/* Generated by wayland-scanner 1.22.0 */

#ifndef OUTPUTMANAGEMENT_SERVER_PROTOCOL_H
#define OUTPUTMANAGEMENT_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_outputmanagement The outputmanagement protocol
 * @section page_ifaces_outputmanagement Interfaces
 * - @subpage page_iface_org_kde_kwin_outputmanagement - configuration of server outputs through clients
 * - @subpage page_iface_org_kde_kwin_outputconfiguration - configure single output devices
 * @section page_copyright_outputmanagement Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2008-2011 Kristian Høgsberg
 * SPDX-FileCopyrightText: 2010-2011 Intel Corporation
 * SPDX-FileCopyrightText: 2012-2013 Collabora, Ltd.
 * SPDX-FileCopyrightText: 2015 Sebastian Kügler <sebas@kde.org>
 *
 * SPDX-License-Identifier: MIT-CMU
 * </pre>
 */
struct org_kde_kwin_outputconfiguration;
struct org_kde_kwin_outputdevice;
struct org_kde_kwin_outputmanagement;

#ifndef ORG_KDE_KWIN_OUTPUTMANAGEMENT_INTERFACE
#define ORG_KDE_KWIN_OUTPUTMANAGEMENT_INTERFACE
/**
 * @page page_iface_org_kde_kwin_outputmanagement org_kde_kwin_outputmanagement
 * @section page_iface_org_kde_kwin_outputmanagement_desc Description
 *
 * This interface enables clients to set properties of output devices for screen
 * configuration purposes via the server. To this end output devices are referenced
 * by global org_kde_kwin_outputdevice objects.
 *
 * outputmanagement (wl_global)
 * --------------------------
 * request:
 * * create_configuration -> outputconfiguration (wl_resource)
 *
 * outputconfiguration (wl_resource)
 * --------------------------
 * requests:
 * * enable(outputdevice, bool)
 * * mode(outputdevice, mode_id)
 * * transformation(outputdevice, flag)
 * * position(outputdevice, x, y)
 * * apply
 *
 * events:
 * * applied
 * * failed
 *
 * The server registers one outputmanagement object as a global object. In order
 * to configure outputs a client requests create_configuration, which provides a
 * resource referencing an outputconfiguration for one-time configuration. That
 * way the server knows which requests belong together and can group them by that.
 *
 * On the outputconfiguration object the client calls for each output whether the
 * output should be enabled, which mode should be set (by referencing the mode from
 * the list of announced modes) and the output's global position. Once all outputs
 * are configured that way, the client calls apply.
 * At that point and not earlier the server should try to apply the configuration.
 * If this succeeds the server emits the applied signal, otherwise the failed
 * signal, such that the configuring client is noticed about the success of its
 * configuration request.
 *
 * Through this design the interface enables atomic output configuration changes if
 * internally supported by the server.
 *
 * @section page_iface_org_kde_kwin_outputmanagement_api API
 * See @ref iface_org_kde_kwin_outputmanagement.
 */
/**
 * @defgroup iface_org_kde_kwin_outputmanagement The org_kde_kwin_outputmanagement interface
 *
 * This interface enables clients to set properties of output devices for screen
 * configuration purposes via the server. To this end output devices are referenced
 * by global org_kde_kwin_outputdevice objects.
 *
 * outputmanagement (wl_global)
 * --------------------------
 * request:
 * * create_configuration -> outputconfiguration (wl_resource)
 *
 * outputconfiguration (wl_resource)
 * --------------------------
 * requests:
 * * enable(outputdevice, bool)
 * * mode(outputdevice, mode_id)
 * * transformation(outputdevice, flag)
 * * position(outputdevice, x, y)
 * * apply
 *
 * events:
 * * applied
 * * failed
 *
 * The server registers one outputmanagement object as a global object. In order
 * to configure outputs a client requests create_configuration, which provides a
 * resource referencing an outputconfiguration for one-time configuration. That
 * way the server knows which requests belong together and can group them by that.
 *
 * On the outputconfiguration object the client calls for each output whether the
 * output should be enabled, which mode should be set (by referencing the mode from
 * the list of announced modes) and the output's global position. Once all outputs
 * are configured that way, the client calls apply.
 * At that point and not earlier the server should try to apply the configuration.
 * If this succeeds the server emits the applied signal, otherwise the failed
 * signal, such that the configuring client is noticed about the success of its
 * configuration request.
 *
 * Through this design the interface enables atomic output configuration changes if
 * internally supported by the server.
 *
 */
extern const struct wl_interface org_kde_kwin_outputmanagement_interface;
#endif
#ifndef ORG_KDE_KWIN_OUTPUTCONFIGURATION_INTERFACE
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_INTERFACE
/**
 * @page page_iface_org_kde_kwin_outputconfiguration org_kde_kwin_outputconfiguration
 * @section page_iface_org_kde_kwin_outputconfiguration_desc Description
 *
 * outputconfiguration is a client-specific resource that can be used to ask
 * the server to apply changes to available output devices.
 *
 * The client receives a list of output devices from the registry. When it wants
 * to apply new settings, it creates a configuration object from the
 * outputmanagement global, writes changes through this object's enable, scale,
 * transform and mode calls. It then asks the server to apply these settings in
 * an atomic fashion, for example through Linux' DRM interface.
 *
 * The server signals back whether the new settings have applied successfully
 * or failed to apply. outputdevice objects are updated after the changes have been
 * applied to the hardware and before the server side sends the applied event.
 * @section page_iface_org_kde_kwin_outputconfiguration_api API
 * See @ref iface_org_kde_kwin_outputconfiguration.
 */
/**
 * @defgroup iface_org_kde_kwin_outputconfiguration The org_kde_kwin_outputconfiguration interface
 *
 * outputconfiguration is a client-specific resource that can be used to ask
 * the server to apply changes to available output devices.
 *
 * The client receives a list of output devices from the registry. When it wants
 * to apply new settings, it creates a configuration object from the
 * outputmanagement global, writes changes through this object's enable, scale,
 * transform and mode calls. It then asks the server to apply these settings in
 * an atomic fashion, for example through Linux' DRM interface.
 *
 * The server signals back whether the new settings have applied successfully
 * or failed to apply. outputdevice objects are updated after the changes have been
 * applied to the hardware and before the server side sends the applied event.
 */
extern const struct wl_interface org_kde_kwin_outputconfiguration_interface;
#endif

/**
 * @ingroup iface_org_kde_kwin_outputmanagement
 * @struct org_kde_kwin_outputmanagement_interface
 */
struct org_kde_kwin_outputmanagement_interface {
	/**
	 * provide outputconfiguration object for configuring outputs
	 *
	 * Request an outputconfiguration object through which the client
	 * can configure output devices.
	 */
	void (*create_configuration)(struct wl_client *client,
				     struct wl_resource *resource,
				     uint32_t id);
};


/**
 * @ingroup iface_org_kde_kwin_outputmanagement
 */
#define ORG_KDE_KWIN_OUTPUTMANAGEMENT_CREATE_CONFIGURATION_SINCE_VERSION 1

#ifndef ORG_KDE_KWIN_OUTPUTCONFIGURATION_VRR_POLICY_ENUM
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_VRR_POLICY_ENUM
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 * describes vrr policy
 *
 * Describes when the compositor may employ variable refresh rate
 */
enum org_kde_kwin_outputconfiguration_vrr_policy {
	ORG_KDE_KWIN_OUTPUTCONFIGURATION_VRR_POLICY_NEVER = 0,
	ORG_KDE_KWIN_OUTPUTCONFIGURATION_VRR_POLICY_ALWAYS = 1,
	ORG_KDE_KWIN_OUTPUTCONFIGURATION_VRR_POLICY_AUTOMATIC = 2,
};
#endif /* ORG_KDE_KWIN_OUTPUTCONFIGURATION_VRR_POLICY_ENUM */

/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 * @struct org_kde_kwin_outputconfiguration_interface
 */
struct org_kde_kwin_outputconfiguration_interface {
	/**
	 * enable or disable an output
	 *
	 * Mark the output as enabled or disabled.
	 * @param outputdevice outputdevice to be en- or disabled
	 * @param enable 1 to enable or 0 to disable this output
	 */
	void (*enable)(struct wl_client *client,
		       struct wl_resource *resource,
		       struct wl_resource *outputdevice,
		       int32_t enable);
	/**
	 * switch outputdevice to mode
	 *
	 * Sets the mode for a given output by its mode size (width and
	 * height) and refresh rate.
	 * @param outputdevice outputdevice this mode change applies to
	 * @param mode_id aspired mode's id
	 */
	void (*mode)(struct wl_client *client,
		     struct wl_resource *resource,
		     struct wl_resource *outputdevice,
		     int32_t mode_id);
	/**
	 * transform outputdevice
	 *
	 * Sets the transformation for a given output.
	 * @param outputdevice outputdevice this transformation change applies to
	 * @param transform transform enum
	 */
	void (*transform)(struct wl_client *client,
			  struct wl_resource *resource,
			  struct wl_resource *outputdevice,
			  int32_t transform);
	/**
	 * position output in global space
	 *
	 * Sets the position for this output device. (x,y) describe the
	 * top-left corner of the output in global space, whereby the
	 * origin (0,0) of the global space has to be aligned with the
	 * top-left corner of the most left and in case this does not
	 * define a single one the top output.
	 *
	 * There may be no gaps or overlaps between outputs, i.e. the
	 * outputs are stacked horizontally, vertically, or both on each
	 * other.
	 * @param outputdevice outputdevice this position applies to
	 * @param x position on the x-axis
	 * @param y position on the y-axis
	 */
	void (*position)(struct wl_client *client,
			 struct wl_resource *resource,
			 struct wl_resource *outputdevice,
			 int32_t x,
			 int32_t y);
	/**
	 * set scaling factor of this output
	 *
	 * Sets the scaling factor for this output device.
	 * @param outputdevice outputdevice this mode change applies to
	 * @param scale scaling factor
	 */
	void (*scale)(struct wl_client *client,
		      struct wl_resource *resource,
		      struct wl_resource *outputdevice,
		      int32_t scale);
	/**
	 * apply configuration changes to all output devices
	 *
	 * Asks the server to apply property changes requested through
	 * this outputconfiguration object to all outputs on the server
	 * side.
	 */
	void (*apply)(struct wl_client *client,
		      struct wl_resource *resource);
	/**
	 * set scaling factor of this output
	 *
	 * Sets the scaling factor for this output device. Sending both
	 * scale and scalef is undefined.
	 * @param outputdevice outputdevice this mode change applies to
	 * @param scale scaling factor
	 * @since 2
	 */
	void (*scalef)(struct wl_client *client,
		       struct wl_resource *resource,
		       struct wl_resource *outputdevice,
		       wl_fixed_t scale);
	/**
	 * set output color curves
	 *
	 * Set color curves of output devices through RGB color ramps.
	 * Allows color correction of output device from user space.
	 *
	 * These are the raw values. A compositor might opt to adjust these
	 * values internally, for example to shift color temperature at
	 * night.
	 * @param outputdevice outputdevice curves apply to
	 * @param red red color ramp
	 * @param green green color ramp
	 * @param blue blue color ramp
	 * @since 2
	 */
	void (*colorcurves)(struct wl_client *client,
			    struct wl_resource *resource,
			    struct wl_resource *outputdevice,
			    struct wl_array *red,
			    struct wl_array *green,
			    struct wl_array *blue);
	/**
	 * release the outputconfiguration object
	 *
	 * 
	 * @since 2
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * set overscan value
	 *
	 * Set the overscan value of this output device with a value in
	 * percent.
	 * @param outputdevice outputdevice overscan applies to
	 * @param overscan overscan value
	 * @since 3
	 */
	void (*overscan)(struct wl_client *client,
			 struct wl_resource *resource,
			 struct wl_resource *outputdevice,
			 uint32_t overscan);
	/**
	 * set the VRR policy
	 *
	 * Set what policy the compositor should employ regarding its use
	 * of variable refresh rate.
	 * @param outputdevice outputdevice this VRR policy applies to
	 * @param policy the vrr policy to apply
	 * @since 4
	 */
	void (*set_vrr_policy)(struct wl_client *client,
			       struct wl_resource *resource,
			       struct wl_resource *outputdevice,
			       uint32_t policy);
};

#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_APPLIED 0
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_FAILED 1

/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_APPLIED_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_FAILED_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_ENABLE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_TRANSFORM_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_SCALE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_APPLY_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_SCALEF_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_COLORCURVES_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_DESTROY_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_OVERSCAN_SINCE_VERSION 3
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_SET_VRR_POLICY_SINCE_VERSION 4

/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 * Sends an applied event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_kwin_outputconfiguration_send_applied(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ORG_KDE_KWIN_OUTPUTCONFIGURATION_APPLIED);
}

/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 * Sends an failed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_kwin_outputconfiguration_send_failed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ORG_KDE_KWIN_OUTPUTCONFIGURATION_FAILED);
}

#ifdef  __cplusplus
}
#endif

#endif
