
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "krecentfilesmenu_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <qaction.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qstyleoption.h>
#include <qurl.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KRecentFilesMenu_Type = nullptr;
static PyTypeObject *Sbk_KRecentFilesMenu_TypeF(void)
{
    return _Sbk_KRecentFilesMenu_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KRecentFilesMenuWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KRecentFilesMenuWrapper::KRecentFilesMenuWrapper(::QWidget * parent) : KRecentFilesMenu(parent)
{
}

KRecentFilesMenuWrapper::KRecentFilesMenuWrapper(const ::QString & title, ::QWidget * parent) : KRecentFilesMenu(title, parent)
{
}

void KRecentFilesMenuWrapper::actionEvent(::QActionEvent * arg__1)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::actionEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KRecentFilesMenu", funcName, gil, pyOverride, arg__1);
}

void KRecentFilesMenuWrapper::changeEvent(::QEvent * arg__1)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::changeEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KRecentFilesMenu", funcName, gil, pyOverride, arg__1);
}

void KRecentFilesMenuWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KRecentFilesMenu", funcName, gil, pyOverride, event);
}

void KRecentFilesMenuWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KRecentFilesMenu", funcName, gil, pyOverride, event);
}

void KRecentFilesMenuWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KRecentFilesMenu", funcName, gil, pyOverride, signal);
}

void KRecentFilesMenuWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KRecentFilesMenu", funcName, gil, pyOverride, event);
}

void KRecentFilesMenuWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KRecentFilesMenu", funcName, gil, pyOverride, event);
}

int KRecentFilesMenuWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KRecentFilesMenu", funcName, gil, pyOverride);
}

void KRecentFilesMenuWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KRecentFilesMenu", funcName, gil, pyOverride, signal);
}

void KRecentFilesMenuWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KRecentFilesMenu", funcName, gil, pyOverride, event);
}

void KRecentFilesMenuWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KRecentFilesMenu", funcName, gil, pyOverride, event);
}

void KRecentFilesMenuWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KRecentFilesMenu", funcName, gil, pyOverride, event);
}

void KRecentFilesMenuWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KRecentFilesMenu", funcName, gil, pyOverride, event);
}

void KRecentFilesMenuWrapper::enterEvent(::QEnterEvent * arg__1)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::enterEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KRecentFilesMenu", funcName, gil, pyOverride, arg__1);
}

bool KRecentFilesMenuWrapper::event(::QEvent * arg__1)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::event(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_event("KRecentFilesMenu", funcName, gil, pyOverride, arg__1);
}

bool KRecentFilesMenuWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KRecentFilesMenu", funcName, gil, pyOverride, watched, event);
}

void KRecentFilesMenuWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KRecentFilesMenu", funcName, gil, pyOverride, event);
}

bool KRecentFilesMenuWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KRecentFilesMenu", funcName, gil, pyOverride, next);
}

void KRecentFilesMenuWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KRecentFilesMenu", funcName, gil, pyOverride, event);
}

bool KRecentFilesMenuWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KRecentFilesMenu", funcName, gil, pyOverride);
}

int KRecentFilesMenuWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KRecentFilesMenu", funcName, gil, pyOverride, arg__1);
}

void KRecentFilesMenuWrapper::hideEvent(::QHideEvent * arg__1)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::hideEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KRecentFilesMenu", funcName, gil, pyOverride, arg__1);
}

void KRecentFilesMenuWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KRecentFilesMenu", funcName, gil, pyOverride, painter);
}

void KRecentFilesMenuWrapper::initStyleOption(::QStyleOptionMenuItem * option, const ::QAction * action) const
{
    static const char *funcName = "initStyleOption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::initStyleOption(option, action);
    }
    sbk_o_initStyleOption("KRecentFilesMenu", funcName, gil, pyOverride, option, action);
}

void KRecentFilesMenuWrapper::sbk_o_initStyleOption(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QStyleOptionMenuItem * option, const ::QAction * action)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QStyleOptionMenuItem_IDX]), option),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), action)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QStyleOptionMenuItem_IDX]), option),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), action)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KRecentFilesMenuWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KRecentFilesMenu", funcName, gil, pyOverride, event);
}

::QVariant KRecentFilesMenuWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KRecentFilesMenu", funcName, gil, pyOverride, arg__1);
}

void KRecentFilesMenuWrapper::keyPressEvent(::QKeyEvent * arg__1)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::keyPressEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KRecentFilesMenu", funcName, gil, pyOverride, arg__1);
}

void KRecentFilesMenuWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KRecentFilesMenu", funcName, gil, pyOverride, event);
}

void KRecentFilesMenuWrapper::leaveEvent(::QEvent * arg__1)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::leaveEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KRecentFilesMenu", funcName, gil, pyOverride, arg__1);
}

int KRecentFilesMenuWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KRecentFilesMenu", funcName, gil, pyOverride, arg__1);
}

::QSize KRecentFilesMenuWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KRecentFilesMenu", funcName, gil, pyOverride);
}

void KRecentFilesMenuWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KRecentFilesMenu", funcName, gil, pyOverride, event);
}

void KRecentFilesMenuWrapper::mouseMoveEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::mouseMoveEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KRecentFilesMenu", funcName, gil, pyOverride, arg__1);
}

void KRecentFilesMenuWrapper::mousePressEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::mousePressEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KRecentFilesMenu", funcName, gil, pyOverride, arg__1);
}

void KRecentFilesMenuWrapper::mouseReleaseEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::mouseReleaseEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KRecentFilesMenu", funcName, gil, pyOverride, arg__1);
}

void KRecentFilesMenuWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KRecentFilesMenu", funcName, gil, pyOverride, event);
}

bool KRecentFilesMenuWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KRecentFilesMenu", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KRecentFilesMenuWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KRecentFilesMenu", funcName, gil, pyOverride);
}

void KRecentFilesMenuWrapper::paintEvent(::QPaintEvent * arg__1)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::paintEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KRecentFilesMenu", funcName, gil, pyOverride, arg__1);
}

::QPaintDevice * KRecentFilesMenuWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KRecentFilesMenu", funcName, gil, pyOverride, offset);
}

void KRecentFilesMenuWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KRecentFilesMenu", funcName, gil, pyOverride, event);
}

void KRecentFilesMenuWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KRecentFilesMenu", funcName, gil, pyOverride, visible);
}

::QPainter * KRecentFilesMenuWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KRecentFilesMenu", funcName, gil, pyOverride);
}

void KRecentFilesMenuWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KRecentFilesMenu", funcName, gil, pyOverride, event);
}

::QSize KRecentFilesMenuWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KRecentFilesMenu", funcName, gil, pyOverride);
}

void KRecentFilesMenuWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KRecentFilesMenu", funcName, gil, pyOverride, event);
}

void KRecentFilesMenuWrapper::timerEvent(::QTimerEvent * arg__1)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::timerEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KRecentFilesMenu", funcName, gil, pyOverride, arg__1);
}

void KRecentFilesMenuWrapper::wheelEvent(::QWheelEvent * arg__1)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KRecentFilesMenu_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::wheelEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KRecentFilesMenu", funcName, gil, pyOverride, arg__1);
}

const QMetaObject *KRecentFilesMenuWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KRecentFilesMenu::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KRecentFilesMenuWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KRecentFilesMenu::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KRecentFilesMenuWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KRecentFilesMenuWrapper *>(this));
    }
    return KRecentFilesMenu::qt_metacast(_clname);
}

KRecentFilesMenuWrapper::~KRecentFilesMenuWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KRecentFilesMenu_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KRecentFilesMenu_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KRecentFilesMenu >()))
        return -1;

    KRecentFilesMenuWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:KRecentFilesMenu", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KRecentFilesMenu::KRecentFilesMenu(QWidget*=)
    // 1: KRecentFilesMenu::KRecentFilesMenu(QString,QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KRecentFilesMenu(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KRecentFilesMenu(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // KRecentFilesMenu(QString,QWidget*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
            overloadId = 1; // KRecentFilesMenu(QString,QWidget*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KRecentFilesMenu(QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0 = nullptr;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KRecentFilesMenu(QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KRecentFilesMenuWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KRecentFilesMenuWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // KRecentFilesMenu(const QString &title, QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QWidget *cppArg1 = nullptr;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KRecentFilesMenu(QString,QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KRecentFilesMenuWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KRecentFilesMenuWrapper(cppArg0, cppArg1);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KRecentFilesMenu >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KRecentFilesMenuFunc_addUrl(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRecentFilesMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "addUrl", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX]);

    if (PyArg_ParseTuple(args, "|OO:addUrl", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KRecentFilesMenu::addUrl(QUrl,const QString&=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addUrl(QUrl,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 0; // addUrl(QUrl,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addUrl", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"name", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "addUrl", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1 = QString();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addUrl(QUrl,QString)
            cppSelf->addUrl(*cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRecentFilesMenuFunc_clearRecentFiles(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRecentFilesMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clearRecentFiles()
        cppSelf->clearRecentFiles();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRecentFilesMenuFunc_group(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRecentFilesMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // group()const
        QString cppResult = const_cast<const ::KRecentFilesMenu *>(cppSelf)->group();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRecentFilesMenuFunc_maximumItems(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRecentFilesMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // maximumItems()const
        int cppResult = const_cast<const ::KRecentFilesMenu *>(cppSelf)->maximumItems();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRecentFilesMenuFunc_recentFiles(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRecentFilesMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // recentFiles()const
        QList<QUrl> cppResult = const_cast<const ::KRecentFilesMenu *>(cppSelf)->recentFiles();
        pyResult = Shiboken::Conversions::copyToPython(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QUrl_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRecentFilesMenuFunc_removeUrl(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRecentFilesMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRecentFilesMenu::removeUrl(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // removeUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeUrl", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // removeUrl(QUrl)
            cppSelf->removeUrl(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRecentFilesMenuFunc_setGroup(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRecentFilesMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRecentFilesMenu::setGroup(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setGroup(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setGroup", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setGroup(QString)
            cppSelf->setGroup(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRecentFilesMenuFunc_setMaximumItems(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRecentFilesMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRecentFilesMenu::setMaximumItems(size_t)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<size_t>(), (pyArg)))) {
        overloadId = 0; // setMaximumItems(size_t)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMaximumItems", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX]);

    // Call function/method
    {
        size_t cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMaximumItems(size_t)
            cppSelf->setMaximumItems(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KRecentFilesMenu_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KRecentFilesMenu_methods[] = {
    {"addUrl", reinterpret_cast<PyCFunction>(Sbk_KRecentFilesMenuFunc_addUrl), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"clearRecentFiles", reinterpret_cast<PyCFunction>(Sbk_KRecentFilesMenuFunc_clearRecentFiles), METH_NOARGS, nullptr},
    {"group", reinterpret_cast<PyCFunction>(Sbk_KRecentFilesMenuFunc_group), METH_NOARGS, nullptr},
    {"maximumItems", reinterpret_cast<PyCFunction>(Sbk_KRecentFilesMenuFunc_maximumItems), METH_NOARGS, nullptr},
    {"recentFiles", reinterpret_cast<PyCFunction>(Sbk_KRecentFilesMenuFunc_recentFiles), METH_NOARGS, nullptr},
    {"removeUrl", reinterpret_cast<PyCFunction>(Sbk_KRecentFilesMenuFunc_removeUrl), METH_O, nullptr},
    {"setGroup", reinterpret_cast<PyCFunction>(Sbk_KRecentFilesMenuFunc_setGroup), METH_O, nullptr},
    {"setMaximumItems", reinterpret_cast<PyCFunction>(Sbk_KRecentFilesMenuFunc_setMaximumItems), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KRecentFilesMenu_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KRecentFilesMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KRecentFilesMenuWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KRecentFilesMenu_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KRecentFilesMenu_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KRecentFilesMenuSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KRecentFilesMenu *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]))
        return static_cast< ::QMenu *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KRecentFilesMenu_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KRecentFilesMenu_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KRecentFilesMenu_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KRecentFilesMenu_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KRecentFilesMenu_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KRecentFilesMenu_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KRecentFilesMenu_spec = {
    "1:KWidgetsAddons.KRecentFilesMenu",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KRecentFilesMenu_slots
};

} //extern "C"

static void *Sbk_KRecentFilesMenu_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KRecentFilesMenu *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KRecentFilesMenu *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KRecentFilesMenu *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KRecentFilesMenu_PythonToCpp_KRecentFilesMenu_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KRecentFilesMenu_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KRecentFilesMenu_PythonToCpp_KRecentFilesMenu_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KRecentFilesMenu_TypeF()))
        return KRecentFilesMenu_PythonToCpp_KRecentFilesMenu_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KRecentFilesMenu_PTR_CppToPython_KRecentFilesMenu(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KRecentFilesMenu *>(const_cast<void *>(cppIn)), Sbk_KRecentFilesMenu_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KRecentFilesMenu_SignatureStrings[] = {
    "1:KWidgetsAddons.KRecentFilesMenu(self,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "0:KWidgetsAddons.KRecentFilesMenu(self,title:QString,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "KWidgetsAddons.KRecentFilesMenu.addUrl(self,url:typing.Union[PySide6.QtCore.QUrl, QString],name:QString=QString())",
    "KWidgetsAddons.KRecentFilesMenu.clearRecentFiles(self)",
    "KWidgetsAddons.KRecentFilesMenu.group(self)->QString",
    "KWidgetsAddons.KRecentFilesMenu.maximumItems(self)->int",
    "KWidgetsAddons.KRecentFilesMenu.recentFiles(self)->QList[PySide6.QtCore.QUrl]",
    "KWidgetsAddons.KRecentFilesMenu.removeUrl(self,url:typing.Union[PySide6.QtCore.QUrl, QString])",
    "KWidgetsAddons.KRecentFilesMenu.setGroup(self,group:QString)",
    "KWidgetsAddons.KRecentFilesMenu.setMaximumItems(self,maximumItems:size_t)",
    nullptr}; // Sentinel
#else
static constexpr size_t KRecentFilesMenu_SignatureByteSize = 239;
static constexpr uint8_t KRecentFilesMenu_SignatureBytes[239] = {
    0x78, 0xda, 0x9d, 0x91, 0x4d, 0x4b, 0x03, 0x31, 0x10, 0x86, 0xef, 0xfd, 0x15, 0x1e, 0xbb, 0x10,
    0x83, 0x5e, 0x3c, 0x04, 0x2a, 0x88, 0xa0, 0x48, 0x2d, 0xb8, 0x96, 0xe2, 0x41, 0x8a, 0x84, 0x66,
    0x5c, 0x06, 0x92, 0xc9, 0x32, 0x99, 0x88, 0xf5, 0xd7, 0xbb, 0x74, 0xb7, 0xb5, 0x14, 0x21, 0xab,
    0xa7, 0x84, 0x61, 0xde, 0x0f, 0x9e, 0xb9, 0x34, 0xf3, 0x17, 0x74, 0x0d, 0x48, 0xba, 0x71, 0x2e,
    0x52, 0xd2, 0xf3, 0x67, 0xd8, 0x00, 0xc9, 0x1d, 0x7a, 0x48, 0x0b, 0xa0, 0x3c, 0x4d, 0xe0, 0xdf,
    0x55, 0x6b, 0xb9, 0x1b, 0x9a, 0xa7, 0xed, 0x12, 0x1d, 0x5c, 0xe9, 0x5a, 0x06, 0x91, 0xae, 0xfb,
    0xcf, 0x8c, 0xb2, 0xf7, 0xad, 0x70, 0x35, 0xb9, 0x18, 0x67, 0x28, 0x28, 0x1e, 0x4c, 0xbd, 0x14,
    0x46, 0x6a, 0xfe, 0x60, 0x5f, 0x30, 0xd7, 0xd6, 0xb9, 0x15, 0xfb, 0x3e, 0x23, 0xb3, 0x37, 0xb2,
    0x6d, 0xbb, 0x00, 0xbd, 0x22, 0x8c, 0xf4, 0xfa, 0xe3, 0x7f, 0x1b, 0x19, 0x74, 0xdd, 0x6d, 0xaa,
    0xb3, 0xa1, 0xc3, 0x5a, 0x91, 0x0d, 0x87, 0x46, 0xb3, 0xe1, 0x9d, 0x56, 0xe5, 0xc8, 0x8d, 0x07,
    0xcb, 0x47, 0xc3, 0x5d, 0x78, 0x59, 0xd6, 0x70, 0xcc, 0x6d, 0xbf, 0x7b, 0x7e, 0x3d, 0xc4, 0x15,
    0x45, 0xc1, 0x7e, 0x62, 0xc8, 0xe1, 0x41, 0x20, 0xa4, 0xbd, 0x16, 0x49, 0x8a, 0x3a, 0x3e, 0xad,
    0xd7, 0x45, 0x3e, 0x62, 0x92, 0xdf, 0x90, 0xac, 0x47, 0xb8, 0x85, 0xf8, 0x01, 0xff, 0xe4, 0x5c,
    0x26, 0x93, 0x40, 0xee, 0x0f, 0x70, 0xd4, 0x8e, 0xd3, 0xfe, 0x2e, 0xa3, 0xc4, 0x8b, 0x53, 0x48,
    0xea, 0x18, 0x9b, 0x49, 0xf8, 0x05, 0x6f, 0x52, 0x4d, 0xbe, 0x01, 0x92, 0x48, 0x19, 0x26
};
#endif

PyTypeObject *init_KRecentFilesMenu(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX].type;

    Shiboken::AutoDecRef Sbk_KRecentFilesMenu_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]))));

    _Sbk_KRecentFilesMenu_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KRecentFilesMenu",
        "KRecentFilesMenu*",
        &Sbk_KRecentFilesMenu_spec,
        &Shiboken::callCppDestructor< KRecentFilesMenu >,
        Sbk_KRecentFilesMenu_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_KRecentFilesMenu_TypeF(); // references _Sbk_KRecentFilesMenu_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KRecentFilesMenu_SignatureStrings);
#else
    InitSignatureBytes(pyType, KRecentFilesMenu_SignatureBytes, KRecentFilesMenu_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KRecentFilesMenu_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KRecentFilesMenu_PythonToCpp_KRecentFilesMenu_PTR,
        is_KRecentFilesMenu_PythonToCpp_KRecentFilesMenu_PTR_Convertible,
        KRecentFilesMenu_PTR_CppToPython_KRecentFilesMenu);

    Shiboken::Conversions::registerConverterName(converter, "KRecentFilesMenu");
    Shiboken::Conversions::registerConverterName(converter, "KRecentFilesMenu*");
    Shiboken::Conversions::registerConverterName(converter, "KRecentFilesMenu&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KRecentFilesMenu).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KRecentFilesMenuWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KRecentFilesMenu_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KRecentFilesMenu_TypeF(), &Sbk_KRecentFilesMenuSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KRecentFilesMenu_TypeF(), &Sbk_KRecentFilesMenu_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::KRecentFilesMenu::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KRecentFilesMenu::staticMetaObject, sizeof(KRecentFilesMenuWrapper));

    return pyType;
}
