/* action.c generated by valac 0.56.18, the Vala compiler
 * generated from action.vala, do not modify */

/*      action.vala*/
/*      */
/*      Copyright 2011 Hong Jen Yee (PCMan) <pcman.tw@pcman.tw@gmail.com>*/
/*      */
/*      This program is free software; you can redistribute it and/or modify*/
/*      it under the terms of the GNU General Public License as published by*/
/*      the Free Software Foundation; either version 2 of the License, or*/
/*      (at your option) any later version.*/
/*      */
/*      This program is distributed in the hope that it will be useful,*/
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*      GNU General Public License for more details.*/
/*      */
/*      You should have received a copy of the GNU General Public License*/
/*      along with this program; if not, write to the Free Software*/
/*      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,*/
/*      MA 02110-1301, USA.*/
/*      */
/*      */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "fm-actions.h"
#include <glib-object.h>
#include <fm-file-info.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FM_FILE_ACTION_OBJECT_0_PROPERTY,
	FM_FILE_ACTION_OBJECT_NUM_PROPERTIES
};
static GParamSpec* fm_file_action_object_properties[FM_FILE_ACTION_OBJECT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _fm_file_action_condition_free0(var) ((var == NULL) ? NULL : (var = (fm_file_action_condition_free (var), NULL)))
enum  {
	FM_FILE_ACTION_0_PROPERTY,
	FM_FILE_ACTION_NUM_PROPERTIES
};
static GParamSpec* fm_file_action_properties[FM_FILE_ACTION_NUM_PROPERTIES];
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
enum  {
	FM_FILE_ACTION_MENU_0_PROPERTY,
	FM_FILE_ACTION_MENU_NUM_PROPERTIES
};
static GParamSpec* fm_file_action_menu_properties[FM_FILE_ACTION_MENU_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _fm_file_action_item_unref0(var) ((var == NULL) ? NULL : (var = (fm_file_action_item_unref (var), NULL)))
typedef struct _FmParamSpecFileActionItem FmParamSpecFileActionItem;
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _FmParamSpecFileActionItem {
	GParamSpec parent_instance;
};

VALA_EXTERN gchar* fm_desktop_env;
gchar* fm_desktop_env = NULL;
VALA_EXTERN gboolean fm_actions_loaded;
gboolean fm_actions_loaded = FALSE;
VALA_EXTERN GHashTable* fm_all_actions;
GHashTable* fm_all_actions = NULL;
static gpointer fm_file_action_object_parent_class = NULL;
static gpointer fm_file_action_parent_class = NULL;
static gpointer fm_file_action_menu_parent_class = NULL;
static gpointer fm_file_action_item_parent_class = NULL;

VALA_EXTERN gchar* utils_key_file_get_locale_string (GKeyFile* kf,
                                         const gchar* group,
                                         const gchar* key,
                                         const gchar* def_val);
VALA_EXTERN gboolean utils_key_file_get_bool (GKeyFile* kf,
                                  const gchar* group,
                                  const gchar* key,
                                  gboolean def_val);
VALA_EXTERN gchar* utils_key_file_get_string (GKeyFile* kf,
                                  const gchar* group,
                                  const gchar* key,
                                  const gchar* def_val);
static void fm_file_action_object_finalize (GObject * obj);
static GType fm_file_action_object_get_type_once (void);
static void _fm_file_action_profile_free0_ (gpointer var);
static inline void _g_list_free__fm_file_action_profile_free0_ (GList* self);
VALA_EXTERN gchar** utils_key_file_get_string_list (GKeyFile* kf,
                                        const gchar* group,
                                        const gchar* key,
                                        gchar** def_val,
                                        gint def_val_length1,
                                        gint* result_length1);
static void fm_file_action_finalize (GObject * obj);
static GType fm_file_action_get_type_once (void);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void fm_file_action_menu_finalize (GObject * obj);
static GType fm_file_action_menu_get_type_once (void);
static void _fm_file_action_item_unref0_ (gpointer var);
static inline void _g_list_free__fm_file_action_item_unref0_ (GList* self);
static FmFileActionItem* fm_file_action_item_new (FmFileActionObject* action,
                                           GList* files);
static FmFileActionItem* fm_file_action_item_construct (GType object_type,
                                                 FmFileActionObject* action,
                                                 GList* files);
static void fm_file_action_item_finalize (FmFileActionItem * obj);
static GType fm_file_action_item_get_type_once (void);
VALA_EXTERN void fm_load_actions_from_dir (const gchar* dirname,
                               const gchar* id_prefix);
VALA_EXTERN void fm_load_all_actions (void);
static void _g_free0_ (gpointer var);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static GType
fm_file_action_type_get_type_once (void)
{
	static const GEnumValue values[] = {{FM_FILE_ACTION_TYPE_NONE, "FM_FILE_ACTION_TYPE_NONE", "none"}, {FM_FILE_ACTION_TYPE_ACTION, "FM_FILE_ACTION_TYPE_ACTION", "action"}, {FM_FILE_ACTION_TYPE_MENU, "FM_FILE_ACTION_TYPE_MENU", "menu"}, {0, NULL, NULL}};
	GType fm_file_action_type_type_id;
	fm_file_action_type_type_id = g_enum_register_static ("FmFileActionType", values);
	return fm_file_action_type_type_id;
}

GType
fm_file_action_type_get_type (void)
{
	static volatile gsize fm_file_action_type_type_id__once = 0;
	if (g_once_init_enter (&fm_file_action_type_type_id__once)) {
		GType fm_file_action_type_type_id;
		fm_file_action_type_type_id = fm_file_action_type_get_type_once ();
		g_once_init_leave (&fm_file_action_type_type_id__once, fm_file_action_type_type_id);
	}
	return fm_file_action_type_type_id__once;
}

FmFileActionObject*
fm_file_action_object_construct (GType object_type)
{
	FmFileActionObject * self = NULL;
	self = (FmFileActionObject*) g_object_new (object_type, NULL);
	return self;
}

FmFileActionObject*
fm_file_action_object_new (void)
{
	return fm_file_action_object_construct (FM_TYPE_FILE_ACTION_OBJECT);
}

FmFileActionObject*
fm_file_action_object_construct_from_key_file (GType object_type,
                                               GKeyFile* kf)
{
	FmFileActionObject * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	FmFileActionCondition* _tmp5_;
	g_return_val_if_fail (kf != NULL, NULL);
	self = (FmFileActionObject*) g_object_new (object_type, NULL);
	_tmp0_ = utils_key_file_get_locale_string (kf, "Desktop Entry", "Name", NULL);
	_g_free0 (self->name);
	self->name = _tmp0_;
	_tmp1_ = utils_key_file_get_locale_string (kf, "Desktop Entry", "Tooltip", NULL);
	_g_free0 (self->tooltip);
	self->tooltip = _tmp1_;
	_tmp2_ = utils_key_file_get_locale_string (kf, "Desktop Entry", "Icon", NULL);
	_g_free0 (self->icon);
	self->icon = _tmp2_;
	_tmp3_ = utils_key_file_get_locale_string (kf, "Desktop Entry", "Description", NULL);
	_g_free0 (self->desc);
	self->desc = _tmp3_;
	self->enabled = utils_key_file_get_bool (kf, "Desktop Entry", "Enabled", TRUE);
	self->hidden = utils_key_file_get_bool (kf, "Desktop Entry", "Hidden", FALSE);
	_tmp4_ = utils_key_file_get_string (kf, "Desktop Entry", "SuggestedShortcut", NULL);
	_g_free0 (self->suggested_shortcut);
	self->suggested_shortcut = _tmp4_;
	_tmp5_ = fm_file_action_condition_new (kf, "Desktop Entry");
	_fm_file_action_condition_free0 (self->condition);
	self->condition = _tmp5_;
	return self;
}

FmFileActionObject*
fm_file_action_object_new_from_key_file (GKeyFile* kf)
{
	return fm_file_action_object_construct_from_key_file (FM_TYPE_FILE_ACTION_OBJECT, kf);
}

static void
fm_file_action_object_class_init (FmFileActionObjectClass * klass,
                                  gpointer klass_data)
{
	fm_file_action_object_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = fm_file_action_object_finalize;
}

static void
fm_file_action_object_instance_init (FmFileActionObject * self,
                                     gpointer klass)
{
}

static void
fm_file_action_object_finalize (GObject * obj)
{
	FmFileActionObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FM_TYPE_FILE_ACTION_OBJECT, FmFileActionObject);
	_g_free0 (self->id);
	_g_free0 (self->name);
	_g_free0 (self->tooltip);
	_g_free0 (self->icon);
	_g_free0 (self->desc);
	_g_free0 (self->suggested_shortcut);
	_fm_file_action_condition_free0 (self->condition);
	G_OBJECT_CLASS (fm_file_action_object_parent_class)->finalize (obj);
}

static GType
fm_file_action_object_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FmFileActionObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fm_file_action_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FmFileActionObject), 0, (GInstanceInitFunc) fm_file_action_object_instance_init, NULL };
	GType fm_file_action_object_type_id;
	fm_file_action_object_type_id = g_type_register_static (G_TYPE_OBJECT, "FmFileActionObject", &g_define_type_info, 0);
	return fm_file_action_object_type_id;
}

GType
fm_file_action_object_get_type (void)
{
	static volatile gsize fm_file_action_object_type_id__once = 0;
	if (g_once_init_enter (&fm_file_action_object_type_id__once)) {
		GType fm_file_action_object_type_id;
		fm_file_action_object_type_id = fm_file_action_object_get_type_once ();
		g_once_init_leave (&fm_file_action_object_type_id__once, fm_file_action_object_type_id);
	}
	return fm_file_action_object_type_id__once;
}

static GType
fm_file_action_target_get_type_once (void)
{
	static const GEnumValue values[] = {{FM_FILE_ACTION_TARGET_NONE, "FM_FILE_ACTION_TARGET_NONE", "none"}, {FM_FILE_ACTION_TARGET_CONTEXT, "FM_FILE_ACTION_TARGET_CONTEXT", "context"}, {FM_FILE_ACTION_TARGET_LOCATION, "FM_FILE_ACTION_TARGET_LOCATION", "location"}, {FM_FILE_ACTION_TARGET_TOOLBAR, "FM_FILE_ACTION_TARGET_TOOLBAR", "toolbar"}, {0, NULL, NULL}};
	GType fm_file_action_target_type_id;
	fm_file_action_target_type_id = g_enum_register_static ("FmFileActionTarget", values);
	return fm_file_action_target_type_id;
}

GType
fm_file_action_target_get_type (void)
{
	static volatile gsize fm_file_action_target_type_id__once = 0;
	if (g_once_init_enter (&fm_file_action_target_type_id__once)) {
		GType fm_file_action_target_type_id;
		fm_file_action_target_type_id = fm_file_action_target_get_type_once ();
		g_once_init_leave (&fm_file_action_target_type_id__once, fm_file_action_target_type_id);
	}
	return fm_file_action_target_type_id__once;
}

static void
_fm_file_action_profile_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (fm_file_action_profile_free (var), NULL));
}

static inline void
_g_list_free__fm_file_action_profile_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _fm_file_action_profile_free0_);
}

FmFileAction*
fm_file_action_construct (GType object_type,
                          const gchar* desktop_id)
{
	FmFileAction * self = NULL;
	GKeyFile* kf = NULL;
	GKeyFile* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (desktop_id != NULL, NULL);
	_tmp0_ = g_key_file_new ();
	kf = _tmp0_;
	_tmp1_ = g_strdup (desktop_id);
	_g_free0 (((FmFileActionObject*) self)->id);
	((FmFileActionObject*) self)->id = _tmp1_;
	{
		GKeyFile* _tmp2_;
		GKeyFile* _tmp3_;
		_tmp2_ = kf;
		g_key_file_load_from_file (_tmp2_, desktop_id, 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_key_file_unref0 (kf);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp3_ = kf;
		self = (FmFileAction*) fm_file_action_construct_from_keyfile (object_type, _tmp3_);
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		g_clear_error (&_inner_error0_);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (kf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_g_key_file_unref0 (kf);
	return self;
}

FmFileAction*
fm_file_action_new (const gchar* desktop_id)
{
	return fm_file_action_construct (FM_TYPE_FILE_ACTION, desktop_id);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

FmFileAction*
fm_file_action_construct_from_keyfile (GType object_type,
                                       GKeyFile* kf)
{
	FmFileAction * self = NULL;
	gchar* _tmp0_;
	gchar** profile_names = NULL;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	gint profile_names_length1;
	gint _profile_names_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (kf != NULL, NULL);
	self = (FmFileAction*) fm_file_action_object_construct_from_key_file (object_type, kf);
	((FmFileActionObject*) self)->type = FM_FILE_ACTION_TYPE_ACTION;
	if (utils_key_file_get_bool (kf, "Desktop Entry", "TargetContext", TRUE)) {
		self->target = self->target | FM_FILE_ACTION_TARGET_CONTEXT;
	}
	if (utils_key_file_get_bool (kf, "Desktop Entry", "TargetLocation", FALSE)) {
		self->target = self->target | FM_FILE_ACTION_TARGET_LOCATION;
	}
	if (utils_key_file_get_bool (kf, "Desktop Entry", "TargetToolbar", FALSE)) {
		self->target = self->target | FM_FILE_ACTION_TARGET_TOOLBAR;
	}
	_tmp0_ = utils_key_file_get_locale_string (kf, "Desktop Entry", "ToolbarLabel", NULL);
	_g_free0 (self->toolbar_label);
	self->toolbar_label = _tmp0_;
	_tmp2_ = utils_key_file_get_string_list (kf, "Desktop Entry", "Profiles", NULL, (gint) 0, &_tmp1_);
	profile_names = _tmp2_;
	profile_names_length1 = _tmp1_;
	_profile_names_size_ = profile_names_length1;
	_tmp3_ = profile_names;
	_tmp3__length1 = profile_names_length1;
	if (_tmp3_ != NULL) {
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = profile_names;
		_tmp4__length1 = profile_names_length1;
		{
			gchar** profile_name_collection = NULL;
			gint profile_name_collection_length1 = 0;
			gint _profile_name_collection_size_ = 0;
			gint profile_name_it = 0;
			profile_name_collection = _tmp4_;
			profile_name_collection_length1 = _tmp4__length1;
			for (profile_name_it = 0; profile_name_it < profile_name_collection_length1; profile_name_it = profile_name_it + 1) {
				gchar* _tmp5_;
				gchar* profile_name = NULL;
				_tmp5_ = g_strdup (profile_name_collection[profile_name_it]);
				profile_name = _tmp5_;
				{
					const gchar* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					FmFileActionProfile* _tmp9_;
					_tmp6_ = profile_name;
					_tmp7_ = string_strip (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = fm_file_action_profile_new (kf, _tmp8_);
					self->profiles = g_list_prepend (self->profiles, _tmp9_);
					_g_free0 (_tmp8_);
					_g_free0 (profile_name);
				}
			}
		}
		self->profiles = g_list_reverse (self->profiles);
	}
	profile_names = (_vala_array_free (profile_names, profile_names_length1, (GDestroyNotify) g_free), NULL);
	return self;
}

FmFileAction*
fm_file_action_new_from_keyfile (GKeyFile* kf)
{
	return fm_file_action_construct_from_keyfile (FM_TYPE_FILE_ACTION, kf);
}

gboolean
fm_file_action_match (FmFileAction* self,
                      GList* files,
                      FmFileActionProfile** matched_profile)
{
	FmFileActionProfile* _vala_matched_profile = NULL;
	gboolean _tmp0_ = FALSE;
	FmFileActionCondition* _tmp1_;
	GList* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_matched_profile = NULL;
	if (((FmFileActionObject*) self)->hidden) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !((FmFileActionObject*) self)->enabled;
	}
	if (_tmp0_) {
		result = FALSE;
		if (matched_profile) {
			*matched_profile = _vala_matched_profile;
		}
		return result;
	}
	_tmp1_ = ((FmFileActionObject*) self)->condition;
	if (!fm_file_action_condition_match (_tmp1_, files)) {
		result = FALSE;
		if (matched_profile) {
			*matched_profile = _vala_matched_profile;
		}
		return result;
	}
	_tmp2_ = self->profiles;
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
		profile_collection = _tmp2_;
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
			FmFileActionProfile* profile = NULL;
			profile = (FmFileActionProfile*) profile_it->data;
			{
				FmFileActionProfile* _tmp3_;
				_tmp3_ = profile;
				if (fm_file_action_profile_match (_tmp3_, files)) {
					FmFileActionProfile* _tmp4_;
					_tmp4_ = profile;
					_vala_matched_profile = _tmp4_;
					result = TRUE;
					if (matched_profile) {
						*matched_profile = _vala_matched_profile;
					}
					return result;
				}
			}
		}
	}
	result = FALSE;
	if (matched_profile) {
		*matched_profile = _vala_matched_profile;
	}
	return result;
}

static void
fm_file_action_class_init (FmFileActionClass * klass,
                           gpointer klass_data)
{
	fm_file_action_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = fm_file_action_finalize;
}

static void
fm_file_action_instance_init (FmFileAction * self,
                              gpointer klass)
{
}

static void
fm_file_action_finalize (GObject * obj)
{
	FmFileAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FM_TYPE_FILE_ACTION, FmFileAction);
	_g_free0 (self->toolbar_label);
	(self->profiles == NULL) ? NULL : (self->profiles = (_g_list_free__fm_file_action_profile_free0_ (self->profiles), NULL));
	G_OBJECT_CLASS (fm_file_action_parent_class)->finalize (obj);
}

static GType
fm_file_action_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FmFileActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fm_file_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FmFileAction), 0, (GInstanceInitFunc) fm_file_action_instance_init, NULL };
	GType fm_file_action_type_id;
	fm_file_action_type_id = g_type_register_static (FM_TYPE_FILE_ACTION_OBJECT, "FmFileAction", &g_define_type_info, 0);
	return fm_file_action_type_id;
}

GType
fm_file_action_get_type (void)
{
	static volatile gsize fm_file_action_type_id__once = 0;
	if (g_once_init_enter (&fm_file_action_type_id__once)) {
		GType fm_file_action_type_id;
		fm_file_action_type_id = fm_file_action_get_type_once ();
		g_once_init_leave (&fm_file_action_type_id__once, fm_file_action_type_id);
	}
	return fm_file_action_type_id__once;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

FmFileActionMenu*
fm_file_action_menu_construct (GType object_type,
                               const gchar* desktop_id)
{
	FmFileActionMenu * self = NULL;
	GKeyFile* kf = NULL;
	GKeyFile* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (desktop_id != NULL, NULL);
	_tmp0_ = g_key_file_new ();
	kf = _tmp0_;
	_tmp1_ = g_strdup (desktop_id);
	_g_free0 (((FmFileActionObject*) self)->id);
	((FmFileActionObject*) self)->id = _tmp1_;
	{
		GKeyFile* _tmp2_;
		GKeyFile* _tmp3_;
		_tmp2_ = kf;
		g_key_file_load_from_file (_tmp2_, desktop_id, 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_key_file_unref0 (kf);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp3_ = kf;
		self = (FmFileActionMenu*) fm_file_action_menu_construct_from_keyfile (object_type, _tmp3_);
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		g_clear_error (&_inner_error0_);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (kf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_g_key_file_unref0 (kf);
	return self;
}

FmFileActionMenu*
fm_file_action_menu_new (const gchar* desktop_id)
{
	return fm_file_action_menu_construct (FM_TYPE_FILE_ACTION_MENU, desktop_id);
}

FmFileActionMenu*
fm_file_action_menu_construct_from_keyfile (GType object_type,
                                            GKeyFile* kf)
{
	FmFileActionMenu * self = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	g_return_val_if_fail (kf != NULL, NULL);
	self = (FmFileActionMenu*) fm_file_action_object_construct_from_key_file (object_type, kf);
	((FmFileActionObject*) self)->type = FM_FILE_ACTION_TYPE_MENU;
	_tmp1_ = utils_key_file_get_string_list (kf, "Desktop Entry", "ItemsList", NULL, (gint) 0, &_tmp0_);
	self->items_list = (_vala_array_free (self->items_list, self->items_list_length1, (GDestroyNotify) g_free), NULL);
	self->items_list = _tmp1_;
	self->items_list_length1 = _tmp0_;
	return self;
}

FmFileActionMenu*
fm_file_action_menu_new_from_keyfile (GKeyFile* kf)
{
	return fm_file_action_menu_construct_from_keyfile (FM_TYPE_FILE_ACTION_MENU, kf);
}

gboolean
fm_file_action_menu_match (FmFileActionMenu* self,
                           GList* files)
{
	gboolean _tmp0_ = FALSE;
	FmFileActionCondition* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (((FmFileActionObject*) self)->hidden) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !((FmFileActionObject*) self)->enabled;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = ((FmFileActionObject*) self)->condition;
	if (!fm_file_action_condition_match (_tmp1_, files)) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
fm_file_action_menu_cache_children (FmFileActionMenu* self,
                                    GList* files,
                                    gchar** items_list,
                                    gint items_list_length1)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar** item_id_prefix_collection = NULL;
		gint item_id_prefix_collection_length1 = 0;
		gint _item_id_prefix_collection_size_ = 0;
		gint item_id_prefix_it = 0;
		item_id_prefix_collection = items_list;
		item_id_prefix_collection_length1 = items_list_length1;
		for (item_id_prefix_it = 0; item_id_prefix_it < item_id_prefix_collection_length1; item_id_prefix_it = item_id_prefix_it + 1) {
			const gchar* item_id_prefix = NULL;
			item_id_prefix = item_id_prefix_collection[item_id_prefix_it];
			{
				gboolean _tmp0_ = FALSE;
				const gchar* _tmp1_;
				_tmp1_ = item_id_prefix;
				if (string_get (_tmp1_, (glong) 0) == '[') {
					const gchar* _tmp2_;
					const gchar* _tmp3_;
					gint _tmp4_;
					gint _tmp5_;
					_tmp2_ = item_id_prefix;
					_tmp3_ = item_id_prefix;
					_tmp4_ = strlen (_tmp3_);
					_tmp5_ = _tmp4_;
					_tmp0_ = string_get (_tmp2_, (glong) (_tmp5_ - 1)) == ']';
				} else {
					_tmp0_ = FALSE;
				}
				if (_tmp0_) {
					gchar* output = NULL;
					gint exit_status = 0;
					gchar* command = NULL;
					const gchar* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					gboolean _tmp11_ = FALSE;
					gboolean _tmp12_ = FALSE;
					const gchar* _tmp13_;
					gchar* _tmp14_ = NULL;
					gint _tmp15_ = 0;
					gboolean _tmp16_;
					_tmp6_ = item_id_prefix;
					_tmp7_ = string_slice (_tmp6_, (glong) 1, (glong) -1);
					_tmp8_ = _tmp7_;
					_tmp9_ = fm_file_action_parameters_expand (_tmp8_, files, FALSE, NULL);
					_tmp10_ = _tmp9_;
					_g_free0 (_tmp8_);
					command = _tmp10_;
					_tmp13_ = command;
					_tmp16_ = g_spawn_command_line_sync (_tmp13_, &_tmp14_, NULL, &_tmp15_, &_inner_error0_);
					_g_free0 (output);
					output = _tmp14_;
					exit_status = _tmp15_;
					_tmp12_ = _tmp16_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (command);
						_g_free0 (output);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					if (_tmp12_) {
						_tmp11_ = exit_status == 0;
					} else {
						_tmp11_ = FALSE;
					}
					if (_tmp11_) {
						gchar** item_ids = NULL;
						const gchar* _tmp17_;
						gchar** _tmp18_;
						gchar** _tmp19_;
						gint item_ids_length1;
						gint _item_ids_size_;
						gchar** _tmp20_;
						gint _tmp20__length1;
						_tmp17_ = output;
						_tmp19_ = _tmp18_ = g_strsplit (_tmp17_, ";", 0);
						item_ids = _tmp19_;
						item_ids_length1 = _vala_array_length (_tmp18_);
						_item_ids_size_ = item_ids_length1;
						_tmp20_ = item_ids;
						_tmp20__length1 = item_ids_length1;
						fm_file_action_menu_cache_children (self, files, _tmp20_, (gint) _tmp20__length1);
						item_ids = (_vala_array_free (item_ids, item_ids_length1, (GDestroyNotify) g_free), NULL);
					}
					_g_free0 (command);
					_g_free0 (output);
				} else {
					const gchar* _tmp21_;
					_tmp21_ = item_id_prefix;
					if (g_strcmp0 (_tmp21_, "SEPARATOR") == 0) {
						self->cached_children = g_list_append (self->cached_children, NULL);
					} else {
						gchar* item_id = NULL;
						const gchar* _tmp22_;
						const gchar* _tmp23_;
						gchar* _tmp24_;
						FmFileActionObject* child_action = NULL;
						GHashTable* _tmp25_;
						const gchar* _tmp26_;
						gconstpointer _tmp27_;
						FmFileActionObject* _tmp28_;
						FmFileActionObject* _tmp29_;
						_tmp22_ = item_id_prefix;
						_tmp23_ = string_to_string (_tmp22_);
						_tmp24_ = g_strconcat (_tmp23_, ".desktop", NULL);
						item_id = _tmp24_;
						_tmp25_ = fm_all_actions;
						_tmp26_ = item_id;
						_tmp27_ = g_hash_table_lookup (_tmp25_, _tmp26_);
						_tmp28_ = _g_object_ref0 ((FmFileActionObject*) _tmp27_);
						child_action = _tmp28_;
						_tmp29_ = child_action;
						if (_tmp29_ != NULL) {
							FmFileActionObject* _tmp30_;
							FmFileActionObject* _tmp31_;
							FmFileActionObject* _tmp32_;
							_tmp30_ = child_action;
							_tmp30_->has_parent = TRUE;
							_tmp31_ = child_action;
							_tmp32_ = _g_object_ref0 (_tmp31_);
							self->cached_children = g_list_append (self->cached_children, _tmp32_);
						}
						_g_object_unref0 (child_action);
						_g_free0 (item_id);
					}
				}
			}
		}
	}
}

static void
fm_file_action_menu_class_init (FmFileActionMenuClass * klass,
                                gpointer klass_data)
{
	fm_file_action_menu_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = fm_file_action_menu_finalize;
}

static void
fm_file_action_menu_instance_init (FmFileActionMenu * self,
                                   gpointer klass)
{
}

static void
fm_file_action_menu_finalize (GObject * obj)
{
	FmFileActionMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FM_TYPE_FILE_ACTION_MENU, FmFileActionMenu);
	self->items_list = (_vala_array_free (self->items_list, self->items_list_length1, (GDestroyNotify) g_free), NULL);
	(self->cached_children == NULL) ? NULL : (self->cached_children = (_g_list_free__g_object_unref0_ (self->cached_children), NULL));
	G_OBJECT_CLASS (fm_file_action_menu_parent_class)->finalize (obj);
}

static GType
fm_file_action_menu_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FmFileActionMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fm_file_action_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FmFileActionMenu), 0, (GInstanceInitFunc) fm_file_action_menu_instance_init, NULL };
	GType fm_file_action_menu_type_id;
	fm_file_action_menu_type_id = g_type_register_static (FM_TYPE_FILE_ACTION_OBJECT, "FmFileActionMenu", &g_define_type_info, 0);
	return fm_file_action_menu_type_id;
}

GType
fm_file_action_menu_get_type (void)
{
	static volatile gsize fm_file_action_menu_type_id__once = 0;
	if (g_once_init_enter (&fm_file_action_menu_type_id__once)) {
		GType fm_file_action_menu_type_id;
		fm_file_action_menu_type_id = fm_file_action_menu_get_type_once ();
		g_once_init_leave (&fm_file_action_menu_type_id__once, fm_file_action_menu_type_id);
	}
	return fm_file_action_menu_type_id__once;
}

static void
_fm_file_action_item_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (fm_file_action_item_unref (var), NULL));
}

static inline void
_g_list_free__fm_file_action_item_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _fm_file_action_item_unref0_);
}

FmFileActionItem*
fm_file_action_item_new_for_action_object (FmFileActionObject* action_obj,
                                           GList* files)
{
	FmFileActionItem* item = NULL;
	FmFileActionItem* result;
	g_return_val_if_fail (action_obj != NULL, NULL);
	item = NULL;
	if (action_obj->type == FM_FILE_ACTION_TYPE_MENU) {
		FmFileActionMenu* menu = NULL;
		FmFileActionMenu* _tmp0_;
		FmFileActionMenu* _tmp1_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (action_obj, FM_TYPE_FILE_ACTION_MENU, FmFileActionMenu));
		menu = _tmp0_;
		_tmp1_ = menu;
		if (fm_file_action_menu_match (_tmp1_, files)) {
			FmFileActionMenu* _tmp2_;
			FmFileActionItem* _tmp3_;
			FmFileActionItem* _tmp4_;
			GList* _tmp5_;
			_tmp2_ = menu;
			_tmp3_ = fm_file_action_item_new_from_menu (_tmp2_, files);
			_fm_file_action_item_unref0 (item);
			item = _tmp3_;
			_tmp4_ = item;
			_tmp5_ = _tmp4_->children;
			if (_tmp5_ == NULL) {
				_fm_file_action_item_unref0 (item);
				item = NULL;
			}
		}
		_g_object_unref0 (menu);
	} else {
		FmFileAction* action = NULL;
		FmFileAction* _tmp6_;
		FmFileActionProfile* profile = NULL;
		FmFileAction* _tmp7_;
		FmFileActionProfile* _tmp8_ = NULL;
		gboolean _tmp9_;
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (action_obj, FM_TYPE_FILE_ACTION, FmFileAction));
		action = _tmp6_;
		_tmp7_ = action;
		_tmp9_ = fm_file_action_match (_tmp7_, files, &_tmp8_);
		profile = _tmp8_;
		if (_tmp9_) {
			FmFileAction* _tmp10_;
			FmFileActionProfile* _tmp11_;
			FmFileActionItem* _tmp12_;
			_tmp10_ = action;
			_tmp11_ = profile;
			_tmp12_ = fm_file_action_item_new_from_action (_tmp10_, _tmp11_, files);
			_fm_file_action_item_unref0 (item);
			item = _tmp12_;
		}
		_g_object_unref0 (action);
	}
	result = item;
	return result;
}

FmFileActionItem*
fm_file_action_item_construct_from_action (GType object_type,
                                           FmFileAction* action,
                                           FmFileActionProfile* profile,
                                           GList* files)
{
	FmFileActionItem* self = NULL;
	g_return_val_if_fail (action != NULL, NULL);
	g_return_val_if_fail (profile != NULL, NULL);
	self = (FmFileActionItem*) fm_file_action_item_construct (object_type, (FmFileActionObject*) action, files);
	self->profile = profile;
	return self;
}

FmFileActionItem*
fm_file_action_item_new_from_action (FmFileAction* action,
                                     FmFileActionProfile* profile,
                                     GList* files)
{
	return fm_file_action_item_construct_from_action (FM_TYPE_FILE_ACTION_ITEM, action, profile, files);
}

static gpointer
_fm_file_action_item_ref0 (gpointer self)
{
	return self ? fm_file_action_item_ref (self) : NULL;
}

FmFileActionItem*
fm_file_action_item_construct_from_menu (GType object_type,
                                         FmFileActionMenu* menu,
                                         GList* files)
{
	FmFileActionItem* self = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (menu != NULL, NULL);
	self = (FmFileActionItem*) fm_file_action_item_construct (object_type, (FmFileActionObject*) menu, files);
	_tmp0_ = menu->cached_children;
	{
		GList* action_obj_collection = NULL;
		GList* action_obj_it = NULL;
		action_obj_collection = _tmp0_;
		for (action_obj_it = action_obj_collection; action_obj_it != NULL; action_obj_it = action_obj_it->next) {
			FmFileActionObject* _tmp1_;
			FmFileActionObject* action_obj = NULL;
			_tmp1_ = _g_object_ref0 ((FmFileActionObject*) action_obj_it->data);
			action_obj = _tmp1_;
			{
				FmFileActionObject* _tmp2_;
				_tmp2_ = action_obj;
				if (_tmp2_ == NULL) {
					self->children = g_list_append (self->children, NULL);
				} else {
					FmFileActionItem* subitem = NULL;
					FmFileActionObject* _tmp3_;
					FmFileActionItem* _tmp4_;
					FmFileActionItem* _tmp5_;
					_tmp3_ = action_obj;
					_tmp4_ = fm_file_action_item_new_for_action_object (_tmp3_, files);
					subitem = _tmp4_;
					_tmp5_ = subitem;
					if (_tmp5_ != NULL) {
						FmFileActionItem* _tmp6_;
						FmFileActionItem* _tmp7_;
						_tmp6_ = subitem;
						_tmp7_ = _fm_file_action_item_ref0 (_tmp6_);
						self->children = g_list_append (self->children, _tmp7_);
					}
					_fm_file_action_item_unref0 (subitem);
				}
				_g_object_unref0 (action_obj);
			}
		}
	}
	return self;
}

FmFileActionItem*
fm_file_action_item_new_from_menu (FmFileActionMenu* menu,
                                   GList* files)
{
	return fm_file_action_item_construct_from_menu (FM_TYPE_FILE_ACTION_ITEM, menu, files);
}

static FmFileActionItem*
fm_file_action_item_construct (GType object_type,
                               FmFileActionObject* action,
                               GList* files)
{
	FmFileActionItem* self = NULL;
	FmFileActionObject* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (action != NULL, NULL);
	self = (FmFileActionItem*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (action);
	_g_object_unref0 (self->action);
	self->action = _tmp0_;
	_tmp1_ = action->name;
	_tmp2_ = fm_file_action_parameters_expand (_tmp1_, files, TRUE, NULL);
	_g_free0 (self->name);
	self->name = _tmp2_;
	_tmp3_ = action->desc;
	_tmp4_ = fm_file_action_parameters_expand (_tmp3_, files, TRUE, NULL);
	_g_free0 (self->desc);
	self->desc = _tmp4_;
	_tmp5_ = action->icon;
	_tmp6_ = fm_file_action_parameters_expand (_tmp5_, files, FALSE, NULL);
	_g_free0 (self->icon);
	self->icon = _tmp6_;
	return self;
}

static FmFileActionItem*
fm_file_action_item_new (FmFileActionObject* action,
                         GList* files)
{
	return fm_file_action_item_construct (FM_TYPE_FILE_ACTION_ITEM, action, files);
}

const gchar*
fm_file_action_item_get_name (FmFileActionItem* self)
{
	const gchar* _tmp0_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	result = _tmp0_;
	return result;
}

const gchar*
fm_file_action_item_get_desc (FmFileActionItem* self)
{
	const gchar* _tmp0_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->desc;
	result = _tmp0_;
	return result;
}

const gchar*
fm_file_action_item_get_icon (FmFileActionItem* self)
{
	const gchar* _tmp0_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->icon;
	result = _tmp0_;
	return result;
}

const gchar*
fm_file_action_item_get_id (FmFileActionItem* self)
{
	FmFileActionObject* _tmp0_;
	const gchar* _tmp1_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->action;
	_tmp1_ = _tmp0_->id;
	result = _tmp1_;
	return result;
}

FmFileActionTarget
fm_file_action_item_get_target (FmFileActionItem* self)
{
	FmFileActionObject* _tmp0_;
	FmFileActionTarget result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->action;
	if (_tmp0_->type == FM_FILE_ACTION_TYPE_ACTION) {
		FmFileActionObject* _tmp1_;
		_tmp1_ = self->action;
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, FM_TYPE_FILE_ACTION, FmFileAction)->target;
		return result;
	}
	result = FM_FILE_ACTION_TARGET_NONE;
	return result;
}

gboolean
fm_file_action_item_is_menu (FmFileActionItem* self)
{
	FmFileActionObject* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->action;
	result = _tmp0_->type == FM_FILE_ACTION_TYPE_MENU;
	return result;
}

gboolean
fm_file_action_item_is_action (FmFileActionItem* self)
{
	FmFileActionObject* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->action;
	result = _tmp0_->type == FM_FILE_ACTION_TYPE_ACTION;
	return result;
}

gboolean
fm_file_action_item_launch (FmFileActionItem* self,
                            GAppLaunchContext* ctx,
                            GList* files,
                            gchar** output)
{
	gchar* _vala_output = NULL;
	FmFileActionObject* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = self->action;
	if (_tmp0_->type == FM_FILE_ACTION_TYPE_ACTION) {
		FmFileActionProfile* _tmp1_;
		_tmp1_ = self->profile;
		if (_tmp1_ != NULL) {
			FmFileActionProfile* _tmp2_;
			gchar* _tmp3_ = NULL;
			_tmp2_ = self->profile;
			fm_file_action_profile_launch (_tmp2_, ctx, files, &_tmp3_);
			_g_free0 (_vala_output);
			_vala_output = _tmp3_;
		}
		result = TRUE;
		if (output) {
			*output = _vala_output;
		} else {
			_g_free0 (_vala_output);
		}
		return result;
	}
	result = FALSE;
	if (output) {
		*output = _vala_output;
	} else {
		_g_free0 (_vala_output);
	}
	return result;
}

GList*
fm_file_action_item_get_sub_items (FmFileActionItem* self)
{
	gboolean _tmp0_ = FALSE;
	FmFileActionObject* _tmp1_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->action;
	if (_tmp1_ != NULL) {
		FmFileActionObject* _tmp2_;
		_tmp2_ = self->action;
		_tmp0_ = _tmp2_->type == FM_FILE_ACTION_TYPE_MENU;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GList* _tmp3_;
		_tmp3_ = self->children;
		result = _tmp3_;
		return result;
	}
	result = NULL;
	return result;
}

static void
fm_value_file_action_item_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
fm_value_file_action_item_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		fm_file_action_item_unref (value->data[0].v_pointer);
	}
}

static void
fm_value_file_action_item_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = fm_file_action_item_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
fm_value_file_action_item_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
fm_value_file_action_item_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FmFileActionItem * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = fm_file_action_item_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
fm_value_file_action_item_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	FmFileActionItem ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = fm_file_action_item_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
fm_param_spec_file_action_item (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	FmParamSpecFileActionItem* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FM_TYPE_FILE_ACTION_ITEM), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
fm_value_get_file_action_item (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FM_TYPE_FILE_ACTION_ITEM), NULL);
	return value->data[0].v_pointer;
}

void
fm_value_set_file_action_item (GValue* value,
                               gpointer v_object)
{
	FmFileActionItem * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FM_TYPE_FILE_ACTION_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FM_TYPE_FILE_ACTION_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		fm_file_action_item_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fm_file_action_item_unref (old);
	}
}

void
fm_value_take_file_action_item (GValue* value,
                                gpointer v_object)
{
	FmFileActionItem * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FM_TYPE_FILE_ACTION_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FM_TYPE_FILE_ACTION_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fm_file_action_item_unref (old);
	}
}

static void
fm_file_action_item_class_init (FmFileActionItemClass * klass,
                                gpointer klass_data)
{
	fm_file_action_item_parent_class = g_type_class_peek_parent (klass);
	((FmFileActionItemClass *) klass)->finalize = fm_file_action_item_finalize;
}

static void
fm_file_action_item_instance_init (FmFileActionItem * self,
                                   gpointer klass)
{
	self->ref_count = 1;
}

static void
fm_file_action_item_finalize (FmFileActionItem * obj)
{
	FmFileActionItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FM_TYPE_FILE_ACTION_ITEM, FmFileActionItem);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	_g_free0 (self->desc);
	_g_free0 (self->icon);
	_g_object_unref0 (self->action);
	(self->children == NULL) ? NULL : (self->children = (_g_list_free__fm_file_action_item_unref0_ (self->children), NULL));
}

static GType
fm_file_action_item_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { fm_value_file_action_item_init, fm_value_file_action_item_free_value, fm_value_file_action_item_copy_value, fm_value_file_action_item_peek_pointer, "p", fm_value_file_action_item_collect_value, "p", fm_value_file_action_item_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FmFileActionItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fm_file_action_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FmFileActionItem), 0, (GInstanceInitFunc) fm_file_action_item_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType fm_file_action_item_type_id;
	fm_file_action_item_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FmFileActionItem", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return fm_file_action_item_type_id;
}

GType
fm_file_action_item_get_type (void)
{
	static volatile gsize fm_file_action_item_type_id__once = 0;
	if (g_once_init_enter (&fm_file_action_item_type_id__once)) {
		GType fm_file_action_item_type_id;
		fm_file_action_item_type_id = fm_file_action_item_get_type_once ();
		g_once_init_leave (&fm_file_action_item_type_id__once, fm_file_action_item_type_id);
	}
	return fm_file_action_item_type_id__once;
}

gpointer
fm_file_action_item_ref (gpointer instance)
{
	FmFileActionItem * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
fm_file_action_item_unref (gpointer instance)
{
	FmFileActionItem * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FM_FILE_ACTION_ITEM_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

void
fm_load_actions_from_dir (const gchar* dirname,
                          const gchar* id_prefix)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (dirname != NULL);
	{
		GDir* dir = NULL;
		GDir* _tmp0_;
		GDir* _tmp1_;
		_tmp0_ = g_dir_open (dirname, (guint) 0, &_inner_error0_);
		dir = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp1_ = dir;
		if (_tmp1_ != NULL) {
			const gchar* name = NULL;
			GKeyFile* kf = NULL;
			GKeyFile* _tmp2_;
			_tmp2_ = g_key_file_new ();
			kf = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					GDir* _tmp4_;
					const gchar* _tmp5_;
					const gchar* _tmp6_;
					gchar* full_path = NULL;
					const gchar* _tmp7_;
					gchar* _tmp8_;
					const gchar* _tmp9_;
					if (!_tmp3_) {
					}
					_tmp3_ = FALSE;
					_tmp4_ = dir;
					_tmp5_ = g_dir_read_name (_tmp4_);
					name = _tmp5_;
					_tmp6_ = name;
					if (_tmp6_ == NULL) {
						break;
					}
					_tmp7_ = name;
					_tmp8_ = g_build_filename (dirname, _tmp7_, NULL);
					full_path = _tmp8_;
					_tmp9_ = full_path;
					if (g_file_test (_tmp9_, G_FILE_TEST_IS_DIR)) {
						gchar* _tmp10_ = NULL;
						const gchar* _tmp17_;
						if (id_prefix != NULL) {
							const gchar* _tmp11_;
							const gchar* _tmp12_;
							const gchar* _tmp13_;
							gchar* _tmp14_;
							_tmp11_ = string_to_string (id_prefix);
							_tmp12_ = name;
							_tmp13_ = string_to_string (_tmp12_);
							_tmp14_ = g_strconcat (_tmp11_, "-", _tmp13_, NULL);
							_g_free0 (_tmp10_);
							_tmp10_ = _tmp14_;
						} else {
							const gchar* _tmp15_;
							gchar* _tmp16_;
							_tmp15_ = name;
							_tmp16_ = g_strdup (_tmp15_);
							_g_free0 (_tmp10_);
							_tmp10_ = _tmp16_;
						}
						_tmp17_ = full_path;
						fm_load_actions_from_dir (_tmp17_, _tmp10_);
						_g_free0 (_tmp10_);
					} else {
						const gchar* _tmp18_;
						_tmp18_ = name;
						if (g_str_has_suffix (_tmp18_, ".desktop")) {
							gchar* _tmp19_ = NULL;
							gchar* id = NULL;
							gchar* _tmp26_;
							GHashTable* _tmp27_;
							const gchar* _tmp28_;
							gconstpointer _tmp29_;
							if (id_prefix != NULL) {
								const gchar* _tmp20_;
								const gchar* _tmp21_;
								const gchar* _tmp22_;
								gchar* _tmp23_;
								_tmp20_ = string_to_string (id_prefix);
								_tmp21_ = name;
								_tmp22_ = string_to_string (_tmp21_);
								_tmp23_ = g_strconcat (_tmp20_, "-", _tmp22_, NULL);
								_g_free0 (_tmp19_);
								_tmp19_ = _tmp23_;
							} else {
								const gchar* _tmp24_;
								gchar* _tmp25_;
								_tmp24_ = name;
								_tmp25_ = g_strdup (_tmp24_);
								_g_free0 (_tmp19_);
								_tmp19_ = _tmp25_;
							}
							_tmp26_ = g_strdup (_tmp19_);
							id = _tmp26_;
							_tmp27_ = fm_all_actions;
							_tmp28_ = id;
							_tmp29_ = g_hash_table_lookup (_tmp27_, _tmp28_);
							if (((FmFileActionObject*) _tmp29_) == NULL) {
								gboolean _tmp30_ = FALSE;
								GKeyFile* _tmp31_;
								const gchar* _tmp32_;
								_tmp31_ = kf;
								_tmp32_ = full_path;
								_tmp30_ = g_key_file_load_from_file (_tmp31_, _tmp32_, 0, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									_g_free0 (id);
									_g_free0 (_tmp19_);
									_g_free0 (full_path);
									_g_key_file_unref0 (kf);
									_g_dir_close0 (dir);
									if (_inner_error0_->domain == G_FILE_ERROR) {
										goto __catch0_g_file_error;
									}
									goto __finally0;
								}
								if (_tmp30_) {
									gchar* type = NULL;
									GKeyFile* _tmp33_;
									gchar* _tmp34_;
									FmFileActionObject* action = NULL;
									gboolean _tmp35_ = FALSE;
									const gchar* _tmp36_;
									FmFileActionObject* _tmp43_;
									const gchar* _tmp44_;
									gchar* _tmp45_;
									GHashTable* _tmp46_;
									const gchar* _tmp47_;
									gchar* _tmp48_;
									FmFileActionObject* _tmp49_;
									FmFileActionObject* _tmp50_;
									_tmp33_ = kf;
									_tmp34_ = utils_key_file_get_string (_tmp33_, "Desktop Entry", "Type", NULL);
									type = _tmp34_;
									action = NULL;
									_tmp36_ = type;
									if (_tmp36_ == NULL) {
										_tmp35_ = TRUE;
									} else {
										const gchar* _tmp37_;
										_tmp37_ = type;
										_tmp35_ = g_strcmp0 (_tmp37_, "Action") == 0;
									}
									if (_tmp35_) {
										GKeyFile* _tmp38_;
										FmFileAction* _tmp39_;
										_tmp38_ = kf;
										_tmp39_ = fm_file_action_new_from_keyfile (_tmp38_);
										_g_object_unref0 (action);
										action = (FmFileActionObject*) _tmp39_;
									} else {
										const gchar* _tmp40_;
										_tmp40_ = type;
										if (g_strcmp0 (_tmp40_, "Menu") == 0) {
											GKeyFile* _tmp41_;
											FmFileActionMenu* _tmp42_;
											_tmp41_ = kf;
											_tmp42_ = fm_file_action_menu_new_from_keyfile (_tmp41_);
											_g_object_unref0 (action);
											action = (FmFileActionObject*) _tmp42_;
										} else {
											_g_object_unref0 (action);
											_g_free0 (type);
											_g_free0 (id);
											_g_free0 (_tmp19_);
											_g_free0 (full_path);
											continue;
										}
									}
									_tmp43_ = action;
									_tmp44_ = id;
									_tmp45_ = g_strdup (_tmp44_);
									_g_free0 (_tmp43_->id);
									_tmp43_->id = _tmp45_;
									_tmp46_ = fm_all_actions;
									_tmp47_ = id;
									_tmp48_ = g_strdup (_tmp47_);
									_tmp49_ = action;
									_tmp50_ = _g_object_ref0 (_tmp49_);
									g_hash_table_insert (_tmp46_, _tmp48_, _tmp50_);
									_g_object_unref0 (action);
									_g_free0 (type);
								}
							} else {
							}
							_g_free0 (id);
							_g_free0 (_tmp19_);
						}
					}
					_g_free0 (full_path);
				}
			}
			_g_key_file_unref0 (kf);
		}
		_g_dir_close0 (dir);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

GList*
fm_get_actions_for_files (GList* files)
{
	GHashTableIter action_it = {0};
	GHashTable* _tmp0_;
	FmFileActionObject* action_obj = NULL;
	GList* items = NULL;
	GHashTable* _tmp10_;
	GHashTable* _tmp20_;
	GList* result;
	if (!fm_actions_loaded) {
		fm_load_all_actions ();
	}
	_tmp0_ = fm_all_actions;
	g_hash_table_iter_init (&action_it, _tmp0_);
	action_obj = NULL;
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gboolean _tmp2_;
		FmFileActionObject* _tmp3_;
		FmFileActionObject* _tmp4_;
		_tmp2_ = g_hash_table_iter_next (&action_it, (gpointer*) NULL, (gpointer*) (&_tmp1_));
		_g_object_unref0 (action_obj);
		_tmp3_ = _g_object_ref0 ((FmFileActionObject*) _tmp1_);
		action_obj = _tmp3_;
		if (!_tmp2_) {
			break;
		}
		_tmp4_ = action_obj;
		if (_tmp4_->type == FM_FILE_ACTION_TYPE_MENU) {
			FmFileActionMenu* menu = NULL;
			FmFileActionObject* _tmp5_;
			FmFileActionMenu* _tmp6_;
			FmFileActionMenu* _tmp7_;
			FmFileActionMenu* _tmp8_;
			gchar** _tmp9_;
			gint _tmp9__length1;
			_tmp5_ = action_obj;
			_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, FM_TYPE_FILE_ACTION_MENU, FmFileActionMenu));
			menu = _tmp6_;
			_tmp7_ = menu;
			_tmp8_ = menu;
			_tmp9_ = _tmp8_->items_list;
			_tmp9__length1 = _tmp8_->items_list_length1;
			fm_file_action_menu_cache_children (_tmp7_, files, _tmp9_, (gint) _tmp9__length1);
			_g_object_unref0 (menu);
		}
	}
	items = NULL;
	_tmp10_ = fm_all_actions;
	g_hash_table_iter_init (&action_it, _tmp10_);
	_g_object_unref0 (action_obj);
	action_obj = NULL;
	while (TRUE) {
		gconstpointer _tmp11_ = NULL;
		gboolean _tmp12_;
		FmFileActionObject* _tmp13_;
		FmFileActionObject* _tmp14_;
		_tmp12_ = g_hash_table_iter_next (&action_it, (gpointer*) NULL, (gpointer*) (&_tmp11_));
		_g_object_unref0 (action_obj);
		_tmp13_ = _g_object_ref0 ((FmFileActionObject*) _tmp11_);
		action_obj = _tmp13_;
		if (!_tmp12_) {
			break;
		}
		_tmp14_ = action_obj;
		if (_tmp14_->has_parent == FALSE) {
			FmFileActionItem* item = NULL;
			FmFileActionObject* _tmp15_;
			FmFileActionItem* _tmp16_;
			FmFileActionItem* _tmp17_;
			_tmp15_ = action_obj;
			_tmp16_ = fm_file_action_item_new_for_action_object (_tmp15_, files);
			item = _tmp16_;
			_tmp17_ = item;
			if (_tmp17_ != NULL) {
				FmFileActionItem* _tmp18_;
				FmFileActionItem* _tmp19_;
				_tmp18_ = item;
				_tmp19_ = _fm_file_action_item_ref0 (_tmp18_);
				items = g_list_append (items, _tmp19_);
			}
			_fm_file_action_item_unref0 (item);
		}
	}
	_tmp20_ = fm_all_actions;
	g_hash_table_iter_init (&action_it, _tmp20_);
	_g_object_unref0 (action_obj);
	action_obj = NULL;
	while (TRUE) {
		gconstpointer _tmp21_ = NULL;
		gboolean _tmp22_;
		FmFileActionObject* _tmp23_;
		FmFileActionObject* _tmp24_;
		FmFileActionObject* _tmp25_;
		_tmp22_ = g_hash_table_iter_next (&action_it, (gpointer*) NULL, (gpointer*) (&_tmp21_));
		_g_object_unref0 (action_obj);
		_tmp23_ = _g_object_ref0 ((FmFileActionObject*) _tmp21_);
		action_obj = _tmp23_;
		if (!_tmp22_) {
			break;
		}
		_tmp24_ = action_obj;
		_tmp24_->has_parent = FALSE;
		_tmp25_ = action_obj;
		if (_tmp25_->type == FM_FILE_ACTION_TYPE_MENU) {
			FmFileActionMenu* menu = NULL;
			FmFileActionObject* _tmp26_;
			FmFileActionMenu* _tmp27_;
			FmFileActionMenu* _tmp28_;
			_tmp26_ = action_obj;
			_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, FM_TYPE_FILE_ACTION_MENU, FmFileActionMenu));
			menu = _tmp27_;
			_tmp28_ = menu;
			(_tmp28_->cached_children == NULL) ? NULL : (_tmp28_->cached_children = (_g_list_free__g_object_unref0_ (_tmp28_->cached_children), NULL));
			_tmp28_->cached_children = NULL;
			_g_object_unref0 (menu);
		}
	}
	result = items;
	_g_object_unref0 (action_obj);
	return result;
}

void
fm_load_all_actions (void)
{
	GHashTable* _tmp0_;
	gchar** dirs = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint dirs_length1;
	gint _dirs_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	_tmp0_ = fm_all_actions;
	g_hash_table_remove_all (_tmp0_);
	_tmp2_ = _tmp1_ = g_get_system_data_dirs ();
	dirs = _tmp2_;
	dirs_length1 = _vala_array_length (_tmp1_);
	_dirs_size_ = dirs_length1;
	_tmp3_ = dirs;
	_tmp3__length1 = dirs_length1;
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp3_;
		dir_collection_length1 = _tmp3__length1;
		for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
			const gchar* dir = NULL;
			dir = dir_collection[dir_it];
			{
				const gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp4_ = dir;
				_tmp5_ = g_build_filename (_tmp4_, "file-manager/actions", NULL);
				_tmp6_ = _tmp5_;
				fm_load_actions_from_dir (_tmp6_, NULL);
				_g_free0 (_tmp6_);
			}
		}
	}
	_tmp7_ = g_get_user_data_dir ();
	_tmp8_ = g_build_filename (_tmp7_, "file-manager/actions", NULL);
	_tmp9_ = _tmp8_;
	fm_load_actions_from_dir (_tmp9_, NULL);
	_g_free0 (_tmp9_);
	fm_actions_loaded = TRUE;
}

void
fm_file_actions_set_desktop_env (const gchar* env)
{
	gchar* _tmp0_;
	g_return_if_fail (env != NULL);
	_tmp0_ = g_strdup (env);
	_g_free0 (fm_desktop_env);
	fm_desktop_env = _tmp0_;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

void
_fm_file_actions_init (void)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (fm_all_actions);
	fm_all_actions = _tmp2_;
}

void
_fm_file_actions_finalize (void)
{
	_g_hash_table_unref0 (fm_all_actions);
	fm_all_actions = NULL;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

