/* gridframe.c generated by valac 0.56.14, the Vala compiler
 * generated from gridframe.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2015 Michael Catanzaro <mcatanzaro@gnome.org>
 *
 * This file is part of libgnome-games-support.
 *
 * libgnome-games-support is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgnome-games-support is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with libgnome-games-support.  If not, see <http://www.gnu.org/licenses/>.
 */
/* A container that guarantees that the internal allocated space is a fixed*/
/* multiple of an integer. This is a fairly literal translation of the LGPLv2+*/
/* original by Callum McKenzie, itself based on GtkFrame and GtkAspectFrame.*/

#include "libgnome-games-support.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>

enum  {
	GAMES_GRID_FRAME_0_PROPERTY,
	GAMES_GRID_FRAME_XPADDING_PROPERTY,
	GAMES_GRID_FRAME_YPADDING_PROPERTY,
	GAMES_GRID_FRAME_WIDTH_PROPERTY,
	GAMES_GRID_FRAME_HEIGHT_PROPERTY,
	GAMES_GRID_FRAME_XALIGN_PROPERTY,
	GAMES_GRID_FRAME_YALIGN_PROPERTY,
	GAMES_GRID_FRAME_NUM_PROPERTIES
};
static GParamSpec* games_grid_frame_properties[GAMES_GRID_FRAME_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GamesGridFramePrivate {
	gint _xpadding;
	gint _ypadding;
	gint _xmult;
	gint _ymult;
	gfloat _xalign;
	gfloat _yalign;
	GtkAllocation old_allocation;
};

static gint GamesGridFrame_private_offset;
static gpointer games_grid_frame_parent_class = NULL;

static void games_grid_frame_real_size_allocate (GtkWidget* base,
                                          GtkAllocation* allocation);
static void games_grid_frame_finalize (GObject * obj);
static GType games_grid_frame_get_type_once (void);
static void _vala_games_grid_frame_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_games_grid_frame_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
games_grid_frame_get_instance_private (GamesGridFrame* self)
{
	return G_STRUCT_MEMBER_P (self, GamesGridFrame_private_offset);
}

gint
games_grid_frame_get_xpadding (GamesGridFrame* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_xpadding;
	return result;
}

void
games_grid_frame_set_xpadding (GamesGridFrame* self,
                               gint value)
{
	g_return_if_fail (self != NULL);
	if (value >= 0) {
		self->priv->_xpadding = value;
		gtk_widget_queue_resize ((GtkWidget*) self);
	}
	g_object_notify_by_pspec ((GObject *) self, games_grid_frame_properties[GAMES_GRID_FRAME_XPADDING_PROPERTY]);
}

gint
games_grid_frame_get_ypadding (GamesGridFrame* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_ypadding;
	return result;
}

void
games_grid_frame_set_ypadding (GamesGridFrame* self,
                               gint value)
{
	g_return_if_fail (self != NULL);
	if (value >= 0) {
		self->priv->_ypadding = value;
		gtk_widget_queue_resize ((GtkWidget*) self);
	}
	g_object_notify_by_pspec ((GObject *) self, games_grid_frame_properties[GAMES_GRID_FRAME_YPADDING_PROPERTY]);
}

gint
games_grid_frame_get_width (GamesGridFrame* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_xmult;
	return result;
}

void
games_grid_frame_set_width (GamesGridFrame* self,
                            gint value)
{
	g_return_if_fail (self != NULL);
	if (value > 0) {
		self->priv->_xmult = value;
		gtk_widget_queue_resize ((GtkWidget*) self);
	}
	g_object_notify_by_pspec ((GObject *) self, games_grid_frame_properties[GAMES_GRID_FRAME_WIDTH_PROPERTY]);
}

gint
games_grid_frame_get_height (GamesGridFrame* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_ymult;
	return result;
}

void
games_grid_frame_set_height (GamesGridFrame* self,
                             gint value)
{
	g_return_if_fail (self != NULL);
	if (value > 0) {
		self->priv->_ymult = value;
		gtk_widget_queue_resize ((GtkWidget*) self);
	}
	g_object_notify_by_pspec ((GObject *) self, games_grid_frame_properties[GAMES_GRID_FRAME_HEIGHT_PROPERTY]);
}

gfloat
games_grid_frame_get_xalign (GamesGridFrame* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_xalign;
	return result;
}

void
games_grid_frame_set_xalign (GamesGridFrame* self,
                             gfloat value)
{
	g_return_if_fail (self != NULL);
	self->priv->_xalign = CLAMP (value, 0.0f, 1.0f);
	gtk_widget_queue_resize ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, games_grid_frame_properties[GAMES_GRID_FRAME_XALIGN_PROPERTY]);
}

gfloat
games_grid_frame_get_yalign (GamesGridFrame* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_yalign;
	return result;
}

void
games_grid_frame_set_yalign (GamesGridFrame* self,
                             gfloat value)
{
	g_return_if_fail (self != NULL);
	self->priv->_yalign = CLAMP (value, 0.0f, 1.0f);
	gtk_widget_queue_resize ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, games_grid_frame_properties[GAMES_GRID_FRAME_YALIGN_PROPERTY]);
}

GamesGridFrame*
games_grid_frame_construct (GType object_type,
                            gint width,
                            gint height)
{
	GamesGridFrame * self = NULL;
	self = (GamesGridFrame*) g_object_new (object_type, "width", width, "height", height, NULL);
	return self;
}

GamesGridFrame*
games_grid_frame_new (gint width,
                      gint height)
{
	return games_grid_frame_construct (GAMES_TYPE_GRID_FRAME, width, height);
}

void
games_grid_frame_set (GamesGridFrame* self,
                      gint width,
                      gint height)
{
	g_return_if_fail (self != NULL);
	games_grid_frame_set_width (self, width);
	games_grid_frame_set_height (self, height);
}

void
games_grid_frame_set_padding (GamesGridFrame* self,
                              gint xpadding,
                              gint ypadding)
{
	g_return_if_fail (self != NULL);
	games_grid_frame_set_xpadding (self, xpadding);
	games_grid_frame_set_ypadding (self, ypadding);
}

void
games_grid_frame_set_alignment (GamesGridFrame* self,
                                gfloat xalign,
                                gfloat yalign)
{
	g_return_if_fail (self != NULL);
	games_grid_frame_set_xalign (self, xalign);
	games_grid_frame_set_yalign (self, yalign);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
games_grid_frame_real_size_allocate (GtkWidget* base,
                                     GtkAllocation* allocation)
{
	GamesGridFrame * self;
	GtkAllocation _tmp0_;
	gint xsize = 0;
	GtkAllocation _tmp1_;
	gint ysize = 0;
	GtkAllocation _tmp2_;
	gint size = 0;
	GtkAllocation child_allocation = {0};
	GtkAllocation _tmp3_ = {0};
	GtkAllocation _tmp4_;
	GtkAllocation _tmp5_;
	GtkAllocation _tmp6_;
	GtkAllocation _tmp7_;
	GtkAllocation _tmp8_;
	GtkAllocation _tmp9_;
	gboolean _tmp10_ = FALSE;
	GtkWidget* child = NULL;
	GtkWidget* _tmp25_;
	GtkWidget* _tmp26_;
	gboolean _tmp27_ = FALSE;
	GtkWidget* _tmp28_;
	GtkAllocation _tmp32_;
	self = (GamesGridFrame*) base;
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	GTK_WIDGET_CLASS (games_grid_frame_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_bin_get_type (), GtkBin), &_tmp0_);
	_tmp1_ = *allocation;
	xsize = MAX (1, (_tmp1_.width - self->priv->_xpadding) / self->priv->_xmult);
	_tmp2_ = *allocation;
	ysize = MAX (1, (_tmp2_.height - self->priv->_ypadding) / self->priv->_ymult);
	size = MIN (xsize, ysize);
	_tmp3_.x = 0;
	_tmp3_.y = 0;
	_tmp3_.width = 0;
	_tmp3_.height = 0;
	child_allocation = _tmp3_;
	child_allocation.width = (size * self->priv->_xmult) + self->priv->_xpadding;
	child_allocation.height = (size * self->priv->_ymult) + self->priv->_ypadding;
	_tmp4_ = *allocation;
	_tmp5_ = child_allocation;
	_tmp6_ = *allocation;
	child_allocation.x = (gint) (((_tmp4_.width - _tmp5_.width) * self->priv->_xalign) + _tmp6_.x);
	_tmp7_ = *allocation;
	_tmp8_ = child_allocation;
	_tmp9_ = *allocation;
	child_allocation.y = (gint) (((_tmp7_.height - _tmp8_.height) * self->priv->_yalign) + _tmp9_.y);
	if (gtk_widget_get_mapped ((GtkWidget*) self)) {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		GtkAllocation _tmp14_;
		GtkAllocation _tmp15_;
		_tmp14_ = child_allocation;
		_tmp15_ = self->priv->old_allocation;
		if (_tmp14_.x != _tmp15_.x) {
			_tmp13_ = TRUE;
		} else {
			GtkAllocation _tmp16_;
			GtkAllocation _tmp17_;
			_tmp16_ = child_allocation;
			_tmp17_ = self->priv->old_allocation;
			_tmp13_ = _tmp16_.y != _tmp17_.y;
		}
		if (_tmp13_) {
			_tmp12_ = TRUE;
		} else {
			GtkAllocation _tmp18_;
			GtkAllocation _tmp19_;
			_tmp18_ = child_allocation;
			_tmp19_ = self->priv->old_allocation;
			_tmp12_ = _tmp18_.width != _tmp19_.width;
		}
		if (_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			GtkAllocation _tmp20_;
			GtkAllocation _tmp21_;
			_tmp20_ = child_allocation;
			_tmp21_ = self->priv->old_allocation;
			_tmp11_ = _tmp20_.height != _tmp21_.height;
		}
		_tmp10_ = _tmp11_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		GdkWindow* _tmp22_;
		GtkAllocation _tmp23_;
		GdkRectangle _tmp24_;
		_tmp22_ = gtk_widget_get_window ((GtkWidget*) self);
		_tmp23_ = *allocation;
		_tmp24_ = _tmp23_;
		gdk_window_invalidate_rect (_tmp22_, &_tmp24_, FALSE);
	}
	_tmp25_ = gtk_bin_get_child ((GtkBin*) self);
	_tmp26_ = _g_object_ref0 (_tmp25_);
	child = _tmp26_;
	_tmp28_ = child;
	if (_tmp28_ != NULL) {
		GtkWidget* _tmp29_;
		_tmp29_ = child;
		_tmp27_ = gtk_widget_get_visible (_tmp29_);
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		GtkWidget* _tmp30_;
		GtkAllocation _tmp31_;
		_tmp30_ = child;
		_tmp31_ = child_allocation;
		gtk_widget_size_allocate (_tmp30_, &_tmp31_);
	}
	_tmp32_ = child_allocation;
	self->priv->old_allocation = _tmp32_;
	_g_object_unref0 (child);
}

static void
games_grid_frame_class_init (GamesGridFrameClass * klass,
                             gpointer klass_data)
{
	games_grid_frame_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesGridFrame_private_offset);
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, GtkAllocation*)) games_grid_frame_real_size_allocate;
	G_OBJECT_CLASS (klass)->get_property = _vala_games_grid_frame_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_grid_frame_set_property;
	G_OBJECT_CLASS (klass)->finalize = games_grid_frame_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_XPADDING_PROPERTY, games_grid_frame_properties[GAMES_GRID_FRAME_XPADDING_PROPERTY] = g_param_spec_int ("xpadding", "xpadding", "xpadding", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_YPADDING_PROPERTY, games_grid_frame_properties[GAMES_GRID_FRAME_YPADDING_PROPERTY] = g_param_spec_int ("ypadding", "ypadding", "ypadding", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_WIDTH_PROPERTY, games_grid_frame_properties[GAMES_GRID_FRAME_WIDTH_PROPERTY] = g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_HEIGHT_PROPERTY, games_grid_frame_properties[GAMES_GRID_FRAME_HEIGHT_PROPERTY] = g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_XALIGN_PROPERTY, games_grid_frame_properties[GAMES_GRID_FRAME_XALIGN_PROPERTY] = g_param_spec_float ("xalign", "xalign", "xalign", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_YALIGN_PROPERTY, games_grid_frame_properties[GAMES_GRID_FRAME_YALIGN_PROPERTY] = g_param_spec_float ("yalign", "yalign", "yalign", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
games_grid_frame_instance_init (GamesGridFrame * self,
                                gpointer klass)
{
	self->priv = games_grid_frame_get_instance_private (self);
	self->priv->_xpadding = 0;
	self->priv->_ypadding = 0;
	self->priv->_xmult = 1;
	self->priv->_ymult = 1;
	self->priv->_xalign = 0.5f;
	self->priv->_yalign = 0.5f;
}

static void
games_grid_frame_finalize (GObject * obj)
{
	GamesGridFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GRID_FRAME, GamesGridFrame);
	G_OBJECT_CLASS (games_grid_frame_parent_class)->finalize (obj);
}

static GType
games_grid_frame_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesGridFrameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_grid_frame_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesGridFrame), 0, (GInstanceInitFunc) games_grid_frame_instance_init, NULL };
	GType games_grid_frame_type_id;
	games_grid_frame_type_id = g_type_register_static (gtk_bin_get_type (), "GamesGridFrame", &g_define_type_info, 0);
	GamesGridFrame_private_offset = g_type_add_instance_private (games_grid_frame_type_id, sizeof (GamesGridFramePrivate));
	return games_grid_frame_type_id;
}

GType
games_grid_frame_get_type (void)
{
	static volatile gsize games_grid_frame_type_id__once = 0;
	if (g_once_init_enter (&games_grid_frame_type_id__once)) {
		GType games_grid_frame_type_id;
		games_grid_frame_type_id = games_grid_frame_get_type_once ();
		g_once_init_leave (&games_grid_frame_type_id__once, games_grid_frame_type_id);
	}
	return games_grid_frame_type_id__once;
}

static void
_vala_games_grid_frame_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	GamesGridFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GRID_FRAME, GamesGridFrame);
	switch (property_id) {
		case GAMES_GRID_FRAME_XPADDING_PROPERTY:
		g_value_set_int (value, games_grid_frame_get_xpadding (self));
		break;
		case GAMES_GRID_FRAME_YPADDING_PROPERTY:
		g_value_set_int (value, games_grid_frame_get_ypadding (self));
		break;
		case GAMES_GRID_FRAME_WIDTH_PROPERTY:
		g_value_set_int (value, games_grid_frame_get_width (self));
		break;
		case GAMES_GRID_FRAME_HEIGHT_PROPERTY:
		g_value_set_int (value, games_grid_frame_get_height (self));
		break;
		case GAMES_GRID_FRAME_XALIGN_PROPERTY:
		g_value_set_float (value, games_grid_frame_get_xalign (self));
		break;
		case GAMES_GRID_FRAME_YALIGN_PROPERTY:
		g_value_set_float (value, games_grid_frame_get_yalign (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_grid_frame_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	GamesGridFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GRID_FRAME, GamesGridFrame);
	switch (property_id) {
		case GAMES_GRID_FRAME_XPADDING_PROPERTY:
		games_grid_frame_set_xpadding (self, g_value_get_int (value));
		break;
		case GAMES_GRID_FRAME_YPADDING_PROPERTY:
		games_grid_frame_set_ypadding (self, g_value_get_int (value));
		break;
		case GAMES_GRID_FRAME_WIDTH_PROPERTY:
		games_grid_frame_set_width (self, g_value_get_int (value));
		break;
		case GAMES_GRID_FRAME_HEIGHT_PROPERTY:
		games_grid_frame_set_height (self, g_value_get_int (value));
		break;
		case GAMES_GRID_FRAME_XALIGN_PROPERTY:
		games_grid_frame_set_xalign (self, g_value_get_float (value));
		break;
		case GAMES_GRID_FRAME_YALIGN_PROPERTY:
		games_grid_frame_set_yalign (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

