
/* GENERATED CODE... DO NOT EDIT */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Copyright (C) 2012 Lanedo GmbH
 * Copyright (C) 2012-2022 Aleksander Morgado <aleksander@aleksander.es>
 */


#include <string.h>

#include "qmi-nas.h"
#include "qmi-common.h"
#include "qmi-enum-types.h"
#include "qmi-flag-types.h"
#include "qmi-enum-types-private.h"
#include "qmi-flag-types-private.h"
#include "qmi-flags64-types.h"
#include "qmi-error-types.h"
#include "qmi-device.h"
#include "qmi-helpers.h"

#define QMI_STATUS_SUCCESS 0x0000
#define QMI_STATUS_FAILURE 0x0001


typedef enum {
    QMI_MESSAGE_NAS_RESET = 0x0000,
    QMI_MESSAGE_NAS_ABORT = 0x0001,
    QMI_MESSAGE_NAS_SET_EVENT_REPORT = 0x0002,
    QMI_MESSAGE_NAS_REGISTER_INDICATIONS = 0x0003,
    QMI_MESSAGE_NAS_GET_SUPPORTED_MESSAGES = 0x001E,
    QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH = 0x0020,
    QMI_MESSAGE_NAS_NETWORK_SCAN = 0x0021,
    QMI_MESSAGE_NAS_INITIATE_NETWORK_REGISTER = 0x0022,
    QMI_MESSAGE_NAS_ATTACH_DETACH = 0x0023,
    QMI_MESSAGE_NAS_GET_SERVING_SYSTEM = 0x0024,
    QMI_MESSAGE_NAS_GET_HOME_NETWORK = 0x0025,
    QMI_MESSAGE_NAS_GET_PREFERRED_NETWORKS = 0x0026,
    QMI_MESSAGE_NAS_SET_PREFERRED_NETWORKS = 0x0027,
    QMI_MESSAGE_NAS_SET_TECHNOLOGY_PREFERENCE = 0x002A,
    QMI_MESSAGE_NAS_GET_TECHNOLOGY_PREFERENCE = 0x002B,
    QMI_MESSAGE_NAS_GET_RF_BAND_INFORMATION = 0x0031,
    QMI_MESSAGE_NAS_SET_SYSTEM_SELECTION_PREFERENCE = 0x0033,
    QMI_MESSAGE_NAS_GET_SYSTEM_SELECTION_PREFERENCE = 0x0034,
    QMI_MESSAGE_NAS_GET_OPERATOR_NAME = 0x0039,
    QMI_MESSAGE_NAS_GET_CELL_LOCATION_INFO = 0x0043,
    QMI_MESSAGE_NAS_GET_PLMN_NAME = 0x0044,
    QMI_MESSAGE_NAS_GET_SYSTEM_INFO = 0x004D,
    QMI_MESSAGE_NAS_GET_SIGNAL_INFO = 0x004F,
    QMI_MESSAGE_NAS_CONFIG_SIGNAL_INFO = 0x0050,
    QMI_MESSAGE_NAS_CONFIG_SIGNAL_INFO_V2 = 0x006C,
    QMI_MESSAGE_NAS_GET_TX_RX_INFO = 0x005A,
    QMI_MESSAGE_NAS_GET_CDMA_POSITION_INFO = 0x0065,
    QMI_MESSAGE_NAS_FORCE_NETWORK_SEARCH = 0x0067,
    QMI_MESSAGE_NAS_GET_NETWORK_TIME = 0x007D,
    QMI_MESSAGE_NAS_GET_DRX = 0x0089,
    QMI_MESSAGE_NAS_GET_LTE_CPHY_CA_INFO = 0x00AC,
    QMI_MESSAGE_NAS_SWI_GET_STATUS = 0x5556, /* vendor 0x1199 */
} QmiMessageNas;


typedef enum {
    QMI_INDICATION_NAS_EVENT_REPORT = 0x0002,
    QMI_INDICATION_NAS_SERVING_SYSTEM = 0x0024,
    QMI_INDICATION_NAS_OPERATOR_NAME = 0x003A,
    QMI_INDICATION_NAS_NETWORK_TIME = 0x004C,
    QMI_INDICATION_NAS_SYSTEM_INFO = 0x004E,
    QMI_INDICATION_NAS_SIGNAL_INFO = 0x0051,
    QMI_INDICATION_NAS_NETWORK_REJECT = 0x0068,
} QmiIndicationNas;


/*****************************************************************************/
/* INDICATION: Qmi Indication NAS Event Report */


/* --- Output -- */

static void
__qmi_indication_nas_event_report_output_rf_band_information_element_free (QmiIndicationNasEventReportOutputRfBandInformationElement *value)
{
    g_slice_free (QmiIndicationNasEventReportOutputRfBandInformationElement, value);
}

static QmiIndicationNasEventReportOutputRfBandInformationElement *
__qmi_indication_nas_event_report_output_rf_band_information_element_new (void)
{
    return g_slice_new0 (QmiIndicationNasEventReportOutputRfBandInformationElement);
}

static QmiIndicationNasEventReportOutputRfBandInformationElement *
__qmi_indication_nas_event_report_output_rf_band_information_element_copy (const QmiIndicationNasEventReportOutputRfBandInformationElement *value)
{
    QmiIndicationNasEventReportOutputRfBandInformationElement *copy;

    copy = __qmi_indication_nas_event_report_output_rf_band_information_element_new ();
    copy->radio_interface = value->radio_interface;
    copy->active_band_class = value->active_band_class;
    copy->active_channel = value->active_channel;
    return copy;
}

G_DEFINE_BOXED_TYPE (QmiIndicationNasEventReportOutputRfBandInformationElement, qmi_indication_nas_event_report_output_rf_band_information_element, (GBoxedCopyFunc)__qmi_indication_nas_event_report_output_rf_band_information_element_copy, (GBoxedFreeFunc)__qmi_indication_nas_event_report_output_rf_band_information_element_free)

struct _QmiIndicationNasEventReportOutput {
    volatile gint ref_count;

    /* LTE RSRP */
    gboolean arg_lte_rsrp_set;
    gint16 arg_lte_rsrp;

    /* LTE SNR */
    gboolean arg_lte_snr_set;
    gint16 arg_lte_snr;

    /* RSRQ */
    gboolean arg_rsrq_set;
    gint8 arg_rsrq_rsrq;
    gint8 arg_rsrq_radio_interface;

    /* Error Rate */
    gboolean arg_error_rate_set;
    guint16 arg_error_rate_rate;
    gint8 arg_error_rate_radio_interface;

    /* SINR */
    gboolean arg_sinr_set;
    guint8 arg_sinr;

    /* IO */
    gboolean arg_io_set;
    gint32 arg_io;

    /* ECIO */
    gboolean arg_ecio_set;
    guint8 arg_ecio_ecio;
    gint8 arg_ecio_radio_interface;

    /* RSSI */
    gboolean arg_rssi_set;
    guint8 arg_rssi_rssi;
    gint8 arg_rssi_radio_interface;

    /* Registration Reject Reason */
    gboolean arg_registration_reject_reason_set;
    guint8 arg_registration_reject_reason_service_domain;
    guint16 arg_registration_reject_reason_reject_cause;

    /* RF Band Information */
    gboolean arg_rf_band_information_set;
    GArray *arg_rf_band_information;
    GPtrArray *arg_rf_band_information_ptr;

    /* Signal Strength */
    gboolean arg_signal_strength_set;
    gint8 arg_signal_strength_strength;
    gint8 arg_signal_strength_radio_interface;
};

#define QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_LTE_RSRP 0x1A
#define QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_LTE_SNR 0x19
#define QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_RSRQ 0x18
#define QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_ERROR_RATE 0x17
#define QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_SINR 0x16
#define QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_IO 0x15
#define QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_ECIO 0x14
#define QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_RSSI 0x13
#define QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_REGISTRATION_REJECT_REASON 0x12
#define QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_RF_BAND_INFORMATION 0x11
#define QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_SIGNAL_STRENGTH 0x10

gboolean
qmi_indication_nas_event_report_output_get_lte_rsrp (
    QmiIndicationNasEventReportOutput *self,
    gint16 *value_lte_rsrp,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_lte_rsrp_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'LTE RSRP' was not found in the message");
        return FALSE;
    }

    if (value_lte_rsrp)
        *value_lte_rsrp = self->arg_lte_rsrp;

    return TRUE;
}

gboolean
qmi_indication_nas_event_report_output_get_lte_snr (
    QmiIndicationNasEventReportOutput *self,
    gint16 *value_lte_snr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_lte_snr_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'LTE SNR' was not found in the message");
        return FALSE;
    }

    if (value_lte_snr)
        *value_lte_snr = self->arg_lte_snr;

    return TRUE;
}

gboolean
qmi_indication_nas_event_report_output_get_rsrq (
    QmiIndicationNasEventReportOutput *self,
    gint8 *value_rsrq_rsrq,
    QmiNasRadioInterface *value_rsrq_radio_interface,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_rsrq_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'RSRQ' was not found in the message");
        return FALSE;
    }

    if (value_rsrq_rsrq)
        *value_rsrq_rsrq = self->arg_rsrq_rsrq;
    if (value_rsrq_radio_interface)
        *value_rsrq_radio_interface = (QmiNasRadioInterface)(self->arg_rsrq_radio_interface);

    return TRUE;
}

gboolean
qmi_indication_nas_event_report_output_get_error_rate (
    QmiIndicationNasEventReportOutput *self,
    guint16 *value_error_rate_rate,
    QmiNasRadioInterface *value_error_rate_radio_interface,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_error_rate_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Error Rate' was not found in the message");
        return FALSE;
    }

    if (value_error_rate_rate)
        *value_error_rate_rate = self->arg_error_rate_rate;
    if (value_error_rate_radio_interface)
        *value_error_rate_radio_interface = (QmiNasRadioInterface)(self->arg_error_rate_radio_interface);

    return TRUE;
}

gboolean
qmi_indication_nas_event_report_output_get_sinr (
    QmiIndicationNasEventReportOutput *self,
    QmiNasEvdoSinrLevel *value_sinr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_sinr_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'SINR' was not found in the message");
        return FALSE;
    }

    if (value_sinr)
        *value_sinr = (QmiNasEvdoSinrLevel)(self->arg_sinr);

    return TRUE;
}

gboolean
qmi_indication_nas_event_report_output_get_io (
    QmiIndicationNasEventReportOutput *self,
    gint32 *value_io,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_io_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'IO' was not found in the message");
        return FALSE;
    }

    if (value_io)
        *value_io = self->arg_io;

    return TRUE;
}

gboolean
qmi_indication_nas_event_report_output_get_ecio (
    QmiIndicationNasEventReportOutput *self,
    guint8 *value_ecio_ecio,
    QmiNasRadioInterface *value_ecio_radio_interface,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_ecio_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'ECIO' was not found in the message");
        return FALSE;
    }

    if (value_ecio_ecio)
        *value_ecio_ecio = self->arg_ecio_ecio;
    if (value_ecio_radio_interface)
        *value_ecio_radio_interface = (QmiNasRadioInterface)(self->arg_ecio_radio_interface);

    return TRUE;
}

gboolean
qmi_indication_nas_event_report_output_get_rssi (
    QmiIndicationNasEventReportOutput *self,
    guint8 *value_rssi_rssi,
    QmiNasRadioInterface *value_rssi_radio_interface,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_rssi_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'RSSI' was not found in the message");
        return FALSE;
    }

    if (value_rssi_rssi)
        *value_rssi_rssi = self->arg_rssi_rssi;
    if (value_rssi_radio_interface)
        *value_rssi_radio_interface = (QmiNasRadioInterface)(self->arg_rssi_radio_interface);

    return TRUE;
}

gboolean
qmi_indication_nas_event_report_output_get_registration_reject_reason (
    QmiIndicationNasEventReportOutput *self,
    QmiNasNetworkServiceDomain *value_registration_reject_reason_service_domain,
    guint16 *value_registration_reject_reason_reject_cause,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_registration_reject_reason_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Registration Reject Reason' was not found in the message");
        return FALSE;
    }

    if (value_registration_reject_reason_service_domain)
        *value_registration_reject_reason_service_domain = (QmiNasNetworkServiceDomain)(self->arg_registration_reject_reason_service_domain);
    if (value_registration_reject_reason_reject_cause)
        *value_registration_reject_reason_reject_cause = self->arg_registration_reject_reason_reject_cause;

    return TRUE;
}

gboolean
qmi_indication_nas_event_report_output_get_rf_band_information (
    QmiIndicationNasEventReportOutput *self,
    GArray **value_rf_band_information,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_rf_band_information_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'RF Band Information' was not found in the message");
        return FALSE;
    }

    if (value_rf_band_information)
        *value_rf_band_information = self->arg_rf_band_information;

    return TRUE;
}

gboolean
qmi_indication_nas_event_report_output_get_rf_band_information_gir (
    QmiIndicationNasEventReportOutput *self,
    GPtrArray **value_rf_band_information_ptr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_rf_band_information_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'RF Band Information' was not found in the message");
        return FALSE;
    }

    if (value_rf_band_information_ptr) {
        if (!self->arg_rf_band_information_ptr) {
            {
                guint rf_band_information_i;

                self->arg_rf_band_information_ptr = g_ptr_array_new_full (self->arg_rf_band_information->len, (GDestroyNotify)__qmi_indication_nas_event_report_output_rf_band_information_element_free);
                for (rf_band_information_i = 0; rf_band_information_i < self->arg_rf_band_information->len; rf_band_information_i++) {
                    QmiIndicationNasEventReportOutputRfBandInformationElement *rf_band_information_aux_from;
                    QmiIndicationNasEventReportOutputRfBandInformationElement *rf_band_information_aux_to;

                    rf_band_information_aux_from = &g_array_index (self->arg_rf_band_information, QmiIndicationNasEventReportOutputRfBandInformationElement, rf_band_information_i);

                    rf_band_information_aux_to = __qmi_indication_nas_event_report_output_rf_band_information_element_new ();
                    rf_band_information_aux_to->radio_interface = (*rf_band_information_aux_from).radio_interface;
                    rf_band_information_aux_to->active_band_class = (*rf_band_information_aux_from).active_band_class;
                    rf_band_information_aux_to->active_channel = (*rf_band_information_aux_from).active_channel;

                    g_ptr_array_add (self->arg_rf_band_information_ptr, rf_band_information_aux_to);
                }
            }
        }
        *value_rf_band_information_ptr = self->arg_rf_band_information_ptr;
    }
    return TRUE;
}

gboolean
qmi_indication_nas_event_report_output_get_signal_strength (
    QmiIndicationNasEventReportOutput *self,
    gint8 *value_signal_strength_strength,
    QmiNasRadioInterface *value_signal_strength_radio_interface,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_signal_strength_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Signal Strength' was not found in the message");
        return FALSE;
    }

    if (value_signal_strength_strength)
        *value_signal_strength_strength = self->arg_signal_strength_strength;
    if (value_signal_strength_radio_interface)
        *value_signal_strength_radio_interface = (QmiNasRadioInterface)(self->arg_signal_strength_radio_interface);

    return TRUE;
}

GType
qmi_indication_nas_event_report_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiIndicationNasEventReportOutput"),
                                          (GBoxedCopyFunc) qmi_indication_nas_event_report_output_ref,
                                          (GBoxedFreeFunc) qmi_indication_nas_event_report_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiIndicationNasEventReportOutput *
qmi_indication_nas_event_report_output_ref (QmiIndicationNasEventReportOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_indication_nas_event_report_output_unref (QmiIndicationNasEventReportOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_rf_band_information, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_rf_band_information, (GDestroyNotify)g_ptr_array_unref);
        g_slice_free (QmiIndicationNasEventReportOutput, self);
    }
}

static gchar *
qmi_indication_nas_event_report_output_lte_rsrp_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_LTE_RSRP, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        gint16 tmp;

        if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT16_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_event_report_output_lte_snr_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_LTE_SNR, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        gint16 tmp;

        if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT16_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_event_report_output_rsrq_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_RSRQ, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " rsrq = '");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%d", (gint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " radio_interface = '");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_RADIO_INTERFACE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_radio_interface_get_string ((QmiNasRadioInterface)tmp));
#elif defined  __QMI_NAS_RADIO_INTERFACE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_radio_interface_build_string_from_mask ((QmiNasRadioInterface)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRadioInterface
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_event_report_output_error_rate_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_ERROR_RATE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " rate = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " radio_interface = '");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_RADIO_INTERFACE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_radio_interface_get_string ((QmiNasRadioInterface)tmp));
#elif defined  __QMI_NAS_RADIO_INTERFACE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_radio_interface_build_string_from_mask ((QmiNasRadioInterface)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRadioInterface
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_event_report_output_sinr_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_SINR, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_EVDO_SINR_LEVEL_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_evdo_sinr_level_get_string ((QmiNasEvdoSinrLevel)tmp));
#elif defined  __QMI_NAS_EVDO_SINR_LEVEL_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_evdo_sinr_level_build_string_from_mask ((QmiNasEvdoSinrLevel)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasEvdoSinrLevel
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_event_report_output_io_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_IO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        gint32 tmp;

        if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_event_report_output_ecio_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_ECIO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " ecio = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " radio_interface = '");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_RADIO_INTERFACE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_radio_interface_get_string ((QmiNasRadioInterface)tmp));
#elif defined  __QMI_NAS_RADIO_INTERFACE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_radio_interface_build_string_from_mask ((QmiNasRadioInterface)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRadioInterface
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_event_report_output_rssi_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_RSSI, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " rssi = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " radio_interface = '");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_RADIO_INTERFACE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_radio_interface_get_string ((QmiNasRadioInterface)tmp));
#elif defined  __QMI_NAS_RADIO_INTERFACE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_radio_interface_build_string_from_mask ((QmiNasRadioInterface)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRadioInterface
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_event_report_output_registration_reject_reason_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_REGISTRATION_REJECT_REASON, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " service_domain = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " reject_cause = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_event_report_output_rf_band_information_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_RF_BAND_INFORMATION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint rf_band_information_i;
        guint8 rf_band_information_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(rf_band_information_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (rf_band_information_i = 0; rf_band_information_i < rf_band_information_n_items; rf_band_information_i++) {
            g_string_append_printf (printable, " [%u] = '", rf_band_information_i);
            g_string_append (printable, "[");
            g_string_append (printable, " radio_interface = '");

            {
                gint8 tmp;

                if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_NAS_RADIO_INTERFACE_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_nas_radio_interface_get_string ((QmiNasRadioInterface)tmp));
#elif defined  __QMI_NAS_RADIO_INTERFACE_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_nas_radio_interface_build_string_from_mask ((QmiNasRadioInterface)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiNasRadioInterface
#endif
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " active_band_class = '");

            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_NAS_ACTIVE_BAND_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_nas_active_band_get_string ((QmiNasActiveBand)tmp));
#elif defined  __QMI_NAS_ACTIVE_BAND_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_nas_active_band_build_string_from_mask ((QmiNasActiveBand)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiNasActiveBand
#endif
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " active_channel = '");

            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " ]");
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_event_report_output_signal_strength_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_SIGNAL_STRENGTH, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " strength = '");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%d", (gint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " radio_interface = '");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_RADIO_INTERFACE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_radio_interface_get_string ((QmiNasRadioInterface)tmp));
#elif defined  __QMI_NAS_RADIO_INTERFACE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_radio_interface_build_string_from_mask ((QmiNasRadioInterface)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRadioInterface
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct indication_event_report_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
indication_event_report_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct indication_event_report_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    {
        switch (type) {
        case QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_LTE_RSRP:
            tlv_type_str = "LTE RSRP";
            translated_value = qmi_indication_nas_event_report_output_lte_rsrp_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_LTE_SNR:
            tlv_type_str = "LTE SNR";
            translated_value = qmi_indication_nas_event_report_output_lte_snr_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_RSRQ:
            tlv_type_str = "RSRQ";
            translated_value = qmi_indication_nas_event_report_output_rsrq_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_ERROR_RATE:
            tlv_type_str = "Error Rate";
            translated_value = qmi_indication_nas_event_report_output_error_rate_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_SINR:
            tlv_type_str = "SINR";
            translated_value = qmi_indication_nas_event_report_output_sinr_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_IO:
            tlv_type_str = "IO";
            translated_value = qmi_indication_nas_event_report_output_io_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_ECIO:
            tlv_type_str = "ECIO";
            translated_value = qmi_indication_nas_event_report_output_ecio_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_RSSI:
            tlv_type_str = "RSSI";
            translated_value = qmi_indication_nas_event_report_output_rssi_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_REGISTRATION_REJECT_REASON:
            tlv_type_str = "Registration Reject Reason";
            translated_value = qmi_indication_nas_event_report_output_registration_reject_reason_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_RF_BAND_INFORMATION:
            tlv_type_str = "RF Band Information";
            translated_value = qmi_indication_nas_event_report_output_rf_band_information_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_SIGNAL_STRENGTH:
            tlv_type_str = "Signal Strength";
            translated_value = qmi_indication_nas_event_report_output_signal_strength_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
indication_event_report_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Event Report\" (0x0002)\n",
                            line_prefix);

    {
        struct indication_event_report_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)indication_event_report_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiIndicationNasEventReportOutput *
qmi_indication_nas_event_report_indication_parse (
    QmiMessage *message,
    GError **error)
{
    QmiIndicationNasEventReportOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_INDICATION_NAS_EVENT_REPORT);

    self = g_slice_new0 (QmiIndicationNasEventReportOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_LTE_RSRP, NULL, NULL)) == 0) {
                goto qmi_indication_nas_event_report_output_lte_rsrp_out;
            }
            if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_lte_rsrp), NULL))
                goto qmi_indication_nas_event_report_output_lte_rsrp_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'LTE RSRP' TLV", offset);
            }

            self->arg_lte_rsrp_set = TRUE;

qmi_indication_nas_event_report_output_lte_rsrp_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_LTE_SNR, NULL, NULL)) == 0) {
                goto qmi_indication_nas_event_report_output_lte_snr_out;
            }
            if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_lte_snr), NULL))
                goto qmi_indication_nas_event_report_output_lte_snr_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'LTE SNR' TLV", offset);
            }

            self->arg_lte_snr_set = TRUE;

qmi_indication_nas_event_report_output_lte_snr_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_RSRQ, NULL, NULL)) == 0) {
                goto qmi_indication_nas_event_report_output_rsrq_out;
            }
            if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &(self->arg_rsrq_rsrq), NULL))
                goto qmi_indication_nas_event_report_output_rsrq_out;
            {
                gint8 tmp;

                if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_event_report_output_rsrq_out;
                self->arg_rsrq_radio_interface = (QmiNasRadioInterface)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'RSRQ' TLV", offset);
            }

            self->arg_rsrq_set = TRUE;

qmi_indication_nas_event_report_output_rsrq_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_ERROR_RATE, NULL, NULL)) == 0) {
                goto qmi_indication_nas_event_report_output_error_rate_out;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_error_rate_rate), NULL))
                goto qmi_indication_nas_event_report_output_error_rate_out;
            {
                gint8 tmp;

                if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_event_report_output_error_rate_out;
                self->arg_error_rate_radio_interface = (QmiNasRadioInterface)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Error Rate' TLV", offset);
            }

            self->arg_error_rate_set = TRUE;

qmi_indication_nas_event_report_output_error_rate_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_SINR, NULL, NULL)) == 0) {
                goto qmi_indication_nas_event_report_output_sinr_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_event_report_output_sinr_out;
                self->arg_sinr = (QmiNasEvdoSinrLevel)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'SINR' TLV", offset);
            }

            self->arg_sinr_set = TRUE;

qmi_indication_nas_event_report_output_sinr_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_IO, NULL, NULL)) == 0) {
                goto qmi_indication_nas_event_report_output_io_out;
            }
            if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_io), NULL))
                goto qmi_indication_nas_event_report_output_io_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'IO' TLV", offset);
            }

            self->arg_io_set = TRUE;

qmi_indication_nas_event_report_output_io_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_ECIO, NULL, NULL)) == 0) {
                goto qmi_indication_nas_event_report_output_ecio_out;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_ecio_ecio), NULL))
                goto qmi_indication_nas_event_report_output_ecio_out;
            {
                gint8 tmp;

                if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_event_report_output_ecio_out;
                self->arg_ecio_radio_interface = (QmiNasRadioInterface)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'ECIO' TLV", offset);
            }

            self->arg_ecio_set = TRUE;

qmi_indication_nas_event_report_output_ecio_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_RSSI, NULL, NULL)) == 0) {
                goto qmi_indication_nas_event_report_output_rssi_out;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_rssi_rssi), NULL))
                goto qmi_indication_nas_event_report_output_rssi_out;
            {
                gint8 tmp;

                if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_event_report_output_rssi_out;
                self->arg_rssi_radio_interface = (QmiNasRadioInterface)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'RSSI' TLV", offset);
            }

            self->arg_rssi_set = TRUE;

qmi_indication_nas_event_report_output_rssi_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_REGISTRATION_REJECT_REASON, NULL, NULL)) == 0) {
                goto qmi_indication_nas_event_report_output_registration_reject_reason_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_event_report_output_registration_reject_reason_out;
                self->arg_registration_reject_reason_service_domain = (QmiNasNetworkServiceDomain)tmp;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_registration_reject_reason_reject_cause), NULL))
                goto qmi_indication_nas_event_report_output_registration_reject_reason_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Registration Reject Reason' TLV", offset);
            }

            self->arg_registration_reject_reason_set = TRUE;

qmi_indication_nas_event_report_output_registration_reject_reason_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_RF_BAND_INFORMATION, NULL, NULL)) == 0) {
                goto qmi_indication_nas_event_report_output_rf_band_information_out;
            }
            {
                guint rf_band_information_i;
                guint8 rf_band_information_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(rf_band_information_n_items), NULL))
                    goto qmi_indication_nas_event_report_output_rf_band_information_out;

                self->arg_rf_band_information = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (QmiIndicationNasEventReportOutputRfBandInformationElement),
                    (guint)rf_band_information_n_items);

                for (rf_band_information_i = 0; rf_band_information_i < rf_band_information_n_items; rf_band_information_i++) {
                    QmiIndicationNasEventReportOutputRfBandInformationElement rf_band_information_aux;

                    {
                        gint8 tmp;

                        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, NULL))
                            goto qmi_indication_nas_event_report_output_rf_band_information_out;
                        rf_band_information_aux.radio_interface = (QmiNasRadioInterface)tmp;
                    }
                    {
                        guint16 tmp;

                        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                            goto qmi_indication_nas_event_report_output_rf_band_information_out;
                        rf_band_information_aux.active_band_class = (QmiNasActiveBand)tmp;
                    }
                    if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(rf_band_information_aux.active_channel), NULL))
                        goto qmi_indication_nas_event_report_output_rf_band_information_out;
                    g_array_insert_val (self->arg_rf_band_information, rf_band_information_i, rf_band_information_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'RF Band Information' TLV", offset);
            }

            self->arg_rf_band_information_set = TRUE;

qmi_indication_nas_event_report_output_rf_band_information_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_EVENT_REPORT_OUTPUT_TLV_SIGNAL_STRENGTH, NULL, NULL)) == 0) {
                goto qmi_indication_nas_event_report_output_signal_strength_out;
            }
            if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &(self->arg_signal_strength_strength), NULL))
                goto qmi_indication_nas_event_report_output_signal_strength_out;
            {
                gint8 tmp;

                if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_event_report_output_signal_strength_out;
                self->arg_signal_strength_radio_interface = (QmiNasRadioInterface)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Signal Strength' TLV", offset);
            }

            self->arg_signal_strength_set = TRUE;

qmi_indication_nas_event_report_output_signal_strength_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* INDICATION: Qmi Indication NAS Serving System */


/* --- Output -- */

static void
__qmi_indication_nas_serving_system_output_roaming_indicator_list_element_free (QmiIndicationNasServingSystemOutputRoamingIndicatorListElement *value)
{
    g_slice_free (QmiIndicationNasServingSystemOutputRoamingIndicatorListElement, value);
}

static QmiIndicationNasServingSystemOutputRoamingIndicatorListElement *
__qmi_indication_nas_serving_system_output_roaming_indicator_list_element_new (void)
{
    return g_slice_new0 (QmiIndicationNasServingSystemOutputRoamingIndicatorListElement);
}

static QmiIndicationNasServingSystemOutputRoamingIndicatorListElement *
__qmi_indication_nas_serving_system_output_roaming_indicator_list_element_copy (const QmiIndicationNasServingSystemOutputRoamingIndicatorListElement *value)
{
    QmiIndicationNasServingSystemOutputRoamingIndicatorListElement *copy;

    copy = __qmi_indication_nas_serving_system_output_roaming_indicator_list_element_new ();
    copy->radio_interface = value->radio_interface;
    copy->roaming_indicator = value->roaming_indicator;
    return copy;
}

G_DEFINE_BOXED_TYPE (QmiIndicationNasServingSystemOutputRoamingIndicatorListElement, qmi_indication_nas_serving_system_output_roaming_indicator_list_element, (GBoxedCopyFunc)__qmi_indication_nas_serving_system_output_roaming_indicator_list_element_copy, (GBoxedFreeFunc)__qmi_indication_nas_serving_system_output_roaming_indicator_list_element_free)

struct _QmiIndicationNasServingSystemOutput {
    volatile gint ref_count;

    /* Network Name Source */
    gboolean arg_network_name_source_set;
    guint32 arg_network_name_source;

    /* MNC PCS Digit Include Status */
    gboolean arg_mnc_pcs_digit_include_status_set;
    guint16 arg_mnc_pcs_digit_include_status_mcc;
    guint16 arg_mnc_pcs_digit_include_status_mnc;
    guint8 arg_mnc_pcs_digit_include_status_includes_pcs_digit;

    /* UMTS Primary Scrambling Code */
    gboolean arg_umts_primary_scrambling_code_set;
    guint16 arg_umts_primary_scrambling_code;

    /* PLMN Not Changed Indication */
    gboolean arg_plmn_not_changed_indication_set;
    guint8 arg_plmn_not_changed_indication;

    /* Call Barring Status */
    gboolean arg_call_barring_status_set;
    gint32 arg_call_barring_status_cs_status;
    gint32 arg_call_barring_status_ps_status;

    /* LTE TAC */
    gboolean arg_lte_tac_set;
    guint16 arg_lte_tac;

    /* HDR Personality */
    gboolean arg_hdr_personality_set;
    guint8 arg_hdr_personality;

    /* CDMA System Info */
    gboolean arg_cdma_system_info_set;
    guint16 arg_cdma_system_info_mcc;
    guint8 arg_cdma_system_info_imsi_11_12;

    /* Detailed Service Status */
    gboolean arg_detailed_service_status_set;
    guint8 arg_detailed_service_status_status;
    guint8 arg_detailed_service_status_capability;
    guint8 arg_detailed_service_status_hdr_status;
    guint8 arg_detailed_service_status_hdr_hybrid;
    guint8 arg_detailed_service_status_forbidden;

    /* DTM Support */
    gboolean arg_dtm_support_set;
    guint8 arg_dtm_support;

    /* PRL Indicator 3GPP2 */
    gboolean arg_prl_indicator_3gpp2_set;
    guint8 arg_prl_indicator_3gpp2;

    /* Concurrent Service Info 3GPP2 */
    gboolean arg_concurrent_service_info_3gpp2_set;
    guint8 arg_concurrent_service_info_3gpp2;

    /* CID 3GPP */
    gboolean arg_cid_3gpp_set;
    guint32 arg_cid_3gpp;

    /* LAC 3GPP */
    gboolean arg_lac_3gpp_set;
    guint16 arg_lac_3gpp;

    /* Universal Time and Local Time Zone 3GPP */
    gboolean arg_universal_time_and_local_time_zone_3gpp_set;
    guint16 arg_universal_time_and_local_time_zone_3gpp_year;
    guint8 arg_universal_time_and_local_time_zone_3gpp_month;
    guint8 arg_universal_time_and_local_time_zone_3gpp_day;
    guint8 arg_universal_time_and_local_time_zone_3gpp_hour;
    guint8 arg_universal_time_and_local_time_zone_3gpp_minute;
    guint8 arg_universal_time_and_local_time_zone_3gpp_second;
    guint8 arg_universal_time_and_local_time_zone_3gpp_time_zone;

    /* Daylight Saving Time Adjustment 3GPP */
    gboolean arg_daylight_saving_time_adjustment_3gpp_set;
    guint8 arg_daylight_saving_time_adjustment_3gpp;

    /* Time Zone 3GPP */
    gboolean arg_time_zone_3gpp_set;
    gint8 arg_time_zone_3gpp;

    /* PLMN Name Flag 3GPP */
    gboolean arg_plmn_name_flag_3gpp_set;
    gint8 arg_plmn_name_flag_3gpp;

    /* CDMA P Rev */
    gboolean arg_cdma_p_rev_set;
    guint8 arg_cdma_p_rev;

    /* Time Zone 3GPP2 */
    gboolean arg_time_zone_3gpp2_set;
    guint8 arg_time_zone_3gpp2_leap_seconds;
    gint8 arg_time_zone_3gpp2_local_time_offset;
    guint8 arg_time_zone_3gpp2_daylight_saving_time;

    /* Default Roaming Indicator */
    gboolean arg_default_roaming_indicator_set;
    guint8 arg_default_roaming_indicator;

    /* Roaming Indicator List */
    gboolean arg_roaming_indicator_list_set;
    GArray *arg_roaming_indicator_list;
    GPtrArray *arg_roaming_indicator_list_ptr;

    /* CDMA Base Station Info */
    gboolean arg_cdma_base_station_info_set;
    guint16 arg_cdma_base_station_info_base_station_id;
    gint32 arg_cdma_base_station_info_base_station_latitude;
    gint32 arg_cdma_base_station_info_base_station_longitude;

    /* CDMA System ID */
    gboolean arg_cdma_system_id_set;
    guint16 arg_cdma_system_id_sid;
    guint16 arg_cdma_system_id_nid;

    /* Current PLMN */
    gboolean arg_current_plmn_set;
    guint16 arg_current_plmn_mcc;
    guint16 arg_current_plmn_mnc;
    gchar *arg_current_plmn_description;

    /* Data Service Capability */
    gboolean arg_data_service_capability_set;
    GArray *arg_data_service_capability;

    /* Roaming Indicator */
    gboolean arg_roaming_indicator_set;
    guint8 arg_roaming_indicator;

    /* Serving System */
    gboolean arg_serving_system_set;
    guint8 arg_serving_system_registration_state;
    guint8 arg_serving_system_cs_attach_state;
    guint8 arg_serving_system_ps_attach_state;
    guint8 arg_serving_system_selected_network;
    GArray *arg_serving_system_radio_interfaces;
};

#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_NETWORK_NAME_SOURCE 0x2B
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_MNC_PCS_DIGIT_INCLUDE_STATUS 0x29
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_UMTS_PRIMARY_SCRAMBLING_CODE 0x28
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_PLMN_NOT_CHANGED_INDICATION 0x27
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CALL_BARRING_STATUS 0x26
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_LTE_TAC 0x25
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_HDR_PERSONALITY 0x24
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CDMA_SYSTEM_INFO 0x23
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_DETAILED_SERVICE_STATUS 0x22
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_DTM_SUPPORT 0x21
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_PRL_INDICATOR_3GPP2 0x20
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CONCURRENT_SERVICE_INFO_3GPP2 0x1F
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CID_3GPP 0x1E
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_LAC_3GPP 0x1D
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_UNIVERSAL_TIME_AND_LOCAL_TIME_ZONE_3GPP 0x1C
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_DAYLIGHT_SAVING_TIME_ADJUSTMENT_3GPP 0x1B
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_TIME_ZONE_3GPP 0x1A
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_PLMN_NAME_FLAG_3GPP 0x19
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CDMA_P_REV 0x18
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_TIME_ZONE_3GPP2 0x17
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_DEFAULT_ROAMING_INDICATOR 0x16
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_ROAMING_INDICATOR_LIST 0x15
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CDMA_BASE_STATION_INFO 0x14
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CDMA_SYSTEM_ID 0x13
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CURRENT_PLMN 0x12
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_DATA_SERVICE_CAPABILITY 0x11
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_ROAMING_INDICATOR 0x10
#define QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_SERVING_SYSTEM 0x01

gboolean
qmi_indication_nas_serving_system_output_get_network_name_source (
    QmiIndicationNasServingSystemOutput *self,
    QmiNasNetworkNameSource *value_network_name_source,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_network_name_source_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Network Name Source' was not found in the message");
        return FALSE;
    }

    if (value_network_name_source)
        *value_network_name_source = (QmiNasNetworkNameSource)(self->arg_network_name_source);

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_mnc_pcs_digit_include_status (
    QmiIndicationNasServingSystemOutput *self,
    guint16 *value_mnc_pcs_digit_include_status_mcc,
    guint16 *value_mnc_pcs_digit_include_status_mnc,
    gboolean *value_mnc_pcs_digit_include_status_includes_pcs_digit,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_mnc_pcs_digit_include_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'MNC PCS Digit Include Status' was not found in the message");
        return FALSE;
    }

    if (value_mnc_pcs_digit_include_status_mcc)
        *value_mnc_pcs_digit_include_status_mcc = self->arg_mnc_pcs_digit_include_status_mcc;
    if (value_mnc_pcs_digit_include_status_mnc)
        *value_mnc_pcs_digit_include_status_mnc = self->arg_mnc_pcs_digit_include_status_mnc;
    if (value_mnc_pcs_digit_include_status_includes_pcs_digit)
        *value_mnc_pcs_digit_include_status_includes_pcs_digit = (gboolean)(self->arg_mnc_pcs_digit_include_status_includes_pcs_digit);

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_umts_primary_scrambling_code (
    QmiIndicationNasServingSystemOutput *self,
    guint16 *value_umts_primary_scrambling_code,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_umts_primary_scrambling_code_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'UMTS Primary Scrambling Code' was not found in the message");
        return FALSE;
    }

    if (value_umts_primary_scrambling_code)
        *value_umts_primary_scrambling_code = self->arg_umts_primary_scrambling_code;

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_plmn_not_changed_indication (
    QmiIndicationNasServingSystemOutput *self,
    gboolean *value_plmn_not_changed_indication,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_plmn_not_changed_indication_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PLMN Not Changed Indication' was not found in the message");
        return FALSE;
    }

    if (value_plmn_not_changed_indication)
        *value_plmn_not_changed_indication = (gboolean)(self->arg_plmn_not_changed_indication);

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_call_barring_status (
    QmiIndicationNasServingSystemOutput *self,
    QmiNasCallBarringStatus *value_call_barring_status_cs_status,
    QmiNasCallBarringStatus *value_call_barring_status_ps_status,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_call_barring_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Call Barring Status' was not found in the message");
        return FALSE;
    }

    if (value_call_barring_status_cs_status)
        *value_call_barring_status_cs_status = (QmiNasCallBarringStatus)(self->arg_call_barring_status_cs_status);
    if (value_call_barring_status_ps_status)
        *value_call_barring_status_ps_status = (QmiNasCallBarringStatus)(self->arg_call_barring_status_ps_status);

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_lte_tac (
    QmiIndicationNasServingSystemOutput *self,
    guint16 *value_lte_tac,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_lte_tac_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'LTE TAC' was not found in the message");
        return FALSE;
    }

    if (value_lte_tac)
        *value_lte_tac = self->arg_lte_tac;

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_hdr_personality (
    QmiIndicationNasServingSystemOutput *self,
    QmiNasHdrPersonality *value_hdr_personality,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_hdr_personality_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'HDR Personality' was not found in the message");
        return FALSE;
    }

    if (value_hdr_personality)
        *value_hdr_personality = (QmiNasHdrPersonality)(self->arg_hdr_personality);

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_cdma_system_info (
    QmiIndicationNasServingSystemOutput *self,
    guint16 *value_cdma_system_info_mcc,
    guint8 *value_cdma_system_info_imsi_11_12,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_cdma_system_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'CDMA System Info' was not found in the message");
        return FALSE;
    }

    if (value_cdma_system_info_mcc)
        *value_cdma_system_info_mcc = self->arg_cdma_system_info_mcc;
    if (value_cdma_system_info_imsi_11_12)
        *value_cdma_system_info_imsi_11_12 = self->arg_cdma_system_info_imsi_11_12;

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_detailed_service_status (
    QmiIndicationNasServingSystemOutput *self,
    QmiNasServiceStatus *value_detailed_service_status_status,
    QmiNasNetworkServiceDomain *value_detailed_service_status_capability,
    QmiNasServiceStatus *value_detailed_service_status_hdr_status,
    gboolean *value_detailed_service_status_hdr_hybrid,
    gboolean *value_detailed_service_status_forbidden,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_detailed_service_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Detailed Service Status' was not found in the message");
        return FALSE;
    }

    if (value_detailed_service_status_status)
        *value_detailed_service_status_status = (QmiNasServiceStatus)(self->arg_detailed_service_status_status);
    if (value_detailed_service_status_capability)
        *value_detailed_service_status_capability = (QmiNasNetworkServiceDomain)(self->arg_detailed_service_status_capability);
    if (value_detailed_service_status_hdr_status)
        *value_detailed_service_status_hdr_status = (QmiNasServiceStatus)(self->arg_detailed_service_status_hdr_status);
    if (value_detailed_service_status_hdr_hybrid)
        *value_detailed_service_status_hdr_hybrid = (gboolean)(self->arg_detailed_service_status_hdr_hybrid);
    if (value_detailed_service_status_forbidden)
        *value_detailed_service_status_forbidden = (gboolean)(self->arg_detailed_service_status_forbidden);

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_dtm_support (
    QmiIndicationNasServingSystemOutput *self,
    gboolean *value_dtm_support,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_dtm_support_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'DTM Support' was not found in the message");
        return FALSE;
    }

    if (value_dtm_support)
        *value_dtm_support = (gboolean)(self->arg_dtm_support);

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_prl_indicator_3gpp2 (
    QmiIndicationNasServingSystemOutput *self,
    gboolean *value_prl_indicator_3gpp2,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_prl_indicator_3gpp2_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PRL Indicator 3GPP2' was not found in the message");
        return FALSE;
    }

    if (value_prl_indicator_3gpp2)
        *value_prl_indicator_3gpp2 = (gboolean)(self->arg_prl_indicator_3gpp2);

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_concurrent_service_info_3gpp2 (
    QmiIndicationNasServingSystemOutput *self,
    gboolean *value_concurrent_service_info_3gpp2,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_concurrent_service_info_3gpp2_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Concurrent Service Info 3GPP2' was not found in the message");
        return FALSE;
    }

    if (value_concurrent_service_info_3gpp2)
        *value_concurrent_service_info_3gpp2 = (gboolean)(self->arg_concurrent_service_info_3gpp2);

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_cid_3gpp (
    QmiIndicationNasServingSystemOutput *self,
    guint32 *value_cid_3gpp,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_cid_3gpp_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'CID 3GPP' was not found in the message");
        return FALSE;
    }

    if (value_cid_3gpp)
        *value_cid_3gpp = self->arg_cid_3gpp;

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_lac_3gpp (
    QmiIndicationNasServingSystemOutput *self,
    guint16 *value_lac_3gpp,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_lac_3gpp_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'LAC 3GPP' was not found in the message");
        return FALSE;
    }

    if (value_lac_3gpp)
        *value_lac_3gpp = self->arg_lac_3gpp;

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_universal_time_and_local_time_zone_3gpp (
    QmiIndicationNasServingSystemOutput *self,
    guint16 *value_universal_time_and_local_time_zone_3gpp_year,
    guint8 *value_universal_time_and_local_time_zone_3gpp_month,
    guint8 *value_universal_time_and_local_time_zone_3gpp_day,
    guint8 *value_universal_time_and_local_time_zone_3gpp_hour,
    guint8 *value_universal_time_and_local_time_zone_3gpp_minute,
    guint8 *value_universal_time_and_local_time_zone_3gpp_second,
    guint8 *value_universal_time_and_local_time_zone_3gpp_time_zone,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_universal_time_and_local_time_zone_3gpp_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Universal Time and Local Time Zone 3GPP' was not found in the message");
        return FALSE;
    }

    if (value_universal_time_and_local_time_zone_3gpp_year)
        *value_universal_time_and_local_time_zone_3gpp_year = self->arg_universal_time_and_local_time_zone_3gpp_year;
    if (value_universal_time_and_local_time_zone_3gpp_month)
        *value_universal_time_and_local_time_zone_3gpp_month = self->arg_universal_time_and_local_time_zone_3gpp_month;
    if (value_universal_time_and_local_time_zone_3gpp_day)
        *value_universal_time_and_local_time_zone_3gpp_day = self->arg_universal_time_and_local_time_zone_3gpp_day;
    if (value_universal_time_and_local_time_zone_3gpp_hour)
        *value_universal_time_and_local_time_zone_3gpp_hour = self->arg_universal_time_and_local_time_zone_3gpp_hour;
    if (value_universal_time_and_local_time_zone_3gpp_minute)
        *value_universal_time_and_local_time_zone_3gpp_minute = self->arg_universal_time_and_local_time_zone_3gpp_minute;
    if (value_universal_time_and_local_time_zone_3gpp_second)
        *value_universal_time_and_local_time_zone_3gpp_second = self->arg_universal_time_and_local_time_zone_3gpp_second;
    if (value_universal_time_and_local_time_zone_3gpp_time_zone)
        *value_universal_time_and_local_time_zone_3gpp_time_zone = self->arg_universal_time_and_local_time_zone_3gpp_time_zone;

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_daylight_saving_time_adjustment_3gpp (
    QmiIndicationNasServingSystemOutput *self,
    guint8 *value_daylight_saving_time_adjustment_3gpp,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_daylight_saving_time_adjustment_3gpp_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Daylight Saving Time Adjustment 3GPP' was not found in the message");
        return FALSE;
    }

    if (value_daylight_saving_time_adjustment_3gpp)
        *value_daylight_saving_time_adjustment_3gpp = self->arg_daylight_saving_time_adjustment_3gpp;

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_time_zone_3gpp (
    QmiIndicationNasServingSystemOutput *self,
    gint8 *value_time_zone_3gpp,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_time_zone_3gpp_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Time Zone 3GPP' was not found in the message");
        return FALSE;
    }

    if (value_time_zone_3gpp)
        *value_time_zone_3gpp = self->arg_time_zone_3gpp;

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_plmn_name_flag_3gpp (
    QmiIndicationNasServingSystemOutput *self,
    gboolean *value_plmn_name_flag_3gpp,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_plmn_name_flag_3gpp_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PLMN Name Flag 3GPP' was not found in the message");
        return FALSE;
    }

    if (value_plmn_name_flag_3gpp)
        *value_plmn_name_flag_3gpp = (gboolean)(self->arg_plmn_name_flag_3gpp);

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_cdma_p_rev (
    QmiIndicationNasServingSystemOutput *self,
    guint8 *value_cdma_p_rev,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_cdma_p_rev_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'CDMA P Rev' was not found in the message");
        return FALSE;
    }

    if (value_cdma_p_rev)
        *value_cdma_p_rev = self->arg_cdma_p_rev;

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_time_zone_3gpp2 (
    QmiIndicationNasServingSystemOutput *self,
    guint8 *value_time_zone_3gpp2_leap_seconds,
    gint8 *value_time_zone_3gpp2_local_time_offset,
    gboolean *value_time_zone_3gpp2_daylight_saving_time,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_time_zone_3gpp2_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Time Zone 3GPP2' was not found in the message");
        return FALSE;
    }

    if (value_time_zone_3gpp2_leap_seconds)
        *value_time_zone_3gpp2_leap_seconds = self->arg_time_zone_3gpp2_leap_seconds;
    if (value_time_zone_3gpp2_local_time_offset)
        *value_time_zone_3gpp2_local_time_offset = self->arg_time_zone_3gpp2_local_time_offset;
    if (value_time_zone_3gpp2_daylight_saving_time)
        *value_time_zone_3gpp2_daylight_saving_time = (gboolean)(self->arg_time_zone_3gpp2_daylight_saving_time);

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_default_roaming_indicator (
    QmiIndicationNasServingSystemOutput *self,
    QmiNasRoamingIndicatorStatus *value_default_roaming_indicator,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_default_roaming_indicator_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Default Roaming Indicator' was not found in the message");
        return FALSE;
    }

    if (value_default_roaming_indicator)
        *value_default_roaming_indicator = (QmiNasRoamingIndicatorStatus)(self->arg_default_roaming_indicator);

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_roaming_indicator_list (
    QmiIndicationNasServingSystemOutput *self,
    GArray **value_roaming_indicator_list,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_roaming_indicator_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Roaming Indicator List' was not found in the message");
        return FALSE;
    }

    if (value_roaming_indicator_list)
        *value_roaming_indicator_list = self->arg_roaming_indicator_list;

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_roaming_indicator_list_gir (
    QmiIndicationNasServingSystemOutput *self,
    GPtrArray **value_roaming_indicator_list_ptr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_roaming_indicator_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Roaming Indicator List' was not found in the message");
        return FALSE;
    }

    if (value_roaming_indicator_list_ptr) {
        if (!self->arg_roaming_indicator_list_ptr) {
            {
                guint roaming_indicator_list_i;

                self->arg_roaming_indicator_list_ptr = g_ptr_array_new_full (self->arg_roaming_indicator_list->len, (GDestroyNotify)__qmi_indication_nas_serving_system_output_roaming_indicator_list_element_free);
                for (roaming_indicator_list_i = 0; roaming_indicator_list_i < self->arg_roaming_indicator_list->len; roaming_indicator_list_i++) {
                    QmiIndicationNasServingSystemOutputRoamingIndicatorListElement *roaming_indicator_list_aux_from;
                    QmiIndicationNasServingSystemOutputRoamingIndicatorListElement *roaming_indicator_list_aux_to;

                    roaming_indicator_list_aux_from = &g_array_index (self->arg_roaming_indicator_list, QmiIndicationNasServingSystemOutputRoamingIndicatorListElement, roaming_indicator_list_i);

                    roaming_indicator_list_aux_to = __qmi_indication_nas_serving_system_output_roaming_indicator_list_element_new ();
                    roaming_indicator_list_aux_to->radio_interface = (*roaming_indicator_list_aux_from).radio_interface;
                    roaming_indicator_list_aux_to->roaming_indicator = (*roaming_indicator_list_aux_from).roaming_indicator;

                    g_ptr_array_add (self->arg_roaming_indicator_list_ptr, roaming_indicator_list_aux_to);
                }
            }
        }
        *value_roaming_indicator_list_ptr = self->arg_roaming_indicator_list_ptr;
    }
    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_cdma_base_station_info (
    QmiIndicationNasServingSystemOutput *self,
    guint16 *value_cdma_base_station_info_base_station_id,
    gint32 *value_cdma_base_station_info_base_station_latitude,
    gint32 *value_cdma_base_station_info_base_station_longitude,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_cdma_base_station_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'CDMA Base Station Info' was not found in the message");
        return FALSE;
    }

    if (value_cdma_base_station_info_base_station_id)
        *value_cdma_base_station_info_base_station_id = self->arg_cdma_base_station_info_base_station_id;
    if (value_cdma_base_station_info_base_station_latitude)
        *value_cdma_base_station_info_base_station_latitude = self->arg_cdma_base_station_info_base_station_latitude;
    if (value_cdma_base_station_info_base_station_longitude)
        *value_cdma_base_station_info_base_station_longitude = self->arg_cdma_base_station_info_base_station_longitude;

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_cdma_system_id (
    QmiIndicationNasServingSystemOutput *self,
    guint16 *value_cdma_system_id_sid,
    guint16 *value_cdma_system_id_nid,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_cdma_system_id_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'CDMA System ID' was not found in the message");
        return FALSE;
    }

    if (value_cdma_system_id_sid)
        *value_cdma_system_id_sid = self->arg_cdma_system_id_sid;
    if (value_cdma_system_id_nid)
        *value_cdma_system_id_nid = self->arg_cdma_system_id_nid;

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_current_plmn (
    QmiIndicationNasServingSystemOutput *self,
    guint16 *value_current_plmn_mcc,
    guint16 *value_current_plmn_mnc,
    const gchar **value_current_plmn_description,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_current_plmn_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Current PLMN' was not found in the message");
        return FALSE;
    }

    if (value_current_plmn_mcc)
        *value_current_plmn_mcc = self->arg_current_plmn_mcc;
    if (value_current_plmn_mnc)
        *value_current_plmn_mnc = self->arg_current_plmn_mnc;
    if (value_current_plmn_description)
        *value_current_plmn_description = self->arg_current_plmn_description;

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_data_service_capability (
    QmiIndicationNasServingSystemOutput *self,
    GArray **value_data_service_capability,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_data_service_capability_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Data Service Capability' was not found in the message");
        return FALSE;
    }

    if (value_data_service_capability)
        *value_data_service_capability = self->arg_data_service_capability;

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_roaming_indicator (
    QmiIndicationNasServingSystemOutput *self,
    QmiNasRoamingIndicatorStatus *value_roaming_indicator,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_roaming_indicator_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Roaming Indicator' was not found in the message");
        return FALSE;
    }

    if (value_roaming_indicator)
        *value_roaming_indicator = (QmiNasRoamingIndicatorStatus)(self->arg_roaming_indicator);

    return TRUE;
}

gboolean
qmi_indication_nas_serving_system_output_get_serving_system (
    QmiIndicationNasServingSystemOutput *self,
    QmiNasRegistrationState *value_serving_system_registration_state,
    QmiNasAttachState *value_serving_system_cs_attach_state,
    QmiNasAttachState *value_serving_system_ps_attach_state,
    QmiNasNetworkType *value_serving_system_selected_network,
    GArray **value_serving_system_radio_interfaces,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_serving_system_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Serving System' was not found in the message");
        return FALSE;
    }

    if (value_serving_system_registration_state)
        *value_serving_system_registration_state = (QmiNasRegistrationState)(self->arg_serving_system_registration_state);
    if (value_serving_system_cs_attach_state)
        *value_serving_system_cs_attach_state = (QmiNasAttachState)(self->arg_serving_system_cs_attach_state);
    if (value_serving_system_ps_attach_state)
        *value_serving_system_ps_attach_state = (QmiNasAttachState)(self->arg_serving_system_ps_attach_state);
    if (value_serving_system_selected_network)
        *value_serving_system_selected_network = (QmiNasNetworkType)(self->arg_serving_system_selected_network);
    if (value_serving_system_radio_interfaces)
        *value_serving_system_radio_interfaces = self->arg_serving_system_radio_interfaces;

    return TRUE;
}

GType
qmi_indication_nas_serving_system_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiIndicationNasServingSystemOutput"),
                                          (GBoxedCopyFunc) qmi_indication_nas_serving_system_output_ref,
                                          (GBoxedFreeFunc) qmi_indication_nas_serving_system_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiIndicationNasServingSystemOutput *
qmi_indication_nas_serving_system_output_ref (QmiIndicationNasServingSystemOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_indication_nas_serving_system_output_unref (QmiIndicationNasServingSystemOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_roaming_indicator_list, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_roaming_indicator_list, (GDestroyNotify)g_ptr_array_unref);
        g_clear_pointer (&self->arg_current_plmn_description, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_data_service_capability, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_serving_system_radio_interfaces, (GDestroyNotify)g_array_unref);
        g_slice_free (QmiIndicationNasServingSystemOutput, self);
    }
}

static gchar *
qmi_indication_nas_serving_system_output_network_name_source_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_NETWORK_NAME_SOURCE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_NAME_SOURCE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_name_source_get_string ((QmiNasNetworkNameSource)tmp));
#elif defined  __QMI_NAS_NETWORK_NAME_SOURCE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_name_source_build_string_from_mask ((QmiNasNetworkNameSource)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkNameSource
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_mnc_pcs_digit_include_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_MNC_PCS_DIGIT_INCLUDE_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " mcc = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " mnc = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " includes_pcs_digit = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_umts_primary_scrambling_code_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_UMTS_PRIMARY_SCRAMBLING_CODE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_plmn_not_changed_indication_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_PLMN_NOT_CHANGED_INDICATION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_call_barring_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CALL_BARRING_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " cs_status = '");

    {
        gint32 tmp;

        if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_CALL_BARRING_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_call_barring_status_get_string ((QmiNasCallBarringStatus)tmp));
#elif defined  __QMI_NAS_CALL_BARRING_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_call_barring_status_build_string_from_mask ((QmiNasCallBarringStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasCallBarringStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ps_status = '");

    {
        gint32 tmp;

        if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_CALL_BARRING_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_call_barring_status_get_string ((QmiNasCallBarringStatus)tmp));
#elif defined  __QMI_NAS_CALL_BARRING_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_call_barring_status_build_string_from_mask ((QmiNasCallBarringStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasCallBarringStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_lte_tac_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_LTE_TAC, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_hdr_personality_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_HDR_PERSONALITY, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_HDR_PERSONALITY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_hdr_personality_get_string ((QmiNasHdrPersonality)tmp));
#elif defined  __QMI_NAS_HDR_PERSONALITY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_hdr_personality_build_string_from_mask ((QmiNasHdrPersonality)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasHdrPersonality
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_cdma_system_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CDMA_SYSTEM_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " mcc = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " imsi_11_12 = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_detailed_service_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_DETAILED_SERVICE_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_SERVICE_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_service_status_get_string ((QmiNasServiceStatus)tmp));
#elif defined  __QMI_NAS_SERVICE_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_service_status_build_string_from_mask ((QmiNasServiceStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasServiceStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " capability = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " hdr_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_SERVICE_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_service_status_get_string ((QmiNasServiceStatus)tmp));
#elif defined  __QMI_NAS_SERVICE_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_service_status_build_string_from_mask ((QmiNasServiceStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasServiceStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " hdr_hybrid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " forbidden = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_dtm_support_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_DTM_SUPPORT, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_prl_indicator_3gpp2_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_PRL_INDICATOR_3GPP2, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_concurrent_service_info_3gpp2_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CONCURRENT_SERVICE_INFO_3GPP2, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_cid_3gpp_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CID_3GPP, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_lac_3gpp_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_LAC_3GPP, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_universal_time_and_local_time_zone_3gpp_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_UNIVERSAL_TIME_AND_LOCAL_TIME_ZONE_3GPP, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " year = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " month = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " day = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " hour = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " minute = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " second = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " time_zone = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_daylight_saving_time_adjustment_3gpp_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_DAYLIGHT_SAVING_TIME_ADJUSTMENT_3GPP, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_time_zone_3gpp_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_TIME_ZONE_3GPP, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%d", (gint)tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_plmn_name_flag_3gpp_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_PLMN_NAME_FLAG_3GPP, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_cdma_p_rev_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CDMA_P_REV, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_time_zone_3gpp2_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_TIME_ZONE_3GPP2, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " leap_seconds = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " local_time_offset = '");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%d", (gint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " daylight_saving_time = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_default_roaming_indicator_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_DEFAULT_ROAMING_INDICATOR, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_ROAMING_INDICATOR_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_roaming_indicator_status_get_string ((QmiNasRoamingIndicatorStatus)tmp));
#elif defined  __QMI_NAS_ROAMING_INDICATOR_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_roaming_indicator_status_build_string_from_mask ((QmiNasRoamingIndicatorStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRoamingIndicatorStatus
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_roaming_indicator_list_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_ROAMING_INDICATOR_LIST, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint roaming_indicator_list_i;
        guint8 roaming_indicator_list_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(roaming_indicator_list_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (roaming_indicator_list_i = 0; roaming_indicator_list_i < roaming_indicator_list_n_items; roaming_indicator_list_i++) {
            g_string_append_printf (printable, " [%u] = '", roaming_indicator_list_i);
            g_string_append (printable, "[");
            g_string_append (printable, " radio_interface = '");

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_NAS_RADIO_INTERFACE_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_nas_radio_interface_get_string ((QmiNasRadioInterface)tmp));
#elif defined  __QMI_NAS_RADIO_INTERFACE_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_nas_radio_interface_build_string_from_mask ((QmiNasRadioInterface)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiNasRadioInterface
#endif
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " roaming_indicator = '");

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_NAS_ROAMING_INDICATOR_STATUS_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_nas_roaming_indicator_status_get_string ((QmiNasRoamingIndicatorStatus)tmp));
#elif defined  __QMI_NAS_ROAMING_INDICATOR_STATUS_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_nas_roaming_indicator_status_build_string_from_mask ((QmiNasRoamingIndicatorStatus)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiNasRoamingIndicatorStatus
#endif
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " ]");
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_cdma_base_station_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CDMA_BASE_STATION_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " base_station_id = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " base_station_latitude = '");

    {
        gint32 tmp;

        if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " base_station_longitude = '");

    {
        gint32 tmp;

        if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_cdma_system_id_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CDMA_SYSTEM_ID, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " sid = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " nid = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_current_plmn_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CURRENT_PLMN, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " mcc = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " mnc = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " description = '");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_data_service_capability_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_DATA_SERVICE_CAPABILITY, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint data_service_capability_i;
        guint8 data_service_capability_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(data_service_capability_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (data_service_capability_i = 0; data_service_capability_i < data_service_capability_n_items; data_service_capability_i++) {
            g_string_append_printf (printable, " [%u] = '", data_service_capability_i);

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_NAS_DATA_CAPABILITY_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_nas_data_capability_get_string ((QmiNasDataCapability)tmp));
#elif defined  __QMI_NAS_DATA_CAPABILITY_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_nas_data_capability_build_string_from_mask ((QmiNasDataCapability)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiNasDataCapability
#endif
                }
            }
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_roaming_indicator_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_ROAMING_INDICATOR, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_ROAMING_INDICATOR_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_roaming_indicator_status_get_string ((QmiNasRoamingIndicatorStatus)tmp));
#elif defined  __QMI_NAS_ROAMING_INDICATOR_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_roaming_indicator_status_build_string_from_mask ((QmiNasRoamingIndicatorStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRoamingIndicatorStatus
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_serving_system_output_serving_system_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_SERVING_SYSTEM, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " registration_state = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_REGISTRATION_STATE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_registration_state_get_string ((QmiNasRegistrationState)tmp));
#elif defined  __QMI_NAS_REGISTRATION_STATE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_registration_state_build_string_from_mask ((QmiNasRegistrationState)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRegistrationState
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " cs_attach_state = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_ATTACH_STATE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_attach_state_get_string ((QmiNasAttachState)tmp));
#elif defined  __QMI_NAS_ATTACH_STATE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_attach_state_build_string_from_mask ((QmiNasAttachState)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasAttachState
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ps_attach_state = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_ATTACH_STATE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_attach_state_get_string ((QmiNasAttachState)tmp));
#elif defined  __QMI_NAS_ATTACH_STATE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_attach_state_build_string_from_mask ((QmiNasAttachState)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasAttachState
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " selected_network = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_type_get_string ((QmiNasNetworkType)tmp));
#elif defined  __QMI_NAS_NETWORK_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_type_build_string_from_mask ((QmiNasNetworkType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkType
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " radio_interfaces = '");
    {
        guint radio_interfaces_i;
        guint8 radio_interfaces_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(radio_interfaces_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (radio_interfaces_i = 0; radio_interfaces_i < radio_interfaces_n_items; radio_interfaces_i++) {
            g_string_append_printf (printable, " [%u] = '", radio_interfaces_i);

            {
                gint8 tmp;

                if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_NAS_RADIO_INTERFACE_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_nas_radio_interface_get_string ((QmiNasRadioInterface)tmp));
#elif defined  __QMI_NAS_RADIO_INTERFACE_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_nas_radio_interface_build_string_from_mask ((QmiNasRadioInterface)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiNasRadioInterface
#endif
                }
            }
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct indication_serving_system_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
indication_serving_system_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct indication_serving_system_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    {
        switch (type) {
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_NETWORK_NAME_SOURCE:
            tlv_type_str = "Network Name Source";
            translated_value = qmi_indication_nas_serving_system_output_network_name_source_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_MNC_PCS_DIGIT_INCLUDE_STATUS:
            tlv_type_str = "MNC PCS Digit Include Status";
            translated_value = qmi_indication_nas_serving_system_output_mnc_pcs_digit_include_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_UMTS_PRIMARY_SCRAMBLING_CODE:
            tlv_type_str = "UMTS Primary Scrambling Code";
            translated_value = qmi_indication_nas_serving_system_output_umts_primary_scrambling_code_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_PLMN_NOT_CHANGED_INDICATION:
            tlv_type_str = "PLMN Not Changed Indication";
            translated_value = qmi_indication_nas_serving_system_output_plmn_not_changed_indication_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CALL_BARRING_STATUS:
            tlv_type_str = "Call Barring Status";
            translated_value = qmi_indication_nas_serving_system_output_call_barring_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_LTE_TAC:
            tlv_type_str = "LTE TAC";
            translated_value = qmi_indication_nas_serving_system_output_lte_tac_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_HDR_PERSONALITY:
            tlv_type_str = "HDR Personality";
            translated_value = qmi_indication_nas_serving_system_output_hdr_personality_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CDMA_SYSTEM_INFO:
            tlv_type_str = "CDMA System Info";
            translated_value = qmi_indication_nas_serving_system_output_cdma_system_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_DETAILED_SERVICE_STATUS:
            tlv_type_str = "Detailed Service Status";
            translated_value = qmi_indication_nas_serving_system_output_detailed_service_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_DTM_SUPPORT:
            tlv_type_str = "DTM Support";
            translated_value = qmi_indication_nas_serving_system_output_dtm_support_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_PRL_INDICATOR_3GPP2:
            tlv_type_str = "PRL Indicator 3GPP2";
            translated_value = qmi_indication_nas_serving_system_output_prl_indicator_3gpp2_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CONCURRENT_SERVICE_INFO_3GPP2:
            tlv_type_str = "Concurrent Service Info 3GPP2";
            translated_value = qmi_indication_nas_serving_system_output_concurrent_service_info_3gpp2_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CID_3GPP:
            tlv_type_str = "CID 3GPP";
            translated_value = qmi_indication_nas_serving_system_output_cid_3gpp_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_LAC_3GPP:
            tlv_type_str = "LAC 3GPP";
            translated_value = qmi_indication_nas_serving_system_output_lac_3gpp_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_UNIVERSAL_TIME_AND_LOCAL_TIME_ZONE_3GPP:
            tlv_type_str = "Universal Time and Local Time Zone 3GPP";
            translated_value = qmi_indication_nas_serving_system_output_universal_time_and_local_time_zone_3gpp_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_DAYLIGHT_SAVING_TIME_ADJUSTMENT_3GPP:
            tlv_type_str = "Daylight Saving Time Adjustment 3GPP";
            translated_value = qmi_indication_nas_serving_system_output_daylight_saving_time_adjustment_3gpp_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_TIME_ZONE_3GPP:
            tlv_type_str = "Time Zone 3GPP";
            translated_value = qmi_indication_nas_serving_system_output_time_zone_3gpp_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_PLMN_NAME_FLAG_3GPP:
            tlv_type_str = "PLMN Name Flag 3GPP";
            translated_value = qmi_indication_nas_serving_system_output_plmn_name_flag_3gpp_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CDMA_P_REV:
            tlv_type_str = "CDMA P Rev";
            translated_value = qmi_indication_nas_serving_system_output_cdma_p_rev_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_TIME_ZONE_3GPP2:
            tlv_type_str = "Time Zone 3GPP2";
            translated_value = qmi_indication_nas_serving_system_output_time_zone_3gpp2_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_DEFAULT_ROAMING_INDICATOR:
            tlv_type_str = "Default Roaming Indicator";
            translated_value = qmi_indication_nas_serving_system_output_default_roaming_indicator_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_ROAMING_INDICATOR_LIST:
            tlv_type_str = "Roaming Indicator List";
            translated_value = qmi_indication_nas_serving_system_output_roaming_indicator_list_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CDMA_BASE_STATION_INFO:
            tlv_type_str = "CDMA Base Station Info";
            translated_value = qmi_indication_nas_serving_system_output_cdma_base_station_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CDMA_SYSTEM_ID:
            tlv_type_str = "CDMA System ID";
            translated_value = qmi_indication_nas_serving_system_output_cdma_system_id_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CURRENT_PLMN:
            tlv_type_str = "Current PLMN";
            translated_value = qmi_indication_nas_serving_system_output_current_plmn_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_DATA_SERVICE_CAPABILITY:
            tlv_type_str = "Data Service Capability";
            translated_value = qmi_indication_nas_serving_system_output_data_service_capability_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_ROAMING_INDICATOR:
            tlv_type_str = "Roaming Indicator";
            translated_value = qmi_indication_nas_serving_system_output_roaming_indicator_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_SERVING_SYSTEM:
            tlv_type_str = "Serving System";
            translated_value = qmi_indication_nas_serving_system_output_serving_system_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
indication_serving_system_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Serving System\" (0x0024)\n",
                            line_prefix);

    {
        struct indication_serving_system_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)indication_serving_system_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiIndicationNasServingSystemOutput *
qmi_indication_nas_serving_system_indication_parse (
    QmiMessage *message,
    GError **error)
{
    QmiIndicationNasServingSystemOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_INDICATION_NAS_SERVING_SYSTEM);

    self = g_slice_new0 (QmiIndicationNasServingSystemOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_NETWORK_NAME_SOURCE, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_network_name_source_out;
            }
            {
                guint32 tmp;

                if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_nas_serving_system_output_network_name_source_out;
                self->arg_network_name_source = (QmiNasNetworkNameSource)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Network Name Source' TLV", offset);
            }

            self->arg_network_name_source_set = TRUE;

qmi_indication_nas_serving_system_output_network_name_source_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_MNC_PCS_DIGIT_INCLUDE_STATUS, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_mnc_pcs_digit_include_status_out;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_mnc_pcs_digit_include_status_mcc), NULL))
                goto qmi_indication_nas_serving_system_output_mnc_pcs_digit_include_status_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_mnc_pcs_digit_include_status_mnc), NULL))
                goto qmi_indication_nas_serving_system_output_mnc_pcs_digit_include_status_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_serving_system_output_mnc_pcs_digit_include_status_out;
                self->arg_mnc_pcs_digit_include_status_includes_pcs_digit = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'MNC PCS Digit Include Status' TLV", offset);
            }

            self->arg_mnc_pcs_digit_include_status_set = TRUE;

qmi_indication_nas_serving_system_output_mnc_pcs_digit_include_status_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_UMTS_PRIMARY_SCRAMBLING_CODE, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_umts_primary_scrambling_code_out;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_umts_primary_scrambling_code), NULL))
                goto qmi_indication_nas_serving_system_output_umts_primary_scrambling_code_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'UMTS Primary Scrambling Code' TLV", offset);
            }

            self->arg_umts_primary_scrambling_code_set = TRUE;

qmi_indication_nas_serving_system_output_umts_primary_scrambling_code_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_PLMN_NOT_CHANGED_INDICATION, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_plmn_not_changed_indication_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_serving_system_output_plmn_not_changed_indication_out;
                self->arg_plmn_not_changed_indication = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'PLMN Not Changed Indication' TLV", offset);
            }

            self->arg_plmn_not_changed_indication_set = TRUE;

qmi_indication_nas_serving_system_output_plmn_not_changed_indication_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CALL_BARRING_STATUS, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_call_barring_status_out;
            }
            {
                gint32 tmp;

                if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_nas_serving_system_output_call_barring_status_out;
                self->arg_call_barring_status_cs_status = (QmiNasCallBarringStatus)tmp;
            }
            {
                gint32 tmp;

                if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_nas_serving_system_output_call_barring_status_out;
                self->arg_call_barring_status_ps_status = (QmiNasCallBarringStatus)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Call Barring Status' TLV", offset);
            }

            self->arg_call_barring_status_set = TRUE;

qmi_indication_nas_serving_system_output_call_barring_status_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_LTE_TAC, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_lte_tac_out;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_lte_tac), NULL))
                goto qmi_indication_nas_serving_system_output_lte_tac_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'LTE TAC' TLV", offset);
            }

            self->arg_lte_tac_set = TRUE;

qmi_indication_nas_serving_system_output_lte_tac_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_HDR_PERSONALITY, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_hdr_personality_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_serving_system_output_hdr_personality_out;
                self->arg_hdr_personality = (QmiNasHdrPersonality)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'HDR Personality' TLV", offset);
            }

            self->arg_hdr_personality_set = TRUE;

qmi_indication_nas_serving_system_output_hdr_personality_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CDMA_SYSTEM_INFO, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_cdma_system_info_out;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_cdma_system_info_mcc), NULL))
                goto qmi_indication_nas_serving_system_output_cdma_system_info_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_cdma_system_info_imsi_11_12), NULL))
                goto qmi_indication_nas_serving_system_output_cdma_system_info_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'CDMA System Info' TLV", offset);
            }

            self->arg_cdma_system_info_set = TRUE;

qmi_indication_nas_serving_system_output_cdma_system_info_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_DETAILED_SERVICE_STATUS, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_detailed_service_status_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_serving_system_output_detailed_service_status_out;
                self->arg_detailed_service_status_status = (QmiNasServiceStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_serving_system_output_detailed_service_status_out;
                self->arg_detailed_service_status_capability = (QmiNasNetworkServiceDomain)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_serving_system_output_detailed_service_status_out;
                self->arg_detailed_service_status_hdr_status = (QmiNasServiceStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_serving_system_output_detailed_service_status_out;
                self->arg_detailed_service_status_hdr_hybrid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_serving_system_output_detailed_service_status_out;
                self->arg_detailed_service_status_forbidden = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Detailed Service Status' TLV", offset);
            }

            self->arg_detailed_service_status_set = TRUE;

qmi_indication_nas_serving_system_output_detailed_service_status_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_DTM_SUPPORT, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_dtm_support_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_serving_system_output_dtm_support_out;
                self->arg_dtm_support = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'DTM Support' TLV", offset);
            }

            self->arg_dtm_support_set = TRUE;

qmi_indication_nas_serving_system_output_dtm_support_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_PRL_INDICATOR_3GPP2, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_prl_indicator_3gpp2_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_serving_system_output_prl_indicator_3gpp2_out;
                self->arg_prl_indicator_3gpp2 = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'PRL Indicator 3GPP2' TLV", offset);
            }

            self->arg_prl_indicator_3gpp2_set = TRUE;

qmi_indication_nas_serving_system_output_prl_indicator_3gpp2_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CONCURRENT_SERVICE_INFO_3GPP2, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_concurrent_service_info_3gpp2_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_serving_system_output_concurrent_service_info_3gpp2_out;
                self->arg_concurrent_service_info_3gpp2 = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Concurrent Service Info 3GPP2' TLV", offset);
            }

            self->arg_concurrent_service_info_3gpp2_set = TRUE;

qmi_indication_nas_serving_system_output_concurrent_service_info_3gpp2_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CID_3GPP, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_cid_3gpp_out;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_cid_3gpp), NULL))
                goto qmi_indication_nas_serving_system_output_cid_3gpp_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'CID 3GPP' TLV", offset);
            }

            self->arg_cid_3gpp_set = TRUE;

qmi_indication_nas_serving_system_output_cid_3gpp_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_LAC_3GPP, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_lac_3gpp_out;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_lac_3gpp), NULL))
                goto qmi_indication_nas_serving_system_output_lac_3gpp_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'LAC 3GPP' TLV", offset);
            }

            self->arg_lac_3gpp_set = TRUE;

qmi_indication_nas_serving_system_output_lac_3gpp_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_UNIVERSAL_TIME_AND_LOCAL_TIME_ZONE_3GPP, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_universal_time_and_local_time_zone_3gpp_out;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_universal_time_and_local_time_zone_3gpp_year), NULL))
                goto qmi_indication_nas_serving_system_output_universal_time_and_local_time_zone_3gpp_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_universal_time_and_local_time_zone_3gpp_month), NULL))
                goto qmi_indication_nas_serving_system_output_universal_time_and_local_time_zone_3gpp_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_universal_time_and_local_time_zone_3gpp_day), NULL))
                goto qmi_indication_nas_serving_system_output_universal_time_and_local_time_zone_3gpp_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_universal_time_and_local_time_zone_3gpp_hour), NULL))
                goto qmi_indication_nas_serving_system_output_universal_time_and_local_time_zone_3gpp_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_universal_time_and_local_time_zone_3gpp_minute), NULL))
                goto qmi_indication_nas_serving_system_output_universal_time_and_local_time_zone_3gpp_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_universal_time_and_local_time_zone_3gpp_second), NULL))
                goto qmi_indication_nas_serving_system_output_universal_time_and_local_time_zone_3gpp_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_universal_time_and_local_time_zone_3gpp_time_zone), NULL))
                goto qmi_indication_nas_serving_system_output_universal_time_and_local_time_zone_3gpp_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Universal Time and Local Time Zone 3GPP' TLV", offset);
            }

            self->arg_universal_time_and_local_time_zone_3gpp_set = TRUE;

qmi_indication_nas_serving_system_output_universal_time_and_local_time_zone_3gpp_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_DAYLIGHT_SAVING_TIME_ADJUSTMENT_3GPP, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_daylight_saving_time_adjustment_3gpp_out;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_daylight_saving_time_adjustment_3gpp), NULL))
                goto qmi_indication_nas_serving_system_output_daylight_saving_time_adjustment_3gpp_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Daylight Saving Time Adjustment 3GPP' TLV", offset);
            }

            self->arg_daylight_saving_time_adjustment_3gpp_set = TRUE;

qmi_indication_nas_serving_system_output_daylight_saving_time_adjustment_3gpp_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_TIME_ZONE_3GPP, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_time_zone_3gpp_out;
            }
            if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &(self->arg_time_zone_3gpp), NULL))
                goto qmi_indication_nas_serving_system_output_time_zone_3gpp_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Time Zone 3GPP' TLV", offset);
            }

            self->arg_time_zone_3gpp_set = TRUE;

qmi_indication_nas_serving_system_output_time_zone_3gpp_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_PLMN_NAME_FLAG_3GPP, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_plmn_name_flag_3gpp_out;
            }
            {
                gint8 tmp;

                if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_serving_system_output_plmn_name_flag_3gpp_out;
                self->arg_plmn_name_flag_3gpp = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'PLMN Name Flag 3GPP' TLV", offset);
            }

            self->arg_plmn_name_flag_3gpp_set = TRUE;

qmi_indication_nas_serving_system_output_plmn_name_flag_3gpp_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CDMA_P_REV, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_cdma_p_rev_out;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_cdma_p_rev), NULL))
                goto qmi_indication_nas_serving_system_output_cdma_p_rev_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'CDMA P Rev' TLV", offset);
            }

            self->arg_cdma_p_rev_set = TRUE;

qmi_indication_nas_serving_system_output_cdma_p_rev_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_TIME_ZONE_3GPP2, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_time_zone_3gpp2_out;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_time_zone_3gpp2_leap_seconds), NULL))
                goto qmi_indication_nas_serving_system_output_time_zone_3gpp2_out;
            if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &(self->arg_time_zone_3gpp2_local_time_offset), NULL))
                goto qmi_indication_nas_serving_system_output_time_zone_3gpp2_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_serving_system_output_time_zone_3gpp2_out;
                self->arg_time_zone_3gpp2_daylight_saving_time = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Time Zone 3GPP2' TLV", offset);
            }

            self->arg_time_zone_3gpp2_set = TRUE;

qmi_indication_nas_serving_system_output_time_zone_3gpp2_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_DEFAULT_ROAMING_INDICATOR, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_default_roaming_indicator_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_serving_system_output_default_roaming_indicator_out;
                self->arg_default_roaming_indicator = (QmiNasRoamingIndicatorStatus)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Default Roaming Indicator' TLV", offset);
            }

            self->arg_default_roaming_indicator_set = TRUE;

qmi_indication_nas_serving_system_output_default_roaming_indicator_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_ROAMING_INDICATOR_LIST, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_roaming_indicator_list_out;
            }
            {
                guint roaming_indicator_list_i;
                guint8 roaming_indicator_list_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(roaming_indicator_list_n_items), NULL))
                    goto qmi_indication_nas_serving_system_output_roaming_indicator_list_out;

                self->arg_roaming_indicator_list = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (QmiIndicationNasServingSystemOutputRoamingIndicatorListElement),
                    (guint)roaming_indicator_list_n_items);

                for (roaming_indicator_list_i = 0; roaming_indicator_list_i < roaming_indicator_list_n_items; roaming_indicator_list_i++) {
                    QmiIndicationNasServingSystemOutputRoamingIndicatorListElement roaming_indicator_list_aux;

                    {
                        guint8 tmp;

                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                            goto qmi_indication_nas_serving_system_output_roaming_indicator_list_out;
                        roaming_indicator_list_aux.radio_interface = (QmiNasRadioInterface)tmp;
                    }
                    {
                        guint8 tmp;

                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                            goto qmi_indication_nas_serving_system_output_roaming_indicator_list_out;
                        roaming_indicator_list_aux.roaming_indicator = (QmiNasRoamingIndicatorStatus)tmp;
                    }
                    g_array_insert_val (self->arg_roaming_indicator_list, roaming_indicator_list_i, roaming_indicator_list_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Roaming Indicator List' TLV", offset);
            }

            self->arg_roaming_indicator_list_set = TRUE;

qmi_indication_nas_serving_system_output_roaming_indicator_list_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CDMA_BASE_STATION_INFO, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_cdma_base_station_info_out;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_cdma_base_station_info_base_station_id), NULL))
                goto qmi_indication_nas_serving_system_output_cdma_base_station_info_out;
            if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_cdma_base_station_info_base_station_latitude), NULL))
                goto qmi_indication_nas_serving_system_output_cdma_base_station_info_out;
            if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_cdma_base_station_info_base_station_longitude), NULL))
                goto qmi_indication_nas_serving_system_output_cdma_base_station_info_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'CDMA Base Station Info' TLV", offset);
            }

            self->arg_cdma_base_station_info_set = TRUE;

qmi_indication_nas_serving_system_output_cdma_base_station_info_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CDMA_SYSTEM_ID, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_cdma_system_id_out;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_cdma_system_id_sid), NULL))
                goto qmi_indication_nas_serving_system_output_cdma_system_id_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_cdma_system_id_nid), NULL))
                goto qmi_indication_nas_serving_system_output_cdma_system_id_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'CDMA System ID' TLV", offset);
            }

            self->arg_cdma_system_id_set = TRUE;

qmi_indication_nas_serving_system_output_cdma_system_id_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_CURRENT_PLMN, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_current_plmn_out;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_current_plmn_mcc), NULL))
                goto qmi_indication_nas_serving_system_output_current_plmn_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_current_plmn_mnc), NULL))
                goto qmi_indication_nas_serving_system_output_current_plmn_out;
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &(self->arg_current_plmn_description), NULL))
                goto qmi_indication_nas_serving_system_output_current_plmn_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Current PLMN' TLV", offset);
            }

            self->arg_current_plmn_set = TRUE;

qmi_indication_nas_serving_system_output_current_plmn_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_DATA_SERVICE_CAPABILITY, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_data_service_capability_out;
            }
            {
                guint data_service_capability_i;
                guint8 data_service_capability_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(data_service_capability_n_items), NULL))
                    goto qmi_indication_nas_serving_system_output_data_service_capability_out;

                self->arg_data_service_capability = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (QmiNasDataCapability),
                    (guint)data_service_capability_n_items);

                for (data_service_capability_i = 0; data_service_capability_i < data_service_capability_n_items; data_service_capability_i++) {
                    QmiNasDataCapability data_service_capability_aux;

                    {
                        guint8 tmp;

                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                            goto qmi_indication_nas_serving_system_output_data_service_capability_out;
                        data_service_capability_aux = (QmiNasDataCapability)tmp;
                    }
                    g_array_insert_val (self->arg_data_service_capability, data_service_capability_i, data_service_capability_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Data Service Capability' TLV", offset);
            }

            self->arg_data_service_capability_set = TRUE;

qmi_indication_nas_serving_system_output_data_service_capability_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_ROAMING_INDICATOR, NULL, NULL)) == 0) {
                goto qmi_indication_nas_serving_system_output_roaming_indicator_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_serving_system_output_roaming_indicator_out;
                self->arg_roaming_indicator = (QmiNasRoamingIndicatorStatus)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Roaming Indicator' TLV", offset);
            }

            self->arg_roaming_indicator_set = TRUE;

qmi_indication_nas_serving_system_output_roaming_indicator_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SERVING_SYSTEM_OUTPUT_TLV_SERVING_SYSTEM, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Serving System TLV: ");
                qmi_indication_nas_serving_system_output_unref (self);
                return NULL;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                    goto qmi_indication_nas_serving_system_output_serving_system_out;
                self->arg_serving_system_registration_state = (QmiNasRegistrationState)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                    goto qmi_indication_nas_serving_system_output_serving_system_out;
                self->arg_serving_system_cs_attach_state = (QmiNasAttachState)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                    goto qmi_indication_nas_serving_system_output_serving_system_out;
                self->arg_serving_system_ps_attach_state = (QmiNasAttachState)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                    goto qmi_indication_nas_serving_system_output_serving_system_out;
                self->arg_serving_system_selected_network = (QmiNasNetworkType)tmp;
            }
            {
                guint radio_interfaces_i;
                guint8 radio_interfaces_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(radio_interfaces_n_items), error))
                    goto qmi_indication_nas_serving_system_output_serving_system_out;

                self->arg_serving_system_radio_interfaces = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (QmiNasRadioInterface),
                    (guint)radio_interfaces_n_items);

                for (radio_interfaces_i = 0; radio_interfaces_i < radio_interfaces_n_items; radio_interfaces_i++) {
                    QmiNasRadioInterface radio_interfaces_aux;

                    {
                        gint8 tmp;

                        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, error))
                            goto qmi_indication_nas_serving_system_output_serving_system_out;
                        radio_interfaces_aux = (QmiNasRadioInterface)tmp;
                    }
                    g_array_insert_val (self->arg_serving_system_radio_interfaces, radio_interfaces_i, radio_interfaces_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Serving System' TLV", offset);
            }

            self->arg_serving_system_set = TRUE;

qmi_indication_nas_serving_system_output_serving_system_out:
            if (!self->arg_serving_system_set) {
                qmi_indication_nas_serving_system_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* INDICATION: Qmi Indication NAS Operator Name */


/* --- Output -- */

static void
__qmi_indication_nas_operator_name_output_operator_plmn_name_element_clear (QmiIndicationNasOperatorNameOutputOperatorPlmnNameElement *value)
{
    g_clear_pointer (&value->long_name, (GDestroyNotify)g_array_unref);
    g_clear_pointer (&value->short_name, (GDestroyNotify)g_array_unref);
}

static void
__qmi_indication_nas_operator_name_output_operator_plmn_name_element_free (QmiIndicationNasOperatorNameOutputOperatorPlmnNameElement *value)
{
    __qmi_indication_nas_operator_name_output_operator_plmn_name_element_clear (value);
    g_slice_free (QmiIndicationNasOperatorNameOutputOperatorPlmnNameElement, value);
}

static QmiIndicationNasOperatorNameOutputOperatorPlmnNameElement *
__qmi_indication_nas_operator_name_output_operator_plmn_name_element_new (void)
{
    return g_slice_new0 (QmiIndicationNasOperatorNameOutputOperatorPlmnNameElement);
}

static QmiIndicationNasOperatorNameOutputOperatorPlmnNameElement *
__qmi_indication_nas_operator_name_output_operator_plmn_name_element_copy (const QmiIndicationNasOperatorNameOutputOperatorPlmnNameElement *value)
{
    QmiIndicationNasOperatorNameOutputOperatorPlmnNameElement *copy;

    copy = __qmi_indication_nas_operator_name_output_operator_plmn_name_element_new ();
    copy->name_encoding = value->name_encoding;
    copy->short_country_initials = value->short_country_initials;
    copy->long_name_spare_bits = value->long_name_spare_bits;
    copy->short_name_spare_bits = value->short_name_spare_bits;
    copy->long_name = g_array_ref (value->long_name);
    copy->short_name = g_array_ref (value->short_name);
    return copy;
}

G_DEFINE_BOXED_TYPE (QmiIndicationNasOperatorNameOutputOperatorPlmnNameElement, qmi_indication_nas_operator_name_output_operator_plmn_name_element, (GBoxedCopyFunc)__qmi_indication_nas_operator_name_output_operator_plmn_name_element_copy, (GBoxedFreeFunc)__qmi_indication_nas_operator_name_output_operator_plmn_name_element_free)

static void
__qmi_indication_nas_operator_name_output_operator_plmn_list_element_clear (QmiIndicationNasOperatorNameOutputOperatorPlmnListElement *value)
{
    g_clear_pointer (&value->mcc, (GDestroyNotify)g_free);
    g_clear_pointer (&value->mnc, (GDestroyNotify)g_free);
}

static void
__qmi_indication_nas_operator_name_output_operator_plmn_list_element_free (QmiIndicationNasOperatorNameOutputOperatorPlmnListElement *value)
{
    __qmi_indication_nas_operator_name_output_operator_plmn_list_element_clear (value);
    g_slice_free (QmiIndicationNasOperatorNameOutputOperatorPlmnListElement, value);
}

static QmiIndicationNasOperatorNameOutputOperatorPlmnListElement *
__qmi_indication_nas_operator_name_output_operator_plmn_list_element_new (void)
{
    return g_slice_new0 (QmiIndicationNasOperatorNameOutputOperatorPlmnListElement);
}

static QmiIndicationNasOperatorNameOutputOperatorPlmnListElement *
__qmi_indication_nas_operator_name_output_operator_plmn_list_element_copy (const QmiIndicationNasOperatorNameOutputOperatorPlmnListElement *value)
{
    QmiIndicationNasOperatorNameOutputOperatorPlmnListElement *copy;

    copy = __qmi_indication_nas_operator_name_output_operator_plmn_list_element_new ();
    copy->mcc = g_strdup (value->mcc);
    copy->mnc = g_strdup (value->mnc);
    copy->lac1 = value->lac1;
    copy->lac2 = value->lac2;
    copy->plmn_name_record_identifier = value->plmn_name_record_identifier;
    return copy;
}

G_DEFINE_BOXED_TYPE (QmiIndicationNasOperatorNameOutputOperatorPlmnListElement, qmi_indication_nas_operator_name_output_operator_plmn_list_element, (GBoxedCopyFunc)__qmi_indication_nas_operator_name_output_operator_plmn_list_element_copy, (GBoxedFreeFunc)__qmi_indication_nas_operator_name_output_operator_plmn_list_element_free)

struct _QmiIndicationNasOperatorNameOutput {
    volatile gint ref_count;

    /* NITZ Information */
    gboolean arg_nitz_information_set;
    guint8 arg_nitz_information_name_encoding;
    guint8 arg_nitz_information_short_country_initials;
    guint8 arg_nitz_information_long_name_spare_bits;
    guint8 arg_nitz_information_short_name_spare_bits;
    GArray *arg_nitz_information_long_name;
    GArray *arg_nitz_information_short_name;

    /* Operator String Name */
    gboolean arg_operator_string_name_set;
    gchar *arg_operator_string_name;

    /* Operator PLMN Name */
    gboolean arg_operator_plmn_name_set;
    GArray *arg_operator_plmn_name;
    GPtrArray *arg_operator_plmn_name_ptr;

    /* Operator PLMN List */
    gboolean arg_operator_plmn_list_set;
    GArray *arg_operator_plmn_list;
    GPtrArray *arg_operator_plmn_list_ptr;

    /* Service Provider Name */
    gboolean arg_service_provider_name_set;
    guint8 arg_service_provider_name_name_display_condition;
    gchar *arg_service_provider_name_name;
};

#define QMI_INDICATION_NAS_OPERATOR_NAME_OUTPUT_TLV_NITZ_INFORMATION 0x14
#define QMI_INDICATION_NAS_OPERATOR_NAME_OUTPUT_TLV_OPERATOR_STRING_NAME 0x13
#define QMI_INDICATION_NAS_OPERATOR_NAME_OUTPUT_TLV_OPERATOR_PLMN_NAME 0x12
#define QMI_INDICATION_NAS_OPERATOR_NAME_OUTPUT_TLV_OPERATOR_PLMN_LIST 0x11
#define QMI_INDICATION_NAS_OPERATOR_NAME_OUTPUT_TLV_SERVICE_PROVIDER_NAME 0x10

gboolean
qmi_indication_nas_operator_name_output_get_nitz_information (
    QmiIndicationNasOperatorNameOutput *self,
    QmiNasPlmnEncodingScheme *value_nitz_information_name_encoding,
    QmiNasPlmnNameCountryInitials *value_nitz_information_short_country_initials,
    QmiNasPlmnNameSpareBits *value_nitz_information_long_name_spare_bits,
    QmiNasPlmnNameSpareBits *value_nitz_information_short_name_spare_bits,
    GArray **value_nitz_information_long_name,
    GArray **value_nitz_information_short_name,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_nitz_information_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'NITZ Information' was not found in the message");
        return FALSE;
    }

    if (value_nitz_information_name_encoding)
        *value_nitz_information_name_encoding = (QmiNasPlmnEncodingScheme)(self->arg_nitz_information_name_encoding);
    if (value_nitz_information_short_country_initials)
        *value_nitz_information_short_country_initials = (QmiNasPlmnNameCountryInitials)(self->arg_nitz_information_short_country_initials);
    if (value_nitz_information_long_name_spare_bits)
        *value_nitz_information_long_name_spare_bits = (QmiNasPlmnNameSpareBits)(self->arg_nitz_information_long_name_spare_bits);
    if (value_nitz_information_short_name_spare_bits)
        *value_nitz_information_short_name_spare_bits = (QmiNasPlmnNameSpareBits)(self->arg_nitz_information_short_name_spare_bits);
    if (value_nitz_information_long_name)
        *value_nitz_information_long_name = self->arg_nitz_information_long_name;
    if (value_nitz_information_short_name)
        *value_nitz_information_short_name = self->arg_nitz_information_short_name;

    return TRUE;
}

gboolean
qmi_indication_nas_operator_name_output_get_operator_string_name (
    QmiIndicationNasOperatorNameOutput *self,
    const gchar **value_operator_string_name,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_operator_string_name_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Operator String Name' was not found in the message");
        return FALSE;
    }

    if (value_operator_string_name)
        *value_operator_string_name = self->arg_operator_string_name;

    return TRUE;
}

gboolean
qmi_indication_nas_operator_name_output_get_operator_plmn_name (
    QmiIndicationNasOperatorNameOutput *self,
    GArray **value_operator_plmn_name,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_operator_plmn_name_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Operator PLMN Name' was not found in the message");
        return FALSE;
    }

    if (value_operator_plmn_name)
        *value_operator_plmn_name = self->arg_operator_plmn_name;

    return TRUE;
}

gboolean
qmi_indication_nas_operator_name_output_get_operator_plmn_name_gir (
    QmiIndicationNasOperatorNameOutput *self,
    GPtrArray **value_operator_plmn_name_ptr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_operator_plmn_name_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Operator PLMN Name' was not found in the message");
        return FALSE;
    }

    if (value_operator_plmn_name_ptr) {
        if (!self->arg_operator_plmn_name_ptr) {
            {
                guint operator_plmn_name_i;

                self->arg_operator_plmn_name_ptr = g_ptr_array_new_full (self->arg_operator_plmn_name->len, (GDestroyNotify)__qmi_indication_nas_operator_name_output_operator_plmn_name_element_free);
                for (operator_plmn_name_i = 0; operator_plmn_name_i < self->arg_operator_plmn_name->len; operator_plmn_name_i++) {
                    QmiIndicationNasOperatorNameOutputOperatorPlmnNameElement *operator_plmn_name_aux_from;
                    QmiIndicationNasOperatorNameOutputOperatorPlmnNameElement *operator_plmn_name_aux_to;

                    operator_plmn_name_aux_from = &g_array_index (self->arg_operator_plmn_name, QmiIndicationNasOperatorNameOutputOperatorPlmnNameElement, operator_plmn_name_i);

                    operator_plmn_name_aux_to = __qmi_indication_nas_operator_name_output_operator_plmn_name_element_new ();
                    operator_plmn_name_aux_to->name_encoding = (*operator_plmn_name_aux_from).name_encoding;
                    operator_plmn_name_aux_to->short_country_initials = (*operator_plmn_name_aux_from).short_country_initials;
                    operator_plmn_name_aux_to->long_name_spare_bits = (*operator_plmn_name_aux_from).long_name_spare_bits;
                    operator_plmn_name_aux_to->short_name_spare_bits = (*operator_plmn_name_aux_from).short_name_spare_bits;
                    operator_plmn_name_aux_to->long_name = g_array_ref ((*operator_plmn_name_aux_from).long_name);
                    operator_plmn_name_aux_to->short_name = g_array_ref ((*operator_plmn_name_aux_from).short_name);

                    g_ptr_array_add (self->arg_operator_plmn_name_ptr, operator_plmn_name_aux_to);
                }
            }
        }
        *value_operator_plmn_name_ptr = self->arg_operator_plmn_name_ptr;
    }
    return TRUE;
}

gboolean
qmi_indication_nas_operator_name_output_get_operator_plmn_list (
    QmiIndicationNasOperatorNameOutput *self,
    GArray **value_operator_plmn_list,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_operator_plmn_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Operator PLMN List' was not found in the message");
        return FALSE;
    }

    if (value_operator_plmn_list)
        *value_operator_plmn_list = self->arg_operator_plmn_list;

    return TRUE;
}

gboolean
qmi_indication_nas_operator_name_output_get_operator_plmn_list_gir (
    QmiIndicationNasOperatorNameOutput *self,
    GPtrArray **value_operator_plmn_list_ptr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_operator_plmn_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Operator PLMN List' was not found in the message");
        return FALSE;
    }

    if (value_operator_plmn_list_ptr) {
        if (!self->arg_operator_plmn_list_ptr) {
            {
                guint operator_plmn_list_i;

                self->arg_operator_plmn_list_ptr = g_ptr_array_new_full (self->arg_operator_plmn_list->len, (GDestroyNotify)__qmi_indication_nas_operator_name_output_operator_plmn_list_element_free);
                for (operator_plmn_list_i = 0; operator_plmn_list_i < self->arg_operator_plmn_list->len; operator_plmn_list_i++) {
                    QmiIndicationNasOperatorNameOutputOperatorPlmnListElement *operator_plmn_list_aux_from;
                    QmiIndicationNasOperatorNameOutputOperatorPlmnListElement *operator_plmn_list_aux_to;

                    operator_plmn_list_aux_from = &g_array_index (self->arg_operator_plmn_list, QmiIndicationNasOperatorNameOutputOperatorPlmnListElement, operator_plmn_list_i);

                    operator_plmn_list_aux_to = __qmi_indication_nas_operator_name_output_operator_plmn_list_element_new ();
                    operator_plmn_list_aux_to->mcc = g_strdup ((*operator_plmn_list_aux_from).mcc);
                    operator_plmn_list_aux_to->mnc = g_strdup ((*operator_plmn_list_aux_from).mnc);
                    operator_plmn_list_aux_to->lac1 = (*operator_plmn_list_aux_from).lac1;
                    operator_plmn_list_aux_to->lac2 = (*operator_plmn_list_aux_from).lac2;
                    operator_plmn_list_aux_to->plmn_name_record_identifier = (*operator_plmn_list_aux_from).plmn_name_record_identifier;

                    g_ptr_array_add (self->arg_operator_plmn_list_ptr, operator_plmn_list_aux_to);
                }
            }
        }
        *value_operator_plmn_list_ptr = self->arg_operator_plmn_list_ptr;
    }
    return TRUE;
}

gboolean
qmi_indication_nas_operator_name_output_get_service_provider_name (
    QmiIndicationNasOperatorNameOutput *self,
    QmiNasNetworkNameDisplayCondition *value_service_provider_name_name_display_condition,
    const gchar **value_service_provider_name_name,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_service_provider_name_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Service Provider Name' was not found in the message");
        return FALSE;
    }

    if (value_service_provider_name_name_display_condition)
        *value_service_provider_name_name_display_condition = (QmiNasNetworkNameDisplayCondition)(self->arg_service_provider_name_name_display_condition);
    if (value_service_provider_name_name)
        *value_service_provider_name_name = self->arg_service_provider_name_name;

    return TRUE;
}

GType
qmi_indication_nas_operator_name_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiIndicationNasOperatorNameOutput"),
                                          (GBoxedCopyFunc) qmi_indication_nas_operator_name_output_ref,
                                          (GBoxedFreeFunc) qmi_indication_nas_operator_name_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiIndicationNasOperatorNameOutput *
qmi_indication_nas_operator_name_output_ref (QmiIndicationNasOperatorNameOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_indication_nas_operator_name_output_unref (QmiIndicationNasOperatorNameOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_nitz_information_long_name, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_nitz_information_short_name, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_operator_string_name, (GDestroyNotify)g_free);
        g_clear_pointer (&self->arg_operator_plmn_name, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_operator_plmn_name, (GDestroyNotify)g_ptr_array_unref);
        g_clear_pointer (&self->arg_operator_plmn_list, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_operator_plmn_list, (GDestroyNotify)g_ptr_array_unref);
        g_clear_pointer (&self->arg_service_provider_name_name, (GDestroyNotify)g_free);
        g_slice_free (QmiIndicationNasOperatorNameOutput, self);
    }
}

static gchar *
qmi_indication_nas_operator_name_output_nitz_information_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_OPERATOR_NAME_OUTPUT_TLV_NITZ_INFORMATION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " name_encoding = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_PLMN_ENCODING_SCHEME_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_plmn_encoding_scheme_get_string ((QmiNasPlmnEncodingScheme)tmp));
#elif defined  __QMI_NAS_PLMN_ENCODING_SCHEME_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_plmn_encoding_scheme_build_string_from_mask ((QmiNasPlmnEncodingScheme)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasPlmnEncodingScheme
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " short_country_initials = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_PLMN_NAME_COUNTRY_INITIALS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_plmn_name_country_initials_get_string ((QmiNasPlmnNameCountryInitials)tmp));
#elif defined  __QMI_NAS_PLMN_NAME_COUNTRY_INITIALS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_plmn_name_country_initials_build_string_from_mask ((QmiNasPlmnNameCountryInitials)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasPlmnNameCountryInitials
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " long_name_spare_bits = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_PLMN_NAME_SPARE_BITS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_plmn_name_spare_bits_get_string ((QmiNasPlmnNameSpareBits)tmp));
#elif defined  __QMI_NAS_PLMN_NAME_SPARE_BITS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_plmn_name_spare_bits_build_string_from_mask ((QmiNasPlmnNameSpareBits)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasPlmnNameSpareBits
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " short_name_spare_bits = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_PLMN_NAME_SPARE_BITS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_plmn_name_spare_bits_get_string ((QmiNasPlmnNameSpareBits)tmp));
#elif defined  __QMI_NAS_PLMN_NAME_SPARE_BITS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_plmn_name_spare_bits_build_string_from_mask ((QmiNasPlmnNameSpareBits)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasPlmnNameSpareBits
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " long_name = '");
    {
        guint long_name_i;
        guint8 long_name_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(long_name_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (long_name_i = 0; long_name_i < long_name_n_items; long_name_i++) {
            g_string_append_printf (printable, " [%u] = '", long_name_i);

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%u", (guint)tmp);
                }
            }
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }    g_string_append (printable, "'");
    g_string_append (printable, " short_name = '");
    {
        guint short_name_i;
        guint8 short_name_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(short_name_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (short_name_i = 0; short_name_i < short_name_n_items; short_name_i++) {
            g_string_append_printf (printable, " [%u] = '", short_name_i);

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%u", (guint)tmp);
                }
            }
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_operator_name_output_operator_string_name_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_OPERATOR_NAME_OUTPUT_TLV_OPERATOR_STRING_NAME, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_operator_name_output_operator_plmn_name_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_OPERATOR_NAME_OUTPUT_TLV_OPERATOR_PLMN_NAME, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint operator_plmn_name_i;
        guint8 operator_plmn_name_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(operator_plmn_name_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (operator_plmn_name_i = 0; operator_plmn_name_i < operator_plmn_name_n_items; operator_plmn_name_i++) {
            g_string_append_printf (printable, " [%u] = '", operator_plmn_name_i);
            g_string_append (printable, "[");
            g_string_append (printable, " name_encoding = '");

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_NAS_PLMN_ENCODING_SCHEME_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_nas_plmn_encoding_scheme_get_string ((QmiNasPlmnEncodingScheme)tmp));
#elif defined  __QMI_NAS_PLMN_ENCODING_SCHEME_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_nas_plmn_encoding_scheme_build_string_from_mask ((QmiNasPlmnEncodingScheme)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiNasPlmnEncodingScheme
#endif
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " short_country_initials = '");

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_NAS_PLMN_NAME_COUNTRY_INITIALS_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_nas_plmn_name_country_initials_get_string ((QmiNasPlmnNameCountryInitials)tmp));
#elif defined  __QMI_NAS_PLMN_NAME_COUNTRY_INITIALS_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_nas_plmn_name_country_initials_build_string_from_mask ((QmiNasPlmnNameCountryInitials)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiNasPlmnNameCountryInitials
#endif
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " long_name_spare_bits = '");

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_NAS_PLMN_NAME_SPARE_BITS_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_nas_plmn_name_spare_bits_get_string ((QmiNasPlmnNameSpareBits)tmp));
#elif defined  __QMI_NAS_PLMN_NAME_SPARE_BITS_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_nas_plmn_name_spare_bits_build_string_from_mask ((QmiNasPlmnNameSpareBits)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiNasPlmnNameSpareBits
#endif
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " short_name_spare_bits = '");

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_NAS_PLMN_NAME_SPARE_BITS_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_nas_plmn_name_spare_bits_get_string ((QmiNasPlmnNameSpareBits)tmp));
#elif defined  __QMI_NAS_PLMN_NAME_SPARE_BITS_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_nas_plmn_name_spare_bits_build_string_from_mask ((QmiNasPlmnNameSpareBits)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiNasPlmnNameSpareBits
#endif
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " long_name = '");
            {
                guint long_name_i;
                guint8 long_name_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(long_name_n_items), &error))
                    goto out;

                g_string_append (printable, "{");

                for (long_name_i = 0; long_name_i < long_name_n_items; long_name_i++) {
                    g_string_append_printf (printable, " [%u] = '", long_name_i);

                    {
                        guint8 tmp;

                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                            goto out;
                        {
                            g_string_append_printf (printable, "%u", (guint)tmp);
                        }
                    }
                    g_string_append (printable, " '");
                }

                g_string_append (printable, "}");
            }            g_string_append (printable, "'");
            g_string_append (printable, " short_name = '");
            {
                guint short_name_i;
                guint8 short_name_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(short_name_n_items), &error))
                    goto out;

                g_string_append (printable, "{");

                for (short_name_i = 0; short_name_i < short_name_n_items; short_name_i++) {
                    g_string_append_printf (printable, " [%u] = '", short_name_i);

                    {
                        guint8 tmp;

                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                            goto out;
                        {
                            g_string_append_printf (printable, "%u", (guint)tmp);
                        }
                    }
                    g_string_append (printable, " '");
                }

                g_string_append (printable, "}");
            }            g_string_append (printable, "'");
            g_string_append (printable, " ]");
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_operator_name_output_operator_plmn_list_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_OPERATOR_NAME_OUTPUT_TLV_OPERATOR_PLMN_LIST, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint operator_plmn_list_i;
        guint16 operator_plmn_list_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(operator_plmn_list_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (operator_plmn_list_i = 0; operator_plmn_list_i < operator_plmn_list_n_items; operator_plmn_list_i++) {
            g_string_append_printf (printable, " [%u] = '", operator_plmn_list_i);
            g_string_append (printable, "[");
            g_string_append (printable, " mcc = '");

            {
                gchar tmp[4] = { '\0' };

                if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &tmp[0], &error))
                    goto out;
                {
                    g_string_append (printable, tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " mnc = '");

            {
                gchar tmp[4] = { '\0' };

                if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &tmp[0], &error))
                    goto out;
                {
                    g_string_append (printable, tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " lac1 = '");

            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " lac2 = '");

            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " plmn_name_record_identifier = '");

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%u", (guint)tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " ]");
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_operator_name_output_service_provider_name_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_OPERATOR_NAME_OUTPUT_TLV_SERVICE_PROVIDER_NAME, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " name_display_condition = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_NAME_DISPLAY_CONDITION_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_name_display_condition_get_string ((QmiNasNetworkNameDisplayCondition)tmp));
#elif defined  __QMI_NAS_NETWORK_NAME_DISPLAY_CONDITION_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_name_display_condition_build_string_from_mask ((QmiNasNetworkNameDisplayCondition)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkNameDisplayCondition
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " name = '");

    {
        g_autofree gchar *tmp = NULL;

        if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &tmp, &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct indication_operator_name_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
indication_operator_name_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct indication_operator_name_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    {
        switch (type) {
        case QMI_INDICATION_NAS_OPERATOR_NAME_OUTPUT_TLV_NITZ_INFORMATION:
            tlv_type_str = "NITZ Information";
            translated_value = qmi_indication_nas_operator_name_output_nitz_information_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_OPERATOR_NAME_OUTPUT_TLV_OPERATOR_STRING_NAME:
            tlv_type_str = "Operator String Name";
            translated_value = qmi_indication_nas_operator_name_output_operator_string_name_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_OPERATOR_NAME_OUTPUT_TLV_OPERATOR_PLMN_NAME:
            tlv_type_str = "Operator PLMN Name";
            translated_value = qmi_indication_nas_operator_name_output_operator_plmn_name_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_OPERATOR_NAME_OUTPUT_TLV_OPERATOR_PLMN_LIST:
            tlv_type_str = "Operator PLMN List";
            translated_value = qmi_indication_nas_operator_name_output_operator_plmn_list_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_OPERATOR_NAME_OUTPUT_TLV_SERVICE_PROVIDER_NAME:
            tlv_type_str = "Service Provider Name";
            translated_value = qmi_indication_nas_operator_name_output_service_provider_name_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
indication_operator_name_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Operator Name\" (0x003A)\n",
                            line_prefix);

    {
        struct indication_operator_name_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)indication_operator_name_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiIndicationNasOperatorNameOutput *
qmi_indication_nas_operator_name_indication_parse (
    QmiMessage *message,
    GError **error)
{
    QmiIndicationNasOperatorNameOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_INDICATION_NAS_OPERATOR_NAME);

    self = g_slice_new0 (QmiIndicationNasOperatorNameOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_OPERATOR_NAME_OUTPUT_TLV_NITZ_INFORMATION, NULL, NULL)) == 0) {
                goto qmi_indication_nas_operator_name_output_nitz_information_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_operator_name_output_nitz_information_out;
                self->arg_nitz_information_name_encoding = (QmiNasPlmnEncodingScheme)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_operator_name_output_nitz_information_out;
                self->arg_nitz_information_short_country_initials = (QmiNasPlmnNameCountryInitials)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_operator_name_output_nitz_information_out;
                self->arg_nitz_information_long_name_spare_bits = (QmiNasPlmnNameSpareBits)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_operator_name_output_nitz_information_out;
                self->arg_nitz_information_short_name_spare_bits = (QmiNasPlmnNameSpareBits)tmp;
            }
            {
                guint long_name_i;
                guint8 long_name_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(long_name_n_items), NULL))
                    goto qmi_indication_nas_operator_name_output_nitz_information_out;

                self->arg_nitz_information_long_name = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (guint8),
                    (guint)long_name_n_items);

                for (long_name_i = 0; long_name_i < long_name_n_items; long_name_i++) {
                    guint8 long_name_aux;

                    if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(long_name_aux), NULL))
                        goto qmi_indication_nas_operator_name_output_nitz_information_out;
                    g_array_insert_val (self->arg_nitz_information_long_name, long_name_i, long_name_aux);
                }
            }
            {
                guint short_name_i;
                guint8 short_name_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(short_name_n_items), NULL))
                    goto qmi_indication_nas_operator_name_output_nitz_information_out;

                self->arg_nitz_information_short_name = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (guint8),
                    (guint)short_name_n_items);

                for (short_name_i = 0; short_name_i < short_name_n_items; short_name_i++) {
                    guint8 short_name_aux;

                    if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(short_name_aux), NULL))
                        goto qmi_indication_nas_operator_name_output_nitz_information_out;
                    g_array_insert_val (self->arg_nitz_information_short_name, short_name_i, short_name_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'NITZ Information' TLV", offset);
            }

            self->arg_nitz_information_set = TRUE;

qmi_indication_nas_operator_name_output_nitz_information_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_OPERATOR_NAME_OUTPUT_TLV_OPERATOR_STRING_NAME, NULL, NULL)) == 0) {
                goto qmi_indication_nas_operator_name_output_operator_string_name_out;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 0, 0, &(self->arg_operator_string_name), NULL))
                goto qmi_indication_nas_operator_name_output_operator_string_name_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Operator String Name' TLV", offset);
            }

            self->arg_operator_string_name_set = TRUE;

qmi_indication_nas_operator_name_output_operator_string_name_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_OPERATOR_NAME_OUTPUT_TLV_OPERATOR_PLMN_NAME, NULL, NULL)) == 0) {
                goto qmi_indication_nas_operator_name_output_operator_plmn_name_out;
            }
            {
                guint operator_plmn_name_i;
                guint8 operator_plmn_name_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(operator_plmn_name_n_items), NULL))
                    goto qmi_indication_nas_operator_name_output_operator_plmn_name_out;

                self->arg_operator_plmn_name = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (QmiIndicationNasOperatorNameOutputOperatorPlmnNameElement),
                    (guint)operator_plmn_name_n_items);

                g_array_set_clear_func (self->arg_operator_plmn_name, (GDestroyNotify)__qmi_indication_nas_operator_name_output_operator_plmn_name_element_clear);

                for (operator_plmn_name_i = 0; operator_plmn_name_i < operator_plmn_name_n_items; operator_plmn_name_i++) {
                    QmiIndicationNasOperatorNameOutputOperatorPlmnNameElement operator_plmn_name_aux;

                    {
                        guint8 tmp;

                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                            goto qmi_indication_nas_operator_name_output_operator_plmn_name_out;
                        operator_plmn_name_aux.name_encoding = (QmiNasPlmnEncodingScheme)tmp;
                    }
                    {
                        guint8 tmp;

                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                            goto qmi_indication_nas_operator_name_output_operator_plmn_name_out;
                        operator_plmn_name_aux.short_country_initials = (QmiNasPlmnNameCountryInitials)tmp;
                    }
                    {
                        guint8 tmp;

                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                            goto qmi_indication_nas_operator_name_output_operator_plmn_name_out;
                        operator_plmn_name_aux.long_name_spare_bits = (QmiNasPlmnNameSpareBits)tmp;
                    }
                    {
                        guint8 tmp;

                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                            goto qmi_indication_nas_operator_name_output_operator_plmn_name_out;
                        operator_plmn_name_aux.short_name_spare_bits = (QmiNasPlmnNameSpareBits)tmp;
                    }
                    {
                        guint long_name_i;
                        guint8 long_name_n_items;

                        /* Read number of items in the array */
                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(long_name_n_items), NULL))
                            goto qmi_indication_nas_operator_name_output_operator_plmn_name_out;

                        operator_plmn_name_aux.long_name = g_array_sized_new (
                            FALSE,
                            FALSE,
                            sizeof (guint8),
                            (guint)long_name_n_items);

                        for (long_name_i = 0; long_name_i < long_name_n_items; long_name_i++) {
                            guint8 long_name_aux;

                            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(long_name_aux), NULL))
                                goto qmi_indication_nas_operator_name_output_operator_plmn_name_out;
                            g_array_insert_val (operator_plmn_name_aux.long_name, long_name_i, long_name_aux);
                        }
                    }
                    {
                        guint short_name_i;
                        guint8 short_name_n_items;

                        /* Read number of items in the array */
                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(short_name_n_items), NULL))
                            goto qmi_indication_nas_operator_name_output_operator_plmn_name_out;

                        operator_plmn_name_aux.short_name = g_array_sized_new (
                            FALSE,
                            FALSE,
                            sizeof (guint8),
                            (guint)short_name_n_items);

                        for (short_name_i = 0; short_name_i < short_name_n_items; short_name_i++) {
                            guint8 short_name_aux;

                            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(short_name_aux), NULL))
                                goto qmi_indication_nas_operator_name_output_operator_plmn_name_out;
                            g_array_insert_val (operator_plmn_name_aux.short_name, short_name_i, short_name_aux);
                        }
                    }
                    g_array_insert_val (self->arg_operator_plmn_name, operator_plmn_name_i, operator_plmn_name_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Operator PLMN Name' TLV", offset);
            }

            self->arg_operator_plmn_name_set = TRUE;

qmi_indication_nas_operator_name_output_operator_plmn_name_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_OPERATOR_NAME_OUTPUT_TLV_OPERATOR_PLMN_LIST, NULL, NULL)) == 0) {
                goto qmi_indication_nas_operator_name_output_operator_plmn_list_out;
            }
            {
                guint operator_plmn_list_i;
                guint16 operator_plmn_list_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(operator_plmn_list_n_items), NULL))
                    goto qmi_indication_nas_operator_name_output_operator_plmn_list_out;

                self->arg_operator_plmn_list = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (QmiIndicationNasOperatorNameOutputOperatorPlmnListElement),
                    (guint)operator_plmn_list_n_items);

                g_array_set_clear_func (self->arg_operator_plmn_list, (GDestroyNotify)__qmi_indication_nas_operator_name_output_operator_plmn_list_element_clear);

                for (operator_plmn_list_i = 0; operator_plmn_list_i < operator_plmn_list_n_items; operator_plmn_list_i++) {
                    QmiIndicationNasOperatorNameOutputOperatorPlmnListElement operator_plmn_list_aux;

                    operator_plmn_list_aux.mcc = g_malloc (4);
                    if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &operator_plmn_list_aux.mcc[0], NULL)) {
                        g_free (operator_plmn_list_aux.mcc);
                        operator_plmn_list_aux.mcc = NULL;
                        goto qmi_indication_nas_operator_name_output_operator_plmn_list_out;
                    }
                    operator_plmn_list_aux.mcc[3] = '\0';
                    operator_plmn_list_aux.mnc = g_malloc (4);
                    if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &operator_plmn_list_aux.mnc[0], NULL)) {
                        g_free (operator_plmn_list_aux.mnc);
                        operator_plmn_list_aux.mnc = NULL;
                        goto qmi_indication_nas_operator_name_output_operator_plmn_list_out;
                    }
                    operator_plmn_list_aux.mnc[3] = '\0';
                    if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(operator_plmn_list_aux.lac1), NULL))
                        goto qmi_indication_nas_operator_name_output_operator_plmn_list_out;
                    if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(operator_plmn_list_aux.lac2), NULL))
                        goto qmi_indication_nas_operator_name_output_operator_plmn_list_out;
                    if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(operator_plmn_list_aux.plmn_name_record_identifier), NULL))
                        goto qmi_indication_nas_operator_name_output_operator_plmn_list_out;
                    g_array_insert_val (self->arg_operator_plmn_list, operator_plmn_list_i, operator_plmn_list_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Operator PLMN List' TLV", offset);
            }

            self->arg_operator_plmn_list_set = TRUE;

qmi_indication_nas_operator_name_output_operator_plmn_list_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_OPERATOR_NAME_OUTPUT_TLV_SERVICE_PROVIDER_NAME, NULL, NULL)) == 0) {
                goto qmi_indication_nas_operator_name_output_service_provider_name_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_operator_name_output_service_provider_name_out;
                self->arg_service_provider_name_name_display_condition = (QmiNasNetworkNameDisplayCondition)tmp;
            }
            if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &(self->arg_service_provider_name_name), NULL))
                goto qmi_indication_nas_operator_name_output_service_provider_name_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Service Provider Name' TLV", offset);
            }

            self->arg_service_provider_name_set = TRUE;

qmi_indication_nas_operator_name_output_service_provider_name_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* INDICATION: Qmi Indication NAS Network Time */


/* --- Output -- */

struct _QmiIndicationNasNetworkTimeOutput {
    volatile gint ref_count;

    /* Radio Interface */
    gboolean arg_radio_interface_set;
    gint8 arg_radio_interface;

    /* Daylight Savings Adjustment */
    gboolean arg_daylight_savings_adjustment_set;
    guint8 arg_daylight_savings_adjustment;

    /* Timezone Offset */
    gboolean arg_timezone_offset_set;
    gint8 arg_timezone_offset;

    /* Universal Time */
    gboolean arg_universal_time_set;
    guint16 arg_universal_time_year;
    guint8 arg_universal_time_month;
    guint8 arg_universal_time_day;
    guint8 arg_universal_time_hour;
    guint8 arg_universal_time_minute;
    guint8 arg_universal_time_second;
    guint8 arg_universal_time_day_of_week;
};

#define QMI_INDICATION_NAS_NETWORK_TIME_OUTPUT_TLV_RADIO_INTERFACE 0x12
#define QMI_INDICATION_NAS_NETWORK_TIME_OUTPUT_TLV_DAYLIGHT_SAVINGS_ADJUSTMENT 0x11
#define QMI_INDICATION_NAS_NETWORK_TIME_OUTPUT_TLV_TIMEZONE_OFFSET 0x10
#define QMI_INDICATION_NAS_NETWORK_TIME_OUTPUT_TLV_UNIVERSAL_TIME 0x01

gboolean
qmi_indication_nas_network_time_output_get_radio_interface (
    QmiIndicationNasNetworkTimeOutput *self,
    QmiNasRadioInterface *value_radio_interface,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_radio_interface_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Radio Interface' was not found in the message");
        return FALSE;
    }

    if (value_radio_interface)
        *value_radio_interface = (QmiNasRadioInterface)(self->arg_radio_interface);

    return TRUE;
}

gboolean
qmi_indication_nas_network_time_output_get_daylight_savings_adjustment (
    QmiIndicationNasNetworkTimeOutput *self,
    QmiNasDaylightSavingsAdjustment *value_daylight_savings_adjustment,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_daylight_savings_adjustment_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Daylight Savings Adjustment' was not found in the message");
        return FALSE;
    }

    if (value_daylight_savings_adjustment)
        *value_daylight_savings_adjustment = (QmiNasDaylightSavingsAdjustment)(self->arg_daylight_savings_adjustment);

    return TRUE;
}

gboolean
qmi_indication_nas_network_time_output_get_timezone_offset (
    QmiIndicationNasNetworkTimeOutput *self,
    gint8 *value_timezone_offset,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_timezone_offset_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Timezone Offset' was not found in the message");
        return FALSE;
    }

    if (value_timezone_offset)
        *value_timezone_offset = self->arg_timezone_offset;

    return TRUE;
}

gboolean
qmi_indication_nas_network_time_output_get_universal_time (
    QmiIndicationNasNetworkTimeOutput *self,
    guint16 *value_universal_time_year,
    guint8 *value_universal_time_month,
    guint8 *value_universal_time_day,
    guint8 *value_universal_time_hour,
    guint8 *value_universal_time_minute,
    guint8 *value_universal_time_second,
    QmiNasDayOfWeek *value_universal_time_day_of_week,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_universal_time_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Universal Time' was not found in the message");
        return FALSE;
    }

    if (value_universal_time_year)
        *value_universal_time_year = self->arg_universal_time_year;
    if (value_universal_time_month)
        *value_universal_time_month = self->arg_universal_time_month;
    if (value_universal_time_day)
        *value_universal_time_day = self->arg_universal_time_day;
    if (value_universal_time_hour)
        *value_universal_time_hour = self->arg_universal_time_hour;
    if (value_universal_time_minute)
        *value_universal_time_minute = self->arg_universal_time_minute;
    if (value_universal_time_second)
        *value_universal_time_second = self->arg_universal_time_second;
    if (value_universal_time_day_of_week)
        *value_universal_time_day_of_week = (QmiNasDayOfWeek)(self->arg_universal_time_day_of_week);

    return TRUE;
}

GType
qmi_indication_nas_network_time_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiIndicationNasNetworkTimeOutput"),
                                          (GBoxedCopyFunc) qmi_indication_nas_network_time_output_ref,
                                          (GBoxedFreeFunc) qmi_indication_nas_network_time_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiIndicationNasNetworkTimeOutput *
qmi_indication_nas_network_time_output_ref (QmiIndicationNasNetworkTimeOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_indication_nas_network_time_output_unref (QmiIndicationNasNetworkTimeOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiIndicationNasNetworkTimeOutput, self);
    }
}

static gchar *
qmi_indication_nas_network_time_output_radio_interface_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_NETWORK_TIME_OUTPUT_TLV_RADIO_INTERFACE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_RADIO_INTERFACE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_radio_interface_get_string ((QmiNasRadioInterface)tmp));
#elif defined  __QMI_NAS_RADIO_INTERFACE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_radio_interface_build_string_from_mask ((QmiNasRadioInterface)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRadioInterface
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_network_time_output_daylight_savings_adjustment_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_NETWORK_TIME_OUTPUT_TLV_DAYLIGHT_SAVINGS_ADJUSTMENT, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_DAYLIGHT_SAVINGS_ADJUSTMENT_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_daylight_savings_adjustment_get_string ((QmiNasDaylightSavingsAdjustment)tmp));
#elif defined  __QMI_NAS_DAYLIGHT_SAVINGS_ADJUSTMENT_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_daylight_savings_adjustment_build_string_from_mask ((QmiNasDaylightSavingsAdjustment)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasDaylightSavingsAdjustment
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_network_time_output_timezone_offset_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_NETWORK_TIME_OUTPUT_TLV_TIMEZONE_OFFSET, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%d", (gint)tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_network_time_output_universal_time_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_NETWORK_TIME_OUTPUT_TLV_UNIVERSAL_TIME, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " year = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " month = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " day = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " hour = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " minute = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " second = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " day_of_week = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_DAY_OF_WEEK_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_day_of_week_get_string ((QmiNasDayOfWeek)tmp));
#elif defined  __QMI_NAS_DAY_OF_WEEK_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_day_of_week_build_string_from_mask ((QmiNasDayOfWeek)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasDayOfWeek
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct indication_network_time_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
indication_network_time_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct indication_network_time_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    {
        switch (type) {
        case QMI_INDICATION_NAS_NETWORK_TIME_OUTPUT_TLV_RADIO_INTERFACE:
            tlv_type_str = "Radio Interface";
            translated_value = qmi_indication_nas_network_time_output_radio_interface_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_NETWORK_TIME_OUTPUT_TLV_DAYLIGHT_SAVINGS_ADJUSTMENT:
            tlv_type_str = "Daylight Savings Adjustment";
            translated_value = qmi_indication_nas_network_time_output_daylight_savings_adjustment_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_NETWORK_TIME_OUTPUT_TLV_TIMEZONE_OFFSET:
            tlv_type_str = "Timezone Offset";
            translated_value = qmi_indication_nas_network_time_output_timezone_offset_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_NETWORK_TIME_OUTPUT_TLV_UNIVERSAL_TIME:
            tlv_type_str = "Universal Time";
            translated_value = qmi_indication_nas_network_time_output_universal_time_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
indication_network_time_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Network Time\" (0x004C)\n",
                            line_prefix);

    {
        struct indication_network_time_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)indication_network_time_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiIndicationNasNetworkTimeOutput *
qmi_indication_nas_network_time_indication_parse (
    QmiMessage *message,
    GError **error)
{
    QmiIndicationNasNetworkTimeOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_INDICATION_NAS_NETWORK_TIME);

    self = g_slice_new0 (QmiIndicationNasNetworkTimeOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_NETWORK_TIME_OUTPUT_TLV_RADIO_INTERFACE, NULL, NULL)) == 0) {
                goto qmi_indication_nas_network_time_output_radio_interface_out;
            }
            {
                gint8 tmp;

                if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_network_time_output_radio_interface_out;
                self->arg_radio_interface = (QmiNasRadioInterface)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Radio Interface' TLV", offset);
            }

            self->arg_radio_interface_set = TRUE;

qmi_indication_nas_network_time_output_radio_interface_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_NETWORK_TIME_OUTPUT_TLV_DAYLIGHT_SAVINGS_ADJUSTMENT, NULL, NULL)) == 0) {
                goto qmi_indication_nas_network_time_output_daylight_savings_adjustment_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_network_time_output_daylight_savings_adjustment_out;
                self->arg_daylight_savings_adjustment = (QmiNasDaylightSavingsAdjustment)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Daylight Savings Adjustment' TLV", offset);
            }

            self->arg_daylight_savings_adjustment_set = TRUE;

qmi_indication_nas_network_time_output_daylight_savings_adjustment_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_NETWORK_TIME_OUTPUT_TLV_TIMEZONE_OFFSET, NULL, NULL)) == 0) {
                goto qmi_indication_nas_network_time_output_timezone_offset_out;
            }
            if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &(self->arg_timezone_offset), NULL))
                goto qmi_indication_nas_network_time_output_timezone_offset_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Timezone Offset' TLV", offset);
            }

            self->arg_timezone_offset_set = TRUE;

qmi_indication_nas_network_time_output_timezone_offset_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_NETWORK_TIME_OUTPUT_TLV_UNIVERSAL_TIME, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Universal Time TLV: ");
                qmi_indication_nas_network_time_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_universal_time_year), error))
                goto qmi_indication_nas_network_time_output_universal_time_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_universal_time_month), error))
                goto qmi_indication_nas_network_time_output_universal_time_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_universal_time_day), error))
                goto qmi_indication_nas_network_time_output_universal_time_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_universal_time_hour), error))
                goto qmi_indication_nas_network_time_output_universal_time_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_universal_time_minute), error))
                goto qmi_indication_nas_network_time_output_universal_time_out;
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_universal_time_second), error))
                goto qmi_indication_nas_network_time_output_universal_time_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                    goto qmi_indication_nas_network_time_output_universal_time_out;
                self->arg_universal_time_day_of_week = (QmiNasDayOfWeek)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Universal Time' TLV", offset);
            }

            self->arg_universal_time_set = TRUE;

qmi_indication_nas_network_time_output_universal_time_out:
            if (!self->arg_universal_time_set) {
                qmi_indication_nas_network_time_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* INDICATION: Qmi Indication NAS System Info */


/* --- Output -- */

struct _QmiIndicationNasSystemInfoOutput {
    volatile gint ref_count;

    /* NR5G Tracking Area Code */
    gboolean arg_nr5g_tracking_area_code_set;
    GArray *arg_nr5g_tracking_area_code;

    /* DCNR restriction Info */
    gboolean arg_dcnr_restriction_info_set;
    guint8 arg_dcnr_restriction_info;

    /* EUTRA with NR5G availability */
    gboolean arg_eutra_with_nr5g_availability_set;
    guint8 arg_eutra_with_nr5g_availability;

    /* NR5G System Info */
    gboolean arg_nr5g_system_info_set;
    guint8 arg_nr5g_system_info_domain_valid;
    guint8 arg_nr5g_system_info_domain;
    guint8 arg_nr5g_system_info_service_capability_valid;
    guint8 arg_nr5g_system_info_service_capability;
    guint8 arg_nr5g_system_info_roaming_status_valid;
    guint8 arg_nr5g_system_info_roaming_status;
    guint8 arg_nr5g_system_info_forbidden_valid;
    guint8 arg_nr5g_system_info_forbidden;
    guint8 arg_nr5g_system_info_lac_valid;
    guint16 arg_nr5g_system_info_lac;
    guint8 arg_nr5g_system_info_cid_valid;
    guint32 arg_nr5g_system_info_cid;
    guint8 arg_nr5g_system_info_registration_reject_info_valid;
    guint8 arg_nr5g_system_info_registration_reject_domain;
    guint8 arg_nr5g_system_info_registration_reject_cause;
    guint8 arg_nr5g_system_info_network_id_valid;
    gchar arg_nr5g_system_info_mcc[4];
    gchar arg_nr5g_system_info_mnc[4];
    guint8 arg_nr5g_system_info_tac_valid;
    guint16 arg_nr5g_system_info_tac;

    /* NR5G Service Status Info */
    gboolean arg_nr5g_service_status_info_set;
    guint8 arg_nr5g_service_status_info_service_status;
    guint8 arg_nr5g_service_status_info_true_service_status;
    guint8 arg_nr5g_service_status_info_preferred_data_path;

    /* SIM Reject Info */
    gboolean arg_sim_reject_info_set;
    guint32 arg_sim_reject_info;

    /* LTE eMBMS Coverage Info Support */
    gboolean arg_lte_embms_coverage_info_support_set;
    guint8 arg_lte_embms_coverage_info_support;

    /* TD SCMA System Info v2 */
    gboolean arg_td_scma_system_info_v2_set;
    guint8 arg_td_scma_system_info_v2_domain_valid;
    guint8 arg_td_scma_system_info_v2_domain;
    guint8 arg_td_scma_system_info_v2_service_capability_valid;
    guint8 arg_td_scma_system_info_v2_service_capability;
    guint8 arg_td_scma_system_info_v2_roaming_status_valid;
    guint8 arg_td_scma_system_info_v2_roaming_status;
    guint8 arg_td_scma_system_info_v2_forbidden_valid;
    guint8 arg_td_scma_system_info_v2_forbidden;
    guint8 arg_td_scma_system_info_v2_lac_valid;
    guint16 arg_td_scma_system_info_v2_lac;
    guint8 arg_td_scma_system_info_v2_cid_valid;
    guint32 arg_td_scma_system_info_v2_cid;
    guint8 arg_td_scma_system_info_v2_registration_reject_info_valid;
    guint8 arg_td_scma_system_info_v2_registration_reject_domain;
    guint8 arg_td_scma_system_info_v2_registration_reject_cause;
    guint8 arg_td_scma_system_info_v2_network_id_valid;
    gchar arg_td_scma_system_info_v2_mcc[4];
    gchar arg_td_scma_system_info_v2_mnc[4];
    guint8 arg_td_scma_system_info_v2_hs_call_status_valid;
    guint8 arg_td_scma_system_info_v2_hs_call_status;
    guint8 arg_td_scma_system_info_v2_hs_service_valid;
    guint8 arg_td_scma_system_info_v2_hs_service;
    guint8 arg_td_scma_system_info_v2_cell_parameter_id_valid;
    guint16 arg_td_scma_system_info_v2_cell_parameter_id;
    guint8 arg_td_scma_system_info_v2_cell_broadcast_support_valid;
    guint32 arg_td_scma_system_info_v2_cell_broadcast_support;
    guint8 arg_td_scma_system_info_v2_cs_call_barring_status_valid;
    gint32 arg_td_scma_system_info_v2_cs_call_barring_status;
    guint8 arg_td_scma_system_info_v2_ps_call_barring_status_valid;
    gint32 arg_td_scma_system_info_v2_ps_call_barring_status;
    guint8 arg_td_scma_system_info_v2_cipher_domain_valid;
    guint8 arg_td_scma_system_info_v2_cipher_domain;

    /* TD SCDMA Service Status */
    gboolean arg_td_scdma_service_status_set;
    guint8 arg_td_scdma_service_status_service_status;
    guint8 arg_td_scdma_service_status_true_service_status;
    guint8 arg_td_scdma_service_status_preferred_data_path;

    /* PLMN Not Changed Indication */
    gboolean arg_plmn_not_changed_indication_set;
    guint8 arg_plmn_not_changed_indication;

    /* WCDMA Cipher Domain */
    gboolean arg_wcdma_cipher_domain_set;
    guint8 arg_wcdma_cipher_domain;

    /* GSM Cipher Domain */
    gboolean arg_gsm_cipher_domain_set;
    guint8 arg_gsm_cipher_domain;

    /* LTE Voice Support */
    gboolean arg_lte_voice_support_set;
    guint8 arg_lte_voice_support;

    /* WCDMA Call Barring Status */
    gboolean arg_wcdma_call_barring_status_set;
    gint32 arg_wcdma_call_barring_status_cs_status;
    gint32 arg_wcdma_call_barring_status_ps_status;

    /* GSM Call Barring Status */
    gboolean arg_gsm_call_barring_status_set;
    gint32 arg_gsm_call_barring_status_cs_status;
    gint32 arg_gsm_call_barring_status_ps_status;

    /* Additional LTE System Info */
    gboolean arg_additional_lte_system_info_set;
    guint16 arg_additional_lte_system_info_geo_system_index;

    /* Additional WCDMA System Info */
    gboolean arg_additional_wcdma_system_info_set;
    guint16 arg_additional_wcdma_system_info_geo_system_index;
    guint32 arg_additional_wcdma_system_info_cell_broadcast_support;

    /* Additional GSM System Info */
    gboolean arg_additional_gsm_system_info_set;
    guint16 arg_additional_gsm_system_info_geo_system_index;
    guint32 arg_additional_gsm_system_info_cell_broadcast_support;

    /* Additional HDR System Info */
    gboolean arg_additional_hdr_system_info_set;
    guint16 arg_additional_hdr_system_info_geo_system_index;

    /* Additional CDMA System Info */
    gboolean arg_additional_cdma_system_info_set;
    guint16 arg_additional_cdma_system_info_geo_system_index;
    guint16 arg_additional_cdma_system_info_registration_period;

    /* LTE System Info v2 */
    gboolean arg_lte_system_info_v2_set;
    guint8 arg_lte_system_info_v2_domain_valid;
    guint8 arg_lte_system_info_v2_domain;
    guint8 arg_lte_system_info_v2_service_capability_valid;
    guint8 arg_lte_system_info_v2_service_capability;
    guint8 arg_lte_system_info_v2_roaming_status_valid;
    guint8 arg_lte_system_info_v2_roaming_status;
    guint8 arg_lte_system_info_v2_forbidden_valid;
    guint8 arg_lte_system_info_v2_forbidden;
    guint8 arg_lte_system_info_v2_lac_valid;
    guint16 arg_lte_system_info_v2_lac;
    guint8 arg_lte_system_info_v2_cid_valid;
    guint32 arg_lte_system_info_v2_cid;
    guint8 arg_lte_system_info_v2_registration_reject_info_valid;
    guint8 arg_lte_system_info_v2_registration_reject_domain;
    guint8 arg_lte_system_info_v2_registration_reject_cause;
    guint8 arg_lte_system_info_v2_network_id_valid;
    gchar arg_lte_system_info_v2_mcc[4];
    gchar arg_lte_system_info_v2_mnc[4];
    guint8 arg_lte_system_info_v2_tac_valid;
    guint16 arg_lte_system_info_v2_tac;

    /* WCDMA System Info v2 */
    gboolean arg_wcdma_system_info_v2_set;
    guint8 arg_wcdma_system_info_v2_domain_valid;
    guint8 arg_wcdma_system_info_v2_domain;
    guint8 arg_wcdma_system_info_v2_service_capability_valid;
    guint8 arg_wcdma_system_info_v2_service_capability;
    guint8 arg_wcdma_system_info_v2_roaming_status_valid;
    guint8 arg_wcdma_system_info_v2_roaming_status;
    guint8 arg_wcdma_system_info_v2_forbidden_valid;
    guint8 arg_wcdma_system_info_v2_forbidden;
    guint8 arg_wcdma_system_info_v2_lac_valid;
    guint16 arg_wcdma_system_info_v2_lac;
    guint8 arg_wcdma_system_info_v2_cid_valid;
    guint32 arg_wcdma_system_info_v2_cid;
    guint8 arg_wcdma_system_info_v2_registration_reject_info_valid;
    guint8 arg_wcdma_system_info_v2_registration_reject_domain;
    guint8 arg_wcdma_system_info_v2_registration_reject_cause;
    guint8 arg_wcdma_system_info_v2_network_id_valid;
    gchar arg_wcdma_system_info_v2_mcc[4];
    gchar arg_wcdma_system_info_v2_mnc[4];
    guint8 arg_wcdma_system_info_v2_hs_call_status_valid;
    guint8 arg_wcdma_system_info_v2_hs_call_status;
    guint8 arg_wcdma_system_info_v2_hs_service_valid;
    guint8 arg_wcdma_system_info_v2_hs_service;
    guint8 arg_wcdma_system_info_v2_primary_scrambling_code_valid;
    guint16 arg_wcdma_system_info_v2_primary_scrambling_code;

    /* GSM System Info v2 */
    gboolean arg_gsm_system_info_v2_set;
    guint8 arg_gsm_system_info_v2_domain_valid;
    guint8 arg_gsm_system_info_v2_domain;
    guint8 arg_gsm_system_info_v2_service_capability_valid;
    guint8 arg_gsm_system_info_v2_service_capability;
    guint8 arg_gsm_system_info_v2_roaming_status_valid;
    guint8 arg_gsm_system_info_v2_roaming_status;
    guint8 arg_gsm_system_info_v2_forbidden_valid;
    guint8 arg_gsm_system_info_v2_forbidden;
    guint8 arg_gsm_system_info_v2_lac_valid;
    guint16 arg_gsm_system_info_v2_lac;
    guint8 arg_gsm_system_info_v2_cid_valid;
    guint32 arg_gsm_system_info_v2_cid;
    guint8 arg_gsm_system_info_v2_registration_reject_info_valid;
    guint8 arg_gsm_system_info_v2_registration_reject_domain;
    guint8 arg_gsm_system_info_v2_registration_reject_cause;
    guint8 arg_gsm_system_info_v2_network_id_valid;
    gchar arg_gsm_system_info_v2_mcc[4];
    gchar arg_gsm_system_info_v2_mnc[4];
    guint8 arg_gsm_system_info_v2_egprs_support_valid;
    guint8 arg_gsm_system_info_v2_egprs_support;
    guint8 arg_gsm_system_info_v2_dtm_support_valid;
    guint8 arg_gsm_system_info_v2_dtm_support;

    /* HDR System Info */
    gboolean arg_hdr_system_info_set;
    guint8 arg_hdr_system_info_domain_valid;
    guint8 arg_hdr_system_info_domain;
    guint8 arg_hdr_system_info_service_capability_valid;
    guint8 arg_hdr_system_info_service_capability;
    guint8 arg_hdr_system_info_roaming_status_valid;
    guint8 arg_hdr_system_info_roaming_status;
    guint8 arg_hdr_system_info_forbidden_valid;
    guint8 arg_hdr_system_info_forbidden;
    guint8 arg_hdr_system_info_prl_match_valid;
    guint8 arg_hdr_system_info_prl_match;
    guint8 arg_hdr_system_info_personality_valid;
    guint8 arg_hdr_system_info_personality;
    guint8 arg_hdr_system_info_protocol_revision_valid;
    guint8 arg_hdr_system_info_protocol_revision;
    guint8 arg_hdr_system_info_is_856_system_id_valid;
    gchar arg_hdr_system_info_is_856_system_id[17];

    /* CDMA System Info */
    gboolean arg_cdma_system_info_set;
    guint8 arg_cdma_system_info_domain_valid;
    guint8 arg_cdma_system_info_domain;
    guint8 arg_cdma_system_info_service_capability_valid;
    guint8 arg_cdma_system_info_service_capability;
    guint8 arg_cdma_system_info_roaming_status_valid;
    guint8 arg_cdma_system_info_roaming_status;
    guint8 arg_cdma_system_info_forbidden_valid;
    guint8 arg_cdma_system_info_forbidden;
    guint8 arg_cdma_system_info_prl_match_valid;
    guint8 arg_cdma_system_info_prl_match;
    guint8 arg_cdma_system_info_p_rev_valid;
    guint8 arg_cdma_system_info_p_rev;
    guint8 arg_cdma_system_info_base_station_p_rev_valid;
    guint8 arg_cdma_system_info_base_station_p_rev;
    guint8 arg_cdma_system_info_concurrent_service_support_valid;
    guint8 arg_cdma_system_info_concurrent_service_support;
    guint8 arg_cdma_system_info_cdma_system_id_valid;
    guint16 arg_cdma_system_info_sid;
    guint16 arg_cdma_system_info_nid;
    guint8 arg_cdma_system_info_base_station_info_valid;
    guint16 arg_cdma_system_info_base_station_id;
    gint32 arg_cdma_system_info_base_station_latitude;
    gint32 arg_cdma_system_info_base_station_longitude;
    guint8 arg_cdma_system_info_packet_zone_valid;
    guint16 arg_cdma_system_info_packet_zone;
    guint8 arg_cdma_system_info_network_id_valid;
    gchar arg_cdma_system_info_mcc[4];
    gchar arg_cdma_system_info_mnc[4];

    /* LTE Service Status */
    gboolean arg_lte_service_status_set;
    guint8 arg_lte_service_status_service_status;
    guint8 arg_lte_service_status_true_service_status;
    guint8 arg_lte_service_status_preferred_data_path;

    /* WCDMA Service Status */
    gboolean arg_wcdma_service_status_set;
    guint8 arg_wcdma_service_status_service_status;
    guint8 arg_wcdma_service_status_true_service_status;
    guint8 arg_wcdma_service_status_preferred_data_path;

    /* GSM Service Status */
    gboolean arg_gsm_service_status_set;
    guint8 arg_gsm_service_status_service_status;
    guint8 arg_gsm_service_status_true_service_status;
    guint8 arg_gsm_service_status_preferred_data_path;

    /* HDR Service Status */
    gboolean arg_hdr_service_status_set;
    guint8 arg_hdr_service_status_service_status;
    guint8 arg_hdr_service_status_preferred_data_path;

    /* CDMA Service Status */
    gboolean arg_cdma_service_status_set;
    guint8 arg_cdma_service_status_service_status;
    guint8 arg_cdma_service_status_preferred_data_path;
};

#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_NR5G_TRACKING_AREA_CODE 0x52
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_DCNR_RESTRICTION_INFO 0x51
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_EUTRA_WITH_NR5G_AVAILABILITY 0x50
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_NR5G_SYSTEM_INFO 0x4D
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_NR5G_SERVICE_STATUS_INFO 0x4C
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_SIM_REJECT_INFO 0x28
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_LTE_EMBMS_COVERAGE_INFO_SUPPORT 0x27
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_TD_SCMA_SYSTEM_INFO_V2 0x26
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_TD_SCDMA_SERVICE_STATUS 0x25
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_PLMN_NOT_CHANGED_INDICATION 0x24
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_WCDMA_CIPHER_DOMAIN 0x23
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_GSM_CIPHER_DOMAIN 0x22
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_LTE_VOICE_SUPPORT 0x21
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_WCDMA_CALL_BARRING_STATUS 0x20
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_GSM_CALL_BARRING_STATUS 0x1F
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_ADDITIONAL_LTE_SYSTEM_INFO 0x1E
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_ADDITIONAL_WCDMA_SYSTEM_INFO 0x1D
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_ADDITIONAL_GSM_SYSTEM_INFO 0x1C
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_ADDITIONAL_HDR_SYSTEM_INFO 0x1B
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_ADDITIONAL_CDMA_SYSTEM_INFO 0x1A
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_LTE_SYSTEM_INFO_V2 0x19
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_WCDMA_SYSTEM_INFO_V2 0x18
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_GSM_SYSTEM_INFO_V2 0x17
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_HDR_SYSTEM_INFO 0x16
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_CDMA_SYSTEM_INFO 0x15
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_LTE_SERVICE_STATUS 0x14
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_WCDMA_SERVICE_STATUS 0x13
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_GSM_SERVICE_STATUS 0x12
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_HDR_SERVICE_STATUS 0x11
#define QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_CDMA_SERVICE_STATUS 0x10

gboolean
qmi_indication_nas_system_info_output_get_nr5g_tracking_area_code (
    QmiIndicationNasSystemInfoOutput *self,
    GArray **value_nr5g_tracking_area_code,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_nr5g_tracking_area_code_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'NR5G Tracking Area Code' was not found in the message");
        return FALSE;
    }

    if (value_nr5g_tracking_area_code)
        *value_nr5g_tracking_area_code = self->arg_nr5g_tracking_area_code;

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_dcnr_restriction_info (
    QmiIndicationNasSystemInfoOutput *self,
    gboolean *value_dcnr_restriction_info,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_dcnr_restriction_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'DCNR restriction Info' was not found in the message");
        return FALSE;
    }

    if (value_dcnr_restriction_info)
        *value_dcnr_restriction_info = (gboolean)(self->arg_dcnr_restriction_info);

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_eutra_with_nr5g_availability (
    QmiIndicationNasSystemInfoOutput *self,
    gboolean *value_eutra_with_nr5g_availability,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_eutra_with_nr5g_availability_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'EUTRA with NR5G availability' was not found in the message");
        return FALSE;
    }

    if (value_eutra_with_nr5g_availability)
        *value_eutra_with_nr5g_availability = (gboolean)(self->arg_eutra_with_nr5g_availability);

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_nr5g_system_info (
    QmiIndicationNasSystemInfoOutput *self,
    gboolean *value_nr5g_system_info_domain_valid,
    QmiNasNetworkServiceDomain *value_nr5g_system_info_domain,
    gboolean *value_nr5g_system_info_service_capability_valid,
    QmiNasNetworkServiceDomain *value_nr5g_system_info_service_capability,
    gboolean *value_nr5g_system_info_roaming_status_valid,
    QmiNasRoamingStatus *value_nr5g_system_info_roaming_status,
    gboolean *value_nr5g_system_info_forbidden_valid,
    gboolean *value_nr5g_system_info_forbidden,
    gboolean *value_nr5g_system_info_lac_valid,
    guint16 *value_nr5g_system_info_lac,
    gboolean *value_nr5g_system_info_cid_valid,
    guint32 *value_nr5g_system_info_cid,
    gboolean *value_nr5g_system_info_registration_reject_info_valid,
    QmiNasNetworkServiceDomain *value_nr5g_system_info_registration_reject_domain,
    guint8 *value_nr5g_system_info_registration_reject_cause,
    gboolean *value_nr5g_system_info_network_id_valid,
    const gchar **value_nr5g_system_info_mcc,
    const gchar **value_nr5g_system_info_mnc,
    gboolean *value_nr5g_system_info_tac_valid,
    guint16 *value_nr5g_system_info_tac,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_nr5g_system_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'NR5G System Info' was not found in the message");
        return FALSE;
    }

    if (value_nr5g_system_info_domain_valid)
        *value_nr5g_system_info_domain_valid = (gboolean)(self->arg_nr5g_system_info_domain_valid);
    if (value_nr5g_system_info_domain)
        *value_nr5g_system_info_domain = (QmiNasNetworkServiceDomain)(self->arg_nr5g_system_info_domain);
    if (value_nr5g_system_info_service_capability_valid)
        *value_nr5g_system_info_service_capability_valid = (gboolean)(self->arg_nr5g_system_info_service_capability_valid);
    if (value_nr5g_system_info_service_capability)
        *value_nr5g_system_info_service_capability = (QmiNasNetworkServiceDomain)(self->arg_nr5g_system_info_service_capability);
    if (value_nr5g_system_info_roaming_status_valid)
        *value_nr5g_system_info_roaming_status_valid = (gboolean)(self->arg_nr5g_system_info_roaming_status_valid);
    if (value_nr5g_system_info_roaming_status)
        *value_nr5g_system_info_roaming_status = (QmiNasRoamingStatus)(self->arg_nr5g_system_info_roaming_status);
    if (value_nr5g_system_info_forbidden_valid)
        *value_nr5g_system_info_forbidden_valid = (gboolean)(self->arg_nr5g_system_info_forbidden_valid);
    if (value_nr5g_system_info_forbidden)
        *value_nr5g_system_info_forbidden = (gboolean)(self->arg_nr5g_system_info_forbidden);
    if (value_nr5g_system_info_lac_valid)
        *value_nr5g_system_info_lac_valid = (gboolean)(self->arg_nr5g_system_info_lac_valid);
    if (value_nr5g_system_info_lac)
        *value_nr5g_system_info_lac = self->arg_nr5g_system_info_lac;
    if (value_nr5g_system_info_cid_valid)
        *value_nr5g_system_info_cid_valid = (gboolean)(self->arg_nr5g_system_info_cid_valid);
    if (value_nr5g_system_info_cid)
        *value_nr5g_system_info_cid = self->arg_nr5g_system_info_cid;
    if (value_nr5g_system_info_registration_reject_info_valid)
        *value_nr5g_system_info_registration_reject_info_valid = (gboolean)(self->arg_nr5g_system_info_registration_reject_info_valid);
    if (value_nr5g_system_info_registration_reject_domain)
        *value_nr5g_system_info_registration_reject_domain = (QmiNasNetworkServiceDomain)(self->arg_nr5g_system_info_registration_reject_domain);
    if (value_nr5g_system_info_registration_reject_cause)
        *value_nr5g_system_info_registration_reject_cause = self->arg_nr5g_system_info_registration_reject_cause;
    if (value_nr5g_system_info_network_id_valid)
        *value_nr5g_system_info_network_id_valid = (gboolean)(self->arg_nr5g_system_info_network_id_valid);
    if (value_nr5g_system_info_mcc)
        *value_nr5g_system_info_mcc = self->arg_nr5g_system_info_mcc;
    if (value_nr5g_system_info_mnc)
        *value_nr5g_system_info_mnc = self->arg_nr5g_system_info_mnc;
    if (value_nr5g_system_info_tac_valid)
        *value_nr5g_system_info_tac_valid = (gboolean)(self->arg_nr5g_system_info_tac_valid);
    if (value_nr5g_system_info_tac)
        *value_nr5g_system_info_tac = self->arg_nr5g_system_info_tac;

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_nr5g_service_status_info (
    QmiIndicationNasSystemInfoOutput *self,
    QmiNasServiceStatus *value_nr5g_service_status_info_service_status,
    QmiNasServiceStatus *value_nr5g_service_status_info_true_service_status,
    gboolean *value_nr5g_service_status_info_preferred_data_path,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_nr5g_service_status_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'NR5G Service Status Info' was not found in the message");
        return FALSE;
    }

    if (value_nr5g_service_status_info_service_status)
        *value_nr5g_service_status_info_service_status = (QmiNasServiceStatus)(self->arg_nr5g_service_status_info_service_status);
    if (value_nr5g_service_status_info_true_service_status)
        *value_nr5g_service_status_info_true_service_status = (QmiNasServiceStatus)(self->arg_nr5g_service_status_info_true_service_status);
    if (value_nr5g_service_status_info_preferred_data_path)
        *value_nr5g_service_status_info_preferred_data_path = (gboolean)(self->arg_nr5g_service_status_info_preferred_data_path);

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_sim_reject_info (
    QmiIndicationNasSystemInfoOutput *self,
    QmiNasSimRejectState *value_sim_reject_info,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_sim_reject_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'SIM Reject Info' was not found in the message");
        return FALSE;
    }

    if (value_sim_reject_info)
        *value_sim_reject_info = (QmiNasSimRejectState)(self->arg_sim_reject_info);

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_lte_embms_coverage_info_support (
    QmiIndicationNasSystemInfoOutput *self,
    gboolean *value_lte_embms_coverage_info_support,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_lte_embms_coverage_info_support_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'LTE eMBMS Coverage Info Support' was not found in the message");
        return FALSE;
    }

    if (value_lte_embms_coverage_info_support)
        *value_lte_embms_coverage_info_support = (gboolean)(self->arg_lte_embms_coverage_info_support);

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_td_scma_system_info_v2 (
    QmiIndicationNasSystemInfoOutput *self,
    gboolean *value_td_scma_system_info_v2_domain_valid,
    QmiNasNetworkServiceDomain *value_td_scma_system_info_v2_domain,
    gboolean *value_td_scma_system_info_v2_service_capability_valid,
    QmiNasNetworkServiceDomain *value_td_scma_system_info_v2_service_capability,
    gboolean *value_td_scma_system_info_v2_roaming_status_valid,
    QmiNasRoamingStatus *value_td_scma_system_info_v2_roaming_status,
    gboolean *value_td_scma_system_info_v2_forbidden_valid,
    gboolean *value_td_scma_system_info_v2_forbidden,
    gboolean *value_td_scma_system_info_v2_lac_valid,
    guint16 *value_td_scma_system_info_v2_lac,
    gboolean *value_td_scma_system_info_v2_cid_valid,
    guint32 *value_td_scma_system_info_v2_cid,
    gboolean *value_td_scma_system_info_v2_registration_reject_info_valid,
    QmiNasNetworkServiceDomain *value_td_scma_system_info_v2_registration_reject_domain,
    QmiNasRejectCause *value_td_scma_system_info_v2_registration_reject_cause,
    gboolean *value_td_scma_system_info_v2_network_id_valid,
    const gchar **value_td_scma_system_info_v2_mcc,
    const gchar **value_td_scma_system_info_v2_mnc,
    gboolean *value_td_scma_system_info_v2_hs_call_status_valid,
    QmiNasWcdmaHsService *value_td_scma_system_info_v2_hs_call_status,
    gboolean *value_td_scma_system_info_v2_hs_service_valid,
    QmiNasWcdmaHsService *value_td_scma_system_info_v2_hs_service,
    gboolean *value_td_scma_system_info_v2_cell_parameter_id_valid,
    guint16 *value_td_scma_system_info_v2_cell_parameter_id,
    gboolean *value_td_scma_system_info_v2_cell_broadcast_support_valid,
    QmiNasCellBroadcastCapability *value_td_scma_system_info_v2_cell_broadcast_support,
    gboolean *value_td_scma_system_info_v2_cs_call_barring_status_valid,
    QmiNasCallBarringStatus *value_td_scma_system_info_v2_cs_call_barring_status,
    gboolean *value_td_scma_system_info_v2_ps_call_barring_status_valid,
    QmiNasCallBarringStatus *value_td_scma_system_info_v2_ps_call_barring_status,
    gboolean *value_td_scma_system_info_v2_cipher_domain_valid,
    QmiNasNetworkServiceDomain *value_td_scma_system_info_v2_cipher_domain,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_td_scma_system_info_v2_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'TD SCMA System Info v2' was not found in the message");
        return FALSE;
    }

    if (value_td_scma_system_info_v2_domain_valid)
        *value_td_scma_system_info_v2_domain_valid = (gboolean)(self->arg_td_scma_system_info_v2_domain_valid);
    if (value_td_scma_system_info_v2_domain)
        *value_td_scma_system_info_v2_domain = (QmiNasNetworkServiceDomain)(self->arg_td_scma_system_info_v2_domain);
    if (value_td_scma_system_info_v2_service_capability_valid)
        *value_td_scma_system_info_v2_service_capability_valid = (gboolean)(self->arg_td_scma_system_info_v2_service_capability_valid);
    if (value_td_scma_system_info_v2_service_capability)
        *value_td_scma_system_info_v2_service_capability = (QmiNasNetworkServiceDomain)(self->arg_td_scma_system_info_v2_service_capability);
    if (value_td_scma_system_info_v2_roaming_status_valid)
        *value_td_scma_system_info_v2_roaming_status_valid = (gboolean)(self->arg_td_scma_system_info_v2_roaming_status_valid);
    if (value_td_scma_system_info_v2_roaming_status)
        *value_td_scma_system_info_v2_roaming_status = (QmiNasRoamingStatus)(self->arg_td_scma_system_info_v2_roaming_status);
    if (value_td_scma_system_info_v2_forbidden_valid)
        *value_td_scma_system_info_v2_forbidden_valid = (gboolean)(self->arg_td_scma_system_info_v2_forbidden_valid);
    if (value_td_scma_system_info_v2_forbidden)
        *value_td_scma_system_info_v2_forbidden = (gboolean)(self->arg_td_scma_system_info_v2_forbidden);
    if (value_td_scma_system_info_v2_lac_valid)
        *value_td_scma_system_info_v2_lac_valid = (gboolean)(self->arg_td_scma_system_info_v2_lac_valid);
    if (value_td_scma_system_info_v2_lac)
        *value_td_scma_system_info_v2_lac = self->arg_td_scma_system_info_v2_lac;
    if (value_td_scma_system_info_v2_cid_valid)
        *value_td_scma_system_info_v2_cid_valid = (gboolean)(self->arg_td_scma_system_info_v2_cid_valid);
    if (value_td_scma_system_info_v2_cid)
        *value_td_scma_system_info_v2_cid = self->arg_td_scma_system_info_v2_cid;
    if (value_td_scma_system_info_v2_registration_reject_info_valid)
        *value_td_scma_system_info_v2_registration_reject_info_valid = (gboolean)(self->arg_td_scma_system_info_v2_registration_reject_info_valid);
    if (value_td_scma_system_info_v2_registration_reject_domain)
        *value_td_scma_system_info_v2_registration_reject_domain = (QmiNasNetworkServiceDomain)(self->arg_td_scma_system_info_v2_registration_reject_domain);
    if (value_td_scma_system_info_v2_registration_reject_cause)
        *value_td_scma_system_info_v2_registration_reject_cause = (QmiNasRejectCause)(self->arg_td_scma_system_info_v2_registration_reject_cause);
    if (value_td_scma_system_info_v2_network_id_valid)
        *value_td_scma_system_info_v2_network_id_valid = (gboolean)(self->arg_td_scma_system_info_v2_network_id_valid);
    if (value_td_scma_system_info_v2_mcc)
        *value_td_scma_system_info_v2_mcc = self->arg_td_scma_system_info_v2_mcc;
    if (value_td_scma_system_info_v2_mnc)
        *value_td_scma_system_info_v2_mnc = self->arg_td_scma_system_info_v2_mnc;
    if (value_td_scma_system_info_v2_hs_call_status_valid)
        *value_td_scma_system_info_v2_hs_call_status_valid = (gboolean)(self->arg_td_scma_system_info_v2_hs_call_status_valid);
    if (value_td_scma_system_info_v2_hs_call_status)
        *value_td_scma_system_info_v2_hs_call_status = (QmiNasWcdmaHsService)(self->arg_td_scma_system_info_v2_hs_call_status);
    if (value_td_scma_system_info_v2_hs_service_valid)
        *value_td_scma_system_info_v2_hs_service_valid = (gboolean)(self->arg_td_scma_system_info_v2_hs_service_valid);
    if (value_td_scma_system_info_v2_hs_service)
        *value_td_scma_system_info_v2_hs_service = (QmiNasWcdmaHsService)(self->arg_td_scma_system_info_v2_hs_service);
    if (value_td_scma_system_info_v2_cell_parameter_id_valid)
        *value_td_scma_system_info_v2_cell_parameter_id_valid = (gboolean)(self->arg_td_scma_system_info_v2_cell_parameter_id_valid);
    if (value_td_scma_system_info_v2_cell_parameter_id)
        *value_td_scma_system_info_v2_cell_parameter_id = self->arg_td_scma_system_info_v2_cell_parameter_id;
    if (value_td_scma_system_info_v2_cell_broadcast_support_valid)
        *value_td_scma_system_info_v2_cell_broadcast_support_valid = (gboolean)(self->arg_td_scma_system_info_v2_cell_broadcast_support_valid);
    if (value_td_scma_system_info_v2_cell_broadcast_support)
        *value_td_scma_system_info_v2_cell_broadcast_support = (QmiNasCellBroadcastCapability)(self->arg_td_scma_system_info_v2_cell_broadcast_support);
    if (value_td_scma_system_info_v2_cs_call_barring_status_valid)
        *value_td_scma_system_info_v2_cs_call_barring_status_valid = (gboolean)(self->arg_td_scma_system_info_v2_cs_call_barring_status_valid);
    if (value_td_scma_system_info_v2_cs_call_barring_status)
        *value_td_scma_system_info_v2_cs_call_barring_status = (QmiNasCallBarringStatus)(self->arg_td_scma_system_info_v2_cs_call_barring_status);
    if (value_td_scma_system_info_v2_ps_call_barring_status_valid)
        *value_td_scma_system_info_v2_ps_call_barring_status_valid = (gboolean)(self->arg_td_scma_system_info_v2_ps_call_barring_status_valid);
    if (value_td_scma_system_info_v2_ps_call_barring_status)
        *value_td_scma_system_info_v2_ps_call_barring_status = (QmiNasCallBarringStatus)(self->arg_td_scma_system_info_v2_ps_call_barring_status);
    if (value_td_scma_system_info_v2_cipher_domain_valid)
        *value_td_scma_system_info_v2_cipher_domain_valid = (gboolean)(self->arg_td_scma_system_info_v2_cipher_domain_valid);
    if (value_td_scma_system_info_v2_cipher_domain)
        *value_td_scma_system_info_v2_cipher_domain = (QmiNasNetworkServiceDomain)(self->arg_td_scma_system_info_v2_cipher_domain);

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_td_scdma_service_status (
    QmiIndicationNasSystemInfoOutput *self,
    QmiNasServiceStatus *value_td_scdma_service_status_service_status,
    QmiNasServiceStatus *value_td_scdma_service_status_true_service_status,
    gboolean *value_td_scdma_service_status_preferred_data_path,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_td_scdma_service_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'TD SCDMA Service Status' was not found in the message");
        return FALSE;
    }

    if (value_td_scdma_service_status_service_status)
        *value_td_scdma_service_status_service_status = (QmiNasServiceStatus)(self->arg_td_scdma_service_status_service_status);
    if (value_td_scdma_service_status_true_service_status)
        *value_td_scdma_service_status_true_service_status = (QmiNasServiceStatus)(self->arg_td_scdma_service_status_true_service_status);
    if (value_td_scdma_service_status_preferred_data_path)
        *value_td_scdma_service_status_preferred_data_path = (gboolean)(self->arg_td_scdma_service_status_preferred_data_path);

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_plmn_not_changed_indication (
    QmiIndicationNasSystemInfoOutput *self,
    gboolean *value_plmn_not_changed_indication,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_plmn_not_changed_indication_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PLMN Not Changed Indication' was not found in the message");
        return FALSE;
    }

    if (value_plmn_not_changed_indication)
        *value_plmn_not_changed_indication = (gboolean)(self->arg_plmn_not_changed_indication);

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_wcdma_cipher_domain (
    QmiIndicationNasSystemInfoOutput *self,
    QmiNasNetworkServiceDomain *value_wcdma_cipher_domain,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_wcdma_cipher_domain_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'WCDMA Cipher Domain' was not found in the message");
        return FALSE;
    }

    if (value_wcdma_cipher_domain)
        *value_wcdma_cipher_domain = (QmiNasNetworkServiceDomain)(self->arg_wcdma_cipher_domain);

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_gsm_cipher_domain (
    QmiIndicationNasSystemInfoOutput *self,
    QmiNasNetworkServiceDomain *value_gsm_cipher_domain,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_gsm_cipher_domain_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'GSM Cipher Domain' was not found in the message");
        return FALSE;
    }

    if (value_gsm_cipher_domain)
        *value_gsm_cipher_domain = (QmiNasNetworkServiceDomain)(self->arg_gsm_cipher_domain);

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_lte_voice_support (
    QmiIndicationNasSystemInfoOutput *self,
    gboolean *value_lte_voice_support,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_lte_voice_support_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'LTE Voice Support' was not found in the message");
        return FALSE;
    }

    if (value_lte_voice_support)
        *value_lte_voice_support = (gboolean)(self->arg_lte_voice_support);

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_wcdma_call_barring_status (
    QmiIndicationNasSystemInfoOutput *self,
    QmiNasCallBarringStatus *value_wcdma_call_barring_status_cs_status,
    QmiNasCallBarringStatus *value_wcdma_call_barring_status_ps_status,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_wcdma_call_barring_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'WCDMA Call Barring Status' was not found in the message");
        return FALSE;
    }

    if (value_wcdma_call_barring_status_cs_status)
        *value_wcdma_call_barring_status_cs_status = (QmiNasCallBarringStatus)(self->arg_wcdma_call_barring_status_cs_status);
    if (value_wcdma_call_barring_status_ps_status)
        *value_wcdma_call_barring_status_ps_status = (QmiNasCallBarringStatus)(self->arg_wcdma_call_barring_status_ps_status);

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_gsm_call_barring_status (
    QmiIndicationNasSystemInfoOutput *self,
    QmiNasCallBarringStatus *value_gsm_call_barring_status_cs_status,
    QmiNasCallBarringStatus *value_gsm_call_barring_status_ps_status,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_gsm_call_barring_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'GSM Call Barring Status' was not found in the message");
        return FALSE;
    }

    if (value_gsm_call_barring_status_cs_status)
        *value_gsm_call_barring_status_cs_status = (QmiNasCallBarringStatus)(self->arg_gsm_call_barring_status_cs_status);
    if (value_gsm_call_barring_status_ps_status)
        *value_gsm_call_barring_status_ps_status = (QmiNasCallBarringStatus)(self->arg_gsm_call_barring_status_ps_status);

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_additional_lte_system_info (
    QmiIndicationNasSystemInfoOutput *self,
    guint16 *value_additional_lte_system_info_geo_system_index,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_additional_lte_system_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Additional LTE System Info' was not found in the message");
        return FALSE;
    }

    if (value_additional_lte_system_info_geo_system_index)
        *value_additional_lte_system_info_geo_system_index = self->arg_additional_lte_system_info_geo_system_index;

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_additional_wcdma_system_info (
    QmiIndicationNasSystemInfoOutput *self,
    guint16 *value_additional_wcdma_system_info_geo_system_index,
    QmiNasCellBroadcastCapability *value_additional_wcdma_system_info_cell_broadcast_support,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_additional_wcdma_system_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Additional WCDMA System Info' was not found in the message");
        return FALSE;
    }

    if (value_additional_wcdma_system_info_geo_system_index)
        *value_additional_wcdma_system_info_geo_system_index = self->arg_additional_wcdma_system_info_geo_system_index;
    if (value_additional_wcdma_system_info_cell_broadcast_support)
        *value_additional_wcdma_system_info_cell_broadcast_support = (QmiNasCellBroadcastCapability)(self->arg_additional_wcdma_system_info_cell_broadcast_support);

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_additional_gsm_system_info (
    QmiIndicationNasSystemInfoOutput *self,
    guint16 *value_additional_gsm_system_info_geo_system_index,
    QmiNasCellBroadcastCapability *value_additional_gsm_system_info_cell_broadcast_support,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_additional_gsm_system_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Additional GSM System Info' was not found in the message");
        return FALSE;
    }

    if (value_additional_gsm_system_info_geo_system_index)
        *value_additional_gsm_system_info_geo_system_index = self->arg_additional_gsm_system_info_geo_system_index;
    if (value_additional_gsm_system_info_cell_broadcast_support)
        *value_additional_gsm_system_info_cell_broadcast_support = (QmiNasCellBroadcastCapability)(self->arg_additional_gsm_system_info_cell_broadcast_support);

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_additional_hdr_system_info (
    QmiIndicationNasSystemInfoOutput *self,
    guint16 *value_additional_hdr_system_info_geo_system_index,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_additional_hdr_system_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Additional HDR System Info' was not found in the message");
        return FALSE;
    }

    if (value_additional_hdr_system_info_geo_system_index)
        *value_additional_hdr_system_info_geo_system_index = self->arg_additional_hdr_system_info_geo_system_index;

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_additional_cdma_system_info (
    QmiIndicationNasSystemInfoOutput *self,
    guint16 *value_additional_cdma_system_info_geo_system_index,
    guint16 *value_additional_cdma_system_info_registration_period,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_additional_cdma_system_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Additional CDMA System Info' was not found in the message");
        return FALSE;
    }

    if (value_additional_cdma_system_info_geo_system_index)
        *value_additional_cdma_system_info_geo_system_index = self->arg_additional_cdma_system_info_geo_system_index;
    if (value_additional_cdma_system_info_registration_period)
        *value_additional_cdma_system_info_registration_period = self->arg_additional_cdma_system_info_registration_period;

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_lte_system_info_v2 (
    QmiIndicationNasSystemInfoOutput *self,
    gboolean *value_lte_system_info_v2_domain_valid,
    QmiNasNetworkServiceDomain *value_lte_system_info_v2_domain,
    gboolean *value_lte_system_info_v2_service_capability_valid,
    QmiNasNetworkServiceDomain *value_lte_system_info_v2_service_capability,
    gboolean *value_lte_system_info_v2_roaming_status_valid,
    QmiNasRoamingStatus *value_lte_system_info_v2_roaming_status,
    gboolean *value_lte_system_info_v2_forbidden_valid,
    gboolean *value_lte_system_info_v2_forbidden,
    gboolean *value_lte_system_info_v2_lac_valid,
    guint16 *value_lte_system_info_v2_lac,
    gboolean *value_lte_system_info_v2_cid_valid,
    guint32 *value_lte_system_info_v2_cid,
    gboolean *value_lte_system_info_v2_registration_reject_info_valid,
    QmiNasNetworkServiceDomain *value_lte_system_info_v2_registration_reject_domain,
    QmiNasRejectCause *value_lte_system_info_v2_registration_reject_cause,
    gboolean *value_lte_system_info_v2_network_id_valid,
    const gchar **value_lte_system_info_v2_mcc,
    const gchar **value_lte_system_info_v2_mnc,
    gboolean *value_lte_system_info_v2_tac_valid,
    guint16 *value_lte_system_info_v2_tac,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_lte_system_info_v2_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'LTE System Info v2' was not found in the message");
        return FALSE;
    }

    if (value_lte_system_info_v2_domain_valid)
        *value_lte_system_info_v2_domain_valid = (gboolean)(self->arg_lte_system_info_v2_domain_valid);
    if (value_lte_system_info_v2_domain)
        *value_lte_system_info_v2_domain = (QmiNasNetworkServiceDomain)(self->arg_lte_system_info_v2_domain);
    if (value_lte_system_info_v2_service_capability_valid)
        *value_lte_system_info_v2_service_capability_valid = (gboolean)(self->arg_lte_system_info_v2_service_capability_valid);
    if (value_lte_system_info_v2_service_capability)
        *value_lte_system_info_v2_service_capability = (QmiNasNetworkServiceDomain)(self->arg_lte_system_info_v2_service_capability);
    if (value_lte_system_info_v2_roaming_status_valid)
        *value_lte_system_info_v2_roaming_status_valid = (gboolean)(self->arg_lte_system_info_v2_roaming_status_valid);
    if (value_lte_system_info_v2_roaming_status)
        *value_lte_system_info_v2_roaming_status = (QmiNasRoamingStatus)(self->arg_lte_system_info_v2_roaming_status);
    if (value_lte_system_info_v2_forbidden_valid)
        *value_lte_system_info_v2_forbidden_valid = (gboolean)(self->arg_lte_system_info_v2_forbidden_valid);
    if (value_lte_system_info_v2_forbidden)
        *value_lte_system_info_v2_forbidden = (gboolean)(self->arg_lte_system_info_v2_forbidden);
    if (value_lte_system_info_v2_lac_valid)
        *value_lte_system_info_v2_lac_valid = (gboolean)(self->arg_lte_system_info_v2_lac_valid);
    if (value_lte_system_info_v2_lac)
        *value_lte_system_info_v2_lac = self->arg_lte_system_info_v2_lac;
    if (value_lte_system_info_v2_cid_valid)
        *value_lte_system_info_v2_cid_valid = (gboolean)(self->arg_lte_system_info_v2_cid_valid);
    if (value_lte_system_info_v2_cid)
        *value_lte_system_info_v2_cid = self->arg_lte_system_info_v2_cid;
    if (value_lte_system_info_v2_registration_reject_info_valid)
        *value_lte_system_info_v2_registration_reject_info_valid = (gboolean)(self->arg_lte_system_info_v2_registration_reject_info_valid);
    if (value_lte_system_info_v2_registration_reject_domain)
        *value_lte_system_info_v2_registration_reject_domain = (QmiNasNetworkServiceDomain)(self->arg_lte_system_info_v2_registration_reject_domain);
    if (value_lte_system_info_v2_registration_reject_cause)
        *value_lte_system_info_v2_registration_reject_cause = (QmiNasRejectCause)(self->arg_lte_system_info_v2_registration_reject_cause);
    if (value_lte_system_info_v2_network_id_valid)
        *value_lte_system_info_v2_network_id_valid = (gboolean)(self->arg_lte_system_info_v2_network_id_valid);
    if (value_lte_system_info_v2_mcc)
        *value_lte_system_info_v2_mcc = self->arg_lte_system_info_v2_mcc;
    if (value_lte_system_info_v2_mnc)
        *value_lte_system_info_v2_mnc = self->arg_lte_system_info_v2_mnc;
    if (value_lte_system_info_v2_tac_valid)
        *value_lte_system_info_v2_tac_valid = (gboolean)(self->arg_lte_system_info_v2_tac_valid);
    if (value_lte_system_info_v2_tac)
        *value_lte_system_info_v2_tac = self->arg_lte_system_info_v2_tac;

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_wcdma_system_info_v2 (
    QmiIndicationNasSystemInfoOutput *self,
    gboolean *value_wcdma_system_info_v2_domain_valid,
    QmiNasNetworkServiceDomain *value_wcdma_system_info_v2_domain,
    gboolean *value_wcdma_system_info_v2_service_capability_valid,
    QmiNasNetworkServiceDomain *value_wcdma_system_info_v2_service_capability,
    gboolean *value_wcdma_system_info_v2_roaming_status_valid,
    QmiNasRoamingStatus *value_wcdma_system_info_v2_roaming_status,
    gboolean *value_wcdma_system_info_v2_forbidden_valid,
    gboolean *value_wcdma_system_info_v2_forbidden,
    gboolean *value_wcdma_system_info_v2_lac_valid,
    guint16 *value_wcdma_system_info_v2_lac,
    gboolean *value_wcdma_system_info_v2_cid_valid,
    guint32 *value_wcdma_system_info_v2_cid,
    gboolean *value_wcdma_system_info_v2_registration_reject_info_valid,
    QmiNasNetworkServiceDomain *value_wcdma_system_info_v2_registration_reject_domain,
    QmiNasRejectCause *value_wcdma_system_info_v2_registration_reject_cause,
    gboolean *value_wcdma_system_info_v2_network_id_valid,
    const gchar **value_wcdma_system_info_v2_mcc,
    const gchar **value_wcdma_system_info_v2_mnc,
    gboolean *value_wcdma_system_info_v2_hs_call_status_valid,
    QmiNasWcdmaHsService *value_wcdma_system_info_v2_hs_call_status,
    gboolean *value_wcdma_system_info_v2_hs_service_valid,
    QmiNasWcdmaHsService *value_wcdma_system_info_v2_hs_service,
    gboolean *value_wcdma_system_info_v2_primary_scrambling_code_valid,
    guint16 *value_wcdma_system_info_v2_primary_scrambling_code,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_wcdma_system_info_v2_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'WCDMA System Info v2' was not found in the message");
        return FALSE;
    }

    if (value_wcdma_system_info_v2_domain_valid)
        *value_wcdma_system_info_v2_domain_valid = (gboolean)(self->arg_wcdma_system_info_v2_domain_valid);
    if (value_wcdma_system_info_v2_domain)
        *value_wcdma_system_info_v2_domain = (QmiNasNetworkServiceDomain)(self->arg_wcdma_system_info_v2_domain);
    if (value_wcdma_system_info_v2_service_capability_valid)
        *value_wcdma_system_info_v2_service_capability_valid = (gboolean)(self->arg_wcdma_system_info_v2_service_capability_valid);
    if (value_wcdma_system_info_v2_service_capability)
        *value_wcdma_system_info_v2_service_capability = (QmiNasNetworkServiceDomain)(self->arg_wcdma_system_info_v2_service_capability);
    if (value_wcdma_system_info_v2_roaming_status_valid)
        *value_wcdma_system_info_v2_roaming_status_valid = (gboolean)(self->arg_wcdma_system_info_v2_roaming_status_valid);
    if (value_wcdma_system_info_v2_roaming_status)
        *value_wcdma_system_info_v2_roaming_status = (QmiNasRoamingStatus)(self->arg_wcdma_system_info_v2_roaming_status);
    if (value_wcdma_system_info_v2_forbidden_valid)
        *value_wcdma_system_info_v2_forbidden_valid = (gboolean)(self->arg_wcdma_system_info_v2_forbidden_valid);
    if (value_wcdma_system_info_v2_forbidden)
        *value_wcdma_system_info_v2_forbidden = (gboolean)(self->arg_wcdma_system_info_v2_forbidden);
    if (value_wcdma_system_info_v2_lac_valid)
        *value_wcdma_system_info_v2_lac_valid = (gboolean)(self->arg_wcdma_system_info_v2_lac_valid);
    if (value_wcdma_system_info_v2_lac)
        *value_wcdma_system_info_v2_lac = self->arg_wcdma_system_info_v2_lac;
    if (value_wcdma_system_info_v2_cid_valid)
        *value_wcdma_system_info_v2_cid_valid = (gboolean)(self->arg_wcdma_system_info_v2_cid_valid);
    if (value_wcdma_system_info_v2_cid)
        *value_wcdma_system_info_v2_cid = self->arg_wcdma_system_info_v2_cid;
    if (value_wcdma_system_info_v2_registration_reject_info_valid)
        *value_wcdma_system_info_v2_registration_reject_info_valid = (gboolean)(self->arg_wcdma_system_info_v2_registration_reject_info_valid);
    if (value_wcdma_system_info_v2_registration_reject_domain)
        *value_wcdma_system_info_v2_registration_reject_domain = (QmiNasNetworkServiceDomain)(self->arg_wcdma_system_info_v2_registration_reject_domain);
    if (value_wcdma_system_info_v2_registration_reject_cause)
        *value_wcdma_system_info_v2_registration_reject_cause = (QmiNasRejectCause)(self->arg_wcdma_system_info_v2_registration_reject_cause);
    if (value_wcdma_system_info_v2_network_id_valid)
        *value_wcdma_system_info_v2_network_id_valid = (gboolean)(self->arg_wcdma_system_info_v2_network_id_valid);
    if (value_wcdma_system_info_v2_mcc)
        *value_wcdma_system_info_v2_mcc = self->arg_wcdma_system_info_v2_mcc;
    if (value_wcdma_system_info_v2_mnc)
        *value_wcdma_system_info_v2_mnc = self->arg_wcdma_system_info_v2_mnc;
    if (value_wcdma_system_info_v2_hs_call_status_valid)
        *value_wcdma_system_info_v2_hs_call_status_valid = (gboolean)(self->arg_wcdma_system_info_v2_hs_call_status_valid);
    if (value_wcdma_system_info_v2_hs_call_status)
        *value_wcdma_system_info_v2_hs_call_status = (QmiNasWcdmaHsService)(self->arg_wcdma_system_info_v2_hs_call_status);
    if (value_wcdma_system_info_v2_hs_service_valid)
        *value_wcdma_system_info_v2_hs_service_valid = (gboolean)(self->arg_wcdma_system_info_v2_hs_service_valid);
    if (value_wcdma_system_info_v2_hs_service)
        *value_wcdma_system_info_v2_hs_service = (QmiNasWcdmaHsService)(self->arg_wcdma_system_info_v2_hs_service);
    if (value_wcdma_system_info_v2_primary_scrambling_code_valid)
        *value_wcdma_system_info_v2_primary_scrambling_code_valid = (gboolean)(self->arg_wcdma_system_info_v2_primary_scrambling_code_valid);
    if (value_wcdma_system_info_v2_primary_scrambling_code)
        *value_wcdma_system_info_v2_primary_scrambling_code = self->arg_wcdma_system_info_v2_primary_scrambling_code;

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_gsm_system_info_v2 (
    QmiIndicationNasSystemInfoOutput *self,
    gboolean *value_gsm_system_info_v2_domain_valid,
    QmiNasNetworkServiceDomain *value_gsm_system_info_v2_domain,
    gboolean *value_gsm_system_info_v2_service_capability_valid,
    QmiNasNetworkServiceDomain *value_gsm_system_info_v2_service_capability,
    gboolean *value_gsm_system_info_v2_roaming_status_valid,
    QmiNasRoamingStatus *value_gsm_system_info_v2_roaming_status,
    gboolean *value_gsm_system_info_v2_forbidden_valid,
    gboolean *value_gsm_system_info_v2_forbidden,
    gboolean *value_gsm_system_info_v2_lac_valid,
    guint16 *value_gsm_system_info_v2_lac,
    gboolean *value_gsm_system_info_v2_cid_valid,
    guint32 *value_gsm_system_info_v2_cid,
    gboolean *value_gsm_system_info_v2_registration_reject_info_valid,
    QmiNasNetworkServiceDomain *value_gsm_system_info_v2_registration_reject_domain,
    QmiNasRejectCause *value_gsm_system_info_v2_registration_reject_cause,
    gboolean *value_gsm_system_info_v2_network_id_valid,
    const gchar **value_gsm_system_info_v2_mcc,
    const gchar **value_gsm_system_info_v2_mnc,
    gboolean *value_gsm_system_info_v2_egprs_support_valid,
    gboolean *value_gsm_system_info_v2_egprs_support,
    gboolean *value_gsm_system_info_v2_dtm_support_valid,
    gboolean *value_gsm_system_info_v2_dtm_support,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_gsm_system_info_v2_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'GSM System Info v2' was not found in the message");
        return FALSE;
    }

    if (value_gsm_system_info_v2_domain_valid)
        *value_gsm_system_info_v2_domain_valid = (gboolean)(self->arg_gsm_system_info_v2_domain_valid);
    if (value_gsm_system_info_v2_domain)
        *value_gsm_system_info_v2_domain = (QmiNasNetworkServiceDomain)(self->arg_gsm_system_info_v2_domain);
    if (value_gsm_system_info_v2_service_capability_valid)
        *value_gsm_system_info_v2_service_capability_valid = (gboolean)(self->arg_gsm_system_info_v2_service_capability_valid);
    if (value_gsm_system_info_v2_service_capability)
        *value_gsm_system_info_v2_service_capability = (QmiNasNetworkServiceDomain)(self->arg_gsm_system_info_v2_service_capability);
    if (value_gsm_system_info_v2_roaming_status_valid)
        *value_gsm_system_info_v2_roaming_status_valid = (gboolean)(self->arg_gsm_system_info_v2_roaming_status_valid);
    if (value_gsm_system_info_v2_roaming_status)
        *value_gsm_system_info_v2_roaming_status = (QmiNasRoamingStatus)(self->arg_gsm_system_info_v2_roaming_status);
    if (value_gsm_system_info_v2_forbidden_valid)
        *value_gsm_system_info_v2_forbidden_valid = (gboolean)(self->arg_gsm_system_info_v2_forbidden_valid);
    if (value_gsm_system_info_v2_forbidden)
        *value_gsm_system_info_v2_forbidden = (gboolean)(self->arg_gsm_system_info_v2_forbidden);
    if (value_gsm_system_info_v2_lac_valid)
        *value_gsm_system_info_v2_lac_valid = (gboolean)(self->arg_gsm_system_info_v2_lac_valid);
    if (value_gsm_system_info_v2_lac)
        *value_gsm_system_info_v2_lac = self->arg_gsm_system_info_v2_lac;
    if (value_gsm_system_info_v2_cid_valid)
        *value_gsm_system_info_v2_cid_valid = (gboolean)(self->arg_gsm_system_info_v2_cid_valid);
    if (value_gsm_system_info_v2_cid)
        *value_gsm_system_info_v2_cid = self->arg_gsm_system_info_v2_cid;
    if (value_gsm_system_info_v2_registration_reject_info_valid)
        *value_gsm_system_info_v2_registration_reject_info_valid = (gboolean)(self->arg_gsm_system_info_v2_registration_reject_info_valid);
    if (value_gsm_system_info_v2_registration_reject_domain)
        *value_gsm_system_info_v2_registration_reject_domain = (QmiNasNetworkServiceDomain)(self->arg_gsm_system_info_v2_registration_reject_domain);
    if (value_gsm_system_info_v2_registration_reject_cause)
        *value_gsm_system_info_v2_registration_reject_cause = (QmiNasRejectCause)(self->arg_gsm_system_info_v2_registration_reject_cause);
    if (value_gsm_system_info_v2_network_id_valid)
        *value_gsm_system_info_v2_network_id_valid = (gboolean)(self->arg_gsm_system_info_v2_network_id_valid);
    if (value_gsm_system_info_v2_mcc)
        *value_gsm_system_info_v2_mcc = self->arg_gsm_system_info_v2_mcc;
    if (value_gsm_system_info_v2_mnc)
        *value_gsm_system_info_v2_mnc = self->arg_gsm_system_info_v2_mnc;
    if (value_gsm_system_info_v2_egprs_support_valid)
        *value_gsm_system_info_v2_egprs_support_valid = (gboolean)(self->arg_gsm_system_info_v2_egprs_support_valid);
    if (value_gsm_system_info_v2_egprs_support)
        *value_gsm_system_info_v2_egprs_support = (gboolean)(self->arg_gsm_system_info_v2_egprs_support);
    if (value_gsm_system_info_v2_dtm_support_valid)
        *value_gsm_system_info_v2_dtm_support_valid = (gboolean)(self->arg_gsm_system_info_v2_dtm_support_valid);
    if (value_gsm_system_info_v2_dtm_support)
        *value_gsm_system_info_v2_dtm_support = (gboolean)(self->arg_gsm_system_info_v2_dtm_support);

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_hdr_system_info (
    QmiIndicationNasSystemInfoOutput *self,
    gboolean *value_hdr_system_info_domain_valid,
    QmiNasNetworkServiceDomain *value_hdr_system_info_domain,
    gboolean *value_hdr_system_info_service_capability_valid,
    QmiNasNetworkServiceDomain *value_hdr_system_info_service_capability,
    gboolean *value_hdr_system_info_roaming_status_valid,
    QmiNasRoamingStatus *value_hdr_system_info_roaming_status,
    gboolean *value_hdr_system_info_forbidden_valid,
    gboolean *value_hdr_system_info_forbidden,
    gboolean *value_hdr_system_info_prl_match_valid,
    gboolean *value_hdr_system_info_prl_match,
    gboolean *value_hdr_system_info_personality_valid,
    QmiNasHdrPersonality *value_hdr_system_info_personality,
    gboolean *value_hdr_system_info_protocol_revision_valid,
    QmiNasHdrProtocolRevision *value_hdr_system_info_protocol_revision,
    gboolean *value_hdr_system_info_is_856_system_id_valid,
    const gchar **value_hdr_system_info_is_856_system_id,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_hdr_system_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'HDR System Info' was not found in the message");
        return FALSE;
    }

    if (value_hdr_system_info_domain_valid)
        *value_hdr_system_info_domain_valid = (gboolean)(self->arg_hdr_system_info_domain_valid);
    if (value_hdr_system_info_domain)
        *value_hdr_system_info_domain = (QmiNasNetworkServiceDomain)(self->arg_hdr_system_info_domain);
    if (value_hdr_system_info_service_capability_valid)
        *value_hdr_system_info_service_capability_valid = (gboolean)(self->arg_hdr_system_info_service_capability_valid);
    if (value_hdr_system_info_service_capability)
        *value_hdr_system_info_service_capability = (QmiNasNetworkServiceDomain)(self->arg_hdr_system_info_service_capability);
    if (value_hdr_system_info_roaming_status_valid)
        *value_hdr_system_info_roaming_status_valid = (gboolean)(self->arg_hdr_system_info_roaming_status_valid);
    if (value_hdr_system_info_roaming_status)
        *value_hdr_system_info_roaming_status = (QmiNasRoamingStatus)(self->arg_hdr_system_info_roaming_status);
    if (value_hdr_system_info_forbidden_valid)
        *value_hdr_system_info_forbidden_valid = (gboolean)(self->arg_hdr_system_info_forbidden_valid);
    if (value_hdr_system_info_forbidden)
        *value_hdr_system_info_forbidden = (gboolean)(self->arg_hdr_system_info_forbidden);
    if (value_hdr_system_info_prl_match_valid)
        *value_hdr_system_info_prl_match_valid = (gboolean)(self->arg_hdr_system_info_prl_match_valid);
    if (value_hdr_system_info_prl_match)
        *value_hdr_system_info_prl_match = (gboolean)(self->arg_hdr_system_info_prl_match);
    if (value_hdr_system_info_personality_valid)
        *value_hdr_system_info_personality_valid = (gboolean)(self->arg_hdr_system_info_personality_valid);
    if (value_hdr_system_info_personality)
        *value_hdr_system_info_personality = (QmiNasHdrPersonality)(self->arg_hdr_system_info_personality);
    if (value_hdr_system_info_protocol_revision_valid)
        *value_hdr_system_info_protocol_revision_valid = (gboolean)(self->arg_hdr_system_info_protocol_revision_valid);
    if (value_hdr_system_info_protocol_revision)
        *value_hdr_system_info_protocol_revision = (QmiNasHdrProtocolRevision)(self->arg_hdr_system_info_protocol_revision);
    if (value_hdr_system_info_is_856_system_id_valid)
        *value_hdr_system_info_is_856_system_id_valid = (gboolean)(self->arg_hdr_system_info_is_856_system_id_valid);
    if (value_hdr_system_info_is_856_system_id)
        *value_hdr_system_info_is_856_system_id = self->arg_hdr_system_info_is_856_system_id;

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_cdma_system_info (
    QmiIndicationNasSystemInfoOutput *self,
    gboolean *value_cdma_system_info_domain_valid,
    QmiNasNetworkServiceDomain *value_cdma_system_info_domain,
    gboolean *value_cdma_system_info_service_capability_valid,
    QmiNasNetworkServiceDomain *value_cdma_system_info_service_capability,
    gboolean *value_cdma_system_info_roaming_status_valid,
    QmiNasRoamingStatus *value_cdma_system_info_roaming_status,
    gboolean *value_cdma_system_info_forbidden_valid,
    gboolean *value_cdma_system_info_forbidden,
    gboolean *value_cdma_system_info_prl_match_valid,
    gboolean *value_cdma_system_info_prl_match,
    gboolean *value_cdma_system_info_p_rev_valid,
    guint8 *value_cdma_system_info_p_rev,
    gboolean *value_cdma_system_info_base_station_p_rev_valid,
    guint8 *value_cdma_system_info_base_station_p_rev,
    gboolean *value_cdma_system_info_concurrent_service_support_valid,
    gboolean *value_cdma_system_info_concurrent_service_support,
    gboolean *value_cdma_system_info_cdma_system_id_valid,
    guint16 *value_cdma_system_info_sid,
    guint16 *value_cdma_system_info_nid,
    gboolean *value_cdma_system_info_base_station_info_valid,
    guint16 *value_cdma_system_info_base_station_id,
    gint32 *value_cdma_system_info_base_station_latitude,
    gint32 *value_cdma_system_info_base_station_longitude,
    gboolean *value_cdma_system_info_packet_zone_valid,
    guint16 *value_cdma_system_info_packet_zone,
    gboolean *value_cdma_system_info_network_id_valid,
    const gchar **value_cdma_system_info_mcc,
    const gchar **value_cdma_system_info_mnc,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_cdma_system_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'CDMA System Info' was not found in the message");
        return FALSE;
    }

    if (value_cdma_system_info_domain_valid)
        *value_cdma_system_info_domain_valid = (gboolean)(self->arg_cdma_system_info_domain_valid);
    if (value_cdma_system_info_domain)
        *value_cdma_system_info_domain = (QmiNasNetworkServiceDomain)(self->arg_cdma_system_info_domain);
    if (value_cdma_system_info_service_capability_valid)
        *value_cdma_system_info_service_capability_valid = (gboolean)(self->arg_cdma_system_info_service_capability_valid);
    if (value_cdma_system_info_service_capability)
        *value_cdma_system_info_service_capability = (QmiNasNetworkServiceDomain)(self->arg_cdma_system_info_service_capability);
    if (value_cdma_system_info_roaming_status_valid)
        *value_cdma_system_info_roaming_status_valid = (gboolean)(self->arg_cdma_system_info_roaming_status_valid);
    if (value_cdma_system_info_roaming_status)
        *value_cdma_system_info_roaming_status = (QmiNasRoamingStatus)(self->arg_cdma_system_info_roaming_status);
    if (value_cdma_system_info_forbidden_valid)
        *value_cdma_system_info_forbidden_valid = (gboolean)(self->arg_cdma_system_info_forbidden_valid);
    if (value_cdma_system_info_forbidden)
        *value_cdma_system_info_forbidden = (gboolean)(self->arg_cdma_system_info_forbidden);
    if (value_cdma_system_info_prl_match_valid)
        *value_cdma_system_info_prl_match_valid = (gboolean)(self->arg_cdma_system_info_prl_match_valid);
    if (value_cdma_system_info_prl_match)
        *value_cdma_system_info_prl_match = (gboolean)(self->arg_cdma_system_info_prl_match);
    if (value_cdma_system_info_p_rev_valid)
        *value_cdma_system_info_p_rev_valid = (gboolean)(self->arg_cdma_system_info_p_rev_valid);
    if (value_cdma_system_info_p_rev)
        *value_cdma_system_info_p_rev = self->arg_cdma_system_info_p_rev;
    if (value_cdma_system_info_base_station_p_rev_valid)
        *value_cdma_system_info_base_station_p_rev_valid = (gboolean)(self->arg_cdma_system_info_base_station_p_rev_valid);
    if (value_cdma_system_info_base_station_p_rev)
        *value_cdma_system_info_base_station_p_rev = self->arg_cdma_system_info_base_station_p_rev;
    if (value_cdma_system_info_concurrent_service_support_valid)
        *value_cdma_system_info_concurrent_service_support_valid = (gboolean)(self->arg_cdma_system_info_concurrent_service_support_valid);
    if (value_cdma_system_info_concurrent_service_support)
        *value_cdma_system_info_concurrent_service_support = (gboolean)(self->arg_cdma_system_info_concurrent_service_support);
    if (value_cdma_system_info_cdma_system_id_valid)
        *value_cdma_system_info_cdma_system_id_valid = (gboolean)(self->arg_cdma_system_info_cdma_system_id_valid);
    if (value_cdma_system_info_sid)
        *value_cdma_system_info_sid = self->arg_cdma_system_info_sid;
    if (value_cdma_system_info_nid)
        *value_cdma_system_info_nid = self->arg_cdma_system_info_nid;
    if (value_cdma_system_info_base_station_info_valid)
        *value_cdma_system_info_base_station_info_valid = (gboolean)(self->arg_cdma_system_info_base_station_info_valid);
    if (value_cdma_system_info_base_station_id)
        *value_cdma_system_info_base_station_id = self->arg_cdma_system_info_base_station_id;
    if (value_cdma_system_info_base_station_latitude)
        *value_cdma_system_info_base_station_latitude = self->arg_cdma_system_info_base_station_latitude;
    if (value_cdma_system_info_base_station_longitude)
        *value_cdma_system_info_base_station_longitude = self->arg_cdma_system_info_base_station_longitude;
    if (value_cdma_system_info_packet_zone_valid)
        *value_cdma_system_info_packet_zone_valid = (gboolean)(self->arg_cdma_system_info_packet_zone_valid);
    if (value_cdma_system_info_packet_zone)
        *value_cdma_system_info_packet_zone = self->arg_cdma_system_info_packet_zone;
    if (value_cdma_system_info_network_id_valid)
        *value_cdma_system_info_network_id_valid = (gboolean)(self->arg_cdma_system_info_network_id_valid);
    if (value_cdma_system_info_mcc)
        *value_cdma_system_info_mcc = self->arg_cdma_system_info_mcc;
    if (value_cdma_system_info_mnc)
        *value_cdma_system_info_mnc = self->arg_cdma_system_info_mnc;

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_lte_service_status (
    QmiIndicationNasSystemInfoOutput *self,
    QmiNasServiceStatus *value_lte_service_status_service_status,
    QmiNasServiceStatus *value_lte_service_status_true_service_status,
    gboolean *value_lte_service_status_preferred_data_path,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_lte_service_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'LTE Service Status' was not found in the message");
        return FALSE;
    }

    if (value_lte_service_status_service_status)
        *value_lte_service_status_service_status = (QmiNasServiceStatus)(self->arg_lte_service_status_service_status);
    if (value_lte_service_status_true_service_status)
        *value_lte_service_status_true_service_status = (QmiNasServiceStatus)(self->arg_lte_service_status_true_service_status);
    if (value_lte_service_status_preferred_data_path)
        *value_lte_service_status_preferred_data_path = (gboolean)(self->arg_lte_service_status_preferred_data_path);

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_wcdma_service_status (
    QmiIndicationNasSystemInfoOutput *self,
    QmiNasServiceStatus *value_wcdma_service_status_service_status,
    QmiNasServiceStatus *value_wcdma_service_status_true_service_status,
    gboolean *value_wcdma_service_status_preferred_data_path,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_wcdma_service_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'WCDMA Service Status' was not found in the message");
        return FALSE;
    }

    if (value_wcdma_service_status_service_status)
        *value_wcdma_service_status_service_status = (QmiNasServiceStatus)(self->arg_wcdma_service_status_service_status);
    if (value_wcdma_service_status_true_service_status)
        *value_wcdma_service_status_true_service_status = (QmiNasServiceStatus)(self->arg_wcdma_service_status_true_service_status);
    if (value_wcdma_service_status_preferred_data_path)
        *value_wcdma_service_status_preferred_data_path = (gboolean)(self->arg_wcdma_service_status_preferred_data_path);

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_gsm_service_status (
    QmiIndicationNasSystemInfoOutput *self,
    QmiNasServiceStatus *value_gsm_service_status_service_status,
    QmiNasServiceStatus *value_gsm_service_status_true_service_status,
    gboolean *value_gsm_service_status_preferred_data_path,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_gsm_service_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'GSM Service Status' was not found in the message");
        return FALSE;
    }

    if (value_gsm_service_status_service_status)
        *value_gsm_service_status_service_status = (QmiNasServiceStatus)(self->arg_gsm_service_status_service_status);
    if (value_gsm_service_status_true_service_status)
        *value_gsm_service_status_true_service_status = (QmiNasServiceStatus)(self->arg_gsm_service_status_true_service_status);
    if (value_gsm_service_status_preferred_data_path)
        *value_gsm_service_status_preferred_data_path = (gboolean)(self->arg_gsm_service_status_preferred_data_path);

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_hdr_service_status (
    QmiIndicationNasSystemInfoOutput *self,
    QmiNasServiceStatus *value_hdr_service_status_service_status,
    gboolean *value_hdr_service_status_preferred_data_path,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_hdr_service_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'HDR Service Status' was not found in the message");
        return FALSE;
    }

    if (value_hdr_service_status_service_status)
        *value_hdr_service_status_service_status = (QmiNasServiceStatus)(self->arg_hdr_service_status_service_status);
    if (value_hdr_service_status_preferred_data_path)
        *value_hdr_service_status_preferred_data_path = (gboolean)(self->arg_hdr_service_status_preferred_data_path);

    return TRUE;
}

gboolean
qmi_indication_nas_system_info_output_get_cdma_service_status (
    QmiIndicationNasSystemInfoOutput *self,
    QmiNasServiceStatus *value_cdma_service_status_service_status,
    gboolean *value_cdma_service_status_preferred_data_path,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_cdma_service_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'CDMA Service Status' was not found in the message");
        return FALSE;
    }

    if (value_cdma_service_status_service_status)
        *value_cdma_service_status_service_status = (QmiNasServiceStatus)(self->arg_cdma_service_status_service_status);
    if (value_cdma_service_status_preferred_data_path)
        *value_cdma_service_status_preferred_data_path = (gboolean)(self->arg_cdma_service_status_preferred_data_path);

    return TRUE;
}

GType
qmi_indication_nas_system_info_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiIndicationNasSystemInfoOutput"),
                                          (GBoxedCopyFunc) qmi_indication_nas_system_info_output_ref,
                                          (GBoxedFreeFunc) qmi_indication_nas_system_info_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiIndicationNasSystemInfoOutput *
qmi_indication_nas_system_info_output_ref (QmiIndicationNasSystemInfoOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_indication_nas_system_info_output_unref (QmiIndicationNasSystemInfoOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_nr5g_tracking_area_code, (GDestroyNotify)g_array_unref);
        g_slice_free (QmiIndicationNasSystemInfoOutput, self);
    }
}

static gchar *
qmi_indication_nas_system_info_output_nr5g_tracking_area_code_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_NR5G_TRACKING_AREA_CODE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint nr5g_tracking_area_code_i;
        guint16 nr5g_tracking_area_code_n_items = 3;


        g_string_append (printable, "{");

        for (nr5g_tracking_area_code_i = 0; nr5g_tracking_area_code_i < nr5g_tracking_area_code_n_items; nr5g_tracking_area_code_i++) {
            g_string_append_printf (printable, " [%u] = '", nr5g_tracking_area_code_i);

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%u", (guint)tmp);
                }
            }
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_dcnr_restriction_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_DCNR_RESTRICTION_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_eutra_with_nr5g_availability_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_EUTRA_WITH_NR5G_AVAILABILITY, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_nr5g_system_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_NR5G_SYSTEM_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " domain_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " domain = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " service_capability_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " service_capability = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " roaming_status_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " roaming_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_ROAMING_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_roaming_status_get_string ((QmiNasRoamingStatus)tmp));
#elif defined  __QMI_NAS_ROAMING_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_roaming_status_build_string_from_mask ((QmiNasRoamingStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRoamingStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " forbidden_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " forbidden = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " lac_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " lac = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " cid_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " cid = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " registration_reject_info_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " registration_reject_domain = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " registration_reject_cause = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " network_id_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " mcc = '");

    {
        gchar tmp[4] = { '\0' };

        if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &tmp[0], &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " mnc = '");

    {
        gchar tmp[4] = { '\0' };

        if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &tmp[0], &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " tac_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " tac = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_nr5g_service_status_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_NR5G_SERVICE_STATUS_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " service_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_SERVICE_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_service_status_get_string ((QmiNasServiceStatus)tmp));
#elif defined  __QMI_NAS_SERVICE_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_service_status_build_string_from_mask ((QmiNasServiceStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasServiceStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " true_service_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_SERVICE_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_service_status_get_string ((QmiNasServiceStatus)tmp));
#elif defined  __QMI_NAS_SERVICE_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_service_status_build_string_from_mask ((QmiNasServiceStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasServiceStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " preferred_data_path = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_sim_reject_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_SIM_REJECT_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_SIM_REJECT_STATE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_sim_reject_state_get_string ((QmiNasSimRejectState)tmp));
#elif defined  __QMI_NAS_SIM_REJECT_STATE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_sim_reject_state_build_string_from_mask ((QmiNasSimRejectState)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasSimRejectState
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_lte_embms_coverage_info_support_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_LTE_EMBMS_COVERAGE_INFO_SUPPORT, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_td_scma_system_info_v2_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_TD_SCMA_SYSTEM_INFO_V2, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " domain_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " domain = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " service_capability_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " service_capability = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " roaming_status_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " roaming_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_ROAMING_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_roaming_status_get_string ((QmiNasRoamingStatus)tmp));
#elif defined  __QMI_NAS_ROAMING_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_roaming_status_build_string_from_mask ((QmiNasRoamingStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRoamingStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " forbidden_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " forbidden = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " lac_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " lac = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " cid_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " cid = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " registration_reject_info_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " registration_reject_domain = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " registration_reject_cause = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_REJECT_CAUSE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_reject_cause_get_string ((QmiNasRejectCause)tmp));
#elif defined  __QMI_NAS_REJECT_CAUSE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_reject_cause_build_string_from_mask ((QmiNasRejectCause)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRejectCause
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " network_id_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " mcc = '");

    {
        gchar tmp[4] = { '\0' };

        if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &tmp[0], &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " mnc = '");

    {
        gchar tmp[4] = { '\0' };

        if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &tmp[0], &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " hs_call_status_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " hs_call_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_WCDMA_HS_SERVICE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_wcdma_hs_service_get_string ((QmiNasWcdmaHsService)tmp));
#elif defined  __QMI_NAS_WCDMA_HS_SERVICE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_wcdma_hs_service_build_string_from_mask ((QmiNasWcdmaHsService)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasWcdmaHsService
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " hs_service_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " hs_service = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_WCDMA_HS_SERVICE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_wcdma_hs_service_get_string ((QmiNasWcdmaHsService)tmp));
#elif defined  __QMI_NAS_WCDMA_HS_SERVICE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_wcdma_hs_service_build_string_from_mask ((QmiNasWcdmaHsService)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasWcdmaHsService
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " cell_parameter_id_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " cell_parameter_id = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " cell_broadcast_support_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " cell_broadcast_support = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_CELL_BROADCAST_CAPABILITY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_cell_broadcast_capability_get_string ((QmiNasCellBroadcastCapability)tmp));
#elif defined  __QMI_NAS_CELL_BROADCAST_CAPABILITY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_cell_broadcast_capability_build_string_from_mask ((QmiNasCellBroadcastCapability)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasCellBroadcastCapability
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " cs_call_barring_status_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " cs_call_barring_status = '");

    {
        gint32 tmp;

        if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_CALL_BARRING_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_call_barring_status_get_string ((QmiNasCallBarringStatus)tmp));
#elif defined  __QMI_NAS_CALL_BARRING_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_call_barring_status_build_string_from_mask ((QmiNasCallBarringStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasCallBarringStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ps_call_barring_status_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ps_call_barring_status = '");

    {
        gint32 tmp;

        if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_CALL_BARRING_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_call_barring_status_get_string ((QmiNasCallBarringStatus)tmp));
#elif defined  __QMI_NAS_CALL_BARRING_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_call_barring_status_build_string_from_mask ((QmiNasCallBarringStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasCallBarringStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " cipher_domain_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " cipher_domain = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_td_scdma_service_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_TD_SCDMA_SERVICE_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " service_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_SERVICE_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_service_status_get_string ((QmiNasServiceStatus)tmp));
#elif defined  __QMI_NAS_SERVICE_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_service_status_build_string_from_mask ((QmiNasServiceStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasServiceStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " true_service_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_SERVICE_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_service_status_get_string ((QmiNasServiceStatus)tmp));
#elif defined  __QMI_NAS_SERVICE_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_service_status_build_string_from_mask ((QmiNasServiceStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasServiceStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " preferred_data_path = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_plmn_not_changed_indication_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_PLMN_NOT_CHANGED_INDICATION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_wcdma_cipher_domain_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_WCDMA_CIPHER_DOMAIN, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_gsm_cipher_domain_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_GSM_CIPHER_DOMAIN, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_lte_voice_support_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_LTE_VOICE_SUPPORT, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_wcdma_call_barring_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_WCDMA_CALL_BARRING_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " cs_status = '");

    {
        gint32 tmp;

        if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_CALL_BARRING_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_call_barring_status_get_string ((QmiNasCallBarringStatus)tmp));
#elif defined  __QMI_NAS_CALL_BARRING_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_call_barring_status_build_string_from_mask ((QmiNasCallBarringStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasCallBarringStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ps_status = '");

    {
        gint32 tmp;

        if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_CALL_BARRING_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_call_barring_status_get_string ((QmiNasCallBarringStatus)tmp));
#elif defined  __QMI_NAS_CALL_BARRING_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_call_barring_status_build_string_from_mask ((QmiNasCallBarringStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasCallBarringStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_gsm_call_barring_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_GSM_CALL_BARRING_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " cs_status = '");

    {
        gint32 tmp;

        if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_CALL_BARRING_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_call_barring_status_get_string ((QmiNasCallBarringStatus)tmp));
#elif defined  __QMI_NAS_CALL_BARRING_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_call_barring_status_build_string_from_mask ((QmiNasCallBarringStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasCallBarringStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ps_status = '");

    {
        gint32 tmp;

        if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_CALL_BARRING_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_call_barring_status_get_string ((QmiNasCallBarringStatus)tmp));
#elif defined  __QMI_NAS_CALL_BARRING_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_call_barring_status_build_string_from_mask ((QmiNasCallBarringStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasCallBarringStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_additional_lte_system_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_ADDITIONAL_LTE_SYSTEM_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " geo_system_index = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_additional_wcdma_system_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_ADDITIONAL_WCDMA_SYSTEM_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " geo_system_index = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " cell_broadcast_support = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_CELL_BROADCAST_CAPABILITY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_cell_broadcast_capability_get_string ((QmiNasCellBroadcastCapability)tmp));
#elif defined  __QMI_NAS_CELL_BROADCAST_CAPABILITY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_cell_broadcast_capability_build_string_from_mask ((QmiNasCellBroadcastCapability)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasCellBroadcastCapability
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_additional_gsm_system_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_ADDITIONAL_GSM_SYSTEM_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " geo_system_index = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " cell_broadcast_support = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_CELL_BROADCAST_CAPABILITY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_cell_broadcast_capability_get_string ((QmiNasCellBroadcastCapability)tmp));
#elif defined  __QMI_NAS_CELL_BROADCAST_CAPABILITY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_cell_broadcast_capability_build_string_from_mask ((QmiNasCellBroadcastCapability)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasCellBroadcastCapability
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_additional_hdr_system_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_ADDITIONAL_HDR_SYSTEM_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " geo_system_index = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_additional_cdma_system_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_ADDITIONAL_CDMA_SYSTEM_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " geo_system_index = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " registration_period = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_lte_system_info_v2_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_LTE_SYSTEM_INFO_V2, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " domain_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " domain = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " service_capability_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " service_capability = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " roaming_status_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " roaming_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_ROAMING_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_roaming_status_get_string ((QmiNasRoamingStatus)tmp));
#elif defined  __QMI_NAS_ROAMING_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_roaming_status_build_string_from_mask ((QmiNasRoamingStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRoamingStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " forbidden_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " forbidden = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " lac_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " lac = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " cid_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " cid = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " registration_reject_info_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " registration_reject_domain = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " registration_reject_cause = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_REJECT_CAUSE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_reject_cause_get_string ((QmiNasRejectCause)tmp));
#elif defined  __QMI_NAS_REJECT_CAUSE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_reject_cause_build_string_from_mask ((QmiNasRejectCause)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRejectCause
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " network_id_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " mcc = '");

    {
        gchar tmp[4] = { '\0' };

        if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &tmp[0], &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " mnc = '");

    {
        gchar tmp[4] = { '\0' };

        if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &tmp[0], &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " tac_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " tac = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_wcdma_system_info_v2_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_WCDMA_SYSTEM_INFO_V2, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " domain_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " domain = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " service_capability_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " service_capability = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " roaming_status_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " roaming_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_ROAMING_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_roaming_status_get_string ((QmiNasRoamingStatus)tmp));
#elif defined  __QMI_NAS_ROAMING_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_roaming_status_build_string_from_mask ((QmiNasRoamingStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRoamingStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " forbidden_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " forbidden = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " lac_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " lac = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " cid_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " cid = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " registration_reject_info_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " registration_reject_domain = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " registration_reject_cause = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_REJECT_CAUSE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_reject_cause_get_string ((QmiNasRejectCause)tmp));
#elif defined  __QMI_NAS_REJECT_CAUSE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_reject_cause_build_string_from_mask ((QmiNasRejectCause)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRejectCause
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " network_id_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " mcc = '");

    {
        gchar tmp[4] = { '\0' };

        if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &tmp[0], &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " mnc = '");

    {
        gchar tmp[4] = { '\0' };

        if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &tmp[0], &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " hs_call_status_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " hs_call_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_WCDMA_HS_SERVICE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_wcdma_hs_service_get_string ((QmiNasWcdmaHsService)tmp));
#elif defined  __QMI_NAS_WCDMA_HS_SERVICE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_wcdma_hs_service_build_string_from_mask ((QmiNasWcdmaHsService)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasWcdmaHsService
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " hs_service_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " hs_service = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_WCDMA_HS_SERVICE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_wcdma_hs_service_get_string ((QmiNasWcdmaHsService)tmp));
#elif defined  __QMI_NAS_WCDMA_HS_SERVICE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_wcdma_hs_service_build_string_from_mask ((QmiNasWcdmaHsService)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasWcdmaHsService
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " primary_scrambling_code_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " primary_scrambling_code = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_gsm_system_info_v2_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_GSM_SYSTEM_INFO_V2, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " domain_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " domain = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " service_capability_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " service_capability = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " roaming_status_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " roaming_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_ROAMING_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_roaming_status_get_string ((QmiNasRoamingStatus)tmp));
#elif defined  __QMI_NAS_ROAMING_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_roaming_status_build_string_from_mask ((QmiNasRoamingStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRoamingStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " forbidden_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " forbidden = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " lac_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " lac = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " cid_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " cid = '");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " registration_reject_info_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " registration_reject_domain = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " registration_reject_cause = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_REJECT_CAUSE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_reject_cause_get_string ((QmiNasRejectCause)tmp));
#elif defined  __QMI_NAS_REJECT_CAUSE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_reject_cause_build_string_from_mask ((QmiNasRejectCause)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRejectCause
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " network_id_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " mcc = '");

    {
        gchar tmp[4] = { '\0' };

        if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &tmp[0], &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " mnc = '");

    {
        gchar tmp[4] = { '\0' };

        if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &tmp[0], &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " egprs_support_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " egprs_support = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " dtm_support_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " dtm_support = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_hdr_system_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_HDR_SYSTEM_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " domain_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " domain = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " service_capability_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " service_capability = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " roaming_status_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " roaming_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_ROAMING_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_roaming_status_get_string ((QmiNasRoamingStatus)tmp));
#elif defined  __QMI_NAS_ROAMING_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_roaming_status_build_string_from_mask ((QmiNasRoamingStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRoamingStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " forbidden_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " forbidden = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " prl_match_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " prl_match = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " personality_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " personality = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_HDR_PERSONALITY_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_hdr_personality_get_string ((QmiNasHdrPersonality)tmp));
#elif defined  __QMI_NAS_HDR_PERSONALITY_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_hdr_personality_build_string_from_mask ((QmiNasHdrPersonality)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasHdrPersonality
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " protocol_revision_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " protocol_revision = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_HDR_PROTOCOL_REVISION_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_hdr_protocol_revision_get_string ((QmiNasHdrProtocolRevision)tmp));
#elif defined  __QMI_NAS_HDR_PROTOCOL_REVISION_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_hdr_protocol_revision_build_string_from_mask ((QmiNasHdrProtocolRevision)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasHdrProtocolRevision
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " is_856_system_id_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " is_856_system_id = '");

    {
        gchar tmp[17] = { '\0' };

        if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 16, &tmp[0], &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_cdma_system_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_CDMA_SYSTEM_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " domain_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " domain = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " service_capability_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " service_capability = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " roaming_status_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " roaming_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_ROAMING_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_roaming_status_get_string ((QmiNasRoamingStatus)tmp));
#elif defined  __QMI_NAS_ROAMING_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_roaming_status_build_string_from_mask ((QmiNasRoamingStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRoamingStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " forbidden_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " forbidden = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " prl_match_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " prl_match = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " p_rev_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " p_rev = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " base_station_p_rev_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " base_station_p_rev = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " concurrent_service_support_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " concurrent_service_support = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " cdma_system_id_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " sid = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " nid = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " base_station_info_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " base_station_id = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " base_station_latitude = '");

    {
        gint32 tmp;

        if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " base_station_longitude = '");

    {
        gint32 tmp;

        if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " packet_zone_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " packet_zone = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " network_id_valid = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " mcc = '");

    {
        gchar tmp[4] = { '\0' };

        if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &tmp[0], &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " mnc = '");

    {
        gchar tmp[4] = { '\0' };

        if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &tmp[0], &error))
            goto out;
        {
            g_string_append (printable, tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_lte_service_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_LTE_SERVICE_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " service_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_SERVICE_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_service_status_get_string ((QmiNasServiceStatus)tmp));
#elif defined  __QMI_NAS_SERVICE_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_service_status_build_string_from_mask ((QmiNasServiceStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasServiceStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " true_service_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_SERVICE_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_service_status_get_string ((QmiNasServiceStatus)tmp));
#elif defined  __QMI_NAS_SERVICE_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_service_status_build_string_from_mask ((QmiNasServiceStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasServiceStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " preferred_data_path = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_wcdma_service_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_WCDMA_SERVICE_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " service_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_SERVICE_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_service_status_get_string ((QmiNasServiceStatus)tmp));
#elif defined  __QMI_NAS_SERVICE_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_service_status_build_string_from_mask ((QmiNasServiceStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasServiceStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " true_service_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_SERVICE_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_service_status_get_string ((QmiNasServiceStatus)tmp));
#elif defined  __QMI_NAS_SERVICE_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_service_status_build_string_from_mask ((QmiNasServiceStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasServiceStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " preferred_data_path = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_gsm_service_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_GSM_SERVICE_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " service_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_SERVICE_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_service_status_get_string ((QmiNasServiceStatus)tmp));
#elif defined  __QMI_NAS_SERVICE_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_service_status_build_string_from_mask ((QmiNasServiceStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasServiceStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " true_service_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_SERVICE_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_service_status_get_string ((QmiNasServiceStatus)tmp));
#elif defined  __QMI_NAS_SERVICE_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_service_status_build_string_from_mask ((QmiNasServiceStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasServiceStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " preferred_data_path = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_hdr_service_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_HDR_SERVICE_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " service_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_SERVICE_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_service_status_get_string ((QmiNasServiceStatus)tmp));
#elif defined  __QMI_NAS_SERVICE_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_service_status_build_string_from_mask ((QmiNasServiceStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasServiceStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " preferred_data_path = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_system_info_output_cdma_service_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_CDMA_SERVICE_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " service_status = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_SERVICE_STATUS_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_service_status_get_string ((QmiNasServiceStatus)tmp));
#elif defined  __QMI_NAS_SERVICE_STATUS_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_service_status_build_string_from_mask ((QmiNasServiceStatus)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasServiceStatus
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " preferred_data_path = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct indication_system_info_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
indication_system_info_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct indication_system_info_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    {
        switch (type) {
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_NR5G_TRACKING_AREA_CODE:
            tlv_type_str = "NR5G Tracking Area Code";
            translated_value = qmi_indication_nas_system_info_output_nr5g_tracking_area_code_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_DCNR_RESTRICTION_INFO:
            tlv_type_str = "DCNR restriction Info";
            translated_value = qmi_indication_nas_system_info_output_dcnr_restriction_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_EUTRA_WITH_NR5G_AVAILABILITY:
            tlv_type_str = "EUTRA with NR5G availability";
            translated_value = qmi_indication_nas_system_info_output_eutra_with_nr5g_availability_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_NR5G_SYSTEM_INFO:
            tlv_type_str = "NR5G System Info";
            translated_value = qmi_indication_nas_system_info_output_nr5g_system_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_NR5G_SERVICE_STATUS_INFO:
            tlv_type_str = "NR5G Service Status Info";
            translated_value = qmi_indication_nas_system_info_output_nr5g_service_status_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_SIM_REJECT_INFO:
            tlv_type_str = "SIM Reject Info";
            translated_value = qmi_indication_nas_system_info_output_sim_reject_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_LTE_EMBMS_COVERAGE_INFO_SUPPORT:
            tlv_type_str = "LTE eMBMS Coverage Info Support";
            translated_value = qmi_indication_nas_system_info_output_lte_embms_coverage_info_support_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_TD_SCMA_SYSTEM_INFO_V2:
            tlv_type_str = "TD SCMA System Info v2";
            translated_value = qmi_indication_nas_system_info_output_td_scma_system_info_v2_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_TD_SCDMA_SERVICE_STATUS:
            tlv_type_str = "TD SCDMA Service Status";
            translated_value = qmi_indication_nas_system_info_output_td_scdma_service_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_PLMN_NOT_CHANGED_INDICATION:
            tlv_type_str = "PLMN Not Changed Indication";
            translated_value = qmi_indication_nas_system_info_output_plmn_not_changed_indication_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_WCDMA_CIPHER_DOMAIN:
            tlv_type_str = "WCDMA Cipher Domain";
            translated_value = qmi_indication_nas_system_info_output_wcdma_cipher_domain_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_GSM_CIPHER_DOMAIN:
            tlv_type_str = "GSM Cipher Domain";
            translated_value = qmi_indication_nas_system_info_output_gsm_cipher_domain_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_LTE_VOICE_SUPPORT:
            tlv_type_str = "LTE Voice Support";
            translated_value = qmi_indication_nas_system_info_output_lte_voice_support_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_WCDMA_CALL_BARRING_STATUS:
            tlv_type_str = "WCDMA Call Barring Status";
            translated_value = qmi_indication_nas_system_info_output_wcdma_call_barring_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_GSM_CALL_BARRING_STATUS:
            tlv_type_str = "GSM Call Barring Status";
            translated_value = qmi_indication_nas_system_info_output_gsm_call_barring_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_ADDITIONAL_LTE_SYSTEM_INFO:
            tlv_type_str = "Additional LTE System Info";
            translated_value = qmi_indication_nas_system_info_output_additional_lte_system_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_ADDITIONAL_WCDMA_SYSTEM_INFO:
            tlv_type_str = "Additional WCDMA System Info";
            translated_value = qmi_indication_nas_system_info_output_additional_wcdma_system_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_ADDITIONAL_GSM_SYSTEM_INFO:
            tlv_type_str = "Additional GSM System Info";
            translated_value = qmi_indication_nas_system_info_output_additional_gsm_system_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_ADDITIONAL_HDR_SYSTEM_INFO:
            tlv_type_str = "Additional HDR System Info";
            translated_value = qmi_indication_nas_system_info_output_additional_hdr_system_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_ADDITIONAL_CDMA_SYSTEM_INFO:
            tlv_type_str = "Additional CDMA System Info";
            translated_value = qmi_indication_nas_system_info_output_additional_cdma_system_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_LTE_SYSTEM_INFO_V2:
            tlv_type_str = "LTE System Info v2";
            translated_value = qmi_indication_nas_system_info_output_lte_system_info_v2_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_WCDMA_SYSTEM_INFO_V2:
            tlv_type_str = "WCDMA System Info v2";
            translated_value = qmi_indication_nas_system_info_output_wcdma_system_info_v2_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_GSM_SYSTEM_INFO_V2:
            tlv_type_str = "GSM System Info v2";
            translated_value = qmi_indication_nas_system_info_output_gsm_system_info_v2_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_HDR_SYSTEM_INFO:
            tlv_type_str = "HDR System Info";
            translated_value = qmi_indication_nas_system_info_output_hdr_system_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_CDMA_SYSTEM_INFO:
            tlv_type_str = "CDMA System Info";
            translated_value = qmi_indication_nas_system_info_output_cdma_system_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_LTE_SERVICE_STATUS:
            tlv_type_str = "LTE Service Status";
            translated_value = qmi_indication_nas_system_info_output_lte_service_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_WCDMA_SERVICE_STATUS:
            tlv_type_str = "WCDMA Service Status";
            translated_value = qmi_indication_nas_system_info_output_wcdma_service_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_GSM_SERVICE_STATUS:
            tlv_type_str = "GSM Service Status";
            translated_value = qmi_indication_nas_system_info_output_gsm_service_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_HDR_SERVICE_STATUS:
            tlv_type_str = "HDR Service Status";
            translated_value = qmi_indication_nas_system_info_output_hdr_service_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_CDMA_SERVICE_STATUS:
            tlv_type_str = "CDMA Service Status";
            translated_value = qmi_indication_nas_system_info_output_cdma_service_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
indication_system_info_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"System Info\" (0x004E)\n",
                            line_prefix);

    {
        struct indication_system_info_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)indication_system_info_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiIndicationNasSystemInfoOutput *
qmi_indication_nas_system_info_indication_parse (
    QmiMessage *message,
    GError **error)
{
    QmiIndicationNasSystemInfoOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_INDICATION_NAS_SYSTEM_INFO);

    self = g_slice_new0 (QmiIndicationNasSystemInfoOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_NR5G_TRACKING_AREA_CODE, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_nr5g_tracking_area_code_out;
            }
            {
                guint nr5g_tracking_area_code_i;
                guint16 nr5g_tracking_area_code_n_items = 3;


                self->arg_nr5g_tracking_area_code = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (guint8),
                    (guint)nr5g_tracking_area_code_n_items);

                for (nr5g_tracking_area_code_i = 0; nr5g_tracking_area_code_i < nr5g_tracking_area_code_n_items; nr5g_tracking_area_code_i++) {
                    guint8 nr5g_tracking_area_code_aux;

                    if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(nr5g_tracking_area_code_aux), NULL))
                        goto qmi_indication_nas_system_info_output_nr5g_tracking_area_code_out;
                    g_array_insert_val (self->arg_nr5g_tracking_area_code, nr5g_tracking_area_code_i, nr5g_tracking_area_code_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'NR5G Tracking Area Code' TLV", offset);
            }

            self->arg_nr5g_tracking_area_code_set = TRUE;

qmi_indication_nas_system_info_output_nr5g_tracking_area_code_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_DCNR_RESTRICTION_INFO, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_dcnr_restriction_info_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_dcnr_restriction_info_out;
                self->arg_dcnr_restriction_info = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'DCNR restriction Info' TLV", offset);
            }

            self->arg_dcnr_restriction_info_set = TRUE;

qmi_indication_nas_system_info_output_dcnr_restriction_info_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_EUTRA_WITH_NR5G_AVAILABILITY, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_eutra_with_nr5g_availability_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_eutra_with_nr5g_availability_out;
                self->arg_eutra_with_nr5g_availability = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'EUTRA with NR5G availability' TLV", offset);
            }

            self->arg_eutra_with_nr5g_availability_set = TRUE;

qmi_indication_nas_system_info_output_eutra_with_nr5g_availability_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_NR5G_SYSTEM_INFO, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_nr5g_system_info_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_nr5g_system_info_out;
                self->arg_nr5g_system_info_domain_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_nr5g_system_info_out;
                self->arg_nr5g_system_info_domain = (QmiNasNetworkServiceDomain)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_nr5g_system_info_out;
                self->arg_nr5g_system_info_service_capability_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_nr5g_system_info_out;
                self->arg_nr5g_system_info_service_capability = (QmiNasNetworkServiceDomain)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_nr5g_system_info_out;
                self->arg_nr5g_system_info_roaming_status_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_nr5g_system_info_out;
                self->arg_nr5g_system_info_roaming_status = (QmiNasRoamingStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_nr5g_system_info_out;
                self->arg_nr5g_system_info_forbidden_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_nr5g_system_info_out;
                self->arg_nr5g_system_info_forbidden = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_nr5g_system_info_out;
                self->arg_nr5g_system_info_lac_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_nr5g_system_info_lac), NULL))
                goto qmi_indication_nas_system_info_output_nr5g_system_info_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_nr5g_system_info_out;
                self->arg_nr5g_system_info_cid_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_nr5g_system_info_cid), NULL))
                goto qmi_indication_nas_system_info_output_nr5g_system_info_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_nr5g_system_info_out;
                self->arg_nr5g_system_info_registration_reject_info_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_nr5g_system_info_out;
                self->arg_nr5g_system_info_registration_reject_domain = (QmiNasNetworkServiceDomain)tmp;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_nr5g_system_info_registration_reject_cause), NULL))
                goto qmi_indication_nas_system_info_output_nr5g_system_info_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_nr5g_system_info_out;
                self->arg_nr5g_system_info_network_id_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &self->arg_nr5g_system_info_mcc[0], NULL))
                goto qmi_indication_nas_system_info_output_nr5g_system_info_out;
            self->arg_nr5g_system_info_mcc[3] = '\0';
            if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &self->arg_nr5g_system_info_mnc[0], NULL))
                goto qmi_indication_nas_system_info_output_nr5g_system_info_out;
            self->arg_nr5g_system_info_mnc[3] = '\0';
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_nr5g_system_info_out;
                self->arg_nr5g_system_info_tac_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_nr5g_system_info_tac), NULL))
                goto qmi_indication_nas_system_info_output_nr5g_system_info_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'NR5G System Info' TLV", offset);
            }

            self->arg_nr5g_system_info_set = TRUE;

qmi_indication_nas_system_info_output_nr5g_system_info_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_NR5G_SERVICE_STATUS_INFO, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_nr5g_service_status_info_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_nr5g_service_status_info_out;
                self->arg_nr5g_service_status_info_service_status = (QmiNasServiceStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_nr5g_service_status_info_out;
                self->arg_nr5g_service_status_info_true_service_status = (QmiNasServiceStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_nr5g_service_status_info_out;
                self->arg_nr5g_service_status_info_preferred_data_path = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'NR5G Service Status Info' TLV", offset);
            }

            self->arg_nr5g_service_status_info_set = TRUE;

qmi_indication_nas_system_info_output_nr5g_service_status_info_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_SIM_REJECT_INFO, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_sim_reject_info_out;
            }
            {
                guint32 tmp;

                if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_sim_reject_info_out;
                self->arg_sim_reject_info = (QmiNasSimRejectState)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'SIM Reject Info' TLV", offset);
            }

            self->arg_sim_reject_info_set = TRUE;

qmi_indication_nas_system_info_output_sim_reject_info_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_LTE_EMBMS_COVERAGE_INFO_SUPPORT, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_lte_embms_coverage_info_support_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_lte_embms_coverage_info_support_out;
                self->arg_lte_embms_coverage_info_support = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'LTE eMBMS Coverage Info Support' TLV", offset);
            }

            self->arg_lte_embms_coverage_info_support_set = TRUE;

qmi_indication_nas_system_info_output_lte_embms_coverage_info_support_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_TD_SCMA_SYSTEM_INFO_V2, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_domain_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_domain = (QmiNasNetworkServiceDomain)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_service_capability_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_service_capability = (QmiNasNetworkServiceDomain)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_roaming_status_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_roaming_status = (QmiNasRoamingStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_forbidden_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_forbidden = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_lac_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_td_scma_system_info_v2_lac), NULL))
                goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_cid_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_td_scma_system_info_v2_cid), NULL))
                goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_registration_reject_info_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_registration_reject_domain = (QmiNasNetworkServiceDomain)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_registration_reject_cause = (QmiNasRejectCause)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_network_id_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &self->arg_td_scma_system_info_v2_mcc[0], NULL))
                goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
            self->arg_td_scma_system_info_v2_mcc[3] = '\0';
            if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &self->arg_td_scma_system_info_v2_mnc[0], NULL))
                goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
            self->arg_td_scma_system_info_v2_mnc[3] = '\0';
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_hs_call_status_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_hs_call_status = (QmiNasWcdmaHsService)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_hs_service_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_hs_service = (QmiNasWcdmaHsService)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_cell_parameter_id_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_td_scma_system_info_v2_cell_parameter_id), NULL))
                goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_cell_broadcast_support_valid = (gboolean)tmp;
            }
            {
                guint32 tmp;

                if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_cell_broadcast_support = (QmiNasCellBroadcastCapability)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_cs_call_barring_status_valid = (gboolean)tmp;
            }
            {
                gint32 tmp;

                if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_cs_call_barring_status = (QmiNasCallBarringStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_ps_call_barring_status_valid = (gboolean)tmp;
            }
            {
                gint32 tmp;

                if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_ps_call_barring_status = (QmiNasCallBarringStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_cipher_domain_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scma_system_info_v2_out;
                self->arg_td_scma_system_info_v2_cipher_domain = (QmiNasNetworkServiceDomain)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'TD SCMA System Info v2' TLV", offset);
            }

            self->arg_td_scma_system_info_v2_set = TRUE;

qmi_indication_nas_system_info_output_td_scma_system_info_v2_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_TD_SCDMA_SERVICE_STATUS, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_td_scdma_service_status_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scdma_service_status_out;
                self->arg_td_scdma_service_status_service_status = (QmiNasServiceStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scdma_service_status_out;
                self->arg_td_scdma_service_status_true_service_status = (QmiNasServiceStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_td_scdma_service_status_out;
                self->arg_td_scdma_service_status_preferred_data_path = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'TD SCDMA Service Status' TLV", offset);
            }

            self->arg_td_scdma_service_status_set = TRUE;

qmi_indication_nas_system_info_output_td_scdma_service_status_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_PLMN_NOT_CHANGED_INDICATION, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_plmn_not_changed_indication_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_plmn_not_changed_indication_out;
                self->arg_plmn_not_changed_indication = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'PLMN Not Changed Indication' TLV", offset);
            }

            self->arg_plmn_not_changed_indication_set = TRUE;

qmi_indication_nas_system_info_output_plmn_not_changed_indication_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_WCDMA_CIPHER_DOMAIN, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_wcdma_cipher_domain_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_cipher_domain_out;
                self->arg_wcdma_cipher_domain = (QmiNasNetworkServiceDomain)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'WCDMA Cipher Domain' TLV", offset);
            }

            self->arg_wcdma_cipher_domain_set = TRUE;

qmi_indication_nas_system_info_output_wcdma_cipher_domain_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_GSM_CIPHER_DOMAIN, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_gsm_cipher_domain_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_cipher_domain_out;
                self->arg_gsm_cipher_domain = (QmiNasNetworkServiceDomain)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'GSM Cipher Domain' TLV", offset);
            }

            self->arg_gsm_cipher_domain_set = TRUE;

qmi_indication_nas_system_info_output_gsm_cipher_domain_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_LTE_VOICE_SUPPORT, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_lte_voice_support_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_lte_voice_support_out;
                self->arg_lte_voice_support = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'LTE Voice Support' TLV", offset);
            }

            self->arg_lte_voice_support_set = TRUE;

qmi_indication_nas_system_info_output_lte_voice_support_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_WCDMA_CALL_BARRING_STATUS, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_wcdma_call_barring_status_out;
            }
            {
                gint32 tmp;

                if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_call_barring_status_out;
                self->arg_wcdma_call_barring_status_cs_status = (QmiNasCallBarringStatus)tmp;
            }
            {
                gint32 tmp;

                if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_call_barring_status_out;
                self->arg_wcdma_call_barring_status_ps_status = (QmiNasCallBarringStatus)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'WCDMA Call Barring Status' TLV", offset);
            }

            self->arg_wcdma_call_barring_status_set = TRUE;

qmi_indication_nas_system_info_output_wcdma_call_barring_status_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_GSM_CALL_BARRING_STATUS, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_gsm_call_barring_status_out;
            }
            {
                gint32 tmp;

                if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_call_barring_status_out;
                self->arg_gsm_call_barring_status_cs_status = (QmiNasCallBarringStatus)tmp;
            }
            {
                gint32 tmp;

                if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_call_barring_status_out;
                self->arg_gsm_call_barring_status_ps_status = (QmiNasCallBarringStatus)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'GSM Call Barring Status' TLV", offset);
            }

            self->arg_gsm_call_barring_status_set = TRUE;

qmi_indication_nas_system_info_output_gsm_call_barring_status_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_ADDITIONAL_LTE_SYSTEM_INFO, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_additional_lte_system_info_out;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_additional_lte_system_info_geo_system_index), NULL))
                goto qmi_indication_nas_system_info_output_additional_lte_system_info_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Additional LTE System Info' TLV", offset);
            }

            self->arg_additional_lte_system_info_set = TRUE;

qmi_indication_nas_system_info_output_additional_lte_system_info_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_ADDITIONAL_WCDMA_SYSTEM_INFO, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_additional_wcdma_system_info_out;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_additional_wcdma_system_info_geo_system_index), NULL))
                goto qmi_indication_nas_system_info_output_additional_wcdma_system_info_out;
            {
                guint32 tmp;

                if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_additional_wcdma_system_info_out;
                self->arg_additional_wcdma_system_info_cell_broadcast_support = (QmiNasCellBroadcastCapability)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Additional WCDMA System Info' TLV", offset);
            }

            self->arg_additional_wcdma_system_info_set = TRUE;

qmi_indication_nas_system_info_output_additional_wcdma_system_info_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_ADDITIONAL_GSM_SYSTEM_INFO, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_additional_gsm_system_info_out;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_additional_gsm_system_info_geo_system_index), NULL))
                goto qmi_indication_nas_system_info_output_additional_gsm_system_info_out;
            {
                guint32 tmp;

                if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_additional_gsm_system_info_out;
                self->arg_additional_gsm_system_info_cell_broadcast_support = (QmiNasCellBroadcastCapability)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Additional GSM System Info' TLV", offset);
            }

            self->arg_additional_gsm_system_info_set = TRUE;

qmi_indication_nas_system_info_output_additional_gsm_system_info_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_ADDITIONAL_HDR_SYSTEM_INFO, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_additional_hdr_system_info_out;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_additional_hdr_system_info_geo_system_index), NULL))
                goto qmi_indication_nas_system_info_output_additional_hdr_system_info_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Additional HDR System Info' TLV", offset);
            }

            self->arg_additional_hdr_system_info_set = TRUE;

qmi_indication_nas_system_info_output_additional_hdr_system_info_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_ADDITIONAL_CDMA_SYSTEM_INFO, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_additional_cdma_system_info_out;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_additional_cdma_system_info_geo_system_index), NULL))
                goto qmi_indication_nas_system_info_output_additional_cdma_system_info_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_additional_cdma_system_info_registration_period), NULL))
                goto qmi_indication_nas_system_info_output_additional_cdma_system_info_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Additional CDMA System Info' TLV", offset);
            }

            self->arg_additional_cdma_system_info_set = TRUE;

qmi_indication_nas_system_info_output_additional_cdma_system_info_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_LTE_SYSTEM_INFO_V2, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_lte_system_info_v2_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_lte_system_info_v2_out;
                self->arg_lte_system_info_v2_domain_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_lte_system_info_v2_out;
                self->arg_lte_system_info_v2_domain = (QmiNasNetworkServiceDomain)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_lte_system_info_v2_out;
                self->arg_lte_system_info_v2_service_capability_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_lte_system_info_v2_out;
                self->arg_lte_system_info_v2_service_capability = (QmiNasNetworkServiceDomain)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_lte_system_info_v2_out;
                self->arg_lte_system_info_v2_roaming_status_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_lte_system_info_v2_out;
                self->arg_lte_system_info_v2_roaming_status = (QmiNasRoamingStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_lte_system_info_v2_out;
                self->arg_lte_system_info_v2_forbidden_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_lte_system_info_v2_out;
                self->arg_lte_system_info_v2_forbidden = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_lte_system_info_v2_out;
                self->arg_lte_system_info_v2_lac_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_lte_system_info_v2_lac), NULL))
                goto qmi_indication_nas_system_info_output_lte_system_info_v2_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_lte_system_info_v2_out;
                self->arg_lte_system_info_v2_cid_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_lte_system_info_v2_cid), NULL))
                goto qmi_indication_nas_system_info_output_lte_system_info_v2_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_lte_system_info_v2_out;
                self->arg_lte_system_info_v2_registration_reject_info_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_lte_system_info_v2_out;
                self->arg_lte_system_info_v2_registration_reject_domain = (QmiNasNetworkServiceDomain)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_lte_system_info_v2_out;
                self->arg_lte_system_info_v2_registration_reject_cause = (QmiNasRejectCause)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_lte_system_info_v2_out;
                self->arg_lte_system_info_v2_network_id_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &self->arg_lte_system_info_v2_mcc[0], NULL))
                goto qmi_indication_nas_system_info_output_lte_system_info_v2_out;
            self->arg_lte_system_info_v2_mcc[3] = '\0';
            if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &self->arg_lte_system_info_v2_mnc[0], NULL))
                goto qmi_indication_nas_system_info_output_lte_system_info_v2_out;
            self->arg_lte_system_info_v2_mnc[3] = '\0';
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_lte_system_info_v2_out;
                self->arg_lte_system_info_v2_tac_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_lte_system_info_v2_tac), NULL))
                goto qmi_indication_nas_system_info_output_lte_system_info_v2_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'LTE System Info v2' TLV", offset);
            }

            self->arg_lte_system_info_v2_set = TRUE;

qmi_indication_nas_system_info_output_lte_system_info_v2_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_WCDMA_SYSTEM_INFO_V2, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
                self->arg_wcdma_system_info_v2_domain_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
                self->arg_wcdma_system_info_v2_domain = (QmiNasNetworkServiceDomain)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
                self->arg_wcdma_system_info_v2_service_capability_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
                self->arg_wcdma_system_info_v2_service_capability = (QmiNasNetworkServiceDomain)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
                self->arg_wcdma_system_info_v2_roaming_status_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
                self->arg_wcdma_system_info_v2_roaming_status = (QmiNasRoamingStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
                self->arg_wcdma_system_info_v2_forbidden_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
                self->arg_wcdma_system_info_v2_forbidden = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
                self->arg_wcdma_system_info_v2_lac_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_wcdma_system_info_v2_lac), NULL))
                goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
                self->arg_wcdma_system_info_v2_cid_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_wcdma_system_info_v2_cid), NULL))
                goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
                self->arg_wcdma_system_info_v2_registration_reject_info_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
                self->arg_wcdma_system_info_v2_registration_reject_domain = (QmiNasNetworkServiceDomain)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
                self->arg_wcdma_system_info_v2_registration_reject_cause = (QmiNasRejectCause)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
                self->arg_wcdma_system_info_v2_network_id_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &self->arg_wcdma_system_info_v2_mcc[0], NULL))
                goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
            self->arg_wcdma_system_info_v2_mcc[3] = '\0';
            if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &self->arg_wcdma_system_info_v2_mnc[0], NULL))
                goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
            self->arg_wcdma_system_info_v2_mnc[3] = '\0';
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
                self->arg_wcdma_system_info_v2_hs_call_status_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
                self->arg_wcdma_system_info_v2_hs_call_status = (QmiNasWcdmaHsService)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
                self->arg_wcdma_system_info_v2_hs_service_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
                self->arg_wcdma_system_info_v2_hs_service = (QmiNasWcdmaHsService)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;
                self->arg_wcdma_system_info_v2_primary_scrambling_code_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_wcdma_system_info_v2_primary_scrambling_code), NULL))
                goto qmi_indication_nas_system_info_output_wcdma_system_info_v2_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'WCDMA System Info v2' TLV", offset);
            }

            self->arg_wcdma_system_info_v2_set = TRUE;

qmi_indication_nas_system_info_output_wcdma_system_info_v2_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_GSM_SYSTEM_INFO_V2, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
                self->arg_gsm_system_info_v2_domain_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
                self->arg_gsm_system_info_v2_domain = (QmiNasNetworkServiceDomain)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
                self->arg_gsm_system_info_v2_service_capability_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
                self->arg_gsm_system_info_v2_service_capability = (QmiNasNetworkServiceDomain)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
                self->arg_gsm_system_info_v2_roaming_status_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
                self->arg_gsm_system_info_v2_roaming_status = (QmiNasRoamingStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
                self->arg_gsm_system_info_v2_forbidden_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
                self->arg_gsm_system_info_v2_forbidden = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
                self->arg_gsm_system_info_v2_lac_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_gsm_system_info_v2_lac), NULL))
                goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
                self->arg_gsm_system_info_v2_cid_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_gsm_system_info_v2_cid), NULL))
                goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
                self->arg_gsm_system_info_v2_registration_reject_info_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
                self->arg_gsm_system_info_v2_registration_reject_domain = (QmiNasNetworkServiceDomain)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
                self->arg_gsm_system_info_v2_registration_reject_cause = (QmiNasRejectCause)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
                self->arg_gsm_system_info_v2_network_id_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &self->arg_gsm_system_info_v2_mcc[0], NULL))
                goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
            self->arg_gsm_system_info_v2_mcc[3] = '\0';
            if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &self->arg_gsm_system_info_v2_mnc[0], NULL))
                goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
            self->arg_gsm_system_info_v2_mnc[3] = '\0';
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
                self->arg_gsm_system_info_v2_egprs_support_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
                self->arg_gsm_system_info_v2_egprs_support = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
                self->arg_gsm_system_info_v2_dtm_support_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_system_info_v2_out;
                self->arg_gsm_system_info_v2_dtm_support = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'GSM System Info v2' TLV", offset);
            }

            self->arg_gsm_system_info_v2_set = TRUE;

qmi_indication_nas_system_info_output_gsm_system_info_v2_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_HDR_SYSTEM_INFO, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_hdr_system_info_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_hdr_system_info_out;
                self->arg_hdr_system_info_domain_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_hdr_system_info_out;
                self->arg_hdr_system_info_domain = (QmiNasNetworkServiceDomain)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_hdr_system_info_out;
                self->arg_hdr_system_info_service_capability_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_hdr_system_info_out;
                self->arg_hdr_system_info_service_capability = (QmiNasNetworkServiceDomain)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_hdr_system_info_out;
                self->arg_hdr_system_info_roaming_status_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_hdr_system_info_out;
                self->arg_hdr_system_info_roaming_status = (QmiNasRoamingStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_hdr_system_info_out;
                self->arg_hdr_system_info_forbidden_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_hdr_system_info_out;
                self->arg_hdr_system_info_forbidden = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_hdr_system_info_out;
                self->arg_hdr_system_info_prl_match_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_hdr_system_info_out;
                self->arg_hdr_system_info_prl_match = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_hdr_system_info_out;
                self->arg_hdr_system_info_personality_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_hdr_system_info_out;
                self->arg_hdr_system_info_personality = (QmiNasHdrPersonality)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_hdr_system_info_out;
                self->arg_hdr_system_info_protocol_revision_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_hdr_system_info_out;
                self->arg_hdr_system_info_protocol_revision = (QmiNasHdrProtocolRevision)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_hdr_system_info_out;
                self->arg_hdr_system_info_is_856_system_id_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 16, &self->arg_hdr_system_info_is_856_system_id[0], NULL))
                goto qmi_indication_nas_system_info_output_hdr_system_info_out;
            self->arg_hdr_system_info_is_856_system_id[16] = '\0';

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'HDR System Info' TLV", offset);
            }

            self->arg_hdr_system_info_set = TRUE;

qmi_indication_nas_system_info_output_hdr_system_info_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_CDMA_SYSTEM_INFO, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_cdma_system_info_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_cdma_system_info_out;
                self->arg_cdma_system_info_domain_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_cdma_system_info_out;
                self->arg_cdma_system_info_domain = (QmiNasNetworkServiceDomain)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_cdma_system_info_out;
                self->arg_cdma_system_info_service_capability_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_cdma_system_info_out;
                self->arg_cdma_system_info_service_capability = (QmiNasNetworkServiceDomain)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_cdma_system_info_out;
                self->arg_cdma_system_info_roaming_status_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_cdma_system_info_out;
                self->arg_cdma_system_info_roaming_status = (QmiNasRoamingStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_cdma_system_info_out;
                self->arg_cdma_system_info_forbidden_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_cdma_system_info_out;
                self->arg_cdma_system_info_forbidden = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_cdma_system_info_out;
                self->arg_cdma_system_info_prl_match_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_cdma_system_info_out;
                self->arg_cdma_system_info_prl_match = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_cdma_system_info_out;
                self->arg_cdma_system_info_p_rev_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_cdma_system_info_p_rev), NULL))
                goto qmi_indication_nas_system_info_output_cdma_system_info_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_cdma_system_info_out;
                self->arg_cdma_system_info_base_station_p_rev_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(self->arg_cdma_system_info_base_station_p_rev), NULL))
                goto qmi_indication_nas_system_info_output_cdma_system_info_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_cdma_system_info_out;
                self->arg_cdma_system_info_concurrent_service_support_valid = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_cdma_system_info_out;
                self->arg_cdma_system_info_concurrent_service_support = (gboolean)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_cdma_system_info_out;
                self->arg_cdma_system_info_cdma_system_id_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_cdma_system_info_sid), NULL))
                goto qmi_indication_nas_system_info_output_cdma_system_info_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_cdma_system_info_nid), NULL))
                goto qmi_indication_nas_system_info_output_cdma_system_info_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_cdma_system_info_out;
                self->arg_cdma_system_info_base_station_info_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_cdma_system_info_base_station_id), NULL))
                goto qmi_indication_nas_system_info_output_cdma_system_info_out;
            if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_cdma_system_info_base_station_latitude), NULL))
                goto qmi_indication_nas_system_info_output_cdma_system_info_out;
            if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_cdma_system_info_base_station_longitude), NULL))
                goto qmi_indication_nas_system_info_output_cdma_system_info_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_cdma_system_info_out;
                self->arg_cdma_system_info_packet_zone_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_cdma_system_info_packet_zone), NULL))
                goto qmi_indication_nas_system_info_output_cdma_system_info_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_cdma_system_info_out;
                self->arg_cdma_system_info_network_id_valid = (gboolean)tmp;
            }
            if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &self->arg_cdma_system_info_mcc[0], NULL))
                goto qmi_indication_nas_system_info_output_cdma_system_info_out;
            self->arg_cdma_system_info_mcc[3] = '\0';
            if (!qmi_message_tlv_read_fixed_size_string (message, init_offset, &offset, 3, &self->arg_cdma_system_info_mnc[0], NULL))
                goto qmi_indication_nas_system_info_output_cdma_system_info_out;
            self->arg_cdma_system_info_mnc[3] = '\0';

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'CDMA System Info' TLV", offset);
            }

            self->arg_cdma_system_info_set = TRUE;

qmi_indication_nas_system_info_output_cdma_system_info_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_LTE_SERVICE_STATUS, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_lte_service_status_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_lte_service_status_out;
                self->arg_lte_service_status_service_status = (QmiNasServiceStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_lte_service_status_out;
                self->arg_lte_service_status_true_service_status = (QmiNasServiceStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_lte_service_status_out;
                self->arg_lte_service_status_preferred_data_path = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'LTE Service Status' TLV", offset);
            }

            self->arg_lte_service_status_set = TRUE;

qmi_indication_nas_system_info_output_lte_service_status_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_WCDMA_SERVICE_STATUS, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_wcdma_service_status_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_service_status_out;
                self->arg_wcdma_service_status_service_status = (QmiNasServiceStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_service_status_out;
                self->arg_wcdma_service_status_true_service_status = (QmiNasServiceStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_wcdma_service_status_out;
                self->arg_wcdma_service_status_preferred_data_path = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'WCDMA Service Status' TLV", offset);
            }

            self->arg_wcdma_service_status_set = TRUE;

qmi_indication_nas_system_info_output_wcdma_service_status_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_GSM_SERVICE_STATUS, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_gsm_service_status_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_service_status_out;
                self->arg_gsm_service_status_service_status = (QmiNasServiceStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_service_status_out;
                self->arg_gsm_service_status_true_service_status = (QmiNasServiceStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_gsm_service_status_out;
                self->arg_gsm_service_status_preferred_data_path = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'GSM Service Status' TLV", offset);
            }

            self->arg_gsm_service_status_set = TRUE;

qmi_indication_nas_system_info_output_gsm_service_status_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_HDR_SERVICE_STATUS, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_hdr_service_status_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_hdr_service_status_out;
                self->arg_hdr_service_status_service_status = (QmiNasServiceStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_hdr_service_status_out;
                self->arg_hdr_service_status_preferred_data_path = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'HDR Service Status' TLV", offset);
            }

            self->arg_hdr_service_status_set = TRUE;

qmi_indication_nas_system_info_output_hdr_service_status_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SYSTEM_INFO_OUTPUT_TLV_CDMA_SERVICE_STATUS, NULL, NULL)) == 0) {
                goto qmi_indication_nas_system_info_output_cdma_service_status_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_cdma_service_status_out;
                self->arg_cdma_service_status_service_status = (QmiNasServiceStatus)tmp;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_system_info_output_cdma_service_status_out;
                self->arg_cdma_service_status_preferred_data_path = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'CDMA Service Status' TLV", offset);
            }

            self->arg_cdma_service_status_set = TRUE;

qmi_indication_nas_system_info_output_cdma_service_status_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* INDICATION: Qmi Indication NAS Signal Info */


/* --- Output -- */

struct _QmiIndicationNasSignalInfoOutput {
    volatile gint ref_count;

    /* WCDMA RSCP */
    gboolean arg_wcdma_rscp_set;
    gint16 arg_wcdma_rscp;

    /* 5G Signal Strength Extended */
    gboolean arg_5g_signal_strength_extended_set;
    gint16 arg_5g_signal_strength_extended;

    /* 5G Signal Strength */
    gboolean arg_5g_signal_strength_set;
    gint16 arg_5g_signal_strength_rsrp;
    gint16 arg_5g_signal_strength_snr;

    /* TDMA Signal Strength */
    gboolean arg_tdma_signal_strength_set;
    gint8 arg_tdma_signal_strength;

    /* LTE Signal Strength */
    gboolean arg_lte_signal_strength_set;
    gint8 arg_lte_signal_strength_rssi;
    gint8 arg_lte_signal_strength_rsrq;
    gint16 arg_lte_signal_strength_rsrp;
    gint16 arg_lte_signal_strength_snr;

    /* WCDMA Signal Strength */
    gboolean arg_wcdma_signal_strength_set;
    gint8 arg_wcdma_signal_strength_rssi;
    gint16 arg_wcdma_signal_strength_ecio;

    /* GSM Signal Strength */
    gboolean arg_gsm_signal_strength_set;
    gint8 arg_gsm_signal_strength;

    /* HDR Signal Strength */
    gboolean arg_hdr_signal_strength_set;
    gint8 arg_hdr_signal_strength_rssi;
    gint16 arg_hdr_signal_strength_ecio;
    guint8 arg_hdr_signal_strength_sinr;
    gint32 arg_hdr_signal_strength_io;

    /* CDMA Signal Strength */
    gboolean arg_cdma_signal_strength_set;
    gint8 arg_cdma_signal_strength_rssi;
    gint16 arg_cdma_signal_strength_ecio;
};

#define QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_WCDMA_RSCP 0x19
#define QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_5G_SIGNAL_STRENGTH_EXTENDED 0x18
#define QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_5G_SIGNAL_STRENGTH 0x17
#define QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_TDMA_SIGNAL_STRENGTH 0x15
#define QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_LTE_SIGNAL_STRENGTH 0x14
#define QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_WCDMA_SIGNAL_STRENGTH 0x13
#define QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_GSM_SIGNAL_STRENGTH 0x12
#define QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_HDR_SIGNAL_STRENGTH 0x11
#define QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_CDMA_SIGNAL_STRENGTH 0x10

gboolean
qmi_indication_nas_signal_info_output_get_wcdma_rscp (
    QmiIndicationNasSignalInfoOutput *self,
    gint16 *value_wcdma_rscp,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_wcdma_rscp_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'WCDMA RSCP' was not found in the message");
        return FALSE;
    }

    if (value_wcdma_rscp)
        *value_wcdma_rscp = self->arg_wcdma_rscp;

    return TRUE;
}

gboolean
qmi_indication_nas_signal_info_output_get_5g_signal_strength_extended (
    QmiIndicationNasSignalInfoOutput *self,
    gint16 *value_5g_signal_strength_extended,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_5g_signal_strength_extended_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field '5G Signal Strength Extended' was not found in the message");
        return FALSE;
    }

    if (value_5g_signal_strength_extended)
        *value_5g_signal_strength_extended = self->arg_5g_signal_strength_extended;

    return TRUE;
}

gboolean
qmi_indication_nas_signal_info_output_get_5g_signal_strength (
    QmiIndicationNasSignalInfoOutput *self,
    gint16 *value_5g_signal_strength_rsrp,
    gint16 *value_5g_signal_strength_snr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_5g_signal_strength_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field '5G Signal Strength' was not found in the message");
        return FALSE;
    }

    if (value_5g_signal_strength_rsrp)
        *value_5g_signal_strength_rsrp = self->arg_5g_signal_strength_rsrp;
    if (value_5g_signal_strength_snr)
        *value_5g_signal_strength_snr = self->arg_5g_signal_strength_snr;

    return TRUE;
}

gboolean
qmi_indication_nas_signal_info_output_get_tdma_signal_strength (
    QmiIndicationNasSignalInfoOutput *self,
    gint8 *value_tdma_signal_strength,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_tdma_signal_strength_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'TDMA Signal Strength' was not found in the message");
        return FALSE;
    }

    if (value_tdma_signal_strength)
        *value_tdma_signal_strength = self->arg_tdma_signal_strength;

    return TRUE;
}

gboolean
qmi_indication_nas_signal_info_output_get_lte_signal_strength (
    QmiIndicationNasSignalInfoOutput *self,
    gint8 *value_lte_signal_strength_rssi,
    gint8 *value_lte_signal_strength_rsrq,
    gint16 *value_lte_signal_strength_rsrp,
    gint16 *value_lte_signal_strength_snr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_lte_signal_strength_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'LTE Signal Strength' was not found in the message");
        return FALSE;
    }

    if (value_lte_signal_strength_rssi)
        *value_lte_signal_strength_rssi = self->arg_lte_signal_strength_rssi;
    if (value_lte_signal_strength_rsrq)
        *value_lte_signal_strength_rsrq = self->arg_lte_signal_strength_rsrq;
    if (value_lte_signal_strength_rsrp)
        *value_lte_signal_strength_rsrp = self->arg_lte_signal_strength_rsrp;
    if (value_lte_signal_strength_snr)
        *value_lte_signal_strength_snr = self->arg_lte_signal_strength_snr;

    return TRUE;
}

gboolean
qmi_indication_nas_signal_info_output_get_wcdma_signal_strength (
    QmiIndicationNasSignalInfoOutput *self,
    gint8 *value_wcdma_signal_strength_rssi,
    gint16 *value_wcdma_signal_strength_ecio,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_wcdma_signal_strength_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'WCDMA Signal Strength' was not found in the message");
        return FALSE;
    }

    if (value_wcdma_signal_strength_rssi)
        *value_wcdma_signal_strength_rssi = self->arg_wcdma_signal_strength_rssi;
    if (value_wcdma_signal_strength_ecio)
        *value_wcdma_signal_strength_ecio = self->arg_wcdma_signal_strength_ecio;

    return TRUE;
}

gboolean
qmi_indication_nas_signal_info_output_get_gsm_signal_strength (
    QmiIndicationNasSignalInfoOutput *self,
    gint8 *value_gsm_signal_strength,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_gsm_signal_strength_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'GSM Signal Strength' was not found in the message");
        return FALSE;
    }

    if (value_gsm_signal_strength)
        *value_gsm_signal_strength = self->arg_gsm_signal_strength;

    return TRUE;
}

gboolean
qmi_indication_nas_signal_info_output_get_hdr_signal_strength (
    QmiIndicationNasSignalInfoOutput *self,
    gint8 *value_hdr_signal_strength_rssi,
    gint16 *value_hdr_signal_strength_ecio,
    QmiNasEvdoSinrLevel *value_hdr_signal_strength_sinr,
    gint32 *value_hdr_signal_strength_io,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_hdr_signal_strength_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'HDR Signal Strength' was not found in the message");
        return FALSE;
    }

    if (value_hdr_signal_strength_rssi)
        *value_hdr_signal_strength_rssi = self->arg_hdr_signal_strength_rssi;
    if (value_hdr_signal_strength_ecio)
        *value_hdr_signal_strength_ecio = self->arg_hdr_signal_strength_ecio;
    if (value_hdr_signal_strength_sinr)
        *value_hdr_signal_strength_sinr = (QmiNasEvdoSinrLevel)(self->arg_hdr_signal_strength_sinr);
    if (value_hdr_signal_strength_io)
        *value_hdr_signal_strength_io = self->arg_hdr_signal_strength_io;

    return TRUE;
}

gboolean
qmi_indication_nas_signal_info_output_get_cdma_signal_strength (
    QmiIndicationNasSignalInfoOutput *self,
    gint8 *value_cdma_signal_strength_rssi,
    gint16 *value_cdma_signal_strength_ecio,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_cdma_signal_strength_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'CDMA Signal Strength' was not found in the message");
        return FALSE;
    }

    if (value_cdma_signal_strength_rssi)
        *value_cdma_signal_strength_rssi = self->arg_cdma_signal_strength_rssi;
    if (value_cdma_signal_strength_ecio)
        *value_cdma_signal_strength_ecio = self->arg_cdma_signal_strength_ecio;

    return TRUE;
}

GType
qmi_indication_nas_signal_info_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiIndicationNasSignalInfoOutput"),
                                          (GBoxedCopyFunc) qmi_indication_nas_signal_info_output_ref,
                                          (GBoxedFreeFunc) qmi_indication_nas_signal_info_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiIndicationNasSignalInfoOutput *
qmi_indication_nas_signal_info_output_ref (QmiIndicationNasSignalInfoOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_indication_nas_signal_info_output_unref (QmiIndicationNasSignalInfoOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiIndicationNasSignalInfoOutput, self);
    }
}

static gchar *
qmi_indication_nas_signal_info_output_wcdma_rscp_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_WCDMA_RSCP, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        gint16 tmp;

        if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT16_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_signal_info_output_5g_signal_strength_extended_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_5G_SIGNAL_STRENGTH_EXTENDED, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        gint16 tmp;

        if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT16_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_signal_info_output_5g_signal_strength_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_5G_SIGNAL_STRENGTH, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " rsrp = '");

    {
        gint16 tmp;

        if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " snr = '");

    {
        gint16 tmp;

        if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_signal_info_output_tdma_signal_strength_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_TDMA_SIGNAL_STRENGTH, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%d", (gint)tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_signal_info_output_lte_signal_strength_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_LTE_SIGNAL_STRENGTH, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " rssi = '");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%d", (gint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " rsrq = '");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%d", (gint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " rsrp = '");

    {
        gint16 tmp;

        if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " snr = '");

    {
        gint16 tmp;

        if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_signal_info_output_wcdma_signal_strength_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_WCDMA_SIGNAL_STRENGTH, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " rssi = '");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%d", (gint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ecio = '");

    {
        gint16 tmp;

        if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_signal_info_output_gsm_signal_strength_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_GSM_SIGNAL_STRENGTH, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%d", (gint)tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_signal_info_output_hdr_signal_strength_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_HDR_SIGNAL_STRENGTH, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " rssi = '");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%d", (gint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ecio = '");

    {
        gint16 tmp;

        if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " sinr = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_EVDO_SINR_LEVEL_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_evdo_sinr_level_get_string ((QmiNasEvdoSinrLevel)tmp));
#elif defined  __QMI_NAS_EVDO_SINR_LEVEL_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_evdo_sinr_level_build_string_from_mask ((QmiNasEvdoSinrLevel)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasEvdoSinrLevel
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " io = '");

    {
        gint32 tmp;

        if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT32_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_signal_info_output_cdma_signal_strength_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_CDMA_SIGNAL_STRENGTH, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " rssi = '");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%d", (gint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ecio = '");

    {
        gint16 tmp;

        if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct indication_signal_info_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
indication_signal_info_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct indication_signal_info_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    {
        switch (type) {
        case QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_WCDMA_RSCP:
            tlv_type_str = "WCDMA RSCP";
            translated_value = qmi_indication_nas_signal_info_output_wcdma_rscp_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_5G_SIGNAL_STRENGTH_EXTENDED:
            tlv_type_str = "5G Signal Strength Extended";
            translated_value = qmi_indication_nas_signal_info_output_5g_signal_strength_extended_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_5G_SIGNAL_STRENGTH:
            tlv_type_str = "5G Signal Strength";
            translated_value = qmi_indication_nas_signal_info_output_5g_signal_strength_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_TDMA_SIGNAL_STRENGTH:
            tlv_type_str = "TDMA Signal Strength";
            translated_value = qmi_indication_nas_signal_info_output_tdma_signal_strength_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_LTE_SIGNAL_STRENGTH:
            tlv_type_str = "LTE Signal Strength";
            translated_value = qmi_indication_nas_signal_info_output_lte_signal_strength_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_WCDMA_SIGNAL_STRENGTH:
            tlv_type_str = "WCDMA Signal Strength";
            translated_value = qmi_indication_nas_signal_info_output_wcdma_signal_strength_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_GSM_SIGNAL_STRENGTH:
            tlv_type_str = "GSM Signal Strength";
            translated_value = qmi_indication_nas_signal_info_output_gsm_signal_strength_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_HDR_SIGNAL_STRENGTH:
            tlv_type_str = "HDR Signal Strength";
            translated_value = qmi_indication_nas_signal_info_output_hdr_signal_strength_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_CDMA_SIGNAL_STRENGTH:
            tlv_type_str = "CDMA Signal Strength";
            translated_value = qmi_indication_nas_signal_info_output_cdma_signal_strength_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
indication_signal_info_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Signal Info\" (0x0051)\n",
                            line_prefix);

    {
        struct indication_signal_info_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)indication_signal_info_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiIndicationNasSignalInfoOutput *
qmi_indication_nas_signal_info_indication_parse (
    QmiMessage *message,
    GError **error)
{
    QmiIndicationNasSignalInfoOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_INDICATION_NAS_SIGNAL_INFO);

    self = g_slice_new0 (QmiIndicationNasSignalInfoOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_WCDMA_RSCP, NULL, NULL)) == 0) {
                goto qmi_indication_nas_signal_info_output_wcdma_rscp_out;
            }
            if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_wcdma_rscp), NULL))
                goto qmi_indication_nas_signal_info_output_wcdma_rscp_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'WCDMA RSCP' TLV", offset);
            }

            self->arg_wcdma_rscp_set = TRUE;

qmi_indication_nas_signal_info_output_wcdma_rscp_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_5G_SIGNAL_STRENGTH_EXTENDED, NULL, NULL)) == 0) {
                goto qmi_indication_nas_signal_info_output_5g_signal_strength_extended_out;
            }
            if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_5g_signal_strength_extended), NULL))
                goto qmi_indication_nas_signal_info_output_5g_signal_strength_extended_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the '5G Signal Strength Extended' TLV", offset);
            }

            self->arg_5g_signal_strength_extended_set = TRUE;

qmi_indication_nas_signal_info_output_5g_signal_strength_extended_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_5G_SIGNAL_STRENGTH, NULL, NULL)) == 0) {
                goto qmi_indication_nas_signal_info_output_5g_signal_strength_out;
            }
            if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_5g_signal_strength_rsrp), NULL))
                goto qmi_indication_nas_signal_info_output_5g_signal_strength_out;
            if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_5g_signal_strength_snr), NULL))
                goto qmi_indication_nas_signal_info_output_5g_signal_strength_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the '5G Signal Strength' TLV", offset);
            }

            self->arg_5g_signal_strength_set = TRUE;

qmi_indication_nas_signal_info_output_5g_signal_strength_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_TDMA_SIGNAL_STRENGTH, NULL, NULL)) == 0) {
                goto qmi_indication_nas_signal_info_output_tdma_signal_strength_out;
            }
            if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &(self->arg_tdma_signal_strength), NULL))
                goto qmi_indication_nas_signal_info_output_tdma_signal_strength_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'TDMA Signal Strength' TLV", offset);
            }

            self->arg_tdma_signal_strength_set = TRUE;

qmi_indication_nas_signal_info_output_tdma_signal_strength_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_LTE_SIGNAL_STRENGTH, NULL, NULL)) == 0) {
                goto qmi_indication_nas_signal_info_output_lte_signal_strength_out;
            }
            if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &(self->arg_lte_signal_strength_rssi), NULL))
                goto qmi_indication_nas_signal_info_output_lte_signal_strength_out;
            if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &(self->arg_lte_signal_strength_rsrq), NULL))
                goto qmi_indication_nas_signal_info_output_lte_signal_strength_out;
            if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_lte_signal_strength_rsrp), NULL))
                goto qmi_indication_nas_signal_info_output_lte_signal_strength_out;
            if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_lte_signal_strength_snr), NULL))
                goto qmi_indication_nas_signal_info_output_lte_signal_strength_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'LTE Signal Strength' TLV", offset);
            }

            self->arg_lte_signal_strength_set = TRUE;

qmi_indication_nas_signal_info_output_lte_signal_strength_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_WCDMA_SIGNAL_STRENGTH, NULL, NULL)) == 0) {
                goto qmi_indication_nas_signal_info_output_wcdma_signal_strength_out;
            }
            if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &(self->arg_wcdma_signal_strength_rssi), NULL))
                goto qmi_indication_nas_signal_info_output_wcdma_signal_strength_out;
            if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_wcdma_signal_strength_ecio), NULL))
                goto qmi_indication_nas_signal_info_output_wcdma_signal_strength_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'WCDMA Signal Strength' TLV", offset);
            }

            self->arg_wcdma_signal_strength_set = TRUE;

qmi_indication_nas_signal_info_output_wcdma_signal_strength_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_GSM_SIGNAL_STRENGTH, NULL, NULL)) == 0) {
                goto qmi_indication_nas_signal_info_output_gsm_signal_strength_out;
            }
            if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &(self->arg_gsm_signal_strength), NULL))
                goto qmi_indication_nas_signal_info_output_gsm_signal_strength_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'GSM Signal Strength' TLV", offset);
            }

            self->arg_gsm_signal_strength_set = TRUE;

qmi_indication_nas_signal_info_output_gsm_signal_strength_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_HDR_SIGNAL_STRENGTH, NULL, NULL)) == 0) {
                goto qmi_indication_nas_signal_info_output_hdr_signal_strength_out;
            }
            if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &(self->arg_hdr_signal_strength_rssi), NULL))
                goto qmi_indication_nas_signal_info_output_hdr_signal_strength_out;
            if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_hdr_signal_strength_ecio), NULL))
                goto qmi_indication_nas_signal_info_output_hdr_signal_strength_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_signal_info_output_hdr_signal_strength_out;
                self->arg_hdr_signal_strength_sinr = (QmiNasEvdoSinrLevel)tmp;
            }
            if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_hdr_signal_strength_io), NULL))
                goto qmi_indication_nas_signal_info_output_hdr_signal_strength_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'HDR Signal Strength' TLV", offset);
            }

            self->arg_hdr_signal_strength_set = TRUE;

qmi_indication_nas_signal_info_output_hdr_signal_strength_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_SIGNAL_INFO_OUTPUT_TLV_CDMA_SIGNAL_STRENGTH, NULL, NULL)) == 0) {
                goto qmi_indication_nas_signal_info_output_cdma_signal_strength_out;
            }
            if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &(self->arg_cdma_signal_strength_rssi), NULL))
                goto qmi_indication_nas_signal_info_output_cdma_signal_strength_out;
            if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_cdma_signal_strength_ecio), NULL))
                goto qmi_indication_nas_signal_info_output_cdma_signal_strength_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'CDMA Signal Strength' TLV", offset);
            }

            self->arg_cdma_signal_strength_set = TRUE;

qmi_indication_nas_signal_info_output_cdma_signal_strength_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* INDICATION: Qmi Indication NAS Network Reject */


/* --- Output -- */

struct _QmiIndicationNasNetworkRejectOutput {
    volatile gint ref_count;

    /* Closed Subscriber Group */
    gboolean arg_closed_subscriber_group_set;
    guint32 arg_closed_subscriber_group;

    /* PLMN */
    gboolean arg_plmn_set;
    guint16 arg_plmn_mcc;
    guint16 arg_plmn_mnc;
    guint8 arg_plmn_includes_pcs_digit;

    /* Reject Cause */
    gboolean arg_reject_cause_set;
    guint8 arg_reject_cause;

    /* Service Domain */
    gboolean arg_service_domain_set;
    guint8 arg_service_domain;

    /* Radio Interface */
    gboolean arg_radio_interface_set;
    guint8 arg_radio_interface;
};

#define QMI_INDICATION_NAS_NETWORK_REJECT_OUTPUT_TLV_CLOSED_SUBSCRIBER_GROUP 0x11
#define QMI_INDICATION_NAS_NETWORK_REJECT_OUTPUT_TLV_PLMN 0x10
#define QMI_INDICATION_NAS_NETWORK_REJECT_OUTPUT_TLV_REJECT_CAUSE 0x03
#define QMI_INDICATION_NAS_NETWORK_REJECT_OUTPUT_TLV_SERVICE_DOMAIN 0x02
#define QMI_INDICATION_NAS_NETWORK_REJECT_OUTPUT_TLV_RADIO_INTERFACE 0x01

gboolean
qmi_indication_nas_network_reject_output_get_closed_subscriber_group (
    QmiIndicationNasNetworkRejectOutput *self,
    guint32 *value_closed_subscriber_group,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_closed_subscriber_group_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Closed Subscriber Group' was not found in the message");
        return FALSE;
    }

    if (value_closed_subscriber_group)
        *value_closed_subscriber_group = self->arg_closed_subscriber_group;

    return TRUE;
}

gboolean
qmi_indication_nas_network_reject_output_get_plmn (
    QmiIndicationNasNetworkRejectOutput *self,
    guint16 *value_plmn_mcc,
    guint16 *value_plmn_mnc,
    gboolean *value_plmn_includes_pcs_digit,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_plmn_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'PLMN' was not found in the message");
        return FALSE;
    }

    if (value_plmn_mcc)
        *value_plmn_mcc = self->arg_plmn_mcc;
    if (value_plmn_mnc)
        *value_plmn_mnc = self->arg_plmn_mnc;
    if (value_plmn_includes_pcs_digit)
        *value_plmn_includes_pcs_digit = (gboolean)(self->arg_plmn_includes_pcs_digit);

    return TRUE;
}

gboolean
qmi_indication_nas_network_reject_output_get_reject_cause (
    QmiIndicationNasNetworkRejectOutput *self,
    QmiNasRejectCause *value_reject_cause,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_reject_cause_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Reject Cause' was not found in the message");
        return FALSE;
    }

    if (value_reject_cause)
        *value_reject_cause = (QmiNasRejectCause)(self->arg_reject_cause);

    return TRUE;
}

gboolean
qmi_indication_nas_network_reject_output_get_service_domain (
    QmiIndicationNasNetworkRejectOutput *self,
    QmiNasNetworkServiceDomain *value_service_domain,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_service_domain_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Service Domain' was not found in the message");
        return FALSE;
    }

    if (value_service_domain)
        *value_service_domain = (QmiNasNetworkServiceDomain)(self->arg_service_domain);

    return TRUE;
}

gboolean
qmi_indication_nas_network_reject_output_get_radio_interface (
    QmiIndicationNasNetworkRejectOutput *self,
    QmiNasRadioInterface *value_radio_interface,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_radio_interface_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Radio Interface' was not found in the message");
        return FALSE;
    }

    if (value_radio_interface)
        *value_radio_interface = (QmiNasRadioInterface)(self->arg_radio_interface);

    return TRUE;
}

GType
qmi_indication_nas_network_reject_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiIndicationNasNetworkRejectOutput"),
                                          (GBoxedCopyFunc) qmi_indication_nas_network_reject_output_ref,
                                          (GBoxedFreeFunc) qmi_indication_nas_network_reject_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiIndicationNasNetworkRejectOutput *
qmi_indication_nas_network_reject_output_ref (QmiIndicationNasNetworkRejectOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_indication_nas_network_reject_output_unref (QmiIndicationNasNetworkRejectOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiIndicationNasNetworkRejectOutput, self);
    }
}

static gchar *
qmi_indication_nas_network_reject_output_closed_subscriber_group_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_NETWORK_REJECT_OUTPUT_TLV_CLOSED_SUBSCRIBER_GROUP, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_network_reject_output_plmn_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_NETWORK_REJECT_OUTPUT_TLV_PLMN, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " mcc = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " mnc = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " includes_pcs_digit = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_network_reject_output_reject_cause_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_NETWORK_REJECT_OUTPUT_TLV_REJECT_CAUSE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_REJECT_CAUSE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_reject_cause_get_string ((QmiNasRejectCause)tmp));
#elif defined  __QMI_NAS_REJECT_CAUSE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_reject_cause_build_string_from_mask ((QmiNasRejectCause)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRejectCause
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_network_reject_output_service_domain_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_NETWORK_REJECT_OUTPUT_TLV_SERVICE_DOMAIN, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_service_domain_get_string ((QmiNasNetworkServiceDomain)tmp));
#elif defined  __QMI_NAS_NETWORK_SERVICE_DOMAIN_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_service_domain_build_string_from_mask ((QmiNasNetworkServiceDomain)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkServiceDomain
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_indication_nas_network_reject_output_radio_interface_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_NETWORK_REJECT_OUTPUT_TLV_RADIO_INTERFACE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_RADIO_INTERFACE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_radio_interface_get_string ((QmiNasRadioInterface)tmp));
#elif defined  __QMI_NAS_RADIO_INTERFACE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_radio_interface_build_string_from_mask ((QmiNasRadioInterface)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRadioInterface
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct indication_network_reject_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
indication_network_reject_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct indication_network_reject_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    {
        switch (type) {
        case QMI_INDICATION_NAS_NETWORK_REJECT_OUTPUT_TLV_CLOSED_SUBSCRIBER_GROUP:
            tlv_type_str = "Closed Subscriber Group";
            translated_value = qmi_indication_nas_network_reject_output_closed_subscriber_group_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_NETWORK_REJECT_OUTPUT_TLV_PLMN:
            tlv_type_str = "PLMN";
            translated_value = qmi_indication_nas_network_reject_output_plmn_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_NETWORK_REJECT_OUTPUT_TLV_REJECT_CAUSE:
            tlv_type_str = "Reject Cause";
            translated_value = qmi_indication_nas_network_reject_output_reject_cause_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_NETWORK_REJECT_OUTPUT_TLV_SERVICE_DOMAIN:
            tlv_type_str = "Service Domain";
            translated_value = qmi_indication_nas_network_reject_output_service_domain_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_INDICATION_NAS_NETWORK_REJECT_OUTPUT_TLV_RADIO_INTERFACE:
            tlv_type_str = "Radio Interface";
            translated_value = qmi_indication_nas_network_reject_output_radio_interface_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
indication_network_reject_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Network Reject\" (0x0068)\n",
                            line_prefix);

    {
        struct indication_network_reject_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)indication_network_reject_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiIndicationNasNetworkRejectOutput *
qmi_indication_nas_network_reject_indication_parse (
    QmiMessage *message,
    GError **error)
{
    QmiIndicationNasNetworkRejectOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_INDICATION_NAS_NETWORK_REJECT);

    self = g_slice_new0 (QmiIndicationNasNetworkRejectOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_NETWORK_REJECT_OUTPUT_TLV_CLOSED_SUBSCRIBER_GROUP, NULL, NULL)) == 0) {
                goto qmi_indication_nas_network_reject_output_closed_subscriber_group_out;
            }
            if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_closed_subscriber_group), NULL))
                goto qmi_indication_nas_network_reject_output_closed_subscriber_group_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Closed Subscriber Group' TLV", offset);
            }

            self->arg_closed_subscriber_group_set = TRUE;

qmi_indication_nas_network_reject_output_closed_subscriber_group_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_NETWORK_REJECT_OUTPUT_TLV_PLMN, NULL, NULL)) == 0) {
                goto qmi_indication_nas_network_reject_output_plmn_out;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_plmn_mcc), NULL))
                goto qmi_indication_nas_network_reject_output_plmn_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_plmn_mnc), NULL))
                goto qmi_indication_nas_network_reject_output_plmn_out;
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_indication_nas_network_reject_output_plmn_out;
                self->arg_plmn_includes_pcs_digit = (gboolean)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'PLMN' TLV", offset);
            }

            self->arg_plmn_set = TRUE;

qmi_indication_nas_network_reject_output_plmn_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_NETWORK_REJECT_OUTPUT_TLV_REJECT_CAUSE, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Reject Cause TLV: ");
                qmi_indication_nas_network_reject_output_unref (self);
                return NULL;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                    goto qmi_indication_nas_network_reject_output_reject_cause_out;
                self->arg_reject_cause = (QmiNasRejectCause)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Reject Cause' TLV", offset);
            }

            self->arg_reject_cause_set = TRUE;

qmi_indication_nas_network_reject_output_reject_cause_out:
            if (!self->arg_reject_cause_set) {
                qmi_indication_nas_network_reject_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_NETWORK_REJECT_OUTPUT_TLV_SERVICE_DOMAIN, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Service Domain TLV: ");
                qmi_indication_nas_network_reject_output_unref (self);
                return NULL;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                    goto qmi_indication_nas_network_reject_output_service_domain_out;
                self->arg_service_domain = (QmiNasNetworkServiceDomain)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Service Domain' TLV", offset);
            }

            self->arg_service_domain_set = TRUE;

qmi_indication_nas_network_reject_output_service_domain_out:
            if (!self->arg_service_domain_set) {
                qmi_indication_nas_network_reject_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_INDICATION_NAS_NETWORK_REJECT_OUTPUT_TLV_RADIO_INTERFACE, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Radio Interface TLV: ");
                qmi_indication_nas_network_reject_output_unref (self);
                return NULL;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, error))
                    goto qmi_indication_nas_network_reject_output_radio_interface_out;
                self->arg_radio_interface = (QmiNasRadioInterface)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Radio Interface' TLV", offset);
            }

            self->arg_radio_interface_set = TRUE;

qmi_indication_nas_network_reject_output_radio_interface_out:
            if (!self->arg_radio_interface_set) {
                qmi_indication_nas_network_reject_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message NAS Reset */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_nas_reset_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_NAS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_NAS_RESET);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageNasResetOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_NAS_RESET_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_nas_reset_output_get_result (
    QmiMessageNasResetOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_nas_reset_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageNasResetOutput"),
                                          (GBoxedCopyFunc) qmi_message_nas_reset_output_ref,
                                          (GBoxedFreeFunc) qmi_message_nas_reset_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageNasResetOutput *
qmi_message_nas_reset_output_ref (QmiMessageNasResetOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_nas_reset_output_unref (QmiMessageNasResetOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageNasResetOutput, self);
    }
}

static gboolean
qmi_message_result_validate (
    const guint8 *buffer,
    guint16 buffer_len)
{
    static const guint expected_len = 4;

    if (buffer_len < expected_len) {
        g_warning ("Cannot read the 'Result' TLV: expected '%u' bytes, but only got '%u' bytes",
                   expected_len, buffer_len);
        return FALSE;
    }

    return TRUE;
}

static gchar *
qmi_message_result_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    guint16 error_status;
    guint16 error_code;

    if ((init_offset = qmi_message_tlv_read_init (self, QMI_MESSAGE_NAS_RESET_OUTPUT_TLV_RESULT, NULL, NULL)) == 0)
        return NULL;
    if (!qmi_message_tlv_read_guint16 (self, init_offset, &offset, QMI_ENDIAN_LITTLE, &error_status, NULL))
        return NULL;
    if (!qmi_message_tlv_read_guint16 (self, init_offset, &offset, QMI_ENDIAN_LITTLE, &error_code, NULL))
        return NULL;
    g_warn_if_fail (qmi_message_tlv_read_remaining_size (self, init_offset, offset) == 0);

    if (error_status == QMI_STATUS_SUCCESS)
        return g_strdup ("SUCCESS");

    return g_strdup_printf ("FAILURE: %s", qmi_protocol_error_get_string ((QmiProtocolError) error_code));
}

struct message_reset_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_reset_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_reset_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_NAS_RESET_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_reset_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Reset\" (0x0000)\n",
                            line_prefix);

    {
        struct message_reset_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_reset_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageNasResetOutput *
qmi_message_nas_reset_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageNasResetOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_NAS_RESET);

    self = g_slice_new0 (QmiMessageNasResetOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_RESET_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_nas_reset_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_nas_reset_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message NAS Abort */


/* --- Input -- */

typedef struct _QmiMessageNasAbortInput QmiMessageNasAbortInput;
static GType qmi_message_nas_abort_input_get_type (void) G_GNUC_CONST;
#define QMI_TYPE_MESSAGE_NAS_ABORT_INPUT (qmi_message_nas_abort_input_get_type ())

struct _QmiMessageNasAbortInput {
    volatile gint ref_count;

    /* Transaction ID */
    gboolean arg_transaction_id_set;
    guint16 arg_transaction_id;
};

#define QMI_MESSAGE_NAS_ABORT_INPUT_TLV_TRANSACTION_ID 0x01

static gboolean qmi_message_nas_abort_input_get_transaction_id (
    QmiMessageNasAbortInput *self,
    guint16 *value_transaction_id,
    GError **error);

static gboolean
qmi_message_nas_abort_input_get_transaction_id (
    QmiMessageNasAbortInput *self,
    guint16 *value_transaction_id,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_transaction_id_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Transaction ID' was not found in the message");
        return FALSE;
    }

    if (value_transaction_id)
        *value_transaction_id = self->arg_transaction_id;

    return TRUE;
}

static gboolean qmi_message_nas_abort_input_set_transaction_id (
    QmiMessageNasAbortInput *self,
    guint16 value_transaction_id,
    GError **error);

static gboolean
qmi_message_nas_abort_input_set_transaction_id (
    QmiMessageNasAbortInput *self,
    guint16 value_transaction_id,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_transaction_id = value_transaction_id;
    self->arg_transaction_id_set = TRUE;

    return TRUE;
}

static QmiMessageNasAbortInput *qmi_message_nas_abort_input_ref (QmiMessageNasAbortInput *self);

static void qmi_message_nas_abort_input_unref (QmiMessageNasAbortInput *self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiMessageNasAbortInput, qmi_message_nas_abort_input_unref)
static QmiMessageNasAbortInput *qmi_message_nas_abort_input_new (void);

static GType
qmi_message_nas_abort_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageNasAbortInput"),
                                          (GBoxedCopyFunc) qmi_message_nas_abort_input_ref,
                                          (GBoxedFreeFunc) qmi_message_nas_abort_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

static QmiMessageNasAbortInput *
qmi_message_nas_abort_input_ref (QmiMessageNasAbortInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

static void
qmi_message_nas_abort_input_unref (QmiMessageNasAbortInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageNasAbortInput, self);
    }
}

static QmiMessageNasAbortInput *
qmi_message_nas_abort_input_new (void)
{
    QmiMessageNasAbortInput *self;

    self = g_slice_new0 (QmiMessageNasAbortInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_nas_abort_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageNasAbortInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_NAS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_NAS_ABORT);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Abort' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Transaction ID' TLV */
    if (input->arg_transaction_id_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_ABORT_INPUT_TLV_TRANSACTION_ID, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Transaction ID': ");
            return NULL;
        }

        /* Write the guint16 variable to the buffer */
        if (!qmi_message_tlv_write_guint16 (self, QMI_ENDIAN_LITTLE, input->arg_transaction_id, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Transaction ID': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Transaction ID': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Transaction ID' in message 'Abort'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

typedef struct _QmiMessageNasAbortOutput QmiMessageNasAbortOutput;
static GType qmi_message_nas_abort_output_get_type (void) G_GNUC_CONST;
#define QMI_TYPE_MESSAGE_NAS_ABORT_OUTPUT (qmi_message_nas_abort_output_get_type ())

struct _QmiMessageNasAbortOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_NAS_ABORT_OUTPUT_TLV_RESULT 0x02

gboolean qmi_message_nas_abort_output_get_result (
    QmiMessageNasAbortOutput *self,
    GError **error);

gboolean
qmi_message_nas_abort_output_get_result (
    QmiMessageNasAbortOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

static QmiMessageNasAbortOutput *qmi_message_nas_abort_output_ref (QmiMessageNasAbortOutput *self);

static void qmi_message_nas_abort_output_unref (QmiMessageNasAbortOutput *self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QmiMessageNasAbortOutput, qmi_message_nas_abort_output_unref)

static GType
qmi_message_nas_abort_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageNasAbortOutput"),
                                          (GBoxedCopyFunc) qmi_message_nas_abort_output_ref,
                                          (GBoxedFreeFunc) qmi_message_nas_abort_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

static QmiMessageNasAbortOutput *
qmi_message_nas_abort_output_ref (QmiMessageNasAbortOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

static void
qmi_message_nas_abort_output_unref (QmiMessageNasAbortOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageNasAbortOutput, self);
    }
}

static gchar *
qmi_message_nas_abort_input_transaction_id_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_ABORT_INPUT_TLV_TRANSACTION_ID, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_abort_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_abort_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_abort_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_NAS_ABORT_INPUT_TLV_TRANSACTION_ID:
            tlv_type_str = "Transaction ID";
            translated_value = qmi_message_nas_abort_input_transaction_id_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_NAS_ABORT_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_abort_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Abort\" (0x0001)\n",
                            line_prefix);

    {
        struct message_abort_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_abort_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

static QmiMessageNasAbortOutput *
__qmi_message_nas_abort_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageNasAbortOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_NAS_ABORT);

    self = g_slice_new0 (QmiMessageNasAbortOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_ABORT_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_nas_abort_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_nas_abort_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message NAS Set Event Report */


/* --- Input -- */

struct _QmiMessageNasSetEventReportInput {
    volatile gint ref_count;

    /* LTE RSRP Delta */
    gboolean arg_lte_rsrp_delta_set;
    guint8 arg_lte_rsrp_delta_report;
    guint8 arg_lte_rsrp_delta_rsrp_delta;

    /* LTE SNR Delta */
    gboolean arg_lte_snr_delta_set;
    guint8 arg_lte_snr_delta_report;
    guint8 arg_lte_snr_delta_snr_delta;

    /* SINR Threshold */
    gboolean arg_sinr_threshold_set;
    guint8 arg_sinr_threshold_report;
    GArray *arg_sinr_threshold_thresholds;

    /* ECIO Threshold */
    gboolean arg_ecio_threshold_set;
    guint8 arg_ecio_threshold_report;
    GArray *arg_ecio_threshold_thresholds;

    /* Error Rate Indicator */
    gboolean arg_error_rate_indicator_set;
    guint8 arg_error_rate_indicator;

    /* SINR Indicator */
    gboolean arg_sinr_indicator_set;
    guint8 arg_sinr_indicator_report;
    guint8 arg_sinr_indicator_sinr_delta;

    /* IO Indicator */
    gboolean arg_io_indicator_set;
    guint8 arg_io_indicator_report;
    guint8 arg_io_indicator_io_delta;

    /* ECIO Indicator */
    gboolean arg_ecio_indicator_set;
    guint8 arg_ecio_indicator_report;
    guint8 arg_ecio_indicator_ecio_delta;

    /* RSSI Indicator */
    gboolean arg_rssi_indicator_set;
    guint8 arg_rssi_indicator_report;
    guint8 arg_rssi_indicator_rssi_delta;

    /* Registration Reject Reason */
    gboolean arg_registration_reject_reason_set;
    guint8 arg_registration_reject_reason;

    /* RF Band Information */
    gboolean arg_rf_band_information_set;
    guint8 arg_rf_band_information;

    /* Signal Strength Indicator */
    gboolean arg_signal_strength_indicator_set;
    guint8 arg_signal_strength_indicator_report;
    GArray *arg_signal_strength_indicator_thresholds;
};

#define QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_LTE_RSRP_DELTA 0x1C
#define QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_LTE_SNR_DELTA 0x1B
#define QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_SINR_THRESHOLD 0x1A
#define QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_ECIO_THRESHOLD 0x19
#define QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_ERROR_RATE_INDICATOR 0x17
#define QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_SINR_INDICATOR 0x16
#define QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_IO_INDICATOR 0x15
#define QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_ECIO_INDICATOR 0x14
#define QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_RSSI_INDICATOR 0x13
#define QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_REGISTRATION_REJECT_REASON 0x12
#define QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_RF_BAND_INFORMATION 0x11
#define QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_SIGNAL_STRENGTH_INDICATOR 0x10

gboolean
qmi_message_nas_set_event_report_input_get_lte_rsrp_delta (
    QmiMessageNasSetEventReportInput *self,
    gboolean *value_lte_rsrp_delta_report,
    guint8 *value_lte_rsrp_delta_rsrp_delta,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_lte_rsrp_delta_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'LTE RSRP Delta' was not found in the message");
        return FALSE;
    }

    if (value_lte_rsrp_delta_report)
        *value_lte_rsrp_delta_report = (gboolean)(self->arg_lte_rsrp_delta_report);
    if (value_lte_rsrp_delta_rsrp_delta)
        *value_lte_rsrp_delta_rsrp_delta = self->arg_lte_rsrp_delta_rsrp_delta;

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_set_lte_rsrp_delta (
    QmiMessageNasSetEventReportInput *self,
    gboolean value_lte_rsrp_delta_report,
    guint8 value_lte_rsrp_delta_rsrp_delta,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_lte_rsrp_delta_report = (guint8)(value_lte_rsrp_delta_report);
    self->arg_lte_rsrp_delta_rsrp_delta = value_lte_rsrp_delta_rsrp_delta;
    self->arg_lte_rsrp_delta_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_get_lte_snr_delta (
    QmiMessageNasSetEventReportInput *self,
    gboolean *value_lte_snr_delta_report,
    guint8 *value_lte_snr_delta_snr_delta,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_lte_snr_delta_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'LTE SNR Delta' was not found in the message");
        return FALSE;
    }

    if (value_lte_snr_delta_report)
        *value_lte_snr_delta_report = (gboolean)(self->arg_lte_snr_delta_report);
    if (value_lte_snr_delta_snr_delta)
        *value_lte_snr_delta_snr_delta = self->arg_lte_snr_delta_snr_delta;

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_set_lte_snr_delta (
    QmiMessageNasSetEventReportInput *self,
    gboolean value_lte_snr_delta_report,
    guint8 value_lte_snr_delta_snr_delta,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_lte_snr_delta_report = (guint8)(value_lte_snr_delta_report);
    self->arg_lte_snr_delta_snr_delta = value_lte_snr_delta_snr_delta;
    self->arg_lte_snr_delta_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_get_sinr_threshold (
    QmiMessageNasSetEventReportInput *self,
    gboolean *value_sinr_threshold_report,
    GArray **value_sinr_threshold_thresholds,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_sinr_threshold_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'SINR Threshold' was not found in the message");
        return FALSE;
    }

    if (value_sinr_threshold_report)
        *value_sinr_threshold_report = (gboolean)(self->arg_sinr_threshold_report);
    if (value_sinr_threshold_thresholds)
        *value_sinr_threshold_thresholds = self->arg_sinr_threshold_thresholds;

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_set_sinr_threshold (
    QmiMessageNasSetEventReportInput *self,
    gboolean value_sinr_threshold_report,
    GArray *value_sinr_threshold_thresholds,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_sinr_threshold_report = (guint8)(value_sinr_threshold_report);
    g_clear_pointer (&self->arg_sinr_threshold_thresholds, (GDestroyNotify)g_array_unref);
    g_clear_pointer (&self->arg_sinr_threshold_thresholds, (GDestroyNotify)g_ptr_array_unref);
    self->arg_sinr_threshold_thresholds = g_array_ref (value_sinr_threshold_thresholds);
    self->arg_sinr_threshold_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_get_ecio_threshold (
    QmiMessageNasSetEventReportInput *self,
    gboolean *value_ecio_threshold_report,
    GArray **value_ecio_threshold_thresholds,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_ecio_threshold_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'ECIO Threshold' was not found in the message");
        return FALSE;
    }

    if (value_ecio_threshold_report)
        *value_ecio_threshold_report = (gboolean)(self->arg_ecio_threshold_report);
    if (value_ecio_threshold_thresholds)
        *value_ecio_threshold_thresholds = self->arg_ecio_threshold_thresholds;

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_set_ecio_threshold (
    QmiMessageNasSetEventReportInput *self,
    gboolean value_ecio_threshold_report,
    GArray *value_ecio_threshold_thresholds,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_ecio_threshold_report = (guint8)(value_ecio_threshold_report);
    g_clear_pointer (&self->arg_ecio_threshold_thresholds, (GDestroyNotify)g_array_unref);
    g_clear_pointer (&self->arg_ecio_threshold_thresholds, (GDestroyNotify)g_ptr_array_unref);
    self->arg_ecio_threshold_thresholds = g_array_ref (value_ecio_threshold_thresholds);
    self->arg_ecio_threshold_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_get_error_rate_indicator (
    QmiMessageNasSetEventReportInput *self,
    gboolean *value_error_rate_indicator,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_error_rate_indicator_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Error Rate Indicator' was not found in the message");
        return FALSE;
    }

    if (value_error_rate_indicator)
        *value_error_rate_indicator = (gboolean)(self->arg_error_rate_indicator);

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_set_error_rate_indicator (
    QmiMessageNasSetEventReportInput *self,
    gboolean value_error_rate_indicator,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_error_rate_indicator = (guint8)(value_error_rate_indicator);
    self->arg_error_rate_indicator_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_get_sinr_indicator (
    QmiMessageNasSetEventReportInput *self,
    gboolean *value_sinr_indicator_report,
    guint8 *value_sinr_indicator_sinr_delta,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_sinr_indicator_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'SINR Indicator' was not found in the message");
        return FALSE;
    }

    if (value_sinr_indicator_report)
        *value_sinr_indicator_report = (gboolean)(self->arg_sinr_indicator_report);
    if (value_sinr_indicator_sinr_delta)
        *value_sinr_indicator_sinr_delta = self->arg_sinr_indicator_sinr_delta;

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_set_sinr_indicator (
    QmiMessageNasSetEventReportInput *self,
    gboolean value_sinr_indicator_report,
    guint8 value_sinr_indicator_sinr_delta,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_sinr_indicator_report = (guint8)(value_sinr_indicator_report);
    self->arg_sinr_indicator_sinr_delta = value_sinr_indicator_sinr_delta;
    self->arg_sinr_indicator_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_get_io_indicator (
    QmiMessageNasSetEventReportInput *self,
    gboolean *value_io_indicator_report,
    guint8 *value_io_indicator_io_delta,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_io_indicator_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'IO Indicator' was not found in the message");
        return FALSE;
    }

    if (value_io_indicator_report)
        *value_io_indicator_report = (gboolean)(self->arg_io_indicator_report);
    if (value_io_indicator_io_delta)
        *value_io_indicator_io_delta = self->arg_io_indicator_io_delta;

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_set_io_indicator (
    QmiMessageNasSetEventReportInput *self,
    gboolean value_io_indicator_report,
    guint8 value_io_indicator_io_delta,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_io_indicator_report = (guint8)(value_io_indicator_report);
    self->arg_io_indicator_io_delta = value_io_indicator_io_delta;
    self->arg_io_indicator_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_get_ecio_indicator (
    QmiMessageNasSetEventReportInput *self,
    gboolean *value_ecio_indicator_report,
    guint8 *value_ecio_indicator_ecio_delta,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_ecio_indicator_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'ECIO Indicator' was not found in the message");
        return FALSE;
    }

    if (value_ecio_indicator_report)
        *value_ecio_indicator_report = (gboolean)(self->arg_ecio_indicator_report);
    if (value_ecio_indicator_ecio_delta)
        *value_ecio_indicator_ecio_delta = self->arg_ecio_indicator_ecio_delta;

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_set_ecio_indicator (
    QmiMessageNasSetEventReportInput *self,
    gboolean value_ecio_indicator_report,
    guint8 value_ecio_indicator_ecio_delta,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_ecio_indicator_report = (guint8)(value_ecio_indicator_report);
    self->arg_ecio_indicator_ecio_delta = value_ecio_indicator_ecio_delta;
    self->arg_ecio_indicator_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_get_rssi_indicator (
    QmiMessageNasSetEventReportInput *self,
    gboolean *value_rssi_indicator_report,
    guint8 *value_rssi_indicator_rssi_delta,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_rssi_indicator_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'RSSI Indicator' was not found in the message");
        return FALSE;
    }

    if (value_rssi_indicator_report)
        *value_rssi_indicator_report = (gboolean)(self->arg_rssi_indicator_report);
    if (value_rssi_indicator_rssi_delta)
        *value_rssi_indicator_rssi_delta = self->arg_rssi_indicator_rssi_delta;

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_set_rssi_indicator (
    QmiMessageNasSetEventReportInput *self,
    gboolean value_rssi_indicator_report,
    guint8 value_rssi_indicator_rssi_delta,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_rssi_indicator_report = (guint8)(value_rssi_indicator_report);
    self->arg_rssi_indicator_rssi_delta = value_rssi_indicator_rssi_delta;
    self->arg_rssi_indicator_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_get_registration_reject_reason (
    QmiMessageNasSetEventReportInput *self,
    gboolean *value_registration_reject_reason,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_registration_reject_reason_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Registration Reject Reason' was not found in the message");
        return FALSE;
    }

    if (value_registration_reject_reason)
        *value_registration_reject_reason = (gboolean)(self->arg_registration_reject_reason);

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_set_registration_reject_reason (
    QmiMessageNasSetEventReportInput *self,
    gboolean value_registration_reject_reason,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_registration_reject_reason = (guint8)(value_registration_reject_reason);
    self->arg_registration_reject_reason_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_get_rf_band_information (
    QmiMessageNasSetEventReportInput *self,
    gboolean *value_rf_band_information,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_rf_band_information_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'RF Band Information' was not found in the message");
        return FALSE;
    }

    if (value_rf_band_information)
        *value_rf_band_information = (gboolean)(self->arg_rf_band_information);

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_set_rf_band_information (
    QmiMessageNasSetEventReportInput *self,
    gboolean value_rf_band_information,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_rf_band_information = (guint8)(value_rf_band_information);
    self->arg_rf_band_information_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_get_signal_strength_indicator (
    QmiMessageNasSetEventReportInput *self,
    gboolean *value_signal_strength_indicator_report,
    GArray **value_signal_strength_indicator_thresholds,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_signal_strength_indicator_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Signal Strength Indicator' was not found in the message");
        return FALSE;
    }

    if (value_signal_strength_indicator_report)
        *value_signal_strength_indicator_report = (gboolean)(self->arg_signal_strength_indicator_report);
    if (value_signal_strength_indicator_thresholds)
        *value_signal_strength_indicator_thresholds = self->arg_signal_strength_indicator_thresholds;

    return TRUE;
}

gboolean
qmi_message_nas_set_event_report_input_set_signal_strength_indicator (
    QmiMessageNasSetEventReportInput *self,
    gboolean value_signal_strength_indicator_report,
    GArray *value_signal_strength_indicator_thresholds,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_signal_strength_indicator_report = (guint8)(value_signal_strength_indicator_report);
    g_clear_pointer (&self->arg_signal_strength_indicator_thresholds, (GDestroyNotify)g_array_unref);
    g_clear_pointer (&self->arg_signal_strength_indicator_thresholds, (GDestroyNotify)g_ptr_array_unref);
    self->arg_signal_strength_indicator_thresholds = g_array_ref (value_signal_strength_indicator_thresholds);
    self->arg_signal_strength_indicator_set = TRUE;

    return TRUE;
}

GType
qmi_message_nas_set_event_report_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageNasSetEventReportInput"),
                                          (GBoxedCopyFunc) qmi_message_nas_set_event_report_input_ref,
                                          (GBoxedFreeFunc) qmi_message_nas_set_event_report_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageNasSetEventReportInput *
qmi_message_nas_set_event_report_input_ref (QmiMessageNasSetEventReportInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_nas_set_event_report_input_unref (QmiMessageNasSetEventReportInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_sinr_threshold_thresholds, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_ecio_threshold_thresholds, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_signal_strength_indicator_thresholds, (GDestroyNotify)g_array_unref);
        g_slice_free (QmiMessageNasSetEventReportInput, self);
    }
}

QmiMessageNasSetEventReportInput *
qmi_message_nas_set_event_report_input_new (void)
{
    QmiMessageNasSetEventReportInput *self;

    self = g_slice_new0 (QmiMessageNasSetEventReportInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_nas_set_event_report_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageNasSetEventReportInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_NAS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_NAS_SET_EVENT_REPORT);

    /* All TLVs are optional, we allow NULL input */
    if (!input)
        return g_steal_pointer (&self);

    /* Try to add the 'LTE RSRP Delta' TLV */
    if (input->arg_lte_rsrp_delta_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_LTE_RSRP_DELTA, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'LTE RSRP Delta': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_lte_rsrp_delta_report;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'LTE RSRP Delta': ");
                return NULL;
            }
        }
        /* Write the guint8 variable to the buffer */
        if (!qmi_message_tlv_write_guint8 (self, input->arg_lte_rsrp_delta_rsrp_delta, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'LTE RSRP Delta': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'LTE RSRP Delta': ");
            return NULL;
        }
    }

    /* Try to add the 'LTE SNR Delta' TLV */
    if (input->arg_lte_snr_delta_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_LTE_SNR_DELTA, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'LTE SNR Delta': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_lte_snr_delta_report;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'LTE SNR Delta': ");
                return NULL;
            }
        }
        /* Write the guint8 variable to the buffer */
        if (!qmi_message_tlv_write_guint8 (self, input->arg_lte_snr_delta_snr_delta, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'LTE SNR Delta': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'LTE SNR Delta': ");
            return NULL;
        }
    }

    /* Try to add the 'SINR Threshold' TLV */
    if (input->arg_sinr_threshold_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_SINR_THRESHOLD, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'SINR Threshold': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_sinr_threshold_report;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'SINR Threshold': ");
                return NULL;
            }
        }
        {
            guint thresholds_i;
            guint8 thresholds_n_items;

            /* Write the number of items in the array first */
            thresholds_n_items = (guint8) input->arg_sinr_threshold_thresholds->len;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, thresholds_n_items, error)) {
                g_prefix_error (error, "Cannot write integer in TLV 'SINR Threshold': ");
                return NULL;
            }

            for (thresholds_i = 0; thresholds_i < input->arg_sinr_threshold_thresholds->len; thresholds_i++) {
                /* Write the guint8 variable to the buffer */
                if (!qmi_message_tlv_write_guint8 (self, g_array_index (input->arg_sinr_threshold_thresholds, guint8,thresholds_i), error)) {
                    g_prefix_error (error, "Cannot write integer in TLV 'SINR Threshold': ");
                    return NULL;
                }
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'SINR Threshold': ");
            return NULL;
        }
    }

    /* Try to add the 'ECIO Threshold' TLV */
    if (input->arg_ecio_threshold_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_ECIO_THRESHOLD, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'ECIO Threshold': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_ecio_threshold_report;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'ECIO Threshold': ");
                return NULL;
            }
        }
        {
            guint thresholds_i;
            guint8 thresholds_n_items;

            /* Write the number of items in the array first */
            thresholds_n_items = (guint8) input->arg_ecio_threshold_thresholds->len;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, thresholds_n_items, error)) {
                g_prefix_error (error, "Cannot write integer in TLV 'ECIO Threshold': ");
                return NULL;
            }

            for (thresholds_i = 0; thresholds_i < input->arg_ecio_threshold_thresholds->len; thresholds_i++) {
                /* Write the gint16 variable to the buffer */
                if (!qmi_message_tlv_write_gint16 (self, QMI_ENDIAN_LITTLE, g_array_index (input->arg_ecio_threshold_thresholds, gint16,thresholds_i), error)) {
                    g_prefix_error (error, "Cannot write integer in TLV 'ECIO Threshold': ");
                    return NULL;
                }
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'ECIO Threshold': ");
            return NULL;
        }
    }

    /* Try to add the 'Error Rate Indicator' TLV */
    if (input->arg_error_rate_indicator_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_ERROR_RATE_INDICATOR, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Error Rate Indicator': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_error_rate_indicator;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Error Rate Indicator': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Error Rate Indicator': ");
            return NULL;
        }
    }

    /* Try to add the 'SINR Indicator' TLV */
    if (input->arg_sinr_indicator_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_SINR_INDICATOR, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'SINR Indicator': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_sinr_indicator_report;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'SINR Indicator': ");
                return NULL;
            }
        }
        /* Write the guint8 variable to the buffer */
        if (!qmi_message_tlv_write_guint8 (self, input->arg_sinr_indicator_sinr_delta, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'SINR Indicator': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'SINR Indicator': ");
            return NULL;
        }
    }

    /* Try to add the 'IO Indicator' TLV */
    if (input->arg_io_indicator_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_IO_INDICATOR, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'IO Indicator': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_io_indicator_report;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'IO Indicator': ");
                return NULL;
            }
        }
        /* Write the guint8 variable to the buffer */
        if (!qmi_message_tlv_write_guint8 (self, input->arg_io_indicator_io_delta, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'IO Indicator': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'IO Indicator': ");
            return NULL;
        }
    }

    /* Try to add the 'ECIO Indicator' TLV */
    if (input->arg_ecio_indicator_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_ECIO_INDICATOR, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'ECIO Indicator': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_ecio_indicator_report;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'ECIO Indicator': ");
                return NULL;
            }
        }
        /* Write the guint8 variable to the buffer */
        if (!qmi_message_tlv_write_guint8 (self, input->arg_ecio_indicator_ecio_delta, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'ECIO Indicator': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'ECIO Indicator': ");
            return NULL;
        }
    }

    /* Try to add the 'RSSI Indicator' TLV */
    if (input->arg_rssi_indicator_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_RSSI_INDICATOR, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'RSSI Indicator': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_rssi_indicator_report;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'RSSI Indicator': ");
                return NULL;
            }
        }
        /* Write the guint8 variable to the buffer */
        if (!qmi_message_tlv_write_guint8 (self, input->arg_rssi_indicator_rssi_delta, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'RSSI Indicator': ");
            return NULL;
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'RSSI Indicator': ");
            return NULL;
        }
    }

    /* Try to add the 'Registration Reject Reason' TLV */
    if (input->arg_registration_reject_reason_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_REGISTRATION_REJECT_REASON, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Registration Reject Reason': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_registration_reject_reason;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Registration Reject Reason': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Registration Reject Reason': ");
            return NULL;
        }
    }

    /* Try to add the 'RF Band Information' TLV */
    if (input->arg_rf_band_information_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_RF_BAND_INFORMATION, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'RF Band Information': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_rf_band_information;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'RF Band Information': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'RF Band Information': ");
            return NULL;
        }
    }

    /* Try to add the 'Signal Strength Indicator' TLV */
    if (input->arg_signal_strength_indicator_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_SIGNAL_STRENGTH_INDICATOR, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Signal Strength Indicator': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_signal_strength_indicator_report;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Signal Strength Indicator': ");
                return NULL;
            }
        }
        {
            guint thresholds_i;
            guint8 thresholds_n_items;

            /* Write the number of items in the array first */
            thresholds_n_items = (guint8) input->arg_signal_strength_indicator_thresholds->len;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, thresholds_n_items, error)) {
                g_prefix_error (error, "Cannot write integer in TLV 'Signal Strength Indicator': ");
                return NULL;
            }

            for (thresholds_i = 0; thresholds_i < input->arg_signal_strength_indicator_thresholds->len; thresholds_i++) {
                /* Write the gint8 variable to the buffer */
                if (!qmi_message_tlv_write_gint8 (self, g_array_index (input->arg_signal_strength_indicator_thresholds, gint8,thresholds_i), error)) {
                    g_prefix_error (error, "Cannot write integer in TLV 'Signal Strength Indicator': ");
                    return NULL;
                }
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Signal Strength Indicator': ");
            return NULL;
        }
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageNasSetEventReportOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_NAS_SET_EVENT_REPORT_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_nas_set_event_report_output_get_result (
    QmiMessageNasSetEventReportOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_nas_set_event_report_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageNasSetEventReportOutput"),
                                          (GBoxedCopyFunc) qmi_message_nas_set_event_report_output_ref,
                                          (GBoxedFreeFunc) qmi_message_nas_set_event_report_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageNasSetEventReportOutput *
qmi_message_nas_set_event_report_output_ref (QmiMessageNasSetEventReportOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_nas_set_event_report_output_unref (QmiMessageNasSetEventReportOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageNasSetEventReportOutput, self);
    }
}

static gchar *
qmi_message_nas_set_event_report_input_lte_rsrp_delta_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_LTE_RSRP_DELTA, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " report = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " rsrp_delta = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_set_event_report_input_lte_snr_delta_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_LTE_SNR_DELTA, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " report = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " snr_delta = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_set_event_report_input_sinr_threshold_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_SINR_THRESHOLD, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " report = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " thresholds = '");
    {
        guint thresholds_i;
        guint8 thresholds_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(thresholds_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (thresholds_i = 0; thresholds_i < thresholds_n_items; thresholds_i++) {
            g_string_append_printf (printable, " [%u] = '", thresholds_i);

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%u", (guint)tmp);
                }
            }
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_set_event_report_input_ecio_threshold_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_ECIO_THRESHOLD, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " report = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " thresholds = '");
    {
        guint thresholds_i;
        guint8 thresholds_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(thresholds_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (thresholds_i = 0; thresholds_i < thresholds_n_items; thresholds_i++) {
            g_string_append_printf (printable, " [%u] = '", thresholds_i);

            {
                gint16 tmp;

                if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%" G_GINT16_FORMAT "", tmp);
                }
            }
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_set_event_report_input_error_rate_indicator_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_ERROR_RATE_INDICATOR, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_set_event_report_input_sinr_indicator_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_SINR_INDICATOR, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " report = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " sinr_delta = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_set_event_report_input_io_indicator_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_IO_INDICATOR, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " report = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " io_delta = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_set_event_report_input_ecio_indicator_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_ECIO_INDICATOR, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " report = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ecio_delta = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_set_event_report_input_rssi_indicator_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_RSSI_INDICATOR, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " report = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " rssi_delta = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%u", (guint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_set_event_report_input_registration_reject_reason_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_REGISTRATION_REJECT_REASON, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_set_event_report_input_rf_band_information_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_RF_BAND_INFORMATION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_set_event_report_input_signal_strength_indicator_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_SIGNAL_STRENGTH_INDICATOR, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " report = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " thresholds = '");
    {
        guint thresholds_i;
        guint8 thresholds_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(thresholds_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (thresholds_i = 0; thresholds_i < thresholds_n_items; thresholds_i++) {
            g_string_append_printf (printable, " [%u] = '", thresholds_i);

            {
                gint8 tmp;

                if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%d", (gint)tmp);
                }
            }
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_set_event_report_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_set_event_report_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_set_event_report_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_LTE_RSRP_DELTA:
            tlv_type_str = "LTE RSRP Delta";
            translated_value = qmi_message_nas_set_event_report_input_lte_rsrp_delta_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_LTE_SNR_DELTA:
            tlv_type_str = "LTE SNR Delta";
            translated_value = qmi_message_nas_set_event_report_input_lte_snr_delta_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_SINR_THRESHOLD:
            tlv_type_str = "SINR Threshold";
            translated_value = qmi_message_nas_set_event_report_input_sinr_threshold_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_ECIO_THRESHOLD:
            tlv_type_str = "ECIO Threshold";
            translated_value = qmi_message_nas_set_event_report_input_ecio_threshold_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_ERROR_RATE_INDICATOR:
            tlv_type_str = "Error Rate Indicator";
            translated_value = qmi_message_nas_set_event_report_input_error_rate_indicator_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_SINR_INDICATOR:
            tlv_type_str = "SINR Indicator";
            translated_value = qmi_message_nas_set_event_report_input_sinr_indicator_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_IO_INDICATOR:
            tlv_type_str = "IO Indicator";
            translated_value = qmi_message_nas_set_event_report_input_io_indicator_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_ECIO_INDICATOR:
            tlv_type_str = "ECIO Indicator";
            translated_value = qmi_message_nas_set_event_report_input_ecio_indicator_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_RSSI_INDICATOR:
            tlv_type_str = "RSSI Indicator";
            translated_value = qmi_message_nas_set_event_report_input_rssi_indicator_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_REGISTRATION_REJECT_REASON:
            tlv_type_str = "Registration Reject Reason";
            translated_value = qmi_message_nas_set_event_report_input_registration_reject_reason_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_RF_BAND_INFORMATION:
            tlv_type_str = "RF Band Information";
            translated_value = qmi_message_nas_set_event_report_input_rf_band_information_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_SET_EVENT_REPORT_INPUT_TLV_SIGNAL_STRENGTH_INDICATOR:
            tlv_type_str = "Signal Strength Indicator";
            translated_value = qmi_message_nas_set_event_report_input_signal_strength_indicator_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_NAS_SET_EVENT_REPORT_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_set_event_report_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Set Event Report\" (0x0002)\n",
                            line_prefix);

    {
        struct message_set_event_report_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_set_event_report_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageNasSetEventReportOutput *
qmi_message_nas_set_event_report_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageNasSetEventReportOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_NAS_SET_EVENT_REPORT);

    self = g_slice_new0 (QmiMessageNasSetEventReportOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_SET_EVENT_REPORT_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_nas_set_event_report_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_nas_set_event_report_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message NAS Register Indications */


/* --- Input -- */

struct _QmiMessageNasRegisterIndicationsInput {
    volatile gint ref_count;

    /* Network Reject Information */
    gboolean arg_network_reject_information_set;
    guint8 arg_network_reject_information_enable_network_reject_indications;
    guint8 arg_network_reject_information_supress_system_info_indications;

    /* RF Band Information */
    gboolean arg_rf_band_information_set;
    guint8 arg_rf_band_information;

    /* eMBMS Status */
    gboolean arg_embms_status_set;
    guint8 arg_embms_status;

    /* Current PLMN Name */
    gboolean arg_current_plmn_name_set;
    guint8 arg_current_plmn_name;

    /* Managed Roaming */
    gboolean arg_managed_roaming_set;
    guint8 arg_managed_roaming;

    /* HDR Session Closed */
    gboolean arg_hdr_session_closed_set;
    guint8 arg_hdr_session_closed;

    /* HDR New UATI Assigned */
    gboolean arg_hdr_new_uati_assigned_set;
    guint8 arg_hdr_new_uati_assigned;

    /* Error Rate */
    gboolean arg_error_rate_set;
    guint8 arg_error_rate;

    /* Signal Info */
    gboolean arg_signal_info_set;
    guint8 arg_signal_info;

    /* System Info */
    gboolean arg_system_info_set;
    guint8 arg_system_info;

    /* Network Time */
    gboolean arg_network_time_set;
    guint8 arg_network_time;

    /* Subscription Info */
    gboolean arg_subscription_info_set;
    guint8 arg_subscription_info;

    /* Dual Standby Preference */
    gboolean arg_dual_standby_preference_set;
    guint8 arg_dual_standby_preference;

    /* Serving System Events */
    gboolean arg_serving_system_events_set;
    guint8 arg_serving_system_events;

    /* DDTM Events */
    gboolean arg_ddtm_events_set;
    guint8 arg_ddtm_events;

    /* System Selection Preference */
    gboolean arg_system_selection_preference_set;
    guint8 arg_system_selection_preference;
};

#define QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_NETWORK_REJECT_INFORMATION 0x21
#define QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_RF_BAND_INFORMATION 0x20
#define QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_EMBMS_STATUS 0x1F
#define QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_CURRENT_PLMN_NAME 0x1E
#define QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_MANAGED_ROAMING 0x1D
#define QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_HDR_SESSION_CLOSED 0x1C
#define QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_HDR_NEW_UATI_ASSIGNED 0x1B
#define QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_ERROR_RATE 0x1A
#define QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_SIGNAL_INFO 0x19
#define QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_SYSTEM_INFO 0x18
#define QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_NETWORK_TIME 0x17
#define QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_SUBSCRIPTION_INFO 0x15
#define QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_DUAL_STANDBY_PREFERENCE 0x14
#define QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_SERVING_SYSTEM_EVENTS 0x13
#define QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_DDTM_EVENTS 0x12
#define QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_SYSTEM_SELECTION_PREFERENCE 0x10

gboolean
qmi_message_nas_register_indications_input_get_network_reject_information (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean *value_network_reject_information_enable_network_reject_indications,
    gboolean *value_network_reject_information_supress_system_info_indications,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_network_reject_information_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Network Reject Information' was not found in the message");
        return FALSE;
    }

    if (value_network_reject_information_enable_network_reject_indications)
        *value_network_reject_information_enable_network_reject_indications = (gboolean)(self->arg_network_reject_information_enable_network_reject_indications);
    if (value_network_reject_information_supress_system_info_indications)
        *value_network_reject_information_supress_system_info_indications = (gboolean)(self->arg_network_reject_information_supress_system_info_indications);

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_set_network_reject_information (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean value_network_reject_information_enable_network_reject_indications,
    gboolean value_network_reject_information_supress_system_info_indications,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_network_reject_information_enable_network_reject_indications = (guint8)(value_network_reject_information_enable_network_reject_indications);
    self->arg_network_reject_information_supress_system_info_indications = (guint8)(value_network_reject_information_supress_system_info_indications);
    self->arg_network_reject_information_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_get_rf_band_information (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean *value_rf_band_information,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_rf_band_information_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'RF Band Information' was not found in the message");
        return FALSE;
    }

    if (value_rf_band_information)
        *value_rf_band_information = (gboolean)(self->arg_rf_band_information);

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_set_rf_band_information (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean value_rf_band_information,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_rf_band_information = (guint8)(value_rf_band_information);
    self->arg_rf_band_information_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_get_embms_status (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean *value_embms_status,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_embms_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'eMBMS Status' was not found in the message");
        return FALSE;
    }

    if (value_embms_status)
        *value_embms_status = (gboolean)(self->arg_embms_status);

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_set_embms_status (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean value_embms_status,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_embms_status = (guint8)(value_embms_status);
    self->arg_embms_status_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_get_current_plmn_name (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean *value_current_plmn_name,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_current_plmn_name_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Current PLMN Name' was not found in the message");
        return FALSE;
    }

    if (value_current_plmn_name)
        *value_current_plmn_name = (gboolean)(self->arg_current_plmn_name);

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_set_current_plmn_name (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean value_current_plmn_name,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_current_plmn_name = (guint8)(value_current_plmn_name);
    self->arg_current_plmn_name_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_get_managed_roaming (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean *value_managed_roaming,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_managed_roaming_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Managed Roaming' was not found in the message");
        return FALSE;
    }

    if (value_managed_roaming)
        *value_managed_roaming = (gboolean)(self->arg_managed_roaming);

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_set_managed_roaming (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean value_managed_roaming,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_managed_roaming = (guint8)(value_managed_roaming);
    self->arg_managed_roaming_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_get_hdr_session_closed (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean *value_hdr_session_closed,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_hdr_session_closed_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'HDR Session Closed' was not found in the message");
        return FALSE;
    }

    if (value_hdr_session_closed)
        *value_hdr_session_closed = (gboolean)(self->arg_hdr_session_closed);

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_set_hdr_session_closed (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean value_hdr_session_closed,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_hdr_session_closed = (guint8)(value_hdr_session_closed);
    self->arg_hdr_session_closed_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_get_hdr_new_uati_assigned (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean *value_hdr_new_uati_assigned,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_hdr_new_uati_assigned_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'HDR New UATI Assigned' was not found in the message");
        return FALSE;
    }

    if (value_hdr_new_uati_assigned)
        *value_hdr_new_uati_assigned = (gboolean)(self->arg_hdr_new_uati_assigned);

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_set_hdr_new_uati_assigned (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean value_hdr_new_uati_assigned,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_hdr_new_uati_assigned = (guint8)(value_hdr_new_uati_assigned);
    self->arg_hdr_new_uati_assigned_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_get_error_rate (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean *value_error_rate,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_error_rate_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Error Rate' was not found in the message");
        return FALSE;
    }

    if (value_error_rate)
        *value_error_rate = (gboolean)(self->arg_error_rate);

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_set_error_rate (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean value_error_rate,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_error_rate = (guint8)(value_error_rate);
    self->arg_error_rate_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_get_signal_info (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean *value_signal_info,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_signal_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Signal Info' was not found in the message");
        return FALSE;
    }

    if (value_signal_info)
        *value_signal_info = (gboolean)(self->arg_signal_info);

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_set_signal_info (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean value_signal_info,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_signal_info = (guint8)(value_signal_info);
    self->arg_signal_info_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_get_system_info (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean *value_system_info,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_system_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'System Info' was not found in the message");
        return FALSE;
    }

    if (value_system_info)
        *value_system_info = (gboolean)(self->arg_system_info);

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_set_system_info (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean value_system_info,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_system_info = (guint8)(value_system_info);
    self->arg_system_info_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_get_network_time (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean *value_network_time,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_network_time_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Network Time' was not found in the message");
        return FALSE;
    }

    if (value_network_time)
        *value_network_time = (gboolean)(self->arg_network_time);

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_set_network_time (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean value_network_time,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_network_time = (guint8)(value_network_time);
    self->arg_network_time_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_get_subscription_info (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean *value_subscription_info,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_subscription_info_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Subscription Info' was not found in the message");
        return FALSE;
    }

    if (value_subscription_info)
        *value_subscription_info = (gboolean)(self->arg_subscription_info);

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_set_subscription_info (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean value_subscription_info,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_subscription_info = (guint8)(value_subscription_info);
    self->arg_subscription_info_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_get_dual_standby_preference (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean *value_dual_standby_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_dual_standby_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Dual Standby Preference' was not found in the message");
        return FALSE;
    }

    if (value_dual_standby_preference)
        *value_dual_standby_preference = (gboolean)(self->arg_dual_standby_preference);

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_set_dual_standby_preference (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean value_dual_standby_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_dual_standby_preference = (guint8)(value_dual_standby_preference);
    self->arg_dual_standby_preference_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_get_serving_system_events (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean *value_serving_system_events,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_serving_system_events_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Serving System Events' was not found in the message");
        return FALSE;
    }

    if (value_serving_system_events)
        *value_serving_system_events = (gboolean)(self->arg_serving_system_events);

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_set_serving_system_events (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean value_serving_system_events,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_serving_system_events = (guint8)(value_serving_system_events);
    self->arg_serving_system_events_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_get_ddtm_events (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean *value_ddtm_events,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_ddtm_events_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'DDTM Events' was not found in the message");
        return FALSE;
    }

    if (value_ddtm_events)
        *value_ddtm_events = (gboolean)(self->arg_ddtm_events);

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_set_ddtm_events (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean value_ddtm_events,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_ddtm_events = (guint8)(value_ddtm_events);
    self->arg_ddtm_events_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_get_system_selection_preference (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean *value_system_selection_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_system_selection_preference_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'System Selection Preference' was not found in the message");
        return FALSE;
    }

    if (value_system_selection_preference)
        *value_system_selection_preference = (gboolean)(self->arg_system_selection_preference);

    return TRUE;
}

gboolean
qmi_message_nas_register_indications_input_set_system_selection_preference (
    QmiMessageNasRegisterIndicationsInput *self,
    gboolean value_system_selection_preference,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_system_selection_preference = (guint8)(value_system_selection_preference);
    self->arg_system_selection_preference_set = TRUE;

    return TRUE;
}

GType
qmi_message_nas_register_indications_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageNasRegisterIndicationsInput"),
                                          (GBoxedCopyFunc) qmi_message_nas_register_indications_input_ref,
                                          (GBoxedFreeFunc) qmi_message_nas_register_indications_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageNasRegisterIndicationsInput *
qmi_message_nas_register_indications_input_ref (QmiMessageNasRegisterIndicationsInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_nas_register_indications_input_unref (QmiMessageNasRegisterIndicationsInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageNasRegisterIndicationsInput, self);
    }
}

QmiMessageNasRegisterIndicationsInput *
qmi_message_nas_register_indications_input_new (void)
{
    QmiMessageNasRegisterIndicationsInput *self;

    self = g_slice_new0 (QmiMessageNasRegisterIndicationsInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_nas_register_indications_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageNasRegisterIndicationsInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_NAS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_NAS_REGISTER_INDICATIONS);

    /* All TLVs are optional, we allow NULL input */
    if (!input)
        return g_steal_pointer (&self);

    /* Try to add the 'Network Reject Information' TLV */
    if (input->arg_network_reject_information_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_NETWORK_REJECT_INFORMATION, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Network Reject Information': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_network_reject_information_enable_network_reject_indications;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Network Reject Information': ");
                return NULL;
            }
        }
        {
            guint8 tmp;

            tmp = (guint8) input->arg_network_reject_information_supress_system_info_indications;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Network Reject Information': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Network Reject Information': ");
            return NULL;
        }
    }

    /* Try to add the 'RF Band Information' TLV */
    if (input->arg_rf_band_information_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_RF_BAND_INFORMATION, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'RF Band Information': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_rf_band_information;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'RF Band Information': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'RF Band Information': ");
            return NULL;
        }
    }

    /* Try to add the 'eMBMS Status' TLV */
    if (input->arg_embms_status_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_EMBMS_STATUS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'eMBMS Status': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_embms_status;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'eMBMS Status': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'eMBMS Status': ");
            return NULL;
        }
    }

    /* Try to add the 'Current PLMN Name' TLV */
    if (input->arg_current_plmn_name_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_CURRENT_PLMN_NAME, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Current PLMN Name': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_current_plmn_name;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Current PLMN Name': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Current PLMN Name': ");
            return NULL;
        }
    }

    /* Try to add the 'Managed Roaming' TLV */
    if (input->arg_managed_roaming_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_MANAGED_ROAMING, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Managed Roaming': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_managed_roaming;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Managed Roaming': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Managed Roaming': ");
            return NULL;
        }
    }

    /* Try to add the 'HDR Session Closed' TLV */
    if (input->arg_hdr_session_closed_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_HDR_SESSION_CLOSED, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'HDR Session Closed': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_hdr_session_closed;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'HDR Session Closed': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'HDR Session Closed': ");
            return NULL;
        }
    }

    /* Try to add the 'HDR New UATI Assigned' TLV */
    if (input->arg_hdr_new_uati_assigned_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_HDR_NEW_UATI_ASSIGNED, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'HDR New UATI Assigned': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_hdr_new_uati_assigned;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'HDR New UATI Assigned': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'HDR New UATI Assigned': ");
            return NULL;
        }
    }

    /* Try to add the 'Error Rate' TLV */
    if (input->arg_error_rate_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_ERROR_RATE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Error Rate': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_error_rate;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Error Rate': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Error Rate': ");
            return NULL;
        }
    }

    /* Try to add the 'Signal Info' TLV */
    if (input->arg_signal_info_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_SIGNAL_INFO, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Signal Info': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_signal_info;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Signal Info': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Signal Info': ");
            return NULL;
        }
    }

    /* Try to add the 'System Info' TLV */
    if (input->arg_system_info_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_SYSTEM_INFO, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'System Info': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_system_info;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'System Info': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'System Info': ");
            return NULL;
        }
    }

    /* Try to add the 'Network Time' TLV */
    if (input->arg_network_time_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_NETWORK_TIME, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Network Time': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_network_time;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Network Time': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Network Time': ");
            return NULL;
        }
    }

    /* Try to add the 'Subscription Info' TLV */
    if (input->arg_subscription_info_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_SUBSCRIPTION_INFO, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Subscription Info': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_subscription_info;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Subscription Info': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Subscription Info': ");
            return NULL;
        }
    }

    /* Try to add the 'Dual Standby Preference' TLV */
    if (input->arg_dual_standby_preference_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_DUAL_STANDBY_PREFERENCE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Dual Standby Preference': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_dual_standby_preference;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Dual Standby Preference': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Dual Standby Preference': ");
            return NULL;
        }
    }

    /* Try to add the 'Serving System Events' TLV */
    if (input->arg_serving_system_events_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_SERVING_SYSTEM_EVENTS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Serving System Events': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_serving_system_events;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Serving System Events': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Serving System Events': ");
            return NULL;
        }
    }

    /* Try to add the 'DDTM Events' TLV */
    if (input->arg_ddtm_events_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_DDTM_EVENTS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'DDTM Events': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_ddtm_events;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'DDTM Events': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'DDTM Events': ");
            return NULL;
        }
    }

    /* Try to add the 'System Selection Preference' TLV */
    if (input->arg_system_selection_preference_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_SYSTEM_SELECTION_PREFERENCE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'System Selection Preference': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_system_selection_preference;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'System Selection Preference': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'System Selection Preference': ");
            return NULL;
        }
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageNasRegisterIndicationsOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_NAS_REGISTER_INDICATIONS_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_nas_register_indications_output_get_result (
    QmiMessageNasRegisterIndicationsOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_nas_register_indications_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageNasRegisterIndicationsOutput"),
                                          (GBoxedCopyFunc) qmi_message_nas_register_indications_output_ref,
                                          (GBoxedFreeFunc) qmi_message_nas_register_indications_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageNasRegisterIndicationsOutput *
qmi_message_nas_register_indications_output_ref (QmiMessageNasRegisterIndicationsOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_nas_register_indications_output_unref (QmiMessageNasRegisterIndicationsOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageNasRegisterIndicationsOutput, self);
    }
}

static gchar *
qmi_message_nas_register_indications_input_network_reject_information_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_NETWORK_REJECT_INFORMATION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " enable_network_reject_indications = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " supress_system_info_indications = '");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_register_indications_input_rf_band_information_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_RF_BAND_INFORMATION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_register_indications_input_embms_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_EMBMS_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_register_indications_input_current_plmn_name_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_CURRENT_PLMN_NAME, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_register_indications_input_managed_roaming_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_MANAGED_ROAMING, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_register_indications_input_hdr_session_closed_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_HDR_SESSION_CLOSED, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_register_indications_input_hdr_new_uati_assigned_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_HDR_NEW_UATI_ASSIGNED, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_register_indications_input_error_rate_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_ERROR_RATE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_register_indications_input_signal_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_SIGNAL_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_register_indications_input_system_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_SYSTEM_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_register_indications_input_network_time_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_NETWORK_TIME, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_register_indications_input_subscription_info_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_SUBSCRIPTION_INFO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_register_indications_input_dual_standby_preference_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_DUAL_STANDBY_PREFERENCE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_register_indications_input_serving_system_events_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_SERVING_SYSTEM_EVENTS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_register_indications_input_ddtm_events_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_DDTM_EVENTS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_register_indications_input_system_selection_preference_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_SYSTEM_SELECTION_PREFERENCE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_register_indications_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_register_indications_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_register_indications_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_NETWORK_REJECT_INFORMATION:
            tlv_type_str = "Network Reject Information";
            translated_value = qmi_message_nas_register_indications_input_network_reject_information_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_RF_BAND_INFORMATION:
            tlv_type_str = "RF Band Information";
            translated_value = qmi_message_nas_register_indications_input_rf_band_information_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_EMBMS_STATUS:
            tlv_type_str = "eMBMS Status";
            translated_value = qmi_message_nas_register_indications_input_embms_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_CURRENT_PLMN_NAME:
            tlv_type_str = "Current PLMN Name";
            translated_value = qmi_message_nas_register_indications_input_current_plmn_name_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_MANAGED_ROAMING:
            tlv_type_str = "Managed Roaming";
            translated_value = qmi_message_nas_register_indications_input_managed_roaming_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_HDR_SESSION_CLOSED:
            tlv_type_str = "HDR Session Closed";
            translated_value = qmi_message_nas_register_indications_input_hdr_session_closed_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_HDR_NEW_UATI_ASSIGNED:
            tlv_type_str = "HDR New UATI Assigned";
            translated_value = qmi_message_nas_register_indications_input_hdr_new_uati_assigned_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_ERROR_RATE:
            tlv_type_str = "Error Rate";
            translated_value = qmi_message_nas_register_indications_input_error_rate_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_SIGNAL_INFO:
            tlv_type_str = "Signal Info";
            translated_value = qmi_message_nas_register_indications_input_signal_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_SYSTEM_INFO:
            tlv_type_str = "System Info";
            translated_value = qmi_message_nas_register_indications_input_system_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_NETWORK_TIME:
            tlv_type_str = "Network Time";
            translated_value = qmi_message_nas_register_indications_input_network_time_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_SUBSCRIPTION_INFO:
            tlv_type_str = "Subscription Info";
            translated_value = qmi_message_nas_register_indications_input_subscription_info_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_DUAL_STANDBY_PREFERENCE:
            tlv_type_str = "Dual Standby Preference";
            translated_value = qmi_message_nas_register_indications_input_dual_standby_preference_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_SERVING_SYSTEM_EVENTS:
            tlv_type_str = "Serving System Events";
            translated_value = qmi_message_nas_register_indications_input_serving_system_events_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_DDTM_EVENTS:
            tlv_type_str = "DDTM Events";
            translated_value = qmi_message_nas_register_indications_input_ddtm_events_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_REGISTER_INDICATIONS_INPUT_TLV_SYSTEM_SELECTION_PREFERENCE:
            tlv_type_str = "System Selection Preference";
            translated_value = qmi_message_nas_register_indications_input_system_selection_preference_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_NAS_REGISTER_INDICATIONS_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_register_indications_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Register Indications\" (0x0003)\n",
                            line_prefix);

    {
        struct message_register_indications_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_register_indications_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageNasRegisterIndicationsOutput *
qmi_message_nas_register_indications_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageNasRegisterIndicationsOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_NAS_REGISTER_INDICATIONS);

    self = g_slice_new0 (QmiMessageNasRegisterIndicationsOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_REGISTER_INDICATIONS_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_nas_register_indications_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_nas_register_indications_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message NAS Get Supported Messages */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_nas_get_supported_messages_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_NAS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_NAS_GET_SUPPORTED_MESSAGES);

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageNasGetSupportedMessagesOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* List */
    gboolean arg_list_set;
    GArray *arg_list;
};

#define QMI_MESSAGE_NAS_GET_SUPPORTED_MESSAGES_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_NAS_GET_SUPPORTED_MESSAGES_OUTPUT_TLV_LIST 0x10

gboolean
qmi_message_nas_get_supported_messages_output_get_result (
    QmiMessageNasGetSupportedMessagesOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_nas_get_supported_messages_output_get_list (
    QmiMessageNasGetSupportedMessagesOutput *self,
    GArray **value_list,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'List' was not found in the message");
        return FALSE;
    }

    if (value_list)
        *value_list = self->arg_list;

    return TRUE;
}

GType
qmi_message_nas_get_supported_messages_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageNasGetSupportedMessagesOutput"),
                                          (GBoxedCopyFunc) qmi_message_nas_get_supported_messages_output_ref,
                                          (GBoxedFreeFunc) qmi_message_nas_get_supported_messages_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageNasGetSupportedMessagesOutput *
qmi_message_nas_get_supported_messages_output_ref (QmiMessageNasGetSupportedMessagesOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_nas_get_supported_messages_output_unref (QmiMessageNasGetSupportedMessagesOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_list, (GDestroyNotify)g_array_unref);
        g_slice_free (QmiMessageNasGetSupportedMessagesOutput, self);
    }
}

static gchar *
qmi_message_nas_get_supported_messages_output_list_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SUPPORTED_MESSAGES_OUTPUT_TLV_LIST, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint list_i;
        guint16 list_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(list_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (list_i = 0; list_i < list_n_items; list_i++) {
            g_string_append_printf (printable, " [%u] = '", list_i);

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%u", (guint)tmp);
                }
            }
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_supported_messages_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_supported_messages_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_supported_messages_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_NAS_GET_SUPPORTED_MESSAGES_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_GET_SUPPORTED_MESSAGES_OUTPUT_TLV_LIST:
            tlv_type_str = "List";
            translated_value = qmi_message_nas_get_supported_messages_output_list_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_supported_messages_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Supported Messages\" (0x001E)\n",
                            line_prefix);

    {
        struct message_get_supported_messages_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_supported_messages_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageNasGetSupportedMessagesOutput *
qmi_message_nas_get_supported_messages_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageNasGetSupportedMessagesOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_NAS_GET_SUPPORTED_MESSAGES);

    self = g_slice_new0 (QmiMessageNasGetSupportedMessagesOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SUPPORTED_MESSAGES_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_nas_get_supported_messages_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_nas_get_supported_messages_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SUPPORTED_MESSAGES_OUTPUT_TLV_LIST, NULL, NULL)) == 0) {
                goto qmi_message_nas_get_supported_messages_output_list_out;
            }
            {
                guint list_i;
                guint16 list_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(list_n_items), NULL))
                    goto qmi_message_nas_get_supported_messages_output_list_out;

                self->arg_list = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (guint8),
                    (guint)list_n_items);

                for (list_i = 0; list_i < list_n_items; list_i++) {
                    guint8 list_aux;

                    if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(list_aux), NULL))
                        goto qmi_message_nas_get_supported_messages_output_list_out;
                    g_array_insert_val (self->arg_list, list_i, list_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'List' TLV", offset);
            }

            self->arg_list_set = TRUE;

qmi_message_nas_get_supported_messages_output_list_out:
            ;

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message NAS Get Signal Strength */


/* --- Input -- */

struct _QmiMessageNasGetSignalStrengthInput {
    volatile gint ref_count;

    /* Request Mask */
    gboolean arg_request_mask_set;
    guint16 arg_request_mask;
};

#define QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_INPUT_TLV_REQUEST_MASK 0x10

gboolean
qmi_message_nas_get_signal_strength_input_get_request_mask (
    QmiMessageNasGetSignalStrengthInput *self,
    QmiNasSignalStrengthRequest *value_request_mask,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_request_mask_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Request Mask' was not found in the message");
        return FALSE;
    }

    if (value_request_mask)
        *value_request_mask = (QmiNasSignalStrengthRequest)(self->arg_request_mask);

    return TRUE;
}

gboolean
qmi_message_nas_get_signal_strength_input_set_request_mask (
    QmiMessageNasGetSignalStrengthInput *self,
    QmiNasSignalStrengthRequest value_request_mask,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_request_mask = (guint16)(value_request_mask);
    self->arg_request_mask_set = TRUE;

    return TRUE;
}

GType
qmi_message_nas_get_signal_strength_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageNasGetSignalStrengthInput"),
                                          (GBoxedCopyFunc) qmi_message_nas_get_signal_strength_input_ref,
                                          (GBoxedFreeFunc) qmi_message_nas_get_signal_strength_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageNasGetSignalStrengthInput *
qmi_message_nas_get_signal_strength_input_ref (QmiMessageNasGetSignalStrengthInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_nas_get_signal_strength_input_unref (QmiMessageNasGetSignalStrengthInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageNasGetSignalStrengthInput, self);
    }
}

QmiMessageNasGetSignalStrengthInput *
qmi_message_nas_get_signal_strength_input_new (void)
{
    QmiMessageNasGetSignalStrengthInput *self;

    self = g_slice_new0 (QmiMessageNasGetSignalStrengthInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_nas_get_signal_strength_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageNasGetSignalStrengthInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_NAS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH);

    /* All TLVs are optional, we allow NULL input */
    if (!input)
        return g_steal_pointer (&self);

    /* Try to add the 'Request Mask' TLV */
    if (input->arg_request_mask_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_INPUT_TLV_REQUEST_MASK, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Request Mask': ");
            return NULL;
        }

        {
            guint16 tmp;

            tmp = (guint16) input->arg_request_mask;
            /* Write the guint16 variable to the buffer */
            if (!qmi_message_tlv_write_guint16 (self, QMI_ENDIAN_LITTLE, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Request Mask': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Request Mask': ");
            return NULL;
        }
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

static void
__qmi_message_nas_get_signal_strength_output_error_rate_list_element_free (QmiMessageNasGetSignalStrengthOutputErrorRateListElement *value)
{
    g_slice_free (QmiMessageNasGetSignalStrengthOutputErrorRateListElement, value);
}

static QmiMessageNasGetSignalStrengthOutputErrorRateListElement *
__qmi_message_nas_get_signal_strength_output_error_rate_list_element_new (void)
{
    return g_slice_new0 (QmiMessageNasGetSignalStrengthOutputErrorRateListElement);
}

static QmiMessageNasGetSignalStrengthOutputErrorRateListElement *
__qmi_message_nas_get_signal_strength_output_error_rate_list_element_copy (const QmiMessageNasGetSignalStrengthOutputErrorRateListElement *value)
{
    QmiMessageNasGetSignalStrengthOutputErrorRateListElement *copy;

    copy = __qmi_message_nas_get_signal_strength_output_error_rate_list_element_new ();
    copy->rate = value->rate;
    copy->radio_interface = value->radio_interface;
    return copy;
}

G_DEFINE_BOXED_TYPE (QmiMessageNasGetSignalStrengthOutputErrorRateListElement, qmi_message_nas_get_signal_strength_output_error_rate_list_element, (GBoxedCopyFunc)__qmi_message_nas_get_signal_strength_output_error_rate_list_element_copy, (GBoxedFreeFunc)__qmi_message_nas_get_signal_strength_output_error_rate_list_element_free)

static void
__qmi_message_nas_get_signal_strength_output_ecio_list_element_free (QmiMessageNasGetSignalStrengthOutputEcioListElement *value)
{
    g_slice_free (QmiMessageNasGetSignalStrengthOutputEcioListElement, value);
}

static QmiMessageNasGetSignalStrengthOutputEcioListElement *
__qmi_message_nas_get_signal_strength_output_ecio_list_element_new (void)
{
    return g_slice_new0 (QmiMessageNasGetSignalStrengthOutputEcioListElement);
}

static QmiMessageNasGetSignalStrengthOutputEcioListElement *
__qmi_message_nas_get_signal_strength_output_ecio_list_element_copy (const QmiMessageNasGetSignalStrengthOutputEcioListElement *value)
{
    QmiMessageNasGetSignalStrengthOutputEcioListElement *copy;

    copy = __qmi_message_nas_get_signal_strength_output_ecio_list_element_new ();
    copy->ecio = value->ecio;
    copy->radio_interface = value->radio_interface;
    return copy;
}

G_DEFINE_BOXED_TYPE (QmiMessageNasGetSignalStrengthOutputEcioListElement, qmi_message_nas_get_signal_strength_output_ecio_list_element, (GBoxedCopyFunc)__qmi_message_nas_get_signal_strength_output_ecio_list_element_copy, (GBoxedFreeFunc)__qmi_message_nas_get_signal_strength_output_ecio_list_element_free)

static void
__qmi_message_nas_get_signal_strength_output_rssi_list_element_free (QmiMessageNasGetSignalStrengthOutputRssiListElement *value)
{
    g_slice_free (QmiMessageNasGetSignalStrengthOutputRssiListElement, value);
}

static QmiMessageNasGetSignalStrengthOutputRssiListElement *
__qmi_message_nas_get_signal_strength_output_rssi_list_element_new (void)
{
    return g_slice_new0 (QmiMessageNasGetSignalStrengthOutputRssiListElement);
}

static QmiMessageNasGetSignalStrengthOutputRssiListElement *
__qmi_message_nas_get_signal_strength_output_rssi_list_element_copy (const QmiMessageNasGetSignalStrengthOutputRssiListElement *value)
{
    QmiMessageNasGetSignalStrengthOutputRssiListElement *copy;

    copy = __qmi_message_nas_get_signal_strength_output_rssi_list_element_new ();
    copy->rssi = value->rssi;
    copy->radio_interface = value->radio_interface;
    return copy;
}

G_DEFINE_BOXED_TYPE (QmiMessageNasGetSignalStrengthOutputRssiListElement, qmi_message_nas_get_signal_strength_output_rssi_list_element, (GBoxedCopyFunc)__qmi_message_nas_get_signal_strength_output_rssi_list_element_copy, (GBoxedFreeFunc)__qmi_message_nas_get_signal_strength_output_rssi_list_element_free)

static void
__qmi_message_nas_get_signal_strength_output_strength_list_element_free (QmiMessageNasGetSignalStrengthOutputStrengthListElement *value)
{
    g_slice_free (QmiMessageNasGetSignalStrengthOutputStrengthListElement, value);
}

static QmiMessageNasGetSignalStrengthOutputStrengthListElement *
__qmi_message_nas_get_signal_strength_output_strength_list_element_new (void)
{
    return g_slice_new0 (QmiMessageNasGetSignalStrengthOutputStrengthListElement);
}

static QmiMessageNasGetSignalStrengthOutputStrengthListElement *
__qmi_message_nas_get_signal_strength_output_strength_list_element_copy (const QmiMessageNasGetSignalStrengthOutputStrengthListElement *value)
{
    QmiMessageNasGetSignalStrengthOutputStrengthListElement *copy;

    copy = __qmi_message_nas_get_signal_strength_output_strength_list_element_new ();
    copy->strength = value->strength;
    copy->radio_interface = value->radio_interface;
    return copy;
}

G_DEFINE_BOXED_TYPE (QmiMessageNasGetSignalStrengthOutputStrengthListElement, qmi_message_nas_get_signal_strength_output_strength_list_element, (GBoxedCopyFunc)__qmi_message_nas_get_signal_strength_output_strength_list_element_copy, (GBoxedFreeFunc)__qmi_message_nas_get_signal_strength_output_strength_list_element_free)

struct _QmiMessageNasGetSignalStrengthOutput {
    volatile gint ref_count;

    /* LTE RSRP */
    gboolean arg_lte_rsrp_set;
    gint16 arg_lte_rsrp;

    /* LTE SNR */
    gboolean arg_lte_snr_set;
    gint16 arg_lte_snr;

    /* RSRQ */
    gboolean arg_rsrq_set;
    gint8 arg_rsrq_rsrq;
    gint8 arg_rsrq_radio_interface;

    /* Error Rate List */
    gboolean arg_error_rate_list_set;
    GArray *arg_error_rate_list;
    GPtrArray *arg_error_rate_list_ptr;

    /* SINR */
    gboolean arg_sinr_set;
    guint8 arg_sinr;

    /* IO */
    gboolean arg_io_set;
    gint32 arg_io;

    /* ECIO List */
    gboolean arg_ecio_list_set;
    GArray *arg_ecio_list;
    GPtrArray *arg_ecio_list_ptr;

    /* RSSI List */
    gboolean arg_rssi_list_set;
    GArray *arg_rssi_list;
    GPtrArray *arg_rssi_list_ptr;

    /* Strength List */
    gboolean arg_strength_list_set;
    GArray *arg_strength_list;
    GPtrArray *arg_strength_list_ptr;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Signal Strength */
    gboolean arg_signal_strength_set;
    gint8 arg_signal_strength_strength;
    gint8 arg_signal_strength_radio_interface;
};

#define QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_LTE_RSRP 0x18
#define QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_LTE_SNR 0x17
#define QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_RSRQ 0x16
#define QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_ERROR_RATE_LIST 0x15
#define QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_SINR 0x14
#define QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_IO 0x13
#define QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_ECIO_LIST 0x12
#define QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_RSSI_LIST 0x11
#define QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_STRENGTH_LIST 0x10
#define QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_RESULT 0x02
#define QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_SIGNAL_STRENGTH 0x01

gboolean
qmi_message_nas_get_signal_strength_output_get_lte_rsrp (
    QmiMessageNasGetSignalStrengthOutput *self,
    gint16 *value_lte_rsrp,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_lte_rsrp_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'LTE RSRP' was not found in the message");
        return FALSE;
    }

    if (value_lte_rsrp)
        *value_lte_rsrp = self->arg_lte_rsrp;

    return TRUE;
}

gboolean
qmi_message_nas_get_signal_strength_output_get_lte_snr (
    QmiMessageNasGetSignalStrengthOutput *self,
    gint16 *value_lte_snr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_lte_snr_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'LTE SNR' was not found in the message");
        return FALSE;
    }

    if (value_lte_snr)
        *value_lte_snr = self->arg_lte_snr;

    return TRUE;
}

gboolean
qmi_message_nas_get_signal_strength_output_get_rsrq (
    QmiMessageNasGetSignalStrengthOutput *self,
    gint8 *value_rsrq_rsrq,
    QmiNasRadioInterface *value_rsrq_radio_interface,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_rsrq_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'RSRQ' was not found in the message");
        return FALSE;
    }

    if (value_rsrq_rsrq)
        *value_rsrq_rsrq = self->arg_rsrq_rsrq;
    if (value_rsrq_radio_interface)
        *value_rsrq_radio_interface = (QmiNasRadioInterface)(self->arg_rsrq_radio_interface);

    return TRUE;
}

gboolean
qmi_message_nas_get_signal_strength_output_get_error_rate_list (
    QmiMessageNasGetSignalStrengthOutput *self,
    GArray **value_error_rate_list,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_error_rate_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Error Rate List' was not found in the message");
        return FALSE;
    }

    if (value_error_rate_list)
        *value_error_rate_list = self->arg_error_rate_list;

    return TRUE;
}

gboolean
qmi_message_nas_get_signal_strength_output_get_error_rate_list_gir (
    QmiMessageNasGetSignalStrengthOutput *self,
    GPtrArray **value_error_rate_list_ptr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_error_rate_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Error Rate List' was not found in the message");
        return FALSE;
    }

    if (value_error_rate_list_ptr) {
        if (!self->arg_error_rate_list_ptr) {
            {
                guint error_rate_list_i;

                self->arg_error_rate_list_ptr = g_ptr_array_new_full (self->arg_error_rate_list->len, (GDestroyNotify)__qmi_message_nas_get_signal_strength_output_error_rate_list_element_free);
                for (error_rate_list_i = 0; error_rate_list_i < self->arg_error_rate_list->len; error_rate_list_i++) {
                    QmiMessageNasGetSignalStrengthOutputErrorRateListElement *error_rate_list_aux_from;
                    QmiMessageNasGetSignalStrengthOutputErrorRateListElement *error_rate_list_aux_to;

                    error_rate_list_aux_from = &g_array_index (self->arg_error_rate_list, QmiMessageNasGetSignalStrengthOutputErrorRateListElement, error_rate_list_i);

                    error_rate_list_aux_to = __qmi_message_nas_get_signal_strength_output_error_rate_list_element_new ();
                    error_rate_list_aux_to->rate = (*error_rate_list_aux_from).rate;
                    error_rate_list_aux_to->radio_interface = (*error_rate_list_aux_from).radio_interface;

                    g_ptr_array_add (self->arg_error_rate_list_ptr, error_rate_list_aux_to);
                }
            }
        }
        *value_error_rate_list_ptr = self->arg_error_rate_list_ptr;
    }
    return TRUE;
}

gboolean
qmi_message_nas_get_signal_strength_output_get_sinr (
    QmiMessageNasGetSignalStrengthOutput *self,
    QmiNasEvdoSinrLevel *value_sinr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_sinr_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'SINR' was not found in the message");
        return FALSE;
    }

    if (value_sinr)
        *value_sinr = (QmiNasEvdoSinrLevel)(self->arg_sinr);

    return TRUE;
}

gboolean
qmi_message_nas_get_signal_strength_output_get_io (
    QmiMessageNasGetSignalStrengthOutput *self,
    gint32 *value_io,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_io_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'IO' was not found in the message");
        return FALSE;
    }

    if (value_io)
        *value_io = self->arg_io;

    return TRUE;
}

gboolean
qmi_message_nas_get_signal_strength_output_get_ecio_list (
    QmiMessageNasGetSignalStrengthOutput *self,
    GArray **value_ecio_list,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_ecio_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'ECIO List' was not found in the message");
        return FALSE;
    }

    if (value_ecio_list)
        *value_ecio_list = self->arg_ecio_list;

    return TRUE;
}

gboolean
qmi_message_nas_get_signal_strength_output_get_ecio_list_gir (
    QmiMessageNasGetSignalStrengthOutput *self,
    GPtrArray **value_ecio_list_ptr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_ecio_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'ECIO List' was not found in the message");
        return FALSE;
    }

    if (value_ecio_list_ptr) {
        if (!self->arg_ecio_list_ptr) {
            {
                guint ecio_list_i;

                self->arg_ecio_list_ptr = g_ptr_array_new_full (self->arg_ecio_list->len, (GDestroyNotify)__qmi_message_nas_get_signal_strength_output_ecio_list_element_free);
                for (ecio_list_i = 0; ecio_list_i < self->arg_ecio_list->len; ecio_list_i++) {
                    QmiMessageNasGetSignalStrengthOutputEcioListElement *ecio_list_aux_from;
                    QmiMessageNasGetSignalStrengthOutputEcioListElement *ecio_list_aux_to;

                    ecio_list_aux_from = &g_array_index (self->arg_ecio_list, QmiMessageNasGetSignalStrengthOutputEcioListElement, ecio_list_i);

                    ecio_list_aux_to = __qmi_message_nas_get_signal_strength_output_ecio_list_element_new ();
                    ecio_list_aux_to->ecio = (*ecio_list_aux_from).ecio;
                    ecio_list_aux_to->radio_interface = (*ecio_list_aux_from).radio_interface;

                    g_ptr_array_add (self->arg_ecio_list_ptr, ecio_list_aux_to);
                }
            }
        }
        *value_ecio_list_ptr = self->arg_ecio_list_ptr;
    }
    return TRUE;
}

gboolean
qmi_message_nas_get_signal_strength_output_get_rssi_list (
    QmiMessageNasGetSignalStrengthOutput *self,
    GArray **value_rssi_list,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_rssi_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'RSSI List' was not found in the message");
        return FALSE;
    }

    if (value_rssi_list)
        *value_rssi_list = self->arg_rssi_list;

    return TRUE;
}

gboolean
qmi_message_nas_get_signal_strength_output_get_rssi_list_gir (
    QmiMessageNasGetSignalStrengthOutput *self,
    GPtrArray **value_rssi_list_ptr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_rssi_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'RSSI List' was not found in the message");
        return FALSE;
    }

    if (value_rssi_list_ptr) {
        if (!self->arg_rssi_list_ptr) {
            {
                guint rssi_list_i;

                self->arg_rssi_list_ptr = g_ptr_array_new_full (self->arg_rssi_list->len, (GDestroyNotify)__qmi_message_nas_get_signal_strength_output_rssi_list_element_free);
                for (rssi_list_i = 0; rssi_list_i < self->arg_rssi_list->len; rssi_list_i++) {
                    QmiMessageNasGetSignalStrengthOutputRssiListElement *rssi_list_aux_from;
                    QmiMessageNasGetSignalStrengthOutputRssiListElement *rssi_list_aux_to;

                    rssi_list_aux_from = &g_array_index (self->arg_rssi_list, QmiMessageNasGetSignalStrengthOutputRssiListElement, rssi_list_i);

                    rssi_list_aux_to = __qmi_message_nas_get_signal_strength_output_rssi_list_element_new ();
                    rssi_list_aux_to->rssi = (*rssi_list_aux_from).rssi;
                    rssi_list_aux_to->radio_interface = (*rssi_list_aux_from).radio_interface;

                    g_ptr_array_add (self->arg_rssi_list_ptr, rssi_list_aux_to);
                }
            }
        }
        *value_rssi_list_ptr = self->arg_rssi_list_ptr;
    }
    return TRUE;
}

gboolean
qmi_message_nas_get_signal_strength_output_get_strength_list (
    QmiMessageNasGetSignalStrengthOutput *self,
    GArray **value_strength_list,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_strength_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Strength List' was not found in the message");
        return FALSE;
    }

    if (value_strength_list)
        *value_strength_list = self->arg_strength_list;

    return TRUE;
}

gboolean
qmi_message_nas_get_signal_strength_output_get_strength_list_gir (
    QmiMessageNasGetSignalStrengthOutput *self,
    GPtrArray **value_strength_list_ptr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_strength_list_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Strength List' was not found in the message");
        return FALSE;
    }

    if (value_strength_list_ptr) {
        if (!self->arg_strength_list_ptr) {
            {
                guint strength_list_i;

                self->arg_strength_list_ptr = g_ptr_array_new_full (self->arg_strength_list->len, (GDestroyNotify)__qmi_message_nas_get_signal_strength_output_strength_list_element_free);
                for (strength_list_i = 0; strength_list_i < self->arg_strength_list->len; strength_list_i++) {
                    QmiMessageNasGetSignalStrengthOutputStrengthListElement *strength_list_aux_from;
                    QmiMessageNasGetSignalStrengthOutputStrengthListElement *strength_list_aux_to;

                    strength_list_aux_from = &g_array_index (self->arg_strength_list, QmiMessageNasGetSignalStrengthOutputStrengthListElement, strength_list_i);

                    strength_list_aux_to = __qmi_message_nas_get_signal_strength_output_strength_list_element_new ();
                    strength_list_aux_to->strength = (*strength_list_aux_from).strength;
                    strength_list_aux_to->radio_interface = (*strength_list_aux_from).radio_interface;

                    g_ptr_array_add (self->arg_strength_list_ptr, strength_list_aux_to);
                }
            }
        }
        *value_strength_list_ptr = self->arg_strength_list_ptr;
    }
    return TRUE;
}

gboolean
qmi_message_nas_get_signal_strength_output_get_result (
    QmiMessageNasGetSignalStrengthOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

gboolean
qmi_message_nas_get_signal_strength_output_get_signal_strength (
    QmiMessageNasGetSignalStrengthOutput *self,
    gint8 *value_signal_strength_strength,
    QmiNasRadioInterface *value_signal_strength_radio_interface,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_signal_strength_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Signal Strength' was not found in the message");
        return FALSE;
    }

    if (value_signal_strength_strength)
        *value_signal_strength_strength = self->arg_signal_strength_strength;
    if (value_signal_strength_radio_interface)
        *value_signal_strength_radio_interface = (QmiNasRadioInterface)(self->arg_signal_strength_radio_interface);

    return TRUE;
}

GType
qmi_message_nas_get_signal_strength_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageNasGetSignalStrengthOutput"),
                                          (GBoxedCopyFunc) qmi_message_nas_get_signal_strength_output_ref,
                                          (GBoxedFreeFunc) qmi_message_nas_get_signal_strength_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageNasGetSignalStrengthOutput *
qmi_message_nas_get_signal_strength_output_ref (QmiMessageNasGetSignalStrengthOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_nas_get_signal_strength_output_unref (QmiMessageNasGetSignalStrengthOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_error_rate_list, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_error_rate_list, (GDestroyNotify)g_ptr_array_unref);
        g_clear_pointer (&self->arg_ecio_list, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_ecio_list, (GDestroyNotify)g_ptr_array_unref);
        g_clear_pointer (&self->arg_rssi_list, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_rssi_list, (GDestroyNotify)g_ptr_array_unref);
        g_clear_pointer (&self->arg_strength_list, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_strength_list, (GDestroyNotify)g_ptr_array_unref);
        g_slice_free (QmiMessageNasGetSignalStrengthOutput, self);
    }
}

static gchar *
qmi_message_nas_get_signal_strength_input_request_mask_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_INPUT_TLV_REQUEST_MASK, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_SIGNAL_STRENGTH_REQUEST_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_signal_strength_request_get_string ((QmiNasSignalStrengthRequest)tmp));
#elif defined  __QMI_NAS_SIGNAL_STRENGTH_REQUEST_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_signal_strength_request_build_string_from_mask ((QmiNasSignalStrengthRequest)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasSignalStrengthRequest
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_get_signal_strength_output_lte_rsrp_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_LTE_RSRP, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        gint16 tmp;

        if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT16_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_get_signal_strength_output_lte_snr_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_LTE_SNR, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        gint16 tmp;

        if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT16_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_get_signal_strength_output_rsrq_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_RSRQ, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " rsrq = '");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%d", (gint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " radio_interface = '");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_RADIO_INTERFACE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_radio_interface_get_string ((QmiNasRadioInterface)tmp));
#elif defined  __QMI_NAS_RADIO_INTERFACE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_radio_interface_build_string_from_mask ((QmiNasRadioInterface)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRadioInterface
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_get_signal_strength_output_error_rate_list_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_ERROR_RATE_LIST, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint error_rate_list_i;
        guint16 error_rate_list_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(error_rate_list_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (error_rate_list_i = 0; error_rate_list_i < error_rate_list_n_items; error_rate_list_i++) {
            g_string_append_printf (printable, " [%u] = '", error_rate_list_i);
            g_string_append (printable, "[");
            g_string_append (printable, " rate = '");

            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " radio_interface = '");

            {
                gint8 tmp;

                if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_NAS_RADIO_INTERFACE_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_nas_radio_interface_get_string ((QmiNasRadioInterface)tmp));
#elif defined  __QMI_NAS_RADIO_INTERFACE_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_nas_radio_interface_build_string_from_mask ((QmiNasRadioInterface)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiNasRadioInterface
#endif
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " ]");
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_get_signal_strength_output_sinr_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_SINR, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_EVDO_SINR_LEVEL_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_evdo_sinr_level_get_string ((QmiNasEvdoSinrLevel)tmp));
#elif defined  __QMI_NAS_EVDO_SINR_LEVEL_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_evdo_sinr_level_build_string_from_mask ((QmiNasEvdoSinrLevel)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasEvdoSinrLevel
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_get_signal_strength_output_io_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_IO, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        gint32 tmp;

        if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GINT32_FORMAT "", tmp);
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_get_signal_strength_output_ecio_list_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_ECIO_LIST, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint ecio_list_i;
        guint16 ecio_list_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(ecio_list_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (ecio_list_i = 0; ecio_list_i < ecio_list_n_items; ecio_list_i++) {
            g_string_append_printf (printable, " [%u] = '", ecio_list_i);
            g_string_append (printable, "[");
            g_string_append (printable, " ecio = '");

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%u", (guint)tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " radio_interface = '");

            {
                gint8 tmp;

                if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_NAS_RADIO_INTERFACE_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_nas_radio_interface_get_string ((QmiNasRadioInterface)tmp));
#elif defined  __QMI_NAS_RADIO_INTERFACE_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_nas_radio_interface_build_string_from_mask ((QmiNasRadioInterface)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiNasRadioInterface
#endif
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " ]");
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_get_signal_strength_output_rssi_list_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_RSSI_LIST, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint rssi_list_i;
        guint16 rssi_list_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(rssi_list_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (rssi_list_i = 0; rssi_list_i < rssi_list_n_items; rssi_list_i++) {
            g_string_append_printf (printable, " [%u] = '", rssi_list_i);
            g_string_append (printable, "[");
            g_string_append (printable, " rssi = '");

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%u", (guint)tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " radio_interface = '");

            {
                gint8 tmp;

                if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_NAS_RADIO_INTERFACE_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_nas_radio_interface_get_string ((QmiNasRadioInterface)tmp));
#elif defined  __QMI_NAS_RADIO_INTERFACE_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_nas_radio_interface_build_string_from_mask ((QmiNasRadioInterface)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiNasRadioInterface
#endif
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " ]");
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_get_signal_strength_output_strength_list_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_STRENGTH_LIST, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint strength_list_i;
        guint16 strength_list_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(strength_list_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (strength_list_i = 0; strength_list_i < strength_list_n_items; strength_list_i++) {
            g_string_append_printf (printable, " [%u] = '", strength_list_i);
            g_string_append (printable, "[");
            g_string_append (printable, " strength = '");

            {
                gint8 tmp;

                if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%d", (gint)tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " radio_interface = '");

            {
                gint8 tmp;

                if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_NAS_RADIO_INTERFACE_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_nas_radio_interface_get_string ((QmiNasRadioInterface)tmp));
#elif defined  __QMI_NAS_RADIO_INTERFACE_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_nas_radio_interface_build_string_from_mask ((QmiNasRadioInterface)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiNasRadioInterface
#endif
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " ]");
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_get_signal_strength_output_signal_strength_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_SIGNAL_STRENGTH, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " strength = '");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%d", (gint)tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " radio_interface = '");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_RADIO_INTERFACE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_radio_interface_get_string ((QmiNasRadioInterface)tmp));
#elif defined  __QMI_NAS_RADIO_INTERFACE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_radio_interface_build_string_from_mask ((QmiNasRadioInterface)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRadioInterface
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_get_signal_strength_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_get_signal_strength_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_get_signal_strength_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_INPUT_TLV_REQUEST_MASK:
            tlv_type_str = "Request Mask";
            translated_value = qmi_message_nas_get_signal_strength_input_request_mask_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_LTE_RSRP:
            tlv_type_str = "LTE RSRP";
            translated_value = qmi_message_nas_get_signal_strength_output_lte_rsrp_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_LTE_SNR:
            tlv_type_str = "LTE SNR";
            translated_value = qmi_message_nas_get_signal_strength_output_lte_snr_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_RSRQ:
            tlv_type_str = "RSRQ";
            translated_value = qmi_message_nas_get_signal_strength_output_rsrq_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_ERROR_RATE_LIST:
            tlv_type_str = "Error Rate List";
            translated_value = qmi_message_nas_get_signal_strength_output_error_rate_list_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_SINR:
            tlv_type_str = "SINR";
            translated_value = qmi_message_nas_get_signal_strength_output_sinr_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_IO:
            tlv_type_str = "IO";
            translated_value = qmi_message_nas_get_signal_strength_output_io_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_ECIO_LIST:
            tlv_type_str = "ECIO List";
            translated_value = qmi_message_nas_get_signal_strength_output_ecio_list_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_RSSI_LIST:
            tlv_type_str = "RSSI List";
            translated_value = qmi_message_nas_get_signal_strength_output_rssi_list_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_STRENGTH_LIST:
            tlv_type_str = "Strength List";
            translated_value = qmi_message_nas_get_signal_strength_output_strength_list_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_SIGNAL_STRENGTH:
            tlv_type_str = "Signal Strength";
            translated_value = qmi_message_nas_get_signal_strength_output_signal_strength_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_get_signal_strength_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Get Signal Strength\" (0x0020)\n",
                            line_prefix);

    {
        struct message_get_signal_strength_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_get_signal_strength_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageNasGetSignalStrengthOutput *
qmi_message_nas_get_signal_strength_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageNasGetSignalStrengthOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH);

    self = g_slice_new0 (QmiMessageNasGetSignalStrengthOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_LTE_RSRP, NULL, NULL)) == 0) {
                goto qmi_message_nas_get_signal_strength_output_lte_rsrp_out;
            }
            if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_lte_rsrp), NULL))
                goto qmi_message_nas_get_signal_strength_output_lte_rsrp_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'LTE RSRP' TLV", offset);
            }

            self->arg_lte_rsrp_set = TRUE;

qmi_message_nas_get_signal_strength_output_lte_rsrp_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_LTE_SNR, NULL, NULL)) == 0) {
                goto qmi_message_nas_get_signal_strength_output_lte_snr_out;
            }
            if (!qmi_message_tlv_read_gint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_lte_snr), NULL))
                goto qmi_message_nas_get_signal_strength_output_lte_snr_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'LTE SNR' TLV", offset);
            }

            self->arg_lte_snr_set = TRUE;

qmi_message_nas_get_signal_strength_output_lte_snr_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_RSRQ, NULL, NULL)) == 0) {
                goto qmi_message_nas_get_signal_strength_output_rsrq_out;
            }
            if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &(self->arg_rsrq_rsrq), NULL))
                goto qmi_message_nas_get_signal_strength_output_rsrq_out;
            {
                gint8 tmp;

                if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_message_nas_get_signal_strength_output_rsrq_out;
                self->arg_rsrq_radio_interface = (QmiNasRadioInterface)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'RSRQ' TLV", offset);
            }

            self->arg_rsrq_set = TRUE;

qmi_message_nas_get_signal_strength_output_rsrq_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_ERROR_RATE_LIST, NULL, NULL)) == 0) {
                goto qmi_message_nas_get_signal_strength_output_error_rate_list_out;
            }
            {
                guint error_rate_list_i;
                guint16 error_rate_list_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(error_rate_list_n_items), NULL))
                    goto qmi_message_nas_get_signal_strength_output_error_rate_list_out;

                self->arg_error_rate_list = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (QmiMessageNasGetSignalStrengthOutputErrorRateListElement),
                    (guint)error_rate_list_n_items);

                for (error_rate_list_i = 0; error_rate_list_i < error_rate_list_n_items; error_rate_list_i++) {
                    QmiMessageNasGetSignalStrengthOutputErrorRateListElement error_rate_list_aux;

                    if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(error_rate_list_aux.rate), NULL))
                        goto qmi_message_nas_get_signal_strength_output_error_rate_list_out;
                    {
                        gint8 tmp;

                        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, NULL))
                            goto qmi_message_nas_get_signal_strength_output_error_rate_list_out;
                        error_rate_list_aux.radio_interface = (QmiNasRadioInterface)tmp;
                    }
                    g_array_insert_val (self->arg_error_rate_list, error_rate_list_i, error_rate_list_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Error Rate List' TLV", offset);
            }

            self->arg_error_rate_list_set = TRUE;

qmi_message_nas_get_signal_strength_output_error_rate_list_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_SINR, NULL, NULL)) == 0) {
                goto qmi_message_nas_get_signal_strength_output_sinr_out;
            }
            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                    goto qmi_message_nas_get_signal_strength_output_sinr_out;
                self->arg_sinr = (QmiNasEvdoSinrLevel)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'SINR' TLV", offset);
            }

            self->arg_sinr_set = TRUE;

qmi_message_nas_get_signal_strength_output_sinr_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_IO, NULL, NULL)) == 0) {
                goto qmi_message_nas_get_signal_strength_output_io_out;
            }
            if (!qmi_message_tlv_read_gint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_io), NULL))
                goto qmi_message_nas_get_signal_strength_output_io_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'IO' TLV", offset);
            }

            self->arg_io_set = TRUE;

qmi_message_nas_get_signal_strength_output_io_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_ECIO_LIST, NULL, NULL)) == 0) {
                goto qmi_message_nas_get_signal_strength_output_ecio_list_out;
            }
            {
                guint ecio_list_i;
                guint16 ecio_list_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(ecio_list_n_items), NULL))
                    goto qmi_message_nas_get_signal_strength_output_ecio_list_out;

                self->arg_ecio_list = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (QmiMessageNasGetSignalStrengthOutputEcioListElement),
                    (guint)ecio_list_n_items);

                for (ecio_list_i = 0; ecio_list_i < ecio_list_n_items; ecio_list_i++) {
                    QmiMessageNasGetSignalStrengthOutputEcioListElement ecio_list_aux;

                    if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(ecio_list_aux.ecio), NULL))
                        goto qmi_message_nas_get_signal_strength_output_ecio_list_out;
                    {
                        gint8 tmp;

                        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, NULL))
                            goto qmi_message_nas_get_signal_strength_output_ecio_list_out;
                        ecio_list_aux.radio_interface = (QmiNasRadioInterface)tmp;
                    }
                    g_array_insert_val (self->arg_ecio_list, ecio_list_i, ecio_list_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'ECIO List' TLV", offset);
            }

            self->arg_ecio_list_set = TRUE;

qmi_message_nas_get_signal_strength_output_ecio_list_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_RSSI_LIST, NULL, NULL)) == 0) {
                goto qmi_message_nas_get_signal_strength_output_rssi_list_out;
            }
            {
                guint rssi_list_i;
                guint16 rssi_list_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(rssi_list_n_items), NULL))
                    goto qmi_message_nas_get_signal_strength_output_rssi_list_out;

                self->arg_rssi_list = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (QmiMessageNasGetSignalStrengthOutputRssiListElement),
                    (guint)rssi_list_n_items);

                for (rssi_list_i = 0; rssi_list_i < rssi_list_n_items; rssi_list_i++) {
                    QmiMessageNasGetSignalStrengthOutputRssiListElement rssi_list_aux;

                    if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &(rssi_list_aux.rssi), NULL))
                        goto qmi_message_nas_get_signal_strength_output_rssi_list_out;
                    {
                        gint8 tmp;

                        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, NULL))
                            goto qmi_message_nas_get_signal_strength_output_rssi_list_out;
                        rssi_list_aux.radio_interface = (QmiNasRadioInterface)tmp;
                    }
                    g_array_insert_val (self->arg_rssi_list, rssi_list_i, rssi_list_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'RSSI List' TLV", offset);
            }

            self->arg_rssi_list_set = TRUE;

qmi_message_nas_get_signal_strength_output_rssi_list_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_STRENGTH_LIST, NULL, NULL)) == 0) {
                goto qmi_message_nas_get_signal_strength_output_strength_list_out;
            }
            {
                guint strength_list_i;
                guint16 strength_list_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(strength_list_n_items), NULL))
                    goto qmi_message_nas_get_signal_strength_output_strength_list_out;

                self->arg_strength_list = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (QmiMessageNasGetSignalStrengthOutputStrengthListElement),
                    (guint)strength_list_n_items);

                for (strength_list_i = 0; strength_list_i < strength_list_n_items; strength_list_i++) {
                    QmiMessageNasGetSignalStrengthOutputStrengthListElement strength_list_aux;

                    if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &(strength_list_aux.strength), NULL))
                        goto qmi_message_nas_get_signal_strength_output_strength_list_out;
                    {
                        gint8 tmp;

                        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, NULL))
                            goto qmi_message_nas_get_signal_strength_output_strength_list_out;
                        strength_list_aux.radio_interface = (QmiNasRadioInterface)tmp;
                    }
                    g_array_insert_val (self->arg_strength_list, strength_list_i, strength_list_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Strength List' TLV", offset);
            }

            self->arg_strength_list_set = TRUE;

qmi_message_nas_get_signal_strength_output_strength_list_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_nas_get_signal_strength_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_nas_get_signal_strength_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    do {
        /* Prerequisite.... */
        if (!(self->arg_result_error_status == QMI_STATUS_SUCCESS))
            break;

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_GET_SIGNAL_STRENGTH_OUTPUT_TLV_SIGNAL_STRENGTH, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Signal Strength TLV: ");
                qmi_message_nas_get_signal_strength_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &(self->arg_signal_strength_strength), error))
                goto qmi_message_nas_get_signal_strength_output_signal_strength_out;
            {
                gint8 tmp;

                if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, error))
                    goto qmi_message_nas_get_signal_strength_output_signal_strength_out;
                self->arg_signal_strength_radio_interface = (QmiNasRadioInterface)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Signal Strength' TLV", offset);
            }

            self->arg_signal_strength_set = TRUE;

qmi_message_nas_get_signal_strength_output_signal_strength_out:
            if (!self->arg_signal_strength_set) {
                qmi_message_nas_get_signal_strength_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message NAS Network Scan */


/* --- Input -- */

struct _QmiMessageNasNetworkScanInput {
    volatile gint ref_count;

    /* Network Type */
    gboolean arg_network_type_set;
    guint8 arg_network_type;
};

#define QMI_MESSAGE_NAS_NETWORK_SCAN_INPUT_TLV_NETWORK_TYPE 0x10

gboolean
qmi_message_nas_network_scan_input_get_network_type (
    QmiMessageNasNetworkScanInput *self,
    QmiNasNetworkScanType *value_network_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_network_type_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Network Type' was not found in the message");
        return FALSE;
    }

    if (value_network_type)
        *value_network_type = (QmiNasNetworkScanType)(self->arg_network_type);

    return TRUE;
}

gboolean
qmi_message_nas_network_scan_input_set_network_type (
    QmiMessageNasNetworkScanInput *self,
    QmiNasNetworkScanType value_network_type,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_network_type = (guint8)(value_network_type);
    self->arg_network_type_set = TRUE;

    return TRUE;
}

GType
qmi_message_nas_network_scan_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageNasNetworkScanInput"),
                                          (GBoxedCopyFunc) qmi_message_nas_network_scan_input_ref,
                                          (GBoxedFreeFunc) qmi_message_nas_network_scan_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageNasNetworkScanInput *
qmi_message_nas_network_scan_input_ref (QmiMessageNasNetworkScanInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_nas_network_scan_input_unref (QmiMessageNasNetworkScanInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageNasNetworkScanInput, self);
    }
}

QmiMessageNasNetworkScanInput *
qmi_message_nas_network_scan_input_new (void)
{
    QmiMessageNasNetworkScanInput *self;

    self = g_slice_new0 (QmiMessageNasNetworkScanInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_nas_network_scan_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageNasNetworkScanInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_NAS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_NAS_NETWORK_SCAN);

    /* All TLVs are optional, we allow NULL input */
    if (!input)
        return g_steal_pointer (&self);

    /* Try to add the 'Network Type' TLV */
    if (input->arg_network_type_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_NETWORK_SCAN_INPUT_TLV_NETWORK_TYPE, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Network Type': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_network_type;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Network Type': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Network Type': ");
            return NULL;
        }
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

static void
__qmi_message_nas_network_scan_output_mnc_pcs_digit_include_status_element_free (QmiMessageNasNetworkScanOutputMncPcsDigitIncludeStatusElement *value)
{
    g_slice_free (QmiMessageNasNetworkScanOutputMncPcsDigitIncludeStatusElement, value);
}

static QmiMessageNasNetworkScanOutputMncPcsDigitIncludeStatusElement *
__qmi_message_nas_network_scan_output_mnc_pcs_digit_include_status_element_new (void)
{
    return g_slice_new0 (QmiMessageNasNetworkScanOutputMncPcsDigitIncludeStatusElement);
}

static QmiMessageNasNetworkScanOutputMncPcsDigitIncludeStatusElement *
__qmi_message_nas_network_scan_output_mnc_pcs_digit_include_status_element_copy (const QmiMessageNasNetworkScanOutputMncPcsDigitIncludeStatusElement *value)
{
    QmiMessageNasNetworkScanOutputMncPcsDigitIncludeStatusElement *copy;

    copy = __qmi_message_nas_network_scan_output_mnc_pcs_digit_include_status_element_new ();
    copy->mcc = value->mcc;
    copy->mnc = value->mnc;
    copy->includes_pcs_digit = value->includes_pcs_digit;
    return copy;
}

G_DEFINE_BOXED_TYPE (QmiMessageNasNetworkScanOutputMncPcsDigitIncludeStatusElement, qmi_message_nas_network_scan_output_mnc_pcs_digit_include_status_element, (GBoxedCopyFunc)__qmi_message_nas_network_scan_output_mnc_pcs_digit_include_status_element_copy, (GBoxedFreeFunc)__qmi_message_nas_network_scan_output_mnc_pcs_digit_include_status_element_free)

static void
__qmi_message_nas_network_scan_output_radio_access_technology_element_free (QmiMessageNasNetworkScanOutputRadioAccessTechnologyElement *value)
{
    g_slice_free (QmiMessageNasNetworkScanOutputRadioAccessTechnologyElement, value);
}

static QmiMessageNasNetworkScanOutputRadioAccessTechnologyElement *
__qmi_message_nas_network_scan_output_radio_access_technology_element_new (void)
{
    return g_slice_new0 (QmiMessageNasNetworkScanOutputRadioAccessTechnologyElement);
}

static QmiMessageNasNetworkScanOutputRadioAccessTechnologyElement *
__qmi_message_nas_network_scan_output_radio_access_technology_element_copy (const QmiMessageNasNetworkScanOutputRadioAccessTechnologyElement *value)
{
    QmiMessageNasNetworkScanOutputRadioAccessTechnologyElement *copy;

    copy = __qmi_message_nas_network_scan_output_radio_access_technology_element_new ();
    copy->mcc = value->mcc;
    copy->mnc = value->mnc;
    copy->radio_interface = value->radio_interface;
    return copy;
}

G_DEFINE_BOXED_TYPE (QmiMessageNasNetworkScanOutputRadioAccessTechnologyElement, qmi_message_nas_network_scan_output_radio_access_technology_element, (GBoxedCopyFunc)__qmi_message_nas_network_scan_output_radio_access_technology_element_copy, (GBoxedFreeFunc)__qmi_message_nas_network_scan_output_radio_access_technology_element_free)

static void
__qmi_message_nas_network_scan_output_network_information_element_clear (QmiMessageNasNetworkScanOutputNetworkInformationElement *value)
{
    g_clear_pointer (&value->description, (GDestroyNotify)g_free);
}

static void
__qmi_message_nas_network_scan_output_network_information_element_free (QmiMessageNasNetworkScanOutputNetworkInformationElement *value)
{
    __qmi_message_nas_network_scan_output_network_information_element_clear (value);
    g_slice_free (QmiMessageNasNetworkScanOutputNetworkInformationElement, value);
}

static QmiMessageNasNetworkScanOutputNetworkInformationElement *
__qmi_message_nas_network_scan_output_network_information_element_new (void)
{
    return g_slice_new0 (QmiMessageNasNetworkScanOutputNetworkInformationElement);
}

static QmiMessageNasNetworkScanOutputNetworkInformationElement *
__qmi_message_nas_network_scan_output_network_information_element_copy (const QmiMessageNasNetworkScanOutputNetworkInformationElement *value)
{
    QmiMessageNasNetworkScanOutputNetworkInformationElement *copy;

    copy = __qmi_message_nas_network_scan_output_network_information_element_new ();
    copy->mcc = value->mcc;
    copy->mnc = value->mnc;
    copy->network_status = value->network_status;
    copy->description = g_strdup (value->description);
    return copy;
}

G_DEFINE_BOXED_TYPE (QmiMessageNasNetworkScanOutputNetworkInformationElement, qmi_message_nas_network_scan_output_network_information_element, (GBoxedCopyFunc)__qmi_message_nas_network_scan_output_network_information_element_copy, (GBoxedFreeFunc)__qmi_message_nas_network_scan_output_network_information_element_free)

struct _QmiMessageNasNetworkScanOutput {
    volatile gint ref_count;

    /* Network Scan Result */
    gboolean arg_network_scan_result_set;
    guint32 arg_network_scan_result;

    /* MNC PCS Digit Include Status */
    gboolean arg_mnc_pcs_digit_include_status_set;
    GArray *arg_mnc_pcs_digit_include_status;
    GPtrArray *arg_mnc_pcs_digit_include_status_ptr;

    /* Radio Access Technology */
    gboolean arg_radio_access_technology_set;
    GArray *arg_radio_access_technology;
    GPtrArray *arg_radio_access_technology_ptr;

    /* Network Information */
    gboolean arg_network_information_set;
    GArray *arg_network_information;
    GPtrArray *arg_network_information_ptr;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_NAS_NETWORK_SCAN_OUTPUT_TLV_NETWORK_SCAN_RESULT 0x13
#define QMI_MESSAGE_NAS_NETWORK_SCAN_OUTPUT_TLV_MNC_PCS_DIGIT_INCLUDE_STATUS 0x12
#define QMI_MESSAGE_NAS_NETWORK_SCAN_OUTPUT_TLV_RADIO_ACCESS_TECHNOLOGY 0x11
#define QMI_MESSAGE_NAS_NETWORK_SCAN_OUTPUT_TLV_NETWORK_INFORMATION 0x10
#define QMI_MESSAGE_NAS_NETWORK_SCAN_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_nas_network_scan_output_get_network_scan_result (
    QmiMessageNasNetworkScanOutput *self,
    QmiNasNetworkScanResult *value_network_scan_result,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_network_scan_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Network Scan Result' was not found in the message");
        return FALSE;
    }

    if (value_network_scan_result)
        *value_network_scan_result = (QmiNasNetworkScanResult)(self->arg_network_scan_result);

    return TRUE;
}

gboolean
qmi_message_nas_network_scan_output_get_mnc_pcs_digit_include_status (
    QmiMessageNasNetworkScanOutput *self,
    GArray **value_mnc_pcs_digit_include_status,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_mnc_pcs_digit_include_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'MNC PCS Digit Include Status' was not found in the message");
        return FALSE;
    }

    if (value_mnc_pcs_digit_include_status)
        *value_mnc_pcs_digit_include_status = self->arg_mnc_pcs_digit_include_status;

    return TRUE;
}

gboolean
qmi_message_nas_network_scan_output_get_mnc_pcs_digit_include_status_gir (
    QmiMessageNasNetworkScanOutput *self,
    GPtrArray **value_mnc_pcs_digit_include_status_ptr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_mnc_pcs_digit_include_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'MNC PCS Digit Include Status' was not found in the message");
        return FALSE;
    }

    if (value_mnc_pcs_digit_include_status_ptr) {
        if (!self->arg_mnc_pcs_digit_include_status_ptr) {
            {
                guint mnc_pcs_digit_include_status_i;

                self->arg_mnc_pcs_digit_include_status_ptr = g_ptr_array_new_full (self->arg_mnc_pcs_digit_include_status->len, (GDestroyNotify)__qmi_message_nas_network_scan_output_mnc_pcs_digit_include_status_element_free);
                for (mnc_pcs_digit_include_status_i = 0; mnc_pcs_digit_include_status_i < self->arg_mnc_pcs_digit_include_status->len; mnc_pcs_digit_include_status_i++) {
                    QmiMessageNasNetworkScanOutputMncPcsDigitIncludeStatusElement *mnc_pcs_digit_include_status_aux_from;
                    QmiMessageNasNetworkScanOutputMncPcsDigitIncludeStatusElement *mnc_pcs_digit_include_status_aux_to;

                    mnc_pcs_digit_include_status_aux_from = &g_array_index (self->arg_mnc_pcs_digit_include_status, QmiMessageNasNetworkScanOutputMncPcsDigitIncludeStatusElement, mnc_pcs_digit_include_status_i);

                    mnc_pcs_digit_include_status_aux_to = __qmi_message_nas_network_scan_output_mnc_pcs_digit_include_status_element_new ();
                    mnc_pcs_digit_include_status_aux_to->mcc = (*mnc_pcs_digit_include_status_aux_from).mcc;
                    mnc_pcs_digit_include_status_aux_to->mnc = (*mnc_pcs_digit_include_status_aux_from).mnc;
                    mnc_pcs_digit_include_status_aux_to->includes_pcs_digit = (*mnc_pcs_digit_include_status_aux_from).includes_pcs_digit;

                    g_ptr_array_add (self->arg_mnc_pcs_digit_include_status_ptr, mnc_pcs_digit_include_status_aux_to);
                }
            }
        }
        *value_mnc_pcs_digit_include_status_ptr = self->arg_mnc_pcs_digit_include_status_ptr;
    }
    return TRUE;
}

gboolean
qmi_message_nas_network_scan_output_get_radio_access_technology (
    QmiMessageNasNetworkScanOutput *self,
    GArray **value_radio_access_technology,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_radio_access_technology_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Radio Access Technology' was not found in the message");
        return FALSE;
    }

    if (value_radio_access_technology)
        *value_radio_access_technology = self->arg_radio_access_technology;

    return TRUE;
}

gboolean
qmi_message_nas_network_scan_output_get_radio_access_technology_gir (
    QmiMessageNasNetworkScanOutput *self,
    GPtrArray **value_radio_access_technology_ptr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_radio_access_technology_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Radio Access Technology' was not found in the message");
        return FALSE;
    }

    if (value_radio_access_technology_ptr) {
        if (!self->arg_radio_access_technology_ptr) {
            {
                guint radio_access_technology_i;

                self->arg_radio_access_technology_ptr = g_ptr_array_new_full (self->arg_radio_access_technology->len, (GDestroyNotify)__qmi_message_nas_network_scan_output_radio_access_technology_element_free);
                for (radio_access_technology_i = 0; radio_access_technology_i < self->arg_radio_access_technology->len; radio_access_technology_i++) {
                    QmiMessageNasNetworkScanOutputRadioAccessTechnologyElement *radio_access_technology_aux_from;
                    QmiMessageNasNetworkScanOutputRadioAccessTechnologyElement *radio_access_technology_aux_to;

                    radio_access_technology_aux_from = &g_array_index (self->arg_radio_access_technology, QmiMessageNasNetworkScanOutputRadioAccessTechnologyElement, radio_access_technology_i);

                    radio_access_technology_aux_to = __qmi_message_nas_network_scan_output_radio_access_technology_element_new ();
                    radio_access_technology_aux_to->mcc = (*radio_access_technology_aux_from).mcc;
                    radio_access_technology_aux_to->mnc = (*radio_access_technology_aux_from).mnc;
                    radio_access_technology_aux_to->radio_interface = (*radio_access_technology_aux_from).radio_interface;

                    g_ptr_array_add (self->arg_radio_access_technology_ptr, radio_access_technology_aux_to);
                }
            }
        }
        *value_radio_access_technology_ptr = self->arg_radio_access_technology_ptr;
    }
    return TRUE;
}

gboolean
qmi_message_nas_network_scan_output_get_network_information (
    QmiMessageNasNetworkScanOutput *self,
    GArray **value_network_information,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_network_information_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Network Information' was not found in the message");
        return FALSE;
    }

    if (value_network_information)
        *value_network_information = self->arg_network_information;

    return TRUE;
}

gboolean
qmi_message_nas_network_scan_output_get_network_information_gir (
    QmiMessageNasNetworkScanOutput *self,
    GPtrArray **value_network_information_ptr,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_network_information_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Network Information' was not found in the message");
        return FALSE;
    }

    if (value_network_information_ptr) {
        if (!self->arg_network_information_ptr) {
            {
                guint network_information_i;

                self->arg_network_information_ptr = g_ptr_array_new_full (self->arg_network_information->len, (GDestroyNotify)__qmi_message_nas_network_scan_output_network_information_element_free);
                for (network_information_i = 0; network_information_i < self->arg_network_information->len; network_information_i++) {
                    QmiMessageNasNetworkScanOutputNetworkInformationElement *network_information_aux_from;
                    QmiMessageNasNetworkScanOutputNetworkInformationElement *network_information_aux_to;

                    network_information_aux_from = &g_array_index (self->arg_network_information, QmiMessageNasNetworkScanOutputNetworkInformationElement, network_information_i);

                    network_information_aux_to = __qmi_message_nas_network_scan_output_network_information_element_new ();
                    network_information_aux_to->mcc = (*network_information_aux_from).mcc;
                    network_information_aux_to->mnc = (*network_information_aux_from).mnc;
                    network_information_aux_to->network_status = (*network_information_aux_from).network_status;
                    network_information_aux_to->description = g_strdup ((*network_information_aux_from).description);

                    g_ptr_array_add (self->arg_network_information_ptr, network_information_aux_to);
                }
            }
        }
        *value_network_information_ptr = self->arg_network_information_ptr;
    }
    return TRUE;
}

gboolean
qmi_message_nas_network_scan_output_get_result (
    QmiMessageNasNetworkScanOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_nas_network_scan_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageNasNetworkScanOutput"),
                                          (GBoxedCopyFunc) qmi_message_nas_network_scan_output_ref,
                                          (GBoxedFreeFunc) qmi_message_nas_network_scan_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageNasNetworkScanOutput *
qmi_message_nas_network_scan_output_ref (QmiMessageNasNetworkScanOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_nas_network_scan_output_unref (QmiMessageNasNetworkScanOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_clear_pointer (&self->arg_mnc_pcs_digit_include_status, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_mnc_pcs_digit_include_status, (GDestroyNotify)g_ptr_array_unref);
        g_clear_pointer (&self->arg_radio_access_technology, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_radio_access_technology, (GDestroyNotify)g_ptr_array_unref);
        g_clear_pointer (&self->arg_network_information, (GDestroyNotify)g_array_unref);
        g_clear_pointer (&self->arg_network_information, (GDestroyNotify)g_ptr_array_unref);
        g_slice_free (QmiMessageNasNetworkScanOutput, self);
    }
}

static gchar *
qmi_message_nas_network_scan_input_network_type_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_NETWORK_SCAN_INPUT_TLV_NETWORK_TYPE, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SCAN_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_scan_type_get_string ((QmiNasNetworkScanType)tmp));
#elif defined  __QMI_NAS_NETWORK_SCAN_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_scan_type_build_string_from_mask ((QmiNasNetworkScanType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkScanType
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_network_scan_output_network_scan_result_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_NETWORK_SCAN_OUTPUT_TLV_NETWORK_SCAN_RESULT, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint32 tmp;

        if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_SCAN_RESULT_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_scan_result_get_string ((QmiNasNetworkScanResult)tmp));
#elif defined  __QMI_NAS_NETWORK_SCAN_RESULT_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_scan_result_build_string_from_mask ((QmiNasNetworkScanResult)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkScanResult
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_network_scan_output_mnc_pcs_digit_include_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_NETWORK_SCAN_OUTPUT_TLV_MNC_PCS_DIGIT_INCLUDE_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint mnc_pcs_digit_include_status_i;
        guint16 mnc_pcs_digit_include_status_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(mnc_pcs_digit_include_status_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (mnc_pcs_digit_include_status_i = 0; mnc_pcs_digit_include_status_i < mnc_pcs_digit_include_status_n_items; mnc_pcs_digit_include_status_i++) {
            g_string_append_printf (printable, " [%u] = '", mnc_pcs_digit_include_status_i);
            g_string_append (printable, "[");
            g_string_append (printable, " mcc = '");

            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " mnc = '");

            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " includes_pcs_digit = '");

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " ]");
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_network_scan_output_radio_access_technology_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_NETWORK_SCAN_OUTPUT_TLV_RADIO_ACCESS_TECHNOLOGY, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint radio_access_technology_i;
        guint16 radio_access_technology_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(radio_access_technology_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (radio_access_technology_i = 0; radio_access_technology_i < radio_access_technology_n_items; radio_access_technology_i++) {
            g_string_append_printf (printable, " [%u] = '", radio_access_technology_i);
            g_string_append (printable, "[");
            g_string_append (printable, " mcc = '");

            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " mnc = '");

            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " radio_interface = '");

            {
                gint8 tmp;

                if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_NAS_RADIO_INTERFACE_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_nas_radio_interface_get_string ((QmiNasRadioInterface)tmp));
#elif defined  __QMI_NAS_RADIO_INTERFACE_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_nas_radio_interface_build_string_from_mask ((QmiNasRadioInterface)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiNasRadioInterface
#endif
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " ]");
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_network_scan_output_network_information_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_NETWORK_SCAN_OUTPUT_TLV_NETWORK_INFORMATION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    {
        guint network_information_i;
        guint16 network_information_n_items;

        /* Read number of items in the array */
        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(network_information_n_items), &error))
            goto out;

        g_string_append (printable, "{");

        for (network_information_i = 0; network_information_i < network_information_n_items; network_information_i++) {
            g_string_append_printf (printable, " [%u] = '", network_information_i);
            g_string_append (printable, "[");
            g_string_append (printable, " mcc = '");

            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " mnc = '");

            {
                guint16 tmp;

                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
                    goto out;
                {
                    g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " network_status = '");

            {
                guint8 tmp;

                if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
                    goto out;
                {
#if defined  __QMI_NAS_NETWORK_STATUS_IS_ENUM__
                    g_string_append_printf (printable, "%s", qmi_nas_network_status_get_string ((QmiNasNetworkStatus)tmp));
#elif defined  __QMI_NAS_NETWORK_STATUS_IS_FLAGS__
                    {
                        g_autofree gchar *flags_str = NULL;

                        flags_str = qmi_nas_network_status_build_string_from_mask ((QmiNasNetworkStatus)tmp);
                        g_string_append_printf (printable, "%s", flags_str);
                    }
#else
# error unexpected public format: QmiNasNetworkStatus
#endif
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " description = '");

            {
                g_autofree gchar *tmp = NULL;

                if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &tmp, &error))
                    goto out;
                {
                    g_string_append (printable, tmp);
                }
            }
            g_string_append (printable, "'");
            g_string_append (printable, " ]");
            g_string_append (printable, " '");
        }

        g_string_append (printable, "}");
    }
    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_network_scan_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_network_scan_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_network_scan_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_NAS_NETWORK_SCAN_INPUT_TLV_NETWORK_TYPE:
            tlv_type_str = "Network Type";
            translated_value = qmi_message_nas_network_scan_input_network_type_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_NAS_NETWORK_SCAN_OUTPUT_TLV_NETWORK_SCAN_RESULT:
            tlv_type_str = "Network Scan Result";
            translated_value = qmi_message_nas_network_scan_output_network_scan_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_NETWORK_SCAN_OUTPUT_TLV_MNC_PCS_DIGIT_INCLUDE_STATUS:
            tlv_type_str = "MNC PCS Digit Include Status";
            translated_value = qmi_message_nas_network_scan_output_mnc_pcs_digit_include_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_NETWORK_SCAN_OUTPUT_TLV_RADIO_ACCESS_TECHNOLOGY:
            tlv_type_str = "Radio Access Technology";
            translated_value = qmi_message_nas_network_scan_output_radio_access_technology_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_NETWORK_SCAN_OUTPUT_TLV_NETWORK_INFORMATION:
            tlv_type_str = "Network Information";
            translated_value = qmi_message_nas_network_scan_output_network_information_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_NETWORK_SCAN_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_network_scan_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Network Scan\" (0x0021)\n",
                            line_prefix);

    {
        struct message_network_scan_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_network_scan_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageNasNetworkScanOutput *
qmi_message_nas_network_scan_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageNasNetworkScanOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_NAS_NETWORK_SCAN);

    self = g_slice_new0 (QmiMessageNasNetworkScanOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_NETWORK_SCAN_OUTPUT_TLV_NETWORK_SCAN_RESULT, NULL, NULL)) == 0) {
                goto qmi_message_nas_network_scan_output_network_scan_result_out;
            }
            {
                guint32 tmp;

                if (!qmi_message_tlv_read_guint32 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, NULL))
                    goto qmi_message_nas_network_scan_output_network_scan_result_out;
                self->arg_network_scan_result = (QmiNasNetworkScanResult)tmp;
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Network Scan Result' TLV", offset);
            }

            self->arg_network_scan_result_set = TRUE;

qmi_message_nas_network_scan_output_network_scan_result_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_NETWORK_SCAN_OUTPUT_TLV_MNC_PCS_DIGIT_INCLUDE_STATUS, NULL, NULL)) == 0) {
                goto qmi_message_nas_network_scan_output_mnc_pcs_digit_include_status_out;
            }
            {
                guint mnc_pcs_digit_include_status_i;
                guint16 mnc_pcs_digit_include_status_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(mnc_pcs_digit_include_status_n_items), NULL))
                    goto qmi_message_nas_network_scan_output_mnc_pcs_digit_include_status_out;

                self->arg_mnc_pcs_digit_include_status = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (QmiMessageNasNetworkScanOutputMncPcsDigitIncludeStatusElement),
                    (guint)mnc_pcs_digit_include_status_n_items);

                for (mnc_pcs_digit_include_status_i = 0; mnc_pcs_digit_include_status_i < mnc_pcs_digit_include_status_n_items; mnc_pcs_digit_include_status_i++) {
                    QmiMessageNasNetworkScanOutputMncPcsDigitIncludeStatusElement mnc_pcs_digit_include_status_aux;

                    if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(mnc_pcs_digit_include_status_aux.mcc), NULL))
                        goto qmi_message_nas_network_scan_output_mnc_pcs_digit_include_status_out;
                    if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(mnc_pcs_digit_include_status_aux.mnc), NULL))
                        goto qmi_message_nas_network_scan_output_mnc_pcs_digit_include_status_out;
                    {
                        guint8 tmp;

                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                            goto qmi_message_nas_network_scan_output_mnc_pcs_digit_include_status_out;
                        mnc_pcs_digit_include_status_aux.includes_pcs_digit = (gboolean)tmp;
                    }
                    g_array_insert_val (self->arg_mnc_pcs_digit_include_status, mnc_pcs_digit_include_status_i, mnc_pcs_digit_include_status_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'MNC PCS Digit Include Status' TLV", offset);
            }

            self->arg_mnc_pcs_digit_include_status_set = TRUE;

qmi_message_nas_network_scan_output_mnc_pcs_digit_include_status_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_NETWORK_SCAN_OUTPUT_TLV_RADIO_ACCESS_TECHNOLOGY, NULL, NULL)) == 0) {
                goto qmi_message_nas_network_scan_output_radio_access_technology_out;
            }
            {
                guint radio_access_technology_i;
                guint16 radio_access_technology_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(radio_access_technology_n_items), NULL))
                    goto qmi_message_nas_network_scan_output_radio_access_technology_out;

                self->arg_radio_access_technology = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (QmiMessageNasNetworkScanOutputRadioAccessTechnologyElement),
                    (guint)radio_access_technology_n_items);

                for (radio_access_technology_i = 0; radio_access_technology_i < radio_access_technology_n_items; radio_access_technology_i++) {
                    QmiMessageNasNetworkScanOutputRadioAccessTechnologyElement radio_access_technology_aux;

                    if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(radio_access_technology_aux.mcc), NULL))
                        goto qmi_message_nas_network_scan_output_radio_access_technology_out;
                    if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(radio_access_technology_aux.mnc), NULL))
                        goto qmi_message_nas_network_scan_output_radio_access_technology_out;
                    {
                        gint8 tmp;

                        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, NULL))
                            goto qmi_message_nas_network_scan_output_radio_access_technology_out;
                        radio_access_technology_aux.radio_interface = (QmiNasRadioInterface)tmp;
                    }
                    g_array_insert_val (self->arg_radio_access_technology, radio_access_technology_i, radio_access_technology_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Radio Access Technology' TLV", offset);
            }

            self->arg_radio_access_technology_set = TRUE;

qmi_message_nas_network_scan_output_radio_access_technology_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_NETWORK_SCAN_OUTPUT_TLV_NETWORK_INFORMATION, NULL, NULL)) == 0) {
                goto qmi_message_nas_network_scan_output_network_information_out;
            }
            {
                guint network_information_i;
                guint16 network_information_n_items;

                /* Read number of items in the array */
                if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(network_information_n_items), NULL))
                    goto qmi_message_nas_network_scan_output_network_information_out;

                self->arg_network_information = g_array_sized_new (
                    FALSE,
                    FALSE,
                    sizeof (QmiMessageNasNetworkScanOutputNetworkInformationElement),
                    (guint)network_information_n_items);

                g_array_set_clear_func (self->arg_network_information, (GDestroyNotify)__qmi_message_nas_network_scan_output_network_information_element_clear);

                for (network_information_i = 0; network_information_i < network_information_n_items; network_information_i++) {
                    QmiMessageNasNetworkScanOutputNetworkInformationElement network_information_aux;

                    if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(network_information_aux.mcc), NULL))
                        goto qmi_message_nas_network_scan_output_network_information_out;
                    if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(network_information_aux.mnc), NULL))
                        goto qmi_message_nas_network_scan_output_network_information_out;
                    {
                        guint8 tmp;

                        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, NULL))
                            goto qmi_message_nas_network_scan_output_network_information_out;
                        network_information_aux.network_status = (QmiNasNetworkStatus)tmp;
                    }
                    if (!qmi_message_tlv_read_string (message, init_offset, &offset, 1, 0, &(network_information_aux.description), NULL))
                        goto qmi_message_nas_network_scan_output_network_information_out;
                    g_array_insert_val (self->arg_network_information, network_information_i, network_information_aux);
                }
            }

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Network Information' TLV", offset);
            }

            self->arg_network_information_set = TRUE;

qmi_message_nas_network_scan_output_network_information_out:
            ;

        }
    } while (0);

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_NETWORK_SCAN_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_nas_network_scan_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_nas_network_scan_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message NAS Initiate Network Register */


/* --- Input -- */

struct _QmiMessageNasInitiateNetworkRegisterInput {
    volatile gint ref_count;

    /* MNC PCS Digit Include Status */
    gboolean arg_mnc_pcs_digit_include_status_set;
    guint8 arg_mnc_pcs_digit_include_status;

    /* Change Duration */
    gboolean arg_change_duration_set;
    guint8 arg_change_duration;

    /* Manual Registration Info 3GPP */
    gboolean arg_manual_registration_info_3gpp_set;
    guint16 arg_manual_registration_info_3gpp_mcc;
    guint16 arg_manual_registration_info_3gpp_mnc;
    gint8 arg_manual_registration_info_3gpp_radio_interface;

    /* Action */
    gboolean arg_action_set;
    guint8 arg_action;
};

#define QMI_MESSAGE_NAS_INITIATE_NETWORK_REGISTER_INPUT_TLV_MNC_PCS_DIGIT_INCLUDE_STATUS 0x12
#define QMI_MESSAGE_NAS_INITIATE_NETWORK_REGISTER_INPUT_TLV_CHANGE_DURATION 0x11
#define QMI_MESSAGE_NAS_INITIATE_NETWORK_REGISTER_INPUT_TLV_MANUAL_REGISTRATION_INFO_3GPP 0x10
#define QMI_MESSAGE_NAS_INITIATE_NETWORK_REGISTER_INPUT_TLV_ACTION 0x01

gboolean
qmi_message_nas_initiate_network_register_input_get_mnc_pcs_digit_include_status (
    QmiMessageNasInitiateNetworkRegisterInput *self,
    gboolean *value_mnc_pcs_digit_include_status,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_mnc_pcs_digit_include_status_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'MNC PCS Digit Include Status' was not found in the message");
        return FALSE;
    }

    if (value_mnc_pcs_digit_include_status)
        *value_mnc_pcs_digit_include_status = (gboolean)(self->arg_mnc_pcs_digit_include_status);

    return TRUE;
}

gboolean
qmi_message_nas_initiate_network_register_input_set_mnc_pcs_digit_include_status (
    QmiMessageNasInitiateNetworkRegisterInput *self,
    gboolean value_mnc_pcs_digit_include_status,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_mnc_pcs_digit_include_status = (guint8)(value_mnc_pcs_digit_include_status);
    self->arg_mnc_pcs_digit_include_status_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_initiate_network_register_input_get_change_duration (
    QmiMessageNasInitiateNetworkRegisterInput *self,
    QmiNasChangeDuration *value_change_duration,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_change_duration_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Change Duration' was not found in the message");
        return FALSE;
    }

    if (value_change_duration)
        *value_change_duration = (QmiNasChangeDuration)(self->arg_change_duration);

    return TRUE;
}

gboolean
qmi_message_nas_initiate_network_register_input_set_change_duration (
    QmiMessageNasInitiateNetworkRegisterInput *self,
    QmiNasChangeDuration value_change_duration,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_change_duration = (guint8)(value_change_duration);
    self->arg_change_duration_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_initiate_network_register_input_get_manual_registration_info_3gpp (
    QmiMessageNasInitiateNetworkRegisterInput *self,
    guint16 *value_manual_registration_info_3gpp_mcc,
    guint16 *value_manual_registration_info_3gpp_mnc,
    QmiNasRadioInterface *value_manual_registration_info_3gpp_radio_interface,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_manual_registration_info_3gpp_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Manual Registration Info 3GPP' was not found in the message");
        return FALSE;
    }

    if (value_manual_registration_info_3gpp_mcc)
        *value_manual_registration_info_3gpp_mcc = self->arg_manual_registration_info_3gpp_mcc;
    if (value_manual_registration_info_3gpp_mnc)
        *value_manual_registration_info_3gpp_mnc = self->arg_manual_registration_info_3gpp_mnc;
    if (value_manual_registration_info_3gpp_radio_interface)
        *value_manual_registration_info_3gpp_radio_interface = (QmiNasRadioInterface)(self->arg_manual_registration_info_3gpp_radio_interface);

    return TRUE;
}

gboolean
qmi_message_nas_initiate_network_register_input_set_manual_registration_info_3gpp (
    QmiMessageNasInitiateNetworkRegisterInput *self,
    guint16 value_manual_registration_info_3gpp_mcc,
    guint16 value_manual_registration_info_3gpp_mnc,
    QmiNasRadioInterface value_manual_registration_info_3gpp_radio_interface,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_manual_registration_info_3gpp_mcc = value_manual_registration_info_3gpp_mcc;
    self->arg_manual_registration_info_3gpp_mnc = value_manual_registration_info_3gpp_mnc;
    self->arg_manual_registration_info_3gpp_radio_interface = (gint8)(value_manual_registration_info_3gpp_radio_interface);
    self->arg_manual_registration_info_3gpp_set = TRUE;

    return TRUE;
}

gboolean
qmi_message_nas_initiate_network_register_input_get_action (
    QmiMessageNasInitiateNetworkRegisterInput *self,
    QmiNasNetworkRegisterType *value_action,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_action_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Action' was not found in the message");
        return FALSE;
    }

    if (value_action)
        *value_action = (QmiNasNetworkRegisterType)(self->arg_action);

    return TRUE;
}

gboolean
qmi_message_nas_initiate_network_register_input_set_action (
    QmiMessageNasInitiateNetworkRegisterInput *self,
    QmiNasNetworkRegisterType value_action,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_action = (guint8)(value_action);
    self->arg_action_set = TRUE;

    return TRUE;
}

GType
qmi_message_nas_initiate_network_register_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageNasInitiateNetworkRegisterInput"),
                                          (GBoxedCopyFunc) qmi_message_nas_initiate_network_register_input_ref,
                                          (GBoxedFreeFunc) qmi_message_nas_initiate_network_register_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageNasInitiateNetworkRegisterInput *
qmi_message_nas_initiate_network_register_input_ref (QmiMessageNasInitiateNetworkRegisterInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_nas_initiate_network_register_input_unref (QmiMessageNasInitiateNetworkRegisterInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageNasInitiateNetworkRegisterInput, self);
    }
}

QmiMessageNasInitiateNetworkRegisterInput *
qmi_message_nas_initiate_network_register_input_new (void)
{
    QmiMessageNasInitiateNetworkRegisterInput *self;

    self = g_slice_new0 (QmiMessageNasInitiateNetworkRegisterInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_nas_initiate_network_register_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageNasInitiateNetworkRegisterInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_NAS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_NAS_INITIATE_NETWORK_REGISTER);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Initiate Network Register' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'MNC PCS Digit Include Status' TLV */
    if (input->arg_mnc_pcs_digit_include_status_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_INITIATE_NETWORK_REGISTER_INPUT_TLV_MNC_PCS_DIGIT_INCLUDE_STATUS, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'MNC PCS Digit Include Status': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_mnc_pcs_digit_include_status;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'MNC PCS Digit Include Status': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'MNC PCS Digit Include Status': ");
            return NULL;
        }
    }

    /* Try to add the 'Change Duration' TLV */
    if (input->arg_change_duration_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_INITIATE_NETWORK_REGISTER_INPUT_TLV_CHANGE_DURATION, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Change Duration': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_change_duration;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Change Duration': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Change Duration': ");
            return NULL;
        }
    }

    /* Try to add the 'Manual Registration Info 3GPP' TLV */
    if (input->arg_manual_registration_info_3gpp_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_INITIATE_NETWORK_REGISTER_INPUT_TLV_MANUAL_REGISTRATION_INFO_3GPP, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Manual Registration Info 3GPP': ");
            return NULL;
        }

        /* Write the guint16 variable to the buffer */
        if (!qmi_message_tlv_write_guint16 (self, QMI_ENDIAN_LITTLE, input->arg_manual_registration_info_3gpp_mcc, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Manual Registration Info 3GPP': ");
            return NULL;
        }
        /* Write the guint16 variable to the buffer */
        if (!qmi_message_tlv_write_guint16 (self, QMI_ENDIAN_LITTLE, input->arg_manual_registration_info_3gpp_mnc, error)) {
            g_prefix_error (error, "Cannot write integer in TLV 'Manual Registration Info 3GPP': ");
            return NULL;
        }
        {
            gint8 tmp;

            tmp = (gint8) input->arg_manual_registration_info_3gpp_radio_interface;
            /* Write the gint8 variable to the buffer */
            if (!qmi_message_tlv_write_gint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Manual Registration Info 3GPP': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Manual Registration Info 3GPP': ");
            return NULL;
        }
    }

    /* Try to add the 'Action' TLV */
    if (input->arg_action_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_INITIATE_NETWORK_REGISTER_INPUT_TLV_ACTION, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Action': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_action;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Action': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Action': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Action' in message 'Initiate Network Register'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageNasInitiateNetworkRegisterOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_NAS_INITIATE_NETWORK_REGISTER_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_nas_initiate_network_register_output_get_result (
    QmiMessageNasInitiateNetworkRegisterOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_nas_initiate_network_register_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageNasInitiateNetworkRegisterOutput"),
                                          (GBoxedCopyFunc) qmi_message_nas_initiate_network_register_output_ref,
                                          (GBoxedFreeFunc) qmi_message_nas_initiate_network_register_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageNasInitiateNetworkRegisterOutput *
qmi_message_nas_initiate_network_register_output_ref (QmiMessageNasInitiateNetworkRegisterOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_nas_initiate_network_register_output_unref (QmiMessageNasInitiateNetworkRegisterOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageNasInitiateNetworkRegisterOutput, self);
    }
}

static gchar *
qmi_message_nas_initiate_network_register_input_mnc_pcs_digit_include_status_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_INITIATE_NETWORK_REGISTER_INPUT_TLV_MNC_PCS_DIGIT_INCLUDE_STATUS, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%s", tmp ? "yes" : "no");
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_initiate_network_register_input_change_duration_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_INITIATE_NETWORK_REGISTER_INPUT_TLV_CHANGE_DURATION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_CHANGE_DURATION_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_change_duration_get_string ((QmiNasChangeDuration)tmp));
#elif defined  __QMI_NAS_CHANGE_DURATION_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_change_duration_build_string_from_mask ((QmiNasChangeDuration)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasChangeDuration
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_initiate_network_register_input_manual_registration_info_3gpp_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_INITIATE_NETWORK_REGISTER_INPUT_TLV_MANUAL_REGISTRATION_INFO_3GPP, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");
    g_string_append (printable, "[");
    g_string_append (printable, " mcc = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " mnc = '");

    {
        guint16 tmp;

        if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &tmp, &error))
            goto out;
        {
            g_string_append_printf (printable, "%" G_GUINT16_FORMAT "", tmp);
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " radio_interface = '");

    {
        gint8 tmp;

        if (!qmi_message_tlv_read_gint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_RADIO_INTERFACE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_radio_interface_get_string ((QmiNasRadioInterface)tmp));
#elif defined  __QMI_NAS_RADIO_INTERFACE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_radio_interface_build_string_from_mask ((QmiNasRadioInterface)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasRadioInterface
#endif
        }
    }
    g_string_append (printable, "'");
    g_string_append (printable, " ]");

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

static gchar *
qmi_message_nas_initiate_network_register_input_action_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_INITIATE_NETWORK_REGISTER_INPUT_TLV_ACTION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_NETWORK_REGISTER_TYPE_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_network_register_type_get_string ((QmiNasNetworkRegisterType)tmp));
#elif defined  __QMI_NAS_NETWORK_REGISTER_TYPE_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_network_register_type_build_string_from_mask ((QmiNasNetworkRegisterType)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasNetworkRegisterType
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_initiate_network_register_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_initiate_network_register_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_initiate_network_register_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_NAS_INITIATE_NETWORK_REGISTER_INPUT_TLV_MNC_PCS_DIGIT_INCLUDE_STATUS:
            tlv_type_str = "MNC PCS Digit Include Status";
            translated_value = qmi_message_nas_initiate_network_register_input_mnc_pcs_digit_include_status_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_INITIATE_NETWORK_REGISTER_INPUT_TLV_CHANGE_DURATION:
            tlv_type_str = "Change Duration";
            translated_value = qmi_message_nas_initiate_network_register_input_change_duration_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_INITIATE_NETWORK_REGISTER_INPUT_TLV_MANUAL_REGISTRATION_INFO_3GPP:
            tlv_type_str = "Manual Registration Info 3GPP";
            translated_value = qmi_message_nas_initiate_network_register_input_manual_registration_info_3gpp_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        case QMI_MESSAGE_NAS_INITIATE_NETWORK_REGISTER_INPUT_TLV_ACTION:
            tlv_type_str = "Action";
            translated_value = qmi_message_nas_initiate_network_register_input_action_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_NAS_INITIATE_NETWORK_REGISTER_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_initiate_network_register_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Initiate Network Register\" (0x0022)\n",
                            line_prefix);

    {
        struct message_initiate_network_register_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_initiate_network_register_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageNasInitiateNetworkRegisterOutput *
qmi_message_nas_initiate_network_register_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageNasInitiateNetworkRegisterOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_NAS_INITIATE_NETWORK_REGISTER);

    self = g_slice_new0 (QmiMessageNasInitiateNetworkRegisterOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_INITIATE_NETWORK_REGISTER_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_nas_initiate_network_register_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_nas_initiate_network_register_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message NAS Attach Detach */


/* --- Input -- */

struct _QmiMessageNasAttachDetachInput {
    volatile gint ref_count;

    /* Action */
    gboolean arg_action_set;
    guint8 arg_action;
};

#define QMI_MESSAGE_NAS_ATTACH_DETACH_INPUT_TLV_ACTION 0x10

gboolean
qmi_message_nas_attach_detach_input_get_action (
    QmiMessageNasAttachDetachInput *self,
    QmiNasPsAttachAction *value_action,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    if (!self->arg_action_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_TLV_NOT_FOUND,
                     "Field 'Action' was not found in the message");
        return FALSE;
    }

    if (value_action)
        *value_action = (QmiNasPsAttachAction)(self->arg_action);

    return TRUE;
}

gboolean
qmi_message_nas_attach_detach_input_set_action (
    QmiMessageNasAttachDetachInput *self,
    QmiNasPsAttachAction value_action,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    self->arg_action = (guint8)(value_action);
    self->arg_action_set = TRUE;

    return TRUE;
}

GType
qmi_message_nas_attach_detach_input_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageNasAttachDetachInput"),
                                          (GBoxedCopyFunc) qmi_message_nas_attach_detach_input_ref,
                                          (GBoxedFreeFunc) qmi_message_nas_attach_detach_input_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageNasAttachDetachInput *
qmi_message_nas_attach_detach_input_ref (QmiMessageNasAttachDetachInput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_nas_attach_detach_input_unref (QmiMessageNasAttachDetachInput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageNasAttachDetachInput, self);
    }
}

QmiMessageNasAttachDetachInput *
qmi_message_nas_attach_detach_input_new (void)
{
    QmiMessageNasAttachDetachInput *self;

    self = g_slice_new0 (QmiMessageNasAttachDetachInput);
    self->ref_count = 1;
    return self;
}

static QmiMessage *
__qmi_message_nas_attach_detach_request_create (
    guint16 transaction_id,
    guint8 cid,
    QmiMessageNasAttachDetachInput *input,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_NAS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_NAS_ATTACH_DETACH);

    /* There is at least one mandatory TLV, don't allow NULL input */
    if (!input) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Message 'Attach Detach' has mandatory TLVs");
        return NULL;
    }

    /* Try to add the 'Action' TLV */
    if (input->arg_action_set) {
        gsize tlv_offset;

        if (!(tlv_offset = qmi_message_tlv_write_init (self, (guint8)QMI_MESSAGE_NAS_ATTACH_DETACH_INPUT_TLV_ACTION, error))) {
            g_prefix_error (error, "Cannot initialize TLV 'Action': ");
            return NULL;
        }

        {
            guint8 tmp;

            tmp = (guint8) input->arg_action;
            /* Write the guint8 variable to the buffer */
            if (!qmi_message_tlv_write_guint8 (self, tmp, error)) {
                g_prefix_error (error, "Cannot write enum in TLV 'Action': ");
                return NULL;
            }
        }

        if (!qmi_message_tlv_write_complete (self, tlv_offset, error)) {
            g_prefix_error (error, "Cannot complete TLV 'Action': ");
            return NULL;
        }
    } else {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_ARGS,
                     "Missing mandatory TLV 'Action' in message 'Attach Detach'");
        return NULL;
    }

    return g_steal_pointer (&self);
}

/* --- Output -- */

struct _QmiMessageNasAttachDetachOutput {
    volatile gint ref_count;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;
};

#define QMI_MESSAGE_NAS_ATTACH_DETACH_OUTPUT_TLV_RESULT 0x02

gboolean
qmi_message_nas_attach_detach_output_get_result (
    QmiMessageNasAttachDetachOutput *self,
    GError **error)
{
    g_return_val_if_fail (self != NULL, FALSE);

    /* We should always have a result set in the response message */
    if (!self->arg_result_set) {
        g_set_error (error,
                     QMI_CORE_ERROR,
                     QMI_CORE_ERROR_INVALID_MESSAGE,
                     "No 'Result' field given in the message");
        return FALSE;
    }

    if (self->arg_result_error_status == QMI_STATUS_SUCCESS) {
        /* Operation succeeded */
        return TRUE;
    }

    /* Report a QMI protocol error */
    g_set_error (error,
                 QMI_PROTOCOL_ERROR,
                 (QmiProtocolError) self->arg_result_error_code,
                 "QMI protocol error (%u): '%s'",
                 self->arg_result_error_code,
                 qmi_protocol_error_get_string ((QmiProtocolError) self->arg_result_error_code));
    return FALSE;
}

GType
qmi_message_nas_attach_detach_output_get_type (void)
{
    static gsize g_define_type_id_initialized = 0;

    if (g_once_init_enter (&g_define_type_id_initialized)) {
        GType g_define_type_id =
            g_boxed_type_register_static (g_intern_static_string ("QmiMessageNasAttachDetachOutput"),
                                          (GBoxedCopyFunc) qmi_message_nas_attach_detach_output_ref,
                                          (GBoxedFreeFunc) qmi_message_nas_attach_detach_output_unref);

        g_once_init_leave (&g_define_type_id_initialized, g_define_type_id);
    }

    return g_define_type_id_initialized;
}

QmiMessageNasAttachDetachOutput *
qmi_message_nas_attach_detach_output_ref (QmiMessageNasAttachDetachOutput *self)
{
    g_return_val_if_fail (self != NULL, NULL);

    g_atomic_int_inc (&self->ref_count);
    return self;
}

void
qmi_message_nas_attach_detach_output_unref (QmiMessageNasAttachDetachOutput *self)
{
    g_return_if_fail (self != NULL);

    if (g_atomic_int_dec_and_test (&self->ref_count)) {
        g_slice_free (QmiMessageNasAttachDetachOutput, self);
    }
}

static gchar *
qmi_message_nas_attach_detach_input_action_get_printable (
    QmiMessage *message,
    const gchar *line_prefix)
{
    gsize offset = 0;
    gsize init_offset;
    GString *printable;
    GError *error = NULL;

    if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_ATTACH_DETACH_INPUT_TLV_ACTION, NULL, NULL)) == 0)
        return NULL;

    printable = g_string_new ("");

    {
        guint8 tmp;

        if (!qmi_message_tlv_read_guint8 (message, init_offset, &offset, &tmp, &error))
            goto out;
        {
#if defined  __QMI_NAS_PS_ATTACH_ACTION_IS_ENUM__
            g_string_append_printf (printable, "%s", qmi_nas_ps_attach_action_get_string ((QmiNasPsAttachAction)tmp));
#elif defined  __QMI_NAS_PS_ATTACH_ACTION_IS_FLAGS__
            {
                g_autofree gchar *flags_str = NULL;

                flags_str = qmi_nas_ps_attach_action_build_string_from_mask ((QmiNasPsAttachAction)tmp);
                g_string_append_printf (printable, "%s", flags_str);
            }
#else
# error unexpected public format: QmiNasPsAttachAction
#endif
        }
    }

    if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0)
        g_string_append_printf (printable, "Additional unexpected '%" G_GSIZE_FORMAT "' bytes", offset);

out:
    if (error) {
        g_string_append_printf (printable, " ERROR: %s", error->message);
        g_error_free (error);
    }
    return g_string_free (printable, FALSE);
}

struct message_attach_detach_context {
    QmiMessage *self;
    const gchar *line_prefix;
    GString *printable;
};

static void
message_attach_detach_get_tlv_printable (
    guint8 type,
    const guint8 *value,
    gsize length,
    struct message_attach_detach_context *ctx)
{
    const gchar *tlv_type_str = NULL;
    g_autofree gchar *translated_value = NULL;
    gboolean value_has_personal_info = FALSE;

    if (!qmi_message_is_response (ctx->self)) {
        switch (type) {
        case QMI_MESSAGE_NAS_ATTACH_DETACH_INPUT_TLV_ACTION:
            tlv_type_str = "Action";
            translated_value = qmi_message_nas_attach_detach_input_action_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    } else {
        switch (type) {
        case QMI_MESSAGE_NAS_ATTACH_DETACH_OUTPUT_TLV_RESULT:
            tlv_type_str = "Result";
            translated_value = qmi_message_result_get_printable (
                                   ctx->self,
                                   ctx->line_prefix);
            break;
        default:
            break;
        }
    }

    if (!tlv_type_str) {
        g_autofree gchar *value_str = NULL;

        value_str = qmi_message_get_tlv_printable (ctx->self,
                                                   ctx->line_prefix,
                                                   type,
                                                   value,
                                                   length);
        g_string_append (ctx->printable, value_str);
    } else {
        g_autofree gchar *value_hex = NULL;

        if (qmi_utils_get_show_personal_info () || !value_has_personal_info)
            value_hex = qmi_common_str_hex (value, length, ':');
        else
            value_hex = g_strdup ("###...");

        g_string_append_printf (ctx->printable,
                                "%sTLV:\n"
                                "%s  type       = \"%s\" (0x%02x)\n"
                                "%s  length     = %" G_GSIZE_FORMAT "\n"
                                "%s  value      = %s\n"
                                "%s  translated = %s\n",
                                ctx->line_prefix,
                                ctx->line_prefix, tlv_type_str, type,
                                ctx->line_prefix, length,
                                ctx->line_prefix, value_hex,
                                ctx->line_prefix, translated_value ? translated_value : "");
    }
}

static gchar *
message_attach_detach_get_printable (
    QmiMessage *self,
    const gchar *line_prefix)
{
    GString *printable;

    printable = g_string_new ("");
    g_string_append_printf (printable,
                            "%s  message     = \"Attach Detach\" (0x0023)\n",
                            line_prefix);

    {
        struct message_attach_detach_context ctx;
        ctx.self = self;
        ctx.line_prefix = line_prefix;
        ctx.printable = printable;
        qmi_message_foreach_raw_tlv (self,
                                     (QmiMessageForeachRawTlvFn)message_attach_detach_get_tlv_printable,
                                     &ctx);
    }

    return g_string_free (printable, FALSE);
}

QmiMessageNasAttachDetachOutput *
qmi_message_nas_attach_detach_response_parse (
    QmiMessage *message,
    GError **error)
{
    QmiMessageNasAttachDetachOutput *self;

    g_assert_cmphex (qmi_message_get_message_id (message), ==, QMI_MESSAGE_NAS_ATTACH_DETACH);

    self = g_slice_new0 (QmiMessageNasAttachDetachOutput);
    self->ref_count = 1;

    do {
        /* No Prerequisites for field */

        {
            gsize offset = 0;
            gsize init_offset;

            if ((init_offset = qmi_message_tlv_read_init (message, QMI_MESSAGE_NAS_ATTACH_DETACH_OUTPUT_TLV_RESULT, NULL, error)) == 0) {
                g_prefix_error (error, "Couldn't get the mandatory Result TLV: ");
                qmi_message_nas_attach_detach_output_unref (self);
                return NULL;
            }
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_status), error))
                goto qmi_message_result_out;
            if (!qmi_message_tlv_read_guint16 (message, init_offset, &offset, QMI_ENDIAN_LITTLE, &(self->arg_result_error_code), error))
                goto qmi_message_result_out;

            /* The remaining size of the buffer needs to be 0 if we successfully read the TLV */
            if ((offset = qmi_message_tlv_read_remaining_size (message, init_offset, offset)) > 0) {
                g_warning ("Left '%" G_GSIZE_FORMAT "' bytes unread when getting the 'Result' TLV", offset);
            }

            self->arg_result_set = TRUE;

qmi_message_result_out:
            if (!self->arg_result_set) {
                qmi_message_nas_attach_detach_output_unref (self);
                return NULL;
            }

        }
    } while (0);

    return self;
}

/*****************************************************************************/
/* REQUEST/RESPONSE: Qmi Message NAS Get Serving System */


/* --- Input -- */

/* Note: no fields in the Input container */

static QmiMessage *
__qmi_message_nas_get_serving_system_request_create (
    guint16 transaction_id,
    guint8 cid,
    gpointer unused,
    GError **error)
{
    g_autoptr(QmiMessage) self = NULL;

    self = qmi_message_new (QMI_SERVICE_NAS,
                            cid,
                            transaction_id,
                            QMI_MESSAGE_NAS_GET_SERVING_SYSTEM);

    return g_steal_pointer (&self);
}

/* --- Output -- */

static void
__qmi_message_nas_get_serving_system_output_roaming_indicator_list_element_free (QmiMessageNasGetServingSystemOutputRoamingIndicatorListElement *value)
{
    g_slice_free (QmiMessageNasGetServingSystemOutputRoamingIndicatorListElement, value);
}

static QmiMessageNasGetServingSystemOutputRoamingIndicatorListElement *
__qmi_message_nas_get_serving_system_output_roaming_indicator_list_element_new (void)
{
    return g_slice_new0 (QmiMessageNasGetServingSystemOutputRoamingIndicatorListElement);
}

static QmiMessageNasGetServingSystemOutputRoamingIndicatorListElement *
__qmi_message_nas_get_serving_system_output_roaming_indicator_list_element_copy (const QmiMessageNasGetServingSystemOutputRoamingIndicatorListElement *value)
{
    QmiMessageNasGetServingSystemOutputRoamingIndicatorListElement *copy;

    copy = __qmi_message_nas_get_serving_system_output_roaming_indicator_list_element_new ();
    copy->radio_interface = value->radio_interface;
    copy->roaming_indicator = value->roaming_indicator;
    return copy;
}

G_DEFINE_BOXED_TYPE (QmiMessageNasGetServingSystemOutputRoamingIndicatorListElement, qmi_message_nas_get_serving_system_output_roaming_indicator_list_element, (GBoxedCopyFunc)__qmi_message_nas_get_serving_system_output_roaming_indicator_list_element_copy, (GBoxedFreeFunc)__qmi_message_nas_get_serving_system_output_roaming_indicator_list_element_free)

struct _QmiMessageNasGetServingSystemOutput {
    volatile gint ref_count;

    /* Network Name Source */
    gboolean arg_network_name_source_set;
    guint32 arg_network_name_source;

    /* MNC PCS Digit Include Status */
    gboolean arg_mnc_pcs_digit_include_status_set;
    guint16 arg_mnc_pcs_digit_include_status_mcc;
    guint16 arg_mnc_pcs_digit_include_status_mnc;
    guint8 arg_mnc_pcs_digit_include_status_includes_pcs_digit;

    /* UMTS Primary Scrambling Code */
    gboolean arg_umts_primary_scrambling_code_set;
    guint16 arg_umts_primary_scrambling_code;

    /* Call Barring Status */
    gboolean arg_call_barring_status_set;
    gint32 arg_call_barring_status_cs_status;
    gint32 arg_call_barring_status_ps_status;

    /* LTE TAC */
    gboolean arg_lte_tac_set;
    guint16 arg_lte_tac;

    /* HDR Personality */
    gboolean arg_hdr_personality_set;
    guint8 arg_hdr_personality;

    /* CDMA System Info */
    gboolean arg_cdma_system_info_set;
    guint16 arg_cdma_system_info_mcc;
    guint8 arg_cdma_system_info_imsi_11_12;

    /* Detailed Service Status */
    gboolean arg_detailed_service_status_set;
    guint8 arg_detailed_service_status_status;
    guint8 arg_detailed_service_status_capability;
    guint8 arg_detailed_service_status_hdr_status;
    guint8 arg_detailed_service_status_hdr_hybrid;
    guint8 arg_detailed_service_status_forbidden;

    /* DTM Support */
    gboolean arg_dtm_support_set;
    guint8 arg_dtm_support;

    /* PRL Indicator 3GPP2 */
    gboolean arg_prl_indicator_3gpp2_set;
    guint8 arg_prl_indicator_3gpp2;

    /* Concurrent Service Info 3GPP2 */
    gboolean arg_concurrent_service_info_3gpp2_set;
    guint8 arg_concurrent_service_info_3gpp2;

    /* CID 3GPP */
    gboolean arg_cid_3gpp_set;
    guint32 arg_cid_3gpp;

    /* LAC 3GPP */
    gboolean arg_lac_3gpp_set;
    guint16 arg_lac_3gpp;

    /* Daylight Saving Time Adjustment 3GPP */
    gboolean arg_daylight_saving_time_adjustment_3gpp_set;
    guint8 arg_daylight_saving_time_adjustment_3gpp;

    /* Time Zone 3GPP */
    gboolean arg_time_zone_3gpp_set;
    gint8 arg_time_zone_3gpp;

    /* CDMA P Rev */
    gboolean arg_cdma_p_rev_set;
    guint8 arg_cdma_p_rev;

    /* Time Zone 3GPP2 */
    gboolean arg_time_zone_3gpp2_set;
    guint8 arg_time_zone_3gpp2_leap_seconds;
    gint8 arg_time_zone_3gpp2_local_time_offset;
    guint8 arg_time_zone_3gpp2_daylight_saving_time;

    /* Default Roaming Indicator */
    gboolean arg_default_roaming_indicator_set;
    guint8 arg_default_roaming_indicator;

    /* Roaming Indicator List */
    gboolean arg_roaming_indicator_list_set;
    GArray *arg_roaming_indicator_list;
    GPtrArray *arg_roaming_indicator_list_ptr;

    /* CDMA Base Station Info */
    gboolean arg_cdma_base_station_info_set;
    guint16 arg_cdma_base_station_info_base_station_id;
    gint32 arg_cdma_base_station_info_base_station_latitude;
    gint32 arg_cdma_base_station_info_base_station_longitude;

    /* CDMA System ID */
    gboolean arg_cdma_system_id_set;
    guint16 arg_cdma_system_id_sid;
    guint16 arg_cdma_system_id_nid;

    /* Current PLMN */
    gboolean arg_current_plmn_set;
    guint16 arg_current_plmn_mcc;
    guint16 arg_current_plmn_mnc;
    gchar *arg_current_plmn_description;

    /* Data Service Capability */
    gboolean arg_data_service_capability_set;
    GArray *arg_data_service_capability;

    /* Roaming Indicator */
    gboolean arg_roaming_indicator_set;
    guint8 arg_roaming_indicator;

    /* Result */
    gboolean arg_result_set;
    guint16 arg_result_error_status;
    guint16 arg_result_error_code;

    /* Serving System */
    gboolean arg_serving_system_set;
    guint8 arg_serving_system_registration_state;
    guint8 arg_serving_system_cs_attach_state;
    guint8 arg_serving_system_ps_attach_state;
    guint8 arg_serving_system_selected_network;
    GArray *arg_serving_system_radio_interfaces;
};

#define QMI_MESSAGE_NAS_GET_SERVING_SYSTEM_OUTPUT_TLV_NETWORK_NAME_SOURCE 0x29
#define QMI_MESSAGE_NAS_GET_SERVING_SYSTEM_OUTPUT_TLV