/* ScummVM - Graphic Adventure Engine
*
* ScummVM is the legal property of its developers, whose names
* are too numerous to list here. Please refer to the COPYRIGHT
* file distributed with this source distribution.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/

#ifndef DARKSEED_OBJECT_NAME_TABLES_H
#define DARKSEED_OBJECT_NAME_TABLES_H

namespace Darkseed {

static constexpr char objectNameTbl_en[199][21] = {
	"Nothing.",
	"Box",
	"hand",
	"eye",
	"Ctrl",
	"crowbar",
	"journal",
	"scotch",
	"money",
	"newspaper",
	"library card",
	"bobby pin",
	"journal scrap",
	"clock key",
	"gloves",
	"mirror shard",
	"binoculars",
	"shovel",
	"business card",
	"stick",
	"axe handle",
	"head band",
	"trunk",
	"rope",
	"microfiche card",
	"loose rock",
	"car keys",
	"hammer",
	"gun",
	"grave journal scrap",
	"note from movers",
	"package",
	"package",
	"package",
	"blue print",
	"watch",
	"crackers",
	"sardines",
	"insecticide",
	"soysauce",
	"olives",
	"tin cup",
	"trunk lock",
	"book 'Alien'",
	"gas cap",
	"Fido",
	"librarian",
	"telephone",
	"bone bars",
	"stairs",
	"brass urn",
	"viewscreen",
	"shower",
	"sergeant",
	"guard",
	"evil plans",
	"evil sergeant",
	"starship lever",
	"Dreketh guards",
	"secret door",
	"turbo door",
	"post",
	"radio dial",
	"exit in car",
	"guard",
	"prisoner lock",
	"tomb left",
	"tomb up",
	"tomb right",
	"front door",
	"top of stairs",
	"car ignition",
	"police at door",
	"evil mike",
	"Gcell lock",
	"tombstone",
	"ladder down",
	"ladder",
	"secret door 2",
	"evil fido",
	"microfiche",
	"box behind desk",
	"button",
	"library floor",
	"book",
	"store",
	"glove compartment",
	"tombstone",
	"tombstone",
	"tombstone",
	"tombstone",
	"tombstone",
	"tombstone",
	"tombstone",
	"tombstone",
	"tombstone",
	"tombstone",
	"tombstone",
	"tombstone",
	"tomb door",
	"coat",
	"car trunk",
	"rope tied to house",
	"clock",
	"cupboard",
	"cupboard",
	"cupboard",
	"cupboard",
	"stove",
	"drawer",
	"kitchen tap",
	"bathroom tap",
	"medicine chest",
	"pillow",
	"Ancient",
	"power nexus",
	"abyss",
	"observatory lever",
	"horizon",
	"force field",
	"leech victims",
	"shrubs",
	"railing",
	"bed",
	"artwork",
	"carpet",
	"chair",
	"spittoon",
	"bed",
	"bed bottom",
	"fridge",
	"books",
	"globe",
	"mug shots",
	"map",
	"desk",
	"xxx",
	"mirror",
	"clerk",
	"ladder",
	"postman",
	"Delbert",
	"cement rock",
	"towels",
	"water heater",
	"bathtub",
	"xxx",
	"couch",
	"window",
	"art",
	"art",
	"clock",
	"counter",
	"books",
	"desk",
	"xxx",
	"desk",
	"books",
	"arch",
	"ground",
	"pillars",
	"caskets",
	"horizon",
	"urn",
	"urn",
	"urn",
	"urn",
	"urn",
	"urn",
	"xxx",
	"soccer ball",
	"skis",
	"trunk",
	"bottles",
	"barrels",
	"wheel",
	"car",
	"furniture",
	"xxx",
	"cocoons",
	"wall of skulls",
	"creature",
	"glass case",
	"power cables",
	"tubes",
	"brain nexus",
	"xxx",
	"control panel",
	"desk",
	"cell bars",
	"cell bars",
	"console",
	"viewer",
	"building",
	"box",
	"tools",
	"newspaper",
	"table",
	"bed bottom",
};

static constexpr char objectNameTbl_fr[199][22] = {
	"RIEN",
	"LA BOITE",
	"LA MAIN",
	"LA QUESTION",
	"CTRL",
	"LE MANIVELLE",
	"LE JOURNAL",
	"LE WHISKY",
	"DE L'ARGENT",
	"LE JOURNAL",
	"LA CARTE DE PRET",
	"LA PINCE",
	"LE BOUT DE JOURNAL",
	"LA CLEF DE L'HORLOGE",
	"LES GANTS",
	"UN FRAGMENT DU MIROIR",
	"LES JUMELLES",
	"LA PELLE",
	"CARTE PROFESSIONNELLE",
	"LE BATON",
	"LA COGNEE",
	"LE BANDEAU",
	"LE COFFRE",
	"LA CORDE",
	"CARTE A MICROFICHES",
	"PIERRE DESCELLEE",
	"CLEFS DE LA VOITURE",
	"MARTEAU",
	"L'ARME",
	"JOURNAL DU CIMETIERE",
	"NOTE DES DEMENAGEURS",
	"LE PAQUET",
	"LE PAQUET",
	"LE PAQUET",
	"LE PLAN",
	"LA MONTRE",
	"DES CRACKERS",
	"DES SARDINES",
	"UN INSECTICIDE",
	"UNE SAUCE AU SOJA",
	"LES OLIVES",
	"TIMBALE EN ETAIN",
	"SERRURE DU COFFRE",
	"LIVRE 'ALIEN'",
	"LE BOUCHON",
	"FIDO",
	"LE BIBLIOTHECAIRE",
	"LE TELEPHONE",
	"UNE BARRE EN OS",
	"LES ESCALIERS",
	"L'URNE EN CUIVRE",
	"L'ECRAN",
	"LA DOUCHE",
	"LE SERGENT",
	"XXX",
	"DES PLANS MAUDITS",
	"LE SERGENT MALEFIQUE",
	"MANETTE DU VAISSEAU",
	"LES GARDES DE DREKETH",
	"LA PORTE DEROBEE",
	"LA PORTE TURBO",
	"POSTE",
	"SELECTEUR RADIO",
	"SORTIE EN VOITURE",
	"DELBERT",
	"LE VERROU",
	"LA TOMBE A GAUCHE",
	"LA TOMBE EN HAUT",
	"LA TOMBE A DROITE",
	"LA PORTE DE DEVANT",
	"LE HAUT DES ESCALIERS",
	"LE CONTACT",
	"POLICE CHEZ VOUS",
	"MALFAISANT MIKE",
	"VERROU CELL. G",
	"LA PIERRE TOMBALE",
	"L'ECHELLE",
	"L'ECHELLE",
	"LA PORTE DEROBEE",
	"MAUVAIS FIDO",
	"LA MICROFICHE",
	"BOITE APRES LE BUREAU",
	"LE BOUTON",
	"ETAGE BIBLIOTHEQUE",
	"LE LIVRE",
	"LE MAGASIN",
	"LE LIVRE",
	"LA PIERRE TOMBALE",
	"LA PIERRE TOMBALE",
	"LA PIERRE TOMBALE",
	"LA PIERRE TOMBALE",
	"LA PIERRE TOMBALE",
	"LA PIERRE TOMBALE",
	"LA PIERRE TOMBALE",
	"LA PIERRE TOMBALE",
	"LA PIERRE TOMBALE",
	"LA PIERRE TOMBALE",
	"LA PIERRE TOMBALE",
	"LA PIERRE TOMBALE",
	"LA PORTE DU CAVEAU",
	"LE MANTEAU",
	"COFFRE DE L'AUTO",
	"CORDE LIEE AU LOGIS",
	"L'HORLOGE",
	"LE PLACARD",
	"LE PLACARD",
	"LE PLACARD",
	"LE PLACARD",
	"LE FOUR",
	"LE TIROIR",
	"ROBINET DE LA CUISINE",
	"ROBINET",
	"BOITE A PHARMACIE",
	"L'OREILLER",
	"L'ANCIEN",
	"LIEN DE PUISSANCE",
	"L'ABYSSE",
	"POIGNER",
	"L'HORIZON",
	"LE CHAMPS DE FORCE",
	"VICTIME DE SANGSUES",
	"DES ARBUSTES",
	"LES RAMPES",
	"LE LIT",
	"LE DECORUM",
	"LE TAPIS",
	"LA CHAISE",
	"LE CRACHOIR",
	"LE LIT",
	"LE PIED DU LIT",
	"LE REFRIGERATEUR",
	"LES LIVRES",
	"LE GLOBE",
	"PHOTOS D'IDENTITE",
	"LA CARTE",
	"LE BUREAU",
	"XXX",
	"LE MIROIR",
	"L'EMPLOYE",
	"LE CORDON",
	"LE POSTIER",
	"DELBERT",
	"LE BLOC DE CIMENT",
	"LES SERVIETTES",
	"LE CHAUFFE-EAU",
	"LA BAIGNOIRE",
	"XXX",
	"LE DIVAN",
	"LA FENETRE",
	"L'ART",
	"L'ART",
	"L'HORLOGE",
	"LE COMPTOIR",
	"LES LIVRES",
	"LE BUREAU",
	"XXX",
	"LE BUREAU",
	"LES LIVRES",
	"L'ARCHE",
	"LE SOL",
	"LES COLONNES",
	"LES BOITES",
	"L'HORIZON",
	"L'URNE",
	"L'URNE",
	"L'URNE",
	"L'URNE",
	"L'URNE",
	"L'URNE",
	"XXX",
	"BALLON DE FOOT",
	"LES SKIS",
	"LE COFFRE",
	"LES BOUTEILLES",
	"LES TONNEAUX",
	"LE VOLANT",
	"LA VOITURE",
	"LES MEUBLES",
	"XXX",
	"LES COCONS",
	"LE MUR DE CRANES",
	"LA CREATURE",
	"LE GLOBE",
	"CABLES D'ALIMENTATION",
	"LES TUBES",
	"LIEN DU CERVEAU",
	"XXX",
	"LE TABLEAU DE BORD",
	"LE BUREAU",
	"LE BARREAU",
	"LE BARREAU",
	"LA CONSOLE",
	"LA VISIONNEUSE",
	"LE BATIMENT",
	"LA BOITE",
	"LES OUTILS",
	"LE JOURNAL",
	"LA TABLE",
	"PIED DU LIT"
};

static constexpr char objectNameTbl_de[199][27] = {
	"NICHTS",
	"DER KASTEN",
	"DIE HAND",
	"DIE FRAGE",
	"CTRL",
	"DAS BRECHEISEN",
	"DAS TAGEBUCH",
	"DIE FLASCHE SCOTCH",
	"DAS GELD",
	"DIE ZEITUNG",
	"DIE BUECHEREIKARTE",
	"DIE HAARNADEL",
	"DIE TAGEBUCHSCHNIPSEL",
	"DER UHRENSCHLUESSEL",
	"DIE HANDSCHUHE",
	"DIE SPIEGELSCHERBE",
	"DAS FERNGLAS",
	"DIE SCHAUFEL",
	"DIE VISITENKARTE",
	"DER STOCK",
	"DER AXTGRIFF",
	"DAS STIRNBAND",
	"DIE TRUHE",
	"DAS SEIL",
	"DIE MIKROFILMKARTE",
	"DER LOSER STEIN",
	"DIE AUTOSCHLUESSEL",
	"DER HAMMER",
	"DIE PISTOLE",
	"DIE TAGEBUCHSEITEN",
	"DIE NOTIZ DER MOEBELPACKER",
	"DAS PAKET",
	"DAS PAKET",
	"DAS PAKET",
	"DIE BLAUPAUSE",
	"DIE UHR",
	"DIE KEKSE",
	"DIE SARDINEN",
	"DAS INSEKTENSPRAY",
	"DIE SOJASAUCE",
	"DIE OLIVEN",
	"DER ZINNBECHER",
	"DAS TRUHENSCHLOSS",
	"DAS BUCH 'AUSSERIRDISCHER'",
	"DER GASHAHN",
	"DER FIDO",
	"DIE BIBLIOTHEKARIN",
	"DAS TELEFON",
	"DIE KNOCHENGITTER",
	"DIE STUFEN",
	"DIE MESSING-URNE",
	"DER BILDSCHIRM",
	"DIE DUSCHE",
	"DER POLIZIST",
	"xxx",
	"DIE PLAENE DER BOESEN",
	"DER BOESER POLIZIST",
	"DER HEBEL FUER RAUMSCHIFF",
	"DIE DREKETH-WACHEN",
	"DIE GEHEIMTUER",
	"DIE AUFZUGTUER",
	"DIE POST",
	"DIE FREQUENZANZEIGE",
	"DER AUSGANG IM AUTO",
	"DER DELBERT",
	"DAS GEFAENGNISSCHLOSS",
	"DIE LINKE STEINPLATTE",
	"DIE OBERE STEINPLATTE",
	"DIE RECHTE STEINPLATTE",
	"DIE HAUSTUER",
	"DIE OBERSTE STUFE",
	"DAS ZUENDSCHLOSS",
	"DIE POLIZEI AN DER TUER",
	"DER BOESER MIKE",
	"DAS ZELLENSCHLOSS",
	"DER GRABSTEIN",
	"DIE LEITER",
	"DIE LEITER",
	"DIE GEHEIMTUER",
	"DER BOESER FIDO",
	"DER MIKROFILM",
	"DER KASTEN HINTER PULT",
	"DER KNOPF",
	"DER BUECHERGANG",
	"DAS BUCH",
	"DER LADEN",
	"DAS BUCH",
	"DER GRABSTEIN",
	"DER GRABSTEIN",
	"DER GRABSTEIN",
	"DER GRABSTEIN",
	"DER GRABSTEIN",
	"DER GRABSTEIN",
	"DER GRABSTEIN",
	"DER GRABSTEIN",
	"DER GRABSTEIN",
	"DER GRABSTEIN",
	"DER GRABSTEIN",
	"DER GRABSTEIN",
	"DIE TUER DER GRUFT",
	"DER MANTEL",
	"DER KOFFERRAUM",
	"DAS ANGEBUNDENES SEIL",
	"DIE UHR",
	"DER SCHRANK",
	"DER SCHRANK",
	"DER SCHRANK",
	"DER SCHRANK",
	"DER HERD",
	"DIE SCHUBLADE",
	"DER KUECHEN-WASSERHAHN",
	"DER BAD-WASSERHAHN",
	"DER MEDIZINSCHRANK",
	"DIE KISSEN",
	"DIE ALTER",
	"DIE STROMVERSORGUNG",
	"DER ABGRUND",
	"DER OBSERVATORIUMSHEBEL",
	"DER HORIZONT",
	"DAS KRAFTFELD",
	"DER OPFER DES BLUTSAUGERS",
	"DIE BUESCHE",
	"DAS GELAENDER",
	"DAS BETT",
	"DAS KUNSTWERK",
	"DER TEPPICH",
	"DER STUHL",
	"DER SPUCKNAPF",
	"DAS BETT",
	"DER FUSS DES BETTES",
	"DER KUEHLSCHRANK",
	"DIE BUECHER",
	"DER GLOBUS",
	"DIE PHANTOMBILDER",
	"DIE KARTE",
	"DER SCHREIBTISCH",
	"xxx",
	"DER SPIEGEL",
	"DER ANGESTELLTER",
	"DAS SEIL",
	"DER POSTBOTE",
	"DER DELBERT",
	"DAS ZEMENTGESTEIN",
	"DIE HANDTUECHER",
	"DER BOILER",
	"DIE BADEWANNE",
	"xxx",
	"DIE COUCH",
	"DIE FENSTER",
	"DIE KUNST",
	"DIE KUNST",
	"DIE UHR",
	"DIE TRESEN",
	"DIE BUECHER",
	"DER SCHREIBTISCH",
	"xxx",
	"DER SCHREIBTISCH",
	"DIE BUECHER",
	"DER BOGEN",
	"DER BODEN",
	"DIE SAEULEN",
	"DIE URNEN",
	"DER HORIZONT",
	"DIE URNE",
	"DIE URNE",
	"DIE URNE",
	"DIE URNE",
	"DIE URNE",
	"DIE URNE",
	"xxx",
	"DER FUSSBALL",
	"DIE SKIER",
	"DIE TRUHE",
	"DIE FLASCHEN",
	"DIE FAESSER",
	"DAS RAD",
	"DAS AUTO",
	"DIE MOEBEL",
	"xxx",
	"DIE KOKONS",
	"DIE WAND VOLLER SCHAEDELN",
	"DIE KREATUR",
	"DER GLASKAEFIG",
	"DIE STROMKABEL",
	"DIE ROHRE",
	"DIE GEHIRNVERSORGUNG",
	"xxx",
	"DER KONTROLLPULT",
	"DER SCHREIBTISCH",
	"DIE ZELLENGITTER",
	"DIE ZELLENGITTER",
	"DIE KONSOLE",
	"DIE SUCHER",
	"DIE GEBAEUDE",
	"DIE KASTEN",
	"DAS WERKZEUG",
	"DIE ZEITUNG",
	"DER TISCH",
	"DAS FUSSENDE DES BETTES"
};

static constexpr char objectNameTbl_es[199][35] = {
	"NADA",
	"LA CAJA",
	"LA MANO",
	"LA PREGUNTA",
	"CTRL",
	"LA BALLESTA",
	"EL DIARIO",
	"EL WHISKY",
	"EL DINERO",
	"EL PERIODICO",
	"LA FICHA DE LIBRERIA",
	"LA HORQUILLA",
	"EL PAPEL DE PERIODICO",
	"LA LLAVE DEL RELOJ",
	"LOS GUANTES",
	"EL TROZO DE ESPEJO",
	"LOS PRISMATICOS",
	"LA PALA",
	"LA TARJETA DE VISITA",
	"LA VARA",
	"EL MANGO DEL HACHA",
	"LA CINTA DE LA CABEZA",
	"EL BAUL",
	"LA CUERDA",
	"LA TARJETA MICROFICHA",
	"LA PIEDRA SUELTA",
	"LAS LLAVES DEL COCHE",
	"EL MARTILLO",
	"LA PISTOLA",
	"UNA NECROLOGIA",
	"LA NOTA DE LA MUDANZA",
	"EL PAQUETE",
	"EL PAQUETE",
	"EL PAQUETE",
	"EL PLANO",
	"EL RELOJ",
	"LAS GALLETAS",
	"LAS SARDINAS",
	"EL INSECTICIDA",
	"LA SALSA DE SOJA",
	"LAS ACEITUNAS",
	"LA TAZA DE HOJALATA",
	"LA CERRADURA DEL BAUL",
	"EL LIBRO 'ALIEN'",
	"EL TAPON DE GASOLINA",
	"FIDO",
	"LA BIBLIOTECARIA",
	"EL TELEFONO",
	"LAS BARRAS DE HUESO",
	"LAS ESCALERAS",
	"LA URNA DE BRONCE",
	"LA PANTALLA DE VISION",
	"LA DUCHA",
	"EL SARGENTO",
	"xxx",
	"LOS PLANOS DIABOLICOS",
	"EL SARGENTO DIABOLICO",
	"LA PALANCA",
	"LOS GUARDIANES DE DREKETH",
	"LA PUERTA SECRETA",
	"LA TURBO PUERTA",
	"EL CORREO",
	"EL DIAL DE LA RADIO",
	"LA SALIDA EN COCHE",
	"DELBERT",
	"LA CERRADURA DEL PRISIONERO",
	"LA TUMBA DE LA IZQUIERDA",
	"LA TUMBA DE ARRIBA",
	"LA TUMBA DE LA DERECHA",
	"LA PUERTA DELANTERA",
	"LA PARTA SUPERIOR DE LAS ESCALERAS",
	"EL ARRANQUE DEL COCHE",
	"EL POLICIA EN LA PUERTA",
	"MIKE DIABOLICO",
	"LA CERRADURA DE LA CELDA",
	"LA LAPIDA",
	"LA ESCALERA",
	"LA ESCALERA",
	"LA PUERTA SECRETA",
	"FIDO DIABOLICO",
	"LA MICROFICHA",
	"LA CAJA DETRAS DEL ESCRITORIO",
	"EL BOTON",
	"EL SUELO DE LA BIBLIOTECA",
	"EL LIBRO",
	"LA TIENDA",
	"EL LIBRO",
	"LA LAPIDA",
	"LA LAPIDA",
	"LA LAPIDA",
	"LA LAPIDA",
	"LA LAPIDA",
	"LA LAPIDA",
	"LA LAPIDA",
	"LA LAPIDA",
	"LA LAPIDA",
	"LA LAPIDA",
	"LA LAPIDA",
	"LA LAPIDA",
	"LA PUERTA DE LA TUMBA",
	"EL ABRIGO",
	"EL PORTAEQUIPAJES",
	"LA CUERDA ATADA A LA CASA",
	"EL RELOJ",
	"EL ARMARIO",
	"EL ARMARIO",
	"EL ARMARIO",
	"EL ARMARIO",
	"LA ESTUFA",
	"EL COJON",
	"LA LLAVE DE LA COCINA",
	"LA LLAVE DEL CUARTO DE ASEO",
	"EL BOTIQUIN",
	"LA ALMOHADA",
	"EL ANTEPASADO",
	"LA FUENTA DE ENERGIA",
	"EL ABISMO",
	"LA PALANCA DEL OBSERVATORIO",
	"EL HORIZONTE",
	"EL CAMPO DE FUERZA",
	"LAS VICTIMAS DE LA SANGUIJUELA",
	"LOS ARBUSTOS",
	"LA BARANDILLA",
	"LA CAMA",
	"LA OBRA DE ARTE",
	"LA ALFOMBRA",
	"LA SILLA",
	"LA ESCUPIDERA",
	"LA CAMA",
	"EL FONDO DE LA CAMA",
	"EL FRIGORIFICO",
	"LOS LIBROS",
	"EL GLOBO TERRAQUEO",
	"LAS FOTOGRAFIAS DE RUFIANES",
	"EL MAPA",
	"EL ESCRITORIO",
	"xxx",
	"EL ESPEJO",
	"EL EMPLEADO",
	"EL CORDON",
	"EL CARTERO",
	"DELBERT",
	"LA PIEDRA DE CEMENTO",
	"LAS TOALLAS",
	"EL CALENTADOR DE AGUA",
	"LA BANERA",
	"xxx",
	"EL SOFA",
	"LA VENTANA",
	"EL ARTE",
	"EL ARTE",
	"EL RELOJ",
	"EL MOSTRADOR",
	"LOS LIBROS",
	"EL ESCRITORIO",
	"xxx",
	"EL ESCRITORIO",
	"LOS LIBROS",
	"EL ARCO",
	"EL SUELO",
	"LOS PILARES",
	"LOS ATAUDES",
	"EL HORIZONTE",
	"LA URNA",
	"LA URNA",
	"LA URNA",
	"LA URNA",
	"LA URNA",
	"LA URNA",
	"xxx",
	"EL BALON DE FUTBOL",
	"LOS ESQUIS",
	"EL BAUL",
	"LAS BOTELLAS",
	"LOS BARRILES",
	"LA RUEDA",
	"EL COCHE",
	"LOS MUEBLES",
	"xxx",
	"LOS CAPULLOS",
	"LA PARED DE CALAVERAS",
	"LA CRIATURA",
	"LA CAJA DE CRISTAL",
	"LOS CABLES DE ENERGIA",
	"LOS TUBOS",
	"EL NEXO CEREBRAL",
	"xxx",
	"EL PANEL DE CONTROL",
	"EL ESCRITORIO",
	"LAS BARRAS DE LA CELDA",
	"LAS BARRAS DE LA CELDA",
	"LA CONSOLA",
	"EL VISOR",
	"EL EDIFICIO",
	"LA CAJA",
	"LAS HERRAMIENTAS",
	"EL PERIODICO",
	"LA MESA",
	"EL FONDO DE LA CAMA"
};

} // namespace Darkseed
#endif //DARKSEED_OBJECT_NAME_TABLES_H
