/* game-view-gtk.c generated by valac 0.56.18, the Vala compiler
 * generated from game-view-gtk.vala, do not modify */

/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_GAME_VIEW, GameViewIface))

typedef struct _GameView GameView;
typedef struct _GameViewIface GameViewIface;

#define TYPE_BOARD_VIEW (board_view_get_type ())
#define BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOARD_VIEW, BoardView))
#define IS_BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOARD_VIEW))
#define BOARD_VIEW_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_BOARD_VIEW, BoardViewIface))

typedef struct _BoardView BoardView;
typedef struct _BoardViewIface BoardViewIface;

#define TYPE_PUZZLE_GENERATOR (puzzle_generator_get_type ())
#define PUZZLE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_GENERATOR, PuzzleGenerator))
#define PUZZLE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_GENERATOR, PuzzleGeneratorClass))
#define IS_PUZZLE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_GENERATOR))
#define IS_PUZZLE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_GENERATOR))
#define PUZZLE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_GENERATOR, PuzzleGeneratorClass))

typedef struct _PuzzleGenerator PuzzleGenerator;
typedef struct _PuzzleGeneratorClass PuzzleGeneratorClass;
typedef enum  {
	GAME_VIEW_REPLACE_STYLE_REFRESH,
	GAME_VIEW_REPLACE_STYLE_RESTART,
	GAME_VIEW_REPLACE_STYLE_SLIDE_FORWARD,
	GAME_VIEW_REPLACE_STYLE_SLIDE_BACKWARD,
	GAME_VIEW_REPLACE_STYLE_SLIDE_NEXT
} GameViewReplaceStyle;

#define GAME_VIEW_TYPE_REPLACE_STYLE (game_view_replace_style_get_type ())

#define TYPE_GTK_GAME_VIEW (gtk_game_view_get_type ())
#define GTK_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GTK_GAME_VIEW, GtkGameView))
#define GTK_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GTK_GAME_VIEW, GtkGameViewClass))
#define IS_GTK_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GTK_GAME_VIEW))
#define IS_GTK_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GTK_GAME_VIEW))
#define GTK_GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GTK_GAME_VIEW, GtkGameViewClass))

typedef struct _GtkGameView GtkGameView;
typedef struct _GtkGameViewClass GtkGameViewClass;
typedef struct _GtkGameViewPrivate GtkGameViewPrivate;

#define TYPE_BOARD_VIEW_GTK (board_view_gtk_get_type ())
#define BOARD_VIEW_GTK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOARD_VIEW_GTK, BoardViewGtk))
#define BOARD_VIEW_GTK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOARD_VIEW_GTK, BoardViewGtkClass))
#define IS_BOARD_VIEW_GTK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOARD_VIEW_GTK))
#define IS_BOARD_VIEW_GTK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOARD_VIEW_GTK))
#define BOARD_VIEW_GTK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOARD_VIEW_GTK, BoardViewGtkClass))

typedef struct _BoardViewGtk BoardViewGtk;
typedef struct _BoardViewGtkClass BoardViewGtkClass;
enum  {
	GTK_GAME_VIEW_0_PROPERTY,
	GTK_GAME_VIEW_NUM_PROPERTIES
};
static GParamSpec* gtk_game_view_properties[GTK_GAME_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _BoardViewIface {
	GTypeInterface parent_iface;
	PuzzleGenerator* (*get_puzzle_generator) (BoardView* self);
	void (*clear_level) (BoardView* self);
	void (*toggle_light) (BoardView* self, gint x, gint y, gboolean user_initiated);
	gboolean (*is_light_active) (BoardView* self, gint x, gint y);
	GObject* (*get_light_at) (BoardView* self, gint x, gint y);
};

struct _GameViewIface {
	GTypeInterface parent_iface;
	void (*replace_board) (GameView* self, BoardView* board_biew, BoardView* new_board_view, GameViewReplaceStyle style, gboolean fast);
	gboolean (*hide_cursor) (GameView* self);
	gboolean (*activate_cursor) (GameView* self);
	gboolean (*move_cursor) (GameView* self, gint x, gint y);
	void (*reset_game) (GameView* self);
	BoardView* (*get_board_view) (GameView* self);
	gboolean (*is_transitioning) (GameView* self);
	gint (*next_level) (GameView* self, gint direction);
	BoardView* (*create_board_view) (GameView* self, gint level);
};

struct _GtkGameView {
	GtkWidget parent_instance;
	GtkGameViewPrivate * priv;
};

struct _GtkGameViewClass {
	GtkWidgetClass parent_class;
};

struct _GtkGameViewPrivate {
	GtkStack* stack;
	BoardViewGtk* board_view;
	gint current_level;
	GQueue* handlers;
	gint _moves;
};

struct _Block1Data {
	int _ref_count_;
	GtkGameView* self;
	BoardView* old_board;
	BoardView* new_board;
};

static gint GtkGameView_private_offset;
static gpointer gtk_game_view_parent_class = NULL;
static GameViewIface * gtk_game_view_game_view_parent_iface = NULL;

VALA_EXTERN GType puzzle_generator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PuzzleGenerator, g_object_unref)
VALA_EXTERN GType board_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoardView, g_object_unref)
VALA_EXTERN GType game_view_replace_style_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType game_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameView, g_object_unref)
VALA_EXTERN GType gtk_game_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkGameView, g_object_unref)
VALA_EXTERN GType board_view_gtk_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoardViewGtk, g_object_unref)
static void gtk_game_view_real_replace_board (GameView* base,
                                       BoardView* old_board,
                                       BoardView* new_board,
                                       GameViewReplaceStyle style,
                                       gboolean fast);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda5_ (Block1Data* _data1_);
VALA_EXTERN void gtk_game_view_board_replaced (GtkGameView* self,
                                   BoardViewGtk* old_board,
                                   BoardViewGtk* new_board);
static void ____lambda5__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static gboolean gtk_game_view_real_hide_cursor (GameView* base);
static gboolean gtk_game_view_real_activate_cursor (GameView* base);
static gboolean gtk_game_view_real_move_cursor (GameView* base,
                                         gint x,
                                         gint y);
static void gtk_game_view_real_reset_game (GameView* base);
VALA_EXTERN gboolean game_view_is_transitioning (GameView* self);
VALA_EXTERN void game_view_replace_board (GameView* self,
                              BoardView* board_biew,
                              BoardView* new_board_view,
                              GameViewReplaceStyle style,
                              gboolean fast);
VALA_EXTERN BoardView* game_view_get_board_view (GameView* self);
VALA_EXTERN BoardView* game_view_create_board_view (GameView* self,
                                        gint level);
VALA_EXTERN GtkGameView* gtk_game_view_new (gint level);
VALA_EXTERN GtkGameView* gtk_game_view_construct (GType object_type,
                                      gint level);
static BoardView* gtk_game_view_real_create_board_view (GameView* base,
                                                 gint level);
VALA_EXTERN BoardViewGtk* board_view_gtk_new (void);
VALA_EXTERN BoardViewGtk* board_view_gtk_construct (GType object_type);
VALA_EXTERN void board_view_load_level (BoardView* self,
                            gint level);
VALA_EXTERN void game_view_game_won_cb (GameView* self);
static void _game_view_game_won_cb_board_view_game_won (BoardView* _sender,
                                                 gpointer self);
VALA_EXTERN void gtk_game_view_light_toggled_cb (GtkGameView* self);
static void _gtk_game_view_light_toggled_cb_board_view_light_toggled (BoardView* _sender,
                                                               gpointer self);
static BoardView* gtk_game_view_real_get_board_view (GameView* base);
static gint gtk_game_view_real_next_level (GameView* base,
                                    gint direction);
static gboolean gtk_game_view_real_is_transitioning (GameView* base);
static GObject * gtk_game_view_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
VALA_EXTERN gboolean game_view_hide_cursor (GameView* self);
VALA_EXTERN gboolean game_view_activate_cursor (GameView* self);
VALA_EXTERN gboolean game_view_move_cursor (GameView* self,
                                gint x,
                                gint y);
VALA_EXTERN void game_view_reset_game (GameView* self);
VALA_EXTERN gint game_view_next_level (GameView* self,
                           gint direction);
static void gtk_game_view_finalize (GObject * obj);
static GType gtk_game_view_get_type_once (void);

static inline gpointer
gtk_game_view_get_instance_private (GtkGameView* self)
{
	return G_STRUCT_MEMBER_P (self, GtkGameView_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GtkGameView* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->old_board);
		_g_object_unref0 (_data1_->new_board);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
___lambda5_ (Block1Data* _data1_)
{
	GtkGameView* self;
	self = _data1_->self;
	gtk_game_view_board_replaced (self, G_TYPE_CHECK_INSTANCE_CAST (_data1_->old_board, TYPE_BOARD_VIEW_GTK, BoardViewGtk), G_TYPE_CHECK_INSTANCE_CAST (_data1_->new_board, TYPE_BOARD_VIEW_GTK, BoardViewGtk));
}

static void
____lambda5__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	___lambda5_ (self);
}

static void
gtk_game_view_real_replace_board (GameView* base,
                                  BoardView* old_board,
                                  BoardView* new_board,
                                  GameViewReplaceStyle style,
                                  gboolean fast)
{
	GtkGameView * self;
	Block1Data* _data1_;
	BoardView* _tmp0_;
	BoardView* _tmp1_;
	gint _tmp2_ = 0;
	GtkStack* _tmp3_;
	GtkStack* _tmp8_;
	GtkStack* _tmp9_;
	GdkDisplay* _tmp10_;
	GtkSettings* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	self = (GtkGameView*) base;
	g_return_if_fail (old_board != NULL);
	g_return_if_fail (new_board != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (old_board);
	_g_object_unref0 (_data1_->old_board);
	_data1_->old_board = _tmp0_;
	_tmp1_ = _g_object_ref0 (new_board);
	_g_object_unref0 (_data1_->new_board);
	_data1_->new_board = _tmp1_;
	gtk_widget_set_sensitive ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_data1_->old_board, TYPE_BOARD_VIEW_GTK, BoardViewGtk), FALSE);
	if (fast) {
		_tmp2_ = 500;
	} else {
		_tmp2_ = 1000;
	}
	_tmp3_ = self->priv->stack;
	gtk_stack_set_transition_duration (_tmp3_, (guint) _tmp2_);
	switch (style) {
		case GAME_VIEW_REPLACE_STYLE_RESTART:
		{
			GtkStack* _tmp4_;
			_tmp4_ = self->priv->stack;
			gtk_stack_set_transition_type (_tmp4_, GTK_STACK_TRANSITION_TYPE_SLIDE_DOWN);
			break;
		}
		case GAME_VIEW_REPLACE_STYLE_REFRESH:
		{
			GtkStack* _tmp5_;
			_tmp5_ = self->priv->stack;
			gtk_stack_set_transition_type (_tmp5_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
			break;
		}
		case GAME_VIEW_REPLACE_STYLE_SLIDE_NEXT:
		case GAME_VIEW_REPLACE_STYLE_SLIDE_FORWARD:
		{
			GtkStack* _tmp6_;
			_tmp6_ = self->priv->stack;
			gtk_stack_set_transition_type (_tmp6_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT);
			break;
		}
		case GAME_VIEW_REPLACE_STYLE_SLIDE_BACKWARD:
		{
			GtkStack* _tmp7_;
			_tmp7_ = self->priv->stack;
			gtk_stack_set_transition_type (_tmp7_, GTK_STACK_TRANSITION_TYPE_SLIDE_RIGHT);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp8_ = self->priv->stack;
	gtk_stack_add_child (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (_data1_->new_board, gtk_widget_get_type (), GtkWidget));
	_tmp9_ = self->priv->stack;
	gtk_stack_set_visible_child (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_data1_->new_board, gtk_widget_get_type (), GtkWidget));
	_tmp10_ = gtk_widget_get_display (G_TYPE_CHECK_INSTANCE_CAST (_data1_->new_board, gtk_widget_get_type (), GtkWidget));
	_tmp11_ = gtk_settings_get_for_display (_tmp10_);
	g_object_get (_tmp11_, "gtk-enable-animations", &_tmp12_, NULL);
	_tmp13_ = _tmp12_;
	if (_tmp13_) {
		GQueue* _tmp14_;
		gulong _tmp15_;
		_tmp14_ = self->priv->handlers;
		_tmp15_ = g_signal_connect_data ((GObject*) self, "notify::transition-running", (GCallback) ____lambda5__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		g_queue_push_tail (_tmp14_, (gpointer) ((guintptr) _tmp15_));
	} else {
		gtk_game_view_board_replaced (self, G_TYPE_CHECK_INSTANCE_CAST (_data1_->old_board, TYPE_BOARD_VIEW_GTK, BoardViewGtk), G_TYPE_CHECK_INSTANCE_CAST (_data1_->new_board, TYPE_BOARD_VIEW_GTK, BoardViewGtk));
	}
	g_signal_emit_by_name ((GameView*) self, "level-changed", self->priv->current_level);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

void
gtk_game_view_board_replaced (GtkGameView* self,
                              BoardViewGtk* old_board,
                              BoardViewGtk* new_board)
{
	GtkStack* _tmp0_;
	BoardViewGtk* _tmp1_;
	GQueue* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_board != NULL);
	g_return_if_fail (new_board != NULL);
	_tmp0_ = self->priv->stack;
	gtk_stack_remove (_tmp0_, (GtkWidget*) old_board);
	gtk_widget_set_sensitive ((GtkWidget*) new_board, TRUE);
	_tmp1_ = _g_object_ref0 (new_board);
	_g_object_unref0 (self->priv->board_view);
	self->priv->board_view = _tmp1_;
	_tmp2_ = self->priv->handlers;
	if (!g_queue_is_empty (_tmp2_)) {
		GQueue* _tmp3_;
		gpointer _tmp4_;
		_tmp3_ = self->priv->handlers;
		_tmp4_ = g_queue_pop_head (_tmp3_);
		g_signal_handler_disconnect ((GObject*) self, (gulong) ((guintptr) _tmp4_));
	}
	g_signal_emit_by_name ((GameView*) self, "moves-changed", 0);
}

static gboolean
gtk_game_view_real_hide_cursor (GameView* base)
{
	GtkGameView * self;
	gboolean result;
	self = (GtkGameView*) base;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
gtk_game_view_real_activate_cursor (GameView* base)
{
	GtkGameView * self;
	gboolean result;
	self = (GtkGameView*) base;
	result = FALSE;
	return result;
}

static gboolean
gtk_game_view_real_move_cursor (GameView* base,
                                gint x,
                                gint y)
{
	GtkGameView * self;
	gboolean result;
	self = (GtkGameView*) base;
	result = FALSE;
	return result;
}

static void
gtk_game_view_real_reset_game (GameView* base)
{
	GtkGameView * self;
	BoardView* _tmp0_;
	BoardView* _tmp1_;
	BoardView* _tmp2_;
	BoardView* _tmp3_;
	self = (GtkGameView*) base;
	if (game_view_is_transitioning ((GameView*) self)) {
		return;
	}
	_tmp0_ = game_view_get_board_view ((GameView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_view_create_board_view ((GameView*) self, 1);
	_tmp3_ = _tmp2_;
	game_view_replace_board ((GameView*) self, _tmp1_, _tmp3_, GAME_VIEW_REPLACE_STYLE_RESTART, TRUE);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
}

GtkGameView*
gtk_game_view_construct (GType object_type,
                         gint level)
{
	GtkGameView * self = NULL;
	BoardView* _tmp0_;
	BoardViewGtk* _tmp1_;
	GtkStack* _tmp2_;
	BoardViewGtk* _tmp3_;
	self = (GtkGameView*) g_object_new (object_type, NULL);
	_tmp0_ = game_view_create_board_view ((GameView*) self, level);
	_g_object_unref0 (self->priv->board_view);
	self->priv->board_view = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_BOARD_VIEW_GTK, BoardViewGtk);
	_tmp1_ = self->priv->board_view;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->priv->stack;
	_tmp3_ = self->priv->board_view;
	gtk_stack_add_child (_tmp2_, (GtkWidget*) _tmp3_);
	return self;
}

GtkGameView*
gtk_game_view_new (gint level)
{
	return gtk_game_view_construct (TYPE_GTK_GAME_VIEW, level);
}

static void
_game_view_game_won_cb_board_view_game_won (BoardView* _sender,
                                            gpointer self)
{
	game_view_game_won_cb ((GameView*) self);
}

static void
_gtk_game_view_light_toggled_cb_board_view_light_toggled (BoardView* _sender,
                                                          gpointer self)
{
	gtk_game_view_light_toggled_cb ((GtkGameView*) self);
}

static BoardView*
gtk_game_view_real_create_board_view (GameView* base,
                                      gint level)
{
	GtkGameView * self;
	BoardViewGtk* view = NULL;
	BoardViewGtk* _tmp0_;
	BoardView* _tmp1_;
	BoardView* result;
	self = (GtkGameView*) base;
	self->priv->current_level = level;
	_tmp0_ = board_view_gtk_new ();
	g_object_ref_sink (_tmp0_);
	view = _tmp0_;
	board_view_load_level ((BoardView*) view, level);
	g_signal_connect_object ((BoardView*) view, "game-won", (GCallback) _game_view_game_won_cb_board_view_game_won, (GameView*) self, 0);
	g_signal_connect_object ((BoardView*) view, "light-toggled", (GCallback) _gtk_game_view_light_toggled_cb_board_view_light_toggled, self, 0);
	gtk_widget_set_sensitive ((GtkWidget*) view, TRUE);
	self->priv->_moves = 0;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (view, TYPE_BOARD_VIEW, BoardView));
	result = _tmp1_;
	_g_object_unref0 (view);
	return result;
}

void
gtk_game_view_light_toggled_cb (GtkGameView* self)
{
	g_return_if_fail (self != NULL);
	self->priv->_moves = self->priv->_moves + 1;
	g_signal_emit_by_name ((GameView*) self, "moves-changed", self->priv->_moves);
}

static BoardView*
gtk_game_view_real_get_board_view (GameView* base)
{
	GtkGameView * self;
	BoardViewGtk* _tmp0_;
	BoardView* _tmp1_;
	BoardView* result;
	self = (GtkGameView*) base;
	_tmp0_ = self->priv->board_view;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_BOARD_VIEW, BoardView));
	result = _tmp1_;
	return result;
}

static gint
gtk_game_view_real_next_level (GameView* base,
                               gint direction)
{
	GtkGameView * self;
	gint result;
	self = (GtkGameView*) base;
	self->priv->current_level = self->priv->current_level + direction;
	result = self->priv->current_level;
	return result;
}

static gboolean
gtk_game_view_real_is_transitioning (GameView* base)
{
	GtkGameView * self;
	GtkStack* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	self = (GtkGameView*) base;
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_transition_running (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static GObject *
gtk_game_view_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GtkGameView * self;
	GtkBinLayout* layout = NULL;
	GtkBinLayout* _tmp0_;
	GtkBinLayout* _tmp1_;
	GtkLayoutManager* _tmp2_;
	GtkStack* _tmp3_;
	GtkStack* _tmp4_;
	parent_class = G_OBJECT_CLASS (gtk_game_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GTK_GAME_VIEW, GtkGameView);
	_tmp0_ = (GtkBinLayout*) gtk_bin_layout_new ();
	layout = _tmp0_;
	_tmp1_ = layout;
	_tmp2_ = _g_object_ref0 ((GtkLayoutManager*) _tmp1_);
	gtk_widget_set_layout_manager ((GtkWidget*) self, _tmp2_);
	_tmp3_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp3_;
	_tmp4_ = self->priv->stack;
	gtk_widget_insert_after ((GtkWidget*) _tmp4_, (GtkWidget*) self, NULL);
	_g_object_unref0 (layout);
	return obj;
}

static void
gtk_game_view_class_init (GtkGameViewClass * klass,
                          gpointer klass_data)
{
	gtk_game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GtkGameView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = gtk_game_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = gtk_game_view_finalize;
}

static void
gtk_game_view_game_view_interface_init (GameViewIface * iface,
                                        gpointer iface_data)
{
	gtk_game_view_game_view_parent_iface = g_type_interface_peek_parent (iface);
	iface->replace_board = (void (*) (GameView*, BoardView*, BoardView*, GameViewReplaceStyle, gboolean)) gtk_game_view_real_replace_board;
	iface->hide_cursor = (gboolean (*) (GameView*)) gtk_game_view_real_hide_cursor;
	iface->activate_cursor = (gboolean (*) (GameView*)) gtk_game_view_real_activate_cursor;
	iface->move_cursor = (gboolean (*) (GameView*, gint, gint)) gtk_game_view_real_move_cursor;
	iface->reset_game = (void (*) (GameView*)) gtk_game_view_real_reset_game;
	iface->create_board_view = (BoardView* (*) (GameView*, gint)) gtk_game_view_real_create_board_view;
	iface->get_board_view = (BoardView* (*) (GameView*)) gtk_game_view_real_get_board_view;
	iface->next_level = (gint (*) (GameView*, gint)) gtk_game_view_real_next_level;
	iface->is_transitioning = (gboolean (*) (GameView*)) gtk_game_view_real_is_transitioning;
}

static void
gtk_game_view_instance_init (GtkGameView * self,
                             gpointer klass)
{
	GQueue* _tmp0_;
	self->priv = gtk_game_view_get_instance_private (self);
	_tmp0_ = g_queue_new ();
	self->priv->handlers = _tmp0_;
	self->priv->_moves = 0;
}

static void
gtk_game_view_finalize (GObject * obj)
{
	GtkGameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GTK_GAME_VIEW, GtkGameView);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->board_view);
	(self->priv->handlers == NULL) ? NULL : (self->priv->handlers = (g_queue_free (self->priv->handlers), NULL));
	G_OBJECT_CLASS (gtk_game_view_parent_class)->finalize (obj);
}

static GType
gtk_game_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GtkGameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtk_game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkGameView), 0, (GInstanceInitFunc) gtk_game_view_instance_init, NULL };
	static const GInterfaceInfo game_view_info = { (GInterfaceInitFunc) gtk_game_view_game_view_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gtk_game_view_type_id;
	gtk_game_view_type_id = g_type_register_static (gtk_widget_get_type (), "GtkGameView", &g_define_type_info, 0);
	g_type_add_interface_static (gtk_game_view_type_id, TYPE_GAME_VIEW, &game_view_info);
	GtkGameView_private_offset = g_type_add_instance_private (gtk_game_view_type_id, sizeof (GtkGameViewPrivate));
	return gtk_game_view_type_id;
}

GType
gtk_game_view_get_type (void)
{
	static volatile gsize gtk_game_view_type_id__once = 0;
	if (g_once_init_enter (&gtk_game_view_type_id__once)) {
		GType gtk_game_view_type_id;
		gtk_game_view_type_id = gtk_game_view_get_type_once ();
		g_once_init_leave (&gtk_game_view_type_id__once, gtk_game_view_type_id);
	}
	return gtk_game_view_type_id__once;
}

