/* managed-window.c generated by valac 0.56.18, the Vala compiler
 * generated from managed-window.vala, do not modify */

/*
 * Copyright (C) 2020 Arnaud Bonatti
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>

#define MANAGED_WINDOW_tiled_state ((((GDK_TOPLEVEL_STATE_TILED | GDK_TOPLEVEL_STATE_TOP_TILED) | GDK_TOPLEVEL_STATE_BOTTOM_TILED) | GDK_TOPLEVEL_STATE_LEFT_TILED) | GDK_TOPLEVEL_STATE_RIGHT_TILED)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MANAGED_WINDOW (managed_window_get_type ())
#define MANAGED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MANAGED_WINDOW, ManagedWindow))
#define MANAGED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MANAGED_WINDOW, ManagedWindowClass))
#define IS_MANAGED_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MANAGED_WINDOW))
#define IS_MANAGED_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MANAGED_WINDOW))
#define MANAGED_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MANAGED_WINDOW, ManagedWindowClass))

typedef struct _ManagedWindow ManagedWindow;
typedef struct _ManagedWindowClass ManagedWindowClass;
typedef struct _ManagedWindowPrivate ManagedWindowPrivate;
enum  {
	MANAGED_WINDOW_0_PROPERTY,
	MANAGED_WINDOW_SCHEMA_PATH_PROPERTY,
	MANAGED_WINDOW_NUM_PROPERTIES
};
static GParamSpec* managed_window_properties[MANAGED_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ManagedWindow {
	AdwApplicationWindow parent_instance;
	ManagedWindowPrivate * priv;
};

struct _ManagedWindowClass {
	AdwApplicationWindowClass parent_class;
};

struct _ManagedWindowPrivate {
	gint window_width;
	gint window_height;
	gboolean window_is_maximized;
	gboolean window_is_fullscreen;
	gboolean window_is_tiled;
	GdkToplevel* surface;
	GSettings* settings;
};

static gint ManagedWindow_private_offset;
static gpointer managed_window_parent_class = NULL;

VALA_EXTERN GType managed_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ManagedWindow, g_object_unref)
static inline void managed_window_connect_callbacks (ManagedWindow* self);
static inline void managed_window_init_state_watcher (ManagedWindow* self);
static void _managed_window_init_state_watcher_gtk_widget_map (GtkWidget* _sender,
                                                        gpointer self);
static inline void managed_window_on_unmap (ManagedWindow* self);
static void _managed_window_on_unmap_gtk_widget_unmap (GtkWidget* _sender,
                                                gpointer self);
static inline void managed_window_on_window_state_event (ManagedWindow* self);
static void _managed_window_on_window_state_event_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static inline void managed_window_save_window_state (ManagedWindow* self);
static inline void managed_window_load_window_state (ManagedWindow* self);
VALA_EXTERN ManagedWindow* managed_window_new (void);
VALA_EXTERN ManagedWindow* managed_window_construct (GType object_type);
static void managed_window_set_schema_path (ManagedWindow* self,
                                     const gchar* value);
static GObject * managed_window_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void managed_window_finalize (GObject * obj);
static GType managed_window_get_type_once (void);
static void _vala_managed_window_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);

static inline gpointer
managed_window_get_instance_private (ManagedWindow* self)
{
	return G_STRUCT_MEMBER_P (self, ManagedWindow_private_offset);
}

static void
_managed_window_init_state_watcher_gtk_widget_map (GtkWidget* _sender,
                                                   gpointer self)
{
	managed_window_init_state_watcher ((ManagedWindow*) self);
}

static void
_managed_window_on_unmap_gtk_widget_unmap (GtkWidget* _sender,
                                           gpointer self)
{
	managed_window_on_unmap ((ManagedWindow*) self);
}

static inline void
managed_window_connect_callbacks (ManagedWindow* self)
{
	g_return_if_fail (self != NULL);
	g_signal_connect_object ((GtkWidget*) self, "map", (GCallback) _managed_window_init_state_watcher_gtk_widget_map, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "unmap", (GCallback) _managed_window_on_unmap_gtk_widget_unmap, self, 0);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_managed_window_on_window_state_event_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	managed_window_on_window_state_event ((ManagedWindow*) self);
}

static inline void
managed_window_init_state_watcher (ManagedWindow* self)
{
	GdkSurface* nullable_surface = NULL;
	GdkSurface* _tmp0_;
	GdkSurface* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GdkSurface* _tmp3_;
	GdkSurface* _tmp5_;
	GdkToplevel* _tmp6_;
	GdkToplevel* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_native_get_surface ((GtkNative*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	nullable_surface = _tmp1_;
	_tmp3_ = nullable_surface;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		GdkSurface* _tmp4_;
		_tmp4_ = nullable_surface;
		_tmp2_ = !G_TYPE_CHECK_INSTANCE_TYPE (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gdk_surface_get_type (), GdkSurface), gdk_toplevel_get_type ());
	}
	if (_tmp2_) {
		g_assert_not_reached ();
	}
	_tmp5_ = nullable_surface;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gdk_surface_get_type (), GdkSurface), gdk_toplevel_get_type (), GdkToplevel));
	_g_object_unref0 (self->priv->surface);
	self->priv->surface = _tmp6_;
	_tmp7_ = self->priv->surface;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::state", (GCallback) _managed_window_on_window_state_event_g_object_notify, self, 0);
	_g_object_unref0 (nullable_surface);
}

static inline void
managed_window_on_window_state_event (ManagedWindow* self)
{
	GdkToplevelState state = 0U;
	GdkToplevel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->surface;
	state = gdk_toplevel_get_state (_tmp0_);
	self->priv->window_is_maximized = (state & GDK_TOPLEVEL_STATE_MAXIMIZED) != 0;
	self->priv->window_is_fullscreen = (state & GDK_TOPLEVEL_STATE_FULLSCREEN) != 0;
	self->priv->window_is_tiled = (state & MANAGED_WINDOW_tiled_state) != 0;
}

static inline void
managed_window_on_unmap (ManagedWindow* self)
{
	GtkApplication* _tmp0_;
	GtkApplication* _tmp1_;
	g_return_if_fail (self != NULL);
	managed_window_save_window_state (self);
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	g_application_quit ((GApplication*) _tmp1_);
}

static inline void
managed_window_load_window_state (ManagedWindow* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp0_, "window-is-maximized")) {
		gtk_window_maximize ((GtkWindow*) self);
	}
	_tmp1_ = self->priv->settings;
	_tmp2_ = self->priv->settings;
	gtk_window_set_default_size ((GtkWindow*) self, g_settings_get_int (_tmp1_, "window-width"), g_settings_get_int (_tmp2_, "window-height"));
}

static inline void
managed_window_save_window_state (ManagedWindow* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	g_settings_delay (_tmp0_);
	_tmp1_ = self->priv->settings;
	g_settings_set_int (_tmp1_, "window-width", self->priv->window_width);
	_tmp2_ = self->priv->settings;
	g_settings_set_int (_tmp2_, "window-height", self->priv->window_height);
	if (self->priv->window_is_maximized) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = self->priv->window_is_fullscreen;
	}
	_tmp4_ = self->priv->settings;
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp3_);
	_tmp5_ = self->priv->settings;
	g_settings_apply (_tmp5_);
}

ManagedWindow*
managed_window_construct (GType object_type)
{
	ManagedWindow * self = NULL;
	self = (ManagedWindow*) g_object_new (object_type, NULL);
	return self;
}

ManagedWindow*
managed_window_new (void)
{
	return managed_window_construct (TYPE_MANAGED_WINDOW);
}

static void
managed_window_set_schema_path (ManagedWindow* self,
                                const gchar* value)
{
	gchar* _value = NULL;
	gchar* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_value = _tmp0_;
	if (_value == NULL) {
		g_assert_not_reached ();
	}
	_tmp1_ = g_settings_new_with_path ("org.gnome.LightsOff.Lib", value);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	_tmp2_ = self->priv->settings;
	g_settings_delay (_tmp2_);
	_g_free0 (_value);
}

static GObject *
managed_window_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ManagedWindow * self;
	parent_class = G_OBJECT_CLASS (managed_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MANAGED_WINDOW, ManagedWindow);
	managed_window_connect_callbacks (self);
	managed_window_load_window_state (self);
	return obj;
}

static void
managed_window_class_init (ManagedWindowClass * klass,
                           gpointer klass_data)
{
	managed_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ManagedWindow_private_offset);
	G_OBJECT_CLASS (klass)->set_property = _vala_managed_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = managed_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = managed_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MANAGED_WINDOW_SCHEMA_PATH_PROPERTY, managed_window_properties[MANAGED_WINDOW_SCHEMA_PATH_PROPERTY] = g_param_spec_string ("schema-path", "schema-path", "schema-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
}

static void
managed_window_instance_init (ManagedWindow * self,
                              gpointer klass)
{
	self->priv = managed_window_get_instance_private (self);
	self->priv->window_width = 0;
	self->priv->window_height = 0;
	self->priv->window_is_maximized = FALSE;
	self->priv->window_is_fullscreen = FALSE;
	self->priv->window_is_tiled = FALSE;
}

static void
managed_window_finalize (GObject * obj)
{
	ManagedWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MANAGED_WINDOW, ManagedWindow);
	_g_object_unref0 (self->priv->surface);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (managed_window_parent_class)->finalize (obj);
}

static GType
managed_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ManagedWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) managed_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ManagedWindow), 0, (GInstanceInitFunc) managed_window_instance_init, NULL };
	GType managed_window_type_id;
	managed_window_type_id = g_type_register_static (adw_application_window_get_type (), "ManagedWindow", &g_define_type_info, 0);
	ManagedWindow_private_offset = g_type_add_instance_private (managed_window_type_id, sizeof (ManagedWindowPrivate));
	return managed_window_type_id;
}

GType
managed_window_get_type (void)
{
	static volatile gsize managed_window_type_id__once = 0;
	if (g_once_init_enter (&managed_window_type_id__once)) {
		GType managed_window_type_id;
		managed_window_type_id = managed_window_get_type_once ();
		g_once_init_leave (&managed_window_type_id__once, managed_window_type_id);
	}
	return managed_window_type_id__once;
}

static void
_vala_managed_window_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	ManagedWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MANAGED_WINDOW, ManagedWindow);
	switch (property_id) {
		case MANAGED_WINDOW_SCHEMA_PATH_PROPERTY:
		managed_window_set_schema_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

