/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Property definitions for LLDB.                                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: CoreProperties.td                                                    *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// Property definitions for debugger
#ifdef LLDB_PROPERTIES_debugger
static constexpr PropertyDefinition g_debugger_properties[] = {
  {"auto-confirm", OptionValue::eTypeBoolean, true, 0, nullptr, {}, "If true all confirmation prompts will receive their default reply."},
  {"auto-indent", OptionValue::eTypeBoolean, true, 1, nullptr, {}, "If true, LLDB will auto indent/outdent code. Currently only supported in the REPL (default: true)."},
  {"auto-one-line-summaries", OptionValue::eTypeBoolean, true, 1, nullptr, {}, "If true, LLDB will automatically display small structs in one-liner format (default: true)."},
  {"dwim-print-verbosity", OptionValue::eTypeEnum, true, eDWIMPrintVerbosityNone, nullptr, OptionEnumValues(g_dwim_print_verbosities), "The verbosity level used by dwim-print."},
  {"disassembly-format", OptionValue::eTypeFormatEntity, true, 0, "{${function.initial-function}{${module.file.basename}`}{${function.name-without-args}}:\\n}{${function.changed}\\n{${module.file.basename}`}{${function.name-without-args}}:\\n}{${ansi.fg.yellow}${current-pc-arrow}${ansi.normal} }${addr-file-or-load}{ <${function.concrete-only-addr-offset-no-padding}>}: ", {}, "The default disassembly format string to use when disassembling instruction sequences."},
  {"escape-non-printables", OptionValue::eTypeBoolean, true, 1, nullptr, {}, "If true, LLDB will automatically escape non-printable and escape characters when formatting strings."},
  {"external-editor", OptionValue::eTypeString, true, 0, "", {}, "External editor to use when use-external-editor is enabled."},
  {"frame-format", OptionValue::eTypeFormatEntity, true, 0, "frame #${frame.index}: ${ansi.fg.yellow}${frame.pc}${ansi.normal}{ ${module.file.basename}{`${function.name-with-args}{${frame.no-debug}${function.pc-offset}}}}{ at ${ansi.fg.cyan}${line.file.basename}${ansi.normal}:${ansi.fg.yellow}${line.number}${ansi.normal}{:${ansi.fg.yellow}${line.column}${ansi.normal}}}{${function.is-optimized} [opt]}{${frame.is-artificial} [artificial]}\\n", {}, "The default frame format string to use when displaying stack frame information for threads."},
  {"frame-format-unique", OptionValue::eTypeFormatEntity, true, 0, "frame #${frame.index}: ${ansi.fg.yellow}${frame.pc}${ansi.normal}{ ${module.file.basename}{`${function.name-without-args}{${frame.no-debug}${function.pc-offset}}}}{ at ${ansi.fg.cyan}${line.file.basename}${ansi.normal}:${ansi.fg.yellow}${line.number}${ansi.normal}{:${ansi.fg.yellow}${line.column}${ansi.normal}}}{${function.is-optimized} [opt]}{${frame.is-artificial} [artificial]}\\n", {}, "The default frame format string to use when displaying stack frame information for threads from thread backtrace unique."},
  {"highlight-source", OptionValue::eTypeBoolean, true, 1, nullptr, {}, "If true, LLDB will highlight the displayed source code."},
  {"notify-void", OptionValue::eTypeBoolean, true, 0, nullptr, {}, "Notify the user explicitly if an expression returns void (default: false)."},
  {"print-decls", OptionValue::eTypeBoolean, true, 1, nullptr, {}, "If true, LLDB will print the values of variables declared in an expression. Currently only supported in the REPL (default: true)."},
  {"prompt", OptionValue::eTypeString, true, OptionValueString::eOptionEncodeCharacterEscapeSequences, "(lldb) ", {}, "The debugger command line prompt displayed for the user."},
  {"prompt-ansi-prefix", OptionValue::eTypeString, true, 0, "${ansi.faint}", {}, "When in a color-enabled terminal, use the ANSI terminal code specified in this format immediately before the prompt."},
  {"prompt-ansi-suffix", OptionValue::eTypeString, true, 0, "${ansi.normal}", {}, "When in a color-enabled terminal, use the ANSI terminal code specified in this format immediately after the prompt."},
  {"repl-lang", OptionValue::eTypeLanguage, true, eLanguageTypeUnknown, nullptr, {}, "The language to use for the REPL."},
  {"script-lang", OptionValue::eTypeEnum, true, eScriptLanguagePython, nullptr, OptionEnumValues(g_language_enumerators), "The script language to be used for evaluating user-written scripts."},
  {"show-autosuggestion", OptionValue::eTypeBoolean, true, 0, nullptr, {}, "If true, LLDB will show suggestions to complete the command the user typed. Suggestions may be accepted using Ctrl-F."},
  {"show-autosuggestion-ansi-prefix", OptionValue::eTypeString, true, 0, "${ansi.faint}", {}, "When displaying suggestion in a color-enabled terminal, use the ANSI terminal code specified in this format immediately before the suggestion."},
  {"show-autosuggestion-ansi-suffix", OptionValue::eTypeString, true, 0, "${ansi.normal}", {}, "When displaying suggestion in a color-enabled terminal, use the ANSI terminal code specified in this format immediately after the suggestion."},
  {"show-dont-use-po-hint", OptionValue::eTypeBoolean, true, 1, nullptr, {}, "If true, and object description was requested for a type that does not implement it, LLDB will print a hint telling the user to consider using p instead."},
  {"show-inline-diagnostics", OptionValue::eTypeBoolean, true, 0, nullptr, {}, "Controls whether diagnostics can refer directly to the command input, drawing arrows to it. If false, diagnostics will echo the input."},
  {"show-progress", OptionValue::eTypeBoolean, true, 1, nullptr, {}, "Whether to show progress or not if the debugger's output is an interactive color-enabled terminal."},
  {"show-progress-ansi-prefix", OptionValue::eTypeString, true, 0, "${ansi.faint}", {}, "When displaying progress in a color-enabled terminal, use the ANSI terminal code specified in this format immediately before the progress message."},
  {"show-progress-ansi-suffix", OptionValue::eTypeString, true, 0, "${ansi.normal}", {}, "When displaying progress in a color-enabled terminal, use the ANSI terminal code specified in this format immediately after the progress message."},
  {"show-regex-match-ansi-prefix", OptionValue::eTypeString, true, 0, "${ansi.fg.red}", {}, "When displaying a regex match in a color-enabled terminal, use the ANSI terminal code specified in this format immediately before the match."},
  {"show-regex-match-ansi-suffix", OptionValue::eTypeString, true, 0, "${ansi.normal}", {}, "When displaying a regex match in a color-enabled terminal, use the ANSI terminal code specified in this format immediately after the match."},
  {"stop-disassembly-count", OptionValue::eTypeUInt64, true, 4, nullptr, {}, "The number of disassembly lines to show when displaying a stopped context."},
  {"stop-disassembly-display", OptionValue::eTypeEnum, true, Debugger::eStopDisassemblyTypeNoDebugInfo, nullptr, OptionEnumValues(g_show_disassembly_enum_values), "Control when to display disassembly when displaying a stopped context."},
  {"stop-disassembly-max-size", OptionValue::eTypeUInt64, true, 32000, nullptr, {}, "The size limit to use when disassembling large functions (default: 32KB)."},
  {"stop-line-count-after", OptionValue::eTypeUInt64, true, 3, nullptr, {}, "The number of sources lines to display that come after the current source line when displaying a stopped context."},
  {"stop-line-count-before", OptionValue::eTypeUInt64, true, 3, nullptr, {}, "The number of sources lines to display that come before the current source line when displaying a stopped context."},
  {"stop-show-column", OptionValue::eTypeEnum, false, eStopShowColumnAnsiOrCaret, nullptr, OptionEnumValues(s_stop_show_column_values), "If true, LLDB will use the column information from the debug info to mark the current position when displaying a stopped context."},
  {"stop-show-column-ansi-prefix", OptionValue::eTypeString, true, 0, "${ansi.underline}", {}, "When displaying the column marker in a color-enabled terminal, use the ANSI terminal code specified in this format at the immediately before the column to be marked."},
  {"stop-show-column-ansi-suffix", OptionValue::eTypeString, true, 0, "${ansi.normal}", {}, "When displaying the column marker in a color-enabled terminal, use the ANSI terminal code specified in this format immediately after the column to be marked."},
  {"stop-show-line-ansi-prefix", OptionValue::eTypeString, true, 0, "${ansi.fg.yellow}", {}, "When displaying the line marker in a color-enabled terminal, use the ANSI terminal code specified in this format at the immediately before the line to be marked."},
  {"stop-show-line-ansi-suffix", OptionValue::eTypeString, true, 0, "${ansi.normal}", {}, "When displaying the line marker in a color-enabled terminal, use the ANSI terminal code specified in this format immediately after the line to be marked."},
  {"tab-size", OptionValue::eTypeUInt64, true, 2, nullptr, {}, "The tab size to use when indenting code in multi-line input mode (default: 2)."},
  {"term-height", OptionValue::eTypeUInt64, true, 24, nullptr, {}, "The number of rows used for displaying text."},
  {"term-width", OptionValue::eTypeUInt64, true, 80, nullptr, {}, "The maximum number of columns to use for displaying text."},
  {"thread-format", OptionValue::eTypeFormatEntity, true, 0, "thread #${thread.index}: tid = ${thread.id%tid}{, ${frame.pc}}{ ${module.file.basename}{`${function.name-with-args}{${frame.no-debug}${function.pc-offset}}}}{ at ${ansi.fg.cyan}${line.file.basename}${ansi.normal}:${ansi.fg.yellow}${line.number}${ansi.normal}{:${ansi.fg.yellow}${line.column}${ansi.normal}}}{, name = ${ansi.fg.green}'${thread.name}'${ansi.normal}}{, queue = ${ansi.fg.green}'${thread.queue}'${ansi.normal}}{, activity = ${ansi.fg.green}'${thread.info.activity.name}'${ansi.normal}}{, ${thread.info.trace_messages} messages}{, stop reason = ${ansi.fg.red}${thread.stop-reason}${ansi.normal}}{\\nReturn value: ${thread.return-value}}{\\nCompleted expression: ${thread.completed-expression}}\\n", {}, "The default thread format string to use when displaying thread information."},
  {"thread-stop-format", OptionValue::eTypeFormatEntity, true, 0, "thread #${thread.index}{, name = '${thread.name}'}{, queue = ${ansi.fg.green}'${thread.queue}'${ansi.normal}}{, activity = ${ansi.fg.green}'${thread.info.activity.name}'${ansi.normal}}{, ${thread.info.trace_messages} messages}{, stop reason = ${ansi.fg.red}${thread.stop-reason}${ansi.normal}}{\\nReturn value: ${thread.return-value}}{\\nCompleted expression: ${thread.completed-expression}}\\n", {}, "The default thread format  string to use when displaying thread information as part of the stop display."},
  {"use-color", OptionValue::eTypeBoolean, true, 1, nullptr, {}, "Whether to use Ansi color codes or not."},
  {"use-external-editor", OptionValue::eTypeBoolean, true, 0, nullptr, {}, "Whether to use an external editor or not."},
  {"use-source-cache", OptionValue::eTypeBoolean, true, 1, nullptr, {}, "Whether to cache source files in memory or not."},
};
#undef LLDB_PROPERTIES_debugger
#endif // debugger Property

// Property definitions for modulelist
#ifdef LLDB_PROPERTIES_modulelist
static constexpr PropertyDefinition g_modulelist_properties[] = {
  {"auto-download", OptionValue::eTypeEnum, true, eSymbolDownloadOff, nullptr, OptionEnumValues(g_auto_download_enum_values), "On macOS, automatically download symbols with dsymForUUID (or an equivalent script/binary) for relevant images in the debug session."},
  {"clang-modules-cache-path", OptionValue::eTypeFileSpec, true, 0, "", {}, "The path to the clang modules cache directory (-fmodules-cache-path)."},
  {"enable-background-lookup", OptionValue::eTypeBoolean, true, 0, nullptr, {}, "Alias for backward compatibility: when enabled this is the equivalent to 'symbols.auto-download background'."},
  {"enable-external-lookup", OptionValue::eTypeBoolean, true, 1, nullptr, {}, "Control the use of external tools and repositories to locate symbol files. Directories listed in target.debug-file-search-paths and directory of the executable are always checked first for separate debug info files. Then depending on this setting: On macOS, Spotlight would be also used to locate a matching .dSYM bundle based on the UUID of the executable. On NetBSD, directory /usr/libdata/debug would be also searched. On platforms other than NetBSD directory /usr/lib/debug would be also searched. If all other methods fail there may be symbol-locator plugins that, if configured properly, will also attempt to acquire symbols. The debuginfod plugin defaults to the DEGUFINFOD_URLS environment variable which is configurable through the 'plugin.symbol-locator.debuginfod.server_urls' setting."},
  {"enable-lldb-index-cache", OptionValue::eTypeBoolean, true, 0, nullptr, {}, "Enable caching for debug sessions in LLDB. LLDB can cache data for each module for improved performance in subsequent debug sessions."},
  {"lldb-index-cache-expiration-days", OptionValue::eTypeUInt64, true, 7, nullptr, {}, "The expiration time in days for a file. When a file hasn't been accessed for the specified amount of days, it is removed from the cache. A value of 0 disables the expiration-based pruning."},
  {"lldb-index-cache-max-byte-size", OptionValue::eTypeUInt64, true, 0, nullptr, {}, "The maximum size for the LLDB index cache directory in bytes. A value over the amount of available space on the disk will be reduced to the amount of available space. A value of 0 disables the absolute size-based pruning."},
  {"lldb-index-cache-max-percent", OptionValue::eTypeUInt64, true, 0, nullptr, {}, "The maximum size for the cache directory in terms of percentage of the available space on the disk. Set to 100 to indicate no limit, 50 to indicate that the cache size will not be left over half the available disk space. A value over 100 will be reduced to 100. A value of 0 disables the percentage size-based pruning."},
  {"lldb-index-cache-path", OptionValue::eTypeFileSpec, true, 0, "", {}, "The path to the LLDB index cache directory."},
  {"load-on-demand", OptionValue::eTypeBoolean, true, 0, nullptr, {}, "Enable on demand symbol loading in LLDB. LLDB will load debug info on demand for each module based on various conditions (e.g. matched breakpoint, resolved stack frame addresses and matched global variables/function symbols in symbol table) to improve performance. Please refer to docs/use/ondemand.rst for details."},
  {"debug-info-symlink-paths", OptionValue::eTypeFileSpecList, true, 0, "", {}, "Debug info path which should be resolved while parsing, relative to the host filesystem."},
};
#undef LLDB_PROPERTIES_modulelist
#endif // modulelist Property

