/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the AMDGPU target                          *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 77;
using PredicateBitset = llvm::PredicateBitsetImpl<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(AMDGPUInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(AMDGPUInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ISelInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ISelInfo;
  static AMDGPUInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static AMDGPUInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const int64_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const std::array<const MachineOperand *, 3> &Operands) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(3),
ISelInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_isGFX6Bit = 29,
  Feature_isGFX6GFX7Bit = 4,
  Feature_isGFX6GFX7GFX10Bit = 62,
  Feature_isGFX6GFX7GFX10PlusBit = 61,
  Feature_isGFX7OnlyBit = 48,
  Feature_isGFX7GFX8GFX9Bit = 24,
  Feature_isGFX6GFX7GFX8GFX9Bit = 38,
  Feature_isGFX6GFX7GFX8GFX9GFX10Bit = 75,
  Feature_isGFX7PlusBit = 6,
  Feature_isGFX8PlusBit = 2,
  Feature_isGFX8OnlyBit = 11,
  Feature_isGFX9PlusBit = 1,
  Feature_isGFX90APlusBit = 20,
  Feature_isNotGFX90APlusBit = 12,
  Feature_isGFX908orGFX90ABit = 19,
  Feature_isGFX940PlusBit = 21,
  Feature_isGFX8GFX9Bit = 7,
  Feature_isGFX10OnlyBit = 35,
  Feature_isGFX10PlusBit = 3,
  Feature_isGFX9GFX10Bit = 44,
  Feature_isGFX11OnlyBit = 36,
  Feature_isGFX11PlusBit = 0,
  Feature_HasFlatAddressSpaceBit = 50,
  Feature_HasFlatGlobalInstsBit = 51,
  Feature_HasFlatScratchInstsBit = 56,
  Feature_HasD16LoadStoreBit = 52,
  Feature_HasFlatScratchSVSModeBit = 57,
  Feature_HasGFX10_BEncodingBit = 28,
  Feature_HasUnpackedD16VMemBit = 59,
  Feature_HasPackedD16VMemBit = 60,
  Feature_D16PreservesUnusedBitsBit = 53,
  Feature_LDSRequiresM0InitBit = 72,
  Feature_NotLDSRequiresM0InitBit = 73,
  Feature_HasLDSFPAtomicAddBit = 76,
  Feature_HasAddNoCarryInstsBit = 37,
  Feature_NotHasAddNoCarryInstsBit = 71,
  Feature_Has16BitInstsBit = 5,
  Feature_HasVOP3PInstsBit = 45,
  Feature_HasMinMaxDenormModesBit = 66,
  Feature_NotHasMinMaxDenormModesBit = 68,
  Feature_HasPackedFP32OpsBit = 22,
  Feature_HasIntClampBit = 43,
  Feature_HasMadMixInstsBit = 46,
  Feature_HasScalarStoresBit = 25,
  Feature_has16BankLDSBit = 31,
  Feature_has32BankLDSBit = 13,
  Feature_HasFmaMixInstsBit = 47,
  Feature_HasDLInstsBit = 8,
  Feature_HasDot1InstsBit = 17,
  Feature_HasDot2InstsBit = 15,
  Feature_HasDot3InstsBit = 42,
  Feature_HasDot4InstsBit = 41,
  Feature_HasDot5InstsBit = 39,
  Feature_HasDot6InstsBit = 40,
  Feature_HasDot7InstsBit = 16,
  Feature_HasDot8InstsBit = 14,
  Feature_HasGetWaveIdInstBit = 27,
  Feature_HasMAIInstsBit = 18,
  Feature_HasSMemRealTimeBit = 26,
  Feature_HasSMemTimeInstBit = 23,
  Feature_HasShaderCyclesRegisterBit = 49,
  Feature_HasMadMacF32InstsBit = 9,
  Feature_HasFmaLegacy32Bit = 10,
  Feature_HasAtomicFaddRtnInstsBit = 30,
  Feature_HasAtomicFaddNoRtnInstsBit = 54,
  Feature_HasAtomicPkFaddNoRtnInstsBit = 58,
  Feature_EnableLateCFGStructurizeBit = 32,
  Feature_EnableFlatScratchBit = 55,
  Feature_DisableFlatScratchBit = 63,
  Feature_HasUnalignedAccessModeBit = 74,
  Feature_FalsePredicateBit = 67,
  Feature_FP16DenormalsBit = 70,
  Feature_FP64DenormalsBit = 69,
  Feature_NoFP32DenormalsBit = 65,
  Feature_UnsafeFPMathBit = 64,
  Feature_isWave32Bit = 33,
  Feature_isWave64Bit = 34,
};

PredicateBitset AMDGPUInstructionSelector::
computeAvailableModuleFeatures(const AMDGPUSubtarget *Subtarget) const {
  PredicateBitset Features;
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS)
    Features.set(Feature_isGFX6Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX6GFX7Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX6GFX7GFX10Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() >= AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX6GFX7GFX10PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX7OnlyBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX7GFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX6GFX7GFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX6GFX7GFX8GFX9GFX10Bit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX7PlusBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
    Features.set(Feature_isGFX8PlusBit);
  if (Subtarget->getGeneration() ==AMDGPUSubtarget::VOLCANIC_ISLANDS)
    Features.set(Feature_isGFX8OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX9PlusBit);
  if (Subtarget->hasGFX90AInsts())
    Features.set(Feature_isGFX90APlusBit);
  if (!Subtarget->hasGFX90AInsts())
    Features.set(Feature_isNotGFX90APlusBit);
  if (Subtarget->hasMAIInsts() && !Subtarget->hasGFX940Insts())
    Features.set(Feature_isGFX908orGFX90ABit);
  if (Subtarget->hasGFX940Insts())
    Features.set(Feature_isGFX940PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX10OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX10PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX9 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX9GFX10Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX11)
    Features.set(Feature_isGFX11OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX11)
    Features.set(Feature_isGFX11PlusBit);
  if (Subtarget->hasFlatAddressSpace())
    Features.set(Feature_HasFlatAddressSpaceBit);
  if (Subtarget->hasFlatGlobalInsts())
    Features.set(Feature_HasFlatGlobalInstsBit);
  if (Subtarget->hasFlatScratchInsts())
    Features.set(Feature_HasFlatScratchInstsBit);
  if (Subtarget->hasD16LoadStore())
    Features.set(Feature_HasD16LoadStoreBit);
  if (Subtarget->hasFlatScratchSVSMode())
    Features.set(Feature_HasFlatScratchSVSModeBit);
  if (Subtarget->hasGFX10_BEncoding())
    Features.set(Feature_HasGFX10_BEncodingBit);
  if (Subtarget->hasUnpackedD16VMem())
    Features.set(Feature_HasUnpackedD16VMemBit);
  if (!Subtarget->hasUnpackedD16VMem())
    Features.set(Feature_HasPackedD16VMemBit);
  if (Subtarget->d16PreservesUnusedBits())
    Features.set(Feature_D16PreservesUnusedBitsBit);
  if (Subtarget->ldsRequiresM0Init())
    Features.set(Feature_LDSRequiresM0InitBit);
  if (!Subtarget->ldsRequiresM0Init())
    Features.set(Feature_NotLDSRequiresM0InitBit);
  if (Subtarget->hasLDSFPAtomicAdd())
    Features.set(Feature_HasLDSFPAtomicAddBit);
  if (Subtarget->hasAddNoCarry())
    Features.set(Feature_HasAddNoCarryInstsBit);
  if (!Subtarget->hasAddNoCarry())
    Features.set(Feature_NotHasAddNoCarryInstsBit);
  if (Subtarget->has16BitInsts())
    Features.set(Feature_Has16BitInstsBit);
  if (Subtarget->hasVOP3PInsts())
    Features.set(Feature_HasVOP3PInstsBit);
  if (Subtarget->supportsMinMaxDenormModes())
    Features.set(Feature_HasMinMaxDenormModesBit);
  if (!Subtarget->supportsMinMaxDenormModes())
    Features.set(Feature_NotHasMinMaxDenormModesBit);
  if (Subtarget->hasPackedFP32Ops())
    Features.set(Feature_HasPackedFP32OpsBit);
  if (Subtarget->hasIntClamp())
    Features.set(Feature_HasIntClampBit);
  if (Subtarget->hasMadMixInsts())
    Features.set(Feature_HasMadMixInstsBit);
  if (Subtarget->hasScalarStores())
    Features.set(Feature_HasScalarStoresBit);
  if (Subtarget->getLDSBankCount() == 16)
    Features.set(Feature_has16BankLDSBit);
  if (Subtarget->getLDSBankCount() == 32)
    Features.set(Feature_has32BankLDSBit);
  if (Subtarget->hasFmaMixInsts())
    Features.set(Feature_HasFmaMixInstsBit);
  if (Subtarget->hasDLInsts())
    Features.set(Feature_HasDLInstsBit);
  if (Subtarget->hasDot1Insts())
    Features.set(Feature_HasDot1InstsBit);
  if (Subtarget->hasDot2Insts())
    Features.set(Feature_HasDot2InstsBit);
  if (Subtarget->hasDot3Insts())
    Features.set(Feature_HasDot3InstsBit);
  if (Subtarget->hasDot4Insts())
    Features.set(Feature_HasDot4InstsBit);
  if (Subtarget->hasDot5Insts())
    Features.set(Feature_HasDot5InstsBit);
  if (Subtarget->hasDot6Insts())
    Features.set(Feature_HasDot6InstsBit);
  if (Subtarget->hasDot7Insts())
    Features.set(Feature_HasDot7InstsBit);
  if (Subtarget->hasDot8Insts())
    Features.set(Feature_HasDot8InstsBit);
  if (Subtarget->hasGetWaveIdInst())
    Features.set(Feature_HasGetWaveIdInstBit);
  if (Subtarget->hasMAIInsts())
    Features.set(Feature_HasMAIInstsBit);
  if (Subtarget->hasSMemRealTime())
    Features.set(Feature_HasSMemRealTimeBit);
  if (Subtarget->hasSMemTimeInst())
    Features.set(Feature_HasSMemTimeInstBit);
  if (Subtarget->hasShaderCyclesRegister())
    Features.set(Feature_HasShaderCyclesRegisterBit);
  if (Subtarget->hasMadMacF32Insts())
    Features.set(Feature_HasMadMacF32InstsBit);
  if (Subtarget->hasGFX10_3Insts())
    Features.set(Feature_HasFmaLegacy32Bit);
  if (Subtarget->hasAtomicFaddRtnInsts())
    Features.set(Feature_HasAtomicFaddRtnInstsBit);
  if (Subtarget->hasAtomicFaddNoRtnInsts())
    Features.set(Feature_HasAtomicFaddNoRtnInstsBit);
  if (Subtarget->hasAtomicPkFaddNoRtnInsts())
    Features.set(Feature_HasAtomicPkFaddNoRtnInstsBit);
  if (EnableLateStructurizeCFG)
    Features.set(Feature_EnableLateCFGStructurizeBit);
  if (Subtarget->enableFlatScratch())
    Features.set(Feature_EnableFlatScratchBit);
  if (!Subtarget->enableFlatScratch())
    Features.set(Feature_DisableFlatScratchBit);
  if (Subtarget->hasUnalignedAccessMode())
    Features.set(Feature_HasUnalignedAccessModeBit);
  if (false)
    Features.set(Feature_FalsePredicateBit);
  if (Subtarget->getWavefrontSize() == 32)
    Features.set(Feature_isWave32Bit);
  if (Subtarget->getWavefrontSize() == 64)
    Features.set(Feature_isWave64Bit);
  return Features;
}

void AMDGPUInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const AMDGPUSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset AMDGPUInstructionSelector::
computeAvailableFunctionFeatures(const AMDGPUSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  if (MF->getInfo<SIMachineFunctionInfo>()->getMode().allFP64FP16Denormals())
    Features.set(Feature_FP16DenormalsBit);
  if (MF->getInfo<SIMachineFunctionInfo>()->getMode().allFP64FP16Denormals())
    Features.set(Feature_FP64DenormalsBit);
  if (!MF->getInfo<SIMachineFunctionInfo>()->getMode().allFP32Denormals())
    Features.set(Feature_NoFP32DenormalsBit);
  if (TM.Options.UnsafeFPMath)
    Features.set(Feature_UnsafeFPMathBit);
  return Features;
}

// LLT Objects.
enum {
  GILLT_p0s64,
  GILLT_p1s64,
  GILLT_p2s32,
  GILLT_p3s32,
  GILLT_p4s64,
  GILLT_p5s32,
  GILLT_p6s32,
  GILLT_s1,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s16,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v3s32,
  GILLT_v3s64,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v4s64,
  GILLT_v5s32,
  GILLT_v6s32,
  GILLT_v7s32,
  GILLT_v8s16,
  GILLT_v8s32,
  GILLT_v8s64,
  GILLT_v16s16,
  GILLT_v16s32,
  GILLT_v16s64,
  GILLT_v32s32,
};
const static size_t NumTypeObjects = 29;
const static LLT TypeObjects[] = {
  LLT::pointer(0, 64),
  LLT::pointer(1, 64),
  LLT::pointer(2, 32),
  LLT::pointer(3, 32),
  LLT::pointer(4, 64),
  LLT::pointer(5, 32),
  LLT::pointer(6, 32),
  LLT::scalar(1),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getFixed(2), 16),
  LLT::vector(ElementCount::getFixed(2), 32),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(3), 32),
  LLT::vector(ElementCount::getFixed(3), 64),
  LLT::vector(ElementCount::getFixed(4), 16),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(4), 64),
  LLT::vector(ElementCount::getFixed(5), 32),
  LLT::vector(ElementCount::getFixed(6), 32),
  LLT::vector(ElementCount::getFixed(7), 32),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(8), 32),
  LLT::vector(ElementCount::getFixed(8), 64),
  LLT::vector(ElementCount::getFixed(16), 16),
  LLT::vector(ElementCount::getFixed(16), 32),
  LLT::vector(ElementCount::getFixed(16), 64),
  LLT::vector(ElementCount::getFixed(32), 32),
};

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_DisableFlatScratch,
  GIFBS_Has16BitInsts,
  GIFBS_HasAddNoCarryInsts,
  GIFBS_HasAtomicFaddNoRtnInsts,
  GIFBS_HasAtomicFaddRtnInsts,
  GIFBS_HasAtomicPkFaddNoRtnInsts,
  GIFBS_HasD16LoadStore,
  GIFBS_HasDLInsts,
  GIFBS_HasDot1Insts,
  GIFBS_HasDot2Insts,
  GIFBS_HasDot7Insts,
  GIFBS_HasDot8Insts,
  GIFBS_HasFlatAddressSpace,
  GIFBS_HasFlatGlobalInsts,
  GIFBS_HasFmaLegacy32,
  GIFBS_HasGFX10_BEncoding,
  GIFBS_HasGetWaveIdInst,
  GIFBS_HasIntClamp,
  GIFBS_HasLDSFPAtomicAdd,
  GIFBS_HasMAIInsts,
  GIFBS_HasMadMacF32Insts,
  GIFBS_HasMinMaxDenormModes,
  GIFBS_HasPackedD16VMem,
  GIFBS_HasPackedFP32Ops,
  GIFBS_HasSMemRealTime,
  GIFBS_HasSMemTimeInst,
  GIFBS_HasShaderCyclesRegister,
  GIFBS_HasUnpackedD16VMem,
  GIFBS_HasVOP3PInsts,
  GIFBS_LDSRequiresM0Init,
  GIFBS_NotHasAddNoCarryInsts,
  GIFBS_NotLDSRequiresM0Init,
  GIFBS_UnsafeFPMath,
  GIFBS_isGFX10Only,
  GIFBS_isGFX10Plus,
  GIFBS_isGFX11Only,
  GIFBS_isGFX11Plus,
  GIFBS_isGFX6,
  GIFBS_isGFX6GFX7,
  GIFBS_isGFX6GFX7GFX10,
  GIFBS_isGFX6GFX7GFX10Plus,
  GIFBS_isGFX6GFX7GFX8GFX9GFX10,
  GIFBS_isGFX7GFX8GFX9,
  GIFBS_isGFX7Only,
  GIFBS_isGFX7Plus,
  GIFBS_isGFX8GFX9,
  GIFBS_isGFX8Plus,
  GIFBS_isGFX908orGFX90A,
  GIFBS_isGFX90APlus,
  GIFBS_isGFX940Plus,
  GIFBS_isGFX9Plus,
  GIFBS_isNotGFX90APlus,
  GIFBS_isWave32,
  GIFBS_isWave64,
  GIFBS_DisableFlatScratch_HasD16LoadStore,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts,
  GIFBS_FP16Denormals_NotHasMinMaxDenormModes,
  GIFBS_FP64Denormals_NotHasMinMaxDenormModes,
  GIFBS_FalsePredicate_NotHasMinMaxDenormModes,
  GIFBS_Has16BitInsts_HasIntClamp,
  GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9,
  GIFBS_Has16BitInsts_isGFX8GFX9,
  GIFBS_Has16BitInsts_isGFX8Only,
  GIFBS_Has16BitInsts_isGFX9Plus,
  GIFBS_Has16BitInsts_isNotGFX90APlus,
  GIFBS_HasAddNoCarryInsts_HasIntClamp,
  GIFBS_HasLDSFPAtomicAdd_LDSRequiresM0Init,
  GIFBS_HasLDSFPAtomicAdd_NotLDSRequiresM0Init,
  GIFBS_HasMadMacF32Insts_NoFP32Denormals,
  GIFBS_HasScalarStores_isGFX8Plus,
  GIFBS_HasUnalignedAccessMode_LDSRequiresM0Init,
  GIFBS_HasUnalignedAccessMode_NotLDSRequiresM0Init,
  GIFBS_LDSRequiresM0Init_isGFX6GFX7GFX8GFX9GFX10,
  GIFBS_LDSRequiresM0Init_isGFX7Plus,
  GIFBS_NotLDSRequiresM0Init_isGFX6GFX7GFX8GFX9GFX10,
  GIFBS_NotLDSRequiresM0Init_isGFX7Plus,
  GIFBS_has16BankLDS_isNotGFX90APlus,
  GIFBS_has32BankLDS_isNotGFX90APlus,
  GIFBS_EnableFlatScratch_HasD16LoadStore_HasFlatScratchInsts,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode,
  GIFBS_Has16BitInsts_has32BankLDS_isNotGFX90APlus,
  GIFBS_HasMadMacF32Insts_NoFP32Denormals_isGFX6GFX7GFX10,
  GIFBS_EnableFlatScratch_HasD16LoadStore_HasFlatScratchInsts_HasFlatScratchSVSMode,
};
const static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_DisableFlatScratchBit, },
  {Feature_Has16BitInstsBit, },
  {Feature_HasAddNoCarryInstsBit, },
  {Feature_HasAtomicFaddNoRtnInstsBit, },
  {Feature_HasAtomicFaddRtnInstsBit, },
  {Feature_HasAtomicPkFaddNoRtnInstsBit, },
  {Feature_HasD16LoadStoreBit, },
  {Feature_HasDLInstsBit, },
  {Feature_HasDot1InstsBit, },
  {Feature_HasDot2InstsBit, },
  {Feature_HasDot7InstsBit, },
  {Feature_HasDot8InstsBit, },
  {Feature_HasFlatAddressSpaceBit, },
  {Feature_HasFlatGlobalInstsBit, },
  {Feature_HasFmaLegacy32Bit, },
  {Feature_HasGFX10_BEncodingBit, },
  {Feature_HasGetWaveIdInstBit, },
  {Feature_HasIntClampBit, },
  {Feature_HasLDSFPAtomicAddBit, },
  {Feature_HasMAIInstsBit, },
  {Feature_HasMadMacF32InstsBit, },
  {Feature_HasMinMaxDenormModesBit, },
  {Feature_HasPackedD16VMemBit, },
  {Feature_HasPackedFP32OpsBit, },
  {Feature_HasSMemRealTimeBit, },
  {Feature_HasSMemTimeInstBit, },
  {Feature_HasShaderCyclesRegisterBit, },
  {Feature_HasUnpackedD16VMemBit, },
  {Feature_HasVOP3PInstsBit, },
  {Feature_LDSRequiresM0InitBit, },
  {Feature_NotHasAddNoCarryInstsBit, },
  {Feature_NotLDSRequiresM0InitBit, },
  {Feature_UnsafeFPMathBit, },
  {Feature_isGFX10OnlyBit, },
  {Feature_isGFX10PlusBit, },
  {Feature_isGFX11OnlyBit, },
  {Feature_isGFX11PlusBit, },
  {Feature_isGFX6Bit, },
  {Feature_isGFX6GFX7Bit, },
  {Feature_isGFX6GFX7GFX10Bit, },
  {Feature_isGFX6GFX7GFX10PlusBit, },
  {Feature_isGFX6GFX7GFX8GFX9GFX10Bit, },
  {Feature_isGFX7GFX8GFX9Bit, },
  {Feature_isGFX7OnlyBit, },
  {Feature_isGFX7PlusBit, },
  {Feature_isGFX8GFX9Bit, },
  {Feature_isGFX8PlusBit, },
  {Feature_isGFX908orGFX90ABit, },
  {Feature_isGFX90APlusBit, },
  {Feature_isGFX940PlusBit, },
  {Feature_isGFX9PlusBit, },
  {Feature_isNotGFX90APlusBit, },
  {Feature_isWave32Bit, },
  {Feature_isWave64Bit, },
  {Feature_DisableFlatScratchBit, Feature_HasD16LoadStoreBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, },
  {Feature_FP16DenormalsBit, Feature_NotHasMinMaxDenormModesBit, },
  {Feature_FP64DenormalsBit, Feature_NotHasMinMaxDenormModesBit, },
  {Feature_FalsePredicateBit, Feature_NotHasMinMaxDenormModesBit, },
  {Feature_Has16BitInstsBit, Feature_HasIntClampBit, },
  {Feature_Has16BitInstsBit, Feature_isGFX6GFX7GFX8GFX9Bit, },
  {Feature_Has16BitInstsBit, Feature_isGFX8GFX9Bit, },
  {Feature_Has16BitInstsBit, Feature_isGFX8OnlyBit, },
  {Feature_Has16BitInstsBit, Feature_isGFX9PlusBit, },
  {Feature_Has16BitInstsBit, Feature_isNotGFX90APlusBit, },
  {Feature_HasAddNoCarryInstsBit, Feature_HasIntClampBit, },
  {Feature_HasLDSFPAtomicAddBit, Feature_LDSRequiresM0InitBit, },
  {Feature_HasLDSFPAtomicAddBit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_HasMadMacF32InstsBit, Feature_NoFP32DenormalsBit, },
  {Feature_HasScalarStoresBit, Feature_isGFX8PlusBit, },
  {Feature_HasUnalignedAccessModeBit, Feature_LDSRequiresM0InitBit, },
  {Feature_HasUnalignedAccessModeBit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_LDSRequiresM0InitBit, Feature_isGFX6GFX7GFX8GFX9GFX10Bit, },
  {Feature_LDSRequiresM0InitBit, Feature_isGFX7PlusBit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_isGFX6GFX7GFX8GFX9GFX10Bit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_isGFX7PlusBit, },
  {Feature_has16BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_has32BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_EnableFlatScratchBit, Feature_HasD16LoadStoreBit, Feature_HasFlatScratchInstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, },
  {Feature_Has16BitInstsBit, Feature_has32BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_HasMadMacF32InstsBit, Feature_NoFP32DenormalsBit, Feature_isGFX6GFX7GFX10Bit, },
  {Feature_EnableFlatScratchBit, Feature_HasD16LoadStoreBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
  GICP_gi_dotiuvop3pmods,
  GICP_gi_ds_128bit_8byte_aligned,
  GICP_gi_ds_1addr_1offset,
  GICP_gi_ds_64bit_4byte_aligned,
  GICP_gi_flat_offset,
  GICP_gi_flat_scratch_offset,
  GICP_gi_flat_scratch_saddr,
  GICP_gi_flat_scratch_svaddr,
  GICP_gi_global_offset,
  GICP_gi_global_saddr,
  GICP_gi_mubuf_addr64,
  GICP_gi_mubuf_offset,
  GICP_gi_mubuf_scratch_offen,
  GICP_gi_mubuf_scratch_offset,
  GICP_gi_smrd_buffer_imm,
  GICP_gi_smrd_buffer_imm32,
  GICP_gi_smrd_imm,
  GICP_gi_smrd_imm32,
  GICP_gi_smrd_sgpr,
  GICP_gi_smrd_sgpr_imm,
  GICP_gi_vcsrc,
  GICP_gi_vinterpmods,
  GICP_gi_vinterpmods_hi,
  GICP_gi_vop3_no_mods,
  GICP_gi_vop3mods,
  GICP_gi_vop3mods0,
  GICP_gi_vop3mods_nnan,
  GICP_gi_vop3omods,
  GICP_gi_vop3opsel,
  GICP_gi_vop3opselmods,
  GICP_gi_vop3pmods,
  GICP_gi_vop3pmodsdot,
  GICP_gi_vsrc0,
  GICP_gi_wmmaopselvop3pmods,
};
// See constructor for table contents

// PatFrag predicates.
enum {
  GIPFP_I64_Predicate_IMMZeroBasedBitfieldMask = GIPFP_I64_Invalid + 1,
  GIPFP_I64_Predicate_InlineImm16,
  GIPFP_I64_Predicate_InlineImm32,
  GIPFP_I64_Predicate_InlineImm64,
  GIPFP_I64_Predicate_NegSubInlineConst32,
  GIPFP_I64_Predicate_NegSubInlineIntConst16,
  GIPFP_I64_Predicate_SIMM16bit,
  GIPFP_I64_Predicate_ShiftAmt32Imm,
  GIPFP_I64_Predicate_UIMM16bit,
  GIPFP_I64_Predicate_i64imm_32bit,
};
bool AMDGPUInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GIPFP_I64_Predicate_IMMZeroBasedBitfieldMask: {
    
  return isMask_32(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_InlineImm16: {
    
  return isInlineImmediate16(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_InlineImm32: {
    
  return isInlineImmediate32(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_InlineImm64: {
    
  return isInlineImmediate64(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_NegSubInlineConst32: {
    
  return Imm < -16 && Imm >= -64;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_NegSubInlineIntConst16: {
    
  return Imm < -16 && Imm >= -64;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_SIMM16bit: {
    return isInt<16>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_ShiftAmt32Imm: {
    
  return Imm < 32;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_UIMM16bit: {
    return isUInt<16>(Imm);
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_i64imm_32bit: {
    
  return (Imm & 0xffffffffULL) == static_cast<uint64_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GIPFP_APFloat_Predicate_InlineImmFP32 = GIPFP_APFloat_Invalid + 1,
  GIPFP_APFloat_Predicate_InlineImmFP64,
};
bool AMDGPUInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  switch (PredicateID) {
  case GIPFP_APFloat_Predicate_InlineImmFP32: {
    
  return isInlineImmediate(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APFloat_Predicate_InlineImmFP64: {
    
  return isInlineImmediate(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GIPFP_MI_Predicate_AMDGPUmul_i24_oneuse = GIPFP_MI_Invalid + 1,
  GIPFP_MI_Predicate_AMDGPUmul_u24_oneuse,
  GIPFP_MI_Predicate_NonACAMDGPUmul_i24_oneuse,
  GIPFP_MI_Predicate_NonACAMDGPUmul_u24_oneuse,
  GIPFP_MI_Predicate_NonACAdd_oneuse,
  GIPFP_MI_Predicate_add_oneuse,
  GIPFP_MI_Predicate_and_oneuse,
  GIPFP_MI_Predicate_anonymous_12050,
  GIPFP_MI_Predicate_anonymous_12055,
  GIPFP_MI_Predicate_anonymous_12056,
  GIPFP_MI_Predicate_anonymous_12057,
  GIPFP_MI_Predicate_anonymous_12058,
  GIPFP_MI_Predicate_anonymous_12059,
  GIPFP_MI_Predicate_anonymous_12065,
  GIPFP_MI_Predicate_anonymous_12078,
  GIPFP_MI_Predicate_anonymous_12079,
  GIPFP_MI_Predicate_anonymous_12080,
  GIPFP_MI_Predicate_anonymous_12081,
  GIPFP_MI_Predicate_anonymous_12082,
  GIPFP_MI_Predicate_anonymous_12083,
  GIPFP_MI_Predicate_anonymous_12084,
  GIPFP_MI_Predicate_anonymous_12085,
  GIPFP_MI_Predicate_anonymous_12087,
  GIPFP_MI_Predicate_anonymous_12088,
  GIPFP_MI_Predicate_anonymous_12089,
  GIPFP_MI_Predicate_anonymous_12090,
  GIPFP_MI_Predicate_anonymous_12091,
  GIPFP_MI_Predicate_anonymous_12092,
  GIPFP_MI_Predicate_anonymous_12093,
  GIPFP_MI_Predicate_anonymous_12094,
  GIPFP_MI_Predicate_anonymous_12095,
  GIPFP_MI_Predicate_anonymous_12096,
  GIPFP_MI_Predicate_anonymous_12097,
  GIPFP_MI_Predicate_anonymous_12101,
  GIPFP_MI_Predicate_anonymous_12102,
  GIPFP_MI_Predicate_anonymous_12115,
  GIPFP_MI_Predicate_anonymous_12118,
  GIPFP_MI_Predicate_anonymous_12124,
  GIPFP_MI_Predicate_anonymous_15766,
  GIPFP_MI_Predicate_anonymous_17031,
  GIPFP_MI_Predicate_anonymous_17033,
  GIPFP_MI_Predicate_anonymous_17693,
  GIPFP_MI_Predicate_anonymous_18037,
  GIPFP_MI_Predicate_anonymous_18038,
  GIPFP_MI_Predicate_anonymous_18040,
  GIPFP_MI_Predicate_anonymous_18041,
  GIPFP_MI_Predicate_anonymous_18043,
  GIPFP_MI_Predicate_anonymous_18045,
  GIPFP_MI_Predicate_anonymous_18047,
  GIPFP_MI_Predicate_anonymous_18048,
  GIPFP_MI_Predicate_anonymous_18050,
  GIPFP_MI_Predicate_anonymous_18051,
  GIPFP_MI_Predicate_anonymous_18053,
  GIPFP_MI_Predicate_anonymous_18054,
  GIPFP_MI_Predicate_anonymous_18056,
  GIPFP_MI_Predicate_anonymous_18057,
  GIPFP_MI_Predicate_anonymous_18064,
  GIPFP_MI_Predicate_anonymous_18065,
  GIPFP_MI_Predicate_anonymous_18084,
  GIPFP_MI_Predicate_anonymous_18090,
  GIPFP_MI_Predicate_anonymous_18092,
  GIPFP_MI_Predicate_anonymous_19022,
  GIPFP_MI_Predicate_anonymous_19024,
  GIPFP_MI_Predicate_anonymous_19030,
  GIPFP_MI_Predicate_anonymous_19032,
  GIPFP_MI_Predicate_anonymous_19034,
  GIPFP_MI_Predicate_anonymous_19036,
  GIPFP_MI_Predicate_anonymous_19041,
  GIPFP_MI_Predicate_anonymous_19043,
  GIPFP_MI_Predicate_anonymous_19045,
  GIPFP_MI_Predicate_anonymous_19047,
  GIPFP_MI_Predicate_anonymous_19049,
  GIPFP_MI_Predicate_anonymous_19051,
  GIPFP_MI_Predicate_anonymous_19054,
  GIPFP_MI_Predicate_anonymous_19056,
  GIPFP_MI_Predicate_anonymous_19062,
  GIPFP_MI_Predicate_anonymous_19064,
  GIPFP_MI_Predicate_anonymous_19066,
  GIPFP_MI_Predicate_anonymous_19068,
  GIPFP_MI_Predicate_anonymous_19073,
  GIPFP_MI_Predicate_anonymous_19075,
  GIPFP_MI_Predicate_anonymous_19080,
  GIPFP_MI_Predicate_anonymous_19082,
  GIPFP_MI_Predicate_anonymous_19084,
  GIPFP_MI_Predicate_anonymous_19086,
  GIPFP_MI_Predicate_anonymous_19091,
  GIPFP_MI_Predicate_anonymous_19093,
  GIPFP_MI_Predicate_anonymous_19095,
  GIPFP_MI_Predicate_anonymous_19097,
  GIPFP_MI_Predicate_anonymous_19099,
  GIPFP_MI_Predicate_anonymous_19101,
  GIPFP_MI_Predicate_anonymous_19103,
  GIPFP_MI_Predicate_anonymous_19105,
  GIPFP_MI_Predicate_anonymous_19111,
  GIPFP_MI_Predicate_anonymous_19113,
  GIPFP_MI_Predicate_anonymous_19115,
  GIPFP_MI_Predicate_anonymous_19117,
  GIPFP_MI_Predicate_anonymous_19122,
  GIPFP_MI_Predicate_anonymous_19124,
  GIPFP_MI_Predicate_anonymous_19126,
  GIPFP_MI_Predicate_anonymous_19128,
  GIPFP_MI_Predicate_anonymous_19133,
  GIPFP_MI_Predicate_anonymous_19135,
  GIPFP_MI_Predicate_anonymous_19140,
  GIPFP_MI_Predicate_anonymous_19142,
  GIPFP_MI_Predicate_anonymous_19144,
  GIPFP_MI_Predicate_anonymous_19146,
  GIPFP_MI_Predicate_anonymous_19149,
  GIPFP_MI_Predicate_anonymous_19151,
  GIPFP_MI_Predicate_anonymous_19153,
  GIPFP_MI_Predicate_anonymous_19155,
  GIPFP_MI_Predicate_anonymous_19160,
  GIPFP_MI_Predicate_anonymous_19162,
  GIPFP_MI_Predicate_anonymous_19164,
  GIPFP_MI_Predicate_anonymous_19166,
  GIPFP_MI_Predicate_anonymous_19172,
  GIPFP_MI_Predicate_anonymous_19174,
  GIPFP_MI_Predicate_anonymous_19176,
  GIPFP_MI_Predicate_anonymous_19178,
  GIPFP_MI_Predicate_anonymous_19181,
  GIPFP_MI_Predicate_anonymous_19183,
  GIPFP_MI_Predicate_anonymous_19189,
  GIPFP_MI_Predicate_anonymous_19191,
  GIPFP_MI_Predicate_anonymous_19193,
  GIPFP_MI_Predicate_anonymous_19195,
  GIPFP_MI_Predicate_anonymous_19198,
  GIPFP_MI_Predicate_anonymous_19200,
  GIPFP_MI_Predicate_anonymous_19202,
  GIPFP_MI_Predicate_anonymous_19204,
  GIPFP_MI_Predicate_anonymous_19206,
  GIPFP_MI_Predicate_anonymous_19208,
  GIPFP_MI_Predicate_anonymous_19213,
  GIPFP_MI_Predicate_anonymous_19215,
  GIPFP_MI_Predicate_anonymous_19217,
  GIPFP_MI_Predicate_anonymous_19219,
  GIPFP_MI_Predicate_anonymous_19221,
  GIPFP_MI_Predicate_anonymous_19223,
  GIPFP_MI_Predicate_anonymous_19225,
  GIPFP_MI_Predicate_anonymous_19227,
  GIPFP_MI_Predicate_anonymous_23531,
  GIPFP_MI_Predicate_anonymous_23533,
  GIPFP_MI_Predicate_anonymous_24998,
  GIPFP_MI_Predicate_anonymous_25187,
  GIPFP_MI_Predicate_anonymous_25189,
  GIPFP_MI_Predicate_anonymous_25250,
  GIPFP_MI_Predicate_anonymous_25255,
  GIPFP_MI_Predicate_anonymous_25324,
  GIPFP_MI_Predicate_anonymous_25355,
  GIPFP_MI_Predicate_anonymous_25358,
  GIPFP_MI_Predicate_anonymous_25363,
  GIPFP_MI_Predicate_anonymous_25367,
  GIPFP_MI_Predicate_anonymous_25413,
  GIPFP_MI_Predicate_anonymous_25415,
  GIPFP_MI_Predicate_anonymous_25436,
  GIPFP_MI_Predicate_anonymous_25447,
  GIPFP_MI_Predicate_anonymous_25456,
  GIPFP_MI_Predicate_anonymous_25458,
  GIPFP_MI_Predicate_anonymous_25462,
  GIPFP_MI_Predicate_anonymous_25467,
  GIPFP_MI_Predicate_anonymous_25469,
  GIPFP_MI_Predicate_anonymous_25482,
  GIPFP_MI_Predicate_anonymous_25485,
  GIPFP_MI_Predicate_anonymous_25487,
  GIPFP_MI_Predicate_anonymous_25489,
  GIPFP_MI_Predicate_csh_mask_16,
  GIPFP_MI_Predicate_csh_mask_32,
  GIPFP_MI_Predicate_csh_mask_64,
  GIPFP_MI_Predicate_cshl_16_oneuse,
  GIPFP_MI_Predicate_cshl_32_oneuse,
  GIPFP_MI_Predicate_cshl_64_oneuse,
  GIPFP_MI_Predicate_csra_16_oneuse,
  GIPFP_MI_Predicate_csra_32_oneuse,
  GIPFP_MI_Predicate_csra_64_oneuse,
  GIPFP_MI_Predicate_csrl_16_oneuse,
  GIPFP_MI_Predicate_csrl_32_oneuse,
  GIPFP_MI_Predicate_csrl_64_oneuse,
  GIPFP_MI_Predicate_fmaxnum_ieee_oneuse,
  GIPFP_MI_Predicate_fmaxnum_oneuse,
  GIPFP_MI_Predicate_fminnum_ieee_oneuse,
  GIPFP_MI_Predicate_fminnum_oneuse,
  GIPFP_MI_Predicate_load_align_less_than_4_local,
  GIPFP_MI_Predicate_load_align_less_than_4_local_m0,
  GIPFP_MI_Predicate_not_oneuse,
  GIPFP_MI_Predicate_or_oneuse,
  GIPFP_MI_Predicate_select_oneuse,
  GIPFP_MI_Predicate_shl1_add,
  GIPFP_MI_Predicate_shl2_add,
  GIPFP_MI_Predicate_shl3_add,
  GIPFP_MI_Predicate_shl4_add,
  GIPFP_MI_Predicate_shl_0_to_4,
  GIPFP_MI_Predicate_shl_oneuse,
  GIPFP_MI_Predicate_smax_oneuse,
  GIPFP_MI_Predicate_smin_oneuse,
  GIPFP_MI_Predicate_smrd_load,
  GIPFP_MI_Predicate_srl_oneuse,
  GIPFP_MI_Predicate_store_align_less_than_4_local,
  GIPFP_MI_Predicate_store_align_less_than_4_local_m0,
  GIPFP_MI_Predicate_sub_oneuse,
  GIPFP_MI_Predicate_umax_oneuse,
  GIPFP_MI_Predicate_umin_oneuse,
  GIPFP_MI_Predicate_xor_oneuse,
};
bool AMDGPUInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const std::array<const MachineOperand *, 3> &Operands) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  (void)MRI;
  switch (PredicateID) {
  case GIPFP_MI_Predicate_AMDGPUmul_i24_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_AMDGPUmul_u24_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_NonACAMDGPUmul_i24_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_NonACAMDGPUmul_u24_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_NonACAdd_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_add_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_and_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12050: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12055: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12056: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12057: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12058: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12059: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12065: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12078: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12079: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12080: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12081: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12082: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12083: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12084: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12085: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12087: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12088: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12089: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12090: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12091: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12092: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12093: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12094: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12095: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12096: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12097: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12101: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12102: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12115: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12118: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_12124: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_15766: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_17031: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_17033: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_17693: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_18037: {
    
    const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
    int ConstantBusUses = 0;
    for (unsigned i = 0; i < 3; ++i) {
      const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
      if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
        if (++ConstantBusUses > ConstantBusLimit)
          return false;
      }
    }
    return true;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_18038: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_18040: {
    
    const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
    int ConstantBusUses = 0;
    for (unsigned i = 0; i < 3; ++i) {
      const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
      if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
        if (++ConstantBusUses > ConstantBusLimit)
          return false;
      }
    }
    return true;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_18041: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_18043: {
    
    const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
    int ConstantBusUses = 0;
    for (unsigned i = 0; i < 3; ++i) {
      const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
      if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
        if (++ConstantBusUses > ConstantBusLimit)
          return false;
      }
    }
    return true;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_18045: {
    
    const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
    int ConstantBusUses = 0;
    for (unsigned i = 0; i < 3; ++i) {
      const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
      if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
        if (++ConstantBusUses > ConstantBusLimit)
          return false;
      }
    }
    return true;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_18047: {
    
    const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
    int ConstantBusUses = 0;
    for (unsigned i = 0; i < 3; ++i) {
      const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
      if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
        if (++ConstantBusUses > ConstantBusLimit)
          return false;
      }
    }
    return true;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_18048: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_18050: {
    
    const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
    int ConstantBusUses = 0;
    for (unsigned i = 0; i < 3; ++i) {
      const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
      if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
        if (++ConstantBusUses > ConstantBusLimit)
          return false;
      }
    }
    return true;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_18051: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_18053: {
    
    const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
    int ConstantBusUses = 0;
    for (unsigned i = 0; i < 3; ++i) {
      const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
      if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
        if (++ConstantBusUses > ConstantBusLimit)
          return false;
      }
    }
    return true;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_18054: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_18056: {
    
    const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
    int ConstantBusUses = 0;
    for (unsigned i = 0; i < 3; ++i) {
      const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
      if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
        if (++ConstantBusUses > ConstantBusLimit)
          return false;
      }
    }
    return true;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_18057: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_18064: {
    
    const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
    int ConstantBusUses = 0;
    for (unsigned i = 0; i < 3; ++i) {
      const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
      if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
        if (++ConstantBusUses > ConstantBusLimit)
          return false;
      }
    }
    return true;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_18065: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_18084: {
    
    const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
    int ConstantBusUses = 0;
    for (unsigned i = 0; i < 3; ++i) {
      const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
      if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
        if (++ConstantBusUses > ConstantBusLimit)
          return false;
      }
    }
    return true;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_18090: {
    
    return MI.getOperand(6).getImm() != 0 ||
           MI.getOperand(7).getImm() != 0;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_18092: {
    
    return MI.getOperand(6).getImm() != 0 ||
           MI.getOperand(7).getImm() != 0;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19022: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19024: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19030: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19032: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19034: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19036: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19041: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19043: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19045: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19047: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19049: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19051: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19054: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19056: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19062: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19064: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19066: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19068: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19073: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19075: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19080: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19082: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19084: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19086: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19091: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19093: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19095: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19097: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19099: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19101: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19103: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19105: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19111: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19113: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19115: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19117: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19122: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19124: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19126: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19128: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19133: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19135: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19140: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19142: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19144: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19146: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19149: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19151: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19153: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19155: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19160: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19162: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19164: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19166: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19172: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19174: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19176: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19178: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19181: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19183: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19189: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19191: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19193: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19195: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19198: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19200: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19202: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19204: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19206: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19208: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19213: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19215: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19217: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19219: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19221: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19223: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19225: {
     return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_19227: {
     return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs(); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_23531: {
    
    return MRI.use_nodbg_empty(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_23533: {
    
    return MRI.use_nodbg_empty(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_24998: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_25187: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_25189: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_25250: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_25255: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_25324: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_25355: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_25358: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_25363: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_25367: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_25413: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_25415: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_25436: {
    
    const SITargetLowering *TLI = static_cast<const SITargetLowering *>(
      MF.getSubtarget().getTargetLowering());

    return TLI->isCanonicalized(MI.getOperand(1).getReg(), const_cast<MachineFunction&>(MF)) &&
      TLI->isCanonicalized(MI.getOperand(2).getReg(), const_cast<MachineFunction&>(MF));
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_25447: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_25456: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_25458: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_25462: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_25467: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_25469: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_25482: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_25485: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_25487: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_anonymous_25489: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_csh_mask_16: {
     return isUnneededShiftMask(MI, 4); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_csh_mask_32: {
     return isUnneededShiftMask(MI, 5); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_csh_mask_64: {
     return isUnneededShiftMask(MI, 6); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_cshl_16_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_cshl_32_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_cshl_64_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_csra_16_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_csra_32_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_csra_64_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_csrl_16_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_csrl_32_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_csrl_64_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_fmaxnum_ieee_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_fmaxnum_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_fminnum_ieee_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_fminnum_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_load_align_less_than_4_local: {
    return (*MI.memoperands_begin())->getAlign() < 4;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_load_align_less_than_4_local_m0: {
    return (*MI.memoperands_begin())->getAlign() < 4;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_not_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_or_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_select_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_shl1_add: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_shl2_add: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_shl3_add: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_shl4_add: {
    return true;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_shl_0_to_4: {
    
    int64_t Imm = 0;
    if (!mi_match(MI.getOperand(2).getReg(), MRI, m_ICst(Imm)) &&
        !mi_match(MI.getOperand(2).getReg(), MRI, m_Copy(m_ICst(Imm))))
      return false;
    return (uint64_t)Imm <= 4;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_shl_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_smax_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_smin_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_smrd_load: {
    
    if (!MI.hasOneMemOperand())
      return false;
    if (!isInstrUniform(MI))
      return false;

    // FIXME: We should probably be caching this.
    SmallVector<GEPInfo, 4> AddrInfo;
    getAddrModeInfo(MI, MRI, AddrInfo);

    if (hasVgprParts(AddrInfo))
      return false;
    return true;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_srl_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_store_align_less_than_4_local: {
    return (*MI.memoperands_begin())->getAlign() < 4;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_store_align_less_than_4_local_m0: {
    return (*MI.memoperands_begin())->getAlign() < 4;
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_sub_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_umax_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_umin_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_xor_oneuse: {
    
    return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}

AMDGPUInstructionSelector::ComplexMatcherMemFn
AMDGPUInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
  &AMDGPUInstructionSelector::selectDotIUVOP3PMods, // gi_dotiuvop3pmods
  &AMDGPUInstructionSelector::selectDS128Bit8ByteAligned, // gi_ds_128bit_8byte_aligned
  &AMDGPUInstructionSelector::selectDS1Addr1Offset, // gi_ds_1addr_1offset
  &AMDGPUInstructionSelector::selectDS64Bit4ByteAligned, // gi_ds_64bit_4byte_aligned
  &AMDGPUInstructionSelector::selectFlatOffset, // gi_flat_offset
  &AMDGPUInstructionSelector::selectScratchOffset, // gi_flat_scratch_offset
  &AMDGPUInstructionSelector::selectScratchSAddr, // gi_flat_scratch_saddr
  &AMDGPUInstructionSelector::selectScratchSVAddr, // gi_flat_scratch_svaddr
  &AMDGPUInstructionSelector::selectGlobalOffset, // gi_global_offset
  &AMDGPUInstructionSelector::selectGlobalSAddr, // gi_global_saddr
  &AMDGPUInstructionSelector::selectMUBUFAddr64, // gi_mubuf_addr64
  &AMDGPUInstructionSelector::selectMUBUFOffset, // gi_mubuf_offset
  &AMDGPUInstructionSelector::selectMUBUFScratchOffen, // gi_mubuf_scratch_offen
  &AMDGPUInstructionSelector::selectMUBUFScratchOffset, // gi_mubuf_scratch_offset
  &AMDGPUInstructionSelector::selectSMRDBufferImm, // gi_smrd_buffer_imm
  &AMDGPUInstructionSelector::selectSMRDBufferImm32, // gi_smrd_buffer_imm32
  &AMDGPUInstructionSelector::selectSmrdImm, // gi_smrd_imm
  &AMDGPUInstructionSelector::selectSmrdImm32, // gi_smrd_imm32
  &AMDGPUInstructionSelector::selectSmrdSgpr, // gi_smrd_sgpr
  &AMDGPUInstructionSelector::selectSmrdSgprImm, // gi_smrd_sgpr_imm
  &AMDGPUInstructionSelector::selectVCSRC, // gi_vcsrc
  &AMDGPUInstructionSelector::selectVINTERPMods, // gi_vinterpmods
  &AMDGPUInstructionSelector::selectVINTERPModsHi, // gi_vinterpmods_hi
  &AMDGPUInstructionSelector::selectVOP3NoMods, // gi_vop3_no_mods
  &AMDGPUInstructionSelector::selectVOP3Mods, // gi_vop3mods
  &AMDGPUInstructionSelector::selectVOP3Mods0, // gi_vop3mods0
  &AMDGPUInstructionSelector::selectVOP3Mods_nnan, // gi_vop3mods_nnan
  &AMDGPUInstructionSelector::selectVOP3OMods, // gi_vop3omods
  &AMDGPUInstructionSelector::selectVOP3OpSelMods, // gi_vop3opsel
  &AMDGPUInstructionSelector::selectVOP3OpSelMods, // gi_vop3opselmods
  &AMDGPUInstructionSelector::selectVOP3PMods, // gi_vop3pmods
  &AMDGPUInstructionSelector::selectVOP3PModsDOT, // gi_vop3pmodsdot
  &AMDGPUInstructionSelector::selectVSRC0, // gi_vsrc0
  &AMDGPUInstructionSelector::selectWMMAOpSelVOP3PMods, // gi_wmmaopselvop3pmods
};

// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderBitcastImm,
  GICR_renderExtractCPol,
  GICR_renderExtractSWZ,
  GICR_renderFrameIndex,
  GICR_renderNegateImm,
  GICR_renderPopcntImm,
  GICR_renderSetGLC,
  GICR_renderTruncTImm,
};
AMDGPUInstructionSelector::CustomRendererFn
AMDGPUInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &AMDGPUInstructionSelector::renderBitcastImm,
  &AMDGPUInstructionSelector::renderExtractCPol,
  &AMDGPUInstructionSelector::renderExtractSWZ,
  &AMDGPUInstructionSelector::renderFrameIndex,
  &AMDGPUInstructionSelector::renderNegateImm,
  &AMDGPUInstructionSelector::renderPopcntImm,
  &AMDGPUInstructionSelector::renderSetGLC,
  &AMDGPUInstructionSelector::renderTruncTImm,
};

bool AMDGPUInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  MachineFunction &MF = *I.getParent()->getParent();
  MachineRegisterInfo &MRI = MF.getRegInfo();
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  NewMIVector OutMIs;
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, OutMIs, State, ISelInfo, getMatchTable(), TII, MRI, TRI, RBI, AvailableFeatures, CoverageInfo)) {
    return true;
  }

  return false;
}

const int64_t *AMDGPUInstructionSelector::getMatchTable() const {
  constexpr static int64_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/45, 1805, /*)*//*default:*//*Label 140*/ 293296,
    /*TargetOpcode::G_ADD*//*Label 0*/ 1765,
    /*TargetOpcode::G_SUB*//*Label 1*/ 3692,
    /*TargetOpcode::G_MUL*//*Label 2*/ 3926, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_AND*//*Label 3*/ 4128,
    /*TargetOpcode::G_OR*//*Label 4*/ 4976,
    /*TargetOpcode::G_XOR*//*Label 5*/ 17056, 0, 0,
    /*TargetOpcode::G_FRAME_INDEX*//*Label 6*/ 20661, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_BUILD_VECTOR*//*Label 7*/ 20713, 0, 0, 0, 0,
    /*TargetOpcode::G_BITCAST*//*Label 8*/ 21832, 0, 0,
    /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 9*/ 27061, 0, 0, 0,
    /*TargetOpcode::G_READCYCLECOUNTER*//*Label 10*/ 27207,
    /*TargetOpcode::G_LOAD*//*Label 11*/ 27304,
    /*TargetOpcode::G_SEXTLOAD*//*Label 12*/ 57982,
    /*TargetOpcode::G_ZEXTLOAD*//*Label 13*/ 60410, 0, 0, 0,
    /*TargetOpcode::G_STORE*//*Label 14*/ 62726, 0, 0,
    /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 15*/ 85001,
    /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 16*/ 86114,
    /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 17*/ 87753,
    /*TargetOpcode::G_ATOMICRMW_SUB*//*Label 18*/ 89670,
    /*TargetOpcode::G_ATOMICRMW_AND*//*Label 19*/ 91587, 0,
    /*TargetOpcode::G_ATOMICRMW_OR*//*Label 20*/ 93504,
    /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 21*/ 95421,
    /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 22*/ 97338,
    /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 23*/ 99255,
    /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 24*/ 101172,
    /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 25*/ 103089,
    /*TargetOpcode::G_ATOMICRMW_FADD*//*Label 26*/ 105006, 0, 0, 0,
    /*TargetOpcode::G_FENCE*//*Label 27*/ 106954, 0, 0,
    /*TargetOpcode::G_INTRINSIC*//*Label 28*/ 106970,
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 29*/ 123846, 0, 0,
    /*TargetOpcode::G_CONSTANT*//*Label 30*/ 130359,
    /*TargetOpcode::G_FCONSTANT*//*Label 31*/ 130438, 0, 0, 0, 0,
    /*TargetOpcode::G_ZEXT*//*Label 32*/ 130493,
    /*TargetOpcode::G_SHL*//*Label 33*/ 131246,
    /*TargetOpcode::G_LSHR*//*Label 34*/ 132224,
    /*TargetOpcode::G_ASHR*//*Label 35*/ 133039, 0,
    /*TargetOpcode::G_FSHR*//*Label 36*/ 133854, 0, 0,
    /*TargetOpcode::G_ICMP*//*Label 37*/ 133906,
    /*TargetOpcode::G_FCMP*//*Label 38*/ 134791,
    /*TargetOpcode::G_SELECT*//*Label 39*/ 136888, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_UMULH*//*Label 40*/ 137089,
    /*TargetOpcode::G_SMULH*//*Label 41*/ 137192,
    /*TargetOpcode::G_UADDSAT*//*Label 42*/ 137295,
    /*TargetOpcode::G_SADDSAT*//*Label 43*/ 137544,
    /*TargetOpcode::G_USUBSAT*//*Label 44*/ 137726,
    /*TargetOpcode::G_SSUBSAT*//*Label 45*/ 137975, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FADD*//*Label 46*/ 138157,
    /*TargetOpcode::G_FSUB*//*Label 47*/ 139129,
    /*TargetOpcode::G_FMUL*//*Label 48*/ 139314,
    /*TargetOpcode::G_FMA*//*Label 49*/ 139804,
    /*TargetOpcode::G_FMAD*//*Label 50*/ 140653, 0, 0,
    /*TargetOpcode::G_FPOW*//*Label 51*/ 141070, 0, 0,
    /*TargetOpcode::G_FEXP2*//*Label 52*/ 141183, 0,
    /*TargetOpcode::G_FLOG2*//*Label 53*/ 141282, 0,
    /*TargetOpcode::G_FNEG*//*Label 54*/ 141381,
    /*TargetOpcode::G_FPEXT*//*Label 55*/ 142408,
    /*TargetOpcode::G_FPTRUNC*//*Label 56*/ 142505,
    /*TargetOpcode::G_FPTOSI*//*Label 57*/ 142602,
    /*TargetOpcode::G_FPTOUI*//*Label 58*/ 142920,
    /*TargetOpcode::G_SITOFP*//*Label 59*/ 143238,
    /*TargetOpcode::G_UITOFP*//*Label 60*/ 143558,
    /*TargetOpcode::G_FABS*//*Label 61*/ 143878, 0, 0,
    /*TargetOpcode::G_FCANONICALIZE*//*Label 62*/ 144324,
    /*TargetOpcode::G_FMINNUM*//*Label 63*/ 145014,
    /*TargetOpcode::G_FMAXNUM*//*Label 64*/ 146081,
    /*TargetOpcode::G_FMINNUM_IEEE*//*Label 65*/ 178380,
    /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 66*/ 179447, 0, 0, 0, 0,
    /*TargetOpcode::G_SMIN*//*Label 67*/ 211746,
    /*TargetOpcode::G_SMAX*//*Label 68*/ 215164,
    /*TargetOpcode::G_UMIN*//*Label 69*/ 218760,
    /*TargetOpcode::G_UMAX*//*Label 70*/ 222178,
    /*TargetOpcode::G_ABS*//*Label 71*/ 225596, 0, 0,
    /*TargetOpcode::G_BR*//*Label 72*/ 225624, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_CTTZ_ZERO_UNDEF*//*Label 73*/ 225649, 0,
    /*TargetOpcode::G_CTLZ_ZERO_UNDEF*//*Label 74*/ 225726,
    /*TargetOpcode::G_CTPOP*//*Label 75*/ 225807,
    /*TargetOpcode::G_BSWAP*//*Label 76*/ 225895,
    /*TargetOpcode::G_BITREVERSE*//*Label 77*/ 226715,
    /*TargetOpcode::G_FCEIL*//*Label 78*/ 226925, 0, 0,
    /*TargetOpcode::G_FSQRT*//*Label 79*/ 227071,
    /*TargetOpcode::G_FFLOOR*//*Label 80*/ 227215,
    /*TargetOpcode::G_FRINT*//*Label 81*/ 227525, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_STRICT_FADD*//*Label 82*/ 227671,
    /*TargetOpcode::G_STRICT_FSUB*//*Label 83*/ 228161,
    /*TargetOpcode::G_STRICT_FMUL*//*Label 84*/ 228294, 0, 0,
    /*TargetOpcode::G_STRICT_FMA*//*Label 85*/ 228672, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*AMDGPU::G_AMDGPU_ATOMIC_CMPXCHG*//*Label 86*/ 229347,
    /*AMDGPU::G_AMDGPU_ATOMIC_DEC*//*Label 87*/ 230828,
    /*AMDGPU::G_AMDGPU_ATOMIC_FMAX*//*Label 88*/ 232745,
    /*AMDGPU::G_AMDGPU_ATOMIC_FMIN*//*Label 89*/ 234116,
    /*AMDGPU::G_AMDGPU_ATOMIC_INC*//*Label 90*/ 235487,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_ADD*//*Label 91*/ 237404,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_AND*//*Label 92*/ 238517,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_CMPSWAP*//*Label 93*/ 239630,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_DEC*//*Label 94*/ 240634,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FADD*//*Label 95*/ 241747,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FMAX*//*Label 96*/ 243461,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FMIN*//*Label 97*/ 245150,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_INC*//*Label 98*/ 246839,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_OR*//*Label 99*/ 247952,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SMAX*//*Label 100*/ 249065,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SMIN*//*Label 101*/ 250178,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SUB*//*Label 102*/ 251291,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SWAP*//*Label 103*/ 252404,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_UMAX*//*Label 104*/ 254045,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_UMIN*//*Label 105*/ 255158,
    /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_XOR*//*Label 106*/ 256271,
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD*//*Label 107*/ 257384,
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_FORMAT*//*Label 108*/ 260880,
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_FORMAT_D16*//*Label 109*/ 263216,
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SBYTE*//*Label 110*/ 267783,
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SSHORT*//*Label 111*/ 268088,
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_UBYTE*//*Label 112*/ 268393,
    /*AMDGPU::G_AMDGPU_BUFFER_LOAD_USHORT*//*Label 113*/ 268698,
    /*AMDGPU::G_AMDGPU_BUFFER_STORE*//*Label 114*/ 269003,
    /*AMDGPU::G_AMDGPU_BUFFER_STORE_BYTE*//*Label 115*/ 272475,
    /*AMDGPU::G_AMDGPU_BUFFER_STORE_FORMAT*//*Label 116*/ 272776,
    /*AMDGPU::G_AMDGPU_BUFFER_STORE_FORMAT_D16*//*Label 117*/ 275096,
    /*AMDGPU::G_AMDGPU_BUFFER_STORE_SHORT*//*Label 118*/ 278971,
    /*AMDGPU::G_AMDGPU_CLAMP*//*Label 119*/ 279272,
    /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE0*//*Label 120*/ 279494,
    /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE1*//*Label 121*/ 279538,
    /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE2*//*Label 122*/ 279582,
    /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE3*//*Label 123*/ 279626,
    /*AMDGPU::G_AMDGPU_CVT_PK_I16_I32*//*Label 124*/ 279670,
    /*AMDGPU::G_AMDGPU_FFBH_U32*//*Label 125*/ 279699,
    /*AMDGPU::G_AMDGPU_FFBL_B32*//*Label 126*/ 279780,
    /*AMDGPU::G_AMDGPU_FMAX_LEGACY*//*Label 127*/ 279857,
    /*AMDGPU::G_AMDGPU_FMED3*//*Label 128*/ 279924,
    /*AMDGPU::G_AMDGPU_FMIN_LEGACY*//*Label 129*/ 280089, 0, 0, 0, 0, 0, 0, 0,
    /*AMDGPU::G_AMDGPU_RCP_IFLAG*//*Label 130*/ 280156,
    /*AMDGPU::G_AMDGPU_SMED3*//*Label 131*/ 280204,
    /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD*//*Label 132*/ 280339,
    /*AMDGPU::G_AMDGPU_TBUFFER_LOAD_FORMAT*//*Label 133*/ 281509,
    /*AMDGPU::G_AMDGPU_TBUFFER_LOAD_FORMAT_D16*//*Label 134*/ 284101,
    /*AMDGPU::G_AMDGPU_TBUFFER_STORE_FORMAT*//*Label 135*/ 287510,
    /*AMDGPU::G_AMDGPU_TBUFFER_STORE_FORMAT_D16*//*Label 136*/ 290086,
    /*AMDGPU::G_AMDGPU_UMED3*//*Label 137*/ 293105, 0,
    /*AMDGPU::G_FPTRUNC_ROUND_DOWNWARD*//*Label 138*/ 293240,
    /*AMDGPU::G_FPTRUNC_ROUND_UPWARD*//*Label 139*/ 293268,
    // Label 0: @1765
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 12, /*)*//*default:*//*Label 145*/ 3691,
    /*GILLT_s16*//*Label 141*/ 1775,
    /*GILLT_s32*//*Label 142*/ 2097,
    /*GILLT_s64*//*Label 143*/ 3452,
    /*GILLT_v2s16*//*Label 144*/ 3623,
    // Label 141: @1775
    GIM_Try, /*On fail goto*//*Label 146*/ 2096,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_Try, /*On fail goto*//*Label 147*/ 1828, // Rule ID 1430 //
        GIM_CheckFeatures, GIFBS_Has16BitInsts_isGFX8GFX9,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_NegSubInlineIntConst16,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_U16_e64:{ *:[i16] } VSrc_b16:{ *:[i16] }:$src0, (NegateImm:{ *:[i16 i32 f16 f32 v2i16 v2f16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_SUB_U16_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderNegateImm, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1430,
        GIR_Done,
      // Label 147: @1828
      GIM_Try, /*On fail goto*//*Label 148*/ 1876, // Rule ID 1510 //
        GIM_CheckFeatures, GIFBS_isGFX10Plus,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_NegSubInlineIntConst16,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_NC_U16_e64:{ *:[i16] } 0:{ *:[i32] }, VSrc_b16:{ *:[i16] }:$src0, 0:{ *:[i32] }, (NegateImm:{ *:[i16 i32 f16 f32 v2i16 v2f16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1), 0:{ *:[i1] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_SUB_NC_U16_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderNegateImm, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1510,
        GIR_Done,
      // Label 148: @1876
      GIM_Try, /*On fail goto*//*Label 149*/ 1924, // Rule ID 1467 //
        GIM_CheckFeatures, GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MAD_U16_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1467,
        GIR_Done,
      // Label 149: @1924
      GIM_Try, /*On fail goto*//*Label 150*/ 1972, // Rule ID 1468 //
        GIM_CheckFeatures, GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_I16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MAD_I16_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1468,
        GIR_Done,
      // Label 150: @1972
      GIM_Try, /*On fail goto*//*Label 151*/ 2020, // Rule ID 4719 //
        GIM_CheckFeatures, GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MAD_U16_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4719,
        GIR_Done,
      // Label 151: @2020
      GIM_Try, /*On fail goto*//*Label 152*/ 2068, // Rule ID 653 //
        GIM_CheckFeatures, GIFBS_isGFX10Plus,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_vop3opselmods,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/1, GICP_gi_vop3opselmods,
        // (add:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_ADD_NC_U16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_ADD_NC_U16_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // src0_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // src0
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/1, /*SubOperand*/1, // src1_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/1, /*SubOperand*/0, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 653,
        GIR_Done,
      // Label 152: @2068
      GIM_Try, /*On fail goto*//*Label 153*/ 2095, // Rule ID 566 //
        GIM_CheckFeatures, GIFBS_isGFX8GFX9,
        // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_ADD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_ADD_U16_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 566,
        GIR_Done,
      // Label 153: @2095
      GIM_Reject,
    // Label 146: @2096
    GIM_Reject,
    // Label 142: @2097
    GIM_Try, /*On fail goto*//*Label 154*/ 3451,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 155*/ 2203, // Rule ID 1484 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIPFP_MI_Predicate_csh_mask_32,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_18038,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:1:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_18037,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:1:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_18038>>, i32:{ *:[i32] }:$src2:$pred:1:z)<<P:1:Predicate_anonymous_18037>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHL_ADD_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1484,
        GIR_Done,
      // Label 155: @2203
      GIM_Try, /*On fail goto*//*Label 156*/ 2299, // Rule ID 4722 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:1:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIPFP_MI_Predicate_csh_mask_32,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_18038,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_18037,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:1:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:1:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_18038>>)<<P:1:Predicate_anonymous_18037>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHL_ADD_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4722,
        GIR_Done,
      // Label 156: @2299
      GIM_Try, /*On fail goto*//*Label 157*/ 2362, // Rule ID 61 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_shl_oneuse,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_shl1_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 1:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl1_add>>  =>  (S_LSHL1_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LSHL1_ADD_U32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 61,
        GIR_Done,
      // Label 157: @2362
      GIM_Try, /*On fail goto*//*Label 158*/ 2425, // Rule ID 62 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_shl_oneuse,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_shl2_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 2:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl2_add>>  =>  (S_LSHL2_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LSHL2_ADD_U32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 62,
        GIR_Done,
      // Label 158: @2425
      GIM_Try, /*On fail goto*//*Label 159*/ 2488, // Rule ID 63 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_shl_oneuse,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_shl3_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 3:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl3_add>>  =>  (S_LSHL3_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LSHL3_ADD_U32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 63,
        GIR_Done,
      // Label 159: @2488
      GIM_Try, /*On fail goto*//*Label 160*/ 2551, // Rule ID 64 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_shl_oneuse,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_shl4_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 4:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl4_add>>  =>  (S_LSHL4_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LSHL4_ADD_U32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 64,
        GIR_Done,
      // Label 160: @2551
      GIM_Try, /*On fail goto*//*Label 161*/ 2614, // Rule ID 4663 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_shl_oneuse,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_shl1_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 1:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl1_add>>  =>  (S_LSHL1_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LSHL1_ADD_U32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4663,
        GIR_Done,
      // Label 161: @2614
      GIM_Try, /*On fail goto*//*Label 162*/ 2677, // Rule ID 4664 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_shl_oneuse,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_shl2_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 2:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl2_add>>  =>  (S_LSHL2_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LSHL2_ADD_U32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4664,
        GIR_Done,
      // Label 162: @2677
      GIM_Try, /*On fail goto*//*Label 163*/ 2740, // Rule ID 4665 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_shl_oneuse,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_shl3_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 3:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl3_add>>  =>  (S_LSHL3_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LSHL3_ADD_U32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4665,
        GIR_Done,
      // Label 163: @2740
      GIM_Try, /*On fail goto*//*Label 164*/ 2803, // Rule ID 4666 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 4,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_shl_oneuse,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_shl4_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 4:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl4_add>>  =>  (S_LSHL4_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LSHL4_ADD_U32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4666,
        GIR_Done,
      // Label 164: @2803
      GIM_Try, /*On fail goto*//*Label 165*/ 2870, // Rule ID 1487 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ADD,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_18041,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:3:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_18043,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:3:x, i32:{ *:[i32] }:$src1:$pred:3:y)<<P:Predicate_anonymous_18041>>, i32:{ *:[i32] }:$src2:$pred:3:z)<<P:3:Predicate_anonymous_18043>>  =>  (V_ADD3_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_ADD3_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1487,
        GIR_Done,
      // Label 165: @2870
      GIM_Try, /*On fail goto*//*Label 166*/ 2937, // Rule ID 1483 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_18038,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:1:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_18037,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, i32:{ *:[i32] }:$src1:$pred:1:y)<<P:Predicate_anonymous_18038>>, i32:{ *:[i32] }:$src2:$pred:1:z)<<P:1:Predicate_anonymous_18037>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHL_ADD_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1483,
        GIR_Done,
      // Label 166: @2937
      GIM_Try, /*On fail goto*//*Label 167*/ 3004, // Rule ID 1492 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:7:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:7:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_18054,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:7:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_18053,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:7:x, i32:{ *:[i32] }:$src1:$pred:7:y)<<P:Predicate_anonymous_18054>>, i32:{ *:[i32] }:$src2:$pred:7:z)<<P:7:Predicate_anonymous_18053>>  =>  (V_XAD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_XAD_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1492,
        GIR_Done,
      // Label 167: @3004
      GIM_Try, /*On fail goto*//*Label 168*/ 3071, // Rule ID 4723 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:3:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ADD,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_18041,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_18043,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:3:z, (add:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:3:x, i32:{ *:[i32] }:$src1:$pred:3:y)<<P:Predicate_anonymous_18041>>)<<P:3:Predicate_anonymous_18043>>  =>  (V_ADD3_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_ADD3_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4723,
        GIR_Done,
      // Label 168: @3071
      GIM_Try, /*On fail goto*//*Label 169*/ 3138, // Rule ID 4721 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:1:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_18038,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_18037,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:1:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, i32:{ *:[i32] }:$src1:$pred:1:y)<<P:Predicate_anonymous_18038>>)<<P:1:Predicate_anonymous_18037>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHL_ADD_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4721,
        GIR_Done,
      // Label 169: @3138
      GIM_Try, /*On fail goto*//*Label 170*/ 3205, // Rule ID 4728 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:7:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:7:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:7:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_18054,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_18053,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:7:z, (xor:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:7:x, i32:{ *:[i32] }:$src1:$pred:7:y)<<P:Predicate_anonymous_18054>>)<<P:7:Predicate_anonymous_18053>>  =>  (V_XAD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_XAD_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4728,
        GIR_Done,
      // Label 170: @3205
      GIM_Try, /*On fail goto*//*Label 171*/ 3246, // Rule ID 4067 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_NegSubInlineConst32,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12078,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)<<P:Predicate_anonymous_12078>>  =>  (S_SUB_I32:{ *:[i32] }:{ *:[i1] } SReg_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i1 i16 i32 f16 f32 v2i16 v2f16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_SUB_I32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderNegateImm, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4067,
        GIR_Done,
      // Label 171: @3246
      GIM_Try, /*On fail goto*//*Label 172*/ 3292, // Rule ID 4068 //
        GIM_CheckFeatures, GIFBS_HasAddNoCarryInsts,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_NegSubInlineConst32,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25447,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)<<P:Predicate_anonymous_25447>>  =>  (V_SUB_U32_e64:{ *:[i32] } VS_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i16 i32 f16 f32 v2i16 v2f16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_SUB_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderNegateImm, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4068,
        GIR_Done,
      // Label 172: @3292
      GIM_Try, /*On fail goto*//*Label 173*/ 3345, // Rule ID 4069 //
        GIM_CheckFeatures, GIFBS_NotHasAddNoCarryInsts,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIPFP_I64_Predicate_NegSubInlineConst32,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25447,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)<<P:Predicate_anonymous_25447>>  =>  (V_SUB_CO_U32_e64:{ *:[i32] }:{ *:[i1] } VS_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i16 i32 f16 f32 v2i16 v2f16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_SUB_CO_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/RegState::Define|RegState::Dead,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderNegateImm, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4069,
        GIR_Done,
      // Label 173: @3345
      GIM_Try, /*On fail goto*//*Label 174*/ 3372, // Rule ID 22 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12078,
        // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_12078>>  =>  (S_ADD_I32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_ADD_I32,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 22,
        GIR_Done,
      // Label 174: @3372
      GIM_Try, /*On fail goto*//*Label 175*/ 3411, // Rule ID 520 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CTPOP,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$src0), i32:{ *:[i32] }:$src1)  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BCNT_U32_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 520,
        GIR_Done,
      // Label 175: @3411
      GIM_Try, /*On fail goto*//*Label 176*/ 3450, // Rule ID 4678 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CTPOP,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$src1, (ctpop:{ *:[i32] } i32:{ *:[i32] }:$src0))  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BCNT_U32_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4678,
        GIR_Done,
      // Label 176: @3450
      GIM_Reject,
    // Label 154: @3451
    GIM_Reject,
    // Label 143: @3452
    GIM_Try, /*On fail goto*//*Label 177*/ 3622,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 178*/ 3532, // Rule ID 1493 //
        GIM_CheckFeatures, GIFBS_isGFX940Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:8:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:8:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_shl_0_to_4,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_18057,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:8:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_18056,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } (shl:{ *:[i64] } i64:{ *:[i64] }:$src0:$pred:8:x, i32:{ *:[i32] }:$src1:$pred:8:y)<<P:Predicate_shl_0_to_4>><<P:Predicate_anonymous_18057>>, i64:{ *:[i64] }:$src2:$pred:8:z)<<P:8:Predicate_anonymous_18056>>  =>  (V_LSHL_ADD_U64_e64:{ *:[i64] } VSrc_b64:{ *:[i64] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b64:{ *:[i64] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHL_ADD_U64_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1493,
        GIR_Done,
      // Label 178: @3532
      GIM_Try, /*On fail goto*//*Label 179*/ 3602, // Rule ID 4729 //
        GIM_CheckFeatures, GIFBS_isGFX940Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:8:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:8:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:8:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_shl_0_to_4,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_18057,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_18056,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } i64:{ *:[i64] }:$src2:$pred:8:z, (shl:{ *:[i64] } i64:{ *:[i64] }:$src0:$pred:8:x, i32:{ *:[i32] }:$src1:$pred:8:y)<<P:Predicate_shl_0_to_4>><<P:Predicate_anonymous_18057>>)<<P:8:Predicate_anonymous_18056>>  =>  (V_LSHL_ADD_U64_e64:{ *:[i64] } VSrc_b64:{ *:[i64] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b64:{ *:[i64] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHL_ADD_U64_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4729,
        GIR_Done,
      // Label 179: @3602
      GIM_Try, /*On fail goto*//*Label 180*/ 3621, // Rule ID 826 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12078,
        // (add:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_12078>>  =>  (S_ADD_U64_PSEUDO:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_ADD_U64_PSEUDO,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 826,
        GIR_Done,
      // Label 180: @3621
      GIM_Reject,
    // Label 177: @3622
    GIM_Reject,
    // Label 144: @3623
    GIM_Try, /*On fail goto*//*Label 181*/ 3690, // Rule ID 667 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_vop3pmods,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/1, GICP_gi_vop3pmods,
      // (add:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_ADD_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_PK_ADD_U16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // src0_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // src0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/1, /*SubOperand*/1, // src1_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/1, /*SubOperand*/0, // src1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 667,
      GIR_Done,
    // Label 181: @3690
    GIM_Reject,
    // Label 145: @3691
    GIM_Reject,
    // Label 1: @3692
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 12, /*)*//*default:*//*Label 186*/ 3925,
    /*GILLT_s16*//*Label 182*/ 3702,
    /*GILLT_s32*//*Label 183*/ 3793,
    /*GILLT_s64*//*Label 184*/ 3829,
    /*GILLT_v2s16*//*Label 185*/ 3857,
    // Label 182: @3702
    GIM_Try, /*On fail goto*//*Label 187*/ 3792,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_Try, /*On fail goto*//*Label 188*/ 3764, // Rule ID 654 //
        GIM_CheckFeatures, GIFBS_isGFX10Plus,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_vop3opselmods,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/1, GICP_gi_vop3opselmods,
        // (sub:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_SUB_NC_U16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_SUB_NC_U16_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // src0_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // src0
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/1, /*SubOperand*/1, // src1_modifiers
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/1, /*SubOperand*/0, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 654,
        GIR_Done,
      // Label 188: @3764
      GIM_Try, /*On fail goto*//*Label 189*/ 3791, // Rule ID 567 //
        GIM_CheckFeatures, GIFBS_isGFX8GFX9,
        // (sub:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_SUB_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_SUB_U16_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 567,
        GIR_Done,
      // Label 189: @3791
      GIM_Reject,
    // Label 187: @3792
    GIM_Reject,
    // Label 183: @3793
    GIM_Try, /*On fail goto*//*Label 190*/ 3828, // Rule ID 23 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12079,
      // (sub:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_12079>>  =>  (S_SUB_I32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_SUB_I32,
      GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 23,
      GIR_Done,
    // Label 190: @3828
    GIM_Reject,
    // Label 184: @3829
    GIM_Try, /*On fail goto*//*Label 191*/ 3856, // Rule ID 827 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12079,
      // (sub:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_12079>>  =>  (S_SUB_U64_PSEUDO:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_SUB_U64_PSEUDO,
      GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 827,
      GIR_Done,
    // Label 191: @3856
    GIM_Reject,
    // Label 185: @3857
    GIM_Try, /*On fail goto*//*Label 192*/ 3924, // Rule ID 673 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_vop3pmods,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/1, GICP_gi_vop3pmods,
      // (sub:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_SUB_I16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_PK_SUB_I16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // src0_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // src0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/1, /*SubOperand*/1, // src1_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/1, /*SubOperand*/0, // src1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 673,
      GIR_Done,
    // Label 192: @3924
    GIM_Reject,
    // Label 186: @3925
    GIM_Reject,
    // Label 2: @3926
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 12, /*)*//*default:*//*Label 196*/ 4127,
    /*GILLT_s16*//*Label 193*/ 3936,
    /*GILLT_s32*//*Label 194*/ 3963, 0,
    /*GILLT_v2s16*//*Label 195*/ 4059,
    // Label 193: @3936
    GIM_Try, /*On fail goto*//*Label 197*/ 3962, // Rule ID 557 //
      GIM_CheckFeatures, GIFBS_Has16BitInsts,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_MUL_LO_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_MUL_LO_U16_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 557,
      GIR_Done,
    // Label 197: @3962
    GIM_Reject,
    // Label 194: @3963
    GIM_Try, /*On fail goto*//*Label 198*/ 4058,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 199*/ 3989, // Rule ID 60 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12097,
        // (mul:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_12097>>  =>  (S_MUL_I32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_MUL_I32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 60,
        GIR_Done,
      // Label 199: @3989
      GIM_Try, /*On fail goto*//*Label 200*/ 4023, // Rule ID 586 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_17693,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_vop3mods0,
        // (mul:{ *:[i32] } (VOP3Mods0:{ *:[i32] } i32:{ *:[i32] }:$src0), i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_17693>>  =>  (V_MUL_LO_U32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MUL_LO_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 586,
        GIR_Done,
      // Label 200: @4023
      GIM_Try, /*On fail goto*//*Label 201*/ 4057, // Rule ID 4702 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_17693,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_vop3mods0,
        // (mul:{ *:[i32] } i32:{ *:[i32] }:$src1, (VOP3Mods0:{ *:[i32] } i32:{ *:[i32] }:$src0))<<P:Predicate_anonymous_17693>>  =>  (V_MUL_LO_U32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MUL_LO_U32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4702,
        GIR_Done,
      // Label 201: @4057
      GIM_Reject,
    // Label 198: @4058
    GIM_Reject,
    // Label 195: @4059
    GIM_Try, /*On fail goto*//*Label 202*/ 4126, // Rule ID 668 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_vop3pmods,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/1, GICP_gi_vop3pmods,
      // (mul:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_MUL_LO_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_PK_MUL_LO_U16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // src0_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // src0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/1, /*SubOperand*/1, // src1_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/1, /*SubOperand*/0, // src1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 668,
      GIR_Done,
    // Label 202: @4126
    GIM_Reject,
    // Label 196: @4127
    GIM_Reject,
    // Label 3: @4128
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 17, /*)*//*default:*//*Label 209*/ 4975,
    /*GILLT_s16*//*Label 203*/ 4143,
    /*GILLT_s32*//*Label 204*/ 4295,
    /*GILLT_s64*//*Label 205*/ 4448,
    /*GILLT_v2s16*//*Label 206*/ 4571,
    /*GILLT_v2s32*//*Label 207*/ 4721, 0, 0, 0,
    /*GILLT_v4s16*//*Label 208*/ 4848,
    // Label 203: @4143
    GIM_Try, /*On fail goto*//*Label 210*/ 4294,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 211*/ 4206, // Rule ID 4709 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12050,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12087,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i16] } (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] })<<P:Predicate_anonymous_12050>>, i16:{ *:[i16] }:$src0)<<P:Predicate_anonymous_12087>>  =>  (S_ANDN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4709,
        GIR_Done,
      // Label 211: @4206
      GIM_Try, /*On fail goto*//*Label 212*/ 4259, // Rule ID 1188 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12050,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12087,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] })<<P:Predicate_anonymous_12050>>)<<P:Predicate_anonymous_12087>>  =>  (S_ANDN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1188,
        GIR_Done,
      // Label 212: @4259
      GIM_Try, /*On fail goto*//*Label 213*/ 4275, // Rule ID 1424 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_AND_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_AND_B32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1424,
        GIR_Done,
      // Label 213: @4275
      GIM_Try, /*On fail goto*//*Label 214*/ 4293, // Rule ID 569 //
        GIM_CheckFeatures, GIFBS_isGFX11Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_AND_B16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_AND_B16_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 569,
        GIR_Done,
      // Label 214: @4293
      GIM_Reject,
    // Label 210: @4294
    GIM_Reject,
    // Label 204: @4295
    GIM_Try, /*On fail goto*//*Label 215*/ 4447,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 216*/ 4358, // Rule ID 4659 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12050,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12087,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] })<<P:Predicate_anonymous_12050>>, i32:{ *:[i32] }:$src0)<<P:Predicate_anonymous_12087>>  =>  (S_ANDN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4659,
        GIR_Done,
      // Label 216: @4358
      GIM_Try, /*On fail goto*//*Label 217*/ 4411, // Rule ID 43 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12050,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12087,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] })<<P:Predicate_anonymous_12050>>)<<P:Predicate_anonymous_12087>>  =>  (S_ANDN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 43,
        GIR_Done,
      // Label 217: @4411
      GIM_Try, /*On fail goto*//*Label 218*/ 4430, // Rule ID 31 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12087,
        // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_12087>>  =>  (S_AND_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_AND_B32,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 31,
        GIR_Done,
      // Label 218: @4430
      GIM_Try, /*On fail goto*//*Label 219*/ 4446, // Rule ID 515 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_AND_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_AND_B32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 515,
        GIR_Done,
      // Label 219: @4446
      GIM_Reject,
    // Label 215: @4447
    GIM_Reject,
    // Label 205: @4448
    GIM_Try, /*On fail goto*//*Label 220*/ 4570,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12087,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_Try, /*On fail goto*//*Label 221*/ 4511, // Rule ID 4660 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12050,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$src1, -1:{ *:[i64] })<<P:Predicate_anonymous_12050>>, i64:{ *:[i64] }:$src0)<<P:Predicate_anonymous_12087>>  =>  (S_ANDN2_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4660,
        GIR_Done,
      // Label 221: @4511
      GIM_Try, /*On fail goto*//*Label 222*/ 4557, // Rule ID 44 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12050,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } i64:{ *:[i64] }:$src0, (xor:{ *:[i64] } i64:{ *:[i64] }:$src1, -1:{ *:[i64] })<<P:Predicate_anonymous_12050>>)<<P:Predicate_anonymous_12087>>  =>  (S_ANDN2_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 44,
        GIR_Done,
      // Label 222: @4557
      GIM_Try, /*On fail goto*//*Label 223*/ 4569, // Rule ID 32 //
        // (and:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_12087>>  =>  (S_AND_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_AND_B64,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 32,
        GIR_Done,
      // Label 223: @4569
      GIM_Reject,
    // Label 220: @4570
    GIM_Reject,
    // Label 206: @4571
    GIM_Try, /*On fail goto*//*Label 224*/ 4720,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_Try, /*On fail goto*//*Label 225*/ 4642, // Rule ID 4710 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12124,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12087,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v2i16] } (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, immAllOnesV:{ *:[v2i16] })<<P:Predicate_anonymous_12124>>, v2i16:{ *:[v2i16] }:$src0)<<P:Predicate_anonymous_12087>>  =>  (S_ANDN2_B32:{ *:[v2i16] }:{ *:[i1] } SSrc_b32:{ *:[v2i16] }:$src0, SSrc_b32:{ *:[v2i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4710,
        GIR_Done,
      // Label 225: @4642
      GIM_Try, /*On fail goto*//*Label 226*/ 4703, // Rule ID 1189 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12124,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12087,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, immAllOnesV:{ *:[v2i16] })<<P:Predicate_anonymous_12124>>)<<P:Predicate_anonymous_12087>>  =>  (S_ANDN2_B32:{ *:[v2i16] }:{ *:[i1] } SSrc_b32:{ *:[v2i16] }:$src0, SSrc_b32:{ *:[v2i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1189,
        GIR_Done,
      // Label 226: @4703
      GIM_Try, /*On fail goto*//*Label 227*/ 4719, // Rule ID 1427 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (and:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1)  =>  (V_AND_B32_e64:{ *:[v2i16] } VSrc_b32:{ *:[v2i16] }:$src0, VSrc_b32:{ *:[v2i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_AND_B32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1427,
        GIR_Done,
      // Label 227: @4719
      GIM_Reject,
    // Label 224: @4720
    GIM_Reject,
    // Label 207: @4721
    GIM_Try, /*On fail goto*//*Label 228*/ 4847,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12087,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_Try, /*On fail goto*//*Label 229*/ 4792, // Rule ID 4712 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12124,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v2i32] } (xor:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src1, immAllOnesV:{ *:[v2i32] })<<P:Predicate_anonymous_12124>>, v2i32:{ *:[v2i32] }:$src0)<<P:Predicate_anonymous_12087>>  =>  (S_ANDN2_B64:{ *:[v2i32] }:{ *:[i1] } SSrc_b64:{ *:[v2i32] }:$src0, SSrc_b64:{ *:[v2i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4712,
        GIR_Done,
      // Label 229: @4792
      GIM_Try, /*On fail goto*//*Label 230*/ 4846, // Rule ID 1191 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12124,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src0, (xor:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src1, immAllOnesV:{ *:[v2i32] })<<P:Predicate_anonymous_12124>>)<<P:Predicate_anonymous_12087>>  =>  (S_ANDN2_B64:{ *:[v2i32] }:{ *:[i1] } SSrc_b64:{ *:[v2i32] }:$src0, SSrc_b64:{ *:[v2i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1191,
        GIR_Done,
      // Label 230: @4846
      GIM_Reject,
    // Label 228: @4847
    GIM_Reject,
    // Label 208: @4848
    GIM_Try, /*On fail goto*//*Label 231*/ 4974,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12087,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_Try, /*On fail goto*//*Label 232*/ 4919, // Rule ID 4711 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12124,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i16] } (xor:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src1, immAllOnesV:{ *:[v4i16] })<<P:Predicate_anonymous_12124>>, v4i16:{ *:[v4i16] }:$src0)<<P:Predicate_anonymous_12087>>  =>  (S_ANDN2_B64:{ *:[v4i16] }:{ *:[i1] } SSrc_b64:{ *:[v4i16] }:$src0, SSrc_b64:{ *:[v4i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4711,
        GIR_Done,
      // Label 232: @4919
      GIM_Try, /*On fail goto*//*Label 233*/ 4973, // Rule ID 1190 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12124,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src0, (xor:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src1, immAllOnesV:{ *:[v4i16] })<<P:Predicate_anonymous_12124>>)<<P:Predicate_anonymous_12087>>  =>  (S_ANDN2_B64:{ *:[v4i16] }:{ *:[i1] } SSrc_b64:{ *:[v4i16] }:$src0, SSrc_b64:{ *:[v4i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ANDN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1190,
        GIR_Done,
      // Label 233: @4973
      GIM_Reject,
    // Label 231: @4974
    GIM_Reject,
    // Label 209: @4975
    GIM_Reject,
    // Label 4: @4976
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 17, /*)*//*default:*//*Label 240*/ 17055,
    /*GILLT_s16*//*Label 234*/ 4991,
    /*GILLT_s32*//*Label 235*/ 5143,
    /*GILLT_s64*//*Label 236*/ 8298,
    /*GILLT_v2s16*//*Label 237*/ 16651,
    /*GILLT_v2s32*//*Label 238*/ 16801, 0, 0, 0,
    /*GILLT_v4s16*//*Label 239*/ 16928,
    // Label 234: @4991
    GIM_Try, /*On fail goto*//*Label 241*/ 5142,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 242*/ 5054, // Rule ID 4713 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12050,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12088,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i16] } (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] })<<P:Predicate_anonymous_12050>>, i16:{ *:[i16] }:$src0)<<P:Predicate_anonymous_12088>>  =>  (S_ORN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4713,
        GIR_Done,
      // Label 242: @5054
      GIM_Try, /*On fail goto*//*Label 243*/ 5107, // Rule ID 1192 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12050,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12088,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] })<<P:Predicate_anonymous_12050>>)<<P:Predicate_anonymous_12088>>  =>  (S_ORN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1192,
        GIR_Done,
      // Label 243: @5107
      GIM_Try, /*On fail goto*//*Label 244*/ 5123, // Rule ID 1425 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_OR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_OR_B32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1425,
        GIR_Done,
      // Label 244: @5123
      GIM_Try, /*On fail goto*//*Label 245*/ 5141, // Rule ID 570 //
        GIM_CheckFeatures, GIFBS_isGFX11Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_OR_B16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_OR_B16_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 570,
        GIR_Done,
      // Label 245: @5141
      GIM_Reject,
    // Label 241: @5142
    GIM_Reject,
    // Label 235: @5143
    GIM_Try, /*On fail goto*//*Label 246*/ 8297,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 247*/ 5242, // Rule ID 7380 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7380,
        GIR_Done,
      // Label 247: @5242
      GIM_Try, /*On fail goto*//*Label 248*/ 5331, // Rule ID 7379 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7379,
        GIR_Done,
      // Label 248: @5331
      GIM_Try, /*On fail goto*//*Label 249*/ 5420, // Rule ID 7378 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7378,
        GIR_Done,
      // Label 249: @5420
      GIM_Try, /*On fail goto*//*Label 250*/ 5509, // Rule ID 7377 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })), (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7377,
        GIR_Done,
      // Label 250: @5509
      GIM_Try, /*On fail goto*//*Label 251*/ 5598, // Rule ID 7374 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7374,
        GIR_Done,
      // Label 251: @5598
      GIM_Try, /*On fail goto*//*Label 252*/ 5687, // Rule ID 7376 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7376,
        GIR_Done,
      // Label 252: @5687
      GIM_Try, /*On fail goto*//*Label 253*/ 5776, // Rule ID 3913 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3913,
        GIR_Done,
      // Label 253: @5776
      GIM_Try, /*On fail goto*//*Label 254*/ 5865, // Rule ID 7375 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7375,
        GIR_Done,
      // Label 254: @5865
      GIM_Try, /*On fail goto*//*Label 255*/ 5961, // Rule ID 1489 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:4:x
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:4:y
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIPFP_MI_Predicate_csh_mask_32,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_18038,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:4:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_18045,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:4:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:4:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_18038>>, i32:{ *:[i32] }:$src2:$pred:4:z)<<P:4:Predicate_anonymous_18045>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHL_OR_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1489,
        GIR_Done,
      // Label 255: @5961
      GIM_Try, /*On fail goto*//*Label 256*/ 6057, // Rule ID 4725 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:4:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:4:x
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:4:y
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIPFP_MI_Predicate_csh_mask_32,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_18038,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_18045,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:4:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:4:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:4:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_18038>>)<<P:4:Predicate_anonymous_18045>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHL_OR_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4725,
        GIR_Done,
      // Label 256: @6057
      GIM_Try, /*On fail goto*//*Label 257*/ 6163, // Rule ID 7425 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7425,
        GIR_Done,
      // Label 257: @6163
      GIM_Try, /*On fail goto*//*Label 258*/ 6269, // Rule ID 7426 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7426,
        GIR_Done,
      // Label 258: @6269
      GIM_Try, /*On fail goto*//*Label 259*/ 6375, // Rule ID 7427 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7427,
        GIR_Done,
      // Label 259: @6375
      GIM_Try, /*On fail goto*//*Label 260*/ 6481, // Rule ID 7428 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7428,
        GIR_Done,
      // Label 260: @6481
      GIM_Try, /*On fail goto*//*Label 261*/ 6587, // Rule ID 7421 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7421,
        GIR_Done,
      // Label 261: @6587
      GIM_Try, /*On fail goto*//*Label 262*/ 6693, // Rule ID 7422 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7422,
        GIR_Done,
      // Label 262: @6693
      GIM_Try, /*On fail goto*//*Label 263*/ 6799, // Rule ID 7423 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7423,
        GIR_Done,
      // Label 263: @6799
      GIM_Try, /*On fail goto*//*Label 264*/ 6905, // Rule ID 7424 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7424,
        GIR_Done,
      // Label 264: @6905
      GIM_Try, /*On fail goto*//*Label 265*/ 7011, // Rule ID 7415 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7415,
        GIR_Done,
      // Label 265: @7011
      GIM_Try, /*On fail goto*//*Label 266*/ 7117, // Rule ID 7416 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7416,
        GIR_Done,
      // Label 266: @7117
      GIM_Try, /*On fail goto*//*Label 267*/ 7223, // Rule ID 7419 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7419,
        GIR_Done,
      // Label 267: @7223
      GIM_Try, /*On fail goto*//*Label 268*/ 7329, // Rule ID 7420 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7420,
        GIR_Done,
      // Label 268: @7329
      GIM_Try, /*On fail goto*//*Label 269*/ 7435, // Rule ID 4081 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4081,
        GIR_Done,
      // Label 269: @7435
      GIM_Try, /*On fail goto*//*Label 270*/ 7541, // Rule ID 7414 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7414,
        GIR_Done,
      // Label 270: @7541
      GIM_Try, /*On fail goto*//*Label 271*/ 7647, // Rule ID 7417 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7417,
        GIR_Done,
      // Label 271: @7647
      GIM_Try, /*On fail goto*//*Label 272*/ 7753, // Rule ID 7418 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)))<<P:Predicate_anonymous_25250>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y), VSrc_b32:{ *:[i32] }:$z, VSrc_b32:{ *:[i32] }:$y)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // z
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7418,
        GIR_Done,
      // Label 272: @7753
      GIM_Try, /*On fail goto*//*Label 273*/ 7806, // Rule ID 4661 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12050,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12088,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] })<<P:Predicate_anonymous_12050>>, i32:{ *:[i32] }:$src0)<<P:Predicate_anonymous_12088>>  =>  (S_ORN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4661,
        GIR_Done,
      // Label 273: @7806
      GIM_Try, /*On fail goto*//*Label 274*/ 7859, // Rule ID 45 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12050,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12088,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src0, (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] })<<P:Predicate_anonymous_12050>>)<<P:Predicate_anonymous_12088>>  =>  (S_ORN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 45,
        GIR_Done,
      // Label 274: @7859
      GIM_Try, /*On fail goto*//*Label 275*/ 7926, // Rule ID 1490 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:5:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_18048,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:5:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_18047,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:5:x, i32:{ *:[i32] }:$src1:$pred:5:y)<<P:Predicate_anonymous_18048>>, i32:{ *:[i32] }:$src2:$pred:5:z)<<P:5:Predicate_anonymous_18047>>  =>  (V_AND_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_AND_OR_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1490,
        GIR_Done,
      // Label 275: @7926
      GIM_Try, /*On fail goto*//*Label 276*/ 7993, // Rule ID 1491 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:6:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:6:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_18051,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:6:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_18050,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:6:x, i32:{ *:[i32] }:$src1:$pred:6:y)<<P:Predicate_anonymous_18051>>, i32:{ *:[i32] }:$src2:$pred:6:z)<<P:6:Predicate_anonymous_18050>>  =>  (V_OR3_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_OR3_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1491,
        GIR_Done,
      // Label 276: @7993
      GIM_Try, /*On fail goto*//*Label 277*/ 8060, // Rule ID 1488 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:4:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:4:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_18038,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:4:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_18045,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:4:x, i32:{ *:[i32] }:$src1:$pred:4:y)<<P:Predicate_anonymous_18038>>, i32:{ *:[i32] }:$src2:$pred:4:z)<<P:4:Predicate_anonymous_18045>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHL_OR_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1488,
        GIR_Done,
      // Label 277: @8060
      GIM_Try, /*On fail goto*//*Label 278*/ 8127, // Rule ID 4726 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:5:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:5:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_18048,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_18047,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:5:z, (and:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:5:x, i32:{ *:[i32] }:$src1:$pred:5:y)<<P:Predicate_anonymous_18048>>)<<P:5:Predicate_anonymous_18047>>  =>  (V_AND_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_AND_OR_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4726,
        GIR_Done,
      // Label 278: @8127
      GIM_Try, /*On fail goto*//*Label 279*/ 8194, // Rule ID 4727 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:6:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:6:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:6:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_18051,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_18050,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:6:z, (or:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:6:x, i32:{ *:[i32] }:$src1:$pred:6:y)<<P:Predicate_anonymous_18051>>)<<P:6:Predicate_anonymous_18050>>  =>  (V_OR3_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_OR3_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4727,
        GIR_Done,
      // Label 279: @8194
      GIM_Try, /*On fail goto*//*Label 280*/ 8261, // Rule ID 4724 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:4:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:4:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:4:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_18038,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_18045,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:4:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:4:x, i32:{ *:[i32] }:$src1:$pred:4:y)<<P:Predicate_anonymous_18038>>)<<P:4:Predicate_anonymous_18045>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHL_OR_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4724,
        GIR_Done,
      // Label 280: @8261
      GIM_Try, /*On fail goto*//*Label 281*/ 8280, // Rule ID 33 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12088,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_12088>>  =>  (S_OR_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_OR_B32,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 33,
        GIR_Done,
      // Label 281: @8280
      GIM_Try, /*On fail goto*//*Label 282*/ 8296, // Rule ID 516 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_OR_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_OR_B32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 516,
        GIR_Done,
      // Label 282: @8296
      GIM_Reject,
    // Label 246: @8297
    GIM_Reject,
    // Label 236: @8298
    GIM_Try, /*On fail goto*//*Label 283*/ 16650,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 284*/ 8595, // Rule ID 7388 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] }), i64:{ *:[i64] }:$z), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/3, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/3, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7388,
        GIR_Done,
      // Label 284: @8595
      GIM_Try, /*On fail goto*//*Label 285*/ 8882, // Rule ID 7387 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] }), i64:{ *:[i64] }:$z), (and:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/3, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/3, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7387,
        GIR_Done,
      // Label 285: @8882
      GIM_Try, /*On fail goto*//*Label 286*/ 9169, // Rule ID 7386 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$z, (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] })), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/3, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/3, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7386,
        GIR_Done,
      // Label 286: @9169
      GIM_Try, /*On fail goto*//*Label 287*/ 9456, // Rule ID 7385 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, -1,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$z, (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] })), (and:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/3, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/3, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7385,
        GIR_Done,
      // Label 287: @9456
      GIM_Try, /*On fail goto*//*Label 288*/ 9743, // Rule ID 7382 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$x), (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] }), i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7382,
        GIR_Done,
      // Label 288: @9743
      GIM_Try, /*On fail goto*//*Label 289*/ 10030, // Rule ID 7384 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$y), (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] }), i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7384,
        GIR_Done,
      // Label 289: @10030
      GIM_Try, /*On fail goto*//*Label 290*/ 10317, // Rule ID 3915 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$x), (and:{ *:[i64] } i64:{ *:[i64] }:$z, (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] })))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 3915,
        GIR_Done,
      // Label 290: @10317
      GIM_Try, /*On fail goto*//*Label 291*/ 10604, // Rule ID 7383 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$y), (and:{ *:[i64] } i64:{ *:[i64] }:$z, (xor:{ *:[i64] } i64:{ *:[i64] }:$x, -1:{ *:[i64] })))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7383,
        GIR_Done,
      // Label 291: @10604
      GIM_Try, /*On fail goto*//*Label 292*/ 10974, // Rule ID 7440 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), i64:{ *:[i64] }:$y), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7440,
        GIR_Done,
      // Label 292: @10974
      GIM_Try, /*On fail goto*//*Label 293*/ 11344, // Rule ID 7441 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), i64:{ *:[i64] }:$y), (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7441,
        GIR_Done,
      // Label 293: @11344
      GIM_Try, /*On fail goto*//*Label 294*/ 11714, // Rule ID 7442 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), i64:{ *:[i64] }:$y), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7442,
        GIR_Done,
      // Label 294: @11714
      GIM_Try, /*On fail goto*//*Label 295*/ 12084, // Rule ID 7443 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), i64:{ *:[i64] }:$y), (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7443,
        GIR_Done,
      // Label 295: @12084
      GIM_Try, /*On fail goto*//*Label 296*/ 12454, // Rule ID 7436 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z)), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7436,
        GIR_Done,
      // Label 296: @12454
      GIM_Try, /*On fail goto*//*Label 297*/ 12824, // Rule ID 7437 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z)), (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7437,
        GIR_Done,
      // Label 297: @12824
      GIM_Try, /*On fail goto*//*Label 298*/ 13194, // Rule ID 7438 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x)), (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7438,
        GIR_Done,
      // Label 298: @13194
      GIM_Try, /*On fail goto*//*Label 299*/ 13564, // Rule ID 7439 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x)), (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7439,
        GIR_Done,
      // Label 299: @13564
      GIM_Try, /*On fail goto*//*Label 300*/ 13934, // Rule ID 7430 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7430,
        GIR_Done,
      // Label 300: @13934
      GIM_Try, /*On fail goto*//*Label 301*/ 14304, // Rule ID 7431 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7431,
        GIR_Done,
      // Label 301: @14304
      GIM_Try, /*On fail goto*//*Label 302*/ 14674, // Rule ID 7434 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7434,
        GIR_Done,
      // Label 302: @14674
      GIM_Try, /*On fail goto*//*Label 303*/ 15044, // Rule ID 7435 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), (and:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), i64:{ *:[i64] }:$y))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7435,
        GIR_Done,
      // Label 303: @15044
      GIM_Try, /*On fail goto*//*Label 304*/ 15414, // Rule ID 4082 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z)))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 4082,
        GIR_Done,
      // Label 304: @15414
      GIM_Try, /*On fail goto*//*Label 305*/ 15784, // Rule ID 7429 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z), (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x)))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7429,
        GIR_Done,
      // Label 305: @15784
      GIM_Try, /*On fail goto*//*Label 306*/ 16154, // Rule ID 7432 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$x, i64:{ *:[i64] }:$z)))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7432,
        GIR_Done,
      // Label 306: @16154
      GIM_Try, /*On fail goto*//*Label 307*/ 16524, // Rule ID 7433 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_OR,
        // MIs[3] z
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] x
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25250,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (or:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x), (and:{ *:[i64] } i64:{ *:[i64] }:$y, (or:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$x)))<<P:Predicate_anonymous_25250>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (V_XOR_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/8, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/9, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/10, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/11, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/12, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/12, /*TempRegID*/11, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/12, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/12, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/11, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/11, /*TempRegID*/10, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/11, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/11, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/10, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/10, /*TempRegID*/9, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/10, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/10, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/9, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/9, /*TempRegID*/8, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/9, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/9, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/8, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/9, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/8,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/10, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/11, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7433,
        GIR_Done,
      // Label 307: @16524
      GIM_Try, /*On fail goto*//*Label 308*/ 16577, // Rule ID 4662 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12050,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12088,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$src1, -1:{ *:[i64] })<<P:Predicate_anonymous_12050>>, i64:{ *:[i64] }:$src0)<<P:Predicate_anonymous_12088>>  =>  (S_ORN2_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4662,
        GIR_Done,
      // Label 308: @16577
      GIM_Try, /*On fail goto*//*Label 309*/ 16630, // Rule ID 46 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12050,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12088,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } i64:{ *:[i64] }:$src0, (xor:{ *:[i64] } i64:{ *:[i64] }:$src1, -1:{ *:[i64] })<<P:Predicate_anonymous_12050>>)<<P:Predicate_anonymous_12088>>  =>  (S_ORN2_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 46,
        GIR_Done,
      // Label 309: @16630
      GIM_Try, /*On fail goto*//*Label 310*/ 16649, // Rule ID 34 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12088,
        // (or:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_12088>>  =>  (S_OR_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_OR_B64,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 34,
        GIR_Done,
      // Label 310: @16649
      GIM_Reject,
    // Label 283: @16650
    GIM_Reject,
    // Label 237: @16651
    GIM_Try, /*On fail goto*//*Label 311*/ 16800,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_Try, /*On fail goto*//*Label 312*/ 16722, // Rule ID 4714 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12124,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12088,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i16] } (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, immAllOnesV:{ *:[v2i16] })<<P:Predicate_anonymous_12124>>, v2i16:{ *:[v2i16] }:$src0)<<P:Predicate_anonymous_12088>>  =>  (S_ORN2_B32:{ *:[v2i16] }:{ *:[i1] } SSrc_b32:{ *:[v2i16] }:$src0, SSrc_b32:{ *:[v2i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4714,
        GIR_Done,
      // Label 312: @16722
      GIM_Try, /*On fail goto*//*Label 313*/ 16783, // Rule ID 1193 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12124,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12088,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, immAllOnesV:{ *:[v2i16] })<<P:Predicate_anonymous_12124>>)<<P:Predicate_anonymous_12088>>  =>  (S_ORN2_B32:{ *:[v2i16] }:{ *:[i1] } SSrc_b32:{ *:[v2i16] }:$src0, SSrc_b32:{ *:[v2i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1193,
        GIR_Done,
      // Label 313: @16783
      GIM_Try, /*On fail goto*//*Label 314*/ 16799, // Rule ID 1428 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (or:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1)  =>  (V_OR_B32_e64:{ *:[v2i16] } VSrc_b32:{ *:[v2i16] }:$src0, VSrc_b32:{ *:[v2i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_OR_B32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1428,
        GIR_Done,
      // Label 314: @16799
      GIM_Reject,
    // Label 311: @16800
    GIM_Reject,
    // Label 238: @16801
    GIM_Try, /*On fail goto*//*Label 315*/ 16927,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12088,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_Try, /*On fail goto*//*Label 316*/ 16872, // Rule ID 4716 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12124,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i32] } (xor:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src1, immAllOnesV:{ *:[v2i32] })<<P:Predicate_anonymous_12124>>, v2i32:{ *:[v2i32] }:$src0)<<P:Predicate_anonymous_12088>>  =>  (S_ORN2_B64:{ *:[v2i32] }:{ *:[i1] } SSrc_b64:{ *:[v2i32] }:$src0, SSrc_b64:{ *:[v2i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4716,
        GIR_Done,
      // Label 316: @16872
      GIM_Try, /*On fail goto*//*Label 317*/ 16926, // Rule ID 1195 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12124,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src0, (xor:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src1, immAllOnesV:{ *:[v2i32] })<<P:Predicate_anonymous_12124>>)<<P:Predicate_anonymous_12088>>  =>  (S_ORN2_B64:{ *:[v2i32] }:{ *:[i1] } SSrc_b64:{ *:[v2i32] }:$src0, SSrc_b64:{ *:[v2i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1195,
        GIR_Done,
      // Label 317: @16926
      GIM_Reject,
    // Label 315: @16927
    GIM_Reject,
    // Label 239: @16928
    GIM_Try, /*On fail goto*//*Label 318*/ 17054,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12088,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_Try, /*On fail goto*//*Label 319*/ 16999, // Rule ID 4715 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12124,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i16] } (xor:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src1, immAllOnesV:{ *:[v4i16] })<<P:Predicate_anonymous_12124>>, v4i16:{ *:[v4i16] }:$src0)<<P:Predicate_anonymous_12088>>  =>  (S_ORN2_B64:{ *:[v4i16] }:{ *:[i1] } SSrc_b64:{ *:[v4i16] }:$src0, SSrc_b64:{ *:[v4i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4715,
        GIR_Done,
      // Label 319: @16999
      GIM_Try, /*On fail goto*//*Label 320*/ 17053, // Rule ID 1194 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_12124,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src0, (xor:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src1, immAllOnesV:{ *:[v4i16] })<<P:Predicate_anonymous_12124>>)<<P:Predicate_anonymous_12088>>  =>  (S_ORN2_B64:{ *:[v4i16] }:{ *:[i1] } SSrc_b64:{ *:[v4i16] }:$src0, SSrc_b64:{ *:[v4i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_ORN2_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1194,
        GIR_Done,
      // Label 320: @17053
      GIM_Reject,
    // Label 318: @17054
    GIM_Reject,
    // Label 240: @17055
    GIM_Reject,
    // Label 5: @17056
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 12, /*)*//*default:*//*Label 325*/ 20660,
    /*GILLT_s16*//*Label 321*/ 17066,
    /*GILLT_s32*//*Label 322*/ 17108,
    /*GILLT_s64*//*Label 323*/ 18240,
    /*GILLT_v2s16*//*Label 324*/ 20635,
    // Label 321: @17066
    GIM_Try, /*On fail goto*//*Label 326*/ 17107,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_Try, /*On fail goto*//*Label 327*/ 17092, // Rule ID 1426 //
        // (xor:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_XOR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1426,
        GIR_Done,
      // Label 327: @17092
      GIM_Try, /*On fail goto*//*Label 328*/ 17106, // Rule ID 571 //
        GIM_CheckFeatures, GIFBS_isGFX11Plus,
        // (xor:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_XOR_B16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_XOR_B16_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 571,
        GIR_Done,
      // Label 328: @17106
      GIM_Reject,
    // Label 326: @17107
    GIM_Reject,
    // Label 322: @17108
    GIM_Try, /*On fail goto*//*Label 329*/ 18239,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 330*/ 17171, // Rule ID 39 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_and_oneuse,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12050,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_and_oneuse>>, -1:{ *:[i32] })<<P:Predicate_anonymous_12050>>  =>  (S_NAND_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_NAND_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 39,
        GIR_Done,
      // Label 330: @17171
      GIM_Try, /*On fail goto*//*Label 331*/ 17228, // Rule ID 41 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_or_oneuse,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12050,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_or_oneuse>>, -1:{ *:[i32] })<<P:Predicate_anonymous_12050>>  =>  (S_NOR_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_NOR_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 41,
        GIR_Done,
      // Label 331: @17228
      GIM_Try, /*On fail goto*//*Label 332*/ 17285, // Rule ID 37 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_xor_oneuse,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12050,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_xor_oneuse>>, -1:{ *:[i32] })<<P:Predicate_anonymous_12050>>  =>  (S_XNOR_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_XNOR_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 37,
        GIR_Done,
      // Label 332: @17285
      GIM_Try, /*On fail goto*//*Label 333*/ 17357, // Rule ID 7394 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[0] z
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$z)<<P:Predicate_anonymous_25255>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7394,
        GIR_Done,
      // Label 333: @17357
      GIM_Try, /*On fail goto*//*Label 334*/ 17429, // Rule ID 7395 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[0] z
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$z)<<P:Predicate_anonymous_25255>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7395,
        GIR_Done,
      // Label 334: @17429
      GIM_Try, /*On fail goto*//*Label 335*/ 17501, // Rule ID 7392 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[0] z
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, (xor:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$z)), i32:{ *:[i32] }:$z)<<P:Predicate_anonymous_25255>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7392,
        GIR_Done,
      // Label 335: @17501
      GIM_Try, /*On fail goto*//*Label 336*/ 17573, // Rule ID 7393 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[0] z
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, (xor:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)), i32:{ *:[i32] }:$z)<<P:Predicate_anonymous_25255>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7393,
        GIR_Done,
      // Label 336: @17573
      GIM_Try, /*On fail goto*//*Label 337*/ 17645, // Rule ID 7391 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] z
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$z, (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y), i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_25255>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7391,
        GIR_Done,
      // Label 337: @17645
      GIM_Try, /*On fail goto*//*Label 338*/ 17717, // Rule ID 7390 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[2] z
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$z, (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_25255>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7390,
        GIR_Done,
      // Label 338: @17717
      GIM_Try, /*On fail goto*//*Label 339*/ 17789, // Rule ID 7389 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] z
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$z, (and:{ *:[i32] } i32:{ *:[i32] }:$x, (xor:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$y)))<<P:Predicate_anonymous_25255>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7389,
        GIR_Done,
      // Label 339: @17789
      GIM_Try, /*On fail goto*//*Label 340*/ 17861, // Rule ID 3916 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        // MIs[2] z
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$z, (and:{ *:[i32] } i32:{ *:[i32] }:$x, (xor:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$z)))<<P:Predicate_anonymous_25255>>  =>  (V_BFI_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$x, VSrc_b32:{ *:[i32] }:$y, VSrc_b32:{ *:[i32] }:$z)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // y
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // z
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3916,
        GIR_Done,
      // Label 340: @17861
      GIM_Try, /*On fail goto*//*Label 341*/ 17894, // Rule ID 0 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12050,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, -1:{ *:[i32] })<<P:Predicate_anonymous_12050>>  =>  (S_NOT_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_NOT_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 0,
        GIR_Done,
      // Label 341: @17894
      GIM_Try, /*On fail goto*//*Label 342*/ 17965, // Rule ID 1503 //
        GIM_CheckFeatures, GIFBS_isGFX10Plus,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:13:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:13:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_18054,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:13:z
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_18084,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:13:x, i32:{ *:[i32] }:$src1:$pred:13:y)<<P:Predicate_anonymous_18054>>, i32:{ *:[i32] }:$src2:$pred:13:z)<<P:13:Predicate_anonymous_18084>>  =>  (V_XOR3_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_XOR3_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1503,
        GIR_Done,
      // Label 342: @17965
      GIM_Try, /*On fail goto*//*Label 343*/ 18036, // Rule ID 4733 //
        GIM_CheckFeatures, GIFBS_isGFX10Plus,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:13:z
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:13:x
        GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:13:y
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_anonymous_18054,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_18084,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:13:z, (xor:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:13:x, i32:{ *:[i32] }:$src1:$pred:13:y)<<P:Predicate_anonymous_18054>>)<<P:13:Predicate_anonymous_18084>>  =>  (V_XOR3_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_XOR3_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4733,
        GIR_Done,
      // Label 343: @18036
      GIM_Try, /*On fail goto*//*Label 344*/ 18059, // Rule ID 35 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12089,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_12089>>  =>  (S_XOR_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_XOR_B32,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 35,
        GIR_Done,
      // Label 344: @18059
      GIM_Try, /*On fail goto*//*Label 345*/ 18112, // Rule ID 4687 //
        GIM_CheckFeatures, GIFBS_HasDLInsts,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, -1:{ *:[i32] }), i32:{ *:[i32] }:$src1)  =>  (V_XNOR_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_XNOR_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4687,
        GIR_Done,
      // Label 345: @18112
      GIM_Try, /*On fail goto*//*Label 346*/ 18165, // Rule ID 568 //
        GIM_CheckFeatures, GIFBS_HasDLInsts,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), -1:{ *:[i32] })  =>  (V_XNOR_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_XNOR_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 568,
        GIR_Done,
      // Label 346: @18165
      GIM_Try, /*On fail goto*//*Label 347*/ 18218, // Rule ID 4688 //
        GIM_CheckFeatures, GIFBS_HasDLInsts,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, -1:{ *:[i32] }))  =>  (V_XNOR_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_XNOR_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4688,
        GIR_Done,
      // Label 347: @18218
      GIM_Try, /*On fail goto*//*Label 348*/ 18238, // Rule ID 517 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (xor:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_XOR_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_XOR_B32_e64,
        GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 517,
        GIR_Done,
      // Label 348: @18238
      GIM_Reject,
    // Label 329: @18239
    GIM_Reject,
    // Label 323: @18240
    GIM_Try, /*On fail goto*//*Label 349*/ 20634,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 350*/ 18303, // Rule ID 40 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_and_oneuse,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12050,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_and_oneuse>>, -1:{ *:[i64] })<<P:Predicate_anonymous_12050>>  =>  (S_NAND_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_NAND_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 40,
        GIR_Done,
      // Label 350: @18303
      GIM_Try, /*On fail goto*//*Label 351*/ 18360, // Rule ID 42 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_OR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_or_oneuse,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12050,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (or:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_or_oneuse>>, -1:{ *:[i64] })<<P:Predicate_anonymous_12050>>  =>  (S_NOR_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_NOR_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 42,
        GIR_Done,
      // Label 351: @18360
      GIM_Try, /*On fail goto*//*Label 352*/ 18417, // Rule ID 38 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_xor_oneuse,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12050,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_xor_oneuse>>, -1:{ *:[i64] })<<P:Predicate_anonymous_12050>>  =>  (S_XNOR_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_XNOR_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 38,
        GIR_Done,
      // Label 352: @18417
      GIM_Try, /*On fail goto*//*Label 353*/ 18687, // Rule ID 7401 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[0] z
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$z), i64:{ *:[i64] }:$x), i64:{ *:[i64] }:$z)<<P:Predicate_anonymous_25255>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7401,
        GIR_Done,
      // Label 353: @18687
      GIM_Try, /*On fail goto*//*Label 354*/ 18957, // Rule ID 7402 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[0] z
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$y), i64:{ *:[i64] }:$x), i64:{ *:[i64] }:$z)<<P:Predicate_anonymous_25255>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7402,
        GIR_Done,
      // Label 354: @18957
      GIM_Try, /*On fail goto*//*Label 355*/ 19227, // Rule ID 7399 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[0] z
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, (xor:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$z)), i64:{ *:[i64] }:$z)<<P:Predicate_anonymous_25255>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7399,
        GIR_Done,
      // Label 355: @19227
      GIM_Try, /*On fail goto*//*Label 356*/ 19497, // Rule ID 7400 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[0] z
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } (and:{ *:[i64] } i64:{ *:[i64] }:$x, (xor:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$y)), i64:{ *:[i64] }:$z)<<P:Predicate_anonymous_25255>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7400,
        GIR_Done,
      // Label 356: @19497
      GIM_Try, /*On fail goto*//*Label 357*/ 19767, // Rule ID 7398 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] z
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$z, (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$y), i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_25255>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7398,
        GIR_Done,
      // Label 357: @19767
      GIM_Try, /*On fail goto*//*Label 358*/ 20037, // Rule ID 7397 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        // MIs[2] z
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$z, (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$z), i64:{ *:[i64] }:$x))<<P:Predicate_anonymous_25255>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7397,
        GIR_Done,
      // Label 358: @20037
      GIM_Try, /*On fail goto*//*Label 359*/ 20307, // Rule ID 7396 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] z
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$z, (and:{ *:[i64] } i64:{ *:[i64] }:$x, (xor:{ *:[i64] } i64:{ *:[i64] }:$z, i64:{ *:[i64] }:$y)))<<P:Predicate_anonymous_25255>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 7396,
        GIR_Done,
      // Label 359: @20307
      GIM_Try, /*On fail goto*//*Label 360*/ 20577, // Rule ID 3917 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        // MIs[2] z
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$z, (and:{ *:[i64] } i64:{ *:[i64] }:$x, (xor:{ *:[i64] } i64:{ *:[i64] }:$y, i64:{ *:[i64] }:$z)))<<P:Predicate_anonymous_25255>>  =>  (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub0:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub0:{ *:[i32] })), sub0:{ *:[i32] }, (V_BFI_B32_e64:{ *:[i16] } (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$x, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$y, sub1:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } VReg_64:{ *:[i64] }:$z, sub1:{ *:[i32] })), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/7, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/8, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/8, /*TempRegID*/7, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/8, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/11, // z
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/8, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/7, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/11, // y
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/7, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/6, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/11, // x
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/5, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/6, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/7, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/3, // z
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/3, // y
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::COPY,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/3, // x
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AMDGPU::VReg_64RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/4, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::VGPR_32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 3917,
        GIR_Done,
      // Label 360: @20577
      GIM_Try, /*On fail goto*//*Label 361*/ 20610, // Rule ID 1 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12050,
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$src0, -1:{ *:[i64] })<<P:Predicate_anonymous_12050>>  =>  (S_NOT_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_NOT_B64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1,
        GIR_Done,
      // Label 361: @20610
      GIM_Try, /*On fail goto*//*Label 362*/ 20633, // Rule ID 36 //
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_12089,
        // (xor:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_12089>>  =>  (S_XOR_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_XOR_B64,
        GIR_AddImplicitDef, /*InsnID*/0, AMDGPU::SCC,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 36,
        GIR_Done,
      // Label 362: @20633
      GIM_Reject,
    // Label 349: @20634
    GIM_Reject,
    // Label 324: @20635
    GIM_Try, /*On fail goto*//*Label 363*/ 20659, // Rule ID 1429 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1)  =>  (V_XOR_B32_e64:{ *:[v2i16] } VSrc_b32:{ *:[v2i16] }:$src0, VSrc_b32:{ *:[v2i16] }:$src1)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::V_XOR_B32_e64,
      GIR_AddImplicitUse, /*InsnID*/0, AMDGPU::EXEC,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1429,
      GIR_Done,
    // Label 363: @20659
    GIM_Reject,
    // Label 325: @20660
    GIM_Reject,
    // Label 6: @20661
    GIM_Try, /*On fail goto*//*Label 364*/ 20712,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_p5s32,
      GIM_Try, /*On fail goto*//*Label 365*/ 20689, // Rule ID 3898 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (frameindex:{ *:[i32] }):$fi  =>  (V_MOV_B32_e32:{ *:[i32] } (frameindex_to_targetframeindex:{ *:[i32] } ?:{ *:[i32] }:$fi))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_MOV_B32_e32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/0, /*Renderer*/GICR_renderFrameIndex, // fi
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3898,
        GIR_Done,
      // Label 365: @20689
      GIM_Try, /*On fail goto*//*Label 366*/ 20711, // Rule ID 3899 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        // (frameindex:{ *:[i32] }):$fi  =>  (S_MOV_B32:{ *:[i32] } (frameindex_to_targetframeindex:{ *:[i32] } ?:{ *:[i32] }:$fi))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/0, /*Renderer*/GICR_renderFrameIndex, // fi
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 3899,
        GIR_Done,
      // Label 366: @20711
      GIM_Reject,
    // Label 364: @20712
    GIM_Reject,
    // Label 7: @20713
    GIM_Try, /*On fail goto*//*Label 367*/ 21831,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_v2s16,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 368*/ 20843, // Rule ID 4054 //
        GIM_CheckFeatures, GIFBS_HasVOP3PInsts,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIPFP_MI_Predicate_srl_oneuse,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 16,
        GIM_CheckCxxInsnPredicate, /*MI*/4, /*FnId*/GIPFP_MI_Predicate_srl_oneuse,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25413,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (build_vector:{ *:[v2i16] } (trunc:{ *:[i16] } (srl:{ *:[i32] } SReg_32:{ *:[i32] }:$src0, 16:{ *:[i32] })<<P:Predicate_srl_oneuse>>), (trunc:{ *:[i16] } (srl:{ *:[i32] } SReg_32:{ *:[i32] }:$src1, 16:{ *:[i32] })<<P:Predicate_srl_oneuse>>))<<P:Predicate_anonymous_25413>>  =>  (S_PACK_HH_B32_B16:{ *:[v2i16] } SReg_32:{ *:[i32] }:$src0, SReg_32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_PACK_HH_B32_B16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4054,
        GIR_Done,
      // Label 368: @20843
      GIM_Try, /*On fail goto*//*Label 369*/ 20994, // Rule ID 4055 //
        GIM_CheckFeatures, GIFBS_HasVOP3PInsts,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIPFP_MI_Predicate_srl_oneuse,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 16,
        GIM_CheckCxxInsnPredicate, /*MI*/4, /*FnId*/GIPFP_MI_Predicate_srl_oneuse,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25415,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (build_vector:{ *:[v2i16] } (trunc:{ *:[i16] } (srl:{ *:[i32] } SReg_32:{ *:[i32] }:$src0, 16:{ *:[i32] })<<P:Predicate_srl_oneuse>>), (trunc:{ *:[i16] } (srl:{ *:[i32] } SReg_32:{ *:[i32] }:$src1, 16:{ *:[i32] })<<P:Predicate_srl_oneuse>>))<<P:Predicate_anonymous_25415>>  =>  (V_AND_OR_B32_e64:{ *:[v2i16] } SReg_32:{ *:[i32] }:$src1, (V_MOV_B32_e32:{ *:[i32] } 4294901760:{ *:[i32] }), (V_LSHRREV_B32_e64:{ *:[i32] } 16:{ *:[i32] }, SReg_32:{ *:[i32] }:$src0))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_LSHRREV_B32_e64,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/2, /*Imm*/16,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_MOV_B32_e32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/4294901760,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_AND_OR_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4055,
        GIR_Done,
      // Label 369: @20994
      GIM_Try, /*On fail goto*//*Label 370*/ 21049, // Rule ID 4058 //
        GIM_CheckFeatures, GIFBS_HasVOP3PInsts,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25436,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_vop3mods,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/1, GICP_gi_vop3mods,
        // (build_vector:{ *:[v2f16] } (VOP3Mods:{ *:[f16] } VGPR_32:{ *:[f16] }:$src0, i32:{ *:[i32] }:$src0_mods), (VOP3Mods:{ *:[f16] } VGPR_32:{ *:[f16] }:$src1, i32:{ *:[i32] }:$src1_mods))<<P:Predicate_anonymous_25436>>  =>  (V_PACK_B32_F16_e64:{ *:[v2f16] } ?:{ *:[i32] }:$src0_mods, VGPR_32:{ *:[f16] }:$src0, ?:{ *:[i32] }:$src1_mods, VGPR_32:{ *:[f16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_PACK_B32_F16_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // src0_mods
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // src0
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/1, /*SubOperand*/1, // src1_mods
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/1, /*SubOperand*/0, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4058,
        GIR_Done,
      // Label 370: @21049
      GIM_Try, /*On fail goto*//*Label 371*/ 21125, // Rule ID 4052 //
        GIM_CheckFeatures, GIFBS_HasVOP3PInsts,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIPFP_MI_Predicate_srl_oneuse,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25413,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (build_vector:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src0, (trunc:{ *:[i16] } (srl:{ *:[i32] } SReg_32:{ *:[i32] }:$src1, 16:{ *:[i32] })<<P:Predicate_srl_oneuse>>))<<P:Predicate_anonymous_25413>>  =>  (S_PACK_LH_B32_B16:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src0, SReg_32:{ *:[i32] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_PACK_LH_B32_B16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4052,
        GIR_Done,
      // Label 371: @21125
      GIM_Try, /*On fail goto*//*Label 372*/ 21220, // Rule ID 4053 //
        GIM_CheckFeatures, GIFBS_HasVOP3PInsts,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIPFP_MI_Predicate_srl_oneuse,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25415,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (build_vector:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src0, (trunc:{ *:[i16] } (srl:{ *:[i32] } SReg_32:{ *:[i32] }:$src1, 16:{ *:[i32] })<<P:Predicate_srl_oneuse>>))<<P:Predicate_anonymous_25415>>  =>  (V_BFI_B32_e64:{ *:[v2i16] } (V_MOV_B32_e32:{ *:[i32] } 65535:{ *:[i32] }), SReg_32:{ *:[i16] }:$src0, SReg_32:{ *:[i32] }:$src1)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_MOV_B32_e32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/65535,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_BFI_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4053,
        GIR_Done,
      // Label 372: @21220
      GIM_Try, /*On fail goto*//*Label 373*/ 21293, // Rule ID 4059 //
        GIM_CheckFeatures, GIFBS_isGFX11Plus,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 16,
        GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIPFP_MI_Predicate_srl_oneuse,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (build_vector:{ *:[v2i16] } (trunc:{ *:[i16] } (srl:{ *:[i32] } SReg_32:{ *:[i32] }:$src0, 16:{ *:[i32] })<<P:Predicate_srl_oneuse>>), SReg_32:{ *:[i16] }:$src1)  =>  (S_PACK_HL_B32_B16:{ *:[v2i16] } SReg_32:{ *:[i32] }:$src0, SReg_32:{ *:[i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_PACK_HL_B32_B16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4059,
        GIR_Done,
      // Label 373: @21293
      GIM_Try, /*On fail goto*//*Label 374*/ 21329, // Rule ID 4037 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25413,
        // (build_vector:{ *:[v2i16] } 0:{ *:[i16] }, SReg_32:{ *:[i16] }:$src1)<<P:Predicate_anonymous_25413>>  =>  (S_LSHL_B32:{ *:[v2i16] }:{ *:[i1] } SReg_32:{ *:[i16] }:$src1, 16:{ *:[i16] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LSHL_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/16,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4037,
        GIR_Done,
      // Label 374: @21329
      GIM_Try, /*On fail goto*//*Label 375*/ 21365, // Rule ID 4038 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25415,
        // (build_vector:{ *:[v2i16] } 0:{ *:[i16] }, SReg_32:{ *:[i16] }:$src1)<<P:Predicate_anonymous_25415>>  =>  (V_LSHLREV_B32_e64:{ *:[v2i16] } 16:{ *:[i16] }, SReg_32:{ *:[i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHLREV_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddImm, /*InsnID*/0, /*Imm*/16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4038,
        GIR_Done,
      // Label 375: @21365
      GIM_Try, /*On fail goto*//*Label 376*/ 21417, // Rule ID 4039 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 0,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25413,
        // (build_vector:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src1, 0:{ *:[i16] })<<P:Predicate_anonymous_25413>>  =>  (S_AND_B32:{ *:[v2i16] }:{ *:[i1] } (S_MOV_B32:{ *:[i1] } 65535:{ *:[i32] }), SReg_32:{ *:[i16] }:$src1)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/65535,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_AND_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4039,
        GIR_Done,
      // Label 376: @21417
      GIM_Try, /*On fail goto*//*Label 377*/ 21469, // Rule ID 4040 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 0,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25415,
        // (build_vector:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src1, 0:{ *:[i16] })<<P:Predicate_anonymous_25415>>  =>  (V_AND_B32_e64:{ *:[v2i16] } (V_MOV_B32_e32:{ *:[i32] } 65535:{ *:[i32] }), SReg_32:{ *:[i16] }:$src1)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_MOV_B32_e32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/65535,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_AND_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4040,
        GIR_Done,
      // Label 377: @21469
      GIM_Try, /*On fail goto*//*Label 378*/ 21510, // Rule ID 4046 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_IMPLICIT_DEF,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25413,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (build_vector:{ *:[v2i16] } (undef:{ *:[i16] }), SReg_32:{ *:[i16] }:$src1)<<P:Predicate_anonymous_25413>>  =>  (S_LSHL_B32:{ *:[v2i16] }:{ *:[i1] } SReg_32:{ *:[i16] }:$src1, 16:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LSHL_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/16,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4046,
        GIR_Done,
      // Label 378: @21510
      GIM_Try, /*On fail goto*//*Label 379*/ 21551, // Rule ID 4047 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_IMPLICIT_DEF,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25415,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (build_vector:{ *:[v2i16] } (undef:{ *:[i16] }), SReg_32:{ *:[i16] }:$src1)<<P:Predicate_anonymous_25415>>  =>  (V_LSHLREV_B32_e64:{ *:[v2i16] } 16:{ *:[i32] }, SReg_32:{ *:[i16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHLREV_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddImm, /*InsnID*/0, /*Imm*/16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4047,
        GIR_Done,
      // Label 379: @21551
      GIM_Try, /*On fail goto*//*Label 380*/ 21592, // Rule ID 4048 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_IMPLICIT_DEF,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25413,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (build_vector:{ *:[v2f16] } (undef:{ *:[f16] }), SReg_32:{ *:[f16] }:$src1)<<P:Predicate_anonymous_25413>>  =>  (S_LSHL_B32:{ *:[v2f16] }:{ *:[i1] } SReg_32:{ *:[f16] }:$src1, 16:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LSHL_B32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/16,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4048,
        GIR_Done,
      // Label 380: @21592
      GIM_Try, /*On fail goto*//*Label 381*/ 21633, // Rule ID 4049 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_IMPLICIT_DEF,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25415,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (build_vector:{ *:[v2f16] } (undef:{ *:[f16] }), SReg_32:{ *:[f16] }:$src1)<<P:Predicate_anonymous_25415>>  =>  (V_LSHLREV_B32_e64:{ *:[v2f16] } 16:{ *:[i32] }, SReg_32:{ *:[f16] }:$src1)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHLREV_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_AddImm, /*InsnID*/0, /*Imm*/16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4049,
        GIR_Done,
      // Label 381: @21633
      GIM_Try, /*On fail goto*//*Label 382*/ 21673, // Rule ID 4043 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_IMPLICIT_DEF,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25413,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (build_vector:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src0, (undef:{ *:[i16] }))<<P:Predicate_anonymous_25413>>  =>  (COPY_TO_REGCLASS:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src0, SReg_32:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
        // GIR_Coverage, 4043,
        GIR_Done,
      // Label 382: @21673
      GIM_Try, /*On fail goto*//*Label 383*/ 21713, // Rule ID 4044 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_IMPLICIT_DEF,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25415,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (build_vector:{ *:[v2i16] } VGPR_32:{ *:[i16] }:$src0, (undef:{ *:[i16] }))<<P:Predicate_anonymous_25415>>  =>  (COPY_TO_REGCLASS:{ *:[v2i16] } VGPR_32:{ *:[i16] }:$src0, VGPR_32:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 4044,
        GIR_Done,
      // Label 383: @21713
      GIM_Try, /*On fail goto*//*Label 384*/ 21753,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25413,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_Try, /*On fail goto*//*Label 385*/ 21741, // Rule ID 4050 //
          GIM_CheckFeatures, GIFBS_HasVOP3PInsts,
          // (build_vector:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src0, SReg_32:{ *:[i16] }:$src1)<<P:Predicate_anonymous_25413>>  =>  (S_PACK_LL_B32_B16:{ *:[v2i16] } SReg_32:{ *:[i16] }:$src0, SReg_32:{ *:[i16] }:$src1)
          GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_PACK_LL_B32_B16,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 4050,
          GIR_Done,
        // Label 385: @21741
        GIM_Try, /*On fail goto*//*Label 386*/ 21752, // Rule ID 4056 //
          GIM_CheckFeatures, GIFBS_HasVOP3PInsts,
          // (build_vector:{ *:[v2f16] } SReg_32:{ *:[f16] }:$src0, SReg_32:{ *:[f16] }:$src1)<<P:Predicate_anonymous_25413>>  =>  (S_PACK_LL_B32_B16:{ *:[v2f16] } SReg_32:{ *:[f16] }:$src0, SReg_32:{ *:[f16] }:$src1)
          GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_PACK_LL_B32_B16,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 4056,
          GIR_Done,
        // Label 386: @21752
        GIM_Reject,
      // Label 384: @21753
      GIM_Try, /*On fail goto*//*Label 387*/ 21830, // Rule ID 4057 //
        GIM_CheckFeatures, GIFBS_HasVOP3PInsts,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_anonymous_25415,
        // (build_vector:{ *:[v2f16] } SReg_32:{ *:[f16] }:$src0, SReg_32:{ *:[f16] }:$src1)<<P:Predicate_anonymous_25415>>  =>  (V_LSHL_OR_B32_e64:{ *:[v2f16] } SReg_32:{ *:[f16] }:$src1, 16:{ *:[i32] }, (V_AND_B32_e64:{ *:[i32] } (V_MOV_B32_e32:{ *:[i32] } 65535:{ *:[i32] }), SReg_32:{ *:[f16] }:$src0))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::V_MOV_B32_e32,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/2, /*Imm*/65535,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::V_AND_B32_e64,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_LSHL_OR_B32_e64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/16,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4057,
        GIR_Done,
      // Label 387: @21830
      GIM_Reject,
    // Label 367: @21831
    GIM_Reject,
    // Label 8: @21832
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 29, /*)*//*default:*//*Label 409*/ 27060,
    /*GILLT_s16*//*Label 388*/ 21859,
    /*GILLT_s32*//*Label 389*/ 21979,
    /*GILLT_s64*//*Label 390*/ 22236,
    /*GILLT_v2s16*//*Label 391*/ 22557,
    /*GILLT_v2s32*//*Label 392*/ 22750,
    /*GILLT_v2s64*//*Label 393*/ 23103,
    /*GILLT_v3s32*//*Label 394*/ 23424,
    /*GILLT_v3s64*//*Label 395*/ 23480,
    /*GILLT_v4s16*//*Label 396*/ 23673,
    /*GILLT_v4s32*//*Label 397*/ 23994,
    /*GILLT_v4s64*//*Label 398*/ 24315,
    /*GILLT_v5s32*//*Label 399*/ 24636,
    /*GILLT_v6s32*//*Label 400*/ 24756,
    /*GILLT_v7s32*//*Label 401*/ 25013,
    /*GILLT_v8s16*//*Label 402*/ 25133,
    /*GILLT_v8s32*//*Label 403*/ 25518,
    /*GILLT_v8s64*//*Label 404*/ 25903,
    /*GILLT_v16s16*//*Label 405*/ 26096,
    /*GILLT_v16s32*//*Label 406*/ 26481,
    /*GILLT_v16s64*//*Label 407*/ 26674,
    /*GILLT_v32s32*//*Label 408*/ 26867,
    // Label 388: @21859
    GIM_Try, /*On fail goto*//*Label 410*/ 21978,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 411*/ 21893, // Rule ID 3689 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (bitconvert:{ *:[i16] } VGPR_32:{ *:[f16] }:$src0)  =>  VGPR_32:{ *:[i16] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 3689,
        GIR_Done,
      // Label 411: @21893
      GIM_Try, /*On fail goto*//*Label 412*/ 21921, // Rule ID 3690 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
        // (bitconvert:{ *:[f16] } VGPR_32:{ *:[i16] }:$src0)  =>  VGPR_32:{ *:[f16] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VGPR_32RegClassID,
        // GIR_Coverage, 3690,
        GIR_Done,
      // Label 412: @21921
      GIM_Try, /*On fail goto*//*Label 413*/ 21949, // Rule ID 3691 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        // (bitconvert:{ *:[i16] } SReg_32:{ *:[f16] }:$src0)  =>  SReg_32:{ *:[i16] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
        // GIR_Coverage, 3691,
        GIR_Done,
      // Label 413: @21949
      GIM_Try, /*On fail goto*//*Label 414*/ 21977, // Rule ID 3692 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
        // (bitconvert:{ *:[f16] } SReg_32:{ *:[i16] }:$src0)  =>  SReg_32:{ *:[f16] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
        // GIR_Coverage, 3692,
        GIR_Done,
      // Label 414: @21977
      GIM_Reject,
    // Label 410: @21978
    GIM_Reject,
    // Label 389: @21979
    GIM_Try, /*On fail goto*//*Label 415*/ 22011, // Rule ID 3693 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (bitconvert:{ *:[i32] } VGPR_32:{ *:[f32] }:$src0)  =>  VGPR_32:{ *:[i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VGPR_32RegClassID,
      // GIR_Coverage, 3693,
      GIR_Done,
    // Label 415: @22011
    GIM_Try, /*On fail goto*//*Label 416*/ 22043, // Rule ID 3694 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VGPR_32RegClassID,
      // (bitconvert:{ *:[f32] } VGPR_32:{ *:[i32] }:$src0)  =>  VGPR_32:{ *:[f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VGPR_32RegClassID,
      // GIR_Coverage, 3694,
      GIR_Done,
    // Label 416: @22043
    GIM_Try, /*On fail goto*//*Label 417*/ 22075, // Rule ID 3695 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[i32] } SReg_32:{ *:[f32] }:$src0)  =>  SReg_32:{ *:[i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3695,
      GIR_Done,
    // Label 417: @22075
    GIM_Try, /*On fail goto*//*Label 418*/ 22107, // Rule ID 3696 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[f32] } SReg_32:{ *:[i32] }:$src0)  =>  SReg_32:{ *:[f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3696,
      GIR_Done,
    // Label 418: @22107
    GIM_Try, /*On fail goto*//*Label 419*/ 22139, // Rule ID 3698 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[i32] } SReg_32:{ *:[v2i16] }:$src0)  =>  SReg_32:{ *:[i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3698,
      GIR_Done,
    // Label 419: @22139
    GIM_Try, /*On fail goto*//*Label 420*/ 22171, // Rule ID 3700 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[i32] } SReg_32:{ *:[v2f16] }:$src0)  =>  SReg_32:{ *:[i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3700,
      GIR_Done,
    // Label 420: @22171
    GIM_Try, /*On fail goto*//*Label 421*/ 22203, // Rule ID 3704 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[f32] } SReg_32:{ *:[v2f16] }:$src0)  =>  SReg_32:{ *:[f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3704,
      GIR_Done,
    // Label 421: @22203
    GIM_Try, /*On fail goto*//*Label 422*/ 22235, // Rule ID 3706 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[f32] } SReg_32:{ *:[v2i16] }:$src0)  =>  SReg_32:{ *:[f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3706,
      GIR_Done,
    // Label 422: @22235
    GIM_Reject,
    // Label 390: @22236
    GIM_Try, /*On fail goto*//*Label 423*/ 22268, // Rule ID 3707 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3707,
      GIR_Done,
    // Label 423: @22268
    GIM_Try, /*On fail goto*//*Label 424*/ 22300, // Rule ID 3708 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3708,
      GIR_Done,
    // Label 424: @22300
    GIM_Try, /*On fail goto*//*Label 425*/ 22332, // Rule ID 3711 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3711,
      GIR_Done,
    // Label 425: @22332
    GIM_Try, /*On fail goto*//*Label 426*/ 22364, // Rule ID 3713 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3713,
      GIR_Done,
    // Label 426: @22364
    GIM_Try, /*On fail goto*//*Label 427*/ 22396, // Rule ID 3715 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3715,
      GIR_Done,
    // Label 427: @22396
    GIM_Try, /*On fail goto*//*Label 428*/ 22428, // Rule ID 3717 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3717,
      GIR_Done,
    // Label 428: @22428
    GIM_Try, /*On fail goto*//*Label 429*/ 22460, // Rule ID 3732 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3732,
      GIR_Done,
    // Label 429: @22460
    GIM_Try, /*On fail goto*//*Label 430*/ 22492, // Rule ID 3733 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[f64] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3733,
      GIR_Done,
    // Label 430: @22492
    GIM_Try, /*On fail goto*//*Label 431*/ 22524, // Rule ID 3736 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3736,
      GIR_Done,
    // Label 431: @22524
    GIM_Try, /*On fail goto*//*Label 432*/ 22556, // Rule ID 3737 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[i64] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3737,
      GIR_Done,
    // Label 432: @22556
    GIM_Reject,
    // Label 391: @22557
    GIM_Try, /*On fail goto*//*Label 433*/ 22589, // Rule ID 3697 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2i16] } SReg_32:{ *:[i32] }:$src0)  =>  SReg_32:{ *:[v2i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3697,
      GIR_Done,
    // Label 433: @22589
    GIM_Try, /*On fail goto*//*Label 434*/ 22621, // Rule ID 3699 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2f16] } SReg_32:{ *:[i32] }:$src0)  =>  SReg_32:{ *:[v2f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3699,
      GIR_Done,
    // Label 434: @22621
    GIM_Try, /*On fail goto*//*Label 435*/ 22653, // Rule ID 3701 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2i16] } SReg_32:{ *:[v2f16] }:$src0)  =>  SReg_32:{ *:[v2i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3701,
      GIR_Done,
    // Label 435: @22653
    GIM_Try, /*On fail goto*//*Label 436*/ 22685, // Rule ID 3702 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2f16] } SReg_32:{ *:[v2i16] }:$src0)  =>  SReg_32:{ *:[v2f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3702,
      GIR_Done,
    // Label 436: @22685
    GIM_Try, /*On fail goto*//*Label 437*/ 22717, // Rule ID 3703 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2f16] } SReg_32:{ *:[f32] }:$src0)  =>  SReg_32:{ *:[v2f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3703,
      GIR_Done,
    // Label 437: @22717
    GIM_Try, /*On fail goto*//*Label 438*/ 22749, // Rule ID 3705 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_32RegClassID,
      // (bitconvert:{ *:[v2i16] } SReg_32:{ *:[f32] }:$src0)  =>  SReg_32:{ *:[v2i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_32RegClassID,
      // GIR_Coverage, 3705,
      GIR_Done,
    // Label 438: @22749
    GIM_Reject,
    // Label 392: @22750
    GIM_Try, /*On fail goto*//*Label 439*/ 22782, // Rule ID 3709 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3709,
      GIR_Done,
    // Label 439: @22782
    GIM_Try, /*On fail goto*//*Label 440*/ 22814, // Rule ID 3710 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3710,
      GIR_Done,
    // Label 440: @22814
    GIM_Try, /*On fail goto*//*Label 441*/ 22846, // Rule ID 3712 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3712,
      GIR_Done,
    // Label 441: @22846
    GIM_Try, /*On fail goto*//*Label 442*/ 22878, // Rule ID 3714 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3714,
      GIR_Done,
    // Label 442: @22878
    GIM_Try, /*On fail goto*//*Label 443*/ 22910, // Rule ID 3716 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3716,
      GIR_Done,
    // Label 443: @22910
    GIM_Try, /*On fail goto*//*Label 444*/ 22942, // Rule ID 3718 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3718,
      GIR_Done,
    // Label 444: @22942
    GIM_Try, /*On fail goto*//*Label 445*/ 22974, // Rule ID 3721 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3721,
      GIR_Done,
    // Label 445: @22974
    GIM_Try, /*On fail goto*//*Label 446*/ 23006, // Rule ID 3723 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3723,
      GIR_Done,
    // Label 446: @23006
    GIM_Try, /*On fail goto*//*Label 447*/ 23038, // Rule ID 3724 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2i32] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[v2i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3724,
      GIR_Done,
    // Label 447: @23038
    GIM_Try, /*On fail goto*//*Label 448*/ 23070, // Rule ID 3726 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3726,
      GIR_Done,
    // Label 448: @23070
    GIM_Try, /*On fail goto*//*Label 449*/ 23102, // Rule ID 3728 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v2f32] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[v2f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3728,
      GIR_Done,
    // Label 449: @23102
    GIM_Reject,
    // Label 393: @23103
    GIM_Try, /*On fail goto*//*Label 450*/ 23135, // Rule ID 3742 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v2i64] } SReg_128:{ *:[v4i32] }:$src0)  =>  SReg_128:{ *:[v2i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3742,
      GIR_Done,
    // Label 450: @23135
    GIM_Try, /*On fail goto*//*Label 451*/ 23167, // Rule ID 3744 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v2f64] } VReg_128:{ *:[v4f32] }:$src0)  =>  VReg_128:{ *:[v2f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3744,
      GIR_Done,
    // Label 451: @23167
    GIM_Try, /*On fail goto*//*Label 452*/ 23199, // Rule ID 3745 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v2f64] } VReg_128:{ *:[v4i32] }:$src0)  =>  VReg_128:{ *:[v2f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3745,
      GIR_Done,
    // Label 452: @23199
    GIM_Try, /*On fail goto*//*Label 453*/ 23231, // Rule ID 3748 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v2i64] } VReg_128:{ *:[v2f64] }:$src0)  =>  VReg_128:{ *:[v2i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3748,
      GIR_Done,
    // Label 453: @23231
    GIM_Try, /*On fail goto*//*Label 454*/ 23263, // Rule ID 3749 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v2f64] } VReg_128:{ *:[v2i64] }:$src0)  =>  VReg_128:{ *:[v2f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3749,
      GIR_Done,
    // Label 454: @23263
    GIM_Try, /*On fail goto*//*Label 455*/ 23295, // Rule ID 3751 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v2i64] } VReg_128:{ *:[v4f32] }:$src0)  =>  VReg_128:{ *:[v2i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3751,
      GIR_Done,
    // Label 455: @23295
    GIM_Try, /*On fail goto*//*Label 456*/ 23327, // Rule ID 3768 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v2i64] } SReg_128:{ *:[v8i16] }:$src0)  =>  SReg_128:{ *:[v2i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3768,
      GIR_Done,
    // Label 456: @23327
    GIM_Try, /*On fail goto*//*Label 457*/ 23359, // Rule ID 3769 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v2f64] } SReg_128:{ *:[v8i16] }:$src0)  =>  SReg_128:{ *:[v2f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3769,
      GIR_Done,
    // Label 457: @23359
    GIM_Try, /*On fail goto*//*Label 458*/ 23391, // Rule ID 3770 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v2i64] } SReg_128:{ *:[v8f16] }:$src0)  =>  SReg_128:{ *:[v2i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3770,
      GIR_Done,
    // Label 458: @23391
    GIM_Try, /*On fail goto*//*Label 459*/ 23423, // Rule ID 3771 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v2f64] } SReg_128:{ *:[v8f16] }:$src0)  =>  SReg_128:{ *:[v2f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3771,
      GIR_Done,
    // Label 459: @23423
    GIM_Reject,
    // Label 394: @23424
    GIM_Try, /*On fail goto*//*Label 460*/ 23479,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v3s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SGPR_96RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SGPR_96RegClassID,
      GIM_Try, /*On fail goto*//*Label 461*/ 23458, // Rule ID 3740 //
        // (bitconvert:{ *:[v3i32] } SGPR_96:{ *:[v3f32] }:$src0)  =>  SGPR_96:{ *:[v3i32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SGPR_96RegClassID,
        // GIR_Coverage, 3740,
        GIR_Done,
      // Label 461: @23458
      GIM_Try, /*On fail goto*//*Label 462*/ 23478, // Rule ID 3741 //
        // (bitconvert:{ *:[v3f32] } SGPR_96:{ *:[v3i32] }:$src0)  =>  SGPR_96:{ *:[v3f32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SGPR_96RegClassID,
        // GIR_Coverage, 3741,
        GIR_Done,
      // Label 462: @23478
      GIM_Reject,
    // Label 460: @23479
    GIM_Reject,
    // Label 395: @23480
    GIM_Try, /*On fail goto*//*Label 463*/ 23512, // Rule ID 3780 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v3s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v3i64] } VReg_192:{ *:[v3f64] }:$src0)  =>  VReg_192:{ *:[v3i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3780,
      GIR_Done,
    // Label 463: @23512
    GIM_Try, /*On fail goto*//*Label 464*/ 23544, // Rule ID 3781 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v3s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v3f64] } VReg_192:{ *:[v3i64] }:$src0)  =>  VReg_192:{ *:[v3f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3781,
      GIR_Done,
    // Label 464: @23544
    GIM_Try, /*On fail goto*//*Label 465*/ 23576, // Rule ID 3782 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v3i64] } VReg_192:{ *:[v6i32] }:$src0)  =>  VReg_192:{ *:[v3i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3782,
      GIR_Done,
    // Label 465: @23576
    GIM_Try, /*On fail goto*//*Label 466*/ 23608, // Rule ID 3783 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v3i64] } VReg_192:{ *:[v6f32] }:$src0)  =>  VReg_192:{ *:[v3i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3783,
      GIR_Done,
    // Label 466: @23608
    GIM_Try, /*On fail goto*//*Label 467*/ 23640, // Rule ID 3784 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v3f64] } VReg_192:{ *:[v6i32] }:$src0)  =>  VReg_192:{ *:[v3f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3784,
      GIR_Done,
    // Label 467: @23640
    GIM_Try, /*On fail goto*//*Label 468*/ 23672, // Rule ID 3785 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v3f64] } VReg_192:{ *:[v6f32] }:$src0)  =>  VReg_192:{ *:[v3f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3785,
      GIR_Done,
    // Label 468: @23672
    GIM_Reject,
    // Label 396: @23673
    GIM_Try, /*On fail goto*//*Label 469*/ 23705, // Rule ID 3719 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[v4f16] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3719,
      GIR_Done,
    // Label 469: @23705
    GIM_Try, /*On fail goto*//*Label 470*/ 23737, // Rule ID 3720 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[v4i16] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3720,
      GIR_Done,
    // Label 470: @23737
    GIM_Try, /*On fail goto*//*Label 471*/ 23769, // Rule ID 3722 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3722,
      GIR_Done,
    // Label 471: @23769
    GIM_Try, /*On fail goto*//*Label 472*/ 23801, // Rule ID 3725 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[v2i32] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3725,
      GIR_Done,
    // Label 472: @23801
    GIM_Try, /*On fail goto*//*Label 473*/ 23833, // Rule ID 3727 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3727,
      GIR_Done,
    // Label 473: @23833
    GIM_Try, /*On fail goto*//*Label 474*/ 23865, // Rule ID 3729 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[v2f32] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3729,
      GIR_Done,
    // Label 474: @23865
    GIM_Try, /*On fail goto*//*Label 475*/ 23897, // Rule ID 3730 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3730,
      GIR_Done,
    // Label 475: @23897
    GIM_Try, /*On fail goto*//*Label 476*/ 23929, // Rule ID 3731 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[f64] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3731,
      GIR_Done,
    // Label 476: @23929
    GIM_Try, /*On fail goto*//*Label 477*/ 23961, // Rule ID 3734 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4i16] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[v4i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3734,
      GIR_Done,
    // Label 477: @23961
    GIM_Try, /*On fail goto*//*Label 478*/ 23993, // Rule ID 3735 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_64RegClassID,
      // (bitconvert:{ *:[v4f16] } VReg_64:{ *:[i64] }:$src0)  =>  VReg_64:{ *:[v4f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_64RegClassID,
      // GIR_Coverage, 3735,
      GIR_Done,
    // Label 478: @23993
    GIM_Reject,
    // Label 397: @23994
    GIM_Try, /*On fail goto*//*Label 479*/ 24026, // Rule ID 3738 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4i32] } VReg_128:{ *:[v4f32] }:$src0)  =>  VReg_128:{ *:[v4i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3738,
      GIR_Done,
    // Label 479: @24026
    GIM_Try, /*On fail goto*//*Label 480*/ 24058, // Rule ID 3739 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4f32] } VReg_128:{ *:[v4i32] }:$src0)  =>  VReg_128:{ *:[v4f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3739,
      GIR_Done,
    // Label 480: @24058
    GIM_Try, /*On fail goto*//*Label 481*/ 24090, // Rule ID 3743 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v4i32] } SReg_128:{ *:[v2i64] }:$src0)  =>  SReg_128:{ *:[v4i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3743,
      GIR_Done,
    // Label 481: @24090
    GIM_Try, /*On fail goto*//*Label 482*/ 24122, // Rule ID 3746 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4f32] } VReg_128:{ *:[v2f64] }:$src0)  =>  VReg_128:{ *:[v4f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3746,
      GIR_Done,
    // Label 482: @24122
    GIM_Try, /*On fail goto*//*Label 483*/ 24154, // Rule ID 3747 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4i32] } VReg_128:{ *:[v2f64] }:$src0)  =>  VReg_128:{ *:[v4i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3747,
      GIR_Done,
    // Label 483: @24154
    GIM_Try, /*On fail goto*//*Label 484*/ 24186, // Rule ID 3750 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4f32] } VReg_128:{ *:[v2i64] }:$src0)  =>  VReg_128:{ *:[v4f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3750,
      GIR_Done,
    // Label 484: @24186
    GIM_Try, /*On fail goto*//*Label 485*/ 24218, // Rule ID 3753 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v4i32] } SReg_128:{ *:[v8i16] }:$src0)  =>  SReg_128:{ *:[v4i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3753,
      GIR_Done,
    // Label 485: @24218
    GIM_Try, /*On fail goto*//*Label 486*/ 24250, // Rule ID 3756 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4f32] } VReg_128:{ *:[v8f16] }:$src0)  =>  VReg_128:{ *:[v4f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3756,
      GIR_Done,
    // Label 486: @24250
    GIM_Try, /*On fail goto*//*Label 487*/ 24282, // Rule ID 3757 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4i32] } VReg_128:{ *:[v8f16] }:$src0)  =>  VReg_128:{ *:[v4i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3757,
      GIR_Done,
    // Label 487: @24282
    GIM_Try, /*On fail goto*//*Label 488*/ 24314, // Rule ID 3760 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v4f32] } VReg_128:{ *:[v8i16] }:$src0)  =>  VReg_128:{ *:[v4f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3760,
      GIR_Done,
    // Label 488: @24314
    GIM_Reject,
    // Label 398: @24315
    GIM_Try, /*On fail goto*//*Label 489*/ 24347, // Rule ID 3798 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v4i64] } VReg_256:{ *:[v4f64] }:$src0)  =>  VReg_256:{ *:[v4i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3798,
      GIR_Done,
    // Label 489: @24347
    GIM_Try, /*On fail goto*//*Label 490*/ 24379, // Rule ID 3799 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v4f64] } VReg_256:{ *:[v4i64] }:$src0)  =>  VReg_256:{ *:[v4f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3799,
      GIR_Done,
    // Label 490: @24379
    GIM_Try, /*On fail goto*//*Label 491*/ 24411, // Rule ID 3800 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v4i64] } VReg_256:{ *:[v8i32] }:$src0)  =>  VReg_256:{ *:[v4i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3800,
      GIR_Done,
    // Label 491: @24411
    GIM_Try, /*On fail goto*//*Label 492*/ 24443, // Rule ID 3801 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v4i64] } VReg_256:{ *:[v8f32] }:$src0)  =>  VReg_256:{ *:[v4i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3801,
      GIR_Done,
    // Label 492: @24443
    GIM_Try, /*On fail goto*//*Label 493*/ 24475, // Rule ID 3802 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v4f64] } VReg_256:{ *:[v8i32] }:$src0)  =>  VReg_256:{ *:[v4f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3802,
      GIR_Done,
    // Label 493: @24475
    GIM_Try, /*On fail goto*//*Label 494*/ 24507, // Rule ID 3803 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v4f64] } VReg_256:{ *:[v8f32] }:$src0)  =>  VReg_256:{ *:[v4f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3803,
      GIR_Done,
    // Label 494: @24507
    GIM_Try, /*On fail goto*//*Label 495*/ 24539, // Rule ID 3824 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v4i64] } VReg_256:{ *:[v16f16] }:$src0)  =>  VReg_256:{ *:[v4i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3824,
      GIR_Done,
    // Label 495: @24539
    GIM_Try, /*On fail goto*//*Label 496*/ 24571, // Rule ID 3825 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v4i64] } VReg_256:{ *:[v16i16] }:$src0)  =>  VReg_256:{ *:[v4i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3825,
      GIR_Done,
    // Label 496: @24571
    GIM_Try, /*On fail goto*//*Label 497*/ 24603, // Rule ID 3826 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v4f64] } VReg_256:{ *:[v16f16] }:$src0)  =>  VReg_256:{ *:[v4f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3826,
      GIR_Done,
    // Label 497: @24603
    GIM_Try, /*On fail goto*//*Label 498*/ 24635, // Rule ID 3827 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v4f64] } VReg_256:{ *:[v16i16] }:$src0)  =>  VReg_256:{ *:[v4f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3827,
      GIR_Done,
    // Label 498: @24635
    GIM_Reject,
    // Label 399: @24636
    GIM_Try, /*On fail goto*//*Label 499*/ 24755,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v5s32,
      GIM_Try, /*On fail goto*//*Label 500*/ 24670, // Rule ID 3772 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_160RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_160RegClassID,
        // (bitconvert:{ *:[v5i32] } SReg_160:{ *:[v5f32] }:$src0)  =>  SReg_160:{ *:[v5i32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_160RegClassID,
        // GIR_Coverage, 3772,
        GIR_Done,
      // Label 500: @24670
      GIM_Try, /*On fail goto*//*Label 501*/ 24698, // Rule ID 3773 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_160RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_160RegClassID,
        // (bitconvert:{ *:[v5f32] } SReg_160:{ *:[v5i32] }:$src0)  =>  SReg_160:{ *:[v5f32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_160RegClassID,
        // GIR_Coverage, 3773,
        GIR_Done,
      // Label 501: @24698
      GIM_Try, /*On fail goto*//*Label 502*/ 24726, // Rule ID 3774 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_160RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_160RegClassID,
        // (bitconvert:{ *:[v5i32] } VReg_160:{ *:[v5f32] }:$src0)  =>  VReg_160:{ *:[v5i32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_160RegClassID,
        // GIR_Coverage, 3774,
        GIR_Done,
      // Label 502: @24726
      GIM_Try, /*On fail goto*//*Label 503*/ 24754, // Rule ID 3775 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_160RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_160RegClassID,
        // (bitconvert:{ *:[v5f32] } VReg_160:{ *:[v5i32] }:$src0)  =>  VReg_160:{ *:[v5f32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_160RegClassID,
        // GIR_Coverage, 3775,
        GIR_Done,
      // Label 503: @24754
      GIM_Reject,
    // Label 499: @24755
    GIM_Reject,
    // Label 400: @24756
    GIM_Try, /*On fail goto*//*Label 504*/ 24788, // Rule ID 3776 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_192RegClassID,
      // (bitconvert:{ *:[v6i32] } SReg_192:{ *:[v6f32] }:$src0)  =>  SReg_192:{ *:[v6i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_192RegClassID,
      // GIR_Coverage, 3776,
      GIR_Done,
    // Label 504: @24788
    GIM_Try, /*On fail goto*//*Label 505*/ 24820, // Rule ID 3777 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_192RegClassID,
      // (bitconvert:{ *:[v6f32] } SReg_192:{ *:[v6i32] }:$src0)  =>  SReg_192:{ *:[v6f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_192RegClassID,
      // GIR_Coverage, 3777,
      GIR_Done,
    // Label 505: @24820
    GIM_Try, /*On fail goto*//*Label 506*/ 24852, // Rule ID 3778 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v6i32] } VReg_192:{ *:[v6f32] }:$src0)  =>  VReg_192:{ *:[v6i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3778,
      GIR_Done,
    // Label 506: @24852
    GIM_Try, /*On fail goto*//*Label 507*/ 24884, // Rule ID 3779 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v6s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v6f32] } VReg_192:{ *:[v6i32] }:$src0)  =>  VReg_192:{ *:[v6f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3779,
      GIR_Done,
    // Label 507: @24884
    GIM_Try, /*On fail goto*//*Label 508*/ 24916, // Rule ID 3786 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v3s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v6i32] } VReg_192:{ *:[v3i64] }:$src0)  =>  VReg_192:{ *:[v6i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3786,
      GIR_Done,
    // Label 508: @24916
    GIM_Try, /*On fail goto*//*Label 509*/ 24948, // Rule ID 3787 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v3s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v6f32] } VReg_192:{ *:[v3i64] }:$src0)  =>  VReg_192:{ *:[v6f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3787,
      GIR_Done,
    // Label 509: @24948
    GIM_Try, /*On fail goto*//*Label 510*/ 24980, // Rule ID 3788 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v3s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v6i32] } VReg_192:{ *:[v3f64] }:$src0)  =>  VReg_192:{ *:[v6i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3788,
      GIR_Done,
    // Label 510: @24980
    GIM_Try, /*On fail goto*//*Label 511*/ 25012, // Rule ID 3789 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v3s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_192RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_192RegClassID,
      // (bitconvert:{ *:[v6f32] } VReg_192:{ *:[v3f64] }:$src0)  =>  VReg_192:{ *:[v6f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_192RegClassID,
      // GIR_Coverage, 3789,
      GIR_Done,
    // Label 511: @25012
    GIM_Reject,
    // Label 401: @25013
    GIM_Try, /*On fail goto*//*Label 512*/ 25132,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v7s32,
      GIM_Try, /*On fail goto*//*Label 513*/ 25047, // Rule ID 3790 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_224RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_224RegClassID,
        // (bitconvert:{ *:[v7i32] } SReg_224:{ *:[v7f32] }:$src0)  =>  SReg_224:{ *:[v7i32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_224RegClassID,
        // GIR_Coverage, 3790,
        GIR_Done,
      // Label 513: @25047
      GIM_Try, /*On fail goto*//*Label 514*/ 25075, // Rule ID 3791 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_224RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_224RegClassID,
        // (bitconvert:{ *:[v7f32] } SReg_224:{ *:[v7i32] }:$src0)  =>  SReg_224:{ *:[v7f32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_224RegClassID,
        // GIR_Coverage, 3791,
        GIR_Done,
      // Label 514: @25075
      GIM_Try, /*On fail goto*//*Label 515*/ 25103, // Rule ID 3792 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_224RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_224RegClassID,
        // (bitconvert:{ *:[v7i32] } VReg_224:{ *:[v7f32] }:$src0)  =>  VReg_224:{ *:[v7i32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_224RegClassID,
        // GIR_Coverage, 3792,
        GIR_Done,
      // Label 515: @25103
      GIM_Try, /*On fail goto*//*Label 516*/ 25131, // Rule ID 3793 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_224RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_224RegClassID,
        // (bitconvert:{ *:[v7f32] } VReg_224:{ *:[v7i32] }:$src0)  =>  VReg_224:{ *:[v7f32] }:$src0
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_224RegClassID,
        // GIR_Coverage, 3793,
        GIR_Done,
      // Label 516: @25131
      GIM_Reject,
    // Label 512: @25132
    GIM_Reject,
    // Label 402: @25133
    GIM_Try, /*On fail goto*//*Label 517*/ 25165, // Rule ID 3752 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v8i16] } SReg_128:{ *:[v4i32] }:$src0)  =>  SReg_128:{ *:[v8i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3752,
      GIR_Done,
    // Label 517: @25165
    GIM_Try, /*On fail goto*//*Label 518*/ 25197, // Rule ID 3754 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v8f16] } VReg_128:{ *:[v4f32] }:$src0)  =>  VReg_128:{ *:[v8f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3754,
      GIR_Done,
    // Label 518: @25197
    GIM_Try, /*On fail goto*//*Label 519*/ 25229, // Rule ID 3755 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v8f16] } VReg_128:{ *:[v4i32] }:$src0)  =>  VReg_128:{ *:[v8f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3755,
      GIR_Done,
    // Label 519: @25229
    GIM_Try, /*On fail goto*//*Label 520*/ 25261, // Rule ID 3758 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v8i16] } VReg_128:{ *:[v8f16] }:$src0)  =>  VReg_128:{ *:[v8i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3758,
      GIR_Done,
    // Label 520: @25261
    GIM_Try, /*On fail goto*//*Label 521*/ 25293, // Rule ID 3759 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v8f16] } VReg_128:{ *:[v8i16] }:$src0)  =>  VReg_128:{ *:[v8f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3759,
      GIR_Done,
    // Label 521: @25293
    GIM_Try, /*On fail goto*//*Label 522*/ 25325, // Rule ID 3761 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_128RegClassID,
      // (bitconvert:{ *:[v8i16] } VReg_128:{ *:[v4f32] }:$src0)  =>  VReg_128:{ *:[v8i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_128RegClassID,
      // GIR_Coverage, 3761,
      GIR_Done,
    // Label 522: @25325
    GIM_Try, /*On fail goto*//*Label 523*/ 25357, // Rule ID 3762 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v8i16] } SReg_128:{ *:[v8f16] }:$src0)  =>  SReg_128:{ *:[v8i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3762,
      GIR_Done,
    // Label 523: @25357
    GIM_Try, /*On fail goto*//*Label 524*/ 25389, // Rule ID 3763 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v8i16] } SReg_128:{ *:[v2i64] }:$src0)  =>  SReg_128:{ *:[v8i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3763,
      GIR_Done,
    // Label 524: @25389
    GIM_Try, /*On fail goto*//*Label 525*/ 25421, // Rule ID 3764 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v8i16] } SReg_128:{ *:[v2f64] }:$src0)  =>  SReg_128:{ *:[v8i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3764,
      GIR_Done,
    // Label 525: @25421
    GIM_Try, /*On fail goto*//*Label 526*/ 25453, // Rule ID 3765 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v8f16] } SReg_128:{ *:[v2i64] }:$src0)  =>  SReg_128:{ *:[v8f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3765,
      GIR_Done,
    // Label 526: @25453
    GIM_Try, /*On fail goto*//*Label 527*/ 25485, // Rule ID 3766 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v8f16] } SReg_128:{ *:[v2f64] }:$src0)  =>  SReg_128:{ *:[v8f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3766,
      GIR_Done,
    // Label 527: @25485
    GIM_Try, /*On fail goto*//*Label 528*/ 25517, // Rule ID 3767 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_128RegClassID,
      // (bitconvert:{ *:[v8f16] } SReg_128:{ *:[v8i16] }:$src0)  =>  SReg_128:{ *:[v8f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_128RegClassID,
      // GIR_Coverage, 3767,
      GIR_Done,
    // Label 528: @25517
    GIM_Reject,
    // Label 403: @25518
    GIM_Try, /*On fail goto*//*Label 529*/ 25550, // Rule ID 3794 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_256RegClassID,
      // (bitconvert:{ *:[v8i32] } SReg_256:{ *:[v8f32] }:$src0)  =>  SReg_256:{ *:[v8i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_256RegClassID,
      // GIR_Coverage, 3794,
      GIR_Done,
    // Label 529: @25550
    GIM_Try, /*On fail goto*//*Label 530*/ 25582, // Rule ID 3795 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_256RegClassID,
      // (bitconvert:{ *:[v8f32] } SReg_256:{ *:[v8i32] }:$src0)  =>  SReg_256:{ *:[v8f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_256RegClassID,
      // GIR_Coverage, 3795,
      GIR_Done,
    // Label 530: @25582
    GIM_Try, /*On fail goto*//*Label 531*/ 25614, // Rule ID 3796 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v8i32] } VReg_256:{ *:[v8f32] }:$src0)  =>  VReg_256:{ *:[v8i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3796,
      GIR_Done,
    // Label 531: @25614
    GIM_Try, /*On fail goto*//*Label 532*/ 25646, // Rule ID 3797 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v8f32] } VReg_256:{ *:[v8i32] }:$src0)  =>  VReg_256:{ *:[v8f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3797,
      GIR_Done,
    // Label 532: @25646
    GIM_Try, /*On fail goto*//*Label 533*/ 25678, // Rule ID 3804 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v8i32] } VReg_256:{ *:[v4i64] }:$src0)  =>  VReg_256:{ *:[v8i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3804,
      GIR_Done,
    // Label 533: @25678
    GIM_Try, /*On fail goto*//*Label 534*/ 25710, // Rule ID 3805 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v8f32] } VReg_256:{ *:[v4i64] }:$src0)  =>  VReg_256:{ *:[v8f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3805,
      GIR_Done,
    // Label 534: @25710
    GIM_Try, /*On fail goto*//*Label 535*/ 25742, // Rule ID 3806 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v8i32] } VReg_256:{ *:[v4f64] }:$src0)  =>  VReg_256:{ *:[v8i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3806,
      GIR_Done,
    // Label 535: @25742
    GIM_Try, /*On fail goto*//*Label 536*/ 25774, // Rule ID 3807 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v8f32] } VReg_256:{ *:[v4f64] }:$src0)  =>  VReg_256:{ *:[v8f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3807,
      GIR_Done,
    // Label 536: @25774
    GIM_Try, /*On fail goto*//*Label 537*/ 25806, // Rule ID 3816 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v8i32] } VReg_256:{ *:[v16f16] }:$src0)  =>  VReg_256:{ *:[v8i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3816,
      GIR_Done,
    // Label 537: @25806
    GIM_Try, /*On fail goto*//*Label 538*/ 25838, // Rule ID 3817 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v8i32] } VReg_256:{ *:[v16i16] }:$src0)  =>  VReg_256:{ *:[v8i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3817,
      GIR_Done,
    // Label 538: @25838
    GIM_Try, /*On fail goto*//*Label 539*/ 25870, // Rule ID 3818 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v8f32] } VReg_256:{ *:[v16f16] }:$src0)  =>  VReg_256:{ *:[v8f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3818,
      GIR_Done,
    // Label 539: @25870
    GIM_Try, /*On fail goto*//*Label 540*/ 25902, // Rule ID 3819 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v8f32] } VReg_256:{ *:[v16i16] }:$src0)  =>  VReg_256:{ *:[v8f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3819,
      GIR_Done,
    // Label 540: @25902
    GIM_Reject,
    // Label 404: @25903
    GIM_Try, /*On fail goto*//*Label 541*/ 25935, // Rule ID 3830 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v8i64] } VReg_512:{ *:[v8f64] }:$src0)  =>  VReg_512:{ *:[v8i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3830,
      GIR_Done,
    // Label 541: @25935
    GIM_Try, /*On fail goto*//*Label 542*/ 25967, // Rule ID 3831 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v8f64] } VReg_512:{ *:[v8i64] }:$src0)  =>  VReg_512:{ *:[v8f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3831,
      GIR_Done,
    // Label 542: @25967
    GIM_Try, /*On fail goto*//*Label 543*/ 25999, // Rule ID 3832 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v8i64] } VReg_512:{ *:[v16i32] }:$src0)  =>  VReg_512:{ *:[v8i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3832,
      GIR_Done,
    // Label 543: @25999
    GIM_Try, /*On fail goto*//*Label 544*/ 26031, // Rule ID 3833 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v8f64] } VReg_512:{ *:[v16i32] }:$src0)  =>  VReg_512:{ *:[v8f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3833,
      GIR_Done,
    // Label 544: @26031
    GIM_Try, /*On fail goto*//*Label 545*/ 26063, // Rule ID 3836 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v8i64] } VReg_512:{ *:[v16f32] }:$src0)  =>  VReg_512:{ *:[v8i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3836,
      GIR_Done,
    // Label 545: @26063
    GIM_Try, /*On fail goto*//*Label 546*/ 26095, // Rule ID 3837 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v8f64] } VReg_512:{ *:[v16f32] }:$src0)  =>  VReg_512:{ *:[v8f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3837,
      GIR_Done,
    // Label 546: @26095
    GIM_Reject,
    // Label 405: @26096
    GIM_Try, /*On fail goto*//*Label 547*/ 26128, // Rule ID 3808 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_256RegClassID,
      // (bitconvert:{ *:[v16i16] } SReg_256:{ *:[v16f16] }:$src0)  =>  SReg_256:{ *:[v16i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_256RegClassID,
      // GIR_Coverage, 3808,
      GIR_Done,
    // Label 547: @26128
    GIM_Try, /*On fail goto*//*Label 548*/ 26160, // Rule ID 3809 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_256RegClassID,
      // (bitconvert:{ *:[v16f16] } SReg_256:{ *:[v16i16] }:$src0)  =>  SReg_256:{ *:[v16f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_256RegClassID,
      // GIR_Coverage, 3809,
      GIR_Done,
    // Label 548: @26160
    GIM_Try, /*On fail goto*//*Label 549*/ 26192, // Rule ID 3810 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v16i16] } VReg_256:{ *:[v16f16] }:$src0)  =>  VReg_256:{ *:[v16i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3810,
      GIR_Done,
    // Label 549: @26192
    GIM_Try, /*On fail goto*//*Label 550*/ 26224, // Rule ID 3811 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v16f16] } VReg_256:{ *:[v16i16] }:$src0)  =>  VReg_256:{ *:[v16f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3811,
      GIR_Done,
    // Label 550: @26224
    GIM_Try, /*On fail goto*//*Label 551*/ 26256, // Rule ID 3812 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v16f16] } VReg_256:{ *:[v8i32] }:$src0)  =>  VReg_256:{ *:[v16f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3812,
      GIR_Done,
    // Label 551: @26256
    GIM_Try, /*On fail goto*//*Label 552*/ 26288, // Rule ID 3813 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v16i16] } VReg_256:{ *:[v8i32] }:$src0)  =>  VReg_256:{ *:[v16i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3813,
      GIR_Done,
    // Label 552: @26288
    GIM_Try, /*On fail goto*//*Label 553*/ 26320, // Rule ID 3814 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v16f16] } VReg_256:{ *:[v8f32] }:$src0)  =>  VReg_256:{ *:[v16f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3814,
      GIR_Done,
    // Label 553: @26320
    GIM_Try, /*On fail goto*//*Label 554*/ 26352, // Rule ID 3815 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v16i16] } VReg_256:{ *:[v8f32] }:$src0)  =>  VReg_256:{ *:[v16i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3815,
      GIR_Done,
    // Label 554: @26352
    GIM_Try, /*On fail goto*//*Label 555*/ 26384, // Rule ID 3820 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v16f16] } VReg_256:{ *:[v4i64] }:$src0)  =>  VReg_256:{ *:[v16f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3820,
      GIR_Done,
    // Label 555: @26384
    GIM_Try, /*On fail goto*//*Label 556*/ 26416, // Rule ID 3821 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v16i16] } VReg_256:{ *:[v4i64] }:$src0)  =>  VReg_256:{ *:[v16i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3821,
      GIR_Done,
    // Label 556: @26416
    GIM_Try, /*On fail goto*//*Label 557*/ 26448, // Rule ID 3822 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v16f16] } VReg_256:{ *:[v4f64] }:$src0)  =>  VReg_256:{ *:[v16f16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3822,
      GIR_Done,
    // Label 557: @26448
    GIM_Try, /*On fail goto*//*Label 558*/ 26480, // Rule ID 3823 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_256RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_256RegClassID,
      // (bitconvert:{ *:[v16i16] } VReg_256:{ *:[v4f64] }:$src0)  =>  VReg_256:{ *:[v16i16] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_256RegClassID,
      // GIR_Coverage, 3823,
      GIR_Done,
    // Label 558: @26480
    GIM_Reject,
    // Label 406: @26481
    GIM_Try, /*On fail goto*//*Label 559*/ 26513, // Rule ID 3828 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v16i32] } VReg_512:{ *:[v16f32] }:$src0)  =>  VReg_512:{ *:[v16i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3828,
      GIR_Done,
    // Label 559: @26513
    GIM_Try, /*On fail goto*//*Label 560*/ 26545, // Rule ID 3829 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v16f32] } VReg_512:{ *:[v16i32] }:$src0)  =>  VReg_512:{ *:[v16f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3829,
      GIR_Done,
    // Label 560: @26545
    GIM_Try, /*On fail goto*//*Label 561*/ 26577, // Rule ID 3834 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v16i32] } VReg_512:{ *:[v8i64] }:$src0)  =>  VReg_512:{ *:[v16i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3834,
      GIR_Done,
    // Label 561: @26577
    GIM_Try, /*On fail goto*//*Label 562*/ 26609, // Rule ID 3835 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v16i32] } VReg_512:{ *:[v8f64] }:$src0)  =>  VReg_512:{ *:[v16i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3835,
      GIR_Done,
    // Label 562: @26609
    GIM_Try, /*On fail goto*//*Label 563*/ 26641, // Rule ID 3838 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v16f32] } VReg_512:{ *:[v8i64] }:$src0)  =>  VReg_512:{ *:[v16f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3838,
      GIR_Done,
    // Label 563: @26641
    GIM_Try, /*On fail goto*//*Label 564*/ 26673, // Rule ID 3839 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_512RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_512RegClassID,
      // (bitconvert:{ *:[v16f32] } VReg_512:{ *:[v8f64] }:$src0)  =>  VReg_512:{ *:[v16f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_512RegClassID,
      // GIR_Coverage, 3839,
      GIR_Done,
    // Label 564: @26673
    GIM_Reject,
    // Label 407: @26674
    GIM_Try, /*On fail goto*//*Label 565*/ 26706, // Rule ID 3842 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v16i64] } VReg_1024:{ *:[v16f64] }:$src0)  =>  VReg_1024:{ *:[v16i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3842,
      GIR_Done,
    // Label 565: @26706
    GIM_Try, /*On fail goto*//*Label 566*/ 26738, // Rule ID 3843 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v16f64] } VReg_1024:{ *:[v16i64] }:$src0)  =>  VReg_1024:{ *:[v16f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3843,
      GIR_Done,
    // Label 566: @26738
    GIM_Try, /*On fail goto*//*Label 567*/ 26770, // Rule ID 3844 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v32s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v16i64] } VReg_1024:{ *:[v32i32] }:$src0)  =>  VReg_1024:{ *:[v16i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3844,
      GIR_Done,
    // Label 567: @26770
    GIM_Try, /*On fail goto*//*Label 568*/ 26802, // Rule ID 3846 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v32s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v16f64] } VReg_1024:{ *:[v32f32] }:$src0)  =>  VReg_1024:{ *:[v16f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3846,
      GIR_Done,
    // Label 568: @26802
    GIM_Try, /*On fail goto*//*Label 569*/ 26834, // Rule ID 3848 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v32s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v16i64] } VReg_1024:{ *:[v32f32] }:$src0)  =>  VReg_1024:{ *:[v16i64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3848,
      GIR_Done,
    // Label 569: @26834
    GIM_Try, /*On fail goto*//*Label 570*/ 26866, // Rule ID 3850 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v32s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v16f64] } VReg_1024:{ *:[v32i32] }:$src0)  =>  VReg_1024:{ *:[v16f64] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3850,
      GIR_Done,
    // Label 570: @26866
    GIM_Reject,
    // Label 408: @26867
    GIM_Try, /*On fail goto*//*Label 571*/ 26899, // Rule ID 3840 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v32s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v32i32] } VReg_1024:{ *:[v32f32] }:$src0)  =>  VReg_1024:{ *:[v32i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3840,
      GIR_Done,
    // Label 571: @26899
    GIM_Try, /*On fail goto*//*Label 572*/ 26931, // Rule ID 3841 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v32s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v32f32] } VReg_1024:{ *:[v32i32] }:$src0)  =>  VReg_1024:{ *:[v32f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3841,
      GIR_Done,
    // Label 572: @26931
    GIM_Try, /*On fail goto*//*Label 573*/ 26963, // Rule ID 3845 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v32i32] } VReg_1024:{ *:[v16i64] }:$src0)  =>  VReg_1024:{ *:[v32i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3845,
      GIR_Done,
    // Label 573: @26963
    GIM_Try, /*On fail goto*//*Label 574*/ 26995, // Rule ID 3847 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v32f32] } VReg_1024:{ *:[v16f64] }:$src0)  =>  VReg_1024:{ *:[v32f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3847,
      GIR_Done,
    // Label 574: @26995
    GIM_Try, /*On fail goto*//*Label 575*/ 27027, // Rule ID 3849 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v32i32] } VReg_1024:{ *:[v16f64] }:$src0)  =>  VReg_1024:{ *:[v32i32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3849,
      GIR_Done,
    // Label 575: @27027
    GIM_Try, /*On fail goto*//*Label 576*/ 27059, // Rule ID 3851 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_1024RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::VReg_1024RegClassID,
      // (bitconvert:{ *:[v32f32] } VReg_1024:{ *:[v16i64] }:$src0)  =>  VReg_1024:{ *:[v32f32] }:$src0
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // src0
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::VReg_1024RegClassID,
      // GIR_Coverage, 3851,
      GIR_Done,
    // Label 576: @27059
    GIM_Reject,
    // Label 409: @27060
    GIM_Reject,
    // Label 9: @27061
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/8, 11, /*)*//*default:*//*Label 580*/ 27206,
    /*GILLT_s16*//*Label 577*/ 27070,
    /*GILLT_s32*//*Label 578*/ 27116,
    /*GILLT_s64*//*Label 579*/ 27160,
    // Label 577: @27070
    GIM_Try, /*On fail goto*//*Label 581*/ 27115, // Rule ID 480 //
      GIM_CheckFeatures, GIFBS_Has16BitInsts,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_vop3mods0,
      // (ftrunc:{ *:[f16] } (VOP3Mods0:{ *:[f16] } f16:{ *:[f16] }:$src0, i32:{ *:[i32] }:$src0_modifiers, i1:{ *:[i1] }:$clamp, i32:{ *:[i32] }:$omod))  =>  (V_TRUNC_F16_e64:{ *:[f16] } i32:{ *:[i32] }:$src0_modifiers, f16:{ *:[f16] }:$src0, i1:{ *:[i1] }:$clamp, i32:{ *:[i32] }:$omod)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_TRUNC_F16_e64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // src0_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // src0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // clamp
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // omod
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 480,
      GIR_Done,
    // Label 581: @27115
    GIM_Reject,
    // Label 578: @27116
    GIM_Try, /*On fail goto*//*Label 582*/ 27159, // Rule ID 412 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VGPR_32RegClassID,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_vop3mods0,
      // (ftrunc:{ *:[f32] } (VOP3Mods0:{ *:[f32] } f32:{ *:[f32] }:$src0, i32:{ *:[i32] }:$src0_modifiers, i1:{ *:[i1] }:$clamp, i32:{ *:[i32] }:$omod))  =>  (V_TRUNC_F32_e64:{ *:[f32] } i32:{ *:[i32] }:$src0_modifiers, f32:{ *:[f32] }:$src0, i1:{ *:[i1] }:$clamp, i32:{ *:[i32] }:$omod)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_TRUNC_F32_e64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // src0_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // src0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // clamp
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // omod
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 412,
      GIR_Done,
    // Label 582: @27159
    GIM_Reject,
    // Label 579: @27160
    GIM_Try, /*On fail goto*//*Label 583*/ 27205, // Rule ID 456 //
      GIM_CheckFeatures, GIFBS_isGFX7Plus,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::VReg_64RegClassID,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_vop3mods0,
      // (ftrunc:{ *:[f64] } (VOP3Mods0:{ *:[f64] } f64:{ *:[f64] }:$src0, i32:{ *:[i32] }:$src0_modifiers, i1:{ *:[i1] }:$clamp, i32:{ *:[i32] }:$omod))  =>  (V_TRUNC_F64_e64:{ *:[f64] } i32:{ *:[i32] }:$src0_modifiers, f64:{ *:[f64] }:$src0, i1:{ *:[i1] }:$clamp, i32:{ *:[i32] }:$omod)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::V_TRUNC_F64_e64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // src0_modifiers
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // src0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // clamp
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // omod
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 456,
      GIR_Done,
    // Label 583: @27205
    GIM_Reject,
    // Label 580: @27206
    GIM_Reject,
    // Label 10: @27207
    GIM_Try, /*On fail goto*//*Label 584*/ 27303,
      GIM_CheckType, /*MI*/0, /*Op*/0, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 585*/ 27287, // Rule ID 1785 //
        GIM_CheckFeatures, GIFBS_HasShaderCyclesRegister,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64RegClassID,
        // (readcyclecounter:{ *:[i64] })  =>  (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, (S_GETREG_B32:{ *:[i1] } 38941:{ *:[i32] }), sub0:{ *:[i32] }, (S_MOV_B32:{ *:[i1] } 0:{ *:[i32] }), sub1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/AMDGPU::S_MOV_B32,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/2, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AMDGPU::S_GETREG_B32,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddImm, /*InsnID*/1, /*Imm*/38941,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::REG_SEQUENCE,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/3,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*SubRegIndex*/11,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AMDGPU::SReg_64RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AMDGPU::SRegOrLds_32_and_SReg_1RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, AMDGPU::SReg_32_XM0RegClassID,
        // GIR_Coverage, 1785,
        GIR_Done,
      // Label 585: @27287
      GIM_Try, /*On fail goto*//*Label 586*/ 27302, // Rule ID 1784 //
        GIM_CheckFeatures, GIFBS_HasSMemTimeInst,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
        // (readcyclecounter:{ *:[i64] })  =>  (S_MEMTIME:{ *:[i64] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AMDGPU::S_MEMTIME,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1784,
        GIR_Done,
      // Label 586: @27302
      GIM_Reject,
    // Label 584: @27303
    GIM_Reject,
    // Label 11: @27304
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/0, 27, /*)*//*default:*//*Label 610*/ 57981,
    /*GILLT_p0s64*//*Label 587*/ 27337,
    /*GILLT_p1s64*//*Label 588*/ 28287,
    /*GILLT_p2s32*//*Label 589*/ 29237,
    /*GILLT_p3s32*//*Label 590*/ 30067,
    /*GILLT_p4s64*//*Label 591*/ 30897,
    /*GILLT_p5s32*//*Label 592*/ 31847,
    /*GILLT_p6s32*//*Label 593*/ 32677,
    /*GILLT_s1*//*Label 594*/ 33507,
    /*GILLT_s16*//*Label 595*/ 33721,
    /*GILLT_s32*//*Label 596*/ 35985,
    /*GILLT_s64*//*Label 597*/ 40705,
    /*GILLT_v2s16*//*Label 598*/ 43233,
    /*GILLT_v2s32*//*Label 599*/ 44892,
    /*GILLT_v2s64*//*Label 600*/ 47047,
    /*GILLT_v3s32*//*Label 601*/ 48946, 0,
    /*GILLT_v4s16*//*Label 602*/ 49978,
    /*GILLT_v4s32*//*Label 603*/ 51877,
    /*GILLT_v4s64*//*Label 604*/ 54032, 0, 0, 0,
    /*GILLT_v8s16*//*Label 605*/ 54442,
    /*GILLT_v8s32*//*Label 606*/ 56341,
    /*GILLT_v8s64*//*Label 607*/ 56751,
    /*GILLT_v16s16*//*Label 608*/ 57161,
    /*GILLT_v16s32*//*Label 609*/ 57571,
    // Label 587: @27337
    GIM_Try, /*On fail goto*//*Label 611*/ 27401, // Rule ID 4396 //
      GIM_CheckFeatures, GIFBS_HasUnalignedAccessMode_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_load_align_less_than_4_local_m0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>><<P:Predicate_load_align_less_than_4_local_m0>>  =>  (DS_READ_B64:{ *:[i64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4396,
      GIR_Done,
    // Label 611: @27401
    GIM_Try, /*On fail goto*//*Label 612*/ 27461, // Rule ID 4328 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemoryAlignment, /*MI*/0, /*MMO*/0, /*MinAlign*/8,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>><<P:Predicate_load_align8_local_m0>>  =>  (DS_READ_B64:{ *:[i64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4328,
      GIR_Done,
    // Label 612: @27461
    GIM_Try, /*On fail goto*//*Label 613*/ 27521, // Rule ID 4397 //
      GIM_CheckFeatures, GIFBS_HasUnalignedAccessMode_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_load_align_less_than_4_local,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>><<P:Predicate_load_align_less_than_4_local>>  =>  (DS_READ_B64_gfx9:{ *:[i64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4397,
      GIR_Done,
    // Label 613: @27521
    GIM_Try, /*On fail goto*//*Label 614*/ 27577, // Rule ID 4329 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemoryAlignment, /*MI*/0, /*MMO*/0, /*MinAlign*/8,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>><<P:Predicate_load_align8_local>>  =>  (DS_READ_B64_gfx9:{ *:[i64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4329,
      GIR_Done,
    // Label 614: @27577
    GIM_Try, /*On fail goto*//*Label 615*/ 27633, // Rule ID 2481 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_svaddr,
      // (ld:{ *:[i64] } (ScratchSVAddr:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORDX2_SVS:{ *:[i64] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORDX2_SVS,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2481,
      GIR_Done,
    // Label 615: @27633
    GIM_Try, /*On fail goto*//*Label 616*/ 27685, // Rule ID 2480 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i64] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORDX2_SADDR:{ *:[i64] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORDX2_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2480,
      GIR_Done,
    // Label 616: @27685
    GIM_Try, /*On fail goto*//*Label 617*/ 27737, // Rule ID 2479 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i64] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORDX2:{ *:[i64] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2479,
      GIR_Done,
    // Label 617: @27737
    GIM_Try, /*On fail goto*//*Label 618*/ 27797, // Rule ID 4272 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init_isGFX7Plus,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_64bit_4byte_aligned,
      // (AMDGPUld_glue:{ *:[i64] } (DS64Bit4ByteAligned:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i8:{ *:[i8] }:$offset0, i8:{ *:[i8] }:$offset1))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>>  =>  (DS_READ2_B32:{ *:[i64] } ?:{ *:[i32] }:$ptr, ?:{ *:[i8] }:$offset0, ?:{ *:[i8] }:$offset1, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ2_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4272,
      GIR_Done,
    // Label 618: @27797
    GIM_Try, /*On fail goto*//*Label 619*/ 27855, // Rule ID 4647 //
      GIM_CheckFeatures, GIFBS_isGFX9Plus,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr_imm,
      // (ld:{ *:[i64] } (SMRDSgprImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$soffset, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_SGPR_IMM:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$soffset, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_SGPR_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4647,
      GIR_Done,
    // Label 619: @27855
    GIM_Try, /*On fail goto*//*Label 620*/ 27911, // Rule ID 4274 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_64bit_4byte_aligned,
      // (ld:{ *:[i64] } (DS64Bit4ByteAligned:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i8:{ *:[i8] }:$offset0, i8:{ *:[i8] }:$offset1))<<P:Predicate_unindexedload>><<P:Predicate_load_local>>  =>  (DS_READ2_B32_gfx9:{ *:[i64] } ?:{ *:[i32] }:$ptr, ?:{ *:[i8] }:$offset0, ?:{ *:[i8] }:$offset1, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ2_B32_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4274,
      GIR_Done,
    // Label 620: @27911
    GIM_Try, /*On fail goto*//*Label 621*/ 27963, // Rule ID 4644 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
      // (ld:{ *:[i64] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4644,
      GIR_Done,
    // Label 621: @27963
    GIM_Try, /*On fail goto*//*Label 622*/ 28017, // Rule ID 4645 //
      GIM_CheckFeatures, GIFBS_isGFX7Only,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
      // (ld:{ *:[i64] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM_ci:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM_ci,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4645,
      GIR_Done,
    // Label 622: @28017
    GIM_Try, /*On fail goto*//*Label 623*/ 28069, // Rule ID 4646 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
      // (ld:{ *:[i64] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$soffset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_SGPR:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$soffset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_SGPR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4646,
      GIR_Done,
    // Label 623: @28069
    GIM_Try, /*On fail goto*//*Label 624*/ 28127, // Rule ID 2084 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[i64] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORDX2_SADDR:{ *:[i64] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORDX2_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2084,
      GIR_Done,
    // Label 624: @28127
    GIM_Try, /*On fail goto*//*Label 625*/ 28181, // Rule ID 2083 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[i64] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORDX2:{ *:[i64] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2083,
      GIR_Done,
    // Label 625: @28181
    GIM_Try, /*On fail goto*//*Label 626*/ 28231, // Rule ID 4648 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      // (ld:{ *:[i64] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[i64] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4648,
      GIR_Done,
    // Label 626: @28231
    GIM_Try, /*On fail goto*//*Label 627*/ 28286, // Rule ID 1838 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (ld:{ *:[i64] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_flat>>  =>  (FLAT_LOAD_DWORDX2:{ *:[i64] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1838,
      GIR_Done,
    // Label 627: @28286
    GIM_Reject,
    // Label 588: @28287
    GIM_Try, /*On fail goto*//*Label 628*/ 28351, // Rule ID 4400 //
      GIM_CheckFeatures, GIFBS_HasUnalignedAccessMode_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_load_align_less_than_4_local_m0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>><<P:Predicate_load_align_less_than_4_local_m0>>  =>  (DS_READ_B64:{ *:[i64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4400,
      GIR_Done,
    // Label 628: @28351
    GIM_Try, /*On fail goto*//*Label 629*/ 28411, // Rule ID 4332 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemoryAlignment, /*MI*/0, /*MMO*/0, /*MinAlign*/8,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>><<P:Predicate_load_align8_local_m0>>  =>  (DS_READ_B64:{ *:[i64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4332,
      GIR_Done,
    // Label 629: @28411
    GIM_Try, /*On fail goto*//*Label 630*/ 28471, // Rule ID 4401 //
      GIM_CheckFeatures, GIFBS_HasUnalignedAccessMode_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_load_align_less_than_4_local,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>><<P:Predicate_load_align_less_than_4_local>>  =>  (DS_READ_B64_gfx9:{ *:[i64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4401,
      GIR_Done,
    // Label 630: @28471
    GIM_Try, /*On fail goto*//*Label 631*/ 28527, // Rule ID 4333 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemoryAlignment, /*MI*/0, /*MMO*/0, /*MinAlign*/8,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>><<P:Predicate_load_align8_local>>  =>  (DS_READ_B64_gfx9:{ *:[i64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4333,
      GIR_Done,
    // Label 631: @28527
    GIM_Try, /*On fail goto*//*Label 632*/ 28583, // Rule ID 2487 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_svaddr,
      // (ld:{ *:[i64] } (ScratchSVAddr:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORDX2_SVS:{ *:[i64] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORDX2_SVS,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2487,
      GIR_Done,
    // Label 632: @28583
    GIM_Try, /*On fail goto*//*Label 633*/ 28635, // Rule ID 2486 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i64] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORDX2_SADDR:{ *:[i64] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORDX2_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2486,
      GIR_Done,
    // Label 633: @28635
    GIM_Try, /*On fail goto*//*Label 634*/ 28687, // Rule ID 2485 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i64] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORDX2:{ *:[i64] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2485,
      GIR_Done,
    // Label 634: @28687
    GIM_Try, /*On fail goto*//*Label 635*/ 28747, // Rule ID 4276 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init_isGFX7Plus,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_64bit_4byte_aligned,
      // (AMDGPUld_glue:{ *:[i64] } (DS64Bit4ByteAligned:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i8:{ *:[i8] }:$offset0, i8:{ *:[i8] }:$offset1))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>>  =>  (DS_READ2_B32:{ *:[i64] } ?:{ *:[i32] }:$ptr, ?:{ *:[i8] }:$offset0, ?:{ *:[i8] }:$offset1, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ2_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4276,
      GIR_Done,
    // Label 635: @28747
    GIM_Try, /*On fail goto*//*Label 636*/ 28805, // Rule ID 4652 //
      GIM_CheckFeatures, GIFBS_isGFX9Plus,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr_imm,
      // (ld:{ *:[i64] } (SMRDSgprImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$soffset, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_SGPR_IMM:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$soffset, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_SGPR_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4652,
      GIR_Done,
    // Label 636: @28805
    GIM_Try, /*On fail goto*//*Label 637*/ 28861, // Rule ID 4278 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_64bit_4byte_aligned,
      // (ld:{ *:[i64] } (DS64Bit4ByteAligned:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i8:{ *:[i8] }:$offset0, i8:{ *:[i8] }:$offset1))<<P:Predicate_unindexedload>><<P:Predicate_load_local>>  =>  (DS_READ2_B32_gfx9:{ *:[i64] } ?:{ *:[i32] }:$ptr, ?:{ *:[i8] }:$offset0, ?:{ *:[i8] }:$offset1, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ2_B32_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4278,
      GIR_Done,
    // Label 637: @28861
    GIM_Try, /*On fail goto*//*Label 638*/ 28913, // Rule ID 4649 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
      // (ld:{ *:[i64] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4649,
      GIR_Done,
    // Label 638: @28913
    GIM_Try, /*On fail goto*//*Label 639*/ 28967, // Rule ID 4650 //
      GIM_CheckFeatures, GIFBS_isGFX7Only,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
      // (ld:{ *:[i64] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM_ci:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM_ci,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4650,
      GIR_Done,
    // Label 639: @28967
    GIM_Try, /*On fail goto*//*Label 640*/ 29019, // Rule ID 4651 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
      // (ld:{ *:[i64] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$soffset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_SGPR:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$soffset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_SGPR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4651,
      GIR_Done,
    // Label 640: @29019
    GIM_Try, /*On fail goto*//*Label 641*/ 29077, // Rule ID 2088 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[i64] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORDX2_SADDR:{ *:[i64] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORDX2_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2088,
      GIR_Done,
    // Label 641: @29077
    GIM_Try, /*On fail goto*//*Label 642*/ 29131, // Rule ID 2087 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[i64] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORDX2:{ *:[i64] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2087,
      GIR_Done,
    // Label 642: @29131
    GIM_Try, /*On fail goto*//*Label 643*/ 29181, // Rule ID 4653 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      // (ld:{ *:[i64] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[i64] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4653,
      GIR_Done,
    // Label 643: @29181
    GIM_Try, /*On fail goto*//*Label 644*/ 29236, // Rule ID 1840 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (ld:{ *:[i64] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_flat>>  =>  (FLAT_LOAD_DWORDX2:{ *:[i64] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1840,
      GIR_Done,
    // Label 644: @29236
    GIM_Reject,
    // Label 589: @29237
    GIM_Try, /*On fail goto*//*Label 645*/ 29295, // Rule ID 1625 //
      GIM_CheckFeatures, GIFBS_isGFX9Plus,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr_imm,
      // (ld:{ *:[i32] } (SMRDSgprImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$soffset, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_SGPR_IMM:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$soffset, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_SGPR_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1625,
      GIR_Done,
    // Label 645: @29295
    GIM_Try, /*On fail goto*//*Label 646*/ 29347, // Rule ID 1622 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
      // (ld:{ *:[i32] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1622,
      GIR_Done,
    // Label 646: @29347
    GIM_Try, /*On fail goto*//*Label 647*/ 29401, // Rule ID 1623 //
      GIM_CheckFeatures, GIFBS_isGFX7Only,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
      // (ld:{ *:[i32] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM_ci:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM_ci,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1623,
      GIR_Done,
    // Label 647: @29401
    GIM_Try, /*On fail goto*//*Label 648*/ 29453, // Rule ID 1624 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
      // (ld:{ *:[i32] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$soffset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_SGPR:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$soffset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_SGPR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1624,
      GIR_Done,
    // Label 648: @29453
    GIM_Try, /*On fail goto*//*Label 649*/ 29503, // Rule ID 1626 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      // (ld:{ *:[i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1626,
      GIR_Done,
    // Label 649: @29503
    GIM_Try, /*On fail goto*//*Label 650*/ 29565, // Rule ID 3378 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offset,
      // (ld:{ *:[i32] } (MUBUFScratchOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_DWORD_OFFSET:{ *:[i32] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3378,
      GIR_Done,
    // Label 650: @29565
    GIM_Try, /*On fail goto*//*Label 651*/ 29621, // Rule ID 2421 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_svaddr,
      // (ld:{ *:[i32] } (ScratchSVAddr:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD_SVS:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD_SVS,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2421,
      GIR_Done,
    // Label 651: @29621
    GIM_Try, /*On fail goto*//*Label 652*/ 29673, // Rule ID 2420 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i32] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD_SADDR:{ *:[i32] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2420,
      GIR_Done,
    // Label 652: @29673
    GIM_Try, /*On fail goto*//*Label 653*/ 29725, // Rule ID 2419 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i32] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2419,
      GIR_Done,
    // Label 653: @29725
    GIM_Try, /*On fail goto*//*Label 654*/ 29791, // Rule ID 3377 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offen,
      // (ld:{ *:[i32] } (MUBUFScratchOffen:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$vaddr, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_DWORD_OFFEN:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFEN,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3377,
      GIR_Done,
    // Label 654: @29791
    GIM_Try, /*On fail goto*//*Label 655*/ 29847, // Rule ID 4174 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>>  =>  (DS_READ_B32:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4174,
      GIR_Done,
    // Label 655: @29847
    GIM_Try, /*On fail goto*//*Label 656*/ 29899, // Rule ID 4175 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>>  =>  (DS_READ_B32_gfx9:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B32_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4175,
      GIR_Done,
    // Label 656: @29899
    GIM_Try, /*On fail goto*//*Label 657*/ 29957, // Rule ID 2044 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[i32] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORD_SADDR:{ *:[i32] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2044,
      GIR_Done,
    // Label 657: @29957
    GIM_Try, /*On fail goto*//*Label 658*/ 30011, // Rule ID 2043 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[i32] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORD:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2043,
      GIR_Done,
    // Label 658: @30011
    GIM_Try, /*On fail goto*//*Label 659*/ 30066, // Rule ID 1817 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (ld:{ *:[i32] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_flat>>  =>  (FLAT_LOAD_DWORD:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1817,
      GIR_Done,
    // Label 659: @30066
    GIM_Reject,
    // Label 590: @30067
    GIM_Try, /*On fail goto*//*Label 660*/ 30125, // Rule ID 1630 //
      GIM_CheckFeatures, GIFBS_isGFX9Plus,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr_imm,
      // (ld:{ *:[i32] } (SMRDSgprImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$soffset, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_SGPR_IMM:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$soffset, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_SGPR_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1630,
      GIR_Done,
    // Label 660: @30125
    GIM_Try, /*On fail goto*//*Label 661*/ 30177, // Rule ID 1627 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
      // (ld:{ *:[i32] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1627,
      GIR_Done,
    // Label 661: @30177
    GIM_Try, /*On fail goto*//*Label 662*/ 30231, // Rule ID 1628 //
      GIM_CheckFeatures, GIFBS_isGFX7Only,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
      // (ld:{ *:[i32] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM_ci:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM_ci,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1628,
      GIR_Done,
    // Label 662: @30231
    GIM_Try, /*On fail goto*//*Label 663*/ 30283, // Rule ID 1629 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
      // (ld:{ *:[i32] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$soffset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_SGPR:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$soffset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_SGPR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1629,
      GIR_Done,
    // Label 663: @30283
    GIM_Try, /*On fail goto*//*Label 664*/ 30333, // Rule ID 1631 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      // (ld:{ *:[i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1631,
      GIR_Done,
    // Label 664: @30333
    GIM_Try, /*On fail goto*//*Label 665*/ 30395, // Rule ID 3380 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offset,
      // (ld:{ *:[i32] } (MUBUFScratchOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_DWORD_OFFSET:{ *:[i32] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3380,
      GIR_Done,
    // Label 665: @30395
    GIM_Try, /*On fail goto*//*Label 666*/ 30451, // Rule ID 2427 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_svaddr,
      // (ld:{ *:[i32] } (ScratchSVAddr:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD_SVS:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD_SVS,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2427,
      GIR_Done,
    // Label 666: @30451
    GIM_Try, /*On fail goto*//*Label 667*/ 30503, // Rule ID 2426 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i32] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD_SADDR:{ *:[i32] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2426,
      GIR_Done,
    // Label 667: @30503
    GIM_Try, /*On fail goto*//*Label 668*/ 30555, // Rule ID 2425 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i32] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2425,
      GIR_Done,
    // Label 668: @30555
    GIM_Try, /*On fail goto*//*Label 669*/ 30621, // Rule ID 3379 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offen,
      // (ld:{ *:[i32] } (MUBUFScratchOffen:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$vaddr, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_DWORD_OFFEN:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFEN,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3379,
      GIR_Done,
    // Label 669: @30621
    GIM_Try, /*On fail goto*//*Label 670*/ 30677, // Rule ID 4176 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>>  =>  (DS_READ_B32:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4176,
      GIR_Done,
    // Label 670: @30677
    GIM_Try, /*On fail goto*//*Label 671*/ 30729, // Rule ID 4177 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>>  =>  (DS_READ_B32_gfx9:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B32_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4177,
      GIR_Done,
    // Label 671: @30729
    GIM_Try, /*On fail goto*//*Label 672*/ 30787, // Rule ID 2048 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[i32] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORD_SADDR:{ *:[i32] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2048,
      GIR_Done,
    // Label 672: @30787
    GIM_Try, /*On fail goto*//*Label 673*/ 30841, // Rule ID 2047 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[i32] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORD:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2047,
      GIR_Done,
    // Label 673: @30841
    GIM_Try, /*On fail goto*//*Label 674*/ 30896, // Rule ID 1819 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (ld:{ *:[i32] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_flat>>  =>  (FLAT_LOAD_DWORD:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1819,
      GIR_Done,
    // Label 674: @30896
    GIM_Reject,
    // Label 591: @30897
    GIM_Try, /*On fail goto*//*Label 675*/ 30961, // Rule ID 4404 //
      GIM_CheckFeatures, GIFBS_HasUnalignedAccessMode_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_load_align_less_than_4_local_m0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>><<P:Predicate_load_align_less_than_4_local_m0>>  =>  (DS_READ_B64:{ *:[i64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4404,
      GIR_Done,
    // Label 675: @30961
    GIM_Try, /*On fail goto*//*Label 676*/ 31021, // Rule ID 4336 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemoryAlignment, /*MI*/0, /*MMO*/0, /*MinAlign*/8,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>><<P:Predicate_load_align8_local_m0>>  =>  (DS_READ_B64:{ *:[i64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4336,
      GIR_Done,
    // Label 676: @31021
    GIM_Try, /*On fail goto*//*Label 677*/ 31081, // Rule ID 4405 //
      GIM_CheckFeatures, GIFBS_HasUnalignedAccessMode_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_load_align_less_than_4_local,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>><<P:Predicate_load_align_less_than_4_local>>  =>  (DS_READ_B64_gfx9:{ *:[i64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4405,
      GIR_Done,
    // Label 677: @31081
    GIM_Try, /*On fail goto*//*Label 678*/ 31137, // Rule ID 4337 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckMemoryAlignment, /*MI*/0, /*MMO*/0, /*MinAlign*/8,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i64] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>><<P:Predicate_load_align8_local>>  =>  (DS_READ_B64_gfx9:{ *:[i64] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B64_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4337,
      GIR_Done,
    // Label 678: @31137
    GIM_Try, /*On fail goto*//*Label 679*/ 31193, // Rule ID 2493 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_svaddr,
      // (ld:{ *:[i64] } (ScratchSVAddr:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORDX2_SVS:{ *:[i64] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORDX2_SVS,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2493,
      GIR_Done,
    // Label 679: @31193
    GIM_Try, /*On fail goto*//*Label 680*/ 31245, // Rule ID 2492 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i64] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORDX2_SADDR:{ *:[i64] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORDX2_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2492,
      GIR_Done,
    // Label 680: @31245
    GIM_Try, /*On fail goto*//*Label 681*/ 31297, // Rule ID 2491 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i64] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORDX2:{ *:[i64] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2491,
      GIR_Done,
    // Label 681: @31297
    GIM_Try, /*On fail goto*//*Label 682*/ 31357, // Rule ID 4280 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init_isGFX7Plus,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_64bit_4byte_aligned,
      // (AMDGPUld_glue:{ *:[i64] } (DS64Bit4ByteAligned:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i8:{ *:[i8] }:$offset0, i8:{ *:[i8] }:$offset1))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>>  =>  (DS_READ2_B32:{ *:[i64] } ?:{ *:[i32] }:$ptr, ?:{ *:[i8] }:$offset0, ?:{ *:[i8] }:$offset1, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ2_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4280,
      GIR_Done,
    // Label 682: @31357
    GIM_Try, /*On fail goto*//*Label 683*/ 31415, // Rule ID 4657 //
      GIM_CheckFeatures, GIFBS_isGFX9Plus,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr_imm,
      // (ld:{ *:[i64] } (SMRDSgprImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$soffset, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_SGPR_IMM:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$soffset, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_SGPR_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4657,
      GIR_Done,
    // Label 683: @31415
    GIM_Try, /*On fail goto*//*Label 684*/ 31471, // Rule ID 4282 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_64bit_4byte_aligned,
      // (ld:{ *:[i64] } (DS64Bit4ByteAligned:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i8:{ *:[i8] }:$offset0, i8:{ *:[i8] }:$offset1))<<P:Predicate_unindexedload>><<P:Predicate_load_local>>  =>  (DS_READ2_B32_gfx9:{ *:[i64] } ?:{ *:[i32] }:$ptr, ?:{ *:[i8] }:$offset0, ?:{ *:[i8] }:$offset1, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ2_B32_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset0
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset1
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4282,
      GIR_Done,
    // Label 684: @31471
    GIM_Try, /*On fail goto*//*Label 685*/ 31523, // Rule ID 4654 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
      // (ld:{ *:[i64] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4654,
      GIR_Done,
    // Label 685: @31523
    GIM_Try, /*On fail goto*//*Label 686*/ 31577, // Rule ID 4655 //
      GIM_CheckFeatures, GIFBS_isGFX7Only,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
      // (ld:{ *:[i64] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM_ci:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM_ci,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4655,
      GIR_Done,
    // Label 686: @31577
    GIM_Try, /*On fail goto*//*Label 687*/ 31629, // Rule ID 4656 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
      // (ld:{ *:[i64] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$soffset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_SGPR:{ *:[i64] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$soffset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_SGPR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4656,
      GIR_Done,
    // Label 687: @31629
    GIM_Try, /*On fail goto*//*Label 688*/ 31687, // Rule ID 2092 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[i64] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORDX2_SADDR:{ *:[i64] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORDX2_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2092,
      GIR_Done,
    // Label 688: @31687
    GIM_Try, /*On fail goto*//*Label 689*/ 31741, // Rule ID 2091 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[i64] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORDX2:{ *:[i64] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2091,
      GIR_Done,
    // Label 689: @31741
    GIM_Try, /*On fail goto*//*Label 690*/ 31791, // Rule ID 4658 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      // (ld:{ *:[i64] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[i64] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4658,
      GIR_Done,
    // Label 690: @31791
    GIM_Try, /*On fail goto*//*Label 691*/ 31846, // Rule ID 1842 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_64RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (ld:{ *:[i64] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_flat>>  =>  (FLAT_LOAD_DWORDX2:{ *:[i64] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_DWORDX2,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1842,
      GIR_Done,
    // Label 691: @31846
    GIM_Reject,
    // Label 592: @31847
    GIM_Try, /*On fail goto*//*Label 692*/ 31905, // Rule ID 1635 //
      GIM_CheckFeatures, GIFBS_isGFX9Plus,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr_imm,
      // (ld:{ *:[i32] } (SMRDSgprImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$soffset, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_SGPR_IMM:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$soffset, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_SGPR_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1635,
      GIR_Done,
    // Label 692: @31905
    GIM_Try, /*On fail goto*//*Label 693*/ 31957, // Rule ID 1632 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
      // (ld:{ *:[i32] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1632,
      GIR_Done,
    // Label 693: @31957
    GIM_Try, /*On fail goto*//*Label 694*/ 32011, // Rule ID 1633 //
      GIM_CheckFeatures, GIFBS_isGFX7Only,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
      // (ld:{ *:[i32] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM_ci:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM_ci,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1633,
      GIR_Done,
    // Label 694: @32011
    GIM_Try, /*On fail goto*//*Label 695*/ 32063, // Rule ID 1634 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
      // (ld:{ *:[i32] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$soffset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_SGPR:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$soffset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_SGPR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1634,
      GIR_Done,
    // Label 695: @32063
    GIM_Try, /*On fail goto*//*Label 696*/ 32113, // Rule ID 1636 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      // (ld:{ *:[i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1636,
      GIR_Done,
    // Label 696: @32113
    GIM_Try, /*On fail goto*//*Label 697*/ 32175, // Rule ID 3382 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offset,
      // (ld:{ *:[i32] } (MUBUFScratchOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_DWORD_OFFSET:{ *:[i32] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3382,
      GIR_Done,
    // Label 697: @32175
    GIM_Try, /*On fail goto*//*Label 698*/ 32231, // Rule ID 2433 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_svaddr,
      // (ld:{ *:[i32] } (ScratchSVAddr:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD_SVS:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD_SVS,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2433,
      GIR_Done,
    // Label 698: @32231
    GIM_Try, /*On fail goto*//*Label 699*/ 32283, // Rule ID 2432 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i32] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD_SADDR:{ *:[i32] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2432,
      GIR_Done,
    // Label 699: @32283
    GIM_Try, /*On fail goto*//*Label 700*/ 32335, // Rule ID 2431 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i32] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2431,
      GIR_Done,
    // Label 700: @32335
    GIM_Try, /*On fail goto*//*Label 701*/ 32401, // Rule ID 3381 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offen,
      // (ld:{ *:[i32] } (MUBUFScratchOffen:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$vaddr, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_DWORD_OFFEN:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFEN,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3381,
      GIR_Done,
    // Label 701: @32401
    GIM_Try, /*On fail goto*//*Label 702*/ 32457, // Rule ID 4178 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>>  =>  (DS_READ_B32:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4178,
      GIR_Done,
    // Label 702: @32457
    GIM_Try, /*On fail goto*//*Label 703*/ 32509, // Rule ID 4179 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>>  =>  (DS_READ_B32_gfx9:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B32_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4179,
      GIR_Done,
    // Label 703: @32509
    GIM_Try, /*On fail goto*//*Label 704*/ 32567, // Rule ID 2052 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[i32] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORD_SADDR:{ *:[i32] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2052,
      GIR_Done,
    // Label 704: @32567
    GIM_Try, /*On fail goto*//*Label 705*/ 32621, // Rule ID 2051 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[i32] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORD:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2051,
      GIR_Done,
    // Label 705: @32621
    GIM_Try, /*On fail goto*//*Label 706*/ 32676, // Rule ID 1821 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (ld:{ *:[i32] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_flat>>  =>  (FLAT_LOAD_DWORD:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1821,
      GIR_Done,
    // Label 706: @32676
    GIM_Reject,
    // Label 593: @32677
    GIM_Try, /*On fail goto*//*Label 707*/ 32735, // Rule ID 1640 //
      GIM_CheckFeatures, GIFBS_isGFX9Plus,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr_imm,
      // (ld:{ *:[i32] } (SMRDSgprImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$soffset, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_SGPR_IMM:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$soffset, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_SGPR_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1640,
      GIR_Done,
    // Label 707: @32735
    GIM_Try, /*On fail goto*//*Label 708*/ 32787, // Rule ID 1637 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
      // (ld:{ *:[i32] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1637,
      GIR_Done,
    // Label 708: @32787
    GIM_Try, /*On fail goto*//*Label 709*/ 32841, // Rule ID 1638 //
      GIM_CheckFeatures, GIFBS_isGFX7Only,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
      // (ld:{ *:[i32] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM_ci:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM_ci,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1638,
      GIR_Done,
    // Label 709: @32841
    GIM_Try, /*On fail goto*//*Label 710*/ 32893, // Rule ID 1639 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
      // (ld:{ *:[i32] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$soffset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_SGPR:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$soffset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_SGPR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1639,
      GIR_Done,
    // Label 710: @32893
    GIM_Try, /*On fail goto*//*Label 711*/ 32943, // Rule ID 1641 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      // (ld:{ *:[i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1641,
      GIR_Done,
    // Label 711: @32943
    GIM_Try, /*On fail goto*//*Label 712*/ 33005, // Rule ID 3384 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offset,
      // (ld:{ *:[i32] } (MUBUFScratchOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_DWORD_OFFSET:{ *:[i32] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3384,
      GIR_Done,
    // Label 712: @33005
    GIM_Try, /*On fail goto*//*Label 713*/ 33061, // Rule ID 2439 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_svaddr,
      // (ld:{ *:[i32] } (ScratchSVAddr:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD_SVS:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD_SVS,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2439,
      GIR_Done,
    // Label 713: @33061
    GIM_Try, /*On fail goto*//*Label 714*/ 33113, // Rule ID 2438 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i32] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD_SADDR:{ *:[i32] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2438,
      GIR_Done,
    // Label 714: @33113
    GIM_Try, /*On fail goto*//*Label 715*/ 33165, // Rule ID 2437 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i32] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2437,
      GIR_Done,
    // Label 715: @33165
    GIM_Try, /*On fail goto*//*Label 716*/ 33231, // Rule ID 3383 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offen,
      // (ld:{ *:[i32] } (MUBUFScratchOffen:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$vaddr, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_DWORD_OFFEN:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFEN,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3383,
      GIR_Done,
    // Label 716: @33231
    GIM_Try, /*On fail goto*//*Label 717*/ 33287, // Rule ID 4180 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>>  =>  (DS_READ_B32:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B32,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4180,
      GIR_Done,
    // Label 717: @33287
    GIM_Try, /*On fail goto*//*Label 718*/ 33339, // Rule ID 4181 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i32] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>>  =>  (DS_READ_B32_gfx9:{ *:[i32] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_B32_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4181,
      GIR_Done,
    // Label 718: @33339
    GIM_Try, /*On fail goto*//*Label 719*/ 33397, // Rule ID 2056 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[i32] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORD_SADDR:{ *:[i32] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2056,
      GIR_Done,
    // Label 719: @33397
    GIM_Try, /*On fail goto*//*Label 720*/ 33451, // Rule ID 2055 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[i32] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_DWORD:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2055,
      GIR_Done,
    // Label 720: @33451
    GIM_Try, /*On fail goto*//*Label 721*/ 33506, // Rule ID 1823 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (ld:{ *:[i32] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_flat>>  =>  (FLAT_LOAD_DWORD:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1823,
      GIR_Done,
    // Label 721: @33506
    GIM_Reject,
    // Label 594: @33507
    GIM_Try, /*On fail goto*//*Label 722*/ 33720,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_64_XEXECRegClassID,
      GIM_Try, /*On fail goto*//*Label 723*/ 33567, // Rule ID 1665 //
        GIM_CheckFeatures, GIFBS_isGFX9Plus,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr_imm,
        // (ld:{ *:[i1] } (SMRDSgprImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$soffset, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_SGPR_IMM:{ *:[i1] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$soffset, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_SGPR_IMM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1665,
        GIR_Done,
      // Label 723: @33567
      GIM_Try, /*On fail goto*//*Label 724*/ 33605, // Rule ID 1662 //
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
        // (ld:{ *:[i1] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[i1] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1662,
        GIR_Done,
      // Label 724: @33605
      GIM_Try, /*On fail goto*//*Label 725*/ 33645, // Rule ID 1663 //
        GIM_CheckFeatures, GIFBS_isGFX7Only,
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
        // (ld:{ *:[i1] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM_ci:{ *:[i1] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM_ci,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1663,
        GIR_Done,
      // Label 725: @33645
      GIM_Try, /*On fail goto*//*Label 726*/ 33683, // Rule ID 1664 //
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
        // (ld:{ *:[i1] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$soffset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_SGPR:{ *:[i1] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$soffset, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_SGPR,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1664,
        GIR_Done,
      // Label 726: @33683
      GIM_Try, /*On fail goto*//*Label 727*/ 33719, // Rule ID 1666 //
        // MIs[0] sbase
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
        // (ld:{ *:[i1] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORDX2_IMM:{ *:[i1] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORDX2_IMM,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1666,
        GIR_Done,
      // Label 727: @33719
      GIM_Reject,
    // Label 722: @33720
    GIM_Reject,
    // Label 595: @33721
    GIM_Try, /*On fail goto*//*Label 728*/ 33791, // Rule ID 3358 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offset,
      // (ld:{ *:[i16] } (MUBUFScratchOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>><<P:Predicate_extloadi8_private>>  =>  (BUFFER_LOAD_UBYTE_OFFSET:{ *:[i16] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_UBYTE_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3358,
      GIR_Done,
    // Label 728: @33791
    GIM_Try, /*On fail goto*//*Label 729*/ 33853, // Rule ID 3368 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offset,
      // (ld:{ *:[i16] } (MUBUFScratchOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_USHORT_OFFSET:{ *:[i16] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_USHORT_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3368,
      GIR_Done,
    // Label 729: @33853
    GIM_Try, /*On fail goto*//*Label 730*/ 33917, // Rule ID 2379 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_svaddr,
      // (ld:{ *:[i16] } (ScratchSVAddr:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>><<P:Predicate_extloadi8_private>>  =>  (SCRATCH_LOAD_UBYTE_SVS:{ *:[i16] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_UBYTE_SVS,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2379,
      GIR_Done,
    // Label 730: @33917
    GIM_Try, /*On fail goto*//*Label 731*/ 33973, // Rule ID 2397 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_svaddr,
      // (ld:{ *:[i16] } (ScratchSVAddr:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_USHORT_SVS:{ *:[i16] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_USHORT_SVS,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2397,
      GIR_Done,
    // Label 731: @33973
    GIM_Try, /*On fail goto*//*Label 732*/ 34033, // Rule ID 2378 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i16] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>><<P:Predicate_extloadi8_private>>  =>  (SCRATCH_LOAD_UBYTE_SADDR:{ *:[i16] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_UBYTE_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2378,
      GIR_Done,
    // Label 732: @34033
    GIM_Try, /*On fail goto*//*Label 733*/ 34085, // Rule ID 2396 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i16] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_USHORT_SADDR:{ *:[i16] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_USHORT_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2396,
      GIR_Done,
    // Label 733: @34085
    GIM_Try, /*On fail goto*//*Label 734*/ 34145, // Rule ID 2377 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i16] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>><<P:Predicate_extloadi8_private>>  =>  (SCRATCH_LOAD_UBYTE:{ *:[i16] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_UBYTE,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2377,
      GIR_Done,
    // Label 734: @34145
    GIM_Try, /*On fail goto*//*Label 735*/ 34197, // Rule ID 2395 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i16] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_USHORT:{ *:[i16] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_USHORT,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2395,
      GIR_Done,
    // Label 735: @34197
    GIM_Try, /*On fail goto*//*Label 736*/ 34267, // Rule ID 2595 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_addr64,
      // (atomic_load:{ *:[i16] } (MUBUFAddr64:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i64:{ *:[i64] }:$vaddr, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_8>><<P:Predicate_atomic_load_8_global>>  =>  (BUFFER_LOAD_UBYTE_ADDR64:{ *:[i16] } i64:{ *:[i64] }:$vaddr, v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_UBYTE_ADDR64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2595,
      GIR_Done,
    // Label 736: @34267
    GIM_Try, /*On fail goto*//*Label 737*/ 34337, // Rule ID 2597 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_addr64,
      // (atomic_load:{ *:[i16] } (MUBUFAddr64:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i64:{ *:[i64] }:$vaddr, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_16>><<P:Predicate_atomic_load_16_global>>  =>  (BUFFER_LOAD_USHORT_ADDR64:{ *:[i16] } i64:{ *:[i64] }:$vaddr, v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_USHORT_ADDR64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2597,
      GIR_Done,
    // Label 737: @34337
    GIM_Try, /*On fail goto*//*Label 738*/ 34411, // Rule ID 3357 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offen,
      // (ld:{ *:[i16] } (MUBUFScratchOffen:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$vaddr, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>><<P:Predicate_extloadi8_private>>  =>  (BUFFER_LOAD_UBYTE_OFFEN:{ *:[i16] } ?:{ *:[i32] }:$vaddr, ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_UBYTE_OFFEN,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3357,
      GIR_Done,
    // Label 738: @34411
    GIM_Try, /*On fail goto*//*Label 739*/ 34477, // Rule ID 3367 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offen,
      // (ld:{ *:[i16] } (MUBUFScratchOffen:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$vaddr, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_USHORT_OFFEN:{ *:[i16] } ?:{ *:[i32] }:$vaddr, ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_USHORT_OFFEN,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3367,
      GIR_Done,
    // Label 739: @34477
    GIM_Try, /*On fail goto*//*Label 740*/ 34543, // Rule ID 2594 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_offset,
      // (atomic_load:{ *:[i16] } (MUBUFOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_8>><<P:Predicate_atomic_load_8_global>>  =>  (BUFFER_LOAD_UBYTE_OFFSET:{ *:[i16] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_UBYTE_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2594,
      GIR_Done,
    // Label 740: @34543
    GIM_Try, /*On fail goto*//*Label 741*/ 34609, // Rule ID 2596 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_offset,
      // (atomic_load:{ *:[i16] } (MUBUFOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_16>><<P:Predicate_atomic_load_16_global>>  =>  (BUFFER_LOAD_USHORT_OFFSET:{ *:[i16] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_USHORT_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2596,
      GIR_Done,
    // Label 741: @34609
    GIM_Try, /*On fail goto*//*Label 742*/ 34680, // Rule ID 3341 //
      GIM_CheckFeatures, GIFBS_Has16BitInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/2, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_offset,
      // (ld:{ *:[i16] } (MUBUFOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>><<P:Predicate_extloadi8_constant>>  =>  (BUFFER_LOAD_UBYTE_OFFSET:{ *:[i16] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_UBYTE_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3341,
      GIR_Done,
    // Label 742: @34680
    GIM_Try, /*On fail goto*//*Label 743*/ 34752, // Rule ID 3344 //
      GIM_CheckFeatures, GIFBS_Has16BitInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_offset,
      // (ld:{ *:[i16] } (MUBUFOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>><<P:Predicate_extloadi8_global>>  =>  (BUFFER_LOAD_UBYTE_OFFSET:{ *:[i16] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_UBYTE_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3344,
      GIR_Done,
    // Label 743: @34752
    GIM_Try, /*On fail goto*//*Label 744*/ 34816, // Rule ID 3346 //
      GIM_CheckFeatures, GIFBS_Has16BitInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_offset,
      // (ld:{ *:[i16] } (MUBUFOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (BUFFER_LOAD_USHORT_OFFSET:{ *:[i16] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_USHORT_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3346,
      GIR_Done,
    // Label 744: @34816
    GIM_Try, /*On fail goto*//*Label 745*/ 34872, // Rule ID 4182 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUatomic_ld_glue:{ *:[i16] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_8_glue>><<P:Predicate_atomic_load_8_local_m0>>  =>  (DS_READ_U8:{ *:[i16] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4182,
      GIR_Done,
    // Label 745: @34872
    GIM_Try, /*On fail goto*//*Label 746*/ 34928, // Rule ID 4183 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (atomic_load:{ *:[i16] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_8>><<P:Predicate_atomic_load_8_local>>  =>  (DS_READ_U8_gfx9:{ *:[i16] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U8_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4183,
      GIR_Done,
    // Label 746: @34928
    GIM_Try, /*On fail goto*//*Label 747*/ 34984, // Rule ID 4186 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUatomic_ld_glue:{ *:[i16] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_16_glue>><<P:Predicate_atomic_load_16_local_m0>>  =>  (DS_READ_U16:{ *:[i16] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4186,
      GIR_Done,
    // Label 747: @34984
    GIM_Try, /*On fail goto*//*Label 748*/ 35040, // Rule ID 4187 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (atomic_load:{ *:[i16] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_16>><<P:Predicate_atomic_load_16_local>>  =>  (DS_READ_U16_gfx9:{ *:[i16] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U16_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4187,
      GIR_Done,
    // Label 748: @35040
    GIM_Try, /*On fail goto*//*Label 749*/ 35100, // Rule ID 4152 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i16] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_extload_glue>><<P:Predicate_extloadi8_glue>><<P:Predicate_extloadi8_local_m0>>  =>  (DS_READ_U8:{ *:[i16] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U8,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4152,
      GIR_Done,
    // Label 749: @35100
    GIM_Try, /*On fail goto*//*Label 750*/ 35160, // Rule ID 4153 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i16] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>><<P:Predicate_extloadi8_local>>  =>  (DS_READ_U8_gfx9:{ *:[i16] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U8_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4153,
      GIR_Done,
    // Label 750: @35160
    GIM_Try, /*On fail goto*//*Label 751*/ 35216, // Rule ID 4164 //
      GIM_CheckFeatures, GIFBS_LDSRequiresM0Init,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (AMDGPUld_glue:{ *:[i16] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload_glue>><<P:Predicate_load_glue>><<P:Predicate_load_local_m0>>  =>  (DS_READ_U16:{ *:[i16] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U16,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4164,
      GIR_Done,
    // Label 751: @35216
    GIM_Try, /*On fail goto*//*Label 752*/ 35268, // Rule ID 4165 //
      GIM_CheckFeatures, GIFBS_NotLDSRequiresM0Init,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/3,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_ds_1addr_1offset,
      // (ld:{ *:[i16] } (DS1Addr1Offset:{ *:[iPTR] } i32:{ *:[i32] }:$ptr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_local>>  =>  (DS_READ_U16_gfx9:{ *:[i16] } ?:{ *:[i32] }:$ptr, offset:{ *:[i16] }:$offset, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::DS_READ_U16_gfx9,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // ptr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 4165,
      GIR_Done,
    // Label 752: @35268
    GIM_Try, /*On fail goto*//*Label 753*/ 35330, // Rule ID 2004 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (atomic_load:{ *:[i16] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_8>><<P:Predicate_atomic_load_8_global>>  =>  (GLOBAL_LOAD_UBYTE_SADDR:{ *:[i16] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_UBYTE_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2004,
      GIR_Done,
    // Label 753: @35330
    GIM_Try, /*On fail goto*//*Label 754*/ 35392, // Rule ID 2008 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (atomic_load:{ *:[i16] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_16>><<P:Predicate_atomic_load_16_global>>  =>  (GLOBAL_LOAD_USHORT_SADDR:{ *:[i16] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_USHORT_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2008,
      GIR_Done,
    // Label 754: @35392
    GIM_Try, /*On fail goto*//*Label 755*/ 35458, // Rule ID 2016 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[i16] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>><<P:Predicate_extloadi8_global>>  =>  (GLOBAL_LOAD_UBYTE_SADDR:{ *:[i16] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_UBYTE_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2016,
      GIR_Done,
    // Label 755: @35458
    GIM_Try, /*On fail goto*//*Label 756*/ 35516, // Rule ID 2028 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_saddr,
      // (ld:{ *:[i16] } (GlobalSAddr:{ *:[iPTR] } SReg_64:{ *:[i64] }:$saddr, VGPR_32:{ *:[i32] }:$voffset, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_USHORT_SADDR:{ *:[i16] } ?:{ *:[i64] }:$saddr, ?:{ *:[i32] }:$voffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_USHORT_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // voffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2028,
      GIR_Done,
    // Label 756: @35516
    GIM_Try, /*On fail goto*//*Label 757*/ 35574, // Rule ID 2003 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (atomic_load:{ *:[i16] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_8>><<P:Predicate_atomic_load_8_global>>  =>  (GLOBAL_LOAD_UBYTE:{ *:[i16] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_UBYTE,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2003,
      GIR_Done,
    // Label 757: @35574
    GIM_Try, /*On fail goto*//*Label 758*/ 35632, // Rule ID 2007 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (atomic_load:{ *:[i16] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_16>><<P:Predicate_atomic_load_16_global>>  =>  (GLOBAL_LOAD_USHORT:{ *:[i16] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_USHORT,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2007,
      GIR_Done,
    // Label 758: @35632
    GIM_Try, /*On fail goto*//*Label 759*/ 35694, // Rule ID 2015 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[i16] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>><<P:Predicate_extloadi8_global>>  =>  (GLOBAL_LOAD_UBYTE:{ *:[i16] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_UBYTE,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2015,
      GIR_Done,
    // Label 759: @35694
    GIM_Try, /*On fail goto*//*Label 760*/ 35748, // Rule ID 2027 //
      GIM_CheckFeatures, GIFBS_HasFlatGlobalInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_global_offset,
      // (ld:{ *:[i16] } (GlobalOffset:{ *:[iPTR] } VReg_64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_global>>  =>  (GLOBAL_LOAD_USHORT:{ *:[i16] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::GLOBAL_LOAD_USHORT,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2027,
      GIR_Done,
    // Label 760: @35748
    GIM_Try, /*On fail goto*//*Label 761*/ 35807, // Rule ID 1791 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (atomic_load:{ *:[i16] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_8>><<P:Predicate_atomic_load_8_flat>>  =>  (FLAT_LOAD_UBYTE:{ *:[i16] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_UBYTE,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1791,
      GIR_Done,
    // Label 761: @35807
    GIM_Try, /*On fail goto*//*Label 762*/ 35866, // Rule ID 1793 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (atomic_load:{ *:[i16] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_16>><<P:Predicate_atomic_load_16_flat>>  =>  (FLAT_LOAD_USHORT:{ *:[i16] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_USHORT,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1793,
      GIR_Done,
    // Label 762: @35866
    GIM_Try, /*On fail goto*//*Label 763*/ 35929, // Rule ID 1797 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (ld:{ *:[i16] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>><<P:Predicate_extloadi8_flat>>  =>  (FLAT_LOAD_UBYTE:{ *:[i16] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_UBYTE,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1797,
      GIR_Done,
    // Label 763: @35929
    GIM_Try, /*On fail goto*//*Label 764*/ 35984, // Rule ID 1802 //
      GIM_CheckFeatures, GIFBS_HasFlatAddressSpace,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/4, /*AddrSpace*/0, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_offset,
      // (ld:{ *:[i16] } (FlatOffset:{ *:[iPTR] } i64:{ *:[i64] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_flat>>  =>  (FLAT_LOAD_USHORT:{ *:[i16] } ?:{ *:[i64] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::FLAT_LOAD_USHORT,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1802,
      GIR_Done,
    // Label 764: @35984
    GIM_Reject,
    // Label 596: @35985
    GIM_Try, /*On fail goto*//*Label 765*/ 36043, // Rule ID 1602 //
      GIM_CheckFeatures, GIFBS_isGFX9Plus,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr_imm,
      // (ld:{ *:[i32] } (SMRDSgprImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$soffset, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_SGPR_IMM:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$soffset, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_SGPR_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1602,
      GIR_Done,
    // Label 765: @36043
    GIM_Try, /*On fail goto*//*Label 766*/ 36101, // Rule ID 1610 //
      GIM_CheckFeatures, GIFBS_isGFX9Plus,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr_imm,
      // (ld:{ *:[f32] } (SMRDSgprImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$soffset, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_SGPR_IMM:{ *:[f32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$soffset, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_SGPR_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1610,
      GIR_Done,
    // Label 766: @36101
    GIM_Try, /*On fail goto*//*Label 767*/ 36153, // Rule ID 1599 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
      // (ld:{ *:[i32] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1599,
      GIR_Done,
    // Label 767: @36153
    GIM_Try, /*On fail goto*//*Label 768*/ 36207, // Rule ID 1600 //
      GIM_CheckFeatures, GIFBS_isGFX7Only,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
      // (ld:{ *:[i32] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM_ci:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM_ci,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1600,
      GIR_Done,
    // Label 768: @36207
    GIM_Try, /*On fail goto*//*Label 769*/ 36259, // Rule ID 1601 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
      // (ld:{ *:[i32] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$soffset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_SGPR:{ *:[i32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$soffset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_SGPR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1601,
      GIR_Done,
    // Label 769: @36259
    GIM_Try, /*On fail goto*//*Label 770*/ 36311, // Rule ID 1607 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm,
      // (ld:{ *:[f32] } (SMRDImm:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[f32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1607,
      GIR_Done,
    // Label 770: @36311
    GIM_Try, /*On fail goto*//*Label 771*/ 36365, // Rule ID 1608 //
      GIM_CheckFeatures, GIFBS_isGFX7Only,
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_imm32,
      // (ld:{ *:[f32] } (SMRDImm32:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM_ci:{ *:[f32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM_ci,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1608,
      GIR_Done,
    // Label 771: @36365
    GIM_Try, /*On fail goto*//*Label 772*/ 36417, // Rule ID 1609 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_smrd_sgpr,
      // (ld:{ *:[f32] } (SMRDSgpr:{ *:[iPTR] } i64:{ *:[i64] }:$sbase, i32:{ *:[i32] }:$soffset))<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_SGPR:{ *:[f32] } ?:{ *:[i64] }:$sbase, ?:{ *:[i32] }:$soffset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_SGPR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // sbase
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1609,
      GIR_Done,
    // Label 772: @36417
    GIM_Try, /*On fail goto*//*Label 773*/ 36467, // Rule ID 1603 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      // (ld:{ *:[i32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[i32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1603,
      GIR_Done,
    // Label 773: @36467
    GIM_Try, /*On fail goto*//*Label 774*/ 36517, // Rule ID 1611 //
      GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::SReg_32_XM0_XEXECRegClassID,
      // MIs[0] sbase
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AMDGPU::SReg_64RegClassID,
      GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_smrd_load,
      // (ld:{ *:[f32] } SReg_64:{ *:[i64] }:$sbase)<<P:Predicate_unindexedload>><<P:Predicate_load>><<P:Predicate_smrd_load>>  =>  (S_LOAD_DWORD_IMM:{ *:[f32] } i64:{ *:[i64] }:$sbase, 0:{ *:[i32] }, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::S_LOAD_DWORD_IMM,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // sdst
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // sbase
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1611,
      GIR_Done,
    // Label 774: @36517
    GIM_Try, /*On fail goto*//*Label 775*/ 36587, // Rule ID 3352 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offset,
      // (ld:{ *:[i32] } (MUBUFScratchOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>><<P:Predicate_extloadi8_private>>  =>  (BUFFER_LOAD_UBYTE_OFFSET:{ *:[i32] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_UBYTE_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3352,
      GIR_Done,
    // Label 775: @36587
    GIM_Try, /*On fail goto*//*Label 776*/ 36657, // Rule ID 3364 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offset,
      // (ld:{ *:[i32] } (MUBUFScratchOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16>><<P:Predicate_extloadi16_private>>  =>  (BUFFER_LOAD_USHORT_OFFSET:{ *:[i32] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_USHORT_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3364,
      GIR_Done,
    // Label 776: @36657
    GIM_Try, /*On fail goto*//*Label 777*/ 36719, // Rule ID 3370 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offset,
      // (ld:{ *:[i32] } (MUBUFScratchOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_DWORD_OFFSET:{ *:[i32] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3370,
      GIR_Done,
    // Label 777: @36719
    GIM_Try, /*On fail goto*//*Label 778*/ 36781, // Rule ID 3372 //
      GIM_CheckFeatures, GIFBS_DisableFlatScratch,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_scratch_offset,
      // (ld:{ *:[f32] } (MUBUFScratchOffset:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, u16imm:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (BUFFER_LOAD_DWORD_OFFSET:{ *:[f32] } ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset, 0:{ *:[i32] }, 0:{ *:[i1] }, 0:{ *:[i1] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_OFFSET,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3372,
      GIR_Done,
    // Label 778: @36781
    GIM_Try, /*On fail goto*//*Label 779*/ 36845, // Rule ID 1996 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_svaddr,
      // (ld:{ *:[i32] } (ScratchSVAddr:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>><<P:Predicate_extloadi8_private>>  =>  (SCRATCH_LOAD_UBYTE_SVS:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_UBYTE_SVS,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1996,
      GIR_Done,
    // Label 779: @36845
    GIM_Try, /*On fail goto*//*Label 780*/ 36909, // Rule ID 2388 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_svaddr,
      // (ld:{ *:[i32] } (ScratchSVAddr:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16>><<P:Predicate_extloadi16_private>>  =>  (SCRATCH_LOAD_USHORT_SVS:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_USHORT_SVS,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2388,
      GIR_Done,
    // Label 780: @36909
    GIM_Try, /*On fail goto*//*Label 781*/ 36965, // Rule ID 2400 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_svaddr,
      // (ld:{ *:[i32] } (ScratchSVAddr:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD_SVS:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD_SVS,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2400,
      GIR_Done,
    // Label 781: @36965
    GIM_Try, /*On fail goto*//*Label 782*/ 37021, // Rule ID 2403 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_svaddr,
      // (ld:{ *:[f32] } (ScratchSVAddr:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD_SVS:{ *:[f32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset, 0:{ *:[i32] })
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD_SVS,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2403,
      GIR_Done,
    // Label 782: @37021
    GIM_Try, /*On fail goto*//*Label 783*/ 37081, // Rule ID 1995 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i32] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>><<P:Predicate_extloadi8_private>>  =>  (SCRATCH_LOAD_UBYTE_SADDR:{ *:[i32] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_UBYTE_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1995,
      GIR_Done,
    // Label 783: @37081
    GIM_Try, /*On fail goto*//*Label 784*/ 37141, // Rule ID 2387 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i32] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16>><<P:Predicate_extloadi16_private>>  =>  (SCRATCH_LOAD_USHORT_SADDR:{ *:[i32] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_USHORT_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2387,
      GIR_Done,
    // Label 784: @37141
    GIM_Try, /*On fail goto*//*Label 785*/ 37193, // Rule ID 2399 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[i32] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD_SADDR:{ *:[i32] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2399,
      GIR_Done,
    // Label 785: @37193
    GIM_Try, /*On fail goto*//*Label 786*/ 37245, // Rule ID 2402 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_saddr,
      // (ld:{ *:[f32] } (ScratchSAddr:{ *:[iPTR] } SGPR_32:{ *:[i32] }:$saddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD_SADDR:{ *:[f32] } ?:{ *:[i32] }:$saddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD_SADDR,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // saddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2402,
      GIR_Done,
    // Label 786: @37245
    GIM_Try, /*On fail goto*//*Label 787*/ 37305, // Rule ID 1994 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i32] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi8>><<P:Predicate_extloadi8_private>>  =>  (SCRATCH_LOAD_UBYTE:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_UBYTE,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1994,
      GIR_Done,
    // Label 787: @37305
    GIM_Try, /*On fail goto*//*Label 788*/ 37365, // Rule ID 2386 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i32] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_extload>><<P:Predicate_extloadi16>><<P:Predicate_extloadi16_private>>  =>  (SCRATCH_LOAD_USHORT:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_USHORT,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2386,
      GIR_Done,
    // Label 788: @37365
    GIM_Try, /*On fail goto*//*Label 789*/ 37417, // Rule ID 2398 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[i32] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD:{ *:[i32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2398,
      GIR_Done,
    // Label 789: @37417
    GIM_Try, /*On fail goto*//*Label 790*/ 37469, // Rule ID 2401 //
      GIM_CheckFeatures, GIFBS_EnableFlatScratch_HasFlatScratchInsts,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/1, /*AddrSpace*/5,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_flat_scratch_offset,
      // (ld:{ *:[f32] } (ScratchOffset:{ *:[iPTR] } VGPR_32:{ *:[i32] }:$vaddr, i16:{ *:[i16] }:$offset))<<P:Predicate_unindexedload>><<P:Predicate_load_private>>  =>  (SCRATCH_LOAD_DWORD:{ *:[f32] } ?:{ *:[i32] }:$vaddr, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::SCRATCH_LOAD_DWORD,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdst
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2401,
      GIR_Done,
    // Label 790: @37469
    GIM_Try, /*On fail goto*//*Label 791*/ 37539, // Rule ID 2591 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_addr64,
      // (atomic_load:{ *:[i32] } (MUBUFAddr64:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i64:{ *:[i64] }:$vaddr, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_8>><<P:Predicate_atomic_load_8_global>>  =>  (BUFFER_LOAD_UBYTE_ADDR64:{ *:[i32] } i64:{ *:[i64] }:$vaddr, v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_UBYTE_ADDR64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2591,
      GIR_Done,
    // Label 791: @37539
    GIM_Try, /*On fail goto*//*Label 792*/ 37609, // Rule ID 2593 //
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/2,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_addr64,
      // (atomic_load:{ *:[i32] } (MUBUFAddr64:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i64:{ *:[i64] }:$vaddr, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_16>><<P:Predicate_atomic_load_16_global>>  =>  (BUFFER_LOAD_USHORT_ADDR64:{ *:[i32] } i64:{ *:[i64] }:$vaddr, v4i32:{ *:[v4i32] }:$srsrc, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_USHORT_ADDR64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 2593,
      GIR_Done,
    // Label 792: @37609
    GIM_Try, /*On fail goto*//*Label 793*/ 37681, // Rule ID 3330 //
      GIM_CheckFeatures, GIFBS_isGFX6GFX7,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/4,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrderingOrStrongerThan, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::Unordered,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
      GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
      GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_mubuf_addr64,
      // (atomic_load:{ *:[i32] } (MUBUFAddr64:{ *:[iPTR] } v4i32:{ *:[v4i32] }:$srsrc, i64:{ *:[i64] }:$vaddr, i32:{ *:[i32] }:$soffset, i16:{ *:[i16] }:$offset))<<P:Predicate_atomic_load_32>><<P:Predicate_atomic_load_32_global>>  =>  (BUFFER_LOAD_DWORD_ADDR64:{ *:[i32] } ?:{ *:[i64] }:$vaddr, ?:{ *:[v4i32] }:$srsrc, ?:{ *:[i32] }:$soffset, ?:{ *:[i16] }:$offset)
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AMDGPU::BUFFER_LOAD_DWORD_ADDR64,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // vdata
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/1, // vaddr
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/0, // srsrc
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/2, // soffset
      GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/0, /*SubOperand*/3, // offset
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_AddImm, /*InsnID*/0, /*Imm*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*MergeInsnID's*/0, GIU_MergeMemOperands_EndOfList,
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 3330,
      GIR_Done,
    // Label 793: @37681
    GIM_Try, /*On fail goto*//*Label 794*/ 37755, // Rule ID 2599 //
      GIM_CheckMemorySizeLessThanLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
      GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/1,
      GIM_CheckMemoryAddressSpace, /*MI*/0, /*MMO*/0, /*NumAddrSpace*/3, /*AddrSpace*/1, /*AddrSpace*/4, /*AddrSpace*/6,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(int64_t)AtomicOrdering::NotAtomic,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AMDGPU::AV_32RegClassID,
