/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Subtarget Enumeration Source Fragment                                      *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_SUBTARGETINFO_ENUM
#undef GET_SUBTARGETINFO_ENUM

namespace llvm {
namespace X86 {
enum {
  Feature3DNow = 0,
  Feature3DNowA = 1,
  FeatureADX = 2,
  FeatureAES = 3,
  FeatureAMXBF16 = 4,
  FeatureAMXINT8 = 5,
  FeatureAMXTILE = 6,
  FeatureAVX = 7,
  FeatureAVX2 = 8,
  FeatureAVX512 = 9,
  FeatureAVXVNNI = 10,
  FeatureBF16 = 11,
  FeatureBITALG = 12,
  FeatureBMI = 13,
  FeatureBMI2 = 14,
  FeatureBWI = 15,
  FeatureCDI = 16,
  FeatureCLDEMOTE = 17,
  FeatureCLFLUSHOPT = 18,
  FeatureCLWB = 19,
  FeatureCLZERO = 20,
  FeatureCMOV = 21,
  FeatureCRC32 = 22,
  FeatureCX8 = 23,
  FeatureCX16 = 24,
  FeatureDQI = 25,
  FeatureENQCMD = 26,
  FeatureERI = 27,
  FeatureERMSB = 28,
  FeatureF16C = 29,
  FeatureFMA = 30,
  FeatureFMA4 = 31,
  FeatureFP16 = 32,
  FeatureFSGSBase = 33,
  FeatureFSRM = 34,
  FeatureFXSR = 35,
  FeatureGFNI = 36,
  FeatureHRESET = 37,
  FeatureHardenSlsIJmp = 38,
  FeatureHardenSlsRet = 39,
  FeatureIFMA = 40,
  FeatureINVPCID = 41,
  FeatureKL = 42,
  FeatureLAHFSAHF64 = 43,
  FeatureLVIControlFlowIntegrity = 44,
  FeatureLVILoadHardening = 45,
  FeatureLWP = 46,
  FeatureLZCNT = 47,
  FeatureMMX = 48,
  FeatureMOVBE = 49,
  FeatureMOVDIR64B = 50,
  FeatureMOVDIRI = 51,
  FeatureMWAITX = 52,
  FeatureNOPL = 53,
  FeaturePCLMUL = 54,
  FeaturePCONFIG = 55,
  FeaturePFI = 56,
  FeaturePKU = 57,
  FeaturePOPCNT = 58,
  FeaturePREFETCHWT1 = 59,
  FeaturePRFCHW = 60,
  FeaturePTWRITE = 61,
  FeatureRDPID = 62,
  FeatureRDPRU = 63,
  FeatureRDRAND = 64,
  FeatureRDSEED = 65,
  FeatureRTM = 66,
  FeatureRetpoline = 67,
  FeatureRetpolineExternalThunk = 68,
  FeatureRetpolineIndirectBranches = 69,
  FeatureRetpolineIndirectCalls = 70,
  FeatureSERIALIZE = 71,
  FeatureSGX = 72,
  FeatureSHA = 73,
  FeatureSHSTK = 74,
  FeatureSSE1 = 75,
  FeatureSSE2 = 76,
  FeatureSSE3 = 77,
  FeatureSSE4A = 78,
  FeatureSSE41 = 79,
  FeatureSSE42 = 80,
  FeatureSSEUnalignedMem = 81,
  FeatureSSSE3 = 82,
  FeatureSoftFloat = 83,
  FeatureSpeculativeExecutionSideEffectSuppression = 84,
  FeatureTBM = 85,
  FeatureTSXLDTRK = 86,
  FeatureTaggedGlobals = 87,
  FeatureUINTR = 88,
  FeatureVAES = 89,
  FeatureVBMI = 90,
  FeatureVBMI2 = 91,
  FeatureVLX = 92,
  FeatureVNNI = 93,
  FeatureVP2INTERSECT = 94,
  FeatureVPCLMULQDQ = 95,
  FeatureVPOPCNTDQ = 96,
  FeatureWAITPKG = 97,
  FeatureWBNOINVD = 98,
  FeatureWIDEKL = 99,
  FeatureX86_64 = 100,
  FeatureX87 = 101,
  FeatureXOP = 102,
  FeatureXSAVE = 103,
  FeatureXSAVEC = 104,
  FeatureXSAVEOPT = 105,
  FeatureXSAVES = 106,
  Is16Bit = 107,
  Is32Bit = 108,
  Is64Bit = 109,
  ProcIntelAtom = 110,
  TuningBranchFusion = 111,
  TuningFast7ByteNOP = 112,
  TuningFast11ByteNOP = 113,
  TuningFast15ByteNOP = 114,
  TuningFastBEXTR = 115,
  TuningFastGather = 116,
  TuningFastHorizontalOps = 117,
  TuningFastLZCNT = 118,
  TuningFastMOVBE = 119,
  TuningFastSHLDRotate = 120,
  TuningFastScalarFSQRT = 121,
  TuningFastScalarShiftMasks = 122,
  TuningFastVariableCrossLaneShuffle = 123,
  TuningFastVariablePerLaneShuffle = 124,
  TuningFastVectorFSQRT = 125,
  TuningFastVectorShiftMasks = 126,
  TuningGETMANTFalseDeps = 127,
  TuningInsertVZEROUPPER = 128,
  TuningLEAForSP = 129,
  TuningLEAUsesAG = 130,
  TuningLZCNTFalseDeps = 131,
  TuningMULCFalseDeps = 132,
  TuningMULLQFalseDeps = 133,
  TuningMacroFusion = 134,
  TuningPERMFalseDeps = 135,
  TuningPOPCNTFalseDeps = 136,
  TuningPadShortFunctions = 137,
  TuningPrefer128Bit = 138,
  TuningPrefer256Bit = 139,
  TuningPreferMaskRegisters = 140,
  TuningRANGEFalseDeps = 141,
  TuningSBBDepBreaking = 142,
  TuningSlow3OpsLEA = 143,
  TuningSlowDivide32 = 144,
  TuningSlowDivide64 = 145,
  TuningSlowIncDec = 146,
  TuningSlowLEA = 147,
  TuningSlowPMADDWD = 148,
  TuningSlowPMULLD = 149,
  TuningSlowSHLD = 150,
  TuningSlowTwoMemOps = 151,
  TuningSlowUAMem16 = 152,
  TuningSlowUAMem32 = 153,
  TuningUseGLMDivSqrtCosts = 154,
  TuningUseSLMArithCosts = 155,
  NumSubtargetFeatures = 156
};
} // end namespace X86
} // end namespace llvm

#endif // GET_SUBTARGETINFO_ENUM


#ifdef GET_SUBTARGETINFO_MACRO
GET_SUBTARGETINFO_MACRO(IsAtom, false, isAtom)
GET_SUBTARGETINFO_MACRO(Is16Bit, false, is16Bit)
GET_SUBTARGETINFO_MACRO(Is32Bit, false, is32Bit)
GET_SUBTARGETINFO_MACRO(HasX86_64, false, hasX86_64)
GET_SUBTARGETINFO_MACRO(Is64Bit, false, is64Bit)
GET_SUBTARGETINFO_MACRO(HasADX, false, hasADX)
GET_SUBTARGETINFO_MACRO(HasAES, false, hasAES)
GET_SUBTARGETINFO_MACRO(HasAMXBF16, false, hasAMXBF16)
GET_SUBTARGETINFO_MACRO(HasAMXINT8, false, hasAMXINT8)
GET_SUBTARGETINFO_MACRO(HasAMXTILE, false, hasAMXTILE)
GET_SUBTARGETINFO_MACRO(HasBF16, false, hasBF16)
GET_SUBTARGETINFO_MACRO(HasBITALG, false, hasBITALG)
GET_SUBTARGETINFO_MACRO(HasBWI, false, hasBWI)
GET_SUBTARGETINFO_MACRO(HasCDI, false, hasCDI)
GET_SUBTARGETINFO_MACRO(HasDQI, false, hasDQI)
GET_SUBTARGETINFO_MACRO(HasERI, false, hasERI)
GET_SUBTARGETINFO_MACRO(HasFP16, false, hasFP16)
GET_SUBTARGETINFO_MACRO(HasIFMA, false, hasIFMA)
GET_SUBTARGETINFO_MACRO(HasPFI, false, hasPFI)
GET_SUBTARGETINFO_MACRO(HasVBMI, false, hasVBMI)
GET_SUBTARGETINFO_MACRO(HasVBMI2, false, hasVBMI2)
GET_SUBTARGETINFO_MACRO(HasVLX, false, hasVLX)
GET_SUBTARGETINFO_MACRO(HasVNNI, false, hasVNNI)
GET_SUBTARGETINFO_MACRO(HasVP2INTERSECT, false, hasVP2INTERSECT)
GET_SUBTARGETINFO_MACRO(HasVPOPCNTDQ, false, hasVPOPCNTDQ)
GET_SUBTARGETINFO_MACRO(HasAVXVNNI, false, hasAVXVNNI)
GET_SUBTARGETINFO_MACRO(HasBMI, false, hasBMI)
GET_SUBTARGETINFO_MACRO(HasBMI2, false, hasBMI2)
GET_SUBTARGETINFO_MACRO(HasBranchFusion, false, hasBranchFusion)
GET_SUBTARGETINFO_MACRO(HasCLDEMOTE, false, hasCLDEMOTE)
GET_SUBTARGETINFO_MACRO(HasCLFLUSHOPT, false, hasCLFLUSHOPT)
GET_SUBTARGETINFO_MACRO(HasCLWB, false, hasCLWB)
GET_SUBTARGETINFO_MACRO(HasCLZERO, false, hasCLZERO)
GET_SUBTARGETINFO_MACRO(HasCMOV, false, hasCMOV)
GET_SUBTARGETINFO_MACRO(HasCRC32, false, hasCRC32)
GET_SUBTARGETINFO_MACRO(HasCX16, false, hasCX16)
GET_SUBTARGETINFO_MACRO(HasCX8, false, hasCX8)
GET_SUBTARGETINFO_MACRO(HasENQCMD, false, hasENQCMD)
GET_SUBTARGETINFO_MACRO(HasERMSB, false, hasERMSB)
GET_SUBTARGETINFO_MACRO(HasF16C, false, hasF16C)
GET_SUBTARGETINFO_MACRO(HasGETMANTFalseDeps, false, hasGETMANTFalseDeps)
GET_SUBTARGETINFO_MACRO(HasLZCNTFalseDeps, false, hasLZCNTFalseDeps)
GET_SUBTARGETINFO_MACRO(HasMULCFalseDeps, false, hasMULCFalseDeps)
GET_SUBTARGETINFO_MACRO(HasMULLQFalseDeps, false, hasMULLQFalseDeps)
GET_SUBTARGETINFO_MACRO(HasPERMFalseDeps, false, hasPERMFalseDeps)
GET_SUBTARGETINFO_MACRO(HasPOPCNTFalseDeps, false, hasPOPCNTFalseDeps)
GET_SUBTARGETINFO_MACRO(HasRANGEFalseDeps, false, hasRANGEFalseDeps)
GET_SUBTARGETINFO_MACRO(HasFast11ByteNOP, false, hasFast11ByteNOP)
GET_SUBTARGETINFO_MACRO(HasFast15ByteNOP, false, hasFast15ByteNOP)
GET_SUBTARGETINFO_MACRO(HasFast7ByteNOP, false, hasFast7ByteNOP)
GET_SUBTARGETINFO_MACRO(HasFastBEXTR, false, hasFastBEXTR)
GET_SUBTARGETINFO_MACRO(HasFastGather, false, hasFastGather)
GET_SUBTARGETINFO_MACRO(HasFastHorizontalOps, false, hasFastHorizontalOps)
GET_SUBTARGETINFO_MACRO(HasFastLZCNT, false, hasFastLZCNT)
GET_SUBTARGETINFO_MACRO(HasFastMOVBE, false, hasFastMOVBE)
GET_SUBTARGETINFO_MACRO(HasFastScalarFSQRT, false, hasFastScalarFSQRT)
GET_SUBTARGETINFO_MACRO(HasFastScalarShiftMasks, false, hasFastScalarShiftMasks)
GET_SUBTARGETINFO_MACRO(HasFastSHLDRotate, false, hasFastSHLDRotate)
GET_SUBTARGETINFO_MACRO(HasFastVariableCrossLaneShuffle, false, hasFastVariableCrossLaneShuffle)
GET_SUBTARGETINFO_MACRO(HasFastVariablePerLaneShuffle, false, hasFastVariablePerLaneShuffle)
GET_SUBTARGETINFO_MACRO(HasFastVectorFSQRT, false, hasFastVectorFSQRT)
GET_SUBTARGETINFO_MACRO(HasFastVectorShiftMasks, false, hasFastVectorShiftMasks)
GET_SUBTARGETINFO_MACRO(HasFMA, false, hasFMA)
GET_SUBTARGETINFO_MACRO(HasFMA4, false, hasFMA4)
GET_SUBTARGETINFO_MACRO(HasFSGSBase, false, hasFSGSBase)
GET_SUBTARGETINFO_MACRO(HasFSRM, false, hasFSRM)
GET_SUBTARGETINFO_MACRO(HasFXSR, false, hasFXSR)
GET_SUBTARGETINFO_MACRO(HasGFNI, false, hasGFNI)
GET_SUBTARGETINFO_MACRO(HardenSlsIJmp, false, hardenSlsIJmp)
GET_SUBTARGETINFO_MACRO(HardenSlsRet, false, hardenSlsRet)
GET_SUBTARGETINFO_MACRO(HasHRESET, false, hasHRESET)
GET_SUBTARGETINFO_MACRO(HasSlowDivide32, false, hasSlowDivide32)
GET_SUBTARGETINFO_MACRO(HasSlowDivide64, false, hasSlowDivide64)
GET_SUBTARGETINFO_MACRO(HasINVPCID, false, hasINVPCID)
GET_SUBTARGETINFO_MACRO(HasKL, false, hasKL)
GET_SUBTARGETINFO_MACRO(UseLeaForSP, false, useLeaForSP)
GET_SUBTARGETINFO_MACRO(LeaUsesAG, false, leaUsesAG)
GET_SUBTARGETINFO_MACRO(UseLVIControlFlowIntegrity, false, useLVIControlFlowIntegrity)
GET_SUBTARGETINFO_MACRO(UseLVILoadHardening, false, useLVILoadHardening)
GET_SUBTARGETINFO_MACRO(HasLWP, false, hasLWP)
GET_SUBTARGETINFO_MACRO(HasLZCNT, false, hasLZCNT)
GET_SUBTARGETINFO_MACRO(HasMacroFusion, false, hasMacroFusion)
GET_SUBTARGETINFO_MACRO(HasMOVBE, false, hasMOVBE)
GET_SUBTARGETINFO_MACRO(HasMOVDIR64B, false, hasMOVDIR64B)
GET_SUBTARGETINFO_MACRO(HasMOVDIRI, false, hasMOVDIRI)
GET_SUBTARGETINFO_MACRO(HasMWAITX, false, hasMWAITX)
GET_SUBTARGETINFO_MACRO(HasNOPL, false, hasNOPL)
GET_SUBTARGETINFO_MACRO(PadShortFunctions, false, padShortFunctions)
GET_SUBTARGETINFO_MACRO(HasPCLMUL, false, hasPCLMUL)
GET_SUBTARGETINFO_MACRO(HasPCONFIG, false, hasPCONFIG)
GET_SUBTARGETINFO_MACRO(HasPKU, false, hasPKU)
GET_SUBTARGETINFO_MACRO(HasPOPCNT, false, hasPOPCNT)
GET_SUBTARGETINFO_MACRO(Prefer128Bit, false, prefer128Bit)
GET_SUBTARGETINFO_MACRO(Prefer256Bit, false, prefer256Bit)
GET_SUBTARGETINFO_MACRO(PreferMaskRegisters, false, preferMaskRegisters)
GET_SUBTARGETINFO_MACRO(HasPREFETCHWT1, false, hasPREFETCHWT1)
GET_SUBTARGETINFO_MACRO(HasPRFCHW, false, hasPRFCHW)
GET_SUBTARGETINFO_MACRO(HasPTWRITE, false, hasPTWRITE)
GET_SUBTARGETINFO_MACRO(HasRDPID, false, hasRDPID)
GET_SUBTARGETINFO_MACRO(HasRDPRU, false, hasRDPRU)
GET_SUBTARGETINFO_MACRO(HasRDRAND, false, hasRDRAND)
GET_SUBTARGETINFO_MACRO(HasRDSEED, false, hasRDSEED)
GET_SUBTARGETINFO_MACRO(DeprecatedUseRetpoline, false, deprecatedUseRetpoline)
GET_SUBTARGETINFO_MACRO(UseRetpolineExternalThunk, false, useRetpolineExternalThunk)
GET_SUBTARGETINFO_MACRO(UseRetpolineIndirectBranches, false, useRetpolineIndirectBranches)
GET_SUBTARGETINFO_MACRO(UseRetpolineIndirectCalls, false, useRetpolineIndirectCalls)
GET_SUBTARGETINFO_MACRO(HasRTM, false, hasRTM)
GET_SUBTARGETINFO_MACRO(HasLAHFSAHF64, false, hasLAHFSAHF64)
GET_SUBTARGETINFO_MACRO(HasSBBDepBreaking, false, hasSBBDepBreaking)
GET_SUBTARGETINFO_MACRO(HasSERIALIZE, false, hasSERIALIZE)
GET_SUBTARGETINFO_MACRO(UseSpeculativeExecutionSideEffectSuppression, false, useSpeculativeExecutionSideEffectSuppression)
GET_SUBTARGETINFO_MACRO(HasSGX, false, hasSGX)
GET_SUBTARGETINFO_MACRO(HasSHA, false, hasSHA)
GET_SUBTARGETINFO_MACRO(HasSHSTK, false, hasSHSTK)
GET_SUBTARGETINFO_MACRO(Slow3OpsLEA, false, slow3OpsLEA)
GET_SUBTARGETINFO_MACRO(SlowIncDec, false, slowIncDec)
GET_SUBTARGETINFO_MACRO(SlowLEA, false, slowLEA)
GET_SUBTARGETINFO_MACRO(IsPMADDWDSlow, false, isPMADDWDSlow)
GET_SUBTARGETINFO_MACRO(IsPMULLDSlow, false, isPMULLDSlow)
GET_SUBTARGETINFO_MACRO(IsSHLDSlow, false, isSHLDSlow)
GET_SUBTARGETINFO_MACRO(SlowTwoMemOps, false, slowTwoMemOps)
GET_SUBTARGETINFO_MACRO(IsUnalignedMem16Slow, false, isUnalignedMem16Slow)
GET_SUBTARGETINFO_MACRO(IsUnalignedMem32Slow, false, isUnalignedMem32Slow)
GET_SUBTARGETINFO_MACRO(UseSoftFloat, false, useSoftFloat)
GET_SUBTARGETINFO_MACRO(HasSSEUnalignedMem, false, hasSSEUnalignedMem)
GET_SUBTARGETINFO_MACRO(HasSSE4A, false, hasSSE4A)
GET_SUBTARGETINFO_MACRO(AllowTaggedGlobals, false, allowTaggedGlobals)
GET_SUBTARGETINFO_MACRO(HasTBM, false, hasTBM)
GET_SUBTARGETINFO_MACRO(HasTSXLDTRK, false, hasTSXLDTRK)
GET_SUBTARGETINFO_MACRO(HasUINTR, false, hasUINTR)
GET_SUBTARGETINFO_MACRO(UseGLMDivSqrtCosts, false, useGLMDivSqrtCosts)
GET_SUBTARGETINFO_MACRO(UseSLMArithCosts, false, useSLMArithCosts)
GET_SUBTARGETINFO_MACRO(HasVAES, false, hasVAES)
GET_SUBTARGETINFO_MACRO(HasVPCLMULQDQ, false, hasVPCLMULQDQ)
GET_SUBTARGETINFO_MACRO(InsertVZEROUPPER, false, insertVZEROUPPER)
GET_SUBTARGETINFO_MACRO(HasWAITPKG, false, hasWAITPKG)
GET_SUBTARGETINFO_MACRO(HasWBNOINVD, false, hasWBNOINVD)
GET_SUBTARGETINFO_MACRO(HasWIDEKL, false, hasWIDEKL)
GET_SUBTARGETINFO_MACRO(HasX87, false, hasX87)
GET_SUBTARGETINFO_MACRO(HasXOP, false, hasXOP)
GET_SUBTARGETINFO_MACRO(HasXSAVE, false, hasXSAVE)
GET_SUBTARGETINFO_MACRO(HasXSAVEC, false, hasXSAVEC)
GET_SUBTARGETINFO_MACRO(HasXSAVEOPT, false, hasXSAVEOPT)
GET_SUBTARGETINFO_MACRO(HasXSAVES, false, hasXSAVES)
#undef GET_SUBTARGETINFO_MACRO
#endif // GET_SUBTARGETINFO_MACRO


#ifdef GET_SUBTARGETINFO_MC_DESC
#undef GET_SUBTARGETINFO_MC_DESC

namespace llvm {
// Sorted (by key) array of values for CPU features.
extern const llvm::SubtargetFeatureKV X86FeatureKV[] = {
  { "16bit-mode", "16-bit mode (i8086)", X86::Is16Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "32bit-mode", "32-bit mode (80386)", X86::Is32Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "3dnow", "Enable 3DNow! instructions", X86::Feature3DNow, { { { 0x1000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "3dnowa", "Enable 3DNow! Athlon instructions", X86::Feature3DNowA, { { { 0x1ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "64bit", "Support 64-bit instructions", X86::FeatureX86_64, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "64bit-mode", "64-bit mode (x86_64)", X86::Is64Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "adx", "Support ADX instructions", X86::FeatureADX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "aes", "Enable AES instructions", X86::FeatureAES, { { { 0x0ULL, 0x1000ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-bf16", "Support AMX-BF16 instructions", X86::FeatureAMXBF16, { { { 0x40ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-int8", "Support AMX-INT8 instructions", X86::FeatureAMXINT8, { { { 0x40ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-tile", "Support AMX-TILE instructions", X86::FeatureAMXTILE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx", "Enable AVX instructions", X86::FeatureAVX, { { { 0x0ULL, 0x10000ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx2", "Enable AVX2 instructions", X86::FeatureAVX2, { { { 0x80ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bf16", "Support bfloat16 floating point", X86::FeatureBF16, { { { 0x8000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bitalg", "Enable AVX-512 Bit Algorithms", X86::FeatureBITALG, { { { 0x8000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bw", "Enable AVX-512 Byte and Word Instructions", X86::FeatureBWI, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512cd", "Enable AVX-512 Conflict Detection Instructions", X86::FeatureCDI, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512dq", "Enable AVX-512 Doubleword and Quadword Instructions", X86::FeatureDQI, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512er", "Enable AVX-512 Exponential and Reciprocal Instructions", X86::FeatureERI, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512f", "Enable AVX-512 instructions", X86::FeatureAVX512, { { { 0x60000100ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512fp16", "Support 16-bit floating point", X86::FeatureFP16, { { { 0x2008000ULL, 0x10000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512ifma", "Enable AVX-512 Integer Fused Multiple-Add", X86::FeatureIFMA, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512pf", "Enable AVX-512 PreFetch Instructions", X86::FeaturePFI, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vbmi", "Enable AVX-512 Vector Byte Manipulation Instructions", X86::FeatureVBMI, { { { 0x8000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vbmi2", "Enable AVX-512 further Vector Byte Manipulation Instructions", X86::FeatureVBMI2, { { { 0x8000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vl", "Enable AVX-512 Vector Length eXtensions", X86::FeatureVLX, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vnni", "Enable AVX-512 Vector Neural Network Instructions", X86::FeatureVNNI, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vp2intersect", "Enable AVX-512 vp2intersect", X86::FeatureVP2INTERSECT, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vpopcntdq", "Enable AVX-512 Population Count Instructions", X86::FeatureVPOPCNTDQ, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxvnni", "Support AVX_VNNI encoding", X86::FeatureAVXVNNI, { { { 0x100ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "bmi", "Support BMI instructions", X86::FeatureBMI, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "bmi2", "Support BMI2 instructions", X86::FeatureBMI2, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "branchfusion", "CMP/TEST can be fused with conditional branches", X86::TuningBranchFusion, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cldemote", "Enable Cache Line Demote", X86::FeatureCLDEMOTE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clflushopt", "Flush A Cache Line Optimized", X86::FeatureCLFLUSHOPT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clwb", "Cache Line Write Back", X86::FeatureCLWB, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clzero", "Enable Cache Line Zero", X86::FeatureCLZERO, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cmov", "Enable conditional move instructions", X86::FeatureCMOV, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "crc32", "Enable SSE 4.2 CRC32 instruction (used when SSE4.2 is supported but function is GPR only)", X86::FeatureCRC32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cx16", "64-bit with cmpxchg16b (this is true for most x86-64 chips, but not the first AMD chips)", X86::FeatureCX16, { { { 0x800000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cx8", "Support CMPXCHG8B instructions", X86::FeatureCX8, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "enqcmd", "Has ENQCMD instructions", X86::FeatureENQCMD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ermsb", "REP MOVS/STOS are fast", X86::FeatureERMSB, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "f16c", "Support 16-bit floating point conversion instructions", X86::FeatureF16C, { { { 0x80ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-getmant", "VGETMANTSS/SD/SH and VGETMANDPS/PD(memory version) has a false dependency on dest register", X86::TuningGETMANTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-lzcnt-tzcnt", "LZCNT/TZCNT have a false dependency on dest register", X86::TuningLZCNTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-mulc", "VF[C]MULCPH/SH has a false dependency on dest register", X86::TuningMULCFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-mullq", "VPMULLQ has a false dependency on dest register", X86::TuningMULLQFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-perm", "VPERMD/Q/PS/PD has a false dependency on dest register", X86::TuningPERMFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-popcnt", "POPCNT has a false dependency on dest register", X86::TuningPOPCNTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-range", "VRANGEPD/PS/SD/SS has a false dependency on dest register", X86::TuningRANGEFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-11bytenop", "Target can quickly decode up to 11 byte NOPs", X86::TuningFast11ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-15bytenop", "Target can quickly decode up to 15 byte NOPs", X86::TuningFast15ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-7bytenop", "Target can quickly decode up to 7 byte NOPs", X86::TuningFast7ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-bextr", "Indicates that the BEXTR instruction is implemented as a single uop with good throughput", X86::TuningFastBEXTR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-gather", "Indicates if gather is reasonably fast (this is true for Skylake client and all AVX-512 CPUs)", X86::TuningFastGather, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-hops", "Prefer horizontal vector math instructions (haddp, phsub, etc.) over normal vector instructions with shuffles", X86::TuningFastHorizontalOps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-lzcnt", "LZCNT instructions are as fast as most simple integer ops", X86::TuningFastLZCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-movbe", "Prefer a movbe over a single-use load + bswap / single-use bswap + store", X86::TuningFastMOVBE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-scalar-fsqrt", "Scalar SQRT is fast (disable Newton-Raphson)", X86::TuningFastScalarFSQRT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-scalar-shift-masks", "Prefer a left/right scalar logical shift pair over a shift+and pair", X86::TuningFastScalarShiftMasks, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-shld-rotate", "SHLD can be used as a faster rotate", X86::TuningFastSHLDRotate, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-variable-crosslane-shuffle", "Cross-lane shuffles with variable masks are fast", X86::TuningFastVariableCrossLaneShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-variable-perlane-shuffle", "Per-lane shuffles with variable masks are fast", X86::TuningFastVariablePerLaneShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-vector-fsqrt", "Vector SQRT is fast (disable Newton-Raphson)", X86::TuningFastVectorFSQRT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-vector-shift-masks", "Prefer a left/right vector logical shift pair over a shift+and pair", X86::TuningFastVectorShiftMasks, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fma", "Enable three-operand fused multiple-add", X86::FeatureFMA, { { { 0x80ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fma4", "Enable four-operand fused multiple-add", X86::FeatureFMA4, { { { 0x80ULL, 0x4000ULL, 0x0ULL, 0x0ULL, } } } },
  { "fsgsbase", "Support FS/GS Base instructions", X86::FeatureFSGSBase, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fsrm", "REP MOVSB of short lengths is faster", X86::FeatureFSRM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fxsr", "Support fxsave/fxrestore instructions", X86::FeatureFXSR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "gfni", "Enable Galois Field Arithmetic Instructions", X86::FeatureGFNI, { { { 0x0ULL, 0x1000ULL, 0x0ULL, 0x0ULL, } } } },
  { "harden-sls-ijmp", "Harden against straight line speculation across indirect JMP instructions.", X86::FeatureHardenSlsIJmp, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "harden-sls-ret", "Harden against straight line speculation across RET instructions.", X86::FeatureHardenSlsRet, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "hreset", "Has hreset instruction", X86::FeatureHRESET, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "idivl-to-divb", "Use 8-bit divide for positive values less than 256", X86::TuningSlowDivide32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "idivq-to-divl", "Use 32-bit divide for positive values less than 2^32", X86::TuningSlowDivide64, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "invpcid", "Invalidate Process-Context Identifier", X86::FeatureINVPCID, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "kl", "Support Key Locker kl Instructions", X86::FeatureKL, { { { 0x0ULL, 0x1000ULL, 0x0ULL, 0x0ULL, } } } },
  { "lea-sp", "Use LEA for adjusting the stack pointer (this is an optimization for Intel Atom processors)", X86::TuningLEAForSP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lea-uses-ag", "LEA instruction needs inputs at AG stage", X86::TuningLEAUsesAG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lvi-cfi", "Prevent indirect calls/branches from using a memory operand, and precede all indirect calls/branches from a register with an LFENCE instruction to serialize control flow. Also decompose RET instructions into a POP+LFENCE+JMP sequence.", X86::FeatureLVIControlFlowIntegrity, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lvi-load-hardening", "Insert LFENCE instructions to prevent data speculatively injected into loads from being used maliciously.", X86::FeatureLVILoadHardening, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lwp", "Enable LWP instructions", X86::FeatureLWP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lzcnt", "Support LZCNT instruction", X86::FeatureLZCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "macrofusion", "Various instructions can be fused with conditional branches", X86::TuningMacroFusion, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "mmx", "Enable MMX instructions", X86::FeatureMMX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movbe", "Support MOVBE instruction", X86::FeatureMOVBE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movdir64b", "Support movdir64b instruction (direct store 64 bytes)", X86::FeatureMOVDIR64B, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movdiri", "Support movdiri instruction (direct store integer)", X86::FeatureMOVDIRI, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "mwaitx", "Enable MONITORX/MWAITX timer functionality", X86::FeatureMWAITX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "nopl", "Enable NOPL instruction (generally pentium pro+)", X86::FeatureNOPL, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pad-short-functions", "Pad short functions (to prevent a stall when returning too early)", X86::TuningPadShortFunctions, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pclmul", "Enable packed carry-less multiplication instructions", X86::FeaturePCLMUL, { { { 0x0ULL, 0x1000ULL, 0x0ULL, 0x0ULL, } } } },
  { "pconfig", "platform configuration instruction", X86::FeaturePCONFIG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pku", "Enable protection keys", X86::FeaturePKU, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "popcnt", "Support POPCNT instruction", X86::FeaturePOPCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-128-bit", "Prefer 128-bit AVX instructions", X86::TuningPrefer128Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-256-bit", "Prefer 256-bit AVX instructions", X86::TuningPrefer256Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-mask-registers", "Prefer AVX512 mask registers over PTEST/MOVMSK", X86::TuningPreferMaskRegisters, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefetchwt1", "Prefetch with Intent to Write and T1 Hint", X86::FeaturePREFETCHWT1, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prfchw", "Support PRFCHW instructions", X86::FeaturePRFCHW, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ptwrite", "Support ptwrite instruction", X86::FeaturePTWRITE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdpid", "Support RDPID instructions", X86::FeatureRDPID, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdpru", "Support RDPRU instructions", X86::FeatureRDPRU, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdrnd", "Support RDRAND instruction", X86::FeatureRDRAND, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdseed", "Support RDSEED instruction", X86::FeatureRDSEED, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline", "Remove speculation of indirect branches from the generated code, either by avoiding them entirely or lowering them with a speculation blocking construct", X86::FeatureRetpoline, { { { 0x0ULL, 0x60ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-external-thunk", "When lowering an indirect call or branch using a `retpoline`, rely on the specified user provided thunk rather than emitting one ourselves. Only has effect when combined with some other retpoline feature", X86::FeatureRetpolineExternalThunk, { { { 0x0ULL, 0x40ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-indirect-branches", "Remove speculation of indirect branches from the generated code", X86::FeatureRetpolineIndirectBranches, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-indirect-calls", "Remove speculation of indirect calls from the generated code", X86::FeatureRetpolineIndirectCalls, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rtm", "Support RTM instructions", X86::FeatureRTM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sahf", "Support LAHF and SAHF instructions in 64-bit mode", X86::FeatureLAHFSAHF64, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sbb-dep-breaking", "SBB with same register has no source dependency", X86::TuningSBBDepBreaking, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "serialize", "Has serialize instruction", X86::FeatureSERIALIZE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "seses", "Prevent speculative execution side channel timing attacks by inserting a speculation barrier before memory reads, memory writes, and conditional branches. Implies LVI Control Flow integrity.", X86::FeatureSpeculativeExecutionSideEffectSuppression, { { { 0x100000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sgx", "Enable Software Guard Extensions", X86::FeatureSGX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sha", "Enable SHA instructions", X86::FeatureSHA, { { { 0x0ULL, 0x1000ULL, 0x0ULL, 0x0ULL, } } } },
  { "shstk", "Support CET Shadow-Stack instructions", X86::FeatureSHSTK, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-3ops-lea", "LEA instruction with 3 ops or certain registers is slow", X86::TuningSlow3OpsLEA, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-incdec", "INC and DEC instructions are slower than ADD and SUB", X86::TuningSlowIncDec, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-lea", "LEA instruction with certain arguments is slow", X86::TuningSlowLEA, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-pmaddwd", "PMADDWD is slower than PMULLD", X86::TuningSlowPMADDWD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-pmulld", "PMULLD instruction is slow (compared to PMULLW/PMULHW and PMULUDQ)", X86::TuningSlowPMULLD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-shld", "SHLD instruction is slow", X86::TuningSlowSHLD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-two-mem-ops", "Two memory operand instructions are slow", X86::TuningSlowTwoMemOps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-unaligned-mem-16", "Slow unaligned 16-byte memory access", X86::TuningSlowUAMem16, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-unaligned-mem-32", "Slow unaligned 32-byte memory access", X86::TuningSlowUAMem32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "soft-float", "Use software floating point features", X86::FeatureSoftFloat, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse", "Enable SSE instructions", X86::FeatureSSE1, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse-unaligned-mem", "Allow unaligned memory operands with SSE instructions (this may require setting a configuration bit in the processor)", X86::FeatureSSEUnalignedMem, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse2", "Enable SSE2 instructions", X86::FeatureSSE2, { { { 0x0ULL, 0x800ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse3", "Enable SSE3 instructions", X86::FeatureSSE3, { { { 0x0ULL, 0x1000ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4.1", "Enable SSE 4.1 instructions", X86::FeatureSSE41, { { { 0x0ULL, 0x40000ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4.2", "Enable SSE 4.2 instructions", X86::FeatureSSE42, { { { 0x0ULL, 0x8000ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4a", "Support SSE 4a instructions", X86::FeatureSSE4A, { { { 0x0ULL, 0x2000ULL, 0x0ULL, 0x0ULL, } } } },
  { "ssse3", "Enable SSSE3 instructions", X86::FeatureSSSE3, { { { 0x0ULL, 0x2000ULL, 0x0ULL, 0x0ULL, } } } },
  { "tagged-globals", "Use an instruction sequence for taking the address of a global that allows a memory tag in the upper address bits.", X86::FeatureTaggedGlobals, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tbm", "Enable TBM instructions", X86::FeatureTBM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tsxldtrk", "Support TSXLDTRK instructions", X86::FeatureTSXLDTRK, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "uintr", "Has UINTR Instructions", X86::FeatureUINTR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "use-glm-div-sqrt-costs", "Use Goldmont specific floating point div/sqrt costs", X86::TuningUseGLMDivSqrtCosts, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "use-slm-arith-costs", "Use Silvermont specific arithmetic costs", X86::TuningUseSLMArithCosts, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vaes", "Promote selected AES instructions to AVX512/AVX registers", X86::FeatureVAES, { { { 0x88ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vpclmulqdq", "Enable vpclmulqdq instructions", X86::FeatureVPCLMULQDQ, { { { 0x40000000000080ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vzeroupper", "Should insert vzeroupper instructions", X86::TuningInsertVZEROUPPER, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "waitpkg", "Wait and pause enhancements", X86::FeatureWAITPKG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "wbnoinvd", "Write Back No Invalidate", X86::FeatureWBNOINVD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "widekl", "Support Key Locker wide Instructions", X86::FeatureWIDEKL, { { { 0x40000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "x87", "Enable X87 float instructions", X86::FeatureX87, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xop", "Enable XOP instructions", X86::FeatureXOP, { { { 0x80000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsave", "Support xsave instructions", X86::FeatureXSAVE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsavec", "Support xsavec instructions", X86::FeatureXSAVEC, { { { 0x0ULL, 0x8000000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsaveopt", "Support xsaveopt instructions", X86::FeatureXSAVEOPT, { { { 0x0ULL, 0x8000000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsaves", "Support xsaves instructions", X86::FeatureXSAVES, { { { 0x0ULL, 0x8000000000ULL, 0x0ULL, 0x0ULL, } } } },
};

#ifdef DBGFIELD
#error "<target>GenSubtargetInfo.inc requires a DBGFIELD macro"
#endif
#if !defined(NDEBUG) || defined(LLVM_ENABLE_DUMP)
#define DBGFIELD(x) x,
#else
#define DBGFIELD(x)
#endif

// ===============================================================
// Data tables for the new per-operand machine model.

// {ProcResourceIdx, Cycles}
extern const llvm::MCWriteProcResEntry X86WriteProcResTable[] = {
  { 0,  0}, // Invalid
  {22,  1}, // #1
  {23,  1}, // #2
  {13,  1}, // #3
  {19,  1}, // #4
  {20,  1}, // #5
  {22,  1}, // #6
  {23,  1}, // #7
  {14,  1}, // #8
  {20,  1}, // #9
  {22,  1}, // #10
  {23,  1}, // #11
  { 7,  1}, // #12
  {12,  1}, // #13
  {14,  2}, // #14
  {17,  1}, // #15
  {20,  2}, // #16
  {21,  2}, // #17
  {22,  3}, // #18
  {23,  6}, // #19
  {14,  1}, // #20
  {17,  1}, // #21
  {20,  1}, // #22
  {21,  1}, // #23
  {22,  1}, // #24
  {23,  2}, // #25
  { 4,  1}, // #26
  {11,  1}, // #27
  {15,  1}, // #28
  {16,  1}, // #29
  {19,  1}, // #30
  {22,  1}, // #31
  {23,  1}, // #32
  { 7,  1}, // #33
  {12,  1}, // #34
  {21,  1}, // #35
  {23,  2}, // #36
  {17,  1}, // #37
  {21,  1}, // #38
  {23,  1}, // #39
  { 3,  1}, // #40
  {11,  1}, // #41
  {12,  1}, // #42
  {13,  1}, // #43
  {14,  1}, // #44
  {19,  1}, // #45
  {20,  1}, // #46
  {22,  1}, // #47
  {23,  1}, // #48
  { 7,  1}, // #49
  {12,  1}, // #50
  {17,  1}, // #51
  {21,  2}, // #52
  {22,  1}, // #53
  {23,  4}, // #54
  {17,  1}, // #55
  {21,  1}, // #56
  {22,  1}, // #57
  {23,  2}, // #58
  {11,  1}, // #59
  {17,  1}, // #60
  {19,  1}, // #61
  {21,  1}, // #62
  {22,  1}, // #63
  {23,  2}, // #64
  {11,  1}, // #65
  {19,  1}, // #66
  {22,  1}, // #67
  {23,  1}, // #68
  { 3,  1}, // #69
  {11,  1}, // #70
  {12,  1}, // #71
  {13,  1}, // #72
  {14,  1}, // #73
  {17,  1}, // #74
  {19,  1}, // #75
  {20,  1}, // #76
  {21,  1}, // #77
  {22,  1}, // #78
  {23,  2}, // #79
  { 3,  2}, // #80
  {11,  2}, // #81
  {12,  2}, // #82
  {13,  2}, // #83
  {14,  2}, // #84
  {17,  1}, // #85
  {19,  2}, // #86
  {20,  2}, // #87
  {21,  1}, // #88
  {22,  2}, // #89
  {23,  3}, // #90
  { 3,  2}, // #91
  {11,  2}, // #92
  {12,  2}, // #93
  {13,  2}, // #94
  {14,  2}, // #95
  {19,  2}, // #96
  {20,  2}, // #97
  {22,  2}, // #98
  {23,  2}, // #99
  { 3,  3}, // #100
  { 8,  6}, // #101
  {11,  3}, // #102
  {12,  3}, // #103
  {13,  9}, // #104
  {14,  3}, // #105
  {15,  6}, // #106
  {17,  1}, // #107
  {18,  6}, // #108
  {19, 10}, // #109
  {20,  9}, // #110
  {21,  1}, // #111
  {22, 10}, // #112
  {23, 11}, // #113
  { 3,  3}, // #114
  { 8,  6}, // #115
  {11,  3}, // #116
  {12,  3}, // #117
  {13,  9}, // #118
  {14,  3}, // #119
  {15,  6}, // #120
  {18,  6}, // #121
  {19, 11}, // #122
  {20,  9}, // #123
  {22, 11}, // #124
  {23, 11}, // #125
  {14,  1}, // #126
  {15,  1}, // #127
  {17,  1}, // #128
  {19,  1}, // #129
  {20,  1}, // #130
  {21,  1}, // #131
  {22,  2}, // #132
  {23,  3}, // #133
  {14,  1}, // #134
  {15,  1}, // #135
  {19,  1}, // #136
  {20,  1}, // #137
  {22,  2}, // #138
  {23,  2}, // #139
  {17,  1}, // #140
  {19,  2}, // #141
  {21,  1}, // #142
  {22,  2}, // #143
  {23,  3}, // #144
  {19,  2}, // #145
  {22,  2}, // #146
  {23,  2}, // #147
  {15,  1}, // #148
  {17,  1}, // #149
  {19,  1}, // #150
  {21,  1}, // #151
  {22,  1}, // #152
  {23,  2}, // #153
  {15,  1}, // #154
  {19,  1}, // #155
  {22,  1}, // #156
  {23,  1}, // #157
  { 4,  1}, // #158
  {11,  1}, // #159
  {15,  1}, // #160
  {16,  1}, // #161
  {17,  1}, // #162
  {19,  1}, // #163
  {21,  1}, // #164
  {22,  1}, // #165
  {23,  2}, // #166
  { 7,  1}, // #167
  {12,  1}, // #168
  {14,  1}, // #169
  {17,  1}, // #170
  {20,  1}, // #171
  {21,  2}, // #172
  {22,  1}, // #173
  {23,  4}, // #174
  {14,  2}, // #175
  {20,  2}, // #176
  {22,  5}, // #177
  {23,  5}, // #178
  { 1, 10}, // #179
  { 3,  1}, // #180
  {11,  1}, // #181
  {12,  1}, // #182
  {13,  1}, // #183
  {14,  1}, // #184
  {17,  1}, // #185
  {19,  1}, // #186
  {20,  1}, // #187
  {21,  1}, // #188
  {22,  1}, // #189
  {23,  2}, // #190
  { 3,  7}, // #191
  { 4,  2}, // #192
  { 8,  8}, // #193
  { 9,  3}, // #194
  {11,  9}, // #195
  {12,  7}, // #196
  {13, 16}, // #197
  {14, 10}, // #198
  {15, 10}, // #199
  {16,  5}, // #200
  {18, 11}, // #201
  {19, 18}, // #202
  {20, 19}, // #203
  {22, 32}, // #204
  {23, 32}, // #205
  { 1, 10}, // #206
  { 3,  1}, // #207
  {11,  1}, // #208
  {12,  1}, // #209
  {13,  1}, // #210
  {14,  1}, // #211
  {19,  1}, // #212
  {20,  1}, // #213
  {22,  1}, // #214
  {23,  1}, // #215
  { 2,  4}, // #216
  { 3,  1}, // #217
  {11,  1}, // #218
  {12,  1}, // #219
  {13,  1}, // #220
  {14,  1}, // #221
  {17,  1}, // #222
  {19,  1}, // #223
  {20,  1}, // #224
  {21,  1}, // #225
  {22,  1}, // #226
  {23,  2}, // #227
  { 2,  3}, // #228
  { 3,  1}, // #229
  {11,  1}, // #230
  {12,  1}, // #231
  {13,  1}, // #232
  {14,  1}, // #233
  {19,  1}, // #234
  {20,  1}, // #235
  {22,  1}, // #236
  {23,  1}, // #237
  { 2,  5}, // #238
  { 3,  1}, // #239
  {11,  1}, // #240
  {12,  1}, // #241
  {13,  1}, // #242
  {14,  1}, // #243
  {17,  1}, // #244
  {19,  1}, // #245
  {20,  1}, // #246
  {21,  1}, // #247
  {22,  1}, // #248
  {23,  2}, // #249
  { 2,  3}, // #250
  { 3,  1}, // #251
  {11,  1}, // #252
  {12,  1}, // #253
  {13,  1}, // #254
  {14,  1}, // #255
  {17,  1}, // #256
  {19,  1}, // #257
  {20,  1}, // #258
  {21,  1}, // #259
  {22,  1}, // #260
  {23,  2}, // #261
  { 8,  1}, // #262
  {11,  2}, // #263
  {13,  1}, // #264
  {15,  1}, // #265
  {17,  1}, // #266
  {18,  1}, // #267
  {19,  3}, // #268
  {20,  1}, // #269
  {21,  1}, // #270
  {22,  3}, // #271
  {23,  4}, // #272
  { 8,  1}, // #273
  {11,  2}, // #274
  {13,  1}, // #275
  {15,  1}, // #276
  {18,  1}, // #277
  {19,  3}, // #278
  {20,  1}, // #279
  {22,  3}, // #280
  {23,  3}, // #281
  { 8,  1}, // #282
  {11,  3}, // #283
  {13,  1}, // #284
  {15,  1}, // #285
  {17,  1}, // #286
  {18,  1}, // #287
  {19,  4}, // #288
  {20,  1}, // #289
  {21,  1}, // #290
  {22,  4}, // #291
  {23,  5}, // #292
  { 8,  1}, // #293
  {11,  3}, // #294
  {13,  1}, // #295
  {15,  1}, // #296
  {18,  1}, // #297
  {19,  4}, // #298
  {20,  1}, // #299
  {22,  4}, // #300
  {23,  4}, // #301
  { 7,  1}, // #302
  { 8,  1}, // #303
  {12,  1}, // #304
  {13,  1}, // #305
  {15,  1}, // #306
  {18,  1}, // #307
  {19,  1}, // #308
  {20,  1}, // #309
  {21,  1}, // #310
  {22,  1}, // #311
  {23,  3}, // #312
  { 3,  1}, // #313
  { 8,  1}, // #314
  {11,  1}, // #315
  {12,  1}, // #316
  {13,  2}, // #317
  {14,  1}, // #318
  {15,  1}, // #319
  {18,  1}, // #320
  {19,  2}, // #321
  {20,  2}, // #322
  {22,  2}, // #323
  {23,  2}, // #324
  {13,  9}, // #325
  {19,  9}, // #326
  {20,  9}, // #327
  {22, 10}, // #328
  {23, 10}, // #329
  {13,  2}, // #330
  {19,  2}, // #331
  {20,  2}, // #332
  {22,  2}, // #333
  {23,  2}, // #334
  { 8,  2}, // #335
  {11,  1}, // #336
  {13,  2}, // #337
  {15,  2}, // #338
  {17,  1}, // #339
  {18,  2}, // #340
  {19,  3}, // #341
  {20,  2}, // #342
  {21,  1}, // #343
  {22,  3}, // #344
  {23,  4}, // #345
  { 8,  2}, // #346
  {11,  1}, // #347
  {13,  2}, // #348
  {15,  2}, // #349
  {18,  2}, // #350
  {19,  3}, // #351
  {20,  2}, // #352
  {22,  3}, // #353
  {23,  3}, // #354
  { 3,  2}, // #355
  { 8,  4}, // #356
  {11,  2}, // #357
  {12,  2}, // #358
  {13,  6}, // #359
  {14,  2}, // #360
  {15,  4}, // #361
  {17,  1}, // #362
  {18,  4}, // #363
  {19,  6}, // #364
  {20,  6}, // #365
  {21,  1}, // #366
  {22,  7}, // #367
  {23,  8}, // #368
  { 3,  4}, // #369
  { 4,  2}, // #370
  { 8,  4}, // #371
  { 9,  8}, // #372
  {11,  6}, // #373
  {12,  4}, // #374
  {13,  8}, // #375
  {14, 26}, // #376
  {15,  6}, // #377
  {16, 10}, // #378
  {18, 12}, // #379
  {19, 10}, // #380
  {20, 30}, // #381
  {22, 66}, // #382
  {23, 66}, // #383
  { 4,  1}, // #384
  {11,  1}, // #385
  {14,  1}, // #386
  {15,  1}, // #387
  {16,  1}, // #388
  {17,  1}, // #389
  {19,  1}, // #390
  {20,  1}, // #391
  {21,  1}, // #392
  {22,  4}, // #393
  {23,  5}, // #394
  { 4,  1}, // #395
  {11,  1}, // #396
  {14,  1}, // #397
  {15,  1}, // #398
  {16,  1}, // #399
  {19,  1}, // #400
  {20,  1}, // #401
  {22,  4}, // #402
  {23,  4}, // #403
  { 4,  1}, // #404
  {11,  1}, // #405
  {15,  1}, // #406
  {16,  1}, // #407
  {17,  1}, // #408
  {19,  1}, // #409
  {21,  1}, // #410
  {22,  2}, // #411
  {23,  3}, // #412
  { 4,  1}, // #413
  {11,  1}, // #414
  {15,  1}, // #415
  {16,  1}, // #416
  {19,  1}, // #417
  {22,  2}, // #418
  {23,  2}, // #419
  { 4,  1}, // #420
  {11,  1}, // #421
  {14,  1}, // #422
  {15,  1}, // #423
  {16,  1}, // #424
  {17,  1}, // #425
  {19,  1}, // #426
  {20,  1}, // #427
  {21,  1}, // #428
  {22,  3}, // #429
  {23,  4}, // #430
  { 4,  1}, // #431
  {11,  1}, // #432
  {14,  1}, // #433
  {15,  1}, // #434
  {16,  1}, // #435
  {19,  1}, // #436
  {20,  1}, // #437
  {22,  3}, // #438
  {23,  3}, // #439
  { 4,  1}, // #440
  { 8,  1}, // #441
  {11,  1}, // #442
  {13,  1}, // #443
  {15,  2}, // #444
  {16,  1}, // #445
  {17,  1}, // #446
  {18,  1}, // #447
  {19,  2}, // #448
  {20,  1}, // #449
  {21,  1}, // #450
  {22,  2}, // #451
  {23,  3}, // #452
  { 4,  1}, // #453
  { 8,  1}, // #454
  {11,  1}, // #455
  {13,  1}, // #456
  {15,  2}, // #457
  {16,  1}, // #458
  {18,  1}, // #459
  {19,  2}, // #460
  {20,  1}, // #461
  {22,  2}, // #462
  {23,  2}, // #463
  { 8,  1}, // #464
  {13,  1}, // #465
  {15,  1}, // #466
  {17,  1}, // #467
  {18,  1}, // #468
  {19,  1}, // #469
  {20,  1}, // #470
  {21,  1}, // #471
  {22,  1}, // #472
  {23,  2}, // #473
  { 8,  1}, // #474
  {13,  1}, // #475
  {15,  1}, // #476
  {18,  1}, // #477
  {19,  1}, // #478
  {20,  1}, // #479
  {22,  1}, // #480
  {23,  1}, // #481
  { 3,  1}, // #482
  {11,  1}, // #483
  {12,  1}, // #484
  {13,  1}, // #485
  {14,  1}, // #486
  {17,  1}, // #487
  {19,  1}, // #488
  {20,  1}, // #489
  {21,  1}, // #490
  {22,  2}, // #491
  {23,  3}, // #492
  { 7,  1}, // #493
  {12,  1}, // #494
  {17,  1}, // #495
  {21,  1}, // #496
  {23,  2}, // #497
  {13,  1}, // #498
  {17,  1}, // #499
  {19,  1}, // #500
  {20,  1}, // #501
  {21,  1}, // #502
  {22,  1}, // #503
  {23,  2}, // #504
  { 8,  2}, // #505
  {13,  3}, // #506
  {15,  2}, // #507
  {17,  1}, // #508
  {18,  2}, // #509
  {19,  3}, // #510
  {20,  3}, // #511
  {21,  1}, // #512
  {22,  3}, // #513
  {23,  4}, // #514
  { 8,  2}, // #515
  {13,  3}, // #516
  {15,  2}, // #517
  {18,  2}, // #518
  {19,  3}, // #519
  {20,  3}, // #520
  {22,  3}, // #521
  {23,  3}, // #522
  { 8,  2}, // #523
  {13,  2}, // #524
  {15,  2}, // #525
  {18,  2}, // #526
  {19,  2}, // #527
  {20,  2}, // #528
  {22,  2}, // #529
  {23,  2}, // #530
  { 8,  2}, // #531
  {13,  2}, // #532
  {15,  2}, // #533
  {17,  1}, // #534
  {18,  2}, // #535
  {19,  2}, // #536
  {20,  2}, // #537
  {21,  1}, // #538
  {22,  2}, // #539
  {23,  3}, // #540
  { 3,  4}, // #541
  { 8,  3}, // #542
  {11,  4}, // #543
  {12,  4}, // #544
  {13,  7}, // #545
  {14,  4}, // #546
  {15,  3}, // #547
  {17,  1}, // #548
  {18,  3}, // #549
  {19,  7}, // #550
  {20,  7}, // #551
  {21,  1}, // #552
  {22,  8}, // #553
  {23,  9}, // #554
  { 3,  4}, // #555
  { 8,  3}, // #556
  {11,  4}, // #557
  {12,  4}, // #558
  {13,  7}, // #559
  {14,  4}, // #560
  {15,  3}, // #561
  {18,  3}, // #562
  {19,  7}, // #563
  {20,  7}, // #564
  {22,  8}, // #565
  {23,  8}, // #566
  { 3,  4}, // #567
  { 8,  3}, // #568
  {11,  4}, // #569
  {12,  4}, // #570
  {13,  7}, // #571
  {14,  4}, // #572
  {15,  3}, // #573
  {17,  1}, // #574
  {18,  3}, // #575
  {19,  8}, // #576
  {20,  7}, // #577
  {21,  1}, // #578
  {22,  9}, // #579
  {23, 10}, // #580
  { 3,  4}, // #581
  { 8,  3}, // #582
  {11,  4}, // #583
  {12,  4}, // #584
  {13,  7}, // #585
  {14,  4}, // #586
  {15,  3}, // #587
  {18,  3}, // #588
  {19,  8}, // #589
  {20,  7}, // #590
  {22,  9}, // #591
  {23,  9}, // #592
  { 3,  3}, // #593
  {11,  3}, // #594
  {12,  3}, // #595
  {13,  3}, // #596
  {14,  3}, // #597
  {17,  1}, // #598
  {19,  3}, // #599
  {20,  3}, // #600
  {21,  1}, // #601
  {22,  3}, // #602
  {23,  4}, // #603
  { 3,  3}, // #604
  {11,  3}, // #605
  {12,  3}, // #606
  {13,  3}, // #607
  {14,  3}, // #608
  {19,  3}, // #609
  {20,  3}, // #610
  {22,  3}, // #611
  {23,  3}, // #612
  { 8,  2}, // #613
  {13,  2}, // #614
  {15,  2}, // #615
  {17,  1}, // #616
  {18,  2}, // #617
  {19,  3}, // #618
  {20,  2}, // #619
  {21,  1}, // #620
  {22,  3}, // #621
  {23,  4}, // #622
  { 8,  2}, // #623
  {13,  2}, // #624
  {15,  2}, // #625
  {18,  2}, // #626
  {19,  3}, // #627
  {20,  2}, // #628
  {22,  3}, // #629
  {23,  3}, // #630
  {11,  2}, // #631
  {17,  1}, // #632
  {19,  2}, // #633
  {21,  1}, // #634
  {22,  2}, // #635
  {23,  3}, // #636
  {11,  2}, // #637
  {19,  2}, // #638
  {22,  2}, // #639
  {23,  2}, // #640
  { 7,  1}, // #641
  {12,  1}, // #642
  {17,  1}, // #643
  {21,  2}, // #644
  {23,  3}, // #645
  { 8,  1}, // #646
  {11,  1}, // #647
  {13,  1}, // #648
  {15,  1}, // #649
  {18,  1}, // #650
  {19,  2}, // #651
  {20,  1}, // #652
  {22,  2}, // #653
  {23,  2}, // #654
  { 3,  1}, // #655
  { 8,  1}, // #656
  {11,  1}, // #657
  {12,  1}, // #658
  {13,  2}, // #659
  {14,  1}, // #660
  {15,  1}, // #661
  {17,  1}, // #662
  {18,  1}, // #663
  {19,  2}, // #664
  {20,  2}, // #665
  {21,  1}, // #666
  {22,  2}, // #667
  {23,  3}, // #668
  { 7,  1}, // #669
  {12,  1}, // #670
  {14,  3}, // #671
  {17,  1}, // #672
  {20,  3}, // #673
  {21,  2}, // #674
  {22,  3}, // #675
  {23,  6}, // #676
  {14,  3}, // #677
  {20,  3}, // #678
  {22,  3}, // #679
  {23,  3}, // #680
  { 7,  1}, // #681
  {12,  1}, // #682
  {14,  1}, // #683
  {20,  1}, // #684
  {21,  1}, // #685
  {22,  1}, // #686
  {23,  3}, // #687
  { 4,  1}, // #688
  {11,  1}, // #689
  {14,  2}, // #690
  {15,  1}, // #691
  {16,  1}, // #692
  {17,  1}, // #693
  {19,  1}, // #694
  {20,  2}, // #695
  {21,  2}, // #696
  {22,  4}, // #697
  {23,  6}, // #698
  { 4,  1}, // #699
  {11,  1}, // #700
  {15,  1}, // #701
  {16,  1}, // #702
  {17,  1}, // #703
  {19,  1}, // #704
  {21,  2}, // #705
  {22,  2}, // #706
  {23,  4}, // #707
  { 4,  1}, // #708
  {11,  1}, // #709
  {14,  2}, // #710
  {15,  1}, // #711
  {16,  1}, // #712
  {19,  1}, // #713
  {20,  2}, // #714
  {22,  4}, // #715
  {23,  4}, // #716
  { 2,  6}, // #717
  { 3,  1}, // #718
  {11,  1}, // #719
  {12,  1}, // #720
  {13,  1}, // #721
  {14,  1}, // #722
  {17,  1}, // #723
  {19,  1}, // #724
  {20,  1}, // #725
  {21,  1}, // #726
  {22,  1}, // #727
  {23,  2}, // #728
  { 2,  6}, // #729
  { 3,  1}, // #730
  {11,  1}, // #731
  {12,  1}, // #732
  {13,  1}, // #733
  {14,  1}, // #734
  {19,  1}, // #735
  {20,  1}, // #736
  {22,  1}, // #737
  {23,  1}, // #738
  { 2,  7}, // #739
  { 3,  1}, // #740
  {11,  1}, // #741
  {12,  1}, // #742
  {13,  1}, // #743
  {14,  1}, // #744
  {19,  1}, // #745
  {20,  1}, // #746
  {22,  1}, // #747
  {23,  1}, // #748
  { 8,  1}, // #749
  {13,  1}, // #750
  {15,  1}, // #751
  {18,  1}, // #752
  {19,  2}, // #753
  {20,  1}, // #754
  {22,  2}, // #755
  {23,  2}, // #756
  { 7,  1}, // #757
  { 8,  1}, // #758
  {11,  1}, // #759
  {12,  1}, // #760
  {13,  1}, // #761
  {15,  1}, // #762
  {18,  1}, // #763
  {19,  2}, // #764
  {20,  1}, // #765
  {21,  1}, // #766
  {22,  2}, // #767
  {23,  4}, // #768
  { 2,  8}, // #769
  { 3,  1}, // #770
  {11,  1}, // #771
  {12,  1}, // #772
  {13,  1}, // #773
  {14,  1}, // #774
  {17,  1}, // #775
  {19,  1}, // #776
  {20,  1}, // #777
  {21,  1}, // #778
  {22,  1}, // #779
  {23,  2}, // #780
  { 2,  5}, // #781
  { 3,  1}, // #782
  {11,  1}, // #783
  {12,  1}, // #784
  {13,  1}, // #785
  {14,  1}, // #786
  {19,  1}, // #787
  {20,  1}, // #788
  {22,  1}, // #789
  {23,  1}, // #790
  { 3,  1}, // #791
  {11,  1}, // #792
  {12,  1}, // #793
  {13,  1}, // #794
  {14,  1}, // #795
  {19,  1}, // #796
  {20,  1}, // #797
  {21,  1}, // #798
  {22,  1}, // #799
  {23,  2}, // #800
  { 2, 12}, // #801
  { 3,  1}, // #802
  {11,  1}, // #803
  {12,  1}, // #804
  {13,  1}, // #805
  {14,  1}, // #806
  {17,  1}, // #807
  {19,  1}, // #808
  {20,  1}, // #809
  {21,  1}, // #810
  {22,  1}, // #811
  {23,  2}, // #812
  { 2, 12}, // #813
  { 3,  1}, // #814
  {11,  1}, // #815
  {12,  1}, // #816
  {13,  1}, // #817
  {14,  1}, // #818
  {19,  1}, // #819
  {20,  1}, // #820
  {22,  1}, // #821
  {23,  1}, // #822
  {14,  1}, // #823
  {17,  1}, // #824
  {20,  1}, // #825
  {21,  2}, // #826
  {22,  3}, // #827
  {23,  5}, // #828
  { 4,  2}, // #829
  {11,  2}, // #830
  {14,  4}, // #831
  {15,  3}, // #832
  {16,  2}, // #833
  {17,  1}, // #834
  {19,  3}, // #835
  {20,  4}, // #836
  {21,  2}, // #837
  {22,  9}, // #838
  {23, 11}, // #839
  { 3,  2}, // #840
  { 4,  1}, // #841
  { 8,  2}, // #842
  { 9,  4}, // #843
  {11,  3}, // #844
  {12,  2}, // #845
  {13,  6}, // #846
  {14,  6}, // #847
  {15,  3}, // #848
  {16,  5}, // #849
  {18,  6}, // #850
  {19,  7}, // #851
  {20, 10}, // #852
  {22, 15}, // #853
  {23, 15}, // #854
  { 3,  1}, // #855
  { 8,  1}, // #856
  {11,  2}, // #857
  {12,  1}, // #858
  {13,  2}, // #859
  {14,  1}, // #860
  {15,  1}, // #861
  {18,  1}, // #862
  {19,  3}, // #863
  {20,  2}, // #864
  {22,  3}, // #865
  {23,  3}, // #866
  { 3,  1}, // #867
  { 8,  1}, // #868
  {11,  2}, // #869
  {12,  1}, // #870
  {13,  2}, // #871
  {14,  1}, // #872
  {15,  1}, // #873
  {17,  1}, // #874
  {18,  1}, // #875
  {19,  3}, // #876
  {20,  2}, // #877
  {21,  1}, // #878
  {22,  3}, // #879
  {23,  4}, // #880
  {17,  1}, // #881
  {21,  1}, // #882
  {22,  2}, // #883
  {23,  3}, // #884
  { 9,  1}, // #885
  {14,  1}, // #886
  {16,  1}, // #887
  {18,  1}, // #888
  {20,  1}, // #889
  {22,  3}, // #890
  {23,  3}, // #891
  { 7,  1}, // #892
  { 9,  1}, // #893
  {12,  1}, // #894
  {14,  2}, // #895
  {16,  1}, // #896
  {17,  1}, // #897
  {18,  1}, // #898
  {20,  2}, // #899
  {21,  2}, // #900
  {22,  5}, // #901
  {23,  8}, // #902
  {14,  1}, // #903
  {20,  1}, // #904
  {22,  2}, // #905
  {23,  2}, // #906
  { 3,  1}, // #907
  {11,  1}, // #908
  {12,  1}, // #909
  {13,  2}, // #910
  {14,  1}, // #911
  {17,  1}, // #912
  {19,  2}, // #913
  {20,  2}, // #914
  {21,  1}, // #915
  {22,  2}, // #916
  {23,  3}, // #917
  {14,  2}, // #918
  {20,  2}, // #919
  {22, 11}, // #920
  {23, 11}, // #921
  { 7,  1}, // #922
  { 9,  1}, // #923
  {12,  1}, // #924
  {14,  1}, // #925
  {16,  1}, // #926
  {18,  1}, // #927
  {20,  1}, // #928
  {21,  1}, // #929
  {22,  1}, // #930
  {23,  3}, // #931
  { 9,  1}, // #932
  {14,  1}, // #933
  {16,  1}, // #934
  {18,  1}, // #935
  {20,  1}, // #936
  {22,  4}, // #937
  {23,  4}, // #938
  { 7,  1}, // #939
  {12,  1}, // #940
  {14,  4}, // #941
  {15,  2}, // #942
  {17,  1}, // #943
  {19,  2}, // #944
  {20,  4}, // #945
  {21,  2}, // #946
  {22, 11}, // #947
  {23, 14}, // #948
  { 9,  1}, // #949
  {14,  4}, // #950
  {15,  1}, // #951
  {16,  1}, // #952
  {18,  1}, // #953
  {19,  1}, // #954
  {20,  4}, // #955
  {22,  7}, // #956
  {23,  7}, // #957
  { 9,  1}, // #958
  {14,  1}, // #959
  {16,  1}, // #960
  {18,  1}, // #961
  {20,  1}, // #962
  {22,  6}, // #963
  {23,  6}, // #964
  { 3,  2}, // #965
  { 7,  1}, // #966
  { 8,  4}, // #967
  {11,  2}, // #968
  {12,  3}, // #969
  {13,  6}, // #970
  {14,  6}, // #971
  {15,  4}, // #972
  {17,  1}, // #973
  {18,  4}, // #974
  {19,  6}, // #975
  {20, 10}, // #976
  {21,  2}, // #977
  {22, 16}, // #978
  {23, 19}, // #979
  { 8,  2}, // #980
  {13,  2}, // #981
  {15,  2}, // #982
  {18,  2}, // #983
  {19,  2}, // #984
  {20,  2}, // #985
  {22, 22}, // #986
  {23, 22}, // #987
  { 8,  1}, // #988
  { 9,  2}, // #989
  {13,  1}, // #990
  {14,  2}, // #991
  {15,  1}, // #992
  {16,  2}, // #993
  {18,  3}, // #994
  {19,  1}, // #995
  {20,  3}, // #996
  {22, 10}, // #997
  {23, 10}, // #998
  { 7,  1}, // #999
  { 8,  1}, // #1000
  { 9,  1}, // #1001
  {12,  1}, // #1002
  {13,  1}, // #1003
  {14,  2}, // #1004
  {15,  1}, // #1005
  {16,  1}, // #1006
  {17,  1}, // #1007
  {18,  2}, // #1008
  {19,  1}, // #1009
  {20,  3}, // #1010
  {21,  2}, // #1011
  {22,  5}, // #1012
  {23,  8}, // #1013
  { 8,  6}, // #1014
  {13,  9}, // #1015
  {15,  6}, // #1016
  {18,  6}, // #1017
  {19,  9}, // #1018
  {20,  9}, // #1019
  {22, 15}, // #1020
  {23, 15}, // #1021
  { 8,  1}, // #1022
  { 9,  5}, // #1023
  {13,  1}, // #1024
  {14,  9}, // #1025
  {15,  1}, // #1026
  {16,  5}, // #1027
  {17,  2}, // #1028
  {18,  6}, // #1029
  {19,  1}, // #1030
  {20, 10}, // #1031
  {21,  3}, // #1032
  {22, 20}, // #1033
  {23, 23}, // #1034
  { 8,  1}, // #1035
  { 9,  5}, // #1036
  {13,  1}, // #1037
  {14,  9}, // #1038
  {15,  1}, // #1039
  {16,  5}, // #1040
  {17,  3}, // #1041
  {18,  6}, // #1042
  {19,  1}, // #1043
  {20, 10}, // #1044
  {21,  3}, // #1045
  {22, 20}, // #1046
  {23, 23}, // #1047
  { 8,  1}, // #1048
  { 9,  1}, // #1049
  {13,  1}, // #1050
  {14,  2}, // #1051
  {15,  1}, // #1052
  {16,  1}, // #1053
  {18,  2}, // #1054
  {19,  1}, // #1055
  {20,  3}, // #1056
  {22,  8}, // #1057
  {23,  8}, // #1058
  { 3,  4}, // #1059
  { 9,  2}, // #1060
  {11,  4}, // #1061
  {12,  4}, // #1062
  {13,  5}, // #1063
  {14,  8}, // #1064
  {15,  1}, // #1065
  {16,  2}, // #1066
  {17, 33}, // #1067
  {18,  2}, // #1068
  {19,  6}, // #1069
  {20,  9}, // #1070
  {21, 33}, // #1071
  {22, 57}, // #1072
  {23, 90}, // #1073
  { 9,  1}, // #1074
  {14,  1}, // #1075
  {16,  1}, // #1076
  {17,  1}, // #1077
  {18,  1}, // #1078
  {20,  1}, // #1079
  {21,  1}, // #1080
  {22,  2}, // #1081
  {23,  3}, // #1082
  { 3,  1}, // #1083
  {11,  1}, // #1084
  {12,  1}, // #1085
  {13,  1}, // #1086
  {14,  1}, // #1087
  {19,  1}, // #1088
  {20,  1}, // #1089
  {22,  2}, // #1090
  {23,  2}, // #1091
  {14,  1}, // #1092
  {20,  1}, // #1093
  {22,  3}, // #1094
  {23,  3}, // #1095
  { 4,  2}, // #1096
  {11,  2}, // #1097
  {14,  4}, // #1098
  {15,  2}, // #1099
  {16,  2}, // #1100
  {19,  2}, // #1101
  {20,  4}, // #1102
  {22,  8}, // #1103
  {23,  8}, // #1104
  { 4,  2}, // #1105
  {11,  2}, // #1106
  {14,  4}, // #1107
  {15,  3}, // #1108
  {16,  2}, // #1109
  {19,  3}, // #1110
  {20,  4}, // #1111
  {22, 10}, // #1112
  {23, 10}, // #1113
  { 7,  1}, // #1114
  {12,  1}, // #1115
  {21,  1}, // #1116
  {22,  1}, // #1117
  {23,  3}, // #1118
  { 7,  1}, // #1119
  {12,  1}, // #1120
  {14,  1}, // #1121
  {20,  1}, // #1122
  {21,  1}, // #1123
  {22,  2}, // #1124
  {23,  4}, // #1125
  { 7,  1}, // #1126
  { 9,  1}, // #1127
  {12,  1}, // #1128
  {14,  1}, // #1129
  {16,  1}, // #1130
  {18,  1}, // #1131
  {20,  1}, // #1132
  {21,  1}, // #1133
  {22,  2}, // #1134
  {23,  4}, // #1135
  { 7,  1}, // #1136
  {12,  1}, // #1137
  {21,  1}, // #1138
  {22,  4}, // #1139
  {23,  6}, // #1140
  { 9,  1}, // #1141
  {14,  1}, // #1142
  {16,  1}, // #1143
  {18,  1}, // #1144
  {20,  1}, // #1145
  {22,  2}, // #1146
  {23,  2}, // #1147
  { 9,  1}, // #1148
  {14,  1}, // #1149
  {16,  1}, // #1150
  {17,  1}, // #1151
  {18,  1}, // #1152
  {20,  1}, // #1153
  {21,  1}, // #1154
  {22,  1}, // #1155
  {23,  2}, // #1156
  { 3,  1}, // #1157
  { 7,  1}, // #1158
  {11,  1}, // #1159
  {12,  2}, // #1160
  {13,  1}, // #1161
  {14,  1}, // #1162
  {19,  1}, // #1163
  {20,  1}, // #1164
  {21,  1}, // #1165
  {22,  1}, // #1166
  {23,  3}, // #1167
  { 4,  1}, // #1168
  { 9,  1}, // #1169
  {11,  1}, // #1170
  {14,  2}, // #1171
  {15,  1}, // #1172
  {16,  2}, // #1173
  {18,  1}, // #1174
  {19,  1}, // #1175
  {20,  2}, // #1176
  {22,  4}, // #1177
  {23,  4}, // #1178
  { 7,  1}, // #1179
  { 9,  1}, // #1180
  {12,  1}, // #1181
  {14,  1}, // #1182
  {16,  1}, // #1183
  {17,  1}, // #1184
  {18,  1}, // #1185
  {20,  1}, // #1186
  {21,  2}, // #1187
  {22,  2}, // #1188
  {23,  5}, // #1189
  { 7,  1}, // #1190
  {12,  1}, // #1191
  {14,  2}, // #1192
  {17,  1}, // #1193
  {20,  2}, // #1194
  {21,  2}, // #1195
  {22,  2}, // #1196
  {23,  5}, // #1197
  { 7,  1}, // #1198
  {12,  1}, // #1199
  {17,  1}, // #1200
  {21,  2}, // #1201
  {22,  2}, // #1202
  {23,  5}, // #1203
  { 3,  1}, // #1204
  {11,  2}, // #1205
  {12,  1}, // #1206
  {13,  1}, // #1207
  {14,  1}, // #1208
  {17,  1}, // #1209
  {19,  2}, // #1210
  {20,  1}, // #1211
  {21,  1}, // #1212
  {22,  2}, // #1213
  {23,  3}, // #1214
  {22, 16}, // #1215
  {23, 16}, // #1216
  { 9,  1}, // #1217
  {14,  1}, // #1218
  {16,  1}, // #1219
  {18,  1}, // #1220
  {20,  1}, // #1221
  {22,  1}, // #1222
  {23,  1}, // #1223
  { 7,  1}, // #1224
  {12,  1}, // #1225
  {15,  1}, // #1226
  {19,  1}, // #1227
  {21,  1}, // #1228
  {22,  1}, // #1229
  {23,  3}, // #1230
  {14,  2}, // #1231
  {20,  2}, // #1232
  {22,  2}, // #1233
  {23,  2}, // #1234
  { 8,  2}, // #1235
  {13,  2}, // #1236
  {15,  2}, // #1237
  {18,  2}, // #1238
  {19,  2}, // #1239
  {20,  2}, // #1240
  {22,  3}, // #1241
  {23,  3}, // #1242
  { 3,  1}, // #1243
  {11,  2}, // #1244
  {12,  1}, // #1245
  {13,  1}, // #1246
  {14,  1}, // #1247
  {19,  2}, // #1248
  {20,  1}, // #1249
  {22,  2}, // #1250
  {23,  2}, // #1251
  { 8,  1}, // #1252
  {11,  1}, // #1253
  {13,  1}, // #1254
  {15,  1}, // #1255
  {17,  1}, // #1256
  {18,  1}, // #1257
  {19,  2}, // #1258
  {20,  1}, // #1259
  {21,  1}, // #1260
  {22,  2}, // #1261
  {23,  3}, // #1262
  { 4,  1}, // #1263
  { 9,  1}, // #1264
  {11,  1}, // #1265
  {14,  1}, // #1266
  {15,  1}, // #1267
  {16,  2}, // #1268
  {18,  1}, // #1269
  {19,  1}, // #1270
  {20,  1}, // #1271
  {22,  4}, // #1272
  {23,  4}, // #1273
  { 4,  1}, // #1274
  { 9,  2}, // #1275
  {11,  1}, // #1276
  {14,  2}, // #1277
  {15,  1}, // #1278
  {16,  3}, // #1279
  {17,  1}, // #1280
  {18,  2}, // #1281
  {19,  1}, // #1282
  {20,  2}, // #1283
  {21,  1}, // #1284
  {22,  4}, // #1285
  {23,  5}, // #1286
  { 4,  1}, // #1287
  { 9,  1}, // #1288
  {11,  1}, // #1289
  {14,  2}, // #1290
  {15,  1}, // #1291
  {16,  2}, // #1292
  {18,  1}, // #1293
  {19,  1}, // #1294
  {20,  2}, // #1295
  {22,  3}, // #1296
  {23,  3}, // #1297
  {14,  1}, // #1298
  {20,  1}, // #1299
  {22,  5}, // #1300
  {23,  5}, // #1301
  { 4,  1}, // #1302
  {11,  1}, // #1303
  {14,  5}, // #1304
  {15,  2}, // #1305
  {16,  1}, // #1306
  {17,  1}, // #1307
  {19,  2}, // #1308
  {20,  5}, // #1309
  {21,  2}, // #1310
  {22,  8}, // #1311
  {23, 10}, // #1312
  { 4,  2}, // #1313
  {11,  2}, // #1314
  {14,  3}, // #1315
  {15,  2}, // #1316
  {16,  2}, // #1317
  {19,  2}, // #1318
  {20,  3}, // #1319
  {22,  7}, // #1320
  {23,  7}, // #1321
  { 4,  1}, // #1322
  {11,  1}, // #1323
  {14,  5}, // #1324
  {15,  2}, // #1325
  {16,  1}, // #1326
  {19,  2}, // #1327
  {20,  5}, // #1328
  {22,  9}, // #1329
  {23,  9}, // #1330
  { 4,  1}, // #1331
  { 9,  8}, // #1332
  {11,  1}, // #1333
  {14,  8}, // #1334
  {15,  1}, // #1335
  {16,  9}, // #1336
  {17,  1}, // #1337
  {18,  8}, // #1338
  {19,  1}, // #1339
  {20,  8}, // #1340
  {21,  1}, // #1341
  {22, 30}, // #1342
  {23, 31}, // #1343
  { 7,  1}, // #1344
  { 9, 10}, // #1345
  {12,  1}, // #1346
  {14, 10}, // #1347
  {16, 10}, // #1348
  {17,  1}, // #1349
  {18, 10}, // #1350
  {20, 10}, // #1351
  {21,  2}, // #1352
  {22, 36}, // #1353
  {23, 39}, // #1354
  { 7,  1}, // #1355
  { 9, 11}, // #1356
  {12,  1}, // #1357
  {14, 11}, // #1358
  {16, 11}, // #1359
  {17,  1}, // #1360
  {18, 11}, // #1361
  {20, 11}, // #1362
  {21,  2}, // #1363
  {22, 37}, // #1364
  {23, 40}, // #1365
  { 7,  1}, // #1366
  { 9, 11}, // #1367
  {12,  1}, // #1368
  {14, 11}, // #1369
  {16, 11}, // #1370
  {17,  1}, // #1371
  {18, 11}, // #1372
  {20, 11}, // #1373
  {21,  2}, // #1374
  {22, 41}, // #1375
  {23, 44}, // #1376
  { 4,  1}, // #1377
  { 7,  1}, // #1378
  { 8,  2}, // #1379
  { 9,  3}, // #1380
  {11,  1}, // #1381
  {12,  1}, // #1382
  {13,  2}, // #1383
  {14,  3}, // #1384
  {15,  4}, // #1385
  {16,  4}, // #1386
  {17,  1}, // #1387
  {18,  5}, // #1388
  {19,  4}, // #1389
  {20,  5}, // #1390
  {21,  2}, // #1391
  {22, 15}, // #1392
  {23, 18}, // #1393
  { 3,  2}, // #1394
  {11,  2}, // #1395
  {12,  2}, // #1396
  {13,  7}, // #1397
  {14, 12}, // #1398
  {17,  8}, // #1399
  {19,  7}, // #1400
  {20, 17}, // #1401
  {21,  8}, // #1402
  {22, 56}, // #1403
  {23, 64}, // #1404
  { 3,  4}, // #1405
  { 9,  4}, // #1406
  {11,  4}, // #1407
  {12,  4}, // #1408
  {13,  5}, // #1409
  {14, 10}, // #1410
  {15,  1}, // #1411
  {16,  4}, // #1412
  {17, 31}, // #1413
  {18,  4}, // #1414
  {19,  6}, // #1415
  {20, 11}, // #1416
  {21, 31}, // #1417
  {22, 57}, // #1418
  {23, 88}, // #1419
  { 3,  9}, // #1420
  { 4,  1}, // #1421
  { 7, 11}, // #1422
  { 8, 16}, // #1423
  { 9,  1}, // #1424
  {11, 10}, // #1425
  {12, 20}, // #1426
  {13, 25}, // #1427
  {14, 31}, // #1428
  {15, 17}, // #1429
  {16,  2}, // #1430
  {18, 17}, // #1431
  {19, 26}, // #1432
  {20, 47}, // #1433
  {21, 11}, // #1434
  {22, 78}, // #1435
  {23, 100}, // #1436
  { 3,  1}, // #1437
  { 8,  1}, // #1438
  {11,  1}, // #1439
  {12,  1}, // #1440
  {13,  2}, // #1441
  {14,  1}, // #1442
  {15,  1}, // #1443
  {17,  2}, // #1444
  {18,  1}, // #1445
  {19,  3}, // #1446
  {20,  2}, // #1447
  {21,  2}, // #1448
  {22,  3}, // #1449
  {23,  5}, // #1450
  { 3,  1}, // #1451
  { 8,  1}, // #1452
  {11,  1}, // #1453
  {12,  1}, // #1454
  {13,  2}, // #1455
  {14,  1}, // #1456
  {15,  1}, // #1457
  {17,  4}, // #1458
  {18,  1}, // #1459
  {19,  3}, // #1460
  {20,  2}, // #1461
  {21,  4}, // #1462
  {22,  3}, // #1463
  {23,  7}, // #1464
  { 3,  1}, // #1465
  { 8,  1}, // #1466
  {11,  1}, // #1467
  {12,  1}, // #1468
  {13,  2}, // #1469
  {14,  1}, // #1470
  {15,  1}, // #1471
  {17,  8}, // #1472
  {18,  1}, // #1473
  {19,  3}, // #1474
  {20,  2}, // #1475
  {21,  8}, // #1476
  {22,  3}, // #1477
  {23, 11}, // #1478
  { 3,  1}, // #1479
  { 8,  2}, // #1480
  {11,  1}, // #1481
  {12,  1}, // #1482
  {13,  3}, // #1483
  {14,  1}, // #1484
  {15,  2}, // #1485
  {18,  2}, // #1486
  {19,  3}, // #1487
  {20,  3}, // #1488
  {22,  3}, // #1489
  {23,  3}, // #1490
  { 3,  1}, // #1491
  { 8,  2}, // #1492
  {11,  1}, // #1493
  {12,  1}, // #1494
  {13,  3}, // #1495
  {14,  1}, // #1496
  {15,  2}, // #1497
  {17,  1}, // #1498
  {18,  2}, // #1499
  {19,  3}, // #1500
  {20,  3}, // #1501
  {21,  1}, // #1502
  {22,  3}, // #1503
  {23,  4}, // #1504
  {14,  2}, // #1505
  {17,  1}, // #1506
  {20,  2}, // #1507
  {21,  1}, // #1508
  {22,  2}, // #1509
  {23,  3}, // #1510
  { 7,  1}, // #1511
  {12,  1}, // #1512
  {14,  2}, // #1513
  {20,  2}, // #1514
  {21,  1}, // #1515
  {22,  2}, // #1516
  {23,  4}, // #1517
  { 2,  1}, // #1518
  { 3,  1}, // #1519
  { 1,  1}, // #1520
  { 3,  2}, // #1521
  { 1,  1}, // #1522
  { 3,  1}, // #1523
  { 1,  6}, // #1524
  { 2,  6}, // #1525
  { 3, 12}, // #1526
  { 1,  5}, // #1527
  { 2,  5}, // #1528
  { 3, 10}, // #1529
  { 1,  1}, // #1530
  { 2,  1}, // #1531
  { 3,  2}, // #1532
  { 1, 16}, // #1533
  { 2, 16}, // #1534
  { 3, 32}, // #1535
  { 3, 11}, // #1536
  { 3, 15}, // #1537
  { 1, 10}, // #1538
  { 2, 10}, // #1539
  { 3, 20}, // #1540
  { 1,  9}, // #1541
  { 2,  9}, // #1542
  { 3, 18}, // #1543
  { 1,  5}, // #1544
  { 3,  5}, // #1545
  { 1,  7}, // #1546
  { 2,  7}, // #1547
  { 3, 14}, // #1548
  { 1,  8}, // #1549
  { 2,  8}, // #1550
  { 3, 16}, // #1551
  { 1, 12}, // #1552
  { 2, 12}, // #1553
  { 3, 24}, // #1554
  { 1, 11}, // #1555
  { 2, 11}, // #1556
  { 3, 22}, // #1557
  { 1, 50}, // #1558
  { 2, 50}, // #1559
  { 3, 100}, // #1560
  { 1, 130}, // #1561
  { 2, 130}, // #1562
  { 3, 260}, // #1563
  { 1, 68}, // #1564
  { 2, 68}, // #1565
  { 3, 136}, // #1566
  { 1, 125}, // #1567
  { 2, 125}, // #1568
  { 3, 250}, // #1569
  { 1, 70}, // #1570
  { 2, 70}, // #1571
  { 3, 140}, // #1572
  { 1, 34}, // #1573
  { 2, 34}, // #1574
  { 3, 68}, // #1575
  { 1, 62}, // #1576
  { 2, 62}, // #1577
  { 3, 124}, // #1578
  { 1, 14}, // #1579
  { 2, 14}, // #1580
  { 3, 28}, // #1581
  { 3,  6}, // #1582
  { 1,  3}, // #1583
  { 3,  3}, // #1584
  { 1,  4}, // #1585
  { 2,  4}, // #1586
  { 3,  8}, // #1587
  { 1,  3}, // #1588
  { 2,  3}, // #1589
  { 3,  6}, // #1590
  { 1,  2}, // #1591
  { 2,  2}, // #1592
  { 3,  4}, // #1593
  { 1,  2}, // #1594
  { 3,  2}, // #1595
  { 1,  4}, // #1596
  { 3,  4}, // #1597
  { 1, 71}, // #1598
  { 3, 71}, // #1599
  { 1, 15}, // #1600
  { 2, 15}, // #1601
  { 3, 30}, // #1602
  { 2,  5}, // #1603
  { 3,  5}, // #1604
  { 3, 13}, // #1605
  { 3, 17}, // #1606
  { 3, 21}, // #1607
  { 3, 23}, // #1608
  { 3, 25}, // #1609
  { 3, 26}, // #1610
  { 3, 29}, // #1611
  { 3, 45}, // #1612
  { 3, 46}, // #1613
  { 3, 48}, // #1614
  { 3, 55}, // #1615
  { 3, 59}, // #1616
  { 3, 63}, // #1617
  { 3, 72}, // #1618
  { 3, 74}, // #1619
  { 3, 77}, // #1620
  { 3, 78}, // #1621
  { 3, 79}, // #1622
  { 3, 92}, // #1623
  { 3, 94}, // #1624
  { 3, 99}, // #1625
  { 3, 121}, // #1626
  { 3, 127}, // #1627
  { 3, 130}, // #1628
  { 3, 141}, // #1629
  { 3, 146}, // #1630
  { 3, 147}, // #1631
  { 3, 168}, // #1632
  { 3, 174}, // #1633
  { 3, 183}, // #1634
  { 3, 202}, // #1635
  { 5,  2}, // #1636
  { 8,  2}, // #1637
  {11,  1}, // #1638
  {14,  1}, // #1639
  {19,  1}, // #1640
  { 2,  1}, // #1641
  { 5,  1}, // #1642
  { 7,  1}, // #1643
  { 8,  1}, // #1644
  { 1,  2}, // #1645
  { 5, 44}, // #1646
  { 7, 44}, // #1647
  { 8, 44}, // #1648
  {22,  1}, // #1649
  {24,  1}, // #1650
  { 1,  3}, // #1651
  { 2,  1}, // #1652
  { 5,  1}, // #1653
  { 7,  1}, // #1654
  { 8,  1}, // #1655
  {22,  3}, // #1656
  { 5,  1}, // #1657
  { 8,  1}, // #1658
  { 5,  6}, // #1659
  { 8,  6}, // #1660
  { 1,  1}, // #1661
  {13,  1}, // #1662
  {14,  3}, // #1663
  {20,  3}, // #1664
  {24,  1}, // #1665
  { 1,  3}, // #1666
  {10,  3}, // #1667
  {14,  1}, // #1668
  {19,  1}, // #1669
  {22,  3}, // #1670
  { 1,  1}, // #1671
  {13,  2}, // #1672
  {14, 36}, // #1673
  {20, 36}, // #1674
  {24,  1}, // #1675
  {10,  4}, // #1676
  {14,  1}, // #1677
  {16,  1}, // #1678
  {19,  1}, // #1679
  { 1,  4}, // #1680
  { 5,  2}, // #1681
  { 8,  2}, // #1682
  {22,  3}, // #1683
  {24,  1}, // #1684
  { 1,  3}, // #1685
  { 5,  2}, // #1686
  { 8,  2}, // #1687
  {22,  3}, // #1688
  { 1,  3}, // #1689
  {10,  1}, // #1690
  {14,  1}, // #1691
  {15,  1}, // #1692
  {19,  1}, // #1693
  {22,  3}, // #1694
  { 1,  3}, // #1695
  {12,  1}, // #1696
  {14,  1}, // #1697
  {15,  1}, // #1698
  {19,  1}, // #1699
  {22,  3}, // #1700
  { 1,  3}, // #1701
  {10,  2}, // #1702
  {14,  1}, // #1703
  {19,  1}, // #1704
  {22,  3}, // #1705
  { 1,  3}, // #1706
  { 5,  6}, // #1707
  { 8,  6}, // #1708
  {22,  3}, // #1709
  { 1,  3}, // #1710
  { 5,  8}, // #1711
  { 8,  8}, // #1712
  {22,  3}, // #1713
  { 1,  2}, // #1714
  { 5,  7}, // #1715
  { 8,  7}, // #1716
  {22,  2}, // #1717
  { 1,  1}, // #1718
  { 5, 42}, // #1719
  { 8, 42}, // #1720
  {22,  1}, // #1721
  { 1,  1}, // #1722
  { 5, 44}, // #1723
  { 8, 44}, // #1724
  {22,  1}, // #1725
  { 1,  3}, // #1726
  { 5,  1}, // #1727
  { 8,  1}, // #1728
  {22,  3}, // #1729
  { 1,  2}, // #1730
  {22,  2}, // #1731
  { 5,  3}, // #1732
  { 7,  3}, // #1733
  { 8,  3}, // #1734
  { 1,  3}, // #1735
  { 5,  1}, // #1736
  { 6,  1}, // #1737
  { 8,  1}, // #1738
  {10,  1}, // #1739
  {14,  1}, // #1740
  {15,  1}, // #1741
  {19,  1}, // #1742
  {22,  3}, // #1743
  { 1,  3}, // #1744
  { 5,  4}, // #1745
  { 8,  4}, // #1746
  {22,  3}, // #1747
  { 1,  3}, // #1748
  { 9,  1}, // #1749
  {13,  1}, // #1750
  {14,  1}, // #1751
  {15,  1}, // #1752
  {19,  1}, // #1753
  {22,  3}, // #1754
  { 1,  3}, // #1755
  { 5,  1}, // #1756
  { 6,  1}, // #1757
  { 8,  1}, // #1758
  { 9,  1}, // #1759
  {10,  1}, // #1760
  {13,  1}, // #1761
  {14,  1}, // #1762
  {15,  1}, // #1763
  {19,  1}, // #1764
  {22,  3}, // #1765
  { 1,  3}, // #1766
  { 9,  2}, // #1767
  {13,  1}, // #1768
  {14,  1}, // #1769
  {15,  1}, // #1770
  {19,  1}, // #1771
  {22,  3}, // #1772
  { 1,  3}, // #1773
  { 4, 15}, // #1774
  { 5,  1}, // #1775
  { 7,  1}, // #1776
  { 8,  1}, // #1777
  {22,  3}, // #1778
  { 1,  3}, // #1779
  { 4, 14}, // #1780
  { 5,  1}, // #1781
  { 7,  1}, // #1782
  { 8,  1}, // #1783
  {22,  3}, // #1784
  { 1,  3}, // #1785
  { 4, 12}, // #1786
  { 5,  1}, // #1787
  { 7,  1}, // #1788
  { 8,  1}, // #1789
  {22,  3}, // #1790
  { 1,  3}, // #1791
  {10,  9}, // #1792
  {14,  1}, // #1793
  {16,  1}, // #1794
  {19,  1}, // #1795
  {22,  3}, // #1796
  { 1,  3}, // #1797
  {10, 10}, // #1798
  {14,  1}, // #1799
  {16,  1}, // #1800
  {19,  1}, // #1801
  {22,  3}, // #1802
  { 1,  3}, // #1803
  {10, 14}, // #1804
  {14,  1}, // #1805
  {16,  1}, // #1806
  {19,  1}, // #1807
  {22,  3}, // #1808
  { 1,  1}, // #1809
  {24,  1}, // #1810
  { 1,  1}, // #1811
  {13,  1}, // #1812
  {14,  2}, // #1813
  {16,  2}, // #1814
  {19,  2}, // #1815
  {24,  1}, // #1816
  { 5,  1}, // #1817
  { 6,  1}, // #1818
  { 8,  1}, // #1819
  {10,  3}, // #1820
  {14,  1}, // #1821
  {15,  1}, // #1822
  {19,  1}, // #1823
  {11,  2}, // #1824
  {14,  1}, // #1825
  {19,  1}, // #1826
  {10,  1}, // #1827
  {14,  1}, // #1828
  {19,  1}, // #1829
  {13,  1}, // #1830
  {14,  1}, // #1831
  {16,  1}, // #1832
  {19,  1}, // #1833
  { 1,  3}, // #1834
  {11,  2}, // #1835
  {14,  1}, // #1836
  {19,  1}, // #1837
  {22,  3}, // #1838
  { 1,  3}, // #1839
  {10,  5}, // #1840
  {14,  1}, // #1841
  {15,  1}, // #1842
  {19,  1}, // #1843
  {22,  3}, // #1844
  { 1,  3}, // #1845
  { 4, 17}, // #1846
  { 5,  1}, // #1847
  { 7,  1}, // #1848
  { 8,  1}, // #1849
  {22,  3}, // #1850
  { 1,  3}, // #1851
  { 4, 25}, // #1852
  { 5,  1}, // #1853
  { 7,  1}, // #1854
  { 8,  1}, // #1855
  {22,  3}, // #1856
  { 1,  3}, // #1857
  { 5,  1}, // #1858
  { 7,  1}, // #1859
  { 8,  1}, // #1860
  {22,  3}, // #1861
  {23,  5}, // #1862
  { 5,  1}, // #1863
  { 7,  1}, // #1864
  { 8,  1}, // #1865
  {23,  5}, // #1866
  { 1,  3}, // #1867
  { 5,  1}, // #1868
  { 7,  1}, // #1869
  { 8,  1}, // #1870
  {22,  3}, // #1871
  {23,  2}, // #1872
  { 5,  1}, // #1873
  { 7,  1}, // #1874
  { 8,  1}, // #1875
  {23,  2}, // #1876
  { 1,  3}, // #1877
  { 5,  1}, // #1878
  { 7,  1}, // #1879
  { 8,  1}, // #1880
  {22,  3}, // #1881
  {23,  4}, // #1882
  { 5,  1}, // #1883
  { 7,  1}, // #1884
  { 8,  1}, // #1885
  {23,  4}, // #1886
  { 1,  3}, // #1887
  { 5,  1}, // #1888
  { 7,  1}, // #1889
  { 8,  1}, // #1890
  {22,  3}, // #1891
  {23,  6}, // #1892
  { 5,  1}, // #1893
  { 7,  1}, // #1894
  { 8,  1}, // #1895
  {23,  6}, // #1896
  { 1,  3}, // #1897
  {11,  3}, // #1898
  {14,  1}, // #1899
  {19,  1}, // #1900
  {22,  3}, // #1901
  { 1,  1}, // #1902
  {22,  1}, // #1903
  { 1,  3}, // #1904
  { 5,  2}, // #1905
  { 6,  2}, // #1906
  { 8,  2}, // #1907
  {22,  3}, // #1908
  { 1,  1}, // #1909
  {13,  1}, // #1910
  {14,  1}, // #1911
  {16,  1}, // #1912
  {19,  1}, // #1913
  {24,  1}, // #1914
  { 1,  3}, // #1915
  {11,  1}, // #1916
  {14,  1}, // #1917
  {19,  1}, // #1918
  {22,  3}, // #1919
  { 1,  3}, // #1920
  {11,  4}, // #1921
  {14,  1}, // #1922
  {19,  1}, // #1923
  {22,  3}, // #1924
  { 1,  3}, // #1925
  {12,  4}, // #1926
  {14,  1}, // #1927
  {15,  1}, // #1928
  {19,  1}, // #1929
  {22,  3}, // #1930
  { 1,  3}, // #1931
  {10,  1}, // #1932
  {14,  1}, // #1933
  {16,  1}, // #1934
  {19,  1}, // #1935
  {22,  3}, // #1936
  { 1,  3}, // #1937
  {12,  7}, // #1938
  {14,  1}, // #1939
  {15,  1}, // #1940
  {19,  1}, // #1941
  {22,  3}, // #1942
  { 1, 23}, // #1943
  { 5,  1}, // #1944
  { 6,  1}, // #1945
  { 8,  1}, // #1946
  {10,  1}, // #1947
  {11, 10}, // #1948
  {14,  1}, // #1949
  {16,  1}, // #1950
  {19,  1}, // #1951
  {22, 13}, // #1952
  {24, 10}, // #1953
  { 1, 20}, // #1954
  { 5,  1}, // #1955
  { 6,  1}, // #1956
  { 8,  1}, // #1957
  {10,  1}, // #1958
  {11, 10}, // #1959
  {14,  1}, // #1960
  {16,  1}, // #1961
  {19,  1}, // #1962
  {22, 10}, // #1963
  {24, 10}, // #1964
  { 1,  3}, // #1965
  { 5,  1}, // #1966
  { 6,  1}, // #1967
  { 8,  1}, // #1968
  {10,  6}, // #1969
  {14,  1}, // #1970
  {16,  1}, // #1971
  {19,  1}, // #1972
  {22,  3}, // #1973
  { 1,  3}, // #1974
  { 5,  1}, // #1975
  { 6,  1}, // #1976
  { 8,  1}, // #1977
  {10,  8}, // #1978
  {14,  1}, // #1979
  {16,  1}, // #1980
  {19,  1}, // #1981
  {22,  3}, // #1982
  { 1,  3}, // #1983
  {11,  1}, // #1984
  {14,  1}, // #1985
  {15,  1}, // #1986
  {19,  1}, // #1987
  {22,  3}, // #1988
  { 1,  3}, // #1989
  {11,  1}, // #1990
  {12,  2}, // #1991
  {14,  3}, // #1992
  {15,  2}, // #1993
  {19,  3}, // #1994
  {22,  3}, // #1995
  { 1,  3}, // #1996
  {22,  2}, // #1997
  {24,  1}, // #1998
  { 1,  4}, // #1999
  { 5,  1}, // #2000
  { 8,  1}, // #2001
  {22,  3}, // #2002
  {24,  1}, // #2003
  { 1,  3}, // #2004
  {13,  1}, // #2005
  {14,  1}, // #2006
  {16,  1}, // #2007
  {19,  1}, // #2008
  {22,  3}, // #2009
  { 1,  3}, // #2010
  {10,  2}, // #2011
  {14,  1}, // #2012
  {16,  1}, // #2013
  {19,  1}, // #2014
  {22,  3}, // #2015
  { 1,  1}, // #2016
  { 5,  1}, // #2017
  { 8,  1}, // #2018
  {24,  1}, // #2019
  { 1,  1}, // #2020
  { 5, 22}, // #2021
  { 8, 22}, // #2022
  {22,  1}, // #2023
  {10, 18}, // #2024
  {14,  1}, // #2025
  {16,  1}, // #2026
  {19,  1}, // #2027
  { 1, 18}, // #2028
  {24, 18}, // #2029
  { 1,  3}, // #2030
  {10,  3}, // #2031
  {14,  1}, // #2032
  {22,  3}, // #2033
  { 1,  3}, // #2034
  {10,  2}, // #2035
  {14,  1}, // #2036
  {15,  1}, // #2037
  {19,  1}, // #2038
  {22,  3}, // #2039
  { 1,  3}, // #2040
  {10,  2}, // #2041
  {14,  2}, // #2042
  {19,  2}, // #2043
  {22,  3}, // #2044
  { 1,  3}, // #2045
  {10,  4}, // #2046
  {14,  2}, // #2047
  {19,  2}, // #2048
  {22,  3}, // #2049
  { 1,  3}, // #2050
  {10,  3}, // #2051
  {14,  2}, // #2052
  {19,  2}, // #2053
  {22,  3}, // #2054
  { 1,  3}, // #2055
  { 9,  2}, // #2056
  {10,  1}, // #2057
  {13,  1}, // #2058
  {14,  1}, // #2059
  {15,  1}, // #2060
  {19,  1}, // #2061
  {22,  3}, // #2062
  { 1,  1}, // #2063
  { 9,  2}, // #2064
  {10,  1}, // #2065
  {13,  1}, // #2066
  {14,  1}, // #2067
  {15,  1}, // #2068
  {19,  1}, // #2069
  {24,  1}, // #2070
  { 1,  1}, // #2071
  { 9,  2}, // #2072
  {13,  1}, // #2073
  {14,  1}, // #2074
  {15,  1}, // #2075
  {19,  1}, // #2076
  {24,  1}, // #2077
  { 1,  3}, // #2078
  {10, 18}, // #2079
  {14,  2}, // #2080
  {16,  2}, // #2081
  {19,  2}, // #2082
  {22,  3}, // #2083
  { 1,  3}, // #2084
  {10, 25}, // #2085
  {14,  2}, // #2086
  {16,  2}, // #2087
  {19,  2}, // #2088
  {22,  3}, // #2089
  { 1,  3}, // #2090
  {13,  1}, // #2091
  {14,  2}, // #2092
  {16,  2}, // #2093
  {19,  2}, // #2094
  {22,  3}, // #2095
  { 1,  3}, // #2096
  {10,  8}, // #2097
  {14,  1}, // #2098
  {15,  1}, // #2099
  {19,  1}, // #2100
  {22,  3}, // #2101
  { 1,  3}, // #2102
  {11,  3}, // #2103
  {14,  2}, // #2104
  {19,  2}, // #2105
  {22,  3}, // #2106
  { 1,  2}, // #2107
  {10, 376}, // #2108
  {14,  2}, // #2109
  {19,  2}, // #2110
  {24,  2}, // #2111
  { 1,  1}, // #2112
  {10, 188}, // #2113
  {14,  1}, // #2114
  {19,  1}, // #2115
  {24,  1}, // #2116
  { 1,  3}, // #2117
  {10,  4}, // #2118
  {14,  1}, // #2119
  {19,  1}, // #2120
  {22,  3}, // #2121
  { 1,  2}, // #2122
  {13,  2}, // #2123
  {14, 36}, // #2124
  {20, 36}, // #2125
  {24,  2}, // #2126
  {11,  2}, // #2127
  {14,  2}, // #2128
  {19,  2}, // #2129
  { 1,  3}, // #2130
  {11,  4}, // #2131
  {14,  2}, // #2132
  {19,  2}, // #2133
  {22,  3}, // #2134
  { 1,  2}, // #2135
  {13,  2}, // #2136
  {14,  2}, // #2137
  {16,  2}, // #2138
  {19,  2}, // #2139
  {24,  2}, // #2140
  { 1,  3}, // #2141
  { 5,  1}, // #2142
  { 6,  1}, // #2143
  { 8,  1}, // #2144
  {10,  4}, // #2145
  {14,  2}, // #2146
  {19,  2}, // #2147
  {22,  3}, // #2148
  { 1,  3}, // #2149
  {10,  1}, // #2150
  {14,  2}, // #2151
  {16,  2}, // #2152
  {19,  2}, // #2153
  {22,  3}, // #2154
  { 1,  3}, // #2155
  {10,  2}, // #2156
  {14,  2}, // #2157
  {16,  2}, // #2158
  {19,  2}, // #2159
  {22,  3}, // #2160
  { 1,  3}, // #2161
  { 5,  1}, // #2162
  { 6,  1}, // #2163
  { 8,  1}, // #2164
  {10,  4}, // #2165
  {14,  4}, // #2166
  {19,  4}, // #2167
  {22,  3}, // #2168
  { 9,  3}, // #2169
  {13,  1}, // #2170
  {14,  1}, // #2171
  {15,  1}, // #2172
  {19,  1}, // #2173
  { 5, 23}, // #2174
  { 7, 23}, // #2175
  { 8, 23}, // #2176
  { 5, 21}, // #2177
  { 7, 21}, // #2178
  { 8, 21}, // #2179
  { 5, 26}, // #2180
  { 7, 26}, // #2181
  { 8, 26}, // #2182
  { 5, 69}, // #2183
  { 7, 69}, // #2184
  { 8, 69}, // #2185
  { 5, 14}, // #2186
  { 8, 14}, // #2187
  { 5, 25}, // #2188
  { 8, 25}, // #2189
  { 1,  1}, // #2190
  {10,  4}, // #2191
  {14,  2}, // #2192
  {19,  2}, // #2193
  {22,  1}, // #2194
  { 5, 20}, // #2195
  { 7, 20}, // #2196
  { 8, 20}, // #2197
  { 1,  3}, // #2198
  {10, 10}, // #2199
  {14,  1}, // #2200
  {15,  1}, // #2201
  {19,  1}, // #2202
  {22,  3}, // #2203
  { 1,  3}, // #2204
  {10, 18}, // #2205
  {14,  1}, // #2206
  {15,  1}, // #2207
  {19,  1}, // #2208
  {22,  3}, // #2209
  { 5, 375}, // #2210
  { 8, 375}, // #2211
  { 5, 24}, // #2212
  { 8, 24}, // #2213
  {10,  6}, // #2214
  {14,  1}, // #2215
  {19,  1}, // #2216
  {10,  8}, // #2217
  {14,  1}, // #2218
  {19,  1}, // #2219
  { 5,  3}, // #2220
  { 8,  3}, // #2221
  { 5, 18}, // #2222
  { 8, 18}, // #2223
  { 5, 88}, // #2224
  { 8, 88}, // #2225
  { 1,  3}, // #2226
  { 5,  3}, // #2227
  { 8,  3}, // #2228
  {22,  3}, // #2229
  { 5, 10}, // #2230
  { 8, 10}, // #2231
  { 5, 12}, // #2232
  { 8, 12}, // #2233
  { 5, 17}, // #2234
  { 8, 17}, // #2235
  { 5,  5}, // #2236
  { 8,  5}, // #2237
  { 5, 23}, // #2238
  { 8, 23}, // #2239
  { 5, 20}, // #2240
  { 8, 20}, // #2241
  { 5, 19}, // #2242
  { 8, 19}, // #2243
  { 5, 13}, // #2244
  { 8, 13}, // #2245
  { 5, 21}, // #2246
  { 8, 21}, // #2247
  { 5, 15}, // #2248
  { 8, 15}, // #2249
  {13,  1}, // #2250
  {14, 10}, // #2251
  {16, 10}, // #2252
  {19, 10}, // #2253
  {13,  1}, // #2254
  {14,  3}, // #2255
  {16,  3}, // #2256
  {19,  3}, // #2257
  {13,  1}, // #2258
  {14,  4}, // #2259
  {16,  4}, // #2260
  {19,  4}, // #2261
  {11,  1}, // #2262
  {12,  1}, // #2263
  {14,  1}, // #2264
  {15,  1}, // #2265
  {19,  1}, // #2266
  { 3,  2}, // #2267
  { 8,  7}, // #2268
  {11,  2}, // #2269
  {12,  2}, // #2270
  {13,  9}, // #2271
  {14,  2}, // #2272
  {15,  7}, // #2273
  {17,  1}, // #2274
  {18,  7}, // #2275
  {19, 10}, // #2276
  {20,  9}, // #2277
  {21,  1}, // #2278
  {22, 10}, // #2279
  {23, 11}, // #2280
  { 3,  2}, // #2281
  { 8,  7}, // #2282
  {11,  2}, // #2283
  {12,  2}, // #2284
  {13,  9}, // #2285
  {14,  2}, // #2286
  {15,  7}, // #2287
  {18,  7}, // #2288
  {19, 11}, // #2289
  {20,  9}, // #2290
  {22, 11}, // #2291
  {23, 11}, // #2292
  { 3,  2}, // #2293
  { 4,  2}, // #2294
  { 8,  2}, // #2295
  {11,  4}, // #2296
  {12,  2}, // #2297
  {13,  4}, // #2298
  {14,  2}, // #2299
  {15,  4}, // #2300
  {16,  2}, // #2301
  {17,  1}, // #2302
  {18,  2}, // #2303
  {19,  6}, // #2304
  {20,  4}, // #2305
  {21,  1}, // #2306
  {22,  7}, // #2307
  {23,  8}, // #2308
  { 3,  7}, // #2309
  { 4,  7}, // #2310
  { 8,  3}, // #2311
  { 9,  3}, // #2312
  {11, 15}, // #2313
  {12,  7}, // #2314
  {13, 10}, // #2315
  {14, 10}, // #2316
  {15, 10}, // #2317
  {16, 10}, // #2318
  {18,  6}, // #2319
  {19, 18}, // #2320
  {20, 13}, // #2321
  {22, 32}, // #2322
  {23, 32}, // #2323
  { 2,  8}, // #2324
  { 3,  1}, // #2325
  {11,  1}, // #2326
  {12,  1}, // #2327
  {13,  1}, // #2328
  {14,  1}, // #2329
  {19,  1}, // #2330
  {20,  1}, // #2331
  {22,  1}, // #2332
  {23,  1}, // #2333
  { 2,  4}, // #2334
  { 3,  1}, // #2335
  {11,  1}, // #2336
  {12,  1}, // #2337
  {13,  1}, // #2338
  {14,  1}, // #2339
  {19,  1}, // #2340
  {20,  1}, // #2341
  {22,  1}, // #2342
  {23,  1}, // #2343
  { 3,  1}, // #2344
  { 4,  1}, // #2345
  { 8,  1}, // #2346
  {11,  2}, // #2347
  {12,  1}, // #2348
  {13,  2}, // #2349
  {14,  1}, // #2350
  {15,  2}, // #2351
  {16,  1}, // #2352
  {17,  1}, // #2353
  {18,  1}, // #2354
  {19,  3}, // #2355
  {20,  2}, // #2356
  {21,  1}, // #2357
  {22,  3}, // #2358
  {23,  4}, // #2359
  { 3,  1}, // #2360
  { 4,  1}, // #2361
  { 8,  1}, // #2362
  {11,  2}, // #2363
  {12,  1}, // #2364
  {13,  2}, // #2365
  {14,  1}, // #2366
  {15,  2}, // #2367
  {16,  1}, // #2368
  {18,  1}, // #2369
  {19,  3}, // #2370
  {20,  2}, // #2371
  {22,  3}, // #2372
  {23,  3}, // #2373
  { 3,  2}, // #2374
  { 4,  1}, // #2375
  { 8,  1}, // #2376
  {11,  3}, // #2377
  {12,  2}, // #2378
  {13,  3}, // #2379
  {14,  2}, // #2380
  {15,  2}, // #2381
  {16,  1}, // #2382
  {17,  1}, // #2383
  {18,  1}, // #2384
  {19,  4}, // #2385
  {20,  3}, // #2386
  {21,  1}, // #2387
  {22,  4}, // #2388
  {23,  5}, // #2389
  { 3,  2}, // #2390
  { 4,  1}, // #2391
  { 8,  1}, // #2392
  {11,  3}, // #2393
  {12,  2}, // #2394
  {13,  3}, // #2395
  {14,  2}, // #2396
  {15,  2}, // #2397
  {16,  1}, // #2398
  {18,  1}, // #2399
  {19,  4}, // #2400
  {20,  3}, // #2401
  {22,  4}, // #2402
  {23,  4}, // #2403
  {11,  8}, // #2404
  {15,  1}, // #2405
  {19, 30}, // #2406
  {22, 31}, // #2407
  {23, 31}, // #2408
  { 4,  1}, // #2409
  { 8,  2}, // #2410
  {11,  1}, // #2411
  {13,  2}, // #2412
  {15,  3}, // #2413
  {16,  1}, // #2414
  {17,  1}, // #2415
  {18,  2}, // #2416
  {19,  3}, // #2417
  {20,  2}, // #2418
  {21,  1}, // #2419
  {22,  3}, // #2420
  {23,  4}, // #2421
  { 4,  1}, // #2422
  { 8,  2}, // #2423
  {11,  1}, // #2424
  {13,  2}, // #2425
  {15,  3}, // #2426
  {16,  1}, // #2427
  {18,  2}, // #2428
  {19,  3}, // #2429
  {20,  2}, // #2430
  {22,  3}, // #2431
  {23,  3}, // #2432
  { 8,  2}, // #2433
  {13,  2}, // #2434
  {15,  3}, // #2435
  {17,  1}, // #2436
  {18,  2}, // #2437
  {19,  3}, // #2438
  {20,  2}, // #2439
  {21,  1}, // #2440
  {22,  3}, // #2441
  {23,  4}, // #2442
  { 8,  2}, // #2443
  {13,  2}, // #2444
  {15,  3}, // #2445
  {18,  2}, // #2446
  {19,  3}, // #2447
  {20,  2}, // #2448
  {22,  3}, // #2449
  {23,  3}, // #2450
  {14,  2}, // #2451
  {20,  2}, // #2452
  {22,  3}, // #2453
  {23,  3}, // #2454
  { 4,  2}, // #2455
  {11,  2}, // #2456
  {15,  2}, // #2457
  {16,  2}, // #2458
  {17,  1}, // #2459
  {19,  2}, // #2460
  {21,  1}, // #2461
  {22,  2}, // #2462
  {23,  3}, // #2463
  { 4,  1}, // #2464
  {11,  1}, // #2465
  {14,  1}, // #2466
  {15,  1}, // #2467
  {16,  1}, // #2468
  {17,  1}, // #2469
  {19,  1}, // #2470
  {20,  1}, // #2471
  {21,  2}, // #2472
  {22,  4}, // #2473
  {23,  6}, // #2474
  { 2, 14}, // #2475
  { 3,  1}, // #2476
  {11,  1}, // #2477
  {12,  1}, // #2478
  {13,  1}, // #2479
  {14,  1}, // #2480
  {17,  1}, // #2481
  {19,  1}, // #2482
  {20,  1}, // #2483
  {21,  1}, // #2484
  {22,  1}, // #2485
  {23,  2}, // #2486
  { 2, 14}, // #2487
  { 3,  1}, // #2488
  {11,  1}, // #2489
  {12,  1}, // #2490
  {13,  1}, // #2491
  {14,  1}, // #2492
  {19,  1}, // #2493
  {20,  1}, // #2494
  {22,  1}, // #2495
  {23,  1}, // #2496
  { 2,  7}, // #2497
  { 3,  1}, // #2498
  {11,  1}, // #2499
  {12,  1}, // #2500
  {13,  1}, // #2501
  {14,  1}, // #2502
  {17,  1}, // #2503
  {19,  1}, // #2504
  {20,  1}, // #2505
  {21,  1}, // #2506
  {22,  1}, // #2507
  {23,  2}, // #2508
  { 2,  9}, // #2509
  { 3,  1}, // #2510
  {11,  1}, // #2511
  {12,  1}, // #2512
  {13,  1}, // #2513
  {14,  1}, // #2514
  {19,  1}, // #2515
  {20,  1}, // #2516
  {22,  1}, // #2517
  {23,  1}, // #2518
  { 4,  1}, // #2519
  { 7,  1}, // #2520
  {11,  1}, // #2521
  {12,  1}, // #2522
  {15,  1}, // #2523
  {16,  1}, // #2524
  {19,  1}, // #2525
  {21,  1}, // #2526
  {22,  1}, // #2527
  {23,  3}, // #2528
  { 2, 16}, // #2529
  { 3,  2}, // #2530
  {11,  2}, // #2531
  {12,  2}, // #2532
  {13,  2}, // #2533
  {14,  2}, // #2534
  {17,  1}, // #2535
  {19,  3}, // #2536
  {20,  2}, // #2537
  {21,  1}, // #2538
  {22,  3}, // #2539
  {23,  4}, // #2540
  { 2, 16}, // #2541
  { 3,  2}, // #2542
  {11,  2}, // #2543
  {12,  2}, // #2544
  {13,  2}, // #2545
  {14,  2}, // #2546
  {19,  3}, // #2547
  {20,  2}, // #2548
  {22,  3}, // #2549
  {23,  3}, // #2550
  { 2, 10}, // #2551
  { 3,  2}, // #2552
  {11,  2}, // #2553
  {12,  2}, // #2554
  {13,  2}, // #2555
  {14,  2}, // #2556
  {17,  1}, // #2557
  {19,  3}, // #2558
  {20,  2}, // #2559
  {21,  1}, // #2560
  {22,  3}, // #2561
  {23,  4}, // #2562
  { 2, 10}, // #2563
  { 3,  2}, // #2564
  {11,  2}, // #2565
  {12,  2}, // #2566
  {13,  2}, // #2567
  {14,  2}, // #2568
  {19,  3}, // #2569
  {20,  2}, // #2570
  {22,  3}, // #2571
  {23,  3}, // #2572
  { 3,  1}, // #2573
  { 7,  1}, // #2574
  {11,  1}, // #2575
  {12,  2}, // #2576
  {13,  1}, // #2577
  {14,  1}, // #2578
  {15,  1}, // #2579
  {19,  2}, // #2580
  {20,  1}, // #2581
  {21,  1}, // #2582
  {22,  2}, // #2583
  {23,  4}, // #2584
  { 3,  2}, // #2585
  { 8,  1}, // #2586
  {11,  2}, // #2587
  {12,  2}, // #2588
  {13,  3}, // #2589
  {14,  2}, // #2590
  {15,  1}, // #2591
  {17,  1}, // #2592
  {18,  1}, // #2593
  {19,  3}, // #2594
  {20,  3}, // #2595
  {21,  1}, // #2596
  {22,  3}, // #2597
  {23,  4}, // #2598
  { 3,  2}, // #2599
  { 8,  1}, // #2600
  {11,  2}, // #2601
  {12,  2}, // #2602
  {13,  3}, // #2603
  {14,  2}, // #2604
  {15,  1}, // #2605
  {18,  1}, // #2606
  {19,  3}, // #2607
  {20,  3}, // #2608
  {22,  3}, // #2609
  {23,  3}, // #2610
  { 2, 28}, // #2611
  { 3,  2}, // #2612
  {11,  2}, // #2613
  {12,  2}, // #2614
  {13,  2}, // #2615
  {14,  2}, // #2616
  {17,  1}, // #2617
  {19,  3}, // #2618
  {20,  2}, // #2619
  {21,  1}, // #2620
  {22,  3}, // #2621
  {23,  4}, // #2622
  { 2, 28}, // #2623
  { 3,  2}, // #2624
  {11,  2}, // #2625
  {12,  2}, // #2626
  {13,  2}, // #2627
  {14,  2}, // #2628
  {19,  3}, // #2629
  {20,  2}, // #2630
  {22,  3}, // #2631
  {23,  3}, // #2632
  { 2, 14}, // #2633
  { 3,  2}, // #2634
  {11,  2}, // #2635
  {12,  2}, // #2636
  {13,  2}, // #2637
  {14,  2}, // #2638
  {17,  1}, // #2639
  {19,  3}, // #2640
  {20,  2}, // #2641
  {21,  1}, // #2642
  {22,  3}, // #2643
  {23,  4}, // #2644
  { 2, 14}, // #2645
  { 3,  2}, // #2646
  {11,  2}, // #2647
  {12,  2}, // #2648
  {13,  2}, // #2649
  {14,  2}, // #2650
  {19,  3}, // #2651
  {20,  2}, // #2652
  {22,  3}, // #2653
  {23,  3}, // #2654
  { 4,  2}, // #2655
  {11,  2}, // #2656
  {14,  3}, // #2657
  {15,  3}, // #2658
  {16,  2}, // #2659
  {17,  1}, // #2660
  {19,  3}, // #2661
  {20,  3}, // #2662
  {21,  2}, // #2663
  {22,  9}, // #2664
  {23, 11}, // #2665
  { 3,  2}, // #2666
  { 4,  1}, // #2667
  { 9,  4}, // #2668
  {11,  3}, // #2669
  {12,  2}, // #2670
  {13,  2}, // #2671
  {14,  6}, // #2672
  {15,  1}, // #2673
  {16,  5}, // #2674
  {18,  4}, // #2675
  {19,  3}, // #2676
  {20,  6}, // #2677
  {22, 12}, // #2678
  {23, 12}, // #2679
  { 3,  1}, // #2680
  { 4,  1}, // #2681
  {11,  2}, // #2682
  {12,  1}, // #2683
  {13,  1}, // #2684
  {14,  1}, // #2685
  {15,  1}, // #2686
  {16,  1}, // #2687
  {19,  2}, // #2688
  {20,  1}, // #2689
  {22,  2}, // #2690
  {23,  2}, // #2691
  { 7,  1}, // #2692
  {12,  1}, // #2693
  {17,  1}, // #2694
  {21,  2}, // #2695
  {22,  3}, // #2696
  {23,  6}, // #2697
  { 9,  1}, // #2698
  {14,  1}, // #2699
  {16,  1}, // #2700
  {18,  1}, // #2701
  {20,  1}, // #2702
  {22,  5}, // #2703
  {23,  5}, // #2704
  { 9,  2}, // #2705
  {14,  4}, // #2706
  {15,  1}, // #2707
  {16,  2}, // #2708
  {18,  2}, // #2709
  {19,  1}, // #2710
  {20,  4}, // #2711
  {22,  7}, // #2712
  {23,  7}, // #2713
  { 8,  6}, // #2714
  {11,  3}, // #2715
  {13,  6}, // #2716
  {15,  6}, // #2717
  {18,  6}, // #2718
  {19,  9}, // #2719
  {20,  6}, // #2720
  {22, 15}, // #2721
  {23, 15}, // #2722
  {11,  1}, // #2723
  {19,  2}, // #2724
  {22,  2}, // #2725
  {23,  2}, // #2726
  { 4,  2}, // #2727
  {11,  2}, // #2728
  {14,  3}, // #2729
  {15,  3}, // #2730
  {16,  2}, // #2731
  {19,  3}, // #2732
  {20,  3}, // #2733
  {22, 10}, // #2734
  {23, 10}, // #2735
  { 3,  1}, // #2736
  { 4,  1}, // #2737
  {11,  2}, // #2738
  {12,  1}, // #2739
  {13,  1}, // #2740
  {14,  1}, // #2741
  {15,  1}, // #2742
  {16,  1}, // #2743
  {17,  1}, // #2744
  {19,  2}, // #2745
  {20,  1}, // #2746
  {21,  1}, // #2747
  {22,  2}, // #2748
  {23,  3}, // #2749
  { 8,  1}, // #2750
  { 9,  1}, // #2751
  {13,  1}, // #2752
  {14,  1}, // #2753
  {15,  1}, // #2754
  {16,  1}, // #2755
  {18,  2}, // #2756
  {19,  1}, // #2757
  {20,  2}, // #2758
  {22,  2}, // #2759
  {23,  2}, // #2760
  {14,  1}, // #2761
  {17,  1}, // #2762
  {20,  1}, // #2763
  {21,  1}, // #2764
  {22,  4}, // #2765
  {23,  5}, // #2766
  { 8,  1}, // #2767
  {13,  1}, // #2768
  {15,  1}, // #2769
  {17,  1}, // #2770
  {18,  1}, // #2771
  {19,  2}, // #2772
  {20,  1}, // #2773
  {21,  1}, // #2774
  {22,  2}, // #2775
  {23,  3}, // #2776
  { 4,  2}, // #2777
  { 9,  2}, // #2778
  {11,  2}, // #2779
  {14,  2}, // #2780
  {15,  2}, // #2781
  {16,  4}, // #2782
  {17,  1}, // #2783
  {18,  2}, // #2784
  {19,  2}, // #2785
  {20,  2}, // #2786
  {21,  1}, // #2787
  {22,  7}, // #2788
  {23,  8}, // #2789
  { 4,  1}, // #2790
  {11,  1}, // #2791
  {14,  4}, // #2792
  {15,  2}, // #2793
  {16,  1}, // #2794
  {17,  1}, // #2795
  {19,  2}, // #2796
  {20,  4}, // #2797
  {21,  2}, // #2798
  {22,  8}, // #2799
  {23, 10}, // #2800
  { 4,  2}, // #2801
  {11,  2}, // #2802
  {14,  2}, // #2803
  {15,  2}, // #2804
  {16,  2}, // #2805
  {19,  2}, // #2806
  {20,  2}, // #2807
  {22,  7}, // #2808
  {23,  7}, // #2809
  { 4,  1}, // #2810
  {11,  1}, // #2811
  {14,  4}, // #2812
  {15,  2}, // #2813
  {16,  1}, // #2814
  {19,  2}, // #2815
  {20,  4}, // #2816
  {22,  9}, // #2817
  {23,  9}, // #2818
  { 9,  3}, // #2819
  {14,  3}, // #2820
  {16,  3}, // #2821
  {17,  1}, // #2822
  {18,  3}, // #2823
  {20,  3}, // #2824
  {21,  1}, // #2825
  {22, 18}, // #2826
  {23, 19}, // #2827
  { 7,  1}, // #2828
  { 9,  5}, // #2829
  {12,  1}, // #2830
  {14,  5}, // #2831
  {16,  5}, // #2832
  {17,  1}, // #2833
  {18,  5}, // #2834
  {20,  5}, // #2835
  {21,  2}, // #2836
  {22, 24}, // #2837
  {23, 27}, // #2838
  { 7,  1}, // #2839
  { 9,  6}, // #2840
  {12,  1}, // #2841
  {14,  6}, // #2842
  {16,  6}, // #2843
  {17,  1}, // #2844
  {18,  6}, // #2845
  {20,  6}, // #2846
  {21,  2}, // #2847
  {22, 25}, // #2848
  {23, 28}, // #2849
  { 3,  2}, // #2850
  {11,  4}, // #2851
  {12,  2}, // #2852
  {13,  3}, // #2853
  {14, 12}, // #2854
  {17,  8}, // #2855
  {19,  7}, // #2856
  {20, 13}, // #2857
  {21,  8}, // #2858
  {22, 56}, // #2859
  {23, 64}, // #2860
  { 3,  9}, // #2861
  { 4,  9}, // #2862
  { 7, 11}, // #2863
  { 8,  8}, // #2864
  { 9,  1}, // #2865
  {11, 18}, // #2866
  {12, 20}, // #2867
  {13, 17}, // #2868
  {14, 31}, // #2869
  {15, 17}, // #2870
  {16, 10}, // #2871
  {18,  9}, // #2872
  {19, 26}, // #2873
  {20, 39}, // #2874
  {21, 11}, // #2875
  {22, 78}, // #2876
  {23, 100}, // #2877
  { 7,  1}, // #2878
  { 8,  3}, // #2879
  {12,  1}, // #2880
  {13,  3}, // #2881
  {15,  3}, // #2882
  {17,  2}, // #2883
  {18,  3}, // #2884
  {19,  3}, // #2885
  {20,  3}, // #2886
  {21,  2}, // #2887
  {22,  4}, // #2888
  {23,  7}, // #2889
  { 7,  1}, // #2890
  { 8,  3}, // #2891
  {12,  1}, // #2892
  {13,  3}, // #2893
  {15,  3}, // #2894
  {17,  4}, // #2895
  {18,  3}, // #2896
  {19,  3}, // #2897
  {20,  3}, // #2898
  {21,  4}, // #2899
  {22,  4}, // #2900
  {23,  9}, // #2901
  { 7,  1}, // #2902
  { 8,  4}, // #2903
  {12,  1}, // #2904
  {13,  4}, // #2905
  {15,  4}, // #2906
  {17,  4}, // #2907
  {18,  4}, // #2908
  {19,  4}, // #2909
  {20,  4}, // #2910
  {21,  4}, // #2911
  {22,  5}, // #2912
  {23, 10}, // #2913
  { 7,  1}, // #2914
  { 8,  4}, // #2915
  {12,  1}, // #2916
  {13,  4}, // #2917
  {15,  4}, // #2918
  {17,  8}, // #2919
  {18,  4}, // #2920
  {19,  4}, // #2921
  {20,  4}, // #2922
  {21,  8}, // #2923
  {22,  5}, // #2924
  {23, 14}, // #2925
  { 7,  1}, // #2926
  { 8,  5}, // #2927
  {12,  1}, // #2928
  {13,  5}, // #2929
  {15,  5}, // #2930
  {17,  2}, // #2931
  {18,  5}, // #2932
  {19,  5}, // #2933
  {20,  5}, // #2934
  {21,  2}, // #2935
  {22,  6}, // #2936
  {23,  9}, // #2937
  { 9,  1}, // #2938
  {14,  1}, // #2939
  {16,  1}, // #2940
  {17,  1}, // #2941
  {18,  1}, // #2942
  {20,  1}, // #2943
  {21,  1}, // #2944
  {22, 17}, // #2945
  {23, 18}, // #2946
  {14,  1}, // #2947
  {17,  1}, // #2948
  {20,  1}, // #2949
  {21,  1}, // #2950
  {22,  2}, // #2951
  {23,  3}, // #2952
  { 9,  1}, // #2953
  {16,  1}, // #2954
  { 3,  3}, // #2955
  {11,  1}, // #2956
  {12,  2}, // #2957
  {14,  1}, // #2958
  { 8,  1}, // #2959
  { 9,  1}, // #2960
  {12,  1}, // #2961
  {14,  1}, // #2962
  {15,  1}, // #2963
  { 8,  2}, // #2964
  { 9,  2}, // #2965
  {12,  2}, // #2966
  {14,  2}, // #2967
  {15,  2}, // #2968
  { 3,  2}, // #2969
  {11,  1}, // #2970
  {12,  2}, // #2971
  {14,  1}, // #2972
  { 3,  2}, // #2973
  {11,  1}, // #2974
  {12,  1}, // #2975
  { 3,  1}, // #2976
  {11,  1}, // #2977
  {12,  2}, // #2978
  {14,  1}, // #2979
  { 5,  1}, // #2980
  { 7,  1}, // #2981
  { 9,  1}, // #2982
  {10,  1}, // #2983
  {11,  1}, // #2984
  {12,  1}, // #2985
  { 7,  1}, // #2986
  { 9,  2}, // #2987
  {11,  1}, // #2988
  {12,  1}, // #2989
  {16,  1}, // #2990
  {19,  1}, // #2991
  { 7,  1}, // #2992
  { 9,  2}, // #2993
  {16,  1}, // #2994
  {19,  1}, // #2995
  { 7,  1}, // #2996
  { 9,  1}, // #2997
  {11,  1}, // #2998
  {12,  1}, // #2999
  {19,  1}, // #3000
  { 7,  1}, // #3001
  { 9,  1}, // #3002
  {19,  1}, // #3003
  { 9,  4}, // #3004
  {10,  4}, // #3005
  {11,  1}, // #3006
  {12,  1}, // #3007
  { 3,  8}, // #3008
  {11,  1}, // #3009
  {12,  1}, // #3010
  { 1,  1}, // #3011
  { 3,  1}, // #3012
  { 5,  1}, // #3013
  { 7,  1}, // #3014
  { 9,  1}, // #3015
  {10,  1}, // #3016
  {11,  1}, // #3017
  {12,  1}, // #3018
  { 3,  4}, // #3019
  {11,  1}, // #3020
  {12,  1}, // #3021
  { 8,  1}, // #3022
  { 9,  1}, // #3023
  {11,  1}, // #3024
  {12,  1}, // #3025
  {15,  1}, // #3026
  { 8,  1}, // #3027
  { 9,  1}, // #3028
  {15,  1}, // #3029
  { 1,  1}, // #3030
  { 3,  1}, // #3031
  { 5,  1}, // #3032
  { 7,  1}, // #3033
  { 8,  1}, // #3034
  { 9,  2}, // #3035
  {10,  1}, // #3036
  {11,  1}, // #3037
  {12,  1}, // #3038
  {15,  1}, // #3039
  { 1,  1}, // #3040
  { 3,  1}, // #3041
  { 5,  1}, // #3042
  { 7,  1}, // #3043
  { 8,  1}, // #3044
  { 9,  2}, // #3045
  {10,  1}, // #3046
  {15,  1}, // #3047
  { 8,  1}, // #3048
  { 9,  1}, // #3049
  {11,  1}, // #3050
  {12,  1}, // #3051
  {15,  2}, // #3052
  { 8,  1}, // #3053
  { 9,  1}, // #3054
  {15,  2}, // #3055
  { 2,  1}, // #3056
  { 3,  1}, // #3057
  { 4, 17}, // #3058
  {11,  1}, // #3059
  {12,  1}, // #3060
  { 2,  1}, // #3061
  { 3,  1}, // #3062
  { 4, 25}, // #3063
  {11,  1}, // #3064
  {12,  1}, // #3065
  { 2,  1}, // #3066
  { 3,  1}, // #3067
  { 4, 41}, // #3068
  {11,  1}, // #3069
  {12,  1}, // #3070
  { 2,  1}, // #3071
  { 3,  1}, // #3072
  { 4, 12}, // #3073
  {11,  1}, // #3074
  {12,  1}, // #3075
  { 6, 19}, // #3076
  { 8,  1}, // #3077
  { 9,  1}, // #3078
  {10, 19}, // #3079
  {11,  1}, // #3080
  {12,  1}, // #3081
  { 5,  3}, // #3082
  { 6,  3}, // #3083
  { 8,  1}, // #3084
  { 9,  1}, // #3085
  {10,  6}, // #3086
  {11,  1}, // #3087
  {12,  1}, // #3088
  { 9,  1}, // #3089
  {11,  1}, // #3090
  {12,  1}, // #3091
  {16,  1}, // #3092
  { 2,  1}, // #3093
  { 3,  1}, // #3094
  {11,  1}, // #3095
  {12,  1}, // #3096
  {13,  3}, // #3097
  { 2,  1}, // #3098
  { 3,  1}, // #3099
  {13,  3}, // #3100
  { 2,  1}, // #3101
  { 3,  1}, // #3102
  {11,  1}, // #3103
  {12,  1}, // #3104
  {13,  1}, // #3105
  { 2,  1}, // #3106
  { 3,  1}, // #3107
  {11,  1}, // #3108
  {12,  1}, // #3109
  {13,  2}, // #3110
  { 2,  1}, // #3111
  { 3,  1}, // #3112
  {13,  1}, // #3113
  { 2,  1}, // #3114
  { 3,  1}, // #3115
  {13,  2}, // #3116
  { 2,  1}, // #3117
  { 3,  1}, // #3118
  {11,  1}, // #3119
  {12,  1}, // #3120
  {13,  4}, // #3121
  { 2,  1}, // #3122
  { 3,  1}, // #3123
  {13,  4}, // #3124
  { 7,  1}, // #3125
  { 9,  1}, // #3126
  {11,  1}, // #3127
  {12,  1}, // #3128
  {19,  2}, // #3129
  { 7,  1}, // #3130
  { 9,  1}, // #3131
  {19,  2}, // #3132
  { 6,  2}, // #3133
  { 8,  1}, // #3134
  { 9,  1}, // #3135
  {10,  2}, // #3136
  {11,  1}, // #3137
  {12,  1}, // #3138
  { 6,  1}, // #3139
  { 8,  1}, // #3140
  { 9,  1}, // #3141
  {10,  1}, // #3142
  {11,  1}, // #3143
  {12,  1}, // #3144
  { 9,  4}, // #3145
  {11,  1}, // #3146
  {12,  1}, // #3147
  {16,  4}, // #3148
  { 9,  4}, // #3149
  {16,  4}, // #3150
  { 1,  1}, // #3151
  { 3,  1}, // #3152
  { 5,  1}, // #3153
  { 8,  1}, // #3154
  { 9,  1}, // #3155
  {10,  1}, // #3156
  {11,  3}, // #3157
  {12,  5}, // #3158
  {14,  2}, // #3159
  {16, 10}, // #3160
  {18,  4}, // #3161
  { 1,  1}, // #3162
  { 3,  1}, // #3163
  { 5,  1}, // #3164
  { 8,  1}, // #3165
  { 9,  1}, // #3166
  {10,  1}, // #3167
  {11,  2}, // #3168
  {12,  4}, // #3169
  {14,  2}, // #3170
  {16, 10}, // #3171
  {18,  4}, // #3172
  { 1,  1}, // #3173
  { 3,  1}, // #3174
  { 5,  1}, // #3175
  { 7,  1}, // #3176
  { 8,  2}, // #3177
  { 9,  3}, // #3178
  {10,  1}, // #3179
  {11,  1}, // #3180
  {12,  1}, // #3181
  {16,  2}, // #3182
  {18,  2}, // #3183
  { 1,  1}, // #3184
  { 3,  1}, // #3185
  { 5,  1}, // #3186
  { 7,  1}, // #3187
  { 8,  2}, // #3188
  { 9,  3}, // #3189
  {10,  1}, // #3190
  {16,  2}, // #3191
  {18,  2}, // #3192
  { 7,  2}, // #3193
  { 9,  3}, // #3194
  {11,  1}, // #3195
  {12,  1}, // #3196
  {16,  1}, // #3197
  {19,  2}, // #3198
  { 7,  2}, // #3199
  { 9,  3}, // #3200
  {16,  1}, // #3201
  {19,  2}, // #3202
  { 9,  1}, // #3203
  {11,  1}, // #3204
  {12,  1}, // #3205
  {16,  4}, // #3206
  { 9,  1}, // #3207
  {16,  4}, // #3208
  { 3,  1}, // #3209
  {12,  1}, // #3210
  {14,  1}, // #3211
  { 3, 22}, // #3212
  {11,  1}, // #3213
  {12,  1}, // #3214
  { 6, 27}, // #3215
  { 8,  1}, // #3216
  { 9,  1}, // #3217
  {10, 27}, // #3218
  {11,  1}, // #3219
  {12,  1}, // #3220
  { 6, 21}, // #3221
  { 8,  1}, // #3222
  { 9,  1}, // #3223
  {10, 21}, // #3224
  {11,  1}, // #3225
  {12,  1}, // #3226
  { 6, 35}, // #3227
  { 8,  1}, // #3228
  { 9,  1}, // #3229
  {10, 35}, // #3230
  { 5,  2}, // #3231
  { 7,  2}, // #3232
  { 9,  2}, // #3233
  {10,  2}, // #3234
  {11,  2}, // #3235
  {12,  2}, // #3236
  { 9,  6}, // #3237
  {10,  6}, // #3238
  {11,  2}, // #3239
  {12,  2}, // #3240
  { 9,  2}, // #3241
  {10,  2}, // #3242
  {11,  1}, // #3243
  {12,  1}, // #3244
  { 8,  2}, // #3245
  { 9,  2}, // #3246
  {11,  2}, // #3247
  {12,  2}, // #3248
  {15,  2}, // #3249
  { 8,  2}, // #3250
  { 9,  2}, // #3251
  {15,  2}, // #3252
  { 8,  2}, // #3253
  { 9,  2}, // #3254
  {10,  4}, // #3255
  {11,  2}, // #3256
  {12,  2}, // #3257
  {15,  2}, // #3258
  { 8,  2}, // #3259
  { 9,  2}, // #3260
  {10,  4}, // #3261
  {15,  2}, // #3262
  { 8,  2}, // #3263
  { 9,  2}, // #3264
  {10,  2}, // #3265
  {12,  1}, // #3266
  {14,  1}, // #3267
  {15,  2}, // #3268
  { 8,  2}, // #3269
  { 9,  2}, // #3270
  {10,  2}, // #3271
  {15,  2}, // #3272
  { 6, 38}, // #3273
  { 8,  2}, // #3274
  { 9,  2}, // #3275
  {10, 38}, // #3276
  {11,  2}, // #3277
  {12,  2}, // #3278
  { 5,  6}, // #3279
  { 6,  6}, // #3280
  { 8,  2}, // #3281
  { 9,  2}, // #3282
  {10, 12}, // #3283
  {11,  2}, // #3284
  {12,  2}, // #3285
  { 3,  4}, // #3286
  { 5,  1}, // #3287
  { 7,  1}, // #3288
  { 8,  4}, // #3289
  { 9,  5}, // #3290
  {10,  1}, // #3291
  {11,  4}, // #3292
  {12,  8}, // #3293
  {14,  4}, // #3294
  {15,  4}, // #3295
  { 9,  4}, // #3296
  {10,  4}, // #3297
  {11,  2}, // #3298
  {12,  2}, // #3299
  { 3,  2}, // #3300
  { 5,  1}, // #3301
  { 7,  1}, // #3302
  { 8,  2}, // #3303
  { 9,  3}, // #3304
  {10,  1}, // #3305
  {11,  2}, // #3306
  {12,  4}, // #3307
  {14,  2}, // #3308
  {15,  2}, // #3309
  { 3,  8}, // #3310
  { 5,  1}, // #3311
  { 7,  1}, // #3312
  { 8, 10}, // #3313
  { 9, 11}, // #3314
  {10,  1}, // #3315
  {11,  8}, // #3316
  {12, 16}, // #3317
  {14,  8}, // #3318
  {15, 10}, // #3319
  { 3,  4}, // #3320
  { 5,  1}, // #3321
  { 7,  1}, // #3322
  { 8,  5}, // #3323
  { 9,  6}, // #3324
  {10,  1}, // #3325
  {11,  4}, // #3326
  {12,  8}, // #3327
  {14,  4}, // #3328
  {15,  5}, // #3329
  { 9,  2}, // #3330
  {16,  2}, // #3331
  { 6,  4}, // #3332
  { 8,  2}, // #3333
  { 9,  2}, // #3334
  {10,  4}, // #3335
  {11,  2}, // #3336
  {12,  2}, // #3337
  { 6,  2}, // #3338
  { 8,  2}, // #3339
  { 9,  2}, // #3340
  {10,  2}, // #3341
  {11,  2}, // #3342
  {12,  2}, // #3343
  { 9,  2}, // #3344
  {10,  6}, // #3345
  {11,  2}, // #3346
  {12,  2}, // #3347
  { 9,  1}, // #3348
  {10,  4}, // #3349
  {11,  1}, // #3350
  {12,  1}, // #3351
  { 9,  4}, // #3352
  {11,  2}, // #3353
  {12,  2}, // #3354
  {16,  4}, // #3355
  { 9,  2}, // #3356
  {11,  1}, // #3357
  {12,  1}, // #3358
  {16,  2}, // #3359
  { 1,  1}, // #3360
  { 3,  1}, // #3361
  { 5,  2}, // #3362
  { 9,  2}, // #3363
  {10,  4}, // #3364
  {11,  2}, // #3365
  {12,  2}, // #3366
  { 6, 54}, // #3367
  { 8,  2}, // #3368
  { 9,  2}, // #3369
  {10, 54}, // #3370
  {11,  2}, // #3371
  {12,  2}, // #3372
  { 6, 42}, // #3373
  { 8,  2}, // #3374
  { 9,  2}, // #3375
  {10, 42}, // #3376
  {11,  2}, // #3377
  {12,  2}, // #3378
  { 3,  2}, // #3379
  {11, 16}, // #3380
  {12, 32}, // #3381
  {14, 16}, // #3382
  { 9,  2}, // #3383
  {10,  4}, // #3384
  {11,  1}, // #3385
  {12,  1}, // #3386
  { 3, 42}, // #3387
  { 5,  1}, // #3388
  { 7,  1}, // #3389
  { 8,  2}, // #3390
  { 9,  3}, // #3391
  {10,  1}, // #3392
  {11,  2}, // #3393
  {12, 18}, // #3394
  {14, 16}, // #3395
  {15,  2}, // #3396
  { 3,  3}, // #3397
  {11, 19}, // #3398
  {12, 38}, // #3399
  {14, 19}, // #3400
  { 3,  6}, // #3401
  {11, 38}, // #3402
  {12, 76}, // #3403
  {14, 38}, // #3404
  { 3,  3}, // #3405
  {11, 16}, // #3406
  {12, 32}, // #3407
  {14, 16}, // #3408
  { 3,  3}, // #3409
  {11, 17}, // #3410
  {12, 34}, // #3411
  {14, 17}, // #3412
  { 3,  6}, // #3413
  {11,  1}, // #3414
  {12,  2}, // #3415
  {14,  1}, // #3416
  { 3,  1}, // #3417
  {11, 19}, // #3418
  {12, 38}, // #3419
  {14, 19}, // #3420
  { 2,  1}, // #3421
  { 3,  1}, // #3422
  {12,  1}, // #3423
  {14,  1}, // #3424
  { 8,  1}, // #3425
  {13,  1}, // #3426
  {15,  1}, // #3427
  {17,  1}, // #3428
  {18,  1}, // #3429
  {19,  3}, // #3430
  {20,  1}, // #3431
  {21,  1}, // #3432
  {22,  3}, // #3433
  {23,  4}, // #3434
  { 8,  1}, // #3435
  {13,  1}, // #3436
  {15,  1}, // #3437
  {18,  1}, // #3438
  {19,  3}, // #3439
  {20,  1}, // #3440
  {22,  3}, // #3441
  {23,  3}, // #3442
  { 8,  1}, // #3443
  {13,  1}, // #3444
  {15,  1}, // #3445
  {17,  1}, // #3446
  {18,  1}, // #3447
  {19,  4}, // #3448
  {20,  1}, // #3449
  {21,  1}, // #3450
  {22,  4}, // #3451
  {23,  5}, // #3452
  { 8,  1}, // #3453
  {13,  1}, // #3454
  {15,  1}, // #3455
  {18,  1}, // #3456
  {19,  4}, // #3457
  {20,  1}, // #3458
  {22,  4}, // #3459
  {23,  4}, // #3460
  {13,  2}, // #3461
  {17,  1}, // #3462
  {19,  2}, // #3463
  {20,  2}, // #3464
  {21,  1}, // #3465
  {22,  2}, // #3466
  {23,  3}, // #3467
  { 7,  1}, // #3468
  { 8,  1}, // #3469
  {12,  1}, // #3470
  {13,  2}, // #3471
  {15,  1}, // #3472
  {18,  1}, // #3473
  {19,  2}, // #3474
  {20,  2}, // #3475
  {21,  1}, // #3476
  {22,  2}, // #3477
  {23,  4}, // #3478
  { 8,  1}, // #3479
  {13,  2}, // #3480
  {15,  1}, // #3481
  {18,  1}, // #3482
  {19,  2}, // #3483
  {20,  2}, // #3484
  {22,  2}, // #3485
  {23,  2}, // #3486
  { 2, 16}, // #3487
  { 3,  2}, // #3488
  { 8,  1}, // #3489
  {11,  2}, // #3490
  {12,  2}, // #3491
  {13,  3}, // #3492
  {14,  2}, // #3493
  {15,  1}, // #3494
  {17,  1}, // #3495
  {18,  1}, // #3496
  {19,  3}, // #3497
  {20,  3}, // #3498
  {21,  1}, // #3499
  {22,  3}, // #3500
  {23,  4}, // #3501
  { 2, 16}, // #3502
  { 3,  2}, // #3503
  { 8,  1}, // #3504
  {11,  2}, // #3505
  {12,  2}, // #3506
  {13,  3}, // #3507
  {14,  2}, // #3508
  {15,  1}, // #3509
  {18,  1}, // #3510
  {19,  3}, // #3511
  {20,  3}, // #3512
  {22,  3}, // #3513
  {23,  3}, // #3514
  { 2, 10}, // #3515
  { 3,  2}, // #3516
  { 8,  1}, // #3517
  {11,  2}, // #3518
  {12,  2}, // #3519
  {13,  3}, // #3520
  {14,  2}, // #3521
  {15,  1}, // #3522
  {17,  1}, // #3523
  {18,  1}, // #3524
  {19,  3}, // #3525
  {20,  3}, // #3526
  {21,  1}, // #3527
  {22,  3}, // #3528
  {23,  4}, // #3529
  { 2, 10}, // #3530
  { 3,  2}, // #3531
  { 8,  1}, // #3532
  {11,  2}, // #3533
  {12,  2}, // #3534
  {13,  3}, // #3535
  {14,  2}, // #3536
  {15,  1}, // #3537
  {18,  1}, // #3538
  {19,  3}, // #3539
  {20,  3}, // #3540
  {22,  3}, // #3541
  {23,  3}, // #3542
  { 2, 24}, // #3543
  { 3,  2}, // #3544
  { 8,  1}, // #3545
  {11,  2}, // #3546
  {12,  2}, // #3547
  {13,  3}, // #3548
  {14,  2}, // #3549
  {15,  1}, // #3550
  {17,  1}, // #3551
  {18,  1}, // #3552
  {19,  3}, // #3553
  {20,  3}, // #3554
  {21,  1}, // #3555
  {22,  3}, // #3556
  {23,  4}, // #3557
  { 2, 24}, // #3558
  { 3,  2}, // #3559
  { 8,  1}, // #3560
  {11,  2}, // #3561
  {12,  2}, // #3562
  {13,  3}, // #3563
  {14,  2}, // #3564
  {15,  1}, // #3565
  {18,  1}, // #3566
  {19,  3}, // #3567
  {20,  3}, // #3568
  {22,  3}, // #3569
  {23,  3}, // #3570
  { 2, 12}, // #3571
  { 3,  2}, // #3572
  { 8,  1}, // #3573
  {11,  2}, // #3574
  {12,  2}, // #3575
  {13,  3}, // #3576
  {14,  2}, // #3577
  {15,  1}, // #3578
  {17,  1}, // #3579
  {18,  1}, // #3580
  {19,  3}, // #3581
  {20,  3}, // #3582
  {21,  1}, // #3583
  {22,  3}, // #3584
  {23,  4}, // #3585
  { 2, 12}, // #3586
  { 3,  2}, // #3587
  { 8,  1}, // #3588
  {11,  2}, // #3589
  {12,  2}, // #3590
  {13,  3}, // #3591
  {14,  2}, // #3592
  {15,  1}, // #3593
  {18,  1}, // #3594
  {19,  3}, // #3595
  {20,  3}, // #3596
  {22,  3}, // #3597
  {23,  3}, // #3598
  { 3,  1}, // #3599
  { 8,  1}, // #3600
  {11,  1}, // #3601
  {12,  1}, // #3602
  {13,  2}, // #3603
  {14,  1}, // #3604
  {15,  1}, // #3605
  {18,  1}, // #3606
  {19,  3}, // #3607
  {20,  2}, // #3608
  {22,  3}, // #3609
  {23,  3}, // #3610
  { 3,  1}, // #3611
  { 8,  1}, // #3612
  {11,  1}, // #3613
  {12,  1}, // #3614
  {13,  2}, // #3615
  {14,  1}, // #3616
  {15,  1}, // #3617
  {17,  1}, // #3618
  {18,  1}, // #3619
  {19,  3}, // #3620
  {20,  2}, // #3621
  {21,  1}, // #3622
  {22,  3}, // #3623
  {23,  4}, // #3624
  { 4,  1}, // #3625
  { 9,  5}, // #3626
  {11,  1}, // #3627
  {13,  4}, // #3628
  {14,  5}, // #3629
  {15,  1}, // #3630
  {16,  6}, // #3631
  {18,  5}, // #3632
  {19,  5}, // #3633
  {20,  9}, // #3634
  {22, 10}, // #3635
  {23, 10}, // #3636
  { 7,  2}, // #3637
  {12,  2}, // #3638
  {15,  1}, // #3639
  {19,  1}, // #3640
  {21,  2}, // #3641
  {22,  1}, // #3642
  {23,  5}, // #3643
  { 7,  1}, // #3644
  {12,  1}, // #3645
  {19,  1}, // #3646
  {21,  1}, // #3647
  {22,  1}, // #3648
  {23,  3}, // #3649
  { 7,  1}, // #3650
  { 8,  2}, // #3651
  {12,  1}, // #3652
  {13,  2}, // #3653
  {15,  2}, // #3654
  {18,  2}, // #3655
  {19,  2}, // #3656
  {20,  2}, // #3657
  {21,  1}, // #3658
  {22,  2}, // #3659
  {23,  4}, // #3660
  { 8,  1}, // #3661
  {13,  1}, // #3662
  {15,  1}, // #3663
  {17,  1}, // #3664
  {18,  1}, // #3665
  {19,  1}, // #3666
  {20,  1}, // #3667
  {21,  1}, // #3668
  {22,  2}, // #3669
  {23,  3}, // #3670
  { 3,  1}, // #3671
  { 7,  2}, // #3672
  {11,  1}, // #3673
  {12,  3}, // #3674
  {13,  1}, // #3675
  {14,  1}, // #3676
  {19,  1}, // #3677
  {20,  1}, // #3678
  {21,  2}, // #3679
  {22,  3}, // #3680
  {23,  7}, // #3681
  { 3,  1}, // #3682
  { 7,  4}, // #3683
  {11,  1}, // #3684
  {12,  5}, // #3685
  {13,  1}, // #3686
  {14,  1}, // #3687
  {19,  1}, // #3688
  {20,  1}, // #3689
  {21,  4}, // #3690
  {22,  3}, // #3691
  {23, 11}, // #3692
  { 3,  1}, // #3693
  { 7,  8}, // #3694
  {11,  1}, // #3695
  {12,  9}, // #3696
  {13,  1}, // #3697
  {14,  1}, // #3698
  {19,  1}, // #3699
  {20,  1}, // #3700
  {21,  8}, // #3701
  {22,  3}, // #3702
  {23, 19}, // #3703
  { 3,  1}, // #3704
  { 7, 16}, // #3705
  { 8,  1}, // #3706
  {11,  1}, // #3707
  {12, 17}, // #3708
  {13,  2}, // #3709
  {14,  1}, // #3710
  {15,  1}, // #3711
  {18,  1}, // #3712
  {19,  2}, // #3713
  {20,  2}, // #3714
  {21, 16}, // #3715
  {22,  4}, // #3716
  {23, 36}, // #3717
  { 3,  1}, // #3718
  { 7,  2}, // #3719
  { 8,  1}, // #3720
  {11,  1}, // #3721
  {12,  3}, // #3722
  {13,  2}, // #3723
  {14,  1}, // #3724
  {15,  1}, // #3725
  {18,  1}, // #3726
  {19,  2}, // #3727
  {20,  2}, // #3728
  {21,  2}, // #3729
  {22,  4}, // #3730
  {23,  8}, // #3731
  { 3,  1}, // #3732
  { 7,  4}, // #3733
  { 8,  1}, // #3734
  {11,  1}, // #3735
  {12,  5}, // #3736
  {13,  2}, // #3737
  {14,  1}, // #3738
  {15,  1}, // #3739
  {18,  1}, // #3740
  {19,  2}, // #3741
  {20,  2}, // #3742
  {21,  4}, // #3743
  {22,  4}, // #3744
  {23, 12}, // #3745
  { 3,  1}, // #3746
  { 7,  8}, // #3747
  { 8,  1}, // #3748
  {11,  1}, // #3749
  {12,  9}, // #3750
  {13,  2}, // #3751
  {14,  1}, // #3752
  {15,  1}, // #3753
  {18,  1}, // #3754
  {19,  2}, // #3755
  {20,  2}, // #3756
  {21,  8}, // #3757
  {22,  4}, // #3758
  {23, 20}, // #3759
  {11,  3}, // #3760
  {19,  3}, // #3761
  {22,  3}, // #3762
  {23,  3}, // #3763
  {13,  3}, // #3764
  {19,  3}, // #3765
  {20,  3}, // #3766
  {22,  3}, // #3767
  {23,  3}, // #3768
  { 3,  1}, // #3769
  {11,  1}, // #3770
  {12,  1}, // #3771
  {13,  1}, // #3772
  {14,  1}, // #3773
  {17,  1}, // #3774
  {19,  2}, // #3775
  {20,  1}, // #3776
  {21,  1}, // #3777
  {22,  2}, // #3778
  {23,  3}, // #3779
  { 4,  1}, // #3780
  { 8,  2}, // #3781
  {11,  3}, // #3782
  {13,  2}, // #3783
  {15,  3}, // #3784
  {16,  1}, // #3785
  {17,  1}, // #3786
  {18,  2}, // #3787
  {19,  7}, // #3788
  {20,  2}, // #3789
  {21,  1}, // #3790
  {22,  7}, // #3791
  {23,  8}, // #3792
  {11,  3}, // #3793
  {17,  1}, // #3794
  {19,  3}, // #3795
  {21,  1}, // #3796
  {22,  3}, // #3797
  {23,  4}, // #3798
  {13,  3}, // #3799
  {17,  1}, // #3800
  {19,  3}, // #3801
  {20,  3}, // #3802
  {21,  1}, // #3803
  {22,  3}, // #3804
  {23,  4}, // #3805
  { 3,  1}, // #3806
  {11,  1}, // #3807
  {12,  1}, // #3808
  {13,  1}, // #3809
  {14,  1}, // #3810
  {17,  2}, // #3811
  {19,  2}, // #3812
  {20,  1}, // #3813
  {21,  2}, // #3814
  {22,  3}, // #3815
  {23,  5}, // #3816
  { 3,  1}, // #3817
  {11,  1}, // #3818
  {12,  1}, // #3819
  {13,  1}, // #3820
  {14,  1}, // #3821
  {17,  4}, // #3822
  {19,  2}, // #3823
  {20,  1}, // #3824
  {21,  4}, // #3825
  {22,  3}, // #3826
  {23,  7}, // #3827
  { 3,  1}, // #3828
  {11,  1}, // #3829
  {12,  1}, // #3830
  {13,  1}, // #3831
  {14,  1}, // #3832
  {17,  8}, // #3833
  {19,  2}, // #3834
  {20,  1}, // #3835
  {21,  8}, // #3836
  {22,  3}, // #3837
  {23, 11}, // #3838
  { 3,  1}, // #3839
  {11,  1}, // #3840
  {12,  1}, // #3841
  {13,  1}, // #3842
  {14,  1}, // #3843
  {17, 16}, // #3844
  {19,  2}, // #3845
  {20,  1}, // #3846
  {21, 16}, // #3847
  {22,  3}, // #3848
  {23, 19}, // #3849
  { 8,  5}, // #3850
  {11,  5}, // #3851
  {13,  5}, // #3852
  {15,  5}, // #3853
  {18,  5}, // #3854
  {19, 14}, // #3855
  {20,  5}, // #3856
  {22, 14}, // #3857
  {23, 14}, // #3858
  { 8,  5}, // #3859
  {11,  5}, // #3860
  {13,  5}, // #3861
  {15,  5}, // #3862
  {17,  1}, // #3863
  {18,  5}, // #3864
  {19, 14}, // #3865
  {20,  5}, // #3866
  {21,  1}, // #3867
  {22, 14}, // #3868
  {23, 15}, // #3869
  { 8,  9}, // #3870
  {11,  7}, // #3871
  {13,  9}, // #3872
  {15,  9}, // #3873
  {18,  9}, // #3874
  {19, 21}, // #3875
  {20,  9}, // #3876
  {22, 21}, // #3877
  {23, 21}, // #3878
  { 8,  9}, // #3879
  {11,  7}, // #3880
  {13,  9}, // #3881
  {15,  9}, // #3882
  {17,  1}, // #3883
  {18,  9}, // #3884
  {19, 21}, // #3885
  {20,  9}, // #3886
  {21,  1}, // #3887
  {22, 21}, // #3888
  {23, 22}, // #3889
  { 8, 17}, // #3890
  {11, 11}, // #3891
  {13, 17}, // #3892
  {15, 17}, // #3893
  {18, 17}, // #3894
  {19, 35}, // #3895
  {20, 17}, // #3896
  {22, 35}, // #3897
  {23, 35}, // #3898
  { 8, 17}, // #3899
  {11, 11}, // #3900
  {13, 17}, // #3901
  {15, 17}, // #3902
  {17,  1}, // #3903
  {18, 17}, // #3904
  {19, 35}, // #3905
  {20, 17}, // #3906
  {21,  1}, // #3907
  {22, 35}, // #3908
  {23, 36}, // #3909
  { 4,  1}, // #3910
  { 7,  1}, // #3911
  { 9,  1}, // #3912
  {11,  1}, // #3913
  {12,  1}, // #3914
  { 6,  1}, // #3915
  { 8,  1}, // #3916
  { 9,  1}, // #3917
  {11,  1}, // #3918
  {12,  1}, // #3919
  { 5,  1}, // #3920
  { 6,  2}, // #3921
  { 8,  2}, // #3922
  { 9,  2}, // #3923
  {10,  2}, // #3924
  {11,  3}, // #3925
  {12,  6}, // #3926
  { 6,  1}, // #3927
  { 8,  1}, // #3928
  { 9,  1}, // #3929
  {10,  1}, // #3930
  {11,  1}, // #3931
  {12,  2}, // #3932
  { 5,  1}, // #3933
  {10,  1}, // #3934
  {12,  2}, // #3935
  {10,  1}, // #3936
  {12,  1}, // #3937
  { 5,  1}, // #3938
  {10,  2}, // #3939
  {11,  3}, // #3940
  {12,  6}, // #3941
  { 8,  1}, // #3942
  {10,  1}, // #3943
  {11,  2}, // #3944
  {12,  3}, // #3945
  { 5,  1}, // #3946
  {10,  2}, // #3947
  {11,  1}, // #3948
  {12,  4}, // #3949
  { 4,  1}, // #3950
  { 7,  1}, // #3951
  { 9,  1}, // #3952
  {10,  1}, // #3953
  {11,  1}, // #3954
  {12,  2}, // #3955
  { 6,  1}, // #3956
  { 8,  1}, // #3957
  { 9,  1}, // #3958
  {10,  1}, // #3959
  {11,  2}, // #3960
  {12,  3}, // #3961
  { 6,  1}, // #3962
  { 8,  1}, // #3963
  { 9,  1}, // #3964
  {11,  2}, // #3965
  {12,  2}, // #3966
  { 6,  2}, // #3967
  { 8,  2}, // #3968
  { 9,  2}, // #3969
  {10,  1}, // #3970
  {11,  2}, // #3971
  {12,  3}, // #3972
  { 6,  2}, // #3973
  { 8,  2}, // #3974
  { 9,  2}, // #3975
  {11,  2}, // #3976
  {12,  2}, // #3977
  {10,  1}, // #3978
  {11, 10}, // #3979
  {12, 11}, // #3980
  {11, 11}, // #3981
  {12, 11}, // #3982
  { 4,  1}, // #3983
  { 7,  1}, // #3984
  { 8,  1}, // #3985
  { 9,  1}, // #3986
  {10,  1}, // #3987
  {11,  2}, // #3988
  {12,  3}, // #3989
  { 4,  1}, // #3990
  { 7,  1}, // #3991
  { 8,  1}, // #3992
  { 9,  1}, // #3993
  {11,  2}, // #3994
  {12,  2}, // #3995
  { 8,  1}, // #3996
  {10,  1}, // #3997
  {11,  1}, // #3998
  {12,  2}, // #3999
  { 8,  2}, // #4000
  {10,  1}, // #4001
  {11,  2}, // #4002
  {12,  3}, // #4003
  { 8,  2}, // #4004
  {11,  2}, // #4005
  {12,  2}, // #4006
  { 5,  1}, // #4007
  { 6,  1}, // #4008
  { 8,  2}, // #4009
  { 9,  1}, // #4010
  {10,  2}, // #4011
  {11,  3}, // #4012
  {12,  6}, // #4013
  { 5,  1}, // #4014
  { 8,  1}, // #4015
  {10,  2}, // #4016
  {11,  1}, // #4017
  {12,  4}, // #4018
  { 6,  2}, // #4019
  { 8,  3}, // #4020
  { 9,  2}, // #4021
  {11,  3}, // #4022
  {12,  3}, // #4023
  { 8,  1}, // #4024
  {11,  4}, // #4025
  {12,  4}, // #4026
  { 4,  1}, // #4027
  { 6,  1}, // #4028
  { 7,  1}, // #4029
  { 8,  1}, // #4030
  { 9,  2}, // #4031
  {10,  1}, // #4032
  {11,  2}, // #4033
  {12,  3}, // #4034
  { 4,  1}, // #4035
  { 6,  1}, // #4036
  { 7,  1}, // #4037
  { 8,  1}, // #4038
  { 9,  2}, // #4039
  {11,  2}, // #4040
  {12,  2}, // #4041
  { 3,  1}, // #4042
  { 7,  1}, // #4043
  { 8,  1}, // #4044
  {10,  1}, // #4045
  {11,  1}, // #4046
  {12,  2}, // #4047
  { 3,  1}, // #4048
  { 6,  1}, // #4049
  { 7,  1}, // #4050
  { 8,  2}, // #4051
  { 9,  1}, // #4052
  {11,  2}, // #4053
  {12,  2}, // #4054
  { 3,  1}, // #4055
  { 4,  1}, // #4056
  { 7,  2}, // #4057
  { 8,  1}, // #4058
  { 9,  1}, // #4059
  {10,  1}, // #4060
  {11,  2}, // #4061
  {12,  3}, // #4062
  { 3,  1}, // #4063
  { 4,  1}, // #4064
  { 7,  2}, // #4065
  { 8,  1}, // #4066
  { 9,  1}, // #4067
  {11,  2}, // #4068
  {12,  2}, // #4069
  { 4,  1}, // #4070
  { 6,  2}, // #4071
  { 7,  1}, // #4072
  { 8,  2}, // #4073
  { 9,  3}, // #4074
  {11,  3}, // #4075
  {12,  3}, // #4076
  { 3,  1}, // #4077
  { 7,  1}, // #4078
  { 8,  1}, // #4079
  {11,  1}, // #4080
  {12,  1}, // #4081
  { 1, 10}, // #4082
  { 3,  1}, // #4083
  { 7,  1}, // #4084
  { 8,  1}, // #4085
  {10,  1}, // #4086
  {11,  1}, // #4087
  {12,  2}, // #4088
  { 1, 10}, // #4089
  { 3,  1}, // #4090
  { 7,  1}, // #4091
  { 8,  1}, // #4092
  {11,  1}, // #4093
  {12,  1}, // #4094
  { 2, 22}, // #4095
  { 3,  1}, // #4096
  { 7,  1}, // #4097
  { 8,  1}, // #4098
  {10,  1}, // #4099
  {11,  1}, // #4100
  {12,  2}, // #4101
  { 2, 22}, // #4102
  { 3,  1}, // #4103
  { 7,  1}, // #4104
  { 8,  1}, // #4105
  {11,  1}, // #4106
  {12,  1}, // #4107
  { 2, 14}, // #4108
  { 3,  1}, // #4109
  { 7,  1}, // #4110
  { 8,  1}, // #4111
  {10,  1}, // #4112
  {11,  1}, // #4113
  {12,  2}, // #4114
  { 2, 14}, // #4115
  { 3,  1}, // #4116
  { 7,  1}, // #4117
  { 8,  1}, // #4118
  {11,  1}, // #4119
  {12,  1}, // #4120
  { 3,  1}, // #4121
  { 4,  1}, // #4122
  { 6,  1}, // #4123
  { 7,  2}, // #4124
  { 8,  2}, // #4125
  { 9,  2}, // #4126
  {10,  1}, // #4127
  {11,  3}, // #4128
  {12,  4}, // #4129
  { 3,  1}, // #4130
  { 4,  1}, // #4131
  { 6,  1}, // #4132
  { 7,  2}, // #4133
  { 8,  2}, // #4134
  { 9,  2}, // #4135
  {11,  3}, // #4136
  {12,  3}, // #4137
  { 3,  1}, // #4138
  { 4,  2}, // #4139
  { 6,  1}, // #4140
  { 7,  3}, // #4141
  { 8,  2}, // #4142
  { 9,  3}, // #4143
  {10,  1}, // #4144
  {11,  4}, // #4145
  {12,  5}, // #4146
  { 3,  1}, // #4147
  { 4,  2}, // #4148
  { 6,  1}, // #4149
  { 7,  3}, // #4150
  { 8,  2}, // #4151
  { 9,  3}, // #4152
  {11,  4}, // #4153
  {12,  4}, // #4154
  { 5,  1}, // #4155
  { 9,  1}, // #4156
  {10,  1}, // #4157
  {11,  1}, // #4158
  {12,  3}, // #4159
  { 3,  1}, // #4160
  { 7,  1}, // #4161
  { 8,  1}, // #4162
  { 9,  1}, // #4163
  {11,  2}, // #4164
  {12,  2}, // #4165
  {11, 31}, // #4166
  {12, 31}, // #4167
  { 4,  1}, // #4168
  { 6,  2}, // #4169
  { 7,  1}, // #4170
  { 8,  2}, // #4171
  { 9,  3}, // #4172
  {10,  1}, // #4173
  {11,  3}, // #4174
  {12,  4}, // #4175
  { 4,  1}, // #4176
  { 7,  1}, // #4177
  { 8,  1}, // #4178
  { 9,  1}, // #4179
  {10,  1}, // #4180
  {11,  4}, // #4181
  {12,  5}, // #4182
  { 4,  1}, // #4183
  { 7,  1}, // #4184
  { 8,  1}, // #4185
  { 9,  1}, // #4186
  {11,  4}, // #4187
  {12,  4}, // #4188
  { 4,  1}, // #4189
  { 7,  1}, // #4190
  { 9,  1}, // #4191
  {10,  1}, // #4192
  {11,  2}, // #4193
  {12,  3}, // #4194
  { 4,  1}, // #4195
  { 7,  1}, // #4196
  { 9,  1}, // #4197
  {11,  2}, // #4198
  {12,  2}, // #4199
  { 4,  1}, // #4200
  { 7,  1}, // #4201
  { 8,  1}, // #4202
  { 9,  1}, // #4203
  {10,  1}, // #4204
  {11,  3}, // #4205
  {12,  4}, // #4206
  { 4,  1}, // #4207
  { 7,  1}, // #4208
  { 8,  1}, // #4209
  { 9,  1}, // #4210
  {11,  3}, // #4211
  {12,  3}, // #4212
  { 3,  1}, // #4213
  { 5,  1}, // #4214
  { 6,  1}, // #4215
  { 7,  1}, // #4216
  { 8,  2}, // #4217
  { 9,  1}, // #4218
  {10,  1}, // #4219
  {11,  2}, // #4220
  {12,  4}, // #4221
  { 6,  1}, // #4222
  { 8,  1}, // #4223
  { 9,  2}, // #4224
  {11,  2}, // #4225
  {12,  2}, // #4226
  { 3,  1}, // #4227
  { 7,  1}, // #4228
  { 8,  1}, // #4229
  { 9,  2}, // #4230
  {10,  1}, // #4231
  {11,  3}, // #4232
  {12,  4}, // #4233
  { 3,  1}, // #4234
  { 7,  1}, // #4235
  { 8,  1}, // #4236
  { 9,  2}, // #4237
  {11,  3}, // #4238
  {12,  3}, // #4239
  {10,  1}, // #4240
  {11, 17}, // #4241
  {12, 18}, // #4242
  {11, 18}, // #4243
  {12, 18}, // #4244
  {10,  1}, // #4245
  {11,  7}, // #4246
  {12,  8}, // #4247
  {11,  8}, // #4248
  {12,  8}, // #4249
  { 3,  3}, // #4250
  { 7,  3}, // #4251
  { 8,  3}, // #4252
  {10,  1}, // #4253
  {11,  3}, // #4254
  {12,  4}, // #4255
  { 3,  3}, // #4256
  { 7,  3}, // #4257
  { 8,  3}, // #4258
  {11,  3}, // #4259
  {12,  3}, // #4260
  { 5,  1}, // #4261
  {10,  2}, // #4262
  {12,  3}, // #4263
  { 3,  1}, // #4264
  { 7,  1}, // #4265
  { 8,  1}, // #4266
  { 9,  1}, // #4267
  {10,  1}, // #4268
  {11,  2}, // #4269
  {12,  3}, // #4270
  { 3,  1}, // #4271
  { 6,  1}, // #4272
  { 7,  1}, // #4273
  { 8,  2}, // #4274
  { 9,  1}, // #4275
  {10,  1}, // #4276
  {11,  2}, // #4277
  {12,  3}, // #4278
  { 5,  1}, // #4279
  { 8,  2}, // #4280
  {10,  2}, // #4281
  {11,  2}, // #4282
  {12,  5}, // #4283
  { 5,  1}, // #4284
  { 8,  3}, // #4285
  {10,  2}, // #4286
  {11,  3}, // #4287
  {12,  6}, // #4288
  { 5,  1}, // #4289
  { 8,  1}, // #4290
  {10,  1}, // #4291
  {11,  1}, // #4292
  {12,  3}, // #4293
  { 5,  1}, // #4294
  { 8,  3}, // #4295
  {10,  2}, // #4296
  {11,  4}, // #4297
  {12,  7}, // #4298
  { 5,  1}, // #4299
  { 8,  1}, // #4300
  {10,  2}, // #4301
  {11,  2}, // #4302
  {12,  5}, // #4303
  { 2, 21}, // #4304
  { 3,  1}, // #4305
  { 7,  1}, // #4306
  { 8,  1}, // #4307
  {10,  1}, // #4308
  {11,  1}, // #4309
  {12,  2}, // #4310
  { 2, 21}, // #4311
  { 3,  1}, // #4312
  { 7,  1}, // #4313
  { 8,  1}, // #4314
  {11,  1}, // #4315
  {12,  1}, // #4316
  { 2, 24}, // #4317
  { 3,  1}, // #4318
  { 7,  1}, // #4319
  { 8,  1}, // #4320
  {11,  1}, // #4321
  {12,  1}, // #4322
  { 7,  1}, // #4323
  {10,  1}, // #4324
  {11,  1}, // #4325
  {12,  2}, // #4326
  { 4,  1}, // #4327
  { 5,  1}, // #4328
  { 7,  1}, // #4329
  { 9,  1}, // #4330
  {10,  1}, // #4331
  {11,  1}, // #4332
  {12,  3}, // #4333
  { 2, 44}, // #4334
  { 3,  2}, // #4335
  { 7,  2}, // #4336
  { 8,  3}, // #4337
  {10,  1}, // #4338
  {11,  3}, // #4339
  {12,  4}, // #4340
  { 2, 44}, // #4341
  { 3,  2}, // #4342
  { 7,  2}, // #4343
  { 8,  3}, // #4344
  {11,  3}, // #4345
  {12,  3}, // #4346
  { 2, 28}, // #4347
  { 3,  2}, // #4348
  { 7,  2}, // #4349
  { 8,  3}, // #4350
  {10,  1}, // #4351
  {11,  3}, // #4352
  {12,  4}, // #4353
  { 2, 28}, // #4354
  { 3,  2}, // #4355
  { 7,  2}, // #4356
  { 8,  3}, // #4357
  {11,  3}, // #4358
  {12,  3}, // #4359
  { 5,  1}, // #4360
  { 7,  1}, // #4361
  {10,  1}, // #4362
  {11,  1}, // #4363
  {12,  3}, // #4364
  { 8,  7}, // #4365
  {10,  4}, // #4366
  {11,  7}, // #4367
  {12, 11}, // #4368
  { 5,  1}, // #4369
  {10,  2}, // #4370
  {11,  2}, // #4371
  {12,  5}, // #4372
  { 6,  1}, // #4373
  { 7,  1}, // #4374
  { 8,  1}, // #4375
  { 9,  1}, // #4376
  {10,  1}, // #4377
  {11,  2}, // #4378
  {12,  3}, // #4379
  { 5,  1}, // #4380
  { 6,  2}, // #4381
  { 8,  2}, // #4382
  { 9,  2}, // #4383
  {10,  2}, // #4384
  {11,  2}, // #4385
  {12,  5}, // #4386
  { 4,  1}, // #4387
  { 5,  1}, // #4388
  { 7,  1}, // #4389
  { 9,  1}, // #4390
  {10,  2}, // #4391
  {11,  1}, // #4392
  {12,  4}, // #4393
  { 5,  1}, // #4394
  { 6,  1}, // #4395
  { 8,  1}, // #4396
  { 9,  1}, // #4397
  {10,  2}, // #4398
  {11,  1}, // #4399
  {12,  4}, // #4400
  { 6,  1}, // #4401
  { 8,  1}, // #4402
  { 9,  1}, // #4403
  {11,  4}, // #4404
  {12,  4}, // #4405
  { 5,  1}, // #4406
  { 6,  2}, // #4407
  { 7,  1}, // #4408
  { 8,  2}, // #4409
  { 9,  2}, // #4410
  {10,  1}, // #4411
  {11,  3}, // #4412
  {12,  5}, // #4413
  { 3,  1}, // #4414
  { 7,  1}, // #4415
  { 8,  1}, // #4416
  {11,  2}, // #4417
  {12,  2}, // #4418
  { 8,  2}, // #4419
  {11,  3}, // #4420
  {12,  3}, // #4421
  { 4,  1}, // #4422
  { 6,  1}, // #4423
  { 7,  1}, // #4424
  { 8,  5}, // #4425
  { 9,  2}, // #4426
  {11,  8}, // #4427
  {12,  8}, // #4428
  { 8,  8}, // #4429
  {11,  8}, // #4430
  {12,  8}, // #4431
  { 5,  1}, // #4432
  { 6,  1}, // #4433
  { 8,  1}, // #4434
  { 9,  1}, // #4435
  {10,  1}, // #4436
  {11,  1}, // #4437
  {12,  3}, // #4438
  { 5,  1}, // #4439
  {10,  1}, // #4440
  {11,  1}, // #4441
  {12,  3}, // #4442
  { 3,  1}, // #4443
  { 5,  1}, // #4444
  { 7,  1}, // #4445
  { 8,  1}, // #4446
  { 9,  1}, // #4447
  {10,  1}, // #4448
  {11,  2}, // #4449
  {12,  4}, // #4450
  { 5,  1}, // #4451
  { 6,  1}, // #4452
  { 7,  1}, // #4453
  { 8,  1}, // #4454
  { 9,  1}, // #4455
  {10,  1}, // #4456
  {11,  2}, // #4457
  {12,  4}, // #4458
  { 3,  1}, // #4459
  { 5,  1}, // #4460
  { 7,  1}, // #4461
  { 8,  1}, // #4462
  {10,  2}, // #4463
  {11,  1}, // #4464
  {12,  4}, // #4465
  { 4,  1}, // #4466
  { 6,  2}, // #4467
  { 7,  1}, // #4468
  { 8,  2}, // #4469
  { 9,  3}, // #4470
  {11,  4}, // #4471
  {12,  4}, // #4472
  {10,  2}, // #4473
  {11,  3}, // #4474
  {12,  5}, // #4475
  { 5,  1}, // #4476
  { 6,  1}, // #4477
  { 7,  1}, // #4478
  { 8,  1}, // #4479
  { 9,  1}, // #4480
  {10,  2}, // #4481
  {11,  2}, // #4482
  {12,  5}, // #4483
  { 5,  1}, // #4484
  { 8,  2}, // #4485
  {10,  2}, // #4486
  {11,  3}, // #4487
  {12,  6}, // #4488
  { 4,  2}, // #4489
  { 7,  2}, // #4490
  { 9,  2}, // #4491
  {10,  1}, // #4492
  {11,  2}, // #4493
  {12,  3}, // #4494
  { 8,  2}, // #4495
  {10,  1}, // #4496
  {11,  3}, // #4497
  {12,  4}, // #4498
  { 5,  1}, // #4499
  { 8,  2}, // #4500
  {10,  1}, // #4501
  {11,  2}, // #4502
  {12,  4}, // #4503
  { 3,  1}, // #4504
  { 4,  1}, // #4505
  { 8,  1}, // #4506
  { 9,  1}, // #4507
  {11,  2}, // #4508
  {12,  1}, // #4509
  {13,  2}, // #4510
  {14,  2}, // #4511
  {15,  2}, // #4512
  {16,  2}, // #4513
  {18,  2}, // #4514
  {19,  3}, // #4515
  {20,  3}, // #4516
  {22,  4}, // #4517
  {23,  4}, // #4518
  { 4,  1}, // #4519
  { 9,  1}, // #4520
  {11,  1}, // #4521
  {14,  1}, // #4522
  {15,  1}, // #4523
  {16,  2}, // #4524
  {17,  1}, // #4525
  {18,  1}, // #4526
  {19,  1}, // #4527
  {20,  1}, // #4528
  {21,  1}, // #4529
  {22,  2}, // #4530
  {23,  3}, // #4531
  { 4,  1}, // #4532
  { 9,  1}, // #4533
  {11,  1}, // #4534
  {14,  1}, // #4535
  {15,  1}, // #4536
  {16,  2}, // #4537
  {18,  1}, // #4538
  {19,  1}, // #4539
  {20,  1}, // #4540
  {22,  2}, // #4541
  {23,  2}, // #4542
  { 2, 17}, // #4543
  { 3,  1}, // #4544
  {11,  1}, // #4545
  {12,  1}, // #4546
  {13,  1}, // #4547
  {14,  1}, // #4548
  {19,  1}, // #4549
  {20,  1}, // #4550
  {22,  1}, // #4551
  {23,  1}, // #4552
  { 4,  1}, // #4553
  { 7,  1}, // #4554
  { 8,  1}, // #4555
  {11,  1}, // #4556
  {12,  1}, // #4557
  {13,  1}, // #4558
  {15,  2}, // #4559
  {16,  1}, // #4560
  {18,  1}, // #4561
  {19,  2}, // #4562
  {20,  1}, // #4563
  {21,  1}, // #4564
  {22,  2}, // #4565
  {23,  4}, // #4566
  { 2, 28}, // #4567
  { 3,  2}, // #4568
  {11,  2}, // #4569
  {12,  2}, // #4570
  {13,  2}, // #4571
  {14,  2}, // #4572
  {15,  1}, // #4573
  {17,  1}, // #4574
  {19,  3}, // #4575
  {20,  2}, // #4576
  {21,  1}, // #4577
  {22,  3}, // #4578
  {23,  4}, // #4579
  { 2, 28}, // #4580
  { 3,  2}, // #4581
  {11,  2}, // #4582
  {12,  2}, // #4583
  {13,  2}, // #4584
  {14,  2}, // #4585
  {15,  1}, // #4586
  {19,  3}, // #4587
  {20,  2}, // #4588
  {22,  3}, // #4589
  {23,  3}, // #4590
  { 2, 14}, // #4591
  { 3,  2}, // #4592
  {11,  2}, // #4593
  {12,  2}, // #4594
  {13,  2}, // #4595
  {14,  2}, // #4596
  {15,  1}, // #4597
  {17,  1}, // #4598
  {19,  3}, // #4599
  {20,  2}, // #4600
  {21,  1}, // #4601
  {22,  3}, // #4602
  {23,  4}, // #4603
  { 2, 14}, // #4604
  { 3,  2}, // #4605
  {11,  2}, // #4606
  {12,  2}, // #4607
  {13,  2}, // #4608
  {14,  2}, // #4609
  {15,  1}, // #4610
  {19,  3}, // #4611
  {20,  2}, // #4612
  {22,  3}, // #4613
  {23,  3}, // #4614
  { 4,  2}, // #4615
  {11,  2}, // #4616
  {15,  2}, // #4617
  {16,  2}, // #4618
  {19,  2}, // #4619
  {22,  2}, // #4620
  {23,  2}, // #4621
  { 3,  2}, // #4622
  { 4,  1}, // #4623
  { 8,  2}, // #4624
  { 9,  4}, // #4625
  {11,  5}, // #4626
  {12,  2}, // #4627
  {13,  4}, // #4628
  {14,  6}, // #4629
  {15,  3}, // #4630
  {16,  5}, // #4631
  {18,  6}, // #4632
  {19,  7}, // #4633
  {20,  8}, // #4634
  {22, 15}, // #4635
  {23, 15}, // #4636
  { 7,  1}, // #4637
  {12,  1}, // #4638
  {17,  2}, // #4639
  {21,  2}, // #4640
  {22,  2}, // #4641
  {23,  5}, // #4642
  {17,  1}, // #4643
  {21,  1}, // #4644
  {22, 14}, // #4645
  {23, 15}, // #4646
  {17,  2}, // #4647
  {21,  2}, // #4648
  {22,  3}, // #4649
  {23,  5}, // #4650
  { 9,  2}, // #4651
  {14,  2}, // #4652
  {16,  2}, // #4653
  {17,  1}, // #4654
  {18,  2}, // #4655
  {19,  1}, // #4656
  {20,  2}, // #4657
  {21,  1}, // #4658
  {22,  3}, // #4659
  {23,  4}, // #4660
  {17,  1}, // #4661
  {19, 16}, // #4662
  {21,  1}, // #4663
  {22, 16}, // #4664
  {23, 17}, // #4665
  { 3,  2}, // #4666
  { 8,  2}, // #4667
  {11,  2}, // #4668
  {12,  2}, // #4669
  {13,  4}, // #4670
  {14,  4}, // #4671
  {15,  3}, // #4672
  {17,  2}, // #4673
  {18,  2}, // #4674
  {19,  8}, // #4675
  {20,  6}, // #4676
  {21,  2}, // #4677
  {22, 10}, // #4678
  {23, 12}, // #4679
  { 3,  3}, // #4680
  { 8,  3}, // #4681
  {11,  3}, // #4682
  {12,  3}, // #4683
  {13,  6}, // #4684
  {14,  7}, // #4685
  {15,  4}, // #4686
  {17,  4}, // #4687
  {18,  3}, // #4688
  {19, 12}, // #4689
  {20, 10}, // #4690
  {21,  4}, // #4691
  {22, 16}, // #4692
  {23, 20}, // #4693
  { 3,  5}, // #4694
  { 8,  3}, // #4695
  {11,  5}, // #4696
  {12,  5}, // #4697
  {13,  8}, // #4698
  {14, 13}, // #4699
  {15,  4}, // #4700
  {17,  8}, // #4701
  {18,  3}, // #4702
  {19, 18}, // #4703
  {20, 16}, // #4704
  {21,  8}, // #4705
  {22, 26}, // #4706
  {23, 34}, // #4707
  { 3,  3}, // #4708
  { 8,  3}, // #4709
  {11,  3}, // #4710
  {12,  3}, // #4711
  {13,  6}, // #4712
  {14,  5}, // #4713
  {15,  4}, // #4714
  {17,  2}, // #4715
  {18,  3}, // #4716
  {19, 10}, // #4717
  {20,  8}, // #4718
  {21,  2}, // #4719
  {22, 12}, // #4720
  {23, 14}, // #4721
  { 3,  5}, // #4722
  { 8,  3}, // #4723
  {11,  5}, // #4724
  {12,  5}, // #4725
  {13,  8}, // #4726
  {14,  9}, // #4727
  {15,  4}, // #4728
  {17,  4}, // #4729
  {18,  3}, // #4730
  {19, 14}, // #4731
  {20, 12}, // #4732
  {21,  4}, // #4733
  {22, 18}, // #4734
  {23, 22}, // #4735
  { 3,  3}, // #4736
  { 8,  3}, // #4737
  {11,  3}, // #4738
  {12,  3}, // #4739
  {13,  6}, // #4740
  {14,  5}, // #4741
  {15,  4}, // #4742
  {17,  2}, // #4743
  {18,  3}, // #4744
  {19, 11}, // #4745
  {20,  8}, // #4746
  {21,  2}, // #4747
  {22, 13}, // #4748
  {23, 15}, // #4749
  {14,  1}, // #4750
  {17,  1}, // #4751
  {20,  1}, // #4752
  {21,  1}, // #4753
  {22,  3}, // #4754
  {23,  4}, // #4755
  { 5,  2}, // #4756
  { 6,  2}, // #4757
  {10,  1}, // #4758
  { 5,  1}, // #4759
  { 6,  1}, // #4760
  {10,  1}, // #4761
  { 4,  5}, // #4762
  { 6,  5}, // #4763
  {10,  1}, // #4764
  { 4,  1}, // #4765
  { 6,  1}, // #4766
  {10,  1}, // #4767
  { 4,  4}, // #4768
  { 6,  4}, // #4769
  {10,  1}, // #4770
  { 7, 10}, // #4771
  { 8, 10}, // #4772
  { 9, 20}, // #4773
  {10,  1}, // #4774
  { 7,  1}, // #4775
  { 8,  1}, // #4776
  { 9,  2}, // #4777
  {10,  2}, // #4778
  { 4,  2}, // #4779
  { 6,  2}, // #4780
  {10,  1}, // #4781
  { 1, 25}, // #4782
  { 9,  1}, // #4783
  {10,  1}, // #4784
  { 2, 69}, // #4785
  { 4,  1}, // #4786
  { 6,  1}, // #4787
  {10,  1}, // #4788
  { 2, 39}, // #4789
  { 4,  1}, // #4790
  { 6,  1}, // #4791
  {10,  1}, // #4792
  { 2, 17}, // #4793
  { 4,  1}, // #4794
  { 6,  1}, // #4795
  {10,  1}, // #4796
  { 2, 32}, // #4797
  { 4,  1}, // #4798
  { 6,  1}, // #4799
  {10,  1}, // #4800
  { 5,  8}, // #4801
  { 6,  8}, // #4802
  {10,  1}, // #4803
  { 5, 12}, // #4804
  { 6, 12}, // #4805
  {10,  1}, // #4806
  { 4,  1}, // #4807
  { 6,  1}, // #4808
  {10,  2}, // #4809
  { 6, 10}, // #4810
  { 5,  6}, // #4811
  { 6,  6}, // #4812
  {10,  1}, // #4813
  { 8,  5}, // #4814
  { 9,  5}, // #4815
  {10,  1}, // #4816
  { 8,  4}, // #4817
  { 9,  4}, // #4818
  {10,  1}, // #4819
  { 8,  7}, // #4820
  { 9,  7}, // #4821
  {10,  1}, // #4822
  { 3,  4}, // #4823
  { 4,  1}, // #4824
  { 6,  1}, // #4825
  {10,  1}, // #4826
  { 3,  2}, // #4827
  { 4,  1}, // #4828
  { 6,  1}, // #4829
  {10,  1}, // #4830
  { 4, 10}, // #4831
  { 6, 10}, // #4832
  {10,  1}, // #4833
  { 4, 21}, // #4834
  { 6, 21}, // #4835
  {10,  1}, // #4836
  { 4, 17}, // #4837
  { 6, 17}, // #4838
  {10,  1}, // #4839
  { 4, 13}, // #4840
  { 6, 13}, // #4841
  {10,  1}, // #4842
  { 4, 11}, // #4843
  { 6, 11}, // #4844
  {10,  1}, // #4845
  { 4,  8}, // #4846
  { 6,  8}, // #4847
  {10,  1}, // #4848
  { 2, 70}, // #4849
  { 4,  1}, // #4850
  { 6,  1}, // #4851
  {10,  1}, // #4852
  { 2, 40}, // #4853
  { 4,  1}, // #4854
  { 6,  1}, // #4855
  {10,  1}, // #4856
  { 2, 35}, // #4857
  { 4,  1}, // #4858
  { 6,  1}, // #4859
  {10,  1}, // #4860
  { 2, 20}, // #4861
  { 4,  1}, // #4862
  { 6,  1}, // #4863
  {10,  1}, // #4864
  {26,  1}, // #4865
  {27,  1}, // #4866
  {15,  1}, // #4867
  {23,  1}, // #4868
  {24,  1}, // #4869
  {26,  1}, // #4870
  {27,  1}, // #4871
  {16,  1}, // #4872
  {24,  1}, // #4873
  {26,  1}, // #4874
  {27,  1}, // #4875
  { 7,  1}, // #4876
  {14,  1}, // #4877
  {16,  2}, // #4878
  {19,  1}, // #4879
  {20,  1}, // #4880
  {24,  2}, // #4881
  {25,  2}, // #4882
  {26,  3}, // #4883
  {27,  6}, // #4884
  {16,  1}, // #4885
  {19,  1}, // #4886
  {24,  1}, // #4887
  {25,  1}, // #4888
  {26,  1}, // #4889
  {27,  2}, // #4890
  { 4,  1}, // #4891
  {13,  1}, // #4892
  {17,  1}, // #4893
  {18,  1}, // #4894
  {23,  1}, // #4895
  {26,  1}, // #4896
  {27,  1}, // #4897
  { 7,  1}, // #4898
  {14,  1}, // #4899
  {20,  1}, // #4900
  {25,  1}, // #4901
  {27,  2}, // #4902
  {19,  1}, // #4903
  {25,  1}, // #4904
  {27,  1}, // #4905
  { 3,  1}, // #4906
  {13,  1}, // #4907
  {14,  1}, // #4908
  {15,  1}, // #4909
  {16,  1}, // #4910
  {23,  1}, // #4911
  {24,  1}, // #4912
  {26,  1}, // #4913
  {27,  1}, // #4914
  { 7,  1}, // #4915
  {14,  1}, // #4916
  {19,  1}, // #4917
  {20,  1}, // #4918
  {25,  2}, // #4919
  {26,  1}, // #4920
  {27,  4}, // #4921
  {19,  1}, // #4922
  {25,  1}, // #4923
  {26,  1}, // #4924
  {27,  2}, // #4925
  {13,  1}, // #4926
  {19,  1}, // #4927
  {23,  1}, // #4928
  {25,  1}, // #4929
  {26,  1}, // #4930
  {27,  2}, // #4931
  {13,  1}, // #4932
  {23,  1}, // #4933
  {26,  1}, // #4934
  {27,  1}, // #4935
  { 3,  1}, // #4936
  {13,  1}, // #4937
  {14,  1}, // #4938
  {15,  1}, // #4939
  {16,  1}, // #4940
  {19,  1}, // #4941
  {23,  1}, // #4942
  {24,  1}, // #4943
  {25,  1}, // #4944
  {26,  1}, // #4945
  {27,  2}, // #4946
  { 3,  2}, // #4947
  {13,  2}, // #4948
  {14,  2}, // #4949
  {15,  2}, // #4950
  {16,  2}, // #4951
  {19,  1}, // #4952
  {23,  2}, // #4953
  {24,  2}, // #4954
  {25,  1}, // #4955
  {26,  2}, // #4956
  {27,  3}, // #4957
  { 3,  2}, // #4958
  {13,  2}, // #4959
  {14,  2}, // #4960
  {15,  2}, // #4961
  {16,  2}, // #4962
  {23,  2}, // #4963
  {24,  2}, // #4964
  {26,  2}, // #4965
  {27,  2}, // #4966
  { 3,  3}, // #4967
  { 8,  6}, // #4968
  {13,  3}, // #4969
  {14,  3}, // #4970
  {15,  9}, // #4971
  {16,  3}, // #4972
  {17,  6}, // #4973
  {19,  1}, // #4974
  {21,  6}, // #4975
  {23, 10}, // #4976
  {24,  9}, // #4977
  {25,  1}, // #4978
  {26, 10}, // #4979
  {27, 11}, // #4980
  { 3,  3}, // #4981
  { 8,  6}, // #4982
  {13,  3}, // #4983
  {14,  3}, // #4984
  {15,  9}, // #4985
  {16,  3}, // #4986
  {17,  6}, // #4987
  {21,  6}, // #4988
  {23, 11}, // #4989
  {24,  9}, // #4990
  {26, 11}, // #4991
  {27, 11}, // #4992
  {16,  1}, // #4993
  {17,  1}, // #4994
  {19,  1}, // #4995
  {23,  1}, // #4996
  {24,  1}, // #4997
  {25,  1}, // #4998
  {26,  2}, // #4999
  {27,  3}, // #5000
  {16,  1}, // #5001
  {17,  1}, // #5002
  {23,  1}, // #5003
  {24,  1}, // #5004
  {26,  2}, // #5005
  {27,  2}, // #5006
  {19,  1}, // #5007
  {23,  2}, // #5008
  {25,  1}, // #5009
  {26,  2}, // #5010
  {27,  3}, // #5011
  {23,  2}, // #5012
  {26,  2}, // #5013
  {27,  2}, // #5014
  {17,  1}, // #5015
  {19,  1}, // #5016
  {23,  1}, // #5017
  {25,  1}, // #5018
  {26,  1}, // #5019
  {27,  2}, // #5020
  {17,  1}, // #5021
  {23,  1}, // #5022
  {26,  1}, // #5023
  {27,  1}, // #5024
  { 4,  1}, // #5025
  {13,  1}, // #5026
  {17,  1}, // #5027
  {18,  1}, // #5028
  {19,  1}, // #5029
  {23,  1}, // #5030
  {25,  1}, // #5031
  {26,  1}, // #5032
  {27,  2}, // #5033
  { 7,  1}, // #5034
  {14,  1}, // #5035
  {16,  1}, // #5036
  {19,  1}, // #5037
  {20,  1}, // #5038
  {24,  1}, // #5039
  {25,  2}, // #5040
  {26,  1}, // #5041
  {27,  4}, // #5042
  {16,  2}, // #5043
  {24,  2}, // #5044
  {26,  5}, // #5045
  {27,  5}, // #5046
  {13,  2}, // #5047
  {19,  1}, // #5048
  {23,  2}, // #5049
  {25,  1}, // #5050
  {26,  2}, // #5051
  {27,  3}, // #5052
  {13,  2}, // #5053
  {23,  2}, // #5054
  {26,  2}, // #5055
  {27,  2}, // #5056
  { 1, 10}, // #5057
  { 3,  1}, // #5058
  {13,  1}, // #5059
  {14,  1}, // #5060
  {15,  1}, // #5061
  {16,  1}, // #5062
  {19,  1}, // #5063
  {23,  1}, // #5064
  {24,  1}, // #5065
  {25,  1}, // #5066
  {26,  1}, // #5067
  {27,  2}, // #5068
  { 3,  7}, // #5069
  { 4,  2}, // #5070
  { 8,  8}, // #5071
  { 9,  3}, // #5072
  {13,  9}, // #5073
  {14,  7}, // #5074
  {15, 16}, // #5075
  {16, 10}, // #5076
  {17, 10}, // #5077
  {18,  5}, // #5078
  {21, 11}, // #5079
  {23, 18}, // #5080
  {24, 19}, // #5081
  {26, 32}, // #5082
  {27, 32}, // #5083
  { 1, 10}, // #5084
  { 3,  1}, // #5085
  {13,  1}, // #5086
  {14,  1}, // #5087
  {15,  1}, // #5088
  {16,  1}, // #5089
  {23,  1}, // #5090
  {24,  1}, // #5091
  {26,  1}, // #5092
  {27,  1}, // #5093
  { 2,  4}, // #5094
  { 3,  1}, // #5095
  {13,  1}, // #5096
  {14,  1}, // #5097
  {15,  1}, // #5098
  {16,  1}, // #5099
  {19,  1}, // #5100
  {23,  1}, // #5101
  {24,  1}, // #5102
  {25,  1}, // #5103
  {26,  1}, // #5104
  {27,  2}, // #5105
  { 2,  3}, // #5106
  { 3,  1}, // #5107
  {13,  1}, // #5108
  {14,  1}, // #5109
  {15,  1}, // #5110
  {16,  1}, // #5111
  {23,  1}, // #5112
  {24,  1}, // #5113
  {26,  1}, // #5114
  {27,  1}, // #5115
  { 2,  5}, // #5116
  { 3,  1}, // #5117
  {13,  1}, // #5118
  {14,  1}, // #5119
  {15,  1}, // #5120
  {16,  1}, // #5121
  {19,  1}, // #5122
  {23,  1}, // #5123
  {24,  1}, // #5124
  {25,  1}, // #5125
  {26,  1}, // #5126
  {27,  2}, // #5127
  { 2,  3}, // #5128
  { 3,  1}, // #5129
  {13,  1}, // #5130
  {14,  1}, // #5131
  {15,  1}, // #5132
  {16,  1}, // #5133
  {19,  1}, // #5134
  {23,  1}, // #5135
  {24,  1}, // #5136
  {25,  1}, // #5137
  {26,  1}, // #5138
  {27,  2}, // #5139
  { 8,  1}, // #5140
  {15,  1}, // #5141
  {17,  1}, // #5142
  {19,  1}, // #5143
  {21,  1}, // #5144
  {23,  3}, // #5145
  {24,  1}, // #5146
  {25,  1}, // #5147
  {26,  3}, // #5148
  {27,  4}, // #5149
  { 8,  1}, // #5150
  {15,  1}, // #5151
  {17,  1}, // #5152
  {21,  1}, // #5153
  {23,  3}, // #5154
  {24,  1}, // #5155
  {26,  3}, // #5156
  {27,  3}, // #5157
  { 8,  1}, // #5158
  {15,  1}, // #5159
  {17,  1}, // #5160
  {19,  1}, // #5161
  {21,  1}, // #5162
  {23,  4}, // #5163
  {24,  1}, // #5164
  {25,  1}, // #5165
  {26,  4}, // #5166
  {27,  5}, // #5167
  { 8,  1}, // #5168
  {15,  1}, // #5169
  {17,  1}, // #5170
  {21,  1}, // #5171
  {23,  4}, // #5172
  {24,  1}, // #5173
  {26,  4}, // #5174
  {27,  4}, // #5175
  { 7,  1}, // #5176
  { 8,  1}, // #5177
  {14,  1}, // #5178
  {15,  1}, // #5179
  {17,  1}, // #5180
  {20,  1}, // #5181
  {21,  1}, // #5182
  {23,  1}, // #5183
  {24,  1}, // #5184
  {25,  1}, // #5185
  {26,  1}, // #5186
  {27,  3}, // #5187
  { 3,  1}, // #5188
  { 8,  1}, // #5189
  {13,  1}, // #5190
  {14,  1}, // #5191
  {15,  2}, // #5192
  {16,  1}, // #5193
  {17,  1}, // #5194
  {21,  1}, // #5195
  {23,  2}, // #5196
  {24,  2}, // #5197
  {26,  2}, // #5198
  {27,  2}, // #5199
  {15,  9}, // #5200
  {23,  9}, // #5201
  {24,  9}, // #5202
  {26, 10}, // #5203
  {27, 10}, // #5204
  {15,  2}, // #5205
  {23,  2}, // #5206
  {24,  2}, // #5207
  {26,  2}, // #5208
  {27,  2}, // #5209
  { 8,  2}, // #5210
  {15,  2}, // #5211
  {17,  2}, // #5212
  {19,  1}, // #5213
  {21,  2}, // #5214
  {23,  3}, // #5215
  {24,  2}, // #5216
  {25,  1}, // #5217
  {26,  3}, // #5218
  {27,  4}, // #5219
  { 8,  2}, // #5220
  {15,  2}, // #5221
  {17,  2}, // #5222
  {21,  2}, // #5223
  {23,  3}, // #5224
  {24,  2}, // #5225
  {26,  3}, // #5226
  {27,  3}, // #5227
  { 3,  2}, // #5228
  { 8,  4}, // #5229
  {13,  2}, // #5230
  {14,  2}, // #5231
  {15,  6}, // #5232
  {16,  2}, // #5233
  {17,  4}, // #5234
  {19,  1}, // #5235
  {21,  4}, // #5236
  {23,  6}, // #5237
  {24,  6}, // #5238
  {25,  1}, // #5239
  {26,  7}, // #5240
  {27,  8}, // #5241
  { 3,  4}, // #5242
  { 4,  2}, // #5243
  { 8,  4}, // #5244
  { 9,  8}, // #5245
  {13,  6}, // #5246
  {14,  4}, // #5247
  {15,  8}, // #5248
  {16, 26}, // #5249
  {17,  6}, // #5250
  {18, 10}, // #5251
  {21, 12}, // #5252
  {23, 10}, // #5253
  {24, 30}, // #5254
  {26, 66}, // #5255
  {27, 66}, // #5256
  { 4,  1}, // #5257
  {13,  1}, // #5258
  {16,  1}, // #5259
  {17,  1}, // #5260
  {18,  1}, // #5261
  {19,  1}, // #5262
  {23,  1}, // #5263
  {24,  1}, // #5264
  {25,  1}, // #5265
  {26,  4}, // #5266
  {27,  5}, // #5267
  { 4,  1}, // #5268
  {13,  1}, // #5269
  {16,  1}, // #5270
  {17,  1}, // #5271
  {18,  1}, // #5272
  {23,  1}, // #5273
  {24,  1}, // #5274
  {26,  4}, // #5275
  {27,  4}, // #5276
  { 4,  1}, // #5277
  {13,  1}, // #5278
  {17,  1}, // #5279
  {18,  1}, // #5280
  {19,  1}, // #5281
  {23,  1}, // #5282
  {25,  1}, // #5283
  {26,  2}, // #5284
  {27,  3}, // #5285
  { 4,  1}, // #5286
  {13,  1}, // #5287
  {17,  1}, // #5288
  {18,  1}, // #5289
  {23,  1}, // #5290
  {26,  2}, // #5291
  {27,  2}, // #5292
  { 4,  1}, // #5293
  {13,  1}, // #5294
  {16,  1}, // #5295
  {17,  1}, // #5296
  {18,  1}, // #5297
  {19,  1}, // #5298
  {23,  1}, // #5299
  {24,  1}, // #5300
  {25,  1}, // #5301
  {26,  3}, // #5302
  {27,  4}, // #5303
  { 4,  1}, // #5304
  {13,  1}, // #5305
  {16,  1}, // #5306
  {17,  1}, // #5307
  {18,  1}, // #5308
  {23,  1}, // #5309
  {24,  1}, // #5310
  {26,  3}, // #5311
  {27,  3}, // #5312
  { 4,  1}, // #5313
  { 8,  1}, // #5314
  {13,  1}, // #5315
  {15,  1}, // #5316
  {17,  2}, // #5317
  {18,  1}, // #5318
  {19,  1}, // #5319
  {21,  1}, // #5320
  {23,  2}, // #5321
  {24,  1}, // #5322
  {25,  1}, // #5323
  {26,  2}, // #5324
  {27,  3}, // #5325
  { 4,  1}, // #5326
  { 8,  1}, // #5327
  {13,  1}, // #5328
  {15,  1}, // #5329
  {17,  2}, // #5330
  {18,  1}, // #5331
  {21,  1}, // #5332
  {23,  2}, // #5333
  {24,  1}, // #5334
  {26,  2}, // #5335
  {27,  2}, // #5336
  { 8,  1}, // #5337
  {15,  1}, // #5338
  {17,  1}, // #5339
  {21,  1}, // #5340
  {23,  1}, // #5341
  {24,  1}, // #5342
  {26,  1}, // #5343
  {27,  1}, // #5344
  { 3,  1}, // #5345
  {13,  1}, // #5346
  {14,  1}, // #5347
  {15,  1}, // #5348
  {16,  1}, // #5349
  {19,  1}, // #5350
  {23,  1}, // #5351
  {24,  1}, // #5352
  {25,  1}, // #5353
  {26,  2}, // #5354
  {27,  3}, // #5355
  { 7,  1}, // #5356
  {14,  1}, // #5357
  {19,  1}, // #5358
  {20,  1}, // #5359
  {25,  1}, // #5360
  {27,  2}, // #5361
  {15,  1}, // #5362
  {19,  1}, // #5363
  {23,  1}, // #5364
  {24,  1}, // #5365
  {25,  1}, // #5366
  {26,  1}, // #5367
  {27,  2}, // #5368
  { 8,  1}, // #5369
  {15,  1}, // #5370
  {17,  1}, // #5371
  {19,  1}, // #5372
  {21,  1}, // #5373
  {23,  1}, // #5374
  {24,  1}, // #5375
  {25,  1}, // #5376
  {26,  1}, // #5377
  {27,  2}, // #5378
  { 8,  2}, // #5379
  {15,  3}, // #5380
  {17,  2}, // #5381
  {19,  1}, // #5382
  {21,  2}, // #5383
  {23,  3}, // #5384
  {24,  3}, // #5385
  {25,  1}, // #5386
  {26,  3}, // #5387
  {27,  4}, // #5388
  { 8,  2}, // #5389
  {15,  3}, // #5390
  {17,  2}, // #5391
  {21,  2}, // #5392
  {23,  3}, // #5393
  {24,  3}, // #5394
  {26,  3}, // #5395
  {27,  3}, // #5396
  { 8,  2}, // #5397
  {15,  2}, // #5398
  {17,  2}, // #5399
  {21,  2}, // #5400
  {23,  2}, // #5401
  {24,  2}, // #5402
  {26,  2}, // #5403
  {27,  2}, // #5404
  { 8,  2}, // #5405
  {15,  2}, // #5406
  {17,  2}, // #5407
  {19,  1}, // #5408
  {21,  2}, // #5409
  {23,  2}, // #5410
  {24,  2}, // #5411
  {25,  1}, // #5412
  {26,  2}, // #5413
  {27,  3}, // #5414
  { 3,  4}, // #5415
  { 8,  3}, // #5416
  {13,  4}, // #5417
  {14,  4}, // #5418
  {15,  7}, // #5419
  {16,  4}, // #5420
  {17,  3}, // #5421
  {19,  1}, // #5422
  {21,  3}, // #5423
  {23,  7}, // #5424
  {24,  7}, // #5425
  {25,  1}, // #5426
  {26,  8}, // #5427
  {27,  9}, // #5428
  { 3,  4}, // #5429
  { 8,  3}, // #5430
  {13,  4}, // #5431
  {14,  4}, // #5432
  {15,  7}, // #5433
  {16,  4}, // #5434
  {17,  3}, // #5435
  {21,  3}, // #5436
  {23,  7}, // #5437
  {24,  7}, // #5438
  {26,  8}, // #5439
  {27,  8}, // #5440
  { 3,  4}, // #5441
  { 8,  3}, // #5442
  {13,  4}, // #5443
  {14,  4}, // #5444
  {15,  7}, // #5445
  {16,  4}, // #5446
  {17,  3}, // #5447
  {19,  1}, // #5448
  {21,  3}, // #5449
  {23,  8}, // #5450
  {24,  7}, // #5451
  {25,  1}, // #5452
  {26,  9}, // #5453
  {27, 10}, // #5454
  { 3,  4}, // #5455
  { 8,  3}, // #5456
  {13,  4}, // #5457
  {14,  4}, // #5458
  {15,  7}, // #5459
  {16,  4}, // #5460
  {17,  3}, // #5461
  {21,  3}, // #5462
  {23,  8}, // #5463
  {24,  7}, // #5464
  {26,  9}, // #5465
  {27,  9}, // #5466
  { 3,  3}, // #5467
  {13,  3}, // #5468
  {14,  3}, // #5469
  {15,  3}, // #5470
  {16,  3}, // #5471
  {19,  1}, // #5472
  {23,  3}, // #5473
  {24,  3}, // #5474
  {25,  1}, // #5475
  {26,  3}, // #5476
  {27,  4}, // #5477
  { 3,  3}, // #5478
  {13,  3}, // #5479
  {14,  3}, // #5480
  {15,  3}, // #5481
  {16,  3}, // #5482
  {23,  3}, // #5483
  {24,  3}, // #5484
  {26,  3}, // #5485
  {27,  3}, // #5486
  { 7,  1}, // #5487
  {14,  1}, // #5488
  {19,  1}, // #5489
  {20,  1}, // #5490
  {25,  2}, // #5491
  {27,  3}, // #5492
  { 8,  1}, // #5493
  {13,  1}, // #5494
  {15,  1}, // #5495
  {17,  1}, // #5496
  {21,  1}, // #5497
  {23,  2}, // #5498
  {24,  1}, // #5499
  {26,  2}, // #5500
  {27,  2}, // #5501
  { 3,  1}, // #5502
  { 8,  1}, // #5503
  {13,  1}, // #5504
  {14,  1}, // #5505
  {15,  2}, // #5506
  {16,  1}, // #5507
  {17,  1}, // #5508
  {19,  1}, // #5509
  {21,  1}, // #5510
  {23,  2}, // #5511
  {24,  2}, // #5512
  {25,  1}, // #5513
  {26,  2}, // #5514
  {27,  3}, // #5515
  { 7,  1}, // #5516
  {14,  1}, // #5517
  {16,  3}, // #5518
  {19,  1}, // #5519
  {20,  1}, // #5520
  {24,  3}, // #5521
  {25,  2}, // #5522
  {26,  3}, // #5523
  {27,  6}, // #5524
  {16,  3}, // #5525
  {24,  3}, // #5526
  {26,  3}, // #5527
  {27,  3}, // #5528
  { 7,  1}, // #5529
  {14,  1}, // #5530
  {16,  1}, // #5531
  {20,  1}, // #5532
  {24,  1}, // #5533
  {25,  1}, // #5534
  {26,  1}, // #5535
  {27,  3}, // #5536
  { 4,  1}, // #5537
  {13,  1}, // #5538
  {16,  2}, // #5539
  {17,  1}, // #5540
  {18,  1}, // #5541
  {19,  1}, // #5542
  {23,  1}, // #5543
  {24,  2}, // #5544
  {25,  2}, // #5545
  {26,  4}, // #5546
  {27,  6}, // #5547
  { 4,  1}, // #5548
  {13,  1}, // #5549
  {17,  1}, // #5550
  {18,  1}, // #5551
  {19,  1}, // #5552
  {23,  1}, // #5553
  {25,  2}, // #5554
  {26,  2}, // #5555
  {27,  4}, // #5556
  { 4,  1}, // #5557
  {13,  1}, // #5558
  {16,  2}, // #5559
  {17,  1}, // #5560
  {18,  1}, // #5561
  {23,  1}, // #5562
  {24,  2}, // #5563
  {26,  4}, // #5564
  {27,  4}, // #5565
  { 2,  6}, // #5566
  { 3,  1}, // #5567
  {13,  1}, // #5568
  {14,  1}, // #5569
  {15,  1}, // #5570
  {16,  1}, // #5571
  {19,  1}, // #5572
  {23,  1}, // #5573
  {24,  1}, // #5574
  {25,  1}, // #5575
  {26,  1}, // #5576
  {27,  2}, // #5577
  { 2,  6}, // #5578
  { 3,  1}, // #5579
  {13,  1}, // #5580
  {14,  1}, // #5581
  {15,  1}, // #5582
  {16,  1}, // #5583
  {23,  1}, // #5584
  {24,  1}, // #5585
  {26,  1}, // #5586
  {27,  1}, // #5587
  { 2,  7}, // #5588
  { 3,  1}, // #5589
  {13,  1}, // #5590
  {14,  1}, // #5591
  {15,  1}, // #5592
  {16,  1}, // #5593
  {23,  1}, // #5594
  {24,  1}, // #5595
  {26,  1}, // #5596
  {27,  1}, // #5597
  { 8,  1}, // #5598
  {13,  1}, // #5599
  {15,  1}, // #5600
  {17,  1}, // #5601
  {19,  1}, // #5602
  {21,  1}, // #5603
  {23,  2}, // #5604
  {24,  1}, // #5605
  {25,  1}, // #5606
  {26,  2}, // #5607
  {27,  3}, // #5608
  {15,  2}, // #5609
  {19,  1}, // #5610
  {23,  2}, // #5611
  {24,  2}, // #5612
  {25,  1}, // #5613
  {26,  2}, // #5614
  {27,  3}, // #5615
  { 7,  1}, // #5616
  { 8,  1}, // #5617
  {13,  1}, // #5618
  {14,  1}, // #5619
  {15,  1}, // #5620
  {17,  1}, // #5621
  {20,  1}, // #5622
  {21,  1}, // #5623
  {23,  2}, // #5624
  {24,  1}, // #5625
  {25,  1}, // #5626
  {26,  2}, // #5627
  {27,  4}, // #5628
  { 7,  1}, // #5629
  { 8,  1}, // #5630
  {14,  1}, // #5631
  {15,  2}, // #5632
  {17,  1}, // #5633
  {20,  1}, // #5634
  {21,  1}, // #5635
  {23,  2}, // #5636
  {24,  2}, // #5637
  {25,  1}, // #5638
  {26,  2}, // #5639
  {27,  4}, // #5640
  { 8,  1}, // #5641
  {15,  2}, // #5642
  {17,  1}, // #5643
  {21,  1}, // #5644
  {23,  2}, // #5645
  {24,  2}, // #5646
  {26,  2}, // #5647
  {27,  2}, // #5648
  { 2,  8}, // #5649
  { 3,  1}, // #5650
  {13,  1}, // #5651
  {14,  1}, // #5652
  {15,  1}, // #5653
  {16,  1}, // #5654
  {19,  1}, // #5655
  {23,  1}, // #5656
  {24,  1}, // #5657
  {25,  1}, // #5658
  {26,  1}, // #5659
  {27,  2}, // #5660
  { 2,  5}, // #5661
  { 3,  1}, // #5662
  {13,  1}, // #5663
  {14,  1}, // #5664
  {15,  1}, // #5665
  {16,  1}, // #5666
  {23,  1}, // #5667
  {24,  1}, // #5668
  {26,  1}, // #5669
  {27,  1}, // #5670
  { 2, 16}, // #5671
  { 3,  2}, // #5672
  { 8,  1}, // #5673
  {13,  2}, // #5674
  {14,  2}, // #5675
  {15,  3}, // #5676
  {16,  2}, // #5677
  {17,  1}, // #5678
  {19,  1}, // #5679
  {21,  1}, // #5680
  {23,  3}, // #5681
  {24,  3}, // #5682
  {25,  1}, // #5683
  {26,  3}, // #5684
  {27,  4}, // #5685
  { 2, 16}, // #5686
  { 3,  2}, // #5687
  { 8,  1}, // #5688
  {13,  2}, // #5689
  {14,  2}, // #5690
  {15,  3}, // #5691
  {16,  2}, // #5692
  {17,  1}, // #5693
  {21,  1}, // #5694
  {23,  3}, // #5695
  {24,  3}, // #5696
  {26,  3}, // #5697
  {27,  3}, // #5698
  { 2, 10}, // #5699
  { 3,  2}, // #5700
  { 8,  1}, // #5701
  {13,  2}, // #5702
  {14,  2}, // #5703
  {15,  3}, // #5704
  {16,  2}, // #5705
  {17,  1}, // #5706
  {19,  1}, // #5707
  {21,  1}, // #5708
  {23,  3}, // #5709
  {24,  3}, // #5710
  {25,  1}, // #5711
  {26,  3}, // #5712
  {27,  4}, // #5713
  { 2, 10}, // #5714
  { 3,  2}, // #5715
  { 8,  1}, // #5716
  {13,  2}, // #5717
  {14,  2}, // #5718
  {15,  3}, // #5719
  {16,  2}, // #5720
  {17,  1}, // #5721
  {21,  1}, // #5722
  {23,  3}, // #5723
  {24,  3}, // #5724
  {26,  3}, // #5725
  {27,  3}, // #5726
  { 3,  1}, // #5727
  {13,  1}, // #5728
  {14,  1}, // #5729
  {15,  1}, // #5730
  {16,  1}, // #5731
  {23,  1}, // #5732
  {24,  1}, // #5733
  {25,  1}, // #5734
  {26,  1}, // #5735
  {27,  2}, // #5736
  { 2, 12}, // #5737
  { 3,  1}, // #5738
  {13,  1}, // #5739
  {14,  1}, // #5740
  {15,  1}, // #5741
  {16,  1}, // #5742
  {19,  1}, // #5743
  {23,  1}, // #5744
  {24,  1}, // #5745
  {25,  1}, // #5746
  {26,  1}, // #5747
  {27,  2}, // #5748
  { 2, 12}, // #5749
  { 3,  1}, // #5750
  {13,  1}, // #5751
  {14,  1}, // #5752
  {15,  1}, // #5753
  {16,  1}, // #5754
  {23,  1}, // #5755
  {24,  1}, // #5756
  {26,  1}, // #5757
  {27,  1}, // #5758
  { 2, 24}, // #5759
  { 3,  2}, // #5760
  { 8,  1}, // #5761
  {13,  2}, // #5762
  {14,  2}, // #5763
  {15,  3}, // #5764
  {16,  2}, // #5765
  {17,  1}, // #5766
  {19,  1}, // #5767
  {21,  1}, // #5768
  {23,  3}, // #5769
  {24,  3}, // #5770
  {25,  1}, // #5771
  {26,  3}, // #5772
  {27,  4}, // #5773
  { 2, 24}, // #5774
  { 3,  2}, // #5775
  { 8,  1}, // #5776
  {13,  2}, // #5777
  {14,  2}, // #5778
  {15,  3}, // #5779
  {16,  2}, // #5780
  {17,  1}, // #5781
  {21,  1}, // #5782
  {23,  3}, // #5783
  {24,  3}, // #5784
  {26,  3}, // #5785
  {27,  3}, // #5786
  { 2, 12}, // #5787
  { 3,  2}, // #5788
  { 8,  1}, // #5789
  {13,  2}, // #5790
  {14,  2}, // #5791
  {15,  3}, // #5792
  {16,  2}, // #5793
  {17,  1}, // #5794
  {19,  1}, // #5795
  {21,  1}, // #5796
  {23,  3}, // #5797
  {24,  3}, // #5798
  {25,  1}, // #5799
  {26,  3}, // #5800
  {27,  4}, // #5801
  { 2, 12}, // #5802
  { 3,  2}, // #5803
  { 8,  1}, // #5804
  {13,  2}, // #5805
  {14,  2}, // #5806
  {15,  3}, // #5807
  {16,  2}, // #5808
  {17,  1}, // #5809
  {21,  1}, // #5810
  {23,  3}, // #5811
  {24,  3}, // #5812
  {26,  3}, // #5813
  {27,  3}, // #5814
  {16,  1}, // #5815
  {19,  1}, // #5816
  {24,  1}, // #5817
  {25,  2}, // #5818
  {26,  3}, // #5819
  {27,  5}, // #5820
  { 4,  2}, // #5821
  {13,  2}, // #5822
  {16,  4}, // #5823
  {17,  3}, // #5824
  {18,  2}, // #5825
  {19,  1}, // #5826
  {23,  3}, // #5827
  {24,  4}, // #5828
  {25,  2}, // #5829
  {26,  9}, // #5830
  {27, 11}, // #5831
  { 8,  1}, // #5832
  {15,  1}, // #5833
  {17,  1}, // #5834
  {21,  1}, // #5835
  {23,  2}, // #5836
  {24,  1}, // #5837
  {26,  2}, // #5838
  {27,  2}, // #5839
  { 3,  2}, // #5840
  { 4,  1}, // #5841
  { 8,  2}, // #5842
  { 9,  4}, // #5843
  {13,  3}, // #5844
  {14,  2}, // #5845
  {15,  6}, // #5846
  {16,  6}, // #5847
  {17,  3}, // #5848
  {18,  5}, // #5849
  {21,  6}, // #5850
  {23,  7}, // #5851
  {24, 10}, // #5852
  {26, 15}, // #5853
  {27, 15}, // #5854
  { 3,  1}, // #5855
  { 8,  1}, // #5856
  {13,  1}, // #5857
  {14,  1}, // #5858
  {15,  2}, // #5859
  {16,  1}, // #5860
  {17,  1}, // #5861
  {21,  1}, // #5862
  {23,  3}, // #5863
  {24,  2}, // #5864
  {26,  3}, // #5865
  {27,  3}, // #5866
  { 3,  1}, // #5867
  { 8,  1}, // #5868
  {13,  1}, // #5869
  {14,  1}, // #5870
  {15,  2}, // #5871
  {16,  1}, // #5872
  {17,  1}, // #5873
  {19,  1}, // #5874
  {21,  1}, // #5875
  {23,  3}, // #5876
  {24,  2}, // #5877
  {25,  1}, // #5878
  {26,  3}, // #5879
  {27,  4}, // #5880
  {19,  1}, // #5881
  {25,  1}, // #5882
  {26,  2}, // #5883
  {27,  3}, // #5884
  { 9,  1}, // #5885
  {16,  1}, // #5886
  {18,  1}, // #5887
  {21,  1}, // #5888
  {24,  1}, // #5889
  {26,  3}, // #5890
  {27,  3}, // #5891
  { 7,  1}, // #5892
  { 9,  1}, // #5893
  {14,  1}, // #5894
  {16,  2}, // #5895
  {18,  1}, // #5896
  {19,  1}, // #5897
  {20,  1}, // #5898
  {21,  1}, // #5899
  {24,  2}, // #5900
  {25,  2}, // #5901
  {26,  5}, // #5902
  {27,  8}, // #5903
  {16,  1}, // #5904
  {24,  1}, // #5905
  {26,  2}, // #5906
  {27,  2}, // #5907
  { 3,  1}, // #5908
  {13,  1}, // #5909
  {14,  1}, // #5910
  {15,  2}, // #5911
  {16,  1}, // #5912
  {19,  1}, // #5913
  {23,  2}, // #5914
  {24,  2}, // #5915
  {25,  1}, // #5916
  {26,  2}, // #5917
  {27,  3}, // #5918
  {16,  2}, // #5919
  {24,  2}, // #5920
  {26, 11}, // #5921
  {27, 11}, // #5922
  { 7,  1}, // #5923
  { 9,  1}, // #5924
  {14,  1}, // #5925
  {16,  1}, // #5926
  {18,  1}, // #5927
  {20,  1}, // #5928
  {21,  1}, // #5929
  {24,  1}, // #5930
  {25,  1}, // #5931
  {26,  1}, // #5932
  {27,  3}, // #5933
  { 9,  1}, // #5934
  {16,  1}, // #5935
  {18,  1}, // #5936
  {21,  1}, // #5937
  {24,  1}, // #5938
  {26,  4}, // #5939
  {27,  4}, // #5940
  { 7,  1}, // #5941
  {14,  1}, // #5942
  {16,  4}, // #5943
  {17,  2}, // #5944
  {19,  1}, // #5945
  {20,  1}, // #5946
  {23,  2}, // #5947
  {24,  4}, // #5948
  {25,  2}, // #5949
  {26, 11}, // #5950
  {27, 14}, // #5951
  { 9,  1}, // #5952
  {16,  4}, // #5953
  {17,  1}, // #5954
  {18,  1}, // #5955
  {21,  1}, // #5956
  {23,  1}, // #5957
  {24,  4}, // #5958
  {26,  7}, // #5959
  {27,  7}, // #5960
  { 9,  1}, // #5961
  {16,  1}, // #5962
  {18,  1}, // #5963
  {21,  1}, // #5964
  {24,  1}, // #5965
  {26,  6}, // #5966
  {27,  6}, // #5967
  { 3,  2}, // #5968
  { 7,  1}, // #5969
  { 8,  4}, // #5970
  {13,  2}, // #5971
  {14,  3}, // #5972
  {15,  6}, // #5973
  {16,  6}, // #5974
  {17,  4}, // #5975
  {19,  1}, // #5976
  {20,  1}, // #5977
  {21,  4}, // #5978
  {23,  6}, // #5979
  {24, 10}, // #5980
  {25,  2}, // #5981
  {26, 16}, // #5982
  {27, 19}, // #5983
  { 8,  2}, // #5984
  {15,  2}, // #5985
  {17,  2}, // #5986
  {21,  2}, // #5987
  {23,  2}, // #5988
  {24,  2}, // #5989
  {26, 22}, // #5990
  {27, 22}, // #5991
  { 8,  1}, // #5992
  { 9,  2}, // #5993
  {15,  1}, // #5994
  {16,  2}, // #5995
  {17,  1}, // #5996
  {18,  2}, // #5997
  {21,  3}, // #5998
  {23,  1}, // #5999
  {24,  3}, // #6000
  {26, 10}, // #6001
  {27, 10}, // #6002
  { 7,  1}, // #6003
  { 8,  1}, // #6004
  { 9,  1}, // #6005
  {14,  1}, // #6006
  {15,  1}, // #6007
  {16,  2}, // #6008
  {17,  1}, // #6009
  {18,  1}, // #6010
  {19,  1}, // #6011
  {20,  1}, // #6012
  {21,  2}, // #6013
  {23,  1}, // #6014
  {24,  3}, // #6015
  {25,  2}, // #6016
  {26,  5}, // #6017
  {27,  8}, // #6018
  { 8,  6}, // #6019
  {15,  9}, // #6020
  {17,  6}, // #6021
  {21,  6}, // #6022
  {23,  9}, // #6023
  {24,  9}, // #6024
  {26, 15}, // #6025
  {27, 15}, // #6026
  { 8,  1}, // #6027
  { 9,  5}, // #6028
  {15,  1}, // #6029
  {16,  9}, // #6030
  {17,  1}, // #6031
  {18,  5}, // #6032
  {19,  2}, // #6033
  {21,  6}, // #6034
  {23,  1}, // #6035
  {24, 10}, // #6036
  {25,  3}, // #6037
  {26, 20}, // #6038
  {27, 23}, // #6039
  { 8,  1}, // #6040
  { 9,  5}, // #6041
  {15,  1}, // #6042
  {16,  9}, // #6043
  {17,  1}, // #6044
  {18,  5}, // #6045
  {19,  3}, // #6046
  {21,  6}, // #6047
  {23,  1}, // #6048
  {24, 10}, // #6049
  {25,  3}, // #6050
  {26, 20}, // #6051
  {27, 23}, // #6052
  { 8,  1}, // #6053
  { 9,  1}, // #6054
  {15,  1}, // #6055
  {16,  2}, // #6056
  {17,  1}, // #6057
  {18,  1}, // #6058
  {21,  2}, // #6059
  {23,  1}, // #6060
  {24,  3}, // #6061
  {26,  8}, // #6062
  {27,  8}, // #6063
  { 3,  4}, // #6064
  { 9,  2}, // #6065
  {13,  4}, // #6066
  {14,  4}, // #6067
  {15,  5}, // #6068
  {16,  8}, // #6069
  {17,  1}, // #6070
  {18,  2}, // #6071
  {19, 33}, // #6072
  {21,  2}, // #6073
  {23,  6}, // #6074
  {24,  9}, // #6075
  {25, 33}, // #6076
  {26, 57}, // #6077
  {27, 90}, // #6078
  { 9,  1}, // #6079
  {16,  1}, // #6080
  {18,  1}, // #6081
  {19,  1}, // #6082
  {21,  1}, // #6083
  {24,  1}, // #6084
  {25,  1}, // #6085
  {26,  2}, // #6086
  {27,  3}, // #6087
  { 3,  1}, // #6088
  {13,  1}, // #6089
  {14,  1}, // #6090
  {15,  1}, // #6091
  {16,  1}, // #6092
  {23,  1}, // #6093
  {24,  1}, // #6094
  {26,  2}, // #6095
  {27,  2}, // #6096
  {16,  1}, // #6097
  {24,  1}, // #6098
  {26,  3}, // #6099
  {27,  3}, // #6100
  { 4,  2}, // #6101
  {13,  2}, // #6102
  {16,  3}, // #6103
  {17,  2}, // #6104
  {18,  2}, // #6105
  {23,  2}, // #6106
  {24,  3}, // #6107
  {26,  7}, // #6108
  {27,  7}, // #6109
  { 4,  2}, // #6110
  {13,  2}, // #6111
  {16,  4}, // #6112
  {17,  3}, // #6113
  {18,  2}, // #6114
  {23,  3}, // #6115
  {24,  4}, // #6116
  {26, 10}, // #6117
  {27, 10}, // #6118
  { 7,  1}, // #6119
  {14,  1}, // #6120
  {20,  1}, // #6121
  {25,  1}, // #6122
  {26,  1}, // #6123
  {27,  3}, // #6124
  { 7,  1}, // #6125
  {14,  1}, // #6126
  {16,  1}, // #6127
  {20,  1}, // #6128
  {24,  1}, // #6129
  {25,  1}, // #6130
  {26,  2}, // #6131
  {27,  4}, // #6132
  { 7,  1}, // #6133
  { 9,  1}, // #6134
  {14,  1}, // #6135
  {16,  1}, // #6136
  {18,  1}, // #6137
  {20,  1}, // #6138
  {21,  1}, // #6139
  {24,  1}, // #6140
  {25,  1}, // #6141
  {26,  2}, // #6142
  {27,  4}, // #6143
  { 7,  1}, // #6144
  {14,  1}, // #6145
  {20,  1}, // #6146
  {25,  1}, // #6147
  {26,  4}, // #6148
  {27,  6}, // #6149
  { 9,  1}, // #6150
  {16,  1}, // #6151
  {18,  1}, // #6152
  {21,  1}, // #6153
  {24,  1}, // #6154
  {26,  2}, // #6155
  {27,  2}, // #6156
  { 9,  1}, // #6157
  {16,  1}, // #6158
  {18,  1}, // #6159
  {19,  1}, // #6160
  {21,  1}, // #6161
  {24,  1}, // #6162
  {25,  1}, // #6163
  {26,  1}, // #6164
  {27,  2}, // #6165
  { 3,  1}, // #6166
  { 7,  1}, // #6167
  {13,  1}, // #6168
  {14,  2}, // #6169
  {15,  1}, // #6170
  {16,  1}, // #6171
  {20,  1}, // #6172
  {23,  1}, // #6173
  {24,  1}, // #6174
  {25,  1}, // #6175
  {26,  1}, // #6176
  {27,  3}, // #6177
  { 4,  1}, // #6178
  { 9,  1}, // #6179
  {13,  1}, // #6180
  {16,  2}, // #6181
  {17,  1}, // #6182
  {18,  2}, // #6183
  {21,  1}, // #6184
  {23,  1}, // #6185
  {24,  2}, // #6186
  {26,  4}, // #6187
  {27,  4}, // #6188
  { 7,  1}, // #6189
  { 9,  1}, // #6190
  {14,  1}, // #6191
  {16,  1}, // #6192
  {18,  1}, // #6193
  {19,  1}, // #6194
  {20,  1}, // #6195
  {21,  1}, // #6196
  {24,  1}, // #6197
  {25,  2}, // #6198
  {26,  2}, // #6199
  {27,  5}, // #6200
  { 7,  1}, // #6201
  {14,  1}, // #6202
  {16,  2}, // #6203
  {19,  1}, // #6204
  {20,  1}, // #6205
  {24,  2}, // #6206
  {25,  2}, // #6207
  {26,  2}, // #6208
  {27,  5}, // #6209
  { 7,  1}, // #6210
  {14,  1}, // #6211
  {19,  1}, // #6212
  {20,  1}, // #6213
  {25,  2}, // #6214
  {26,  2}, // #6215
  {27,  5}, // #6216
  { 4,  1}, // #6217
  { 9,  5}, // #6218
  {13,  1}, // #6219
  {15,  4}, // #6220
  {16,  5}, // #6221
  {17,  1}, // #6222
  {18,  6}, // #6223
  {21,  5}, // #6224
  {23,  5}, // #6225
  {24,  9}, // #6226
  {26, 10}, // #6227
  {27, 10}, // #6228
  { 9,  1}, // #6229
  {16,  1}, // #6230
  {18,  1}, // #6231
  {21,  1}, // #6232
  {24,  1}, // #6233
  {26,  1}, // #6234
  {27,  1}, // #6235
  { 7,  1}, // #6236
  {14,  1}, // #6237
  {17,  1}, // #6238
  {20,  1}, // #6239
  {23,  1}, // #6240
  {25,  1}, // #6241
  {26,  1}, // #6242
  {27,  3}, // #6243
  {16,  2}, // #6244
  {24,  2}, // #6245
  {26,  2}, // #6246
  {27,  2}, // #6247
  { 8,  2}, // #6248
  {15,  2}, // #6249
  {17,  2}, // #6250
  {21,  2}, // #6251
  {23,  2}, // #6252
  {24,  2}, // #6253
  {26,  3}, // #6254
  {27,  3}, // #6255
  { 8,  1}, // #6256
  {15,  1}, // #6257
  {17,  1}, // #6258
  {19,  1}, // #6259
  {21,  1}, // #6260
  {23,  2}, // #6261
  {24,  1}, // #6262
  {25,  1}, // #6263
  {26,  2}, // #6264
  {27,  3}, // #6265
  { 4,  1}, // #6266
  { 9,  1}, // #6267
  {13,  1}, // #6268
  {16,  1}, // #6269
  {17,  1}, // #6270
  {18,  2}, // #6271
  {21,  1}, // #6272
  {23,  1}, // #6273
  {24,  1}, // #6274
  {26,  4}, // #6275
  {27,  4}, // #6276
  { 4,  1}, // #6277
  { 9,  2}, // #6278
  {13,  1}, // #6279
  {16,  2}, // #6280
  {17,  1}, // #6281
  {18,  3}, // #6282
  {19,  1}, // #6283
  {21,  2}, // #6284
  {23,  1}, // #6285
  {24,  2}, // #6286
  {25,  1}, // #6287
  {26,  4}, // #6288
  {27,  5}, // #6289
  { 4,  1}, // #6290
  { 9,  1}, // #6291
  {13,  1}, // #6292
  {16,  2}, // #6293
  {17,  1}, // #6294
  {18,  2}, // #6295
  {21,  1}, // #6296
  {23,  1}, // #6297
  {24,  2}, // #6298
  {26,  3}, // #6299
  {27,  3}, // #6300
  {16,  1}, // #6301
  {24,  1}, // #6302
  {26,  5}, // #6303
  {27,  5}, // #6304
  { 4,  1}, // #6305
  {13,  1}, // #6306
  {16,  5}, // #6307
  {17,  2}, // #6308
  {18,  1}, // #6309
  {19,  1}, // #6310
  {23,  2}, // #6311
  {24,  5}, // #6312
  {25,  2}, // #6313
  {26,  8}, // #6314
  {27, 10}, // #6315
  { 4,  1}, // #6316
  {13,  1}, // #6317
  {16,  5}, // #6318
  {17,  2}, // #6319
  {18,  1}, // #6320
  {23,  2}, // #6321
  {24,  5}, // #6322
  {26,  9}, // #6323
  {27,  9}, // #6324
  { 4,  1}, // #6325
  { 9,  8}, // #6326
  {13,  1}, // #6327
  {16,  8}, // #6328
  {17,  1}, // #6329
  {18,  9}, // #6330
  {19,  1}, // #6331
  {21,  8}, // #6332
  {23,  1}, // #6333
  {24,  8}, // #6334
  {25,  1}, // #6335
  {26, 30}, // #6336
  {27, 31}, // #6337
  { 7,  1}, // #6338
  { 9, 10}, // #6339
  {14,  1}, // #6340
  {16, 10}, // #6341
  {18, 10}, // #6342
  {19,  1}, // #6343
  {20,  1}, // #6344
  {21, 10}, // #6345
  {24, 10}, // #6346
  {25,  2}, // #6347
  {26, 36}, // #6348
  {27, 39}, // #6349
  { 7,  1}, // #6350
  { 9, 11}, // #6351
  {14,  1}, // #6352
  {16, 11}, // #6353
  {18, 11}, // #6354
  {19,  1}, // #6355
  {20,  1}, // #6356
  {21, 11}, // #6357
  {24, 11}, // #6358
  {25,  2}, // #6359
  {26, 37}, // #6360
  {27, 40}, // #6361
  { 4,  1}, // #6362
  { 7,  1}, // #6363
  { 8,  2}, // #6364
  { 9,  3}, // #6365
  {13,  1}, // #6366
  {14,  1}, // #6367
  {15,  2}, // #6368
  {16,  3}, // #6369
  {17,  4}, // #6370
  {18,  4}, // #6371
  {19,  1}, // #6372
  {20,  1}, // #6373
  {21,  5}, // #6374
  {23,  4}, // #6375
  {24,  5}, // #6376
  {25,  2}, // #6377
  {26, 15}, // #6378
  {27, 18}, // #6379
  { 3,  2}, // #6380
  {13,  2}, // #6381
  {14,  2}, // #6382
  {15,  7}, // #6383
  {16, 12}, // #6384
  {19,  8}, // #6385
  {23,  7}, // #6386
  {24, 17}, // #6387
  {25,  8}, // #6388
  {26, 56}, // #6389
  {27, 64}, // #6390
  { 3,  4}, // #6391
  { 9,  4}, // #6392
  {13,  4}, // #6393
  {14,  4}, // #6394
  {15,  5}, // #6395
  {16, 10}, // #6396
  {17,  1}, // #6397
  {18,  4}, // #6398
  {19, 31}, // #6399
  {21,  4}, // #6400
  {23,  6}, // #6401
  {24, 11}, // #6402
  {25, 31}, // #6403
  {26, 57}, // #6404
  {27, 88}, // #6405
  { 3,  9}, // #6406
  { 4,  1}, // #6407
  { 7, 11}, // #6408
  { 8, 16}, // #6409
  { 9,  1}, // #6410
  {13, 10}, // #6411
  {14, 20}, // #6412
  {15, 25}, // #6413
  {16, 31}, // #6414
  {17, 17}, // #6415
  {18,  2}, // #6416
  {20, 11}, // #6417
  {21, 17}, // #6418
  {23, 26}, // #6419
  {24, 47}, // #6420
  {25, 11}, // #6421
  {26, 78}, // #6422
  {27, 100}, // #6423
  { 3,  1}, // #6424
  { 8,  1}, // #6425
  {13,  1}, // #6426
  {14,  1}, // #6427
  {15,  2}, // #6428
  {16,  1}, // #6429
  {17,  1}, // #6430
  {19,  2}, // #6431
  {21,  1}, // #6432
  {23,  3}, // #6433
  {24,  2}, // #6434
  {25,  2}, // #6435
  {26,  3}, // #6436
  {27,  5}, // #6437
  { 3,  1}, // #6438
  { 8,  1}, // #6439
  {13,  1}, // #6440
  {14,  1}, // #6441
  {15,  2}, // #6442
  {16,  1}, // #6443
  {17,  1}, // #6444
  {19,  4}, // #6445
  {21,  1}, // #6446
  {23,  3}, // #6447
  {24,  2}, // #6448
  {25,  4}, // #6449
  {26,  3}, // #6450
  {27,  7}, // #6451
  { 3,  1}, // #6452
  { 8,  1}, // #6453
  {13,  1}, // #6454
  {14,  1}, // #6455
  {15,  2}, // #6456
  {16,  1}, // #6457
  {17,  1}, // #6458
  {19,  8}, // #6459
  {21,  1}, // #6460
  {23,  3}, // #6461
  {24,  2}, // #6462
  {25,  8}, // #6463
  {26,  3}, // #6464
  {27, 11}, // #6465
  { 3,  1}, // #6466
  { 8,  2}, // #6467
  {13,  1}, // #6468
  {14,  1}, // #6469
  {15,  3}, // #6470
  {16,  1}, // #6471
  {17,  2}, // #6472
  {21,  2}, // #6473
  {23,  3}, // #6474
  {24,  3}, // #6475
  {26,  3}, // #6476
  {27,  3}, // #6477
  { 8,  2}, // #6478
  {13,  1}, // #6479
  {15,  2}, // #6480
  {17,  2}, // #6481
  {21,  2}, // #6482
  {23,  3}, // #6483
  {24,  2}, // #6484
  {26,  3}, // #6485
  {27,  3}, // #6486
  { 3,  1}, // #6487
  { 8,  2}, // #6488
  {13,  1}, // #6489
  {14,  1}, // #6490
  {15,  3}, // #6491
  {16,  1}, // #6492
  {17,  2}, // #6493
  {19,  1}, // #6494
  {21,  2}, // #6495
  {23,  3}, // #6496
  {24,  3}, // #6497
  {25,  1}, // #6498
  {26,  3}, // #6499
  {27,  4}, // #6500
  { 8,  2}, // #6501
  {13,  1}, // #6502
  {15,  2}, // #6503
  {17,  2}, // #6504
  {19,  1}, // #6505
  {21,  2}, // #6506
  {23,  3}, // #6507
  {24,  2}, // #6508
  {25,  1}, // #6509
  {26,  3}, // #6510
  {27,  4}, // #6511
  { 7,  2}, // #6512
  {14,  2}, // #6513
  {17,  1}, // #6514
  {20,  2}, // #6515
  {23,  1}, // #6516
  {25,  2}, // #6517
  {26,  1}, // #6518
  {27,  5}, // #6519
  { 7,  1}, // #6520
  {14,  1}, // #6521
  {20,  1}, // #6522
  {23,  1}, // #6523
  {25,  1}, // #6524
  {26,  1}, // #6525
  {27,  3}, // #6526
  { 7,  1}, // #6527
  { 8,  2}, // #6528
  {14,  1}, // #6529
  {15,  2}, // #6530
  {17,  2}, // #6531
  {20,  1}, // #6532
  {21,  2}, // #6533
  {23,  2}, // #6534
  {24,  2}, // #6535
  {25,  1}, // #6536
  {26,  2}, // #6537
  {27,  4}, // #6538
  { 8,  1}, // #6539
  {15,  1}, // #6540
  {17,  1}, // #6541
  {19,  1}, // #6542
  {21,  1}, // #6543
  {23,  1}, // #6544
  {24,  1}, // #6545
  {25,  1}, // #6546
  {26,  2}, // #6547
  {27,  3}, // #6548
  { 3,  1}, // #6549
  { 7,  2}, // #6550
  {13,  1}, // #6551
  {14,  3}, // #6552
  {15,  1}, // #6553
  {16,  1}, // #6554
  {20,  2}, // #6555
  {23,  1}, // #6556
  {24,  1}, // #6557
  {25,  2}, // #6558
  {26,  3}, // #6559
  {27,  7}, // #6560
  { 3,  1}, // #6561
  { 7,  4}, // #6562
  {13,  1}, // #6563
  {14,  5}, // #6564
  {15,  1}, // #6565
  {16,  1}, // #6566
  {20,  4}, // #6567
  {23,  1}, // #6568
  {24,  1}, // #6569
  {25,  4}, // #6570
  {26,  3}, // #6571
  {27, 11}, // #6572
  { 3,  1}, // #6573
  { 7,  8}, // #6574
  {13,  1}, // #6575
  {14,  9}, // #6576
  {15,  1}, // #6577
  {16,  1}, // #6578
  {20,  8}, // #6579
  {23,  1}, // #6580
  {24,  1}, // #6581
  {25,  8}, // #6582
  {26,  3}, // #6583
  {27, 19}, // #6584
  { 3,  1}, // #6585
  { 7, 16}, // #6586
  { 8,  1}, // #6587
  {13,  1}, // #6588
  {14, 17}, // #6589
  {15,  2}, // #6590
  {16,  1}, // #6591
  {17,  1}, // #6592
  {20, 16}, // #6593
  {21,  1}, // #6594
  {23,  2}, // #6595
  {24,  2}, // #6596
  {25, 16}, // #6597
  {26,  4}, // #6598
  {27, 36}, // #6599
  { 3,  1}, // #6600
  { 7,  2}, // #6601
  { 8,  1}, // #6602
  {13,  1}, // #6603
  {14,  3}, // #6604
  {15,  2}, // #6605
  {16,  1}, // #6606
  {17,  1}, // #6607
  {20,  2}, // #6608
  {21,  1}, // #6609
  {23,  2}, // #6610
  {24,  2}, // #6611
  {25,  2}, // #6612
  {26,  4}, // #6613
  {27,  8}, // #6614
  { 3,  1}, // #6615
  { 7,  4}, // #6616
  { 8,  1}, // #6617
  {13,  1}, // #6618
  {14,  5}, // #6619
  {15,  2}, // #6620
  {16,  1}, // #6621
  {17,  1}, // #6622
  {20,  4}, // #6623
  {21,  1}, // #6624
  {23,  2}, // #6625
  {24,  2}, // #6626
  {25,  4}, // #6627
  {26,  4}, // #6628
  {27, 12}, // #6629
  { 3,  1}, // #6630
  { 7,  8}, // #6631
  { 8,  1}, // #6632
  {13,  1}, // #6633
  {14,  9}, // #6634
  {15,  2}, // #6635
  {16,  1}, // #6636
  {17,  1}, // #6637
  {20,  8}, // #6638
  {21,  1}, // #6639
  {23,  2}, // #6640
  {24,  2}, // #6641
  {25,  8}, // #6642
  {26,  4}, // #6643
  {27, 20}, // #6644
  {13,  3}, // #6645
  {23,  3}, // #6646
  {26,  3}, // #6647
  {27,  3}, // #6648
  {15,  3}, // #6649
  {23,  3}, // #6650
  {24,  3}, // #6651
  {26,  3}, // #6652
  {27,  3}, // #6653
  { 3,  1}, // #6654
  {13,  1}, // #6655
  {14,  1}, // #6656
  {15,  1}, // #6657
  {16,  1}, // #6658
  {19,  1}, // #6659
  {23,  2}, // #6660
  {24,  1}, // #6661
  {25,  1}, // #6662
  {26,  2}, // #6663
  {27,  3}, // #6664
  { 4,  1}, // #6665
  { 8,  2}, // #6666
  {13,  3}, // #6667
  {15,  2}, // #6668
  {17,  3}, // #6669
  {18,  1}, // #6670
  {19,  1}, // #6671
  {21,  2}, // #6672
  {23,  7}, // #6673
  {24,  2}, // #6674
  {25,  1}, // #6675
  {26,  7}, // #6676
  {27,  8}, // #6677
  {13,  3}, // #6678
  {19,  1}, // #6679
  {23,  3}, // #6680
  {25,  1}, // #6681
  {26,  3}, // #6682
  {27,  4}, // #6683
  {15,  3}, // #6684
  {19,  1}, // #6685
  {23,  3}, // #6686
  {24,  3}, // #6687
  {25,  1}, // #6688
  {26,  3}, // #6689
  {27,  4}, // #6690
  { 3,  1}, // #6691
  {13,  1}, // #6692
  {14,  1}, // #6693
  {15,  1}, // #6694
  {16,  1}, // #6695
  {19,  2}, // #6696
  {23,  2}, // #6697
  {24,  1}, // #6698
  {25,  2}, // #6699
  {26,  3}, // #6700
  {27,  5}, // #6701
  { 3,  1}, // #6702
  {13,  1}, // #6703
  {14,  1}, // #6704
  {15,  1}, // #6705
  {16,  1}, // #6706
  {19,  4}, // #6707
  {23,  2}, // #6708
  {24,  1}, // #6709
  {25,  4}, // #6710
  {26,  3}, // #6711
  {27,  7}, // #6712
  { 3,  1}, // #6713
  {13,  1}, // #6714
  {14,  1}, // #6715
  {15,  1}, // #6716
  {16,  1}, // #6717
  {19,  8}, // #6718
  {23,  2}, // #6719
  {24,  1}, // #6720
  {25,  8}, // #6721
  {26,  3}, // #6722
  {27, 11}, // #6723
  { 3,  1}, // #6724
  {13,  1}, // #6725
  {14,  1}, // #6726
  {15,  1}, // #6727
  {16,  1}, // #6728
  {19, 16}, // #6729
  {23,  2}, // #6730
  {24,  1}, // #6731
  {25, 16}, // #6732
  {26,  3}, // #6733
  {27, 19}, // #6734
  { 8,  5}, // #6735
  {13,  5}, // #6736
  {15,  5}, // #6737
  {17,  5}, // #6738
  {21,  5}, // #6739
  {23, 14}, // #6740
  {24,  5}, // #6741
  {26, 14}, // #6742
  {27, 14}, // #6743
  { 8,  5}, // #6744
  {13,  5}, // #6745
  {15,  5}, // #6746
  {17,  5}, // #6747
  {19,  1}, // #6748
  {21,  5}, // #6749
  {23, 14}, // #6750
  {24,  5}, // #6751
  {25,  1}, // #6752
  {26, 14}, // #6753
  {27, 15}, // #6754
  { 8,  9}, // #6755
  {13,  7}, // #6756
  {15,  9}, // #6757
  {17,  9}, // #6758
  {21,  9}, // #6759
  {23, 21}, // #6760
  {24,  9}, // #6761
  {26, 21}, // #6762
  {27, 21}, // #6763
  { 8,  9}, // #6764
  {13,  7}, // #6765
  {15,  9}, // #6766
  {17,  9}, // #6767
  {19,  1}, // #6768
  {21,  9}, // #6769
  {23, 21}, // #6770
  {24,  9}, // #6771
  {25,  1}, // #6772
  {26, 21}, // #6773
  {27, 22}, // #6774
  { 8, 17}, // #6775
  {13, 11}, // #6776
  {15, 17}, // #6777
  {17, 17}, // #6778
  {21, 17}, // #6779
  {23, 35}, // #6780
  {24, 17}, // #6781
  {26, 35}, // #6782
  {27, 35}, // #6783
  { 8, 17}, // #6784
  {13, 11}, // #6785
  {15, 17}, // #6786
  {17, 17}, // #6787
  {19,  1}, // #6788
  {21, 17}, // #6789
  {23, 35}, // #6790
  {24, 17}, // #6791
  {25,  1}, // #6792
  {26, 35}, // #6793
  {27, 36}, // #6794
  {16,  2}, // #6795
  {19,  1}, // #6796
  {24,  2}, // #6797
  {25,  1}, // #6798
  {26,  2}, // #6799
  {27,  3}, // #6800
  { 7,  1}, // #6801
  {14,  1}, // #6802
  {16,  2}, // #6803
  {20,  1}, // #6804
  {24,  2}, // #6805
  {25,  1}, // #6806
  {26,  2}, // #6807
  {27,  4}, // #6808
  { 1,  1}, // #6809
  { 4,  1}, // #6810
  {11,  1}, // #6811
  {15,  1}, // #6812
  {18,  1}, // #6813
  {20,  1}, // #6814
  {21,  1}, // #6815
  {22,  1}, // #6816
  { 1,  2}, // #6817
  { 4,  1}, // #6818
  { 1,  1}, // #6819
  {11,  1}, // #6820
  {21,  1}, // #6821
  { 1,  1}, // #6822
  {11,  1}, // #6823
  {16,  1}, // #6824
  {22,  1}, // #6825
  { 1,  1}, // #6826
  { 4, 12}, // #6827
  { 1,  1}, // #6828
  { 4, 16}, // #6829
  { 1,  1}, // #6830
  {11,  2}, // #6831
  {14,  1}, // #6832
  {16,  1}, // #6833
  {17,  1}, // #6834
  {19,  1}, // #6835
  {21,  1}, // #6836
  {22,  1}, // #6837
  { 1,  1}, // #6838
  {11,  1}, // #6839
  {12,  1}, // #6840
  {16,  1}, // #6841
  {17,  1}, // #6842
  {18,  1}, // #6843
  {22,  1}, // #6844
  { 1,  1}, // #6845
  {11,  1}, // #6846
  {15,  1}, // #6847
  {18,  1}, // #6848
  {20,  1}, // #6849
  {21,  1}, // #6850
  {22,  1}, // #6851
  { 1,  1}, // #6852
  {11,  2}, // #6853
  {18,  2}, // #6854
  {22,  2}, // #6855
  { 1,  1}, // #6856
  {11,  2}, // #6857
  {15,  2}, // #6858
  {18,  2}, // #6859
  {20,  2}, // #6860
  {21,  2}, // #6861
  {22,  2}, // #6862
  { 1,  1}, // #6863
  { 4,  1}, // #6864
  { 7,  1}, // #6865
  {10, 17}, // #6866
  { 1,  1}, // #6867
  { 4,  1}, // #6868
  { 7,  1}, // #6869
  {10, 25}, // #6870
  { 1,  1}, // #6871
  { 4,  1}, // #6872
  { 7,  1}, // #6873
  {10, 41}, // #6874
  { 1,  1}, // #6875
  { 4,  1}, // #6876
  { 7,  1}, // #6877
  {10, 15}, // #6878
  { 1,  1}, // #6879
  {11,  5}, // #6880
  {14,  3}, // #6881
  {17,  3}, // #6882
  {19,  5}, // #6883
  {21,  3}, // #6884
  {11,  3}, // #6885
  {14,  2}, // #6886
  {17,  2}, // #6887
  {19,  3}, // #6888
  {21,  2}, // #6889
  { 1,  1}, // #6890
  { 4,  1}, // #6891
  { 6,  1}, // #6892
  {23,  1}, // #6893
  { 1,  1}, // #6894
  {11,  1}, // #6895
  {19,  1}, // #6896
  { 1,  1}, // #6897
  {11,  1}, // #6898
  {20,  1}, // #6899
  {22,  1}, // #6900
  {11,  1}, // #6901
  {14,  1}, // #6902
  {17,  1}, // #6903
  {19,  1}, // #6904
  {21,  1}, // #6905
  { 1,  1}, // #6906
  {11,  1}, // #6907
  {14,  1}, // #6908
  {17,  1}, // #6909
  {19,  1}, // #6910
  {21,  1}, // #6911
  { 1,  1}, // #6912
  { 4,  1}, // #6913
  { 6,  1}, // #6914
  {23,  2}, // #6915
  { 1,  1}, // #6916
  {11,  2}, // #6917
  {19,  2}, // #6918
  { 1,  1}, // #6919
  {11,  2}, // #6920
  {17,  2}, // #6921
  { 1,  1}, // #6922
  {11, 20}, // #6923
  {15, 20}, // #6924
  {18, 20}, // #6925
  {20, 20}, // #6926
  {21, 20}, // #6927
  {22, 20}, // #6928
  { 1,  1}, // #6929
  {11,  1}, // #6930
  {18,  1}, // #6931
  {22,  1}, // #6932
  { 1,  1}, // #6933
  {11,  2}, // #6934
  {21,  2}, // #6935
  { 1,  1}, // #6936
  {11,  2}, // #6937
  {16,  2}, // #6938
  {22,  2}, // #6939
  { 1,  1}, // #6940
  {11, 22}, // #6941
  {15, 22}, // #6942
  {18, 22}, // #6943
  {20, 22}, // #6944
  {21, 22}, // #6945
  {22, 22}, // #6946
  {11, 15}, // #6947
  {15, 15}, // #6948
  {18, 15}, // #6949
  {20, 15}, // #6950
  {21, 15}, // #6951
  {22, 15}, // #6952
  { 1,  1}, // #6953
  {11, 19}, // #6954
  {15, 19}, // #6955
  {18, 19}, // #6956
  {20, 19}, // #6957
  {21, 19}, // #6958
  {22, 19}, // #6959
  {11, 12}, // #6960
  {15, 12}, // #6961
  {18, 12}, // #6962
  {20, 12}, // #6963
  {21, 12}, // #6964
  {22, 12}, // #6965
  { 1,  1}, // #6966
  {11,  3}, // #6967
  {16,  3}, // #6968
  {22,  3}, // #6969
  { 1,  1}, // #6970
  {11,  4}, // #6971
  {19,  4}, // #6972
  {11,  2}, // #6973
  {14,  2}, // #6974
  {17,  2}, // #6975
  {19,  2}, // #6976
  {21,  2}, // #6977
  { 1,  1}, // #6978
  {11,  2}, // #6979
  {12,  2}, // #6980
  {16,  2}, // #6981
  {17,  2}, // #6982
  {18,  2}, // #6983
  {22,  2}, // #6984
  { 1,  1}, // #6985
  {11,  2}, // #6986
  {14,  2}, // #6987
  {17,  2}, // #6988
  {19,  2}, // #6989
  {21,  2}, // #6990
  { 1,  1}, // #6991
  {11,  2}, // #6992
  {13,  2}, // #6993
  {16,  2}, // #6994
  {19,  2}, // #6995
  {20,  2}, // #6996
  {22,  2}, // #6997
  { 1,  1}, // #6998
  {11,  4}, // #6999
  {13,  4}, // #7000
  {16,  4}, // #7001
  {19,  4}, // #7002
  {20,  4}, // #7003
  {22,  4}, // #7004
  { 1,  1}, // #7005
  {11, 40}, // #7006
  {15, 40}, // #7007
  {18, 40}, // #7008
  {20, 40}, // #7009
  {21, 40}, // #7010
  {22, 40}, // #7011
  { 1,  1}, // #7012
  {11, 28}, // #7013
  {15, 28}, // #7014
  {18, 28}, // #7015
  {20, 28}, // #7016
  {21, 28}, // #7017
  {22, 28}, // #7018
  {11,  2}, // #7019
  {15,  1}, // #7020
  {18,  1}, // #7021
  {19,  1}, // #7022
  {20,  1}, // #7023
  {21,  1}, // #7024
  {22,  1}, // #7025
  { 1,  1}, // #7026
  {11,  2}, // #7027
  {15,  1}, // #7028
  {18,  1}, // #7029
  {19,  1}, // #7030
  {20,  1}, // #7031
  {21,  1}, // #7032
  {22,  1}, // #7033
  { 1,  1}, // #7034
  {11,  1}, // #7035
  {17,  1}, // #7036
  { 1,  5}, // #7037
  {11,  3}, // #7038
  {14,  2}, // #7039
  {17,  2}, // #7040
  {19,  3}, // #7041
  {21,  2}, // #7042
  { 1,  1}, // #7043
  {11,  2}, // #7044
  {22,  2}, // #7045
  { 1,  1}, // #7046
  {11,  2}, // #7047
  {14,  1}, // #7048
  {15,  1}, // #7049
  {17,  1}, // #7050
  {18,  1}, // #7051
  {19,  1}, // #7052
  {20,  1}, // #7053
  {21,  2}, // #7054
  {22,  1}, // #7055
  { 1,  1}, // #7056
  {11,  3}, // #7057
  {18,  3}, // #7058
  {22,  3}, // #7059
  {11,  2}, // #7060
  {15,  1}, // #7061
  {18,  1}, // #7062
  {20,  1}, // #7063
  {21,  1}, // #7064
  {22,  2}, // #7065
  { 1,  1}, // #7066
  { 4,  1}, // #7067
  { 9,  1}, // #7068
  {11,  1}, // #7069
  {22,  1}, // #7070
  { 1,  1}, // #7071
  {11,  1}, // #7072
  {22,  1}, // #7073
  {11,  2}, // #7074
  {14,  1}, // #7075
  {17,  1}, // #7076
  {19,  2}, // #7077
  {21,  1}, // #7078
  {11,  2}, // #7079
  {13,  1}, // #7080
  {16,  1}, // #7081
  {18,  1}, // #7082
  {19,  1}, // #7083
  {20,  1}, // #7084
  {22,  2}, // #7085
  {11,  1}, // #7086
  {13,  1}, // #7087
  {16,  1}, // #7088
  {19,  1}, // #7089
  {20,  1}, // #7090
  {22,  1}, // #7091
  { 1,  1}, // #7092
  {11,  1}, // #7093
  {13,  1}, // #7094
  {16,  1}, // #7095
  {19,  1}, // #7096
  {20,  1}, // #7097
  {22,  1}, // #7098
  {12,  1}, // #7099
  {16,  1}, // #7100
  {19,  1}, // #7101
  {21,  1}, // #7102
  {22,  1}, // #7103
  {23,  1}, // #7104
  { 1,  2}, // #7105
  { 5,  1}, // #7106
  { 1,  1}, // #7107
  {12,  1}, // #7108
  {22,  1}, // #7109
  { 1,  1}, // #7110
  {12,  1}, // #7111
  {17,  1}, // #7112
  {23,  1}, // #7113
  { 1,  1}, // #7114
  { 5, 12}, // #7115
  { 1,  1}, // #7116
  { 5, 16}, // #7117
  { 1,  1}, // #7118
  {12,  2}, // #7119
  {15,  1}, // #7120
  {17,  1}, // #7121
  {18,  1}, // #7122
  {20,  1}, // #7123
  {22,  1}, // #7124
  {23,  1}, // #7125
  { 1,  1}, // #7126
  {12,  1}, // #7127
  {13,  1}, // #7128
  {17,  1}, // #7129
  {18,  1}, // #7130
  {19,  1}, // #7131
  {23,  1}, // #7132
  { 1,  1}, // #7133
  {12,  1}, // #7134
  {16,  1}, // #7135
  {19,  1}, // #7136
  {21,  1}, // #7137
  {22,  1}, // #7138
  {23,  1}, // #7139
  { 1,  1}, // #7140
  {12,  1}, // #7141
  {19,  1}, // #7142
  {23,  1}, // #7143
  { 1,  1}, // #7144
  {12,  2}, // #7145
  {16,  2}, // #7146
  {19,  2}, // #7147
  {21,  2}, // #7148
  {22,  2}, // #7149
  {23,  2}, // #7150
  { 1,  1}, // #7151
  { 5,  1}, // #7152
  { 8,  1}, // #7153
  {11, 17}, // #7154
  { 1,  1}, // #7155
  { 5,  1}, // #7156
  { 8,  1}, // #7157
  {11, 25}, // #7158
  { 1,  1}, // #7159
  { 5,  1}, // #7160
  { 8,  1}, // #7161
  {11, 41}, // #7162
  { 1,  1}, // #7163
  { 5,  1}, // #7164
  { 8,  1}, // #7165
  {11, 15}, // #7166
  { 1,  1}, // #7167
  {12,  5}, // #7168
  {15,  3}, // #7169
  {18,  3}, // #7170
  {20,  5}, // #7171
  {22,  3}, // #7172
  {12,  3}, // #7173
  {15,  2}, // #7174
  {18,  2}, // #7175
  {20,  3}, // #7176
  {22,  2}, // #7177
  { 1,  1}, // #7178
  { 5,  1}, // #7179
  { 7,  1}, // #7180
  {24,  1}, // #7181
  { 1,  1}, // #7182
  {12,  1}, // #7183
  {20,  1}, // #7184
  { 1,  1}, // #7185
  {12,  1}, // #7186
  {21,  1}, // #7187
  {23,  1}, // #7188
  {12,  1}, // #7189
  {15,  1}, // #7190
  {18,  1}, // #7191
  {20,  1}, // #7192
  {22,  1}, // #7193
  { 1,  1}, // #7194
  {12,  1}, // #7195
  {15,  1}, // #7196
  {18,  1}, // #7197
  {20,  1}, // #7198
  {22,  1}, // #7199
  { 1,  1}, // #7200
  { 5,  1}, // #7201
  { 7,  1}, // #7202
  {24,  2}, // #7203
  { 1,  1}, // #7204
  {12,  2}, // #7205
  {20,  2}, // #7206
  { 1,  1}, // #7207
  {12,  2}, // #7208
  {18,  2}, // #7209
  {12,  1}, // #7210
  {18,  1}, // #7211
  { 1,  1}, // #7212
  {12, 20}, // #7213
  {16, 20}, // #7214
  {19, 20}, // #7215
  {21, 20}, // #7216
  {22, 20}, // #7217
  {23, 20}, // #7218
  {12, 13}, // #7219
  {16, 13}, // #7220
  {19, 13}, // #7221
  {21, 13}, // #7222
  {22, 13}, // #7223
  {23, 13}, // #7224
  { 1,  1}, // #7225
  {12, 17}, // #7226
  {16, 17}, // #7227
  {19, 17}, // #7228
  {21, 17}, // #7229
  {22, 17}, // #7230
  {23, 17}, // #7231
  {12, 10}, // #7232
  {16, 10}, // #7233
  {19, 10}, // #7234
  {21, 10}, // #7235
  {22, 10}, // #7236
  {23, 10}, // #7237
  { 1,  1}, // #7238
  {12,  2}, // #7239
  {17,  2}, // #7240
  {23,  2}, // #7241
  {12,  2}, // #7242
  {15,  2}, // #7243
  {18,  2}, // #7244
  {20,  2}, // #7245
  {22,  2}, // #7246
  { 1,  1}, // #7247
  {12,  2}, // #7248
  {14,  2}, // #7249
  {17,  2}, // #7250
  {20,  2}, // #7251
  {21,  2}, // #7252
  {23,  2}, // #7253
  { 1,  1}, // #7254
  {12, 28}, // #7255
  {16, 28}, // #7256
  {19, 28}, // #7257
  {21, 28}, // #7258
  {22, 28}, // #7259
  {23, 28}, // #7260
  {12,  2}, // #7261
  {16,  1}, // #7262
  {19,  1}, // #7263
  {20,  1}, // #7264
  {21,  1}, // #7265
  {22,  1}, // #7266
  {23,  1}, // #7267
  { 1,  1}, // #7268
  {12,  2}, // #7269
  {16,  1}, // #7270
  {19,  1}, // #7271
  {20,  1}, // #7272
  {21,  1}, // #7273
  {22,  1}, // #7274
  {23,  1}, // #7275
  { 1,  1}, // #7276
  {12,  1}, // #7277
  {18,  1}, // #7278
  { 1,  5}, // #7279
  {12,  3}, // #7280
  {15,  2}, // #7281
  {18,  2}, // #7282
  {20,  3}, // #7283
  {22,  2}, // #7284
  { 1,  1}, // #7285
  {12,  1}, // #7286
  {23,  1}, // #7287
  { 1,  1}, // #7288
  {12,  2}, // #7289
  {15,  1}, // #7290
  {16,  1}, // #7291
  {18,  1}, // #7292
  {19,  1}, // #7293
  {20,  1}, // #7294
  {21,  1}, // #7295
  {22,  2}, // #7296
  {23,  1}, // #7297
  { 1,  1}, // #7298
  {12,  3}, // #7299
  {19,  3}, // #7300
  {23,  3}, // #7301
  { 1,  1}, // #7302
  {12,  3}, // #7303
  {17,  3}, // #7304
  {23,  3}, // #7305
  {12,  2}, // #7306
  {16,  1}, // #7307
  {19,  1}, // #7308
  {21,  1}, // #7309
  {22,  1}, // #7310
  {23,  2}, // #7311
  { 1,  1}, // #7312
  { 5,  1}, // #7313
  {10,  1}, // #7314
  {12,  2}, // #7315
  {15,  1}, // #7316
  {18,  1}, // #7317
  {20,  2}, // #7318
  {22,  1}, // #7319
  {12,  2}, // #7320
  {14,  1}, // #7321
  {17,  1}, // #7322
  {19,  1}, // #7323
  {20,  1}, // #7324
  {21,  1}, // #7325
  {23,  2}, // #7326
  {12,  1}, // #7327
  {14,  1}, // #7328
  {17,  1}, // #7329
  {20,  1}, // #7330
  {21,  1}, // #7331
  {23,  1}, // #7332
  { 1,  1}, // #7333
  {12,  1}, // #7334
  {14,  1}, // #7335
  {17,  1}, // #7336
  {20,  1}, // #7337
  {21,  1}, // #7338
  {23,  1}, // #7339
  {11,  1}, // #7340
  {36,  1}, // #7341
  {11,  0}, // #7342
  {36,  0}, // #7343
  {14,  1}, // #7344
  {20,  1}, // #7345
  {28,  1}, // #7346
  {31,  1}, // #7347
  {32,  1}, // #7348
  {13,  1}, // #7349
  {36,  1}, // #7350
  {11, 12}, // #7351
  {36, 12}, // #7352
  { 4,  1}, // #7353
  {13,  1}, // #7354
  {36,  2}, // #7355
  {37,  1}, // #7356
  {38,  1}, // #7357
  {11,  4}, // #7358
  {36,  4}, // #7359
  {11, 100}, // #7360
  {36, 100}, // #7361
  {10,  3}, // #7362
  {11,  3}, // #7363
  {36,  3}, // #7364
  {26,  1}, // #7365
  {27,  1}, // #7366
  {37,  1}, // #7367
  {39,  1}, // #7368
  {14,  1}, // #7369
  {26,  1}, // #7370
  {37,  1}, // #7371
  {38,  1}, // #7372
  {14,  2}, // #7373
  {15,  2}, // #7374
  {16,  2}, // #7375
  {20,  2}, // #7376
  {21,  2}, // #7377
  {28,  2}, // #7378
  {29,  2}, // #7379
  {31,  2}, // #7380
  {32,  2}, // #7381
  { 4,  2}, // #7382
  {11,  4}, // #7383
  {36,  6}, // #7384
  {37,  2}, // #7385
  {38,  1}, // #7386
  {39,  1}, // #7387
  { 4,  1}, // #7388
  {11,  4}, // #7389
  {36,  5}, // #7390
  {37,  1}, // #7391
  {38,  1}, // #7392
  { 4,  2}, // #7393
  {11,  1}, // #7394
  {36,  3}, // #7395
  {37,  2}, // #7396
  {38,  1}, // #7397
  {39,  1}, // #7398
  { 4,  1}, // #7399
  {11,  1}, // #7400
  {36,  2}, // #7401
  {37,  1}, // #7402
  {38,  1}, // #7403
  {14,  2}, // #7404
  {17,  1}, // #7405
  {18,  1}, // #7406
  {20,  1}, // #7407
  {26,  1}, // #7408
  {28,  1}, // #7409
  {31,  1}, // #7410
  {32,  1}, // #7411
  {37,  1}, // #7412
  {38,  1}, // #7413
  {14,  1}, // #7414
  {17,  1}, // #7415
  {18,  1}, // #7416
  {20,  1}, // #7417
  {28,  1}, // #7418
  {31,  1}, // #7419
  {32,  1}, // #7420
  {14,  2}, // #7421
  {15,  1}, // #7422
  {16,  1}, // #7423
  {20,  1}, // #7424
  {21,  1}, // #7425
  {26,  1}, // #7426
  {28,  1}, // #7427
  {29,  1}, // #7428
  {31,  1}, // #7429
  {32,  1}, // #7430
  {37,  1}, // #7431
  {38,  1}, // #7432
  {14,  1}, // #7433
  {15,  1}, // #7434
  {16,  1}, // #7435
  {20,  1}, // #7436
  {21,  1}, // #7437
  {28,  1}, // #7438
  {29,  1}, // #7439
  {31,  1}, // #7440
  {32,  1}, // #7441
  {14,  2}, // #7442
  {20,  1}, // #7443
  {26,  1}, // #7444
  {28,  1}, // #7445
  {31,  1}, // #7446
  {32,  1}, // #7447
  {37,  1}, // #7448
  {38,  1}, // #7449
  { 4,  1}, // #7450
  {10,  1}, // #7451
  {11,  1}, // #7452
  {36,  2}, // #7453
  {37,  1}, // #7454
  {38,  1}, // #7455
  {10,  1}, // #7456
  {11,  1}, // #7457
  {36,  1}, // #7458
  { 4,  1}, // #7459
  {11,  2}, // #7460
  {36,  3}, // #7461
  {37,  1}, // #7462
  {38,  1}, // #7463
  {11,  2}, // #7464
  {36,  2}, // #7465
  { 4,  1}, // #7466
  { 6,  3}, // #7467
  {10,  3}, // #7468
  {11,  3}, // #7469
  {36,  4}, // #7470
  {37,  1}, // #7471
  {38,  1}, // #7472
  { 6,  3}, // #7473
  {10,  3}, // #7474
  {11,  3}, // #7475
  {36,  3}, // #7476
  { 4,  1}, // #7477
  { 6,  4}, // #7478
  {10,  4}, // #7479
  {11,  4}, // #7480
  {36,  5}, // #7481
  {37,  1}, // #7482
  {38,  1}, // #7483
  { 6,  4}, // #7484
  {10,  4}, // #7485
  {11,  4}, // #7486
  {36,  4}, // #7487
  { 4,  2}, // #7488
  {10,  1}, // #7489
  {11,  1}, // #7490
  {36,  3}, // #7491
  {37,  2}, // #7492
  {38,  1}, // #7493
  {39,  1}, // #7494
  {10,  2}, // #7495
  {11,  2}, // #7496
  {36,  2}, // #7497
  { 4,  1}, // #7498
  {36,  1}, // #7499
  {37,  1}, // #7500
  {38,  1}, // #7501
  { 4,  1}, // #7502
  { 9,  1}, // #7503
  {11,  1}, // #7504
  {36,  2}, // #7505
  {37,  1}, // #7506
  {38,  1}, // #7507
  { 9,  1}, // #7508
  {11,  1}, // #7509
  {36,  1}, // #7510
  {11, 28}, // #7511
  {36, 28}, // #7512
  {14,  3}, // #7513
  {15,  2}, // #7514
  {16,  2}, // #7515
  {20,  2}, // #7516
  {21,  2}, // #7517
  {26,  1}, // #7518
  {28,  2}, // #7519
  {29,  2}, // #7520
  {31,  2}, // #7521
  {32,  2}, // #7522
  {37,  1}, // #7523
  {38,  1}, // #7524
  { 4,  1}, // #7525
  { 6,  1}, // #7526
  {10,  1}, // #7527
  {11,  1}, // #7528
  {36,  2}, // #7529
  {37,  1}, // #7530
  {38,  1}, // #7531
  { 6,  1}, // #7532
  {10,  1}, // #7533
  {11,  1}, // #7534
  {36,  1}, // #7535
  {14,  3}, // #7536
  {17,  2}, // #7537
  {18,  2}, // #7538
  {20,  2}, // #7539
  {26,  1}, // #7540
  {28,  2}, // #7541
  {31,  2}, // #7542
  {32,  2}, // #7543
  {37,  1}, // #7544
  {38,  1}, // #7545
  {14,  2}, // #7546
  {17,  2}, // #7547
  {18,  2}, // #7548
  {20,  2}, // #7549
  {28,  2}, // #7550
  {31,  2}, // #7551
  {32,  2}, // #7552
  { 4,  1}, // #7553
  { 5, 11}, // #7554
  { 9, 11}, // #7555
  {11, 11}, // #7556
  {13, 11}, // #7557
  {36, 12}, // #7558
  {37,  1}, // #7559
  {38,  1}, // #7560
  { 5, 11}, // #7561
  { 9, 11}, // #7562
  {11, 11}, // #7563
  {13, 11}, // #7564
  {36, 11}, // #7565
  { 4,  1}, // #7566
  { 5, 13}, // #7567
  { 9, 13}, // #7568
  {11, 13}, // #7569
  {13, 13}, // #7570
  {36, 14}, // #7571
  {37,  1}, // #7572
  {38,  1}, // #7573
  { 5, 13}, // #7574
  { 9, 13}, // #7575
  {11, 13}, // #7576
  {13, 13}, // #7577
  {36, 13}, // #7578
  { 4,  1}, // #7579
  { 5, 17}, // #7580
  { 9, 17}, // #7581
  {11, 17}, // #7582
  {13, 17}, // #7583
  {36, 18}, // #7584
  {37,  1}, // #7585
  {38,  1}, // #7586
  { 5, 17}, // #7587
  { 9, 17}, // #7588
  {11, 17}, // #7589
  {13, 17}, // #7590
  {36, 17}, // #7591
  { 4,  1}, // #7592
  { 5, 10}, // #7593
  { 9, 10}, // #7594
  {11, 10}, // #7595
  {13, 10}, // #7596
  {36, 11}, // #7597
  {37,  1}, // #7598
  {38,  1}, // #7599
  { 5, 10}, // #7600
  { 9, 10}, // #7601
  {11, 10}, // #7602
  {13, 10}, // #7603
  {36, 10}, // #7604
  {14,  6}, // #7605
  {15,  5}, // #7606
  {16,  5}, // #7607
  {19,  5}, // #7608
  {20,  5}, // #7609
  {21,  5}, // #7610
  {23,  5}, // #7611
  {26,  1}, // #7612
  {28,  5}, // #7613
  {29,  5}, // #7614
  {30,  5}, // #7615
  {31,  5}, // #7616
  {32,  5}, // #7617
  {34,  5}, // #7618
  {35,  5}, // #7619
  {37,  1}, // #7620
  {38,  1}, // #7621
  {14,  5}, // #7622
  {15,  5}, // #7623
  {16,  5}, // #7624
  {19,  5}, // #7625
  {20,  5}, // #7626
  {21,  5}, // #7627
  {23,  5}, // #7628
  {28,  5}, // #7629
  {29,  5}, // #7630
  {30,  5}, // #7631
  {31,  5}, // #7632
  {32,  5}, // #7633
  {34,  5}, // #7634
  {35,  5}, // #7635
  {14,  4}, // #7636
  {15,  3}, // #7637
  {16,  3}, // #7638
  {19,  3}, // #7639
  {20,  3}, // #7640
  {21,  3}, // #7641
  {23,  3}, // #7642
  {26,  1}, // #7643
  {28,  3}, // #7644
  {29,  3}, // #7645
  {30,  3}, // #7646
  {31,  3}, // #7647
  {32,  3}, // #7648
  {34,  3}, // #7649
  {35,  3}, // #7650
  {37,  1}, // #7651
  {38,  1}, // #7652
  {14,  3}, // #7653
  {15,  3}, // #7654
  {16,  3}, // #7655
  {19,  3}, // #7656
  {20,  3}, // #7657
  {21,  3}, // #7658
  {23,  3}, // #7659
  {28,  3}, // #7660
  {29,  3}, // #7661
  {30,  3}, // #7662
  {31,  3}, // #7663
  {32,  3}, // #7664
  {34,  3}, // #7665
  {35,  3}, // #7666
  {14,  7}, // #7667
  {15,  6}, // #7668
  {16,  6}, // #7669
  {20,  6}, // #7670
  {21,  6}, // #7671
  {26,  1}, // #7672
  {28,  6}, // #7673
  {29,  6}, // #7674
  {31,  6}, // #7675
  {32,  6}, // #7676
  {37,  1}, // #7677
  {38,  1}, // #7678
  {14,  6}, // #7679
  {15,  6}, // #7680
  {16,  6}, // #7681
  {20,  6}, // #7682
  {21,  6}, // #7683
  {28,  6}, // #7684
  {29,  6}, // #7685
  {31,  6}, // #7686
  {32,  6}, // #7687
  {14,  9}, // #7688
  {15,  8}, // #7689
  {16,  8}, // #7690
  {20,  8}, // #7691
  {21,  8}, // #7692
  {26,  1}, // #7693
  {28,  8}, // #7694
  {29,  8}, // #7695
  {31,  8}, // #7696
  {32,  8}, // #7697
  {37,  1}, // #7698
  {38,  1}, // #7699
  {14,  8}, // #7700
  {15,  8}, // #7701
  {16,  8}, // #7702
  {20,  8}, // #7703
  {21,  8}, // #7704
  {28,  8}, // #7705
  {29,  8}, // #7706
  {31,  8}, // #7707
  {32,  8}, // #7708
  { 4,  1}, // #7709
  {36,  1}, // #7710
  {37,  2}, // #7711
  {39,  2}, // #7712
  {14,  2}, // #7713
  {26,  2}, // #7714
  {14,  2}, // #7715
  {15,  1}, // #7716
  {16,  1}, // #7717
  {19,  1}, // #7718
  {20,  1}, // #7719
  {21,  1}, // #7720
  {23,  1}, // #7721
  {26,  1}, // #7722
  {28,  1}, // #7723
  {29,  1}, // #7724
  {30,  1}, // #7725
  {31,  1}, // #7726
  {32,  1}, // #7727
  {34,  1}, // #7728
  {35,  1}, // #7729
  {37,  1}, // #7730
  {38,  1}, // #7731
  {14,  3}, // #7732
  {17,  2}, // #7733
  {18,  2}, // #7734
  {19,  2}, // #7735
  {20,  2}, // #7736
  {24,  2}, // #7737
  {26,  1}, // #7738
  {28,  2}, // #7739
  {30,  2}, // #7740
  {31,  2}, // #7741
  {32,  2}, // #7742
  {34,  2}, // #7743
  {35,  2}, // #7744
  {37,  1}, // #7745
  {38,  1}, // #7746
  {14,  2}, // #7747
  {17,  2}, // #7748
  {18,  2}, // #7749
  {19,  2}, // #7750
  {20,  2}, // #7751
  {24,  2}, // #7752
  {28,  2}, // #7753
  {30,  2}, // #7754
  {31,  2}, // #7755
  {32,  2}, // #7756
  {34,  2}, // #7757
  {35,  2}, // #7758
  {14,  2}, // #7759
  {19,  1}, // #7760
  {20,  1}, // #7761
  {26,  1}, // #7762
  {28,  1}, // #7763
  {30,  1}, // #7764
  {31,  1}, // #7765
  {32,  1}, // #7766
  {34,  1}, // #7767
  {35,  1}, // #7768
  {37,  1}, // #7769
  {38,  1}, // #7770
  {14,  1}, // #7771
  {19,  1}, // #7772
  {20,  1}, // #7773
  {28,  1}, // #7774
  {30,  1}, // #7775
  {31,  1}, // #7776
  {32,  1}, // #7777
  {34,  1}, // #7778
  {35,  1}, // #7779
  { 8,  1}, // #7780
  { 9,  1}, // #7781
  {11,  1}, // #7782
  {36,  1}, // #7783
  { 4,  1}, // #7784
  {11,  6}, // #7785
  {36,  7}, // #7786
  {37,  1}, // #7787
  {38,  1}, // #7788
  {14,  3}, // #7789
  {15,  2}, // #7790
  {16,  2}, // #7791
  {20,  2}, // #7792
  {21,  2}, // #7793
  {22,  2}, // #7794
  {26,  1}, // #7795
  {28,  2}, // #7796
  {29,  2}, // #7797
  {31,  2}, // #7798
  {32,  2}, // #7799
  {33,  2}, // #7800
  {37,  1}, // #7801
  {38,  1}, // #7802
  {14,  2}, // #7803
  {15,  2}, // #7804
  {16,  2}, // #7805
  {20,  2}, // #7806
  {21,  2}, // #7807
  {22,  2}, // #7808
  {28,  2}, // #7809
  {29,  2}, // #7810
  {31,  2}, // #7811
  {32,  2}, // #7812
  {33,  2}, // #7813
  {14,  3}, // #7814
  {26,  3}, // #7815
  {37,  1}, // #7816
  {38,  1}, // #7817
  {14,  2}, // #7818
  {20,  1}, // #7819
  {26,  1}, // #7820
  {28,  1}, // #7821
  {31,  1}, // #7822
  {32,  1}, // #7823
  {33,  1}, // #7824
  {37,  1}, // #7825
  {38,  1}, // #7826
  {14,  1}, // #7827
  {20,  1}, // #7828
  {28,  1}, // #7829
  {31,  1}, // #7830
  {32,  1}, // #7831
  {33,  1}, // #7832
  {14,  1}, // #7833
  {17,  1}, // #7834
  {18,  1}, // #7835
  {19,  1}, // #7836
  {20,  1}, // #7837
  {24,  1}, // #7838
  {28,  1}, // #7839
  {30,  1}, // #7840
  {31,  1}, // #7841
  {32,  1}, // #7842
  {34,  1}, // #7843
  {35,  1}, // #7844
  {14,  3}, // #7845
  {20,  2}, // #7846
  {26,  1}, // #7847
  {28,  2}, // #7848
  {31,  2}, // #7849
  {32,  2}, // #7850
  {37,  1}, // #7851
  {38,  1}, // #7852
  {14,  2}, // #7853
  {20,  2}, // #7854
  {28,  2}, // #7855
  {31,  2}, // #7856
  {32,  2}, // #7857
  {14,  9}, // #7858
  {20,  8}, // #7859
  {26,  1}, // #7860
  {28,  8}, // #7861
  {31,  8}, // #7862
  {32,  8}, // #7863
  {37,  1}, // #7864
  {38,  1}, // #7865
  {14,  8}, // #7866
  {20,  8}, // #7867
  {28,  8}, // #7868
  {31,  8}, // #7869
  {32,  8}, // #7870
  {14,  5}, // #7871
  {15,  4}, // #7872
  {16,  4}, // #7873
  {20,  4}, // #7874
  {21,  4}, // #7875
  {26,  1}, // #7876
  {28,  4}, // #7877
  {29,  4}, // #7878
  {31,  4}, // #7879
  {32,  4}, // #7880
  {37,  1}, // #7881
  {38,  1}, // #7882
  {14,  4}, // #7883
  {15,  4}, // #7884
  {16,  4}, // #7885
  {20,  4}, // #7886
  {21,  4}, // #7887
  {28,  4}, // #7888
  {29,  4}, // #7889
  {31,  4}, // #7890
  {32,  4}, // #7891
  {14, 13}, // #7892
  {20, 12}, // #7893
  {26,  1}, // #7894
  {28, 12}, // #7895
  {31, 12}, // #7896
  {32, 12}, // #7897
  {37,  1}, // #7898
  {38,  1}, // #7899
  {14, 12}, // #7900
  {20, 12}, // #7901
  {28, 12}, // #7902
  {31, 12}, // #7903
  {32, 12}, // #7904
  { 4,  2}, // #7905
  {36,  2}, // #7906
  {37,  3}, // #7907
  {38,  1}, // #7908
  {39,  2}, // #7909
  {14,  2}, // #7910
  {19,  1}, // #7911
  {20,  1}, // #7912
  {26,  2}, // #7913
  {27,  1}, // #7914
  {28,  1}, // #7915
  {30,  1}, // #7916
  {31,  1}, // #7917
  {32,  1}, // #7918
  {34,  1}, // #7919
  {35,  1}, // #7920
  {37,  1}, // #7921
  {38,  1}, // #7922
  {14,  1}, // #7923
  {19,  1}, // #7924
  {20,  1}, // #7925
  {26,  1}, // #7926
  {27,  1}, // #7927
  {28,  1}, // #7928
  {30,  1}, // #7929
  {31,  1}, // #7930
  {32,  1}, // #7931
  {34,  1}, // #7932
  {35,  1}, // #7933
  { 4,  1}, // #7934
  {36,  1}, // #7935
  {37,  1}, // #7936
  {39,  1}, // #7937
  {14,  1}, // #7938
  {15,  1}, // #7939
  {16,  1}, // #7940
  {19,  1}, // #7941
  {20,  1}, // #7942
  {21,  1}, // #7943
  {23,  1}, // #7944
  {28,  1}, // #7945
  {29,  1}, // #7946
  {30,  1}, // #7947
  {31,  1}, // #7948
  {32,  1}, // #7949
  {34,  1}, // #7950
  {35,  1}, // #7951
  { 4,  1}, // #7952
  { 9,  2}, // #7953
  {11,  2}, // #7954
  {36,  3}, // #7955
  {37,  1}, // #7956
  {39,  1}, // #7957
  { 9,  2}, // #7958
  {11,  2}, // #7959
  {36,  2}, // #7960
  { 4,  1}, // #7961
  {10,  4}, // #7962
  {11,  4}, // #7963
  {36,  5}, // #7964
  {37,  1}, // #7965
  {38,  1}, // #7966
  {14, 10}, // #7967
  {15,  9}, // #7968
  {16,  9}, // #7969
  {19,  9}, // #7970
  {20,  9}, // #7971
  {21,  9}, // #7972
  {23,  9}, // #7973
  {26,  1}, // #7974
  {28,  9}, // #7975
  {29,  9}, // #7976
  {30,  9}, // #7977
  {31,  9}, // #7978
  {32,  9}, // #7979
  {34,  9}, // #7980
  {35,  9}, // #7981
  {37,  1}, // #7982
  {38,  1}, // #7983
  {14,  9}, // #7984
  {15,  9}, // #7985
  {16,  9}, // #7986
  {19,  9}, // #7987
  {20,  9}, // #7988
  {21,  9}, // #7989
  {23,  9}, // #7990
  {28,  9}, // #7991
  {29,  9}, // #7992
  {30,  9}, // #7993
  {31,  9}, // #7994
  {32,  9}, // #7995
  {34,  9}, // #7996
  {35,  9}, // #7997
  {14, 23}, // #7998
  {15, 23}, // #7999
  {16, 23}, // #8000
  {19, 23}, // #8001
  {20, 23}, // #8002
  {21, 23}, // #8003
  {23, 23}, // #8004
  {28, 23}, // #8005
  {29, 23}, // #8006
  {30, 23}, // #8007
  {31, 23}, // #8008
  {32, 23}, // #8009
  {34, 23}, // #8010
  {35, 23}, // #8011
  { 4,  1}, // #8012
  {11, 60}, // #8013
  {36, 61}, // #8014
  {37,  1}, // #8015
  {39,  1}, // #8016
  {14,  2}, // #8017
  {17,  2}, // #8018
  {18,  2}, // #8019
  {20,  2}, // #8020
  {26,  1}, // #8021
  {27,  1}, // #8022
  {28,  2}, // #8023
  {31,  2}, // #8024
  {32,  2}, // #8025
  {37,  1}, // #8026
  {39,  1}, // #8027
  {14,  1}, // #8028
  {17,  1}, // #8029
  {18,  1}, // #8030
  {20,  1}, // #8031
  {26,  1}, // #8032
  {27,  1}, // #8033
  {28,  1}, // #8034
  {31,  1}, // #8035
  {32,  1}, // #8036
  {37,  1}, // #8037
  {39,  1}, // #8038
  {26,  6}, // #8039
  {27,  6}, // #8040
  {37,  1}, // #8041
  {39,  1}, // #8042
  {26,  4}, // #8043
  {27,  4}, // #8044
  {37,  1}, // #8045
  {39,  1}, // #8046
  {26, 12}, // #8047
  {27, 12}, // #8048
  {37,  1}, // #8049
  {39,  1}, // #8050
  {14,  4}, // #8051
  {19,  3}, // #8052
  {20,  3}, // #8053
  {26,  1}, // #8054
  {28,  3}, // #8055
  {30,  3}, // #8056
  {31,  3}, // #8057
  {32,  3}, // #8058
  {34,  3}, // #8059
  {35,  3}, // #8060
  {37,  1}, // #8061
  {38,  1}, // #8062
  {14,  3}, // #8063
  {19,  3}, // #8064
  {20,  3}, // #8065
  {28,  3}, // #8066
  {30,  3}, // #8067
  {31,  3}, // #8068
  {32,  3}, // #8069
  {34,  3}, // #8070
  {35,  3}, // #8071
  {14,  3}, // #8072
  {19,  2}, // #8073
  {20,  2}, // #8074
  {26,  1}, // #8075
  {28,  2}, // #8076
  {30,  2}, // #8077
  {31,  2}, // #8078
  {32,  2}, // #8079
  {34,  2}, // #8080
  {35,  2}, // #8081
  {37,  1}, // #8082
  {38,  1}, // #8083
  {14,  2}, // #8084
  {19,  2}, // #8085
  {20,  2}, // #8086
  {28,  2}, // #8087
  {30,  2}, // #8088
  {31,  2}, // #8089
  {32,  2}, // #8090
  {34,  2}, // #8091
  {35,  2}, // #8092
  {11,  8}, // #8093
  {36,  8}, // #8094
  { 4,  1}, // #8095
  {10,  8}, // #8096
  {11,  8}, // #8097
  {36,  9}, // #8098
  {37,  1}, // #8099
  {38,  1}, // #8100
  {37, 30}, // #8101
  { 4,  3}, // #8102
  {36,  3}, // #8103
  {37,  1}, // #8104
  {38,  1}, // #8105
  { 4,  1}, // #8106
  {11, 12}, // #8107
  {36, 13}, // #8108
  {37,  1}, // #8109
  {38,  1}, // #8110
  {11, 24}, // #8111
  {36, 24}, // #8112
  {11, 59}, // #8113
  {36, 59}, // #8114
  {10,  6}, // #8115
  {11,  6}, // #8116
  {36,  6}, // #8117
  {10,  8}, // #8118
  {11,  8}, // #8119
  {36,  8}, // #8120
  { 4,  1}, // #8121
  {14,  1}, // #8122
  {15,  1}, // #8123
  {16,  1}, // #8124
  {20,  1}, // #8125
  {21,  1}, // #8126
  {22,  1}, // #8127
  {28,  1}, // #8128
  {29,  1}, // #8129
  {31,  1}, // #8130
  {32,  1}, // #8131
  {33,  1}, // #8132
  {36,  1}, // #8133
  {37,  1}, // #8134
  {38,  1}, // #8135
  { 4,  1}, // #8136
  {14, 24}, // #8137
  {20, 24}, // #8138
  {28, 24}, // #8139
  {31, 24}, // #8140
  {32, 24}, // #8141
  {36,  1}, // #8142
  {37,  1}, // #8143
  {38,  1}, // #8144
  { 4,  1}, // #8145
  {14, 62}, // #8146
  {20, 62}, // #8147
  {28, 62}, // #8148
  {31, 62}, // #8149
  {32, 62}, // #8150
  {36,  1}, // #8151
  {37,  1}, // #8152
  {38,  1}, // #8153
  { 4,  1}, // #8154
  {11,  4}, // #8155
  {36,  5}, // #8156
  {37,  1}, // #8157
  {39,  1}, // #8158
  {14,  6}, // #8159
  {17,  6}, // #8160
  {18,  6}, // #8161
  {20,  6}, // #8162
  {28,  6}, // #8163
  {31,  6}, // #8164
  {32,  6}, // #8165
  { 4,  1}, // #8166
  {14,  1}, // #8167
  {15,  1}, // #8168
  {16,  1}, // #8169
  {19,  1}, // #8170
  {20,  1}, // #8171
  {21,  1}, // #8172
  {23,  1}, // #8173
  {28,  1}, // #8174
  {29,  1}, // #8175
  {30,  1}, // #8176
  {31,  1}, // #8177
  {32,  1}, // #8178
  {34,  1}, // #8179
  {35,  1}, // #8180
  {36,  1}, // #8181
  {37,  1}, // #8182
  {38,  1}, // #8183
  {14,  1}, // #8184
  {15,  1}, // #8185
  {16,  1}, // #8186
  {20,  1}, // #8187
  {21,  1}, // #8188
  {22,  1}, // #8189
  {26,  1}, // #8190
  {27,  1}, // #8191
  {28,  1}, // #8192
  {29,  1}, // #8193
  {31,  1}, // #8194
  {32,  1}, // #8195
  {33,  1}, // #8196
  {37,  1}, // #8197
  {39,  1}, // #8198
  { 4,  1}, // #8199
  {14,  8}, // #8200
  {20,  8}, // #8201
  {28,  8}, // #8202
  {31,  8}, // #8203
  {32,  8}, // #8204
  {36,  1}, // #8205
  {37,  1}, // #8206
  {38,  1}, // #8207
  {14,  3}, // #8208
  {20,  3}, // #8209
  {28,  3}, // #8210
  {31,  3}, // #8211
  {32,  3}, // #8212
  { 4,  1}, // #8213
  {14,  3}, // #8214
  {20,  3}, // #8215
  {28,  3}, // #8216
  {31,  3}, // #8217
  {32,  3}, // #8218
  {36,  1}, // #8219
  {37,  1}, // #8220
  {38,  1}, // #8221
  { 4,  1}, // #8222
  {14,  2}, // #8223
  {20,  2}, // #8224
  {28,  2}, // #8225
  {31,  2}, // #8226
  {32,  2}, // #8227
  {36,  1}, // #8228
  {37,  1}, // #8229
  {38,  1}, // #8230
  { 4,  1}, // #8231
  {11,  7}, // #8232
  {36,  8}, // #8233
  {37,  2}, // #8234
  {38,  1}, // #8235
  {39,  1}, // #8236
  { 4,  1}, // #8237
  {10,  2}, // #8238
  {11,  2}, // #8239
  {36,  3}, // #8240
  {37,  1}, // #8241
  {38,  1}, // #8242
  {14,  5}, // #8243
  {20,  4}, // #8244
  {26,  1}, // #8245
  {28,  4}, // #8246
  {31,  4}, // #8247
  {32,  4}, // #8248
  { 4,  1}, // #8249
  {14,  2}, // #8250
  {15,  2}, // #8251
  {16,  2}, // #8252
  {19,  2}, // #8253
  {20,  2}, // #8254
  {21,  2}, // #8255
  {23,  2}, // #8256
  {28,  2}, // #8257
  {29,  2}, // #8258
  {30,  2}, // #8259
  {31,  2}, // #8260
  {32,  2}, // #8261
  {34,  2}, // #8262
  {35,  2}, // #8263
  {36,  1}, // #8264
  {37,  1}, // #8265
  {38,  1} // #8266
}; // X86WriteProcResTable

// {Cycles, WriteResourceID}
extern const llvm::MCWriteLatencyEntry X86WriteLatencyTable[] = {
  { 0,  0}, // Invalid
  { 1,  0}, // #1 WriteALU_WriteZero_WriteVecALU_WriteJump_WriteMove_WriteADC_WriteFStoreX_WriteFStoreY_WriteFSign_WriteNop_WriteFLogic_WriteFBlend_WriteBLS_WriteBSWAP32_WriteBitTest_WriteBitTestSet_WriteBZHI_WriteCMOV_WriteStore_WriteVecALUX_WriteFLDC_WriteFShuffle_WriteVecLogicX_WriteShuffle_WriteLAHFSAHF_WriteFLD0_WriteFLD1_WriteLEA_WriteFence_WriteVecStoreX_WriteVecMoveFromGpr_WriteVecMoveX_WriteVecStoreNT_WriteVarShuffle_WriteVecShiftImm_WriteFMoveX_WriteStoreNT_WriteFStoreNTX_WriteShuffleX_WriteBlend_WriteVarShuffleX_WriteVecShiftImmX_WriteRotate_WriteRMW_WriteShift_WriteSETCC_WriteShuffleY_WriteFLogicY_WriteFBlendY_WriteVecALUY_WriteFMoveY_WriteFShuffleY_WriteVecStoreY_WriteVecMoveY_WriteVecStoreNTY_WriteFStoreNTY_WriteVecLogicY_WriteBlendY_WriteFVarShuffleY_WriteVecShiftImmY_WriteVarVecShift_WriteVarVecShiftY_WriteVarShuffleY_SKLWriteResGroup9_SKLWriteResGroup10_SKLWriteResGroup11_SKLWriteResGroup3_SKLWriteResGroup6_SKLWriteResGroup7_SKLWriteResGroup4_SKLWriteResGroup8_SKLWritePSUB_WriteCMPXCHGRMW_WriteJumpLd_WriteFLoadX_AtomWrite0_1_WriteADCLd_WriteALULd_WriteFLogicLd_WriteBSWAP64_WriteBitTestImmLd_WriteLoad_WriteCMOVLd_WriteVecExtractSt_WriteVecALUXLd_WriteFShuffleLd_WriteVecLoadX_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteVarShuffleLd_WriteVecLoadNT_WriteShuffleXLd_WriteVecLogicXLd_WriteRotateCL_WriteShiftLd_WriteShiftCL_WriteVecShiftImmXLd_WriteFTestLd_AtomWrite1_1_AtomWrite0_1_1_AtomWrite01_1_WriteFCMOV_WriteFComX_WriteVecTest_WriteSETCCStore_WriteFSqrt80_WriteSTMXCSR_WriteShuffle256_WriteVarShuffle256_WriteVPMOV256_WriteVecTestY_WriteFTestY_WriteXCHG_PdWriteTST_F_UCOM_FPPr_PdWriteXADD_PdWriteLEA16r_PdWriteADCSBB64ri32_PdWriteVMOVUPDYmrVMOVUPSYmr_PdWriteVMOVDQUYmr_PdWriteMOVDQArr_PdWriteSETGEmSETGmSETLEmSETLm_WriteVecMoveToGpr_WriteMMXMOVMSK_BWWriteResGroup10_BWWriteResGroup2_BWWriteResGroup5_BWWriteResGroup6_BWWriteResGroup3_BWWriteResGroup4_BWWriteResGroup7_BWWriteResGroup8_BWWriteResGroup9_WriteBEXTR_WriteLZCNT_WritePHAdd_WritePOPCNT_WriteFShuffle256_JWriteVecExtractF128_JWriteZeroIdiomYmm_WriteShuffleZ_WriteFLogicZ_WriteVecALUZ_WriteFMoveZ_WriteFShuffleZ_WriteVecMoveZ_WriteVecLogicZ_WriteFVarShuffleZ_WriteVecShiftImmZ_WriteVarVecShiftZ_WriteVarShuffleZ_SKXWriteResGroup9_SKXWriteResGroup10_SKXWriteResGroup11_SKXWriteResGroup3_SKXWriteResGroup6_SKXWriteResGroup7_SKXWriteResGroup4_SKXWriteResGroup8_SKXWritePSUB_WriteCvtSS2SD_WriteFVarShuffle256_SBWriteResGroup2_SBWriteResGroup1_SBWriteResGroup4_SBWriteResGroup5_SBWriteResGroupVzeroupper_WriteBitTestRegLd_HWWriteBTRSCmr_HWWrite2P1_HWWriteP01_HWWrite2P01_HWWrite2P0156_P23_HWWriteResGroup10_HWWriteINTO_HWWritePushA_HWWritePopA_HWWriteP1_HWWriteBOUND_HWWriteResGroup3_HWWriteResGroup6_HWWriteResGroup7_HWWrite3P01_HWWriteP0156_P23_HWWriteRETI_HWWriteRDPMC_HWWriteRDRAND_HWWriteFNSAVE_HWWriteFRSTOR_HWWriteResGroup2_HWWriteResGroup4_HWWriteResGroup5_HWWriteResGroup8_HWWriteResGroup9_HWWriteADC0_WriteSHDrri_WriteSHDrrcl_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_ICXWriteResGroup9_ICXWriteResGroup10_ICXWriteResGroup11_ICXWriteResGroup3_ICXWriteResGroup6_ICXWriteResGroup7_ICXWriteResGroup4_ICXWriteResGroup8_ICXWritePSUB_WriteFVarBlend_WriteFCmp64X_WriteFCmpX_WriteFMOVMSK_WriteVarBlend_WriteVecMOVMSK_WriteVecShiftX_WriteFVarBlendY_WriteFCmp64Y_WriteFCmpY_WriteVarBlendY_WriteVecShiftY_ZnWriteFPU3Lat1_ZnWriteFLDr_ZnWriteFPU0Lat1_ZnWriteFXCH_ZnWriteJCXZ_ZnWriteLD_F80m_ZnWriteLOOPE_ZnWriteCMPXCHG8B_ZnWriteRET_ZnWritePCMPGTQr_ZnWriteFPU01Y_ZnWriteFPU12m_ZnWriteCALLr_ZnXADD_ZnWriteFPU013_ZnWritePShift_ZnWriteSHA1MSG2r_ZnWriteSHA1NEXTEr_Zn2WriteFPU3Lat1_Zn2WriteFLDr_Zn2WriteFPU0Lat1_Zn2WriteFXCH_Zn2WriteJCXZ_Zn2WriteLD_F80m_Zn2WriteLOOPE_Zn2WriteCMPXCHG8B_Zn2WriteRET_Zn2WritePCMPGTQr_Zn2WriteFPU01Y_Zn2WriteFPU12m_Zn2WriteCALLr_Zn2XADD_Zn2WriteFPU013_Zn2WriteFPU013Y_Zn2WriteSHA1MSG2r_Zn2WriteSHA1NEXTEr_Zn2WriteXCHG_WriteVecMOVMSKY_Zn3WriteLFENCE_Zn3WriteMoveExtend_Zn3WriteVecALUXMMX_Zn3WriteRotateR1_Zn3WriteMOVMMX_Zn3WriteSFENCE_Zn3WriteMOVBEmr_Zn3WriteCvtPD2IMMX_Zn3WriteSHA1MSG2rr_SHA1NEXTErr_Zn3WriteALUSlow_Zn3WriteMaterialize32bitImm_Zn3WriteADC8mr_SBB8mr_Zn3WriteWriteXCHGUnrenameable_Zn3WritePOPCNT16rr_Zn3WriteLZCNT16rr_Zn3WriteMOVMMXSlow_Zn3WriteVecALUXSlow_Zn3WriteVecALUYSlow
  { 8,  0}, // #2 WriteCMPXCHGRMW_SKLWriteResGroup119_WriteAESIMC_WriteFVarBlendLd_WriteBSFLd_WriteBSRLd_WriteCRC32Ld_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtPS2ILd_WriteCvtPS2PDLd_WriteCvtSD2ILd_WriteCvtSD2SSLd_WriteCvtSS2SDLd_WriteCvtSS2ILd_WriteIMul16RegLd_WriteIMul16ImmLd_WriteIMul32RegLd_WriteIMul32ImmLd_WriteIMul64RegLd_WriteIMul64ImmLd_WriteIMul8Ld_WriteLZCNTLd_WritePHAddLd_WritePSADBWLd_WriteMULX32Ld_WriteMULX64Ld_WriteVarBlendLd_WritePOPCNTLd_WriteFRnd_WriteTZCNTLd_WriteShuffleYLd_WriteFLogicYLd_WriteFBlendYLd_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_WriteCvtPS2IYLd_WriteCvtPS2PDYLd_WriteCvtPS2PHYSt_WriteFRndY_WriteVecALUYLd_WriteFMaskedLoadY_WriteFShuffleYLd_WriteVecLogicYLd_WriteBlendYLd_WriteVarBlendYLd_WriteFVarShuffleYLd_WriteVecMaskedLoadY_WriteVecShiftImmYLd_WriteVarVecShiftYLd_WriteVarShuffleYLd_WriteVecShiftYLd_WriteFTestLd_SKLWriteResGroup116_SKLWriteResGroup117_SKLWriteResGroup107_SKLWriteResGroup108_SKLWriteResGroup110_SKLWriteResGroup112_WriteCvtI2PDLd_WriteFHAdd_WriteIMul16Ld_WritePHAddXLd_AtomWrite01_8_WriteIMul32Ld_WriteVarShuffleLd_WriteVecShiftLd_WriteVarShuffleXLd_WriteVecShiftXLd_WriteCvtI2PDY_WriteCvtPH2PSY_WriteFVarShuffleLd_WriteVarVecShiftLd_PdWriteVPERM2F128rm_PdWriteRCL3264ri_PdWriteVMPSADBW_BWWriteResGroup100_WriteFAdd64XLd_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteFComXLd_WriteFComLd_WriteFMul64XLd_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WriteFVarBlendYLd_BWWriteResGroup97_BWWriteResGroup91_BWWriteResGroup99_BWWriteResGroup154_BWWriteResGroup92_WriteAESDecEncLd_WriteCvtI2PSLd_WriteVecMoveFromGpr_WriteMPSADLd_WritePCmpIStrM_WriteVecTestLd_WriteFRndLd_WriteFAdd64YLd_WriteFAddYLd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteFRndYLd_SKXWriteResGroup130_WriteShuffleZLd_WriteFLogicZLd_WriteCvtPD2PSZLd_WriteCvtPD2IZLd_WriteCvtPS2IZLd_WriteCvtPS2PDZLd_WriteCvtPS2PHZSt_WriteFRndZ_WriteVecALUZLd_WriteFShuffleZLd_WriteVecLogicZLd_WriteVarBlendZLd_WriteFVarShuffleZLd_WriteVecShiftImmZLd_WriteVarVecShiftZLd_WriteVarShuffleZLd_WriteVecShiftZLd_SKXWriteResGroup127_SKXWriteResGroup128_SKXWriteResGroup118_SKXWriteResGroup119_SKXWriteResGroup121_SKXWriteResGroup123_SKXWriteResGroup131_SKXWriteResGroup132_SKXWriteResGroup133_SKXWriteResGroup134_WriteAESKeyGen_WriteVecALULd_WriteSHDmri_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteCvtPH2PSZLd_WriteFVarShuffle256Ld_WriteVPMOV256Ld_WriteFTestYLd_SBWriteResGroup86_SBWriteResGroup84_SBWriteResGroup77_SBWriteResGroup83_SBWriteResGroup85_SBWriteResGroup87_SBWriteCMOVA_CMOVBErm_HWWriteResGroup12_HWWriteResGroup48_HWWriteResGroup46_HWWriteResGroup47_HWWriteResGroup145_HWWriteResGroup11_2_HWWriteResGroup13_1_HWWriteResGroup17_2_HWWriteCMOVA_CMOVBErm_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteVecIMulXLd_WritePSADBWXLd_WriteVecIMulYLd_WriteFMulYLd_ICXWriteResGroup130_ICXWriteResGroup127_ICXWriteResGroup128_ICXWriteResGroup118_ICXWriteResGroup119_ICXWriteResGroup121_ICXWriteResGroup123_ICXWriteResGroup131_ICXWriteResGroup132_ICXWriteResGroup133_ICXWriteResGroup134_WriteFLoadX_WriteFLoadY_WriteFLogicLd_WriteFBlendLd_WriteLoad_WriteVecALUXLd_ZnWriteMul16Ld_ZnWriteMul32Ld_WriteFShuffleLd_WriteVecLoadX_ZnWriteFPU13_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteVecLoadNT_WriteFStoreNT_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WriteFCmp64YLd_WriteFCmpYLd_WriteVecLoadY_WriteVecLoadNTY_WriteVecShiftImmXLd_ZnWriteLEAVE_ZnWritePushA_ZnWritePCMPGTQm_ZnWriteBROADCAST_ZnWriteFPU01Op2_ZnWriteVPBROADCAST256Ld_ZnWritePCMPGTQYm_ZnWriteFPU0Lat1Ld_ZnWriteFPU013Ld_ZnWriteVPBROADCAST128Ld_ZnWriteFPU013m_ZnWriteSHA1MSG2Ld_ZnWriteSHA1NEXTELd_Zn2WriteMul64Ld_Zn2WriteFPU13_Zn2WriteLEAVE_Zn2WritePushA_Zn2WritePCMPGTQm_Zn2WriteBROADCAST_Zn2WriteFPU01Op2_Zn2WriteVPBROADCAST256Ld_Zn2WritePCMPGTQYm_Zn2WriteFPU0Lat1Ld_Zn2WriteFPU013Ld_Zn2WriteFPU013LdY_Zn2WriteVPBROADCAST128Ld_Zn2WriteFPU013m_Zn2WriteSHA1MSG2Ld_Zn2WriteSHA1NEXTELd_WriteFLD0_WriteVecTestYLd_Zn3WriteRotateLeftMI_Zn3WriteVINSERTF128rmr_Zn3WriteRotateLeftMCL_Zn3WriteVEXTRACTI128mr
  { 6,  0}, // #3 WriteJumpLd_WriteFLoadX_WriteADCLd_WriteALULd_WriteBLSLd_WriteBitTestImmLd_WriteBitTestRegLd_WriteRMW_WriteBZHILd_WriteCMOVLd_WriteFHAdd_WriteVecLoadX_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteVarShuffleLd_WriteVecShiftLd_WriteVecLoadNT_WriteCLMul_WriteStore_WriteShiftLd_WriteSHDrrcl_WriteCvtPS2PHSt_WriteFHAddY_SKLWriteResGroup82_SKLWriteResGroup68_SKLWriteResGroup76_SKLWriteResGroup78_SKLWriteResGroup83_SKLWriteResGroup84_SKLWriteResGroup42c_SKLWriteResGroup67_SKLWriteResGroup72_SKLWriteResGroup80_SKLWriteResGroup88_SKLWriteResGroup75_SKLWriteResGroup70_SKLWriteResGroup69_WriteFAdd64X_WriteFCmp64X_WriteFCmpX_WriteCvtI2PS_WriteCvtPS2I_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2SD_WriteIMul16Reg_WriteIMul16Imm_WriteIMul32_WriteFLD1_AtomWrite01_6_PdWriteALURMW_WriteBEXTRLd_WriteFComXLd_WriteCRC32Ld_WriteFComLd_WriteIMul64_WriteIMul64Reg_WriteIMul64Imm_WriteLZCNTLd_WriteVecTestLd_WriteTZCNTLd_WriteShuffle256Ld_WriteVarShuffle256Ld_WriteFMaskedStore64Y_WriteFMaskedLoadY_WriteFMaskedStore32Y_WriteVecMaskedLoadY_WriteVPMOV256Ld_WriteVecTestYLd_WriteFTestYLd_WriteFTestLd_PdWriteXLAT_PdWriteVBROADCASTYLd_PdWriteXADDm_PdWriteMMX_CVTPD2PIrrMMX_CVTPI2PDrr_PdWriteFCOMPm_PdWriteLXADD_PdWriteBMI1m_PdWriteCRC32r32r32_PdWriteMMX_CVTTPD2PIrr_WriteFLoadY_WriteFLogicLd_WriteFBlendLd_WriteVecALUXLd_WriteFShuffleLd_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WriteVarShuffleXLd_WriteFRnd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteCvtPS2PHY_WriteFRndY_WriteVecLoadY_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVecShiftImmXLd_BWWriteResGroup69_BWWriteResGroup66_BWWriteResGroup70_BWWriteResGroup58_BWWriteResGroup71_BWWriteResGroup36b_BWWriteResGroup65_BWWriteResGroup62_BWWriteResGroup68_BWWriteResGroup59_BWWriteResGroup64_BWWriteResGroup60_WriteIMul16Ld_WriteIMul16RegLd_WriteIMul32Ld_WriteIMul32RegLd_WriteIMul32ImmLd_WriteIMul8Ld_WritePHAddLd_WriteFLogicYLd_WriteFBlendYLd_WriteFShuffle256Ld_WriteCvtPD2PSY_WriteCvtPD2IY_WriteFShuffleYLd_JWriteVBROADCASTYLd_WriteCvtSD2I_WriteCvtSS2I_SKXWriteResGroup86_SKXWriteResGroup72_SKXWriteResGroup81_SKXWriteResGroup82_SKXWriteResGroup87_SKXWriteResGroup88_SKXWriteResGroup44c_SKXWriteResGroup71_SKXWriteResGroup76_SKXWriteResGroup84_SKXWriteResGroup92a_SKXWriteResGroup79_SKXWriteResGroup73_SKXWriteResGroup80_SBWriteResGroup48_SBWriteResGroup53_SBWriteResGroup81_SBWriteResGroup49_SBWriteResGroup51_SBWriteResGroup52_WriteCvtPS2PHZ_WriteFRndZ_HWWriteResGroup18_HWWriteResGroup108_HWWriteResGroup60b_HWWriteResGroup0_HWWriteResGroup14_HWWriteResGroup107_HWWriteResGroup11_HWWriteResGroup13_HWWriteResGroup16_HWWriteResGroup102_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WritePHAddX_WritePOPCNTLd_WriteFRndLd_WriteFAddYLd_WriteFCmp64YLd_WriteFCmpYLd_WriteFRndYLd_ICXWriteResGroup86_ICXWriteResGroup72_ICXWriteResGroup81_ICXWriteResGroup82_ICXWriteResGroup87_ICXWriteResGroup88_ICXWriteResGroup44c_ICXWriteResGroup71_ICXWriteResGroup76_ICXWriteResGroup84_ICXWriteResGroup79_ICXWriteResGroup73_ICXWriteResGroup80_ZnWriteALULat2Ld_ZnWriteBTRSCm_ZnWriteSHA1RNDS4r_Zn2WriteALULat2Ld_Zn2WriteBTRSCm_Zn2WriteSHA1RNDS4r_WritePCmpEStrI_WritePCmpEStrM_WritePCmpIStrM_WriteSHDmrcl_WriteSHDmri_Zn3WriteXCHG32rm_XCHG64rm_Zn3Writerm_SHA256MSG1rm_Zn3WriteSHA1RNDS4rri_Zn3WriteSHA1MSG1rm_Zn3WriteVPERMYri
  {100,  0}, // #4 WriteSystem_WriteMicrocoded_ZnWriteMicrocoded_WriteFShuffle256_WriteFVarShuffle256_Zn2WriteMicrocoded
  { 3,  0}, // #5 WriteSHDrri_WriteBSF_WriteBSR_WriteFCMOV_WriteCRC32_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtPS2I_WriteCvtPS2PD_WriteCvtSD2I_WriteCvtSD2SS_WriteCvtSS2SD_WriteCvtSS2I_WriteVecExtract_WriteIMul16Reg_WriteIMul32Reg_WriteIMul32Imm_WriteIMul64Reg_WriteIMul64Imm_WriteIMul8_WriteLZCNT_WritePHAdd_WritePSADBW_WriteMULX32_WriteMULX64_WritePHAddX_WritePOPCNT_WritePSADBWX_WriteVecTest_WriteRotateCL_WriteShiftCL_WriteTZCNT_WriteShuffle256_WriteFShuffle256_WriteVarShuffle256_WriteCvtPD2PSY_WriteCvtPD2IY_WriteCvtPS2IY_WriteCvtPS2PDY_WritePSADBWY_WriteFVarShuffle256_WritePHAddY_WriteVPMOV256_WriteVecTestY_SKLWriteResGroup40_SKLWriteResGroup32_SKLWriteResGroup46_SKLWriteResGroup45_SKLWriteResGroup43_SKLWriteResGroup41_SKLWriteResGroup29_SKLWriteResGroup30_SKLWriteResGroup39_SKLWriteResGroup35_SKLWriteResGroup36_SKLWritePCMPGTQ_SKLWriteSETA_SETBEm_WriteVecMoveToGpr_WriteMMXMOVMSK_WriteVecShiftLd_WriteFMOVMSK_WriteVecMOVMSK_WriteVecShiftXLd_AtomWrite01_3_WriteCMPXCHGRMW_WriteFLDC_WriteFLD0_WriteFLD1_WriteFStoreNTX_WriteVarShuffleX_WriteSHDrrcl_WriteFStoreNTY_WriteFVarShuffleY_WriteVarVecShift_PdWriteCMPXCHG8rm_PdWriteCMPXCHG8rr_PdWriteCMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm_PdWriteCMPXCHG8B_PdWriteCMPXCHG16B_PdWriteSHLD16rrCLSHLD32rrCLSHRD32rrCL_PdWriteEXTRQ_PdWriteINSERTQI_PdWriteSHLD32rri8SHRD16rri8_WriteFAdd64X_WriteFAddX_WriteFCmp64X_WriteFCmpX_WriteFComX_WriteFMul64X_WriteFMulX_WriteFAdd64Y_WriteFAddY_WriteFCmp64Y_WriteFCmpY_WriteFMul64Y_WriteFMulY_WriteVecMOVMSKY_WriteVarVecShiftY_BWWriteResGroup27_BWWriteResGroup34_BWWriteResGroup38_BWWriteResGroup37_BWWriteResGroup28_BWWriteResGroup33_BWWriteSETA_SETBEm_WriteAESDecEnc_WriteLoad_WriteCvtI2PD_WriteCvtI2PS_WriteVecExtractSt_WriteLDMXCSR_WriteMPSAD_WriteFRnd_WriteFVarBlendY_WriteCvtI2PDY_WriteCvtI2PSY_WriteCvtPH2PSY_WriteCvtPS2PH_WriteFRndY_WriteFTest_JSlowLEA16r_JWriteCMPXCHG8rr_WriteCvtPD2PSZ_WriteCvtPD2IZ_WriteCvtPS2IZ_WriteCvtPS2PDZ_WritePSADBWZ_SKXWriteResGroup42_SKXWriteResGroup34_SKXWriteResGroup48_SKXWriteResGroup47_SKXWriteResGroup45_SKXWriteResGroup43_SKXWriteResGroup31_SKXWriteResGroup32_SKXWriteResGroup41_SKXWriteResGroup37_SKXWriteResGroup38_SKXWriteResGroup30_SKXWritePCMPGTQ_SKXWriteSETA_SETBEm_WriteVecALU_WriteFAdd64Z_WriteFAddZ_WriteFCmpZ_WriteCvtI2PSZ_WriteCvtPH2PSZ_WriteCvtPS2PHY_WriteCvtPS2PHZ_WriteFRndZ_WriteFCmp64Z_SBWriteResGroup21_SBWriteResGroup22_SBWriteResGroup24_SBWriteResGroup26_2_SBWriteCMOVA_CMOVBErr_SBWriteSETA_SETBEm_WriteVarVecShiftZ_HWWriteResGroup50_HWWriteResGroup58_HWWriteResGroup45_HWWriteResGroup44_HWWriteResGroup51_HWWriteResGroup57_HWWriteCMOVA_CMOVBErr_HWWriteSETA_SETBEm_WriteFLoadX_WriteFLoadY_WriteVecLoadX_WriteVecLoadNT_WriteVecLoadY_WriteFMaskedLoadY_WriteVecLoadNTY_WriteVecMaskedLoadY_ICXWriteResGroup42_ICXWriteResGroup34_ICXWriteResGroup48_ICXWriteResGroup47_ICXWriteResGroup45_ICXWriteResGroup43_ICXWriteResGroup31_ICXWriteResGroup32_ICXWriteResGroup41_ICXWriteResGroup37_ICXWriteResGroup38_ICXWriteResGroup30_ICXWritePCMPGTQ_ICXWriteSETA_SETBEm_ZnWriteCVTPS2PDr_ZnWriteMul16_ZnWriteMul32_WriteVecMoveFromGpr_ZnWriteVCVTPS2PDY_Zn2WriteCVTPD2PSr_Zn2WriteCVTPS2PDr_Zn2WriteCVTSS2SDr_Zn2WriteMul16_Zn2WriteMul32_Zn2WriteCVTPD2PSYr_Zn2WriteVCVTPS2PDY_WriteFTestY_Zn2WriteCVTPD2DQr_Zn2WriteCVTDQ2PDr_Zn2WriteCVSTSI2SDr_Zn2WritePShift_Zn2WritePShiftY_Zn2WriteEXTRQ_WriteCvtI2SD_WriteCvtI2SS_WriteVecIMul_WritePHMINPOS_WriteVecIMulX_WritePMULLD_WriteFRcpX_WriteFRsqrtX_WriteVecIMulY_WritePMULLDY_WriteFRcpY_WriteFRsqrtY_Zn3WriteCvtI2PSMMX_Zn3WriteCMPXCHG8rr_Zn3WriteCMPXCHG8B_Zn3WriteRotateRightRI_Zn3WriteRotateRightRCL_Zn3WritePDEP_PEXT_Zn3WriteVPERM2I128rr_VPERM2F128rr_Zn3WriteEXTRQI_INSERTQI_Zn3WriteSHA256MSG2rr_Zn3WriteEXTRQ_INSERTQ
  { 7,  0}, // #6 WriteFLoadY_WriteRMW_WriteFLogicLd_WriteBEXTRLd_WriteFBlendLd_WriteFComXLd_WriteFComLd_WriteVecALUXLd_WriteFShuffleLd_WriteLDMXCSR_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WriteVarShuffleXLd_WriteVecShiftXLd_WriteCvtPH2PSY_WriteCvtPS2PHY_WriteVecLoadY_WriteFMaskedLoad_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVecMaskedLoad_WriteVecShiftImmXLd_WriteVarVecShiftLd_SKLWriteResGroup95_SKLWriteResGroup94_SKLWriteResGroup91_SKLWriteResGroup85_SKLWriteResGroup96_SKLWriteResGroup103_SKLWriteResGroup98_SKLWriteResGroup102_SKLWriteResGroup100_SKLWriteResGroup101_SKLWriteResGroup92_SKLWriteResGroup89_SKLWriteResGroup86_SKLWriteCMOVA_CMOVBErm_WriteFAdd64XLd_WriteFCmp64XLd_WriteFCmpXLd_WriteCvtI2PD_WriteCvtI2PSLd_WriteCvtPD2I_WriteCvtPS2ILd_WriteCvtPS2PD_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteIMul16_WriteIMul16RegLd_WriteIMul16ImmLd_WriteIMul32Ld_WriteIMul8Ld_WritePHAddX_AtomWrite0_1_7_AtomWrite0_1_7_4_AtomWrite01_7_WriteFVarBlendLd_WriteBSFLd_PdWriteBTSIm_PdWriteBTSRm_WriteFCmp64Ld_WriteFCmpLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVarBlendLd_WritePCmpIStrM_WritePHAddXLd_WriteShuffleYLd_WriteFLogicYLd_WriteFVarBlendYLd_WriteFBlendYLd_WriteFShuffle256Ld_WriteFCmp64YLd_WriteFCmpYLd_WriteFShuffleYLd_PdWriteRCR32riRCR64ri_PdWriteVBROADCASTF128_PdWriteRCL3264rCL_PdWriteVEXTRACTF128mr_PdWriteRCR3264rCL_WriteAESDecEnc_WriteMPSAD_WriteVecTestLd_WriteCvtPS2PHYSt_WriteVecALUYLd_WriteMPSADY_WriteVecLogicYLd_WriteBlendYLd_WriteFVarShuffleYLd_WriteVecShiftImmYLd_WriteVarShuffleYLd_WriteVecShiftYLd_WriteFTestYLd_BWWriteResGroup80_BWWriteResGroup82_BWWriteResGroup90_BWWriteResGroup84_BWWriteResGroup89_BWWriteResGroup87_BWWriteResGroup88_BWWriteResGroup73_BWWriteResGroup77_BWWriteResGroup79_BWWriteResGroup74_BWWriteCMOVA_CMOVBErm_WriteAESIMCLd_WriteAESKeyGenLd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSD2SS_WriteCvtSS2I_WriteVecIMulLd_WritePSADBWLd_WriteVarShuffleLd_WriteFMulXLd_WriteFMulLd_WriteCLMulLd_WritePCmpIStrI_WritePHMINPOSLd_WriteVecIMulXLd_WritePSADBWXLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_WriteFRsqrtLd_WriteCvtPS2PDYLd_WriteFMulYLd_WriteFRcpYLd_WriteFRsqrtYLd_WriteCvtPH2PSZ_WriteCvtPS2PHZ_SKXWriteResGroup100_SKXWriteResGroup99_SKXWriteResGroup95_SKXWriteResGroup89_SKXWriteResGroup101_SKXWriteResGroup111_SKXWriteResGroup104_SKXWriteResGroup109_SKXWriteResGroup107_SKXWriteResGroup108_SKXWriteResGroup96_SKXWriteResGroup93_SKXWriteResGroup90_SKXWriteResGroup92_SKXWriteResGroup93z_SKXWriteResGroup97_SKXWriteResGroup103_SKXWriteResGroup106_SKXWriteResGroup110_SKXWriteResGroup112_SKXWriteResGroup113_SKXWriteResGroup114_SKXWriteCMOVA_CMOVBErm_WriteADCLd_WriteCMOVLd_WriteVecInsertLd_WriteCvtPS2PDZLd_WriteFRcpZ_WriteFRsqrtZ_WriteFTestLd_SBWriteResGroup69_SBWriteResGroup25_1_SBWriteResGroup63_SBWriteResGroup68_SBWriteResGroup54_SBWriteResGroup58_SBWriteResGroup59_SBWriteResGroup62_SBWriteResGroup64_SBWriteResGroup66_SBWriteResGroup67_WriteCvtPH2PSYLd_WriteCvtPH2PSZLd_WriteCvtPS2PHZSt_HWWriteResGroup25_HWWriteResGroup37_HWWriteResGroup26_HWWriteResGroup0_1_HWWriteResGroup39_HWWriteXLAT_HWWriteResGroup114_HWWriteResGroup41_HWWriteResGroup17_HWWriteResGroup11_1_HWWriteResGroup36_2_WriteCvtSD2SSLd_WriteIMul64_WriteFMul64X_WriteFAdd64YLd_WriteFMul64Y_SLMWriteResGroup1rm_ICXWriteResGroup100_ICXWriteResGroup99_ICXWriteResGroup95_ICXWriteResGroup89_ICXWriteResGroup101_ICXWriteResGroup111_ICXWriteResGroup104_ICXWriteResGroup109_ICXWriteResGroup107_ICXWriteResGroup108_ICXWriteResGroup96_ICXWriteResGroup93_ICXWriteResGroup90_ICXWriteResGroup92_ICXWriteResGroup93z_ICXWriteResGroup97_ICXWriteResGroup103_ICXWriteResGroup106_ICXWriteResGroup110_ICXWriteResGroup112_ICXWriteResGroup113_ICXWriteResGroup114_ICXWriteCMOVA_CMOVBErm_WriteFHAdd_WriteFHAddY_Zn2WriteMul16Ld_Zn2WriteMul32Ld_WriteMULX32Ld_WriteMULX64Ld_WriteFCMOV_WriteCRC32Ld_WriteIMul16Ld_WriteIMul32RegLd_WriteIMul32ImmLd_WriteIMul64Ld_WriteIMul64RegLd_WriteIMul64ImmLd_WriteFVarShuffle256_Zn3WriteRotateRightMCL_Zn3WriteCMPXCHG8rm_LCMPXCHG8_Zn3WriteVPERM2F128rm_Zn3WriteSHA256MSG2rm_Zn3WriteXCHG8rm_XCHG16rm_Zn3WriteRotateRightMI_Zn3WriteVPERMPSYrr
  {10,  0}, // #7 WriteFAdd64XLd_WriteFAddXLd_WriteAESDecEncLd_WriteFCmp64XLd_WriteFCmpXLd_WriteEMMS_WriteVecIMulLd_WriteMPSADLd_WriteFMul64XLd_WriteFMulXLd_WritePCmpIStrI_WritePCmpIStrM_WritePHMINPOSLd_WritePMULLD_WriteFRcpXLd_WriteFRsqrtXLd_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteCvtPH2PSYLd_WritePSADBWYLd_WriteFMAXLd_WriteFVarShuffle256Ld_WritePHAddYLd_WriteVPMOV256Ld_WritePMULLDY_WriteVecTestYLd_SKLWriteResGroup133_SKLWriteResGroup143_SKLWriteResGroup134_SKLWriteResGroup138_SKLWriteResGroup139_SKLWriteResGroup140_WriteFComXLd_WriteCvtSD2SS_AtomWrite01_10_AtomWrite0_1_10_WriteFAdd64Ld_WriteFAddLd_WriteAESIMCLd_WriteAESKeyGenLd_WriteIMul64Ld_WriteIMul64RegLd_WriteIMul64ImmLd_WritePHAddLd_WriteMMXMOVMSK_WriteFMul64Ld_WriteFMulLd_WritePCmpEStrM_WritePMULLDLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFAdd64YLd_WriteFAddYLd_WriteFMAYLd_WriteFMul64YLd_WriteFMulYLd_WriteFRcpYLd_WriteFRsqrtYLd_PdWriteCRC32r64r64_PdWriteRCL16rCL_PdWriteRCR16ri_PdWriteVFRCZP_PdWriteVFRCZS_PdWriteVFRCZY_WriteFHAddLd_WritePSADBWLd_WriteCLMulLd_WriteVecIMulXLd_WritePSADBWXLd_BWWriteResGroup120_BWWriteResGroup115_BWWriteResGroup117_WriteCvtPH2PSZLd_WritePSADBWZLd_WritePMULLDZ_SKXWriteResGroup148_SKXWriteResGroup157_SKXWriteResGroup149_SKXWriteResGroup153_SKXWriteResGroup154_SKXWriteResGroup136_2_SKXWriteResGroup151_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtSD2ILd_WriteCvtSD2SSLd_WriteCvtI2SSLd_WriteCvtSS2ILd_WritePCmpEStrILd_WriteSHDmrcl_WriteFMAZLd_WriteFAdd64ZLd_WriteFAddZLd_WriteFCmp64YLd_WriteFCmpYLd_WriteFCmpZLd_WriteCvtI2PDYLd_WriteCvtI2PDZLd_WriteCvtI2PSYLd_WriteCvtI2PSZLd_WriteCvtPS2IYLd_WriteCvtPS2IZLd_WriteFRndYLd_WriteFRndZLd_WriteFCmp64ZLd_SBWriteResGroup101_WriteSHDmri_WriteVarVecShiftYLd_WriteVarVecShiftZLd_HWWriteResGroup52_1_HWWriteResGroup97_HWWriteResGroup77_HWWriteResGroup78_WriteBSF_WriteBSR_ICXWriteResGroup148_ICXWriteResGroup157_ICXWriteResGroup149_ICXWriteResGroup153_ICXWriteResGroup154_ICXWriteResGroup136_2_ICXWriteResGroup151_WriteCRC32Ld_ZnWriteCVTPS2PDLd_WriteFComLd_WritePHAddXLd_WriteVarVecShiftLd_Zn2WriteCVTPD2PSLd_Zn2WriteCVTPS2PDLd_Zn2WriteCVTSS2SDLd_WriteVecTestLd_WriteFRndLd_Zn2WriteCVTPD2PSYLd_Zn2WriteVDIVPSYr_WriteFVarShuffleYLd_WriteFVarShuffleLd_WriteFTestYLd_WriteFTestLd_Zn2WriteCVTPD2DQLd_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtPS2PDLd_WriteCvtI2SDLd_WriteCvtSS2SDLd_WriteDiv8_WriteIDiv8_WriteCvtPH2PSLd_WriteVecIMulYLd_WritePMULLDYLd_Zn3WriteVZEROALL_Zn3WriteVPERMPDYmi
  { 4,  0}, // #8 WriteFAdd64X_WriteFAddX_WriteAESDecEnc_WriteFCmp64X_WriteFCmpX_WriteCvtI2PD_WriteCvtI2PS_WriteCvtI2SD_WriteCvtI2SS_WriteIMul16_WriteIMul16Imm_WriteIMul32_WriteIMul64_WriteMPSAD_WriteFMul64X_WriteFMulX_WritePHMINPOS_WriteFRcpX_WriteFRsqrtX_WriteFAdd64Y_WriteFAddY_WriteFCmp64Y_WriteFCmpY_WriteCvtI2PDY_WriteCvtI2PSY_WriteFMAX_WriteFMAY_WriteMPSADY_WriteFMul64Y_WriteFMulY_WriteVecShiftY_WriteFRcpY_WriteFRsqrtY_SKLWriteResGroup53_SKLWriteResGroup55_SKLWriteResGroup54_SKLWriteResGroup48_SKLWriteResGroup57_SKLWriteResGroup47_WritePHAddLd_WriteVecIMulLd_WritePSADBWLd_WriteFMulLd_WriteVarShuffleX_WriteFRcpLd_WriteFRsqrtLd_WriteSHDmrcl_WriteSHDmri_AtomWrite01_4_WriteBSR_WriteCvtPS2I_WriteCvtSD2SS_WriteCvtSS2SD_WriteIMul16Reg_WriteIMul32Reg_WriteIMul32Imm_WriteIMul8_WriteVecIMulX_WritePOPCNT_WritePSADBWX_WriteFRnd_WriteCvtPS2IY_WriteCvtPS2PHYSt_WriteCvtPS2PHSt_WriteFRndY_PdWriteMMX_CVTPI2PSrr_PdWriteMOVQ2DQrr_PdWriteVPERM2F128rr_PdWriteVPMACS_WriteVecTestY_BWWriteResGroup42_BWWriteResGroup39_BWWriteResGroup44_BWWriteResGroup45_BWWriteResGroup41_BWWriteResGroup43_BWWriteResGroup40_WriteJumpLd_WriteADCLd_WriteALULd_WriteBEXTRLd_WriteBSF_WriteBitTestImmLd_WriteBitTestRegLd_WriteCMOVLd_WriteFHAdd_WriteLZCNTLd_WriteVecMoveToGpr_WriteVecInsertLd_WritePMULLD_WriteStore_WritePOPCNTLd_WriteShiftLd_WriteSHDrrcl_WriteFHAddY_WriteFVarShuffleY_WriteFTestY_WriteFAdd64Z_WriteFAddZ_WriteFCmpZ_WriteCvtI2PDZ_WriteCvtI2PSZ_WriteFMAZ_WriteFCmp64Z_WriteFMul64Z_WriteFMulZ_WriteVecShiftZ_WriteFRcpZ_SKXWriteResGroup54_SKXWriteResGroup55_SKXWriteResGroup50_SKXWriteResGroup57_SKXWriteResGroup49_SKXWriteResGroup33_SKXWriteResGroup50z_SKXWriteResGroup51_WriteCvtPD2I_WriteCvtPD2PS_WritePCmpEStrI_WriteCvtPD2PSY_WriteCvtPD2PSZ_WriteCvtPD2IY_WriteCvtPD2IZ_WriteCvtPS2PHZSt_SBWriteResGroup29_2_SBWriteResGroup24b_HWWriteResGroup73_HWWriteResGroup70_HWWriteMOVS_HWWriteResGroup62_HWWriteResGroup81_HWWriteResGroup72_HWWriteResGroup61_HWWriteCMPS_HWWriteResGroup71_HWWriteResGroup83_WriteCMPXCHGRMW_WriteFLogicLd_WriteFBlendLd_WriteFVarBlend_WriteRMW_WriteVecExtractSt_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteMMXMOVMSK_WriteVarShuffleLd_WriteFMOVMSK_WriteShuffleXLd_WriteVecLogicXLd_WriteVarBlend_WriteBlendLd_WriteVecMOVMSK_WriteVecTestLd_WriteShuffleYLd_WriteFLogicYLd_WriteVecALUYLd_WriteFShuffleYLd_WriteVecLogicYLd_WriteBlendYLd_WriteFVarShuffleYLd_WriteFVarShuffleLd_WriteVecMOVMSKY_WriteVecShiftImmXLd_WriteVecShiftImmYLd_WriteVarVecShiftLd_WriteVecTestYLd_WriteFTestYLd_WriteFTestLd_SLMWriteResGroup1rr_ICXWriteResGroup54_ICXWriteResGroup55_ICXWriteResGroup50_ICXWriteResGroup57_ICXWriteResGroup49_ICXWriteResGroup33_ICXWriteResGroup50z_ICXWriteResGroup51_WriteAESIMC_WriteAESKeyGen_ZnWriteCVTPD2PSr_ZnWriteCVTSS2SDr_ZnWriteMul64_WriteVecIMulY_WriteFMaskedStore64_WriteFMaskedStore32_WriteVecMaskedStore32_WriteVecMaskedStore64_ZnWriteCVTPS2PIr_ZnWritePUSH_ZnWriteINSERTQ_ZnWriteSHA256RNDS2r_Zn2WriteMul16Imm_Zn2WriteMul64_WriteVPMOV256_WritePMULLDY_Zn2WriteCVTPS2PIr_Zn2WriteCVSTSI2SIr_Zn2WritePUSH_Zn2WriteINSERTQ_Zn2WriteSHA256RNDS2r_WriteFComX_WriteCLMul_WriteCvtPS2PDY_WriteCvtPH2PSY_Zn3WriteCMPXCHG16B_LCMPXCHG16B_Zn3WriteRotateLeftRI_Zn3WriteRotateLeftRCL_Zn3WriteVEXTRACTF128rr_VEXTRACTI128rr_Zn3WriteSHA256RNDS2rr_Zn3WriteMOVBE16rm
  { 9,  0}, // #9 WriteFAdd64Ld_WriteFAddLd_WriteFCmp64Ld_WriteFCmpLd_WriteCvtI2PDLd_WriteCvtI2PSLd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteDPPD_WriteIMul16Ld_WriteIMul32Ld_WriteIMul64Ld_WriteFMul64Ld_WriteFMulLd_WritePHAddXLd_WritePSADBWXLd_WriteVecTestLd_WriteFRcpLd_WriteFRsqrtLd_WriteSHDmri_WriteFMALd_WriteFVarBlendYLd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPH2PSLd_WriteFTestYLd_SKLWriteResGroup120_SKLWriteResGroup123_SKLWriteResGroup121_SKLWriteResGroup131_SKLWriteResGroup128_WriteBitTestRegLd_WriteFCMOV_WriteFComX_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteFHAddLd_WriteFMul64X_WriteFRcpX_WriteFRsqrtX_AtomWrite0_1_9_AtomWrite01_9_WriteAESDecEnc_WriteCvtPS2ILd_WriteCvtSD2SSLd_WriteCvtSS2SDLd_WriteFDiv64X_WriteFDivX_WriteIMul16ImmLd_WriteVecIMulLd_WritePSADBWLd_WriteMPSAD_WritePHMINPOSLd_WriteVecIMulXLd_WriteFRndLd_WriteFSqrt64X_WriteFSqrtX_WriteCvtPS2IYLd_WriteFDiv64Y_WriteFDivY_WriteFRndYLd_WriteFSqrt64Y_WriteFSqrtY_PdWriteX87Div_PdWriteRCR16rCL_WriteFAdd64YLd_WriteFAddYLd_WriteShuffle256Ld_WriteFShuffle256Ld_WriteFCmp64YLd_WriteFCmpYLd_WriteVarShuffle256Ld_WriteFMul64YLd_WriteFMulYLd_WriteFVarShuffle256Ld_WritePHAddYLd_WriteVPMOV256Ld_WriteVarVecShiftYLd_BWWriteResGroup101_BWWriteResGroup105_BWWriteResGroup112_BWWriteResGroup106_BWWriteResGroup107_BWWriteResGroup108_BWWriteResGroup113_WriteIMul64RegLd_WriteIMul64ImmLd_WriteFMul64XLd_WritePMULLDLd_WriteSHDmrcl_WriteFHAddYLd_WriteFVarShuffleYLd_WriteVecTestYLd_WriteFVarBlendZLd_WriteCvtI2PDZLd_WriteCvtI2PSZLd_WriteFRsqrtZ_SKXWriteResGroup135_SKXWriteResGroup137_SKXWriteResGroup136_SKXWriteResGroup146_SKXWriteResGroup143_SBWriteResGroup98_WriteFAdd64XLd_WriteFAddXLd_SBWriteResGroup100_WriteRMW_WriteFCmp64XLd_WriteFCmpXLd_WritePOPCNTLd_WriteFMaskedLoadY_WriteVarBlendYLd_WriteVarBlendZLd_WriteVecMaskedLoadY_SBWriteResGroup97_2_SBWriteResGroup93_SBWriteResGroup95_SBWriteResGroup99_SBWriteResGroupVzeroall_WriteCMPXCHGRMW_HWWriteResGroup69_WriteVarVecShiftLd_HWWriteResGroup66_HWWriteResGroup68_HWWriteResGroup76_HWWriteResGroup52_HWWriteResGroup53_1_HWWriteResGroup78_1_HWWriteResGroup80_HWWriteResGroup87_WritePHAddLd_ICXWriteResGroup135_ICXWriteResGroup137_ICXWriteResGroup136_ICXWriteResGroup146_ICXWriteResGroup143_ZnWriteMul64Ld_WriteStore_WriteFTestLd_ZnWriteFPU02_ZnWriteVINSERT128Ld_ZnWriteFPU01Op2Y_ZnWriteFPU013LdY_ZnWriteSHA1MSG1Ld_Zn2WriteFPU02_Zn2WriteVINSERT128Ld_Zn2WriteFPU01Op2Y_Zn2WriteSHA1MSG1Ld_WritePCmpIStrILd_Zn3WriteVPERMYm
  {14,  0}, // #10 WriteAESIMCLd_SKLWriteResGroup166_WriteFRndLd_SKLWriteResGroup166_1_SKLWriteResGroup170_SKLWriteResGroup169_WriteIMul64ImmLd_AtomWrite01_14_WriteAESDecEncLd_WriteDiv32_WriteDiv64_WriteFDiv64XLd_WriteFDivXLd_WriteFDivLd_WriteFDiv64Ld_WriteIDiv32_WriteIDiv64_WriteMPSADLd_WritePCmpEStrI_WriteFSqrt64XLd_WriteFSqrtXLd_WriteFSqrt64Ld_WriteFSqrtLd_WriteFDiv64YLd_WriteFDivYLd_WriteFSqrt64YLd_WriteFSqrtYLd_BWWriteResGroup139_1_WriteDPPDLd_WriteDPPS_WriteDPPSY_BWWriteResGroup146_BWWriteResGroup145_BWWriteResGroup141_BWWriteResGroup144_WritePCmpEStrM_SKXWriteResGroup184_SKXWriteResGroup184_1_SKXWriteResGroup190_SKXWriteResGroup187_SKXWriteResGroup188_SKXWriteResGroup189_WriteAESKeyGenLd_WriteCLMul_WriteMPSADYLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_WriteFRsqrtZLd_HWWriteResGroup142_HWWriteResGroup184_WritePMULLDLd_ICXWriteResGroup184_ICXWriteResGroup184_1_ICXWriteResGroup190_ICXWriteResGroup187_ICXWriteResGroup188_ICXWriteResGroup189_WriteFHAddLd_WriteFHAddYLd_WriteDiv8Ld_WriteIDiv8Ld_WriteFVarShuffle256Ld
  {25,  0}, // #11 WriteAESKeyGenLd_WriteDiv8_WriteIDiv8_WritePCmpEStrMLd_WriteFSqrt64YLd_SKLWriteResGroup202_AtomWrite01_25_WriteDPPS_WriteIDiv16_WriteIDiv32_WriteIDiv64_WriteDiv32_WriteFDivZLd_SKXWriteResGroup233_SKXWriteGatherEVEX16_WriteDiv16_WriteDiv64_WriteFDiv64Ld_ICXWriteResGroup233_ICXWriteGatherEVEX16
  {20,  0}, // #12 WriteAESKeyGen_SKLWriteResGroup190_WriteDPPSYLd_SKLWriteResGroup193_SKLWriteResGroup192_SKLWriteResGroup189_SKLWriteResGroupVEX4_AtomWrite01_20_WriteDPPDLd_BWWriteResGroup167_BWWriteResGroup165_WriteDiv16Ld_WriteIDiv16Ld_SKXWriteResGroup216_WriteFSqrtZ_SKXWriteResGroup220_SKXWriteResGroup219_SKXWriteResGroup215_SKXWriteResGroupVEX4_WriteFDivXLd_WriteFDivLd_WriteCLMulLd_WriteFSqrtXLd_WriteFSqrtLd_WriteAESIMCLd_WriteFDiv64X_WriteDPPSLd_HWWriteResGroup156_HWWriteResGroup154_WritePCmpEStrMLd_WritePCmpIStrILd_ICXWriteResGroup216_ICXWriteResGroup220_ICXWriteResGroup219_ICXWriteResGroup215_ICXWriteResGroupVEX4_WriteFSqrt64X_WriteFSqrt80_Zn2WriteVDIVPDYLd_WriteFSqrt64Y_WriteFDiv64XLd_WriteFDiv64Ld_WriteFDiv64YLd
  { 2,  0}, // #13 WriteBEXTR_WriteFVarBlend_WriteBSWAP64_WriteFComX_WriteVecExtractSt_WriteVecMoveToGpr_WriteVecInsert_WriteMMXMOVMSK_WriteFMOVMSK_WriteVarBlend_WriteVecMOVMSK_WriteVecShiftX_WriteSETCCStore_WriteSTMXCSR_WriteFVarBlendY_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVarBlendY_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_WriteVecMOVMSKY_WriteFTestY_WriteXCHG_SKLWriteResGroup17_SKLWriteResGroup23_SKLWriteResGroup25_SKLWriteResGroup14_SKLWriteResGroup42_SKLWriteResGroup28_SKLWriteResGroup20_SKLWriteResGroup13_SKLWriteResGroup21_SKLWriteResGroup27_SKLWriteResGroup100_1_SKLWriteCMOVA_CMOVBErr_SKLWriteSETA_SETBEr_WriteSHDrri_AtomWrite01_2_WriteLAHFSAHF_WriteStore_WriteSHDrrcl_WriteVecALU_WriteFLogic_WriteFBlend_WriteBLS_WriteBitTestSet_WriteFCmp64X_WriteFCmpX_WriteCRC32_WriteVecALUX_WriteEMMS_WriteFShuffle_WriteVecLogicX_WriteShuffle_WriteLZCNT_WriteVecStore_WriteVecStoreNT_WriteVecShiftImm_WriteFStore_WriteShuffleX_WriteBlend_WritePHAddX_WriteVecShiftImmX_WriteTZCNT_WriteShuffleY_WriteFLogicY_WriteFBlendY_WriteFShuffle256_WriteFCmp64Y_WriteFCmpY_WriteFMoveY_WriteFShuffleY_WriteVecMoveY_WriteVecStoreNTY_PdWriteLAHF_PdWriteVEXTRACTF128rr_PdWriteMOVHPm_PdWriteBMI1_PdWriteSAHF_PdWriteBEXTRI_PdWriteBEXTRIm_PdWriteVPPERM_PdWrite3OpsLEA_WriteVecTest_WriteCvtPH2PSY_BWWriteResGroup14_BWWriteResGroup20_BWWriteResGroup22_BWWriteResGroup12_BWWriteResGroup17_BWWriteResGroup35_BWWriteResGroup25_BWWriteResGroup16_BWWriteResGroup18_BWWriteResGroup24_BWWriteResGroup15_BWWriteResGroup87_1_BWWriteCMOVA_CMOVBErr_BWWriteSETA_SETBEr_WriteFSign_WriteAESIMC_WriteAESKeyGen_WriteCvtPS2PD_WriteVecIMul_WritePSADBW_WriteVarShuffle_WriteFMulX_WriteCLMul_WritePHMINPOS_WriteVecIMulX_WritePSADBWX_WriteVarShuffleX_WriteFRcpX_WriteRMW_WriteFRsqrtX_WriteCvtPS2PDY_WriteFMulY_WriteFRcpY_WriteFRsqrtY_JWriteXCHG8rr_XADDrr_JWriteINSERTQ_JWrite3OpsLEA_WriteFVarBlendZ_WriteVarBlendZ_SKXWriteResGroup17_SKXWriteResGroup23_SKXWriteResGroup25_SKXWriteResGroup14_SKXWriteResGroup44_SKXWriteResGroup28_SKXWriteResGroup20_SKXWriteResGroup13_SKXWriteResGroup21_SKXWriteResGroup27_SKXWriteResGroup107_1_SKXWriteResGroup29_SKXWriteCMOVA_CMOVBErr_SKXWriteSETA_SETBEr_WriteADC_WriteRotate_WriteCvtPS2PDZ_WriteVecTestY_SBWriteResGroup18_SBWriteResGroup11_SBWriteResGroup12_SBWriteResGroup15_SBWriteResGroup23_SBWriteSETA_SETBEr_WriteCvtPH2PSZ_HWWriteResGroup30_HWWriteResGroup35_HWWriteResGroup21_HWWriteResGroup28_HWWriteResGroup33_HWWriteResGroup59_HWWriteResGroup24_HWWriteResGroup32_HWWriteResGroup19_HWWriteResGroup23_HWWriteResGroup23_16_HWWriteResGroup31_HWWriteResGroup46_1_HWWriteSETA_SETBEr_WriteVecShiftY_ICXWriteResGroup17_ICXWriteResGroup23_ICXWriteResGroup25_ICXWriteResGroup14_ICXWriteResGroup44_ICXWriteResGroup28_ICXWriteResGroup20_ICXWriteResGroup13_ICXWriteResGroup21_ICXWriteResGroup27_ICXWriteResGroup107_1_ICXWriteResGroup29_ICXWriteCMOVA_CMOVBErr_ICXWriteSETA_SETBEr_ZnWriteALULat2_WriteShuffle256_WriteVarShuffle256_ZnWriteEXTRACTPSr_ZnWriteFPU013Y_ZnWritePShiftY_ZnWriteVINSERT128r_ZnWriteEXTRQ_ZnWriteSHA1MSG1r_Zn2WriteALULat2_Zn2WriteEXTRACTPSr_Zn2WriteVINSERT128r_Zn2WriteSHA1MSG1r_Zn2WriteBTRSC_WriteCvtSD2I_WriteCvtSS2I_WritePCmpIStrI_WritePHAddY_Zn3WriteCvtI2PDMMX_Zn3WriteSHA256MSG1rr_Zn3SlowLEA16r_Zn3WriteTZCNT16rr_Zn3WriteWriteFStoreMMX_Zn3WriteSHA1MSG1rr_Zn3Write3OpsLEA
  { 5,  0}, // #14 WriteLoad_WriteCMPXCHG_WriteVecLoad_WriteVecIMul_WriteFLoad_WriteVecIMulX_WriteCvtPH2PS_WriteCvtPS2PH_WriteVecIMulY_SKLWriteResGroup60_SKLWriteResGroup58_SKLWriteResGroup42b_SKLWriteResGroup65_SKLWriteResGroup59_SKLWriteResGroup61_SKLWriteResGroup63_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64Ld_WriteFCmpLd_WriteFCom_WriteFComLd_WriteEMMS_WriteIMul32RegLd_WriteIMul32ImmLd_WriteLDMXCSR_WriteFMulXLd_WriteFMul64Ld_WriteVecIMulXLd_WritePSADBWXLd_WriteVarShuffleXLd_WriteFRndLd_AtomWrite1_5_AtomWrite0_1_5_AtomWrite01_5_WriteJumpLd_WriteFLoadX_WriteFLoadY_WriteADCLd_WriteALULd_WriteFAdd64X_WriteAESIMC_WriteAESKeyGen_WriteBitTestImmLd_WriteBitTestRegLd_WriteBZHILd_WriteCMOVLd_WriteIMul16Imm_WriteVecLoadX_WritePHAdd_WriteVecLoadNT_WriteFMul64X_WritePMULLD_WriteFRcpX_WriteShiftLd_WriteFRsqrtX_WriteFAdd64Y_WriteFAddY_WriteFMAX_WriteFMAY_WriteVecLoadY_WriteVecLoadNTY_WriteFMul64Y_WriteFMulY_WriteFRcpY_WriteFRsqrtY_PdWriteX87Add_PdWriteX87Mul_PdWriteCRC32r32r16_PdWriteCMOVm_WriteFHAdd_WriteCLMul_WritePHMINPOS_WriteCvtPS2PHSt_WritePSADBWY_WriteFHAddY_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_BWWriteResGroup50_BWWriteResGroup49_BWWriteResGroup54_BWWriteResGroup36_BWWriteResGroup57_BWWriteResGroup47_BWWriteResGroup51_BWWriteResGroup55_BWWritePCMPGTQ_WriteBLSLd_WriteBSR_WriteTZCNTLd_WriteVecIMulZ_SKXWriteResGroup61_SKXWriteResGroup58_SKXWriteResGroup44b_SKXWriteResGroup69_SKXWriteResGroup63_SKXWriteResGroup67_SKXWriteResGroup62_SKXWriteResGroup65_SKXWriteResGroup66_WriteCvtSD2I_WriteCvtI2SS_WriteCvtSS2I_WriteVecExtractSt_WriteSTMXCSR_WritePSADBWZ_WriteFMAZ_WriteFMul64Z_WriteFMulZ_WritePMULLDY_WritePMULLDZ_SBWriteResGroup33_SBWriteResGroup31_SBWriteResGroup41_SBWriteResGroup47_SBWriteResGroup76_SBWriteResGroup35_SBWriteResGroup35_2_SBWriteResGroup36_SBWriteResGroup40_SBWriteResGroup45_SBWriteResGroup46_SBWritePCMPGTQ_HWWriteResGroup93_HWWriteResGroup0_2_HWWriteResGroup99_HWWriteResGroup60_HWWriteResGroup88_HWWriteResGroup89_HWWriteResGroup94_HWWriteResGroup100_HWWritePCMPGTQ_WriteRMW_WriteCvtI2PD_WriteCvtI2PS_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtPS2I_WriteCvtPS2PD_WriteCvtI2SD_WriteIMul64Reg_WriteIMul64Imm_WriteIMul8_WriteVecShiftLd_WriteVecShiftXLd_WriteCvtI2PDY_WriteCvtI2PSY_WriteCvtPD2PSY_WriteCvtPD2IY_WriteCvtPS2IY_WriteCvtPS2PDY_WriteVecShiftYLd_ICXWriteResGroup61_ICXWriteResGroup58_ICXWriteResGroup44b_ICXWriteResGroup69_ICXWriteResGroup63_ICXWriteResGroup67_ICXWriteResGroup62_ICXWriteResGroup65_ICXWriteResGroup66_WriteBEXTRLd_WritePOPCNTLd_ZnWriteRSQRTSSr_ZnWriteCVTPD2PSYr_ZnWriteRSQRTPSYr_ZnWriteCVTPD2DQr_ZnWriteSTr_ZnWriteXCHGrm_ZnWriteST_FP80m_ZnWriteEXTRACTPSm_ZnWriteMOVBE_ZnWriteCVSTSI2SIr_ZnWriteCVTDQ2PDr_ZnWriteCVSTSI2SDr_ZnWritePop16r_WriteLZCNTLd_Zn2WriteRSQRTSSr_Zn2WriteRSQRTPSYr_Zn2WriteSTr_Zn2WriteXCHGrm_Zn2WriteST_FP80m_Zn2WriteEXTRACTPSm_Zn2WriteMOVBE_Zn2WritePop16r_Zn3WriteMOVSlow_Zn3WriteX87Arith_Zn3WriteX87Div_Zn3Writerm_SHA1MSG2rm_SHA1NEXTErm_Zn3WriteRotateM1_Zn3WriteVPERMDYrr
  {29,  0}, // #15 WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_AtomWrite01_29_WriteAESKeyGen_WriteFDiv64YLd_WriteFSqrt64Y_BWWriteResGroup182_BWWriteResGroup185_SKXWriteResGroup242_WriteFDivY_WriteFDivZ_WriteFSqrtY_WriteFSqrtZ_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_ICXWriteResGroup242
  {76,  0}, // #16 WriteDiv16_WriteDiv32_WriteDiv64
  {17,  0}, // #17 SKLWriteResGroup179_WriteFSqrtLd_WritePMULLDYLd_SKLWriteResGroup180_AtomWrite01_17_WriteCLMulLd_WriteFDivY_WriteFRcpYLd_WriteFRsqrtYLd_BWWriteResGroup183_1_WriteDiv16_WriteIDiv16_WriteDPPSYLd_JWriteLOCK_CMPXCHGrm_SKXWriteResGroup201_WritePMULLDZLd_SKXWriteResGroup202_SKXWriteGatherEVEX2_WritePCmpEStrMLd_WritePCmpIStrILd_WritePCmpIStrMLd_WriteFSqrtXLd_HWWriteResGroup147_HWWriteResGroup132_HWWriteResGroup185_HWWriteResGroup189_ICXWriteResGroup201_ICXWriteResGroup202_ICXWriteGatherEVEX2_Zn2WriteVDIVPSYLd_WriteDiv32Ld_WriteDiv64_WriteIDiv32Ld_WriteIDiv64
  {11,  0}, // #18 SKLWriteResGroup145_WriteFDiv_WriteVecIMulXLd_WriteSHDmrcl_WriteFAdd64YLd_WriteFAddYLd_WriteFCmp64YLd_WriteFCmpYLd_WriteFDivY_WriteFMAYLd_WriteMPSADYLd_WriteFMul64YLd_WriteFMulYLd_WriteFRcpYLd_WriteFRsqrtYLd_SKLWriteResGroup156_SKLWriteResGroup151_SKLWriteResGroup149_SKLWriteResGroup146_SKLWriteResGroup147_SKLWriteResGroup152_SKLWriteResGroup150_SKLWriteResGroup154_SKLWriteResGroup155_AtomWrite01_11_WriteCvtPD2PS_WriteCvtSD2SSLd_WriteFHAdd_WriteVecMoveToGpr_WriteVecMoveFromGpr_WritePCmpIStrI_WriteFHAddY_PdWriteRCR8rCL_PdWriteRCL16ri_WriteFDivX_BWWriteResGroup122_1_WritePCmpIStrM_WriteFRndLd_WriteFSqrtX_WritePSADBWYLd_WriteVecIMulYLd_WriteFHAddYLd_BWWriteResGroup133_BWWriteResGroup123_BWWriteResGroup128_BWWriteResGroup131_BWWriteResGroup132_WriteCMPXCHGRMW_WriteDPPS_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_JWriteXCHGrm_XCHG_Part_JWriteCMPXCHG8B_JWriteCMPXCHG8rm_JWriteLOCK_XADDrm_XCHG_Part_WriteCvtSD2ILd_WriteCvtSS2ILd_SKXWriteResGroup159_WriteFMAZLd_WriteFAdd64ZLd_WriteFAddZLd_WriteFCmpZLd_WriteFCmp64ZLd_WriteFMul64ZLd_WriteFMulZLd_WriteFRcpZLd_SKXWriteResGroup171_SKXWriteResGroup162_SKXWriteResGroup160_SKXWriteResGroup161_SKXWriteResGroup166_SKXWriteResGroup164_SKXWriteResGroup169_SKXWriteResGroup170_SKXWriteResGroup148_2_SKXWriteResGroup163_SKXWriteResGroup167_WriteFHAddLd_WriteFMul64XLd_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePCmpEStrM_WritePHMINPOSLd_WritePMULLDLd_WritePSADBWXLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_WriteFRsqrtLd_WriteCvtPD2PSZLd_WriteCvtPD2IZLd_WriteVecShiftYLd_WriteVecShiftZLd_SBWriteResGroup108_SBWriteResGroup104_SBWriteResGroup106_WriteCLMul_WriteFMAXLd_WriteVecTestYLd_WriteFRsqrtZ_HWWriteResGroup131_HWWriteFRNDINT_HWWriteResGroup91_2_HWWriteResGroup75_HWWriteResGroup129_HWWriteResGroup130_WriteAESDecEncLd_WriteAESIMCLd_WriteAESKeyGenLd_ICXWriteResGroup159_ICXWriteResGroup171_ICXWriteResGroup162_ICXWriteResGroup160_ICXWriteResGroup161_ICXWriteResGroup166_ICXWriteResGroup164_ICXWriteResGroup169_ICXWriteResGroup170_ICXWriteResGroup148_2_ICXWriteResGroup163_ICXWriteResGroup167_ZnWriteCVTPD2PSLd_ZnWriteCVTSS2SDLd_ZnWriteFPU3_WriteVecIMulLd_ZnWriteCVTPD2PSYLd_WriteFRndYLd_WriteFTestYLd_ZnWriteFILD_ZnWriteSHA256RNDS2Ld_Zn2WriteFPU3_WritePMULLDYLd_Zn2WriteFILD_Zn2WriteCVSTSI2SILd_Zn2WriteSHA256RNDS2Ld_WriteFComXLd_WriteDiv16_WriteFLDC_WriteIDiv16_WriteFLD1_WriteMPSADLd_WriteCLMulLd_WriteFMALd_WriteCvtI2PDYLd_WriteCvtPS2PDYLd_WriteCvtPH2PSYLd_WriteVPMOV256Ld_Zn3WriteVPERMPSYrm
  {16,  0}, // #19 WriteFDivLd_WritePCmpIStrILd_WritePCmpIStrMLd_WritePMULLDLd_SKLWriteResGroup177_SKLWriteResGroup178_WriteBSFLd_WriteBSRLd_WriteDiv8Ld_WriteFHAddLd_WriteIDiv8Ld_WriteFHAddYLd_WriteFDivXLd_BWWriteResGroup150_WriteFSqrt64X_WriteFSqrtXLd_WriteFSqrtLd_WritePMULLDYLd_BWWriteResGroup153_WriteDPPSLd_WriteFMaskedStore64Y_WriteFMaskedStore32_JWriteXCHGrm_LdSt_Part_JWriteLOCK_CMPXCHG8rm_WriteFRsqrtZLd_SKXWriteResGroup199_HWWriteResGroup120_HWWriteResGroup186_HWWriteResGroup190_ICXWriteResGroup199_WriteDPPDLd
  {19,  0}, // #20 SKLWriteResGroup186_WriteDPPSLd_WritePCmpEStrM_WriteFSqrtYLd_WriteDiv16Ld_WriteIDiv16Ld_WritePCmpEStrILd_WriteAESIMCLd_WriteFDiv64XLd_BWWriteResGroup161_BWWriteResGroup183_4_BWWriteResGroup183_3_WriteFDivX_WritePCmpEStrMLd_JWriteLOCK_CMPXCHG8B_JWriteLOCK_ALURMW_SKXWriteResGroup209_SKXWriteGatherEVEX4_WriteDPPSYLd_WriteFDivXLd_HWWriteResGroup135_HWWriteResGroup143_HWWriteFPREM_ICXWriteResGroup209_ICXWriteGatherEVEX4_WriteDiv8Ld_WriteIDiv8Ld_ZnWriteVDIVPSYLd
  {15,  0}, // #21 WriteDPPDLd_WriteFRndYLd_SKLWriteResGroup174_SKLWriteResGroup171_WriteCMPXCHG_WriteSTMXCSR_WriteDiv16_WriteIDiv16_WritePCmpEStrMLd_PdWriteVFRCZm_PdWriteVFRCZYm_WritePMULLDLd_BWWriteResGroup149_BWWriteResGroup147_WriteDiv8Ld_WriteIDiv8Ld_WriteFRndZLd_SKXWriteResGroup195_SKXWriteResGroup191_SKXWriteResGroup174_SKXWriteResGroup174z_SKXWriteResGroup194_SBWriteResGroup119_HWWriteResGroup115_HWWriteFXTRACT_HWWriteResGroup188_WriteDPPS_ICXWriteResGroup195_ICXWriteResGroup191_ICXWriteResGroup174_ICXWriteResGroup174z_ICXWriteResGroup194_WriteFDiv64X_WriteFDivX_ZnWriteVDIVPDY_WriteDiv16Ld_WriteIDiv16Ld_WriteFSqrtX_WriteDPPSY_WriteFSqrtY
  {13,  0}, // #22 WriteDPPS_WriteDPPSY_WriteFHAddYLd_SKLWriteResGroup162_SKLWriteResGroup163_AtomWrite01_13_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSS2I_WriteVecExtractSt_WriteCvtI2PDYLd_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_WriteCvtPS2PDYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_PdWriteCVTSI642SDrr_CVTSI642SSrr_CVTSI2SDr_CVTSI2SSrr_PdWriteRCL8ri_WriteMPSADYLd_WritePCmpIStrMLd_WriteFMaskedStore64_SKXWriteResGroup180_SKXWriteResGroup181_SKXWriteResGroup183_WriteAESDecEncLd_WriteMPSADLd_SBWriteResGroup114_WriteFDivX_WriteFRndYLd_WriteFRndZLd_HWWriteResGroup103_WriteBSFLd_WriteBSRLd_WriteCLMulLd_ICXWriteResGroup180_ICXWriteResGroup181_ICXWriteResGroup183_ZnWriteSHA1RNDS4Ld_Zn2WriteVDIVPDY_Zn2WriteSHA1RNDS4Ld_WriteDiv32_WriteFDiv64X_WriteFHAddLd_WriteIDiv32_WritePCmpEStrILd_WritePCmpEStrMLd_WriteFDiv64Y
  {12,  0}, // #23 WriteFHAddLd_WriteCLMulLd_WriteFSqrtX_WriteVecIMulYLd_WriteFSqrtY_SKLWriteResGroup160_WriteCvtPD2PSLd_WriteIMul64Ld_WriteIMul64RegLd_WriteDiv8_WriteVecExtract_WriteIDiv8_WriteFMOVMSK_WritePCmpIStrMLd_WriteVecMOVMSK_PdWriteRCL8rCL_PdWriteRCR8ri_PdWriteVPCLMULQDQrr_WriteAESDecEncLd_WriteMPSADLd_WriteFRndYLd_BWWriteResGroup135_WriteCvtSD2ILd_WriteCvtSD2SSLd_WriteCvtSS2SDLd_WriteCvtSS2ILd_WritePCmpIStrILd_WriteDPPSY_WriteVecIMulZLd_SKXWriteResGroup179_SKXWriteResGroup200_SKXWriteResGroup175_SKXWriteResGroup176_SKXWriteResGroup177_WriteAESIMC_WritePSADBWYLd_WritePSADBWZLd_WriteFHAddYLd_WriteFMul64YLd_WriteFMul64ZLd_WriteFMulYLd_WriteFMulZLd_WritePMULLDYLd_WritePMULLDZLd_SBWriteResGroup111_WriteFRndLd_WriteSHDmrcl_WriteFMAZLd_WriteFMAYLd_HWWriteResGroup91_3_HWWriteResGroup104_WriteDPPD_WriteFRcpXLd_WriteFRsqrtXLd_ICXWriteResGroup179_ICXWriteResGroup200_ICXWriteResGroup175_ICXWriteResGroup176_ICXWriteResGroup177_WriteCvtI2PDLd_WriteCvtI2PSLd_WriteCvtPD2ILd_WriteCvtPS2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteFRcpLd_ZnWriteRSQRTSSLd_WriteFMALd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPD2IYLd_WriteCvtPS2IYLd_ZnWriteVDIVPSYr_WriteFMAXLd_WriteFRcpYLd_ZnWriteRSQRTPSYLd_ZnWriteCVTPD2DQLd_ZnWriteFIST_ZnWriteCVSTSI2SILd_ZnWriteFPU03_Zn2WriteRSQRTSSLd_Zn2WriteRSQRTPSYLd_Zn2WriteFIST_Zn2WriteFPU03
  {28,  0}, // #24 WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteDiv32Ld_WriteFDiv64XLd_WriteFDiv64Ld_WriteFDivYLd_WriteFDivZLd_WriteFSqrtYLd_WriteFSqrtZLd_WriteFSqrt64XLd_WriteFSqrt64Ld_WriteFSqrt64YLd
  {102,  0}, // #25 WriteIDiv16_WriteIDiv32_WriteIDiv64
  { 9,  0}, // #26 WriteIMulHLd
  { 8,  0}, // #27 WriteMULX32Ld_WriteMULX64Ld
  { 4,  0}, // #28 WriteIMulH
  { 3,  0}, // #29 WriteMULX32_WriteMULX64
  {24,  0}, // #30 WritePCmpEStrILd_WriteFSqrt64XLd_WritePCmpEStrMLd_BWWriteResGroup177_WriteFDiv64XLd_WriteFDivXLd_WriteFDivLd_WriteFDiv64Ld_WriteFSqrt80_HWWriteResGroup162
  {18,  0}, // #31 WritePCmpEStrI_WriteFSqrt64X_WriteFSqrtXLd_WriteFDivYLd_WriteFSqrt64Y_SKLWriteResGroup185_SKLWriteResGroup184_SKLWriteResGroupVEX2_AtomWrite01_18_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteDiv32Ld_WriteDiv64Ld_WriteIDiv32Ld_WriteIDiv64Ld_BWWriteResGroup160_BWWriteResGroup159_BWWriteResGroup183_2_WriteFDivZ_SKXWriteResGroup208_SKXWriteResGroup207_SKXWriteResGroupVEX2_WriteAESIMCLd_WriteDPPSLd_WriteFDivLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_WriteFRsqrtZLd_HWWriteResGroup149_ICXWriteResGroup208_ICXWriteResGroup207_ICXWriteResGroupVEX2_WriteFDivXLd
  { 6,  0}, // #32 WriteRotateLd_WriteShiftLd_WriteALULd
  { 1,  0}, // #33 WriteRMW
  { 8,  0}, // #34 WriteRotateCLLd_WriteShiftCLLd
  { 1,  0}, // #35 WriteRMW
  {23,  0}, // #36 WriteFSqrt64Ld_SKLWriteResGroup198_AtomWrite01_23_WritePCmpEStrILd_WriteFSqrt80_WriteFDiv64Y_WriteFDivYLd_BWWriteResGroup176_WriteFDiv64Z_SKXWriteResGroup228_WriteIDiv8_HWWriteResGroup151_WriteFSqrtLd_ICXWriteResGroup228
  {21,  0}, // #37 WriteFSqrt80_SKLWriteResGroup195_AtomWrite01_21_WriteFSqrt64XLd_WriteFSqrt64Ld_WriteFSqrtY_BWWriteResGroup171_BWWriteResGroup169_BWWriteResGroup183_5_WriteFSqrtX_SKXWriteResGroup222_SKXWriteResGroup205_SKXWriteGatherEVEX8_WriteFDivY_WriteFDivZ_WriteDPPSYLd_WriteFSqrtZ_HWWriteResGroup144_WritePCmpEStrI_ICXWriteResGroup222_ICXWriteResGroup205_ICXWriteGatherEVEX8_WriteDiv16Ld_WriteIDiv16Ld_WriteDiv64Ld_WriteIDiv64Ld_WriteFSqrt64Y
  { 5,  0}, // #38 WriteLoad
  { 5,  0}, // #39 WriteVecMaskedGatherWriteback
  {42,  0}, // #40 SKLWriteResGroup214_SKLWriteResGroup215_BWWriteResGroup196_WriteFSqrtY_SKXWriteResGroup254_SKXWriteResGroup255_WriteFDiv64YLd_WriteFDiv64ZLd_WriteFSqrt64YLd_WriteFSqrt64ZLd_HWWriteResGroup176_WriteFDivXLd_ICXWriteResGroup254_ICXWriteResGroup255
  {75,  0}, // #41 SKLWriteResGroup220_BWWriteResGroup200_SKXWriteResGroup263_HWWriteResGroup180_HWWriteFSCALE_ICXWriteResGroup263
  {35,  0}, // #42 SKLWriteResGroup210_SKLWriteResGroup209_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteFSqrt64YLd_BWWriteResGroup194_WriteFSqrt80_SKXWriteResGroup248_SKXWriteResGroup247_WriteFDiv64Y_WriteFDiv64Z_WriteFSqrt64Z_HWWriteResGroup170_ICXWriteResGroup248_ICXWriteResGroup247_WriteFSqrtYLd
  {63,  0}, // #43 SKLWriteResGroup219_SKLWriteResGroup218_AtomWrite01_63_BWWriteResGroup199_BWWriteResGroup198_SKXWriteResGroup260_SKXWriteResGroup259_ICXWriteResGroup260_ICXWriteResGroup259
  {22,  0}, // #44 SKLWriteResGroup196_SKLWriteResGroupVEX8_AtomWrite01_22_BWWriteResGroup172_WriteFMaskedStore32Y_SKXWriteResGroup223_SKXWriteResGroupVEX8_SKXWriteResGroup211_SKXWriteResGroup211_1_SKXWriteResGroup225_WriteFDiv64X_WriteDiv8_WriteFSqrt64XLd_HWWriteResGroup146_HWWriteResGroup187_WriteFDivLd_ICXWriteResGroup223_ICXWriteResGroupVEX8_ICXWriteResGroup211_ICXWriteResGroup211_1_ICXWriteResGroup225_WriteFDiv64XLd_WriteFDivXLd_WriteFDiv64Ld_ZnWriteVDIVPDYLd_WriteDPPSLd_WriteFSqrtXLd_WriteFSqrtLd_WriteFSqrt80_WriteDPPSYLd_WriteFSqrtYLd
  {37,  0}, // #45 SKLWriteResGroup211_SKXWriteResGroup250_SKXWriteResGroup249_WriteFDiv64Ld_ICXWriteResGroup250_ICXWriteResGroup249
  {27,  0}, // #46 SKLWriteResGroup206_WriteDPPSY_PdWriteVDPPSrri_WriteFSqrtYLd_WriteFSqrt64X_WriteFSqrtZLd_SKXWriteResGroup239_WriteFSqrt64XLd_WriteFSqrt64Ld_HWWriteFPREM1_HWWriteResGroup155_ICXWriteResGroup239_WriteFSqrtXLd_WriteFSqrtLd_WriteFSqrt64YLd
  {30,  0}, // #47 SKLWriteResGroup208_AtomWrite01_30_WriteDPPSLd_BWWriteResGroup186_WriteFDiv64ZLd_SKXWriteResGroup243_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_HWWriteResGroup161_HWWriteResGroup164_ICXWriteResGroup243
  {41,  0}, // #48 SKLWriteResGroup213_WriteDiv64_WriteIDiv64_SKXWriteResGroup253_HWWriteResGroup175_WriteFSqrtX_ICXWriteResGroup253
  {46,  0}, // #49 SKLWriteResGroup216_AtomWrite01_46_PdWriteVZEROUPPER_JWriteJVZEROUPPER
  {40,  0}, // #50 SKLWriteResGroup212_SKXWriteResGroup252_WriteFSqrt80_ICXWriteResGroup252_WriteFSqrt64Y
  {62,  0}, // #51 SKLWriteResGroup217_WriteFDiv64Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv8Ld_WriteFSqrt64Ld_SKXWriteResGroup258_ICXWriteResGroup258
  {106,  0}, // #52 SKLWriteResGroup223_SKXWriteResGroup266_ICXWriteResGroup266
  {50,  0}, // #53 WriteDiv16Ld_WriteDiv32Ld_WriteDiv8
  {130,  0}, // #54 WriteDiv64Ld_WriteIDiv64Ld_AtomWrite01_130
  {68,  0}, // #55 WriteDiv8Ld_AtomWrite01_68
  {125,  0}, // #56 WriteFDiv64XLd_WriteFSqrt64XLd
  {70,  0}, // #57 WriteFDivXLd_WriteFSqrtXLd
  {34,  0}, // #58 WriteFDivLd_WriteFSqrtLd_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_BWWriteResGroup191_JWriteMASKMOVDQU_SBWriteResGroup131_WriteAESKeyGenLd_HWWriteResGroup166_WriteFDiv64
  { 1,  0}, // #59 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #60 WriteRMW
  {71,  0}, // #61 WriteFSqrt80_AtomWrite01_71_WriteFSqrt64X
  {26,  0}, // #62 AtomWrite01_26_BWWriteResGroup180_WriteFSqrtXLd_WriteFSqrtLd_WriteFDiv64XLd
  {32,  0}, // #63 AtomWrite01_32_WriteDPPSYLd_WriteFSqrt64XLd_WriteFSqrt64Ld_JWriteCMPXCHG16B_WriteFSqrt64Z
  {45,  0}, // #64 AtomWrite01_45_WriteFDiv64Y_WriteFDiv64Z_WriteFSqrt64Y_WriteFSqrt64Z_WriteDiv64Ld_WriteIDiv64Ld
  {48,  0}, // #65 AtomWrite01_48
  {55,  0}, // #66 AtomWrite01_55
  {59,  0}, // #67 AtomWrite01_59_WriteFSqrt64YLd
  {72,  0}, // #68 AtomWrite01_72_WriteFDiv64XLd
  {74,  0}, // #69 AtomWrite01_74_SKXWriteResGroup262_WriteFSqrt64XLd_ICXWriteResGroup262
  {77,  0}, // #70 AtomWrite01_77
  {78,  0}, // #71 AtomWrite01_78
  {79,  0}, // #72 AtomWrite01_79
  {92,  0}, // #73 AtomWrite01_92
  {94,  0}, // #74 AtomWrite01_94
  {99,  0}, // #75 AtomWrite01_99
  {121,  0}, // #76 AtomWrite01_121
  {127,  0}, // #77 AtomWrite01_127
  {140,  0}, // #78 AtomWrite01_140_SKXWriteResGroup267_ICXWriteResGroup267
  {141,  0}, // #79 AtomWrite01_141
  {146,  0}, // #80 AtomWrite01_146
  {147,  0}, // #81 AtomWrite01_147
  {168,  0}, // #82 AtomWrite01_168
  {174,  0}, // #83 AtomWrite01_174
  {183,  0}, // #84 AtomWrite01_183
  {202,  0}, // #85 AtomWrite01_202
  { 5,  0}, // #86 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #87 WriteRMW
  {90,  0}, // #88 PdWriteVZEROALL_JWriteJVZEROALL
  {184,  0}, // #89 PdWriteLARrr
  {33,  0}, // #90 WriteAESKeyGenLd
  {80,  0}, // #91 WriteDiv16_WriteDiv32_WriteDiv64
  {31,  0}, // #92 WriteEMMS_SBWriteResGroup130_HWWriteResGroup163_HWWriteResGroup165
  {60,  0}, // #93 BWWriteResGroup197
  {115,  0}, // #94 BWWriteResGroup202_HWWriteResGroup183
  {44,  0}, // #95 WriteDiv64Ld_WriteIDiv64Ld_SKXWriteResGroup256_WriteFSqrtXLd_ICXWriteResGroup256
  { 4,  0}, // #96 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 2,  0}, // #97 WriteRMW
  {43,  0}, // #98 WriteFDiv64YLd_WriteFDivYLd
  {38,  0}, // #99 WriteFDiv64Y_WriteFDivY_JWriteLOCK_CMPXCHG16B_WriteFSqrt64Ld
  {54,  0}, // #100 WriteFSqrt64Y
  {47,  0}, // #101 WriteFSqrtYLd_HWWriteFBLD_WriteFSqrt64YLd
  { 3,  0}, // #102 JWriteXADDrm_XCHG_Part
  {11,  0}, // #103 JWriteXADDrm_LdSt_Part
  {39,  0}, // #104 WriteFSqrt64ZLd_WriteFDivX
  {67,  0}, // #105 SKXWriteResGroup261_ICXWriteResGroup261
  { 7,  0}, // #106 WriteRotateLd
  { 1,  0}, // #107 WriteRMW
  {52,  0}, // #108 WriteFDiv64YLd_WriteFDiv64ZLd_WriteFSqrt64YLd_WriteFSqrt64ZLd
  {36,  0}, // #109 WriteFDivYLd_WriteFDivZLd_WriteFSqrtYLd_WriteFSqrtZLd_HWWriteResGroup171
  {98,  0}, // #110 WriteDiv16_WriteDiv32_WriteDiv64
  {112,  0}, // #111 WriteIDiv16_WriteIDiv32_WriteIDiv64
  {64,  0}, // #112 HWWriteResGroup179_HWWriteResGroup178
  {61,  0}, // #113 HWWriteResGroup177
  {69,  0}, // #114 WriteFDiv64X
  { 4,  0}, // #115 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #116 WriteRMW
  { 7,  0}, // #117 WriteIMulHLd
  { 8,  0}, // #118 WriteMULX32Ld_WriteMULX64Ld
  { 3,  0}, // #119 WriteIMulH
  { 3,  0}, // #120 WriteMULX32_WriteMULX64
  {107,  0}, // #121 WriteFShuffle256Ld_WriteFVarShuffle256Ld
  { 8,  0}, // #122 WriteLoad
  { 8,  0}, // #123 WriteVecMaskedGatherWriteback_WriteIMulHLd
  { 7,  0}, // #124 WriteIMulHLd_WriteMULX32Ld_WriteMULX64Ld
  { 7,  0} // #125 WriteMULX32Ld_WriteMULX64Ld
}; // X86WriteLatencyTable

// {UseIdx, WriteResourceID, Cycles}
extern const llvm::MCReadAdvanceEntry X86ReadAdvanceTable[] = {
  {0,  0,  0}, // Invalid
  {5,  0,  5}, // #1
  {6,  0,  5}, // #2
  {0,  0,  5}, // #3
  {6,  0,  5}, // #4
  {0,  0,  6}, // #5
  {1,  0,  0}, // #6
  {0,  0,  7}, // #7
  {0,  0,  7}, // #8
  {6,  0,  7}, // #9
  {0,  0,  6}, // #10
  {6,  0,  6}, // #11
  {0,  0,  7}, // #12
  {1,  0,  7}, // #13
  {0,  0,  6}, // #14
  {1,  0,  6}, // #15
  {0,  0,  5}, // #16
  {1,  0,  5}, // #17
  {5,  0,  3}, // #18
  {6,  0,  3}, // #19
  {0,  0,  3}, // #20
  {6,  0,  3}, // #21
  {0,  0,  3}, // #22
  {1,  0,  3}, // #23
  {5,  0,  4}, // #24
  {6,  0,  4}, // #25
  {0,  0,  4}, // #26
  {6,  0,  4}, // #27
  {0,  0, -10}, // #28
  {1,  0, -10}, // #29
  {0,  0, -6}, // #30
  {1,  0, -6}, // #31
  {5,  0,  3}, // #32
  {6,  0,  3}, // #33
  {7,  0,  3}, // #34
  {8,  0,  3}, // #35
  {0,  0,  8}, // #36
  {0,  0,  8}, // #37
  {6,  0,  8}, // #38
  {0,  0,  8}, // #39
  {1,  0,  8}, // #40
  {0,  0, -1}, // #41
  {1,  0, -1} // #42
}; // X86ReadAdvanceTable

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc SkylakeClientModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, false,  3, 5,  1, 1,  0, 0}, // #3
  {DBGFIELD("WriteJump")          1, false, false, false,  8, 4,  1, 1,  0, 0}, // #4
  {DBGFIELD("WriteCMPXCHGRMW")    6, false, false, false, 12, 8,  2, 1,  0, 0}, // #5
  {DBGFIELD("WriteJumpLd")        2, false, false, false, 20, 6,  3, 1,  0, 0}, // #6
  {DBGFIELD("WriteMove")          1, false, false, false,  1, 2,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, false,  1, 2,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteADC")           1, false, false, false,  8, 4,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteSHDrri")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreX")       2, false, false, false, 33, 4,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteFLoadX")        1, false, false, false, 37, 3,  3, 1,  0, 0}, // #12
  {DBGFIELD("WriteFStoreY")       2, false, false, false, 33, 4,  1, 1,  0, 0}, // #13
  {DBGFIELD("WriteFLoadY")        1, false, false, false, 37, 3,  6, 1,  0, 0}, // #14
  {DBGFIELD("WriteMicrocoded")    1, false, false, false,  1, 2,  4, 1,  0, 0}, // #15
  {DBGFIELD("WriteFSign")         1, false, false, false, 40, 9,  1, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCRMW")        6, false, false, false, 12, 8,  2, 1,  0, 0}, // #17
  {DBGFIELD("WriteADCRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 6, false, false, false, 12, 8,  2, 1,  1, 2}, // #18
  {DBGFIELD("WriteADCLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 20, 6,  3, 1,  3, 2}, // #19
  {DBGFIELD("WriteALURMW")        3, false, false, false, 49, 6,  6, 1,  0, 0}, // #20
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, false, 49, 6,  6, 1,  1, 1}, // #21
  {DBGFIELD("WriteALULd_ReadAfterLd") 2, false, false, false, 55, 4,  3, 1,  3, 1}, // #22
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1,  5, 1}, // #23
  {DBGFIELD("WriteFAdd64X")       1, false, false, false, 65, 4,  8, 1,  0, 0}, // #24
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1,  5, 1}, // #25
  {DBGFIELD("WriteFAddX")         1, false, false, false, 65, 4,  8, 1,  0, 0}, // #26
  {DBGFIELD("WriteNop")           1, false, false, false,  0, 0,  1, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 2, false, false, false, 59, 6,  9, 1,  3, 1}, // #28
  {DBGFIELD("WriteFAdd64")        1, false, false, false, 65, 4,  8, 1,  0, 0}, // #29
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 2, false, false, false, 59, 6,  9, 1,  3, 1}, // #30
  {DBGFIELD("WriteFAdd")          1, false, false, false, 65, 4,  8, 1,  0, 0}, // #31
  {DBGFIELD("WriteFAddLd")        2, false, false, false, 59, 6,  9, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 2, false, false, false, 69, 11,  7, 1,  5, 1}, // #33
  {DBGFIELD("WriteAESDecEnc")     1, false, false, false, 40, 9,  8, 1,  0, 0}, // #34
  {DBGFIELD("WriteAESIMCLd")      3, false, false, false, 80, 11, 10, 1,  0, 0}, // #35
  {DBGFIELD("WriteAESIMC")        2, false, false, false, 91, 9,  2, 1,  0, 0}, // #36
  {DBGFIELD("WriteAESKeyGenLd")   11, false, false, false, 100, 14, 11, 1,  0, 0}, // #37
  {DBGFIELD("WriteAESKeyGen")     11, false, false, false, 114, 12, 12, 1,  0, 0}, // #38
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 2, false, false, false, 60, 5,  6, 1,  5, 1}, // #39
  {DBGFIELD("WriteFLogic")        1, false, false, false, 30, 3,  1, 1,  0, 0}, // #40
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, false, 126, 8,  6, 1,  1, 1}, // #41
  {DBGFIELD("WriteBEXTR")         2, false, false, false, 134, 6, 13, 1,  0, 0}, // #42
  {DBGFIELD("WriteBEXTRLd")       3, false, false, false, 126, 8,  6, 1,  0, 0}, // #43
  {DBGFIELD("WriteALULd")         2, false, false, false, 55, 4,  3, 1,  0, 0}, // #44
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 2, false, false, false, 60, 5,  6, 1,  5, 1}, // #45
  {DBGFIELD("WriteFBlend")        1, false, false, false, 30, 3,  1, 1,  0, 0}, // #46
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 3, false, false, false, 140, 5,  2, 1,  5, 1}, // #47
  {DBGFIELD("WriteFVarBlend")     2, false, false, false, 145, 3, 13, 1,  0, 0}, // #48
  {DBGFIELD("WriteBLSLd")         2, false, false, false, 148, 6,  3, 1,  0, 0}, // #49
  {DBGFIELD("WriteBLS")           1, false, false, false, 154, 4,  1, 1,  0, 0}, // #50
  {DBGFIELD("WriteBSFLd")         2, false, false, false, 158, 9,  2, 1,  0, 0}, // #51
  {DBGFIELD("WriteBSF")           1, false, false, false, 26, 7,  5, 1,  0, 0}, // #52
  {DBGFIELD("WriteBSRLd")         2, false, false, false, 158, 9,  2, 1,  0, 0}, // #53
  {DBGFIELD("WriteBSR")           1, false, false, false, 26, 7,  5, 1,  0, 0}, // #54
  {DBGFIELD("WriteBSWAP32")       1, false, false, false, 154, 4,  1, 1,  0, 0}, // #55
  {DBGFIELD("WriteBSWAP64")       2, false, false, false, 134, 6, 13, 1,  0, 0}, // #56
  {DBGFIELD("WriteBitTestImmLd")  2, false, false, false, 20, 6,  3, 1,  0, 0}, // #57
  {DBGFIELD("WriteBitTestRegLd")  2, false, false, false, 55, 4,  3, 1,  0, 0}, // #58
  {DBGFIELD("WriteBitTest")       1, false, false, false,  8, 4,  1, 1,  0, 0}, // #59
  {DBGFIELD("WriteBitTestSetImmRMW") 4, false, false, false, 167, 8,  3, 1,  0, 0}, // #60
  {DBGFIELD("WriteBitTestSetRegRMW") 3, false, false, false, 49, 6,  3, 1,  0, 0}, // #61
  {DBGFIELD("WriteBitTestSet")    1, false, false, false,  8, 4,  1, 1,  0, 0}, // #62
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 148, 6,  3, 1,  1, 1}, // #63
  {DBGFIELD("WriteBZHI")          1, false, false, false, 154, 4,  1, 1,  0, 0}, // #64
  {DBGFIELD("WriteLoad")          1, false, false, false, 37, 3, 14, 1,  0, 0}, // #65
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 2, false, false, false, 20, 6,  3, 1,  3, 1}, // #66
  {DBGFIELD("WriteCMOV")          1, false, false, false,  8, 4,  1, 1,  0, 0}, // #67
  {DBGFIELD("WriteFCMOV")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #68
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 55, 4,  3, 1,  1, 1}, // #69
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1,  5, 1}, // #70
  {DBGFIELD("WriteFCmp64X")       1, false, false, false, 65, 4,  8, 1,  0, 0}, // #71
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1,  5, 1}, // #72
  {DBGFIELD("WriteFCmpX")         1, false, false, false, 65, 4,  8, 1,  0, 0}, // #73
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 2, false, false, false, 59, 6,  9, 1,  3, 1}, // #74
  {DBGFIELD("WriteFCmp64")        1, false, false, false, 65, 4,  8, 1,  0, 0}, // #75
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 2, false, false, false, 59, 6,  9, 1,  3, 1}, // #76
  {DBGFIELD("WriteFCmp")          1, false, false, false, 65, 4,  8, 1,  0, 0}, // #77
  {DBGFIELD("WriteCMPXCHG")       5, false, false, false, 175, 4, 14, 1,  0, 0}, // #78
  {DBGFIELD("WriteFComXLd_ReadAfterVecLd") 2, false, false, false, 69, 11,  6, 1,  3, 1}, // #79
  {DBGFIELD("WriteFComX")         1, false, false, false, 40, 9, 13, 1,  0, 0}, // #80
  {DBGFIELD("WriteFCom")          1, false, false, false, 40, 9, 13, 1,  0, 0}, // #81
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #82
  {DBGFIELD("WriteCRC32")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtI2PDLd")     2, false, false, false, 158, 9,  9, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtI2PD")       1, false, false, false, 26, 7,  8, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtI2PSLd")     2, false, false, false, 158, 9,  9, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtI2PS")       1, false, false, false, 26, 7,  8, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtPD2ILd")     2, false, false, false, 158, 9,  2, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtPD2I")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtPD2PSLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPD2PS")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPS2ILd")     2, false, false, false, 158, 9,  2, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtPS2I")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtPS2PD")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtSD2ILd")     2, false, false, false, 158, 9,  2, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtSD2I")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtSD2SSLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #100
  {DBGFIELD("WriteCvtSD2SS")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, false, 158, 9,  9, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 2, false, false, false, 158, 9,  9, 1,  3, 1}, // #103
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 1, false, false, false, 26, 7,  8, 1,  0, 1}, // #104
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 1, false, false, false, 26, 7,  8, 1,  6, 1}, // #105
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, false, 158, 9,  9, 1,  0, 0}, // #106
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 2, false, false, false, 158, 9,  9, 1,  3, 1}, // #107
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 1, false, false, false, 26, 7,  8, 1,  0, 1}, // #108
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 1, false, false, false, 26, 7,  8, 1,  6, 1}, // #109
  {DBGFIELD("WriteCvtSS2SDLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #110
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #111
  {DBGFIELD("WriteCvtSS2SD")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #112
  {DBGFIELD("WriteCvtSS2ILd")     2, false, false, false, 158, 9,  2, 1,  0, 0}, // #113
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #114
  {DBGFIELD("WriteCvtSS2I")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #115
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 179, 12, 15, 1,  1, 2}, // #116
  {DBGFIELD("WriteDiv16")         32, false, false, false, 191, 15, 16, 1,  0, 0}, // #117
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 179, 12, 15, 1,  1, 2}, // #118
  {DBGFIELD("WriteDiv32")         32, false, false, false, 191, 15, 16, 1,  0, 0}, // #119
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 179, 12, 15, 1,  1, 2}, // #120
  {DBGFIELD("WriteDiv64")         32, false, false, false, 191, 15, 16, 1,  0, 0}, // #121
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 179, 12, 15, 1,  1, 2}, // #122
  {DBGFIELD("WriteDiv8")          1, false, false, false, 206, 10, 11, 1,  0, 0}, // #123
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 2, false, false, false, 216, 12, 12, 1,  5, 1}, // #124
  {DBGFIELD("WriteFDiv64X")       1, false, false, false, 228, 10, 10, 1,  0, 0}, // #125
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 2, false, false, false, 238, 12, 17, 1,  5, 1}, // #126
  {DBGFIELD("WriteFDivX")         1, false, false, false, 228, 10, 18, 1,  0, 0}, // #127
  {DBGFIELD("WriteFDivLd")        2, false, false, false, 250, 12, 19, 1,  0, 0}, // #128
  {DBGFIELD("WriteFDiv")          1, false, false, false, 228, 10, 18, 1,  0, 0}, // #129
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 2, false, false, false, 216, 12, 20, 1,  3, 1}, // #130
  {DBGFIELD("WriteFDiv64")        1, false, false, false, 228, 10, 10, 1,  0, 0}, // #131
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 2, false, false, false, 250, 12, 19, 1,  3, 1}, // #132
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 4, false, false, false, 262, 11, 21, 1,  5, 1}, // #133
  {DBGFIELD("WriteDPPD")          3, false, false, false, 273, 9,  9, 1,  0, 0}, // #134
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 5, false, false, false, 282, 11, 20, 1,  5, 1}, // #135
  {DBGFIELD("WriteDPPS")          4, false, false, false, 293, 9, 22, 1,  0, 0}, // #136
  {DBGFIELD("WriteStore")         1, false, false, false, 33, 4,  1, 1,  0, 0}, // #137
  {DBGFIELD("WriteVecExtractSt")  3, false, false, false, 302, 11, 13, 1,  0, 0}, // #138
  {DBGFIELD("WriteVecExtract")    2, false, false, false, 313, 12,  5, 1,  0, 0}, // #139
  {DBGFIELD("WriteVecALUX")       1, false, false, false, 65, 4,  1, 1,  0, 0}, // #140
  {DBGFIELD("WriteFComLd")        2, false, false, false, 69, 11,  6, 1,  0, 0}, // #141
  {DBGFIELD("WriteEMMS")          10, false, false, false, 325, 5,  7, 1,  0, 0}, // #142
  {DBGFIELD("WriteFLDC")          2, false, false, false, 330, 5,  1, 1,  0, 0}, // #143
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  6, 1,  5, 1}, // #144
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 4, false, false, false, 335, 11, 23, 1,  5, 1}, // #145
  {DBGFIELD("WriteFHAdd")         3, false, false, false, 346, 9,  3, 1,  0, 0}, // #146
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 355, 14, 24, 1,  1, 2}, // #147
  {DBGFIELD("WriteIDiv16")        66, false, false, false, 369, 15, 25, 1,  0, 0}, // #148
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 355, 14, 24, 1,  1, 2}, // #149
  {DBGFIELD("WriteIDiv32")        66, false, false, false, 369, 15, 25, 1,  0, 0}, // #150
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 355, 14, 24, 1,  1, 2}, // #151
  {DBGFIELD("WriteIDiv64")        66, false, false, false, 369, 15, 25, 1,  0, 0}, // #152
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 355, 14, 24, 1,  1, 2}, // #153
  {DBGFIELD("WriteIDiv8")         1, false, false, false, 206, 10, 11, 1,  0, 0}, // #154
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 384, 11,  9, 1,  1, 2}, // #155
  {DBGFIELD("WriteIMul16")        4, false, false, false, 395, 9,  8, 1,  0, 0}, // #156
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #157
  {DBGFIELD("WriteIMul16ImmLd")   3, false, false, false, 404, 9,  2, 1,  0, 0}, // #158
  {DBGFIELD("WriteIMul16Reg")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul16Imm")     2, false, false, false, 413, 7,  8, 1,  0, 0}, // #160
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 420, 11,  9, 1,  1, 2}, // #161
  {DBGFIELD("WriteIMul32")        3, false, false, false, 431, 9,  8, 1,  0, 0}, // #162
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #163
  {DBGFIELD("WriteIMul32ImmLd")   2, false, false, false, 158, 9,  2, 1,  0, 0}, // #164
  {DBGFIELD("WriteIMul32Reg")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul32Imm")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #166
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 440, 13,  9, 1,  1, 2}, // #167
  {DBGFIELD("WriteIMul64")        2, false, false, false, 453, 11,  8, 1,  0, 0}, // #168
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #169
  {DBGFIELD("WriteIMul64ImmLd")   2, false, false, false, 158, 9,  2, 1,  0, 0}, // #170
  {DBGFIELD("WriteIMul64Reg")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #171
  {DBGFIELD("WriteIMul64Imm")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #172
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 158, 9,  2, 1,  1, 2}, // #173
  {DBGFIELD("WriteIMul8")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #174
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #175
  {DBGFIELD("WriteFShuffle")      1, false, false, false, 474, 8,  1, 1,  0, 0}, // #176
  {DBGFIELD("WriteVecLogicX")     1, false, false, false, 30, 3,  1, 1,  0, 0}, // #177
  {DBGFIELD("WriteShuffle")       1, false, false, false, 474, 8,  1, 1,  0, 0}, // #178
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, false,  8, 4,  1, 1,  0, 0}, // #179
  {DBGFIELD("WriteVecLoadX")      1, false, false, false, 37, 3,  3, 1,  0, 0}, // #180
  {DBGFIELD("WriteLDMXCSR")       3, false, false, false, 482, 11,  6, 1,  0, 0}, // #181
  {DBGFIELD("WriteFLD0")          1, false, false, false,  3, 5,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteFLD1")          2, false, false, false, 330, 5,  1, 1,  0, 0}, // #183
  {DBGFIELD("WriteLEA")           1, false, false, false, 154, 4,  1, 1,  0, 0}, // #184
  {DBGFIELD("WriteFence")         1, false, false, false, 493, 5,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteLZCNTLd")       2, false, false, false, 158, 9,  2, 1,  0, 0}, // #186
  {DBGFIELD("WriteLZCNT")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecStoreX")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #188
  {DBGFIELD("WriteVecStore")      2, false, false, false, 33, 4,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, false, 40, 9, 13, 1,  0, 0}, // #190
  {DBGFIELD("WriteVecLoad")       1, false, false, false, 37, 3, 14, 1,  0, 0}, // #191
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #192
  {DBGFIELD("WriteVecMoveX")      1, false, false, false, 30, 3,  1, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecStoreNT")    2, false, false, false, 33, 4,  1, 1,  0, 0}, // #194
  {DBGFIELD("WriteVecMove")       1, false, false, false,  3, 5,  1, 1,  0, 0}, // #195
  {DBGFIELD("WriteVecALULd")      2, false, false, false, 498, 7,  3, 1,  0, 0}, // #196
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #197
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 2, false, false, false, 498, 7,  3, 1,  3, 1}, // #198
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 2, false, false, false, 498, 7,  3, 1,  3, 1}, // #199
  {DBGFIELD("WriteVecLogic")      1, false, false, false,  3, 5,  1, 1,  0, 0}, // #200
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, false, 505, 10,  2, 1,  3, 1}, // #201
  {DBGFIELD("WritePHAdd")         3, false, false, false, 515, 8,  5, 1,  0, 0}, // #202
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #203
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 2, false, false, false, 523, 8, 13, 1,  6, 1}, // #204
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #205
  {DBGFIELD("WriteVecIMul")       1, false, false, false, 40, 9, 14, 1,  0, 0}, // #206
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, false, 40, 9, 13, 1,  0, 0}, // #207
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 2, false, false, false, 464, 10,  2, 1,  3, 1}, // #208
  {DBGFIELD("WritePSADBW")        1, false, false, false, 474, 8,  5, 1,  0, 0}, // #209
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #210
  {DBGFIELD("WriteVarShuffle")    1, false, false, false, 474, 8,  1, 1,  0, 0}, // #211
  {DBGFIELD("WriteShuffleLd")     2, false, false, false, 464, 10,  3, 1,  0, 0}, // #212
  {DBGFIELD("WriteVecShiftImm")   1, false, false, false, 40, 9,  1, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 2, false, false, false, 69, 11,  3, 1,  3, 1}, // #214
  {DBGFIELD("WriteVecShift")      1, false, false, false, 40, 9,  1, 1,  0, 0}, // #215
  {DBGFIELD("WriteFMoveX")        1, false, false, false, 30, 3,  1, 1,  0, 0}, // #216
  {DBGFIELD("WriteFShuffleLd")    2, false, false, false, 464, 10,  6, 1,  0, 0}, // #217
  {DBGFIELD("WriteFStore")        2, false, false, false, 33, 4,  1, 1,  0, 0}, // #218
  {DBGFIELD("WriteFMOVMSK")       1, false, false, false, 40, 9, 13, 1,  0, 0}, // #219
  {DBGFIELD("WriteVecLoadNT")     1, false, false, false, 37, 3,  3, 1,  0, 0}, // #220
  {DBGFIELD("WriteStoreNT")       2, false, false, false, 33, 4,  1, 1,  0, 0}, // #221
  {DBGFIELD("WriteFStoreNTX")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #222
  {DBGFIELD("WriteFStoreNT")      2, false, false, false, 33, 4,  1, 1,  0, 0}, // #223
  {DBGFIELD("WriteFLoad")         1, false, false, false, 37, 3, 14, 1,  0, 0}, // #224
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 3, false, false, false, 531, 10,  7, 1,  5, 1}, // #225
  {DBGFIELD("WriteMPSAD")         2, false, false, false, 523, 8,  8, 1,  0, 0}, // #226
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1,  5, 1}, // #227
  {DBGFIELD("WriteFMul64X")       1, false, false, false, 65, 4,  8, 1,  0, 0}, // #228
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1,  5, 1}, // #229
  {DBGFIELD("WriteFMulX")         1, false, false, false, 65, 4,  8, 1,  0, 0}, // #230
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 2, false, false, false, 59, 6,  9, 1,  3, 1}, // #231
  {DBGFIELD("WriteFMul64")        1, false, false, false, 65, 4,  8, 1,  0, 0}, // #232
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 2, false, false, false, 59, 6,  9, 1,  3, 1}, // #233
  {DBGFIELD("WriteFMul")          1, false, false, false, 65, 4,  8, 1,  0, 0}, // #234
  {DBGFIELD("WriteMULX32Ld")      4, false, false, false, 420, 11,  2, 1,  0, 0}, // #235
  {DBGFIELD("WriteMULX32")        3, false, false, false, 431, 9,  5, 1,  0, 0}, // #236
  {DBGFIELD("WriteIMulHLd_WriteMULX32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 5, false, false, false, 420, 11, 26, 2,  1, 1}, // #237
  {DBGFIELD("WriteIMulH_WriteMULX32") 4, false, false, false, 431, 9, 28, 2,  0, 0}, // #238
  {DBGFIELD("WriteMULX64Ld")      3, false, false, false, 440, 13,  2, 1,  0, 0}, // #239
  {DBGFIELD("WriteMULX64")        2, false, false, false, 453, 11,  5, 1,  0, 0}, // #240
  {DBGFIELD("WriteIMulHLd_WriteMULX64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 4, false, false, false, 440, 13, 26, 2,  1, 1}, // #241
  {DBGFIELD("WriteIMulH_WriteMULX64") 3, false, false, false, 453, 11, 28, 2,  0, 0}, // #242
  {DBGFIELD("WriteFMulLd")        2, false, false, false, 59, 6,  9, 1,  0, 0}, // #243
  {DBGFIELD("WriteVecALUXLd")     2, false, false, false, 59, 6,  6, 1,  0, 0}, // #244
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #245
  {DBGFIELD("WriteShuffleX")      1, false, false, false, 474, 8,  1, 1,  0, 0}, // #246
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 2, false, false, false, 60, 5,  6, 1,  5, 1}, // #247
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 3, false, false, false, 140, 5,  2, 1,  5, 1}, // #248
  {DBGFIELD("WriteVarBlend")      2, false, false, false, 145, 3, 13, 1,  0, 0}, // #249
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #250
  {DBGFIELD("WriteBlend")         1, false, false, false, 474, 8,  1, 1,  0, 0}, // #251
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 2, false, false, false, 464, 10, 23, 1,  5, 1}, // #252
  {DBGFIELD("WriteCLMul")         1, false, false, false, 474, 8,  3, 1,  0, 0}, // #253
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 9, false, false, false, 541, 14, 30, 1,  5, 1}, // #254
  {DBGFIELD("WritePCmpEStrI")     8, false, false, false, 555, 12, 31, 1,  0, 0}, // #255
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 10, false, false, false, 567, 14, 11, 1,  5, 1}, // #256
  {DBGFIELD("WritePCmpEStrM")     9, false, false, false, 581, 12, 20, 1,  0, 0}, // #257
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 4, false, false, false, 593, 11, 19, 1,  5, 1}, // #258
  {DBGFIELD("WritePCmpIStrI")     3, false, false, false, 604, 9,  7, 1,  0, 0}, // #259
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 4, false, false, false, 593, 11, 19, 1,  5, 1}, // #260
  {DBGFIELD("WritePCmpIStrM")     3, false, false, false, 604, 9,  7, 1,  0, 0}, // #261
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 2, false, false, false, 158, 9,  2, 1,  5, 1}, // #262
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 4, false, false, false, 613, 10,  9, 1,  5, 1}, // #263
  {DBGFIELD("WritePHAddX")        3, false, false, false, 623, 8,  5, 1,  0, 0}, // #264
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, false, 59, 6,  7, 1,  0, 0}, // #265
  {DBGFIELD("WritePHMINPOS")      1, false, false, false, 65, 4,  8, 1,  0, 0}, // #266
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 2, false, false, false, 158, 9,  9, 1,  5, 1}, // #267
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6, 18, 1,  5, 1}, // #268
  {DBGFIELD("WriteVecIMulX")      1, false, false, false, 65, 4, 14, 1,  0, 0}, // #269
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, false, 40, 9, 13, 1,  0, 0}, // #270
  {DBGFIELD("WriteShuffleXLd")    2, false, false, false, 464, 10,  6, 1,  0, 0}, // #271
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 3, false, false, false, 631, 6, 19, 1,  5, 1}, // #272
  {DBGFIELD("WritePMULLD")        2, false, false, false, 637, 4,  7, 1,  0, 0}, // #273
  {DBGFIELD("WriteCopy")          2, false, false, false, 641, 5,  3, 1,  0, 0}, // #274
  {DBGFIELD("WritePOPCNTLd")      2, false, false, false, 158, 9,  2, 1,  0, 0}, // #275
  {DBGFIELD("WritePOPCNT")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #276
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #277
  {DBGFIELD("WritePSADBWX")       1, false, false, false, 474, 8,  5, 1,  0, 0}, // #278
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #279
  {DBGFIELD("WriteVarShuffleX")   1, false, false, false, 474, 8,  1, 1,  0, 0}, // #280
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, false, 65, 4,  1, 1,  0, 0}, // #281
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  6, 1,  5, 1}, // #282
  {DBGFIELD("WriteVecShiftX")     2, false, false, false, 646, 9, 13, 1,  0, 0}, // #283
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 3, false, false, false, 655, 14,  9, 1,  5, 1}, // #284
  {DBGFIELD("WriteVecTest")       2, false, false, false, 313, 12,  5, 1,  0, 0}, // #285
  {DBGFIELD("WriteRotateLd_WriteRMW") 3, false, false, false, 167, 8, 32, 2,  0, 0}, // #286
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 5, false, false, false, 669, 8, 34, 2,  0, 0}, // #287
  {DBGFIELD("WriteRotate")        1, false, false, false,  8, 4,  1, 1,  0, 0}, // #288
  {DBGFIELD("WriteRotateCL")      3, false, false, false, 677, 4,  5, 1,  0, 0}, // #289
  {DBGFIELD("WriteFRcpXLd")       2, false, false, false, 69, 11,  7, 1,  0, 0}, // #290
  {DBGFIELD("WriteFRcpX")         1, false, false, false, 40, 9,  8, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRcpLd")        2, false, false, false, 69, 11,  9, 1,  0, 0}, // #292
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 2, false, false, false, 69, 11,  9, 1,  3, 1}, // #293
  {DBGFIELD("WriteFRcp")          1, false, false, false, 40, 9,  8, 1,  0, 0}, // #294
  {DBGFIELD("WriteRMW")           1, false, false, false, 33, 4,  1, 1,  0, 0}, // #295
  {DBGFIELD("WriteShiftLd")       2, false, false, false, 20, 6,  3, 1,  0, 0}, // #296
  {DBGFIELD("WriteShift")         1, false, false, false,  8, 4,  1, 1,  0, 0}, // #297
  {DBGFIELD("WriteFRndLd")        3, false, false, false, 631, 6, 10, 1,  0, 0}, // #298
  {DBGFIELD("WriteFRnd")          2, false, false, false, 637, 4,  2, 1,  0, 0}, // #299
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 3, false, false, false, 631, 6, 10, 1,  5, 1}, // #300
  {DBGFIELD("WriteFRsqrtXLd")     2, false, false, false, 69, 11,  7, 1,  0, 0}, // #301
  {DBGFIELD("WriteFRsqrtX")       1, false, false, false, 40, 9,  8, 1,  0, 0}, // #302
  {DBGFIELD("WriteFRsqrtLd")      2, false, false, false, 69, 11,  9, 1,  0, 0}, // #303
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 2, false, false, false, 69, 11,  9, 1,  3, 1}, // #304
  {DBGFIELD("WriteFRsqrt")        1, false, false, false, 40, 9,  8, 1,  0, 0}, // #305
  {DBGFIELD("WriteShiftLd_WriteRMW") 3, false, false, false, 167, 8, 32, 2,  0, 0}, // #306
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 5, false, false, false, 669, 8, 34, 2,  0, 0}, // #307
  {DBGFIELD("WriteShiftCL")       3, false, false, false, 677, 4,  5, 1,  0, 0}, // #308
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 20, 6,  3, 1,  1, 1}, // #309
  {DBGFIELD("WriteSETCCStore")    3, false, false, false, 681, 7, 13, 1,  0, 0}, // #310
  {DBGFIELD("WriteSETCC")         1, false, false, false,  8, 4,  1, 1,  0, 0}, // #311
  {DBGFIELD("WriteSHDmrcl")       6, false, false, false, 688, 11, 18, 1,  0, 0}, // #312
  {DBGFIELD("WriteSHDmri")        4, false, false, false, 699, 9,  9, 1,  0, 0}, // #313
  {DBGFIELD("WriteSHDrrcl")       4, false, false, false, 708, 9,  3, 1,  0, 0}, // #314
  {DBGFIELD("WriteFSqrt64XLd")    2, false, false, false, 717, 12, 30, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrt64X")      1, false, false, false, 729, 10, 31, 1,  0, 0}, // #316
  {DBGFIELD("WriteFSqrtXLd")      2, false, false, false, 250, 12, 31, 1,  0, 0}, // #317
  {DBGFIELD("WriteFSqrtX")        1, false, false, false, 228, 10, 23, 1,  0, 0}, // #318
  {DBGFIELD("WriteFSqrt64Ld")     2, false, false, false, 717, 12, 36, 1,  0, 0}, // #319
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 2, false, false, false, 717, 12, 36, 1,  3, 1}, // #320
  {DBGFIELD("WriteFSqrt64")       1, false, false, false, 729, 10, 31, 1,  0, 0}, // #321
  {DBGFIELD("WriteFSqrtLd")       2, false, false, false, 250, 12, 17, 1,  0, 0}, // #322
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 2, false, false, false, 250, 12, 17, 1,  3, 1}, // #323
  {DBGFIELD("WriteFSqrt")         1, false, false, false, 228, 10, 23, 1,  0, 0}, // #324
  {DBGFIELD("WriteFSqrt80")       1, false, false, false, 739, 10, 37, 1,  0, 0}, // #325
  {DBGFIELD("WriteSTMXCSR")       3, false, false, false, 302, 11, 13, 1,  0, 0}, // #326
  {DBGFIELD("WriteTZCNTLd")       2, false, false, false, 158, 9,  2, 1,  0, 0}, // #327
  {DBGFIELD("WriteTZCNT")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #328
  {DBGFIELD("WriteFMAZLd")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #329
  {DBGFIELD("WriteFMALd")         2, false, false, false, 59, 6,  9, 1,  0, 0}, // #330
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1,  7, 1}, // #331
  {DBGFIELD("WriteFAdd64Y")       1, false, false, false, 65, 4,  8, 1,  0, 0}, // #332
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteFAdd64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1,  7, 1}, // #335
  {DBGFIELD("WriteFAddY")         1, false, false, false, 65, 4,  8, 1,  0, 0}, // #336
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD("WriteFAddZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  2, 1,  7, 1}, // #339
  {DBGFIELD("WriteShuffleY")      1, false, false, false, 474, 8,  1, 1,  0, 0}, // #340
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD("WriteShuffleZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 2, false, false, false, 60, 5,  2, 1,  7, 1}, // #343
  {DBGFIELD("WriteFLogicY")       1, false, false, false, 30, 3,  1, 1,  0, 0}, // #344
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #345
  {DBGFIELD("WriteFLogicZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #346
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 3, false, false, false, 140, 5,  9, 1,  7, 1}, // #347
  {DBGFIELD("WriteFVarBlendY")    2, false, false, false, 145, 3, 13, 1,  0, 0}, // #348
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #349
  {DBGFIELD("WriteFVarBlendZ")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 2, false, false, false, 60, 5,  2, 1,  7, 1}, // #351
  {DBGFIELD("WriteFBlendY")       1, false, false, false, 30, 3,  1, 1,  0, 0}, // #352
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 3, false, false, false, 140, 5,  9, 1,  8, 2}, // #353
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, false, 140, 5,  2, 1, 10, 2}, // #354
  {DBGFIELD("WriteShuffle256Ld")  2, false, false, false, 464, 10,  7, 1,  0, 0}, // #355
  {DBGFIELD("WriteShuffle256")    1, false, false, false, 474, 8,  5, 1,  0, 0}, // #356
  {DBGFIELD("WriteShuffleYLd")    2, false, false, false, 464, 10,  2, 1,  0, 0}, // #357
  {DBGFIELD("WriteFShuffle256")   1, false, false, false, 474, 8,  5, 1,  0, 0}, // #358
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, false, 464, 10,  7, 1,  0, 0}, // #359
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1,  7, 1}, // #360
  {DBGFIELD("WriteFCmp64Y")       1, false, false, false, 65, 4,  8, 1,  0, 0}, // #361
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1,  7, 1}, // #362
  {DBGFIELD("WriteFCmpY")         1, false, false, false, 65, 4,  8, 1,  0, 0}, // #363
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #364
  {DBGFIELD("WriteFCmpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("WriteVarShuffle256Ld") 2, false, false, false, 464, 10,  7, 1,  0, 0}, // #366
  {DBGFIELD("WriteVarShuffle256") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #367
  {DBGFIELD("WriteCvtI2PDYLd")    2, false, false, false, 158, 9,  9, 1,  0, 0}, // #368
  {DBGFIELD("WriteCvtI2PDY")      1, false, false, false, 26, 7,  8, 1,  0, 0}, // #369
  {DBGFIELD("WriteCvtI2PDZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #370
  {DBGFIELD("WriteCvtI2PDZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #371
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, false, 158, 9,  9, 1,  0, 0}, // #372
  {DBGFIELD("WriteCvtI2PSY")      1, false, false, false, 26, 7,  8, 1,  0, 0}, // #373
  {DBGFIELD("WriteCvtI2PSZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #374
  {DBGFIELD("WriteCvtI2PSZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 2, false, false, false, 158, 9,  2, 1,  5, 1}, // #376
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 2, false, false, false, 158, 9,  2, 1,  7, 1}, // #377
  {DBGFIELD("WriteCvtPD2PSY")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #378
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtPD2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteCvtPD2PSYLd")   2, false, false, false, 158, 9,  2, 1,  0, 0}, // #381
  {DBGFIELD("WriteCvtPD2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #382
  {DBGFIELD("WriteCvtPD2IYLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #383
  {DBGFIELD("WriteCvtPD2IY")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #384
  {DBGFIELD("WriteCvtPD2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #385
  {DBGFIELD("WriteCvtPD2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2IY")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2PDYLd")   2, false, false, false, 158, 9,  2, 1,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PDY")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PDZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PDZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtPH2PSYLd")   2, false, false, false, 59, 6,  7, 1,  0, 0}, // #395
  {DBGFIELD("WriteCvtPH2PSY")     2, false, false, false, 646, 9,  6, 1,  0, 0}, // #396
  {DBGFIELD("WriteCvtPH2PSLd")    2, false, false, false, 59, 6,  9, 1,  0, 0}, // #397
  {DBGFIELD("WriteCvtPH2PS")      2, false, false, false, 749, 8, 14, 1,  0, 0}, // #398
  {DBGFIELD("WriteCvtPH2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteCvtPH2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #400
  {DBGFIELD("WriteCvtPS2PHYSt")   4, false, false, false, 757, 12,  2, 1,  0, 0}, // #401
  {DBGFIELD("WriteCvtPS2PHY")     2, false, false, false, 646, 9,  6, 1,  0, 0}, // #402
  {DBGFIELD("WriteCvtPS2PHSt")    4, false, false, false, 757, 12,  3, 1,  0, 0}, // #403
  {DBGFIELD("WriteCvtPS2PH")      2, false, false, false, 749, 8, 14, 1,  0, 0}, // #404
  {DBGFIELD("WriteCvtPS2PHZSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteCvtPS2PHZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #406
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #407
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #408
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #409
  {DBGFIELD("WritePSADBWY")       1, false, false, false, 474, 8,  5, 1,  0, 0}, // #410
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #411
  {DBGFIELD("WritePSADBWZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #412
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 2, false, false, false, 769, 12, 37, 1,  7, 1}, // #413
  {DBGFIELD("WriteFDiv64Y")       1, false, false, false, 781, 10, 10, 1,  0, 0}, // #414
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD("WriteFDiv64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 2, false, false, false, 238, 12, 31, 1,  7, 1}, // #417
  {DBGFIELD("WriteFDivY")         1, false, false, false, 781, 10, 18, 1,  0, 0}, // #418
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WriteFDivZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #420
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1,  5, 1}, // #421
  {DBGFIELD("WriteFMAX")          1, false, false, false, 65, 4,  8, 1,  0, 0}, // #422
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1,  7, 1}, // #423
  {DBGFIELD("WriteFMAY")          1, false, false, false, 65, 4,  8, 1,  0, 0}, // #424
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteFMAZ")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #426
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 5, false, false, false, 282, 11, 12, 1,  7, 1}, // #427
  {DBGFIELD("WriteDPPSY")         4, false, false, false, 293, 9, 22, 1,  0, 0}, // #428
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #429
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1, 12, 2}, // #430
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1, 14, 2}, // #431
  {DBGFIELD("WriteFMALd_ReadAfterVecLd") 2, false, false, false, 59, 6,  9, 1,  3, 1}, // #432
  {DBGFIELD("WriteFMA")           1, false, false, false, 65, 4,  8, 1,  0, 0}, // #433
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 2, false, false, false, 59, 6,  9, 1, 16, 2}, // #434
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1,  8, 2}, // #435
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1, 10, 2}, // #436
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 2, false, false, false, 59, 6,  9, 1,  3, 2}, // #437
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 3, false, false, false, 631, 6, 21, 1,  7, 1}, // #438
  {DBGFIELD("WriteFRndY")         2, false, false, false, 637, 4,  2, 1,  0, 0}, // #439
  {DBGFIELD("WriteLoad_WriteVecMaskedGatherWriteback") 1, false, false, false, 37, 3, 38, 2,  0, 0}, // #440
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteFRndZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6, 23, 1,  7, 1}, // #443
  {DBGFIELD("WriteVecIMulY")      1, false, false, false, 65, 4, 14, 1,  0, 0}, // #444
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #445
  {DBGFIELD("WriteVecIMulZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #446
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6,  2, 1,  7, 1}, // #447
  {DBGFIELD("WriteVecALUY")       1, false, false, false, 65, 4,  1, 1,  0, 0}, // #448
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("WriteVecALUZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #450
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 4, false, false, false, 335, 11, 22, 1,  7, 1}, // #451
  {DBGFIELD("WriteFHAddY")        3, false, false, false, 346, 9,  3, 1,  0, 0}, // #452
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #453
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #454
  {DBGFIELD("WriteVecLoadY")      1, false, false, false, 37, 3,  6, 1,  0, 0}, // #455
  {DBGFIELD("WriteFMaskedStore64Y") 2, false, false, false, 791, 10, 13, 1,  0, 0}, // #456
  {DBGFIELD("WriteFMaskedLoadY")  2, false, false, false, 60, 5,  2, 1,  0, 0}, // #457
  {DBGFIELD("WriteFMaskedStore64") 2, false, false, false, 791, 10, 13, 1,  0, 0}, // #458
  {DBGFIELD("WriteFMaskedLoad")   2, false, false, false, 60, 5,  6, 1,  0, 0}, // #459
  {DBGFIELD("WriteFMaskedStore32Y") 2, false, false, false, 791, 10, 13, 1,  0, 0}, // #460
  {DBGFIELD("WriteFMaskedStore32") 2, false, false, false, 791, 10, 13, 1,  0, 0}, // #461
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #462
  {DBGFIELD("WriteFCmp64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #463
  {DBGFIELD("WriteFMoveY")        1, false, false, false, 30, 3,  1, 1,  0, 0}, // #464
  {DBGFIELD("WriteFMoveZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #465
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, false, 464, 10,  2, 1,  0, 0}, // #466
  {DBGFIELD("WriteFShuffleY")     1, false, false, false, 474, 8,  1, 1,  0, 0}, // #467
  {DBGFIELD("WriteFShuffleZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteFShuffleZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #469
  {DBGFIELD("WriteVecStoreY")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #470
  {DBGFIELD("WriteVecMoveY")      1, false, false, false, 30, 3,  1, 1,  0, 0}, // #471
  {DBGFIELD("WriteVecMoveZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #472
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, false, 37, 3,  6, 1,  0, 0}, // #473
  {DBGFIELD("WriteVecStoreNTY")   2, false, false, false, 33, 4,  1, 1,  0, 0}, // #474
  {DBGFIELD("WriteFStoreNTY")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #475
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 3, false, false, false, 531, 10, 18, 1,  7, 1}, // #476
  {DBGFIELD("WriteMPSADY")        2, false, false, false, 523, 8,  8, 1,  0, 0}, // #477
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1,  7, 1}, // #478
  {DBGFIELD("WriteFMul64Y")       1, false, false, false, 65, 4,  8, 1,  0, 0}, // #479
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteFMul64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1,  7, 1}, // #482
  {DBGFIELD("WriteFMulY")         1, false, false, false, 65, 4,  8, 1,  0, 0}, // #483
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #484
  {DBGFIELD("WriteFMulZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #485
  {DBGFIELD("WriteVecALUYLd")     2, false, false, false, 59, 6,  2, 1,  0, 0}, // #486
  {DBGFIELD("WriteVecALUZLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 2, false, false, false, 60, 5,  2, 1,  7, 1}, // #488
  {DBGFIELD("WriteVecLogicY")     1, false, false, false, 30, 3,  1, 1,  0, 0}, // #489
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteVecLogicZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  2, 1,  7, 1}, // #492
  {DBGFIELD("WriteBlendY")        1, false, false, false, 474, 8,  1, 1,  0, 0}, // #493
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 3, false, false, false, 140, 5,  2, 1,  7, 1}, // #494
  {DBGFIELD("WriteVarBlendY")     2, false, false, false, 145, 3, 13, 1,  0, 0}, // #495
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteVarBlendZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 3, false, false, false, 140, 5,  2, 1,  8, 2}, // #498
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, false, 140, 5,  2, 1, 10, 2}, // #499
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 464, 10,  2, 1,  8, 2}, // #500
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  2, 1, 12, 2}, // #501
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 464, 10,  6, 1, 10, 2}, // #502
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  6, 1, 14, 2}, // #503
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #504
  {DBGFIELD("WriteFVarShuffle256") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #505
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 464, 10,  2, 1,  8, 2}, // #506
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  2, 1, 12, 2}, // #507
  {DBGFIELD("WriteFVarShuffleY")  1, false, false, false, 474, 8,  1, 1,  0, 0}, // #508
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 464, 10,  6, 1, 10, 2}, // #509
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  6, 1, 14, 2}, // #510
  {DBGFIELD("WriteFVarShuffle")   1, false, false, false, 474, 8,  1, 1,  0, 0}, // #511
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  2, 1,  7, 1}, // #512
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #513
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #514
  {DBGFIELD("WriteFVarShuffleZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #515
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 4, false, false, false, 613, 10,  7, 1,  7, 1}, // #516
  {DBGFIELD("WritePHAddY")        3, false, false, false, 623, 8,  5, 1,  0, 0}, // #517
  {DBGFIELD("WriteVecInsert")     2, false, false, false, 523, 8, 13, 1,  0, 0}, // #518
  {DBGFIELD("WriteVecIMulXLd")    2, false, false, false, 59, 6, 18, 1,  0, 0}, // #519
  {DBGFIELD("WriteVecIMulYLd")    2, false, false, false, 59, 6, 23, 1,  0, 0}, // #520
  {DBGFIELD("WriteVecIMulZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #521
  {DBGFIELD("WriteVecMaskedStore32Y") 2, false, false, false, 791, 10, 13, 1,  0, 0}, // #522
  {DBGFIELD("WriteVecMaskedLoadY") 2, false, false, false, 60, 5,  2, 1,  0, 0}, // #523
  {DBGFIELD("WriteVecMaskedStore32") 2, false, false, false, 791, 10, 13, 1,  0, 0}, // #524
  {DBGFIELD("WriteVecMaskedLoad") 2, false, false, false, 60, 5,  6, 1,  0, 0}, // #525
  {DBGFIELD("WriteVecMaskedStore64Y") 2, false, false, false, 791, 10, 13, 1,  0, 0}, // #526
  {DBGFIELD("WriteVecMaskedStore64") 2, false, false, false, 791, 10, 13, 1,  0, 0}, // #527
  {DBGFIELD("WriteVPMOV256Ld")    2, false, false, false, 464, 10,  7, 1,  0, 0}, // #528
  {DBGFIELD("WriteVPMOV256")      1, false, false, false, 474, 8,  5, 1,  0, 0}, // #529
  {DBGFIELD("WriteVecMOVMSKY")    1, false, false, false, 40, 9, 13, 1,  0, 0}, // #530
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 3, false, false, false, 631, 6, 17, 1,  7, 1}, // #531
  {DBGFIELD("WritePMULLDY")       2, false, false, false, 637, 4,  7, 1,  0, 0}, // #532
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WritePMULLDZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #534
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 464, 10,  6, 1, 10, 2}, // #535
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  6, 1, 14, 2}, // #536
  {DBGFIELD("WriteVecShiftImmXLd") 2, false, false, false, 59, 6,  6, 1,  0, 0}, // #537
  {DBGFIELD("WriteVecShiftImmYLd") 2, false, false, false, 59, 6,  2, 1,  0, 0}, // #538
  {DBGFIELD("WriteVecShiftImmY")  1, false, false, false, 65, 4,  1, 1,  0, 0}, // #539
  {DBGFIELD("WriteVecShiftImmZLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #540
  {DBGFIELD("WriteVecShiftImmZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #541
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  6, 1,  5, 1}, // #542
  {DBGFIELD("WriteVarVecShift")   1, false, false, false, 65, 4,  1, 1,  0, 0}, // #543
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6,  2, 1,  7, 1}, // #544
  {DBGFIELD("WriteVarVecShiftY")  1, false, false, false, 65, 4,  1, 1,  0, 0}, // #545
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #546
  {DBGFIELD("WriteVarVecShiftZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #547
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  6, 1,  5, 1}, // #548
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  2, 1,  7, 1}, // #549
  {DBGFIELD("WriteVarShuffleY")   1, false, false, false, 474, 8,  1, 1,  0, 0}, // #550
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #551
  {DBGFIELD("WriteVarShuffleZ")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #552
  {DBGFIELD("WriteShuffleZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #553
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6,  2, 1,  7, 1}, // #554
  {DBGFIELD("WriteVecShiftY")     2, false, false, false, 646, 9,  8, 1,  0, 0}, // #555
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD("WriteVecShiftZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #557
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 3, false, false, false, 655, 14,  7, 1,  7, 1}, // #558
  {DBGFIELD("WriteVecTestY")      2, false, false, false, 313, 12,  5, 1,  0, 0}, // #559
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 2, false, false, false, 69, 11,  7, 1,  5, 1}, // #560
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 2, false, false, false, 69, 11, 18, 1,  7, 1}, // #561
  {DBGFIELD("WriteFRcpY")         1, false, false, false, 40, 9,  8, 1,  0, 0}, // #562
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #563
  {DBGFIELD("WriteFRcpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #564
  {DBGFIELD("WriteFRcpYLd")       2, false, false, false, 69, 11, 18, 1,  0, 0}, // #565
  {DBGFIELD("WriteFRndYLd")       3, false, false, false, 631, 6, 21, 1,  0, 0}, // #566
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 2, false, false, false, 69, 11,  7, 1,  5, 1}, // #567
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 2, false, false, false, 69, 11, 18, 1,  7, 1}, // #568
  {DBGFIELD("WriteFRsqrtY")       1, false, false, false, 40, 9,  8, 1,  0, 0}, // #569
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #570
  {DBGFIELD("WriteFRsqrtZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #571
  {DBGFIELD("WriteFRsqrtYLd")     2, false, false, false, 69, 11, 18, 1,  0, 0}, // #572
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  2, 1,  7, 1}, // #573
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #574
  {DBGFIELD("WriteFSqrt64YLd")    2, false, false, false, 801, 12, 11, 1,  0, 0}, // #575
  {DBGFIELD("WriteFSqrt64Y")      1, false, false, false, 813, 10, 31, 1,  0, 0}, // #576
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 2, false, false, false, 717, 12, 30, 1,  5, 1}, // #577
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 2, false, false, false, 801, 12, 11, 1,  7, 1}, // #578
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #579
  {DBGFIELD("WriteFSqrt64Z")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #580
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 2, false, false, false, 250, 12, 31, 1,  5, 1}, // #581
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 2, false, false, false, 717, 12, 20, 1,  7, 1}, // #582
  {DBGFIELD("WriteFSqrtY")        1, false, false, false, 729, 10, 23, 1,  0, 0}, // #583
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #584
  {DBGFIELD("WriteFSqrtZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #585
  {DBGFIELD("WriteFSqrtYLd")      2, false, false, false, 717, 12, 20, 1,  0, 0}, // #586
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 2, false, false, false, 69, 11,  9, 1,  7, 1}, // #587
  {DBGFIELD("WriteFTestY")        1, false, false, false, 40, 9, 13, 1,  0, 0}, // #588
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 2, false, false, false, 69, 11,  2, 1,  5, 1}, // #589
  {DBGFIELD("WriteFTest")         1, false, false, false, 40, 9, 13, 1,  0, 0}, // #590
  {DBGFIELD("WriteALULd_WriteRMW") 3, false, false, false, 49, 6, 32, 2,  0, 0}, // #591
  {DBGFIELD("WriteXCHG")          3, false, false, false, 280, 2, 13, 1,  0, 0}, // #592
  {DBGFIELD("COPY")               8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #593
  {DBGFIELD("XAM_F")              1, false, false, false, 40, 9, 13, 1,  0, 0}, // #594
  {DBGFIELD("LD_Frr")             1, false, false, false,  1, 2,  1, 1,  0, 0}, // #595
  {DBGFIELD("MOVSX64rr32")        1, false, false, false,  1, 2,  1, 1,  0, 0}, // #596
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 5, false, false, false, 823, 6,  2, 1,  0, 0}, // #597
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 11, false, false, false, 829, 11, 31, 1,  0, 0}, // #598
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 4, false, false, false, 167, 8,  3, 1,  0, 0}, // #599
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 6, false, false, false, 669, 8,  2, 1,  0, 0}, // #600
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #601
  {DBGFIELD("FCOMPP")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #602
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, false, 40, 9, 13, 1,  0, 0}, // #603
  {DBGFIELD("MMX_CVTPI2PSrr")     2, false, false, false, 91, 9,  3, 1,  0, 0}, // #604
  {DBGFIELD("MMX_CVTPI2PSrm")     2, false, false, false, 69, 11,  9, 1,  0, 0}, // #605
  {DBGFIELD("MMX_CVTPS2PIrr_MMX_CVTTPS2PIrr") 2, false, false, false, 749, 8, 14, 1,  0, 0}, // #606
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 2, false, false, false, 55, 4,  3, 1,  0, 0}, // #607
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #608
  {DBGFIELD("XCH_F")              15, false, false, false, 840, 15, 17, 1,  0, 0}, // #609
  {DBGFIELD("RETI16_RETI32_RETI64_IRET_IRET16_IRET32_IRET64") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #610
  {DBGFIELD("MMX_CVTPS2PIrm_MMX_CVTTPS2PIrm") 2, false, false, false, 59, 6,  9, 1,  0, 0}, // #611
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 2, false, false, false, 464, 10,  7, 1,  0, 0}, // #612
  {DBGFIELD("CVTSI642SDrm")       2, false, false, false, 158, 9,  9, 1,  0, 0}, // #613
  {DBGFIELD("CVTSI642SDrm_Int")   2, false, false, false, 158, 9,  9, 1,  3, 1}, // #614
  {DBGFIELD("CVTSI642SSrr")       3, false, false, false, 346, 9,  3, 1,  0, 0}, // #615
  {DBGFIELD("CVTSI642SSrr_Int")   3, false, false, false, 346, 9,  3, 1,  0, 0}, // #616
  {DBGFIELD("CVTSI642SSrm")       2, false, false, false, 158, 9,  9, 1,  0, 0}, // #617
  {DBGFIELD("CVTSI642SSrm_Int")   2, false, false, false, 158, 9,  9, 1,  3, 1}, // #618
  {DBGFIELD("CVTSS2SI64rr_CVTTSS2SI64rr") 3, false, false, false, 855, 12,  6, 1,  0, 0}, // #619
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 3, false, false, false, 855, 12,  6, 1,  0, 0}, // #620
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 4, false, false, false, 867, 14, 23, 1,  0, 0}, // #621
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 2, false, false, false, 98, 2, 13, 1,  0, 0}, // #622
  {DBGFIELD("LFENCE")             2, false, false, false, 98, 2, 13, 1,  0, 0}, // #623
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #624
  {DBGFIELD("LEAVE_LEAVE64")      3, false, false, false, 881, 4,  6, 1,  0, 0}, // #625
  {DBGFIELD("POP16r")             2, false, false, false, 55, 4,  3, 1,  0, 0}, // #626
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 4, false, false, false, 49, 6,  3, 1,  0, 0}, // #627
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #628
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #629
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #630
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, false,  1, 2,  1, 1,  0, 0}, // #631
  {DBGFIELD("MMX_PADDQrr_MMX_PSUBQrr") 1, false, false, false,  3, 5,  1, 1,  0, 0}, // #632
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #633
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #634
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  2, false, false, false, 33, 4,  1, 1,  0, 0}, // #635
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, false, 30, 3,  1, 1,  0, 0}, // #636
  {DBGFIELD("CLD")                3, false, false, false, 885, 7,  5, 1,  0, 0}, // #637
  {DBGFIELD("LDDQUrm")            1, false, false, false, 37, 3,  3, 1,  0, 0}, // #638
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #639
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 4, false, false, false, 49, 6,  3, 1,  0, 0}, // #640
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 8, false, false, false, 892, 11,  7, 1,  0, 0}, // #641
  {DBGFIELD("PHADDDrr_PHSUBDrr")  3, false, false, false, 623, 8,  5, 1,  0, 0}, // #642
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #643
  {DBGFIELD("MMX_PADDQrm_MMX_PSUBQrm") 2, false, false, false, 498, 7,  3, 1,  3, 1}, // #644
  {DBGFIELD("MOVDQUrm")           1, false, false, false, 37, 3,  3, 1,  0, 0}, // #645
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, false, 37, 3,  3, 1,  0, 0}, // #646
  {DBGFIELD("PADDQrm_PSUBQrm")    2, false, false, false, 60, 5,  6, 1,  5, 1}, // #647
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #648
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   2, false, false, false, 903, 4, 13, 1,  0, 0}, // #649
  {DBGFIELD("LD_F80m")            1, false, false, false, 37, 3,  6, 1,  0, 0}, // #650
  {DBGFIELD("PHADDDrm_PHSUBDrm")  4, false, false, false, 613, 10,  9, 1,  5, 1}, // #651
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 2, false, false, false, 313, 12,  5, 1,  0, 0}, // #652
  {DBGFIELD("FLDCW16m")           3, false, false, false, 907, 11,  6, 1,  0, 0}, // #653
  {DBGFIELD("ST_FP80m")           2, false, false, false, 33, 4,  1, 1,  0, 0}, // #654
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 3, false, false, false, 515, 8,  5, 1,  0, 0}, // #655
  {DBGFIELD("CMPXCHG8rm")         6, false, false, false, 12, 8,  2, 1,  0, 0}, // #656
  {DBGFIELD("INTO")               1, false, false, false,  1, 2,  4, 1,  0, 0}, // #657
  {DBGFIELD("XLAT")               1, false, false, false, 37, 3, 14, 1,  0, 0}, // #658
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 4, false, false, false, 708, 9,  3, 1,  0, 0}, // #659
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #660
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 6, false, false, false, 688, 11, 18, 1,  0, 0}, // #661
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 4, false, false, false, 699, 9,  9, 1,  0, 0}, // #662
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 3, false, false, false, 302, 11,  8, 1,  0, 0}, // #663
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 4, false, false, false, 505, 10,  2, 1,  3, 1}, // #664
  {DBGFIELD("AAD8i8")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #665
  {DBGFIELD("LOOPE")              11, false, false, false, 918, 4, 18, 1,  0, 0}, // #666
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, false, 33, 4,  1, 1,  0, 0}, // #667
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 4, false, false, false, 708, 9,  3, 1,  0, 0}, // #668
  {DBGFIELD("FNSTCW16m")          3, false, false, false, 922, 10, 13, 1,  0, 0}, // #669
  {DBGFIELD("POPA16_POPA32")      1, false, false, false, 37, 3, 14, 1,  0, 0}, // #670
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #671
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 6, false, false, false, 688, 11, 18, 1,  0, 0}, // #672
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 4, false, false, false, 699, 9,  9, 1,  0, 0}, // #673
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #674
  {DBGFIELD("CMPXCHG8rr")         5, false, false, false, 175, 4, 14, 1,  0, 0}, // #675
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80") 1, false, false, false, 40, 9, 13, 1,  0, 0}, // #676
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #677
  {DBGFIELD("AAA_AAS")            1, false, false, false,  1, 2,  4, 1,  0, 0}, // #678
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 6, false, false, false, 12, 8,  2, 1,  0, 0}, // #679
  {DBGFIELD("LOOPNE")             11, false, false, false, 918, 4, 18, 1,  0, 0}, // #680
  {DBGFIELD("PAUSE")              4, false, false, false, 932, 7,  8, 1,  0, 0}, // #681
  {DBGFIELD("CMPXCHG8B")          14, false, false, false, 939, 10, 19, 1,  0, 0}, // #682
  {DBGFIELD("DAA")                1, false, false, false,  1, 2,  4, 1,  0, 0}, // #683
  {DBGFIELD("LOOP")               7, false, false, false, 949, 9,  6, 1,  0, 0}, // #684
  {DBGFIELD("DAS")                1, false, false, false,  1, 2,  4, 1,  0, 0}, // #685
  {DBGFIELD("AAM8i8")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #686
  {DBGFIELD("STD")                6, false, false, false, 958, 7,  3, 1,  0, 0}, // #687
  {DBGFIELD("CMPXCHG16B")         19, false, false, false, 965, 15, 36, 1,  0, 0}, // #688
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, false,  1, 2,  4, 1,  0, 0}, // #689
  {DBGFIELD("FNCLEX_FXTRACT")     4, false, false, false, 300, 2,  8, 1,  0, 0}, // #690
  {DBGFIELD("POPF32_POPF64")      1, false, false, false, 37, 3, 14, 1,  0, 0}, // #691
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #692
  {DBGFIELD("RDTSC_RDTSCP")       22, false, false, false, 980, 8, 40, 1,  0, 0}, // #693
  {DBGFIELD("ENTER")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #694
  {DBGFIELD("POPF16")             1, false, false, false, 37, 3, 14, 1,  0, 0}, // #695
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #696
  {DBGFIELD("FRNDINT")            1, false, false, false,  1, 2,  4, 1,  0, 0}, // #697
  {DBGFIELD("MWAITrr_RDPMC")      10, false, false, false, 988, 11, 12, 1,  0, 0}, // #698
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, false,  1, 2,  4, 1,  0, 0}, // #699
  {DBGFIELD("FPREM")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #700
  {DBGFIELD("INSB_INSL_INSW")     8, false, false, false, 999, 15, 12, 1,  0, 0}, // #701
  {DBGFIELD("FNINIT")             15, false, false, false, 1014, 8, 41, 1,  0, 0}, // #702
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 23, false, false, false, 1022, 13, 42, 1,  0, 0}, // #703
  {DBGFIELD("FPREM1")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #704
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #705
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 23, false, false, false, 1022, 13, 42, 1,  0, 0}, // #706
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, false,  1, 2,  4, 1,  0, 0}, // #707
  {DBGFIELD("FSCALE")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #708
  {DBGFIELD("RDMSR")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #709
  {DBGFIELD("RET_RET16_RET32_RET64_LRET16_LRET32_LRET64_LRETI16_LRETI32_LRETI64") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #710
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 23, false, false, false, 1035, 13, 42, 1,  0, 0}, // #711
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 23, false, false, false, 1035, 13, 42, 1,  0, 0}, // #712
  {DBGFIELD("F2XM1")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #713
  {DBGFIELD("CPUID")              8, false, false, false, 1048, 11, 31, 1,  0, 0}, // #714
  {DBGFIELD("INT")                1, false, false, false,  1, 2,  4, 1,  0, 0}, // #715
  {DBGFIELD("INT3")               1, false, false, false,  1, 2,  4, 1,  0, 0}, // #716
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, false,  1, 2,  4, 1,  0, 0}, // #717
  {DBGFIELD("FXRSTOR_FXRSTOR64")  90, false, false, false, 1059, 15, 43, 1,  0, 0}, // #718
  {DBGFIELD("FYL2X")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #719
  {DBGFIELD("FYL2XP1")            1, false, false, false,  1, 2,  4, 1,  0, 0}, // #720
  {DBGFIELD("FPTAN")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #721
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, false,  1, 2,  4, 1,  0, 0}, // #722
  {DBGFIELD("FPATAN")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #723
  {DBGFIELD("WRMSR")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #724
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #725
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, false, 474, 8,  1, 1,  0, 0}, // #726
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 2, false, false, false, 330, 5, 13, 1,  0, 0}, // #727
  {DBGFIELD("FNOP")               1, false, false, false,  3, 5,  1, 1,  0, 0}, // #728
  {DBGFIELD("RET64")              3, false, false, false, 1074, 9,  6, 1,  0, 0}, // #729
  {DBGFIELD("CDQ_CQO")            1, false, false, false,  8, 4,  1, 1,  0, 0}, // #730
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, false,  3, 5,  1, 1,  0, 0}, // #731
  {DBGFIELD("MMX_PADDQrr")        1, false, false, false,  3, 5,  1, 1,  0, 0}, // #732
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, false, 474, 8,  1, 1,  0, 0}, // #733
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 3, false, false, false, 881, 4,  6, 1,  0, 0}, // #734
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int_VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 1, false, false, false, 40, 9, 13, 1,  0, 0}, // #735
  {DBGFIELD("CWD")                2, false, false, false, 903, 4, 13, 1,  0, 0}, // #736
  {DBGFIELD("FNSTSW16r")          2, false, false, false, 1083, 9,  5, 1,  0, 0}, // #737
  {DBGFIELD("MMX_MOVDQ2Qrr")      2, false, false, false, 330, 5, 13, 1,  0, 0}, // #738
  {DBGFIELD("PUSHFS64")           1, false, false, false,  1, 2,  4, 1,  0, 0}, // #739
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 2, false, false, false, 313, 12,  5, 1,  0, 0}, // #740
  {DBGFIELD("RCL8r1_RCL16r1_RCL32r1_RCL64r1_RCR8r1_RCR16r1_RCR32r1_RCR64r1") 3, false, false, false, 1092, 4, 13, 1,  0, 0}, // #741
  {DBGFIELD("RCR8ri_RCR16ri_RCR32ri_RCR64ri") 8, false, false, false, 1096, 9, 14, 1,  0, 0}, // #742
  {DBGFIELD("RCL8ri_RCL16ri_RCL32ri_RCL64ri") 8, false, false, false, 1096, 9,  3, 1,  0, 0}, // #743
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, false, 40, 9, 13, 1,  0, 0}, // #744
  {DBGFIELD("MOV64sr")            1, false, false, false,  1, 2,  1, 1,  0, 0}, // #745
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVSX32rm16_MOVSX32rm32_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #746
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 10, false, false, false, 1105, 9, 10, 1,  0, 0}, // #747
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 3, false, false, false, 1114, 5, 13, 1,  0, 0}, // #748
  {DBGFIELD("CLI")                1, false, false, false,  1, 2,  4, 1,  0, 0}, // #749
  {DBGFIELD("PUSHGS64")           1, false, false, false,  1, 2,  4, 1,  0, 0}, // #750
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 3, false, false, false, 302, 11,  8, 1,  0, 0}, // #751
  {DBGFIELD("CALL64pcrel32")      4, false, false, false, 1119, 7,  5, 1,  0, 0}, // #752
  {DBGFIELD("CALL64r_RVMARKER_CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 4, false, false, false, 1126, 10,  5, 1,  0, 0}, // #753
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 3, false, false, false, 302, 11, 13, 1,  0, 0}, // #754
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 3, false, false, false, 1114, 5, 13, 1,  0, 0}, // #755
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 3, false, false, false, 302, 11, 13, 1,  0, 0}, // #756
  {DBGFIELD("PUSHF16_PUSHF64")    6, false, false, false, 1136, 5, 14, 1,  0, 0}, // #757
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 2, false, false, false, 1141, 7, 13, 1,  0, 0}, // #758
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, false, 37, 3,  3, 1,  0, 0}, // #759
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #760
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #761
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #762
  {DBGFIELD("MOV16sm")            1, false, false, false,  1, 2,  1, 1,  0, 0}, // #763
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 2, false, false, false, 498, 7,  3, 1,  0, 0}, // #764
  {DBGFIELD("MMX_PALIGNRrmi")     2, false, false, false, 464, 10,  3, 1,  3, 1}, // #765
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 2, false, false, false, 498, 7,  3, 1,  3, 1}, // #766
  {DBGFIELD("LODSL_LODSQ")        1, false, false, false,  1, 2,  4, 1,  0, 0}, // #767
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, false, 37, 3,  6, 1,  0, 0}, // #768
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 1, false, false, false, 37, 3,  6, 1,  0, 0}, // #769
  {DBGFIELD("VINSERTF128rm")      2, false, false, false, 60, 5,  6, 1,  0, 0}, // #770
  {DBGFIELD("MMX_PADDQrm")        2, false, false, false, 498, 7,  3, 1,  3, 1}, // #771
  {DBGFIELD("VERRm_VERWm")        1, false, false, false,  1, 2,  4, 1,  0, 0}, // #772
  {DBGFIELD("FARJMP64m")          2, false, false, false, 1148, 9,  3, 1,  0, 0}, // #773
  {DBGFIELD("FNSTSWm")            3, false, false, false, 1157, 11,  5, 1,  0, 0}, // #774
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 4, false, false, false, 1168, 11,  3, 1,  0, 0}, // #775
  {DBGFIELD("CALL64m_RVMARKER_CALL64m_CALL64m_NT") 5, false, false, false, 1179, 11,  6, 1,  0, 0}, // #776
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 5, false, false, false, 1179, 11,  6, 1,  0, 0}, // #777
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int_VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 2, false, false, false, 69, 11,  6, 1,  3, 1}, // #778
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #779
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 5, false, false, false, 1190, 8,  6, 1,  0, 0}, // #780
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 5, false, false, false, 1198, 6,  6, 1,  0, 0}, // #781
  {DBGFIELD("FARCALL64m")         5, false, false, false, 1179, 11,  6, 1,  0, 0}, // #782
  {DBGFIELD("CVTSD2SI64rm_CVTSD2SI64rm_Int_CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 3, false, false, false, 1204, 11, 18, 1,  0, 0}, // #783
  {DBGFIELD("CVTSS2SIrm_CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 3, false, false, false, 1204, 11, 18, 1,  0, 0}, // #784
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, false, 37, 3,  6, 1,  0, 0}, // #785
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 6, false, false, false, 669, 8,  2, 1,  0, 0}, // #786
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 6, false, false, false, 12, 8,  2, 1,  1, 2}, // #787
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 2, false, false, false, 464, 10,  7, 1,  0, 0}, // #788
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 2, false, false, false, 464, 10,  9, 1,  0, 0}, // #789
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 3, false, false, false, 531, 10, 18, 1,  0, 0}, // #790
  {DBGFIELD("MUL_F32m_MUL_F64m")  2, false, false, false, 69, 11, 18, 1,  0, 0}, // #791
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 3, false, false, false, 531, 10, 22, 1,  0, 0}, // #792
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 3, false, false, false, 655, 14, 10, 1,  0, 0}, // #793
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 2, false, false, false, 69, 11, 44, 1,  0, 0}, // #794
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 3, false, false, false, 655, 14, 11, 1,  0, 0}, // #795
  {DBGFIELD("VZEROALL")           16, false, false, false, 1215, 2, 19, 1,  0, 0}, // #796
  {DBGFIELD("VZEROUPPER")         4, false, false, false,  0, 0,  0, 1,  0, 0}, // #797
  {DBGFIELD("CLC")                1, false, false, false,  0, 0,  1, 1,  0, 0}, // #798
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #799
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #800
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #801
  {DBGFIELD("PXORrr_VPXORrr")     8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #802
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #803
  {DBGFIELD("PSUBQrr")            8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #804
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #805
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #806
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #807
  {DBGFIELD("SETCCr")             8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #808
  {DBGFIELD("SETCCm")             8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #809
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 2, false, false, false, 464, 10,  3, 1,  0, 0}, // #810
  {DBGFIELD("RETI16_RETI32_RETI64") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #811
  {DBGFIELD("LRETI16_LRETI32_LRETI64") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #812
  {DBGFIELD("RDPMC")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #813
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #814
  {DBGFIELD("FBLDm")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #815
  {DBGFIELD("FFREE_FFREEP")       1, false, false, false,  1, 2,  4, 1,  0, 0}, // #816
  {DBGFIELD("FSAVEm")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #817
  {DBGFIELD("FRSTORm")            1, false, false, false,  1, 2,  4, 1,  0, 0}, // #818
  {DBGFIELD("FXTRACT")            1, false, false, false,  1, 2,  4, 1,  0, 0}, // #819
  {DBGFIELD("MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #820
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #821
  {DBGFIELD("VBROADCASTF128")     1, false, false, false, 37, 3,  6, 1,  0, 0}, // #822
  {DBGFIELD("VBROADCASTI128")     1, false, false, false, 37, 3,  6, 1,  0, 0}, // #823
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, false, 37, 3,  6, 1,  0, 0}, // #824
  {DBGFIELD("FBSTPm")             2, false, false, false, 33, 4,  1, 1,  0, 0}, // #825
  {DBGFIELD("VMPTRSTm")           2, false, false, false, 33, 4,  1, 1,  0, 0}, // #826
  {DBGFIELD("ST_FP32m_ST_FP64m")  2, false, false, false, 33, 4,  1, 1,  0, 0}, // #827
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #828
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #829
  {DBGFIELD("MMX_MOVQ2DQrr")      2, false, false, false, 523, 8, 13, 1,  0, 0}, // #830
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false, false, 1217, 7,  1, 1,  0, 0}, // #831
  {DBGFIELD("FINCSTP")            1, false, false, false,  3, 5,  1, 1,  0, 0}, // #832
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false, false, 154, 4,  1, 1,  0, 0}, // #833
  {DBGFIELD("VPBLENDDYrri")       1, false, false, false, 30, 3,  1, 1,  0, 0}, // #834
  {DBGFIELD("VPBLENDDrri")        1, false, false, false, 30, 3,  1, 1,  0, 0}, // #835
  {DBGFIELD("CMC_STC")            1, false, false, false,  1, 2,  1, 1,  0, 0}, // #836
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #837
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 2, false, false, false, 59, 6,  9, 1,  0, 0}, // #838
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 2, false, false, false, 59, 6,  6, 1,  5, 1}, // #839
  {DBGFIELD("CVTSS2SDrm")         2, false, false, false, 59, 6,  7, 1,  0, 0}, // #840
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 2, false, false, false, 59, 6,  7, 1,  0, 0}, // #841
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 2, false, false, false, 59, 6,  2, 1,  7, 1}, // #842
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #843
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 2, false, false, false, 464, 10,  3, 1,  0, 0}, // #844
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 2, false, false, false, 464, 10,  2, 1,  0, 0}, // #845
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 2, false, false, false, 1148, 9,  3, 1,  0, 0}, // #846
  {DBGFIELD("ANDN32rm_ANDN64rm")  2, false, false, false, 148, 6,  3, 1,  0, 0}, // #847
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 2, false, false, false, 148, 6,  3, 1,  0, 0}, // #848
  {DBGFIELD("VINSERTI128rm")      2, false, false, false, 60, 5,  6, 1,  0, 0}, // #849
  {DBGFIELD("VPBLENDDrmi")        2, false, false, false, 60, 5,  6, 1,  0, 0}, // #850
  {DBGFIELD("VPBLENDDYrmi")       2, false, false, false, 60, 5,  2, 1,  0, 0}, // #851
  {DBGFIELD("POP32r_POP64r")      2, false, false, false, 55, 4,  3, 1,  0, 0}, // #852
  {DBGFIELD("SFENCE")             2, false, false, false, 23, 3, 13, 1,  0, 0}, // #853
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 3, false, false, false, 1224, 7, 13, 1,  0, 0}, // #854
  {DBGFIELD("MOVBE16mr")          3, false, false, false, 1224, 7, 13, 1,  0, 0}, // #855
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 3, false, false, false, 1114, 5, 13, 1,  0, 0}, // #856
  {DBGFIELD("MFENCE")             3, false, false, false, 88, 3,  5, 1,  0, 0}, // #857
  {DBGFIELD("XGETBV")             2, false, false, false, 98, 2, 13, 1,  0, 0}, // #858
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 2, false, false, false, 749, 8, 14, 1,  0, 0}, // #859
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 2, false, false, false, 749, 8, 14, 1,  0, 0}, // #860
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm_MMX_PACKUSWBrm") 3, false, false, false, 531, 10,  6, 1,  0, 0}, // #861
  {DBGFIELD("LRET64_RET32")       2, false, false, false, 20, 6,  3, 1,  0, 0}, // #862
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 2, false, false, false, 1231, 4, 13, 1,  0, 0}, // #863
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #864
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, false, 65, 4,  8, 1,  0, 0}, // #865
  {DBGFIELD("VCVTDQ2PSYrr")       1, false, false, false, 65, 4,  8, 1,  0, 0}, // #866
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #867
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 2, false, false, false, 59, 6,  7, 1,  0, 0}, // #868
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, false, 59, 6, 18, 1,  0, 0}, // #869
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 2, false, false, false, 59, 6, 18, 1,  0, 0}, // #870
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 2, false, false, false, 464, 10,  9, 1,  0, 0}, // #871
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr_MMX_PACKUSWBrr") 3, false, false, false, 1235, 8,  5, 1,  0, 0}, // #872
  {DBGFIELD("CLDEMOTE")           3, false, false, false, 885, 7,  5, 1,  0, 0}, // #873
  {DBGFIELD("CVTSD2SI64rr_CVTSD2SIrr_CVTTSD2SI64rr_CVTTSD2SIrr_VCVTSD2SI64rr_VCVTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, false, 1243, 9,  3, 1,  0, 0}, // #874
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 2, false, false, false, 1243, 9,  3, 1,  0, 0}, // #875
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, false, 1243, 9,  3, 1,  0, 0}, // #876
  {DBGFIELD("CVTSS2SIrr_CVTTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 3, false, false, false, 855, 12,  6, 1,  0, 0}, // #877
  {DBGFIELD("VCVTPS2PDYrr")       2, false, false, false, 646, 9,  6, 1,  0, 0}, // #878
  {DBGFIELD("MMX_CVTPI2PDrr")     2, false, false, false, 313, 12, 14, 1,  0, 0}, // #879
  {DBGFIELD("MMX_CVTPD2PIrr_MMX_CVTTPD2PIrr") 2, false, false, false, 749, 8, 14, 1,  0, 0}, // #880
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 2, false, false, false, 313, 12, 14, 1,  0, 0}, // #881
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 2, false, false, false, 749, 8, 14, 1,  0, 0}, // #882
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 2, false, false, false, 749, 8, 14, 1,  0, 0}, // #883
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 2, false, false, false, 749, 8, 14, 1,  0, 0}, // #884
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, false, 749, 8, 14, 1,  0, 0}, // #885
  {DBGFIELD("CVTSI2SSrr")         2, false, false, false, 749, 8, 14, 1,  0, 0}, // #886
  {DBGFIELD("CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 2, false, false, false, 749, 8, 14, 1,  0, 0}, // #887
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, false, 749, 8, 14, 1,  0, 0}, // #888
  {DBGFIELD("VCVTSD2SI64rm_VCVTSD2SI64rm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 3, false, false, false, 1204, 11, 18, 1,  0, 0}, // #889
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int") 3, false, false, false, 1204, 11, 18, 1,  0, 0}, // #890
  {DBGFIELD("VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, false, 1204, 11, 18, 1,  0, 0}, // #891
  {DBGFIELD("VCVTPS2PDYrm")       2, false, false, false, 59, 6, 18, 1,  0, 0}, // #892
  {DBGFIELD("CVTPD2PSrm")         3, false, false, false, 1252, 11, 18, 1,  0, 0}, // #893
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIrm_MMX_CVTTPD2PIrm") 3, false, false, false, 1252, 11, 18, 1,  0, 0}, // #894
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 3, false, false, false, 655, 14, 18, 1,  0, 0}, // #895
  {DBGFIELD("MMX_CVTPI2PDrm")     3, false, false, false, 655, 14,  7, 1,  0, 0}, // #896
  {DBGFIELD("CVTSD2SSrm")         3, false, false, false, 1252, 11,  7, 1,  0, 0}, // #897
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_VCVTSD2SSrm_Int") 3, false, false, false, 1252, 11,  7, 1,  0, 0}, // #898
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 2, false, false, false, 464, 10,  2, 1,  0, 0}, // #899
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 4, false, false, false, 1263, 11,  8, 1,  0, 0}, // #900
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 5, false, false, false, 1274, 13,  9, 1,  0, 0}, // #901
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, false, 40, 9,  8, 1,  0, 0}, // #902
  {DBGFIELD("VPCMPGTQYrm")        2, false, false, false, 464, 10,  7, 1,  0, 0}, // #903
  {DBGFIELD("VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, false, 346, 9,  3, 1,  0, 0}, // #904
  {DBGFIELD("STR16r_STR32r_STR64r") 3, false, false, false, 1287, 11, 14, 1,  0, 0}, // #905
  {DBGFIELD("XSETBV")             5, false, false, false, 1298, 4, 14, 1,  0, 0}, // #906
  {DBGFIELD("VCVTDQ2PDYrr")       2, false, false, false, 313, 12,  6, 1,  0, 0}, // #907
  {DBGFIELD("VCVTPD2PSYrr")       2, false, false, false, 646, 9,  6, 1,  0, 0}, // #908
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 2, false, false, false, 646, 9,  6, 1,  0, 0}, // #909
  {DBGFIELD("VCVTDQ2PDYrm")       3, false, false, false, 655, 14, 22, 1,  0, 0}, // #910
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 10, false, false, false, 1302, 11, 21, 1,  0, 0}, // #911
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 7, false, false, false, 1313, 9, 18, 1,  0, 0}, // #912
  {DBGFIELD("RCL8rCL")            9, false, false, false, 1322, 9, 18, 1,  0, 0}, // #913
  {DBGFIELD("RDTSC")              8, false, false, false, 1048, 11, 31, 1,  0, 0}, // #914
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 31, false, false, false, 1331, 13, 45, 1,  0, 0}, // #915
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, false, 40, 9, 12, 1,  0, 0}, // #916
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 2, false, false, false, 69, 11, 46, 1,  0, 0}, // #917
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 3, false, false, false, 655, 14, 47, 1,  0, 0}, // #918
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, false, 40, 9, 21, 1,  0, 0}, // #919
  {DBGFIELD("XSAVE64")            39, false, false, false, 1344, 11, 48, 1,  0, 0}, // #920
  {DBGFIELD("XSAVE")              40, false, false, false, 1355, 11, 40, 1,  0, 0}, // #921
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 44, false, false, false, 1366, 11, 49, 1,  0, 0}, // #922
  {DBGFIELD("VMCLEARm")           18, false, false, false, 1377, 17, 50, 1,  0, 0}, // #923
  {DBGFIELD("FLDENVm")            64, false, false, false, 1394, 11, 51, 1,  0, 0}, // #924
  {DBGFIELD("FXRSTOR64")          88, false, false, false, 1405, 15, 43, 1,  0, 0}, // #925
  {DBGFIELD("FSTENVm")            100, false, false, false, 1420, 17, 52, 1,  0, 0}, // #926
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm") 5, false, false, false, 1437, 14, 31, 1,  0, 0}, // #927
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 5, false, false, false, 1451, 14, 12, 1,  0, 0}, // #928
  {DBGFIELD("VGATHERDPSrm_VPGATHERDDrm") 5, false, false, false, 1451, 14, 12, 1,  0, 0}, // #929
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 5, false, false, false, 1465, 14, 44, 1,  0, 0}, // #930
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 5, false, false, false, 1437, 14, 31, 1,  0, 0}, // #931
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm_VGATHERQPSYrm_VPGATHERQDYrm") 5, false, false, false, 1451, 14, 12, 1,  0, 0}, // #932
  {DBGFIELD("VGATHERQPSrm_VPGATHERQDrm") 5, false, false, false, 1437, 14, 31, 1,  0, 0}, // #933
  {DBGFIELD("VPXORYrr")           8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #934
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #935
  {DBGFIELD("VPCMPGTQYrr")        8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #936
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false, false,  8, 4,  1, 1,  0, 0}, // #937
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 2, false, false, false, 903, 4, 13, 1,  0, 0}, // #938
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 2, false, false, false, 464, 10,  2, 1,  0, 0}, // #939
  {DBGFIELD("LRET64")             3, false, false, false, 1074, 9,  6, 1,  0, 0}, // #940
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 2, false, false, false, 59, 6,  7, 1,  0, 0}, // #941
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 3, false, false, false, 1252, 11, 18, 1,  0, 0}, // #942
  {DBGFIELD("POPF64")             1, false, false, false, 37, 3, 14, 1,  0, 0}, // #943
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 5, false, false, false, 1451, 14, 12, 1,  0, 0}, // #944
  {DBGFIELD("PCMPEQQrr")          1, false, false, false, 65, 4,  1, 1,  0, 0}, // #945
  {DBGFIELD("PCMPEQQrm")          2, false, false, false, 59, 6,  6, 1,  5, 1}, // #946
  {DBGFIELD("MOV16rm")            1, false, false, false, 37, 3, 14, 1,  0, 0}, // #947
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #948
  {DBGFIELD("POP16rmm")           4, false, false, false, 49, 6,  3, 1,  0, 0}, // #949
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 4, false, false, false, 49, 6,  3, 1,  0, 0}, // #950
  {DBGFIELD("PUSHF16")            6, false, false, false, 1136, 5, 14, 1,  0, 0}, // #951
  {DBGFIELD("LAHF")               1, false, false, false,  8, 4,  1, 1,  0, 0}, // #952
  {DBGFIELD("ADD16mi_ADD16mi8_ADD32mi_ADD32mi8_ADD64mi32_ADD64mi8_ADD8mi_ADD8mi8_SUB16mi_SUB16mi8_SUB32mi_SUB32mi8_SUB64mi32_SUB64mi8_SUB8mi_SUB8mi8") 3, false, false, false, 49, 6,  6, 1,  0, 0}, // #953
  {DBGFIELD("ADD16mr_ADD32mr_ADD64mr_ADD8mr_SUB16mr_SUB32mr_SUB64mr_SUB8mr") 3, false, false, false, 49, 6,  6, 1,  1, 1}, // #954
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 6, false, false, false, 12, 8,  2, 1,  0, 0}, // #955
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 3, false, false, false, 49, 6,  6, 1,  0, 0}, // #956
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 4, false, false, false, 1126, 10,  5, 1,  0, 0}, // #957
  {DBGFIELD("RET16_LRET16_LRET32") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #958
  {DBGFIELD("IRET16_IRET32_IRET64") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #959
  {DBGFIELD("AND16mi_AND16mi8_AND32mi_AND32mi8_AND64mi32_AND64mi8_AND8mi_AND8mi8_OR16mi_OR16mi8_OR32mi_OR32mi8_OR32mi8Locked_OR64mi32_OR64mi8_OR8mi_OR8mi8_XOR16mi_XOR16mi8_XOR32mi_XOR32mi8_XOR64mi32_XOR64mi8_XOR8mi_XOR8mi8") 3, false, false, false, 49, 6,  6, 1,  0, 0}, // #960
  {DBGFIELD("AND16mr_AND32mr_AND64mr_AND8mr_OR16mr_OR32mr_OR64mr_OR8mr_XOR16mr_XOR32mr_XOR64mr_XOR8mr") 3, false, false, false, 49, 6,  6, 1,  1, 1}, // #961
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 4, false, false, false, 699, 9,  9, 1,  0, 0}, // #962
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 4, false, false, false, 708, 9,  3, 1,  0, 0}, // #963
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 6, false, false, false, 688, 11, 18, 1,  0, 0}, // #964
  {DBGFIELD("MOVSLDUPrm")         1, false, false, false, 37, 3,  3, 1,  0, 0}, // #965
  {DBGFIELD("MOVSLDUPrr")         1, false, false, false, 474, 8,  1, 1,  0, 0}, // #966
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 3, false, false, false, 280, 2, 13, 1,  0, 0}, // #967
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, false, 40, 9,  1, 1,  0, 0}, // #968
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #969
  {DBGFIELD("VPBLENDWYrri")       1, false, false, false, 474, 8,  1, 1,  0, 0}, // #970
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #971
  {DBGFIELD("VPBLENDWYrmi")       2, false, false, false, 464, 10,  2, 1,  7, 1}, // #972
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #973
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #974
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #975
  {DBGFIELD("VPMASKMOVDYrm")      2, false, false, false, 60, 5,  2, 1,  0, 0}, // #976
  {DBGFIELD("VPMASKMOVDrm")       2, false, false, false, 60, 5,  6, 1,  0, 0}, // #977
  {DBGFIELD("VPMASKMOVDYmr")      2, false, false, false, 791, 10, 13, 1,  0, 0}, // #978
  {DBGFIELD("VPMASKMOVDmr")       2, false, false, false, 791, 10, 13, 1,  0, 0}, // #979
  {DBGFIELD("VPMASKMOVQYmr")      2, false, false, false, 791, 10, 13, 1,  0, 0}, // #980
  {DBGFIELD("VPMASKMOVQmr")       2, false, false, false, 791, 10, 13, 1,  0, 0}, // #981
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 2, false, false, false, 464, 10,  6, 1,  0, 0}, // #982
  {DBGFIELD("VPGATHERDDYrm")      5, false, false, false, 1465, 14, 44, 1,  0, 0}, // #983
  {DBGFIELD("VPGATHERDDrm")       5, false, false, false, 1451, 14, 12, 1,  0, 0}, // #984
  {DBGFIELD("VPGATHERDQYrm")      5, false, false, false, 1451, 14, 12, 1,  0, 0}, // #985
  {DBGFIELD("VPGATHERDQrm")       5, false, false, false, 1437, 14, 31, 1,  0, 0}, // #986
  {DBGFIELD("VPGATHERQDYrm")      5, false, false, false, 1451, 14, 12, 1,  0, 0}, // #987
  {DBGFIELD("VPGATHERQDrm")       5, false, false, false, 1437, 14, 31, 1,  0, 0}, // #988
  {DBGFIELD("VPGATHERQQYrm")      5, false, false, false, 1451, 14, 12, 1,  0, 0}, // #989
  {DBGFIELD("VPGATHERQQrm")       5, false, false, false, 1437, 14, 31, 1,  0, 0}, // #990
  {DBGFIELD("PSLLDQri_PSRLDQri_VPSLLDQri_VPSRLDQri") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #991
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #992
  {DBGFIELD("VPERM2F128rr")       1, false, false, false, 474, 8,  5, 1,  0, 0}, // #993
  {DBGFIELD("VPERM2F128rm")       2, false, false, false, 464, 10,  7, 1,  7, 1}, // #994
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, false, 474, 8,  5, 1,  0, 0}, // #995
  {DBGFIELD("VEXTRACTF128mr")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #996
  {DBGFIELD("VINSERTF128rr")      1, false, false, false, 474, 8,  5, 1,  0, 0}, // #997
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #998
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #999
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 3, false, false, false, 855, 12,  6, 1,  0, 0}, // #1000
  {DBGFIELD("VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, false, 1204, 11, 18, 1,  0, 0}, // #1001
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1002
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1003
  {DBGFIELD("SHA256MSG2rm")       2, false, false, false, 59, 6, 18, 1,  5, 1}, // #1004
  {DBGFIELD("SHA256MSG2rr")       1, false, false, false, 65, 4, 14, 1,  0, 0}, // #1005
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, false, 65, 4, 14, 1,  0, 0}, // #1006
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 2, false, false, false, 59, 6, 18, 1,  5, 1}, // #1007
  {DBGFIELD("SHA1MSG2rr")         1, false, false, false, 65, 4, 14, 1,  0, 0}, // #1008
  {DBGFIELD("SHA1MSG2rm")         2, false, false, false, 59, 6, 18, 1,  5, 1}, // #1009
  {DBGFIELD("SHA1NEXTErr")        1, false, false, false, 65, 4, 14, 1,  0, 0}, // #1010
  {DBGFIELD("SHA1NEXTErm")        2, false, false, false, 59, 6, 18, 1,  5, 1}, // #1011
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, false, 65, 4, 14, 1,  0, 0}, // #1012
  {DBGFIELD("SHA1RNDS4rmi")       2, false, false, false, 59, 6, 18, 1,  5, 1}, // #1013
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, false, 65, 4, 14, 1,  0, 0}, // #1014
  {DBGFIELD("SHA256RNDS2rm")      2, false, false, false, 59, 6, 18, 1,  5, 1}, // #1015
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 3, false, false, false, 280, 2, 13, 1,  0, 0}, // #1016
  {DBGFIELD("BT16mi8_BT32mi8_BT64mi8") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #1017
  {DBGFIELD("BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 1, false, false, false,  8, 4,  1, 1,  0, 0}, // #1018
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, false, 65, 4,  8, 1,  0, 0}, // #1019
  {DBGFIELD("MOV8rm_MOV8rm_NOREX") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1020
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVZX16rm16") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1021
  {DBGFIELD("MOVBE16rm")          2, false, false, false, 148, 6,  3, 1,  0, 0}, // #1022
  {DBGFIELD("ADD8i8_ADD16i16_ADD32i32_ADD64i32_AND8i8_AND16i16_AND32i32_AND64i32_OR8i8_OR16i16_OR32i32_OR64i32_SUB8i8_SUB16i16_SUB32i32_SUB64i32_XOR8i8_XOR16i16_XOR32i32_XOR64i32") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1023
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32_MOVZX16rr16") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1024
  {DBGFIELD("MOV32ri_MOV32ri_alt_MOV64ri32") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1025
  {DBGFIELD("ADC8mr_SBB8mr")      6, false, false, false, 12, 8,  2, 1,  1, 2}, // #1026
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1027
  {DBGFIELD("LEA16r")             1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1028
  {DBGFIELD("LCMPXCHG8")          6, false, false, false, 12, 8,  2, 1,  0, 0}, // #1029
  {DBGFIELD("LCMPXCHG16B")        6, false, false, false, 12, 8,  2, 1,  0, 0}, // #1030
  {DBGFIELD("XCHG8rr_XCHG16rr_XCHG16ar") 3, false, false, false, 280, 2, 13, 1,  0, 0}, // #1031
  {DBGFIELD("XCHG8rm_XCHG16rm")   8, false, false, false, 892, 11,  7, 1,  0, 0}, // #1032
  {DBGFIELD("POPCNT16rr")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1033
  {DBGFIELD("LZCNT16rr")          1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1034
  {DBGFIELD("TZCNT16rr")          1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1035
  {DBGFIELD("RCL8m1_RCL16m1_RCL32m1_RCL64m1_RCR8m1_RCR16m1_RCR32m1_RCR64m1") 5, false, false, false, 823, 6,  2, 1,  0, 0}, // #1036
  {DBGFIELD("RCR8mi_RCR16mi_RCR32mi_RCR64mi") 5, false, false, false, 823, 6,  2, 1,  0, 0}, // #1037
  {DBGFIELD("RCR16rCL_RCR32rCL_RCR64rCL") 7, false, false, false, 1313, 9, 18, 1,  0, 0}, // #1038
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #1039
  {DBGFIELD("VEXTRACTI128rr")     1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1040
  {DBGFIELD("VEXTRACTI128mr")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #1041
  {DBGFIELD("MMX_MOVQ2FR64rr")    1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1042
  {DBGFIELD("MMX_MOVD64rr_MMX_MOVD64to64rr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1043
  {DBGFIELD("EXTRQ")              1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1044
  {DBGFIELD("INSERTQ")            1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1045
  {DBGFIELD("PABSBrr_PABSDrr_PABSWrr_PADDSBrr_PADDSWrr_PADDUSBrr_PADDUSWrr_PAVGBrr_PAVGWrr_PSIGNBrr_PSIGNDrr_PSIGNWrr_VPABSBrr_VPABSDrr_VPABSWrr_VPADDSBrr_VPADDSWrr_VPADDUSBrr_VPADDUSWrr_VPAVGBrr_VPAVGWrr_VPCMPEQQrr_VPSIGNBrr_VPSIGNDrr_VPSIGNWrr_PSUBSBrr_PSUBSWrr_PSUBUSBrr_PSUBUSWrr_VPSUBSBrr_VPSUBSWrr_VPSUBUSBrr_VPSUBUSWrr") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1046
  {DBGFIELD("MMX_PADDSBrr_MMX_PADDSWrr_MMX_PADDUSBrr_MMX_PADDUSWrr_MMX_PAVGBrr_MMX_PAVGWrr_MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false, 40, 9,  1, 1,  0, 0}, // #1047
  {DBGFIELD("VPABSBYrr_VPABSDYrr_VPABSWYrr_VPADDSBYrr_VPADDSWYrr_VPADDUSBYrr_VPADDUSWYrr_VPSUBSBYrr_VPSUBSWYrr_VPSUBUSBYrr_VPSUBUSWYrr_VPAVGBYrr_VPAVGWYrr_VPCMPEQQYrr_VPSIGNBYrr_VPSIGNDYrr_VPSIGNWYrr") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1048
  {DBGFIELD("SHA1MSG1rr")         1, false, false, false, 65, 4, 14, 1,  0, 0}, // #1049
  {DBGFIELD("SHA1MSG1rm")         2, false, false, false, 59, 6, 18, 1,  5, 1}, // #1050
  {DBGFIELD("VPERM2I128rr")       1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1051
  {DBGFIELD("VPERMPSYrr")         1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1052
  {DBGFIELD("VPERMPSYrm")         2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1053
  {DBGFIELD("VPERMPDYri")         1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1054
  {DBGFIELD("VPERMQYri")          1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1055
  {DBGFIELD("VPERMPDYmi")         2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1056
  {DBGFIELD("VPERMDYrr")          1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1057
  {DBGFIELD("VPERMQYmi")          2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1058
  {DBGFIELD("VPERMDYrm")          2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1059
  {DBGFIELD("MOV32rr_MOV32rr_REV_MOV64rr_MOV64rr_REV") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1060
  {DBGFIELD("MOVSX32rr32")        1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1061
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV_SUB32rr_REV_SUB64rr_REV") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1062
  {DBGFIELD("CMP8rr_CMP8rr_REV_CMP16rr_CMP16rr_REV_CMP32rr_CMP32rr_REV_CMP64rr_CMP64rr_REV") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1063
  {DBGFIELD("VXORPSrr_VXORPDrr")  8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1064
  {DBGFIELD("VANDNPSrr_VANDNPDrr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1065
  {DBGFIELD("VANDNPSYrr_VANDNPDYrr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1066
  {DBGFIELD("VPXORrr")            8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1067
  {DBGFIELD("VPANDNrr")           1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1068
  {DBGFIELD("VPANDNYrr")          1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1069
  {DBGFIELD("VPSUBBrr_VPSUBWrr_VPSUBDrr_VPSUBQrr_VPCMPGTBrr_VPCMPGTWrr_VPCMPGTDrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1070
  {DBGFIELD("VPCMPGTQrr")         8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1071
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #1072
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 3, false, false, false, 49, 6,  6, 1,  0, 0}, // #1073
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1074
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 2, false, false, false, 55, 4,  3, 1,  0, 0}, // #1075
  {DBGFIELD("ADC64ri32_SBB64ri32") 1, false, false, false,  8, 4,  1, 1,  0, 0}, // #1076
  {DBGFIELD("CRC32r32r16")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1077
  {DBGFIELD("CRC32r32r32")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1078
  {DBGFIELD("CRC32r64r64")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1079
  {DBGFIELD("SAHF")               1, false, false, false,  8, 4,  1, 1,  0, 0}, // #1080
  {DBGFIELD("BEXTRI32ri_BEXTRI64ri") 2, false, false, false, 134, 6, 13, 1,  0, 0}, // #1081
  {DBGFIELD("BEXTRI32mi_BEXTRI64mi") 3, false, false, false, 126, 8,  6, 1,  0, 0}, // #1082
  {DBGFIELD("RCR8ri")             8, false, false, false, 1096, 9, 14, 1,  0, 0}, // #1083
  {DBGFIELD("RCL16rCL")           7, false, false, false, 1313, 9, 18, 1,  0, 0}, // #1084
  {DBGFIELD("RCR16ri")            8, false, false, false, 1096, 9, 14, 1,  0, 0}, // #1085
  {DBGFIELD("RCR32rCL_RCR64rCL")  7, false, false, false, 1313, 9, 18, 1,  0, 0}, // #1086
  {DBGFIELD("RCL16ri")            8, false, false, false, 1096, 9,  3, 1,  0, 0}, // #1087
  {DBGFIELD("RCL32ri_RCL64ri")    8, false, false, false, 1096, 9,  3, 1,  0, 0}, // #1088
  {DBGFIELD("SHLD32rri8")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1089
  {DBGFIELD("SHRD16rri8")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1090
  {DBGFIELD("SHLD16rrCL")         4, false, false, false, 708, 9,  3, 1,  0, 0}, // #1091
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #1092
  {DBGFIELD("TST_F")              1, false, false, false, 40, 9, 13, 1,  0, 0}, // #1093
  {DBGFIELD("VDPPSrri")           4, false, false, false, 293, 9, 22, 1,  0, 0}, // #1094
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr") 2, false, false, false, 637, 4,  2, 1,  0, 0}, // #1095
  {DBGFIELD("VFRCZSDrr_VFRCZSSrr") 2, false, false, false, 637, 4,  2, 1,  0, 0}, // #1096
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 3, false, false, false, 631, 6, 10, 1,  5, 1}, // #1097
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 2, false, false, false, 637, 4,  2, 1,  0, 0}, // #1098
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 3, false, false, false, 631, 6, 21, 1,  7, 1}, // #1099
  {DBGFIELD("MMX_CVTTPD2PIrr")    2, false, false, false, 749, 8, 14, 1,  0, 0}, // #1100
  {DBGFIELD("VMOVDQUYmr")         2, false, false, false, 33, 4,  1, 1,  0, 0}, // #1101
  {DBGFIELD("MOVDQArr")           1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1102
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 2, false, false, false, 637, 4,  7, 1,  0, 0}, // #1103
  {DBGFIELD("VMPSADBWrri")        2, false, false, false, 523, 8,  8, 1,  0, 0}, // #1104
  {DBGFIELD("VPPERMrrr_VPPERMrrr_REV") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1105
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 3, false, false, false, 623, 8,  5, 1,  0, 0}, // #1106
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 4, false, false, false, 613, 10,  9, 1,  5, 1}, // #1107
  {DBGFIELD("VPCLMULQDQrr")       1, false, false, false, 474, 8,  3, 1,  0, 0}, // #1108
  {DBGFIELD("ANDNPSrr_ANDNPDrr")  1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1109
  {DBGFIELD("MMX_PXORrr_MMX_PANDNrr") 1, false, false, false,  3, 5,  1, 1,  0, 0}, // #1110
  {DBGFIELD("PANDNrr")            1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1111
  {DBGFIELD("MMX_PSUBBrr_MMX_PSUBDrr_MMX_PSUBWrr_MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false,  3, 5,  1, 1,  0, 0}, // #1112
  {DBGFIELD("LCMPXCHG16_LCMPXCHG32_LCMPXCHG64") 6, false, false, false, 12, 8,  2, 1,  0, 0}, // #1113
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 5, false, false, false, 175, 4, 14, 1,  0, 0}, // #1114
  {DBGFIELD("LCMPXCHG8B")         6, false, false, false, 12, 8,  2, 1,  0, 0}, // #1115
  {DBGFIELD("XCHG8rr")            3, false, false, false, 280, 2, 13, 1,  0, 0}, // #1116
  {DBGFIELD("MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false, 40, 9,  1, 1,  0, 0}, // #1117
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1118
  {DBGFIELD("MMX_PCMPEQBrr_MMX_PCMPEQDrr_MMX_PCMPEQWrr_MMX_PMAXSWrr_MMX_PMINSWrr_MMX_PMAXUBrr_MMX_PMINUBrr") 1, false, false, false, 40, 9,  1, 1,  0, 0}, // #1119
  {DBGFIELD("MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false, 40, 9,  1, 1,  0, 0}, // #1120
  {DBGFIELD("CLAC_STAC")          1, false, false, false,  8, 4,  1, 1,  0, 0}, // #1121
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1122
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1123
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1124
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 3, false, false, false, 1479, 12,  5, 1,  0, 0}, // #1125
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, false, 346, 9,  5, 1,  0, 0}, // #1126
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 3, false, false, false, 346, 9,  5, 1,  0, 0}, // #1127
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 1, false, false, false, 65, 4,  8, 1,  0, 0}, // #1128
  {DBGFIELD("MMX_PADDSBrm_MMX_PADDSWrm_MMX_PADDUSBrm_MMX_PADDUSWrm_MMX_PAVGBrm_MMX_PAVGWrm_MMX_PCMPEQBrm_MMX_PCMPEQDrm_MMX_PCMPEQWrm_MMX_PCMPGTBrm_MMX_PCMPGTDrm_MMX_PCMPGTWrm_MMX_PMAXSWrm_MMX_PMAXUBrm_MMX_PMINSWrm_MMX_PMINUBrm_MMX_PSUBSBrm_MMX_PSUBSWrm_MMX_PSUBUSBrm_MMX_PSUBUSWrm") 2, false, false, false, 69, 11,  3, 1,  0, 0}, // #1129
  {DBGFIELD("CVTSS2SI64rr")       2, false, false, false, 1243, 9,  3, 1,  0, 0}, // #1130
  {DBGFIELD("CVTSS2SI64rr_Int")   2, false, false, false, 1243, 9,  3, 1,  0, 0}, // #1131
  {DBGFIELD("CVTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr") 2, false, false, false, 1243, 9,  3, 1,  0, 0}, // #1132
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 2, false, false, false, 1243, 9,  3, 1,  0, 0}, // #1133
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 2, false, false, false, 60, 5,  6, 1,  5, 1}, // #1134
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 2, false, false, false, 60, 5,  2, 1,  7, 1}, // #1135
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 4, false, false, false, 1491, 14,  2, 1,  0, 0}, // #1136
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, false, 335, 11,  9, 1,  0, 0}, // #1137
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 4, false, false, false, 335, 11,  7, 1,  0, 0}, // #1138
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 40, false, false, false, 1355, 11, 40, 1,  0, 0}, // #1139
  {DBGFIELD("PCMPGTBrr_PCMPGTDrr_PCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1140
  {DBGFIELD("VPCMPGTBrr_VPCMPGTDrr_VPCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1141
  {DBGFIELD("VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1142
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1143
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1144
  {DBGFIELD("KSET0D_KSET0Q_KSET0W_KSET1D_KSET1Q_KSET1W") 1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1145
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1146
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 2, false, false, false, 145, 3, 13, 1,  0, 0}, // #1147
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 2, false, false, false, 145, 3, 13, 1,  0, 0}, // #1148
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1149
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1150
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1151
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 2, false, false, false, 145, 3, 13, 1,  0, 0}, // #1152
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 2, false, false, false, 145, 3, 13, 1,  0, 0}, // #1153
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1154
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #1155
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1156
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1157
  {DBGFIELD("VPSADBWZrr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1158
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1159
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1160
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1161
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1162
  {DBGFIELD("VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1163
  {DBGFIELD("VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1164
  {DBGFIELD("VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1165
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1166
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1167
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, false, 65, 4,  8, 1,  0, 0}, // #1168
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 1, false, false, false, 65, 4,  8, 1,  0, 0}, // #1169
  {DBGFIELD("VCMPPDZrri_VCMPPDZrrib_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrrib_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1170
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, false, 65, 4,  8, 1,  0, 0}, // #1171
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rrik_VPCMPDZ128rri_VPCMPDZ128rrik_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rrik_VPCMPUBZ128rri_VPCMPUBZ128rrik_VPCMPUDZ128rri_VPCMPUDZ128rrik_VPCMPUQZ128rri_VPCMPUQZ128rrik_VPCMPUWZ128rri_VPCMPUWZ128rrik_VPCMPWZ128rri_VPCMPWZ128rrik") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1172
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rrik_VPCMPDZ256rri_VPCMPDZ256rrik_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rrik_VPCMPUBZ256rri_VPCMPUBZ256rrik_VPCMPUDZ256rri_VPCMPUDZ256rrik_VPCMPUQZ256rri_VPCMPUQZ256rrik_VPCMPUWZ256rri_VPCMPUWZ256rrik_VPCMPWZ256rri_VPCMPWZ256rrik") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1173
  {DBGFIELD("VPCMPBZrri_VPCMPBZrrik_VPCMPDZrri_VPCMPDZrrik_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrrik_VPCMPUBZrri_VPCMPUBZrrik_VPCMPUDZrri_VPCMPUDZrrik_VPCMPUQZrri_VPCMPUQZrrik_VPCMPUWZrri_VPCMPUWZrrik_VPCMPWZrri_VPCMPWZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1174
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1175
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1176
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1177
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1178
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1179
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1180
  {DBGFIELD("VCVTPS2DQYrr")       1, false, false, false, 65, 4,  8, 1,  0, 0}, // #1181
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1182
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1183
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1184
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1185
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1186
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1187
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1188
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1189
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1190
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1191
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 2, false, false, false, 464, 10,  7, 1,  0, 0}, // #1192
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1193
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1194
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1195
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1196
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1197
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1198
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1199
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 1, false, false, false, 26, 7,  8, 1,  6, 1}, // #1200
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 1, false, false, false, 26, 7,  8, 1,  6, 1}, // #1201
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1202
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1203
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 4, false, false, false, 757, 12,  3, 1,  0, 0}, // #1204
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 4, false, false, false, 757, 12,  2, 1,  0, 0}, // #1205
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1206
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 2, false, false, false, 464, 10,  7, 1,  0, 0}, // #1207
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1208
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1209
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1210
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 1, false, false, false, 26, 7,  8, 1,  6, 1}, // #1211
  {DBGFIELD("VMOVSDZrm_VMOVSDZrm_alt_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrm_alt_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1212
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1213
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1214
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1215
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1216
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1217
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1218
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1219
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1220
  {DBGFIELD("VCVTPD2PSZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1221
  {DBGFIELD("VCVTPS2PDZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1222
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1223
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1224
  {DBGFIELD("VMOVNTDQAZ128rm")    1, false, false, false, 37, 3,  3, 1,  0, 0}, // #1225
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 3, false, false, false, 140, 5,  2, 1,  5, 1}, // #1226
  {DBGFIELD("VBROADCASTI32X2Z128rm_VBROADCASTI32X2Z128rmk_VBROADCASTI32X2Z128rmkz_VPBROADCASTDZ128rm_VPBROADCASTDZ128rmk_VPBROADCASTDZ128rmkz_VPBROADCASTQZ128rm_VPBROADCASTQZ128rmk_VPBROADCASTQZ128rmkz") 2, false, false, false, 464, 10,  6, 1,  0, 0}, // #1227
  {DBGFIELD("VBROADCASTSSZ128rm_VBROADCASTSSZ128rmk_VBROADCASTSSZ128rmkz") 2, false, false, false, 464, 10,  7, 1,  0, 0}, // #1228
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #1229
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 2, false, false, false, 464, 10,  6, 1,  0, 0}, // #1230
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #1231
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 2, false, false, false, 59, 6,  6, 1,  5, 1}, // #1232
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 3, false, false, false, 140, 5,  2, 1,  5, 1}, // #1233
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1234
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1235
  {DBGFIELD("VCVTSS2SI64rr")      2, false, false, false, 1243, 9,  3, 1,  0, 0}, // #1236
  {DBGFIELD("VCVTSS2SI64rr_Int")  2, false, false, false, 1243, 9,  3, 1,  0, 0}, // #1237
  {DBGFIELD("VCVTTSS2SI64rr")     3, false, false, false, 855, 12,  6, 1,  0, 0}, // #1238
  {DBGFIELD("VCVTTSS2SI64rr_Int") 3, false, false, false, 855, 12,  6, 1,  0, 0}, // #1239
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1240
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 2, false, false, false, 464, 10,  7, 1,  0, 0}, // #1241
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1242
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1243
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1244
  {DBGFIELD("VSCATTERDPSZmr")     1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1245
  {DBGFIELD("VPBROADCASTBZ256rm_VPBROADCASTBZ256rmk_VPBROADCASTBZ256rmkz_VPBROADCASTBZrm_VPBROADCASTBZrmk_VPBROADCASTBZrmkz_VPBROADCASTWZ256rm_VPBROADCASTWZ256rmk_VPBROADCASTWZ256rmkz_VPBROADCASTWZrm_VPBROADCASTWZrmk_VPBROADCASTWZrmkz") 2, false, false, false, 464, 10,  7, 1,  0, 0}, // #1246
  {DBGFIELD("VMOVNTDQAZ256rm")    1, false, false, false, 37, 3,  6, 1,  0, 0}, // #1247
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 3, false, false, false, 140, 5,  9, 1,  7, 1}, // #1248
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1249
  {DBGFIELD("VBROADCASTF32X2Z256rm_VBROADCASTF32X2Z256rmk_VBROADCASTF32X2Z256rmkz_VBROADCASTF32X2Zrm_VBROADCASTF32X2Zrmk_VBROADCASTF32X2Zrmkz_VBROADCASTI32X2Z256rm_VBROADCASTI32X2Z256rmk_VBROADCASTI32X2Z256rmkz_VBROADCASTI32X2Zrm_VBROADCASTI32X2Zrmk_VBROADCASTI32X2Zrmkz_VPBROADCASTDZ256rm_VPBROADCASTDZ256rmk_VPBROADCASTDZ256rmkz_VPBROADCASTDZrm_VPBROADCASTDZrmk_VPBROADCASTDZrmkz_VPBROADCASTQZ256rm_VPBROADCASTQZ256rmk_VPBROADCASTQZ256rmkz_VPBROADCASTQZrm_VPBROADCASTQZrmk_VPBROADCASTQZrmkz") 2, false, false, false, 464, 10,  7, 1,  0, 0}, // #1250
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 2, false, false, false, 464, 10,  2, 1,  0, 0}, // #1251
  {DBGFIELD("VBROADCASTSDZ256rm_VBROADCASTSDZ256rmk_VBROADCASTSDZ256rmkz_VBROADCASTSDZrm_VBROADCASTSDZrmk_VBROADCASTSDZrmkz_VBROADCASTSSZ256rm_VBROADCASTSSZ256rmk_VBROADCASTSSZ256rmkz_VBROADCASTSSZrm_VBROADCASTSSZrmk_VBROADCASTSSZrmkz") 2, false, false, false, 464, 10,  7, 1,  0, 0}, // #1252
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1253
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1254
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 1, false, false, false, 37, 3,  6, 1,  0, 0}, // #1255
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, false, 464, 10,  2, 1,  0, 0}, // #1256
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1257
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 1, false, false, false, 37, 3,  6, 1,  0, 0}, // #1258
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 2, false, false, false, 59, 6,  2, 1,  7, 1}, // #1259
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1260
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 3, false, false, false, 140, 5,  2, 1,  7, 1}, // #1261
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1262
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1263
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1264
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1265
  {DBGFIELD("VPSCATTERDDZmr")     1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1266
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #1267
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 2, false, false, false, 59, 6,  9, 1,  3, 1}, // #1268
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1269
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1270
  {DBGFIELD("VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 2, false, false, false, 59, 6,  6, 1,  5, 1}, // #1271
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmik_VFPCLASSPDZ128rm_VFPCLASSPDZ128rmb_VFPCLASSPDZ128rmbk_VFPCLASSPDZ128rmk_VFPCLASSPSZ128rm_VFPCLASSPSZ128rmb_VFPCLASSPSZ128rmbk_VFPCLASSPSZ128rmk") 2, false, false, false, 59, 6,  7, 1,  5, 1}, // #1272
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk") 2, false, false, false, 59, 6,  9, 1,  3, 1}, // #1273
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmik_VPCMPDZ128rmi_VPCMPDZ128rmib_VPCMPDZ128rmibk_VPCMPDZ128rmik_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmib_VPCMPQZ128rmibk_VPCMPQZ128rmik_VPCMPUBZ128rmi_VPCMPUBZ128rmik_VPCMPUDZ128rmi_VPCMPUDZ128rmib_VPCMPUDZ128rmibk_VPCMPUDZ128rmik_VPCMPUQZ128rmi_VPCMPUQZ128rmib_VPCMPUQZ128rmibk_VPCMPUQZ128rmik_VPCMPUWZ128rmi_VPCMPUWZ128rmik_VPCMPWZ128rmi_VPCMPWZ128rmik") 2, false, false, false, 59, 6,  6, 1,  5, 1}, // #1274
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 2, false, false, false, 60, 5,  6, 1,  5, 1}, // #1275
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 2, false, false, false, 464, 10,  2, 1,  7, 1}, // #1276
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1277
  {DBGFIELD("VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 2, false, false, false, 59, 6,  2, 1,  7, 1}, // #1278
  {DBGFIELD("VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1279
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmik_VFPCLASSPDZ256rm_VFPCLASSPDZ256rmb_VFPCLASSPDZ256rmbk_VFPCLASSPDZ256rmk_VFPCLASSPSZ256rm_VFPCLASSPSZ256rmb_VFPCLASSPSZ256rmbk_VFPCLASSPSZ256rmk") 2, false, false, false, 59, 6, 18, 1,  7, 1}, // #1280
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmik_VFPCLASSPDZrm_VFPCLASSPDZrmb_VFPCLASSPDZrmbk_VFPCLASSPDZrmk_VFPCLASSPSZrm_VFPCLASSPSZrmb_VFPCLASSPSZrmbk_VFPCLASSPSZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1281
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmik_VPCMPDZ256rmi_VPCMPDZ256rmib_VPCMPDZ256rmibk_VPCMPDZ256rmik_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmib_VPCMPQZ256rmibk_VPCMPQZ256rmik_VPCMPUBZ256rmi_VPCMPUBZ256rmik_VPCMPUDZ256rmi_VPCMPUDZ256rmib_VPCMPUDZ256rmibk_VPCMPUDZ256rmik_VPCMPUQZ256rmi_VPCMPUQZ256rmib_VPCMPUQZ256rmibk_VPCMPUQZ256rmik_VPCMPUWZ256rmi_VPCMPUWZ256rmik_VPCMPWZ256rmi_VPCMPWZ256rmik") 2, false, false, false, 59, 6,  2, 1,  7, 1}, // #1282
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmik_VPCMPDZrmi_VPCMPDZrmib_VPCMPDZrmibk_VPCMPDZrmik_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmib_VPCMPQZrmibk_VPCMPQZrmik_VPCMPUBZrmi_VPCMPUBZrmik_VPCMPUDZrmi_VPCMPUDZrmib_VPCMPUDZrmibk_VPCMPUDZrmik_VPCMPUQZrmi_VPCMPUQZrmib_VPCMPUQZrmibk_VPCMPUQZrmik_VPCMPUWZrmi_VPCMPUWZrmik_VPCMPWZrmi_VPCMPWZrmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1283
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 2, false, false, false, 60, 5,  2, 1,  7, 1}, // #1284
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1285
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 2, false, false, false, 158, 9,  9, 1,  0, 0}, // #1286
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 2, false, false, false, 158, 9,  9, 1,  0, 0}, // #1287
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #1288
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 2, false, false, false, 59, 6,  9, 1,  0, 0}, // #1289
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #1290
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #1291
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #1292
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1293
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 2, false, false, false, 158, 9,  9, 1,  0, 0}, // #1294
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1295
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, false, 158, 9,  9, 1,  0, 0}, // #1296
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1297
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 2, false, false, false, 59, 6,  7, 1,  0, 0}, // #1298
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1299
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #1300
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1301
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #1302
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1303
  {DBGFIELD("VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #1304
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1305
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1306
  {DBGFIELD("VCVTSD2SSZrm_VCVTSD2SSZrm_Int_VCVTSD2SSZrm_Intk_VCVTSD2SSZrm_Intkz") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #1307
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 2, false, false, false, 59, 6,  6, 1,  0, 0}, // #1308
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, false, 65, 4, 14, 1,  0, 0}, // #1309
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 1, false, false, false, 65, 4, 14, 1,  0, 0}, // #1310
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1311
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1312
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #1313
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #1314
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1315
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1316
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1317
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1318
  {DBGFIELD("VCVTPD2PSZrm_VCVTPD2PSZrmb_VCVTPD2PSZrmbk_VCVTPD2PSZrmbkz_VCVTPD2PSZrmk_VCVTPD2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1319
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1320
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 2, false, false, false, 464, 10,  7, 1,  7, 1}, // #1321
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 2, false, false, false, 59, 6,  6, 1,  0, 0}, // #1322
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 2, false, false, false, 59, 6, 18, 1,  5, 1}, // #1323
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 2, false, false, false, 59, 6, 23, 1,  7, 1}, // #1324
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1325
  {DBGFIELD("VGATHERQPSZ128rm_VPGATHERQDZ128rm_VGATHERDPDZ128rm_VPGATHERDQZ128rm_VGATHERQPDZ128rm_VPGATHERQQZ128rm") 1, false, false, false, 37, 3, 38, 2,  0, 0}, // #1326
  {DBGFIELD("VGATHERQPSZ256rm_VPGATHERQDZ256rm_VGATHERQPDZ256rm_VPGATHERQQZ256rm_VGATHERDPSZ128rm_VPGATHERDDZ128rm_VGATHERDPDZ256rm_VPGATHERDQZ256rm") 1, false, false, false, 37, 3, 38, 2,  0, 0}, // #1327
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm_VGATHERDPDZrm_VPGATHERDQZrm_VGATHERQPDZrm_VPGATHERQQZrm_VGATHERQPSZrm_VPGATHERQDZrm") 1, false, false, false, 37, 3, 38, 2,  0, 0}, // #1328
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 1, false, false, false, 37, 3, 38, 2,  0, 0}, // #1329
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1330
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1331
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 2, false, false, false, 59, 6,  2, 1,  0, 0}, // #1332
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1333
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1334
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 2, false, false, false, 59, 6,  2, 1,  0, 0}, // #1335
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1336
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1337
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1338
  {DBGFIELD("VXORPSZ128rr_VXORPDZ128rr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1339
  {DBGFIELD("VXORPSZ256rr_VXORPDZ256rr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1340
  {DBGFIELD("VXORPSZrr_VXORPDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1341
  {DBGFIELD("VPXORDZ128rr_VPXORQZ128rr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1342
  {DBGFIELD("VPXORDZ256rr_VPXORQZ256rr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1343
  {DBGFIELD("VPXORDZrr_VPXORQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1344
  {DBGFIELD("VPSUBBZ128rr_VPSUBDZ128rr_VPSUBQZ128rr_VPSUBWZ128rr") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1345
  {DBGFIELD("VPSUBBZ256rr_VPSUBDZ256rr_VPSUBQZ256rr_VPSUBWZ256rr") 1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1346
  {DBGFIELD("VPSUBBZrr_VPSUBDZrr_VPSUBQZrr_VPSUBWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1347
  {DBGFIELD("VPBROADCASTDrr_VPBROADCASTQrr_PALIGNRrri_VPALIGNRZ128rri_VPALIGNRZ128rrik_VPALIGNRZ128rrikz_VPALIGNRrri_PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWZ128rr_VPACKSSDWZ128rrk_VPACKSSDWZ128rrkz_VPACKSSDWrr_VPACKSSWBZ128rr_VPACKSSWBZ128rrk_VPACKSSWBZ128rrkz_VPACKSSWBrr_VPACKUSDWZ128rr_VPACKUSDWZ128rrk_VPACKUSDWZ128rrkz_VPACKUSDWrr_VPACKUSWBZ128rr_VPACKUSWBZ128rrk_VPACKUSWBZ128rrkz_VPACKUSWBrr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1348
  {DBGFIELD("INSERTPSrr_VINSERTPSZrr_VINSERTPSrr_MOVHLPSrr_MOVLHPSrr_VMOVHLPSZrr_VMOVHLPSrr_VMOVLHPSZrr_VMOVLHPSrr_MOVDDUPrr_VMOVDDUPZ128rr_VMOVDDUPZ128rrk_VMOVDDUPZ128rrkz_VMOVDDUPrr_VPERMILPDZ128ri_VPERMILPDZ128rik_VPERMILPDZ128rikz_VPERMILPDri_VPERMILPSZ128ri_VPERMILPSZ128rik_VPERMILPSZ128rikz_VPERMILPSri_UNPCKHPDrr_UNPCKHPSrr_UNPCKLPDrr_UNPCKLPSrr_VUNPCKHPDZ128rr_VUNPCKHPDZ128rrk_VUNPCKHPDZ128rrkz_VUNPCKHPDrr_VUNPCKHPSZ128rr_VUNPCKHPSZ128rrk_VUNPCKHPSZ128rrkz_VUNPCKHPSrr_VUNPCKLPDZ128rr_VUNPCKLPDZ128rrk_VUNPCKLPDZ128rrkz_VUNPCKLPDrr_VUNPCKLPSZ128rr_VUNPCKLPSZ128rrk_VUNPCKLPSZ128rrkz_VUNPCKLPSrr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1349
  {DBGFIELD("VMOVDDUPYrr_VMOVDDUPZ256rr_VMOVDDUPZ256rrk_VMOVDDUPZ256rrkz_VPERMILPDYri_VPERMILPDZ256ri_VPERMILPDZ256rik_VPERMILPDZ256rikz_VPERMILPSYri_VPERMILPSZ256ri_VPERMILPSZ256rik_VPERMILPSZ256rikz_VUNPCKHPDYrr_VUNPCKHPDZ256rr_VUNPCKHPDZ256rrk_VUNPCKHPDZ256rrkz_VUNPCKHPSYrr_VUNPCKHPSZ256rr_VUNPCKHPSZ256rrk_VUNPCKHPSZ256rrkz_VUNPCKLPDYrr_VUNPCKLPDZ256rr_VUNPCKLPDZ256rrk_VUNPCKLPDZ256rrkz_VUNPCKLPSYrr_VUNPCKLPSZ256rr_VUNPCKLPSZ256rrk_VUNPCKLPSZ256rrkz") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1350
  {DBGFIELD("VMOVDDUPZrr_VMOVDDUPZrrk_VMOVDDUPZrrkz_VPERMILPDZri_VPERMILPDZrik_VPERMILPDZrikz_VPERMILPSZri_VPERMILPSZrik_VPERMILPSZrikz_VUNPCKHPDZrr_VUNPCKHPDZrrk_VUNPCKHPDZrrkz_VUNPCKHPSZrr_VUNPCKHPSZrrk_VUNPCKHPSZrrkz_VUNPCKLPDZrr_VUNPCKLPDZrrk_VUNPCKLPDZrrkz_VUNPCKLPSZrr_VUNPCKLPSZrrk_VUNPCKLPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1351
  {DBGFIELD("VPALIGNRYrri_VPALIGNRZ256rri_VPALIGNRZ256rrik_VPALIGNRZ256rrikz_VPACKSSDWYrr_VPACKSSDWZ256rr_VPACKSSDWZ256rrk_VPACKSSDWZ256rrkz_VPACKSSWBYrr_VPACKSSWBZ256rr_VPACKSSWBZ256rrk_VPACKSSWBZ256rrkz_VPACKUSDWYrr_VPACKUSDWZ256rr_VPACKUSDWZ256rrk_VPACKUSDWZ256rrkz_VPACKUSWBYrr_VPACKUSWBZ256rr_VPACKUSWBZ256rrk_VPACKUSWBZ256rrkz") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1352
  {DBGFIELD("VPALIGNRZrri_VPALIGNRZrrik_VPALIGNRZrrikz_VPACKSSDWZrr_VPACKSSDWZrrk_VPACKSSDWZrrkz_VPACKSSWBZrr_VPACKSSWBZrrk_VPACKSSWBZrrkz_VPACKUSDWZrr_VPACKUSDWZrrk_VPACKUSDWZrrkz_VPACKUSWBZrr_VPACKUSWBZrrk_VPACKUSWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1353
  {DBGFIELD("VPERMILPDYrr_VPERMILPDZ256rr_VPERMILPDZ256rrk_VPERMILPDZ256rrkz_VPERMILPSYrr_VPERMILPSZ256rr_VPERMILPSZ256rrk_VPERMILPSZ256rrkz") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1354
  {DBGFIELD("VPERMILPDZ128rr_VPERMILPDZ128rrk_VPERMILPDZ128rrkz_VPERMILPDrr_VPERMILPSZ128rr_VPERMILPSZ128rrk_VPERMILPSZ128rrkz_VPERMILPSrr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1355
  {DBGFIELD("VPERMILPDZrr_VPERMILPDZrrk_VPERMILPDZrrkz_VPERMILPSZrr_VPERMILPSZrrk_VPERMILPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1356
  {DBGFIELD("MOVSDrr_MOVSDrr_REV_VMOVSDZrr_VMOVSDZrr_REV_VMOVSDZrrk_VMOVSDZrrk_REV_VMOVSDZrrkz_VMOVSDZrrkz_REV_VMOVSDrr_VMOVSDrr_REV_VMOVSSZrr_VMOVSSZrr_REV_VMOVSSZrrk_VMOVSSZrrk_REV_VMOVSSZrrkz_VMOVSSZrrkz_REV_VMOVSSrr_VMOVSSrr_REV") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1357
  {DBGFIELD("VPBROADCASTBZ128rm_VPBROADCASTBZ128rmk_VPBROADCASTBZ128rmkz_VPBROADCASTWZ128rm_VPBROADCASTWZ128rmk_VPBROADCASTWZ128rmkz") 2, false, false, false, 464, 10,  6, 1,  0, 0}, // #1358
  {DBGFIELD("INSERTPSrm_VINSERTPSZrm_VINSERTPSrm_UNPCKHPDrm_UNPCKHPSrm_UNPCKLPDrm_UNPCKLPSrm_VUNPCKHPDZ128rm_VUNPCKHPDZ128rmb_VUNPCKHPDZ128rmbk_VUNPCKHPDZ128rmbkz_VUNPCKHPDZ128rmk_VUNPCKHPDZ128rmkz_VUNPCKHPDrm_VUNPCKHPSZ128rm_VUNPCKHPSZ128rmb_VUNPCKHPSZ128rmbk_VUNPCKHPSZ128rmbkz_VUNPCKHPSZ128rmk_VUNPCKHPSZ128rmkz_VUNPCKHPSrm_VUNPCKLPDZ128rm_VUNPCKLPDZ128rmb_VUNPCKLPDZ128rmbk_VUNPCKLPDZ128rmbkz_VUNPCKLPDZ128rmk_VUNPCKLPDZ128rmkz_VUNPCKLPDrm_VUNPCKLPSZ128rm_VUNPCKLPSZ128rmb_VUNPCKLPSZ128rmbk_VUNPCKLPSZ128rmbkz_VUNPCKLPSZ128rmk_VUNPCKLPSZ128rmkz_VUNPCKLPSrm") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #1359
  {DBGFIELD("PALIGNRrmi_VPALIGNRZ128rmi_VPALIGNRZ128rmik_VPALIGNRZ128rmikz_VPALIGNRrmi_PACKSSDWrm_PACKSSWBrm_PACKUSDWrm_PACKUSWBrm_VPACKSSDWZ128rm_VPACKSSDWZ128rmb_VPACKSSDWZ128rmbk_VPACKSSDWZ128rmbkz_VPACKSSDWZ128rmk_VPACKSSDWZ128rmkz_VPACKSSDWrm_VPACKSSWBZ128rm_VPACKSSWBZ128rmk_VPACKSSWBZ128rmkz_VPACKSSWBrm_VPACKUSDWZ128rm_VPACKUSDWZ128rmb_VPACKUSDWZ128rmbk_VPACKUSDWZ128rmbkz_VPACKUSDWZ128rmk_VPACKUSDWZ128rmkz_VPACKUSDWrm_VPACKUSWBZ128rm_VPACKUSWBZ128rmk_VPACKUSWBZ128rmkz_VPACKUSWBrm") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #1360
  {DBGFIELD("VPERMILPDZ128mbi_VPERMILPDZ128mbik_VPERMILPDZ128mbikz_VPERMILPDZ128mi_VPERMILPDZ128mik_VPERMILPDZ128mikz_VPERMILPDmi_VPERMILPSZ128mbi_VPERMILPSZ128mbik_VPERMILPSZ128mbikz_VPERMILPSZ128mi_VPERMILPSZ128mik_VPERMILPSZ128mikz_VPERMILPSmi") 2, false, false, false, 464, 10,  6, 1,  0, 0}, // #1361
  {DBGFIELD("VPERMILPDZ128rm_VPERMILPDZ128rmb_VPERMILPDZ128rmbk_VPERMILPDZ128rmbkz_VPERMILPDZ128rmk_VPERMILPDZ128rmkz_VPERMILPDrm_VPERMILPSZ128rm_VPERMILPSZ128rmb_VPERMILPSZ128rmbk_VPERMILPSZ128rmbkz_VPERMILPSZ128rmk_VPERMILPSZ128rmkz_VPERMILPSrm") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #1362
  {DBGFIELD("VPALIGNRYrmi_VPALIGNRZ256rmi_VPALIGNRZ256rmik_VPALIGNRZ256rmikz_VPACKSSDWYrm_VPACKSSDWZ256rm_VPACKSSDWZ256rmb_VPACKSSDWZ256rmbk_VPACKSSDWZ256rmbkz_VPACKSSDWZ256rmk_VPACKSSDWZ256rmkz_VPACKSSWBYrm_VPACKSSWBZ256rm_VPACKSSWBZ256rmk_VPACKSSWBZ256rmkz_VPACKUSDWYrm_VPACKUSDWZ256rm_VPACKUSDWZ256rmb_VPACKUSDWZ256rmbk_VPACKUSDWZ256rmbkz_VPACKUSDWZ256rmk_VPACKUSDWZ256rmkz_VPACKUSWBYrm_VPACKUSWBZ256rm_VPACKUSWBZ256rmk_VPACKUSWBZ256rmkz") 2, false, false, false, 464, 10,  2, 1,  7, 1}, // #1363
  {DBGFIELD("VPALIGNRZrmi_VPALIGNRZrmik_VPALIGNRZrmikz_VPACKSSDWZrm_VPACKSSDWZrmb_VPACKSSDWZrmbk_VPACKSSDWZrmbkz_VPACKSSDWZrmk_VPACKSSDWZrmkz_VPACKSSWBZrm_VPACKSSWBZrmk_VPACKSSWBZrmkz_VPACKUSDWZrm_VPACKUSDWZrmb_VPACKUSDWZrmbk_VPACKUSDWZrmbkz_VPACKUSDWZrmk_VPACKUSDWZrmkz_VPACKUSWBZrm_VPACKUSWBZrmk_VPACKUSWBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1364
  {DBGFIELD("VPERMILPDYmi_VPERMILPDZ256mbi_VPERMILPDZ256mbik_VPERMILPDZ256mbikz_VPERMILPDZ256mi_VPERMILPDZ256mik_VPERMILPDZ256mikz_VPERMILPSYmi_VPERMILPSZ256mbi_VPERMILPSZ256mbik_VPERMILPSZ256mbikz_VPERMILPSZ256mi_VPERMILPSZ256mik_VPERMILPSZ256mikz") 2, false, false, false, 464, 10,  2, 1,  0, 0}, // #1365
  {DBGFIELD("VPERMILPDZmbi_VPERMILPDZmbik_VPERMILPDZmbikz_VPERMILPDZmi_VPERMILPDZmik_VPERMILPDZmikz_VPERMILPSZmbi_VPERMILPSZmbik_VPERMILPSZmbikz_VPERMILPSZmi_VPERMILPSZmik_VPERMILPSZmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1366
  {DBGFIELD("VPERMILPDYrm_VPERMILPDZ256rm_VPERMILPDZ256rmb_VPERMILPDZ256rmbk_VPERMILPDZ256rmbkz_VPERMILPDZ256rmk_VPERMILPDZ256rmkz_VPERMILPSYrm_VPERMILPSZ256rm_VPERMILPSZ256rmb_VPERMILPSZ256rmbk_VPERMILPSZ256rmbkz_VPERMILPSZ256rmk_VPERMILPSZ256rmkz") 2, false, false, false, 464, 10,  2, 1,  7, 1}, // #1367
  {DBGFIELD("VPERMILPDZrm_VPERMILPDZrmb_VPERMILPDZrmbk_VPERMILPDZrmbkz_VPERMILPDZrmk_VPERMILPDZrmkz_VPERMILPSZrm_VPERMILPSZrmb_VPERMILPSZrmbk_VPERMILPSZrmbkz_VPERMILPSZrmk_VPERMILPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1368
  {DBGFIELD("VUNPCKHPDYrm_VUNPCKHPDZ256rm_VUNPCKHPDZ256rmb_VUNPCKHPDZ256rmbk_VUNPCKHPDZ256rmbkz_VUNPCKHPDZ256rmk_VUNPCKHPDZ256rmkz_VUNPCKHPSYrm_VUNPCKHPSZ256rm_VUNPCKHPSZ256rmb_VUNPCKHPSZ256rmbk_VUNPCKHPSZ256rmbkz_VUNPCKHPSZ256rmk_VUNPCKHPSZ256rmkz_VUNPCKLPDYrm_VUNPCKLPDZ256rm_VUNPCKLPDZ256rmb_VUNPCKLPDZ256rmbk_VUNPCKLPDZ256rmbkz_VUNPCKLPDZ256rmk_VUNPCKLPDZ256rmkz_VUNPCKLPSYrm_VUNPCKLPSZ256rm_VUNPCKLPSZ256rmb_VUNPCKLPSZ256rmbk_VUNPCKLPSZ256rmbkz_VUNPCKLPSZ256rmk_VUNPCKLPSZ256rmkz") 2, false, false, false, 464, 10,  2, 1,  7, 1}, // #1369
  {DBGFIELD("VUNPCKHPDZrm_VUNPCKHPDZrmb_VUNPCKHPDZrmbk_VUNPCKHPDZrmbkz_VUNPCKHPDZrmk_VUNPCKHPDZrmkz_VUNPCKHPSZrm_VUNPCKHPSZrmb_VUNPCKHPSZrmbk_VUNPCKHPSZrmbkz_VUNPCKHPSZrmk_VUNPCKHPSZrmkz_VUNPCKLPDZrm_VUNPCKLPDZrmb_VUNPCKLPDZrmbk_VUNPCKLPDZrmbkz_VUNPCKLPDZrmk_VUNPCKLPDZrmkz_VUNPCKLPSZrm_VUNPCKLPSZrmb_VUNPCKLPSZrmbk_VUNPCKLPSZrmbkz_VUNPCKLPSZrmk_VUNPCKLPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1370
  {DBGFIELD("PdWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1371
  {DBGFIELD("WriteVecALU")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1372
  {DBGFIELD("JWriteZeroLatency")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1373
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1374
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1375
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1376
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1377
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1378
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1379
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1380
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1381
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1382
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1383
  {DBGFIELD("JWriteLOCK_CMPXCHG8B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1384
  {DBGFIELD("JWriteLOCK_CMPXCHG16B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1385
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1386
  {DBGFIELD("JWriteLOCK_CMPXCHGrm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1387
  {DBGFIELD("JWriteCMPXCHG8B")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1388
  {DBGFIELD("JWriteCMPXCHG16B")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1389
  {DBGFIELD("JWriteCMPXCHG8rm")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1390
  {DBGFIELD("WriteCMPXCHGRMW")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1391
  {DBGFIELD("JWriteCMPXCHG8rr")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1392
  {DBGFIELD("WriteCMPXCHG")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1393
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1394
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1395
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1396
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1397
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1398
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1399
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1400
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1401
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1402
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1403
  {DBGFIELD("JWriteLOCK_XADDrm_XCHG_Part_JWriteXCHGrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1404
  {DBGFIELD("JWriteXADDrm_XCHG_Part_JWriteXADDrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1405
  {DBGFIELD("SBWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1406
  {DBGFIELD("WriteALU")           1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1407
  {DBGFIELD("HWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1408
  {DBGFIELD("BWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1409
  {DBGFIELD("Zn3WriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1410
  {DBGFIELD("SKLWriteZeroLatency") 1, false, false, false,  0, 0,  0, 1,  0, 0}, // #1411
  {DBGFIELD("SKXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1412
  {DBGFIELD("ICXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1413
  {DBGFIELD("WriteFLogic")        1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1414
  {DBGFIELD("WriteFLogicY")       1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1415
  {DBGFIELD("JWriteZeroIdiomYmm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1416
  {DBGFIELD("WriteVecLogicX")     1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1417
  {DBGFIELD("WriteVecALUX")       1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1418
  {DBGFIELD("SKLWritePSUB")       1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1419
  {DBGFIELD("SKXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1420
  {DBGFIELD("ICXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1421
  {DBGFIELD("SBWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1422
  {DBGFIELD("HWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1423
  {DBGFIELD("BWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1424
  {DBGFIELD("SKLWritePCMPGTQ")    1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1425
  {DBGFIELD("SKXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1426
  {DBGFIELD("ICXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1427
  {DBGFIELD("SBWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1428
  {DBGFIELD("WriteCMOV")          1, false, false, false,  8, 4,  1, 1,  0, 0}, // #1429
  {DBGFIELD("HWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1430
  {DBGFIELD("BWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1431
  {DBGFIELD("SKLWriteCMOVA_CMOVBErr") 2, false, false, false, 1231, 4, 13, 1,  0, 0}, // #1432
  {DBGFIELD("SKXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1433
  {DBGFIELD("ICXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1434
  {DBGFIELD("SBWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1435
  {DBGFIELD("WriteCMOVLd")        2, false, false, false, 20, 6,  3, 1,  0, 0}, // #1436
  {DBGFIELD("HWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1437
  {DBGFIELD("BWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1438
  {DBGFIELD("PdWriteCMOVm")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1439
  {DBGFIELD("SKLWriteCMOVA_CMOVBErm") 3, false, false, false, 1505, 6,  6, 1,  0, 0}, // #1440
  {DBGFIELD("SKXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1441
  {DBGFIELD("ICXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1442
  {DBGFIELD("SBWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1443
  {DBGFIELD("WriteSETCC")         1, false, false, false,  8, 4,  1, 1,  0, 0}, // #1444
  {DBGFIELD("HWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1445
  {DBGFIELD("BWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1446
  {DBGFIELD("SKLWriteSETA_SETBEr") 2, false, false, false, 1231, 4, 13, 1,  0, 0}, // #1447
  {DBGFIELD("SKXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1448
  {DBGFIELD("ICXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1449
  {DBGFIELD("SBWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1450
  {DBGFIELD("WriteSETCCStore")    3, false, false, false, 681, 7, 13, 1,  0, 0}, // #1451
  {DBGFIELD("HWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1452
  {DBGFIELD("BWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1453
  {DBGFIELD("PdWriteSETGEmSETGmSETLEmSETLm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1454
  {DBGFIELD("SKLWriteSETA_SETBEm") 4, false, false, false, 1511, 7,  5, 1,  0, 0}, // #1455
  {DBGFIELD("SKXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1456
  {DBGFIELD("ICXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1457
  {DBGFIELD("WriteVecLogicY")     1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1458
  {DBGFIELD("WriteVecALUY")       1, false, false, false, 65, 4,  1, 1,  0, 0}, // #1459
  {DBGFIELD("HWWriteADC0")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1460
  {DBGFIELD("WriteADC")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1461
  {DBGFIELD("JWriteLOCK_ALURMW")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1462
  {DBGFIELD("WriteALURMW")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1463
  {DBGFIELD("WriteFShuffle256")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1464
  {DBGFIELD("Zn3Write3OpsLEA")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1465
  {DBGFIELD("WriteLEA")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1466
  {DBGFIELD("PdWrite3OpsLEA")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1467
  {DBGFIELD("JWrite3OpsLEA")      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1468
  {DBGFIELD("WriteVecLogic")      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1469
  {DBGFIELD("WriteFLogicZ")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1470
  {DBGFIELD("WriteVecLogicZ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1471
}; // SkylakeClientModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc AtomModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, false, 40, 1,  1, 1,  0, 0}, // #3
  {DBGFIELD("WriteJump")          1, false, false, false, 1518, 2,  1, 1,  0, 0}, // #4
  {DBGFIELD("WriteCMPXCHGRMW")    1, false, false, false, 1520, 2,  1, 1,  0, 0}, // #5
  {DBGFIELD("WriteJumpLd")        1, false, false, false, 1518, 2,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteMove")          1, false, false, false, 40, 1,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, false, 40, 1,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteADC")           1, false, false, false, 40, 1,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteSHDrri")        1, false, false, false, 80, 1, 13, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreX")       1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteFLoadX")        1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #12
  {DBGFIELD("WriteFStoreY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #13
  {DBGFIELD("WriteFLoadY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #14
  {DBGFIELD("WriteMicrocoded")    1, false, false, false, 40, 1,  4, 1,  0, 0}, // #15
  {DBGFIELD("WriteFSign")         1, false, false, false, 1518, 2,  1, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCRMW")        1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #17
  {DBGFIELD("WriteADCRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, false, 1522, 2,  1, 1, 18, 2}, // #18
  {DBGFIELD("WriteADCLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 1522, 2,  1, 1, 20, 2}, // #19
  {DBGFIELD("WriteALURMW")        1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #20
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 1522, 2,  1, 1, 18, 1}, // #21
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #22
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 4, false, false, false, 1524, 3,  6, 1, 20, 1}, // #23
  {DBGFIELD("WriteFAdd64X")       3, false, false, false, 1527, 3,  3, 1,  0, 0}, // #24
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 1, false, false, false, 1530, 3, 14, 1, 20, 1}, // #25
  {DBGFIELD("WriteFAddX")         1, false, false, false, 1518, 2, 14, 1,  0, 0}, // #26
  {DBGFIELD("WriteNop")           1, false, false, false, 40, 1,  1, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 1, false, false, false, 1530, 3, 14, 1, 20, 1}, // #28
  {DBGFIELD("WriteFAdd64")        1, false, false, false, 1518, 2, 14, 1,  0, 0}, // #29
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 1, false, false, false, 1530, 3, 14, 1, 20, 1}, // #30
  {DBGFIELD("WriteFAdd")          1, false, false, false, 1518, 2, 14, 1,  0, 0}, // #31
  {DBGFIELD("WriteFAddLd")        1, false, false, false, 1530, 3, 14, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #33
  {DBGFIELD("WriteAESDecEnc")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #34
  {DBGFIELD("WriteAESIMCLd")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #35
  {DBGFIELD("WriteAESIMC")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #36
  {DBGFIELD("WriteAESKeyGenLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #37
  {DBGFIELD("WriteAESKeyGen")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #38
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #39
  {DBGFIELD("WriteFLogic")        1, false, false, false, 40, 1,  1, 1,  0, 0}, // #40
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #41
  {DBGFIELD("WriteBEXTR")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #42
  {DBGFIELD("WriteBEXTRLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #43
  {DBGFIELD("WriteALULd")         1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #44
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #45
  {DBGFIELD("WriteFBlend")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #46
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #47
  {DBGFIELD("WriteFVarBlend")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #48
  {DBGFIELD("WriteBLSLd")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #49
  {DBGFIELD("WriteBLS")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #50
  {DBGFIELD("WriteBSFLd")         10, false, false, false, 1533, 3, 19, 1,  0, 0}, // #51
  {DBGFIELD("WriteBSF")           10, false, false, false, 1533, 3, 19, 1,  0, 0}, // #52
  {DBGFIELD("WriteBSRLd")         10, false, false, false, 1533, 3, 19, 1,  0, 0}, // #53
  {DBGFIELD("WriteBSR")           10, false, false, false, 1533, 3, 19, 1,  0, 0}, // #54
  {DBGFIELD("WriteBSWAP32")       1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #55
  {DBGFIELD("WriteBSWAP64")       1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #56
  {DBGFIELD("WriteBitTestImmLd")  1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #57
  {DBGFIELD("WriteBitTestRegLd")  1, false, false, false, 1420, 1,  9, 1,  0, 0}, // #58
  {DBGFIELD("WriteBitTest")       1, false, false, false, 1518, 2,  1, 1,  0, 0}, // #59
  {DBGFIELD("WriteBitTestSetImmRMW") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #60
  {DBGFIELD("WriteBitTestSetRegRMW") 1, false, false, false, 1536, 1, 18, 1,  0, 0}, // #61
  {DBGFIELD("WriteBitTestSet")    1, false, false, false, 1518, 2,  1, 1,  0, 0}, // #62
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #63
  {DBGFIELD("WriteBZHI")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #64
  {DBGFIELD("WriteLoad")          1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #65
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #66
  {DBGFIELD("WriteCMOV")          1, false, false, false, 40, 1,  1, 1,  0, 0}, // #67
  {DBGFIELD("WriteFCMOV")         1, false, false, false, 1420, 1,  9, 1,  0, 0}, // #68
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 1522, 2,  1, 1, 18, 1}, // #69
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 4, false, false, false, 1524, 3,  6, 1, 20, 1}, // #70
  {DBGFIELD("WriteFCmp64X")       3, false, false, false, 1527, 3,  3, 1,  0, 0}, // #71
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 4, false, false, false, 1524, 3,  6, 1, 20, 1}, // #72
  {DBGFIELD("WriteFCmpX")         3, false, false, false, 1527, 3,  3, 1,  0, 0}, // #73
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 1, false, false, false, 1530, 3, 14, 1, 20, 1}, // #74
  {DBGFIELD("WriteFCmp64")        1, false, false, false, 1518, 2, 14, 1,  0, 0}, // #75
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 1, false, false, false, 1530, 3, 14, 1, 20, 1}, // #76
  {DBGFIELD("WriteFCmp")          1, false, false, false, 1518, 2, 14, 1,  0, 0}, // #77
  {DBGFIELD("WriteCMPXCHG")       1, false, false, false, 1537, 1, 21, 1,  0, 0}, // #78
  {DBGFIELD("WriteFComXLd_ReadAfterVecLd") 5, false, false, false, 1538, 3,  7, 1, 20, 1}, // #79
  {DBGFIELD("WriteFComX")         4, false, false, false, 1541, 3,  9, 1,  0, 0}, // #80
  {DBGFIELD("WriteFCom")          1, false, false, false, 1544, 2, 14, 1,  0, 0}, // #81
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #82
  {DBGFIELD("WriteCRC32")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #83
  {DBGFIELD("WriteCvtI2PDLd")     4, false, false, false, 1546, 3,  2, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtI2PD")       3, false, false, false, 1524, 3,  6, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtI2PSLd")     4, false, false, false, 1546, 3,  6, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtI2PS")       3, false, false, false, 1524, 3,  3, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtPD2ILd")     5, false, false, false, 1549, 3,  2, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtPD2I")       4, false, false, false, 1546, 3,  6, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtPD2PSLd")    5, false, false, false, 1552, 3, 23, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPD2PS")      4, false, false, false, 1555, 3, 18, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPS2ILd")     4, false, false, false, 1546, 3,  6, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtPS2I")       3, false, false, false, 1524, 3,  3, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtPS2PDLd")    5, false, false, false, 1546, 3,  2, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtPS2PD")      4, false, false, false, 1524, 3,  6, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtSD2ILd")     4, false, false, false, 1538, 3,  9, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 3, false, false, false, 1549, 3,  2, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtSD2I")       3, false, false, false, 1549, 3,  2, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtSD2SSLd")    4, false, false, false, 1552, 3, 18, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 4, false, false, false, 1552, 3, 18, 1, 20, 1}, // #100
  {DBGFIELD("WriteCvtSD2SS")      3, false, false, false, 1538, 3,  7, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtI2SDLd")     3, false, false, false, 1546, 3,  6, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 3, false, false, false, 1546, 3,  6, 1, 20, 1}, // #103
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 3, false, false, false, 1524, 3,  3, 1,  0, 1}, // #104
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 3, false, false, false, 1524, 3,  3, 1,  6, 1}, // #105
  {DBGFIELD("WriteCvtI2SSLd")     1, false, false, false, 1524, 3,  6, 1,  0, 0}, // #106
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 1, false, false, false, 1524, 3,  6, 1, 20, 1}, // #107
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 3, false, false, false, 1524, 3,  3, 1,  0, 1}, // #108
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 3, false, false, false, 1524, 3,  3, 1,  6, 1}, // #109
  {DBGFIELD("WriteCvtSS2SDLd")    4, false, false, false, 1546, 3,  6, 1,  0, 0}, // #110
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 4, false, false, false, 1546, 3,  6, 1, 20, 1}, // #111
  {DBGFIELD("WriteCvtSS2SD")      3, false, false, false, 1524, 3,  3, 1,  0, 0}, // #112
  {DBGFIELD("WriteCvtSS2ILd")     4, false, false, false, 1541, 3,  9, 1,  0, 0}, // #113
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 3, false, false, false, 1549, 3,  2, 1,  0, 0}, // #114
  {DBGFIELD("WriteCvtSS2I")       3, false, false, false, 1549, 3,  2, 1,  0, 0}, // #115
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 12, false, false, false, 1558, 3, 53, 1, 18, 2}, // #116
  {DBGFIELD("WriteDiv16")         12, false, false, false, 1558, 3, 53, 1,  0, 0}, // #117
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 12, false, false, false, 1558, 3, 53, 1, 18, 2}, // #118
  {DBGFIELD("WriteDiv32")         12, false, false, false, 1558, 3, 53, 1,  0, 0}, // #119
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 38, false, false, false, 1561, 3, 54, 1, 18, 2}, // #120
  {DBGFIELD("WriteDiv64")         38, false, false, false, 1561, 3, 54, 1,  0, 0}, // #121
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 9, false, false, false, 1564, 3, 55, 1, 18, 2}, // #122
  {DBGFIELD("WriteDiv8")          9, false, false, false, 1558, 3, 53, 1,  0, 0}, // #123
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 7, false, false, false, 1567, 3, 56, 1, 20, 1}, // #124
  {DBGFIELD("WriteFDiv64X")       6, false, false, false, 1567, 3, 56, 1,  0, 0}, // #125
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 7, false, false, false, 1570, 3, 57, 1, 20, 1}, // #126
  {DBGFIELD("WriteFDivX")         6, false, false, false, 1570, 3, 57, 1,  0, 0}, // #127
  {DBGFIELD("WriteFDivLd")        4, false, false, false, 1573, 3, 58, 1,  0, 0}, // #128
  {DBGFIELD("WriteFDiv")          3, false, false, false, 1573, 3, 58, 1,  0, 0}, // #129
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 4, false, false, false, 1576, 3, 51, 1, 20, 1}, // #130
  {DBGFIELD("WriteFDiv64")        3, false, false, false, 1576, 3, 51, 1,  0, 0}, // #131
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 4, false, false, false, 1573, 3, 58, 1, 20, 1}, // #132
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #133
  {DBGFIELD("WriteDPPD")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #134
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #135
  {DBGFIELD("WriteDPPS")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #136
  {DBGFIELD("WriteStore")         1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #137
  {DBGFIELD("WriteVecExtractSt")  1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #138
  {DBGFIELD("WriteVecExtract")    1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #139
  {DBGFIELD("WriteVecALUX")       1, false, false, false, 40, 1,  1, 1,  0, 0}, // #140
  {DBGFIELD("WriteFComLd")        1, false, false, false, 1544, 2, 14, 1,  0, 0}, // #141
  {DBGFIELD("WriteEMMS")          1, false, false, false, 1545, 1, 14, 1,  0, 0}, // #142
  {DBGFIELD("WriteFLDC")          1, false, false, false, 1529, 1,  7, 1,  0, 0}, // #143
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #144
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 6, false, false, false, 1541, 3,  9, 1, 20, 1}, // #145
  {DBGFIELD("WriteFHAdd")         5, false, false, false, 1549, 3,  2, 1,  0, 0}, // #146
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 29, false, false, false, 1576, 3, 51, 1, 18, 2}, // #147
  {DBGFIELD("WriteIDiv16")        29, false, false, false, 1576, 3, 51, 1,  0, 0}, // #148
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 29, false, false, false, 1576, 3, 51, 1, 18, 2}, // #149
  {DBGFIELD("WriteIDiv32")        29, false, false, false, 1576, 3, 51, 1,  0, 0}, // #150
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 60, false, false, false, 1561, 3, 54, 1, 18, 2}, // #151
  {DBGFIELD("WriteIDiv64")        60, false, false, false, 1561, 3, 54, 1,  0, 0}, // #152
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 26, false, false, false, 1576, 3, 51, 1, 18, 2}, // #153
  {DBGFIELD("WriteIDiv8")         26, false, false, false, 1576, 3, 51, 1,  0, 0}, // #154
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 1549, 3,  2, 1, 18, 2}, // #155
  {DBGFIELD("WriteIMul16")        4, false, false, false, 1546, 3,  6, 1,  0, 0}, // #156
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 3, false, false, false, 1546, 3,  6, 1, 20, 1}, // #157
  {DBGFIELD("WriteIMul16ImmLd")   3, false, false, false, 1546, 3,  6, 1,  0, 0}, // #158
  {DBGFIELD("WriteIMul16Reg")     2, false, false, false, 1524, 3,  3, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul16Imm")     2, false, false, false, 1524, 3,  3, 1,  0, 0}, // #160
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 1546, 3,  6, 1, 18, 2}, // #161
  {DBGFIELD("WriteIMul32")        3, false, false, false, 1524, 3,  3, 1,  0, 0}, // #162
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 1, false, false, false, 1544, 2, 14, 1, 20, 1}, // #163
  {DBGFIELD("WriteIMul32ImmLd")   1, false, false, false, 1544, 2, 14, 1,  0, 0}, // #164
  {DBGFIELD("WriteIMul32Reg")     1, false, false, false, 1544, 2, 14, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul32Imm")     1, false, false, false, 1544, 2, 14, 1,  0, 0}, // #166
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 1552, 3, 23, 1, 18, 2}, // #167
  {DBGFIELD("WriteIMul64")        8, false, false, false, 1552, 3, 23, 1,  0, 0}, // #168
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 6, false, false, false, 1552, 3, 23, 1, 20, 1}, // #169
  {DBGFIELD("WriteIMul64ImmLd")   7, false, false, false, 1579, 3, 10, 1,  0, 0}, // #170
  {DBGFIELD("WriteIMul64Reg")     6, false, false, false, 1552, 3, 23, 1,  0, 0}, // #171
  {DBGFIELD("WriteIMul64Imm")     7, false, false, false, 1579, 3, 10, 1,  0, 0}, // #172
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 1546, 3,  6, 1, 18, 2}, // #173
  {DBGFIELD("WriteIMul8")         3, false, false, false, 1546, 3,  6, 1,  0, 0}, // #174
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #175
  {DBGFIELD("WriteFShuffle")      1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #176
  {DBGFIELD("WriteVecLogicX")     1, false, false, false, 40, 1,  1, 1,  0, 0}, // #177
  {DBGFIELD("WriteShuffle")       1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #178
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, false, 80, 1, 13, 1,  0, 0}, // #179
  {DBGFIELD("WriteVecLoadX")      1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #180
  {DBGFIELD("WriteLDMXCSR")       4, false, false, false, 1527, 3, 14, 1,  0, 0}, // #181
  {DBGFIELD("WriteFLD0")          1, false, false, false, 40, 1,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteFLD1")          1, false, false, false, 1582, 1,  3, 1,  0, 0}, // #183
  {DBGFIELD("WriteLEA")           1, false, false, false, 1518, 2,  1, 1,  0, 0}, // #184
  {DBGFIELD("WriteFence")         1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteLZCNTLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #186
  {DBGFIELD("WriteLZCNT")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #187
  {DBGFIELD("WriteVecStoreX")     1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #188
  {DBGFIELD("WriteVecStore")      1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, false, 1583, 2,  5, 1,  0, 0}, // #190
  {DBGFIELD("WriteVecLoad")       1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #191
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #192
  {DBGFIELD("WriteVecMoveX")      1, false, false, false, 40, 1,  1, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecStoreNT")    1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #194
  {DBGFIELD("WriteVecMove")       1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #195
  {DBGFIELD("WriteVecALULd")      1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #196
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #197
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #198
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #199
  {DBGFIELD("WriteVecLogic")      1, false, false, false, 40, 1,  1, 1,  0, 0}, // #200
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, false, 1585, 3,  8, 1, 20, 1}, // #201
  {DBGFIELD("WritePHAdd")         3, false, false, false, 1588, 3,  5, 1,  0, 0}, // #202
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #203
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 1, false, false, false, 1522, 2,  1, 1,  6, 1}, // #204
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 1, false, false, false, 1522, 2,  8, 1, 20, 1}, // #205
  {DBGFIELD("WriteVecIMul")       1, false, false, false, 1522, 2,  8, 1,  0, 0}, // #206
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, false, 1583, 2,  5, 1,  0, 0}, // #207
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 1, false, false, false, 1522, 2,  8, 1, 20, 1}, // #208
  {DBGFIELD("WritePSADBW")        1, false, false, false, 1522, 2,  8, 1,  0, 0}, // #209
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #210
  {DBGFIELD("WriteVarShuffle")    1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #211
  {DBGFIELD("WriteShuffleLd")     1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #212
  {DBGFIELD("WriteVecShiftImm")   1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 3, false, false, false, 1591, 3,  5, 1, 20, 1}, // #214
  {DBGFIELD("WriteVecShift")      2, false, false, false, 1530, 3, 13, 1,  0, 0}, // #215
  {DBGFIELD("WriteFMoveX")        1, false, false, false, 40, 1,  1, 1,  0, 0}, // #216
  {DBGFIELD("WriteFShuffleLd")    1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #217
  {DBGFIELD("WriteFStore")        1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #218
  {DBGFIELD("WriteFMOVMSK")       1, false, false, false, 1583, 2,  5, 1,  0, 0}, // #219
  {DBGFIELD("WriteVecLoadNT")     1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #220
  {DBGFIELD("WriteStoreNT")       1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #221
  {DBGFIELD("WriteFStoreNTX")     1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #222
  {DBGFIELD("WriteFStoreNT")      1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #223
  {DBGFIELD("WriteFLoad")         1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #224
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #225
  {DBGFIELD("WriteMPSAD")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #226
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 7, false, false, false, 1538, 3,  7, 1, 20, 1}, // #227
  {DBGFIELD("WriteFMul64X")       6, false, false, false, 1541, 3,  9, 1,  0, 0}, // #228
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 1, false, false, false, 1594, 2, 14, 1, 20, 1}, // #229
  {DBGFIELD("WriteFMulX")         1, false, false, false, 1594, 2, 14, 1,  0, 0}, // #230
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 1, false, false, false, 1594, 2, 14, 1, 20, 1}, // #231
  {DBGFIELD("WriteFMul64")        1, false, false, false, 1594, 2, 14, 1,  0, 0}, // #232
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 1, false, false, false, 1594, 2,  8, 1, 20, 1}, // #233
  {DBGFIELD("WriteFMul")          1, false, false, false, 1594, 2,  8, 1,  0, 0}, // #234
  {DBGFIELD("WriteMULX32Ld")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #235
  {DBGFIELD("WriteMULX32")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #236
  {DBGFIELD("WriteIMulHLd_WriteMULX32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #237
  {DBGFIELD("WriteIMulH_WriteMULX32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #238
  {DBGFIELD("WriteMULX64Ld")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #239
  {DBGFIELD("WriteMULX64")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #240
  {DBGFIELD("WriteIMulHLd_WriteMULX64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #241
  {DBGFIELD("WriteIMulH_WriteMULX64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #242
  {DBGFIELD("WriteFMulLd")        1, false, false, false, 1594, 2,  8, 1,  0, 0}, // #243
  {DBGFIELD("WriteVecALUXLd")     1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #244
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #245
  {DBGFIELD("WriteShuffleX")      1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #246
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #247
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #248
  {DBGFIELD("WriteVarBlend")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #249
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #250
  {DBGFIELD("WriteBlend")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #251
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #252
  {DBGFIELD("WriteCLMul")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #253
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #254
  {DBGFIELD("WritePCmpEStrI")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #255
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #256
  {DBGFIELD("WritePCmpEStrM")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #257
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #258
  {DBGFIELD("WritePCmpIStrI")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #259
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #260
  {DBGFIELD("WritePCmpIStrM")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #261
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 4, false, false, false, 1546, 3,  6, 1, 20, 1}, // #262
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 4, false, false, false, 1549, 3,  2, 1, 20, 1}, // #263
  {DBGFIELD("WritePHAddX")        3, false, false, false, 1546, 3,  6, 1,  0, 0}, // #264
  {DBGFIELD("WritePHMINPOSLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #265
  {DBGFIELD("WritePHMINPOS")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #266
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 4, false, false, false, 1546, 3,  6, 1, 20, 1}, // #267
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 1, false, false, false, 1594, 2, 14, 1, 20, 1}, // #268
  {DBGFIELD("WriteVecIMulX")      1, false, false, false, 1594, 2, 14, 1,  0, 0}, // #269
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, false, 1583, 2,  5, 1,  0, 0}, // #270
  {DBGFIELD("WriteShuffleXLd")    1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #271
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #272
  {DBGFIELD("WritePMULLD")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #273
  {DBGFIELD("WriteCopy")          2, false, false, false, 1594, 2, 13, 1,  0, 0}, // #274
  {DBGFIELD("WritePOPCNTLd")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #275
  {DBGFIELD("WritePOPCNT")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #276
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 1, false, false, false, 1594, 2, 14, 1, 20, 1}, // #277
  {DBGFIELD("WritePSADBWX")       1, false, false, false, 1594, 2, 14, 1,  0, 0}, // #278
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 5, false, false, false, 1585, 3, 14, 1, 20, 1}, // #279
  {DBGFIELD("WriteVarShuffleX")   4, false, false, false, 1588, 3,  8, 1,  0, 0}, // #280
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #281
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 3, false, false, false, 1591, 3,  5, 1, 20, 1}, // #282
  {DBGFIELD("WriteVecShiftX")     2, false, false, false, 1530, 3, 13, 1,  0, 0}, // #283
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #284
  {DBGFIELD("WriteVecTest")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #285
  {DBGFIELD("WriteRotateLd_WriteRMW") 2, false, false, false, 1594, 2, 59, 2,  0, 0}, // #286
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 2, false, false, false, 1594, 2, 59, 2,  0, 0}, // #287
  {DBGFIELD("WriteRotate")        1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #288
  {DBGFIELD("WriteRotateCL")      1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #289
  {DBGFIELD("WriteFRcpXLd")       6, false, false, false, 1538, 3,  7, 1,  0, 0}, // #290
  {DBGFIELD("WriteFRcpX")         5, false, false, false, 1541, 3,  9, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRcpLd")        1, false, false, false, 1596, 2,  8, 1,  0, 0}, // #292
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 1, false, false, false, 1596, 2,  8, 1, 20, 1}, // #293
  {DBGFIELD("WriteFRcp")          1, false, false, false, 1596, 2,  8, 1,  0, 0}, // #294
  {DBGFIELD("WriteRMW")           1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #295
  {DBGFIELD("WriteShiftLd")       1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #296
  {DBGFIELD("WriteShift")         1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #297
  {DBGFIELD("WriteFRndLd")        1, false, false, false, 1544, 2, 14, 1,  0, 0}, // #298
  {DBGFIELD("WriteFRnd")          1, false, false, false, 1544, 2, 14, 1,  0, 0}, // #299
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 1, false, false, false, 1544, 2, 14, 1, 20, 1}, // #300
  {DBGFIELD("WriteFRsqrtXLd")     6, false, false, false, 1538, 3,  7, 1,  0, 0}, // #301
  {DBGFIELD("WriteFRsqrtX")       5, false, false, false, 1541, 3,  9, 1,  0, 0}, // #302
  {DBGFIELD("WriteFRsqrtLd")      1, false, false, false, 1596, 2,  8, 1,  0, 0}, // #303
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 1, false, false, false, 1596, 2,  8, 1, 20, 1}, // #304
  {DBGFIELD("WriteFRsqrt")        1, false, false, false, 1596, 2,  8, 1,  0, 0}, // #305
  {DBGFIELD("WriteShiftLd_WriteRMW") 2, false, false, false, 1594, 2, 59, 2,  0, 0}, // #306
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 2, false, false, false, 1594, 2, 59, 2,  0, 0}, // #307
  {DBGFIELD("WriteShiftCL")       1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #308
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 1522, 2,  1, 1, 18, 1}, // #309
  {DBGFIELD("WriteSETCCStore")    1, false, false, false, 80, 1, 13, 1,  0, 0}, // #310
  {DBGFIELD("WriteSETCC")         1, false, false, false, 40, 1,  1, 1,  0, 0}, // #311
  {DBGFIELD("WriteSHDmrcl")       1, false, false, false, 369, 1,  8, 1,  0, 0}, // #312
  {DBGFIELD("WriteSHDmri")        1, false, false, false, 369, 1,  8, 1,  0, 0}, // #313
  {DBGFIELD("WriteSHDrrcl")       1, false, false, false, 80, 1, 13, 1,  0, 0}, // #314
  {DBGFIELD("WriteFSqrt64XLd")    6, false, false, false, 1567, 3, 56, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrt64X")      5, false, false, false, 1567, 3, 56, 1,  0, 0}, // #316
  {DBGFIELD("WriteFSqrtXLd")      6, false, false, false, 1570, 3, 57, 1,  0, 0}, // #317
  {DBGFIELD("WriteFSqrtX")        5, false, false, false, 1570, 3, 57, 1,  0, 0}, // #318
  {DBGFIELD("WriteFSqrt64Ld")     4, false, false, false, 1576, 3, 51, 1,  0, 0}, // #319
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 4, false, false, false, 1576, 3, 51, 1, 20, 1}, // #320
  {DBGFIELD("WriteFSqrt64")       3, false, false, false, 1576, 3, 51, 1,  0, 0}, // #321
  {DBGFIELD("WriteFSqrtLd")       4, false, false, false, 1573, 3, 58, 1,  0, 0}, // #322
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 4, false, false, false, 1573, 3, 58, 1, 20, 1}, // #323
  {DBGFIELD("WriteFSqrt")         3, false, false, false, 1573, 3, 58, 1,  0, 0}, // #324
  {DBGFIELD("WriteFSqrt80")       1, false, false, false, 1598, 2, 61, 1,  0, 0}, // #325
  {DBGFIELD("WriteSTMXCSR")       4, false, false, false, 1600, 3, 21, 1,  0, 0}, // #326
  {DBGFIELD("WriteTZCNTLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #327
  {DBGFIELD("WriteTZCNT")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #328
  {DBGFIELD("WriteFMAZLd")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #329
  {DBGFIELD("WriteFMALd")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #330
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #331
  {DBGFIELD("WriteFAdd64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #332
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteFAdd64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #335
  {DBGFIELD("WriteFAddY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #336
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD("WriteFAddZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #339
  {DBGFIELD("WriteShuffleY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #340
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD("WriteShuffleZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #343
  {DBGFIELD("WriteFLogicY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #344
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #345
  {DBGFIELD("WriteFLogicZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #346
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #347
  {DBGFIELD("WriteFVarBlendY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #348
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #349
  {DBGFIELD("WriteFVarBlendZ")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #351
  {DBGFIELD("WriteFBlendY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #352
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #353
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #354
  {DBGFIELD("WriteShuffle256Ld")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #355
  {DBGFIELD("WriteShuffle256")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #356
  {DBGFIELD("WriteShuffleYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD("WriteFShuffle256")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #358
  {DBGFIELD("WriteFShuffle256Ld") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #359
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #360
  {DBGFIELD("WriteFCmp64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #361
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #362
  {DBGFIELD("WriteFCmpY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #363
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #364
  {DBGFIELD("WriteFCmpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("WriteVarShuffle256Ld") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #366
  {DBGFIELD("WriteVarShuffle256") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #367
  {DBGFIELD("WriteCvtI2PDYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #368
  {DBGFIELD("WriteCvtI2PDY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #369
  {DBGFIELD("WriteCvtI2PDZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #370
  {DBGFIELD("WriteCvtI2PDZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #371
  {DBGFIELD("WriteCvtI2PSYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #372
  {DBGFIELD("WriteCvtI2PSY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #373
  {DBGFIELD("WriteCvtI2PSZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #374
  {DBGFIELD("WriteCvtI2PSZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 5, false, false, false, 1552, 3, 23, 1, 20, 1}, // #376
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #377
  {DBGFIELD("WriteCvtPD2PSY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #378
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtPD2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteCvtPD2PSYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #381
  {DBGFIELD("WriteCvtPD2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #382
  {DBGFIELD("WriteCvtPD2IYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #383
  {DBGFIELD("WriteCvtPD2IY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #384
  {DBGFIELD("WriteCvtPD2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #385
  {DBGFIELD("WriteCvtPD2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("WriteCvtPS2IYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2IY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2PDYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PDY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PDZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PDZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtPH2PSYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #395
  {DBGFIELD("WriteCvtPH2PSY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #396
  {DBGFIELD("WriteCvtPH2PSLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #397
  {DBGFIELD("WriteCvtPH2PS")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #398
  {DBGFIELD("WriteCvtPH2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteCvtPH2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #400
  {DBGFIELD("WriteCvtPS2PHYSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #401
  {DBGFIELD("WriteCvtPS2PHY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #402
  {DBGFIELD("WriteCvtPS2PHSt")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #403
  {DBGFIELD("WriteCvtPS2PH")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD("WriteCvtPS2PHZSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteCvtPS2PHZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #406
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 4, false, false, false, 1538, 3,  9, 1, 20, 1}, // #407
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 4, false, false, false, 1541, 3,  9, 1, 20, 1}, // #408
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #409
  {DBGFIELD("WritePSADBWY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #410
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #411
  {DBGFIELD("WritePSADBWZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #412
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #413
  {DBGFIELD("WriteFDiv64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #414
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD("WriteFDiv64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #417
  {DBGFIELD("WriteFDivY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #418
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WriteFDivZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #420
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #421
  {DBGFIELD("WriteFMAX")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #422
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #423
  {DBGFIELD("WriteFMAY")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #424
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteFMAZ")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #426
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #427
  {DBGFIELD("WriteDPPSY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #428
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #429
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #430
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #431
  {DBGFIELD("WriteFMALd_ReadAfterVecLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #432
  {DBGFIELD("WriteFMA")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #433
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #434
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #435
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #436
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #437
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #438
  {DBGFIELD("WriteFRndY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #439
  {DBGFIELD("WriteLoad_WriteVecMaskedGatherWriteback") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #440
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteFRndZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #443
  {DBGFIELD("WriteVecIMulY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #444
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #445
  {DBGFIELD("WriteVecIMulZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #446
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #447
  {DBGFIELD("WriteVecALUY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("WriteVecALUZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #450
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #451
  {DBGFIELD("WriteFHAddY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #452
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #453
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #454
  {DBGFIELD("WriteVecLoadY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #455
  {DBGFIELD("WriteFMaskedStore64Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #456
  {DBGFIELD("WriteFMaskedLoadY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #457
  {DBGFIELD("WriteFMaskedStore64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #458
  {DBGFIELD("WriteFMaskedLoad")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #459
  {DBGFIELD("WriteFMaskedStore32Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #460
  {DBGFIELD("WriteFMaskedStore32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #461
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #462
  {DBGFIELD("WriteFCmp64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #463
  {DBGFIELD("WriteFMoveY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #464
  {DBGFIELD("WriteFMoveZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #465
  {DBGFIELD("WriteFShuffleYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #466
  {DBGFIELD("WriteFShuffleY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #467
  {DBGFIELD("WriteFShuffleZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteFShuffleZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #469
  {DBGFIELD("WriteVecStoreY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #470
  {DBGFIELD("WriteVecMoveY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD("WriteVecMoveZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #472
  {DBGFIELD("WriteVecLoadNTY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #473
  {DBGFIELD("WriteVecStoreNTY")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #474
  {DBGFIELD("WriteFStoreNTY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #475
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #476
  {DBGFIELD("WriteMPSADY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #477
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #478
  {DBGFIELD("WriteFMul64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #479
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteFMul64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #482
  {DBGFIELD("WriteFMulY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #483
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #484
  {DBGFIELD("WriteFMulZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #485
  {DBGFIELD("WriteVecALUYLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD("WriteVecALUZLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #488
  {DBGFIELD("WriteVecLogicY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #489
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteVecLogicZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #492
  {DBGFIELD("WriteBlendY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #493
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #494
  {DBGFIELD("WriteVarBlendY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #495
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteVarBlendZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #498
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #499
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #500
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #501
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 1522, 2,  1, 1, 20, 2}, // #502
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 1522, 2,  1, 1, 22, 2}, // #503
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #504
  {DBGFIELD("WriteFVarShuffle256") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #505
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #506
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #507
  {DBGFIELD("WriteFVarShuffleY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #508
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #509
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #510
  {DBGFIELD("WriteFVarShuffle")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #511
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #512
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #513
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #514
  {DBGFIELD("WriteFVarShuffleZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #515
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #516
  {DBGFIELD("WritePHAddY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #517
  {DBGFIELD("WriteVecInsert")     1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #518
  {DBGFIELD("WriteVecIMulXLd")    1, false, false, false, 1594, 2, 14, 1,  0, 0}, // #519
  {DBGFIELD("WriteVecIMulYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #520
  {DBGFIELD("WriteVecIMulZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #521
  {DBGFIELD("WriteVecMaskedStore32Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #522
  {DBGFIELD("WriteVecMaskedLoadY") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #523
  {DBGFIELD("WriteVecMaskedStore32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #524
  {DBGFIELD("WriteVecMaskedLoad") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #525
  {DBGFIELD("WriteVecMaskedStore64Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #526
  {DBGFIELD("WriteVecMaskedStore64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #527
  {DBGFIELD("WriteVPMOV256Ld")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #528
  {DBGFIELD("WriteVPMOV256")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #529
  {DBGFIELD("WriteVecMOVMSKY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #530
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #531
  {DBGFIELD("WritePMULLDY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #532
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WritePMULLDZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #534
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 5, false, false, false, 1585, 3, 14, 1, 20, 2}, // #535
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 5, false, false, false, 1585, 3, 14, 1, 22, 2}, // #536
  {DBGFIELD("WriteVecShiftImmXLd") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #537
  {DBGFIELD("WriteVecShiftImmYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #538
  {DBGFIELD("WriteVecShiftImmY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #539
  {DBGFIELD("WriteVecShiftImmZLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #540
  {DBGFIELD("WriteVecShiftImmZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #541
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD("WriteVarVecShift")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #543
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #544
  {DBGFIELD("WriteVarVecShiftY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #545
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #546
  {DBGFIELD("WriteVarVecShiftZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #547
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #548
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD("WriteVarShuffleY")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #550
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #551
  {DBGFIELD("WriteVarShuffleZ")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #552
  {DBGFIELD("WriteShuffleZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #553
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #554
  {DBGFIELD("WriteVecShiftY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #555
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD("WriteVecShiftZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #557
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #558
  {DBGFIELD("WriteVecTestY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #559
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 6, false, false, false, 1538, 3,  7, 1, 20, 1}, // #560
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #561
  {DBGFIELD("WriteFRcpY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #562
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #563
  {DBGFIELD("WriteFRcpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #564
  {DBGFIELD("WriteFRcpYLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #565
  {DBGFIELD("WriteFRndYLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #566
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 6, false, false, false, 1538, 3,  7, 1, 20, 1}, // #567
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #568
  {DBGFIELD("WriteFRsqrtY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #569
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #570
  {DBGFIELD("WriteFRsqrtZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #571
  {DBGFIELD("WriteFRsqrtYLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #572
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #573
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #574
  {DBGFIELD("WriteFSqrt64YLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #575
  {DBGFIELD("WriteFSqrt64Y")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #576
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 6, false, false, false, 1567, 3, 56, 1, 20, 1}, // #577
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #578
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #579
  {DBGFIELD("WriteFSqrt64Z")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #580
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 6, false, false, false, 1570, 3, 57, 1, 20, 1}, // #581
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #582
  {DBGFIELD("WriteFSqrtY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #583
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #584
  {DBGFIELD("WriteFSqrtZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #585
  {DBGFIELD("WriteFSqrtYLd")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #586
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #587
  {DBGFIELD("WriteFTestY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #588
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #589
  {DBGFIELD("WriteFTest")         1, false, false, false, 40, 1,  1, 1,  0, 0}, // #590
  {DBGFIELD("WriteALULd_WriteRMW") 2, false, false, false, 1594, 2, 59, 2,  0, 0}, // #591
  {DBGFIELD("WriteXCHG")          1, false, false, false, 80, 1, 13, 1,  0, 0}, // #592
  {DBGFIELD("COPY")               1, false, false, false, 40, 1,  1, 1,  0, 0}, // #593
  {DBGFIELD("XAM_F")              1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #594
  {DBGFIELD("LD_Frr")             1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #595
  {DBGFIELD("MOVSX64rr32")        1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #596
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #597
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #598
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #599
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #600
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #601
  {DBGFIELD("FCOMPP")             1, false, false, false, 1518, 2,  1, 1,  0, 0}, // #602
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, false, 1518, 2,  1, 1,  0, 0}, // #603
  {DBGFIELD("MMX_CVTPI2PSrr")     1, false, false, false, 1603, 2, 14, 1,  0, 0}, // #604
  {DBGFIELD("MMX_CVTPI2PSrm")     1, false, false, false, 1603, 2, 14, 1,  0, 0}, // #605
  {DBGFIELD("MMX_CVTPS2PIrr_MMX_CVTTPS2PIrr") 1, false, false, false, 1603, 2, 14, 1,  0, 0}, // #606
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, false, 1530, 3,  1, 1,  0, 0}, // #607
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, false, 1530, 3,  1, 1,  0, 0}, // #608
  {DBGFIELD("XCH_F")              1, false, false, false, 1530, 3,  1, 1,  0, 0}, // #609
  {DBGFIELD("RETI16_RETI32_RETI64_IRET_IRET16_IRET32_IRET64") 1, false, false, false, 1530, 3,  1, 1,  0, 0}, // #610
  {DBGFIELD("MMX_CVTPS2PIrm_MMX_CVTTPS2PIrm") 1, false, false, false, 1527, 3, 14, 1,  0, 0}, // #611
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 1, false, false, false, 1527, 3, 14, 1,  0, 0}, // #612
  {DBGFIELD("CVTSI642SDrm")       1, false, false, false, 1524, 3,  6, 1,  0, 0}, // #613
  {DBGFIELD("CVTSI642SDrm_Int")   1, false, false, false, 1524, 3,  6, 1,  0, 0}, // #614
  {DBGFIELD("CVTSI642SSrr")       4, false, false, false, 1549, 3,  6, 1,  0, 0}, // #615
  {DBGFIELD("CVTSI642SSrr_Int")   4, false, false, false, 1549, 3,  6, 1,  0, 0}, // #616
  {DBGFIELD("CVTSI642SSrm")       4, false, false, false, 1549, 3,  6, 1,  0, 0}, // #617
  {DBGFIELD("CVTSI642SSrm_Int")   4, false, false, false, 1549, 3,  6, 1,  0, 0}, // #618
  {DBGFIELD("CVTSS2SI64rr_CVTTSS2SI64rr") 4, false, false, false, 1541, 3,  9, 1,  0, 0}, // #619
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 4, false, false, false, 1541, 3,  9, 1,  0, 0}, // #620
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 5, false, false, false, 1555, 3,  7, 1,  0, 0}, // #621
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #622
  {DBGFIELD("LFENCE")             1, false, false, false, 40, 1,  1, 1,  0, 0}, // #623
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #624
  {DBGFIELD("LEAVE_LEAVE64")      1, false, false, false, 80, 1, 13, 1,  0, 0}, // #625
  {DBGFIELD("POP16r")             1, false, false, false, 80, 1, 13, 1,  0, 0}, // #626
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #627
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #628
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #629
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #630
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, false, 80, 1, 13, 1,  0, 0}, // #631
  {DBGFIELD("MMX_PADDQrr_MMX_PSUBQrr") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #632
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #633
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #634
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  1, false, false, false, 80, 1, 13, 1,  0, 0}, // #635
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, false, 80, 1, 13, 1,  0, 0}, // #636
  {DBGFIELD("CLD")                1, false, false, false, 100, 1,  5, 1,  0, 0}, // #637
  {DBGFIELD("LDDQUrm")            1, false, false, false, 100, 1,  5, 1,  0, 0}, // #638
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, false, 100, 1,  5, 1,  0, 0}, // #639
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 1, false, false, false, 100, 1,  5, 1,  0, 0}, // #640
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 1, false, false, false, 100, 1,  5, 1,  0, 0}, // #641
  {DBGFIELD("PHADDDrr_PHSUBDrr")  1, false, false, false, 100, 1,  5, 1,  0, 0}, // #642
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, false, 100, 1,  5, 1,  0, 0}, // #643
  {DBGFIELD("MMX_PADDQrm_MMX_PSUBQrm") 1, false, false, false, 100, 1,  5, 1,  0, 0}, // #644
  {DBGFIELD("MOVDQUrm")           1, false, false, false, 100, 1,  5, 1,  0, 0}, // #645
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, false, 100, 1,  5, 1,  0, 0}, // #646
  {DBGFIELD("PADDQrm_PSUBQrm")    1, false, false, false, 100, 1,  5, 1,  0, 0}, // #647
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, false, 369, 1,  8, 1,  0, 0}, // #648
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   1, false, false, false, 369, 1,  8, 1,  0, 0}, // #649
  {DBGFIELD("LD_F80m")            1, false, false, false, 369, 1,  8, 1,  0, 0}, // #650
  {DBGFIELD("PHADDDrm_PHSUBDrm")  1, false, false, false, 369, 1,  8, 1,  0, 0}, // #651
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 1, false, false, false, 369, 1,  8, 1,  0, 0}, // #652
  {DBGFIELD("FLDCW16m")           1, false, false, false, 1545, 1, 14, 1,  0, 0}, // #653
  {DBGFIELD("ST_FP80m")           1, false, false, false, 1545, 1, 14, 1,  0, 0}, // #654
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 1, false, false, false, 1545, 1, 14, 1,  0, 0}, // #655
  {DBGFIELD("CMPXCHG8rm")         1, false, false, false, 1582, 1,  3, 1,  0, 0}, // #656
  {DBGFIELD("INTO")               1, false, false, false, 1582, 1,  3, 1,  0, 0}, // #657
  {DBGFIELD("XLAT")               1, false, false, false, 1582, 1,  3, 1,  0, 0}, // #658
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 1, false, false, false, 1582, 1,  3, 1,  0, 0}, // #659
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, false, 1582, 1,  3, 1,  0, 0}, // #660
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 1, false, false, false, 1582, 1,  3, 1,  0, 0}, // #661
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 1, false, false, false, 1582, 1,  3, 1,  0, 0}, // #662
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 1, false, false, false, 1582, 1,  3, 1,  0, 0}, // #663
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 1, false, false, false, 1582, 1,  3, 1,  0, 0}, // #664
  {DBGFIELD("AAD8i8")             1, false, false, false, 191, 1,  6, 1,  0, 0}, // #665
  {DBGFIELD("LOOPE")              1, false, false, false, 1587, 1,  2, 1,  0, 0}, // #666
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, false, 1587, 1,  2, 1,  0, 0}, // #667
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 1, false, false, false, 1587, 1,  2, 1,  0, 0}, // #668
  {DBGFIELD("FNSTCW16m")          1, false, false, false, 1587, 1,  2, 1,  0, 0}, // #669
  {DBGFIELD("POPA16_POPA32")      1, false, false, false, 1420, 1,  9, 1,  0, 0}, // #670
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, false, 1420, 1,  9, 1,  0, 0}, // #671
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 1, false, false, false, 1420, 1,  9, 1,  0, 0}, // #672
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 1, false, false, false, 1420, 1,  9, 1,  0, 0}, // #673
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, false, 1420, 1,  9, 1,  0, 0}, // #674
  {DBGFIELD("CMPXCHG8rr")         1, false, false, false, 1420, 1,  9, 1,  0, 0}, // #675
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80") 1, false, false, false, 1420, 1,  9, 1,  0, 0}, // #676
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, false, 1536, 1, 18, 1,  0, 0}, // #677
  {DBGFIELD("AAA_AAS")            1, false, false, false, 1605, 1, 22, 1,  0, 0}, // #678
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 1, false, false, false, 1548, 1, 10, 1,  0, 0}, // #679
  {DBGFIELD("LOOPNE")             1, false, false, false, 1606, 1, 17, 1,  0, 0}, // #680
  {DBGFIELD("PAUSE")              1, false, false, false, 1606, 1, 17, 1,  0, 0}, // #681
  {DBGFIELD("CMPXCHG8B")          1, false, false, false, 1543, 1, 31, 1,  0, 0}, // #682
  {DBGFIELD("DAA")                1, false, false, false, 1543, 1, 31, 1,  0, 0}, // #683
  {DBGFIELD("LOOP")               1, false, false, false, 1543, 1, 31, 1,  0, 0}, // #684
  {DBGFIELD("DAS")                1, false, false, false, 1540, 1, 12, 1,  0, 0}, // #685
  {DBGFIELD("AAM8i8")             1, false, false, false, 1607, 1, 37, 1,  0, 0}, // #686
  {DBGFIELD("STD")                1, false, false, false, 1607, 1, 37, 1,  0, 0}, // #687
  {DBGFIELD("CMPXCHG16B")         1, false, false, false, 1557, 1, 44, 1,  0, 0}, // #688
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, false, 1608, 1, 36, 1,  0, 0}, // #689
  {DBGFIELD("FNCLEX_FXTRACT")     1, false, false, false, 1609, 1, 11, 1,  0, 0}, // #690
  {DBGFIELD("POPF32_POPF64")      1, false, false, false, 1610, 1, 62, 1,  0, 0}, // #691
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, false, 1611, 1, 15, 1,  0, 0}, // #692
  {DBGFIELD("RDTSC_RDTSCP")       1, false, false, false, 1602, 1, 47, 1,  0, 0}, // #693
  {DBGFIELD("ENTER")              1, false, false, false, 1535, 1, 63, 1,  0, 0}, // #694
  {DBGFIELD("POPF16")             1, false, false, false, 1535, 1, 63, 1,  0, 0}, // #695
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, false, 1612, 1, 64, 1,  0, 0}, // #696
  {DBGFIELD("FRNDINT")            1, false, false, false, 1613, 1, 49, 1,  0, 0}, // #697
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false, false, 1613, 1, 49, 1,  0, 0}, // #698
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, false, 1614, 1, 65, 1,  0, 0}, // #699
  {DBGFIELD("FPREM")              1, false, false, false, 1615, 1, 66, 1,  0, 0}, // #700
  {DBGFIELD("INSB_INSL_INSW")     1, false, false, false, 1616, 1, 67, 1,  0, 0}, // #701
  {DBGFIELD("FNINIT")             1, false, false, false, 1617, 1, 43, 1,  0, 0}, // #702
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 1, false, false, false, 1575, 1, 55, 1,  0, 0}, // #703
  {DBGFIELD("FPREM1")             1, false, false, false, 1599, 1, 61, 1,  0, 0}, // #704
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, false, 1599, 1, 61, 1,  0, 0}, // #705
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 1, false, false, false, 1618, 1, 68, 1,  0, 0}, // #706
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, false, 1619, 1, 69, 1,  0, 0}, // #707
  {DBGFIELD("FSCALE")             1, false, false, false, 1620, 1, 70, 1,  0, 0}, // #708
  {DBGFIELD("RDMSR")              1, false, false, false, 1621, 1, 71, 1,  0, 0}, // #709
  {DBGFIELD("RET_RET16_RET32_RET64_LRET16_LRET32_LRET64_LRETI16_LRETI32_LRETI64") 1, false, false, false, 1622, 1, 72, 1,  0, 0}, // #710
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 1, false, false, false, 1623, 1, 73, 1,  0, 0}, // #711
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 1, false, false, false, 1624, 1, 74, 1,  0, 0}, // #712
  {DBGFIELD("F2XM1")              1, false, false, false, 1625, 1, 75, 1,  0, 0}, // #713
  {DBGFIELD("CPUID")              1, false, false, false, 1626, 1, 76, 1,  0, 0}, // #714
  {DBGFIELD("INT")                1, false, false, false, 1627, 1, 77, 1,  0, 0}, // #715
  {DBGFIELD("INT3")               1, false, false, false, 1628, 1, 54, 1,  0, 0}, // #716
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, false, 1572, 1, 78, 1,  0, 0}, // #717
  {DBGFIELD("FXRSTOR_FXRSTOR64")  1, false, false, false, 1629, 1, 79, 1,  0, 0}, // #718
  {DBGFIELD("FYL2X")              1, false, false, false, 1630, 1, 80, 1,  0, 0}, // #719
  {DBGFIELD("FYL2XP1")            1, false, false, false, 1631, 1, 81, 1,  0, 0}, // #720
  {DBGFIELD("FPTAN")              1, false, false, false, 1632, 1, 82, 1,  0, 0}, // #721
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, false, 1633, 1, 83, 1,  0, 0}, // #722
  {DBGFIELD("FPATAN")             1, false, false, false, 1634, 1, 84, 1,  0, 0}, // #723
  {DBGFIELD("WRMSR")              1, false, false, false, 1635, 1, 85, 1,  0, 0}, // #724
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, false, 1544, 2, 14, 1,  0, 0}, // #725
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, false, 1518, 2,  1, 1,  0, 0}, // #726
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #727
  {DBGFIELD("FNOP")               1, false, false, false, 40, 1,  1, 1,  0, 0}, // #728
  {DBGFIELD("RET64")              1, false, false, false, 1622, 1, 72, 1,  0, 0}, // #729
  {DBGFIELD("CDQ_CQO")            1, false, false, false, 369, 1,  8, 1,  0, 0}, // #730
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #731
  {DBGFIELD("MMX_PADDQrr")        1, false, false, false, 80, 1, 13, 1,  0, 0}, // #732
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #733
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #734
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int_VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 4, false, false, false, 1541, 3,  9, 1,  0, 0}, // #735
  {DBGFIELD("CWD")                1, false, false, false, 369, 1,  8, 1,  0, 0}, // #736
  {DBGFIELD("FNSTSW16r")          1, false, false, false, 40, 1,  1, 1,  0, 0}, // #737
  {DBGFIELD("MMX_MOVDQ2Qrr")      1, false, false, false, 40, 1,  1, 1,  0, 0}, // #738
  {DBGFIELD("PUSHFS64")           1, false, false, false, 80, 1, 13, 1,  0, 0}, // #739
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #740
  {DBGFIELD("RCL8r1_RCL16r1_RCL32r1_RCL64r1_RCR8r1_RCR16r1_RCR32r1_RCR64r1") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #741
  {DBGFIELD("RCR8ri_RCR16ri_RCR32ri_RCR64ri") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #742
  {DBGFIELD("RCL8ri_RCL16ri_RCL32ri_RCL64ri") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #743
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, false, 1420, 1,  9, 1,  0, 0}, // #744
  {DBGFIELD("MOV64sr")            1, false, false, false, 40, 1,  1, 1,  0, 0}, // #745
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVSX32rm16_MOVSX32rm32_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #746
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #747
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 1, false, false, false, 1530, 3,  1, 1,  0, 0}, // #748
  {DBGFIELD("CLI")                1, false, false, false, 40, 1,  4, 1,  0, 0}, // #749
  {DBGFIELD("PUSHGS64")           1, false, false, false, 80, 1, 13, 1,  0, 0}, // #750
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #751
  {DBGFIELD("CALL64pcrel32")      1, false, false, false, 1518, 2,  1, 1,  0, 0}, // #752
  {DBGFIELD("CALL64r_RVMARKER_CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false, false, 1518, 2,  1, 1,  0, 0}, // #753
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #754
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #755
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #756
  {DBGFIELD("PUSHF16_PUSHF64")    1, false, false, false, 1420, 1,  9, 1,  0, 0}, // #757
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #758
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #759
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #760
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #761
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #762
  {DBGFIELD("MOV16sm")            1, false, false, false, 40, 1,  1, 1,  0, 0}, // #763
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #764
  {DBGFIELD("MMX_PALIGNRrmi")     1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #765
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #766
  {DBGFIELD("LODSL_LODSQ")        1, false, false, false, 80, 1, 13, 1,  0, 0}, // #767
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #768
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #769
  {DBGFIELD("VINSERTF128rm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #770
  {DBGFIELD("MMX_PADDQrm")        1, false, false, false, 100, 1,  5, 1,  0, 0}, // #771
  {DBGFIELD("VERRm_VERWm")        1, false, false, false, 40, 1,  4, 1,  0, 0}, // #772
  {DBGFIELD("FARJMP64m")          1, false, false, false, 1518, 2,  1, 1,  0, 0}, // #773
  {DBGFIELD("FNSTSWm")            1, false, false, false, 40, 1,  4, 1,  0, 0}, // #774
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 1, false, false, false, 40, 1,  4, 1,  0, 0}, // #775
  {DBGFIELD("CALL64m_RVMARKER_CALL64m_CALL64m_NT") 1, false, false, false, 1518, 2,  1, 1,  0, 0}, // #776
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 1, false, false, false, 1518, 2,  1, 1,  0, 0}, // #777
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int_VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 5, false, false, false, 1538, 3,  7, 1, 20, 1}, // #778
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, false, 100, 1,  5, 1,  0, 0}, // #779
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #780
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 1, false, false, false, 100, 1,  5, 1,  0, 0}, // #781
  {DBGFIELD("FARCALL64m")         1, false, false, false, 1518, 2,  1, 1,  0, 0}, // #782
  {DBGFIELD("CVTSD2SI64rm_CVTSD2SI64rm_Int_CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 4, false, false, false, 1538, 3,  9, 1,  0, 0}, // #783
  {DBGFIELD("CVTSS2SIrm_CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 4, false, false, false, 1541, 3,  9, 1,  0, 0}, // #784
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #785
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #786
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 1, false, false, false, 1522, 2,  1, 1, 18, 2}, // #787
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 1, false, false, false, 1530, 3, 14, 1,  0, 0}, // #788
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #789
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 1, false, false, false, 1544, 2, 14, 1,  0, 0}, // #790
  {DBGFIELD("MUL_F32m_MUL_F64m")  1, false, false, false, 1594, 2,  8, 1,  0, 0}, // #791
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 1, false, false, false, 1530, 3, 14, 1,  0, 0}, // #792
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 1, false, false, false, 1594, 2,  8, 1,  0, 0}, // #793
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 4, false, false, false, 1573, 3, 58, 1,  0, 0}, // #794
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 4, false, false, false, 1573, 3, 58, 1,  0, 0}, // #795
  {DBGFIELD("VZEROALL")           1, false, false, false, 40, 1,  4, 1,  0, 0}, // #796
  {DBGFIELD("VZEROUPPER")         1, false, false, false, 40, 1,  4, 1,  0, 0}, // #797
  {DBGFIELD("CLC")                1, false, false, false, 40, 1,  1, 1,  0, 0}, // #798
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #799
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #800
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #801
  {DBGFIELD("PXORrr_VPXORrr")     1, false, false, false, 40, 1,  1, 1,  0, 0}, // #802
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #803
  {DBGFIELD("PSUBQrr")            1, false, false, false, 80, 1, 13, 1,  0, 0}, // #804
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #805
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #806
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #807
  {DBGFIELD("SETCCr")             1, false, false, false, 40, 1,  1, 1,  0, 0}, // #808
  {DBGFIELD("SETCCm")             1, false, false, false, 80, 1, 13, 1,  0, 0}, // #809
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #810
  {DBGFIELD("RETI16_RETI32_RETI64") 1, false, false, false, 1530, 3,  1, 1,  0, 0}, // #811
  {DBGFIELD("LRETI16_LRETI32_LRETI64") 1, false, false, false, 1622, 1, 72, 1,  0, 0}, // #812
  {DBGFIELD("RDPMC")              1, false, false, false, 1613, 1, 49, 1,  0, 0}, // #813
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false, false, 40, 1,  4, 1,  0, 0}, // #814
  {DBGFIELD("FBLDm")              1, false, false, false, 40, 1,  4, 1,  0, 0}, // #815
  {DBGFIELD("FFREE_FFREEP")       1, false, false, false, 40, 1,  1, 1,  0, 0}, // #816
  {DBGFIELD("FSAVEm")             1, false, false, false, 40, 1,  4, 1,  0, 0}, // #817
  {DBGFIELD("FRSTORm")            1, false, false, false, 40, 1,  4, 1,  0, 0}, // #818
  {DBGFIELD("FXTRACT")            1, false, false, false, 1609, 1, 11, 1,  0, 0}, // #819
  {DBGFIELD("MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #820
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #821
  {DBGFIELD("VBROADCASTF128")     1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #822
  {DBGFIELD("VBROADCASTI128")     1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #823
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #824
  {DBGFIELD("FBSTPm")             1, false, false, false, 40, 1,  4, 1,  0, 0}, // #825
  {DBGFIELD("VMPTRSTm")           1, false, false, false, 40, 1,  4, 1,  0, 0}, // #826
  {DBGFIELD("ST_FP32m_ST_FP64m")  1, false, false, false, 80, 1, 13, 1,  0, 0}, // #827
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #828
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #829
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false, false, 40, 1,  1, 1,  0, 0}, // #830
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false, false, 1518, 2,  1, 1,  0, 0}, // #831
  {DBGFIELD("FINCSTP")            1, false, false, false, 40, 1,  1, 1,  0, 0}, // #832
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false, false, 40, 1,  1, 1,  0, 0}, // #833
  {DBGFIELD("VPBLENDDYrri")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #834
  {DBGFIELD("VPBLENDDrri")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #835
  {DBGFIELD("CMC_STC")            1, false, false, false, 40, 1,  1, 1,  0, 0}, // #836
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, false, 40, 1,  4, 1,  0, 0}, // #837
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 5, false, false, false, 1546, 3,  2, 1,  0, 0}, // #838
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #839
  {DBGFIELD("CVTSS2SDrm")         4, false, false, false, 1546, 3,  6, 1,  0, 0}, // #840
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 4, false, false, false, 1546, 3,  6, 1, 20, 1}, // #841
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #842
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #843
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #844
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #845
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 1, false, false, false, 1518, 2,  1, 1,  0, 0}, // #846
  {DBGFIELD("ANDN32rm_ANDN64rm")  1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #847
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #848
  {DBGFIELD("VINSERTI128rm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #849
  {DBGFIELD("VPBLENDDrmi")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #850
  {DBGFIELD("VPBLENDDYrmi")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #851
  {DBGFIELD("POP32r_POP64r")      1, false, false, false, 1530, 3,  1, 1,  0, 0}, // #852
  {DBGFIELD("SFENCE")             1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #853
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #854
  {DBGFIELD("MOVBE16mr")          1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #855
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 1, false, false, false, 1530, 3,  1, 1,  0, 0}, // #856
  {DBGFIELD("MFENCE")             1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #857
  {DBGFIELD("XGETBV")             1, false, false, false, 40, 1,  4, 1,  0, 0}, // #858
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 4, false, false, false, 1524, 3,  6, 1,  0, 0}, // #859
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 3, false, false, false, 1524, 3,  3, 1,  0, 0}, // #860
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm_MMX_PACKUSWBrm") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #861
  {DBGFIELD("LRET64_RET32")       1, false, false, false, 1622, 1, 72, 1,  0, 0}, // #862
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #863
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #864
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 3, false, false, false, 1524, 3,  3, 1,  0, 0}, // #865
  {DBGFIELD("VCVTDQ2PSYrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #866
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #867
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 4, false, false, false, 1546, 3,  6, 1,  0, 0}, // #868
  {DBGFIELD("VCVTDQ2PSYrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #869
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #870
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #871
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr_MMX_PACKUSWBrr") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #872
  {DBGFIELD("CLDEMOTE")           1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #873
  {DBGFIELD("CVTSD2SI64rr_CVTSD2SIrr_CVTTSD2SI64rr_CVTTSD2SIrr_VCVTSD2SI64rr_VCVTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 3, false, false, false, 1549, 3,  2, 1,  0, 0}, // #874
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 3, false, false, false, 1549, 3,  2, 1,  0, 0}, // #875
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 3, false, false, false, 1549, 3,  2, 1,  0, 0}, // #876
  {DBGFIELD("CVTSS2SIrr_CVTTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 3, false, false, false, 1549, 3,  2, 1,  0, 0}, // #877
  {DBGFIELD("VCVTPS2PDYrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #878
  {DBGFIELD("MMX_CVTPI2PDrr")     3, false, false, false, 1524, 3,  6, 1,  0, 0}, // #879
  {DBGFIELD("MMX_CVTPD2PIrr_MMX_CVTTPD2PIrr") 4, false, false, false, 1546, 3,  6, 1,  0, 0}, // #880
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 3, false, false, false, 1524, 3,  6, 1,  0, 0}, // #881
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 4, false, false, false, 1555, 3, 18, 1,  0, 0}, // #882
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 3, false, false, false, 1538, 3,  7, 1,  0, 0}, // #883
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 3, false, false, false, 1524, 3,  3, 1,  0, 1}, // #884
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 3, false, false, false, 1524, 3,  3, 1,  6, 1}, // #885
  {DBGFIELD("CVTSI2SSrr")         3, false, false, false, 1524, 3,  3, 1,  0, 1}, // #886
  {DBGFIELD("CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 3, false, false, false, 1524, 3,  3, 1,  6, 1}, // #887
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 4, false, false, false, 1546, 3,  6, 1,  0, 0}, // #888
  {DBGFIELD("VCVTSD2SI64rm_VCVTSD2SI64rm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 4, false, false, false, 1538, 3,  9, 1,  0, 0}, // #889
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int") 5, false, false, false, 1555, 3,  7, 1,  0, 0}, // #890
  {DBGFIELD("VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 4, false, false, false, 1541, 3,  9, 1,  0, 0}, // #891
  {DBGFIELD("VCVTPS2PDYrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #892
  {DBGFIELD("CVTPD2PSrm")         5, false, false, false, 1552, 3, 23, 1,  0, 0}, // #893
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIrm_MMX_CVTTPD2PIrm") 5, false, false, false, 1549, 3,  2, 1,  0, 0}, // #894
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 4, false, false, false, 1546, 3,  2, 1,  0, 0}, // #895
  {DBGFIELD("MMX_CVTPI2PDrm")     4, false, false, false, 1546, 3,  2, 1,  0, 0}, // #896
  {DBGFIELD("CVTSD2SSrm")         4, false, false, false, 1552, 3, 18, 1,  0, 0}, // #897
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_VCVTSD2SSrm_Int") 4, false, false, false, 1552, 3, 18, 1, 20, 1}, // #898
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #899
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 1, false, false, false, 40, 1,  4, 1,  0, 0}, // #900
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 1, false, false, false, 40, 1,  4, 1,  0, 0}, // #901
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, false, 1594, 2,  8, 1,  0, 0}, // #902
  {DBGFIELD("VPCMPGTQYrm")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #903
  {DBGFIELD("VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, false, 1524, 3,  3, 1,  6, 1}, // #904
  {DBGFIELD("STR16r_STR32r_STR64r") 1, false, false, false, 40, 1,  4, 1,  0, 0}, // #905
  {DBGFIELD("XSETBV")             1, false, false, false, 40, 1,  4, 1,  0, 0}, // #906
  {DBGFIELD("VCVTDQ2PDYrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #907
  {DBGFIELD("VCVTPD2PSYrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #908
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #909
  {DBGFIELD("VCVTDQ2PDYrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #910
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #911
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #912
  {DBGFIELD("RCL8rCL")            1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #913
  {DBGFIELD("RDTSC")              1, false, false, false, 1602, 1, 47, 1,  0, 0}, // #914
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 1, false, false, false, 40, 1,  4, 1,  0, 0}, // #915
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 3, false, false, false, 1573, 3, 58, 1,  0, 0}, // #916
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 4, false, false, false, 1573, 3, 58, 1,  0, 0}, // #917
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 4, false, false, false, 1573, 3, 58, 1,  0, 0}, // #918
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 3, false, false, false, 1573, 3, 58, 1,  0, 0}, // #919
  {DBGFIELD("XSAVE64")            1, false, false, false, 40, 1,  4, 1,  0, 0}, // #920
  {DBGFIELD("XSAVE")              1, false, false, false, 40, 1,  4, 1,  0, 0}, // #921
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 1, false, false, false, 40, 1,  4, 1,  0, 0}, // #922
  {DBGFIELD("VMCLEARm")           1, false, false, false, 40, 1,  4, 1,  0, 0}, // #923
  {DBGFIELD("FLDENVm")            1, false, false, false, 40, 1,  4, 1,  0, 0}, // #924
  {DBGFIELD("FXRSTOR64")          1, false, false, false, 1629, 1, 79, 1,  0, 0}, // #925
  {DBGFIELD("FSTENVm")            1, false, false, false, 40, 1,  4, 1,  0, 0}, // #926
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #927
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #928
  {DBGFIELD("VGATHERDPSrm_VPGATHERDDrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #929
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #930
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #931
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm_VGATHERQPSYrm_VPGATHERQDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #932
  {DBGFIELD("VGATHERQPSrm_VPGATHERQDrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #933
  {DBGFIELD("VPXORYrr")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #934
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #935
  {DBGFIELD("VPCMPGTQYrr")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #936
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #937
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #938
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 1, false, false, false, 1544, 2, 14, 1,  0, 0}, // #939
  {DBGFIELD("LRET64")             1, false, false, false, 1622, 1, 72, 1,  0, 0}, // #940
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 4, false, false, false, 1546, 3,  6, 1,  0, 0}, // #941
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 5, false, false, false, 1549, 3,  2, 1,  0, 0}, // #942
  {DBGFIELD("POPF64")             1, false, false, false, 1610, 1, 62, 1,  0, 0}, // #943
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #944
  {DBGFIELD("PCMPEQQrr")          1, false, false, false, 40, 1,  1, 1,  0, 0}, // #945
  {DBGFIELD("PCMPEQQrm")          1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #946
  {DBGFIELD("MOV16rm")            1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #947
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #948
  {DBGFIELD("POP16rmm")           1, false, false, false, 100, 1,  5, 1,  0, 0}, // #949
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #950
  {DBGFIELD("PUSHF16")            1, false, false, false, 1420, 1,  9, 1,  0, 0}, // #951
  {DBGFIELD("LAHF")               1, false, false, false, 80, 1, 13, 1,  0, 0}, // #952
  {DBGFIELD("ADD16mi_ADD16mi8_ADD32mi_ADD32mi8_ADD64mi32_ADD64mi8_ADD8mi_ADD8mi8_SUB16mi_SUB16mi8_SUB32mi_SUB32mi8_SUB64mi32_SUB64mi8_SUB8mi_SUB8mi8") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #953
  {DBGFIELD("ADD16mr_ADD32mr_ADD64mr_ADD8mr_SUB16mr_SUB32mr_SUB64mr_SUB8mr") 1, false, false, false, 1522, 2,  1, 1, 18, 1}, // #954
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #955
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #956
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 1, false, false, false, 1518, 2,  1, 1,  0, 0}, // #957
  {DBGFIELD("RET16_LRET16_LRET32") 1, false, false, false, 1622, 1, 72, 1,  0, 0}, // #958
  {DBGFIELD("IRET16_IRET32_IRET64") 1, false, false, false, 1530, 3,  1, 1,  0, 0}, // #959
  {DBGFIELD("AND16mi_AND16mi8_AND32mi_AND32mi8_AND64mi32_AND64mi8_AND8mi_AND8mi8_OR16mi_OR16mi8_OR32mi_OR32mi8_OR32mi8Locked_OR64mi32_OR64mi8_OR8mi_OR8mi8_XOR16mi_XOR16mi8_XOR32mi_XOR32mi8_XOR64mi32_XOR64mi8_XOR8mi_XOR8mi8") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #960
  {DBGFIELD("AND16mr_AND32mr_AND64mr_AND8mr_OR16mr_OR32mr_OR64mr_OR8mr_XOR16mr_XOR32mr_XOR64mr_XOR8mr") 1, false, false, false, 1522, 2,  1, 1, 18, 1}, // #961
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 1, false, false, false, 369, 1,  8, 1,  0, 0}, // #962
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #963
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 1, false, false, false, 369, 1,  8, 1,  0, 0}, // #964
  {DBGFIELD("MOVSLDUPrm")         1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #965
  {DBGFIELD("MOVSLDUPrr")         1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #966
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #967
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, false, 1518, 2,  1, 1,  0, 0}, // #968
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #969
  {DBGFIELD("VPBLENDWYrri")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #970
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #971
  {DBGFIELD("VPBLENDWYrmi")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #972
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #973
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #974
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #975
  {DBGFIELD("VPMASKMOVDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #976
  {DBGFIELD("VPMASKMOVDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #977
  {DBGFIELD("VPMASKMOVDYmr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #978
  {DBGFIELD("VPMASKMOVDmr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #979
  {DBGFIELD("VPMASKMOVQYmr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #980
  {DBGFIELD("VPMASKMOVQmr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #981
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #982
  {DBGFIELD("VPGATHERDDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #983
  {DBGFIELD("VPGATHERDDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #984
  {DBGFIELD("VPGATHERDQYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #985
  {DBGFIELD("VPGATHERDQrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #986
  {DBGFIELD("VPGATHERQDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #987
  {DBGFIELD("VPGATHERQDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #988
  {DBGFIELD("VPGATHERQQYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #989
  {DBGFIELD("VPGATHERQQrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #990
  {DBGFIELD("PSLLDQri_PSRLDQri_VPSLLDQri_VPSRLDQri") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #991
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #992
  {DBGFIELD("VPERM2F128rr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #993
  {DBGFIELD("VPERM2F128rm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #994
  {DBGFIELD("VEXTRACTF128rr")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #995
  {DBGFIELD("VEXTRACTF128mr")     1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #996
  {DBGFIELD("VINSERTF128rr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #997
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 5, false, false, false, 1549, 3,  2, 1,  0, 0}, // #998
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #999
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 3, false, false, false, 1549, 3,  2, 1,  0, 0}, // #1000
  {DBGFIELD("VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 4, false, false, false, 1541, 3,  9, 1,  0, 0}, // #1001
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1002
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1003
  {DBGFIELD("SHA256MSG2rm")       1, false, false, false, 1594, 2, 14, 1, 20, 1}, // #1004
  {DBGFIELD("SHA256MSG2rr")       1, false, false, false, 1594, 2, 14, 1,  0, 0}, // #1005
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, false, 1594, 2, 14, 1,  0, 0}, // #1006
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 1, false, false, false, 1594, 2, 14, 1, 20, 1}, // #1007
  {DBGFIELD("SHA1MSG2rr")         1, false, false, false, 1594, 2, 14, 1,  0, 0}, // #1008
  {DBGFIELD("SHA1MSG2rm")         1, false, false, false, 1594, 2, 14, 1, 20, 1}, // #1009
  {DBGFIELD("SHA1NEXTErr")        1, false, false, false, 1594, 2, 14, 1,  0, 0}, // #1010
  {DBGFIELD("SHA1NEXTErm")        1, false, false, false, 1594, 2, 14, 1, 20, 1}, // #1011
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, false, 1594, 2, 14, 1,  0, 0}, // #1012
  {DBGFIELD("SHA1RNDS4rmi")       1, false, false, false, 1594, 2, 14, 1, 20, 1}, // #1013
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, false, 1594, 2, 14, 1,  0, 0}, // #1014
  {DBGFIELD("SHA256RNDS2rm")      1, false, false, false, 1594, 2, 14, 1, 20, 1}, // #1015
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #1016
  {DBGFIELD("BT16mi8_BT32mi8_BT64mi8") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1017
  {DBGFIELD("BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 1, false, false, false, 1518, 2,  1, 1,  0, 0}, // #1018
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 3, false, false, false, 1524, 3,  3, 1,  0, 0}, // #1019
  {DBGFIELD("MOV8rm_MOV8rm_NOREX") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1020
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVZX16rm16") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1021
  {DBGFIELD("MOVBE16rm")          1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1022
  {DBGFIELD("ADD8i8_ADD16i16_ADD32i32_ADD64i32_AND8i8_AND16i16_AND32i32_AND64i32_OR8i8_OR16i16_OR32i32_OR64i32_SUB8i8_SUB16i16_SUB32i32_SUB64i32_XOR8i8_XOR16i16_XOR32i32_XOR64i32") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1023
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32_MOVZX16rr16") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1024
  {DBGFIELD("MOV32ri_MOV32ri_alt_MOV64ri32") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1025
  {DBGFIELD("ADC8mr_SBB8mr")      1, false, false, false, 1522, 2,  1, 1, 18, 2}, // #1026
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false, false, 1518, 2,  1, 1,  0, 0}, // #1027
  {DBGFIELD("LEA16r")             1, false, false, false, 1518, 2,  1, 1,  0, 0}, // #1028
  {DBGFIELD("LCMPXCHG8")          1, false, false, false, 1520, 2,  1, 1,  0, 0}, // #1029
  {DBGFIELD("LCMPXCHG16B")        1, false, false, false, 1520, 2,  1, 1,  0, 0}, // #1030
  {DBGFIELD("XCHG8rr_XCHG16rr_XCHG16ar") 1, false, false, false, 80, 1, 13, 1,  0, 0}, // #1031
  {DBGFIELD("XCHG8rm_XCHG16rm")   1, false, false, false, 100, 1,  5, 1,  0, 0}, // #1032
  {DBGFIELD("POPCNT16rr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1033
  {DBGFIELD("LZCNT16rr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1034
  {DBGFIELD("TZCNT16rr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1035
  {DBGFIELD("RCL8m1_RCL16m1_RCL32m1_RCL64m1_RCR8m1_RCR16m1_RCR32m1_RCR64m1") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1036
  {DBGFIELD("RCR8mi_RCR16mi_RCR32mi_RCR64mi") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1037
  {DBGFIELD("RCR16rCL_RCR32rCL_RCR64rCL") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1038
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1039
  {DBGFIELD("VEXTRACTI128rr")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1040
  {DBGFIELD("VEXTRACTI128mr")     1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1041
  {DBGFIELD("MMX_MOVQ2FR64rr")    1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1042
  {DBGFIELD("MMX_MOVD64rr_MMX_MOVD64to64rr") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1043
  {DBGFIELD("EXTRQ")              1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1044
  {DBGFIELD("INSERTQ")            1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1045
  {DBGFIELD("PABSBrr_PABSDrr_PABSWrr_PADDSBrr_PADDSWrr_PADDUSBrr_PADDUSWrr_PAVGBrr_PAVGWrr_PSIGNBrr_PSIGNDrr_PSIGNWrr_VPABSBrr_VPABSDrr_VPABSWrr_VPADDSBrr_VPADDSWrr_VPADDUSBrr_VPADDUSWrr_VPAVGBrr_VPAVGWrr_VPCMPEQQrr_VPSIGNBrr_VPSIGNDrr_VPSIGNWrr_PSUBSBrr_PSUBSWrr_PSUBUSBrr_PSUBUSWrr_VPSUBSBrr_VPSUBSWrr_VPSUBUSBrr_VPSUBUSWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1046
  {DBGFIELD("MMX_PADDSBrr_MMX_PADDSWrr_MMX_PADDUSBrr_MMX_PADDUSWrr_MMX_PAVGBrr_MMX_PAVGWrr_MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1047
  {DBGFIELD("VPABSBYrr_VPABSDYrr_VPABSWYrr_VPADDSBYrr_VPADDSWYrr_VPADDUSBYrr_VPADDUSWYrr_VPSUBSBYrr_VPSUBSWYrr_VPSUBUSBYrr_VPSUBUSWYrr_VPAVGBYrr_VPAVGWYrr_VPCMPEQQYrr_VPSIGNBYrr_VPSIGNDYrr_VPSIGNWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1048
  {DBGFIELD("SHA1MSG1rr")         1, false, false, false, 1594, 2, 14, 1,  0, 0}, // #1049
  {DBGFIELD("SHA1MSG1rm")         1, false, false, false, 1594, 2, 14, 1, 20, 1}, // #1050
  {DBGFIELD("VPERM2I128rr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1051
  {DBGFIELD("VPERMPSYrr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1052
  {DBGFIELD("VPERMPSYrm")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1053
  {DBGFIELD("VPERMPDYri")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1054
  {DBGFIELD("VPERMQYri")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1055
  {DBGFIELD("VPERMPDYmi")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1056
  {DBGFIELD("VPERMDYrr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1057
  {DBGFIELD("VPERMQYmi")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1058
  {DBGFIELD("VPERMDYrm")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1059
  {DBGFIELD("MOV32rr_MOV32rr_REV_MOV64rr_MOV64rr_REV") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1060
  {DBGFIELD("MOVSX32rr32")        1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1061
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV_SUB32rr_REV_SUB64rr_REV") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1062
  {DBGFIELD("CMP8rr_CMP8rr_REV_CMP16rr_CMP16rr_REV_CMP32rr_CMP32rr_REV_CMP64rr_CMP64rr_REV") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1063
  {DBGFIELD("VXORPSrr_VXORPDrr")  1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1064
  {DBGFIELD("VANDNPSrr_VANDNPDrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1065
  {DBGFIELD("VANDNPSYrr_VANDNPDYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1066
  {DBGFIELD("VPXORrr")            1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1067
  {DBGFIELD("VPANDNrr")           1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1068
  {DBGFIELD("VPANDNYrr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1069
  {DBGFIELD("VPSUBBrr_VPSUBWrr_VPSUBDrr_VPSUBQrr_VPCMPGTBrr_VPCMPGTWrr_VPCMPGTDrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1070
  {DBGFIELD("VPCMPGTQrr")         1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1071
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 1, false, false, false, 40, 1,  4, 1,  0, 0}, // #1072
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1073
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1074
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1075
  {DBGFIELD("ADC64ri32_SBB64ri32") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1076
  {DBGFIELD("CRC32r32r16")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1077
  {DBGFIELD("CRC32r32r32")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1078
  {DBGFIELD("CRC32r64r64")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1079
  {DBGFIELD("SAHF")               1, false, false, false, 80, 1, 13, 1,  0, 0}, // #1080
  {DBGFIELD("BEXTRI32ri_BEXTRI64ri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1081
  {DBGFIELD("BEXTRI32mi_BEXTRI64mi") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1082
  {DBGFIELD("RCR8ri")             1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1083
  {DBGFIELD("RCL16rCL")           1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1084
  {DBGFIELD("RCR16ri")            1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1085
  {DBGFIELD("RCR32rCL_RCR64rCL")  1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1086
  {DBGFIELD("RCL16ri")            1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1087
  {DBGFIELD("RCL32ri_RCL64ri")    1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1088
  {DBGFIELD("SHLD32rri8")         1, false, false, false, 80, 1, 13, 1,  0, 0}, // #1089
  {DBGFIELD("SHRD16rri8")         1, false, false, false, 1582, 1,  3, 1,  0, 0}, // #1090
  {DBGFIELD("SHLD16rrCL")         1, false, false, false, 1582, 1,  3, 1,  0, 0}, // #1091
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1092
  {DBGFIELD("TST_F")              1, false, false, false, 1420, 1,  9, 1,  0, 0}, // #1093
  {DBGFIELD("VDPPSrri")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1094
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr") 1, false, false, false, 1544, 2, 14, 1,  0, 0}, // #1095
  {DBGFIELD("VFRCZSDrr_VFRCZSSrr") 1, false, false, false, 1544, 2, 14, 1,  0, 0}, // #1096
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 1, false, false, false, 1544, 2, 14, 1, 20, 1}, // #1097
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1098
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1099
  {DBGFIELD("MMX_CVTTPD2PIrr")    4, false, false, false, 1546, 3,  6, 1,  0, 0}, // #1100
  {DBGFIELD("VMOVDQUYmr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1101
  {DBGFIELD("MOVDQArr")           1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1102
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1103
  {DBGFIELD("VMPSADBWrri")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1104
  {DBGFIELD("VPPERMrrr_VPPERMrrr_REV") 4, false, false, false, 1588, 3,  8, 1,  0, 0}, // #1105
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 3, false, false, false, 1546, 3,  6, 1,  0, 0}, // #1106
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 4, false, false, false, 1549, 3,  2, 1, 20, 1}, // #1107
  {DBGFIELD("VPCLMULQDQrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1108
  {DBGFIELD("ANDNPSrr_ANDNPDrr")  1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1109
  {DBGFIELD("MMX_PXORrr_MMX_PANDNrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1110
  {DBGFIELD("PANDNrr")            1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1111
  {DBGFIELD("MMX_PSUBBrr_MMX_PSUBDrr_MMX_PSUBWrr_MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1112
  {DBGFIELD("LCMPXCHG16_LCMPXCHG32_LCMPXCHG64") 1, false, false, false, 1520, 2,  1, 1,  0, 0}, // #1113
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 1, false, false, false, 1537, 1, 21, 1,  0, 0}, // #1114
  {DBGFIELD("LCMPXCHG8B")         1, false, false, false, 1520, 2,  1, 1,  0, 0}, // #1115
  {DBGFIELD("XCHG8rr")            1, false, false, false, 80, 1, 13, 1,  0, 0}, // #1116
  {DBGFIELD("MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1117
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1118
  {DBGFIELD("MMX_PCMPEQBrr_MMX_PCMPEQDrr_MMX_PCMPEQWrr_MMX_PMAXSWrr_MMX_PMINSWrr_MMX_PMAXUBrr_MMX_PMINUBrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1119
  {DBGFIELD("MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1120
  {DBGFIELD("CLAC_STAC")          1, false, false, false, 40, 1,  4, 1,  0, 0}, // #1121
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1122
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1123
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, false, 1518, 2, 14, 1,  0, 0}, // #1124
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 1, false, false, false, 1545, 1, 14, 1,  0, 0}, // #1125
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, false, 1546, 3,  6, 1,  0, 0}, // #1126
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1127
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1128
  {DBGFIELD("MMX_PADDSBrm_MMX_PADDSWrm_MMX_PADDUSBrm_MMX_PADDUSWrm_MMX_PAVGBrm_MMX_PAVGWrm_MMX_PCMPEQBrm_MMX_PCMPEQDrm_MMX_PCMPEQWrm_MMX_PCMPGTBrm_MMX_PCMPGTDrm_MMX_PCMPGTWrm_MMX_PMAXSWrm_MMX_PMAXUBrm_MMX_PMINSWrm_MMX_PMINUBrm_MMX_PSUBSBrm_MMX_PSUBSWrm_MMX_PSUBUSBrm_MMX_PSUBUSWrm") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #1129
  {DBGFIELD("CVTSS2SI64rr")       4, false, false, false, 1541, 3,  9, 1,  0, 0}, // #1130
  {DBGFIELD("CVTSS2SI64rr_Int")   4, false, false, false, 1541, 3,  9, 1,  0, 0}, // #1131
  {DBGFIELD("CVTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr") 3, false, false, false, 1549, 3,  2, 1,  0, 0}, // #1132
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 3, false, false, false, 1549, 3,  2, 1,  0, 0}, // #1133
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #1134
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1135
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 1, false, false, false, 1582, 1,  3, 1,  0, 0}, // #1136
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, false, 1549, 3,  2, 1, 20, 1}, // #1137
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1138
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 1, false, false, false, 40, 1,  4, 1,  0, 0}, // #1139
  {DBGFIELD("PCMPGTBrr_PCMPGTDrr_PCMPGTWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1140
  {DBGFIELD("VPCMPGTBrr_VPCMPGTDrr_VPCMPGTWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1141
  {DBGFIELD("VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1142
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1143
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1144
  {DBGFIELD("KSET0D_KSET0Q_KSET0W_KSET1D_KSET1Q_KSET1W") 1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1145
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1146
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1147
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1148
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1149
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1150
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1151
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1152
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1153
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1154
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1155
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1156
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1157
  {DBGFIELD("VPSADBWZrr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1158
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1159
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1160
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1161
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1162
  {DBGFIELD("VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1163
  {DBGFIELD("VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1164
  {DBGFIELD("VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1165
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1166
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1167
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 3, false, false, false, 1527, 3,  3, 1,  0, 0}, // #1168
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1169
  {DBGFIELD("VCMPPDZrri_VCMPPDZrrib_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrrib_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1170
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, false, 1518, 2, 14, 1,  0, 0}, // #1171
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rrik_VPCMPDZ128rri_VPCMPDZ128rrik_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rrik_VPCMPUBZ128rri_VPCMPUBZ128rrik_VPCMPUDZ128rri_VPCMPUDZ128rrik_VPCMPUQZ128rri_VPCMPUQZ128rrik_VPCMPUWZ128rri_VPCMPUWZ128rrik_VPCMPWZ128rri_VPCMPWZ128rrik") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1172
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rrik_VPCMPDZ256rri_VPCMPDZ256rrik_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rrik_VPCMPUBZ256rri_VPCMPUBZ256rrik_VPCMPUDZ256rri_VPCMPUDZ256rrik_VPCMPUQZ256rri_VPCMPUQZ256rrik_VPCMPUWZ256rri_VPCMPUWZ256rrik_VPCMPWZ256rri_VPCMPWZ256rrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1173
  {DBGFIELD("VPCMPBZrri_VPCMPBZrrik_VPCMPDZrri_VPCMPDZrrik_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrrik_VPCMPUBZrri_VPCMPUBZrrik_VPCMPUDZrri_VPCMPUDZrrik_VPCMPUQZrri_VPCMPUQZrrik_VPCMPUWZrri_VPCMPUWZrrik_VPCMPWZrri_VPCMPWZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1174
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1175
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1176
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 3, false, false, false, 1524, 3,  3, 1,  0, 0}, // #1177
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1178
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 4, false, false, false, 1546, 3,  6, 1,  0, 0}, // #1179
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1180
  {DBGFIELD("VCVTPS2DQYrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1181
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 3, false, false, false, 1524, 3,  3, 1,  0, 0}, // #1182
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1183
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 3, false, false, false, 1524, 3,  6, 1,  0, 0}, // #1184
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1185
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1186
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1187
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1188
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1189
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1190
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1191
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1192
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 3, false, false, false, 1524, 3,  6, 1,  0, 0}, // #1193
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 4, false, false, false, 1546, 3,  6, 1,  0, 0}, // #1194
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 4, false, false, false, 1555, 3, 18, 1,  0, 0}, // #1195
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 4, false, false, false, 1524, 3,  6, 1,  0, 0}, // #1196
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 3, false, false, false, 1524, 3,  3, 1,  0, 0}, // #1197
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 3, false, false, false, 1524, 3,  3, 1,  0, 0}, // #1198
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 3, false, false, false, 1538, 3,  7, 1,  0, 0}, // #1199
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 3, false, false, false, 1524, 3,  3, 1,  6, 1}, // #1200
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 3, false, false, false, 1524, 3,  3, 1,  6, 1}, // #1201
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 3, false, false, false, 1524, 3,  3, 1,  0, 0}, // #1202
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1203
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1204
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1205
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1206
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1207
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1208
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1209
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1210
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 3, false, false, false, 1524, 3,  3, 1,  6, 1}, // #1211
  {DBGFIELD("VMOVSDZrm_VMOVSDZrm_alt_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrm_alt_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1212
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1213
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1214
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1215
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1216
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1217
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1218
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1219
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1220
  {DBGFIELD("VCVTPD2PSZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1221
  {DBGFIELD("VCVTPS2PDZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1222
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1223
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1224
  {DBGFIELD("VMOVNTDQAZ128rm")    1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1225
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1226
  {DBGFIELD("VBROADCASTI32X2Z128rm_VBROADCASTI32X2Z128rmk_VBROADCASTI32X2Z128rmkz_VPBROADCASTDZ128rm_VPBROADCASTDZ128rmk_VPBROADCASTDZ128rmkz_VPBROADCASTQZ128rm_VPBROADCASTQZ128rmk_VPBROADCASTQZ128rmkz") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1227
  {DBGFIELD("VBROADCASTSSZ128rm_VBROADCASTSSZ128rmk_VBROADCASTSSZ128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1228
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1229
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1230
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1231
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #1232
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1233
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1234
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 3, false, false, false, 1549, 3,  2, 1,  0, 0}, // #1235
  {DBGFIELD("VCVTSS2SI64rr")      3, false, false, false, 1549, 3,  2, 1,  0, 0}, // #1236
  {DBGFIELD("VCVTSS2SI64rr_Int")  3, false, false, false, 1549, 3,  2, 1,  0, 0}, // #1237
  {DBGFIELD("VCVTTSS2SI64rr")     3, false, false, false, 1549, 3,  2, 1,  0, 0}, // #1238
  {DBGFIELD("VCVTTSS2SI64rr_Int") 3, false, false, false, 1549, 3,  2, 1,  0, 0}, // #1239
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1240
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1241
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1242
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1243
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1244
  {DBGFIELD("VSCATTERDPSZmr")     1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1245
  {DBGFIELD("VPBROADCASTBZ256rm_VPBROADCASTBZ256rmk_VPBROADCASTBZ256rmkz_VPBROADCASTBZrm_VPBROADCASTBZrmk_VPBROADCASTBZrmkz_VPBROADCASTWZ256rm_VPBROADCASTWZ256rmk_VPBROADCASTWZ256rmkz_VPBROADCASTWZrm_VPBROADCASTWZrmk_VPBROADCASTWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1246
  {DBGFIELD("VMOVNTDQAZ256rm")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1247
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1248
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1249
  {DBGFIELD("VBROADCASTF32X2Z256rm_VBROADCASTF32X2Z256rmk_VBROADCASTF32X2Z256rmkz_VBROADCASTF32X2Zrm_VBROADCASTF32X2Zrmk_VBROADCASTF32X2Zrmkz_VBROADCASTI32X2Z256rm_VBROADCASTI32X2Z256rmk_VBROADCASTI32X2Z256rmkz_VBROADCASTI32X2Zrm_VBROADCASTI32X2Zrmk_VBROADCASTI32X2Zrmkz_VPBROADCASTDZ256rm_VPBROADCASTDZ256rmk_VPBROADCASTDZ256rmkz_VPBROADCASTDZrm_VPBROADCASTDZrmk_VPBROADCASTDZrmkz_VPBROADCASTQZ256rm_VPBROADCASTQZ256rmk_VPBROADCASTQZ256rmkz_VPBROADCASTQZrm_VPBROADCASTQZrmk_VPBROADCASTQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1250
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1251
  {DBGFIELD("VBROADCASTSDZ256rm_VBROADCASTSDZ256rmk_VBROADCASTSDZ256rmkz_VBROADCASTSDZrm_VBROADCASTSDZrmk_VBROADCASTSDZrmkz_VBROADCASTSSZ256rm_VBROADCASTSSZ256rmk_VBROADCASTSSZ256rmkz_VBROADCASTSSZrm_VBROADCASTSSZrmk_VBROADCASTSSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1252
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1253
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1254
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1255
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1256
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1257
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1258
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1259
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1260
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1261
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1262
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1263
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1264
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1265
  {DBGFIELD("VPSCATTERDDZmr")     1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1266
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #1267
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 1, false, false, false, 1530, 3, 14, 1, 20, 1}, // #1268
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1269
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1270
  {DBGFIELD("VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #1271
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmik_VFPCLASSPDZ128rm_VFPCLASSPDZ128rmb_VFPCLASSPDZ128rmbk_VFPCLASSPDZ128rmk_VFPCLASSPSZ128rm_VFPCLASSPSZ128rmb_VFPCLASSPSZ128rmbk_VFPCLASSPSZ128rmk") 4, false, false, false, 1524, 3,  6, 1, 20, 1}, // #1272
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk") 1, false, false, false, 1530, 3, 14, 1, 20, 1}, // #1273
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmik_VPCMPDZ128rmi_VPCMPDZ128rmib_VPCMPDZ128rmibk_VPCMPDZ128rmik_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmib_VPCMPQZ128rmibk_VPCMPQZ128rmik_VPCMPUBZ128rmi_VPCMPUBZ128rmik_VPCMPUDZ128rmi_VPCMPUDZ128rmib_VPCMPUDZ128rmibk_VPCMPUDZ128rmik_VPCMPUQZ128rmi_VPCMPUQZ128rmib_VPCMPUQZ128rmibk_VPCMPUQZ128rmik_VPCMPUWZ128rmi_VPCMPUWZ128rmik_VPCMPWZ128rmi_VPCMPWZ128rmik") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #1274
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #1275
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1276
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1277
  {DBGFIELD("VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1278
  {DBGFIELD("VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1279
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmik_VFPCLASSPDZ256rm_VFPCLASSPDZ256rmb_VFPCLASSPDZ256rmbk_VFPCLASSPDZ256rmk_VFPCLASSPSZ256rm_VFPCLASSPSZ256rmb_VFPCLASSPSZ256rmbk_VFPCLASSPSZ256rmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1280
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmik_VFPCLASSPDZrm_VFPCLASSPDZrmb_VFPCLASSPDZrmbk_VFPCLASSPDZrmk_VFPCLASSPSZrm_VFPCLASSPSZrmb_VFPCLASSPSZrmbk_VFPCLASSPSZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1281
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmik_VPCMPDZ256rmi_VPCMPDZ256rmib_VPCMPDZ256rmibk_VPCMPDZ256rmik_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmib_VPCMPQZ256rmibk_VPCMPQZ256rmik_VPCMPUBZ256rmi_VPCMPUBZ256rmik_VPCMPUDZ256rmi_VPCMPUDZ256rmib_VPCMPUDZ256rmibk_VPCMPUDZ256rmik_VPCMPUQZ256rmi_VPCMPUQZ256rmib_VPCMPUQZ256rmibk_VPCMPUQZ256rmik_VPCMPUWZ256rmi_VPCMPUWZ256rmik_VPCMPWZ256rmi_VPCMPWZ256rmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1282
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmik_VPCMPDZrmi_VPCMPDZrmib_VPCMPDZrmibk_VPCMPDZrmik_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmib_VPCMPQZrmibk_VPCMPQZrmik_VPCMPUBZrmi_VPCMPUBZrmik_VPCMPUDZrmi_VPCMPUDZrmib_VPCMPUDZrmibk_VPCMPUDZrmik_VPCMPUQZrmi_VPCMPUQZrmib_VPCMPUQZrmibk_VPCMPUQZrmik_VPCMPUWZrmi_VPCMPUWZrmik_VPCMPWZrmi_VPCMPWZrmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1283
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1284
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1285
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 4, false, false, false, 1546, 3,  2, 1,  0, 0}, // #1286
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 4, false, false, false, 1546, 3,  6, 1,  0, 0}, // #1287
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 5, false, false, false, 1549, 3,  2, 1,  0, 0}, // #1288
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1289
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 4, false, false, false, 1546, 3,  6, 1,  0, 0}, // #1290
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 5, false, false, false, 1546, 3,  2, 1,  0, 0}, // #1291
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz") 4, false, false, false, 1546, 3,  6, 1, 20, 1}, // #1292
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1293
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1294
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1295
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1296
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1297
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1298
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1299
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1300
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1301
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1302
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1303
  {DBGFIELD("VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1304
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1305
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1306
  {DBGFIELD("VCVTSD2SSZrm_VCVTSD2SSZrm_Int_VCVTSD2SSZrm_Intk_VCVTSD2SSZrm_Intkz") 4, false, false, false, 1552, 3, 18, 1, 20, 1}, // #1307
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1308
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, false, 1594, 2, 14, 1,  0, 0}, // #1309
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1310
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1311
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1312
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 4, false, false, false, 1538, 3,  9, 1, 20, 1}, // #1313
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 4, false, false, false, 1541, 3,  9, 1, 20, 1}, // #1314
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1315
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1316
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1317
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1318
  {DBGFIELD("VCVTPD2PSZrm_VCVTPD2PSZrmb_VCVTPD2PSZrmbk_VCVTPD2PSZrmbkz_VCVTPD2PSZrmk_VCVTPD2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1319
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1320
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1321
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1322
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 1, false, false, false, 1594, 2, 14, 1, 20, 1}, // #1323
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1324
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1325
  {DBGFIELD("VGATHERQPSZ128rm_VPGATHERQDZ128rm_VGATHERDPDZ128rm_VPGATHERDQZ128rm_VGATHERQPDZ128rm_VPGATHERQQZ128rm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1326
  {DBGFIELD("VGATHERQPSZ256rm_VPGATHERQDZ256rm_VGATHERQPDZ256rm_VPGATHERQQZ256rm_VGATHERDPSZ128rm_VPGATHERDDZ128rm_VGATHERDPDZ256rm_VPGATHERDQZ256rm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1327
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm_VGATHERDPDZrm_VPGATHERDQZrm_VGATHERQPDZrm_VPGATHERQQZrm_VGATHERQPSZrm_VPGATHERQDZrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1328
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1329
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1330
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1331
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1332
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1333
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1334
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1335
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1336
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1337
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1338
  {DBGFIELD("VXORPSZ128rr_VXORPDZ128rr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1339
  {DBGFIELD("VXORPSZ256rr_VXORPDZ256rr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1340
  {DBGFIELD("VXORPSZrr_VXORPDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1341
  {DBGFIELD("VPXORDZ128rr_VPXORQZ128rr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1342
  {DBGFIELD("VPXORDZ256rr_VPXORQZ256rr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1343
  {DBGFIELD("VPXORDZrr_VPXORQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1344
  {DBGFIELD("VPSUBBZ128rr_VPSUBDZ128rr_VPSUBQZ128rr_VPSUBWZ128rr") 1, false, false, false, 40, 1,  1, 1,  0, 0}, // #1345
  {DBGFIELD("VPSUBBZ256rr_VPSUBDZ256rr_VPSUBQZ256rr_VPSUBWZ256rr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1346
  {DBGFIELD("VPSUBBZrr_VPSUBDZrr_VPSUBQZrr_VPSUBWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1347
  {DBGFIELD("VPBROADCASTDrr_VPBROADCASTQrr_PALIGNRrri_VPALIGNRZ128rri_VPALIGNRZ128rrik_VPALIGNRZ128rrikz_VPALIGNRrri_PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWZ128rr_VPACKSSDWZ128rrk_VPACKSSDWZ128rrkz_VPACKSSDWrr_VPACKSSWBZ128rr_VPACKSSWBZ128rrk_VPACKSSWBZ128rrkz_VPACKSSWBrr_VPACKUSDWZ128rr_VPACKUSDWZ128rrk_VPACKUSDWZ128rrkz_VPACKUSDWrr_VPACKUSWBZ128rr_VPACKUSWBZ128rrk_VPACKUSWBZ128rrkz_VPACKUSWBrr") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1348
  {DBGFIELD("INSERTPSrr_VINSERTPSZrr_VINSERTPSrr_MOVHLPSrr_MOVLHPSrr_VMOVHLPSZrr_VMOVHLPSrr_VMOVLHPSZrr_VMOVLHPSrr_MOVDDUPrr_VMOVDDUPZ128rr_VMOVDDUPZ128rrk_VMOVDDUPZ128rrkz_VMOVDDUPrr_VPERMILPDZ128ri_VPERMILPDZ128rik_VPERMILPDZ128rikz_VPERMILPDri_VPERMILPSZ128ri_VPERMILPSZ128rik_VPERMILPSZ128rikz_VPERMILPSri_UNPCKHPDrr_UNPCKHPSrr_UNPCKLPDrr_UNPCKLPSrr_VUNPCKHPDZ128rr_VUNPCKHPDZ128rrk_VUNPCKHPDZ128rrkz_VUNPCKHPDrr_VUNPCKHPSZ128rr_VUNPCKHPSZ128rrk_VUNPCKHPSZ128rrkz_VUNPCKHPSrr_VUNPCKLPDZ128rr_VUNPCKLPDZ128rrk_VUNPCKLPDZ128rrkz_VUNPCKLPDrr_VUNPCKLPSZ128rr_VUNPCKLPSZ128rrk_VUNPCKLPSZ128rrkz_VUNPCKLPSrr") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1349
  {DBGFIELD("VMOVDDUPYrr_VMOVDDUPZ256rr_VMOVDDUPZ256rrk_VMOVDDUPZ256rrkz_VPERMILPDYri_VPERMILPDZ256ri_VPERMILPDZ256rik_VPERMILPDZ256rikz_VPERMILPSYri_VPERMILPSZ256ri_VPERMILPSZ256rik_VPERMILPSZ256rikz_VUNPCKHPDYrr_VUNPCKHPDZ256rr_VUNPCKHPDZ256rrk_VUNPCKHPDZ256rrkz_VUNPCKHPSYrr_VUNPCKHPSZ256rr_VUNPCKHPSZ256rrk_VUNPCKHPSZ256rrkz_VUNPCKLPDYrr_VUNPCKLPDZ256rr_VUNPCKLPDZ256rrk_VUNPCKLPDZ256rrkz_VUNPCKLPSYrr_VUNPCKLPSZ256rr_VUNPCKLPSZ256rrk_VUNPCKLPSZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1350
  {DBGFIELD("VMOVDDUPZrr_VMOVDDUPZrrk_VMOVDDUPZrrkz_VPERMILPDZri_VPERMILPDZrik_VPERMILPDZrikz_VPERMILPSZri_VPERMILPSZrik_VPERMILPSZrikz_VUNPCKHPDZrr_VUNPCKHPDZrrk_VUNPCKHPDZrrkz_VUNPCKHPSZrr_VUNPCKHPSZrrk_VUNPCKHPSZrrkz_VUNPCKLPDZrr_VUNPCKLPDZrrk_VUNPCKLPDZrrkz_VUNPCKLPSZrr_VUNPCKLPSZrrk_VUNPCKLPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1351
  {DBGFIELD("VPALIGNRYrri_VPALIGNRZ256rri_VPALIGNRZ256rrik_VPALIGNRZ256rrikz_VPACKSSDWYrr_VPACKSSDWZ256rr_VPACKSSDWZ256rrk_VPACKSSDWZ256rrkz_VPACKSSWBYrr_VPACKSSWBZ256rr_VPACKSSWBZ256rrk_VPACKSSWBZ256rrkz_VPACKUSDWYrr_VPACKUSDWZ256rr_VPACKUSDWZ256rrk_VPACKUSDWZ256rrkz_VPACKUSWBYrr_VPACKUSWBZ256rr_VPACKUSWBZ256rrk_VPACKUSWBZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1352
  {DBGFIELD("VPALIGNRZrri_VPALIGNRZrrik_VPALIGNRZrrikz_VPACKSSDWZrr_VPACKSSDWZrrk_VPACKSSDWZrrkz_VPACKSSWBZrr_VPACKSSWBZrrk_VPACKSSWBZrrkz_VPACKUSDWZrr_VPACKUSDWZrrk_VPACKUSDWZrrkz_VPACKUSWBZrr_VPACKUSWBZrrk_VPACKUSWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1353
  {DBGFIELD("VPERMILPDYrr_VPERMILPDZ256rr_VPERMILPDZ256rrk_VPERMILPDZ256rrkz_VPERMILPSYrr_VPERMILPSZ256rr_VPERMILPSZ256rrk_VPERMILPSZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1354
  {DBGFIELD("VPERMILPDZ128rr_VPERMILPDZ128rrk_VPERMILPDZ128rrkz_VPERMILPDrr_VPERMILPSZ128rr_VPERMILPSZ128rrk_VPERMILPSZ128rrkz_VPERMILPSrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1355
  {DBGFIELD("VPERMILPDZrr_VPERMILPDZrrk_VPERMILPDZrrkz_VPERMILPSZrr_VPERMILPSZrrk_VPERMILPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1356
  {DBGFIELD("MOVSDrr_MOVSDrr_REV_VMOVSDZrr_VMOVSDZrr_REV_VMOVSDZrrk_VMOVSDZrrk_REV_VMOVSDZrrkz_VMOVSDZrrkz_REV_VMOVSDrr_VMOVSDrr_REV_VMOVSSZrr_VMOVSSZrr_REV_VMOVSSZrrk_VMOVSSZrrk_REV_VMOVSSZrrkz_VMOVSSZrrkz_REV_VMOVSSrr_VMOVSSrr_REV") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1357
  {DBGFIELD("VPBROADCASTBZ128rm_VPBROADCASTBZ128rmk_VPBROADCASTBZ128rmkz_VPBROADCASTWZ128rm_VPBROADCASTWZ128rmk_VPBROADCASTWZ128rmkz") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1358
  {DBGFIELD("INSERTPSrm_VINSERTPSZrm_VINSERTPSrm_UNPCKHPDrm_UNPCKHPSrm_UNPCKLPDrm_UNPCKLPSrm_VUNPCKHPDZ128rm_VUNPCKHPDZ128rmb_VUNPCKHPDZ128rmbk_VUNPCKHPDZ128rmbkz_VUNPCKHPDZ128rmk_VUNPCKHPDZ128rmkz_VUNPCKHPDrm_VUNPCKHPSZ128rm_VUNPCKHPSZ128rmb_VUNPCKHPSZ128rmbk_VUNPCKHPSZ128rmbkz_VUNPCKHPSZ128rmk_VUNPCKHPSZ128rmkz_VUNPCKHPSrm_VUNPCKLPDZ128rm_VUNPCKLPDZ128rmb_VUNPCKLPDZ128rmbk_VUNPCKLPDZ128rmbkz_VUNPCKLPDZ128rmk_VUNPCKLPDZ128rmkz_VUNPCKLPDrm_VUNPCKLPSZ128rm_VUNPCKLPSZ128rmb_VUNPCKLPSZ128rmbk_VUNPCKLPSZ128rmbkz_VUNPCKLPSZ128rmk_VUNPCKLPSZ128rmkz_VUNPCKLPSrm") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #1359
  {DBGFIELD("PALIGNRrmi_VPALIGNRZ128rmi_VPALIGNRZ128rmik_VPALIGNRZ128rmikz_VPALIGNRrmi_PACKSSDWrm_PACKSSWBrm_PACKUSDWrm_PACKUSWBrm_VPACKSSDWZ128rm_VPACKSSDWZ128rmb_VPACKSSDWZ128rmbk_VPACKSSDWZ128rmbkz_VPACKSSDWZ128rmk_VPACKSSDWZ128rmkz_VPACKSSDWrm_VPACKSSWBZ128rm_VPACKSSWBZ128rmk_VPACKSSWBZ128rmkz_VPACKSSWBrm_VPACKUSDWZ128rm_VPACKUSDWZ128rmb_VPACKUSDWZ128rmbk_VPACKUSDWZ128rmbkz_VPACKUSDWZ128rmk_VPACKUSDWZ128rmkz_VPACKUSDWrm_VPACKUSWBZ128rm_VPACKUSWBZ128rmk_VPACKUSWBZ128rmkz_VPACKUSWBrm") 1, false, false, false, 1522, 2,  1, 1, 20, 1}, // #1360
  {DBGFIELD("VPERMILPDZ128mbi_VPERMILPDZ128mbik_VPERMILPDZ128mbikz_VPERMILPDZ128mi_VPERMILPDZ128mik_VPERMILPDZ128mikz_VPERMILPDmi_VPERMILPSZ128mbi_VPERMILPSZ128mbik_VPERMILPSZ128mbikz_VPERMILPSZ128mi_VPERMILPSZ128mik_VPERMILPSZ128mikz_VPERMILPSmi") 1, false, false, false, 1522, 2,  1, 1,  0, 0}, // #1361
  {DBGFIELD("VPERMILPDZ128rm_VPERMILPDZ128rmb_VPERMILPDZ128rmbk_VPERMILPDZ128rmbkz_VPERMILPDZ128rmk_VPERMILPDZ128rmkz_VPERMILPDrm_VPERMILPSZ128rm_VPERMILPSZ128rmb_VPERMILPSZ128rmbk_VPERMILPSZ128rmbkz_VPERMILPSZ128rmk_VPERMILPSZ128rmkz_VPERMILPSrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1362
  {DBGFIELD("VPALIGNRYrmi_VPALIGNRZ256rmi_VPALIGNRZ256rmik_VPALIGNRZ256rmikz_VPACKSSDWYrm_VPACKSSDWZ256rm_VPACKSSDWZ256rmb_VPACKSSDWZ256rmbk_VPACKSSDWZ256rmbkz_VPACKSSDWZ256rmk_VPACKSSDWZ256rmkz_VPACKSSWBYrm_VPACKSSWBZ256rm_VPACKSSWBZ256rmk_VPACKSSWBZ256rmkz_VPACKUSDWYrm_VPACKUSDWZ256rm_VPACKUSDWZ256rmb_VPACKUSDWZ256rmbk_VPACKUSDWZ256rmbkz_VPACKUSDWZ256rmk_VPACKUSDWZ256rmkz_VPACKUSWBYrm_VPACKUSWBZ256rm_VPACKUSWBZ256rmk_VPACKUSWBZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1363
  {DBGFIELD("VPALIGNRZrmi_VPALIGNRZrmik_VPALIGNRZrmikz_VPACKSSDWZrm_VPACKSSDWZrmb_VPACKSSDWZrmbk_VPACKSSDWZrmbkz_VPACKSSDWZrmk_VPACKSSDWZrmkz_VPACKSSWBZrm_VPACKSSWBZrmk_VPACKSSWBZrmkz_VPACKUSDWZrm_VPACKUSDWZrmb_VPACKUSDWZrmbk_VPACKUSDWZrmbkz_VPACKUSDWZrmk_VPACKUSDWZrmkz_VPACKUSWBZrm_VPACKUSWBZrmk_VPACKUSWBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1364
  {DBGFIELD("VPERMILPDYmi_VPERMILPDZ256mbi_VPERMILPDZ256mbik_VPERMILPDZ256mbikz_VPERMILPDZ256mi_VPERMILPDZ256mik_VPERMILPDZ256mikz_VPERMILPSYmi_VPERMILPSZ256mbi_VPERMILPSZ256mbik_VPERMILPSZ256mbikz_VPERMILPSZ256mi_VPERMILPSZ256mik_VPERMILPSZ256mikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1365
  {DBGFIELD("VPERMILPDZmbi_VPERMILPDZmbik_VPERMILPDZmbikz_VPERMILPDZmi_VPERMILPDZmik_VPERMILPDZmikz_VPERMILPSZmbi_VPERMILPSZmbik_VPERMILPSZmbikz_VPERMILPSZmi_VPERMILPSZmik_VPERMILPSZmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1366
  {DBGFIELD("VPERMILPDYrm_VPERMILPDZ256rm_VPERMILPDZ256rmb_VPERMILPDZ256rmbk_VPERMILPDZ256rmbkz_VPERMILPDZ256rmk_VPERMILPDZ256rmkz_VPERMILPSYrm_VPERMILPSZ256rm_VPERMILPSZ256rmb_VPERMILPSZ256rmbk_VPERMILPSZ256rmbkz_VPERMILPSZ256rmk_VPERMILPSZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1367
  {DBGFIELD("VPERMILPDZrm_VPERMILPDZrmb_VPERMILPDZrmbk_VPERMILPDZrmbkz_VPERMILPDZrmk_VPERMILPDZrmkz_VPERMILPSZrm_VPERMILPSZrmb_VPERMILPSZrmbk_VPERMILPSZrmbkz_VPERMILPSZrmk_VPERMILPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1368
  {DBGFIELD("VUNPCKHPDYrm_VUNPCKHPDZ256rm_VUNPCKHPDZ256rmb_VUNPCKHPDZ256rmbk_VUNPCKHPDZ256rmbkz_VUNPCKHPDZ256rmk_VUNPCKHPDZ256rmkz_VUNPCKHPSYrm_VUNPCKHPSZ256rm_VUNPCKHPSZ256rmb_VUNPCKHPSZ256rmbk_VUNPCKHPSZ256rmbkz_VUNPCKHPSZ256rmk_VUNPCKHPSZ256rmkz_VUNPCKLPDYrm_VUNPCKLPDZ256rm_VUNPCKLPDZ256rmb_VUNPCKLPDZ256rmbk_VUNPCKLPDZ256rmbkz_VUNPCKLPDZ256rmk_VUNPCKLPDZ256rmkz_VUNPCKLPSYrm_VUNPCKLPSZ256rm_VUNPCKLPSZ256rmb_VUNPCKLPSZ256rmbk_VUNPCKLPSZ256rmbkz_VUNPCKLPSZ256rmk_VUNPCKLPSZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1369
  {DBGFIELD("VUNPCKHPDZrm_VUNPCKHPDZrmb_VUNPCKHPDZrmbk_VUNPCKHPDZrmbkz_VUNPCKHPDZrmk_VUNPCKHPDZrmkz_VUNPCKHPSZrm_VUNPCKHPSZrmb_VUNPCKHPSZrmbk_VUNPCKHPSZrmbkz_VUNPCKHPSZrmk_VUNPCKHPSZrmkz_VUNPCKLPDZrm_VUNPCKLPDZrmb_VUNPCKLPDZrmbk_VUNPCKLPDZrmbkz_VUNPCKLPDZrmk_VUNPCKLPDZrmkz_VUNPCKLPSZrm_VUNPCKLPSZrmb_VUNPCKLPSZrmbk_VUNPCKLPSZrmbkz_VUNPCKLPSZrmk_VUNPCKLPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1370
  {DBGFIELD("PdWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1371
  {DBGFIELD("WriteVecALU")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1372
  {DBGFIELD("JWriteZeroLatency")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1373
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1374
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1375
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1376
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1377
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1378
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1379
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1380
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1381
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1382
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1383
  {DBGFIELD("JWriteLOCK_CMPXCHG8B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1384
  {DBGFIELD("JWriteLOCK_CMPXCHG16B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1385
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1386
  {DBGFIELD("JWriteLOCK_CMPXCHGrm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1387
  {DBGFIELD("JWriteCMPXCHG8B")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1388
  {DBGFIELD("JWriteCMPXCHG16B")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1389
  {DBGFIELD("JWriteCMPXCHG8rm")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1390
  {DBGFIELD("WriteCMPXCHGRMW")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1391
  {DBGFIELD("JWriteCMPXCHG8rr")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1392
  {DBGFIELD("WriteCMPXCHG")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1393
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1394
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1395
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1396
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1397
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1398
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1399
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1400
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1401
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1402
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1403
  {DBGFIELD("JWriteLOCK_XADDrm_XCHG_Part_JWriteXCHGrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1404
  {DBGFIELD("JWriteXADDrm_XCHG_Part_JWriteXADDrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1405
  {DBGFIELD("SBWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1406
  {DBGFIELD("WriteALU")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1407
  {DBGFIELD("HWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1408
  {DBGFIELD("BWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1409
  {DBGFIELD("Zn3WriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1410
  {DBGFIELD("SKLWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1411
  {DBGFIELD("SKXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1412
  {DBGFIELD("ICXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1413
  {DBGFIELD("WriteFLogic")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1414
  {DBGFIELD("WriteFLogicY")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1415
  {DBGFIELD("JWriteZeroIdiomYmm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1416
  {DBGFIELD("WriteVecLogicX")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1417
  {DBGFIELD("WriteVecALUX")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1418
  {DBGFIELD("SKLWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1419
  {DBGFIELD("SKXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1420
  {DBGFIELD("ICXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1421
  {DBGFIELD("SBWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1422
  {DBGFIELD("HWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1423
  {DBGFIELD("BWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1424
  {DBGFIELD("SKLWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1425
  {DBGFIELD("SKXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1426
  {DBGFIELD("ICXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1427
  {DBGFIELD("SBWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1428
  {DBGFIELD("WriteCMOV")          0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1429
  {DBGFIELD("HWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1430
  {DBGFIELD("BWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1431
  {DBGFIELD("SKLWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1432
  {DBGFIELD("SKXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1433
  {DBGFIELD("ICXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1434
  {DBGFIELD("SBWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1435
  {DBGFIELD("WriteCMOVLd")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1436
  {DBGFIELD("HWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1437
  {DBGFIELD("BWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1438
  {DBGFIELD("PdWriteCMOVm")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1439
  {DBGFIELD("SKLWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1440
  {DBGFIELD("SKXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1441
  {DBGFIELD("ICXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1442
  {DBGFIELD("SBWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1443
  {DBGFIELD("WriteSETCC")         0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1444
  {DBGFIELD("HWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1445
  {DBGFIELD("BWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1446
  {DBGFIELD("SKLWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1447
  {DBGFIELD("SKXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1448
  {DBGFIELD("ICXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1449
  {DBGFIELD("SBWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1450
  {DBGFIELD("WriteSETCCStore")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1451
  {DBGFIELD("HWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1452
  {DBGFIELD("BWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1453
  {DBGFIELD("PdWriteSETGEmSETGmSETLEmSETLm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1454
  {DBGFIELD("SKLWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1455
  {DBGFIELD("SKXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1456
  {DBGFIELD("ICXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1457
  {DBGFIELD("WriteVecLogicY")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1458
  {DBGFIELD("WriteVecALUY")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1459
  {DBGFIELD("HWWriteADC0")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1460
  {DBGFIELD("WriteADC")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1461
  {DBGFIELD("JWriteLOCK_ALURMW")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1462
  {DBGFIELD("WriteALURMW")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1463
  {DBGFIELD("WriteFShuffle256")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1464
  {DBGFIELD("Zn3Write3OpsLEA")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1465
  {DBGFIELD("WriteLEA")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1466
  {DBGFIELD("PdWrite3OpsLEA")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1467
  {DBGFIELD("JWrite3OpsLEA")      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1468
  {DBGFIELD("WriteVecLogic")      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1469
  {DBGFIELD("WriteFLogicZ")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1470
  {DBGFIELD("WriteVecLogicZ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1471
}; // AtomModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc BdVer2ModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, false, 1638, 3, 13, 1,  0, 0}, // #3
  {DBGFIELD("WriteJump")          1, false, false, false, 1641, 4,  1, 1,  0, 0}, // #4
  {DBGFIELD("WriteCMPXCHGRMW")    2, false, false, false, 1645, 6,  5, 1,  0, 0}, // #5
  {DBGFIELD("WriteJumpLd")        1, false, false, false, 1651, 6, 14, 1,  0, 0}, // #6
  {DBGFIELD("WriteMove")          1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteADC")           1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteSHDrri")        6, false, false, false, 1659, 2,  5, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreX")       1, false, false, false, 1661, 5,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteFLoadX")        1, false, false, false, 1666, 5, 14, 1,  0, 0}, // #12
  {DBGFIELD("WriteFStoreY")       4, false, false, false, 1671, 5,  1, 1,  0, 0}, // #13
  {DBGFIELD("WriteFLoadY")        2, false, false, false, 1666, 5, 14, 1,  0, 0}, // #14
  {DBGFIELD("WriteMicrocoded")    1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #15
  {DBGFIELD("WriteFSign")         1, false, false, false, 1676, 4,  1, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCRMW")        2, false, false, false, 1680, 5,  3, 1,  0, 0}, // #17
  {DBGFIELD("WriteADCRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 1680, 5,  3, 1, 24, 2}, // #18
  {DBGFIELD("WriteADCLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 1685, 4, 14, 1, 26, 2}, // #19
  {DBGFIELD("WriteALURMW")        1, false, false, false, 1680, 5,  3, 1,  0, 0}, // #20
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 1680, 5,  3, 1, 24, 1}, // #21
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false, false, 1685, 4, 14, 1, 26, 1}, // #22
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 1, false, false, false, 1689, 6,  7, 1,  3, 1}, // #23
  {DBGFIELD("WriteFAdd64X")       1, false, false, false, 1690, 4, 14, 1,  0, 0}, // #24
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 1, false, false, false, 1689, 6,  7, 1,  3, 1}, // #25
  {DBGFIELD("WriteFAddX")         1, false, false, false, 1690, 4, 14, 1,  0, 0}, // #26
  {DBGFIELD("WriteNop")           1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 1, false, false, false, 1689, 6,  7, 1,  3, 1}, // #28
  {DBGFIELD("WriteFAdd64")        1, false, false, false, 1690, 4, 14, 1,  0, 0}, // #29
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 1, false, false, false, 1689, 6,  7, 1,  3, 1}, // #30
  {DBGFIELD("WriteFAdd")          1, false, false, false, 1690, 4, 14, 1,  0, 0}, // #31
  {DBGFIELD("WriteFAddLd")        1, false, false, false, 1689, 6,  7, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 2, false, false, false, 1695, 6, 10, 1,  3, 1}, // #33
  {DBGFIELD("WriteAESDecEnc")     2, false, false, false, 1696, 4,  9, 1,  0, 0}, // #34
  {DBGFIELD("WriteAESIMCLd")      1, false, false, false, 1695, 6,  7, 1,  0, 0}, // #35
  {DBGFIELD("WriteAESIMC")        1, false, false, false, 1696, 4, 14, 1,  0, 0}, // #36
  {DBGFIELD("WriteAESKeyGenLd")   1, false, false, false, 1695, 6,  7, 1,  0, 0}, // #37
  {DBGFIELD("WriteAESKeyGen")     1, false, false, false, 1696, 4, 14, 1,  0, 0}, // #38
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 1, false, false, false, 1701, 5,  6, 1,  3, 1}, // #39
  {DBGFIELD("WriteFLogic")        1, false, false, false, 1702, 3, 13, 1,  0, 0}, // #40
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 1685, 4,  3, 1, 24, 1}, // #41
  {DBGFIELD("WriteBEXTR")         2, false, false, false, 1636, 2, 13, 1,  0, 0}, // #42
  {DBGFIELD("WriteBEXTRLd")       2, false, false, false, 1685, 4,  3, 1,  0, 0}, // #43
  {DBGFIELD("WriteALULd")         1, false, false, false, 1685, 4, 14, 1,  0, 0}, // #44
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 1, false, false, false, 1666, 5,  6, 1,  3, 1}, // #45
  {DBGFIELD("WriteFBlend")        1, false, false, false, 1667, 3, 13, 1,  0, 0}, // #46
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 1, false, false, false, 1666, 5,  6, 1,  3, 1}, // #47
  {DBGFIELD("WriteFVarBlend")     1, false, false, false, 1667, 3, 13, 1,  0, 0}, // #48
  {DBGFIELD("WriteBLSLd")         2, false, false, false, 1685, 4,  3, 1,  0, 0}, // #49
  {DBGFIELD("WriteBLS")           2, false, false, false, 1636, 2, 13, 1,  0, 0}, // #50
  {DBGFIELD("WriteBSFLd")         8, false, false, false, 1706, 4,  6, 1,  0, 0}, // #51
  {DBGFIELD("WriteBSF")           6, false, false, false, 1659, 2,  5, 1,  0, 0}, // #52
  {DBGFIELD("WriteBSRLd")         9, false, false, false, 1710, 4,  2, 1,  0, 0}, // #53
  {DBGFIELD("WriteBSR")           7, false, false, false, 1711, 2,  8, 1,  0, 0}, // #54
  {DBGFIELD("WriteBSWAP32")       1, false, false, false, 1657, 2,  1, 1,  0, 0}, // #55
  {DBGFIELD("WriteBSWAP64")       1, false, false, false, 1657, 2,  1, 1,  0, 0}, // #56
  {DBGFIELD("WriteBitTestImmLd")  1, false, false, false, 1685, 4, 14, 1,  0, 0}, // #57
  {DBGFIELD("WriteBitTestRegLd")  7, false, false, false, 1714, 4, 14, 1,  0, 0}, // #58
  {DBGFIELD("WriteBitTest")       1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #59
  {DBGFIELD("WriteBitTestSetImmRMW") 4, false, false, false, 1718, 4,  6, 1,  0, 0}, // #60
  {DBGFIELD("WriteBitTestSetRegRMW") 10, false, false, false, 1722, 4,  6, 1,  0, 0}, // #61
  {DBGFIELD("WriteBitTestSet")    2, false, false, false, 1636, 2, 13, 1,  0, 0}, // #62
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 1726, 4, 14, 1, 24, 1}, // #63
  {DBGFIELD("WriteBZHI")          1, false, false, false, 1657, 2,  1, 1,  0, 0}, // #64
  {DBGFIELD("WriteLoad")          1, false, false, false, 1730, 2, 14, 1,  0, 0}, // #65
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 1, false, false, false, 1726, 4, 14, 1, 26, 1}, // #66
  {DBGFIELD("WriteCMOV")          1, false, false, false, 1657, 2,  1, 1,  0, 0}, // #67
  {DBGFIELD("WriteFCMOV")         1, false, false, false, 1690, 4,  1, 1,  0, 0}, // #68
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 1685, 4, 14, 1, 24, 1}, // #69
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 1, false, false, false, 1689, 6,  6, 1,  3, 1}, // #70
  {DBGFIELD("WriteFCmp64X")       1, false, false, false, 1690, 4, 13, 1,  0, 0}, // #71
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 1, false, false, false, 1689, 6,  6, 1,  3, 1}, // #72
  {DBGFIELD("WriteFCmpX")         1, false, false, false, 1690, 4, 13, 1,  0, 0}, // #73
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 1, false, false, false, 1689, 6,  6, 1,  3, 1}, // #74
  {DBGFIELD("WriteFCmp64")        1, false, false, false, 1690, 4, 13, 1,  0, 0}, // #75
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 1, false, false, false, 1689, 6,  6, 1,  3, 1}, // #76
  {DBGFIELD("WriteFCmp")          1, false, false, false, 1690, 4, 13, 1,  0, 0}, // #77
  {DBGFIELD("WriteCMPXCHG")       5, false, false, false, 1732, 3,  5, 1,  0, 0}, // #78
  {DBGFIELD("WriteFComXLd_ReadAfterVecLd") 2, false, false, false, 1735, 9,  3, 1,  3, 1}, // #79
  {DBGFIELD("WriteFComX")         2, false, false, false, 1736, 7,  1, 1,  0, 0}, // #80
  {DBGFIELD("WriteFCom")          2, false, false, false, 1736, 7,  1, 1,  0, 0}, // #81
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 3, false, false, false, 1744, 4,  3, 1, 26, 1}, // #82
  {DBGFIELD("WriteCRC32")         3, false, false, false, 1745, 2, 13, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtI2PDLd")     2, false, false, false, 1748, 7, 22, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtI2PD")       2, false, false, false, 1749, 5,  2, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtI2PSLd")     1, false, false, false, 1748, 7,  9, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtI2PS")       1, false, false, false, 1749, 5,  8, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtPD2ILd")     2, false, false, false, 1748, 7, 22, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtPD2I")       2, false, false, false, 1749, 5,  2, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtPD2PSLd")    2, false, false, false, 1748, 7, 22, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPD2PS")      2, false, false, false, 1749, 5,  2, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPS2ILd")     1, false, false, false, 1748, 7,  9, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtPS2I")       1, false, false, false, 1749, 5,  8, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, false, 1748, 7, 22, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtPS2PD")      2, false, false, false, 1749, 5,  2, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtSD2ILd")     2, false, false, false, 1755, 11, 31, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 2, false, false, false, 1756, 9, 22, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtSD2I")       2, false, false, false, 1756, 9, 22, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtSD2SSLd")    1, false, false, false, 1766, 7,  9, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 1, false, false, false, 1766, 7,  9, 1,  3, 1}, // #100
  {DBGFIELD("WriteCvtSD2SS")      1, false, false, false, 1767, 5,  8, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, false, 1748, 7,  9, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 2, false, false, false, 1748, 7,  9, 1,  3, 1}, // #103
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 2, false, false, false, 1749, 5,  8, 1, 28, 1}, // #104
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 2, false, false, false, 1749, 5,  8, 1, 29, 1}, // #105
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, false, 1748, 7,  9, 1,  0, 0}, // #106
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 2, false, false, false, 1748, 7,  9, 1,  3, 1}, // #107
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 2, false, false, false, 1749, 5,  8, 1, 28, 1}, // #108
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 2, false, false, false, 1749, 5,  8, 1, 29, 1}, // #109
  {DBGFIELD("WriteCvtSS2SDLd")    1, false, false, false, 1766, 7,  9, 1,  0, 0}, // #110
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 1, false, false, false, 1766, 7,  9, 1,  3, 1}, // #111
  {DBGFIELD("WriteCvtSS2SD")      1, false, false, false, 1767, 5,  8, 1,  0, 0}, // #112
  {DBGFIELD("WriteCvtSS2ILd")     2, false, false, false, 1755, 11, 31, 1,  0, 0}, // #113
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 2, false, false, false, 1756, 9, 22, 1,  0, 0}, // #114
  {DBGFIELD("WriteCvtSS2I")       2, false, false, false, 1756, 9, 22, 1,  0, 0}, // #115
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 1773, 6, 20, 1, 24, 2}, // #116
  {DBGFIELD("WriteDiv16")         2, false, false, false, 1774, 4, 21, 1,  0, 0}, // #117
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 1779, 6, 31, 1, 24, 2}, // #118
  {DBGFIELD("WriteDiv32")         2, false, false, false, 1780, 4, 10, 1,  0, 0}, // #119
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 1779, 6, 31, 1, 24, 2}, // #120
  {DBGFIELD("WriteDiv64")         2, false, false, false, 1780, 4, 10, 1,  0, 0}, // #121
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, false, 1785, 6, 19, 1, 24, 2}, // #122
  {DBGFIELD("WriteDiv8")          1, false, false, false, 1786, 4, 23, 1,  0, 0}, // #123
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 1, false, false, false, 1791, 6, 10, 1,  3, 1}, // #124
  {DBGFIELD("WriteFDiv64X")       1, false, false, false, 1792, 4,  9, 1,  0, 0}, // #125
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 1, false, false, false, 1791, 6, 10, 1,  3, 1}, // #126
  {DBGFIELD("WriteFDivX")         1, false, false, false, 1792, 4,  9, 1,  0, 0}, // #127
  {DBGFIELD("WriteFDivLd")        1, false, false, false, 1791, 6, 10, 1,  0, 0}, // #128
  {DBGFIELD("WriteFDiv")          1, false, false, false, 1792, 4,  9, 1,  0, 0}, // #129
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 1, false, false, false, 1791, 6, 10, 1,  3, 1}, // #130
  {DBGFIELD("WriteFDiv64")        1, false, false, false, 1792, 4,  9, 1,  0, 0}, // #131
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 1, false, false, false, 1791, 6, 10, 1,  3, 1}, // #132
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 17, false, false, false, 1797, 6, 12, 1,  3, 1}, // #133
  {DBGFIELD("WriteDPPD")          15, false, false, false, 1798, 4, 21, 1,  0, 0}, // #134
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 18, false, false, false, 1803, 6, 47, 1,  3, 1}, // #135
  {DBGFIELD("WriteDPPS")          16, false, false, false, 1804, 4, 11, 1,  0, 0}, // #136
  {DBGFIELD("WriteStore")         1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #137
  {DBGFIELD("WriteVecExtractSt")  2, false, false, false, 1811, 6, 22, 1,  0, 0}, // #138
  {DBGFIELD("WriteVecExtract")    2, false, false, false, 1817, 7, 23, 1,  0, 0}, // #139
  {DBGFIELD("WriteVecALUX")       1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #140
  {DBGFIELD("WriteFComLd")        2, false, false, false, 1735, 9,  3, 1,  0, 0}, // #141
  {DBGFIELD("WriteEMMS")          1, false, false, false, 1827, 3, 13, 1,  0, 0}, // #142
  {DBGFIELD("WriteFLDC")          1, false, false, false, 1830, 4,  5, 1,  0, 0}, // #143
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 1, false, false, false, 1834, 5,  6, 1,  3, 1}, // #144
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 4, false, false, false, 1839, 6, 19, 1,  3, 1}, // #145
  {DBGFIELD("WriteFHAdd")         3, false, false, false, 1840, 4, 18, 1,  0, 0}, // #146
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 1845, 6, 20, 1, 24, 2}, // #147
  {DBGFIELD("WriteIDiv16")        2, false, false, false, 1846, 4, 21, 1,  0, 0}, // #148
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 1851, 6, 31, 1, 24, 2}, // #149
  {DBGFIELD("WriteIDiv32")        2, false, false, false, 1852, 4, 10, 1,  0, 0}, // #150
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 1779, 6, 31, 1, 24, 2}, // #151
  {DBGFIELD("WriteIDiv64")        2, false, false, false, 1780, 4, 10, 1,  0, 0}, // #152
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, false, 1785, 6, 19, 1, 24, 2}, // #153
  {DBGFIELD("WriteIDiv8")         1, false, false, false, 1786, 4, 23, 1,  0, 0}, // #154
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 1857, 6,  2, 1, 24, 2}, // #155
  {DBGFIELD("WriteIMul16")        2, false, false, false, 1863, 4,  8, 1,  0, 0}, // #156
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 1, false, false, false, 1867, 6,  2, 1, 26, 1}, // #157
  {DBGFIELD("WriteIMul16ImmLd")   2, false, false, false, 1857, 6,  9, 1,  0, 0}, // #158
  {DBGFIELD("WriteIMul16Reg")     1, false, false, false, 1873, 4,  8, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul16Imm")     2, false, false, false, 1863, 4, 14, 1,  0, 0}, // #160
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, false, 1877, 6,  2, 1, 24, 2}, // #161
  {DBGFIELD("WriteIMul32")        1, false, false, false, 1883, 4,  8, 1,  0, 0}, // #162
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 1, false, false, false, 1867, 6,  2, 1, 26, 1}, // #163
  {DBGFIELD("WriteIMul32ImmLd")   2, false, false, false, 1867, 6,  2, 1,  0, 0}, // #164
  {DBGFIELD("WriteIMul32Reg")     1, false, false, false, 1873, 4,  8, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul32Imm")     1, false, false, false, 1873, 4,  8, 1,  0, 0}, // #166
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, false, 1887, 6,  7, 1, 24, 2}, // #167
  {DBGFIELD("WriteIMul64")        1, false, false, false, 1893, 4,  3, 1,  0, 0}, // #168
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 1, false, false, false, 1877, 6,  7, 1, 26, 1}, // #169
  {DBGFIELD("WriteIMul64ImmLd")   2, false, false, false, 1877, 6,  7, 1,  0, 0}, // #170
  {DBGFIELD("WriteIMul64Reg")     1, false, false, false, 1883, 4,  3, 1,  0, 0}, // #171
  {DBGFIELD("WriteIMul64Imm")     1, false, false, false, 1883, 4,  3, 1,  0, 0}, // #172
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, false, 1877, 6,  2, 1, 24, 2}, // #173
  {DBGFIELD("WriteIMul8")         1, false, false, false, 1883, 4,  8, 1,  0, 0}, // #174
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 1, false, false, false, 1701, 5,  6, 1,  3, 1}, // #175
  {DBGFIELD("WriteFShuffle")      1, false, false, false, 1702, 3, 13, 1,  0, 0}, // #176
  {DBGFIELD("WriteVecLogicX")     1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #177
  {DBGFIELD("WriteShuffle")       1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #178
  {DBGFIELD("WriteLAHFSAHF")      2, false, false, false, 1745, 2, 13, 1,  0, 0}, // #179
  {DBGFIELD("WriteVecLoadX")      1, false, false, false, 1897, 5, 14, 1,  0, 0}, // #180
  {DBGFIELD("WriteLDMXCSR")       1, false, false, false, 1902, 2, 14, 1,  0, 0}, // #181
  {DBGFIELD("WriteFLD0")          1, false, false, false, 1830, 4,  5, 1,  0, 0}, // #182
  {DBGFIELD("WriteFLD1")          1, false, false, false, 1830, 4,  5, 1,  0, 0}, // #183
  {DBGFIELD("WriteLEA")           1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #184
  {DBGFIELD("WriteFence")         1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteLZCNTLd")       2, false, false, false, 1904, 5,  3, 1,  0, 0}, // #186
  {DBGFIELD("WriteLZCNT")         2, false, false, false, 1905, 3, 13, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecStoreX")     1, false, false, false, 1661, 5,  1, 1,  0, 0}, // #188
  {DBGFIELD("WriteVecStore")      1, false, false, false, 1661, 5, 13, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, false, 1736, 7, 18, 1,  0, 0}, // #190
  {DBGFIELD("WriteVecLoad")       1, false, false, false, 1897, 5, 14, 1,  0, 0}, // #191
  {DBGFIELD("WriteVecMoveFromGpr") 2, false, false, false, 1702, 3, 18, 1,  0, 0}, // #192
  {DBGFIELD("WriteVecMoveX")      1, false, false, false, 1824, 3,  1, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecStoreNT")    1, false, false, false, 1909, 6, 13, 1,  0, 0}, // #194
  {DBGFIELD("WriteVecMove")       1, false, false, false, 1638, 3, 13, 1,  0, 0}, // #195
  {DBGFIELD("WriteVecALULd")      1, false, false, false, 1915, 5,  6, 1,  0, 0}, // #196
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 1, false, false, false, 1834, 5,  6, 1,  3, 1}, // #197
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 1, false, false, false, 1915, 5,  6, 1,  3, 1}, // #198
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 1, false, false, false, 1915, 5,  6, 1,  3, 1}, // #199
  {DBGFIELD("WriteVecLogic")      1, false, false, false, 1638, 3, 13, 1,  0, 0}, // #200
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, false, 1920, 5,  7, 1,  3, 1}, // #201
  {DBGFIELD("WritePHAdd")         3, false, false, false, 1921, 3, 14, 1,  0, 0}, // #202
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, false, 1920, 5,  3, 1, 26, 1}, // #203
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 2, false, false, false, 1898, 3, 13, 1, 29, 1}, // #204
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 1, false, false, false, 1695, 6,  9, 1,  3, 1}, // #205
  {DBGFIELD("WriteVecIMul")       1, false, false, false, 1696, 4,  8, 1,  0, 0}, // #206
  {DBGFIELD("WriteMMXMOVMSK")     2, false, false, false, 1736, 7,  7, 1,  0, 0}, // #207
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 2, false, false, false, 1834, 5,  9, 1,  3, 1}, // #208
  {DBGFIELD("WritePSADBW")        2, false, false, false, 1824, 3,  8, 1,  0, 0}, // #209
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 1, false, false, false, 1834, 5,  2, 1,  3, 1}, // #210
  {DBGFIELD("WriteVarShuffle")    1, false, false, false, 1824, 3,  5, 1,  0, 0}, // #211
  {DBGFIELD("WriteShuffleLd")     1, false, false, false, 1834, 5,  6, 1,  0, 0}, // #212
  {DBGFIELD("WriteVecShiftImm")   1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 1, false, false, false, 1834, 5,  2, 1,  3, 1}, // #214
  {DBGFIELD("WriteVecShift")      1, false, false, false, 1824, 3,  5, 1,  0, 0}, // #215
  {DBGFIELD("WriteFMoveX")        1, false, false, false, 1702, 3,  1, 1,  0, 0}, // #216
  {DBGFIELD("WriteFShuffleLd")    1, false, false, false, 1701, 5,  6, 1,  0, 0}, // #217
  {DBGFIELD("WriteFStore")        1, false, false, false, 1661, 5, 13, 1,  0, 0}, // #218
  {DBGFIELD("WriteFMOVMSK")       2, false, false, false, 1736, 7, 23, 1,  0, 0}, // #219
  {DBGFIELD("WriteVecLoadNT")     1, false, false, false, 1920, 5, 14, 1,  0, 0}, // #220
  {DBGFIELD("WriteStoreNT")       1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #221
  {DBGFIELD("WriteFStoreNTX")     1, false, false, false, 1909, 6,  5, 1,  0, 0}, // #222
  {DBGFIELD("WriteFStoreNT")      1, false, false, false, 1909, 6,  5, 1,  0, 0}, // #223
  {DBGFIELD("WriteFLoad")         1, false, false, false, 1666, 5, 14, 1,  0, 0}, // #224
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 8, false, false, false, 1925, 6, 10, 1,  3, 1}, // #225
  {DBGFIELD("WriteMPSAD")         8, false, false, false, 1926, 4,  9, 1,  0, 0}, // #226
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 1, false, false, false, 1931, 6,  7, 1,  3, 1}, // #227
  {DBGFIELD("WriteFMul64X")       1, false, false, false, 1932, 4, 14, 1,  0, 0}, // #228
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 1, false, false, false, 1931, 6,  7, 1,  3, 1}, // #229
  {DBGFIELD("WriteFMulX")         1, false, false, false, 1932, 4, 14, 1,  0, 0}, // #230
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 1, false, false, false, 1931, 6,  7, 1,  3, 1}, // #231
  {DBGFIELD("WriteFMul64")        1, false, false, false, 1932, 4, 14, 1,  0, 0}, // #232
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 1, false, false, false, 1931, 6,  7, 1,  3, 1}, // #233
  {DBGFIELD("WriteFMul")          1, false, false, false, 1932, 4, 14, 1,  0, 0}, // #234
  {DBGFIELD("WriteMULX32Ld")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #235
  {DBGFIELD("WriteMULX32")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #236
  {DBGFIELD("WriteIMulHLd_WriteMULX32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #237
  {DBGFIELD("WriteIMulH_WriteMULX32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #238
  {DBGFIELD("WriteMULX64Ld")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #239
  {DBGFIELD("WriteMULX64")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #240
  {DBGFIELD("WriteIMulHLd_WriteMULX64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #241
  {DBGFIELD("WriteIMulH_WriteMULX64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #242
  {DBGFIELD("WriteFMulLd")        1, false, false, false, 1931, 6,  7, 1,  0, 0}, // #243
  {DBGFIELD("WriteVecALUXLd")     1, false, false, false, 1834, 5,  6, 1,  0, 0}, // #244
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 1, false, false, false, 1834, 5,  6, 1,  3, 1}, // #245
  {DBGFIELD("WriteShuffleX")      1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #246
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 1, false, false, false, 1834, 5,  6, 1,  3, 1}, // #247
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 1, false, false, false, 1834, 5,  6, 1,  3, 1}, // #248
  {DBGFIELD("WriteVarBlend")      1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #249
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 1, false, false, false, 1915, 5,  6, 1,  3, 1}, // #250
  {DBGFIELD("WriteBlend")         1, false, false, false, 1638, 3, 13, 1,  0, 0}, // #251
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 6, false, false, false, 1937, 6, 17, 1,  3, 1}, // #252
  {DBGFIELD("WriteCLMul")         5, false, false, false, 1938, 4, 23, 1,  0, 0}, // #253
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 28, false, false, false, 1943, 11, 20, 1,  3, 1}, // #254
  {DBGFIELD("WritePCmpEStrI")     27, false, false, false, 1954, 11, 10, 1,  0, 0}, // #255
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 28, false, false, false, 1943, 11, 21, 1,  3, 1}, // #256
  {DBGFIELD("WritePCmpEStrM")     27, false, false, false, 1954, 11,  7, 1,  0, 0}, // #257
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 8, false, false, false, 1965, 9, 19, 1,  3, 1}, // #258
  {DBGFIELD("WritePCmpIStrI")     7, false, false, false, 1966, 7, 18, 1,  0, 0}, // #259
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 9, false, false, false, 1974, 9, 23, 1,  3, 1}, // #260
  {DBGFIELD("WritePCmpIStrM")     7, false, false, false, 1975, 7,  6, 1,  0, 0}, // #261
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 1, false, false, false, 1748, 7,  9, 1,  3, 1}, // #262
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 1, false, false, false, 1834, 5,  6, 1,  3, 1}, // #263
  {DBGFIELD("WritePHAddX")        1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #264
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, false, 1983, 6,  9, 1,  0, 0}, // #265
  {DBGFIELD("WritePHMINPOS")      2, false, false, false, 1984, 4,  8, 1,  0, 0}, // #266
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 1, false, false, false, 1748, 7,  9, 1,  3, 1}, // #267
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 1, false, false, false, 1695, 6,  9, 1,  3, 1}, // #268
  {DBGFIELD("WriteVecIMulX")      1, false, false, false, 1696, 4,  8, 1,  0, 0}, // #269
  {DBGFIELD("WriteVecMOVMSK")     2, false, false, false, 1736, 7, 23, 1,  0, 0}, // #270
  {DBGFIELD("WriteShuffleXLd")    1, false, false, false, 1834, 5,  6, 1,  0, 0}, // #271
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 1, false, false, false, 1989, 7,  7, 1,  3, 1}, // #272
  {DBGFIELD("WritePMULLD")        1, false, false, false, 1990, 5, 14, 1,  0, 0}, // #273
  {DBGFIELD("WriteCopy")          2, false, false, false, 1996, 3,  3, 1,  0, 0}, // #274
  {DBGFIELD("WritePOPCNTLd")      1, false, false, false, 1744, 4,  2, 1,  0, 0}, // #275
  {DBGFIELD("WritePOPCNT")        1, false, false, false, 1745, 2,  8, 1,  0, 0}, // #276
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 2, false, false, false, 1834, 5,  9, 1,  3, 1}, // #277
  {DBGFIELD("WritePSADBWX")       2, false, false, false, 1824, 3,  8, 1,  0, 0}, // #278
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 1, false, false, false, 1897, 5,  2, 1,  3, 1}, // #279
  {DBGFIELD("WriteVarShuffleX")   1, false, false, false, 1898, 3,  5, 1,  0, 0}, // #280
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #281
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 1, false, false, false, 1834, 5,  2, 1,  3, 1}, // #282
  {DBGFIELD("WriteVecShiftX")     1, false, false, false, 1824, 3,  5, 1,  0, 0}, // #283
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 2, false, false, false, 1735, 9,  3, 1,  3, 1}, // #284
  {DBGFIELD("WriteVecTest")       2, false, false, false, 1736, 7,  1, 1,  0, 0}, // #285
  {DBGFIELD("WriteRotateLd_WriteRMW") 2, false, false, false, 1680, 5, 86, 2,  0, 0}, // #286
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 2, false, false, false, 1999, 5, 86, 2,  0, 0}, // #287
  {DBGFIELD("WriteRotate")        1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #288
  {DBGFIELD("WriteRotateCL")      1, false, false, false, 1657, 2,  1, 1,  0, 0}, // #289
  {DBGFIELD("WriteFRcpXLd")       1, false, false, false, 1931, 6,  7, 1,  0, 0}, // #290
  {DBGFIELD("WriteFRcpX")         1, false, false, false, 1932, 4, 14, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRcpLd")        1, false, false, false, 1931, 6,  7, 1,  0, 0}, // #292
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 1, false, false, false, 1931, 6,  7, 1,  3, 1}, // #293
  {DBGFIELD("WriteFRcp")          1, false, false, false, 1932, 4, 14, 1,  0, 0}, // #294
  {DBGFIELD("WriteRMW")           1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #295
  {DBGFIELD("WriteShiftLd")       1, false, false, false, 1685, 4, 14, 1,  0, 0}, // #296
  {DBGFIELD("WriteShift")         1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #297
  {DBGFIELD("WriteFRndLd")        1, false, false, false, 2004, 6,  9, 1,  0, 0}, // #298
  {DBGFIELD("WriteFRnd")          1, false, false, false, 1830, 4,  8, 1,  0, 0}, // #299
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 1, false, false, false, 2004, 6,  9, 1,  3, 1}, // #300
  {DBGFIELD("WriteFRsqrtXLd")     1, false, false, false, 1931, 6,  7, 1,  0, 0}, // #301
  {DBGFIELD("WriteFRsqrtX")       1, false, false, false, 1932, 4, 14, 1,  0, 0}, // #302
  {DBGFIELD("WriteFRsqrtLd")      1, false, false, false, 2010, 6,  7, 1,  0, 0}, // #303
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 1, false, false, false, 2010, 6,  7, 1,  3, 1}, // #304
  {DBGFIELD("WriteFRsqrt")        1, false, false, false, 2011, 4, 14, 1,  0, 0}, // #305
  {DBGFIELD("WriteShiftLd_WriteRMW") 2, false, false, false, 1680, 5, 86, 2,  0, 0}, // #306
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 2, false, false, false, 1999, 5, 86, 2,  0, 0}, // #307
  {DBGFIELD("WriteShiftCL")       1, false, false, false, 1657, 2,  1, 1,  0, 0}, // #308
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 1685, 4, 14, 1, 24, 1}, // #309
  {DBGFIELD("WriteSETCCStore")    1, false, false, false, 2016, 4,  1, 1,  0, 0}, // #310
  {DBGFIELD("WriteSETCC")         1, false, false, false, 1657, 2,  1, 1,  0, 0}, // #311
  {DBGFIELD("WriteSHDmrcl")       8, false, false, false, 2020, 4,  8, 1,  0, 0}, // #312
  {DBGFIELD("WriteSHDmri")        8, false, false, false, 2020, 4,  8, 1,  0, 0}, // #313
  {DBGFIELD("WriteSHDrrcl")       7, false, false, false, 1711, 2,  5, 1,  0, 0}, // #314
  {DBGFIELD("WriteFSqrt64XLd")    1, false, false, false, 1791, 6, 10, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrt64X")      1, false, false, false, 1792, 4,  9, 1,  0, 0}, // #316
  {DBGFIELD("WriteFSqrtXLd")      1, false, false, false, 1791, 6, 10, 1,  0, 0}, // #317
  {DBGFIELD("WriteFSqrtX")        1, false, false, false, 1792, 4,  9, 1,  0, 0}, // #318
  {DBGFIELD("WriteFSqrt64Ld")     1, false, false, false, 1791, 6, 10, 1,  0, 0}, // #319
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 1, false, false, false, 1791, 6, 10, 1,  3, 1}, // #320
  {DBGFIELD("WriteFSqrt64")       1, false, false, false, 1792, 4,  9, 1,  0, 0}, // #321
  {DBGFIELD("WriteFSqrtLd")       1, false, false, false, 1791, 6, 10, 1,  0, 0}, // #322
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 1, false, false, false, 1791, 6, 10, 1,  3, 1}, // #323
  {DBGFIELD("WriteFSqrt")         1, false, false, false, 1792, 4,  9, 1,  0, 0}, // #324
  {DBGFIELD("WriteFSqrt80")       1, false, false, false, 2024, 4,  1, 1,  0, 0}, // #325
  {DBGFIELD("WriteSTMXCSR")       2, false, false, false, 2028, 2,  1, 1,  0, 0}, // #326
  {DBGFIELD("WriteTZCNTLd")       2, false, false, false, 1904, 5,  3, 1,  0, 0}, // #327
  {DBGFIELD("WriteTZCNT")         2, false, false, false, 1905, 3, 13, 1,  0, 0}, // #328
  {DBGFIELD("WriteFMAZLd")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #329
  {DBGFIELD("WriteFMALd")         1, false, false, false, 2030, 4,  7, 1,  0, 0}, // #330
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 2, false, false, false, 2034, 6,  7, 1,  3, 1}, // #331
  {DBGFIELD("WriteFAdd64Y")       2, false, false, false, 2035, 4, 14, 1,  0, 0}, // #332
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteFAdd64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 2, false, false, false, 2034, 6,  7, 1,  3, 1}, // #335
  {DBGFIELD("WriteFAddY")         2, false, false, false, 2035, 4, 14, 1,  0, 0}, // #336
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD("WriteFAddZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 1920, 5,  6, 1,  3, 1}, // #339
  {DBGFIELD("WriteShuffleY")      2, false, false, false, 1921, 3, 13, 1,  0, 0}, // #340
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD("WriteShuffleZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 2, false, false, false, 2040, 5,  6, 1,  3, 1}, // #343
  {DBGFIELD("WriteFLogicY")       2, false, false, false, 2041, 3, 13, 1,  0, 0}, // #344
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #345
  {DBGFIELD("WriteFLogicZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #346
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 2, false, false, false, 2045, 5,  6, 1,  3, 1}, // #347
  {DBGFIELD("WriteFVarBlendY")    2, false, false, false, 2046, 3, 13, 1,  0, 0}, // #348
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #349
  {DBGFIELD("WriteFVarBlendZ")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 2, false, false, false, 2050, 5,  6, 1,  3, 1}, // #351
  {DBGFIELD("WriteFBlendY")       2, false, false, false, 2051, 3, 13, 1,  0, 0}, // #352
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 2045, 5,  6, 1,  3, 2}, // #353
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 1666, 5,  6, 1,  3, 2}, // #354
  {DBGFIELD("WriteShuffle256Ld")  1, false, false, false, 1915, 5,  3, 1,  0, 0}, // #355
  {DBGFIELD("WriteShuffle256")    1, false, false, false, 1638, 3,  1, 1,  0, 0}, // #356
  {DBGFIELD("WriteShuffleYLd")    2, false, false, false, 1920, 5,  6, 1,  0, 0}, // #357
  {DBGFIELD("WriteFShuffle256")   2, false, false, false, 1667, 3, 13, 1,  0, 0}, // #358
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, false, 1666, 5,  6, 1,  0, 0}, // #359
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 2, false, false, false, 2034, 6,  6, 1,  3, 1}, // #360
  {DBGFIELD("WriteFCmp64Y")       2, false, false, false, 2035, 4, 13, 1,  0, 0}, // #361
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 2, false, false, false, 2034, 6,  6, 1,  3, 1}, // #362
  {DBGFIELD("WriteFCmpY")         2, false, false, false, 2035, 4, 13, 1,  0, 0}, // #363
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #364
  {DBGFIELD("WriteFCmpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("WriteVarShuffle256Ld") 1, false, false, false, 1915, 5,  3, 1,  0, 0}, // #366
  {DBGFIELD("WriteVarShuffle256") 1, false, false, false, 1638, 3,  1, 1,  0, 0}, // #367
  {DBGFIELD("WriteCvtI2PDYLd")    5, false, false, false, 1766, 7, 22, 1,  0, 0}, // #368
  {DBGFIELD("WriteCvtI2PDY")      4, false, false, false, 1767, 5,  2, 1,  0, 0}, // #369
  {DBGFIELD("WriteCvtI2PDZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #370
  {DBGFIELD("WriteCvtI2PDZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #371
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, false, 1766, 7,  9, 1,  0, 0}, // #372
  {DBGFIELD("WriteCvtI2PSY")      2, false, false, false, 1767, 5,  8, 1,  0, 0}, // #373
  {DBGFIELD("WriteCvtI2PSZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #374
  {DBGFIELD("WriteCvtI2PSZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 2, false, false, false, 1748, 7, 22, 1,  3, 1}, // #376
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 4, false, false, false, 2055, 8, 22, 1,  3, 1}, // #377
  {DBGFIELD("WriteCvtPD2PSY")     4, false, false, false, 2056, 6,  2, 1,  0, 0}, // #378
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtPD2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteCvtPD2PSYLd")   4, false, false, false, 2055, 8, 22, 1,  0, 0}, // #381
  {DBGFIELD("WriteCvtPD2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #382
  {DBGFIELD("WriteCvtPD2IYLd")    4, false, false, false, 2055, 8, 22, 1,  0, 0}, // #383
  {DBGFIELD("WriteCvtPD2IY")      4, false, false, false, 2056, 6,  2, 1,  0, 0}, // #384
  {DBGFIELD("WriteCvtPD2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #385
  {DBGFIELD("WriteCvtPD2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, false, 1766, 7,  9, 1,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2IY")      2, false, false, false, 1767, 5,  8, 1,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2PDYLd")   5, false, false, false, 1766, 7, 22, 1,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PDY")     4, false, false, false, 1767, 5,  2, 1,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PDZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PDZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtPH2PSYLd")   7, false, false, false, 1766, 7, 22, 1,  0, 0}, // #395
  {DBGFIELD("WriteCvtPH2PSY")     4, false, false, false, 1767, 5,  2, 1,  0, 0}, // #396
  {DBGFIELD("WriteCvtPH2PSLd")    3, false, false, false, 1766, 7, 22, 1,  0, 0}, // #397
  {DBGFIELD("WriteCvtPH2PS")      2, false, false, false, 1767, 5,  2, 1,  0, 0}, // #398
  {DBGFIELD("WriteCvtPH2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteCvtPH2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #400
  {DBGFIELD("WriteCvtPS2PHYSt")   4, false, false, false, 2063, 8,  8, 1,  0, 0}, // #401
  {DBGFIELD("WriteCvtPS2PHY")     4, false, false, false, 2056, 6,  2, 1,  0, 0}, // #402
  {DBGFIELD("WriteCvtPS2PHSt")    3, false, false, false, 2071, 7,  8, 1,  0, 0}, // #403
  {DBGFIELD("WriteCvtPS2PH")      2, false, false, false, 1767, 5,  2, 1,  0, 0}, // #404
  {DBGFIELD("WriteCvtPS2PHZSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteCvtPS2PHZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #406
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 2, false, false, false, 1755, 11, 31, 1,  3, 1}, // #407
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 2, false, false, false, 1755, 11, 31, 1,  3, 1}, // #408
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #409
  {DBGFIELD("WritePSADBWY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #410
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #411
  {DBGFIELD("WritePSADBWZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #412
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 2, false, false, false, 2078, 6, 10, 1,  3, 1}, // #413
  {DBGFIELD("WriteFDiv64Y")       2, false, false, false, 2079, 4,  9, 1,  0, 0}, // #414
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD("WriteFDiv64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 2, false, false, false, 2078, 6, 10, 1,  3, 1}, // #417
  {DBGFIELD("WriteFDivY")         2, false, false, false, 2079, 4,  9, 1,  0, 0}, // #418
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WriteFDivZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #420
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 1, false, false, false, 2030, 4,  7, 1,  3, 1}, // #421
  {DBGFIELD("WriteFMAX")          1, false, false, false, 1667, 2, 14, 1,  0, 0}, // #422
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 2, false, false, false, 2030, 4,  7, 1,  3, 1}, // #423
  {DBGFIELD("WriteFMAY")          2, false, false, false, 1667, 2, 14, 1,  0, 0}, // #424
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteFMAZ")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #426
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 29, false, false, false, 2084, 6, 63, 1,  3, 1}, // #427
  {DBGFIELD("WriteDPPSY")         25, false, false, false, 2085, 4, 46, 1,  0, 0}, // #428
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 1, false, false, false, 1915, 5,  3, 1,  3, 1}, // #429
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 2030, 4,  7, 1, 16, 2}, // #430
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 2030, 4,  7, 1, 16, 2}, // #431
  {DBGFIELD("WriteFMALd_ReadAfterVecLd") 1, false, false, false, 2030, 4,  7, 1,  3, 1}, // #432
  {DBGFIELD("WriteFMA")           1, false, false, false, 1667, 2, 14, 1,  0, 0}, // #433
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 1, false, false, false, 2030, 4,  7, 1, 16, 2}, // #434
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 2030, 4,  7, 1,  3, 2}, // #435
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 2030, 4,  7, 1,  3, 2}, // #436
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 1, false, false, false, 2030, 4,  7, 1,  3, 2}, // #437
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 2, false, false, false, 2090, 6,  9, 1,  3, 1}, // #438
  {DBGFIELD("WriteFRndY")         2, false, false, false, 1812, 4,  8, 1,  0, 0}, // #439
  {DBGFIELD("WriteLoad_WriteVecMaskedGatherWriteback") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #440
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteFRndZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #443
  {DBGFIELD("WriteVecIMulY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #444
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #445
  {DBGFIELD("WriteVecIMulZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #446
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #447
  {DBGFIELD("WriteVecALUY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("WriteVecALUZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #450
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 10, false, false, false, 2096, 6, 19, 1,  3, 1}, // #451
  {DBGFIELD("WriteFHAddY")        8, false, false, false, 2097, 4, 18, 1,  0, 0}, // #452
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 1666, 5,  6, 1,  3, 1}, // #453
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 1, false, false, false, 1915, 5,  3, 1,  3, 1}, // #454
  {DBGFIELD("WriteVecLoadY")      2, false, false, false, 2102, 5, 14, 1,  0, 0}, // #455
  {DBGFIELD("WriteFMaskedStore64Y") 34, false, false, false, 2107, 5,  3, 1,  0, 0}, // #456
  {DBGFIELD("WriteFMaskedLoadY")  2, false, false, false, 2045, 5,  3, 1,  0, 0}, // #457
  {DBGFIELD("WriteFMaskedStore64") 18, false, false, false, 2112, 5,  3, 1,  0, 0}, // #458
  {DBGFIELD("WriteFMaskedLoad")   1, false, false, false, 2117, 5,  3, 1,  0, 0}, // #459
  {DBGFIELD("WriteFMaskedStore32Y") 34, false, false, false, 2107, 5,  3, 1,  0, 0}, // #460
  {DBGFIELD("WriteFMaskedStore32") 18, false, false, false, 2112, 5,  3, 1,  0, 0}, // #461
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #462
  {DBGFIELD("WriteFCmp64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #463
  {DBGFIELD("WriteFMoveY")        2, false, false, false, 2041, 3, 13, 1,  0, 0}, // #464
  {DBGFIELD("WriteFMoveZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #465
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, false, 2045, 5,  6, 1,  0, 0}, // #466
  {DBGFIELD("WriteFShuffleY")     2, false, false, false, 2046, 3, 13, 1,  0, 0}, // #467
  {DBGFIELD("WriteFShuffleZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteFShuffleZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #469
  {DBGFIELD("WriteVecStoreY")     4, false, false, false, 2122, 5,  1, 1,  0, 0}, // #470
  {DBGFIELD("WriteVecMoveY")      2, false, false, false, 2127, 3, 13, 1,  0, 0}, // #471
  {DBGFIELD("WriteVecMoveZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #472
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, false, 2130, 5, 14, 1,  0, 0}, // #473
  {DBGFIELD("WriteVecStoreNTY")   4, false, false, false, 2135, 6, 13, 1,  0, 0}, // #474
  {DBGFIELD("WriteFStoreNTY")     4, false, false, false, 2135, 6,  5, 1,  0, 0}, // #475
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #476
  {DBGFIELD("WriteMPSADY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #477
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 2, false, false, false, 2010, 6,  7, 1,  3, 1}, // #478
  {DBGFIELD("WriteFMul64Y")       2, false, false, false, 2011, 4, 14, 1,  0, 0}, // #479
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteFMul64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 2, false, false, false, 2010, 6,  7, 1,  3, 1}, // #482
  {DBGFIELD("WriteFMulY")         2, false, false, false, 2011, 4, 14, 1,  0, 0}, // #483
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #484
  {DBGFIELD("WriteFMulZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #485
  {DBGFIELD("WriteVecALUYLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD("WriteVecALUZLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #488
  {DBGFIELD("WriteVecLogicY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #489
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteVecLogicZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #492
  {DBGFIELD("WriteBlendY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #493
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #494
  {DBGFIELD("WriteVarBlendY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #495
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteVarBlendZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #498
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 1834, 5,  6, 1,  3, 2}, // #499
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 1920, 5,  6, 1,  3, 2}, // #500
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 1920, 5,  6, 1, 16, 2}, // #501
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 1834, 5,  6, 1,  3, 2}, // #502
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 1834, 5,  6, 1, 16, 2}, // #503
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #504
  {DBGFIELD("WriteFVarShuffle256") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #505
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 2045, 5,  2, 1,  3, 2}, // #506
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 2045, 5,  2, 1, 16, 2}, // #507
  {DBGFIELD("WriteFVarShuffleY")  2, false, false, false, 2046, 3,  5, 1,  0, 0}, // #508
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 1701, 5,  2, 1,  3, 2}, // #509
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 1701, 5,  2, 1, 16, 2}, // #510
  {DBGFIELD("WriteFVarShuffle")   1, false, false, false, 1702, 3,  5, 1,  0, 0}, // #511
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 2045, 5,  2, 1,  3, 1}, // #512
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 1, false, false, false, 1701, 5,  2, 1,  3, 1}, // #513
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #514
  {DBGFIELD("WriteFVarShuffleZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #515
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #516
  {DBGFIELD("WritePHAddY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #517
  {DBGFIELD("WriteVecInsert")     2, false, false, false, 1898, 3, 13, 1,  0, 0}, // #518
  {DBGFIELD("WriteVecIMulXLd")    1, false, false, false, 1695, 6,  9, 1,  0, 0}, // #519
  {DBGFIELD("WriteVecIMulYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #520
  {DBGFIELD("WriteVecIMulZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #521
  {DBGFIELD("WriteVecMaskedStore32Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #522
  {DBGFIELD("WriteVecMaskedLoadY") 2, false, false, false, 2130, 5,  3, 1,  0, 0}, // #523
  {DBGFIELD("WriteVecMaskedStore32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #524
  {DBGFIELD("WriteVecMaskedLoad") 1, false, false, false, 1834, 5,  3, 1,  0, 0}, // #525
  {DBGFIELD("WriteVecMaskedStore64Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #526
  {DBGFIELD("WriteVecMaskedStore64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #527
  {DBGFIELD("WriteVPMOV256Ld")    1, false, false, false, 1915, 5,  3, 1,  0, 0}, // #528
  {DBGFIELD("WriteVPMOV256")      1, false, false, false, 1638, 3,  1, 1,  0, 0}, // #529
  {DBGFIELD("WriteVecMOVMSKY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #530
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #531
  {DBGFIELD("WritePMULLDY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #532
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WritePMULLDZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #534
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 1897, 5,  2, 1,  3, 2}, // #535
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 1897, 5,  2, 1, 16, 2}, // #536
  {DBGFIELD("WriteVecShiftImmXLd") 1, false, false, false, 1834, 5,  6, 1,  0, 0}, // #537
  {DBGFIELD("WriteVecShiftImmYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #538
  {DBGFIELD("WriteVecShiftImmY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #539
  {DBGFIELD("WriteVecShiftImmZLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #540
  {DBGFIELD("WriteVecShiftImmZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #541
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 1, false, false, false, 1834, 5,  2, 1,  3, 1}, // #542
  {DBGFIELD("WriteVarVecShift")   1, false, false, false, 1824, 3,  5, 1,  0, 0}, // #543
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #544
  {DBGFIELD("WriteVarVecShiftY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #545
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #546
  {DBGFIELD("WriteVarVecShiftZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #547
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 1, false, false, false, 1834, 5,  6, 1,  3, 1}, // #548
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD("WriteVarShuffleY")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #550
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #551
  {DBGFIELD("WriteVarShuffleZ")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #552
  {DBGFIELD("WriteShuffleZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #553
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #554
  {DBGFIELD("WriteVecShiftY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #555
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD("WriteVecShiftZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #557
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 6, false, false, false, 2141, 8,  3, 1,  3, 1}, // #558
  {DBGFIELD("WriteVecTestY")      4, false, false, false, 2142, 6,  1, 1,  0, 0}, // #559
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 1, false, false, false, 1931, 6,  7, 1,  3, 1}, // #560
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 2, false, false, false, 2149, 6,  7, 1,  3, 1}, // #561
  {DBGFIELD("WriteFRcpY")         2, false, false, false, 2150, 4, 14, 1,  0, 0}, // #562
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #563
  {DBGFIELD("WriteFRcpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #564
  {DBGFIELD("WriteFRcpYLd")       2, false, false, false, 2149, 6,  7, 1,  0, 0}, // #565
  {DBGFIELD("WriteFRndYLd")       2, false, false, false, 2090, 6,  9, 1,  0, 0}, // #566
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 1, false, false, false, 1931, 6,  7, 1,  3, 1}, // #567
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 2, false, false, false, 2155, 6,  7, 1,  3, 1}, // #568
  {DBGFIELD("WriteFRsqrtY")       2, false, false, false, 2156, 4, 14, 1,  0, 0}, // #569
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #570
  {DBGFIELD("WriteFRsqrtZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #571
  {DBGFIELD("WriteFRsqrtYLd")     2, false, false, false, 2155, 6,  7, 1,  0, 0}, // #572
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 2045, 5,  6, 1,  3, 1}, // #573
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #574
  {DBGFIELD("WriteFSqrt64YLd")    2, false, false, false, 2078, 6, 10, 1,  0, 0}, // #575
  {DBGFIELD("WriteFSqrt64Y")      2, false, false, false, 2079, 4,  9, 1,  0, 0}, // #576
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 1, false, false, false, 1791, 6, 10, 1,  3, 1}, // #577
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 2, false, false, false, 2078, 6, 10, 1,  3, 1}, // #578
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #579
  {DBGFIELD("WriteFSqrt64Z")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #580
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 1, false, false, false, 1791, 6, 10, 1,  3, 1}, // #581
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 2, false, false, false, 2078, 6, 10, 1,  3, 1}, // #582
  {DBGFIELD("WriteFSqrtY")        2, false, false, false, 2079, 4,  9, 1,  0, 0}, // #583
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #584
  {DBGFIELD("WriteFSqrtZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #585
  {DBGFIELD("WriteFSqrtYLd")      2, false, false, false, 2078, 6, 10, 1,  0, 0}, // #586
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 6, false, false, false, 2161, 8,  3, 1,  3, 1}, // #587
  {DBGFIELD("WriteFTestY")        4, false, false, false, 2162, 6,  1, 1,  0, 0}, // #588
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 2, false, false, false, 1735, 9,  3, 1,  3, 1}, // #589
  {DBGFIELD("WriteFTest")         2, false, false, false, 1736, 7,  1, 1,  0, 0}, // #590
  {DBGFIELD("WriteALULd_WriteRMW") 2, false, false, false, 1680, 5, 86, 2,  0, 0}, // #591
  {DBGFIELD("WriteXCHG")          2, false, false, false, 1642, 3,  1, 1,  0, 0}, // #592
  {DBGFIELD("COPY")               1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #593
  {DBGFIELD("XAM_F")              2, false, false, false, 1736, 7,  1, 1,  0, 0}, // #594
  {DBGFIELD("LD_Frr")             1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #595
  {DBGFIELD("MOVSX64rr32")        1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #596
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 2, false, false, false, 1680, 5, 86, 2,  0, 0}, // #597
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 2, false, false, false, 1999, 5, 86, 2,  0, 0}, // #598
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 2, false, false, false, 1680, 5, 86, 2,  0, 0}, // #599
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 2, false, false, false, 1999, 5, 86, 2,  0, 0}, // #600
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #601
  {DBGFIELD("FCOMPP")             1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #602
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, false, 1932, 4,  1, 1,  0, 0}, // #603
  {DBGFIELD("MMX_CVTPI2PSrr")     2, false, false, false, 1749, 5,  8, 1,  0, 0}, // #604
  {DBGFIELD("MMX_CVTPI2PSrm")     1, false, false, false, 1748, 7,  9, 1,  0, 0}, // #605
  {DBGFIELD("MMX_CVTPS2PIrr_MMX_CVTTPS2PIrr") 1, false, false, false, 1749, 5,  8, 1,  0, 0}, // #606
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, false, 1730, 2, 14, 1,  0, 0}, // #607
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #608
  {DBGFIELD("XCH_F")              1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #609
  {DBGFIELD("RETI16_RETI32_RETI64_IRET_IRET16_IRET32_IRET64") 1, false, false, false, 1651, 6, 14, 1,  0, 0}, // #610
  {DBGFIELD("MMX_CVTPS2PIrm_MMX_CVTTPS2PIrm") 1, false, false, false, 1748, 7,  9, 1,  0, 0}, // #611
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 1, false, false, false, 1730, 2, 14, 1,  0, 0}, // #612
  {DBGFIELD("CVTSI642SDrm")       2, false, false, false, 1748, 7,  9, 1,  0, 0}, // #613
  {DBGFIELD("CVTSI642SDrm_Int")   2, false, false, false, 1748, 7,  9, 1,  3, 1}, // #614
  {DBGFIELD("CVTSI642SSrr")       2, false, false, false, 2169, 5, 22, 1,  0, 0}, // #615
  {DBGFIELD("CVTSI642SSrr_Int")   2, false, false, false, 1749, 5,  8, 1, 29, 1}, // #616
  {DBGFIELD("CVTSI642SSrm")       2, false, false, false, 1748, 7,  9, 1,  0, 0}, // #617
  {DBGFIELD("CVTSI642SSrm_Int")   2, false, false, false, 1748, 7,  9, 1,  3, 1}, // #618
  {DBGFIELD("CVTSS2SI64rr_CVTTSS2SI64rr") 2, false, false, false, 1756, 9, 22, 1,  0, 0}, // #619
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 2, false, false, false, 1756, 9, 22, 1,  0, 0}, // #620
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 2, false, false, false, 1755, 11, 31, 1,  0, 0}, // #621
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #622
  {DBGFIELD("LFENCE")             1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #623
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, false, 1702, 3, 13, 1,  0, 0}, // #624
  {DBGFIELD("LEAVE_LEAVE64")      1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #625
  {DBGFIELD("POP16r")             1, false, false, false, 1730, 2, 14, 1,  0, 0}, // #626
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 2, false, false, false, 1996, 3,  3, 1,  0, 0}, // #627
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #628
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #629
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #630
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #631
  {DBGFIELD("MMX_PADDQrr_MMX_PSUBQrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #632
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #633
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 1, false, false, false, 1661, 5,  1, 1,  0, 0}, // #634
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  1, false, false, false, 1661, 5,  1, 1,  0, 0}, // #635
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #636
  {DBGFIELD("CLD")                1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #637
  {DBGFIELD("LDDQUrm")            1, false, false, false, 1897, 5, 14, 1,  0, 0}, // #638
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #639
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 2, false, false, false, 1996, 3,  3, 1,  0, 0}, // #640
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 2, false, false, false, 1680, 5, 86, 2,  0, 0}, // #641
  {DBGFIELD("PHADDDrr_PHSUBDrr")  3, false, false, false, 1921, 3, 14, 1,  0, 0}, // #642
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, false, 1685, 4, 14, 1,  0, 0}, // #643
  {DBGFIELD("MMX_PADDQrm_MMX_PSUBQrm") 1, false, false, false, 1915, 5,  6, 1,  3, 1}, // #644
  {DBGFIELD("MOVDQUrm")           1, false, false, false, 1897, 5, 14, 1,  0, 0}, // #645
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, false, 1666, 5, 14, 1,  0, 0}, // #646
  {DBGFIELD("PADDQrm_PSUBQrm")    1, false, false, false, 1834, 5,  6, 1,  3, 1}, // #647
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #648
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   1, false, false, false, 1641, 4,  1, 1,  0, 0}, // #649
  {DBGFIELD("LD_F80m")            1, false, false, false, 1730, 2, 14, 1,  0, 0}, // #650
  {DBGFIELD("PHADDDrm_PHSUBDrm")  4, false, false, false, 1920, 5,  7, 1,  0, 0}, // #651
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 2, false, false, false, 1817, 7, 23, 1,  0, 0}, // #652
  {DBGFIELD("FLDCW16m")           1, false, false, false, 1730, 2, 14, 1,  0, 0}, // #653
  {DBGFIELD("ST_FP80m")           1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #654
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 3, false, false, false, 1921, 3, 14, 1,  0, 0}, // #655
  {DBGFIELD("CMPXCHG8rm")         5, false, false, false, 2174, 3,  5, 1,  0, 0}, // #656
  {DBGFIELD("INTO")               1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #657
  {DBGFIELD("XLAT")               1, false, false, false, 1657, 2,  3, 1,  0, 0}, // #658
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 7, false, false, false, 1711, 2,  5, 1,  0, 0}, // #659
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 6, false, false, false, 1659, 2,  5, 1,  0, 0}, // #660
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 8, false, false, false, 2020, 4,  8, 1,  0, 0}, // #661
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 8, false, false, false, 2020, 4,  8, 1,  0, 0}, // #662
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #663
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 4, false, false, false, 1920, 5,  7, 1,  3, 1}, // #664
  {DBGFIELD("AAD8i8")             1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #665
  {DBGFIELD("LOOPE")              1, false, false, false, 1641, 4,  1, 1,  0, 0}, // #666
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #667
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 7, false, false, false, 1711, 2,  5, 1,  0, 0}, // #668
  {DBGFIELD("FNSTCW16m")          1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #669
  {DBGFIELD("POPA16_POPA32")      1, false, false, false, 1730, 2, 14, 1,  0, 0}, // #670
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #671
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 8, false, false, false, 2020, 4,  8, 1,  0, 0}, // #672
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 8, false, false, false, 2020, 4,  8, 1,  0, 0}, // #673
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 6, false, false, false, 1659, 2,  5, 1,  0, 0}, // #674
  {DBGFIELD("CMPXCHG8rr")         3, false, false, false, 1732, 3,  5, 1,  0, 0}, // #675
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80") 2, false, false, false, 1736, 7,  1, 1,  0, 0}, // #676
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #677
  {DBGFIELD("AAA_AAS")            1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #678
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 6, false, false, false, 2177, 3,  5, 1,  0, 0}, // #679
  {DBGFIELD("LOOPNE")             1, false, false, false, 1641, 4,  1, 1,  0, 0}, // #680
  {DBGFIELD("PAUSE")              1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #681
  {DBGFIELD("CMPXCHG8B")          18, false, false, false, 2180, 3,  5, 1,  0, 0}, // #682
  {DBGFIELD("DAA")                1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #683
  {DBGFIELD("LOOP")               1, false, false, false, 1641, 4,  1, 1,  0, 0}, // #684
  {DBGFIELD("DAS")                1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #685
  {DBGFIELD("AAM8i8")             1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #686
  {DBGFIELD("STD")                1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #687
  {DBGFIELD("CMPXCHG16B")         22, false, false, false, 2183, 3,  5, 1,  0, 0}, // #688
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #689
  {DBGFIELD("FNCLEX_FXTRACT")     1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #690
  {DBGFIELD("POPF32_POPF64")      1, false, false, false, 1730, 2, 14, 1,  0, 0}, // #691
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #692
  {DBGFIELD("RDTSC_RDTSCP")       1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #693
  {DBGFIELD("ENTER")              1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #694
  {DBGFIELD("POPF16")             1, false, false, false, 1730, 2, 14, 1,  0, 0}, // #695
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #696
  {DBGFIELD("FRNDINT")            1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #697
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #698
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #699
  {DBGFIELD("FPREM")              1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #700
  {DBGFIELD("INSB_INSL_INSW")     1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #701
  {DBGFIELD("FNINIT")             1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #702
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #703
  {DBGFIELD("FPREM1")             1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #704
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #705
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #706
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #707
  {DBGFIELD("FSCALE")             1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #708
  {DBGFIELD("RDMSR")              1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #709
  {DBGFIELD("RET_RET16_RET32_RET64_LRET16_LRET32_LRET64_LRETI16_LRETI32_LRETI64") 1, false, false, false, 1651, 6, 14, 1,  0, 0}, // #710
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #711
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #712
  {DBGFIELD("F2XM1")              1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #713
  {DBGFIELD("CPUID")              1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #714
  {DBGFIELD("INT")                1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #715
  {DBGFIELD("INT3")               1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #716
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #717
  {DBGFIELD("FXRSTOR_FXRSTOR64")  1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #718
  {DBGFIELD("FYL2X")              1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #719
  {DBGFIELD("FYL2XP1")            1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #720
  {DBGFIELD("FPTAN")              1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #721
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #722
  {DBGFIELD("FPATAN")             1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #723
  {DBGFIELD("WRMSR")              1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #724
  {DBGFIELD("COMP_FST0r_COM_FST0r") 2, false, false, false, 1736, 7,  1, 1,  0, 0}, // #725
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   2, false, false, false, 1736, 7,  1, 1,  0, 0}, // #726
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #727
  {DBGFIELD("FNOP")               1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #728
  {DBGFIELD("RET64")              1, false, false, false, 1651, 6, 14, 1,  0, 0}, // #729
  {DBGFIELD("CDQ_CQO")            1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #730
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, false, 1638, 3, 13, 1,  0, 0}, // #731
  {DBGFIELD("MMX_PADDQrr")        1, false, false, false, 1638, 3, 13, 1,  0, 0}, // #732
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #733
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #734
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int_VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 2, false, false, false, 1736, 7,  1, 1,  0, 0}, // #735
  {DBGFIELD("CWD")                1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #736
  {DBGFIELD("FNSTSW16r")          1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #737
  {DBGFIELD("MMX_MOVDQ2Qrr")      1, false, false, false, 1824, 3,  1, 1,  0, 0}, // #738
  {DBGFIELD("PUSHFS64")           1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #739
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 2, false, false, false, 1817, 7, 23, 1,  0, 0}, // #740
  {DBGFIELD("RCL8r1_RCL16r1_RCL32r1_RCL64r1_RCR8r1_RCR16r1_RCR32r1_RCR64r1") 1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #741
  {DBGFIELD("RCR8ri_RCR16ri_RCR32ri_RCR64ri") 15, false, false, false, 2186, 2,  6, 1,  0, 0}, // #742
  {DBGFIELD("RCL8ri_RCL16ri_RCL32ri_RCL64ri") 25, false, false, false, 2188, 2, 22, 1,  0, 0}, // #743
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 2, false, false, false, 1736, 7,  1, 1,  0, 0}, // #744
  {DBGFIELD("MOV64sr")            1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #745
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVSX32rm16_MOVSX32rm32_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false, false, 1685, 4, 14, 1,  0, 0}, // #746
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 24, false, false, false, 2021, 2, 18, 1,  0, 0}, // #747
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #748
  {DBGFIELD("CLI")                1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #749
  {DBGFIELD("PUSHGS64")           1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #750
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #751
  {DBGFIELD("CALL64pcrel32")      1, false, false, false, 1641, 4,  1, 1,  0, 0}, // #752
  {DBGFIELD("CALL64r_RVMARKER_CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false, false, 1641, 4,  1, 1,  0, 0}, // #753
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 2, false, false, false, 1811, 6, 22, 1,  0, 0}, // #754
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #755
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 2, false, false, false, 1811, 6, 22, 1,  0, 0}, // #756
  {DBGFIELD("PUSHF16_PUSHF64")    1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #757
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 1, false, false, false, 1730, 2, 14, 1,  0, 0}, // #758
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, false, 1701, 5,  6, 1,  0, 0}, // #759
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, false, 1897, 5, 14, 1,  0, 0}, // #760
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 1701, 5,  6, 1,  0, 0}, // #761
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, false, 1666, 5, 14, 1,  0, 0}, // #762
  {DBGFIELD("MOV16sm")            1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #763
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 1, false, false, false, 1915, 5,  6, 1,  0, 0}, // #764
  {DBGFIELD("MMX_PALIGNRrmi")     1, false, false, false, 1834, 5,  6, 1,  3, 1}, // #765
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 1, false, false, false, 1915, 5,  6, 1,  3, 1}, // #766
  {DBGFIELD("LODSL_LODSQ")        1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #767
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 2, false, false, false, 2190, 5,  3, 1, 26, 1}, // #768
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 2, false, false, false, 2045, 5,  6, 1,  0, 0}, // #769
  {DBGFIELD("VINSERTF128rm")      2, false, false, false, 1666, 5,  6, 1,  3, 1}, // #770
  {DBGFIELD("MMX_PADDQrm")        1, false, false, false, 1915, 5,  6, 1,  3, 1}, // #771
  {DBGFIELD("VERRm_VERWm")        1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #772
  {DBGFIELD("FARJMP64m")          1, false, false, false, 1641, 4,  1, 1,  0, 0}, // #773
  {DBGFIELD("FNSTSWm")            1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #774
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #775
  {DBGFIELD("CALL64m_RVMARKER_CALL64m_CALL64m_NT") 1, false, false, false, 1641, 4,  1, 1,  0, 0}, // #776
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 1, false, false, false, 1651, 6, 14, 1,  0, 0}, // #777
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int_VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 2, false, false, false, 1735, 9,  3, 1,  3, 1}, // #778
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #779
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 2, false, false, false, 1680, 5, 86, 2,  0, 0}, // #780
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 4, false, false, false, 2195, 3,  3, 1,  0, 0}, // #781
  {DBGFIELD("FARCALL64m")         1, false, false, false, 1641, 4,  1, 1,  0, 0}, // #782
  {DBGFIELD("CVTSD2SI64rm_CVTSD2SI64rm_Int_CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 2, false, false, false, 1755, 11, 31, 1,  0, 0}, // #783
  {DBGFIELD("CVTSS2SIrm_CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 2, false, false, false, 1755, 11, 31, 1,  0, 0}, // #784
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, false, 1730, 2, 14, 1,  0, 0}, // #785
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 2, false, false, false, 1999, 5, 86, 2,  0, 0}, // #786
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 2, false, false, false, 1680, 5,  3, 1, 24, 2}, // #787
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 1, false, false, false, 2198, 6, 14, 1,  0, 0}, // #788
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 1, false, false, false, 1834, 5,  6, 1,  3, 1}, // #789
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 2, false, false, false, 1735, 9,  3, 1,  0, 0}, // #790
  {DBGFIELD("MUL_F32m_MUL_F64m")  1, false, false, false, 1797, 6, 14, 1,  0, 0}, // #791
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 1, false, false, false, 2198, 6, 14, 1,  0, 0}, // #792
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 1, false, false, false, 1797, 6, 14, 1,  0, 0}, // #793
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 1, false, false, false, 2204, 6,  9, 1,  0, 0}, // #794
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 1, false, false, false, 2204, 6,  9, 1,  0, 0}, // #795
  {DBGFIELD("VZEROALL")           32, false, false, false,  0, 0, 88, 1,  0, 0}, // #796
  {DBGFIELD("VZEROUPPER")         16, false, false, false,  0, 0, 49, 1,  0, 0}, // #797
  {DBGFIELD("CLC")                1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #798
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #799
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #800
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 2, false, false, false, 2041, 3, 13, 1,  0, 0}, // #801
  {DBGFIELD("PXORrr_VPXORrr")     8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #802
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #803
  {DBGFIELD("PSUBQrr")            8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #804
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #805
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 1, false, false, false, 1657, 2,  1, 1,  0, 0}, // #806
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #807
  {DBGFIELD("SETCCr")             1, false, false, false, 1657, 2,  1, 1,  0, 0}, // #808
  {DBGFIELD("SETCCm")             8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #809
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 1, false, false, false, 1701, 5,  6, 1,  3, 1}, // #810
  {DBGFIELD("RETI16_RETI32_RETI64") 1, false, false, false, 1651, 6, 14, 1,  0, 0}, // #811
  {DBGFIELD("LRETI16_LRETI32_LRETI64") 1, false, false, false, 1651, 6, 14, 1,  0, 0}, // #812
  {DBGFIELD("RDPMC")              1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #813
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #814
  {DBGFIELD("FBLDm")              1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #815
  {DBGFIELD("FFREE_FFREEP")       1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #816
  {DBGFIELD("FSAVEm")             1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #817
  {DBGFIELD("FRSTORm")            1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #818
  {DBGFIELD("FXTRACT")            1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #819
  {DBGFIELD("MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 1701, 5,  6, 1,  0, 0}, // #820
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, false, 1834, 5,  6, 1,  0, 0}, // #821
  {DBGFIELD("VBROADCASTF128")     2, false, false, false, 1667, 3,  6, 1,  0, 0}, // #822
  {DBGFIELD("VBROADCASTI128")     1, false, false, false, 1834, 5,  6, 1,  0, 0}, // #823
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, false, 1834, 5,  6, 1,  0, 0}, // #824
  {DBGFIELD("FBSTPm")             1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #825
  {DBGFIELD("VMPTRSTm")           1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #826
  {DBGFIELD("ST_FP32m_ST_FP64m")  1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #827
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #828
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 1, false, false, false, 1824, 3,  5, 1,  0, 0}, // #829
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false, false, 1638, 3,  8, 1,  0, 0}, // #830
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false, false, 1641, 4,  1, 1,  0, 0}, // #831
  {DBGFIELD("FINCSTP")            1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #832
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #833
  {DBGFIELD("VPBLENDDYrri")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #834
  {DBGFIELD("VPBLENDDrri")        1, false, false, false, 1638, 3, 13, 1,  0, 0}, // #835
  {DBGFIELD("CMC_STC")            1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #836
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #837
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 2, false, false, false, 1748, 7, 22, 1,  0, 0}, // #838
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 1, false, false, false, 1834, 5,  2, 1,  3, 1}, // #839
  {DBGFIELD("CVTSS2SDrm")         1, false, false, false, 1766, 7,  9, 1,  0, 0}, // #840
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 1, false, false, false, 1766, 7,  9, 1,  3, 1}, // #841
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #842
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 1, false, false, false, 1685, 4, 14, 1, 26, 1}, // #843
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 1, false, false, false, 1834, 5,  6, 1,  0, 0}, // #844
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 1, false, false, false, 1915, 5,  3, 1,  0, 0}, // #845
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 1, false, false, false, 1651, 6, 14, 1,  0, 0}, // #846
  {DBGFIELD("ANDN32rm_ANDN64rm")  1, false, false, false, 1685, 4, 14, 1, 26, 1}, // #847
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 1, false, false, false, 1685, 4, 14, 1,  0, 0}, // #848
  {DBGFIELD("VINSERTI128rm")      1, false, false, false, 1915, 5,  3, 1,  3, 1}, // #849
  {DBGFIELD("VPBLENDDrmi")        1, false, false, false, 1915, 5,  6, 1,  3, 1}, // #850
  {DBGFIELD("VPBLENDDYrmi")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #851
  {DBGFIELD("POP32r_POP64r")      1, false, false, false, 1730, 2, 14, 1,  0, 0}, // #852
  {DBGFIELD("SFENCE")             1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #853
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #854
  {DBGFIELD("MOVBE16mr")          1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #855
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #856
  {DBGFIELD("MFENCE")             1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #857
  {DBGFIELD("XGETBV")             1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #858
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 2, false, false, false, 1749, 5,  2, 1,  0, 0}, // #859
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 1, false, false, false, 1767, 5,  8, 1,  0, 0}, // #860
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm_MMX_PACKUSWBrm") 1, false, false, false, 1834, 5,  6, 1,  3, 1}, // #861
  {DBGFIELD("LRET64_RET32")       1, false, false, false, 1651, 6, 14, 1,  0, 0}, // #862
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #863
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #864
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, false, 1749, 5,  8, 1,  0, 0}, // #865
  {DBGFIELD("VCVTDQ2PSYrr")       2, false, false, false, 1767, 5,  8, 1,  0, 0}, // #866
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #867
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 1, false, false, false, 1748, 7,  9, 1,  0, 0}, // #868
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, false, 1766, 7,  9, 1,  0, 0}, // #869
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 2, false, false, false, 1766, 7,  9, 1,  0, 0}, // #870
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 1, false, false, false, 1915, 5,  3, 1,  0, 0}, // #871
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr_MMX_PACKUSWBrr") 1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #872
  {DBGFIELD("CLDEMOTE")           1, false, false, false, 1730, 2, 14, 1,  0, 0}, // #873
  {DBGFIELD("CVTSD2SI64rr_CVTSD2SIrr_CVTTSD2SI64rr_CVTTSD2SIrr_VCVTSD2SI64rr_VCVTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, false, 1756, 9, 22, 1,  0, 0}, // #874
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 2, false, false, false, 1756, 9, 22, 1,  0, 0}, // #875
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, false, 1756, 9, 22, 1,  0, 0}, // #876
  {DBGFIELD("CVTSS2SIrr_CVTTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 2, false, false, false, 1756, 9, 22, 1,  0, 0}, // #877
  {DBGFIELD("VCVTPS2PDYrr")       4, false, false, false, 1767, 5,  2, 1,  0, 0}, // #878
  {DBGFIELD("MMX_CVTPI2PDrr")     2, false, false, false, 1749, 5,  3, 1,  0, 0}, // #879
  {DBGFIELD("MMX_CVTPD2PIrr_MMX_CVTTPD2PIrr") 2, false, false, false, 1749, 5,  3, 1,  0, 0}, // #880
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 2, false, false, false, 1749, 5,  2, 1,  0, 0}, // #881
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 2, false, false, false, 1749, 5,  2, 1,  0, 0}, // #882
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 1, false, false, false, 1767, 5,  8, 1,  0, 0}, // #883
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 2, false, false, false, 2169, 5, 22, 1,  0, 0}, // #884
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, false, 1749, 5,  8, 1, 29, 1}, // #885
  {DBGFIELD("CVTSI2SSrr")         2, false, false, false, 2169, 5, 22, 1,  0, 0}, // #886
  {DBGFIELD("CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 2, false, false, false, 1749, 5,  8, 1, 29, 1}, // #887
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, false, 1749, 5,  2, 1,  0, 0}, // #888
  {DBGFIELD("VCVTSD2SI64rm_VCVTSD2SI64rm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 2, false, false, false, 1755, 11, 31, 1,  0, 0}, // #889
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int") 2, false, false, false, 1755, 11, 31, 1,  0, 0}, // #890
  {DBGFIELD("VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 2, false, false, false, 1755, 11, 31, 1,  0, 0}, // #891
  {DBGFIELD("VCVTPS2PDYrm")       5, false, false, false, 1766, 7, 22, 1,  0, 0}, // #892
  {DBGFIELD("CVTPD2PSrm")         2, false, false, false, 1748, 7, 22, 1,  0, 0}, // #893
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIrm_MMX_CVTTPD2PIrm") 2, false, false, false, 1748, 7, 22, 1,  0, 0}, // #894
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 2, false, false, false, 1748, 7, 22, 1,  0, 0}, // #895
  {DBGFIELD("MMX_CVTPI2PDrm")     2, false, false, false, 1748, 7, 22, 1,  0, 0}, // #896
  {DBGFIELD("CVTSD2SSrm")         1, false, false, false, 1766, 7,  9, 1,  0, 0}, // #897
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_VCVTSD2SSrm_Int") 1, false, false, false, 1766, 7,  9, 1,  3, 1}, // #898
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 1, false, false, false, 1834, 5,  6, 1,  0, 0}, // #899
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 45, false, false, false, 2210, 2, 89, 1,  0, 0}, // #900
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #901
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, false, 1932, 4, 14, 1,  0, 0}, // #902
  {DBGFIELD("VPCMPGTQYrm")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #903
  {DBGFIELD("VCVTSI642SSrr_VCVTSI642SSrr_Int") 2, false, false, false, 1749, 5,  8, 1, 29, 1}, // #904
  {DBGFIELD("STR16r_STR32r_STR64r") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #905
  {DBGFIELD("XSETBV")             1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #906
  {DBGFIELD("VCVTDQ2PDYrr")       4, false, false, false, 1767, 5,  2, 1,  0, 0}, // #907
  {DBGFIELD("VCVTPD2PSYrr")       4, false, false, false, 2056, 6,  2, 1,  0, 0}, // #908
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 4, false, false, false, 2056, 6,  2, 1,  0, 0}, // #909
  {DBGFIELD("VCVTDQ2PDYrm")       5, false, false, false, 1766, 7, 22, 1,  0, 0}, // #910
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 2, false, false, false, 1999, 5, 86, 2,  0, 0}, // #911
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 17, false, false, false, 2186, 2,  6, 1,  0, 0}, // #912
  {DBGFIELD("RCL8rCL")            26, false, false, false, 2212, 2, 23, 1,  0, 0}, // #913
  {DBGFIELD("RDTSC")              1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #914
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #915
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, false, 1792, 4,  9, 1,  0, 0}, // #916
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 1, false, false, false, 2204, 6,  9, 1,  0, 0}, // #917
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 1, false, false, false, 2204, 6,  9, 1,  0, 0}, // #918
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, false, 1792, 4,  9, 1,  0, 0}, // #919
  {DBGFIELD("XSAVE64")            1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #920
  {DBGFIELD("XSAVE")              1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #921
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #922
  {DBGFIELD("VMCLEARm")           1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #923
  {DBGFIELD("FLDENVm")            1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #924
  {DBGFIELD("FXRSTOR64")          1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #925
  {DBGFIELD("FSTENVm")            1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #926
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #927
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #928
  {DBGFIELD("VGATHERDPSrm_VPGATHERDDrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #929
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #930
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #931
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm_VGATHERQPSYrm_VPGATHERQDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #932
  {DBGFIELD("VGATHERQPSrm_VPGATHERQDrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #933
  {DBGFIELD("VPXORYrr")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #934
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #935
  {DBGFIELD("VPCMPGTQYrr")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #936
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #937
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #938
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 1, false, false, false, 1932, 4,  3, 1,  0, 0}, // #939
  {DBGFIELD("LRET64")             1, false, false, false, 1651, 6, 14, 1,  0, 0}, // #940
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 1, false, false, false, 1748, 7,  9, 1,  0, 0}, // #941
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 2, false, false, false, 1748, 7, 22, 1,  0, 0}, // #942
  {DBGFIELD("POPF64")             1, false, false, false, 1730, 2, 14, 1,  0, 0}, // #943
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #944
  {DBGFIELD("PCMPEQQrr")          1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #945
  {DBGFIELD("PCMPEQQrm")          1, false, false, false, 1834, 5,  6, 1,  3, 1}, // #946
  {DBGFIELD("MOV16rm")            1, false, false, false, 1730, 2, 14, 1,  0, 0}, // #947
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false, false, 1685, 4, 14, 1,  0, 0}, // #948
  {DBGFIELD("POP16rmm")           2, false, false, false, 1996, 3,  3, 1,  0, 0}, // #949
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 2, false, false, false, 1996, 3,  3, 1,  0, 0}, // #950
  {DBGFIELD("PUSHF16")            1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #951
  {DBGFIELD("LAHF")               4, false, false, false, 1745, 2, 13, 1,  0, 0}, // #952
  {DBGFIELD("ADD16mi_ADD16mi8_ADD32mi_ADD32mi8_ADD64mi32_ADD64mi8_ADD8mi_ADD8mi8_SUB16mi_SUB16mi8_SUB32mi_SUB32mi8_SUB64mi32_SUB64mi8_SUB8mi_SUB8mi8") 1, false, false, false, 1680, 5,  3, 1,  0, 0}, // #953
  {DBGFIELD("ADD16mr_ADD32mr_ADD64mr_ADD8mr_SUB16mr_SUB32mr_SUB64mr_SUB8mr") 1, false, false, false, 1680, 5,  3, 1, 24, 1}, // #954
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 2, false, false, false, 1680, 5,  3, 1,  0, 0}, // #955
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 1, false, false, false, 1680, 5,  3, 1,  0, 0}, // #956
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 1, false, false, false, 1641, 4,  1, 1,  0, 0}, // #957
  {DBGFIELD("RET16_LRET16_LRET32") 1, false, false, false, 1651, 6, 14, 1,  0, 0}, // #958
  {DBGFIELD("IRET16_IRET32_IRET64") 1, false, false, false, 1651, 6, 14, 1,  0, 0}, // #959
  {DBGFIELD("AND16mi_AND16mi8_AND32mi_AND32mi8_AND64mi32_AND64mi8_AND8mi_AND8mi8_OR16mi_OR16mi8_OR32mi_OR32mi8_OR32mi8Locked_OR64mi32_OR64mi8_OR8mi_OR8mi8_XOR16mi_XOR16mi8_XOR32mi_XOR32mi8_XOR64mi32_XOR64mi8_XOR8mi_XOR8mi8") 1, false, false, false, 1680, 5,  3, 1,  0, 0}, // #960
  {DBGFIELD("AND16mr_AND32mr_AND64mr_AND8mr_OR16mr_OR32mr_OR64mr_OR8mr_XOR16mr_XOR32mr_XOR64mr_XOR8mr") 1, false, false, false, 1680, 5,  3, 1, 24, 1}, // #961
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 8, false, false, false, 2020, 4,  8, 1,  0, 0}, // #962
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 7, false, false, false, 1659, 2,  5, 1,  0, 0}, // #963
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 8, false, false, false, 2020, 4,  8, 1,  0, 0}, // #964
  {DBGFIELD("MOVSLDUPrm")         1, false, false, false, 1701, 5,  6, 1,  0, 0}, // #965
  {DBGFIELD("MOVSLDUPrr")         1, false, false, false, 1702, 3, 13, 1,  0, 0}, // #966
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 2, false, false, false, 1642, 3,  1, 1,  0, 0}, // #967
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, false, 1676, 4,  1, 1,  0, 0}, // #968
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 1, false, false, false, 1638, 3, 13, 1,  0, 0}, // #969
  {DBGFIELD("VPBLENDWYrri")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #970
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 1, false, false, false, 1915, 5,  6, 1,  3, 1}, // #971
  {DBGFIELD("VPBLENDWYrmi")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #972
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #973
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 1, false, false, false, 1661, 5,  1, 1,  0, 0}, // #974
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 1, false, false, false, 1661, 5,  1, 1,  0, 0}, // #975
  {DBGFIELD("VPMASKMOVDYrm")      2, false, false, false, 2130, 5,  3, 1,  0, 0}, // #976
  {DBGFIELD("VPMASKMOVDrm")       1, false, false, false, 1834, 5,  3, 1,  0, 0}, // #977
  {DBGFIELD("VPMASKMOVDYmr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #978
  {DBGFIELD("VPMASKMOVDmr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #979
  {DBGFIELD("VPMASKMOVQYmr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #980
  {DBGFIELD("VPMASKMOVQmr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #981
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 1, false, false, false, 1834, 5,  6, 1,  0, 0}, // #982
  {DBGFIELD("VPGATHERDDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #983
  {DBGFIELD("VPGATHERDDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #984
  {DBGFIELD("VPGATHERDQYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #985
  {DBGFIELD("VPGATHERDQrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #986
  {DBGFIELD("VPGATHERQDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #987
  {DBGFIELD("VPGATHERQDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #988
  {DBGFIELD("VPGATHERQQYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #989
  {DBGFIELD("VPGATHERQQrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #990
  {DBGFIELD("PSLLDQri_PSRLDQri_VPSLLDQri_VPSRLDQri") 1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #991
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 2, false, false, false, 1921, 3, 13, 1,  0, 0}, // #992
  {DBGFIELD("VPERM2F128rr")       8, false, false, false, 2214, 3,  8, 1,  0, 0}, // #993
  {DBGFIELD("VPERM2F128rm")       10, false, false, false, 2217, 3,  2, 1,  0, 0}, // #994
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, false, 1702, 3, 13, 1,  0, 0}, // #995
  {DBGFIELD("VEXTRACTF128mr")     2, false, false, false, 2118, 3,  6, 1,  0, 0}, // #996
  {DBGFIELD("VINSERTF128rr")      2, false, false, false, 1667, 3, 13, 1,  0, 0}, // #997
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 2, false, false, false, 1748, 7, 22, 1,  0, 0}, // #998
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 4, false, false, false, 2055, 8, 22, 1,  0, 0}, // #999
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, false, 1756, 9, 22, 1,  0, 0}, // #1000
  {DBGFIELD("VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 2, false, false, false, 1755, 11, 31, 1,  0, 0}, // #1001
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, false, 1898, 3,  5, 1,  0, 0}, // #1002
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, false, 1898, 3,  5, 1,  0, 0}, // #1003
  {DBGFIELD("SHA256MSG2rm")       1, false, false, false, 1695, 6,  9, 1,  3, 1}, // #1004
  {DBGFIELD("SHA256MSG2rr")       1, false, false, false, 1696, 4,  8, 1,  0, 0}, // #1005
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, false, 1696, 4,  8, 1,  0, 0}, // #1006
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 1, false, false, false, 1695, 6,  9, 1,  3, 1}, // #1007
  {DBGFIELD("SHA1MSG2rr")         1, false, false, false, 1696, 4,  8, 1,  0, 0}, // #1008
  {DBGFIELD("SHA1MSG2rm")         1, false, false, false, 1695, 6,  9, 1,  3, 1}, // #1009
  {DBGFIELD("SHA1NEXTErr")        1, false, false, false, 1696, 4,  8, 1,  0, 0}, // #1010
  {DBGFIELD("SHA1NEXTErm")        1, false, false, false, 1695, 6,  9, 1,  3, 1}, // #1011
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, false, 1696, 4,  8, 1,  0, 0}, // #1012
  {DBGFIELD("SHA1RNDS4rmi")       1, false, false, false, 1695, 6,  9, 1,  3, 1}, // #1013
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, false, 1696, 4,  8, 1,  0, 0}, // #1014
  {DBGFIELD("SHA256RNDS2rm")      1, false, false, false, 1695, 6,  9, 1,  3, 1}, // #1015
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 2, false, false, false, 1642, 3,  1, 1,  0, 0}, // #1016
  {DBGFIELD("BT16mi8_BT32mi8_BT64mi8") 1, false, false, false, 1685, 4, 14, 1,  0, 0}, // #1017
  {DBGFIELD("BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 2, false, false, false, 1636, 2, 13, 1,  0, 0}, // #1018
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, false, 1749, 5,  8, 1,  0, 0}, // #1019
  {DBGFIELD("MOV8rm_MOV8rm_NOREX") 1, false, false, false, 1730, 2, 14, 1,  0, 0}, // #1020
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVZX16rm16") 1, false, false, false, 1685, 4, 14, 1,  0, 0}, // #1021
  {DBGFIELD("MOVBE16rm")          1, false, false, false, 1685, 4, 14, 1,  0, 0}, // #1022
  {DBGFIELD("ADD8i8_ADD16i16_ADD32i32_ADD64i32_AND8i8_AND16i16_AND32i32_AND64i32_OR8i8_OR16i16_OR32i32_OR64i32_SUB8i8_SUB16i16_SUB32i32_SUB64i32_XOR8i8_XOR16i16_XOR32i32_XOR64i32") 1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #1023
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32_MOVZX16rr16") 1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #1024
  {DBGFIELD("MOV32ri_MOV32ri_alt_MOV64ri32") 1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #1025
  {DBGFIELD("ADC8mr_SBB8mr")      2, false, false, false, 1680, 5,  3, 1, 24, 2}, // #1026
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1027
  {DBGFIELD("LEA16r")             2, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1028
  {DBGFIELD("LCMPXCHG8")          2, false, false, false, 1645, 6,  5, 1,  0, 0}, // #1029
  {DBGFIELD("LCMPXCHG16B")        2, false, false, false, 1645, 6,  5, 1,  0, 0}, // #1030
  {DBGFIELD("XCHG8rr_XCHG16rr_XCHG16ar") 2, false, false, false, 1642, 3,  1, 1,  0, 0}, // #1031
  {DBGFIELD("XCHG8rm_XCHG16rm")   2, false, false, false, 1680, 5, 86, 2,  0, 0}, // #1032
  {DBGFIELD("POPCNT16rr")         1, false, false, false, 1745, 2,  8, 1,  0, 0}, // #1033
  {DBGFIELD("LZCNT16rr")          2, false, false, false, 1905, 3, 13, 1,  0, 0}, // #1034
  {DBGFIELD("TZCNT16rr")          2, false, false, false, 1905, 3, 13, 1,  0, 0}, // #1035
  {DBGFIELD("RCL8m1_RCL16m1_RCL32m1_RCL64m1_RCR8m1_RCR16m1_RCR32m1_RCR64m1") 2, false, false, false, 1680, 5, 86, 2,  0, 0}, // #1036
  {DBGFIELD("RCR8mi_RCR16mi_RCR32mi_RCR64mi") 2, false, false, false, 1680, 5, 86, 2,  0, 0}, // #1037
  {DBGFIELD("RCR16rCL_RCR32rCL_RCR64rCL") 20, false, false, false, 2222, 2,  9, 1,  0, 0}, // #1038
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 2, false, false, false, 1661, 5, 13, 1,  0, 0}, // #1039
  {DBGFIELD("VEXTRACTI128rr")     1, false, false, false, 1638, 3,  1, 1,  0, 0}, // #1040
  {DBGFIELD("VEXTRACTI128mr")     1, false, false, false, 1661, 5,  1, 1,  0, 0}, // #1041
  {DBGFIELD("MMX_MOVQ2FR64rr")    1, false, false, false, 1824, 3,  1, 1,  0, 0}, // #1042
  {DBGFIELD("MMX_MOVD64rr_MMX_MOVD64to64rr") 2, false, false, false, 1702, 3, 18, 1,  0, 0}, // #1043
  {DBGFIELD("EXTRQ")              1, false, false, false, 1898, 3,  5, 1,  0, 0}, // #1044
  {DBGFIELD("INSERTQ")            1, false, false, false, 1824, 3,  5, 1,  0, 0}, // #1045
  {DBGFIELD("PABSBrr_PABSDrr_PABSWrr_PADDSBrr_PADDSWrr_PADDUSBrr_PADDUSWrr_PAVGBrr_PAVGWrr_PSIGNBrr_PSIGNDrr_PSIGNWrr_VPABSBrr_VPABSDrr_VPABSWrr_VPADDSBrr_VPADDSWrr_VPADDUSBrr_VPADDUSWrr_VPAVGBrr_VPAVGWrr_VPCMPEQQrr_VPSIGNBrr_VPSIGNDrr_VPSIGNWrr_PSUBSBrr_PSUBSWrr_PSUBUSBrr_PSUBUSWrr_VPSUBSBrr_VPSUBSWrr_VPSUBUSBrr_VPSUBUSWrr") 1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #1046
  {DBGFIELD("MMX_PADDSBrr_MMX_PADDSWrr_MMX_PADDUSBrr_MMX_PADDUSWrr_MMX_PAVGBrr_MMX_PAVGWrr_MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false, 1638, 3, 13, 1,  0, 0}, // #1047
  {DBGFIELD("VPABSBYrr_VPABSDYrr_VPABSWYrr_VPADDSBYrr_VPADDSWYrr_VPADDUSBYrr_VPADDUSWYrr_VPSUBSBYrr_VPSUBSWYrr_VPSUBUSBYrr_VPSUBUSWYrr_VPAVGBYrr_VPAVGWYrr_VPCMPEQQYrr_VPSIGNBYrr_VPSIGNDYrr_VPSIGNWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1048
  {DBGFIELD("SHA1MSG1rr")         1, false, false, false, 1696, 4,  8, 1,  0, 0}, // #1049
  {DBGFIELD("SHA1MSG1rm")         1, false, false, false, 1695, 6,  9, 1,  3, 1}, // #1050
  {DBGFIELD("VPERM2I128rr")       1, false, false, false, 1638, 3,  1, 1,  0, 0}, // #1051
  {DBGFIELD("VPERMPSYrr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1052
  {DBGFIELD("VPERMPSYrm")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1053
  {DBGFIELD("VPERMPDYri")         2, false, false, false, 1667, 3, 13, 1,  0, 0}, // #1054
  {DBGFIELD("VPERMQYri")          1, false, false, false, 1638, 3,  1, 1,  0, 0}, // #1055
  {DBGFIELD("VPERMPDYmi")         2, false, false, false, 1666, 5,  6, 1,  3, 1}, // #1056
  {DBGFIELD("VPERMDYrr")          1, false, false, false, 1638, 3,  1, 1,  0, 0}, // #1057
  {DBGFIELD("VPERMQYmi")          1, false, false, false, 1915, 5,  3, 1,  3, 1}, // #1058
  {DBGFIELD("VPERMDYrm")          1, false, false, false, 1915, 5,  3, 1,  3, 1}, // #1059
  {DBGFIELD("MOV32rr_MOV32rr_REV_MOV64rr_MOV64rr_REV") 1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #1060
  {DBGFIELD("MOVSX32rr32")        1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #1061
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV_SUB32rr_REV_SUB64rr_REV") 1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #1062
  {DBGFIELD("CMP8rr_CMP8rr_REV_CMP16rr_CMP16rr_REV_CMP32rr_CMP32rr_REV_CMP64rr_CMP64rr_REV") 1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #1063
  {DBGFIELD("VXORPSrr_VXORPDrr")  8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1064
  {DBGFIELD("VANDNPSrr_VANDNPDrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1065
  {DBGFIELD("VANDNPSYrr_VANDNPDYrr") 2, false, false, false, 2041, 3, 13, 1,  0, 0}, // #1066
  {DBGFIELD("VPXORrr")            8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1067
  {DBGFIELD("VPANDNrr")           8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1068
  {DBGFIELD("VPANDNYrr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1069
  {DBGFIELD("VPSUBBrr_VPSUBWrr_VPSUBDrr_VPSUBQrr_VPCMPGTBrr_VPCMPGTWrr_VPCMPGTDrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1070
  {DBGFIELD("VPCMPGTQrr")         1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #1071
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 45, false, false, false, 2210, 2, 89, 1,  0, 0}, // #1072
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 4, false, false, false, 2224, 2,  3, 1,  0, 0}, // #1073
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 2, false, false, false, 1636, 2, 13, 1,  0, 0}, // #1074
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 2, false, false, false, 2226, 4,  3, 1,  0, 0}, // #1075
  {DBGFIELD("ADC64ri32_SBB64ri32") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1076
  {DBGFIELD("CRC32r32r16")        5, false, false, false, 2230, 2, 14, 1,  0, 0}, // #1077
  {DBGFIELD("CRC32r32r32")        7, false, false, false, 2232, 2,  3, 1,  0, 0}, // #1078
  {DBGFIELD("CRC32r64r64")        11, false, false, false, 2234, 2,  7, 1,  0, 0}, // #1079
  {DBGFIELD("SAHF")               2, false, false, false, 1636, 2, 13, 1,  0, 0}, // #1080
  {DBGFIELD("BEXTRI32ri_BEXTRI64ri") 2, false, false, false, 1745, 2, 13, 1,  0, 0}, // #1081
  {DBGFIELD("BEXTRI32mi_BEXTRI64mi") 2, false, false, false, 2236, 2, 13, 1,  0, 0}, // #1082
  {DBGFIELD("RCR8ri")             23, false, false, false, 2238, 2, 23, 1,  0, 0}, // #1083
  {DBGFIELD("RCL16rCL")           22, false, false, false, 2240, 2,  7, 1,  0, 0}, // #1084
  {DBGFIELD("RCR16ri")            19, false, false, false, 2242, 2,  7, 1,  0, 0}, // #1085
  {DBGFIELD("RCR32rCL_RCR64rCL")  16, false, false, false, 2244, 2,  6, 1,  0, 0}, // #1086
  {DBGFIELD("RCL16ri")            21, false, false, false, 2246, 2, 18, 1,  0, 0}, // #1087
  {DBGFIELD("RCL32ri_RCL64ri")    16, false, false, false, 2248, 2,  2, 1,  0, 0}, // #1088
  {DBGFIELD("SHLD32rri8")         6, false, false, false, 1659, 2,  5, 1,  0, 0}, // #1089
  {DBGFIELD("SHRD16rri8")         6, false, false, false, 1659, 2,  5, 1,  0, 0}, // #1090
  {DBGFIELD("SHLD16rrCL")         7, false, false, false, 1659, 2,  5, 1,  0, 0}, // #1091
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 8, false, false, false, 1909, 6,  1, 1,  0, 0}, // #1092
  {DBGFIELD("TST_F")              1, false, false, false, 1932, 4,  1, 1,  0, 0}, // #1093
  {DBGFIELD("VDPPSrri")           17, false, false, false, 1804, 4, 46, 1,  0, 0}, // #1094
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr") 2, false, false, false, 1812, 4,  7, 1,  0, 0}, // #1095
  {DBGFIELD("VFRCZSDrr_VFRCZSSrr") 2, false, false, false, 2250, 4,  7, 1,  0, 0}, // #1096
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 3, false, false, false, 1812, 4, 21, 1,  0, 0}, // #1097
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 4, false, false, false, 2254, 4,  7, 1,  0, 0}, // #1098
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 8, false, false, false, 2258, 4, 21, 1,  0, 0}, // #1099
  {DBGFIELD("MMX_CVTTPD2PIrr")    2, false, false, false, 1749, 5,  3, 1,  0, 0}, // #1100
  {DBGFIELD("VMOVDQUYmr")         8, false, false, false, 1909, 6,  1, 1,  0, 0}, // #1101
  {DBGFIELD("MOVDQArr")           1, false, false, false, 1638, 3,  1, 1,  0, 0}, // #1102
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 1, false, false, false, 2262, 5,  8, 1,  0, 0}, // #1103
  {DBGFIELD("VMPSADBWrri")        10, false, false, false, 1926, 4,  2, 1,  0, 0}, // #1104
  {DBGFIELD("VPPERMrrr_VPPERMrrr_REV") 1, false, false, false, 1898, 3, 13, 1,  0, 0}, // #1105
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 3, false, false, false, 1921, 3, 14, 1,  0, 0}, // #1106
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 4, false, false, false, 1920, 5,  7, 1,  0, 0}, // #1107
  {DBGFIELD("VPCLMULQDQrr")       6, false, false, false, 1938, 4, 23, 1,  0, 0}, // #1108
  {DBGFIELD("ANDNPSrr_ANDNPDrr")  8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1109
  {DBGFIELD("MMX_PXORrr_MMX_PANDNrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1110
  {DBGFIELD("PANDNrr")            8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1111
  {DBGFIELD("MMX_PSUBBrr_MMX_PSUBDrr_MMX_PSUBWrr_MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1112
  {DBGFIELD("LCMPXCHG16_LCMPXCHG32_LCMPXCHG64") 2, false, false, false, 1645, 6,  5, 1,  0, 0}, // #1113
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 5, false, false, false, 1732, 3,  5, 1,  0, 0}, // #1114
  {DBGFIELD("LCMPXCHG8B")         2, false, false, false, 1645, 6,  5, 1,  0, 0}, // #1115
  {DBGFIELD("XCHG8rr")            2, false, false, false, 1642, 3,  1, 1,  0, 0}, // #1116
  {DBGFIELD("MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false, 1638, 3, 13, 1,  0, 0}, // #1117
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #1118
  {DBGFIELD("MMX_PCMPEQBrr_MMX_PCMPEQDrr_MMX_PCMPEQWrr_MMX_PMAXSWrr_MMX_PMINSWrr_MMX_PMAXUBrr_MMX_PMINUBrr") 1, false, false, false, 1638, 3, 13, 1,  0, 0}, // #1119
  {DBGFIELD("MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1120
  {DBGFIELD("CLAC_STAC")          1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #1121
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #1122
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1123
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, false, 1690, 4, 14, 1,  0, 0}, // #1124
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 3, false, false, false, 1921, 3, 14, 1,  0, 0}, // #1125
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, false, 1921, 3, 14, 1,  0, 0}, // #1126
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1127
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 2, false, false, false, 1767, 5,  8, 1,  0, 0}, // #1128
  {DBGFIELD("MMX_PADDSBrm_MMX_PADDSWrm_MMX_PADDUSBrm_MMX_PADDUSWrm_MMX_PAVGBrm_MMX_PAVGWrm_MMX_PCMPEQBrm_MMX_PCMPEQDrm_MMX_PCMPEQWrm_MMX_PCMPGTBrm_MMX_PCMPGTDrm_MMX_PCMPGTWrm_MMX_PMAXSWrm_MMX_PMAXUBrm_MMX_PMINSWrm_MMX_PMINUBrm_MMX_PSUBSBrm_MMX_PSUBSWrm_MMX_PSUBUSBrm_MMX_PSUBUSWrm") 1, false, false, false, 1915, 5,  6, 1,  3, 1}, // #1129
  {DBGFIELD("CVTSS2SI64rr")       2, false, false, false, 1756, 9, 22, 1,  0, 0}, // #1130
  {DBGFIELD("CVTSS2SI64rr_Int")   2, false, false, false, 1756, 9, 22, 1,  0, 0}, // #1131
  {DBGFIELD("CVTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr") 2, false, false, false, 1756, 9, 22, 1,  0, 0}, // #1132
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 2, false, false, false, 1756, 9, 22, 1,  0, 0}, // #1133
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 1, false, false, false, 1834, 5,  6, 1,  3, 1}, // #1134
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1135
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 4, false, false, false, 1920, 5,  7, 1,  3, 1}, // #1136
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, false, 1920, 5,  7, 1,  0, 0}, // #1137
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1138
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 1, false, false, false, 1657, 2,  4, 1,  0, 0}, // #1139
  {DBGFIELD("PCMPGTBrr_PCMPGTDrr_PCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1140
  {DBGFIELD("VPCMPGTBrr_VPCMPGTDrr_VPCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1141
  {DBGFIELD("VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1142
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #1143
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #1144
  {DBGFIELD("KSET0D_KSET0Q_KSET0W_KSET1D_KSET1Q_KSET1W") 1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1145
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #1146
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 1, false, false, false, 1667, 3, 13, 1,  0, 0}, // #1147
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 2, false, false, false, 2046, 3, 13, 1,  0, 0}, // #1148
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #1149
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1150
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1151
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #1152
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1153
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #1154
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 4, false, false, false, 2122, 5,  1, 1,  0, 0}, // #1155
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #1156
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #1157
  {DBGFIELD("VPSADBWZrr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1158
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #1159
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 2, false, false, false, 1921, 3, 13, 1,  0, 0}, // #1160
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1161
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1162
  {DBGFIELD("VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #1163
  {DBGFIELD("VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1164
  {DBGFIELD("VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1165
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #1166
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #1167
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, false, 1690, 4, 13, 1,  0, 0}, // #1168
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 2, false, false, false, 2035, 4, 13, 1,  0, 0}, // #1169
  {DBGFIELD("VCMPPDZrri_VCMPPDZrrib_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrrib_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1170
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, false, 1690, 4, 13, 1,  0, 0}, // #1171
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rrik_VPCMPDZ128rri_VPCMPDZ128rrik_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rrik_VPCMPUBZ128rri_VPCMPUBZ128rrik_VPCMPUDZ128rri_VPCMPUDZ128rrik_VPCMPUQZ128rri_VPCMPUQZ128rrik_VPCMPUWZ128rri_VPCMPUWZ128rrik_VPCMPWZ128rri_VPCMPWZ128rrik") 1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #1172
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rrik_VPCMPDZ256rri_VPCMPDZ256rrik_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rrik_VPCMPUBZ256rri_VPCMPUBZ256rrik_VPCMPUDZ256rri_VPCMPUDZ256rrik_VPCMPUQZ256rri_VPCMPUQZ256rrik_VPCMPUWZ256rri_VPCMPUWZ256rrik_VPCMPWZ256rri_VPCMPWZ256rrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1173
  {DBGFIELD("VPCMPBZrri_VPCMPBZrrik_VPCMPDZrri_VPCMPDZrrik_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrrik_VPCMPUBZrri_VPCMPUBZrrik_VPCMPUDZrri_VPCMPUDZrrik_VPCMPUQZrri_VPCMPUQZrrik_VPCMPUWZrri_VPCMPUWZrrik_VPCMPWZrri_VPCMPWZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1174
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1175
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1176
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 1, false, false, false, 1749, 5,  8, 1,  0, 0}, // #1177
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 2, false, false, false, 1767, 5,  8, 1,  0, 0}, // #1178
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 2, false, false, false, 1749, 5,  2, 1,  0, 0}, // #1179
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 4, false, false, false, 2056, 6,  2, 1,  0, 0}, // #1180
  {DBGFIELD("VCVTPS2DQYrr")       2, false, false, false, 1767, 5,  8, 1,  0, 0}, // #1181
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, false, 1749, 5,  8, 1,  0, 0}, // #1182
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 2, false, false, false, 1767, 5,  8, 1,  0, 0}, // #1183
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 2, false, false, false, 1749, 5,  2, 1,  0, 0}, // #1184
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 4, false, false, false, 1767, 5,  2, 1,  0, 0}, // #1185
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1186
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1187
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1188
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1189
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 1, false, false, false, 1638, 3,  1, 1,  0, 0}, // #1190
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 1, false, false, false, 1638, 3,  1, 1,  0, 0}, // #1191
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 1, false, false, false, 1915, 5,  3, 1,  0, 0}, // #1192
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 2, false, false, false, 1749, 5,  2, 1,  0, 0}, // #1193
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 2, false, false, false, 1749, 5,  2, 1,  0, 0}, // #1194
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 2, false, false, false, 1749, 5,  2, 1,  0, 0}, // #1195
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 2, false, false, false, 1749, 5,  2, 1,  0, 0}, // #1196
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false, false, 1749, 5,  8, 1,  0, 0}, // #1197
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false, false, 1749, 5,  8, 1,  0, 0}, // #1198
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 1, false, false, false, 1767, 5,  8, 1,  0, 0}, // #1199
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 2, false, false, false, 1749, 5,  8, 1, 29, 1}, // #1200
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 2, false, false, false, 1749, 5,  8, 1, 29, 1}, // #1201
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 1, false, false, false, 1767, 5,  8, 1,  0, 0}, // #1202
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #1203
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 3, false, false, false, 2071, 7,  8, 1,  0, 0}, // #1204
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 4, false, false, false, 2063, 8,  8, 1,  0, 0}, // #1205
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1206
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 1, false, false, false, 1915, 5,  3, 1,  0, 0}, // #1207
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 1, false, false, false, 1638, 3,  1, 1,  0, 0}, // #1208
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false, false, 1897, 5, 14, 1,  0, 0}, // #1209
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false, false, 1897, 5, 14, 1,  0, 0}, // #1210
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 2, false, false, false, 1749, 5,  8, 1, 29, 1}, // #1211
  {DBGFIELD("VMOVSDZrm_VMOVSDZrm_alt_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrm_alt_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, false, 1666, 5, 14, 1,  0, 0}, // #1212
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 4, false, false, false, 1767, 5,  2, 1,  0, 0}, // #1213
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 4, false, false, false, 2056, 6,  2, 1,  0, 0}, // #1214
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 4, false, false, false, 2056, 6,  2, 1,  0, 0}, // #1215
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 4, false, false, false, 1767, 5,  2, 1,  0, 0}, // #1216
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 2, false, false, false, 1767, 5,  8, 1,  0, 0}, // #1217
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 2, false, false, false, 1767, 5,  8, 1,  0, 0}, // #1218
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1219
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1220
  {DBGFIELD("VCVTPD2PSZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1221
  {DBGFIELD("VCVTPS2PDZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1222
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1223
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1224
  {DBGFIELD("VMOVNTDQAZ128rm")    1, false, false, false, 1897, 5, 14, 1,  0, 0}, // #1225
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 1, false, false, false, 1666, 5,  6, 1,  3, 1}, // #1226
  {DBGFIELD("VBROADCASTI32X2Z128rm_VBROADCASTI32X2Z128rmk_VBROADCASTI32X2Z128rmkz_VPBROADCASTDZ128rm_VPBROADCASTDZ128rmk_VPBROADCASTDZ128rmkz_VPBROADCASTQZ128rm_VPBROADCASTQZ128rmk_VPBROADCASTQZ128rmkz") 1, false, false, false, 1834, 5,  6, 1,  0, 0}, // #1227
  {DBGFIELD("VBROADCASTSSZ128rm_VBROADCASTSSZ128rmk_VBROADCASTSSZ128rmkz") 2, false, false, false, 1666, 5,  6, 1,  0, 0}, // #1228
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, false, 1666, 5, 14, 1,  0, 0}, // #1229
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 1, false, false, false, 1701, 5,  6, 1,  0, 0}, // #1230
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, false, 1897, 5, 14, 1,  0, 0}, // #1231
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 1, false, false, false, 1834, 5,  6, 1,  3, 1}, // #1232
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 1, false, false, false, 1834, 5,  6, 1,  3, 1}, // #1233
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 1, false, false, false, 1638, 3,  1, 1,  0, 0}, // #1234
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 2, false, false, false, 1756, 9, 22, 1,  0, 0}, // #1235
  {DBGFIELD("VCVTSS2SI64rr")      2, false, false, false, 1756, 9, 22, 1,  0, 0}, // #1236
  {DBGFIELD("VCVTSS2SI64rr_Int")  2, false, false, false, 1756, 9, 22, 1,  0, 0}, // #1237
  {DBGFIELD("VCVTTSS2SI64rr")     2, false, false, false, 1756, 9, 22, 1,  0, 0}, // #1238
  {DBGFIELD("VCVTTSS2SI64rr_Int") 2, false, false, false, 1756, 9, 22, 1,  0, 0}, // #1239
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, false, 1730, 2, 14, 1,  0, 0}, // #1240
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 1, false, false, false, 1915, 5,  3, 1,  0, 0}, // #1241
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #1242
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #1243
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #1244
  {DBGFIELD("VSCATTERDPSZmr")     1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #1245
  {DBGFIELD("VPBROADCASTBZ256rm_VPBROADCASTBZ256rmk_VPBROADCASTBZ256rmkz_VPBROADCASTBZrm_VPBROADCASTBZrmk_VPBROADCASTBZrmkz_VPBROADCASTWZ256rm_VPBROADCASTWZ256rmk_VPBROADCASTWZ256rmkz_VPBROADCASTWZrm_VPBROADCASTWZrmk_VPBROADCASTWZrmkz") 1, false, false, false, 1915, 5,  3, 1,  0, 0}, // #1246
  {DBGFIELD("VMOVNTDQAZ256rm")    2, false, false, false, 2102, 5, 14, 1,  0, 0}, // #1247
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 2, false, false, false, 2045, 5,  6, 1,  3, 1}, // #1248
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1249
  {DBGFIELD("VBROADCASTF32X2Z256rm_VBROADCASTF32X2Z256rmk_VBROADCASTF32X2Z256rmkz_VBROADCASTF32X2Zrm_VBROADCASTF32X2Zrmk_VBROADCASTF32X2Zrmkz_VBROADCASTI32X2Z256rm_VBROADCASTI32X2Z256rmk_VBROADCASTI32X2Z256rmkz_VBROADCASTI32X2Zrm_VBROADCASTI32X2Zrmk_VBROADCASTI32X2Zrmkz_VPBROADCASTDZ256rm_VPBROADCASTDZ256rmk_VPBROADCASTDZ256rmkz_VPBROADCASTDZrm_VPBROADCASTDZrmk_VPBROADCASTDZrmkz_VPBROADCASTQZ256rm_VPBROADCASTQZ256rmk_VPBROADCASTQZ256rmkz_VPBROADCASTQZrm_VPBROADCASTQZrmk_VPBROADCASTQZrmkz") 1, false, false, false, 1915, 5,  3, 1,  0, 0}, // #1250
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 2, false, false, false, 1920, 5,  6, 1,  0, 0}, // #1251
  {DBGFIELD("VBROADCASTSDZ256rm_VBROADCASTSDZ256rmk_VBROADCASTSDZ256rmkz_VBROADCASTSDZrm_VBROADCASTSDZrmk_VBROADCASTSDZrmkz_VBROADCASTSSZ256rm_VBROADCASTSSZ256rmk_VBROADCASTSSZ256rmkz_VBROADCASTSSZrm_VBROADCASTSSZrmk_VBROADCASTSSZrmkz") 2, false, false, false, 1666, 5,  6, 1,  0, 0}, // #1252
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 2, false, false, false, 1666, 5,  6, 1,  3, 1}, // #1253
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 1, false, false, false, 1915, 5,  3, 1,  3, 1}, // #1254
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 2, false, false, false, 1666, 5, 14, 1,  0, 0}, // #1255
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, false, 2045, 5,  6, 1,  0, 0}, // #1256
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1257
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 2, false, false, false, 2102, 5, 14, 1,  0, 0}, // #1258
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1259
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1260
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1261
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1262
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #1263
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #1264
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #1265
  {DBGFIELD("VPSCATTERDDZmr")     1, false, false, false, 1809, 2,  1, 1,  0, 0}, // #1266
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 1, false, false, false, 1834, 5,  6, 1,  3, 1}, // #1267
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 1, false, false, false, 1689, 6,  6, 1,  3, 1}, // #1268
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 1, false, false, false, 1915, 5,  3, 1,  3, 1}, // #1269
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1270
  {DBGFIELD("VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 1, false, false, false, 1834, 5,  6, 1,  3, 1}, // #1271
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmik_VFPCLASSPDZ128rm_VFPCLASSPDZ128rmb_VFPCLASSPDZ128rmbk_VFPCLASSPDZ128rmk_VFPCLASSPSZ128rm_VFPCLASSPSZ128rmb_VFPCLASSPSZ128rmbk_VFPCLASSPSZ128rmk") 1, false, false, false, 1689, 6,  6, 1,  3, 1}, // #1272
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk") 1, false, false, false, 1689, 6,  6, 1,  3, 1}, // #1273
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmik_VPCMPDZ128rmi_VPCMPDZ128rmib_VPCMPDZ128rmibk_VPCMPDZ128rmik_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmib_VPCMPQZ128rmibk_VPCMPQZ128rmik_VPCMPUBZ128rmi_VPCMPUBZ128rmik_VPCMPUDZ128rmi_VPCMPUDZ128rmib_VPCMPUDZ128rmibk_VPCMPUDZ128rmik_VPCMPUQZ128rmi_VPCMPUQZ128rmib_VPCMPUQZ128rmibk_VPCMPUQZ128rmik_VPCMPUWZ128rmi_VPCMPUWZ128rmik_VPCMPWZ128rmi_VPCMPWZ128rmik") 1, false, false, false, 1834, 5,  6, 1,  3, 1}, // #1274
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 1, false, false, false, 1834, 5,  6, 1,  3, 1}, // #1275
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 2, false, false, false, 1920, 5,  6, 1,  3, 1}, // #1276
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1277
  {DBGFIELD("VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1278
  {DBGFIELD("VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1279
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmik_VFPCLASSPDZ256rm_VFPCLASSPDZ256rmb_VFPCLASSPDZ256rmbk_VFPCLASSPDZ256rmk_VFPCLASSPSZ256rm_VFPCLASSPSZ256rmb_VFPCLASSPSZ256rmbk_VFPCLASSPSZ256rmk") 2, false, false, false, 2034, 6,  6, 1,  3, 1}, // #1280
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmik_VFPCLASSPDZrm_VFPCLASSPDZrmb_VFPCLASSPDZrmbk_VFPCLASSPDZrmk_VFPCLASSPSZrm_VFPCLASSPSZrmb_VFPCLASSPSZrmbk_VFPCLASSPSZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1281
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmik_VPCMPDZ256rmi_VPCMPDZ256rmib_VPCMPDZ256rmibk_VPCMPDZ256rmik_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmib_VPCMPQZ256rmibk_VPCMPQZ256rmik_VPCMPUBZ256rmi_VPCMPUBZ256rmik_VPCMPUDZ256rmi_VPCMPUDZ256rmib_VPCMPUDZ256rmibk_VPCMPUDZ256rmik_VPCMPUQZ256rmi_VPCMPUQZ256rmib_VPCMPUQZ256rmibk_VPCMPUQZ256rmik_VPCMPUWZ256rmi_VPCMPUWZ256rmik_VPCMPWZ256rmi_VPCMPWZ256rmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1282
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmik_VPCMPDZrmi_VPCMPDZrmib_VPCMPDZrmibk_VPCMPDZrmik_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmib_VPCMPQZrmibk_VPCMPQZrmik_VPCMPUBZrmi_VPCMPUBZrmik_VPCMPUDZrmi_VPCMPUDZrmib_VPCMPUDZrmibk_VPCMPUDZrmik_VPCMPUQZrmi_VPCMPUQZrmib_VPCMPUQZrmibk_VPCMPUQZrmik_VPCMPUWZrmi_VPCMPUWZrmik_VPCMPWZrmi_VPCMPWZrmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1283
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1284
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1285
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 2, false, false, false, 1748, 7, 22, 1,  0, 0}, // #1286
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 1, false, false, false, 1748, 7,  9, 1,  0, 0}, // #1287
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 2, false, false, false, 1748, 7, 22, 1,  0, 0}, // #1288
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 3, false, false, false, 1766, 7, 22, 1,  0, 0}, // #1289
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 1, false, false, false, 1748, 7,  9, 1,  0, 0}, // #1290
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 2, false, false, false, 1748, 7, 22, 1,  0, 0}, // #1291
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz") 1, false, false, false, 1766, 7,  9, 1,  3, 1}, // #1292
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 1, false, false, false, 1915, 5,  3, 1,  3, 1}, // #1293
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 5, false, false, false, 1766, 7, 22, 1,  0, 0}, // #1294
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1295
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, false, 1766, 7,  9, 1,  0, 0}, // #1296
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1297
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 7, false, false, false, 1766, 7, 22, 1,  0, 0}, // #1298
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1299
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 5, false, false, false, 1766, 7, 22, 1,  0, 0}, // #1300
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1301
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 4, false, false, false, 2055, 8, 22, 1,  0, 0}, // #1302
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1303
  {DBGFIELD("VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, false, 1766, 7,  9, 1,  0, 0}, // #1304
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1305
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 1, false, false, false, 1915, 5,  3, 1,  3, 1}, // #1306
  {DBGFIELD("VCVTSD2SSZrm_VCVTSD2SSZrm_Int_VCVTSD2SSZrm_Intk_VCVTSD2SSZrm_Intkz") 1, false, false, false, 1766, 7,  9, 1,  3, 1}, // #1307
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 1, false, false, false, 1834, 5,  6, 1,  0, 0}, // #1308
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, false, 1696, 4,  8, 1,  0, 0}, // #1309
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1310
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1311
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 1, false, false, false, 1915, 5,  3, 1,  3, 1}, // #1312
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 2, false, false, false, 1755, 11, 31, 1,  3, 1}, // #1313
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 2, false, false, false, 1755, 11, 31, 1,  3, 1}, // #1314
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1315
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 1, false, false, false, 1915, 5,  3, 1,  3, 1}, // #1316
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 1, false, false, false, 1915, 5,  3, 1,  3, 1}, // #1317
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1318
  {DBGFIELD("VCVTPD2PSZrm_VCVTPD2PSZrmb_VCVTPD2PSZrmbk_VCVTPD2PSZrmbkz_VCVTPD2PSZrmk_VCVTPD2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1319
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1320
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 1, false, false, false, 1915, 5,  3, 1,  3, 1}, // #1321
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 1, false, false, false, 1834, 5,  6, 1,  0, 0}, // #1322
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 1, false, false, false, 1695, 6,  9, 1,  3, 1}, // #1323
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1324
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1325
  {DBGFIELD("VGATHERQPSZ128rm_VPGATHERQDZ128rm_VGATHERDPDZ128rm_VPGATHERDQZ128rm_VGATHERQPDZ128rm_VPGATHERQQZ128rm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1326
  {DBGFIELD("VGATHERQPSZ256rm_VPGATHERQDZ256rm_VGATHERQPDZ256rm_VPGATHERQQZ256rm_VGATHERDPSZ128rm_VPGATHERDDZ128rm_VGATHERDPDZ256rm_VPGATHERDQZ256rm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1327
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm_VGATHERDPDZrm_VPGATHERDQZrm_VGATHERQPDZrm_VPGATHERQQZrm_VGATHERQPSZrm_VPGATHERQDZrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1328
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1329
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz") 1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #1330
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1331
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1332
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1333
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1334
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1335
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1336
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1337
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1338
  {DBGFIELD("VXORPSZ128rr_VXORPDZ128rr") 1, false, false, false, 1702, 3, 13, 1,  0, 0}, // #1339
  {DBGFIELD("VXORPSZ256rr_VXORPDZ256rr") 2, false, false, false, 2041, 3, 13, 1,  0, 0}, // #1340
  {DBGFIELD("VXORPSZrr_VXORPDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1341
  {DBGFIELD("VPXORDZ128rr_VPXORQZ128rr") 1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #1342
  {DBGFIELD("VPXORDZ256rr_VPXORQZ256rr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1343
  {DBGFIELD("VPXORDZrr_VPXORQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1344
  {DBGFIELD("VPSUBBZ128rr_VPSUBDZ128rr_VPSUBQZ128rr_VPSUBWZ128rr") 1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #1345
  {DBGFIELD("VPSUBBZ256rr_VPSUBDZ256rr_VPSUBQZ256rr_VPSUBWZ256rr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1346
  {DBGFIELD("VPSUBBZrr_VPSUBDZrr_VPSUBQZrr_VPSUBWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1347
  {DBGFIELD("VPBROADCASTDrr_VPBROADCASTQrr_PALIGNRrri_VPALIGNRZ128rri_VPALIGNRZ128rrik_VPALIGNRZ128rrikz_VPALIGNRrri_PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWZ128rr_VPACKSSDWZ128rrk_VPACKSSDWZ128rrkz_VPACKSSDWrr_VPACKSSWBZ128rr_VPACKSSWBZ128rrk_VPACKSSWBZ128rrkz_VPACKSSWBrr_VPACKUSDWZ128rr_VPACKUSDWZ128rrk_VPACKUSDWZ128rrkz_VPACKUSDWrr_VPACKUSWBZ128rr_VPACKUSWBZ128rrk_VPACKUSWBZ128rrkz_VPACKUSWBrr") 1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #1348
  {DBGFIELD("INSERTPSrr_VINSERTPSZrr_VINSERTPSrr_MOVHLPSrr_MOVLHPSrr_VMOVHLPSZrr_VMOVHLPSrr_VMOVLHPSZrr_VMOVLHPSrr_MOVDDUPrr_VMOVDDUPZ128rr_VMOVDDUPZ128rrk_VMOVDDUPZ128rrkz_VMOVDDUPrr_VPERMILPDZ128ri_VPERMILPDZ128rik_VPERMILPDZ128rikz_VPERMILPDri_VPERMILPSZ128ri_VPERMILPSZ128rik_VPERMILPSZ128rikz_VPERMILPSri_UNPCKHPDrr_UNPCKHPSrr_UNPCKLPDrr_UNPCKLPSrr_VUNPCKHPDZ128rr_VUNPCKHPDZ128rrk_VUNPCKHPDZ128rrkz_VUNPCKHPDrr_VUNPCKHPSZ128rr_VUNPCKHPSZ128rrk_VUNPCKHPSZ128rrkz_VUNPCKHPSrr_VUNPCKLPDZ128rr_VUNPCKLPDZ128rrk_VUNPCKLPDZ128rrkz_VUNPCKLPDrr_VUNPCKLPSZ128rr_VUNPCKLPSZ128rrk_VUNPCKLPSZ128rrkz_VUNPCKLPSrr") 1, false, false, false, 1702, 3, 13, 1,  0, 0}, // #1349
  {DBGFIELD("VMOVDDUPYrr_VMOVDDUPZ256rr_VMOVDDUPZ256rrk_VMOVDDUPZ256rrkz_VPERMILPDYri_VPERMILPDZ256ri_VPERMILPDZ256rik_VPERMILPDZ256rikz_VPERMILPSYri_VPERMILPSZ256ri_VPERMILPSZ256rik_VPERMILPSZ256rikz_VUNPCKHPDYrr_VUNPCKHPDZ256rr_VUNPCKHPDZ256rrk_VUNPCKHPDZ256rrkz_VUNPCKHPSYrr_VUNPCKHPSZ256rr_VUNPCKHPSZ256rrk_VUNPCKHPSZ256rrkz_VUNPCKLPDYrr_VUNPCKLPDZ256rr_VUNPCKLPDZ256rrk_VUNPCKLPDZ256rrkz_VUNPCKLPSYrr_VUNPCKLPSZ256rr_VUNPCKLPSZ256rrk_VUNPCKLPSZ256rrkz") 2, false, false, false, 2046, 3, 13, 1,  0, 0}, // #1350
  {DBGFIELD("VMOVDDUPZrr_VMOVDDUPZrrk_VMOVDDUPZrrkz_VPERMILPDZri_VPERMILPDZrik_VPERMILPDZrikz_VPERMILPSZri_VPERMILPSZrik_VPERMILPSZrikz_VUNPCKHPDZrr_VUNPCKHPDZrrk_VUNPCKHPDZrrkz_VUNPCKHPSZrr_VUNPCKHPSZrrk_VUNPCKHPSZrrkz_VUNPCKLPDZrr_VUNPCKLPDZrrk_VUNPCKLPDZrrkz_VUNPCKLPSZrr_VUNPCKLPSZrrk_VUNPCKLPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1351
  {DBGFIELD("VPALIGNRYrri_VPALIGNRZ256rri_VPALIGNRZ256rrik_VPALIGNRZ256rrikz_VPACKSSDWYrr_VPACKSSDWZ256rr_VPACKSSDWZ256rrk_VPACKSSDWZ256rrkz_VPACKSSWBYrr_VPACKSSWBZ256rr_VPACKSSWBZ256rrk_VPACKSSWBZ256rrkz_VPACKUSDWYrr_VPACKUSDWZ256rr_VPACKUSDWZ256rrk_VPACKUSDWZ256rrkz_VPACKUSWBYrr_VPACKUSWBZ256rr_VPACKUSWBZ256rrk_VPACKUSWBZ256rrkz") 2, false, false, false, 1921, 3, 13, 1,  0, 0}, // #1352
  {DBGFIELD("VPALIGNRZrri_VPALIGNRZrrik_VPALIGNRZrrikz_VPACKSSDWZrr_VPACKSSDWZrrk_VPACKSSDWZrrkz_VPACKSSWBZrr_VPACKSSWBZrrk_VPACKSSWBZrrkz_VPACKUSDWZrr_VPACKUSDWZrrk_VPACKUSDWZrrkz_VPACKUSWBZrr_VPACKUSWBZrrk_VPACKUSWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1353
  {DBGFIELD("VPERMILPDYrr_VPERMILPDZ256rr_VPERMILPDZ256rrk_VPERMILPDZ256rrkz_VPERMILPSYrr_VPERMILPSZ256rr_VPERMILPSZ256rrk_VPERMILPSZ256rrkz") 2, false, false, false, 2046, 3,  5, 1,  0, 0}, // #1354
  {DBGFIELD("VPERMILPDZ128rr_VPERMILPDZ128rrk_VPERMILPDZ128rrkz_VPERMILPDrr_VPERMILPSZ128rr_VPERMILPSZ128rrk_VPERMILPSZ128rrkz_VPERMILPSrr") 1, false, false, false, 1702, 3,  5, 1,  0, 0}, // #1355
  {DBGFIELD("VPERMILPDZrr_VPERMILPDZrrk_VPERMILPDZrrkz_VPERMILPSZrr_VPERMILPSZrrk_VPERMILPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1356
  {DBGFIELD("MOVSDrr_MOVSDrr_REV_VMOVSDZrr_VMOVSDZrr_REV_VMOVSDZrrk_VMOVSDZrrk_REV_VMOVSDZrrkz_VMOVSDZrrkz_REV_VMOVSDrr_VMOVSDrr_REV_VMOVSSZrr_VMOVSSZrr_REV_VMOVSSZrrk_VMOVSSZrrk_REV_VMOVSSZrrkz_VMOVSSZrrkz_REV_VMOVSSrr_VMOVSSrr_REV") 1, false, false, false, 1702, 3, 13, 1,  0, 0}, // #1357
  {DBGFIELD("VPBROADCASTBZ128rm_VPBROADCASTBZ128rmk_VPBROADCASTBZ128rmkz_VPBROADCASTWZ128rm_VPBROADCASTWZ128rmk_VPBROADCASTWZ128rmkz") 1, false, false, false, 1834, 5,  6, 1,  0, 0}, // #1358
  {DBGFIELD("INSERTPSrm_VINSERTPSZrm_VINSERTPSrm_UNPCKHPDrm_UNPCKHPSrm_UNPCKLPDrm_UNPCKLPSrm_VUNPCKHPDZ128rm_VUNPCKHPDZ128rmb_VUNPCKHPDZ128rmbk_VUNPCKHPDZ128rmbkz_VUNPCKHPDZ128rmk_VUNPCKHPDZ128rmkz_VUNPCKHPDrm_VUNPCKHPSZ128rm_VUNPCKHPSZ128rmb_VUNPCKHPSZ128rmbk_VUNPCKHPSZ128rmbkz_VUNPCKHPSZ128rmk_VUNPCKHPSZ128rmkz_VUNPCKHPSrm_VUNPCKLPDZ128rm_VUNPCKLPDZ128rmb_VUNPCKLPDZ128rmbk_VUNPCKLPDZ128rmbkz_VUNPCKLPDZ128rmk_VUNPCKLPDZ128rmkz_VUNPCKLPDrm_VUNPCKLPSZ128rm_VUNPCKLPSZ128rmb_VUNPCKLPSZ128rmbk_VUNPCKLPSZ128rmbkz_VUNPCKLPSZ128rmk_VUNPCKLPSZ128rmkz_VUNPCKLPSrm") 1, false, false, false, 1701, 5,  6, 1,  3, 1}, // #1359
  {DBGFIELD("PALIGNRrmi_VPALIGNRZ128rmi_VPALIGNRZ128rmik_VPALIGNRZ128rmikz_VPALIGNRrmi_PACKSSDWrm_PACKSSWBrm_PACKUSDWrm_PACKUSWBrm_VPACKSSDWZ128rm_VPACKSSDWZ128rmb_VPACKSSDWZ128rmbk_VPACKSSDWZ128rmbkz_VPACKSSDWZ128rmk_VPACKSSDWZ128rmkz_VPACKSSDWrm_VPACKSSWBZ128rm_VPACKSSWBZ128rmk_VPACKSSWBZ128rmkz_VPACKSSWBrm_VPACKUSDWZ128rm_VPACKUSDWZ128rmb_VPACKUSDWZ128rmbk_VPACKUSDWZ128rmbkz_VPACKUSDWZ128rmk_VPACKUSDWZ128rmkz_VPACKUSDWrm_VPACKUSWBZ128rm_VPACKUSWBZ128rmk_VPACKUSWBZ128rmkz_VPACKUSWBrm") 1, false, false, false, 1834, 5,  6, 1,  3, 1}, // #1360
  {DBGFIELD("VPERMILPDZ128mbi_VPERMILPDZ128mbik_VPERMILPDZ128mbikz_VPERMILPDZ128mi_VPERMILPDZ128mik_VPERMILPDZ128mikz_VPERMILPDmi_VPERMILPSZ128mbi_VPERMILPSZ128mbik_VPERMILPSZ128mbikz_VPERMILPSZ128mi_VPERMILPSZ128mik_VPERMILPSZ128mikz_VPERMILPSmi") 1, false, false, false, 1701, 5,  6, 1,  0, 0}, // #1361
  {DBGFIELD("VPERMILPDZ128rm_VPERMILPDZ128rmb_VPERMILPDZ128rmbk_VPERMILPDZ128rmbkz_VPERMILPDZ128rmk_VPERMILPDZ128rmkz_VPERMILPDrm_VPERMILPSZ128rm_VPERMILPSZ128rmb_VPERMILPSZ128rmbk_VPERMILPSZ128rmbkz_VPERMILPSZ128rmk_VPERMILPSZ128rmkz_VPERMILPSrm") 1, false, false, false, 1701, 5,  2, 1,  3, 1}, // #1362
  {DBGFIELD("VPALIGNRYrmi_VPALIGNRZ256rmi_VPALIGNRZ256rmik_VPALIGNRZ256rmikz_VPACKSSDWYrm_VPACKSSDWZ256rm_VPACKSSDWZ256rmb_VPACKSSDWZ256rmbk_VPACKSSDWZ256rmbkz_VPACKSSDWZ256rmk_VPACKSSDWZ256rmkz_VPACKSSWBYrm_VPACKSSWBZ256rm_VPACKSSWBZ256rmk_VPACKSSWBZ256rmkz_VPACKUSDWYrm_VPACKUSDWZ256rm_VPACKUSDWZ256rmb_VPACKUSDWZ256rmbk_VPACKUSDWZ256rmbkz_VPACKUSDWZ256rmk_VPACKUSDWZ256rmkz_VPACKUSWBYrm_VPACKUSWBZ256rm_VPACKUSWBZ256rmk_VPACKUSWBZ256rmkz") 2, false, false, false, 1920, 5,  6, 1,  3, 1}, // #1363
  {DBGFIELD("VPALIGNRZrmi_VPALIGNRZrmik_VPALIGNRZrmikz_VPACKSSDWZrm_VPACKSSDWZrmb_VPACKSSDWZrmbk_VPACKSSDWZrmbkz_VPACKSSDWZrmk_VPACKSSDWZrmkz_VPACKSSWBZrm_VPACKSSWBZrmk_VPACKSSWBZrmkz_VPACKUSDWZrm_VPACKUSDWZrmb_VPACKUSDWZrmbk_VPACKUSDWZrmbkz_VPACKUSDWZrmk_VPACKUSDWZrmkz_VPACKUSWBZrm_VPACKUSWBZrmk_VPACKUSWBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1364
  {DBGFIELD("VPERMILPDYmi_VPERMILPDZ256mbi_VPERMILPDZ256mbik_VPERMILPDZ256mbikz_VPERMILPDZ256mi_VPERMILPDZ256mik_VPERMILPDZ256mikz_VPERMILPSYmi_VPERMILPSZ256mbi_VPERMILPSZ256mbik_VPERMILPSZ256mbikz_VPERMILPSZ256mi_VPERMILPSZ256mik_VPERMILPSZ256mikz") 2, false, false, false, 2045, 5,  6, 1,  0, 0}, // #1365
  {DBGFIELD("VPERMILPDZmbi_VPERMILPDZmbik_VPERMILPDZmbikz_VPERMILPDZmi_VPERMILPDZmik_VPERMILPDZmikz_VPERMILPSZmbi_VPERMILPSZmbik_VPERMILPSZmbikz_VPERMILPSZmi_VPERMILPSZmik_VPERMILPSZmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1366
  {DBGFIELD("VPERMILPDYrm_VPERMILPDZ256rm_VPERMILPDZ256rmb_VPERMILPDZ256rmbk_VPERMILPDZ256rmbkz_VPERMILPDZ256rmk_VPERMILPDZ256rmkz_VPERMILPSYrm_VPERMILPSZ256rm_VPERMILPSZ256rmb_VPERMILPSZ256rmbk_VPERMILPSZ256rmbkz_VPERMILPSZ256rmk_VPERMILPSZ256rmkz") 2, false, false, false, 2045, 5,  2, 1,  3, 1}, // #1367
  {DBGFIELD("VPERMILPDZrm_VPERMILPDZrmb_VPERMILPDZrmbk_VPERMILPDZrmbkz_VPERMILPDZrmk_VPERMILPDZrmkz_VPERMILPSZrm_VPERMILPSZrmb_VPERMILPSZrmbk_VPERMILPSZrmbkz_VPERMILPSZrmk_VPERMILPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1368
  {DBGFIELD("VUNPCKHPDYrm_VUNPCKHPDZ256rm_VUNPCKHPDZ256rmb_VUNPCKHPDZ256rmbk_VUNPCKHPDZ256rmbkz_VUNPCKHPDZ256rmk_VUNPCKHPDZ256rmkz_VUNPCKHPSYrm_VUNPCKHPSZ256rm_VUNPCKHPSZ256rmb_VUNPCKHPSZ256rmbk_VUNPCKHPSZ256rmbkz_VUNPCKHPSZ256rmk_VUNPCKHPSZ256rmkz_VUNPCKLPDYrm_VUNPCKLPDZ256rm_VUNPCKLPDZ256rmb_VUNPCKLPDZ256rmbk_VUNPCKLPDZ256rmbkz_VUNPCKLPDZ256rmk_VUNPCKLPDZ256rmkz_VUNPCKLPSYrm_VUNPCKLPSZ256rm_VUNPCKLPSZ256rmb_VUNPCKLPSZ256rmbk_VUNPCKLPSZ256rmbkz_VUNPCKLPSZ256rmk_VUNPCKLPSZ256rmkz") 2, false, false, false, 2045, 5,  6, 1,  3, 1}, // #1369
  {DBGFIELD("VUNPCKHPDZrm_VUNPCKHPDZrmb_VUNPCKHPDZrmbk_VUNPCKHPDZrmbkz_VUNPCKHPDZrmk_VUNPCKHPDZrmkz_VUNPCKHPSZrm_VUNPCKHPSZrmb_VUNPCKHPSZrmbk_VUNPCKHPSZrmbkz_VUNPCKHPSZrmk_VUNPCKHPSZrmkz_VUNPCKLPDZrm_VUNPCKLPDZrmb_VUNPCKLPDZrmbk_VUNPCKLPDZrmbkz_VUNPCKLPDZrmk_VUNPCKLPDZrmkz_VUNPCKLPSZrm_VUNPCKLPSZrmb_VUNPCKLPSZrmbk_VUNPCKLPSZrmbkz_VUNPCKLPSZrmk_VUNPCKLPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1370
  {DBGFIELD("PdWriteZeroLatency") 1, false, false, false,  0, 0,  0, 1,  0, 0}, // #1371
  {DBGFIELD("WriteVecALU")        1, false, false, false, 1638, 3, 13, 1,  0, 0}, // #1372
  {DBGFIELD("JWriteZeroLatency")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1373
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1374
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1375
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1376
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1377
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1378
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1379
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1380
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1381
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1382
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1383
  {DBGFIELD("JWriteLOCK_CMPXCHG8B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1384
  {DBGFIELD("JWriteLOCK_CMPXCHG16B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1385
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1386
  {DBGFIELD("JWriteLOCK_CMPXCHGrm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1387
  {DBGFIELD("JWriteCMPXCHG8B")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1388
  {DBGFIELD("JWriteCMPXCHG16B")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1389
  {DBGFIELD("JWriteCMPXCHG8rm")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1390
  {DBGFIELD("WriteCMPXCHGRMW")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1391
  {DBGFIELD("JWriteCMPXCHG8rr")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1392
  {DBGFIELD("WriteCMPXCHG")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1393
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1394
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1395
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1396
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1397
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1398
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1399
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1400
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1401
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1402
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1403
  {DBGFIELD("JWriteLOCK_XADDrm_XCHG_Part_JWriteXCHGrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1404
  {DBGFIELD("JWriteXADDrm_XCHG_Part_JWriteXADDrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1405
  {DBGFIELD("SBWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1406
  {DBGFIELD("WriteALU")           1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #1407
  {DBGFIELD("HWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1408
  {DBGFIELD("BWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1409
  {DBGFIELD("Zn3WriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1410
  {DBGFIELD("SKLWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1411
  {DBGFIELD("SKXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1412
  {DBGFIELD("ICXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1413
  {DBGFIELD("WriteFLogic")        1, false, false, false, 1702, 3, 13, 1,  0, 0}, // #1414
  {DBGFIELD("WriteFLogicY")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1415
  {DBGFIELD("JWriteZeroIdiomYmm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1416
  {DBGFIELD("WriteVecLogicX")     1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #1417
  {DBGFIELD("WriteVecALUX")       1, false, false, false, 1824, 3, 13, 1,  0, 0}, // #1418
  {DBGFIELD("SKLWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1419
  {DBGFIELD("SKXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1420
  {DBGFIELD("ICXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1421
  {DBGFIELD("SBWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1422
  {DBGFIELD("HWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1423
  {DBGFIELD("BWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1424
  {DBGFIELD("SKLWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1425
  {DBGFIELD("SKXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1426
  {DBGFIELD("ICXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1427
  {DBGFIELD("SBWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1428
  {DBGFIELD("WriteCMOV")          0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1429
  {DBGFIELD("HWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1430
  {DBGFIELD("BWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1431
  {DBGFIELD("SKLWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1432
  {DBGFIELD("SKXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1433
  {DBGFIELD("ICXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1434
  {DBGFIELD("SBWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1435
  {DBGFIELD("WriteCMOVLd")        1, false, false, false, 1726, 4, 14, 1,  0, 0}, // #1436
  {DBGFIELD("HWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1437
  {DBGFIELD("BWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1438
  {DBGFIELD("PdWriteCMOVm")       2, false, false, false, 2226, 4, 14, 1,  0, 0}, // #1439
  {DBGFIELD("SKLWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1440
  {DBGFIELD("SKXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1441
  {DBGFIELD("ICXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1442
  {DBGFIELD("SBWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1443
  {DBGFIELD("WriteSETCC")         0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1444
  {DBGFIELD("HWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1445
  {DBGFIELD("BWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1446
  {DBGFIELD("SKLWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1447
  {DBGFIELD("SKXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1448
  {DBGFIELD("ICXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1449
  {DBGFIELD("SBWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1450
  {DBGFIELD("WriteSETCCStore")    1, false, false, false, 2016, 4,  1, 1,  0, 0}, // #1451
  {DBGFIELD("HWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1452
  {DBGFIELD("BWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1453
  {DBGFIELD("PdWriteSETGEmSETGmSETLEmSETLm") 2, false, false, false, 1636, 2,  1, 1,  0, 0}, // #1454
  {DBGFIELD("SKLWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1455
  {DBGFIELD("SKXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1456
  {DBGFIELD("ICXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1457
  {DBGFIELD("WriteVecLogicY")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1458
  {DBGFIELD("WriteVecALUY")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1459
  {DBGFIELD("HWWriteADC0")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1460
  {DBGFIELD("WriteADC")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1461
  {DBGFIELD("JWriteLOCK_ALURMW")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1462
  {DBGFIELD("WriteALURMW")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1463
  {DBGFIELD("WriteFShuffle256")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1464
  {DBGFIELD("Zn3Write3OpsLEA")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1465
  {DBGFIELD("WriteLEA")           1, false, false, false, 1636, 2,  1, 1,  0, 0}, // #1466
  {DBGFIELD("PdWrite3OpsLEA")     1, false, false, false, 1636, 2, 13, 1,  0, 0}, // #1467
  {DBGFIELD("JWrite3OpsLEA")      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1468
  {DBGFIELD("WriteVecLogic")      1, false, false, false, 1638, 3, 13, 1,  0, 0}, // #1469
  {DBGFIELD("WriteFLogicZ")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1470
  {DBGFIELD("WriteVecLogicZ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1471
}; // BdVer2ModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc BroadwellModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, false, 154, 4,  1, 1,  0, 0}, // #3
  {DBGFIELD("WriteJump")          1, false, false, false,  8, 4,  1, 1,  0, 0}, // #4
  {DBGFIELD("WriteCMPXCHGRMW")    6, false, false, false, 12, 8,  2, 1,  0, 0}, // #5
  {DBGFIELD("WriteJumpLd")        2, false, false, false, 20, 6,  3, 1,  0, 0}, // #6
  {DBGFIELD("WriteMove")          1, false, false, false,  1, 2,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, false,  1, 2,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteADC")           1, false, false, false,  8, 4,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteSHDrri")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreX")       2, false, false, false, 33, 4,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteFLoadX")        1, false, false, false, 37, 3, 14, 1,  0, 0}, // #12
  {DBGFIELD("WriteFStoreY")       2, false, false, false, 33, 4,  1, 1,  0, 0}, // #13
  {DBGFIELD("WriteFLoadY")        1, false, false, false, 37, 3,  3, 1,  0, 0}, // #14
  {DBGFIELD("WriteMicrocoded")    1, false, false, false,  1, 2,  4, 1,  0, 0}, // #15
  {DBGFIELD("WriteFSign")         1, false, false, false, 474, 8,  1, 1,  0, 0}, // #16
  {DBGFIELD("WriteADCRMW")        6, false, false, false, 12, 8,  2, 1,  0, 0}, // #17
  {DBGFIELD("WriteADCRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 6, false, false, false, 12, 8,  2, 1,  1, 2}, // #18
  {DBGFIELD("WriteADCLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 20, 6,  3, 1,  3, 2}, // #19
  {DBGFIELD("WriteALURMW")        3, false, false, false, 49, 6,  6, 1,  0, 0}, // #20
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, false, 49, 6,  6, 1,  1, 1}, // #21
  {DBGFIELD("WriteALULd_ReadAfterLd") 2, false, false, false, 55, 4,  3, 1,  3, 1}, // #22
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #23
  {DBGFIELD("WriteFAdd64X")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #24
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #25
  {DBGFIELD("WriteFAddX")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #26
  {DBGFIELD("WriteNop")           1, false, false, false,  0, 0,  1, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #28
  {DBGFIELD("WriteFAdd64")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #29
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #30
  {DBGFIELD("WriteFAdd")          1, false, false, false, 26, 7,  5, 1,  0, 0}, // #31
  {DBGFIELD("WriteFAddLd")        2, false, false, false, 158, 9,  2, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 2, false, false, false, 464, 10, 23, 1,  3, 1}, // #33
  {DBGFIELD("WriteAESDecEnc")     1, false, false, false, 474, 8,  6, 1,  0, 0}, // #34
  {DBGFIELD("WriteAESIMCLd")      3, false, false, false, 531, 10, 20, 1,  0, 0}, // #35
  {DBGFIELD("WriteAESIMC")        2, false, false, false, 523, 8, 10, 1,  0, 0}, // #36
  {DBGFIELD("WriteAESKeyGenLd")   11, false, false, false, 2267, 14, 90, 1,  0, 0}, // #37
  {DBGFIELD("WriteAESKeyGen")     11, false, false, false, 2281, 12, 15, 1,  0, 0}, // #38
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #39
  {DBGFIELD("WriteFLogic")        1, false, false, false, 474, 8,  1, 1,  0, 0}, // #40
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, false, 126, 8,  6, 1,  1, 1}, // #41
  {DBGFIELD("WriteBEXTR")         2, false, false, false, 134, 6, 13, 1,  0, 0}, // #42
  {DBGFIELD("WriteBEXTRLd")       3, false, false, false, 126, 8,  6, 1,  0, 0}, // #43
  {DBGFIELD("WriteALULd")         2, false, false, false, 55, 4,  3, 1,  0, 0}, // #44
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 2, false, false, false, 60, 5,  3, 1,  3, 1}, // #45
  {DBGFIELD("WriteFBlend")        1, false, false, false, 30, 3,  1, 1,  0, 0}, // #46
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 3, false, false, false, 531, 10,  6, 1,  3, 1}, // #47
  {DBGFIELD("WriteFVarBlend")     2, false, false, false, 523, 8, 13, 1,  0, 0}, // #48
  {DBGFIELD("WriteBLSLd")         2, false, false, false, 148, 6,  3, 1,  0, 0}, // #49
  {DBGFIELD("WriteBLS")           1, false, false, false, 154, 4,  1, 1,  0, 0}, // #50
  {DBGFIELD("WriteBSFLd")         2, false, false, false, 158, 9,  2, 1,  0, 0}, // #51
  {DBGFIELD("WriteBSF")           1, false, false, false, 26, 7,  5, 1,  0, 0}, // #52
  {DBGFIELD("WriteBSRLd")         2, false, false, false, 158, 9,  2, 1,  0, 0}, // #53
  {DBGFIELD("WriteBSR")           1, false, false, false, 26, 7,  5, 1,  0, 0}, // #54
  {DBGFIELD("WriteBSWAP32")       1, false, false, false, 154, 4,  1, 1,  0, 0}, // #55
  {DBGFIELD("WriteBSWAP64")       2, false, false, false, 134, 6, 13, 1,  0, 0}, // #56
  {DBGFIELD("WriteBitTestImmLd")  2, false, false, false, 20, 6,  3, 1,  0, 0}, // #57
  {DBGFIELD("WriteBitTestRegLd")  2, false, false, false, 55, 4,  3, 1,  0, 0}, // #58
  {DBGFIELD("WriteBitTest")       1, false, false, false,  8, 4,  1, 1,  0, 0}, // #59
  {DBGFIELD("WriteBitTestSetImmRMW") 4, false, false, false, 167, 8,  3, 1,  0, 0}, // #60
  {DBGFIELD("WriteBitTestSetRegRMW") 3, false, false, false, 49, 6,  3, 1,  0, 0}, // #61
  {DBGFIELD("WriteBitTestSet")    1, false, false, false,  8, 4,  1, 1,  0, 0}, // #62
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 148, 6,  3, 1,  1, 1}, // #63
  {DBGFIELD("WriteBZHI")          1, false, false, false, 154, 4,  1, 1,  0, 0}, // #64
  {DBGFIELD("WriteLoad")          1, false, false, false, 37, 3, 14, 1,  0, 0}, // #65
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 2, false, false, false, 20, 6,  3, 1,  3, 1}, // #66
  {DBGFIELD("WriteCMOV")          1, false, false, false,  8, 4,  1, 1,  0, 0}, // #67
  {DBGFIELD("WriteFCMOV")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #68
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 55, 4,  3, 1,  1, 1}, // #69
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #70
  {DBGFIELD("WriteFCmp64X")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #71
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #72
  {DBGFIELD("WriteFCmpX")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #73
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #74
  {DBGFIELD("WriteFCmp64")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #75
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #76
  {DBGFIELD("WriteFCmp")          1, false, false, false, 26, 7,  5, 1,  0, 0}, // #77
  {DBGFIELD("WriteCMPXCHG")       5, false, false, false, 175, 4, 14, 1,  0, 0}, // #78
  {DBGFIELD("WriteFComXLd_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #79
  {DBGFIELD("WriteFComX")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #80
  {DBGFIELD("WriteFCom")          1, false, false, false, 26, 7,  5, 1,  0, 0}, // #81
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #82
  {DBGFIELD("WriteCRC32")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #83
  {DBGFIELD("WriteCvtI2PDLd")     2, false, false, false, 158, 9,  9, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtI2PD")       1, false, false, false, 26, 7,  8, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtI2PSLd")     2, false, false, false, 158, 9,  9, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtI2PS")       1, false, false, false, 26, 7,  8, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtPD2ILd")     2, false, false, false, 158, 9,  2, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtPD2I")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtPD2PSLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPD2PS")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPS2ILd")     2, false, false, false, 158, 9,  2, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtPS2I")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtPS2PD")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtSD2ILd")     2, false, false, false, 158, 9,  2, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtSD2I")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtSD2SSLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #100
  {DBGFIELD("WriteCvtSD2SS")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, false, 158, 9,  9, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 2, false, false, false, 158, 9,  9, 1,  3, 1}, // #103
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 1, false, false, false, 26, 7,  8, 1,  0, 1}, // #104
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 1, false, false, false, 26, 7,  8, 1,  6, 1}, // #105
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, false, 158, 9,  9, 1,  0, 0}, // #106
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 2, false, false, false, 158, 9,  9, 1,  3, 1}, // #107
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 1, false, false, false, 26, 7,  8, 1,  0, 1}, // #108
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 1, false, false, false, 26, 7,  8, 1,  6, 1}, // #109
  {DBGFIELD("WriteCvtSS2SDLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #110
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #111
  {DBGFIELD("WriteCvtSS2SD")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #112
  {DBGFIELD("WriteCvtSS2ILd")     2, false, false, false, 158, 9,  2, 1,  0, 0}, // #113
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #114
  {DBGFIELD("WriteCvtSS2I")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #115
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 2293, 16, 58, 1,  1, 2}, // #116
  {DBGFIELD("WriteDiv16")         32, false, false, false, 2309, 15, 91, 1,  0, 0}, // #117
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 2293, 16, 58, 1,  1, 2}, // #118
  {DBGFIELD("WriteDiv32")         32, false, false, false, 2309, 15, 91, 1,  0, 0}, // #119
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 2293, 16, 58, 1,  1, 2}, // #120
  {DBGFIELD("WriteDiv64")         32, false, false, false, 2309, 15, 91, 1,  0, 0}, // #121
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 2293, 16, 58, 1,  1, 2}, // #122
  {DBGFIELD("WriteDiv8")          1, false, false, false, 206, 10, 11, 1,  0, 0}, // #123
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 2, false, false, false, 769, 12, 20, 1,  3, 1}, // #124
  {DBGFIELD("WriteFDiv64X")       1, false, false, false, 2324, 10, 10, 1,  0, 0}, // #125
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 2, false, false, false, 238, 12, 19, 1,  3, 1}, // #126
  {DBGFIELD("WriteFDivX")         1, false, false, false, 781, 10, 18, 1,  0, 0}, // #127
  {DBGFIELD("WriteFDivLd")        2, false, false, false, 238, 12, 19, 1,  0, 0}, // #128
  {DBGFIELD("WriteFDiv")          1, false, false, false, 228, 10, 18, 1,  0, 0}, // #129
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 2, false, false, false, 769, 12, 20, 1,  3, 1}, // #130
  {DBGFIELD("WriteFDiv64")        1, false, false, false, 2334, 10, 10, 1,  0, 0}, // #131
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 2, false, false, false, 238, 12, 19, 1,  3, 1}, // #132
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 4, false, false, false, 2344, 16, 10, 1,  3, 1}, // #133
  {DBGFIELD("WriteDPPD")          3, false, false, false, 2360, 14,  9, 1,  0, 0}, // #134
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 5, false, false, false, 2374, 16, 20, 1,  3, 1}, // #135
  {DBGFIELD("WriteDPPS")          4, false, false, false, 2390, 14, 10, 1,  0, 0}, // #136
  {DBGFIELD("WriteStore")         1, false, false, false, 33, 4,  1, 1,  0, 0}, // #137
  {DBGFIELD("WriteVecExtractSt")  3, false, false, false, 302, 11, 13, 1,  0, 0}, // #138
  {DBGFIELD("WriteVecExtract")    2, false, false, false, 313, 12, 13, 1,  0, 0}, // #139
  {DBGFIELD("WriteVecALUX")       1, false, false, false, 154, 4,  1, 1,  0, 0}, // #140
  {DBGFIELD("WriteFComLd")        2, false, false, false, 158, 9,  2, 1,  0, 0}, // #141
  {DBGFIELD("WriteEMMS")          31, false, false, false, 2404, 5, 92, 1,  0, 0}, // #142
  {DBGFIELD("WriteFLDC")          2, false, false, false, 637, 4,  1, 1,  0, 0}, // #143
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 2, false, false, false, 148, 6,  3, 1,  3, 1}, // #144
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 4, false, false, false, 2409, 13,  7, 1,  3, 1}, // #145
  {DBGFIELD("WriteFHAdd")         3, false, false, false, 2422, 11, 14, 1,  0, 0}, // #146
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 2293, 16, 42, 1,  1, 2}, // #147
  {DBGFIELD("WriteIDiv16")        1, false, false, false, 206, 10, 11, 1,  0, 0}, // #148
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 2293, 16, 42, 1,  1, 2}, // #149
  {DBGFIELD("WriteIDiv32")        1, false, false, false, 206, 10, 11, 1,  0, 0}, // #150
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 2293, 16, 42, 1,  1, 2}, // #151
  {DBGFIELD("WriteIDiv64")        1, false, false, false, 206, 10, 11, 1,  0, 0}, // #152
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 2293, 16, 42, 1,  1, 2}, // #153
  {DBGFIELD("WriteIDiv8")         1, false, false, false, 206, 10, 11, 1,  0, 0}, // #154
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 384, 11,  9, 1,  1, 2}, // #155
  {DBGFIELD("WriteIMul16")        4, false, false, false, 395, 9,  8, 1,  0, 0}, // #156
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #157
  {DBGFIELD("WriteIMul16ImmLd")   3, false, false, false, 404, 9,  2, 1,  0, 0}, // #158
  {DBGFIELD("WriteIMul16Reg")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul16Imm")     2, false, false, false, 413, 7,  8, 1,  0, 0}, // #160
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 420, 11,  9, 1,  1, 2}, // #161
  {DBGFIELD("WriteIMul32")        3, false, false, false, 431, 9,  8, 1,  0, 0}, // #162
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #163
  {DBGFIELD("WriteIMul32ImmLd")   2, false, false, false, 158, 9,  2, 1,  0, 0}, // #164
  {DBGFIELD("WriteIMul32Reg")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul32Imm")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #166
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 440, 13,  9, 1,  1, 2}, // #167
  {DBGFIELD("WriteIMul64")        2, false, false, false, 453, 11,  8, 1,  0, 0}, // #168
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #169
  {DBGFIELD("WriteIMul64ImmLd")   2, false, false, false, 158, 9,  2, 1,  0, 0}, // #170
  {DBGFIELD("WriteIMul64Reg")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #171
  {DBGFIELD("WriteIMul64Imm")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #172
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 158, 9,  2, 1,  1, 2}, // #173
  {DBGFIELD("WriteIMul8")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #174
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #175
  {DBGFIELD("WriteFShuffle")      1, false, false, false, 474, 8,  1, 1,  0, 0}, // #176
  {DBGFIELD("WriteVecLogicX")     1, false, false, false, 30, 3,  1, 1,  0, 0}, // #177
  {DBGFIELD("WriteShuffle")       1, false, false, false, 474, 8,  1, 1,  0, 0}, // #178
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, false,  8, 4,  1, 1,  0, 0}, // #179
  {DBGFIELD("WriteVecLoadX")      1, false, false, false, 37, 3, 14, 1,  0, 0}, // #180
  {DBGFIELD("WriteLDMXCSR")       3, false, false, false, 482, 11,  6, 1,  0, 0}, // #181
  {DBGFIELD("WriteFLD0")          1, false, false, false, 65, 4,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteFLD1")          2, false, false, false, 637, 4,  1, 1,  0, 0}, // #183
  {DBGFIELD("WriteLEA")           1, false, false, false, 154, 4,  1, 1,  0, 0}, // #184
  {DBGFIELD("WriteFence")         1, false, false, false, 493, 5,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteLZCNTLd")       2, false, false, false, 158, 9,  2, 1,  0, 0}, // #186
  {DBGFIELD("WriteLZCNT")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #187
  {DBGFIELD("WriteVecStoreX")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #188
  {DBGFIELD("WriteVecStore")      2, false, false, false, 33, 4,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, false, 40, 9,  1, 1,  0, 0}, // #190
  {DBGFIELD("WriteVecLoad")       1, false, false, false, 37, 3, 14, 1,  0, 0}, // #191
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #192
  {DBGFIELD("WriteVecMoveX")      1, false, false, false, 30, 3,  1, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecStoreNT")    2, false, false, false, 33, 4,  1, 1,  0, 0}, // #194
  {DBGFIELD("WriteVecMove")       1, false, false, false, 30, 3,  1, 1,  0, 0}, // #195
  {DBGFIELD("WriteVecALULd")      2, false, false, false, 148, 6,  3, 1,  0, 0}, // #196
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #197
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 2, false, false, false, 148, 6,  3, 1,  3, 1}, // #198
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 2, false, false, false, 60, 5,  3, 1,  3, 1}, // #199
  {DBGFIELD("WriteVecLogic")      1, false, false, false, 30, 3,  1, 1,  0, 0}, // #200
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, false, 2433, 10,  2, 1,  3, 1}, // #201
  {DBGFIELD("WritePHAdd")         3, false, false, false, 2443, 8,  5, 1,  0, 0}, // #202
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #203
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 2, false, false, false, 523, 8, 13, 1,  6, 1}, // #204
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #205
  {DBGFIELD("WriteVecIMul")       1, false, false, false, 40, 9, 14, 1,  0, 0}, // #206
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, false, 40, 9,  1, 1,  0, 0}, // #207
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #208
  {DBGFIELD("WritePSADBW")        1, false, false, false, 40, 9, 14, 1,  0, 0}, // #209
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #210
  {DBGFIELD("WriteVarShuffle")    1, false, false, false, 474, 8,  1, 1,  0, 0}, // #211
  {DBGFIELD("WriteShuffleLd")     2, false, false, false, 464, 10,  3, 1,  0, 0}, // #212
  {DBGFIELD("WriteVecShiftImm")   1, false, false, false, 40, 9,  1, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 2, false, false, false, 69, 11,  3, 1,  3, 1}, // #214
  {DBGFIELD("WriteVecShift")      1, false, false, false, 40, 9,  1, 1,  0, 0}, // #215
  {DBGFIELD("WriteFMoveX")        1, false, false, false, 474, 8,  1, 1,  0, 0}, // #216
  {DBGFIELD("WriteFShuffleLd")    2, false, false, false, 464, 10,  3, 1,  0, 0}, // #217
  {DBGFIELD("WriteFStore")        2, false, false, false, 33, 4,  1, 1,  0, 0}, // #218
  {DBGFIELD("WriteFMOVMSK")       1, false, false, false, 40, 9,  5, 1,  0, 0}, // #219
  {DBGFIELD("WriteVecLoadNT")     1, false, false, false, 37, 3, 14, 1,  0, 0}, // #220
  {DBGFIELD("WriteStoreNT")       2, false, false, false, 33, 4,  1, 1,  0, 0}, // #221
  {DBGFIELD("WriteFStoreNTX")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #222
  {DBGFIELD("WriteFStoreNT")      2, false, false, false, 33, 4,  1, 1,  0, 0}, // #223
  {DBGFIELD("WriteFLoad")         1, false, false, false, 37, 3, 14, 1,  0, 0}, // #224
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 4, false, false, false, 1491, 14, 23, 1,  3, 1}, // #225
  {DBGFIELD("WriteMPSAD")         3, false, false, false, 1479, 12,  6, 1,  0, 0}, // #226
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  2, 1,  3, 1}, // #227
  {DBGFIELD("WriteFMul64X")       1, false, false, false, 65, 4,  5, 1,  0, 0}, // #228
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  2, 1,  3, 1}, // #229
  {DBGFIELD("WriteFMulX")         1, false, false, false, 65, 4,  5, 1,  0, 0}, // #230
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 2, false, false, false, 59, 6,  2, 1,  3, 1}, // #231
  {DBGFIELD("WriteFMul64")        1, false, false, false, 65, 4,  5, 1,  0, 0}, // #232
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 2, false, false, false, 59, 6,  2, 1,  3, 1}, // #233
  {DBGFIELD("WriteFMul")          1, false, false, false, 65, 4,  5, 1,  0, 0}, // #234
  {DBGFIELD("WriteMULX32Ld")      4, false, false, false, 420, 11,  2, 1,  0, 0}, // #235
  {DBGFIELD("WriteMULX32")        3, false, false, false, 431, 9,  5, 1,  0, 0}, // #236
  {DBGFIELD("WriteIMulHLd_WriteMULX32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 5, false, false, false, 420, 11, 26, 2,  1, 1}, // #237
  {DBGFIELD("WriteIMulH_WriteMULX32") 4, false, false, false, 431, 9, 28, 2,  0, 0}, // #238
  {DBGFIELD("WriteMULX64Ld")      3, false, false, false, 440, 13,  2, 1,  0, 0}, // #239
  {DBGFIELD("WriteMULX64")        2, false, false, false, 453, 11,  5, 1,  0, 0}, // #240
  {DBGFIELD("WriteIMulHLd_WriteMULX64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 4, false, false, false, 440, 13, 26, 2,  1, 1}, // #241
  {DBGFIELD("WriteIMulH_WriteMULX64") 3, false, false, false, 453, 11, 28, 2,  0, 0}, // #242
  {DBGFIELD("WriteFMulLd")        2, false, false, false, 59, 6,  2, 1,  0, 0}, // #243
  {DBGFIELD("WriteVecALUXLd")     2, false, false, false, 148, 6,  3, 1,  0, 0}, // #244
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #245
  {DBGFIELD("WriteShuffleX")      1, false, false, false, 474, 8,  1, 1,  0, 0}, // #246
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 2, false, false, false, 60, 5,  3, 1,  3, 1}, // #247
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 3, false, false, false, 531, 10,  6, 1,  3, 1}, // #248
  {DBGFIELD("WriteVarBlend")      2, false, false, false, 523, 8, 13, 1,  0, 0}, // #249
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #250
  {DBGFIELD("WriteBlend")         1, false, false, false, 474, 8,  1, 1,  0, 0}, // #251
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #252
  {DBGFIELD("WriteCLMul")         1, false, false, false, 40, 9, 14, 1,  0, 0}, // #253
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 9, false, false, false, 541, 14, 36, 1,  3, 1}, // #254
  {DBGFIELD("WritePCmpEStrI")     8, false, false, false, 555, 12, 31, 1,  0, 0}, // #255
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 10, false, false, false, 567, 14, 30, 1,  3, 1}, // #256
  {DBGFIELD("WritePCmpEStrM")     9, false, false, false, 581, 12, 20, 1,  0, 0}, // #257
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 4, false, false, false, 593, 11, 19, 1,  3, 1}, // #258
  {DBGFIELD("WritePCmpIStrI")     3, false, false, false, 604, 9, 18, 1,  0, 0}, // #259
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 4, false, false, false, 593, 11, 19, 1,  3, 1}, // #260
  {DBGFIELD("WritePCmpIStrM")     3, false, false, false, 604, 9, 18, 1,  0, 0}, // #261
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #262
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 4, false, false, false, 2433, 10,  2, 1,  3, 1}, // #263
  {DBGFIELD("WritePHAddX")        3, false, false, false, 2443, 8,  5, 1,  0, 0}, // #264
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, false, 69, 11,  7, 1,  0, 0}, // #265
  {DBGFIELD("WritePHMINPOS")      1, false, false, false, 40, 9, 14, 1,  0, 0}, // #266
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 2, false, false, false, 158, 9,  9, 1,  3, 1}, // #267
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #268
  {DBGFIELD("WriteVecIMulX")      1, false, false, false, 40, 9, 14, 1,  0, 0}, // #269
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, false, 40, 9,  5, 1,  0, 0}, // #270
  {DBGFIELD("WriteShuffleXLd")    2, false, false, false, 464, 10,  3, 1,  0, 0}, // #271
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 3, false, false, false, 80, 11, 21, 1,  3, 1}, // #272
  {DBGFIELD("WritePMULLD")        2, false, false, false, 91, 9,  7, 1,  0, 0}, // #273
  {DBGFIELD("WriteCopy")          2, false, false, false, 641, 5,  3, 1,  0, 0}, // #274
  {DBGFIELD("WritePOPCNTLd")      2, false, false, false, 158, 9,  2, 1,  0, 0}, // #275
  {DBGFIELD("WritePOPCNT")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #276
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #277
  {DBGFIELD("WritePSADBWX")       1, false, false, false, 40, 9, 14, 1,  0, 0}, // #278
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #279
  {DBGFIELD("WriteVarShuffleX")   1, false, false, false, 474, 8,  1, 1,  0, 0}, // #280
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, false, 40, 9,  1, 1,  0, 0}, // #281
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 3, false, false, false, 655, 14,  6, 1,  3, 1}, // #282
  {DBGFIELD("WriteVecShiftX")     2, false, false, false, 313, 12, 13, 1,  0, 0}, // #283
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 3, false, false, false, 655, 14,  6, 1,  3, 1}, // #284
  {DBGFIELD("WriteVecTest")       2, false, false, false, 313, 12, 13, 1,  0, 0}, // #285
  {DBGFIELD("WriteRotateLd_WriteRMW") 3, false, false, false, 167, 8, 32, 2,  0, 0}, // #286
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 5, false, false, false, 12, 8, 34, 2,  0, 0}, // #287
  {DBGFIELD("WriteRotate")        1, false, false, false,  8, 4,  1, 1,  0, 0}, // #288
  {DBGFIELD("WriteRotateCL")      3, false, false, false, 2451, 4,  5, 1,  0, 0}, // #289
  {DBGFIELD("WriteFRcpXLd")       2, false, false, false, 69, 11,  7, 1,  0, 0}, // #290
  {DBGFIELD("WriteFRcpX")         1, false, false, false, 40, 9, 14, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRcpLd")        2, false, false, false, 69, 11,  7, 1,  0, 0}, // #292
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #293
  {DBGFIELD("WriteFRcp")          1, false, false, false, 40, 9, 14, 1,  0, 0}, // #294
  {DBGFIELD("WriteRMW")           1, false, false, false, 33, 4,  1, 1,  0, 0}, // #295
  {DBGFIELD("WriteShiftLd")       2, false, false, false, 20, 6,  3, 1,  0, 0}, // #296
  {DBGFIELD("WriteShift")         1, false, false, false,  8, 4,  1, 1,  0, 0}, // #297
  {DBGFIELD("WriteFRndLd")        3, false, false, false, 2455, 9, 18, 1,  0, 0}, // #298
  {DBGFIELD("WriteFRnd")          1, false, false, false, 37, 3,  3, 1,  0, 0}, // #299
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 3, false, false, false, 2455, 9, 18, 1,  3, 1}, // #300
  {DBGFIELD("WriteFRsqrtXLd")     2, false, false, false, 69, 11,  7, 1,  0, 0}, // #301
  {DBGFIELD("WriteFRsqrtX")       1, false, false, false, 40, 9, 14, 1,  0, 0}, // #302
  {DBGFIELD("WriteFRsqrtLd")      2, false, false, false, 69, 11,  7, 1,  0, 0}, // #303
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #304
  {DBGFIELD("WriteFRsqrt")        1, false, false, false, 40, 9, 14, 1,  0, 0}, // #305
  {DBGFIELD("WriteShiftLd_WriteRMW") 3, false, false, false, 167, 8, 32, 2,  0, 0}, // #306
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 5, false, false, false, 12, 8, 34, 2,  0, 0}, // #307
  {DBGFIELD("WriteShiftCL")       3, false, false, false, 2451, 4,  5, 1,  0, 0}, // #308
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 20, 6,  3, 1,  1, 1}, // #309
  {DBGFIELD("WriteSETCCStore")    3, false, false, false, 681, 7, 13, 1,  0, 0}, // #310
  {DBGFIELD("WriteSETCC")         1, false, false, false,  8, 4,  1, 1,  0, 0}, // #311
  {DBGFIELD("WriteSHDmrcl")       6, false, false, false, 2464, 11, 18, 1,  0, 0}, // #312
  {DBGFIELD("WriteSHDmri")        4, false, false, false, 699, 9,  9, 1,  0, 0}, // #313
  {DBGFIELD("WriteSHDrrcl")       4, false, false, false, 395, 9,  3, 1,  0, 0}, // #314
  {DBGFIELD("WriteFSqrt64XLd")    2, false, false, false, 2475, 12, 37, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrt64X")      1, false, false, false, 2487, 10, 19, 1,  0, 0}, // #316
  {DBGFIELD("WriteFSqrtXLd")      2, false, false, false, 2497, 12, 19, 1,  0, 0}, // #317
  {DBGFIELD("WriteFSqrtX")        1, false, false, false, 739, 10, 18, 1,  0, 0}, // #318
  {DBGFIELD("WriteFSqrt64Ld")     2, false, false, false, 2475, 12, 37, 1,  0, 0}, // #319
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 2, false, false, false, 2475, 12, 37, 1,  3, 1}, // #320
  {DBGFIELD("WriteFSqrt64")       1, false, false, false, 2324, 10, 19, 1,  0, 0}, // #321
  {DBGFIELD("WriteFSqrtLd")       2, false, false, false, 2497, 12, 19, 1,  0, 0}, // #322
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 2, false, false, false, 2497, 12, 19, 1,  3, 1}, // #323
  {DBGFIELD("WriteFSqrt")         1, false, false, false, 2334, 10, 18, 1,  0, 0}, // #324
  {DBGFIELD("WriteFSqrt80")       1, false, false, false, 2509, 10, 36, 1,  0, 0}, // #325
  {DBGFIELD("WriteSTMXCSR")       3, false, false, false, 302, 11, 13, 1,  0, 0}, // #326
  {DBGFIELD("WriteTZCNTLd")       2, false, false, false, 158, 9,  2, 1,  0, 0}, // #327
  {DBGFIELD("WriteTZCNT")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #328
  {DBGFIELD("WriteFMAZLd")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #329
  {DBGFIELD("WriteFMALd")         2, false, false, false, 59, 6,  7, 1,  0, 0}, // #330
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 2, false, false, false, 158, 9,  9, 1,  5, 1}, // #331
  {DBGFIELD("WriteFAdd64Y")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #332
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteFAdd64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 2, false, false, false, 158, 9,  9, 1,  5, 1}, // #335
  {DBGFIELD("WriteFAddY")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #336
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD("WriteFAddZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #339
  {DBGFIELD("WriteShuffleY")      1, false, false, false, 474, 8,  1, 1,  0, 0}, // #340
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD("WriteShuffleZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #343
  {DBGFIELD("WriteFLogicY")       1, false, false, false, 474, 8,  1, 1,  0, 0}, // #344
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #345
  {DBGFIELD("WriteFLogicZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #346
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 3, false, false, false, 531, 10,  2, 1,  5, 1}, // #347
  {DBGFIELD("WriteFVarBlendY")    2, false, false, false, 523, 8, 13, 1,  0, 0}, // #348
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #349
  {DBGFIELD("WriteFVarBlendZ")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 2, false, false, false, 60, 5,  6, 1,  5, 1}, // #351
  {DBGFIELD("WriteFBlendY")       1, false, false, false, 30, 3,  1, 1,  0, 0}, // #352
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 3, false, false, false, 531, 10,  2, 1, 10, 2}, // #353
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, false, 531, 10,  6, 1,  3, 2}, // #354
  {DBGFIELD("WriteShuffle256Ld")  2, false, false, false, 464, 10,  9, 1,  0, 0}, // #355
  {DBGFIELD("WriteShuffle256")    1, false, false, false, 474, 8,  5, 1,  0, 0}, // #356
  {DBGFIELD("WriteShuffleYLd")    2, false, false, false, 464, 10,  6, 1,  0, 0}, // #357
  {DBGFIELD("WriteFShuffle256")   1, false, false, false, 474, 8,  5, 1,  0, 0}, // #358
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, false, 464, 10,  9, 1,  0, 0}, // #359
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 2, false, false, false, 158, 9,  9, 1,  5, 1}, // #360
  {DBGFIELD("WriteFCmp64Y")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #361
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 2, false, false, false, 158, 9,  9, 1,  5, 1}, // #362
  {DBGFIELD("WriteFCmpY")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #363
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #364
  {DBGFIELD("WriteFCmpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("WriteVarShuffle256Ld") 2, false, false, false, 464, 10,  9, 1,  0, 0}, // #366
  {DBGFIELD("WriteVarShuffle256") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #367
  {DBGFIELD("WriteCvtI2PDYLd")    2, false, false, false, 158, 9,  9, 1,  0, 0}, // #368
  {DBGFIELD("WriteCvtI2PDY")      1, false, false, false, 26, 7,  8, 1,  0, 0}, // #369
  {DBGFIELD("WriteCvtI2PDZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #370
  {DBGFIELD("WriteCvtI2PDZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #371
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, false, 158, 9,  9, 1,  0, 0}, // #372
  {DBGFIELD("WriteCvtI2PSY")      1, false, false, false, 26, 7,  8, 1,  0, 0}, // #373
  {DBGFIELD("WriteCvtI2PSZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #374
  {DBGFIELD("WriteCvtI2PSZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #376
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 2, false, false, false, 158, 9,  2, 1,  5, 1}, // #377
  {DBGFIELD("WriteCvtPD2PSY")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #378
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtPD2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteCvtPD2PSYLd")   2, false, false, false, 158, 9,  2, 1,  0, 0}, // #381
  {DBGFIELD("WriteCvtPD2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #382
  {DBGFIELD("WriteCvtPD2IYLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #383
  {DBGFIELD("WriteCvtPD2IY")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #384
  {DBGFIELD("WriteCvtPD2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #385
  {DBGFIELD("WriteCvtPD2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, false, 158, 9,  2, 1,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2IY")      1, false, false, false, 26, 7,  5, 1,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2PDYLd")   2, false, false, false, 158, 9,  2, 1,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PDY")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PDZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PDZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtPH2PSYLd")   2, false, false, false, 69, 11,  3, 1,  0, 0}, // #395
  {DBGFIELD("WriteCvtPH2PSY")     2, false, false, false, 313, 12, 13, 1,  0, 0}, // #396
  {DBGFIELD("WriteCvtPH2PSLd")    2, false, false, false, 69, 11,  3, 1,  0, 0}, // #397
  {DBGFIELD("WriteCvtPH2PS")      2, false, false, false, 313, 12, 13, 1,  0, 0}, // #398
  {DBGFIELD("WriteCvtPH2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteCvtPH2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #400
  {DBGFIELD("WriteCvtPS2PHYSt")   3, false, false, false, 2519, 10,  6, 1,  0, 0}, // #401
  {DBGFIELD("WriteCvtPS2PHY")     2, false, false, false, 453, 11,  3, 1,  0, 0}, // #402
  {DBGFIELD("WriteCvtPS2PHSt")    3, false, false, false, 2519, 10, 14, 1,  0, 0}, // #403
  {DBGFIELD("WriteCvtPS2PH")      2, false, false, false, 453, 11,  8, 1,  0, 0}, // #404
  {DBGFIELD("WriteCvtPS2PHZSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteCvtPS2PHZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #406
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #407
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #408
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 2, false, false, false, 69, 11, 18, 1,  5, 1}, // #409
  {DBGFIELD("WritePSADBWY")       1, false, false, false, 40, 9, 14, 1,  0, 0}, // #410
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #411
  {DBGFIELD("WritePSADBWZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #412
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 4, false, false, false, 2529, 12, 15, 1,  5, 1}, // #413
  {DBGFIELD("WriteFDiv64Y")       3, false, false, false, 2541, 10, 36, 1,  0, 0}, // #414
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD("WriteFDiv64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 4, false, false, false, 2551, 12, 36, 1,  5, 1}, // #417
  {DBGFIELD("WriteFDivY")         3, false, false, false, 2563, 10, 17, 1,  0, 0}, // #418
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WriteFDivZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #420
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1,  3, 1}, // #421
  {DBGFIELD("WriteFMAX")          1, false, false, false, 65, 4, 14, 1,  0, 0}, // #422
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1,  5, 1}, // #423
  {DBGFIELD("WriteFMAY")          1, false, false, false, 65, 4, 14, 1,  0, 0}, // #424
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteFMAZ")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #426
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 5, false, false, false, 2374, 16, 12, 1,  5, 1}, // #427
  {DBGFIELD("WriteDPPSY")         4, false, false, false, 2390, 14, 10, 1,  0, 0}, // #428
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #429
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1, 14, 2}, // #430
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1, 16, 2}, // #431
  {DBGFIELD("WriteFMALd_ReadAfterVecLd") 2, false, false, false, 59, 6,  7, 1,  3, 1}, // #432
  {DBGFIELD("WriteFMA")           1, false, false, false, 65, 4, 14, 1,  0, 0}, // #433
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 2, false, false, false, 59, 6,  7, 1, 16, 2}, // #434
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 59, 6, 18, 1, 10, 2}, // #435
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 59, 6,  7, 1,  3, 2}, // #436
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 2, false, false, false, 59, 6,  7, 1,  3, 2}, // #437
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 3, false, false, false, 2455, 9, 23, 1,  5, 1}, // #438
  {DBGFIELD("WriteFRndY")         1, false, false, false, 37, 3,  3, 1,  0, 0}, // #439
  {DBGFIELD("WriteLoad_WriteVecMaskedGatherWriteback") 1, false, false, false, 37, 3, 38, 2,  0, 0}, // #440
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteFRndZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 2, false, false, false, 69, 11, 18, 1,  5, 1}, // #443
  {DBGFIELD("WriteVecIMulY")      1, false, false, false, 40, 9, 14, 1,  0, 0}, // #444
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #445
  {DBGFIELD("WriteVecIMulZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #446
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 2, false, false, false, 148, 6,  6, 1,  5, 1}, // #447
  {DBGFIELD("WriteVecALUY")       1, false, false, false, 154, 4,  1, 1,  0, 0}, // #448
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("WriteVecALUZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #450
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 4, false, false, false, 2409, 13, 18, 1,  5, 1}, // #451
  {DBGFIELD("WriteFHAddY")        3, false, false, false, 2422, 11, 14, 1,  0, 0}, // #452
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #453
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #454
  {DBGFIELD("WriteVecLoadY")      1, false, false, false, 37, 3,  3, 1,  0, 0}, // #455
  {DBGFIELD("WriteFMaskedStore64Y") 4, false, false, false, 2573, 12, 14, 1,  0, 0}, // #456
  {DBGFIELD("WriteFMaskedLoadY")  3, false, false, false, 531, 10,  2, 1,  0, 0}, // #457
  {DBGFIELD("WriteFMaskedStore64") 4, false, false, false, 2573, 12, 14, 1,  0, 0}, // #458
  {DBGFIELD("WriteFMaskedLoad")   3, false, false, false, 531, 10,  6, 1,  0, 0}, // #459
  {DBGFIELD("WriteFMaskedStore32Y") 4, false, false, false, 2573, 12, 14, 1,  0, 0}, // #460
  {DBGFIELD("WriteFMaskedStore32") 4, false, false, false, 2573, 12, 14, 1,  0, 0}, // #461
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #462
  {DBGFIELD("WriteFCmp64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #463
  {DBGFIELD("WriteFMoveY")        1, false, false, false, 474, 8,  1, 1,  0, 0}, // #464
  {DBGFIELD("WriteFMoveZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #465
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, false, 464, 10,  6, 1,  0, 0}, // #466
  {DBGFIELD("WriteFShuffleY")     1, false, false, false, 474, 8,  1, 1,  0, 0}, // #467
  {DBGFIELD("WriteFShuffleZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteFShuffleZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #469
  {DBGFIELD("WriteVecStoreY")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #470
  {DBGFIELD("WriteVecMoveY")      1, false, false, false, 30, 3,  1, 1,  0, 0}, // #471
  {DBGFIELD("WriteVecMoveZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #472
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, false, 37, 3,  3, 1,  0, 0}, // #473
  {DBGFIELD("WriteVecStoreNTY")   2, false, false, false, 33, 4,  1, 1,  0, 0}, // #474
  {DBGFIELD("WriteFStoreNTY")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #475
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 4, false, false, false, 1491, 14, 22, 1,  5, 1}, // #476
  {DBGFIELD("WriteMPSADY")        3, false, false, false, 1479, 12,  6, 1,  0, 0}, // #477
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 2, false, false, false, 59, 6,  9, 1,  5, 1}, // #478
  {DBGFIELD("WriteFMul64Y")       1, false, false, false, 65, 4,  5, 1,  0, 0}, // #479
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteFMul64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 2, false, false, false, 59, 6,  9, 1,  5, 1}, // #482
  {DBGFIELD("WriteFMulY")         1, false, false, false, 65, 4,  5, 1,  0, 0}, // #483
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #484
  {DBGFIELD("WriteFMulZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #485
  {DBGFIELD("WriteVecALUYLd")     2, false, false, false, 148, 6,  6, 1,  0, 0}, // #486
  {DBGFIELD("WriteVecALUZLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 2, false, false, false, 60, 5,  6, 1,  5, 1}, // #488
  {DBGFIELD("WriteVecLogicY")     1, false, false, false, 30, 3,  1, 1,  0, 0}, // #489
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteVecLogicZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #492
  {DBGFIELD("WriteBlendY")        1, false, false, false, 474, 8,  1, 1,  0, 0}, // #493
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 3, false, false, false, 531, 10,  2, 1,  5, 1}, // #494
  {DBGFIELD("WriteVarBlendY")     2, false, false, false, 523, 8, 13, 1,  0, 0}, // #495
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteVarBlendZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 3, false, false, false, 531, 10,  2, 1, 10, 2}, // #498
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 3, false, false, false, 531, 10,  6, 1,  3, 2}, // #499
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 464, 10,  6, 1, 10, 2}, // #500
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  6, 1, 14, 2}, // #501
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1,  3, 2}, // #502
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1, 16, 2}, // #503
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #504
  {DBGFIELD("WriteFVarShuffle256") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #505
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 464, 10,  6, 1, 10, 2}, // #506
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  6, 1, 14, 2}, // #507
  {DBGFIELD("WriteFVarShuffleY")  1, false, false, false, 474, 8,  1, 1,  0, 0}, // #508
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1,  3, 2}, // #509
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1, 16, 2}, // #510
  {DBGFIELD("WriteFVarShuffle")   1, false, false, false, 474, 8,  1, 1,  0, 0}, // #511
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #512
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #513
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #514
  {DBGFIELD("WriteFVarShuffleZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #515
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 4, false, false, false, 2433, 10,  9, 1,  5, 1}, // #516
  {DBGFIELD("WritePHAddY")        3, false, false, false, 2443, 8,  5, 1,  0, 0}, // #517
  {DBGFIELD("WriteVecInsert")     2, false, false, false, 523, 8, 13, 1,  0, 0}, // #518
  {DBGFIELD("WriteVecIMulXLd")    2, false, false, false, 69, 11,  7, 1,  0, 0}, // #519
  {DBGFIELD("WriteVecIMulYLd")    2, false, false, false, 69, 11, 18, 1,  0, 0}, // #520
  {DBGFIELD("WriteVecIMulZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #521
  {DBGFIELD("WriteVecMaskedStore32Y") 4, false, false, false, 2573, 12, 14, 1,  0, 0}, // #522
  {DBGFIELD("WriteVecMaskedLoadY") 3, false, false, false, 531, 10,  2, 1,  0, 0}, // #523
  {DBGFIELD("WriteVecMaskedStore32") 4, false, false, false, 2573, 12, 14, 1,  0, 0}, // #524
  {DBGFIELD("WriteVecMaskedLoad") 3, false, false, false, 531, 10,  6, 1,  0, 0}, // #525
  {DBGFIELD("WriteVecMaskedStore64Y") 4, false, false, false, 2573, 12, 14, 1,  0, 0}, // #526
  {DBGFIELD("WriteVecMaskedStore64") 4, false, false, false, 2573, 12, 14, 1,  0, 0}, // #527
  {DBGFIELD("WriteVPMOV256Ld")    2, false, false, false, 464, 10,  9, 1,  0, 0}, // #528
  {DBGFIELD("WriteVPMOV256")      1, false, false, false, 474, 8,  5, 1,  0, 0}, // #529
  {DBGFIELD("WriteVecMOVMSKY")    1, false, false, false, 40, 9,  5, 1,  0, 0}, // #530
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 3, false, false, false, 80, 11, 19, 1,  5, 1}, // #531
  {DBGFIELD("WritePMULLDY")       2, false, false, false, 91, 9,  7, 1,  0, 0}, // #532
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WritePMULLDZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #534
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1,  3, 2}, // #535
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 464, 10,  3, 1, 16, 2}, // #536
  {DBGFIELD("WriteVecShiftImmXLd") 2, false, false, false, 69, 11,  3, 1,  0, 0}, // #537
  {DBGFIELD("WriteVecShiftImmYLd") 2, false, false, false, 69, 11,  6, 1,  0, 0}, // #538
  {DBGFIELD("WriteVecShiftImmY")  1, false, false, false, 40, 9,  1, 1,  0, 0}, // #539
  {DBGFIELD("WriteVecShiftImmZLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #540
  {DBGFIELD("WriteVecShiftImmZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #541
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 4, false, false, false, 2585, 14,  2, 1,  3, 1}, // #542
  {DBGFIELD("WriteVarVecShift")   3, false, false, false, 2599, 12,  5, 1,  0, 0}, // #543
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 4, false, false, false, 2585, 14,  9, 1,  5, 1}, // #544
  {DBGFIELD("WriteVarVecShiftY")  3, false, false, false, 2599, 12,  5, 1,  0, 0}, // #545
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #546
  {DBGFIELD("WriteVarVecShiftZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #547
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 2, false, false, false, 69, 11,  3, 1,  3, 1}, // #548
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #549
  {DBGFIELD("WriteVarShuffleY")   1, false, false, false, 474, 8,  1, 1,  0, 0}, // #550
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #551
  {DBGFIELD("WriteVarShuffleZ")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #552
  {DBGFIELD("WriteShuffleZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #553
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 2, false, false, false, 69, 11,  6, 1,  5, 1}, // #554
  {DBGFIELD("WriteVecShiftY")     2, false, false, false, 313, 12,  8, 1,  0, 0}, // #555
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD("WriteVecShiftZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #557
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 3, false, false, false, 655, 14,  7, 1,  5, 1}, // #558
  {DBGFIELD("WriteVecTestY")      2, false, false, false, 313, 12,  8, 1,  0, 0}, // #559
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #560
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 4, false, false, false, 2530, 11, 17, 1,  5, 1}, // #561
  {DBGFIELD("WriteFRcpY")         3, false, false, false, 2542, 9, 18, 1,  0, 0}, // #562
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #563
  {DBGFIELD("WriteFRcpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #564
  {DBGFIELD("WriteFRcpYLd")       4, false, false, false, 2530, 11, 17, 1,  0, 0}, // #565
  {DBGFIELD("WriteFRndYLd")       3, false, false, false, 2455, 9, 23, 1,  0, 0}, // #566
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #567
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 4, false, false, false, 2530, 11, 17, 1,  5, 1}, // #568
  {DBGFIELD("WriteFRsqrtY")       3, false, false, false, 2542, 9, 18, 1,  0, 0}, // #569
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #570
  {DBGFIELD("WriteFRsqrtZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #571
  {DBGFIELD("WriteFRsqrtYLd")     4, false, false, false, 2530, 11, 17, 1,  0, 0}, // #572
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #573
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #574
  {DBGFIELD("WriteFSqrt64YLd")    4, false, false, false, 2611, 12, 42, 1,  0, 0}, // #575
  {DBGFIELD("WriteFSqrt64Y")      3, false, false, false, 2623, 10, 15, 1,  0, 0}, // #576
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 2, false, false, false, 2475, 12, 37, 1,  3, 1}, // #577
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 4, false, false, false, 2611, 12, 42, 1,  5, 1}, // #578
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #579
  {DBGFIELD("WriteFSqrt64Z")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #580
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 2, false, false, false, 2497, 12, 19, 1,  3, 1}, // #581
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 4, false, false, false, 2633, 12, 46, 1,  5, 1}, // #582
  {DBGFIELD("WriteFSqrtY")        3, false, false, false, 2645, 10, 37, 1,  0, 0}, // #583
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #584
  {DBGFIELD("WriteFSqrtZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #585
  {DBGFIELD("WriteFSqrtYLd")      4, false, false, false, 2633, 12, 46, 1,  0, 0}, // #586
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 2, false, false, false, 69, 11,  6, 1,  5, 1}, // #587
  {DBGFIELD("WriteFTestY")        1, false, false, false, 40, 9,  1, 1,  0, 0}, // #588
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 2, false, false, false, 69, 11,  3, 1,  3, 1}, // #589
  {DBGFIELD("WriteFTest")         1, false, false, false, 40, 9,  1, 1,  0, 0}, // #590
  {DBGFIELD("WriteALULd_WriteRMW") 3, false, false, false, 49, 6, 32, 2,  0, 0}, // #591
  {DBGFIELD("WriteXCHG")          3, false, false, false, 280, 2, 13, 1,  0, 0}, // #592
  {DBGFIELD("COPY")               1, false, false, false,  1, 2,  1, 1,  0, 0}, // #593
  {DBGFIELD("XAM_F")              1, false, false, false, 40, 9,  1, 1,  0, 0}, // #594
  {DBGFIELD("LD_Frr")             1, false, false, false,  1, 2,  1, 1,  0, 0}, // #595
  {DBGFIELD("MOVSX64rr32")        1, false, false, false,  1, 2,  1, 1,  0, 0}, // #596
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 5, false, false, false, 823, 6,  2, 1,  0, 0}, // #597
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 11, false, false, false, 2655, 11, 31, 1,  0, 0}, // #598
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 4, false, false, false, 167, 8,  3, 1,  0, 0}, // #599
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 6, false, false, false, 12, 8,  2, 1,  0, 0}, // #600
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #601
  {DBGFIELD("FCOMPP")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #602
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #603
  {DBGFIELD("MMX_CVTPI2PSrr")     1, false, false, false, 26, 7,  5, 1,  0, 0}, // #604
  {DBGFIELD("MMX_CVTPI2PSrm")     2, false, false, false, 158, 9,  2, 1,  0, 0}, // #605
  {DBGFIELD("MMX_CVTPS2PIrr_MMX_CVTTPS2PIrr") 2, false, false, false, 453, 11,  8, 1,  0, 0}, // #606
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 2, false, false, false, 55, 4,  3, 1,  0, 0}, // #607
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #608
  {DBGFIELD("XCH_F")              12, false, false, false, 2666, 14, 10, 1,  0, 0}, // #609
  {DBGFIELD("RETI16_RETI32_RETI64_IRET_IRET16_IRET32_IRET64") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #610
  {DBGFIELD("MMX_CVTPS2PIrm_MMX_CVTTPS2PIrm") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #611
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 2, false, false, false, 158, 9,  9, 1,  0, 0}, // #612
  {DBGFIELD("CVTSI642SDrm")       2, false, false, false, 158, 9,  9, 1,  0, 0}, // #613
  {DBGFIELD("CVTSI642SDrm_Int")   2, false, false, false, 158, 9,  9, 1,  3, 1}, // #614
  {DBGFIELD("CVTSI642SSrr")       3, false, false, false, 2422, 11, 14, 1,  0, 0}, // #615
  {DBGFIELD("CVTSI642SSrr_Int")   3, false, false, false, 2422, 11, 14, 1,  0, 0}, // #616
  {DBGFIELD("CVTSI642SSrm")       2, false, false, false, 158, 9,  9, 1,  0, 0}, // #617
  {DBGFIELD("CVTSI642SSrm_Int")   2, false, false, false, 158, 9,  9, 1,  3, 1}, // #618
  {DBGFIELD("CVTSS2SI64rr_CVTTSS2SI64rr") 2, false, false, false, 2680, 12,  8, 1,  0, 0}, // #619
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 2, false, false, false, 2680, 12,  8, 1,  0, 0}, // #620
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 4, false, false, false, 2344, 16,  7, 1,  0, 0}, // #621
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 2, false, false, false, 98, 2, 13, 1,  0, 0}, // #622
  {DBGFIELD("LFENCE")             2, false, false, false, 98, 2, 13, 1,  0, 0}, // #623
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #624
  {DBGFIELD("LEAVE_LEAVE64")      3, false, false, false, 881, 4,  6, 1,  0, 0}, // #625
  {DBGFIELD("POP16r")             2, false, false, false, 55, 4,  3, 1,  0, 0}, // #626
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 4, false, false, false, 49, 6,  3, 1,  0, 0}, // #627
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #628
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #629
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #630
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, false,  1, 2,  1, 1,  0, 0}, // #631
  {DBGFIELD("MMX_PADDQrr_MMX_PSUBQrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #632
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #633
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #634
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  2, false, false, false, 33, 4,  1, 1,  0, 0}, // #635
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, false, 154, 4,  1, 1,  0, 0}, // #636
  {DBGFIELD("CLD")                3, false, false, false, 885, 7,  5, 1,  0, 0}, // #637
  {DBGFIELD("LDDQUrm")            1, false, false, false, 37, 3, 14, 1,  0, 0}, // #638
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #639
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 4, false, false, false, 49, 6,  3, 1,  0, 0}, // #640
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 6, false, false, false, 2692, 6,  2, 1,  0, 0}, // #641
  {DBGFIELD("PHADDDrr_PHSUBDrr")  3, false, false, false, 2443, 8,  5, 1,  0, 0}, // #642
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #643
  {DBGFIELD("MMX_PADDQrm_MMX_PSUBQrm") 2, false, false, false, 148, 6,  3, 1,  3, 1}, // #644
  {DBGFIELD("MOVDQUrm")           1, false, false, false, 37, 3, 14, 1,  0, 0}, // #645
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, false, 37, 3, 14, 1,  0, 0}, // #646
  {DBGFIELD("PADDQrm_PSUBQrm")    2, false, false, false, 148, 6,  3, 1,  3, 1}, // #647
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #648
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   2, false, false, false, 903, 4, 13, 1,  0, 0}, // #649
  {DBGFIELD("LD_F80m")            1, false, false, false, 37, 3,  3, 1,  0, 0}, // #650
  {DBGFIELD("PHADDDrm_PHSUBDrm")  4, false, false, false, 2433, 10,  2, 1,  3, 1}, // #651
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 2, false, false, false, 313, 12, 13, 1,  0, 0}, // #652
  {DBGFIELD("FLDCW16m")           3, false, false, false, 1204, 11,  6, 1,  0, 0}, // #653
  {DBGFIELD("ST_FP80m")           2, false, false, false, 33, 4,  1, 1,  0, 0}, // #654
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 3, false, false, false, 2443, 8,  5, 1,  0, 0}, // #655
  {DBGFIELD("CMPXCHG8rm")         6, false, false, false, 12, 8,  2, 1,  0, 0}, // #656
  {DBGFIELD("INTO")               1, false, false, false,  1, 2,  4, 1,  0, 0}, // #657
  {DBGFIELD("XLAT")               1, false, false, false, 37, 3, 14, 1,  0, 0}, // #658
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 4, false, false, false, 395, 9,  3, 1,  0, 0}, // #659
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #660
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 6, false, false, false, 2464, 11, 18, 1,  0, 0}, // #661
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 4, false, false, false, 699, 9,  9, 1,  0, 0}, // #662
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 3, false, false, false, 2519, 10,  8, 1,  0, 0}, // #663
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 4, false, false, false, 2433, 10,  2, 1,  3, 1}, // #664
  {DBGFIELD("AAD8i8")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #665
  {DBGFIELD("LOOPE")              11, false, false, false, 918, 4, 18, 1,  0, 0}, // #666
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, false, 33, 4,  1, 1,  0, 0}, // #667
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 4, false, false, false, 395, 9,  3, 1,  0, 0}, // #668
  {DBGFIELD("FNSTCW16m")          3, false, false, false, 922, 10, 13, 1,  0, 0}, // #669
  {DBGFIELD("POPA16_POPA32")      1, false, false, false, 37, 3, 14, 1,  0, 0}, // #670
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #671
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 6, false, false, false, 2464, 11, 18, 1,  0, 0}, // #672
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 4, false, false, false, 699, 9,  9, 1,  0, 0}, // #673
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #674
  {DBGFIELD("CMPXCHG8rr")         5, false, false, false, 175, 4, 14, 1,  0, 0}, // #675
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #676
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #677
  {DBGFIELD("AAA_AAS")            1, false, false, false,  1, 2,  4, 1,  0, 0}, // #678
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 6, false, false, false, 12, 8,  2, 1,  0, 0}, // #679
  {DBGFIELD("LOOPNE")             11, false, false, false, 918, 4, 18, 1,  0, 0}, // #680
  {DBGFIELD("PAUSE")              5, false, false, false, 2698, 7, 14, 1,  0, 0}, // #681
  {DBGFIELD("CMPXCHG8B")          14, false, false, false, 939, 10, 19, 1,  0, 0}, // #682
  {DBGFIELD("DAA")                1, false, false, false,  1, 2,  4, 1,  0, 0}, // #683
  {DBGFIELD("LOOP")               7, false, false, false, 2705, 9,  6, 1,  0, 0}, // #684
  {DBGFIELD("DAS")                1, false, false, false,  1, 2,  4, 1,  0, 0}, // #685
  {DBGFIELD("AAM8i8")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #686
  {DBGFIELD("STD")                6, false, false, false, 958, 7,  3, 1,  0, 0}, // #687
  {DBGFIELD("CMPXCHG16B")         19, false, false, false, 965, 15, 37, 1,  0, 0}, // #688
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, false,  1, 2,  4, 1,  0, 0}, // #689
  {DBGFIELD("FNCLEX_FXTRACT")     4, false, false, false, 300, 2,  8, 1,  0, 0}, // #690
  {DBGFIELD("POPF32_POPF64")      1, false, false, false, 37, 3, 14, 1,  0, 0}, // #691
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #692
  {DBGFIELD("RDTSC_RDTSCP")       22, false, false, false, 980, 8, 40, 1,  0, 0}, // #693
  {DBGFIELD("ENTER")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #694
  {DBGFIELD("POPF16")             1, false, false, false, 37, 3, 14, 1,  0, 0}, // #695
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #696
  {DBGFIELD("FRNDINT")            1, false, false, false,  1, 2,  4, 1,  0, 0}, // #697
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false, false,  1, 2,  4, 1,  0, 0}, // #698
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, false,  1, 2,  4, 1,  0, 0}, // #699
  {DBGFIELD("FPREM")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #700
  {DBGFIELD("INSB_INSL_INSW")     8, false, false, false, 999, 15, 12, 1,  0, 0}, // #701
  {DBGFIELD("FNINIT")             15, false, false, false, 2714, 9, 41, 1,  0, 0}, // #702
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 23, false, false, false, 1022, 13, 42, 1,  0, 0}, // #703
  {DBGFIELD("FPREM1")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #704
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #705
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 23, false, false, false, 1022, 13, 42, 1,  0, 0}, // #706
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, false,  1, 2,  4, 1,  0, 0}, // #707
  {DBGFIELD("FSCALE")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #708
  {DBGFIELD("RDMSR")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #709
  {DBGFIELD("RET_RET16_RET32_RET64_LRET16_LRET32_LRET64_LRETI16_LRETI32_LRETI64") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #710
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 23, false, false, false, 1035, 13, 58, 1,  0, 0}, // #711
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 23, false, false, false, 1035, 13, 58, 1,  0, 0}, // #712
  {DBGFIELD("F2XM1")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #713
  {DBGFIELD("CPUID")              8, false, false, false, 1048, 11, 31, 1,  0, 0}, // #714
  {DBGFIELD("INT")                1, false, false, false,  1, 2,  4, 1,  0, 0}, // #715
  {DBGFIELD("INT3")               1, false, false, false,  1, 2,  4, 1,  0, 0}, // #716
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, false,  1, 2,  4, 1,  0, 0}, // #717
  {DBGFIELD("FXRSTOR_FXRSTOR64")  90, false, false, false, 1059, 15, 43, 1,  0, 0}, // #718
  {DBGFIELD("FYL2X")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #719
  {DBGFIELD("FYL2XP1")            1, false, false, false,  1, 2,  4, 1,  0, 0}, // #720
  {DBGFIELD("FPTAN")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #721
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, false,  1, 2,  4, 1,  0, 0}, // #722
  {DBGFIELD("FPATAN")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #723
  {DBGFIELD("WRMSR")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #724
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, false, 26, 7,  1, 1,  0, 0}, // #725
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, false, 26, 7,  1, 1,  0, 0}, // #726
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 2, false, false, false, 637, 4, 13, 1,  0, 0}, // #727
  {DBGFIELD("FNOP")               1, false, false, false, 65, 4,  1, 1,  0, 0}, // #728
  {DBGFIELD("RET64")              3, false, false, false, 1074, 9,  6, 1,  0, 0}, // #729
  {DBGFIELD("CDQ_CQO")            1, false, false, false,  8, 4,  1, 1,  0, 0}, // #730
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #731
  {DBGFIELD("MMX_PADDQrr")        1, false, false, false, 154, 4,  1, 1,  0, 0}, // #732
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, false, 474, 8,  1, 1,  0, 0}, // #733
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 3, false, false, false, 881, 4,  6, 1,  0, 0}, // #734
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int_VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #735
  {DBGFIELD("CWD")                2, false, false, false, 903, 4, 13, 1,  0, 0}, // #736
  {DBGFIELD("FNSTSW16r")          2, false, false, false, 1083, 9,  8, 1,  0, 0}, // #737
  {DBGFIELD("MMX_MOVDQ2Qrr")      2, false, false, false, 2723, 4, 13, 1,  0, 0}, // #738
  {DBGFIELD("PUSHFS64")           1, false, false, false,  1, 2,  4, 1,  0, 0}, // #739
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 2, false, false, false, 313, 12, 13, 1,  0, 0}, // #740
  {DBGFIELD("RCL8r1_RCL16r1_RCL32r1_RCL64r1_RCR8r1_RCR16r1_RCR32r1_RCR64r1") 3, false, false, false, 1092, 4, 13, 1,  0, 0}, // #741
  {DBGFIELD("RCR8ri_RCR16ri_RCR32ri_RCR64ri") 8, false, false, false, 1096, 9, 14, 1,  0, 0}, // #742
  {DBGFIELD("RCL8ri_RCL16ri_RCL32ri_RCL64ri") 8, false, false, false, 1096, 9,  3, 1,  0, 0}, // #743
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #744
  {DBGFIELD("MOV64sr")            1, false, false, false,  1, 2,  1, 1,  0, 0}, // #745
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVSX32rm16_MOVSX32rm32_MOVSX32rm8_MOVSX32rm8_NOREX_MOVSX64rm16_MOVSX64rm32_MOVSX64rm8_MOVZX16rm16_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX_MOVZX64rm16_MOVZX64rm8") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #746
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 10, false, false, false, 2727, 9, 10, 1,  0, 0}, // #747
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 3, false, false, false, 1114, 5, 13, 1,  0, 0}, // #748
  {DBGFIELD("CLI")                1, false, false, false,  1, 2,  4, 1,  0, 0}, // #749
  {DBGFIELD("PUSHGS64")           1, false, false, false,  1, 2,  4, 1,  0, 0}, // #750
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 3, false, false, false, 2519, 10,  8, 1,  0, 0}, // #751
  {DBGFIELD("CALL64pcrel32")      4, false, false, false, 1119, 7,  5, 1,  0, 0}, // #752
  {DBGFIELD("CALL64r_RVMARKER_CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 4, false, false, false, 1126, 10,  5, 1,  0, 0}, // #753
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 3, false, false, false, 302, 11, 13, 1,  0, 0}, // #754
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 3, false, false, false, 1114, 5, 13, 1,  0, 0}, // #755
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 3, false, false, false, 302, 11, 13, 1,  0, 0}, // #756
  {DBGFIELD("PUSHF16_PUSHF64")    6, false, false, false, 1136, 5, 14, 1,  0, 0}, // #757
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 2, false, false, false, 1141, 7, 13, 1,  0, 0}, // #758
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, false, 37, 3, 14, 1,  0, 0}, // #759
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #760
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #761
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #762
  {DBGFIELD("MOV16sm")            1, false, false, false,  1, 2,  1, 1,  0, 0}, // #763
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 2, false, false, false, 148, 6,  3, 1,  0, 0}, // #764
  {DBGFIELD("MMX_PALIGNRrmi")     2, false, false, false, 464, 10,  3, 1,  3, 1}, // #765
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 2, false, false, false, 148, 6,  3, 1,  3, 1}, // #766
  {DBGFIELD("LODSL_LODSQ")        1, false, false, false,  1, 2,  4, 1,  0, 0}, // #767
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #768
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #769
  {DBGFIELD("VINSERTF128rm")      2, false, false, false, 60, 5,  3, 1,  0, 0}, // #770
  {DBGFIELD("MMX_PADDQrm")        2, false, false, false, 148, 6,  3, 1,  3, 1}, // #771
  {DBGFIELD("VERRm_VERWm")        1, false, false, false,  1, 2,  4, 1,  0, 0}, // #772
  {DBGFIELD("FARJMP64m")          2, false, false, false, 1148, 9,  3, 1,  0, 0}, // #773
  {DBGFIELD("FNSTSWm")            3, false, false, false, 1157, 11,  8, 1,  0, 0}, // #774
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 4, false, false, false, 1168, 11,  3, 1,  0, 0}, // #775
  {DBGFIELD("CALL64m_RVMARKER_CALL64m_CALL64m_NT") 5, false, false, false, 1179, 11,  6, 1,  0, 0}, // #776
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 5, false, false, false, 1179, 11,  6, 1,  0, 0}, // #777
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int_VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #778
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #779
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 5, false, false, false, 1190, 8,  6, 1,  0, 0}, // #780
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 5, false, false, false, 1198, 6,  6, 1,  0, 0}, // #781
  {DBGFIELD("FARCALL64m")         5, false, false, false, 1179, 11,  6, 1,  0, 0}, // #782
  {DBGFIELD("CVTSD2SI64rm_CVTSD2SI64rm_Int_CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int") 3, false, false, false, 2736, 14,  9, 1,  0, 0}, // #783
  {DBGFIELD("CVTSS2SIrm_CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int") 3, false, false, false, 2736, 14,  9, 1,  0, 0}, // #784
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, false, 37, 3,  3, 1,  0, 0}, // #785
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 6, false, false, false, 12, 8,  2, 1,  0, 0}, // #786
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 6, false, false, false, 12, 8,  2, 1,  1, 2}, // #787
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 2, false, false, false, 158, 9,  9, 1,  0, 0}, // #788
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 2, false, false, false, 69, 11,  7, 1,  0, 0}, // #789
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 3, false, false, false, 2455, 9,  7, 1,  0, 0}, // #790
  {DBGFIELD("MUL_F32m_MUL_F64m")  2, false, false, false, 69, 11, 18, 1,  0, 0}, // #791
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 3, false, false, false, 2455, 9, 23, 1,  0, 0}, // #792
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 3, false, false, false, 2736, 14, 10, 1,  0, 0}, // #793
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 2, false, false, false, 69, 11, 37, 1,  0, 0}, // #794
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 3, false, false, false, 2736, 14, 30, 1,  0, 0}, // #795
  {DBGFIELD("VZEROALL")           20, false, false, false, 2750, 11,  2, 1,  0, 0}, // #796
  {DBGFIELD("VZEROUPPER")         4, false, false, false,  0, 0,  0, 1,  0, 0}, // #797
  {DBGFIELD("CLC")                1, false, false, false,  0, 0,  1, 1,  0, 0}, // #798
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #799
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #800
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #801
  {DBGFIELD("PXORrr_VPXORrr")     8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #802
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #803
  {DBGFIELD("PSUBQrr")            8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #804
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #805
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #806
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #807
  {DBGFIELD("SETCCr")             8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #808
  {DBGFIELD("SETCCm")             8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #809
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #810
  {DBGFIELD("RETI16_RETI32_RETI64") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #811
  {DBGFIELD("LRETI16_LRETI32_LRETI64") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #812
  {DBGFIELD("RDPMC")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #813
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 5, false, false, false, 2761, 6,  9, 1,  0, 0}, // #814
  {DBGFIELD("FBLDm")              1, false, false, false,  1, 2,  4, 1,  0, 0}, // #815
  {DBGFIELD("FFREE_FFREEP")       1, false, false, false,  1, 2,  4, 1,  0, 0}, // #816
  {DBGFIELD("FSAVEm")             1, false, false, false,  1, 2,  4, 1,  0, 0}, // #817
  {DBGFIELD("FRSTORm")            1, false, false, false,  1, 2,  4, 1,  0, 0}, // #818
  {DBGFIELD("FXTRACT")            1, false, false, false,  1, 2,  4, 1,  0, 0}, // #819
  {DBGFIELD("MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #820
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #821
  {DBGFIELD("VBROADCASTF128")     1, false, false, false, 37, 3,  3, 1,  0, 0}, // #822
  {DBGFIELD("VBROADCASTI128")     1, false, false, false, 37, 3,  3, 1,  0, 0}, // #823
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #824
  {DBGFIELD("FBSTPm")             2, false, false, false, 33, 4,  1, 1,  0, 0}, // #825
  {DBGFIELD("VMPTRSTm")           1, false, false, false,  1, 2,  4, 1,  0, 0}, // #826
  {DBGFIELD("ST_FP32m_ST_FP64m")  2, false, false, false, 33, 4,  1, 1,  0, 0}, // #827
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 1, false, false, false, 40, 9,  1, 1,  0, 0}, // #828
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 1, false, false, false, 40, 9,  1, 1,  0, 0}, // #829
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false, false, 474, 8,  1, 1,  0, 0}, // #830
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false, false, 1217, 7,  1, 1,  0, 0}, // #831
  {DBGFIELD("FINCSTP")            1, false, false, false, 65, 4,  1, 1,  0, 0}, // #832
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false, false, 154, 4,  1, 1,  0, 0}, // #833
  {DBGFIELD("VPBLENDDYrri")       1, false, false, false, 30, 3,  1, 1,  0, 0}, // #834
  {DBGFIELD("VPBLENDDrri")        1, false, false, false, 30, 3,  1, 1,  0, 0}, // #835
  {DBGFIELD("CMC_STC")            1, false, false, false,  1, 2,  1, 1,  0, 0}, // #836
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #837
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 2, false, false, false, 69, 11,  3, 1,  0, 0}, // #838
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 2, false, false, false, 69, 11,  3, 1,  0, 0}, // #839
  {DBGFIELD("CVTSS2SDrm")         2, false, false, false, 69, 11,  3, 1,  0, 0}, // #840
  {DBGFIELD("CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 2, false, false, false, 69, 11,  3, 1,  0, 0}, // #841
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 2, false, false, false, 69, 11,  6, 1,  0, 0}, // #842
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #843
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 2, false, false, false, 464, 10,  3, 1,  0, 0}, // #844
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 2, false, false, false, 464, 10,  2, 1,  0, 0}, // #845
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 2, false, false, false, 1148, 9,  3, 1,  0, 0}, // #846
  {DBGFIELD("ANDN32rm_ANDN64rm")  2, false, false, false, 148, 6,  3, 1,  0, 0}, // #847
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 2, false, false, false, 148, 6,  3, 1,  0, 0}, // #848
  {DBGFIELD("VINSERTI128rm")      2, false, false, false, 60, 5,  3, 1,  0, 0}, // #849
  {DBGFIELD("VPBLENDDrmi")        2, false, false, false, 60, 5,  3, 1,  0, 0}, // #850
  {DBGFIELD("VPBLENDDYrmi")       2, false, false, false, 60, 5,  6, 1,  0, 0}, // #851
  {DBGFIELD("POP32r_POP64r")      2, false, false, false, 55, 4,  3, 1,  0, 0}, // #852
  {DBGFIELD("SFENCE")             2, false, false, false, 23, 3, 13, 1,  0, 0}, // #853
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 3, false, false, false, 1224, 7, 13, 1,  0, 0}, // #854
  {DBGFIELD("MOVBE16mr")          3, false, false, false, 1224, 7, 13, 1,  0, 0}, // #855
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 3, false, false, false, 1114, 5, 13, 1,  0, 0}, // #856
  {DBGFIELD("MFENCE")             2, false, false, false, 98, 2, 13, 1,  0, 0}, // #857
  {DBGFIELD("XGETBV")             2, false, false, false, 98, 2, 13, 1,  0, 0}, // #858
  {DBGFIELD("CVTPS2PDrr_VCVTPS2PDrr") 2, false, false, false, 313, 12, 13, 1,  0, 0}, // #859
  {DBGFIELD("CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 2, false, false, false, 313, 12, 13, 1,  0, 0}, // #860
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm_MMX_PACKUSWBrm") 3, false, false, false, 531, 10,  6, 1,  0, 0}, // #861
  {DBGFIELD("LRET64_RET32")       2, false, false, false, 20, 6,  3, 1,  0, 0}, // #862
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 2, false, false, false, 1231, 4, 13, 1,  0, 0}, // #863
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #864
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #865
  {DBGFIELD("VCVTDQ2PSYrr")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #866
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #867
  {DBGFIELD("CVTPS2DQrm_VCVTPS2DQrm_CVTTPS2DQrm_VCVTTPS2DQrm") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #868
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, false, 158, 9,  9, 1,  0, 0}, // #869
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm") 2, false, false, false, 158, 9,  9, 1,  0, 0}, // #870
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 2, false, false, false, 464, 10,  2, 1,  0, 0}, // #871
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr_MMX_PACKUSWBrr") 3, false, false, false, 1235, 8,  5, 1,  0, 0}, // #872
  {DBGFIELD("CLDEMOTE")           3, false, false, false, 885, 7,  5, 1,  0, 0}, // #873
  {DBGFIELD("CVTSD2SI64rr_CVTSD2SIrr_CVTTSD2SI64rr_CVTTSD2SIrr_VCVTSD2SI64rr_VCVTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, false, 2680, 12,  8, 1,  0, 0}, // #874
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 2, false, false, false, 2680, 12,  8, 1,  0, 0}, // #875
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int_CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, false, 2680, 12,  8, 1,  0, 0}, // #876
  {DBGFIELD("CVTSS2SIrr_CVTTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 2, false, false, false, 2680, 12,  8, 1,  0, 0}, // #877
  {DBGFIELD("VCVTPS2PDYrr")       2, false, false, false, 313, 12,  8, 1,  0, 0}, // #878
  {DBGFIELD("MMX_CVTPI2PDrr")     2, false, false, false, 453, 11,  8, 1,  0, 0}, // #879
  {DBGFIELD("MMX_CVTPD2PIrr_MMX_CVTTPD2PIrr") 2, false, false, false, 453, 11,  8, 1,  0, 0}, // #880
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 2, false, false, false, 453, 11,  8, 1,  0, 0}, // #881
  {DBGFIELD("CVTPD2PSrr_VCVTPD2PSrr") 2, false, false, false, 453, 11,  8, 1,  0, 0}, // #882
  {DBGFIELD("CVTSD2SSrr_CVTSD2SSrr_Int_VCVTSD2SSrr_VCVTSD2SSrr_Int") 2, false, false, false, 453, 11,  8, 1,  0, 0}, // #883
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 2, false, false, false, 453, 11,  8, 1,  0, 0}, // #884
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, false, 453, 11,  8, 1,  0, 0}, // #885
  {DBGFIELD("CVTSI2SSrr")         2, false, false, false, 453, 11,  8, 1,  0, 0}, // #886
  {DBGFIELD("CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int") 2, false, false, false, 453, 11,  8, 1,  0, 0}, // #887
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, false, 453, 11,  8, 1,  0, 0}, // #888
  {DBGFIELD("VCVTSD2SI64rm_VCVTSD2SI64rm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 3, false, false, false, 2736, 14,  9, 1,  0, 0}, // #889
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int") 3, false, false, false, 2736, 14,  9, 1,  0, 0}, // #890
  {DBGFIELD("VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, false, 2736, 14,  9, 1,  0, 0}, // #891
  {DBGFIELD("VCVTPS2PDYrm")       3, false, false, false, 655, 14,  9, 1,  0, 0}, // #892
  {DBGFIELD("CVTPD2PSrm")         3, false, false, false, 440, 13,  9, 1,  0, 0}, // #893
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_MMX_CVTPD2PIrm_MMX_CVTTPD2PIrm") 3, false, false, false, 440, 13,  9, 1,  0, 0}, // #894
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 3, false, false, false, 440, 13,  9, 1,  0, 0}, // #895
  {DBGFIELD("MMX_CVTPI2PDrm")     3, false, false, false, 440, 13,  9, 1,  0, 0}, // #896
  {DBGFIELD("CVTSD2SSrm")         3, false, false, false, 440, 13,  9, 1,  0, 0}, // #897
  {DBGFIELD("CVTSD2SSrm_Int_VCVTSD2SSrm_VCVTSD2SSrm_Int") 3, false, false, false, 440, 13,  9, 1,  0, 0}, // #898
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 3, false, false, false, 2767, 10,  9, 1,  0, 0}, // #899
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 8, false, false, false, 2777, 13, 10, 1,  0, 0}, // #900
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 5, false, false, false, 1274, 13,  9, 1,  0, 0}, // #901
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, false, 40, 9, 14, 1,  0, 0}, // #902
  {DBGFIELD("VPCMPGTQYrm")        2, false, false, false, 69, 11, 18, 1,  0, 0}, // #903
  {DBGFIELD("VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, false, 2422, 11, 14, 1,  0, 0}, // #904
  {DBGFIELD("STR16r_STR32r_STR64r") 3, false, false, false, 1287, 11, 14, 1,  0, 0}, // #905
  {DBGFIELD("XSETBV")             5, false, false, false, 1298, 4, 14, 1,  0, 0}, // #906
  {DBGFIELD("VCVTDQ2PDYrr")       2, false, false, false, 453, 11,  3, 1,  0, 0}, // #907
  {DBGFIELD("VCVTPD2PSYrr")       2, false, false, false, 453, 11,  3, 1,  0, 0}, // #908
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 2, false, false, false, 453, 11,  3, 1,  0, 0}, // #909
  {DBGFIELD("VCVTDQ2PDYrm")       3, false, false, false, 440, 13, 18, 1,  0, 0}, // #910
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 10, false, false, false, 2790, 11, 21, 1,  0, 0}, // #911
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 7, false, false, false, 2801, 9, 18, 1,  0, 0}, // #912
  {DBGFIELD("RCL8rCL")            9, false, false, false, 2810, 9, 18, 1,  0, 0}, // #913
  {DBGFIELD("RDTSC")              8, false, false, false, 1048, 11, 31, 1,  0, 0}, // #914
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 19, false, false, false, 2819, 9, 36, 1,  0, 0}, // #915
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, false, 40, 9, 12, 1,  0, 0}, // #916
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 2, false, false, false, 69, 11, 62, 1,  0, 0}, // #917
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 3, false, false, false, 2736, 14, 15, 1,  0, 0}, // #918
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, false, 40, 9, 21, 1,  0, 0}, // #919
  {DBGFIELD("XSAVE64")            27, false, false, false, 2828, 11, 15, 1,  0, 0}, // #920
  {DBGFIELD("XSAVE")              28, false, false, false, 2839, 11, 47, 1,  0, 0}, // #921
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 28, false, false, false, 2839, 11, 47, 1,  0, 0}, // #922
  {DBGFIELD("VMCLEARm")           1, false, false, false,  1, 2,  4, 1,  0, 0}, // #923
  {DBGFIELD("FLDENVm")            64, false, false, false, 2850, 11, 93, 1,  0, 0}, // #924
  {DBGFIELD("FXRSTOR64")          88, false, false, false, 1405, 15, 43, 1,  0, 0}, // #925
  {DBGFIELD("FSTENVm")            100, false, false, false, 2861, 17, 94, 1,  0, 0}, // #926
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm") 7, false, false, false, 2878, 12, 17, 1,  0, 0}, // #927
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 9, false, false, false, 2890, 12, 31, 1,  0, 0}, // #928
  {DBGFIELD("VGATHERDPSrm_VPGATHERDDrm") 10, false, false, false, 2902, 12, 20, 1,  0, 0}, // #929
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 14, false, false, false, 2914, 12, 37, 1,  0, 0}, // #930
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 7, false, false, false, 2878, 12, 17, 1,  0, 0}, // #931
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm_VGATHERQPSYrm_VPGATHERQDYrm") 10, false, false, false, 2902, 12, 20, 1,  0, 0}, // #932
  {DBGFIELD("VGATHERQPSrm_VPGATHERQDrm") 9, false, false, false, 2926, 12, 20, 1,  0, 0}, // #933
  {DBGFIELD("VPXORYrr")           8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #934
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #935
  {DBGFIELD("VPCMPGTQYrr")        8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #936
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false, false,  8, 4,  1, 1,  0, 0}, // #937
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 2, false, false, false, 903, 4, 13, 1,  0, 0}, // #938
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 2, false, false, false, 158, 9,  6, 1,  0, 0}, // #939
  {DBGFIELD("LRET64")             3, false, false, false, 1074, 9,  6, 1,  0, 0}, // #940
  {DBGFIELD("CVTDQ2PSrm_VCVTDQ2PSrm") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #941
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 3, false, false, false, 440, 13,  9, 1,  0, 0}, // #942
  {DBGFIELD("POPF64")             18, false, false, false, 2938, 9, 44, 1,  0, 0}, // #943
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 9, false, false, false, 2890, 12, 31, 1,  0, 0}, // #944
  {DBGFIELD("PCMPEQQrr")          1, false, false, false, 154, 4,  1, 1,  0, 0}, // #945
  {DBGFIELD("PCMPEQQrm")          2, false, false, false, 148, 6,  3, 1,  3, 1}, // #946
  {DBGFIELD("MOV16rm")            1, false, false, false, 37, 3, 14, 1,  0, 0}, // #947
  {DBGFIELD("MOVSX32rm16_MOVSX32rm8_MOVSX32rm8_NOREX_MOVZX32rm16_MOVZX32rm8_MOVZX32rm8_NOREX") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #948
  {DBGFIELD("POP16rmm")           4, false, false, false, 49, 6,  3, 1,  0, 0}, // #949
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 4, false, false, false, 49, 6,  3, 1,  0, 0}, // #950
  {DBGFIELD("PUSHF16")            6, false, false, false, 1136, 5, 14, 1,  0, 0}, // #951
  {DBGFIELD("LAHF")               1, false, false, false,  8, 4,  1, 1,  0, 0}, // #952
  {DBGFIELD("ADD16mi_ADD16mi8_ADD32mi_ADD32mi8_ADD64mi32_ADD64mi8_ADD8mi_ADD8mi8_SUB16mi_SUB16mi8_SUB32mi_SUB32mi8_SUB64mi32_SUB64mi8_SUB8mi_SUB8mi8") 3, false, false, false, 49, 6,  6, 1,  0, 0}, // #953
  {DBGFIELD("ADD16mr_ADD32mr_ADD64mr_ADD8mr_SUB16mr_SUB32mr_SUB64mr_SUB8mr") 3, false, false, false, 49, 6,  6, 1,  1, 1}, // #954
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 6, false, false, false, 12, 8,  2, 1,  0, 0}, // #955
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 3, false, false, false, 49, 6,  6, 1,  0, 0}, // #956
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 4, false, false, false, 1126, 10,  5, 1,  0, 0}, // #957
  {DBGFIELD("RET16_LRET16_LRET32") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #958
  {DBGFIELD("IRET16_IRET32_IRET64") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #959
  {DBGFIELD("AND16mi_AND16mi8_AND32mi_AND32mi8_AND64mi32_AND64mi8_AND8mi_AND8mi8_OR16mi_OR16mi8_OR32mi_OR32mi8_OR32mi8Locked_OR64mi32_OR64mi8_OR8mi_OR8mi8_XOR16mi_XOR16mi8_XOR32mi_XOR32mi8_XOR64mi32_XOR64mi8_XOR8mi_XOR8mi8") 3, false, false, false, 49, 6,  6, 1,  0, 0}, // #960
  {DBGFIELD("AND16mr_AND32mr_AND64mr_AND8mr_OR16mr_OR32mr_OR64mr_OR8mr_XOR16mr_XOR32mr_XOR64mr_XOR8mr") 3, false, false, false, 49, 6,  6, 1,  1, 1}, // #961
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 4, false, false, false, 699, 9,  9, 1,  0, 0}, // #962
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 4, false, false, false, 395, 9,  3, 1,  0, 0}, // #963
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 6, false, false, false, 2464, 11, 18, 1,  0, 0}, // #964
  {DBGFIELD("MOVSLDUPrm")         1, false, false, false, 37, 3, 14, 1,  0, 0}, // #965
  {DBGFIELD("MOVSLDUPrr")         1, false, false, false, 474, 8,  1, 1,  0, 0}, // #966
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 3, false, false, false, 280, 2, 13, 1,  0, 0}, // #967
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #968
  {DBGFIELD("PBLENDWrri_VPBLENDWrri") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #969
  {DBGFIELD("VPBLENDWYrri")       1, false, false, false, 474, 8,  1, 1,  0, 0}, // #970
  {DBGFIELD("PBLENDWrmi_VPBLENDWrmi") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #971
  {DBGFIELD("VPBLENDWYrmi")       2, false, false, false, 464, 10,  6, 1,  5, 1}, // #972
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #973
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #974
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #975
  {DBGFIELD("VPMASKMOVDYrm")      3, false, false, false, 531, 10,  2, 1,  0, 0}, // #976
  {DBGFIELD("VPMASKMOVDrm")       3, false, false, false, 531, 10,  6, 1,  0, 0}, // #977
  {DBGFIELD("VPMASKMOVDYmr")      4, false, false, false, 2573, 12, 14, 1,  0, 0}, // #978
  {DBGFIELD("VPMASKMOVDmr")       4, false, false, false, 2573, 12, 14, 1,  0, 0}, // #979
  {DBGFIELD("VPMASKMOVQYmr")      4, false, false, false, 2573, 12, 14, 1,  0, 0}, // #980
  {DBGFIELD("VPMASKMOVQmr")       4, false, false, false, 2573, 12, 14, 1,  0, 0}, // #981
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 3, false, false, false, 2767, 10,  9, 1,  0, 0}, // #982
  {DBGFIELD("VPGATHERDDYrm")      14, false, false, false, 2914, 12, 37, 1,  0, 0}, // #983
  {DBGFIELD("VPGATHERDDrm")       10, false, false, false, 2902, 12, 20, 1,  0, 0}, // #984
  {DBGFIELD("VPGATHERDQYrm")      9, false, false, false, 2890, 12, 31, 1,  0, 0}, // #985
  {DBGFIELD("VPGATHERDQrm")       7, false, false, false, 2878, 12, 17, 1,  0, 0}, // #986
  {DBGFIELD("VPGATHERQDYrm")      10, false, false, false, 2902, 12, 20, 1,  0, 0}, // #987
  {DBGFIELD("VPGATHERQDrm")       9, false, false, false, 2926, 12, 20, 1,  0, 0}, // #988
  {DBGFIELD("VPGATHERQQYrm")      9, false, false, false, 2890, 12, 31, 1,  0, 0}, // #989
  {DBGFIELD("VPGATHERQQrm")       7, false, false, false, 2878, 12, 17, 1,  0, 0}, // #990
  {DBGFIELD("PSLLDQri_PSRLDQri_VPSLLDQri_VPSRLDQri") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #991
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #992
  {DBGFIELD("VPERM2F128rr")       1, false, false, false, 474, 8,  5, 1,  0, 0}, // #993
  {DBGFIELD("VPERM2F128rm")       2, false, false, false, 464, 10,  9, 1,  5, 1}, // #994
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, false, 474, 8,  5, 1,  0, 0}, // #995
  {DBGFIELD("VEXTRACTF128mr")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #996
  {DBGFIELD("VINSERTF128rr")      1, false, false, false, 474, 8,  5, 1,  0, 0}, // #997
  {DBGFIELD("VCVTPD2DQrm_VCVTTPD2DQrm") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #998
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #999
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, false, 2680, 12,  8, 1,  0, 0}, // #1000
  {DBGFIELD("VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, false, 2736, 14,  9, 1,  0, 0}, // #1001
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1002
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1003
  {DBGFIELD("SHA256MSG2rm")       2, false, false, false, 69, 11,  7, 1,  3, 1}, // #1004
  {DBGFIELD("SHA256MSG2rr")       1, false, false, false, 40, 9, 14, 1,  0, 0}, // #1005
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, false, 40, 9, 14, 1,  0, 0}, // #1006
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 2, false, false, false, 69, 11,  7, 1,  3, 1}, // #1007
  {DBGFIELD("SHA1MSG2rr")         1, false, false, false, 40, 9, 14, 1,  0, 0}, // #1008
  {DBGFIELD("SHA1MSG2rm")         2, false, false, false, 69, 11,  7, 1,  3, 1}, // #1009
  {DBGFIELD("SHA1NEXTErr")        1, false, false, false, 40, 9, 14, 1,  0, 0}, // #1010
  {DBGFIELD("SHA1NEXTErm")        2, false, false, false, 69, 11,  7, 1,  3, 1}, // #1011
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, false, 40, 9, 14, 1,  0, 0}, // #1012
  {DBGFIELD("SHA1RNDS4rmi")       2, false, false, false, 69, 11,  7, 1,  3, 1}, // #1013
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, false, 40, 9, 14, 1,  0, 0}, // #1014
  {DBGFIELD("SHA256RNDS2rm")      2, false, false, false, 69, 11,  7, 1,  3, 1}, // #1015
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 3, false, false, false, 280, 2, 13, 1,  0, 0}, // #1016
  {DBGFIELD("BT16mi8_BT32mi8_BT64mi8") 2, false, false, false, 20, 6,  3, 1,  0, 0}, // #1017
  {DBGFIELD("BTC16ri8_BTC16rr_BTC32ri8_BTC32rr_BTC64ri8_BTC64rr_BTR16ri8_BTR16rr_BTR32ri8_BTR32rr_BTR64ri8_BTR64rr_BTS16ri8_BTS16rr_BTS32ri8_BTS32rr_BTS64ri8_BTS64rr") 1, false, false, false,  8, 4,  1, 1,  0, 0}, // #1018
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1019
  {DBGFIELD("MOV8rm_MOV8rm_NOREX") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1020
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32_MOVZX16rm16") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1021
  {DBGFIELD("MOVBE16rm")          2, false, false, false, 148, 6,  3, 1,  0, 0}, // #1022
  {DBGFIELD("ADD8i8_ADD16i16_ADD32i32_ADD64i32_AND8i8_AND16i16_AND32i32_AND64i32_OR8i8_OR16i16_OR32i32_OR64i32_SUB8i8_SUB16i16_SUB32i32_SUB64i32_XOR8i8_XOR16i16_XOR32i32_XOR64i32") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1023
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32_MOVZX16rr16") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1024
  {DBGFIELD("MOV32ri_MOV32ri_alt_MOV64ri32") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1025
  {DBGFIELD("ADC8mr_SBB8mr")      6, false, false, false, 12, 8,  2, 1,  1, 2}, // #1026
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1027
  {DBGFIELD("LEA16r")             1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1028
  {DBGFIELD("LCMPXCHG8")          6, false, false, false, 12, 8,  2, 1,  0, 0}, // #1029
  {DBGFIELD("LCMPXCHG16B")        6, false, false, false, 12, 8,  2, 1,  0, 0}, // #1030
  {DBGFIELD("XCHG8rr_XCHG16rr_XCHG16ar") 3, false, false, false, 280, 2, 13, 1,  0, 0}, // #1031
  {DBGFIELD("XCHG8rm_XCHG16rm")   6, false, false, false, 2692, 6,  2, 1,  0, 0}, // #1032
  {DBGFIELD("POPCNT16rr")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1033
  {DBGFIELD("LZCNT16rr")          1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1034
  {DBGFIELD("TZCNT16rr")          1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1035
  {DBGFIELD("RCL8m1_RCL16m1_RCL32m1_RCL64m1_RCR8m1_RCR16m1_RCR32m1_RCR64m1") 5, false, false, false, 823, 6,  2, 1,  0, 0}, // #1036
  {DBGFIELD("RCR8mi_RCR16mi_RCR32mi_RCR64mi") 5, false, false, false, 823, 6,  2, 1,  0, 0}, // #1037
  {DBGFIELD("RCR16rCL_RCR32rCL_RCR64rCL") 7, false, false, false, 2801, 9, 18, 1,  0, 0}, // #1038
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #1039
  {DBGFIELD("VEXTRACTI128rr")     1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1040
  {DBGFIELD("VEXTRACTI128mr")     2, false, false, false, 33, 4,  1, 1,  0, 0}, // #1041
  {DBGFIELD("MMX_MOVQ2FR64rr")    1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1042
  {DBGFIELD("MMX_MOVD64rr_MMX_MOVD64to64rr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1043
  {DBGFIELD("EXTRQ")              1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1044
  {DBGFIELD("INSERTQ")            1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1045
  {DBGFIELD("PABSBrr_PABSDrr_PABSWrr_PADDSBrr_PADDSWrr_PADDUSBrr_PADDUSWrr_PAVGBrr_PAVGWrr_PSIGNBrr_PSIGNDrr_PSIGNWrr_VPABSBrr_VPABSDrr_VPABSWrr_VPADDSBrr_VPADDSWrr_VPADDUSBrr_VPADDUSWrr_VPAVGBrr_VPAVGWrr_VPCMPEQQrr_VPSIGNBrr_VPSIGNDrr_VPSIGNWrr_PSUBSBrr_PSUBSWrr_PSUBUSBrr_PSUBUSWrr_VPSUBSBrr_VPSUBSWrr_VPSUBUSBrr_VPSUBUSWrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1046
  {DBGFIELD("MMX_PADDSBrr_MMX_PADDSWrr_MMX_PADDUSBrr_MMX_PADDUSWrr_MMX_PAVGBrr_MMX_PAVGWrr_MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1047
  {DBGFIELD("VPABSBYrr_VPABSDYrr_VPABSWYrr_VPADDSBYrr_VPADDSWYrr_VPADDUSBYrr_VPADDUSWYrr_VPSUBSBYrr_VPSUBSWYrr_VPSUBUSBYrr_VPSUBUSWYrr_VPAVGBYrr_VPAVGWYrr_VPCMPEQQYrr_VPSIGNBYrr_VPSIGNDYrr_VPSIGNWYrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1048
  {DBGFIELD("SHA1MSG1rr")         1, false, false, false, 40, 9, 14, 1,  0, 0}, // #1049
  {DBGFIELD("SHA1MSG1rm")         2, false, false, false, 69, 11,  7, 1,  3, 1}, // #1050
  {DBGFIELD("VPERM2I128rr")       1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1051
  {DBGFIELD("VPERMPSYrr")         1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1052
  {DBGFIELD("VPERMPSYrm")         2, false, false, false, 464, 10,  9, 1,  5, 1}, // #1053
  {DBGFIELD("VPERMPDYri")         1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1054
  {DBGFIELD("VPERMQYri")          1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1055
  {DBGFIELD("VPERMPDYmi")         2, false, false, false, 464, 10,  9, 1,  5, 1}, // #1056
  {DBGFIELD("VPERMDYrr")          1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1057
  {DBGFIELD("VPERMQYmi")          2, false, false, false, 464, 10,  9, 1,  5, 1}, // #1058
  {DBGFIELD("VPERMDYrm")          2, false, false, false, 464, 10,  9, 1,  5, 1}, // #1059
  {DBGFIELD("MOV32rr_MOV32rr_REV_MOV64rr_MOV64rr_REV") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1060
  {DBGFIELD("MOVSX32rr32")        1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1061
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV_SUB32rr_REV_SUB64rr_REV") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1062
  {DBGFIELD("CMP8rr_CMP8rr_REV_CMP16rr_CMP16rr_REV_CMP32rr_CMP32rr_REV_CMP64rr_CMP64rr_REV") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1063
  {DBGFIELD("VXORPSrr_VXORPDrr")  8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1064
  {DBGFIELD("VANDNPSrr_VANDNPDrr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1065
  {DBGFIELD("VANDNPSYrr_VANDNPDYrr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1066
  {DBGFIELD("VPXORrr")            8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1067
  {DBGFIELD("VPANDNrr")           1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1068
  {DBGFIELD("VPANDNYrr")          1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1069
  {DBGFIELD("VPSUBBrr_VPSUBWrr_VPSUBDrr_VPSUBQrr_VPCMPGTBrr_VPCMPGTWrr_VPCMPGTDrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1070
  {DBGFIELD("VPCMPGTQrr")         8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1071
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 1, false, false, false,  1, 2,  4, 1,  0, 0}, // #1072
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 3, false, false, false, 49, 6,  6, 1,  0, 0}, // #1073
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1074
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 2, false, false, false, 55, 4,  3, 1,  0, 0}, // #1075
  {DBGFIELD("ADC64ri32_SBB64ri32") 1, false, false, false,  8, 4,  1, 1,  0, 0}, // #1076
  {DBGFIELD("CRC32r32r16")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1077
  {DBGFIELD("CRC32r32r32")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1078
  {DBGFIELD("CRC32r64r64")        1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1079
  {DBGFIELD("SAHF")               1, false, false, false,  8, 4,  1, 1,  0, 0}, // #1080
  {DBGFIELD("BEXTRI32ri_BEXTRI64ri") 2, false, false, false, 134, 6, 13, 1,  0, 0}, // #1081
  {DBGFIELD("BEXTRI32mi_BEXTRI64mi") 3, false, false, false, 126, 8,  6, 1,  0, 0}, // #1082
  {DBGFIELD("RCR8ri")             8, false, false, false, 1096, 9, 14, 1,  0, 0}, // #1083
  {DBGFIELD("RCL16rCL")           7, false, false, false, 2801, 9, 18, 1,  0, 0}, // #1084
  {DBGFIELD("RCR16ri")            8, false, false, false, 1096, 9, 14, 1,  0, 0}, // #1085
  {DBGFIELD("RCR32rCL_RCR64rCL")  7, false, false, false, 2801, 9, 18, 1,  0, 0}, // #1086
  {DBGFIELD("RCL16ri")            8, false, false, false, 1096, 9,  3, 1,  0, 0}, // #1087
  {DBGFIELD("RCL32ri_RCL64ri")    8, false, false, false, 1096, 9,  3, 1,  0, 0}, // #1088
  {DBGFIELD("SHLD32rri8")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1089
  {DBGFIELD("SHRD16rri8")         1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1090
  {DBGFIELD("SHLD16rrCL")         4, false, false, false, 395, 9,  3, 1,  0, 0}, // #1091
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #1092
  {DBGFIELD("TST_F")              1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1093
  {DBGFIELD("VDPPSrri")           4, false, false, false, 2390, 14, 10, 1,  0, 0}, // #1094
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #1095
  {DBGFIELD("VFRCZSDrr_VFRCZSSrr") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #1096
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 3, false, false, false, 2455, 9, 18, 1,  3, 1}, // #1097
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #1098
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 3, false, false, false, 2455, 9, 23, 1,  5, 1}, // #1099
  {DBGFIELD("MMX_CVTTPD2PIrr")    2, false, false, false, 453, 11,  8, 1,  0, 0}, // #1100
  {DBGFIELD("VMOVDQUYmr")         2, false, false, false, 33, 4,  1, 1,  0, 0}, // #1101
  {DBGFIELD("MOVDQArr")           1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1102
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 2, false, false, false, 91, 9,  7, 1,  0, 0}, // #1103
  {DBGFIELD("VMPSADBWrri")        3, false, false, false, 1479, 12,  6, 1,  0, 0}, // #1104
  {DBGFIELD("VPPERMrrr_VPPERMrrr_REV") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1105
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 3, false, false, false, 2443, 8,  5, 1,  0, 0}, // #1106
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 4, false, false, false, 2433, 10,  2, 1,  3, 1}, // #1107
  {DBGFIELD("VPCLMULQDQrr")       1, false, false, false, 40, 9, 14, 1,  0, 0}, // #1108
  {DBGFIELD("ANDNPSrr_ANDNPDrr")  1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1109
  {DBGFIELD("MMX_PXORrr_MMX_PANDNrr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1110
  {DBGFIELD("PANDNrr")            1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1111
  {DBGFIELD("MMX_PSUBBrr_MMX_PSUBDrr_MMX_PSUBWrr_MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1112
  {DBGFIELD("LCMPXCHG16_LCMPXCHG32_LCMPXCHG64") 6, false, false, false, 12, 8,  2, 1,  0, 0}, // #1113
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 5, false, false, false, 175, 4, 14, 1,  0, 0}, // #1114
  {DBGFIELD("LCMPXCHG8B")         6, false, false, false, 12, 8,  2, 1,  0, 0}, // #1115
  {DBGFIELD("XCHG8rr")            3, false, false, false, 280, 2, 13, 1,  0, 0}, // #1116
  {DBGFIELD("MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1117
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1118
  {DBGFIELD("MMX_PCMPEQBrr_MMX_PCMPEQDrr_MMX_PCMPEQWrr_MMX_PMAXSWrr_MMX_PMINSWrr_MMX_PMAXUBrr_MMX_PMINUBrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1119
  {DBGFIELD("MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1120
  {DBGFIELD("CLAC_STAC")          1, false, false, false,  1, 2,  4, 1,  0, 0}, // #1121
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1122
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1123
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1124
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 3, false, false, false, 2443, 8,  5, 1,  0, 0}, // #1125
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, false, 2443, 8,  5, 1,  0, 0}, // #1126
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 3, false, false, false, 2443, 8,  5, 1,  0, 0}, // #1127
  {DBGFIELD("VCVTPS2DQYrr_VCVTTPS2DQYrr") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1128
  {DBGFIELD("MMX_PADDSBrm_MMX_PADDSWrm_MMX_PADDUSBrm_MMX_PADDUSWrm_MMX_PAVGBrm_MMX_PAVGWrm_MMX_PCMPEQBrm_MMX_PCMPEQDrm_MMX_PCMPEQWrm_MMX_PCMPGTBrm_MMX_PCMPGTDrm_MMX_PCMPGTWrm_MMX_PMAXSWrm_MMX_PMAXUBrm_MMX_PMINSWrm_MMX_PMINUBrm_MMX_PSUBSBrm_MMX_PSUBSWrm_MMX_PSUBUSBrm_MMX_PSUBUSWrm") 2, false, false, false, 148, 6,  3, 1,  3, 1}, // #1129
  {DBGFIELD("CVTSS2SI64rr")       2, false, false, false, 2680, 12,  8, 1,  0, 0}, // #1130
  {DBGFIELD("CVTSS2SI64rr_Int")   2, false, false, false, 2680, 12,  8, 1,  0, 0}, // #1131
  {DBGFIELD("CVTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr") 2, false, false, false, 2680, 12,  8, 1,  0, 0}, // #1132
  {DBGFIELD("CVTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int") 2, false, false, false, 2680, 12,  8, 1,  0, 0}, // #1133
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 2, false, false, false, 148, 6,  3, 1,  3, 1}, // #1134
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 2, false, false, false, 148, 6,  6, 1,  5, 1}, // #1135
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 4, false, false, false, 2433, 10,  2, 1,  3, 1}, // #1136
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, false, 2433, 10,  2, 1,  3, 1}, // #1137
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 4, false, false, false, 2433, 10,  9, 1,  5, 1}, // #1138
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 28, false, false, false, 2839, 11, 47, 1,  0, 0}, // #1139
  {DBGFIELD("PCMPGTBrr_PCMPGTDrr_PCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1140
  {DBGFIELD("VPCMPGTBrr_VPCMPGTDrr_VPCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1141
  {DBGFIELD("VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1142
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1143
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1144
  {DBGFIELD("KSET0D_KSET0Q_KSET0W_KSET1D_KSET1Q_KSET1W") 1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1145
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1146
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 2, false, false, false, 523, 8, 13, 1,  0, 0}, // #1147
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 2, false, false, false, 523, 8, 13, 1,  0, 0}, // #1148
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1149
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1150
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1151
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 2, false, false, false, 523, 8, 13, 1,  0, 0}, // #1152
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 2, false, false, false, 523, 8, 13, 1,  0, 0}, // #1153
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1154
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 2, false, false, false, 33, 4,  1, 1,  0, 0}, // #1155
  {DBGFIELD("KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1156
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1157
  {DBGFIELD("VPSADBWZrr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1158
  {DBGFIELD("VALIGNDZ128rri_VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rri_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1159
  {DBGFIELD("VALIGNDZ256rri_VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rri_VALIGNQZ256rrik_VALIGNQZ256rrikz") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1160
  {DBGFIELD("VALIGNDZrri_VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrri_VALIGNQZrrik_VALIGNQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1161
  {DBGFIELD("VDBPSADBWZrri_VDBPSADBWZrrik_VDBPSADBWZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1162
  {DBGFIELD("VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1163
  {DBGFIELD("VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1164
  {DBGFIELD("VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1165
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_VPTESTMBZ128rr_VPTESTMBZ128rrk_VPTESTMDZ128rr_VPTESTMDZ128rrk_VPTESTMQZ128rr_VPTESTMQZ128rrk_VPTESTMWZ128rr_VPTESTMWZ128rrk_VPTESTNMBZ128rr_VPTESTNMBZ128rrk_VPTESTNMDZ128rr_VPTESTNMDZ128rrk_VPTESTNMQZ128rr_VPTESTNMQZ128rrk_VPTESTNMWZ128rr_VPTESTNMWZ128rrk") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1166
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri_KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, false, 474, 8,  1, 1,  0, 0}, // #1167
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1168
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1169
  {DBGFIELD("VCMPPDZrri_VCMPPDZrrib_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrrib_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1170
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1171
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rrik_VPCMPDZ128rri_VPCMPDZ128rrik_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rrik_VPCMPUBZ128rri_VPCMPUBZ128rrik_VPCMPUDZ128rri_VPCMPUDZ128rrik_VPCMPUQZ128rri_VPCMPUQZ128rrik_VPCMPUWZ128rri_VPCMPUWZ128rrik_VPCMPWZ128rri_VPCMPWZ128rrik") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1172
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rrik_VPCMPDZ256rri_VPCMPDZ256rrik_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rrik_VPCMPUBZ256rri_VPCMPUBZ256rrik_VPCMPUDZ256rri_VPCMPUDZ256rrik_VPCMPUQZ256rri_VPCMPUQZ256rrik_VPCMPUWZ256rri_VPCMPUWZ256rrik_VPCMPWZ256rri_VPCMPWZ256rrik") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1173
  {DBGFIELD("VPCMPBZrri_VPCMPBZrrik_VPCMPDZrri_VPCMPDZrrik_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrrik_VPCMPUBZrri_VPCMPUBZrrik_VPCMPUDZrri_VPCMPUDZrrik_VPCMPUQZrri_VPCMPUQZrrik_VPCMPUWZrri_VPCMPUWZrrik_VPCMPWZrri_VPCMPWZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1174
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 1, false, false, false, 30, 3,  1, 1,  0, 0}, // #1175
  {DBGFIELD("VPTESTMBZrr_VPTESTMBZrrk_VPTESTMDZrr_VPTESTMDZrrk_VPTESTMQZrr_VPTESTMQZrrk_VPTESTMWZrr_VPTESTMWZrrk_VPTESTNMBZrr_VPTESTNMBZrrk_VPTESTNMDZrr_VPTESTNMDZrrk_VPTESTNMQZrr_VPTESTNMQZrrk_VPTESTNMWZrr_VPTESTNMWZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1176
  {DBGFIELD("VCVTDQ2PSZ128rr_VCVTDQ2PSZ128rrk_VCVTDQ2PSZ128rrkz_VCVTUDQ2PSZ128rr_VCVTUDQ2PSZ128rrk_VCVTUDQ2PSZ128rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1177
  {DBGFIELD("VCVTDQ2PSZ256rr_VCVTDQ2PSZ256rrk_VCVTDQ2PSZ256rrkz_VCVTUDQ2PSZ256rr_VCVTUDQ2PSZ256rrk_VCVTUDQ2PSZ256rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1178
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1179
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1180
  {DBGFIELD("VCVTPS2DQYrr")       1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1181
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1182
  {DBGFIELD("VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1183
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1184
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1185
  {DBGFIELD("VCVTDQ2PSZrr_VCVTUDQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1186
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1187
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1188
  {DBGFIELD("VCVTQQ2PDZrr_VCVTUQQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1189
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1190
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1191
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 2, false, false, false, 464, 10,  9, 1,  0, 0}, // #1192
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1193
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1194
  {DBGFIELD("VCVTPD2PSZ128rr_VCVTPD2PSZ128rrk_VCVTPD2PSZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1195
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1196
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1197
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1198
  {DBGFIELD("VCVTSD2SSZrr_VCVTSD2SSZrr_Int_VCVTSD2SSZrr_Intk_VCVTSD2SSZrr_Intkz_VCVTSD2SSZrrb_Int_VCVTSD2SSZrrb_Intk_VCVTSD2SSZrrb_Intkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1199
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 1, false, false, false, 26, 7,  8, 1,  6, 1}, // #1200
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 1, false, false, false, 26, 7,  8, 1,  6, 1}, // #1201
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1202
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false, 154, 4,  1, 1,  0, 0}, // #1203
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 3, false, false, false, 2519, 10, 14, 1,  0, 0}, // #1204
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 3, false, false, false, 2519, 10,  6, 1,  0, 0}, // #1205
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1206
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 2, false, false, false, 464, 10,  9, 1,  0, 0}, // #1207
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1208
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1209
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1210
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 1, false, false, false, 26, 7,  8, 1,  6, 1}, // #1211
  {DBGFIELD("VMOVSDZrm_VMOVSDZrm_alt_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrm_alt_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1212
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1213
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1214
  {DBGFIELD("VCVTPD2PSZ256rr_VCVTPD2PSZ256rrk_VCVTPD2PSZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1215
  {DBGFIELD("VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1216
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1217
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 1, false, false, false, 26, 7,  8, 1,  0, 0}, // #1218
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1219
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1220
  {DBGFIELD("VCVTPD2PSZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1221
  {DBGFIELD("VCVTPS2PDZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1222
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1223
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1224
  {DBGFIELD("VMOVNTDQAZ128rm")    1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1225
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 3, false, false, false, 531, 10,  6, 1,  3, 1}, // #1226
  {DBGFIELD("VBROADCASTI32X2Z128rm_VBROADCASTI32X2Z128rmk_VBROADCASTI32X2Z128rmkz_VPBROADCASTDZ128rm_VPBROADCASTDZ128rmk_VPBROADCASTDZ128rmkz_VPBROADCASTQZ128rm_VPBROADCASTQZ128rmk_VPBROADCASTQZ128rmkz") 2, false, false, false, 464, 10,  3, 1,  0, 0}, // #1227
  {DBGFIELD("VBROADCASTSSZ128rm_VBROADCASTSSZ128rmk_VBROADCASTSSZ128rmkz") 2, false, false, false, 464, 10,  9, 1,  0, 0}, // #1228
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1229
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 2, false, false, false, 464, 10,  3, 1,  0, 0}, // #1230
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1231
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 2, false, false, false, 148, 6,  3, 1,  3, 1}, // #1232
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 3, false, false, false, 531, 10,  6, 1,  3, 1}, // #1233
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 1, false, false, false, 474, 8,  5, 1,  0, 0}, // #1234
  {DBGFIELD("VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTSS2SI64Zrr_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 1, false, false, false, 26, 7,  5, 1,  0, 0}, // #1235
  {DBGFIELD("VCVTSS2SI64rr")      2, false, false, false, 2680, 12,  8, 1,  0, 0}, // #1236
  {DBGFIELD("VCVTSS2SI64rr_Int")  2, false, false, false, 2680, 12,  8, 1,  0, 0}, // #1237
  {DBGFIELD("VCVTTSS2SI64rr")     2, false, false, false, 2680, 12,  8, 1,  0, 0}, // #1238
  {DBGFIELD("VCVTTSS2SI64rr_Int") 2, false, false, false, 2680, 12,  8, 1,  0, 0}, // #1239
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, false, 37, 3, 14, 1,  0, 0}, // #1240
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 2, false, false, false, 464, 10,  9, 1,  0, 0}, // #1241
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1242
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1243
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1244
  {DBGFIELD("VSCATTERDPSZmr")     1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1245
  {DBGFIELD("VPBROADCASTBZ256rm_VPBROADCASTBZ256rmk_VPBROADCASTBZ256rmkz_VPBROADCASTBZrm_VPBROADCASTBZrmk_VPBROADCASTBZrmkz_VPBROADCASTWZ256rm_VPBROADCASTWZ256rmk_VPBROADCASTWZ256rmkz_VPBROADCASTWZrm_VPBROADCASTWZrmk_VPBROADCASTWZrmkz") 2, false, false, false, 464, 10,  9, 1,  0, 0}, // #1246
  {DBGFIELD("VMOVNTDQAZ256rm")    1, false, false, false, 37, 3,  3, 1,  0, 0}, // #1247
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 3, false, false, false, 531, 10,  2, 1,  5, 1}, // #1248
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1249
  {DBGFIELD("VBROADCASTF32X2Z256rm_VBROADCASTF32X2Z256rmk_VBROADCASTF32X2Z256rmkz_VBROADCASTF32X2Zrm_VBROADCASTF32X2Zrmk_VBROADCASTF32X2Zrmkz_VBROADCASTI32X2Z256rm_VBROADCASTI32X2Z256rmk_VBROADCASTI32X2Z256rmkz_VBROADCASTI32X2Zrm_VBROADCASTI32X2Zrmk_VBROADCASTI32X2Zrmkz_VPBROADCASTDZ256rm_VPBROADCASTDZ256rmk_VPBROADCASTDZ256rmkz_VPBROADCASTDZrm_VPBROADCASTDZrmk_VPBROADCASTDZrmkz_VPBROADCASTQZ256rm_VPBROADCASTQZ256rmk_VPBROADCASTQZ256rmkz_VPBROADCASTQZrm_VPBROADCASTQZrmk_VPBROADCASTQZrmkz") 2, false, false, false, 464, 10,  9, 1,  0, 0}, // #1250
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 2, false, false, false, 464, 10,  6, 1,  0, 0}, // #1251
  {DBGFIELD("VBROADCASTSDZ256rm_VBROADCASTSDZ256rmk_VBROADCASTSDZ256rmkz_VBROADCASTSDZrm_VBROADCASTSDZrmk_VBROADCASTSDZrmkz_VBROADCASTSSZ256rm_VBROADCASTSSZ256rmk_VBROADCASTSSZ256rmkz_VBROADCASTSSZrm_VBROADCASTSSZrmk_VBROADCASTSSZrmkz") 2, false, false, false, 464, 10,  9, 1,  0, 0}, // #1252
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #1253
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #1254
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #1255
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, false, 464, 10,  6, 1,  0, 0}, // #1256
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1257
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 1, false, false, false, 37, 3,  3, 1,  0, 0}, // #1258
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 2, false, false, false, 148, 6,  6, 1,  5, 1}, // #1259
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1260
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 3, false, false, false, 531, 10,  2, 1,  5, 1}, // #1261
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1262
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1263
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1264
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1265
  {DBGFIELD("VPSCATTERDDZmr")     1, false, false, false, 33, 4,  1, 1,  0, 0}, // #1266
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 2, false, false, false, 464, 10,  3, 1,  3, 1}, // #1267
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #1268
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #1269
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 2, false, false, false, 464, 10,  9, 1,  5, 1}, // #1270
  {DBGFIELD("VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 2, false, false, false, 148, 6,  3, 1,  3, 1}, // #1271
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmik_VFPCLASSPDZ128rm_VFPCLASSPDZ128rmb_VFPCLASSPDZ128rmbk_VFPCLASSPDZ128rmk_VFPCLASSPSZ128rm_VFPCLASSPSZ128rmb_VFPCLASSPSZ128rmbk_VFPCLASSPSZ128rmk") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #1272
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk") 2, false, false, false, 158, 9,  2, 1,  3, 1}, // #1273
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmik_VPCMPDZ128rmi_VPCMPDZ128rmib_VPCMPDZ128rmibk_VPCMPDZ128rmik_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmib_VPCMPQZ128rmibk_VPCMPQZ128rmik_VPCMPUBZ128rmi_VPCMPUBZ128rmik_VPCMPUDZ128rmi_VPCMPUDZ128rmib_VPCMPUDZ128rmibk_VPCMPUDZ128rmik_VPCMPUQZ128rmi_VPCMPUQZ128rmib_VPCMPUQZ128rmibk_VPCMPUQZ128rmik_VPCMPUWZ128rmi_VPCMPUWZ128rmik_VPCMPWZ128rmi_VPCMPWZ128rmik") 2, false, false, false, 148, 6,  3, 1,  3, 1}, // #1274
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 2, false, false, false, 60, 5,  3, 1,  3, 1}, // #1275
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 2, false, false, false, 464, 10,  6, 1,  5, 1}, // #1276
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1277
  {DBGFIELD("VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 2, false, false, false, 148, 6,  6, 1,  5, 1}, // #1278
  {DBGFIELD("VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1279
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmik_VFPCLASSPDZ256rm_VFPCLASSPDZ256rmb_VFPCLASSPDZ256rmbk_VFPCLASSPDZ256rmk_VFPCLASSPSZ256rm_VFPCLASSPSZ256rmb_VFPCLASSPSZ256rmbk_VFPCLASSPSZ256rmk") 2, false, false, false, 158, 9,  9, 1,  5, 1}, // #1280
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmik_VFPCLASSPDZrm_VFPCLASSPDZrmb_VFPCLASSPDZrmbk_VFPCLASSPDZrmk_VFPCLASSPSZrm_VFPCLASSPSZrmb_VFPCLASSPSZrmbk_VFPCLASSPSZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1281
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmik_VPCMPDZ256rmi_VPCMPDZ256rmib_VPCMPDZ256rmibk_VPCMPDZ256rmik_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmib_VPCMPQZ256rmibk_VPCMPQZ256rmik_VPCMPUBZ256rmi_VPCMPUBZ256rmik_VPCMPUDZ256rmi_VPCMPUDZ256rmib_VPCMPUDZ256rmibk_VPCMPUDZ256rmik_VPCMPUQZ256rmi_VPCMPUQZ256rmib_VPCMPUQZ256rmibk_VPCMPUQZ256rmik_VPCMPUWZ256rmi_VPCMPUWZ256rmik_VPCMPWZ256rmi_VPCMPWZ256rmik") 2, false, false, false, 148, 6,  6, 1,  5, 1}, // #1282
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmik_VPCMPDZrmi_VPCMPDZrmib_VPCMPDZrmibk_VPCMPDZrmik_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmib_VPCMPQZrmibk_VPCMPQZrmik_VPCMPUBZrmi_VPCMPUBZrmik_VPCMPUDZrmi_VPCMPUDZrmib_VPCMPUDZrmibk_VPCMPUDZrmik_VPCMPUQZrmi_VPCMPUQZrmib_VPCMPUQZrmibk_VPCMPUQZrmik_VPCMPUWZrmi_VPCMPUWZrmik_VPCMPWZrmi_VPCMPWZrmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1283
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 2, false, false, false, 60, 5,  6, 1,  5, 1}, // #1284
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1285
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 2, false, false, false, 158, 9,  9, 1,  0, 0}, // #1286
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 2, false, false, false, 158, 9,  9, 1,  0, 0}, // #1287
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #1288
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 2, false, false, false, 69, 11,  3, 1,  0, 0}, // #1289
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 2, false, false, false, 158, 9,  2, 1,  0, 0}, // #1290
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 2, false, false, false, 158, 9,  2, 1,  0,