/* Generated by wayland-scanner 1.23.1 */

#ifndef ORG_KDE_PLASMA_VIRTUAL_DESKTOP_CLIENT_PROTOCOL_H
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_org_kde_plasma_virtual_desktop The org_kde_plasma_virtual_desktop protocol
 * @section page_ifaces_org_kde_plasma_virtual_desktop Interfaces
 * - @subpage page_iface_org_kde_plasma_virtual_desktop_management - 
 * - @subpage page_iface_org_kde_plasma_virtual_desktop - 
 * @section page_copyright_org_kde_plasma_virtual_desktop Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2018 Marco Martin
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct org_kde_plasma_virtual_desktop;
struct org_kde_plasma_virtual_desktop_management;

#ifndef ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_INTERFACE
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_INTERFACE
/**
 * @page page_iface_org_kde_plasma_virtual_desktop_management org_kde_plasma_virtual_desktop_management
 * @section page_iface_org_kde_plasma_virtual_desktop_management_api API
 * See @ref iface_org_kde_plasma_virtual_desktop_management.
 */
/**
 * @defgroup iface_org_kde_plasma_virtual_desktop_management The org_kde_plasma_virtual_desktop_management interface
 */
extern const struct wl_interface org_kde_plasma_virtual_desktop_management_interface;
#endif
#ifndef ORG_KDE_PLASMA_VIRTUAL_DESKTOP_INTERFACE
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_INTERFACE
/**
 * @page page_iface_org_kde_plasma_virtual_desktop org_kde_plasma_virtual_desktop
 * @section page_iface_org_kde_plasma_virtual_desktop_api API
 * See @ref iface_org_kde_plasma_virtual_desktop.
 */
/**
 * @defgroup iface_org_kde_plasma_virtual_desktop The org_kde_plasma_virtual_desktop interface
 */
extern const struct wl_interface org_kde_plasma_virtual_desktop_interface;
#endif

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 * @struct org_kde_plasma_virtual_desktop_management_listener
 */
struct org_kde_plasma_virtual_desktop_management_listener {
	/**
	 * Emitted when a new desktop has been created
	 *
	 * 
	 * @param desktop_id Unique id of the desktop
	 * @param position Position of this desktop, to ensure the client and the server will see desktops in the same order
	 */
	void (*desktop_created)(void *data,
				struct org_kde_plasma_virtual_desktop_management *org_kde_plasma_virtual_desktop_management,
				const char *desktop_id,
				uint32_t position);
	/**
	 * Emitted when a desktop has been removed
	 *
	 * 
	 * @param desktop_id Unique id of the desktop
	 */
	void (*desktop_removed)(void *data,
				struct org_kde_plasma_virtual_desktop_management *org_kde_plasma_virtual_desktop_management,
				const char *desktop_id);
	/**
	 * sent all information about desktops
	 *
	 * This event is sent after all other properties has been sent
	 * after binding to the desktop manager object and after any other
	 * property changes done after that. This allows changes to the
	 * org_kde_plasma_virtual_desktop_management properties to be seen
	 * as atomic, even if they happen via multiple events.
	 */
	void (*done)(void *data,
		     struct org_kde_plasma_virtual_desktop_management *org_kde_plasma_virtual_desktop_management);
	/**
	 * @param rows Number of rows the virtual desktops are laid out into.
	 * @since 2
	 */
	void (*rows)(void *data,
		     struct org_kde_plasma_virtual_desktop_management *org_kde_plasma_virtual_desktop_management,
		     uint32_t rows);
};

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 */
static inline int
org_kde_plasma_virtual_desktop_management_add_listener(struct org_kde_plasma_virtual_desktop_management *org_kde_plasma_virtual_desktop_management,
						       const struct org_kde_plasma_virtual_desktop_management_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) org_kde_plasma_virtual_desktop_management,
				     (void (**)(void)) listener, data);
}

#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_GET_VIRTUAL_DESKTOP 0
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_REQUEST_CREATE_VIRTUAL_DESKTOP 1
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_REQUEST_REMOVE_VIRTUAL_DESKTOP 2

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_DESKTOP_CREATED_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_DESKTOP_REMOVED_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_ROWS_SINCE_VERSION 2

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_GET_VIRTUAL_DESKTOP_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_REQUEST_CREATE_VIRTUAL_DESKTOP_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_REQUEST_REMOVE_VIRTUAL_DESKTOP_SINCE_VERSION 1

/** @ingroup iface_org_kde_plasma_virtual_desktop_management */
static inline void
org_kde_plasma_virtual_desktop_management_set_user_data(struct org_kde_plasma_virtual_desktop_management *org_kde_plasma_virtual_desktop_management, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) org_kde_plasma_virtual_desktop_management, user_data);
}

/** @ingroup iface_org_kde_plasma_virtual_desktop_management */
static inline void *
org_kde_plasma_virtual_desktop_management_get_user_data(struct org_kde_plasma_virtual_desktop_management *org_kde_plasma_virtual_desktop_management)
{
	return wl_proxy_get_user_data((struct wl_proxy *) org_kde_plasma_virtual_desktop_management);
}

static inline uint32_t
org_kde_plasma_virtual_desktop_management_get_version(struct org_kde_plasma_virtual_desktop_management *org_kde_plasma_virtual_desktop_management)
{
	return wl_proxy_get_version((struct wl_proxy *) org_kde_plasma_virtual_desktop_management);
}

/** @ingroup iface_org_kde_plasma_virtual_desktop_management */
static inline void
org_kde_plasma_virtual_desktop_management_destroy(struct org_kde_plasma_virtual_desktop_management *org_kde_plasma_virtual_desktop_management)
{
	wl_proxy_destroy((struct wl_proxy *) org_kde_plasma_virtual_desktop_management);
}

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 *
 * Given the id of a particular virtual desktop, get the corresponding org_kde_plasma_virtual_desktop which represents only the desktop with that id.
 */
static inline struct org_kde_plasma_virtual_desktop *
org_kde_plasma_virtual_desktop_management_get_virtual_desktop(struct org_kde_plasma_virtual_desktop_management *org_kde_plasma_virtual_desktop_management, const char *desktop_id)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) org_kde_plasma_virtual_desktop_management,
			 ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_GET_VIRTUAL_DESKTOP, &org_kde_plasma_virtual_desktop_interface, wl_proxy_get_version((struct wl_proxy *) org_kde_plasma_virtual_desktop_management), 0, NULL, desktop_id);

	return (struct org_kde_plasma_virtual_desktop *) id;
}

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 *
 * Ask the server to create a new virtual desktop, and position it at a specified position. If the position is zero or less, it will be positioned at the beginning, if the position is the count or more, it will be positioned at the end.
 */
static inline void
org_kde_plasma_virtual_desktop_management_request_create_virtual_desktop(struct org_kde_plasma_virtual_desktop_management *org_kde_plasma_virtual_desktop_management, const char *name, uint32_t position)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_plasma_virtual_desktop_management,
			 ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_REQUEST_CREATE_VIRTUAL_DESKTOP, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_plasma_virtual_desktop_management), 0, name, position);
}

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop_management
 *
 * Ask the server to get rid of a virtual desktop, the server may or may not acconsent to the request.
 */
static inline void
org_kde_plasma_virtual_desktop_management_request_remove_virtual_desktop(struct org_kde_plasma_virtual_desktop_management *org_kde_plasma_virtual_desktop_management, const char *desktop_id)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_plasma_virtual_desktop_management,
			 ORG_KDE_PLASMA_VIRTUAL_DESKTOP_MANAGEMENT_REQUEST_REMOVE_VIRTUAL_DESKTOP, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_plasma_virtual_desktop_management), 0, desktop_id);
}

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 * @struct org_kde_plasma_virtual_desktop_listener
 */
struct org_kde_plasma_virtual_desktop_listener {
	/**
	 * The desktop got an id
	 *
	 * The format of the id is decided by the compositor
	 * implementation. A desktop id univocally identifies a virtual
	 * desktop and must be guaranteed to never exist two desktops with
	 * the same id. The format of the string id is up to the server
	 * implementation.
	 * @param desktop_id Unique id of the desktop
	 */
	void (*desktop_id)(void *data,
			   struct org_kde_plasma_virtual_desktop *org_kde_plasma_virtual_desktop,
			   const char *desktop_id);
	/**
	 * @param name User readable descriptive name for the desktop
	 */
	void (*name)(void *data,
		     struct org_kde_plasma_virtual_desktop *org_kde_plasma_virtual_desktop,
		     const char *name);
	/**
	 * The desktop has been activated
	 *
	 * The desktop will be the new "current" desktop of the system.
	 * The server may support either one virtual desktop active at a
	 * time, or other combinations such as one virtual desktop active
	 * per screen. Windows associated to this virtual desktop will be
	 * shown.
	 */
	void (*activated)(void *data,
			  struct org_kde_plasma_virtual_desktop *org_kde_plasma_virtual_desktop);
	/**
	 * This desktop is no longer active
	 *
	 * Windows that were associated only to this desktop will be
	 * hidden.
	 */
	void (*deactivated)(void *data,
			    struct org_kde_plasma_virtual_desktop *org_kde_plasma_virtual_desktop);
	/**
	 * sent all information about desktops
	 *
	 * This event is sent after all other properties has been sent
	 * after binding to the desktop object and after any other property
	 * changes done after that. This allows changes to the
	 * org_kde_plasma_virtual_desktop properties to be seen as atomic,
	 * even if they happen via multiple events.
	 */
	void (*done)(void *data,
		     struct org_kde_plasma_virtual_desktop *org_kde_plasma_virtual_desktop);
	/**
	 * This desktop has been removed
	 *
	 * This virtual desktop has just been removed by the server: All
	 * windows will lose the association to this desktop.
	 */
	void (*removed)(void *data,
			struct org_kde_plasma_virtual_desktop *org_kde_plasma_virtual_desktop);
};

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 */
static inline int
org_kde_plasma_virtual_desktop_add_listener(struct org_kde_plasma_virtual_desktop *org_kde_plasma_virtual_desktop,
					    const struct org_kde_plasma_virtual_desktop_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) org_kde_plasma_virtual_desktop,
				     (void (**)(void)) listener, data);
}

#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_REQUEST_ACTIVATE 0

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_DESKTOP_ID_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_NAME_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_ACTIVATED_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_DEACTIVATED_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_REMOVED_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 */
#define ORG_KDE_PLASMA_VIRTUAL_DESKTOP_REQUEST_ACTIVATE_SINCE_VERSION 1

/** @ingroup iface_org_kde_plasma_virtual_desktop */
static inline void
org_kde_plasma_virtual_desktop_set_user_data(struct org_kde_plasma_virtual_desktop *org_kde_plasma_virtual_desktop, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) org_kde_plasma_virtual_desktop, user_data);
}

/** @ingroup iface_org_kde_plasma_virtual_desktop */
static inline void *
org_kde_plasma_virtual_desktop_get_user_data(struct org_kde_plasma_virtual_desktop *org_kde_plasma_virtual_desktop)
{
	return wl_proxy_get_user_data((struct wl_proxy *) org_kde_plasma_virtual_desktop);
}

static inline uint32_t
org_kde_plasma_virtual_desktop_get_version(struct org_kde_plasma_virtual_desktop *org_kde_plasma_virtual_desktop)
{
	return wl_proxy_get_version((struct wl_proxy *) org_kde_plasma_virtual_desktop);
}

/** @ingroup iface_org_kde_plasma_virtual_desktop */
static inline void
org_kde_plasma_virtual_desktop_destroy(struct org_kde_plasma_virtual_desktop *org_kde_plasma_virtual_desktop)
{
	wl_proxy_destroy((struct wl_proxy *) org_kde_plasma_virtual_desktop);
}

/**
 * @ingroup iface_org_kde_plasma_virtual_desktop
 *
 * Request the server to set the status of this desktop to active: The server is free to consent or deny the request. This will be the new "current" virtual desktop of the system.
 */
static inline void
org_kde_plasma_virtual_desktop_request_activate(struct org_kde_plasma_virtual_desktop *org_kde_plasma_virtual_desktop)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_plasma_virtual_desktop,
			 ORG_KDE_PLASMA_VIRTUAL_DESKTOP_REQUEST_ACTIVATE, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_plasma_virtual_desktop), 0);
}

#ifdef  __cplusplus
}
#endif

#endif
