/* autostart.c generated by valac 0.56.18, the Vala compiler
 * generated from autostart.vala, do not modify */

/* 
    Copyright 2013 Julien Lavergne <gilir@ubuntu.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

#define LDEFAULT_APPS_TYPE_DBUS_BACKEND (ldefault_apps_dbus_backend_get_type ())
#define LDEFAULT_APPS_DBUS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LDEFAULT_APPS_TYPE_DBUS_BACKEND, LDefaultAppsDbusBackend))
#define LDEFAULT_APPS_DBUS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LDEFAULT_APPS_TYPE_DBUS_BACKEND, LDefaultAppsDbusBackendClass))
#define LDEFAULT_APPS_IS_DBUS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LDEFAULT_APPS_TYPE_DBUS_BACKEND))
#define LDEFAULT_APPS_IS_DBUS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LDEFAULT_APPS_TYPE_DBUS_BACKEND))
#define LDEFAULT_APPS_DBUS_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LDEFAULT_APPS_TYPE_DBUS_BACKEND, LDefaultAppsDbusBackendClass))

typedef struct _LDefaultAppsDbusBackend LDefaultAppsDbusBackend;
typedef struct _LDefaultAppsDbusBackendClass LDefaultAppsDbusBackendClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Block1Data {
	int _ref_count_;
	GtkBuilder* builder;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	GtkEntry* add_entry;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	GtkCheckButton* check;
};

VALA_EXTERN gchar* ldefault_apps_read_autostart_conf (void);
VALA_EXTERN gchar* ldefault_apps_get_config_home_path (const gchar* conf_file);
VALA_EXTERN gchar* ldefault_apps_get_config_path (const gchar* conf_file);
VALA_EXTERN void ldefault_apps_manual_autostart_init (GtkBuilder* builder);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ____lambda4_ (Block3Data* _data3_);
VALA_EXTERN void ldefault_apps_update_autostart_conf (const gchar* line,
                                          const gchar* action,
                                          GtkBuilder* builder);
static void _____lambda4__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                              gpointer self);
static void ____lambda5_ (Block3Data* _data3_);
static void _____lambda5__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void ___lambda6_ (Block2Data* _data2_);
static void ____lambda6__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
VALA_EXTERN GType ldefault_apps_dbus_backend_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LDefaultAppsDbusBackend, g_object_unref)
VALA_EXTERN void ldefault_apps_autostart_core_applications (GtkBuilder* builder,
                                                LDefaultAppsDbusBackend* dbus_backend);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

gchar*
ldefault_apps_read_autostart_conf (void)
{
	gchar* config_path = NULL;
	gchar* _tmp0_;
	GFile* config_file = NULL;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	const gchar* _tmp31_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	_tmp0_ = ldefault_apps_get_config_home_path ("autostart");
	_g_free0 (config_path);
	config_path = _tmp0_;
	_tmp1_ = config_path;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	config_file = _tmp2_;
	_tmp3_ = config_file;
	if (!g_file_query_exists (_tmp3_, NULL)) {
		gchar* config_system_path = NULL;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = ldefault_apps_get_config_path ("autostart");
		_g_free0 (config_system_path);
		config_system_path = _tmp4_;
		_tmp5_ = config_system_path;
		if (_tmp5_ == NULL) {
			GFile* config_parent = NULL;
			GFile* _tmp6_;
			GFile* _tmp7_;
			GFile* _tmp8_;
			_tmp6_ = config_file;
			_tmp7_ = g_file_get_parent (_tmp6_);
			config_parent = _tmp7_;
			_tmp8_ = config_parent;
			if (!g_file_query_exists (_tmp8_, NULL)) {
				{
					GFile* _tmp9_;
					_tmp9_ = config_parent;
					g_file_make_directory_with_parents (_tmp9_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GError* _tmp10_;
					const gchar* _tmp11_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp10_ = e;
					_tmp11_ = _tmp10_->message;
					g_message ("autostart.vala:44: %s", _tmp11_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (config_parent);
					_g_free0 (config_system_path);
					_g_object_unref0 (config_file);
					_g_free0 (config_path);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			{
				GFile* blank_file = NULL;
				const gchar* _tmp12_;
				GFile* _tmp13_;
				GFile* _tmp14_;
				GFileOutputStream* _tmp15_;
				GFileOutputStream* _tmp16_;
				g_message ("autostart.vala:50: Create blank file");
				_tmp12_ = config_path;
				_tmp13_ = g_file_new_for_path (_tmp12_);
				blank_file = _tmp13_;
				_tmp14_ = blank_file;
				_tmp15_ = g_file_create (_tmp14_, G_FILE_CREATE_PRIVATE, NULL, &_inner_error0_);
				_tmp16_ = _tmp15_;
				_g_object_unref0 (_tmp16_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (blank_file);
					goto __catch1_g_error;
				}
				_g_object_unref0 (blank_file);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp17_;
				const gchar* _tmp18_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp17_ = e;
				_tmp18_ = _tmp17_->message;
				g_message ("autostart.vala:56: %s", _tmp18_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (config_parent);
				_g_free0 (config_system_path);
				_g_object_unref0 (config_file);
				_g_free0 (config_path);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_g_object_unref0 (config_parent);
		} else {
			GFile* file = NULL;
			const gchar* _tmp19_;
			GFile* _tmp20_;
			GFile* config_parent = NULL;
			GFile* _tmp21_;
			GFile* _tmp22_;
			GFile* _tmp23_;
			_tmp19_ = config_system_path;
			_tmp20_ = g_file_new_for_path (_tmp19_);
			file = _tmp20_;
			_tmp21_ = config_file;
			_tmp22_ = g_file_get_parent (_tmp21_);
			config_parent = _tmp22_;
			_tmp23_ = config_parent;
			if (!g_file_query_exists (_tmp23_, NULL)) {
				{
					GFile* _tmp24_;
					_tmp24_ = config_parent;
					g_file_make_directory_with_parents (_tmp24_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch2_g_error;
					}
				}
				goto __finally2;
				__catch2_g_error:
				{
					GError* e = NULL;
					GError* _tmp25_;
					const gchar* _tmp26_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp25_ = e;
					_tmp26_ = _tmp25_->message;
					g_message ("autostart.vala:72: %s", _tmp26_);
					_g_error_free0 (e);
				}
				__finally2:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (config_parent);
					_g_object_unref0 (file);
					_g_free0 (config_system_path);
					_g_object_unref0 (config_file);
					_g_free0 (config_path);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			{
				GFile* _tmp27_;
				GFile* _tmp28_;
				_tmp27_ = file;
				_tmp28_ = config_file;
				g_file_copy (_tmp27_, _tmp28_, G_FILE_COPY_NONE, NULL, NULL, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch3_g_error;
				}
			}
			goto __finally3;
			__catch3_g_error:
			{
				GError* e = NULL;
				GError* _tmp29_;
				const gchar* _tmp30_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp29_ = e;
				_tmp30_ = _tmp29_->message;
				g_message ("autostart.vala:82: %s", _tmp30_);
				_g_error_free0 (e);
			}
			__finally3:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (config_parent);
				_g_object_unref0 (file);
				_g_free0 (config_system_path);
				_g_object_unref0 (config_file);
				_g_free0 (config_path);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_g_object_unref0 (config_parent);
			_g_object_unref0 (file);
		}
		_g_free0 (config_system_path);
	}
	_tmp31_ = config_path;
	g_message ("autostart.vala:86: Conf file for autostart: %s", _tmp31_);
	result = config_path;
	_g_object_unref0 (config_file);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->builder);
		g_slice_free (Block1Data, _data1_);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->add_entry);
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->check);
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}

static gchar*
g_file_stream_read_line (FILE* self)
{
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		GString* _tmp0_;
		GString* _tmp2_;
		c = fgetc (self);
		if (!(c != EOF)) {
			break;
		}
		_tmp0_ = ret;
		if (_tmp0_ == NULL) {
			GString* _tmp1_;
			_tmp1_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp1_;
		}
		if (c == ((gint) '\n')) {
			break;
		}
		_tmp2_ = ret;
		g_string_append_c ((GString*) _tmp2_, (gchar) c);
	}
	_tmp3_ = ret;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = ret;
		_tmp5_ = ((GString*) _tmp4_)->str;
		((GString*) _tmp4_)->str = NULL;
		result = _tmp5_;
		_g_string_free0 (ret);
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
____lambda4_ (Block3Data* _data3_)
{
	Block2Data* _data2_;
	Block1Data* _data1_;
	GtkCheckButton* _tmp0_;
	const gchar* _tmp1_;
	GtkCheckButton* _tmp2_;
	_data2_ = _data3_->_data2_;
	_data1_ = _data2_->_data1_;
	_tmp0_ = _data3_->check;
	_tmp1_ = gtk_button_get_label ((GtkButton*) _tmp0_);
	g_message ("autostart.vala:129: Label to update : %s", _tmp1_);
	_tmp2_ = _data3_->check;
	if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp2_)) {
		GtkCheckButton* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp3_ = _data3_->check;
		_tmp4_ = gtk_button_get_label ((GtkButton*) _tmp3_);
		_tmp5_ = string_slice (_tmp4_, (glong) 0, (glong) 1);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strcmp0 (_tmp6_, "#") == 0;
		_g_free0 (_tmp6_);
		if (_tmp7_) {
			GtkCheckButton* _tmp8_;
			const gchar* _tmp9_;
			GtkCheckButton* _tmp10_;
			const gchar* _tmp11_;
			_tmp8_ = _data3_->check;
			_tmp9_ = gtk_button_get_label ((GtkButton*) _tmp8_);
			ldefault_apps_update_autostart_conf (_tmp9_, "activate", _data1_->builder);
			_tmp10_ = _data3_->check;
			_tmp11_ = gtk_button_get_label ((GtkButton*) _tmp10_);
			g_message ("autostart.vala:135: Activate : %s", _tmp11_);
		}
	} else {
		GtkCheckButton* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gboolean _tmp16_;
		_tmp12_ = _data3_->check;
		_tmp13_ = gtk_button_get_label ((GtkButton*) _tmp12_);
		_tmp14_ = string_slice (_tmp13_, (glong) 0, (glong) 1);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strcmp0 (_tmp15_, "#") != 0;
		_g_free0 (_tmp15_);
		if (_tmp16_) {
			GtkCheckButton* _tmp17_;
			const gchar* _tmp18_;
			GtkCheckButton* _tmp19_;
			const gchar* _tmp20_;
			_tmp17_ = _data3_->check;
			_tmp18_ = gtk_button_get_label ((GtkButton*) _tmp17_);
			ldefault_apps_update_autostart_conf (_tmp18_, "desactivate", _data1_->builder);
			_tmp19_ = _data3_->check;
			_tmp20_ = gtk_button_get_label ((GtkButton*) _tmp19_);
			g_message ("autostart.vala:143: Deactivate : %s", _tmp20_);
		}
	}
}

static void
_____lambda4__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                         gpointer self)
{
	____lambda4_ (self);
}

static void
____lambda5_ (Block3Data* _data3_)
{
	Block2Data* _data2_;
	Block1Data* _data1_;
	GtkCheckButton* _tmp0_;
	const gchar* _tmp1_;
	GtkCheckButton* _tmp2_;
	const gchar* _tmp3_;
	_data2_ = _data3_->_data2_;
	_data1_ = _data2_->_data1_;
	_tmp0_ = _data3_->check;
	_tmp1_ = gtk_button_get_label ((GtkButton*) _tmp0_);
	ldefault_apps_update_autostart_conf (_tmp1_, "remove", _data1_->builder);
	_tmp2_ = _data3_->check;
	_tmp3_ = gtk_button_get_label ((GtkButton*) _tmp2_);
	g_message ("autostart.vala:153: try to remove : %s", _tmp3_);
}

static void
_____lambda5__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	____lambda5_ (self);
}

static void
___lambda6_ (Block2Data* _data2_)
{
	Block1Data* _data1_;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	GtkEntry* _tmp2_;
	_data1_ = _data2_->_data1_;
	_tmp0_ = _data2_->add_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	ldefault_apps_update_autostart_conf (_tmp1_, "add", _data1_->builder);
	_tmp2_ = _data2_->add_entry;
	gtk_entry_set_text (_tmp2_, "");
}

static void
____lambda6__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	___lambda6_ (self);
}

void
ldefault_apps_manual_autostart_init (GtkBuilder* builder)
{
	Block1Data* _data1_;
	GtkBuilder* _tmp0_;
	gchar* autostart_conf = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (builder != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (builder);
	_g_object_unref0 (_data1_->builder);
	_data1_->builder = _tmp0_;
	_tmp1_ = ldefault_apps_read_autostart_conf ();
	autostart_conf = _tmp1_;
	_tmp2_ = autostart_conf;
	if (_tmp2_ == NULL) {
		g_message ("autostart.vala:96: Can't find an autostart file, abort");
	} else {
		Block2Data* _data2_;
		FILE* stream = NULL;
		const gchar* _tmp3_;
		FILE* _tmp4_;
		FILE* _tmp5_;
		const gchar* _tmp6_;
		GtkAlignment* auto_align = NULL;
		GObject* _tmp7_;
		GtkAlignment* _tmp8_;
		GtkVBox* auto_vbox = NULL;
		GObject* _tmp9_;
		GtkVBox* _tmp10_;
		GtkVBox* _tmp11_;
		GList* _tmp12_;
		gchar* line = NULL;
		GtkHBox* add_hbox = NULL;
		GtkHBox* _tmp37_;
		GtkButton* add_button = NULL;
		GtkButton* _tmp38_;
		GtkEntry* _tmp39_;
		GtkHBox* _tmp40_;
		GtkButton* _tmp41_;
		GtkHBox* _tmp42_;
		GtkEntry* _tmp43_;
		GtkVBox* _tmp44_;
		GtkHBox* _tmp45_;
		GtkAlignment* _tmp46_;
		GtkVBox* _tmp47_;
		GtkButton* _tmp48_;
		GtkVBox* _tmp49_;
		_data2_ = g_slice_new0 (Block2Data);
		_data2_->_ref_count_ = 1;
		_data2_->_data1_ = block1_data_ref (_data1_);
		_tmp3_ = autostart_conf;
		_tmp4_ = g_fopen (_tmp3_, "r");
		stream = _tmp4_;
		_tmp5_ = stream;
		_vala_assert (_tmp5_ != NULL, "stream != null");
		_tmp6_ = autostart_conf;
		g_message ("autostart.vala:103: Autostart conf file : %s", _tmp6_);
		_tmp7_ = gtk_builder_get_object (_data1_->builder, "autostart_alignment");
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, GTK_TYPE_ALIGNMENT) ? ((GtkAlignment*) _tmp7_) : NULL);
		auto_align = _tmp8_;
		_tmp9_ = gtk_builder_get_object (_data1_->builder, "manual_autostart_vbox");
		_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, GTK_TYPE_VBOX) ? ((GtkVBox*) _tmp9_) : NULL);
		auto_vbox = _tmp10_;
		_tmp11_ = auto_vbox;
		_tmp12_ = gtk_container_get_children ((GtkContainer*) _tmp11_);
		{
			GList* widget_collection = NULL;
			GList* widget_it = NULL;
			widget_collection = _tmp12_;
			for (widget_it = widget_collection; widget_it != NULL; widget_it = widget_it->next) {
				GtkWidget* widget = NULL;
				widget = (GtkWidget*) widget_it->data;
				{
					GtkVBox* _tmp13_;
					GtkWidget* _tmp14_;
					_tmp13_ = auto_vbox;
					_tmp14_ = widget;
					gtk_container_remove ((GtkContainer*) _tmp13_, _tmp14_);
				}
			}
			(widget_collection == NULL) ? NULL : (widget_collection = (g_list_free (widget_collection), NULL));
		}
		line = NULL;
		while (TRUE) {
			Block3Data* _data3_;
			FILE* _tmp15_;
			gchar* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			GtkHBox* hbox = NULL;
			GtkHBox* _tmp19_;
			const gchar* _tmp20_;
			GtkCheckButton* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gboolean _tmp25_;
			GtkCheckButton* _tmp28_;
			GtkHBox* _tmp29_;
			GtkCheckButton* _tmp30_;
			GtkButton* button = NULL;
			GtkButton* _tmp31_;
			GtkButton* _tmp32_;
			GtkHBox* _tmp33_;
			GtkButton* _tmp34_;
			GtkVBox* _tmp35_;
			GtkHBox* _tmp36_;
			_data3_ = g_slice_new0 (Block3Data);
			_data3_->_ref_count_ = 1;
			_data3_->_data2_ = block2_data_ref (_data2_);
			_tmp15_ = stream;
			_tmp16_ = g_file_stream_read_line (_tmp15_);
			_g_free0 (line);
			line = _tmp16_;
			_tmp17_ = line;
			if (!(_tmp17_ != NULL)) {
				block3_data_unref (_data3_);
				_data3_ = NULL;
				break;
			}
			_tmp18_ = line;
			g_message ("autostart.vala:116: Autostart line : %s", _tmp18_);
			_tmp19_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
			g_object_ref_sink (_tmp19_);
			hbox = _tmp19_;
			_tmp20_ = line;
			_tmp21_ = (GtkCheckButton*) gtk_check_button_new_with_label (_tmp20_);
			g_object_ref_sink (_tmp21_);
			_data3_->check = _tmp21_;
			_tmp22_ = line;
			_tmp23_ = string_slice (_tmp22_, (glong) 0, (glong) 1);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strcmp0 (_tmp24_, "#") == 0;
			_g_free0 (_tmp24_);
			if (_tmp25_) {
				GtkCheckButton* _tmp26_;
				_tmp26_ = _data3_->check;
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp26_, FALSE);
			} else {
				GtkCheckButton* _tmp27_;
				_tmp27_ = _data3_->check;
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp27_, TRUE);
			}
			_tmp28_ = _data3_->check;
			g_signal_connect_data ((GtkToggleButton*) _tmp28_, "toggled", (GCallback) _____lambda4__gtk_toggle_button_toggled, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
			_tmp29_ = hbox;
			_tmp30_ = _data3_->check;
			gtk_box_pack_start ((GtkBox*) _tmp29_, (GtkWidget*) _tmp30_, FALSE, FALSE, (guint) 0);
			_tmp31_ = (GtkButton*) gtk_button_new_from_stock ("gtk-remove");
			g_object_ref_sink (_tmp31_);
			button = _tmp31_;
			_tmp32_ = button;
			g_signal_connect_data (_tmp32_, "clicked", (GCallback) _____lambda5__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
			_tmp33_ = hbox;
			_tmp34_ = button;
			gtk_box_pack_start ((GtkBox*) _tmp33_, (GtkWidget*) _tmp34_, FALSE, FALSE, (guint) 0);
			_tmp35_ = auto_vbox;
			_tmp36_ = hbox;
			gtk_box_pack_start ((GtkBox*) _tmp35_, (GtkWidget*) _tmp36_, FALSE, FALSE, (guint) 0);
			_g_object_unref0 (button);
			_g_object_unref0 (hbox);
			block3_data_unref (_data3_);
			_data3_ = NULL;
		}
		_tmp37_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
		g_object_ref_sink (_tmp37_);
		add_hbox = _tmp37_;
		_tmp38_ = (GtkButton*) gtk_button_new_from_stock ("gtk-add");
		g_object_ref_sink (_tmp38_);
		add_button = _tmp38_;
		_tmp39_ = (GtkEntry*) gtk_entry_new ();
		g_object_ref_sink (_tmp39_);
		_data2_->add_entry = _tmp39_;
		_tmp40_ = add_hbox;
		_tmp41_ = add_button;
		gtk_box_pack_start ((GtkBox*) _tmp40_, (GtkWidget*) _tmp41_, FALSE, FALSE, (guint) 0);
		_tmp42_ = add_hbox;
		_tmp43_ = _data2_->add_entry;
		gtk_box_pack_start ((GtkBox*) _tmp42_, (GtkWidget*) _tmp43_, FALSE, FALSE, (guint) 0);
		_tmp44_ = auto_vbox;
		_tmp45_ = add_hbox;
		gtk_box_pack_start ((GtkBox*) _tmp44_, (GtkWidget*) _tmp45_, FALSE, FALSE, (guint) 0);
		_tmp46_ = auto_align;
		_tmp47_ = auto_vbox;
		gtk_container_add ((GtkContainer*) _tmp46_, (GtkWidget*) _tmp47_);
		_tmp48_ = add_button;
		g_signal_connect_data (_tmp48_, "clicked", (GCallback) ____lambda6__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		_tmp49_ = auto_vbox;
		gtk_widget_show_all ((GtkWidget*) _tmp49_);
		_g_object_unref0 (add_button);
		_g_object_unref0 (add_hbox);
		_g_free0 (line);
		_g_object_unref0 (auto_vbox);
		_g_object_unref0 (auto_align);
		_fclose0 (stream);
		block2_data_unref (_data2_);
		_data2_ = NULL;
	}
	_g_free0 (autostart_conf);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

void
ldefault_apps_update_autostart_conf (const gchar* line,
                                     const gchar* action,
                                     GtkBuilder* builder)
{
	GString* new_line = NULL;
	GString* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (line != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = g_string_new ("");
	new_line = _tmp0_;
	_tmp1_ = action;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("activate")))) {
		switch (0) {
			default:
			{
				GString* _tmp4_;
				GString* _tmp5_;
				GString* _tmp6_;
				_tmp4_ = new_line;
				g_string_append (_tmp4_, line);
				_tmp5_ = new_line;
				g_string_erase (_tmp5_, (gssize) 0, (gssize) 1);
				_tmp6_ = new_line;
				g_string_append (_tmp6_, "\n");
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("desactivate")))) {
		switch (0) {
			default:
			{
				GString* _tmp7_;
				GString* _tmp8_;
				GString* _tmp9_;
				_tmp7_ = new_line;
				g_string_append (_tmp7_, "#");
				_tmp8_ = new_line;
				g_string_append (_tmp8_, line);
				_tmp9_ = new_line;
				g_string_append (_tmp9_, "\n");
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("add")))) {
		switch (0) {
			default:
			{
				GString* _tmp10_;
				GString* _tmp11_;
				_tmp10_ = new_line;
				g_string_append (_tmp10_, line);
				_tmp11_ = new_line;
				g_string_append (_tmp11_, "\n");
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("remove")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	{
		gchar* tmp_path = NULL;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		GFile* tmp_file = NULL;
		const gchar* _tmp14_;
		GFile* _tmp15_;
		GFile* dest_file = NULL;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		FILE* stream = NULL;
		gchar* _tmp20_;
		gchar* _tmp21_;
		FILE* _tmp22_;
		FILE* _tmp23_;
		GFileOutputStream* _tmp24_ = NULL;
		GFile* _tmp25_;
		GFileOutputStream* _tmp26_;
		GDataOutputStream* tmp_stream = NULL;
		GDataOutputStream* _tmp27_;
		FILE* _tmp28_;
		gchar* read = NULL;
		GFile* _tmp43_;
		GFile* _tmp44_;
		GFile* _tmp45_;
		_tmp12_ = g_get_user_cache_dir ();
		_tmp13_ = g_build_filename (_tmp12_, "lxsession-default-apps", "autostart.tmp", NULL);
		tmp_path = _tmp13_;
		_tmp14_ = tmp_path;
		_tmp15_ = g_file_new_for_path (_tmp14_);
		tmp_file = _tmp15_;
		_tmp16_ = ldefault_apps_read_autostart_conf ();
		_tmp17_ = _tmp16_;
		_tmp18_ = g_file_new_for_path (_tmp17_);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		dest_file = _tmp19_;
		_tmp20_ = ldefault_apps_read_autostart_conf ();
		_tmp21_ = _tmp20_;
		_tmp22_ = g_fopen (_tmp21_, "r");
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp21_);
		stream = _tmp23_;
		_tmp25_ = tmp_file;
		_tmp26_ = g_file_create (_tmp25_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
		_tmp24_ = _tmp26_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_fclose0 (stream);
			_g_object_unref0 (dest_file);
			_g_object_unref0 (tmp_file);
			_g_free0 (tmp_path);
			goto __catch0_g_error;
		}
		_tmp27_ = g_data_output_stream_new ((GOutputStream*) _tmp24_);
		tmp_stream = _tmp27_;
		_tmp28_ = stream;
		_vala_assert (_tmp28_ != NULL, "stream != null");
		read = NULL;
		while (TRUE) {
			FILE* _tmp29_;
			gchar* _tmp30_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			_tmp29_ = stream;
			_tmp30_ = g_file_stream_read_line (_tmp29_);
			_g_free0 (read);
			read = _tmp30_;
			_tmp31_ = read;
			if (!(_tmp31_ != NULL)) {
				break;
			}
			_tmp32_ = read;
			g_message ("autostart.vala:212: read : %s", _tmp32_);
			g_message ("autostart.vala:213: line : %s", line);
			_tmp33_ = read;
			if (g_strcmp0 (_tmp33_, line) == 0) {
				GDataOutputStream* _tmp34_;
				GString* _tmp35_;
				const gchar* _tmp36_;
				_tmp34_ = tmp_stream;
				_tmp35_ = new_line;
				_tmp36_ = _tmp35_->str;
				g_data_output_stream_put_string (_tmp34_, _tmp36_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (read);
					_g_object_unref0 (tmp_stream);
					_g_object_unref0 (_tmp24_);
					_fclose0 (stream);
					_g_object_unref0 (dest_file);
					_g_object_unref0 (tmp_file);
					_g_free0 (tmp_path);
					goto __catch0_g_error;
				}
			} else {
				GDataOutputStream* _tmp37_;
				const gchar* _tmp38_;
				GDataOutputStream* _tmp39_;
				_tmp37_ = tmp_stream;
				_tmp38_ = read;
				g_data_output_stream_put_string (_tmp37_, _tmp38_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (read);
					_g_object_unref0 (tmp_stream);
					_g_object_unref0 (_tmp24_);
					_fclose0 (stream);
					_g_object_unref0 (dest_file);
					_g_object_unref0 (tmp_file);
					_g_free0 (tmp_path);
					goto __catch0_g_error;
				}
				_tmp39_ = tmp_stream;
				g_data_output_stream_put_string (_tmp39_, "\n", NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (read);
					_g_object_unref0 (tmp_stream);
					_g_object_unref0 (_tmp24_);
					_fclose0 (stream);
					_g_object_unref0 (dest_file);
					_g_object_unref0 (tmp_file);
					_g_free0 (tmp_path);
					goto __catch0_g_error;
				}
			}
		}
		if (g_strcmp0 (action, "add") == 0) {
			GDataOutputStream* _tmp40_;
			GString* _tmp41_;
			const gchar* _tmp42_;
			_tmp40_ = tmp_stream;
			_tmp41_ = new_line;
			_tmp42_ = _tmp41_->str;
			g_data_output_stream_put_string (_tmp40_, _tmp42_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (read);
				_g_object_unref0 (tmp_stream);
				_g_object_unref0 (_tmp24_);
				_fclose0 (stream);
				_g_object_unref0 (dest_file);
				_g_object_unref0 (tmp_file);
				_g_free0 (tmp_path);
				goto __catch0_g_error;
			}
		}
		_tmp43_ = tmp_file;
		_tmp44_ = dest_file;
		g_file_copy (_tmp43_, _tmp44_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (read);
			_g_object_unref0 (tmp_stream);
			_g_object_unref0 (_tmp24_);
			_fclose0 (stream);
			_g_object_unref0 (dest_file);
			_g_object_unref0 (tmp_file);
			_g_free0 (tmp_path);
			goto __catch0_g_error;
		}
		_tmp45_ = tmp_file;
		g_file_delete (_tmp45_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (read);
			_g_object_unref0 (tmp_stream);
			_g_object_unref0 (_tmp24_);
			_fclose0 (stream);
			_g_object_unref0 (dest_file);
			_g_object_unref0 (tmp_file);
			_g_free0 (tmp_path);
			goto __catch0_g_error;
		}
		ldefault_apps_manual_autostart_init (builder);
		_g_free0 (read);
		_g_object_unref0 (tmp_stream);
		_g_object_unref0 (_tmp24_);
		_fclose0 (stream);
		_g_object_unref0 (dest_file);
		_g_object_unref0 (tmp_file);
		_g_free0 (tmp_path);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp46_;
		const gchar* _tmp47_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp46_ = e;
		_tmp47_ = _tmp46_->message;
		g_message ("autostart.vala:237: %s", _tmp47_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_string_free0 (new_line);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_string_free0 (new_line);
}

void
ldefault_apps_autostart_core_applications (GtkBuilder* builder,
                                           LDefaultAppsDbusBackend* dbus_backend)
{
	g_return_if_fail (builder != NULL);
	g_return_if_fail (dbus_backend != NULL);
}

gchar*
ldefault_apps_get_config_home_path (const gchar* conf_file)
{
	gchar* user_config_dir = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (conf_file != NULL, NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_getenv ("DESKTOP_SESSION");
	_tmp2_ = g_build_filename (_tmp0_, "lxsession", _tmp1_, conf_file, NULL);
	user_config_dir = _tmp2_;
	result = user_config_dir;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

gchar*
ldefault_apps_get_config_path (const gchar* conf_file)
{
	gchar* final_config_file = NULL;
	gchar* user_config_dir = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp20_;
	gchar* result;
	g_return_val_if_fail (conf_file != NULL, NULL);
	_tmp0_ = ldefault_apps_get_config_home_path (conf_file);
	user_config_dir = _tmp0_;
	_tmp1_ = user_config_dir;
	if (g_file_test (_tmp1_, G_FILE_TEST_EXISTS)) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = user_config_dir;
		g_message ("autostart.vala:291: User config used : %s", _tmp2_);
		_tmp3_ = user_config_dir;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (final_config_file);
		final_config_file = _tmp4_;
	} else {
		gchar** system_config_dirs = NULL;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		gint system_config_dirs_length1;
		gint _system_config_dirs_size_;
		gchar* config_system_location = NULL;
		gchar* path_system_config_file = NULL;
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp6_ = _tmp5_ = g_get_system_config_dirs ();
		_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup1 (_tmp6_, _vala_array_length (_tmp5_)) : _tmp6_;
		_tmp7__length1 = _vala_array_length (_tmp5_);
		system_config_dirs = _tmp7_;
		system_config_dirs_length1 = _tmp7__length1;
		_system_config_dirs_size_ = system_config_dirs_length1;
		config_system_location = NULL;
		path_system_config_file = NULL;
		_tmp8_ = system_config_dirs;
		_tmp8__length1 = system_config_dirs_length1;
		{
			gchar** config_collection = NULL;
			gint config_collection_length1 = 0;
			gint _config_collection_size_ = 0;
			gint config_it = 0;
			config_collection = _tmp8_;
			config_collection_length1 = _tmp8__length1;
			for (config_it = 0; config_it < config_collection_length1; config_it = config_it + 1) {
				gchar* _tmp9_;
				gchar* config = NULL;
				_tmp9_ = g_strdup (config_collection[config_it]);
				config = _tmp9_;
				{
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					gchar* _tmp12_;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					_tmp10_ = config;
					_tmp11_ = g_getenv ("DESKTOP_SESSION");
					_tmp12_ = g_build_filename (_tmp10_, "lxsession", _tmp11_, NULL);
					_g_free0 (config_system_location);
					config_system_location = _tmp12_;
					_tmp13_ = config_system_location;
					g_message ("autostart.vala:302: Config system location : %s", _tmp13_);
					_tmp14_ = config_system_location;
					if (g_file_test (_tmp14_, G_FILE_TEST_EXISTS)) {
						const gchar* _tmp15_;
						gchar* _tmp16_;
						_tmp15_ = config_system_location;
						_tmp16_ = g_build_filename (_tmp15_, conf_file, NULL);
						_g_free0 (path_system_config_file);
						path_system_config_file = _tmp16_;
						_g_free0 (config);
						break;
					}
					_g_free0 (config);
				}
			}
		}
		_tmp17_ = path_system_config_file;
		g_message ("autostart.vala:308: System system path location : %s", _tmp17_);
		_tmp18_ = path_system_config_file;
		_tmp19_ = g_strdup (_tmp18_);
		_g_free0 (final_config_file);
		final_config_file = _tmp19_;
		_g_free0 (path_system_config_file);
		_g_free0 (config_system_location);
		system_config_dirs = (_vala_array_free (system_config_dirs, system_config_dirs_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp20_ = final_config_file;
	g_message ("autostart.vala:312: Final file used : %s", _tmp20_);
	result = final_config_file;
	_g_free0 (user_config_dir);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

