/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "meta-dbus-remote-desktop.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_VOID__STRING_UINT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringUintFunc)
       (void *data1,
        const gchar *arg_mime_type,
        guint arg_serial,
        void *data2);
  _GDbusCodegenMarshalVoid_StringUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_uint (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_BOOLEAN (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintBooleanFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_keycode,
        gboolean arg_state,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintBooleanFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintBooleanFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              g_marshal_value_peek_boolean (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_BOOLEAN (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectIntBooleanFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint arg_button,
        gboolean arg_state,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectIntBooleanFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectIntBooleanFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int (param_values + 2),
              g_marshal_value_peek_boolean (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_DOUBLE_DOUBLE_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectDoubleDoubleUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gdouble arg_dx,
        gdouble arg_dy,
        guint arg_flags,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectDoubleDoubleUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectDoubleDoubleUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_double (param_values + 2),
              g_marshal_value_peek_double (param_values + 3),
              g_marshal_value_peek_uint (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_INT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintIntFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_axis,
        gint arg_steps,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              g_marshal_value_peek_int (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_DOUBLE_DOUBLE (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectDoubleDoubleFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gdouble arg_dx,
        gdouble arg_dy,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectDoubleDoubleFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectDoubleDoubleFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_double (param_values + 2),
              g_marshal_value_peek_double (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_DOUBLE_DOUBLE (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringDoubleDoubleFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_stream,
        gdouble arg_x,
        gdouble arg_y,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringDoubleDoubleFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringDoubleDoubleFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_double (param_values + 3),
              g_marshal_value_peek_double (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_UINT_DOUBLE_DOUBLE (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringUintDoubleDoubleFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_stream,
        guint arg_slot,
        gdouble arg_x,
        gdouble arg_y,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringUintDoubleDoubleFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringUintDoubleDoubleFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_uint (param_values + 3),
              g_marshal_value_peek_double (param_values + 4),
              g_marshal_value_peek_double (param_values + 5),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_slot,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_options,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectObjectUintFunc)
       (void *data1,
        GUnixFDList *arg_fd_list,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_serial,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectObjectUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectObjectUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_object (param_values + 2),
              g_marshal_value_peek_uint (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectObjectStringFunc)
       (void *data1,
        GUnixFDList *arg_fd_list,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_mime_type,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_object (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Mutter.RemoteDesktop
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MetaDBusRemoteDesktop
 * @title: MetaDBusRemoteDesktop
 * @short_description: Generated C code for the org.gnome.Mutter.RemoteDesktop D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop.top_of_page">org.gnome.Mutter.RemoteDesktop</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Mutter.RemoteDesktop ---- */

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_method_info_create_session_OUT_ARG_session_path =
{
  {
    -1,
    (gchar *) "session_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_remote_desktop_method_info_create_session_OUT_ARG_pointers[] =
{
  &_meta_dbus_remote_desktop_method_info_create_session_OUT_ARG_session_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_remote_desktop_method_info_create_session =
{
  {
    -1,
    (gchar *) "CreateSession",
    NULL,
    (GDBusArgInfo **) &_meta_dbus_remote_desktop_method_info_create_session_OUT_ARG_pointers,
    NULL
  },
  "handle-create-session",
  FALSE
};

static const GDBusMethodInfo * const _meta_dbus_remote_desktop_method_info_pointers[] =
{
  &_meta_dbus_remote_desktop_method_info_create_session.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_remote_desktop_property_info_supported_device_types =
{
  {
    -1,
    (gchar *) "SupportedDeviceTypes",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-device-types",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_remote_desktop_property_info_version =
{
  {
    -1,
    (gchar *) "Version",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _meta_dbus_remote_desktop_property_info_pointers[] =
{
  &_meta_dbus_remote_desktop_property_info_supported_device_types.parent_struct,
  &_meta_dbus_remote_desktop_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _meta_dbus_remote_desktop_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Mutter.RemoteDesktop",
    (GDBusMethodInfo **) &_meta_dbus_remote_desktop_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_meta_dbus_remote_desktop_property_info_pointers,
    NULL
  },
  "remote-desktop",
};


/**
 * meta_dbus_remote_desktop_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop.top_of_page">org.gnome.Mutter.RemoteDesktop</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
meta_dbus_remote_desktop_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_meta_dbus_remote_desktop_interface_info.parent_struct;
}

/**
 * meta_dbus_remote_desktop_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MetaDBusRemoteDesktop interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
meta_dbus_remote_desktop_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "supported-device-types");
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}


inline static void
meta_dbus_remote_desktop_method_marshal_create_session (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * MetaDBusRemoteDesktop:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop.top_of_page">org.gnome.Mutter.RemoteDesktop</link>.
 */

/**
 * MetaDBusRemoteDesktopIface:
 * @parent_iface: The parent interface.
 * @handle_create_session: Handler for the #MetaDBusRemoteDesktop::handle-create-session signal.
 * @get_supported_device_types: Getter for the #MetaDBusRemoteDesktop:supported-device-types property.
 * @get_version: Getter for the #MetaDBusRemoteDesktop:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop.top_of_page">org.gnome.Mutter.RemoteDesktop</link>.
 */

typedef MetaDBusRemoteDesktopIface MetaDBusRemoteDesktopInterface;
G_DEFINE_INTERFACE (MetaDBusRemoteDesktop, meta_dbus_remote_desktop, G_TYPE_OBJECT)

static void
meta_dbus_remote_desktop_default_init (MetaDBusRemoteDesktopIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MetaDBusRemoteDesktop::handle-create-session:
   * @object: A #MetaDBusRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop.CreateSession">CreateSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_remote_desktop_complete_create_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusRemoteDesktopIface, handle_create_session),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_remote_desktop_method_marshal_create_session,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject properties for D-Bus properties: */
  /**
   * MetaDBusRemoteDesktop:supported-device-types:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop.SupportedDeviceTypes">"SupportedDeviceTypes"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("supported-device-types", "SupportedDeviceTypes", "SupportedDeviceTypes", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusRemoteDesktop:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop.Version">"Version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("version", "Version", "Version", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * meta_dbus_remote_desktop_get_supported_device_types: (skip)
 * @object: A #MetaDBusRemoteDesktop.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop.SupportedDeviceTypes">"SupportedDeviceTypes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
meta_dbus_remote_desktop_get_supported_device_types (MetaDBusRemoteDesktop *object)
{
  g_return_val_if_fail (META_DBUS_IS_REMOTE_DESKTOP (object), 0);

  return META_DBUS_REMOTE_DESKTOP_GET_IFACE (object)->get_supported_device_types (object);
}

/**
 * meta_dbus_remote_desktop_set_supported_device_types: (skip)
 * @object: A #MetaDBusRemoteDesktop.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop.SupportedDeviceTypes">"SupportedDeviceTypes"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_remote_desktop_set_supported_device_types (MetaDBusRemoteDesktop *object, guint value)
{
  g_object_set (G_OBJECT (object), "supported-device-types", value, NULL);
}

/**
 * meta_dbus_remote_desktop_get_version: (skip)
 * @object: A #MetaDBusRemoteDesktop.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop.Version">"Version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
meta_dbus_remote_desktop_get_version (MetaDBusRemoteDesktop *object)
{
  g_return_val_if_fail (META_DBUS_IS_REMOTE_DESKTOP (object), 0);

  return META_DBUS_REMOTE_DESKTOP_GET_IFACE (object)->get_version (object);
}

/**
 * meta_dbus_remote_desktop_set_version: (skip)
 * @object: A #MetaDBusRemoteDesktop.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop.Version">"Version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_remote_desktop_set_version (MetaDBusRemoteDesktop *object, gint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * meta_dbus_remote_desktop_call_create_session:
 * @proxy: A #MetaDBusRemoteDesktopProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop.CreateSession">CreateSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_call_create_session_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_call_create_session_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_remote_desktop_call_create_session (
    MetaDBusRemoteDesktop *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_remote_desktop_call_create_session_finish:
 * @proxy: A #MetaDBusRemoteDesktopProxy.
 * @out_session_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_call_create_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_remote_desktop_call_create_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_call_create_session_finish (
    MetaDBusRemoteDesktop *proxy,
    gchar **out_session_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_session_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_call_create_session_sync:
 * @proxy: A #MetaDBusRemoteDesktopProxy.
 * @out_session_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop.CreateSession">CreateSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_call_create_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_call_create_session_sync (
    MetaDBusRemoteDesktop *proxy,
    gchar **out_session_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_session_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_complete_create_session:
 * @object: A #MetaDBusRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @session_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop.CreateSession">CreateSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_remote_desktop_complete_create_session (
    MetaDBusRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *session_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   session_path));
}

/* ------------------------------------------------------------------------ */

/**
 * MetaDBusRemoteDesktopProxy:
 *
 * The #MetaDBusRemoteDesktopProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDBusRemoteDesktopProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDBusRemoteDesktopProxy.
 */

struct _MetaDBusRemoteDesktopProxyPrivate
{
  GData *qdata;
};

static void meta_dbus_remote_desktop_proxy_iface_init (MetaDBusRemoteDesktopIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDBusRemoteDesktopProxy, meta_dbus_remote_desktop_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MetaDBusRemoteDesktopProxy)
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_REMOTE_DESKTOP, meta_dbus_remote_desktop_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDBusRemoteDesktopProxy, meta_dbus_remote_desktop_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_REMOTE_DESKTOP, meta_dbus_remote_desktop_proxy_iface_init))

#endif
static void
meta_dbus_remote_desktop_proxy_finalize (GObject *object)
{
  MetaDBusRemoteDesktopProxy *proxy = META_DBUS_REMOTE_DESKTOP_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (meta_dbus_remote_desktop_proxy_parent_class)->finalize (object);
}

static void
meta_dbus_remote_desktop_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _meta_dbus_remote_desktop_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
meta_dbus_remote_desktop_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Mutter.RemoteDesktop: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
meta_dbus_remote_desktop_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _meta_dbus_remote_desktop_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Mutter.RemoteDesktop", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) meta_dbus_remote_desktop_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
meta_dbus_remote_desktop_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_meta_dbus_remote_desktop_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], META_DBUS_TYPE_REMOTE_DESKTOP);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_TYPE_REMOTE_DESKTOP);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
meta_dbus_remote_desktop_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MetaDBusRemoteDesktopProxy *proxy = META_DBUS_REMOTE_DESKTOP_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_remote_desktop_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_remote_desktop_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
meta_dbus_remote_desktop_proxy_get_supported_device_types (MetaDBusRemoteDesktop *object)
{
  MetaDBusRemoteDesktopProxy *proxy = META_DBUS_REMOTE_DESKTOP_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SupportedDeviceTypes");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
meta_dbus_remote_desktop_proxy_get_version (MetaDBusRemoteDesktop *object)
{
  MetaDBusRemoteDesktopProxy *proxy = META_DBUS_REMOTE_DESKTOP_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Version");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
meta_dbus_remote_desktop_proxy_init (MetaDBusRemoteDesktopProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = meta_dbus_remote_desktop_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, META_DBUS_TYPE_REMOTE_DESKTOP_PROXY, MetaDBusRemoteDesktopProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), meta_dbus_remote_desktop_interface_info ());
}

static void
meta_dbus_remote_desktop_proxy_class_init (MetaDBusRemoteDesktopProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = meta_dbus_remote_desktop_proxy_finalize;
  gobject_class->get_property = meta_dbus_remote_desktop_proxy_get_property;
  gobject_class->set_property = meta_dbus_remote_desktop_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = meta_dbus_remote_desktop_proxy_g_signal;
  proxy_class->g_properties_changed = meta_dbus_remote_desktop_proxy_g_properties_changed;

  meta_dbus_remote_desktop_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDBusRemoteDesktopProxyPrivate));
#endif
}

static void
meta_dbus_remote_desktop_proxy_iface_init (MetaDBusRemoteDesktopIface *iface)
{
  iface->get_supported_device_types = meta_dbus_remote_desktop_proxy_get_supported_device_types;
  iface->get_version = meta_dbus_remote_desktop_proxy_get_version;
}

/**
 * meta_dbus_remote_desktop_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop.top_of_page">org.gnome.Mutter.RemoteDesktop</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_proxy_new_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_remote_desktop_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_TYPE_REMOTE_DESKTOP_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop", NULL);
}

/**
 * meta_dbus_remote_desktop_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_remote_desktop_proxy_new().
 *
 * Returns: (transfer full) (type MetaDBusRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusRemoteDesktop *
meta_dbus_remote_desktop_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_REMOTE_DESKTOP (ret);
  else
    return NULL;
}

/**
 * meta_dbus_remote_desktop_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop.top_of_page">org.gnome.Mutter.RemoteDesktop</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDBusRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusRemoteDesktop *
meta_dbus_remote_desktop_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_TYPE_REMOTE_DESKTOP_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop", NULL);
  if (ret != NULL)
    return META_DBUS_REMOTE_DESKTOP (ret);
  else
    return NULL;
}


/**
 * meta_dbus_remote_desktop_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like meta_dbus_remote_desktop_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_remote_desktop_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_TYPE_REMOTE_DESKTOP_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop", NULL);
}

/**
 * meta_dbus_remote_desktop_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_remote_desktop_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MetaDBusRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusRemoteDesktop *
meta_dbus_remote_desktop_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_REMOTE_DESKTOP (ret);
  else
    return NULL;
}

/**
 * meta_dbus_remote_desktop_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like meta_dbus_remote_desktop_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDBusRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusRemoteDesktop *
meta_dbus_remote_desktop_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_TYPE_REMOTE_DESKTOP_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop", NULL);
  if (ret != NULL)
    return META_DBUS_REMOTE_DESKTOP (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MetaDBusRemoteDesktopSkeleton:
 *
 * The #MetaDBusRemoteDesktopSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDBusRemoteDesktopSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDBusRemoteDesktopSkeleton.
 */

struct _MetaDBusRemoteDesktopSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_meta_dbus_remote_desktop_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MetaDBusRemoteDesktopSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], META_DBUS_TYPE_REMOTE_DESKTOP);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_TYPE_REMOTE_DESKTOP);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_meta_dbus_remote_desktop_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MetaDBusRemoteDesktopSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_remote_desktop_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_meta_dbus_remote_desktop_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MetaDBusRemoteDesktopSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_remote_desktop_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _meta_dbus_remote_desktop_skeleton_vtable =
{
  _meta_dbus_remote_desktop_skeleton_handle_method_call,
  _meta_dbus_remote_desktop_skeleton_handle_get_property,
  _meta_dbus_remote_desktop_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
meta_dbus_remote_desktop_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return meta_dbus_remote_desktop_interface_info ();
}

static GDBusInterfaceVTable *
meta_dbus_remote_desktop_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_meta_dbus_remote_desktop_skeleton_vtable;
}

static GVariant *
meta_dbus_remote_desktop_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MetaDBusRemoteDesktopSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_meta_dbus_remote_desktop_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _meta_dbus_remote_desktop_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _meta_dbus_remote_desktop_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _meta_dbus_remote_desktop_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.RemoteDesktop", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _meta_dbus_remote_desktop_emit_changed (gpointer user_data);

static void
meta_dbus_remote_desktop_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MetaDBusRemoteDesktopSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _meta_dbus_remote_desktop_emit_changed (skeleton);
}

static void meta_dbus_remote_desktop_skeleton_iface_init (MetaDBusRemoteDesktopIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDBusRemoteDesktopSkeleton, meta_dbus_remote_desktop_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MetaDBusRemoteDesktopSkeleton)
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_REMOTE_DESKTOP, meta_dbus_remote_desktop_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDBusRemoteDesktopSkeleton, meta_dbus_remote_desktop_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_REMOTE_DESKTOP, meta_dbus_remote_desktop_skeleton_iface_init))

#endif
static void
meta_dbus_remote_desktop_skeleton_finalize (GObject *object)
{
  MetaDBusRemoteDesktopSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (meta_dbus_remote_desktop_skeleton_parent_class)->finalize (object);
}

static void
meta_dbus_remote_desktop_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MetaDBusRemoteDesktopSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_meta_dbus_remote_desktop_emit_changed (gpointer user_data)
{
  MetaDBusRemoteDesktopSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Mutter.RemoteDesktop",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_meta_dbus_remote_desktop_schedule_emit_changed (MetaDBusRemoteDesktopSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
meta_dbus_remote_desktop_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MetaDBusRemoteDesktopSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _meta_dbus_remote_desktop_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _meta_dbus_remote_desktop_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
meta_dbus_remote_desktop_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MetaDBusRemoteDesktopSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _meta_dbus_remote_desktop_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _meta_dbus_remote_desktop_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
meta_dbus_remote_desktop_skeleton_init (MetaDBusRemoteDesktopSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = meta_dbus_remote_desktop_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, META_DBUS_TYPE_REMOTE_DESKTOP_SKELETON, MetaDBusRemoteDesktopSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_INT);
}

static guint 
meta_dbus_remote_desktop_skeleton_get_supported_device_types (MetaDBusRemoteDesktop *object)
{
  MetaDBusRemoteDesktopSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
meta_dbus_remote_desktop_skeleton_get_version (MetaDBusRemoteDesktop *object)
{
  MetaDBusRemoteDesktopSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
meta_dbus_remote_desktop_skeleton_class_init (MetaDBusRemoteDesktopSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = meta_dbus_remote_desktop_skeleton_finalize;
  gobject_class->get_property = meta_dbus_remote_desktop_skeleton_get_property;
  gobject_class->set_property = meta_dbus_remote_desktop_skeleton_set_property;
  gobject_class->notify       = meta_dbus_remote_desktop_skeleton_notify;


  meta_dbus_remote_desktop_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = meta_dbus_remote_desktop_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = meta_dbus_remote_desktop_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = meta_dbus_remote_desktop_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = meta_dbus_remote_desktop_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDBusRemoteDesktopSkeletonPrivate));
#endif
}

static void
meta_dbus_remote_desktop_skeleton_iface_init (MetaDBusRemoteDesktopIface *iface)
{
  iface->get_supported_device_types = meta_dbus_remote_desktop_skeleton_get_supported_device_types;
  iface->get_version = meta_dbus_remote_desktop_skeleton_get_version;
}

/**
 * meta_dbus_remote_desktop_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop.top_of_page">org.gnome.Mutter.RemoteDesktop</link>.
 *
 * Returns: (transfer full) (type MetaDBusRemoteDesktopSkeleton): The skeleton object.
 */
MetaDBusRemoteDesktop *
meta_dbus_remote_desktop_skeleton_new (void)
{
  return META_DBUS_REMOTE_DESKTOP (g_object_new (META_DBUS_TYPE_REMOTE_DESKTOP_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Mutter.RemoteDesktop.Session
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MetaDBusRemoteDesktopSession
 * @title: MetaDBusRemoteDesktopSession
 * @short_description: Generated C code for the org.gnome.Mutter.RemoteDesktop.Session D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop-Session.top_of_page">org.gnome.Mutter.RemoteDesktop.Session</link> D-Bus interface in C.
 */

enum
{
  META_DBUS__REMOTE_DESKTOP_SESSION_CLOSED,
  META_DBUS__REMOTE_DESKTOP_SESSION_SELECTION_OWNER_CHANGED,
  META_DBUS__REMOTE_DESKTOP_SESSION_SELECTION_TRANSFER,
};

static unsigned META_DBUS__REMOTE_DESKTOP_SESSION_SIGNALS[3] = { 0 };

/* ---- Introspection data for org.gnome.Mutter.RemoteDesktop.Session ---- */

static const _ExtendedGDBusMethodInfo _meta_dbus_remote_desktop_session_method_info_start =
{
  {
    -1,
    (gchar *) "Start",
    NULL,
    NULL,
    NULL
  },
  "handle-start",
  FALSE
};

static const _ExtendedGDBusMethodInfo _meta_dbus_remote_desktop_session_method_info_stop =
{
  {
    -1,
    (gchar *) "Stop",
    NULL,
    NULL,
    NULL
  },
  "handle-stop",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_keyboard_keycode_IN_ARG_keycode =
{
  {
    -1,
    (gchar *) "keycode",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_keyboard_keycode_IN_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_remote_desktop_session_method_info_notify_keyboard_keycode_IN_ARG_pointers[] =
{
  &_meta_dbus_remote_desktop_session_method_info_notify_keyboard_keycode_IN_ARG_keycode.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_keyboard_keycode_IN_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_remote_desktop_session_method_info_notify_keyboard_keycode =
{
  {
    -1,
    (gchar *) "NotifyKeyboardKeycode",
    (GDBusArgInfo **) &_meta_dbus_remote_desktop_session_method_info_notify_keyboard_keycode_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-keyboard-keycode",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_keyboard_keysym_IN_ARG_keysym =
{
  {
    -1,
    (gchar *) "keysym",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_keyboard_keysym_IN_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_remote_desktop_session_method_info_notify_keyboard_keysym_IN_ARG_pointers[] =
{
  &_meta_dbus_remote_desktop_session_method_info_notify_keyboard_keysym_IN_ARG_keysym.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_keyboard_keysym_IN_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_remote_desktop_session_method_info_notify_keyboard_keysym =
{
  {
    -1,
    (gchar *) "NotifyKeyboardKeysym",
    (GDBusArgInfo **) &_meta_dbus_remote_desktop_session_method_info_notify_keyboard_keysym_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-keyboard-keysym",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_pointer_button_IN_ARG_button =
{
  {
    -1,
    (gchar *) "button",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_pointer_button_IN_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_remote_desktop_session_method_info_notify_pointer_button_IN_ARG_pointers[] =
{
  &_meta_dbus_remote_desktop_session_method_info_notify_pointer_button_IN_ARG_button.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_pointer_button_IN_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_remote_desktop_session_method_info_notify_pointer_button =
{
  {
    -1,
    (gchar *) "NotifyPointerButton",
    (GDBusArgInfo **) &_meta_dbus_remote_desktop_session_method_info_notify_pointer_button_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-button",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_dx =
{
  {
    -1,
    (gchar *) "dx",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_dy =
{
  {
    -1,
    (gchar *) "dy",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_pointers[] =
{
  &_meta_dbus_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_dx.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_dy.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_remote_desktop_session_method_info_notify_pointer_axis =
{
  {
    -1,
    (gchar *) "NotifyPointerAxis",
    (GDBusArgInfo **) &_meta_dbus_remote_desktop_session_method_info_notify_pointer_axis_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-axis",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_pointer_axis_discrete_IN_ARG_axis =
{
  {
    -1,
    (gchar *) "axis",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_pointer_axis_discrete_IN_ARG_steps =
{
  {
    -1,
    (gchar *) "steps",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_remote_desktop_session_method_info_notify_pointer_axis_discrete_IN_ARG_pointers[] =
{
  &_meta_dbus_remote_desktop_session_method_info_notify_pointer_axis_discrete_IN_ARG_axis.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_pointer_axis_discrete_IN_ARG_steps.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_remote_desktop_session_method_info_notify_pointer_axis_discrete =
{
  {
    -1,
    (gchar *) "NotifyPointerAxisDiscrete",
    (GDBusArgInfo **) &_meta_dbus_remote_desktop_session_method_info_notify_pointer_axis_discrete_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-axis-discrete",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_pointer_motion_relative_IN_ARG_dx =
{
  {
    -1,
    (gchar *) "dx",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_pointer_motion_relative_IN_ARG_dy =
{
  {
    -1,
    (gchar *) "dy",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_remote_desktop_session_method_info_notify_pointer_motion_relative_IN_ARG_pointers[] =
{
  &_meta_dbus_remote_desktop_session_method_info_notify_pointer_motion_relative_IN_ARG_dx.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_pointer_motion_relative_IN_ARG_dy.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_remote_desktop_session_method_info_notify_pointer_motion_relative =
{
  {
    -1,
    (gchar *) "NotifyPointerMotionRelative",
    (GDBusArgInfo **) &_meta_dbus_remote_desktop_session_method_info_notify_pointer_motion_relative_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-motion-relative",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_stream =
{
  {
    -1,
    (gchar *) "stream",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_pointers[] =
{
  &_meta_dbus_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_stream.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_x.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_y.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_remote_desktop_session_method_info_notify_pointer_motion_absolute =
{
  {
    -1,
    (gchar *) "NotifyPointerMotionAbsolute",
    (GDBusArgInfo **) &_meta_dbus_remote_desktop_session_method_info_notify_pointer_motion_absolute_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-motion-absolute",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_touch_down_IN_ARG_stream =
{
  {
    -1,
    (gchar *) "stream",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_touch_down_IN_ARG_slot =
{
  {
    -1,
    (gchar *) "slot",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_touch_down_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_touch_down_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_remote_desktop_session_method_info_notify_touch_down_IN_ARG_pointers[] =
{
  &_meta_dbus_remote_desktop_session_method_info_notify_touch_down_IN_ARG_stream.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_touch_down_IN_ARG_slot.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_touch_down_IN_ARG_x.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_touch_down_IN_ARG_y.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_remote_desktop_session_method_info_notify_touch_down =
{
  {
    -1,
    (gchar *) "NotifyTouchDown",
    (GDBusArgInfo **) &_meta_dbus_remote_desktop_session_method_info_notify_touch_down_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-touch-down",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_stream =
{
  {
    -1,
    (gchar *) "stream",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_slot =
{
  {
    -1,
    (gchar *) "slot",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_pointers[] =
{
  &_meta_dbus_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_stream.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_slot.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_x.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_y.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_remote_desktop_session_method_info_notify_touch_motion =
{
  {
    -1,
    (gchar *) "NotifyTouchMotion",
    (GDBusArgInfo **) &_meta_dbus_remote_desktop_session_method_info_notify_touch_motion_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-touch-motion",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_notify_touch_up_IN_ARG_slot =
{
  {
    -1,
    (gchar *) "slot",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_remote_desktop_session_method_info_notify_touch_up_IN_ARG_pointers[] =
{
  &_meta_dbus_remote_desktop_session_method_info_notify_touch_up_IN_ARG_slot.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_remote_desktop_session_method_info_notify_touch_up =
{
  {
    -1,
    (gchar *) "NotifyTouchUp",
    (GDBusArgInfo **) &_meta_dbus_remote_desktop_session_method_info_notify_touch_up_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-touch-up",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_enable_clipboard_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_remote_desktop_session_method_info_enable_clipboard_IN_ARG_pointers[] =
{
  &_meta_dbus_remote_desktop_session_method_info_enable_clipboard_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_remote_desktop_session_method_info_enable_clipboard =
{
  {
    -1,
    (gchar *) "EnableClipboard",
    (GDBusArgInfo **) &_meta_dbus_remote_desktop_session_method_info_enable_clipboard_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-enable-clipboard",
  FALSE
};

static const _ExtendedGDBusMethodInfo _meta_dbus_remote_desktop_session_method_info_disable_clipboard =
{
  {
    -1,
    (gchar *) "DisableClipboard",
    NULL,
    NULL,
    NULL
  },
  "handle-disable-clipboard",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_set_selection_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_remote_desktop_session_method_info_set_selection_IN_ARG_pointers[] =
{
  &_meta_dbus_remote_desktop_session_method_info_set_selection_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_remote_desktop_session_method_info_set_selection =
{
  {
    -1,
    (gchar *) "SetSelection",
    (GDBusArgInfo **) &_meta_dbus_remote_desktop_session_method_info_set_selection_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-selection",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_selection_write_IN_ARG_serial =
{
  {
    -1,
    (gchar *) "serial",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_remote_desktop_session_method_info_selection_write_IN_ARG_pointers[] =
{
  &_meta_dbus_remote_desktop_session_method_info_selection_write_IN_ARG_serial.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_selection_write_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_remote_desktop_session_method_info_selection_write_OUT_ARG_pointers[] =
{
  &_meta_dbus_remote_desktop_session_method_info_selection_write_OUT_ARG_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_remote_desktop_session_method_info_selection_write =
{
  {
    -1,
    (gchar *) "SelectionWrite",
    (GDBusArgInfo **) &_meta_dbus_remote_desktop_session_method_info_selection_write_IN_ARG_pointers,
    (GDBusArgInfo **) &_meta_dbus_remote_desktop_session_method_info_selection_write_OUT_ARG_pointers,
    NULL
  },
  "handle-selection-write",
  TRUE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_selection_write_done_IN_ARG_serial =
{
  {
    -1,
    (gchar *) "serial",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_selection_write_done_IN_ARG_success =
{
  {
    -1,
    (gchar *) "success",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_remote_desktop_session_method_info_selection_write_done_IN_ARG_pointers[] =
{
  &_meta_dbus_remote_desktop_session_method_info_selection_write_done_IN_ARG_serial.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_selection_write_done_IN_ARG_success.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_remote_desktop_session_method_info_selection_write_done =
{
  {
    -1,
    (gchar *) "SelectionWriteDone",
    (GDBusArgInfo **) &_meta_dbus_remote_desktop_session_method_info_selection_write_done_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-selection-write-done",
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_selection_read_IN_ARG_mime_type =
{
  {
    -1,
    (gchar *) "mime_type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_remote_desktop_session_method_info_selection_read_IN_ARG_pointers[] =
{
  &_meta_dbus_remote_desktop_session_method_info_selection_read_IN_ARG_mime_type.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_method_info_selection_read_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_remote_desktop_session_method_info_selection_read_OUT_ARG_pointers[] =
{
  &_meta_dbus_remote_desktop_session_method_info_selection_read_OUT_ARG_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _meta_dbus_remote_desktop_session_method_info_selection_read =
{
  {
    -1,
    (gchar *) "SelectionRead",
    (GDBusArgInfo **) &_meta_dbus_remote_desktop_session_method_info_selection_read_IN_ARG_pointers,
    (GDBusArgInfo **) &_meta_dbus_remote_desktop_session_method_info_selection_read_OUT_ARG_pointers,
    NULL
  },
  "handle-selection-read",
  TRUE
};

static const GDBusMethodInfo * const _meta_dbus_remote_desktop_session_method_info_pointers[] =
{
  &_meta_dbus_remote_desktop_session_method_info_start.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_stop.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_keyboard_keycode.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_keyboard_keysym.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_pointer_button.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_pointer_axis.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_pointer_axis_discrete.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_pointer_motion_relative.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_pointer_motion_absolute.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_touch_down.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_touch_motion.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_notify_touch_up.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_enable_clipboard.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_disable_clipboard.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_set_selection.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_selection_write.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_selection_write_done.parent_struct,
  &_meta_dbus_remote_desktop_session_method_info_selection_read.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _meta_dbus_remote_desktop_session_signal_info_closed =
{
  {
    -1,
    (gchar *) "Closed",
    NULL,
    NULL
  },
  "closed"
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_signal_info_selection_owner_changed_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_remote_desktop_session_signal_info_selection_owner_changed_ARG_pointers[] =
{
  &_meta_dbus_remote_desktop_session_signal_info_selection_owner_changed_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _meta_dbus_remote_desktop_session_signal_info_selection_owner_changed =
{
  {
    -1,
    (gchar *) "SelectionOwnerChanged",
    (GDBusArgInfo **) &_meta_dbus_remote_desktop_session_signal_info_selection_owner_changed_ARG_pointers,
    NULL
  },
  "selection-owner-changed"
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_signal_info_selection_transfer_ARG_mime_type =
{
  {
    -1,
    (gchar *) "mime_type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _meta_dbus_remote_desktop_session_signal_info_selection_transfer_ARG_serial =
{
  {
    -1,
    (gchar *) "serial",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _meta_dbus_remote_desktop_session_signal_info_selection_transfer_ARG_pointers[] =
{
  &_meta_dbus_remote_desktop_session_signal_info_selection_transfer_ARG_mime_type.parent_struct,
  &_meta_dbus_remote_desktop_session_signal_info_selection_transfer_ARG_serial.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _meta_dbus_remote_desktop_session_signal_info_selection_transfer =
{
  {
    -1,
    (gchar *) "SelectionTransfer",
    (GDBusArgInfo **) &_meta_dbus_remote_desktop_session_signal_info_selection_transfer_ARG_pointers,
    NULL
  },
  "selection-transfer"
};

static const GDBusSignalInfo * const _meta_dbus_remote_desktop_session_signal_info_pointers[] =
{
  &_meta_dbus_remote_desktop_session_signal_info_closed.parent_struct,
  &_meta_dbus_remote_desktop_session_signal_info_selection_owner_changed.parent_struct,
  &_meta_dbus_remote_desktop_session_signal_info_selection_transfer.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_remote_desktop_session_property_info_session_id =
{
  {
    -1,
    (gchar *) "SessionId",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "session-id",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_remote_desktop_session_property_info_caps_lock_state =
{
  {
    -1,
    (gchar *) "CapsLockState",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "caps-lock-state",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _meta_dbus_remote_desktop_session_property_info_num_lock_state =
{
  {
    -1,
    (gchar *) "NumLockState",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "num-lock-state",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _meta_dbus_remote_desktop_session_property_info_pointers[] =
{
  &_meta_dbus_remote_desktop_session_property_info_session_id.parent_struct,
  &_meta_dbus_remote_desktop_session_property_info_caps_lock_state.parent_struct,
  &_meta_dbus_remote_desktop_session_property_info_num_lock_state.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _meta_dbus_remote_desktop_session_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Mutter.RemoteDesktop.Session",
    (GDBusMethodInfo **) &_meta_dbus_remote_desktop_session_method_info_pointers,
    (GDBusSignalInfo **) &_meta_dbus_remote_desktop_session_signal_info_pointers,
    (GDBusPropertyInfo **) &_meta_dbus_remote_desktop_session_property_info_pointers,
    NULL
  },
  "remote-desktop-session",
};


/**
 * meta_dbus_remote_desktop_session_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop-Session.top_of_page">org.gnome.Mutter.RemoteDesktop.Session</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
meta_dbus_remote_desktop_session_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_meta_dbus_remote_desktop_session_interface_info.parent_struct;
}

/**
 * meta_dbus_remote_desktop_session_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MetaDBusRemoteDesktopSession interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
meta_dbus_remote_desktop_session_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "session-id");
  g_object_class_override_property (klass, property_id_begin++, "caps-lock-state");
  g_object_class_override_property (klass, property_id_begin++, "num-lock-state");
  return property_id_begin - 1;
}


inline static void
meta_dbus_remote_desktop_session_signal_marshal_closed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_remote_desktop_session_signal_marshal_selection_owner_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_remote_desktop_session_signal_marshal_selection_transfer (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_remote_desktop_session_method_marshal_start (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_remote_desktop_session_method_marshal_stop (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_remote_desktop_session_method_marshal_notify_keyboard_keycode (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_remote_desktop_session_method_marshal_notify_keyboard_keysym (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_remote_desktop_session_method_marshal_notify_pointer_button (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_remote_desktop_session_method_marshal_notify_pointer_axis (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_DOUBLE_DOUBLE_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_remote_desktop_session_method_marshal_notify_pointer_axis_discrete (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_remote_desktop_session_method_marshal_notify_pointer_motion_relative (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_DOUBLE_DOUBLE (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_remote_desktop_session_method_marshal_notify_pointer_motion_absolute (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_DOUBLE_DOUBLE (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_remote_desktop_session_method_marshal_notify_touch_down (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_UINT_DOUBLE_DOUBLE (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_remote_desktop_session_method_marshal_notify_touch_motion (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_UINT_DOUBLE_DOUBLE (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_remote_desktop_session_method_marshal_notify_touch_up (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_remote_desktop_session_method_marshal_enable_clipboard (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_remote_desktop_session_method_marshal_disable_clipboard (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_remote_desktop_session_method_marshal_set_selection (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_remote_desktop_session_method_marshal_selection_write (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_remote_desktop_session_method_marshal_selection_write_done (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
meta_dbus_remote_desktop_session_method_marshal_selection_read (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * MetaDBusRemoteDesktopSession:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop-Session.top_of_page">org.gnome.Mutter.RemoteDesktop.Session</link>.
 */

/**
 * MetaDBusRemoteDesktopSessionIface:
 * @parent_iface: The parent interface.
 * @handle_disable_clipboard: Handler for the #MetaDBusRemoteDesktopSession::handle-disable-clipboard signal.
 * @handle_enable_clipboard: Handler for the #MetaDBusRemoteDesktopSession::handle-enable-clipboard signal.
 * @handle_notify_keyboard_keycode: Handler for the #MetaDBusRemoteDesktopSession::handle-notify-keyboard-keycode signal.
 * @handle_notify_keyboard_keysym: Handler for the #MetaDBusRemoteDesktopSession::handle-notify-keyboard-keysym signal.
 * @handle_notify_pointer_axis: Handler for the #MetaDBusRemoteDesktopSession::handle-notify-pointer-axis signal.
 * @handle_notify_pointer_axis_discrete: Handler for the #MetaDBusRemoteDesktopSession::handle-notify-pointer-axis-discrete signal.
 * @handle_notify_pointer_button: Handler for the #MetaDBusRemoteDesktopSession::handle-notify-pointer-button signal.
 * @handle_notify_pointer_motion_absolute: Handler for the #MetaDBusRemoteDesktopSession::handle-notify-pointer-motion-absolute signal.
 * @handle_notify_pointer_motion_relative: Handler for the #MetaDBusRemoteDesktopSession::handle-notify-pointer-motion-relative signal.
 * @handle_notify_touch_down: Handler for the #MetaDBusRemoteDesktopSession::handle-notify-touch-down signal.
 * @handle_notify_touch_motion: Handler for the #MetaDBusRemoteDesktopSession::handle-notify-touch-motion signal.
 * @handle_notify_touch_up: Handler for the #MetaDBusRemoteDesktopSession::handle-notify-touch-up signal.
 * @handle_selection_read: Handler for the #MetaDBusRemoteDesktopSession::handle-selection-read signal.
 * @handle_selection_write: Handler for the #MetaDBusRemoteDesktopSession::handle-selection-write signal.
 * @handle_selection_write_done: Handler for the #MetaDBusRemoteDesktopSession::handle-selection-write-done signal.
 * @handle_set_selection: Handler for the #MetaDBusRemoteDesktopSession::handle-set-selection signal.
 * @handle_start: Handler for the #MetaDBusRemoteDesktopSession::handle-start signal.
 * @handle_stop: Handler for the #MetaDBusRemoteDesktopSession::handle-stop signal.
 * @get_caps_lock_state: Getter for the #MetaDBusRemoteDesktopSession:caps-lock-state property.
 * @get_num_lock_state: Getter for the #MetaDBusRemoteDesktopSession:num-lock-state property.
 * @get_session_id: Getter for the #MetaDBusRemoteDesktopSession:session-id property.
 * @closed: Handler for the #MetaDBusRemoteDesktopSession::closed signal.
 * @selection_owner_changed: Handler for the #MetaDBusRemoteDesktopSession::selection-owner-changed signal.
 * @selection_transfer: Handler for the #MetaDBusRemoteDesktopSession::selection-transfer signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop-Session.top_of_page">org.gnome.Mutter.RemoteDesktop.Session</link>.
 */

typedef MetaDBusRemoteDesktopSessionIface MetaDBusRemoteDesktopSessionInterface;
G_DEFINE_INTERFACE (MetaDBusRemoteDesktopSession, meta_dbus_remote_desktop_session, G_TYPE_OBJECT)

static void
meta_dbus_remote_desktop_session_default_init (MetaDBusRemoteDesktopSessionIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MetaDBusRemoteDesktopSession::handle-start:
   * @object: A #MetaDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Start">Start()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_remote_desktop_session_complete_start() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusRemoteDesktopSessionIface, handle_start),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_remote_desktop_session_method_marshal_start,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusRemoteDesktopSession::handle-stop:
   * @object: A #MetaDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Stop">Stop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_remote_desktop_session_complete_stop() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusRemoteDesktopSessionIface, handle_stop),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_remote_desktop_session_method_marshal_stop,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusRemoteDesktopSession::handle-notify-keyboard-keycode:
   * @object: A #MetaDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_keycode: Argument passed by remote caller.
   * @arg_state: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeycode">NotifyKeyboardKeycode()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_remote_desktop_session_complete_notify_keyboard_keycode() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-keyboard-keycode",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusRemoteDesktopSessionIface, handle_notify_keyboard_keycode),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_remote_desktop_session_method_marshal_notify_keyboard_keycode,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_BOOLEAN);

  /**
   * MetaDBusRemoteDesktopSession::handle-notify-keyboard-keysym:
   * @object: A #MetaDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_keysym: Argument passed by remote caller.
   * @arg_state: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeysym">NotifyKeyboardKeysym()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_remote_desktop_session_complete_notify_keyboard_keysym() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-keyboard-keysym",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusRemoteDesktopSessionIface, handle_notify_keyboard_keysym),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_remote_desktop_session_method_marshal_notify_keyboard_keysym,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_BOOLEAN);

  /**
   * MetaDBusRemoteDesktopSession::handle-notify-pointer-button:
   * @object: A #MetaDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_button: Argument passed by remote caller.
   * @arg_state: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerButton">NotifyPointerButton()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_remote_desktop_session_complete_notify_pointer_button() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-button",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusRemoteDesktopSessionIface, handle_notify_pointer_button),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_remote_desktop_session_method_marshal_notify_pointer_button,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_BOOLEAN);

  /**
   * MetaDBusRemoteDesktopSession::handle-notify-pointer-axis:
   * @object: A #MetaDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_dx: Argument passed by remote caller.
   * @arg_dy: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxis">NotifyPointerAxis()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_remote_desktop_session_complete_notify_pointer_axis() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-axis",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusRemoteDesktopSessionIface, handle_notify_pointer_axis),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_remote_desktop_session_method_marshal_notify_pointer_axis,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_DOUBLE, G_TYPE_DOUBLE, G_TYPE_UINT);

  /**
   * MetaDBusRemoteDesktopSession::handle-notify-pointer-axis-discrete:
   * @object: A #MetaDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_axis: Argument passed by remote caller.
   * @arg_steps: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxisDiscrete">NotifyPointerAxisDiscrete()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_remote_desktop_session_complete_notify_pointer_axis_discrete() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-axis-discrete",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusRemoteDesktopSessionIface, handle_notify_pointer_axis_discrete),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_remote_desktop_session_method_marshal_notify_pointer_axis_discrete,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_INT);

  /**
   * MetaDBusRemoteDesktopSession::handle-notify-pointer-motion-relative:
   * @object: A #MetaDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_dx: Argument passed by remote caller.
   * @arg_dy: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionRelative">NotifyPointerMotionRelative()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_remote_desktop_session_complete_notify_pointer_motion_relative() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-motion-relative",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusRemoteDesktopSessionIface, handle_notify_pointer_motion_relative),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_remote_desktop_session_method_marshal_notify_pointer_motion_relative,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  /**
   * MetaDBusRemoteDesktopSession::handle-notify-pointer-motion-absolute:
   * @object: A #MetaDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_stream: Argument passed by remote caller.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionAbsolute">NotifyPointerMotionAbsolute()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_remote_desktop_session_complete_notify_pointer_motion_absolute() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-motion-absolute",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusRemoteDesktopSessionIface, handle_notify_pointer_motion_absolute),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_remote_desktop_session_method_marshal_notify_pointer_motion_absolute,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  /**
   * MetaDBusRemoteDesktopSession::handle-notify-touch-down:
   * @object: A #MetaDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_stream: Argument passed by remote caller.
   * @arg_slot: Argument passed by remote caller.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchDown">NotifyTouchDown()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_remote_desktop_session_complete_notify_touch_down() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-touch-down",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusRemoteDesktopSessionIface, handle_notify_touch_down),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_remote_desktop_session_method_marshal_notify_touch_down,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  /**
   * MetaDBusRemoteDesktopSession::handle-notify-touch-motion:
   * @object: A #MetaDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_stream: Argument passed by remote caller.
   * @arg_slot: Argument passed by remote caller.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchMotion">NotifyTouchMotion()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_remote_desktop_session_complete_notify_touch_motion() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-touch-motion",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusRemoteDesktopSessionIface, handle_notify_touch_motion),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_remote_desktop_session_method_marshal_notify_touch_motion,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  /**
   * MetaDBusRemoteDesktopSession::handle-notify-touch-up:
   * @object: A #MetaDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_slot: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchUp">NotifyTouchUp()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_remote_desktop_session_complete_notify_touch_up() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-touch-up",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusRemoteDesktopSessionIface, handle_notify_touch_up),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_remote_desktop_session_method_marshal_notify_touch_up,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * MetaDBusRemoteDesktopSession::handle-enable-clipboard:
   * @object: A #MetaDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.EnableClipboard">EnableClipboard()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_remote_desktop_session_complete_enable_clipboard() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-enable-clipboard",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusRemoteDesktopSessionIface, handle_enable_clipboard),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_remote_desktop_session_method_marshal_enable_clipboard,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * MetaDBusRemoteDesktopSession::handle-disable-clipboard:
   * @object: A #MetaDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.DisableClipboard">DisableClipboard()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_remote_desktop_session_complete_disable_clipboard() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-disable-clipboard",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusRemoteDesktopSessionIface, handle_disable_clipboard),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_remote_desktop_session_method_marshal_disable_clipboard,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MetaDBusRemoteDesktopSession::handle-set-selection:
   * @object: A #MetaDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SetSelection">SetSelection()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_remote_desktop_session_complete_set_selection() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-selection",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusRemoteDesktopSessionIface, handle_set_selection),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_remote_desktop_session_method_marshal_set_selection,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * MetaDBusRemoteDesktopSession::handle-selection-write:
   * @object: A #MetaDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_serial: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionWrite">SelectionWrite()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_remote_desktop_session_complete_selection_write() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-selection-write",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusRemoteDesktopSessionIface, handle_selection_write),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_remote_desktop_session_method_marshal_selection_write,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_UINT);

  /**
   * MetaDBusRemoteDesktopSession::handle-selection-write-done:
   * @object: A #MetaDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_serial: Argument passed by remote caller.
   * @arg_success: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionWriteDone">SelectionWriteDone()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_remote_desktop_session_complete_selection_write_done() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-selection-write-done",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusRemoteDesktopSessionIface, handle_selection_write_done),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_remote_desktop_session_method_marshal_selection_write_done,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_BOOLEAN);

  /**
   * MetaDBusRemoteDesktopSession::handle-selection-read:
   * @object: A #MetaDBusRemoteDesktopSession.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_mime_type: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionRead">SelectionRead()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call meta_dbus_remote_desktop_session_complete_selection_read() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-selection-read",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MetaDBusRemoteDesktopSessionIface, handle_selection_read),
    g_signal_accumulator_true_handled,
    NULL,
      meta_dbus_remote_desktop_session_method_marshal_selection_read,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * MetaDBusRemoteDesktopSession::closed:
   * @object: A #MetaDBusRemoteDesktopSession.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Mutter-RemoteDesktop-Session.Closed">"Closed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__REMOTE_DESKTOP_SESSION_SIGNALS[META_DBUS__REMOTE_DESKTOP_SESSION_CLOSED] =
    g_signal_new ("closed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusRemoteDesktopSessionIface, closed),
      NULL,
      NULL,
      meta_dbus_remote_desktop_session_signal_marshal_closed,
      G_TYPE_NONE,
      0);

  /**
   * MetaDBusRemoteDesktopSession::selection-owner-changed:
   * @object: A #MetaDBusRemoteDesktopSession.
   * @arg_options: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Mutter-RemoteDesktop-Session.SelectionOwnerChanged">"SelectionOwnerChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__REMOTE_DESKTOP_SESSION_SIGNALS[META_DBUS__REMOTE_DESKTOP_SESSION_SELECTION_OWNER_CHANGED] =
    g_signal_new ("selection-owner-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusRemoteDesktopSessionIface, selection_owner_changed),
      NULL,
      NULL,
      meta_dbus_remote_desktop_session_signal_marshal_selection_owner_changed,
      G_TYPE_NONE,
      1, G_TYPE_VARIANT);

  /**
   * MetaDBusRemoteDesktopSession::selection-transfer:
   * @object: A #MetaDBusRemoteDesktopSession.
   * @arg_mime_type: Argument.
   * @arg_serial: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Mutter-RemoteDesktop-Session.SelectionTransfer">"SelectionTransfer"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  META_DBUS__REMOTE_DESKTOP_SESSION_SIGNALS[META_DBUS__REMOTE_DESKTOP_SESSION_SELECTION_TRANSFER] =
    g_signal_new ("selection-transfer",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MetaDBusRemoteDesktopSessionIface, selection_transfer),
      NULL,
      NULL,
      meta_dbus_remote_desktop_session_signal_marshal_selection_transfer,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * MetaDBusRemoteDesktopSession:session-id:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.SessionId">"SessionId"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("session-id", "SessionId", "SessionId", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusRemoteDesktopSession:caps-lock-state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.CapsLockState">"CapsLockState"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("caps-lock-state", "CapsLockState", "CapsLockState", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MetaDBusRemoteDesktopSession:num-lock-state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.NumLockState">"NumLockState"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("num-lock-state", "NumLockState", "NumLockState", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * meta_dbus_remote_desktop_session_get_session_id: (skip)
 * @object: A #MetaDBusRemoteDesktopSession.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.SessionId">"SessionId"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use meta_dbus_remote_desktop_session_dup_session_id() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
meta_dbus_remote_desktop_session_get_session_id (MetaDBusRemoteDesktopSession *object)
{
  g_return_val_if_fail (META_DBUS_IS_REMOTE_DESKTOP_SESSION (object), NULL);

  return META_DBUS_REMOTE_DESKTOP_SESSION_GET_IFACE (object)->get_session_id (object);
}

/**
 * meta_dbus_remote_desktop_session_dup_session_id: (skip)
 * @object: A #MetaDBusRemoteDesktopSession.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.SessionId">"SessionId"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
meta_dbus_remote_desktop_session_dup_session_id (MetaDBusRemoteDesktopSession *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "session-id", &value, NULL);
  return value;
}

/**
 * meta_dbus_remote_desktop_session_set_session_id: (skip)
 * @object: A #MetaDBusRemoteDesktopSession.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.SessionId">"SessionId"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_remote_desktop_session_set_session_id (MetaDBusRemoteDesktopSession *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "session-id", value, NULL);
}

/**
 * meta_dbus_remote_desktop_session_get_caps_lock_state: (skip)
 * @object: A #MetaDBusRemoteDesktopSession.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.CapsLockState">"CapsLockState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
meta_dbus_remote_desktop_session_get_caps_lock_state (MetaDBusRemoteDesktopSession *object)
{
  g_return_val_if_fail (META_DBUS_IS_REMOTE_DESKTOP_SESSION (object), FALSE);

  return META_DBUS_REMOTE_DESKTOP_SESSION_GET_IFACE (object)->get_caps_lock_state (object);
}

/**
 * meta_dbus_remote_desktop_session_set_caps_lock_state: (skip)
 * @object: A #MetaDBusRemoteDesktopSession.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.CapsLockState">"CapsLockState"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_remote_desktop_session_set_caps_lock_state (MetaDBusRemoteDesktopSession *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "caps-lock-state", value, NULL);
}

/**
 * meta_dbus_remote_desktop_session_get_num_lock_state: (skip)
 * @object: A #MetaDBusRemoteDesktopSession.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.NumLockState">"NumLockState"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
meta_dbus_remote_desktop_session_get_num_lock_state (MetaDBusRemoteDesktopSession *object)
{
  g_return_val_if_fail (META_DBUS_IS_REMOTE_DESKTOP_SESSION (object), FALSE);

  return META_DBUS_REMOTE_DESKTOP_SESSION_GET_IFACE (object)->get_num_lock_state (object);
}

/**
 * meta_dbus_remote_desktop_session_set_num_lock_state: (skip)
 * @object: A #MetaDBusRemoteDesktopSession.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Mutter-RemoteDesktop-Session.NumLockState">"NumLockState"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
meta_dbus_remote_desktop_session_set_num_lock_state (MetaDBusRemoteDesktopSession *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "num-lock-state", value, NULL);
}

/**
 * meta_dbus_remote_desktop_session_emit_closed:
 * @object: A #MetaDBusRemoteDesktopSession.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Mutter-RemoteDesktop-Session.Closed">"Closed"</link> D-Bus signal.
 */
void
meta_dbus_remote_desktop_session_emit_closed (
    MetaDBusRemoteDesktopSession *object)
{
  g_signal_emit (object, META_DBUS__REMOTE_DESKTOP_SESSION_SIGNALS[META_DBUS__REMOTE_DESKTOP_SESSION_CLOSED], 0);
}

/**
 * meta_dbus_remote_desktop_session_emit_selection_owner_changed:
 * @object: A #MetaDBusRemoteDesktopSession.
 * @arg_options: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Mutter-RemoteDesktop-Session.SelectionOwnerChanged">"SelectionOwnerChanged"</link> D-Bus signal.
 */
void
meta_dbus_remote_desktop_session_emit_selection_owner_changed (
    MetaDBusRemoteDesktopSession *object,
    GVariant *arg_options)
{
  g_signal_emit (object, META_DBUS__REMOTE_DESKTOP_SESSION_SIGNALS[META_DBUS__REMOTE_DESKTOP_SESSION_SELECTION_OWNER_CHANGED], 0, arg_options);
}

/**
 * meta_dbus_remote_desktop_session_emit_selection_transfer:
 * @object: A #MetaDBusRemoteDesktopSession.
 * @arg_mime_type: Argument to pass with the signal.
 * @arg_serial: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Mutter-RemoteDesktop-Session.SelectionTransfer">"SelectionTransfer"</link> D-Bus signal.
 */
void
meta_dbus_remote_desktop_session_emit_selection_transfer (
    MetaDBusRemoteDesktopSession *object,
    const gchar *arg_mime_type,
    guint arg_serial)
{
  g_signal_emit (object, META_DBUS__REMOTE_DESKTOP_SESSION_SIGNALS[META_DBUS__REMOTE_DESKTOP_SESSION_SELECTION_TRANSFER], 0, arg_mime_type, arg_serial);
}

/**
 * meta_dbus_remote_desktop_session_call_start:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Start">Start()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_session_call_start_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_session_call_start_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_remote_desktop_session_call_start (
    MetaDBusRemoteDesktopSession *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_remote_desktop_session_call_start_finish:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_session_call_start().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_remote_desktop_session_call_start().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_start_finish (
    MetaDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_start_sync:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Start">Start()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_session_call_start() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_start_sync (
    MetaDBusRemoteDesktopSession *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_stop:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Stop">Stop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_session_call_stop_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_session_call_stop_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_remote_desktop_session_call_stop (
    MetaDBusRemoteDesktopSession *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_remote_desktop_session_call_stop_finish:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_session_call_stop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_remote_desktop_session_call_stop().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_stop_finish (
    MetaDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_stop_sync:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Stop">Stop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_session_call_stop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_stop_sync (
    MetaDBusRemoteDesktopSession *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_notify_keyboard_keycode:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_keycode: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeycode">NotifyKeyboardKeycode()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_session_call_notify_keyboard_keycode_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_session_call_notify_keyboard_keycode_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_remote_desktop_session_call_notify_keyboard_keycode (
    MetaDBusRemoteDesktopSession *proxy,
    guint arg_keycode,
    gboolean arg_state,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyKeyboardKeycode",
    g_variant_new ("(ub)",
                   arg_keycode,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_remote_desktop_session_call_notify_keyboard_keycode_finish:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_session_call_notify_keyboard_keycode().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_remote_desktop_session_call_notify_keyboard_keycode().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_notify_keyboard_keycode_finish (
    MetaDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_notify_keyboard_keycode_sync:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_keycode: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeycode">NotifyKeyboardKeycode()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_session_call_notify_keyboard_keycode() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_notify_keyboard_keycode_sync (
    MetaDBusRemoteDesktopSession *proxy,
    guint arg_keycode,
    gboolean arg_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyKeyboardKeycode",
    g_variant_new ("(ub)",
                   arg_keycode,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_notify_keyboard_keysym:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_keysym: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeysym">NotifyKeyboardKeysym()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_session_call_notify_keyboard_keysym_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_session_call_notify_keyboard_keysym_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_remote_desktop_session_call_notify_keyboard_keysym (
    MetaDBusRemoteDesktopSession *proxy,
    guint arg_keysym,
    gboolean arg_state,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyKeyboardKeysym",
    g_variant_new ("(ub)",
                   arg_keysym,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_remote_desktop_session_call_notify_keyboard_keysym_finish:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_session_call_notify_keyboard_keysym().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_remote_desktop_session_call_notify_keyboard_keysym().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_notify_keyboard_keysym_finish (
    MetaDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_notify_keyboard_keysym_sync:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_keysym: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeysym">NotifyKeyboardKeysym()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_session_call_notify_keyboard_keysym() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_notify_keyboard_keysym_sync (
    MetaDBusRemoteDesktopSession *proxy,
    guint arg_keysym,
    gboolean arg_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyKeyboardKeysym",
    g_variant_new ("(ub)",
                   arg_keysym,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_notify_pointer_button:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_button: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerButton">NotifyPointerButton()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_session_call_notify_pointer_button_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_session_call_notify_pointer_button_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_remote_desktop_session_call_notify_pointer_button (
    MetaDBusRemoteDesktopSession *proxy,
    gint arg_button,
    gboolean arg_state,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerButton",
    g_variant_new ("(ib)",
                   arg_button,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_remote_desktop_session_call_notify_pointer_button_finish:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_session_call_notify_pointer_button().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_remote_desktop_session_call_notify_pointer_button().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_notify_pointer_button_finish (
    MetaDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_notify_pointer_button_sync:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_button: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerButton">NotifyPointerButton()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_session_call_notify_pointer_button() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_notify_pointer_button_sync (
    MetaDBusRemoteDesktopSession *proxy,
    gint arg_button,
    gboolean arg_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerButton",
    g_variant_new ("(ib)",
                   arg_button,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_notify_pointer_axis:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_dx: Argument to pass with the method invocation.
 * @arg_dy: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxis">NotifyPointerAxis()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_session_call_notify_pointer_axis_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_session_call_notify_pointer_axis_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_remote_desktop_session_call_notify_pointer_axis (
    MetaDBusRemoteDesktopSession *proxy,
    gdouble arg_dx,
    gdouble arg_dy,
    guint arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerAxis",
    g_variant_new ("(ddu)",
                   arg_dx,
                   arg_dy,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_remote_desktop_session_call_notify_pointer_axis_finish:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_session_call_notify_pointer_axis().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_remote_desktop_session_call_notify_pointer_axis().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_notify_pointer_axis_finish (
    MetaDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_notify_pointer_axis_sync:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_dx: Argument to pass with the method invocation.
 * @arg_dy: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxis">NotifyPointerAxis()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_session_call_notify_pointer_axis() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_notify_pointer_axis_sync (
    MetaDBusRemoteDesktopSession *proxy,
    gdouble arg_dx,
    gdouble arg_dy,
    guint arg_flags,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerAxis",
    g_variant_new ("(ddu)",
                   arg_dx,
                   arg_dy,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_notify_pointer_axis_discrete:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_axis: Argument to pass with the method invocation.
 * @arg_steps: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxisDiscrete">NotifyPointerAxisDiscrete()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_session_call_notify_pointer_axis_discrete_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_session_call_notify_pointer_axis_discrete_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_remote_desktop_session_call_notify_pointer_axis_discrete (
    MetaDBusRemoteDesktopSession *proxy,
    guint arg_axis,
    gint arg_steps,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerAxisDiscrete",
    g_variant_new ("(ui)",
                   arg_axis,
                   arg_steps),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_remote_desktop_session_call_notify_pointer_axis_discrete_finish:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_session_call_notify_pointer_axis_discrete().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_remote_desktop_session_call_notify_pointer_axis_discrete().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_notify_pointer_axis_discrete_finish (
    MetaDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_notify_pointer_axis_discrete_sync:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_axis: Argument to pass with the method invocation.
 * @arg_steps: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxisDiscrete">NotifyPointerAxisDiscrete()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_session_call_notify_pointer_axis_discrete() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_notify_pointer_axis_discrete_sync (
    MetaDBusRemoteDesktopSession *proxy,
    guint arg_axis,
    gint arg_steps,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerAxisDiscrete",
    g_variant_new ("(ui)",
                   arg_axis,
                   arg_steps),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_notify_pointer_motion_relative:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_dx: Argument to pass with the method invocation.
 * @arg_dy: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionRelative">NotifyPointerMotionRelative()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_session_call_notify_pointer_motion_relative_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_session_call_notify_pointer_motion_relative_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_remote_desktop_session_call_notify_pointer_motion_relative (
    MetaDBusRemoteDesktopSession *proxy,
    gdouble arg_dx,
    gdouble arg_dy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerMotionRelative",
    g_variant_new ("(dd)",
                   arg_dx,
                   arg_dy),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_remote_desktop_session_call_notify_pointer_motion_relative_finish:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_session_call_notify_pointer_motion_relative().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_remote_desktop_session_call_notify_pointer_motion_relative().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_notify_pointer_motion_relative_finish (
    MetaDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_notify_pointer_motion_relative_sync:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_dx: Argument to pass with the method invocation.
 * @arg_dy: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionRelative">NotifyPointerMotionRelative()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_session_call_notify_pointer_motion_relative() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_notify_pointer_motion_relative_sync (
    MetaDBusRemoteDesktopSession *proxy,
    gdouble arg_dx,
    gdouble arg_dy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerMotionRelative",
    g_variant_new ("(dd)",
                   arg_dx,
                   arg_dy),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_notify_pointer_motion_absolute:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionAbsolute">NotifyPointerMotionAbsolute()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_session_call_notify_pointer_motion_absolute_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_session_call_notify_pointer_motion_absolute_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_remote_desktop_session_call_notify_pointer_motion_absolute (
    MetaDBusRemoteDesktopSession *proxy,
    const gchar *arg_stream,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerMotionAbsolute",
    g_variant_new ("(sdd)",
                   arg_stream,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_remote_desktop_session_call_notify_pointer_motion_absolute_finish:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_session_call_notify_pointer_motion_absolute().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_remote_desktop_session_call_notify_pointer_motion_absolute().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_notify_pointer_motion_absolute_finish (
    MetaDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_notify_pointer_motion_absolute_sync:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionAbsolute">NotifyPointerMotionAbsolute()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_session_call_notify_pointer_motion_absolute() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_notify_pointer_motion_absolute_sync (
    MetaDBusRemoteDesktopSession *proxy,
    const gchar *arg_stream,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerMotionAbsolute",
    g_variant_new ("(sdd)",
                   arg_stream,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_notify_touch_down:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchDown">NotifyTouchDown()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_session_call_notify_touch_down_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_session_call_notify_touch_down_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_remote_desktop_session_call_notify_touch_down (
    MetaDBusRemoteDesktopSession *proxy,
    const gchar *arg_stream,
    guint arg_slot,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyTouchDown",
    g_variant_new ("(sudd)",
                   arg_stream,
                   arg_slot,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_remote_desktop_session_call_notify_touch_down_finish:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_session_call_notify_touch_down().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_remote_desktop_session_call_notify_touch_down().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_notify_touch_down_finish (
    MetaDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_notify_touch_down_sync:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchDown">NotifyTouchDown()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_session_call_notify_touch_down() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_notify_touch_down_sync (
    MetaDBusRemoteDesktopSession *proxy,
    const gchar *arg_stream,
    guint arg_slot,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyTouchDown",
    g_variant_new ("(sudd)",
                   arg_stream,
                   arg_slot,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_notify_touch_motion:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchMotion">NotifyTouchMotion()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_session_call_notify_touch_motion_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_session_call_notify_touch_motion_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_remote_desktop_session_call_notify_touch_motion (
    MetaDBusRemoteDesktopSession *proxy,
    const gchar *arg_stream,
    guint arg_slot,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyTouchMotion",
    g_variant_new ("(sudd)",
                   arg_stream,
                   arg_slot,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_remote_desktop_session_call_notify_touch_motion_finish:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_session_call_notify_touch_motion().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_remote_desktop_session_call_notify_touch_motion().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_notify_touch_motion_finish (
    MetaDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_notify_touch_motion_sync:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchMotion">NotifyTouchMotion()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_session_call_notify_touch_motion() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_notify_touch_motion_sync (
    MetaDBusRemoteDesktopSession *proxy,
    const gchar *arg_stream,
    guint arg_slot,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyTouchMotion",
    g_variant_new ("(sudd)",
                   arg_stream,
                   arg_slot,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_notify_touch_up:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_slot: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchUp">NotifyTouchUp()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_session_call_notify_touch_up_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_session_call_notify_touch_up_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_remote_desktop_session_call_notify_touch_up (
    MetaDBusRemoteDesktopSession *proxy,
    guint arg_slot,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyTouchUp",
    g_variant_new ("(u)",
                   arg_slot),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_remote_desktop_session_call_notify_touch_up_finish:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_session_call_notify_touch_up().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_remote_desktop_session_call_notify_touch_up().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_notify_touch_up_finish (
    MetaDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_notify_touch_up_sync:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_slot: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchUp">NotifyTouchUp()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_session_call_notify_touch_up() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_notify_touch_up_sync (
    MetaDBusRemoteDesktopSession *proxy,
    guint arg_slot,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyTouchUp",
    g_variant_new ("(u)",
                   arg_slot),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_enable_clipboard:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.EnableClipboard">EnableClipboard()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_session_call_enable_clipboard_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_session_call_enable_clipboard_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_remote_desktop_session_call_enable_clipboard (
    MetaDBusRemoteDesktopSession *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EnableClipboard",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_remote_desktop_session_call_enable_clipboard_finish:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_session_call_enable_clipboard().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_remote_desktop_session_call_enable_clipboard().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_enable_clipboard_finish (
    MetaDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_enable_clipboard_sync:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.EnableClipboard">EnableClipboard()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_session_call_enable_clipboard() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_enable_clipboard_sync (
    MetaDBusRemoteDesktopSession *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EnableClipboard",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_disable_clipboard:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.DisableClipboard">DisableClipboard()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_session_call_disable_clipboard_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_session_call_disable_clipboard_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_remote_desktop_session_call_disable_clipboard (
    MetaDBusRemoteDesktopSession *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DisableClipboard",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_remote_desktop_session_call_disable_clipboard_finish:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_session_call_disable_clipboard().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_remote_desktop_session_call_disable_clipboard().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_disable_clipboard_finish (
    MetaDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_disable_clipboard_sync:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.DisableClipboard">DisableClipboard()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_session_call_disable_clipboard() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_disable_clipboard_sync (
    MetaDBusRemoteDesktopSession *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DisableClipboard",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_set_selection:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SetSelection">SetSelection()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_session_call_set_selection_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_session_call_set_selection_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_remote_desktop_session_call_set_selection (
    MetaDBusRemoteDesktopSession *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetSelection",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_remote_desktop_session_call_set_selection_finish:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_session_call_set_selection().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_remote_desktop_session_call_set_selection().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_set_selection_finish (
    MetaDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_set_selection_sync:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SetSelection">SetSelection()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_session_call_set_selection() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_set_selection_sync (
    MetaDBusRemoteDesktopSession *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetSelection",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_selection_write:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_serial: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionWrite">SelectionWrite()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_session_call_selection_write_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_session_call_selection_write_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_remote_desktop_session_call_selection_write (
    MetaDBusRemoteDesktopSession *proxy,
    guint arg_serial,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "SelectionWrite",
    g_variant_new ("(u)",
                   arg_serial),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_remote_desktop_session_call_selection_write_finish:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_session_call_selection_write().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_remote_desktop_session_call_selection_write().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_selection_write_finish (
    MetaDBusRemoteDesktopSession *proxy,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_selection_write_sync:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_serial: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionWrite">SelectionWrite()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_session_call_selection_write() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_selection_write_sync (
    MetaDBusRemoteDesktopSession *proxy,
    guint arg_serial,
    GUnixFDList  *fd_list,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "SelectionWrite",
    g_variant_new ("(u)",
                   arg_serial),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_selection_write_done:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_serial: Argument to pass with the method invocation.
 * @arg_success: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionWriteDone">SelectionWriteDone()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_session_call_selection_write_done_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_session_call_selection_write_done_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_remote_desktop_session_call_selection_write_done (
    MetaDBusRemoteDesktopSession *proxy,
    guint arg_serial,
    gboolean arg_success,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SelectionWriteDone",
    g_variant_new ("(ub)",
                   arg_serial,
                   arg_success),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_remote_desktop_session_call_selection_write_done_finish:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_session_call_selection_write_done().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_remote_desktop_session_call_selection_write_done().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_selection_write_done_finish (
    MetaDBusRemoteDesktopSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_selection_write_done_sync:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_serial: Argument to pass with the method invocation.
 * @arg_success: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionWriteDone">SelectionWriteDone()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_session_call_selection_write_done() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_selection_write_done_sync (
    MetaDBusRemoteDesktopSession *proxy,
    guint arg_serial,
    gboolean arg_success,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SelectionWriteDone",
    g_variant_new ("(ub)",
                   arg_serial,
                   arg_success),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_selection_read:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_mime_type: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionRead">SelectionRead()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_session_call_selection_read_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_session_call_selection_read_sync() for the synchronous, blocking version of this method.
 */
void
meta_dbus_remote_desktop_session_call_selection_read (
    MetaDBusRemoteDesktopSession *proxy,
    const gchar *arg_mime_type,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "SelectionRead",
    g_variant_new ("(s)",
                   arg_mime_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * meta_dbus_remote_desktop_session_call_selection_read_finish:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_session_call_selection_read().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with meta_dbus_remote_desktop_session_call_selection_read().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_selection_read_finish (
    MetaDBusRemoteDesktopSession *proxy,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_call_selection_read_sync:
 * @proxy: A #MetaDBusRemoteDesktopSessionProxy.
 * @arg_mime_type: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionRead">SelectionRead()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_session_call_selection_read() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
meta_dbus_remote_desktop_session_call_selection_read_sync (
    MetaDBusRemoteDesktopSession *proxy,
    const gchar *arg_mime_type,
    GUnixFDList  *fd_list,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "SelectionRead",
    g_variant_new ("(s)",
                   arg_mime_type),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * meta_dbus_remote_desktop_session_complete_start:
 * @object: A #MetaDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Start">Start()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_remote_desktop_session_complete_start (
    MetaDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_remote_desktop_session_complete_stop:
 * @object: A #MetaDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.Stop">Stop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_remote_desktop_session_complete_stop (
    MetaDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_remote_desktop_session_complete_notify_keyboard_keycode:
 * @object: A #MetaDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeycode">NotifyKeyboardKeycode()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_remote_desktop_session_complete_notify_keyboard_keycode (
    MetaDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_remote_desktop_session_complete_notify_keyboard_keysym:
 * @object: A #MetaDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyKeyboardKeysym">NotifyKeyboardKeysym()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_remote_desktop_session_complete_notify_keyboard_keysym (
    MetaDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_remote_desktop_session_complete_notify_pointer_button:
 * @object: A #MetaDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerButton">NotifyPointerButton()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_remote_desktop_session_complete_notify_pointer_button (
    MetaDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_remote_desktop_session_complete_notify_pointer_axis:
 * @object: A #MetaDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxis">NotifyPointerAxis()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_remote_desktop_session_complete_notify_pointer_axis (
    MetaDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_remote_desktop_session_complete_notify_pointer_axis_discrete:
 * @object: A #MetaDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerAxisDiscrete">NotifyPointerAxisDiscrete()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_remote_desktop_session_complete_notify_pointer_axis_discrete (
    MetaDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_remote_desktop_session_complete_notify_pointer_motion_relative:
 * @object: A #MetaDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionRelative">NotifyPointerMotionRelative()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_remote_desktop_session_complete_notify_pointer_motion_relative (
    MetaDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_remote_desktop_session_complete_notify_pointer_motion_absolute:
 * @object: A #MetaDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyPointerMotionAbsolute">NotifyPointerMotionAbsolute()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_remote_desktop_session_complete_notify_pointer_motion_absolute (
    MetaDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_remote_desktop_session_complete_notify_touch_down:
 * @object: A #MetaDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchDown">NotifyTouchDown()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_remote_desktop_session_complete_notify_touch_down (
    MetaDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_remote_desktop_session_complete_notify_touch_motion:
 * @object: A #MetaDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchMotion">NotifyTouchMotion()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_remote_desktop_session_complete_notify_touch_motion (
    MetaDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_remote_desktop_session_complete_notify_touch_up:
 * @object: A #MetaDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.NotifyTouchUp">NotifyTouchUp()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_remote_desktop_session_complete_notify_touch_up (
    MetaDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_remote_desktop_session_complete_enable_clipboard:
 * @object: A #MetaDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.EnableClipboard">EnableClipboard()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_remote_desktop_session_complete_enable_clipboard (
    MetaDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_remote_desktop_session_complete_disable_clipboard:
 * @object: A #MetaDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.DisableClipboard">DisableClipboard()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_remote_desktop_session_complete_disable_clipboard (
    MetaDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_remote_desktop_session_complete_set_selection:
 * @object: A #MetaDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SetSelection">SetSelection()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_remote_desktop_session_complete_set_selection (
    MetaDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_remote_desktop_session_complete_selection_write:
 * @object: A #MetaDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionWrite">SelectionWrite()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_remote_desktop_session_complete_selection_write (
    MetaDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@h)",
                   fd),
    fd_list);
}

/**
 * meta_dbus_remote_desktop_session_complete_selection_write_done:
 * @object: A #MetaDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionWriteDone">SelectionWriteDone()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_remote_desktop_session_complete_selection_write_done (
    MetaDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * meta_dbus_remote_desktop_session_complete_selection_read:
 * @object: A #MetaDBusRemoteDesktopSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-RemoteDesktop-Session.SelectionRead">SelectionRead()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
meta_dbus_remote_desktop_session_complete_selection_read (
    MetaDBusRemoteDesktopSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@h)",
                   fd),
    fd_list);
}

/* ------------------------------------------------------------------------ */

/**
 * MetaDBusRemoteDesktopSessionProxy:
 *
 * The #MetaDBusRemoteDesktopSessionProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDBusRemoteDesktopSessionProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDBusRemoteDesktopSessionProxy.
 */

struct _MetaDBusRemoteDesktopSessionProxyPrivate
{
  GData *qdata;
};

static void meta_dbus_remote_desktop_session_proxy_iface_init (MetaDBusRemoteDesktopSessionIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDBusRemoteDesktopSessionProxy, meta_dbus_remote_desktop_session_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MetaDBusRemoteDesktopSessionProxy)
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_REMOTE_DESKTOP_SESSION, meta_dbus_remote_desktop_session_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDBusRemoteDesktopSessionProxy, meta_dbus_remote_desktop_session_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_REMOTE_DESKTOP_SESSION, meta_dbus_remote_desktop_session_proxy_iface_init))

#endif
static void
meta_dbus_remote_desktop_session_proxy_finalize (GObject *object)
{
  MetaDBusRemoteDesktopSessionProxy *proxy = META_DBUS_REMOTE_DESKTOP_SESSION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (meta_dbus_remote_desktop_session_proxy_parent_class)->finalize (object);
}

static void
meta_dbus_remote_desktop_session_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _meta_dbus_remote_desktop_session_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
meta_dbus_remote_desktop_session_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Mutter.RemoteDesktop.Session: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
meta_dbus_remote_desktop_session_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _meta_dbus_remote_desktop_session_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Mutter.RemoteDesktop.Session", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) meta_dbus_remote_desktop_session_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
meta_dbus_remote_desktop_session_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_meta_dbus_remote_desktop_session_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], META_DBUS_TYPE_REMOTE_DESKTOP_SESSION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_TYPE_REMOTE_DESKTOP_SESSION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
meta_dbus_remote_desktop_session_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MetaDBusRemoteDesktopSessionProxy *proxy = META_DBUS_REMOTE_DESKTOP_SESSION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_remote_desktop_session_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_remote_desktop_session_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
meta_dbus_remote_desktop_session_proxy_get_session_id (MetaDBusRemoteDesktopSession *object)
{
  MetaDBusRemoteDesktopSessionProxy *proxy = META_DBUS_REMOTE_DESKTOP_SESSION_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SessionId");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
meta_dbus_remote_desktop_session_proxy_get_caps_lock_state (MetaDBusRemoteDesktopSession *object)
{
  MetaDBusRemoteDesktopSessionProxy *proxy = META_DBUS_REMOTE_DESKTOP_SESSION_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CapsLockState");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
meta_dbus_remote_desktop_session_proxy_get_num_lock_state (MetaDBusRemoteDesktopSession *object)
{
  MetaDBusRemoteDesktopSessionProxy *proxy = META_DBUS_REMOTE_DESKTOP_SESSION_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "NumLockState");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
meta_dbus_remote_desktop_session_proxy_init (MetaDBusRemoteDesktopSessionProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = meta_dbus_remote_desktop_session_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, META_DBUS_TYPE_REMOTE_DESKTOP_SESSION_PROXY, MetaDBusRemoteDesktopSessionProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), meta_dbus_remote_desktop_session_interface_info ());
}

static void
meta_dbus_remote_desktop_session_proxy_class_init (MetaDBusRemoteDesktopSessionProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = meta_dbus_remote_desktop_session_proxy_finalize;
  gobject_class->get_property = meta_dbus_remote_desktop_session_proxy_get_property;
  gobject_class->set_property = meta_dbus_remote_desktop_session_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = meta_dbus_remote_desktop_session_proxy_g_signal;
  proxy_class->g_properties_changed = meta_dbus_remote_desktop_session_proxy_g_properties_changed;

  meta_dbus_remote_desktop_session_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDBusRemoteDesktopSessionProxyPrivate));
#endif
}

static void
meta_dbus_remote_desktop_session_proxy_iface_init (MetaDBusRemoteDesktopSessionIface *iface)
{
  iface->get_session_id = meta_dbus_remote_desktop_session_proxy_get_session_id;
  iface->get_caps_lock_state = meta_dbus_remote_desktop_session_proxy_get_caps_lock_state;
  iface->get_num_lock_state = meta_dbus_remote_desktop_session_proxy_get_num_lock_state;
}

/**
 * meta_dbus_remote_desktop_session_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop-Session.top_of_page">org.gnome.Mutter.RemoteDesktop.Session</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_session_proxy_new_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_session_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_remote_desktop_session_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_TYPE_REMOTE_DESKTOP_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop.Session", NULL);
}

/**
 * meta_dbus_remote_desktop_session_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_session_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_remote_desktop_session_proxy_new().
 *
 * Returns: (transfer full) (type MetaDBusRemoteDesktopSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusRemoteDesktopSession *
meta_dbus_remote_desktop_session_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_REMOTE_DESKTOP_SESSION (ret);
  else
    return NULL;
}

/**
 * meta_dbus_remote_desktop_session_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop-Session.top_of_page">org.gnome.Mutter.RemoteDesktop.Session</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_session_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDBusRemoteDesktopSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusRemoteDesktopSession *
meta_dbus_remote_desktop_session_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_TYPE_REMOTE_DESKTOP_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop.Session", NULL);
  if (ret != NULL)
    return META_DBUS_REMOTE_DESKTOP_SESSION (ret);
  else
    return NULL;
}


/**
 * meta_dbus_remote_desktop_session_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like meta_dbus_remote_desktop_session_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call meta_dbus_remote_desktop_session_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See meta_dbus_remote_desktop_session_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
meta_dbus_remote_desktop_session_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (META_DBUS_TYPE_REMOTE_DESKTOP_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop.Session", NULL);
}

/**
 * meta_dbus_remote_desktop_session_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to meta_dbus_remote_desktop_session_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with meta_dbus_remote_desktop_session_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MetaDBusRemoteDesktopSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusRemoteDesktopSession *
meta_dbus_remote_desktop_session_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return META_DBUS_REMOTE_DESKTOP_SESSION (ret);
  else
    return NULL;
}

/**
 * meta_dbus_remote_desktop_session_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like meta_dbus_remote_desktop_session_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See meta_dbus_remote_desktop_session_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MetaDBusRemoteDesktopSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
MetaDBusRemoteDesktopSession *
meta_dbus_remote_desktop_session_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (META_DBUS_TYPE_REMOTE_DESKTOP_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.RemoteDesktop.Session", NULL);
  if (ret != NULL)
    return META_DBUS_REMOTE_DESKTOP_SESSION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MetaDBusRemoteDesktopSessionSkeleton:
 *
 * The #MetaDBusRemoteDesktopSessionSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MetaDBusRemoteDesktopSessionSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MetaDBusRemoteDesktopSessionSkeleton.
 */

struct _MetaDBusRemoteDesktopSessionSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_meta_dbus_remote_desktop_session_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MetaDBusRemoteDesktopSessionSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], META_DBUS_TYPE_REMOTE_DESKTOP_SESSION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, META_DBUS_TYPE_REMOTE_DESKTOP_SESSION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_meta_dbus_remote_desktop_session_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MetaDBusRemoteDesktopSessionSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_remote_desktop_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_meta_dbus_remote_desktop_session_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MetaDBusRemoteDesktopSessionSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_meta_dbus_remote_desktop_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _meta_dbus_remote_desktop_session_skeleton_vtable =
{
  _meta_dbus_remote_desktop_session_skeleton_handle_method_call,
  _meta_dbus_remote_desktop_session_skeleton_handle_get_property,
  _meta_dbus_remote_desktop_session_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
meta_dbus_remote_desktop_session_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return meta_dbus_remote_desktop_session_interface_info ();
}

static GDBusInterfaceVTable *
meta_dbus_remote_desktop_session_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_meta_dbus_remote_desktop_session_skeleton_vtable;
}

static GVariant *
meta_dbus_remote_desktop_session_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MetaDBusRemoteDesktopSessionSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_meta_dbus_remote_desktop_session_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _meta_dbus_remote_desktop_session_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _meta_dbus_remote_desktop_session_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _meta_dbus_remote_desktop_session_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.RemoteDesktop.Session", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _meta_dbus_remote_desktop_session_emit_changed (gpointer user_data);

static void
meta_dbus_remote_desktop_session_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MetaDBusRemoteDesktopSessionSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _meta_dbus_remote_desktop_session_emit_changed (skeleton);
}

static void
_meta_dbus_remote_desktop_session_on_signal_closed (
    MetaDBusRemoteDesktopSession *object)
{
  MetaDBusRemoteDesktopSessionSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.RemoteDesktop.Session", "Closed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_meta_dbus_remote_desktop_session_on_signal_selection_owner_changed (
    MetaDBusRemoteDesktopSession *object,
    GVariant *arg_options)
{
  MetaDBusRemoteDesktopSessionSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@a{sv})",
                   arg_options));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.RemoteDesktop.Session", "SelectionOwnerChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_meta_dbus_remote_desktop_session_on_signal_selection_transfer (
    MetaDBusRemoteDesktopSession *object,
    const gchar *arg_mime_type,
    guint arg_serial)
{
  MetaDBusRemoteDesktopSessionSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(su)",
                   arg_mime_type,
                   arg_serial));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.RemoteDesktop.Session", "SelectionTransfer",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void meta_dbus_remote_desktop_session_skeleton_iface_init (MetaDBusRemoteDesktopSessionIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MetaDBusRemoteDesktopSessionSkeleton, meta_dbus_remote_desktop_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MetaDBusRemoteDesktopSessionSkeleton)
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_REMOTE_DESKTOP_SESSION, meta_dbus_remote_desktop_session_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MetaDBusRemoteDesktopSessionSkeleton, meta_dbus_remote_desktop_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (META_DBUS_TYPE_REMOTE_DESKTOP_SESSION, meta_dbus_remote_desktop_session_skeleton_iface_init))

#endif
static void
meta_dbus_remote_desktop_session_skeleton_finalize (GObject *object)
{
  MetaDBusRemoteDesktopSessionSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (object);
  guint n;
  for (n = 0; n < 3; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (meta_dbus_remote_desktop_session_skeleton_parent_class)->finalize (object);
}

static void
meta_dbus_remote_desktop_session_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MetaDBusRemoteDesktopSessionSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_meta_dbus_remote_desktop_session_emit_changed (gpointer user_data)
{
  MetaDBusRemoteDesktopSessionSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Mutter.RemoteDesktop.Session",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_meta_dbus_remote_desktop_session_schedule_emit_changed (MetaDBusRemoteDesktopSessionSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
meta_dbus_remote_desktop_session_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MetaDBusRemoteDesktopSessionSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _meta_dbus_remote_desktop_session_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _meta_dbus_remote_desktop_session_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
meta_dbus_remote_desktop_session_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MetaDBusRemoteDesktopSessionSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _meta_dbus_remote_desktop_session_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _meta_dbus_remote_desktop_session_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
meta_dbus_remote_desktop_session_skeleton_init (MetaDBusRemoteDesktopSessionSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = meta_dbus_remote_desktop_session_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, META_DBUS_TYPE_REMOTE_DESKTOP_SESSION_SKELETON, MetaDBusRemoteDesktopSessionSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 3);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_BOOLEAN);
}

static const gchar *
meta_dbus_remote_desktop_session_skeleton_get_session_id (MetaDBusRemoteDesktopSession *object)
{
  MetaDBusRemoteDesktopSessionSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
meta_dbus_remote_desktop_session_skeleton_get_caps_lock_state (MetaDBusRemoteDesktopSession *object)
{
  MetaDBusRemoteDesktopSessionSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
meta_dbus_remote_desktop_session_skeleton_get_num_lock_state (MetaDBusRemoteDesktopSession *object)
{
  MetaDBusRemoteDesktopSessionSkeleton *skeleton = META_DBUS_REMOTE_DESKTOP_SESSION_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
meta_dbus_remote_desktop_session_skeleton_class_init (MetaDBusRemoteDesktopSessionSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = meta_dbus_remote_desktop_session_skeleton_finalize;
  gobject_class->get_property = meta_dbus_remote_desktop_session_skeleton_get_property;
  gobject_class->set_property = meta_dbus_remote_desktop_session_skeleton_set_property;
  gobject_class->notify       = meta_dbus_remote_desktop_session_skeleton_notify;


  meta_dbus_remote_desktop_session_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = meta_dbus_remote_desktop_session_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = meta_dbus_remote_desktop_session_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = meta_dbus_remote_desktop_session_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = meta_dbus_remote_desktop_session_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MetaDBusRemoteDesktopSessionSkeletonPrivate));
#endif
}

static void
meta_dbus_remote_desktop_session_skeleton_iface_init (MetaDBusRemoteDesktopSessionIface *iface)
{
  iface->closed = _meta_dbus_remote_desktop_session_on_signal_closed;
  iface->selection_owner_changed = _meta_dbus_remote_desktop_session_on_signal_selection_owner_changed;
  iface->selection_transfer = _meta_dbus_remote_desktop_session_on_signal_selection_transfer;
  iface->get_session_id = meta_dbus_remote_desktop_session_skeleton_get_session_id;
  iface->get_caps_lock_state = meta_dbus_remote_desktop_session_skeleton_get_caps_lock_state;
  iface->get_num_lock_state = meta_dbus_remote_desktop_session_skeleton_get_num_lock_state;
}

/**
 * meta_dbus_remote_desktop_session_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-RemoteDesktop-Session.top_of_page">org.gnome.Mutter.RemoteDesktop.Session</link>.
 *
 * Returns: (transfer full) (type MetaDBusRemoteDesktopSessionSkeleton): The skeleton object.
 */
MetaDBusRemoteDesktopSession *
meta_dbus_remote_desktop_session_skeleton_new (void)
{
  return META_DBUS_REMOTE_DESKTOP_SESSION (g_object_new (META_DBUS_TYPE_REMOTE_DESKTOP_SESSION_SKELETON, NULL));
}

