#include "nv_push_clc697.h"

#include <stdio.h>

const char*
P_PARSE_NVC697_MTHD(uint16_t idx)
{
    switch (idx) {
    case NVC697_SET_OBJECT:
        return "NVC697_SET_OBJECT";
    case NVC697_NO_OPERATION:
        return "NVC697_NO_OPERATION";
    case NVC697_SET_NOTIFY_A:
        return "NVC697_SET_NOTIFY_A";
    case NVC697_SET_NOTIFY_B:
        return "NVC697_SET_NOTIFY_B";
    case NVC697_NOTIFY:
        return "NVC697_NOTIFY";
    case NVC697_WAIT_FOR_IDLE:
        return "NVC697_WAIT_FOR_IDLE";
    case NVC697_LOAD_MME_INSTRUCTION_RAM_POINTER:
        return "NVC697_LOAD_MME_INSTRUCTION_RAM_POINTER";
    case NVC697_LOAD_MME_INSTRUCTION_RAM:
        return "NVC697_LOAD_MME_INSTRUCTION_RAM";
    case NVC697_LOAD_MME_START_ADDRESS_RAM_POINTER:
        return "NVC697_LOAD_MME_START_ADDRESS_RAM_POINTER";
    case NVC697_LOAD_MME_START_ADDRESS_RAM:
        return "NVC697_LOAD_MME_START_ADDRESS_RAM";
    case NVC697_SET_MME_SHADOW_RAM_CONTROL:
        return "NVC697_SET_MME_SHADOW_RAM_CONTROL";
    case NVC697_PEER_SEMAPHORE_RELEASE_OFFSET_UPPER:
        return "NVC697_PEER_SEMAPHORE_RELEASE_OFFSET_UPPER";
    case NVC697_PEER_SEMAPHORE_RELEASE_OFFSET:
        return "NVC697_PEER_SEMAPHORE_RELEASE_OFFSET";
    case NVC697_SET_GLOBAL_RENDER_ENABLE_A:
        return "NVC697_SET_GLOBAL_RENDER_ENABLE_A";
    case NVC697_SET_GLOBAL_RENDER_ENABLE_B:
        return "NVC697_SET_GLOBAL_RENDER_ENABLE_B";
    case NVC697_SET_GLOBAL_RENDER_ENABLE_C:
        return "NVC697_SET_GLOBAL_RENDER_ENABLE_C";
    case NVC697_SEND_GO_IDLE:
        return "NVC697_SEND_GO_IDLE";
    case NVC697_PM_TRIGGER:
        return "NVC697_PM_TRIGGER";
    case NVC697_PM_TRIGGER_WFI:
        return "NVC697_PM_TRIGGER_WFI";
    case NVC697_FE_ATOMIC_SEQUENCE_BEGIN:
        return "NVC697_FE_ATOMIC_SEQUENCE_BEGIN";
    case NVC697_FE_ATOMIC_SEQUENCE_END:
        return "NVC697_FE_ATOMIC_SEQUENCE_END";
    case NVC697_SET_INSTRUMENTATION_METHOD_HEADER:
        return "NVC697_SET_INSTRUMENTATION_METHOD_HEADER";
    case NVC697_SET_INSTRUMENTATION_METHOD_DATA:
        return "NVC697_SET_INSTRUMENTATION_METHOD_DATA";
    case NVC697_LINE_LENGTH_IN:
        return "NVC697_LINE_LENGTH_IN";
    case NVC697_LINE_COUNT:
        return "NVC697_LINE_COUNT";
    case NVC697_OFFSET_OUT_UPPER:
        return "NVC697_OFFSET_OUT_UPPER";
    case NVC697_OFFSET_OUT:
        return "NVC697_OFFSET_OUT";
    case NVC697_PITCH_OUT:
        return "NVC697_PITCH_OUT";
    case NVC697_SET_DST_BLOCK_SIZE:
        return "NVC697_SET_DST_BLOCK_SIZE";
    case NVC697_SET_DST_WIDTH:
        return "NVC697_SET_DST_WIDTH";
    case NVC697_SET_DST_HEIGHT:
        return "NVC697_SET_DST_HEIGHT";
    case NVC697_SET_DST_DEPTH:
        return "NVC697_SET_DST_DEPTH";
    case NVC697_SET_DST_LAYER:
        return "NVC697_SET_DST_LAYER";
    case NVC697_SET_DST_ORIGIN_BYTES_X:
        return "NVC697_SET_DST_ORIGIN_BYTES_X";
    case NVC697_SET_DST_ORIGIN_SAMPLES_Y:
        return "NVC697_SET_DST_ORIGIN_SAMPLES_Y";
    case NVC697_LAUNCH_DMA:
        return "NVC697_LAUNCH_DMA";
    case NVC697_LOAD_INLINE_DATA:
        return "NVC697_LOAD_INLINE_DATA";
    case NVC697_SET_I2M_SEMAPHORE_A:
        return "NVC697_SET_I2M_SEMAPHORE_A";
    case NVC697_SET_I2M_SEMAPHORE_B:
        return "NVC697_SET_I2M_SEMAPHORE_B";
    case NVC697_SET_I2M_SEMAPHORE_C:
        return "NVC697_SET_I2M_SEMAPHORE_C";
    case NVC697_SET_I2M_SPARE_NOOP00:
        return "NVC697_SET_I2M_SPARE_NOOP00";
    case NVC697_SET_I2M_SPARE_NOOP01:
        return "NVC697_SET_I2M_SPARE_NOOP01";
    case NVC697_SET_I2M_SPARE_NOOP02:
        return "NVC697_SET_I2M_SPARE_NOOP02";
    case NVC697_SET_I2M_SPARE_NOOP03:
        return "NVC697_SET_I2M_SPARE_NOOP03";
    case NVC697_RUN_DS_NOW:
        return "NVC697_RUN_DS_NOW";
    case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS:
        return "NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS";
    case NVC697_SET_GS_MODE:
        return "NVC697_SET_GS_MODE";
    case NVC697_SET_ALIASED_LINE_WIDTH_ENABLE:
        return "NVC697_SET_ALIASED_LINE_WIDTH_ENABLE";
    case NVC697_SET_API_MANDATED_EARLY_Z:
        return "NVC697_SET_API_MANDATED_EARLY_Z";
    case NVC697_SET_GS_DM_FIFO:
        return "NVC697_SET_GS_DM_FIFO";
    case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS:
        return "NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS";
    case NVC697_INVALIDATE_SHADER_CACHES:
        return "NVC697_INVALIDATE_SHADER_CACHES";
    case NVC697_SET_INSTANCE_COUNT:
        return "NVC697_SET_INSTANCE_COUNT";
    case NVC697_SET_POSITION_W_SCALED_OFFSET_ENABLE:
        return "NVC697_SET_POSITION_W_SCALED_OFFSET_ENABLE";
    case NVC697_SET_MULTI_VIEW:
        return "NVC697_SET_MULTI_VIEW";
    case NVC697_SET_GO_IDLE_TIMEOUT:
        return "NVC697_SET_GO_IDLE_TIMEOUT";
    case NVC697_SET_CONSERVATIVE_RASTER_CONTROL:
        return "NVC697_SET_CONSERVATIVE_RASTER_CONTROL";
    case NVC697_SET_MME_VERSION:
        return "NVC697_SET_MME_VERSION";
    case NVC697_SET_INDEX_BUFFER_SIZE_A:
        return "NVC697_SET_INDEX_BUFFER_SIZE_A";
    case NVC697_SET_INDEX_BUFFER_SIZE_B:
        return "NVC697_SET_INDEX_BUFFER_SIZE_B";
    case NVC697_SET_ROOT_TABLE_VISIBILITY(0):
        return "NVC697_SET_ROOT_TABLE_VISIBILITY(0)";
    case NVC697_SET_ROOT_TABLE_VISIBILITY(1):
        return "NVC697_SET_ROOT_TABLE_VISIBILITY(1)";
    case NVC697_SET_ROOT_TABLE_VISIBILITY(2):
        return "NVC697_SET_ROOT_TABLE_VISIBILITY(2)";
    case NVC697_SET_ROOT_TABLE_VISIBILITY(3):
        return "NVC697_SET_ROOT_TABLE_VISIBILITY(3)";
    case NVC697_SET_ROOT_TABLE_VISIBILITY(4):
        return "NVC697_SET_ROOT_TABLE_VISIBILITY(4)";
    case NVC697_SET_ROOT_TABLE_VISIBILITY(5):
        return "NVC697_SET_ROOT_TABLE_VISIBILITY(5)";
    case NVC697_SET_ROOT_TABLE_VISIBILITY(6):
        return "NVC697_SET_ROOT_TABLE_VISIBILITY(6)";
    case NVC697_SET_ROOT_TABLE_VISIBILITY(7):
        return "NVC697_SET_ROOT_TABLE_VISIBILITY(7)";
    case NVC697_SET_DRAW_CONTROL_A:
        return "NVC697_SET_DRAW_CONTROL_A";
    case NVC697_SET_DRAW_CONTROL_B:
        return "NVC697_SET_DRAW_CONTROL_B";
    case NVC697_DRAW_INDEX_BUFFER_BEGIN_END_A:
        return "NVC697_DRAW_INDEX_BUFFER_BEGIN_END_A";
    case NVC697_DRAW_INDEX_BUFFER_BEGIN_END_B:
        return "NVC697_DRAW_INDEX_BUFFER_BEGIN_END_B";
    case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_A:
        return "NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_A";
    case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_B:
        return "NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_B";
    case NVC697_INVALIDATE_RASTER_CACHE_NO_WFI:
        return "NVC697_INVALIDATE_RASTER_CACHE_NO_WFI";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(0):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(0)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(1):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(1)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(2):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(2)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(3):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(3)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(4):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(4)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(5):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(5)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(6):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(6)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(7):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(7)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(8):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(8)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(9):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(9)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(10):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(10)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(11):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(11)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(12):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(12)";
    case NVC697_SET_COLOR_RENDER_TO_ZETA_SURFACE:
        return "NVC697_SET_COLOR_RENDER_TO_ZETA_SURFACE";
    case NVC697_SET_ZCULL_VISIBLE_PRIM_OPTIMIZATION:
        return "NVC697_SET_ZCULL_VISIBLE_PRIM_OPTIMIZATION";
    case NVC697_INCREMENT_SYNC_POINT:
        return "NVC697_INCREMENT_SYNC_POINT";
    case NVC697_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE:
        return "NVC697_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE";
    case NVC697_SET_SURFACE_CLIP_ID_BLOCK_SIZE:
        return "NVC697_SET_SURFACE_CLIP_ID_BLOCK_SIZE";
    case NVC697_SET_ALPHA_CIRCULAR_BUFFER_SIZE:
        return "NVC697_SET_ALPHA_CIRCULAR_BUFFER_SIZE";
    case NVC697_DECOMPRESS_SURFACE:
        return "NVC697_DECOMPRESS_SURFACE";
    case NVC697_SET_ZCULL_ROP_BYPASS:
        return "NVC697_SET_ZCULL_ROP_BYPASS";
    case NVC697_SET_ZCULL_SUBREGION:
        return "NVC697_SET_ZCULL_SUBREGION";
    case NVC697_SET_RASTER_BOUNDING_BOX:
        return "NVC697_SET_RASTER_BOUNDING_BOX";
    case NVC697_PEER_SEMAPHORE_RELEASE:
        return "NVC697_PEER_SEMAPHORE_RELEASE";
    case NVC697_SET_ITERATED_BLEND_OPTIMIZATION:
        return "NVC697_SET_ITERATED_BLEND_OPTIMIZATION";
    case NVC697_SET_ZCULL_SUBREGION_ALLOCATION:
        return "NVC697_SET_ZCULL_SUBREGION_ALLOCATION";
    case NVC697_ASSIGN_ZCULL_SUBREGIONS:
        return "NVC697_ASSIGN_ZCULL_SUBREGIONS";
    case NVC697_SET_PS_OUTPUT_SAMPLE_MASK_USAGE:
        return "NVC697_SET_PS_OUTPUT_SAMPLE_MASK_USAGE";
    case NVC697_DRAW_ZERO_INDEX:
        return "NVC697_DRAW_ZERO_INDEX";
    case NVC697_SET_L1_CONFIGURATION:
        return "NVC697_SET_L1_CONFIGURATION";
    case NVC697_SET_RENDER_ENABLE_CONTROL:
        return "NVC697_SET_RENDER_ENABLE_CONTROL";
    case NVC697_SET_SPA_VERSION:
        return "NVC697_SET_SPA_VERSION";
    case NVC697_SET_TIMESLICE_BATCH_LIMIT:
        return "NVC697_SET_TIMESLICE_BATCH_LIMIT";
    case NVC697_SET_SNAP_GRID_LINE:
        return "NVC697_SET_SNAP_GRID_LINE";
    case NVC697_SET_SNAP_GRID_NON_LINE:
        return "NVC697_SET_SNAP_GRID_NON_LINE";
    case NVC697_SET_TESSELLATION_PARAMETERS:
        return "NVC697_SET_TESSELLATION_PARAMETERS";
    case NVC697_SET_TESSELLATION_LOD_U0_OR_DENSITY:
        return "NVC697_SET_TESSELLATION_LOD_U0_OR_DENSITY";
    case NVC697_SET_TESSELLATION_LOD_V0_OR_DETAIL:
        return "NVC697_SET_TESSELLATION_LOD_V0_OR_DETAIL";
    case NVC697_SET_TESSELLATION_LOD_U1_OR_W0:
        return "NVC697_SET_TESSELLATION_LOD_U1_OR_W0";
    case NVC697_SET_TESSELLATION_LOD_V1:
        return "NVC697_SET_TESSELLATION_LOD_V1";
    case NVC697_SET_TG_LOD_INTERIOR_U:
        return "NVC697_SET_TG_LOD_INTERIOR_U";
    case NVC697_SET_TG_LOD_INTERIOR_V:
        return "NVC697_SET_TG_LOD_INTERIOR_V";
    case NVC697_RESERVED_TG07:
        return "NVC697_RESERVED_TG07";
    case NVC697_RESERVED_TG08:
        return "NVC697_RESERVED_TG08";
    case NVC697_RESERVED_TG09:
        return "NVC697_RESERVED_TG09";
    case NVC697_RESERVED_TG10:
        return "NVC697_RESERVED_TG10";
    case NVC697_RESERVED_TG11:
        return "NVC697_RESERVED_TG11";
    case NVC697_RESERVED_TG12:
        return "NVC697_RESERVED_TG12";
    case NVC697_RESERVED_TG13:
        return "NVC697_RESERVED_TG13";
    case NVC697_RESERVED_TG14:
        return "NVC697_RESERVED_TG14";
    case NVC697_RESERVED_TG15:
        return "NVC697_RESERVED_TG15";
    case NVC697_SET_SUBTILING_PERF_KNOB_A:
        return "NVC697_SET_SUBTILING_PERF_KNOB_A";
    case NVC697_SET_SUBTILING_PERF_KNOB_B:
        return "NVC697_SET_SUBTILING_PERF_KNOB_B";
    case NVC697_SET_SUBTILING_PERF_KNOB_C:
        return "NVC697_SET_SUBTILING_PERF_KNOB_C";
    case NVC697_SET_ZCULL_SUBREGION_TO_REPORT:
        return "NVC697_SET_ZCULL_SUBREGION_TO_REPORT";
    case NVC697_SET_ZCULL_SUBREGION_REPORT_TYPE:
        return "NVC697_SET_ZCULL_SUBREGION_REPORT_TYPE";
    case NVC697_SET_BALANCED_PRIMITIVE_WORKLOAD:
        return "NVC697_SET_BALANCED_PRIMITIVE_WORKLOAD";
    case NVC697_SET_MAX_PATCHES_PER_BATCH:
        return "NVC697_SET_MAX_PATCHES_PER_BATCH";
    case NVC697_SET_RASTER_ENABLE:
        return "NVC697_SET_RASTER_ENABLE";
    case NVC697_SET_STREAM_OUT_BUFFER_ENABLE(0):
        return "NVC697_SET_STREAM_OUT_BUFFER_ENABLE(0)";
    case NVC697_SET_STREAM_OUT_BUFFER_ENABLE(1):
        return "NVC697_SET_STREAM_OUT_BUFFER_ENABLE(1)";
    case NVC697_SET_STREAM_OUT_BUFFER_ENABLE(2):
        return "NVC697_SET_STREAM_OUT_BUFFER_ENABLE(2)";
    case NVC697_SET_STREAM_OUT_BUFFER_ENABLE(3):
        return "NVC697_SET_STREAM_OUT_BUFFER_ENABLE(3)";
    case NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_A(0):
        return "NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_A(0)";
    case NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_A(1):
        return "NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_A(1)";
    case NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_A(2):
        return "NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_A(2)";
    case NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_A(3):
        return "NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_A(3)";
    case NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_B(0):
        return "NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_B(0)";
    case NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_B(1):
        return "NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_B(1)";
    case NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_B(2):
        return "NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_B(2)";
    case NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_B(3):
        return "NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_B(3)";
    case NVC697_SET_STREAM_OUT_BUFFER_SIZE(0):
        return "NVC697_SET_STREAM_OUT_BUFFER_SIZE(0)";
    case NVC697_SET_STREAM_OUT_BUFFER_SIZE(1):
        return "NVC697_SET_STREAM_OUT_BUFFER_SIZE(1)";
    case NVC697_SET_STREAM_OUT_BUFFER_SIZE(2):
        return "NVC697_SET_STREAM_OUT_BUFFER_SIZE(2)";
    case NVC697_SET_STREAM_OUT_BUFFER_SIZE(3):
        return "NVC697_SET_STREAM_OUT_BUFFER_SIZE(3)";
    case NVC697_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(0):
        return "NVC697_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(0)";
    case NVC697_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(1):
        return "NVC697_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(1)";
    case NVC697_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(2):
        return "NVC697_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(2)";
    case NVC697_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(3):
        return "NVC697_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(3)";
                    case NVC697_SET_ROOT_TABLE_SELECTOR:
        return "NVC697_SET_ROOT_TABLE_SELECTOR";
    case NVC697_LOAD_ROOT_TABLE:
        return "NVC697_LOAD_ROOT_TABLE";
    case NVC697_SET_MME_MEM_ADDRESS_A:
        return "NVC697_SET_MME_MEM_ADDRESS_A";
    case NVC697_SET_MME_MEM_ADDRESS_B:
        return "NVC697_SET_MME_MEM_ADDRESS_B";
    case NVC697_SET_MME_DATA_RAM_ADDRESS:
        return "NVC697_SET_MME_DATA_RAM_ADDRESS";
    case NVC697_MME_DMA_READ:
        return "NVC697_MME_DMA_READ";
    case NVC697_MME_DMA_READ_FIFOED:
        return "NVC697_MME_DMA_READ_FIFOED";
    case NVC697_MME_DMA_WRITE:
        return "NVC697_MME_DMA_WRITE";
    case NVC697_MME_DMA_REDUCTION:
        return "NVC697_MME_DMA_REDUCTION";
    case NVC697_MME_DMA_SYSMEMBAR:
        return "NVC697_MME_DMA_SYSMEMBAR";
    case NVC697_MME_DMA_SYNC:
        return "NVC697_MME_DMA_SYNC";
    case NVC697_SET_MME_DATA_FIFO_CONFIG:
        return "NVC697_SET_MME_DATA_FIFO_CONFIG";
    case NVC697_SET_VERTEX_STREAM_SIZE_A(0):
        return "NVC697_SET_VERTEX_STREAM_SIZE_A(0)";
    case NVC697_SET_VERTEX_STREAM_SIZE_A(1):
        return "NVC697_SET_VERTEX_STREAM_SIZE_A(1)";
    case NVC697_SET_VERTEX_STREAM_SIZE_A(2):
        return "NVC697_SET_VERTEX_STREAM_SIZE_A(2)";
    case NVC697_SET_VERTEX_STREAM_SIZE_A(3):
        return "NVC697_SET_VERTEX_STREAM_SIZE_A(3)";
    case NVC697_SET_VERTEX_STREAM_SIZE_A(4):
        return "NVC697_SET_VERTEX_STREAM_SIZE_A(4)";
    case NVC697_SET_VERTEX_STREAM_SIZE_A(5):
        return "NVC697_SET_VERTEX_STREAM_SIZE_A(5)";
    case NVC697_SET_VERTEX_STREAM_SIZE_A(6):
        return "NVC697_SET_VERTEX_STREAM_SIZE_A(6)";
    case NVC697_SET_VERTEX_STREAM_SIZE_A(7):
        return "NVC697_SET_VERTEX_STREAM_SIZE_A(7)";
    case NVC697_SET_VERTEX_STREAM_SIZE_A(8):
        return "NVC697_SET_VERTEX_STREAM_SIZE_A(8)";
    case NVC697_SET_VERTEX_STREAM_SIZE_A(9):
        return "NVC697_SET_VERTEX_STREAM_SIZE_A(9)";
    case NVC697_SET_VERTEX_STREAM_SIZE_A(10):
        return "NVC697_SET_VERTEX_STREAM_SIZE_A(10)";
    case NVC697_SET_VERTEX_STREAM_SIZE_A(11):
        return "NVC697_SET_VERTEX_STREAM_SIZE_A(11)";
    case NVC697_SET_VERTEX_STREAM_SIZE_A(12):
        return "NVC697_SET_VERTEX_STREAM_SIZE_A(12)";
    case NVC697_SET_VERTEX_STREAM_SIZE_A(13):
        return "NVC697_SET_VERTEX_STREAM_SIZE_A(13)";
    case NVC697_SET_VERTEX_STREAM_SIZE_A(14):
        return "NVC697_SET_VERTEX_STREAM_SIZE_A(14)";
    case NVC697_SET_VERTEX_STREAM_SIZE_A(15):
        return "NVC697_SET_VERTEX_STREAM_SIZE_A(15)";
    case NVC697_SET_VERTEX_STREAM_SIZE_B(0):
        return "NVC697_SET_VERTEX_STREAM_SIZE_B(0)";
    case NVC697_SET_VERTEX_STREAM_SIZE_B(1):
        return "NVC697_SET_VERTEX_STREAM_SIZE_B(1)";
    case NVC697_SET_VERTEX_STREAM_SIZE_B(2):
        return "NVC697_SET_VERTEX_STREAM_SIZE_B(2)";
    case NVC697_SET_VERTEX_STREAM_SIZE_B(3):
        return "NVC697_SET_VERTEX_STREAM_SIZE_B(3)";
    case NVC697_SET_VERTEX_STREAM_SIZE_B(4):
        return "NVC697_SET_VERTEX_STREAM_SIZE_B(4)";
    case NVC697_SET_VERTEX_STREAM_SIZE_B(5):
        return "NVC697_SET_VERTEX_STREAM_SIZE_B(5)";
    case NVC697_SET_VERTEX_STREAM_SIZE_B(6):
        return "NVC697_SET_VERTEX_STREAM_SIZE_B(6)";
    case NVC697_SET_VERTEX_STREAM_SIZE_B(7):
        return "NVC697_SET_VERTEX_STREAM_SIZE_B(7)";
    case NVC697_SET_VERTEX_STREAM_SIZE_B(8):
        return "NVC697_SET_VERTEX_STREAM_SIZE_B(8)";
    case NVC697_SET_VERTEX_STREAM_SIZE_B(9):
        return "NVC697_SET_VERTEX_STREAM_SIZE_B(9)";
    case NVC697_SET_VERTEX_STREAM_SIZE_B(10):
        return "NVC697_SET_VERTEX_STREAM_SIZE_B(10)";
    case NVC697_SET_VERTEX_STREAM_SIZE_B(11):
        return "NVC697_SET_VERTEX_STREAM_SIZE_B(11)";
    case NVC697_SET_VERTEX_STREAM_SIZE_B(12):
        return "NVC697_SET_VERTEX_STREAM_SIZE_B(12)";
    case NVC697_SET_VERTEX_STREAM_SIZE_B(13):
        return "NVC697_SET_VERTEX_STREAM_SIZE_B(13)";
    case NVC697_SET_VERTEX_STREAM_SIZE_B(14):
        return "NVC697_SET_VERTEX_STREAM_SIZE_B(14)";
    case NVC697_SET_VERTEX_STREAM_SIZE_B(15):
        return "NVC697_SET_VERTEX_STREAM_SIZE_B(15)";
    case NVC697_SET_STREAM_OUT_CONTROL_STREAM(0):
        return "NVC697_SET_STREAM_OUT_CONTROL_STREAM(0)";
    case NVC697_SET_STREAM_OUT_CONTROL_STREAM(1):
        return "NVC697_SET_STREAM_OUT_CONTROL_STREAM(1)";
    case NVC697_SET_STREAM_OUT_CONTROL_STREAM(2):
        return "NVC697_SET_STREAM_OUT_CONTROL_STREAM(2)";
    case NVC697_SET_STREAM_OUT_CONTROL_STREAM(3):
        return "NVC697_SET_STREAM_OUT_CONTROL_STREAM(3)";
    case NVC697_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(0):
        return "NVC697_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(0)";
    case NVC697_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(1):
        return "NVC697_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(1)";
    case NVC697_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(2):
        return "NVC697_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(2)";
    case NVC697_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(3):
        return "NVC697_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(3)";
    case NVC697_SET_STREAM_OUT_CONTROL_STRIDE(0):
        return "NVC697_SET_STREAM_OUT_CONTROL_STRIDE(0)";
    case NVC697_SET_STREAM_OUT_CONTROL_STRIDE(1):
        return "NVC697_SET_STREAM_OUT_CONTROL_STRIDE(1)";
    case NVC697_SET_STREAM_OUT_CONTROL_STRIDE(2):
        return "NVC697_SET_STREAM_OUT_CONTROL_STRIDE(2)";
    case NVC697_SET_STREAM_OUT_CONTROL_STRIDE(3):
        return "NVC697_SET_STREAM_OUT_CONTROL_STRIDE(3)";
    case NVC697_SET_RASTER_INPUT:
        return "NVC697_SET_RASTER_INPUT";
    case NVC697_SET_STREAM_OUTPUT:
        return "NVC697_SET_STREAM_OUTPUT";
    case NVC697_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE:
        return "NVC697_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE";
    case NVC697_SET_HYBRID_ANTI_ALIAS_CONTROL:
        return "NVC697_SET_HYBRID_ANTI_ALIAS_CONTROL";
    case NVC697_SET_SHADER_LOCAL_MEMORY_WINDOW:
        return "NVC697_SET_SHADER_LOCAL_MEMORY_WINDOW";
    case NVC697_SET_SHADER_LOCAL_MEMORY_A:
        return "NVC697_SET_SHADER_LOCAL_MEMORY_A";
    case NVC697_SET_SHADER_LOCAL_MEMORY_B:
        return "NVC697_SET_SHADER_LOCAL_MEMORY_B";
    case NVC697_SET_SHADER_LOCAL_MEMORY_C:
        return "NVC697_SET_SHADER_LOCAL_MEMORY_C";
    case NVC697_SET_SHADER_LOCAL_MEMORY_D:
        return "NVC697_SET_SHADER_LOCAL_MEMORY_D";
    case NVC697_SET_SHADER_LOCAL_MEMORY_E:
        return "NVC697_SET_SHADER_LOCAL_MEMORY_E";
    case NVC697_SET_COLOR_ZERO_BANDWIDTH_CLEAR:
        return "NVC697_SET_COLOR_ZERO_BANDWIDTH_CLEAR";
    case NVC697_SET_Z_ZERO_BANDWIDTH_CLEAR:
        return "NVC697_SET_Z_ZERO_BANDWIDTH_CLEAR";
    case NVC697_SET_STENCIL_ZERO_BANDWIDTH_CLEAR:
        return "NVC697_SET_STENCIL_ZERO_BANDWIDTH_CLEAR";
    case NVC697_SET_ZCULL_REGION_SIZE_A:
        return "NVC697_SET_ZCULL_REGION_SIZE_A";
    case NVC697_SET_ZCULL_REGION_SIZE_B:
        return "NVC697_SET_ZCULL_REGION_SIZE_B";
    case NVC697_SET_ZCULL_REGION_SIZE_C:
        return "NVC697_SET_ZCULL_REGION_SIZE_C";
    case NVC697_SET_ZCULL_REGION_PIXEL_OFFSET_C:
        return "NVC697_SET_ZCULL_REGION_PIXEL_OFFSET_C";
    case NVC697_SET_CULL_BEFORE_FETCH:
        return "NVC697_SET_CULL_BEFORE_FETCH";
    case NVC697_SET_ZCULL_REGION_LOCATION:
        return "NVC697_SET_ZCULL_REGION_LOCATION";
    case NVC697_SET_ZCULL_REGION_ALIQUOTS:
        return "NVC697_SET_ZCULL_REGION_ALIQUOTS";
    case NVC697_SET_ZCULL_STORAGE_A:
        return "NVC697_SET_ZCULL_STORAGE_A";
    case NVC697_SET_ZCULL_STORAGE_B:
        return "NVC697_SET_ZCULL_STORAGE_B";
    case NVC697_SET_ZCULL_STORAGE_C:
        return "NVC697_SET_ZCULL_STORAGE_C";
    case NVC697_SET_ZCULL_STORAGE_D:
        return "NVC697_SET_ZCULL_STORAGE_D";
    case NVC697_SET_ZT_READ_ONLY:
        return "NVC697_SET_ZT_READ_ONLY";
    case NVC697_SET_COLOR_TARGET_A(0):
        return "NVC697_SET_COLOR_TARGET_A(0)";
    case NVC697_SET_COLOR_TARGET_A(1):
        return "NVC697_SET_COLOR_TARGET_A(1)";
    case NVC697_SET_COLOR_TARGET_A(2):
        return "NVC697_SET_COLOR_TARGET_A(2)";
    case NVC697_SET_COLOR_TARGET_A(3):
        return "NVC697_SET_COLOR_TARGET_A(3)";
    case NVC697_SET_COLOR_TARGET_A(4):
        return "NVC697_SET_COLOR_TARGET_A(4)";
    case NVC697_SET_COLOR_TARGET_A(5):
        return "NVC697_SET_COLOR_TARGET_A(5)";
    case NVC697_SET_COLOR_TARGET_A(6):
        return "NVC697_SET_COLOR_TARGET_A(6)";
    case NVC697_SET_COLOR_TARGET_A(7):
        return "NVC697_SET_COLOR_TARGET_A(7)";
    case NVC697_SET_COLOR_TARGET_B(0):
        return "NVC697_SET_COLOR_TARGET_B(0)";
    case NVC697_SET_COLOR_TARGET_B(1):
        return "NVC697_SET_COLOR_TARGET_B(1)";
    case NVC697_SET_COLOR_TARGET_B(2):
        return "NVC697_SET_COLOR_TARGET_B(2)";
    case NVC697_SET_COLOR_TARGET_B(3):
        return "NVC697_SET_COLOR_TARGET_B(3)";
    case NVC697_SET_COLOR_TARGET_B(4):
        return "NVC697_SET_COLOR_TARGET_B(4)";
    case NVC697_SET_COLOR_TARGET_B(5):
        return "NVC697_SET_COLOR_TARGET_B(5)";
    case NVC697_SET_COLOR_TARGET_B(6):
        return "NVC697_SET_COLOR_TARGET_B(6)";
    case NVC697_SET_COLOR_TARGET_B(7):
        return "NVC697_SET_COLOR_TARGET_B(7)";
    case NVC697_SET_COLOR_TARGET_WIDTH(0):
        return "NVC697_SET_COLOR_TARGET_WIDTH(0)";
    case NVC697_SET_COLOR_TARGET_WIDTH(1):
        return "NVC697_SET_COLOR_TARGET_WIDTH(1)";
    case NVC697_SET_COLOR_TARGET_WIDTH(2):
        return "NVC697_SET_COLOR_TARGET_WIDTH(2)";
    case NVC697_SET_COLOR_TARGET_WIDTH(3):
        return "NVC697_SET_COLOR_TARGET_WIDTH(3)";
    case NVC697_SET_COLOR_TARGET_WIDTH(4):
        return "NVC697_SET_COLOR_TARGET_WIDTH(4)";
    case NVC697_SET_COLOR_TARGET_WIDTH(5):
        return "NVC697_SET_COLOR_TARGET_WIDTH(5)";
    case NVC697_SET_COLOR_TARGET_WIDTH(6):
        return "NVC697_SET_COLOR_TARGET_WIDTH(6)";
    case NVC697_SET_COLOR_TARGET_WIDTH(7):
        return "NVC697_SET_COLOR_TARGET_WIDTH(7)";
    case NVC697_SET_COLOR_TARGET_HEIGHT(0):
        return "NVC697_SET_COLOR_TARGET_HEIGHT(0)";
    case NVC697_SET_COLOR_TARGET_HEIGHT(1):
        return "NVC697_SET_COLOR_TARGET_HEIGHT(1)";
    case NVC697_SET_COLOR_TARGET_HEIGHT(2):
        return "NVC697_SET_COLOR_TARGET_HEIGHT(2)";
    case NVC697_SET_COLOR_TARGET_HEIGHT(3):
        return "NVC697_SET_COLOR_TARGET_HEIGHT(3)";
    case NVC697_SET_COLOR_TARGET_HEIGHT(4):
        return "NVC697_SET_COLOR_TARGET_HEIGHT(4)";
    case NVC697_SET_COLOR_TARGET_HEIGHT(5):
        return "NVC697_SET_COLOR_TARGET_HEIGHT(5)";
    case NVC697_SET_COLOR_TARGET_HEIGHT(6):
        return "NVC697_SET_COLOR_TARGET_HEIGHT(6)";
    case NVC697_SET_COLOR_TARGET_HEIGHT(7):
        return "NVC697_SET_COLOR_TARGET_HEIGHT(7)";
    case NVC697_SET_COLOR_TARGET_FORMAT(0):
        return "NVC697_SET_COLOR_TARGET_FORMAT(0)";
    case NVC697_SET_COLOR_TARGET_FORMAT(1):
        return "NVC697_SET_COLOR_TARGET_FORMAT(1)";
    case NVC697_SET_COLOR_TARGET_FORMAT(2):
        return "NVC697_SET_COLOR_TARGET_FORMAT(2)";
    case NVC697_SET_COLOR_TARGET_FORMAT(3):
        return "NVC697_SET_COLOR_TARGET_FORMAT(3)";
    case NVC697_SET_COLOR_TARGET_FORMAT(4):
        return "NVC697_SET_COLOR_TARGET_FORMAT(4)";
    case NVC697_SET_COLOR_TARGET_FORMAT(5):
        return "NVC697_SET_COLOR_TARGET_FORMAT(5)";
    case NVC697_SET_COLOR_TARGET_FORMAT(6):
        return "NVC697_SET_COLOR_TARGET_FORMAT(6)";
    case NVC697_SET_COLOR_TARGET_FORMAT(7):
        return "NVC697_SET_COLOR_TARGET_FORMAT(7)";
    case NVC697_SET_COLOR_TARGET_MEMORY(0):
        return "NVC697_SET_COLOR_TARGET_MEMORY(0)";
    case NVC697_SET_COLOR_TARGET_MEMORY(1):
        return "NVC697_SET_COLOR_TARGET_MEMORY(1)";
    case NVC697_SET_COLOR_TARGET_MEMORY(2):
        return "NVC697_SET_COLOR_TARGET_MEMORY(2)";
    case NVC697_SET_COLOR_TARGET_MEMORY(3):
        return "NVC697_SET_COLOR_TARGET_MEMORY(3)";
    case NVC697_SET_COLOR_TARGET_MEMORY(4):
        return "NVC697_SET_COLOR_TARGET_MEMORY(4)";
    case NVC697_SET_COLOR_TARGET_MEMORY(5):
        return "NVC697_SET_COLOR_TARGET_MEMORY(5)";
    case NVC697_SET_COLOR_TARGET_MEMORY(6):
        return "NVC697_SET_COLOR_TARGET_MEMORY(6)";
    case NVC697_SET_COLOR_TARGET_MEMORY(7):
        return "NVC697_SET_COLOR_TARGET_MEMORY(7)";
    case NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(0):
        return "NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(0)";
    case NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(1):
        return "NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(1)";
    case NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(2):
        return "NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(2)";
    case NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(3):
        return "NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(3)";
    case NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(4):
        return "NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(4)";
    case NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(5):
        return "NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(5)";
    case NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(6):
        return "NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(6)";
    case NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(7):
        return "NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(7)";
    case NVC697_SET_COLOR_TARGET_ARRAY_PITCH(0):
        return "NVC697_SET_COLOR_TARGET_ARRAY_PITCH(0)";
    case NVC697_SET_COLOR_TARGET_ARRAY_PITCH(1):
        return "NVC697_SET_COLOR_TARGET_ARRAY_PITCH(1)";
    case NVC697_SET_COLOR_TARGET_ARRAY_PITCH(2):
        return "NVC697_SET_COLOR_TARGET_ARRAY_PITCH(2)";
    case NVC697_SET_COLOR_TARGET_ARRAY_PITCH(3):
        return "NVC697_SET_COLOR_TARGET_ARRAY_PITCH(3)";
    case NVC697_SET_COLOR_TARGET_ARRAY_PITCH(4):
        return "NVC697_SET_COLOR_TARGET_ARRAY_PITCH(4)";
    case NVC697_SET_COLOR_TARGET_ARRAY_PITCH(5):
        return "NVC697_SET_COLOR_TARGET_ARRAY_PITCH(5)";
    case NVC697_SET_COLOR_TARGET_ARRAY_PITCH(6):
        return "NVC697_SET_COLOR_TARGET_ARRAY_PITCH(6)";
    case NVC697_SET_COLOR_TARGET_ARRAY_PITCH(7):
        return "NVC697_SET_COLOR_TARGET_ARRAY_PITCH(7)";
    case NVC697_SET_COLOR_TARGET_LAYER(0):
        return "NVC697_SET_COLOR_TARGET_LAYER(0)";
    case NVC697_SET_COLOR_TARGET_LAYER(1):
        return "NVC697_SET_COLOR_TARGET_LAYER(1)";
    case NVC697_SET_COLOR_TARGET_LAYER(2):
        return "NVC697_SET_COLOR_TARGET_LAYER(2)";
    case NVC697_SET_COLOR_TARGET_LAYER(3):
        return "NVC697_SET_COLOR_TARGET_LAYER(3)";
    case NVC697_SET_COLOR_TARGET_LAYER(4):
        return "NVC697_SET_COLOR_TARGET_LAYER(4)";
    case NVC697_SET_COLOR_TARGET_LAYER(5):
        return "NVC697_SET_COLOR_TARGET_LAYER(5)";
    case NVC697_SET_COLOR_TARGET_LAYER(6):
        return "NVC697_SET_COLOR_TARGET_LAYER(6)";
    case NVC697_SET_COLOR_TARGET_LAYER(7):
        return "NVC697_SET_COLOR_TARGET_LAYER(7)";
    case NVC697_SET_COLOR_TARGET_RESERVED_A(0):
        return "NVC697_SET_COLOR_TARGET_RESERVED_A(0)";
    case NVC697_SET_COLOR_TARGET_RESERVED_A(1):
        return "NVC697_SET_COLOR_TARGET_RESERVED_A(1)";
    case NVC697_SET_COLOR_TARGET_RESERVED_A(2):
        return "NVC697_SET_COLOR_TARGET_RESERVED_A(2)";
    case NVC697_SET_COLOR_TARGET_RESERVED_A(3):
        return "NVC697_SET_COLOR_TARGET_RESERVED_A(3)";
    case NVC697_SET_COLOR_TARGET_RESERVED_A(4):
        return "NVC697_SET_COLOR_TARGET_RESERVED_A(4)";
    case NVC697_SET_COLOR_TARGET_RESERVED_A(5):
        return "NVC697_SET_COLOR_TARGET_RESERVED_A(5)";
    case NVC697_SET_COLOR_TARGET_RESERVED_A(6):
        return "NVC697_SET_COLOR_TARGET_RESERVED_A(6)";
    case NVC697_SET_COLOR_TARGET_RESERVED_A(7):
        return "NVC697_SET_COLOR_TARGET_RESERVED_A(7)";
    case NVC697_SET_VIEWPORT_SCALE_X(0):
        return "NVC697_SET_VIEWPORT_SCALE_X(0)";
    case NVC697_SET_VIEWPORT_SCALE_X(1):
        return "NVC697_SET_VIEWPORT_SCALE_X(1)";
    case NVC697_SET_VIEWPORT_SCALE_X(2):
        return "NVC697_SET_VIEWPORT_SCALE_X(2)";
    case NVC697_SET_VIEWPORT_SCALE_X(3):
        return "NVC697_SET_VIEWPORT_SCALE_X(3)";
    case NVC697_SET_VIEWPORT_SCALE_X(4):
        return "NVC697_SET_VIEWPORT_SCALE_X(4)";
    case NVC697_SET_VIEWPORT_SCALE_X(5):
        return "NVC697_SET_VIEWPORT_SCALE_X(5)";
    case NVC697_SET_VIEWPORT_SCALE_X(6):
        return "NVC697_SET_VIEWPORT_SCALE_X(6)";
    case NVC697_SET_VIEWPORT_SCALE_X(7):
        return "NVC697_SET_VIEWPORT_SCALE_X(7)";
    case NVC697_SET_VIEWPORT_SCALE_X(8):
        return "NVC697_SET_VIEWPORT_SCALE_X(8)";
    case NVC697_SET_VIEWPORT_SCALE_X(9):
        return "NVC697_SET_VIEWPORT_SCALE_X(9)";
    case NVC697_SET_VIEWPORT_SCALE_X(10):
        return "NVC697_SET_VIEWPORT_SCALE_X(10)";
    case NVC697_SET_VIEWPORT_SCALE_X(11):
        return "NVC697_SET_VIEWPORT_SCALE_X(11)";
    case NVC697_SET_VIEWPORT_SCALE_X(12):
        return "NVC697_SET_VIEWPORT_SCALE_X(12)";
    case NVC697_SET_VIEWPORT_SCALE_X(13):
        return "NVC697_SET_VIEWPORT_SCALE_X(13)";
    case NVC697_SET_VIEWPORT_SCALE_X(14):
        return "NVC697_SET_VIEWPORT_SCALE_X(14)";
    case NVC697_SET_VIEWPORT_SCALE_X(15):
        return "NVC697_SET_VIEWPORT_SCALE_X(15)";
    case NVC697_SET_VIEWPORT_SCALE_Y(0):
        return "NVC697_SET_VIEWPORT_SCALE_Y(0)";
    case NVC697_SET_VIEWPORT_SCALE_Y(1):
        return "NVC697_SET_VIEWPORT_SCALE_Y(1)";
    case NVC697_SET_VIEWPORT_SCALE_Y(2):
        return "NVC697_SET_VIEWPORT_SCALE_Y(2)";
    case NVC697_SET_VIEWPORT_SCALE_Y(3):
        return "NVC697_SET_VIEWPORT_SCALE_Y(3)";
    case NVC697_SET_VIEWPORT_SCALE_Y(4):
        return "NVC697_SET_VIEWPORT_SCALE_Y(4)";
    case NVC697_SET_VIEWPORT_SCALE_Y(5):
        return "NVC697_SET_VIEWPORT_SCALE_Y(5)";
    case NVC697_SET_VIEWPORT_SCALE_Y(6):
        return "NVC697_SET_VIEWPORT_SCALE_Y(6)";
    case NVC697_SET_VIEWPORT_SCALE_Y(7):
        return "NVC697_SET_VIEWPORT_SCALE_Y(7)";
    case NVC697_SET_VIEWPORT_SCALE_Y(8):
        return "NVC697_SET_VIEWPORT_SCALE_Y(8)";
    case NVC697_SET_VIEWPORT_SCALE_Y(9):
        return "NVC697_SET_VIEWPORT_SCALE_Y(9)";
    case NVC697_SET_VIEWPORT_SCALE_Y(10):
        return "NVC697_SET_VIEWPORT_SCALE_Y(10)";
    case NVC697_SET_VIEWPORT_SCALE_Y(11):
        return "NVC697_SET_VIEWPORT_SCALE_Y(11)";
    case NVC697_SET_VIEWPORT_SCALE_Y(12):
        return "NVC697_SET_VIEWPORT_SCALE_Y(12)";
    case NVC697_SET_VIEWPORT_SCALE_Y(13):
        return "NVC697_SET_VIEWPORT_SCALE_Y(13)";
    case NVC697_SET_VIEWPORT_SCALE_Y(14):
        return "NVC697_SET_VIEWPORT_SCALE_Y(14)";
    case NVC697_SET_VIEWPORT_SCALE_Y(15):
        return "NVC697_SET_VIEWPORT_SCALE_Y(15)";
    case NVC697_SET_VIEWPORT_SCALE_Z(0):
        return "NVC697_SET_VIEWPORT_SCALE_Z(0)";
    case NVC697_SET_VIEWPORT_SCALE_Z(1):
        return "NVC697_SET_VIEWPORT_SCALE_Z(1)";
    case NVC697_SET_VIEWPORT_SCALE_Z(2):
        return "NVC697_SET_VIEWPORT_SCALE_Z(2)";
    case NVC697_SET_VIEWPORT_SCALE_Z(3):
        return "NVC697_SET_VIEWPORT_SCALE_Z(3)";
    case NVC697_SET_VIEWPORT_SCALE_Z(4):
        return "NVC697_SET_VIEWPORT_SCALE_Z(4)";
    case NVC697_SET_VIEWPORT_SCALE_Z(5):
        return "NVC697_SET_VIEWPORT_SCALE_Z(5)";
    case NVC697_SET_VIEWPORT_SCALE_Z(6):
        return "NVC697_SET_VIEWPORT_SCALE_Z(6)";
    case NVC697_SET_VIEWPORT_SCALE_Z(7):
        return "NVC697_SET_VIEWPORT_SCALE_Z(7)";
    case NVC697_SET_VIEWPORT_SCALE_Z(8):
        return "NVC697_SET_VIEWPORT_SCALE_Z(8)";
    case NVC697_SET_VIEWPORT_SCALE_Z(9):
        return "NVC697_SET_VIEWPORT_SCALE_Z(9)";
    case NVC697_SET_VIEWPORT_SCALE_Z(10):
        return "NVC697_SET_VIEWPORT_SCALE_Z(10)";
    case NVC697_SET_VIEWPORT_SCALE_Z(11):
        return "NVC697_SET_VIEWPORT_SCALE_Z(11)";
    case NVC697_SET_VIEWPORT_SCALE_Z(12):
        return "NVC697_SET_VIEWPORT_SCALE_Z(12)";
    case NVC697_SET_VIEWPORT_SCALE_Z(13):
        return "NVC697_SET_VIEWPORT_SCALE_Z(13)";
    case NVC697_SET_VIEWPORT_SCALE_Z(14):
        return "NVC697_SET_VIEWPORT_SCALE_Z(14)";
    case NVC697_SET_VIEWPORT_SCALE_Z(15):
        return "NVC697_SET_VIEWPORT_SCALE_Z(15)";
    case NVC697_SET_VIEWPORT_OFFSET_X(0):
        return "NVC697_SET_VIEWPORT_OFFSET_X(0)";
    case NVC697_SET_VIEWPORT_OFFSET_X(1):
        return "NVC697_SET_VIEWPORT_OFFSET_X(1)";
    case NVC697_SET_VIEWPORT_OFFSET_X(2):
        return "NVC697_SET_VIEWPORT_OFFSET_X(2)";
    case NVC697_SET_VIEWPORT_OFFSET_X(3):
        return "NVC697_SET_VIEWPORT_OFFSET_X(3)";
    case NVC697_SET_VIEWPORT_OFFSET_X(4):
        return "NVC697_SET_VIEWPORT_OFFSET_X(4)";
    case NVC697_SET_VIEWPORT_OFFSET_X(5):
        return "NVC697_SET_VIEWPORT_OFFSET_X(5)";
    case NVC697_SET_VIEWPORT_OFFSET_X(6):
        return "NVC697_SET_VIEWPORT_OFFSET_X(6)";
    case NVC697_SET_VIEWPORT_OFFSET_X(7):
        return "NVC697_SET_VIEWPORT_OFFSET_X(7)";
    case NVC697_SET_VIEWPORT_OFFSET_X(8):
        return "NVC697_SET_VIEWPORT_OFFSET_X(8)";
    case NVC697_SET_VIEWPORT_OFFSET_X(9):
        return "NVC697_SET_VIEWPORT_OFFSET_X(9)";
    case NVC697_SET_VIEWPORT_OFFSET_X(10):
        return "NVC697_SET_VIEWPORT_OFFSET_X(10)";
    case NVC697_SET_VIEWPORT_OFFSET_X(11):
        return "NVC697_SET_VIEWPORT_OFFSET_X(11)";
    case NVC697_SET_VIEWPORT_OFFSET_X(12):
        return "NVC697_SET_VIEWPORT_OFFSET_X(12)";
    case NVC697_SET_VIEWPORT_OFFSET_X(13):
        return "NVC697_SET_VIEWPORT_OFFSET_X(13)";
    case NVC697_SET_VIEWPORT_OFFSET_X(14):
        return "NVC697_SET_VIEWPORT_OFFSET_X(14)";
    case NVC697_SET_VIEWPORT_OFFSET_X(15):
        return "NVC697_SET_VIEWPORT_OFFSET_X(15)";
    case NVC697_SET_VIEWPORT_OFFSET_Y(0):
        return "NVC697_SET_VIEWPORT_OFFSET_Y(0)";
    case NVC697_SET_VIEWPORT_OFFSET_Y(1):
        return "NVC697_SET_VIEWPORT_OFFSET_Y(1)";
    case NVC697_SET_VIEWPORT_OFFSET_Y(2):
        return "NVC697_SET_VIEWPORT_OFFSET_Y(2)";
    case NVC697_SET_VIEWPORT_OFFSET_Y(3):
        return "NVC697_SET_VIEWPORT_OFFSET_Y(3)";
    case NVC697_SET_VIEWPORT_OFFSET_Y(4):
        return "NVC697_SET_VIEWPORT_OFFSET_Y(4)";
    case NVC697_SET_VIEWPORT_OFFSET_Y(5):
        return "NVC697_SET_VIEWPORT_OFFSET_Y(5)";
    case NVC697_SET_VIEWPORT_OFFSET_Y(6):
        return "NVC697_SET_VIEWPORT_OFFSET_Y(6)";
    case NVC697_SET_VIEWPORT_OFFSET_Y(7):
        return "NVC697_SET_VIEWPORT_OFFSET_Y(7)";
    case NVC697_SET_VIEWPORT_OFFSET_Y(8):
        return "NVC697_SET_VIEWPORT_OFFSET_Y(8)";
    case NVC697_SET_VIEWPORT_OFFSET_Y(9):
        return "NVC697_SET_VIEWPORT_OFFSET_Y(9)";
    case NVC697_SET_VIEWPORT_OFFSET_Y(10):
        return "NVC697_SET_VIEWPORT_OFFSET_Y(10)";
    case NVC697_SET_VIEWPORT_OFFSET_Y(11):
        return "NVC697_SET_VIEWPORT_OFFSET_Y(11)";
    case NVC697_SET_VIEWPORT_OFFSET_Y(12):
        return "NVC697_SET_VIEWPORT_OFFSET_Y(12)";
    case NVC697_SET_VIEWPORT_OFFSET_Y(13):
        return "NVC697_SET_VIEWPORT_OFFSET_Y(13)";
    case NVC697_SET_VIEWPORT_OFFSET_Y(14):
        return "NVC697_SET_VIEWPORT_OFFSET_Y(14)";
    case NVC697_SET_VIEWPORT_OFFSET_Y(15):
        return "NVC697_SET_VIEWPORT_OFFSET_Y(15)";
    case NVC697_SET_VIEWPORT_OFFSET_Z(0):
        return "NVC697_SET_VIEWPORT_OFFSET_Z(0)";
    case NVC697_SET_VIEWPORT_OFFSET_Z(1):
        return "NVC697_SET_VIEWPORT_OFFSET_Z(1)";
    case NVC697_SET_VIEWPORT_OFFSET_Z(2):
        return "NVC697_SET_VIEWPORT_OFFSET_Z(2)";
    case NVC697_SET_VIEWPORT_OFFSET_Z(3):
        return "NVC697_SET_VIEWPORT_OFFSET_Z(3)";
    case NVC697_SET_VIEWPORT_OFFSET_Z(4):
        return "NVC697_SET_VIEWPORT_OFFSET_Z(4)";
    case NVC697_SET_VIEWPORT_OFFSET_Z(5):
        return "NVC697_SET_VIEWPORT_OFFSET_Z(5)";
    case NVC697_SET_VIEWPORT_OFFSET_Z(6):
        return "NVC697_SET_VIEWPORT_OFFSET_Z(6)";
    case NVC697_SET_VIEWPORT_OFFSET_Z(7):
        return "NVC697_SET_VIEWPORT_OFFSET_Z(7)";
    case NVC697_SET_VIEWPORT_OFFSET_Z(8):
        return "NVC697_SET_VIEWPORT_OFFSET_Z(8)";
    case NVC697_SET_VIEWPORT_OFFSET_Z(9):
        return "NVC697_SET_VIEWPORT_OFFSET_Z(9)";
    case NVC697_SET_VIEWPORT_OFFSET_Z(10):
        return "NVC697_SET_VIEWPORT_OFFSET_Z(10)";
    case NVC697_SET_VIEWPORT_OFFSET_Z(11):
        return "NVC697_SET_VIEWPORT_OFFSET_Z(11)";
    case NVC697_SET_VIEWPORT_OFFSET_Z(12):
        return "NVC697_SET_VIEWPORT_OFFSET_Z(12)";
    case NVC697_SET_VIEWPORT_OFFSET_Z(13):
        return "NVC697_SET_VIEWPORT_OFFSET_Z(13)";
    case NVC697_SET_VIEWPORT_OFFSET_Z(14):
        return "NVC697_SET_VIEWPORT_OFFSET_Z(14)";
    case NVC697_SET_VIEWPORT_OFFSET_Z(15):
        return "NVC697_SET_VIEWPORT_OFFSET_Z(15)";
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(0):
        return "NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(0)";
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(1):
        return "NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(1)";
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(2):
        return "NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(2)";
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(3):
        return "NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(3)";
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(4):
        return "NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(4)";
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(5):
        return "NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(5)";
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(6):
        return "NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(6)";
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(7):
        return "NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(7)";
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(8):
        return "NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(8)";
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(9):
        return "NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(9)";
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(10):
        return "NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(10)";
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(11):
        return "NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(11)";
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(12):
        return "NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(12)";
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(13):
        return "NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(13)";
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(14):
        return "NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(14)";
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(15):
        return "NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(15)";
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(0):
        return "NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(0)";
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(1):
        return "NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(1)";
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(2):
        return "NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(2)";
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(3):
        return "NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(3)";
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(4):
        return "NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(4)";
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(5):
        return "NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(5)";
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(6):
        return "NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(6)";
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(7):
        return "NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(7)";
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(8):
        return "NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(8)";
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(9):
        return "NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(9)";
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(10):
        return "NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(10)";
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(11):
        return "NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(11)";
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(12):
        return "NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(12)";
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(13):
        return "NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(13)";
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(14):
        return "NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(14)";
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(15):
        return "NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(15)";
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(0):
        return "NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(0)";
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(1):
        return "NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(1)";
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(2):
        return "NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(2)";
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(3):
        return "NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(3)";
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(4):
        return "NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(4)";
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(5):
        return "NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(5)";
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(6):
        return "NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(6)";
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(7):
        return "NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(7)";
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(8):
        return "NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(8)";
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(9):
        return "NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(9)";
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(10):
        return "NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(10)";
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(11):
        return "NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(11)";
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(12):
        return "NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(12)";
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(13):
        return "NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(13)";
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(14):
        return "NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(14)";
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(15):
        return "NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(15)";
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(0):
        return "NVC697_SET_VIEWPORT_CLIP_VERTICAL(0)";
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(1):
        return "NVC697_SET_VIEWPORT_CLIP_VERTICAL(1)";
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(2):
        return "NVC697_SET_VIEWPORT_CLIP_VERTICAL(2)";
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(3):
        return "NVC697_SET_VIEWPORT_CLIP_VERTICAL(3)";
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(4):
        return "NVC697_SET_VIEWPORT_CLIP_VERTICAL(4)";
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(5):
        return "NVC697_SET_VIEWPORT_CLIP_VERTICAL(5)";
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(6):
        return "NVC697_SET_VIEWPORT_CLIP_VERTICAL(6)";
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(7):
        return "NVC697_SET_VIEWPORT_CLIP_VERTICAL(7)";
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(8):
        return "NVC697_SET_VIEWPORT_CLIP_VERTICAL(8)";
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(9):
        return "NVC697_SET_VIEWPORT_CLIP_VERTICAL(9)";
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(10):
        return "NVC697_SET_VIEWPORT_CLIP_VERTICAL(10)";
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(11):
        return "NVC697_SET_VIEWPORT_CLIP_VERTICAL(11)";
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(12):
        return "NVC697_SET_VIEWPORT_CLIP_VERTICAL(12)";
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(13):
        return "NVC697_SET_VIEWPORT_CLIP_VERTICAL(13)";
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(14):
        return "NVC697_SET_VIEWPORT_CLIP_VERTICAL(14)";
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(15):
        return "NVC697_SET_VIEWPORT_CLIP_VERTICAL(15)";
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(0):
        return "NVC697_SET_VIEWPORT_CLIP_MIN_Z(0)";
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(1):
        return "NVC697_SET_VIEWPORT_CLIP_MIN_Z(1)";
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(2):
        return "NVC697_SET_VIEWPORT_CLIP_MIN_Z(2)";
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(3):
        return "NVC697_SET_VIEWPORT_CLIP_MIN_Z(3)";
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(4):
        return "NVC697_SET_VIEWPORT_CLIP_MIN_Z(4)";
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(5):
        return "NVC697_SET_VIEWPORT_CLIP_MIN_Z(5)";
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(6):
        return "NVC697_SET_VIEWPORT_CLIP_MIN_Z(6)";
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(7):
        return "NVC697_SET_VIEWPORT_CLIP_MIN_Z(7)";
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(8):
        return "NVC697_SET_VIEWPORT_CLIP_MIN_Z(8)";
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(9):
        return "NVC697_SET_VIEWPORT_CLIP_MIN_Z(9)";
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(10):
        return "NVC697_SET_VIEWPORT_CLIP_MIN_Z(10)";
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(11):
        return "NVC697_SET_VIEWPORT_CLIP_MIN_Z(11)";
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(12):
        return "NVC697_SET_VIEWPORT_CLIP_MIN_Z(12)";
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(13):
        return "NVC697_SET_VIEWPORT_CLIP_MIN_Z(13)";
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(14):
        return "NVC697_SET_VIEWPORT_CLIP_MIN_Z(14)";
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(15):
        return "NVC697_SET_VIEWPORT_CLIP_MIN_Z(15)";
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(0):
        return "NVC697_SET_VIEWPORT_CLIP_MAX_Z(0)";
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(1):
        return "NVC697_SET_VIEWPORT_CLIP_MAX_Z(1)";
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(2):
        return "NVC697_SET_VIEWPORT_CLIP_MAX_Z(2)";
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(3):
        return "NVC697_SET_VIEWPORT_CLIP_MAX_Z(3)";
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(4):
        return "NVC697_SET_VIEWPORT_CLIP_MAX_Z(4)";
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(5):
        return "NVC697_SET_VIEWPORT_CLIP_MAX_Z(5)";
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(6):
        return "NVC697_SET_VIEWPORT_CLIP_MAX_Z(6)";
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(7):
        return "NVC697_SET_VIEWPORT_CLIP_MAX_Z(7)";
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(8):
        return "NVC697_SET_VIEWPORT_CLIP_MAX_Z(8)";
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(9):
        return "NVC697_SET_VIEWPORT_CLIP_MAX_Z(9)";
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(10):
        return "NVC697_SET_VIEWPORT_CLIP_MAX_Z(10)";
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(11):
        return "NVC697_SET_VIEWPORT_CLIP_MAX_Z(11)";
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(12):
        return "NVC697_SET_VIEWPORT_CLIP_MAX_Z(12)";
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(13):
        return "NVC697_SET_VIEWPORT_CLIP_MAX_Z(13)";
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(14):
        return "NVC697_SET_VIEWPORT_CLIP_MAX_Z(14)";
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(15):
        return "NVC697_SET_VIEWPORT_CLIP_MAX_Z(15)";
    case NVC697_SET_WINDOW_CLIP_HORIZONTAL(0):
        return "NVC697_SET_WINDOW_CLIP_HORIZONTAL(0)";
    case NVC697_SET_WINDOW_CLIP_HORIZONTAL(1):
        return "NVC697_SET_WINDOW_CLIP_HORIZONTAL(1)";
    case NVC697_SET_WINDOW_CLIP_HORIZONTAL(2):
        return "NVC697_SET_WINDOW_CLIP_HORIZONTAL(2)";
    case NVC697_SET_WINDOW_CLIP_HORIZONTAL(3):
        return "NVC697_SET_WINDOW_CLIP_HORIZONTAL(3)";
    case NVC697_SET_WINDOW_CLIP_HORIZONTAL(4):
        return "NVC697_SET_WINDOW_CLIP_HORIZONTAL(4)";
    case NVC697_SET_WINDOW_CLIP_HORIZONTAL(5):
        return "NVC697_SET_WINDOW_CLIP_HORIZONTAL(5)";
    case NVC697_SET_WINDOW_CLIP_HORIZONTAL(6):
        return "NVC697_SET_WINDOW_CLIP_HORIZONTAL(6)";
    case NVC697_SET_WINDOW_CLIP_HORIZONTAL(7):
        return "NVC697_SET_WINDOW_CLIP_HORIZONTAL(7)";
    case NVC697_SET_WINDOW_CLIP_VERTICAL(0):
        return "NVC697_SET_WINDOW_CLIP_VERTICAL(0)";
    case NVC697_SET_WINDOW_CLIP_VERTICAL(1):
        return "NVC697_SET_WINDOW_CLIP_VERTICAL(1)";
    case NVC697_SET_WINDOW_CLIP_VERTICAL(2):
        return "NVC697_SET_WINDOW_CLIP_VERTICAL(2)";
    case NVC697_SET_WINDOW_CLIP_VERTICAL(3):
        return "NVC697_SET_WINDOW_CLIP_VERTICAL(3)";
    case NVC697_SET_WINDOW_CLIP_VERTICAL(4):
        return "NVC697_SET_WINDOW_CLIP_VERTICAL(4)";
    case NVC697_SET_WINDOW_CLIP_VERTICAL(5):
        return "NVC697_SET_WINDOW_CLIP_VERTICAL(5)";
    case NVC697_SET_WINDOW_CLIP_VERTICAL(6):
        return "NVC697_SET_WINDOW_CLIP_VERTICAL(6)";
    case NVC697_SET_WINDOW_CLIP_VERTICAL(7):
        return "NVC697_SET_WINDOW_CLIP_VERTICAL(7)";
    case NVC697_SET_CLIP_ID_EXTENT_X(0):
        return "NVC697_SET_CLIP_ID_EXTENT_X(0)";
    case NVC697_SET_CLIP_ID_EXTENT_X(1):
        return "NVC697_SET_CLIP_ID_EXTENT_X(1)";
    case NVC697_SET_CLIP_ID_EXTENT_X(2):
        return "NVC697_SET_CLIP_ID_EXTENT_X(2)";
    case NVC697_SET_CLIP_ID_EXTENT_X(3):
        return "NVC697_SET_CLIP_ID_EXTENT_X(3)";
    case NVC697_SET_CLIP_ID_EXTENT_Y(0):
        return "NVC697_SET_CLIP_ID_EXTENT_Y(0)";
    case NVC697_SET_CLIP_ID_EXTENT_Y(1):
        return "NVC697_SET_CLIP_ID_EXTENT_Y(1)";
    case NVC697_SET_CLIP_ID_EXTENT_Y(2):
        return "NVC697_SET_CLIP_ID_EXTENT_Y(2)";
    case NVC697_SET_CLIP_ID_EXTENT_Y(3):
        return "NVC697_SET_CLIP_ID_EXTENT_Y(3)";
    case NVC697_SET_MAX_STREAM_OUTPUT_GS_INSTANCES_PER_TASK:
        return "NVC697_SET_MAX_STREAM_OUTPUT_GS_INSTANCES_PER_TASK";
    case NVC697_SET_API_VISIBLE_CALL_LIMIT:
        return "NVC697_SET_API_VISIBLE_CALL_LIMIT";
    case NVC697_SET_STATISTICS_COUNTER:
        return "NVC697_SET_STATISTICS_COUNTER";
    case NVC697_SET_CLEAR_RECT_HORIZONTAL:
        return "NVC697_SET_CLEAR_RECT_HORIZONTAL";
    case NVC697_SET_CLEAR_RECT_VERTICAL:
        return "NVC697_SET_CLEAR_RECT_VERTICAL";
    case NVC697_SET_VERTEX_ARRAY_START:
        return "NVC697_SET_VERTEX_ARRAY_START";
    case NVC697_DRAW_VERTEX_ARRAY:
        return "NVC697_DRAW_VERTEX_ARRAY";
    case NVC697_SET_VIEWPORT_Z_CLIP:
        return "NVC697_SET_VIEWPORT_Z_CLIP";
    case NVC697_SET_COLOR_CLEAR_VALUE(0):
        return "NVC697_SET_COLOR_CLEAR_VALUE(0)";
    case NVC697_SET_COLOR_CLEAR_VALUE(1):
        return "NVC697_SET_COLOR_CLEAR_VALUE(1)";
    case NVC697_SET_COLOR_CLEAR_VALUE(2):
        return "NVC697_SET_COLOR_CLEAR_VALUE(2)";
    case NVC697_SET_COLOR_CLEAR_VALUE(3):
        return "NVC697_SET_COLOR_CLEAR_VALUE(3)";
    case NVC697_SET_Z_CLEAR_VALUE:
        return "NVC697_SET_Z_CLEAR_VALUE";
    case NVC697_SET_SHADER_CACHE_CONTROL:
        return "NVC697_SET_SHADER_CACHE_CONTROL";
    case NVC697_FORCE_TRANSITION_TO_BETA:
        return "NVC697_FORCE_TRANSITION_TO_BETA";
    case NVC697_SET_REDUCE_COLOR_THRESHOLDS_ENABLE:
        return "NVC697_SET_REDUCE_COLOR_THRESHOLDS_ENABLE";
    case NVC697_SET_STENCIL_CLEAR_VALUE:
        return "NVC697_SET_STENCIL_CLEAR_VALUE";
    case NVC697_INVALIDATE_SHADER_CACHES_NO_WFI:
        return "NVC697_INVALIDATE_SHADER_CACHES_NO_WFI";
    case NVC697_SET_ZCULL_SERIALIZATION:
        return "NVC697_SET_ZCULL_SERIALIZATION";
    case NVC697_SET_FRONT_POLYGON_MODE:
        return "NVC697_SET_FRONT_POLYGON_MODE";
    case NVC697_SET_BACK_POLYGON_MODE:
        return "NVC697_SET_BACK_POLYGON_MODE";
    case NVC697_SET_POLY_SMOOTH:
        return "NVC697_SET_POLY_SMOOTH";
    case NVC697_SET_ZCULL_DIR_FORMAT:
        return "NVC697_SET_ZCULL_DIR_FORMAT";
    case NVC697_SET_POLY_OFFSET_POINT:
        return "NVC697_SET_POLY_OFFSET_POINT";
    case NVC697_SET_POLY_OFFSET_LINE:
        return "NVC697_SET_POLY_OFFSET_LINE";
    case NVC697_SET_POLY_OFFSET_FILL:
        return "NVC697_SET_POLY_OFFSET_FILL";
    case NVC697_SET_PATCH:
        return "NVC697_SET_PATCH";
    case NVC697_SET_ITERATED_BLEND:
        return "NVC697_SET_ITERATED_BLEND";
    case NVC697_SET_ITERATED_BLEND_PASS:
        return "NVC697_SET_ITERATED_BLEND_PASS";
    case NVC697_SET_ZCULL_CRITERION:
        return "NVC697_SET_ZCULL_CRITERION";
    case NVC697_PIXEL_SHADER_BARRIER:
        return "NVC697_PIXEL_SHADER_BARRIER";
    case NVC697_SET_SM_TIMEOUT_INTERVAL:
        return "NVC697_SET_SM_TIMEOUT_INTERVAL";
    case NVC697_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY:
        return "NVC697_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY";
    case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_POINTER:
        return "NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_POINTER";
    case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION:
        return "NVC697_LOAD_ITERATED_BLEND_INSTRUCTION";
    case NVC697_SET_WINDOW_OFFSET_X:
        return "NVC697_SET_WINDOW_OFFSET_X";
    case NVC697_SET_WINDOW_OFFSET_Y:
        return "NVC697_SET_WINDOW_OFFSET_Y";
    case NVC697_SET_SCISSOR_ENABLE(0):
        return "NVC697_SET_SCISSOR_ENABLE(0)";
    case NVC697_SET_SCISSOR_ENABLE(1):
        return "NVC697_SET_SCISSOR_ENABLE(1)";
    case NVC697_SET_SCISSOR_ENABLE(2):
        return "NVC697_SET_SCISSOR_ENABLE(2)";
    case NVC697_SET_SCISSOR_ENABLE(3):
        return "NVC697_SET_SCISSOR_ENABLE(3)";
    case NVC697_SET_SCISSOR_ENABLE(4):
        return "NVC697_SET_SCISSOR_ENABLE(4)";
    case NVC697_SET_SCISSOR_ENABLE(5):
        return "NVC697_SET_SCISSOR_ENABLE(5)";
    case NVC697_SET_SCISSOR_ENABLE(6):
        return "NVC697_SET_SCISSOR_ENABLE(6)";
    case NVC697_SET_SCISSOR_ENABLE(7):
        return "NVC697_SET_SCISSOR_ENABLE(7)";
    case NVC697_SET_SCISSOR_ENABLE(8):
        return "NVC697_SET_SCISSOR_ENABLE(8)";
    case NVC697_SET_SCISSOR_ENABLE(9):
        return "NVC697_SET_SCISSOR_ENABLE(9)";
    case NVC697_SET_SCISSOR_ENABLE(10):
        return "NVC697_SET_SCISSOR_ENABLE(10)";
    case NVC697_SET_SCISSOR_ENABLE(11):
        return "NVC697_SET_SCISSOR_ENABLE(11)";
    case NVC697_SET_SCISSOR_ENABLE(12):
        return "NVC697_SET_SCISSOR_ENABLE(12)";
    case NVC697_SET_SCISSOR_ENABLE(13):
        return "NVC697_SET_SCISSOR_ENABLE(13)";
    case NVC697_SET_SCISSOR_ENABLE(14):
        return "NVC697_SET_SCISSOR_ENABLE(14)";
    case NVC697_SET_SCISSOR_ENABLE(15):
        return "NVC697_SET_SCISSOR_ENABLE(15)";
    case NVC697_SET_SCISSOR_HORIZONTAL(0):
        return "NVC697_SET_SCISSOR_HORIZONTAL(0)";
    case NVC697_SET_SCISSOR_HORIZONTAL(1):
        return "NVC697_SET_SCISSOR_HORIZONTAL(1)";
    case NVC697_SET_SCISSOR_HORIZONTAL(2):
        return "NVC697_SET_SCISSOR_HORIZONTAL(2)";
    case NVC697_SET_SCISSOR_HORIZONTAL(3):
        return "NVC697_SET_SCISSOR_HORIZONTAL(3)";
    case NVC697_SET_SCISSOR_HORIZONTAL(4):
        return "NVC697_SET_SCISSOR_HORIZONTAL(4)";
    case NVC697_SET_SCISSOR_HORIZONTAL(5):
        return "NVC697_SET_SCISSOR_HORIZONTAL(5)";
    case NVC697_SET_SCISSOR_HORIZONTAL(6):
        return "NVC697_SET_SCISSOR_HORIZONTAL(6)";
    case NVC697_SET_SCISSOR_HORIZONTAL(7):
        return "NVC697_SET_SCISSOR_HORIZONTAL(7)";
    case NVC697_SET_SCISSOR_HORIZONTAL(8):
        return "NVC697_SET_SCISSOR_HORIZONTAL(8)";
    case NVC697_SET_SCISSOR_HORIZONTAL(9):
        return "NVC697_SET_SCISSOR_HORIZONTAL(9)";
    case NVC697_SET_SCISSOR_HORIZONTAL(10):
        return "NVC697_SET_SCISSOR_HORIZONTAL(10)";
    case NVC697_SET_SCISSOR_HORIZONTAL(11):
        return "NVC697_SET_SCISSOR_HORIZONTAL(11)";
    case NVC697_SET_SCISSOR_HORIZONTAL(12):
        return "NVC697_SET_SCISSOR_HORIZONTAL(12)";
    case NVC697_SET_SCISSOR_HORIZONTAL(13):
        return "NVC697_SET_SCISSOR_HORIZONTAL(13)";
    case NVC697_SET_SCISSOR_HORIZONTAL(14):
        return "NVC697_SET_SCISSOR_HORIZONTAL(14)";
    case NVC697_SET_SCISSOR_HORIZONTAL(15):
        return "NVC697_SET_SCISSOR_HORIZONTAL(15)";
    case NVC697_SET_SCISSOR_VERTICAL(0):
        return "NVC697_SET_SCISSOR_VERTICAL(0)";
    case NVC697_SET_SCISSOR_VERTICAL(1):
        return "NVC697_SET_SCISSOR_VERTICAL(1)";
    case NVC697_SET_SCISSOR_VERTICAL(2):
        return "NVC697_SET_SCISSOR_VERTICAL(2)";
    case NVC697_SET_SCISSOR_VERTICAL(3):
        return "NVC697_SET_SCISSOR_VERTICAL(3)";
    case NVC697_SET_SCISSOR_VERTICAL(4):
        return "NVC697_SET_SCISSOR_VERTICAL(4)";
    case NVC697_SET_SCISSOR_VERTICAL(5):
        return "NVC697_SET_SCISSOR_VERTICAL(5)";
    case NVC697_SET_SCISSOR_VERTICAL(6):
        return "NVC697_SET_SCISSOR_VERTICAL(6)";
    case NVC697_SET_SCISSOR_VERTICAL(7):
        return "NVC697_SET_SCISSOR_VERTICAL(7)";
    case NVC697_SET_SCISSOR_VERTICAL(8):
        return "NVC697_SET_SCISSOR_VERTICAL(8)";
    case NVC697_SET_SCISSOR_VERTICAL(9):
        return "NVC697_SET_SCISSOR_VERTICAL(9)";
    case NVC697_SET_SCISSOR_VERTICAL(10):
        return "NVC697_SET_SCISSOR_VERTICAL(10)";
    case NVC697_SET_SCISSOR_VERTICAL(11):
        return "NVC697_SET_SCISSOR_VERTICAL(11)";
    case NVC697_SET_SCISSOR_VERTICAL(12):
        return "NVC697_SET_SCISSOR_VERTICAL(12)";
    case NVC697_SET_SCISSOR_VERTICAL(13):
        return "NVC697_SET_SCISSOR_VERTICAL(13)";
    case NVC697_SET_SCISSOR_VERTICAL(14):
        return "NVC697_SET_SCISSOR_VERTICAL(14)";
    case NVC697_SET_SCISSOR_VERTICAL(15):
        return "NVC697_SET_SCISSOR_VERTICAL(15)";
    case NVC697_SET_VPC_PERF_KNOB:
        return "NVC697_SET_VPC_PERF_KNOB";
    case NVC697_PM_LOCAL_TRIGGER:
        return "NVC697_PM_LOCAL_TRIGGER";
    case NVC697_SET_POST_Z_PS_IMASK:
        return "NVC697_SET_POST_Z_PS_IMASK";
    case NVC697_SET_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(0):
        return "NVC697_SET_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(0)";
    case NVC697_SET_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(1):
        return "NVC697_SET_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(1)";
    case NVC697_SET_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(2):
        return "NVC697_SET_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(2)";
    case NVC697_SET_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(3):
        return "NVC697_SET_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(3)";
    case NVC697_SET_SPARE_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(0):
        return "NVC697_SET_SPARE_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(0)";
    case NVC697_SET_SPARE_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(1):
        return "NVC697_SET_SPARE_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(1)";
    case NVC697_SET_SPARE_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(2):
        return "NVC697_SET_SPARE_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(2)";
    case NVC697_SET_SPARE_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(3):
        return "NVC697_SET_SPARE_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(3)";
    case NVC697_SET_CONSTANT_COLOR_RENDERING:
        return "NVC697_SET_CONSTANT_COLOR_RENDERING";
    case NVC697_SET_CONSTANT_COLOR_RENDERING_RED:
        return "NVC697_SET_CONSTANT_COLOR_RENDERING_RED";
    case NVC697_SET_CONSTANT_COLOR_RENDERING_GREEN:
        return "NVC697_SET_CONSTANT_COLOR_RENDERING_GREEN";
    case NVC697_SET_CONSTANT_COLOR_RENDERING_BLUE:
        return "NVC697_SET_CONSTANT_COLOR_RENDERING_BLUE";
    case NVC697_SET_CONSTANT_COLOR_RENDERING_ALPHA:
        return "NVC697_SET_CONSTANT_COLOR_RENDERING_ALPHA";
    case NVC697_SET_BACK_STENCIL_FUNC_REF:
        return "NVC697_SET_BACK_STENCIL_FUNC_REF";
    case NVC697_SET_BACK_STENCIL_MASK:
        return "NVC697_SET_BACK_STENCIL_MASK";
    case NVC697_SET_BACK_STENCIL_FUNC_MASK:
        return "NVC697_SET_BACK_STENCIL_FUNC_MASK";
    case NVC697_SET_VERTEX_STREAM_SUBSTITUTE_A:
        return "NVC697_SET_VERTEX_STREAM_SUBSTITUTE_A";
    case NVC697_SET_VERTEX_STREAM_SUBSTITUTE_B:
        return "NVC697_SET_VERTEX_STREAM_SUBSTITUTE_B";
    case NVC697_SET_LINE_MODE_POLYGON_CLIP:
        return "NVC697_SET_LINE_MODE_POLYGON_CLIP";
    case NVC697_SET_SINGLE_CT_WRITE_CONTROL:
        return "NVC697_SET_SINGLE_CT_WRITE_CONTROL";
    case NVC697_SET_VTG_WARP_WATERMARKS:
        return "NVC697_SET_VTG_WARP_WATERMARKS";
    case NVC697_SET_DEPTH_BOUNDS_MIN:
        return "NVC697_SET_DEPTH_BOUNDS_MIN";
    case NVC697_SET_DEPTH_BOUNDS_MAX:
        return "NVC697_SET_DEPTH_BOUNDS_MAX";
    case NVC697_SET_SAMPLE_MASK:
        return "NVC697_SET_SAMPLE_MASK";
    case NVC697_SET_COLOR_TARGET_SAMPLE_MASK:
        return "NVC697_SET_COLOR_TARGET_SAMPLE_MASK";
    case NVC697_SET_CT_MRT_ENABLE:
        return "NVC697_SET_CT_MRT_ENABLE";
    case NVC697_SET_NONMULTISAMPLED_Z:
        return "NVC697_SET_NONMULTISAMPLED_Z";
    case NVC697_SET_TIR:
        return "NVC697_SET_TIR";
    case NVC697_SET_ANTI_ALIAS_RASTER:
        return "NVC697_SET_ANTI_ALIAS_RASTER";
    case NVC697_SET_SAMPLE_MASK_X0_Y0:
        return "NVC697_SET_SAMPLE_MASK_X0_Y0";
    case NVC697_SET_SAMPLE_MASK_X1_Y0:
        return "NVC697_SET_SAMPLE_MASK_X1_Y0";
    case NVC697_SET_SAMPLE_MASK_X0_Y1:
        return "NVC697_SET_SAMPLE_MASK_X0_Y1";
    case NVC697_SET_SAMPLE_MASK_X1_Y1:
        return "NVC697_SET_SAMPLE_MASK_X1_Y1";
    case NVC697_SET_SURFACE_CLIP_ID_MEMORY_A:
        return "NVC697_SET_SURFACE_CLIP_ID_MEMORY_A";
    case NVC697_SET_SURFACE_CLIP_ID_MEMORY_B:
        return "NVC697_SET_SURFACE_CLIP_ID_MEMORY_B";
    case NVC697_SET_TIR_MODULATION:
        return "NVC697_SET_TIR_MODULATION";
    case NVC697_SET_TIR_MODULATION_FUNCTION:
        return "NVC697_SET_TIR_MODULATION_FUNCTION";
    case NVC697_SET_BLEND_OPT_CONTROL:
        return "NVC697_SET_BLEND_OPT_CONTROL";
    case NVC697_SET_ZT_A:
        return "NVC697_SET_ZT_A";
    case NVC697_SET_ZT_B:
        return "NVC697_SET_ZT_B";
    case NVC697_SET_ZT_FORMAT:
        return "NVC697_SET_ZT_FORMAT";
    case NVC697_SET_ZT_BLOCK_SIZE:
        return "NVC697_SET_ZT_BLOCK_SIZE";
    case NVC697_SET_ZT_ARRAY_PITCH:
        return "NVC697_SET_ZT_ARRAY_PITCH";
    case NVC697_SET_SURFACE_CLIP_HORIZONTAL:
        return "NVC697_SET_SURFACE_CLIP_HORIZONTAL";
    case NVC697_SET_SURFACE_CLIP_VERTICAL:
        return "NVC697_SET_SURFACE_CLIP_VERTICAL";
    case NVC697_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS:
        return "NVC697_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS";
    case NVC697_SET_VIEWPORT_MULTICAST:
        return "NVC697_SET_VIEWPORT_MULTICAST";
    case NVC697_SET_TESSELLATION_CUT_HEIGHT:
        return "NVC697_SET_TESSELLATION_CUT_HEIGHT";
    case NVC697_SET_MAX_GS_INSTANCES_PER_TASK:
        return "NVC697_SET_MAX_GS_INSTANCES_PER_TASK";
    case NVC697_SET_MAX_GS_OUTPUT_VERTICES_PER_TASK:
        return "NVC697_SET_MAX_GS_OUTPUT_VERTICES_PER_TASK";
    case NVC697_SET_RESERVED_SW_METHOD00:
        return "NVC697_SET_RESERVED_SW_METHOD00";
    case NVC697_SET_GS_OUTPUT_CB_STORAGE_MULTIPLIER:
        return "NVC697_SET_GS_OUTPUT_CB_STORAGE_MULTIPLIER";
    case NVC697_SET_BETA_CB_STORAGE_CONSTRAINT:
        return "NVC697_SET_BETA_CB_STORAGE_CONSTRAINT";
    case NVC697_SET_TI_OUTPUT_CB_STORAGE_MULTIPLIER:
        return "NVC697_SET_TI_OUTPUT_CB_STORAGE_MULTIPLIER";
    case NVC697_SET_ALPHA_CB_STORAGE_CONSTRAINT:
        return "NVC697_SET_ALPHA_CB_STORAGE_CONSTRAINT";
    case NVC697_SET_RESERVED_SW_METHOD01:
        return "NVC697_SET_RESERVED_SW_METHOD01";
    case NVC697_SET_RESERVED_SW_METHOD02:
        return "NVC697_SET_RESERVED_SW_METHOD02";
        case NVC697_SET_SPARE_NOOP01:
        return "NVC697_SET_SPARE_NOOP01";
    case NVC697_SET_SPARE_NOOP02:
        return "NVC697_SET_SPARE_NOOP02";
    case NVC697_SET_SPARE_NOOP03:
        return "NVC697_SET_SPARE_NOOP03";
    case NVC697_SET_SPARE_NOOP04:
        return "NVC697_SET_SPARE_NOOP04";
    case NVC697_SET_SPARE_NOOP05:
        return "NVC697_SET_SPARE_NOOP05";
    case NVC697_SET_SPARE_NOOP06:
        return "NVC697_SET_SPARE_NOOP06";
    case NVC697_SET_SPARE_NOOP07:
        return "NVC697_SET_SPARE_NOOP07";
    case NVC697_SET_SPARE_NOOP08:
        return "NVC697_SET_SPARE_NOOP08";
    case NVC697_SET_SPARE_NOOP09:
        return "NVC697_SET_SPARE_NOOP09";
    case NVC697_SET_SPARE_NOOP10:
        return "NVC697_SET_SPARE_NOOP10";
    case NVC697_SET_SPARE_NOOP11:
        return "NVC697_SET_SPARE_NOOP11";
    case NVC697_SET_SPARE_NOOP12:
        return "NVC697_SET_SPARE_NOOP12";
    case NVC697_SET_SPARE_NOOP13:
        return "NVC697_SET_SPARE_NOOP13";
    case NVC697_SET_SPARE_NOOP14:
        return "NVC697_SET_SPARE_NOOP14";
    case NVC697_SET_SPARE_NOOP15:
        return "NVC697_SET_SPARE_NOOP15";
    case NVC697_SET_RESERVED_SW_METHOD03:
        return "NVC697_SET_RESERVED_SW_METHOD03";
    case NVC697_SET_RESERVED_SW_METHOD04:
        return "NVC697_SET_RESERVED_SW_METHOD04";
    case NVC697_SET_RESERVED_SW_METHOD05:
        return "NVC697_SET_RESERVED_SW_METHOD05";
    case NVC697_SET_RESERVED_SW_METHOD06:
        return "NVC697_SET_RESERVED_SW_METHOD06";
    case NVC697_SET_RESERVED_SW_METHOD07:
        return "NVC697_SET_RESERVED_SW_METHOD07";
    case NVC697_SET_RESERVED_SW_METHOD08:
        return "NVC697_SET_RESERVED_SW_METHOD08";
    case NVC697_SET_RESERVED_SW_METHOD09:
        return "NVC697_SET_RESERVED_SW_METHOD09";
    case NVC697_SET_REDUCE_COLOR_THRESHOLDS_UNORM8:
        return "NVC697_SET_REDUCE_COLOR_THRESHOLDS_UNORM8";
    case NVC697_SET_RESERVED_SW_METHOD10:
        return "NVC697_SET_RESERVED_SW_METHOD10";
    case NVC697_SET_RESERVED_SW_METHOD11:
        return "NVC697_SET_RESERVED_SW_METHOD11";
    case NVC697_SET_RESERVED_SW_METHOD12:
        return "NVC697_SET_RESERVED_SW_METHOD12";
    case NVC697_SET_RESERVED_SW_METHOD13:
        return "NVC697_SET_RESERVED_SW_METHOD13";
    case NVC697_SET_REDUCE_COLOR_THRESHOLDS_UNORM10:
        return "NVC697_SET_REDUCE_COLOR_THRESHOLDS_UNORM10";
    case NVC697_SET_REDUCE_COLOR_THRESHOLDS_UNORM16:
        return "NVC697_SET_REDUCE_COLOR_THRESHOLDS_UNORM16";
    case NVC697_SET_REDUCE_COLOR_THRESHOLDS_FP11:
        return "NVC697_SET_REDUCE_COLOR_THRESHOLDS_FP11";
    case NVC697_SET_REDUCE_COLOR_THRESHOLDS_FP16:
        return "NVC697_SET_REDUCE_COLOR_THRESHOLDS_FP16";
    case NVC697_SET_REDUCE_COLOR_THRESHOLDS_SRGB8:
        return "NVC697_SET_REDUCE_COLOR_THRESHOLDS_SRGB8";
    case NVC697_UNBIND_ALL:
        return "NVC697_UNBIND_ALL";
    case NVC697_SET_CLEAR_SURFACE_CONTROL:
        return "NVC697_SET_CLEAR_SURFACE_CONTROL";
    case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS:
        return "NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS";
    case NVC697_SET_RESERVED_SW_METHOD14:
        return "NVC697_SET_RESERVED_SW_METHOD14";
    case NVC697_SET_RESERVED_SW_METHOD15:
        return "NVC697_SET_RESERVED_SW_METHOD15";
    case NVC697_NO_OPERATION_DATA_HI:
        return "NVC697_NO_OPERATION_DATA_HI";
    case NVC697_SET_DEPTH_BIAS_CONTROL:
        return "NVC697_SET_DEPTH_BIAS_CONTROL";
    case NVC697_PM_TRIGGER_END:
        return "NVC697_PM_TRIGGER_END";
    case NVC697_SET_VERTEX_ID_BASE:
        return "NVC697_SET_VERTEX_ID_BASE";
    case NVC697_SET_STENCIL_COMPRESSION:
        return "NVC697_SET_STENCIL_COMPRESSION";
            case NVC697_SET_TIR_CONTROL:
        return "NVC697_SET_TIR_CONTROL";
    case NVC697_SET_MUTABLE_METHOD_CONTROL:
        return "NVC697_SET_MUTABLE_METHOD_CONTROL";
    case NVC697_SET_POST_PS_INITIAL_COVERAGE:
        return "NVC697_SET_POST_PS_INITIAL_COVERAGE";
    case NVC697_SET_FILL_VIA_TRIANGLE:
        return "NVC697_SET_FILL_VIA_TRIANGLE";
    case NVC697_SET_BLEND_PER_FORMAT_ENABLE:
        return "NVC697_SET_BLEND_PER_FORMAT_ENABLE";
    case NVC697_FLUSH_PENDING_WRITES:
        return "NVC697_FLUSH_PENDING_WRITES";
    case NVC697_SET_CONSERVATIVE_RASTER:
        return "NVC697_SET_CONSERVATIVE_RASTER";
    case NVC697_SET_MESH_CONTROL:
        return "NVC697_SET_MESH_CONTROL";
    case NVC697_SET_MESH_SHADER_A:
        return "NVC697_SET_MESH_SHADER_A";
    case NVC697_SET_MESH_SHADER_B:
        return "NVC697_SET_MESH_SHADER_B";
    case NVC697_SET_MESH_INIT_SHADER:
        return "NVC697_SET_MESH_INIT_SHADER";
    case NVC697_SET_VERTEX_ATTRIBUTE_A(0):
        return "NVC697_SET_VERTEX_ATTRIBUTE_A(0)";
    case NVC697_SET_VERTEX_ATTRIBUTE_A(1):
        return "NVC697_SET_VERTEX_ATTRIBUTE_A(1)";
    case NVC697_SET_VERTEX_ATTRIBUTE_A(2):
        return "NVC697_SET_VERTEX_ATTRIBUTE_A(2)";
    case NVC697_SET_VERTEX_ATTRIBUTE_A(3):
        return "NVC697_SET_VERTEX_ATTRIBUTE_A(3)";
    case NVC697_SET_VERTEX_ATTRIBUTE_A(4):
        return "NVC697_SET_VERTEX_ATTRIBUTE_A(4)";
    case NVC697_SET_VERTEX_ATTRIBUTE_A(5):
        return "NVC697_SET_VERTEX_ATTRIBUTE_A(5)";
    case NVC697_SET_VERTEX_ATTRIBUTE_A(6):
        return "NVC697_SET_VERTEX_ATTRIBUTE_A(6)";
    case NVC697_SET_VERTEX_ATTRIBUTE_A(7):
        return "NVC697_SET_VERTEX_ATTRIBUTE_A(7)";
    case NVC697_SET_VERTEX_ATTRIBUTE_A(8):
        return "NVC697_SET_VERTEX_ATTRIBUTE_A(8)";
    case NVC697_SET_VERTEX_ATTRIBUTE_A(9):
        return "NVC697_SET_VERTEX_ATTRIBUTE_A(9)";
    case NVC697_SET_VERTEX_ATTRIBUTE_A(10):
        return "NVC697_SET_VERTEX_ATTRIBUTE_A(10)";
    case NVC697_SET_VERTEX_ATTRIBUTE_A(11):
        return "NVC697_SET_VERTEX_ATTRIBUTE_A(11)";
    case NVC697_SET_VERTEX_ATTRIBUTE_A(12):
        return "NVC697_SET_VERTEX_ATTRIBUTE_A(12)";
    case NVC697_SET_VERTEX_ATTRIBUTE_A(13):
        return "NVC697_SET_VERTEX_ATTRIBUTE_A(13)";
    case NVC697_SET_VERTEX_ATTRIBUTE_A(14):
        return "NVC697_SET_VERTEX_ATTRIBUTE_A(14)";
    case NVC697_SET_VERTEX_ATTRIBUTE_A(15):
        return "NVC697_SET_VERTEX_ATTRIBUTE_A(15)";
    case NVC697_SET_VERTEX_ATTRIBUTE_B(0):
        return "NVC697_SET_VERTEX_ATTRIBUTE_B(0)";
    case NVC697_SET_VERTEX_ATTRIBUTE_B(1):
        return "NVC697_SET_VERTEX_ATTRIBUTE_B(1)";
    case NVC697_SET_VERTEX_ATTRIBUTE_B(2):
        return "NVC697_SET_VERTEX_ATTRIBUTE_B(2)";
    case NVC697_SET_VERTEX_ATTRIBUTE_B(3):
        return "NVC697_SET_VERTEX_ATTRIBUTE_B(3)";
    case NVC697_SET_VERTEX_ATTRIBUTE_B(4):
        return "NVC697_SET_VERTEX_ATTRIBUTE_B(4)";
    case NVC697_SET_VERTEX_ATTRIBUTE_B(5):
        return "NVC697_SET_VERTEX_ATTRIBUTE_B(5)";
    case NVC697_SET_VERTEX_ATTRIBUTE_B(6):
        return "NVC697_SET_VERTEX_ATTRIBUTE_B(6)";
    case NVC697_SET_VERTEX_ATTRIBUTE_B(7):
        return "NVC697_SET_VERTEX_ATTRIBUTE_B(7)";
    case NVC697_SET_VERTEX_ATTRIBUTE_B(8):
        return "NVC697_SET_VERTEX_ATTRIBUTE_B(8)";
    case NVC697_SET_VERTEX_ATTRIBUTE_B(9):
        return "NVC697_SET_VERTEX_ATTRIBUTE_B(9)";
    case NVC697_SET_VERTEX_ATTRIBUTE_B(10):
        return "NVC697_SET_VERTEX_ATTRIBUTE_B(10)";
    case NVC697_SET_VERTEX_ATTRIBUTE_B(11):
        return "NVC697_SET_VERTEX_ATTRIBUTE_B(11)";
    case NVC697_SET_VERTEX_ATTRIBUTE_B(12):
        return "NVC697_SET_VERTEX_ATTRIBUTE_B(12)";
    case NVC697_SET_VERTEX_ATTRIBUTE_B(13):
        return "NVC697_SET_VERTEX_ATTRIBUTE_B(13)";
    case NVC697_SET_VERTEX_ATTRIBUTE_B(14):
        return "NVC697_SET_VERTEX_ATTRIBUTE_B(14)";
    case NVC697_SET_VERTEX_ATTRIBUTE_B(15):
        return "NVC697_SET_VERTEX_ATTRIBUTE_B(15)";
    case NVC697_SET_ANTI_ALIAS_SAMPLE_POSITIONS(0):
        return "NVC697_SET_ANTI_ALIAS_SAMPLE_POSITIONS(0)";
    case NVC697_SET_ANTI_ALIAS_SAMPLE_POSITIONS(1):
        return "NVC697_SET_ANTI_ALIAS_SAMPLE_POSITIONS(1)";
    case NVC697_SET_ANTI_ALIAS_SAMPLE_POSITIONS(2):
        return "NVC697_SET_ANTI_ALIAS_SAMPLE_POSITIONS(2)";
    case NVC697_SET_ANTI_ALIAS_SAMPLE_POSITIONS(3):
        return "NVC697_SET_ANTI_ALIAS_SAMPLE_POSITIONS(3)";
    case NVC697_SET_OFFSET_RENDER_TARGET_INDEX:
        return "NVC697_SET_OFFSET_RENDER_TARGET_INDEX";
    case NVC697_FORCE_HEAVYWEIGHT_METHOD_SYNC:
        return "NVC697_FORCE_HEAVYWEIGHT_METHOD_SYNC";
    case NVC697_SET_COVERAGE_TO_COLOR:
        return "NVC697_SET_COVERAGE_TO_COLOR";
    case NVC697_DECOMPRESS_ZETA_SURFACE:
        return "NVC697_DECOMPRESS_ZETA_SURFACE";
    case NVC697_SET_SCREEN_STATE_MASK:
        return "NVC697_SET_SCREEN_STATE_MASK";
    case NVC697_SET_ZT_SPARSE:
        return "NVC697_SET_ZT_SPARSE";
    case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST:
        return "NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST";
    case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT:
        return "NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT";
    case NVC697_SET_CT_SELECT:
        return "NVC697_SET_CT_SELECT";
    case NVC697_SET_COMPRESSION_THRESHOLD:
        return "NVC697_SET_COMPRESSION_THRESHOLD";
    case NVC697_SET_PIXEL_SHADER_INTERLOCK_CONTROL:
        return "NVC697_SET_PIXEL_SHADER_INTERLOCK_CONTROL";
    case NVC697_SET_ZT_SIZE_A:
        return "NVC697_SET_ZT_SIZE_A";
    case NVC697_SET_ZT_SIZE_B:
        return "NVC697_SET_ZT_SIZE_B";
    case NVC697_SET_ZT_SIZE_C:
        return "NVC697_SET_ZT_SIZE_C";
    case NVC697_SET_SAMPLER_BINDING:
        return "NVC697_SET_SAMPLER_BINDING";
    case NVC697_DRAW_AUTO:
        return "NVC697_DRAW_AUTO";
        case NVC697_SET_PIXEL_SHADER_TICKET_DISPENSER_VALUE:
        return "NVC697_SET_PIXEL_SHADER_TICKET_DISPENSER_VALUE";
    case NVC697_SET_BACK_END_COPY_A:
        return "NVC697_SET_BACK_END_COPY_A";
    case NVC697_SET_BACK_END_COPY_B:
        return "NVC697_SET_BACK_END_COPY_B";
    case NVC697_SET_BACK_END_COPY_C:
        return "NVC697_SET_BACK_END_COPY_C";
    case NVC697_SET_BACK_END_COPY_D:
        return "NVC697_SET_BACK_END_COPY_D";
    case NVC697_SET_BACK_END_COPY_E:
        return "NVC697_SET_BACK_END_COPY_E";
    case NVC697_SET_CIRCULAR_BUFFER_SIZE:
        return "NVC697_SET_CIRCULAR_BUFFER_SIZE";
    case NVC697_SET_VTG_REGISTER_WATERMARKS:
        return "NVC697_SET_VTG_REGISTER_WATERMARKS";
    case NVC697_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI:
        return "NVC697_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI";
    case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS:
        return "NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS";
    case NVC697_SET_DA_PRIMITIVE_RESTART_INDEX_TOPOLOGY_CHANGE:
        return "NVC697_SET_DA_PRIMITIVE_RESTART_INDEX_TOPOLOGY_CHANGE";
    case NVC697_SET_SHADING_RATE_INDEX_SURFACE_ADDRESS_A(0):
        return "NVC697_SET_SHADING_RATE_INDEX_SURFACE_ADDRESS_A(0)";
    case NVC697_SET_SHADING_RATE_INDEX_SURFACE_ADDRESS_B(0):
        return "NVC697_SET_SHADING_RATE_INDEX_SURFACE_ADDRESS_B(0)";
    case NVC697_SET_SHADING_RATE_INDEX_SURFACE_SIZE_A(0):
        return "NVC697_SET_SHADING_RATE_INDEX_SURFACE_SIZE_A(0)";
    case NVC697_SET_SHADING_RATE_INDEX_SURFACE_SIZE_B(0):
        return "NVC697_SET_SHADING_RATE_INDEX_SURFACE_SIZE_B(0)";
    case NVC697_SET_SHADING_RATE_INDEX_SURFACE_LAYER(0):
        return "NVC697_SET_SHADING_RATE_INDEX_SURFACE_LAYER(0)";
    case NVC697_SET_SHADING_RATE_INDEX_SURFACE_ARRAY_PITCH(0):
        return "NVC697_SET_SHADING_RATE_INDEX_SURFACE_ARRAY_PITCH(0)";
    case NVC697_SET_SHADING_RATE_INDEX_SURFACE_BLOCK_SIZE(0):
        return "NVC697_SET_SHADING_RATE_INDEX_SURFACE_BLOCK_SIZE(0)";
    case NVC697_SET_SHADING_RATE_INDEX_SURFACE_ALLOCATED_SIZE(0):
        return "NVC697_SET_SHADING_RATE_INDEX_SURFACE_ALLOCATED_SIZE(0)";
    case NVC697_CLEAR_ZCULL_REGION:
        return "NVC697_CLEAR_ZCULL_REGION";
    case NVC697_SET_DEPTH_TEST:
        return "NVC697_SET_DEPTH_TEST";
    case NVC697_SET_FILL_MODE:
        return "NVC697_SET_FILL_MODE";
    case NVC697_SET_SHADE_MODE:
        return "NVC697_SET_SHADE_MODE";
    case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS:
        return "NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS";
    case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS:
        return "NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS";
    case NVC697_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL:
        return "NVC697_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL";
    case NVC697_SET_BLEND_STATE_PER_TARGET:
        return "NVC697_SET_BLEND_STATE_PER_TARGET";
    case NVC697_SET_DEPTH_WRITE:
        return "NVC697_SET_DEPTH_WRITE";
    case NVC697_SET_ALPHA_TEST:
        return "NVC697_SET_ALPHA_TEST";
    case NVC697_SET_INLINE_INDEX4X8_ALIGN:
        return "NVC697_SET_INLINE_INDEX4X8_ALIGN";
    case NVC697_DRAW_INLINE_INDEX4X8:
        return "NVC697_DRAW_INLINE_INDEX4X8";
    case NVC697_D3D_SET_CULL_MODE:
        return "NVC697_D3D_SET_CULL_MODE";
    case NVC697_SET_DEPTH_FUNC:
        return "NVC697_SET_DEPTH_FUNC";
    case NVC697_SET_ALPHA_REF:
        return "NVC697_SET_ALPHA_REF";
    case NVC697_SET_ALPHA_FUNC:
        return "NVC697_SET_ALPHA_FUNC";
    case NVC697_SET_DRAW_AUTO_STRIDE:
        return "NVC697_SET_DRAW_AUTO_STRIDE";
    case NVC697_SET_BLEND_CONST_RED:
        return "NVC697_SET_BLEND_CONST_RED";
    case NVC697_SET_BLEND_CONST_GREEN:
        return "NVC697_SET_BLEND_CONST_GREEN";
    case NVC697_SET_BLEND_CONST_BLUE:
        return "NVC697_SET_BLEND_CONST_BLUE";
    case NVC697_SET_BLEND_CONST_ALPHA:
        return "NVC697_SET_BLEND_CONST_ALPHA";
    case NVC697_INVALIDATE_SAMPLER_CACHE:
        return "NVC697_INVALIDATE_SAMPLER_CACHE";
    case NVC697_INVALIDATE_TEXTURE_HEADER_CACHE:
        return "NVC697_INVALIDATE_TEXTURE_HEADER_CACHE";
    case NVC697_INVALIDATE_TEXTURE_DATA_CACHE:
        return "NVC697_INVALIDATE_TEXTURE_DATA_CACHE";
    case NVC697_SET_BLEND_SEPARATE_FOR_ALPHA:
        return "NVC697_SET_BLEND_SEPARATE_FOR_ALPHA";
    case NVC697_SET_BLEND_COLOR_OP:
        return "NVC697_SET_BLEND_COLOR_OP";
    case NVC697_SET_BLEND_COLOR_SOURCE_COEFF:
        return "NVC697_SET_BLEND_COLOR_SOURCE_COEFF";
    case NVC697_SET_BLEND_COLOR_DEST_COEFF:
        return "NVC697_SET_BLEND_COLOR_DEST_COEFF";
    case NVC697_SET_BLEND_ALPHA_OP:
        return "NVC697_SET_BLEND_ALPHA_OP";
    case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF:
        return "NVC697_SET_BLEND_ALPHA_SOURCE_COEFF";
    case NVC697_SET_GLOBAL_COLOR_KEY:
        return "NVC697_SET_GLOBAL_COLOR_KEY";
    case NVC697_SET_BLEND_ALPHA_DEST_COEFF:
        return "NVC697_SET_BLEND_ALPHA_DEST_COEFF";
    case NVC697_SET_SINGLE_ROP_CONTROL:
        return "NVC697_SET_SINGLE_ROP_CONTROL";
    case NVC697_SET_BLEND(0):
        return "NVC697_SET_BLEND(0)";
    case NVC697_SET_BLEND(1):
        return "NVC697_SET_BLEND(1)";
    case NVC697_SET_BLEND(2):
        return "NVC697_SET_BLEND(2)";
    case NVC697_SET_BLEND(3):
        return "NVC697_SET_BLEND(3)";
    case NVC697_SET_BLEND(4):
        return "NVC697_SET_BLEND(4)";
    case NVC697_SET_BLEND(5):
        return "NVC697_SET_BLEND(5)";
    case NVC697_SET_BLEND(6):
        return "NVC697_SET_BLEND(6)";
    case NVC697_SET_BLEND(7):
        return "NVC697_SET_BLEND(7)";
    case NVC697_SET_STENCIL_TEST:
        return "NVC697_SET_STENCIL_TEST";
    case NVC697_SET_STENCIL_OP_FAIL:
        return "NVC697_SET_STENCIL_OP_FAIL";
    case NVC697_SET_STENCIL_OP_ZFAIL:
        return "NVC697_SET_STENCIL_OP_ZFAIL";
    case NVC697_SET_STENCIL_OP_ZPASS:
        return "NVC697_SET_STENCIL_OP_ZPASS";
    case NVC697_SET_STENCIL_FUNC:
        return "NVC697_SET_STENCIL_FUNC";
    case NVC697_SET_STENCIL_FUNC_REF:
        return "NVC697_SET_STENCIL_FUNC_REF";
    case NVC697_SET_STENCIL_FUNC_MASK:
        return "NVC697_SET_STENCIL_FUNC_MASK";
    case NVC697_SET_STENCIL_MASK:
        return "NVC697_SET_STENCIL_MASK";
    case NVC697_SET_DRAW_AUTO_START:
        return "NVC697_SET_DRAW_AUTO_START";
    case NVC697_SET_PS_SATURATE:
        return "NVC697_SET_PS_SATURATE";
    case NVC697_SET_WINDOW_ORIGIN:
        return "NVC697_SET_WINDOW_ORIGIN";
    case NVC697_SET_LINE_WIDTH_FLOAT:
        return "NVC697_SET_LINE_WIDTH_FLOAT";
    case NVC697_SET_ALIASED_LINE_WIDTH_FLOAT:
        return "NVC697_SET_ALIASED_LINE_WIDTH_FLOAT";
    case NVC697_SET_LINE_MULTISAMPLE_OVERRIDE:
        return "NVC697_SET_LINE_MULTISAMPLE_OVERRIDE";
    case NVC697_INVALIDATE_SAMPLER_CACHE_NO_WFI:
        return "NVC697_INVALIDATE_SAMPLER_CACHE_NO_WFI";
    case NVC697_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI:
        return "NVC697_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI";
    case NVC697_SET_GLOBAL_BASE_VERTEX_INDEX:
        return "NVC697_SET_GLOBAL_BASE_VERTEX_INDEX";
    case NVC697_SET_GLOBAL_BASE_INSTANCE_INDEX:
        return "NVC697_SET_GLOBAL_BASE_INSTANCE_INDEX";
    case NVC697_SET_PS_WARP_WATERMARKS:
        return "NVC697_SET_PS_WARP_WATERMARKS";
    case NVC697_SET_PS_REGISTER_WATERMARKS:
        return "NVC697_SET_PS_REGISTER_WATERMARKS";
    case NVC697_STORE_ZCULL:
        return "NVC697_STORE_ZCULL";
                case NVC697_LOAD_ZCULL:
        return "NVC697_LOAD_ZCULL";
    case NVC697_SET_SURFACE_CLIP_ID_HEIGHT:
        return "NVC697_SET_SURFACE_CLIP_ID_HEIGHT";
    case NVC697_SET_CLIP_ID_CLEAR_RECT_HORIZONTAL:
        return "NVC697_SET_CLIP_ID_CLEAR_RECT_HORIZONTAL";
    case NVC697_SET_CLIP_ID_CLEAR_RECT_VERTICAL:
        return "NVC697_SET_CLIP_ID_CLEAR_RECT_VERTICAL";
    case NVC697_SET_USER_CLIP_ENABLE:
        return "NVC697_SET_USER_CLIP_ENABLE";
    case NVC697_SET_ZPASS_PIXEL_COUNT:
        return "NVC697_SET_ZPASS_PIXEL_COUNT";
    case NVC697_SET_POINT_SIZE:
        return "NVC697_SET_POINT_SIZE";
    case NVC697_SET_ZCULL_STATS:
        return "NVC697_SET_ZCULL_STATS";
    case NVC697_SET_POINT_SPRITE:
        return "NVC697_SET_POINT_SPRITE";
    case NVC697_SET_SHADER_EXCEPTIONS:
        return "NVC697_SET_SHADER_EXCEPTIONS";
    case NVC697_CLEAR_REPORT_VALUE:
        return "NVC697_CLEAR_REPORT_VALUE";
    case NVC697_SET_ANTI_ALIAS_ENABLE:
        return "NVC697_SET_ANTI_ALIAS_ENABLE";
    case NVC697_SET_ZT_SELECT:
        return "NVC697_SET_ZT_SELECT";
    case NVC697_SET_ANTI_ALIAS_ALPHA_CONTROL:
        return "NVC697_SET_ANTI_ALIAS_ALPHA_CONTROL";
    case NVC697_SET_RENDER_ENABLE_A:
        return "NVC697_SET_RENDER_ENABLE_A";
    case NVC697_SET_RENDER_ENABLE_B:
        return "NVC697_SET_RENDER_ENABLE_B";
    case NVC697_SET_RENDER_ENABLE_C:
        return "NVC697_SET_RENDER_ENABLE_C";
    case NVC697_SET_TEX_SAMPLER_POOL_A:
        return "NVC697_SET_TEX_SAMPLER_POOL_A";
    case NVC697_SET_TEX_SAMPLER_POOL_B:
        return "NVC697_SET_TEX_SAMPLER_POOL_B";
    case NVC697_SET_TEX_SAMPLER_POOL_C:
        return "NVC697_SET_TEX_SAMPLER_POOL_C";
    case NVC697_SET_SLOPE_SCALE_DEPTH_BIAS:
        return "NVC697_SET_SLOPE_SCALE_DEPTH_BIAS";
    case NVC697_SET_ANTI_ALIASED_LINE:
        return "NVC697_SET_ANTI_ALIASED_LINE";
    case NVC697_SET_TEX_HEADER_POOL_A:
        return "NVC697_SET_TEX_HEADER_POOL_A";
    case NVC697_SET_TEX_HEADER_POOL_B:
        return "NVC697_SET_TEX_HEADER_POOL_B";
    case NVC697_SET_TEX_HEADER_POOL_C:
        return "NVC697_SET_TEX_HEADER_POOL_C";
    case NVC697_SET_ACTIVE_ZCULL_REGION:
        return "NVC697_SET_ACTIVE_ZCULL_REGION";
    case NVC697_SET_TWO_SIDED_STENCIL_TEST:
        return "NVC697_SET_TWO_SIDED_STENCIL_TEST";
    case NVC697_SET_BACK_STENCIL_OP_FAIL:
        return "NVC697_SET_BACK_STENCIL_OP_FAIL";
    case NVC697_SET_BACK_STENCIL_OP_ZFAIL:
        return "NVC697_SET_BACK_STENCIL_OP_ZFAIL";
    case NVC697_SET_BACK_STENCIL_OP_ZPASS:
        return "NVC697_SET_BACK_STENCIL_OP_ZPASS";
    case NVC697_SET_BACK_STENCIL_FUNC:
        return "NVC697_SET_BACK_STENCIL_FUNC";
    case NVC697_SET_SRGB_WRITE:
        return "NVC697_SET_SRGB_WRITE";
    case NVC697_SET_DEPTH_BIAS:
        return "NVC697_SET_DEPTH_BIAS";
    case NVC697_SET_ZCULL_REGION_FORMAT:
        return "NVC697_SET_ZCULL_REGION_FORMAT";
    case NVC697_SET_RT_LAYER:
        return "NVC697_SET_RT_LAYER";
    case NVC697_SET_ANTI_ALIAS:
        return "NVC697_SET_ANTI_ALIAS";
    case NVC697_SET_EDGE_FLAG:
        return "NVC697_SET_EDGE_FLAG";
    case NVC697_DRAW_INLINE_INDEX:
        return "NVC697_DRAW_INLINE_INDEX";
    case NVC697_SET_INLINE_INDEX2X16_ALIGN:
        return "NVC697_SET_INLINE_INDEX2X16_ALIGN";
    case NVC697_DRAW_INLINE_INDEX2X16:
        return "NVC697_DRAW_INLINE_INDEX2X16";
    case NVC697_SET_VERTEX_GLOBAL_BASE_OFFSET_A:
        return "NVC697_SET_VERTEX_GLOBAL_BASE_OFFSET_A";
    case NVC697_SET_VERTEX_GLOBAL_BASE_OFFSET_B:
        return "NVC697_SET_VERTEX_GLOBAL_BASE_OFFSET_B";
    case NVC697_SET_ZCULL_REGION_PIXEL_OFFSET_A:
        return "NVC697_SET_ZCULL_REGION_PIXEL_OFFSET_A";
    case NVC697_SET_ZCULL_REGION_PIXEL_OFFSET_B:
        return "NVC697_SET_ZCULL_REGION_PIXEL_OFFSET_B";
    case NVC697_SET_POINT_SPRITE_SELECT:
        return "NVC697_SET_POINT_SPRITE_SELECT";
    case NVC697_SET_ATTRIBUTE_DEFAULT:
        return "NVC697_SET_ATTRIBUTE_DEFAULT";
    case NVC697_END:
        return "NVC697_END";
    case NVC697_BEGIN:
        return "NVC697_BEGIN";
    case NVC697_SET_VERTEX_ID_COPY:
        return "NVC697_SET_VERTEX_ID_COPY";
    case NVC697_ADD_TO_PRIMITIVE_ID:
        return "NVC697_ADD_TO_PRIMITIVE_ID";
    case NVC697_LOAD_PRIMITIVE_ID:
        return "NVC697_LOAD_PRIMITIVE_ID";
    case NVC697_SET_SHADER_BASED_CULL:
        return "NVC697_SET_SHADER_BASED_CULL";
    case NVC697_SET_CLASS_VERSION:
        return "NVC697_SET_CLASS_VERSION";
    case NVC697_SET_DA_PRIMITIVE_RESTART:
        return "NVC697_SET_DA_PRIMITIVE_RESTART";
    case NVC697_SET_DA_PRIMITIVE_RESTART_INDEX:
        return "NVC697_SET_DA_PRIMITIVE_RESTART_INDEX";
    case NVC697_SET_DA_OUTPUT:
        return "NVC697_SET_DA_OUTPUT";
    case NVC697_SET_ANTI_ALIASED_POINT:
        return "NVC697_SET_ANTI_ALIASED_POINT";
    case NVC697_SET_POINT_CENTER_MODE:
        return "NVC697_SET_POINT_CENTER_MODE";
    case NVC697_SET_LINE_SMOOTH_PARAMETERS:
        return "NVC697_SET_LINE_SMOOTH_PARAMETERS";
    case NVC697_SET_LINE_STIPPLE:
        return "NVC697_SET_LINE_STIPPLE";
        case NVC697_SET_LINE_STIPPLE_PARAMETERS:
        return "NVC697_SET_LINE_STIPPLE_PARAMETERS";
    case NVC697_SET_PROVOKING_VERTEX:
        return "NVC697_SET_PROVOKING_VERTEX";
    case NVC697_SET_TWO_SIDED_LIGHT:
        return "NVC697_SET_TWO_SIDED_LIGHT";
    case NVC697_SET_POLYGON_STIPPLE:
        return "NVC697_SET_POLYGON_STIPPLE";
    case NVC697_SET_SHADER_CONTROL:
        return "NVC697_SET_SHADER_CONTROL";
    case NVC697_CHECK_CLASS_VERSION:
        return "NVC697_CHECK_CLASS_VERSION";
    case NVC697_SET_SPH_VERSION:
        return "NVC697_SET_SPH_VERSION";
    case NVC697_CHECK_SPH_VERSION:
        return "NVC697_CHECK_SPH_VERSION";
    case NVC697_SET_ALPHA_TO_COVERAGE_OVERRIDE:
        return "NVC697_SET_ALPHA_TO_COVERAGE_OVERRIDE";
    case NVC697_SET_SCG_GRAPHICS_PRIORITY:
        return "NVC697_SET_SCG_GRAPHICS_PRIORITY";
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(0):
        return "NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(0)";
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(1):
        return "NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(1)";
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(2):
        return "NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(2)";
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(3):
        return "NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(3)";
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(4):
        return "NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(4)";
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(5):
        return "NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(5)";
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(6):
        return "NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(6)";
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(7):
        return "NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(7)";
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(8):
        return "NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(8)";
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(9):
        return "NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(9)";
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(10):
        return "NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(10)";
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(11):
        return "NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(11)";
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(12):
        return "NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(12)";
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(13):
        return "NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(13)";
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(14):
        return "NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(14)";
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(15):
        return "NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(15)";
        case NVC697_SET_AAM_VERSION:
        return "NVC697_SET_AAM_VERSION";
    case NVC697_CHECK_AAM_VERSION:
        return "NVC697_CHECK_AAM_VERSION";
    case NVC697_SET_ZT_LAYER:
        return "NVC697_SET_ZT_LAYER";
    case NVC697_SET_INDEX_BUFFER_A:
        return "NVC697_SET_INDEX_BUFFER_A";
    case NVC697_SET_INDEX_BUFFER_B:
        return "NVC697_SET_INDEX_BUFFER_B";
    case NVC697_SET_INDEX_BUFFER_E:
        return "NVC697_SET_INDEX_BUFFER_E";
    case NVC697_SET_INDEX_BUFFER_F:
        return "NVC697_SET_INDEX_BUFFER_F";
    case NVC697_DRAW_INDEX_BUFFER:
        return "NVC697_DRAW_INDEX_BUFFER";
    case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST:
        return "NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST";
    case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST:
        return "NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST";
    case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST:
        return "NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST";
    case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT:
        return "NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT";
    case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT:
        return "NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT";
    case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT:
        return "NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT";
    case NVC697_SET_DEPTH_BIAS_CLAMP:
        return "NVC697_SET_DEPTH_BIAS_CLAMP";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(0):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_A(0)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(1):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_A(1)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(2):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_A(2)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(3):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_A(3)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(4):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_A(4)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(5):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_A(5)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(6):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_A(6)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(7):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_A(7)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(8):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_A(8)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(9):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_A(9)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(10):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_A(10)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(11):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_A(11)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(12):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_A(12)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(13):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_A(13)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(14):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_A(14)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(15):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_A(15)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(0):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_B(0)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(1):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_B(1)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(2):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_B(2)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(3):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_B(3)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(4):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_B(4)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(5):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_B(5)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(6):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_B(6)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(7):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_B(7)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(8):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_B(8)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(9):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_B(9)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(10):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_B(10)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(11):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_B(11)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(12):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_B(12)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(13):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_B(13)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(14):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_B(14)";
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(15):
        return "NVC697_SET_VERTEX_STREAM_INSTANCE_B(15)";
    case NVC697_SET_ATTRIBUTE_POINT_SIZE:
        return "NVC697_SET_ATTRIBUTE_POINT_SIZE";
    case NVC697_OGL_SET_CULL:
        return "NVC697_OGL_SET_CULL";
    case NVC697_OGL_SET_FRONT_FACE:
        return "NVC697_OGL_SET_FRONT_FACE";
    case NVC697_OGL_SET_CULL_FACE:
        return "NVC697_OGL_SET_CULL_FACE";
    case NVC697_SET_VIEWPORT_PIXEL:
        return "NVC697_SET_VIEWPORT_PIXEL";
    case NVC697_SET_VIEWPORT_SCALE_OFFSET:
        return "NVC697_SET_VIEWPORT_SCALE_OFFSET";
    case NVC697_SET_VIEWPORT_CLIP_CONTROL:
        return "NVC697_SET_VIEWPORT_CLIP_CONTROL";
    case NVC697_SET_USER_CLIP_OP:
        return "NVC697_SET_USER_CLIP_OP";
    case NVC697_SET_RENDER_ENABLE_OVERRIDE:
        return "NVC697_SET_RENDER_ENABLE_OVERRIDE";
    case NVC697_SET_PRIMITIVE_TOPOLOGY_CONTROL:
        return "NVC697_SET_PRIMITIVE_TOPOLOGY_CONTROL";
    case NVC697_SET_WINDOW_CLIP_ENABLE:
        return "NVC697_SET_WINDOW_CLIP_ENABLE";
    case NVC697_SET_WINDOW_CLIP_TYPE:
        return "NVC697_SET_WINDOW_CLIP_TYPE";
    case NVC697_INVALIDATE_ZCULL:
        return "NVC697_INVALIDATE_ZCULL";
    case NVC697_SET_ZCULL:
        return "NVC697_SET_ZCULL";
    case NVC697_SET_ZCULL_BOUNDS:
        return "NVC697_SET_ZCULL_BOUNDS";
    case NVC697_SET_PRIMITIVE_TOPOLOGY:
        return "NVC697_SET_PRIMITIVE_TOPOLOGY";
    case NVC697_ZCULL_SYNC:
        return "NVC697_ZCULL_SYNC";
    case NVC697_SET_CLIP_ID_TEST:
        return "NVC697_SET_CLIP_ID_TEST";
    case NVC697_SET_SURFACE_CLIP_ID_WIDTH:
        return "NVC697_SET_SURFACE_CLIP_ID_WIDTH";
    case NVC697_SET_CLIP_ID:
        return "NVC697_SET_CLIP_ID";
    case NVC697_SET_DEPTH_BOUNDS_TEST:
        return "NVC697_SET_DEPTH_BOUNDS_TEST";
    case NVC697_SET_BLEND_FLOAT_OPTION:
        return "NVC697_SET_BLEND_FLOAT_OPTION";
    case NVC697_SET_LOGIC_OP:
        return "NVC697_SET_LOGIC_OP";
    case NVC697_SET_LOGIC_OP_FUNC:
        return "NVC697_SET_LOGIC_OP_FUNC";
    case NVC697_SET_Z_COMPRESSION:
        return "NVC697_SET_Z_COMPRESSION";
    case NVC697_CLEAR_SURFACE:
        return "NVC697_CLEAR_SURFACE";
    case NVC697_CLEAR_CLIP_ID_SURFACE:
        return "NVC697_CLEAR_CLIP_ID_SURFACE";
    case NVC697_SET_COLOR_COMPRESSION(0):
        return "NVC697_SET_COLOR_COMPRESSION(0)";
    case NVC697_SET_COLOR_COMPRESSION(1):
        return "NVC697_SET_COLOR_COMPRESSION(1)";
    case NVC697_SET_COLOR_COMPRESSION(2):
        return "NVC697_SET_COLOR_COMPRESSION(2)";
    case NVC697_SET_COLOR_COMPRESSION(3):
        return "NVC697_SET_COLOR_COMPRESSION(3)";
    case NVC697_SET_COLOR_COMPRESSION(4):
        return "NVC697_SET_COLOR_COMPRESSION(4)";
    case NVC697_SET_COLOR_COMPRESSION(5):
        return "NVC697_SET_COLOR_COMPRESSION(5)";
    case NVC697_SET_COLOR_COMPRESSION(6):
        return "NVC697_SET_COLOR_COMPRESSION(6)";
    case NVC697_SET_COLOR_COMPRESSION(7):
        return "NVC697_SET_COLOR_COMPRESSION(7)";
    case NVC697_SET_CT_WRITE(0):
        return "NVC697_SET_CT_WRITE(0)";
    case NVC697_SET_CT_WRITE(1):
        return "NVC697_SET_CT_WRITE(1)";
    case NVC697_SET_CT_WRITE(2):
        return "NVC697_SET_CT_WRITE(2)";
    case NVC697_SET_CT_WRITE(3):
        return "NVC697_SET_CT_WRITE(3)";
    case NVC697_SET_CT_WRITE(4):
        return "NVC697_SET_CT_WRITE(4)";
    case NVC697_SET_CT_WRITE(5):
        return "NVC697_SET_CT_WRITE(5)";
    case NVC697_SET_CT_WRITE(6):
        return "NVC697_SET_CT_WRITE(6)";
    case NVC697_SET_CT_WRITE(7):
        return "NVC697_SET_CT_WRITE(7)";
    case NVC697_PIPE_NOP:
        return "NVC697_PIPE_NOP";
    case NVC697_SET_SPARE00:
        return "NVC697_SET_SPARE00";
    case NVC697_SET_SPARE01:
        return "NVC697_SET_SPARE01";
    case NVC697_SET_SPARE02:
        return "NVC697_SET_SPARE02";
    case NVC697_SET_SPARE03:
        return "NVC697_SET_SPARE03";
    case NVC697_SET_REPORT_SEMAPHORE_A:
        return "NVC697_SET_REPORT_SEMAPHORE_A";
    case NVC697_SET_REPORT_SEMAPHORE_B:
        return "NVC697_SET_REPORT_SEMAPHORE_B";
    case NVC697_SET_REPORT_SEMAPHORE_C:
        return "NVC697_SET_REPORT_SEMAPHORE_C";
    case NVC697_SET_REPORT_SEMAPHORE_D:
        return "NVC697_SET_REPORT_SEMAPHORE_D";
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(0):
        return "NVC697_SET_VERTEX_STREAM_A_FORMAT(0)";
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(1):
        return "NVC697_SET_VERTEX_STREAM_A_FORMAT(1)";
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(2):
        return "NVC697_SET_VERTEX_STREAM_A_FORMAT(2)";
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(3):
        return "NVC697_SET_VERTEX_STREAM_A_FORMAT(3)";
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(4):
        return "NVC697_SET_VERTEX_STREAM_A_FORMAT(4)";
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(5):
        return "NVC697_SET_VERTEX_STREAM_A_FORMAT(5)";
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(6):
        return "NVC697_SET_VERTEX_STREAM_A_FORMAT(6)";
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(7):
        return "NVC697_SET_VERTEX_STREAM_A_FORMAT(7)";
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(8):
        return "NVC697_SET_VERTEX_STREAM_A_FORMAT(8)";
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(9):
        return "NVC697_SET_VERTEX_STREAM_A_FORMAT(9)";
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(10):
        return "NVC697_SET_VERTEX_STREAM_A_FORMAT(10)";
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(11):
        return "NVC697_SET_VERTEX_STREAM_A_FORMAT(11)";
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(12):
        return "NVC697_SET_VERTEX_STREAM_A_FORMAT(12)";
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(13):
        return "NVC697_SET_VERTEX_STREAM_A_FORMAT(13)";
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(14):
        return "NVC697_SET_VERTEX_STREAM_A_FORMAT(14)";
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(15):
        return "NVC697_SET_VERTEX_STREAM_A_FORMAT(15)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(0):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_A(0)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(1):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_A(1)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(2):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_A(2)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(3):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_A(3)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(4):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_A(4)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(5):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_A(5)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(6):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_A(6)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(7):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_A(7)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(8):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_A(8)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(9):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_A(9)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(10):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_A(10)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(11):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_A(11)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(12):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_A(12)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(13):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_A(13)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(14):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_A(14)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(15):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_A(15)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(0):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_B(0)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(1):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_B(1)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(2):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_B(2)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(3):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_B(3)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(4):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_B(4)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(5):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_B(5)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(6):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_B(6)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(7):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_B(7)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(8):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_B(8)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(9):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_B(9)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(10):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_B(10)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(11):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_B(11)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(12):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_B(12)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(13):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_B(13)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(14):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_B(14)";
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(15):
        return "NVC697_SET_VERTEX_STREAM_A_LOCATION_B(15)";
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(0):
        return "NVC697_SET_VERTEX_STREAM_A_FREQUENCY(0)";
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(1):
        return "NVC697_SET_VERTEX_STREAM_A_FREQUENCY(1)";
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(2):
        return "NVC697_SET_VERTEX_STREAM_A_FREQUENCY(2)";
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(3):
        return "NVC697_SET_VERTEX_STREAM_A_FREQUENCY(3)";
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(4):
        return "NVC697_SET_VERTEX_STREAM_A_FREQUENCY(4)";
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(5):
        return "NVC697_SET_VERTEX_STREAM_A_FREQUENCY(5)";
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(6):
        return "NVC697_SET_VERTEX_STREAM_A_FREQUENCY(6)";
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(7):
        return "NVC697_SET_VERTEX_STREAM_A_FREQUENCY(7)";
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(8):
        return "NVC697_SET_VERTEX_STREAM_A_FREQUENCY(8)";
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(9):
        return "NVC697_SET_VERTEX_STREAM_A_FREQUENCY(9)";
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(10):
        return "NVC697_SET_VERTEX_STREAM_A_FREQUENCY(10)";
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(11):
        return "NVC697_SET_VERTEX_STREAM_A_FREQUENCY(11)";
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(12):
        return "NVC697_SET_VERTEX_STREAM_A_FREQUENCY(12)";
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(13):
        return "NVC697_SET_VERTEX_STREAM_A_FREQUENCY(13)";
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(14):
        return "NVC697_SET_VERTEX_STREAM_A_FREQUENCY(14)";
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(15):
        return "NVC697_SET_VERTEX_STREAM_A_FREQUENCY(15)";
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(0):
        return "NVC697_SET_VERTEX_STREAM_B_FORMAT(0)";
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(1):
        return "NVC697_SET_VERTEX_STREAM_B_FORMAT(1)";
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(2):
        return "NVC697_SET_VERTEX_STREAM_B_FORMAT(2)";
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(3):
        return "NVC697_SET_VERTEX_STREAM_B_FORMAT(3)";
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(4):
        return "NVC697_SET_VERTEX_STREAM_B_FORMAT(4)";
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(5):
        return "NVC697_SET_VERTEX_STREAM_B_FORMAT(5)";
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(6):
        return "NVC697_SET_VERTEX_STREAM_B_FORMAT(6)";
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(7):
        return "NVC697_SET_VERTEX_STREAM_B_FORMAT(7)";
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(8):
        return "NVC697_SET_VERTEX_STREAM_B_FORMAT(8)";
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(9):
        return "NVC697_SET_VERTEX_STREAM_B_FORMAT(9)";
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(10):
        return "NVC697_SET_VERTEX_STREAM_B_FORMAT(10)";
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(11):
        return "NVC697_SET_VERTEX_STREAM_B_FORMAT(11)";
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(12):
        return "NVC697_SET_VERTEX_STREAM_B_FORMAT(12)";
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(13):
        return "NVC697_SET_VERTEX_STREAM_B_FORMAT(13)";
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(14):
        return "NVC697_SET_VERTEX_STREAM_B_FORMAT(14)";
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(15):
        return "NVC697_SET_VERTEX_STREAM_B_FORMAT(15)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(0):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_A(0)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(1):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_A(1)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(2):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_A(2)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(3):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_A(3)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(4):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_A(4)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(5):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_A(5)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(6):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_A(6)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(7):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_A(7)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(8):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_A(8)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(9):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_A(9)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(10):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_A(10)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(11):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_A(11)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(12):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_A(12)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(13):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_A(13)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(14):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_A(14)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(15):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_A(15)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(0):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_B(0)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(1):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_B(1)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(2):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_B(2)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(3):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_B(3)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(4):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_B(4)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(5):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_B(5)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(6):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_B(6)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(7):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_B(7)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(8):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_B(8)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(9):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_B(9)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(10):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_B(10)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(11):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_B(11)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(12):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_B(12)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(13):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_B(13)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(14):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_B(14)";
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(15):
        return "NVC697_SET_VERTEX_STREAM_B_LOCATION_B(15)";
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(0):
        return "NVC697_SET_VERTEX_STREAM_B_FREQUENCY(0)";
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(1):
        return "NVC697_SET_VERTEX_STREAM_B_FREQUENCY(1)";
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(2):
        return "NVC697_SET_VERTEX_STREAM_B_FREQUENCY(2)";
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(3):
        return "NVC697_SET_VERTEX_STREAM_B_FREQUENCY(3)";
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(4):
        return "NVC697_SET_VERTEX_STREAM_B_FREQUENCY(4)";
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(5):
        return "NVC697_SET_VERTEX_STREAM_B_FREQUENCY(5)";
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(6):
        return "NVC697_SET_VERTEX_STREAM_B_FREQUENCY(6)";
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(7):
        return "NVC697_SET_VERTEX_STREAM_B_FREQUENCY(7)";
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(8):
        return "NVC697_SET_VERTEX_STREAM_B_FREQUENCY(8)";
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(9):
        return "NVC697_SET_VERTEX_STREAM_B_FREQUENCY(9)";
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(10):
        return "NVC697_SET_VERTEX_STREAM_B_FREQUENCY(10)";
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(11):
        return "NVC697_SET_VERTEX_STREAM_B_FREQUENCY(11)";
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(12):
        return "NVC697_SET_VERTEX_STREAM_B_FREQUENCY(12)";
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(13):
        return "NVC697_SET_VERTEX_STREAM_B_FREQUENCY(13)";
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(14):
        return "NVC697_SET_VERTEX_STREAM_B_FREQUENCY(14)";
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(15):
        return "NVC697_SET_VERTEX_STREAM_B_FREQUENCY(15)";
    case NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(0):
        return "NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(0)";
    case NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(1):
        return "NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(1)";
    case NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(2):
        return "NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(2)";
    case NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(3):
        return "NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(3)";
    case NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(4):
        return "NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(4)";
    case NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(5):
        return "NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(5)";
    case NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(6):
        return "NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(6)";
    case NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(7):
        return "NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(7)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_OP(0):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_OP(0)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_OP(1):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_OP(1)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_OP(2):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_OP(2)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_OP(3):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_OP(3)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_OP(4):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_OP(4)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_OP(5):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_OP(5)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_OP(6):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_OP(6)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_OP(7):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_OP(7)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(0):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(0)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(1):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(1)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(2):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(2)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(3):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(3)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(4):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(4)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(5):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(5)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(6):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(6)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(7):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(7)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(0):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(0)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(1):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(1)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(2):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(2)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(3):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(3)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(4):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(4)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(5):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(5)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(6):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(6)";
    case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(7):
        return "NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(7)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(0):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(0)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(1):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(1)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(2):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(2)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(3):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(3)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(4):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(4)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(5):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(5)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(6):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(6)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(7):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(7)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(0):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(0)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(1):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(1)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(2):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(2)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(3):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(3)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(4):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(4)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(5):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(5)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(6):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(6)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(7):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(7)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(0):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(0)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(1):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(1)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(2):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(2)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(3):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(3)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(4):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(4)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(5):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(5)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(6):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(6)";
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(7):
        return "NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(7)";
    case NVC697_SET_PIPELINE_SHADER(0):
        return "NVC697_SET_PIPELINE_SHADER(0)";
    case NVC697_SET_PIPELINE_SHADER(1):
        return "NVC697_SET_PIPELINE_SHADER(1)";
    case NVC697_SET_PIPELINE_SHADER(2):
        return "NVC697_SET_PIPELINE_SHADER(2)";
    case NVC697_SET_PIPELINE_SHADER(3):
        return "NVC697_SET_PIPELINE_SHADER(3)";
    case NVC697_SET_PIPELINE_SHADER(4):
        return "NVC697_SET_PIPELINE_SHADER(4)";
    case NVC697_SET_PIPELINE_SHADER(5):
        return "NVC697_SET_PIPELINE_SHADER(5)";
    case NVC697_SET_PIPELINE_RESERVED_B(0):
        return "NVC697_SET_PIPELINE_RESERVED_B(0)";
    case NVC697_SET_PIPELINE_RESERVED_B(1):
        return "NVC697_SET_PIPELINE_RESERVED_B(1)";
    case NVC697_SET_PIPELINE_RESERVED_B(2):
        return "NVC697_SET_PIPELINE_RESERVED_B(2)";
    case NVC697_SET_PIPELINE_RESERVED_B(3):
        return "NVC697_SET_PIPELINE_RESERVED_B(3)";
    case NVC697_SET_PIPELINE_RESERVED_B(4):
        return "NVC697_SET_PIPELINE_RESERVED_B(4)";
    case NVC697_SET_PIPELINE_RESERVED_B(5):
        return "NVC697_SET_PIPELINE_RESERVED_B(5)";
    case NVC697_SET_PIPELINE_RESERVED_A(0):
        return "NVC697_SET_PIPELINE_RESERVED_A(0)";
    case NVC697_SET_PIPELINE_RESERVED_A(1):
        return "NVC697_SET_PIPELINE_RESERVED_A(1)";
    case NVC697_SET_PIPELINE_RESERVED_A(2):
        return "NVC697_SET_PIPELINE_RESERVED_A(2)";
    case NVC697_SET_PIPELINE_RESERVED_A(3):
        return "NVC697_SET_PIPELINE_RESERVED_A(3)";
    case NVC697_SET_PIPELINE_RESERVED_A(4):
        return "NVC697_SET_PIPELINE_RESERVED_A(4)";
    case NVC697_SET_PIPELINE_RESERVED_A(5):
        return "NVC697_SET_PIPELINE_RESERVED_A(5)";
    case NVC697_SET_PIPELINE_REGISTER_COUNT(0):
        return "NVC697_SET_PIPELINE_REGISTER_COUNT(0)";
    case NVC697_SET_PIPELINE_REGISTER_COUNT(1):
        return "NVC697_SET_PIPELINE_REGISTER_COUNT(1)";
    case NVC697_SET_PIPELINE_REGISTER_COUNT(2):
        return "NVC697_SET_PIPELINE_REGISTER_COUNT(2)";
    case NVC697_SET_PIPELINE_REGISTER_COUNT(3):
        return "NVC697_SET_PIPELINE_REGISTER_COUNT(3)";
    case NVC697_SET_PIPELINE_REGISTER_COUNT(4):
        return "NVC697_SET_PIPELINE_REGISTER_COUNT(4)";
    case NVC697_SET_PIPELINE_REGISTER_COUNT(5):
        return "NVC697_SET_PIPELINE_REGISTER_COUNT(5)";
    case NVC697_SET_PIPELINE_BINDING(0):
        return "NVC697_SET_PIPELINE_BINDING(0)";
    case NVC697_SET_PIPELINE_BINDING(1):
        return "NVC697_SET_PIPELINE_BINDING(1)";
    case NVC697_SET_PIPELINE_BINDING(2):
        return "NVC697_SET_PIPELINE_BINDING(2)";
    case NVC697_SET_PIPELINE_BINDING(3):
        return "NVC697_SET_PIPELINE_BINDING(3)";
    case NVC697_SET_PIPELINE_BINDING(4):
        return "NVC697_SET_PIPELINE_BINDING(4)";
    case NVC697_SET_PIPELINE_BINDING(5):
        return "NVC697_SET_PIPELINE_BINDING(5)";
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_A(0):
        return "NVC697_SET_PIPELINE_PROGRAM_ADDRESS_A(0)";
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_A(1):
        return "NVC697_SET_PIPELINE_PROGRAM_ADDRESS_A(1)";
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_A(2):
        return "NVC697_SET_PIPELINE_PROGRAM_ADDRESS_A(2)";
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_A(3):
        return "NVC697_SET_PIPELINE_PROGRAM_ADDRESS_A(3)";
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_A(4):
        return "NVC697_SET_PIPELINE_PROGRAM_ADDRESS_A(4)";
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_A(5):
        return "NVC697_SET_PIPELINE_PROGRAM_ADDRESS_A(5)";
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_B(0):
        return "NVC697_SET_PIPELINE_PROGRAM_ADDRESS_B(0)";
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_B(1):
        return "NVC697_SET_PIPELINE_PROGRAM_ADDRESS_B(1)";
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_B(2):
        return "NVC697_SET_PIPELINE_PROGRAM_ADDRESS_B(2)";
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_B(3):
        return "NVC697_SET_PIPELINE_PROGRAM_ADDRESS_B(3)";
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_B(4):
        return "NVC697_SET_PIPELINE_PROGRAM_ADDRESS_B(4)";
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_B(5):
        return "NVC697_SET_PIPELINE_PROGRAM_ADDRESS_B(5)";
    case NVC697_SET_PIPELINE_RESERVED_D(0):
        return "NVC697_SET_PIPELINE_RESERVED_D(0)";
    case NVC697_SET_PIPELINE_RESERVED_D(1):
        return "NVC697_SET_PIPELINE_RESERVED_D(1)";
    case NVC697_SET_PIPELINE_RESERVED_D(2):
        return "NVC697_SET_PIPELINE_RESERVED_D(2)";
    case NVC697_SET_PIPELINE_RESERVED_D(3):
        return "NVC697_SET_PIPELINE_RESERVED_D(3)";
    case NVC697_SET_PIPELINE_RESERVED_D(4):
        return "NVC697_SET_PIPELINE_RESERVED_D(4)";
    case NVC697_SET_PIPELINE_RESERVED_D(5):
        return "NVC697_SET_PIPELINE_RESERVED_D(5)";
    case NVC697_SET_PIPELINE_RESERVED_E(0):
        return "NVC697_SET_PIPELINE_RESERVED_E(0)";
    case NVC697_SET_PIPELINE_RESERVED_E(1):
        return "NVC697_SET_PIPELINE_RESERVED_E(1)";
    case NVC697_SET_PIPELINE_RESERVED_E(2):
        return "NVC697_SET_PIPELINE_RESERVED_E(2)";
    case NVC697_SET_PIPELINE_RESERVED_E(3):
        return "NVC697_SET_PIPELINE_RESERVED_E(3)";
    case NVC697_SET_PIPELINE_RESERVED_E(4):
        return "NVC697_SET_PIPELINE_RESERVED_E(4)";
    case NVC697_SET_PIPELINE_RESERVED_E(5):
        return "NVC697_SET_PIPELINE_RESERVED_E(5)";
    case NVC697_SET_FALCON00:
        return "NVC697_SET_FALCON00";
    case NVC697_SET_FALCON01:
        return "NVC697_SET_FALCON01";
    case NVC697_SET_FALCON02:
        return "NVC697_SET_FALCON02";
    case NVC697_SET_FALCON03:
        return "NVC697_SET_FALCON03";
    case NVC697_SET_FALCON04:
        return "NVC697_SET_FALCON04";
    case NVC697_SET_FALCON05:
        return "NVC697_SET_FALCON05";
    case NVC697_SET_FALCON06:
        return "NVC697_SET_FALCON06";
    case NVC697_SET_FALCON07:
        return "NVC697_SET_FALCON07";
    case NVC697_SET_FALCON08:
        return "NVC697_SET_FALCON08";
    case NVC697_SET_FALCON09:
        return "NVC697_SET_FALCON09";
    case NVC697_SET_FALCON10:
        return "NVC697_SET_FALCON10";
    case NVC697_SET_FALCON11:
        return "NVC697_SET_FALCON11";
    case NVC697_SET_FALCON12:
        return "NVC697_SET_FALCON12";
    case NVC697_SET_FALCON13:
        return "NVC697_SET_FALCON13";
    case NVC697_SET_FALCON14:
        return "NVC697_SET_FALCON14";
    case NVC697_SET_FALCON15:
        return "NVC697_SET_FALCON15";
    case NVC697_SET_FALCON16:
        return "NVC697_SET_FALCON16";
    case NVC697_SET_FALCON17:
        return "NVC697_SET_FALCON17";
    case NVC697_SET_FALCON18:
        return "NVC697_SET_FALCON18";
    case NVC697_SET_FALCON19:
        return "NVC697_SET_FALCON19";
    case NVC697_SET_FALCON20:
        return "NVC697_SET_FALCON20";
    case NVC697_SET_FALCON21:
        return "NVC697_SET_FALCON21";
    case NVC697_SET_FALCON22:
        return "NVC697_SET_FALCON22";
    case NVC697_SET_FALCON23:
        return "NVC697_SET_FALCON23";
    case NVC697_SET_FALCON24:
        return "NVC697_SET_FALCON24";
    case NVC697_SET_FALCON25:
        return "NVC697_SET_FALCON25";
    case NVC697_SET_FALCON26:
        return "NVC697_SET_FALCON26";
    case NVC697_SET_FALCON27:
        return "NVC697_SET_FALCON27";
    case NVC697_SET_FALCON28:
        return "NVC697_SET_FALCON28";
    case NVC697_SET_FALCON29:
        return "NVC697_SET_FALCON29";
    case NVC697_SET_FALCON30:
        return "NVC697_SET_FALCON30";
    case NVC697_SET_FALCON31:
        return "NVC697_SET_FALCON31";
    case NVC697_SET_CONSTANT_BUFFER_SELECTOR_A:
        return "NVC697_SET_CONSTANT_BUFFER_SELECTOR_A";
    case NVC697_SET_CONSTANT_BUFFER_SELECTOR_B:
        return "NVC697_SET_CONSTANT_BUFFER_SELECTOR_B";
    case NVC697_SET_CONSTANT_BUFFER_SELECTOR_C:
        return "NVC697_SET_CONSTANT_BUFFER_SELECTOR_C";
    case NVC697_LOAD_CONSTANT_BUFFER_OFFSET:
        return "NVC697_LOAD_CONSTANT_BUFFER_OFFSET";
    case NVC697_LOAD_CONSTANT_BUFFER(0):
        return "NVC697_LOAD_CONSTANT_BUFFER(0)";
    case NVC697_LOAD_CONSTANT_BUFFER(1):
        return "NVC697_LOAD_CONSTANT_BUFFER(1)";
    case NVC697_LOAD_CONSTANT_BUFFER(2):
        return "NVC697_LOAD_CONSTANT_BUFFER(2)";
    case NVC697_LOAD_CONSTANT_BUFFER(3):
        return "NVC697_LOAD_CONSTANT_BUFFER(3)";
    case NVC697_LOAD_CONSTANT_BUFFER(4):
        return "NVC697_LOAD_CONSTANT_BUFFER(4)";
    case NVC697_LOAD_CONSTANT_BUFFER(5):
        return "NVC697_LOAD_CONSTANT_BUFFER(5)";
    case NVC697_LOAD_CONSTANT_BUFFER(6):
        return "NVC697_LOAD_CONSTANT_BUFFER(6)";
    case NVC697_LOAD_CONSTANT_BUFFER(7):
        return "NVC697_LOAD_CONSTANT_BUFFER(7)";
    case NVC697_LOAD_CONSTANT_BUFFER(8):
        return "NVC697_LOAD_CONSTANT_BUFFER(8)";
    case NVC697_LOAD_CONSTANT_BUFFER(9):
        return "NVC697_LOAD_CONSTANT_BUFFER(9)";
    case NVC697_LOAD_CONSTANT_BUFFER(10):
        return "NVC697_LOAD_CONSTANT_BUFFER(10)";
    case NVC697_LOAD_CONSTANT_BUFFER(11):
        return "NVC697_LOAD_CONSTANT_BUFFER(11)";
    case NVC697_LOAD_CONSTANT_BUFFER(12):
        return "NVC697_LOAD_CONSTANT_BUFFER(12)";
    case NVC697_LOAD_CONSTANT_BUFFER(13):
        return "NVC697_LOAD_CONSTANT_BUFFER(13)";
    case NVC697_LOAD_CONSTANT_BUFFER(14):
        return "NVC697_LOAD_CONSTANT_BUFFER(14)";
    case NVC697_LOAD_CONSTANT_BUFFER(15):
        return "NVC697_LOAD_CONSTANT_BUFFER(15)";
                    case NVC697_BIND_GROUP_CONSTANT_BUFFER(0):
        return "NVC697_BIND_GROUP_CONSTANT_BUFFER(0)";
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(1):
        return "NVC697_BIND_GROUP_CONSTANT_BUFFER(1)";
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(2):
        return "NVC697_BIND_GROUP_CONSTANT_BUFFER(2)";
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(3):
        return "NVC697_BIND_GROUP_CONSTANT_BUFFER(3)";
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(4):
        return "NVC697_BIND_GROUP_CONSTANT_BUFFER(4)";
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(5):
        return "NVC697_BIND_GROUP_CONSTANT_BUFFER(5)";
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(6):
        return "NVC697_BIND_GROUP_CONSTANT_BUFFER(6)";
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(7):
        return "NVC697_BIND_GROUP_CONSTANT_BUFFER(7)";
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(8):
        return "NVC697_BIND_GROUP_CONSTANT_BUFFER(8)";
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(9):
        return "NVC697_BIND_GROUP_CONSTANT_BUFFER(9)";
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(10):
        return "NVC697_BIND_GROUP_CONSTANT_BUFFER(10)";
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(11):
        return "NVC697_BIND_GROUP_CONSTANT_BUFFER(11)";
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(12):
        return "NVC697_BIND_GROUP_CONSTANT_BUFFER(12)";
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(13):
        return "NVC697_BIND_GROUP_CONSTANT_BUFFER(13)";
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(14):
        return "NVC697_BIND_GROUP_CONSTANT_BUFFER(14)";
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(15):
        return "NVC697_BIND_GROUP_CONSTANT_BUFFER(15)";
    case NVC697_SET_TRAP_HANDLER_A:
        return "NVC697_SET_TRAP_HANDLER_A";
    case NVC697_SET_TRAP_HANDLER_B:
        return "NVC697_SET_TRAP_HANDLER_B";
    case NVC697_SET_COLOR_CLAMP:
        return "NVC697_SET_COLOR_CLAMP";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(0):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(0)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(1):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(1)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(2):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(2)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(3):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(3)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(4):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(4)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(5):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(5)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(6):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(6)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(7):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(7)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(8):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(8)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(9):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(9)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(10):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(10)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(11):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(11)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(12):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(12)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(13):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(13)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(14):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(14)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(15):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(15)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(0):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(0)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(1):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(1)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(2):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(2)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(3):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(3)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(4):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(4)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(5):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(5)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(6):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(6)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(7):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(7)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(8):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(8)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(9):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(9)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(10):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(10)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(11):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(11)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(12):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(12)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(13):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(13)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(14):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(14)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(15):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(15)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(0):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(0)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(1):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(1)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(2):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(2)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(3):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(3)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(4):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(4)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(5):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(5)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(6):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(6)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(7):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(7)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(8):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(8)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(9):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(9)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(10):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(10)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(11):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(11)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(12):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(12)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(13):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(13)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(14):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(14)";
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(15):
        return "NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(15)";
        case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(0):
        return "NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(0)";
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(1):
        return "NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(1)";
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(2):
        return "NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(2)";
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(3):
        return "NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(3)";
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(4):
        return "NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(4)";
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(5):
        return "NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(5)";
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(6):
        return "NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(6)";
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(7):
        return "NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(7)";
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(0):
        return "NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(0)";
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(1):
        return "NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(1)";
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(2):
        return "NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(2)";
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(3):
        return "NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(3)";
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(4):
        return "NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(4)";
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(5):
        return "NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(5)";
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(6):
        return "NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(6)";
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(7):
        return "NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(7)";
    case NVC697_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER:
        return "NVC697_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER";
    case NVC697_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER:
        return "NVC697_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(0):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(0)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(1):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(1)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(2):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(2)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(3):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(3)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(4):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(4)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(5):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(5)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(6):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(6)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(7):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(7)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(0):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(0)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(1):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(1)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(2):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(2)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(3):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(3)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(4):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(4)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(5):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(5)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(6):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(6)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(7):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(7)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(0):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(0)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(1):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(1)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(2):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(2)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(3):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(3)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(4):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(4)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(5):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(5)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(6):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(6)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(7):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(7)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(0):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(0)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(1):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(1)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(2):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(2)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(3):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(3)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(4):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(4)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(5):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(5)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(6):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(6)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(7):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(7)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(0):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(0)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(1):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(1)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(2):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(2)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(3):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(3)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(4):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(4)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(5):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(5)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(6):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(6)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(7):
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(7)";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL:
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL";
    case NVC697_START_SHADER_PERFORMANCE_COUNTER:
        return "NVC697_START_SHADER_PERFORMANCE_COUNTER";
    case NVC697_STOP_SHADER_PERFORMANCE_COUNTER:
        return "NVC697_STOP_SHADER_PERFORMANCE_COUNTER";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER:
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER";
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER:
        return "NVC697_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER";
    case NVC697_SET_MME_SHADOW_SCRATCH(0):
        return "NVC697_SET_MME_SHADOW_SCRATCH(0)";
    case NVC697_SET_MME_SHADOW_SCRATCH(1):
        return "NVC697_SET_MME_SHADOW_SCRATCH(1)";
    case NVC697_SET_MME_SHADOW_SCRATCH(2):
        return "NVC697_SET_MME_SHADOW_SCRATCH(2)";
    case NVC697_SET_MME_SHADOW_SCRATCH(3):
        return "NVC697_SET_MME_SHADOW_SCRATCH(3)";
    case NVC697_SET_MME_SHADOW_SCRATCH(4):
        return "NVC697_SET_MME_SHADOW_SCRATCH(4)";
    case NVC697_SET_MME_SHADOW_SCRATCH(5):
        return "NVC697_SET_MME_SHADOW_SCRATCH(5)";
    case NVC697_SET_MME_SHADOW_SCRATCH(6):
        return "NVC697_SET_MME_SHADOW_SCRATCH(6)";
    case NVC697_SET_MME_SHADOW_SCRATCH(7):
        return "NVC697_SET_MME_SHADOW_SCRATCH(7)";
    case NVC697_SET_MME_SHADOW_SCRATCH(8):
        return "NVC697_SET_MME_SHADOW_SCRATCH(8)";
    case NVC697_SET_MME_SHADOW_SCRATCH(9):
        return "NVC697_SET_MME_SHADOW_SCRATCH(9)";
    case NVC697_SET_MME_SHADOW_SCRATCH(10):
        return "NVC697_SET_MME_SHADOW_SCRATCH(10)";
    case NVC697_SET_MME_SHADOW_SCRATCH(11):
        return "NVC697_SET_MME_SHADOW_SCRATCH(11)";
    case NVC697_SET_MME_SHADOW_SCRATCH(12):
        return "NVC697_SET_MME_SHADOW_SCRATCH(12)";
    case NVC697_SET_MME_SHADOW_SCRATCH(13):
        return "NVC697_SET_MME_SHADOW_SCRATCH(13)";
    case NVC697_SET_MME_SHADOW_SCRATCH(14):
        return "NVC697_SET_MME_SHADOW_SCRATCH(14)";
    case NVC697_SET_MME_SHADOW_SCRATCH(15):
        return "NVC697_SET_MME_SHADOW_SCRATCH(15)";
    case NVC697_SET_MME_SHADOW_SCRATCH(16):
        return "NVC697_SET_MME_SHADOW_SCRATCH(16)";
    case NVC697_SET_MME_SHADOW_SCRATCH(17):
        return "NVC697_SET_MME_SHADOW_SCRATCH(17)";
    case NVC697_SET_MME_SHADOW_SCRATCH(18):
        return "NVC697_SET_MME_SHADOW_SCRATCH(18)";
    case NVC697_SET_MME_SHADOW_SCRATCH(19):
        return "NVC697_SET_MME_SHADOW_SCRATCH(19)";
    case NVC697_SET_MME_SHADOW_SCRATCH(20):
        return "NVC697_SET_MME_SHADOW_SCRATCH(20)";
    case NVC697_SET_MME_SHADOW_SCRATCH(21):
        return "NVC697_SET_MME_SHADOW_SCRATCH(21)";
    case NVC697_SET_MME_SHADOW_SCRATCH(22):
        return "NVC697_SET_MME_SHADOW_SCRATCH(22)";
    case NVC697_SET_MME_SHADOW_SCRATCH(23):
        return "NVC697_SET_MME_SHADOW_SCRATCH(23)";
    case NVC697_SET_MME_SHADOW_SCRATCH(24):
        return "NVC697_SET_MME_SHADOW_SCRATCH(24)";
    case NVC697_SET_MME_SHADOW_SCRATCH(25):
        return "NVC697_SET_MME_SHADOW_SCRATCH(25)";
    case NVC697_SET_MME_SHADOW_SCRATCH(26):
        return "NVC697_SET_MME_SHADOW_SCRATCH(26)";
    case NVC697_SET_MME_SHADOW_SCRATCH(27):
        return "NVC697_SET_MME_SHADOW_SCRATCH(27)";
    case NVC697_SET_MME_SHADOW_SCRATCH(28):
        return "NVC697_SET_MME_SHADOW_SCRATCH(28)";
    case NVC697_SET_MME_SHADOW_SCRATCH(29):
        return "NVC697_SET_MME_SHADOW_SCRATCH(29)";
    case NVC697_SET_MME_SHADOW_SCRATCH(30):
        return "NVC697_SET_MME_SHADOW_SCRATCH(30)";
    case NVC697_SET_MME_SHADOW_SCRATCH(31):
        return "NVC697_SET_MME_SHADOW_SCRATCH(31)";
    case NVC697_SET_MME_SHADOW_SCRATCH(32):
        return "NVC697_SET_MME_SHADOW_SCRATCH(32)";
    case NVC697_SET_MME_SHADOW_SCRATCH(33):
        return "NVC697_SET_MME_SHADOW_SCRATCH(33)";
    case NVC697_SET_MME_SHADOW_SCRATCH(34):
        return "NVC697_SET_MME_SHADOW_SCRATCH(34)";
    case NVC697_SET_MME_SHADOW_SCRATCH(35):
        return "NVC697_SET_MME_SHADOW_SCRATCH(35)";
    case NVC697_SET_MME_SHADOW_SCRATCH(36):
        return "NVC697_SET_MME_SHADOW_SCRATCH(36)";
    case NVC697_SET_MME_SHADOW_SCRATCH(37):
        return "NVC697_SET_MME_SHADOW_SCRATCH(37)";
    case NVC697_SET_MME_SHADOW_SCRATCH(38):
        return "NVC697_SET_MME_SHADOW_SCRATCH(38)";
    case NVC697_SET_MME_SHADOW_SCRATCH(39):
        return "NVC697_SET_MME_SHADOW_SCRATCH(39)";
    case NVC697_SET_MME_SHADOW_SCRATCH(40):
        return "NVC697_SET_MME_SHADOW_SCRATCH(40)";
    case NVC697_SET_MME_SHADOW_SCRATCH(41):
        return "NVC697_SET_MME_SHADOW_SCRATCH(41)";
    case NVC697_SET_MME_SHADOW_SCRATCH(42):
        return "NVC697_SET_MME_SHADOW_SCRATCH(42)";
    case NVC697_SET_MME_SHADOW_SCRATCH(43):
        return "NVC697_SET_MME_SHADOW_SCRATCH(43)";
    case NVC697_SET_MME_SHADOW_SCRATCH(44):
        return "NVC697_SET_MME_SHADOW_SCRATCH(44)";
    case NVC697_SET_MME_SHADOW_SCRATCH(45):
        return "NVC697_SET_MME_SHADOW_SCRATCH(45)";
    case NVC697_SET_MME_SHADOW_SCRATCH(46):
        return "NVC697_SET_MME_SHADOW_SCRATCH(46)";
    case NVC697_SET_MME_SHADOW_SCRATCH(47):
        return "NVC697_SET_MME_SHADOW_SCRATCH(47)";
    case NVC697_SET_MME_SHADOW_SCRATCH(48):
        return "NVC697_SET_MME_SHADOW_SCRATCH(48)";
    case NVC697_SET_MME_SHADOW_SCRATCH(49):
        return "NVC697_SET_MME_SHADOW_SCRATCH(49)";
    case NVC697_SET_MME_SHADOW_SCRATCH(50):
        return "NVC697_SET_MME_SHADOW_SCRATCH(50)";
    case NVC697_SET_MME_SHADOW_SCRATCH(51):
        return "NVC697_SET_MME_SHADOW_SCRATCH(51)";
    case NVC697_SET_MME_SHADOW_SCRATCH(52):
        return "NVC697_SET_MME_SHADOW_SCRATCH(52)";
    case NVC697_SET_MME_SHADOW_SCRATCH(53):
        return "NVC697_SET_MME_SHADOW_SCRATCH(53)";
    case NVC697_SET_MME_SHADOW_SCRATCH(54):
        return "NVC697_SET_MME_SHADOW_SCRATCH(54)";
    case NVC697_SET_MME_SHADOW_SCRATCH(55):
        return "NVC697_SET_MME_SHADOW_SCRATCH(55)";
    case NVC697_SET_MME_SHADOW_SCRATCH(56):
        return "NVC697_SET_MME_SHADOW_SCRATCH(56)";
    case NVC697_SET_MME_SHADOW_SCRATCH(57):
        return "NVC697_SET_MME_SHADOW_SCRATCH(57)";
    case NVC697_SET_MME_SHADOW_SCRATCH(58):
        return "NVC697_SET_MME_SHADOW_SCRATCH(58)";
    case NVC697_SET_MME_SHADOW_SCRATCH(59):
        return "NVC697_SET_MME_SHADOW_SCRATCH(59)";
    case NVC697_SET_MME_SHADOW_SCRATCH(60):
        return "NVC697_SET_MME_SHADOW_SCRATCH(60)";
    case NVC697_SET_MME_SHADOW_SCRATCH(61):
        return "NVC697_SET_MME_SHADOW_SCRATCH(61)";
    case NVC697_SET_MME_SHADOW_SCRATCH(62):
        return "NVC697_SET_MME_SHADOW_SCRATCH(62)";
    case NVC697_SET_MME_SHADOW_SCRATCH(63):
        return "NVC697_SET_MME_SHADOW_SCRATCH(63)";
    case NVC697_SET_MME_SHADOW_SCRATCH(64):
        return "NVC697_SET_MME_SHADOW_SCRATCH(64)";
    case NVC697_SET_MME_SHADOW_SCRATCH(65):
        return "NVC697_SET_MME_SHADOW_SCRATCH(65)";
    case NVC697_SET_MME_SHADOW_SCRATCH(66):
        return "NVC697_SET_MME_SHADOW_SCRATCH(66)";
    case NVC697_SET_MME_SHADOW_SCRATCH(67):
        return "NVC697_SET_MME_SHADOW_SCRATCH(67)";
    case NVC697_SET_MME_SHADOW_SCRATCH(68):
        return "NVC697_SET_MME_SHADOW_SCRATCH(68)";
    case NVC697_SET_MME_SHADOW_SCRATCH(69):
        return "NVC697_SET_MME_SHADOW_SCRATCH(69)";
    case NVC697_SET_MME_SHADOW_SCRATCH(70):
        return "NVC697_SET_MME_SHADOW_SCRATCH(70)";
    case NVC697_SET_MME_SHADOW_SCRATCH(71):
        return "NVC697_SET_MME_SHADOW_SCRATCH(71)";
    case NVC697_SET_MME_SHADOW_SCRATCH(72):
        return "NVC697_SET_MME_SHADOW_SCRATCH(72)";
    case NVC697_SET_MME_SHADOW_SCRATCH(73):
        return "NVC697_SET_MME_SHADOW_SCRATCH(73)";
    case NVC697_SET_MME_SHADOW_SCRATCH(74):
        return "NVC697_SET_MME_SHADOW_SCRATCH(74)";
    case NVC697_SET_MME_SHADOW_SCRATCH(75):
        return "NVC697_SET_MME_SHADOW_SCRATCH(75)";
    case NVC697_SET_MME_SHADOW_SCRATCH(76):
        return "NVC697_SET_MME_SHADOW_SCRATCH(76)";
    case NVC697_SET_MME_SHADOW_SCRATCH(77):
        return "NVC697_SET_MME_SHADOW_SCRATCH(77)";
    case NVC697_SET_MME_SHADOW_SCRATCH(78):
        return "NVC697_SET_MME_SHADOW_SCRATCH(78)";
    case NVC697_SET_MME_SHADOW_SCRATCH(79):
        return "NVC697_SET_MME_SHADOW_SCRATCH(79)";
    case NVC697_SET_MME_SHADOW_SCRATCH(80):
        return "NVC697_SET_MME_SHADOW_SCRATCH(80)";
    case NVC697_SET_MME_SHADOW_SCRATCH(81):
        return "NVC697_SET_MME_SHADOW_SCRATCH(81)";
    case NVC697_SET_MME_SHADOW_SCRATCH(82):
        return "NVC697_SET_MME_SHADOW_SCRATCH(82)";
    case NVC697_SET_MME_SHADOW_SCRATCH(83):
        return "NVC697_SET_MME_SHADOW_SCRATCH(83)";
    case NVC697_SET_MME_SHADOW_SCRATCH(84):
        return "NVC697_SET_MME_SHADOW_SCRATCH(84)";
    case NVC697_SET_MME_SHADOW_SCRATCH(85):
        return "NVC697_SET_MME_SHADOW_SCRATCH(85)";
    case NVC697_SET_MME_SHADOW_SCRATCH(86):
        return "NVC697_SET_MME_SHADOW_SCRATCH(86)";
    case NVC697_SET_MME_SHADOW_SCRATCH(87):
        return "NVC697_SET_MME_SHADOW_SCRATCH(87)";
    case NVC697_SET_MME_SHADOW_SCRATCH(88):
        return "NVC697_SET_MME_SHADOW_SCRATCH(88)";
    case NVC697_SET_MME_SHADOW_SCRATCH(89):
        return "NVC697_SET_MME_SHADOW_SCRATCH(89)";
    case NVC697_SET_MME_SHADOW_SCRATCH(90):
        return "NVC697_SET_MME_SHADOW_SCRATCH(90)";
    case NVC697_SET_MME_SHADOW_SCRATCH(91):
        return "NVC697_SET_MME_SHADOW_SCRATCH(91)";
    case NVC697_SET_MME_SHADOW_SCRATCH(92):
        return "NVC697_SET_MME_SHADOW_SCRATCH(92)";
    case NVC697_SET_MME_SHADOW_SCRATCH(93):
        return "NVC697_SET_MME_SHADOW_SCRATCH(93)";
    case NVC697_SET_MME_SHADOW_SCRATCH(94):
        return "NVC697_SET_MME_SHADOW_SCRATCH(94)";
    case NVC697_SET_MME_SHADOW_SCRATCH(95):
        return "NVC697_SET_MME_SHADOW_SCRATCH(95)";
    case NVC697_SET_MME_SHADOW_SCRATCH(96):
        return "NVC697_SET_MME_SHADOW_SCRATCH(96)";
    case NVC697_SET_MME_SHADOW_SCRATCH(97):
        return "NVC697_SET_MME_SHADOW_SCRATCH(97)";
    case NVC697_SET_MME_SHADOW_SCRATCH(98):
        return "NVC697_SET_MME_SHADOW_SCRATCH(98)";
    case NVC697_SET_MME_SHADOW_SCRATCH(99):
        return "NVC697_SET_MME_SHADOW_SCRATCH(99)";
    case NVC697_SET_MME_SHADOW_SCRATCH(100):
        return "NVC697_SET_MME_SHADOW_SCRATCH(100)";
    case NVC697_SET_MME_SHADOW_SCRATCH(101):
        return "NVC697_SET_MME_SHADOW_SCRATCH(101)";
    case NVC697_SET_MME_SHADOW_SCRATCH(102):
        return "NVC697_SET_MME_SHADOW_SCRATCH(102)";
    case NVC697_SET_MME_SHADOW_SCRATCH(103):
        return "NVC697_SET_MME_SHADOW_SCRATCH(103)";
    case NVC697_SET_MME_SHADOW_SCRATCH(104):
        return "NVC697_SET_MME_SHADOW_SCRATCH(104)";
    case NVC697_SET_MME_SHADOW_SCRATCH(105):
        return "NVC697_SET_MME_SHADOW_SCRATCH(105)";
    case NVC697_SET_MME_SHADOW_SCRATCH(106):
        return "NVC697_SET_MME_SHADOW_SCRATCH(106)";
    case NVC697_SET_MME_SHADOW_SCRATCH(107):
        return "NVC697_SET_MME_SHADOW_SCRATCH(107)";
    case NVC697_SET_MME_SHADOW_SCRATCH(108):
        return "NVC697_SET_MME_SHADOW_SCRATCH(108)";
    case NVC697_SET_MME_SHADOW_SCRATCH(109):
        return "NVC697_SET_MME_SHADOW_SCRATCH(109)";
    case NVC697_SET_MME_SHADOW_SCRATCH(110):
        return "NVC697_SET_MME_SHADOW_SCRATCH(110)";
    case NVC697_SET_MME_SHADOW_SCRATCH(111):
        return "NVC697_SET_MME_SHADOW_SCRATCH(111)";
    case NVC697_SET_MME_SHADOW_SCRATCH(112):
        return "NVC697_SET_MME_SHADOW_SCRATCH(112)";
    case NVC697_SET_MME_SHADOW_SCRATCH(113):
        return "NVC697_SET_MME_SHADOW_SCRATCH(113)";
    case NVC697_SET_MME_SHADOW_SCRATCH(114):
        return "NVC697_SET_MME_SHADOW_SCRATCH(114)";
    case NVC697_SET_MME_SHADOW_SCRATCH(115):
        return "NVC697_SET_MME_SHADOW_SCRATCH(115)";
    case NVC697_SET_MME_SHADOW_SCRATCH(116):
        return "NVC697_SET_MME_SHADOW_SCRATCH(116)";
    case NVC697_SET_MME_SHADOW_SCRATCH(117):
        return "NVC697_SET_MME_SHADOW_SCRATCH(117)";
    case NVC697_SET_MME_SHADOW_SCRATCH(118):
        return "NVC697_SET_MME_SHADOW_SCRATCH(118)";
    case NVC697_SET_MME_SHADOW_SCRATCH(119):
        return "NVC697_SET_MME_SHADOW_SCRATCH(119)";
    case NVC697_SET_MME_SHADOW_SCRATCH(120):
        return "NVC697_SET_MME_SHADOW_SCRATCH(120)";
    case NVC697_SET_MME_SHADOW_SCRATCH(121):
        return "NVC697_SET_MME_SHADOW_SCRATCH(121)";
    case NVC697_SET_MME_SHADOW_SCRATCH(122):
        return "NVC697_SET_MME_SHADOW_SCRATCH(122)";
    case NVC697_SET_MME_SHADOW_SCRATCH(123):
        return "NVC697_SET_MME_SHADOW_SCRATCH(123)";
    case NVC697_SET_MME_SHADOW_SCRATCH(124):
        return "NVC697_SET_MME_SHADOW_SCRATCH(124)";
    case NVC697_SET_MME_SHADOW_SCRATCH(125):
        return "NVC697_SET_MME_SHADOW_SCRATCH(125)";
    case NVC697_SET_MME_SHADOW_SCRATCH(126):
        return "NVC697_SET_MME_SHADOW_SCRATCH(126)";
    case NVC697_SET_MME_SHADOW_SCRATCH(127):
        return "NVC697_SET_MME_SHADOW_SCRATCH(127)";
    case NVC697_SET_MME_SHADOW_SCRATCH(128):
        return "NVC697_SET_MME_SHADOW_SCRATCH(128)";
    case NVC697_SET_MME_SHADOW_SCRATCH(129):
        return "NVC697_SET_MME_SHADOW_SCRATCH(129)";
    case NVC697_SET_MME_SHADOW_SCRATCH(130):
        return "NVC697_SET_MME_SHADOW_SCRATCH(130)";
    case NVC697_SET_MME_SHADOW_SCRATCH(131):
        return "NVC697_SET_MME_SHADOW_SCRATCH(131)";
    case NVC697_SET_MME_SHADOW_SCRATCH(132):
        return "NVC697_SET_MME_SHADOW_SCRATCH(132)";
    case NVC697_SET_MME_SHADOW_SCRATCH(133):
        return "NVC697_SET_MME_SHADOW_SCRATCH(133)";
    case NVC697_SET_MME_SHADOW_SCRATCH(134):
        return "NVC697_SET_MME_SHADOW_SCRATCH(134)";
    case NVC697_SET_MME_SHADOW_SCRATCH(135):
        return "NVC697_SET_MME_SHADOW_SCRATCH(135)";
    case NVC697_SET_MME_SHADOW_SCRATCH(136):
        return "NVC697_SET_MME_SHADOW_SCRATCH(136)";
    case NVC697_SET_MME_SHADOW_SCRATCH(137):
        return "NVC697_SET_MME_SHADOW_SCRATCH(137)";
    case NVC697_SET_MME_SHADOW_SCRATCH(138):
        return "NVC697_SET_MME_SHADOW_SCRATCH(138)";
    case NVC697_SET_MME_SHADOW_SCRATCH(139):
        return "NVC697_SET_MME_SHADOW_SCRATCH(139)";
    case NVC697_SET_MME_SHADOW_SCRATCH(140):
        return "NVC697_SET_MME_SHADOW_SCRATCH(140)";
    case NVC697_SET_MME_SHADOW_SCRATCH(141):
        return "NVC697_SET_MME_SHADOW_SCRATCH(141)";
    case NVC697_SET_MME_SHADOW_SCRATCH(142):
        return "NVC697_SET_MME_SHADOW_SCRATCH(142)";
    case NVC697_SET_MME_SHADOW_SCRATCH(143):
        return "NVC697_SET_MME_SHADOW_SCRATCH(143)";
    case NVC697_SET_MME_SHADOW_SCRATCH(144):
        return "NVC697_SET_MME_SHADOW_SCRATCH(144)";
    case NVC697_SET_MME_SHADOW_SCRATCH(145):
        return "NVC697_SET_MME_SHADOW_SCRATCH(145)";
    case NVC697_SET_MME_SHADOW_SCRATCH(146):
        return "NVC697_SET_MME_SHADOW_SCRATCH(146)";
    case NVC697_SET_MME_SHADOW_SCRATCH(147):
        return "NVC697_SET_MME_SHADOW_SCRATCH(147)";
    case NVC697_SET_MME_SHADOW_SCRATCH(148):
        return "NVC697_SET_MME_SHADOW_SCRATCH(148)";
    case NVC697_SET_MME_SHADOW_SCRATCH(149):
        return "NVC697_SET_MME_SHADOW_SCRATCH(149)";
    case NVC697_SET_MME_SHADOW_SCRATCH(150):
        return "NVC697_SET_MME_SHADOW_SCRATCH(150)";
    case NVC697_SET_MME_SHADOW_SCRATCH(151):
        return "NVC697_SET_MME_SHADOW_SCRATCH(151)";
    case NVC697_SET_MME_SHADOW_SCRATCH(152):
        return "NVC697_SET_MME_SHADOW_SCRATCH(152)";
    case NVC697_SET_MME_SHADOW_SCRATCH(153):
        return "NVC697_SET_MME_SHADOW_SCRATCH(153)";
    case NVC697_SET_MME_SHADOW_SCRATCH(154):
        return "NVC697_SET_MME_SHADOW_SCRATCH(154)";
    case NVC697_SET_MME_SHADOW_SCRATCH(155):
        return "NVC697_SET_MME_SHADOW_SCRATCH(155)";
    case NVC697_SET_MME_SHADOW_SCRATCH(156):
        return "NVC697_SET_MME_SHADOW_SCRATCH(156)";
    case NVC697_SET_MME_SHADOW_SCRATCH(157):
        return "NVC697_SET_MME_SHADOW_SCRATCH(157)";
    case NVC697_SET_MME_SHADOW_SCRATCH(158):
        return "NVC697_SET_MME_SHADOW_SCRATCH(158)";
    case NVC697_SET_MME_SHADOW_SCRATCH(159):
        return "NVC697_SET_MME_SHADOW_SCRATCH(159)";
    case NVC697_SET_MME_SHADOW_SCRATCH(160):
        return "NVC697_SET_MME_SHADOW_SCRATCH(160)";
    case NVC697_SET_MME_SHADOW_SCRATCH(161):
        return "NVC697_SET_MME_SHADOW_SCRATCH(161)";
    case NVC697_SET_MME_SHADOW_SCRATCH(162):
        return "NVC697_SET_MME_SHADOW_SCRATCH(162)";
    case NVC697_SET_MME_SHADOW_SCRATCH(163):
        return "NVC697_SET_MME_SHADOW_SCRATCH(163)";
    case NVC697_SET_MME_SHADOW_SCRATCH(164):
        return "NVC697_SET_MME_SHADOW_SCRATCH(164)";
    case NVC697_SET_MME_SHADOW_SCRATCH(165):
        return "NVC697_SET_MME_SHADOW_SCRATCH(165)";
    case NVC697_SET_MME_SHADOW_SCRATCH(166):
        return "NVC697_SET_MME_SHADOW_SCRATCH(166)";
    case NVC697_SET_MME_SHADOW_SCRATCH(167):
        return "NVC697_SET_MME_SHADOW_SCRATCH(167)";
    case NVC697_SET_MME_SHADOW_SCRATCH(168):
        return "NVC697_SET_MME_SHADOW_SCRATCH(168)";
    case NVC697_SET_MME_SHADOW_SCRATCH(169):
        return "NVC697_SET_MME_SHADOW_SCRATCH(169)";
    case NVC697_SET_MME_SHADOW_SCRATCH(170):
        return "NVC697_SET_MME_SHADOW_SCRATCH(170)";
    case NVC697_SET_MME_SHADOW_SCRATCH(171):
        return "NVC697_SET_MME_SHADOW_SCRATCH(171)";
    case NVC697_SET_MME_SHADOW_SCRATCH(172):
        return "NVC697_SET_MME_SHADOW_SCRATCH(172)";
    case NVC697_SET_MME_SHADOW_SCRATCH(173):
        return "NVC697_SET_MME_SHADOW_SCRATCH(173)";
    case NVC697_SET_MME_SHADOW_SCRATCH(174):
        return "NVC697_SET_MME_SHADOW_SCRATCH(174)";
    case NVC697_SET_MME_SHADOW_SCRATCH(175):
        return "NVC697_SET_MME_SHADOW_SCRATCH(175)";
    case NVC697_SET_MME_SHADOW_SCRATCH(176):
        return "NVC697_SET_MME_SHADOW_SCRATCH(176)";
    case NVC697_SET_MME_SHADOW_SCRATCH(177):
        return "NVC697_SET_MME_SHADOW_SCRATCH(177)";
    case NVC697_SET_MME_SHADOW_SCRATCH(178):
        return "NVC697_SET_MME_SHADOW_SCRATCH(178)";
    case NVC697_SET_MME_SHADOW_SCRATCH(179):
        return "NVC697_SET_MME_SHADOW_SCRATCH(179)";
    case NVC697_SET_MME_SHADOW_SCRATCH(180):
        return "NVC697_SET_MME_SHADOW_SCRATCH(180)";
    case NVC697_SET_MME_SHADOW_SCRATCH(181):
        return "NVC697_SET_MME_SHADOW_SCRATCH(181)";
    case NVC697_SET_MME_SHADOW_SCRATCH(182):
        return "NVC697_SET_MME_SHADOW_SCRATCH(182)";
    case NVC697_SET_MME_SHADOW_SCRATCH(183):
        return "NVC697_SET_MME_SHADOW_SCRATCH(183)";
    case NVC697_SET_MME_SHADOW_SCRATCH(184):
        return "NVC697_SET_MME_SHADOW_SCRATCH(184)";
    case NVC697_SET_MME_SHADOW_SCRATCH(185):
        return "NVC697_SET_MME_SHADOW_SCRATCH(185)";
    case NVC697_SET_MME_SHADOW_SCRATCH(186):
        return "NVC697_SET_MME_SHADOW_SCRATCH(186)";
    case NVC697_SET_MME_SHADOW_SCRATCH(187):
        return "NVC697_SET_MME_SHADOW_SCRATCH(187)";
    case NVC697_SET_MME_SHADOW_SCRATCH(188):
        return "NVC697_SET_MME_SHADOW_SCRATCH(188)";
    case NVC697_SET_MME_SHADOW_SCRATCH(189):
        return "NVC697_SET_MME_SHADOW_SCRATCH(189)";
    case NVC697_SET_MME_SHADOW_SCRATCH(190):
        return "NVC697_SET_MME_SHADOW_SCRATCH(190)";
    case NVC697_SET_MME_SHADOW_SCRATCH(191):
        return "NVC697_SET_MME_SHADOW_SCRATCH(191)";
    case NVC697_SET_MME_SHADOW_SCRATCH(192):
        return "NVC697_SET_MME_SHADOW_SCRATCH(192)";
    case NVC697_SET_MME_SHADOW_SCRATCH(193):
        return "NVC697_SET_MME_SHADOW_SCRATCH(193)";
    case NVC697_SET_MME_SHADOW_SCRATCH(194):
        return "NVC697_SET_MME_SHADOW_SCRATCH(194)";
    case NVC697_SET_MME_SHADOW_SCRATCH(195):
        return "NVC697_SET_MME_SHADOW_SCRATCH(195)";
    case NVC697_SET_MME_SHADOW_SCRATCH(196):
        return "NVC697_SET_MME_SHADOW_SCRATCH(196)";
    case NVC697_SET_MME_SHADOW_SCRATCH(197):
        return "NVC697_SET_MME_SHADOW_SCRATCH(197)";
    case NVC697_SET_MME_SHADOW_SCRATCH(198):
        return "NVC697_SET_MME_SHADOW_SCRATCH(198)";
    case NVC697_SET_MME_SHADOW_SCRATCH(199):
        return "NVC697_SET_MME_SHADOW_SCRATCH(199)";
    case NVC697_SET_MME_SHADOW_SCRATCH(200):
        return "NVC697_SET_MME_SHADOW_SCRATCH(200)";
    case NVC697_SET_MME_SHADOW_SCRATCH(201):
        return "NVC697_SET_MME_SHADOW_SCRATCH(201)";
    case NVC697_SET_MME_SHADOW_SCRATCH(202):
        return "NVC697_SET_MME_SHADOW_SCRATCH(202)";
    case NVC697_SET_MME_SHADOW_SCRATCH(203):
        return "NVC697_SET_MME_SHADOW_SCRATCH(203)";
    case NVC697_SET_MME_SHADOW_SCRATCH(204):
        return "NVC697_SET_MME_SHADOW_SCRATCH(204)";
    case NVC697_SET_MME_SHADOW_SCRATCH(205):
        return "NVC697_SET_MME_SHADOW_SCRATCH(205)";
    case NVC697_SET_MME_SHADOW_SCRATCH(206):
        return "NVC697_SET_MME_SHADOW_SCRATCH(206)";
    case NVC697_SET_MME_SHADOW_SCRATCH(207):
        return "NVC697_SET_MME_SHADOW_SCRATCH(207)";
    case NVC697_SET_MME_SHADOW_SCRATCH(208):
        return "NVC697_SET_MME_SHADOW_SCRATCH(208)";
    case NVC697_SET_MME_SHADOW_SCRATCH(209):
        return "NVC697_SET_MME_SHADOW_SCRATCH(209)";
    case NVC697_SET_MME_SHADOW_SCRATCH(210):
        return "NVC697_SET_MME_SHADOW_SCRATCH(210)";
    case NVC697_SET_MME_SHADOW_SCRATCH(211):
        return "NVC697_SET_MME_SHADOW_SCRATCH(211)";
    case NVC697_SET_MME_SHADOW_SCRATCH(212):
        return "NVC697_SET_MME_SHADOW_SCRATCH(212)";
    case NVC697_SET_MME_SHADOW_SCRATCH(213):
        return "NVC697_SET_MME_SHADOW_SCRATCH(213)";
    case NVC697_SET_MME_SHADOW_SCRATCH(214):
        return "NVC697_SET_MME_SHADOW_SCRATCH(214)";
    case NVC697_SET_MME_SHADOW_SCRATCH(215):
        return "NVC697_SET_MME_SHADOW_SCRATCH(215)";
    case NVC697_SET_MME_SHADOW_SCRATCH(216):
        return "NVC697_SET_MME_SHADOW_SCRATCH(216)";
    case NVC697_SET_MME_SHADOW_SCRATCH(217):
        return "NVC697_SET_MME_SHADOW_SCRATCH(217)";
    case NVC697_SET_MME_SHADOW_SCRATCH(218):
        return "NVC697_SET_MME_SHADOW_SCRATCH(218)";
    case NVC697_SET_MME_SHADOW_SCRATCH(219):
        return "NVC697_SET_MME_SHADOW_SCRATCH(219)";
    case NVC697_SET_MME_SHADOW_SCRATCH(220):
        return "NVC697_SET_MME_SHADOW_SCRATCH(220)";
    case NVC697_SET_MME_SHADOW_SCRATCH(221):
        return "NVC697_SET_MME_SHADOW_SCRATCH(221)";
    case NVC697_SET_MME_SHADOW_SCRATCH(222):
        return "NVC697_SET_MME_SHADOW_SCRATCH(222)";
    case NVC697_SET_MME_SHADOW_SCRATCH(223):
        return "NVC697_SET_MME_SHADOW_SCRATCH(223)";
    case NVC697_SET_MME_SHADOW_SCRATCH(224):
        return "NVC697_SET_MME_SHADOW_SCRATCH(224)";
    case NVC697_SET_MME_SHADOW_SCRATCH(225):
        return "NVC697_SET_MME_SHADOW_SCRATCH(225)";
    case NVC697_SET_MME_SHADOW_SCRATCH(226):
        return "NVC697_SET_MME_SHADOW_SCRATCH(226)";
    case NVC697_SET_MME_SHADOW_SCRATCH(227):
        return "NVC697_SET_MME_SHADOW_SCRATCH(227)";
    case NVC697_SET_MME_SHADOW_SCRATCH(228):
        return "NVC697_SET_MME_SHADOW_SCRATCH(228)";
    case NVC697_SET_MME_SHADOW_SCRATCH(229):
        return "NVC697_SET_MME_SHADOW_SCRATCH(229)";
    case NVC697_SET_MME_SHADOW_SCRATCH(230):
        return "NVC697_SET_MME_SHADOW_SCRATCH(230)";
    case NVC697_SET_MME_SHADOW_SCRATCH(231):
        return "NVC697_SET_MME_SHADOW_SCRATCH(231)";
    case NVC697_SET_MME_SHADOW_SCRATCH(232):
        return "NVC697_SET_MME_SHADOW_SCRATCH(232)";
    case NVC697_SET_MME_SHADOW_SCRATCH(233):
        return "NVC697_SET_MME_SHADOW_SCRATCH(233)";
    case NVC697_SET_MME_SHADOW_SCRATCH(234):
        return "NVC697_SET_MME_SHADOW_SCRATCH(234)";
    case NVC697_SET_MME_SHADOW_SCRATCH(235):
        return "NVC697_SET_MME_SHADOW_SCRATCH(235)";
    case NVC697_SET_MME_SHADOW_SCRATCH(236):
        return "NVC697_SET_MME_SHADOW_SCRATCH(236)";
    case NVC697_SET_MME_SHADOW_SCRATCH(237):
        return "NVC697_SET_MME_SHADOW_SCRATCH(237)";
    case NVC697_SET_MME_SHADOW_SCRATCH(238):
        return "NVC697_SET_MME_SHADOW_SCRATCH(238)";
    case NVC697_SET_MME_SHADOW_SCRATCH(239):
        return "NVC697_SET_MME_SHADOW_SCRATCH(239)";
    case NVC697_SET_MME_SHADOW_SCRATCH(240):
        return "NVC697_SET_MME_SHADOW_SCRATCH(240)";
    case NVC697_SET_MME_SHADOW_SCRATCH(241):
        return "NVC697_SET_MME_SHADOW_SCRATCH(241)";
    case NVC697_SET_MME_SHADOW_SCRATCH(242):
        return "NVC697_SET_MME_SHADOW_SCRATCH(242)";
    case NVC697_SET_MME_SHADOW_SCRATCH(243):
        return "NVC697_SET_MME_SHADOW_SCRATCH(243)";
    case NVC697_SET_MME_SHADOW_SCRATCH(244):
        return "NVC697_SET_MME_SHADOW_SCRATCH(244)";
    case NVC697_SET_MME_SHADOW_SCRATCH(245):
        return "NVC697_SET_MME_SHADOW_SCRATCH(245)";
    case NVC697_SET_MME_SHADOW_SCRATCH(246):
        return "NVC697_SET_MME_SHADOW_SCRATCH(246)";
    case NVC697_SET_MME_SHADOW_SCRATCH(247):
        return "NVC697_SET_MME_SHADOW_SCRATCH(247)";
    case NVC697_SET_MME_SHADOW_SCRATCH(248):
        return "NVC697_SET_MME_SHADOW_SCRATCH(248)";
    case NVC697_SET_MME_SHADOW_SCRATCH(249):
        return "NVC697_SET_MME_SHADOW_SCRATCH(249)";
    case NVC697_SET_MME_SHADOW_SCRATCH(250):
        return "NVC697_SET_MME_SHADOW_SCRATCH(250)";
    case NVC697_SET_MME_SHADOW_SCRATCH(251):
        return "NVC697_SET_MME_SHADOW_SCRATCH(251)";
    case NVC697_SET_MME_SHADOW_SCRATCH(252):
        return "NVC697_SET_MME_SHADOW_SCRATCH(252)";
    case NVC697_SET_MME_SHADOW_SCRATCH(253):
        return "NVC697_SET_MME_SHADOW_SCRATCH(253)";
    case NVC697_SET_MME_SHADOW_SCRATCH(254):
        return "NVC697_SET_MME_SHADOW_SCRATCH(254)";
    case NVC697_SET_MME_SHADOW_SCRATCH(255):
        return "NVC697_SET_MME_SHADOW_SCRATCH(255)";
    case NVC697_CALL_MME_MACRO(0):
        return "NVC697_CALL_MME_MACRO(0)";
    case NVC697_CALL_MME_MACRO(1):
        return "NVC697_CALL_MME_MACRO(1)";
    case NVC697_CALL_MME_MACRO(2):
        return "NVC697_CALL_MME_MACRO(2)";
    case NVC697_CALL_MME_MACRO(3):
        return "NVC697_CALL_MME_MACRO(3)";
    case NVC697_CALL_MME_MACRO(4):
        return "NVC697_CALL_MME_MACRO(4)";
    case NVC697_CALL_MME_MACRO(5):
        return "NVC697_CALL_MME_MACRO(5)";
    case NVC697_CALL_MME_MACRO(6):
        return "NVC697_CALL_MME_MACRO(6)";
    case NVC697_CALL_MME_MACRO(7):
        return "NVC697_CALL_MME_MACRO(7)";
    case NVC697_CALL_MME_MACRO(8):
        return "NVC697_CALL_MME_MACRO(8)";
    case NVC697_CALL_MME_MACRO(9):
        return "NVC697_CALL_MME_MACRO(9)";
    case NVC697_CALL_MME_MACRO(10):
        return "NVC697_CALL_MME_MACRO(10)";
    case NVC697_CALL_MME_MACRO(11):
        return "NVC697_CALL_MME_MACRO(11)";
    case NVC697_CALL_MME_MACRO(12):
        return "NVC697_CALL_MME_MACRO(12)";
    case NVC697_CALL_MME_MACRO(13):
        return "NVC697_CALL_MME_MACRO(13)";
    case NVC697_CALL_MME_MACRO(14):
        return "NVC697_CALL_MME_MACRO(14)";
    case NVC697_CALL_MME_MACRO(15):
        return "NVC697_CALL_MME_MACRO(15)";
    case NVC697_CALL_MME_MACRO(16):
        return "NVC697_CALL_MME_MACRO(16)";
    case NVC697_CALL_MME_MACRO(17):
        return "NVC697_CALL_MME_MACRO(17)";
    case NVC697_CALL_MME_MACRO(18):
        return "NVC697_CALL_MME_MACRO(18)";
    case NVC697_CALL_MME_MACRO(19):
        return "NVC697_CALL_MME_MACRO(19)";
    case NVC697_CALL_MME_MACRO(20):
        return "NVC697_CALL_MME_MACRO(20)";
    case NVC697_CALL_MME_MACRO(21):
        return "NVC697_CALL_MME_MACRO(21)";
    case NVC697_CALL_MME_MACRO(22):
        return "NVC697_CALL_MME_MACRO(22)";
    case NVC697_CALL_MME_MACRO(23):
        return "NVC697_CALL_MME_MACRO(23)";
    case NVC697_CALL_MME_MACRO(24):
        return "NVC697_CALL_MME_MACRO(24)";
    case NVC697_CALL_MME_MACRO(25):
        return "NVC697_CALL_MME_MACRO(25)";
    case NVC697_CALL_MME_MACRO(26):
        return "NVC697_CALL_MME_MACRO(26)";
    case NVC697_CALL_MME_MACRO(27):
        return "NVC697_CALL_MME_MACRO(27)";
    case NVC697_CALL_MME_MACRO(28):
        return "NVC697_CALL_MME_MACRO(28)";
    case NVC697_CALL_MME_MACRO(29):
        return "NVC697_CALL_MME_MACRO(29)";
    case NVC697_CALL_MME_MACRO(30):
        return "NVC697_CALL_MME_MACRO(30)";
    case NVC697_CALL_MME_MACRO(31):
        return "NVC697_CALL_MME_MACRO(31)";
    case NVC697_CALL_MME_MACRO(32):
        return "NVC697_CALL_MME_MACRO(32)";
    case NVC697_CALL_MME_MACRO(33):
        return "NVC697_CALL_MME_MACRO(33)";
    case NVC697_CALL_MME_MACRO(34):
        return "NVC697_CALL_MME_MACRO(34)";
    case NVC697_CALL_MME_MACRO(35):
        return "NVC697_CALL_MME_MACRO(35)";
    case NVC697_CALL_MME_MACRO(36):
        return "NVC697_CALL_MME_MACRO(36)";
    case NVC697_CALL_MME_MACRO(37):
        return "NVC697_CALL_MME_MACRO(37)";
    case NVC697_CALL_MME_MACRO(38):
        return "NVC697_CALL_MME_MACRO(38)";
    case NVC697_CALL_MME_MACRO(39):
        return "NVC697_CALL_MME_MACRO(39)";
    case NVC697_CALL_MME_MACRO(40):
        return "NVC697_CALL_MME_MACRO(40)";
    case NVC697_CALL_MME_MACRO(41):
        return "NVC697_CALL_MME_MACRO(41)";
    case NVC697_CALL_MME_MACRO(42):
        return "NVC697_CALL_MME_MACRO(42)";
    case NVC697_CALL_MME_MACRO(43):
        return "NVC697_CALL_MME_MACRO(43)";
    case NVC697_CALL_MME_MACRO(44):
        return "NVC697_CALL_MME_MACRO(44)";
    case NVC697_CALL_MME_MACRO(45):
        return "NVC697_CALL_MME_MACRO(45)";
    case NVC697_CALL_MME_MACRO(46):
        return "NVC697_CALL_MME_MACRO(46)";
    case NVC697_CALL_MME_MACRO(47):
        return "NVC697_CALL_MME_MACRO(47)";
    case NVC697_CALL_MME_MACRO(48):
        return "NVC697_CALL_MME_MACRO(48)";
    case NVC697_CALL_MME_MACRO(49):
        return "NVC697_CALL_MME_MACRO(49)";
    case NVC697_CALL_MME_MACRO(50):
        return "NVC697_CALL_MME_MACRO(50)";
    case NVC697_CALL_MME_MACRO(51):
        return "NVC697_CALL_MME_MACRO(51)";
    case NVC697_CALL_MME_MACRO(52):
        return "NVC697_CALL_MME_MACRO(52)";
    case NVC697_CALL_MME_MACRO(53):
        return "NVC697_CALL_MME_MACRO(53)";
    case NVC697_CALL_MME_MACRO(54):
        return "NVC697_CALL_MME_MACRO(54)";
    case NVC697_CALL_MME_MACRO(55):
        return "NVC697_CALL_MME_MACRO(55)";
    case NVC697_CALL_MME_MACRO(56):
        return "NVC697_CALL_MME_MACRO(56)";
    case NVC697_CALL_MME_MACRO(57):
        return "NVC697_CALL_MME_MACRO(57)";
    case NVC697_CALL_MME_MACRO(58):
        return "NVC697_CALL_MME_MACRO(58)";
    case NVC697_CALL_MME_MACRO(59):
        return "NVC697_CALL_MME_MACRO(59)";
    case NVC697_CALL_MME_MACRO(60):
        return "NVC697_CALL_MME_MACRO(60)";
    case NVC697_CALL_MME_MACRO(61):
        return "NVC697_CALL_MME_MACRO(61)";
    case NVC697_CALL_MME_MACRO(62):
        return "NVC697_CALL_MME_MACRO(62)";
    case NVC697_CALL_MME_MACRO(63):
        return "NVC697_CALL_MME_MACRO(63)";
    case NVC697_CALL_MME_MACRO(64):
        return "NVC697_CALL_MME_MACRO(64)";
    case NVC697_CALL_MME_MACRO(65):
        return "NVC697_CALL_MME_MACRO(65)";
    case NVC697_CALL_MME_MACRO(66):
        return "NVC697_CALL_MME_MACRO(66)";
    case NVC697_CALL_MME_MACRO(67):
        return "NVC697_CALL_MME_MACRO(67)";
    case NVC697_CALL_MME_MACRO(68):
        return "NVC697_CALL_MME_MACRO(68)";
    case NVC697_CALL_MME_MACRO(69):
        return "NVC697_CALL_MME_MACRO(69)";
    case NVC697_CALL_MME_MACRO(70):
        return "NVC697_CALL_MME_MACRO(70)";
    case NVC697_CALL_MME_MACRO(71):
        return "NVC697_CALL_MME_MACRO(71)";
    case NVC697_CALL_MME_MACRO(72):
        return "NVC697_CALL_MME_MACRO(72)";
    case NVC697_CALL_MME_MACRO(73):
        return "NVC697_CALL_MME_MACRO(73)";
    case NVC697_CALL_MME_MACRO(74):
        return "NVC697_CALL_MME_MACRO(74)";
    case NVC697_CALL_MME_MACRO(75):
        return "NVC697_CALL_MME_MACRO(75)";
    case NVC697_CALL_MME_MACRO(76):
        return "NVC697_CALL_MME_MACRO(76)";
    case NVC697_CALL_MME_MACRO(77):
        return "NVC697_CALL_MME_MACRO(77)";
    case NVC697_CALL_MME_MACRO(78):
        return "NVC697_CALL_MME_MACRO(78)";
    case NVC697_CALL_MME_MACRO(79):
        return "NVC697_CALL_MME_MACRO(79)";
    case NVC697_CALL_MME_MACRO(80):
        return "NVC697_CALL_MME_MACRO(80)";
    case NVC697_CALL_MME_MACRO(81):
        return "NVC697_CALL_MME_MACRO(81)";
    case NVC697_CALL_MME_MACRO(82):
        return "NVC697_CALL_MME_MACRO(82)";
    case NVC697_CALL_MME_MACRO(83):
        return "NVC697_CALL_MME_MACRO(83)";
    case NVC697_CALL_MME_MACRO(84):
        return "NVC697_CALL_MME_MACRO(84)";
    case NVC697_CALL_MME_MACRO(85):
        return "NVC697_CALL_MME_MACRO(85)";
    case NVC697_CALL_MME_MACRO(86):
        return "NVC697_CALL_MME_MACRO(86)";
    case NVC697_CALL_MME_MACRO(87):
        return "NVC697_CALL_MME_MACRO(87)";
    case NVC697_CALL_MME_MACRO(88):
        return "NVC697_CALL_MME_MACRO(88)";
    case NVC697_CALL_MME_MACRO(89):
        return "NVC697_CALL_MME_MACRO(89)";
    case NVC697_CALL_MME_MACRO(90):
        return "NVC697_CALL_MME_MACRO(90)";
    case NVC697_CALL_MME_MACRO(91):
        return "NVC697_CALL_MME_MACRO(91)";
    case NVC697_CALL_MME_MACRO(92):
        return "NVC697_CALL_MME_MACRO(92)";
    case NVC697_CALL_MME_MACRO(93):
        return "NVC697_CALL_MME_MACRO(93)";
    case NVC697_CALL_MME_MACRO(94):
        return "NVC697_CALL_MME_MACRO(94)";
    case NVC697_CALL_MME_MACRO(95):
        return "NVC697_CALL_MME_MACRO(95)";
    case NVC697_CALL_MME_MACRO(96):
        return "NVC697_CALL_MME_MACRO(96)";
    case NVC697_CALL_MME_MACRO(97):
        return "NVC697_CALL_MME_MACRO(97)";
    case NVC697_CALL_MME_MACRO(98):
        return "NVC697_CALL_MME_MACRO(98)";
    case NVC697_CALL_MME_MACRO(99):
        return "NVC697_CALL_MME_MACRO(99)";
    case NVC697_CALL_MME_MACRO(100):
        return "NVC697_CALL_MME_MACRO(100)";
    case NVC697_CALL_MME_MACRO(101):
        return "NVC697_CALL_MME_MACRO(101)";
    case NVC697_CALL_MME_MACRO(102):
        return "NVC697_CALL_MME_MACRO(102)";
    case NVC697_CALL_MME_MACRO(103):
        return "NVC697_CALL_MME_MACRO(103)";
    case NVC697_CALL_MME_MACRO(104):
        return "NVC697_CALL_MME_MACRO(104)";
    case NVC697_CALL_MME_MACRO(105):
        return "NVC697_CALL_MME_MACRO(105)";
    case NVC697_CALL_MME_MACRO(106):
        return "NVC697_CALL_MME_MACRO(106)";
    case NVC697_CALL_MME_MACRO(107):
        return "NVC697_CALL_MME_MACRO(107)";
    case NVC697_CALL_MME_MACRO(108):
        return "NVC697_CALL_MME_MACRO(108)";
    case NVC697_CALL_MME_MACRO(109):
        return "NVC697_CALL_MME_MACRO(109)";
    case NVC697_CALL_MME_MACRO(110):
        return "NVC697_CALL_MME_MACRO(110)";
    case NVC697_CALL_MME_MACRO(111):
        return "NVC697_CALL_MME_MACRO(111)";
    case NVC697_CALL_MME_MACRO(112):
        return "NVC697_CALL_MME_MACRO(112)";
    case NVC697_CALL_MME_MACRO(113):
        return "NVC697_CALL_MME_MACRO(113)";
    case NVC697_CALL_MME_MACRO(114):
        return "NVC697_CALL_MME_MACRO(114)";
    case NVC697_CALL_MME_MACRO(115):
        return "NVC697_CALL_MME_MACRO(115)";
    case NVC697_CALL_MME_MACRO(116):
        return "NVC697_CALL_MME_MACRO(116)";
    case NVC697_CALL_MME_MACRO(117):
        return "NVC697_CALL_MME_MACRO(117)";
    case NVC697_CALL_MME_MACRO(118):
        return "NVC697_CALL_MME_MACRO(118)";
    case NVC697_CALL_MME_MACRO(119):
        return "NVC697_CALL_MME_MACRO(119)";
    case NVC697_CALL_MME_MACRO(120):
        return "NVC697_CALL_MME_MACRO(120)";
    case NVC697_CALL_MME_MACRO(121):
        return "NVC697_CALL_MME_MACRO(121)";
    case NVC697_CALL_MME_MACRO(122):
        return "NVC697_CALL_MME_MACRO(122)";
    case NVC697_CALL_MME_MACRO(123):
        return "NVC697_CALL_MME_MACRO(123)";
    case NVC697_CALL_MME_MACRO(124):
        return "NVC697_CALL_MME_MACRO(124)";
    case NVC697_CALL_MME_MACRO(125):
        return "NVC697_CALL_MME_MACRO(125)";
    case NVC697_CALL_MME_MACRO(126):
        return "NVC697_CALL_MME_MACRO(126)";
    case NVC697_CALL_MME_MACRO(127):
        return "NVC697_CALL_MME_MACRO(127)";
    case NVC697_CALL_MME_MACRO(128):
        return "NVC697_CALL_MME_MACRO(128)";
    case NVC697_CALL_MME_MACRO(129):
        return "NVC697_CALL_MME_MACRO(129)";
    case NVC697_CALL_MME_MACRO(130):
        return "NVC697_CALL_MME_MACRO(130)";
    case NVC697_CALL_MME_MACRO(131):
        return "NVC697_CALL_MME_MACRO(131)";
    case NVC697_CALL_MME_MACRO(132):
        return "NVC697_CALL_MME_MACRO(132)";
    case NVC697_CALL_MME_MACRO(133):
        return "NVC697_CALL_MME_MACRO(133)";
    case NVC697_CALL_MME_MACRO(134):
        return "NVC697_CALL_MME_MACRO(134)";
    case NVC697_CALL_MME_MACRO(135):
        return "NVC697_CALL_MME_MACRO(135)";
    case NVC697_CALL_MME_MACRO(136):
        return "NVC697_CALL_MME_MACRO(136)";
    case NVC697_CALL_MME_MACRO(137):
        return "NVC697_CALL_MME_MACRO(137)";
    case NVC697_CALL_MME_MACRO(138):
        return "NVC697_CALL_MME_MACRO(138)";
    case NVC697_CALL_MME_MACRO(139):
        return "NVC697_CALL_MME_MACRO(139)";
    case NVC697_CALL_MME_MACRO(140):
        return "NVC697_CALL_MME_MACRO(140)";
    case NVC697_CALL_MME_MACRO(141):
        return "NVC697_CALL_MME_MACRO(141)";
    case NVC697_CALL_MME_MACRO(142):
        return "NVC697_CALL_MME_MACRO(142)";
    case NVC697_CALL_MME_MACRO(143):
        return "NVC697_CALL_MME_MACRO(143)";
    case NVC697_CALL_MME_MACRO(144):
        return "NVC697_CALL_MME_MACRO(144)";
    case NVC697_CALL_MME_MACRO(145):
        return "NVC697_CALL_MME_MACRO(145)";
    case NVC697_CALL_MME_MACRO(146):
        return "NVC697_CALL_MME_MACRO(146)";
    case NVC697_CALL_MME_MACRO(147):
        return "NVC697_CALL_MME_MACRO(147)";
    case NVC697_CALL_MME_MACRO(148):
        return "NVC697_CALL_MME_MACRO(148)";
    case NVC697_CALL_MME_MACRO(149):
        return "NVC697_CALL_MME_MACRO(149)";
    case NVC697_CALL_MME_MACRO(150):
        return "NVC697_CALL_MME_MACRO(150)";
    case NVC697_CALL_MME_MACRO(151):
        return "NVC697_CALL_MME_MACRO(151)";
    case NVC697_CALL_MME_MACRO(152):
        return "NVC697_CALL_MME_MACRO(152)";
    case NVC697_CALL_MME_MACRO(153):
        return "NVC697_CALL_MME_MACRO(153)";
    case NVC697_CALL_MME_MACRO(154):
        return "NVC697_CALL_MME_MACRO(154)";
    case NVC697_CALL_MME_MACRO(155):
        return "NVC697_CALL_MME_MACRO(155)";
    case NVC697_CALL_MME_MACRO(156):
        return "NVC697_CALL_MME_MACRO(156)";
    case NVC697_CALL_MME_MACRO(157):
        return "NVC697_CALL_MME_MACRO(157)";
    case NVC697_CALL_MME_MACRO(158):
        return "NVC697_CALL_MME_MACRO(158)";
    case NVC697_CALL_MME_MACRO(159):
        return "NVC697_CALL_MME_MACRO(159)";
    case NVC697_CALL_MME_MACRO(160):
        return "NVC697_CALL_MME_MACRO(160)";
    case NVC697_CALL_MME_MACRO(161):
        return "NVC697_CALL_MME_MACRO(161)";
    case NVC697_CALL_MME_MACRO(162):
        return "NVC697_CALL_MME_MACRO(162)";
    case NVC697_CALL_MME_MACRO(163):
        return "NVC697_CALL_MME_MACRO(163)";
    case NVC697_CALL_MME_MACRO(164):
        return "NVC697_CALL_MME_MACRO(164)";
    case NVC697_CALL_MME_MACRO(165):
        return "NVC697_CALL_MME_MACRO(165)";
    case NVC697_CALL_MME_MACRO(166):
        return "NVC697_CALL_MME_MACRO(166)";
    case NVC697_CALL_MME_MACRO(167):
        return "NVC697_CALL_MME_MACRO(167)";
    case NVC697_CALL_MME_MACRO(168):
        return "NVC697_CALL_MME_MACRO(168)";
    case NVC697_CALL_MME_MACRO(169):
        return "NVC697_CALL_MME_MACRO(169)";
    case NVC697_CALL_MME_MACRO(170):
        return "NVC697_CALL_MME_MACRO(170)";
    case NVC697_CALL_MME_MACRO(171):
        return "NVC697_CALL_MME_MACRO(171)";
    case NVC697_CALL_MME_MACRO(172):
        return "NVC697_CALL_MME_MACRO(172)";
    case NVC697_CALL_MME_MACRO(173):
        return "NVC697_CALL_MME_MACRO(173)";
    case NVC697_CALL_MME_MACRO(174):
        return "NVC697_CALL_MME_MACRO(174)";
    case NVC697_CALL_MME_MACRO(175):
        return "NVC697_CALL_MME_MACRO(175)";
    case NVC697_CALL_MME_MACRO(176):
        return "NVC697_CALL_MME_MACRO(176)";
    case NVC697_CALL_MME_MACRO(177):
        return "NVC697_CALL_MME_MACRO(177)";
    case NVC697_CALL_MME_MACRO(178):
        return "NVC697_CALL_MME_MACRO(178)";
    case NVC697_CALL_MME_MACRO(179):
        return "NVC697_CALL_MME_MACRO(179)";
    case NVC697_CALL_MME_MACRO(180):
        return "NVC697_CALL_MME_MACRO(180)";
    case NVC697_CALL_MME_MACRO(181):
        return "NVC697_CALL_MME_MACRO(181)";
    case NVC697_CALL_MME_MACRO(182):
        return "NVC697_CALL_MME_MACRO(182)";
    case NVC697_CALL_MME_MACRO(183):
        return "NVC697_CALL_MME_MACRO(183)";
    case NVC697_CALL_MME_MACRO(184):
        return "NVC697_CALL_MME_MACRO(184)";
    case NVC697_CALL_MME_MACRO(185):
        return "NVC697_CALL_MME_MACRO(185)";
    case NVC697_CALL_MME_MACRO(186):
        return "NVC697_CALL_MME_MACRO(186)";
    case NVC697_CALL_MME_MACRO(187):
        return "NVC697_CALL_MME_MACRO(187)";
    case NVC697_CALL_MME_MACRO(188):
        return "NVC697_CALL_MME_MACRO(188)";
    case NVC697_CALL_MME_MACRO(189):
        return "NVC697_CALL_MME_MACRO(189)";
    case NVC697_CALL_MME_MACRO(190):
        return "NVC697_CALL_MME_MACRO(190)";
    case NVC697_CALL_MME_MACRO(191):
        return "NVC697_CALL_MME_MACRO(191)";
    case NVC697_CALL_MME_MACRO(192):
        return "NVC697_CALL_MME_MACRO(192)";
    case NVC697_CALL_MME_MACRO(193):
        return "NVC697_CALL_MME_MACRO(193)";
    case NVC697_CALL_MME_MACRO(194):
        return "NVC697_CALL_MME_MACRO(194)";
    case NVC697_CALL_MME_MACRO(195):
        return "NVC697_CALL_MME_MACRO(195)";
    case NVC697_CALL_MME_MACRO(196):
        return "NVC697_CALL_MME_MACRO(196)";
    case NVC697_CALL_MME_MACRO(197):
        return "NVC697_CALL_MME_MACRO(197)";
    case NVC697_CALL_MME_MACRO(198):
        return "NVC697_CALL_MME_MACRO(198)";
    case NVC697_CALL_MME_MACRO(199):
        return "NVC697_CALL_MME_MACRO(199)";
    case NVC697_CALL_MME_MACRO(200):
        return "NVC697_CALL_MME_MACRO(200)";
    case NVC697_CALL_MME_MACRO(201):
        return "NVC697_CALL_MME_MACRO(201)";
    case NVC697_CALL_MME_MACRO(202):
        return "NVC697_CALL_MME_MACRO(202)";
    case NVC697_CALL_MME_MACRO(203):
        return "NVC697_CALL_MME_MACRO(203)";
    case NVC697_CALL_MME_MACRO(204):
        return "NVC697_CALL_MME_MACRO(204)";
    case NVC697_CALL_MME_MACRO(205):
        return "NVC697_CALL_MME_MACRO(205)";
    case NVC697_CALL_MME_MACRO(206):
        return "NVC697_CALL_MME_MACRO(206)";
    case NVC697_CALL_MME_MACRO(207):
        return "NVC697_CALL_MME_MACRO(207)";
    case NVC697_CALL_MME_MACRO(208):
        return "NVC697_CALL_MME_MACRO(208)";
    case NVC697_CALL_MME_MACRO(209):
        return "NVC697_CALL_MME_MACRO(209)";
    case NVC697_CALL_MME_MACRO(210):
        return "NVC697_CALL_MME_MACRO(210)";
    case NVC697_CALL_MME_MACRO(211):
        return "NVC697_CALL_MME_MACRO(211)";
    case NVC697_CALL_MME_MACRO(212):
        return "NVC697_CALL_MME_MACRO(212)";
    case NVC697_CALL_MME_MACRO(213):
        return "NVC697_CALL_MME_MACRO(213)";
    case NVC697_CALL_MME_MACRO(214):
        return "NVC697_CALL_MME_MACRO(214)";
    case NVC697_CALL_MME_MACRO(215):
        return "NVC697_CALL_MME_MACRO(215)";
    case NVC697_CALL_MME_MACRO(216):
        return "NVC697_CALL_MME_MACRO(216)";
    case NVC697_CALL_MME_MACRO(217):
        return "NVC697_CALL_MME_MACRO(217)";
    case NVC697_CALL_MME_MACRO(218):
        return "NVC697_CALL_MME_MACRO(218)";
    case NVC697_CALL_MME_MACRO(219):
        return "NVC697_CALL_MME_MACRO(219)";
    case NVC697_CALL_MME_MACRO(220):
        return "NVC697_CALL_MME_MACRO(220)";
    case NVC697_CALL_MME_MACRO(221):
        return "NVC697_CALL_MME_MACRO(221)";
    case NVC697_CALL_MME_MACRO(222):
        return "NVC697_CALL_MME_MACRO(222)";
    case NVC697_CALL_MME_MACRO(223):
        return "NVC697_CALL_MME_MACRO(223)";
    case NVC697_CALL_MME_MACRO(224):
        return "NVC697_CALL_MME_MACRO(224)";
    case NVC697_CALL_MME_MACRO(225):
        return "NVC697_CALL_MME_MACRO(225)";
    case NVC697_CALL_MME_MACRO(226):
        return "NVC697_CALL_MME_MACRO(226)";
    case NVC697_CALL_MME_MACRO(227):
        return "NVC697_CALL_MME_MACRO(227)";
    case NVC697_CALL_MME_MACRO(228):
        return "NVC697_CALL_MME_MACRO(228)";
    case NVC697_CALL_MME_MACRO(229):
        return "NVC697_CALL_MME_MACRO(229)";
    case NVC697_CALL_MME_MACRO(230):
        return "NVC697_CALL_MME_MACRO(230)";
    case NVC697_CALL_MME_MACRO(231):
        return "NVC697_CALL_MME_MACRO(231)";
    case NVC697_CALL_MME_MACRO(232):
        return "NVC697_CALL_MME_MACRO(232)";
    case NVC697_CALL_MME_MACRO(233):
        return "NVC697_CALL_MME_MACRO(233)";
    case NVC697_CALL_MME_MACRO(234):
        return "NVC697_CALL_MME_MACRO(234)";
    case NVC697_CALL_MME_MACRO(235):
        return "NVC697_CALL_MME_MACRO(235)";
    case NVC697_CALL_MME_MACRO(236):
        return "NVC697_CALL_MME_MACRO(236)";
    case NVC697_CALL_MME_MACRO(237):
        return "NVC697_CALL_MME_MACRO(237)";
    case NVC697_CALL_MME_MACRO(238):
        return "NVC697_CALL_MME_MACRO(238)";
    case NVC697_CALL_MME_MACRO(239):
        return "NVC697_CALL_MME_MACRO(239)";
    case NVC697_CALL_MME_MACRO(240):
        return "NVC697_CALL_MME_MACRO(240)";
    case NVC697_CALL_MME_MACRO(241):
        return "NVC697_CALL_MME_MACRO(241)";
    case NVC697_CALL_MME_MACRO(242):
        return "NVC697_CALL_MME_MACRO(242)";
    case NVC697_CALL_MME_MACRO(243):
        return "NVC697_CALL_MME_MACRO(243)";
    case NVC697_CALL_MME_MACRO(244):
        return "NVC697_CALL_MME_MACRO(244)";
    case NVC697_CALL_MME_MACRO(245):
        return "NVC697_CALL_MME_MACRO(245)";
    case NVC697_CALL_MME_MACRO(246):
        return "NVC697_CALL_MME_MACRO(246)";
    case NVC697_CALL_MME_MACRO(247):
        return "NVC697_CALL_MME_MACRO(247)";
    case NVC697_CALL_MME_MACRO(248):
        return "NVC697_CALL_MME_MACRO(248)";
    case NVC697_CALL_MME_MACRO(249):
        return "NVC697_CALL_MME_MACRO(249)";
    case NVC697_CALL_MME_MACRO(250):
        return "NVC697_CALL_MME_MACRO(250)";
    case NVC697_CALL_MME_MACRO(251):
        return "NVC697_CALL_MME_MACRO(251)";
    case NVC697_CALL_MME_MACRO(252):
        return "NVC697_CALL_MME_MACRO(252)";
    case NVC697_CALL_MME_MACRO(253):
        return "NVC697_CALL_MME_MACRO(253)";
    case NVC697_CALL_MME_MACRO(254):
        return "NVC697_CALL_MME_MACRO(254)";
    case NVC697_CALL_MME_MACRO(255):
        return "NVC697_CALL_MME_MACRO(255)";
    case NVC697_CALL_MME_DATA(0):
        return "NVC697_CALL_MME_DATA(0)";
    case NVC697_CALL_MME_DATA(1):
        return "NVC697_CALL_MME_DATA(1)";
    case NVC697_CALL_MME_DATA(2):
        return "NVC697_CALL_MME_DATA(2)";
    case NVC697_CALL_MME_DATA(3):
        return "NVC697_CALL_MME_DATA(3)";
    case NVC697_CALL_MME_DATA(4):
        return "NVC697_CALL_MME_DATA(4)";
    case NVC697_CALL_MME_DATA(5):
        return "NVC697_CALL_MME_DATA(5)";
    case NVC697_CALL_MME_DATA(6):
        return "NVC697_CALL_MME_DATA(6)";
    case NVC697_CALL_MME_DATA(7):
        return "NVC697_CALL_MME_DATA(7)";
    case NVC697_CALL_MME_DATA(8):
        return "NVC697_CALL_MME_DATA(8)";
    case NVC697_CALL_MME_DATA(9):
        return "NVC697_CALL_MME_DATA(9)";
    case NVC697_CALL_MME_DATA(10):
        return "NVC697_CALL_MME_DATA(10)";
    case NVC697_CALL_MME_DATA(11):
        return "NVC697_CALL_MME_DATA(11)";
    case NVC697_CALL_MME_DATA(12):
        return "NVC697_CALL_MME_DATA(12)";
    case NVC697_CALL_MME_DATA(13):
        return "NVC697_CALL_MME_DATA(13)";
    case NVC697_CALL_MME_DATA(14):
        return "NVC697_CALL_MME_DATA(14)";
    case NVC697_CALL_MME_DATA(15):
        return "NVC697_CALL_MME_DATA(15)";
    case NVC697_CALL_MME_DATA(16):
        return "NVC697_CALL_MME_DATA(16)";
    case NVC697_CALL_MME_DATA(17):
        return "NVC697_CALL_MME_DATA(17)";
    case NVC697_CALL_MME_DATA(18):
        return "NVC697_CALL_MME_DATA(18)";
    case NVC697_CALL_MME_DATA(19):
        return "NVC697_CALL_MME_DATA(19)";
    case NVC697_CALL_MME_DATA(20):
        return "NVC697_CALL_MME_DATA(20)";
    case NVC697_CALL_MME_DATA(21):
        return "NVC697_CALL_MME_DATA(21)";
    case NVC697_CALL_MME_DATA(22):
        return "NVC697_CALL_MME_DATA(22)";
    case NVC697_CALL_MME_DATA(23):
        return "NVC697_CALL_MME_DATA(23)";
    case NVC697_CALL_MME_DATA(24):
        return "NVC697_CALL_MME_DATA(24)";
    case NVC697_CALL_MME_DATA(25):
        return "NVC697_CALL_MME_DATA(25)";
    case NVC697_CALL_MME_DATA(26):
        return "NVC697_CALL_MME_DATA(26)";
    case NVC697_CALL_MME_DATA(27):
        return "NVC697_CALL_MME_DATA(27)";
    case NVC697_CALL_MME_DATA(28):
        return "NVC697_CALL_MME_DATA(28)";
    case NVC697_CALL_MME_DATA(29):
        return "NVC697_CALL_MME_DATA(29)";
    case NVC697_CALL_MME_DATA(30):
        return "NVC697_CALL_MME_DATA(30)";
    case NVC697_CALL_MME_DATA(31):
        return "NVC697_CALL_MME_DATA(31)";
    case NVC697_CALL_MME_DATA(32):
        return "NVC697_CALL_MME_DATA(32)";
    case NVC697_CALL_MME_DATA(33):
        return "NVC697_CALL_MME_DATA(33)";
    case NVC697_CALL_MME_DATA(34):
        return "NVC697_CALL_MME_DATA(34)";
    case NVC697_CALL_MME_DATA(35):
        return "NVC697_CALL_MME_DATA(35)";
    case NVC697_CALL_MME_DATA(36):
        return "NVC697_CALL_MME_DATA(36)";
    case NVC697_CALL_MME_DATA(37):
        return "NVC697_CALL_MME_DATA(37)";
    case NVC697_CALL_MME_DATA(38):
        return "NVC697_CALL_MME_DATA(38)";
    case NVC697_CALL_MME_DATA(39):
        return "NVC697_CALL_MME_DATA(39)";
    case NVC697_CALL_MME_DATA(40):
        return "NVC697_CALL_MME_DATA(40)";
    case NVC697_CALL_MME_DATA(41):
        return "NVC697_CALL_MME_DATA(41)";
    case NVC697_CALL_MME_DATA(42):
        return "NVC697_CALL_MME_DATA(42)";
    case NVC697_CALL_MME_DATA(43):
        return "NVC697_CALL_MME_DATA(43)";
    case NVC697_CALL_MME_DATA(44):
        return "NVC697_CALL_MME_DATA(44)";
    case NVC697_CALL_MME_DATA(45):
        return "NVC697_CALL_MME_DATA(45)";
    case NVC697_CALL_MME_DATA(46):
        return "NVC697_CALL_MME_DATA(46)";
    case NVC697_CALL_MME_DATA(47):
        return "NVC697_CALL_MME_DATA(47)";
    case NVC697_CALL_MME_DATA(48):
        return "NVC697_CALL_MME_DATA(48)";
    case NVC697_CALL_MME_DATA(49):
        return "NVC697_CALL_MME_DATA(49)";
    case NVC697_CALL_MME_DATA(50):
        return "NVC697_CALL_MME_DATA(50)";
    case NVC697_CALL_MME_DATA(51):
        return "NVC697_CALL_MME_DATA(51)";
    case NVC697_CALL_MME_DATA(52):
        return "NVC697_CALL_MME_DATA(52)";
    case NVC697_CALL_MME_DATA(53):
        return "NVC697_CALL_MME_DATA(53)";
    case NVC697_CALL_MME_DATA(54):
        return "NVC697_CALL_MME_DATA(54)";
    case NVC697_CALL_MME_DATA(55):
        return "NVC697_CALL_MME_DATA(55)";
    case NVC697_CALL_MME_DATA(56):
        return "NVC697_CALL_MME_DATA(56)";
    case NVC697_CALL_MME_DATA(57):
        return "NVC697_CALL_MME_DATA(57)";
    case NVC697_CALL_MME_DATA(58):
        return "NVC697_CALL_MME_DATA(58)";
    case NVC697_CALL_MME_DATA(59):
        return "NVC697_CALL_MME_DATA(59)";
    case NVC697_CALL_MME_DATA(60):
        return "NVC697_CALL_MME_DATA(60)";
    case NVC697_CALL_MME_DATA(61):
        return "NVC697_CALL_MME_DATA(61)";
    case NVC697_CALL_MME_DATA(62):
        return "NVC697_CALL_MME_DATA(62)";
    case NVC697_CALL_MME_DATA(63):
        return "NVC697_CALL_MME_DATA(63)";
    case NVC697_CALL_MME_DATA(64):
        return "NVC697_CALL_MME_DATA(64)";
    case NVC697_CALL_MME_DATA(65):
        return "NVC697_CALL_MME_DATA(65)";
    case NVC697_CALL_MME_DATA(66):
        return "NVC697_CALL_MME_DATA(66)";
    case NVC697_CALL_MME_DATA(67):
        return "NVC697_CALL_MME_DATA(67)";
    case NVC697_CALL_MME_DATA(68):
        return "NVC697_CALL_MME_DATA(68)";
    case NVC697_CALL_MME_DATA(69):
        return "NVC697_CALL_MME_DATA(69)";
    case NVC697_CALL_MME_DATA(70):
        return "NVC697_CALL_MME_DATA(70)";
    case NVC697_CALL_MME_DATA(71):
        return "NVC697_CALL_MME_DATA(71)";
    case NVC697_CALL_MME_DATA(72):
        return "NVC697_CALL_MME_DATA(72)";
    case NVC697_CALL_MME_DATA(73):
        return "NVC697_CALL_MME_DATA(73)";
    case NVC697_CALL_MME_DATA(74):
        return "NVC697_CALL_MME_DATA(74)";
    case NVC697_CALL_MME_DATA(75):
        return "NVC697_CALL_MME_DATA(75)";
    case NVC697_CALL_MME_DATA(76):
        return "NVC697_CALL_MME_DATA(76)";
    case NVC697_CALL_MME_DATA(77):
        return "NVC697_CALL_MME_DATA(77)";
    case NVC697_CALL_MME_DATA(78):
        return "NVC697_CALL_MME_DATA(78)";
    case NVC697_CALL_MME_DATA(79):
        return "NVC697_CALL_MME_DATA(79)";
    case NVC697_CALL_MME_DATA(80):
        return "NVC697_CALL_MME_DATA(80)";
    case NVC697_CALL_MME_DATA(81):
        return "NVC697_CALL_MME_DATA(81)";
    case NVC697_CALL_MME_DATA(82):
        return "NVC697_CALL_MME_DATA(82)";
    case NVC697_CALL_MME_DATA(83):
        return "NVC697_CALL_MME_DATA(83)";
    case NVC697_CALL_MME_DATA(84):
        return "NVC697_CALL_MME_DATA(84)";
    case NVC697_CALL_MME_DATA(85):
        return "NVC697_CALL_MME_DATA(85)";
    case NVC697_CALL_MME_DATA(86):
        return "NVC697_CALL_MME_DATA(86)";
    case NVC697_CALL_MME_DATA(87):
        return "NVC697_CALL_MME_DATA(87)";
    case NVC697_CALL_MME_DATA(88):
        return "NVC697_CALL_MME_DATA(88)";
    case NVC697_CALL_MME_DATA(89):
        return "NVC697_CALL_MME_DATA(89)";
    case NVC697_CALL_MME_DATA(90):
        return "NVC697_CALL_MME_DATA(90)";
    case NVC697_CALL_MME_DATA(91):
        return "NVC697_CALL_MME_DATA(91)";
    case NVC697_CALL_MME_DATA(92):
        return "NVC697_CALL_MME_DATA(92)";
    case NVC697_CALL_MME_DATA(93):
        return "NVC697_CALL_MME_DATA(93)";
    case NVC697_CALL_MME_DATA(94):
        return "NVC697_CALL_MME_DATA(94)";
    case NVC697_CALL_MME_DATA(95):
        return "NVC697_CALL_MME_DATA(95)";
    case NVC697_CALL_MME_DATA(96):
        return "NVC697_CALL_MME_DATA(96)";
    case NVC697_CALL_MME_DATA(97):
        return "NVC697_CALL_MME_DATA(97)";
    case NVC697_CALL_MME_DATA(98):
        return "NVC697_CALL_MME_DATA(98)";
    case NVC697_CALL_MME_DATA(99):
        return "NVC697_CALL_MME_DATA(99)";
    case NVC697_CALL_MME_DATA(100):
        return "NVC697_CALL_MME_DATA(100)";
    case NVC697_CALL_MME_DATA(101):
        return "NVC697_CALL_MME_DATA(101)";
    case NVC697_CALL_MME_DATA(102):
        return "NVC697_CALL_MME_DATA(102)";
    case NVC697_CALL_MME_DATA(103):
        return "NVC697_CALL_MME_DATA(103)";
    case NVC697_CALL_MME_DATA(104):
        return "NVC697_CALL_MME_DATA(104)";
    case NVC697_CALL_MME_DATA(105):
        return "NVC697_CALL_MME_DATA(105)";
    case NVC697_CALL_MME_DATA(106):
        return "NVC697_CALL_MME_DATA(106)";
    case NVC697_CALL_MME_DATA(107):
        return "NVC697_CALL_MME_DATA(107)";
    case NVC697_CALL_MME_DATA(108):
        return "NVC697_CALL_MME_DATA(108)";
    case NVC697_CALL_MME_DATA(109):
        return "NVC697_CALL_MME_DATA(109)";
    case NVC697_CALL_MME_DATA(110):
        return "NVC697_CALL_MME_DATA(110)";
    case NVC697_CALL_MME_DATA(111):
        return "NVC697_CALL_MME_DATA(111)";
    case NVC697_CALL_MME_DATA(112):
        return "NVC697_CALL_MME_DATA(112)";
    case NVC697_CALL_MME_DATA(113):
        return "NVC697_CALL_MME_DATA(113)";
    case NVC697_CALL_MME_DATA(114):
        return "NVC697_CALL_MME_DATA(114)";
    case NVC697_CALL_MME_DATA(115):
        return "NVC697_CALL_MME_DATA(115)";
    case NVC697_CALL_MME_DATA(116):
        return "NVC697_CALL_MME_DATA(116)";
    case NVC697_CALL_MME_DATA(117):
        return "NVC697_CALL_MME_DATA(117)";
    case NVC697_CALL_MME_DATA(118):
        return "NVC697_CALL_MME_DATA(118)";
    case NVC697_CALL_MME_DATA(119):
        return "NVC697_CALL_MME_DATA(119)";
    case NVC697_CALL_MME_DATA(120):
        return "NVC697_CALL_MME_DATA(120)";
    case NVC697_CALL_MME_DATA(121):
        return "NVC697_CALL_MME_DATA(121)";
    case NVC697_CALL_MME_DATA(122):
        return "NVC697_CALL_MME_DATA(122)";
    case NVC697_CALL_MME_DATA(123):
        return "NVC697_CALL_MME_DATA(123)";
    case NVC697_CALL_MME_DATA(124):
        return "NVC697_CALL_MME_DATA(124)";
    case NVC697_CALL_MME_DATA(125):
        return "NVC697_CALL_MME_DATA(125)";
    case NVC697_CALL_MME_DATA(126):
        return "NVC697_CALL_MME_DATA(126)";
    case NVC697_CALL_MME_DATA(127):
        return "NVC697_CALL_MME_DATA(127)";
    case NVC697_CALL_MME_DATA(128):
        return "NVC697_CALL_MME_DATA(128)";
    case NVC697_CALL_MME_DATA(129):
        return "NVC697_CALL_MME_DATA(129)";
    case NVC697_CALL_MME_DATA(130):
        return "NVC697_CALL_MME_DATA(130)";
    case NVC697_CALL_MME_DATA(131):
        return "NVC697_CALL_MME_DATA(131)";
    case NVC697_CALL_MME_DATA(132):
        return "NVC697_CALL_MME_DATA(132)";
    case NVC697_CALL_MME_DATA(133):
        return "NVC697_CALL_MME_DATA(133)";
    case NVC697_CALL_MME_DATA(134):
        return "NVC697_CALL_MME_DATA(134)";
    case NVC697_CALL_MME_DATA(135):
        return "NVC697_CALL_MME_DATA(135)";
    case NVC697_CALL_MME_DATA(136):
        return "NVC697_CALL_MME_DATA(136)";
    case NVC697_CALL_MME_DATA(137):
        return "NVC697_CALL_MME_DATA(137)";
    case NVC697_CALL_MME_DATA(138):
        return "NVC697_CALL_MME_DATA(138)";
    case NVC697_CALL_MME_DATA(139):
        return "NVC697_CALL_MME_DATA(139)";
    case NVC697_CALL_MME_DATA(140):
        return "NVC697_CALL_MME_DATA(140)";
    case NVC697_CALL_MME_DATA(141):
        return "NVC697_CALL_MME_DATA(141)";
    case NVC697_CALL_MME_DATA(142):
        return "NVC697_CALL_MME_DATA(142)";
    case NVC697_CALL_MME_DATA(143):
        return "NVC697_CALL_MME_DATA(143)";
    case NVC697_CALL_MME_DATA(144):
        return "NVC697_CALL_MME_DATA(144)";
    case NVC697_CALL_MME_DATA(145):
        return "NVC697_CALL_MME_DATA(145)";
    case NVC697_CALL_MME_DATA(146):
        return "NVC697_CALL_MME_DATA(146)";
    case NVC697_CALL_MME_DATA(147):
        return "NVC697_CALL_MME_DATA(147)";
    case NVC697_CALL_MME_DATA(148):
        return "NVC697_CALL_MME_DATA(148)";
    case NVC697_CALL_MME_DATA(149):
        return "NVC697_CALL_MME_DATA(149)";
    case NVC697_CALL_MME_DATA(150):
        return "NVC697_CALL_MME_DATA(150)";
    case NVC697_CALL_MME_DATA(151):
        return "NVC697_CALL_MME_DATA(151)";
    case NVC697_CALL_MME_DATA(152):
        return "NVC697_CALL_MME_DATA(152)";
    case NVC697_CALL_MME_DATA(153):
        return "NVC697_CALL_MME_DATA(153)";
    case NVC697_CALL_MME_DATA(154):
        return "NVC697_CALL_MME_DATA(154)";
    case NVC697_CALL_MME_DATA(155):
        return "NVC697_CALL_MME_DATA(155)";
    case NVC697_CALL_MME_DATA(156):
        return "NVC697_CALL_MME_DATA(156)";
    case NVC697_CALL_MME_DATA(157):
        return "NVC697_CALL_MME_DATA(157)";
    case NVC697_CALL_MME_DATA(158):
        return "NVC697_CALL_MME_DATA(158)";
    case NVC697_CALL_MME_DATA(159):
        return "NVC697_CALL_MME_DATA(159)";
    case NVC697_CALL_MME_DATA(160):
        return "NVC697_CALL_MME_DATA(160)";
    case NVC697_CALL_MME_DATA(161):
        return "NVC697_CALL_MME_DATA(161)";
    case NVC697_CALL_MME_DATA(162):
        return "NVC697_CALL_MME_DATA(162)";
    case NVC697_CALL_MME_DATA(163):
        return "NVC697_CALL_MME_DATA(163)";
    case NVC697_CALL_MME_DATA(164):
        return "NVC697_CALL_MME_DATA(164)";
    case NVC697_CALL_MME_DATA(165):
        return "NVC697_CALL_MME_DATA(165)";
    case NVC697_CALL_MME_DATA(166):
        return "NVC697_CALL_MME_DATA(166)";
    case NVC697_CALL_MME_DATA(167):
        return "NVC697_CALL_MME_DATA(167)";
    case NVC697_CALL_MME_DATA(168):
        return "NVC697_CALL_MME_DATA(168)";
    case NVC697_CALL_MME_DATA(169):
        return "NVC697_CALL_MME_DATA(169)";
    case NVC697_CALL_MME_DATA(170):
        return "NVC697_CALL_MME_DATA(170)";
    case NVC697_CALL_MME_DATA(171):
        return "NVC697_CALL_MME_DATA(171)";
    case NVC697_CALL_MME_DATA(172):
        return "NVC697_CALL_MME_DATA(172)";
    case NVC697_CALL_MME_DATA(173):
        return "NVC697_CALL_MME_DATA(173)";
    case NVC697_CALL_MME_DATA(174):
        return "NVC697_CALL_MME_DATA(174)";
    case NVC697_CALL_MME_DATA(175):
        return "NVC697_CALL_MME_DATA(175)";
    case NVC697_CALL_MME_DATA(176):
        return "NVC697_CALL_MME_DATA(176)";
    case NVC697_CALL_MME_DATA(177):
        return "NVC697_CALL_MME_DATA(177)";
    case NVC697_CALL_MME_DATA(178):
        return "NVC697_CALL_MME_DATA(178)";
    case NVC697_CALL_MME_DATA(179):
        return "NVC697_CALL_MME_DATA(179)";
    case NVC697_CALL_MME_DATA(180):
        return "NVC697_CALL_MME_DATA(180)";
    case NVC697_CALL_MME_DATA(181):
        return "NVC697_CALL_MME_DATA(181)";
    case NVC697_CALL_MME_DATA(182):
        return "NVC697_CALL_MME_DATA(182)";
    case NVC697_CALL_MME_DATA(183):
        return "NVC697_CALL_MME_DATA(183)";
    case NVC697_CALL_MME_DATA(184):
        return "NVC697_CALL_MME_DATA(184)";
    case NVC697_CALL_MME_DATA(185):
        return "NVC697_CALL_MME_DATA(185)";
    case NVC697_CALL_MME_DATA(186):
        return "NVC697_CALL_MME_DATA(186)";
    case NVC697_CALL_MME_DATA(187):
        return "NVC697_CALL_MME_DATA(187)";
    case NVC697_CALL_MME_DATA(188):
        return "NVC697_CALL_MME_DATA(188)";
    case NVC697_CALL_MME_DATA(189):
        return "NVC697_CALL_MME_DATA(189)";
    case NVC697_CALL_MME_DATA(190):
        return "NVC697_CALL_MME_DATA(190)";
    case NVC697_CALL_MME_DATA(191):
        return "NVC697_CALL_MME_DATA(191)";
    case NVC697_CALL_MME_DATA(192):
        return "NVC697_CALL_MME_DATA(192)";
    case NVC697_CALL_MME_DATA(193):
        return "NVC697_CALL_MME_DATA(193)";
    case NVC697_CALL_MME_DATA(194):
        return "NVC697_CALL_MME_DATA(194)";
    case NVC697_CALL_MME_DATA(195):
        return "NVC697_CALL_MME_DATA(195)";
    case NVC697_CALL_MME_DATA(196):
        return "NVC697_CALL_MME_DATA(196)";
    case NVC697_CALL_MME_DATA(197):
        return "NVC697_CALL_MME_DATA(197)";
    case NVC697_CALL_MME_DATA(198):
        return "NVC697_CALL_MME_DATA(198)";
    case NVC697_CALL_MME_DATA(199):
        return "NVC697_CALL_MME_DATA(199)";
    case NVC697_CALL_MME_DATA(200):
        return "NVC697_CALL_MME_DATA(200)";
    case NVC697_CALL_MME_DATA(201):
        return "NVC697_CALL_MME_DATA(201)";
    case NVC697_CALL_MME_DATA(202):
        return "NVC697_CALL_MME_DATA(202)";
    case NVC697_CALL_MME_DATA(203):
        return "NVC697_CALL_MME_DATA(203)";
    case NVC697_CALL_MME_DATA(204):
        return "NVC697_CALL_MME_DATA(204)";
    case NVC697_CALL_MME_DATA(205):
        return "NVC697_CALL_MME_DATA(205)";
    case NVC697_CALL_MME_DATA(206):
        return "NVC697_CALL_MME_DATA(206)";
    case NVC697_CALL_MME_DATA(207):
        return "NVC697_CALL_MME_DATA(207)";
    case NVC697_CALL_MME_DATA(208):
        return "NVC697_CALL_MME_DATA(208)";
    case NVC697_CALL_MME_DATA(209):
        return "NVC697_CALL_MME_DATA(209)";
    case NVC697_CALL_MME_DATA(210):
        return "NVC697_CALL_MME_DATA(210)";
    case NVC697_CALL_MME_DATA(211):
        return "NVC697_CALL_MME_DATA(211)";
    case NVC697_CALL_MME_DATA(212):
        return "NVC697_CALL_MME_DATA(212)";
    case NVC697_CALL_MME_DATA(213):
        return "NVC697_CALL_MME_DATA(213)";
    case NVC697_CALL_MME_DATA(214):
        return "NVC697_CALL_MME_DATA(214)";
    case NVC697_CALL_MME_DATA(215):
        return "NVC697_CALL_MME_DATA(215)";
    case NVC697_CALL_MME_DATA(216):
        return "NVC697_CALL_MME_DATA(216)";
    case NVC697_CALL_MME_DATA(217):
        return "NVC697_CALL_MME_DATA(217)";
    case NVC697_CALL_MME_DATA(218):
        return "NVC697_CALL_MME_DATA(218)";
    case NVC697_CALL_MME_DATA(219):
        return "NVC697_CALL_MME_DATA(219)";
    case NVC697_CALL_MME_DATA(220):
        return "NVC697_CALL_MME_DATA(220)";
    case NVC697_CALL_MME_DATA(221):
        return "NVC697_CALL_MME_DATA(221)";
    case NVC697_CALL_MME_DATA(222):
        return "NVC697_CALL_MME_DATA(222)";
    case NVC697_CALL_MME_DATA(223):
        return "NVC697_CALL_MME_DATA(223)";
    case NVC697_CALL_MME_DATA(224):
        return "NVC697_CALL_MME_DATA(224)";
    case NVC697_CALL_MME_DATA(225):
        return "NVC697_CALL_MME_DATA(225)";
    case NVC697_CALL_MME_DATA(226):
        return "NVC697_CALL_MME_DATA(226)";
    case NVC697_CALL_MME_DATA(227):
        return "NVC697_CALL_MME_DATA(227)";
    case NVC697_CALL_MME_DATA(228):
        return "NVC697_CALL_MME_DATA(228)";
    case NVC697_CALL_MME_DATA(229):
        return "NVC697_CALL_MME_DATA(229)";
    case NVC697_CALL_MME_DATA(230):
        return "NVC697_CALL_MME_DATA(230)";
    case NVC697_CALL_MME_DATA(231):
        return "NVC697_CALL_MME_DATA(231)";
    case NVC697_CALL_MME_DATA(232):
        return "NVC697_CALL_MME_DATA(232)";
    case NVC697_CALL_MME_DATA(233):
        return "NVC697_CALL_MME_DATA(233)";
    case NVC697_CALL_MME_DATA(234):
        return "NVC697_CALL_MME_DATA(234)";
    case NVC697_CALL_MME_DATA(235):
        return "NVC697_CALL_MME_DATA(235)";
    case NVC697_CALL_MME_DATA(236):
        return "NVC697_CALL_MME_DATA(236)";
    case NVC697_CALL_MME_DATA(237):
        return "NVC697_CALL_MME_DATA(237)";
    case NVC697_CALL_MME_DATA(238):
        return "NVC697_CALL_MME_DATA(238)";
    case NVC697_CALL_MME_DATA(239):
        return "NVC697_CALL_MME_DATA(239)";
    case NVC697_CALL_MME_DATA(240):
        return "NVC697_CALL_MME_DATA(240)";
    case NVC697_CALL_MME_DATA(241):
        return "NVC697_CALL_MME_DATA(241)";
    case NVC697_CALL_MME_DATA(242):
        return "NVC697_CALL_MME_DATA(242)";
    case NVC697_CALL_MME_DATA(243):
        return "NVC697_CALL_MME_DATA(243)";
    case NVC697_CALL_MME_DATA(244):
        return "NVC697_CALL_MME_DATA(244)";
    case NVC697_CALL_MME_DATA(245):
        return "NVC697_CALL_MME_DATA(245)";
    case NVC697_CALL_MME_DATA(246):
        return "NVC697_CALL_MME_DATA(246)";
    case NVC697_CALL_MME_DATA(247):
        return "NVC697_CALL_MME_DATA(247)";
    case NVC697_CALL_MME_DATA(248):
        return "NVC697_CALL_MME_DATA(248)";
    case NVC697_CALL_MME_DATA(249):
        return "NVC697_CALL_MME_DATA(249)";
    case NVC697_CALL_MME_DATA(250):
        return "NVC697_CALL_MME_DATA(250)";
    case NVC697_CALL_MME_DATA(251):
        return "NVC697_CALL_MME_DATA(251)";
    case NVC697_CALL_MME_DATA(252):
        return "NVC697_CALL_MME_DATA(252)";
    case NVC697_CALL_MME_DATA(253):
        return "NVC697_CALL_MME_DATA(253)";
    case NVC697_CALL_MME_DATA(254):
        return "NVC697_CALL_MME_DATA(254)";
    case NVC697_CALL_MME_DATA(255):
        return "NVC697_CALL_MME_DATA(255)";
    default:
        return "unknown method";
    }
}

void
P_DUMP_NVC697_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {
    case NVC697_SET_OBJECT:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CLASS_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 5) - 1);
        fprintf(fp, "%s.ENGINE_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_NO_OPERATION:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_NOTIFY_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_NOTIFY_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_NOTIFY:
    
        parsed = data;
        fprintf(fp, "%s.TYPE = ", prefix);
        switch (parsed) {
        case NVC697_NOTIFY_TYPE_WRITE_ONLY:
            fprintf(fp, "WRITE_ONLY\n");
            break;
        case NVC697_NOTIFY_TYPE_WRITE_THEN_AWAKEN:
            fprintf(fp, "WRITE_THEN_AWAKEN\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_WAIT_FOR_IDLE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_LOAD_MME_INSTRUCTION_RAM_POINTER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_LOAD_MME_INSTRUCTION_RAM:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_LOAD_MME_START_ADDRESS_RAM_POINTER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_LOAD_MME_START_ADDRESS_RAM:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_MME_SHADOW_RAM_CONTROL:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVC697_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK:
            fprintf(fp, "METHOD_TRACK\n");
            break;
        case NVC697_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK_WITH_FILTER:
            fprintf(fp, "METHOD_TRACK_WITH_FILTER\n");
            break;
        case NVC697_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_PASSTHROUGH:
            fprintf(fp, "METHOD_PASSTHROUGH\n");
            break;
        case NVC697_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_REPLAY:
            fprintf(fp, "METHOD_REPLAY\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_PEER_SEMAPHORE_RELEASE_OFFSET_UPPER:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_PEER_SEMAPHORE_RELEASE_OFFSET:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_GLOBAL_RENDER_ENABLE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_GLOBAL_RENDER_ENABLE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_GLOBAL_RENDER_ENABLE_C:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVC697_SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        case NVC697_SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL:
            fprintf(fp, "CONDITIONAL\n");
            break;
        case NVC697_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL:
            fprintf(fp, "RENDER_IF_EQUAL\n");
            break;
        case NVC697_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL:
            fprintf(fp, "RENDER_IF_NOT_EQUAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SEND_GO_IDLE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_PM_TRIGGER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_PM_TRIGGER_WFI:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_FE_ATOMIC_SEQUENCE_BEGIN:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_FE_ATOMIC_SEQUENCE_END:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_INSTRUMENTATION_METHOD_HEADER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_INSTRUMENTATION_METHOD_DATA:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_LINE_LENGTH_IN:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_LINE_COUNT:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_OFFSET_OUT_UPPER:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_OFFSET_OUT:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_PITCH_OUT:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_DST_BLOCK_SIZE:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        switch (parsed) {
        case NVC697_SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        switch (parsed) {
        case NVC697_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVC697_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVC697_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVC697_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVC697_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVC697_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.DEPTH = ", prefix);
        switch (parsed) {
        case NVC697_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVC697_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVC697_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVC697_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVC697_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVC697_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_DST_WIDTH:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_DST_HEIGHT:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_DST_DEPTH:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_DST_LAYER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_DST_ORIGIN_BYTES_X:
    
        parsed = (data >> 0) & ((1u << 21) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_DST_ORIGIN_SAMPLES_Y:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_LAUNCH_DMA:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.DST_MEMORY_LAYOUT = ", prefix);
        switch (parsed) {
        case NVC697_LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR:
            fprintf(fp, "BLOCKLINEAR\n");
            break;
        case NVC697_LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH:
            fprintf(fp, "PITCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.COMPLETION_TYPE = ", prefix);
        switch (parsed) {
        case NVC697_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_DISABLE:
            fprintf(fp, "FLUSH_DISABLE\n");
            break;
        case NVC697_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_ONLY:
            fprintf(fp, "FLUSH_ONLY\n");
            break;
        case NVC697_LAUNCH_DMA_COMPLETION_TYPE_RELEASE_SEMAPHORE:
            fprintf(fp, "RELEASE_SEMAPHORE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 2) - 1);
        fprintf(fp, "%s.INTERRUPT_TYPE = ", prefix);
        switch (parsed) {
        case NVC697_LAUNCH_DMA_INTERRUPT_TYPE_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVC697_LAUNCH_DMA_INTERRUPT_TYPE_INTERRUPT:
            fprintf(fp, "INTERRUPT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.SEMAPHORE_STRUCT_SIZE = ", prefix);
        switch (parsed) {
        case NVC697_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_FOUR_WORDS:
            fprintf(fp, "FOUR_WORDS\n");
            break;
        case NVC697_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_ONE_WORD:
            fprintf(fp, "ONE_WORD\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.REDUCTION_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_LAUNCH_DMA_REDUCTION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_LAUNCH_DMA_REDUCTION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 13) & ((1u << 3) - 1);
        fprintf(fp, "%s.REDUCTION_OP = ", prefix);
        switch (parsed) {
        case NVC697_LAUNCH_DMA_REDUCTION_OP_RED_ADD:
            fprintf(fp, "RED_ADD\n");
            break;
        case NVC697_LAUNCH_DMA_REDUCTION_OP_RED_MIN:
            fprintf(fp, "RED_MIN\n");
            break;
        case NVC697_LAUNCH_DMA_REDUCTION_OP_RED_MAX:
            fprintf(fp, "RED_MAX\n");
            break;
        case NVC697_LAUNCH_DMA_REDUCTION_OP_RED_INC:
            fprintf(fp, "RED_INC\n");
            break;
        case NVC697_LAUNCH_DMA_REDUCTION_OP_RED_DEC:
            fprintf(fp, "RED_DEC\n");
            break;
        case NVC697_LAUNCH_DMA_REDUCTION_OP_RED_AND:
            fprintf(fp, "RED_AND\n");
            break;
        case NVC697_LAUNCH_DMA_REDUCTION_OP_RED_OR:
            fprintf(fp, "RED_OR\n");
            break;
        case NVC697_LAUNCH_DMA_REDUCTION_OP_RED_XOR:
            fprintf(fp, "RED_XOR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 2) - 1);
        fprintf(fp, "%s.REDUCTION_FORMAT = ", prefix);
        switch (parsed) {
        case NVC697_LAUNCH_DMA_REDUCTION_FORMAT_UNSIGNED_32:
            fprintf(fp, "UNSIGNED_32\n");
            break;
        case NVC697_LAUNCH_DMA_REDUCTION_FORMAT_SIGNED_32:
            fprintf(fp, "SIGNED_32\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 6) & ((1u << 1) - 1);
        fprintf(fp, "%s.SYSMEMBAR_DISABLE = ", prefix);
        switch (parsed) {
        case NVC697_LAUNCH_DMA_SYSMEMBAR_DISABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_LAUNCH_DMA_SYSMEMBAR_DISABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_LOAD_INLINE_DATA:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_I2M_SEMAPHORE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_I2M_SEMAPHORE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_I2M_SEMAPHORE_C:
    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_I2M_SPARE_NOOP00:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_I2M_SPARE_NOOP01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_I2M_SPARE_NOOP02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_I2M_SPARE_NOOP03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_RUN_DS_NOW:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS:
    
        parsed = (data >> 0) & ((1u << 5) - 1);
        fprintf(fp, "%s.ACCUMULATED_PRIM_AREA_THRESHOLD = ", prefix);
        switch (parsed) {
        case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD_INSTANTANEOUS:
            fprintf(fp, "INSTANTANEOUS\n");
            break;
        case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__16:
            fprintf(fp, "_16\n");
            break;
        case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__32:
            fprintf(fp, "_32\n");
            break;
        case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__64:
            fprintf(fp, "_64\n");
            break;
        case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__128:
            fprintf(fp, "_128\n");
            break;
        case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__256:
            fprintf(fp, "_256\n");
            break;
        case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__512:
            fprintf(fp, "_512\n");
            break;
        case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__1024:
            fprintf(fp, "_1024\n");
            break;
        case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__2048:
            fprintf(fp, "_2048\n");
            break;
        case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__4096:
            fprintf(fp, "_4096\n");
            break;
        case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__8192:
            fprintf(fp, "_8192\n");
            break;
        case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__16384:
            fprintf(fp, "_16384\n");
            break;
        case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__32768:
            fprintf(fp, "_32768\n");
            break;
        case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__65536:
            fprintf(fp, "_65536\n");
            break;
        case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__131072:
            fprintf(fp, "_131072\n");
            break;
        case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__262144:
            fprintf(fp, "_262144\n");
            break;
        case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__524288:
            fprintf(fp, "_524288\n");
            break;
        case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__1048576:
            fprintf(fp, "_1048576\n");
            break;
        case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__2097152:
            fprintf(fp, "_2097152\n");
            break;
        case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__4194304:
            fprintf(fp, "_4194304\n");
            break;
        case NVC697_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD_LATEZ_ALWAYS:
            fprintf(fp, "LATEZ_ALWAYS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_GS_MODE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.TYPE = ", prefix);
        switch (parsed) {
        case NVC697_SET_GS_MODE_TYPE_ANY:
            fprintf(fp, "ANY\n");
            break;
        case NVC697_SET_GS_MODE_TYPE_FAST_GS:
            fprintf(fp, "FAST_GS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ALIASED_LINE_WIDTH_ENABLE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_ALIASED_LINE_WIDTH_ENABLE_V_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ALIASED_LINE_WIDTH_ENABLE_V_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_API_MANDATED_EARLY_Z:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_API_MANDATED_EARLY_Z_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_API_MANDATED_EARLY_Z_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_GS_DM_FIFO:
    
        parsed = (data >> 0) & ((1u << 13) - 1);
        fprintf(fp, "%s.SIZE_RASTER_ON = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 13) - 1);
        fprintf(fp, "%s.SIZE_RASTER_OFF = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 31) & ((1u << 1) - 1);
        fprintf(fp, "%s.SPILL_ENABLED = ", prefix);
        switch (parsed) {
        case NVC697_SET_GS_DM_FIFO_SPILL_ENABLED_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_GS_DM_FIFO_SPILL_ENABLED_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS:
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.POLICY = ", prefix);
        switch (parsed) {
        case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS_POLICY_EVICT_FIRST:
            fprintf(fp, "EVICT_FIRST\n");
            break;
        case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS_POLICY_EVICT_NORMAL:
            fprintf(fp, "EVICT_NORMAL\n");
            break;
        case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS_POLICY_EVICT_LAST:
            fprintf(fp, "EVICT_LAST\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_INVALIDATE_SHADER_CACHES:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.INSTRUCTION = ", prefix);
        switch (parsed) {
        case NVC697_INVALIDATE_SHADER_CACHES_INSTRUCTION_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_INVALIDATE_SHADER_CACHES_INSTRUCTION_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.DATA = ", prefix);
        switch (parsed) {
        case NVC697_INVALIDATE_SHADER_CACHES_DATA_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_INVALIDATE_SHADER_CACHES_DATA_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONSTANT = ", prefix);
        switch (parsed) {
        case NVC697_INVALIDATE_SHADER_CACHES_CONSTANT_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_INVALIDATE_SHADER_CACHES_CONSTANT_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.LOCKS = ", prefix);
        switch (parsed) {
        case NVC697_INVALIDATE_SHADER_CACHES_LOCKS_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_INVALIDATE_SHADER_CACHES_LOCKS_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLUSH_DATA = ", prefix);
        switch (parsed) {
        case NVC697_INVALIDATE_SHADER_CACHES_FLUSH_DATA_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_INVALIDATE_SHADER_CACHES_FLUSH_DATA_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_INSTANCE_COUNT:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_POSITION_W_SCALED_OFFSET_ENABLE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_POSITION_W_SCALED_OFFSET_ENABLE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_POSITION_W_SCALED_OFFSET_ENABLE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_MULTI_VIEW:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.VIEW_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 4) & ((1u << 11) - 1);
        fprintf(fp, "%s.RENDER_TARGET_INDEX_OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.INDEPENDENT_VIEWPORT_MASK_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_MULTI_VIEW_INDEPENDENT_VIEWPORT_MASK_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_MULTI_VIEW_INDEPENDENT_VIEWPORT_MASK_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 15) & ((1u << 1) - 1);
        fprintf(fp, "%s.SECOND_X_ONLY = ", prefix);
        switch (parsed) {
        case NVC697_SET_MULTI_VIEW_SECOND_X_ONLY_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_MULTI_VIEW_SECOND_X_ONLY_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_GO_IDLE_TIMEOUT:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_CONSERVATIVE_RASTER_CONTROL:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.EXTRA_PRIM_BLOAT = ", prefix);
        switch (parsed) {
        case NVC697_SET_CONSERVATIVE_RASTER_CONTROL_EXTRA_PRIM_BLOAT_BLOAT_0:
            fprintf(fp, "BLOAT_0\n");
            break;
        case NVC697_SET_CONSERVATIVE_RASTER_CONTROL_EXTRA_PRIM_BLOAT_BLOAT_25:
            fprintf(fp, "BLOAT_25\n");
            break;
        case NVC697_SET_CONSERVATIVE_RASTER_CONTROL_EXTRA_PRIM_BLOAT_BLOAT_50:
            fprintf(fp, "BLOAT_50\n");
            break;
        case NVC697_SET_CONSERVATIVE_RASTER_CONTROL_EXTRA_PRIM_BLOAT_BLOAT_75:
            fprintf(fp, "BLOAT_75\n");
            break;
        case NVC697_SET_CONSERVATIVE_RASTER_CONTROL_EXTRA_PRIM_BLOAT_BLOAT_PRI:
            fprintf(fp, "BLOAT_PRI\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.COPY_INNER_TO_OUTER = ", prefix);
        switch (parsed) {
        case NVC697_SET_CONSERVATIVE_RASTER_CONTROL_COPY_INNER_TO_OUTER_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_CONSERVATIVE_RASTER_CONTROL_COPY_INNER_TO_OUTER_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 3) - 1);
        fprintf(fp, "%s.TRIANGLE_SNAP_MODE = ", prefix);
        switch (parsed) {
        case NVC697_SET_CONSERVATIVE_RASTER_CONTROL_TRIANGLE_SNAP_MODE_MODE_POST_SNAP:
            fprintf(fp, "MODE_POST_SNAP\n");
            break;
        case NVC697_SET_CONSERVATIVE_RASTER_CONTROL_TRIANGLE_SNAP_MODE_MODE_PRE_SNAP:
            fprintf(fp, "MODE_PRE_SNAP\n");
            break;
        case NVC697_SET_CONSERVATIVE_RASTER_CONTROL_TRIANGLE_SNAP_MODE_MODE_PRI:
            fprintf(fp, "MODE_PRI\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 3) - 1);
        fprintf(fp, "%s.LINE_AND_POINT_SNAP_MODE = ", prefix);
        switch (parsed) {
        case NVC697_SET_CONSERVATIVE_RASTER_CONTROL_LINE_AND_POINT_SNAP_MODE_MODE_POST_SNAP:
            fprintf(fp, "MODE_POST_SNAP\n");
            break;
        case NVC697_SET_CONSERVATIVE_RASTER_CONTROL_LINE_AND_POINT_SNAP_MODE_MODE_PRE_SNAP:
            fprintf(fp, "MODE_PRE_SNAP\n");
            break;
        case NVC697_SET_CONSERVATIVE_RASTER_CONTROL_LINE_AND_POINT_SNAP_MODE_MODE_PRI:
            fprintf(fp, "MODE_PRI\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 4) - 1);
        fprintf(fp, "%s.UNCERTAINTY_REGION_SIZE = ", prefix);
        switch (parsed) {
        case NVC697_SET_CONSERVATIVE_RASTER_CONTROL_UNCERTAINTY_REGION_SIZE_SIZE_64:
            fprintf(fp, "SIZE_64\n");
            break;
        case NVC697_SET_CONSERVATIVE_RASTER_CONTROL_UNCERTAINTY_REGION_SIZE_SIZE_128:
            fprintf(fp, "SIZE_128\n");
            break;
        case NVC697_SET_CONSERVATIVE_RASTER_CONTROL_UNCERTAINTY_REGION_SIZE_SIZE_256:
            fprintf(fp, "SIZE_256\n");
            break;
        case NVC697_SET_CONSERVATIVE_RASTER_CONTROL_UNCERTAINTY_REGION_SIZE_SIZE_512:
            fprintf(fp, "SIZE_512\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_MME_VERSION:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.MAJOR = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_INDEX_BUFFER_SIZE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_INDEX_BUFFER_SIZE_B:
    
        parsed = data;
        fprintf(fp, "%s.LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ROOT_TABLE_VISIBILITY(0):
    case NVC697_SET_ROOT_TABLE_VISIBILITY(1):
    case NVC697_SET_ROOT_TABLE_VISIBILITY(2):
    case NVC697_SET_ROOT_TABLE_VISIBILITY(3):
    case NVC697_SET_ROOT_TABLE_VISIBILITY(4):
    case NVC697_SET_ROOT_TABLE_VISIBILITY(5):
    case NVC697_SET_ROOT_TABLE_VISIBILITY(6):
    case NVC697_SET_ROOT_TABLE_VISIBILITY(7):
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.BINDING_GROUP0_ENABLE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.BINDING_GROUP1_ENABLE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 2) - 1);
        fprintf(fp, "%s.BINDING_GROUP2_ENABLE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 12) & ((1u << 2) - 1);
        fprintf(fp, "%s.BINDING_GROUP3_ENABLE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 2) - 1);
        fprintf(fp, "%s.BINDING_GROUP4_ENABLE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_DRAW_CONTROL_A:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.TOPOLOGY = ", prefix);
        switch (parsed) {
        case NVC697_SET_DRAW_CONTROL_A_TOPOLOGY_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_TOPOLOGY_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_TOPOLOGY_LINE_LOOP:
            fprintf(fp, "LINE_LOOP\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_TOPOLOGY_LINE_STRIP:
            fprintf(fp, "LINE_STRIP\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_TOPOLOGY_TRIANGLES:
            fprintf(fp, "TRIANGLES\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_TOPOLOGY_TRIANGLE_STRIP:
            fprintf(fp, "TRIANGLE_STRIP\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_TOPOLOGY_TRIANGLE_FAN:
            fprintf(fp, "TRIANGLE_FAN\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_TOPOLOGY_QUADS:
            fprintf(fp, "QUADS\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_TOPOLOGY_QUAD_STRIP:
            fprintf(fp, "QUAD_STRIP\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_TOPOLOGY_POLYGON:
            fprintf(fp, "POLYGON\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_TOPOLOGY_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_TOPOLOGY_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_TOPOLOGY_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_TOPOLOGY_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_TOPOLOGY_PATCH:
            fprintf(fp, "PATCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.PRIMITIVE_ID = ", prefix);
        switch (parsed) {
        case NVC697_SET_DRAW_CONTROL_A_PRIMITIVE_ID_FIRST:
            fprintf(fp, "FIRST\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_PRIMITIVE_ID_UNCHANGED:
            fprintf(fp, "UNCHANGED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 2) - 1);
        fprintf(fp, "%s.INSTANCE_ID = ", prefix);
        switch (parsed) {
        case NVC697_SET_DRAW_CONTROL_A_INSTANCE_ID_FIRST:
            fprintf(fp, "FIRST\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_INSTANCE_ID_SUBSEQUENT:
            fprintf(fp, "SUBSEQUENT\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_INSTANCE_ID_UNCHANGED:
            fprintf(fp, "UNCHANGED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 2) - 1);
        fprintf(fp, "%s.SPLIT_MODE = ", prefix);
        switch (parsed) {
        case NVC697_SET_DRAW_CONTROL_A_SPLIT_MODE_NORMAL_BEGIN_NORMAL_END:
            fprintf(fp, "NORMAL_BEGIN_NORMAL_END\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_SPLIT_MODE_NORMAL_BEGIN_OPEN_END:
            fprintf(fp, "NORMAL_BEGIN_OPEN_END\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_SPLIT_MODE_OPEN_BEGIN_OPEN_END:
            fprintf(fp, "OPEN_BEGIN_OPEN_END\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_SPLIT_MODE_OPEN_BEGIN_NORMAL_END:
            fprintf(fp, "OPEN_BEGIN_NORMAL_END\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 1) - 1);
        fprintf(fp, "%s.INSTANCE_ITERATE_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_DRAW_CONTROL_A_INSTANCE_ITERATE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_INSTANCE_ITERATE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 10) & ((1u << 1) - 1);
        fprintf(fp, "%s.IGNORE_GLOBAL_BASE_VERTEX_INDEX = ", prefix);
        switch (parsed) {
        case NVC697_SET_DRAW_CONTROL_A_IGNORE_GLOBAL_BASE_VERTEX_INDEX_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_IGNORE_GLOBAL_BASE_VERTEX_INDEX_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 11) & ((1u << 1) - 1);
        fprintf(fp, "%s.IGNORE_GLOBAL_BASE_INSTANCE_INDEX = ", prefix);
        switch (parsed) {
        case NVC697_SET_DRAW_CONTROL_A_IGNORE_GLOBAL_BASE_INSTANCE_INDEX_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_DRAW_CONTROL_A_IGNORE_GLOBAL_BASE_INSTANCE_INDEX_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_DRAW_CONTROL_B:
    
        parsed = data;
        fprintf(fp, "%s.INSTANCE_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_DRAW_INDEX_BUFFER_BEGIN_END_A:
    
        parsed = data;
        fprintf(fp, "%s.FIRST = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_DRAW_INDEX_BUFFER_BEGIN_END_B:
    
        parsed = data;
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_A:
    
        parsed = data;
        fprintf(fp, "%s.START = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_B:
    
        parsed = data;
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_INVALIDATE_RASTER_CACHE_NO_WFI:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(0):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(1):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(2):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(3):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(4):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(5):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(6):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(7):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(8):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(9):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(10):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(11):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SAMPLE_ORDER(12):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_COLOR_RENDER_TO_ZETA_SURFACE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_COLOR_RENDER_TO_ZETA_SURFACE_V_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_COLOR_RENDER_TO_ZETA_SURFACE_V_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ZCULL_VISIBLE_PRIM_OPTIMIZATION:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZCULL_VISIBLE_PRIM_OPTIMIZATION_V_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ZCULL_VISIBLE_PRIM_OPTIMIZATION_V_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_INCREMENT_SYNC_POINT:
    
        parsed = (data >> 0) & ((1u << 12) - 1);
        fprintf(fp, "%s.INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLEAN_L2 = ", prefix);
        switch (parsed) {
        case NVC697_INCREMENT_SYNC_POINT_CLEAN_L2_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_INCREMENT_SYNC_POINT_CLEAN_L2_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONDITION = ", prefix);
        switch (parsed) {
        case NVC697_INCREMENT_SYNC_POINT_CONDITION_STREAM_OUT_WRITES_DONE:
            fprintf(fp, "STREAM_OUT_WRITES_DONE\n");
            break;
        case NVC697_INCREMENT_SYNC_POINT_CONDITION_ROP_WRITES_DONE:
            fprintf(fp, "ROP_WRITES_DONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SURFACE_CLIP_ID_BLOCK_SIZE:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        switch (parsed) {
        case NVC697_SET_SURFACE_CLIP_ID_BLOCK_SIZE_WIDTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        switch (parsed) {
        case NVC697_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVC697_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVC697_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVC697_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVC697_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVC697_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.DEPTH = ", prefix);
        switch (parsed) {
        case NVC697_SET_SURFACE_CLIP_ID_BLOCK_SIZE_DEPTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ALPHA_CIRCULAR_BUFFER_SIZE:
    
        parsed = (data >> 0) & ((1u << 14) - 1);
        fprintf(fp, "%s.CACHE_LINES_PER_SM = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_DECOMPRESS_SURFACE:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.MRT_SELECT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 4) & ((1u << 16) - 1);
        fprintf(fp, "%s.RT_ARRAY_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZCULL_ROP_BYPASS:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZCULL_ROP_BYPASS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ZCULL_ROP_BYPASS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.NO_STALL = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZCULL_ROP_BYPASS_NO_STALL_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ZCULL_ROP_BYPASS_NO_STALL_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.CULL_EVERYTHING = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZCULL_ROP_BYPASS_CULL_EVERYTHING_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ZCULL_ROP_BYPASS_CULL_EVERYTHING_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 4) - 1);
        fprintf(fp, "%s.THRESHOLD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZCULL_SUBREGION:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZCULL_SUBREGION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ZCULL_SUBREGION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 24) - 1);
        fprintf(fp, "%s.NORMALIZED_ALIQUOTS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_RASTER_BOUNDING_BOX:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVC697_SET_RASTER_BOUNDING_BOX_MODE_BOUNDING_BOX:
            fprintf(fp, "BOUNDING_BOX\n");
            break;
        case NVC697_SET_RASTER_BOUNDING_BOX_MODE_FULL_VIEWPORT:
            fprintf(fp, "FULL_VIEWPORT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 8) - 1);
        fprintf(fp, "%s.PAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_PEER_SEMAPHORE_RELEASE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ITERATED_BLEND_OPTIMIZATION:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.NOOP = ", prefix);
        switch (parsed) {
        case NVC697_SET_ITERATED_BLEND_OPTIMIZATION_NOOP_NEVER:
            fprintf(fp, "NEVER\n");
            break;
        case NVC697_SET_ITERATED_BLEND_OPTIMIZATION_NOOP_SOURCE_RGBA_0000:
            fprintf(fp, "SOURCE_RGBA_0000\n");
            break;
        case NVC697_SET_ITERATED_BLEND_OPTIMIZATION_NOOP_SOURCE_ALPHA_0:
            fprintf(fp, "SOURCE_ALPHA_0\n");
            break;
        case NVC697_SET_ITERATED_BLEND_OPTIMIZATION_NOOP_SOURCE_RGBA_0001:
            fprintf(fp, "SOURCE_RGBA_0001\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ZCULL_SUBREGION_ALLOCATION:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.SUBREGION_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 16) - 1);
        fprintf(fp, "%s.ALIQUOTS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 24) & ((1u << 4) - 1);
        fprintf(fp, "%s.FORMAT = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16X2_4X4:
            fprintf(fp, "Z_16X16X2_4X4\n");
            break;
        case NVC697_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_16X16_4X4:
            fprintf(fp, "ZS_16X16_4X4\n");
            break;
        case NVC697_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16_4X2:
            fprintf(fp, "Z_16X16_4X2\n");
            break;
        case NVC697_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16_2X4:
            fprintf(fp, "Z_16X16_2X4\n");
            break;
        case NVC697_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X8_4X4:
            fprintf(fp, "Z_16X8_4X4\n");
            break;
        case NVC697_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_8X8_4X2:
            fprintf(fp, "Z_8X8_4X2\n");
            break;
        case NVC697_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_8X8_2X4:
            fprintf(fp, "Z_8X8_2X4\n");
            break;
        case NVC697_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16_4X8:
            fprintf(fp, "Z_16X16_4X8\n");
            break;
        case NVC697_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_4X8_2X2:
            fprintf(fp, "Z_4X8_2X2\n");
            break;
        case NVC697_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_16X8_4X2:
            fprintf(fp, "ZS_16X8_4X2\n");
            break;
        case NVC697_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_16X8_2X4:
            fprintf(fp, "ZS_16X8_2X4\n");
            break;
        case NVC697_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_8X8_2X2:
            fprintf(fp, "ZS_8X8_2X2\n");
            break;
        case NVC697_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_4X8_1X1:
            fprintf(fp, "Z_4X8_1X1\n");
            break;
        case NVC697_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_NONE:
            fprintf(fp, "NONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_ASSIGN_ZCULL_SUBREGIONS:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.ALGORITHM = ", prefix);
        switch (parsed) {
        case NVC697_ASSIGN_ZCULL_SUBREGIONS_ALGORITHM_Static:
            fprintf(fp, "Static\n");
            break;
        case NVC697_ASSIGN_ZCULL_SUBREGIONS_ALGORITHM_Adaptive:
            fprintf(fp, "Adaptive\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_PS_OUTPUT_SAMPLE_MASK_USAGE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_PS_OUTPUT_SAMPLE_MASK_USAGE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_PS_OUTPUT_SAMPLE_MASK_USAGE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.QUALIFY_BY_ANTI_ALIAS_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_PS_OUTPUT_SAMPLE_MASK_USAGE_QUALIFY_BY_ANTI_ALIAS_ENABLE_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        case NVC697_SET_PS_OUTPUT_SAMPLE_MASK_USAGE_QUALIFY_BY_ANTI_ALIAS_ENABLE_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_DRAW_ZERO_INDEX:
    
        parsed = data;
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_L1_CONFIGURATION:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.DIRECTLY_ADDRESSABLE_MEMORY = ", prefix);
        switch (parsed) {
        case NVC697_SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_16KB:
            fprintf(fp, "SIZE_16KB\n");
            break;
        case NVC697_SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_48KB:
            fprintf(fp, "SIZE_48KB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_RENDER_ENABLE_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONDITIONAL_LOAD_CONSTANT_BUFFER = ", prefix);
        switch (parsed) {
        case NVC697_SET_RENDER_ENABLE_CONTROL_CONDITIONAL_LOAD_CONSTANT_BUFFER_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_RENDER_ENABLE_CONTROL_CONDITIONAL_LOAD_CONSTANT_BUFFER_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_SPA_VERSION:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.MINOR = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 8) - 1);
        fprintf(fp, "%s.MAJOR = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_TIMESLICE_BATCH_LIMIT:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.BATCH_LIMIT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SNAP_GRID_LINE:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.LOCATIONS_PER_PIXEL = ", prefix);
        switch (parsed) {
        case NVC697_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__2X2:
            fprintf(fp, "_2X2\n");
            break;
        case NVC697_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__4X4:
            fprintf(fp, "_4X4\n");
            break;
        case NVC697_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__8X8:
            fprintf(fp, "_8X8\n");
            break;
        case NVC697_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__16X16:
            fprintf(fp, "_16X16\n");
            break;
        case NVC697_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__32X32:
            fprintf(fp, "_32X32\n");
            break;
        case NVC697_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__64X64:
            fprintf(fp, "_64X64\n");
            break;
        case NVC697_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__128X128:
            fprintf(fp, "_128X128\n");
            break;
        case NVC697_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__256X256:
            fprintf(fp, "_256X256\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.ROUNDING_MODE = ", prefix);
        switch (parsed) {
        case NVC697_SET_SNAP_GRID_LINE_ROUNDING_MODE_RTNE:
            fprintf(fp, "RTNE\n");
            break;
        case NVC697_SET_SNAP_GRID_LINE_ROUNDING_MODE_TESLA:
            fprintf(fp, "TESLA\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_SNAP_GRID_NON_LINE:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.LOCATIONS_PER_PIXEL = ", prefix);
        switch (parsed) {
        case NVC697_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__2X2:
            fprintf(fp, "_2X2\n");
            break;
        case NVC697_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__4X4:
            fprintf(fp, "_4X4\n");
            break;
        case NVC697_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__8X8:
            fprintf(fp, "_8X8\n");
            break;
        case NVC697_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__16X16:
            fprintf(fp, "_16X16\n");
            break;
        case NVC697_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__32X32:
            fprintf(fp, "_32X32\n");
            break;
        case NVC697_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__64X64:
            fprintf(fp, "_64X64\n");
            break;
        case NVC697_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__128X128:
            fprintf(fp, "_128X128\n");
            break;
        case NVC697_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__256X256:
            fprintf(fp, "_256X256\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.ROUNDING_MODE = ", prefix);
        switch (parsed) {
        case NVC697_SET_SNAP_GRID_NON_LINE_ROUNDING_MODE_RTNE:
            fprintf(fp, "RTNE\n");
            break;
        case NVC697_SET_SNAP_GRID_NON_LINE_ROUNDING_MODE_TESLA:
            fprintf(fp, "TESLA\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_TESSELLATION_PARAMETERS:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.DOMAIN_TYPE = ", prefix);
        switch (parsed) {
        case NVC697_SET_TESSELLATION_PARAMETERS_DOMAIN_TYPE_ISOLINE:
            fprintf(fp, "ISOLINE\n");
            break;
        case NVC697_SET_TESSELLATION_PARAMETERS_DOMAIN_TYPE_TRIANGLE:
            fprintf(fp, "TRIANGLE\n");
            break;
        case NVC697_SET_TESSELLATION_PARAMETERS_DOMAIN_TYPE_QUAD:
            fprintf(fp, "QUAD\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.SPACING = ", prefix);
        switch (parsed) {
        case NVC697_SET_TESSELLATION_PARAMETERS_SPACING_INTEGER:
            fprintf(fp, "INTEGER\n");
            break;
        case NVC697_SET_TESSELLATION_PARAMETERS_SPACING_FRACTIONAL_ODD:
            fprintf(fp, "FRACTIONAL_ODD\n");
            break;
        case NVC697_SET_TESSELLATION_PARAMETERS_SPACING_FRACTIONAL_EVEN:
            fprintf(fp, "FRACTIONAL_EVEN\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 2) - 1);
        fprintf(fp, "%s.OUTPUT_PRIMITIVES = ", prefix);
        switch (parsed) {
        case NVC697_SET_TESSELLATION_PARAMETERS_OUTPUT_PRIMITIVES_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVC697_SET_TESSELLATION_PARAMETERS_OUTPUT_PRIMITIVES_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVC697_SET_TESSELLATION_PARAMETERS_OUTPUT_PRIMITIVES_TRIANGLES_CW:
            fprintf(fp, "TRIANGLES_CW\n");
            break;
        case NVC697_SET_TESSELLATION_PARAMETERS_OUTPUT_PRIMITIVES_TRIANGLES_CCW:
            fprintf(fp, "TRIANGLES_CCW\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_TESSELLATION_LOD_U0_OR_DENSITY:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_TESSELLATION_LOD_V0_OR_DETAIL:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_TESSELLATION_LOD_U1_OR_W0:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_TESSELLATION_LOD_V1:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_TG_LOD_INTERIOR_U:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_TG_LOD_INTERIOR_V:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_RESERVED_TG07:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_RESERVED_TG08:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_RESERVED_TG09:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_RESERVED_TG10:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_RESERVED_TG11:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_RESERVED_TG12:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_RESERVED_TG13:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_RESERVED_TG14:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_RESERVED_TG15:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SUBTILING_PERF_KNOB_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.FRACTION_OF_SPM_REGISTER_FILE_PER_SUBTILE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 8) - 1);
        fprintf(fp, "%s.FRACTION_OF_SPM_PIXEL_OUTPUT_BUFFER_PER_SUBTILE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 8) - 1);
        fprintf(fp, "%s.FRACTION_OF_SPM_TRIANGLE_RAM_PER_SUBTILE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 24) & ((1u << 8) - 1);
        fprintf(fp, "%s.FRACTION_OF_MAX_QUADS_PER_SUBTILE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SUBTILING_PERF_KNOB_B:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.FRACTION_OF_MAX_PRIMITIVES_PER_SUBTILE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SUBTILING_PERF_KNOB_C:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.RESERVED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZCULL_SUBREGION_TO_REPORT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZCULL_SUBREGION_TO_REPORT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ZCULL_SUBREGION_TO_REPORT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 8) - 1);
        fprintf(fp, "%s.SUBREGION_ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZCULL_SUBREGION_REPORT_TYPE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZCULL_SUBREGION_REPORT_TYPE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ZCULL_SUBREGION_REPORT_TYPE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 3) - 1);
        fprintf(fp, "%s.TYPE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_DEPTH_TEST:
            fprintf(fp, "DEPTH_TEST\n");
            break;
        case NVC697_SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_DEPTH_TEST_NO_ACCEPT:
            fprintf(fp, "DEPTH_TEST_NO_ACCEPT\n");
            break;
        case NVC697_SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_DEPTH_TEST_LATE_Z:
            fprintf(fp, "DEPTH_TEST_LATE_Z\n");
            break;
        case NVC697_SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_STENCIL_TEST:
            fprintf(fp, "STENCIL_TEST\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BALANCED_PRIMITIVE_WORKLOAD:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.IN_UNPARTITIONED_MODE = ", prefix);
        switch (parsed) {
        case NVC697_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_UNPARTITIONED_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_UNPARTITIONED_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.IN_TIMESLICED_MODE = ", prefix);
        switch (parsed) {
        case NVC697_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_TIMESLICED_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_TIMESLICED_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.BY_PES_IN_UNPARTITIONED_MODE = ", prefix);
        switch (parsed) {
        case NVC697_SET_BALANCED_PRIMITIVE_WORKLOAD_BY_PES_IN_UNPARTITIONED_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_BALANCED_PRIMITIVE_WORKLOAD_BY_PES_IN_UNPARTITIONED_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 1) - 1);
        fprintf(fp, "%s.BY_PES_IN_TIMESLICED_MODE = ", prefix);
        switch (parsed) {
        case NVC697_SET_BALANCED_PRIMITIVE_WORKLOAD_BY_PES_IN_TIMESLICED_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_BALANCED_PRIMITIVE_WORKLOAD_BY_PES_IN_TIMESLICED_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_MAX_PATCHES_PER_BATCH:
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_RASTER_ENABLE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_RASTER_ENABLE_V_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_RASTER_ENABLE_V_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_STREAM_OUT_BUFFER_ENABLE(0):
    case NVC697_SET_STREAM_OUT_BUFFER_ENABLE(1):
    case NVC697_SET_STREAM_OUT_BUFFER_ENABLE(2):
    case NVC697_SET_STREAM_OUT_BUFFER_ENABLE(3):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_STREAM_OUT_BUFFER_ENABLE_V_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_STREAM_OUT_BUFFER_ENABLE_V_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_A(0):
    case NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_A(1):
    case NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_A(2):
    case NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_A(3):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_B(0):
    case NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_B(1):
    case NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_B(2):
    case NVC697_SET_STREAM_OUT_BUFFER_ADDRESS_B(3):
    
        parsed = data;
        fprintf(fp, "%s.LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_STREAM_OUT_BUFFER_SIZE(0):
    case NVC697_SET_STREAM_OUT_BUFFER_SIZE(1):
    case NVC697_SET_STREAM_OUT_BUFFER_SIZE(2):
    case NVC697_SET_STREAM_OUT_BUFFER_SIZE(3):
    
        parsed = data;
        fprintf(fp, "%s.BYTES = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(0):
    case NVC697_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(1):
    case NVC697_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(2):
    case NVC697_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(3):
    
        parsed = data;
        fprintf(fp, "%s.START_OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                    case NVC697_SET_ROOT_TABLE_SELECTOR:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.ROOT_TABLE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_LOAD_ROOT_TABLE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_MME_MEM_ADDRESS_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_MME_MEM_ADDRESS_B:
    
        parsed = data;
        fprintf(fp, "%s.LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_MME_DATA_RAM_ADDRESS:
    
        parsed = data;
        fprintf(fp, "%s.WORD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_MME_DMA_READ:
    
        parsed = data;
        fprintf(fp, "%s.LENGTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_MME_DMA_READ_FIFOED:
    
        parsed = data;
        fprintf(fp, "%s.LENGTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_MME_DMA_WRITE:
    
        parsed = data;
        fprintf(fp, "%s.LENGTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_MME_DMA_REDUCTION:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.REDUCTION_OP = ", prefix);
        switch (parsed) {
        case NVC697_MME_DMA_REDUCTION_REDUCTION_OP_RED_ADD:
            fprintf(fp, "RED_ADD\n");
            break;
        case NVC697_MME_DMA_REDUCTION_REDUCTION_OP_RED_MIN:
            fprintf(fp, "RED_MIN\n");
            break;
        case NVC697_MME_DMA_REDUCTION_REDUCTION_OP_RED_MAX:
            fprintf(fp, "RED_MAX\n");
            break;
        case NVC697_MME_DMA_REDUCTION_REDUCTION_OP_RED_INC:
            fprintf(fp, "RED_INC\n");
            break;
        case NVC697_MME_DMA_REDUCTION_REDUCTION_OP_RED_DEC:
            fprintf(fp, "RED_DEC\n");
            break;
        case NVC697_MME_DMA_REDUCTION_REDUCTION_OP_RED_AND:
            fprintf(fp, "RED_AND\n");
            break;
        case NVC697_MME_DMA_REDUCTION_REDUCTION_OP_RED_OR:
            fprintf(fp, "RED_OR\n");
            break;
        case NVC697_MME_DMA_REDUCTION_REDUCTION_OP_RED_XOR:
            fprintf(fp, "RED_XOR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.REDUCTION_FORMAT = ", prefix);
        switch (parsed) {
        case NVC697_MME_DMA_REDUCTION_REDUCTION_FORMAT_UNSIGNED_32:
            fprintf(fp, "UNSIGNED_32\n");
            break;
        case NVC697_MME_DMA_REDUCTION_REDUCTION_FORMAT_SIGNED_32:
            fprintf(fp, "SIGNED_32\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.REDUCTION_SIZE = ", prefix);
        switch (parsed) {
        case NVC697_MME_DMA_REDUCTION_REDUCTION_SIZE_FOUR_BYTES:
            fprintf(fp, "FOUR_BYTES\n");
            break;
        case NVC697_MME_DMA_REDUCTION_REDUCTION_SIZE_EIGHT_BYTES:
            fprintf(fp, "EIGHT_BYTES\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_MME_DMA_SYSMEMBAR:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_MME_DMA_SYNC:
    
        parsed = data;
        fprintf(fp, "%s.VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_MME_DATA_FIFO_CONFIG:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.FIFO_SIZE = ", prefix);
        switch (parsed) {
        case NVC697_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_0KB:
            fprintf(fp, "SIZE_0KB\n");
            break;
        case NVC697_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_4KB:
            fprintf(fp, "SIZE_4KB\n");
            break;
        case NVC697_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_8KB:
            fprintf(fp, "SIZE_8KB\n");
            break;
        case NVC697_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_12KB:
            fprintf(fp, "SIZE_12KB\n");
            break;
        case NVC697_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_16KB:
            fprintf(fp, "SIZE_16KB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_VERTEX_STREAM_SIZE_A(0):
    case NVC697_SET_VERTEX_STREAM_SIZE_A(1):
    case NVC697_SET_VERTEX_STREAM_SIZE_A(2):
    case NVC697_SET_VERTEX_STREAM_SIZE_A(3):
    case NVC697_SET_VERTEX_STREAM_SIZE_A(4):
    case NVC697_SET_VERTEX_STREAM_SIZE_A(5):
    case NVC697_SET_VERTEX_STREAM_SIZE_A(6):
    case NVC697_SET_VERTEX_STREAM_SIZE_A(7):
    case NVC697_SET_VERTEX_STREAM_SIZE_A(8):
    case NVC697_SET_VERTEX_STREAM_SIZE_A(9):
    case NVC697_SET_VERTEX_STREAM_SIZE_A(10):
    case NVC697_SET_VERTEX_STREAM_SIZE_A(11):
    case NVC697_SET_VERTEX_STREAM_SIZE_A(12):
    case NVC697_SET_VERTEX_STREAM_SIZE_A(13):
    case NVC697_SET_VERTEX_STREAM_SIZE_A(14):
    case NVC697_SET_VERTEX_STREAM_SIZE_A(15):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_VERTEX_STREAM_SIZE_B(0):
    case NVC697_SET_VERTEX_STREAM_SIZE_B(1):
    case NVC697_SET_VERTEX_STREAM_SIZE_B(2):
    case NVC697_SET_VERTEX_STREAM_SIZE_B(3):
    case NVC697_SET_VERTEX_STREAM_SIZE_B(4):
    case NVC697_SET_VERTEX_STREAM_SIZE_B(5):
    case NVC697_SET_VERTEX_STREAM_SIZE_B(6):
    case NVC697_SET_VERTEX_STREAM_SIZE_B(7):
    case NVC697_SET_VERTEX_STREAM_SIZE_B(8):
    case NVC697_SET_VERTEX_STREAM_SIZE_B(9):
    case NVC697_SET_VERTEX_STREAM_SIZE_B(10):
    case NVC697_SET_VERTEX_STREAM_SIZE_B(11):
    case NVC697_SET_VERTEX_STREAM_SIZE_B(12):
    case NVC697_SET_VERTEX_STREAM_SIZE_B(13):
    case NVC697_SET_VERTEX_STREAM_SIZE_B(14):
    case NVC697_SET_VERTEX_STREAM_SIZE_B(15):
    
        parsed = data;
        fprintf(fp, "%s.LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_STREAM_OUT_CONTROL_STREAM(0):
    case NVC697_SET_STREAM_OUT_CONTROL_STREAM(1):
    case NVC697_SET_STREAM_OUT_CONTROL_STREAM(2):
    case NVC697_SET_STREAM_OUT_CONTROL_STREAM(3):
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.SELECT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(0):
    case NVC697_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(1):
    case NVC697_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(2):
    case NVC697_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(3):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.MAX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_STREAM_OUT_CONTROL_STRIDE(0):
    case NVC697_SET_STREAM_OUT_CONTROL_STRIDE(1):
    case NVC697_SET_STREAM_OUT_CONTROL_STRIDE(2):
    case NVC697_SET_STREAM_OUT_CONTROL_STRIDE(3):
    
        parsed = data;
        fprintf(fp, "%s.BYTES = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_RASTER_INPUT:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.STREAM_SELECT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_STREAM_OUTPUT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_STREAM_OUTPUT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_STREAM_OUTPUT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_HYBRID_ANTI_ALIAS_CONTROL:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.PASSES = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.CENTROID = ", prefix);
        switch (parsed) {
        case NVC697_SET_HYBRID_ANTI_ALIAS_CONTROL_CENTROID_PER_FRAGMENT:
            fprintf(fp, "PER_FRAGMENT\n");
            break;
        case NVC697_SET_HYBRID_ANTI_ALIAS_CONTROL_CENTROID_PER_PASS:
            fprintf(fp, "PER_PASS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 1) - 1);
        fprintf(fp, "%s.PASSES_EXTENDED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADER_LOCAL_MEMORY_WINDOW:
    
        parsed = data;
        fprintf(fp, "%s.BASE_ADDRESS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADER_LOCAL_MEMORY_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADER_LOCAL_MEMORY_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADER_LOCAL_MEMORY_C:
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.SIZE_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADER_LOCAL_MEMORY_D:
    
        parsed = data;
        fprintf(fp, "%s.SIZE_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADER_LOCAL_MEMORY_E:
    
        parsed = (data >> 0) & ((1u << 26) - 1);
        fprintf(fp, "%s.DEFAULT_SIZE_PER_WARP = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_COLOR_ZERO_BANDWIDTH_CLEAR:
    
        parsed = (data >> 0) & ((1u << 15) - 1);
        fprintf(fp, "%s.SLOT_DISABLE_MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_Z_ZERO_BANDWIDTH_CLEAR:
    
        parsed = (data >> 0) & ((1u << 15) - 1);
        fprintf(fp, "%s.SLOT_DISABLE_MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_STENCIL_ZERO_BANDWIDTH_CLEAR:
    
        parsed = (data >> 0) & ((1u << 15) - 1);
        fprintf(fp, "%s.SLOT_DISABLE_MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZCULL_REGION_SIZE_A:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZCULL_REGION_SIZE_B:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZCULL_REGION_SIZE_C:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.DEPTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZCULL_REGION_PIXEL_OFFSET_C:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.DEPTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_CULL_BEFORE_FETCH:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.FETCH_STREAMS_ONCE = ", prefix);
        switch (parsed) {
        case NVC697_SET_CULL_BEFORE_FETCH_FETCH_STREAMS_ONCE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_CULL_BEFORE_FETCH_FETCH_STREAMS_ONCE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ZCULL_REGION_LOCATION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.START_ALIQUOT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.ALIQUOT_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZCULL_REGION_ALIQUOTS:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.PER_LAYER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZCULL_STORAGE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZCULL_STORAGE_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZCULL_STORAGE_C:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.LIMIT_ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZCULL_STORAGE_D:
    
        parsed = data;
        fprintf(fp, "%s.LIMIT_ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZT_READ_ONLY:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE_Z = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZT_READ_ONLY_ENABLE_Z_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ZT_READ_ONLY_ENABLE_Z_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE_STENCIL = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZT_READ_ONLY_ENABLE_STENCIL_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ZT_READ_ONLY_ENABLE_STENCIL_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_COLOR_TARGET_A(0):
    case NVC697_SET_COLOR_TARGET_A(1):
    case NVC697_SET_COLOR_TARGET_A(2):
    case NVC697_SET_COLOR_TARGET_A(3):
    case NVC697_SET_COLOR_TARGET_A(4):
    case NVC697_SET_COLOR_TARGET_A(5):
    case NVC697_SET_COLOR_TARGET_A(6):
    case NVC697_SET_COLOR_TARGET_A(7):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_COLOR_TARGET_B(0):
    case NVC697_SET_COLOR_TARGET_B(1):
    case NVC697_SET_COLOR_TARGET_B(2):
    case NVC697_SET_COLOR_TARGET_B(3):
    case NVC697_SET_COLOR_TARGET_B(4):
    case NVC697_SET_COLOR_TARGET_B(5):
    case NVC697_SET_COLOR_TARGET_B(6):
    case NVC697_SET_COLOR_TARGET_B(7):
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_COLOR_TARGET_WIDTH(0):
    case NVC697_SET_COLOR_TARGET_WIDTH(1):
    case NVC697_SET_COLOR_TARGET_WIDTH(2):
    case NVC697_SET_COLOR_TARGET_WIDTH(3):
    case NVC697_SET_COLOR_TARGET_WIDTH(4):
    case NVC697_SET_COLOR_TARGET_WIDTH(5):
    case NVC697_SET_COLOR_TARGET_WIDTH(6):
    case NVC697_SET_COLOR_TARGET_WIDTH(7):
    
        parsed = (data >> 0) & ((1u << 28) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_COLOR_TARGET_HEIGHT(0):
    case NVC697_SET_COLOR_TARGET_HEIGHT(1):
    case NVC697_SET_COLOR_TARGET_HEIGHT(2):
    case NVC697_SET_COLOR_TARGET_HEIGHT(3):
    case NVC697_SET_COLOR_TARGET_HEIGHT(4):
    case NVC697_SET_COLOR_TARGET_HEIGHT(5):
    case NVC697_SET_COLOR_TARGET_HEIGHT(6):
    case NVC697_SET_COLOR_TARGET_HEIGHT(7):
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_COLOR_TARGET_FORMAT(0):
    case NVC697_SET_COLOR_TARGET_FORMAT(1):
    case NVC697_SET_COLOR_TARGET_FORMAT(2):
    case NVC697_SET_COLOR_TARGET_FORMAT(3):
    case NVC697_SET_COLOR_TARGET_FORMAT(4):
    case NVC697_SET_COLOR_TARGET_FORMAT(5):
    case NVC697_SET_COLOR_TARGET_FORMAT(6):
    case NVC697_SET_COLOR_TARGET_FORMAT(7):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_COLOR_TARGET_FORMAT_V_DISABLED:
            fprintf(fp, "DISABLED\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RF32_GF32_BF32_AF32:
            fprintf(fp, "RF32_GF32_BF32_AF32\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RS32_GS32_BS32_AS32:
            fprintf(fp, "RS32_GS32_BS32_AS32\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RU32_GU32_BU32_AU32:
            fprintf(fp, "RU32_GU32_BU32_AU32\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RF32_GF32_BF32_X32:
            fprintf(fp, "RF32_GF32_BF32_X32\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RS32_GS32_BS32_X32:
            fprintf(fp, "RS32_GS32_BS32_X32\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RU32_GU32_BU32_X32:
            fprintf(fp, "RU32_GU32_BU32_X32\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_R16_G16_B16_A16:
            fprintf(fp, "R16_G16_B16_A16\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RN16_GN16_BN16_AN16:
            fprintf(fp, "RN16_GN16_BN16_AN16\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RS16_GS16_BS16_AS16:
            fprintf(fp, "RS16_GS16_BS16_AS16\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RU16_GU16_BU16_AU16:
            fprintf(fp, "RU16_GU16_BU16_AU16\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RF16_GF16_BF16_AF16:
            fprintf(fp, "RF16_GF16_BF16_AF16\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RF32_GF32:
            fprintf(fp, "RF32_GF32\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RS32_GS32:
            fprintf(fp, "RS32_GS32\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RU32_GU32:
            fprintf(fp, "RU32_GU32\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RF16_GF16_BF16_X16:
            fprintf(fp, "RF16_GF16_BF16_X16\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_A8R8G8B8:
            fprintf(fp, "A8R8G8B8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_A8RL8GL8BL8:
            fprintf(fp, "A8RL8GL8BL8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_A2B10G10R10:
            fprintf(fp, "A2B10G10R10\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_AU2BU10GU10RU10:
            fprintf(fp, "AU2BU10GU10RU10\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_A8B8G8R8:
            fprintf(fp, "A8B8G8R8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_A8BL8GL8RL8:
            fprintf(fp, "A8BL8GL8RL8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_AN8BN8GN8RN8:
            fprintf(fp, "AN8BN8GN8RN8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_AS8BS8GS8RS8:
            fprintf(fp, "AS8BS8GS8RS8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_AU8BU8GU8RU8:
            fprintf(fp, "AU8BU8GU8RU8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_R16_G16:
            fprintf(fp, "R16_G16\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RN16_GN16:
            fprintf(fp, "RN16_GN16\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RS16_GS16:
            fprintf(fp, "RS16_GS16\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RU16_GU16:
            fprintf(fp, "RU16_GU16\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RF16_GF16:
            fprintf(fp, "RF16_GF16\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_A2R10G10B10:
            fprintf(fp, "A2R10G10B10\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_BF10GF11RF11:
            fprintf(fp, "BF10GF11RF11\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RS32:
            fprintf(fp, "RS32\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RU32:
            fprintf(fp, "RU32\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RF32:
            fprintf(fp, "RF32\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_X8R8G8B8:
            fprintf(fp, "X8R8G8B8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_X8RL8GL8BL8:
            fprintf(fp, "X8RL8GL8BL8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_R5G6B5:
            fprintf(fp, "R5G6B5\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_A1R5G5B5:
            fprintf(fp, "A1R5G5B5\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_G8R8:
            fprintf(fp, "G8R8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_GN8RN8:
            fprintf(fp, "GN8RN8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_GS8RS8:
            fprintf(fp, "GS8RS8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_GU8RU8:
            fprintf(fp, "GU8RU8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_R16:
            fprintf(fp, "R16\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RN16:
            fprintf(fp, "RN16\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RS16:
            fprintf(fp, "RS16\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RU16:
            fprintf(fp, "RU16\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RF16:
            fprintf(fp, "RF16\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_R8:
            fprintf(fp, "R8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RN8:
            fprintf(fp, "RN8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RS8:
            fprintf(fp, "RS8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RU8:
            fprintf(fp, "RU8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_A8:
            fprintf(fp, "A8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_X1R5G5B5:
            fprintf(fp, "X1R5G5B5\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_X8B8G8R8:
            fprintf(fp, "X8B8G8R8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_X8BL8GL8RL8:
            fprintf(fp, "X8BL8GL8RL8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_Z1R5G5B5:
            fprintf(fp, "Z1R5G5B5\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_O1R5G5B5:
            fprintf(fp, "O1R5G5B5\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_Z8R8G8B8:
            fprintf(fp, "Z8R8G8B8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_O8R8G8B8:
            fprintf(fp, "O8R8G8B8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_R32:
            fprintf(fp, "R32\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_A16:
            fprintf(fp, "A16\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_AF16:
            fprintf(fp, "AF16\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_AF32:
            fprintf(fp, "AF32\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_A8R8:
            fprintf(fp, "A8R8\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_R16_A16:
            fprintf(fp, "R16_A16\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RF16_AF16:
            fprintf(fp, "RF16_AF16\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_RF32_AF32:
            fprintf(fp, "RF32_AF32\n");
            break;
        case NVC697_SET_COLOR_TARGET_FORMAT_V_B8G8R8A8:
            fprintf(fp, "B8G8R8A8\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_COLOR_TARGET_MEMORY(0):
    case NVC697_SET_COLOR_TARGET_MEMORY(1):
    case NVC697_SET_COLOR_TARGET_MEMORY(2):
    case NVC697_SET_COLOR_TARGET_MEMORY(3):
    case NVC697_SET_COLOR_TARGET_MEMORY(4):
    case NVC697_SET_COLOR_TARGET_MEMORY(5):
    case NVC697_SET_COLOR_TARGET_MEMORY(6):
    case NVC697_SET_COLOR_TARGET_MEMORY(7):
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.BLOCK_WIDTH = ", prefix);
        switch (parsed) {
        case NVC697_SET_COLOR_TARGET_MEMORY_BLOCK_WIDTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.BLOCK_HEIGHT = ", prefix);
        switch (parsed) {
        case NVC697_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVC697_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVC697_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVC697_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVC697_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVC697_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.BLOCK_DEPTH = ", prefix);
        switch (parsed) {
        case NVC697_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVC697_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVC697_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVC697_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVC697_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVC697_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.LAYOUT = ", prefix);
        switch (parsed) {
        case NVC697_SET_COLOR_TARGET_MEMORY_LAYOUT_BLOCKLINEAR:
            fprintf(fp, "BLOCKLINEAR\n");
            break;
        case NVC697_SET_COLOR_TARGET_MEMORY_LAYOUT_PITCH:
            fprintf(fp, "PITCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.THIRD_DIMENSION_CONTROL = ", prefix);
        switch (parsed) {
        case NVC697_SET_COLOR_TARGET_MEMORY_THIRD_DIMENSION_CONTROL_THIRD_DIMENSION_DEFINES_ARRAY_SIZE:
            fprintf(fp, "THIRD_DIMENSION_DEFINES_ARRAY_SIZE\n");
            break;
        case NVC697_SET_COLOR_TARGET_MEMORY_THIRD_DIMENSION_CONTROL_THIRD_DIMENSION_DEFINES_DEPTH_SIZE:
            fprintf(fp, "THIRD_DIMENSION_DEFINES_DEPTH_SIZE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(0):
    case NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(1):
    case NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(2):
    case NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(3):
    case NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(4):
    case NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(5):
    case NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(6):
    case NVC697_SET_COLOR_TARGET_THIRD_DIMENSION(7):
    
        parsed = (data >> 0) & ((1u << 28) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_COLOR_TARGET_ARRAY_PITCH(0):
    case NVC697_SET_COLOR_TARGET_ARRAY_PITCH(1):
    case NVC697_SET_COLOR_TARGET_ARRAY_PITCH(2):
    case NVC697_SET_COLOR_TARGET_ARRAY_PITCH(3):
    case NVC697_SET_COLOR_TARGET_ARRAY_PITCH(4):
    case NVC697_SET_COLOR_TARGET_ARRAY_PITCH(5):
    case NVC697_SET_COLOR_TARGET_ARRAY_PITCH(6):
    case NVC697_SET_COLOR_TARGET_ARRAY_PITCH(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_COLOR_TARGET_LAYER(0):
    case NVC697_SET_COLOR_TARGET_LAYER(1):
    case NVC697_SET_COLOR_TARGET_LAYER(2):
    case NVC697_SET_COLOR_TARGET_LAYER(3):
    case NVC697_SET_COLOR_TARGET_LAYER(4):
    case NVC697_SET_COLOR_TARGET_LAYER(5):
    case NVC697_SET_COLOR_TARGET_LAYER(6):
    case NVC697_SET_COLOR_TARGET_LAYER(7):
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_COLOR_TARGET_RESERVED_A(0):
    case NVC697_SET_COLOR_TARGET_RESERVED_A(1):
    case NVC697_SET_COLOR_TARGET_RESERVED_A(2):
    case NVC697_SET_COLOR_TARGET_RESERVED_A(3):
    case NVC697_SET_COLOR_TARGET_RESERVED_A(4):
    case NVC697_SET_COLOR_TARGET_RESERVED_A(5):
    case NVC697_SET_COLOR_TARGET_RESERVED_A(6):
    case NVC697_SET_COLOR_TARGET_RESERVED_A(7):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_VIEWPORT_SCALE_X(0):
    case NVC697_SET_VIEWPORT_SCALE_X(1):
    case NVC697_SET_VIEWPORT_SCALE_X(2):
    case NVC697_SET_VIEWPORT_SCALE_X(3):
    case NVC697_SET_VIEWPORT_SCALE_X(4):
    case NVC697_SET_VIEWPORT_SCALE_X(5):
    case NVC697_SET_VIEWPORT_SCALE_X(6):
    case NVC697_SET_VIEWPORT_SCALE_X(7):
    case NVC697_SET_VIEWPORT_SCALE_X(8):
    case NVC697_SET_VIEWPORT_SCALE_X(9):
    case NVC697_SET_VIEWPORT_SCALE_X(10):
    case NVC697_SET_VIEWPORT_SCALE_X(11):
    case NVC697_SET_VIEWPORT_SCALE_X(12):
    case NVC697_SET_VIEWPORT_SCALE_X(13):
    case NVC697_SET_VIEWPORT_SCALE_X(14):
    case NVC697_SET_VIEWPORT_SCALE_X(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVC697_SET_VIEWPORT_SCALE_Y(0):
    case NVC697_SET_VIEWPORT_SCALE_Y(1):
    case NVC697_SET_VIEWPORT_SCALE_Y(2):
    case NVC697_SET_VIEWPORT_SCALE_Y(3):
    case NVC697_SET_VIEWPORT_SCALE_Y(4):
    case NVC697_SET_VIEWPORT_SCALE_Y(5):
    case NVC697_SET_VIEWPORT_SCALE_Y(6):
    case NVC697_SET_VIEWPORT_SCALE_Y(7):
    case NVC697_SET_VIEWPORT_SCALE_Y(8):
    case NVC697_SET_VIEWPORT_SCALE_Y(9):
    case NVC697_SET_VIEWPORT_SCALE_Y(10):
    case NVC697_SET_VIEWPORT_SCALE_Y(11):
    case NVC697_SET_VIEWPORT_SCALE_Y(12):
    case NVC697_SET_VIEWPORT_SCALE_Y(13):
    case NVC697_SET_VIEWPORT_SCALE_Y(14):
    case NVC697_SET_VIEWPORT_SCALE_Y(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVC697_SET_VIEWPORT_SCALE_Z(0):
    case NVC697_SET_VIEWPORT_SCALE_Z(1):
    case NVC697_SET_VIEWPORT_SCALE_Z(2):
    case NVC697_SET_VIEWPORT_SCALE_Z(3):
    case NVC697_SET_VIEWPORT_SCALE_Z(4):
    case NVC697_SET_VIEWPORT_SCALE_Z(5):
    case NVC697_SET_VIEWPORT_SCALE_Z(6):
    case NVC697_SET_VIEWPORT_SCALE_Z(7):
    case NVC697_SET_VIEWPORT_SCALE_Z(8):
    case NVC697_SET_VIEWPORT_SCALE_Z(9):
    case NVC697_SET_VIEWPORT_SCALE_Z(10):
    case NVC697_SET_VIEWPORT_SCALE_Z(11):
    case NVC697_SET_VIEWPORT_SCALE_Z(12):
    case NVC697_SET_VIEWPORT_SCALE_Z(13):
    case NVC697_SET_VIEWPORT_SCALE_Z(14):
    case NVC697_SET_VIEWPORT_SCALE_Z(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVC697_SET_VIEWPORT_OFFSET_X(0):
    case NVC697_SET_VIEWPORT_OFFSET_X(1):
    case NVC697_SET_VIEWPORT_OFFSET_X(2):
    case NVC697_SET_VIEWPORT_OFFSET_X(3):
    case NVC697_SET_VIEWPORT_OFFSET_X(4):
    case NVC697_SET_VIEWPORT_OFFSET_X(5):
    case NVC697_SET_VIEWPORT_OFFSET_X(6):
    case NVC697_SET_VIEWPORT_OFFSET_X(7):
    case NVC697_SET_VIEWPORT_OFFSET_X(8):
    case NVC697_SET_VIEWPORT_OFFSET_X(9):
    case NVC697_SET_VIEWPORT_OFFSET_X(10):
    case NVC697_SET_VIEWPORT_OFFSET_X(11):
    case NVC697_SET_VIEWPORT_OFFSET_X(12):
    case NVC697_SET_VIEWPORT_OFFSET_X(13):
    case NVC697_SET_VIEWPORT_OFFSET_X(14):
    case NVC697_SET_VIEWPORT_OFFSET_X(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVC697_SET_VIEWPORT_OFFSET_Y(0):
    case NVC697_SET_VIEWPORT_OFFSET_Y(1):
    case NVC697_SET_VIEWPORT_OFFSET_Y(2):
    case NVC697_SET_VIEWPORT_OFFSET_Y(3):
    case NVC697_SET_VIEWPORT_OFFSET_Y(4):
    case NVC697_SET_VIEWPORT_OFFSET_Y(5):
    case NVC697_SET_VIEWPORT_OFFSET_Y(6):
    case NVC697_SET_VIEWPORT_OFFSET_Y(7):
    case NVC697_SET_VIEWPORT_OFFSET_Y(8):
    case NVC697_SET_VIEWPORT_OFFSET_Y(9):
    case NVC697_SET_VIEWPORT_OFFSET_Y(10):
    case NVC697_SET_VIEWPORT_OFFSET_Y(11):
    case NVC697_SET_VIEWPORT_OFFSET_Y(12):
    case NVC697_SET_VIEWPORT_OFFSET_Y(13):
    case NVC697_SET_VIEWPORT_OFFSET_Y(14):
    case NVC697_SET_VIEWPORT_OFFSET_Y(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVC697_SET_VIEWPORT_OFFSET_Z(0):
    case NVC697_SET_VIEWPORT_OFFSET_Z(1):
    case NVC697_SET_VIEWPORT_OFFSET_Z(2):
    case NVC697_SET_VIEWPORT_OFFSET_Z(3):
    case NVC697_SET_VIEWPORT_OFFSET_Z(4):
    case NVC697_SET_VIEWPORT_OFFSET_Z(5):
    case NVC697_SET_VIEWPORT_OFFSET_Z(6):
    case NVC697_SET_VIEWPORT_OFFSET_Z(7):
    case NVC697_SET_VIEWPORT_OFFSET_Z(8):
    case NVC697_SET_VIEWPORT_OFFSET_Z(9):
    case NVC697_SET_VIEWPORT_OFFSET_Z(10):
    case NVC697_SET_VIEWPORT_OFFSET_Z(11):
    case NVC697_SET_VIEWPORT_OFFSET_Z(12):
    case NVC697_SET_VIEWPORT_OFFSET_Z(13):
    case NVC697_SET_VIEWPORT_OFFSET_Z(14):
    case NVC697_SET_VIEWPORT_OFFSET_Z(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(0):
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(1):
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(2):
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(3):
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(4):
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(5):
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(6):
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(7):
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(8):
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(9):
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(10):
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(11):
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(12):
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(13):
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(14):
    case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE(15):
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.X = ", prefix);
        switch (parsed) {
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_X_POS_X:
            fprintf(fp, "POS_X\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_X_NEG_X:
            fprintf(fp, "NEG_X\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_X_POS_Y:
            fprintf(fp, "POS_Y\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_X_NEG_Y:
            fprintf(fp, "NEG_Y\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_X_POS_Z:
            fprintf(fp, "POS_Z\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_X_NEG_Z:
            fprintf(fp, "NEG_Z\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_X_POS_W:
            fprintf(fp, "POS_W\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_X_NEG_W:
            fprintf(fp, "NEG_W\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 3) - 1);
        fprintf(fp, "%s.Y = ", prefix);
        switch (parsed) {
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_Y_POS_X:
            fprintf(fp, "POS_X\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_Y_NEG_X:
            fprintf(fp, "NEG_X\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_Y_POS_Y:
            fprintf(fp, "POS_Y\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_Y_NEG_Y:
            fprintf(fp, "NEG_Y\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_Y_POS_Z:
            fprintf(fp, "POS_Z\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_Y_NEG_Z:
            fprintf(fp, "NEG_Z\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_Y_POS_W:
            fprintf(fp, "POS_W\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_Y_NEG_W:
            fprintf(fp, "NEG_W\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 3) - 1);
        fprintf(fp, "%s.Z = ", prefix);
        switch (parsed) {
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_Z_POS_X:
            fprintf(fp, "POS_X\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_Z_NEG_X:
            fprintf(fp, "NEG_X\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_Z_POS_Y:
            fprintf(fp, "POS_Y\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_Z_NEG_Y:
            fprintf(fp, "NEG_Y\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_Z_POS_Z:
            fprintf(fp, "POS_Z\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_Z_NEG_Z:
            fprintf(fp, "NEG_Z\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_Z_POS_W:
            fprintf(fp, "POS_W\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_Z_NEG_W:
            fprintf(fp, "NEG_W\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 3) - 1);
        fprintf(fp, "%s.W = ", prefix);
        switch (parsed) {
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_W_POS_X:
            fprintf(fp, "POS_X\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_W_NEG_X:
            fprintf(fp, "NEG_X\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_W_POS_Y:
            fprintf(fp, "POS_Y\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_W_NEG_Y:
            fprintf(fp, "NEG_Y\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_W_POS_Z:
            fprintf(fp, "POS_Z\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_W_NEG_Z:
            fprintf(fp, "NEG_Z\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_W_POS_W:
            fprintf(fp, "POS_W\n");
            break;
        case NVC697_SET_VIEWPORT_COORDINATE_SWIZZLE_W_NEG_W:
            fprintf(fp, "NEG_W\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(0):
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(1):
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(2):
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(3):
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(4):
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(5):
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(6):
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(7):
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(8):
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(9):
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(10):
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(11):
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(12):
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(13):
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(14):
    case NVC697_SET_VIEWPORT_INCREASE_SNAP_GRID_PRECISION(15):
    
        parsed = (data >> 0) & ((1u << 5) - 1);
        fprintf(fp, "%s.X_BITS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 5) - 1);
        fprintf(fp, "%s.Y_BITS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(0):
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(1):
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(2):
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(3):
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(4):
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(5):
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(6):
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(7):
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(8):
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(9):
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(10):
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(11):
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(12):
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(13):
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(14):
    case NVC697_SET_VIEWPORT_CLIP_HORIZONTAL(15):
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.X0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(0):
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(1):
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(2):
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(3):
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(4):
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(5):
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(6):
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(7):
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(8):
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(9):
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(10):
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(11):
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(12):
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(13):
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(14):
    case NVC697_SET_VIEWPORT_CLIP_VERTICAL(15):
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.Y0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(0):
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(1):
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(2):
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(3):
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(4):
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(5):
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(6):
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(7):
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(8):
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(9):
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(10):
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(11):
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(12):
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(13):
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(14):
    case NVC697_SET_VIEWPORT_CLIP_MIN_Z(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(0):
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(1):
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(2):
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(3):
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(4):
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(5):
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(6):
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(7):
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(8):
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(9):
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(10):
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(11):
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(12):
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(13):
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(14):
    case NVC697_SET_VIEWPORT_CLIP_MAX_Z(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVC697_SET_WINDOW_CLIP_HORIZONTAL(0):
    case NVC697_SET_WINDOW_CLIP_HORIZONTAL(1):
    case NVC697_SET_WINDOW_CLIP_HORIZONTAL(2):
    case NVC697_SET_WINDOW_CLIP_HORIZONTAL(3):
    case NVC697_SET_WINDOW_CLIP_HORIZONTAL(4):
    case NVC697_SET_WINDOW_CLIP_HORIZONTAL(5):
    case NVC697_SET_WINDOW_CLIP_HORIZONTAL(6):
    case NVC697_SET_WINDOW_CLIP_HORIZONTAL(7):
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.XMIN = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.XMAX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_WINDOW_CLIP_VERTICAL(0):
    case NVC697_SET_WINDOW_CLIP_VERTICAL(1):
    case NVC697_SET_WINDOW_CLIP_VERTICAL(2):
    case NVC697_SET_WINDOW_CLIP_VERTICAL(3):
    case NVC697_SET_WINDOW_CLIP_VERTICAL(4):
    case NVC697_SET_WINDOW_CLIP_VERTICAL(5):
    case NVC697_SET_WINDOW_CLIP_VERTICAL(6):
    case NVC697_SET_WINDOW_CLIP_VERTICAL(7):
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.YMIN = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.YMAX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_CLIP_ID_EXTENT_X(0):
    case NVC697_SET_CLIP_ID_EXTENT_X(1):
    case NVC697_SET_CLIP_ID_EXTENT_X(2):
    case NVC697_SET_CLIP_ID_EXTENT_X(3):
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.MINX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_CLIP_ID_EXTENT_Y(0):
    case NVC697_SET_CLIP_ID_EXTENT_Y(1):
    case NVC697_SET_CLIP_ID_EXTENT_Y(2):
    case NVC697_SET_CLIP_ID_EXTENT_Y(3):
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.MINY = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_MAX_STREAM_OUTPUT_GS_INSTANCES_PER_TASK:
    
        parsed = (data >> 0) & ((1u << 11) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_API_VISIBLE_CALL_LIMIT:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_API_VISIBLE_CALL_LIMIT_V__0:
            fprintf(fp, "_0\n");
            break;
        case NVC697_SET_API_VISIBLE_CALL_LIMIT_V__1:
            fprintf(fp, "_1\n");
            break;
        case NVC697_SET_API_VISIBLE_CALL_LIMIT_V__2:
            fprintf(fp, "_2\n");
            break;
        case NVC697_SET_API_VISIBLE_CALL_LIMIT_V__4:
            fprintf(fp, "_4\n");
            break;
        case NVC697_SET_API_VISIBLE_CALL_LIMIT_V__8:
            fprintf(fp, "_8\n");
            break;
        case NVC697_SET_API_VISIBLE_CALL_LIMIT_V__16:
            fprintf(fp, "_16\n");
            break;
        case NVC697_SET_API_VISIBLE_CALL_LIMIT_V__32:
            fprintf(fp, "_32\n");
            break;
        case NVC697_SET_API_VISIBLE_CALL_LIMIT_V__64:
            fprintf(fp, "_64\n");
            break;
        case NVC697_SET_API_VISIBLE_CALL_LIMIT_V__128:
            fprintf(fp, "_128\n");
            break;
        case NVC697_SET_API_VISIBLE_CALL_LIMIT_V_NO_CHECK:
            fprintf(fp, "NO_CHECK\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_STATISTICS_COUNTER:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.DA_VERTICES_GENERATED_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_STATISTICS_COUNTER_DA_VERTICES_GENERATED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_STATISTICS_COUNTER_DA_VERTICES_GENERATED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.DA_PRIMITIVES_GENERATED_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_STATISTICS_COUNTER_DA_PRIMITIVES_GENERATED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_STATISTICS_COUNTER_DA_PRIMITIVES_GENERATED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.VS_INVOCATIONS_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_STATISTICS_COUNTER_VS_INVOCATIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_STATISTICS_COUNTER_VS_INVOCATIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.GS_INVOCATIONS_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_STATISTICS_COUNTER_GS_INVOCATIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_STATISTICS_COUNTER_GS_INVOCATIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.GS_PRIMITIVES_GENERATED_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_STATISTICS_COUNTER_GS_PRIMITIVES_GENERATED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_STATISTICS_COUNTER_GS_PRIMITIVES_GENERATED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 1) - 1);
        fprintf(fp, "%s.STREAMING_PRIMITIVES_SUCCEEDED_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_SUCCEEDED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_SUCCEEDED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 6) & ((1u << 1) - 1);
        fprintf(fp, "%s.STREAMING_PRIMITIVES_NEEDED_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_NEEDED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_NEEDED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLIPPER_INVOCATIONS_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_STATISTICS_COUNTER_CLIPPER_INVOCATIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_STATISTICS_COUNTER_CLIPPER_INVOCATIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLIPPER_PRIMITIVES_GENERATED_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_STATISTICS_COUNTER_CLIPPER_PRIMITIVES_GENERATED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_STATISTICS_COUNTER_CLIPPER_PRIMITIVES_GENERATED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 1) - 1);
        fprintf(fp, "%s.PS_INVOCATIONS_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_STATISTICS_COUNTER_PS_INVOCATIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_STATISTICS_COUNTER_PS_INVOCATIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 11) & ((1u << 1) - 1);
        fprintf(fp, "%s.TI_INVOCATIONS_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_STATISTICS_COUNTER_TI_INVOCATIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_STATISTICS_COUNTER_TI_INVOCATIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.TS_INVOCATIONS_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_STATISTICS_COUNTER_TS_INVOCATIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_STATISTICS_COUNTER_TS_INVOCATIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 13) & ((1u << 1) - 1);
        fprintf(fp, "%s.TS_PRIMITIVES_GENERATED_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_STATISTICS_COUNTER_TS_PRIMITIVES_GENERATED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_STATISTICS_COUNTER_TS_PRIMITIVES_GENERATED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 14) & ((1u << 1) - 1);
        fprintf(fp, "%s.TOTAL_STREAMING_PRIMITIVES_NEEDED_SUCCEEDED_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_STATISTICS_COUNTER_TOTAL_STREAMING_PRIMITIVES_NEEDED_SUCCEEDED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_STATISTICS_COUNTER_TOTAL_STREAMING_PRIMITIVES_NEEDED_SUCCEEDED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 10) & ((1u << 1) - 1);
        fprintf(fp, "%s.VTG_PRIMITIVES_OUT_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_STATISTICS_COUNTER_VTG_PRIMITIVES_OUT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_STATISTICS_COUNTER_VTG_PRIMITIVES_OUT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 15) & ((1u << 1) - 1);
        fprintf(fp, "%s.ALPHA_BETA_CLOCKS_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_STATISTICS_COUNTER_ALPHA_BETA_CLOCKS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_STATISTICS_COUNTER_ALPHA_BETA_CLOCKS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.SCG_CLOCKS_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_STATISTICS_COUNTER_SCG_CLOCKS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_STATISTICS_COUNTER_SCG_CLOCKS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_CLEAR_RECT_HORIZONTAL:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.XMIN = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.XMAX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_CLEAR_RECT_VERTICAL:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.YMIN = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.YMAX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_VERTEX_ARRAY_START:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_DRAW_VERTEX_ARRAY:
    
        parsed = data;
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_VIEWPORT_Z_CLIP:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.RANGE = ", prefix);
        switch (parsed) {
        case NVC697_SET_VIEWPORT_Z_CLIP_RANGE_NEGATIVE_W_TO_POSITIVE_W:
            fprintf(fp, "NEGATIVE_W_TO_POSITIVE_W\n");
            break;
        case NVC697_SET_VIEWPORT_Z_CLIP_RANGE_ZERO_TO_POSITIVE_W:
            fprintf(fp, "ZERO_TO_POSITIVE_W\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_COLOR_CLEAR_VALUE(0):
    case NVC697_SET_COLOR_CLEAR_VALUE(1):
    case NVC697_SET_COLOR_CLEAR_VALUE(2):
    case NVC697_SET_COLOR_CLEAR_VALUE(3):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_Z_CLEAR_VALUE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVC697_SET_SHADER_CACHE_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ICACHE_PREFETCH_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_FORCE_TRANSITION_TO_BETA:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_REDUCE_COLOR_THRESHOLDS_ENABLE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_REDUCE_COLOR_THRESHOLDS_ENABLE_V_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_REDUCE_COLOR_THRESHOLDS_ENABLE_V_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_STENCIL_CLEAR_VALUE:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_INVALIDATE_SHADER_CACHES_NO_WFI:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.INSTRUCTION = ", prefix);
        switch (parsed) {
        case NVC697_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.GLOBAL_DATA = ", prefix);
        switch (parsed) {
        case NVC697_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONSTANT = ", prefix);
        switch (parsed) {
        case NVC697_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ZCULL_SERIALIZATION:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZCULL_SERIALIZATION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ZCULL_SERIALIZATION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.APPLIED = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZCULL_SERIALIZATION_APPLIED_ALWAYS:
            fprintf(fp, "ALWAYS\n");
            break;
        case NVC697_SET_ZCULL_SERIALIZATION_APPLIED_LATE_Z:
            fprintf(fp, "LATE_Z\n");
            break;
        case NVC697_SET_ZCULL_SERIALIZATION_APPLIED_OUT_OF_GAMUT_Z:
            fprintf(fp, "OUT_OF_GAMUT_Z\n");
            break;
        case NVC697_SET_ZCULL_SERIALIZATION_APPLIED_LATE_Z_OR_OUT_OF_GAMUT_Z:
            fprintf(fp, "LATE_Z_OR_OUT_OF_GAMUT_Z\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_FRONT_POLYGON_MODE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_FRONT_POLYGON_MODE_V_POINT:
            fprintf(fp, "POINT\n");
            break;
        case NVC697_SET_FRONT_POLYGON_MODE_V_LINE:
            fprintf(fp, "LINE\n");
            break;
        case NVC697_SET_FRONT_POLYGON_MODE_V_FILL:
            fprintf(fp, "FILL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BACK_POLYGON_MODE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_BACK_POLYGON_MODE_V_POINT:
            fprintf(fp, "POINT\n");
            break;
        case NVC697_SET_BACK_POLYGON_MODE_V_LINE:
            fprintf(fp, "LINE\n");
            break;
        case NVC697_SET_BACK_POLYGON_MODE_V_FILL:
            fprintf(fp, "FILL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_POLY_SMOOTH:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_POLY_SMOOTH_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_POLY_SMOOTH_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ZCULL_DIR_FORMAT:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.ZDIR = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZCULL_DIR_FORMAT_ZDIR_LESS:
            fprintf(fp, "LESS\n");
            break;
        case NVC697_SET_ZCULL_DIR_FORMAT_ZDIR_GREATER:
            fprintf(fp, "GREATER\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.ZFORMAT = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZCULL_DIR_FORMAT_ZFORMAT_MSB:
            fprintf(fp, "MSB\n");
            break;
        case NVC697_SET_ZCULL_DIR_FORMAT_ZFORMAT_FP:
            fprintf(fp, "FP\n");
            break;
        case NVC697_SET_ZCULL_DIR_FORMAT_ZFORMAT_ZTRICK:
            fprintf(fp, "ZTRICK\n");
            break;
        case NVC697_SET_ZCULL_DIR_FORMAT_ZFORMAT_ZF32_1:
            fprintf(fp, "ZF32_1\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_POLY_OFFSET_POINT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_POLY_OFFSET_POINT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_POLY_OFFSET_POINT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_POLY_OFFSET_LINE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_POLY_OFFSET_LINE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_POLY_OFFSET_LINE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_POLY_OFFSET_FILL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_POLY_OFFSET_FILL_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_POLY_OFFSET_FILL_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_PATCH:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.SIZE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ITERATED_BLEND:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ITERATED_BLEND_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ITERATED_BLEND_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.ALPHA_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ITERATED_BLEND_ALPHA_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ITERATED_BLEND_ALPHA_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ITERATED_BLEND_PASS:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZCULL_CRITERION:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.SFUNC = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZCULL_CRITERION_SFUNC_NEVER:
            fprintf(fp, "NEVER\n");
            break;
        case NVC697_SET_ZCULL_CRITERION_SFUNC_LESS:
            fprintf(fp, "LESS\n");
            break;
        case NVC697_SET_ZCULL_CRITERION_SFUNC_EQUAL:
            fprintf(fp, "EQUAL\n");
            break;
        case NVC697_SET_ZCULL_CRITERION_SFUNC_LEQUAL:
            fprintf(fp, "LEQUAL\n");
            break;
        case NVC697_SET_ZCULL_CRITERION_SFUNC_GREATER:
            fprintf(fp, "GREATER\n");
            break;
        case NVC697_SET_ZCULL_CRITERION_SFUNC_NOTEQUAL:
            fprintf(fp, "NOTEQUAL\n");
            break;
        case NVC697_SET_ZCULL_CRITERION_SFUNC_GEQUAL:
            fprintf(fp, "GEQUAL\n");
            break;
        case NVC697_SET_ZCULL_CRITERION_SFUNC_ALWAYS:
            fprintf(fp, "ALWAYS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.NO_INVALIDATE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZCULL_CRITERION_NO_INVALIDATE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ZCULL_CRITERION_NO_INVALIDATE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 1) - 1);
        fprintf(fp, "%s.FORCE_MATCH = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZCULL_CRITERION_FORCE_MATCH_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ZCULL_CRITERION_FORCE_MATCH_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 8) - 1);
        fprintf(fp, "%s.SREF = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 24) & ((1u << 8) - 1);
        fprintf(fp, "%s.SMASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_PIXEL_SHADER_BARRIER:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.SYSMEMBAR_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_PIXEL_SHADER_BARRIER_SYSMEMBAR_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_PIXEL_SHADER_BARRIER_SYSMEMBAR_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_SM_TIMEOUT_INTERVAL:
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.COUNTER_BIT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_POINTER:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.TEST_CC = ", prefix);
        switch (parsed) {
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_TEST_CC_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_TEST_CC_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_TEST_CC_EQ:
            fprintf(fp, "EQ\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_TEST_CC_NE:
            fprintf(fp, "NE\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_TEST_CC_LT:
            fprintf(fp, "LT\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_TEST_CC_LE:
            fprintf(fp, "LE\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_TEST_CC_GT:
            fprintf(fp, "GT\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_TEST_CC_GE:
            fprintf(fp, "GE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 3) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERATION_ADD_PRODUCTS:
            fprintf(fp, "ADD_PRODUCTS\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERATION_SUB_PRODUCTS:
            fprintf(fp, "SUB_PRODUCTS\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERATION_MIN:
            fprintf(fp, "MIN\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERATION_MAX:
            fprintf(fp, "MAX\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERATION_RCP:
            fprintf(fp, "RCP\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERATION_ADD:
            fprintf(fp, "ADD\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERATION_SUBTRACT:
            fprintf(fp, "SUBTRACT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 6) & ((1u << 3) - 1);
        fprintf(fp, "%s.CONSTANT_INPUT_SELECT = ", prefix);
        switch (parsed) {
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_CONSTANT_INPUT_SELECT_CONSTANT0:
            fprintf(fp, "CONSTANT0\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_CONSTANT_INPUT_SELECT_CONSTANT1:
            fprintf(fp, "CONSTANT1\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_CONSTANT_INPUT_SELECT_CONSTANT2:
            fprintf(fp, "CONSTANT2\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_CONSTANT_INPUT_SELECT_CONSTANT3:
            fprintf(fp, "CONSTANT3\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_CONSTANT_INPUT_SELECT_CONSTANT4:
            fprintf(fp, "CONSTANT4\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_CONSTANT_INPUT_SELECT_CONSTANT5:
            fprintf(fp, "CONSTANT5\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_CONSTANT_INPUT_SELECT_CONSTANT6:
            fprintf(fp, "CONSTANT6\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_CONSTANT_INPUT_SELECT_CONSTANT7:
            fprintf(fp, "CONSTANT7\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 3) - 1);
        fprintf(fp, "%s.OPERAND_A_SELECT = ", prefix);
        switch (parsed) {
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_A_SELECT_SRC_RGB:
            fprintf(fp, "SRC_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_A_SELECT_DEST_RGB:
            fprintf(fp, "DEST_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_A_SELECT_SRC_AAA:
            fprintf(fp, "SRC_AAA\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_A_SELECT_DEST_AAA:
            fprintf(fp, "DEST_AAA\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_A_SELECT_TEMP0_RGB:
            fprintf(fp, "TEMP0_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_A_SELECT_TEMP1_RGB:
            fprintf(fp, "TEMP1_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_A_SELECT_TEMP2_RGB:
            fprintf(fp, "TEMP2_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_A_SELECT_PBR_RGB:
            fprintf(fp, "PBR_RGB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 4) - 1);
        fprintf(fp, "%s.OPERAND_B_SELECT = ", prefix);
        switch (parsed) {
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_ZERO:
            fprintf(fp, "ZERO\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_ONE:
            fprintf(fp, "ONE\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_SRC_RGB:
            fprintf(fp, "SRC_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_SRC_AAA:
            fprintf(fp, "SRC_AAA\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_ONE_MINUS_SRC_AAA:
            fprintf(fp, "ONE_MINUS_SRC_AAA\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_DEST_RGB:
            fprintf(fp, "DEST_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_DEST_AAA:
            fprintf(fp, "DEST_AAA\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_ONE_MINUS_DEST_AAA:
            fprintf(fp, "ONE_MINUS_DEST_AAA\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_TEMP0_RGB:
            fprintf(fp, "TEMP0_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_TEMP1_RGB:
            fprintf(fp, "TEMP1_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_TEMP2_RGB:
            fprintf(fp, "TEMP2_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_PBR_RGB:
            fprintf(fp, "PBR_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_CONSTANT_RGB:
            fprintf(fp, "CONSTANT_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_B_SELECT_ZERO_A_TIMES_B:
            fprintf(fp, "ZERO_A_TIMES_B\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 3) - 1);
        fprintf(fp, "%s.OPERAND_C_SELECT = ", prefix);
        switch (parsed) {
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_C_SELECT_SRC_RGB:
            fprintf(fp, "SRC_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_C_SELECT_DEST_RGB:
            fprintf(fp, "DEST_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_C_SELECT_SRC_AAA:
            fprintf(fp, "SRC_AAA\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_C_SELECT_DEST_AAA:
            fprintf(fp, "DEST_AAA\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_C_SELECT_TEMP0_RGB:
            fprintf(fp, "TEMP0_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_C_SELECT_TEMP1_RGB:
            fprintf(fp, "TEMP1_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_C_SELECT_TEMP2_RGB:
            fprintf(fp, "TEMP2_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_C_SELECT_PBR_RGB:
            fprintf(fp, "PBR_RGB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 19) & ((1u << 4) - 1);
        fprintf(fp, "%s.OPERAND_D_SELECT = ", prefix);
        switch (parsed) {
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_ZERO:
            fprintf(fp, "ZERO\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_ONE:
            fprintf(fp, "ONE\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_SRC_RGB:
            fprintf(fp, "SRC_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_SRC_AAA:
            fprintf(fp, "SRC_AAA\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_ONE_MINUS_SRC_AAA:
            fprintf(fp, "ONE_MINUS_SRC_AAA\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_DEST_RGB:
            fprintf(fp, "DEST_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_DEST_AAA:
            fprintf(fp, "DEST_AAA\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_ONE_MINUS_DEST_AAA:
            fprintf(fp, "ONE_MINUS_DEST_AAA\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_TEMP0_RGB:
            fprintf(fp, "TEMP0_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_TEMP1_RGB:
            fprintf(fp, "TEMP1_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_TEMP2_RGB:
            fprintf(fp, "TEMP2_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_PBR_RGB:
            fprintf(fp, "PBR_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_CONSTANT_RGB:
            fprintf(fp, "CONSTANT_RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OPERAND_D_SELECT_ZERO_C_TIMES_D:
            fprintf(fp, "ZERO_C_TIMES_D\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 23) & ((1u << 3) - 1);
        fprintf(fp, "%s.OUTPUT_SWIZZLE = ", prefix);
        switch (parsed) {
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OUTPUT_SWIZZLE_RGB:
            fprintf(fp, "RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OUTPUT_SWIZZLE_GBR:
            fprintf(fp, "GBR\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OUTPUT_SWIZZLE_RRR:
            fprintf(fp, "RRR\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OUTPUT_SWIZZLE_GGG:
            fprintf(fp, "GGG\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OUTPUT_SWIZZLE_BBB:
            fprintf(fp, "BBB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OUTPUT_SWIZZLE_R_TO_A:
            fprintf(fp, "R_TO_A\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 26) & ((1u << 2) - 1);
        fprintf(fp, "%s.OUTPUT_WRITE_MASK = ", prefix);
        switch (parsed) {
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OUTPUT_WRITE_MASK_RGB:
            fprintf(fp, "RGB\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OUTPUT_WRITE_MASK_R_ONLY:
            fprintf(fp, "R_ONLY\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OUTPUT_WRITE_MASK_G_ONLY:
            fprintf(fp, "G_ONLY\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_OUTPUT_WRITE_MASK_B_ONLY:
            fprintf(fp, "B_ONLY\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 28) & ((1u << 2) - 1);
        fprintf(fp, "%s.PASS_OUTPUT = ", prefix);
        switch (parsed) {
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_PASS_OUTPUT_TEMP0:
            fprintf(fp, "TEMP0\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_PASS_OUTPUT_TEMP1:
            fprintf(fp, "TEMP1\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_PASS_OUTPUT_TEMP2:
            fprintf(fp, "TEMP2\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_PASS_OUTPUT_NONE:
            fprintf(fp, "NONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 31) & ((1u << 1) - 1);
        fprintf(fp, "%s.SET_CC = ", prefix);
        switch (parsed) {
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_SET_CC_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_LOAD_ITERATED_BLEND_INSTRUCTION_SET_CC_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_WINDOW_OFFSET_X:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_WINDOW_OFFSET_Y:
    
        parsed = (data >> 0) & ((1u << 18) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SCISSOR_ENABLE(0):
    case NVC697_SET_SCISSOR_ENABLE(1):
    case NVC697_SET_SCISSOR_ENABLE(2):
    case NVC697_SET_SCISSOR_ENABLE(3):
    case NVC697_SET_SCISSOR_ENABLE(4):
    case NVC697_SET_SCISSOR_ENABLE(5):
    case NVC697_SET_SCISSOR_ENABLE(6):
    case NVC697_SET_SCISSOR_ENABLE(7):
    case NVC697_SET_SCISSOR_ENABLE(8):
    case NVC697_SET_SCISSOR_ENABLE(9):
    case NVC697_SET_SCISSOR_ENABLE(10):
    case NVC697_SET_SCISSOR_ENABLE(11):
    case NVC697_SET_SCISSOR_ENABLE(12):
    case NVC697_SET_SCISSOR_ENABLE(13):
    case NVC697_SET_SCISSOR_ENABLE(14):
    case NVC697_SET_SCISSOR_ENABLE(15):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_SCISSOR_ENABLE_V_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_SCISSOR_ENABLE_V_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_SCISSOR_HORIZONTAL(0):
    case NVC697_SET_SCISSOR_HORIZONTAL(1):
    case NVC697_SET_SCISSOR_HORIZONTAL(2):
    case NVC697_SET_SCISSOR_HORIZONTAL(3):
    case NVC697_SET_SCISSOR_HORIZONTAL(4):
    case NVC697_SET_SCISSOR_HORIZONTAL(5):
    case NVC697_SET_SCISSOR_HORIZONTAL(6):
    case NVC697_SET_SCISSOR_HORIZONTAL(7):
    case NVC697_SET_SCISSOR_HORIZONTAL(8):
    case NVC697_SET_SCISSOR_HORIZONTAL(9):
    case NVC697_SET_SCISSOR_HORIZONTAL(10):
    case NVC697_SET_SCISSOR_HORIZONTAL(11):
    case NVC697_SET_SCISSOR_HORIZONTAL(12):
    case NVC697_SET_SCISSOR_HORIZONTAL(13):
    case NVC697_SET_SCISSOR_HORIZONTAL(14):
    case NVC697_SET_SCISSOR_HORIZONTAL(15):
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.XMIN = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.XMAX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SCISSOR_VERTICAL(0):
    case NVC697_SET_SCISSOR_VERTICAL(1):
    case NVC697_SET_SCISSOR_VERTICAL(2):
    case NVC697_SET_SCISSOR_VERTICAL(3):
    case NVC697_SET_SCISSOR_VERTICAL(4):
    case NVC697_SET_SCISSOR_VERTICAL(5):
    case NVC697_SET_SCISSOR_VERTICAL(6):
    case NVC697_SET_SCISSOR_VERTICAL(7):
    case NVC697_SET_SCISSOR_VERTICAL(8):
    case NVC697_SET_SCISSOR_VERTICAL(9):
    case NVC697_SET_SCISSOR_VERTICAL(10):
    case NVC697_SET_SCISSOR_VERTICAL(11):
    case NVC697_SET_SCISSOR_VERTICAL(12):
    case NVC697_SET_SCISSOR_VERTICAL(13):
    case NVC697_SET_SCISSOR_VERTICAL(14):
    case NVC697_SET_SCISSOR_VERTICAL(15):
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.YMIN = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.YMAX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_VPC_PERF_KNOB:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.CULLED_SMALL_LINES = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 8) - 1);
        fprintf(fp, "%s.CULLED_SMALL_TRIANGLES = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 8) - 1);
        fprintf(fp, "%s.NONCULLED_LINES_AND_POINTS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 24) & ((1u << 8) - 1);
        fprintf(fp, "%s.NONCULLED_TRIANGLES = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_PM_LOCAL_TRIGGER:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.BOOKMARK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_POST_Z_PS_IMASK:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_POST_Z_PS_IMASK_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_POST_Z_PS_IMASK_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(0):
    case NVC697_SET_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(1):
    case NVC697_SET_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(2):
    case NVC697_SET_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(3):
    
        parsed = (data >> 0) & ((1u << 11) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SPARE_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(0):
    case NVC697_SET_SPARE_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(1):
    case NVC697_SET_SPARE_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(2):
    case NVC697_SET_SPARE_MULTI_VIEW_RENDER_TARGET_ARRAY_INDEX_OFFSET(3):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_CONSTANT_COLOR_RENDERING:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_CONSTANT_COLOR_RENDERING_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_CONSTANT_COLOR_RENDERING_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_CONSTANT_COLOR_RENDERING_RED:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_CONSTANT_COLOR_RENDERING_GREEN:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_CONSTANT_COLOR_RENDERING_BLUE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_CONSTANT_COLOR_RENDERING_ALPHA:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_BACK_STENCIL_FUNC_REF:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_BACK_STENCIL_MASK:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_BACK_STENCIL_FUNC_MASK:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_VERTEX_STREAM_SUBSTITUTE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_VERTEX_STREAM_SUBSTITUTE_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_LINE_MODE_POLYGON_CLIP:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.GENERATED_EDGE = ", prefix);
        switch (parsed) {
        case NVC697_SET_LINE_MODE_POLYGON_CLIP_GENERATED_EDGE_DRAW_LINE:
            fprintf(fp, "DRAW_LINE\n");
            break;
        case NVC697_SET_LINE_MODE_POLYGON_CLIP_GENERATED_EDGE_DO_NOT_DRAW_LINE:
            fprintf(fp, "DO_NOT_DRAW_LINE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_SINGLE_CT_WRITE_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_SINGLE_CT_WRITE_CONTROL_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_SINGLE_CT_WRITE_CONTROL_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_VTG_WARP_WATERMARKS:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.LOW = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.HIGH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_DEPTH_BOUNDS_MIN:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVC697_SET_DEPTH_BOUNDS_MAX:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVC697_SET_SAMPLE_MASK:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.RASTER_OUT_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_SAMPLE_MASK_RASTER_OUT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_SAMPLE_MASK_RASTER_OUT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.COLOR_TARGET_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_SAMPLE_MASK_COLOR_TARGET_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_SAMPLE_MASK_COLOR_TARGET_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_COLOR_TARGET_SAMPLE_MASK:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_CT_MRT_ENABLE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_CT_MRT_ENABLE_V_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_CT_MRT_ENABLE_V_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_NONMULTISAMPLED_Z:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_NONMULTISAMPLED_Z_V_PER_SAMPLE:
            fprintf(fp, "PER_SAMPLE\n");
            break;
        case NVC697_SET_NONMULTISAMPLED_Z_V_AT_PIXEL_CENTER:
            fprintf(fp, "AT_PIXEL_CENTER\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_TIR:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVC697_SET_TIR_MODE_DISABLED:
            fprintf(fp, "DISABLED\n");
            break;
        case NVC697_SET_TIR_MODE_RASTER_N_TARGET_M:
            fprintf(fp, "RASTER_N_TARGET_M\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ANTI_ALIAS_RASTER:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.SAMPLES = ", prefix);
        switch (parsed) {
        case NVC697_SET_ANTI_ALIAS_RASTER_SAMPLES_MODE_1X1:
            fprintf(fp, "MODE_1X1\n");
            break;
        case NVC697_SET_ANTI_ALIAS_RASTER_SAMPLES_MODE_2X2:
            fprintf(fp, "MODE_2X2\n");
            break;
        case NVC697_SET_ANTI_ALIAS_RASTER_SAMPLES_MODE_4X2_D3D:
            fprintf(fp, "MODE_4X2_D3D\n");
            break;
        case NVC697_SET_ANTI_ALIAS_RASTER_SAMPLES_MODE_2X1_D3D:
            fprintf(fp, "MODE_2X1_D3D\n");
            break;
        case NVC697_SET_ANTI_ALIAS_RASTER_SAMPLES_MODE_4X4:
            fprintf(fp, "MODE_4X4\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_SAMPLE_MASK_X0_Y0:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SAMPLE_MASK_X1_Y0:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SAMPLE_MASK_X0_Y1:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SAMPLE_MASK_X1_Y1:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SURFACE_CLIP_ID_MEMORY_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SURFACE_CLIP_ID_MEMORY_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_TIR_MODULATION:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.COMPONENT_SELECT = ", prefix);
        switch (parsed) {
        case NVC697_SET_TIR_MODULATION_COMPONENT_SELECT_NO_MODULATION:
            fprintf(fp, "NO_MODULATION\n");
            break;
        case NVC697_SET_TIR_MODULATION_COMPONENT_SELECT_MODULATE_RGB:
            fprintf(fp, "MODULATE_RGB\n");
            break;
        case NVC697_SET_TIR_MODULATION_COMPONENT_SELECT_MODULATE_ALPHA_ONLY:
            fprintf(fp, "MODULATE_ALPHA_ONLY\n");
            break;
        case NVC697_SET_TIR_MODULATION_COMPONENT_SELECT_MODULATE_RGBA:
            fprintf(fp, "MODULATE_RGBA\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_TIR_MODULATION_FUNCTION:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.SELECT = ", prefix);
        switch (parsed) {
        case NVC697_SET_TIR_MODULATION_FUNCTION_SELECT_LINEAR:
            fprintf(fp, "LINEAR\n");
            break;
        case NVC697_SET_TIR_MODULATION_FUNCTION_SELECT_TABLE:
            fprintf(fp, "TABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BLEND_OPT_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ALLOW_FLOAT_PIXEL_KILLS = ", prefix);
        switch (parsed) {
        case NVC697_SET_BLEND_OPT_CONTROL_ALLOW_FLOAT_PIXEL_KILLS_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_BLEND_OPT_CONTROL_ALLOW_FLOAT_PIXEL_KILLS_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ZT_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZT_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZT_FORMAT:
    
        parsed = (data >> 0) & ((1u << 5) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZT_FORMAT_V_Z16:
            fprintf(fp, "Z16\n");
            break;
        case NVC697_SET_ZT_FORMAT_V_Z24S8:
            fprintf(fp, "Z24S8\n");
            break;
        case NVC697_SET_ZT_FORMAT_V_X8Z24:
            fprintf(fp, "X8Z24\n");
            break;
        case NVC697_SET_ZT_FORMAT_V_S8Z24:
            fprintf(fp, "S8Z24\n");
            break;
        case NVC697_SET_ZT_FORMAT_V_S8:
            fprintf(fp, "S8\n");
            break;
        case NVC697_SET_ZT_FORMAT_V_V8Z24:
            fprintf(fp, "V8Z24\n");
            break;
        case NVC697_SET_ZT_FORMAT_V_ZF32:
            fprintf(fp, "ZF32\n");
            break;
        case NVC697_SET_ZT_FORMAT_V_ZF32_X24S8:
            fprintf(fp, "ZF32_X24S8\n");
            break;
        case NVC697_SET_ZT_FORMAT_V_X8Z24_X16V8S8:
            fprintf(fp, "X8Z24_X16V8S8\n");
            break;
        case NVC697_SET_ZT_FORMAT_V_ZF32_X16V8X8:
            fprintf(fp, "ZF32_X16V8X8\n");
            break;
        case NVC697_SET_ZT_FORMAT_V_ZF32_X16V8S8:
            fprintf(fp, "ZF32_X16V8S8\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ZT_BLOCK_SIZE:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZT_BLOCK_SIZE_WIDTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZT_BLOCK_SIZE_HEIGHT_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVC697_SET_ZT_BLOCK_SIZE_HEIGHT_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVC697_SET_ZT_BLOCK_SIZE_HEIGHT_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVC697_SET_ZT_BLOCK_SIZE_HEIGHT_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVC697_SET_ZT_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVC697_SET_ZT_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.DEPTH = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZT_BLOCK_SIZE_DEPTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ZT_ARRAY_PITCH:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SURFACE_CLIP_HORIZONTAL:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.X = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SURFACE_CLIP_VERTICAL:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.Y = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.SYSTEM_MEMORY_VOLATILE = ", prefix);
        switch (parsed) {
        case NVC697_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_SYSTEM_MEMORY_VOLATILE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_SYSTEM_MEMORY_VOLATILE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.POLICY = ", prefix);
        switch (parsed) {
        case NVC697_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_POLICY_EVICT_FIRST:
            fprintf(fp, "EVICT_FIRST\n");
            break;
        case NVC697_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_POLICY_EVICT_NORMAL:
            fprintf(fp, "EVICT_NORMAL\n");
            break;
        case NVC697_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_POLICY_EVICT_LAST:
            fprintf(fp, "EVICT_LAST\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_VIEWPORT_MULTICAST:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ORDER = ", prefix);
        switch (parsed) {
        case NVC697_SET_VIEWPORT_MULTICAST_ORDER_VIEWPORT_ORDER:
            fprintf(fp, "VIEWPORT_ORDER\n");
            break;
        case NVC697_SET_VIEWPORT_MULTICAST_ORDER_PRIMITIVE_ORDER:
            fprintf(fp, "PRIMITIVE_ORDER\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_TESSELLATION_CUT_HEIGHT:
    
        parsed = (data >> 0) & ((1u << 5) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_MAX_GS_INSTANCES_PER_TASK:
    
        parsed = (data >> 0) & ((1u << 11) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_MAX_GS_OUTPUT_VERTICES_PER_TASK:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_RESERVED_SW_METHOD00:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_GS_OUTPUT_CB_STORAGE_MULTIPLIER:
    
        parsed = (data >> 0) & ((1u << 10) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_BETA_CB_STORAGE_CONSTRAINT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_BETA_CB_STORAGE_CONSTRAINT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_BETA_CB_STORAGE_CONSTRAINT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_TI_OUTPUT_CB_STORAGE_MULTIPLIER:
    
        parsed = (data >> 0) & ((1u << 10) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ALPHA_CB_STORAGE_CONSTRAINT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ALPHA_CB_STORAGE_CONSTRAINT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ALPHA_CB_STORAGE_CONSTRAINT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_RESERVED_SW_METHOD01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_RESERVED_SW_METHOD02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
        case NVC697_SET_SPARE_NOOP01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SPARE_NOOP02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SPARE_NOOP03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SPARE_NOOP04:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SPARE_NOOP05:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SPARE_NOOP06:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SPARE_NOOP07:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SPARE_NOOP08:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SPARE_NOOP09:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SPARE_NOOP10:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SPARE_NOOP11:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SPARE_NOOP12:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SPARE_NOOP13:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SPARE_NOOP14:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SPARE_NOOP15:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_RESERVED_SW_METHOD03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_RESERVED_SW_METHOD04:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_RESERVED_SW_METHOD05:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_RESERVED_SW_METHOD06:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_RESERVED_SW_METHOD07:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_RESERVED_SW_METHOD08:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_RESERVED_SW_METHOD09:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_REDUCE_COLOR_THRESHOLDS_UNORM8:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ALL_COVERED_ALL_HIT_ONCE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 8) - 1);
        fprintf(fp, "%s.ALL_COVERED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_RESERVED_SW_METHOD10:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_RESERVED_SW_METHOD11:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_RESERVED_SW_METHOD12:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_RESERVED_SW_METHOD13:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_REDUCE_COLOR_THRESHOLDS_UNORM10:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ALL_COVERED_ALL_HIT_ONCE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 8) - 1);
        fprintf(fp, "%s.ALL_COVERED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_REDUCE_COLOR_THRESHOLDS_UNORM16:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ALL_COVERED_ALL_HIT_ONCE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 8) - 1);
        fprintf(fp, "%s.ALL_COVERED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_REDUCE_COLOR_THRESHOLDS_FP11:
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.ALL_COVERED_ALL_HIT_ONCE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 6) - 1);
        fprintf(fp, "%s.ALL_COVERED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_REDUCE_COLOR_THRESHOLDS_FP16:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ALL_COVERED_ALL_HIT_ONCE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 8) - 1);
        fprintf(fp, "%s.ALL_COVERED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_REDUCE_COLOR_THRESHOLDS_SRGB8:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ALL_COVERED_ALL_HIT_ONCE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 8) - 1);
        fprintf(fp, "%s.ALL_COVERED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_UNBIND_ALL:
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONSTANT_BUFFERS = ", prefix);
        switch (parsed) {
        case NVC697_UNBIND_ALL_CONSTANT_BUFFERS_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_UNBIND_ALL_CONSTANT_BUFFERS_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_CLEAR_SURFACE_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.RESPECT_STENCIL_MASK = ", prefix);
        switch (parsed) {
        case NVC697_SET_CLEAR_SURFACE_CONTROL_RESPECT_STENCIL_MASK_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_CLEAR_SURFACE_CONTROL_RESPECT_STENCIL_MASK_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.USE_CLEAR_RECT = ", prefix);
        switch (parsed) {
        case NVC697_SET_CLEAR_SURFACE_CONTROL_USE_CLEAR_RECT_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_CLEAR_SURFACE_CONTROL_USE_CLEAR_RECT_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.USE_SCISSOR0 = ", prefix);
        switch (parsed) {
        case NVC697_SET_CLEAR_SURFACE_CONTROL_USE_SCISSOR0_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_CLEAR_SURFACE_CONTROL_USE_SCISSOR0_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.USE_VIEWPORT_CLIP0 = ", prefix);
        switch (parsed) {
        case NVC697_SET_CLEAR_SURFACE_CONTROL_USE_VIEWPORT_CLIP0_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_CLEAR_SURFACE_CONTROL_USE_VIEWPORT_CLIP0_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS:
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.POLICY = ", prefix);
        switch (parsed) {
        case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS_POLICY_EVICT_FIRST:
            fprintf(fp, "EVICT_FIRST\n");
            break;
        case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS_POLICY_EVICT_NORMAL:
            fprintf(fp, "EVICT_NORMAL\n");
            break;
        case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS_POLICY_EVICT_LAST:
            fprintf(fp, "EVICT_LAST\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_RESERVED_SW_METHOD14:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_RESERVED_SW_METHOD15:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_NO_OPERATION_DATA_HI:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_DEPTH_BIAS_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.DEPTH_FORMAT_DEPENDENT = ", prefix);
        switch (parsed) {
        case NVC697_SET_DEPTH_BIAS_CONTROL_DEPTH_FORMAT_DEPENDENT_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_DEPTH_BIAS_CONTROL_DEPTH_FORMAT_DEPENDENT_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_PM_TRIGGER_END:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_VERTEX_ID_BASE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_STENCIL_COMPRESSION:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_STENCIL_COMPRESSION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_STENCIL_COMPRESSION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
            case NVC697_SET_TIR_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.Z_PASS_PIXEL_COUNT_USE_RASTER_SAMPLES = ", prefix);
        switch (parsed) {
        case NVC697_SET_TIR_CONTROL_Z_PASS_PIXEL_COUNT_USE_RASTER_SAMPLES_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        case NVC697_SET_TIR_CONTROL_Z_PASS_PIXEL_COUNT_USE_RASTER_SAMPLES_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.ALPHA_TO_COVERAGE_USE_RASTER_SAMPLES = ", prefix);
        switch (parsed) {
        case NVC697_SET_TIR_CONTROL_ALPHA_TO_COVERAGE_USE_RASTER_SAMPLES_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        case NVC697_SET_TIR_CONTROL_ALPHA_TO_COVERAGE_USE_RASTER_SAMPLES_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.REDUCE_COVERAGE = ", prefix);
        switch (parsed) {
        case NVC697_SET_TIR_CONTROL_REDUCE_COVERAGE_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        case NVC697_SET_TIR_CONTROL_REDUCE_COVERAGE_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_MUTABLE_METHOD_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.TREAT_MUTABLE_AS_HEAVYWEIGHT = ", prefix);
        switch (parsed) {
        case NVC697_SET_MUTABLE_METHOD_CONTROL_TREAT_MUTABLE_AS_HEAVYWEIGHT_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_MUTABLE_METHOD_CONTROL_TREAT_MUTABLE_AS_HEAVYWEIGHT_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_POST_PS_INITIAL_COVERAGE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.USE_PRE_PS_COVERAGE = ", prefix);
        switch (parsed) {
        case NVC697_SET_POST_PS_INITIAL_COVERAGE_USE_PRE_PS_COVERAGE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_POST_PS_INITIAL_COVERAGE_USE_PRE_PS_COVERAGE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_FILL_VIA_TRIANGLE:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVC697_SET_FILL_VIA_TRIANGLE_MODE_DISABLED:
            fprintf(fp, "DISABLED\n");
            break;
        case NVC697_SET_FILL_VIA_TRIANGLE_MODE_FILL_ALL:
            fprintf(fp, "FILL_ALL\n");
            break;
        case NVC697_SET_FILL_VIA_TRIANGLE_MODE_FILL_BBOX:
            fprintf(fp, "FILL_BBOX\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BLEND_PER_FORMAT_ENABLE:
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.SNORM8_UNORM16_SNORM16 = ", prefix);
        switch (parsed) {
        case NVC697_SET_BLEND_PER_FORMAT_ENABLE_SNORM8_UNORM16_SNORM16_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_BLEND_PER_FORMAT_ENABLE_SNORM8_UNORM16_SNORM16_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_FLUSH_PENDING_WRITES:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.SM_DOES_GLOBAL_STORE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_CONSERVATIVE_RASTER:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_CONSERVATIVE_RASTER_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_CONSERVATIVE_RASTER_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_MESH_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_MESH_CONTROL_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_MESH_CONTROL_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_MESH_SHADER_A:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.OUTPUT_TOPOLOGY = ", prefix);
        switch (parsed) {
        case NVC697_SET_MESH_SHADER_A_OUTPUT_TOPOLOGY_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVC697_SET_MESH_SHADER_A_OUTPUT_TOPOLOGY_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVC697_SET_MESH_SHADER_A_OUTPUT_TOPOLOGY_LINE_LOOP:
            fprintf(fp, "LINE_LOOP\n");
            break;
        case NVC697_SET_MESH_SHADER_A_OUTPUT_TOPOLOGY_LINE_STRIP:
            fprintf(fp, "LINE_STRIP\n");
            break;
        case NVC697_SET_MESH_SHADER_A_OUTPUT_TOPOLOGY_TRIANGLES:
            fprintf(fp, "TRIANGLES\n");
            break;
        case NVC697_SET_MESH_SHADER_A_OUTPUT_TOPOLOGY_TRIANGLE_STRIP:
            fprintf(fp, "TRIANGLE_STRIP\n");
            break;
        case NVC697_SET_MESH_SHADER_A_OUTPUT_TOPOLOGY_TRIANGLE_FAN:
            fprintf(fp, "TRIANGLE_FAN\n");
            break;
        case NVC697_SET_MESH_SHADER_A_OUTPUT_TOPOLOGY_QUADS:
            fprintf(fp, "QUADS\n");
            break;
        case NVC697_SET_MESH_SHADER_A_OUTPUT_TOPOLOGY_QUAD_STRIP:
            fprintf(fp, "QUAD_STRIP\n");
            break;
        case NVC697_SET_MESH_SHADER_A_OUTPUT_TOPOLOGY_POLYGON:
            fprintf(fp, "POLYGON\n");
            break;
        case NVC697_SET_MESH_SHADER_A_OUTPUT_TOPOLOGY_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVC697_SET_MESH_SHADER_A_OUTPUT_TOPOLOGY_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVC697_SET_MESH_SHADER_A_OUTPUT_TOPOLOGY_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVC697_SET_MESH_SHADER_A_OUTPUT_TOPOLOGY_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVC697_SET_MESH_SHADER_A_OUTPUT_TOPOLOGY_PATCH:
            fprintf(fp, "PATCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 9) - 1);
        fprintf(fp, "%s.MAX_VERTEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 13) & ((1u << 10) - 1);
        fprintf(fp, "%s.MAX_PRIMITIVE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_MESH_SHADER_B:
    
        parsed = (data >> 8) & ((1u << 9) - 1);
        fprintf(fp, "%s.SHARED_MEM_LINES = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 20) & ((1u << 6) - 1);
        fprintf(fp, "%s.THREAD_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_MESH_INIT_SHADER:
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.THREAD_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 12) & ((1u << 9) - 1);
        fprintf(fp, "%s.LOCAL_BUFFER_LINES = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 22) & ((1u << 9) - 1);
        fprintf(fp, "%s.OUTPUT_TO_M_S_LINES = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_VERTEX_ATTRIBUTE_A(0):
    case NVC697_SET_VERTEX_ATTRIBUTE_A(1):
    case NVC697_SET_VERTEX_ATTRIBUTE_A(2):
    case NVC697_SET_VERTEX_ATTRIBUTE_A(3):
    case NVC697_SET_VERTEX_ATTRIBUTE_A(4):
    case NVC697_SET_VERTEX_ATTRIBUTE_A(5):
    case NVC697_SET_VERTEX_ATTRIBUTE_A(6):
    case NVC697_SET_VERTEX_ATTRIBUTE_A(7):
    case NVC697_SET_VERTEX_ATTRIBUTE_A(8):
    case NVC697_SET_VERTEX_ATTRIBUTE_A(9):
    case NVC697_SET_VERTEX_ATTRIBUTE_A(10):
    case NVC697_SET_VERTEX_ATTRIBUTE_A(11):
    case NVC697_SET_VERTEX_ATTRIBUTE_A(12):
    case NVC697_SET_VERTEX_ATTRIBUTE_A(13):
    case NVC697_SET_VERTEX_ATTRIBUTE_A(14):
    case NVC697_SET_VERTEX_ATTRIBUTE_A(15):
    
        parsed = (data >> 0) & ((1u << 5) - 1);
        fprintf(fp, "%s.STREAM = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 6) & ((1u << 1) - 1);
        fprintf(fp, "%s.SOURCE = ", prefix);
        switch (parsed) {
        case NVC697_SET_VERTEX_ATTRIBUTE_A_SOURCE_ACTIVE:
            fprintf(fp, "ACTIVE\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_SOURCE_INACTIVE:
            fprintf(fp, "INACTIVE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 14) - 1);
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 21) & ((1u << 6) - 1);
        fprintf(fp, "%s.COMPONENT_BIT_WIDTHS = ", prefix);
        switch (parsed) {
        case NVC697_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R32_G32_B32_A32:
            fprintf(fp, "R32_G32_B32_A32\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R32_G32_B32:
            fprintf(fp, "R32_G32_B32\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R16_G16_B16_A16:
            fprintf(fp, "R16_G16_B16_A16\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R32_G32:
            fprintf(fp, "R32_G32\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R16_G16_B16:
            fprintf(fp, "R16_G16_B16\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_A8B8G8R8:
            fprintf(fp, "A8B8G8R8\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R8_G8_B8_A8:
            fprintf(fp, "R8_G8_B8_A8\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_X8B8G8R8:
            fprintf(fp, "X8B8G8R8\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_A2B10G10R10:
            fprintf(fp, "A2B10G10R10\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_B10G11R11:
            fprintf(fp, "B10G11R11\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R16_G16:
            fprintf(fp, "R16_G16\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R32:
            fprintf(fp, "R32\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R8_G8_B8:
            fprintf(fp, "R8_G8_B8\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_G8R8:
            fprintf(fp, "G8R8\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R8_G8:
            fprintf(fp, "R8_G8\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R16:
            fprintf(fp, "R16\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R8:
            fprintf(fp, "R8\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_A8:
            fprintf(fp, "A8\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 27) & ((1u << 3) - 1);
        fprintf(fp, "%s.NUMERICAL_TYPE = ", prefix);
        switch (parsed) {
        case NVC697_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY:
            fprintf(fp, "UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_SNORM:
            fprintf(fp, "NUM_SNORM\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_UNORM:
            fprintf(fp, "NUM_UNORM\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_SINT:
            fprintf(fp, "NUM_SINT\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_UINT:
            fprintf(fp, "NUM_UINT\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_USCALED:
            fprintf(fp, "NUM_USCALED\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_SSCALED:
            fprintf(fp, "NUM_SSCALED\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_FLOAT:
            fprintf(fp, "NUM_FLOAT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 31) & ((1u << 1) - 1);
        fprintf(fp, "%s.SWAP_R_AND_B = ", prefix);
        switch (parsed) {
        case NVC697_SET_VERTEX_ATTRIBUTE_A_SWAP_R_AND_B_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_A_SWAP_R_AND_B_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_VERTEX_ATTRIBUTE_B(0):
    case NVC697_SET_VERTEX_ATTRIBUTE_B(1):
    case NVC697_SET_VERTEX_ATTRIBUTE_B(2):
    case NVC697_SET_VERTEX_ATTRIBUTE_B(3):
    case NVC697_SET_VERTEX_ATTRIBUTE_B(4):
    case NVC697_SET_VERTEX_ATTRIBUTE_B(5):
    case NVC697_SET_VERTEX_ATTRIBUTE_B(6):
    case NVC697_SET_VERTEX_ATTRIBUTE_B(7):
    case NVC697_SET_VERTEX_ATTRIBUTE_B(8):
    case NVC697_SET_VERTEX_ATTRIBUTE_B(9):
    case NVC697_SET_VERTEX_ATTRIBUTE_B(10):
    case NVC697_SET_VERTEX_ATTRIBUTE_B(11):
    case NVC697_SET_VERTEX_ATTRIBUTE_B(12):
    case NVC697_SET_VERTEX_ATTRIBUTE_B(13):
    case NVC697_SET_VERTEX_ATTRIBUTE_B(14):
    case NVC697_SET_VERTEX_ATTRIBUTE_B(15):
    
        parsed = (data >> 0) & ((1u << 5) - 1);
        fprintf(fp, "%s.STREAM = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 6) & ((1u << 1) - 1);
        fprintf(fp, "%s.SOURCE = ", prefix);
        switch (parsed) {
        case NVC697_SET_VERTEX_ATTRIBUTE_B_SOURCE_ACTIVE:
            fprintf(fp, "ACTIVE\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_SOURCE_INACTIVE:
            fprintf(fp, "INACTIVE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 14) - 1);
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 21) & ((1u << 6) - 1);
        fprintf(fp, "%s.COMPONENT_BIT_WIDTHS = ", prefix);
        switch (parsed) {
        case NVC697_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R32_G32_B32_A32:
            fprintf(fp, "R32_G32_B32_A32\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R32_G32_B32:
            fprintf(fp, "R32_G32_B32\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R16_G16_B16_A16:
            fprintf(fp, "R16_G16_B16_A16\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R32_G32:
            fprintf(fp, "R32_G32\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R16_G16_B16:
            fprintf(fp, "R16_G16_B16\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_A8B8G8R8:
            fprintf(fp, "A8B8G8R8\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R8_G8_B8_A8:
            fprintf(fp, "R8_G8_B8_A8\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_X8B8G8R8:
            fprintf(fp, "X8B8G8R8\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_A2B10G10R10:
            fprintf(fp, "A2B10G10R10\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_B10G11R11:
            fprintf(fp, "B10G11R11\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R16_G16:
            fprintf(fp, "R16_G16\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R32:
            fprintf(fp, "R32\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R8_G8_B8:
            fprintf(fp, "R8_G8_B8\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_G8R8:
            fprintf(fp, "G8R8\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R8_G8:
            fprintf(fp, "R8_G8\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R16:
            fprintf(fp, "R16\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R8:
            fprintf(fp, "R8\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_A8:
            fprintf(fp, "A8\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 27) & ((1u << 3) - 1);
        fprintf(fp, "%s.NUMERICAL_TYPE = ", prefix);
        switch (parsed) {
        case NVC697_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY:
            fprintf(fp, "UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_SNORM:
            fprintf(fp, "NUM_SNORM\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_UNORM:
            fprintf(fp, "NUM_UNORM\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_SINT:
            fprintf(fp, "NUM_SINT\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_UINT:
            fprintf(fp, "NUM_UINT\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_USCALED:
            fprintf(fp, "NUM_USCALED\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_SSCALED:
            fprintf(fp, "NUM_SSCALED\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_FLOAT:
            fprintf(fp, "NUM_FLOAT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 31) & ((1u << 1) - 1);
        fprintf(fp, "%s.SWAP_R_AND_B = ", prefix);
        switch (parsed) {
        case NVC697_SET_VERTEX_ATTRIBUTE_B_SWAP_R_AND_B_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_VERTEX_ATTRIBUTE_B_SWAP_R_AND_B_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ANTI_ALIAS_SAMPLE_POSITIONS(0):
    case NVC697_SET_ANTI_ALIAS_SAMPLE_POSITIONS(1):
    case NVC697_SET_ANTI_ALIAS_SAMPLE_POSITIONS(2):
    case NVC697_SET_ANTI_ALIAS_SAMPLE_POSITIONS(3):
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.X0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.Y0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.X1 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 12) & ((1u << 4) - 1);
        fprintf(fp, "%s.Y1 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 4) - 1);
        fprintf(fp, "%s.X2 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 20) & ((1u << 4) - 1);
        fprintf(fp, "%s.Y2 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 24) & ((1u << 4) - 1);
        fprintf(fp, "%s.X3 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.Y3 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_OFFSET_RENDER_TARGET_INDEX:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.BY_VIEWPORT_INDEX = ", prefix);
        switch (parsed) {
        case NVC697_SET_OFFSET_RENDER_TARGET_INDEX_BY_VIEWPORT_INDEX_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_OFFSET_RENDER_TARGET_INDEX_BY_VIEWPORT_INDEX_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_FORCE_HEAVYWEIGHT_METHOD_SYNC:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_COVERAGE_TO_COLOR:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_COVERAGE_TO_COLOR_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_COVERAGE_TO_COLOR_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 3) - 1);
        fprintf(fp, "%s.CT_SELECT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_DECOMPRESS_ZETA_SURFACE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.Z_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_DECOMPRESS_ZETA_SURFACE_Z_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_DECOMPRESS_ZETA_SURFACE_Z_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.STENCIL_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_DECOMPRESS_ZETA_SURFACE_STENCIL_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_DECOMPRESS_ZETA_SURFACE_STENCIL_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_SCREEN_STATE_MASK:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZT_SPARSE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZT_SPARSE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ZT_SPARSE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.UNMAPPED_COMPARE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZT_SPARSE_UNMAPPED_COMPARE_ZT_SPARSE_UNMAPPED_0:
            fprintf(fp, "ZT_SPARSE_UNMAPPED_0\n");
            break;
        case NVC697_SET_ZT_SPARSE_UNMAPPED_COMPARE_ZT_SPARSE_FAIL_ALWAYS:
            fprintf(fp, "ZT_SPARSE_FAIL_ALWAYS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.START_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 12) - 1);
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.TOPOLOGY = ", prefix);
        switch (parsed) {
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_LOOP:
            fprintf(fp, "LINE_LOOP\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_STRIP:
            fprintf(fp, "LINE_STRIP\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLES:
            fprintf(fp, "TRIANGLES\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_STRIP:
            fprintf(fp, "TRIANGLE_STRIP\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_FAN:
            fprintf(fp, "TRIANGLE_FAN\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUADS:
            fprintf(fp, "QUADS\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUAD_STRIP:
            fprintf(fp, "QUAD_STRIP\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POLYGON:
            fprintf(fp, "POLYGON\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_PATCH:
            fprintf(fp, "PATCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.START_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 12) - 1);
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.TOPOLOGY = ", prefix);
        switch (parsed) {
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_LOOP:
            fprintf(fp, "LINE_LOOP\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_STRIP:
            fprintf(fp, "LINE_STRIP\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLES:
            fprintf(fp, "TRIANGLES\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_STRIP:
            fprintf(fp, "TRIANGLE_STRIP\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_FAN:
            fprintf(fp, "TRIANGLE_FAN\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUADS:
            fprintf(fp, "QUADS\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUAD_STRIP:
            fprintf(fp, "QUAD_STRIP\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POLYGON:
            fprintf(fp, "POLYGON\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVC697_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_PATCH:
            fprintf(fp, "PATCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_CT_SELECT:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.TARGET_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 4) & ((1u << 3) - 1);
        fprintf(fp, "%s.TARGET0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 7) & ((1u << 3) - 1);
        fprintf(fp, "%s.TARGET1 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 10) & ((1u << 3) - 1);
        fprintf(fp, "%s.TARGET2 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 13) & ((1u << 3) - 1);
        fprintf(fp, "%s.TARGET3 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 3) - 1);
        fprintf(fp, "%s.TARGET4 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 19) & ((1u << 3) - 1);
        fprintf(fp, "%s.TARGET5 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 22) & ((1u << 3) - 1);
        fprintf(fp, "%s.TARGET6 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 25) & ((1u << 3) - 1);
        fprintf(fp, "%s.TARGET7 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_COMPRESSION_THRESHOLD:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.SAMPLES = ", prefix);
        switch (parsed) {
        case NVC697_SET_COMPRESSION_THRESHOLD_SAMPLES__0:
            fprintf(fp, "_0\n");
            break;
        case NVC697_SET_COMPRESSION_THRESHOLD_SAMPLES__1:
            fprintf(fp, "_1\n");
            break;
        case NVC697_SET_COMPRESSION_THRESHOLD_SAMPLES__2:
            fprintf(fp, "_2\n");
            break;
        case NVC697_SET_COMPRESSION_THRESHOLD_SAMPLES__4:
            fprintf(fp, "_4\n");
            break;
        case NVC697_SET_COMPRESSION_THRESHOLD_SAMPLES__8:
            fprintf(fp, "_8\n");
            break;
        case NVC697_SET_COMPRESSION_THRESHOLD_SAMPLES__16:
            fprintf(fp, "_16\n");
            break;
        case NVC697_SET_COMPRESSION_THRESHOLD_SAMPLES__32:
            fprintf(fp, "_32\n");
            break;
        case NVC697_SET_COMPRESSION_THRESHOLD_SAMPLES__64:
            fprintf(fp, "_64\n");
            break;
        case NVC697_SET_COMPRESSION_THRESHOLD_SAMPLES__128:
            fprintf(fp, "_128\n");
            break;
        case NVC697_SET_COMPRESSION_THRESHOLD_SAMPLES__256:
            fprintf(fp, "_256\n");
            break;
        case NVC697_SET_COMPRESSION_THRESHOLD_SAMPLES__512:
            fprintf(fp, "_512\n");
            break;
        case NVC697_SET_COMPRESSION_THRESHOLD_SAMPLES__1024:
            fprintf(fp, "_1024\n");
            break;
        case NVC697_SET_COMPRESSION_THRESHOLD_SAMPLES__2048:
            fprintf(fp, "_2048\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_PIXEL_SHADER_INTERLOCK_CONTROL:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.TILE_COALESCER_MODE = ", prefix);
        switch (parsed) {
        case NVC697_SET_PIXEL_SHADER_INTERLOCK_CONTROL_TILE_COALESCER_MODE_NO_CONFLICT_DETECT:
            fprintf(fp, "NO_CONFLICT_DETECT\n");
            break;
        case NVC697_SET_PIXEL_SHADER_INTERLOCK_CONTROL_TILE_COALESCER_MODE_CONFLICT_DETECT_SAMPLE:
            fprintf(fp, "CONFLICT_DETECT_SAMPLE\n");
            break;
        case NVC697_SET_PIXEL_SHADER_INTERLOCK_CONTROL_TILE_COALESCER_MODE_CONFLICT_DETECT_PIXEL:
            fprintf(fp, "CONFLICT_DETECT_PIXEL\n");
            break;
        case NVC697_SET_PIXEL_SHADER_INTERLOCK_CONTROL_TILE_COALESCER_MODE_CONFLICT_DETECT_VPRS:
            fprintf(fp, "CONFLICT_DETECT_VPRS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.TILE_COALESCER_TILE_SIZE = ", prefix);
        switch (parsed) {
        case NVC697_SET_PIXEL_SHADER_INTERLOCK_CONTROL_TILE_COALESCER_TILE_SIZE_TC_TILE_SIZE_16X16:
            fprintf(fp, "TC_TILE_SIZE_16X16\n");
            break;
        case NVC697_SET_PIXEL_SHADER_INTERLOCK_CONTROL_TILE_COALESCER_TILE_SIZE_TC_TILE_SIZE_8X8:
            fprintf(fp, "TC_TILE_SIZE_8X8\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.TILE_COALESCER_FRAGMENT_ORDER = ", prefix);
        switch (parsed) {
        case NVC697_SET_PIXEL_SHADER_INTERLOCK_CONTROL_TILE_COALESCER_FRAGMENT_ORDER_TC_FRAGMENT_ORDERED:
            fprintf(fp, "TC_FRAGMENT_ORDERED\n");
            break;
        case NVC697_SET_PIXEL_SHADER_INTERLOCK_CONTROL_TILE_COALESCER_FRAGMENT_ORDER_TC_FRAGMENT_UNORDERED:
            fprintf(fp, "TC_FRAGMENT_UNORDERED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ZT_SIZE_A:
    
        parsed = (data >> 0) & ((1u << 28) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZT_SIZE_B:
    
        parsed = (data >> 0) & ((1u << 18) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZT_SIZE_C:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.THIRD_DIMENSION = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONTROL = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZT_SIZE_C_CONTROL_THIRD_DIMENSION_DEFINES_ARRAY_SIZE:
            fprintf(fp, "THIRD_DIMENSION_DEFINES_ARRAY_SIZE\n");
            break;
        case NVC697_SET_ZT_SIZE_C_CONTROL_ARRAY_SIZE_IS_ONE:
            fprintf(fp, "ARRAY_SIZE_IS_ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_SAMPLER_BINDING:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_SAMPLER_BINDING_V_INDEPENDENTLY:
            fprintf(fp, "INDEPENDENTLY\n");
            break;
        case NVC697_SET_SAMPLER_BINDING_V_VIA_HEADER_BINDING:
            fprintf(fp, "VIA_HEADER_BINDING\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_DRAW_AUTO:
    
        parsed = data;
        fprintf(fp, "%s.BYTE_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
        case NVC697_SET_PIXEL_SHADER_TICKET_DISPENSER_VALUE:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.TICKET_DISPENSER_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 16) - 1);
        fprintf(fp, "%s.TICKET_DISPENSER_VALUE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_BACK_END_COPY_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.DWORDS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.SATURATE32_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_BACK_END_COPY_A_SATURATE32_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_BACK_END_COPY_A_SATURATE32_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.TIMESTAMP_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_BACK_END_COPY_A_TIMESTAMP_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_BACK_END_COPY_A_TIMESTAMP_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BACK_END_COPY_B:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.SRC_ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_BACK_END_COPY_C:
    
        parsed = data;
        fprintf(fp, "%s.SRC_ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_BACK_END_COPY_D:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.DEST_ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_BACK_END_COPY_E:
    
        parsed = data;
        fprintf(fp, "%s.DEST_ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_CIRCULAR_BUFFER_SIZE:
    
        parsed = (data >> 0) & ((1u << 20) - 1);
        fprintf(fp, "%s.CACHE_LINES_PER_SM = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_VTG_REGISTER_WATERMARKS:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.LOW = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.HIGH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVC697_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVC697_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS:
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.POLICY = ", prefix);
        switch (parsed) {
        case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS_POLICY_EVICT_FIRST:
            fprintf(fp, "EVICT_FIRST\n");
            break;
        case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS_POLICY_EVICT_NORMAL:
            fprintf(fp, "EVICT_NORMAL\n");
            break;
        case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS_POLICY_EVICT_LAST:
            fprintf(fp, "EVICT_LAST\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_DA_PRIMITIVE_RESTART_INDEX_TOPOLOGY_CHANGE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADING_RATE_INDEX_SURFACE_ADDRESS_A(0):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADING_RATE_INDEX_SURFACE_ADDRESS_B(0):
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADING_RATE_INDEX_SURFACE_SIZE_A(0):
    
        parsed = (data >> 0) & ((1u << 12) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 12) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADING_RATE_INDEX_SURFACE_SIZE_B(0):
    
        parsed = (data >> 0) & ((1u << 12) - 1);
        fprintf(fp, "%s.ARRAY_SIZE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADING_RATE_INDEX_SURFACE_LAYER(0):
    
        parsed = (data >> 0) & ((1u << 12) - 1);
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADING_RATE_INDEX_SURFACE_ARRAY_PITCH(0):
    
        parsed = (data >> 0) & ((1u << 29) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADING_RATE_INDEX_SURFACE_BLOCK_SIZE(0):
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        switch (parsed) {
        case NVC697_SET_SHADING_RATE_INDEX_SURFACE_BLOCK_SIZE_WIDTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        switch (parsed) {
        case NVC697_SET_SHADING_RATE_INDEX_SURFACE_BLOCK_SIZE_HEIGHT_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVC697_SET_SHADING_RATE_INDEX_SURFACE_BLOCK_SIZE_HEIGHT_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVC697_SET_SHADING_RATE_INDEX_SURFACE_BLOCK_SIZE_HEIGHT_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVC697_SET_SHADING_RATE_INDEX_SURFACE_BLOCK_SIZE_HEIGHT_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVC697_SET_SHADING_RATE_INDEX_SURFACE_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVC697_SET_SHADING_RATE_INDEX_SURFACE_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.DEPTH = ", prefix);
        switch (parsed) {
        case NVC697_SET_SHADING_RATE_INDEX_SURFACE_BLOCK_SIZE_DEPTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_SHADING_RATE_INDEX_SURFACE_ALLOCATED_SIZE(0):
    
        parsed = (data >> 0) & ((1u << 12) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_CLEAR_ZCULL_REGION:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.Z_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_CLEAR_ZCULL_REGION_Z_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_CLEAR_ZCULL_REGION_Z_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.STENCIL_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_CLEAR_ZCULL_REGION_STENCIL_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_CLEAR_ZCULL_REGION_STENCIL_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.USE_CLEAR_RECT = ", prefix);
        switch (parsed) {
        case NVC697_CLEAR_ZCULL_REGION_USE_CLEAR_RECT_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_CLEAR_ZCULL_REGION_USE_CLEAR_RECT_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.USE_RT_ARRAY_INDEX = ", prefix);
        switch (parsed) {
        case NVC697_CLEAR_ZCULL_REGION_USE_RT_ARRAY_INDEX_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_CLEAR_ZCULL_REGION_USE_RT_ARRAY_INDEX_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 16) - 1);
        fprintf(fp, "%s.RT_ARRAY_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.MAKE_CONSERVATIVE = ", prefix);
        switch (parsed) {
        case NVC697_CLEAR_ZCULL_REGION_MAKE_CONSERVATIVE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_CLEAR_ZCULL_REGION_MAKE_CONSERVATIVE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_DEPTH_TEST:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_DEPTH_TEST_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_DEPTH_TEST_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_FILL_MODE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_FILL_MODE_V_POINT:
            fprintf(fp, "POINT\n");
            break;
        case NVC697_SET_FILL_MODE_V_WIREFRAME:
            fprintf(fp, "WIREFRAME\n");
            break;
        case NVC697_SET_FILL_MODE_V_SOLID:
            fprintf(fp, "SOLID\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_SHADE_MODE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_SHADE_MODE_V_FLAT:
            fprintf(fp, "FLAT\n");
            break;
        case NVC697_SET_SHADE_MODE_V_GOURAUD:
            fprintf(fp, "GOURAUD\n");
            break;
        case NVC697_SET_SHADE_MODE_V_OGL_FLAT:
            fprintf(fp, "OGL_FLAT\n");
            break;
        case NVC697_SET_SHADE_MODE_V_OGL_SMOOTH:
            fprintf(fp, "OGL_SMOOTH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS:
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.POLICY = ", prefix);
        switch (parsed) {
        case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_FIRST:
            fprintf(fp, "EVICT_FIRST\n");
            break;
        case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_NORMAL:
            fprintf(fp, "EVICT_NORMAL\n");
            break;
        case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_LAST:
            fprintf(fp, "EVICT_LAST\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS:
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.POLICY = ", prefix);
        switch (parsed) {
        case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_FIRST:
            fprintf(fp, "EVICT_FIRST\n");
            break;
        case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_NORMAL:
            fprintf(fp, "EVICT_NORMAL\n");
            break;
        case NVC697_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_LAST:
            fprintf(fp, "EVICT_LAST\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.DITHER_FOOTPRINT = ", prefix);
        switch (parsed) {
        case NVC697_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL_DITHER_FOOTPRINT_PIXELS_1X1:
            fprintf(fp, "PIXELS_1X1\n");
            break;
        case NVC697_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL_DITHER_FOOTPRINT_PIXELS_2X2:
            fprintf(fp, "PIXELS_2X2\n");
            break;
        case NVC697_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL_DITHER_FOOTPRINT_PIXELS_1X1_VIRTUAL_SAMPLES:
            fprintf(fp, "PIXELS_1X1_VIRTUAL_SAMPLES\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BLEND_STATE_PER_TARGET:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_BLEND_STATE_PER_TARGET_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_BLEND_STATE_PER_TARGET_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_DEPTH_WRITE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_DEPTH_WRITE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_DEPTH_WRITE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ALPHA_TEST:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ALPHA_TEST_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ALPHA_TEST_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_INLINE_INDEX4X8_ALIGN:
    
        parsed = (data >> 0) & ((1u << 30) - 1);
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 30) & ((1u << 2) - 1);
        fprintf(fp, "%s.START = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_DRAW_INLINE_INDEX4X8:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.INDEX0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 8) - 1);
        fprintf(fp, "%s.INDEX1 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 8) - 1);
        fprintf(fp, "%s.INDEX2 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 24) & ((1u << 8) - 1);
        fprintf(fp, "%s.INDEX3 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_D3D_SET_CULL_MODE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_D3D_SET_CULL_MODE_V_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVC697_D3D_SET_CULL_MODE_V_CW:
            fprintf(fp, "CW\n");
            break;
        case NVC697_D3D_SET_CULL_MODE_V_CCW:
            fprintf(fp, "CCW\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_DEPTH_FUNC:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_DEPTH_FUNC_V_OGL_NEVER:
            fprintf(fp, "OGL_NEVER\n");
            break;
        case NVC697_SET_DEPTH_FUNC_V_OGL_LESS:
            fprintf(fp, "OGL_LESS\n");
            break;
        case NVC697_SET_DEPTH_FUNC_V_OGL_EQUAL:
            fprintf(fp, "OGL_EQUAL\n");
            break;
        case NVC697_SET_DEPTH_FUNC_V_OGL_LEQUAL:
            fprintf(fp, "OGL_LEQUAL\n");
            break;
        case NVC697_SET_DEPTH_FUNC_V_OGL_GREATER:
            fprintf(fp, "OGL_GREATER\n");
            break;
        case NVC697_SET_DEPTH_FUNC_V_OGL_NOTEQUAL:
            fprintf(fp, "OGL_NOTEQUAL\n");
            break;
        case NVC697_SET_DEPTH_FUNC_V_OGL_GEQUAL:
            fprintf(fp, "OGL_GEQUAL\n");
            break;
        case NVC697_SET_DEPTH_FUNC_V_OGL_ALWAYS:
            fprintf(fp, "OGL_ALWAYS\n");
            break;
        case NVC697_SET_DEPTH_FUNC_V_D3D_NEVER:
            fprintf(fp, "D3D_NEVER\n");
            break;
        case NVC697_SET_DEPTH_FUNC_V_D3D_LESS:
            fprintf(fp, "D3D_LESS\n");
            break;
        case NVC697_SET_DEPTH_FUNC_V_D3D_EQUAL:
            fprintf(fp, "D3D_EQUAL\n");
            break;
        case NVC697_SET_DEPTH_FUNC_V_D3D_LESSEQUAL:
            fprintf(fp, "D3D_LESSEQUAL\n");
            break;
        case NVC697_SET_DEPTH_FUNC_V_D3D_GREATER:
            fprintf(fp, "D3D_GREATER\n");
            break;
        case NVC697_SET_DEPTH_FUNC_V_D3D_NOTEQUAL:
            fprintf(fp, "D3D_NOTEQUAL\n");
            break;
        case NVC697_SET_DEPTH_FUNC_V_D3D_GREATEREQUAL:
            fprintf(fp, "D3D_GREATEREQUAL\n");
            break;
        case NVC697_SET_DEPTH_FUNC_V_D3D_ALWAYS:
            fprintf(fp, "D3D_ALWAYS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ALPHA_REF:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ALPHA_FUNC:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_ALPHA_FUNC_V_OGL_NEVER:
            fprintf(fp, "OGL_NEVER\n");
            break;
        case NVC697_SET_ALPHA_FUNC_V_OGL_LESS:
            fprintf(fp, "OGL_LESS\n");
            break;
        case NVC697_SET_ALPHA_FUNC_V_OGL_EQUAL:
            fprintf(fp, "OGL_EQUAL\n");
            break;
        case NVC697_SET_ALPHA_FUNC_V_OGL_LEQUAL:
            fprintf(fp, "OGL_LEQUAL\n");
            break;
        case NVC697_SET_ALPHA_FUNC_V_OGL_GREATER:
            fprintf(fp, "OGL_GREATER\n");
            break;
        case NVC697_SET_ALPHA_FUNC_V_OGL_NOTEQUAL:
            fprintf(fp, "OGL_NOTEQUAL\n");
            break;
        case NVC697_SET_ALPHA_FUNC_V_OGL_GEQUAL:
            fprintf(fp, "OGL_GEQUAL\n");
            break;
        case NVC697_SET_ALPHA_FUNC_V_OGL_ALWAYS:
            fprintf(fp, "OGL_ALWAYS\n");
            break;
        case NVC697_SET_ALPHA_FUNC_V_D3D_NEVER:
            fprintf(fp, "D3D_NEVER\n");
            break;
        case NVC697_SET_ALPHA_FUNC_V_D3D_LESS:
            fprintf(fp, "D3D_LESS\n");
            break;
        case NVC697_SET_ALPHA_FUNC_V_D3D_EQUAL:
            fprintf(fp, "D3D_EQUAL\n");
            break;
        case NVC697_SET_ALPHA_FUNC_V_D3D_LESSEQUAL:
            fprintf(fp, "D3D_LESSEQUAL\n");
            break;
        case NVC697_SET_ALPHA_FUNC_V_D3D_GREATER:
            fprintf(fp, "D3D_GREATER\n");
            break;
        case NVC697_SET_ALPHA_FUNC_V_D3D_NOTEQUAL:
            fprintf(fp, "D3D_NOTEQUAL\n");
            break;
        case NVC697_SET_ALPHA_FUNC_V_D3D_GREATEREQUAL:
            fprintf(fp, "D3D_GREATEREQUAL\n");
            break;
        case NVC697_SET_ALPHA_FUNC_V_D3D_ALWAYS:
            fprintf(fp, "D3D_ALWAYS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_DRAW_AUTO_STRIDE:
    
        parsed = (data >> 0) & ((1u << 12) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_BLEND_CONST_RED:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVC697_SET_BLEND_CONST_GREEN:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVC697_SET_BLEND_CONST_BLUE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVC697_SET_BLEND_CONST_ALPHA:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVC697_INVALIDATE_SAMPLER_CACHE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVC697_INVALIDATE_SAMPLER_CACHE_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVC697_INVALIDATE_SAMPLER_CACHE_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_INVALIDATE_TEXTURE_HEADER_CACHE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVC697_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVC697_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_INVALIDATE_TEXTURE_DATA_CACHE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVC697_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVC697_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_BLEND_SEPARATE_FOR_ALPHA:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_BLEND_SEPARATE_FOR_ALPHA_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_BLEND_SEPARATE_FOR_ALPHA_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BLEND_COLOR_OP:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_BLEND_COLOR_OP_V_OGL_FUNC_SUBTRACT:
            fprintf(fp, "OGL_FUNC_SUBTRACT\n");
            break;
        case NVC697_SET_BLEND_COLOR_OP_V_OGL_FUNC_REVERSE_SUBTRACT:
            fprintf(fp, "OGL_FUNC_REVERSE_SUBTRACT\n");
            break;
        case NVC697_SET_BLEND_COLOR_OP_V_OGL_FUNC_ADD:
            fprintf(fp, "OGL_FUNC_ADD\n");
            break;
        case NVC697_SET_BLEND_COLOR_OP_V_OGL_MIN:
            fprintf(fp, "OGL_MIN\n");
            break;
        case NVC697_SET_BLEND_COLOR_OP_V_OGL_MAX:
            fprintf(fp, "OGL_MAX\n");
            break;
        case NVC697_SET_BLEND_COLOR_OP_V_D3D_ADD:
            fprintf(fp, "D3D_ADD\n");
            break;
        case NVC697_SET_BLEND_COLOR_OP_V_D3D_SUBTRACT:
            fprintf(fp, "D3D_SUBTRACT\n");
            break;
        case NVC697_SET_BLEND_COLOR_OP_V_D3D_REVSUBTRACT:
            fprintf(fp, "D3D_REVSUBTRACT\n");
            break;
        case NVC697_SET_BLEND_COLOR_OP_V_D3D_MIN:
            fprintf(fp, "D3D_MIN\n");
            break;
        case NVC697_SET_BLEND_COLOR_OP_V_D3D_MAX:
            fprintf(fp, "D3D_MAX\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BLEND_COLOR_SOURCE_COEFF:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE:
            fprintf(fp, "OGL_ONE\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC_COLOR:
            fprintf(fp, "OGL_SRC_COLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_SRC_COLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC_ALPHA:
            fprintf(fp, "OGL_SRC_ALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_SRC_ALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_DST_ALPHA:
            fprintf(fp, "OGL_DST_ALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_DST_ALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_DST_COLOR:
            fprintf(fp, "OGL_DST_COLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_DST_COLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC_ALPHA_SATURATE:
            fprintf(fp, "OGL_SRC_ALPHA_SATURATE\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_CONSTANT_COLOR:
            fprintf(fp, "OGL_CONSTANT_COLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_COLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_CONSTANT_ALPHA:
            fprintf(fp, "OGL_CONSTANT_ALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_ALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC1COLOR:
            fprintf(fp, "OGL_SRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_INVSRC1COLOR:
            fprintf(fp, "OGL_INVSRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC1ALPHA:
            fprintf(fp, "OGL_SRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_INVSRC1ALPHA:
            fprintf(fp, "OGL_INVSRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_ONE:
            fprintf(fp, "D3D_ONE\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRCCOLOR:
            fprintf(fp, "D3D_SRCCOLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVSRCCOLOR:
            fprintf(fp, "D3D_INVSRCCOLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRCALPHA:
            fprintf(fp, "D3D_SRCALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVSRCALPHA:
            fprintf(fp, "D3D_INVSRCALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_DESTALPHA:
            fprintf(fp, "D3D_DESTALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVDESTALPHA:
            fprintf(fp, "D3D_INVDESTALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_DESTCOLOR:
            fprintf(fp, "D3D_DESTCOLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVDESTCOLOR:
            fprintf(fp, "D3D_INVDESTCOLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRCALPHASAT:
            fprintf(fp, "D3D_SRCALPHASAT\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_BOTHSRCALPHA:
            fprintf(fp, "D3D_BOTHSRCALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_BOTHINVSRCALPHA:
            fprintf(fp, "D3D_BOTHINVSRCALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_BLENDFACTOR:
            fprintf(fp, "D3D_BLENDFACTOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVBLENDFACTOR:
            fprintf(fp, "D3D_INVBLENDFACTOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRC1COLOR:
            fprintf(fp, "D3D_SRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVSRC1COLOR:
            fprintf(fp, "D3D_INVSRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRC1ALPHA:
            fprintf(fp, "D3D_SRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVSRC1ALPHA:
            fprintf(fp, "D3D_INVSRC1ALPHA\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BLEND_COLOR_DEST_COEFF:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE:
            fprintf(fp, "OGL_ONE\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC_COLOR:
            fprintf(fp, "OGL_SRC_COLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_SRC_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_SRC_COLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC_ALPHA:
            fprintf(fp, "OGL_SRC_ALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_SRC_ALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_OGL_DST_ALPHA:
            fprintf(fp, "OGL_DST_ALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_DST_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_DST_ALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_OGL_DST_COLOR:
            fprintf(fp, "OGL_DST_COLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_DST_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_DST_COLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC_ALPHA_SATURATE:
            fprintf(fp, "OGL_SRC_ALPHA_SATURATE\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_OGL_CONSTANT_COLOR:
            fprintf(fp, "OGL_CONSTANT_COLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_COLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_OGL_CONSTANT_ALPHA:
            fprintf(fp, "OGL_CONSTANT_ALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_ALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC1COLOR:
            fprintf(fp, "OGL_SRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_OGL_INVSRC1COLOR:
            fprintf(fp, "OGL_INVSRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC1ALPHA:
            fprintf(fp, "OGL_SRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_OGL_INVSRC1ALPHA:
            fprintf(fp, "OGL_INVSRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_D3D_ONE:
            fprintf(fp, "D3D_ONE\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRCCOLOR:
            fprintf(fp, "D3D_SRCCOLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVSRCCOLOR:
            fprintf(fp, "D3D_INVSRCCOLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRCALPHA:
            fprintf(fp, "D3D_SRCALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVSRCALPHA:
            fprintf(fp, "D3D_INVSRCALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_D3D_DESTALPHA:
            fprintf(fp, "D3D_DESTALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVDESTALPHA:
            fprintf(fp, "D3D_INVDESTALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_D3D_DESTCOLOR:
            fprintf(fp, "D3D_DESTCOLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVDESTCOLOR:
            fprintf(fp, "D3D_INVDESTCOLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRCALPHASAT:
            fprintf(fp, "D3D_SRCALPHASAT\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_D3D_BLENDFACTOR:
            fprintf(fp, "D3D_BLENDFACTOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVBLENDFACTOR:
            fprintf(fp, "D3D_INVBLENDFACTOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRC1COLOR:
            fprintf(fp, "D3D_SRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVSRC1COLOR:
            fprintf(fp, "D3D_INVSRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRC1ALPHA:
            fprintf(fp, "D3D_SRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVSRC1ALPHA:
            fprintf(fp, "D3D_INVSRC1ALPHA\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BLEND_ALPHA_OP:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_BLEND_ALPHA_OP_V_OGL_FUNC_SUBTRACT:
            fprintf(fp, "OGL_FUNC_SUBTRACT\n");
            break;
        case NVC697_SET_BLEND_ALPHA_OP_V_OGL_FUNC_REVERSE_SUBTRACT:
            fprintf(fp, "OGL_FUNC_REVERSE_SUBTRACT\n");
            break;
        case NVC697_SET_BLEND_ALPHA_OP_V_OGL_FUNC_ADD:
            fprintf(fp, "OGL_FUNC_ADD\n");
            break;
        case NVC697_SET_BLEND_ALPHA_OP_V_OGL_MIN:
            fprintf(fp, "OGL_MIN\n");
            break;
        case NVC697_SET_BLEND_ALPHA_OP_V_OGL_MAX:
            fprintf(fp, "OGL_MAX\n");
            break;
        case NVC697_SET_BLEND_ALPHA_OP_V_D3D_ADD:
            fprintf(fp, "D3D_ADD\n");
            break;
        case NVC697_SET_BLEND_ALPHA_OP_V_D3D_SUBTRACT:
            fprintf(fp, "D3D_SUBTRACT\n");
            break;
        case NVC697_SET_BLEND_ALPHA_OP_V_D3D_REVSUBTRACT:
            fprintf(fp, "D3D_REVSUBTRACT\n");
            break;
        case NVC697_SET_BLEND_ALPHA_OP_V_D3D_MIN:
            fprintf(fp, "D3D_MIN\n");
            break;
        case NVC697_SET_BLEND_ALPHA_OP_V_D3D_MAX:
            fprintf(fp, "D3D_MAX\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE:
            fprintf(fp, "OGL_ONE\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC_COLOR:
            fprintf(fp, "OGL_SRC_COLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_SRC_COLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC_ALPHA:
            fprintf(fp, "OGL_SRC_ALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_SRC_ALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_DST_ALPHA:
            fprintf(fp, "OGL_DST_ALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_DST_ALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_DST_COLOR:
            fprintf(fp, "OGL_DST_COLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_DST_COLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC_ALPHA_SATURATE:
            fprintf(fp, "OGL_SRC_ALPHA_SATURATE\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_CONSTANT_COLOR:
            fprintf(fp, "OGL_CONSTANT_COLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_COLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_CONSTANT_ALPHA:
            fprintf(fp, "OGL_CONSTANT_ALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_ALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC1COLOR:
            fprintf(fp, "OGL_SRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_INVSRC1COLOR:
            fprintf(fp, "OGL_INVSRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC1ALPHA:
            fprintf(fp, "OGL_SRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_INVSRC1ALPHA:
            fprintf(fp, "OGL_INVSRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_ONE:
            fprintf(fp, "D3D_ONE\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRCCOLOR:
            fprintf(fp, "D3D_SRCCOLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVSRCCOLOR:
            fprintf(fp, "D3D_INVSRCCOLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRCALPHA:
            fprintf(fp, "D3D_SRCALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVSRCALPHA:
            fprintf(fp, "D3D_INVSRCALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_DESTALPHA:
            fprintf(fp, "D3D_DESTALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVDESTALPHA:
            fprintf(fp, "D3D_INVDESTALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_DESTCOLOR:
            fprintf(fp, "D3D_DESTCOLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVDESTCOLOR:
            fprintf(fp, "D3D_INVDESTCOLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRCALPHASAT:
            fprintf(fp, "D3D_SRCALPHASAT\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_BOTHSRCALPHA:
            fprintf(fp, "D3D_BOTHSRCALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_BOTHINVSRCALPHA:
            fprintf(fp, "D3D_BOTHINVSRCALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_BLENDFACTOR:
            fprintf(fp, "D3D_BLENDFACTOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVBLENDFACTOR:
            fprintf(fp, "D3D_INVBLENDFACTOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRC1COLOR:
            fprintf(fp, "D3D_SRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVSRC1COLOR:
            fprintf(fp, "D3D_INVSRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRC1ALPHA:
            fprintf(fp, "D3D_SRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVSRC1ALPHA:
            fprintf(fp, "D3D_INVSRC1ALPHA\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_GLOBAL_COLOR_KEY:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_GLOBAL_COLOR_KEY_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_GLOBAL_COLOR_KEY_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BLEND_ALPHA_DEST_COEFF:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE:
            fprintf(fp, "OGL_ONE\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC_COLOR:
            fprintf(fp, "OGL_SRC_COLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_SRC_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_SRC_COLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC_ALPHA:
            fprintf(fp, "OGL_SRC_ALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_SRC_ALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_DST_ALPHA:
            fprintf(fp, "OGL_DST_ALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_DST_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_DST_ALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_DST_COLOR:
            fprintf(fp, "OGL_DST_COLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_DST_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_DST_COLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC_ALPHA_SATURATE:
            fprintf(fp, "OGL_SRC_ALPHA_SATURATE\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_CONSTANT_COLOR:
            fprintf(fp, "OGL_CONSTANT_COLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_COLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_CONSTANT_ALPHA:
            fprintf(fp, "OGL_CONSTANT_ALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_ALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC1COLOR:
            fprintf(fp, "OGL_SRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_INVSRC1COLOR:
            fprintf(fp, "OGL_INVSRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC1ALPHA:
            fprintf(fp, "OGL_SRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_INVSRC1ALPHA:
            fprintf(fp, "OGL_INVSRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_ONE:
            fprintf(fp, "D3D_ONE\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRCCOLOR:
            fprintf(fp, "D3D_SRCCOLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVSRCCOLOR:
            fprintf(fp, "D3D_INVSRCCOLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRCALPHA:
            fprintf(fp, "D3D_SRCALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVSRCALPHA:
            fprintf(fp, "D3D_INVSRCALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_DESTALPHA:
            fprintf(fp, "D3D_DESTALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVDESTALPHA:
            fprintf(fp, "D3D_INVDESTALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_DESTCOLOR:
            fprintf(fp, "D3D_DESTCOLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVDESTCOLOR:
            fprintf(fp, "D3D_INVDESTCOLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRCALPHASAT:
            fprintf(fp, "D3D_SRCALPHASAT\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_BLENDFACTOR:
            fprintf(fp, "D3D_BLENDFACTOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVBLENDFACTOR:
            fprintf(fp, "D3D_INVBLENDFACTOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRC1COLOR:
            fprintf(fp, "D3D_SRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVSRC1COLOR:
            fprintf(fp, "D3D_INVSRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRC1ALPHA:
            fprintf(fp, "D3D_SRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVSRC1ALPHA:
            fprintf(fp, "D3D_INVSRC1ALPHA\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_SINGLE_ROP_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_SINGLE_ROP_CONTROL_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_SINGLE_ROP_CONTROL_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BLEND(0):
    case NVC697_SET_BLEND(1):
    case NVC697_SET_BLEND(2):
    case NVC697_SET_BLEND(3):
    case NVC697_SET_BLEND(4):
    case NVC697_SET_BLEND(5):
    case NVC697_SET_BLEND(6):
    case NVC697_SET_BLEND(7):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_BLEND_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_BLEND_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_STENCIL_TEST:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_STENCIL_TEST_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_STENCIL_TEST_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_STENCIL_OP_FAIL:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_STENCIL_OP_FAIL_V_OGL_KEEP:
            fprintf(fp, "OGL_KEEP\n");
            break;
        case NVC697_SET_STENCIL_OP_FAIL_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVC697_SET_STENCIL_OP_FAIL_V_OGL_REPLACE:
            fprintf(fp, "OGL_REPLACE\n");
            break;
        case NVC697_SET_STENCIL_OP_FAIL_V_OGL_INCRSAT:
            fprintf(fp, "OGL_INCRSAT\n");
            break;
        case NVC697_SET_STENCIL_OP_FAIL_V_OGL_DECRSAT:
            fprintf(fp, "OGL_DECRSAT\n");
            break;
        case NVC697_SET_STENCIL_OP_FAIL_V_OGL_INVERT:
            fprintf(fp, "OGL_INVERT\n");
            break;
        case NVC697_SET_STENCIL_OP_FAIL_V_OGL_INCR:
            fprintf(fp, "OGL_INCR\n");
            break;
        case NVC697_SET_STENCIL_OP_FAIL_V_OGL_DECR:
            fprintf(fp, "OGL_DECR\n");
            break;
        case NVC697_SET_STENCIL_OP_FAIL_V_D3D_KEEP:
            fprintf(fp, "D3D_KEEP\n");
            break;
        case NVC697_SET_STENCIL_OP_FAIL_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVC697_SET_STENCIL_OP_FAIL_V_D3D_REPLACE:
            fprintf(fp, "D3D_REPLACE\n");
            break;
        case NVC697_SET_STENCIL_OP_FAIL_V_D3D_INCRSAT:
            fprintf(fp, "D3D_INCRSAT\n");
            break;
        case NVC697_SET_STENCIL_OP_FAIL_V_D3D_DECRSAT:
            fprintf(fp, "D3D_DECRSAT\n");
            break;
        case NVC697_SET_STENCIL_OP_FAIL_V_D3D_INVERT:
            fprintf(fp, "D3D_INVERT\n");
            break;
        case NVC697_SET_STENCIL_OP_FAIL_V_D3D_INCR:
            fprintf(fp, "D3D_INCR\n");
            break;
        case NVC697_SET_STENCIL_OP_FAIL_V_D3D_DECR:
            fprintf(fp, "D3D_DECR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_STENCIL_OP_ZFAIL:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_STENCIL_OP_ZFAIL_V_OGL_KEEP:
            fprintf(fp, "OGL_KEEP\n");
            break;
        case NVC697_SET_STENCIL_OP_ZFAIL_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVC697_SET_STENCIL_OP_ZFAIL_V_OGL_REPLACE:
            fprintf(fp, "OGL_REPLACE\n");
            break;
        case NVC697_SET_STENCIL_OP_ZFAIL_V_OGL_INCRSAT:
            fprintf(fp, "OGL_INCRSAT\n");
            break;
        case NVC697_SET_STENCIL_OP_ZFAIL_V_OGL_DECRSAT:
            fprintf(fp, "OGL_DECRSAT\n");
            break;
        case NVC697_SET_STENCIL_OP_ZFAIL_V_OGL_INVERT:
            fprintf(fp, "OGL_INVERT\n");
            break;
        case NVC697_SET_STENCIL_OP_ZFAIL_V_OGL_INCR:
            fprintf(fp, "OGL_INCR\n");
            break;
        case NVC697_SET_STENCIL_OP_ZFAIL_V_OGL_DECR:
            fprintf(fp, "OGL_DECR\n");
            break;
        case NVC697_SET_STENCIL_OP_ZFAIL_V_D3D_KEEP:
            fprintf(fp, "D3D_KEEP\n");
            break;
        case NVC697_SET_STENCIL_OP_ZFAIL_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVC697_SET_STENCIL_OP_ZFAIL_V_D3D_REPLACE:
            fprintf(fp, "D3D_REPLACE\n");
            break;
        case NVC697_SET_STENCIL_OP_ZFAIL_V_D3D_INCRSAT:
            fprintf(fp, "D3D_INCRSAT\n");
            break;
        case NVC697_SET_STENCIL_OP_ZFAIL_V_D3D_DECRSAT:
            fprintf(fp, "D3D_DECRSAT\n");
            break;
        case NVC697_SET_STENCIL_OP_ZFAIL_V_D3D_INVERT:
            fprintf(fp, "D3D_INVERT\n");
            break;
        case NVC697_SET_STENCIL_OP_ZFAIL_V_D3D_INCR:
            fprintf(fp, "D3D_INCR\n");
            break;
        case NVC697_SET_STENCIL_OP_ZFAIL_V_D3D_DECR:
            fprintf(fp, "D3D_DECR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_STENCIL_OP_ZPASS:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_STENCIL_OP_ZPASS_V_OGL_KEEP:
            fprintf(fp, "OGL_KEEP\n");
            break;
        case NVC697_SET_STENCIL_OP_ZPASS_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVC697_SET_STENCIL_OP_ZPASS_V_OGL_REPLACE:
            fprintf(fp, "OGL_REPLACE\n");
            break;
        case NVC697_SET_STENCIL_OP_ZPASS_V_OGL_INCRSAT:
            fprintf(fp, "OGL_INCRSAT\n");
            break;
        case NVC697_SET_STENCIL_OP_ZPASS_V_OGL_DECRSAT:
            fprintf(fp, "OGL_DECRSAT\n");
            break;
        case NVC697_SET_STENCIL_OP_ZPASS_V_OGL_INVERT:
            fprintf(fp, "OGL_INVERT\n");
            break;
        case NVC697_SET_STENCIL_OP_ZPASS_V_OGL_INCR:
            fprintf(fp, "OGL_INCR\n");
            break;
        case NVC697_SET_STENCIL_OP_ZPASS_V_OGL_DECR:
            fprintf(fp, "OGL_DECR\n");
            break;
        case NVC697_SET_STENCIL_OP_ZPASS_V_D3D_KEEP:
            fprintf(fp, "D3D_KEEP\n");
            break;
        case NVC697_SET_STENCIL_OP_ZPASS_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVC697_SET_STENCIL_OP_ZPASS_V_D3D_REPLACE:
            fprintf(fp, "D3D_REPLACE\n");
            break;
        case NVC697_SET_STENCIL_OP_ZPASS_V_D3D_INCRSAT:
            fprintf(fp, "D3D_INCRSAT\n");
            break;
        case NVC697_SET_STENCIL_OP_ZPASS_V_D3D_DECRSAT:
            fprintf(fp, "D3D_DECRSAT\n");
            break;
        case NVC697_SET_STENCIL_OP_ZPASS_V_D3D_INVERT:
            fprintf(fp, "D3D_INVERT\n");
            break;
        case NVC697_SET_STENCIL_OP_ZPASS_V_D3D_INCR:
            fprintf(fp, "D3D_INCR\n");
            break;
        case NVC697_SET_STENCIL_OP_ZPASS_V_D3D_DECR:
            fprintf(fp, "D3D_DECR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_STENCIL_FUNC:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_STENCIL_FUNC_V_OGL_NEVER:
            fprintf(fp, "OGL_NEVER\n");
            break;
        case NVC697_SET_STENCIL_FUNC_V_OGL_LESS:
            fprintf(fp, "OGL_LESS\n");
            break;
        case NVC697_SET_STENCIL_FUNC_V_OGL_EQUAL:
            fprintf(fp, "OGL_EQUAL\n");
            break;
        case NVC697_SET_STENCIL_FUNC_V_OGL_LEQUAL:
            fprintf(fp, "OGL_LEQUAL\n");
            break;
        case NVC697_SET_STENCIL_FUNC_V_OGL_GREATER:
            fprintf(fp, "OGL_GREATER\n");
            break;
        case NVC697_SET_STENCIL_FUNC_V_OGL_NOTEQUAL:
            fprintf(fp, "OGL_NOTEQUAL\n");
            break;
        case NVC697_SET_STENCIL_FUNC_V_OGL_GEQUAL:
            fprintf(fp, "OGL_GEQUAL\n");
            break;
        case NVC697_SET_STENCIL_FUNC_V_OGL_ALWAYS:
            fprintf(fp, "OGL_ALWAYS\n");
            break;
        case NVC697_SET_STENCIL_FUNC_V_D3D_NEVER:
            fprintf(fp, "D3D_NEVER\n");
            break;
        case NVC697_SET_STENCIL_FUNC_V_D3D_LESS:
            fprintf(fp, "D3D_LESS\n");
            break;
        case NVC697_SET_STENCIL_FUNC_V_D3D_EQUAL:
            fprintf(fp, "D3D_EQUAL\n");
            break;
        case NVC697_SET_STENCIL_FUNC_V_D3D_LESSEQUAL:
            fprintf(fp, "D3D_LESSEQUAL\n");
            break;
        case NVC697_SET_STENCIL_FUNC_V_D3D_GREATER:
            fprintf(fp, "D3D_GREATER\n");
            break;
        case NVC697_SET_STENCIL_FUNC_V_D3D_NOTEQUAL:
            fprintf(fp, "D3D_NOTEQUAL\n");
            break;
        case NVC697_SET_STENCIL_FUNC_V_D3D_GREATEREQUAL:
            fprintf(fp, "D3D_GREATEREQUAL\n");
            break;
        case NVC697_SET_STENCIL_FUNC_V_D3D_ALWAYS:
            fprintf(fp, "D3D_ALWAYS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_STENCIL_FUNC_REF:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_STENCIL_FUNC_MASK:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_STENCIL_MASK:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_DRAW_AUTO_START:
    
        parsed = data;
        fprintf(fp, "%s.BYTE_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_PS_SATURATE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.OUTPUT0 = ", prefix);
        switch (parsed) {
        case NVC697_SET_PS_SATURATE_OUTPUT0_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_PS_SATURATE_OUTPUT0_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLAMP_RANGE0 = ", prefix);
        switch (parsed) {
        case NVC697_SET_PS_SATURATE_CLAMP_RANGE0_ZERO_TO_PLUS_ONE:
            fprintf(fp, "ZERO_TO_PLUS_ONE\n");
            break;
        case NVC697_SET_PS_SATURATE_CLAMP_RANGE0_MINUS_ONE_TO_PLUS_ONE:
            fprintf(fp, "MINUS_ONE_TO_PLUS_ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.OUTPUT1 = ", prefix);
        switch (parsed) {
        case NVC697_SET_PS_SATURATE_OUTPUT1_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_PS_SATURATE_OUTPUT1_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLAMP_RANGE1 = ", prefix);
        switch (parsed) {
        case NVC697_SET_PS_SATURATE_CLAMP_RANGE1_ZERO_TO_PLUS_ONE:
            fprintf(fp, "ZERO_TO_PLUS_ONE\n");
            break;
        case NVC697_SET_PS_SATURATE_CLAMP_RANGE1_MINUS_ONE_TO_PLUS_ONE:
            fprintf(fp, "MINUS_ONE_TO_PLUS_ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.OUTPUT2 = ", prefix);
        switch (parsed) {
        case NVC697_SET_PS_SATURATE_OUTPUT2_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_PS_SATURATE_OUTPUT2_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLAMP_RANGE2 = ", prefix);
        switch (parsed) {
        case NVC697_SET_PS_SATURATE_CLAMP_RANGE2_ZERO_TO_PLUS_ONE:
            fprintf(fp, "ZERO_TO_PLUS_ONE\n");
            break;
        case NVC697_SET_PS_SATURATE_CLAMP_RANGE2_MINUS_ONE_TO_PLUS_ONE:
            fprintf(fp, "MINUS_ONE_TO_PLUS_ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.OUTPUT3 = ", prefix);
        switch (parsed) {
        case NVC697_SET_PS_SATURATE_OUTPUT3_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_PS_SATURATE_OUTPUT3_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 13) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLAMP_RANGE3 = ", prefix);
        switch (parsed) {
        case NVC697_SET_PS_SATURATE_CLAMP_RANGE3_ZERO_TO_PLUS_ONE:
            fprintf(fp, "ZERO_TO_PLUS_ONE\n");
            break;
        case NVC697_SET_PS_SATURATE_CLAMP_RANGE3_MINUS_ONE_TO_PLUS_ONE:
            fprintf(fp, "MINUS_ONE_TO_PLUS_ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.OUTPUT4 = ", prefix);
        switch (parsed) {
        case NVC697_SET_PS_SATURATE_OUTPUT4_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_PS_SATURATE_OUTPUT4_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 17) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLAMP_RANGE4 = ", prefix);
        switch (parsed) {
        case NVC697_SET_PS_SATURATE_CLAMP_RANGE4_ZERO_TO_PLUS_ONE:
            fprintf(fp, "ZERO_TO_PLUS_ONE\n");
            break;
        case NVC697_SET_PS_SATURATE_CLAMP_RANGE4_MINUS_ONE_TO_PLUS_ONE:
            fprintf(fp, "MINUS_ONE_TO_PLUS_ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.OUTPUT5 = ", prefix);
        switch (parsed) {
        case NVC697_SET_PS_SATURATE_OUTPUT5_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_PS_SATURATE_OUTPUT5_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 21) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLAMP_RANGE5 = ", prefix);
        switch (parsed) {
        case NVC697_SET_PS_SATURATE_CLAMP_RANGE5_ZERO_TO_PLUS_ONE:
            fprintf(fp, "ZERO_TO_PLUS_ONE\n");
            break;
        case NVC697_SET_PS_SATURATE_CLAMP_RANGE5_MINUS_ONE_TO_PLUS_ONE:
            fprintf(fp, "MINUS_ONE_TO_PLUS_ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.OUTPUT6 = ", prefix);
        switch (parsed) {
        case NVC697_SET_PS_SATURATE_OUTPUT6_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_PS_SATURATE_OUTPUT6_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 25) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLAMP_RANGE6 = ", prefix);
        switch (parsed) {
        case NVC697_SET_PS_SATURATE_CLAMP_RANGE6_ZERO_TO_PLUS_ONE:
            fprintf(fp, "ZERO_TO_PLUS_ONE\n");
            break;
        case NVC697_SET_PS_SATURATE_CLAMP_RANGE6_MINUS_ONE_TO_PLUS_ONE:
            fprintf(fp, "MINUS_ONE_TO_PLUS_ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 28) & ((1u << 1) - 1);
        fprintf(fp, "%s.OUTPUT7 = ", prefix);
        switch (parsed) {
        case NVC697_SET_PS_SATURATE_OUTPUT7_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_PS_SATURATE_OUTPUT7_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 29) & ((1u << 1) - 1);
        fprintf(fp, "%s.CLAMP_RANGE7 = ", prefix);
        switch (parsed) {
        case NVC697_SET_PS_SATURATE_CLAMP_RANGE7_ZERO_TO_PLUS_ONE:
            fprintf(fp, "ZERO_TO_PLUS_ONE\n");
            break;
        case NVC697_SET_PS_SATURATE_CLAMP_RANGE7_MINUS_ONE_TO_PLUS_ONE:
            fprintf(fp, "MINUS_ONE_TO_PLUS_ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_WINDOW_ORIGIN:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVC697_SET_WINDOW_ORIGIN_MODE_UPPER_LEFT:
            fprintf(fp, "UPPER_LEFT\n");
            break;
        case NVC697_SET_WINDOW_ORIGIN_MODE_LOWER_LEFT:
            fprintf(fp, "LOWER_LEFT\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLIP_Y = ", prefix);
        switch (parsed) {
        case NVC697_SET_WINDOW_ORIGIN_FLIP_Y_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_WINDOW_ORIGIN_FLIP_Y_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_LINE_WIDTH_FLOAT:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVC697_SET_ALIASED_LINE_WIDTH_FLOAT:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVC697_SET_LINE_MULTISAMPLE_OVERRIDE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_LINE_MULTISAMPLE_OVERRIDE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_LINE_MULTISAMPLE_OVERRIDE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_INVALIDATE_SAMPLER_CACHE_NO_WFI:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVC697_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVC697_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINES = ", prefix);
        switch (parsed) {
        case NVC697_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ALL:
            fprintf(fp, "ALL\n");
            break;
        case NVC697_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ONE:
            fprintf(fp, "ONE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 22) - 1);
        fprintf(fp, "%s.TAG = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_GLOBAL_BASE_VERTEX_INDEX:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_GLOBAL_BASE_INSTANCE_INDEX:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_PS_WARP_WATERMARKS:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.LOW = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.HIGH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_PS_REGISTER_WATERMARKS:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.LOW = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.HIGH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_STORE_ZCULL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                case NVC697_LOAD_ZCULL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SURFACE_CLIP_ID_HEIGHT:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_CLIP_ID_CLEAR_RECT_HORIZONTAL:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.XMIN = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.XMAX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_CLIP_ID_CLEAR_RECT_VERTICAL:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.YMIN = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.YMAX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_USER_CLIP_ENABLE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE0 = ", prefix);
        switch (parsed) {
        case NVC697_SET_USER_CLIP_ENABLE_PLANE0_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_USER_CLIP_ENABLE_PLANE0_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE1 = ", prefix);
        switch (parsed) {
        case NVC697_SET_USER_CLIP_ENABLE_PLANE1_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_USER_CLIP_ENABLE_PLANE1_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE2 = ", prefix);
        switch (parsed) {
        case NVC697_SET_USER_CLIP_ENABLE_PLANE2_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_USER_CLIP_ENABLE_PLANE2_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE3 = ", prefix);
        switch (parsed) {
        case NVC697_SET_USER_CLIP_ENABLE_PLANE3_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_USER_CLIP_ENABLE_PLANE3_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE4 = ", prefix);
        switch (parsed) {
        case NVC697_SET_USER_CLIP_ENABLE_PLANE4_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_USER_CLIP_ENABLE_PLANE4_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE5 = ", prefix);
        switch (parsed) {
        case NVC697_SET_USER_CLIP_ENABLE_PLANE5_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_USER_CLIP_ENABLE_PLANE5_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 6) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE6 = ", prefix);
        switch (parsed) {
        case NVC697_SET_USER_CLIP_ENABLE_PLANE6_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_USER_CLIP_ENABLE_PLANE6_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE7 = ", prefix);
        switch (parsed) {
        case NVC697_SET_USER_CLIP_ENABLE_PLANE7_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_USER_CLIP_ENABLE_PLANE7_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ZPASS_PIXEL_COUNT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZPASS_PIXEL_COUNT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ZPASS_PIXEL_COUNT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_POINT_SIZE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZCULL_STATS:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZCULL_STATS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ZCULL_STATS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_POINT_SPRITE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_POINT_SPRITE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_POINT_SPRITE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_SHADER_EXCEPTIONS:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_SHADER_EXCEPTIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_SHADER_EXCEPTIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_CLEAR_REPORT_VALUE:
    
        parsed = (data >> 0) & ((1u << 5) - 1);
        fprintf(fp, "%s.TYPE = ", prefix);
        switch (parsed) {
        case NVC697_CLEAR_REPORT_VALUE_TYPE_DA_VERTICES_GENERATED:
            fprintf(fp, "DA_VERTICES_GENERATED\n");
            break;
        case NVC697_CLEAR_REPORT_VALUE_TYPE_DA_PRIMITIVES_GENERATED:
            fprintf(fp, "DA_PRIMITIVES_GENERATED\n");
            break;
        case NVC697_CLEAR_REPORT_VALUE_TYPE_VS_INVOCATIONS:
            fprintf(fp, "VS_INVOCATIONS\n");
            break;
        case NVC697_CLEAR_REPORT_VALUE_TYPE_TI_INVOCATIONS:
            fprintf(fp, "TI_INVOCATIONS\n");
            break;
        case NVC697_CLEAR_REPORT_VALUE_TYPE_TS_INVOCATIONS:
            fprintf(fp, "TS_INVOCATIONS\n");
            break;
        case NVC697_CLEAR_REPORT_VALUE_TYPE_TS_PRIMITIVES_GENERATED:
            fprintf(fp, "TS_PRIMITIVES_GENERATED\n");
            break;
        case NVC697_CLEAR_REPORT_VALUE_TYPE_GS_INVOCATIONS:
            fprintf(fp, "GS_INVOCATIONS\n");
            break;
        case NVC697_CLEAR_REPORT_VALUE_TYPE_GS_PRIMITIVES_GENERATED:
            fprintf(fp, "GS_PRIMITIVES_GENERATED\n");
            break;
        case NVC697_CLEAR_REPORT_VALUE_TYPE_VTG_PRIMITIVES_OUT:
            fprintf(fp, "VTG_PRIMITIVES_OUT\n");
            break;
        case NVC697_CLEAR_REPORT_VALUE_TYPE_STREAMING_PRIMITIVES_SUCCEEDED:
            fprintf(fp, "STREAMING_PRIMITIVES_SUCCEEDED\n");
            break;
        case NVC697_CLEAR_REPORT_VALUE_TYPE_STREAMING_PRIMITIVES_NEEDED:
            fprintf(fp, "STREAMING_PRIMITIVES_NEEDED\n");
            break;
        case NVC697_CLEAR_REPORT_VALUE_TYPE_TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED:
            fprintf(fp, "TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED\n");
            break;
        case NVC697_CLEAR_REPORT_VALUE_TYPE_CLIPPER_INVOCATIONS:
            fprintf(fp, "CLIPPER_INVOCATIONS\n");
            break;
        case NVC697_CLEAR_REPORT_VALUE_TYPE_CLIPPER_PRIMITIVES_GENERATED:
            fprintf(fp, "CLIPPER_PRIMITIVES_GENERATED\n");
            break;
        case NVC697_CLEAR_REPORT_VALUE_TYPE_ZCULL_STATS:
            fprintf(fp, "ZCULL_STATS\n");
            break;
        case NVC697_CLEAR_REPORT_VALUE_TYPE_PS_INVOCATIONS:
            fprintf(fp, "PS_INVOCATIONS\n");
            break;
        case NVC697_CLEAR_REPORT_VALUE_TYPE_ZPASS_PIXEL_CNT:
            fprintf(fp, "ZPASS_PIXEL_CNT\n");
            break;
        case NVC697_CLEAR_REPORT_VALUE_TYPE_ALPHA_BETA_CLOCKS:
            fprintf(fp, "ALPHA_BETA_CLOCKS\n");
            break;
        case NVC697_CLEAR_REPORT_VALUE_TYPE_SCG_CLOCKS:
            fprintf(fp, "SCG_CLOCKS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ANTI_ALIAS_ENABLE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_ANTI_ALIAS_ENABLE_V_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ANTI_ALIAS_ENABLE_V_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ZT_SELECT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.TARGET_COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ANTI_ALIAS_ALPHA_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ALPHA_TO_COVERAGE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ANTI_ALIAS_ALPHA_CONTROL_ALPHA_TO_COVERAGE_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        case NVC697_SET_ANTI_ALIAS_ALPHA_CONTROL_ALPHA_TO_COVERAGE_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.ALPHA_TO_ONE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ANTI_ALIAS_ALPHA_CONTROL_ALPHA_TO_ONE_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        case NVC697_SET_ANTI_ALIAS_ALPHA_CONTROL_ALPHA_TO_ONE_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_RENDER_ENABLE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_RENDER_ENABLE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_RENDER_ENABLE_C:
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVC697_SET_RENDER_ENABLE_C_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_RENDER_ENABLE_C_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        case NVC697_SET_RENDER_ENABLE_C_MODE_CONDITIONAL:
            fprintf(fp, "CONDITIONAL\n");
            break;
        case NVC697_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL:
            fprintf(fp, "RENDER_IF_EQUAL\n");
            break;
        case NVC697_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL:
            fprintf(fp, "RENDER_IF_NOT_EQUAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_TEX_SAMPLER_POOL_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_TEX_SAMPLER_POOL_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_TEX_SAMPLER_POOL_C:
    
        parsed = (data >> 0) & ((1u << 20) - 1);
        fprintf(fp, "%s.MAXIMUM_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SLOPE_SCALE_DEPTH_BIAS:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVC697_SET_ANTI_ALIASED_LINE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ANTI_ALIASED_LINE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ANTI_ALIASED_LINE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_TEX_HEADER_POOL_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_TEX_HEADER_POOL_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_TEX_HEADER_POOL_C:
    
        parsed = (data >> 0) & ((1u << 22) - 1);
        fprintf(fp, "%s.MAXIMUM_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ACTIVE_ZCULL_REGION:
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.ID = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_TWO_SIDED_STENCIL_TEST:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_TWO_SIDED_STENCIL_TEST_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_TWO_SIDED_STENCIL_TEST_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BACK_STENCIL_OP_FAIL:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_BACK_STENCIL_OP_FAIL_V_OGL_KEEP:
            fprintf(fp, "OGL_KEEP\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_FAIL_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_FAIL_V_OGL_REPLACE:
            fprintf(fp, "OGL_REPLACE\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_FAIL_V_OGL_INCRSAT:
            fprintf(fp, "OGL_INCRSAT\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_FAIL_V_OGL_DECRSAT:
            fprintf(fp, "OGL_DECRSAT\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_FAIL_V_OGL_INVERT:
            fprintf(fp, "OGL_INVERT\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_FAIL_V_OGL_INCR:
            fprintf(fp, "OGL_INCR\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_FAIL_V_OGL_DECR:
            fprintf(fp, "OGL_DECR\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_FAIL_V_D3D_KEEP:
            fprintf(fp, "D3D_KEEP\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_FAIL_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_FAIL_V_D3D_REPLACE:
            fprintf(fp, "D3D_REPLACE\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_FAIL_V_D3D_INCRSAT:
            fprintf(fp, "D3D_INCRSAT\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_FAIL_V_D3D_DECRSAT:
            fprintf(fp, "D3D_DECRSAT\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_FAIL_V_D3D_INVERT:
            fprintf(fp, "D3D_INVERT\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_FAIL_V_D3D_INCR:
            fprintf(fp, "D3D_INCR\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_FAIL_V_D3D_DECR:
            fprintf(fp, "D3D_DECR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BACK_STENCIL_OP_ZFAIL:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_KEEP:
            fprintf(fp, "OGL_KEEP\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_REPLACE:
            fprintf(fp, "OGL_REPLACE\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_INCRSAT:
            fprintf(fp, "OGL_INCRSAT\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_DECRSAT:
            fprintf(fp, "OGL_DECRSAT\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_INVERT:
            fprintf(fp, "OGL_INVERT\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_INCR:
            fprintf(fp, "OGL_INCR\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_DECR:
            fprintf(fp, "OGL_DECR\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_KEEP:
            fprintf(fp, "D3D_KEEP\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_REPLACE:
            fprintf(fp, "D3D_REPLACE\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_INCRSAT:
            fprintf(fp, "D3D_INCRSAT\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_DECRSAT:
            fprintf(fp, "D3D_DECRSAT\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_INVERT:
            fprintf(fp, "D3D_INVERT\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_INCR:
            fprintf(fp, "D3D_INCR\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_DECR:
            fprintf(fp, "D3D_DECR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BACK_STENCIL_OP_ZPASS:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_BACK_STENCIL_OP_ZPASS_V_OGL_KEEP:
            fprintf(fp, "OGL_KEEP\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZPASS_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZPASS_V_OGL_REPLACE:
            fprintf(fp, "OGL_REPLACE\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZPASS_V_OGL_INCRSAT:
            fprintf(fp, "OGL_INCRSAT\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZPASS_V_OGL_DECRSAT:
            fprintf(fp, "OGL_DECRSAT\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZPASS_V_OGL_INVERT:
            fprintf(fp, "OGL_INVERT\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZPASS_V_OGL_INCR:
            fprintf(fp, "OGL_INCR\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZPASS_V_OGL_DECR:
            fprintf(fp, "OGL_DECR\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZPASS_V_D3D_KEEP:
            fprintf(fp, "D3D_KEEP\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZPASS_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZPASS_V_D3D_REPLACE:
            fprintf(fp, "D3D_REPLACE\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZPASS_V_D3D_INCRSAT:
            fprintf(fp, "D3D_INCRSAT\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZPASS_V_D3D_DECRSAT:
            fprintf(fp, "D3D_DECRSAT\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZPASS_V_D3D_INVERT:
            fprintf(fp, "D3D_INVERT\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZPASS_V_D3D_INCR:
            fprintf(fp, "D3D_INCR\n");
            break;
        case NVC697_SET_BACK_STENCIL_OP_ZPASS_V_D3D_DECR:
            fprintf(fp, "D3D_DECR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BACK_STENCIL_FUNC:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_BACK_STENCIL_FUNC_V_OGL_NEVER:
            fprintf(fp, "OGL_NEVER\n");
            break;
        case NVC697_SET_BACK_STENCIL_FUNC_V_OGL_LESS:
            fprintf(fp, "OGL_LESS\n");
            break;
        case NVC697_SET_BACK_STENCIL_FUNC_V_OGL_EQUAL:
            fprintf(fp, "OGL_EQUAL\n");
            break;
        case NVC697_SET_BACK_STENCIL_FUNC_V_OGL_LEQUAL:
            fprintf(fp, "OGL_LEQUAL\n");
            break;
        case NVC697_SET_BACK_STENCIL_FUNC_V_OGL_GREATER:
            fprintf(fp, "OGL_GREATER\n");
            break;
        case NVC697_SET_BACK_STENCIL_FUNC_V_OGL_NOTEQUAL:
            fprintf(fp, "OGL_NOTEQUAL\n");
            break;
        case NVC697_SET_BACK_STENCIL_FUNC_V_OGL_GEQUAL:
            fprintf(fp, "OGL_GEQUAL\n");
            break;
        case NVC697_SET_BACK_STENCIL_FUNC_V_OGL_ALWAYS:
            fprintf(fp, "OGL_ALWAYS\n");
            break;
        case NVC697_SET_BACK_STENCIL_FUNC_V_D3D_NEVER:
            fprintf(fp, "D3D_NEVER\n");
            break;
        case NVC697_SET_BACK_STENCIL_FUNC_V_D3D_LESS:
            fprintf(fp, "D3D_LESS\n");
            break;
        case NVC697_SET_BACK_STENCIL_FUNC_V_D3D_EQUAL:
            fprintf(fp, "D3D_EQUAL\n");
            break;
        case NVC697_SET_BACK_STENCIL_FUNC_V_D3D_LESSEQUAL:
            fprintf(fp, "D3D_LESSEQUAL\n");
            break;
        case NVC697_SET_BACK_STENCIL_FUNC_V_D3D_GREATER:
            fprintf(fp, "D3D_GREATER\n");
            break;
        case NVC697_SET_BACK_STENCIL_FUNC_V_D3D_NOTEQUAL:
            fprintf(fp, "D3D_NOTEQUAL\n");
            break;
        case NVC697_SET_BACK_STENCIL_FUNC_V_D3D_GREATEREQUAL:
            fprintf(fp, "D3D_GREATEREQUAL\n");
            break;
        case NVC697_SET_BACK_STENCIL_FUNC_V_D3D_ALWAYS:
            fprintf(fp, "D3D_ALWAYS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_SRGB_WRITE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_SRGB_WRITE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_SRGB_WRITE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_DEPTH_BIAS:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVC697_SET_ZCULL_REGION_FORMAT:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.TYPE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZCULL_REGION_FORMAT_TYPE_Z_4X4:
            fprintf(fp, "Z_4X4\n");
            break;
        case NVC697_SET_ZCULL_REGION_FORMAT_TYPE_ZS_4X4:
            fprintf(fp, "ZS_4X4\n");
            break;
        case NVC697_SET_ZCULL_REGION_FORMAT_TYPE_Z_4X2:
            fprintf(fp, "Z_4X2\n");
            break;
        case NVC697_SET_ZCULL_REGION_FORMAT_TYPE_Z_2X4:
            fprintf(fp, "Z_2X4\n");
            break;
        case NVC697_SET_ZCULL_REGION_FORMAT_TYPE_Z_16X8_4X4:
            fprintf(fp, "Z_16X8_4X4\n");
            break;
        case NVC697_SET_ZCULL_REGION_FORMAT_TYPE_Z_8X8_4X2:
            fprintf(fp, "Z_8X8_4X2\n");
            break;
        case NVC697_SET_ZCULL_REGION_FORMAT_TYPE_Z_8X8_2X4:
            fprintf(fp, "Z_8X8_2X4\n");
            break;
        case NVC697_SET_ZCULL_REGION_FORMAT_TYPE_Z_16X16_4X8:
            fprintf(fp, "Z_16X16_4X8\n");
            break;
        case NVC697_SET_ZCULL_REGION_FORMAT_TYPE_Z_4X8_2X2:
            fprintf(fp, "Z_4X8_2X2\n");
            break;
        case NVC697_SET_ZCULL_REGION_FORMAT_TYPE_ZS_16X8_4X2:
            fprintf(fp, "ZS_16X8_4X2\n");
            break;
        case NVC697_SET_ZCULL_REGION_FORMAT_TYPE_ZS_16X8_2X4:
            fprintf(fp, "ZS_16X8_2X4\n");
            break;
        case NVC697_SET_ZCULL_REGION_FORMAT_TYPE_ZS_8X8_2X2:
            fprintf(fp, "ZS_8X8_2X2\n");
            break;
        case NVC697_SET_ZCULL_REGION_FORMAT_TYPE_Z_4X8_1X1:
            fprintf(fp, "Z_4X8_1X1\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_RT_LAYER:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONTROL = ", prefix);
        switch (parsed) {
        case NVC697_SET_RT_LAYER_CONTROL_V_SELECTS_LAYER:
            fprintf(fp, "V_SELECTS_LAYER\n");
            break;
        case NVC697_SET_RT_LAYER_CONTROL_GEOMETRY_SHADER_SELECTS_LAYER:
            fprintf(fp, "GEOMETRY_SHADER_SELECTS_LAYER\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ANTI_ALIAS:
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.SAMPLES = ", prefix);
        switch (parsed) {
        case NVC697_SET_ANTI_ALIAS_SAMPLES_MODE_1X1:
            fprintf(fp, "MODE_1X1\n");
            break;
        case NVC697_SET_ANTI_ALIAS_SAMPLES_MODE_2X1:
            fprintf(fp, "MODE_2X1\n");
            break;
        case NVC697_SET_ANTI_ALIAS_SAMPLES_MODE_2X2:
            fprintf(fp, "MODE_2X2\n");
            break;
        case NVC697_SET_ANTI_ALIAS_SAMPLES_MODE_4X2:
            fprintf(fp, "MODE_4X2\n");
            break;
        case NVC697_SET_ANTI_ALIAS_SAMPLES_MODE_4X2_D3D:
            fprintf(fp, "MODE_4X2_D3D\n");
            break;
        case NVC697_SET_ANTI_ALIAS_SAMPLES_MODE_2X1_D3D:
            fprintf(fp, "MODE_2X1_D3D\n");
            break;
        case NVC697_SET_ANTI_ALIAS_SAMPLES_MODE_4X4:
            fprintf(fp, "MODE_4X4\n");
            break;
        case NVC697_SET_ANTI_ALIAS_SAMPLES_MODE_2X2_VC_4:
            fprintf(fp, "MODE_2X2_VC_4\n");
            break;
        case NVC697_SET_ANTI_ALIAS_SAMPLES_MODE_2X2_VC_12:
            fprintf(fp, "MODE_2X2_VC_12\n");
            break;
        case NVC697_SET_ANTI_ALIAS_SAMPLES_MODE_4X2_VC_8:
            fprintf(fp, "MODE_4X2_VC_8\n");
            break;
        case NVC697_SET_ANTI_ALIAS_SAMPLES_MODE_4X2_VC_24:
            fprintf(fp, "MODE_4X2_VC_24\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_EDGE_FLAG:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_EDGE_FLAG_V_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_EDGE_FLAG_V_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_DRAW_INLINE_INDEX:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_INLINE_INDEX2X16_ALIGN:
    
        parsed = (data >> 0) & ((1u << 31) - 1);
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 31) & ((1u << 1) - 1);
        fprintf(fp, "%s.START_ODD = ", prefix);
        switch (parsed) {
        case NVC697_SET_INLINE_INDEX2X16_ALIGN_START_ODD_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_INLINE_INDEX2X16_ALIGN_START_ODD_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_DRAW_INLINE_INDEX2X16:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.EVEN = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.ODD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_VERTEX_GLOBAL_BASE_OFFSET_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_VERTEX_GLOBAL_BASE_OFFSET_B:
    
        parsed = data;
        fprintf(fp, "%s.LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZCULL_REGION_PIXEL_OFFSET_A:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZCULL_REGION_PIXEL_OFFSET_B:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_POINT_SPRITE_SELECT:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.RMODE = ", prefix);
        switch (parsed) {
        case NVC697_SET_POINT_SPRITE_SELECT_RMODE_ZERO:
            fprintf(fp, "ZERO\n");
            break;
        case NVC697_SET_POINT_SPRITE_SELECT_RMODE_FROM_R:
            fprintf(fp, "FROM_R\n");
            break;
        case NVC697_SET_POINT_SPRITE_SELECT_RMODE_FROM_S:
            fprintf(fp, "FROM_S\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.ORIGIN = ", prefix);
        switch (parsed) {
        case NVC697_SET_POINT_SPRITE_SELECT_ORIGIN_BOTTOM:
            fprintf(fp, "BOTTOM\n");
            break;
        case NVC697_SET_POINT_SPRITE_SELECT_ORIGIN_TOP:
            fprintf(fp, "TOP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.TEXTURE0 = ", prefix);
        switch (parsed) {
        case NVC697_SET_POINT_SPRITE_SELECT_TEXTURE0_PASSTHROUGH:
            fprintf(fp, "PASSTHROUGH\n");
            break;
        case NVC697_SET_POINT_SPRITE_SELECT_TEXTURE0_GENERATE:
            fprintf(fp, "GENERATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.TEXTURE1 = ", prefix);
        switch (parsed) {
        case NVC697_SET_POINT_SPRITE_SELECT_TEXTURE1_PASSTHROUGH:
            fprintf(fp, "PASSTHROUGH\n");
            break;
        case NVC697_SET_POINT_SPRITE_SELECT_TEXTURE1_GENERATE:
            fprintf(fp, "GENERATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 1) - 1);
        fprintf(fp, "%s.TEXTURE2 = ", prefix);
        switch (parsed) {
        case NVC697_SET_POINT_SPRITE_SELECT_TEXTURE2_PASSTHROUGH:
            fprintf(fp, "PASSTHROUGH\n");
            break;
        case NVC697_SET_POINT_SPRITE_SELECT_TEXTURE2_GENERATE:
            fprintf(fp, "GENERATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 6) & ((1u << 1) - 1);
        fprintf(fp, "%s.TEXTURE3 = ", prefix);
        switch (parsed) {
        case NVC697_SET_POINT_SPRITE_SELECT_TEXTURE3_PASSTHROUGH:
            fprintf(fp, "PASSTHROUGH\n");
            break;
        case NVC697_SET_POINT_SPRITE_SELECT_TEXTURE3_GENERATE:
            fprintf(fp, "GENERATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 1) - 1);
        fprintf(fp, "%s.TEXTURE4 = ", prefix);
        switch (parsed) {
        case NVC697_SET_POINT_SPRITE_SELECT_TEXTURE4_PASSTHROUGH:
            fprintf(fp, "PASSTHROUGH\n");
            break;
        case NVC697_SET_POINT_SPRITE_SELECT_TEXTURE4_GENERATE:
            fprintf(fp, "GENERATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.TEXTURE5 = ", prefix);
        switch (parsed) {
        case NVC697_SET_POINT_SPRITE_SELECT_TEXTURE5_PASSTHROUGH:
            fprintf(fp, "PASSTHROUGH\n");
            break;
        case NVC697_SET_POINT_SPRITE_SELECT_TEXTURE5_GENERATE:
            fprintf(fp, "GENERATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 1) - 1);
        fprintf(fp, "%s.TEXTURE6 = ", prefix);
        switch (parsed) {
        case NVC697_SET_POINT_SPRITE_SELECT_TEXTURE6_PASSTHROUGH:
            fprintf(fp, "PASSTHROUGH\n");
            break;
        case NVC697_SET_POINT_SPRITE_SELECT_TEXTURE6_GENERATE:
            fprintf(fp, "GENERATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 10) & ((1u << 1) - 1);
        fprintf(fp, "%s.TEXTURE7 = ", prefix);
        switch (parsed) {
        case NVC697_SET_POINT_SPRITE_SELECT_TEXTURE7_PASSTHROUGH:
            fprintf(fp, "PASSTHROUGH\n");
            break;
        case NVC697_SET_POINT_SPRITE_SELECT_TEXTURE7_GENERATE:
            fprintf(fp, "GENERATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 11) & ((1u << 1) - 1);
        fprintf(fp, "%s.TEXTURE8 = ", prefix);
        switch (parsed) {
        case NVC697_SET_POINT_SPRITE_SELECT_TEXTURE8_PASSTHROUGH:
            fprintf(fp, "PASSTHROUGH\n");
            break;
        case NVC697_SET_POINT_SPRITE_SELECT_TEXTURE8_GENERATE:
            fprintf(fp, "GENERATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.TEXTURE9 = ", prefix);
        switch (parsed) {
        case NVC697_SET_POINT_SPRITE_SELECT_TEXTURE9_PASSTHROUGH:
            fprintf(fp, "PASSTHROUGH\n");
            break;
        case NVC697_SET_POINT_SPRITE_SELECT_TEXTURE9_GENERATE:
            fprintf(fp, "GENERATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ATTRIBUTE_DEFAULT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.COLOR_FRONT_DIFFUSE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ATTRIBUTE_DEFAULT_COLOR_FRONT_DIFFUSE_VECTOR_0001:
            fprintf(fp, "VECTOR_0001\n");
            break;
        case NVC697_SET_ATTRIBUTE_DEFAULT_COLOR_FRONT_DIFFUSE_VECTOR_1111:
            fprintf(fp, "VECTOR_1111\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.COLOR_FRONT_SPECULAR = ", prefix);
        switch (parsed) {
        case NVC697_SET_ATTRIBUTE_DEFAULT_COLOR_FRONT_SPECULAR_VECTOR_0000:
            fprintf(fp, "VECTOR_0000\n");
            break;
        case NVC697_SET_ATTRIBUTE_DEFAULT_COLOR_FRONT_SPECULAR_VECTOR_0001:
            fprintf(fp, "VECTOR_0001\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.GENERIC_VECTOR = ", prefix);
        switch (parsed) {
        case NVC697_SET_ATTRIBUTE_DEFAULT_GENERIC_VECTOR_VECTOR_0000:
            fprintf(fp, "VECTOR_0000\n");
            break;
        case NVC697_SET_ATTRIBUTE_DEFAULT_GENERIC_VECTOR_VECTOR_0001:
            fprintf(fp, "VECTOR_0001\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.FIXED_FNC_TEXTURE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ATTRIBUTE_DEFAULT_FIXED_FNC_TEXTURE_VECTOR_0000:
            fprintf(fp, "VECTOR_0000\n");
            break;
        case NVC697_SET_ATTRIBUTE_DEFAULT_FIXED_FNC_TEXTURE_VECTOR_0001:
            fprintf(fp, "VECTOR_0001\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.DX9_COLOR0 = ", prefix);
        switch (parsed) {
        case NVC697_SET_ATTRIBUTE_DEFAULT_DX9_COLOR0_VECTOR_0001:
            fprintf(fp, "VECTOR_0001\n");
            break;
        case NVC697_SET_ATTRIBUTE_DEFAULT_DX9_COLOR0_VECTOR_1111:
            fprintf(fp, "VECTOR_1111\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 1) - 1);
        fprintf(fp, "%s.DX9_COLOR1_TO_COLOR15 = ", prefix);
        switch (parsed) {
        case NVC697_SET_ATTRIBUTE_DEFAULT_DX9_COLOR1_TO_COLOR15_VECTOR_0000:
            fprintf(fp, "VECTOR_0000\n");
            break;
        case NVC697_SET_ATTRIBUTE_DEFAULT_DX9_COLOR1_TO_COLOR15_VECTOR_0001:
            fprintf(fp, "VECTOR_0001\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_END:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_BEGIN:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.OP = ", prefix);
        switch (parsed) {
        case NVC697_BEGIN_OP_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVC697_BEGIN_OP_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVC697_BEGIN_OP_LINE_LOOP:
            fprintf(fp, "LINE_LOOP\n");
            break;
        case NVC697_BEGIN_OP_LINE_STRIP:
            fprintf(fp, "LINE_STRIP\n");
            break;
        case NVC697_BEGIN_OP_TRIANGLES:
            fprintf(fp, "TRIANGLES\n");
            break;
        case NVC697_BEGIN_OP_TRIANGLE_STRIP:
            fprintf(fp, "TRIANGLE_STRIP\n");
            break;
        case NVC697_BEGIN_OP_TRIANGLE_FAN:
            fprintf(fp, "TRIANGLE_FAN\n");
            break;
        case NVC697_BEGIN_OP_QUADS:
            fprintf(fp, "QUADS\n");
            break;
        case NVC697_BEGIN_OP_QUAD_STRIP:
            fprintf(fp, "QUAD_STRIP\n");
            break;
        case NVC697_BEGIN_OP_POLYGON:
            fprintf(fp, "POLYGON\n");
            break;
        case NVC697_BEGIN_OP_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVC697_BEGIN_OP_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVC697_BEGIN_OP_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVC697_BEGIN_OP_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVC697_BEGIN_OP_PATCH:
            fprintf(fp, "PATCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.PRIMITIVE_ID = ", prefix);
        switch (parsed) {
        case NVC697_BEGIN_PRIMITIVE_ID_FIRST:
            fprintf(fp, "FIRST\n");
            break;
        case NVC697_BEGIN_PRIMITIVE_ID_UNCHANGED:
            fprintf(fp, "UNCHANGED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 26) & ((1u << 2) - 1);
        fprintf(fp, "%s.INSTANCE_ID = ", prefix);
        switch (parsed) {
        case NVC697_BEGIN_INSTANCE_ID_FIRST:
            fprintf(fp, "FIRST\n");
            break;
        case NVC697_BEGIN_INSTANCE_ID_SUBSEQUENT:
            fprintf(fp, "SUBSEQUENT\n");
            break;
        case NVC697_BEGIN_INSTANCE_ID_UNCHANGED:
            fprintf(fp, "UNCHANGED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 29) & ((1u << 2) - 1);
        fprintf(fp, "%s.SPLIT_MODE = ", prefix);
        switch (parsed) {
        case NVC697_BEGIN_SPLIT_MODE_NORMAL_BEGIN_NORMAL_END:
            fprintf(fp, "NORMAL_BEGIN_NORMAL_END\n");
            break;
        case NVC697_BEGIN_SPLIT_MODE_NORMAL_BEGIN_OPEN_END:
            fprintf(fp, "NORMAL_BEGIN_OPEN_END\n");
            break;
        case NVC697_BEGIN_SPLIT_MODE_OPEN_BEGIN_OPEN_END:
            fprintf(fp, "OPEN_BEGIN_OPEN_END\n");
            break;
        case NVC697_BEGIN_SPLIT_MODE_OPEN_BEGIN_NORMAL_END:
            fprintf(fp, "OPEN_BEGIN_NORMAL_END\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 31) & ((1u << 1) - 1);
        fprintf(fp, "%s.INSTANCE_ITERATE_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_BEGIN_INSTANCE_ITERATE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_BEGIN_INSTANCE_ITERATE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_VERTEX_ID_COPY:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_VERTEX_ID_COPY_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_VERTEX_ID_COPY_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 8) - 1);
        fprintf(fp, "%s.ATTRIBUTE_SLOT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_ADD_TO_PRIMITIVE_ID:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_LOAD_PRIMITIVE_ID:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADER_BASED_CULL:
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.BATCH_CULL_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_SHADER_BASED_CULL_BATCH_CULL_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_SHADER_BASED_CULL_BATCH_CULL_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.BEFORE_FETCH_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_SHADER_BASED_CULL_BEFORE_FETCH_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_SHADER_BASED_CULL_BEFORE_FETCH_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_CLASS_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_DA_PRIMITIVE_RESTART:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_DA_PRIMITIVE_RESTART_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_DA_PRIMITIVE_RESTART_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_DA_PRIMITIVE_RESTART_INDEX:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_DA_OUTPUT:
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.VERTEX_ID_USES_ARRAY_START = ", prefix);
        switch (parsed) {
        case NVC697_SET_DA_OUTPUT_VERTEX_ID_USES_ARRAY_START_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_DA_OUTPUT_VERTEX_ID_USES_ARRAY_START_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ANTI_ALIASED_POINT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ANTI_ALIASED_POINT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ANTI_ALIASED_POINT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_POINT_CENTER_MODE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_POINT_CENTER_MODE_V_OGL:
            fprintf(fp, "OGL\n");
            break;
        case NVC697_SET_POINT_CENTER_MODE_V_D3D:
            fprintf(fp, "D3D\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_LINE_SMOOTH_PARAMETERS:
    
        parsed = data;
        fprintf(fp, "%s.FALLOFF = ", prefix);
        switch (parsed) {
        case NVC697_SET_LINE_SMOOTH_PARAMETERS_FALLOFF__1_00:
            fprintf(fp, "_1_00\n");
            break;
        case NVC697_SET_LINE_SMOOTH_PARAMETERS_FALLOFF__1_33:
            fprintf(fp, "_1_33\n");
            break;
        case NVC697_SET_LINE_SMOOTH_PARAMETERS_FALLOFF__1_60:
            fprintf(fp, "_1_60\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_LINE_STIPPLE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_LINE_STIPPLE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_LINE_STIPPLE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
        case NVC697_SET_LINE_STIPPLE_PARAMETERS:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.FACTOR = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 16) - 1);
        fprintf(fp, "%s.PATTERN = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_PROVOKING_VERTEX:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_PROVOKING_VERTEX_V_FIRST:
            fprintf(fp, "FIRST\n");
            break;
        case NVC697_SET_PROVOKING_VERTEX_V_LAST:
            fprintf(fp, "LAST\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_TWO_SIDED_LIGHT:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_TWO_SIDED_LIGHT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_TWO_SIDED_LIGHT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_POLYGON_STIPPLE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_POLYGON_STIPPLE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_POLYGON_STIPPLE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_SHADER_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.DEFAULT_PARTIAL = ", prefix);
        switch (parsed) {
        case NVC697_SET_SHADER_CONTROL_DEFAULT_PARTIAL_ZERO:
            fprintf(fp, "ZERO\n");
            break;
        case NVC697_SET_SHADER_CONTROL_DEFAULT_PARTIAL_INFINITY:
            fprintf(fp, "INFINITY\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.FP32_NAN_BEHAVIOR = ", prefix);
        switch (parsed) {
        case NVC697_SET_SHADER_CONTROL_FP32_NAN_BEHAVIOR_LEGACY:
            fprintf(fp, "LEGACY\n");
            break;
        case NVC697_SET_SHADER_CONTROL_FP32_NAN_BEHAVIOR_FP64_COMPATIBLE:
            fprintf(fp, "FP64_COMPATIBLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.FP32_F2I_NAN_BEHAVIOR = ", prefix);
        switch (parsed) {
        case NVC697_SET_SHADER_CONTROL_FP32_F2I_NAN_BEHAVIOR_PASS_ZERO:
            fprintf(fp, "PASS_ZERO\n");
            break;
        case NVC697_SET_SHADER_CONTROL_FP32_F2I_NAN_BEHAVIOR_PASS_INDEFINITE:
            fprintf(fp, "PASS_INDEFINITE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_CHECK_CLASS_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SPH_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_CHECK_SPH_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ALPHA_TO_COVERAGE_OVERRIDE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.QUALIFY_BY_ANTI_ALIAS_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ALPHA_TO_COVERAGE_OVERRIDE_QUALIFY_BY_ANTI_ALIAS_ENABLE_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        case NVC697_SET_ALPHA_TO_COVERAGE_OVERRIDE_QUALIFY_BY_ANTI_ALIAS_ENABLE_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.QUALIFY_BY_PS_SAMPLE_MASK_OUTPUT = ", prefix);
        switch (parsed) {
        case NVC697_SET_ALPHA_TO_COVERAGE_OVERRIDE_QUALIFY_BY_PS_SAMPLE_MASK_OUTPUT_DISABLE:
            fprintf(fp, "DISABLE\n");
            break;
        case NVC697_SET_ALPHA_TO_COVERAGE_OVERRIDE_QUALIFY_BY_PS_SAMPLE_MASK_OUTPUT_ENABLE:
            fprintf(fp, "ENABLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_SCG_GRAPHICS_PRIORITY:
    
        parsed = (data >> 0) & ((1u << 6) - 1);
        fprintf(fp, "%s.PRIORITY = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(0):
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(1):
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(2):
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(3):
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(4):
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(5):
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(6):
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(7):
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(8):
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(9):
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(10):
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(11):
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(12):
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(13):
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(14):
    case NVC697_SET_SCG_GRAPHICS_SCHEDULING_PARAMETERS(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
        case NVC697_SET_AAM_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_CHECK_AAM_VERSION:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.CURRENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.OLDEST_SUPPORTED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_ZT_LAYER:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_INDEX_BUFFER_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_INDEX_BUFFER_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_INDEX_BUFFER_E:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.INDEX_SIZE = ", prefix);
        switch (parsed) {
        case NVC697_SET_INDEX_BUFFER_E_INDEX_SIZE_ONE_BYTE:
            fprintf(fp, "ONE_BYTE\n");
            break;
        case NVC697_SET_INDEX_BUFFER_E_INDEX_SIZE_TWO_BYTES:
            fprintf(fp, "TWO_BYTES\n");
            break;
        case NVC697_SET_INDEX_BUFFER_E_INDEX_SIZE_FOUR_BYTES:
            fprintf(fp, "FOUR_BYTES\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_INDEX_BUFFER_F:
    
        parsed = data;
        fprintf(fp, "%s.FIRST = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_DRAW_INDEX_BUFFER:
    
        parsed = data;
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.FIRST = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 12) - 1);
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.TOPOLOGY = ", prefix);
        switch (parsed) {
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_LOOP:
            fprintf(fp, "LINE_LOOP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_STRIP:
            fprintf(fp, "LINE_STRIP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLES:
            fprintf(fp, "TRIANGLES\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_STRIP:
            fprintf(fp, "TRIANGLE_STRIP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_FAN:
            fprintf(fp, "TRIANGLE_FAN\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUADS:
            fprintf(fp, "QUADS\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUAD_STRIP:
            fprintf(fp, "QUAD_STRIP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POLYGON:
            fprintf(fp, "POLYGON\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_PATCH:
            fprintf(fp, "PATCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.FIRST = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 12) - 1);
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.TOPOLOGY = ", prefix);
        switch (parsed) {
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_LOOP:
            fprintf(fp, "LINE_LOOP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_STRIP:
            fprintf(fp, "LINE_STRIP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLES:
            fprintf(fp, "TRIANGLES\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_STRIP:
            fprintf(fp, "TRIANGLE_STRIP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_FAN:
            fprintf(fp, "TRIANGLE_FAN\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUADS:
            fprintf(fp, "QUADS\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUAD_STRIP:
            fprintf(fp, "QUAD_STRIP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POLYGON:
            fprintf(fp, "POLYGON\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_PATCH:
            fprintf(fp, "PATCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.FIRST = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 12) - 1);
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.TOPOLOGY = ", prefix);
        switch (parsed) {
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_LOOP:
            fprintf(fp, "LINE_LOOP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_STRIP:
            fprintf(fp, "LINE_STRIP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLES:
            fprintf(fp, "TRIANGLES\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_STRIP:
            fprintf(fp, "TRIANGLE_STRIP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_FAN:
            fprintf(fp, "TRIANGLE_FAN\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUADS:
            fprintf(fp, "QUADS\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUAD_STRIP:
            fprintf(fp, "QUAD_STRIP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POLYGON:
            fprintf(fp, "POLYGON\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_PATCH:
            fprintf(fp, "PATCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.FIRST = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 12) - 1);
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.TOPOLOGY = ", prefix);
        switch (parsed) {
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_LOOP:
            fprintf(fp, "LINE_LOOP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_STRIP:
            fprintf(fp, "LINE_STRIP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLES:
            fprintf(fp, "TRIANGLES\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_STRIP:
            fprintf(fp, "TRIANGLE_STRIP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_FAN:
            fprintf(fp, "TRIANGLE_FAN\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUADS:
            fprintf(fp, "QUADS\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUAD_STRIP:
            fprintf(fp, "QUAD_STRIP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POLYGON:
            fprintf(fp, "POLYGON\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_PATCH:
            fprintf(fp, "PATCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.FIRST = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 12) - 1);
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.TOPOLOGY = ", prefix);
        switch (parsed) {
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_LOOP:
            fprintf(fp, "LINE_LOOP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_STRIP:
            fprintf(fp, "LINE_STRIP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLES:
            fprintf(fp, "TRIANGLES\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_STRIP:
            fprintf(fp, "TRIANGLE_STRIP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_FAN:
            fprintf(fp, "TRIANGLE_FAN\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUADS:
            fprintf(fp, "QUADS\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUAD_STRIP:
            fprintf(fp, "QUAD_STRIP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POLYGON:
            fprintf(fp, "POLYGON\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_PATCH:
            fprintf(fp, "PATCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.FIRST = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 12) - 1);
        fprintf(fp, "%s.COUNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.TOPOLOGY = ", prefix);
        switch (parsed) {
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POINTS:
            fprintf(fp, "POINTS\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINES:
            fprintf(fp, "LINES\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_LOOP:
            fprintf(fp, "LINE_LOOP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_STRIP:
            fprintf(fp, "LINE_STRIP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLES:
            fprintf(fp, "TRIANGLES\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_STRIP:
            fprintf(fp, "TRIANGLE_STRIP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_FAN:
            fprintf(fp, "TRIANGLE_FAN\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUADS:
            fprintf(fp, "QUADS\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUAD_STRIP:
            fprintf(fp, "QUAD_STRIP\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POLYGON:
            fprintf(fp, "POLYGON\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVC697_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_PATCH:
            fprintf(fp, "PATCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_DEPTH_BIAS_CLAMP:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "%ff (0x%x)\n", uif(parsed), parsed);
        break;
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(0):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(1):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(2):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(3):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(4):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(5):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(6):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(7):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(8):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(9):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(10):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(11):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(12):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(13):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(14):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_A(15):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.IS_INSTANCED = ", prefix);
        switch (parsed) {
        case NVC697_SET_VERTEX_STREAM_INSTANCE_A_IS_INSTANCED_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_VERTEX_STREAM_INSTANCE_A_IS_INSTANCED_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(0):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(1):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(2):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(3):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(4):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(5):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(6):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(7):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(8):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(9):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(10):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(11):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(12):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(13):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(14):
    case NVC697_SET_VERTEX_STREAM_INSTANCE_B(15):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.IS_INSTANCED = ", prefix);
        switch (parsed) {
        case NVC697_SET_VERTEX_STREAM_INSTANCE_B_IS_INSTANCED_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_VERTEX_STREAM_INSTANCE_B_IS_INSTANCED_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ATTRIBUTE_POINT_SIZE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ATTRIBUTE_POINT_SIZE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ATTRIBUTE_POINT_SIZE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 8) - 1);
        fprintf(fp, "%s.SLOT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_OGL_SET_CULL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_OGL_SET_CULL_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_OGL_SET_CULL_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_OGL_SET_FRONT_FACE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_OGL_SET_FRONT_FACE_V_CW:
            fprintf(fp, "CW\n");
            break;
        case NVC697_OGL_SET_FRONT_FACE_V_CCW:
            fprintf(fp, "CCW\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_OGL_SET_CULL_FACE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_OGL_SET_CULL_FACE_V_FRONT:
            fprintf(fp, "FRONT\n");
            break;
        case NVC697_OGL_SET_CULL_FACE_V_BACK:
            fprintf(fp, "BACK\n");
            break;
        case NVC697_OGL_SET_CULL_FACE_V_FRONT_AND_BACK:
            fprintf(fp, "FRONT_AND_BACK\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_VIEWPORT_PIXEL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.CENTER = ", prefix);
        switch (parsed) {
        case NVC697_SET_VIEWPORT_PIXEL_CENTER_AT_HALF_INTEGERS:
            fprintf(fp, "AT_HALF_INTEGERS\n");
            break;
        case NVC697_SET_VIEWPORT_PIXEL_CENTER_AT_INTEGERS:
            fprintf(fp, "AT_INTEGERS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_VIEWPORT_SCALE_OFFSET:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_VIEWPORT_SCALE_OFFSET_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_VIEWPORT_SCALE_OFFSET_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_VIEWPORT_CLIP_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.MIN_Z_ZERO_MAX_Z_ONE = ", prefix);
        switch (parsed) {
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_MIN_Z_ZERO_MAX_Z_ONE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_MIN_Z_ZERO_MAX_Z_ONE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 2) - 1);
        fprintf(fp, "%s.Z_CLIP_RANGE = ", prefix);
        switch (parsed) {
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_Z_CLIP_RANGE_USE_FIELD_MIN_Z_ZERO_MAX_Z_ONE:
            fprintf(fp, "USE_FIELD_MIN_Z_ZERO_MAX_Z_ONE\n");
            break;
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_Z_CLIP_RANGE_MIN_Z_MAX_Z:
            fprintf(fp, "MIN_Z_MAX_Z\n");
            break;
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_Z_CLIP_RANGE_ZERO_ONE:
            fprintf(fp, "ZERO_ONE\n");
            break;
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_Z_CLIP_RANGE_MINUS_INF_PLUS_INF:
            fprintf(fp, "MINUS_INF_PLUS_INF\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.PIXEL_MIN_Z = ", prefix);
        switch (parsed) {
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_PIXEL_MIN_Z_CLIP:
            fprintf(fp, "CLIP\n");
            break;
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_PIXEL_MIN_Z_CLAMP:
            fprintf(fp, "CLAMP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.PIXEL_MAX_Z = ", prefix);
        switch (parsed) {
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_PIXEL_MAX_Z_CLIP:
            fprintf(fp, "CLIP\n");
            break;
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_PIXEL_MAX_Z_CLAMP:
            fprintf(fp, "CLAMP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 1) - 1);
        fprintf(fp, "%s.GEOMETRY_GUARDBAND = ", prefix);
        switch (parsed) {
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_SCALE_256:
            fprintf(fp, "SCALE_256\n");
            break;
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_SCALE_1:
            fprintf(fp, "SCALE_1\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 10) & ((1u << 1) - 1);
        fprintf(fp, "%s.LINE_POINT_CULL_GUARDBAND = ", prefix);
        switch (parsed) {
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_LINE_POINT_CULL_GUARDBAND_SCALE_256:
            fprintf(fp, "SCALE_256\n");
            break;
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_LINE_POINT_CULL_GUARDBAND_SCALE_1:
            fprintf(fp, "SCALE_1\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 11) & ((1u << 3) - 1);
        fprintf(fp, "%s.GEOMETRY_CLIP = ", prefix);
        switch (parsed) {
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_WZERO_CLIP:
            fprintf(fp, "WZERO_CLIP\n");
            break;
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_PASSTHRU:
            fprintf(fp, "PASSTHRU\n");
            break;
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_FRUSTUM_XY_CLIP:
            fprintf(fp, "FRUSTUM_XY_CLIP\n");
            break;
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_FRUSTUM_XYZ_CLIP:
            fprintf(fp, "FRUSTUM_XYZ_CLIP\n");
            break;
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_WZERO_CLIP_NO_Z_CULL:
            fprintf(fp, "WZERO_CLIP_NO_Z_CULL\n");
            break;
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_FRUSTUM_Z_CLIP:
            fprintf(fp, "FRUSTUM_Z_CLIP\n");
            break;
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_WZERO_TRI_FILL_OR_CLIP:
            fprintf(fp, "WZERO_TRI_FILL_OR_CLIP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 2) - 1);
        fprintf(fp, "%s.GEOMETRY_GUARDBAND_Z = ", prefix);
        switch (parsed) {
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_Z_SAME_AS_XY_GUARDBAND:
            fprintf(fp, "SAME_AS_XY_GUARDBAND\n");
            break;
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_Z_SCALE_256:
            fprintf(fp, "SCALE_256\n");
            break;
        case NVC697_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_Z_SCALE_1:
            fprintf(fp, "SCALE_1\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_USER_CLIP_OP:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE0 = ", prefix);
        switch (parsed) {
        case NVC697_SET_USER_CLIP_OP_PLANE0_CLIP:
            fprintf(fp, "CLIP\n");
            break;
        case NVC697_SET_USER_CLIP_OP_PLANE0_CULL:
            fprintf(fp, "CULL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE1 = ", prefix);
        switch (parsed) {
        case NVC697_SET_USER_CLIP_OP_PLANE1_CLIP:
            fprintf(fp, "CLIP\n");
            break;
        case NVC697_SET_USER_CLIP_OP_PLANE1_CULL:
            fprintf(fp, "CULL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE2 = ", prefix);
        switch (parsed) {
        case NVC697_SET_USER_CLIP_OP_PLANE2_CLIP:
            fprintf(fp, "CLIP\n");
            break;
        case NVC697_SET_USER_CLIP_OP_PLANE2_CULL:
            fprintf(fp, "CULL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE3 = ", prefix);
        switch (parsed) {
        case NVC697_SET_USER_CLIP_OP_PLANE3_CLIP:
            fprintf(fp, "CLIP\n");
            break;
        case NVC697_SET_USER_CLIP_OP_PLANE3_CULL:
            fprintf(fp, "CULL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE4 = ", prefix);
        switch (parsed) {
        case NVC697_SET_USER_CLIP_OP_PLANE4_CLIP:
            fprintf(fp, "CLIP\n");
            break;
        case NVC697_SET_USER_CLIP_OP_PLANE4_CULL:
            fprintf(fp, "CULL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE5 = ", prefix);
        switch (parsed) {
        case NVC697_SET_USER_CLIP_OP_PLANE5_CLIP:
            fprintf(fp, "CLIP\n");
            break;
        case NVC697_SET_USER_CLIP_OP_PLANE5_CULL:
            fprintf(fp, "CULL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE6 = ", prefix);
        switch (parsed) {
        case NVC697_SET_USER_CLIP_OP_PLANE6_CLIP:
            fprintf(fp, "CLIP\n");
            break;
        case NVC697_SET_USER_CLIP_OP_PLANE6_CULL:
            fprintf(fp, "CULL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 28) & ((1u << 1) - 1);
        fprintf(fp, "%s.PLANE7 = ", prefix);
        switch (parsed) {
        case NVC697_SET_USER_CLIP_OP_PLANE7_CLIP:
            fprintf(fp, "CLIP\n");
            break;
        case NVC697_SET_USER_CLIP_OP_PLANE7_CULL:
            fprintf(fp, "CULL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_RENDER_ENABLE_OVERRIDE:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NVC697_SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE:
            fprintf(fp, "USE_RENDER_ENABLE\n");
            break;
        case NVC697_SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER:
            fprintf(fp, "ALWAYS_RENDER\n");
            break;
        case NVC697_SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER:
            fprintf(fp, "NEVER_RENDER\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_PRIMITIVE_TOPOLOGY_CONTROL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.OVERRIDE = ", prefix);
        switch (parsed) {
        case NVC697_SET_PRIMITIVE_TOPOLOGY_CONTROL_OVERRIDE_USE_TOPOLOGY_IN_BEGIN_METHODS:
            fprintf(fp, "USE_TOPOLOGY_IN_BEGIN_METHODS\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_CONTROL_OVERRIDE_USE_SEPARATE_TOPOLOGY_STATE:
            fprintf(fp, "USE_SEPARATE_TOPOLOGY_STATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_WINDOW_CLIP_ENABLE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_WINDOW_CLIP_ENABLE_V_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_WINDOW_CLIP_ENABLE_V_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_WINDOW_CLIP_TYPE:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_WINDOW_CLIP_TYPE_V_INCLUSIVE:
            fprintf(fp, "INCLUSIVE\n");
            break;
        case NVC697_SET_WINDOW_CLIP_TYPE_V_EXCLUSIVE:
            fprintf(fp, "EXCLUSIVE\n");
            break;
        case NVC697_SET_WINDOW_CLIP_TYPE_V_CLIPALL:
            fprintf(fp, "CLIPALL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_INVALIDATE_ZCULL:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_INVALIDATE_ZCULL_V_INVALIDATE:
            fprintf(fp, "INVALIDATE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ZCULL:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.Z_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZCULL_Z_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ZCULL_Z_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.STENCIL_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZCULL_STENCIL_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ZCULL_STENCIL_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_ZCULL_BOUNDS:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.Z_MIN_UNBOUNDED_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZCULL_BOUNDS_Z_MIN_UNBOUNDED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ZCULL_BOUNDS_Z_MIN_UNBOUNDED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.Z_MAX_UNBOUNDED_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_ZCULL_BOUNDS_Z_MAX_UNBOUNDED_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_ZCULL_BOUNDS_Z_MAX_UNBOUNDED_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_PRIMITIVE_TOPOLOGY:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_POINTLIST:
            fprintf(fp, "POINTLIST\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_LINELIST:
            fprintf(fp, "LINELIST\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_LINESTRIP:
            fprintf(fp, "LINESTRIP\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_TRIANGLELIST:
            fprintf(fp, "TRIANGLELIST\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_TRIANGLESTRIP:
            fprintf(fp, "TRIANGLESTRIP\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_LINELIST_ADJCY:
            fprintf(fp, "LINELIST_ADJCY\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_LINESTRIP_ADJCY:
            fprintf(fp, "LINESTRIP_ADJCY\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_TRIANGLELIST_ADJCY:
            fprintf(fp, "TRIANGLELIST_ADJCY\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_TRIANGLESTRIP_ADJCY:
            fprintf(fp, "TRIANGLESTRIP_ADJCY\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_PATCHLIST:
            fprintf(fp, "PATCHLIST\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_POINTS:
            fprintf(fp, "LEGACY_POINTS\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDLINELIST:
            fprintf(fp, "LEGACY_INDEXEDLINELIST\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDTRIANGLELIST:
            fprintf(fp, "LEGACY_INDEXEDTRIANGLELIST\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_LINELIST:
            fprintf(fp, "LEGACY_LINELIST\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_LINESTRIP:
            fprintf(fp, "LEGACY_LINESTRIP\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDLINESTRIP:
            fprintf(fp, "LEGACY_INDEXEDLINESTRIP\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_TRIANGLELIST:
            fprintf(fp, "LEGACY_TRIANGLELIST\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_TRIANGLESTRIP:
            fprintf(fp, "LEGACY_TRIANGLESTRIP\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDTRIANGLESTRIP:
            fprintf(fp, "LEGACY_INDEXEDTRIANGLESTRIP\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_TRIANGLEFAN:
            fprintf(fp, "LEGACY_TRIANGLEFAN\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDTRIANGLEFAN:
            fprintf(fp, "LEGACY_INDEXEDTRIANGLEFAN\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_TRIANGLEFAN_IMM:
            fprintf(fp, "LEGACY_TRIANGLEFAN_IMM\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_LINELIST_IMM:
            fprintf(fp, "LEGACY_LINELIST_IMM\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDTRIANGLELIST2:
            fprintf(fp, "LEGACY_INDEXEDTRIANGLELIST2\n");
            break;
        case NVC697_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDLINELIST2:
            fprintf(fp, "LEGACY_INDEXEDLINELIST2\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_ZCULL_SYNC:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_CLIP_ID_TEST:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_CLIP_ID_TEST_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_CLIP_ID_TEST_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_SURFACE_CLIP_ID_WIDTH:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_CLIP_ID:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_DEPTH_BOUNDS_TEST:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_DEPTH_BOUNDS_TEST_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_DEPTH_BOUNDS_TEST_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BLEND_FLOAT_OPTION:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ZERO_TIMES_ANYTHING_IS_ZERO = ", prefix);
        switch (parsed) {
        case NVC697_SET_BLEND_FLOAT_OPTION_ZERO_TIMES_ANYTHING_IS_ZERO_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_BLEND_FLOAT_OPTION_ZERO_TIMES_ANYTHING_IS_ZERO_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_LOGIC_OP:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_LOGIC_OP_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_LOGIC_OP_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_LOGIC_OP_FUNC:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_LOGIC_OP_FUNC_V_CLEAR:
            fprintf(fp, "CLEAR\n");
            break;
        case NVC697_SET_LOGIC_OP_FUNC_V_AND:
            fprintf(fp, "AND\n");
            break;
        case NVC697_SET_LOGIC_OP_FUNC_V_AND_REVERSE:
            fprintf(fp, "AND_REVERSE\n");
            break;
        case NVC697_SET_LOGIC_OP_FUNC_V_COPY:
            fprintf(fp, "COPY\n");
            break;
        case NVC697_SET_LOGIC_OP_FUNC_V_AND_INVERTED:
            fprintf(fp, "AND_INVERTED\n");
            break;
        case NVC697_SET_LOGIC_OP_FUNC_V_NOOP:
            fprintf(fp, "NOOP\n");
            break;
        case NVC697_SET_LOGIC_OP_FUNC_V_XOR:
            fprintf(fp, "XOR\n");
            break;
        case NVC697_SET_LOGIC_OP_FUNC_V_OR:
            fprintf(fp, "OR\n");
            break;
        case NVC697_SET_LOGIC_OP_FUNC_V_NOR:
            fprintf(fp, "NOR\n");
            break;
        case NVC697_SET_LOGIC_OP_FUNC_V_EQUIV:
            fprintf(fp, "EQUIV\n");
            break;
        case NVC697_SET_LOGIC_OP_FUNC_V_INVERT:
            fprintf(fp, "INVERT\n");
            break;
        case NVC697_SET_LOGIC_OP_FUNC_V_OR_REVERSE:
            fprintf(fp, "OR_REVERSE\n");
            break;
        case NVC697_SET_LOGIC_OP_FUNC_V_COPY_INVERTED:
            fprintf(fp, "COPY_INVERTED\n");
            break;
        case NVC697_SET_LOGIC_OP_FUNC_V_OR_INVERTED:
            fprintf(fp, "OR_INVERTED\n");
            break;
        case NVC697_SET_LOGIC_OP_FUNC_V_NAND:
            fprintf(fp, "NAND\n");
            break;
        case NVC697_SET_LOGIC_OP_FUNC_V_SET:
            fprintf(fp, "SET\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_Z_COMPRESSION:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_Z_COMPRESSION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_Z_COMPRESSION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_CLEAR_SURFACE:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.Z_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_CLEAR_SURFACE_Z_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_CLEAR_SURFACE_Z_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.STENCIL_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_CLEAR_SURFACE_STENCIL_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_CLEAR_SURFACE_STENCIL_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.R_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_CLEAR_SURFACE_R_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_CLEAR_SURFACE_R_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.G_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_CLEAR_SURFACE_G_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_CLEAR_SURFACE_G_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.B_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_CLEAR_SURFACE_B_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_CLEAR_SURFACE_B_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 1) - 1);
        fprintf(fp, "%s.A_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_CLEAR_SURFACE_A_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_CLEAR_SURFACE_A_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 6) & ((1u << 4) - 1);
        fprintf(fp, "%s.MRT_SELECT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 10) & ((1u << 16) - 1);
        fprintf(fp, "%s.RT_ARRAY_INDEX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_CLEAR_CLIP_ID_SURFACE:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_COLOR_COMPRESSION(0):
    case NVC697_SET_COLOR_COMPRESSION(1):
    case NVC697_SET_COLOR_COMPRESSION(2):
    case NVC697_SET_COLOR_COMPRESSION(3):
    case NVC697_SET_COLOR_COMPRESSION(4):
    case NVC697_SET_COLOR_COMPRESSION(5):
    case NVC697_SET_COLOR_COMPRESSION(6):
    case NVC697_SET_COLOR_COMPRESSION(7):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_COLOR_COMPRESSION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_COLOR_COMPRESSION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_CT_WRITE(0):
    case NVC697_SET_CT_WRITE(1):
    case NVC697_SET_CT_WRITE(2):
    case NVC697_SET_CT_WRITE(3):
    case NVC697_SET_CT_WRITE(4):
    case NVC697_SET_CT_WRITE(5):
    case NVC697_SET_CT_WRITE(6):
    case NVC697_SET_CT_WRITE(7):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.R_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_CT_WRITE_R_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_CT_WRITE_R_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.G_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_CT_WRITE_G_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_CT_WRITE_G_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.B_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_CT_WRITE_B_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_CT_WRITE_B_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.A_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_CT_WRITE_A_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_CT_WRITE_A_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_PIPE_NOP:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SPARE00:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SPARE01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SPARE02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SPARE03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_REPORT_SEMAPHORE_A:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_REPORT_SEMAPHORE_B:
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_REPORT_SEMAPHORE_C:
    
        parsed = data;
        fprintf(fp, "%s.PAYLOAD = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_REPORT_SEMAPHORE_D:
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.OPERATION = ", prefix);
        switch (parsed) {
        case NVC697_SET_REPORT_SEMAPHORE_D_OPERATION_RELEASE:
            fprintf(fp, "RELEASE\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_OPERATION_ACQUIRE:
            fprintf(fp, "ACQUIRE\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_OPERATION_REPORT_ONLY:
            fprintf(fp, "REPORT_ONLY\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_OPERATION_TRAP:
            fprintf(fp, "TRAP\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.RELEASE = ", prefix);
        switch (parsed) {
        case NVC697_SET_REPORT_SEMAPHORE_D_RELEASE_AFTER_ALL_PRECEEDING_READS_COMPLETE:
            fprintf(fp, "AFTER_ALL_PRECEEDING_READS_COMPLETE\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_RELEASE_AFTER_ALL_PRECEEDING_WRITES_COMPLETE:
            fprintf(fp, "AFTER_ALL_PRECEEDING_WRITES_COMPLETE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.ACQUIRE = ", prefix);
        switch (parsed) {
        case NVC697_SET_REPORT_SEMAPHORE_D_ACQUIRE_BEFORE_ANY_FOLLOWING_WRITES_START:
            fprintf(fp, "BEFORE_ANY_FOLLOWING_WRITES_START\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_ACQUIRE_BEFORE_ANY_FOLLOWING_READS_START:
            fprintf(fp, "BEFORE_ANY_FOLLOWING_READS_START\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 4) - 1);
        fprintf(fp, "%s.PIPELINE_LOCATION = ", prefix);
        switch (parsed) {
        case NVC697_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_DATA_ASSEMBLER:
            fprintf(fp, "DATA_ASSEMBLER\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_VERTEX_SHADER:
            fprintf(fp, "VERTEX_SHADER\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_TESSELATION_INIT_SHADER:
            fprintf(fp, "TESSELATION_INIT_SHADER\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_TESSELATION_SHADER:
            fprintf(fp, "TESSELATION_SHADER\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_GEOMETRY_SHADER:
            fprintf(fp, "GEOMETRY_SHADER\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_STREAMING_OUTPUT:
            fprintf(fp, "STREAMING_OUTPUT\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_VPC:
            fprintf(fp, "VPC\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_ZCULL:
            fprintf(fp, "ZCULL\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_PIXEL_SHADER:
            fprintf(fp, "PIXEL_SHADER\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_DEPTH_TEST:
            fprintf(fp, "DEPTH_TEST\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_ALL:
            fprintf(fp, "ALL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.COMPARISON = ", prefix);
        switch (parsed) {
        case NVC697_SET_REPORT_SEMAPHORE_D_COMPARISON_EQ:
            fprintf(fp, "EQ\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_COMPARISON_GE:
            fprintf(fp, "GE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.AWAKEN_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 23) & ((1u << 5) - 1);
        fprintf(fp, "%s.REPORT = ", prefix);
        switch (parsed) {
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_DA_VERTICES_GENERATED:
            fprintf(fp, "DA_VERTICES_GENERATED\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_DA_PRIMITIVES_GENERATED:
            fprintf(fp, "DA_PRIMITIVES_GENERATED\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_VS_INVOCATIONS:
            fprintf(fp, "VS_INVOCATIONS\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_TI_INVOCATIONS:
            fprintf(fp, "TI_INVOCATIONS\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_TS_INVOCATIONS:
            fprintf(fp, "TS_INVOCATIONS\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_TS_PRIMITIVES_GENERATED:
            fprintf(fp, "TS_PRIMITIVES_GENERATED\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_GS_INVOCATIONS:
            fprintf(fp, "GS_INVOCATIONS\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_GS_PRIMITIVES_GENERATED:
            fprintf(fp, "GS_PRIMITIVES_GENERATED\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_ALPHA_BETA_CLOCKS:
            fprintf(fp, "ALPHA_BETA_CLOCKS\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_SCG_CLOCKS:
            fprintf(fp, "SCG_CLOCKS\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_VTG_PRIMITIVES_OUT:
            fprintf(fp, "VTG_PRIMITIVES_OUT\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED:
            fprintf(fp, "TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_PRIMITIVES_SUCCEEDED:
            fprintf(fp, "STREAMING_PRIMITIVES_SUCCEEDED\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_PRIMITIVES_NEEDED:
            fprintf(fp, "STREAMING_PRIMITIVES_NEEDED\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED:
            fprintf(fp, "STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_BYTE_COUNT:
            fprintf(fp, "STREAMING_BYTE_COUNT\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_CLIPPER_INVOCATIONS:
            fprintf(fp, "CLIPPER_INVOCATIONS\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_CLIPPER_PRIMITIVES_GENERATED:
            fprintf(fp, "CLIPPER_PRIMITIVES_GENERATED\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS0:
            fprintf(fp, "ZCULL_STATS0\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS1:
            fprintf(fp, "ZCULL_STATS1\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS2:
            fprintf(fp, "ZCULL_STATS2\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS3:
            fprintf(fp, "ZCULL_STATS3\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_PS_INVOCATIONS:
            fprintf(fp, "PS_INVOCATIONS\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_ZPASS_PIXEL_CNT:
            fprintf(fp, "ZPASS_PIXEL_CNT\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_ZPASS_PIXEL_CNT64:
            fprintf(fp, "ZPASS_PIXEL_CNT64\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_TILED_ZPASS_PIXEL_CNT64:
            fprintf(fp, "TILED_ZPASS_PIXEL_CNT64\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_IEEE_CLEAN_COLOR_TARGET:
            fprintf(fp, "IEEE_CLEAN_COLOR_TARGET\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_IEEE_CLEAN_ZETA_TARGET:
            fprintf(fp, "IEEE_CLEAN_ZETA_TARGET\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REPORT_BOUNDING_RECTANGLE:
            fprintf(fp, "BOUNDING_RECTANGLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 28) & ((1u << 1) - 1);
        fprintf(fp, "%s.STRUCTURE_SIZE = ", prefix);
        switch (parsed) {
        case NVC697_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_FOUR_WORDS:
            fprintf(fp, "FOUR_WORDS\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_ONE_WORD:
            fprintf(fp, "ONE_WORD\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 3) - 1);
        fprintf(fp, "%s.SUB_REPORT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 21) & ((1u << 1) - 1);
        fprintf(fp, "%s.REPORT_DWORD_NUMBER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLUSH_DISABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.REDUCTION_ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 3) - 1);
        fprintf(fp, "%s.REDUCTION_OP = ", prefix);
        switch (parsed) {
        case NVC697_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_ADD:
            fprintf(fp, "RED_ADD\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MIN:
            fprintf(fp, "RED_MIN\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MAX:
            fprintf(fp, "RED_MAX\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_INC:
            fprintf(fp, "RED_INC\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_DEC:
            fprintf(fp, "RED_DEC\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_AND:
            fprintf(fp, "RED_AND\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_OR:
            fprintf(fp, "RED_OR\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_XOR:
            fprintf(fp, "RED_XOR\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 17) & ((1u << 2) - 1);
        fprintf(fp, "%s.REDUCTION_FORMAT = ", prefix);
        switch (parsed) {
        case NVC697_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_UNSIGNED_32:
            fprintf(fp, "UNSIGNED_32\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_SIGNED_32:
            fprintf(fp, "SIGNED_32\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 19) & ((1u << 1) - 1);
        fprintf(fp, "%s.CONDITIONAL_TRAP = ", prefix);
        switch (parsed) {
        case NVC697_SET_REPORT_SEMAPHORE_D_CONDITIONAL_TRAP_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_REPORT_SEMAPHORE_D_CONDITIONAL_TRAP_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(0):
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(1):
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(2):
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(3):
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(4):
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(5):
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(6):
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(7):
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(8):
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(9):
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(10):
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(11):
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(12):
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(13):
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(14):
    case NVC697_SET_VERTEX_STREAM_A_FORMAT(15):
    
        parsed = (data >> 0) & ((1u << 12) - 1);
        fprintf(fp, "%s.STRIDE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_VERTEX_STREAM_A_FORMAT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_VERTEX_STREAM_A_FORMAT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(0):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(1):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(2):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(3):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(4):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(5):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(6):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(7):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(8):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(9):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(10):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(11):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(12):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(13):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(14):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_A(15):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(0):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(1):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(2):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(3):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(4):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(5):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(6):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(7):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(8):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(9):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(10):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(11):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(12):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(13):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(14):
    case NVC697_SET_VERTEX_STREAM_A_LOCATION_B(15):
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(0):
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(1):
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(2):
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(3):
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(4):
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(5):
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(6):
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(7):
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(8):
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(9):
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(10):
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(11):
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(12):
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(13):
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(14):
    case NVC697_SET_VERTEX_STREAM_A_FREQUENCY(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(0):
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(1):
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(2):
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(3):
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(4):
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(5):
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(6):
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(7):
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(8):
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(9):
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(10):
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(11):
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(12):
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(13):
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(14):
    case NVC697_SET_VERTEX_STREAM_B_FORMAT(15):
    
        parsed = (data >> 0) & ((1u << 12) - 1);
        fprintf(fp, "%s.STRIDE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_VERTEX_STREAM_B_FORMAT_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_VERTEX_STREAM_B_FORMAT_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(0):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(1):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(2):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(3):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(4):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(5):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(6):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(7):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(8):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(9):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(10):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(11):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(12):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(13):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(14):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_A(15):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.OFFSET_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(0):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(1):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(2):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(3):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(4):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(5):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(6):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(7):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(8):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(9):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(10):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(11):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(12):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(13):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(14):
    case NVC697_SET_VERTEX_STREAM_B_LOCATION_B(15):
    
        parsed = data;
        fprintf(fp, "%s.OFFSET_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(0):
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(1):
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(2):
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(3):
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(4):
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(5):
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(6):
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(7):
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(8):
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(9):
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(10):
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(11):
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(12):
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(13):
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(14):
    case NVC697_SET_VERTEX_STREAM_B_FREQUENCY(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(0):
    case NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(1):
    case NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(2):
    case NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(3):
    case NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(4):
    case NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(5):
    case NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(6):
    case NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(7):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BLEND_PER_TARGET_COLOR_OP(0):
    case NVC697_SET_BLEND_PER_TARGET_COLOR_OP(1):
    case NVC697_SET_BLEND_PER_TARGET_COLOR_OP(2):
    case NVC697_SET_BLEND_PER_TARGET_COLOR_OP(3):
    case NVC697_SET_BLEND_PER_TARGET_COLOR_OP(4):
    case NVC697_SET_BLEND_PER_TARGET_COLOR_OP(5):
    case NVC697_SET_BLEND_PER_TARGET_COLOR_OP(6):
    case NVC697_SET_BLEND_PER_TARGET_COLOR_OP(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_FUNC_SUBTRACT:
            fprintf(fp, "OGL_FUNC_SUBTRACT\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_FUNC_REVERSE_SUBTRACT:
            fprintf(fp, "OGL_FUNC_REVERSE_SUBTRACT\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_FUNC_ADD:
            fprintf(fp, "OGL_FUNC_ADD\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_MIN:
            fprintf(fp, "OGL_MIN\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_MAX:
            fprintf(fp, "OGL_MAX\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_ADD:
            fprintf(fp, "D3D_ADD\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_SUBTRACT:
            fprintf(fp, "D3D_SUBTRACT\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_REVSUBTRACT:
            fprintf(fp, "D3D_REVSUBTRACT\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_MIN:
            fprintf(fp, "D3D_MIN\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_MAX:
            fprintf(fp, "D3D_MAX\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(0):
    case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(1):
    case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(2):
    case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(3):
    case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(4):
    case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(5):
    case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(6):
    case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE:
            fprintf(fp, "OGL_ONE\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC_COLOR:
            fprintf(fp, "OGL_SRC_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_SRC_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC_ALPHA:
            fprintf(fp, "OGL_SRC_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_SRC_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_DST_ALPHA:
            fprintf(fp, "OGL_DST_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_DST_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_DST_COLOR:
            fprintf(fp, "OGL_DST_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_DST_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC_ALPHA_SATURATE:
            fprintf(fp, "OGL_SRC_ALPHA_SATURATE\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_CONSTANT_COLOR:
            fprintf(fp, "OGL_CONSTANT_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_CONSTANT_ALPHA:
            fprintf(fp, "OGL_CONSTANT_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC1COLOR:
            fprintf(fp, "OGL_SRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_INVSRC1COLOR:
            fprintf(fp, "OGL_INVSRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC1ALPHA:
            fprintf(fp, "OGL_SRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_INVSRC1ALPHA:
            fprintf(fp, "OGL_INVSRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_ONE:
            fprintf(fp, "D3D_ONE\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRCCOLOR:
            fprintf(fp, "D3D_SRCCOLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVSRCCOLOR:
            fprintf(fp, "D3D_INVSRCCOLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRCALPHA:
            fprintf(fp, "D3D_SRCALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVSRCALPHA:
            fprintf(fp, "D3D_INVSRCALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_DESTALPHA:
            fprintf(fp, "D3D_DESTALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVDESTALPHA:
            fprintf(fp, "D3D_INVDESTALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_DESTCOLOR:
            fprintf(fp, "D3D_DESTCOLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVDESTCOLOR:
            fprintf(fp, "D3D_INVDESTCOLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRCALPHASAT:
            fprintf(fp, "D3D_SRCALPHASAT\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_BOTHSRCALPHA:
            fprintf(fp, "D3D_BOTHSRCALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_BOTHINVSRCALPHA:
            fprintf(fp, "D3D_BOTHINVSRCALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_BLENDFACTOR:
            fprintf(fp, "D3D_BLENDFACTOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVBLENDFACTOR:
            fprintf(fp, "D3D_INVBLENDFACTOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRC1COLOR:
            fprintf(fp, "D3D_SRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVSRC1COLOR:
            fprintf(fp, "D3D_INVSRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRC1ALPHA:
            fprintf(fp, "D3D_SRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVSRC1ALPHA:
            fprintf(fp, "D3D_INVSRC1ALPHA\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(0):
    case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(1):
    case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(2):
    case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(3):
    case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(4):
    case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(5):
    case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(6):
    case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE:
            fprintf(fp, "OGL_ONE\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC_COLOR:
            fprintf(fp, "OGL_SRC_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_SRC_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_SRC_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC_ALPHA:
            fprintf(fp, "OGL_SRC_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_SRC_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_DST_ALPHA:
            fprintf(fp, "OGL_DST_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_DST_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_DST_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_DST_COLOR:
            fprintf(fp, "OGL_DST_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_DST_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_DST_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC_ALPHA_SATURATE:
            fprintf(fp, "OGL_SRC_ALPHA_SATURATE\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_CONSTANT_COLOR:
            fprintf(fp, "OGL_CONSTANT_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_CONSTANT_ALPHA:
            fprintf(fp, "OGL_CONSTANT_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC1COLOR:
            fprintf(fp, "OGL_SRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_INVSRC1COLOR:
            fprintf(fp, "OGL_INVSRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC1ALPHA:
            fprintf(fp, "OGL_SRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_INVSRC1ALPHA:
            fprintf(fp, "OGL_INVSRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_ONE:
            fprintf(fp, "D3D_ONE\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRCCOLOR:
            fprintf(fp, "D3D_SRCCOLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVSRCCOLOR:
            fprintf(fp, "D3D_INVSRCCOLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRCALPHA:
            fprintf(fp, "D3D_SRCALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVSRCALPHA:
            fprintf(fp, "D3D_INVSRCALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_DESTALPHA:
            fprintf(fp, "D3D_DESTALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVDESTALPHA:
            fprintf(fp, "D3D_INVDESTALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_DESTCOLOR:
            fprintf(fp, "D3D_DESTCOLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVDESTCOLOR:
            fprintf(fp, "D3D_INVDESTCOLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRCALPHASAT:
            fprintf(fp, "D3D_SRCALPHASAT\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_BLENDFACTOR:
            fprintf(fp, "D3D_BLENDFACTOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVBLENDFACTOR:
            fprintf(fp, "D3D_INVBLENDFACTOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRC1COLOR:
            fprintf(fp, "D3D_SRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVSRC1COLOR:
            fprintf(fp, "D3D_INVSRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRC1ALPHA:
            fprintf(fp, "D3D_SRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVSRC1ALPHA:
            fprintf(fp, "D3D_INVSRC1ALPHA\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(0):
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(1):
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(2):
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(3):
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(4):
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(5):
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(6):
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_FUNC_SUBTRACT:
            fprintf(fp, "OGL_FUNC_SUBTRACT\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_FUNC_REVERSE_SUBTRACT:
            fprintf(fp, "OGL_FUNC_REVERSE_SUBTRACT\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_FUNC_ADD:
            fprintf(fp, "OGL_FUNC_ADD\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_MIN:
            fprintf(fp, "OGL_MIN\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_MAX:
            fprintf(fp, "OGL_MAX\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_ADD:
            fprintf(fp, "D3D_ADD\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_SUBTRACT:
            fprintf(fp, "D3D_SUBTRACT\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_REVSUBTRACT:
            fprintf(fp, "D3D_REVSUBTRACT\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_MIN:
            fprintf(fp, "D3D_MIN\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_MAX:
            fprintf(fp, "D3D_MAX\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(0):
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(1):
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(2):
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(3):
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(4):
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(5):
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(6):
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE:
            fprintf(fp, "OGL_ONE\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC_COLOR:
            fprintf(fp, "OGL_SRC_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_SRC_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC_ALPHA:
            fprintf(fp, "OGL_SRC_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_SRC_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_DST_ALPHA:
            fprintf(fp, "OGL_DST_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_DST_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_DST_COLOR:
            fprintf(fp, "OGL_DST_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_DST_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC_ALPHA_SATURATE:
            fprintf(fp, "OGL_SRC_ALPHA_SATURATE\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_CONSTANT_COLOR:
            fprintf(fp, "OGL_CONSTANT_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_CONSTANT_ALPHA:
            fprintf(fp, "OGL_CONSTANT_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC1COLOR:
            fprintf(fp, "OGL_SRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_INVSRC1COLOR:
            fprintf(fp, "OGL_INVSRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC1ALPHA:
            fprintf(fp, "OGL_SRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_INVSRC1ALPHA:
            fprintf(fp, "OGL_INVSRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_ONE:
            fprintf(fp, "D3D_ONE\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRCCOLOR:
            fprintf(fp, "D3D_SRCCOLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVSRCCOLOR:
            fprintf(fp, "D3D_INVSRCCOLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRCALPHA:
            fprintf(fp, "D3D_SRCALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVSRCALPHA:
            fprintf(fp, "D3D_INVSRCALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_DESTALPHA:
            fprintf(fp, "D3D_DESTALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVDESTALPHA:
            fprintf(fp, "D3D_INVDESTALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_DESTCOLOR:
            fprintf(fp, "D3D_DESTCOLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVDESTCOLOR:
            fprintf(fp, "D3D_INVDESTCOLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRCALPHASAT:
            fprintf(fp, "D3D_SRCALPHASAT\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_BOTHSRCALPHA:
            fprintf(fp, "D3D_BOTHSRCALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_BOTHINVSRCALPHA:
            fprintf(fp, "D3D_BOTHINVSRCALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_BLENDFACTOR:
            fprintf(fp, "D3D_BLENDFACTOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVBLENDFACTOR:
            fprintf(fp, "D3D_INVBLENDFACTOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRC1COLOR:
            fprintf(fp, "D3D_SRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVSRC1COLOR:
            fprintf(fp, "D3D_INVSRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRC1ALPHA:
            fprintf(fp, "D3D_SRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVSRC1ALPHA:
            fprintf(fp, "D3D_INVSRC1ALPHA\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(0):
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(1):
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(2):
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(3):
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(4):
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(5):
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(6):
    case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        switch (parsed) {
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ZERO:
            fprintf(fp, "OGL_ZERO\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE:
            fprintf(fp, "OGL_ONE\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC_COLOR:
            fprintf(fp, "OGL_SRC_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_SRC_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_SRC_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC_ALPHA:
            fprintf(fp, "OGL_SRC_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_SRC_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_DST_ALPHA:
            fprintf(fp, "OGL_DST_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_DST_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_DST_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_DST_COLOR:
            fprintf(fp, "OGL_DST_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_DST_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_DST_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC_ALPHA_SATURATE:
            fprintf(fp, "OGL_SRC_ALPHA_SATURATE\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_CONSTANT_COLOR:
            fprintf(fp, "OGL_CONSTANT_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_CONSTANT_ALPHA:
            fprintf(fp, "OGL_CONSTANT_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA:
            fprintf(fp, "OGL_ONE_MINUS_CONSTANT_ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC1COLOR:
            fprintf(fp, "OGL_SRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_INVSRC1COLOR:
            fprintf(fp, "OGL_INVSRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC1ALPHA:
            fprintf(fp, "OGL_SRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_INVSRC1ALPHA:
            fprintf(fp, "OGL_INVSRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_ZERO:
            fprintf(fp, "D3D_ZERO\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_ONE:
            fprintf(fp, "D3D_ONE\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRCCOLOR:
            fprintf(fp, "D3D_SRCCOLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVSRCCOLOR:
            fprintf(fp, "D3D_INVSRCCOLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRCALPHA:
            fprintf(fp, "D3D_SRCALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVSRCALPHA:
            fprintf(fp, "D3D_INVSRCALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_DESTALPHA:
            fprintf(fp, "D3D_DESTALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVDESTALPHA:
            fprintf(fp, "D3D_INVDESTALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_DESTCOLOR:
            fprintf(fp, "D3D_DESTCOLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVDESTCOLOR:
            fprintf(fp, "D3D_INVDESTCOLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRCALPHASAT:
            fprintf(fp, "D3D_SRCALPHASAT\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_BLENDFACTOR:
            fprintf(fp, "D3D_BLENDFACTOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVBLENDFACTOR:
            fprintf(fp, "D3D_INVBLENDFACTOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRC1COLOR:
            fprintf(fp, "D3D_SRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVSRC1COLOR:
            fprintf(fp, "D3D_INVSRC1COLOR\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRC1ALPHA:
            fprintf(fp, "D3D_SRC1ALPHA\n");
            break;
        case NVC697_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVSRC1ALPHA:
            fprintf(fp, "D3D_INVSRC1ALPHA\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_PIPELINE_SHADER(0):
    case NVC697_SET_PIPELINE_SHADER(1):
    case NVC697_SET_PIPELINE_SHADER(2):
    case NVC697_SET_PIPELINE_SHADER(3):
    case NVC697_SET_PIPELINE_SHADER(4):
    case NVC697_SET_PIPELINE_SHADER(5):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_PIPELINE_SHADER_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_PIPELINE_SHADER_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.TYPE = ", prefix);
        switch (parsed) {
        case NVC697_SET_PIPELINE_SHADER_TYPE_VERTEX_CULL_BEFORE_FETCH:
            fprintf(fp, "VERTEX_CULL_BEFORE_FETCH\n");
            break;
        case NVC697_SET_PIPELINE_SHADER_TYPE_VERTEX:
            fprintf(fp, "VERTEX\n");
            break;
        case NVC697_SET_PIPELINE_SHADER_TYPE_TESSELLATION_INIT:
            fprintf(fp, "TESSELLATION_INIT\n");
            break;
        case NVC697_SET_PIPELINE_SHADER_TYPE_TESSELLATION:
            fprintf(fp, "TESSELLATION\n");
            break;
        case NVC697_SET_PIPELINE_SHADER_TYPE_GEOMETRY:
            fprintf(fp, "GEOMETRY\n");
            break;
        case NVC697_SET_PIPELINE_SHADER_TYPE_PIXEL:
            fprintf(fp, "PIXEL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_PIPELINE_RESERVED_B(0):
    case NVC697_SET_PIPELINE_RESERVED_B(1):
    case NVC697_SET_PIPELINE_RESERVED_B(2):
    case NVC697_SET_PIPELINE_RESERVED_B(3):
    case NVC697_SET_PIPELINE_RESERVED_B(4):
    case NVC697_SET_PIPELINE_RESERVED_B(5):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_PIPELINE_RESERVED_A(0):
    case NVC697_SET_PIPELINE_RESERVED_A(1):
    case NVC697_SET_PIPELINE_RESERVED_A(2):
    case NVC697_SET_PIPELINE_RESERVED_A(3):
    case NVC697_SET_PIPELINE_RESERVED_A(4):
    case NVC697_SET_PIPELINE_RESERVED_A(5):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_PIPELINE_REGISTER_COUNT(0):
    case NVC697_SET_PIPELINE_REGISTER_COUNT(1):
    case NVC697_SET_PIPELINE_REGISTER_COUNT(2):
    case NVC697_SET_PIPELINE_REGISTER_COUNT(3):
    case NVC697_SET_PIPELINE_REGISTER_COUNT(4):
    case NVC697_SET_PIPELINE_REGISTER_COUNT(5):
    
        parsed = (data >> 0) & ((1u << 9) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_PIPELINE_BINDING(0):
    case NVC697_SET_PIPELINE_BINDING(1):
    case NVC697_SET_PIPELINE_BINDING(2):
    case NVC697_SET_PIPELINE_BINDING(3):
    case NVC697_SET_PIPELINE_BINDING(4):
    case NVC697_SET_PIPELINE_BINDING(5):
    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.GROUP = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_A(0):
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_A(1):
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_A(2):
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_A(3):
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_A(4):
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_A(5):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_B(0):
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_B(1):
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_B(2):
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_B(3):
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_B(4):
    case NVC697_SET_PIPELINE_PROGRAM_ADDRESS_B(5):
    
        parsed = data;
        fprintf(fp, "%s.LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_PIPELINE_RESERVED_D(0):
    case NVC697_SET_PIPELINE_RESERVED_D(1):
    case NVC697_SET_PIPELINE_RESERVED_D(2):
    case NVC697_SET_PIPELINE_RESERVED_D(3):
    case NVC697_SET_PIPELINE_RESERVED_D(4):
    case NVC697_SET_PIPELINE_RESERVED_D(5):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_PIPELINE_RESERVED_E(0):
    case NVC697_SET_PIPELINE_RESERVED_E(1):
    case NVC697_SET_PIPELINE_RESERVED_E(2):
    case NVC697_SET_PIPELINE_RESERVED_E(3):
    case NVC697_SET_PIPELINE_RESERVED_E(4):
    case NVC697_SET_PIPELINE_RESERVED_E(5):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON00:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON01:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON02:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON03:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON04:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON05:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON06:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON07:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON08:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON09:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON10:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON11:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON12:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON13:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON14:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON15:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON16:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON17:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON18:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON19:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON20:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON21:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON22:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON23:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON24:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON25:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON26:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON27:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON28:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON29:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON30:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_FALCON31:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_CONSTANT_BUFFER_SELECTOR_A:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.SIZE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_CONSTANT_BUFFER_SELECTOR_B:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_CONSTANT_BUFFER_SELECTOR_C:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_LOAD_CONSTANT_BUFFER_OFFSET:
    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_LOAD_CONSTANT_BUFFER(0):
    case NVC697_LOAD_CONSTANT_BUFFER(1):
    case NVC697_LOAD_CONSTANT_BUFFER(2):
    case NVC697_LOAD_CONSTANT_BUFFER(3):
    case NVC697_LOAD_CONSTANT_BUFFER(4):
    case NVC697_LOAD_CONSTANT_BUFFER(5):
    case NVC697_LOAD_CONSTANT_BUFFER(6):
    case NVC697_LOAD_CONSTANT_BUFFER(7):
    case NVC697_LOAD_CONSTANT_BUFFER(8):
    case NVC697_LOAD_CONSTANT_BUFFER(9):
    case NVC697_LOAD_CONSTANT_BUFFER(10):
    case NVC697_LOAD_CONSTANT_BUFFER(11):
    case NVC697_LOAD_CONSTANT_BUFFER(12):
    case NVC697_LOAD_CONSTANT_BUFFER(13):
    case NVC697_LOAD_CONSTANT_BUFFER(14):
    case NVC697_LOAD_CONSTANT_BUFFER(15):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                    case NVC697_BIND_GROUP_CONSTANT_BUFFER(0):
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(1):
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(2):
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(3):
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(4):
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(5):
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(6):
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(7):
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(8):
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(9):
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(10):
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(11):
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(12):
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(13):
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(14):
    case NVC697_BIND_GROUP_CONSTANT_BUFFER(15):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.VALID = ", prefix);
        switch (parsed) {
        case NVC697_BIND_GROUP_CONSTANT_BUFFER_VALID_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_BIND_GROUP_CONSTANT_BUFFER_VALID_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 5) - 1);
        fprintf(fp, "%s.SHADER_SLOT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_TRAP_HANDLER_A:
    
        parsed = (data >> 0) & ((1u << 17) - 1);
        fprintf(fp, "%s.ADDRESS_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_TRAP_HANDLER_B:
    
        parsed = data;
        fprintf(fp, "%s.ADDRESS_LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_COLOR_CLAMP:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_COLOR_CLAMP_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_COLOR_CLAMP_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(0):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(1):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(2):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(3):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(4):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(5):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(6):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(7):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(8):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(9):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(10):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(11):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(12):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(13):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(14):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL(15):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_CONTROL_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(0):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(1):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(2):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(3):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(4):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(5):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(6):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(7):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(8):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(9):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(10):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(11):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(12):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(13):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(14):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A(15):
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.RATE_INDEX0 = ", prefix);
        switch (parsed) {
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX0_PS_X0_CULL_RASTER_PIXELS:
            fprintf(fp, "PS_X0_CULL_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX0_PS_X16_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X16_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX0_PS_X8_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X8_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX0_PS_X4_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X4_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX0_PS_X2_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X2_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX0_PS_X1_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X1_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX0_PS_X1_PER_2X1_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X1_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX0_PS_X1_PER_1X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_1X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX0_PS_X1_PER_2X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX0_PS_X1_PER_4X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX0_PS_X1_PER_2X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X4_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX0_PS_X1_PER_4X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X4_RASTER_PIXELS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.RATE_INDEX1 = ", prefix);
        switch (parsed) {
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX1_PS_X0_CULL_RASTER_PIXELS:
            fprintf(fp, "PS_X0_CULL_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX1_PS_X16_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X16_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX1_PS_X8_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X8_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX1_PS_X4_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X4_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX1_PS_X2_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X2_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX1_PS_X1_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X1_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX1_PS_X1_PER_2X1_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X1_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX1_PS_X1_PER_1X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_1X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX1_PS_X1_PER_2X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX1_PS_X1_PER_4X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX1_PS_X1_PER_2X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X4_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX1_PS_X1_PER_4X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X4_RASTER_PIXELS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.RATE_INDEX2 = ", prefix);
        switch (parsed) {
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX2_PS_X0_CULL_RASTER_PIXELS:
            fprintf(fp, "PS_X0_CULL_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX2_PS_X16_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X16_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX2_PS_X8_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X8_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX2_PS_X4_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X4_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX2_PS_X2_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X2_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX2_PS_X1_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X1_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX2_PS_X1_PER_2X1_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X1_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX2_PS_X1_PER_1X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_1X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX2_PS_X1_PER_2X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX2_PS_X1_PER_4X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX2_PS_X1_PER_2X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X4_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX2_PS_X1_PER_4X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X4_RASTER_PIXELS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 4) - 1);
        fprintf(fp, "%s.RATE_INDEX3 = ", prefix);
        switch (parsed) {
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX3_PS_X0_CULL_RASTER_PIXELS:
            fprintf(fp, "PS_X0_CULL_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX3_PS_X16_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X16_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX3_PS_X8_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X8_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX3_PS_X4_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X4_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX3_PS_X2_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X2_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX3_PS_X1_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X1_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX3_PS_X1_PER_2X1_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X1_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX3_PS_X1_PER_1X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_1X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX3_PS_X1_PER_2X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX3_PS_X1_PER_4X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX3_PS_X1_PER_2X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X4_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX3_PS_X1_PER_4X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X4_RASTER_PIXELS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 4) - 1);
        fprintf(fp, "%s.RATE_INDEX4 = ", prefix);
        switch (parsed) {
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX4_PS_X0_CULL_RASTER_PIXELS:
            fprintf(fp, "PS_X0_CULL_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX4_PS_X16_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X16_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX4_PS_X8_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X8_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX4_PS_X4_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X4_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX4_PS_X2_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X2_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX4_PS_X1_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X1_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX4_PS_X1_PER_2X1_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X1_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX4_PS_X1_PER_1X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_1X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX4_PS_X1_PER_2X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX4_PS_X1_PER_4X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX4_PS_X1_PER_2X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X4_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX4_PS_X1_PER_4X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X4_RASTER_PIXELS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 4) - 1);
        fprintf(fp, "%s.RATE_INDEX5 = ", prefix);
        switch (parsed) {
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX5_PS_X0_CULL_RASTER_PIXELS:
            fprintf(fp, "PS_X0_CULL_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX5_PS_X16_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X16_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX5_PS_X8_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X8_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX5_PS_X4_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X4_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX5_PS_X2_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X2_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX5_PS_X1_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X1_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX5_PS_X1_PER_2X1_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X1_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX5_PS_X1_PER_1X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_1X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX5_PS_X1_PER_2X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX5_PS_X1_PER_4X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX5_PS_X1_PER_2X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X4_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX5_PS_X1_PER_4X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X4_RASTER_PIXELS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 4) - 1);
        fprintf(fp, "%s.RATE_INDEX6 = ", prefix);
        switch (parsed) {
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX6_PS_X0_CULL_RASTER_PIXELS:
            fprintf(fp, "PS_X0_CULL_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX6_PS_X16_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X16_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX6_PS_X8_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X8_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX6_PS_X4_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X4_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX6_PS_X2_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X2_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX6_PS_X1_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X1_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX6_PS_X1_PER_2X1_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X1_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX6_PS_X1_PER_1X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_1X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX6_PS_X1_PER_2X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX6_PS_X1_PER_4X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX6_PS_X1_PER_2X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X4_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX6_PS_X1_PER_4X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X4_RASTER_PIXELS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.RATE_INDEX7 = ", prefix);
        switch (parsed) {
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX7_PS_X0_CULL_RASTER_PIXELS:
            fprintf(fp, "PS_X0_CULL_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX7_PS_X16_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X16_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX7_PS_X8_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X8_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX7_PS_X4_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X4_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX7_PS_X2_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X2_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX7_PS_X1_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X1_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX7_PS_X1_PER_2X1_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X1_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX7_PS_X1_PER_1X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_1X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX7_PS_X1_PER_2X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX7_PS_X1_PER_4X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX7_PS_X1_PER_2X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X4_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_A_RATE_INDEX7_PS_X1_PER_4X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X4_RASTER_PIXELS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(0):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(1):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(2):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(3):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(4):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(5):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(6):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(7):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(8):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(9):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(10):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(11):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(12):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(13):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(14):
    case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B(15):
    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.RATE_INDEX8 = ", prefix);
        switch (parsed) {
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX8_PS_X0_CULL_RASTER_PIXELS:
            fprintf(fp, "PS_X0_CULL_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX8_PS_X16_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X16_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX8_PS_X8_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X8_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX8_PS_X4_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X4_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX8_PS_X2_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X2_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX8_PS_X1_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X1_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX8_PS_X1_PER_2X1_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X1_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX8_PS_X1_PER_1X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_1X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX8_PS_X1_PER_2X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX8_PS_X1_PER_4X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX8_PS_X1_PER_2X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X4_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX8_PS_X1_PER_4X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X4_RASTER_PIXELS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.RATE_INDEX9 = ", prefix);
        switch (parsed) {
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX9_PS_X0_CULL_RASTER_PIXELS:
            fprintf(fp, "PS_X0_CULL_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX9_PS_X16_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X16_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX9_PS_X8_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X8_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX9_PS_X4_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X4_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX9_PS_X2_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X2_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX9_PS_X1_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X1_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX9_PS_X1_PER_2X1_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X1_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX9_PS_X1_PER_1X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_1X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX9_PS_X1_PER_2X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX9_PS_X1_PER_4X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX9_PS_X1_PER_2X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X4_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX9_PS_X1_PER_4X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X4_RASTER_PIXELS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.RATE_INDEX10 = ", prefix);
        switch (parsed) {
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX10_PS_X0_CULL_RASTER_PIXELS:
            fprintf(fp, "PS_X0_CULL_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX10_PS_X16_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X16_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX10_PS_X8_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X8_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX10_PS_X4_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X4_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX10_PS_X2_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X2_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX10_PS_X1_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X1_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX10_PS_X1_PER_2X1_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X1_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX10_PS_X1_PER_1X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_1X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX10_PS_X1_PER_2X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX10_PS_X1_PER_4X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX10_PS_X1_PER_2X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X4_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX10_PS_X1_PER_4X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X4_RASTER_PIXELS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 4) - 1);
        fprintf(fp, "%s.RATE_INDEX11 = ", prefix);
        switch (parsed) {
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX11_PS_X0_CULL_RASTER_PIXELS:
            fprintf(fp, "PS_X0_CULL_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX11_PS_X16_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X16_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX11_PS_X8_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X8_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX11_PS_X4_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X4_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX11_PS_X2_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X2_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX11_PS_X1_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X1_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX11_PS_X1_PER_2X1_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X1_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX11_PS_X1_PER_1X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_1X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX11_PS_X1_PER_2X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX11_PS_X1_PER_4X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX11_PS_X1_PER_2X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X4_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX11_PS_X1_PER_4X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X4_RASTER_PIXELS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 4) - 1);
        fprintf(fp, "%s.RATE_INDEX12 = ", prefix);
        switch (parsed) {
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX12_PS_X0_CULL_RASTER_PIXELS:
            fprintf(fp, "PS_X0_CULL_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX12_PS_X16_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X16_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX12_PS_X8_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X8_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX12_PS_X4_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X4_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX12_PS_X2_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X2_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX12_PS_X1_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X1_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX12_PS_X1_PER_2X1_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X1_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX12_PS_X1_PER_1X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_1X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX12_PS_X1_PER_2X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX12_PS_X1_PER_4X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX12_PS_X1_PER_2X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X4_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX12_PS_X1_PER_4X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X4_RASTER_PIXELS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 4) - 1);
        fprintf(fp, "%s.RATE_INDEX13 = ", prefix);
        switch (parsed) {
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX13_PS_X0_CULL_RASTER_PIXELS:
            fprintf(fp, "PS_X0_CULL_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX13_PS_X16_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X16_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX13_PS_X8_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X8_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX13_PS_X4_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X4_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX13_PS_X2_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X2_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX13_PS_X1_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X1_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX13_PS_X1_PER_2X1_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X1_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX13_PS_X1_PER_1X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_1X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX13_PS_X1_PER_2X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX13_PS_X1_PER_4X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX13_PS_X1_PER_2X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X4_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX13_PS_X1_PER_4X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X4_RASTER_PIXELS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 4) - 1);
        fprintf(fp, "%s.RATE_INDEX14 = ", prefix);
        switch (parsed) {
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX14_PS_X0_CULL_RASTER_PIXELS:
            fprintf(fp, "PS_X0_CULL_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX14_PS_X16_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X16_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX14_PS_X8_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X8_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX14_PS_X4_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X4_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX14_PS_X2_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X2_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX14_PS_X1_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X1_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX14_PS_X1_PER_2X1_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X1_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX14_PS_X1_PER_1X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_1X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX14_PS_X1_PER_2X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX14_PS_X1_PER_4X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX14_PS_X1_PER_2X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X4_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX14_PS_X1_PER_4X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X4_RASTER_PIXELS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.RATE_INDEX15 = ", prefix);
        switch (parsed) {
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX15_PS_X0_CULL_RASTER_PIXELS:
            fprintf(fp, "PS_X0_CULL_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX15_PS_X16_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X16_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX15_PS_X8_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X8_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX15_PS_X4_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X4_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX15_PS_X2_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X2_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX15_PS_X1_PER_RASTER_PIXEL:
            fprintf(fp, "PS_X1_PER_RASTER_PIXEL\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX15_PS_X1_PER_2X1_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X1_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX15_PS_X1_PER_1X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_1X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX15_PS_X1_PER_2X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX15_PS_X1_PER_4X2_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X2_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX15_PS_X1_PER_2X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_2X4_RASTER_PIXELS\n");
            break;
        case NVC697_SET_VARIABLE_PIXEL_RATE_SHADING_INDEX_TO_RATE_B_RATE_INDEX15_PS_X1_PER_4X4_RASTER_PIXELS:
            fprintf(fp, "PS_X1_PER_4X4_RASTER_PIXELS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
        case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(0):
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(1):
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(2):
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(3):
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(4):
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(5):
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(6):
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(0):
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(1):
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(2):
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(3):
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(4):
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(5):
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(6):
    case NVC697_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER:
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(0):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(1):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(2):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(3):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(4):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(5):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(6):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(0):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(1):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(2):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(3):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(4):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(5):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(6):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_VALUE(7):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(0):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(1):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(2):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(3):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(4):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(5):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(6):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_EVENT(7):
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.EVENT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(0):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(1):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(2):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(3):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(4):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(5):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(6):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(7):
    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 2) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT0 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 5) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT1 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 7) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT1 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 10) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT2 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 12) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT2 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 15) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT3 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 17) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT3 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 20) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT4 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 22) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT4 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 25) & ((1u << 2) - 1);
        fprintf(fp, "%s.EVENT5 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 27) & ((1u << 3) - 1);
        fprintf(fp, "%s.BIT_SELECT5 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 30) & ((1u << 2) - 1);
        fprintf(fp, "%s.SPARE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(0):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(1):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(2):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(3):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(4):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(5):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(6):
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(7):
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.EDGE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 1) & ((1u << 2) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 3) & ((1u << 1) - 1);
        fprintf(fp, "%s.WINDOWED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 4) & ((1u << 16) - 1);
        fprintf(fp, "%s.FUNC = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_START_SHADER_PERFORMANCE_COUNTER:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.COUNTER_MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_STOP_SHADER_PERFORMANCE_COUNTER:
    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.COUNTER_MASK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER:
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_SET_MME_SHADOW_SCRATCH(0):
    case NVC697_SET_MME_SHADOW_SCRATCH(1):
    case NVC697_SET_MME_SHADOW_SCRATCH(2):
    case NVC697_SET_MME_SHADOW_SCRATCH(3):
    case NVC697_SET_MME_SHADOW_SCRATCH(4):
    case NVC697_SET_MME_SHADOW_SCRATCH(5):
    case NVC697_SET_MME_SHADOW_SCRATCH(6):
    case NVC697_SET_MME_SHADOW_SCRATCH(7):
    case NVC697_SET_MME_SHADOW_SCRATCH(8):
    case NVC697_SET_MME_SHADOW_SCRATCH(9):
    case NVC697_SET_MME_SHADOW_SCRATCH(10):
    case NVC697_SET_MME_SHADOW_SCRATCH(11):
    case NVC697_SET_MME_SHADOW_SCRATCH(12):
    case NVC697_SET_MME_SHADOW_SCRATCH(13):
    case NVC697_SET_MME_SHADOW_SCRATCH(14):
    case NVC697_SET_MME_SHADOW_SCRATCH(15):
    case NVC697_SET_MME_SHADOW_SCRATCH(16):
    case NVC697_SET_MME_SHADOW_SCRATCH(17):
    case NVC697_SET_MME_SHADOW_SCRATCH(18):
    case NVC697_SET_MME_SHADOW_SCRATCH(19):
    case NVC697_SET_MME_SHADOW_SCRATCH(20):
    case NVC697_SET_MME_SHADOW_SCRATCH(21):
    case NVC697_SET_MME_SHADOW_SCRATCH(22):
    case NVC697_SET_MME_SHADOW_SCRATCH(23):
    case NVC697_SET_MME_SHADOW_SCRATCH(24):
    case NVC697_SET_MME_SHADOW_SCRATCH(25):
    case NVC697_SET_MME_SHADOW_SCRATCH(26):
    case NVC697_SET_MME_SHADOW_SCRATCH(27):
    case NVC697_SET_MME_SHADOW_SCRATCH(28):
    case NVC697_SET_MME_SHADOW_SCRATCH(29):
    case NVC697_SET_MME_SHADOW_SCRATCH(30):
    case NVC697_SET_MME_SHADOW_SCRATCH(31):
    case NVC697_SET_MME_SHADOW_SCRATCH(32):
    case NVC697_SET_MME_SHADOW_SCRATCH(33):
    case NVC697_SET_MME_SHADOW_SCRATCH(34):
    case NVC697_SET_MME_SHADOW_SCRATCH(35):
    case NVC697_SET_MME_SHADOW_SCRATCH(36):
    case NVC697_SET_MME_SHADOW_SCRATCH(37):
    case NVC697_SET_MME_SHADOW_SCRATCH(38):
    case NVC697_SET_MME_SHADOW_SCRATCH(39):
    case NVC697_SET_MME_SHADOW_SCRATCH(40):
    case NVC697_SET_MME_SHADOW_SCRATCH(41):
    case NVC697_SET_MME_SHADOW_SCRATCH(42):
    case NVC697_SET_MME_SHADOW_SCRATCH(43):
    case NVC697_SET_MME_SHADOW_SCRATCH(44):
    case NVC697_SET_MME_SHADOW_SCRATCH(45):
    case NVC697_SET_MME_SHADOW_SCRATCH(46):
    case NVC697_SET_MME_SHADOW_SCRATCH(47):
    case NVC697_SET_MME_SHADOW_SCRATCH(48):
    case NVC697_SET_MME_SHADOW_SCRATCH(49):
    case NVC697_SET_MME_SHADOW_SCRATCH(50):
    case NVC697_SET_MME_SHADOW_SCRATCH(51):
    case NVC697_SET_MME_SHADOW_SCRATCH(52):
    case NVC697_SET_MME_SHADOW_SCRATCH(53):
    case NVC697_SET_MME_SHADOW_SCRATCH(54):
    case NVC697_SET_MME_SHADOW_SCRATCH(55):
    case NVC697_SET_MME_SHADOW_SCRATCH(56):
    case NVC697_SET_MME_SHADOW_SCRATCH(57):
    case NVC697_SET_MME_SHADOW_SCRATCH(58):
    case NVC697_SET_MME_SHADOW_SCRATCH(59):
    case NVC697_SET_MME_SHADOW_SCRATCH(60):
    case NVC697_SET_MME_SHADOW_SCRATCH(61):
    case NVC697_SET_MME_SHADOW_SCRATCH(62):
    case NVC697_SET_MME_SHADOW_SCRATCH(63):
    case NVC697_SET_MME_SHADOW_SCRATCH(64):
    case NVC697_SET_MME_SHADOW_SCRATCH(65):
    case NVC697_SET_MME_SHADOW_SCRATCH(66):
    case NVC697_SET_MME_SHADOW_SCRATCH(67):
    case NVC697_SET_MME_SHADOW_SCRATCH(68):
    case NVC697_SET_MME_SHADOW_SCRATCH(69):
    case NVC697_SET_MME_SHADOW_SCRATCH(70):
    case NVC697_SET_MME_SHADOW_SCRATCH(71):
    case NVC697_SET_MME_SHADOW_SCRATCH(72):
    case NVC697_SET_MME_SHADOW_SCRATCH(73):
    case NVC697_SET_MME_SHADOW_SCRATCH(74):
    case NVC697_SET_MME_SHADOW_SCRATCH(75):
    case NVC697_SET_MME_SHADOW_SCRATCH(76):
    case NVC697_SET_MME_SHADOW_SCRATCH(77):
    case NVC697_SET_MME_SHADOW_SCRATCH(78):
    case NVC697_SET_MME_SHADOW_SCRATCH(79):
    case NVC697_SET_MME_SHADOW_SCRATCH(80):
    case NVC697_SET_MME_SHADOW_SCRATCH(81):
    case NVC697_SET_MME_SHADOW_SCRATCH(82):
    case NVC697_SET_MME_SHADOW_SCRATCH(83):
    case NVC697_SET_MME_SHADOW_SCRATCH(84):
    case NVC697_SET_MME_SHADOW_SCRATCH(85):
    case NVC697_SET_MME_SHADOW_SCRATCH(86):
    case NVC697_SET_MME_SHADOW_SCRATCH(87):
    case NVC697_SET_MME_SHADOW_SCRATCH(88):
    case NVC697_SET_MME_SHADOW_SCRATCH(89):
    case NVC697_SET_MME_SHADOW_SCRATCH(90):
    case NVC697_SET_MME_SHADOW_SCRATCH(91):
    case NVC697_SET_MME_SHADOW_SCRATCH(92):
    case NVC697_SET_MME_SHADOW_SCRATCH(93):
    case NVC697_SET_MME_SHADOW_SCRATCH(94):
    case NVC697_SET_MME_SHADOW_SCRATCH(95):
    case NVC697_SET_MME_SHADOW_SCRATCH(96):
    case NVC697_SET_MME_SHADOW_SCRATCH(97):
    case NVC697_SET_MME_SHADOW_SCRATCH(98):
    case NVC697_SET_MME_SHADOW_SCRATCH(99):
    case NVC697_SET_MME_SHADOW_SCRATCH(100):
    case NVC697_SET_MME_SHADOW_SCRATCH(101):
    case NVC697_SET_MME_SHADOW_SCRATCH(102):
    case NVC697_SET_MME_SHADOW_SCRATCH(103):
    case NVC697_SET_MME_SHADOW_SCRATCH(104):
    case NVC697_SET_MME_SHADOW_SCRATCH(105):
    case NVC697_SET_MME_SHADOW_SCRATCH(106):
    case NVC697_SET_MME_SHADOW_SCRATCH(107):
    case NVC697_SET_MME_SHADOW_SCRATCH(108):
    case NVC697_SET_MME_SHADOW_SCRATCH(109):
    case NVC697_SET_MME_SHADOW_SCRATCH(110):
    case NVC697_SET_MME_SHADOW_SCRATCH(111):
    case NVC697_SET_MME_SHADOW_SCRATCH(112):
    case NVC697_SET_MME_SHADOW_SCRATCH(113):
    case NVC697_SET_MME_SHADOW_SCRATCH(114):
    case NVC697_SET_MME_SHADOW_SCRATCH(115):
    case NVC697_SET_MME_SHADOW_SCRATCH(116):
    case NVC697_SET_MME_SHADOW_SCRATCH(117):
    case NVC697_SET_MME_SHADOW_SCRATCH(118):
    case NVC697_SET_MME_SHADOW_SCRATCH(119):
    case NVC697_SET_MME_SHADOW_SCRATCH(120):
    case NVC697_SET_MME_SHADOW_SCRATCH(121):
    case NVC697_SET_MME_SHADOW_SCRATCH(122):
    case NVC697_SET_MME_SHADOW_SCRATCH(123):
    case NVC697_SET_MME_SHADOW_SCRATCH(124):
    case NVC697_SET_MME_SHADOW_SCRATCH(125):
    case NVC697_SET_MME_SHADOW_SCRATCH(126):
    case NVC697_SET_MME_SHADOW_SCRATCH(127):
    case NVC697_SET_MME_SHADOW_SCRATCH(128):
    case NVC697_SET_MME_SHADOW_SCRATCH(129):
    case NVC697_SET_MME_SHADOW_SCRATCH(130):
    case NVC697_SET_MME_SHADOW_SCRATCH(131):
    case NVC697_SET_MME_SHADOW_SCRATCH(132):
    case NVC697_SET_MME_SHADOW_SCRATCH(133):
    case NVC697_SET_MME_SHADOW_SCRATCH(134):
    case NVC697_SET_MME_SHADOW_SCRATCH(135):
    case NVC697_SET_MME_SHADOW_SCRATCH(136):
    case NVC697_SET_MME_SHADOW_SCRATCH(137):
    case NVC697_SET_MME_SHADOW_SCRATCH(138):
    case NVC697_SET_MME_SHADOW_SCRATCH(139):
    case NVC697_SET_MME_SHADOW_SCRATCH(140):
    case NVC697_SET_MME_SHADOW_SCRATCH(141):
    case NVC697_SET_MME_SHADOW_SCRATCH(142):
    case NVC697_SET_MME_SHADOW_SCRATCH(143):
    case NVC697_SET_MME_SHADOW_SCRATCH(144):
    case NVC697_SET_MME_SHADOW_SCRATCH(145):
    case NVC697_SET_MME_SHADOW_SCRATCH(146):
    case NVC697_SET_MME_SHADOW_SCRATCH(147):
    case NVC697_SET_MME_SHADOW_SCRATCH(148):
    case NVC697_SET_MME_SHADOW_SCRATCH(149):
    case NVC697_SET_MME_SHADOW_SCRATCH(150):
    case NVC697_SET_MME_SHADOW_SCRATCH(151):
    case NVC697_SET_MME_SHADOW_SCRATCH(152):
    case NVC697_SET_MME_SHADOW_SCRATCH(153):
    case NVC697_SET_MME_SHADOW_SCRATCH(154):
    case NVC697_SET_MME_SHADOW_SCRATCH(155):
    case NVC697_SET_MME_SHADOW_SCRATCH(156):
    case NVC697_SET_MME_SHADOW_SCRATCH(157):
    case NVC697_SET_MME_SHADOW_SCRATCH(158):
    case NVC697_SET_MME_SHADOW_SCRATCH(159):
    case NVC697_SET_MME_SHADOW_SCRATCH(160):
    case NVC697_SET_MME_SHADOW_SCRATCH(161):
    case NVC697_SET_MME_SHADOW_SCRATCH(162):
    case NVC697_SET_MME_SHADOW_SCRATCH(163):
    case NVC697_SET_MME_SHADOW_SCRATCH(164):
    case NVC697_SET_MME_SHADOW_SCRATCH(165):
    case NVC697_SET_MME_SHADOW_SCRATCH(166):
    case NVC697_SET_MME_SHADOW_SCRATCH(167):
    case NVC697_SET_MME_SHADOW_SCRATCH(168):
    case NVC697_SET_MME_SHADOW_SCRATCH(169):
    case NVC697_SET_MME_SHADOW_SCRATCH(170):
    case NVC697_SET_MME_SHADOW_SCRATCH(171):
    case NVC697_SET_MME_SHADOW_SCRATCH(172):
    case NVC697_SET_MME_SHADOW_SCRATCH(173):
    case NVC697_SET_MME_SHADOW_SCRATCH(174):
    case NVC697_SET_MME_SHADOW_SCRATCH(175):
    case NVC697_SET_MME_SHADOW_SCRATCH(176):
    case NVC697_SET_MME_SHADOW_SCRATCH(177):
    case NVC697_SET_MME_SHADOW_SCRATCH(178):
    case NVC697_SET_MME_SHADOW_SCRATCH(179):
    case NVC697_SET_MME_SHADOW_SCRATCH(180):
    case NVC697_SET_MME_SHADOW_SCRATCH(181):
    case NVC697_SET_MME_SHADOW_SCRATCH(182):
    case NVC697_SET_MME_SHADOW_SCRATCH(183):
    case NVC697_SET_MME_SHADOW_SCRATCH(184):
    case NVC697_SET_MME_SHADOW_SCRATCH(185):
    case NVC697_SET_MME_SHADOW_SCRATCH(186):
    case NVC697_SET_MME_SHADOW_SCRATCH(187):
    case NVC697_SET_MME_SHADOW_SCRATCH(188):
    case NVC697_SET_MME_SHADOW_SCRATCH(189):
    case NVC697_SET_MME_SHADOW_SCRATCH(190):
    case NVC697_SET_MME_SHADOW_SCRATCH(191):
    case NVC697_SET_MME_SHADOW_SCRATCH(192):
    case NVC697_SET_MME_SHADOW_SCRATCH(193):
    case NVC697_SET_MME_SHADOW_SCRATCH(194):
    case NVC697_SET_MME_SHADOW_SCRATCH(195):
    case NVC697_SET_MME_SHADOW_SCRATCH(196):
    case NVC697_SET_MME_SHADOW_SCRATCH(197):
    case NVC697_SET_MME_SHADOW_SCRATCH(198):
    case NVC697_SET_MME_SHADOW_SCRATCH(199):
    case NVC697_SET_MME_SHADOW_SCRATCH(200):
    case NVC697_SET_MME_SHADOW_SCRATCH(201):
    case NVC697_SET_MME_SHADOW_SCRATCH(202):
    case NVC697_SET_MME_SHADOW_SCRATCH(203):
    case NVC697_SET_MME_SHADOW_SCRATCH(204):
    case NVC697_SET_MME_SHADOW_SCRATCH(205):
    case NVC697_SET_MME_SHADOW_SCRATCH(206):
    case NVC697_SET_MME_SHADOW_SCRATCH(207):
    case NVC697_SET_MME_SHADOW_SCRATCH(208):
    case NVC697_SET_MME_SHADOW_SCRATCH(209):
    case NVC697_SET_MME_SHADOW_SCRATCH(210):
    case NVC697_SET_MME_SHADOW_SCRATCH(211):
    case NVC697_SET_MME_SHADOW_SCRATCH(212):
    case NVC697_SET_MME_SHADOW_SCRATCH(213):
    case NVC697_SET_MME_SHADOW_SCRATCH(214):
    case NVC697_SET_MME_SHADOW_SCRATCH(215):
    case NVC697_SET_MME_SHADOW_SCRATCH(216):
    case NVC697_SET_MME_SHADOW_SCRATCH(217):
    case NVC697_SET_MME_SHADOW_SCRATCH(218):
    case NVC697_SET_MME_SHADOW_SCRATCH(219):
    case NVC697_SET_MME_SHADOW_SCRATCH(220):
    case NVC697_SET_MME_SHADOW_SCRATCH(221):
    case NVC697_SET_MME_SHADOW_SCRATCH(222):
    case NVC697_SET_MME_SHADOW_SCRATCH(223):
    case NVC697_SET_MME_SHADOW_SCRATCH(224):
    case NVC697_SET_MME_SHADOW_SCRATCH(225):
    case NVC697_SET_MME_SHADOW_SCRATCH(226):
    case NVC697_SET_MME_SHADOW_SCRATCH(227):
    case NVC697_SET_MME_SHADOW_SCRATCH(228):
    case NVC697_SET_MME_SHADOW_SCRATCH(229):
    case NVC697_SET_MME_SHADOW_SCRATCH(230):
    case NVC697_SET_MME_SHADOW_SCRATCH(231):
    case NVC697_SET_MME_SHADOW_SCRATCH(232):
    case NVC697_SET_MME_SHADOW_SCRATCH(233):
    case NVC697_SET_MME_SHADOW_SCRATCH(234):
    case NVC697_SET_MME_SHADOW_SCRATCH(235):
    case NVC697_SET_MME_SHADOW_SCRATCH(236):
    case NVC697_SET_MME_SHADOW_SCRATCH(237):
    case NVC697_SET_MME_SHADOW_SCRATCH(238):
    case NVC697_SET_MME_SHADOW_SCRATCH(239):
    case NVC697_SET_MME_SHADOW_SCRATCH(240):
    case NVC697_SET_MME_SHADOW_SCRATCH(241):
    case NVC697_SET_MME_SHADOW_SCRATCH(242):
    case NVC697_SET_MME_SHADOW_SCRATCH(243):
    case NVC697_SET_MME_SHADOW_SCRATCH(244):
    case NVC697_SET_MME_SHADOW_SCRATCH(245):
    case NVC697_SET_MME_SHADOW_SCRATCH(246):
    case NVC697_SET_MME_SHADOW_SCRATCH(247):
    case NVC697_SET_MME_SHADOW_SCRATCH(248):
    case NVC697_SET_MME_SHADOW_SCRATCH(249):
    case NVC697_SET_MME_SHADOW_SCRATCH(250):
    case NVC697_SET_MME_SHADOW_SCRATCH(251):
    case NVC697_SET_MME_SHADOW_SCRATCH(252):
    case NVC697_SET_MME_SHADOW_SCRATCH(253):
    case NVC697_SET_MME_SHADOW_SCRATCH(254):
    case NVC697_SET_MME_SHADOW_SCRATCH(255):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_CALL_MME_MACRO(0):
    case NVC697_CALL_MME_MACRO(1):
    case NVC697_CALL_MME_MACRO(2):
    case NVC697_CALL_MME_MACRO(3):
    case NVC697_CALL_MME_MACRO(4):
    case NVC697_CALL_MME_MACRO(5):
    case NVC697_CALL_MME_MACRO(6):
    case NVC697_CALL_MME_MACRO(7):
    case NVC697_CALL_MME_MACRO(8):
    case NVC697_CALL_MME_MACRO(9):
    case NVC697_CALL_MME_MACRO(10):
    case NVC697_CALL_MME_MACRO(11):
    case NVC697_CALL_MME_MACRO(12):
    case NVC697_CALL_MME_MACRO(13):
    case NVC697_CALL_MME_MACRO(14):
    case NVC697_CALL_MME_MACRO(15):
    case NVC697_CALL_MME_MACRO(16):
    case NVC697_CALL_MME_MACRO(17):
    case NVC697_CALL_MME_MACRO(18):
    case NVC697_CALL_MME_MACRO(19):
    case NVC697_CALL_MME_MACRO(20):
    case NVC697_CALL_MME_MACRO(21):
    case NVC697_CALL_MME_MACRO(22):
    case NVC697_CALL_MME_MACRO(23):
    case NVC697_CALL_MME_MACRO(24):
    case NVC697_CALL_MME_MACRO(25):
    case NVC697_CALL_MME_MACRO(26):
    case NVC697_CALL_MME_MACRO(27):
    case NVC697_CALL_MME_MACRO(28):
    case NVC697_CALL_MME_MACRO(29):
    case NVC697_CALL_MME_MACRO(30):
    case NVC697_CALL_MME_MACRO(31):
    case NVC697_CALL_MME_MACRO(32):
    case NVC697_CALL_MME_MACRO(33):
    case NVC697_CALL_MME_MACRO(34):
    case NVC697_CALL_MME_MACRO(35):
    case NVC697_CALL_MME_MACRO(36):
    case NVC697_CALL_MME_MACRO(37):
    case NVC697_CALL_MME_MACRO(38):
    case NVC697_CALL_MME_MACRO(39):
    case NVC697_CALL_MME_MACRO(40):
    case NVC697_CALL_MME_MACRO(41):
    case NVC697_CALL_MME_MACRO(42):
    case NVC697_CALL_MME_MACRO(43):
    case NVC697_CALL_MME_MACRO(44):
    case NVC697_CALL_MME_MACRO(45):
    case NVC697_CALL_MME_MACRO(46):
    case NVC697_CALL_MME_MACRO(47):
    case NVC697_CALL_MME_MACRO(48):
    case NVC697_CALL_MME_MACRO(49):
    case NVC697_CALL_MME_MACRO(50):
    case NVC697_CALL_MME_MACRO(51):
    case NVC697_CALL_MME_MACRO(52):
    case NVC697_CALL_MME_MACRO(53):
    case NVC697_CALL_MME_MACRO(54):
    case NVC697_CALL_MME_MACRO(55):
    case NVC697_CALL_MME_MACRO(56):
    case NVC697_CALL_MME_MACRO(57):
    case NVC697_CALL_MME_MACRO(58):
    case NVC697_CALL_MME_MACRO(59):
    case NVC697_CALL_MME_MACRO(60):
    case NVC697_CALL_MME_MACRO(61):
    case NVC697_CALL_MME_MACRO(62):
    case NVC697_CALL_MME_MACRO(63):
    case NVC697_CALL_MME_MACRO(64):
    case NVC697_CALL_MME_MACRO(65):
    case NVC697_CALL_MME_MACRO(66):
    case NVC697_CALL_MME_MACRO(67):
    case NVC697_CALL_MME_MACRO(68):
    case NVC697_CALL_MME_MACRO(69):
    case NVC697_CALL_MME_MACRO(70):
    case NVC697_CALL_MME_MACRO(71):
    case NVC697_CALL_MME_MACRO(72):
    case NVC697_CALL_MME_MACRO(73):
    case NVC697_CALL_MME_MACRO(74):
    case NVC697_CALL_MME_MACRO(75):
    case NVC697_CALL_MME_MACRO(76):
    case NVC697_CALL_MME_MACRO(77):
    case NVC697_CALL_MME_MACRO(78):
    case NVC697_CALL_MME_MACRO(79):
    case NVC697_CALL_MME_MACRO(80):
    case NVC697_CALL_MME_MACRO(81):
    case NVC697_CALL_MME_MACRO(82):
    case NVC697_CALL_MME_MACRO(83):
    case NVC697_CALL_MME_MACRO(84):
    case NVC697_CALL_MME_MACRO(85):
    case NVC697_CALL_MME_MACRO(86):
    case NVC697_CALL_MME_MACRO(87):
    case NVC697_CALL_MME_MACRO(88):
    case NVC697_CALL_MME_MACRO(89):
    case NVC697_CALL_MME_MACRO(90):
    case NVC697_CALL_MME_MACRO(91):
    case NVC697_CALL_MME_MACRO(92):
    case NVC697_CALL_MME_MACRO(93):
    case NVC697_CALL_MME_MACRO(94):
    case NVC697_CALL_MME_MACRO(95):
    case NVC697_CALL_MME_MACRO(96):
    case NVC697_CALL_MME_MACRO(97):
    case NVC697_CALL_MME_MACRO(98):
    case NVC697_CALL_MME_MACRO(99):
    case NVC697_CALL_MME_MACRO(100):
    case NVC697_CALL_MME_MACRO(101):
    case NVC697_CALL_MME_MACRO(102):
    case NVC697_CALL_MME_MACRO(103):
    case NVC697_CALL_MME_MACRO(104):
    case NVC697_CALL_MME_MACRO(105):
    case NVC697_CALL_MME_MACRO(106):
    case NVC697_CALL_MME_MACRO(107):
    case NVC697_CALL_MME_MACRO(108):
    case NVC697_CALL_MME_MACRO(109):
    case NVC697_CALL_MME_MACRO(110):
    case NVC697_CALL_MME_MACRO(111):
    case NVC697_CALL_MME_MACRO(112):
    case NVC697_CALL_MME_MACRO(113):
    case NVC697_CALL_MME_MACRO(114):
    case NVC697_CALL_MME_MACRO(115):
    case NVC697_CALL_MME_MACRO(116):
    case NVC697_CALL_MME_MACRO(117):
    case NVC697_CALL_MME_MACRO(118):
    case NVC697_CALL_MME_MACRO(119):
    case NVC697_CALL_MME_MACRO(120):
    case NVC697_CALL_MME_MACRO(121):
    case NVC697_CALL_MME_MACRO(122):
    case NVC697_CALL_MME_MACRO(123):
    case NVC697_CALL_MME_MACRO(124):
    case NVC697_CALL_MME_MACRO(125):
    case NVC697_CALL_MME_MACRO(126):
    case NVC697_CALL_MME_MACRO(127):
    case NVC697_CALL_MME_MACRO(128):
    case NVC697_CALL_MME_MACRO(129):
    case NVC697_CALL_MME_MACRO(130):
    case NVC697_CALL_MME_MACRO(131):
    case NVC697_CALL_MME_MACRO(132):
    case NVC697_CALL_MME_MACRO(133):
    case NVC697_CALL_MME_MACRO(134):
    case NVC697_CALL_MME_MACRO(135):
    case NVC697_CALL_MME_MACRO(136):
    case NVC697_CALL_MME_MACRO(137):
    case NVC697_CALL_MME_MACRO(138):
    case NVC697_CALL_MME_MACRO(139):
    case NVC697_CALL_MME_MACRO(140):
    case NVC697_CALL_MME_MACRO(141):
    case NVC697_CALL_MME_MACRO(142):
    case NVC697_CALL_MME_MACRO(143):
    case NVC697_CALL_MME_MACRO(144):
    case NVC697_CALL_MME_MACRO(145):
    case NVC697_CALL_MME_MACRO(146):
    case NVC697_CALL_MME_MACRO(147):
    case NVC697_CALL_MME_MACRO(148):
    case NVC697_CALL_MME_MACRO(149):
    case NVC697_CALL_MME_MACRO(150):
    case NVC697_CALL_MME_MACRO(151):
    case NVC697_CALL_MME_MACRO(152):
    case NVC697_CALL_MME_MACRO(153):
    case NVC697_CALL_MME_MACRO(154):
    case NVC697_CALL_MME_MACRO(155):
    case NVC697_CALL_MME_MACRO(156):
    case NVC697_CALL_MME_MACRO(157):
    case NVC697_CALL_MME_MACRO(158):
    case NVC697_CALL_MME_MACRO(159):
    case NVC697_CALL_MME_MACRO(160):
    case NVC697_CALL_MME_MACRO(161):
    case NVC697_CALL_MME_MACRO(162):
    case NVC697_CALL_MME_MACRO(163):
    case NVC697_CALL_MME_MACRO(164):
    case NVC697_CALL_MME_MACRO(165):
    case NVC697_CALL_MME_MACRO(166):
    case NVC697_CALL_MME_MACRO(167):
    case NVC697_CALL_MME_MACRO(168):
    case NVC697_CALL_MME_MACRO(169):
    case NVC697_CALL_MME_MACRO(170):
    case NVC697_CALL_MME_MACRO(171):
    case NVC697_CALL_MME_MACRO(172):
    case NVC697_CALL_MME_MACRO(173):
    case NVC697_CALL_MME_MACRO(174):
    case NVC697_CALL_MME_MACRO(175):
    case NVC697_CALL_MME_MACRO(176):
    case NVC697_CALL_MME_MACRO(177):
    case NVC697_CALL_MME_MACRO(178):
    case NVC697_CALL_MME_MACRO(179):
    case NVC697_CALL_MME_MACRO(180):
    case NVC697_CALL_MME_MACRO(181):
    case NVC697_CALL_MME_MACRO(182):
    case NVC697_CALL_MME_MACRO(183):
    case NVC697_CALL_MME_MACRO(184):
    case NVC697_CALL_MME_MACRO(185):
    case NVC697_CALL_MME_MACRO(186):
    case NVC697_CALL_MME_MACRO(187):
    case NVC697_CALL_MME_MACRO(188):
    case NVC697_CALL_MME_MACRO(189):
    case NVC697_CALL_MME_MACRO(190):
    case NVC697_CALL_MME_MACRO(191):
    case NVC697_CALL_MME_MACRO(192):
    case NVC697_CALL_MME_MACRO(193):
    case NVC697_CALL_MME_MACRO(194):
    case NVC697_CALL_MME_MACRO(195):
    case NVC697_CALL_MME_MACRO(196):
    case NVC697_CALL_MME_MACRO(197):
    case NVC697_CALL_MME_MACRO(198):
    case NVC697_CALL_MME_MACRO(199):
    case NVC697_CALL_MME_MACRO(200):
    case NVC697_CALL_MME_MACRO(201):
    case NVC697_CALL_MME_MACRO(202):
    case NVC697_CALL_MME_MACRO(203):
    case NVC697_CALL_MME_MACRO(204):
    case NVC697_CALL_MME_MACRO(205):
    case NVC697_CALL_MME_MACRO(206):
    case NVC697_CALL_MME_MACRO(207):
    case NVC697_CALL_MME_MACRO(208):
    case NVC697_CALL_MME_MACRO(209):
    case NVC697_CALL_MME_MACRO(210):
    case NVC697_CALL_MME_MACRO(211):
    case NVC697_CALL_MME_MACRO(212):
    case NVC697_CALL_MME_MACRO(213):
    case NVC697_CALL_MME_MACRO(214):
    case NVC697_CALL_MME_MACRO(215):
    case NVC697_CALL_MME_MACRO(216):
    case NVC697_CALL_MME_MACRO(217):
    case NVC697_CALL_MME_MACRO(218):
    case NVC697_CALL_MME_MACRO(219):
    case NVC697_CALL_MME_MACRO(220):
    case NVC697_CALL_MME_MACRO(221):
    case NVC697_CALL_MME_MACRO(222):
    case NVC697_CALL_MME_MACRO(223):
    case NVC697_CALL_MME_MACRO(224):
    case NVC697_CALL_MME_MACRO(225):
    case NVC697_CALL_MME_MACRO(226):
    case NVC697_CALL_MME_MACRO(227):
    case NVC697_CALL_MME_MACRO(228):
    case NVC697_CALL_MME_MACRO(229):
    case NVC697_CALL_MME_MACRO(230):
    case NVC697_CALL_MME_MACRO(231):
    case NVC697_CALL_MME_MACRO(232):
    case NVC697_CALL_MME_MACRO(233):
    case NVC697_CALL_MME_MACRO(234):
    case NVC697_CALL_MME_MACRO(235):
    case NVC697_CALL_MME_MACRO(236):
    case NVC697_CALL_MME_MACRO(237):
    case NVC697_CALL_MME_MACRO(238):
    case NVC697_CALL_MME_MACRO(239):
    case NVC697_CALL_MME_MACRO(240):
    case NVC697_CALL_MME_MACRO(241):
    case NVC697_CALL_MME_MACRO(242):
    case NVC697_CALL_MME_MACRO(243):
    case NVC697_CALL_MME_MACRO(244):
    case NVC697_CALL_MME_MACRO(245):
    case NVC697_CALL_MME_MACRO(246):
    case NVC697_CALL_MME_MACRO(247):
    case NVC697_CALL_MME_MACRO(248):
    case NVC697_CALL_MME_MACRO(249):
    case NVC697_CALL_MME_MACRO(250):
    case NVC697_CALL_MME_MACRO(251):
    case NVC697_CALL_MME_MACRO(252):
    case NVC697_CALL_MME_MACRO(253):
    case NVC697_CALL_MME_MACRO(254):
    case NVC697_CALL_MME_MACRO(255):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    case NVC697_CALL_MME_DATA(0):
    case NVC697_CALL_MME_DATA(1):
    case NVC697_CALL_MME_DATA(2):
    case NVC697_CALL_MME_DATA(3):
    case NVC697_CALL_MME_DATA(4):
    case NVC697_CALL_MME_DATA(5):
    case NVC697_CALL_MME_DATA(6):
    case NVC697_CALL_MME_DATA(7):
    case NVC697_CALL_MME_DATA(8):
    case NVC697_CALL_MME_DATA(9):
    case NVC697_CALL_MME_DATA(10):
    case NVC697_CALL_MME_DATA(11):
    case NVC697_CALL_MME_DATA(12):
    case NVC697_CALL_MME_DATA(13):
    case NVC697_CALL_MME_DATA(14):
    case NVC697_CALL_MME_DATA(15):
    case NVC697_CALL_MME_DATA(16):
    case NVC697_CALL_MME_DATA(17):
    case NVC697_CALL_MME_DATA(18):
    case NVC697_CALL_MME_DATA(19):
    case NVC697_CALL_MME_DATA(20):
    case NVC697_CALL_MME_DATA(21):
    case NVC697_CALL_MME_DATA(22):
    case NVC697_CALL_MME_DATA(23):
    case NVC697_CALL_MME_DATA(24):
    case NVC697_CALL_MME_DATA(25):
    case NVC697_CALL_MME_DATA(26):
    case NVC697_CALL_MME_DATA(27):
    case NVC697_CALL_MME_DATA(28):
    case NVC697_CALL_MME_DATA(29):
    case NVC697_CALL_MME_DATA(30):
    case NVC697_CALL_MME_DATA(31):
    case NVC697_CALL_MME_DATA(32):
    case NVC697_CALL_MME_DATA(33):
    case NVC697_CALL_MME_DATA(34):
    case NVC697_CALL_MME_DATA(35):
    case NVC697_CALL_MME_DATA(36):
    case NVC697_CALL_MME_DATA(37):
    case NVC697_CALL_MME_DATA(38):
    case NVC697_CALL_MME_DATA(39):
    case NVC697_CALL_MME_DATA(40):
    case NVC697_CALL_MME_DATA(41):
    case NVC697_CALL_MME_DATA(42):
    case NVC697_CALL_MME_DATA(43):
    case NVC697_CALL_MME_DATA(44):
    case NVC697_CALL_MME_DATA(45):
    case NVC697_CALL_MME_DATA(46):
    case NVC697_CALL_MME_DATA(47):
    case NVC697_CALL_MME_DATA(48):
    case NVC697_CALL_MME_DATA(49):
    case NVC697_CALL_MME_DATA(50):
    case NVC697_CALL_MME_DATA(51):
    case NVC697_CALL_MME_DATA(52):
    case NVC697_CALL_MME_DATA(53):
    case NVC697_CALL_MME_DATA(54):
    case NVC697_CALL_MME_DATA(55):
    case NVC697_CALL_MME_DATA(56):
    case NVC697_CALL_MME_DATA(57):
    case NVC697_CALL_MME_DATA(58):
    case NVC697_CALL_MME_DATA(59):
    case NVC697_CALL_MME_DATA(60):
    case NVC697_CALL_MME_DATA(61):
    case NVC697_CALL_MME_DATA(62):
    case NVC697_CALL_MME_DATA(63):
    case NVC697_CALL_MME_DATA(64):
    case NVC697_CALL_MME_DATA(65):
    case NVC697_CALL_MME_DATA(66):
    case NVC697_CALL_MME_DATA(67):
    case NVC697_CALL_MME_DATA(68):
    case NVC697_CALL_MME_DATA(69):
    case NVC697_CALL_MME_DATA(70):
    case NVC697_CALL_MME_DATA(71):
    case NVC697_CALL_MME_DATA(72):
    case NVC697_CALL_MME_DATA(73):
    case NVC697_CALL_MME_DATA(74):
    case NVC697_CALL_MME_DATA(75):
    case NVC697_CALL_MME_DATA(76):
    case NVC697_CALL_MME_DATA(77):
    case NVC697_CALL_MME_DATA(78):
    case NVC697_CALL_MME_DATA(79):
    case NVC697_CALL_MME_DATA(80):
    case NVC697_CALL_MME_DATA(81):
    case NVC697_CALL_MME_DATA(82):
    case NVC697_CALL_MME_DATA(83):
    case NVC697_CALL_MME_DATA(84):
    case NVC697_CALL_MME_DATA(85):
    case NVC697_CALL_MME_DATA(86):
    case NVC697_CALL_MME_DATA(87):
    case NVC697_CALL_MME_DATA(88):
    case NVC697_CALL_MME_DATA(89):
    case NVC697_CALL_MME_DATA(90):
    case NVC697_CALL_MME_DATA(91):
    case NVC697_CALL_MME_DATA(92):
    case NVC697_CALL_MME_DATA(93):
    case NVC697_CALL_MME_DATA(94):
    case NVC697_CALL_MME_DATA(95):
    case NVC697_CALL_MME_DATA(96):
    case NVC697_CALL_MME_DATA(97):
    case NVC697_CALL_MME_DATA(98):
    case NVC697_CALL_MME_DATA(99):
    case NVC697_CALL_MME_DATA(100):
    case NVC697_CALL_MME_DATA(101):
    case NVC697_CALL_MME_DATA(102):
    case NVC697_CALL_MME_DATA(103):
    case NVC697_CALL_MME_DATA(104):
    case NVC697_CALL_MME_DATA(105):
    case NVC697_CALL_MME_DATA(106):
    case NVC697_CALL_MME_DATA(107):
    case NVC697_CALL_MME_DATA(108):
    case NVC697_CALL_MME_DATA(109):
    case NVC697_CALL_MME_DATA(110):
    case NVC697_CALL_MME_DATA(111):
    case NVC697_CALL_MME_DATA(112):
    case NVC697_CALL_MME_DATA(113):
    case NVC697_CALL_MME_DATA(114):
    case NVC697_CALL_MME_DATA(115):
    case NVC697_CALL_MME_DATA(116):
    case NVC697_CALL_MME_DATA(117):
    case NVC697_CALL_MME_DATA(118):
    case NVC697_CALL_MME_DATA(119):
    case NVC697_CALL_MME_DATA(120):
    case NVC697_CALL_MME_DATA(121):
    case NVC697_CALL_MME_DATA(122):
    case NVC697_CALL_MME_DATA(123):
    case NVC697_CALL_MME_DATA(124):
    case NVC697_CALL_MME_DATA(125):
    case NVC697_CALL_MME_DATA(126):
    case NVC697_CALL_MME_DATA(127):
    case NVC697_CALL_MME_DATA(128):
    case NVC697_CALL_MME_DATA(129):
    case NVC697_CALL_MME_DATA(130):
    case NVC697_CALL_MME_DATA(131):
    case NVC697_CALL_MME_DATA(132):
    case NVC697_CALL_MME_DATA(133):
    case NVC697_CALL_MME_DATA(134):
    case NVC697_CALL_MME_DATA(135):
    case NVC697_CALL_MME_DATA(136):
    case NVC697_CALL_MME_DATA(137):
    case NVC697_CALL_MME_DATA(138):
    case NVC697_CALL_MME_DATA(139):
    case NVC697_CALL_MME_DATA(140):
    case NVC697_CALL_MME_DATA(141):
    case NVC697_CALL_MME_DATA(142):
    case NVC697_CALL_MME_DATA(143):
    case NVC697_CALL_MME_DATA(144):
    case NVC697_CALL_MME_DATA(145):
    case NVC697_CALL_MME_DATA(146):
    case NVC697_CALL_MME_DATA(147):
    case NVC697_CALL_MME_DATA(148):
    case NVC697_CALL_MME_DATA(149):
    case NVC697_CALL_MME_DATA(150):
    case NVC697_CALL_MME_DATA(151):
    case NVC697_CALL_MME_DATA(152):
    case NVC697_CALL_MME_DATA(153):
    case NVC697_CALL_MME_DATA(154):
    case NVC697_CALL_MME_DATA(155):
    case NVC697_CALL_MME_DATA(156):
    case NVC697_CALL_MME_DATA(157):
    case NVC697_CALL_MME_DATA(158):
    case NVC697_CALL_MME_DATA(159):
    case NVC697_CALL_MME_DATA(160):
    case NVC697_CALL_MME_DATA(161):
    case NVC697_CALL_MME_DATA(162):
    case NVC697_CALL_MME_DATA(163):
    case NVC697_CALL_MME_DATA(164):
    case NVC697_CALL_MME_DATA(165):
    case NVC697_CALL_MME_DATA(166):
    case NVC697_CALL_MME_DATA(167):
    case NVC697_CALL_MME_DATA(168):
    case NVC697_CALL_MME_DATA(169):
    case NVC697_CALL_MME_DATA(170):
    case NVC697_CALL_MME_DATA(171):
    case NVC697_CALL_MME_DATA(172):
    case NVC697_CALL_MME_DATA(173):
    case NVC697_CALL_MME_DATA(174):
    case NVC697_CALL_MME_DATA(175):
    case NVC697_CALL_MME_DATA(176):
    case NVC697_CALL_MME_DATA(177):
    case NVC697_CALL_MME_DATA(178):
    case NVC697_CALL_MME_DATA(179):
    case NVC697_CALL_MME_DATA(180):
    case NVC697_CALL_MME_DATA(181):
    case NVC697_CALL_MME_DATA(182):
    case NVC697_CALL_MME_DATA(183):
    case NVC697_CALL_MME_DATA(184):
    case NVC697_CALL_MME_DATA(185):
    case NVC697_CALL_MME_DATA(186):
    case NVC697_CALL_MME_DATA(187):
    case NVC697_CALL_MME_DATA(188):
    case NVC697_CALL_MME_DATA(189):
    case NVC697_CALL_MME_DATA(190):
    case NVC697_CALL_MME_DATA(191):
    case NVC697_CALL_MME_DATA(192):
    case NVC697_CALL_MME_DATA(193):
    case NVC697_CALL_MME_DATA(194):
    case NVC697_CALL_MME_DATA(195):
    case NVC697_CALL_MME_DATA(196):
    case NVC697_CALL_MME_DATA(197):
    case NVC697_CALL_MME_DATA(198):
    case NVC697_CALL_MME_DATA(199):
    case NVC697_CALL_MME_DATA(200):
    case NVC697_CALL_MME_DATA(201):
    case NVC697_CALL_MME_DATA(202):
    case NVC697_CALL_MME_DATA(203):
    case NVC697_CALL_MME_DATA(204):
    case NVC697_CALL_MME_DATA(205):
    case NVC697_CALL_MME_DATA(206):
    case NVC697_CALL_MME_DATA(207):
    case NVC697_CALL_MME_DATA(208):
    case NVC697_CALL_MME_DATA(209):
    case NVC697_CALL_MME_DATA(210):
    case NVC697_CALL_MME_DATA(211):
    case NVC697_CALL_MME_DATA(212):
    case NVC697_CALL_MME_DATA(213):
    case NVC697_CALL_MME_DATA(214):
    case NVC697_CALL_MME_DATA(215):
    case NVC697_CALL_MME_DATA(216):
    case NVC697_CALL_MME_DATA(217):
    case NVC697_CALL_MME_DATA(218):
    case NVC697_CALL_MME_DATA(219):
    case NVC697_CALL_MME_DATA(220):
    case NVC697_CALL_MME_DATA(221):
    case NVC697_CALL_MME_DATA(222):
    case NVC697_CALL_MME_DATA(223):
    case NVC697_CALL_MME_DATA(224):
    case NVC697_CALL_MME_DATA(225):
    case NVC697_CALL_MME_DATA(226):
    case NVC697_CALL_MME_DATA(227):
    case NVC697_CALL_MME_DATA(228):
    case NVC697_CALL_MME_DATA(229):
    case NVC697_CALL_MME_DATA(230):
    case NVC697_CALL_MME_DATA(231):
    case NVC697_CALL_MME_DATA(232):
    case NVC697_CALL_MME_DATA(233):
    case NVC697_CALL_MME_DATA(234):
    case NVC697_CALL_MME_DATA(235):
    case NVC697_CALL_MME_DATA(236):
    case NVC697_CALL_MME_DATA(237):
    case NVC697_CALL_MME_DATA(238):
    case NVC697_CALL_MME_DATA(239):
    case NVC697_CALL_MME_DATA(240):
    case NVC697_CALL_MME_DATA(241):
    case NVC697_CALL_MME_DATA(242):
    case NVC697_CALL_MME_DATA(243):
    case NVC697_CALL_MME_DATA(244):
    case NVC697_CALL_MME_DATA(245):
    case NVC697_CALL_MME_DATA(246):
    case NVC697_CALL_MME_DATA(247):
    case NVC697_CALL_MME_DATA(248):
    case NVC697_CALL_MME_DATA(249):
    case NVC697_CALL_MME_DATA(250):
    case NVC697_CALL_MME_DATA(251):
    case NVC697_CALL_MME_DATA(252):
    case NVC697_CALL_MME_DATA(253):
    case NVC697_CALL_MME_DATA(254):
    case NVC697_CALL_MME_DATA(255):
    
        parsed = data;
        fprintf(fp, "%s.V = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
    default:
        fprintf(fp, "%s.VALUE = 0x%x\n", prefix, data);
        break;
    }
}
