// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlpcollectormetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

type Metrics struct {
	orig  *otlpcollectormetrics.ExportMetricsServiceRequest
	state *State
}

func GetOrigMetrics(ms Metrics) *otlpcollectormetrics.ExportMetricsServiceRequest {
	return ms.orig
}

func GetMetricsState(ms Metrics) *State {
	return ms.state
}

func NewMetrics(orig *otlpcollectormetrics.ExportMetricsServiceRequest, state *State) Metrics {
	return Metrics{orig: orig, state: state}
}

var (
	protoPoolExportMetricsServiceRequest = sync.Pool{
		New: func() any {
			return &otlpcollectormetrics.ExportMetricsServiceRequest{}
		},
	}
)

func NewOrigExportMetricsServiceRequest() *otlpcollectormetrics.ExportMetricsServiceRequest {
	if !UseProtoPooling.IsEnabled() {
		return &otlpcollectormetrics.ExportMetricsServiceRequest{}
	}
	return protoPoolExportMetricsServiceRequest.Get().(*otlpcollectormetrics.ExportMetricsServiceRequest)
}

func DeleteOrigExportMetricsServiceRequest(orig *otlpcollectormetrics.ExportMetricsServiceRequest, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	for i := range orig.ResourceMetrics {
		DeleteOrigResourceMetrics(orig.ResourceMetrics[i], true)
	}

	orig.Reset()
	if nullable {
		protoPoolExportMetricsServiceRequest.Put(orig)
	}
}

func CopyOrigExportMetricsServiceRequest(dest, src *otlpcollectormetrics.ExportMetricsServiceRequest) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.ResourceMetrics = CopyOrigResourceMetricsSlice(dest.ResourceMetrics, src.ResourceMetrics)
}

func GenTestOrigExportMetricsServiceRequest() *otlpcollectormetrics.ExportMetricsServiceRequest {
	orig := NewOrigExportMetricsServiceRequest()
	orig.ResourceMetrics = GenerateOrigTestResourceMetricsSlice()
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigExportMetricsServiceRequest(orig *otlpcollectormetrics.ExportMetricsServiceRequest, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.ResourceMetrics) > 0 {
		dest.WriteObjectField("resourceMetrics")
		dest.WriteArrayStart()
		MarshalJSONOrigResourceMetrics(orig.ResourceMetrics[0], dest)
		for i := 1; i < len(orig.ResourceMetrics); i++ {
			dest.WriteMore()
			MarshalJSONOrigResourceMetrics(orig.ResourceMetrics[i], dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigMetrics unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExportMetricsServiceRequest(orig *otlpcollectormetrics.ExportMetricsServiceRequest, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "resourceMetrics", "resource_metrics":
			for iter.ReadArray() {
				orig.ResourceMetrics = append(orig.ResourceMetrics, NewOrigResourceMetrics())
				UnmarshalJSONOrigResourceMetrics(orig.ResourceMetrics[len(orig.ResourceMetrics)-1], iter)
			}

		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigExportMetricsServiceRequest(orig *otlpcollectormetrics.ExportMetricsServiceRequest) int {
	var n int
	var l int
	_ = l
	for i := range orig.ResourceMetrics {
		l = SizeProtoOrigResourceMetrics(orig.ResourceMetrics[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigExportMetricsServiceRequest(orig *otlpcollectormetrics.ExportMetricsServiceRequest, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.ResourceMetrics) - 1; i >= 0; i-- {
		l = MarshalProtoOrigResourceMetrics(orig.ResourceMetrics[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigExportMetricsServiceRequest(orig *otlpcollectormetrics.ExportMetricsServiceRequest, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceMetrics", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.ResourceMetrics = append(orig.ResourceMetrics, NewOrigResourceMetrics())
			err = UnmarshalProtoOrigResourceMetrics(orig.ResourceMetrics[len(orig.ResourceMetrics)-1], buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
