/* assert.c generated by valac 0.56.18, the Vala compiler
 * generated from assert.vala, do not modify */

/*
* Copyright (C) 2018  Trevor Williams <phase1geo@icloud.com>
* 
* This program is free software: you can redistribute it and/or modify
* it under the terms of the Lesser GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* Lesser GNU General Public License for more details.
* 
* You should have received a copy of the Lesser GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define APP_TESTS_TYPE_ASSERT (app_tests_assert_get_type ())
#define APP_TESTS_ASSERT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APP_TESTS_TYPE_ASSERT, AppTestsAssert))
#define APP_TESTS_ASSERT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APP_TESTS_TYPE_ASSERT, AppTestsAssertClass))
#define APP_TESTS_IS_ASSERT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APP_TESTS_TYPE_ASSERT))
#define APP_TESTS_IS_ASSERT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APP_TESTS_TYPE_ASSERT))
#define APP_TESTS_ASSERT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APP_TESTS_TYPE_ASSERT, AppTestsAssertClass))

typedef struct _AppTestsAssert AppTestsAssert;
typedef struct _AppTestsAssertClass AppTestsAssertClass;
typedef struct _AppTestsAssertPrivate AppTestsAssertPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AppTestsParamSpecAssert AppTestsParamSpecAssert;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AppTestsAssert {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AppTestsAssertPrivate * priv;
};

struct _AppTestsAssertClass {
	GTypeClass parent_class;
	void (*finalize) (AppTestsAssert *self);
};

struct _AppTestsParamSpecAssert {
	GParamSpec parent_instance;
};

static gpointer app_tests_assert_parent_class = NULL;

VALA_EXTERN gpointer app_tests_assert_ref (gpointer instance);
VALA_EXTERN void app_tests_assert_unref (gpointer instance);
VALA_EXTERN GParamSpec* app_tests_param_spec_assert (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void app_tests_value_set_assert (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void app_tests_value_take_assert (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer app_tests_value_get_assert (const GValue* value);
VALA_EXTERN GType app_tests_assert_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppTestsAssert, app_tests_assert_unref)
VALA_EXTERN void app_tests_assert_string_compare (const gchar* expected,
                                      const gchar* actual,
                                      const gchar* compare);
VALA_EXTERN void app_tests_assert_bool_compare (gboolean* expected,
                                    gboolean* actual,
                                    const gchar* compare);
static gboolean _bool_equal (const gboolean * s1,
                      const gboolean * s2);
VALA_EXTERN void app_tests_assert_int_compare (gint* expected,
                                   gint* actual,
                                   const gchar* compare);
static gboolean _int_equal (const gint * s1,
                     const gint * s2);
VALA_EXTERN void app_tests_assert_float_compare (gfloat* expected,
                                     gfloat* actual,
                                     const gchar* compare);
static gboolean _float_equal (const gfloat * s1,
                       const gfloat * s2);
VALA_EXTERN void app_tests_assert_double_compare (gdouble* expected,
                                      gdouble* actual,
                                      const gchar* compare);
static gboolean _double_equal (const gdouble * s1,
                        const gdouble * s2);
VALA_EXTERN void app_tests_assert_true (gboolean* expected);
VALA_EXTERN void app_tests_assert_false (gboolean* expected);
VALA_EXTERN AppTestsAssert* app_tests_assert_new (void);
VALA_EXTERN AppTestsAssert* app_tests_assert_construct (GType object_type);
static void app_tests_assert_finalize (AppTestsAssert * obj);
static GType app_tests_assert_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

void
app_tests_assert_string_compare (const gchar* expected,
                                 const gchar* actual,
                                 const gchar* compare)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	g_return_if_fail (compare != NULL);
	_tmp0_ = compare;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("!=")))) {
		switch (0) {
			default:
			{
				if (g_strcmp0 (expected, actual) == 0) {
					gchar* _tmp3_;
					gchar* _tmp4_;
					gchar* _tmp5_;
					gchar* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp3_ = g_strconcat ("Expected '", expected, NULL);
					_tmp4_ = _tmp3_;
					_tmp5_ = g_strconcat (_tmp4_, "', got '", NULL);
					_tmp6_ = _tmp5_;
					_tmp7_ = g_strconcat (_tmp6_, actual, NULL);
					_tmp8_ = _tmp7_;
					_tmp9_ = g_strconcat (_tmp8_, "'", NULL);
					_tmp10_ = _tmp9_;
					g_warning ("assert.vala:31: %s", _tmp10_);
					_g_free0 (_tmp10_);
					_g_free0 (_tmp8_);
					_g_free0 (_tmp6_);
					_g_free0 (_tmp4_);
					_vala_assert (g_strcmp0 (expected, actual) != 0, "expected != actual");
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				if (g_strcmp0 (expected, actual) != 0) {
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp11_ = g_strconcat ("Expected '", expected, NULL);
					_tmp12_ = _tmp11_;
					_tmp13_ = g_strconcat (_tmp12_, "' to not equal '", NULL);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_strconcat (_tmp14_, actual, NULL);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_strconcat (_tmp16_, "'", NULL);
					_tmp18_ = _tmp17_;
					g_warning ("assert.vala:38: %s", _tmp18_);
					_g_free0 (_tmp18_);
					_g_free0 (_tmp16_);
					_g_free0 (_tmp14_);
					_g_free0 (_tmp12_);
					_vala_assert (g_strcmp0 (expected, actual) == 0, "expected == actual");
				}
				break;
			}
		}
	}
}

static gboolean
_bool_equal (const gboolean * s1,
             const gboolean * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

void
app_tests_assert_bool_compare (gboolean* expected,
                               gboolean* actual,
                               const gchar* compare)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	g_return_if_fail (compare != NULL);
	_tmp0_ = compare;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("!=")))) {
		switch (0) {
			default:
			{
				if (_bool_equal (expected, actual) == TRUE) {
					gchar* _tmp3_;
					gchar* _tmp4_;
					gchar* _tmp5_;
					gchar* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp3_ = bool_to_string (*expected);
					_tmp4_ = _tmp3_;
					_tmp5_ = g_strconcat ("Expected '", _tmp4_, NULL);
					_tmp6_ = _tmp5_;
					_tmp7_ = g_strconcat (_tmp6_, "', got '", NULL);
					_tmp8_ = _tmp7_;
					_tmp9_ = bool_to_string (*actual);
					_tmp10_ = _tmp9_;
					_tmp11_ = g_strconcat (_tmp8_, _tmp10_, NULL);
					_tmp12_ = _tmp11_;
					_tmp13_ = g_strconcat (_tmp12_, "'", NULL);
					_tmp14_ = _tmp13_;
					g_warning ("assert.vala:50: %s", _tmp14_);
					_g_free0 (_tmp14_);
					_g_free0 (_tmp12_);
					_g_free0 (_tmp10_);
					_g_free0 (_tmp8_);
					_g_free0 (_tmp6_);
					_g_free0 (_tmp4_);
					_vala_assert (_bool_equal (expected, actual) != TRUE, "expected != actual");
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				if (_bool_equal (expected, actual) != TRUE) {
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					_tmp15_ = bool_to_string (*expected);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_strconcat ("Expected '", _tmp16_, NULL);
					_tmp18_ = _tmp17_;
					_tmp19_ = g_strconcat (_tmp18_, "' to not equal '", NULL);
					_tmp20_ = _tmp19_;
					_tmp21_ = bool_to_string (*actual);
					_tmp22_ = _tmp21_;
					_tmp23_ = g_strconcat (_tmp20_, _tmp22_, NULL);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_strconcat (_tmp24_, "'", NULL);
					_tmp26_ = _tmp25_;
					g_warning ("assert.vala:57: %s", _tmp26_);
					_g_free0 (_tmp26_);
					_g_free0 (_tmp24_);
					_g_free0 (_tmp22_);
					_g_free0 (_tmp20_);
					_g_free0 (_tmp18_);
					_g_free0 (_tmp16_);
					_vala_assert (_bool_equal (expected, actual) == TRUE, "expected == actual");
				}
				break;
			}
		}
	}
}

static gboolean
_int_equal (const gint * s1,
            const gint * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

void
app_tests_assert_int_compare (gint* expected,
                              gint* actual,
                              const gchar* compare)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	g_return_if_fail (compare != NULL);
	_tmp0_ = compare;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (">")))) {
		switch (0) {
			default:
			{
				if ((*expected) <= (*actual)) {
					gchar* _tmp3_;
					gchar* _tmp4_;
					gchar* _tmp5_;
					gchar* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp3_ = g_strdup_printf ("%i", *expected);
					_tmp4_ = _tmp3_;
					_tmp5_ = g_strconcat (_tmp4_, " is less than or equal to ", NULL);
					_tmp6_ = _tmp5_;
					_tmp7_ = g_strdup_printf ("%i", *actual);
					_tmp8_ = _tmp7_;
					_tmp9_ = g_strconcat (_tmp6_, _tmp8_, NULL);
					_tmp10_ = _tmp9_;
					g_warning ("assert.vala:68: %s", _tmp10_);
					_g_free0 (_tmp10_);
					_g_free0 (_tmp8_);
					_g_free0 (_tmp6_);
					_g_free0 (_tmp4_);
					_vala_assert ((*expected) <= (*actual), "expected <= actual");
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string (">=")))) {
		switch (0) {
			default:
			{
				if ((*expected) < (*actual)) {
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp11_ = g_strdup_printf ("%i", *expected);
					_tmp12_ = _tmp11_;
					_tmp13_ = g_strconcat (_tmp12_, " is less than ", NULL);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_strdup_printf ("%i", *actual);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_strconcat (_tmp14_, _tmp16_, NULL);
					_tmp18_ = _tmp17_;
					g_warning ("assert.vala:74: %s", _tmp18_);
					_g_free0 (_tmp18_);
					_g_free0 (_tmp16_);
					_g_free0 (_tmp14_);
					_g_free0 (_tmp12_);
					_vala_assert ((*expected) < (*actual), "expected < actual");
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("<")))) {
		switch (0) {
			default:
			{
				if ((*expected) >= (*actual)) {
					gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					_tmp19_ = g_strdup_printf ("%i", *expected);
					_tmp20_ = _tmp19_;
					_tmp21_ = g_strconcat (_tmp20_, " is greater than or equal to ", NULL);
					_tmp22_ = _tmp21_;
					_tmp23_ = g_strdup_printf ("%i", *actual);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_strconcat (_tmp22_, _tmp24_, NULL);
					_tmp26_ = _tmp25_;
					g_warning ("assert.vala:80: %s", _tmp26_);
					_g_free0 (_tmp26_);
					_g_free0 (_tmp24_);
					_g_free0 (_tmp22_);
					_g_free0 (_tmp20_);
					_vala_assert ((*expected) >= (*actual), "expected >= actual");
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("<=")))) {
		switch (0) {
			default:
			{
				if ((*expected) > (*actual)) {
					gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					_tmp27_ = g_strdup_printf ("%i", *expected);
					_tmp28_ = _tmp27_;
					_tmp29_ = g_strconcat (_tmp28_, " is greater than ", NULL);
					_tmp30_ = _tmp29_;
					_tmp31_ = g_strdup_printf ("%i", *actual);
					_tmp32_ = _tmp31_;
					_tmp33_ = g_strconcat (_tmp30_, _tmp32_, NULL);
					_tmp34_ = _tmp33_;
					g_warning ("assert.vala:86: %s", _tmp34_);
					_g_free0 (_tmp34_);
					_g_free0 (_tmp32_);
					_g_free0 (_tmp30_);
					_g_free0 (_tmp28_);
					_vala_assert ((*expected) > (*actual), "expected > actual");
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("!=")))) {
		switch (0) {
			default:
			{
				if (_int_equal (expected, actual) == TRUE) {
					gchar* _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					_tmp35_ = g_strdup_printf ("%i", *expected);
					_tmp36_ = _tmp35_;
					_tmp37_ = g_strconcat (_tmp36_, " is equal to ", NULL);
					_tmp38_ = _tmp37_;
					_tmp39_ = g_strdup_printf ("%i", *actual);
					_tmp40_ = _tmp39_;
					_tmp41_ = g_strconcat (_tmp38_, _tmp40_, NULL);
					_tmp42_ = _tmp41_;
					g_warning ("assert.vala:92: %s", _tmp42_);
					_g_free0 (_tmp42_);
					_g_free0 (_tmp40_);
					_g_free0 (_tmp38_);
					_g_free0 (_tmp36_);
					_vala_assert (_int_equal (expected, actual) != TRUE, "expected != actual");
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				if (_int_equal (expected, actual) != TRUE) {
					gchar* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					_tmp43_ = g_strdup_printf ("%i", *expected);
					_tmp44_ = _tmp43_;
					_tmp45_ = g_strconcat (_tmp44_, " is not equal to ", NULL);
					_tmp46_ = _tmp45_;
					_tmp47_ = g_strdup_printf ("%i", *actual);
					_tmp48_ = _tmp47_;
					_tmp49_ = g_strconcat (_tmp46_, _tmp48_, NULL);
					_tmp50_ = _tmp49_;
					g_warning ("assert.vala:99: %s", _tmp50_);
					_g_free0 (_tmp50_);
					_g_free0 (_tmp48_);
					_g_free0 (_tmp46_);
					_g_free0 (_tmp44_);
					_vala_assert (_int_equal (expected, actual) == TRUE, "expected == actual");
				}
				break;
			}
		}
	}
}

static gboolean
_float_equal (const gfloat * s1,
              const gfloat * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

void
app_tests_assert_float_compare (gfloat* expected,
                                gfloat* actual,
                                const gchar* compare)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	g_return_if_fail (compare != NULL);
	_tmp0_ = compare;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (">")))) {
		switch (0) {
			default:
			{
				if ((*expected) <= (*actual)) {
					gchar* _tmp3_;
					gchar* _tmp4_;
					gchar* _tmp5_;
					gchar* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp3_ = g_strdup_printf ("%g", *expected);
					_tmp4_ = _tmp3_;
					_tmp5_ = g_strconcat (_tmp4_, " is less than or equal to ", NULL);
					_tmp6_ = _tmp5_;
					_tmp7_ = g_strdup_printf ("%g", *actual);
					_tmp8_ = _tmp7_;
					_tmp9_ = g_strconcat (_tmp6_, _tmp8_, NULL);
					_tmp10_ = _tmp9_;
					g_warning ("assert.vala:110: %s", _tmp10_);
					_g_free0 (_tmp10_);
					_g_free0 (_tmp8_);
					_g_free0 (_tmp6_);
					_g_free0 (_tmp4_);
					_vala_assert ((*expected) <= (*actual), "expected <= actual");
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string (">=")))) {
		switch (0) {
			default:
			{
				if ((*expected) < (*actual)) {
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp11_ = g_strdup_printf ("%g", *expected);
					_tmp12_ = _tmp11_;
					_tmp13_ = g_strconcat (_tmp12_, " is less than ", NULL);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_strdup_printf ("%g", *actual);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_strconcat (_tmp14_, _tmp16_, NULL);
					_tmp18_ = _tmp17_;
					g_warning ("assert.vala:116: %s", _tmp18_);
					_g_free0 (_tmp18_);
					_g_free0 (_tmp16_);
					_g_free0 (_tmp14_);
					_g_free0 (_tmp12_);
					_vala_assert ((*expected) < (*actual), "expected < actual");
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("<")))) {
		switch (0) {
			default:
			{
				if ((*expected) >= (*actual)) {
					gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					_tmp19_ = g_strdup_printf ("%g", *expected);
					_tmp20_ = _tmp19_;
					_tmp21_ = g_strconcat (_tmp20_, " is greater than or equal to ", NULL);
					_tmp22_ = _tmp21_;
					_tmp23_ = g_strdup_printf ("%g", *actual);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_strconcat (_tmp22_, _tmp24_, NULL);
					_tmp26_ = _tmp25_;
					g_warning ("assert.vala:122: %s", _tmp26_);
					_g_free0 (_tmp26_);
					_g_free0 (_tmp24_);
					_g_free0 (_tmp22_);
					_g_free0 (_tmp20_);
					_vala_assert ((*expected) >= (*actual), "expected >= actual");
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("<=")))) {
		switch (0) {
			default:
			{
				if ((*expected) > (*actual)) {
					gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					_tmp27_ = g_strdup_printf ("%g", *expected);
					_tmp28_ = _tmp27_;
					_tmp29_ = g_strconcat (_tmp28_, " is greater than ", NULL);
					_tmp30_ = _tmp29_;
					_tmp31_ = g_strdup_printf ("%g", *actual);
					_tmp32_ = _tmp31_;
					_tmp33_ = g_strconcat (_tmp30_, _tmp32_, NULL);
					_tmp34_ = _tmp33_;
					g_warning ("assert.vala:128: %s", _tmp34_);
					_g_free0 (_tmp34_);
					_g_free0 (_tmp32_);
					_g_free0 (_tmp30_);
					_g_free0 (_tmp28_);
					_vala_assert ((*expected) > (*actual), "expected > actual");
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("!=")))) {
		switch (0) {
			default:
			{
				if (_float_equal (expected, actual) == TRUE) {
					gchar* _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					_tmp35_ = g_strdup_printf ("%g", *expected);
					_tmp36_ = _tmp35_;
					_tmp37_ = g_strconcat (_tmp36_, " is equal to ", NULL);
					_tmp38_ = _tmp37_;
					_tmp39_ = g_strdup_printf ("%g", *actual);
					_tmp40_ = _tmp39_;
					_tmp41_ = g_strconcat (_tmp38_, _tmp40_, NULL);
					_tmp42_ = _tmp41_;
					g_warning ("assert.vala:134: %s", _tmp42_);
					_g_free0 (_tmp42_);
					_g_free0 (_tmp40_);
					_g_free0 (_tmp38_);
					_g_free0 (_tmp36_);
					_vala_assert (_float_equal (expected, actual) != TRUE, "expected != actual");
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				if (_float_equal (expected, actual) != TRUE) {
					gchar* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					_tmp43_ = g_strdup_printf ("%g", *expected);
					_tmp44_ = _tmp43_;
					_tmp45_ = g_strconcat (_tmp44_, " is not equal to ", NULL);
					_tmp46_ = _tmp45_;
					_tmp47_ = g_strdup_printf ("%g", *actual);
					_tmp48_ = _tmp47_;
					_tmp49_ = g_strconcat (_tmp46_, _tmp48_, NULL);
					_tmp50_ = _tmp49_;
					g_warning ("assert.vala:141: %s", _tmp50_);
					_g_free0 (_tmp50_);
					_g_free0 (_tmp48_);
					_g_free0 (_tmp46_);
					_g_free0 (_tmp44_);
					_vala_assert (_float_equal (expected, actual) == TRUE, "expected == actual");
				}
				break;
			}
		}
	}
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static gboolean
_double_equal (const gdouble * s1,
               const gdouble * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

void
app_tests_assert_double_compare (gdouble* expected,
                                 gdouble* actual,
                                 const gchar* compare)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	g_return_if_fail (compare != NULL);
	_tmp0_ = compare;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (">")))) {
		switch (0) {
			default:
			{
				if ((*expected) <= (*actual)) {
					gchar* _tmp3_;
					gchar* _tmp4_;
					gchar* _tmp5_;
					gchar* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp3_ = double_to_string (*expected);
					_tmp4_ = _tmp3_;
					_tmp5_ = g_strconcat (_tmp4_, " is less than or equal to ", NULL);
					_tmp6_ = _tmp5_;
					_tmp7_ = double_to_string (*actual);
					_tmp8_ = _tmp7_;
					_tmp9_ = g_strconcat (_tmp6_, _tmp8_, NULL);
					_tmp10_ = _tmp9_;
					g_warning ("assert.vala:152: %s", _tmp10_);
					_g_free0 (_tmp10_);
					_g_free0 (_tmp8_);
					_g_free0 (_tmp6_);
					_g_free0 (_tmp4_);
					_vala_assert ((*expected) <= (*actual), "expected <= actual");
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string (">=")))) {
		switch (0) {
			default:
			{
				if ((*expected) < (*actual)) {
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp11_ = double_to_string (*expected);
					_tmp12_ = _tmp11_;
					_tmp13_ = g_strconcat (_tmp12_, " is less than ", NULL);
					_tmp14_ = _tmp13_;
					_tmp15_ = double_to_string (*actual);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_strconcat (_tmp14_, _tmp16_, NULL);
					_tmp18_ = _tmp17_;
					g_warning ("assert.vala:158: %s", _tmp18_);
					_g_free0 (_tmp18_);
					_g_free0 (_tmp16_);
					_g_free0 (_tmp14_);
					_g_free0 (_tmp12_);
					_vala_assert ((*expected) < (*actual), "expected < actual");
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("<")))) {
		switch (0) {
			default:
			{
				if ((*expected) >= (*actual)) {
					gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					_tmp19_ = double_to_string (*expected);
					_tmp20_ = _tmp19_;
					_tmp21_ = g_strconcat (_tmp20_, " is greater than or equal to ", NULL);
					_tmp22_ = _tmp21_;
					_tmp23_ = double_to_string (*actual);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_strconcat (_tmp22_, _tmp24_, NULL);
					_tmp26_ = _tmp25_;
					g_warning ("assert.vala:164: %s", _tmp26_);
					_g_free0 (_tmp26_);
					_g_free0 (_tmp24_);
					_g_free0 (_tmp22_);
					_g_free0 (_tmp20_);
					_vala_assert ((*expected) >= (*actual), "expected >= actual");
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("<=")))) {
		switch (0) {
			default:
			{
				if ((*expected) > (*actual)) {
					gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					_tmp27_ = double_to_string (*expected);
					_tmp28_ = _tmp27_;
					_tmp29_ = g_strconcat (_tmp28_, " is greater than ", NULL);
					_tmp30_ = _tmp29_;
					_tmp31_ = double_to_string (*actual);
					_tmp32_ = _tmp31_;
					_tmp33_ = g_strconcat (_tmp30_, _tmp32_, NULL);
					_tmp34_ = _tmp33_;
					g_warning ("assert.vala:170: %s", _tmp34_);
					_g_free0 (_tmp34_);
					_g_free0 (_tmp32_);
					_g_free0 (_tmp30_);
					_g_free0 (_tmp28_);
					_vala_assert ((*expected) > (*actual), "expected > actual");
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("!=")))) {
		switch (0) {
			default:
			{
				if (_double_equal (expected, actual) == TRUE) {
					gchar* _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					_tmp35_ = double_to_string (*expected);
					_tmp36_ = _tmp35_;
					_tmp37_ = g_strconcat (_tmp36_, " is equal to ", NULL);
					_tmp38_ = _tmp37_;
					_tmp39_ = double_to_string (*actual);
					_tmp40_ = _tmp39_;
					_tmp41_ = g_strconcat (_tmp38_, _tmp40_, NULL);
					_tmp42_ = _tmp41_;
					g_warning ("assert.vala:176: %s", _tmp42_);
					_g_free0 (_tmp42_);
					_g_free0 (_tmp40_);
					_g_free0 (_tmp38_);
					_g_free0 (_tmp36_);
					_vala_assert (_double_equal (expected, actual) != TRUE, "expected != actual");
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				if (_double_equal (expected, actual) != TRUE) {
					gchar* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					_tmp43_ = double_to_string (*expected);
					_tmp44_ = _tmp43_;
					_tmp45_ = g_strconcat (_tmp44_, " is not equal to ", NULL);
					_tmp46_ = _tmp45_;
					_tmp47_ = double_to_string (*actual);
					_tmp48_ = _tmp47_;
					_tmp49_ = g_strconcat (_tmp46_, _tmp48_, NULL);
					_tmp50_ = _tmp49_;
					g_warning ("assert.vala:183: %s", _tmp50_);
					_g_free0 (_tmp50_);
					_g_free0 (_tmp48_);
					_g_free0 (_tmp46_);
					_g_free0 (_tmp44_);
					_vala_assert (_double_equal (expected, actual) == TRUE, "expected == actual");
				}
				break;
			}
		}
	}
}

void
app_tests_assert_true (gboolean* expected)
{
	gboolean _tmp0_;
	gboolean _tmp7_;
	_tmp0_ = TRUE;
	if (_bool_equal (expected, &_tmp0_) != TRUE) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp1_ = bool_to_string (*expected);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strconcat ("Expected '", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat (_tmp4_, "' to be true", NULL);
		_tmp6_ = _tmp5_;
		g_warning ("assert.vala:192: %s", _tmp6_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
	}
	_tmp7_ = TRUE;
	_vala_assert (_bool_equal (expected, &_tmp7_) == TRUE, "expected == true");
}

void
app_tests_assert_false (gboolean* expected)
{
	gboolean _tmp0_;
	gboolean _tmp7_;
	_tmp0_ = FALSE;
	if (_bool_equal (expected, &_tmp0_) != TRUE) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp1_ = bool_to_string (*expected);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strconcat ("Expected '", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat (_tmp4_, "' to be false", NULL);
		_tmp6_ = _tmp5_;
		g_warning ("assert.vala:200: %s", _tmp6_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
	}
	_tmp7_ = FALSE;
	_vala_assert (_bool_equal (expected, &_tmp7_) == TRUE, "expected == false");
}

AppTestsAssert*
app_tests_assert_construct (GType object_type)
{
	AppTestsAssert* self = NULL;
	self = (AppTestsAssert*) g_type_create_instance (object_type);
	return self;
}

AppTestsAssert*
app_tests_assert_new (void)
{
	return app_tests_assert_construct (APP_TESTS_TYPE_ASSERT);
}

static void
app_tests_value_assert_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
app_tests_value_assert_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		app_tests_assert_unref (value->data[0].v_pointer);
	}
}

static void
app_tests_value_assert_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = app_tests_assert_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
app_tests_value_assert_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
app_tests_value_assert_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		AppTestsAssert * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = app_tests_assert_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
app_tests_value_assert_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	AppTestsAssert ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = app_tests_assert_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
app_tests_param_spec_assert (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	AppTestsParamSpecAssert* spec;
	g_return_val_if_fail (g_type_is_a (object_type, APP_TESTS_TYPE_ASSERT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
app_tests_value_get_assert (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, APP_TESTS_TYPE_ASSERT), NULL);
	return value->data[0].v_pointer;
}

void
app_tests_value_set_assert (GValue* value,
                            gpointer v_object)
{
	AppTestsAssert * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, APP_TESTS_TYPE_ASSERT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, APP_TESTS_TYPE_ASSERT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		app_tests_assert_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		app_tests_assert_unref (old);
	}
}

void
app_tests_value_take_assert (GValue* value,
                             gpointer v_object)
{
	AppTestsAssert * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, APP_TESTS_TYPE_ASSERT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, APP_TESTS_TYPE_ASSERT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		app_tests_assert_unref (old);
	}
}

static void
app_tests_assert_class_init (AppTestsAssertClass * klass,
                             gpointer klass_data)
{
	app_tests_assert_parent_class = g_type_class_peek_parent (klass);
	((AppTestsAssertClass *) klass)->finalize = app_tests_assert_finalize;
}

static void
app_tests_assert_instance_init (AppTestsAssert * self,
                                gpointer klass)
{
	self->ref_count = 1;
}

static void
app_tests_assert_finalize (AppTestsAssert * obj)
{
	AppTestsAssert * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APP_TESTS_TYPE_ASSERT, AppTestsAssert);
	g_signal_handlers_destroy (self);
}

/**
     * The {@code Assert} class contains various helper functions for testing assertions
     *
     * @since 1.0.0
     */
static GType
app_tests_assert_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { app_tests_value_assert_init, app_tests_value_assert_free_value, app_tests_value_assert_copy_value, app_tests_value_assert_peek_pointer, "p", app_tests_value_assert_collect_value, "p", app_tests_value_assert_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (AppTestsAssertClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) app_tests_assert_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AppTestsAssert), 0, (GInstanceInitFunc) app_tests_assert_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType app_tests_assert_type_id;
	app_tests_assert_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AppTestsAssert", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return app_tests_assert_type_id;
}

GType
app_tests_assert_get_type (void)
{
	static volatile gsize app_tests_assert_type_id__once = 0;
	if (g_once_init_enter (&app_tests_assert_type_id__once)) {
		GType app_tests_assert_type_id;
		app_tests_assert_type_id = app_tests_assert_get_type_once ();
		g_once_init_leave (&app_tests_assert_type_id__once, app_tests_assert_type_id);
	}
	return app_tests_assert_type_id__once;
}

gpointer
app_tests_assert_ref (gpointer instance)
{
	AppTestsAssert * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
app_tests_assert_unref (gpointer instance)
{
	AppTestsAssert * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		APP_TESTS_ASSERT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

