/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "mm-gdbus-sim.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_pin,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_puk,
        const gchar *arg_pin,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOOLEAN (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringBooleanFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_pin,
        gboolean arg_enabled,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringBooleanFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringBooleanFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_boolean (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_preferred_networks,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.ModemManager1.Sim
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MmGdbusSim
 * @title: MmGdbusSim
 * @short_description: Generated C code for the org.freedesktop.ModemManager1.Sim D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Sim.top_of_page">org.freedesktop.ModemManager1.Sim</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.ModemManager1.Sim ---- */

static const _ExtendedGDBusArgInfo _mm_gdbus_sim_method_info_send_pin_IN_ARG_pin =
{
  {
    -1,
    (gchar *) "pin",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_sim_method_info_send_pin_IN_ARG_pointers[] =
{
  &_mm_gdbus_sim_method_info_send_pin_IN_ARG_pin.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_sim_method_info_send_pin =
{
  {
    -1,
    (gchar *) "SendPin",
    (GDBusArgInfo **) &_mm_gdbus_sim_method_info_send_pin_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-send-pin",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_sim_method_info_send_puk_IN_ARG_puk =
{
  {
    -1,
    (gchar *) "puk",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_sim_method_info_send_puk_IN_ARG_pin =
{
  {
    -1,
    (gchar *) "pin",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_sim_method_info_send_puk_IN_ARG_pointers[] =
{
  &_mm_gdbus_sim_method_info_send_puk_IN_ARG_puk.parent_struct,
  &_mm_gdbus_sim_method_info_send_puk_IN_ARG_pin.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_sim_method_info_send_puk =
{
  {
    -1,
    (gchar *) "SendPuk",
    (GDBusArgInfo **) &_mm_gdbus_sim_method_info_send_puk_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-send-puk",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_sim_method_info_enable_pin_IN_ARG_pin =
{
  {
    -1,
    (gchar *) "pin",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_sim_method_info_enable_pin_IN_ARG_enabled =
{
  {
    -1,
    (gchar *) "enabled",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_sim_method_info_enable_pin_IN_ARG_pointers[] =
{
  &_mm_gdbus_sim_method_info_enable_pin_IN_ARG_pin.parent_struct,
  &_mm_gdbus_sim_method_info_enable_pin_IN_ARG_enabled.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_sim_method_info_enable_pin =
{
  {
    -1,
    (gchar *) "EnablePin",
    (GDBusArgInfo **) &_mm_gdbus_sim_method_info_enable_pin_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-enable-pin",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_sim_method_info_change_pin_IN_ARG_old_pin =
{
  {
    -1,
    (gchar *) "old_pin",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_sim_method_info_change_pin_IN_ARG_new_pin =
{
  {
    -1,
    (gchar *) "new_pin",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_sim_method_info_change_pin_IN_ARG_pointers[] =
{
  &_mm_gdbus_sim_method_info_change_pin_IN_ARG_old_pin.parent_struct,
  &_mm_gdbus_sim_method_info_change_pin_IN_ARG_new_pin.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_sim_method_info_change_pin =
{
  {
    -1,
    (gchar *) "ChangePin",
    (GDBusArgInfo **) &_mm_gdbus_sim_method_info_change_pin_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-change-pin",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_sim_method_info_set_preferred_networks_IN_ARG_preferred_networks =
{
  {
    -1,
    (gchar *) "preferred_networks",
    (gchar *) "a(su)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_sim_method_info_set_preferred_networks_IN_ARG_pointers[] =
{
  &_mm_gdbus_sim_method_info_set_preferred_networks_IN_ARG_preferred_networks.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_sim_method_info_set_preferred_networks =
{
  {
    -1,
    (gchar *) "SetPreferredNetworks",
    (GDBusArgInfo **) &_mm_gdbus_sim_method_info_set_preferred_networks_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-preferred-networks",
  FALSE
};

static const GDBusMethodInfo * const _mm_gdbus_sim_method_info_pointers[] =
{
  &_mm_gdbus_sim_method_info_send_pin.parent_struct,
  &_mm_gdbus_sim_method_info_send_puk.parent_struct,
  &_mm_gdbus_sim_method_info_enable_pin.parent_struct,
  &_mm_gdbus_sim_method_info_change_pin.parent_struct,
  &_mm_gdbus_sim_method_info_set_preferred_networks.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sim_property_info_active =
{
  {
    -1,
    (gchar *) "Active",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "active",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sim_property_info_sim_identifier =
{
  {
    -1,
    (gchar *) "SimIdentifier",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "sim-identifier",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sim_property_info_imsi =
{
  {
    -1,
    (gchar *) "Imsi",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "imsi",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sim_property_info_eid =
{
  {
    -1,
    (gchar *) "Eid",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "eid",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sim_property_info_operator_identifier =
{
  {
    -1,
    (gchar *) "OperatorIdentifier",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "operator-identifier",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sim_property_info_operator_name =
{
  {
    -1,
    (gchar *) "OperatorName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "operator-name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sim_property_info_emergency_numbers =
{
  {
    -1,
    (gchar *) "EmergencyNumbers",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "emergency-numbers",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sim_property_info_preferred_networks =
{
  {
    -1,
    (gchar *) "PreferredNetworks",
    (gchar *) "a(su)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "preferred-networks",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sim_property_info_gid1 =
{
  {
    -1,
    (gchar *) "Gid1",
    (gchar *) "ay",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "gid1",
  TRUE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sim_property_info_gid2 =
{
  {
    -1,
    (gchar *) "Gid2",
    (gchar *) "ay",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "gid2",
  TRUE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sim_property_info_sim_type =
{
  {
    -1,
    (gchar *) "SimType",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "sim-type",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sim_property_info_esim_status =
{
  {
    -1,
    (gchar *) "EsimStatus",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "esim-status",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_sim_property_info_removability =
{
  {
    -1,
    (gchar *) "Removability",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "removability",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _mm_gdbus_sim_property_info_pointers[] =
{
  &_mm_gdbus_sim_property_info_active.parent_struct,
  &_mm_gdbus_sim_property_info_sim_identifier.parent_struct,
  &_mm_gdbus_sim_property_info_imsi.parent_struct,
  &_mm_gdbus_sim_property_info_eid.parent_struct,
  &_mm_gdbus_sim_property_info_operator_identifier.parent_struct,
  &_mm_gdbus_sim_property_info_operator_name.parent_struct,
  &_mm_gdbus_sim_property_info_emergency_numbers.parent_struct,
  &_mm_gdbus_sim_property_info_preferred_networks.parent_struct,
  &_mm_gdbus_sim_property_info_gid1.parent_struct,
  &_mm_gdbus_sim_property_info_gid2.parent_struct,
  &_mm_gdbus_sim_property_info_sim_type.parent_struct,
  &_mm_gdbus_sim_property_info_esim_status.parent_struct,
  &_mm_gdbus_sim_property_info_removability.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mm_gdbus_sim_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.ModemManager1.Sim",
    (GDBusMethodInfo **) &_mm_gdbus_sim_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_mm_gdbus_sim_property_info_pointers,
    NULL
  },
  "sim",
};


/**
 * mm_gdbus_sim_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Sim.top_of_page">org.freedesktop.ModemManager1.Sim</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mm_gdbus_sim_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mm_gdbus_sim_interface_info.parent_struct;
}

/**
 * mm_gdbus_sim_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MmGdbusSim interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
mm_gdbus_sim_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "active");
  g_object_class_override_property (klass, property_id_begin++, "sim-identifier");
  g_object_class_override_property (klass, property_id_begin++, "imsi");
  g_object_class_override_property (klass, property_id_begin++, "eid");
  g_object_class_override_property (klass, property_id_begin++, "operator-identifier");
  g_object_class_override_property (klass, property_id_begin++, "operator-name");
  g_object_class_override_property (klass, property_id_begin++, "emergency-numbers");
  g_object_class_override_property (klass, property_id_begin++, "preferred-networks");
  g_object_class_override_property (klass, property_id_begin++, "gid1");
  g_object_class_override_property (klass, property_id_begin++, "gid2");
  g_object_class_override_property (klass, property_id_begin++, "sim-type");
  g_object_class_override_property (klass, property_id_begin++, "esim-status");
  g_object_class_override_property (klass, property_id_begin++, "removability");
  return property_id_begin - 1;
}


inline static void
mm_gdbus_sim_method_marshal_send_pin (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mm_gdbus_sim_method_marshal_send_puk (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mm_gdbus_sim_method_marshal_enable_pin (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mm_gdbus_sim_method_marshal_change_pin (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mm_gdbus_sim_method_marshal_set_preferred_networks (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * MmGdbusSim:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Sim.top_of_page">org.freedesktop.ModemManager1.Sim</link>.
 */

/**
 * MmGdbusSimIface:
 * @parent_iface: The parent interface.
 * @handle_change_pin: Handler for the #MmGdbusSim::handle-change-pin signal.
 * @handle_enable_pin: Handler for the #MmGdbusSim::handle-enable-pin signal.
 * @handle_send_pin: Handler for the #MmGdbusSim::handle-send-pin signal.
 * @handle_send_puk: Handler for the #MmGdbusSim::handle-send-puk signal.
 * @handle_set_preferred_networks: Handler for the #MmGdbusSim::handle-set-preferred-networks signal.
 * @get_active: Getter for the #MmGdbusSim:active property.
 * @get_eid: Getter for the #MmGdbusSim:eid property.
 * @get_emergency_numbers: Getter for the #MmGdbusSim:emergency-numbers property.
 * @get_esim_status: Getter for the #MmGdbusSim:esim-status property.
 * @get_gid1: Getter for the #MmGdbusSim:gid1 property.
 * @get_gid2: Getter for the #MmGdbusSim:gid2 property.
 * @get_imsi: Getter for the #MmGdbusSim:imsi property.
 * @get_operator_identifier: Getter for the #MmGdbusSim:operator-identifier property.
 * @get_operator_name: Getter for the #MmGdbusSim:operator-name property.
 * @get_preferred_networks: Getter for the #MmGdbusSim:preferred-networks property.
 * @get_removability: Getter for the #MmGdbusSim:removability property.
 * @get_sim_identifier: Getter for the #MmGdbusSim:sim-identifier property.
 * @get_sim_type: Getter for the #MmGdbusSim:sim-type property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Sim.top_of_page">org.freedesktop.ModemManager1.Sim</link>.
 */

typedef MmGdbusSimIface MmGdbusSimInterface;
G_DEFINE_INTERFACE (MmGdbusSim, mm_gdbus_sim, G_TYPE_OBJECT)

static void
mm_gdbus_sim_default_init (MmGdbusSimIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MmGdbusSim::handle-send-pin:
   * @object: A #MmGdbusSim.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pin: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sim.SendPin">SendPin()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_sim_complete_send_pin() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-send-pin",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusSimIface, handle_send_pin),
    g_signal_accumulator_true_handled,
    NULL,
      mm_gdbus_sim_method_marshal_send_pin,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MmGdbusSim::handle-send-puk:
   * @object: A #MmGdbusSim.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_puk: Argument passed by remote caller.
   * @arg_pin: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sim.SendPuk">SendPuk()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_sim_complete_send_puk() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-send-puk",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusSimIface, handle_send_puk),
    g_signal_accumulator_true_handled,
    NULL,
      mm_gdbus_sim_method_marshal_send_puk,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * MmGdbusSim::handle-enable-pin:
   * @object: A #MmGdbusSim.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pin: Argument passed by remote caller.
   * @arg_enabled: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sim.EnablePin">EnablePin()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_sim_complete_enable_pin() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-enable-pin",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusSimIface, handle_enable_pin),
    g_signal_accumulator_true_handled,
    NULL,
      mm_gdbus_sim_method_marshal_enable_pin,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN);

  /**
   * MmGdbusSim::handle-change-pin:
   * @object: A #MmGdbusSim.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_old_pin: Argument passed by remote caller.
   * @arg_new_pin: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sim.ChangePin">ChangePin()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_sim_complete_change_pin() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-change-pin",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusSimIface, handle_change_pin),
    g_signal_accumulator_true_handled,
    NULL,
      mm_gdbus_sim_method_marshal_change_pin,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * MmGdbusSim::handle-set-preferred-networks:
   * @object: A #MmGdbusSim.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_preferred_networks: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sim.SetPreferredNetworks">SetPreferredNetworks()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_sim_complete_set_preferred_networks() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-preferred-networks",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusSimIface, handle_set_preferred_networks),
    g_signal_accumulator_true_handled,
    NULL,
      mm_gdbus_sim_method_marshal_set_preferred_networks,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * MmGdbusSim:active:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.Active">"Active"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("active", "Active", "Active", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSim:sim-identifier:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.SimIdentifier">"SimIdentifier"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("sim-identifier", "SimIdentifier", "SimIdentifier", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSim:imsi:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.Imsi">"Imsi"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("imsi", "Imsi", "Imsi", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSim:eid:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.Eid">"Eid"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("eid", "Eid", "Eid", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSim:operator-identifier:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.OperatorIdentifier">"OperatorIdentifier"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("operator-identifier", "OperatorIdentifier", "OperatorIdentifier", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSim:operator-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.OperatorName">"OperatorName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("operator-name", "OperatorName", "OperatorName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSim:emergency-numbers:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.EmergencyNumbers">"EmergencyNumbers"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("emergency-numbers", "EmergencyNumbers", "EmergencyNumbers", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSim:preferred-networks:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.PreferredNetworks">"PreferredNetworks"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("preferred-networks", "PreferredNetworks", "PreferredNetworks", G_VARIANT_TYPE ("a(su)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSim:gid1:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.Gid1">"Gid1"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("gid1", "Gid1", "Gid1", G_VARIANT_TYPE ("ay"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSim:gid2:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.Gid2">"Gid2"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("gid2", "Gid2", "Gid2", G_VARIANT_TYPE ("ay"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSim:sim-type:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.SimType">"SimType"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("sim-type", "SimType", "SimType", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSim:esim-status:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.EsimStatus">"EsimStatus"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("esim-status", "EsimStatus", "EsimStatus", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * MmGdbusSim:removability:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.Removability">"Removability"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("removability", "Removability", "Removability", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * mm_gdbus_sim_get_active: (skip)
 * @object: A #MmGdbusSim.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.Active">"Active"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
mm_gdbus_sim_get_active (MmGdbusSim *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SIM (object), FALSE);

  return MM_GDBUS_SIM_GET_IFACE (object)->get_active (object);
}

/**
 * mm_gdbus_sim_set_active: (skip)
 * @object: A #MmGdbusSim.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.Active">"Active"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sim_set_active (MmGdbusSim *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "active", value, NULL);
}

/**
 * mm_gdbus_sim_get_sim_identifier: (skip)
 * @object: A #MmGdbusSim.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.SimIdentifier">"SimIdentifier"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_sim_dup_sim_identifier() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_sim_get_sim_identifier (MmGdbusSim *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SIM (object), NULL);

  return MM_GDBUS_SIM_GET_IFACE (object)->get_sim_identifier (object);
}

/**
 * mm_gdbus_sim_dup_sim_identifier: (skip)
 * @object: A #MmGdbusSim.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.SimIdentifier">"SimIdentifier"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_sim_dup_sim_identifier (MmGdbusSim *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "sim-identifier", &value, NULL);
  return value;
}

/**
 * mm_gdbus_sim_set_sim_identifier: (skip)
 * @object: A #MmGdbusSim.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.SimIdentifier">"SimIdentifier"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sim_set_sim_identifier (MmGdbusSim *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "sim-identifier", value, NULL);
}

/**
 * mm_gdbus_sim_get_imsi: (skip)
 * @object: A #MmGdbusSim.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.Imsi">"Imsi"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_sim_dup_imsi() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_sim_get_imsi (MmGdbusSim *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SIM (object), NULL);

  return MM_GDBUS_SIM_GET_IFACE (object)->get_imsi (object);
}

/**
 * mm_gdbus_sim_dup_imsi: (skip)
 * @object: A #MmGdbusSim.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.Imsi">"Imsi"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_sim_dup_imsi (MmGdbusSim *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "imsi", &value, NULL);
  return value;
}

/**
 * mm_gdbus_sim_set_imsi: (skip)
 * @object: A #MmGdbusSim.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.Imsi">"Imsi"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sim_set_imsi (MmGdbusSim *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "imsi", value, NULL);
}

/**
 * mm_gdbus_sim_get_eid: (skip)
 * @object: A #MmGdbusSim.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.Eid">"Eid"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_sim_dup_eid() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_sim_get_eid (MmGdbusSim *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SIM (object), NULL);

  return MM_GDBUS_SIM_GET_IFACE (object)->get_eid (object);
}

/**
 * mm_gdbus_sim_dup_eid: (skip)
 * @object: A #MmGdbusSim.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.Eid">"Eid"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_sim_dup_eid (MmGdbusSim *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "eid", &value, NULL);
  return value;
}

/**
 * mm_gdbus_sim_set_eid: (skip)
 * @object: A #MmGdbusSim.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.Eid">"Eid"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sim_set_eid (MmGdbusSim *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "eid", value, NULL);
}

/**
 * mm_gdbus_sim_get_operator_identifier: (skip)
 * @object: A #MmGdbusSim.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.OperatorIdentifier">"OperatorIdentifier"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_sim_dup_operator_identifier() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_sim_get_operator_identifier (MmGdbusSim *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SIM (object), NULL);

  return MM_GDBUS_SIM_GET_IFACE (object)->get_operator_identifier (object);
}

/**
 * mm_gdbus_sim_dup_operator_identifier: (skip)
 * @object: A #MmGdbusSim.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.OperatorIdentifier">"OperatorIdentifier"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_sim_dup_operator_identifier (MmGdbusSim *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "operator-identifier", &value, NULL);
  return value;
}

/**
 * mm_gdbus_sim_set_operator_identifier: (skip)
 * @object: A #MmGdbusSim.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.OperatorIdentifier">"OperatorIdentifier"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sim_set_operator_identifier (MmGdbusSim *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "operator-identifier", value, NULL);
}

/**
 * mm_gdbus_sim_get_operator_name: (skip)
 * @object: A #MmGdbusSim.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.OperatorName">"OperatorName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_sim_dup_operator_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_sim_get_operator_name (MmGdbusSim *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SIM (object), NULL);

  return MM_GDBUS_SIM_GET_IFACE (object)->get_operator_name (object);
}

/**
 * mm_gdbus_sim_dup_operator_name: (skip)
 * @object: A #MmGdbusSim.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.OperatorName">"OperatorName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_sim_dup_operator_name (MmGdbusSim *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "operator-name", &value, NULL);
  return value;
}

/**
 * mm_gdbus_sim_set_operator_name: (skip)
 * @object: A #MmGdbusSim.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.OperatorName">"OperatorName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sim_set_operator_name (MmGdbusSim *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "operator-name", value, NULL);
}

/**
 * mm_gdbus_sim_get_emergency_numbers: (skip)
 * @object: A #MmGdbusSim.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.EmergencyNumbers">"EmergencyNumbers"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_sim_dup_emergency_numbers() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
mm_gdbus_sim_get_emergency_numbers (MmGdbusSim *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SIM (object), NULL);

  return MM_GDBUS_SIM_GET_IFACE (object)->get_emergency_numbers (object);
}

/**
 * mm_gdbus_sim_dup_emergency_numbers: (skip)
 * @object: A #MmGdbusSim.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.EmergencyNumbers">"EmergencyNumbers"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
mm_gdbus_sim_dup_emergency_numbers (MmGdbusSim *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "emergency-numbers", &value, NULL);
  return value;
}

/**
 * mm_gdbus_sim_set_emergency_numbers: (skip)
 * @object: A #MmGdbusSim.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.EmergencyNumbers">"EmergencyNumbers"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sim_set_emergency_numbers (MmGdbusSim *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "emergency-numbers", value, NULL);
}

/**
 * mm_gdbus_sim_get_preferred_networks: (skip)
 * @object: A #MmGdbusSim.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.PreferredNetworks">"PreferredNetworks"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_sim_dup_preferred_networks() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mm_gdbus_sim_get_preferred_networks (MmGdbusSim *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SIM (object), NULL);

  return MM_GDBUS_SIM_GET_IFACE (object)->get_preferred_networks (object);
}

/**
 * mm_gdbus_sim_dup_preferred_networks: (skip)
 * @object: A #MmGdbusSim.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.PreferredNetworks">"PreferredNetworks"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mm_gdbus_sim_dup_preferred_networks (MmGdbusSim *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "preferred-networks", &value, NULL);
  return value;
}

/**
 * mm_gdbus_sim_set_preferred_networks: (skip)
 * @object: A #MmGdbusSim.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.PreferredNetworks">"PreferredNetworks"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sim_set_preferred_networks (MmGdbusSim *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "preferred-networks", value, NULL);
}

/**
 * mm_gdbus_sim_get_gid1: (skip)
 * @object: A #MmGdbusSim.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.Gid1">"Gid1"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_sim_dup_gid1() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mm_gdbus_sim_get_gid1 (MmGdbusSim *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SIM (object), NULL);

  return MM_GDBUS_SIM_GET_IFACE (object)->get_gid1 (object);
}

/**
 * mm_gdbus_sim_dup_gid1: (skip)
 * @object: A #MmGdbusSim.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.Gid1">"Gid1"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mm_gdbus_sim_dup_gid1 (MmGdbusSim *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "gid1", &value, NULL);
  return value;
}

/**
 * mm_gdbus_sim_set_gid1: (skip)
 * @object: A #MmGdbusSim.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.Gid1">"Gid1"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sim_set_gid1 (MmGdbusSim *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "gid1", value, NULL);
}

/**
 * mm_gdbus_sim_get_gid2: (skip)
 * @object: A #MmGdbusSim.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.Gid2">"Gid2"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_sim_dup_gid2() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mm_gdbus_sim_get_gid2 (MmGdbusSim *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SIM (object), NULL);

  return MM_GDBUS_SIM_GET_IFACE (object)->get_gid2 (object);
}

/**
 * mm_gdbus_sim_dup_gid2: (skip)
 * @object: A #MmGdbusSim.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.Gid2">"Gid2"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mm_gdbus_sim_dup_gid2 (MmGdbusSim *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "gid2", &value, NULL);
  return value;
}

/**
 * mm_gdbus_sim_set_gid2: (skip)
 * @object: A #MmGdbusSim.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.Gid2">"Gid2"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sim_set_gid2 (MmGdbusSim *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "gid2", value, NULL);
}

/**
 * mm_gdbus_sim_get_sim_type: (skip)
 * @object: A #MmGdbusSim.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.SimType">"SimType"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_sim_get_sim_type (MmGdbusSim *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SIM (object), 0);

  return MM_GDBUS_SIM_GET_IFACE (object)->get_sim_type (object);
}

/**
 * mm_gdbus_sim_set_sim_type: (skip)
 * @object: A #MmGdbusSim.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.SimType">"SimType"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sim_set_sim_type (MmGdbusSim *object, guint value)
{
  g_object_set (G_OBJECT (object), "sim-type", value, NULL);
}

/**
 * mm_gdbus_sim_get_esim_status: (skip)
 * @object: A #MmGdbusSim.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.EsimStatus">"EsimStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_sim_get_esim_status (MmGdbusSim *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SIM (object), 0);

  return MM_GDBUS_SIM_GET_IFACE (object)->get_esim_status (object);
}

/**
 * mm_gdbus_sim_set_esim_status: (skip)
 * @object: A #MmGdbusSim.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.EsimStatus">"EsimStatus"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sim_set_esim_status (MmGdbusSim *object, guint value)
{
  g_object_set (G_OBJECT (object), "esim-status", value, NULL);
}

/**
 * mm_gdbus_sim_get_removability: (skip)
 * @object: A #MmGdbusSim.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.Removability">"Removability"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
mm_gdbus_sim_get_removability (MmGdbusSim *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_SIM (object), 0);

  return MM_GDBUS_SIM_GET_IFACE (object)->get_removability (object);
}

/**
 * mm_gdbus_sim_set_removability: (skip)
 * @object: A #MmGdbusSim.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1-Sim.Removability">"Removability"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_sim_set_removability (MmGdbusSim *object, guint value)
{
  g_object_set (G_OBJECT (object), "removability", value, NULL);
}

/**
 * mm_gdbus_sim_call_send_pin:
 * @proxy: A #MmGdbusSimProxy.
 * @arg_pin: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sim.SendPin">SendPin()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_sim_call_send_pin_finish() to get the result of the operation.
 *
 * See mm_gdbus_sim_call_send_pin_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_sim_call_send_pin (
    MmGdbusSim *proxy,
    const gchar *arg_pin,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SendPin",
    g_variant_new ("(s)",
                   arg_pin),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_sim_call_send_pin_finish:
 * @proxy: A #MmGdbusSimProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_sim_call_send_pin().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_sim_call_send_pin().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_sim_call_send_pin_finish (
    MmGdbusSim *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_sim_call_send_pin_sync:
 * @proxy: A #MmGdbusSimProxy.
 * @arg_pin: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sim.SendPin">SendPin()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_sim_call_send_pin() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_sim_call_send_pin_sync (
    MmGdbusSim *proxy,
    const gchar *arg_pin,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SendPin",
    g_variant_new ("(s)",
                   arg_pin),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_sim_call_send_puk:
 * @proxy: A #MmGdbusSimProxy.
 * @arg_puk: Argument to pass with the method invocation.
 * @arg_pin: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sim.SendPuk">SendPuk()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_sim_call_send_puk_finish() to get the result of the operation.
 *
 * See mm_gdbus_sim_call_send_puk_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_sim_call_send_puk (
    MmGdbusSim *proxy,
    const gchar *arg_puk,
    const gchar *arg_pin,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SendPuk",
    g_variant_new ("(ss)",
                   arg_puk,
                   arg_pin),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_sim_call_send_puk_finish:
 * @proxy: A #MmGdbusSimProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_sim_call_send_puk().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_sim_call_send_puk().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_sim_call_send_puk_finish (
    MmGdbusSim *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_sim_call_send_puk_sync:
 * @proxy: A #MmGdbusSimProxy.
 * @arg_puk: Argument to pass with the method invocation.
 * @arg_pin: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sim.SendPuk">SendPuk()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_sim_call_send_puk() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_sim_call_send_puk_sync (
    MmGdbusSim *proxy,
    const gchar *arg_puk,
    const gchar *arg_pin,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SendPuk",
    g_variant_new ("(ss)",
                   arg_puk,
                   arg_pin),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_sim_call_enable_pin:
 * @proxy: A #MmGdbusSimProxy.
 * @arg_pin: Argument to pass with the method invocation.
 * @arg_enabled: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sim.EnablePin">EnablePin()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_sim_call_enable_pin_finish() to get the result of the operation.
 *
 * See mm_gdbus_sim_call_enable_pin_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_sim_call_enable_pin (
    MmGdbusSim *proxy,
    const gchar *arg_pin,
    gboolean arg_enabled,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EnablePin",
    g_variant_new ("(sb)",
                   arg_pin,
                   arg_enabled),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_sim_call_enable_pin_finish:
 * @proxy: A #MmGdbusSimProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_sim_call_enable_pin().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_sim_call_enable_pin().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_sim_call_enable_pin_finish (
    MmGdbusSim *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_sim_call_enable_pin_sync:
 * @proxy: A #MmGdbusSimProxy.
 * @arg_pin: Argument to pass with the method invocation.
 * @arg_enabled: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sim.EnablePin">EnablePin()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_sim_call_enable_pin() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_sim_call_enable_pin_sync (
    MmGdbusSim *proxy,
    const gchar *arg_pin,
    gboolean arg_enabled,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EnablePin",
    g_variant_new ("(sb)",
                   arg_pin,
                   arg_enabled),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_sim_call_change_pin:
 * @proxy: A #MmGdbusSimProxy.
 * @arg_old_pin: Argument to pass with the method invocation.
 * @arg_new_pin: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sim.ChangePin">ChangePin()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_sim_call_change_pin_finish() to get the result of the operation.
 *
 * See mm_gdbus_sim_call_change_pin_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_sim_call_change_pin (
    MmGdbusSim *proxy,
    const gchar *arg_old_pin,
    const gchar *arg_new_pin,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ChangePin",
    g_variant_new ("(ss)",
                   arg_old_pin,
                   arg_new_pin),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_sim_call_change_pin_finish:
 * @proxy: A #MmGdbusSimProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_sim_call_change_pin().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_sim_call_change_pin().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_sim_call_change_pin_finish (
    MmGdbusSim *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_sim_call_change_pin_sync:
 * @proxy: A #MmGdbusSimProxy.
 * @arg_old_pin: Argument to pass with the method invocation.
 * @arg_new_pin: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sim.ChangePin">ChangePin()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_sim_call_change_pin() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_sim_call_change_pin_sync (
    MmGdbusSim *proxy,
    const gchar *arg_old_pin,
    const gchar *arg_new_pin,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ChangePin",
    g_variant_new ("(ss)",
                   arg_old_pin,
                   arg_new_pin),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_sim_call_set_preferred_networks:
 * @proxy: A #MmGdbusSimProxy.
 * @arg_preferred_networks: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sim.SetPreferredNetworks">SetPreferredNetworks()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_sim_call_set_preferred_networks_finish() to get the result of the operation.
 *
 * See mm_gdbus_sim_call_set_preferred_networks_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_sim_call_set_preferred_networks (
    MmGdbusSim *proxy,
    GVariant *arg_preferred_networks,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetPreferredNetworks",
    g_variant_new ("(@a(su))",
                   arg_preferred_networks),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_sim_call_set_preferred_networks_finish:
 * @proxy: A #MmGdbusSimProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_sim_call_set_preferred_networks().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_sim_call_set_preferred_networks().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_sim_call_set_preferred_networks_finish (
    MmGdbusSim *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_sim_call_set_preferred_networks_sync:
 * @proxy: A #MmGdbusSimProxy.
 * @arg_preferred_networks: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sim.SetPreferredNetworks">SetPreferredNetworks()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_sim_call_set_preferred_networks() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_sim_call_set_preferred_networks_sync (
    MmGdbusSim *proxy,
    GVariant *arg_preferred_networks,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetPreferredNetworks",
    g_variant_new ("(@a(su))",
                   arg_preferred_networks),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_sim_complete_send_pin:
 * @object: A #MmGdbusSim.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sim.SendPin">SendPin()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_sim_complete_send_pin (
    MmGdbusSim *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_sim_complete_send_puk:
 * @object: A #MmGdbusSim.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sim.SendPuk">SendPuk()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_sim_complete_send_puk (
    MmGdbusSim *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_sim_complete_enable_pin:
 * @object: A #MmGdbusSim.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sim.EnablePin">EnablePin()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_sim_complete_enable_pin (
    MmGdbusSim *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_sim_complete_change_pin:
 * @object: A #MmGdbusSim.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sim.ChangePin">ChangePin()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_sim_complete_change_pin (
    MmGdbusSim *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_sim_complete_set_preferred_networks:
 * @object: A #MmGdbusSim.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1-Sim.SetPreferredNetworks">SetPreferredNetworks()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_sim_complete_set_preferred_networks (
    MmGdbusSim *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MmGdbusSimProxy:
 *
 * The #MmGdbusSimProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusSimProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusSimProxy.
 */

struct _MmGdbusSimProxyPrivate
{
  GData *qdata;
};

static void mm_gdbus_sim_proxy_iface_init (MmGdbusSimIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusSimProxy, mm_gdbus_sim_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MmGdbusSimProxy)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_SIM, mm_gdbus_sim_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusSimProxy, mm_gdbus_sim_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_SIM, mm_gdbus_sim_proxy_iface_init))

#endif
static void
mm_gdbus_sim_proxy_finalize (GObject *object)
{
  MmGdbusSimProxy *proxy = MM_GDBUS_SIM_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (mm_gdbus_sim_proxy_parent_class)->finalize (object);
}

static void
mm_gdbus_sim_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 13);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_sim_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
mm_gdbus_sim_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.ModemManager1.Sim: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
mm_gdbus_sim_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 13);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_sim_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.ModemManager1.Sim", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) mm_gdbus_sim_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
mm_gdbus_sim_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_mm_gdbus_sim_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MM_GDBUS_TYPE_SIM);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_SIM);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
mm_gdbus_sim_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MmGdbusSimProxy *proxy = MM_GDBUS_SIM_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_sim_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_sim_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
mm_gdbus_sim_proxy_get_active (MmGdbusSim *object)
{
  MmGdbusSimProxy *proxy = MM_GDBUS_SIM_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Active");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
mm_gdbus_sim_proxy_get_sim_identifier (MmGdbusSim *object)
{
  MmGdbusSimProxy *proxy = MM_GDBUS_SIM_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SimIdentifier");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
mm_gdbus_sim_proxy_get_imsi (MmGdbusSim *object)
{
  MmGdbusSimProxy *proxy = MM_GDBUS_SIM_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Imsi");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
mm_gdbus_sim_proxy_get_eid (MmGdbusSim *object)
{
  MmGdbusSimProxy *proxy = MM_GDBUS_SIM_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Eid");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
mm_gdbus_sim_proxy_get_operator_identifier (MmGdbusSim *object)
{
  MmGdbusSimProxy *proxy = MM_GDBUS_SIM_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OperatorIdentifier");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
mm_gdbus_sim_proxy_get_operator_name (MmGdbusSim *object)
{
  MmGdbusSimProxy *proxy = MM_GDBUS_SIM_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OperatorName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
mm_gdbus_sim_proxy_get_emergency_numbers (MmGdbusSim *object)
{
  MmGdbusSimProxy *proxy = MM_GDBUS_SIM_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "EmergencyNumbers");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "EmergencyNumbers");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "EmergencyNumbers", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
mm_gdbus_sim_proxy_get_preferred_networks (MmGdbusSim *object)
{
  MmGdbusSimProxy *proxy = MM_GDBUS_SIM_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PreferredNetworks");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
mm_gdbus_sim_proxy_get_gid1 (MmGdbusSim *object)
{
  MmGdbusSimProxy *proxy = MM_GDBUS_SIM_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Gid1");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
mm_gdbus_sim_proxy_get_gid2 (MmGdbusSim *object)
{
  MmGdbusSimProxy *proxy = MM_GDBUS_SIM_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Gid2");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static guint 
mm_gdbus_sim_proxy_get_sim_type (MmGdbusSim *object)
{
  MmGdbusSimProxy *proxy = MM_GDBUS_SIM_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SimType");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
mm_gdbus_sim_proxy_get_esim_status (MmGdbusSim *object)
{
  MmGdbusSimProxy *proxy = MM_GDBUS_SIM_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "EsimStatus");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
mm_gdbus_sim_proxy_get_removability (MmGdbusSim *object)
{
  MmGdbusSimProxy *proxy = MM_GDBUS_SIM_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Removability");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
mm_gdbus_sim_proxy_init (MmGdbusSimProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = mm_gdbus_sim_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MM_GDBUS_TYPE_SIM_PROXY, MmGdbusSimProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), mm_gdbus_sim_interface_info ());
}

static void
mm_gdbus_sim_proxy_class_init (MmGdbusSimProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = mm_gdbus_sim_proxy_finalize;
  gobject_class->get_property = mm_gdbus_sim_proxy_get_property;
  gobject_class->set_property = mm_gdbus_sim_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = mm_gdbus_sim_proxy_g_signal;
  proxy_class->g_properties_changed = mm_gdbus_sim_proxy_g_properties_changed;

  mm_gdbus_sim_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusSimProxyPrivate));
#endif
}

static void
mm_gdbus_sim_proxy_iface_init (MmGdbusSimIface *iface)
{
  iface->get_active = mm_gdbus_sim_proxy_get_active;
  iface->get_sim_identifier = mm_gdbus_sim_proxy_get_sim_identifier;
  iface->get_imsi = mm_gdbus_sim_proxy_get_imsi;
  iface->get_eid = mm_gdbus_sim_proxy_get_eid;
  iface->get_operator_identifier = mm_gdbus_sim_proxy_get_operator_identifier;
  iface->get_operator_name = mm_gdbus_sim_proxy_get_operator_name;
  iface->get_emergency_numbers = mm_gdbus_sim_proxy_get_emergency_numbers;
  iface->get_preferred_networks = mm_gdbus_sim_proxy_get_preferred_networks;
  iface->get_gid1 = mm_gdbus_sim_proxy_get_gid1;
  iface->get_gid2 = mm_gdbus_sim_proxy_get_gid2;
  iface->get_sim_type = mm_gdbus_sim_proxy_get_sim_type;
  iface->get_esim_status = mm_gdbus_sim_proxy_get_esim_status;
  iface->get_removability = mm_gdbus_sim_proxy_get_removability;
}

/**
 * mm_gdbus_sim_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Sim.top_of_page">org.freedesktop.ModemManager1.Sim</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_sim_proxy_new_finish() to get the result of the operation.
 *
 * See mm_gdbus_sim_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_sim_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_SIM_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Sim", NULL);
}

/**
 * mm_gdbus_sim_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_sim_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_sim_proxy_new().
 *
 * Returns: (transfer full) (type MmGdbusSimProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusSim *
mm_gdbus_sim_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_SIM (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_sim_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Sim.top_of_page">org.freedesktop.ModemManager1.Sim</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_sim_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusSimProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusSim *
mm_gdbus_sim_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_SIM_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Sim", NULL);
  if (ret != NULL)
    return MM_GDBUS_SIM (ret);
  else
    return NULL;
}


/**
 * mm_gdbus_sim_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like mm_gdbus_sim_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_sim_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See mm_gdbus_sim_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_sim_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_SIM_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Sim", NULL);
}

/**
 * mm_gdbus_sim_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_sim_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_sim_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MmGdbusSimProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusSim *
mm_gdbus_sim_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_SIM (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_sim_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like mm_gdbus_sim_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_sim_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusSimProxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusSim *
mm_gdbus_sim_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_SIM_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1.Sim", NULL);
  if (ret != NULL)
    return MM_GDBUS_SIM (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MmGdbusSimSkeleton:
 *
 * The #MmGdbusSimSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusSimSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusSimSkeleton.
 */

struct _MmGdbusSimSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_mm_gdbus_sim_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MM_GDBUS_TYPE_SIM);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_SIM);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_mm_gdbus_sim_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_sim_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_mm_gdbus_sim_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_sim_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _mm_gdbus_sim_skeleton_vtable =
{
  _mm_gdbus_sim_skeleton_handle_method_call,
  _mm_gdbus_sim_skeleton_handle_get_property,
  _mm_gdbus_sim_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
mm_gdbus_sim_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return mm_gdbus_sim_interface_info ();
}

static GDBusInterfaceVTable *
mm_gdbus_sim_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_mm_gdbus_sim_skeleton_vtable;
}

static GVariant *
mm_gdbus_sim_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_mm_gdbus_sim_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _mm_gdbus_sim_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _mm_gdbus_sim_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _mm_gdbus_sim_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1.Sim", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _mm_gdbus_sim_emit_changed (gpointer user_data);

static void
mm_gdbus_sim_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _mm_gdbus_sim_emit_changed (skeleton);
}

static void mm_gdbus_sim_skeleton_iface_init (MmGdbusSimIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusSimSkeleton, mm_gdbus_sim_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MmGdbusSimSkeleton)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_SIM, mm_gdbus_sim_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusSimSkeleton, mm_gdbus_sim_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_SIM, mm_gdbus_sim_skeleton_iface_init))

#endif
static void
mm_gdbus_sim_skeleton_finalize (GObject *object)
{
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (object);
  guint n;
  for (n = 0; n < 13; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (mm_gdbus_sim_skeleton_parent_class)->finalize (object);
}

static void
mm_gdbus_sim_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 13);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_mm_gdbus_sim_emit_changed (gpointer user_data)
{
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.ModemManager1.Sim",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_mm_gdbus_sim_schedule_emit_changed (MmGdbusSimSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
mm_gdbus_sim_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _mm_gdbus_sim_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _mm_gdbus_sim_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
mm_gdbus_sim_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 13);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_sim_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _mm_gdbus_sim_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
mm_gdbus_sim_skeleton_init (MmGdbusSimSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = mm_gdbus_sim_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MM_GDBUS_TYPE_SIM_SKELETON, MmGdbusSimSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 13);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[10], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[11], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[12], G_TYPE_UINT);
}

static gboolean 
mm_gdbus_sim_skeleton_get_active (MmGdbusSim *object)
{
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
mm_gdbus_sim_skeleton_get_sim_identifier (MmGdbusSim *object)
{
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
mm_gdbus_sim_skeleton_get_imsi (MmGdbusSim *object)
{
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
mm_gdbus_sim_skeleton_get_eid (MmGdbusSim *object)
{
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
mm_gdbus_sim_skeleton_get_operator_identifier (MmGdbusSim *object)
{
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
mm_gdbus_sim_skeleton_get_operator_name (MmGdbusSim *object)
{
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
mm_gdbus_sim_skeleton_get_emergency_numbers (MmGdbusSim *object)
{
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
mm_gdbus_sim_skeleton_get_preferred_networks (MmGdbusSim *object)
{
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
mm_gdbus_sim_skeleton_get_gid1 (MmGdbusSim *object)
{
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
mm_gdbus_sim_skeleton_get_gid2 (MmGdbusSim *object)
{
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_sim_skeleton_get_sim_type (MmGdbusSim *object)
{
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[10]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_sim_skeleton_get_esim_status (MmGdbusSim *object)
{
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[11]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
mm_gdbus_sim_skeleton_get_removability (MmGdbusSim *object)
{
  MmGdbusSimSkeleton *skeleton = MM_GDBUS_SIM_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[12]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
mm_gdbus_sim_skeleton_class_init (MmGdbusSimSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = mm_gdbus_sim_skeleton_finalize;
  gobject_class->get_property = mm_gdbus_sim_skeleton_get_property;
  gobject_class->set_property = mm_gdbus_sim_skeleton_set_property;
  gobject_class->notify       = mm_gdbus_sim_skeleton_notify;


  mm_gdbus_sim_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = mm_gdbus_sim_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = mm_gdbus_sim_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = mm_gdbus_sim_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = mm_gdbus_sim_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusSimSkeletonPrivate));
#endif
}

static void
mm_gdbus_sim_skeleton_iface_init (MmGdbusSimIface *iface)
{
  iface->get_active = mm_gdbus_sim_skeleton_get_active;
  iface->get_sim_identifier = mm_gdbus_sim_skeleton_get_sim_identifier;
  iface->get_imsi = mm_gdbus_sim_skeleton_get_imsi;
  iface->get_eid = mm_gdbus_sim_skeleton_get_eid;
  iface->get_operator_identifier = mm_gdbus_sim_skeleton_get_operator_identifier;
  iface->get_operator_name = mm_gdbus_sim_skeleton_get_operator_name;
  iface->get_emergency_numbers = mm_gdbus_sim_skeleton_get_emergency_numbers;
  iface->get_preferred_networks = mm_gdbus_sim_skeleton_get_preferred_networks;
  iface->get_gid1 = mm_gdbus_sim_skeleton_get_gid1;
  iface->get_gid2 = mm_gdbus_sim_skeleton_get_gid2;
  iface->get_sim_type = mm_gdbus_sim_skeleton_get_sim_type;
  iface->get_esim_status = mm_gdbus_sim_skeleton_get_esim_status;
  iface->get_removability = mm_gdbus_sim_skeleton_get_removability;
}

/**
 * mm_gdbus_sim_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1-Sim.top_of_page">org.freedesktop.ModemManager1.Sim</link>.
 *
 * Returns: (transfer full) (type MmGdbusSimSkeleton): The skeleton object.
 */
MmGdbusSim *
mm_gdbus_sim_skeleton_new (void)
{
  return MM_GDBUS_SIM (g_object_new (MM_GDBUS_TYPE_SIM_SKELETON, NULL));
}

