/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "meta-dbus-login1.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_VOID__UINT_UINT_STRING (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_UintUintStringFunc)
       (void *data1,
        guint arg_major,
        guint arg_minor,
        const gchar *arg_type,
        void *data2);
  _GDbusCodegenMarshalVoid_UintUintStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_UintUintStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_uint (param_values + 1),
            g_marshal_value_peek_uint (param_values + 2),
            g_marshal_value_peek_string (param_values + 3),
            data2);
}

static void
_g_dbus_codegen_marshal_VOID__UINT_UINT_VARIANT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_UintUintVariantFunc)
       (void *data1,
        guint arg_major,
        guint arg_minor,
        GVariant *arg_fd,
        void *data2);
  _GDbusCodegenMarshalVoid_UintUintVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_UintUintVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_uint (param_values + 1),
            g_marshal_value_peek_uint (param_values + 2),
            g_marshal_value_peek_variant (param_values + 3),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBooleanFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gboolean arg_force,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBooleanFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBooleanFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boolean (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_UINT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectObjectUintUintFunc)
       (void *data1,
        GUnixFDList *arg_fd_list,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_major,
        guint arg_minor,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectObjectUintUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectObjectUintUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_object (param_values + 2),
              g_marshal_value_peek_uint (param_values + 3),
              g_marshal_value_peek_uint (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_major,
        guint arg_minor,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              g_marshal_value_peek_uint (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_vt,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.login1.Session
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:Login1Session
 * @title: Login1Session
 * @short_description: Generated C code for the org.freedesktop.login1.Session D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-login1-Session.top_of_page">org.freedesktop.login1.Session</link> D-Bus interface in C.
 */

enum
{
  LOGIN1__SESSION_PAUSE_DEVICE,
  LOGIN1__SESSION_RESUME_DEVICE,
};

static unsigned LOGIN1__SESSION_SIGNALS[2] = { 0 };

/* ---- Introspection data for org.freedesktop.login1.Session ---- */

static const _ExtendedGDBusMethodInfo _login1_session_method_info_activate =
{
  {
    -1,
    (gchar *) "Activate",
    NULL,
    NULL,
    NULL
  },
  "handle-activate",
  FALSE
};

static const _ExtendedGDBusArgInfo _login1_session_method_info_take_control_IN_ARG_force =
{
  {
    -1,
    (gchar *) "force",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _login1_session_method_info_take_control_IN_ARG_pointers[] =
{
  &_login1_session_method_info_take_control_IN_ARG_force.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _login1_session_method_info_take_control =
{
  {
    -1,
    (gchar *) "TakeControl",
    (GDBusArgInfo **) &_login1_session_method_info_take_control_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-take-control",
  FALSE
};

static const _ExtendedGDBusMethodInfo _login1_session_method_info_release_control =
{
  {
    -1,
    (gchar *) "ReleaseControl",
    NULL,
    NULL,
    NULL
  },
  "handle-release-control",
  FALSE
};

static const _ExtendedGDBusArgInfo _login1_session_method_info_take_device_IN_ARG_major =
{
  {
    -1,
    (gchar *) "major",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _login1_session_method_info_take_device_IN_ARG_minor =
{
  {
    -1,
    (gchar *) "minor",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _login1_session_method_info_take_device_IN_ARG_pointers[] =
{
  &_login1_session_method_info_take_device_IN_ARG_major.parent_struct,
  &_login1_session_method_info_take_device_IN_ARG_minor.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _login1_session_method_info_take_device_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _login1_session_method_info_take_device_OUT_ARG_paused =
{
  {
    -1,
    (gchar *) "paused",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _login1_session_method_info_take_device_OUT_ARG_pointers[] =
{
  &_login1_session_method_info_take_device_OUT_ARG_fd.parent_struct,
  &_login1_session_method_info_take_device_OUT_ARG_paused.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _login1_session_method_info_take_device =
{
  {
    -1,
    (gchar *) "TakeDevice",
    (GDBusArgInfo **) &_login1_session_method_info_take_device_IN_ARG_pointers,
    (GDBusArgInfo **) &_login1_session_method_info_take_device_OUT_ARG_pointers,
    NULL
  },
  "handle-take-device",
  TRUE
};

static const _ExtendedGDBusArgInfo _login1_session_method_info_release_device_IN_ARG_major =
{
  {
    -1,
    (gchar *) "major",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _login1_session_method_info_release_device_IN_ARG_minor =
{
  {
    -1,
    (gchar *) "minor",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _login1_session_method_info_release_device_IN_ARG_pointers[] =
{
  &_login1_session_method_info_release_device_IN_ARG_major.parent_struct,
  &_login1_session_method_info_release_device_IN_ARG_minor.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _login1_session_method_info_release_device =
{
  {
    -1,
    (gchar *) "ReleaseDevice",
    (GDBusArgInfo **) &_login1_session_method_info_release_device_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-release-device",
  FALSE
};

static const _ExtendedGDBusArgInfo _login1_session_method_info_pause_device_complete_IN_ARG_major =
{
  {
    -1,
    (gchar *) "major",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _login1_session_method_info_pause_device_complete_IN_ARG_minor =
{
  {
    -1,
    (gchar *) "minor",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _login1_session_method_info_pause_device_complete_IN_ARG_pointers[] =
{
  &_login1_session_method_info_pause_device_complete_IN_ARG_major.parent_struct,
  &_login1_session_method_info_pause_device_complete_IN_ARG_minor.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _login1_session_method_info_pause_device_complete =
{
  {
    -1,
    (gchar *) "PauseDeviceComplete",
    (GDBusArgInfo **) &_login1_session_method_info_pause_device_complete_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-pause-device-complete",
  FALSE
};

static const GDBusMethodInfo * const _login1_session_method_info_pointers[] =
{
  &_login1_session_method_info_activate.parent_struct,
  &_login1_session_method_info_take_control.parent_struct,
  &_login1_session_method_info_release_control.parent_struct,
  &_login1_session_method_info_take_device.parent_struct,
  &_login1_session_method_info_release_device.parent_struct,
  &_login1_session_method_info_pause_device_complete.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _login1_session_signal_info_pause_device_ARG_major =
{
  {
    -1,
    (gchar *) "major",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _login1_session_signal_info_pause_device_ARG_minor =
{
  {
    -1,
    (gchar *) "minor",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _login1_session_signal_info_pause_device_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _login1_session_signal_info_pause_device_ARG_pointers[] =
{
  &_login1_session_signal_info_pause_device_ARG_major.parent_struct,
  &_login1_session_signal_info_pause_device_ARG_minor.parent_struct,
  &_login1_session_signal_info_pause_device_ARG_type.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _login1_session_signal_info_pause_device =
{
  {
    -1,
    (gchar *) "PauseDevice",
    (GDBusArgInfo **) &_login1_session_signal_info_pause_device_ARG_pointers,
    NULL
  },
  "pause-device"
};

static const _ExtendedGDBusArgInfo _login1_session_signal_info_resume_device_ARG_major =
{
  {
    -1,
    (gchar *) "major",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _login1_session_signal_info_resume_device_ARG_minor =
{
  {
    -1,
    (gchar *) "minor",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _login1_session_signal_info_resume_device_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _login1_session_signal_info_resume_device_ARG_pointers[] =
{
  &_login1_session_signal_info_resume_device_ARG_major.parent_struct,
  &_login1_session_signal_info_resume_device_ARG_minor.parent_struct,
  &_login1_session_signal_info_resume_device_ARG_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _login1_session_signal_info_resume_device =
{
  {
    -1,
    (gchar *) "ResumeDevice",
    (GDBusArgInfo **) &_login1_session_signal_info_resume_device_ARG_pointers,
    NULL
  },
  "resume-device"
};

static const GDBusSignalInfo * const _login1_session_signal_info_pointers[] =
{
  &_login1_session_signal_info_pause_device.parent_struct,
  &_login1_session_signal_info_resume_device.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _login1_session_property_info_active =
{
  {
    -1,
    (gchar *) "Active",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "active",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _login1_session_property_info_pointers[] =
{
  &_login1_session_property_info_active.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _login1_session_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.login1.Session",
    (GDBusMethodInfo **) &_login1_session_method_info_pointers,
    (GDBusSignalInfo **) &_login1_session_signal_info_pointers,
    (GDBusPropertyInfo **) &_login1_session_property_info_pointers,
    NULL
  },
  "session",
};


/**
 * login1_session_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-login1-Session.top_of_page">org.freedesktop.login1.Session</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
login1_session_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_login1_session_interface_info.parent_struct;
}

/**
 * login1_session_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #Login1Session interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
login1_session_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "active");
  return property_id_begin - 1;
}


inline static void
login1_session_signal_marshal_pause_device (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__UINT_UINT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
login1_session_signal_marshal_resume_device (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__UINT_UINT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
login1_session_method_marshal_activate (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
login1_session_method_marshal_take_control (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
login1_session_method_marshal_release_control (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
login1_session_method_marshal_take_device (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_OBJECT_UINT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
login1_session_method_marshal_release_device (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
login1_session_method_marshal_pause_device_complete (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * Login1Session:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Session.top_of_page">org.freedesktop.login1.Session</link>.
 */

/**
 * Login1SessionIface:
 * @parent_iface: The parent interface.
 * @handle_activate: Handler for the #Login1Session::handle-activate signal.
 * @handle_pause_device_complete: Handler for the #Login1Session::handle-pause-device-complete signal.
 * @handle_release_control: Handler for the #Login1Session::handle-release-control signal.
 * @handle_release_device: Handler for the #Login1Session::handle-release-device signal.
 * @handle_take_control: Handler for the #Login1Session::handle-take-control signal.
 * @handle_take_device: Handler for the #Login1Session::handle-take-device signal.
 * @get_active: Getter for the #Login1Session:active property.
 * @pause_device: Handler for the #Login1Session::pause-device signal.
 * @resume_device: Handler for the #Login1Session::resume-device signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Session.top_of_page">org.freedesktop.login1.Session</link>.
 */

typedef Login1SessionIface Login1SessionInterface;
G_DEFINE_INTERFACE (Login1Session, login1_session, G_TYPE_OBJECT)

static void
login1_session_default_init (Login1SessionIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * Login1Session::handle-activate:
   * @object: A #Login1Session.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.Activate">Activate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call login1_session_complete_activate() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-activate",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Login1SessionIface, handle_activate),
    g_signal_accumulator_true_handled,
    NULL,
      login1_session_method_marshal_activate,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Login1Session::handle-take-control:
   * @object: A #Login1Session.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_force: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeControl">TakeControl()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call login1_session_complete_take_control() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-take-control",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Login1SessionIface, handle_take_control),
    g_signal_accumulator_true_handled,
    NULL,
      login1_session_method_marshal_take_control,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * Login1Session::handle-release-control:
   * @object: A #Login1Session.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseControl">ReleaseControl()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call login1_session_complete_release_control() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release-control",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Login1SessionIface, handle_release_control),
    g_signal_accumulator_true_handled,
    NULL,
      login1_session_method_marshal_release_control,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * Login1Session::handle-take-device:
   * @object: A #Login1Session.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_major: Argument passed by remote caller.
   * @arg_minor: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeDevice">TakeDevice()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call login1_session_complete_take_device() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-take-device",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Login1SessionIface, handle_take_device),
    g_signal_accumulator_true_handled,
    NULL,
      login1_session_method_marshal_take_device,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_UINT, G_TYPE_UINT);

  /**
   * Login1Session::handle-release-device:
   * @object: A #Login1Session.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_major: Argument passed by remote caller.
   * @arg_minor: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseDevice">ReleaseDevice()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call login1_session_complete_release_device() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release-device",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Login1SessionIface, handle_release_device),
    g_signal_accumulator_true_handled,
    NULL,
      login1_session_method_marshal_release_device,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_UINT);

  /**
   * Login1Session::handle-pause-device-complete:
   * @object: A #Login1Session.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_major: Argument passed by remote caller.
   * @arg_minor: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Session.PauseDeviceComplete">PauseDeviceComplete()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call login1_session_complete_pause_device_complete() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-pause-device-complete",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Login1SessionIface, handle_pause_device_complete),
    g_signal_accumulator_true_handled,
    NULL,
      login1_session_method_marshal_pause_device_complete,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_UINT);

  /* GObject signals for received D-Bus signals: */
  /**
   * Login1Session::pause-device:
   * @object: A #Login1Session.
   * @arg_major: Argument.
   * @arg_minor: Argument.
   * @arg_type: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-login1-Session.PauseDevice">"PauseDevice"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  LOGIN1__SESSION_SIGNALS[LOGIN1__SESSION_PAUSE_DEVICE] =
    g_signal_new ("pause-device",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (Login1SessionIface, pause_device),
      NULL,
      NULL,
      login1_session_signal_marshal_pause_device,
      G_TYPE_NONE,
      3, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING);

  /**
   * Login1Session::resume-device:
   * @object: A #Login1Session.
   * @arg_major: Argument.
   * @arg_minor: Argument.
   * @arg_fd: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-login1-Session.ResumeDevice">"ResumeDevice"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  LOGIN1__SESSION_SIGNALS[LOGIN1__SESSION_RESUME_DEVICE] =
    g_signal_new ("resume-device",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (Login1SessionIface, resume_device),
      NULL,
      NULL,
      login1_session_signal_marshal_resume_device,
      G_TYPE_NONE,
      3, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * Login1Session:active:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-login1-Session.Active">"Active"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("active", "Active", "Active", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * login1_session_get_active: (skip)
 * @object: A #Login1Session.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-login1-Session.Active">"Active"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
login1_session_get_active (Login1Session *object)
{
  g_return_val_if_fail (LOGIN1_IS_SESSION (object), FALSE);

  return LOGIN1_SESSION_GET_IFACE (object)->get_active (object);
}

/**
 * login1_session_set_active: (skip)
 * @object: A #Login1Session.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-login1-Session.Active">"Active"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
login1_session_set_active (Login1Session *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "active", value, NULL);
}

/**
 * login1_session_emit_pause_device:
 * @object: A #Login1Session.
 * @arg_major: Argument to pass with the signal.
 * @arg_minor: Argument to pass with the signal.
 * @arg_type: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-login1-Session.PauseDevice">"PauseDevice"</link> D-Bus signal.
 */
void
login1_session_emit_pause_device (
    Login1Session *object,
    guint arg_major,
    guint arg_minor,
    const gchar *arg_type)
{
  g_signal_emit (object, LOGIN1__SESSION_SIGNALS[LOGIN1__SESSION_PAUSE_DEVICE], 0, arg_major, arg_minor, arg_type);
}

/**
 * login1_session_emit_resume_device:
 * @object: A #Login1Session.
 * @arg_major: Argument to pass with the signal.
 * @arg_minor: Argument to pass with the signal.
 * @arg_fd: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-login1-Session.ResumeDevice">"ResumeDevice"</link> D-Bus signal.
 */
void
login1_session_emit_resume_device (
    Login1Session *object,
    guint arg_major,
    guint arg_minor,
    GVariant *arg_fd)
{
  g_signal_emit (object, LOGIN1__SESSION_SIGNALS[LOGIN1__SESSION_RESUME_DEVICE], 0, arg_major, arg_minor, arg_fd);
}

/**
 * login1_session_call_activate:
 * @proxy: A #Login1SessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.Activate">Activate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call login1_session_call_activate_finish() to get the result of the operation.
 *
 * See login1_session_call_activate_sync() for the synchronous, blocking version of this method.
 */
void
login1_session_call_activate (
    Login1Session *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Activate",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * login1_session_call_activate_finish:
 * @proxy: A #Login1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to login1_session_call_activate().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with login1_session_call_activate().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
login1_session_call_activate_finish (
    Login1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * login1_session_call_activate_sync:
 * @proxy: A #Login1SessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.Activate">Activate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See login1_session_call_activate() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
login1_session_call_activate_sync (
    Login1Session *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Activate",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * login1_session_call_take_control:
 * @proxy: A #Login1SessionProxy.
 * @arg_force: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeControl">TakeControl()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call login1_session_call_take_control_finish() to get the result of the operation.
 *
 * See login1_session_call_take_control_sync() for the synchronous, blocking version of this method.
 */
void
login1_session_call_take_control (
    Login1Session *proxy,
    gboolean arg_force,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "TakeControl",
    g_variant_new ("(b)",
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * login1_session_call_take_control_finish:
 * @proxy: A #Login1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to login1_session_call_take_control().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with login1_session_call_take_control().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
login1_session_call_take_control_finish (
    Login1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * login1_session_call_take_control_sync:
 * @proxy: A #Login1SessionProxy.
 * @arg_force: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeControl">TakeControl()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See login1_session_call_take_control() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
login1_session_call_take_control_sync (
    Login1Session *proxy,
    gboolean arg_force,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "TakeControl",
    g_variant_new ("(b)",
                   arg_force),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * login1_session_call_release_control:
 * @proxy: A #Login1SessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseControl">ReleaseControl()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call login1_session_call_release_control_finish() to get the result of the operation.
 *
 * See login1_session_call_release_control_sync() for the synchronous, blocking version of this method.
 */
void
login1_session_call_release_control (
    Login1Session *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReleaseControl",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * login1_session_call_release_control_finish:
 * @proxy: A #Login1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to login1_session_call_release_control().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with login1_session_call_release_control().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
login1_session_call_release_control_finish (
    Login1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * login1_session_call_release_control_sync:
 * @proxy: A #Login1SessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseControl">ReleaseControl()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See login1_session_call_release_control() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
login1_session_call_release_control_sync (
    Login1Session *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReleaseControl",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * login1_session_call_take_device:
 * @proxy: A #Login1SessionProxy.
 * @arg_major: Argument to pass with the method invocation.
 * @arg_minor: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeDevice">TakeDevice()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call login1_session_call_take_device_finish() to get the result of the operation.
 *
 * See login1_session_call_take_device_sync() for the synchronous, blocking version of this method.
 */
void
login1_session_call_take_device (
    Login1Session *proxy,
    guint arg_major,
    guint arg_minor,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "TakeDevice",
    g_variant_new ("(uu)",
                   arg_major,
                   arg_minor),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * login1_session_call_take_device_finish:
 * @proxy: A #Login1SessionProxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_paused: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to login1_session_call_take_device().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with login1_session_call_take_device().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
login1_session_call_take_device_finish (
    Login1Session *proxy,
    GVariant **out_fd,
    gboolean *out_paused,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@hb)",
                 out_fd,
                 out_paused);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * login1_session_call_take_device_sync:
 * @proxy: A #Login1SessionProxy.
 * @arg_major: Argument to pass with the method invocation.
 * @arg_minor: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_paused: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeDevice">TakeDevice()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See login1_session_call_take_device() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
login1_session_call_take_device_sync (
    Login1Session *proxy,
    guint arg_major,
    guint arg_minor,
    GUnixFDList  *fd_list,
    GVariant **out_fd,
    gboolean *out_paused,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "TakeDevice",
    g_variant_new ("(uu)",
                   arg_major,
                   arg_minor),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@hb)",
                 out_fd,
                 out_paused);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * login1_session_call_release_device:
 * @proxy: A #Login1SessionProxy.
 * @arg_major: Argument to pass with the method invocation.
 * @arg_minor: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseDevice">ReleaseDevice()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call login1_session_call_release_device_finish() to get the result of the operation.
 *
 * See login1_session_call_release_device_sync() for the synchronous, blocking version of this method.
 */
void
login1_session_call_release_device (
    Login1Session *proxy,
    guint arg_major,
    guint arg_minor,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReleaseDevice",
    g_variant_new ("(uu)",
                   arg_major,
                   arg_minor),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * login1_session_call_release_device_finish:
 * @proxy: A #Login1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to login1_session_call_release_device().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with login1_session_call_release_device().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
login1_session_call_release_device_finish (
    Login1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * login1_session_call_release_device_sync:
 * @proxy: A #Login1SessionProxy.
 * @arg_major: Argument to pass with the method invocation.
 * @arg_minor: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseDevice">ReleaseDevice()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See login1_session_call_release_device() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
login1_session_call_release_device_sync (
    Login1Session *proxy,
    guint arg_major,
    guint arg_minor,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReleaseDevice",
    g_variant_new ("(uu)",
                   arg_major,
                   arg_minor),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * login1_session_call_pause_device_complete:
 * @proxy: A #Login1SessionProxy.
 * @arg_major: Argument to pass with the method invocation.
 * @arg_minor: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.PauseDeviceComplete">PauseDeviceComplete()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call login1_session_call_pause_device_complete_finish() to get the result of the operation.
 *
 * See login1_session_call_pause_device_complete_sync() for the synchronous, blocking version of this method.
 */
void
login1_session_call_pause_device_complete (
    Login1Session *proxy,
    guint arg_major,
    guint arg_minor,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PauseDeviceComplete",
    g_variant_new ("(uu)",
                   arg_major,
                   arg_minor),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * login1_session_call_pause_device_complete_finish:
 * @proxy: A #Login1SessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to login1_session_call_pause_device_complete().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with login1_session_call_pause_device_complete().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
login1_session_call_pause_device_complete_finish (
    Login1Session *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * login1_session_call_pause_device_complete_sync:
 * @proxy: A #Login1SessionProxy.
 * @arg_major: Argument to pass with the method invocation.
 * @arg_minor: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Session.PauseDeviceComplete">PauseDeviceComplete()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See login1_session_call_pause_device_complete() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
login1_session_call_pause_device_complete_sync (
    Login1Session *proxy,
    guint arg_major,
    guint arg_minor,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PauseDeviceComplete",
    g_variant_new ("(uu)",
                   arg_major,
                   arg_minor),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * login1_session_complete_activate:
 * @object: A #Login1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.Activate">Activate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
login1_session_complete_activate (
    Login1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * login1_session_complete_take_control:
 * @object: A #Login1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeControl">TakeControl()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
login1_session_complete_take_control (
    Login1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * login1_session_complete_release_control:
 * @object: A #Login1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseControl">ReleaseControl()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
login1_session_complete_release_control (
    Login1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * login1_session_complete_take_device:
 * @object: A #Login1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd: Parameter to return.
 * @paused: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.TakeDevice">TakeDevice()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
login1_session_complete_take_device (
    Login1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd,
    gboolean paused)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@hb)",
                   fd,
                   paused),
    fd_list);
}

/**
 * login1_session_complete_release_device:
 * @object: A #Login1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.ReleaseDevice">ReleaseDevice()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
login1_session_complete_release_device (
    Login1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * login1_session_complete_pause_device_complete:
 * @object: A #Login1Session.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Session.PauseDeviceComplete">PauseDeviceComplete()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
login1_session_complete_pause_device_complete (
    Login1Session *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * Login1SessionProxy:
 *
 * The #Login1SessionProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Login1SessionProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Login1SessionProxy.
 */

struct _Login1SessionProxyPrivate
{
  GData *qdata;
};

static void login1_session_proxy_iface_init (Login1SessionIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (Login1SessionProxy, login1_session_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (Login1SessionProxy)
                         G_IMPLEMENT_INTERFACE (LOGIN1_TYPE_SESSION, login1_session_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (Login1SessionProxy, login1_session_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (LOGIN1_TYPE_SESSION, login1_session_proxy_iface_init))

#endif
static void
login1_session_proxy_finalize (GObject *object)
{
  Login1SessionProxy *proxy = LOGIN1_SESSION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (login1_session_proxy_parent_class)->finalize (object);
}

static void
login1_session_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _login1_session_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
login1_session_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.login1.Session: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
login1_session_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _login1_session_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.login1.Session", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) login1_session_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
login1_session_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_login1_session_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], LOGIN1_TYPE_SESSION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, LOGIN1_TYPE_SESSION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
login1_session_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  Login1SessionProxy *proxy = LOGIN1_SESSION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_login1_session_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_login1_session_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
login1_session_proxy_get_active (Login1Session *object)
{
  Login1SessionProxy *proxy = LOGIN1_SESSION_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Active");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
login1_session_proxy_init (Login1SessionProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = login1_session_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, LOGIN1_TYPE_SESSION_PROXY, Login1SessionProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), login1_session_interface_info ());
}

static void
login1_session_proxy_class_init (Login1SessionProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = login1_session_proxy_finalize;
  gobject_class->get_property = login1_session_proxy_get_property;
  gobject_class->set_property = login1_session_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = login1_session_proxy_g_signal;
  proxy_class->g_properties_changed = login1_session_proxy_g_properties_changed;

  login1_session_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (Login1SessionProxyPrivate));
#endif
}

static void
login1_session_proxy_iface_init (Login1SessionIface *iface)
{
  iface->get_active = login1_session_proxy_get_active;
}

/**
 * login1_session_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Session.top_of_page">org.freedesktop.login1.Session</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call login1_session_proxy_new_finish() to get the result of the operation.
 *
 * See login1_session_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
login1_session_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (LOGIN1_TYPE_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.login1.Session", NULL);
}

/**
 * login1_session_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to login1_session_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with login1_session_proxy_new().
 *
 * Returns: (transfer full) (type Login1SessionProxy): The constructed proxy object or %NULL if @error is set.
 */
Login1Session *
login1_session_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return LOGIN1_SESSION (ret);
  else
    return NULL;
}

/**
 * login1_session_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Session.top_of_page">org.freedesktop.login1.Session</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See login1_session_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Login1SessionProxy): The constructed proxy object or %NULL if @error is set.
 */
Login1Session *
login1_session_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (LOGIN1_TYPE_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.login1.Session", NULL);
  if (ret != NULL)
    return LOGIN1_SESSION (ret);
  else
    return NULL;
}


/**
 * login1_session_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like login1_session_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call login1_session_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See login1_session_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
login1_session_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (LOGIN1_TYPE_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.login1.Session", NULL);
}

/**
 * login1_session_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to login1_session_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with login1_session_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type Login1SessionProxy): The constructed proxy object or %NULL if @error is set.
 */
Login1Session *
login1_session_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return LOGIN1_SESSION (ret);
  else
    return NULL;
}

/**
 * login1_session_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like login1_session_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See login1_session_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Login1SessionProxy): The constructed proxy object or %NULL if @error is set.
 */
Login1Session *
login1_session_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (LOGIN1_TYPE_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.login1.Session", NULL);
  if (ret != NULL)
    return LOGIN1_SESSION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * Login1SessionSkeleton:
 *
 * The #Login1SessionSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Login1SessionSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Login1SessionSkeleton.
 */

struct _Login1SessionSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_login1_session_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  Login1SessionSkeleton *skeleton = LOGIN1_SESSION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], LOGIN1_TYPE_SESSION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, LOGIN1_TYPE_SESSION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_login1_session_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  Login1SessionSkeleton *skeleton = LOGIN1_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_login1_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_login1_session_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  Login1SessionSkeleton *skeleton = LOGIN1_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_login1_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _login1_session_skeleton_vtable =
{
  _login1_session_skeleton_handle_method_call,
  _login1_session_skeleton_handle_get_property,
  _login1_session_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
login1_session_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return login1_session_interface_info ();
}

static GDBusInterfaceVTable *
login1_session_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_login1_session_skeleton_vtable;
}

static GVariant *
login1_session_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  Login1SessionSkeleton *skeleton = LOGIN1_SESSION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_login1_session_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _login1_session_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _login1_session_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _login1_session_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.login1.Session", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _login1_session_emit_changed (gpointer user_data);

static void
login1_session_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  Login1SessionSkeleton *skeleton = LOGIN1_SESSION_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _login1_session_emit_changed (skeleton);
}

static void
_login1_session_on_signal_pause_device (
    Login1Session *object,
    guint arg_major,
    guint arg_minor,
    const gchar *arg_type)
{
  Login1SessionSkeleton *skeleton = LOGIN1_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(uus)",
                   arg_major,
                   arg_minor,
                   arg_type));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.login1.Session", "PauseDevice",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_login1_session_on_signal_resume_device (
    Login1Session *object,
    guint arg_major,
    guint arg_minor,
    GVariant *arg_fd)
{
  Login1SessionSkeleton *skeleton = LOGIN1_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(uu@h)",
                   arg_major,
                   arg_minor,
                   arg_fd));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.login1.Session", "ResumeDevice",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void login1_session_skeleton_iface_init (Login1SessionIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (Login1SessionSkeleton, login1_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (Login1SessionSkeleton)
                         G_IMPLEMENT_INTERFACE (LOGIN1_TYPE_SESSION, login1_session_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (Login1SessionSkeleton, login1_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (LOGIN1_TYPE_SESSION, login1_session_skeleton_iface_init))

#endif
static void
login1_session_skeleton_finalize (GObject *object)
{
  Login1SessionSkeleton *skeleton = LOGIN1_SESSION_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (login1_session_skeleton_parent_class)->finalize (object);
}

static void
login1_session_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  Login1SessionSkeleton *skeleton = LOGIN1_SESSION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_login1_session_emit_changed (gpointer user_data)
{
  Login1SessionSkeleton *skeleton = LOGIN1_SESSION_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.login1.Session",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_login1_session_schedule_emit_changed (Login1SessionSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
login1_session_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  Login1SessionSkeleton *skeleton = LOGIN1_SESSION_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _login1_session_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _login1_session_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
login1_session_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  Login1SessionSkeleton *skeleton = LOGIN1_SESSION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _login1_session_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _login1_session_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
login1_session_skeleton_init (Login1SessionSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = login1_session_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, LOGIN1_TYPE_SESSION_SKELETON, Login1SessionSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
}

static gboolean 
login1_session_skeleton_get_active (Login1Session *object)
{
  Login1SessionSkeleton *skeleton = LOGIN1_SESSION_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
login1_session_skeleton_class_init (Login1SessionSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = login1_session_skeleton_finalize;
  gobject_class->get_property = login1_session_skeleton_get_property;
  gobject_class->set_property = login1_session_skeleton_set_property;
  gobject_class->notify       = login1_session_skeleton_notify;


  login1_session_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = login1_session_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = login1_session_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = login1_session_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = login1_session_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (Login1SessionSkeletonPrivate));
#endif
}

static void
login1_session_skeleton_iface_init (Login1SessionIface *iface)
{
  iface->pause_device = _login1_session_on_signal_pause_device;
  iface->resume_device = _login1_session_on_signal_resume_device;
  iface->get_active = login1_session_skeleton_get_active;
}

/**
 * login1_session_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Session.top_of_page">org.freedesktop.login1.Session</link>.
 *
 * Returns: (transfer full) (type Login1SessionSkeleton): The skeleton object.
 */
Login1Session *
login1_session_skeleton_new (void)
{
  return LOGIN1_SESSION (g_object_new (LOGIN1_TYPE_SESSION_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.login1.Seat
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:Login1Seat
 * @title: Login1Seat
 * @short_description: Generated C code for the org.freedesktop.login1.Seat D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-login1-Seat.top_of_page">org.freedesktop.login1.Seat</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.login1.Seat ---- */

static const _ExtendedGDBusArgInfo _login1_seat_method_info_switch_to_IN_ARG_vt =
{
  {
    -1,
    (gchar *) "vt",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _login1_seat_method_info_switch_to_IN_ARG_pointers[] =
{
  &_login1_seat_method_info_switch_to_IN_ARG_vt.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _login1_seat_method_info_switch_to =
{
  {
    -1,
    (gchar *) "SwitchTo",
    (GDBusArgInfo **) &_login1_seat_method_info_switch_to_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-switch-to",
  FALSE
};

static const GDBusMethodInfo * const _login1_seat_method_info_pointers[] =
{
  &_login1_seat_method_info_switch_to.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _login1_seat_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.login1.Seat",
    (GDBusMethodInfo **) &_login1_seat_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "seat",
};


/**
 * login1_seat_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-login1-Seat.top_of_page">org.freedesktop.login1.Seat</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
login1_seat_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_login1_seat_interface_info.parent_struct;
}

/**
 * login1_seat_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #Login1Seat interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
login1_seat_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
login1_seat_method_marshal_switch_to (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * Login1Seat:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Seat.top_of_page">org.freedesktop.login1.Seat</link>.
 */

/**
 * Login1SeatIface:
 * @parent_iface: The parent interface.
 * @handle_switch_to: Handler for the #Login1Seat::handle-switch-to signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Seat.top_of_page">org.freedesktop.login1.Seat</link>.
 */

typedef Login1SeatIface Login1SeatInterface;
G_DEFINE_INTERFACE (Login1Seat, login1_seat, G_TYPE_OBJECT)

static void
login1_seat_default_init (Login1SeatIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * Login1Seat::handle-switch-to:
   * @object: A #Login1Seat.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_vt: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-login1-Seat.SwitchTo">SwitchTo()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call login1_seat_complete_switch_to() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-switch-to",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (Login1SeatIface, handle_switch_to),
    g_signal_accumulator_true_handled,
    NULL,
      login1_seat_method_marshal_switch_to,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

}

/**
 * login1_seat_call_switch_to:
 * @proxy: A #Login1SeatProxy.
 * @arg_vt: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Seat.SwitchTo">SwitchTo()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call login1_seat_call_switch_to_finish() to get the result of the operation.
 *
 * See login1_seat_call_switch_to_sync() for the synchronous, blocking version of this method.
 */
void
login1_seat_call_switch_to (
    Login1Seat *proxy,
    guint arg_vt,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SwitchTo",
    g_variant_new ("(u)",
                   arg_vt),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * login1_seat_call_switch_to_finish:
 * @proxy: A #Login1SeatProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to login1_seat_call_switch_to().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with login1_seat_call_switch_to().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
login1_seat_call_switch_to_finish (
    Login1Seat *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * login1_seat_call_switch_to_sync:
 * @proxy: A #Login1SeatProxy.
 * @arg_vt: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-login1-Seat.SwitchTo">SwitchTo()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See login1_seat_call_switch_to() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
login1_seat_call_switch_to_sync (
    Login1Seat *proxy,
    guint arg_vt,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SwitchTo",
    g_variant_new ("(u)",
                   arg_vt),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * login1_seat_complete_switch_to:
 * @object: A #Login1Seat.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-login1-Seat.SwitchTo">SwitchTo()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
login1_seat_complete_switch_to (
    Login1Seat *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * Login1SeatProxy:
 *
 * The #Login1SeatProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Login1SeatProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Login1SeatProxy.
 */

struct _Login1SeatProxyPrivate
{
  GData *qdata;
};

static void login1_seat_proxy_iface_init (Login1SeatIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (Login1SeatProxy, login1_seat_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (Login1SeatProxy)
                         G_IMPLEMENT_INTERFACE (LOGIN1_TYPE_SEAT, login1_seat_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (Login1SeatProxy, login1_seat_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (LOGIN1_TYPE_SEAT, login1_seat_proxy_iface_init))

#endif
static void
login1_seat_proxy_finalize (GObject *object)
{
  Login1SeatProxy *proxy = LOGIN1_SEAT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (login1_seat_proxy_parent_class)->finalize (object);
}

static void
login1_seat_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
login1_seat_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
login1_seat_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_login1_seat_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], LOGIN1_TYPE_SEAT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, LOGIN1_TYPE_SEAT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
login1_seat_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  Login1SeatProxy *proxy = LOGIN1_SEAT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_login1_seat_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_login1_seat_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
login1_seat_proxy_init (Login1SeatProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = login1_seat_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, LOGIN1_TYPE_SEAT_PROXY, Login1SeatProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), login1_seat_interface_info ());
}

static void
login1_seat_proxy_class_init (Login1SeatProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = login1_seat_proxy_finalize;
  gobject_class->get_property = login1_seat_proxy_get_property;
  gobject_class->set_property = login1_seat_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = login1_seat_proxy_g_signal;
  proxy_class->g_properties_changed = login1_seat_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (Login1SeatProxyPrivate));
#endif
}

static void
login1_seat_proxy_iface_init (Login1SeatIface *iface G_GNUC_UNUSED)
{
}

/**
 * login1_seat_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Seat.top_of_page">org.freedesktop.login1.Seat</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call login1_seat_proxy_new_finish() to get the result of the operation.
 *
 * See login1_seat_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
login1_seat_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (LOGIN1_TYPE_SEAT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.login1.Seat", NULL);
}

/**
 * login1_seat_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to login1_seat_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with login1_seat_proxy_new().
 *
 * Returns: (transfer full) (type Login1SeatProxy): The constructed proxy object or %NULL if @error is set.
 */
Login1Seat *
login1_seat_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return LOGIN1_SEAT (ret);
  else
    return NULL;
}

/**
 * login1_seat_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Seat.top_of_page">org.freedesktop.login1.Seat</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See login1_seat_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Login1SeatProxy): The constructed proxy object or %NULL if @error is set.
 */
Login1Seat *
login1_seat_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (LOGIN1_TYPE_SEAT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.login1.Seat", NULL);
  if (ret != NULL)
    return LOGIN1_SEAT (ret);
  else
    return NULL;
}


/**
 * login1_seat_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like login1_seat_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call login1_seat_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See login1_seat_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
login1_seat_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (LOGIN1_TYPE_SEAT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.login1.Seat", NULL);
}

/**
 * login1_seat_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to login1_seat_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with login1_seat_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type Login1SeatProxy): The constructed proxy object or %NULL if @error is set.
 */
Login1Seat *
login1_seat_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return LOGIN1_SEAT (ret);
  else
    return NULL;
}

/**
 * login1_seat_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like login1_seat_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See login1_seat_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type Login1SeatProxy): The constructed proxy object or %NULL if @error is set.
 */
Login1Seat *
login1_seat_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (LOGIN1_TYPE_SEAT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.login1.Seat", NULL);
  if (ret != NULL)
    return LOGIN1_SEAT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * Login1SeatSkeleton:
 *
 * The #Login1SeatSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * Login1SeatSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #Login1SeatSkeleton.
 */

struct _Login1SeatSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_login1_seat_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  Login1SeatSkeleton *skeleton = LOGIN1_SEAT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], LOGIN1_TYPE_SEAT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, LOGIN1_TYPE_SEAT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_login1_seat_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  Login1SeatSkeleton *skeleton = LOGIN1_SEAT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_login1_seat_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_login1_seat_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  Login1SeatSkeleton *skeleton = LOGIN1_SEAT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_login1_seat_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _login1_seat_skeleton_vtable =
{
  _login1_seat_skeleton_handle_method_call,
  _login1_seat_skeleton_handle_get_property,
  _login1_seat_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
login1_seat_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return login1_seat_interface_info ();
}

static GDBusInterfaceVTable *
login1_seat_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_login1_seat_skeleton_vtable;
}

static GVariant *
login1_seat_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  Login1SeatSkeleton *skeleton = LOGIN1_SEAT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_login1_seat_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _login1_seat_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _login1_seat_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _login1_seat_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.login1.Seat", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
login1_seat_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void login1_seat_skeleton_iface_init (Login1SeatIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (Login1SeatSkeleton, login1_seat_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (Login1SeatSkeleton)
                         G_IMPLEMENT_INTERFACE (LOGIN1_TYPE_SEAT, login1_seat_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (Login1SeatSkeleton, login1_seat_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (LOGIN1_TYPE_SEAT, login1_seat_skeleton_iface_init))

#endif
static void
login1_seat_skeleton_finalize (GObject *object)
{
  Login1SeatSkeleton *skeleton = LOGIN1_SEAT_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (login1_seat_skeleton_parent_class)->finalize (object);
}

static void
login1_seat_skeleton_init (Login1SeatSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = login1_seat_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, LOGIN1_TYPE_SEAT_SKELETON, Login1SeatSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
login1_seat_skeleton_class_init (Login1SeatSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = login1_seat_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = login1_seat_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = login1_seat_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = login1_seat_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = login1_seat_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (Login1SeatSkeletonPrivate));
#endif
}

static void
login1_seat_skeleton_iface_init (Login1SeatIface *iface G_GNUC_UNUSED)
{
}

/**
 * login1_seat_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-login1-Seat.top_of_page">org.freedesktop.login1.Seat</link>.
 *
 * Returns: (transfer full) (type Login1SeatSkeleton): The skeleton object.
 */
Login1Seat *
login1_seat_skeleton_new (void)
{
  return LOGIN1_SEAT (g_object_new (LOGIN1_TYPE_SEAT_SKELETON, NULL));
}

