use gio::prelude::ToVariant;
use glib::Boxed;
use news_flash::models::TagID;
use serde::{Deserialize, Serialize};
use std::fmt;

#[derive(Clone, Debug, Eq, Boxed, Serialize, Deserialize)]
#[boxed_type(name = "GTagID")]
pub struct GTagID(TagID);

impl From<TagID> for GTagID {
    fn from(id: TagID) -> Self {
        Self(id)
    }
}

impl AsRef<TagID> for GTagID {
    fn as_ref(&self) -> &TagID {
        &self.0
    }
}

impl From<GTagID> for TagID {
    fn from(id: GTagID) -> Self {
        id.0
    }
}

impl Default for GTagID {
    fn default() -> Self {
        TagID::from_owned(String::new()).into()
    }
}

impl ToVariant for GTagID {
    fn to_variant(&self) -> glib::Variant {
        self.0.as_str().to_variant()
    }
}

impl fmt::Display for GTagID {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(f, "{}", self.0)
    }
}

impl PartialEq for GTagID {
    fn eq(&self, other: &GTagID) -> bool {
        self.0 == other.0
    }
}
