/* desktop-file-service.c generated by valac 0.56.18, the Vala compiler
 * generated from desktop-file-service.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017-2021 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include <glib.h>
#include <glib-object.h>
#include "slingshot.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>
#include <gee.h>

#define SYNAPSE_DESKTOP_FILE_SERVICE_DEFAULT_TIMEOUT_SECONDS 3
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SYNAPSE_TYPE_DESKTOP_FILE_ERROR (synapse_desktop_file_error_get_type ())
enum  {
	SYNAPSE_DESKTOP_FILE_INFO_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_GENERIC_NAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_GETTEXT_DOMAIN_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	SYNAPSE_DESKTOP_FILE_SERVICE_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_SERVICE_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_service_properties[SYNAPSE_DESKTOP_FILE_SERVICE_NUM_PROPERTIES];
#define _synapse_utils_async_once_unref0(var) ((var == NULL) ? NULL : (var = (synapse_utils_async_once_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _SynapseDesktopFileServiceInitializeData SynapseDesktopFileServiceInitializeData;
enum  {
	SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_STARTED_SIGNAL,
	SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_DONE_SIGNAL,
	SYNAPSE_DESKTOP_FILE_SERVICE_NUM_SIGNALS
};
static guint synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_NUM_SIGNALS] = {0};

typedef enum  {
	SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY
} SynapseDesktopFileError;
#define SYNAPSE_DESKTOP_FILE_ERROR synapse_desktop_file_error_quark ()

struct _SynapseDesktopFileInfoPrivate {
	gchar* _desktop_id;
	gchar* _name;
	gchar* _generic_name;
	gchar* _comment;
	gchar* _icon_name;
	gchar* _gettext_domain;
	gboolean _needs_terminal;
	gchar* _filename;
	gchar* _exec;
	gboolean _is_hidden;
	gboolean _is_valid;
	gchar* name_folded;
	SynapseDesktopFileInfoEnvironmentType _show_in;
};

struct _SynapseDesktopFileServicePrivate {
	SynapseUtilsAsyncOnce* init_once;
	GAppInfoMonitor* app_info_monitor;
	GeeList* non_hidden_desktop_files;
	GeeMap* exec_map;
	GeeMap* desktop_id_map;
	guint queued_update_id;
	GRegex* exec_regex;
};

struct _SynapseDesktopFileServiceInitializeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFileService* self;
	SynapseUtilsAsyncOnce* _tmp0_;
	gboolean is_locked;
	SynapseUtilsAsyncOnce* _tmp1_;
	GAppInfoMonitor* _tmp2_;
	GAppInfoMonitor* _tmp3_;
	SynapseUtilsAsyncOnce* _tmp4_;
};

static gint SynapseDesktopFileInfo_private_offset;
static gpointer synapse_desktop_file_info_parent_class = NULL;
static gint SynapseDesktopFileService_private_offset;
static gpointer synapse_desktop_file_service_parent_class = NULL;
static SynapseDesktopFileService* synapse_desktop_file_service_instance;
static SynapseDesktopFileService* synapse_desktop_file_service_instance = NULL;

VALA_EXTERN GQuark synapse_desktop_file_error_quark (void);
VALA_EXTERN GType synapse_desktop_file_error_get_type (void) G_GNUC_CONST ;
static void synapse_desktop_file_info_init_from_desktop_app_info (SynapseDesktopFileInfo* self,
                                                           GDesktopAppInfo* app_info);
static SynapseDesktopFileInfoEnvironmentType synapse_desktop_file_info_parse_environments (SynapseDesktopFileInfo* self,
                                                                                    gchar** environments,
                                                                                    gint environments_length1);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void synapse_desktop_file_info_set_is_hidden (SynapseDesktopFileInfo* self,
                                              gboolean value);
static void synapse_desktop_file_info_set_is_valid (SynapseDesktopFileInfo* self,
                                             gboolean value);
static void synapse_desktop_file_info_finalize (GObject * obj);
static GType synapse_desktop_file_info_get_type_once (void);
static void _vala_synapse_desktop_file_info_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_synapse_desktop_file_info_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static SynapseDesktopFileService* synapse_desktop_file_service_new (void);
static SynapseDesktopFileService* synapse_desktop_file_service_construct (GType object_type);
static void synapse_desktop_file_service_initialize_data_free (gpointer _data);
static gboolean synapse_desktop_file_service_initialize_co (SynapseDesktopFileServiceInitializeData* _data_);
static void synapse_desktop_file_service_initialize_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void synapse_desktop_file_service_load_all_desktop_files (SynapseDesktopFileService* self);
static void synapse_desktop_file_service_queue_cache_update (SynapseDesktopFileService* self);
static void _synapse_desktop_file_service_queue_cache_update_g_app_info_monitor_changed (GAppInfoMonitor* _sender,
                                                                                  gpointer self);
static gboolean __lambda6_ (SynapseDesktopFileService* self);
static gboolean ___lambda6__gsource_func (gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static GObject * synapse_desktop_file_service_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void synapse_desktop_file_service_finalize (GObject * obj);
static GType synapse_desktop_file_service_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const gchar* SYNAPSE_DESKTOP_FILE_INFO_SUPPORTED_GETTEXT_DOMAINS_KEYS[2] = {"X-Ubuntu-Gettext-Domain", "X-GNOME-Gettext-Domain"};

GQuark
synapse_desktop_file_error_quark (void)
{
	return g_quark_from_static_string ("synapse-desktop-file-error-quark");
}

static GType
synapse_desktop_file_error_get_type_once (void)
{
	static const GEnumValue values[] = {{SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, "SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY", "uninteresting-entry"}, {0, NULL, NULL}};
	GType synapse_desktop_file_error_type_id;
	synapse_desktop_file_error_type_id = g_enum_register_static ("SynapseDesktopFileError", values);
	return synapse_desktop_file_error_type_id;
}

GType
synapse_desktop_file_error_get_type (void)
{
	static volatile gsize synapse_desktop_file_error_type_id__once = 0;
	if (g_once_init_enter (&synapse_desktop_file_error_type_id__once)) {
		GType synapse_desktop_file_error_type_id;
		synapse_desktop_file_error_type_id = synapse_desktop_file_error_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_error_type_id__once, synapse_desktop_file_error_type_id);
	}
	return synapse_desktop_file_error_type_id__once;
}

static inline gpointer
synapse_desktop_file_info_get_instance_private (SynapseDesktopFileInfo* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFileInfo_private_offset);
}

static GType
synapse_desktop_file_info_environment_type_get_type_once (void)
{
	static const GFlagsValue values[] = {{SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME", "gnome"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE", "kde"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE", "lxde"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXQT, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXQT", "lxqt"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_MATE, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_MATE", "mate"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_RAZOR, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_RAZOR", "razor"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX", "rox"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_TDE, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_TDE", "tde"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_UNITY, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_UNITY", "unity"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE", "xfce"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_PANTHEON, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_PANTHEON", "pantheon"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_OLD, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_OLD", "old"}, {SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL, "SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL", "all"}, {0, NULL, NULL}};
	GType synapse_desktop_file_info_environment_type_type_id;
	synapse_desktop_file_info_environment_type_type_id = g_flags_register_static ("SynapseDesktopFileInfoEnvironmentType", values);
	return synapse_desktop_file_info_environment_type_type_id;
}

GType
synapse_desktop_file_info_environment_type_get_type (void)
{
	static volatile gsize synapse_desktop_file_info_environment_type_type_id__once = 0;
	if (g_once_init_enter (&synapse_desktop_file_info_environment_type_type_id__once)) {
		GType synapse_desktop_file_info_environment_type_type_id;
		synapse_desktop_file_info_environment_type_type_id = synapse_desktop_file_info_environment_type_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_info_environment_type_type_id__once, synapse_desktop_file_info_environment_type_type_id);
	}
	return synapse_desktop_file_info_environment_type_type_id__once;
}

const gchar*
synapse_desktop_file_info_get_name_folded (SynapseDesktopFileInfo* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp3_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->name_folded;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->_name;
		_tmp2_ = g_utf8_casefold (_tmp1_, (gssize) -1);
		_g_free0 (self->priv->name_folded);
		self->priv->name_folded = _tmp2_;
	}
	_tmp3_ = self->priv->name_folded;
	result = _tmp3_;
	return result;
}

SynapseDesktopFileInfo*
synapse_desktop_file_info_construct_for_desktop_app_info (GType object_type,
                                                          GDesktopAppInfo* app_info)
{
	SynapseDesktopFileInfo * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (app_info != NULL, NULL);
	_tmp0_ = g_app_info_get_id ((GAppInfo*) app_info);
	_tmp1_ = g_desktop_app_info_get_filename (app_info);
	_tmp2_ = _tmp1_;
	self = (SynapseDesktopFileInfo*) g_object_new (object_type, "desktop-id", _tmp0_, "filename", _tmp2_, NULL);
	synapse_desktop_file_info_init_from_desktop_app_info (self, app_info);
	return self;
}

SynapseDesktopFileInfo*
synapse_desktop_file_info_new_for_desktop_app_info (GDesktopAppInfo* app_info)
{
	return synapse_desktop_file_info_construct_for_desktop_app_info (SYNAPSE_TYPE_DESKTOP_FILE_INFO, app_info);
}

static SynapseDesktopFileInfoEnvironmentType
synapse_desktop_file_info_parse_environments (SynapseDesktopFileInfo* self,
                                              gchar** environments,
                                              gint environments_length1)
{
	SynapseDesktopFileInfoEnvironmentType _result_ = 0U;
	SynapseDesktopFileInfoEnvironmentType result;
	g_return_val_if_fail (self != NULL, 0U);
	_result_ = 0;
	{
		gchar** env_collection = NULL;
		gint env_collection_length1 = 0;
		gint _env_collection_size_ = 0;
		gint env_it = 0;
		env_collection = environments;
		env_collection_length1 = environments_length1;
		for (env_it = 0; env_it < env_collection_length1; env_it = env_it + 1) {
			const gchar* env = NULL;
			env = env_collection[env_it];
			{
				gchar* env_up = NULL;
				const gchar* _tmp0_;
				gchar* _tmp1_;
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				GQuark _tmp5_ = 0U;
				static GQuark _tmp4_label0 = 0;
				static GQuark _tmp4_label1 = 0;
				static GQuark _tmp4_label2 = 0;
				static GQuark _tmp4_label3 = 0;
				static GQuark _tmp4_label4 = 0;
				static GQuark _tmp4_label5 = 0;
				static GQuark _tmp4_label6 = 0;
				static GQuark _tmp4_label7 = 0;
				static GQuark _tmp4_label8 = 0;
				static GQuark _tmp4_label9 = 0;
				static GQuark _tmp4_label10 = 0;
				static GQuark _tmp4_label11 = 0;
				static GQuark _tmp4_label12 = 0;
				static GQuark _tmp4_label13 = 0;
				static GQuark _tmp4_label14 = 0;
				_tmp0_ = env;
				_tmp1_ = g_utf8_strup (_tmp0_, (gssize) -1);
				env_up = _tmp1_;
				_tmp2_ = env_up;
				_tmp3_ = _tmp2_;
				_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
				if (((_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("GNOME")))) || (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("X-CINNAMON"))))) || (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("UBUNTU"))))) {
					switch (0) {
						default:
						{
							_result_ |= SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_GNOME;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label3) ? _tmp4_label3 : (_tmp4_label3 = g_quark_from_static_string ("PANTHEON")))) {
					switch (0) {
						default:
						{
							_result_ |= SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_PANTHEON;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label4) ? _tmp4_label4 : (_tmp4_label4 = g_quark_from_static_string ("KDE")))) {
					switch (0) {
						default:
						{
							_result_ |= SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_KDE;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label5) ? _tmp4_label5 : (_tmp4_label5 = g_quark_from_static_string ("LXDE")))) {
					switch (0) {
						default:
						{
							_result_ |= SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXDE;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label6) ? _tmp4_label6 : (_tmp4_label6 = g_quark_from_static_string ("LXQT")))) {
					switch (0) {
						default:
						{
							_result_ |= SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_LXQT;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label7) ? _tmp4_label7 : (_tmp4_label7 = g_quark_from_static_string ("MATE")))) {
					switch (0) {
						default:
						{
							_result_ |= SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_MATE;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label8) ? _tmp4_label8 : (_tmp4_label8 = g_quark_from_static_string ("RAZOR")))) {
					switch (0) {
						default:
						{
							_result_ |= SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_RAZOR;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label9) ? _tmp4_label9 : (_tmp4_label9 = g_quark_from_static_string ("ROX")))) {
					switch (0) {
						default:
						{
							_result_ |= SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ROX;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label10) ? _tmp4_label10 : (_tmp4_label10 = g_quark_from_static_string ("TDE")))) {
					switch (0) {
						default:
						{
							_result_ |= SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_TDE;
							break;
						}
					}
				} else if ((_tmp5_ == ((0 != _tmp4_label11) ? _tmp4_label11 : (_tmp4_label11 = g_quark_from_static_string ("UNITY")))) || (_tmp5_ == ((0 != _tmp4_label12) ? _tmp4_label12 : (_tmp4_label12 = g_quark_from_static_string ("UNITY7"))))) {
					switch (0) {
						default:
						{
							_result_ |= SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_UNITY;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label13) ? _tmp4_label13 : (_tmp4_label13 = g_quark_from_static_string ("XFCE")))) {
					switch (0) {
						default:
						{
							_result_ |= SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_XFCE;
							break;
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label14) ? _tmp4_label14 : (_tmp4_label14 = g_quark_from_static_string ("OLD")))) {
					switch (0) {
						default:
						{
							_result_ |= SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_OLD;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							const gchar* _tmp6_;
							_tmp6_ = env;
							g_warning ("desktop-file-service.vala:119: %s is not understood", _tmp6_);
							break;
						}
					}
				}
				_g_free0 (env_up);
			}
		}
	}
	result = _result_;
	return result;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
synapse_desktop_file_info_init_from_desktop_app_info (SynapseDesktopFileInfo* self,
                                                      GDesktopAppInfo* app_info)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_info != NULL);
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		gboolean _tmp2_;
		const gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_;
		GIcon* _tmp24_ = NULL;
		GIcon* _tmp25_;
		GIcon* _tmp26_;
		GIcon* icon = NULL;
		GIcon* _tmp28_;
		GIcon* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp0_ = g_desktop_app_info_get_string (app_info, G_KEY_FILE_DESKTOP_KEY_TYPE);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strcmp0 (_tmp1_, G_KEY_FILE_DESKTOP_TYPE_APPLICATION) != 0;
		_g_free0 (_tmp1_);
		if (_tmp2_) {
			GError* _tmp3_;
			_tmp3_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, "Not Application-type desktop entry");
			_inner_error0_ = _tmp3_;
			goto __catch0_g_error;
		}
		if (g_desktop_app_info_has_key (app_info, G_KEY_FILE_DESKTOP_KEY_CATEGORIES)) {
			gchar** categories = NULL;
			gsize _tmp4_ = 0;
			gchar** _tmp5_;
			gint categories_length1;
			gint _categories_size_;
			gchar** _tmp6_;
			gint _tmp6__length1;
			_tmp5_ = g_desktop_app_info_get_string_list (app_info, G_KEY_FILE_DESKTOP_KEY_CATEGORIES, &_tmp4_);
			categories = _tmp5_;
			categories_length1 = _tmp4_;
			_categories_size_ = categories_length1;
			_tmp6_ = categories;
			_tmp6__length1 = categories_length1;
			if (_vala_string_array_contains (_tmp6_, _tmp6__length1, "Screensaver")) {
				GError* _tmp7_;
				_tmp7_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, "Screensaver desktop entry");
				_inner_error0_ = _tmp7_;
				categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
				goto __catch0_g_error;
			}
			categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
		}
		{
			const gchar** domain_key_collection = NULL;
			gint domain_key_collection_length1 = 0;
			gint _domain_key_collection_size_ = 0;
			gint domain_key_it = 0;
			domain_key_collection = SYNAPSE_DESKTOP_FILE_INFO_SUPPORTED_GETTEXT_DOMAINS_KEYS;
			domain_key_collection_length1 = G_N_ELEMENTS (SYNAPSE_DESKTOP_FILE_INFO_SUPPORTED_GETTEXT_DOMAINS_KEYS);
			for (domain_key_it = 0; domain_key_it < domain_key_collection_length1; domain_key_it = domain_key_it + 1) {
				const gchar* domain_key = NULL;
				domain_key = domain_key_collection[domain_key_it];
				{
					const gchar* _tmp8_;
					_tmp8_ = domain_key;
					if (g_desktop_app_info_has_key (app_info, _tmp8_)) {
						const gchar* _tmp9_;
						gchar* _tmp10_;
						gchar* _tmp11_;
						_tmp9_ = domain_key;
						_tmp10_ = g_desktop_app_info_get_string (app_info, _tmp9_);
						_tmp11_ = _tmp10_;
						synapse_desktop_file_info_set_gettext_domain (self, _tmp11_);
						_g_free0 (_tmp11_);
						break;
					}
				}
			}
		}
		_tmp12_ = g_app_info_get_name ((GAppInfo*) app_info);
		synapse_desktop_file_info_set_name (self, _tmp12_);
		_tmp14_ = g_desktop_app_info_get_generic_name (app_info);
		_tmp13_ = _tmp14_;
		if (_tmp13_ == NULL) {
			_tmp13_ = "";
		}
		synapse_desktop_file_info_set_generic_name (self, _tmp13_);
		_tmp15_ = g_app_info_get_commandline ((GAppInfo*) app_info);
		synapse_desktop_file_info_set_exec (self, _tmp15_);
		_tmp16_ = self->priv->_exec;
		if (_tmp16_ == NULL) {
			const gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			GError* _tmp20_;
			GError* _tmp21_;
			_tmp17_ = self->priv->_name;
			_tmp18_ = g_strdup_printf ("Unable to get exec for %s", _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, _tmp19_);
			_tmp21_ = _tmp20_;
			_g_free0 (_tmp19_);
			_inner_error0_ = _tmp21_;
			goto __catch0_g_error;
		}
		synapse_desktop_file_info_set_is_hidden (self, !g_app_info_should_show ((GAppInfo*) app_info));
		_tmp23_ = g_app_info_get_description ((GAppInfo*) app_info);
		_tmp22_ = _tmp23_;
		if (_tmp22_ == NULL) {
			_tmp22_ = "";
		}
		synapse_desktop_file_info_set_comment (self, _tmp22_);
		_tmp25_ = g_app_info_get_icon ((GAppInfo*) app_info);
		_tmp26_ = _g_object_ref0 (_tmp25_);
		_tmp24_ = _tmp26_;
		if (_tmp24_ == NULL) {
			GThemedIcon* _tmp27_;
			_tmp27_ = (GThemedIcon*) g_themed_icon_new ("application-default-icon");
			_g_object_unref0 (_tmp24_);
			_tmp24_ = (GIcon*) _tmp27_;
		}
		_tmp28_ = _tmp24_;
		_tmp24_ = NULL;
		icon = _tmp28_;
		_tmp29_ = icon;
		_tmp30_ = g_icon_to_string (_tmp29_);
		_tmp31_ = _tmp30_;
		synapse_desktop_file_info_set_icon_name (self, _tmp31_);
		_g_free0 (_tmp31_);
		if (g_desktop_app_info_has_key (app_info, G_KEY_FILE_DESKTOP_KEY_TERMINAL)) {
			synapse_desktop_file_info_set_needs_terminal (self, g_desktop_app_info_get_boolean (app_info, G_KEY_FILE_DESKTOP_KEY_TERMINAL));
		}
		if (g_desktop_app_info_has_key (app_info, G_KEY_FILE_DESKTOP_KEY_ONLY_SHOW_IN)) {
			gsize _tmp32_ = 0;
			gchar** _tmp33_;
			gchar** _tmp34_;
			gint _tmp34__length1;
			_tmp33_ = g_desktop_app_info_get_string_list (app_info, G_KEY_FILE_DESKTOP_KEY_ONLY_SHOW_IN, &_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp34__length1 = _tmp32_;
			synapse_desktop_file_info_set_show_in (self, synapse_desktop_file_info_parse_environments (self, _tmp34_, (gint) _tmp32_));
			_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
		} else {
			if (g_desktop_app_info_has_key (app_info, G_KEY_FILE_DESKTOP_KEY_NOT_SHOW_IN)) {
				SynapseDesktopFileInfoEnvironmentType not_show = 0U;
				gsize _tmp35_ = 0;
				gchar** _tmp36_;
				gchar** _tmp37_;
				gint _tmp37__length1;
				SynapseDesktopFileInfoEnvironmentType _tmp38_;
				_tmp36_ = g_desktop_app_info_get_string_list (app_info, G_KEY_FILE_DESKTOP_KEY_NOT_SHOW_IN, &_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp37__length1 = _tmp35_;
				_tmp38_ = synapse_desktop_file_info_parse_environments (self, _tmp37_, (gint) _tmp35_);
				_tmp37_ = (_vala_array_free (_tmp37_, _tmp37__length1, (GDestroyNotify) g_free), NULL);
				not_show = _tmp38_;
				synapse_desktop_file_info_set_show_in (self, SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL ^ not_show);
			}
		}
		_g_object_unref0 (icon);
		_g_object_unref0 (_tmp24_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* name = NULL;
		gchar* _tmp39_;
		GError* _tmp41_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp39_ = g_strdup ("Unidentified");
		name = _tmp39_;
		if (g_desktop_app_info_has_key (app_info, G_KEY_FILE_DESKTOP_KEY_NAME)) {
			gchar* _tmp40_;
			_tmp40_ = g_desktop_app_info_get_string (app_info, G_KEY_FILE_DESKTOP_KEY_NAME);
			_g_free0 (name);
			name = _tmp40_;
		}
		_tmp41_ = err;
		if (g_error_matches (_tmp41_, SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY)) {
			const gchar* _tmp42_;
			GError* _tmp43_;
			const gchar* _tmp44_;
			_tmp42_ = name;
			_tmp43_ = err;
			_tmp44_ = _tmp43_->message;
			g_debug ("desktop-file-service.vala:177: Ignoring DesktopFileInfo %s - %s", _tmp42_, _tmp44_);
		} else {
			GError* _tmp45_;
			const gchar* _tmp46_;
			_tmp45_ = err;
			_tmp46_ = _tmp45_->message;
			g_warning ("desktop-file-service.vala:179: Error initializing DesktopFileInfo from" \
" DesktopAppInfo - %s", _tmp46_);
		}
		synapse_desktop_file_info_set_is_valid (self, FALSE);
		_g_free0 (name);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

SynapseDesktopFileInfo*
synapse_desktop_file_info_construct (GType object_type)
{
	SynapseDesktopFileInfo * self = NULL;
	self = (SynapseDesktopFileInfo*) g_object_new (object_type, NULL);
	return self;
}

SynapseDesktopFileInfo*
synapse_desktop_file_info_new (void)
{
	return synapse_desktop_file_info_construct (SYNAPSE_TYPE_DESKTOP_FILE_INFO);
}

const gchar*
synapse_desktop_file_info_get_desktop_id (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_id;
	result = _tmp0_;
	return result;
}

void
synapse_desktop_file_info_set_desktop_id (SynapseDesktopFileInfo* self,
                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_desktop_file_info_get_desktop_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_desktop_id);
		self->priv->_desktop_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY]);
	}
}

const gchar*
synapse_desktop_file_info_get_name (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
synapse_desktop_file_info_set_name (SynapseDesktopFileInfo* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_desktop_file_info_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY]);
	}
}

const gchar*
synapse_desktop_file_info_get_generic_name (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_generic_name;
	result = _tmp0_;
	return result;
}

void
synapse_desktop_file_info_set_generic_name (SynapseDesktopFileInfo* self,
                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_desktop_file_info_get_generic_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_generic_name);
		self->priv->_generic_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_GENERIC_NAME_PROPERTY]);
	}
}

const gchar*
synapse_desktop_file_info_get_comment (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_comment;
	result = _tmp0_;
	return result;
}

void
synapse_desktop_file_info_set_comment (SynapseDesktopFileInfo* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_desktop_file_info_get_comment (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_comment);
		self->priv->_comment = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY]);
	}
}

const gchar*
synapse_desktop_file_info_get_icon_name (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}

void
synapse_desktop_file_info_set_icon_name (SynapseDesktopFileInfo* self,
                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_desktop_file_info_get_icon_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY]);
	}
}

const gchar*
synapse_desktop_file_info_get_gettext_domain (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gettext_domain;
	result = _tmp0_;
	return result;
}

void
synapse_desktop_file_info_set_gettext_domain (SynapseDesktopFileInfo* self,
                                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_desktop_file_info_get_gettext_domain (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_gettext_domain);
		self->priv->_gettext_domain = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_GETTEXT_DOMAIN_PROPERTY]);
	}
}

gboolean
synapse_desktop_file_info_get_needs_terminal (SynapseDesktopFileInfo* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_needs_terminal;
	return result;
}

void
synapse_desktop_file_info_set_needs_terminal (SynapseDesktopFileInfo* self,
                                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_desktop_file_info_get_needs_terminal (self);
	if (old_value != value) {
		self->priv->_needs_terminal = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY]);
	}
}

const gchar*
synapse_desktop_file_info_get_filename (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}

void
synapse_desktop_file_info_set_filename (SynapseDesktopFileInfo* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_desktop_file_info_get_filename (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_filename);
		self->priv->_filename = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY]);
	}
}

const gchar*
synapse_desktop_file_info_get_exec (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_exec;
	result = _tmp0_;
	return result;
}

void
synapse_desktop_file_info_set_exec (SynapseDesktopFileInfo* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_desktop_file_info_get_exec (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_exec);
		self->priv->_exec = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY]);
	}
}

gboolean
synapse_desktop_file_info_get_is_hidden (SynapseDesktopFileInfo* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_hidden;
	return result;
}

static void
synapse_desktop_file_info_set_is_hidden (SynapseDesktopFileInfo* self,
                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_desktop_file_info_get_is_hidden (self);
	if (old_value != value) {
		self->priv->_is_hidden = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY]);
	}
}

gboolean
synapse_desktop_file_info_get_is_valid (SynapseDesktopFileInfo* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_valid;
	return result;
}

static void
synapse_desktop_file_info_set_is_valid (SynapseDesktopFileInfo* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_desktop_file_info_get_is_valid (self);
	if (old_value != value) {
		self->priv->_is_valid = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY]);
	}
}

SynapseDesktopFileInfoEnvironmentType
synapse_desktop_file_info_get_show_in (SynapseDesktopFileInfo* self)
{
	SynapseDesktopFileInfoEnvironmentType result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_show_in;
	return result;
}

void
synapse_desktop_file_info_set_show_in (SynapseDesktopFileInfo* self,
                                       SynapseDesktopFileInfoEnvironmentType value)
{
	SynapseDesktopFileInfoEnvironmentType old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_desktop_file_info_get_show_in (self);
	if (old_value != value) {
		self->priv->_show_in = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY]);
	}
}

static void
synapse_desktop_file_info_class_init (SynapseDesktopFileInfoClass * klass,
                                      gpointer klass_data)
{
	synapse_desktop_file_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFileInfo_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_info_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_info_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_info_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY] = g_param_spec_string ("desktop-id", "desktop-id", "desktop-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_GENERIC_NAME_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_GENERIC_NAME_PROPERTY] = g_param_spec_string ("generic-name", "generic-name", "generic-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY] = g_param_spec_string ("comment", "comment", "comment", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_GETTEXT_DOMAIN_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_GETTEXT_DOMAIN_PROPERTY] = g_param_spec_string ("gettext-domain", "gettext-domain", "gettext-domain", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY] = g_param_spec_boolean ("needs-terminal", "needs-terminal", "needs-terminal", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY] = g_param_spec_string ("exec", "exec", "exec", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY] = g_param_spec_boolean ("is-hidden", "is-hidden", "is-hidden", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY] = g_param_spec_boolean ("is-valid", "is-valid", "is-valid", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY] = g_param_spec_flags ("show-in", "show-in", "show-in", SYNAPSE_DESKTOP_FILE_INFO_TYPE_ENVIRONMENT_TYPE, SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
synapse_desktop_file_info_instance_init (SynapseDesktopFileInfo * self,
                                         gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = synapse_desktop_file_info_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_comment = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_icon_name = _tmp1_;
	self->priv->_needs_terminal = FALSE;
	self->priv->_is_hidden = FALSE;
	self->priv->_is_valid = TRUE;
	self->priv->name_folded = NULL;
	self->priv->_show_in = SYNAPSE_DESKTOP_FILE_INFO_ENVIRONMENT_TYPE_ALL;
}

static void
synapse_desktop_file_info_finalize (GObject * obj)
{
	SynapseDesktopFileInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo);
	_g_free0 (self->priv->_desktop_id);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_generic_name);
	_g_free0 (self->priv->_comment);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_gettext_domain);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_exec);
	_g_free0 (self->priv->name_folded);
	G_OBJECT_CLASS (synapse_desktop_file_info_parent_class)->finalize (obj);
}

static GType
synapse_desktop_file_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFileInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFileInfo), 0, (GInstanceInitFunc) synapse_desktop_file_info_instance_init, NULL };
	GType synapse_desktop_file_info_type_id;
	synapse_desktop_file_info_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFileInfo", &g_define_type_info, 0);
	SynapseDesktopFileInfo_private_offset = g_type_add_instance_private (synapse_desktop_file_info_type_id, sizeof (SynapseDesktopFileInfoPrivate));
	return synapse_desktop_file_info_type_id;
}

GType
synapse_desktop_file_info_get_type (void)
{
	static volatile gsize synapse_desktop_file_info_type_id__once = 0;
	if (g_once_init_enter (&synapse_desktop_file_info_type_id__once)) {
		GType synapse_desktop_file_info_type_id;
		synapse_desktop_file_info_type_id = synapse_desktop_file_info_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_info_type_id__once, synapse_desktop_file_info_type_id);
	}
	return synapse_desktop_file_info_type_id__once;
}

static void
_vala_synapse_desktop_file_info_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	SynapseDesktopFileInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_info_get_desktop_id (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_info_get_name (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_GENERIC_NAME_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_info_get_generic_name (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_info_get_comment (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_info_get_icon_name (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_GETTEXT_DOMAIN_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_info_get_gettext_domain (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY:
		g_value_set_boolean (value, synapse_desktop_file_info_get_needs_terminal (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_info_get_filename (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY:
		g_value_set_string (value, synapse_desktop_file_info_get_exec (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY:
		g_value_set_boolean (value, synapse_desktop_file_info_get_is_hidden (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY:
		g_value_set_boolean (value, synapse_desktop_file_info_get_is_valid (self));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY:
		g_value_set_flags (value, synapse_desktop_file_info_get_show_in (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_synapse_desktop_file_info_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	SynapseDesktopFileInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo);
	switch (property_id) {
		case SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY:
		synapse_desktop_file_info_set_desktop_id (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY:
		synapse_desktop_file_info_set_name (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_GENERIC_NAME_PROPERTY:
		synapse_desktop_file_info_set_generic_name (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY:
		synapse_desktop_file_info_set_comment (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY:
		synapse_desktop_file_info_set_icon_name (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_GETTEXT_DOMAIN_PROPERTY:
		synapse_desktop_file_info_set_gettext_domain (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY:
		synapse_desktop_file_info_set_needs_terminal (self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY:
		synapse_desktop_file_info_set_filename (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY:
		synapse_desktop_file_info_set_exec (self, g_value_get_string (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY:
		synapse_desktop_file_info_set_is_hidden (self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY:
		synapse_desktop_file_info_set_is_valid (self, g_value_get_boolean (value));
		break;
		case SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY:
		synapse_desktop_file_info_set_show_in (self, g_value_get_flags (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
synapse_desktop_file_service_get_instance_private (SynapseDesktopFileService* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFileService_private_offset);
}

SynapseDesktopFileService*
synapse_desktop_file_service_get_default (void)
{
	SynapseDesktopFileService* _tmp0_ = NULL;
	SynapseDesktopFileService* _tmp1_;
	SynapseDesktopFileService* _tmp2_;
	SynapseDesktopFileService* _tmp4_;
	SynapseDesktopFileService* result;
	_tmp1_ = synapse_desktop_file_service_instance;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		SynapseDesktopFileService* _tmp3_;
		_tmp3_ = synapse_desktop_file_service_new ();
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static SynapseDesktopFileService*
synapse_desktop_file_service_construct (GType object_type)
{
	SynapseDesktopFileService * self = NULL;
	self = (SynapseDesktopFileService*) g_object_new (object_type, NULL);
	return self;
}

static SynapseDesktopFileService*
synapse_desktop_file_service_new (void)
{
	return synapse_desktop_file_service_construct (SYNAPSE_TYPE_DESKTOP_FILE_SERVICE);
}

static void
synapse_desktop_file_service_initialize_data_free (gpointer _data)
{
	SynapseDesktopFileServiceInitializeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseDesktopFileServiceInitializeData, _data_);
}

void
synapse_desktop_file_service_initialize (SynapseDesktopFileService* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	SynapseDesktopFileServiceInitializeData* _data_;
	SynapseDesktopFileService* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SynapseDesktopFileServiceInitializeData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_initialize_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	synapse_desktop_file_service_initialize_co (_data_);
}

void
synapse_desktop_file_service_initialize_finish (SynapseDesktopFileService* self,
                                                GAsyncResult* _res_)
{
	SynapseDesktopFileServiceInitializeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
synapse_desktop_file_service_initialize_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	SynapseDesktopFileServiceInitializeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	synapse_desktop_file_service_initialize_co (_data_);
}

static void
_synapse_desktop_file_service_queue_cache_update_g_app_info_monitor_changed (GAppInfoMonitor* _sender,
                                                                             gpointer self)
{
	synapse_desktop_file_service_queue_cache_update ((SynapseDesktopFileService*) self);
}

static gboolean
synapse_desktop_file_service_initialize_co (SynapseDesktopFileServiceInitializeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->init_once;
	if (synapse_utils_async_once_is_initialized (_data_->_tmp0_)) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->init_once;
	_data_->_state_ = 1;
	synapse_utils_async_once_enter (_data_->_tmp1_, synapse_desktop_file_service_initialize_ready, _data_);
	return FALSE;
	_state_1:
	_data_->is_locked = synapse_utils_async_once_enter_finish (_data_->_tmp1_, _data_->_res_);
	if (!_data_->is_locked) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	synapse_desktop_file_service_load_all_desktop_files (_data_->self);
	_data_->_tmp2_ = g_app_info_monitor_get ();
	_g_object_unref0 (_data_->self->priv->app_info_monitor);
	_data_->self->priv->app_info_monitor = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->app_info_monitor;
	g_signal_connect_object (_data_->_tmp3_, "changed", (GCallback) _synapse_desktop_file_service_queue_cache_update_g_app_info_monitor_changed, _data_->self, 0);
	_data_->_tmp4_ = _data_->self->priv->init_once;
	synapse_utils_async_once_leave (_data_->_tmp4_, (gpointer) ((gintptr) TRUE));
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
__lambda6_ (SynapseDesktopFileService* self)
{
	gboolean result;
	synapse_desktop_file_service_load_all_desktop_files (self);
	g_signal_emit (self, synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_DONE_SIGNAL], 0);
	self->priv->queued_update_id = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ ((SynapseDesktopFileService*) self);
	return result;
}

static void
synapse_desktop_file_service_queue_cache_update (SynapseDesktopFileService* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_STARTED_SIGNAL], 0);
	if (self->priv->queued_update_id != ((guint) 0)) {
		g_source_remove (self->priv->queued_update_id);
	}
	self->priv->queued_update_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) SYNAPSE_DESKTOP_FILE_SERVICE_DEFAULT_TIMEOUT_SECONDS, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
synapse_desktop_file_service_load_all_desktop_files (SynapseDesktopFileService* self)
{
	GeeList* _tmp0_;
	GeeMap* _tmp1_;
	GeeMap* _tmp2_;
	GList* app_infos = NULL;
	GList* _tmp3_;
	GList* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->non_hidden_desktop_files;
	gee_collection_clear ((GeeCollection*) _tmp0_);
	_tmp1_ = self->priv->exec_map;
	gee_map_clear (_tmp1_);
	_tmp2_ = self->priv->desktop_id_map;
	gee_map_clear (_tmp2_);
	_tmp3_ = g_app_info_get_all ();
	app_infos = _tmp3_;
	_tmp4_ = app_infos;
	{
		GList* app_collection = NULL;
		GList* app_it = NULL;
		app_collection = _tmp4_;
		for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
			GAppInfo* app = NULL;
			app = (GAppInfo*) app_it->data;
			{
				GAppInfo* _tmp5_;
				_tmp5_ = app;
				if (g_app_info_should_show (_tmp5_)) {
					GDesktopAppInfo* app_info = NULL;
					GAppInfo* _tmp6_;
					SynapseDesktopFileInfo* dfi = NULL;
					GDesktopAppInfo* _tmp7_;
					SynapseDesktopFileInfo* _tmp8_;
					GeeList* _tmp9_;
					SynapseDesktopFileInfo* _tmp10_;
					GeeMap* _tmp11_;
					SynapseDesktopFileInfo* _tmp12_;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					SynapseDesktopFileInfo* _tmp15_;
					gchar* exec = NULL;
					SynapseDesktopFileInfo* _tmp16_;
					const gchar* _tmp17_;
					const gchar* _tmp18_;
					gchar* _tmp19_;
					GRegex* _tmp20_;
					GeeList* exec_list = NULL;
					GeeMap* _tmp32_;
					const gchar* _tmp33_;
					gpointer _tmp34_;
					GeeList* _tmp35_;
					GeeList* _tmp40_;
					SynapseDesktopFileInfo* _tmp41_;
					_tmp6_ = app;
					app_info = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, G_TYPE_DESKTOP_APP_INFO, GDesktopAppInfo);
					_tmp7_ = app_info;
					_tmp8_ = synapse_desktop_file_info_new_for_desktop_app_info (_tmp7_);
					dfi = _tmp8_;
					_tmp9_ = self->priv->non_hidden_desktop_files;
					_tmp10_ = dfi;
					gee_collection_add ((GeeCollection*) _tmp9_, _tmp10_);
					_tmp11_ = self->priv->desktop_id_map;
					_tmp12_ = dfi;
					_tmp13_ = synapse_desktop_file_info_get_desktop_id (_tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = dfi;
					gee_map_set (_tmp11_, _tmp14_, _tmp15_);
					_tmp16_ = dfi;
					_tmp17_ = synapse_desktop_file_info_get_exec (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = g_strdup (_tmp18_);
					exec = _tmp19_;
					_tmp20_ = self->priv->exec_regex;
					if (_tmp20_ != NULL) {
						{
							gchar* _tmp21_ = NULL;
							GRegex* _tmp22_;
							SynapseDesktopFileInfo* _tmp23_;
							const gchar* _tmp24_;
							const gchar* _tmp25_;
							gchar* _tmp26_;
							gchar* _tmp27_;
							const gchar* _tmp28_;
							gchar* _tmp29_;
							_tmp22_ = self->priv->exec_regex;
							_tmp23_ = dfi;
							_tmp24_ = synapse_desktop_file_info_get_exec (_tmp23_);
							_tmp25_ = _tmp24_;
							_tmp26_ = g_regex_replace_literal (_tmp22_, _tmp25_, (gssize) -1, 0, "", 0, &_inner_error0_);
							_tmp21_ = _tmp26_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								if (_inner_error0_->domain == G_REGEX_ERROR) {
									goto __catch0_g_regex_error;
								}
								_g_free0 (exec);
								_g_object_unref0 (dfi);
								(app_infos == NULL) ? NULL : (app_infos = (_g_list_free__g_object_unref0_ (app_infos), NULL));
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
							_tmp27_ = _tmp21_;
							_tmp21_ = NULL;
							_g_free0 (exec);
							exec = _tmp27_;
							_tmp28_ = exec;
							_tmp29_ = string_strip (_tmp28_);
							_g_free0 (exec);
							exec = _tmp29_;
							_g_free0 (_tmp21_);
						}
						goto __finally0;
						__catch0_g_regex_error:
						{
							GError* err = NULL;
							GError* _tmp30_;
							const gchar* _tmp31_;
							err = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp30_ = err;
							_tmp31_ = _tmp30_->message;
							g_critical ("desktop-file-service.vala:291: %s", _tmp31_);
							_g_error_free0 (err);
						}
						__finally0:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (exec);
							_g_object_unref0 (dfi);
							(app_infos == NULL) ? NULL : (app_infos = (_g_list_free__g_object_unref0_ (app_infos), NULL));
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
					_tmp32_ = self->priv->exec_map;
					_tmp33_ = exec;
					_tmp34_ = gee_map_get (_tmp32_, _tmp33_);
					exec_list = (GeeList*) _tmp34_;
					_tmp35_ = exec_list;
					if (_tmp35_ == NULL) {
						GeeArrayList* _tmp36_;
						GeeMap* _tmp37_;
						const gchar* _tmp38_;
						GeeList* _tmp39_;
						_tmp36_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
						_g_object_unref0 (exec_list);
						exec_list = (GeeList*) _tmp36_;
						_tmp37_ = self->priv->exec_map;
						_tmp38_ = exec;
						_tmp39_ = exec_list;
						gee_map_set (_tmp37_, _tmp38_, _tmp39_);
					}
					_tmp40_ = exec_list;
					_tmp41_ = dfi;
					gee_collection_add ((GeeCollection*) _tmp40_, _tmp41_);
					_g_object_unref0 (exec_list);
					_g_free0 (exec);
					_g_object_unref0 (dfi);
				}
			}
		}
	}
	(app_infos == NULL) ? NULL : (app_infos = (_g_list_free__g_object_unref0_ (app_infos), NULL));
}

GeeList*
synapse_desktop_file_service_get_desktop_files (SynapseDesktopFileService* self)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->non_hidden_desktop_files;
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

GeeList*
synapse_desktop_file_service_get_desktop_files_for_exec (SynapseDesktopFileService* self,
                                                         const gchar* exec)
{
	GeeList* _tmp0_ = NULL;
	GeeMap* _tmp1_;
	gpointer _tmp2_;
	GeeList* _tmp4_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (exec != NULL, NULL);
	_tmp1_ = self->priv->exec_map;
	_tmp2_ = gee_map_get (_tmp1_, exec);
	_tmp0_ = (GeeList*) _tmp2_;
	if (_tmp0_ == NULL) {
		GeeArrayList* _tmp3_;
		_tmp3_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = (GeeList*) _tmp3_;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp0_);
	return result;
}

SynapseDesktopFileInfo*
synapse_desktop_file_service_get_desktop_file_for_id (SynapseDesktopFileService* self,
                                                      const gchar* desktop_id)
{
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	SynapseDesktopFileInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (desktop_id != NULL, NULL);
	_tmp0_ = self->priv->desktop_id_map;
	_tmp1_ = gee_map_get (_tmp0_, desktop_id);
	result = (SynapseDesktopFileInfo*) _tmp1_;
	return result;
}

static GObject *
synapse_desktop_file_service_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDesktopFileService * self;
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	SynapseUtilsAsyncOnce* _tmp3_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (synapse_desktop_file_service_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileService);
	synapse_desktop_file_service_instance = self;
	_tmp0_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->non_hidden_desktop_files);
	self->priv->non_hidden_desktop_files = (GeeList*) _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->exec_map);
	self->priv->exec_map = (GeeMap*) _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->desktop_id_map);
	self->priv->desktop_id_map = (GeeMap*) _tmp2_;
	_tmp3_ = synapse_utils_async_once_new (G_TYPE_BOOLEAN, NULL, NULL);
	_synapse_utils_async_once_unref0 (self->priv->init_once);
	self->priv->init_once = _tmp3_;
	{
		GRegex* _tmp4_ = NULL;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		_tmp5_ = g_regex_new ("%[fFuU]", 0, 0, &_inner_error0_);
		_tmp4_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp4_;
		_tmp4_ = NULL;
		_g_regex_unref0 (self->priv->exec_regex);
		self->priv->exec_regex = _tmp6_;
		_g_regex_unref0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = err;
		_tmp8_ = _tmp7_->message;
		g_warning ("desktop-file-service.vala:226: Unable to construct exec regex: %s", _tmp8_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	synapse_desktop_file_service_initialize (self, NULL, NULL);
	return obj;
}

static void
synapse_desktop_file_service_class_init (SynapseDesktopFileServiceClass * klass,
                                         gpointer klass_data)
{
	synapse_desktop_file_service_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFileService_private_offset);
	G_OBJECT_CLASS (klass)->constructor = synapse_desktop_file_service_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_service_finalize;
	synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_STARTED_SIGNAL] = g_signal_new ("reload-started", SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_DONE_SIGNAL] = g_signal_new ("reload-done", SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
synapse_desktop_file_service_instance_init (SynapseDesktopFileService * self,
                                            gpointer klass)
{
	self->priv = synapse_desktop_file_service_get_instance_private (self);
	self->priv->queued_update_id = (guint) 0;
}

static void
synapse_desktop_file_service_finalize (GObject * obj)
{
	SynapseDesktopFileService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileService);
	synapse_desktop_file_service_instance = NULL;
	_synapse_utils_async_once_unref0 (self->priv->init_once);
	_g_object_unref0 (self->priv->app_info_monitor);
	_g_object_unref0 (self->priv->non_hidden_desktop_files);
	_g_object_unref0 (self->priv->exec_map);
	_g_object_unref0 (self->priv->desktop_id_map);
	_g_regex_unref0 (self->priv->exec_regex);
	G_OBJECT_CLASS (synapse_desktop_file_service_parent_class)->finalize (obj);
}

static GType
synapse_desktop_file_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFileServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFileService), 0, (GInstanceInitFunc) synapse_desktop_file_service_instance_init, NULL };
	GType synapse_desktop_file_service_type_id;
	synapse_desktop_file_service_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFileService", &g_define_type_info, 0);
	SynapseDesktopFileService_private_offset = g_type_add_instance_private (synapse_desktop_file_service_type_id, sizeof (SynapseDesktopFileServicePrivate));
	return synapse_desktop_file_service_type_id;
}

GType
synapse_desktop_file_service_get_type (void)
{
	static volatile gsize synapse_desktop_file_service_type_id__once = 0;
	if (g_once_init_enter (&synapse_desktop_file_service_type_id__once)) {
		GType synapse_desktop_file_service_type_id;
		synapse_desktop_file_service_type_id = synapse_desktop_file_service_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_service_type_id__once, synapse_desktop_file_service_type_id);
	}
	return synapse_desktop_file_service_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

