/* TodayEventMonitor.c generated by valac 0.56.17, the Vala compiler
 * generated from TodayEventMonitor.vala, do not modify */

/*
 * Copyright 2021 elementary, Inc. (https://elementary.io)
 *           2014 Corentin Noël <corentin@elementary.io>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gee.h>
#include <libecal/libecal.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "elementary-calendar.h"
#include <libedataserver/libedataserver.h>
#include <libical-glib/libical-glib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <granite.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CALENDAR_TYPE_TODAY_EVENT_MONITOR (calendar_today_event_monitor_get_type ())
#define CALENDAR_TODAY_EVENT_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALENDAR_TYPE_TODAY_EVENT_MONITOR, CalendarTodayEventMonitor))
#define CALENDAR_TODAY_EVENT_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALENDAR_TYPE_TODAY_EVENT_MONITOR, CalendarTodayEventMonitorClass))
#define CALENDAR_IS_TODAY_EVENT_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALENDAR_TYPE_TODAY_EVENT_MONITOR))
#define CALENDAR_IS_TODAY_EVENT_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALENDAR_TYPE_TODAY_EVENT_MONITOR))
#define CALENDAR_TODAY_EVENT_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALENDAR_TYPE_TODAY_EVENT_MONITOR, CalendarTodayEventMonitorClass))

typedef struct _CalendarTodayEventMonitor CalendarTodayEventMonitor;
typedef struct _CalendarTodayEventMonitorClass CalendarTodayEventMonitorClass;
typedef struct _CalendarTodayEventMonitorPrivate CalendarTodayEventMonitorPrivate;
enum  {
	CALENDAR_TODAY_EVENT_MONITOR_0_PROPERTY,
	CALENDAR_TODAY_EVENT_MONITOR_NUM_PROPERTIES
};
static GParamSpec* calendar_today_event_monitor_properties[CALENDAR_TODAY_EVENT_MONITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_ECalComponentAlarmTrigger_free0(var) ((var == NULL) ? NULL : (var = (_vala_ECalComponentAlarmTrigger_free (var), NULL)))
#define __vala_ECalComponentAlarm_free0(var) ((var == NULL) ? NULL : (var = (_vala_ECalComponentAlarm_free (var), NULL)))
typedef struct _Block8Data Block8Data;
typedef struct _CalendarTodayEventMonitorAddTimeoutData CalendarTodayEventMonitorAddTimeoutData;

struct _CalendarTodayEventMonitor {
	GObject parent_instance;
	CalendarTodayEventMonitorPrivate * priv;
};

struct _CalendarTodayEventMonitorClass {
	GObjectClass parent_class;
};

struct _CalendarTodayEventMonitorPrivate {
	GeeHashMultiMap* event_uids;
};

struct _Block5Data {
	int _ref_count_;
	CalendarTodayEventMonitor* self;
	ESource* source;
	GeeCollection* events;
};

struct _Block6Data {
	int _ref_count_;
	CalendarTodayEventMonitor* self;
	ESource* source;
	GeeCollection* events;
};

struct _Block7Data {
	int _ref_count_;
	CalendarTodayEventMonitor* self;
	ESource* source;
	GeeCollection* events;
};

struct _Block8Data {
	int _ref_count_;
	CalendarTodayEventMonitor* self;
	gchar* uid;
	ESource* source;
	ECalComponent* event;
	gpointer _async_data_;
};

struct _CalendarTodayEventMonitorAddTimeoutData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	CalendarTodayEventMonitor* self;
	ESource* source;
	ECalComponent* event;
	guint interval;
	Block8Data* _data8_;
	gchar* _tmp0_;
	GeeHashMultiMap* _tmp1_;
};

static gint CalendarTodayEventMonitor_private_offset;
static gpointer calendar_today_event_monitor_parent_class = NULL;

VALA_EXTERN GType calendar_today_event_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CalendarTodayEventMonitor, g_object_unref)
static void calendar_today_event_monitor_load_today_events (CalendarTodayEventMonitor* self);
static void calendar_today_event_monitor_on_events_added (CalendarTodayEventMonitor* self,
                                                   ESource* source,
                                                   GeeCollection* events);
static void _calendar_today_event_monitor_on_events_added_calendar_event_store_events_added (CalendarEventStore* _sender,
                                                                                      ESource* source,
                                                                                      GeeCollection* events,
                                                                                      gpointer self);
static void calendar_today_event_monitor_on_events_updated (CalendarTodayEventMonitor* self,
                                                     ESource* source,
                                                     GeeCollection* events);
static void _calendar_today_event_monitor_on_events_updated_calendar_event_store_events_updated (CalendarEventStore* _sender,
                                                                                          ESource* source,
                                                                                          GeeCollection* events,
                                                                                          gpointer self);
static void calendar_today_event_monitor_on_events_removed (CalendarTodayEventMonitor* self,
                                                     ESource* source,
                                                     GeeCollection* events);
static void _calendar_today_event_monitor_on_events_removed_calendar_event_store_events_removed (CalendarEventStore* _sender,
                                                                                          ESource* source,
                                                                                          GeeCollection* events,
                                                                                          gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda197_ (Block5Data* _data5_);
static void calendar_today_event_monitor_add_event (CalendarTodayEventMonitor* self,
                                             ESource* source,
                                             ECalComponent* event);
static gboolean ___lambda197__gsource_func (gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean __lambda199_ (Block6Data* _data6_);
static void calendar_today_event_monitor_update_event (CalendarTodayEventMonitor* self,
                                                ESource* source,
                                                ECalComponent* event);
static gboolean ___lambda199__gsource_func (gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gboolean __lambda200_ (Block7Data* _data7_);
static void calendar_today_event_monitor_remove_event (CalendarTodayEventMonitor* self,
                                                ESource* source,
                                                ECalComponent* event);
static gboolean ___lambda200__gsource_func (gpointer self);
static ECalComponentAlarmTrigger* _vala_ECalComponentAlarmTrigger_copy (ECalComponentAlarmTrigger* self);
static void _vala_ECalComponentAlarmTrigger_free (ECalComponentAlarmTrigger* self);
static void _vala_ECalComponentAlarm_free (ECalComponentAlarm* self);
static GTimeSpan calendar_today_event_monitor_time_until_now (CalendarTodayEventMonitor* self,
                                                       GDateTime* dt);
VALA_EXTERN void calendar_today_event_monitor_add_timeout (CalendarTodayEventMonitor* self,
                                               ESource* source,
                                               ECalComponent* event,
                                               guint interval,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
VALA_EXTERN void calendar_today_event_monitor_add_timeout_finish (CalendarTodayEventMonitor* self,
                                                      GAsyncResult* _res_);
static void _g_free0_ (gpointer var);
static inline void _g_slist_free__g_free0_ (GSList* self);
static void calendar_today_event_monitor_add_timeout_data_free (gpointer _data);
static gboolean calendar_today_event_monitor_add_timeout_co (CalendarTodayEventMonitorAddTimeoutData* _data_);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static gboolean __lambda198_ (Block8Data* _data8_);
VALA_EXTERN void calendar_today_event_monitor_send_event_notification (CalendarTodayEventMonitor* self,
                                                           ECalComponent* event,
                                                           const gchar* uid);
static gboolean ___lambda198__gsource_func (gpointer self);
VALA_EXTERN CalendarTodayEventMonitor* calendar_today_event_monitor_new (void);
VALA_EXTERN CalendarTodayEventMonitor* calendar_today_event_monitor_construct (GType object_type);
static GObject * calendar_today_event_monitor_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static gboolean _calendar_today_event_monitor___lambda201_ (CalendarTodayEventMonitor* self);
static gboolean __calendar_today_event_monitor___lambda201__gsource_func (gpointer self);
static void calendar_today_event_monitor_finalize (GObject * obj);
static GType calendar_today_event_monitor_get_type_once (void);

static inline gpointer
calendar_today_event_monitor_get_instance_private (CalendarTodayEventMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, CalendarTodayEventMonitor_private_offset);
}

static void
_calendar_today_event_monitor_on_events_added_calendar_event_store_events_added (CalendarEventStore* _sender,
                                                                                 ESource* source,
                                                                                 GeeCollection* events,
                                                                                 gpointer self)
{
	calendar_today_event_monitor_on_events_added ((CalendarTodayEventMonitor*) self, source, events);
}

static void
_calendar_today_event_monitor_on_events_updated_calendar_event_store_events_updated (CalendarEventStore* _sender,
                                                                                     ESource* source,
                                                                                     GeeCollection* events,
                                                                                     gpointer self)
{
	calendar_today_event_monitor_on_events_updated ((CalendarTodayEventMonitor*) self, source, events);
}

static void
_calendar_today_event_monitor_on_events_removed_calendar_event_store_events_removed (CalendarEventStore* _sender,
                                                                                     ESource* source,
                                                                                     GeeCollection* events,
                                                                                     gpointer self)
{
	calendar_today_event_monitor_on_events_removed ((CalendarTodayEventMonitor*) self, source, events);
}

static void
calendar_today_event_monitor_load_today_events (CalendarTodayEventMonitor* self)
{
	GeeHashMultiMap* _tmp0_;
	CalendarEventStore* model = NULL;
	CalendarEventStore* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_multi_map_new (e_cal_component_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->event_uids);
	self->priv->event_uids = _tmp0_;
	_tmp1_ = calendar_event_store_new ();
	model = _tmp1_;
	g_signal_connect_object (model, "events-added", (GCallback) _calendar_today_event_monitor_on_events_added_calendar_event_store_events_added, self, 0);
	g_signal_connect_object (model, "events-updated", (GCallback) _calendar_today_event_monitor_on_events_updated_calendar_event_store_events_updated, self, 0);
	g_signal_connect_object (model, "events-removed", (GCallback) _calendar_today_event_monitor_on_events_removed_calendar_event_store_events_removed, self, 0);
	_tmp2_ = g_date_time_new_now_local ();
	_tmp3_ = calendar_util_datetime_get_start_of_month (_tmp2_);
	_tmp4_ = _tmp3_;
	calendar_event_store_set_month_start (model, _tmp4_);
	_g_date_time_unref0 (_tmp4_);
	_g_object_unref0 (model);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		CalendarTodayEventMonitor* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->source);
		_g_object_unref0 (_data5_->events);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
__lambda197_ (Block5Data* _data5_)
{
	CalendarTodayEventMonitor* self;
	gboolean result;
	self = _data5_->self;
	{
		GeeIterator* _event_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) _data5_->events);
		_event_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			ECalComponent* event = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			ECalComponent* _tmp4_;
			_tmp1_ = _event_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _event_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			event = (ECalComponent*) _tmp3_;
			_tmp4_ = event;
			calendar_today_event_monitor_add_event (self, _data5_->source, _tmp4_);
			_g_object_unref0 (event);
		}
		_g_object_unref0 (_event_it);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda197__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda197_ (self);
	return result;
}

static void
calendar_today_event_monitor_on_events_added (CalendarTodayEventMonitor* self,
                                              ESource* source,
                                              GeeCollection* events)
{
	Block5Data* _data5_;
	ESource* _tmp0_;
	GeeCollection* _tmp1_;
	ESourceAlarms* extension = NULL;
	ESourceExtension* _tmp2_;
	ESourceAlarms* _tmp3_;
	ESourceAlarms* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (events != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data5_->source);
	_data5_->source = _tmp0_;
	_tmp1_ = _g_object_ref0 (events);
	_g_object_unref0 (_data5_->events);
	_data5_->events = _tmp1_;
	_tmp2_ = e_source_get_extension (_data5_->source, E_SOURCE_EXTENSION_ALARMS);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, e_source_alarms_get_type (), ESourceAlarms));
	extension = _tmp3_;
	_tmp4_ = extension;
	if (e_source_alarms_get_include_me (_tmp4_) == FALSE) {
		_g_object_unref0 (extension);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda197__gsource_func, block5_data_ref (_data5_), block5_data_unref);
	_g_object_unref0 (extension);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		CalendarTodayEventMonitor* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->source);
		_g_object_unref0 (_data6_->events);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static gboolean
__lambda199_ (Block6Data* _data6_)
{
	CalendarTodayEventMonitor* self;
	gboolean result;
	self = _data6_->self;
	{
		GeeIterator* _event_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) _data6_->events);
		_event_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			ECalComponent* event = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			ECalComponent* _tmp4_;
			_tmp1_ = _event_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _event_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			event = (ECalComponent*) _tmp3_;
			_tmp4_ = event;
			calendar_today_event_monitor_update_event (self, _data6_->source, _tmp4_);
			_g_object_unref0 (event);
		}
		_g_object_unref0 (_event_it);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda199__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda199_ (self);
	return result;
}

static void
calendar_today_event_monitor_on_events_updated (CalendarTodayEventMonitor* self,
                                                ESource* source,
                                                GeeCollection* events)
{
	Block6Data* _data6_;
	ESource* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (events != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data6_->source);
	_data6_->source = _tmp0_;
	_tmp1_ = _g_object_ref0 (events);
	_g_object_unref0 (_data6_->events);
	_data6_->events = _tmp1_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda199__gsource_func, block6_data_ref (_data6_), block6_data_unref);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		CalendarTodayEventMonitor* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->source);
		_g_object_unref0 (_data7_->events);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static gboolean
__lambda200_ (Block7Data* _data7_)
{
	CalendarTodayEventMonitor* self;
	gboolean result;
	self = _data7_->self;
	{
		GeeIterator* _event_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) _data7_->events);
		_event_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			ECalComponent* event = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			ECalComponent* _tmp4_;
			_tmp1_ = _event_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _event_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			event = (ECalComponent*) _tmp3_;
			_tmp4_ = event;
			calendar_today_event_monitor_remove_event (self, _data7_->source, _tmp4_);
			_g_object_unref0 (event);
		}
		_g_object_unref0 (_event_it);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda200__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda200_ (self);
	return result;
}

static void
calendar_today_event_monitor_on_events_removed (CalendarTodayEventMonitor* self,
                                                ESource* source,
                                                GeeCollection* events)
{
	Block7Data* _data7_;
	ESource* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (events != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data7_->source);
	_data7_->source = _tmp0_;
	_tmp1_ = _g_object_ref0 (events);
	_g_object_unref0 (_data7_->events);
	_data7_->events = _tmp1_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda200__gsource_func, block7_data_ref (_data7_), block7_data_unref);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static ECalComponentAlarmTrigger*
_vala_ECalComponentAlarmTrigger_copy (ECalComponentAlarmTrigger* self)
{
	return g_boxed_copy (e_cal_component_alarm_trigger_get_type (), self);
}

static gpointer
__vala_ECalComponentAlarmTrigger_copy0 (gpointer self)
{
	return self ? _vala_ECalComponentAlarmTrigger_copy (self) : NULL;
}

static void
_vala_ECalComponentAlarmTrigger_free (ECalComponentAlarmTrigger* self)
{
	g_boxed_free (e_cal_component_alarm_trigger_get_type (), self);
}

static void
_vala_ECalComponentAlarm_free (ECalComponentAlarm* self)
{
	g_boxed_free (e_cal_component_alarm_get_type (), self);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_slist_free__g_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
calendar_today_event_monitor_add_event (CalendarTodayEventMonitor* self,
                                        ESource* source,
                                        ECalComponent* event)
{
	ICalComponent* comp = NULL;
	ICalComponent* _tmp0_;
	ICalComponent* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	ICalComponent* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GSList* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = e_cal_component_get_icalcomponent (event);
	comp = _tmp0_;
	_tmp1_ = comp;
	_tmp2_ = i_cal_component_get_summary (_tmp1_);
	_tmp3_ = e_source_dup_display_name (source);
	_tmp4_ = _tmp3_;
	_tmp5_ = comp;
	_tmp6_ = i_cal_component_get_uid (_tmp5_);
	_tmp7_ = g_strdup_printf ("Event [%s, %s, %s]", _tmp2_, _tmp4_, _tmp6_);
	_tmp8_ = _tmp7_;
	g_debug ("TodayEventMonitor.vala:75: %s", _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp4_);
	_tmp9_ = e_cal_component_get_alarm_uids (event);
	{
		GSList* alarm_uid_collection = NULL;
		GSList* alarm_uid_it = NULL;
		alarm_uid_collection = _tmp9_;
		for (alarm_uid_it = alarm_uid_collection; alarm_uid_it != NULL; alarm_uid_it = alarm_uid_it->next) {
			gchar* _tmp10_;
			gchar* alarm_uid = NULL;
			_tmp10_ = g_strdup ((const gchar*) alarm_uid_it->data);
			alarm_uid = _tmp10_;
			{
				ECalComponentAlarm* e_alarm = NULL;
				const gchar* _tmp11_;
				ECalComponentAlarm* _tmp12_;
				ECalComponentAlarmAction action = 0;
				ECalComponentAlarm* _tmp13_;
				_tmp11_ = alarm_uid;
				_tmp12_ = e_cal_component_get_alarm (event, _tmp11_);
				e_alarm = _tmp12_;
				_tmp13_ = e_alarm;
				action = e_cal_component_alarm_get_action (_tmp13_);
				if (action == E_CAL_COMPONENT_ALARM_DISPLAY) {
					ECalComponentAlarmTrigger* trigger = NULL;
					ECalComponentAlarm* _tmp14_;
					ECalComponentAlarmTrigger* _tmp15_;
					ECalComponentAlarmTrigger* _tmp16_;
					ECalComponentAlarmTrigger* _tmp17_;
					_tmp14_ = e_alarm;
					_tmp15_ = e_cal_component_alarm_get_trigger (_tmp14_);
					_tmp16_ = __vala_ECalComponentAlarmTrigger_copy0 (_tmp15_);
					__vala_ECalComponentAlarmTrigger_free0 (trigger);
					trigger = _tmp16_;
					_tmp17_ = trigger;
					if (e_cal_component_alarm_trigger_get_kind (_tmp17_) == E_CAL_COMPONENT_ALARM_TRIGGER_RELATIVE_START) {
						ICalDuration* duration = NULL;
						ECalComponentAlarmTrigger* _tmp18_;
						ICalDuration* _tmp19_;
						ICalDuration* _tmp20_;
						GDateTime* start_time = NULL;
						ICalComponent* _tmp21_;
						ICalTime* _tmp22_;
						ICalTime* _tmp23_;
						GDateTime* _tmp24_;
						GDateTime* _tmp25_;
						GDateTime* now = NULL;
						GDateTime* _tmp26_;
						GDateTime* _tmp27_;
						GDateTime* _tmp28_;
						GDateTime* _tmp29_;
						ICalDuration* _tmp30_;
						GDateTime* _tmp31_;
						GDateTime* _tmp32_;
						ICalDuration* _tmp33_;
						GDateTime* _tmp34_;
						GDateTime* _tmp35_;
						ICalDuration* _tmp36_;
						GDateTime* _tmp37_;
						GDateTime* _tmp38_;
						ICalDuration* _tmp39_;
						GDateTime* _tmp40_;
						GDateTime* _tmp41_;
						ICalDuration* _tmp42_;
						GDateTime* _tmp43_;
						gboolean _tmp44_ = FALSE;
						GDateTime* _tmp45_;
						GDateTime* _tmp46_;
						_tmp18_ = trigger;
						_tmp19_ = e_cal_component_alarm_trigger_get_duration (_tmp18_);
						_tmp20_ = _g_object_ref0 (_tmp19_);
						duration = _tmp20_;
						_tmp21_ = comp;
						_tmp22_ = i_cal_component_get_dtstart (_tmp21_);
						_tmp23_ = _tmp22_;
						_tmp24_ = calendar_util_icaltime_to_datetime (_tmp23_);
						_tmp25_ = _tmp24_;
						_g_object_unref0 (_tmp23_);
						start_time = _tmp25_;
						_tmp26_ = g_date_time_new_now_local ();
						now = _tmp26_;
						_tmp27_ = now;
						_tmp28_ = start_time;
						if (g_date_time_compare (_tmp27_, _tmp28_) > 0) {
							_g_date_time_unref0 (now);
							_g_date_time_unref0 (start_time);
							_g_object_unref0 (duration);
							__vala_ECalComponentAlarmTrigger_free0 (trigger);
							__vala_ECalComponentAlarm_free0 (e_alarm);
							_g_free0 (alarm_uid);
							continue;
						}
						_tmp29_ = start_time;
						_tmp30_ = duration;
						_tmp31_ = g_date_time_add_weeks (_tmp29_, -((gint) i_cal_duration_get_weeks (_tmp30_)));
						_g_date_time_unref0 (start_time);
						start_time = _tmp31_;
						_tmp32_ = start_time;
						_tmp33_ = duration;
						_tmp34_ = g_date_time_add_days (_tmp32_, -((gint) i_cal_duration_get_days (_tmp33_)));
						_g_date_time_unref0 (start_time);
						start_time = _tmp34_;
						_tmp35_ = start_time;
						_tmp36_ = duration;
						_tmp37_ = g_date_time_add_hours (_tmp35_, -((gint) i_cal_duration_get_hours (_tmp36_)));
						_g_date_time_unref0 (start_time);
						start_time = _tmp37_;
						_tmp38_ = start_time;
						_tmp39_ = duration;
						_tmp40_ = g_date_time_add_minutes (_tmp38_, -((gint) i_cal_duration_get_minutes (_tmp39_)));
						_g_date_time_unref0 (start_time);
						start_time = _tmp40_;
						_tmp41_ = start_time;
						_tmp42_ = duration;
						_tmp43_ = g_date_time_add_seconds (_tmp41_, (gdouble) (-((gint) i_cal_duration_get_seconds (_tmp42_))));
						_g_date_time_unref0 (start_time);
						start_time = _tmp43_;
						_tmp45_ = start_time;
						_tmp46_ = now;
						if (g_date_time_get_year (_tmp45_) == g_date_time_get_year (_tmp46_)) {
							GDateTime* _tmp47_;
							GDateTime* _tmp48_;
							_tmp47_ = start_time;
							_tmp48_ = now;
							_tmp44_ = g_date_time_get_day_of_year (_tmp47_) == g_date_time_get_day_of_year (_tmp48_);
						} else {
							_tmp44_ = FALSE;
						}
						if (_tmp44_) {
							GTimeSpan time = 0LL;
							GDateTime* _tmp49_;
							_tmp49_ = start_time;
							time = calendar_today_event_monitor_time_until_now (self, _tmp49_);
							if (time >= ((GTimeSpan) 0)) {
								calendar_today_event_monitor_add_timeout (self, source, event, (guint) time, NULL, NULL);
							}
						}
						_g_date_time_unref0 (now);
						_g_date_time_unref0 (start_time);
						_g_object_unref0 (duration);
					}
					__vala_ECalComponentAlarmTrigger_free0 (trigger);
				} else {
					ICalComponent* _tmp50_;
					const gchar* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					ICalComponent* _tmp54_;
					const gchar* _tmp55_;
					GEnumValue* _tmp56_;
					_tmp50_ = comp;
					_tmp51_ = i_cal_component_get_summary (_tmp50_);
					_tmp52_ = e_source_dup_display_name (source);
					_tmp53_ = _tmp52_;
					_tmp54_ = comp;
					_tmp55_ = i_cal_component_get_uid (_tmp54_);
					_tmp56_ = g_enum_get_value (g_type_class_ref (e_cal_component_alarm_action_get_type ()), action);
					g_warning ("TodayEventMonitor.vala:105: Event [%s, %s, %s]: Unhandled alarm action" \
": %s", _tmp51_, _tmp53_, _tmp55_, (_tmp56_ != NULL) ? _tmp56_->value_name : NULL);
					_g_free0 (_tmp53_);
				}
				__vala_ECalComponentAlarm_free0 (e_alarm);
				_g_free0 (alarm_uid);
			}
		}
		(alarm_uid_collection == NULL) ? NULL : (alarm_uid_collection = (_g_slist_free__g_free0_ (alarm_uid_collection), NULL));
	}
}

static void
calendar_today_event_monitor_add_timeout_data_free (gpointer _data)
{
	CalendarTodayEventMonitorAddTimeoutData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (CalendarTodayEventMonitorAddTimeoutData, _data_);
}

void
calendar_today_event_monitor_add_timeout (CalendarTodayEventMonitor* self,
                                          ESource* source,
                                          ECalComponent* event,
                                          guint interval,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	CalendarTodayEventMonitorAddTimeoutData* _data_;
	CalendarTodayEventMonitor* _tmp0_;
	ESource* _tmp1_;
	ECalComponent* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (event != NULL);
	_data_ = g_slice_new0 (CalendarTodayEventMonitorAddTimeoutData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, calendar_today_event_monitor_add_timeout_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (source);
	_g_object_unref0 (_data_->source);
	_data_->source = _tmp1_;
	_tmp2_ = _g_object_ref0 (event);
	_g_object_unref0 (_data_->event);
	_data_->event = _tmp2_;
	_data_->interval = interval;
	calendar_today_event_monitor_add_timeout_co (_data_);
}

void
calendar_today_event_monitor_add_timeout_finish (CalendarTodayEventMonitor* self,
                                                 GAsyncResult* _res_)
{
	CalendarTodayEventMonitorAddTimeoutData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		CalendarTodayEventMonitor* self;
		self = _data8_->self;
		_g_free0 (_data8_->uid);
		_g_object_unref0 (_data8_->source);
		_g_object_unref0 (_data8_->event);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

static gboolean
__lambda198_ (Block8Data* _data8_)
{
	CalendarTodayEventMonitor* self;
	ESourceAlarms* extension = NULL;
	ESourceExtension* _tmp0_;
	ESourceAlarms* _tmp1_;
	ESourceAlarms* _tmp2_;
	gboolean result;
	self = _data8_->self;
	_tmp0_ = e_source_get_extension (_data8_->source, E_SOURCE_EXTENSION_ALARMS);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, e_source_alarms_get_type (), ESourceAlarms));
	extension = _tmp1_;
	_tmp2_ = extension;
	if (_tmp2_ != NULL) {
		ESourceAlarms* _tmp3_;
		GDateTime* _tmp4_;
		GDateTime* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp3_ = extension;
		_tmp4_ = g_date_time_new_now_local ();
		_tmp5_ = _tmp4_;
		_tmp6_ = g_date_time_to_string (_tmp5_);
		_tmp7_ = _tmp6_;
		e_source_alarms_set_last_notified (_tmp3_, _tmp7_);
		_g_free0 (_tmp7_);
		_g_date_time_unref0 (_tmp5_);
	}
	calendar_today_event_monitor_send_event_notification (self, _data8_->event, _data8_->uid);
	result = FALSE;
	_g_object_unref0 (extension);
	return result;
}

static gboolean
___lambda198__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda198_ (self);
	return result;
}

static gboolean
calendar_today_event_monitor_add_timeout_co (CalendarTodayEventMonitorAddTimeoutData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data8_ = g_slice_new0 (Block8Data);
	_data_->_data8_->_ref_count_ = 1;
	_data_->_data8_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data8_->source);
	_data_->_data8_->source = _data_->source;
	_g_object_unref0 (_data_->_data8_->event);
	_data_->_data8_->event = _data_->event;
	_data_->_data8_->_async_data_ = _data_;
	_data_->_tmp0_ = g_strdup_printf ("%u-%u", _data_->interval, (guint) g_random_int ());
	_data_->_data8_->uid = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->event_uids;
	gee_multi_map_set ((GeeMultiMap*) _data_->_tmp1_, _data_->_data8_->event, _data_->_data8_->uid);
	g_debug ("TodayEventMonitor.vala:113: adding timeout uid:%s", _data_->_data8_->uid);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, _data_->interval, ___lambda198__gsource_func, block8_data_ref (_data_->_data8_), block8_data_unref);
	block8_data_unref (_data_->_data8_);
	_data_->_data8_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

void
calendar_today_event_monitor_send_event_notification (CalendarTodayEventMonitor* self,
                                                      ECalComponent* event,
                                                      const gchar* uid)
{
	GeeHashMultiMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	gboolean _tmp3_;
	ICalComponent* comp = NULL;
	ICalComponent* _tmp4_;
	gchar* primary_text = NULL;
	ICalComponent* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GDateTime* start_time = NULL;
	ICalComponent* _tmp8_;
	ICalTime* _tmp9_;
	ICalTime* _tmp10_;
	GDateTime* _tmp11_;
	GDateTime* _tmp12_;
	GDateTime* now = NULL;
	GDateTime* _tmp13_;
	gchar* secondary_text = NULL;
	gchar* _tmp14_;
	GSettings* h24_settings = NULL;
	GSettings* _tmp15_;
	gchar* format = NULL;
	GSettings* _tmp16_;
	gchar* _tmp17_;
	gchar* text = NULL;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	GDateTime* _tmp20_;
	GDateTime* _tmp21_;
	GNotification* notification = NULL;
	const gchar* _tmp40_;
	GNotification* _tmp41_;
	GNotification* _tmp42_;
	const gchar* _tmp43_;
	GApplication* _tmp44_;
	GNotification* _tmp45_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	g_return_if_fail (uid != NULL);
	_tmp0_ = self->priv->event_uids;
	_tmp1_ = gee_multi_map_get ((GeeMultiMap*) _tmp0_, event);
	_tmp2_ = _tmp1_;
	_tmp3_ = !gee_collection_contains (_tmp2_, uid);
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		return;
	}
	_tmp4_ = e_cal_component_get_icalcomponent (event);
	comp = _tmp4_;
	_tmp5_ = comp;
	_tmp6_ = i_cal_component_get_summary (_tmp5_);
	_tmp7_ = g_strdup_printf ("%s", _tmp6_);
	primary_text = _tmp7_;
	_tmp8_ = comp;
	_tmp9_ = i_cal_component_get_dtstart (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = calendar_util_icaltime_to_datetime (_tmp10_);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp10_);
	start_time = _tmp12_;
	_tmp13_ = g_date_time_new_now_local ();
	now = _tmp13_;
	_tmp14_ = g_strdup ("");
	secondary_text = _tmp14_;
	_tmp15_ = g_settings_new ("org.gnome.desktop.interface");
	h24_settings = _tmp15_;
	_tmp16_ = h24_settings;
	_tmp17_ = g_settings_get_string (_tmp16_, "clock-format");
	format = _tmp17_;
	_tmp18_ = format;
	_tmp19_ = granite_date_time_get_default_time_format (string_contains (_tmp18_, "12h"), FALSE);
	text = _tmp19_;
	_tmp20_ = start_time;
	_tmp21_ = now;
	if (g_date_time_get_year (_tmp20_) == g_date_time_get_year (_tmp21_)) {
		GDateTime* _tmp22_;
		GDateTime* _tmp23_;
		_tmp22_ = start_time;
		_tmp23_ = now;
		if (g_date_time_get_day_of_year (_tmp22_) == g_date_time_get_day_of_year (_tmp23_)) {
			GDateTime* _tmp24_;
			gchar* _tmp25_;
			_tmp24_ = start_time;
			_tmp25_ = granite_date_time_get_relative_datetime (_tmp24_);
			_g_free0 (secondary_text);
			secondary_text = _tmp25_;
		} else {
			GDateTime* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			const gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp26_ = start_time;
			_tmp27_ = granite_date_time_get_default_date_format (FALSE, TRUE, FALSE);
			_tmp28_ = _tmp27_;
			_tmp29_ = text;
			_tmp30_ = g_strdup_printf ("%s, %s", _tmp28_, _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_date_time_format (_tmp26_, _tmp31_);
			_g_free0 (secondary_text);
			secondary_text = _tmp32_;
			_g_free0 (_tmp31_);
			_g_free0 (_tmp28_);
		}
	} else {
		GDateTime* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		_tmp33_ = start_time;
		_tmp34_ = granite_date_time_get_default_date_format (FALSE, TRUE, TRUE);
		_tmp35_ = _tmp34_;
		_tmp36_ = text;
		_tmp37_ = g_strdup_printf ("%s, %s", _tmp35_, _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_date_time_format (_tmp33_, _tmp38_);
		_g_free0 (secondary_text);
		secondary_text = _tmp39_;
		_g_free0 (_tmp38_);
		_g_free0 (_tmp35_);
	}
	_tmp40_ = primary_text;
	_tmp41_ = g_notification_new (_tmp40_);
	notification = _tmp41_;
	_tmp42_ = notification;
	_tmp43_ = secondary_text;
	g_notification_set_body (_tmp42_, _tmp43_);
	_tmp44_ = g_application_get_default ();
	_tmp45_ = notification;
	g_application_send_notification (_tmp44_, uid, _tmp45_);
	_g_object_unref0 (notification);
	_g_free0 (text);
	_g_free0 (format);
	_g_object_unref0 (h24_settings);
	_g_free0 (secondary_text);
	_g_date_time_unref0 (now);
	_g_date_time_unref0 (start_time);
	_g_free0 (primary_text);
}

static void
calendar_today_event_monitor_update_event (CalendarTodayEventMonitor* self,
                                           ESource* source,
                                           ECalComponent* event)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (event != NULL);
	calendar_today_event_monitor_remove_event (self, source, event);
	e_cal_component_commit_sequence (event);
	calendar_today_event_monitor_add_event (self, source, event);
}

static void
calendar_today_event_monitor_remove_event (CalendarTodayEventMonitor* self,
                                           ESource* source,
                                           ECalComponent* event)
{
	GeeHashMultiMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->event_uids;
	if (gee_multi_map_contains ((GeeMultiMap*) _tmp0_, event)) {
		GeeHashMultiMap* _tmp1_;
		_tmp1_ = self->priv->event_uids;
		gee_multi_map_remove_all ((GeeMultiMap*) _tmp1_, event);
	}
}

static GTimeSpan
calendar_today_event_monitor_time_until_now (CalendarTodayEventMonitor* self,
                                             GDateTime* dt)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	GTimeSpan result;
	g_return_val_if_fail (self != NULL, 0LL);
	g_return_val_if_fail (dt != NULL, 0LL);
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	result = g_date_time_difference (dt, now) / G_TIME_SPAN_SECOND;
	_g_date_time_unref0 (now);
	return result;
}

CalendarTodayEventMonitor*
calendar_today_event_monitor_construct (GType object_type)
{
	CalendarTodayEventMonitor * self = NULL;
	self = (CalendarTodayEventMonitor*) g_object_new (object_type, NULL);
	return self;
}

CalendarTodayEventMonitor*
calendar_today_event_monitor_new (void)
{
	return calendar_today_event_monitor_construct (CALENDAR_TYPE_TODAY_EVENT_MONITOR);
}

static gboolean
_calendar_today_event_monitor___lambda201_ (CalendarTodayEventMonitor* self)
{
	GeeHashMultiMap* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->event_uids;
	gee_multi_map_clear ((GeeMultiMap*) _tmp0_);
	calendar_today_event_monitor_load_today_events (self);
	result = TRUE;
	return result;
}

static gboolean
__calendar_today_event_monitor___lambda201__gsource_func (gpointer self)
{
	gboolean result;
	result = _calendar_today_event_monitor___lambda201_ ((CalendarTodayEventMonitor*) self);
	return result;
}

static GObject *
calendar_today_event_monitor_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	static GWeakRef CalendarTodayEventMonitor_singleton__ref;
	static GMutex CalendarTodayEventMonitor_singleton__lock;
	CalendarTodayEventMonitor * self;
	g_mutex_lock (&CalendarTodayEventMonitor_singleton__lock);
	obj = g_weak_ref_get (&CalendarTodayEventMonitor_singleton__ref);
	if (obj != NULL) {
		g_mutex_unlock (&CalendarTodayEventMonitor_singleton__lock);
		return obj;
	}
	parent_class = G_OBJECT_CLASS (calendar_today_event_monitor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALENDAR_TYPE_TODAY_EVENT_MONITOR, CalendarTodayEventMonitor);
	calendar_today_event_monitor_load_today_events (self);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 86400, __calendar_today_event_monitor___lambda201__gsource_func, g_object_ref (self), g_object_unref);
	g_weak_ref_set (&CalendarTodayEventMonitor_singleton__ref, obj);
	g_mutex_unlock (&CalendarTodayEventMonitor_singleton__lock);
	return obj;
}

static void
calendar_today_event_monitor_class_init (CalendarTodayEventMonitorClass * klass,
                                         gpointer klass_data)
{
	calendar_today_event_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CalendarTodayEventMonitor_private_offset);
	G_OBJECT_CLASS (klass)->constructor = calendar_today_event_monitor_constructor;
	G_OBJECT_CLASS (klass)->finalize = calendar_today_event_monitor_finalize;
}

static void
calendar_today_event_monitor_instance_init (CalendarTodayEventMonitor * self,
                                            gpointer klass)
{
	self->priv = calendar_today_event_monitor_get_instance_private (self);
}

static void
calendar_today_event_monitor_finalize (GObject * obj)
{
	CalendarTodayEventMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALENDAR_TYPE_TODAY_EVENT_MONITOR, CalendarTodayEventMonitor);
	_g_object_unref0 (self->priv->event_uids);
	G_OBJECT_CLASS (calendar_today_event_monitor_parent_class)->finalize (obj);
}

static GType
calendar_today_event_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CalendarTodayEventMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) calendar_today_event_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CalendarTodayEventMonitor), 0, (GInstanceInitFunc) calendar_today_event_monitor_instance_init, NULL };
	GType calendar_today_event_monitor_type_id;
	calendar_today_event_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "CalendarTodayEventMonitor", &g_define_type_info, 0);
	CalendarTodayEventMonitor_private_offset = g_type_add_instance_private (calendar_today_event_monitor_type_id, sizeof (CalendarTodayEventMonitorPrivate));
	return calendar_today_event_monitor_type_id;
}

GType
calendar_today_event_monitor_get_type (void)
{
	static volatile gsize calendar_today_event_monitor_type_id__once = 0;
	if (g_once_init_enter (&calendar_today_event_monitor_type_id__once)) {
		GType calendar_today_event_monitor_type_id;
		calendar_today_event_monitor_type_id = calendar_today_event_monitor_get_type_once ();
		g_once_init_leave (&calendar_today_event_monitor_type_id__once, calendar_today_event_monitor_type_id);
	}
	return calendar_today_event_monitor_type_id__once;
}

