/* WebBackend.c generated by valac 0.56.17, the Vala compiler
 * generated from WebBackend.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*
 * Copyright 2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: LGPL-2.0
 */

#include "web.h"
#include <gmodule.h>
#include "elementary-calendar.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <libedataserver/libedataserver.h>
#include <gee.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	MAYA_WEB_BACKEND_0_PROPERTY,
	MAYA_WEB_BACKEND_NUM_PROPERTIES
};
static GParamSpec* maya_web_backend_properties[MAYA_WEB_BACKEND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_uri_unref0(var) ((var == NULL) ? NULL : (var = (g_uri_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

VALA_EXTERN MayaBackend* backend;
MayaBackend* backend = NULL;
static gpointer maya_web_backend_parent_class = NULL;
static MayaBackendIface * maya_web_backend_maya_backend_parent_iface = NULL;

static gchar* maya_web_backend_real_get_name (MayaBackend* base);
static gchar* maya_web_backend_real_get_uid (MayaBackend* base);
static GeeCollection* maya_web_backend_real_get_new_calendar_widget (MayaBackend* base,
                                                              ESource* to_edit);
static void maya_web_backend_real_add_new_calendar (MayaBackend* base,
                                             const gchar* name,
                                             const gchar* color,
                                             gboolean set_default,
                                             GeeCollection* widgets);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void maya_web_backend_real_modify_calendar (MayaBackend* base,
                                            const gchar* name,
                                            const gchar* color,
                                            gboolean set_default,
                                            GeeCollection* widgets,
                                            ESource* source);
static GType maya_web_backend_get_type_once (void);

MayaBackend*
get_backend (GModule* module)
{
	MayaWebBackend* b = NULL;
	MayaWebBackend* _tmp0_;
	MayaBackend* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("WebBackend.vala:8: Activating Web Backend");
	_tmp0_ = maya_web_backend_new ();
	b = _tmp0_;
	g_object_ref ((GObject*) b);
	result = (MayaBackend*) b;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

MayaWebBackend*
maya_web_backend_construct (GType object_type)
{
	MayaWebBackend * self = NULL;
	MayaBackend* _tmp0_;
	self = (MayaWebBackend*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 ((MayaBackend*) self);
	_g_object_unref0 (backend);
	backend = _tmp0_;
	return self;
}

MayaWebBackend*
maya_web_backend_new (void)
{
	return maya_web_backend_construct (MAYA_TYPE_WEB_BACKEND);
}

static gchar*
maya_web_backend_real_get_name (MayaBackend* base)
{
	MayaWebBackend * self;
	gchar* _tmp0_;
	gchar* result;
	self = (MayaWebBackend*) base;
	_tmp0_ = g_strdup (_ ("On the web"));
	result = _tmp0_;
	return result;
}

static gchar*
maya_web_backend_real_get_uid (MayaBackend* base)
{
	MayaWebBackend * self;
	gchar* _tmp0_;
	gchar* result;
	self = (MayaWebBackend*) base;
	_tmp0_ = g_strdup ("webcal-stub");
	result = _tmp0_;
	return result;
}

static GeeCollection*
maya_web_backend_real_get_new_calendar_widget (MayaBackend* base,
                                               ESource* to_edit)
{
	MayaWebBackend * self;
	GeeLinkedList* collection = NULL;
	GeeLinkedList* _tmp0_;
	gboolean keep_copy = FALSE;
	GeeLinkedList* _tmp6_;
	MayaPlacementWidget* _tmp7_;
	MayaPlacementWidget* _tmp8_;
	MayaPlacementWidget* url_label = NULL;
	MayaPlacementWidget* _tmp9_;
	MayaPlacementWidget* _tmp10_;
	GtkLabel* _tmp11_ = NULL;
	MayaPlacementWidget* _tmp12_;
	MayaPlacementWidget* _tmp13_;
	MayaPlacementWidget* _tmp14_;
	gchar* _tmp15_;
	GeeLinkedList* _tmp16_;
	MayaPlacementWidget* _tmp17_;
	MayaPlacementWidget* url_entry = NULL;
	MayaPlacementWidget* _tmp18_;
	MayaPlacementWidget* _tmp19_;
	gchar* _tmp20_;
	GtkEntry* _tmp21_ = NULL;
	MayaPlacementWidget* _tmp22_;
	MayaPlacementWidget* _tmp23_;
	MayaPlacementWidget* _tmp24_;
	gchar* _tmp25_;
	MayaPlacementWidget* _tmp26_;
	GeeLinkedList* _tmp27_;
	MayaPlacementWidget* _tmp28_;
	GeeCollection* result;
	self = (MayaWebBackend*) base;
	_tmp0_ = gee_linked_list_new (MAYA_TYPE_PLACEMENT_WIDGET, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	collection = _tmp0_;
	keep_copy = FALSE;
	if (to_edit != NULL) {
		ESourceOffline* source_offline = NULL;
		ESourceExtension* _tmp1_;
		ESourceOffline* _tmp2_;
		ESourceOffline* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp1_ = e_source_get_extension (to_edit, E_SOURCE_EXTENSION_OFFLINE);
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, e_source_offline_get_type (), ESourceOffline));
		source_offline = _tmp2_;
		_tmp3_ = source_offline;
		_tmp4_ = e_source_offline_get_stay_synchronized (_tmp3_);
		_tmp5_ = _tmp4_;
		keep_copy = _tmp5_;
		_g_object_unref0 (source_offline);
	}
	_tmp6_ = collection;
	_tmp7_ = maya_default_placement_widgets_get_keep_copy (0, keep_copy);
	_tmp8_ = _tmp7_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = maya_placement_widget_new ();
	url_label = _tmp9_;
	_tmp10_ = url_label;
	_tmp11_ = (GtkLabel*) gtk_label_new (_ ("URL:"));
	gtk_widget_set_hexpand ((GtkWidget*) _tmp11_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp11_, TRUE);
	gtk_label_set_xalign (_tmp11_, 1.0f);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (_tmp10_->widget);
	_tmp10_->widget = (GtkWidget*) _tmp11_;
	_tmp12_ = url_label;
	_tmp12_->row = 1;
	_tmp13_ = url_label;
	_tmp13_->column = 0;
	_tmp14_ = url_label;
	_tmp15_ = g_strdup ("url_label");
	_g_free0 (_tmp14_->ref_name);
	_tmp14_->ref_name = _tmp15_;
	_tmp16_ = collection;
	_tmp17_ = url_label;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
	_tmp18_ = maya_placement_widget_new ();
	url_entry = _tmp18_;
	_tmp19_ = url_entry;
	_tmp20_ = g_strdup ("https://example.com");
	_tmp21_ = (GtkEntry*) gtk_entry_new ();
	gtk_entry_set_placeholder_text (_tmp21_, _tmp20_);
	_g_free0 (_tmp20_);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (_tmp19_->widget);
	_tmp19_->widget = (GtkWidget*) _tmp21_;
	_tmp22_ = url_entry;
	_tmp22_->row = 1;
	_tmp23_ = url_entry;
	_tmp23_->column = 1;
	_tmp24_ = url_entry;
	_tmp25_ = g_strdup ("url_entry");
	_g_free0 (_tmp24_->ref_name);
	_tmp24_->ref_name = _tmp25_;
	_tmp26_ = url_entry;
	_tmp26_->needed = TRUE;
	_tmp27_ = collection;
	_tmp28_ = url_entry;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp28_);
	if (to_edit != NULL) {
		ESourceWebdav* webdav = NULL;
		ESourceExtension* _tmp29_;
		ESourceWebdav* _tmp30_;
		GUri* uri = NULL;
		ESourceWebdav* _tmp31_;
		GUri* _tmp32_;
		GUri* _tmp33_;
		_tmp29_ = e_source_get_extension (to_edit, E_SOURCE_EXTENSION_WEBDAV_BACKEND);
		_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, e_source_webdav_get_type (), ESourceWebdav));
		webdav = _tmp30_;
		_tmp31_ = webdav;
		_tmp32_ = e_source_webdav_dup_uri (_tmp31_);
		uri = _tmp32_;
		_tmp33_ = uri;
		if (g_uri_get_port (_tmp33_) != 80) {
			MayaPlacementWidget* _tmp34_;
			GtkWidget* _tmp35_;
			GUri* _tmp36_;
			const gchar* _tmp37_;
			GUri* _tmp38_;
			const gchar* _tmp39_;
			GUri* _tmp40_;
			GUri* _tmp41_;
			const gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			_tmp34_ = url_entry;
			_tmp35_ = _tmp34_->widget;
			_tmp36_ = uri;
			_tmp37_ = g_uri_get_scheme (_tmp36_);
			_tmp38_ = uri;
			_tmp39_ = g_uri_get_host (_tmp38_);
			_tmp40_ = uri;
			_tmp41_ = uri;
			_tmp42_ = g_uri_get_path (_tmp41_);
			_tmp43_ = g_strdup_printf ("%s://%s:%u%s", _tmp37_, _tmp39_, (guint) g_uri_get_port (_tmp40_), _tmp42_);
			_tmp44_ = _tmp43_;
			gtk_entry_set_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_entry_get_type (), GtkEntry), _tmp44_);
			_g_free0 (_tmp44_);
		} else {
			MayaPlacementWidget* _tmp45_;
			GtkWidget* _tmp46_;
			GUri* _tmp47_;
			const gchar* _tmp48_;
			GUri* _tmp49_;
			const gchar* _tmp50_;
			GUri* _tmp51_;
			const gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			_tmp45_ = url_entry;
			_tmp46_ = _tmp45_->widget;
			_tmp47_ = uri;
			_tmp48_ = g_uri_get_scheme (_tmp47_);
			_tmp49_ = uri;
			_tmp50_ = g_uri_get_host (_tmp49_);
			_tmp51_ = uri;
			_tmp52_ = g_uri_get_path (_tmp51_);
			_tmp53_ = g_strdup_printf ("%s://%s%s", _tmp48_, _tmp50_, _tmp52_);
			_tmp54_ = _tmp53_;
			gtk_entry_set_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, gtk_entry_get_type (), GtkEntry), _tmp54_);
			_g_free0 (_tmp54_);
		}
		_g_uri_unref0 (uri);
		_g_object_unref0 (webdav);
	}
	result = (GeeCollection*) collection;
	_g_object_unref0 (url_entry);
	_g_object_unref0 (url_label);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
maya_web_backend_real_add_new_calendar (MayaBackend* base,
                                        const gchar* name,
                                        const gchar* color,
                                        gboolean set_default,
                                        GeeCollection* widgets)
{
	MayaWebBackend * self;
	GError* _inner_error0_ = NULL;
	self = (MayaWebBackend*) base;
	g_return_if_fail (name != NULL);
	g_return_if_fail (color != NULL);
	g_return_if_fail (widgets != NULL);
	{
		ESource* new_source = NULL;
		gchar* _tmp0_;
		ESource* _tmp1_ = NULL;
		ESource* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		ESourceCalendar* cal = NULL;
		ESource* _tmp5_;
		ESourceExtension* _tmp6_;
		ESourceCalendar* _tmp7_;
		ESourceCalendar* _tmp8_;
		ESourceCalendar* _tmp9_;
		ESourceWebdav* webdav = NULL;
		ESource* _tmp10_;
		ESourceExtension* _tmp11_;
		ESourceWebdav* _tmp12_;
		ESource* _tmp13_;
		ESourceOffline* offline = NULL;
		ESource* _tmp14_;
		ESourceExtension* _tmp15_;
		ESourceOffline* _tmp16_;
		CalendarEventStore* calmodel = NULL;
		CalendarEventStore* _tmp38_;
		ESourceRegistry* registry = NULL;
		CalendarEventStore* _tmp39_;
		ESourceRegistry* _tmp40_;
		ESourceRegistry* _tmp41_;
		ESourceRegistry* _tmp42_;
		GList* list = NULL;
		ESource* _tmp43_;
		ESource* _tmp44_;
		ESourceRegistry* _tmp45_;
		GList* _tmp46_;
		CalendarEventStore* _tmp47_;
		ESource* _tmp48_;
		_tmp0_ = g_strdup (name);
		_tmp1_ = e_source_new (NULL, NULL, &_inner_error0_);
		e_source_set_display_name (_tmp1_, _tmp0_);
		_g_free0 (_tmp0_);
		new_source = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = new_source;
		_tmp3_ = maya_backend_get_uid ((MayaBackend*) self);
		_tmp4_ = _tmp3_;
		e_source_set_parent (_tmp2_, _tmp4_);
		_g_free0 (_tmp4_);
		_tmp5_ = new_source;
		_tmp6_ = e_source_get_extension (_tmp5_, E_SOURCE_EXTENSION_CALENDAR);
		_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, e_source_calendar_get_type (), ESourceCalendar));
		cal = _tmp7_;
		_tmp8_ = cal;
		e_source_selectable_set_color ((ESourceSelectable*) _tmp8_, color);
		_tmp9_ = cal;
		e_source_backend_set_backend_name ((ESourceBackend*) _tmp9_, "webcal");
		_tmp10_ = new_source;
		_tmp11_ = e_source_get_extension (_tmp10_, E_SOURCE_EXTENSION_WEBDAV_BACKEND);
		_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, e_source_webdav_get_type (), ESourceWebdav));
		webdav = _tmp12_;
		_tmp13_ = new_source;
		e_source_get_extension (_tmp13_, E_SOURCE_EXTENSION_AUTHENTICATION);
		_tmp14_ = new_source;
		_tmp15_ = e_source_get_extension (_tmp14_, E_SOURCE_EXTENSION_OFFLINE);
		_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, e_source_offline_get_type (), ESourceOffline));
		offline = _tmp16_;
		{
			GeeIterator* _widget_it = NULL;
			GeeIterator* _tmp17_;
			_tmp17_ = gee_iterable_iterator ((GeeIterable*) widgets);
			_widget_it = _tmp17_;
			while (TRUE) {
				GeeIterator* _tmp18_;
				MayaPlacementWidget* widget = NULL;
				GeeIterator* _tmp19_;
				gpointer _tmp20_;
				MayaPlacementWidget* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				GQuark _tmp25_ = 0U;
				static GQuark _tmp24_label0 = 0;
				static GQuark _tmp24_label1 = 0;
				_tmp18_ = _widget_it;
				if (!gee_iterator_next (_tmp18_)) {
					break;
				}
				_tmp19_ = _widget_it;
				_tmp20_ = gee_iterator_get (_tmp19_);
				widget = (MayaPlacementWidget*) _tmp20_;
				_tmp21_ = widget;
				_tmp22_ = _tmp21_->ref_name;
				_tmp23_ = _tmp22_;
				_tmp25_ = (NULL == _tmp23_) ? 0 : g_quark_from_string (_tmp23_);
				if (_tmp25_ == ((0 != _tmp24_label0) ? _tmp24_label0 : (_tmp24_label0 = g_quark_from_static_string ("url_entry")))) {
					switch (0) {
						default:
						{
							GUri* _tmp26_ = NULL;
							MayaPlacementWidget* _tmp27_;
							GtkWidget* _tmp28_;
							const gchar* _tmp29_;
							const gchar* _tmp30_;
							GUri* _tmp31_;
							ESourceWebdav* _tmp32_;
							_tmp27_ = widget;
							_tmp28_ = _tmp27_->widget;
							_tmp29_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_entry_get_type (), GtkEntry));
							_tmp30_ = _tmp29_;
							_tmp31_ = g_uri_parse (_tmp30_, G_URI_FLAGS_NONE, &_inner_error0_);
							_tmp26_ = _tmp31_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_object_unref0 (widget);
								_g_object_unref0 (_widget_it);
								_g_object_unref0 (offline);
								_g_object_unref0 (webdav);
								_g_object_unref0 (cal);
								_g_object_unref0 (new_source);
								goto __catch0_g_error;
							}
							_tmp32_ = webdav;
							g_object_set (_tmp32_, "uri", _tmp26_, NULL);
							_g_uri_unref0 (_tmp26_);
							break;
						}
					}
				} else if (_tmp25_ == ((0 != _tmp24_label1) ? _tmp24_label1 : (_tmp24_label1 = g_quark_from_static_string ("keep_copy")))) {
					switch (0) {
						default:
						{
							ESourceOffline* _tmp33_;
							MayaPlacementWidget* _tmp34_;
							GtkWidget* _tmp35_;
							gboolean _tmp36_;
							gboolean _tmp37_;
							_tmp33_ = offline;
							_tmp34_ = widget;
							_tmp35_ = _tmp34_->widget;
							_tmp36_ = gtk_toggle_button_get_active ((GtkToggleButton*) G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_check_button_get_type (), GtkCheckButton));
							_tmp37_ = _tmp36_;
							e_source_offline_set_stay_synchronized (_tmp33_, _tmp37_);
							break;
						}
					}
				}
				_g_object_unref0 (widget);
			}
			_g_object_unref0 (_widget_it);
		}
		_tmp38_ = calendar_event_store_get_default ();
		calmodel = _tmp38_;
		_tmp39_ = calmodel;
		_tmp40_ = calendar_event_store_get_registry (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = _g_object_ref0 (_tmp41_);
		registry = _tmp42_;
		list = NULL;
		_tmp43_ = new_source;
		_tmp44_ = _g_object_ref0 (_tmp43_);
		list = g_list_append (list, _tmp44_);
		_tmp45_ = registry;
		_tmp46_ = list;
		e_source_registry_create_sources_sync (_tmp45_, _tmp46_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
			_g_object_unref0 (registry);
			_g_object_unref0 (calmodel);
			_g_object_unref0 (offline);
			_g_object_unref0 (webdav);
			_g_object_unref0 (cal);
			_g_object_unref0 (new_source);
			goto __catch0_g_error;
		}
		_tmp47_ = calmodel;
		_tmp48_ = new_source;
		calendar_event_store_add_source (_tmp47_, _tmp48_);
		if (set_default) {
			ESourceRegistry* _tmp49_;
			ESource* _tmp50_;
			_tmp49_ = registry;
			_tmp50_ = new_source;
			g_object_set (_tmp49_, "default-calendar", _tmp50_, NULL);
		}
		(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
		_g_object_unref0 (registry);
		_g_object_unref0 (calmodel);
		_g_object_unref0 (offline);
		_g_object_unref0 (webdav);
		_g_object_unref0 (cal);
		_g_object_unref0 (new_source);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp51_;
		const gchar* _tmp52_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp51_ = _error_;
		_tmp52_ = _tmp51_->message;
		g_critical ("WebBackend.vala:117: %s", _tmp52_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
maya_web_backend_real_modify_calendar (MayaBackend* base,
                                       const gchar* name,
                                       const gchar* color,
                                       gboolean set_default,
                                       GeeCollection* widgets,
                                       ESource* source)
{
	MayaWebBackend * self;
	GError* _inner_error0_ = NULL;
	self = (MayaWebBackend*) base;
	g_return_if_fail (name != NULL);
	g_return_if_fail (color != NULL);
	g_return_if_fail (widgets != NULL);
	g_return_if_fail (source != NULL);
	{
		ESourceCalendar* cal = NULL;
		ESourceExtension* _tmp0_;
		ESourceCalendar* _tmp1_;
		ESourceCalendar* _tmp2_;
		ESourceWebdav* webdav = NULL;
		ESourceExtension* _tmp3_;
		ESourceWebdav* _tmp4_;
		ESourceOffline* offline = NULL;
		ESourceExtension* _tmp5_;
		ESourceOffline* _tmp6_;
		e_source_set_display_name (source, name);
		_tmp0_ = e_source_get_extension (source, E_SOURCE_EXTENSION_CALENDAR);
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, e_source_calendar_get_type (), ESourceCalendar));
		cal = _tmp1_;
		_tmp2_ = cal;
		e_source_selectable_set_color ((ESourceSelectable*) _tmp2_, color);
		_tmp3_ = e_source_get_extension (source, E_SOURCE_EXTENSION_WEBDAV_BACKEND);
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, e_source_webdav_get_type (), ESourceWebdav));
		webdav = _tmp4_;
		e_source_get_extension (source, E_SOURCE_EXTENSION_AUTHENTICATION);
		_tmp5_ = e_source_get_extension (source, E_SOURCE_EXTENSION_OFFLINE);
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, e_source_offline_get_type (), ESourceOffline));
		offline = _tmp6_;
		{
			GeeIterator* _widget_it = NULL;
			GeeIterator* _tmp7_;
			_tmp7_ = gee_iterable_iterator ((GeeIterable*) widgets);
			_widget_it = _tmp7_;
			while (TRUE) {
				GeeIterator* _tmp8_;
				MayaPlacementWidget* widget = NULL;
				GeeIterator* _tmp9_;
				gpointer _tmp10_;
				MayaPlacementWidget* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				GQuark _tmp15_ = 0U;
				static GQuark _tmp14_label0 = 0;
				static GQuark _tmp14_label1 = 0;
				_tmp8_ = _widget_it;
				if (!gee_iterator_next (_tmp8_)) {
					break;
				}
				_tmp9_ = _widget_it;
				_tmp10_ = gee_iterator_get (_tmp9_);
				widget = (MayaPlacementWidget*) _tmp10_;
				_tmp11_ = widget;
				_tmp12_ = _tmp11_->ref_name;
				_tmp13_ = _tmp12_;
				_tmp15_ = (NULL == _tmp13_) ? 0 : g_quark_from_string (_tmp13_);
				if (_tmp15_ == ((0 != _tmp14_label0) ? _tmp14_label0 : (_tmp14_label0 = g_quark_from_static_string ("url_entry")))) {
					switch (0) {
						default:
						{
							GUri* _tmp16_ = NULL;
							MayaPlacementWidget* _tmp17_;
							GtkWidget* _tmp18_;
							const gchar* _tmp19_;
							const gchar* _tmp20_;
							GUri* _tmp21_;
							ESourceWebdav* _tmp22_;
							_tmp17_ = widget;
							_tmp18_ = _tmp17_->widget;
							_tmp19_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_entry_get_type (), GtkEntry));
							_tmp20_ = _tmp19_;
							_tmp21_ = g_uri_parse (_tmp20_, G_URI_FLAGS_NONE, &_inner_error0_);
							_tmp16_ = _tmp21_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_object_unref0 (widget);
								_g_object_unref0 (_widget_it);
								_g_object_unref0 (offline);
								_g_object_unref0 (webdav);
								_g_object_unref0 (cal);
								goto __catch0_g_error;
							}
							_tmp22_ = webdav;
							g_object_set (_tmp22_, "uri", _tmp16_, NULL);
							_g_uri_unref0 (_tmp16_);
							break;
						}
					}
				} else if (_tmp15_ == ((0 != _tmp14_label1) ? _tmp14_label1 : (_tmp14_label1 = g_quark_from_static_string ("keep_copy")))) {
					switch (0) {
						default:
						{
							ESourceOffline* _tmp23_;
							MayaPlacementWidget* _tmp24_;
							GtkWidget* _tmp25_;
							gboolean _tmp26_;
							gboolean _tmp27_;
							_tmp23_ = offline;
							_tmp24_ = widget;
							_tmp25_ = _tmp24_->widget;
							_tmp26_ = gtk_toggle_button_get_active ((GtkToggleButton*) G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_check_button_get_type (), GtkCheckButton));
							_tmp27_ = _tmp26_;
							e_source_offline_set_stay_synchronized (_tmp23_, _tmp27_);
							break;
						}
					}
				}
				_g_object_unref0 (widget);
			}
			_g_object_unref0 (_widget_it);
		}
		e_source_write (source, NULL, NULL, NULL);
		if (set_default) {
			ESourceRegistry* registry = NULL;
			ESourceRegistry* _tmp28_;
			ESourceRegistry* _tmp29_;
			_tmp28_ = e_source_registry_new_sync (NULL, &_inner_error0_);
			registry = _tmp28_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (offline);
				_g_object_unref0 (webdav);
				_g_object_unref0 (cal);
				goto __catch0_g_error;
			}
			_tmp29_ = registry;
			g_object_set (_tmp29_, "default-calendar", source, NULL);
			_g_object_unref0 (registry);
		}
		_g_object_unref0 (offline);
		_g_object_unref0 (webdav);
		_g_object_unref0 (cal);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp30_ = _error_;
		_tmp31_ = _tmp30_->message;
		g_critical ("WebBackend.vala:152: %s", _tmp31_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
maya_web_backend_class_init (MayaWebBackendClass * klass,
                             gpointer klass_data)
{
	maya_web_backend_parent_class = g_type_class_peek_parent (klass);
}

static void
maya_web_backend_maya_backend_interface_init (MayaBackendIface * iface,
                                              gpointer iface_data)
{
	maya_web_backend_maya_backend_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = (gchar* (*) (MayaBackend*)) maya_web_backend_real_get_name;
	iface->get_uid = (gchar* (*) (MayaBackend*)) maya_web_backend_real_get_uid;
	iface->get_new_calendar_widget = (GeeCollection* (*) (MayaBackend*, ESource*)) maya_web_backend_real_get_new_calendar_widget;
	iface->add_new_calendar = (void (*) (MayaBackend*, const gchar*, const gchar*, gboolean, GeeCollection*)) maya_web_backend_real_add_new_calendar;
	iface->modify_calendar = (void (*) (MayaBackend*, const gchar*, const gchar*, gboolean, GeeCollection*, ESource*)) maya_web_backend_real_modify_calendar;
}

static void
maya_web_backend_instance_init (MayaWebBackend * self,
                                gpointer klass)
{
}

static GType
maya_web_backend_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaWebBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_web_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaWebBackend), 0, (GInstanceInitFunc) maya_web_backend_instance_init, NULL };
	static const GInterfaceInfo maya_backend_info = { (GInterfaceInitFunc) maya_web_backend_maya_backend_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType maya_web_backend_type_id;
	maya_web_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "MayaWebBackend", &g_define_type_info, 0);
	g_type_add_interface_static (maya_web_backend_type_id, MAYA_TYPE_BACKEND, &maya_backend_info);
	return maya_web_backend_type_id;
}

GType
maya_web_backend_get_type (void)
{
	static volatile gsize maya_web_backend_type_id__once = 0;
	if (g_once_init_enter (&maya_web_backend_type_id__once)) {
		GType maya_web_backend_type_id;
		maya_web_backend_type_id = maya_web_backend_get_type_once ();
		g_once_init_leave (&maya_web_backend_type_id__once, maya_web_backend_type_id);
	}
	return maya_web_backend_type_id__once;
}

