/* ListModel.c generated by valac 0.56.18, the Vala compiler
 * generated from ListModel.vala, do not modify */

/* Copyright 2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, Inc.,; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "pantheon-files-core.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FILES_LIST_MODEL_0_PROPERTY,
	FILES_LIST_MODEL_SHOW_HIDDEN_FILES_PROPERTY,
	FILES_LIST_MODEL_ICON_SIZE_PROPERTY,
	FILES_LIST_MODEL_HAS_CHILD_PROPERTY,
	FILES_LIST_MODEL_SORT_PENDING_PROPERTY,
	FILES_LIST_MODEL_NUM_PROPERTIES
};
static GParamSpec* files_list_model_properties[FILES_LIST_MODEL_NUM_PROPERTIES];
typedef enum  {
	FILES_LIST_MODEL_PRIV_COLUMN_ID_DUMMY = FILES_LIST_MODEL_COLUMN_ID_NUM_COLUMNS
} FilesListModelPrivColumnID;

#define FILES_LIST_MODEL_TYPE_PRIV_COLUMN_ID (files_list_model_priv_column_id_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GtkTreeIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeIter_free (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
#define __vala_GtkTreeRowReference_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeRowReference_free (var), NULL)))
typedef struct _Block16Data Block16Data;
enum  {
	FILES_LIST_MODEL_SUBDIRECTORY_UNLOADED_SIGNAL,
	FILES_LIST_MODEL_NUM_SIGNALS
};
static guint files_list_model_signals[FILES_LIST_MODEL_NUM_SIGNALS] = {0};

struct _FilesListModelPrivate {
	gboolean _show_hidden_files;
	gint _icon_size;
	gboolean _has_child;
	gboolean sort_directories_first;
	GeeTreeMap* file_treerow_map;
	guint resort_timeout_id;
	gboolean delay_resort;
};

struct _Block16Data {
	int _ref_count_;
	FilesListModel* self;
	gboolean found;
	FilesFile* file;
};

static gint FilesListModel_private_offset;
static gpointer files_list_model_parent_class = NULL;
static GtkTreeModelIface * files_list_model_gtk_tree_model_parent_iface = NULL;

static GType files_list_model_priv_column_id_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gint _____lambda4_ (FilesListModel* self);
static gint ______lambda4__gtk_tree_iter_compare_func (GtkTreeModel* model,
                                                GtkTreeIter* a,
                                                GtkTreeIter* b,
                                                gpointer self);
static gint files_list_model_file_entry_compare_func (FilesListModel* self,
                                               GtkTreeIter* a,
                                               GtkTreeIter* b);
static void _vala_GtkTreeIter_free (GtkTreeIter* self);
static GtkTreeIter* _vala_GtkTreeIter_copy (GtkTreeIter* self);
static gboolean files_list_model_get_first_iter_for_file (FilesListModel* self,
                                                   FilesFile* file,
                                                   GtkTreeIter** iter);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void _vala_GtkTreeRowReference_free (GtkTreeRowReference* self);
static void files_list_model_real_get_value (GtkTreeModel* base,
                                      GtkTreeIter* iter,
                                      gint column,
                                      GValue* value);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static gboolean __lambda7_ (Block16Data* _data16_,
                     GtkTreeModel* model,
                     GtkTreePath* path,
                     GtkTreeIter* iter);
static gboolean ___lambda7__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                                  GtkTreePath* path,
                                                  GtkTreeIter* iter,
                                                  gpointer self);
static void files_list_model_resort (FilesListModel* self);
static gboolean ___lambda8_ (FilesListModel* self);
static gboolean ____lambda8__gsource_func (gpointer self);
static GObject * files_list_model_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static GtkTreeRowReference* _vala_GtkTreeRowReference_copy (GtkTreeRowReference* self);
static void files_list_model_finalize (GObject * obj);
static GType files_list_model_get_type_once (void);
static void _vala_files_list_model_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_files_list_model_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

VALA_EXTERN const gchar* FILES_PREFERENCES_TAGS_COLORS[12];

static inline gpointer
files_list_model_get_instance_private (FilesListModel* self)
{
	return G_STRUCT_MEMBER_P (self, FilesListModel_private_offset);
}

FilesListModelColumnID
files_list_model_column_id_from_string (const gchar* column_id)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	FilesListModelColumnID result;
	g_return_val_if_fail (column_id != NULL, 0);
	_tmp0_ = column_id;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("name")))) {
		switch (0) {
			default:
			{
				result = FILES_LIST_MODEL_COLUMN_ID_FILENAME;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("size")))) {
		switch (0) {
			default:
			{
				result = FILES_LIST_MODEL_COLUMN_ID_SIZE;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("type")))) {
		switch (0) {
			default:
			{
				result = FILES_LIST_MODEL_COLUMN_ID_TYPE;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("modified")))) {
		switch (0) {
			default:
			{
				result = FILES_LIST_MODEL_COLUMN_ID_MODIFIED;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = (FilesListModelColumnID) -1;
				return result;
			}
		}
	}
}

const gchar*
files_list_model_column_id_to_string (FilesListModelColumnID self)
{
	const gchar* result;
	switch (self) {
		case FILES_LIST_MODEL_COLUMN_ID_FILENAME:
		{
			result = "name";
			return result;
		}
		case FILES_LIST_MODEL_COLUMN_ID_SIZE:
		{
			result = "size";
			return result;
		}
		case FILES_LIST_MODEL_COLUMN_ID_TYPE:
		{
			result = "type";
			return result;
		}
		case FILES_LIST_MODEL_COLUMN_ID_MODIFIED:
		{
			result = "modified";
			return result;
		}
		default:
		{
			g_critical ("ListModel.vala:56: COLUMN id %u unsupported", (guint) self);
			result = "";
			return result;
		}
	}
}

 G_GNUC_NO_INLINE static GType
files_list_model_column_id_get_type_once (void)
{
	static const GEnumValue values[] = {{FILES_LIST_MODEL_COLUMN_ID_FILE_COLUMN, "FILES_LIST_MODEL_COLUMN_ID_FILE_COLUMN", "file-column"}, {FILES_LIST_MODEL_COLUMN_ID_COLOR, "FILES_LIST_MODEL_COLUMN_ID_COLOR", "color"}, {FILES_LIST_MODEL_COLUMN_ID_PIXBUF, "FILES_LIST_MODEL_COLUMN_ID_PIXBUF", "pixbuf"}, {FILES_LIST_MODEL_COLUMN_ID_FILENAME, "FILES_LIST_MODEL_COLUMN_ID_FILENAME", "filename"}, {FILES_LIST_MODEL_COLUMN_ID_SIZE, "FILES_LIST_MODEL_COLUMN_ID_SIZE", "size"}, {FILES_LIST_MODEL_COLUMN_ID_TYPE, "FILES_LIST_MODEL_COLUMN_ID_TYPE", "type"}, {FILES_LIST_MODEL_COLUMN_ID_MODIFIED, "FILES_LIST_MODEL_COLUMN_ID_MODIFIED", "modified"}, {FILES_LIST_MODEL_COLUMN_ID_NUM_COLUMNS, "FILES_LIST_MODEL_COLUMN_ID_NUM_COLUMNS", "num-columns"}, {0, NULL, NULL}};
	GType files_list_model_column_id_type_id;
	files_list_model_column_id_type_id = g_enum_register_static ("FilesListModelColumnID", values);
	return files_list_model_column_id_type_id;
}

GType
files_list_model_column_id_get_type (void)
{
	static volatile gsize files_list_model_column_id_type_id__once = 0;
	if (g_once_init_enter (&files_list_model_column_id_type_id__once)) {
		GType files_list_model_column_id_type_id;
		files_list_model_column_id_type_id = files_list_model_column_id_get_type_once ();
		g_once_init_leave (&files_list_model_column_id_type_id__once, files_list_model_column_id_type_id);
	}
	return files_list_model_column_id_type_id__once;
}

 G_GNUC_NO_INLINE static GType
files_list_model_priv_column_id_get_type_once (void)
{
	static const GEnumValue values[] = {{FILES_LIST_MODEL_PRIV_COLUMN_ID_DUMMY, "FILES_LIST_MODEL_PRIV_COLUMN_ID_DUMMY", "dummy"}, {0, NULL, NULL}};
	GType files_list_model_priv_column_id_type_id;
	files_list_model_priv_column_id_type_id = g_enum_register_static ("FilesListModelPrivColumnID", values);
	return files_list_model_priv_column_id_type_id;
}

static GType
files_list_model_priv_column_id_get_type (void)
{
	static volatile gsize files_list_model_priv_column_id_type_id__once = 0;
	if (g_once_init_enter (&files_list_model_priv_column_id_type_id__once)) {
		GType files_list_model_priv_column_id_type_id;
		files_list_model_priv_column_id_type_id = files_list_model_priv_column_id_get_type_once ();
		g_once_init_leave (&files_list_model_priv_column_id_type_id__once, files_list_model_priv_column_id_type_id);
	}
	return files_list_model_priv_column_id_type_id__once;
}

static gint
_____lambda4_ (FilesListModel* self)
{
	gint result;
	result = 0;
	return result;
}

static gint
______lambda4__gtk_tree_iter_compare_func (GtkTreeModel* model,
                                           GtkTreeIter* a,
                                           GtkTreeIter* b,
                                           gpointer self)
{
	gint result;
	result = _____lambda4_ ((FilesListModel*) self);
	return result;
}

void
files_list_model_set_sorting_off (FilesListModel* self)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < ((gint) FILES_LIST_MODEL_COLUMN_ID_NUM_COLUMNS))) {
					break;
				}
				gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) self, i, ______lambda4__gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
			}
		}
	}
}

void
files_list_model_set_sorting_on (FilesListModel* self)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < ((gint) FILES_LIST_MODEL_COLUMN_ID_NUM_COLUMNS))) {
					break;
				}
				gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) self, i, (GtkTreeIterCompareFunc) files_list_model_file_entry_compare_func, g_object_ref (self), g_object_unref);
			}
		}
	}
}

static void
_vala_GtkTreeIter_free (GtkTreeIter* self)
{
	g_boxed_free (gtk_tree_iter_get_type (), self);
}

static GtkTreeIter*
_vala_GtkTreeIter_copy (GtkTreeIter* self)
{
	return g_boxed_copy (gtk_tree_iter_get_type (), self);
}

static gpointer
__vala_GtkTreeIter_copy0 (gpointer self)
{
	return self ? _vala_GtkTreeIter_copy (self) : NULL;
}

FilesFile*
files_list_model_file_for_path (FilesListModel* self,
                                GtkTreePath* path)
{
	FilesFile* file = NULL;
	GtkTreeIter* iter = NULL;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	GtkTreeIter _tmp2_;
	GtkTreeIter* _tmp3_;
	FilesFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	file = NULL;
	_tmp1_ = gtk_tree_model_get_iter ((GtkTreeModel*) self, &_tmp0_, path);
	__vala_GtkTreeIter_free0 (iter);
	_tmp2_ = _tmp0_;
	_tmp3_ = __vala_GtkTreeIter_copy0 (&_tmp2_);
	iter = _tmp3_;
	if (_tmp1_) {
		GtkTreeIter* _tmp4_;
		GtkTreeIter _tmp5_;
		_tmp4_ = iter;
		_tmp5_ = *_tmp4_;
		gtk_tree_model_get ((GtkTreeModel*) self, &_tmp5_, FILES_LIST_MODEL_COLUMN_ID_FILE_COLUMN, &file, -1);
	}
	result = file;
	__vala_GtkTreeIter_free0 (iter);
	return result;
}

FilesFile*
files_list_model_file_for_iter (FilesListModel* self,
                                GtkTreeIter* iter)
{
	FilesFile* file = NULL;
	GtkTreeIter _tmp0_;
	FilesFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	file = NULL;
	_tmp0_ = *iter;
	gtk_tree_model_get ((GtkTreeModel*) self, &_tmp0_, FILES_LIST_MODEL_COLUMN_ID_FILE_COLUMN, &file, -1);
	result = file;
	return result;
}

guint
files_list_model_get_length (FilesListModel* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = (guint) gtk_tree_model_iter_n_children ((GtkTreeModel*) self, NULL);
	return result;
}

GtkTreePath*
files_list_model_get_path_for_first_file (FilesListModel* self,
                                          FilesFile* file)
{
	GtkTreeIter* iter = NULL;
	GtkTreeIter* _tmp0_ = NULL;
	gboolean _tmp1_;
	GtkTreePath* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (file == NULL) {
		result = NULL;
		return result;
	}
	iter = NULL;
	_tmp1_ = files_list_model_get_first_iter_for_file (self, file, &_tmp0_);
	__vala_GtkTreeIter_free0 (iter);
	iter = _tmp0_;
	if (_tmp1_) {
		GtkTreeIter* _tmp2_;
		GtkTreeIter _tmp3_;
		GtkTreePath* _tmp4_;
		_tmp2_ = iter;
		_tmp3_ = *_tmp2_;
		_tmp4_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp3_);
		result = _tmp4_;
		__vala_GtkTreeIter_free0 (iter);
		return result;
	} else {
		result = NULL;
		__vala_GtkTreeIter_free0 (iter);
		return result;
	}
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
_vala_GtkTreeRowReference_free (GtkTreeRowReference* self)
{
	g_boxed_free (gtk_tree_row_reference_get_type (), self);
}

static gboolean
files_list_model_get_first_iter_for_file (FilesListModel* self,
                                          FilesFile* file,
                                          GtkTreeIter** iter)
{
	GtkTreeIter* _vala_iter = NULL;
	GtkTreeRowReference* row = NULL;
	GeeTreeMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gpointer _tmp3_;
	GtkTreeRowReference* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	__vala_GtkTreeIter_free0 (_vala_iter);
	_vala_iter = NULL;
	if (file == NULL) {
		result = FALSE;
		if (iter) {
			*iter = _vala_iter;
		} else {
			__vala_GtkTreeIter_free0 (_vala_iter);
		}
		return result;
	}
	_tmp0_ = self->priv->file_treerow_map;
	_tmp1_ = files_file_get_uri (file);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp2_);
	row = (GtkTreeRowReference*) _tmp3_;
	_tmp4_ = row;
	if (_tmp4_ != NULL) {
		GtkTreeRowReference* _tmp5_;
		_tmp5_ = row;
		if (gtk_tree_row_reference_valid (_tmp5_)) {
			GtkTreeRowReference* _tmp6_;
			GtkTreePath* _tmp7_;
			GtkTreePath* _tmp8_;
			GtkTreeIter _tmp9_ = {0};
			GtkTreeIter _tmp10_;
			GtkTreeIter* _tmp11_;
			_tmp6_ = row;
			_tmp7_ = gtk_tree_row_reference_get_path (_tmp6_);
			_tmp8_ = _tmp7_;
			gtk_tree_model_get_iter ((GtkTreeModel*) self, &_tmp9_, _tmp8_);
			__vala_GtkTreeIter_free0 (_vala_iter);
			_tmp10_ = _tmp9_;
			_tmp11_ = __vala_GtkTreeIter_copy0 (&_tmp10_);
			_vala_iter = _tmp11_;
			__vala_GtkTreePath_free0 (_tmp8_);
			result = TRUE;
			__vala_GtkTreeRowReference_free0 (row);
			if (iter) {
				*iter = _vala_iter;
			} else {
				__vala_GtkTreeIter_free0 (_vala_iter);
			}
			return result;
		} else {
			GeeTreeMap* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp12_ = self->priv->file_treerow_map;
			_tmp13_ = files_file_get_uri (file);
			_tmp14_ = _tmp13_;
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp12_, _tmp14_, NULL);
		}
	}
	result = FALSE;
	__vala_GtkTreeRowReference_free0 (row);
	if (iter) {
		*iter = _vala_iter;
	} else {
		__vala_GtkTreeIter_free0 (_vala_iter);
	}
	return result;
}

static void
files_list_model_real_get_value (GtkTreeModel* base,
                                 GtkTreeIter* iter,
                                 gint column,
                                 GValue* value)
{
	FilesListModel * self;
	GValue _vala_value = {0};
	GValue file_value = {0};
	GtkTreeIter _tmp0_;
	GValue _tmp1_ = {0};
	FilesFile* file = NULL;
	GObject* _tmp2_;
	self = (FilesListModel*) base;
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	files_list_model_gtk_tree_model_parent_iface->get_value ((GtkTreeModel*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_store_get_type (), GtkTreeStore), &_tmp0_, (gint) FILES_LIST_MODEL_COLUMN_ID_FILE_COLUMN, &_tmp1_);
	G_IS_VALUE (&file_value) ? (g_value_unset (&file_value), NULL) : NULL;
	file_value = _tmp1_;
	_tmp2_ = g_value_get_object (&file_value);
	file = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, FILES_TYPE_FILE, FilesFile);
	switch (column) {
		case FILES_LIST_MODEL_COLUMN_ID_FILE_COLUMN:
		{
			GValue _tmp3_ = {0};
			FilesFile* _tmp4_;
			g_value_init (&_tmp3_, FILES_TYPE_FILE);
			G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
			_vala_value = _tmp3_;
			_tmp4_ = file;
			g_value_set_object (&_vala_value, (GObject*) _tmp4_);
			break;
		}
		case FILES_LIST_MODEL_COLUMN_ID_COLOR:
		{
			GValue _tmp5_ = {0};
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			FilesFile* _tmp8_;
			g_value_init (&_tmp5_, G_TYPE_STRING);
			G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
			_vala_value = _tmp5_;
			_tmp8_ = file;
			if (_tmp8_ != NULL) {
				FilesFile* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				_tmp9_ = file;
				_tmp10_ = files_file_get_color (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp7_ = _tmp11_ >= 0;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				FilesFile* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				_tmp12_ = file;
				_tmp13_ = files_file_get_color (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp6_ = _tmp14_ < G_N_ELEMENTS (FILES_PREFERENCES_TAGS_COLORS);
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				FilesFile* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				const gchar* _tmp18_;
				_tmp15_ = file;
				_tmp16_ = files_file_get_color (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = FILES_PREFERENCES_TAGS_COLORS[_tmp17_];
				g_value_set_string (&_vala_value, _tmp18_);
			} else {
				const gchar* _tmp19_;
				_tmp19_ = FILES_PREFERENCES_TAGS_COLORS[0];
				g_value_set_string (&_vala_value, _tmp19_);
			}
			break;
		}
		case FILES_LIST_MODEL_COLUMN_ID_PIXBUF:
		{
			GValue _tmp20_ = {0};
			FilesFile* _tmp21_;
			g_value_init (&_tmp20_, gdk_pixbuf_get_type ());
			G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
			_vala_value = _tmp20_;
			_tmp21_ = file;
			if (_tmp21_ != NULL) {
				FilesFile* _tmp22_;
				gint _tmp23_;
				FilesFile* _tmp24_;
				FilesFile* _tmp25_;
				GdkPixbuf* _tmp26_;
				_tmp22_ = file;
				_tmp23_ = self->priv->_icon_size;
				_tmp24_ = file;
				files_file_update_icon (_tmp22_, _tmp23_, _tmp24_->pix_scale);
				_tmp25_ = file;
				_tmp26_ = _tmp25_->pix;
				if (_tmp26_ != NULL) {
					FilesFile* _tmp27_;
					GdkPixbuf* _tmp28_;
					_tmp27_ = file;
					_tmp28_ = _tmp27_->pix;
					g_value_set_object (&_vala_value, (GObject*) _tmp28_);
				}
			}
			break;
		}
		case FILES_LIST_MODEL_COLUMN_ID_FILENAME:
		{
			GValue _tmp29_ = {0};
			FilesFile* _tmp30_;
			g_value_init (&_tmp29_, G_TYPE_STRING);
			G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
			_vala_value = _tmp29_;
			_tmp30_ = file;
			if (_tmp30_ != NULL) {
				FilesFile* _tmp31_;
				const gchar* _tmp32_;
				_tmp31_ = file;
				_tmp32_ = files_file_get_display_name (_tmp31_);
				g_value_set_string (&_vala_value, _tmp32_);
			} else {
				g_value_set_static_string (&_vala_value, "");
			}
			break;
		}
		case FILES_LIST_MODEL_COLUMN_ID_SIZE:
		{
			GValue _tmp33_ = {0};
			FilesFile* _tmp34_;
			g_value_init (&_tmp33_, G_TYPE_STRING);
			G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
			_vala_value = _tmp33_;
			_tmp34_ = file;
			if (_tmp34_ != NULL) {
				FilesFile* _tmp35_;
				const gchar* _tmp36_;
				_tmp35_ = file;
				_tmp36_ = _tmp35_->format_size;
				g_value_set_string (&_vala_value, _tmp36_);
			} else {
				g_value_set_static_string (&_vala_value, "");
			}
			break;
		}
		case FILES_LIST_MODEL_COLUMN_ID_TYPE:
		{
			GValue _tmp37_ = {0};
			FilesFile* _tmp38_;
			g_value_init (&_tmp37_, G_TYPE_STRING);
			G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
			_vala_value = _tmp37_;
			_tmp38_ = file;
			if (_tmp38_ != NULL) {
				FilesFile* _tmp39_;
				const gchar* _tmp40_;
				_tmp39_ = file;
				_tmp40_ = _tmp39_->formated_type;
				g_value_set_string (&_vala_value, _tmp40_);
			} else {
				g_value_set_static_string (&_vala_value, "");
			}
			break;
		}
		case FILES_LIST_MODEL_COLUMN_ID_MODIFIED:
		{
			GValue _tmp41_ = {0};
			FilesFile* _tmp42_;
			g_value_init (&_tmp41_, G_TYPE_STRING);
			G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
			_vala_value = _tmp41_;
			_tmp42_ = file;
			if (_tmp42_ != NULL) {
				FilesFile* _tmp43_;
				const gchar* _tmp44_;
				_tmp43_ = file;
				_tmp44_ = _tmp43_->formated_modified;
				g_value_set_string (&_vala_value, _tmp44_);
			} else {
				g_value_set_static_string (&_vala_value, "");
			}
			break;
		}
		case FILES_LIST_MODEL_PRIV_COLUMN_ID_DUMMY:
		{
			GValue _tmp45_ = {0};
			FilesFile* _tmp46_;
			g_value_init (&_tmp45_, G_TYPE_BOOLEAN);
			G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
			_vala_value = _tmp45_;
			_tmp46_ = file;
			g_value_set_boolean (&_vala_value, _tmp46_ == NULL);
			break;
		}
		default:
		{
			GValue _tmp47_ = {0};
			g_value_init (&_tmp47_, G_TYPE_INVALID);
			G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
			_vala_value = _tmp47_;
			break;
		}
	}
	G_IS_VALUE (&file_value) ? (g_value_unset (&file_value), NULL) : NULL;
	if (value) {
		*value = _vala_value;
	} else {
		G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		FilesListModel* self;
		self = _data16_->self;
		_g_object_unref0 (_data16_->file);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static gboolean
__lambda7_ (Block16Data* _data16_,
            GtkTreeModel* model,
            GtkTreePath* path,
            GtkTreeIter* iter)
{
	FilesListModel* self;
	FilesFile* iter_file = NULL;
	GtkTreeIter _tmp0_;
	FilesFile* _tmp1_;
	gboolean result;
	self = _data16_->self;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	iter_file = NULL;
	_tmp0_ = *iter;
	gtk_tree_model_get ((GtkTreeModel*) self, &_tmp0_, FILES_LIST_MODEL_COLUMN_ID_FILE_COLUMN, &iter_file, -1);
	_tmp1_ = iter_file;
	if (_tmp1_ == _data16_->file) {
		GtkTreeIter _tmp2_;
		_tmp2_ = *iter;
		gtk_tree_model_row_changed (model, path, &_tmp2_);
		_data16_->found = TRUE;
		result = TRUE;
		_g_object_unref0 (iter_file);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (iter_file);
	return result;
}

static gboolean
___lambda7__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                         GtkTreePath* path,
                                         GtkTreeIter* iter,
                                         gpointer self)
{
	gboolean result;
	result = __lambda7_ (self, model, path, iter);
	return result;
}

void
files_list_model_file_changed (FilesListModel* self,
                               FilesFile* file,
                               FilesDirectory* dir)
{
	Block16Data* _data16_;
	FilesFile* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (dir != NULL);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (_data16_->file);
	_data16_->file = _tmp0_;
	_data16_->found = FALSE;
	gtk_tree_model_foreach ((GtkTreeModel*) self, ___lambda7__gtk_tree_model_foreach_func, _data16_);
	if (!_data16_->found) {
		files_list_model_add_file (self, _data16_->file, dir);
	}
	block16_data_unref (_data16_);
	_data16_ = NULL;
}

void
files_list_model_set_should_sort_directories_first (FilesListModel* self,
                                                    gboolean sort_directories_first)
{
	g_return_if_fail (self != NULL);
	if (self->priv->sort_directories_first == sort_directories_first) {
		return;
	}
	self->priv->sort_directories_first = sort_directories_first;
	files_list_model_resort (self);
}

static gboolean
___lambda8_ (FilesListModel* self)
{
	gboolean result;
	if (self->priv->delay_resort) {
		self->priv->delay_resort = FALSE;
		result = G_SOURCE_CONTINUE;
		return result;
	} else {
		gint sort_column_id = 0;
		GtkSortType order = 0;
		gint _tmp0_ = 0;
		GtkSortType _tmp1_ = 0;
		gboolean _tmp2_;
		self->priv->delay_resort = TRUE;
		_tmp2_ = gtk_tree_sortable_get_sort_column_id ((GtkTreeSortable*) self, &_tmp0_, &_tmp1_);
		sort_column_id = _tmp0_;
		order = _tmp1_;
		if (!_tmp2_) {
			sort_column_id = (gint) FILES_LIST_MODEL_COLUMN_ID_FILENAME;
			order = GTK_SORT_ASCENDING;
		}
		gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) self, GTK_TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID, order);
		gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) self, sort_column_id, order);
		self->priv->resort_timeout_id = (guint) 0;
		result = G_SOURCE_REMOVE;
		return result;
	}
}

static gboolean
____lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda8_ ((FilesListModel*) self);
	return result;
}

static void
files_list_model_resort (FilesListModel* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = files_list_model_get_sort_pending (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		self->priv->resort_timeout_id = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda8__gsource_func, g_object_ref (self), g_object_unref);
	} else {
		self->priv->delay_resort = TRUE;
	}
}

gboolean
files_list_model_get_subdirectory (FilesListModel* self,
                                   GtkTreePath* path,
                                   FilesDirectory** dir)
{
	FilesDirectory* _vala_dir = NULL;
	FilesFile* file = NULL;
	GtkTreeIter* iter = NULL;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	GtkTreeIter _tmp2_;
	GtkTreeIter* _tmp3_;
	FilesDirectory* _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_g_object_unref0 (_vala_dir);
	_vala_dir = NULL;
	file = NULL;
	_tmp1_ = gtk_tree_model_get_iter ((GtkTreeModel*) self, &_tmp0_, path);
	__vala_GtkTreeIter_free0 (iter);
	_tmp2_ = _tmp0_;
	_tmp3_ = __vala_GtkTreeIter_copy0 (&_tmp2_);
	iter = _tmp3_;
	if (_tmp1_) {
		GtkTreeIter* _tmp4_;
		GtkTreeIter _tmp5_;
		FilesFile* _tmp6_ = NULL;
		FilesFile* _tmp7_;
		_tmp4_ = iter;
		_tmp5_ = *_tmp4_;
		gtk_tree_model_get ((GtkTreeModel*) self, &_tmp5_, FILES_LIST_MODEL_COLUMN_ID_FILE_COLUMN, &_tmp6_, -1);
		_g_object_unref0 (file);
		file = _tmp6_;
		_tmp7_ = file;
		if (_tmp7_ != NULL) {
			FilesFile* _tmp8_;
			FilesDirectory* _tmp9_;
			_tmp8_ = file;
			_tmp9_ = files_directory_from_file (_tmp8_);
			_g_object_unref0 (_vala_dir);
			_vala_dir = _tmp9_;
		}
	}
	_tmp10_ = _vala_dir;
	result = _tmp10_ != NULL;
	__vala_GtkTreeIter_free0 (iter);
	_g_object_unref0 (file);
	if (dir) {
		*dir = _vala_dir;
	} else {
		_g_object_unref0 (_vala_dir);
	}
	return result;
}

void
files_list_model_load_subdirectory (FilesListModel* self,
                                    FilesDirectory* dir)
{
	GtkTreeIter* parent_iter = NULL;
	GtkTreeIter* child_iter = NULL;
	gboolean change_dummy = FALSE;
	FilesFile* _tmp0_;
	FilesFile* _tmp1_;
	GtkTreeIter* _tmp2_ = NULL;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	parent_iter = NULL;
	child_iter = NULL;
	change_dummy = TRUE;
	_tmp0_ = files_directory_get_file (dir);
	_tmp1_ = _tmp0_;
	_tmp3_ = files_list_model_get_first_iter_for_file (self, _tmp1_, &_tmp2_);
	__vala_GtkTreeIter_free0 (parent_iter);
	parent_iter = _tmp2_;
	if (_tmp3_) {
		GList* files = NULL;
		GList* _tmp4_;
		GtkTreeIter* _tmp5_;
		GtkTreeIter _tmp6_ = {0};
		gboolean _tmp7_;
		GtkTreeIter _tmp8_;
		GtkTreeIter* _tmp9_;
		GList* _tmp13_;
		_tmp4_ = files_directory_get_files (dir);
		files = _tmp4_;
		_tmp5_ = parent_iter;
		_tmp7_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) self, &_tmp6_, _tmp5_, 0);
		__vala_GtkTreeIter_free0 (child_iter);
		_tmp8_ = _tmp6_;
		_tmp9_ = __vala_GtkTreeIter_copy0 (&_tmp8_);
		child_iter = _tmp9_;
		if (_tmp7_) {
			GtkTreeIter* _tmp10_;
			GtkTreeIter _tmp11_;
			gboolean _tmp12_ = FALSE;
			_tmp10_ = child_iter;
			_tmp11_ = *_tmp10_;
			gtk_tree_model_get ((GtkTreeModel*) self, &_tmp11_, FILES_LIST_MODEL_PRIV_COLUMN_ID_DUMMY, &_tmp12_, -1);
			change_dummy = _tmp12_;
		} else {
			g_critical ("ListModel.vala:328: folder item with no child");
		}
		if (!change_dummy) {
			(files == NULL) ? NULL : (files = (g_list_free (files), NULL));
			__vala_GtkTreeIter_free0 (child_iter);
			__vala_GtkTreeIter_free0 (parent_iter);
			return;
		}
		files_list_model_set_sorting_off (self);
		_tmp13_ = files;
		{
			GList* file_collection = NULL;
			GList* file_it = NULL;
			file_collection = _tmp13_;
			for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
				FilesFile* file = NULL;
				file = (FilesFile*) file_it->data;
				{
					gboolean _tmp14_ = FALSE;
					gboolean _tmp15_;
					GeeTreeMap* _tmp29_;
					FilesFile* _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp32_;
					GtkTreeIter* _tmp33_;
					GtkTreeIter _tmp34_;
					GtkTreePath* _tmp35_;
					GtkTreePath* _tmp36_;
					GtkTreeRowReference* _tmp37_;
					GtkTreeRowReference* _tmp38_;
					FilesFile* _tmp39_;
					_tmp15_ = self->priv->_show_hidden_files;
					if (!_tmp15_) {
						FilesFile* _tmp16_;
						gboolean _tmp17_;
						gboolean _tmp18_;
						_tmp16_ = file;
						_tmp17_ = files_file_get_is_hidden (_tmp16_);
						_tmp18_ = _tmp17_;
						_tmp14_ = _tmp18_;
					} else {
						_tmp14_ = FALSE;
					}
					if (_tmp14_) {
						continue;
					}
					if (change_dummy) {
						GtkTreeIter* _tmp19_;
						FilesFile* _tmp20_;
						GtkTreeIter _tmp21_;
						_tmp19_ = child_iter;
						_tmp20_ = file;
						_tmp21_ = *_tmp19_;
						gtk_tree_store_set ((GtkTreeStore*) self, &_tmp21_, FILES_LIST_MODEL_COLUMN_ID_FILE_COLUMN, _tmp20_, FILES_LIST_MODEL_PRIV_COLUMN_ID_DUMMY, FALSE, -1, -1);
						change_dummy = FALSE;
					} else {
						GtkTreeIter* _tmp22_;
						GtkTreeIter _tmp23_ = {0};
						GtkTreeIter _tmp24_;
						GtkTreeIter* _tmp25_;
						GtkTreeIter* _tmp26_;
						FilesFile* _tmp27_;
						GtkTreeIter _tmp28_;
						_tmp22_ = parent_iter;
						gtk_tree_store_insert ((GtkTreeStore*) self, &_tmp23_, _tmp22_, -1);
						__vala_GtkTreeIter_free0 (child_iter);
						_tmp24_ = _tmp23_;
						_tmp25_ = __vala_GtkTreeIter_copy0 (&_tmp24_);
						child_iter = _tmp25_;
						_tmp26_ = child_iter;
						_tmp27_ = file;
						_tmp28_ = *_tmp26_;
						gtk_tree_store_set ((GtkTreeStore*) self, &_tmp28_, FILES_LIST_MODEL_COLUMN_ID_FILE_COLUMN, _tmp27_, FILES_LIST_MODEL_PRIV_COLUMN_ID_DUMMY, FALSE, -1, -1);
					}
					_tmp29_ = self->priv->file_treerow_map;
					_tmp30_ = file;
					_tmp31_ = files_file_get_uri (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = child_iter;
					_tmp34_ = *_tmp33_;
					_tmp35_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = gtk_tree_row_reference_new ((GtkTreeModel*) self, _tmp36_);
					_tmp38_ = _tmp37_;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp29_, _tmp32_, _tmp38_);
					__vala_GtkTreeRowReference_free0 (_tmp38_);
					__vala_GtkTreePath_free0 (_tmp36_);
					_tmp39_ = file;
					if (files_file_is_folder (_tmp39_)) {
						GtkTreeIter* _tmp40_;
						GtkTreeIter _tmp41_ = {0};
						GtkTreeIter _tmp42_;
						GtkTreeIter* _tmp43_;
						_tmp40_ = child_iter;
						gtk_tree_store_insert_with_values ((GtkTreeStore*) self, &_tmp41_, _tmp40_, -1, FILES_LIST_MODEL_PRIV_COLUMN_ID_DUMMY, TRUE, -1);
						__vala_GtkTreeIter_free0 (child_iter);
						_tmp42_ = _tmp41_;
						_tmp43_ = __vala_GtkTreeIter_copy0 (&_tmp42_);
						child_iter = _tmp43_;
					}
				}
			}
		}
		files_list_model_set_sorting_on (self);
		(files == NULL) ? NULL : (files = (g_list_free (files), NULL));
	}
	__vala_GtkTreeIter_free0 (child_iter);
	__vala_GtkTreeIter_free0 (parent_iter);
}

gboolean
files_list_model_unload_subdirectory (FilesListModel* self,
                                      GtkTreeIter* parent_iter)
{
	FilesFile* file = NULL;
	GtkTreeIter _tmp0_;
	FilesFile* _tmp1_ = NULL;
	FilesFile* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (parent_iter != NULL, FALSE);
	file = NULL;
	_tmp0_ = *parent_iter;
	gtk_tree_model_get ((GtkTreeModel*) self, &_tmp0_, FILES_LIST_MODEL_COLUMN_ID_FILE_COLUMN, &_tmp1_, -1);
	_g_object_unref0 (file);
	file = _tmp1_;
	_tmp2_ = file;
	if (_tmp2_ != NULL) {
		FilesDirectory* dir = NULL;
		FilesFile* _tmp3_;
		FilesDirectory* _tmp4_;
		FilesDirectory* _tmp5_;
		GtkTreeIter* child_iter = NULL;
		FilesFile* child_file = NULL;
		GtkTreeIter _tmp6_;
		GtkTreeIter _tmp7_ = {0};
		gboolean _tmp8_;
		GtkTreeIter _tmp9_;
		GtkTreeIter* _tmp10_;
		GtkTreeIter _tmp21_;
		GtkTreeIter _tmp22_ = {0};
		GtkTreeIter _tmp23_;
		GtkTreeIter* _tmp24_;
		FilesDirectory* _tmp25_;
		_tmp3_ = file;
		_tmp4_ = files_directory_from_file (_tmp3_);
		dir = _tmp4_;
		_tmp5_ = dir;
		files_directory_cancel (_tmp5_);
		child_iter = NULL;
		child_file = NULL;
		files_list_model_set_sorting_off (self);
		_tmp6_ = *parent_iter;
		_tmp8_ = gtk_tree_model_iter_children ((GtkTreeModel*) self, &_tmp7_, &_tmp6_);
		__vala_GtkTreeIter_free0 (child_iter);
		_tmp9_ = _tmp7_;
		_tmp10_ = __vala_GtkTreeIter_copy0 (&_tmp9_);
		child_iter = _tmp10_;
		if (_tmp8_) {
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					GtkTreeIter* _tmp13_;
					GtkTreeIter _tmp14_;
					FilesFile* _tmp15_ = NULL;
					FilesFile* _tmp16_;
					if (!_tmp11_) {
						gboolean _tmp12_;
						_tmp12_ = gtk_tree_store_remove ((GtkTreeStore*) self, child_iter);
						if (!_tmp12_) {
							break;
						}
					}
					_tmp11_ = FALSE;
					_tmp13_ = child_iter;
					_tmp14_ = *_tmp13_;
					gtk_tree_model_get ((GtkTreeModel*) self, &_tmp14_, FILES_LIST_MODEL_COLUMN_ID_FILE_COLUMN, &_tmp15_, -1);
					_g_object_unref0 (child_file);
					child_file = _tmp15_;
					_tmp16_ = child_file;
					if (_tmp16_ != NULL) {
						GeeTreeMap* _tmp17_;
						FilesFile* _tmp18_;
						const gchar* _tmp19_;
						const gchar* _tmp20_;
						_tmp17_ = self->priv->file_treerow_map;
						_tmp18_ = child_file;
						_tmp19_ = files_file_get_uri (_tmp18_);
						_tmp20_ = _tmp19_;
						gee_abstract_map_unset ((GeeAbstractMap*) _tmp17_, _tmp20_, NULL);
					}
				}
			}
		}
		_tmp21_ = *parent_iter;
		gtk_tree_store_insert_with_values ((GtkTreeStore*) self, &_tmp22_, &_tmp21_, -1, FILES_LIST_MODEL_PRIV_COLUMN_ID_DUMMY, TRUE, -1);
		__vala_GtkTreeIter_free0 (child_iter);
		_tmp23_ = _tmp22_;
		_tmp24_ = __vala_GtkTreeIter_copy0 (&_tmp23_);
		child_iter = _tmp24_;
		_tmp25_ = dir;
		g_signal_emit (self, files_list_model_signals[FILES_LIST_MODEL_SUBDIRECTORY_UNLOADED_SIGNAL], 0, _tmp25_);
		files_list_model_set_sorting_on (self);
		result = TRUE;
		_g_object_unref0 (child_file);
		__vala_GtkTreeIter_free0 (child_iter);
		_g_object_unref0 (dir);
		_g_object_unref0 (file);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (file);
	return result;
}

gboolean
files_list_model_insert_sorted (FilesListModel* self,
                                FilesFile* file,
                                FilesDirectory* dir)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (dir != NULL, FALSE);
	if (files_list_model_add_file (self, file, dir)) {
		files_list_model_resort (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

gboolean
files_list_model_add_file (FilesListModel* self,
                           FilesFile* file,
                           FilesDirectory* dir)
{
	GtkTreeIter* parent_iter = NULL;
	GtkTreeIter* file_iter = NULL;
	GtkTreeIter* dummy_iter = NULL;
	gboolean change_dummy = FALSE;
	GtkTreeIter* _tmp0_ = NULL;
	gboolean _tmp1_;
	FilesFile* _tmp2_;
	FilesFile* _tmp3_;
	GtkTreeIter* _tmp4_ = NULL;
	gboolean _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (dir != NULL, FALSE);
	change_dummy = FALSE;
	_tmp1_ = files_list_model_get_first_iter_for_file (self, file, &_tmp0_);
	__vala_GtkTreeIter_free0 (file_iter);
	file_iter = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		__vala_GtkTreeIter_free0 (dummy_iter);
		__vala_GtkTreeIter_free0 (file_iter);
		__vala_GtkTreeIter_free0 (parent_iter);
		return result;
	}
	_tmp2_ = files_directory_get_file (dir);
	_tmp3_ = _tmp2_;
	_tmp5_ = files_list_model_get_first_iter_for_file (self, _tmp3_, &_tmp4_);
	__vala_GtkTreeIter_free0 (parent_iter);
	parent_iter = _tmp4_;
	if (_tmp5_) {
		GtkTreeIter* _tmp6_;
		GtkTreeIter _tmp7_ = {0};
		gboolean _tmp8_;
		GtkTreeIter _tmp9_;
		GtkTreeIter* _tmp10_;
		_tmp6_ = parent_iter;
		_tmp8_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) self, &_tmp7_, _tmp6_, 0);
		__vala_GtkTreeIter_free0 (file_iter);
		_tmp9_ = _tmp7_;
		_tmp10_ = __vala_GtkTreeIter_copy0 (&_tmp9_);
		file_iter = _tmp10_;
		if (_tmp8_) {
			GtkTreeIter* _tmp11_;
			GtkTreeIter _tmp12_;
			gboolean _tmp13_ = FALSE;
			_tmp11_ = file_iter;
			_tmp12_ = *_tmp11_;
			gtk_tree_model_get ((GtkTreeModel*) self, &_tmp12_, FILES_LIST_MODEL_PRIV_COLUMN_ID_DUMMY, &_tmp13_, -1);
			change_dummy = _tmp13_;
			if (change_dummy) {
				GtkTreeIter* _tmp14_;
				GtkTreeIter _tmp15_;
				GeeTreeMap* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				GtkTreeIter* _tmp19_;
				GtkTreeIter _tmp20_;
				GtkTreePath* _tmp21_;
				GtkTreePath* _tmp22_;
				GtkTreeRowReference* _tmp23_;
				GtkTreeRowReference* _tmp24_;
				_tmp14_ = file_iter;
				_tmp15_ = *_tmp14_;
				gtk_tree_store_set ((GtkTreeStore*) self, &_tmp15_, FILES_LIST_MODEL_COLUMN_ID_FILE_COLUMN, file, FILES_LIST_MODEL_PRIV_COLUMN_ID_DUMMY, FALSE, -1, -1);
				_tmp16_ = self->priv->file_treerow_map;
				_tmp17_ = files_file_get_uri (file);
				_tmp18_ = _tmp17_;
				_tmp19_ = file_iter;
				_tmp20_ = *_tmp19_;
				_tmp21_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = gtk_tree_row_reference_new ((GtkTreeModel*) self, _tmp22_);
				_tmp24_ = _tmp23_;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, _tmp18_, _tmp24_);
				__vala_GtkTreeRowReference_free0 (_tmp24_);
				__vala_GtkTreePath_free0 (_tmp22_);
			}
		} else {
			g_critical ("ListModel.vala:421: folder item with no child");
		}
	} else {
		__vala_GtkTreeIter_free0 (parent_iter);
		parent_iter = NULL;
	}
	if (!change_dummy) {
		GtkTreeIter* _tmp25_;
		GtkTreeIter _tmp26_ = {0};
		GtkTreeIter _tmp27_;
		GtkTreeIter* _tmp28_;
		GeeTreeMap* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		GtkTreeIter* _tmp32_;
		GtkTreeIter _tmp33_;
		GtkTreePath* _tmp34_;
		GtkTreePath* _tmp35_;
		GtkTreeRowReference* _tmp36_;
		GtkTreeRowReference* _tmp37_;
		_tmp25_ = parent_iter;
		gtk_tree_store_insert_with_values ((GtkTreeStore*) self, &_tmp26_, _tmp25_, -1, FILES_LIST_MODEL_COLUMN_ID_FILE_COLUMN, file, FILES_LIST_MODEL_PRIV_COLUMN_ID_DUMMY, FALSE, -1);
		__vala_GtkTreeIter_free0 (file_iter);
		_tmp27_ = _tmp26_;
		_tmp28_ = __vala_GtkTreeIter_copy0 (&_tmp27_);
		file_iter = _tmp28_;
		_tmp29_ = self->priv->file_treerow_map;
		_tmp30_ = files_file_get_uri (file);
		_tmp31_ = _tmp30_;
		_tmp32_ = file_iter;
		_tmp33_ = *_tmp32_;
		_tmp34_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = gtk_tree_row_reference_new ((GtkTreeModel*) self, _tmp35_);
		_tmp37_ = _tmp36_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp29_, _tmp31_, _tmp37_);
		__vala_GtkTreeRowReference_free0 (_tmp37_);
		__vala_GtkTreePath_free0 (_tmp35_);
	}
	if (files_file_is_folder (file)) {
		GtkTreeIter* _tmp38_;
		GtkTreeIter _tmp39_ = {0};
		GtkTreeIter _tmp40_;
		GtkTreeIter* _tmp41_;
		_tmp38_ = file_iter;
		gtk_tree_store_insert_with_values ((GtkTreeStore*) self, &_tmp39_, _tmp38_, -1, FILES_LIST_MODEL_PRIV_COLUMN_ID_DUMMY, TRUE, -1);
		__vala_GtkTreeIter_free0 (dummy_iter);
		_tmp40_ = _tmp39_;
		_tmp41_ = __vala_GtkTreeIter_copy0 (&_tmp40_);
		dummy_iter = _tmp41_;
	}
	result = TRUE;
	__vala_GtkTreeIter_free0 (dummy_iter);
	__vala_GtkTreeIter_free0 (file_iter);
	__vala_GtkTreeIter_free0 (parent_iter);
	return result;
}

gboolean
files_list_model_remove_file (FilesListModel* self,
                              FilesFile* file,
                              FilesDirectory* dir)
{
	GtkTreeIter* parent_iter = NULL;
	GtkTreeIter* child_iter = NULL;
	GtkTreeIter* file_iter = NULL;
	GtkTreeIter* dummy_iter = NULL;
	GtkTreeIter* _tmp0_ = NULL;
	gboolean _tmp1_;
	GtkTreeIter* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (dir != NULL, FALSE);
	_tmp1_ = files_list_model_get_first_iter_for_file (self, file, &_tmp0_);
	__vala_GtkTreeIter_free0 (file_iter);
	file_iter = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		__vala_GtkTreeIter_free0 (dummy_iter);
		__vala_GtkTreeIter_free0 (file_iter);
		__vala_GtkTreeIter_free0 (child_iter);
		__vala_GtkTreeIter_free0 (parent_iter);
		return result;
	}
	_tmp2_ = file_iter;
	if (_tmp2_ != NULL) {
		FilesFile* _tmp3_;
		FilesFile* _tmp4_;
		GtkTreeIter* _tmp5_ = NULL;
		gboolean _tmp6_;
		GeeTreeMap* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp3_ = files_directory_get_file (dir);
		_tmp4_ = _tmp3_;
		_tmp6_ = files_list_model_get_first_iter_for_file (self, _tmp4_, &_tmp5_);
		__vala_GtkTreeIter_free0 (parent_iter);
		parent_iter = _tmp5_;
		if (_tmp6_) {
			GtkTreeIter* _tmp7_;
			GtkTreeIter _tmp8_ = {0};
			gboolean _tmp9_;
			GtkTreeIter _tmp10_;
			GtkTreeIter* _tmp11_;
			_tmp7_ = parent_iter;
			_tmp9_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) self, &_tmp8_, _tmp7_, 1);
			__vala_GtkTreeIter_free0 (child_iter);
			_tmp10_ = _tmp8_;
			_tmp11_ = __vala_GtkTreeIter_copy0 (&_tmp10_);
			child_iter = _tmp11_;
			if (!_tmp9_) {
				GtkTreeIter* _tmp12_;
				GtkTreeIter _tmp13_ = {0};
				GtkTreeIter _tmp14_;
				GtkTreeIter* _tmp15_;
				_tmp12_ = parent_iter;
				gtk_tree_store_insert_with_values ((GtkTreeStore*) self, &_tmp13_, _tmp12_, -1, FILES_LIST_MODEL_PRIV_COLUMN_ID_DUMMY, TRUE, -1);
				__vala_GtkTreeIter_free0 (dummy_iter);
				_tmp14_ = _tmp13_;
				_tmp15_ = __vala_GtkTreeIter_copy0 (&_tmp14_);
				dummy_iter = _tmp15_;
			}
		}
		gtk_tree_store_remove ((GtkTreeStore*) self, file_iter);
		_tmp16_ = self->priv->file_treerow_map;
		_tmp17_ = files_file_get_uri (file);
		_tmp18_ = _tmp17_;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp16_, _tmp18_, NULL);
		result = TRUE;
		__vala_GtkTreeIter_free0 (dummy_iter);
		__vala_GtkTreeIter_free0 (file_iter);
		__vala_GtkTreeIter_free0 (child_iter);
		__vala_GtkTreeIter_free0 (parent_iter);
		return result;
	}
	result = FALSE;
	__vala_GtkTreeIter_free0 (dummy_iter);
	__vala_GtkTreeIter_free0 (file_iter);
	__vala_GtkTreeIter_free0 (child_iter);
	__vala_GtkTreeIter_free0 (parent_iter);
	return result;
}

void
files_list_model_clear (FilesListModel* self)
{
	GeeTreeMap* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->file_treerow_map;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
	gtk_tree_store_clear (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_store_get_type (), GtkTreeStore));
}

static gint
files_list_model_file_entry_compare_func (FilesListModel* self,
                                          GtkTreeIter* a,
                                          GtkTreeIter* b)
{
	FilesFile* file_a = NULL;
	FilesFile* file_b = NULL;
	GtkTreeIter _tmp0_;
	FilesFile* _tmp1_ = NULL;
	GtkTreeIter _tmp2_;
	FilesFile* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	FilesFile* _tmp7_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	file_a = NULL;
	file_b = NULL;
	_tmp0_ = *a;
	gtk_tree_model_get ((GtkTreeModel*) self, &_tmp0_, FILES_LIST_MODEL_COLUMN_ID_FILE_COLUMN, &_tmp1_, -1);
	_g_object_unref0 (file_a);
	file_a = _tmp1_;
	_tmp2_ = *b;
	gtk_tree_model_get ((GtkTreeModel*) self, &_tmp2_, FILES_LIST_MODEL_COLUMN_ID_FILE_COLUMN, &_tmp3_, -1);
	_g_object_unref0 (file_b);
	file_b = _tmp3_;
	_tmp7_ = file_a;
	if (_tmp7_ != NULL) {
		FilesFile* _tmp8_;
		_tmp8_ = file_b;
		_tmp6_ = _tmp8_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		FilesFile* _tmp9_;
		GFile* _tmp10_;
		GFile* _tmp11_;
		_tmp9_ = file_a;
		_tmp10_ = files_file_get_location (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = _tmp11_ != NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		FilesFile* _tmp12_;
		GFile* _tmp13_;
		GFile* _tmp14_;
		_tmp12_ = file_b;
		_tmp13_ = files_file_get_location (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp4_ = _tmp14_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gint sort_column_id = 0;
		GtkSortType order = 0;
		gint _tmp15_ = 0;
		GtkSortType _tmp16_ = 0;
		gboolean _tmp17_;
		FilesFile* _tmp18_;
		FilesFile* _tmp19_;
		_tmp17_ = gtk_tree_sortable_get_sort_column_id ((GtkTreeSortable*) self, &_tmp15_, &_tmp16_);
		sort_column_id = _tmp15_;
		order = _tmp16_;
		if (!_tmp17_) {
			sort_column_id = (gint) FILES_LIST_MODEL_COLUMN_ID_FILENAME;
			order = GTK_SORT_ASCENDING;
		}
		_tmp18_ = file_a;
		_tmp19_ = file_b;
		result = files_file_compare_for_sort (_tmp18_, _tmp19_, sort_column_id, self->priv->sort_directories_first, order == GTK_SORT_DESCENDING);
		_g_object_unref0 (file_b);
		_g_object_unref0 (file_a);
		return result;
	} else {
		gboolean _tmp20_ = FALSE;
		FilesFile* _tmp21_;
		_tmp21_ = file_a;
		if (_tmp21_ == NULL) {
			_tmp20_ = TRUE;
		} else {
			FilesFile* _tmp22_;
			GFile* _tmp23_;
			GFile* _tmp24_;
			_tmp22_ = file_a;
			_tmp23_ = files_file_get_location (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp20_ = _tmp24_ == NULL;
		}
		if (_tmp20_) {
			result = -1;
			_g_object_unref0 (file_b);
			_g_object_unref0 (file_a);
			return result;
		} else {
			result = 1;
			_g_object_unref0 (file_b);
			_g_object_unref0 (file_a);
			return result;
		}
	}
}

FilesListModel*
files_list_model_construct (GType object_type)
{
	FilesListModel * self = NULL;
	self = (FilesListModel*) g_object_new (object_type, NULL);
	return self;
}

FilesListModel*
files_list_model_new (void)
{
	return files_list_model_construct (FILES_TYPE_LIST_MODEL);
}

gboolean
files_list_model_get_show_hidden_files (FilesListModel* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_hidden_files;
	return result;
}

void
files_list_model_set_show_hidden_files (FilesListModel* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_list_model_get_show_hidden_files (self);
	if (old_value != value) {
		self->priv->_show_hidden_files = value;
		g_object_notify_by_pspec ((GObject *) self, files_list_model_properties[FILES_LIST_MODEL_SHOW_HIDDEN_FILES_PROPERTY]);
	}
}

gint
files_list_model_get_icon_size (FilesListModel* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_icon_size;
	return result;
}

void
files_list_model_set_icon_size (FilesListModel* self,
                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = files_list_model_get_icon_size (self);
	if (old_value != value) {
		self->priv->_icon_size = value;
		g_object_notify_by_pspec ((GObject *) self, files_list_model_properties[FILES_LIST_MODEL_ICON_SIZE_PROPERTY]);
	}
}

gboolean
files_list_model_get_has_child (FilesListModel* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_child;
	return result;
}

void
files_list_model_set_has_child (FilesListModel* self,
                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_list_model_get_has_child (self);
	if (old_value != value) {
		self->priv->_has_child = value;
		g_object_notify_by_pspec ((GObject *) self, files_list_model_properties[FILES_LIST_MODEL_HAS_CHILD_PROPERTY]);
	}
}

gboolean
files_list_model_get_sort_pending (FilesListModel* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->resort_timeout_id > ((guint) 0);
	return result;
}

static GtkTreeRowReference*
_vala_GtkTreeRowReference_copy (GtkTreeRowReference* self)
{
	return g_boxed_copy (gtk_tree_row_reference_get_type (), self);
}

static GObject *
files_list_model_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesListModel * self;
	GeeTreeMap* _tmp0_;
	GType* _tmp1_;
	GType* _tmp2_;
	gint _tmp2__length1;
	parent_class = G_OBJECT_CLASS (files_list_model_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_LIST_MODEL, FilesListModel);
	_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gtk_tree_row_reference_get_type (), (GBoxedCopyFunc) _vala_GtkTreeRowReference_copy, (GDestroyNotify) _vala_GtkTreeRowReference_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->file_treerow_map);
	self->priv->file_treerow_map = _tmp0_;
	_tmp1_ = g_new0 (GType, 8);
	_tmp1_[0] = FILES_TYPE_FILE;
	_tmp1_[1] = G_TYPE_STRING;
	_tmp1_[2] = gdk_pixbuf_get_type ();
	_tmp1_[3] = G_TYPE_STRING;
	_tmp1_[4] = G_TYPE_STRING;
	_tmp1_[5] = G_TYPE_STRING;
	_tmp1_[6] = G_TYPE_STRING;
	_tmp1_[7] = G_TYPE_BOOLEAN;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 8;
	gtk_tree_store_set_column_types ((GtkTreeStore*) self, (gint) 8, _tmp2_);
	_tmp2_ = (g_free (_tmp2_), NULL);
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) self, (gint) FILES_LIST_MODEL_COLUMN_ID_FILENAME, GTK_SORT_ASCENDING);
	files_list_model_set_sorting_off (self);
	return obj;
}

static void
files_list_model_class_init (FilesListModelClass * klass,
                             gpointer klass_data)
{
	files_list_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesListModel_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_files_list_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_list_model_set_property;
	G_OBJECT_CLASS (klass)->constructor = files_list_model_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_list_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_LIST_MODEL_SHOW_HIDDEN_FILES_PROPERTY, files_list_model_properties[FILES_LIST_MODEL_SHOW_HIDDEN_FILES_PROPERTY] = g_param_spec_boolean ("show-hidden-files", "show-hidden-files", "show-hidden-files", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_LIST_MODEL_ICON_SIZE_PROPERTY, files_list_model_properties[FILES_LIST_MODEL_ICON_SIZE_PROPERTY] = g_param_spec_int ("icon-size", "icon-size", "icon-size", G_MININT, G_MAXINT, 32, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_LIST_MODEL_HAS_CHILD_PROPERTY, files_list_model_properties[FILES_LIST_MODEL_HAS_CHILD_PROPERTY] = g_param_spec_boolean ("has-child", "has-child", "has-child", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_LIST_MODEL_SORT_PENDING_PROPERTY, files_list_model_properties[FILES_LIST_MODEL_SORT_PENDING_PROPERTY] = g_param_spec_boolean ("sort-pending", "sort-pending", "sort-pending", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	files_list_model_signals[FILES_LIST_MODEL_SUBDIRECTORY_UNLOADED_SIGNAL] = g_signal_new ("subdirectory-unloaded", FILES_TYPE_LIST_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FILES_TYPE_DIRECTORY);
}

static void
files_list_model_gtk_tree_model_interface_init (GtkTreeModelIface * iface,
                                                gpointer iface_data)
{
	files_list_model_gtk_tree_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_value = (void (*) (GtkTreeModel*, GtkTreeIter*, gint, GValue*)) files_list_model_real_get_value;
}

static void
files_list_model_instance_init (FilesListModel * self,
                                gpointer klass)
{
	self->priv = files_list_model_get_instance_private (self);
	self->priv->_show_hidden_files = FALSE;
	self->priv->_icon_size = 32;
	self->priv->_has_child = FALSE;
	self->priv->sort_directories_first = TRUE;
	self->priv->resort_timeout_id = (guint) 0;
	self->priv->delay_resort = TRUE;
}

static void
files_list_model_finalize (GObject * obj)
{
	FilesListModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_LIST_MODEL, FilesListModel);
	_g_object_unref0 (self->priv->file_treerow_map);
	G_OBJECT_CLASS (files_list_model_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_list_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesListModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_list_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesListModel), 0, (GInstanceInitFunc) files_list_model_instance_init, NULL };
	static const GInterfaceInfo gtk_tree_model_info = { (GInterfaceInitFunc) files_list_model_gtk_tree_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType files_list_model_type_id;
	files_list_model_type_id = g_type_register_static (gtk_tree_store_get_type (), "FilesListModel", &g_define_type_info, 0);
	g_type_add_interface_static (files_list_model_type_id, gtk_tree_model_get_type (), &gtk_tree_model_info);
	FilesListModel_private_offset = g_type_add_instance_private (files_list_model_type_id, sizeof (FilesListModelPrivate));
	return files_list_model_type_id;
}

GType
files_list_model_get_type (void)
{
	static volatile gsize files_list_model_type_id__once = 0;
	if (g_once_init_enter (&files_list_model_type_id__once)) {
		GType files_list_model_type_id;
		files_list_model_type_id = files_list_model_get_type_once ();
		g_once_init_leave (&files_list_model_type_id__once, files_list_model_type_id);
	}
	return files_list_model_type_id__once;
}

static void
_vala_files_list_model_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	FilesListModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_LIST_MODEL, FilesListModel);
	switch (property_id) {
		case FILES_LIST_MODEL_SHOW_HIDDEN_FILES_PROPERTY:
		g_value_set_boolean (value, files_list_model_get_show_hidden_files (self));
		break;
		case FILES_LIST_MODEL_ICON_SIZE_PROPERTY:
		g_value_set_int (value, files_list_model_get_icon_size (self));
		break;
		case FILES_LIST_MODEL_HAS_CHILD_PROPERTY:
		g_value_set_boolean (value, files_list_model_get_has_child (self));
		break;
		case FILES_LIST_MODEL_SORT_PENDING_PROPERTY:
		g_value_set_boolean (value, files_list_model_get_sort_pending (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_list_model_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	FilesListModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_LIST_MODEL, FilesListModel);
	switch (property_id) {
		case FILES_LIST_MODEL_SHOW_HIDDEN_FILES_PROPERTY:
		files_list_model_set_show_hidden_files (self, g_value_get_boolean (value));
		break;
		case FILES_LIST_MODEL_ICON_SIZE_PROPERTY:
		files_list_model_set_icon_size (self, g_value_get_int (value));
		break;
		case FILES_LIST_MODEL_HAS_CHILD_PROPERTY:
		files_list_model_set_has_child (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

