/* UndoManager.c generated by valac 0.56.18, the Vala compiler
 * generated from UndoManager.vala, do not modify */

#include "pantheon-files-core.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>
#include <gtk/gtk.h>
#include "marlin-file-operations.h"
#include <gdk/gdk.h>
#include <granite.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FilesParamSpecUndoActionData FilesParamSpecUndoActionData;
enum  {
	FILES_UNDO_MANAGER_0_PROPERTY,
	FILES_UNDO_MANAGER_UNDO_LEVELS_PROPERTY,
	FILES_UNDO_MANAGER_CONFIRM_DELETE_PROPERTY,
	FILES_UNDO_MANAGER_UNDO_REDO_FLAG_PROPERTY,
	FILES_UNDO_MANAGER_NUM_PROPERTIES
};
static GParamSpec* files_undo_manager_properties[FILES_UNDO_MANAGER_NUM_PROPERTIES];
typedef struct _Block22Data Block22Data;
#define _files_undo_action_data_unref0(var) ((var == NULL) ? NULL : (var = (files_undo_action_data_unref (var), NULL)))
typedef struct _Block23Data Block23Data;
typedef struct _Block24Data Block24Data;
typedef struct _Block25Data Block25Data;
typedef struct _FilesUndoManagerUndoData FilesUndoManagerUndoData;
typedef struct _Block26Data Block26Data;
typedef struct _Block27Data Block27Data;
typedef struct _Block28Data Block28Data;
typedef struct _Block29Data Block29Data;
typedef struct _Block30Data Block30Data;
typedef struct _FilesUndoManagerRedoData FilesUndoManagerRedoData;
typedef struct _Block31Data Block31Data;
typedef struct _Block32Data Block32Data;
typedef struct _Block33Data Block33Data;
typedef struct _Block34Data Block34Data;
enum  {
	FILES_UNDO_MANAGER_REQUEST_MENU_UPDATE_SIGNAL,
	FILES_UNDO_MANAGER_NUM_SIGNALS
};
static guint files_undo_manager_signals[FILES_UNDO_MANAGER_NUM_SIGNALS] = {0};

struct _FilesParamSpecUndoActionData {
	GParamSpec parent_instance;
};

struct _FilesUndoManagerPrivate {
	guint _undo_levels;
	gboolean _confirm_delete;
	GQueue* stack;
	GRecMutex __lock_stack;
	guint index;
	gboolean _undo_redo_flag;
};

struct _Block22Data {
	int _ref_count_;
	FilesUndoManager* self;
	FilesUndoActionData* action;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _Block23Data {
	int _ref_count_;
	Block22Data * _data22_;
	GList* uris;
};

struct _Block24Data {
	int _ref_count_;
	Block22Data * _data22_;
	GList* uris;
};

struct _Block25Data {
	int _ref_count_;
	Block22Data * _data22_;
	GList* uris;
};

struct _FilesUndoManagerUndoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesUndoManager* self;
	GtkWidget* widget;
	GCancellable* cancellable;
	gboolean result;
	Block22Data* _data22_;
	GQueue* _tmp0_;
	FilesUndoActionData* _tmp1_;
	FilesUndoActionData* _tmp2_;
	FilesUndoActionData* _tmp3_;
	FilesUndoActionData* _tmp4_;
	GQueue* _tmp5_;
	FilesUndoActionData* _tmp6_;
	FilesUndoActionData* _tmp7_;
	Block23Data* _data23_;
	FilesUndoActionData* _tmp8_;
	GList* _tmp9_;
	gboolean _tmp10_;
	GList* _tmp11_;
	gboolean _tmp12_;
	GList* _tmp13_;
	GtkWidget* _tmp14_;
	GError* e;
	FilesUndoActionData* _tmp15_;
	GError* _tmp16_;
	GError* _tmp17_;
	GList* _tmp18_;
	GList* file_collection;
	GList* file_it;
	GFile* file;
	GFile* _tmp19_;
	GFile* _tmp20_;
	FilesUndoActionData* _tmp21_;
	Block24Data* _data24_;
	FilesUndoActionData* _tmp22_;
	GList* _tmp23_;
	GList* _tmp24_;
	GList* _tmp25_;
	FilesUndoActionData* _tmp26_;
	GFile* _tmp27_;
	GError* _vala1_e;
	FilesUndoActionData* _tmp28_;
	GError* _tmp29_;
	GError* _tmp30_;
	FilesUndoActionData* _tmp31_;
	GFile* _vala1_file;
	FilesUndoActionData* _tmp32_;
	const gchar* _tmp33_;
	GFile* _tmp34_;
	gchar* new_name;
	FilesUndoActionData* _tmp35_;
	const gchar* _tmp36_;
	GFile* _tmp37_;
	GFile* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	GFile* _tmp41_;
	const gchar* _tmp42_;
	GFile* _tmp43_;
	GFile* _tmp44_;
	GError* _vala2_e;
	FilesUndoActionData* _tmp45_;
	GError* _tmp46_;
	GError* _tmp47_;
	FilesUndoActionData* _tmp48_;
	GList* uris;
	FilesUndoActionData* _tmp49_;
	const gchar* _tmp50_;
	GFile* _tmp51_;
	gboolean _tmp52_;
	GList* _tmp53_;
	gboolean _tmp54_;
	GList* _tmp55_;
	GtkWidget* _tmp56_;
	GError* _vala3_e;
	FilesUndoActionData* _tmp57_;
	GError* _tmp58_;
	GError* _tmp59_;
	GList* _tmp60_;
	GList* _vala1_file_collection;
	GList* _vala1_file_it;
	GFile* _vala2_file;
	GFile* _tmp61_;
	GFile* _tmp62_;
	FilesUndoActionData* _tmp63_;
	GHashTable* files_to_restore;
	FilesUndoActionData* _tmp64_;
	GHashTable* _tmp65_;
	GHashTable* _tmp66_;
	GHashTable* _tmp67_;
	GtkWidget* _tmp68_;
	GraniteMessageDialog* _tmp69_;
	GraniteMessageDialog* _tmp70_;
	FilesUndoActionData* _tmp71_;
	Block25Data* _data25_;
	FilesUndoActionData* _tmp72_;
	GList* _tmp73_;
	GList* _tmp74_;
	GList* _tmp75_;
	GtkWidget* _tmp76_;
	GError* _vala4_e;
	FilesUndoActionData* _tmp77_;
	GError* _tmp78_;
	GError* _tmp79_;
	FilesUndoActionData* _tmp80_;
	FilesUndoActionData* _tmp81_;
	gchar* _tmp82_;
	GError* _inner_error0_;
};

struct _Block26Data {
	int _ref_count_;
	FilesUndoManager* self;
	FilesUndoActionData* action;
	gpointer _async_data_;
};

struct _Block27Data {
	int _ref_count_;
	Block26Data * _data26_;
	GList* uris;
};

struct _Block28Data {
	int _ref_count_;
	Block26Data * _data26_;
	GList* uris;
};

struct _Block29Data {
	int _ref_count_;
	Block26Data * _data26_;
	GList* uris;
};

struct _Block30Data {
	int _ref_count_;
	Block26Data * _data26_;
	GList* uris;
};

struct _FilesUndoManagerRedoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesUndoManager* self;
	GtkWidget* widget;
	GCancellable* cancellable;
	gboolean result;
	Block26Data* _data26_;
	GQueue* _tmp0_;
	FilesUndoActionData* _tmp1_;
	FilesUndoActionData* _tmp2_;
	FilesUndoActionData* _tmp3_;
	FilesUndoActionData* _tmp4_;
	GQueue* _tmp5_;
	FilesUndoActionData* _tmp6_;
	FilesUndoActionData* _tmp7_;
	Block27Data* _data27_;
	FilesUndoActionData* _tmp8_;
	GList* _tmp9_;
	GList* _tmp10_;
	GList* _tmp11_;
	FilesUndoActionData* _tmp12_;
	GFile* _tmp13_;
	GError* e;
	FilesUndoActionData* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	FilesUndoActionData* _tmp17_;
	Block28Data* _data28_;
	FilesUndoActionData* _tmp18_;
	GList* _tmp19_;
	GList* _tmp20_;
	GList* _tmp21_;
	FilesUndoActionData* _tmp22_;
	GFile* _tmp23_;
	GError* _vala1_e;
	FilesUndoActionData* _tmp24_;
	GError* _tmp25_;
	GError* _tmp26_;
	FilesUndoActionData* _tmp27_;
	Block29Data* _data29_;
	FilesUndoActionData* _tmp28_;
	GList* _tmp29_;
	GList* _tmp30_;
	GList* _tmp31_;
	FilesUndoActionData* _tmp32_;
	GFile* _tmp33_;
	GError* _vala2_e;
	FilesUndoActionData* _tmp34_;
	GError* _tmp35_;
	GError* _tmp36_;
	FilesUndoActionData* _tmp37_;
	GFile* file;
	FilesUndoActionData* _tmp38_;
	const gchar* _tmp39_;
	GFile* _tmp40_;
	gchar* new_name;
	FilesUndoActionData* _tmp41_;
	const gchar* _tmp42_;
	GFile* _tmp43_;
	GFile* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	GFile* _tmp47_;
	const gchar* _tmp48_;
	GFile* _tmp49_;
	GFile* _tmp50_;
	GError* _vala3_e;
	FilesUndoActionData* _tmp51_;
	GError* _tmp52_;
	GError* _tmp53_;
	FilesUndoActionData* _tmp54_;
	gchar* p_uri;
	FilesUndoActionData* _tmp55_;
	const gchar* _tmp56_;
	GFile* _tmp57_;
	GFile* _tmp58_;
	GFile* _tmp59_;
	GFile* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _vala1_new_name;
	FilesUndoActionData* _tmp63_;
	const gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	GtkWidget* _tmp69_;
	const gchar* _tmp70_;
	const gchar* _tmp71_;
	FilesUndoActionData* _tmp72_;
	const gchar* _tmp73_;
	GFile* _tmp74_;
	GFile* _tmp75_;
	GError* _vala4_e;
	FilesUndoActionData* _tmp76_;
	GError* _tmp77_;
	GError* _tmp78_;
	FilesUndoActionData* _tmp79_;
	GFile* fparent;
	FilesUndoActionData* _tmp80_;
	const gchar* _tmp81_;
	GFile* _tmp82_;
	GFile* _tmp83_;
	GFile* _tmp84_;
	GFile* _tmp85_;
	GtkWidget* _tmp86_;
	GFile* _tmp87_;
	GFile* _tmp88_;
	GFile* _tmp89_;
	GError* _vala5_e;
	FilesUndoActionData* _tmp90_;
	GError* _tmp91_;
	GError* _tmp92_;
	FilesUndoActionData* _tmp93_;
	FilesUndoActionData* _tmp94_;
	GHashTable* _tmp95_;
	Block30Data* _data30_;
	GList* uri_to_trash;
	FilesUndoActionData* _tmp96_;
	GHashTable* _tmp97_;
	GList* _tmp98_;
	GList* _tmp99_;
	GList* _tmp100_;
	GtkWidget* _tmp101_;
	GError* _vala6_e;
	FilesUndoActionData* _tmp102_;
	GError* _tmp103_;
	GError* _tmp104_;
	FilesUndoActionData* _tmp105_;
	FilesUndoActionData* _tmp106_;
	gchar* _tmp107_;
	GError* _inner_error0_;
};

struct _Block31Data {
	int _ref_count_;
	FilesUndoManager* self;
	GList* trash;
};

struct _Block32Data {
	int _ref_count_;
	Block31Data * _data31_;
	FilesUndoActionData* action;
};

struct _Block33Data {
	int _ref_count_;
	Block32Data * _data32_;
	GList* g;
};

struct _Block34Data {
	int _ref_count_;
	FilesUndoManager* self;
	GList* trash;
};

static gpointer files_undo_action_data_parent_class = NULL;
static gint FilesUndoManager_private_offset;
static gpointer files_undo_manager_parent_class = NULL;
static FilesUndoManager* files_undo_manager__instance;
static FilesUndoManager* files_undo_manager__instance = NULL;

static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static guint64* _uint64_dup (guint64* self);
static guint32* _uint32_dup (guint32* self);
VALA_EXTERN GHashTable* files_undo_action_data_retrieve_files_to_restore (FilesUndoActionData* self);
static void _g_object_unref0_ (gpointer var);
static gboolean _uint64_equal (const guint64 * s1,
                        const guint64 * s2);
static void files_undo_action_data_finalize (FilesUndoActionData * obj);
static GType files_undo_action_data_get_type_once (void);
static void _files_undo_action_data_unref0_ (gpointer var);
static inline void _g_queue_free__files_undo_action_data_unref0_ (GQueue* self);
static void files_undo_manager_undo_data_free (gpointer _data);
static gboolean files_undo_manager_undo_co (FilesUndoManagerUndoData* _data_);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
static FilesUndoActionData* files_undo_manager_stack_scroll_right (FilesUndoManager* self);
static void files_undo_manager_set_undo_redo_flag (FilesUndoManager* self,
                                            gboolean value);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void block23_data_unref (void * _userdata_);
static void ___lambda48_ (Block23Data* _data23_,
                   const gchar* uri);
static void ____lambda48__gfunc (gconstpointer data,
                          gpointer self);
static void files_undo_manager_undo_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_);
static void files_undo_manager_undo_redo_done_transfer (FilesUndoManager* self,
                                                 FilesUndoActionData* action);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static void ___lambda49_ (Block24Data* _data24_,
                   const gchar* uri);
static void ____lambda49__gfunc (gconstpointer data,
                          gpointer self);
static void ____lambda50_ (Block22Data* _data22_,
                    GFile* key,
                    const gchar* val);
static void _____lambda50__gh_func (gconstpointer key,
                             gconstpointer value,
                             gpointer self);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
static void ___lambda51_ (Block25Data* _data25_,
                   const gchar* uri);
static void ____lambda51__gfunc (gconstpointer data,
                          gpointer self);
static void files_undo_manager_redo_data_free (gpointer _data);
static gboolean files_undo_manager_redo_co (FilesUndoManagerRedoData* _data_);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
static FilesUndoActionData* files_undo_manager_stack_scroll_left (FilesUndoManager* self);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
static void ___lambda52_ (Block27Data* _data27_,
                   const gchar* uri);
static void ____lambda52__gfunc (gconstpointer data,
                          gpointer self);
static void files_undo_manager_redo_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
static void ___lambda53_ (Block28Data* _data28_,
                   const gchar* uri);
static void ____lambda53__gfunc (gconstpointer data,
                          gpointer self);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
static void ___lambda54_ (Block29Data* _data29_,
                   const gchar* uri);
static void ____lambda54__gfunc (gconstpointer data,
                          gpointer self);
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (void * _userdata_);
static void ____lambda55_ (Block30Data* _data30_,
                    const gchar* uri);
static void _____lambda55__gfunc (gconstpointer data,
                           gpointer self);
static void files_undo_manager_stack_push_action (FilesUndoManager* self,
                                           FilesUndoActionData* action);
static Block31Data* block31_data_ref (Block31Data* _data31_);
static void block31_data_unref (void * _userdata_);
static void files_undo_manager_clear_redo_actions (FilesUndoManager* self);
static GList* files_undo_manager_get_all_trashed_items (FilesUndoManager* self);
static void ___lambda57_ (Block31Data* _data31_,
                   FilesUndoActionData* action);
static Block32Data* block32_data_ref (Block32Data* _data32_);
static void block32_data_unref (void * _userdata_);
static Block33Data* block33_data_ref (Block33Data* _data33_);
static void block33_data_unref (void * _userdata_);
static void ___lambda58_ (Block33Data* _data33_,
                   const gchar* uri);
static void ____lambda58__gfunc (gconstpointer data,
                          gpointer self);
static gboolean files_undo_manager_is_destination_uri_action_partof_trashed (GList* trash,
                                                                      GList* g);
static void ____lambda57__gfunc (gconstpointer data,
                          gpointer self);
static void files_undo_manager_stack_clear_n_oldest (FilesUndoManager* self,
                                              guint n);
static void files_undo_manager_stack_fix_size (FilesUndoManager* self);
static FilesUndoActionData* files_undo_manager_get_next_redo_action (FilesUndoManager* self);
static FilesUndoActionData* files_undo_manager_get_next_undo_action (FilesUndoManager* self);
static Block34Data* block34_data_ref (Block34Data* _data34_);
static void block34_data_unref (void * _userdata_);
static void __lambda56_ (Block34Data* _data34_,
                  FilesUndoActionData* action);
static void ___lambda56__gfunc (gconstpointer data,
                         gpointer self);
static GObject * files_undo_manager_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void files_undo_manager_finalize (GObject * obj);
static GType files_undo_manager_get_type_once (void);
static void _vala_files_undo_manager_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_files_undo_manager_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

const gchar*
files_undo_action_type_to_undo_string (FilesUndoActionType self)
{
	const gchar* result;
	switch (self) {
		case MARLIN_UNDO_COPY:
		{
			result = _ ("Undo Copy");
			return result;
		}
		case MARLIN_UNDO_DUPLICATE:
		{
			result = _ ("Undo Duplicate");
			return result;
		}
		case MARLIN_UNDO_MOVE:
		{
			result = _ ("Undo Move");
			return result;
		}
		case MARLIN_UNDO_RENAME:
		{
			result = _ ("Undo Rename");
			return result;
		}
		case MARLIN_UNDO_CREATEEMPTYFILE:
		{
			result = _ ("Undo Create Empty File");
			return result;
		}
		case MARLIN_UNDO_CREATEFILEFROMTEMPLATE:
		{
			result = _ ("Undo Create File from Template");
			return result;
		}
		case MARLIN_UNDO_CREATEFOLDER:
		{
			result = _ ("Undo Create Folder");
			return result;
		}
		case MARLIN_UNDO_MOVETOTRASH:
		{
			result = _ ("Undo Move to Trash");
			return result;
		}
		case MARLIN_UNDO_CREATELINK:
		{
			result = _ ("Undo Create Link");
			return result;
		}
		case MARLIN_UNDO_RESTOREFROMTRASH:
		{
			result = _ ("Undo Restore from Trash");
			return result;
		}
		case MARLIN_UNDO_SETPERMISSIONS:
		{
			result = _ ("Undo Set Permissions");
			return result;
		}
		case MARLIN_UNDO_RECURSIVESETPERMISSIONS:
		{
			result = _ ("Undo Set Permissions Recursively");
			return result;
		}
		case MARLIN_UNDO_CHANGEOWNER:
		{
			result = _ ("Undo Change Owner");
			return result;
		}
		case MARLIN_UNDO_CHANGEGROUP:
		{
			result = _ ("Undo Change Group");
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

const gchar*
files_undo_action_type_to_redo_string (FilesUndoActionType self)
{
	const gchar* result;
	switch (self) {
		case MARLIN_UNDO_COPY:
		{
			result = _ ("Redo Copy");
			return result;
		}
		case MARLIN_UNDO_DUPLICATE:
		{
			result = _ ("Redo Duplicate");
			return result;
		}
		case MARLIN_UNDO_MOVE:
		{
			result = _ ("Redo Move");
			return result;
		}
		case MARLIN_UNDO_RENAME:
		{
			result = _ ("Redo Rename");
			return result;
		}
		case MARLIN_UNDO_CREATEEMPTYFILE:
		{
			result = _ ("Redo Create Empty File");
			return result;
		}
		case MARLIN_UNDO_CREATEFILEFROMTEMPLATE:
		{
			result = _ ("Redo Create File from Template");
			return result;
		}
		case MARLIN_UNDO_CREATEFOLDER:
		{
			result = _ ("Redo Create Folder");
			return result;
		}
		case MARLIN_UNDO_MOVETOTRASH:
		{
			result = _ ("Redo Move to Trash");
			return result;
		}
		case MARLIN_UNDO_CREATELINK:
		{
			result = _ ("Redo Create Link");
			return result;
		}
		case MARLIN_UNDO_RESTOREFROMTRASH:
		{
			result = _ ("Redo Restore from Trash");
			return result;
		}
		case MARLIN_UNDO_SETPERMISSIONS:
		{
			result = _ ("Redo Set Permissions");
			return result;
		}
		case MARLIN_UNDO_RECURSIVESETPERMISSIONS:
		{
			result = _ ("Redo Set Permissions Recursively");
			return result;
		}
		case MARLIN_UNDO_CHANGEOWNER:
		{
			result = _ ("Redo Change Owner");
			return result;
		}
		case MARLIN_UNDO_CHANGEGROUP:
		{
			result = _ ("Redo Change Group");
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

 G_GNUC_NO_INLINE static GType
files_undo_action_type_get_type_once (void)
{
	static const GEnumValue values[] = {{MARLIN_UNDO_COPY, "MARLIN_UNDO_COPY", "copy"}, {MARLIN_UNDO_DUPLICATE, "MARLIN_UNDO_DUPLICATE", "duplicate"}, {MARLIN_UNDO_MOVE, "MARLIN_UNDO_MOVE", "move"}, {MARLIN_UNDO_RENAME, "MARLIN_UNDO_RENAME", "rename"}, {MARLIN_UNDO_CREATEEMPTYFILE, "MARLIN_UNDO_CREATEEMPTYFILE", "createemptyfile"}, {MARLIN_UNDO_CREATEFILEFROMTEMPLATE, "MARLIN_UNDO_CREATEFILEFROMTEMPLATE", "createfilefromtemplate"}, {MARLIN_UNDO_CREATEFOLDER, "MARLIN_UNDO_CREATEFOLDER", "createfolder"}, {MARLIN_UNDO_MOVETOTRASH, "MARLIN_UNDO_MOVETOTRASH", "movetotrash"}, {MARLIN_UNDO_CREATELINK, "MARLIN_UNDO_CREATELINK", "createlink"}, {MARLIN_UNDO_RESTOREFROMTRASH, "MARLIN_UNDO_RESTOREFROMTRASH", "restorefromtrash"}, {MARLIN_UNDO_SETPERMISSIONS, "MARLIN_UNDO_SETPERMISSIONS", "setpermissions"}, {MARLIN_UNDO_RECURSIVESETPERMISSIONS, "MARLIN_UNDO_RECURSIVESETPERMISSIONS", "recursivesetpermissions"}, {MARLIN_UNDO_CHANGEOWNER, "MARLIN_UNDO_CHANGEOWNER", "changeowner"}, {MARLIN_UNDO_CHANGEGROUP, "MARLIN_UNDO_CHANGEGROUP", "changegroup"}, {0, NULL, NULL}};
	GType files_undo_action_type_type_id;
	files_undo_action_type_type_id = g_enum_register_static ("FilesUndoActionType", values);
	return files_undo_action_type_type_id;
}

GType
files_undo_action_type_get_type (void)
{
	static volatile gsize files_undo_action_type_type_id__once = 0;
	if (g_once_init_enter (&files_undo_action_type_type_id__once)) {
		GType files_undo_action_type_type_id;
		files_undo_action_type_type_id = files_undo_action_type_get_type_once ();
		g_once_init_leave (&files_undo_action_type_type_id__once, files_undo_action_type_type_id);
	}
	return files_undo_action_type_type_id__once;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

FilesUndoActionData*
files_undo_action_data_construct (GType object_type,
                                  FilesUndoActionType action_type,
                                  gint items_count)
{
	FilesUndoActionData* self = NULL;
	FilesUndoManager* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	self = (FilesUndoActionData*) g_type_create_instance (object_type);
	self->action_type = action_type;
	self->count = (guint) items_count;
	if (action_type == MARLIN_UNDO_MOVETOTRASH) {
		GHashFunc _tmp0_;
		GEqualFunc _tmp1_;
		GHashTable* _tmp2_;
		_tmp0_ = g_str_hash;
		_tmp1_ = g_str_equal;
		_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
		_g_hash_table_unref0 (self->trashed);
		self->trashed = _tmp2_;
	}
	_tmp3_ = files_undo_manager_instance ();
	_tmp4_ = files_undo_manager_get_undo_redo_flag (_tmp3_);
	_tmp5_ = _tmp4_;
	self->is_valid = !_tmp5_;
	return self;
}

FilesUndoActionData*
files_undo_action_data_new (FilesUndoActionType action_type,
                            gint items_count)
{
	return files_undo_action_data_construct (FILES_TYPE_UNDO_ACTION_DATA, action_type, items_count);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
files_undo_action_data_set_src_dir (FilesUndoActionData* self,
                                    GFile* src)
{
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (src != NULL);
	_tmp0_ = _g_object_ref0 (src);
	_g_object_unref0 (self->src_dir);
	self->src_dir = _tmp0_;
}

void
files_undo_action_data_set_dest_dir (FilesUndoActionData* self,
                                     GFile* dest)
{
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dest != NULL);
	_tmp0_ = _g_object_ref0 (dest);
	_g_object_unref0 (self->dest_dir);
	self->dest_dir = _tmp0_;
}

void
files_undo_action_data_add_origin_target_pair (FilesUndoActionData* self,
                                               GFile* origin,
                                               GFile* target)
{
	GFile* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (origin != NULL);
	g_return_if_fail (target != NULL);
	_tmp0_ = self->src_dir;
	_tmp1_ = g_file_get_relative_path (_tmp0_, origin);
	self->sources = g_list_prepend (self->sources, _tmp1_);
	_tmp2_ = self->dest_dir;
	_tmp3_ = g_file_get_relative_path (_tmp2_, target);
	self->destinations = g_list_prepend (self->destinations, _tmp3_);
}

void
files_undo_action_data_set_create_data (FilesUndoActionData* self,
                                        const gchar* target_uri,
                                        const gchar* template)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target_uri != NULL);
	_tmp0_ = g_strdup (template);
	_g_free0 (self->template);
	self->template = _tmp0_;
	_tmp1_ = g_strdup (target_uri);
	_g_free0 (self->target_uri);
	self->target_uri = _tmp1_;
}

void
files_undo_action_data_set_rename_information (FilesUndoActionData* self,
                                               GFile* old_file,
                                               GFile* new_file)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_file != NULL);
	g_return_if_fail (new_file != NULL);
	_tmp0_ = g_file_get_uri (old_file);
	_g_free0 (self->old_uri);
	self->old_uri = _tmp0_;
	_tmp1_ = g_file_get_uri (new_file);
	_g_free0 (self->new_uri);
	self->new_uri = _tmp1_;
}

static guint64*
_uint64_dup (guint64* self)
{
	guint64* dup;
	dup = g_new0 (guint64, 1);
	memcpy (dup, self, sizeof (guint64));
	return dup;
}

static gpointer
__uint64_dup0 (gpointer self)
{
	return self ? _uint64_dup (self) : NULL;
}

void
files_undo_action_data_add_trashed_file (FilesUndoActionData* self,
                                         GFile* file,
                                         guint64 mtime)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	guint64* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->trashed;
	_tmp1_ = g_file_get_uri (file);
	_tmp2_ = __uint64_dup0 (&mtime);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
}

static guint32*
_uint32_dup (guint32* self)
{
	guint32* dup;
	dup = g_new0 (guint32, 1);
	memcpy (dup, self, sizeof (guint32));
	return dup;
}

static gpointer
__uint32_dup0 (gpointer self)
{
	return self ? _uint32_dup (self) : NULL;
}

void
files_undo_action_data_add_file_permissions (FilesUndoActionData* self,
                                             GFile* file,
                                             guint32 permission)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	guint32* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->original_permissions;
	_tmp1_ = g_file_get_uri (file);
	_tmp2_ = __uint32_dup0 (&permission);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
}

void
files_undo_action_data_set_recursive_permissions (FilesUndoActionData* self,
                                                  guint32 file_permissions,
                                                  guint32 file_mask,
                                                  guint32 dir_permissions,
                                                  guint32 dir_mask)
{
	g_return_if_fail (self != NULL);
	self->file_permissions = file_permissions;
	self->file_mask = file_mask;
	self->dir_permissions = dir_permissions;
	self->dir_mask = dir_mask;
}

void
files_undo_action_data_set_file_permissions (FilesUndoActionData* self,
                                             const gchar* uri,
                                             guint32 current_permissions,
                                             guint32 new_permissions)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_strdup (uri);
	_g_free0 (self->target_uri);
	self->target_uri = _tmp0_;
	self->current_permissions = current_permissions;
	self->new_permissions = new_permissions;
}

void
files_undo_action_data_set_owner_change_information (FilesUndoActionData* self,
                                                     const gchar* uri,
                                                     const gchar* current_user,
                                                     const gchar* new_user)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (current_user != NULL);
	g_return_if_fail (new_user != NULL);
	_tmp0_ = g_strdup (uri);
	_g_free0 (self->target_uri);
	self->target_uri = _tmp0_;
	_tmp1_ = g_strdup (current_user);
	_g_free0 (self->original_user_name_or_id);
	self->original_user_name_or_id = _tmp1_;
	_tmp2_ = g_strdup (new_user);
	_g_free0 (self->new_user_name_or_id);
	self->new_user_name_or_id = _tmp2_;
}

void
files_undo_action_data_set_group_change_information (FilesUndoActionData* self,
                                                     const gchar* uri,
                                                     const gchar* current_group,
                                                     const gchar* new_group)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (current_group != NULL);
	g_return_if_fail (new_group != NULL);
	_tmp0_ = g_strdup (uri);
	_g_free0 (self->target_uri);
	self->target_uri = _tmp0_;
	_tmp1_ = g_strdup (current_group);
	_g_free0 (self->original_group_name_or_id);
	self->original_group_name_or_id = _tmp1_;
	_tmp2_ = g_strdup (new_group);
	_g_free0 (self->new_group_name_or_id);
	self->new_group_name_or_id = _tmp2_;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gboolean
_uint64_equal (const guint64 * s1,
               const guint64 * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

GHashTable*
files_undo_action_data_retrieve_files_to_restore (FilesUndoActionData* self)
{
	GHashTable* _tmp0_;
	GHashTable* to_restore = NULL;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GFile* trash = NULL;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	GHashTable* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->trashed;
	if (g_hash_table_size (_tmp0_) <= ((guint) 0)) {
		result = NULL;
		return result;
	}
	_tmp1_ = g_direct_hash;
	_tmp2_ = g_direct_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_object_unref0_, _g_free0_);
	to_restore = _tmp3_;
	_tmp4_ = g_file_new_for_uri ("trash:");
	trash = _tmp4_;
	{
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp5_;
		GFileEnumerator* _tmp6_;
		GFileInfo* info = NULL;
		_tmp5_ = trash;
		_tmp6_ = g_file_enumerate_children (_tmp5_, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_TIME_MODIFIED "," G_FILE_ATTRIBUTE_TRASH_ORIG_PATH, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
		enumerator = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		info = NULL;
		while (TRUE) {
			GFileInfo* _tmp7_ = NULL;
			GFileEnumerator* _tmp8_;
			GFileInfo* _tmp9_;
			GFileInfo* _tmp10_;
			GFileInfo* _tmp11_;
			const gchar* origpath = NULL;
			GFileInfo* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp8_ = enumerator;
			_tmp9_ = g_file_enumerator_next_file (_tmp8_, NULL, &_inner_error0_);
			_tmp7_ = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_tmp10_ = _tmp7_;
			_tmp7_ = NULL;
			_g_object_unref0 (info);
			info = _tmp10_;
			_tmp11_ = info;
			if (!(_tmp11_ != NULL)) {
				_g_object_unref0 (_tmp7_);
				break;
			}
			_tmp12_ = info;
			_tmp13_ = g_file_info_get_attribute_byte_string (_tmp12_, G_FILE_ATTRIBUTE_TRASH_ORIG_PATH);
			origpath = _tmp13_;
			_tmp14_ = origpath;
			if (_tmp14_ != NULL) {
				GFile* origfile = NULL;
				const gchar* _tmp15_;
				GFile* _tmp16_;
				gchar* origuri = NULL;
				GFile* _tmp17_;
				gchar* _tmp18_;
				guint64* mtime = NULL;
				GHashTable* _tmp19_;
				const gchar* _tmp20_;
				gconstpointer _tmp21_;
				guint64* _tmp22_;
				guint64* _tmp23_;
				_tmp15_ = origpath;
				_tmp16_ = g_file_new_for_path (_tmp15_);
				origfile = _tmp16_;
				_tmp17_ = origfile;
				_tmp18_ = g_file_get_uri (_tmp17_);
				origuri = _tmp18_;
				_tmp19_ = self->trashed;
				_tmp20_ = origuri;
				_tmp21_ = g_hash_table_lookup (_tmp19_, _tmp20_);
				_tmp22_ = __uint64_dup0 ((guint64*) _tmp21_);
				mtime = _tmp22_;
				_tmp23_ = mtime;
				if (_tmp23_ != NULL) {
					guint64 mtime_item = 0ULL;
					GFileInfo* _tmp24_;
					guint64* _tmp25_;
					_tmp24_ = info;
					mtime_item = g_file_info_get_attribute_uint64 (_tmp24_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
					_tmp25_ = mtime;
					if (_uint64_equal (_tmp25_, &mtime_item) == TRUE) {
						GHashTable* _tmp26_;
						GFile* _tmp27_;
						GFileInfo* _tmp28_;
						const gchar* _tmp29_;
						GFile* _tmp30_;
						const gchar* _tmp31_;
						gchar* _tmp32_;
						_tmp26_ = to_restore;
						_tmp27_ = trash;
						_tmp28_ = info;
						_tmp29_ = g_file_info_get_name (_tmp28_);
						_tmp30_ = g_file_get_child (_tmp27_, _tmp29_);
						_tmp31_ = origuri;
						_tmp32_ = g_strdup (_tmp31_);
						g_hash_table_insert (_tmp26_, _tmp30_, _tmp32_);
					}
				}
				_g_free0 (mtime);
				_g_free0 (origuri);
				_g_object_unref0 (origfile);
			}
			_g_object_unref0 (_tmp7_);
		}
		_g_object_unref0 (info);
		_g_object_unref0 (enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp33_;
		const gchar* _tmp34_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp33_ = e;
		_tmp34_ = _tmp33_->message;
		g_critical ("UndoManager.vala:241: %s", _tmp34_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (trash);
		_g_hash_table_unref0 (to_restore);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = to_restore;
	_g_object_unref0 (trash);
	return result;
}

static void
files_value_undo_action_data_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
files_value_undo_action_data_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		files_undo_action_data_unref (value->data[0].v_pointer);
	}
}

static void
files_value_undo_action_data_copy_value (const GValue* src_value,
                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = files_undo_action_data_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
files_value_undo_action_data_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
files_value_undo_action_data_collect_value (GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FilesUndoActionData * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = files_undo_action_data_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
files_value_undo_action_data_lcopy_value (const GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	FilesUndoActionData ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = files_undo_action_data_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
files_param_spec_undo_action_data (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags)
{
	FilesParamSpecUndoActionData* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FILES_TYPE_UNDO_ACTION_DATA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
files_value_get_undo_action_data (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FILES_TYPE_UNDO_ACTION_DATA), NULL);
	return value->data[0].v_pointer;
}

void
files_value_set_undo_action_data (GValue* value,
                                  gpointer v_object)
{
	FilesUndoActionData * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FILES_TYPE_UNDO_ACTION_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FILES_TYPE_UNDO_ACTION_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		files_undo_action_data_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		files_undo_action_data_unref (old);
	}
}

void
files_value_take_undo_action_data (GValue* value,
                                   gpointer v_object)
{
	FilesUndoActionData * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FILES_TYPE_UNDO_ACTION_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FILES_TYPE_UNDO_ACTION_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		files_undo_action_data_unref (old);
	}
}

static void
files_undo_action_data_class_init (FilesUndoActionDataClass * klass,
                                   gpointer klass_data)
{
	files_undo_action_data_parent_class = g_type_class_peek_parent (klass);
	((FilesUndoActionDataClass *) klass)->finalize = files_undo_action_data_finalize;
}

static void
files_undo_action_data_instance_init (FilesUndoActionData * self,
                                      gpointer klass)
{
	self->ref_count = 1;
}

static void
files_undo_action_data_finalize (FilesUndoActionData * obj)
{
	FilesUndoActionData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_UNDO_ACTION_DATA, FilesUndoActionData);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->src_dir);
	_g_object_unref0 (self->dest_dir);
	(self->sources == NULL) ? NULL : (self->sources = (_g_list_free__g_free0_ (self->sources), NULL));
	(self->destinations == NULL) ? NULL : (self->destinations = (_g_list_free__g_free0_ (self->destinations), NULL));
	_g_free0 (self->undo_label);
	_g_free0 (self->undo_description);
	_g_free0 (self->redo_label);
	_g_free0 (self->redo_description);
	_g_free0 (self->template);
	_g_free0 (self->target_uri);
	_g_free0 (self->old_uri);
	_g_free0 (self->new_uri);
	_g_hash_table_unref0 (self->trashed);
	_g_hash_table_unref0 (self->original_permissions);
	_g_free0 (self->original_group_name_or_id);
	_g_free0 (self->new_group_name_or_id);
	_g_free0 (self->original_user_name_or_id);
	_g_free0 (self->new_user_name_or_id);
}

 G_GNUC_NO_INLINE static GType
files_undo_action_data_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { files_value_undo_action_data_init, files_value_undo_action_data_free_value, files_value_undo_action_data_copy_value, files_value_undo_action_data_peek_pointer, "p", files_value_undo_action_data_collect_value, "p", files_value_undo_action_data_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FilesUndoActionDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_undo_action_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesUndoActionData), 0, (GInstanceInitFunc) files_undo_action_data_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType files_undo_action_data_type_id;
	files_undo_action_data_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FilesUndoActionData", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return files_undo_action_data_type_id;
}

GType
files_undo_action_data_get_type (void)
{
	static volatile gsize files_undo_action_data_type_id__once = 0;
	if (g_once_init_enter (&files_undo_action_data_type_id__once)) {
		GType files_undo_action_data_type_id;
		files_undo_action_data_type_id = files_undo_action_data_get_type_once ();
		g_once_init_leave (&files_undo_action_data_type_id__once, files_undo_action_data_type_id);
	}
	return files_undo_action_data_type_id__once;
}

gpointer
files_undo_action_data_ref (gpointer instance)
{
	FilesUndoActionData * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
files_undo_action_data_unref (gpointer instance)
{
	FilesUndoActionData * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FILES_UNDO_ACTION_DATA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
files_undo_manager_get_instance_private (FilesUndoManager* self)
{
	return G_STRUCT_MEMBER_P (self, FilesUndoManager_private_offset);
}

static void
_files_undo_action_data_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (files_undo_action_data_unref (var), NULL));
}

static inline void
_g_queue_free__files_undo_action_data_unref0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _files_undo_action_data_unref0_);
}

FilesUndoManager*
files_undo_manager_instance (void)
{
	FilesUndoManager* _tmp0_;
	FilesUndoManager* _tmp2_;
	FilesUndoManager* result;
	_tmp0_ = files_undo_manager__instance;
	if (_tmp0_ == NULL) {
		FilesUndoManager* _tmp1_;
		_tmp1_ = files_undo_manager_new ();
		_g_object_unref0 (files_undo_manager__instance);
		files_undo_manager__instance = _tmp1_;
	}
	_tmp2_ = files_undo_manager__instance;
	result = _tmp2_;
	return result;
}

static void
files_undo_manager_undo_data_free (gpointer _data)
{
	FilesUndoManagerUndoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->widget);
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesUndoManagerUndoData, _data_);
}

void
files_undo_manager_undo (FilesUndoManager* self,
                         GtkWidget* widget,
                         GCancellable* cancellable,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	FilesUndoManagerUndoData* _data_;
	FilesUndoManager* _tmp0_;
	GtkWidget* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_data_ = g_slice_new0 (FilesUndoManagerUndoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_undo_manager_undo_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (widget);
	_g_object_unref0 (_data_->widget);
	_data_->widget = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	files_undo_manager_undo_co (_data_);
}

gboolean
files_undo_manager_undo_finish (FilesUndoManager* self,
                                GAsyncResult* _res_,
                                GError** error)
{
	gboolean result;
	FilesUndoManagerUndoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		FilesUndoManager* self;
		self = _data22_->self;
		_files_undo_action_data_unref0 (_data22_->action);
		_g_object_unref0 (_data22_->cancellable);
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}

static gpointer
_files_undo_action_data_ref0 (gpointer self)
{
	return self ? files_undo_action_data_ref (self) : NULL;
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		FilesUndoManager* self;
		self = _data23_->_data22_->self;
		(_data23_->uris == NULL) ? NULL : (_data23_->uris = (_g_list_free__g_object_unref0_ (_data23_->uris), NULL));
		block22_data_unref (_data23_->_data22_);
		_data23_->_data22_ = NULL;
		g_slice_free (Block23Data, _data23_);
	}
}

static void
___lambda48_ (Block23Data* _data23_,
              const gchar* uri)
{
	Block22Data* _data22_;
	FilesUndoManager* self;
	FilesUndoActionData* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	_data22_ = _data23_->_data22_;
	self = _data22_->self;
	g_return_if_fail (uri != NULL);
	_tmp0_ = _data22_->action;
	_tmp1_ = _tmp0_->dest_dir;
	_tmp2_ = g_file_get_child (_tmp1_, uri);
	_data23_->uris = g_list_prepend (_data23_->uris, _tmp2_);
}

static void
____lambda48__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda48_ (self, (const gchar*) data);
}

static void
files_undo_manager_undo_ready (GObject* source_object,
                               GAsyncResult* _res_,
                               gpointer _user_data_)
{
	FilesUndoManagerUndoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	files_undo_manager_undo_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}

static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		FilesUndoManager* self;
		self = _data24_->_data22_->self;
		(_data24_->uris == NULL) ? NULL : (_data24_->uris = (_g_list_free__g_object_unref0_ (_data24_->uris), NULL));
		block22_data_unref (_data24_->_data22_);
		_data24_->_data22_ = NULL;
		g_slice_free (Block24Data, _data24_);
	}
}

static void
___lambda49_ (Block24Data* _data24_,
              const gchar* uri)
{
	Block22Data* _data22_;
	FilesUndoManager* self;
	FilesUndoActionData* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	_data22_ = _data24_->_data22_;
	self = _data22_->self;
	g_return_if_fail (uri != NULL);
	_tmp0_ = _data22_->action;
	_tmp1_ = _tmp0_->dest_dir;
	_tmp2_ = g_file_get_child (_tmp1_, uri);
	_data24_->uris = g_list_prepend (_data24_->uris, _tmp2_);
}

static void
____lambda49__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda49_ (self, (const gchar*) data);
}

static void
____lambda50_ (Block22Data* _data22_,
               GFile* key,
               const gchar* val)
{
	FilesUndoManager* self;
	GFile* dest = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = _data22_->self;
	g_return_if_fail (key != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = g_file_new_for_uri (val);
	dest = _tmp0_;
	{
		g_file_move (key, dest, G_FILE_COPY_NOFOLLOW_SYMLINKS, _data22_->cancellable, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		files_file_changes_queue_file_moved (key, dest);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("UndoManager.vala:374: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (dest);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (dest);
}

static void
_____lambda50__gh_func (gconstpointer key,
                        gconstpointer value,
                        gpointer self)
{
	____lambda50_ (self, (GFile*) key, (const gchar*) value);
}

static Block25Data*
block25_data_ref (Block25Data* _data25_)
{
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}

static void
block25_data_unref (void * _userdata_)
{
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		FilesUndoManager* self;
		self = _data25_->_data22_->self;
		(_data25_->uris == NULL) ? NULL : (_data25_->uris = (_g_list_free__g_object_unref0_ (_data25_->uris), NULL));
		block22_data_unref (_data25_->_data22_);
		_data25_->_data22_ = NULL;
		g_slice_free (Block25Data, _data25_);
	}
}

static void
___lambda51_ (Block25Data* _data25_,
              const gchar* uri)
{
	Block22Data* _data22_;
	FilesUndoManager* self;
	FilesUndoActionData* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	_data22_ = _data25_->_data22_;
	self = _data22_->self;
	g_return_if_fail (uri != NULL);
	_tmp0_ = _data22_->action;
	_tmp1_ = _tmp0_->dest_dir;
	_tmp2_ = g_file_get_child (_tmp1_, uri);
	_data25_->uris = g_list_prepend (_data25_->uris, _tmp2_);
}

static void
____lambda51__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda51_ (self, (const gchar*) data);
}

static gboolean
files_undo_manager_undo_co (FilesUndoManagerUndoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data22_ = g_slice_new0 (Block22Data);
	_data_->_data22_->_ref_count_ = 1;
	_data_->_data22_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data22_->cancellable);
	_data_->_data22_->cancellable = _data_->cancellable;
	_data_->_data22_->_async_data_ = _data_;
	_data_->_data22_->action = NULL;
	{
		_data_->_tmp0_ = _data_->self->priv->stack;
		g_rec_mutex_lock (&_data_->self->priv->__lock_stack);
		{
			_data_->_tmp1_ = files_undo_manager_stack_scroll_right (_data_->self);
			_data_->_tmp2_ = _files_undo_action_data_ref0 (_data_->_tmp1_);
			_files_undo_action_data_unref0 (_data_->_data22_->action);
			_data_->_data22_->action = _data_->_tmp2_;
			_data_->_tmp3_ = _data_->_data22_->action;
			if (_data_->_tmp3_ != NULL) {
				_data_->_tmp4_ = _data_->_data22_->action;
				_data_->_tmp4_->locked = TRUE;
			}
		}
		__finally0:
		{
			_data_->_tmp5_ = _data_->self->priv->stack;
			g_rec_mutex_unlock (&_data_->self->priv->__lock_stack);
		}
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block22_data_unref (_data_->_data22_);
			_data_->_data22_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_signal_emit (_data_->self, files_undo_manager_signals[FILES_UNDO_MANAGER_REQUEST_MENU_UPDATE_SIGNAL], 0);
	_data_->_tmp6_ = _data_->_data22_->action;
	if (_data_->_tmp6_ == NULL) {
		_data_->result = TRUE;
		block22_data_unref (_data_->_data22_);
		_data_->_data22_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	files_undo_manager_set_undo_redo_flag (_data_->self, TRUE);
	_data_->_tmp7_ = _data_->_data22_->action;
	switch (_data_->_tmp7_->action_type) {
		case MARLIN_UNDO_COPY:
		case MARLIN_UNDO_DUPLICATE:
		case MARLIN_UNDO_CREATELINK:
		{
			_data_->_data23_ = g_slice_new0 (Block23Data);
			_data_->_data23_->_ref_count_ = 1;
			_data_->_data23_->_data22_ = block22_data_ref (_data_->_data22_);
			_data_->_data23_->uris = NULL;
			_data_->_tmp8_ = _data_->_data22_->action;
			_data_->_tmp9_ = _data_->_tmp8_->destinations;
			g_list_foreach (_data_->_tmp9_, ____lambda48__gfunc, _data_->_data23_);
			_data_->_data23_->uris = g_list_reverse (_data_->_data23_->uris);
			_data_->_tmp11_ = _data_->_data23_->uris;
			if (_data_->_tmp11_ != NULL) {
				_data_->_tmp12_ = _data_->self->priv->_confirm_delete;
				_data_->_tmp10_ = _data_->_tmp12_;
			} else {
				_data_->_tmp10_ = FALSE;
			}
			if (_data_->_tmp10_) {
				{
					_data_->_tmp13_ = _data_->_data23_->uris;
					_data_->_tmp14_ = gtk_widget_get_toplevel (_data_->widget);
					_data_->_state_ = 1;
					marlin_file_operations_delete (_data_->_tmp13_, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp14_, gtk_window_get_type ()) ? ((GtkWindow*) _data_->_tmp14_) : NULL, FALSE, _data_->_data22_->cancellable, files_undo_manager_undo_ready, _data_);
					return FALSE;
					_state_1:
					marlin_file_operations_delete_finish (_data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					_data_->e = _data_->_inner_error0_;
					_data_->_inner_error0_ = NULL;
					_data_->_tmp15_ = _data_->_data22_->action;
					files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp15_);
					_data_->_tmp16_ = _data_->e;
					_data_->_tmp17_ = _g_error_copy0 (_data_->_tmp16_);
					_data_->_inner_error0_ = _data_->_tmp17_;
					_g_error_free0 (_data_->e);
					goto __finally1;
				}
				__finally1:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					block23_data_unref (_data_->_data23_);
					_data_->_data23_ = NULL;
					block22_data_unref (_data_->_data22_);
					_data_->_data22_ = NULL;
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			} else {
				_data_->_tmp18_ = _data_->_data23_->uris;
				{
					_data_->file_collection = _data_->_tmp18_;
					for (_data_->file_it = _data_->file_collection; _data_->file_it != NULL; _data_->file_it = _data_->file_it->next) {
						_data_->file = (GFile*) _data_->file_it->data;
						{
							_data_->_tmp19_ = _data_->file;
							_data_->_state_ = 2;
							g_file_delete_async (_data_->_tmp19_, G_PRIORITY_DEFAULT, _data_->_data22_->cancellable, files_undo_manager_undo_ready, _data_);
							return FALSE;
							_state_2:
							g_file_delete_finish (_data_->_tmp19_, _data_->_res_, &_data_->_inner_error0_);
							if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
								g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
								block23_data_unref (_data_->_data23_);
								_data_->_data23_ = NULL;
								block22_data_unref (_data_->_data22_);
								_data_->_data22_ = NULL;
								g_object_unref (_data_->_async_result);
								return FALSE;
							}
							_data_->_tmp20_ = _data_->file;
							files_file_changes_queue_file_removed (_data_->_tmp20_);
						}
					}
				}
				files_file_changes_consume_changes (TRUE);
			}
			_data_->_tmp21_ = _data_->_data22_->action;
			files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp21_);
			block23_data_unref (_data_->_data23_);
			_data_->_data23_ = NULL;
			break;
		}
		case MARLIN_UNDO_MOVE:
		{
			_data_->_data24_ = g_slice_new0 (Block24Data);
			_data_->_data24_->_ref_count_ = 1;
			_data_->_data24_->_data22_ = block22_data_ref (_data_->_data22_);
			_data_->_data24_->uris = NULL;
			_data_->_tmp22_ = _data_->_data22_->action;
			_data_->_tmp23_ = _data_->_tmp22_->destinations;
			g_list_foreach (_data_->_tmp23_, ____lambda49__gfunc, _data_->_data24_);
			_data_->_tmp24_ = _data_->_data24_->uris;
			if (_data_->_tmp24_ != NULL) {
				{
					_data_->_tmp25_ = _data_->_data24_->uris;
					_data_->_tmp26_ = _data_->_data22_->action;
					_data_->_tmp27_ = _data_->_tmp26_->src_dir;
					_data_->_state_ = 3;
					marlin_file_operations_copy_move_link (_data_->_tmp25_, _data_->_tmp27_, GDK_ACTION_MOVE, _data_->widget, _data_->_data22_->cancellable, files_undo_manager_undo_ready, _data_);
					return FALSE;
					_state_3:
					marlin_file_operations_copy_move_link_finish (_data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						goto __catch2_g_error;
					}
				}
				goto __finally2;
				__catch2_g_error:
				{
					_data_->_vala1_e = _data_->_inner_error0_;
					_data_->_inner_error0_ = NULL;
					_data_->_tmp28_ = _data_->_data22_->action;
					files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp28_);
					_data_->_tmp29_ = _data_->_vala1_e;
					_data_->_tmp30_ = _g_error_copy0 (_data_->_tmp29_);
					_data_->_inner_error0_ = _data_->_tmp30_;
					_g_error_free0 (_data_->_vala1_e);
					goto __finally2;
				}
				__finally2:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					block24_data_unref (_data_->_data24_);
					_data_->_data24_ = NULL;
					block22_data_unref (_data_->_data22_);
					_data_->_data22_ = NULL;
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_data_->_tmp31_ = _data_->_data22_->action;
			files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp31_);
			block24_data_unref (_data_->_data24_);
			_data_->_data24_ = NULL;
			break;
		}
		case MARLIN_UNDO_RENAME:
		{
			_data_->_tmp32_ = _data_->_data22_->action;
			_data_->_tmp33_ = _data_->_tmp32_->new_uri;
			_data_->_tmp34_ = files_file_utils_get_file_for_path (_data_->_tmp33_);
			_data_->_vala1_file = _data_->_tmp34_;
			_data_->_tmp35_ = _data_->_data22_->action;
			_data_->_tmp36_ = _data_->_tmp35_->old_uri;
			_data_->_tmp37_ = files_file_utils_get_file_for_path (_data_->_tmp36_);
			_data_->_tmp38_ = _data_->_tmp37_;
			_data_->_tmp39_ = g_file_get_basename (_data_->_tmp38_);
			_data_->_tmp40_ = _data_->_tmp39_;
			_g_object_unref0 (_data_->_tmp38_);
			_data_->new_name = _data_->_tmp40_;
			{
				_data_->_tmp41_ = _data_->_vala1_file;
				_data_->_tmp42_ = _data_->new_name;
				_data_->_state_ = 4;
				files_file_utils_set_file_display_name (_data_->_tmp41_, _data_->_tmp42_, _data_->_data22_->cancellable, files_undo_manager_undo_ready, _data_);
				return FALSE;
				_state_4:
				_data_->_tmp43_ = files_file_utils_set_file_display_name_finish (_data_->_res_, &_data_->_inner_error0_);
				_data_->_tmp44_ = _data_->_tmp43_;
				_g_object_unref0 (_data_->_tmp44_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch3_g_error;
				}
			}
			goto __finally3;
			__catch3_g_error:
			{
				_data_->_vala2_e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp45_ = _data_->_data22_->action;
				files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp45_);
				_data_->_tmp46_ = _data_->_vala2_e;
				_data_->_tmp47_ = _g_error_copy0 (_data_->_tmp46_);
				_data_->_inner_error0_ = _data_->_tmp47_;
				_g_error_free0 (_data_->_vala2_e);
				goto __finally3;
			}
			__finally3:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_free0 (_data_->new_name);
				_g_object_unref0 (_data_->_vala1_file);
				block22_data_unref (_data_->_data22_);
				_data_->_data22_ = NULL;
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp48_ = _data_->_data22_->action;
			files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp48_);
			_g_free0 (_data_->new_name);
			_g_object_unref0 (_data_->_vala1_file);
			break;
		}
		case MARLIN_UNDO_CREATEEMPTYFILE:
		case MARLIN_UNDO_CREATEFOLDER:
		case MARLIN_UNDO_CREATEFILEFROMTEMPLATE:
		{
			_data_->uris = NULL;
			_data_->_tmp49_ = _data_->_data22_->action;
			_data_->_tmp50_ = _data_->_tmp49_->target_uri;
			_data_->_tmp51_ = g_file_new_for_uri (_data_->_tmp50_);
			_data_->uris = g_list_prepend (_data_->uris, _data_->_tmp51_);
			_data_->_tmp53_ = _data_->uris;
			if (_data_->_tmp53_ != NULL) {
				_data_->_tmp54_ = _data_->self->priv->_confirm_delete;
				_data_->_tmp52_ = _data_->_tmp54_;
			} else {
				_data_->_tmp52_ = FALSE;
			}
			if (_data_->_tmp52_) {
				{
					_data_->_tmp55_ = _data_->uris;
					_data_->_tmp56_ = gtk_widget_get_toplevel (_data_->widget);
					_data_->_state_ = 5;
					marlin_file_operations_delete (_data_->_tmp55_, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp56_, gtk_window_get_type ()) ? ((GtkWindow*) _data_->_tmp56_) : NULL, FALSE, _data_->_data22_->cancellable, files_undo_manager_undo_ready, _data_);
					return FALSE;
					_state_5:
					marlin_file_operations_delete_finish (_data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						goto __catch4_g_error;
					}
				}
				goto __finally4;
				__catch4_g_error:
				{
					_data_->_vala3_e = _data_->_inner_error0_;
					_data_->_inner_error0_ = NULL;
					_data_->_tmp57_ = _data_->_data22_->action;
					files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp57_);
					_data_->_tmp58_ = _data_->_vala3_e;
					_data_->_tmp59_ = _g_error_copy0 (_data_->_tmp58_);
					_data_->_inner_error0_ = _data_->_tmp59_;
					_g_error_free0 (_data_->_vala3_e);
					goto __finally4;
				}
				__finally4:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					(_data_->uris == NULL) ? NULL : (_data_->uris = (_g_list_free__g_object_unref0_ (_data_->uris), NULL));
					block22_data_unref (_data_->_data22_);
					_data_->_data22_ = NULL;
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			} else {
				_data_->_tmp60_ = _data_->uris;
				{
					_data_->_vala1_file_collection = _data_->_tmp60_;
					for (_data_->_vala1_file_it = _data_->_vala1_file_collection; _data_->_vala1_file_it != NULL; _data_->_vala1_file_it = _data_->_vala1_file_it->next) {
						_data_->_vala2_file = (GFile*) _data_->_vala1_file_it->data;
						{
							_data_->_tmp61_ = _data_->_vala2_file;
							_data_->_state_ = 6;
							g_file_delete_async (_data_->_tmp61_, G_PRIORITY_DEFAULT, _data_->_data22_->cancellable, files_undo_manager_undo_ready, _data_);
							return FALSE;
							_state_6:
							g_file_delete_finish (_data_->_tmp61_, _data_->_res_, &_data_->_inner_error0_);
							if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
								g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
								(_data_->uris == NULL) ? NULL : (_data_->uris = (_g_list_free__g_object_unref0_ (_data_->uris), NULL));
								block22_data_unref (_data_->_data22_);
								_data_->_data22_ = NULL;
								g_object_unref (_data_->_async_result);
								return FALSE;
							}
							_data_->_tmp62_ = _data_->_vala2_file;
							files_file_changes_queue_file_removed (_data_->_tmp62_);
						}
					}
				}
				files_file_changes_consume_changes (TRUE);
			}
			_data_->_tmp63_ = _data_->_data22_->action;
			files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp63_);
			(_data_->uris == NULL) ? NULL : (_data_->uris = (_g_list_free__g_object_unref0_ (_data_->uris), NULL));
			break;
		}
		case MARLIN_UNDO_MOVETOTRASH:
		{
			_data_->_tmp64_ = _data_->_data22_->action;
			_data_->_tmp65_ = files_undo_action_data_retrieve_files_to_restore (_data_->_tmp64_);
			_data_->files_to_restore = _data_->_tmp65_;
			_data_->_tmp66_ = _data_->files_to_restore;
			if (g_hash_table_size (_data_->_tmp66_) > ((guint) 0)) {
				_data_->_tmp67_ = _data_->files_to_restore;
				g_hash_table_foreach (_data_->_tmp67_, _____lambda50__gh_func, _data_->_data22_);
				files_file_changes_consume_changes (TRUE);
			} else {
				_data_->_tmp68_ = gtk_widget_get_toplevel (_data_->widget);
				_data_->_tmp69_ = pf_dialogs_show_error_dialog (_ ("Original location could not be determined"), _ ("Open trash folder and restore manually"), G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp68_, gtk_window_get_type ()) ? ((GtkWindow*) _data_->_tmp68_) : NULL);
				_data_->_tmp70_ = _data_->_tmp69_;
				_g_object_unref0 (_data_->_tmp70_);
			}
			_data_->_tmp71_ = _data_->_data22_->action;
			files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp71_);
			_g_hash_table_unref0 (_data_->files_to_restore);
			break;
		}
		case MARLIN_UNDO_RESTOREFROMTRASH:
		{
			_data_->_data25_ = g_slice_new0 (Block25Data);
			_data_->_data25_->_ref_count_ = 1;
			_data_->_data25_->_data22_ = block22_data_ref (_data_->_data22_);
			_data_->_data25_->uris = NULL;
			_data_->_tmp72_ = _data_->_data22_->action;
			_data_->_tmp73_ = _data_->_tmp72_->destinations;
			g_list_foreach (_data_->_tmp73_, ____lambda51__gfunc, _data_->_data25_);
			_data_->_tmp74_ = _data_->_data25_->uris;
			if (_data_->_tmp74_ != NULL) {
				{
					_data_->_tmp75_ = _data_->_data25_->uris;
					_data_->_tmp76_ = gtk_widget_get_toplevel (_data_->widget);
					_data_->_state_ = 7;
					marlin_file_operations_delete (_data_->_tmp75_, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp76_, gtk_window_get_type ()) ? ((GtkWindow*) _data_->_tmp76_) : NULL, TRUE, _data_->_data22_->cancellable, files_undo_manager_undo_ready, _data_);
					return FALSE;
					_state_7:
					marlin_file_operations_delete_finish (_data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						goto __catch5_g_error;
					}
				}
				goto __finally5;
				__catch5_g_error:
				{
					_data_->_vala4_e = _data_->_inner_error0_;
					_data_->_inner_error0_ = NULL;
					_data_->_tmp77_ = _data_->_data22_->action;
					files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp77_);
					_data_->_tmp78_ = _data_->_vala4_e;
					_data_->_tmp79_ = _g_error_copy0 (_data_->_tmp78_);
					_data_->_inner_error0_ = _data_->_tmp79_;
					_g_error_free0 (_data_->_vala4_e);
					goto __finally5;
				}
				__finally5:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					block25_data_unref (_data_->_data25_);
					_data_->_data25_ = NULL;
					block22_data_unref (_data_->_data22_);
					_data_->_data22_ = NULL;
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_data_->_tmp80_ = _data_->_data22_->action;
			files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp80_);
			block25_data_unref (_data_->_data25_);
			_data_->_data25_ = NULL;
			break;
		}
		default:
		{
			_data_->_tmp81_ = _data_->_data22_->action;
			_data_->_tmp82_ = g_enum_to_string (FILES_TYPE_UNDO_ACTION_TYPE, _data_->_tmp81_->action_type);
			g_warning ("UndoManager.vala:404: Ignoring request to undo irreversible or unknown" \
" action %s", _data_->_tmp82_);
			_g_free0 (_data_->_tmp82_);
			files_undo_manager_set_undo_redo_flag (_data_->self, FALSE);
			break;
		}
	}
	_data_->result = TRUE;
	block22_data_unref (_data_->_data22_);
	_data_->_data22_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
files_undo_manager_redo_data_free (gpointer _data)
{
	FilesUndoManagerRedoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->widget);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesUndoManagerRedoData, _data_);
}

void
files_undo_manager_redo (FilesUndoManager* self,
                         GtkWidget* widget,
                         GCancellable* cancellable,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	FilesUndoManagerRedoData* _data_;
	FilesUndoManager* _tmp0_;
	GtkWidget* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_data_ = g_slice_new0 (FilesUndoManagerRedoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_undo_manager_redo_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (widget);
	_g_object_unref0 (_data_->widget);
	_data_->widget = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	files_undo_manager_redo_co (_data_);
}

gboolean
files_undo_manager_redo_finish (FilesUndoManager* self,
                                GAsyncResult* _res_,
                                GError** error)
{
	gboolean result;
	FilesUndoManagerRedoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static Block26Data*
block26_data_ref (Block26Data* _data26_)
{
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}

static void
block26_data_unref (void * _userdata_)
{
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		FilesUndoManager* self;
		self = _data26_->self;
		_files_undo_action_data_unref0 (_data26_->action);
		_g_object_unref0 (self);
		g_slice_free (Block26Data, _data26_);
	}
}

static Block27Data*
block27_data_ref (Block27Data* _data27_)
{
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}

static void
block27_data_unref (void * _userdata_)
{
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		FilesUndoManager* self;
		self = _data27_->_data26_->self;
		(_data27_->uris == NULL) ? NULL : (_data27_->uris = (_g_list_free__g_object_unref0_ (_data27_->uris), NULL));
		block26_data_unref (_data27_->_data26_);
		_data27_->_data26_ = NULL;
		g_slice_free (Block27Data, _data27_);
	}
}

static void
___lambda52_ (Block27Data* _data27_,
              const gchar* uri)
{
	Block26Data* _data26_;
	FilesUndoManager* self;
	FilesUndoActionData* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	_data26_ = _data27_->_data26_;
	self = _data26_->self;
	g_return_if_fail (uri != NULL);
	_tmp0_ = _data26_->action;
	_tmp1_ = _tmp0_->src_dir;
	_tmp2_ = g_file_get_child (_tmp1_, uri);
	_data27_->uris = g_list_prepend (_data27_->uris, _tmp2_);
}

static void
____lambda52__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda52_ (self, (const gchar*) data);
}

static void
files_undo_manager_redo_ready (GObject* source_object,
                               GAsyncResult* _res_,
                               gpointer _user_data_)
{
	FilesUndoManagerRedoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	files_undo_manager_redo_co (_data_);
}

static Block28Data*
block28_data_ref (Block28Data* _data28_)
{
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}

static void
block28_data_unref (void * _userdata_)
{
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		FilesUndoManager* self;
		self = _data28_->_data26_->self;
		(_data28_->uris == NULL) ? NULL : (_data28_->uris = (_g_list_free__g_object_unref0_ (_data28_->uris), NULL));
		block26_data_unref (_data28_->_data26_);
		_data28_->_data26_ = NULL;
		g_slice_free (Block28Data, _data28_);
	}
}

static void
___lambda53_ (Block28Data* _data28_,
              const gchar* uri)
{
	Block26Data* _data26_;
	FilesUndoManager* self;
	FilesUndoActionData* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	_data26_ = _data28_->_data26_;
	self = _data26_->self;
	g_return_if_fail (uri != NULL);
	_tmp0_ = _data26_->action;
	_tmp1_ = _tmp0_->src_dir;
	_tmp2_ = g_file_get_child (_tmp1_, uri);
	_data28_->uris = g_list_prepend (_data28_->uris, _tmp2_);
}

static void
____lambda53__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda53_ (self, (const gchar*) data);
}

static Block29Data*
block29_data_ref (Block29Data* _data29_)
{
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}

static void
block29_data_unref (void * _userdata_)
{
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		FilesUndoManager* self;
		self = _data29_->_data26_->self;
		(_data29_->uris == NULL) ? NULL : (_data29_->uris = (_g_list_free__g_object_unref0_ (_data29_->uris), NULL));
		block26_data_unref (_data29_->_data26_);
		_data29_->_data26_ = NULL;
		g_slice_free (Block29Data, _data29_);
	}
}

static void
___lambda54_ (Block29Data* _data29_,
              const gchar* uri)
{
	Block26Data* _data26_;
	FilesUndoManager* self;
	FilesUndoActionData* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	_data26_ = _data29_->_data26_;
	self = _data26_->self;
	g_return_if_fail (uri != NULL);
	_tmp0_ = _data26_->action;
	_tmp1_ = _tmp0_->src_dir;
	_tmp2_ = g_file_get_child (_tmp1_, uri);
	_data29_->uris = g_list_prepend (_data29_->uris, _tmp2_);
}

static void
____lambda54__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda54_ (self, (const gchar*) data);
}

static Block30Data*
block30_data_ref (Block30Data* _data30_)
{
	g_atomic_int_inc (&_data30_->_ref_count_);
	return _data30_;
}

static void
block30_data_unref (void * _userdata_)
{
	Block30Data* _data30_;
	_data30_ = (Block30Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
		FilesUndoManager* self;
		self = _data30_->_data26_->self;
		(_data30_->uris == NULL) ? NULL : (_data30_->uris = (_g_list_free__g_object_unref0_ (_data30_->uris), NULL));
		block26_data_unref (_data30_->_data26_);
		_data30_->_data26_ = NULL;
		g_slice_free (Block30Data, _data30_);
	}
}

static void
____lambda55_ (Block30Data* _data30_,
               const gchar* uri)
{
	Block26Data* _data26_;
	FilesUndoManager* self;
	GFile* _tmp0_;
	_data26_ = _data30_->_data26_;
	self = _data26_->self;
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_file_new_for_uri (uri);
	_data30_->uris = g_list_prepend (_data30_->uris, _tmp0_);
}

static void
_____lambda55__gfunc (gconstpointer data,
                      gpointer self)
{
	____lambda55_ (self, (const gchar*) data);
}

static gboolean
files_undo_manager_redo_co (FilesUndoManagerRedoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data26_ = g_slice_new0 (Block26Data);
	_data_->_data26_->_ref_count_ = 1;
	_data_->_data26_->self = g_object_ref (_data_->self);
	_data_->_data26_->_async_data_ = _data_;
	_data_->_data26_->action = NULL;
	{
		_data_->_tmp0_ = _data_->self->priv->stack;
		g_rec_mutex_lock (&_data_->self->priv->__lock_stack);
		{
			_data_->_tmp1_ = files_undo_manager_stack_scroll_left (_data_->self);
			_data_->_tmp2_ = _files_undo_action_data_ref0 (_data_->_tmp1_);
			_files_undo_action_data_unref0 (_data_->_data26_->action);
			_data_->_data26_->action = _data_->_tmp2_;
			_data_->_tmp3_ = _data_->_data26_->action;
			if (_data_->_tmp3_ != NULL) {
				_data_->_tmp4_ = _data_->_data26_->action;
				_data_->_tmp4_->locked = TRUE;
			}
		}
		__finally0:
		{
			_data_->_tmp5_ = _data_->self->priv->stack;
			g_rec_mutex_unlock (&_data_->self->priv->__lock_stack);
		}
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block26_data_unref (_data_->_data26_);
			_data_->_data26_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_signal_emit (_data_->self, files_undo_manager_signals[FILES_UNDO_MANAGER_REQUEST_MENU_UPDATE_SIGNAL], 0);
	_data_->_tmp6_ = _data_->_data26_->action;
	if (_data_->_tmp6_ == NULL) {
		_data_->result = TRUE;
		block26_data_unref (_data_->_data26_);
		_data_->_data26_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	files_undo_manager_set_undo_redo_flag (_data_->self, TRUE);
	_data_->_tmp7_ = _data_->_data26_->action;
	switch (_data_->_tmp7_->action_type) {
		case MARLIN_UNDO_COPY:
		case MARLIN_UNDO_DUPLICATE:
		{
			_data_->_data27_ = g_slice_new0 (Block27Data);
			_data_->_data27_->_ref_count_ = 1;
			_data_->_data27_->_data26_ = block26_data_ref (_data_->_data26_);
			_data_->_data27_->uris = NULL;
			_data_->_tmp8_ = _data_->_data26_->action;
			_data_->_tmp9_ = _data_->_tmp8_->sources;
			g_list_foreach (_data_->_tmp9_, ____lambda52__gfunc, _data_->_data27_);
			_data_->_tmp10_ = _data_->_data27_->uris;
			if (_data_->_tmp10_ != NULL) {
				{
					_data_->_tmp11_ = _data_->_data27_->uris;
					_data_->_tmp12_ = _data_->_data26_->action;
					_data_->_tmp13_ = _data_->_tmp12_->dest_dir;
					_data_->_state_ = 1;
					marlin_file_operations_copy_move_link (_data_->_tmp11_, _data_->_tmp13_, GDK_ACTION_COPY, _data_->widget, _data_->cancellable, files_undo_manager_redo_ready, _data_);
					return FALSE;
					_state_1:
					marlin_file_operations_copy_move_link_finish (_data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					_data_->e = _data_->_inner_error0_;
					_data_->_inner_error0_ = NULL;
					_data_->_tmp14_ = _data_->_data26_->action;
					files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp14_);
					_data_->_tmp15_ = _data_->e;
					_data_->_tmp16_ = _g_error_copy0 (_data_->_tmp15_);
					_data_->_inner_error0_ = _data_->_tmp16_;
					_g_error_free0 (_data_->e);
					goto __finally1;
				}
				__finally1:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					block27_data_unref (_data_->_data27_);
					_data_->_data27_ = NULL;
					block26_data_unref (_data_->_data26_);
					_data_->_data26_ = NULL;
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_data_->_tmp17_ = _data_->_data26_->action;
			files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp17_);
			block27_data_unref (_data_->_data27_);
			_data_->_data27_ = NULL;
			break;
		}
		case MARLIN_UNDO_CREATELINK:
		{
			_data_->_data28_ = g_slice_new0 (Block28Data);
			_data_->_data28_->_ref_count_ = 1;
			_data_->_data28_->_data26_ = block26_data_ref (_data_->_data26_);
			_data_->_data28_->uris = NULL;
			_data_->_tmp18_ = _data_->_data26_->action;
			_data_->_tmp19_ = _data_->_tmp18_->sources;
			g_list_foreach (_data_->_tmp19_, ____lambda53__gfunc, _data_->_data28_);
			_data_->_tmp20_ = _data_->_data28_->uris;
			if (_data_->_tmp20_ != NULL) {
				{
					_data_->_tmp21_ = _data_->_data28_->uris;
					_data_->_tmp22_ = _data_->_data26_->action;
					_data_->_tmp23_ = _data_->_tmp22_->dest_dir;
					_data_->_state_ = 2;
					marlin_file_operations_copy_move_link (_data_->_tmp21_, _data_->_tmp23_, GDK_ACTION_LINK, _data_->widget, _data_->cancellable, files_undo_manager_redo_ready, _data_);
					return FALSE;
					_state_2:
					marlin_file_operations_copy_move_link_finish (_data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						goto __catch2_g_error;
					}
				}
				goto __finally2;
				__catch2_g_error:
				{
					_data_->_vala1_e = _data_->_inner_error0_;
					_data_->_inner_error0_ = NULL;
					_data_->_tmp24_ = _data_->_data26_->action;
					files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp24_);
					_data_->_tmp25_ = _data_->_vala1_e;
					_data_->_tmp26_ = _g_error_copy0 (_data_->_tmp25_);
					_data_->_inner_error0_ = _data_->_tmp26_;
					_g_error_free0 (_data_->_vala1_e);
					goto __finally2;
				}
				__finally2:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					block28_data_unref (_data_->_data28_);
					_data_->_data28_ = NULL;
					block26_data_unref (_data_->_data26_);
					_data_->_data26_ = NULL;
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_data_->_tmp27_ = _data_->_data26_->action;
			files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp27_);
			block28_data_unref (_data_->_data28_);
			_data_->_data28_ = NULL;
			break;
		}
		case MARLIN_UNDO_MOVE:
		case MARLIN_UNDO_RESTOREFROMTRASH:
		{
			_data_->_data29_ = g_slice_new0 (Block29Data);
			_data_->_data29_->_ref_count_ = 1;
			_data_->_data29_->_data26_ = block26_data_ref (_data_->_data26_);
			_data_->_data29_->uris = NULL;
			_data_->_tmp28_ = _data_->_data26_->action;
			_data_->_tmp29_ = _data_->_tmp28_->sources;
			g_list_foreach (_data_->_tmp29_, ____lambda54__gfunc, _data_->_data29_);
			_data_->_tmp30_ = _data_->_data29_->uris;
			if (_data_->_tmp30_ != NULL) {
				{
					_data_->_tmp31_ = _data_->_data29_->uris;
					_data_->_tmp32_ = _data_->_data26_->action;
					_data_->_tmp33_ = _data_->_tmp32_->dest_dir;
					_data_->_state_ = 3;
					marlin_file_operations_copy_move_link (_data_->_tmp31_, _data_->_tmp33_, GDK_ACTION_MOVE, _data_->widget, _data_->cancellable, files_undo_manager_redo_ready, _data_);
					return FALSE;
					_state_3:
					marlin_file_operations_copy_move_link_finish (_data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						goto __catch3_g_error;
					}
				}
				goto __finally3;
				__catch3_g_error:
				{
					_data_->_vala2_e = _data_->_inner_error0_;
					_data_->_inner_error0_ = NULL;
					_data_->_tmp34_ = _data_->_data26_->action;
					files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp34_);
					_data_->_tmp35_ = _data_->_vala2_e;
					_data_->_tmp36_ = _g_error_copy0 (_data_->_tmp35_);
					_data_->_inner_error0_ = _data_->_tmp36_;
					_g_error_free0 (_data_->_vala2_e);
					goto __finally3;
				}
				__finally3:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					block29_data_unref (_data_->_data29_);
					_data_->_data29_ = NULL;
					block26_data_unref (_data_->_data26_);
					_data_->_data26_ = NULL;
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_data_->_tmp37_ = _data_->_data26_->action;
			files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp37_);
			block29_data_unref (_data_->_data29_);
			_data_->_data29_ = NULL;
			break;
		}
		case MARLIN_UNDO_RENAME:
		{
			_data_->_tmp38_ = _data_->_data26_->action;
			_data_->_tmp39_ = _data_->_tmp38_->old_uri;
			_data_->_tmp40_ = files_file_utils_get_file_for_path (_data_->_tmp39_);
			_data_->file = _data_->_tmp40_;
			_data_->_tmp41_ = _data_->_data26_->action;
			_data_->_tmp42_ = _data_->_tmp41_->new_uri;
			_data_->_tmp43_ = files_file_utils_get_file_for_path (_data_->_tmp42_);
			_data_->_tmp44_ = _data_->_tmp43_;
			_data_->_tmp45_ = g_file_get_basename (_data_->_tmp44_);
			_data_->_tmp46_ = _data_->_tmp45_;
			_g_object_unref0 (_data_->_tmp44_);
			_data_->new_name = _data_->_tmp46_;
			{
				_data_->_tmp47_ = _data_->file;
				_data_->_tmp48_ = _data_->new_name;
				_data_->_state_ = 4;
				files_file_utils_set_file_display_name (_data_->_tmp47_, _data_->_tmp48_, _data_->cancellable, files_undo_manager_redo_ready, _data_);
				return FALSE;
				_state_4:
				_data_->_tmp49_ = files_file_utils_set_file_display_name_finish (_data_->_res_, &_data_->_inner_error0_);
				_data_->_tmp50_ = _data_->_tmp49_;
				_g_object_unref0 (_data_->_tmp50_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch4_g_error;
				}
			}
			goto __finally4;
			__catch4_g_error:
			{
				_data_->_vala3_e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp51_ = _data_->_data26_->action;
				files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp51_);
				_data_->_tmp52_ = _data_->_vala3_e;
				_data_->_tmp53_ = _g_error_copy0 (_data_->_tmp52_);
				_data_->_inner_error0_ = _data_->_tmp53_;
				_g_error_free0 (_data_->_vala3_e);
				goto __finally4;
			}
			__finally4:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_free0 (_data_->new_name);
				_g_object_unref0 (_data_->file);
				block26_data_unref (_data_->_data26_);
				_data_->_data26_ = NULL;
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp54_ = _data_->_data26_->action;
			files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp54_);
			_g_free0 (_data_->new_name);
			_g_object_unref0 (_data_->file);
			break;
		}
		case MARLIN_UNDO_CREATEEMPTYFILE:
		case MARLIN_UNDO_CREATEFILEFROMTEMPLATE:
		{
			_data_->_tmp55_ = _data_->_data26_->action;
			_data_->_tmp56_ = _data_->_tmp55_->target_uri;
			_data_->_tmp57_ = g_file_new_for_uri (_data_->_tmp56_);
			_data_->_tmp58_ = _data_->_tmp57_;
			_data_->_tmp59_ = g_file_get_parent (_data_->_tmp58_);
			_data_->_tmp60_ = _data_->_tmp59_;
			_data_->_tmp61_ = g_file_get_uri (_data_->_tmp60_);
			_data_->_tmp62_ = _data_->_tmp61_;
			_g_object_unref0 (_data_->_tmp60_);
			_g_object_unref0 (_data_->_tmp58_);
			_data_->p_uri = _data_->_tmp62_;
			_data_->_tmp63_ = _data_->_data26_->action;
			_data_->_tmp64_ = _data_->_tmp63_->target_uri;
			_data_->_tmp65_ = g_uri_unescape_string (_data_->_tmp64_, NULL);
			_data_->_tmp66_ = _data_->_tmp65_;
			_data_->_tmp67_ = g_path_get_basename (_data_->_tmp66_);
			_data_->_tmp68_ = _data_->_tmp67_;
			_g_free0 (_data_->_tmp66_);
			_data_->_vala1_new_name = _data_->_tmp68_;
			{
				_data_->_tmp69_ = gtk_widget_get_toplevel (_data_->widget);
				_data_->_tmp70_ = _data_->p_uri;
				_data_->_tmp71_ = _data_->_vala1_new_name;
				_data_->_tmp72_ = _data_->_data26_->action;
				_data_->_tmp73_ = _data_->_tmp72_->template;
				_data_->_state_ = 5;
				marlin_file_operations_new_file ((GtkWidget*) (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp69_, gtk_window_get_type ()) ? ((GtkWindow*) _data_->_tmp69_) : NULL), _data_->_tmp70_, _data_->_tmp71_, _data_->_tmp73_, 0, _data_->cancellable, files_undo_manager_redo_ready, _data_);
				return FALSE;
				_state_5:
				_data_->_tmp74_ = marlin_file_operations_new_file_finish (_data_->_res_, &_data_->_inner_error0_);
				_data_->_tmp75_ = _data_->_tmp74_;
				_g_object_unref0 (_data_->_tmp75_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch5_g_error;
				}
			}
			goto __finally5;
			__catch5_g_error:
			{
				_data_->_vala4_e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp76_ = _data_->_data26_->action;
				files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp76_);
				_data_->_tmp77_ = _data_->_vala4_e;
				_data_->_tmp78_ = _g_error_copy0 (_data_->_tmp77_);
				_data_->_inner_error0_ = _data_->_tmp78_;
				_g_error_free0 (_data_->_vala4_e);
				goto __finally5;
			}
			__finally5:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_free0 (_data_->_vala1_new_name);
				_g_free0 (_data_->p_uri);
				block26_data_unref (_data_->_data26_);
				_data_->_data26_ = NULL;
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp79_ = _data_->_data26_->action;
			files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp79_);
			_g_free0 (_data_->_vala1_new_name);
			_g_free0 (_data_->p_uri);
			break;
		}
		case MARLIN_UNDO_CREATEFOLDER:
		{
			_data_->_tmp80_ = _data_->_data26_->action;
			_data_->_tmp81_ = _data_->_tmp80_->target_uri;
			_data_->_tmp82_ = g_file_new_for_uri (_data_->_tmp81_);
			_data_->_tmp83_ = _data_->_tmp82_;
			_data_->_tmp84_ = g_file_get_parent (_data_->_tmp83_);
			_data_->_tmp85_ = _data_->_tmp84_;
			_g_object_unref0 (_data_->_tmp83_);
			_data_->fparent = _data_->_tmp85_;
			{
				_data_->_tmp86_ = gtk_widget_get_toplevel (_data_->widget);
				_data_->_tmp87_ = _data_->fparent;
				_data_->_state_ = 6;
				marlin_file_operations_new_folder ((GtkWidget*) (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp86_, gtk_window_get_type ()) ? ((GtkWindow*) _data_->_tmp86_) : NULL), _data_->_tmp87_, _data_->cancellable, files_undo_manager_redo_ready, _data_);
				return FALSE;
				_state_6:
				_data_->_tmp88_ = marlin_file_operations_new_folder_finish (_data_->_res_, &_data_->_inner_error0_);
				_data_->_tmp89_ = _data_->_tmp88_;
				_g_object_unref0 (_data_->_tmp89_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch6_g_error;
				}
			}
			goto __finally6;
			__catch6_g_error:
			{
				_data_->_vala5_e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp90_ = _data_->_data26_->action;
				files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp90_);
				_data_->_tmp91_ = _data_->_vala5_e;
				_data_->_tmp92_ = _g_error_copy0 (_data_->_tmp91_);
				_data_->_inner_error0_ = _data_->_tmp92_;
				_g_error_free0 (_data_->_vala5_e);
				goto __finally6;
			}
			__finally6:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->fparent);
				block26_data_unref (_data_->_data26_);
				_data_->_data26_ = NULL;
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp93_ = _data_->_data26_->action;
			files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp93_);
			_g_object_unref0 (_data_->fparent);
			break;
		}
		case MARLIN_UNDO_MOVETOTRASH:
		{
			_data_->_tmp94_ = _data_->_data26_->action;
			_data_->_tmp95_ = _data_->_tmp94_->trashed;
			if (g_hash_table_size (_data_->_tmp95_) > ((guint) 0)) {
				_data_->_data30_ = g_slice_new0 (Block30Data);
				_data_->_data30_->_ref_count_ = 1;
				_data_->_data30_->_data26_ = block26_data_ref (_data_->_data26_);
				_data_->_tmp96_ = _data_->_data26_->action;
				_data_->_tmp97_ = _data_->_tmp96_->trashed;
				_data_->_tmp98_ = g_hash_table_get_keys (_data_->_tmp97_);
				_data_->uri_to_trash = _data_->_tmp98_;
				_data_->_data30_->uris = NULL;
				_data_->_tmp99_ = _data_->uri_to_trash;
				g_list_foreach (_data_->_tmp99_, _____lambda55__gfunc, _data_->_data30_);
				{
					_data_->_tmp100_ = _data_->_data30_->uris;
					_data_->_tmp101_ = gtk_widget_get_toplevel (_data_->widget);
					_data_->_state_ = 7;
					marlin_file_operations_delete (_data_->_tmp100_, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp101_, gtk_window_get_type ()) ? ((GtkWindow*) _data_->_tmp101_) : NULL, TRUE, _data_->cancellable, files_undo_manager_redo_ready, _data_);
					return FALSE;
					_state_7:
					marlin_file_operations_delete_finish (_data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						goto __catch7_g_error;
					}
				}
				goto __finally7;
				__catch7_g_error:
				{
					_data_->_vala6_e = _data_->_inner_error0_;
					_data_->_inner_error0_ = NULL;
					_data_->_tmp102_ = _data_->_data26_->action;
					files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp102_);
					_data_->_tmp103_ = _data_->_vala6_e;
					_data_->_tmp104_ = _g_error_copy0 (_data_->_tmp103_);
					_data_->_inner_error0_ = _data_->_tmp104_;
					_g_error_free0 (_data_->_vala6_e);
					goto __finally7;
				}
				__finally7:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					(_data_->uri_to_trash == NULL) ? NULL : (_data_->uri_to_trash = (g_list_free (_data_->uri_to_trash), NULL));
					block30_data_unref (_data_->_data30_);
					_data_->_data30_ = NULL;
					block26_data_unref (_data_->_data26_);
					_data_->_data26_ = NULL;
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				(_data_->uri_to_trash == NULL) ? NULL : (_data_->uri_to_trash = (g_list_free (_data_->uri_to_trash), NULL));
				block30_data_unref (_data_->_data30_);
				_data_->_data30_ = NULL;
			}
			_data_->_tmp105_ = _data_->_data26_->action;
			files_undo_manager_undo_redo_done_transfer (_data_->self, _data_->_tmp105_);
			break;
		}
		default:
		{
			_data_->_tmp106_ = _data_->_data26_->action;
			_data_->_tmp107_ = g_enum_to_string (FILES_TYPE_UNDO_ACTION_TYPE, _data_->_tmp106_->action_type);
			g_warning ("UndoManager.vala:538: Ignoring request to redo irreversible or unknown" \
" action %s", _data_->_tmp107_);
			_g_free0 (_data_->_tmp107_);
			files_undo_manager_set_undo_redo_flag (_data_->self, FALSE);
			break;
		}
	}
	_data_->result = TRUE;
	block26_data_unref (_data_->_data26_);
	_data_->_data26_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
files_undo_manager_add_action (FilesUndoManager* self,
                               FilesUndoActionData* action)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (action == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !action->is_valid;
	}
	if (_tmp0_) {
		_files_undo_action_data_unref0 (action);
		return;
	}
	{
		GQueue* _tmp1_;
		_tmp1_ = self->priv->stack;
		g_rec_mutex_lock (&self->priv->__lock_stack);
		{
			FilesUndoActionData* _tmp2_;
			_tmp2_ = action;
			action = NULL;
			files_undo_manager_stack_push_action (self, _tmp2_);
		}
		__finally0:
		{
			GQueue* _tmp3_;
			_tmp3_ = self->priv->stack;
			g_rec_mutex_unlock (&self->priv->__lock_stack);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_files_undo_action_data_unref0 (action);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	g_signal_emit (self, files_undo_manager_signals[FILES_UNDO_MANAGER_REQUEST_MENU_UPDATE_SIGNAL], 0);
	_files_undo_action_data_unref0 (action);
}

void
files_undo_manager_add_rename_action (FilesUndoManager* self,
                                      GFile* renamed_file,
                                      const gchar* original_name)
{
	gboolean _tmp0_;
	FilesUndoActionData* data = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	FilesUndoActionData* _tmp7_ = NULL;
	FilesUndoActionData* _tmp8_;
	FilesUndoActionData* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (renamed_file != NULL);
	g_return_if_fail (original_name != NULL);
	_tmp0_ = self->priv->_undo_redo_flag;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = g_file_get_parent (renamed_file);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_child (_tmp2_, original_name);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_get_uri (_tmp4_);
	_tmp6_ = g_file_get_uri (renamed_file);
	_tmp7_ = files_undo_action_data_new (MARLIN_UNDO_RENAME, 1);
	_g_free0 (_tmp7_->old_uri);
	_tmp7_->old_uri = _tmp5_;
	_g_free0 (_tmp7_->new_uri);
	_tmp7_->new_uri = _tmp6_;
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	data = _tmp8_;
	_tmp9_ = data;
	data = NULL;
	files_undo_manager_add_action (self, _tmp9_);
	_files_undo_action_data_unref0 (data);
}

static Block31Data*
block31_data_ref (Block31Data* _data31_)
{
	g_atomic_int_inc (&_data31_->_ref_count_);
	return _data31_;
}

static void
block31_data_unref (void * _userdata_)
{
	Block31Data* _data31_;
	_data31_ = (Block31Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data31_->_ref_count_)) {
		FilesUndoManager* self;
		self = _data31_->self;
		(_data31_->trash == NULL) ? NULL : (_data31_->trash = (g_list_free (_data31_->trash), NULL));
		_g_object_unref0 (self);
		g_slice_free (Block31Data, _data31_);
	}
}

static Block32Data*
block32_data_ref (Block32Data* _data32_)
{
	g_atomic_int_inc (&_data32_->_ref_count_);
	return _data32_;
}

static void
block32_data_unref (void * _userdata_)
{
	Block32Data* _data32_;
	_data32_ = (Block32Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data32_->_ref_count_)) {
		FilesUndoManager* self;
		self = _data32_->_data31_->self;
		_files_undo_action_data_unref0 (_data32_->action);
		block31_data_unref (_data32_->_data31_);
		_data32_->_data31_ = NULL;
		g_slice_free (Block32Data, _data32_);
	}
}

static Block33Data*
block33_data_ref (Block33Data* _data33_)
{
	g_atomic_int_inc (&_data33_->_ref_count_);
	return _data33_;
}

static void
block33_data_unref (void * _userdata_)
{
	Block33Data* _data33_;
	_data33_ = (Block33Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data33_->_ref_count_)) {
		FilesUndoManager* self;
		self = _data33_->_data32_->_data31_->self;
		(_data33_->g == NULL) ? NULL : (_data33_->g = (_g_list_free__g_object_unref0_ (_data33_->g), NULL));
		block32_data_unref (_data33_->_data32_);
		_data33_->_data32_ = NULL;
		g_slice_free (Block33Data, _data33_);
	}
}

static void
___lambda58_ (Block33Data* _data33_,
              const gchar* uri)
{
	Block32Data* _data32_;
	Block31Data* _data31_;
	FilesUndoManager* self;
	GFile* _tmp0_;
	GFile* _tmp1_;
	_data32_ = _data33_->_data32_;
	_data31_ = _data32_->_data31_;
	self = _data31_->self;
	g_return_if_fail (uri != NULL);
	_tmp0_ = _data32_->action->dest_dir;
	_tmp1_ = g_file_get_child (_tmp0_, uri);
	_data33_->g = g_list_prepend (_data33_->g, _tmp1_);
}

static void
____lambda58__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda58_ (self, (const gchar*) data);
}

static gboolean
vala_g_queue_remove_full (GQueue* self,
                          gconstpointer data,
                          GFreeFunc func)
{
	GList* l = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->head;
	_tmp1_ = g_list_find (_tmp0_, data);
	l = _tmp1_;
	_tmp2_ = l;
	if (_tmp2_ != NULL) {
		GList* _tmp3_;
		gconstpointer _tmp4_;
		GList* _tmp5_;
		_tmp3_ = l;
		_tmp4_ = ((GList*) _tmp3_)->data;
		func (_tmp4_);
		_tmp5_ = l;
		g_queue_delete_link (self, (GList*) _tmp5_);
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
___lambda57_ (Block31Data* _data31_,
              FilesUndoActionData* action)
{
	FilesUndoManager* self;
	Block32Data* _data32_;
	FilesUndoActionData* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GList* _tmp2_;
	self = _data31_->self;
	g_return_if_fail (action != NULL);
	_data32_ = g_slice_new0 (Block32Data);
	_data32_->_ref_count_ = 1;
	_data32_->_data31_ = block31_data_ref (_data31_);
	_tmp0_ = _files_undo_action_data_ref0 (action);
	_files_undo_action_data_unref0 (_data32_->action);
	_data32_->action = _tmp0_;
	_tmp2_ = _data32_->action->destinations;
	if (_tmp2_ != NULL) {
		GFile* _tmp3_;
		_tmp3_ = _data32_->action->dest_dir;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Block33Data* _data33_;
		GList* _tmp4_;
		GList* _tmp5_;
		_data33_ = g_slice_new0 (Block33Data);
		_data33_->_ref_count_ = 1;
		_data33_->_data32_ = block32_data_ref (_data32_);
		_data33_->g = NULL;
		_tmp4_ = _data32_->action->destinations;
		g_list_foreach (_tmp4_, ____lambda58__gfunc, _data33_);
		_tmp5_ = _data33_->g;
		if (files_undo_manager_is_destination_uri_action_partof_trashed (_data31_->trash, _tmp5_)) {
			GQueue* _tmp6_;
			_tmp6_ = self->priv->stack;
			vala_g_queue_remove_full (_tmp6_, _data32_->action, _files_undo_action_data_unref0_);
			block33_data_unref (_data33_);
			_data33_ = NULL;
			block32_data_unref (_data32_);
			_data32_ = NULL;
			return;
		}
		block33_data_unref (_data33_);
		_data33_ = NULL;
	}
	if (_data32_->action->action_type == MARLIN_UNDO_MOVETOTRASH) {
		GQueue* _tmp7_;
		_tmp7_ = self->priv->stack;
		vala_g_queue_remove_full (_tmp7_, _data32_->action, _files_undo_action_data_unref0_);
	}
	block32_data_unref (_data32_);
	_data32_ = NULL;
}

static void
____lambda57__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda57_ (self, (FilesUndoActionData*) data);
}

void
files_undo_manager_trash_has_emptied (FilesUndoManager* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GQueue* _tmp0_;
		_tmp0_ = self->priv->stack;
		g_rec_mutex_lock (&self->priv->__lock_stack);
		{
			Block31Data* _data31_;
			GList* _tmp1_;
			GQueue* _tmp2_;
			GList* _tmp3_;
			GList* _tmp4_;
			GList* _tmp5_;
			_data31_ = g_slice_new0 (Block31Data);
			_data31_->_ref_count_ = 1;
			_data31_->self = g_object_ref (self);
			files_undo_manager_clear_redo_actions (self);
			_tmp1_ = files_undo_manager_get_all_trashed_items (self);
			_data31_->trash = _tmp1_;
			_tmp2_ = self->priv->stack;
			_tmp3_ = _tmp2_->head;
			_tmp4_ = g_list_copy (_tmp3_);
			_tmp5_ = _tmp4_;
			g_list_foreach (_tmp5_, ____lambda57__gfunc, _data31_);
			(_tmp5_ == NULL) ? NULL : (_tmp5_ = (g_list_free (_tmp5_), NULL));
			block31_data_unref (_data31_);
			_data31_ = NULL;
		}
		__finally0:
		{
			GQueue* _tmp6_;
			_tmp6_ = self->priv->stack;
			g_rec_mutex_unlock (&self->priv->__lock_stack);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	g_signal_emit (self, files_undo_manager_signals[FILES_UNDO_MANAGER_REQUEST_MENU_UPDATE_SIGNAL], 0);
}

static void
files_undo_manager_clear_redo_actions (FilesUndoManager* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		GQueue* _tmp0_;
		gpointer _tmp1_;
		FilesUndoActionData* _tmp2_;
		guint _tmp3_;
		if (!(self->priv->index > ((guint) 0))) {
			break;
		}
		_tmp0_ = self->priv->stack;
		_tmp1_ = g_queue_pop_head (_tmp0_);
		_tmp2_ = (FilesUndoActionData*) _tmp1_;
		_files_undo_action_data_unref0 (_tmp2_);
		_tmp3_ = self->priv->index;
		self->priv->index = _tmp3_ - 1;
	}
}

static void
files_undo_manager_stack_clear_n_oldest (FilesUndoManager* self,
                                         guint n)
{
	g_return_if_fail (self != NULL);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GQueue* _tmp2_;
				gpointer _tmp3_;
				FilesUndoActionData* _tmp4_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < n)) {
					break;
				}
				_tmp2_ = self->priv->stack;
				_tmp3_ = g_queue_pop_tail (_tmp2_);
				_tmp4_ = (FilesUndoActionData*) _tmp3_;
				_files_undo_action_data_unref0 (_tmp4_);
			}
		}
	}
}

static void
files_undo_manager_stack_fix_size (FilesUndoManager* self)
{
	guint length = 0U;
	GQueue* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	length = g_queue_get_length (_tmp0_);
	_tmp1_ = self->priv->_undo_levels;
	if (length > _tmp1_) {
		guint _tmp2_;
		guint _tmp4_;
		_tmp2_ = self->priv->_undo_levels;
		if (self->priv->index > (_tmp2_ + 1)) {
			guint _tmp3_;
			_tmp3_ = self->priv->_undo_levels;
			self->priv->index = _tmp3_ + 1;
		}
		_tmp4_ = self->priv->_undo_levels;
		files_undo_manager_stack_clear_n_oldest (self, length - _tmp4_);
	}
}

static void
files_undo_manager_stack_push_action (FilesUndoManager* self,
                                      FilesUndoActionData* action)
{
	GQueue* _tmp0_;
	FilesUndoActionData* _tmp1_;
	GQueue* _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	files_undo_manager_clear_redo_actions (self);
	_tmp0_ = self->priv->stack;
	_tmp1_ = action;
	action = NULL;
	g_queue_push_head (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->stack;
	_tmp3_ = self->priv->_undo_levels;
	if (g_queue_get_length (_tmp2_) > _tmp3_) {
		files_undo_manager_stack_fix_size (self);
	}
	_files_undo_action_data_unref0 (action);
}

static FilesUndoActionData*
files_undo_manager_get_next_redo_action (FilesUndoManager* self)
{
	GQueue* _tmp0_;
	FilesUndoActionData* action = NULL;
	GQueue* _tmp1_;
	gconstpointer _tmp2_;
	FilesUndoActionData* _tmp3_;
	FilesUndoActionData* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->stack;
	if (g_queue_is_empty (_tmp0_)) {
		result = NULL;
		return result;
	}
	if (self->priv->index == ((guint) 0)) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->stack;
	_tmp2_ = g_queue_peek_nth (_tmp1_, self->priv->index - 1);
	action = (FilesUndoActionData*) _tmp2_;
	_tmp3_ = action;
	if (_tmp3_->locked) {
		result = NULL;
		return result;
	} else {
		FilesUndoActionData* _tmp4_;
		_tmp4_ = action;
		result = _tmp4_;
		return result;
	}
}

static FilesUndoActionData*
files_undo_manager_get_next_undo_action (FilesUndoManager* self)
{
	GQueue* _tmp0_;
	GQueue* _tmp1_;
	FilesUndoActionData* action = NULL;
	GQueue* _tmp2_;
	gconstpointer _tmp3_;
	FilesUndoActionData* _tmp4_;
	FilesUndoActionData* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->stack;
	if (g_queue_is_empty (_tmp0_)) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->stack;
	if (self->priv->index == g_queue_get_length (_tmp1_)) {
		result = NULL;
		return result;
	}
	_tmp2_ = self->priv->stack;
	_tmp3_ = g_queue_peek_nth (_tmp2_, self->priv->index);
	action = (FilesUndoActionData*) _tmp3_;
	_tmp4_ = action;
	if (_tmp4_->locked) {
		result = NULL;
		return result;
	} else {
		FilesUndoActionData* _tmp5_;
		_tmp5_ = action;
		result = _tmp5_;
		return result;
	}
}

const gchar*
files_undo_manager_get_next_undo_description (FilesUndoManager* self)
{
	FilesUndoActionData* action = NULL;
	FilesUndoActionData* _tmp0_;
	FilesUndoActionData* _tmp1_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = files_undo_manager_get_next_undo_action (self);
	action = _tmp0_;
	_tmp1_ = action;
	if (_tmp1_ != NULL) {
		FilesUndoActionData* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = action;
		_tmp3_ = files_undo_action_type_to_undo_string (_tmp2_->action_type);
		result = _tmp3_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}

const gchar*
files_undo_manager_get_next_redo_description (FilesUndoManager* self)
{
	FilesUndoActionData* action = NULL;
	FilesUndoActionData* _tmp0_;
	FilesUndoActionData* _tmp1_;
	FilesUndoActionData* _tmp2_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = files_undo_manager_get_next_redo_action (self);
	_tmp1_ = _files_undo_action_data_ref0 (_tmp0_);
	action = _tmp1_;
	_tmp2_ = action;
	if (_tmp2_ != NULL) {
		FilesUndoActionData* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = action;
		_tmp4_ = files_undo_action_type_to_redo_string (_tmp3_->action_type);
		result = _tmp4_;
		_files_undo_action_data_unref0 (action);
		return result;
	} else {
		result = NULL;
		_files_undo_action_data_unref0 (action);
		return result;
	}
}

gboolean
files_undo_manager_can_undo (FilesUndoManager* self)
{
	FilesUndoActionData* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = files_undo_manager_get_next_undo_action (self);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
files_undo_manager_can_redo (FilesUndoManager* self)
{
	FilesUndoActionData* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = files_undo_manager_get_next_redo_action (self);
	result = _tmp0_ != NULL;
	return result;
}

static FilesUndoActionData*
files_undo_manager_stack_scroll_right (FilesUndoManager* self)
{
	FilesUndoActionData* data = NULL;
	GQueue* _tmp0_;
	gconstpointer _tmp1_;
	GQueue* _tmp2_;
	FilesUndoActionData* _tmp4_;
	FilesUndoActionData* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!files_undo_manager_can_undo (self)) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->stack;
	_tmp1_ = g_queue_peek_nth (_tmp0_, self->priv->index);
	data = (FilesUndoActionData*) _tmp1_;
	_tmp2_ = self->priv->stack;
	if (self->priv->index < g_queue_get_length (_tmp2_)) {
		guint _tmp3_;
		_tmp3_ = self->priv->index;
		self->priv->index = _tmp3_ + 1;
	}
	_tmp4_ = data;
	result = _tmp4_;
	return result;
}

static FilesUndoActionData*
files_undo_manager_stack_scroll_left (FilesUndoManager* self)
{
	guint _tmp0_;
	GQueue* _tmp1_;
	gconstpointer _tmp2_;
	FilesUndoActionData* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!files_undo_manager_can_redo (self)) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->index;
	self->priv->index = _tmp0_ - 1;
	_tmp1_ = self->priv->stack;
	_tmp2_ = g_queue_peek_nth (_tmp1_, self->priv->index);
	result = (FilesUndoActionData*) _tmp2_;
	return result;
}

static void
files_undo_manager_undo_redo_done_transfer (FilesUndoManager* self,
                                            FilesUndoActionData* action)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	action->locked = FALSE;
	files_undo_manager_set_undo_redo_flag (self, FALSE);
	g_signal_emit (self, files_undo_manager_signals[FILES_UNDO_MANAGER_REQUEST_MENU_UPDATE_SIGNAL], 0);
}

static Block34Data*
block34_data_ref (Block34Data* _data34_)
{
	g_atomic_int_inc (&_data34_->_ref_count_);
	return _data34_;
}

static void
block34_data_unref (void * _userdata_)
{
	Block34Data* _data34_;
	_data34_ = (Block34Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data34_->_ref_count_)) {
		FilesUndoManager* self;
		self = _data34_->self;
		(_data34_->trash == NULL) ? NULL : (_data34_->trash = (g_list_free (_data34_->trash), NULL));
		_g_object_unref0 (self);
		g_slice_free (Block34Data, _data34_);
	}
}

static void
__lambda56_ (Block34Data* _data34_,
             FilesUndoActionData* action)
{
	FilesUndoManager* self;
	GHashTable* _tmp0_;
	self = _data34_->self;
	g_return_if_fail (action != NULL);
	_tmp0_ = action->trashed;
	if (_tmp0_ != NULL) {
		GHashTable* _tmp1_;
		GList* _tmp2_;
		_tmp1_ = action->trashed;
		_tmp2_ = g_hash_table_get_keys (_tmp1_);
		_data34_->trash = g_list_concat (_data34_->trash, _tmp2_);
	}
}

static void
___lambda56__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda56_ (self, (FilesUndoActionData*) data);
}

static GList*
files_undo_manager_get_all_trashed_items (FilesUndoManager* self)
{
	Block34Data* _data34_;
	GQueue* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data34_ = g_slice_new0 (Block34Data);
	_data34_->_ref_count_ = 1;
	_data34_->self = g_object_ref (self);
	_data34_->trash = NULL;
	_tmp0_ = self->priv->stack;
	_tmp1_ = _tmp0_->head;
	g_list_foreach (_tmp1_, ___lambda56__gfunc, _data34_);
	_tmp2_ = _data34_->trash;
	_data34_->trash = NULL;
	result = _tmp2_;
	block34_data_unref (_data34_);
	_data34_ = NULL;
	return result;
}

static gboolean
files_undo_manager_is_destination_uri_action_partof_trashed (GList* trash,
                                                             GList* g)
{
	gboolean result;
	{
		GList* trash_item_collection = NULL;
		GList* trash_item_it = NULL;
		trash_item_collection = trash;
		for (trash_item_it = trash_item_collection; trash_item_it != NULL; trash_item_it = trash_item_it->next) {
			const gchar* trash_item = NULL;
			trash_item = (const gchar*) trash_item_it->data;
			{
				{
					GList* g_item_collection = NULL;
					GList* g_item_it = NULL;
					g_item_collection = g;
					for (g_item_it = g_item_collection; g_item_it != NULL; g_item_it = g_item_it->next) {
						GFile* g_item = NULL;
						g_item = (GFile*) g_item_it->data;
						{
							GFile* _tmp0_;
							gchar* _tmp1_;
							gchar* _tmp2_;
							const gchar* _tmp3_;
							gboolean _tmp4_;
							_tmp0_ = g_item;
							_tmp1_ = g_file_get_uri (_tmp0_);
							_tmp2_ = _tmp1_;
							_tmp3_ = trash_item;
							_tmp4_ = g_strcmp0 (_tmp2_, _tmp3_) == 0;
							_g_free0 (_tmp2_);
							if (_tmp4_) {
								result = TRUE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}

FilesUndoManager*
files_undo_manager_construct (GType object_type)
{
	FilesUndoManager * self = NULL;
	self = (FilesUndoManager*) g_object_new (object_type, NULL);
	return self;
}

FilesUndoManager*
files_undo_manager_new (void)
{
	return files_undo_manager_construct (FILES_TYPE_UNDO_MANAGER);
}

guint
files_undo_manager_get_undo_levels (FilesUndoManager* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_undo_levels;
	return result;
}

void
files_undo_manager_set_undo_levels (FilesUndoManager* self,
                                    guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = files_undo_manager_get_undo_levels (self);
	if (old_value != value) {
		self->priv->_undo_levels = value;
		g_object_notify_by_pspec ((GObject *) self, files_undo_manager_properties[FILES_UNDO_MANAGER_UNDO_LEVELS_PROPERTY]);
	}
}

gboolean
files_undo_manager_get_confirm_delete (FilesUndoManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_confirm_delete;
	return result;
}

void
files_undo_manager_set_confirm_delete (FilesUndoManager* self,
                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_undo_manager_get_confirm_delete (self);
	if (old_value != value) {
		self->priv->_confirm_delete = value;
		g_object_notify_by_pspec ((GObject *) self, files_undo_manager_properties[FILES_UNDO_MANAGER_CONFIRM_DELETE_PROPERTY]);
	}
}

gboolean
files_undo_manager_get_undo_redo_flag (FilesUndoManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_undo_redo_flag;
	return result;
}

static void
files_undo_manager_set_undo_redo_flag (FilesUndoManager* self,
                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_undo_manager_get_undo_redo_flag (self);
	if (old_value != value) {
		self->priv->_undo_redo_flag = value;
		g_object_notify_by_pspec ((GObject *) self, files_undo_manager_properties[FILES_UNDO_MANAGER_UNDO_REDO_FLAG_PROPERTY]);
	}
}

static GObject *
files_undo_manager_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesUndoManager * self;
	GQueue* _tmp0_;
	parent_class = G_OBJECT_CLASS (files_undo_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_UNDO_MANAGER, FilesUndoManager);
	_tmp0_ = g_queue_new ();
	(self->priv->stack == NULL) ? NULL : (self->priv->stack = (_g_queue_free__files_undo_action_data_unref0_ (self->priv->stack), NULL));
	self->priv->stack = _tmp0_;
	return obj;
}

static void
files_undo_manager_class_init (FilesUndoManagerClass * klass,
                               gpointer klass_data)
{
	files_undo_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesUndoManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_files_undo_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_undo_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = files_undo_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_undo_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_UNDO_MANAGER_UNDO_LEVELS_PROPERTY, files_undo_manager_properties[FILES_UNDO_MANAGER_UNDO_LEVELS_PROPERTY] = g_param_spec_uint ("undo-levels", "undo-levels", "undo-levels", 0, G_MAXUINT, (guint) 10, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_UNDO_MANAGER_CONFIRM_DELETE_PROPERTY, files_undo_manager_properties[FILES_UNDO_MANAGER_CONFIRM_DELETE_PROPERTY] = g_param_spec_boolean ("confirm-delete", "confirm-delete", "confirm-delete", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_UNDO_MANAGER_UNDO_REDO_FLAG_PROPERTY, files_undo_manager_properties[FILES_UNDO_MANAGER_UNDO_REDO_FLAG_PROPERTY] = g_param_spec_boolean ("undo-redo-flag", "undo-redo-flag", "undo-redo-flag", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	files_undo_manager_signals[FILES_UNDO_MANAGER_REQUEST_MENU_UPDATE_SIGNAL] = g_signal_new ("request-menu-update", FILES_TYPE_UNDO_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
files_undo_manager_instance_init (FilesUndoManager * self,
                                  gpointer klass)
{
	self->priv = files_undo_manager_get_instance_private (self);
	self->priv->_undo_levels = (guint) 10;
	self->priv->_confirm_delete = FALSE;
	g_rec_mutex_init (&self->priv->__lock_stack);
}

static void
files_undo_manager_finalize (GObject * obj)
{
	FilesUndoManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_UNDO_MANAGER, FilesUndoManager);
	g_rec_mutex_clear (&self->priv->__lock_stack);
	(self->priv->stack == NULL) ? NULL : (self->priv->stack = (_g_queue_free__files_undo_action_data_unref0_ (self->priv->stack), NULL));
	G_OBJECT_CLASS (files_undo_manager_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_undo_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesUndoManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_undo_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesUndoManager), 0, (GInstanceInitFunc) files_undo_manager_instance_init, NULL };
	GType files_undo_manager_type_id;
	files_undo_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "FilesUndoManager", &g_define_type_info, 0);
	FilesUndoManager_private_offset = g_type_add_instance_private (files_undo_manager_type_id, sizeof (FilesUndoManagerPrivate));
	return files_undo_manager_type_id;
}

GType
files_undo_manager_get_type (void)
{
	static volatile gsize files_undo_manager_type_id__once = 0;
	if (g_once_init_enter (&files_undo_manager_type_id__once)) {
		GType files_undo_manager_type_id;
		files_undo_manager_type_id = files_undo_manager_get_type_once ();
		g_once_init_leave (&files_undo_manager_type_id__once, files_undo_manager_type_id);
	}
	return files_undo_manager_type_id__once;
}

static void
_vala_files_undo_manager_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	FilesUndoManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_UNDO_MANAGER, FilesUndoManager);
	switch (property_id) {
		case FILES_UNDO_MANAGER_UNDO_LEVELS_PROPERTY:
		g_value_set_uint (value, files_undo_manager_get_undo_levels (self));
		break;
		case FILES_UNDO_MANAGER_CONFIRM_DELETE_PROPERTY:
		g_value_set_boolean (value, files_undo_manager_get_confirm_delete (self));
		break;
		case FILES_UNDO_MANAGER_UNDO_REDO_FLAG_PROPERTY:
		g_value_set_boolean (value, files_undo_manager_get_undo_redo_flag (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_undo_manager_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	FilesUndoManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_UNDO_MANAGER, FilesUndoManager);
	switch (property_id) {
		case FILES_UNDO_MANAGER_UNDO_LEVELS_PROPERTY:
		files_undo_manager_set_undo_levels (self, g_value_get_uint (value));
		break;
		case FILES_UNDO_MANAGER_CONFIRM_DELETE_PROPERTY:
		files_undo_manager_set_confirm_delete (self, g_value_get_boolean (value));
		break;
		case FILES_UNDO_MANAGER_UNDO_REDO_FLAG_PROPERTY:
		files_undo_manager_set_undo_redo_flag (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

