/* RenamerModifier.c generated by valac 0.56.18, the Vala compiler
 * generated from RenamerModifier.vala, do not modify */

/*
 * Copyright (C) 2019-2022 elementary LLC. <https://elementary.io>
 *
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  Authors:
 *  Jeremy Wootten <jeremywootten@gmail.com>
 *
*/

#include <glib-object.h>
#include "pantheon-files-core.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <granite.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_TYPE_RENAMER_MODIFIER (files_renamer_modifier_get_type ())
#define FILES_RENAMER_MODIFIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_RENAMER_MODIFIER, FilesRenamerModifier))
#define FILES_RENAMER_MODIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_RENAMER_MODIFIER, FilesRenamerModifierClass))
#define FILES_IS_RENAMER_MODIFIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_RENAMER_MODIFIER))
#define FILES_IS_RENAMER_MODIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_RENAMER_MODIFIER))
#define FILES_RENAMER_MODIFIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_RENAMER_MODIFIER, FilesRenamerModifierClass))

typedef struct _FilesRenamerModifier FilesRenamerModifier;
typedef struct _FilesRenamerModifierClass FilesRenamerModifierClass;
typedef struct _FilesRenamerModifierPrivate FilesRenamerModifierPrivate;
enum  {
	FILES_RENAMER_MODIFIER_0_PROPERTY,
	FILES_RENAMER_MODIFIER_MODE_PROPERTY,
	FILES_RENAMER_MODIFIER_POS_PROPERTY,
	FILES_RENAMER_MODIFIER_START_PROPERTY,
	FILES_RENAMER_MODIFIER_OLD_START_PROPERTY,
	FILES_RENAMER_MODIFIER_DIGITS_PROPERTY,
	FILES_RENAMER_MODIFIER_OLD_DIGITS_PROPERTY,
	FILES_RENAMER_MODIFIER_SOURCE_PROPERTY,
	FILES_RENAMER_MODIFIER_OLD_SOURCE_PROPERTY,
	FILES_RENAMER_MODIFIER_FORMAT_PROPERTY,
	FILES_RENAMER_MODIFIER_IS_REVERSED_PROPERTY,
	FILES_RENAMER_MODIFIER_OLD_FORMAT_PROPERTY,
	FILES_RENAMER_MODIFIER_OLD_IS_REVERSED_PROPERTY,
	FILES_RENAMER_MODIFIER_TEXT_PROPERTY,
	FILES_RENAMER_MODIFIER_OLD_TEXT_PROPERTY,
	FILES_RENAMER_MODIFIER_SEPARATOR_PROPERTY,
	FILES_RENAMER_MODIFIER_OLD_SEPARATOR_PROPERTY,
	FILES_RENAMER_MODIFIER_NUM_PROPERTIES
};
static GParamSpec* files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define FILES_RENAMER_MODIFIER_TYPE_EDIT_WIDGET (files_renamer_modifier_edit_widget_get_type ())
#define FILES_RENAMER_MODIFIER_EDIT_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_RENAMER_MODIFIER_TYPE_EDIT_WIDGET, FilesRenamerModifierEditWidget))
#define FILES_RENAMER_MODIFIER_EDIT_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_RENAMER_MODIFIER_TYPE_EDIT_WIDGET, FilesRenamerModifierEditWidgetClass))
#define FILES_RENAMER_MODIFIER_IS_EDIT_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_RENAMER_MODIFIER_TYPE_EDIT_WIDGET))
#define FILES_RENAMER_MODIFIER_IS_EDIT_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_RENAMER_MODIFIER_TYPE_EDIT_WIDGET))
#define FILES_RENAMER_MODIFIER_EDIT_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_RENAMER_MODIFIER_TYPE_EDIT_WIDGET, FilesRenamerModifierEditWidgetClass))

typedef struct _FilesRenamerModifierEditWidget FilesRenamerModifierEditWidget;
typedef struct _FilesRenamerModifierEditWidgetClass FilesRenamerModifierEditWidgetClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
typedef struct _FilesRenamerModifierEditWidgetPrivate FilesRenamerModifierEditWidgetPrivate;
enum  {
	FILES_RENAMER_MODIFIER_EDIT_WIDGET_0_PROPERTY,
	FILES_RENAMER_MODIFIER_EDIT_WIDGET_MODIFIER_PROPERTY,
	FILES_RENAMER_MODIFIER_EDIT_WIDGET_NUM_PROPERTIES
};
static GParamSpec* files_renamer_modifier_edit_widget_properties[FILES_RENAMER_MODIFIER_EDIT_WIDGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _FilesRenamerModifier {
	GObject parent_instance;
	FilesRenamerModifierPrivate * priv;
};

struct _FilesRenamerModifierClass {
	GObjectClass parent_class;
};

struct _FilesRenamerModifierPrivate {
	FilesRenameMode _mode;
	FilesRenamePosition _pos;
	gint _start;
	gint _old_start;
	gint _digits;
	gint _old_digits;
	gint _source;
	gint _old_source;
	gint _format;
	gboolean _is_reversed;
	gint _old_format;
	gboolean _old_is_reversed;
	gchar* _text;
	gchar* _old_text;
	gchar* _separator;
	gchar* _old_separator;
};

struct _FilesRenamerModifierEditWidget {
	GtkBin parent_instance;
	FilesRenamerModifierEditWidgetPrivate * priv;
};

struct _FilesRenamerModifierEditWidgetClass {
	GtkBinClass parent_class;
};

struct _FilesRenamerModifierEditWidgetPrivate {
	FilesRenamerModifier* _modifier;
};

static gint FilesRenamerModifier_private_offset;
static gpointer files_renamer_modifier_parent_class = NULL;
static gint FilesRenamerModifierEditWidget_private_offset;
static gpointer files_renamer_modifier_edit_widget_parent_class = NULL;

VALA_EXTERN GType files_renamer_modifier_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesRenamerModifier, g_object_unref)
VALA_EXTERN FilesRenamerModifier* files_renamer_modifier_new_default_number (FilesRenamePosition pos);
VALA_EXTERN FilesRenamerModifier* files_renamer_modifier_construct_default_number (GType object_type,
                                                                       FilesRenamePosition pos);
VALA_EXTERN FilesRenamerModifier* files_renamer_modifier_new_default_date (FilesRenamePosition pos);
VALA_EXTERN FilesRenamerModifier* files_renamer_modifier_construct_default_date (GType object_type,
                                                                     FilesRenamePosition pos);
VALA_EXTERN FilesRenamerModifier* files_renamer_modifier_new_default_text (FilesRenamePosition pos);
VALA_EXTERN FilesRenamerModifier* files_renamer_modifier_construct_default_text (GType object_type,
                                                                     FilesRenamePosition pos);
VALA_EXTERN GtkWidget* files_renamer_modifier_get_modifier_widget (FilesRenamerModifier* self);
VALA_EXTERN gint files_renamer_modifier_get_start (FilesRenamerModifier* self);
VALA_EXTERN void files_renamer_modifier_set_old_start (FilesRenamerModifier* self,
                                           gint value);
VALA_EXTERN gint files_renamer_modifier_get_digits (FilesRenamerModifier* self);
VALA_EXTERN void files_renamer_modifier_set_old_digits (FilesRenamerModifier* self,
                                            gint value);
VALA_EXTERN gint files_renamer_modifier_get_source (FilesRenamerModifier* self);
VALA_EXTERN void files_renamer_modifier_set_old_source (FilesRenamerModifier* self,
                                            gint value);
VALA_EXTERN gint files_renamer_modifier_get_format (FilesRenamerModifier* self);
VALA_EXTERN void files_renamer_modifier_set_old_format (FilesRenamerModifier* self,
                                            gint value);
VALA_EXTERN const gchar* files_renamer_modifier_get_text (FilesRenamerModifier* self);
VALA_EXTERN void files_renamer_modifier_set_old_text (FilesRenamerModifier* self,
                                          const gchar* value);
VALA_EXTERN const gchar* files_renamer_modifier_get_separator (FilesRenamerModifier* self);
VALA_EXTERN void files_renamer_modifier_set_old_separator (FilesRenamerModifier* self,
                                               const gchar* value);
VALA_EXTERN gboolean files_renamer_modifier_get_is_reversed (FilesRenamerModifier* self);
VALA_EXTERN void files_renamer_modifier_set_old_is_reversed (FilesRenamerModifier* self,
                                                 gboolean value);
VALA_EXTERN FilesRenamerModifierEditWidget* files_renamer_modifier_edit_widget_new (FilesRenamerModifier* modifier);
VALA_EXTERN FilesRenamerModifierEditWidget* files_renamer_modifier_edit_widget_construct (GType object_type,
                                                                              FilesRenamerModifier* modifier);
VALA_EXTERN GType files_renamer_modifier_edit_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesRenamerModifierEditWidget, g_object_unref)
VALA_EXTERN void files_renamer_modifier_cancel_edit (FilesRenamerModifier* self);
VALA_EXTERN gint files_renamer_modifier_get_old_start (FilesRenamerModifier* self);
VALA_EXTERN void files_renamer_modifier_set_start (FilesRenamerModifier* self,
                                       gint value);
VALA_EXTERN gint files_renamer_modifier_get_old_digits (FilesRenamerModifier* self);
VALA_EXTERN void files_renamer_modifier_set_digits (FilesRenamerModifier* self,
                                        gint value);
VALA_EXTERN gint files_renamer_modifier_get_old_source (FilesRenamerModifier* self);
VALA_EXTERN void files_renamer_modifier_set_source (FilesRenamerModifier* self,
                                        gint value);
VALA_EXTERN gint files_renamer_modifier_get_old_format (FilesRenamerModifier* self);
VALA_EXTERN void files_renamer_modifier_set_format (FilesRenamerModifier* self,
                                        gint value);
VALA_EXTERN const gchar* files_renamer_modifier_get_old_text (FilesRenamerModifier* self);
VALA_EXTERN void files_renamer_modifier_set_text (FilesRenamerModifier* self,
                                      const gchar* value);
VALA_EXTERN const gchar* files_renamer_modifier_get_old_separator (FilesRenamerModifier* self);
VALA_EXTERN void files_renamer_modifier_set_separator (FilesRenamerModifier* self,
                                           const gchar* value);
VALA_EXTERN gboolean files_renamer_modifier_get_old_is_reversed (FilesRenamerModifier* self);
VALA_EXTERN void files_renamer_modifier_set_is_reversed (FilesRenamerModifier* self,
                                             gboolean value);
VALA_EXTERN gchar* files_renamer_modifier_rename (FilesRenamerModifier* self,
                                      const gchar* input,
                                      guint index,
                                      FilesFile* file);
VALA_EXTERN FilesRenameMode files_renamer_modifier_get_mode (FilesRenamerModifier* self);
VALA_EXTERN gchar* files_renamer_modifier_get_formated_datetime (FilesRenamerModifier* self,
                                                     gint64 dt);
VALA_EXTERN FilesRenamePosition files_renamer_modifier_get_pos (FilesRenamerModifier* self);
VALA_EXTERN gchar* files_renamer_modifier_get_button_text (FilesRenamerModifier* self);
VALA_EXTERN FilesRenamerModifier* files_renamer_modifier_new (void);
VALA_EXTERN FilesRenamerModifier* files_renamer_modifier_construct (GType object_type);
static void files_renamer_modifier_set_mode (FilesRenamerModifier* self,
                                      FilesRenameMode value);
static void files_renamer_modifier_set_pos (FilesRenamerModifier* self,
                                     FilesRenamePosition value);
VALA_EXTERN FilesRenamerModifier* files_renamer_modifier_edit_widget_get_modifier (FilesRenamerModifierEditWidget* self);
static void files_renamer_modifier_edit_widget_set_modifier (FilesRenamerModifierEditWidget* self,
                                                      FilesRenamerModifier* value);
static GObject * files_renamer_modifier_edit_widget_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties);
static void files_renamer_modifier_edit_widget_finalize (GObject * obj);
static GType files_renamer_modifier_edit_widget_get_type_once (void);
static void _vala_files_renamer_modifier_edit_widget_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_files_renamer_modifier_edit_widget_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec);
static void files_renamer_modifier_finalize (GObject * obj);
static GType files_renamer_modifier_get_type_once (void);
static void _vala_files_renamer_modifier_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_files_renamer_modifier_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
files_renamer_modifier_get_instance_private (FilesRenamerModifier* self)
{
	return G_STRUCT_MEMBER_P (self, FilesRenamerModifier_private_offset);
}

FilesRenamerModifier*
files_renamer_modifier_construct_default_number (GType object_type,
                                                 FilesRenamePosition pos)
{
	FilesRenamerModifier * self = NULL;
	self = (FilesRenamerModifier*) g_object_new (object_type, "mode", FILES_RENAME_MODE_NUMBER_SEQUENCE, "pos", pos, NULL);
	return self;
}

FilesRenamerModifier*
files_renamer_modifier_new_default_number (FilesRenamePosition pos)
{
	return files_renamer_modifier_construct_default_number (FILES_TYPE_RENAMER_MODIFIER, pos);
}

FilesRenamerModifier*
files_renamer_modifier_construct_default_date (GType object_type,
                                               FilesRenamePosition pos)
{
	FilesRenamerModifier * self = NULL;
	self = (FilesRenamerModifier*) g_object_new (object_type, "mode", FILES_RENAME_MODE_DATETIME, "pos", pos, NULL);
	return self;
}

FilesRenamerModifier*
files_renamer_modifier_new_default_date (FilesRenamePosition pos)
{
	return files_renamer_modifier_construct_default_date (FILES_TYPE_RENAMER_MODIFIER, pos);
}

FilesRenamerModifier*
files_renamer_modifier_construct_default_text (GType object_type,
                                               FilesRenamePosition pos)
{
	FilesRenamerModifier * self = NULL;
	self = (FilesRenamerModifier*) g_object_new (object_type, "mode", FILES_RENAME_MODE_TEXT, "pos", pos, NULL);
	return self;
}

FilesRenamerModifier*
files_renamer_modifier_new_default_text (FilesRenamePosition pos)
{
	return files_renamer_modifier_construct_default_text (FILES_TYPE_RENAMER_MODIFIER, pos);
}

GtkWidget*
files_renamer_modifier_get_modifier_widget (FilesRenamerModifier* self)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	FilesRenamerModifierEditWidget* _tmp7_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_start;
	files_renamer_modifier_set_old_start (self, _tmp0_);
	_tmp1_ = self->priv->_digits;
	files_renamer_modifier_set_old_digits (self, _tmp1_);
	_tmp2_ = self->priv->_source;
	files_renamer_modifier_set_old_source (self, _tmp2_);
	_tmp3_ = self->priv->_format;
	files_renamer_modifier_set_old_format (self, _tmp3_);
	_tmp4_ = self->priv->_text;
	files_renamer_modifier_set_old_text (self, _tmp4_);
	_tmp5_ = self->priv->_separator;
	files_renamer_modifier_set_old_separator (self, _tmp5_);
	_tmp6_ = self->priv->_is_reversed;
	files_renamer_modifier_set_old_is_reversed (self, _tmp6_);
	_tmp7_ = files_renamer_modifier_edit_widget_new (self);
	g_object_ref_sink (_tmp7_);
	result = (GtkWidget*) _tmp7_;
	return result;
}

void
files_renamer_modifier_cancel_edit (FilesRenamerModifier* self)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_old_start;
	files_renamer_modifier_set_start (self, _tmp0_);
	_tmp1_ = self->priv->_old_digits;
	files_renamer_modifier_set_digits (self, _tmp1_);
	_tmp2_ = self->priv->_old_source;
	files_renamer_modifier_set_source (self, _tmp2_);
	_tmp3_ = self->priv->_old_format;
	files_renamer_modifier_set_format (self, _tmp3_);
	_tmp4_ = self->priv->_old_text;
	files_renamer_modifier_set_text (self, _tmp4_);
	_tmp5_ = self->priv->_old_separator;
	files_renamer_modifier_set_separator (self, _tmp5_);
	_tmp6_ = self->priv->_old_is_reversed;
	files_renamer_modifier_set_is_reversed (self, _tmp6_);
}

gchar*
files_renamer_modifier_rename (FilesRenamerModifier* self,
                               const gchar* input,
                               guint index,
                               FilesFile* file)
{
	gchar* new_text = NULL;
	gchar* _tmp0_;
	FilesRenameMode _tmp1_;
	FilesRenamePosition _tmp18_;
	gchar* _tmp25_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (input != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_strdup ("");
	new_text = _tmp0_;
	_tmp1_ = self->priv->_mode;
	switch (_tmp1_) {
		case FILES_RENAME_MODE_NUMBER_SEQUENCE:
		{
			gboolean _tmp2_ = FALSE;
			gint _tmp3_;
			_tmp3_ = self->priv->_start;
			if (_tmp3_ >= 0) {
				gint _tmp4_;
				_tmp4_ = self->priv->_digits;
				_tmp2_ = _tmp4_ >= 0;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				gchar* template = NULL;
				gint _tmp5_;
				gchar* _tmp6_;
				const gchar* _tmp7_;
				gint _tmp8_;
				gchar* _tmp9_;
				_tmp5_ = self->priv->_digits;
				_tmp6_ = g_strdup_printf ("%%0%id", _tmp5_);
				template = _tmp6_;
				_tmp7_ = template;
				_tmp8_ = self->priv->_start;
				_tmp9_ = g_strdup_printf (_tmp7_, index + _tmp8_);
				_g_free0 (new_text);
				new_text = _tmp9_;
				_g_free0 (template);
			} else {
				gint _tmp10_;
				gint _tmp11_;
				_tmp10_ = self->priv->_start;
				_tmp11_ = self->priv->_digits;
				g_critical ("RenamerModifier.vala:235: Invalid start number %i or digits %i", _tmp10_, _tmp11_);
			}
			break;
		}
		case FILES_RENAME_MODE_TEXT:
		{
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp12_ = self->priv->_text;
			_tmp13_ = g_strdup (_tmp12_);
			_g_free0 (new_text);
			new_text = _tmp13_;
			break;
		}
		case FILES_RENAME_MODE_DATETIME:
		{
			gint _tmp14_;
			_tmp14_ = self->priv->_source;
			switch (_tmp14_) {
				case FILES_RENAME_DATE_SOURCE_MODIFIED:
				{
					gchar* _tmp15_;
					_tmp15_ = files_renamer_modifier_get_formated_datetime (self, (gint64) file->modified);
					_g_free0 (new_text);
					new_text = _tmp15_;
					break;
				}
				case FILES_RENAME_DATE_SOURCE_CREATED:
				{
					gchar* _tmp16_;
					_tmp16_ = files_renamer_modifier_get_formated_datetime (self, (gint64) file->created);
					_g_free0 (new_text);
					new_text = _tmp16_;
					break;
				}
				case FILES_RENAME_DATE_SOURCE_NOW:
				{
					gchar* _tmp17_;
					_tmp17_ = files_renamer_modifier_get_formated_datetime (self, (gint64) -1);
					_g_free0 (new_text);
					new_text = _tmp17_;
					break;
				}
				default:
				{
					break;
				}
			}
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp18_ = self->priv->_pos;
	switch (_tmp18_) {
		case FILES_RENAME_POSITION_SUFFIX:
		{
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp19_ = self->priv->_separator;
			_tmp20_ = new_text;
			_tmp21_ = g_strconcat (input, _tmp19_, _tmp20_, NULL);
			result = _tmp21_;
			_g_free0 (new_text);
			return result;
		}
		case FILES_RENAME_POSITION_PREFIX:
		{
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp22_ = new_text;
			_tmp23_ = self->priv->_separator;
			_tmp24_ = g_strconcat (_tmp22_, _tmp23_, input, NULL);
			result = _tmp24_;
			_g_free0 (new_text);
			return result;
		}
		default:
		{
			break;
		}
	}
	_tmp25_ = g_strdup (input);
	result = _tmp25_;
	_g_free0 (new_text);
	return result;
}

gchar*
files_renamer_modifier_get_formated_datetime (FilesRenamerModifier* self,
                                              gint64 dt)
{
	GDateTime* datetime = NULL;
	gint _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (dt > ((gint64) 0)) {
		GDateTime* _tmp0_;
		_tmp0_ = g_date_time_new_from_unix_local (dt);
		_g_date_time_unref0 (datetime);
		datetime = _tmp0_;
	} else {
		if (dt < ((gint64) 0)) {
			GTimeZone* _tmp1_;
			GTimeZone* _tmp2_;
			GDateTime* _tmp3_;
			_tmp1_ = g_time_zone_new_local ();
			_tmp2_ = _tmp1_;
			_tmp3_ = g_date_time_new_now (_tmp2_);
			_g_date_time_unref0 (datetime);
			datetime = _tmp3_;
			_g_time_zone_unref0 (_tmp2_);
		} else {
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("");
			result = _tmp4_;
			_g_date_time_unref0 (datetime);
			return result;
		}
	}
	_tmp5_ = self->priv->_format;
	switch ((guint) _tmp5_) {
		case FILES_RENAME_DATE_FORMAT_DEFAULT_DATETIME:
		{
			GDateTime* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp6_ = datetime;
			_tmp7_ = granite_date_time_get_default_date_format (FALSE, TRUE, TRUE);
			_tmp8_ = _tmp7_;
			_tmp9_ = granite_date_time_get_default_time_format (FALSE, FALSE);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strconcat (_tmp8_, " ", _tmp10_, NULL);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_date_time_format (_tmp6_, _tmp12_);
			_tmp14_ = _tmp13_;
			_g_free0 (_tmp12_);
			_g_free0 (_tmp10_);
			_g_free0 (_tmp8_);
			result = _tmp14_;
			_g_date_time_unref0 (datetime);
			return result;
		}
		case FILES_RENAME_DATE_FORMAT_LOCALE:
		{
			GDateTime* _tmp15_;
			gchar* _tmp16_;
			_tmp15_ = datetime;
			_tmp16_ = g_date_time_format (_tmp15_, "%c");
			result = _tmp16_;
			_g_date_time_unref0 (datetime);
			return result;
		}
		case FILES_RENAME_DATE_FORMAT_ISO_DATE:
		{
			GDateTime* _tmp17_;
			gchar* _tmp18_;
			_tmp17_ = datetime;
			_tmp18_ = g_date_time_format (_tmp17_, "%Y-%m-%d");
			result = _tmp18_;
			_g_date_time_unref0 (datetime);
			return result;
		}
		case FILES_RENAME_DATE_FORMAT_ISO_DATETIME:
		{
			GDateTime* _tmp19_;
			gchar* _tmp20_;
			_tmp19_ = datetime;
			_tmp20_ = g_date_time_format (_tmp19_, "%Y-%m-%d %H:%M:%S");
			result = _tmp20_;
			_g_date_time_unref0 (datetime);
			return result;
		}
		default:
		{
			GDateTime* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp21_ = datetime;
			_tmp22_ = granite_date_time_get_default_date_format (FALSE, TRUE, TRUE);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_date_time_format (_tmp21_, _tmp23_);
			_tmp25_ = _tmp24_;
			_g_free0 (_tmp23_);
			result = _tmp25_;
			_g_date_time_unref0 (datetime);
			return result;
		}
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

gchar*
files_renamer_modifier_get_button_text (FilesRenamerModifier* self)
{
	FilesRenameMode _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mode;
	switch (_tmp0_) {
		case FILES_RENAME_MODE_NUMBER_SEQUENCE:
		{
			gint _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gchar* _tmp7_;
			_tmp1_ = self->priv->_digits;
			_tmp2_ = self->priv->_start;
			_tmp3_ = self->priv->_digits;
			_tmp4_ = self->priv->_start;
			_tmp5_ = self->priv->_digits;
			_tmp6_ = self->priv->_start;
			_tmp7_ = g_strdup_printf (_ ("%0*d,%0*d,%0*d…"), _tmp1_, _tmp2_, _tmp3_, _tmp4_ + 1, _tmp5_, _tmp6_ + 2);
			result = _tmp7_;
			return result;
		}
		case FILES_RENAME_MODE_TEXT:
		{
			const gchar* _tmp8_;
			_tmp8_ = self->priv->_text;
			if (g_strcmp0 (_tmp8_, "") == 0) {
				gchar* _tmp9_;
				_tmp9_ = g_strdup (_ ("Text"));
				result = _tmp9_;
				return result;
			} else {
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp10_ = self->priv->_text;
				_tmp11_ = self->priv->_text;
				_tmp12_ = strlen (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = string_slice (_tmp10_, (glong) 0, (glong) MIN (_tmp13_ - 1, 5));
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strconcat (_tmp15_, "…", NULL);
				_tmp17_ = _tmp16_;
				_g_free0 (_tmp15_);
				result = _tmp17_;
				return result;
			}
		}
		case FILES_RENAME_MODE_DATETIME:
		{
			gint _tmp18_;
			gchar* _tmp19_;
			_tmp18_ = self->priv->_source;
			_tmp19_ = files_rename_date_source_to_string ((FilesRenameDateSource) _tmp18_);
			result = _tmp19_;
			return result;
		}
		default:
		{
			gchar* _tmp20_;
			_tmp20_ = g_strdup ("");
			result = _tmp20_;
			return result;
		}
	}
}

FilesRenamerModifier*
files_renamer_modifier_construct (GType object_type)
{
	FilesRenamerModifier * self = NULL;
	self = (FilesRenamerModifier*) g_object_new (object_type, NULL);
	return self;
}

FilesRenamerModifier*
files_renamer_modifier_new (void)
{
	return files_renamer_modifier_construct (FILES_TYPE_RENAMER_MODIFIER);
}

FilesRenameMode
files_renamer_modifier_get_mode (FilesRenamerModifier* self)
{
	FilesRenameMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mode;
	return result;
}

static void
files_renamer_modifier_set_mode (FilesRenamerModifier* self,
                                 FilesRenameMode value)
{
	FilesRenameMode old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_modifier_get_mode (self);
	if (old_value != value) {
		self->priv->_mode = value;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_MODE_PROPERTY]);
	}
}

FilesRenamePosition
files_renamer_modifier_get_pos (FilesRenamerModifier* self)
{
	FilesRenamePosition result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_pos;
	return result;
}

static void
files_renamer_modifier_set_pos (FilesRenamerModifier* self,
                                FilesRenamePosition value)
{
	FilesRenamePosition old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_modifier_get_pos (self);
	if (old_value != value) {
		self->priv->_pos = value;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_POS_PROPERTY]);
	}
}

gint
files_renamer_modifier_get_start (FilesRenamerModifier* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_start;
	return result;
}

void
files_renamer_modifier_set_start (FilesRenamerModifier* self,
                                  gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_modifier_get_start (self);
	if (old_value != value) {
		self->priv->_start = value;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_START_PROPERTY]);
	}
}

gint
files_renamer_modifier_get_old_start (FilesRenamerModifier* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_old_start;
	return result;
}

void
files_renamer_modifier_set_old_start (FilesRenamerModifier* self,
                                      gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_modifier_get_old_start (self);
	if (old_value != value) {
		self->priv->_old_start = value;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_OLD_START_PROPERTY]);
	}
}

gint
files_renamer_modifier_get_digits (FilesRenamerModifier* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_digits;
	return result;
}

void
files_renamer_modifier_set_digits (FilesRenamerModifier* self,
                                   gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_modifier_get_digits (self);
	if (old_value != value) {
		self->priv->_digits = value;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_DIGITS_PROPERTY]);
	}
}

gint
files_renamer_modifier_get_old_digits (FilesRenamerModifier* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_old_digits;
	return result;
}

void
files_renamer_modifier_set_old_digits (FilesRenamerModifier* self,
                                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_modifier_get_old_digits (self);
	if (old_value != value) {
		self->priv->_old_digits = value;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_OLD_DIGITS_PROPERTY]);
	}
}

gint
files_renamer_modifier_get_source (FilesRenamerModifier* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_source;
	return result;
}

void
files_renamer_modifier_set_source (FilesRenamerModifier* self,
                                   gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_modifier_get_source (self);
	if (old_value != value) {
		self->priv->_source = value;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_SOURCE_PROPERTY]);
	}
}

gint
files_renamer_modifier_get_old_source (FilesRenamerModifier* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_old_source;
	return result;
}

void
files_renamer_modifier_set_old_source (FilesRenamerModifier* self,
                                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_modifier_get_old_source (self);
	if (old_value != value) {
		self->priv->_old_source = value;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_OLD_SOURCE_PROPERTY]);
	}
}

gint
files_renamer_modifier_get_format (FilesRenamerModifier* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_format;
	return result;
}

void
files_renamer_modifier_set_format (FilesRenamerModifier* self,
                                   gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_modifier_get_format (self);
	if (old_value != value) {
		self->priv->_format = value;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_FORMAT_PROPERTY]);
	}
}

gboolean
files_renamer_modifier_get_is_reversed (FilesRenamerModifier* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_reversed;
	return result;
}

void
files_renamer_modifier_set_is_reversed (FilesRenamerModifier* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_modifier_get_is_reversed (self);
	if (old_value != value) {
		self->priv->_is_reversed = value;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_IS_REVERSED_PROPERTY]);
	}
}

gint
files_renamer_modifier_get_old_format (FilesRenamerModifier* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_old_format;
	return result;
}

void
files_renamer_modifier_set_old_format (FilesRenamerModifier* self,
                                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_modifier_get_old_format (self);
	if (old_value != value) {
		self->priv->_old_format = value;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_OLD_FORMAT_PROPERTY]);
	}
}

gboolean
files_renamer_modifier_get_old_is_reversed (FilesRenamerModifier* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_old_is_reversed;
	return result;
}

void
files_renamer_modifier_set_old_is_reversed (FilesRenamerModifier* self,
                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_modifier_get_old_is_reversed (self);
	if (old_value != value) {
		self->priv->_old_is_reversed = value;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_OLD_IS_REVERSED_PROPERTY]);
	}
}

const gchar*
files_renamer_modifier_get_text (FilesRenamerModifier* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}

void
files_renamer_modifier_set_text (FilesRenamerModifier* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_modifier_get_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_text);
		self->priv->_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_TEXT_PROPERTY]);
	}
}

const gchar*
files_renamer_modifier_get_old_text (FilesRenamerModifier* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_old_text;
	result = _tmp0_;
	return result;
}

void
files_renamer_modifier_set_old_text (FilesRenamerModifier* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_modifier_get_old_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_old_text);
		self->priv->_old_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_OLD_TEXT_PROPERTY]);
	}
}

const gchar*
files_renamer_modifier_get_separator (FilesRenamerModifier* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_separator;
	result = _tmp0_;
	return result;
}

void
files_renamer_modifier_set_separator (FilesRenamerModifier* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_modifier_get_separator (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_separator);
		self->priv->_separator = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_SEPARATOR_PROPERTY]);
	}
}

const gchar*
files_renamer_modifier_get_old_separator (FilesRenamerModifier* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_old_separator;
	result = _tmp0_;
	return result;
}

void
files_renamer_modifier_set_old_separator (FilesRenamerModifier* self,
                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_modifier_get_old_separator (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_old_separator);
		self->priv->_old_separator = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_OLD_SEPARATOR_PROPERTY]);
	}
}

static inline gpointer
files_renamer_modifier_edit_widget_get_instance_private (FilesRenamerModifierEditWidget* self)
{
	return G_STRUCT_MEMBER_P (self, FilesRenamerModifierEditWidget_private_offset);
}

FilesRenamerModifierEditWidget*
files_renamer_modifier_edit_widget_construct (GType object_type,
                                              FilesRenamerModifier* modifier)
{
	FilesRenamerModifierEditWidget * self = NULL;
	g_return_val_if_fail (modifier != NULL, NULL);
	self = (FilesRenamerModifierEditWidget*) g_object_new (object_type, "modifier", modifier, NULL);
	return self;
}

FilesRenamerModifierEditWidget*
files_renamer_modifier_edit_widget_new (FilesRenamerModifier* modifier)
{
	return files_renamer_modifier_edit_widget_construct (FILES_RENAMER_MODIFIER_TYPE_EDIT_WIDGET, modifier);
}

FilesRenamerModifier*
files_renamer_modifier_edit_widget_get_modifier (FilesRenamerModifierEditWidget* self)
{
	FilesRenamerModifier* result;
	FilesRenamerModifier* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_modifier;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
files_renamer_modifier_edit_widget_set_modifier (FilesRenamerModifierEditWidget* self,
                                                 FilesRenamerModifier* value)
{
	FilesRenamerModifier* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_renamer_modifier_edit_widget_get_modifier (self);
	if (old_value != value) {
		FilesRenamerModifier* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_modifier);
		self->priv->_modifier = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_renamer_modifier_edit_widget_properties[FILES_RENAMER_MODIFIER_EDIT_WIDGET_MODIFIER_PROPERTY]);
	}
}

static GObject *
files_renamer_modifier_edit_widget_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesRenamerModifierEditWidget * self;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp0_ = NULL;
	GtkWidget* controls = NULL;
	GBindingFlags flags = 0U;
	FilesRenamerModifier* _tmp1_;
	FilesRenameMode _tmp2_;
	FilesRenameMode _tmp3_;
	GtkEntry* separator_entry = NULL;
	FilesRenamerModifier* _tmp94_;
	const gchar* _tmp95_;
	const gchar* _tmp96_;
	gchar* _tmp97_;
	GtkEntry* _tmp98_ = NULL;
	GtkLabel* separator_label = NULL;
	GtkLabel* _tmp99_ = NULL;
	GtkEntry* _tmp100_;
	FilesRenamerModifier* _tmp101_;
	GtkGrid* _tmp102_;
	GtkLabel* _tmp103_;
	GtkGrid* _tmp104_;
	GtkEntry* _tmp105_;
	GtkGrid* _tmp106_;
	GtkWidget* _tmp107_;
	GtkGrid* _tmp108_;
	parent_class = G_OBJECT_CLASS (files_renamer_modifier_edit_widget_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_RENAMER_MODIFIER_TYPE_EDIT_WIDGET, FilesRenamerModifierEditWidget);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_homogeneous (_tmp0_, TRUE);
	gtk_grid_set_column_spacing (_tmp0_, 6);
	gtk_grid_set_row_spacing (_tmp0_, 6);
	g_object_set ((GtkWidget*) _tmp0_, "margin", 12, NULL);
	g_object_ref_sink (_tmp0_);
	grid = _tmp0_;
	flags = G_BINDING_DEFAULT;
	_tmp1_ = self->priv->_modifier;
	_tmp2_ = files_renamer_modifier_get_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	switch (_tmp3_) {
		case FILES_RENAME_MODE_NUMBER_SEQUENCE:
		{
			GtkLabel* isreversed_label = NULL;
			GtkLabel* _tmp4_ = NULL;
			GtkCheckButton* is_reversed_check = NULL;
			FilesRenamerModifier* _tmp5_;
			gboolean _tmp6_;
			gboolean _tmp7_;
			GtkCheckButton* _tmp8_ = NULL;
			GtkLabel* start_number_label = NULL;
			GtkLabel* _tmp9_ = NULL;
			GtkSpinButton* start_number_spin_button = NULL;
			FilesRenamerModifier* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			GtkSpinButton* _tmp13_ = NULL;
			GtkLabel* digits_label = NULL;
			GtkLabel* _tmp14_ = NULL;
			GtkSpinButton* digits_spin_button = NULL;
			FilesRenamerModifier* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			GtkSpinButton* _tmp18_ = NULL;
			GtkGrid* number_grid = NULL;
			GtkGrid* _tmp19_ = NULL;
			GtkGrid* _tmp20_;
			GtkLabel* _tmp21_;
			GtkGrid* _tmp22_;
			GtkSpinButton* _tmp23_;
			GtkGrid* _tmp24_;
			GtkLabel* _tmp25_;
			GtkGrid* _tmp26_;
			GtkSpinButton* _tmp27_;
			GtkGrid* _tmp28_;
			GtkLabel* _tmp29_;
			GtkGrid* _tmp30_;
			GtkCheckButton* _tmp31_;
			GtkGrid* _tmp32_;
			GtkWidget* _tmp33_;
			GtkCheckButton* _tmp34_;
			FilesRenamerModifier* _tmp35_;
			GtkSpinButton* _tmp36_;
			FilesRenamerModifier* _tmp37_;
			GtkSpinButton* _tmp38_;
			FilesRenamerModifier* _tmp39_;
			_tmp4_ = (GtkLabel*) gtk_label_new (_ ("Reverse Order"));
			gtk_widget_set_halign ((GtkWidget*) _tmp4_, GTK_ALIGN_END);
			g_object_ref_sink (_tmp4_);
			isreversed_label = _tmp4_;
			_tmp5_ = self->priv->_modifier;
			_tmp6_ = files_renamer_modifier_get_is_reversed (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = (GtkCheckButton*) gtk_check_button_new ();
			gtk_widget_set_valign ((GtkWidget*) _tmp8_, GTK_ALIGN_CENTER);
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp8_, _tmp7_);
			gtk_widget_set_hexpand ((GtkWidget*) _tmp8_, FALSE);
			g_object_ref_sink (_tmp8_);
			is_reversed_check = _tmp8_;
			_tmp9_ = (GtkLabel*) gtk_label_new (_ ("Start Number"));
			gtk_widget_set_halign ((GtkWidget*) _tmp9_, GTK_ALIGN_END);
			g_object_ref_sink (_tmp9_);
			start_number_label = _tmp9_;
			_tmp10_ = self->priv->_modifier;
			_tmp11_ = files_renamer_modifier_get_start (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 0, (gdouble) G_MAXINT, (gdouble) 1);
			gtk_widget_set_halign ((GtkWidget*) _tmp13_, GTK_ALIGN_START);
			gtk_spin_button_set_value (_tmp13_, (gdouble) _tmp12_);
			g_object_ref_sink (_tmp13_);
			start_number_spin_button = _tmp13_;
			_tmp14_ = (GtkLabel*) gtk_label_new (_ ("Digits"));
			gtk_widget_set_halign ((GtkWidget*) _tmp14_, GTK_ALIGN_END);
			g_object_ref_sink (_tmp14_);
			digits_label = _tmp14_;
			_tmp15_ = self->priv->_modifier;
			_tmp16_ = files_renamer_modifier_get_digits (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 1, (gdouble) G_MAXINT, (gdouble) 1);
			gtk_widget_set_halign ((GtkWidget*) _tmp18_, GTK_ALIGN_START);
			gtk_spin_button_set_value (_tmp18_, (gdouble) _tmp17_);
			g_object_ref_sink (_tmp18_);
			digits_spin_button = _tmp18_;
			_tmp19_ = (GtkGrid*) gtk_grid_new ();
			gtk_grid_set_column_homogeneous (_tmp19_, TRUE);
			gtk_grid_set_column_spacing (_tmp19_, 6);
			gtk_grid_set_row_spacing (_tmp19_, 6);
			g_object_ref_sink (_tmp19_);
			number_grid = _tmp19_;
			_tmp20_ = number_grid;
			_tmp21_ = start_number_label;
			gtk_grid_attach (_tmp20_, (GtkWidget*) _tmp21_, 0, 0, 1, 1);
			_tmp22_ = number_grid;
			_tmp23_ = start_number_spin_button;
			gtk_grid_attach (_tmp22_, (GtkWidget*) _tmp23_, 1, 0, 1, 1);
			_tmp24_ = number_grid;
			_tmp25_ = digits_label;
			gtk_grid_attach (_tmp24_, (GtkWidget*) _tmp25_, 0, 1, 1, 1);
			_tmp26_ = number_grid;
			_tmp27_ = digits_spin_button;
			gtk_grid_attach (_tmp26_, (GtkWidget*) _tmp27_, 1, 1, 1, 1);
			_tmp28_ = number_grid;
			_tmp29_ = isreversed_label;
			gtk_grid_attach (_tmp28_, (GtkWidget*) _tmp29_, 0, 3, 1, 1);
			_tmp30_ = number_grid;
			_tmp31_ = is_reversed_check;
			gtk_grid_attach (_tmp30_, (GtkWidget*) _tmp31_, 1, 3, 1, 1);
			_tmp32_ = number_grid;
			_tmp33_ = _g_object_ref0 ((GtkWidget*) _tmp32_);
			_g_object_unref0 (controls);
			controls = _tmp33_;
			_tmp34_ = is_reversed_check;
			_tmp35_ = self->priv->_modifier;
			g_object_bind_property_with_closures ((GObject*) _tmp34_, "active", (GObject*) _tmp35_, "is-reversed", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
			_tmp36_ = digits_spin_button;
			_tmp37_ = self->priv->_modifier;
			g_object_bind_property_with_closures ((GObject*) _tmp36_, "value", (GObject*) _tmp37_, "digits", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
			_tmp38_ = start_number_spin_button;
			_tmp39_ = self->priv->_modifier;
			g_object_bind_property_with_closures ((GObject*) _tmp38_, "value", (GObject*) _tmp39_, "start", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
			_g_object_unref0 (number_grid);
			_g_object_unref0 (digits_spin_button);
			_g_object_unref0 (digits_label);
			_g_object_unref0 (start_number_spin_button);
			_g_object_unref0 (start_number_label);
			_g_object_unref0 (is_reversed_check);
			_g_object_unref0 (isreversed_label);
			break;
		}
		case FILES_RENAME_MODE_DATETIME:
		{
			GtkComboBoxText* date_source_combo = NULL;
			GtkComboBoxText* _tmp40_ = NULL;
			GtkComboBoxText* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			GtkComboBoxText* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			GtkComboBoxText* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			GtkComboBoxText* date_format_combo = NULL;
			GtkComboBoxText* _tmp50_ = NULL;
			GtkComboBoxText* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			GtkComboBoxText* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			GtkComboBoxText* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			GtkComboBoxText* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			GtkComboBoxText* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			GtkBox* box = NULL;
			GtkBox* _tmp66_;
			GtkBox* _tmp67_;
			GtkComboBoxText* _tmp68_;
			GtkBox* _tmp69_;
			GtkComboBoxText* _tmp70_;
			GtkBox* _tmp71_;
			GtkWidget* _tmp72_;
			GtkComboBoxText* _tmp73_;
			FilesRenamerModifier* _tmp74_;
			gint _tmp75_;
			gint _tmp76_;
			GtkComboBoxText* _tmp77_;
			FilesRenamerModifier* _tmp78_;
			gint _tmp79_;
			gint _tmp80_;
			GtkComboBoxText* _tmp81_;
			FilesRenamerModifier* _tmp82_;
			GtkComboBoxText* _tmp83_;
			FilesRenamerModifier* _tmp84_;
			_tmp40_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
			gtk_widget_set_valign ((GtkWidget*) _tmp40_, GTK_ALIGN_CENTER);
			g_object_ref_sink (_tmp40_);
			date_source_combo = _tmp40_;
			_tmp41_ = date_source_combo;
			_tmp42_ = files_rename_date_source_to_string (FILES_RENAME_DATE_SOURCE_CREATED);
			_tmp43_ = _tmp42_;
			gtk_combo_box_text_insert (_tmp41_, (gint) FILES_RENAME_DATE_SOURCE_CREATED, "DEFAULT", _tmp43_);
			_g_free0 (_tmp43_);
			_tmp44_ = date_source_combo;
			_tmp45_ = files_rename_date_source_to_string (FILES_RENAME_DATE_SOURCE_MODIFIED);
			_tmp46_ = _tmp45_;
			gtk_combo_box_text_insert (_tmp44_, (gint) FILES_RENAME_DATE_SOURCE_MODIFIED, "MODIFICATION_DATE", _tmp46_);
			_g_free0 (_tmp46_);
			_tmp47_ = date_source_combo;
			_tmp48_ = files_rename_date_source_to_string (FILES_RENAME_DATE_SOURCE_NOW);
			_tmp49_ = _tmp48_;
			gtk_combo_box_text_insert (_tmp47_, (gint) FILES_RENAME_DATE_SOURCE_NOW, "CURRENT_DATE", _tmp49_);
			_g_free0 (_tmp49_);
			_tmp50_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
			gtk_widget_set_valign ((GtkWidget*) _tmp50_, GTK_ALIGN_CENTER);
			g_object_ref_sink (_tmp50_);
			date_format_combo = _tmp50_;
			_tmp51_ = date_format_combo;
			_tmp52_ = files_rename_date_format_to_string (FILES_RENAME_DATE_FORMAT_DEFAULT);
			_tmp53_ = _tmp52_;
			gtk_combo_box_text_insert (_tmp51_, (gint) FILES_RENAME_DATE_FORMAT_DEFAULT, "DEFAULT", _tmp53_);
			_g_free0 (_tmp53_);
			_tmp54_ = date_format_combo;
			_tmp55_ = files_rename_date_format_to_string (FILES_RENAME_DATE_FORMAT_DEFAULT_DATETIME);
			_tmp56_ = _tmp55_;
			gtk_combo_box_text_insert (_tmp54_, (gint) FILES_RENAME_DATE_FORMAT_DEFAULT_DATETIME, "DEFAULT_DATETIME", _tmp56_);
			_g_free0 (_tmp56_);
			_tmp57_ = date_format_combo;
			_tmp58_ = files_rename_date_format_to_string (FILES_RENAME_DATE_FORMAT_LOCALE);
			_tmp59_ = _tmp58_;
			gtk_combo_box_text_insert (_tmp57_, (gint) FILES_RENAME_DATE_FORMAT_LOCALE, "LOCALE", _tmp59_);
			_g_free0 (_tmp59_);
			_tmp60_ = date_format_combo;
			_tmp61_ = files_rename_date_format_to_string (FILES_RENAME_DATE_FORMAT_ISO_DATE);
			_tmp62_ = _tmp61_;
			gtk_combo_box_text_insert (_tmp60_, (gint) FILES_RENAME_DATE_FORMAT_ISO_DATE, "ISO_DATE", _tmp62_);
			_g_free0 (_tmp62_);
			_tmp63_ = date_format_combo;
			_tmp64_ = files_rename_date_format_to_string (FILES_RENAME_DATE_FORMAT_ISO_DATETIME);
			_tmp65_ = _tmp64_;
			gtk_combo_box_text_insert (_tmp63_, (gint) FILES_RENAME_DATE_FORMAT_ISO_DATETIME, "ISO_DATETIME", _tmp65_);
			_g_free0 (_tmp65_);
			_tmp66_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
			g_object_ref_sink (_tmp66_);
			box = _tmp66_;
			_tmp67_ = box;
			_tmp68_ = date_source_combo;
			gtk_container_add ((GtkContainer*) _tmp67_, (GtkWidget*) _tmp68_);
			_tmp69_ = box;
			_tmp70_ = date_format_combo;
			gtk_container_add ((GtkContainer*) _tmp69_, (GtkWidget*) _tmp70_);
			_tmp71_ = box;
			_tmp72_ = _g_object_ref0 ((GtkWidget*) _tmp71_);
			_g_object_unref0 (controls);
			controls = _tmp72_;
			_tmp73_ = date_source_combo;
			_tmp74_ = self->priv->_modifier;
			_tmp75_ = files_renamer_modifier_get_source (_tmp74_);
			_tmp76_ = _tmp75_;
			gtk_combo_box_set_active ((GtkComboBox*) _tmp73_, _tmp76_);
			_tmp77_ = date_format_combo;
			_tmp78_ = self->priv->_modifier;
			_tmp79_ = files_renamer_modifier_get_format (_tmp78_);
			_tmp80_ = _tmp79_;
			gtk_combo_box_set_active ((GtkComboBox*) _tmp77_, _tmp80_);
			_tmp81_ = date_source_combo;
			_tmp82_ = self->priv->_modifier;
			g_object_bind_property_with_closures ((GObject*) _tmp81_, "active", (GObject*) _tmp82_, "source", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
			_tmp83_ = date_format_combo;
			_tmp84_ = self->priv->_modifier;
			g_object_bind_property_with_closures ((GObject*) _tmp83_, "active", (GObject*) _tmp84_, "format", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
			_g_object_unref0 (box);
			_g_object_unref0 (date_format_combo);
			_g_object_unref0 (date_source_combo);
			break;
		}
		case FILES_RENAME_MODE_TEXT:
		{
			GtkEntry* text_entry = NULL;
			FilesRenamerModifier* _tmp85_;
			const gchar* _tmp86_;
			const gchar* _tmp87_;
			gchar* _tmp88_;
			GtkEntry* _tmp89_ = NULL;
			GtkEntry* _tmp90_;
			GtkWidget* _tmp91_;
			GtkEntry* _tmp92_;
			FilesRenamerModifier* _tmp93_;
			_tmp85_ = self->priv->_modifier;
			_tmp86_ = files_renamer_modifier_get_text (_tmp85_);
			_tmp87_ = _tmp86_;
			_tmp88_ = g_strdup (_tmp87_);
			_tmp89_ = (GtkEntry*) gtk_entry_new ();
			gtk_widget_set_vexpand ((GtkWidget*) _tmp89_, FALSE);
			gtk_widget_set_hexpand ((GtkWidget*) _tmp89_, FALSE);
			gtk_entry_set_max_length (_tmp89_, 64);
			gtk_entry_set_max_width_chars (_tmp89_, 15);
			gtk_entry_set_text (_tmp89_, _tmp88_);
			_g_free0 (_tmp88_);
			g_object_ref_sink (_tmp89_);
			text_entry = _tmp89_;
			_tmp90_ = text_entry;
			_tmp91_ = _g_object_ref0 ((GtkWidget*) _tmp90_);
			_g_object_unref0 (controls);
			controls = _tmp91_;
			_tmp92_ = text_entry;
			_tmp93_ = self->priv->_modifier;
			g_object_bind_property_with_closures ((GObject*) _tmp92_, "text", (GObject*) _tmp93_, "text", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
			_g_object_unref0 (text_entry);
			break;
		}
		default:
		{
			g_assert_not_reached ();
			break;
		}
	}
	_tmp94_ = self->priv->_modifier;
	_tmp95_ = files_renamer_modifier_get_separator (_tmp94_);
	_tmp96_ = _tmp95_;
	_tmp97_ = g_strdup (_tmp96_);
	_tmp98_ = (GtkEntry*) gtk_entry_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp98_, GTK_ALIGN_START);
	gtk_entry_set_max_length (_tmp98_, 3);
	gtk_entry_set_text (_tmp98_, _tmp97_);
	_g_free0 (_tmp97_);
	g_object_ref_sink (_tmp98_);
	separator_entry = _tmp98_;
	_tmp99_ = (GtkLabel*) gtk_label_new (_ ("Separator"));
	gtk_widget_set_halign ((GtkWidget*) _tmp99_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp99_);
	separator_label = _tmp99_;
	_tmp100_ = separator_entry;
	_tmp101_ = self->priv->_modifier;
	g_object_bind_property_with_closures ((GObject*) _tmp100_, "text", (GObject*) _tmp101_, "separator", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp102_ = grid;
	_tmp103_ = separator_label;
	gtk_grid_attach (_tmp102_, (GtkWidget*) _tmp103_, 0, 0, 1, 1);
	_tmp104_ = grid;
	_tmp105_ = separator_entry;
	gtk_grid_attach (_tmp104_, (GtkWidget*) _tmp105_, 1, 0, 1, 1);
	_tmp106_ = grid;
	_tmp107_ = controls;
	gtk_grid_attach (_tmp106_, _tmp107_, 0, 1, 2, 1);
	_tmp108_ = grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp108_);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (separator_label);
	_g_object_unref0 (separator_entry);
	_g_object_unref0 (controls);
	_g_object_unref0 (grid);
	return obj;
}

static void
files_renamer_modifier_edit_widget_class_init (FilesRenamerModifierEditWidgetClass * klass,
                                               gpointer klass_data)
{
	files_renamer_modifier_edit_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesRenamerModifierEditWidget_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_files_renamer_modifier_edit_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_renamer_modifier_edit_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = files_renamer_modifier_edit_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_renamer_modifier_edit_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_MODIFIER_EDIT_WIDGET_MODIFIER_PROPERTY, files_renamer_modifier_edit_widget_properties[FILES_RENAMER_MODIFIER_EDIT_WIDGET_MODIFIER_PROPERTY] = g_param_spec_object ("modifier", "modifier", "modifier", FILES_TYPE_RENAMER_MODIFIER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
files_renamer_modifier_edit_widget_instance_init (FilesRenamerModifierEditWidget * self,
                                                  gpointer klass)
{
	self->priv = files_renamer_modifier_edit_widget_get_instance_private (self);
}

static void
files_renamer_modifier_edit_widget_finalize (GObject * obj)
{
	FilesRenamerModifierEditWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_RENAMER_MODIFIER_TYPE_EDIT_WIDGET, FilesRenamerModifierEditWidget);
	_g_object_unref0 (self->priv->_modifier);
	G_OBJECT_CLASS (files_renamer_modifier_edit_widget_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_renamer_modifier_edit_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesRenamerModifierEditWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_renamer_modifier_edit_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesRenamerModifierEditWidget), 0, (GInstanceInitFunc) files_renamer_modifier_edit_widget_instance_init, NULL };
	GType files_renamer_modifier_edit_widget_type_id;
	files_renamer_modifier_edit_widget_type_id = g_type_register_static (gtk_bin_get_type (), "FilesRenamerModifierEditWidget", &g_define_type_info, 0);
	FilesRenamerModifierEditWidget_private_offset = g_type_add_instance_private (files_renamer_modifier_edit_widget_type_id, sizeof (FilesRenamerModifierEditWidgetPrivate));
	return files_renamer_modifier_edit_widget_type_id;
}

GType
files_renamer_modifier_edit_widget_get_type (void)
{
	static volatile gsize files_renamer_modifier_edit_widget_type_id__once = 0;
	if (g_once_init_enter (&files_renamer_modifier_edit_widget_type_id__once)) {
		GType files_renamer_modifier_edit_widget_type_id;
		files_renamer_modifier_edit_widget_type_id = files_renamer_modifier_edit_widget_get_type_once ();
		g_once_init_leave (&files_renamer_modifier_edit_widget_type_id__once, files_renamer_modifier_edit_widget_type_id);
	}
	return files_renamer_modifier_edit_widget_type_id__once;
}

static void
_vala_files_renamer_modifier_edit_widget_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	FilesRenamerModifierEditWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_RENAMER_MODIFIER_TYPE_EDIT_WIDGET, FilesRenamerModifierEditWidget);
	switch (property_id) {
		case FILES_RENAMER_MODIFIER_EDIT_WIDGET_MODIFIER_PROPERTY:
		g_value_set_object (value, files_renamer_modifier_edit_widget_get_modifier (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_renamer_modifier_edit_widget_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec)
{
	FilesRenamerModifierEditWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_RENAMER_MODIFIER_TYPE_EDIT_WIDGET, FilesRenamerModifierEditWidget);
	switch (property_id) {
		case FILES_RENAMER_MODIFIER_EDIT_WIDGET_MODIFIER_PROPERTY:
		files_renamer_modifier_edit_widget_set_modifier (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
files_renamer_modifier_class_init (FilesRenamerModifierClass * klass,
                                   gpointer klass_data)
{
	files_renamer_modifier_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesRenamerModifier_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_files_renamer_modifier_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_renamer_modifier_set_property;
	G_OBJECT_CLASS (klass)->finalize = files_renamer_modifier_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_MODIFIER_MODE_PROPERTY, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_MODE_PROPERTY] = g_param_spec_enum ("mode", "mode", "mode", FILES_TYPE_RENAME_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_MODIFIER_POS_PROPERTY, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_POS_PROPERTY] = g_param_spec_enum ("pos", "pos", "pos", FILES_TYPE_RENAME_POSITION, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_MODIFIER_START_PROPERTY, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_START_PROPERTY] = g_param_spec_int ("start", "start", "start", G_MININT, G_MAXINT, 1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_MODIFIER_OLD_START_PROPERTY, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_OLD_START_PROPERTY] = g_param_spec_int ("old-start", "old-start", "old-start", G_MININT, G_MAXINT, 1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_MODIFIER_DIGITS_PROPERTY, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_DIGITS_PROPERTY] = g_param_spec_int ("digits", "digits", "digits", G_MININT, G_MAXINT, 1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_MODIFIER_OLD_DIGITS_PROPERTY, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_OLD_DIGITS_PROPERTY] = g_param_spec_int ("old-digits", "old-digits", "old-digits", G_MININT, G_MAXINT, 1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_MODIFIER_SOURCE_PROPERTY, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_SOURCE_PROPERTY] = g_param_spec_int ("source", "source", "source", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_MODIFIER_OLD_SOURCE_PROPERTY, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_OLD_SOURCE_PROPERTY] = g_param_spec_int ("old-source", "old-source", "old-source", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_MODIFIER_FORMAT_PROPERTY, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_FORMAT_PROPERTY] = g_param_spec_int ("format", "format", "format", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_MODIFIER_IS_REVERSED_PROPERTY, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_IS_REVERSED_PROPERTY] = g_param_spec_boolean ("is-reversed", "is-reversed", "is-reversed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_MODIFIER_OLD_FORMAT_PROPERTY, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_OLD_FORMAT_PROPERTY] = g_param_spec_int ("old-format", "old-format", "old-format", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_MODIFIER_OLD_IS_REVERSED_PROPERTY, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_OLD_IS_REVERSED_PROPERTY] = g_param_spec_boolean ("old-is-reversed", "old-is-reversed", "old-is-reversed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_MODIFIER_TEXT_PROPERTY, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_MODIFIER_OLD_TEXT_PROPERTY, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_OLD_TEXT_PROPERTY] = g_param_spec_string ("old-text", "old-text", "old-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_MODIFIER_SEPARATOR_PROPERTY, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_SEPARATOR_PROPERTY] = g_param_spec_string ("separator", "separator", "separator", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_RENAMER_MODIFIER_OLD_SEPARATOR_PROPERTY, files_renamer_modifier_properties[FILES_RENAMER_MODIFIER_OLD_SEPARATOR_PROPERTY] = g_param_spec_string ("old-separator", "old-separator", "old-separator", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
files_renamer_modifier_instance_init (FilesRenamerModifier * self,
                                      gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self->priv = files_renamer_modifier_get_instance_private (self);
	self->priv->_start = 1;
	self->priv->_old_start = 1;
	self->priv->_digits = 1;
	self->priv->_old_digits = 1;
	self->priv->_source = 0;
	self->priv->_old_source = 0;
	self->priv->_format = 0;
	self->priv->_is_reversed = FALSE;
	self->priv->_old_format = 0;
	self->priv->_old_is_reversed = FALSE;
	_tmp0_ = g_strdup ("");
	self->priv->_text = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_old_text = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_separator = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->_old_separator = _tmp3_;
}

static void
files_renamer_modifier_finalize (GObject * obj)
{
	FilesRenamerModifier * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_RENAMER_MODIFIER, FilesRenamerModifier);
	_g_free0 (self->priv->_text);
	_g_free0 (self->priv->_old_text);
	_g_free0 (self->priv->_separator);
	_g_free0 (self->priv->_old_separator);
	G_OBJECT_CLASS (files_renamer_modifier_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_renamer_modifier_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesRenamerModifierClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_renamer_modifier_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesRenamerModifier), 0, (GInstanceInitFunc) files_renamer_modifier_instance_init, NULL };
	GType files_renamer_modifier_type_id;
	files_renamer_modifier_type_id = g_type_register_static (G_TYPE_OBJECT, "FilesRenamerModifier", &g_define_type_info, 0);
	FilesRenamerModifier_private_offset = g_type_add_instance_private (files_renamer_modifier_type_id, sizeof (FilesRenamerModifierPrivate));
	return files_renamer_modifier_type_id;
}

GType
files_renamer_modifier_get_type (void)
{
	static volatile gsize files_renamer_modifier_type_id__once = 0;
	if (g_once_init_enter (&files_renamer_modifier_type_id__once)) {
		GType files_renamer_modifier_type_id;
		files_renamer_modifier_type_id = files_renamer_modifier_get_type_once ();
		g_once_init_leave (&files_renamer_modifier_type_id__once, files_renamer_modifier_type_id);
	}
	return files_renamer_modifier_type_id__once;
}

static void
_vala_files_renamer_modifier_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	FilesRenamerModifier * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_RENAMER_MODIFIER, FilesRenamerModifier);
	switch (property_id) {
		case FILES_RENAMER_MODIFIER_MODE_PROPERTY:
		g_value_set_enum (value, files_renamer_modifier_get_mode (self));
		break;
		case FILES_RENAMER_MODIFIER_POS_PROPERTY:
		g_value_set_enum (value, files_renamer_modifier_get_pos (self));
		break;
		case FILES_RENAMER_MODIFIER_START_PROPERTY:
		g_value_set_int (value, files_renamer_modifier_get_start (self));
		break;
		case FILES_RENAMER_MODIFIER_OLD_START_PROPERTY:
		g_value_set_int (value, files_renamer_modifier_get_old_start (self));
		break;
		case FILES_RENAMER_MODIFIER_DIGITS_PROPERTY:
		g_value_set_int (value, files_renamer_modifier_get_digits (self));
		break;
		case FILES_RENAMER_MODIFIER_OLD_DIGITS_PROPERTY:
		g_value_set_int (value, files_renamer_modifier_get_old_digits (self));
		break;
		case FILES_RENAMER_MODIFIER_SOURCE_PROPERTY:
		g_value_set_int (value, files_renamer_modifier_get_source (self));
		break;
		case FILES_RENAMER_MODIFIER_OLD_SOURCE_PROPERTY:
		g_value_set_int (value, files_renamer_modifier_get_old_source (self));
		break;
		case FILES_RENAMER_MODIFIER_FORMAT_PROPERTY:
		g_value_set_int (value, files_renamer_modifier_get_format (self));
		break;
		case FILES_RENAMER_MODIFIER_IS_REVERSED_PROPERTY:
		g_value_set_boolean (value, files_renamer_modifier_get_is_reversed (self));
		break;
		case FILES_RENAMER_MODIFIER_OLD_FORMAT_PROPERTY:
		g_value_set_int (value, files_renamer_modifier_get_old_format (self));
		break;
		case FILES_RENAMER_MODIFIER_OLD_IS_REVERSED_PROPERTY:
		g_value_set_boolean (value, files_renamer_modifier_get_old_is_reversed (self));
		break;
		case FILES_RENAMER_MODIFIER_TEXT_PROPERTY:
		g_value_set_string (value, files_renamer_modifier_get_text (self));
		break;
		case FILES_RENAMER_MODIFIER_OLD_TEXT_PROPERTY:
		g_value_set_string (value, files_renamer_modifier_get_old_text (self));
		break;
		case FILES_RENAMER_MODIFIER_SEPARATOR_PROPERTY:
		g_value_set_string (value, files_renamer_modifier_get_separator (self));
		break;
		case FILES_RENAMER_MODIFIER_OLD_SEPARATOR_PROPERTY:
		g_value_set_string (value, files_renamer_modifier_get_old_separator (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_renamer_modifier_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	FilesRenamerModifier * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_RENAMER_MODIFIER, FilesRenamerModifier);
	switch (property_id) {
		case FILES_RENAMER_MODIFIER_MODE_PROPERTY:
		files_renamer_modifier_set_mode (self, g_value_get_enum (value));
		break;
		case FILES_RENAMER_MODIFIER_POS_PROPERTY:
		files_renamer_modifier_set_pos (self, g_value_get_enum (value));
		break;
		case FILES_RENAMER_MODIFIER_START_PROPERTY:
		files_renamer_modifier_set_start (self, g_value_get_int (value));
		break;
		case FILES_RENAMER_MODIFIER_OLD_START_PROPERTY:
		files_renamer_modifier_set_old_start (self, g_value_get_int (value));
		break;
		case FILES_RENAMER_MODIFIER_DIGITS_PROPERTY:
		files_renamer_modifier_set_digits (self, g_value_get_int (value));
		break;
		case FILES_RENAMER_MODIFIER_OLD_DIGITS_PROPERTY:
		files_renamer_modifier_set_old_digits (self, g_value_get_int (value));
		break;
		case FILES_RENAMER_MODIFIER_SOURCE_PROPERTY:
		files_renamer_modifier_set_source (self, g_value_get_int (value));
		break;
		case FILES_RENAMER_MODIFIER_OLD_SOURCE_PROPERTY:
		files_renamer_modifier_set_old_source (self, g_value_get_int (value));
		break;
		case FILES_RENAMER_MODIFIER_FORMAT_PROPERTY:
		files_renamer_modifier_set_format (self, g_value_get_int (value));
		break;
		case FILES_RENAMER_MODIFIER_IS_REVERSED_PROPERTY:
		files_renamer_modifier_set_is_reversed (self, g_value_get_boolean (value));
		break;
		case FILES_RENAMER_MODIFIER_OLD_FORMAT_PROPERTY:
		files_renamer_modifier_set_old_format (self, g_value_get_int (value));
		break;
		case FILES_RENAMER_MODIFIER_OLD_IS_REVERSED_PROPERTY:
		files_renamer_modifier_set_old_is_reversed (self, g_value_get_boolean (value));
		break;
		case FILES_RENAMER_MODIFIER_TEXT_PROPERTY:
		files_renamer_modifier_set_text (self, g_value_get_string (value));
		break;
		case FILES_RENAMER_MODIFIER_OLD_TEXT_PROPERTY:
		files_renamer_modifier_set_old_text (self, g_value_get_string (value));
		break;
		case FILES_RENAMER_MODIFIER_SEPARATOR_PROPERTY:
		files_renamer_modifier_set_separator (self, g_value_get_string (value));
		break;
		case FILES_RENAMER_MODIFIER_OLD_SEPARATOR_PROPERTY:
		files_renamer_modifier_set_old_separator (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

