/* PlaybackManager.c generated by valac 0.56.17, the Vala compiler
 * generated from PlaybackManager.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2021-2022 elementary, Inc. (https://elementary.io)
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <gst/gst.h>
#include <gst/pbutils/pbutils.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gst/tag/tag.h>

#define MUSIC_APPLICATION_ACTION_PLAY_PAUSE "action-play-pause"
#define MUSIC_APPLICATION_ACTION_NEXT "action-next"
#define MUSIC_APPLICATION_ACTION_PREVIOUS "action-previous"
#define MUSIC_APPLICATION_ACTION_SHUFFLE "action-shuffle"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MUSIC_TYPE_PLAYBACK_MANAGER (music_playback_manager_get_type ())
#define MUSIC_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManager))
#define MUSIC_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManagerClass))
#define MUSIC_IS_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_PLAYBACK_MANAGER))
#define MUSIC_IS_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_PLAYBACK_MANAGER))
#define MUSIC_PLAYBACK_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManagerClass))

typedef struct _MusicPlaybackManager MusicPlaybackManager;
typedef struct _MusicPlaybackManagerClass MusicPlaybackManagerClass;
typedef struct _MusicPlaybackManagerPrivate MusicPlaybackManagerPrivate;

#define MUSIC_TYPE_AUDIO_OBJECT (music_audio_object_get_type ())
#define MUSIC_AUDIO_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject))
#define MUSIC_AUDIO_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObjectClass))
#define MUSIC_IS_AUDIO_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_AUDIO_OBJECT))
#define MUSIC_IS_AUDIO_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_AUDIO_OBJECT))
#define MUSIC_AUDIO_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObjectClass))

typedef struct _MusicAudioObject MusicAudioObject;
typedef struct _MusicAudioObjectClass MusicAudioObjectClass;
typedef enum  {
	MUSIC_PLAYBACK_MANAGER_DIRECTION_NONE,
	MUSIC_PLAYBACK_MANAGER_DIRECTION_NEXT,
	MUSIC_PLAYBACK_MANAGER_DIRECTION_PREVIOUS
} MusicPlaybackManagerDirection;

#define MUSIC_PLAYBACK_MANAGER_TYPE_DIRECTION (music_playback_manager_direction_get_type ())
enum  {
	MUSIC_PLAYBACK_MANAGER_0_PROPERTY,
	MUSIC_PLAYBACK_MANAGER_CURRENT_AUDIO_PROPERTY,
	MUSIC_PLAYBACK_MANAGER_QUEUE_LISTSTORE_PROPERTY,
	MUSIC_PLAYBACK_MANAGER_PLAYBACK_POSITION_PROPERTY,
	MUSIC_PLAYBACK_MANAGER_NUM_PROPERTIES
};
static GParamSpec* music_playback_manager_properties[MUSIC_PLAYBACK_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_buffer_unref0(var) ((var == NULL) ? NULL : (var = (gst_buffer_unref (var), NULL)))
#define _gst_sample_unref0(var) ((var == NULL) ? NULL : (var = (gst_sample_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	MUSIC_PLAYBACK_MANAGER_INVALIDS_FOUND_SIGNAL,
	MUSIC_PLAYBACK_MANAGER_NUM_SIGNALS
};
static guint music_playback_manager_signals[MUSIC_PLAYBACK_MANAGER_NUM_SIGNALS] = {0};

struct _MusicPlaybackManager {
	GObject parent_instance;
	MusicPlaybackManagerPrivate * priv;
};

struct _MusicPlaybackManagerClass {
	GObjectClass parent_class;
};

struct _MusicPlaybackManagerPrivate {
	MusicAudioObject* _current_audio;
	GListStore* _queue_liststore;
	gint64 _playback_position;
	GstElement* playbin;
	GstDiscoverer* discoverer;
	guint progress_timer;
	GSettings* settings;
	gboolean next_by_eos;
	MusicPlaybackManagerDirection direction;
};

static gint MusicPlaybackManager_private_offset;
static gpointer music_playback_manager_parent_class = NULL;
static GOnce music_playback_manager_instance;
static GOnce music_playback_manager_instance = G_ONCE_INIT;

VALA_EXTERN GType music_playback_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicPlaybackManager, g_object_unref)
VALA_EXTERN GType music_audio_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicAudioObject, g_object_unref)
static GType music_playback_manager_direction_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN MusicPlaybackManager* music_playback_manager_get_default (void);
static MusicPlaybackManager* __lambda4_ (void);
static MusicPlaybackManager* music_playback_manager_new (void);
static MusicPlaybackManager* music_playback_manager_construct (GType object_type);
static gpointer ___lambda4__gthread_func (gpointer self);
VALA_EXTERN void music_playback_manager_seek_to_progress (MusicPlaybackManager* self,
                                              gdouble percent);
VALA_EXTERN MusicAudioObject* music_playback_manager_get_current_audio (MusicPlaybackManager* self);
VALA_EXTERN gint64 music_audio_object_get_duration (MusicAudioObject* self);
VALA_EXTERN void music_playback_manager_queue_files (MusicPlaybackManager* self,
                                         GFile** files,
                                         gint files_length1);
VALA_EXTERN MusicAudioObject* music_audio_object_new (const gchar* uri);
VALA_EXTERN MusicAudioObject* music_audio_object_construct (GType object_type,
                                                const gchar* uri);
VALA_EXTERN void music_audio_object_set_title (MusicAudioObject* self,
                                   const gchar* value);
VALA_EXTERN const gchar* music_audio_object_get_uri (MusicAudioObject* self);
VALA_EXTERN GListStore* music_playback_manager_get_queue_liststore (MusicPlaybackManager* self);
VALA_EXTERN void music_playback_manager_set_current_audio (MusicPlaybackManager* self,
                                               MusicAudioObject* value);
static void music_playback_manager_update_metadata (MusicPlaybackManager* self,
                                             GstDiscovererInfo* info,
                                             GError* err);
static gboolean __lambda5_ (const gchar* a,
                     const gchar* b);
static gboolean ___lambda5__gequal_func (gconstpointer a,
                                  gconstpointer b);
VALA_EXTERN void music_audio_object_set_duration (MusicAudioObject* self,
                                      gint64 value);
VALA_EXTERN void music_audio_object_set_artist (MusicAudioObject* self,
                                    const gchar* value);
static GstSample* music_playback_manager_get_cover_sample (MusicPlaybackManager* self,
                                                    GstTagList* tag_list);
static GdkPixbuf* music_playback_manager_get_pixbuf_from_buffer (MusicPlaybackManager* self,
                                                          GstBuffer* buffer);
VALA_EXTERN void music_audio_object_set_texture (MusicAudioObject* self,
                                     GdkTexture* value);
static gboolean music_playback_manager_bus_callback (MusicPlaybackManager* self,
                                              GstBus* bus,
                                              GstMessage* message);
VALA_EXTERN void music_playback_manager_next (MusicPlaybackManager* self,
                                  gboolean eos);
VALA_EXTERN void music_playback_manager_previous (MusicPlaybackManager* self);
static GVariant* _variant_new2 (gboolean value);
static gboolean ____lambda6_ (MusicPlaybackManager* self);
static void music_playback_manager_set_playback_position (MusicPlaybackManager* self,
                                                   gint64 value);
static gboolean _____lambda6__gsource_func (gpointer self);
static GVariant* _variant_new3 (gboolean value);
VALA_EXTERN void music_playback_manager_play_pause (MusicPlaybackManager* self);
VALA_EXTERN void music_playback_manager_shuffle (MusicPlaybackManager* self);
static void music_playback_manager_update_next_previous_sensitivity (MusicPlaybackManager* self);
static void music_playback_manager_set_queue_liststore (MusicPlaybackManager* self,
                                                 GListStore* value);
VALA_EXTERN gint64 music_playback_manager_get_playback_position (MusicPlaybackManager* self);
static GObject * music_playback_manager_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static gboolean _music_playback_manager_bus_callback_gst_bus_func (GstBus* bus,
                                                            GstMessage* message,
                                                            gpointer self);
static void _music_playback_manager_update_metadata_gst_discoverer_discovered (GstDiscoverer* _sender,
                                                                        GstDiscovererInfo* info,
                                                                        GError* err,
                                                                        gpointer self);
static void _gst_discoverer_stop_gst_discoverer_finished (GstDiscoverer* _sender,
                                                   gpointer self);
static void _music_playback_manager___lambda7_ (MusicPlaybackManager* self);
static void __music_playback_manager___lambda7__g_list_model_items_changed (GListModel* _sender,
                                                                     guint position,
                                                                     guint removed,
                                                                     guint added,
                                                                     gpointer self);
static void _music_playback_manager___lambda8_ (MusicPlaybackManager* self);
static void __music_playback_manager___lambda8__g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void music_playback_manager_finalize (GObject * obj);
static GType music_playback_manager_get_type_once (void);
static void _vala_music_playback_manager_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_music_playback_manager_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
music_playback_manager_get_instance_private (MusicPlaybackManager* self)
{
	return G_STRUCT_MEMBER_P (self, MusicPlaybackManager_private_offset);
}

static GType
music_playback_manager_direction_get_type_once (void)
{
	static const GEnumValue values[] = {{MUSIC_PLAYBACK_MANAGER_DIRECTION_NONE, "MUSIC_PLAYBACK_MANAGER_DIRECTION_NONE", "none"}, {MUSIC_PLAYBACK_MANAGER_DIRECTION_NEXT, "MUSIC_PLAYBACK_MANAGER_DIRECTION_NEXT", "next"}, {MUSIC_PLAYBACK_MANAGER_DIRECTION_PREVIOUS, "MUSIC_PLAYBACK_MANAGER_DIRECTION_PREVIOUS", "previous"}, {0, NULL, NULL}};
	GType music_playback_manager_direction_type_id;
	music_playback_manager_direction_type_id = g_enum_register_static ("MusicPlaybackManagerDirection", values);
	return music_playback_manager_direction_type_id;
}

static GType
music_playback_manager_direction_get_type (void)
{
	static volatile gsize music_playback_manager_direction_type_id__once = 0;
	if (g_once_init_enter (&music_playback_manager_direction_type_id__once)) {
		GType music_playback_manager_direction_type_id;
		music_playback_manager_direction_type_id = music_playback_manager_direction_get_type_once ();
		g_once_init_leave (&music_playback_manager_direction_type_id__once, music_playback_manager_direction_type_id);
	}
	return music_playback_manager_direction_type_id__once;
}

static MusicPlaybackManager*
__lambda4_ (void)
{
	MusicPlaybackManager* _tmp0_;
	MusicPlaybackManager* result;
	_tmp0_ = music_playback_manager_new ();
	result = _tmp0_;
	return result;
}

static gpointer
___lambda4__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda4_ ();
	return result;
}

MusicPlaybackManager*
music_playback_manager_get_default (void)
{
	gconstpointer _tmp0_;
	MusicPlaybackManager* result;
	_tmp0_ = g_once (&music_playback_manager_instance, ___lambda4__gthread_func, NULL);
	result = (MusicPlaybackManager*) _tmp0_;
	return result;
}

static MusicPlaybackManager*
music_playback_manager_construct (GType object_type)
{
	MusicPlaybackManager * self = NULL;
	self = (MusicPlaybackManager*) g_object_new (object_type, NULL);
	return self;
}

static MusicPlaybackManager*
music_playback_manager_new (void)
{
	return music_playback_manager_construct (MUSIC_TYPE_PLAYBACK_MANAGER);
}

void
music_playback_manager_seek_to_progress (MusicPlaybackManager* self,
                                         gdouble percent)
{
	GstElement* _tmp0_;
	MusicAudioObject* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->playbin;
	_tmp1_ = self->priv->_current_audio;
	_tmp2_ = music_audio_object_get_duration (_tmp1_);
	_tmp3_ = _tmp2_;
	gst_element_seek_simple (_tmp0_, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH, (gint64) (percent * _tmp3_));
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
music_playback_manager_queue_files (MusicPlaybackManager* self,
                                    GFile** files,
                                    gint files_length1)
{
	GstDiscoverer* _tmp0_;
	gint invalids = 0;
	MusicAudioObject* _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->discoverer;
	gst_discoverer_start (_tmp0_);
	invalids = 0;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = files;
		file_collection_length1 = files_length1;
		for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
			GFile* file = NULL;
			file = file_collection[file_it];
			{
				gboolean _tmp1_ = FALSE;
				GFile* _tmp2_;
				_tmp2_ = file;
				if (g_file_query_exists (_tmp2_, NULL)) {
					GFile* _tmp3_;
					gchar* _tmp4_;
					gchar* _tmp5_;
					gchar* _tmp6_;
					gchar* _tmp7_;
					_tmp3_ = file;
					_tmp4_ = g_file_get_uri (_tmp3_);
					_tmp5_ = _tmp4_;
					_tmp6_ = g_content_type_guess (_tmp5_, NULL, (gsize) 0, NULL);
					_tmp7_ = _tmp6_;
					_tmp1_ = string_contains (_tmp7_, "audio");
					_g_free0 (_tmp7_);
					_g_free0 (_tmp5_);
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					MusicAudioObject* audio_object = NULL;
					GFile* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					MusicAudioObject* _tmp11_;
					MusicAudioObject* _tmp12_;
					gchar* basename = NULL;
					GFile* _tmp13_;
					gchar* _tmp14_;
					const gchar* _tmp15_;
					GstDiscoverer* _tmp22_;
					MusicAudioObject* _tmp23_;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					GListStore* _tmp26_;
					MusicAudioObject* _tmp27_;
					_tmp8_ = file;
					_tmp9_ = g_file_get_uri (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = music_audio_object_new (_tmp10_);
					_tmp12_ = _tmp11_;
					_g_free0 (_tmp10_);
					audio_object = _tmp12_;
					_tmp13_ = file;
					_tmp14_ = g_file_get_basename (_tmp13_);
					basename = _tmp14_;
					_tmp15_ = basename;
					if (_tmp15_ != NULL) {
						MusicAudioObject* _tmp16_;
						const gchar* _tmp17_;
						_tmp16_ = audio_object;
						_tmp17_ = basename;
						music_audio_object_set_title (_tmp16_, _tmp17_);
					} else {
						MusicAudioObject* _tmp18_;
						MusicAudioObject* _tmp19_;
						const gchar* _tmp20_;
						const gchar* _tmp21_;
						_tmp18_ = audio_object;
						_tmp19_ = audio_object;
						_tmp20_ = music_audio_object_get_uri (_tmp19_);
						_tmp21_ = _tmp20_;
						music_audio_object_set_title (_tmp18_, _tmp21_);
					}
					_tmp22_ = self->priv->discoverer;
					_tmp23_ = audio_object;
					_tmp24_ = music_audio_object_get_uri (_tmp23_);
					_tmp25_ = _tmp24_;
					gst_discoverer_discover_uri_async (_tmp22_, _tmp25_);
					_tmp26_ = self->priv->_queue_liststore;
					_tmp27_ = audio_object;
					g_list_store_append (_tmp26_, (GObject*) _tmp27_);
					_g_free0 (basename);
					_g_object_unref0 (audio_object);
				} else {
					gint _tmp28_;
					_tmp28_ = invalids;
					invalids = _tmp28_ + 1;
					continue;
				}
			}
		}
	}
	if (invalids > 0) {
		g_signal_emit (self, music_playback_manager_signals[MUSIC_PLAYBACK_MANAGER_INVALIDS_FOUND_SIGNAL], 0, invalids);
	}
	_tmp29_ = self->priv->_current_audio;
	if (_tmp29_ == NULL) {
		MusicAudioObject* audio_object = NULL;
		GListStore* _tmp30_;
		GObject* _tmp31_;
		MusicAudioObject* _tmp32_;
		_tmp30_ = self->priv->_queue_liststore;
		_tmp31_ = g_list_model_get_object ((GListModel*) _tmp30_, (guint) 0);
		audio_object = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
		_tmp32_ = audio_object;
		if (_tmp32_ != NULL) {
			MusicAudioObject* _tmp33_;
			_tmp33_ = audio_object;
			music_playback_manager_set_current_audio (self, _tmp33_);
		}
		_g_object_unref0 (audio_object);
	} else {
		GtkApplication* application = NULL;
		GApplication* _tmp34_;
		GtkApplication* _tmp35_;
		gint added_tracks = 0;
		gboolean _tmp36_ = FALSE;
		GtkApplication* _tmp37_;
		GtkWindow* _tmp38_;
		gboolean _tmp39_;
		gboolean _tmp40_;
		_tmp34_ = g_application_get_default ();
		_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_application_get_type (), GtkApplication));
		application = _tmp35_;
		added_tracks = files_length1 - invalids;
		_tmp37_ = application;
		_tmp38_ = gtk_application_get_active_window (_tmp37_);
		g_object_get (_tmp38_, "is-active", &_tmp39_, NULL);
		_tmp40_ = _tmp39_;
		if (!_tmp40_) {
			_tmp36_ = added_tracks > 0;
		} else {
			_tmp36_ = FALSE;
		}
		if (_tmp36_) {
			GNotification* notification = NULL;
			gchar* _tmp41_;
			gchar* _tmp42_;
			GNotification* _tmp43_;
			GNotification* _tmp44_;
			GNotification* _tmp45_;
			GThemedIcon* _tmp46_;
			GThemedIcon* _tmp47_;
			GtkApplication* _tmp48_;
			GNotification* _tmp49_;
			_tmp41_ = g_strdup_printf (ngettext ("%d track was added to the queue", "%d tracks were added to the queue", (gulong) added_tracks), added_tracks);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_notification_new (_tmp42_);
			_tmp44_ = _tmp43_;
			_g_free0 (_tmp42_);
			notification = _tmp44_;
			_tmp45_ = notification;
			_tmp46_ = (GThemedIcon*) g_themed_icon_new ("playlist-queue");
			_tmp47_ = _tmp46_;
			g_notification_set_icon (_tmp45_, (GIcon*) _tmp47_);
			_g_object_unref0 (_tmp47_);
			_tmp48_ = application;
			_tmp49_ = notification;
			g_application_send_notification ((GApplication*) _tmp48_, "queue-files", _tmp49_);
			_g_object_unref0 (notification);
		}
		_g_object_unref0 (application);
	}
}

static gboolean
__lambda5_ (const gchar* a,
            const gchar* b)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = music_audio_object_get_uri (G_TYPE_CHECK_INSTANCE_CAST (a, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject));
	_tmp1_ = _tmp0_;
	_tmp2_ = music_audio_object_get_uri (G_TYPE_CHECK_INSTANCE_CAST (b, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject));
	_tmp3_ = _tmp2_;
	result = g_strcmp0 (_tmp1_, _tmp3_) == 0;
	return result;
}

static gboolean
___lambda5__gequal_func (gconstpointer a,
                         gconstpointer b)
{
	gboolean result;
	result = __lambda5_ ((const gchar*) a, (const gchar*) b);
	return result;
}

static gpointer
_gst_buffer_ref0 (gpointer self)
{
	return self ? gst_buffer_ref (self) : NULL;
}

static void
music_playback_manager_update_metadata (MusicPlaybackManager* self,
                                        GstDiscovererInfo* info,
                                        GError* err)
{
	gchar* uri = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GEqualFunc equal_func = NULL;
	MusicAudioObject* temp_audio_object = NULL;
	const gchar* _tmp8_;
	MusicAudioObject* _tmp9_;
	guint position = 0U;
	GListStore* _tmp10_;
	MusicAudioObject* _tmp11_;
	GEqualFunc _tmp12_;
	guint _tmp13_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = gst_discoverer_info_get_uri (info);
	_tmp1_ = g_strdup (_tmp0_);
	uri = _tmp1_;
	switch (gst_discoverer_info_get_result (info)) {
		case GST_DISCOVERER_URI_INVALID:
		{
			const gchar* _tmp2_;
			_tmp2_ = uri;
			g_critical ("PlaybackManager.vala:146: Couldn't read metadata for '%s': invalid URI" \
".", _tmp2_);
			_g_free0 (uri);
			return;
		}
		case GST_DISCOVERER_ERROR:
		{
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp3_ = uri;
			_tmp4_ = err->message;
			g_critical ("PlaybackManager.vala:149: Couldn't read metadata for '%s': %s", _tmp3_, _tmp4_);
			_g_free0 (uri);
			return;
		}
		case GST_DISCOVERER_TIMEOUT:
		{
			const gchar* _tmp5_;
			_tmp5_ = uri;
			g_critical ("PlaybackManager.vala:152: Couldn't read metadata for '%s': Discovery t" \
"imed out.", _tmp5_);
			_g_free0 (uri);
			return;
		}
		case GST_DISCOVERER_BUSY:
		{
			const gchar* _tmp6_;
			_tmp6_ = uri;
			g_critical ("PlaybackManager.vala:155: Couldn't read metadata for '%s': Already dis" \
"covering a file.", _tmp6_);
			_g_free0 (uri);
			return;
		}
		case GST_DISCOVERER_MISSING_PLUGINS:
		{
			const gchar* _tmp7_;
			_tmp7_ = uri;
			g_critical ("PlaybackManager.vala:158: Couldn't read metadata for '%s': Missing plu" \
"gins.", _tmp7_);
			_g_free0 (uri);
			return;
		}
		default:
		{
			break;
		}
	}
	equal_func = ___lambda5__gequal_func;
	_tmp8_ = uri;
	_tmp9_ = music_audio_object_new (_tmp8_);
	temp_audio_object = _tmp9_;
	position = (guint) -1;
	_tmp10_ = self->priv->_queue_liststore;
	_tmp11_ = temp_audio_object;
	_tmp12_ = equal_func;
	g_list_store_find_with_equal_func (_tmp10_, (GObject*) _tmp11_, _tmp12_, &_tmp13_);
	position = _tmp13_;
	if (position != ((guint) -1)) {
		MusicAudioObject* audio_object = NULL;
		GListStore* _tmp14_;
		GObject* _tmp15_;
		MusicAudioObject* _tmp16_;
		GstTagList* tag_list = NULL;
		GstTagList* _tmp17_;
		gchar* _title = NULL;
		GstTagList* _tmp18_;
		gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		gchar* _artist = NULL;
		GstTagList* _tmp23_;
		gchar* _tmp24_ = NULL;
		const gchar* _tmp25_;
		GstSample* sample = NULL;
		GstTagList* _tmp30_;
		GstSample* _tmp31_;
		GstSample* _tmp32_;
		_tmp14_ = self->priv->_queue_liststore;
		_tmp15_ = g_list_model_get_item ((GListModel*) _tmp14_, position);
		audio_object = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
		_tmp16_ = audio_object;
		music_audio_object_set_duration (_tmp16_, (gint64) gst_discoverer_info_get_duration (info));
		_tmp17_ = gst_discoverer_info_get_tags (info);
		tag_list = _tmp17_;
		_tmp18_ = tag_list;
		gst_tag_list_get_string (_tmp18_, GST_TAG_TITLE, &_tmp19_);
		_g_free0 (_title);
		_title = _tmp19_;
		_tmp20_ = _title;
		if (_tmp20_ != NULL) {
			MusicAudioObject* _tmp21_;
			const gchar* _tmp22_;
			_tmp21_ = audio_object;
			_tmp22_ = _title;
			music_audio_object_set_title (_tmp21_, _tmp22_);
		}
		_tmp23_ = tag_list;
		gst_tag_list_get_string (_tmp23_, GST_TAG_ARTIST, &_tmp24_);
		_g_free0 (_artist);
		_artist = _tmp24_;
		_tmp25_ = _artist;
		if (_tmp25_ != NULL) {
			MusicAudioObject* _tmp26_;
			const gchar* _tmp27_;
			_tmp26_ = audio_object;
			_tmp27_ = _artist;
			music_audio_object_set_artist (_tmp26_, _tmp27_);
		} else {
			const gchar* _tmp28_;
			_tmp28_ = _title;
			if (_tmp28_ != NULL) {
				MusicAudioObject* _tmp29_;
				_tmp29_ = audio_object;
				music_audio_object_set_artist (_tmp29_, _ ("Unknown"));
			}
		}
		_tmp30_ = tag_list;
		_tmp31_ = music_playback_manager_get_cover_sample (self, _tmp30_);
		sample = _tmp31_;
		_tmp32_ = sample;
		if (_tmp32_ != NULL) {
			GstBuffer* buffer = NULL;
			GstSample* _tmp33_;
			GstBuffer* _tmp34_;
			GstBuffer* _tmp35_;
			GstBuffer* _tmp36_;
			_tmp33_ = sample;
			_tmp34_ = gst_sample_get_buffer (_tmp33_);
			_tmp35_ = _gst_buffer_ref0 (_tmp34_);
			buffer = _tmp35_;
			_tmp36_ = buffer;
			if (_tmp36_ != NULL) {
				MusicAudioObject* _tmp37_;
				GstBuffer* _tmp38_;
				GdkPixbuf* _tmp39_;
				GdkPixbuf* _tmp40_;
				GdkTexture* _tmp41_;
				GdkTexture* _tmp42_;
				_tmp37_ = audio_object;
				_tmp38_ = buffer;
				_tmp39_ = music_playback_manager_get_pixbuf_from_buffer (self, _tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = gdk_texture_new_for_pixbuf (_tmp40_);
				_tmp42_ = _tmp41_;
				music_audio_object_set_texture (_tmp37_, _tmp42_);
				_g_object_unref0 (_tmp42_);
				_g_object_unref0 (_tmp40_);
			}
			_gst_buffer_unref0 (buffer);
		}
		_gst_sample_unref0 (sample);
		_g_free0 (_artist);
		_g_free0 (_title);
		_g_object_unref0 (audio_object);
	} else {
		const gchar* _tmp43_;
		_tmp43_ = uri;
		g_critical ("PlaybackManager.vala:202: Couldn't find '%s' in queue", _tmp43_);
	}
	_g_object_unref0 (temp_audio_object);
	_g_free0 (uri);
}

static GVariant*
_variant_new2 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static gboolean
____lambda6_ (MusicPlaybackManager* self)
{
	gint64 position = 0LL;
	GstElement* _tmp0_;
	gint64 _tmp1_ = 0LL;
	MusicAudioObject* _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	gboolean result;
	position = (gint64) 0;
	_tmp0_ = self->priv->playbin;
	gst_element_query_position (_tmp0_, GST_FORMAT_TIME, &_tmp1_);
	position = _tmp1_;
	_tmp2_ = self->priv->_current_audio;
	_tmp3_ = music_audio_object_get_duration (_tmp2_);
	_tmp4_ = _tmp3_;
	music_playback_manager_set_playback_position (self, CLAMP (position, (gint64) 0, _tmp4_));
	result = G_SOURCE_CONTINUE;
	return result;
}

static gboolean
_____lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda6_ ((MusicPlaybackManager*) self);
	return result;
}

static GVariant*
_variant_new3 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static gboolean
music_playback_manager_bus_callback (MusicPlaybackManager* self,
                                     GstBus* bus,
                                     GstMessage* message)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	switch (message->type) {
		case GST_MESSAGE_EOS:
		{
			music_playback_manager_next (self, TRUE);
			break;
		}
		case GST_MESSAGE_ERROR:
		{
			switch (self->priv->direction) {
				case MUSIC_PLAYBACK_MANAGER_DIRECTION_NEXT:
				{
					music_playback_manager_next (self, self->priv->next_by_eos);
					break;
				}
				case MUSIC_PLAYBACK_MANAGER_DIRECTION_PREVIOUS:
				{
					music_playback_manager_previous (self);
					break;
				}
				default:
				{
					break;
				}
			}
			break;
		}
		case GST_MESSAGE_STATE_CHANGED:
		{
			GSimpleAction* play_pause_action = NULL;
			GApplication* _tmp0_;
			GAction* _tmp1_;
			GSimpleAction* _tmp2_;
			GstState old_state = 0;
			GstState new_state = 0;
			GstState pending_state = 0;
			GstState _tmp3_ = 0;
			GstState _tmp4_ = 0;
			GstState _tmp5_ = 0;
			if (self->priv->progress_timer != ((guint) 0)) {
				g_source_remove (self->priv->progress_timer);
				self->priv->progress_timer = (guint) 0;
			}
			_tmp0_ = g_application_get_default ();
			_tmp1_ = g_action_map_lookup_action ((GActionMap*) _tmp0_, MUSIC_APPLICATION_ACTION_PLAY_PAUSE);
			_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction));
			play_pause_action = _tmp2_;
			gst_message_parse_state_changed (message, &_tmp3_, &_tmp4_, &_tmp5_);
			old_state = _tmp3_;
			new_state = _tmp4_;
			pending_state = _tmp5_;
			if (new_state == GST_STATE_PLAYING) {
				GSimpleAction* _tmp6_;
				GVariant* _tmp7_;
				_tmp6_ = play_pause_action;
				_tmp7_ = _variant_new2 (TRUE);
				g_simple_action_set_state (_tmp6_, _tmp7_);
				_g_variant_unref0 (_tmp7_);
				self->priv->progress_timer = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _____lambda6__gsource_func, g_object_ref (self), g_object_unref);
			} else {
				GSimpleAction* _tmp8_;
				GVariant* _tmp9_;
				_tmp8_ = play_pause_action;
				_tmp9_ = _variant_new3 (FALSE);
				g_simple_action_set_state (_tmp8_, _tmp9_);
				_g_variant_unref0 (_tmp9_);
			}
			_g_object_unref0 (play_pause_action);
			break;
		}
		default:
		{
			break;
		}
	}
	result = TRUE;
	return result;
}

void
music_playback_manager_play_pause (MusicPlaybackManager* self)
{
	GSimpleAction* play_pause_action = NULL;
	GApplication* _tmp0_;
	GAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) _tmp0_, MUSIC_APPLICATION_ACTION_PLAY_PAUSE);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction));
	play_pause_action = _tmp2_;
	_tmp3_ = play_pause_action;
	_tmp4_ = g_action_get_state ((GAction*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_get_boolean (_tmp5_);
	_g_variant_unref0 (_tmp5_);
	if (_tmp6_) {
		GstElement* _tmp7_;
		_tmp7_ = self->priv->playbin;
		gst_element_set_state (_tmp7_, GST_STATE_PAUSED);
	} else {
		GstElement* _tmp8_;
		_tmp8_ = self->priv->playbin;
		gst_element_set_state (_tmp8_, GST_STATE_PLAYING);
	}
	_g_object_unref0 (play_pause_action);
}

void
music_playback_manager_next (MusicPlaybackManager* self,
                             gboolean eos)
{
	guint position = 0U;
	GListStore* _tmp0_;
	MusicAudioObject* _tmp1_;
	guint _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	self->priv->direction = MUSIC_PLAYBACK_MANAGER_DIRECTION_NEXT;
	self->priv->next_by_eos = eos;
	position = (guint) -1;
	_tmp0_ = self->priv->_queue_liststore;
	_tmp1_ = self->priv->_current_audio;
	g_list_store_find (_tmp0_, (GObject*) _tmp1_, &_tmp2_);
	position = _tmp2_;
	if (position != ((guint) -1)) {
		GSettings* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GQuark _tmp14_ = 0U;
		static GQuark _tmp13_label0 = 0;
		static GQuark _tmp13_label1 = 0;
		static GQuark _tmp13_label2 = 0;
		if (!self->priv->next_by_eos) {
			GListStore* _tmp3_;
			_tmp3_ = self->priv->_queue_liststore;
			if (position == (g_list_model_get_n_items ((GListModel*) _tmp3_) - 1)) {
				GListStore* _tmp4_;
				GObject* _tmp5_;
				MusicAudioObject* _tmp6_;
				_tmp4_ = self->priv->_queue_liststore;
				_tmp5_ = g_list_model_get_item ((GListModel*) _tmp4_, (guint) 0);
				_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
				music_playback_manager_set_current_audio (self, _tmp6_);
				_g_object_unref0 (_tmp6_);
				if (position == ((guint) 0)) {
					music_playback_manager_seek_to_progress (self, (gdouble) 0);
				}
			} else {
				GListStore* _tmp7_;
				GObject* _tmp8_;
				MusicAudioObject* _tmp9_;
				_tmp7_ = self->priv->_queue_liststore;
				_tmp8_ = g_list_model_get_item ((GListModel*) _tmp7_, position + 1);
				_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
				music_playback_manager_set_current_audio (self, _tmp9_);
				_g_object_unref0 (_tmp9_);
			}
			return;
		}
		_tmp10_ = self->priv->settings;
		_tmp11_ = g_settings_get_string (_tmp10_, "repeat-mode");
		_tmp12_ = _tmp11_;
		_tmp14_ = (NULL == _tmp12_) ? 0 : g_quark_from_string (_tmp12_);
		g_free (_tmp12_);
		if (_tmp14_ == ((0 != _tmp13_label0) ? _tmp13_label0 : (_tmp13_label0 = g_quark_from_static_string ("disabled")))) {
			switch (0) {
				default:
				{
					GListStore* _tmp15_;
					GListStore* _tmp16_;
					GObject* _tmp17_;
					MusicAudioObject* _tmp18_;
					_tmp15_ = self->priv->_queue_liststore;
					if (position == (g_list_model_get_n_items ((GListModel*) _tmp15_) - 1)) {
						music_playback_manager_set_current_audio (self, NULL);
						return;
					}
					_tmp16_ = self->priv->_queue_liststore;
					_tmp17_ = g_list_model_get_item ((GListModel*) _tmp16_, position + 1);
					_tmp18_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
					music_playback_manager_set_current_audio (self, _tmp18_);
					_g_object_unref0 (_tmp18_);
					break;
				}
			}
		} else if (_tmp14_ == ((0 != _tmp13_label1) ? _tmp13_label1 : (_tmp13_label1 = g_quark_from_static_string ("all")))) {
			switch (0) {
				default:
				{
					GListStore* _tmp19_;
					_tmp19_ = self->priv->_queue_liststore;
					if (position == (g_list_model_get_n_items ((GListModel*) _tmp19_) - 1)) {
						GListStore* _tmp20_;
						GObject* _tmp21_;
						MusicAudioObject* _tmp22_;
						_tmp20_ = self->priv->_queue_liststore;
						_tmp21_ = g_list_model_get_item ((GListModel*) _tmp20_, (guint) 0);
						_tmp22_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
						music_playback_manager_set_current_audio (self, _tmp22_);
						_g_object_unref0 (_tmp22_);
						if (position == ((guint) 0)) {
							music_playback_manager_seek_to_progress (self, (gdouble) 0);
						}
					} else {
						GListStore* _tmp23_;
						GObject* _tmp24_;
						MusicAudioObject* _tmp25_;
						_tmp23_ = self->priv->_queue_liststore;
						_tmp24_ = g_list_model_get_item ((GListModel*) _tmp23_, position + 1);
						_tmp25_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
						music_playback_manager_set_current_audio (self, _tmp25_);
						_g_object_unref0 (_tmp25_);
					}
					break;
				}
			}
		} else if (_tmp14_ == ((0 != _tmp13_label2) ? _tmp13_label2 : (_tmp13_label2 = g_quark_from_static_string ("one")))) {
			switch (0) {
				default:
				{
					music_playback_manager_seek_to_progress (self, (gdouble) 0);
					break;
				}
			}
		}
	}
}

void
music_playback_manager_previous (MusicPlaybackManager* self)
{
	guint position = 0U;
	GListStore* _tmp0_;
	MusicAudioObject* _tmp1_;
	guint _tmp2_ = 0U;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	self->priv->direction = MUSIC_PLAYBACK_MANAGER_DIRECTION_PREVIOUS;
	position = (guint) -1;
	_tmp0_ = self->priv->_queue_liststore;
	_tmp1_ = self->priv->_current_audio;
	g_list_store_find (_tmp0_, (GObject*) _tmp1_, &_tmp2_);
	position = _tmp2_;
	if (position != ((guint) -1)) {
		_tmp3_ = position != ((guint) 0);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GListStore* _tmp4_;
		GObject* _tmp5_;
		MusicAudioObject* _tmp6_;
		_tmp4_ = self->priv->_queue_liststore;
		_tmp5_ = g_list_model_get_item ((GListModel*) _tmp4_, position - 1);
		_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
		music_playback_manager_set_current_audio (self, _tmp6_);
		_g_object_unref0 (_tmp6_);
	}
	if (position == ((guint) 0)) {
		guint n_items = 0U;
		GListStore* _tmp7_;
		_tmp7_ = self->priv->_queue_liststore;
		n_items = g_list_model_get_n_items ((GListModel*) _tmp7_);
		if (n_items == ((guint) 1)) {
			music_playback_manager_seek_to_progress (self, (gdouble) 0);
		} else {
			GListStore* _tmp8_;
			GObject* _tmp9_;
			MusicAudioObject* _tmp10_;
			_tmp8_ = self->priv->_queue_liststore;
			_tmp9_ = g_list_model_get_item ((GListModel*) _tmp8_, n_items - 1);
			_tmp10_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
			music_playback_manager_set_current_audio (self, _tmp10_);
			_g_object_unref0 (_tmp10_);
		}
	}
}

void
music_playback_manager_shuffle (MusicPlaybackManager* self)
{
	GListStore* temp_list = NULL;
	GListStore* _tmp0_;
	GListStore* _tmp1_;
	MusicAudioObject* _tmp2_;
	guint position = 0U;
	GListStore* _tmp3_;
	MusicAudioObject* _tmp4_;
	guint _tmp5_ = 0U;
	GListStore* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_list_store_new (MUSIC_TYPE_AUDIO_OBJECT);
	temp_list = _tmp0_;
	_tmp1_ = temp_list;
	_tmp2_ = self->priv->_current_audio;
	g_list_store_append (_tmp1_, (GObject*) _tmp2_);
	position = (guint) -1;
	_tmp3_ = self->priv->_queue_liststore;
	_tmp4_ = self->priv->_current_audio;
	g_list_store_find (_tmp3_, (GObject*) _tmp4_, &_tmp5_);
	position = _tmp5_;
	_tmp6_ = self->priv->_queue_liststore;
	g_list_store_remove (_tmp6_, position);
	while (TRUE) {
		GListStore* _tmp7_;
		gint32 random_position = 0;
		GListStore* _tmp8_;
		GListStore* _tmp9_;
		GListStore* _tmp10_;
		GObject* _tmp11_;
		GObject* _tmp12_;
		GListStore* _tmp13_;
		_tmp7_ = self->priv->_queue_liststore;
		if (!(g_list_model_get_n_items ((GListModel*) _tmp7_) > ((guint) 0))) {
			break;
		}
		_tmp8_ = self->priv->_queue_liststore;
		random_position = g_random_int_range ((gint32) 0, (gint32) g_list_model_get_n_items ((GListModel*) _tmp8_));
		_tmp9_ = temp_list;
		_tmp10_ = self->priv->_queue_liststore;
		_tmp11_ = g_list_model_get_item ((GListModel*) _tmp10_, (guint) random_position);
		_tmp12_ = _tmp11_;
		g_list_store_append (_tmp9_, _tmp12_);
		_g_object_unref0 (_tmp12_);
		_tmp13_ = self->priv->_queue_liststore;
		g_list_store_remove (_tmp13_, (guint) random_position);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				GListStore* _tmp16_;
				GListStore* _tmp17_;
				GListStore* _tmp18_;
				GObject* _tmp19_;
				GObject* _tmp20_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				_tmp16_ = temp_list;
				if (!(((guint) i) < g_list_model_get_n_items ((GListModel*) _tmp16_))) {
					break;
				}
				_tmp17_ = self->priv->_queue_liststore;
				_tmp18_ = temp_list;
				_tmp19_ = g_list_model_get_item ((GListModel*) _tmp18_, (guint) i);
				_tmp20_ = _tmp19_;
				g_list_store_append (_tmp17_, _tmp20_);
				_g_object_unref0 (_tmp20_);
			}
		}
	}
	_g_object_unref0 (temp_list);
}

static void
music_playback_manager_update_next_previous_sensitivity (MusicPlaybackManager* self)
{
	gboolean next_sensitive = FALSE;
	gboolean previous_sensitive = FALSE;
	MusicAudioObject* _tmp0_;
	GApplication* default_application = NULL;
	GApplication* _tmp1_;
	GApplication* _tmp2_;
	GSimpleAction* next_action = NULL;
	GAction* _tmp3_;
	GSimpleAction* _tmp4_;
	GSimpleAction* previous_action = NULL;
	GAction* _tmp5_;
	GSimpleAction* _tmp6_;
	g_return_if_fail (self != NULL);
	next_sensitive = FALSE;
	previous_sensitive = FALSE;
	_tmp0_ = self->priv->_current_audio;
	previous_sensitive = _tmp0_ != NULL;
	next_sensitive = previous_sensitive;
	_tmp1_ = g_application_get_default ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	default_application = _tmp2_;
	_tmp3_ = g_action_map_lookup_action ((GActionMap*) default_application, MUSIC_APPLICATION_ACTION_NEXT);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_simple_action_get_type (), GSimpleAction));
	next_action = _tmp4_;
	g_simple_action_set_enabled (next_action, next_sensitive);
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) default_application, MUSIC_APPLICATION_ACTION_PREVIOUS);
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_simple_action_get_type (), GSimpleAction));
	previous_action = _tmp6_;
	g_simple_action_set_enabled (previous_action, previous_sensitive);
	_g_object_unref0 (previous_action);
	_g_object_unref0 (next_action);
	_g_object_unref0 (default_application);
}

static gpointer
_gst_caps_ref0 (gpointer self)
{
	return self ? gst_caps_ref (self) : NULL;
}

static gpointer
_gst_sample_ref0 (gpointer self)
{
	return self ? gst_sample_ref (self) : NULL;
}

static GstSample*
music_playback_manager_get_cover_sample (MusicPlaybackManager* self,
                                         GstTagList* tag_list)
{
	GstSample* cover_sample = NULL;
	GstSample* sample = NULL;
	GstSample* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag_list != NULL, NULL);
	cover_sample = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GstSample* _tmp2_ = NULL;
				gboolean _tmp3_;
				GstCaps* caps = NULL;
				GstSample* _tmp4_;
				GstCaps* _tmp5_;
				GstCaps* _tmp6_;
				GstStructure* caps_struct = NULL;
				GstCaps* _tmp7_;
				GstStructure* _tmp8_;
				gint image_type = 0;
				GstStructure* _tmp9_;
				gint _tmp10_ = 0;
				gboolean _tmp11_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = gst_tag_list_get_sample_index (tag_list, GST_TAG_IMAGE, (guint) i, &_tmp2_);
				_gst_sample_unref0 (sample);
				sample = _tmp2_;
				if (!_tmp3_) {
					break;
				}
				_tmp4_ = sample;
				_tmp5_ = gst_sample_get_caps (_tmp4_);
				_tmp6_ = _gst_caps_ref0 (_tmp5_);
				caps = _tmp6_;
				_tmp7_ = caps;
				_tmp8_ = gst_caps_get_structure (_tmp7_, (guint) 0);
				caps_struct = _tmp8_;
				image_type = (gint) GST_TAG_IMAGE_TYPE_UNDEFINED;
				_tmp9_ = caps_struct;
				gst_structure_get_enum (_tmp9_, "image-type", gst_tag_image_type_get_type (), &_tmp10_);
				image_type = _tmp10_;
				if (image_type == ((gint) GST_TAG_IMAGE_TYPE_UNDEFINED)) {
					GstSample* _tmp12_;
					_tmp12_ = cover_sample;
					_tmp11_ = _tmp12_ == NULL;
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					GstSample* _tmp13_;
					GstSample* _tmp14_;
					_tmp13_ = sample;
					_tmp14_ = _gst_sample_ref0 (_tmp13_);
					_gst_sample_unref0 (cover_sample);
					cover_sample = _tmp14_;
				} else {
					if (image_type == ((gint) GST_TAG_IMAGE_TYPE_FRONT_COVER)) {
						result = sample;
						_gst_caps_unref0 (caps);
						_gst_sample_unref0 (cover_sample);
						return result;
					}
				}
				_gst_caps_unref0 (caps);
			}
		}
	}
	result = cover_sample;
	_gst_sample_unref0 (sample);
	return result;
}

static GdkPixbuf*
music_playback_manager_get_pixbuf_from_buffer (MusicPlaybackManager* self,
                                               GstBuffer* buffer)
{
	GstMapInfo map_info = {0};
	GstMapInfo _tmp0_ = {0};
	gboolean _tmp1_;
	GdkPixbuf* pix = NULL;
	GstMapInfo _tmp15_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (buffer != NULL, NULL);
	_tmp1_ = gst_buffer_map (buffer, &_tmp0_, GST_MAP_READ);
	map_info = _tmp0_;
	if (!_tmp1_) {
		g_warning ("PlaybackManager.vala:389: Could not map memory buffer");
		result = NULL;
		return result;
	}
	pix = NULL;
	{
		GdkPixbufLoader* loader = NULL;
		GdkPixbufLoader* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		GdkPixbufLoader* _tmp5_;
		GstMapInfo _tmp6_;
		guint8* _tmp7_;
		gint _tmp7__length1;
		_tmp2_ = gdk_pixbuf_loader_new ();
		loader = _tmp2_;
		_tmp5_ = loader;
		_tmp6_ = map_info;
		_tmp7_ = _tmp6_.data;
		_tmp7__length1 = _tmp6_.size;
		_tmp4_ = gdk_pixbuf_loader_write (_tmp5_, _tmp7_, (gsize) _tmp7__length1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (loader);
			goto __catch0_g_error;
		}
		if (_tmp4_) {
			gboolean _tmp8_ = FALSE;
			GdkPixbufLoader* _tmp9_;
			_tmp9_ = loader;
			_tmp8_ = gdk_pixbuf_loader_close (_tmp9_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (loader);
				goto __catch0_g_error;
			}
			_tmp3_ = _tmp8_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			GdkPixbufLoader* _tmp10_;
			GdkPixbuf* _tmp11_;
			GdkPixbuf* _tmp12_;
			_tmp10_ = loader;
			_tmp11_ = gdk_pixbuf_loader_get_pixbuf (_tmp10_);
			_tmp12_ = _g_object_ref0 (_tmp11_);
			_g_object_unref0 (pix);
			pix = _tmp12_;
		}
		_g_object_unref0 (loader);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = err;
		_tmp14_ = _tmp13_->message;
		g_warning ("PlaybackManager.vala:402: Error processing image data: %s", _tmp14_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (pix);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp15_ = map_info;
	gst_buffer_unmap (buffer, &_tmp15_);
	result = pix;
	return result;
}

MusicAudioObject*
music_playback_manager_get_current_audio (MusicPlaybackManager* self)
{
	MusicAudioObject* result;
	MusicAudioObject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_audio;
	result = _tmp0_;
	return result;
}

void
music_playback_manager_set_current_audio (MusicPlaybackManager* self,
                                          MusicAudioObject* value)
{
	MusicAudioObject* old_value;
	g_return_if_fail (self != NULL);
	old_value = music_playback_manager_get_current_audio (self);
	if (old_value != value) {
		MusicAudioObject* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_current_audio);
		self->priv->_current_audio = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, music_playback_manager_properties[MUSIC_PLAYBACK_MANAGER_CURRENT_AUDIO_PROPERTY]);
	}
}

GListStore*
music_playback_manager_get_queue_liststore (MusicPlaybackManager* self)
{
	GListStore* result;
	GListStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_queue_liststore;
	result = _tmp0_;
	return result;
}

static void
music_playback_manager_set_queue_liststore (MusicPlaybackManager* self,
                                            GListStore* value)
{
	GListStore* old_value;
	g_return_if_fail (self != NULL);
	old_value = music_playback_manager_get_queue_liststore (self);
	if (old_value != value) {
		GListStore* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_queue_liststore);
		self->priv->_queue_liststore = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, music_playback_manager_properties[MUSIC_PLAYBACK_MANAGER_QUEUE_LISTSTORE_PROPERTY]);
	}
}

gint64
music_playback_manager_get_playback_position (MusicPlaybackManager* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_playback_position;
	return result;
}

static void
music_playback_manager_set_playback_position (MusicPlaybackManager* self,
                                              gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = music_playback_manager_get_playback_position (self);
	if (old_value != value) {
		self->priv->_playback_position = value;
		g_object_notify_by_pspec ((GObject *) self, music_playback_manager_properties[MUSIC_PLAYBACK_MANAGER_PLAYBACK_POSITION_PROPERTY]);
	}
}

static gboolean
_music_playback_manager_bus_callback_gst_bus_func (GstBus* bus,
                                                   GstMessage* message,
                                                   gpointer self)
{
	gboolean result;
	result = music_playback_manager_bus_callback ((MusicPlaybackManager*) self, bus, message);
	return result;
}

static void
_music_playback_manager_update_metadata_gst_discoverer_discovered (GstDiscoverer* _sender,
                                                                   GstDiscovererInfo* info,
                                                                   GError* err,
                                                                   gpointer self)
{
	music_playback_manager_update_metadata ((MusicPlaybackManager*) self, info, err);
}

static void
_gst_discoverer_stop_gst_discoverer_finished (GstDiscoverer* _sender,
                                              gpointer self)
{
	gst_discoverer_stop ((GstDiscoverer*) self);
}

static void
_music_playback_manager___lambda7_ (MusicPlaybackManager* self)
{
	GSimpleAction* shuffle_action_action = NULL;
	GApplication* _tmp0_;
	GAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GListStore* _tmp4_;
	_tmp0_ = g_application_get_default ();
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) _tmp0_, MUSIC_APPLICATION_ACTION_SHUFFLE);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction));
	shuffle_action_action = _tmp2_;
	_tmp3_ = shuffle_action_action;
	_tmp4_ = self->priv->_queue_liststore;
	g_simple_action_set_enabled (_tmp3_, g_list_model_get_n_items ((GListModel*) _tmp4_) > ((guint) 1));
	music_playback_manager_update_next_previous_sensitivity (self);
	_g_object_unref0 (shuffle_action_action);
}

static void
__music_playback_manager___lambda7__g_list_model_items_changed (GListModel* _sender,
                                                                guint position,
                                                                guint removed,
                                                                guint added,
                                                                gpointer self)
{
	_music_playback_manager___lambda7_ ((MusicPlaybackManager*) self);
}

static void
_music_playback_manager___lambda8_ (MusicPlaybackManager* self)
{
	GstElement* _tmp0_;
	MusicAudioObject* _tmp1_;
	GSimpleAction* play_pause_action = NULL;
	GApplication* _tmp8_;
	GAction* _tmp9_;
	GSimpleAction* _tmp10_;
	GSimpleAction* _tmp11_;
	MusicAudioObject* _tmp12_;
	_tmp0_ = self->priv->playbin;
	gst_element_set_state (_tmp0_, GST_STATE_NULL);
	_tmp1_ = self->priv->_current_audio;
	if (_tmp1_ != NULL) {
		GstElement* _tmp2_;
		MusicAudioObject* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GstElement* _tmp6_;
		_tmp2_ = self->priv->playbin;
		_tmp3_ = self->priv->_current_audio;
		_tmp4_ = music_audio_object_get_uri (_tmp3_);
		_tmp5_ = _tmp4_;
		g_object_set (_tmp2_, "uri", _tmp5_, NULL);
		_tmp6_ = self->priv->playbin;
		gst_element_set_state (_tmp6_, GST_STATE_PLAYING);
	} else {
		GstElement* _tmp7_;
		_tmp7_ = self->priv->playbin;
		g_object_set (_tmp7_, "uri", "", NULL);
		music_playback_manager_set_playback_position (self, (gint64) 0);
		if (self->priv->progress_timer != ((guint) 0)) {
			g_source_remove (self->priv->progress_timer);
			self->priv->progress_timer = (guint) 0;
		}
	}
	music_playback_manager_update_next_previous_sensitivity (self);
	_tmp8_ = g_application_get_default ();
	_tmp9_ = g_action_map_lookup_action ((GActionMap*) _tmp8_, MUSIC_APPLICATION_ACTION_PLAY_PAUSE);
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_simple_action_get_type (), GSimpleAction));
	play_pause_action = _tmp10_;
	_tmp11_ = play_pause_action;
	_tmp12_ = self->priv->_current_audio;
	g_simple_action_set_enabled (_tmp11_, _tmp12_ != NULL);
	_g_object_unref0 (play_pause_action);
}

static void
__music_playback_manager___lambda8__g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	_music_playback_manager___lambda8_ ((MusicPlaybackManager*) self);
}

static GObject *
music_playback_manager_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MusicPlaybackManager * self;
	GListStore* _tmp0_;
	GListStore* _tmp1_;
	GstElement* _tmp2_;
	GstBus* bus = NULL;
	GstElement* _tmp3_;
	GstBus* _tmp4_;
	GstBus* _tmp5_;
	GstBus* _tmp6_;
	GListStore* _tmp15_;
	GSettings* _tmp16_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (music_playback_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManager);
	_tmp0_ = g_list_store_new (MUSIC_TYPE_AUDIO_OBJECT);
	_tmp1_ = _tmp0_;
	music_playback_manager_set_queue_liststore (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = gst_element_factory_make ("playbin", "playbin");
	if (_tmp2_ != NULL) {
		g_object_ref_sink (_tmp2_);
	}
	_g_object_unref0 (self->priv->playbin);
	self->priv->playbin = _tmp2_;
	_tmp3_ = self->priv->playbin;
	_tmp4_ = gst_element_get_bus (_tmp3_);
	bus = _tmp4_;
	_tmp5_ = bus;
	gst_bus_add_watch_full (_tmp5_, 0, _music_playback_manager_bus_callback_gst_bus_func, g_object_ref (self), g_object_unref);
	_tmp6_ = bus;
	gst_bus_enable_sync_message_emission (_tmp6_);
	{
		GstDiscoverer* _tmp7_ = NULL;
		GstDiscoverer* _tmp8_;
		GstDiscoverer* _tmp9_;
		GstDiscoverer* _tmp10_;
		GstDiscoverer* _tmp11_;
		GstDiscoverer* _tmp12_;
		_tmp8_ = gst_discoverer_new ((GstClockTime) (5 * GST_SECOND), &_inner_error0_);
		_tmp7_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp9_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (self->priv->discoverer);
		self->priv->discoverer = _tmp9_;
		_tmp10_ = self->priv->discoverer;
		g_signal_connect_object (_tmp10_, "discovered", (GCallback) _music_playback_manager_update_metadata_gst_discoverer_discovered, self, 0);
		_tmp11_ = self->priv->discoverer;
		_tmp12_ = self->priv->discoverer;
		g_signal_connect_object (_tmp11_, "finished", (GCallback) _gst_discoverer_stop_gst_discoverer_finished, _tmp12_, 0);
		_g_object_unref0 (_tmp7_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_critical ("PlaybackManager.vala:48: Unable to start Gstreamer Discoverer: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (bus);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp15_ = self->priv->_queue_liststore;
	g_signal_connect_object ((GListModel*) _tmp15_, "items-changed", (GCallback) __music_playback_manager___lambda7__g_list_model_items_changed, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::current-audio", (GCallback) __music_playback_manager___lambda8__g_object_notify, self, 0);
	_tmp16_ = g_settings_new ("io.elementary.music");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp16_;
	_g_object_unref0 (bus);
	return obj;
}

static void
music_playback_manager_class_init (MusicPlaybackManagerClass * klass,
                                   gpointer klass_data)
{
	music_playback_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MusicPlaybackManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_music_playback_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_music_playback_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = music_playback_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = music_playback_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MUSIC_PLAYBACK_MANAGER_CURRENT_AUDIO_PROPERTY, music_playback_manager_properties[MUSIC_PLAYBACK_MANAGER_CURRENT_AUDIO_PROPERTY] = g_param_spec_object ("current-audio", "current-audio", "current-audio", MUSIC_TYPE_AUDIO_OBJECT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MUSIC_PLAYBACK_MANAGER_QUEUE_LISTSTORE_PROPERTY, music_playback_manager_properties[MUSIC_PLAYBACK_MANAGER_QUEUE_LISTSTORE_PROPERTY] = g_param_spec_object ("queue-liststore", "queue-liststore", "queue-liststore", g_list_store_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MUSIC_PLAYBACK_MANAGER_PLAYBACK_POSITION_PROPERTY, music_playback_manager_properties[MUSIC_PLAYBACK_MANAGER_PLAYBACK_POSITION_PROPERTY] = g_param_spec_int64 ("playback-position", "playback-position", "playback-position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	music_playback_manager_signals[MUSIC_PLAYBACK_MANAGER_INVALIDS_FOUND_SIGNAL] = g_signal_new ("invalids-found", MUSIC_TYPE_PLAYBACK_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}

static void
music_playback_manager_instance_init (MusicPlaybackManager * self,
                                      gpointer klass)
{
	self->priv = music_playback_manager_get_instance_private (self);
	self->priv->_current_audio = NULL;
	self->priv->progress_timer = (guint) 0;
	self->priv->next_by_eos = FALSE;
	self->priv->direction = MUSIC_PLAYBACK_MANAGER_DIRECTION_NONE;
}

static void
music_playback_manager_finalize (GObject * obj)
{
	MusicPlaybackManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManager);
	_g_object_unref0 (self->priv->_current_audio);
	_g_object_unref0 (self->priv->_queue_liststore);
	_g_object_unref0 (self->priv->playbin);
	_g_object_unref0 (self->priv->discoverer);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (music_playback_manager_parent_class)->finalize (obj);
}

static GType
music_playback_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MusicPlaybackManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) music_playback_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MusicPlaybackManager), 0, (GInstanceInitFunc) music_playback_manager_instance_init, NULL };
	GType music_playback_manager_type_id;
	music_playback_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "MusicPlaybackManager", &g_define_type_info, 0);
	MusicPlaybackManager_private_offset = g_type_add_instance_private (music_playback_manager_type_id, sizeof (MusicPlaybackManagerPrivate));
	return music_playback_manager_type_id;
}

GType
music_playback_manager_get_type (void)
{
	static volatile gsize music_playback_manager_type_id__once = 0;
	if (g_once_init_enter (&music_playback_manager_type_id__once)) {
		GType music_playback_manager_type_id;
		music_playback_manager_type_id = music_playback_manager_get_type_once ();
		g_once_init_leave (&music_playback_manager_type_id__once, music_playback_manager_type_id);
	}
	return music_playback_manager_type_id__once;
}

static void
_vala_music_playback_manager_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	MusicPlaybackManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManager);
	switch (property_id) {
		case MUSIC_PLAYBACK_MANAGER_CURRENT_AUDIO_PROPERTY:
		g_value_set_object (value, music_playback_manager_get_current_audio (self));
		break;
		case MUSIC_PLAYBACK_MANAGER_QUEUE_LISTSTORE_PROPERTY:
		g_value_set_object (value, music_playback_manager_get_queue_liststore (self));
		break;
		case MUSIC_PLAYBACK_MANAGER_PLAYBACK_POSITION_PROPERTY:
		g_value_set_int64 (value, music_playback_manager_get_playback_position (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_music_playback_manager_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	MusicPlaybackManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManager);
	switch (property_id) {
		case MUSIC_PLAYBACK_MANAGER_CURRENT_AUDIO_PROPERTY:
		music_playback_manager_set_current_audio (self, g_value_get_object (value));
		break;
		case MUSIC_PLAYBACK_MANAGER_QUEUE_LISTSTORE_PROPERTY:
		music_playback_manager_set_queue_liststore (self, g_value_get_object (value));
		break;
		case MUSIC_PLAYBACK_MANAGER_PLAYBACK_POSITION_PROPERTY:
		music_playback_manager_set_playback_position (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

