/* SlideEffect.c generated by valac 0.56.18, the Vala compiler
 * generated from SlideEffect.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*               2010 Maxim Kartashev
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "pantheon-photos-transitions.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "io.elementary.photos.h"
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>

#define SLIDE_EFFECT_DESIRED_FPS 25
#define SLIDE_EFFECT_MIN_FPS 15
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_SLIDE_EFFECT_DESCRIPTOR (slide_effect_descriptor_get_type ())
#define SLIDE_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLIDE_EFFECT_DESCRIPTOR, SlideEffectDescriptor))
#define SLIDE_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLIDE_EFFECT_DESCRIPTOR, SlideEffectDescriptorClass))
#define IS_SLIDE_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLIDE_EFFECT_DESCRIPTOR))
#define IS_SLIDE_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLIDE_EFFECT_DESCRIPTOR))
#define SLIDE_EFFECT_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLIDE_EFFECT_DESCRIPTOR, SlideEffectDescriptorClass))

typedef struct _SlideEffectDescriptor SlideEffectDescriptor;
typedef struct _SlideEffectDescriptorClass SlideEffectDescriptorClass;
typedef struct _SlideEffectDescriptorPrivate SlideEffectDescriptorPrivate;
enum  {
	SLIDE_EFFECT_DESCRIPTOR_0_PROPERTY,
	SLIDE_EFFECT_DESCRIPTOR_NUM_PROPERTIES
};
static GParamSpec* slide_effect_descriptor_properties[SLIDE_EFFECT_DESCRIPTOR_NUM_PROPERTIES];

#define TYPE_SLIDE_EFFECT (slide_effect_get_type ())
#define SLIDE_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLIDE_EFFECT, SlideEffect))
#define SLIDE_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLIDE_EFFECT, SlideEffectClass))
#define IS_SLIDE_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLIDE_EFFECT))
#define IS_SLIDE_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLIDE_EFFECT))
#define SLIDE_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLIDE_EFFECT, SlideEffectClass))

typedef struct _SlideEffect SlideEffect;
typedef struct _SlideEffectClass SlideEffectClass;
typedef struct _SlideEffectPrivate SlideEffectPrivate;
enum  {
	SLIDE_EFFECT_0_PROPERTY,
	SLIDE_EFFECT_NUM_PROPERTIES
};
static GParamSpec* slide_effect_properties[SLIDE_EFFECT_NUM_PROPERTIES];

struct _SlideEffectDescriptor {
	ShotwellTransitionDescriptor parent_instance;
	SlideEffectDescriptorPrivate * priv;
};

struct _SlideEffectDescriptorClass {
	ShotwellTransitionDescriptorClass parent_class;
};

struct _SlideEffect {
	GObject parent_instance;
	SlideEffectPrivate * priv;
};

struct _SlideEffectClass {
	GObjectClass parent_class;
};

static gpointer slide_effect_descriptor_parent_class = NULL;
static gpointer slide_effect_parent_class = NULL;
static SpitTransitionsEffectIface * slide_effect_spit_transitions_effect_parent_iface = NULL;

VALA_EXTERN GType slide_effect_descriptor_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SlideEffectDescriptor* slide_effect_descriptor_new (GFile* resource_directory);
VALA_EXTERN SlideEffectDescriptor* slide_effect_descriptor_construct (GType object_type,
                                                          GFile* resource_directory);
static const gchar* slide_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base);
static const gchar* slide_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base);
static SpitTransitionsEffect* slide_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                                            SpitHostInterface* host);
VALA_EXTERN SlideEffect* slide_effect_new (void);
VALA_EXTERN SlideEffect* slide_effect_construct (GType object_type);
VALA_EXTERN GType slide_effect_get_type (void) G_GNUC_CONST ;
static GType slide_effect_descriptor_get_type_once (void);
static void slide_effect_real_get_fps (SpitTransitionsEffect* base,
                                gint* desired_fps,
                                gint* min_fps);
static void slide_effect_real_start (SpitTransitionsEffect* base,
                              SpitTransitionsVisuals* visuals,
                              SpitTransitionsMotion* motion);
static gboolean slide_effect_real_needs_clear_background (SpitTransitionsEffect* base);
static void slide_effect_real_paint (SpitTransitionsEffect* base,
                              SpitTransitionsVisuals* visuals,
                              SpitTransitionsMotion* motion,
                              cairo_t* ctx,
                              gint width,
                              gint height,
                              gint frame_number);
static void slide_effect_real_advance (SpitTransitionsEffect* base,
                                SpitTransitionsVisuals* visuals,
                                SpitTransitionsMotion* motion,
                                gint frame_number);
static void slide_effect_real_cancel (SpitTransitionsEffect* base);
static GType slide_effect_get_type_once (void);

SlideEffectDescriptor*
slide_effect_descriptor_construct (GType object_type,
                                   GFile* resource_directory)
{
	SlideEffectDescriptor * self = NULL;
	g_return_val_if_fail (resource_directory != NULL, NULL);
	self = (SlideEffectDescriptor*) shotwell_transition_descriptor_construct (object_type, resource_directory);
	return self;
}

SlideEffectDescriptor*
slide_effect_descriptor_new (GFile* resource_directory)
{
	return slide_effect_descriptor_construct (TYPE_SLIDE_EFFECT_DESCRIPTOR, resource_directory);
}

static const gchar*
slide_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base)
{
	SlideEffectDescriptor * self;
	const gchar* result;
	self = (SlideEffectDescriptor*) base;
	result = "io.elementary.photos.transitions.slide";
	return result;
}

static const gchar*
slide_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base)
{
	SlideEffectDescriptor * self;
	const gchar* result;
	self = (SlideEffectDescriptor*) base;
	result = _ ("Slide");
	return result;
}

static SpitTransitionsEffect*
slide_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                     SpitHostInterface* host)
{
	SlideEffectDescriptor * self;
	SlideEffect* _tmp0_;
	SpitTransitionsEffect* result;
	self = (SlideEffectDescriptor*) base;
	g_return_val_if_fail (host != NULL, NULL);
	_tmp0_ = slide_effect_new ();
	result = (SpitTransitionsEffect*) _tmp0_;
	return result;
}

static void
slide_effect_descriptor_class_init (SlideEffectDescriptorClass * klass,
                                    gpointer klass_data)
{
	slide_effect_descriptor_parent_class = g_type_class_peek_parent (klass);
	((ShotwellTransitionDescriptorClass *) klass)->get_id = (const gchar* (*) (ShotwellTransitionDescriptor*)) slide_effect_descriptor_real_get_id;
	((ShotwellTransitionDescriptorClass *) klass)->get_pluggable_name = (const gchar* (*) (ShotwellTransitionDescriptor*)) slide_effect_descriptor_real_get_pluggable_name;
	((ShotwellTransitionDescriptorClass *) klass)->create = (SpitTransitionsEffect* (*) (ShotwellTransitionDescriptor*, SpitHostInterface*)) slide_effect_descriptor_real_create;
}

static void
slide_effect_descriptor_instance_init (SlideEffectDescriptor * self,
                                       gpointer klass)
{
}

static GType
slide_effect_descriptor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlideEffectDescriptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slide_effect_descriptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlideEffectDescriptor), 0, (GInstanceInitFunc) slide_effect_descriptor_instance_init, NULL };
	GType slide_effect_descriptor_type_id;
	slide_effect_descriptor_type_id = g_type_register_static (TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, "SlideEffectDescriptor", &g_define_type_info, 0);
	return slide_effect_descriptor_type_id;
}

GType
slide_effect_descriptor_get_type (void)
{
	static volatile gsize slide_effect_descriptor_type_id__once = 0;
	if (g_once_init_enter (&slide_effect_descriptor_type_id__once)) {
		GType slide_effect_descriptor_type_id;
		slide_effect_descriptor_type_id = slide_effect_descriptor_get_type_once ();
		g_once_init_leave (&slide_effect_descriptor_type_id__once, slide_effect_descriptor_type_id);
	}
	return slide_effect_descriptor_type_id__once;
}

SlideEffect*
slide_effect_construct (GType object_type)
{
	SlideEffect * self = NULL;
	self = (SlideEffect*) g_object_new (object_type, NULL);
	return self;
}

SlideEffect*
slide_effect_new (void)
{
	return slide_effect_construct (TYPE_SLIDE_EFFECT);
}

static void
slide_effect_real_get_fps (SpitTransitionsEffect* base,
                           gint* desired_fps,
                           gint* min_fps)
{
	SlideEffect * self;
	gint _vala_desired_fps = 0;
	gint _vala_min_fps = 0;
	self = (SlideEffect*) base;
	_vala_desired_fps = SLIDE_EFFECT_DESIRED_FPS;
	_vala_min_fps = SLIDE_EFFECT_MIN_FPS;
	if (desired_fps) {
		*desired_fps = _vala_desired_fps;
	}
	if (min_fps) {
		*min_fps = _vala_min_fps;
	}
}

static void
slide_effect_real_start (SpitTransitionsEffect* base,
                         SpitTransitionsVisuals* visuals,
                         SpitTransitionsMotion* motion)
{
	SlideEffect * self;
	self = (SlideEffect*) base;
	g_return_if_fail (visuals != NULL);
	g_return_if_fail (motion != NULL);
}

static gboolean
slide_effect_real_needs_clear_background (SpitTransitionsEffect* base)
{
	SlideEffect * self;
	gboolean result;
	self = (SlideEffect*) base;
	result = TRUE;
	return result;
}

static void
slide_effect_real_paint (SpitTransitionsEffect* base,
                         SpitTransitionsVisuals* visuals,
                         SpitTransitionsMotion* motion,
                         cairo_t* ctx,
                         gint width,
                         gint height,
                         gint frame_number)
{
	SlideEffect * self;
	gdouble alpha = 0.0;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp15_;
	GdkPixbuf* _tmp16_;
	self = (SlideEffect*) base;
	g_return_if_fail (visuals != NULL);
	g_return_if_fail (motion != NULL);
	g_return_if_fail (ctx != NULL);
	alpha = spit_transitions_motion_get_alpha (motion, frame_number);
	_tmp0_ = spit_transitions_visuals_get_from_pixbuf (visuals);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		gint _tmp2_ = 0;
		SpitTransitionsDirection _tmp3_;
		SpitTransitionsDirection _tmp4_;
		gint from_target_x = 0;
		gint from_current_x = 0;
		GdkRectangle _tmp9_ = {0};
		GdkRectangle _tmp10_;
		GdkPixbuf* _tmp11_;
		GdkPixbuf* _tmp12_;
		GdkRectangle _tmp13_ = {0};
		GdkRectangle _tmp14_;
		_tmp3_ = spit_transitions_motion_get_direction (motion);
		_tmp4_ = _tmp3_;
		if (_tmp4_ == SPIT_TRANSITIONS_DIRECTION_FORWARD) {
			GdkPixbuf* _tmp5_;
			GdkPixbuf* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			_tmp5_ = spit_transitions_visuals_get_from_pixbuf (visuals);
			_tmp6_ = _tmp5_;
			_tmp7_ = gdk_pixbuf_get_width (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp2_ = -_tmp8_;
		} else {
			_tmp2_ = width;
		}
		from_target_x = _tmp2_;
		spit_transitions_visuals_get_from_pos (visuals, &_tmp9_);
		_tmp10_ = _tmp9_;
		from_current_x = (gint) ((_tmp10_.x * (1 - alpha)) + (from_target_x * alpha));
		_tmp11_ = spit_transitions_visuals_get_from_pixbuf (visuals);
		_tmp12_ = _tmp11_;
		spit_transitions_visuals_get_from_pos (visuals, &_tmp13_);
		_tmp14_ = _tmp13_;
		gdk_cairo_set_source_pixbuf (ctx, _tmp12_, (gdouble) from_current_x, (gdouble) _tmp14_.y);
		cairo_paint (ctx);
	}
	_tmp15_ = spit_transitions_visuals_get_to_pixbuf (visuals);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		gint to_target_x = 0;
		GdkPixbuf* _tmp17_;
		GdkPixbuf* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _tmp21_ = 0;
		SpitTransitionsDirection _tmp22_;
		SpitTransitionsDirection _tmp23_;
		gint from_x = 0;
		gint to_current_x = 0;
		GdkPixbuf* _tmp28_;
		GdkPixbuf* _tmp29_;
		GdkRectangle _tmp30_ = {0};
		GdkRectangle _tmp31_;
		_tmp17_ = spit_transitions_visuals_get_to_pixbuf (visuals);
		_tmp18_ = _tmp17_;
		_tmp19_ = gdk_pixbuf_get_width (_tmp18_);
		_tmp20_ = _tmp19_;
		to_target_x = (width - _tmp20_) / 2;
		_tmp22_ = spit_transitions_motion_get_direction (motion);
		_tmp23_ = _tmp22_;
		if (_tmp23_ == SPIT_TRANSITIONS_DIRECTION_FORWARD) {
			_tmp21_ = width;
		} else {
			GdkPixbuf* _tmp24_;
			GdkPixbuf* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			_tmp24_ = spit_transitions_visuals_get_to_pixbuf (visuals);
			_tmp25_ = _tmp24_;
			_tmp26_ = gdk_pixbuf_get_width (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp21_ = -_tmp27_;
		}
		from_x = _tmp21_;
		to_current_x = (gint) ((from_x * (1 - alpha)) + (to_target_x * alpha));
		_tmp28_ = spit_transitions_visuals_get_to_pixbuf (visuals);
		_tmp29_ = _tmp28_;
		spit_transitions_visuals_get_to_pos (visuals, &_tmp30_);
		_tmp31_ = _tmp30_;
		gdk_cairo_set_source_pixbuf (ctx, _tmp29_, (gdouble) to_current_x, (gdouble) _tmp31_.y);
		cairo_paint (ctx);
	}
}

static void
slide_effect_real_advance (SpitTransitionsEffect* base,
                           SpitTransitionsVisuals* visuals,
                           SpitTransitionsMotion* motion,
                           gint frame_number)
{
	SlideEffect * self;
	self = (SlideEffect*) base;
	g_return_if_fail (visuals != NULL);
	g_return_if_fail (motion != NULL);
}

static void
slide_effect_real_cancel (SpitTransitionsEffect* base)
{
	SlideEffect * self;
	self = (SlideEffect*) base;
}

static void
slide_effect_class_init (SlideEffectClass * klass,
                         gpointer klass_data)
{
	slide_effect_parent_class = g_type_class_peek_parent (klass);
}

static void
slide_effect_spit_transitions_effect_interface_init (SpitTransitionsEffectIface * iface,
                                                     gpointer iface_data)
{
	slide_effect_spit_transitions_effect_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_fps = (void (*) (SpitTransitionsEffect*, gint*, gint*)) slide_effect_real_get_fps;
	iface->start = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*)) slide_effect_real_start;
	iface->needs_clear_background = (gboolean (*) (SpitTransitionsEffect*)) slide_effect_real_needs_clear_background;
	iface->paint = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, cairo_t*, gint, gint, gint)) slide_effect_real_paint;
	iface->advance = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, gint)) slide_effect_real_advance;
	iface->cancel = (void (*) (SpitTransitionsEffect*)) slide_effect_real_cancel;
}

static void
slide_effect_instance_init (SlideEffect * self,
                            gpointer klass)
{
}

static GType
slide_effect_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlideEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slide_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlideEffect), 0, (GInstanceInitFunc) slide_effect_instance_init, NULL };
	static const GInterfaceInfo spit_transitions_effect_info = { (GInterfaceInitFunc) slide_effect_spit_transitions_effect_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType slide_effect_type_id;
	slide_effect_type_id = g_type_register_static (G_TYPE_OBJECT, "SlideEffect", &g_define_type_info, 0);
	g_type_add_interface_static (slide_effect_type_id, SPIT_TRANSITIONS_TYPE_EFFECT, &spit_transitions_effect_info);
	return slide_effect_type_id;
}

GType
slide_effect_get_type (void)
{
	static volatile gsize slide_effect_type_id__once = 0;
	if (g_once_init_enter (&slide_effect_type_id__once)) {
		GType slide_effect_type_id;
		slide_effect_type_id = slide_effect_get_type_once ();
		g_once_init_leave (&slide_effect_type_id__once, slide_effect_type_id);
	}
	return slide_effect_type_id__once;
}

