/* ContainerSourceCollection.c generated by valac 0.56.18, the Vala compiler
 * generated from ContainerSourceCollection.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/
/* A ContainerSourceCollection is for DataSources which maintain links to one or more other*/
/* DataSources, assumed to be of a different type.  ContainerSourceCollection automates the task*/
/* of handling unlinking and relinking and maintaining backlinks.  Unlinked DataSources are*/
/* held in a holding tank, until they are either relinked or destroyed.*/
/**/
/* If the ContainerSourceCollection's DataSources are types that "evaporate" (i.e. they disappear*/
/* when they hold no items), they should use the evaporate () method, which will either destroy*/
/* the DataSource or hold it in the tank (if backlinks are outstanding).*/

#include "io.elementary.photos.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _source_backlink_unref0(var) ((var == NULL) ? NULL : (var = (source_backlink_unref (var), NULL)))
enum  {
	CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_ADDED_SIGNAL,
	CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_REMOVED_SIGNAL,
	CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_ALTERED_SIGNAL,
	CONTAINER_SOURCE_COLLECTION_BACKLINK_TO_CONTAINER_REMOVED_SIGNAL,
	CONTAINER_SOURCE_COLLECTION_NUM_SIGNALS
};
static guint container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ContainerSourceCollectionPrivate {
	GeeHashSet* attached_collections;
	gchar* backlink_name;
	GeeHashSet* holding_tank;
};

static gint ContainerSourceCollection_private_offset;
static gpointer container_source_collection_parent_class = NULL;

static void container_source_collection_real_notify_backlink_removed (SourceCollection* base,
                                                               SourceBacklink* backlink,
                                                               GeeCollection* sources);
static void container_source_collection_real_notify_container_contents_added (ContainerSourceCollection* self,
                                                                       ContainerSource* container,
                                                                       GeeCollection* added,
                                                                       gboolean relinked);
static void container_source_collection_real_notify_container_contents_removed (ContainerSourceCollection* self,
                                                                         ContainerSource* container,
                                                                         GeeCollection* removed,
                                                                         gboolean unlinked);
static void container_source_collection_real_notify_container_contents_altered (ContainerSourceCollection* self,
                                                                         ContainerSource* container,
                                                                         GeeCollection* added,
                                                                         gboolean relinked,
                                                                         GeeCollection* removed,
                                                                         gboolean unlinked);
static void container_source_collection_real_notify_backlink_to_container_removed (ContainerSourceCollection* self,
                                                                            ContainerSource* container,
                                                                            GeeCollection* sources);
static GeeCollection* container_source_collection_real_get_containers_holding_source (ContainerSourceCollection* self,
                                                                               DataSource* source);
static ContainerSource* container_source_collection_real_convert_backlink_to_container (ContainerSourceCollection* self,
                                                                                 SourceBacklink* backlink);
static void container_source_collection_on_contained_sources_unlinking (ContainerSourceCollection* self,
                                                                 GeeCollection* unlinking);
static void container_source_collection_on_contained_sources_relinked (ContainerSourceCollection* self,
                                                                GeeCollection* relinked);
static void container_source_collection_on_contained_source_destroyed (ContainerSourceCollection* self,
                                                                DataSource* source);
static void container_source_collection_real_notify_item_destroyed (SourceCollection* base,
                                                             DataSource* source);
static void _container_source_collection_on_contained_sources_unlinking_source_collection_items_unlinking (SourceCollection* _sender,
                                                                                                    GeeCollection* unlinking,
                                                                                                    gpointer self);
static void _container_source_collection_on_contained_sources_relinked_source_collection_items_relinked (SourceCollection* _sender,
                                                                                                  GeeCollection* relinked,
                                                                                                  gpointer self);
static void _container_source_collection_on_contained_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                                                  DataSource* source,
                                                                                                  gpointer self);
static void _container_source_collection_on_contained_source_destroyed_source_collection_unlinked_destroyed (SourceCollection* _sender,
                                                                                                      DataSource* source,
                                                                                                      gpointer self);
static void container_source_collection_real_container_contents_added (ContainerSourceCollection* self,
                                                                ContainerSource* container,
                                                                GeeCollection* added,
                                                                gboolean relinked);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOOLEAN (GClosure * closure,
                                                          GValue * return_value,
                                                          guint n_param_values,
                                                          const GValue * param_values,
                                                          gpointer invocation_hint,
                                                          gpointer marshal_data);
static void container_source_collection_real_container_contents_removed (ContainerSourceCollection* self,
                                                                  ContainerSource* container,
                                                                  GeeCollection* removed,
                                                                  gboolean unlinked);
static void container_source_collection_real_container_contents_altered (ContainerSourceCollection* self,
                                                                  ContainerSource* container,
                                                                  GeeCollection* added,
                                                                  gboolean relinked,
                                                                  GeeCollection* removed,
                                                                  gboolean unlinked);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOOLEAN_OBJECT_BOOLEAN (GClosure * closure,
                                                                         GValue * return_value,
                                                                         guint n_param_values,
                                                                         const GValue * param_values,
                                                                         gpointer invocation_hint,
                                                                         gpointer marshal_data);
static void container_source_collection_real_backlink_to_container_removed (ContainerSourceCollection* self,
                                                                     ContainerSource* container,
                                                                     GeeCollection* sources);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void container_source_collection_finalize (DataCollection * obj);
static GType container_source_collection_get_type_once (void);

static inline gpointer
container_source_collection_get_instance_private (ContainerSourceCollection* self)
{
	return G_STRUCT_MEMBER_P (self, ContainerSourceCollection_private_offset);
}

ContainerSourceCollection*
container_source_collection_construct (GType object_type,
                                       const gchar* backlink_name,
                                       const gchar* name,
                                       GetSourceDatabaseKey source_key_func,
                                       gpointer source_key_func_target)
{
	ContainerSourceCollection* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (backlink_name != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (ContainerSourceCollection*) database_source_collection_construct (object_type, name, source_key_func, source_key_func_target);
	_tmp0_ = g_strdup (backlink_name);
	_g_free0 (self->priv->backlink_name);
	self->priv->backlink_name = _tmp0_;
	return self;
}

static void
container_source_collection_real_notify_backlink_removed (SourceCollection* base,
                                                          SourceBacklink* backlink,
                                                          GeeCollection* sources)
{
	ContainerSourceCollection * self;
	ContainerSource* container = NULL;
	ContainerSource* _tmp0_;
	ContainerSource* _tmp1_;
	self = (ContainerSourceCollection*) base;
	g_return_if_fail (backlink != NULL);
	g_return_if_fail (sources != NULL);
	SOURCE_COLLECTION_CLASS (container_source_collection_parent_class)->notify_backlink_removed ((SourceCollection*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), backlink, sources);
	_tmp0_ = container_source_collection_convert_backlink_to_container (self, backlink);
	container = _tmp0_;
	_tmp1_ = container;
	if (_tmp1_ != NULL) {
		ContainerSource* _tmp2_;
		_tmp2_ = container;
		container_source_collection_notify_backlink_to_container_removed (self, _tmp2_, sources);
	}
	_g_object_unref0 (container);
}

static void
container_source_collection_real_notify_container_contents_added (ContainerSourceCollection* self,
                                                                  ContainerSource* container,
                                                                  GeeCollection* added,
                                                                  gboolean relinked)
{
	GeeHashSet* _tmp0_;
	g_return_if_fail (container != NULL);
	g_return_if_fail (added != NULL);
	_tmp0_ = self->priv->holding_tank;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, container)) {
		gboolean removed = FALSE;
		GeeHashSet* _tmp1_;
		_tmp1_ = self->priv->holding_tank;
		removed = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp1_, container);
		_vala_assert (removed, "removed");
		source_collection_relink ((SourceCollection*) self, (DataSource*) container);
	}
	g_signal_emit (self, container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_ADDED_SIGNAL], 0, container, added, relinked);
}

void
container_source_collection_notify_container_contents_added (ContainerSourceCollection* self,
                                                             ContainerSource* container,
                                                             GeeCollection* added,
                                                             gboolean relinked)
{
	ContainerSourceCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CONTAINER_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_container_contents_added) {
		_klass_->notify_container_contents_added (self, container, added, relinked);
	}
}

static void
container_source_collection_real_notify_container_contents_removed (ContainerSourceCollection* self,
                                                                    ContainerSource* container,
                                                                    GeeCollection* removed,
                                                                    gboolean unlinked)
{
	g_return_if_fail (container != NULL);
	g_return_if_fail (removed != NULL);
	g_signal_emit (self, container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_REMOVED_SIGNAL], 0, container, removed, unlinked);
}

void
container_source_collection_notify_container_contents_removed (ContainerSourceCollection* self,
                                                               ContainerSource* container,
                                                               GeeCollection* removed,
                                                               gboolean unlinked)
{
	ContainerSourceCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CONTAINER_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_container_contents_removed) {
		_klass_->notify_container_contents_removed (self, container, removed, unlinked);
	}
}

static void
container_source_collection_real_notify_container_contents_altered (ContainerSourceCollection* self,
                                                                    ContainerSource* container,
                                                                    GeeCollection* added,
                                                                    gboolean relinked,
                                                                    GeeCollection* removed,
                                                                    gboolean unlinked)
{
	g_return_if_fail (container != NULL);
	g_signal_emit (self, container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_ALTERED_SIGNAL], 0, container, added, relinked, removed, unlinked);
}

void
container_source_collection_notify_container_contents_altered (ContainerSourceCollection* self,
                                                               ContainerSource* container,
                                                               GeeCollection* added,
                                                               gboolean relinked,
                                                               GeeCollection* removed,
                                                               gboolean unlinked)
{
	ContainerSourceCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CONTAINER_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_container_contents_altered) {
		_klass_->notify_container_contents_altered (self, container, added, relinked, removed, unlinked);
	}
}

static void
container_source_collection_real_notify_backlink_to_container_removed (ContainerSourceCollection* self,
                                                                       ContainerSource* container,
                                                                       GeeCollection* sources)
{
	g_return_if_fail (container != NULL);
	g_return_if_fail (sources != NULL);
	g_signal_emit (self, container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_BACKLINK_TO_CONTAINER_REMOVED_SIGNAL], 0, container, sources);
}

void
container_source_collection_notify_backlink_to_container_removed (ContainerSourceCollection* self,
                                                                  ContainerSource* container,
                                                                  GeeCollection* sources)
{
	ContainerSourceCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CONTAINER_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_backlink_to_container_removed) {
		_klass_->notify_backlink_to_container_removed (self, container, sources);
	}
}

static GeeCollection*
container_source_collection_real_get_containers_holding_source (ContainerSourceCollection* self,
                                                                DataSource* source)
{
	g_critical ("Type `%s' does not implement abstract method `container_source_collection_get_containers_holding_source'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GeeCollection*
container_source_collection_get_containers_holding_source (ContainerSourceCollection* self,
                                                           DataSource* source)
{
	ContainerSourceCollectionClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = CONTAINER_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->get_containers_holding_source) {
		return _klass_->get_containers_holding_source (self, source);
	}
	return NULL;
}

static ContainerSource*
container_source_collection_real_convert_backlink_to_container (ContainerSourceCollection* self,
                                                                SourceBacklink* backlink)
{
	g_critical ("Type `%s' does not implement abstract method `container_source_collection_convert_backlink_to_container'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

ContainerSource*
container_source_collection_convert_backlink_to_container (ContainerSourceCollection* self,
                                                           SourceBacklink* backlink)
{
	ContainerSourceCollectionClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = CONTAINER_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->convert_backlink_to_container) {
		return _klass_->convert_backlink_to_container (self, backlink);
	}
	return NULL;
}

void
container_source_collection_freeze_attached_notifications (ContainerSourceCollection* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _collection_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->attached_collections;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_collection_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			SourceCollection* collection = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			SourceCollection* _tmp5_;
			_tmp2_ = _collection_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _collection_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			collection = (SourceCollection*) _tmp4_;
			_tmp5_ = collection;
			data_collection_freeze_notifications ((DataCollection*) _tmp5_);
			_data_collection_unref0 (collection);
		}
		_g_object_unref0 (_collection_it);
	}
}

void
container_source_collection_thaw_attached_notifications (ContainerSourceCollection* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _collection_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->attached_collections;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_collection_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			SourceCollection* collection = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			SourceCollection* _tmp5_;
			_tmp2_ = _collection_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _collection_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			collection = (SourceCollection*) _tmp4_;
			_tmp5_ = collection;
			data_collection_thaw_notifications ((DataCollection*) _tmp5_);
			_data_collection_unref0 (collection);
		}
		_g_object_unref0 (_collection_it);
	}
}

GeeCollection*
container_source_collection_get_holding_tank (ContainerSourceCollection* self)
{
	GeeHashSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->holding_tank;
	_tmp1_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = (GeeCollection*) _tmp2_;
	return result;
}

void
container_source_collection_init_add_unlinked (ContainerSourceCollection* self,
                                               ContainerSource* unlinked)
{
	GeeHashSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (unlinked != NULL);
	_tmp0_ = self->priv->holding_tank;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, unlinked);
}

void
container_source_collection_init_add_many_unlinked (ContainerSourceCollection* self,
                                                    GeeCollection* unlinked)
{
	GeeHashSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (unlinked != NULL);
	_tmp0_ = self->priv->holding_tank;
	gee_collection_add_all ((GeeCollection*) _tmp0_, unlinked);
}

gboolean
container_source_collection_relink_from_holding_tank (ContainerSourceCollection* self,
                                                      ContainerSource* source)
{
	GeeHashSet* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = self->priv->holding_tank;
	if (!gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, source)) {
		result = FALSE;
		return result;
	}
	source_collection_relink ((SourceCollection*) self, (DataSource*) source);
	result = TRUE;
	return result;
}

static void
container_source_collection_on_contained_sources_unlinking (ContainerSourceCollection* self,
                                                            GeeCollection* unlinking)
{
	GeeHashMultiMap* map = NULL;
	GeeHashMultiMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (unlinking != NULL);
	container_source_collection_freeze_attached_notifications (self);
	_tmp0_ = gee_hash_multi_map_new (TYPE_CONTAINER_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	map = _tmp0_;
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) unlinking);
		_source_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			DataSource* source = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GeeCollection* containers = NULL;
			DataSource* _tmp5_;
			GeeCollection* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeCollection* _tmp8_;
			_tmp2_ = _source_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _source_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			source = (DataSource*) _tmp4_;
			_tmp5_ = source;
			_tmp6_ = container_source_collection_get_containers_holding_source (self, _tmp5_);
			containers = _tmp6_;
			_tmp8_ = containers;
			if (_tmp8_ == NULL) {
				_tmp7_ = TRUE;
			} else {
				GeeCollection* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				_tmp9_ = containers;
				_tmp10_ = gee_collection_get_size (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp7_ = _tmp11_ == 0;
			}
			if (_tmp7_) {
				_g_object_unref0 (containers);
				_g_object_unref0 (source);
				continue;
			}
			{
				GeeIterator* _container_it = NULL;
				GeeCollection* _tmp12_;
				GeeIterator* _tmp13_;
				_tmp12_ = containers;
				_tmp13_ = gee_iterable_iterator ((GeeIterable*) _tmp12_);
				_container_it = _tmp13_;
				while (TRUE) {
					GeeIterator* _tmp14_;
					ContainerSource* container = NULL;
					GeeIterator* _tmp15_;
					gpointer _tmp16_;
					GeeHashMultiMap* _tmp17_;
					ContainerSource* _tmp18_;
					DataSource* _tmp19_;
					DataSource* _tmp20_;
					ContainerSource* _tmp21_;
					SourceBacklink* _tmp22_;
					SourceBacklink* _tmp23_;
					_tmp14_ = _container_it;
					if (!gee_iterator_next (_tmp14_)) {
						break;
					}
					_tmp15_ = _container_it;
					_tmp16_ = gee_iterator_get (_tmp15_);
					container = (ContainerSource*) _tmp16_;
					_tmp17_ = map;
					_tmp18_ = container;
					_tmp19_ = source;
					gee_multi_map_set ((GeeMultiMap*) _tmp17_, _tmp18_, _tmp19_);
					_tmp20_ = source;
					_tmp21_ = container;
					_tmp22_ = container_source_get_backlink (_tmp21_);
					_tmp23_ = _tmp22_;
					data_source_set_backlink (_tmp20_, _tmp23_);
					_source_backlink_unref0 (_tmp23_);
					_g_object_unref0 (container);
				}
				_g_object_unref0 (_container_it);
			}
			_g_object_unref0 (containers);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	{
		GeeIterator* _container_it = NULL;
		GeeHashMultiMap* _tmp24_;
		GeeSet* _tmp25_;
		GeeSet* _tmp26_;
		GeeIterator* _tmp27_;
		GeeIterator* _tmp28_;
		_tmp24_ = map;
		_tmp25_ = gee_multi_map_get_keys ((GeeMultiMap*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = gee_iterable_iterator ((GeeIterable*) _tmp26_);
		_tmp28_ = _tmp27_;
		_g_object_unref0 (_tmp26_);
		_container_it = _tmp28_;
		while (TRUE) {
			GeeIterator* _tmp29_;
			ContainerSource* container = NULL;
			GeeIterator* _tmp30_;
			gpointer _tmp31_;
			ContainerSource* _tmp32_;
			GeeHashMultiMap* _tmp33_;
			ContainerSource* _tmp34_;
			GeeCollection* _tmp35_;
			GeeCollection* _tmp36_;
			_tmp29_ = _container_it;
			if (!gee_iterator_next (_tmp29_)) {
				break;
			}
			_tmp30_ = _container_it;
			_tmp31_ = gee_iterator_get (_tmp30_);
			container = (ContainerSource*) _tmp31_;
			_tmp32_ = container;
			_tmp33_ = map;
			_tmp34_ = container;
			_tmp35_ = gee_multi_map_get ((GeeMultiMap*) _tmp33_, _tmp34_);
			_tmp36_ = _tmp35_;
			container_source_break_link_many (_tmp32_, _tmp36_);
			_g_object_unref0 (_tmp36_);
			_g_object_unref0 (container);
		}
		_g_object_unref0 (_container_it);
	}
	container_source_collection_thaw_attached_notifications (self);
	_g_object_unref0 (map);
}

static void
container_source_collection_on_contained_sources_relinked (ContainerSourceCollection* self,
                                                           GeeCollection* relinked)
{
	GeeHashMultiMap* map = NULL;
	GeeHashMultiMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (relinked != NULL);
	container_source_collection_freeze_attached_notifications (self);
	_tmp0_ = gee_hash_multi_map_new (TYPE_CONTAINER_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	map = _tmp0_;
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) relinked);
		_source_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			DataSource* source = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GeeList* backlinks = NULL;
			DataSource* _tmp5_;
			const gchar* _tmp6_;
			GeeList* _tmp7_;
			gboolean _tmp8_ = FALSE;
			GeeList* _tmp9_;
			_tmp2_ = _source_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _source_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			source = (DataSource*) _tmp4_;
			_tmp5_ = source;
			_tmp6_ = self->priv->backlink_name;
			_tmp7_ = data_source_get_backlinks (_tmp5_, _tmp6_);
			backlinks = _tmp7_;
			_tmp9_ = backlinks;
			if (_tmp9_ == NULL) {
				_tmp8_ = TRUE;
			} else {
				GeeList* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				_tmp10_ = backlinks;
				_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
				_tmp12_ = _tmp11_;
				_tmp8_ = _tmp12_ == 0;
			}
			if (_tmp8_) {
				_g_object_unref0 (backlinks);
				_g_object_unref0 (source);
				continue;
			}
			{
				GeeList* _backlink_list = NULL;
				GeeList* _tmp13_;
				gint _backlink_size = 0;
				GeeList* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gint _backlink_index = 0;
				_tmp13_ = backlinks;
				_backlink_list = _tmp13_;
				_tmp14_ = _backlink_list;
				_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
				_tmp16_ = _tmp15_;
				_backlink_size = _tmp16_;
				_backlink_index = -1;
				while (TRUE) {
					gint _tmp17_;
					gint _tmp18_;
					SourceBacklink* backlink = NULL;
					GeeList* _tmp19_;
					gpointer _tmp20_;
					ContainerSource* container = NULL;
					SourceBacklink* _tmp21_;
					ContainerSource* _tmp22_;
					ContainerSource* _tmp23_;
					_backlink_index = _backlink_index + 1;
					_tmp17_ = _backlink_index;
					_tmp18_ = _backlink_size;
					if (!(_tmp17_ < _tmp18_)) {
						break;
					}
					_tmp19_ = _backlink_list;
					_tmp20_ = gee_list_get (_tmp19_, _backlink_index);
					backlink = (SourceBacklink*) _tmp20_;
					_tmp21_ = backlink;
					_tmp22_ = container_source_collection_convert_backlink_to_container (self, _tmp21_);
					container = _tmp22_;
					_tmp23_ = container;
					if (_tmp23_ != NULL) {
						GeeHashMultiMap* _tmp24_;
						ContainerSource* _tmp25_;
						DataSource* _tmp26_;
						_tmp24_ = map;
						_tmp25_ = container;
						_tmp26_ = source;
						gee_multi_map_set ((GeeMultiMap*) _tmp24_, _tmp25_, _tmp26_);
					} else {
						DataSource* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						SourceBacklink* _tmp30_;
						gchar* _tmp31_;
						gchar* _tmp32_;
						_tmp27_ = source;
						_tmp28_ = data_object_to_string ((DataObject*) _tmp27_);
						_tmp29_ = _tmp28_;
						_tmp30_ = backlink;
						_tmp31_ = source_backlink_to_string (_tmp30_);
						_tmp32_ = _tmp31_;
						g_warning ("ContainerSourceCollection.vala:174: Unable to relink %s to container b" \
"acklink %s", _tmp29_, _tmp32_);
						_g_free0 (_tmp32_);
						_g_free0 (_tmp29_);
					}
					_g_object_unref0 (container);
					_source_backlink_unref0 (backlink);
				}
			}
			_g_object_unref0 (backlinks);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	{
		GeeIterator* _container_it = NULL;
		GeeHashMultiMap* _tmp33_;
		GeeSet* _tmp34_;
		GeeSet* _tmp35_;
		GeeIterator* _tmp36_;
		GeeIterator* _tmp37_;
		_tmp33_ = map;
		_tmp34_ = gee_multi_map_get_keys ((GeeMultiMap*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = gee_iterable_iterator ((GeeIterable*) _tmp35_);
		_tmp37_ = _tmp36_;
		_g_object_unref0 (_tmp35_);
		_container_it = _tmp37_;
		while (TRUE) {
			GeeIterator* _tmp38_;
			ContainerSource* container = NULL;
			GeeIterator* _tmp39_;
			gpointer _tmp40_;
			ContainerSource* _tmp41_;
			GeeHashMultiMap* _tmp42_;
			ContainerSource* _tmp43_;
			GeeCollection* _tmp44_;
			GeeCollection* _tmp45_;
			_tmp38_ = _container_it;
			if (!gee_iterator_next (_tmp38_)) {
				break;
			}
			_tmp39_ = _container_it;
			_tmp40_ = gee_iterator_get (_tmp39_);
			container = (ContainerSource*) _tmp40_;
			_tmp41_ = container;
			_tmp42_ = map;
			_tmp43_ = container;
			_tmp44_ = gee_multi_map_get ((GeeMultiMap*) _tmp42_, _tmp43_);
			_tmp45_ = _tmp44_;
			container_source_establish_link_many (_tmp41_, _tmp45_);
			_g_object_unref0 (_tmp45_);
			_g_object_unref0 (container);
		}
		_g_object_unref0 (_container_it);
	}
	container_source_collection_thaw_attached_notifications (self);
	_g_object_unref0 (map);
}

static void
container_source_collection_on_contained_source_destroyed (ContainerSourceCollection* self,
                                                           DataSource* source)
{
	GeeIterator* iter = NULL;
	GeeHashSet* _tmp0_;
	GeeIterator* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->holding_tank;
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GeeIterator* _tmp2_;
		ContainerSource* container = NULL;
		GeeIterator* _tmp3_;
		gpointer _tmp4_;
		gboolean _tmp5_ = FALSE;
		ContainerSource* _tmp6_;
		_tmp2_ = iter;
		if (!gee_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = iter;
		_tmp4_ = gee_iterator_get (_tmp3_);
		container = (ContainerSource*) _tmp4_;
		_tmp6_ = container;
		if (!container_source_has_links (_tmp6_)) {
			ContainerSource* _tmp7_;
			_tmp7_ = container;
			_tmp5_ = !IS_TAG (_tmp7_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			GeeIterator* _tmp8_;
			ContainerSource* _tmp9_;
			_tmp8_ = iter;
			gee_iterator_remove (_tmp8_);
			_tmp9_ = container;
			data_source_destroy_orphan ((DataSource*) _tmp9_, TRUE);
		}
		_g_object_unref0 (container);
	}
	_g_object_unref0 (iter);
}

static void
container_source_collection_real_notify_item_destroyed (SourceCollection* base,
                                                        DataSource* source)
{
	ContainerSourceCollection * self;
	self = (ContainerSourceCollection*) base;
	g_return_if_fail (source != NULL);
	{
		GeeIterator* _collection_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->attached_collections;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_collection_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			SourceCollection* collection = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			SourceCollection* _tmp5_;
			SourceBacklink* _tmp6_;
			SourceBacklink* _tmp7_;
			_tmp2_ = _collection_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _collection_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			collection = (SourceCollection*) _tmp4_;
			_tmp5_ = collection;
			_tmp6_ = container_source_get_backlink (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_CONTAINER_SOURCE, ContainerSource));
			_tmp7_ = _tmp6_;
			source_collection_remove_backlink (_tmp5_, _tmp7_);
			_source_backlink_unref0 (_tmp7_);
			_data_collection_unref0 (collection);
		}
		_g_object_unref0 (_collection_it);
	}
	SOURCE_COLLECTION_CLASS (container_source_collection_parent_class)->notify_item_destroyed ((SourceCollection*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), source);
}

void
container_source_collection_evaporate (ContainerSourceCollection* self,
                                       ContainerSource* container)
{
	Marker* _tmp14_;
	Marker* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	{
		GeeIterator* _collection_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->attached_collections;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_collection_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			SourceCollection* collection = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			SourceCollection* _tmp5_;
			SourceBacklink* _tmp6_;
			SourceBacklink* _tmp7_;
			gboolean _tmp8_;
			_tmp2_ = _collection_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _collection_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			collection = (SourceCollection*) _tmp4_;
			_tmp5_ = collection;
			_tmp6_ = container_source_get_backlink (container);
			_tmp7_ = _tmp6_;
			_tmp8_ = source_collection_has_backlink (_tmp5_, _tmp7_);
			_source_backlink_unref0 (_tmp7_);
			if (_tmp8_) {
				Marker* _tmp9_;
				Marker* _tmp10_;
				GeeCollection* _tmp11_;
				GeeCollection* _tmp12_;
				gboolean added = FALSE;
				GeeHashSet* _tmp13_;
				_tmp9_ = data_collection_mark ((DataCollection*) self, (DataObject*) container);
				_tmp10_ = _tmp9_;
				_tmp11_ = source_collection_unlink_marked ((SourceCollection*) self, _tmp10_, NULL, NULL);
				_tmp12_ = _tmp11_;
				_g_object_unref0 (_tmp12_);
				_g_object_unref0 (_tmp10_);
				_tmp13_ = self->priv->holding_tank;
				added = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, container);
				_vala_assert (added, "added");
				_data_collection_unref0 (collection);
				_g_object_unref0 (_collection_it);
				return;
			}
			_data_collection_unref0 (collection);
		}
		_g_object_unref0 (_collection_it);
	}
	_tmp14_ = data_collection_mark ((DataCollection*) self, (DataObject*) container);
	_tmp15_ = _tmp14_;
	source_collection_destroy_marked ((SourceCollection*) self, _tmp15_, TRUE, NULL, NULL, NULL);
	_g_object_unref0 (_tmp15_);
}

static void
_container_source_collection_on_contained_sources_unlinking_source_collection_items_unlinking (SourceCollection* _sender,
                                                                                               GeeCollection* unlinking,
                                                                                               gpointer self)
{
	container_source_collection_on_contained_sources_unlinking ((ContainerSourceCollection*) self, unlinking);
}

static void
_container_source_collection_on_contained_sources_relinked_source_collection_items_relinked (SourceCollection* _sender,
                                                                                             GeeCollection* relinked,
                                                                                             gpointer self)
{
	container_source_collection_on_contained_sources_relinked ((ContainerSourceCollection*) self, relinked);
}

static void
_container_source_collection_on_contained_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                                             DataSource* source,
                                                                                             gpointer self)
{
	container_source_collection_on_contained_source_destroyed ((ContainerSourceCollection*) self, source);
}

static void
_container_source_collection_on_contained_source_destroyed_source_collection_unlinked_destroyed (SourceCollection* _sender,
                                                                                                 DataSource* source,
                                                                                                 gpointer self)
{
	container_source_collection_on_contained_source_destroyed ((ContainerSourceCollection*) self, source);
}

void
container_source_collection_attach_collection (ContainerSourceCollection* self,
                                               SourceCollection* collection)
{
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->priv->attached_collections;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, collection)) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = data_collection_to_string ((DataCollection*) collection);
		_tmp2_ = _tmp1_;
		_tmp3_ = data_collection_to_string ((DataCollection*) self);
		_tmp4_ = _tmp3_;
		g_warning ("ContainerSourceCollection.vala:227: attempted to multiple-attach '%s' " \
"to '%s'", _tmp2_, _tmp4_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		return;
	}
	_tmp5_ = self->priv->attached_collections;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, collection);
	g_signal_connect (collection, "items-unlinking", (GCallback) _container_source_collection_on_contained_sources_unlinking_source_collection_items_unlinking, self);
	g_signal_connect (collection, "items-relinked", (GCallback) _container_source_collection_on_contained_sources_relinked_source_collection_items_relinked, self);
	g_signal_connect (collection, "item-destroyed", (GCallback) _container_source_collection_on_contained_source_destroyed_source_collection_item_destroyed, self);
	g_signal_connect (collection, "unlinked-destroyed", (GCallback) _container_source_collection_on_contained_source_destroyed_source_collection_unlinked_destroyed, self);
}

void
container_source_collection_detach_all_collections (ContainerSourceCollection* self)
{
	GeeHashSet* _tmp13_;
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _collection_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->attached_collections;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
		_collection_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			SourceCollection* collection = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			SourceCollection* _tmp5_;
			guint _tmp6_;
			SourceCollection* _tmp7_;
			guint _tmp8_;
			SourceCollection* _tmp9_;
			guint _tmp10_;
			SourceCollection* _tmp11_;
			guint _tmp12_;
			_tmp2_ = _collection_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _collection_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			collection = (SourceCollection*) _tmp4_;
			_tmp5_ = collection;
			g_signal_parse_name ("items-unlinking", TYPE_SOURCE_COLLECTION, &_tmp6_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _container_source_collection_on_contained_sources_unlinking_source_collection_items_unlinking, self);
			_tmp7_ = collection;
			g_signal_parse_name ("items-relinked", TYPE_SOURCE_COLLECTION, &_tmp8_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _container_source_collection_on_contained_sources_relinked_source_collection_items_relinked, self);
			_tmp9_ = collection;
			g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp10_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _container_source_collection_on_contained_source_destroyed_source_collection_item_destroyed, self);
			_tmp11_ = collection;
			g_signal_parse_name ("unlinked-destroyed", TYPE_SOURCE_COLLECTION, &_tmp12_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _container_source_collection_on_contained_source_destroyed_source_collection_unlinked_destroyed, self);
			_data_collection_unref0 (collection);
		}
		_g_object_unref0 (_collection_it);
	}
	_tmp13_ = self->priv->attached_collections;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp13_);
}

static void
container_source_collection_real_container_contents_added (ContainerSourceCollection* self,
                                                           ContainerSource* container,
                                                           GeeCollection* added,
                                                           gboolean relinked)
{
	g_return_if_fail (container != NULL);
	g_return_if_fail (added != NULL);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOOLEAN (GClosure * closure,
                                                     GValue * return_value,
                                                     guint n_param_values,
                                                     const GValue * param_values,
                                                     gpointer invocation_hint,
                                                     gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_BOOLEAN) (gpointer data1, gpointer arg_1, gpointer arg_2, gboolean arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_boolean (param_values + 3), data2);
}

static void
container_source_collection_real_container_contents_removed (ContainerSourceCollection* self,
                                                             ContainerSource* container,
                                                             GeeCollection* removed,
                                                             gboolean unlinked)
{
	g_return_if_fail (container != NULL);
	g_return_if_fail (removed != NULL);
}

static void
container_source_collection_real_container_contents_altered (ContainerSourceCollection* self,
                                                             ContainerSource* container,
                                                             GeeCollection* added,
                                                             gboolean relinked,
                                                             GeeCollection* removed,
                                                             gboolean unlinked)
{
	g_return_if_fail (container != NULL);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOOLEAN_OBJECT_BOOLEAN (GClosure * closure,
                                                                    GValue * return_value,
                                                                    guint n_param_values,
                                                                    const GValue * param_values,
                                                                    gpointer invocation_hint,
                                                                    gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_BOOLEAN_OBJECT_BOOLEAN) (gpointer data1, gpointer arg_1, gpointer arg_2, gboolean arg_3, gpointer arg_4, gboolean arg_5, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_BOOLEAN_OBJECT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_BOOLEAN_OBJECT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_boolean (param_values + 3), g_value_get_object (param_values + 4), g_value_get_boolean (param_values + 5), data2);
}

static void
container_source_collection_real_backlink_to_container_removed (ContainerSourceCollection* self,
                                                                ContainerSource* container,
                                                                GeeCollection* sources)
{
	g_return_if_fail (container != NULL);
	g_return_if_fail (sources != NULL);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
container_source_collection_class_init (ContainerSourceCollectionClass * klass,
                                        gpointer klass_data)
{
	container_source_collection_parent_class = g_type_class_peek_parent (klass);
	((DataCollectionClass *) klass)->finalize = container_source_collection_finalize;
	g_type_class_adjust_private_offset (klass, &ContainerSourceCollection_private_offset);
	((SourceCollectionClass *) klass)->notify_backlink_removed = (void (*) (SourceCollection*, SourceBacklink*, GeeCollection*)) container_source_collection_real_notify_backlink_removed;
	((ContainerSourceCollectionClass *) klass)->notify_container_contents_added = (void (*) (ContainerSourceCollection*, ContainerSource*, GeeCollection*, gboolean)) container_source_collection_real_notify_container_contents_added;
	((ContainerSourceCollectionClass *) klass)->notify_container_contents_removed = (void (*) (ContainerSourceCollection*, ContainerSource*, GeeCollection*, gboolean)) container_source_collection_real_notify_container_contents_removed;
	((ContainerSourceCollectionClass *) klass)->notify_container_contents_altered = (void (*) (ContainerSourceCollection*, ContainerSource*, GeeCollection*, gboolean, GeeCollection*, gboolean)) container_source_collection_real_notify_container_contents_altered;
	((ContainerSourceCollectionClass *) klass)->notify_backlink_to_container_removed = (void (*) (ContainerSourceCollection*, ContainerSource*, GeeCollection*)) container_source_collection_real_notify_backlink_to_container_removed;
	((ContainerSourceCollectionClass *) klass)->get_containers_holding_source = (GeeCollection* (*) (ContainerSourceCollection*, DataSource*)) container_source_collection_real_get_containers_holding_source;
	((ContainerSourceCollectionClass *) klass)->convert_backlink_to_container = (ContainerSource* (*) (ContainerSourceCollection*, SourceBacklink*)) container_source_collection_real_convert_backlink_to_container;
	((SourceCollectionClass *) klass)->notify_item_destroyed = (void (*) (SourceCollection*, DataSource*)) container_source_collection_real_notify_item_destroyed;
	((ContainerSourceCollectionClass *) klass)->container_contents_added = container_source_collection_real_container_contents_added;
	((ContainerSourceCollectionClass *) klass)->container_contents_removed = container_source_collection_real_container_contents_removed;
	((ContainerSourceCollectionClass *) klass)->container_contents_altered = container_source_collection_real_container_contents_altered;
	((ContainerSourceCollectionClass *) klass)->backlink_to_container_removed = container_source_collection_real_backlink_to_container_removed;
	container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_ADDED_SIGNAL] = g_signal_new ("container-contents-added", TYPE_CONTAINER_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ContainerSourceCollectionClass, container_contents_added), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOOLEAN, G_TYPE_NONE, 3, TYPE_CONTAINER_SOURCE, GEE_TYPE_COLLECTION, G_TYPE_BOOLEAN);
	container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_REMOVED_SIGNAL] = g_signal_new ("container-contents-removed", TYPE_CONTAINER_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ContainerSourceCollectionClass, container_contents_removed), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOOLEAN, G_TYPE_NONE, 3, TYPE_CONTAINER_SOURCE, GEE_TYPE_COLLECTION, G_TYPE_BOOLEAN);
	container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_ALTERED_SIGNAL] = g_signal_new ("container-contents-altered", TYPE_CONTAINER_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ContainerSourceCollectionClass, container_contents_altered), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOOLEAN_OBJECT_BOOLEAN, G_TYPE_NONE, 5, TYPE_CONTAINER_SOURCE, GEE_TYPE_COLLECTION, G_TYPE_BOOLEAN, GEE_TYPE_COLLECTION, G_TYPE_BOOLEAN);
	container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_BACKLINK_TO_CONTAINER_REMOVED_SIGNAL] = g_signal_new ("backlink-to-container-removed", TYPE_CONTAINER_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ContainerSourceCollectionClass, backlink_to_container_removed), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, TYPE_CONTAINER_SOURCE, GEE_TYPE_COLLECTION);
}

static void
container_source_collection_instance_init (ContainerSourceCollection * self,
                                           gpointer klass)
{
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	self->priv = container_source_collection_get_instance_private (self);
	_tmp0_ = gee_hash_set_new (TYPE_SOURCE_COLLECTION, (GBoxedCopyFunc) data_collection_ref, (GDestroyNotify) data_collection_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->attached_collections = _tmp0_;
	_tmp1_ = gee_hash_set_new (TYPE_CONTAINER_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->holding_tank = _tmp1_;
}

static void
container_source_collection_finalize (DataCollection * obj)
{
	ContainerSourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection);
	container_source_collection_detach_all_collections (self);
	_g_object_unref0 (self->priv->attached_collections);
	_g_free0 (self->priv->backlink_name);
	_g_object_unref0 (self->priv->holding_tank);
	DATA_COLLECTION_CLASS (container_source_collection_parent_class)->finalize (obj);
}

static GType
container_source_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContainerSourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) container_source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContainerSourceCollection), 0, (GInstanceInitFunc) container_source_collection_instance_init, NULL };
	GType container_source_collection_type_id;
	container_source_collection_type_id = g_type_register_static (TYPE_DATABASE_SOURCE_COLLECTION, "ContainerSourceCollection", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	ContainerSourceCollection_private_offset = g_type_add_instance_private (container_source_collection_type_id, sizeof (ContainerSourceCollectionPrivate));
	return container_source_collection_type_id;
}

GType
container_source_collection_get_type (void)
{
	static volatile gsize container_source_collection_type_id__once = 0;
	if (g_once_init_enter (&container_source_collection_type_id__once)) {
		GType container_source_collection_type_id;
		container_source_collection_type_id = container_source_collection_get_type_once ();
		g_once_init_leave (&container_source_collection_type_id__once, container_source_collection_type_id);
	}
	return container_source_collection_type_id__once;
}

