/* PhotoFileSniffer.c generated by valac 0.56.18, the Vala compiler
 * generated from PhotoFileSniffer.vala, do not modify */

/*
* Copyright (c) 2010-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>
#include <gio/gio.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecDetectedPhotoInformation ParamSpecDetectedPhotoInformation;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecPhotoFileSniffer ParamSpecPhotoFileSniffer;
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
#define _photo_file_sniffer_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_sniffer_unref (var), NULL)))
typedef struct _ParamSpecPhotoFileInterrogator ParamSpecPhotoFileInterrogator;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ParamSpecDetectedPhotoInformation {
	GParamSpec parent_instance;
};

struct _ParamSpecPhotoFileSniffer {
	GParamSpec parent_instance;
};

struct _PhotoFileInterrogatorPrivate {
	GFile* file;
	PhotoFileSnifferOptions options;
	DetectedPhotoInformation* detected;
};

struct _ParamSpecPhotoFileInterrogator {
	GParamSpec parent_instance;
};

static gpointer detected_photo_information_parent_class = NULL;
static gpointer photo_file_sniffer_parent_class = NULL;
static gint PhotoFileInterrogator_private_offset;
static gpointer photo_file_interrogator_parent_class = NULL;

static void detected_photo_information_finalize (DetectedPhotoInformation * obj);
static GType detected_photo_information_get_type_once (void);
static DetectedPhotoInformation* photo_file_sniffer_real_sniff (PhotoFileSniffer* self,
                                                         GError** error);
static void photo_file_sniffer_finalize (PhotoFileSniffer * obj);
static GType photo_file_sniffer_get_type_once (void);
static void photo_file_interrogator_finalize (PhotoFileInterrogator * obj);
static GType photo_file_interrogator_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

DetectedPhotoInformation*
detected_photo_information_construct (GType object_type)
{
	DetectedPhotoInformation* self = NULL;
	self = (DetectedPhotoInformation*) g_type_create_instance (object_type);
	return self;
}

DetectedPhotoInformation*
detected_photo_information_new (void)
{
	return detected_photo_information_construct (TYPE_DETECTED_PHOTO_INFORMATION);
}

static void
value_detected_photo_information_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_detected_photo_information_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		detected_photo_information_unref (value->data[0].v_pointer);
	}
}

static void
value_detected_photo_information_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = detected_photo_information_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_detected_photo_information_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_detected_photo_information_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		DetectedPhotoInformation * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = detected_photo_information_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_detected_photo_information_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	DetectedPhotoInformation ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = detected_photo_information_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_detected_photo_information (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	ParamSpecDetectedPhotoInformation* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DETECTED_PHOTO_INFORMATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_detected_photo_information (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DETECTED_PHOTO_INFORMATION), NULL);
	return value->data[0].v_pointer;
}

void
value_set_detected_photo_information (GValue* value,
                                      gpointer v_object)
{
	DetectedPhotoInformation * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DETECTED_PHOTO_INFORMATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DETECTED_PHOTO_INFORMATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		detected_photo_information_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		detected_photo_information_unref (old);
	}
}

void
value_take_detected_photo_information (GValue* value,
                                       gpointer v_object)
{
	DetectedPhotoInformation * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DETECTED_PHOTO_INFORMATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DETECTED_PHOTO_INFORMATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		detected_photo_information_unref (old);
	}
}

static void
detected_photo_information_class_init (DetectedPhotoInformationClass * klass,
                                       gpointer klass_data)
{
	detected_photo_information_parent_class = g_type_class_peek_parent (klass);
	((DetectedPhotoInformationClass *) klass)->finalize = detected_photo_information_finalize;
}

static void
detected_photo_information_instance_init (DetectedPhotoInformation * self,
                                          gpointer klass)
{
	self->file_format = PHOTO_FILE_FORMAT_UNKNOWN;
	self->metadata = NULL;
	self->md5 = NULL;
	self->exif_md5 = NULL;
	self->thumbnail_md5 = NULL;
	self->format_name = NULL;
	dimensions_init (&self->image_dim, 0, 0);
	self->colorspace = GDK_COLORSPACE_RGB;
	self->channels = 0;
	self->bits_per_channel = 0;
	self->ref_count = 1;
}

static void
detected_photo_information_finalize (DetectedPhotoInformation * obj)
{
	DetectedPhotoInformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformation);
	g_signal_handlers_destroy (self);
	_media_metadata_unref0 (self->metadata);
	_g_free0 (self->md5);
	_g_free0 (self->exif_md5);
	_g_free0 (self->thumbnail_md5);
	_g_free0 (self->format_name);
}

static GType
detected_photo_information_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_detected_photo_information_init, value_detected_photo_information_free_value, value_detected_photo_information_copy_value, value_detected_photo_information_peek_pointer, "p", value_detected_photo_information_collect_value, "p", value_detected_photo_information_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (DetectedPhotoInformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) detected_photo_information_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DetectedPhotoInformation), 0, (GInstanceInitFunc) detected_photo_information_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType detected_photo_information_type_id;
	detected_photo_information_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DetectedPhotoInformation", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return detected_photo_information_type_id;
}

GType
detected_photo_information_get_type (void)
{
	static volatile gsize detected_photo_information_type_id__once = 0;
	if (g_once_init_enter (&detected_photo_information_type_id__once)) {
		GType detected_photo_information_type_id;
		detected_photo_information_type_id = detected_photo_information_get_type_once ();
		g_once_init_leave (&detected_photo_information_type_id__once, detected_photo_information_type_id);
	}
	return detected_photo_information_type_id__once;
}

gpointer
detected_photo_information_ref (gpointer instance)
{
	DetectedPhotoInformation * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
detected_photo_information_unref (gpointer instance)
{
	DetectedPhotoInformation * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DETECTED_PHOTO_INFORMATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static GType
photo_file_sniffer_options_get_type_once (void)
{
	static const GEnumValue values[] = {{PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL, "PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL", "get-all"}, {PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5, "PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5", "no-md5"}, {0, NULL, NULL}};
	GType photo_file_sniffer_options_type_id;
	photo_file_sniffer_options_type_id = g_enum_register_static ("PhotoFileSnifferOptions", values);
	return photo_file_sniffer_options_type_id;
}

GType
photo_file_sniffer_options_get_type (void)
{
	static volatile gsize photo_file_sniffer_options_type_id__once = 0;
	if (g_once_init_enter (&photo_file_sniffer_options_type_id__once)) {
		GType photo_file_sniffer_options_type_id;
		photo_file_sniffer_options_type_id = photo_file_sniffer_options_get_type_once ();
		g_once_init_leave (&photo_file_sniffer_options_type_id__once, photo_file_sniffer_options_type_id);
	}
	return photo_file_sniffer_options_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

PhotoFileSniffer*
photo_file_sniffer_construct (GType object_type,
                              GFile* file,
                              PhotoFileSnifferOptions options)
{
	PhotoFileSniffer* self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (PhotoFileSniffer*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->file);
	self->file = _tmp0_;
	self->options = options;
	self->calc_md5 = (options & PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5) == 0;
	return self;
}

static DetectedPhotoInformation*
photo_file_sniffer_real_sniff (PhotoFileSniffer* self,
                               GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `photo_file_sniffer_sniff'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

DetectedPhotoInformation*
photo_file_sniffer_sniff (PhotoFileSniffer* self,
                          GError** error)
{
	PhotoFileSnifferClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PHOTO_FILE_SNIFFER_GET_CLASS (self);
	if (_klass_->sniff) {
		return _klass_->sniff (self, error);
	}
	return NULL;
}

static void
value_photo_file_sniffer_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_photo_file_sniffer_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		photo_file_sniffer_unref (value->data[0].v_pointer);
	}
}

static void
value_photo_file_sniffer_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = photo_file_sniffer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_photo_file_sniffer_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_photo_file_sniffer_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PhotoFileSniffer * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = photo_file_sniffer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_photo_file_sniffer_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	PhotoFileSniffer ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = photo_file_sniffer_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_photo_file_sniffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	ParamSpecPhotoFileSniffer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_FILE_SNIFFER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_photo_file_sniffer (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_SNIFFER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_photo_file_sniffer (GValue* value,
                              gpointer v_object)
{
	PhotoFileSniffer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_SNIFFER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_SNIFFER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		photo_file_sniffer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_file_sniffer_unref (old);
	}
}

void
value_take_photo_file_sniffer (GValue* value,
                               gpointer v_object)
{
	PhotoFileSniffer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_SNIFFER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_SNIFFER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_file_sniffer_unref (old);
	}
}

static void
photo_file_sniffer_class_init (PhotoFileSnifferClass * klass,
                               gpointer klass_data)
{
	photo_file_sniffer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileSnifferClass *) klass)->finalize = photo_file_sniffer_finalize;
	((PhotoFileSnifferClass *) klass)->sniff = (DetectedPhotoInformation* (*) (PhotoFileSniffer*, GError**)) photo_file_sniffer_real_sniff;
}

static void
photo_file_sniffer_instance_init (PhotoFileSniffer * self,
                                  gpointer klass)
{
	self->ref_count = 1;
}

static void
photo_file_sniffer_finalize (PhotoFileSniffer * obj)
{
	PhotoFileSniffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->file);
}

static GType
photo_file_sniffer_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_photo_file_sniffer_init, value_photo_file_sniffer_free_value, value_photo_file_sniffer_copy_value, value_photo_file_sniffer_peek_pointer, "p", value_photo_file_sniffer_collect_value, "p", value_photo_file_sniffer_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PhotoFileSnifferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_file_sniffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoFileSniffer), 0, (GInstanceInitFunc) photo_file_sniffer_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType photo_file_sniffer_type_id;
	photo_file_sniffer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoFileSniffer", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return photo_file_sniffer_type_id;
}

GType
photo_file_sniffer_get_type (void)
{
	static volatile gsize photo_file_sniffer_type_id__once = 0;
	if (g_once_init_enter (&photo_file_sniffer_type_id__once)) {
		GType photo_file_sniffer_type_id;
		photo_file_sniffer_type_id = photo_file_sniffer_get_type_once ();
		g_once_init_leave (&photo_file_sniffer_type_id__once, photo_file_sniffer_type_id);
	}
	return photo_file_sniffer_type_id__once;
}

gpointer
photo_file_sniffer_ref (gpointer instance)
{
	PhotoFileSniffer * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
photo_file_sniffer_unref (gpointer instance)
{
	PhotoFileSniffer * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PHOTO_FILE_SNIFFER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
photo_file_interrogator_get_instance_private (PhotoFileInterrogator* self)
{
	return G_STRUCT_MEMBER_P (self, PhotoFileInterrogator_private_offset);
}

PhotoFileInterrogator*
photo_file_interrogator_construct (GType object_type,
                                   GFile* file,
                                   PhotoFileSnifferOptions options)
{
	PhotoFileInterrogator* self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (PhotoFileInterrogator*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	self->priv->options = options;
	return self;
}

PhotoFileInterrogator*
photo_file_interrogator_new (GFile* file,
                             PhotoFileSnifferOptions options)
{
	return photo_file_interrogator_construct (TYPE_PHOTO_FILE_INTERROGATOR, file, options);
}

static gpointer
_detected_photo_information_ref0 (gpointer self)
{
	return self ? detected_photo_information_ref (self) : NULL;
}

DetectedPhotoInformation*
photo_file_interrogator_get_detected_photo_information (PhotoFileInterrogator* self)
{
	DetectedPhotoInformation* _tmp0_;
	DetectedPhotoInformation* _tmp1_;
	DetectedPhotoInformation* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->detected;
	_tmp1_ = _detected_photo_information_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
photo_file_interrogator_interrogate (PhotoFileInterrogator* self,
                                     GError** error)
{
	gint _tmp0_ = 0;
	PhotoFileFormat* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = photo_file_format_get_supported (&_tmp0_);
	{
		PhotoFileFormat* file_format_collection = NULL;
		gint file_format_collection_length1 = 0;
		gint _file_format_collection_size_ = 0;
		gint file_format_it = 0;
		file_format_collection = _tmp1_;
		file_format_collection_length1 = _tmp0_;
		for (file_format_it = 0; file_format_it < file_format_collection_length1; file_format_it = file_format_it + 1) {
			PhotoFileFormat file_format = 0;
			file_format = file_format_collection[file_format_it];
			{
				PhotoFileSniffer* sniffer = NULL;
				GFile* _tmp2_;
				PhotoFileSniffer* _tmp3_;
				DetectedPhotoInformation* _tmp4_ = NULL;
				PhotoFileSniffer* _tmp5_;
				DetectedPhotoInformation* _tmp6_;
				DetectedPhotoInformation* _tmp7_;
				DetectedPhotoInformation* _tmp8_;
				_tmp2_ = self->priv->file;
				_tmp3_ = photo_file_format_create_sniffer (file_format, _tmp2_, self->priv->options);
				sniffer = _tmp3_;
				_tmp5_ = sniffer;
				_tmp6_ = photo_file_sniffer_sniff (_tmp5_, &_inner_error0_);
				_tmp4_ = _tmp6_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_photo_file_sniffer_unref0 (sniffer);
					file_format_collection = (g_free (file_format_collection), NULL);
					return;
				}
				_tmp7_ = _tmp4_;
				_tmp4_ = NULL;
				_detected_photo_information_unref0 (self->priv->detected);
				self->priv->detected = _tmp7_;
				_tmp8_ = self->priv->detected;
				if (_tmp8_ != NULL) {
					DetectedPhotoInformation* _tmp9_;
					_tmp9_ = self->priv->detected;
					_vala_assert (_tmp9_->file_format == file_format, "detected.file_format == file_format");
					_detected_photo_information_unref0 (_tmp4_);
					_photo_file_sniffer_unref0 (sniffer);
					break;
				}
				_detected_photo_information_unref0 (_tmp4_);
				_photo_file_sniffer_unref0 (sniffer);
			}
		}
		file_format_collection = (g_free (file_format_collection), NULL);
	}
}

static void
value_photo_file_interrogator_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_photo_file_interrogator_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		photo_file_interrogator_unref (value->data[0].v_pointer);
	}
}

static void
value_photo_file_interrogator_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = photo_file_interrogator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_photo_file_interrogator_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_photo_file_interrogator_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PhotoFileInterrogator * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = photo_file_interrogator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_photo_file_interrogator_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	PhotoFileInterrogator ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = photo_file_interrogator_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_photo_file_interrogator (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	ParamSpecPhotoFileInterrogator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_FILE_INTERROGATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_photo_file_interrogator (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_INTERROGATOR), NULL);
	return value->data[0].v_pointer;
}

void
value_set_photo_file_interrogator (GValue* value,
                                   gpointer v_object)
{
	PhotoFileInterrogator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_INTERROGATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_INTERROGATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		photo_file_interrogator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_file_interrogator_unref (old);
	}
}

void
value_take_photo_file_interrogator (GValue* value,
                                    gpointer v_object)
{
	PhotoFileInterrogator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_INTERROGATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_INTERROGATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_file_interrogator_unref (old);
	}
}

static void
photo_file_interrogator_class_init (PhotoFileInterrogatorClass * klass,
                                    gpointer klass_data)
{
	photo_file_interrogator_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileInterrogatorClass *) klass)->finalize = photo_file_interrogator_finalize;
	g_type_class_adjust_private_offset (klass, &PhotoFileInterrogator_private_offset);
}

static void
photo_file_interrogator_instance_init (PhotoFileInterrogator * self,
                                       gpointer klass)
{
	self->priv = photo_file_interrogator_get_instance_private (self);
	self->priv->detected = NULL;
	self->ref_count = 1;
}

static void
photo_file_interrogator_finalize (PhotoFileInterrogator * obj)
{
	PhotoFileInterrogator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_FILE_INTERROGATOR, PhotoFileInterrogator);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->file);
	_detected_photo_information_unref0 (self->priv->detected);
}

static GType
photo_file_interrogator_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_photo_file_interrogator_init, value_photo_file_interrogator_free_value, value_photo_file_interrogator_copy_value, value_photo_file_interrogator_peek_pointer, "p", value_photo_file_interrogator_collect_value, "p", value_photo_file_interrogator_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PhotoFileInterrogatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_file_interrogator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoFileInterrogator), 0, (GInstanceInitFunc) photo_file_interrogator_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType photo_file_interrogator_type_id;
	photo_file_interrogator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoFileInterrogator", &g_define_type_info, &g_define_type_fundamental_info, 0);
	PhotoFileInterrogator_private_offset = g_type_add_instance_private (photo_file_interrogator_type_id, sizeof (PhotoFileInterrogatorPrivate));
	return photo_file_interrogator_type_id;
}

GType
photo_file_interrogator_get_type (void)
{
	static volatile gsize photo_file_interrogator_type_id__once = 0;
	if (g_once_init_enter (&photo_file_interrogator_type_id__once)) {
		GType photo_file_interrogator_type_id;
		photo_file_interrogator_type_id = photo_file_interrogator_get_type_once ();
		g_once_init_leave (&photo_file_interrogator_type_id__once, photo_file_interrogator_type_id);
	}
	return photo_file_interrogator_type_id__once;
}

gpointer
photo_file_interrogator_ref (gpointer instance)
{
	PhotoFileInterrogator * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
photo_file_interrogator_unref (gpointer instance)
{
	PhotoFileInterrogator * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PHOTO_FILE_INTERROGATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

