/* ScheduledTaskListBox.c generated by valac 0.56.17, the Vala compiler
 * generated from ScheduledTaskListBox.vala, do not modify */

/*
 * Copyright 2019-2023 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gee.h>
#include <libedataserver/libedataserver.h>
#include <libecal/libecal.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <libical-glib/libical-glib.h>
#include <granite.h>
#include <pango/pango.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#define TASKS_WIDGETS_SCHEDULED_TASK_LIST_BOX_QUERY "AND (NOT is-completed?) (has-start?)"
#define TASKS_MAIN_WINDOW_ACTION_GROUP_PREFIX "win"
#define TASKS_MAIN_WINDOW_ACTION_DELETE_SELECTED_LIST "action-delete-selected-list"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TASKS_WIDGETS_TYPE_SCHEDULED_TASK_LIST_BOX (tasks_widgets_scheduled_task_list_box_get_type ())
#define TASKS_WIDGETS_SCHEDULED_TASK_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_WIDGETS_TYPE_SCHEDULED_TASK_LIST_BOX, TasksWidgetsScheduledTaskListBox))
#define TASKS_WIDGETS_SCHEDULED_TASK_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_WIDGETS_TYPE_SCHEDULED_TASK_LIST_BOX, TasksWidgetsScheduledTaskListBoxClass))
#define TASKS_WIDGETS_IS_SCHEDULED_TASK_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_WIDGETS_TYPE_SCHEDULED_TASK_LIST_BOX))
#define TASKS_WIDGETS_IS_SCHEDULED_TASK_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_WIDGETS_TYPE_SCHEDULED_TASK_LIST_BOX))
#define TASKS_WIDGETS_SCHEDULED_TASK_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_WIDGETS_TYPE_SCHEDULED_TASK_LIST_BOX, TasksWidgetsScheduledTaskListBoxClass))

typedef struct _TasksWidgetsScheduledTaskListBox TasksWidgetsScheduledTaskListBox;
typedef struct _TasksWidgetsScheduledTaskListBoxClass TasksWidgetsScheduledTaskListBoxClass;
typedef struct _TasksWidgetsScheduledTaskListBoxPrivate TasksWidgetsScheduledTaskListBoxPrivate;

#define TASKS_TYPE_TASK_MODEL (tasks_task_model_get_type ())
#define TASKS_TASK_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_TYPE_TASK_MODEL, TasksTaskModel))
#define TASKS_TASK_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_TYPE_TASK_MODEL, TasksTaskModelClass))
#define TASKS_IS_TASK_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_TYPE_TASK_MODEL))
#define TASKS_IS_TASK_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_TYPE_TASK_MODEL))
#define TASKS_TASK_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_TYPE_TASK_MODEL, TasksTaskModelClass))

typedef struct _TasksTaskModel TasksTaskModel;
typedef struct _TasksTaskModelClass TasksTaskModelClass;
enum  {
	TASKS_WIDGETS_SCHEDULED_TASK_LIST_BOX_0_PROPERTY,
	TASKS_WIDGETS_SCHEDULED_TASK_LIST_BOX_MODEL_PROPERTY,
	TASKS_WIDGETS_SCHEDULED_TASK_LIST_BOX_NUM_PROPERTIES
};
static GParamSpec* tasks_widgets_scheduled_task_list_box_properties[TASKS_WIDGETS_SCHEDULED_TASK_LIST_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef void (*TasksTaskModelTasksAddedFunc) (GeeCollection* tasks, ESource* task_list, gpointer user_data);
typedef void (*TasksTaskModelTasksModifiedFunc) (GeeCollection* tasks, gpointer user_data);
typedef void (*TasksTaskModelTasksRemovedFunc) (GSList* cids, gpointer user_data);
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TASKS_WIDGETS_TYPE_TASK_ROW (tasks_widgets_task_row_get_type ())
#define TASKS_WIDGETS_TASK_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_WIDGETS_TYPE_TASK_ROW, TasksWidgetsTaskRow))
#define TASKS_WIDGETS_TASK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_WIDGETS_TYPE_TASK_ROW, TasksWidgetsTaskRowClass))
#define TASKS_WIDGETS_IS_TASK_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_WIDGETS_TYPE_TASK_ROW))
#define TASKS_WIDGETS_IS_TASK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_WIDGETS_TYPE_TASK_ROW))
#define TASKS_WIDGETS_TASK_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_WIDGETS_TYPE_TASK_ROW, TasksWidgetsTaskRowClass))

typedef struct _TasksWidgetsTaskRow TasksWidgetsTaskRow;
typedef struct _TasksWidgetsTaskRowClass TasksWidgetsTaskRowClass;
#define __vala_ECalComponentDateTime_free0(var) ((var == NULL) ? NULL : (var = (_vala_ECalComponentDateTime_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block14Data Block14Data;
typedef struct _Block15Data Block15Data;
typedef struct _Block16Data Block16Data;
typedef struct _Block17Data Block17Data;

struct _TasksWidgetsScheduledTaskListBox {
	GtkBox parent_instance;
	TasksWidgetsScheduledTaskListBoxPrivate * priv;
};

struct _TasksWidgetsScheduledTaskListBoxClass {
	GtkBoxClass parent_class;
};

struct _TasksWidgetsScheduledTaskListBoxPrivate {
	GeeMap* views;
	GRecMutex __lock_views;
	TasksTaskModel* _model;
	GtkLabel* scheduled_title;
	GtkListBox* task_list;
};

struct _Block14Data {
	int _ref_count_;
	TasksWidgetsScheduledTaskListBox* self;
	ESource* source;
};

struct _Block15Data {
	int _ref_count_;
	TasksWidgetsScheduledTaskListBox* self;
	GAsyncResult* res;
};

struct _Block16Data {
	int _ref_count_;
	TasksWidgetsScheduledTaskListBox* self;
	GAsyncResult* res;
};

struct _Block17Data {
	int _ref_count_;
	TasksWidgetsScheduledTaskListBox* self;
	GAsyncResult* res;
};

static gint TasksWidgetsScheduledTaskListBox_private_offset;
static gpointer tasks_widgets_scheduled_task_list_box_parent_class = NULL;
VALA_EXTERN TasksTaskModel* tasks_application_model;

VALA_EXTERN GType tasks_widgets_scheduled_task_list_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksWidgetsScheduledTaskListBox, g_object_unref)
VALA_EXTERN GType tasks_task_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksTaskModel, g_object_unref)
static void tasks_widgets_scheduled_task_list_box_add_view (TasksWidgetsScheduledTaskListBox* self,
                                                     ESource* source,
                                                     const gchar* query);
VALA_EXTERN TasksTaskModel* tasks_widgets_scheduled_task_list_box_get_model (TasksWidgetsScheduledTaskListBox* self);
VALA_EXTERN ECalClientView* tasks_task_model_create_task_list_view (TasksTaskModel* self,
                                                        ESource* task_list,
                                                        const gchar* query,
                                                        TasksTaskModelTasksAddedFunc on_tasks_added,
                                                        gpointer on_tasks_added_target,
                                                        TasksTaskModelTasksModifiedFunc on_tasks_modified,
                                                        gpointer on_tasks_modified_target,
                                                        TasksTaskModelTasksRemovedFunc on_tasks_removed,
                                                        gpointer on_tasks_removed_target,
                                                        GError** error);
static void tasks_widgets_scheduled_task_list_box_on_tasks_added (TasksWidgetsScheduledTaskListBox* self,
                                                           GeeCollection* tasks,
                                                           ESource* source);
static void _tasks_widgets_scheduled_task_list_box_on_tasks_added_tasks_task_model_tasks_added_func (GeeCollection* tasks,
                                                                                              ESource* task_list,
                                                                                              gpointer self);
static void tasks_widgets_scheduled_task_list_box_on_tasks_modified (TasksWidgetsScheduledTaskListBox* self,
                                                              GeeCollection* tasks);
static void _tasks_widgets_scheduled_task_list_box_on_tasks_modified_tasks_task_model_tasks_modified_func (GeeCollection* tasks,
                                                                                                    gpointer self);
static void tasks_widgets_scheduled_task_list_box_on_tasks_removed (TasksWidgetsScheduledTaskListBox* self,
                                                             GSList* cids);
static void _tasks_widgets_scheduled_task_list_box_on_tasks_removed_tasks_task_model_tasks_removed_func (GSList* cids,
                                                                                                  gpointer self);
static void tasks_widgets_scheduled_task_list_box_remove_view (TasksWidgetsScheduledTaskListBox* self,
                                                        ESource* source);
VALA_EXTERN GType tasks_widgets_task_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksWidgetsTaskRow, g_object_unref)
VALA_EXTERN ESource* tasks_widgets_task_row_get_source (TasksWidgetsTaskRow* self);
VALA_EXTERN void tasks_task_model_destroy_task_list_view (TasksTaskModel* self,
                                              ECalClientView* view);
VALA_EXTERN TasksWidgetsScheduledTaskListBox* tasks_widgets_scheduled_task_list_box_new (TasksTaskModel* model);
VALA_EXTERN TasksWidgetsScheduledTaskListBox* tasks_widgets_scheduled_task_list_box_construct (GType object_type,
                                                                                   TasksTaskModel* model);
static void tasks_widgets_scheduled_task_list_box_add_task_list (TasksWidgetsScheduledTaskListBox* self,
                                                          ESource* task_list);
static void tasks_widgets_scheduled_task_list_box_modify_task_list (TasksWidgetsScheduledTaskListBox* self,
                                                             ESource* task_list);
static void tasks_widgets_scheduled_task_list_box_remove_task_list (TasksWidgetsScheduledTaskListBox* self,
                                                             ESource* task_list);
static void tasks_widgets_scheduled_task_list_box_on_row_activated (TasksWidgetsScheduledTaskListBox* self,
                                                             GtkListBoxRow* row);
VALA_EXTERN void tasks_widgets_task_row_reveal_child_request (TasksWidgetsTaskRow* self,
                                                  gboolean value);
static void tasks_widgets_scheduled_task_list_box_on_row_unselect (TasksWidgetsScheduledTaskListBox* self,
                                                            GtkListBoxRow* row);
static gint tasks_widgets_scheduled_task_list_box_sort_function (GtkListBoxRow* row1,
                                                          GtkListBoxRow* row2,
                                                          TasksWidgetsScheduledTaskListBox* self);
VALA_EXTERN ECalComponent* tasks_widgets_task_row_get_task (TasksWidgetsTaskRow* self);
static void _vala_ECalComponentDateTime_free (ECalComponentDateTime* self);
static void tasks_widgets_scheduled_task_list_box_header_function (TasksWidgetsScheduledTaskListBox* self,
                                                            GtkListBoxRow* lbrow,
                                                            GtkListBoxRow* lbbefore);
VALA_EXTERN GDateTime* tasks_util_ical_to_date_time_local (ICalTime* date);
VALA_EXTERN gchar* tasks_util_get_relative_date (GDateTime* date_time);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static gboolean __lambda98_ (Block14Data* _data14_,
                      ECalComponent* task);
VALA_EXTERN TasksWidgetsTaskRow* tasks_widgets_task_row_new_for_component (ECalComponent* task,
                                                               ESource* source,
                                                               gboolean is_scheduled_view);
VALA_EXTERN TasksWidgetsTaskRow* tasks_widgets_task_row_construct_for_component (GType object_type,
                                                                     ECalComponent* task,
                                                                     ESource* source,
                                                                     gboolean is_scheduled_view);
static void _tasks_widgets_scheduled_task_list_box_on_row_unselect_tasks_widgets_task_row_unselect (TasksWidgetsTaskRow* _sender,
                                                                                             GtkListBoxRow* row,
                                                                                             gpointer self);
static void __lambda99_ (Block14Data* _data14_,
                  ECalComponent* task);
VALA_EXTERN void tasks_task_model_complete_task (TasksTaskModel* self,
                                     ESource* list,
                                     ECalComponent* task,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN void tasks_task_model_complete_task_finish (TasksTaskModel* self,
                                            GAsyncResult* _res_,
                                            GError** error);
static void __lambda100_ (TasksWidgetsScheduledTaskListBox* self,
                   GObject* obj,
                   GAsyncResult* res);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static gboolean __lambda101_ (Block15Data* _data15_);
static gboolean ___lambda101__gsource_func (gpointer self);
static void ___lambda100__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda99__tasks_widgets_task_row_task_completed (TasksWidgetsTaskRow* _sender,
                                                         ECalComponent* task,
                                                         gpointer self);
static void __lambda102_ (Block14Data* _data14_,
                   ECalComponent* task);
VALA_EXTERN void tasks_task_model_update_task (TasksTaskModel* self,
                                   ESource* list,
                                   ECalComponent* task,
                                   ECalObjModType mod_type,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN void tasks_task_model_update_task_finish (TasksTaskModel* self,
                                          GAsyncResult* _res_,
                                          GError** error);
static void __lambda103_ (TasksWidgetsScheduledTaskListBox* self,
                   GObject* obj,
                   GAsyncResult* res);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static gboolean __lambda104_ (Block16Data* _data16_);
static gboolean ___lambda104__gsource_func (gpointer self);
static void ___lambda103__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda102__tasks_widgets_task_row_task_changed (TasksWidgetsTaskRow* _sender,
                                                        ECalComponent* task,
                                                        gpointer self);
static void __lambda105_ (Block14Data* _data14_,
                   ECalComponent* task);
VALA_EXTERN void tasks_task_model_remove_task (TasksTaskModel* self,
                                   ESource* list,
                                   ECalComponent* task,
                                   ECalObjModType mod_type,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN void tasks_task_model_remove_task_finish (TasksTaskModel* self,
                                          GAsyncResult* _res_,
                                          GError** error);
static void __lambda106_ (TasksWidgetsScheduledTaskListBox* self,
                   GObject* obj,
                   GAsyncResult* res);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static gboolean __lambda107_ (Block17Data* _data17_);
static gboolean ___lambda107__gsource_func (gpointer self);
static void ___lambda106__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda105__tasks_widgets_task_row_task_removed (TasksWidgetsTaskRow* _sender,
                                                        ECalComponent* task,
                                                        gpointer self);
static gboolean ___lambda98__gee_forall_func (gpointer g,
                                       gpointer self);
static gboolean __lambda108_ (TasksWidgetsScheduledTaskListBox* self);
static gboolean ___lambda108__gsource_func (gpointer self);
VALA_EXTERN gboolean tasks_util_calcomponent_equal_func (ECalComponent* a,
                                             ECalComponent* b);
VALA_EXTERN void tasks_widgets_task_row_set_task (TasksWidgetsTaskRow* self,
                                      ECalComponent* value);
static gboolean __lambda109_ (TasksWidgetsScheduledTaskListBox* self);
static gboolean ___lambda109__gsource_func (gpointer self);
static gboolean __lambda110_ (TasksWidgetsScheduledTaskListBox* self);
static gboolean ___lambda110__gsource_func (gpointer self);
static void tasks_widgets_scheduled_task_list_box_set_model (TasksWidgetsScheduledTaskListBox* self,
                                                      TasksTaskModel* value);
static GObject * tasks_widgets_scheduled_task_list_box_constructor (GType type,
                                                             guint n_construct_properties,
                                                             GObjectConstructParam * construct_properties);
static gint _tasks_widgets_scheduled_task_list_box_sort_function_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                                  GtkListBoxRow* row2,
                                                                                  gpointer self);
static void _tasks_widgets_scheduled_task_list_box_header_function_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                                             GtkListBoxRow* before,
                                                                                             gpointer self);
static void _tasks_widgets_scheduled_task_list_box_on_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                         GtkListBoxRow* row,
                                                                                         gpointer self);
static void _tasks_widgets_scheduled_task_list_box_add_task_list_tasks_task_model_task_list_added (TasksTaskModel* _sender,
                                                                                            ESource* task_list,
                                                                                            gpointer self);
static void _tasks_widgets_scheduled_task_list_box_modify_task_list_tasks_task_model_task_list_modified (TasksTaskModel* _sender,
                                                                                                  ESource* task_list,
                                                                                                  gpointer self);
static void _tasks_widgets_scheduled_task_list_box_remove_task_list_tasks_task_model_task_list_removed (TasksTaskModel* _sender,
                                                                                                 ESource* task_list,
                                                                                                 gpointer self);
VALA_EXTERN void tasks_task_model_get_registry (TasksTaskModel* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN ESourceRegistry* tasks_task_model_get_registry_finish (TasksTaskModel* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void _tasks_widgets_scheduled_task_list_box___lambda111_ (TasksWidgetsScheduledTaskListBox* self,
                                                          GObject* obj,
                                                          GAsyncResult* res);
static void __lambda112_ (TasksWidgetsScheduledTaskListBox* self,
                   ESource* source);
static void ___lambda112__gfunc (gconstpointer data,
                          gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void __tasks_widgets_scheduled_task_list_box___lambda111__gasync_ready_callback (GObject* source_object,
                                                                                 GAsyncResult* res,
                                                                                 gpointer self);
static void tasks_widgets_scheduled_task_list_box_finalize (GObject * obj);
static GType tasks_widgets_scheduled_task_list_box_get_type_once (void);
static void _vala_tasks_widgets_scheduled_task_list_box_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec);
static void _vala_tasks_widgets_scheduled_task_list_box_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec);

static inline gpointer
tasks_widgets_scheduled_task_list_box_get_instance_private (TasksWidgetsScheduledTaskListBox* self)
{
	return G_STRUCT_MEMBER_P (self, TasksWidgetsScheduledTaskListBox_private_offset);
}

static void
_tasks_widgets_scheduled_task_list_box_on_tasks_added_tasks_task_model_tasks_added_func (GeeCollection* tasks,
                                                                                         ESource* task_list,
                                                                                         gpointer self)
{
	tasks_widgets_scheduled_task_list_box_on_tasks_added ((TasksWidgetsScheduledTaskListBox*) self, tasks, task_list);
}

static void
_tasks_widgets_scheduled_task_list_box_on_tasks_modified_tasks_task_model_tasks_modified_func (GeeCollection* tasks,
                                                                                               gpointer self)
{
	tasks_widgets_scheduled_task_list_box_on_tasks_modified ((TasksWidgetsScheduledTaskListBox*) self, tasks);
}

static void
_tasks_widgets_scheduled_task_list_box_on_tasks_removed_tasks_task_model_tasks_removed_func (GSList* cids,
                                                                                             gpointer self)
{
	tasks_widgets_scheduled_task_list_box_on_tasks_removed ((TasksWidgetsScheduledTaskListBox*) self, cids);
}

static void
tasks_widgets_scheduled_task_list_box_add_view (TasksWidgetsScheduledTaskListBox* self,
                                                ESource* source,
                                                const gchar* query)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (query != NULL);
	{
		ECalClientView* view = NULL;
		TasksTaskModel* _tmp0_;
		ECalClientView* _tmp1_;
		_tmp0_ = self->priv->_model;
		_tmp1_ = tasks_task_model_create_task_list_view (_tmp0_, source, query, _tasks_widgets_scheduled_task_list_box_on_tasks_added_tasks_task_model_tasks_added_func, self, _tasks_widgets_scheduled_task_list_box_on_tasks_modified_tasks_task_model_tasks_modified_func, self, _tasks_widgets_scheduled_task_list_box_on_tasks_removed_tasks_task_model_tasks_removed_func, self, &_inner_error0_);
		view = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			GeeMap* _tmp2_;
			_tmp2_ = self->priv->views;
			g_rec_mutex_lock (&self->priv->__lock_views);
			{
				GeeMap* _tmp3_;
				ECalClientView* _tmp4_;
				_tmp3_ = self->priv->views;
				_tmp4_ = view;
				gee_map_set (_tmp3_, source, _tmp4_);
			}
			__finally1:
			{
				GeeMap* _tmp5_;
				_tmp5_ = self->priv->views;
				g_rec_mutex_unlock (&self->priv->__lock_views);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (view);
				goto __catch0_g_error;
			}
		}
		_g_object_unref0 (view);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("ScheduledTaskListBox.vala:31: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
tasks_widgets_scheduled_task_list_box_remove_view (TasksWidgetsScheduledTaskListBox* self,
                                                   ESource* source)
{
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->task_list;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				gboolean _tmp2_ = FALSE;
				GtkWidget* _tmp3_;
				_tmp3_ = child;
				if (TASKS_WIDGETS_IS_TASK_ROW (_tmp3_)) {
					GtkWidget* _tmp4_;
					ESource* _tmp5_;
					ESource* _tmp6_;
					_tmp4_ = child;
					_tmp5_ = tasks_widgets_task_row_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TASKS_WIDGETS_TYPE_TASK_ROW, TasksWidgetsTaskRow));
					_tmp6_ = _tmp5_;
					_tmp2_ = _tmp6_ == source;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					GtkWidget* _tmp7_;
					_tmp7_ = child;
					gtk_widget_destroy (_tmp7_);
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	{
		GeeMap* _tmp8_;
		_tmp8_ = self->priv->views;
		g_rec_mutex_lock (&self->priv->__lock_views);
		{
			ECalClientView* view = NULL;
			GeeMap* _tmp9_;
			gpointer _tmp10_ = NULL;
			gboolean _tmp11_;
			_tmp9_ = self->priv->views;
			_tmp11_ = gee_map_unset (_tmp9_, source, &_tmp10_);
			_g_object_unref0 (view);
			view = (ECalClientView*) _tmp10_;
			if (_tmp11_) {
				TasksTaskModel* _tmp12_;
				ECalClientView* _tmp13_;
				_tmp12_ = self->priv->_model;
				_tmp13_ = view;
				tasks_task_model_destroy_task_list_view (_tmp12_, _tmp13_);
			}
			_g_object_unref0 (view);
		}
		__finally0:
		{
			GeeMap* _tmp14_;
			_tmp14_ = self->priv->views;
			g_rec_mutex_unlock (&self->priv->__lock_views);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

TasksWidgetsScheduledTaskListBox*
tasks_widgets_scheduled_task_list_box_construct (GType object_type,
                                                 TasksTaskModel* model)
{
	TasksWidgetsScheduledTaskListBox * self = NULL;
	g_return_val_if_fail (model != NULL, NULL);
	self = (TasksWidgetsScheduledTaskListBox*) g_object_new (object_type, "model", model, NULL);
	return self;
}

TasksWidgetsScheduledTaskListBox*
tasks_widgets_scheduled_task_list_box_new (TasksTaskModel* model)
{
	return tasks_widgets_scheduled_task_list_box_construct (TASKS_WIDGETS_TYPE_SCHEDULED_TASK_LIST_BOX, model);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
tasks_widgets_scheduled_task_list_box_add_task_list (TasksWidgetsScheduledTaskListBox* self,
                                                     ESource* task_list)
{
	ESourceTaskList* list = NULL;
	ESourceExtension* _tmp0_;
	ESourceTaskList* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ESourceTaskList* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (task_list != NULL);
	if (!e_source_has_extension (task_list, E_SOURCE_EXTENSION_TASK_LIST)) {
		return;
	}
	_tmp0_ = e_source_get_extension (task_list, E_SOURCE_EXTENSION_TASK_LIST);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, e_source_task_list_get_type (), ESourceTaskList));
	list = _tmp1_;
	_tmp4_ = list;
	_tmp5_ = e_source_selectable_get_selected ((ESourceSelectable*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == TRUE) {
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = e_source_get_enabled (task_list);
		_tmp8_ = _tmp7_;
		_tmp3_ = _tmp8_ == TRUE;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = !e_source_has_extension (task_list, E_SOURCE_EXTENSION_COLLECTION);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		tasks_widgets_scheduled_task_list_box_add_view (self, task_list, TASKS_WIDGETS_SCHEDULED_TASK_LIST_BOX_QUERY);
	}
	_g_object_unref0 (list);
}

static void
tasks_widgets_scheduled_task_list_box_modify_task_list (TasksWidgetsScheduledTaskListBox* self,
                                                        ESource* task_list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (task_list != NULL);
	tasks_widgets_scheduled_task_list_box_remove_task_list (self, task_list);
	tasks_widgets_scheduled_task_list_box_add_task_list (self, task_list);
}

static void
tasks_widgets_scheduled_task_list_box_remove_task_list (TasksWidgetsScheduledTaskListBox* self,
                                                        ESource* task_list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (task_list != NULL);
	tasks_widgets_scheduled_task_list_box_remove_view (self, task_list);
}

static void
tasks_widgets_scheduled_task_list_box_on_row_activated (TasksWidgetsScheduledTaskListBox* self,
                                                        GtkListBoxRow* row)
{
	TasksWidgetsTaskRow* task_row = NULL;
	TasksWidgetsTaskRow* _tmp0_;
	TasksWidgetsTaskRow* _tmp1_;
	GActionMap* win_action_map = NULL;
	GActionGroup* _tmp2_;
	GActionMap* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (row, TASKS_WIDGETS_TYPE_TASK_ROW, TasksWidgetsTaskRow));
	task_row = _tmp0_;
	_tmp1_ = task_row;
	tasks_widgets_task_row_reveal_child_request (_tmp1_, TRUE);
	_tmp2_ = gtk_widget_get_action_group ((GtkWidget*) self, TASKS_MAIN_WINDOW_ACTION_GROUP_PREFIX);
	win_action_map = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_action_map_get_type (), GActionMap);
	_tmp3_ = win_action_map;
	if (_tmp3_ != NULL) {
		GActionMap* _tmp4_;
		GAction* _tmp5_;
		_tmp4_ = win_action_map;
		_tmp5_ = g_action_map_lookup_action (_tmp4_, TASKS_MAIN_WINDOW_ACTION_DELETE_SELECTED_LIST);
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_simple_action_get_type (), GSimpleAction), FALSE);
	}
	_g_object_unref0 (task_row);
}

static void
tasks_widgets_scheduled_task_list_box_on_row_unselect (TasksWidgetsScheduledTaskListBox* self,
                                                       GtkListBoxRow* row)
{
	GtkContainer* _tmp0_;
	GtkContainer* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = gtk_widget_get_parent ((GtkWidget*) row);
	_tmp1_ = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_list_box_get_type ())) {
		GtkContainer* _tmp2_;
		GtkContainer* _tmp3_;
		_tmp2_ = gtk_widget_get_parent ((GtkWidget*) row);
		_tmp3_ = _tmp2_;
		gtk_list_box_unselect_row (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_list_box_get_type (), GtkListBox), row);
	}
}

static void
_vala_ECalComponentDateTime_free (ECalComponentDateTime* self)
{
	g_boxed_free (e_cal_component_datetime_get_type (), self);
}

static gint
tasks_widgets_scheduled_task_list_box_sort_function (GtkListBoxRow* row1,
                                                     GtkListBoxRow* row2,
                                                     TasksWidgetsScheduledTaskListBox* self)
{
	TasksWidgetsTaskRow* row_a = NULL;
	TasksWidgetsTaskRow* _tmp0_;
	TasksWidgetsTaskRow* row_b = NULL;
	TasksWidgetsTaskRow* _tmp1_;
	ECalComponent* _tmp2_;
	ECalComponent* _tmp3_;
	ECalComponentDateTime* _tmp4_;
	ECalComponentDateTime* _tmp5_;
	ICalTime* _tmp6_;
	ECalComponent* _tmp7_;
	ECalComponent* _tmp8_;
	ECalComponentDateTime* _tmp9_;
	ECalComponentDateTime* _tmp10_;
	ICalTime* _tmp11_;
	gint _tmp12_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (row1, TASKS_WIDGETS_TYPE_TASK_ROW, TasksWidgetsTaskRow));
	row_a = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (row2, TASKS_WIDGETS_TYPE_TASK_ROW, TasksWidgetsTaskRow));
	row_b = _tmp1_;
	_tmp2_ = tasks_widgets_task_row_get_task (row_a);
	_tmp3_ = _tmp2_;
	_tmp4_ = e_cal_component_get_due (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = e_cal_component_datetime_get_value (_tmp5_);
	_tmp7_ = tasks_widgets_task_row_get_task (row_b);
	_tmp8_ = _tmp7_;
	_tmp9_ = e_cal_component_get_due (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = e_cal_component_datetime_get_value (_tmp10_);
	_tmp12_ = i_cal_time_compare (_tmp6_, _tmp11_);
	__vala_ECalComponentDateTime_free0 (_tmp10_);
	__vala_ECalComponentDateTime_free0 (_tmp5_);
	result = _tmp12_;
	_g_object_unref0 (row_b);
	_g_object_unref0 (row_a);
	return result;
}

static void
tasks_widgets_scheduled_task_list_box_header_function (TasksWidgetsScheduledTaskListBox* self,
                                                       GtkListBoxRow* lbrow,
                                                       GtkListBoxRow* lbbefore)
{
	TasksWidgetsTaskRow* row = NULL;
	TasksWidgetsTaskRow* _tmp0_;
	ICalComponent* comp = NULL;
	TasksWidgetsTaskRow* _tmp1_;
	ECalComponent* _tmp2_;
	ECalComponent* _tmp3_;
	ICalComponent* _tmp4_;
	ICalComponent* _tmp5_;
	ICalTime* _tmp6_;
	ICalTime* _tmp7_;
	gboolean _tmp8_;
	GDateTime* due_date_time = NULL;
	ICalComponent* _tmp21_;
	ICalTime* _tmp22_;
	ICalTime* _tmp23_;
	GDateTime* _tmp24_;
	GDateTime* _tmp25_;
	GraniteHeaderLabel* header_label = NULL;
	GDateTime* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GraniteHeaderLabel* _tmp29_;
	GraniteHeaderLabel* _tmp30_;
	GraniteHeaderLabel* _tmp31_;
	GraniteHeaderLabel* _tmp32_;
	TasksWidgetsTaskRow* _tmp33_;
	GraniteHeaderLabel* _tmp34_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (lbrow != NULL);
	if (!TASKS_WIDGETS_IS_TASK_ROW (lbrow)) {
		return;
	}
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (lbrow, TASKS_WIDGETS_TYPE_TASK_ROW, TasksWidgetsTaskRow));
	row = _tmp0_;
	_tmp1_ = row;
	_tmp2_ = tasks_widgets_task_row_get_task (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = e_cal_component_get_icalcomponent (_tmp3_);
	comp = _tmp4_;
	_tmp5_ = comp;
	_tmp6_ = i_cal_component_get_due (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = i_cal_time_is_null_time (_tmp7_);
	_g_object_unref0 (_tmp7_);
	if (_tmp8_) {
		_g_object_unref0 (row);
		return;
	}
	if (lbbefore != NULL) {
		TasksWidgetsTaskRow* before = NULL;
		TasksWidgetsTaskRow* _tmp9_;
		ICalComponent* comp_before = NULL;
		TasksWidgetsTaskRow* _tmp10_;
		ECalComponent* _tmp11_;
		ECalComponent* _tmp12_;
		ICalComponent* _tmp13_;
		ICalComponent* _tmp14_;
		ICalTime* _tmp15_;
		ICalTime* _tmp16_;
		ICalComponent* _tmp17_;
		ICalTime* _tmp18_;
		ICalTime* _tmp19_;
		gboolean _tmp20_;
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (lbbefore, TASKS_WIDGETS_TYPE_TASK_ROW, TasksWidgetsTaskRow));
		before = _tmp9_;
		_tmp10_ = before;
		_tmp11_ = tasks_widgets_task_row_get_task (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = e_cal_component_get_icalcomponent (_tmp12_);
		comp_before = _tmp13_;
		_tmp14_ = comp_before;
		_tmp15_ = i_cal_component_get_due (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = comp;
		_tmp18_ = i_cal_component_get_due (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = i_cal_time_compare_date_only (_tmp16_, _tmp19_) == 0;
		_g_object_unref0 (_tmp19_);
		_g_object_unref0 (_tmp16_);
		if (_tmp20_) {
			_g_object_unref0 (before);
			_g_object_unref0 (row);
			return;
		}
		_g_object_unref0 (before);
	}
	_tmp21_ = comp;
	_tmp22_ = i_cal_component_get_due (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = tasks_util_ical_to_date_time_local (_tmp23_);
	_tmp25_ = _tmp24_;
	_g_object_unref0 (_tmp23_);
	due_date_time = _tmp25_;
	_tmp26_ = due_date_time;
	_tmp27_ = tasks_util_get_relative_date (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = granite_header_label_new (_tmp28_);
	g_object_ref_sink (_tmp29_);
	_tmp30_ = _tmp29_;
	_g_free0 (_tmp28_);
	header_label = _tmp30_;
	_tmp31_ = header_label;
	gtk_label_set_ellipsize ((GtkLabel*) _tmp31_, PANGO_ELLIPSIZE_MIDDLE);
	_tmp32_ = header_label;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp32_, 6);
	_tmp33_ = row;
	_tmp34_ = header_label;
	gtk_list_box_row_set_header ((GtkListBoxRow*) _tmp33_, (GtkWidget*) _tmp34_);
	_g_object_unref0 (header_label);
	_g_date_time_unref0 (due_date_time);
	_g_object_unref0 (row);
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		TasksWidgetsScheduledTaskListBox* self;
		self = _data14_->self;
		_g_object_unref0 (_data14_->source);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}

static void
_tasks_widgets_scheduled_task_list_box_on_row_unselect_tasks_widgets_task_row_unselect (TasksWidgetsTaskRow* _sender,
                                                                                        GtkListBoxRow* row,
                                                                                        gpointer self)
{
	tasks_widgets_scheduled_task_list_box_on_row_unselect ((TasksWidgetsScheduledTaskListBox*) self, row);
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		TasksWidgetsScheduledTaskListBox* self;
		self = _data15_->self;
		_g_object_unref0 (_data15_->res);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static gboolean
__lambda101_ (Block15Data* _data15_)
{
	TasksWidgetsScheduledTaskListBox* self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = _data15_->self;
	{
		TasksTaskModel* _tmp0_;
		_tmp0_ = tasks_application_model;
		tasks_task_model_complete_task_finish (_tmp0_, _data15_->res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GraniteMessageDialog* error_dialog = NULL;
		GThemedIcon* _tmp1_;
		GThemedIcon* _tmp2_;
		GraniteMessageDialog* _tmp3_;
		GraniteMessageDialog* _tmp4_;
		GraniteMessageDialog* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		GraniteMessageDialog* _tmp8_;
		GraniteMessageDialog* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp2_ = _tmp1_;
		_tmp3_ = granite_message_dialog_new (_ ("Completing task failed"), _ ("The task registry may be unavailable or unable to be written to."), (GIcon*) _tmp2_, GTK_BUTTONS_CLOSE);
		g_object_ref_sink (_tmp3_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		error_dialog = _tmp4_;
		_tmp5_ = error_dialog;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		granite_message_dialog_show_error_details (_tmp5_, _tmp7_);
		_tmp8_ = error_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp8_);
		_tmp9_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp9_);
		_g_object_unref0 (error_dialog);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda101__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda101_ (self);
	return result;
}

static void
__lambda100_ (TasksWidgetsScheduledTaskListBox* self,
              GObject* obj,
              GAsyncResult* res)
{
	Block15Data* _data15_;
	GAsyncResult* _tmp0_;
	g_return_if_fail (res != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (res);
	_g_object_unref0 (_data15_->res);
	_data15_->res = _tmp0_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda101__gsource_func, block15_data_ref (_data15_), block15_data_unref);
	block15_data_unref (_data15_);
	_data15_ = NULL;
}

static void
___lambda100__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda100_ ((TasksWidgetsScheduledTaskListBox*) self, source_object, res);
	g_object_unref (self);
}

static void
__lambda99_ (Block14Data* _data14_,
             ECalComponent* task)
{
	TasksWidgetsScheduledTaskListBox* self;
	TasksTaskModel* _tmp0_;
	self = _data14_->self;
	g_return_if_fail (task != NULL);
	_tmp0_ = tasks_application_model;
	tasks_task_model_complete_task (_tmp0_, _data14_->source, task, ___lambda100__gasync_ready_callback, g_object_ref (self));
}

static void
___lambda99__tasks_widgets_task_row_task_completed (TasksWidgetsTaskRow* _sender,
                                                    ECalComponent* task,
                                                    gpointer self)
{
	__lambda99_ (self, task);
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		TasksWidgetsScheduledTaskListBox* self;
		self = _data16_->self;
		_g_object_unref0 (_data16_->res);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static gboolean
__lambda104_ (Block16Data* _data16_)
{
	TasksWidgetsScheduledTaskListBox* self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = _data16_->self;
	{
		TasksTaskModel* _tmp0_;
		_tmp0_ = tasks_application_model;
		tasks_task_model_update_task_finish (_tmp0_, _data16_->res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GraniteMessageDialog* error_dialog = NULL;
		GThemedIcon* _tmp1_;
		GThemedIcon* _tmp2_;
		GraniteMessageDialog* _tmp3_;
		GraniteMessageDialog* _tmp4_;
		GraniteMessageDialog* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		GraniteMessageDialog* _tmp8_;
		GraniteMessageDialog* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp2_ = _tmp1_;
		_tmp3_ = granite_message_dialog_new (_ ("Updating task failed"), _ ("The task registry may be unavailable or unable to be written to."), (GIcon*) _tmp2_, GTK_BUTTONS_CLOSE);
		g_object_ref_sink (_tmp3_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		error_dialog = _tmp4_;
		_tmp5_ = error_dialog;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		granite_message_dialog_show_error_details (_tmp5_, _tmp7_);
		_tmp8_ = error_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp8_);
		_tmp9_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp9_);
		_g_object_unref0 (error_dialog);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda104__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda104_ (self);
	return result;
}

static void
__lambda103_ (TasksWidgetsScheduledTaskListBox* self,
              GObject* obj,
              GAsyncResult* res)
{
	Block16Data* _data16_;
	GAsyncResult* _tmp0_;
	g_return_if_fail (res != NULL);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (res);
	_g_object_unref0 (_data16_->res);
	_data16_->res = _tmp0_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda104__gsource_func, block16_data_ref (_data16_), block16_data_unref);
	block16_data_unref (_data16_);
	_data16_ = NULL;
}

static void
___lambda103__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda103_ ((TasksWidgetsScheduledTaskListBox*) self, source_object, res);
	g_object_unref (self);
}

static void
__lambda102_ (Block14Data* _data14_,
              ECalComponent* task)
{
	TasksWidgetsScheduledTaskListBox* self;
	TasksTaskModel* _tmp0_;
	self = _data14_->self;
	g_return_if_fail (task != NULL);
	_tmp0_ = tasks_application_model;
	tasks_task_model_update_task (_tmp0_, _data14_->source, task, E_CAL_OBJ_MOD_THIS_AND_FUTURE, ___lambda103__gasync_ready_callback, g_object_ref (self));
}

static void
___lambda102__tasks_widgets_task_row_task_changed (TasksWidgetsTaskRow* _sender,
                                                   ECalComponent* task,
                                                   gpointer self)
{
	__lambda102_ (self, task);
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		TasksWidgetsScheduledTaskListBox* self;
		self = _data17_->self;
		_g_object_unref0 (_data17_->res);
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}

static gboolean
__lambda107_ (Block17Data* _data17_)
{
	TasksWidgetsScheduledTaskListBox* self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = _data17_->self;
	{
		TasksTaskModel* _tmp0_;
		_tmp0_ = tasks_application_model;
		tasks_task_model_remove_task_finish (_tmp0_, _data17_->res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GraniteMessageDialog* error_dialog = NULL;
		GThemedIcon* _tmp1_;
		GThemedIcon* _tmp2_;
		GraniteMessageDialog* _tmp3_;
		GraniteMessageDialog* _tmp4_;
		GraniteMessageDialog* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		GraniteMessageDialog* _tmp8_;
		GraniteMessageDialog* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp2_ = _tmp1_;
		_tmp3_ = granite_message_dialog_new (_ ("Removing task failed"), _ ("The task registry may be unavailable or unable to be written to."), (GIcon*) _tmp2_, GTK_BUTTONS_CLOSE);
		g_object_ref_sink (_tmp3_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		error_dialog = _tmp4_;
		_tmp5_ = error_dialog;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		granite_message_dialog_show_error_details (_tmp5_, _tmp7_);
		_tmp8_ = error_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp8_);
		_tmp9_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp9_);
		_g_object_unref0 (error_dialog);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda107__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda107_ (self);
	return result;
}

static void
__lambda106_ (TasksWidgetsScheduledTaskListBox* self,
              GObject* obj,
              GAsyncResult* res)
{
	Block17Data* _data17_;
	GAsyncResult* _tmp0_;
	g_return_if_fail (res != NULL);
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (res);
	_g_object_unref0 (_data17_->res);
	_data17_->res = _tmp0_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda107__gsource_func, block17_data_ref (_data17_), block17_data_unref);
	block17_data_unref (_data17_);
	_data17_ = NULL;
}

static void
___lambda106__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda106_ ((TasksWidgetsScheduledTaskListBox*) self, source_object, res);
	g_object_unref (self);
}

static void
__lambda105_ (Block14Data* _data14_,
              ECalComponent* task)
{
	TasksWidgetsScheduledTaskListBox* self;
	TasksTaskModel* _tmp0_;
	self = _data14_->self;
	g_return_if_fail (task != NULL);
	_tmp0_ = tasks_application_model;
	tasks_task_model_remove_task (_tmp0_, _data14_->source, task, E_CAL_OBJ_MOD_ALL, ___lambda106__gasync_ready_callback, g_object_ref (self));
}

static void
___lambda105__tasks_widgets_task_row_task_removed (TasksWidgetsTaskRow* _sender,
                                                   ECalComponent* task,
                                                   gpointer self)
{
	__lambda105_ (self, task);
}

static gboolean
__lambda98_ (Block14Data* _data14_,
             ECalComponent* task)
{
	TasksWidgetsScheduledTaskListBox* self;
	TasksWidgetsTaskRow* task_row = NULL;
	TasksWidgetsTaskRow* _tmp0_;
	GtkListBox* _tmp1_;
	gboolean result;
	self = _data14_->self;
	g_return_val_if_fail (task != NULL, FALSE);
	_tmp0_ = tasks_widgets_task_row_new_for_component (task, _data14_->source, TRUE);
	g_object_ref_sink (_tmp0_);
	task_row = _tmp0_;
	g_signal_connect_object (task_row, "unselect", (GCallback) _tasks_widgets_scheduled_task_list_box_on_row_unselect_tasks_widgets_task_row_unselect, self, 0);
	g_signal_connect_data (task_row, "task-completed", (GCallback) ___lambda99__tasks_widgets_task_row_task_completed, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
	g_signal_connect_data (task_row, "task-changed", (GCallback) ___lambda102__tasks_widgets_task_row_task_changed, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
	g_signal_connect_data (task_row, "task-removed", (GCallback) ___lambda105__tasks_widgets_task_row_task_removed, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
	_tmp1_ = self->priv->task_list;
	gtk_container_add ((GtkContainer*) _tmp1_, (GtkWidget*) task_row);
	result = TRUE;
	_g_object_unref0 (task_row);
	_g_object_unref0 (task);
	return result;
}

static gboolean
___lambda98__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda98_ (self, (ECalComponent*) g);
	return result;
}

static gboolean
__lambda108_ (TasksWidgetsScheduledTaskListBox* self)
{
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	gboolean result;
	_tmp0_ = self->priv->task_list;
	gtk_list_box_invalidate_sort (_tmp0_);
	_tmp1_ = self->priv->task_list;
	gtk_widget_show_all ((GtkWidget*) _tmp1_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda108__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda108_ ((TasksWidgetsScheduledTaskListBox*) self);
	return result;
}

static void
tasks_widgets_scheduled_task_list_box_on_tasks_added (TasksWidgetsScheduledTaskListBox* self,
                                                      GeeCollection* tasks,
                                                      ESource* source)
{
	Block14Data* _data14_;
	ESource* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tasks != NULL);
	g_return_if_fail (source != NULL);
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data14_->source);
	_data14_->source = _tmp0_;
	gee_traversable_foreach ((GeeTraversable*) tasks, ___lambda98__gee_forall_func, _data14_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda108__gsource_func, g_object_ref (self), g_object_unref);
	block14_data_unref (_data14_);
	_data14_ = NULL;
}

static gboolean
__lambda109_ (TasksWidgetsScheduledTaskListBox* self)
{
	GtkListBox* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->task_list;
	gtk_list_box_invalidate_sort (_tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda109__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda109_ ((TasksWidgetsScheduledTaskListBox*) self);
	return result;
}

static void
tasks_widgets_scheduled_task_list_box_on_tasks_modified (TasksWidgetsScheduledTaskListBox* self,
                                                         GeeCollection* tasks)
{
	TasksWidgetsTaskRow* task_row = NULL;
	gint row_index = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tasks != NULL);
	task_row = NULL;
	row_index = 0;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			GtkListBox* _tmp2_;
			GtkListBoxRow* _tmp3_;
			TasksWidgetsTaskRow* _tmp4_;
			TasksWidgetsTaskRow* _tmp5_;
			gint _tmp16_;
			if (!_tmp0_) {
				TasksWidgetsTaskRow* _tmp1_;
				_tmp1_ = task_row;
				if (!(_tmp1_ != NULL)) {
					break;
				}
			}
			_tmp0_ = FALSE;
			_tmp2_ = self->priv->task_list;
			_tmp3_ = gtk_list_box_get_row_at_index (_tmp2_, row_index);
			_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TASKS_WIDGETS_TYPE_TASK_ROW, TasksWidgetsTaskRow));
			_g_object_unref0 (task_row);
			task_row = _tmp4_;
			_tmp5_ = task_row;
			if (_tmp5_ != NULL) {
				{
					GeeIterator* _task_it = NULL;
					GeeIterator* _tmp6_;
					_tmp6_ = gee_iterable_iterator ((GeeIterable*) tasks);
					_task_it = _tmp6_;
					while (TRUE) {
						GeeIterator* _tmp7_;
						ECalComponent* task = NULL;
						GeeIterator* _tmp8_;
						gpointer _tmp9_;
						TasksWidgetsTaskRow* _tmp10_;
						ECalComponent* _tmp11_;
						ECalComponent* _tmp12_;
						ECalComponent* _tmp13_;
						_tmp7_ = _task_it;
						if (!gee_iterator_next (_tmp7_)) {
							break;
						}
						_tmp8_ = _task_it;
						_tmp9_ = gee_iterator_get (_tmp8_);
						task = (ECalComponent*) _tmp9_;
						_tmp10_ = task_row;
						_tmp11_ = tasks_widgets_task_row_get_task (_tmp10_);
						_tmp12_ = _tmp11_;
						_tmp13_ = task;
						if (tasks_util_calcomponent_equal_func (_tmp12_, _tmp13_)) {
							TasksWidgetsTaskRow* _tmp14_;
							ECalComponent* _tmp15_;
							_tmp14_ = task_row;
							_tmp15_ = task;
							tasks_widgets_task_row_set_task (_tmp14_, _tmp15_);
							_g_object_unref0 (task);
							break;
						}
						_g_object_unref0 (task);
					}
					_g_object_unref0 (_task_it);
				}
			}
			_tmp16_ = row_index;
			row_index = _tmp16_ + 1;
		}
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda109__gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (task_row);
}

static gboolean
__lambda110_ (TasksWidgetsScheduledTaskListBox* self)
{
	GtkListBox* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->task_list;
	gtk_list_box_invalidate_sort (_tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda110__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda110_ ((TasksWidgetsScheduledTaskListBox*) self);
	return result;
}

static void
tasks_widgets_scheduled_task_list_box_on_tasks_removed (TasksWidgetsScheduledTaskListBox* self,
                                                        GSList* cids)
{
	TasksWidgetsTaskRow* task_row = NULL;
	gint row_index = 0;
	g_return_if_fail (self != NULL);
	task_row = NULL;
	row_index = 0;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			GtkListBox* _tmp2_;
			GtkListBoxRow* _tmp3_;
			TasksWidgetsTaskRow* _tmp4_;
			gint _tmp15_;
			if (!_tmp0_) {
				TasksWidgetsTaskRow* _tmp1_;
				_tmp1_ = task_row;
				if (!(_tmp1_ != NULL)) {
					break;
				}
			}
			_tmp0_ = FALSE;
			_tmp2_ = self->priv->task_list;
			_tmp3_ = gtk_list_box_get_row_at_index (_tmp2_, row_index);
			task_row = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TASKS_WIDGETS_TYPE_TASK_ROW, TasksWidgetsTaskRow);
			_tmp4_ = task_row;
			if (_tmp4_ != NULL) {
				{
					GSList* cid_collection = NULL;
					GSList* cid_it = NULL;
					cid_collection = cids;
					for (cid_it = cid_collection; cid_it != NULL; cid_it = cid_it->next) {
						ECalComponentId* cid = NULL;
						cid = (ECalComponentId*) cid_it->data;
						{
							ECalComponentId* _tmp5_;
							_tmp5_ = cid;
							if (_tmp5_ == NULL) {
								continue;
							} else {
								ECalComponentId* _tmp6_;
								const gchar* _tmp7_;
								TasksWidgetsTaskRow* _tmp8_;
								ECalComponent* _tmp9_;
								ECalComponent* _tmp10_;
								ICalComponent* _tmp11_;
								const gchar* _tmp12_;
								_tmp6_ = cid;
								_tmp7_ = e_cal_component_id_get_uid (_tmp6_);
								_tmp8_ = task_row;
								_tmp9_ = tasks_widgets_task_row_get_task (_tmp8_);
								_tmp10_ = _tmp9_;
								_tmp11_ = e_cal_component_get_icalcomponent (_tmp10_);
								_tmp12_ = i_cal_component_get_uid (_tmp11_);
								if (g_strcmp0 (_tmp7_, _tmp12_) == 0) {
									GtkListBox* _tmp13_;
									TasksWidgetsTaskRow* _tmp14_;
									_tmp13_ = self->priv->task_list;
									_tmp14_ = task_row;
									gtk_container_remove ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
									break;
								}
							}
						}
					}
				}
			}
			_tmp15_ = row_index;
			row_index = _tmp15_ + 1;
		}
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda110__gsource_func, g_object_ref (self), g_object_unref);
}

TasksTaskModel*
tasks_widgets_scheduled_task_list_box_get_model (TasksWidgetsScheduledTaskListBox* self)
{
	TasksTaskModel* result;
	TasksTaskModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_model;
	result = _tmp0_;
	return result;
}

static void
tasks_widgets_scheduled_task_list_box_set_model (TasksWidgetsScheduledTaskListBox* self,
                                                 TasksTaskModel* value)
{
	TasksTaskModel* old_value;
	g_return_if_fail (self != NULL);
	old_value = tasks_widgets_scheduled_task_list_box_get_model (self);
	if (old_value != value) {
		TasksTaskModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_model);
		self->priv->_model = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tasks_widgets_scheduled_task_list_box_properties[TASKS_WIDGETS_SCHEDULED_TASK_LIST_BOX_MODEL_PROPERTY]);
	}
}

static gint
_tasks_widgets_scheduled_task_list_box_sort_function_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                             GtkListBoxRow* row2,
                                                                             gpointer self)
{
	gint result;
	result = tasks_widgets_scheduled_task_list_box_sort_function (row1, row2, (TasksWidgetsScheduledTaskListBox*) self);
	return result;
}

static void
_tasks_widgets_scheduled_task_list_box_header_function_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                                        GtkListBoxRow* before,
                                                                                        gpointer self)
{
	tasks_widgets_scheduled_task_list_box_header_function ((TasksWidgetsScheduledTaskListBox*) self, row, before);
}

static void
_tasks_widgets_scheduled_task_list_box_on_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                    GtkListBoxRow* row,
                                                                                    gpointer self)
{
	tasks_widgets_scheduled_task_list_box_on_row_activated ((TasksWidgetsScheduledTaskListBox*) self, row);
}

static void
_tasks_widgets_scheduled_task_list_box_add_task_list_tasks_task_model_task_list_added (TasksTaskModel* _sender,
                                                                                       ESource* task_list,
                                                                                       gpointer self)
{
	tasks_widgets_scheduled_task_list_box_add_task_list ((TasksWidgetsScheduledTaskListBox*) self, task_list);
}

static void
_tasks_widgets_scheduled_task_list_box_modify_task_list_tasks_task_model_task_list_modified (TasksTaskModel* _sender,
                                                                                             ESource* task_list,
                                                                                             gpointer self)
{
	tasks_widgets_scheduled_task_list_box_modify_task_list ((TasksWidgetsScheduledTaskListBox*) self, task_list);
}

static void
_tasks_widgets_scheduled_task_list_box_remove_task_list_tasks_task_model_task_list_removed (TasksTaskModel* _sender,
                                                                                            ESource* task_list,
                                                                                            gpointer self)
{
	tasks_widgets_scheduled_task_list_box_remove_task_list ((TasksWidgetsScheduledTaskListBox*) self, task_list);
}

static void
__lambda112_ (TasksWidgetsScheduledTaskListBox* self,
              ESource* source)
{
	g_return_if_fail (source != NULL);
	tasks_widgets_scheduled_task_list_box_add_task_list (self, source);
}

static void
___lambda112__gfunc (gconstpointer data,
                     gpointer self)
{
	__lambda112_ ((TasksWidgetsScheduledTaskListBox*) self, (ESource*) data);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_tasks_widgets_scheduled_task_list_box___lambda111_ (TasksWidgetsScheduledTaskListBox* self,
                                                     GObject* obj,
                                                     GAsyncResult* res)
{
	ESourceRegistry* registry = NULL;
	GList* sources = NULL;
	ESourceRegistry* _tmp6_;
	GList* _tmp7_;
	GList* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		ESourceRegistry* _tmp0_ = NULL;
		TasksTaskModel* _tmp1_;
		ESourceRegistry* _tmp2_;
		ESourceRegistry* _tmp3_;
		_tmp1_ = self->priv->_model;
		_tmp2_ = tasks_task_model_get_registry_finish (_tmp1_, res, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (registry);
		registry = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("ScheduledTaskListBox.vala:107: %s", _tmp5_);
		_g_error_free0 (e);
		_g_object_unref0 (registry);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (registry);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp6_ = registry;
	_tmp7_ = e_source_registry_list_sources (_tmp6_, E_SOURCE_EXTENSION_TASK_LIST);
	sources = _tmp7_;
	_tmp8_ = sources;
	g_list_foreach (_tmp8_, ___lambda112__gfunc, self);
	(sources == NULL) ? NULL : (sources = (_g_list_free__g_object_unref0_ (sources), NULL));
	_g_object_unref0 (registry);
}

static void
__tasks_widgets_scheduled_task_list_box___lambda111__gasync_ready_callback (GObject* source_object,
                                                                            GAsyncResult* res,
                                                                            gpointer self)
{
	_tasks_widgets_scheduled_task_list_box___lambda111_ ((TasksWidgetsScheduledTaskListBox*) self, source_object, res);
	g_object_unref (self);
}

static GObject *
tasks_widgets_scheduled_task_list_box_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TasksWidgetsScheduledTaskListBox * self;
	GeeHashMap* _tmp0_;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkLabel* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkLabel* placeholder = NULL;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkLabel* _tmp10_;
	GtkStyleContext* _tmp11_;
	GtkListBox* _tmp12_ = NULL;
	GtkListBox* _tmp13_;
	GtkLabel* _tmp14_;
	GtkListBox* _tmp15_;
	GtkListBox* _tmp16_;
	GtkListBox* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkScrolledWindow* _tmp19_ = NULL;
	GtkScrolledWindow* _tmp20_;
	GtkListBox* _tmp21_;
	GtkLabel* _tmp22_;
	GtkScrolledWindow* _tmp23_;
	GtkListBox* _tmp24_;
	TasksTaskModel* _tmp25_;
	TasksTaskModel* _tmp26_;
	TasksTaskModel* _tmp27_;
	TasksTaskModel* _tmp28_;
	parent_class = G_OBJECT_CLASS (tasks_widgets_scheduled_task_list_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKS_WIDGETS_TYPE_SCHEDULED_TASK_LIST_BOX, TasksWidgetsScheduledTaskListBox);
	_tmp0_ = gee_hash_map_new (e_source_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, e_cal_client_view_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->views);
	self->priv->views = (GeeMap*) _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (_ ("Scheduled"));
	gtk_label_set_ellipsize (_tmp1_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp1_, 24);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp1_, 24);
	gtk_label_set_xalign (_tmp1_, (gfloat) 0);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->scheduled_title);
	self->priv->scheduled_title = _tmp1_;
	_tmp2_ = self->priv->scheduled_title;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_add_class (_tmp3_, GRANITE_STYLE_CLASS_H1_LABEL);
	_tmp4_ = self->priv->scheduled_title;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	gtk_style_context_add_class (_tmp5_, GRANITE_STYLE_CLASS_ACCENT);
	_tmp6_ = (GtkLabel*) gtk_label_new (_ ("No Tasks"));
	g_object_ref_sink (_tmp6_);
	placeholder = _tmp6_;
	_tmp7_ = placeholder;
	gtk_widget_show ((GtkWidget*) _tmp7_);
	_tmp8_ = placeholder;
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
	gtk_style_context_add_class (_tmp9_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp10_ = placeholder;
	_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
	gtk_style_context_add_class (_tmp11_, GRANITE_STYLE_CLASS_H2_LABEL);
	_tmp12_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_selection_mode (_tmp12_, GTK_SELECTION_MULTIPLE);
	gtk_list_box_set_activate_on_single_click (_tmp12_, TRUE);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->task_list);
	self->priv->task_list = _tmp12_;
	_tmp13_ = self->priv->task_list;
	_tmp14_ = placeholder;
	gtk_list_box_set_placeholder (_tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = self->priv->task_list;
	gtk_list_box_set_sort_func (_tmp15_, _tasks_widgets_scheduled_task_list_box_sort_function_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp16_ = self->priv->task_list;
	gtk_list_box_set_header_func (_tmp16_, _tasks_widgets_scheduled_task_list_box_header_function_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp17_ = self->priv->task_list;
	_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) _tmp17_);
	gtk_style_context_add_class (_tmp18_, GTK_STYLE_CLASS_BACKGROUND);
	_tmp19_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp19_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp19_, TRUE);
	g_object_set (_tmp19_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_ref_sink (_tmp19_);
	scrolled_window = _tmp19_;
	_tmp20_ = scrolled_window;
	_tmp21_ = self->priv->task_list;
	gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp22_ = self->priv->scheduled_title;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp22_);
	_tmp23_ = scrolled_window;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp23_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp24_ = self->priv->task_list;
	g_signal_connect_object (_tmp24_, "row-activated", (GCallback) _tasks_widgets_scheduled_task_list_box_on_row_activated_gtk_list_box_row_activated, self, 0);
	_tmp25_ = self->priv->_model;
	g_signal_connect_object (_tmp25_, "task-list-added", (GCallback) _tasks_widgets_scheduled_task_list_box_add_task_list_tasks_task_model_task_list_added, self, 0);
	_tmp26_ = self->priv->_model;
	g_signal_connect_object (_tmp26_, "task-list-modified", (GCallback) _tasks_widgets_scheduled_task_list_box_modify_task_list_tasks_task_model_task_list_modified, self, 0);
	_tmp27_ = self->priv->_model;
	g_signal_connect_object (_tmp27_, "task-list-removed", (GCallback) _tasks_widgets_scheduled_task_list_box_remove_task_list_tasks_task_model_task_list_removed, self, 0);
	_tmp28_ = self->priv->_model;
	tasks_task_model_get_registry (_tmp28_, __tasks_widgets_scheduled_task_list_box___lambda111__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (placeholder);
	return obj;
}

static void
tasks_widgets_scheduled_task_list_box_class_init (TasksWidgetsScheduledTaskListBoxClass * klass,
                                                  gpointer klass_data)
{
	tasks_widgets_scheduled_task_list_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TasksWidgetsScheduledTaskListBox_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_tasks_widgets_scheduled_task_list_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tasks_widgets_scheduled_task_list_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = tasks_widgets_scheduled_task_list_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = tasks_widgets_scheduled_task_list_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TASKS_WIDGETS_SCHEDULED_TASK_LIST_BOX_MODEL_PROPERTY, tasks_widgets_scheduled_task_list_box_properties[TASKS_WIDGETS_SCHEDULED_TASK_LIST_BOX_MODEL_PROPERTY] = g_param_spec_object ("model", "model", "model", TASKS_TYPE_TASK_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
tasks_widgets_scheduled_task_list_box_instance_init (TasksWidgetsScheduledTaskListBox * self,
                                                     gpointer klass)
{
	self->priv = tasks_widgets_scheduled_task_list_box_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_views);
}

static void
tasks_widgets_scheduled_task_list_box_finalize (GObject * obj)
{
	TasksWidgetsScheduledTaskListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKS_WIDGETS_TYPE_SCHEDULED_TASK_LIST_BOX, TasksWidgetsScheduledTaskListBox);
	g_rec_mutex_clear (&self->priv->__lock_views);
	_g_object_unref0 (self->priv->views);
	_g_object_unref0 (self->priv->_model);
	_g_object_unref0 (self->priv->scheduled_title);
	_g_object_unref0 (self->priv->task_list);
	G_OBJECT_CLASS (tasks_widgets_scheduled_task_list_box_parent_class)->finalize (obj);
}

static GType
tasks_widgets_scheduled_task_list_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TasksWidgetsScheduledTaskListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasks_widgets_scheduled_task_list_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TasksWidgetsScheduledTaskListBox), 0, (GInstanceInitFunc) tasks_widgets_scheduled_task_list_box_instance_init, NULL };
	GType tasks_widgets_scheduled_task_list_box_type_id;
	tasks_widgets_scheduled_task_list_box_type_id = g_type_register_static (gtk_box_get_type (), "TasksWidgetsScheduledTaskListBox", &g_define_type_info, 0);
	TasksWidgetsScheduledTaskListBox_private_offset = g_type_add_instance_private (tasks_widgets_scheduled_task_list_box_type_id, sizeof (TasksWidgetsScheduledTaskListBoxPrivate));
	return tasks_widgets_scheduled_task_list_box_type_id;
}

GType
tasks_widgets_scheduled_task_list_box_get_type (void)
{
	static volatile gsize tasks_widgets_scheduled_task_list_box_type_id__once = 0;
	if (g_once_init_enter (&tasks_widgets_scheduled_task_list_box_type_id__once)) {
		GType tasks_widgets_scheduled_task_list_box_type_id;
		tasks_widgets_scheduled_task_list_box_type_id = tasks_widgets_scheduled_task_list_box_get_type_once ();
		g_once_init_leave (&tasks_widgets_scheduled_task_list_box_type_id__once, tasks_widgets_scheduled_task_list_box_type_id);
	}
	return tasks_widgets_scheduled_task_list_box_type_id__once;
}

static void
_vala_tasks_widgets_scheduled_task_list_box_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec)
{
	TasksWidgetsScheduledTaskListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TASKS_WIDGETS_TYPE_SCHEDULED_TASK_LIST_BOX, TasksWidgetsScheduledTaskListBox);
	switch (property_id) {
		case TASKS_WIDGETS_SCHEDULED_TASK_LIST_BOX_MODEL_PROPERTY:
		g_value_set_object (value, tasks_widgets_scheduled_task_list_box_get_model (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tasks_widgets_scheduled_task_list_box_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec)
{
	TasksWidgetsScheduledTaskListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TASKS_WIDGETS_TYPE_SCHEDULED_TASK_LIST_BOX, TasksWidgetsScheduledTaskListBox);
	switch (property_id) {
		case TASKS_WIDGETS_SCHEDULED_TASK_LIST_BOX_MODEL_PROPERTY:
		tasks_widgets_scheduled_task_list_box_set_model (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

