/* Thumbnailer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Thumbnailer.vala, do not modify */

/* Thumbnailer.vala
 *
 * Copyright 2023 Diego Iván <diegoivan.mae@gmail.com>
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <poppler.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PAPER_CLIP_SERVICES_TYPE_THUMBNAILER (paper_clip_services_thumbnailer_get_type ())
#define PAPER_CLIP_SERVICES_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAPER_CLIP_SERVICES_TYPE_THUMBNAILER, PaperClipServicesThumbnailer))
#define PAPER_CLIP_SERVICES_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAPER_CLIP_SERVICES_TYPE_THUMBNAILER, PaperClipServicesThumbnailerClass))
#define PAPER_CLIP_SERVICES_IS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAPER_CLIP_SERVICES_TYPE_THUMBNAILER))
#define PAPER_CLIP_SERVICES_IS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAPER_CLIP_SERVICES_TYPE_THUMBNAILER))
#define PAPER_CLIP_SERVICES_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAPER_CLIP_SERVICES_TYPE_THUMBNAILER, PaperClipServicesThumbnailerClass))

typedef struct _PaperClipServicesThumbnailer PaperClipServicesThumbnailer;
typedef struct _PaperClipServicesThumbnailerClass PaperClipServicesThumbnailerClass;
typedef struct _PaperClipServicesThumbnailerPrivate PaperClipServicesThumbnailerPrivate;
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _paper_clip_services_thumbnailer_unref0(var) ((var == NULL) ? NULL : (var = (paper_clip_services_thumbnailer_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef gpointer (*ThreadManagerThreadFunc) (gpointer user_data, GError** error);
typedef struct _PaperClipServicesThumbnailerCreateThumbnailData PaperClipServicesThumbnailerCreateThumbnailData;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
typedef struct _PaperClipServicesParamSpecThumbnailer PaperClipServicesParamSpecThumbnailer;

#define PAPER_CLIP_TYPE_THUMBNAIL_ERROR (paper_clip_thumbnail_error_get_type ())

struct _PaperClipServicesThumbnailer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PaperClipServicesThumbnailerPrivate * priv;
};

struct _PaperClipServicesThumbnailerClass {
	GTypeClass parent_class;
	void (*finalize) (PaperClipServicesThumbnailer *self);
};

struct _PaperClipServicesThumbnailerPrivate {
	gfloat area_threshold;
	gint _max_size;
	GdkMemoryFormat* _default_format;
};

struct _Block3Data {
	int _ref_count_;
	PaperClipServicesThumbnailer* self;
	cairo_surface_t* surface;
	cairo_t* context;
	PopplerPage* page;
	gpointer _async_data_;
};

struct _PaperClipServicesThumbnailerCreateThumbnailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PaperClipServicesThumbnailer* self;
	PopplerPage* page;
	gchar* basename;
	GdkTexture* result;
	Block3Data* _data3_;
	gfloat max_area;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gdouble height;
	gdouble width;
	gdouble image_area;
	gdouble _tmp4_;
	gdouble _tmp5_;
	cairo_surface_t* _tmp6_;
	cairo_surface_t* _tmp7_;
	cairo_t* _tmp8_;
	GdkTexture* retval;
	GdkTexture* _tmp9_;
	gpointer _tmp10_;
	GdkTexture* _tmp11_;
	GdkTexture* _tmp12_;
	gpointer _tmp13_;
	GdkTexture* _tmp14_;
	GError* _inner_error0_;
};

struct _PaperClipServicesParamSpecThumbnailer {
	GParamSpec parent_instance;
};

typedef enum  {
	PAPER_CLIP_THUMBNAIL_ERROR_FAILED_EXPORT,
	PAPER_CLIP_THUMBNAIL_ERROR_FAILED_TO_CACHE
} PaperClipThumbnailError;
#define PAPER_CLIP_THUMBNAIL_ERROR paper_clip_thumbnail_error_quark ()

static gint PaperClipServicesThumbnailer_private_offset;
static gpointer paper_clip_services_thumbnailer_parent_class = NULL;
VALA_EXTERN PaperClipServicesThumbnailer* paper_clip_services_thumbnailer_instance;
PaperClipServicesThumbnailer* paper_clip_services_thumbnailer_instance = NULL;

VALA_EXTERN gpointer paper_clip_services_thumbnailer_ref (gpointer instance);
VALA_EXTERN void paper_clip_services_thumbnailer_unref (gpointer instance);
VALA_EXTERN GParamSpec* paper_clip_services_param_spec_thumbnailer (const gchar* name,
                                                        const gchar* nick,
                                                        const gchar* blurb,
                                                        GType object_type,
                                                        GParamFlags flags);
VALA_EXTERN void paper_clip_services_value_set_thumbnailer (GValue* value,
                                                gpointer v_object);
VALA_EXTERN void paper_clip_services_value_take_thumbnailer (GValue* value,
                                                 gpointer v_object);
VALA_EXTERN gpointer paper_clip_services_value_get_thumbnailer (const GValue* value);
VALA_EXTERN GType paper_clip_services_thumbnailer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PaperClipServicesThumbnailer, paper_clip_services_thumbnailer_unref)
VALA_EXTERN PaperClipServicesThumbnailer* paper_clip_services_thumbnailer_get_default (void);
VALA_EXTERN PaperClipServicesThumbnailer* paper_clip_services_thumbnailer_new (void);
VALA_EXTERN PaperClipServicesThumbnailer* paper_clip_services_thumbnailer_construct (GType object_type);
static void paper_clip_services_thumbnailer_create_thumbnail_data_free (gpointer _data);
VALA_EXTERN void paper_clip_services_thumbnailer_create_thumbnail (PaperClipServicesThumbnailer* self,
                                                       PopplerPage* page,
                                                       const gchar* basename,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
VALA_EXTERN GdkTexture* paper_clip_services_thumbnailer_create_thumbnail_finish (PaperClipServicesThumbnailer* self,
                                                                     GAsyncResult* _res_,
                                                                     GError** error);
static gboolean paper_clip_services_thumbnailer_create_thumbnail_co (PaperClipServicesThumbnailerCreateThumbnailData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN gint paper_clip_services_thumbnailer_get_max_size (PaperClipServicesThumbnailer* self);
VALA_EXTERN void thread_manager_run_in_thread (GType g_type,
                                   GBoxedCopyFunc g_dup_func,
                                   GDestroyNotify g_destroy_func,
                                   ThreadManagerThreadFunc thread_func,
                                   gpointer thread_func_target,
                                   GDestroyNotify thread_func_target_destroy_notify,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN gpointer thread_manager_run_in_thread_finish (GAsyncResult* _res_,
                                              GError** error);
static void __lambda8_ (Block3Data* _data3_,
                 GError** error);
static gpointer ___lambda8__thread_manager_thread_func (gpointer self,
                                                 GError** error);
static void paper_clip_services_thumbnailer_create_thumbnail_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static GdkTexture* ___lambda9_ (Block3Data* _data3_,
                         GError** error);
static GdkTexture* paper_clip_services_thumbnailer_load_scaled (PaperClipServicesThumbnailer* self,
                                                         cairo_surface_t* surface,
                                                         GError** error);
static gpointer ____lambda9__thread_manager_thread_func (gpointer self,
                                                  GError** error);
static GdkTexture* ___lambda10_ (Block3Data* _data3_,
                          GError** error);
static GdkTexture* paper_clip_services_thumbnailer_load_memory (PaperClipServicesThumbnailer* self,
                                                         cairo_surface_t* surface,
                                                         GError** error);
static gpointer ____lambda10__thread_manager_thread_func (gpointer self,
                                                   GError** error);
static guint8* paper_clip_services_thumbnailer_create_sized_copy (PaperClipServicesThumbnailer* self,
                                                           guint8* data,
                                                           gsize size,
                                                           gint* result_length1);
static GdkMemoryFormat paper_clip_services_thumbnailer_get_default_format (PaperClipServicesThumbnailer* self);
VALA_EXTERN void paper_clip_services_thumbnailer_set_max_size (PaperClipServicesThumbnailer* self,
                                                   gint value);
static GdkMemoryFormat* _gdk_memory_format_dup (GdkMemoryFormat* self);
static void paper_clip_services_thumbnailer_finalize (PaperClipServicesThumbnailer * obj);
static GType paper_clip_services_thumbnailer_get_type_once (void);
VALA_EXTERN GQuark paper_clip_thumbnail_error_quark (void);
VALA_EXTERN GType paper_clip_thumbnail_error_get_type (void) G_GNUC_CONST ;

static inline gpointer
paper_clip_services_thumbnailer_get_instance_private (PaperClipServicesThumbnailer* self)
{
	return G_STRUCT_MEMBER_P (self, PaperClipServicesThumbnailer_private_offset);
}

static gpointer
_paper_clip_services_thumbnailer_ref0 (gpointer self)
{
	return self ? paper_clip_services_thumbnailer_ref (self) : NULL;
}

PaperClipServicesThumbnailer*
paper_clip_services_thumbnailer_get_default (void)
{
	PaperClipServicesThumbnailer* _tmp0_;
	PaperClipServicesThumbnailer* _tmp2_;
	PaperClipServicesThumbnailer* _tmp3_;
	PaperClipServicesThumbnailer* result;
	_tmp0_ = paper_clip_services_thumbnailer_instance;
	if (_tmp0_ == NULL) {
		PaperClipServicesThumbnailer* _tmp1_;
		_tmp1_ = paper_clip_services_thumbnailer_new ();
		_paper_clip_services_thumbnailer_unref0 (paper_clip_services_thumbnailer_instance);
		paper_clip_services_thumbnailer_instance = _tmp1_;
	}
	_tmp2_ = paper_clip_services_thumbnailer_instance;
	_tmp3_ = _paper_clip_services_thumbnailer_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

PaperClipServicesThumbnailer*
paper_clip_services_thumbnailer_construct (GType object_type)
{
	PaperClipServicesThumbnailer* self = NULL;
	self = (PaperClipServicesThumbnailer*) g_type_create_instance (object_type);
	return self;
}

PaperClipServicesThumbnailer*
paper_clip_services_thumbnailer_new (void)
{
	return paper_clip_services_thumbnailer_construct (PAPER_CLIP_SERVICES_TYPE_THUMBNAILER);
}

static void
paper_clip_services_thumbnailer_create_thumbnail_data_free (gpointer _data)
{
	PaperClipServicesThumbnailerCreateThumbnailData* _data_;
	_data_ = _data;
	_g_free0 (_data_->basename);
	_g_object_unref0 (_data_->result);
	_paper_clip_services_thumbnailer_unref0 (_data_->self);
	g_slice_free (PaperClipServicesThumbnailerCreateThumbnailData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
paper_clip_services_thumbnailer_create_thumbnail (PaperClipServicesThumbnailer* self,
                                                  PopplerPage* page,
                                                  const gchar* basename,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	PaperClipServicesThumbnailerCreateThumbnailData* _data_;
	PaperClipServicesThumbnailer* _tmp0_;
	PopplerPage* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	g_return_if_fail (basename != NULL);
	_data_ = g_slice_new0 (PaperClipServicesThumbnailerCreateThumbnailData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, paper_clip_services_thumbnailer_create_thumbnail_data_free);
	_tmp0_ = _paper_clip_services_thumbnailer_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (page);
	_g_object_unref0 (_data_->page);
	_data_->page = _tmp1_;
	_tmp2_ = g_strdup (basename);
	_g_free0 (_data_->basename);
	_data_->basename = _tmp2_;
	paper_clip_services_thumbnailer_create_thumbnail_co (_data_);
}

GdkTexture*
paper_clip_services_thumbnailer_create_thumbnail_finish (PaperClipServicesThumbnailer* self,
                                                         GAsyncResult* _res_,
                                                         GError** error)
{
	GdkTexture* result;
	PaperClipServicesThumbnailerCreateThumbnailData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		PaperClipServicesThumbnailer* self;
		self = _data3_->self;
		_cairo_destroy0 (_data3_->context);
		_cairo_surface_destroy0 (_data3_->surface);
		_g_object_unref0 (_data3_->page);
		_paper_clip_services_thumbnailer_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda8_ (Block3Data* _data3_,
            GError** error)
{
	PaperClipServicesThumbnailer* self;
	cairo_t* _tmp0_;
	self = _data3_->self;
	_tmp0_ = _data3_->context;
	poppler_page_render (_data3_->page, (cairo_t*) _tmp0_);
}

static gpointer
___lambda8__thread_manager_thread_func (gpointer self,
                                        GError** error)
{
	gpointer result;
	__lambda8_ (self, error);
	result = NULL;
	return result;
}

static void
paper_clip_services_thumbnailer_create_thumbnail_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	PaperClipServicesThumbnailerCreateThumbnailData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	paper_clip_services_thumbnailer_create_thumbnail_co (_data_);
}

static GdkTexture*
___lambda9_ (Block3Data* _data3_,
             GError** error)
{
	PaperClipServicesThumbnailer* self;
	GdkTexture* _tmp0_ = NULL;
	cairo_surface_t* _tmp1_;
	GdkTexture* _tmp2_;
	GdkTexture* _tmp3_;
	GError* _inner_error0_ = NULL;
	GdkTexture* result;
	self = _data3_->self;
	_tmp1_ = _data3_->surface;
	_tmp2_ = paper_clip_services_thumbnailer_load_scaled (self, _tmp1_, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static gpointer
____lambda9__thread_manager_thread_func (gpointer self,
                                         GError** error)
{
	gpointer result;
	result = ___lambda9_ (self, error);
	return result;
}

static GdkTexture*
___lambda10_ (Block3Data* _data3_,
              GError** error)
{
	PaperClipServicesThumbnailer* self;
	GdkTexture* _tmp0_ = NULL;
	cairo_surface_t* _tmp1_;
	GdkTexture* _tmp2_;
	GdkTexture* _tmp3_;
	GError* _inner_error0_ = NULL;
	GdkTexture* result;
	self = _data3_->self;
	_tmp1_ = _data3_->surface;
	_tmp2_ = paper_clip_services_thumbnailer_load_memory (self, _tmp1_, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static gpointer
____lambda10__thread_manager_thread_func (gpointer self,
                                          GError** error)
{
	gpointer result;
	result = ___lambda10_ (self, error);
	return result;
}

static gboolean
paper_clip_services_thumbnailer_create_thumbnail_co (PaperClipServicesThumbnailerCreateThumbnailData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data3_ = g_slice_new0 (Block3Data);
	_data_->_data3_->_ref_count_ = 1;
	_data_->_data3_->self = paper_clip_services_thumbnailer_ref (_data_->self);
	_g_object_unref0 (_data_->_data3_->page);
	_data_->_data3_->page = _data_->page;
	_data_->_data3_->_async_data_ = _data_;
	_data_->_tmp0_ = paper_clip_services_thumbnailer_get_max_size (_data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = paper_clip_services_thumbnailer_get_max_size (_data_->self);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->max_area = (_data_->_tmp1_ * _data_->_tmp3_) * _data_->self->priv->area_threshold;
	_data_->_tmp4_ = 0.0;
	_data_->_tmp5_ = 0.0;
	poppler_page_get_size (_data_->_data3_->page, &_data_->_tmp4_, &_data_->_tmp5_);
	_data_->width = _data_->_tmp4_;
	_data_->height = _data_->_tmp5_;
	_data_->image_area = _data_->width * _data_->height;
	_data_->_tmp6_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, (gint) _data_->width, (gint) _data_->height);
	_data_->_data3_->surface = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->_data3_->surface;
	_data_->_tmp8_ = cairo_create (_data_->_tmp7_);
	_data_->_data3_->context = _data_->_tmp8_;
	_data_->_state_ = 1;
	thread_manager_run_in_thread (G_TYPE_NONE, NULL, NULL, ___lambda8__thread_manager_thread_func, block3_data_ref (_data_->_data3_), block3_data_unref, paper_clip_services_thumbnailer_create_thumbnail_ready, _data_);
	return FALSE;
	_state_1:
	thread_manager_run_in_thread_finish (_data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->image_area >= ((gdouble) _data_->max_area)) {
		g_debug ("Thumbnailer.vala:58: Image is too big! Loading it in a reduced size");
		_data_->_state_ = 2;
		thread_manager_run_in_thread (gdk_texture_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, ____lambda9__thread_manager_thread_func, block3_data_ref (_data_->_data3_), block3_data_unref, paper_clip_services_thumbnailer_create_thumbnail_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp10_ = thread_manager_run_in_thread_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp9_ = (GdkTexture*) _data_->_tmp10_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->retval);
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp11_ = _data_->_tmp9_;
		_data_->_tmp9_ = NULL;
		_g_object_unref0 (_data_->retval);
		_data_->retval = _data_->_tmp11_;
		_g_object_unref0 (_data_->_tmp9_);
	} else {
		g_debug ("Thumbnailer.vala:62: Loading image in its default size");
		_data_->_state_ = 3;
		thread_manager_run_in_thread (gdk_texture_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, ____lambda10__thread_manager_thread_func, block3_data_ref (_data_->_data3_), block3_data_unref, paper_clip_services_thumbnailer_create_thumbnail_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp13_ = thread_manager_run_in_thread_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp12_ = (GdkTexture*) _data_->_tmp13_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->retval);
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp14_ = _data_->_tmp12_;
		_data_->_tmp12_ = NULL;
		_g_object_unref0 (_data_->retval);
		_data_->retval = _data_->_tmp14_;
		_g_object_unref0 (_data_->_tmp12_);
	}
	_data_->result = _data_->retval;
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GdkTexture*
paper_clip_services_thumbnailer_load_scaled (PaperClipServicesThumbnailer* self,
                                             cairo_surface_t* surface,
                                             GError** error)
{
	gfloat max_area = 0.0F;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint width = 0;
	gint height = 0;
	gfloat scale_factor = 0.0F;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gfloat scaled_height = 0.0F;
	gfloat scaled_width = 0.0F;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp19_;
	GdkPixbuf* scaled_pixbuf = NULL;
	GdkPixbuf* _tmp20_;
	GdkTexture* texture = NULL;
	GdkTexture* _tmp21_;
	GdkTexture* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (surface != NULL, NULL);
	_tmp0_ = paper_clip_services_thumbnailer_get_max_size (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = paper_clip_services_thumbnailer_get_max_size (self);
	_tmp3_ = _tmp2_;
	max_area = (_tmp1_ * _tmp3_) * self->priv->area_threshold;
	width = cairo_image_surface_get_width (surface);
	height = cairo_image_surface_get_height (surface);
	scale_factor = 0.1f;
	{
		gboolean _tmp4_ = FALSE;
		_tmp4_ = TRUE;
		while (TRUE) {
			gfloat scaled_area = 0.0F;
			if (!_tmp4_) {
				scale_factor += 0.1f;
			}
			_tmp4_ = FALSE;
			if (!(scale_factor < 0.8f)) {
				break;
			}
			scaled_area = (height * width) * scale_factor;
			if (scaled_area >= max_area) {
				break;
			}
		}
	}
	_tmp5_ = g_strdup_printf ("%g", scale_factor);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat ("Loading image at scale ", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	g_debug ("Thumbnailer.vala:81: %s", _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	scaled_height = height * scale_factor;
	scaled_width = width * scale_factor;
	_tmp9_ = g_strdup_printf ("%i", height);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup_printf ("%g", scaled_height);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("%i", width);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup_printf ("%g", scaled_width);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat ("Height: ", _tmp10_, " -> ", _tmp12_, ". Width: ", _tmp14_, " -> ", _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	g_debug ("Thumbnailer.vala:83: %s", _tmp18_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp19_ = gdk_pixbuf_get_from_surface (surface, 0, 0, width, height);
	pixbuf = _tmp19_;
	_tmp20_ = gdk_pixbuf_scale_simple (pixbuf, (gint) scaled_width, (gint) scaled_height, GDK_INTERP_BILINEAR);
	scaled_pixbuf = _tmp20_;
	_tmp21_ = gdk_texture_new_for_pixbuf (scaled_pixbuf);
	texture = _tmp21_;
	result = texture;
	_g_object_unref0 (scaled_pixbuf);
	_g_object_unref0 (pixbuf);
	return result;
}

static GdkTexture*
paper_clip_services_thumbnailer_load_memory (PaperClipServicesThumbnailer* self,
                                             cairo_surface_t* surface,
                                             GError** error)
{
	gint height = 0;
	gint width = 0;
	gsize size = 0UL;
	GBytes* bytes = NULL;
	guchar* _tmp0_;
	gint _tmp1_ = 0;
	guint8* _tmp2_;
	GBytes* _tmp3_;
	GdkMemoryTexture* memory_texture = NULL;
	GdkMemoryFormat _tmp4_;
	GdkMemoryFormat _tmp5_;
	GdkMemoryTexture* _tmp6_;
	GdkTexture* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (surface != NULL, NULL);
	height = cairo_image_surface_get_height (surface);
	width = cairo_image_surface_get_width (surface);
	size = (gsize) ((height * width) * 4);
	_tmp0_ = cairo_image_surface_get_data (surface);
	_tmp2_ = paper_clip_services_thumbnailer_create_sized_copy (self, _tmp0_, size, &_tmp1_);
	_tmp3_ = g_bytes_new_take (_tmp2_, _tmp1_);
	bytes = _tmp3_;
	_tmp4_ = paper_clip_services_thumbnailer_get_default_format (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = (GdkMemoryTexture*) gdk_memory_texture_new (width, height, _tmp5_, bytes, (gsize) cairo_image_surface_get_stride (surface));
	memory_texture = _tmp6_;
	result = (GdkTexture*) memory_texture;
	_g_bytes_unref0 (bytes);
	return result;
}

static guint8*
paper_clip_services_thumbnailer_create_sized_copy (PaperClipServicesThumbnailer* self,
                                                   guint8* data,
                                                   gsize size,
                                                   gint* result_length1)
{
	guint8* copy = NULL;
	guint8* _tmp0_;
	gint copy_length1;
	gint _copy_size_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (guint8, size);
	copy = _tmp0_;
	copy_length1 = size;
	_copy_size_ = copy_length1;
	{
		gsize i = 0UL;
		i = (gsize) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				guint8* _tmp3_;
				gint _tmp3__length1;
				guint8 _tmp4_;
				if (!_tmp1_) {
					gsize _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < size)) {
					break;
				}
				_tmp3_ = copy;
				_tmp3__length1 = copy_length1;
				_tmp4_ = data[i];
				_tmp3_[i] = _tmp4_;
			}
		}
	}
	_tmp5_ = copy;
	_tmp5__length1 = copy_length1;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}

gint
paper_clip_services_thumbnailer_get_max_size (PaperClipServicesThumbnailer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_max_size;
	return result;
}

void
paper_clip_services_thumbnailer_set_max_size (PaperClipServicesThumbnailer* self,
                                              gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_max_size = value;
}

static GdkMemoryFormat*
_gdk_memory_format_dup (GdkMemoryFormat* self)
{
	GdkMemoryFormat* dup;
	dup = g_new0 (GdkMemoryFormat, 1);
	memcpy (dup, self, sizeof (GdkMemoryFormat));
	return dup;
}

static gpointer
__gdk_memory_format_dup0 (gpointer self)
{
	return self ? _gdk_memory_format_dup (self) : NULL;
}

static GdkMemoryFormat
paper_clip_services_thumbnailer_get_default_format (PaperClipServicesThumbnailer* self)
{
	GdkMemoryFormat result;
	GdkMemoryFormat* _tmp0_;
	GdkMemoryFormat* _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_default_format;
	if (_tmp0_ == NULL) {
		if (G_BYTE_ORDER == G_LITTLE_ENDIAN) {
			GdkMemoryFormat _tmp1_;
			GdkMemoryFormat* _tmp2_;
			_tmp1_ = GDK_MEMORY_B8G8R8A8_PREMULTIPLIED;
			_tmp2_ = __gdk_memory_format_dup0 (&_tmp1_);
			_g_free0 (self->priv->_default_format);
			self->priv->_default_format = _tmp2_;
		} else {
			GdkMemoryFormat _tmp3_;
			GdkMemoryFormat* _tmp4_;
			_tmp3_ = GDK_MEMORY_A8R8G8B8_PREMULTIPLIED;
			_tmp4_ = __gdk_memory_format_dup0 (&_tmp3_);
			_g_free0 (self->priv->_default_format);
			self->priv->_default_format = _tmp4_;
		}
	}
	_tmp5_ = self->priv->_default_format;
	result = *_tmp5_;
	return result;
}

static void
paper_clip_services_value_thumbnailer_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
paper_clip_services_value_thumbnailer_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		paper_clip_services_thumbnailer_unref (value->data[0].v_pointer);
	}
}

static void
paper_clip_services_value_thumbnailer_copy_value (const GValue* src_value,
                                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = paper_clip_services_thumbnailer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
paper_clip_services_value_thumbnailer_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
paper_clip_services_value_thumbnailer_collect_value (GValue* value,
                                                     guint n_collect_values,
                                                     GTypeCValue* collect_values,
                                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PaperClipServicesThumbnailer * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = paper_clip_services_thumbnailer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
paper_clip_services_value_thumbnailer_lcopy_value (const GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	PaperClipServicesThumbnailer ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = paper_clip_services_thumbnailer_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
paper_clip_services_param_spec_thumbnailer (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags)
{
	PaperClipServicesParamSpecThumbnailer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PAPER_CLIP_SERVICES_TYPE_THUMBNAILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
paper_clip_services_value_get_thumbnailer (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PAPER_CLIP_SERVICES_TYPE_THUMBNAILER), NULL);
	return value->data[0].v_pointer;
}

void
paper_clip_services_value_set_thumbnailer (GValue* value,
                                           gpointer v_object)
{
	PaperClipServicesThumbnailer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PAPER_CLIP_SERVICES_TYPE_THUMBNAILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PAPER_CLIP_SERVICES_TYPE_THUMBNAILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		paper_clip_services_thumbnailer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		paper_clip_services_thumbnailer_unref (old);
	}
}

void
paper_clip_services_value_take_thumbnailer (GValue* value,
                                            gpointer v_object)
{
	PaperClipServicesThumbnailer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PAPER_CLIP_SERVICES_TYPE_THUMBNAILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PAPER_CLIP_SERVICES_TYPE_THUMBNAILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		paper_clip_services_thumbnailer_unref (old);
	}
}

static void
paper_clip_services_thumbnailer_class_init (PaperClipServicesThumbnailerClass * klass,
                                            gpointer klass_data)
{
	paper_clip_services_thumbnailer_parent_class = g_type_class_peek_parent (klass);
	((PaperClipServicesThumbnailerClass *) klass)->finalize = paper_clip_services_thumbnailer_finalize;
	g_type_class_adjust_private_offset (klass, &PaperClipServicesThumbnailer_private_offset);
}

static void
paper_clip_services_thumbnailer_instance_init (PaperClipServicesThumbnailer * self,
                                               gpointer klass)
{
	self->priv = paper_clip_services_thumbnailer_get_instance_private (self);
	self->priv->area_threshold = 2.5f;
	self->priv->_default_format = NULL;
	self->ref_count = 1;
}

static void
paper_clip_services_thumbnailer_finalize (PaperClipServicesThumbnailer * obj)
{
	PaperClipServicesThumbnailer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAPER_CLIP_SERVICES_TYPE_THUMBNAILER, PaperClipServicesThumbnailer);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_default_format);
}

static GType
paper_clip_services_thumbnailer_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { paper_clip_services_value_thumbnailer_init, paper_clip_services_value_thumbnailer_free_value, paper_clip_services_value_thumbnailer_copy_value, paper_clip_services_value_thumbnailer_peek_pointer, "p", paper_clip_services_value_thumbnailer_collect_value, "p", paper_clip_services_value_thumbnailer_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PaperClipServicesThumbnailerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) paper_clip_services_thumbnailer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PaperClipServicesThumbnailer), 0, (GInstanceInitFunc) paper_clip_services_thumbnailer_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType paper_clip_services_thumbnailer_type_id;
	paper_clip_services_thumbnailer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PaperClipServicesThumbnailer", &g_define_type_info, &g_define_type_fundamental_info, 0);
	PaperClipServicesThumbnailer_private_offset = g_type_add_instance_private (paper_clip_services_thumbnailer_type_id, sizeof (PaperClipServicesThumbnailerPrivate));
	return paper_clip_services_thumbnailer_type_id;
}

GType
paper_clip_services_thumbnailer_get_type (void)
{
	static volatile gsize paper_clip_services_thumbnailer_type_id__once = 0;
	if (g_once_init_enter (&paper_clip_services_thumbnailer_type_id__once)) {
		GType paper_clip_services_thumbnailer_type_id;
		paper_clip_services_thumbnailer_type_id = paper_clip_services_thumbnailer_get_type_once ();
		g_once_init_leave (&paper_clip_services_thumbnailer_type_id__once, paper_clip_services_thumbnailer_type_id);
	}
	return paper_clip_services_thumbnailer_type_id__once;
}

gpointer
paper_clip_services_thumbnailer_ref (gpointer instance)
{
	PaperClipServicesThumbnailer * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
paper_clip_services_thumbnailer_unref (gpointer instance)
{
	PaperClipServicesThumbnailer * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PAPER_CLIP_SERVICES_THUMBNAILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

GQuark
paper_clip_thumbnail_error_quark (void)
{
	return g_quark_from_static_string ("paper-clip-thumbnail-error-quark");
}

static GType
paper_clip_thumbnail_error_get_type_once (void)
{
	static const GEnumValue values[] = {{PAPER_CLIP_THUMBNAIL_ERROR_FAILED_EXPORT, "PAPER_CLIP_THUMBNAIL_ERROR_FAILED_EXPORT", "failed-export"}, {PAPER_CLIP_THUMBNAIL_ERROR_FAILED_TO_CACHE, "PAPER_CLIP_THUMBNAIL_ERROR_FAILED_TO_CACHE", "failed-to-cache"}, {0, NULL, NULL}};
	GType paper_clip_thumbnail_error_type_id;
	paper_clip_thumbnail_error_type_id = g_enum_register_static ("PaperClipThumbnailError", values);
	return paper_clip_thumbnail_error_type_id;
}

GType
paper_clip_thumbnail_error_get_type (void)
{
	static volatile gsize paper_clip_thumbnail_error_type_id__once = 0;
	if (g_once_init_enter (&paper_clip_thumbnail_error_type_id__once)) {
		GType paper_clip_thumbnail_error_type_id;
		paper_clip_thumbnail_error_type_id = paper_clip_thumbnail_error_get_type_once ();
		g_once_init_leave (&paper_clip_thumbnail_error_type_id__once, paper_clip_thumbnail_error_type_id);
	}
	return paper_clip_thumbnail_error_type_id__once;
}

