// python wrapper for vtkResampledAMRImageSource
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkResampledAMRImageSource.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkResampledAMRImageSource(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkResampledAMRImageSource_ClassNew(); }


static PyObject *
PyvtkResampledAMRImageSource_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkResampledAMRImageSource::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkResampledAMRImageSource_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkResampledAMRImageSource *op = static_cast<vtkResampledAMRImageSource *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkResampledAMRImageSource::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkResampledAMRImageSource_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkResampledAMRImageSource *tempr = vtkResampledAMRImageSource::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkResampledAMRImageSource_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkResampledAMRImageSource *op = static_cast<vtkResampledAMRImageSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkResampledAMRImageSource *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkResampledAMRImageSource::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkResampledAMRImageSource_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkResampledAMRImageSource::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkResampledAMRImageSource_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkResampledAMRImageSource *op = static_cast<vtkResampledAMRImageSource *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkResampledAMRImageSource::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkResampledAMRImageSource_SetMaxDimensions_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaxDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkResampledAMRImageSource *op = static_cast<vtkResampledAMRImageSource *>(vp);

  int temp0;
  int temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetMaxDimensions(temp0, temp1, temp2);
    }
    else
    {
      op->vtkResampledAMRImageSource::SetMaxDimensions(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkResampledAMRImageSource_SetMaxDimensions_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaxDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkResampledAMRImageSource *op = static_cast<vtkResampledAMRImageSource *>(vp);

  const size_t size0 = 3;
  int temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetMaxDimensions(temp0);
    }
    else
    {
      op->vtkResampledAMRImageSource::SetMaxDimensions(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkResampledAMRImageSource_SetMaxDimensions(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkResampledAMRImageSource_SetMaxDimensions_s1(self, args);
    case 1:
      return PyvtkResampledAMRImageSource_SetMaxDimensions_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetMaxDimensions");
  return nullptr;
}


static PyObject *
PyvtkResampledAMRImageSource_GetMaxDimensions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaxDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkResampledAMRImageSource *op = static_cast<vtkResampledAMRImageSource *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetMaxDimensions() :
      op->vtkResampledAMRImageSource::GetMaxDimensions());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkResampledAMRImageSource_SetSpatialBounds_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSpatialBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkResampledAMRImageSource *op = static_cast<vtkResampledAMRImageSource *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  double temp4;
  double temp5;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(6) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4) &&
      ap.GetValue(temp5))
  {
    if (ap.IsBound())
    {
      op->SetSpatialBounds(temp0, temp1, temp2, temp3, temp4, temp5);
    }
    else
    {
      op->vtkResampledAMRImageSource::SetSpatialBounds(temp0, temp1, temp2, temp3, temp4, temp5);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkResampledAMRImageSource_SetSpatialBounds_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSpatialBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkResampledAMRImageSource *op = static_cast<vtkResampledAMRImageSource *>(vp);

  const size_t size0 = 6;
  double temp0[6];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetSpatialBounds(temp0);
    }
    else
    {
      op->vtkResampledAMRImageSource::SetSpatialBounds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkResampledAMRImageSource_SetSpatialBounds(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 6:
      return PyvtkResampledAMRImageSource_SetSpatialBounds_s1(self, args);
    case 1:
      return PyvtkResampledAMRImageSource_SetSpatialBounds_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetSpatialBounds");
  return nullptr;
}


static PyObject *
PyvtkResampledAMRImageSource_GetSpatialBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSpatialBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkResampledAMRImageSource *op = static_cast<vtkResampledAMRImageSource *>(vp);

  size_t sizer = 6;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetSpatialBounds() :
      op->vtkResampledAMRImageSource::GetSpatialBounds());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkResampledAMRImageSource_Reset(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Reset");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkResampledAMRImageSource *op = static_cast<vtkResampledAMRImageSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Reset();
    }
    else
    {
      op->vtkResampledAMRImageSource::Reset();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkResampledAMRImageSource_UpdateResampledVolume(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateResampledVolume");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkResampledAMRImageSource *op = static_cast<vtkResampledAMRImageSource *>(vp);

  vtkOverlappingAMR *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkOverlappingAMR"))
  {
    if (ap.IsBound())
    {
      op->UpdateResampledVolume(temp0);
    }
    else
    {
      op->vtkResampledAMRImageSource::UpdateResampledVolume(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkResampledAMRImageSource_NeedsInitialization(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NeedsInitialization");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkResampledAMRImageSource *op = static_cast<vtkResampledAMRImageSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->NeedsInitialization() :
      op->vtkResampledAMRImageSource::NeedsInitialization());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkResampledAMRImageSource_Methods[] = {
  {"IsTypeOf", PyvtkResampledAMRImageSource_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkResampledAMRImageSource_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkResampledAMRImageSource_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkResampledAMRImageSource\nC++: static vtkResampledAMRImageSource *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkResampledAMRImageSource_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkResampledAMRImageSource\nC++: vtkResampledAMRImageSource *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkResampledAMRImageSource_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkResampledAMRImageSource_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetMaxDimensions", PyvtkResampledAMRImageSource_SetMaxDimensions, METH_VARARGS,
   "SetMaxDimensions(self, _arg1:int, _arg2:int, _arg3:int) -> None\nC++: virtual void SetMaxDimensions(int _arg1, int _arg2,\n    int _arg3)\nSetMaxDimensions(self, _arg:(int, int, int)) -> None\nC++: virtual void SetMaxDimensions(const int _arg[3])\n\nGet/Set the maximum number of samples along each axis.\n"},
  {"GetMaxDimensions", PyvtkResampledAMRImageSource_GetMaxDimensions, METH_VARARGS,
   "GetMaxDimensions(self) -> (int, int, int)\nC++: virtual int *GetMaxDimensions()\n\n"},
  {"SetSpatialBounds", PyvtkResampledAMRImageSource_SetSpatialBounds, METH_VARARGS,
   "SetSpatialBounds(self, _arg1:float, _arg2:float, _arg3:float,\n    _arg4:float, _arg5:float, _arg6:float) -> None\nC++: virtual void SetSpatialBounds(double _arg1, double _arg2,\n    double _arg3, double _arg4, double _arg5, double _arg6)\nSetSpatialBounds(self, _arg:(float, float, float, float, float,\n    float)) -> None\nC++: virtual void SetSpatialBounds(const double _arg[6])\n\nWhen provided, the resampled image is set up to cover these\nbounds. If not provided, data bounds are used. If provided, these\nbounds *MUST* fit within the data bounds. This is essential to\nensure valid resampled volume is generated.\n"},
  {"GetSpatialBounds", PyvtkResampledAMRImageSource_GetSpatialBounds, METH_VARARGS,
   "GetSpatialBounds(self) -> (float, float, float, float, float,\n    float)\nC++: virtual double *GetSpatialBounds()\n\n"},
  {"Reset", PyvtkResampledAMRImageSource_Reset, METH_VARARGS,
   "Reset(self) -> None\nC++: void Reset()\n\nTo restart the incremental resample process, call this method.\nThe output image data is setup in the first call to Update().\n"},
  {"UpdateResampledVolume", PyvtkResampledAMRImageSource_UpdateResampledVolume, METH_VARARGS,
   "UpdateResampledVolume(self, __a:vtkOverlappingAMR) -> None\nC++: void UpdateResampledVolume(vtkOverlappingAMR *)\n\nUpdates the volume. Any non-empty pieces provided by the amr are\nadded to the resampled volume if it adds refinement to the\nvolume.\n"},
  {"NeedsInitialization", PyvtkResampledAMRImageSource_NeedsInitialization, METH_VARARGS,
   "NeedsInitialization(self) -> bool\nC++: bool NeedsInitialization()\n\nReturns true if the resampler will reinitialize the volume in the\nnext call to UpdateResampledVolume().\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkResampledAMRImageSource_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("max_dimensions"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkResampledAMRImageSource_GetMaxDimensions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkResampledAMRImageSource_SetMaxDimensions(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkResampledAMRImageSource_SetMaxDimensions(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaxDimensions/SetMaxDimensions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("spatial_bounds"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkResampledAMRImageSource_GetSpatialBounds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkResampledAMRImageSource_SetSpatialBounds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkResampledAMRImageSource_SetSpatialBounds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSpatialBounds/SetSpatialBounds\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkResampledAMRImageSource_Doc =
  "vtkResampledAMRImageSource - image data source that resamples an AMR\ndataset to produce the image data.\n\n"
  "Superclass: vtkTrivialProducer\n\n"
  "vtkResampledAMRImageSource is a image data source that resamples a\n"
  "vtkOverlappingAMR dataset to produce an image data. The output AMR\n"
  "will have both the point data and cell data from the input AMR grids\n"
  "passed along as point data for the output image data. This filter\n"
  "assumes that all blocks in the input AMR have exactly the same\n"
  "point/cell arrays in same order. If they are different we will end up\n"
  "with weird runtime issues that may be hard to debug.\n\n"
  "@attention We subclass vtkTrivialProducer since it deals with all the\n"
  "meta-data that needs to be passed down the pipeline for image data,\n"
  "keeping the code here simple.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkResampledAMRImageSource_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersRendering.vtkResampledAMRImageSource", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkResampledAMRImageSource_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkResampledAMRImageSource_StaticNew()
{
  return vtkResampledAMRImageSource::New();
}

PyObject *PyvtkResampledAMRImageSource_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkResampledAMRImageSource_Type, PyvtkResampledAMRImageSource_Methods,
    "vtkResampledAMRImageSource",
 &PyvtkResampledAMRImageSource_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkTrivialProducer");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkResampledAMRImageSource_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkResampledAMRImageSource(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkResampledAMRImageSource_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkResampledAMRImageSource", o) != 0)
  {
    Py_DECREF(o);
  }

}

