// python wrapper for vtkDisplayConfiguration
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkTuple.h"
#include "vtkDisplayConfiguration.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkDisplayConfiguration(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkDisplayConfiguration_ClassNew(); }


static PyObject *
PyvtkDisplayConfiguration_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkDisplayConfiguration::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkDisplayConfiguration_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDisplayConfiguration *op = static_cast<vtkDisplayConfiguration *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkDisplayConfiguration::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkDisplayConfiguration_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkDisplayConfiguration *tempr = vtkDisplayConfiguration::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkDisplayConfiguration_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDisplayConfiguration *op = static_cast<vtkDisplayConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDisplayConfiguration *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkDisplayConfiguration::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkDisplayConfiguration_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkDisplayConfiguration::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkDisplayConfiguration_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDisplayConfiguration *op = static_cast<vtkDisplayConfiguration *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkDisplayConfiguration::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkDisplayConfiguration_GetShowBorders(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetShowBorders");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDisplayConfiguration *op = static_cast<vtkDisplayConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetShowBorders() :
      op->vtkDisplayConfiguration::GetShowBorders());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkDisplayConfiguration_GetFullScreen(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFullScreen");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDisplayConfiguration *op = static_cast<vtkDisplayConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetFullScreen() :
      op->vtkDisplayConfiguration::GetFullScreen());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkDisplayConfiguration_GetEyeSeparation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEyeSeparation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDisplayConfiguration *op = static_cast<vtkDisplayConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetEyeSeparation() :
      op->vtkDisplayConfiguration::GetEyeSeparation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkDisplayConfiguration_GetNumberOfDisplays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfDisplays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDisplayConfiguration *op = static_cast<vtkDisplayConfiguration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfDisplays() :
      op->vtkDisplayConfiguration::GetNumberOfDisplays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkDisplayConfiguration_GetEnvironment(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnvironment");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDisplayConfiguration *op = static_cast<vtkDisplayConfiguration *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetEnvironment(temp0) :
      op->vtkDisplayConfiguration::GetEnvironment(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkDisplayConfiguration_GetGeometry(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGeometry");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDisplayConfiguration *op = static_cast<vtkDisplayConfiguration *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkTuple<int, 4> tempr = (ap.IsBound() ?
      op->GetGeometry(temp0) :
      op->vtkDisplayConfiguration::GetGeometry(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkTuple_IiLi4EE");
    }
  }

  return result;
}


static PyObject *
PyvtkDisplayConfiguration_GetLowerLeft(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLowerLeft");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDisplayConfiguration *op = static_cast<vtkDisplayConfiguration *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkTuple<double, 3> tempr = (ap.IsBound() ?
      op->GetLowerLeft(temp0) :
      op->vtkDisplayConfiguration::GetLowerLeft(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkTuple_IdLi3EE");
    }
  }

  return result;
}


static PyObject *
PyvtkDisplayConfiguration_GetLowerRight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLowerRight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDisplayConfiguration *op = static_cast<vtkDisplayConfiguration *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkTuple<double, 3> tempr = (ap.IsBound() ?
      op->GetLowerRight(temp0) :
      op->vtkDisplayConfiguration::GetLowerRight(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkTuple_IdLi3EE");
    }
  }

  return result;
}


static PyObject *
PyvtkDisplayConfiguration_GetUpperRight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUpperRight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDisplayConfiguration *op = static_cast<vtkDisplayConfiguration *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkTuple<double, 3> tempr = (ap.IsBound() ?
      op->GetUpperRight(temp0) :
      op->vtkDisplayConfiguration::GetUpperRight(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkTuple_IdLi3EE");
    }
  }

  return result;
}


static PyObject *
PyvtkDisplayConfiguration_GetHasCorners(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHasCorners");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDisplayConfiguration *op = static_cast<vtkDisplayConfiguration *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetHasCorners(temp0) :
      op->vtkDisplayConfiguration::GetHasCorners(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkDisplayConfiguration_GetCoverable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCoverable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDisplayConfiguration *op = static_cast<vtkDisplayConfiguration *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetCoverable(temp0) :
      op->vtkDisplayConfiguration::GetCoverable(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkDisplayConfiguration_LoadPVX(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadPVX");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDisplayConfiguration *op = static_cast<vtkDisplayConfiguration *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->LoadPVX(temp0) :
      op->vtkDisplayConfiguration::LoadPVX(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkDisplayConfiguration_Methods[] = {
  {"IsTypeOf", PyvtkDisplayConfiguration_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkDisplayConfiguration_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkDisplayConfiguration_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkDisplayConfiguration\nC++: static vtkDisplayConfiguration *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkDisplayConfiguration_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkDisplayConfiguration\nC++: vtkDisplayConfiguration *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkDisplayConfiguration_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkDisplayConfiguration_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetShowBorders", PyvtkDisplayConfiguration_GetShowBorders, METH_VARARGS,
   "GetShowBorders(self) -> bool\nC++: virtual bool GetShowBorders()\n\nGet whether to use window borders / frames are to be shown.\n"},
  {"GetFullScreen", PyvtkDisplayConfiguration_GetFullScreen, METH_VARARGS,
   "GetFullScreen(self) -> bool\nC++: virtual bool GetFullScreen()\n\nReturns true of each display should simply be full-screen. If so,\ndisplay geometry is ignored.\n"},
  {"GetEyeSeparation", PyvtkDisplayConfiguration_GetEyeSeparation, METH_VARARGS,
   "GetEyeSeparation(self) -> float\nC++: virtual double GetEyeSeparation()\n\nGet eye separation.\n"},
  {"GetNumberOfDisplays", PyvtkDisplayConfiguration_GetNumberOfDisplays, METH_VARARGS,
   "GetNumberOfDisplays(self) -> int\nC++: int GetNumberOfDisplays()\n\nReturns the count for display specified.\n"},
  {"GetEnvironment", PyvtkDisplayConfiguration_GetEnvironment, METH_VARARGS,
   "GetEnvironment(self, index:int) -> str\nC++: const char *GetEnvironment(int index)\n\nReturns information about each display specified.  The\n`Coverable` field is only used on X windows systems, and\nindicates that the window should be manageable by the window\nmanager.  This means it can be covered by other windows, and a\ntaskbar item is available to bring it back to the front.\n"},
  {"GetGeometry", PyvtkDisplayConfiguration_GetGeometry, METH_VARARGS,
   "GetGeometry(self, index:int) -> vtkTuple_IiLi4EE\nC++: vtkTuple<int, 4> GetGeometry(int index)\n\n"},
  {"GetLowerLeft", PyvtkDisplayConfiguration_GetLowerLeft, METH_VARARGS,
   "GetLowerLeft(self, index:int) -> vtkTuple_IdLi3EE\nC++: vtkTuple<double, 3> GetLowerLeft(int index)\n\n"},
  {"GetLowerRight", PyvtkDisplayConfiguration_GetLowerRight, METH_VARARGS,
   "GetLowerRight(self, index:int) -> vtkTuple_IdLi3EE\nC++: vtkTuple<double, 3> GetLowerRight(int index)\n\n"},
  {"GetUpperRight", PyvtkDisplayConfiguration_GetUpperRight, METH_VARARGS,
   "GetUpperRight(self, index:int) -> vtkTuple_IdLi3EE\nC++: vtkTuple<double, 3> GetUpperRight(int index)\n\n"},
  {"GetHasCorners", PyvtkDisplayConfiguration_GetHasCorners, METH_VARARGS,
   "GetHasCorners(self, index:int) -> bool\nC++: bool GetHasCorners(int index)\n\n"},
  {"GetCoverable", PyvtkDisplayConfiguration_GetCoverable, METH_VARARGS,
   "GetCoverable(self, index:int) -> bool\nC++: bool GetCoverable(int index)\n\n"},
  {"LoadPVX", PyvtkDisplayConfiguration_LoadPVX, METH_VARARGS,
   "LoadPVX(self, fname:str) -> bool\nC++: bool LoadPVX(const char *fname)\n\nParses a PVX file to load display configuration information.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkDisplayConfiguration_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("show_borders"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkDisplayConfiguration_GetShowBorders(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetShowBorders\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("full_screen"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkDisplayConfiguration_GetFullScreen(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFullScreen\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("eye_separation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkDisplayConfiguration_GetEyeSeparation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetEyeSeparation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_displays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkDisplayConfiguration_GetNumberOfDisplays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfDisplays\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkDisplayConfiguration_Doc =
  "vtkDisplayConfiguration - display configuration container\n\n"
  "Superclass: vtkObject\n\n"
  "vtkDisplayConfiguration is a container used by\n"
  "vtkRemotingCoreConfiguration to manage display configurations which\n"
  "are needed for CAVE and other immersive displays.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkDisplayConfiguration_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkDisplayConfiguration", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkDisplayConfiguration_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkDisplayConfiguration_StaticNew()
{
  return vtkDisplayConfiguration::New();
}

PyObject *PyvtkDisplayConfiguration_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkDisplayConfiguration_Type, PyvtkDisplayConfiguration_Methods,
    "vtkDisplayConfiguration",
 &PyvtkDisplayConfiguration_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkDisplayConfiguration_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkDisplayConfiguration(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkDisplayConfiguration_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkDisplayConfiguration", o) != 0)
  {
    Py_DECREF(o);
  }

}

