// python wrapper for vtkIceTSynchronizedRenderers
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkIceTSynchronizedRenderers.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkIceTSynchronizedRenderers(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkIceTSynchronizedRenderers_ClassNew(); }


static PyObject *
PyvtkIceTSynchronizedRenderers_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkIceTSynchronizedRenderers::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTSynchronizedRenderers_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTSynchronizedRenderers *op = static_cast<vtkIceTSynchronizedRenderers *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkIceTSynchronizedRenderers::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTSynchronizedRenderers_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkIceTSynchronizedRenderers *tempr = vtkIceTSynchronizedRenderers::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTSynchronizedRenderers_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTSynchronizedRenderers *op = static_cast<vtkIceTSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkIceTSynchronizedRenderers *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkIceTSynchronizedRenderers::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTSynchronizedRenderers_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkIceTSynchronizedRenderers::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTSynchronizedRenderers_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTSynchronizedRenderers *op = static_cast<vtkIceTSynchronizedRenderers *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkIceTSynchronizedRenderers::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTSynchronizedRenderers_SetRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTSynchronizedRenderers *op = static_cast<vtkIceTSynchronizedRenderers *>(vp);

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    if (ap.IsBound())
    {
      op->SetRenderer(temp0);
    }
    else
    {
      op->vtkIceTSynchronizedRenderers::SetRenderer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTSynchronizedRenderers_SetTileDimensions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTileDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTSynchronizedRenderers *op = static_cast<vtkIceTSynchronizedRenderers *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetTileDimensions(temp0, temp1);
    }
    else
    {
      op->vtkIceTSynchronizedRenderers::SetTileDimensions(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTSynchronizedRenderers_SetTileMullions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTileMullions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTSynchronizedRenderers *op = static_cast<vtkIceTSynchronizedRenderers *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetTileMullions(temp0, temp1);
    }
    else
    {
      op->vtkIceTSynchronizedRenderers::SetTileMullions(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTSynchronizedRenderers_SetDataReplicatedOnAllProcesses(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDataReplicatedOnAllProcesses");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTSynchronizedRenderers *op = static_cast<vtkIceTSynchronizedRenderers *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDataReplicatedOnAllProcesses(temp0);
    }
    else
    {
      op->vtkIceTSynchronizedRenderers::SetDataReplicatedOnAllProcesses(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTSynchronizedRenderers_SetOrderedCompositingHelper(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrderedCompositingHelper");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTSynchronizedRenderers *op = static_cast<vtkIceTSynchronizedRenderers *>(vp);

  vtkOrderedCompositingHelper *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkOrderedCompositingHelper"))
  {
    if (ap.IsBound())
    {
      op->SetOrderedCompositingHelper(temp0);
    }
    else
    {
      op->vtkIceTSynchronizedRenderers::SetOrderedCompositingHelper(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTSynchronizedRenderers_SetUseOrderedCompositing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseOrderedCompositing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTSynchronizedRenderers *op = static_cast<vtkIceTSynchronizedRenderers *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseOrderedCompositing(temp0);
    }
    else
    {
      op->vtkIceTSynchronizedRenderers::SetUseOrderedCompositing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTSynchronizedRenderers_SetImageReductionFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetImageReductionFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTSynchronizedRenderers *op = static_cast<vtkIceTSynchronizedRenderers *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetImageReductionFactor(temp0);
    }
    else
    {
      op->vtkIceTSynchronizedRenderers::SetImageReductionFactor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTSynchronizedRenderers_GetImageReductionFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetImageReductionFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTSynchronizedRenderers *op = static_cast<vtkIceTSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetImageReductionFactor() :
      op->vtkIceTSynchronizedRenderers::GetImageReductionFactor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTSynchronizedRenderers_SetParallelController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParallelController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTSynchronizedRenderers *op = static_cast<vtkIceTSynchronizedRenderers *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetParallelController(temp0);
    }
    else
    {
      op->vtkIceTSynchronizedRenderers::SetParallelController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTSynchronizedRenderers_SetImageProcessingPass(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetImageProcessingPass");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTSynchronizedRenderers *op = static_cast<vtkIceTSynchronizedRenderers *>(vp);

  vtkImageProcessingPass *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkImageProcessingPass"))
  {
    if (ap.IsBound())
    {
      op->SetImageProcessingPass(temp0);
    }
    else
    {
      op->vtkIceTSynchronizedRenderers::SetImageProcessingPass(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTSynchronizedRenderers_GetImageProcessingPass(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetImageProcessingPass");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTSynchronizedRenderers *op = static_cast<vtkIceTSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkImageProcessingPass *tempr = (ap.IsBound() ?
      op->GetImageProcessingPass() :
      op->vtkIceTSynchronizedRenderers::GetImageProcessingPass());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTSynchronizedRenderers_SetUseDepthBuffer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseDepthBuffer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTSynchronizedRenderers *op = static_cast<vtkIceTSynchronizedRenderers *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseDepthBuffer(temp0);
    }
    else
    {
      op->vtkIceTSynchronizedRenderers::SetUseDepthBuffer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTSynchronizedRenderers_SetRenderEmptyImages(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRenderEmptyImages");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTSynchronizedRenderers *op = static_cast<vtkIceTSynchronizedRenderers *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRenderEmptyImages(temp0);
    }
    else
    {
      op->vtkIceTSynchronizedRenderers::SetRenderEmptyImages(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTSynchronizedRenderers_SetRenderPass(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRenderPass");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTSynchronizedRenderers *op = static_cast<vtkIceTSynchronizedRenderers *>(vp);

  vtkRenderPass *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderPass"))
  {
    if (ap.IsBound())
    {
      op->SetRenderPass(temp0);
    }
    else
    {
      op->vtkIceTSynchronizedRenderers::SetRenderPass(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkIceTSynchronizedRenderers_GetRenderPass(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderPass");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTSynchronizedRenderers *op = static_cast<vtkIceTSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRenderPass *tempr = (ap.IsBound() ?
      op->GetRenderPass() :
      op->vtkIceTSynchronizedRenderers::GetRenderPass());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkIceTSynchronizedRenderers_GetIceTCompositePass(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIceTCompositePass");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkIceTSynchronizedRenderers *op = static_cast<vtkIceTSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkIceTCompositePass *tempr = (ap.IsBound() ?
      op->GetIceTCompositePass() :
      op->vtkIceTSynchronizedRenderers::GetIceTCompositePass());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkIceTSynchronizedRenderers_Methods[] = {
  {"IsTypeOf", PyvtkIceTSynchronizedRenderers_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkIceTSynchronizedRenderers_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkIceTSynchronizedRenderers_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkIceTSynchronizedRenderers\nC++: static vtkIceTSynchronizedRenderers *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkIceTSynchronizedRenderers_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkIceTSynchronizedRenderers\nC++: vtkIceTSynchronizedRenderers *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkIceTSynchronizedRenderers_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkIceTSynchronizedRenderers_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetRenderer", PyvtkIceTSynchronizedRenderers_SetRenderer, METH_VARARGS,
   "SetRenderer(self, __a:vtkRenderer) -> None\nC++: void SetRenderer(vtkRenderer *) override;\n\nSet the renderer to be synchronized by this instance. A\nvtkSynchronizedRenderers instance can be used to synchronize\nexactly 1 renderer on each processes. You can create multiple\ninstances on vtkSynchronizedRenderers to synchronize multiple\nrenderers.\n"},
  {"SetTileDimensions", PyvtkIceTSynchronizedRenderers_SetTileDimensions, METH_VARARGS,
   "SetTileDimensions(self, x:int, y:int) -> None\nC++: void SetTileDimensions(int x, int y)\n\nSet the tile dimensions. Default is (1, 1). If any of the\ndimensions is > 1 then tile display mode is assumed.\n"},
  {"SetTileMullions", PyvtkIceTSynchronizedRenderers_SetTileMullions, METH_VARARGS,
   "SetTileMullions(self, x:int, y:int) -> None\nC++: void SetTileMullions(int x, int y)\n\nSet the tile mullions. The mullions are measured in pixels. Use\nnegative numbers for overlap.\n"},
  {"SetDataReplicatedOnAllProcesses", PyvtkIceTSynchronizedRenderers_SetDataReplicatedOnAllProcesses, METH_VARARGS,
   "SetDataReplicatedOnAllProcesses(self, val:bool) -> None\nC++: void SetDataReplicatedOnAllProcesses(bool val)\n\nSet to true if data is replicated on all processes. This will\nenable IceT to minimize communications since data is available on\nall process. Off by default.\n"},
  {"SetOrderedCompositingHelper", PyvtkIceTSynchronizedRenderers_SetOrderedCompositingHelper, METH_VARARGS,
   "SetOrderedCompositingHelper(self,\n    helper:vtkOrderedCompositingHelper) -> None\nC++: void SetOrderedCompositingHelper(\n    vtkOrderedCompositingHelper *helper)\n\npartition ordering that gives processes ordering. Initial value\nis a nullptr pointer. This is used only when\nUseOrderedCompositing is true.\n"},
  {"SetUseOrderedCompositing", PyvtkIceTSynchronizedRenderers_SetUseOrderedCompositing, METH_VARARGS,
   "SetUseOrderedCompositing(self, uoc:bool) -> None\nC++: void SetUseOrderedCompositing(bool uoc)\n\nSet this to true, if compositing must be done in a specific\norder. This is necessary when rendering volumes or translucent\ngeometries. When UseOrderedCompositing is set to true, it is\nexpected that the PartitionOrdering is set as well. The\nPartitionOrdering is used to decide the process-order for\ncompositing.\n"},
  {"SetImageReductionFactor", PyvtkIceTSynchronizedRenderers_SetImageReductionFactor, METH_VARARGS,
   "SetImageReductionFactor(self, val:int) -> None\nC++: void SetImageReductionFactor(int val) override;\n\nSet the image reduction factor. Overrides superclass\nimplementation.\n"},
  {"GetImageReductionFactor", PyvtkIceTSynchronizedRenderers_GetImageReductionFactor, METH_VARARGS,
   "GetImageReductionFactor(self) -> int\nC++: int GetImageReductionFactor() override;\n\n"},
  {"SetParallelController", PyvtkIceTSynchronizedRenderers_SetParallelController, METH_VARARGS,
   "SetParallelController(self, cont:vtkMultiProcessController)\n    -> None\nC++: void SetParallelController(vtkMultiProcessController *cont)\n    override;\n\nSet the parallel message communicator. This is used to\ncommunicate among processes.\n"},
  {"SetImageProcessingPass", PyvtkIceTSynchronizedRenderers_SetImageProcessingPass, METH_VARARGS,
   "SetImageProcessingPass(self, __a:vtkImageProcessingPass) -> None\nC++: void SetImageProcessingPass(vtkImageProcessingPass *)\n\nGet/Set an image processing pass to process the rendered images.\n"},
  {"GetImageProcessingPass", PyvtkIceTSynchronizedRenderers_GetImageProcessingPass, METH_VARARGS,
   "GetImageProcessingPass(self) -> vtkImageProcessingPass\nC++: virtual vtkImageProcessingPass *GetImageProcessingPass()\n\n"},
  {"SetUseDepthBuffer", PyvtkIceTSynchronizedRenderers_SetUseDepthBuffer, METH_VARARGS,
   "SetUseDepthBuffer(self, __a:bool) -> None\nC++: void SetUseDepthBuffer(bool)\n\nActivates or de-activated the use of Depth Buffer\n"},
  {"SetRenderEmptyImages", PyvtkIceTSynchronizedRenderers_SetRenderEmptyImages, METH_VARARGS,
   "SetRenderEmptyImages(self, __a:bool) -> None\nC++: void SetRenderEmptyImages(bool)\n\nEnable/Disable empty images optimization. Render empty images is\ndisabled by default. It may be needed if a painter needs to make\nMPI global collective communication.\n"},
  {"SetRenderPass", PyvtkIceTSynchronizedRenderers_SetRenderPass, METH_VARARGS,
   "SetRenderPass(self, __a:vtkRenderPass) -> None\nC++: void SetRenderPass(vtkRenderPass *)\n\nGet/Set geometry rendering pass. This pass is used to render the\ngeometry. If none specified then default rendering pipeline is\nused. This is typically the render-pass pipeline after the\nCameraPass. The CameraPass is setup by ParaView specially since\nParaView needs some customizations for multiviews/icet etc.\n"},
  {"GetRenderPass", PyvtkIceTSynchronizedRenderers_GetRenderPass, METH_VARARGS,
   "GetRenderPass(self) -> vtkRenderPass\nC++: virtual vtkRenderPass *GetRenderPass()\n\n"},
  {"GetIceTCompositePass", PyvtkIceTSynchronizedRenderers_GetIceTCompositePass, METH_VARARGS,
   "GetIceTCompositePass(self) -> vtkIceTCompositePass\nC++: virtual vtkIceTCompositePass *GetIceTCompositePass()\n\nProvides access to the internal vtkIceTCompositePass. Only use\nthis if you know what you're doing.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkIceTSynchronizedRenderers_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("renderer"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTSynchronizedRenderers_SetRenderer(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTSynchronizedRenderers_SetRenderer(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRenderer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tile_dimensions"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTSynchronizedRenderers_SetTileDimensions(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTSynchronizedRenderers_SetTileDimensions(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTileDimensions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tile_mullions"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTSynchronizedRenderers_SetTileMullions(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTSynchronizedRenderers_SetTileMullions(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTileMullions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_replicated_on_all_processes"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTSynchronizedRenderers_SetDataReplicatedOnAllProcesses(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTSynchronizedRenderers_SetDataReplicatedOnAllProcesses(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDataReplicatedOnAllProcesses\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("ordered_compositing_helper"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTSynchronizedRenderers_SetOrderedCompositingHelper(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTSynchronizedRenderers_SetOrderedCompositingHelper(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOrderedCompositingHelper\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_ordered_compositing"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTSynchronizedRenderers_SetUseOrderedCompositing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTSynchronizedRenderers_SetUseOrderedCompositing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUseOrderedCompositing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("image_reduction_factor"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkIceTSynchronizedRenderers_GetImageReductionFactor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTSynchronizedRenderers_SetImageReductionFactor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTSynchronizedRenderers_SetImageReductionFactor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetImageReductionFactor/SetImageReductionFactor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("parallel_controller"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTSynchronizedRenderers_SetParallelController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTSynchronizedRenderers_SetParallelController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetParallelController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("image_processing_pass"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkIceTSynchronizedRenderers_GetImageProcessingPass(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTSynchronizedRenderers_SetImageProcessingPass(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTSynchronizedRenderers_SetImageProcessingPass(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetImageProcessingPass/SetImageProcessingPass\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_depth_buffer"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTSynchronizedRenderers_SetUseDepthBuffer(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTSynchronizedRenderers_SetUseDepthBuffer(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUseDepthBuffer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("render_empty_images"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTSynchronizedRenderers_SetRenderEmptyImages(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTSynchronizedRenderers_SetRenderEmptyImages(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRenderEmptyImages\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("render_pass"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkIceTSynchronizedRenderers_GetRenderPass(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkIceTSynchronizedRenderers_SetRenderPass(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkIceTSynchronizedRenderers_SetRenderPass(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRenderPass/SetRenderPass\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("ice_t_composite_pass"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkIceTSynchronizedRenderers_GetIceTCompositePass(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetIceTCompositePass\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkIceTSynchronizedRenderers_Doc =
  "vtkIceTSynchronizedRenderers - vtkSynchronizedRenderers subclass that\nuses IceT for parallel rendering and compositing.\n\n"
  "Superclass: vtkSynchronizedRenderers\n\n"
  "vtkIceTSynchronizedRenderers uses IceT (the Image Compositing Engine\n"
  "for Tiles) for parallel rendering and compositing. This class simply\n"
  "uses vtkIceTCompositePass internally, even though this class is\n"
  "designed to be used with traditional renderers and not those using\n"
  "render-passes. Note that this class internally does indeed leverage\n"
  "the RenderPass mechanism to intercept render calls from a\n"
  "vtkRenderer. In other words, if you are using render passes, you\n"
  "should not use this class. Your render passes will  be overridden.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkIceTSynchronizedRenderers_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkIceTSynchronizedRenderers", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkIceTSynchronizedRenderers_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkIceTSynchronizedRenderers_StaticNew()
{
  return vtkIceTSynchronizedRenderers::New();
}

PyObject *PyvtkIceTSynchronizedRenderers_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkIceTSynchronizedRenderers_Type, PyvtkIceTSynchronizedRenderers_Methods,
    "vtkIceTSynchronizedRenderers",
 &PyvtkIceTSynchronizedRenderers_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkSynchronizedRenderers");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkIceTSynchronizedRenderers_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkIceTSynchronizedRenderers(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkIceTSynchronizedRenderers_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkIceTSynchronizedRenderers", o) != 0)
  {
    Py_DECREF(o);
  }

}

