/* gnome-shell-dbus-recorder.c generated by valac 0.56.17, the Vala compiler
 * generated from gnome-shell-dbus-recorder.vala, do not modify */

/*
Peek Copyright (c) 2017-2018 by Philipp Wolfer <ph.wolfer@gmail.com>

This file is part of Peek.

This software is licensed under the GNU General Public License
(version 3 or later). See the LICENSE file in this distribution.
*/

#include "../../application.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdio.h>

#define PEEK_RECORDING_GNOME_SHELL_DBUS_RECORDER_DBUS_NAME "org.gnome.Shell.Screencast"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PEEK_RECORDING_GNOME_SHELL_DBUS_RECORDER_0_PROPERTY,
	PEEK_RECORDING_GNOME_SHELL_DBUS_RECORDER_NUM_PROPERTIES
};
static GParamSpec* peek_recording_gnome_shell_dbus_recorder_properties[PEEK_RECORDING_GNOME_SHELL_DBUS_RECORDER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PeekRecordingGnomeShellDbusRecorderPrivate {
	GnomeShellScreencast* screencast;
	guint wait_timeout;
};

static gint PeekRecordingGnomeShellDbusRecorder_private_offset;
static gpointer peek_recording_gnome_shell_dbus_recorder_parent_class = NULL;

static void peek_recording_gnome_shell_dbus_recorder_real_start_recording (PeekRecordingBaseScreenRecorder* base,
                                                                    PeekRecordingRecordingArea* area,
                                                                    GError** error);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static gchar* peek_recording_gnome_shell_dbus_recorder_build_gst_pipeline (PeekRecordingGnomeShellDbusRecorder* self,
                                                                    PeekRecordingRecordingArea* area);
static GVariant* _variant_new1 (gchar* value);
static GVariant* _variant_new2 (gboolean value);
static gchar* peek_recording_gnome_shell_dbus_recorder_get_temp_file_extension (PeekRecordingGnomeShellDbusRecorder* self);
static void peek_recording_gnome_shell_dbus_recorder_real_stop_recording (PeekRecordingBaseScreenRecorder* base);
static gboolean ____lambda23_ (PeekRecordingGnomeShellDbusRecorder* self);
static gboolean _____lambda23__gsource_func (gpointer self);
static void peek_recording_gnome_shell_dbus_recorder_finalize (GObject * obj);
static GType peek_recording_gnome_shell_dbus_recorder_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
peek_recording_gnome_shell_dbus_recorder_get_instance_private (PeekRecordingGnomeShellDbusRecorder* self)
{
	return G_STRUCT_MEMBER_P (self, PeekRecordingGnomeShellDbusRecorder_private_offset);
}

PeekRecordingGnomeShellDbusRecorder*
peek_recording_gnome_shell_dbus_recorder_construct (GType object_type,
                                                    GError** error)
{
	PeekRecordingGnomeShellDbusRecorder * self = NULL;
	GnomeShellScreencast* _tmp0_ = NULL;
	GnomeShellScreencast* _tmp1_;
	GnomeShellScreencast* _tmp2_;
	GError* _inner_error0_ = NULL;
	self = (PeekRecordingGnomeShellDbusRecorder*) peek_recording_base_screen_recorder_construct (object_type);
	_tmp1_ = (GnomeShellScreencast*) g_initable_new (GNOME_SHELL_TYPE_SCREENCAST_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", PEEK_RECORDING_GNOME_SHELL_DBUS_RECORDER_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/Shell/Screencast", "g-interface-name", "org.gnome.Shell.Screencast", NULL);
	_tmp0_ = (GnomeShellScreencast*) _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->screencast);
	self->priv->screencast = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return self;
}

PeekRecordingGnomeShellDbusRecorder*
peek_recording_gnome_shell_dbus_recorder_new (GError** error)
{
	return peek_recording_gnome_shell_dbus_recorder_construct (PEEK_RECORDING_TYPE_GNOME_SHELL_DBUS_RECORDER, error);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static GVariant*
_variant_new1 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new2 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
peek_recording_gnome_shell_dbus_recorder_real_start_recording (PeekRecordingBaseScreenRecorder* base,
                                                               PeekRecordingRecordingArea* area,
                                                               GError** error)
{
	PeekRecordingGnomeShellDbusRecorder * self;
	gboolean success = FALSE;
	GHashTable* options = NULL;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gchar* _tmp2_;
	PeekRecordingRecordingConfig* _tmp3_;
	PeekRecordingRecordingConfig* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GVariant* _tmp7_;
	GHashTable* _tmp8_;
	gchar* _tmp9_;
	PeekRecordingRecordingArea _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GVariant* _tmp13_;
	PeekRecordingRecordingConfig* _tmp14_;
	PeekRecordingRecordingConfig* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	GError* _inner_error0_ = NULL;
	self = (PeekRecordingGnomeShellDbusRecorder*) base;
	g_return_if_fail (area != NULL);
	success = FALSE;
	_tmp0_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	options = _tmp0_;
	_tmp1_ = options;
	_tmp2_ = g_strdup ("framerate");
	_tmp3_ = peek_recording_screen_recorder_get_config ((PeekRecordingScreenRecorder*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = peek_recording_recording_config_get_framerate (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_variant_new_int32 ((gint32) _tmp6_);
	g_variant_ref_sink (_tmp7_);
	g_hash_table_insert (_tmp1_, _tmp2_, _tmp7_);
	_tmp8_ = options;
	_tmp9_ = g_strdup ("pipeline");
	_tmp10_ = *area;
	_tmp11_ = peek_recording_gnome_shell_dbus_recorder_build_gst_pipeline (self, &_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _variant_new1 (_tmp12_);
	g_hash_table_insert (_tmp8_, _tmp9_, _tmp13_);
	_g_free0 (_tmp12_);
	_tmp14_ = peek_recording_screen_recorder_get_config ((PeekRecordingScreenRecorder*) self);
	_tmp15_ = _tmp14_;
	_tmp16_ = peek_recording_recording_config_get_capture_mouse (_tmp15_);
	_tmp17_ = _tmp16_;
	if (!_tmp17_) {
		GHashTable* _tmp18_;
		gchar* _tmp19_;
		GVariant* _tmp20_;
		_tmp18_ = options;
		_tmp19_ = g_strdup ("draw-cursor");
		_tmp20_ = _variant_new2 (FALSE);
		g_hash_table_insert (_tmp18_, _tmp19_, _tmp20_);
	}
	{
		gchar* file_template = NULL;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gint width = 0;
		PeekRecordingRecordingArea _tmp25_;
		gint height = 0;
		PeekRecordingRecordingArea _tmp26_;
		PeekRecordingRecordingConfig* _tmp27_;
		PeekRecordingRecordingConfig* _tmp28_;
		PeekOutputFormat _tmp29_;
		PeekOutputFormat _tmp30_;
		GnomeShellScreencast* _tmp31_;
		PeekRecordingRecordingArea _tmp32_;
		PeekRecordingRecordingArea _tmp33_;
		const gchar* _tmp34_;
		GHashTable* _tmp35_;
		gboolean _tmp36_ = FALSE;
		gchar* _tmp37_ = NULL;
		_tmp21_ = peek_recording_gnome_shell_dbus_recorder_get_temp_file_extension (self);
		_tmp22_ = _tmp21_;
		_tmp23_ = peek_utils_create_temp_file (_tmp22_, &_inner_error0_);
		_tmp24_ = _tmp23_;
		_g_free0 (_tmp22_);
		file_template = _tmp24_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_hash_table_unref0 (options);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp25_ = *area;
		width = _tmp25_.width;
		_tmp26_ = *area;
		height = _tmp26_.height;
		_tmp27_ = peek_recording_screen_recorder_get_config ((PeekRecordingScreenRecorder*) self);
		_tmp28_ = _tmp27_;
		_tmp29_ = peek_recording_recording_config_get_output_format (_tmp28_);
		_tmp30_ = _tmp29_;
		if (_tmp30_ == PEEK_OUTPUT_FORMAT_MP4) {
			width = peek_utils_make_even (width);
			height = peek_utils_make_even (height);
		}
		_tmp31_ = self->priv->screencast;
		_tmp32_ = *area;
		_tmp33_ = *area;
		_tmp34_ = file_template;
		_tmp35_ = options;
		gnome_shell_screencast_screencast_area (_tmp31_, _tmp32_.left, _tmp33_.top, width, height, _tmp34_, _tmp35_, &_tmp36_, &_tmp37_, &_inner_error0_);
		success = _tmp36_;
		_g_free0 (((PeekRecordingBaseScreenRecorder*) self)->temp_file);
		((PeekRecordingBaseScreenRecorder*) self)->temp_file = _tmp37_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (file_template);
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_hash_table_unref0 (options);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		if (success) {
			FILE* _tmp38_;
			const gchar* _tmp39_;
			_tmp38_ = stdout;
			_tmp39_ = ((PeekRecordingBaseScreenRecorder*) self)->temp_file;
			fprintf (_tmp38_, "Recording to file %s\n", _tmp39_);
		} else {
			GString* message = NULL;
			GString* _tmp40_;
			GString* _tmp41_;
			PeekRecordingRecordingConfig* _tmp42_;
			PeekRecordingRecordingConfig* _tmp43_;
			PeekOutputFormat _tmp44_;
			PeekOutputFormat _tmp45_;
			GString* _tmp48_;
			GString* _tmp49_;
			const gchar* _tmp50_;
			GError* _tmp51_;
			_tmp40_ = g_string_new ("");
			message = _tmp40_;
			_tmp41_ = message;
			g_string_append (_tmp41_, "Could not start GNOME Shell recorder.\n\n");
			_tmp42_ = peek_recording_screen_recorder_get_config ((PeekRecordingScreenRecorder*) self);
			_tmp43_ = _tmp42_;
			_tmp44_ = peek_recording_recording_config_get_output_format (_tmp43_);
			_tmp45_ = _tmp44_;
			if (_tmp45_ == PEEK_OUTPUT_FORMAT_MP4) {
				GString* _tmp46_;
				_tmp46_ = message;
				g_string_append (_tmp46_, "Make sure you have the GStreamer ugly plugins installed for MP4 record" \
"ing.");
			} else {
				GString* _tmp47_;
				_tmp47_ = message;
				g_string_append (_tmp47_, "Missing codec or another active screen recording using org.gnome.Shell" \
".Screencast?");
			}
			_tmp48_ = message;
			g_string_append (_tmp48_, "\n" \
"\n" \
"Please see the FAQ at https://github.com/phw/peek#what-is-the-cause-fo" \
"r-could-not-start-gnome-shell-recorder-errors");
			_tmp49_ = message;
			_tmp50_ = _tmp49_->str;
			_tmp51_ = g_error_new_literal (PEEK_RECORDING_ERROR, PEEK_RECORDING_ERROR_INITIALIZING_RECORDING_FAILED, _tmp50_);
			_inner_error0_ = _tmp51_;
			_g_string_free0 (message);
			_g_free0 (file_template);
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			goto __finally0;
		}
		_g_free0 (file_template);
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* e = NULL;
		GError* _tmp52_;
		const gchar* _tmp53_;
		GError* _tmp54_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp52_ = e;
		_tmp53_ = _tmp52_->message;
		_tmp54_ = g_error_new_literal (PEEK_RECORDING_ERROR, PEEK_RECORDING_ERROR_INITIALIZING_RECORDING_FAILED, _tmp53_);
		_inner_error0_ = _tmp54_;
		_g_error_free0 (e);
		goto __finally0;
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp55_;
		const gchar* _tmp56_;
		GError* _tmp57_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp55_ = e;
		_tmp56_ = _tmp55_->message;
		_tmp57_ = g_error_new_literal (PEEK_RECORDING_ERROR, PEEK_RECORDING_ERROR_INITIALIZING_RECORDING_FAILED, _tmp56_);
		_inner_error0_ = _tmp57_;
		_g_error_free0 (e);
		goto __finally0;
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp58_;
		const gchar* _tmp59_;
		GError* _tmp60_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp58_ = e;
		_tmp59_ = _tmp58_->message;
		_tmp60_ = g_error_new_literal (PEEK_RECORDING_ERROR, PEEK_RECORDING_ERROR_INITIALIZING_RECORDING_FAILED, _tmp59_);
		_inner_error0_ = _tmp60_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == PEEK_RECORDING_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_hash_table_unref0 (options);
			return;
		} else {
			_g_hash_table_unref0 (options);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	peek_recording_screen_recorder_set_is_recording ((PeekRecordingScreenRecorder*) self, success);
	_g_hash_table_unref0 (options);
}

gboolean
peek_recording_gnome_shell_dbus_recorder_is_available (GError** error)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	if (!peek_desktop_integration_is_gnome ()) {
		result = FALSE;
		return result;
	}
	{
		FreedesktopDBus* dbus = NULL;
		FreedesktopDBus* _tmp0_;
		gboolean _tmp2_ = FALSE;
		FreedesktopDBus* _tmp3_;
		_tmp0_ = (FreedesktopDBus*) g_initable_new (FREEDESKTOP_TYPE_DBUS_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.freedesktop.DBus", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/freedesktop/DBus", "g-interface-name", "org.freedesktop.DBus", NULL);
		dbus = (FreedesktopDBus*) _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp1_ = FALSE;
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
		_tmp3_ = dbus;
		_tmp2_ = freedesktop_dbus_name_has_owner (_tmp3_, PEEK_RECORDING_GNOME_SHELL_DBUS_RECORDER_DBUS_NAME, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			_g_object_unref0 (dbus);
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		result = _tmp2_;
		_g_object_unref0 (dbus);
		return result;
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		GError* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "Error: %s\n", _tmp7_);
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		_tmp10_ = g_error_new_literal (PEEK_PEEK_ERROR, PEEK_PEEK_ERROR_SCREEN_RECORDER_ERROR, _tmp9_);
		_inner_error0_ = _tmp10_;
		_g_error_free0 (e);
		goto __finally0;
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		FILE* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		GError* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = stderr;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		fprintf (_tmp11_, "Error: %s\n", _tmp13_);
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		_tmp16_ = g_error_new_literal (PEEK_PEEK_ERROR, PEEK_PEEK_ERROR_SCREEN_RECORDER_ERROR, _tmp15_);
		_inner_error0_ = _tmp16_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (_inner_error0_->domain == PEEK_PEEK_ERROR) {
		gboolean _tmp17_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp17_;
	} else {
		gboolean _tmp18_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp18_;
	}
}

static gboolean
____lambda23_ (PeekRecordingGnomeShellDbusRecorder* self)
{
	gboolean result;
	g_source_remove (self->priv->wait_timeout);
	self->priv->wait_timeout = (guint) 0;
	peek_recording_base_screen_recorder_finalize_recording ((PeekRecordingBaseScreenRecorder*) self);
	result = TRUE;
	return result;
}

static gboolean
_____lambda23__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda23_ ((PeekRecordingGnomeShellDbusRecorder*) self);
	return result;
}

static void
peek_recording_gnome_shell_dbus_recorder_real_stop_recording (PeekRecordingBaseScreenRecorder* base)
{
	PeekRecordingGnomeShellDbusRecorder * self;
	GError* _inner_error0_ = NULL;
	self = (PeekRecordingGnomeShellDbusRecorder*) base;
	{
		GnomeShellScreencast* _tmp0_;
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp0_ = self->priv->screencast;
		gnome_shell_screencast_stop_screencast (_tmp0_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_DBUS_ERROR) {
				goto __catch0_g_dbus_error;
			}
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp1_ = peek_recording_base_screen_recorder_get_is_cancelling ((PeekRecordingBaseScreenRecorder*) self);
		_tmp2_ = _tmp1_;
		if (!_tmp2_) {
			self->priv->wait_timeout = g_timeout_add_full (G_PRIORITY_LOW, (guint) 400, _____lambda23__gsource_func, g_object_ref (self), g_object_unref);
		}
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* e = NULL;
		FILE* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		fprintf (_tmp3_, "Error: %s\n", _tmp5_);
		_tmp6_ = peek_recording_base_screen_recorder_get_is_cancelling ((PeekRecordingBaseScreenRecorder*) self);
		_tmp7_ = _tmp6_;
		if (!_tmp7_) {
			GError* _tmp8_;
			const gchar* _tmp9_;
			GError* _tmp10_;
			GError* _tmp11_;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			_tmp10_ = g_error_new_literal (PEEK_RECORDING_ERROR, PEEK_RECORDING_ERROR_RECORDING_ABORTED, _tmp9_);
			_tmp11_ = _tmp10_;
			g_signal_emit_by_name ((PeekRecordingScreenRecorder*) self, "recording-aborted", _tmp11_);
			_g_error_free0 (_tmp11_);
		}
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		FILE* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = stderr;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		fprintf (_tmp12_, "Error: %s\n", _tmp14_);
		_tmp15_ = peek_recording_base_screen_recorder_get_is_cancelling ((PeekRecordingBaseScreenRecorder*) self);
		_tmp16_ = _tmp15_;
		if (!_tmp16_) {
			GError* _tmp17_;
			const gchar* _tmp18_;
			GError* _tmp19_;
			GError* _tmp20_;
			_tmp17_ = e;
			_tmp18_ = _tmp17_->message;
			_tmp19_ = g_error_new_literal (PEEK_RECORDING_ERROR, PEEK_RECORDING_ERROR_RECORDING_ABORTED, _tmp18_);
			_tmp20_ = _tmp19_;
			g_signal_emit_by_name ((PeekRecordingScreenRecorder*) self, "recording-aborted", _tmp20_);
			_g_error_free0 (_tmp20_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gchar*
peek_recording_gnome_shell_dbus_recorder_build_gst_pipeline (PeekRecordingGnomeShellDbusRecorder* self,
                                                             PeekRecordingRecordingArea* area)
{
	GString* pipeline = NULL;
	GString* _tmp0_;
	PeekRecordingRecordingConfig* _tmp1_;
	PeekRecordingRecordingConfig* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	PeekRecordingRecordingConfig* _tmp20_;
	PeekRecordingRecordingConfig* _tmp21_;
	PeekOutputFormat _tmp22_;
	PeekOutputFormat _tmp23_;
	GString* _tmp35_;
	const gchar* _tmp36_;
	GString* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (area != NULL, NULL);
	_tmp0_ = g_string_new ("");
	pipeline = _tmp0_;
	_tmp1_ = peek_recording_screen_recorder_get_config ((PeekRecordingScreenRecorder*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = peek_recording_recording_config_get_downsample (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 1) {
		gint width = 0;
		PeekRecordingRecordingArea _tmp5_;
		PeekRecordingRecordingConfig* _tmp6_;
		PeekRecordingRecordingConfig* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint height = 0;
		PeekRecordingRecordingArea _tmp10_;
		PeekRecordingRecordingConfig* _tmp11_;
		PeekRecordingRecordingConfig* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		PeekRecordingRecordingConfig* _tmp15_;
		PeekRecordingRecordingConfig* _tmp16_;
		PeekOutputFormat _tmp17_;
		PeekOutputFormat _tmp18_;
		GString* _tmp19_;
		_tmp5_ = *area;
		_tmp6_ = peek_recording_screen_recorder_get_config ((PeekRecordingScreenRecorder*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = peek_recording_recording_config_get_downsample (_tmp7_);
		_tmp9_ = _tmp8_;
		width = _tmp5_.width / _tmp9_;
		_tmp10_ = *area;
		_tmp11_ = peek_recording_screen_recorder_get_config ((PeekRecordingScreenRecorder*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = peek_recording_recording_config_get_downsample (_tmp12_);
		_tmp14_ = _tmp13_;
		height = _tmp10_.height / _tmp14_;
		_tmp15_ = peek_recording_screen_recorder_get_config ((PeekRecordingScreenRecorder*) self);
		_tmp16_ = _tmp15_;
		_tmp17_ = peek_recording_recording_config_get_output_format (_tmp16_);
		_tmp18_ = _tmp17_;
		if (_tmp18_ == PEEK_OUTPUT_FORMAT_MP4) {
			width = peek_utils_make_even (width);
			height = peek_utils_make_even (height);
		}
		_tmp19_ = pipeline;
		g_string_append_printf (_tmp19_, "videoscale ! video/x-raw,width=%i,height=%i ! ", width, height);
	}
	_tmp20_ = peek_recording_screen_recorder_get_config ((PeekRecordingScreenRecorder*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = peek_recording_recording_config_get_output_format (_tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_ == PEEK_OUTPUT_FORMAT_WEBM) {
		GString* _tmp24_;
		GString* _tmp25_;
		_tmp24_ = pipeline;
		g_string_append (_tmp24_, "vp9enc min_quantizer=10 max_quantizer=50 cq_level=13 cpu-used=5 deadli" \
"ne=1000000 threads=%T ! ");
		_tmp25_ = pipeline;
		g_string_append (_tmp25_, "queue ! webmmux");
	} else {
		PeekRecordingRecordingConfig* _tmp26_;
		PeekRecordingRecordingConfig* _tmp27_;
		PeekOutputFormat _tmp28_;
		PeekOutputFormat _tmp29_;
		_tmp26_ = peek_recording_screen_recorder_get_config ((PeekRecordingScreenRecorder*) self);
		_tmp27_ = _tmp26_;
		_tmp28_ = peek_recording_recording_config_get_output_format (_tmp27_);
		_tmp29_ = _tmp28_;
		if (_tmp29_ == PEEK_OUTPUT_FORMAT_MP4) {
			GString* _tmp30_;
			GString* _tmp31_;
			GString* _tmp32_;
			_tmp30_ = pipeline;
			g_string_append (_tmp30_, "x264enc speed-preset=fast threads=%T ! ");
			_tmp31_ = pipeline;
			g_string_append (_tmp31_, "video/x-h264, profile=baseline ! ");
			_tmp32_ = pipeline;
			g_string_append (_tmp32_, "queue ! mp4mux");
		} else {
			GString* _tmp33_;
			GString* _tmp34_;
			_tmp33_ = pipeline;
			g_string_append (_tmp33_, "vp9enc min_quantizer=0 max_quantizer=0 cq_level=0 cpu-used=5 deadline=" \
"1000000 threads=%T ! ");
			_tmp34_ = pipeline;
			g_string_append (_tmp34_, "queue ! webmmux");
		}
	}
	_tmp35_ = pipeline;
	_tmp36_ = _tmp35_->str;
	g_debug ("gnome-shell-dbus-recorder.vala:177: Using GStreamer pipeline %s", _tmp36_);
	_tmp37_ = pipeline;
	_tmp38_ = _tmp37_->str;
	_tmp39_ = g_strdup (_tmp38_);
	result = _tmp39_;
	_g_string_free0 (pipeline);
	return result;
}

static gchar*
peek_recording_gnome_shell_dbus_recorder_get_temp_file_extension (PeekRecordingGnomeShellDbusRecorder* self)
{
	gchar* extension = NULL;
	gboolean _tmp0_ = FALSE;
	PeekRecordingRecordingConfig* _tmp1_;
	PeekRecordingRecordingConfig* _tmp2_;
	PeekOutputFormat _tmp3_;
	PeekOutputFormat _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = peek_recording_screen_recorder_get_config ((PeekRecordingScreenRecorder*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = peek_recording_recording_config_get_output_format (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == PEEK_OUTPUT_FORMAT_GIF) {
		_tmp0_ = TRUE;
	} else {
		PeekRecordingRecordingConfig* _tmp5_;
		PeekRecordingRecordingConfig* _tmp6_;
		PeekOutputFormat _tmp7_;
		PeekOutputFormat _tmp8_;
		_tmp5_ = peek_recording_screen_recorder_get_config ((PeekRecordingScreenRecorder*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = peek_recording_recording_config_get_output_format (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_ == PEEK_OUTPUT_FORMAT_APNG;
	}
	if (_tmp0_) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("webm");
		_g_free0 (extension);
		extension = _tmp9_;
	} else {
		PeekRecordingRecordingConfig* _tmp10_;
		PeekRecordingRecordingConfig* _tmp11_;
		PeekOutputFormat _tmp12_;
		PeekOutputFormat _tmp13_;
		gchar* _tmp14_;
		_tmp10_ = peek_recording_screen_recorder_get_config ((PeekRecordingScreenRecorder*) self);
		_tmp11_ = _tmp10_;
		_tmp12_ = peek_recording_recording_config_get_output_format (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = peek_utils_get_file_extension_for_format (_tmp13_);
		_g_free0 (extension);
		extension = _tmp14_;
	}
	result = extension;
	return result;
}

static void
peek_recording_gnome_shell_dbus_recorder_class_init (PeekRecordingGnomeShellDbusRecorderClass * klass,
                                                     gpointer klass_data)
{
	peek_recording_gnome_shell_dbus_recorder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PeekRecordingGnomeShellDbusRecorder_private_offset);
	((PeekRecordingBaseScreenRecorderClass *) klass)->start_recording = (void (*) (PeekRecordingBaseScreenRecorder*, PeekRecordingRecordingArea*, GError**)) peek_recording_gnome_shell_dbus_recorder_real_start_recording;
	((PeekRecordingBaseScreenRecorderClass *) klass)->stop_recording = (void (*) (PeekRecordingBaseScreenRecorder*)) peek_recording_gnome_shell_dbus_recorder_real_stop_recording;
	G_OBJECT_CLASS (klass)->finalize = peek_recording_gnome_shell_dbus_recorder_finalize;
}

static void
peek_recording_gnome_shell_dbus_recorder_instance_init (PeekRecordingGnomeShellDbusRecorder * self,
                                                        gpointer klass)
{
	self->priv = peek_recording_gnome_shell_dbus_recorder_get_instance_private (self);
	self->priv->wait_timeout = (guint) 0;
}

static void
peek_recording_gnome_shell_dbus_recorder_finalize (GObject * obj)
{
	PeekRecordingGnomeShellDbusRecorder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PEEK_RECORDING_TYPE_GNOME_SHELL_DBUS_RECORDER, PeekRecordingGnomeShellDbusRecorder);
	if (self->priv->wait_timeout != ((guint) 0)) {
		g_source_remove (self->priv->wait_timeout);
	}
	_g_object_unref0 (self->priv->screencast);
	G_OBJECT_CLASS (peek_recording_gnome_shell_dbus_recorder_parent_class)->finalize (obj);
}

static GType
peek_recording_gnome_shell_dbus_recorder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PeekRecordingGnomeShellDbusRecorderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) peek_recording_gnome_shell_dbus_recorder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PeekRecordingGnomeShellDbusRecorder), 0, (GInstanceInitFunc) peek_recording_gnome_shell_dbus_recorder_instance_init, NULL };
	GType peek_recording_gnome_shell_dbus_recorder_type_id;
	peek_recording_gnome_shell_dbus_recorder_type_id = g_type_register_static (PEEK_RECORDING_TYPE_BASE_SCREEN_RECORDER, "PeekRecordingGnomeShellDbusRecorder", &g_define_type_info, 0);
	PeekRecordingGnomeShellDbusRecorder_private_offset = g_type_add_instance_private (peek_recording_gnome_shell_dbus_recorder_type_id, sizeof (PeekRecordingGnomeShellDbusRecorderPrivate));
	return peek_recording_gnome_shell_dbus_recorder_type_id;
}

GType
peek_recording_gnome_shell_dbus_recorder_get_type (void)
{
	static volatile gsize peek_recording_gnome_shell_dbus_recorder_type_id__once = 0;
	if (g_once_init_enter (&peek_recording_gnome_shell_dbus_recorder_type_id__once)) {
		GType peek_recording_gnome_shell_dbus_recorder_type_id;
		peek_recording_gnome_shell_dbus_recorder_type_id = peek_recording_gnome_shell_dbus_recorder_get_type_once ();
		g_once_init_leave (&peek_recording_gnome_shell_dbus_recorder_type_id__once, peek_recording_gnome_shell_dbus_recorder_type_id);
	}
	return peek_recording_gnome_shell_dbus_recorder_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

