/* Generated by wayland-scanner 1.23.1 */

#ifndef PHOC_LAYER_SURFACE_EFFECTS_UNSTABLE_V1_SERVER_PROTOCOL_H
#define PHOC_LAYER_SURFACE_EFFECTS_UNSTABLE_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_phoc_layer_surface_effects_unstable_v1 The phoc_layer_surface_effects_unstable_v1 protocol
 * @section page_ifaces_phoc_layer_surface_effects_unstable_v1 Interfaces
 * - @subpage page_iface_zphoc_layer_shell_effects_v1 - Adjust properties of layer surfaces
 * - @subpage page_iface_zphoc_draggable_layer_surface_v1 - Draggable layer surface interface
 * - @subpage page_iface_zphoc_alpha_layer_surface_v1 - 
 * - @subpage page_iface_zphoc_stacked_layer_surface_v1 - 
 * @section page_copyright_phoc_layer_surface_effects_unstable_v1 Copyright
 * <pre>
 *
 * Copyright © 2022-2024 Guido Günther
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct zphoc_alpha_layer_surface_v1;
struct zphoc_draggable_layer_surface_v1;
struct zphoc_layer_shell_effects_v1;
struct zphoc_stacked_layer_surface_v1;
struct zwlr_layer_surface_v1;

#ifndef ZPHOC_LAYER_SHELL_EFFECTS_V1_INTERFACE
#define ZPHOC_LAYER_SHELL_EFFECTS_V1_INTERFACE
/**
 * @page page_iface_zphoc_layer_shell_effects_v1 zphoc_layer_shell_effects_v1
 * @section page_iface_zphoc_layer_shell_effects_v1_desc Description
 *
 * Assigns additional features to layer surfaces such as opacity or gestures interaction.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding interface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and interface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 *
 * This protocol is meant to collect necessary bits before we propose an
 * upstream solution.
 * @section page_iface_zphoc_layer_shell_effects_v1_api API
 * See @ref iface_zphoc_layer_shell_effects_v1.
 */
/**
 * @defgroup iface_zphoc_layer_shell_effects_v1 The zphoc_layer_shell_effects_v1 interface
 *
 * Assigns additional features to layer surfaces such as opacity or gestures interaction.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding interface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and interface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 *
 * This protocol is meant to collect necessary bits before we propose an
 * upstream solution.
 */
extern const struct wl_interface zphoc_layer_shell_effects_v1_interface;
#endif
#ifndef ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_INTERFACE
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_INTERFACE
/**
 * @page page_iface_zphoc_draggable_layer_surface_v1 zphoc_draggable_layer_surface_v1
 * @section page_iface_zphoc_draggable_layer_surface_v1_desc Description
 *
 * An interface that may be implemented by a layer_surface, for surfaces that
 * are designed to become draggable when anchored at three edges.
 * @section page_iface_zphoc_draggable_layer_surface_v1_api API
 * See @ref iface_zphoc_draggable_layer_surface_v1.
 */
/**
 * @defgroup iface_zphoc_draggable_layer_surface_v1 The zphoc_draggable_layer_surface_v1 interface
 *
 * An interface that may be implemented by a layer_surface, for surfaces that
 * are designed to become draggable when anchored at three edges.
 */
extern const struct wl_interface zphoc_draggable_layer_surface_v1_interface;
#endif
#ifndef ZPHOC_ALPHA_LAYER_SURFACE_V1_INTERFACE
#define ZPHOC_ALPHA_LAYER_SURFACE_V1_INTERFACE
/**
 * @page page_iface_zphoc_alpha_layer_surface_v1 zphoc_alpha_layer_surface_v1
 * @section page_iface_zphoc_alpha_layer_surface_v1_api API
 * See @ref iface_zphoc_alpha_layer_surface_v1.
 */
/**
 * @defgroup iface_zphoc_alpha_layer_surface_v1 The zphoc_alpha_layer_surface_v1 interface
 */
extern const struct wl_interface zphoc_alpha_layer_surface_v1_interface;
#endif
#ifndef ZPHOC_STACKED_LAYER_SURFACE_V1_INTERFACE
#define ZPHOC_STACKED_LAYER_SURFACE_V1_INTERFACE
/**
 * @page page_iface_zphoc_stacked_layer_surface_v1 zphoc_stacked_layer_surface_v1
 * @section page_iface_zphoc_stacked_layer_surface_v1_api API
 * See @ref iface_zphoc_stacked_layer_surface_v1.
 */
/**
 * @defgroup iface_zphoc_stacked_layer_surface_v1 The zphoc_stacked_layer_surface_v1 interface
 */
extern const struct wl_interface zphoc_stacked_layer_surface_v1_interface;
#endif

#ifndef ZPHOC_LAYER_SHELL_EFFECTS_V1_ERROR_ENUM
#define ZPHOC_LAYER_SHELL_EFFECTS_V1_ERROR_ENUM
enum zphoc_layer_shell_effects_v1_error {
	/**
	 * layer surface is not committed
	 */
	ZPHOC_LAYER_SHELL_EFFECTS_V1_ERROR_BAD_SURFACE = 0,
	/**
	 * layer surface is not anchored to 3 edges
	 */
	ZPHOC_LAYER_SHELL_EFFECTS_V1_ERROR_BAD_ANCHORS = 1,
	/**
	 * layer surface has no margin to use
	 */
	ZPHOC_LAYER_SHELL_EFFECTS_V1_ERROR_BAD_MARGIN = 2,
};
/**
 * @ingroup iface_zphoc_layer_shell_effects_v1
 * Validate a zphoc_layer_shell_effects_v1 error value.
 *
 * @return true on success, false on error.
 * @ref zphoc_layer_shell_effects_v1_error
 */
static inline bool
zphoc_layer_shell_effects_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ZPHOC_LAYER_SHELL_EFFECTS_V1_ERROR_BAD_SURFACE:
		return version >= 1;
	case ZPHOC_LAYER_SHELL_EFFECTS_V1_ERROR_BAD_ANCHORS:
		return version >= 1;
	case ZPHOC_LAYER_SHELL_EFFECTS_V1_ERROR_BAD_MARGIN:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ZPHOC_LAYER_SHELL_EFFECTS_V1_ERROR_ENUM */

#ifndef ZPHOC_LAYER_SHELL_EFFECTS_V1_STACK_ERROR_ENUM
#define ZPHOC_LAYER_SHELL_EFFECTS_V1_STACK_ERROR_ENUM
enum zphoc_layer_shell_effects_v1_stack_error {
	/**
	 * layer surfaces not in same layer
	 */
	ZPHOC_LAYER_SHELL_EFFECTS_V1_STACK_ERROR_INVALID_LAYER = 0,
	/**
	 * layer surfaces not on same output
	 */
	ZPHOC_LAYER_SHELL_EFFECTS_V1_STACK_ERROR_INVALID_OUTPUT = 1,
	/**
	 * layer surface invalid
	 */
	ZPHOC_LAYER_SHELL_EFFECTS_V1_STACK_ERROR_INVALID_SURFACE = 2,
};
/**
 * @ingroup iface_zphoc_layer_shell_effects_v1
 * Validate a zphoc_layer_shell_effects_v1 stack_error value.
 *
 * @return true on success, false on error.
 * @ref zphoc_layer_shell_effects_v1_stack_error
 */
static inline bool
zphoc_layer_shell_effects_v1_stack_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ZPHOC_LAYER_SHELL_EFFECTS_V1_STACK_ERROR_INVALID_LAYER:
		return version >= 1;
	case ZPHOC_LAYER_SHELL_EFFECTS_V1_STACK_ERROR_INVALID_OUTPUT:
		return version >= 1;
	case ZPHOC_LAYER_SHELL_EFFECTS_V1_STACK_ERROR_INVALID_SURFACE:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ZPHOC_LAYER_SHELL_EFFECTS_V1_STACK_ERROR_ENUM */

/**
 * @ingroup iface_zphoc_layer_shell_effects_v1
 * @struct zphoc_layer_shell_effects_v1_interface
 */
struct zphoc_layer_shell_effects_v1_interface {
	/**
	 * Make layer_surface draggable
	 *
	 * This marks a layer surface as draggable via one finger drag on
	 * touch or click and drag when using a mouse. E.g. a surface that
	 * is anchored to the left, right and top can be dragged to the
	 * bottom exposing more of it's surface.
	 *
	 * The state with the minimal amount of surface visible is called
	 * folded state, the state with the maximum amount of surface
	 * visible is called unfolded state. These two states are defined
	 * by the layer surfaces margin in those states. During drag the
	 * layer surfaces margin is adjusted to move the surface
	 * invalidating the margin set on the zwlr_layer_surface_v1
	 * interface. The default folded and unfolded margins are 0.
	 *
	 * The threshold ([0.0, 1.0]) specifies how far the user needs to
	 * pull out the surface to not slide back into the folded state but
	 * rather slide into the unfolded state. The default is 1.0.
	 *
	 * The client is responsible for adjusting it's margins when it's
	 * size changes to e.g. make sure only the wanted parts of the
	 * surface are visible in folded state.
	 *
	 * Note that you shouldn't modify exclusive_zone or margins via
	 * zwlr_layer_surface_v1 interface directly when using this one.
	 *
	 * Margins, threshold and exclusive zone are double buffered and
	 * will be applied on the next surface commit.
	 */
	void (*get_draggable_layer_surface)(struct wl_client *client,
					    struct wl_resource *resource,
					    uint32_t id,
					    struct wl_resource *layer_surface);
	/**
	 * destroy the layer_shell_effects object
	 *
	 * This request indicates that the client will not use the
	 * layer_shell effects object any more. Objects that have been
	 * created through this instance are not affected.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * Allow layer_surface to become transparent
	 *
	 * 
	 * @since 2
	 */
	void (*get_alpha_layer_surface)(struct wl_client *client,
					struct wl_resource *resource,
					uint32_t id,
					struct wl_resource *layer_surface);
	/**
	 * Allow to tweak how a layer surfaces is stacked
	 *
	 * Making a layer surface stacked allows to fixate it's position
	 * in the layer surface stack.
	 * @since 3
	 */
	void (*get_stacked_layer_surface)(struct wl_client *client,
					  struct wl_resource *resource,
					  uint32_t id,
					  struct wl_resource *surface);
};


/**
 * @ingroup iface_zphoc_layer_shell_effects_v1
 */
#define ZPHOC_LAYER_SHELL_EFFECTS_V1_GET_DRAGGABLE_LAYER_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_layer_shell_effects_v1
 */
#define ZPHOC_LAYER_SHELL_EFFECTS_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_layer_shell_effects_v1
 */
#define ZPHOC_LAYER_SHELL_EFFECTS_V1_GET_ALPHA_LAYER_SURFACE_SINCE_VERSION 2
/**
 * @ingroup iface_zphoc_layer_shell_effects_v1
 */
#define ZPHOC_LAYER_SHELL_EFFECTS_V1_GET_STACKED_LAYER_SURFACE_SINCE_VERSION 3

#ifndef ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_END_STATE_ENUM
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_END_STATE_ENUM
enum zphoc_draggable_layer_surface_v1_drag_end_state {
	/**
	 * The surface is folded
	 */
	ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_END_STATE_FOLDED = 0,
	/**
	 * The surface is unfolded
	 */
	ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_END_STATE_UNFOLDED = 1,
};
/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 * Validate a zphoc_draggable_layer_surface_v1 drag_end_state value.
 *
 * @return true on success, false on error.
 * @ref zphoc_draggable_layer_surface_v1_drag_end_state
 */
static inline bool
zphoc_draggable_layer_surface_v1_drag_end_state_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_END_STATE_FOLDED:
		return version >= 1;
	case ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_END_STATE_UNFOLDED:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_END_STATE_ENUM */

#ifndef ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_MODE_ENUM
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_MODE_ENUM
enum zphoc_draggable_layer_surface_v1_drag_mode {
	/**
	 * The whole surface is draggable
	 */
	ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_MODE_FULL = 0,
	/**
	 * Only the handle is draggable
	 */
	ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_MODE_HANDLE = 1,
	/**
	 * Surface not draggable
	 */
	ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_MODE_NONE = 2,
};
/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 * Validate a zphoc_draggable_layer_surface_v1 drag_mode value.
 *
 * @return true on success, false on error.
 * @ref zphoc_draggable_layer_surface_v1_drag_mode
 */
static inline bool
zphoc_draggable_layer_surface_v1_drag_mode_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_MODE_FULL:
		return version >= 1;
	case ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_MODE_HANDLE:
		return version >= 1;
	case ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_MODE_NONE:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_MODE_ENUM */

/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 * @struct zphoc_draggable_layer_surface_v1_interface
 */
struct zphoc_draggable_layer_surface_v1_interface {
	/**
	 * Set the margins
	 *
	 * Sets the folded and unfolded margins. For how they are defined
	 * refer to margins in the layer-surface protocol.
	 *
	 * Margins are double-buffered, see wl_surface.commit.
	 */
	void (*set_margins)(struct wl_client *client,
			    struct wl_resource *resource,
			    int32_t margin_folded,
			    int32_t margin_unfolded);
	/**
	 * Set the threshold
	 *
	 * How far the surface needs to be pulled to go from folded to
	 * unfolded state and vice versa. Ranges 0.0 to 1.0 as fraction of
	 * the total margin between folded and unfolded state.
	 *
	 * Threshold is double-buffered, see wl_surface.commit.
	 */
	void (*set_threshold)(struct wl_client *client,
			      struct wl_resource *resource,
			      wl_fixed_t threshold);
	/**
	 * Set the exclusive zone
	 *
	 * Sets the exclusive zone. This is the amount of pixels from the
	 * screen edge that shouldn't be occluded by other surfaces.
	 *
	 * Exclusive zone is double-buffered, see wl_surface.commit.
	 */
	void (*set_exclusive)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t exclusive);
	/**
	 * Set the drag mode
	 *
	 * Specify how the surface can be dragged. The default is "full".
	 *
	 * Drag-mode is double-buffered, see wl_surface.commit.
	 */
	void (*set_drag_mode)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t mode);
	/**
	 * The drag mode
	 *
	 * Specify the position of the drag handle and thus the area that
	 * responds to drag gestures.
	 *
	 * If the surface's non anchored edge is at the left or right it
	 * specifies the x, otherwise the y coordinate of the drag handle
	 * in surface local coordinates. The area between the non anchored
	 * surface edge and the drag handle responds to drag gestures.
	 *
	 * 0 +-----------------+ 1 | | 2 | A | 3 | | 4 +++++++++++++++++++
	 * -- drag handle 5 | | 6 | | 7 | B | 8 | | 9 +-----------------+
	 *
	 * If the above surface's non anchored edge is at the bottom then a
	 * drag handle of 4 will make area B respond to touch events. If
	 * the non anchored edge is at the top the same value makes area A
	 * respond to touch events.
	 *
	 * A special value of 0 indicates that the whole surface should be
	 * draggable.
	 *
	 * The default is 0.
	 *
	 * Drag-handle is double-buffered, see wl_surface.commit.
	 */
	void (*set_drag_handle)(struct wl_client *client,
				struct wl_resource *resource,
				uint32_t handle);
	/**
	 * Set a certain state
	 *
	 * Set state to folded or unfolded. This is applied immediately.
	 */
	void (*set_state)(struct wl_client *client,
			  struct wl_resource *resource,
			  uint32_t state);
	/**
	 * destroy the draggable_layer_surface
	 *
	 * This request destroys the draggable layer surface.
	 *
	 * It's a protocol error if the client destroys the layer-surface
	 * before the draggable layer-surface.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAGGED 0
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_END 1

/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 */
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAGGED_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 */
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_END_SINCE_VERSION 1

/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 */
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_MARGINS_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 */
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_THRESHOLD_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 */
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_EXCLUSIVE_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 */
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_DRAG_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 */
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_DRAG_HANDLE_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 */
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_SET_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 */
#define ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 * Sends an dragged event to the client owning the resource.
 * @param resource_ The client's resource
 * @param margin The current margin
 */
static inline void
zphoc_draggable_layer_surface_v1_send_dragged(struct wl_resource *resource_, int32_t margin)
{
	wl_resource_post_event(resource_, ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAGGED, margin);
}

/**
 * @ingroup iface_zphoc_draggable_layer_surface_v1
 * Sends an drag_end event to the client owning the resource.
 * @param resource_ The client's resource
 * @param state The state
 */
static inline void
zphoc_draggable_layer_surface_v1_send_drag_end(struct wl_resource *resource_, uint32_t state)
{
	wl_resource_post_event(resource_, ZPHOC_DRAGGABLE_LAYER_SURFACE_V1_DRAG_END, state);
}

/**
 * @ingroup iface_zphoc_alpha_layer_surface_v1
 * @struct zphoc_alpha_layer_surface_v1_interface
 */
struct zphoc_alpha_layer_surface_v1_interface {
	/**
	 * Set the surface's alpha value
	 *
	 * Set the surface's transparency. Valid values are between 0.0
	 * (fully transparent) and 1.0 (fully opaque). The set value also
	 * affects subsurfaces and popups.
	 *
	 * Alpha is double-buffered, see wl_surface.commit.
	 */
	void (*set_alpha)(struct wl_client *client,
			  struct wl_resource *resource,
			  wl_fixed_t alpha);
	/**
	 * destroy the alpha_layer_surface
	 *
	 * This request destroys the alpha layer surface.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};


/**
 * @ingroup iface_zphoc_alpha_layer_surface_v1
 */
#define ZPHOC_ALPHA_LAYER_SURFACE_V1_SET_ALPHA_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_alpha_layer_surface_v1
 */
#define ZPHOC_ALPHA_LAYER_SURFACE_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_zphoc_stacked_layer_surface_v1
 * @struct zphoc_stacked_layer_surface_v1_interface
 */
struct zphoc_stacked_layer_surface_v1_interface {
	/**
	 * Stack surface below the given layer surface
	 *
	 * Attaches the stacked layer surface below the layer surface
	 * given in this request. Both surfaces must be in the same layer
	 * and on the same output. Otherwise a protocol error will be
	 * raised.
	 */
	void (*stack_below)(struct wl_client *client,
			    struct wl_resource *resource,
			    struct wl_resource *surface);
	/**
	 * Stack surface below the given layer surface
	 *
	 * Attaches the stacked layer surface above the layer surface
	 * given in this request. Both surfaces must be in the same layer
	 * and on the same output. Otherwise a protocol error will be
	 * raised.
	 */
	void (*stack_above)(struct wl_client *client,
			    struct wl_resource *resource,
			    struct wl_resource *surface);
	/**
	 * destroy the stacked layer_surface
	 *
	 * This request destroys the stacked layer surface
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};


/**
 * @ingroup iface_zphoc_stacked_layer_surface_v1
 */
#define ZPHOC_STACKED_LAYER_SURFACE_V1_STACK_BELOW_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_stacked_layer_surface_v1
 */
#define ZPHOC_STACKED_LAYER_SURFACE_V1_STACK_ABOVE_SINCE_VERSION 1
/**
 * @ingroup iface_zphoc_stacked_layer_surface_v1
 */
#define ZPHOC_STACKED_LAYER_SURFACE_V1_DESTROY_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
