/* This file is part of GDB.

   Copyright 2002, 2007 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   --

   This file was generated by the program igen */

#ifndef SEMANTICS_C
#define SEMANTICS_C


#include "cpu.h"
#include "idecode.h"
#include "semantics.h"
#include "tree.h"
#ifdef HAVE_COMMON_FPU
#include "sim-inline.h"
#include "sim-fpu.h"
#endif
#include "support.h"

int option_mpc860c0 = 0;

PSIM_EXTERN_SEMANTICS(void)
semantic_init(device* root)
{
  option_mpc860c0 = 0;
  if (tree_find_property(root, "/options/mpc860c0"))
    option_mpc860c0 = tree_find_integer_property(root, "/options/mpc860c0");
  option_mpc860c0 *= 4;   /* convert word count to byte count */
}


PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_instruction_call(cpu *processor,
                          idecode_cache *cache_entry,
                          unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_instruction_call
#undef MY_PREFIX
#define MY_PREFIX instruction_call

  /* extraction: 0.0,6./,11./,16./,21./,31.1 #define get-values-from-icache */
#line 61 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 1493 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics instruction_call\n"));
#line 67 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_instruction_call, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1493 "../../sim/ppc/powerpc.igen"
  {
    if (!os_emul_instruction_call(processor, cia, real_addr(cia, 1)))
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
  }
#line 82 "semantics.c"
  return nia;
  /* extraction: 0.0,6./,11./,16./,21./,31.1 #undef get-values-from-icache */
#line 85 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Trap_Word_Immediate(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Trap_Word_Immediate
#undef MY_PREFIX
#define MY_PREFIX Trap_Word_Immediate

  /* extraction: 0.3,6.TO,11.RA,16.SI #define get-values-from-icache */
#define TO cache_entry->crack.D.TO /* default in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_SI cache_entry->crack.D.EXTS_SI /* in icache - extraction */
#line 108 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2897 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Trap Word Immediate\n"));
#line 114 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Trap_Word_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2897 "../../sim/ppc/powerpc.igen"
  {
    signed_word a = EXTENDED(*rA);
    signed_word b = EXTS(SI);
    if ((a < b && TO_0_)
        || (a > b && TO_1_)
        || (a == b && TO_2_)
        || ((unsigned_word)a < (unsigned_word)b && TO_3_)
        || ((unsigned_word)a > (unsigned_word)b && TO_4_)
        )
      program_interrupt(processor, cia,
                        trap_program_interrupt);
  }
#line 136 "semantics.c"
  return nia;
  /* extraction: 0.3,6.TO,11.RA,16.SI #undef get-values-from-icache */
#undef TO
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_SI
#line 145 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Multiply_Low_Immediate(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_Low_Immediate
#undef MY_PREFIX
#define MY_PREFIX Multiply_Low_Immediate

  /* extraction: 0.7,6.RT,11.RA,16.SI #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_SI cache_entry->crack.D.EXTS_SI /* in icache - extraction */
#line 170 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2687 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Multiply Low Immediate\n"));
#line 176 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Multiply_Low_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2687 "../../sim/ppc/powerpc.igen"
  {
    signed_word prod = *rA * EXTS(SI);
    *rT = prod;
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, 0/*Rc*/);
  }
#line 191 "semantics.c"
  return nia;
  /* extraction: 0.7,6.RT,11.RA,16.SI #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_SI
#line 202 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Immediate_Carrying(cpu *processor,
                                          idecode_cache *cache_entry,
                                          unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Immediate_Carrying
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Immediate_Carrying

  /* extraction: 0.8,6.RT,11.RA,16.SI #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_SI cache_entry->crack.D.EXTS_SI /* in icache - extraction */
#line 227 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2574 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Immediate Carrying\n"));
#line 233 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Immediate_Carrying, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2574 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(EXTS(SI));
    ALU_ADD(1);
    ALU_END(*rT, 1/*CA*/, 0/*OE*/, 0/*Rc*/);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, 0/*Rc*/);
  }
#line 251 "semantics.c"
  return nia;
  /* extraction: 0.8,6.RT,11.RA,16.SI #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_SI
#line 262 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Compare_Logical_Immediate(cpu *processor,
                                   idecode_cache *cache_entry,
                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Compare_Logical_Immediate
#undef MY_PREFIX
#define MY_PREFIX Compare_Logical_Immediate

  /* extraction: 0.10,6.BF,9./,10.L,11.RA,16.UI #define get-values-from-icache */
#define BF cache_entry->crack.D.BF /* in icache - extraction */
#define BF_BITMASK cache_entry->crack.D.BF_BITMASK /* in icache - extraction */
#define L cache_entry->crack.D.L /* default in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define UI cache_entry->crack.D.UI /* default in icache - extraction */
#line 287 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2833 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Compare Logical Immediate\n"));
#line 293 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Compare_Logical_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2833 "../../sim/ppc/powerpc.igen"
  {
    if (!is_64bit_mode && L)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    else {
      unsigned_word a;
      unsigned_word b = UI;
      if (L == 0)
        a = MASKED(*rA, 32, 63);
      else
        a = *rA;
      CR_COMPARE(BF, a, b);
    }
    PPC_INSN_INT_CR(0, RA_BITMASK, BF_BITMASK);
  }
#line 318 "semantics.c"
  return nia;
  /* extraction: 0.10,6.BF,9./,10.L,11.RA,16.UI #undef get-values-from-icache */
#undef BF
#undef BF_BITMASK
#undef L
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef UI
#line 329 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Compare_Immediate(cpu *processor,
                           idecode_cache *cache_entry,
                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Compare_Immediate
#undef MY_PREFIX
#define MY_PREFIX Compare_Immediate

  /* extraction: 0.11,6.BF,9./,10.L,11.RA,16.SI #define get-values-from-icache */
#define BF cache_entry->crack.D.BF /* in icache - extraction */
#define BF_BITMASK cache_entry->crack.D.BF_BITMASK /* in icache - extraction */
#define L cache_entry->crack.D.L /* default in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_SI cache_entry->crack.D.EXTS_SI /* in icache - extraction */
#line 354 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2791 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Compare Immediate\n"));
#line 360 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Compare_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2791 "../../sim/ppc/powerpc.igen"
  {
    if (!is_64bit_mode && L)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    else {
      signed_word a;
      signed_word b = EXTS(SI);
      if (L == 0)
        a = EXTENDED(*rA);
      else
        a = *rA;
      CR_COMPARE(BF, a, b);
    }
    PPC_INSN_INT_CR(0, RA_BITMASK, BF_BITMASK);
  }
#line 385 "semantics.c"
  return nia;
  /* extraction: 0.11,6.BF,9./,10.L,11.RA,16.SI #undef get-values-from-icache */
#undef BF
#undef BF_BITMASK
#undef L
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_SI
#line 396 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Immediate_Carrying(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate_Carrying
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_Carrying

  /* extraction: 0.12,6.RT,11.RA,16.SI #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_SI cache_entry->crack.D.EXTS_SI /* in icache - extraction */
#line 421 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2554 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Immediate Carrying\n"));
#line 427 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Immediate_Carrying, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2554 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(EXTS(SI));
    ALU_END(*rT, 1/*CA*/, 0/*OE*/, 0/*Rc*/);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, 0/*Rc*/);
  }
#line 443 "semantics.c"
  return nia;
  /* extraction: 0.12,6.RT,11.RA,16.SI #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_SI
#line 454 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Immediate_Carrying_and_Record(cpu *processor,
                                           idecode_cache *cache_entry,
                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate_Carrying_and_Record
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_Carrying_and_Record

  /* extraction: 0.13,6.RT,11.RA,16.SI #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_SI cache_entry->crack.D.EXTS_SI /* in icache - extraction */
#line 479 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2564 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Immediate Carrying and Record\n"));
#line 485 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Immediate_Carrying_and_Record, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2564 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(EXTS(SI));
    ALU_END(*rT, 1/*CA*/, 0/*OE*/, 1/*Rc*/);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, 1/*Rc*/);
  }
#line 501 "semantics.c"
  return nia;
  /* extraction: 0.13,6.RT,11.RA,16.SI #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_SI
#line 512 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Immediate_RA0(cpu *processor,
                           idecode_cache *cache_entry,
                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_RA0

  /* extraction: 0.14,6.RT,11.RA,16.SI #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA 0 /* in icache - constant field */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 1 /* RA == 0 */ /* semantic compute - constant compare */
#define EXTS_SI cache_entry->crack.D.EXTS_SI /* in icache - extraction */
#line 537 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2512 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Immediate\n"));
#line 543 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2512 "../../sim/ppc/powerpc.igen"
  {
    if (RA_is_0)	*rT = EXTS(SI);
    else		*rT = *rA + EXTS(SI);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rT, (long)*rT));
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 559 "semantics.c"
  return nia;
  /* extraction: 0.14,6.RT,11.RA,16.SI #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_SI
#line 570 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Immediate_RA(cpu *processor,
                          idecode_cache *cache_entry,
                          unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_RA

  /* extraction: 0.14,6.RT,11.RA,16.SI #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 0 /* RA == 0 */ /* semantic compute - constant compare */
#define EXTS_SI cache_entry->crack.D.EXTS_SI /* in icache - extraction */
#line 595 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2512 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Immediate\n"));
#line 601 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2512 "../../sim/ppc/powerpc.igen"
  {
    if (RA_is_0)	*rT = EXTS(SI);
    else		*rT = *rA + EXTS(SI);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rT, (long)*rT));
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 617 "semantics.c"
  return nia;
  /* extraction: 0.14,6.RT,11.RA,16.SI #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_SI
#line 628 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Immediate_Shifted_RA0(cpu *processor,
                                   idecode_cache *cache_entry,
                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate_Shifted
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_Shifted_RA0

  /* extraction: 0.15,6.RT,11.RA,16.SI #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA 0 /* in icache - constant field */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 1 /* RA == 0 */ /* semantic compute - constant compare */
#define EXTS_SI cache_entry->crack.D.EXTS_SI /* in icache - extraction */
#line 653 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2522 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Immediate Shifted\n"));
#line 659 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Immediate_Shifted, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2522 "../../sim/ppc/powerpc.igen"
  {
    if (RA_is_0)	*rT = EXTS(SI) << 16;
    else		*rT = *rA + (EXTS(SI) << 16);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rT, (long)*rT));
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 675 "semantics.c"
  return nia;
  /* extraction: 0.15,6.RT,11.RA,16.SI #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_SI
#line 686 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Immediate_Shifted_RA(cpu *processor,
                                  idecode_cache *cache_entry,
                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate_Shifted
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_Shifted_RA

  /* extraction: 0.15,6.RT,11.RA,16.SI #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 0 /* RA == 0 */ /* semantic compute - constant compare */
#define EXTS_SI cache_entry->crack.D.EXTS_SI /* in icache - extraction */
#line 711 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2522 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Immediate Shifted\n"));
#line 717 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Immediate_Shifted, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2522 "../../sim/ppc/powerpc.igen"
  {
    if (RA_is_0)	*rT = EXTS(SI) << 16;
    else		*rT = *rA + (EXTS(SI) << 16);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rT, (long)*rT));
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 733 "semantics.c"
  return nia;
  /* extraction: 0.15,6.RT,11.RA,16.SI #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_SI
#line 744 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO0(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO0

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 0 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 766 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 772 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 821 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 829 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO1(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO1

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 1 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 851 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 857 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 906 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 914 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO2(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO2

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 2 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 936 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 942 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 991 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 999 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO3(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO3

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 3 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1021 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1027 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 1076 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1084 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO4(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO4

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 4 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1106 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1112 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 1161 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1169 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO5(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO5

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 5 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1191 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1197 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 1246 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1254 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO6(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO6

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 6 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1276 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1282 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 1331 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1339 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO7(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO7

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 7 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1361 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1367 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 1416 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1424 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO8(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO8

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 8 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1446 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1452 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 1501 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1509 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO9(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO9

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 9 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1531 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1537 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 1586 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1594 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO10(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO10

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 10 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1616 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1622 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 1671 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1679 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO11(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO11

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 11 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1701 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1707 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 1756 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1764 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO12(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO12

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 12 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1786 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1792 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 1841 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1849 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO13(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO13

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 13 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1871 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1877 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 1926 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 1934 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO14(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO14

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 14 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 1956 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1962 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2011 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2019 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO15(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO15

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 15 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2041 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2047 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2096 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2104 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO16(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO16

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 16 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2126 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2132 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2181 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2189 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO17(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO17

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 17 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2211 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2217 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2266 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2274 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO18(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO18

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 18 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2296 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2302 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2351 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2359 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO19(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO19

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 19 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2381 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2387 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2436 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2444 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO20(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO20

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 20 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2466 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2472 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2521 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2529 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO21(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO21

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 21 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2551 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2557 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2606 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2614 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO22(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO22

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 22 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2636 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2642 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2691 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2699 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO23(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO23

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 23 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2721 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2727 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2776 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2784 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO24(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO24

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 24 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2806 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2812 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2861 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2869 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO25(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO25

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 25 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2891 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2897 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 2946 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 2954 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO26(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO26

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 26 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 2976 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2982 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3031 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3039 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO27(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO27

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 27 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 3061 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3067 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3116 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3124 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO28(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO28

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 28 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 3146 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3152 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3201 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3209 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO29(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO29

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 29 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 3231 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3237 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3286 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3294 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO30(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO30

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 30 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 3316 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3322 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3371 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3379 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK0_BO31(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO31

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 31 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 3401 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3407 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3456 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3464 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO0(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO0

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 0 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 3486 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3492 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3541 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3549 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO1(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO1

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 1 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 3571 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3577 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3626 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3634 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO2(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO2

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 2 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 3656 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3662 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3711 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3719 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO3(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO3

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 3 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 3741 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3747 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3796 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3804 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO4(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO4

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 4 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 3826 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3832 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3881 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3889 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO5(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO5

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 5 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 3911 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3917 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 3966 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 3974 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO6(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO6

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 6 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 3996 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4002 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4051 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4059 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO7(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO7

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 7 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 4081 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4087 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4136 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4144 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO8(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO8

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 8 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 4166 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4172 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4221 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4229 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO9(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO9

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 9 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 4251 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4257 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4306 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4314 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO10(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO10

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 10 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 4336 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4342 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4391 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4399 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO11(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO11

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 11 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 4421 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4427 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4476 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4484 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO12(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO12

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 12 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 4506 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4512 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4561 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4569 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO13(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO13

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 13 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 4591 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4597 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4646 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4654 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO14(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO14

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 14 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 4676 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4682 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4731 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4739 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO15(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO15

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 15 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 4761 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4767 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4816 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4824 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO16(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO16

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 16 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 4846 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4852 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4901 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4909 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO17(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO17

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 17 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 4931 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4937 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 4986 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 4994 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO18(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO18

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 18 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5016 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5022 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 5071 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 5079 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO19(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO19

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 19 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5101 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5107 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 5156 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 5164 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO20(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO20

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 20 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5186 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5192 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 5241 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 5249 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO21(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO21

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 21 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5271 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5277 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 5326 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 5334 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO22(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO22

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 22 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5356 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5362 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 5411 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 5419 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO23(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO23

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 23 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5441 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5447 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 5496 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 5504 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO24(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO24

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 24 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5526 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5532 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 5581 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 5589 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO25(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO25

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 25 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5611 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5617 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 5666 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 5674 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO26(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO26

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 26 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5696 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5702 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 5751 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 5759 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO27(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO27

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 27 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5781 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5787 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 5836 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 5844 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO28(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO28

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 28 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5866 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5872 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 5921 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 5929 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO29(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO29

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 29 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 5951 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5957 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6006 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6014 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO30(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO30

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 30 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 6036 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6042 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6091 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6099 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA0_LK1_BO31(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO31

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 31 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 6121 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6127 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6176 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6184 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO0(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO0

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 0 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 6206 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6212 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6261 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6269 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO1(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO1

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 1 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 6291 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6297 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6346 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6354 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO2(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO2

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 2 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 6376 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6382 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6431 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6439 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO3(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO3

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 3 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 6461 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6467 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6516 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6524 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO4(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO4

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 4 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 6546 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6552 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6601 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6609 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO5(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO5

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 5 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 6631 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6637 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6686 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6694 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO6(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO6

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 6 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 6716 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6722 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6771 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6779 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO7(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO7

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 7 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 6801 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6807 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6856 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6864 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO8(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO8

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 8 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 6886 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6892 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 6941 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 6949 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO9(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO9

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 9 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 6971 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6977 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7026 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7034 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO10(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO10

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 10 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7056 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7062 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7111 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7119 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO11(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO11

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 11 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7141 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7147 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7196 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7204 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO12(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO12

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 12 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7226 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7232 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7281 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7289 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO13(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO13

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 13 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7311 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7317 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7366 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7374 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO14(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO14

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 14 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7396 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7402 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7451 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7459 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO15(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO15

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 15 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7481 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7487 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7536 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7544 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO16(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO16

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 16 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7566 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7572 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7621 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7629 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO17(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO17

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 17 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7651 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7657 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7706 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7714 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO18(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO18

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 18 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7736 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7742 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7791 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7799 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO19(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO19

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 19 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7821 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7827 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7876 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7884 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO20(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO20

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 20 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7906 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7912 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 7961 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 7969 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO21(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO21

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 21 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 7991 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7997 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8046 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8054 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO22(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO22

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 22 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 8076 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8082 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8131 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8139 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO23(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO23

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 23 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 8161 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8167 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8216 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8224 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO24(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO24

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 24 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 8246 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8252 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8301 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8309 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO25(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO25

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 25 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 8331 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8337 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8386 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8394 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO26(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO26

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 26 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 8416 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8422 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8471 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8479 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO27(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO27

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 27 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 8501 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8507 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8556 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8564 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO28(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO28

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 28 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 8586 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8592 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8641 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8649 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO29(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO29

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 29 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 8671 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8677 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8726 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8734 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO30(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO30

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 30 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 8756 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8762 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8811 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8819 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK0_BO31(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO31

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 31 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 8841 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8847 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8896 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8904 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO0(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO0

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 0 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 8926 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8932 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 8981 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 8989 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO1(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO1

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 1 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9011 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9017 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 9066 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 9074 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO2(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO2

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 2 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9096 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9102 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 9151 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 9159 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO3(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO3

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 3 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9181 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9187 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 9236 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 9244 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO4(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO4

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 4 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9266 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9272 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 9321 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 9329 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO5(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO5

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 5 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9351 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9357 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 9406 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 9414 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO6(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO6

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 6 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9436 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9442 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 9491 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 9499 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO7(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO7

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 7 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9521 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9527 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 9576 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 9584 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO8(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO8

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 8 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9606 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9612 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 9661 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 9669 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO9(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO9

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 9 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9691 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9697 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 9746 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 9754 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO10(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO10

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 10 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9776 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9782 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 9831 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 9839 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO11(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO11

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 11 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9861 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9867 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 9916 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 9924 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO12(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO12

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 12 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 9946 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9952 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10001 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10009 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO13(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO13

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 13 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10031 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10037 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10086 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10094 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO14(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO14

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 14 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10116 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10122 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10171 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10179 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO15(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO15

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 15 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10201 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10207 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10256 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10264 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO16(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO16

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 16 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10286 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10292 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10341 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10349 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO17(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO17

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 17 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10371 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10377 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10426 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10434 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO18(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO18

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 18 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10456 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10462 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10511 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10519 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO19(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO19

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 19 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10541 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10547 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10596 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10604 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO20(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO20

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 20 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10626 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10632 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10681 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10689 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO21(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO21

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 21 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10711 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10717 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10766 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10774 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO22(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO22

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 22 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10796 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10802 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10851 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10859 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO23(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO23

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 23 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10881 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10887 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 10936 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 10944 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO24(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO24

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 24 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 10966 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10972 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 11021 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 11029 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO25(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO25

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 25 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 11051 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11057 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 11106 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 11114 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO26(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO26

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 26 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 11136 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11142 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 11191 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 11199 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO27(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO27

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 27 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 11221 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11227 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 11276 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 11284 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO28(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO28

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 28 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 11306 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11312 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 11361 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 11369 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO29(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO29

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 29 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 11391 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11397 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 11446 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 11454 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO30(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO30

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 30 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 11476 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11482 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 11531 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 11539 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_AA1_LK1_BO31(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO31

  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache */
#define BO 31 /* default in icache - constant field */
#define BIT32_BI cache_entry->crack.B.BIT32_BI /* in icache - extraction */
#define EXTS_BD_0b00 cache_entry->crack.B.EXTS_BD_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 11561 "semantics.c"

#define insn cache_entry->crack.B.insn
  unsigned_word nia;
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11567 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
    cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
    if (ctr_ok && cond_ok) {
      if (AA) NIA = IEA(EXTS(BD_0b00));
      else    NIA = IEA(CIA + EXTS(BD_0b00));
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as "normal".
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), succeed, BO);
    if (! BO_0_) {
      int reverse;
      if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
        reverse = EXTS(BD_0b00) < 0;
      } else {	/* branch prediction bit not set */
        reverse = EXTS(BD_0b00) >= 0;
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
    }
  }
#line 11616 "semantics.c"
  return nia;
  /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef EXTS_BD_0b00
#undef AA
#undef LK
#line 11624 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_System_Call(cpu *processor,
                     idecode_cache *cache_entry,
                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_System_Call
#undef MY_PREFIX
#define MY_PREFIX System_Call

  /* extraction: 0.17,6./,11./,16./,30.1,31./ #define get-values-from-icache */
#line 11641 "semantics.c"

#define insn cache_entry->crack.SC.insn
  unsigned_word nia;
#line 1630 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics System Call\n"));
#line 11647 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_System_Call, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1630 "../../sim/ppc/powerpc.igen"
  {
    if (CURRENT_MODEL_ISSUE > 0)
      model_serialize(MY_INDEX, cpu_model(processor));
    system_call_interrupt(processor, cia);
  }
#line 11662 "semantics.c"
  return nia;
  /* extraction: 0.17,6./,11./,16./,30.1,31./ #undef get-values-from-icache */
#line 11665 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_AA0_LK0(cpu *processor,
                        idecode_cache *cache_entry,
                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch
#undef MY_PREFIX
#define MY_PREFIX Branch_AA0_LK0

  /* extraction: 0.18,6.LI,30.AA,31.LK #define get-values-from-icache */
#define EXTS_LI_0b00 cache_entry->crack.I.EXTS_LI_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 11685 "semantics.c"

#define insn cache_entry->crack.I.insn
  unsigned_word nia;
#line 1505 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch\n"));
#line 11691 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1505 "../../sim/ppc/powerpc.igen"
  {
    /* option_mpc860c0:
    No problem here because this branch is predicted taken (unconditional). */
    if (AA) NIA = IEA(EXTS(LI_0b00));
    else    NIA = IEA(CIA + EXTS(LI_0b00));
    if (LK) LR = (spreg)CIA+4;
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), 1, -1);
  }
#line 11710 "semantics.c"
  return nia;
  /* extraction: 0.18,6.LI,30.AA,31.LK #undef get-values-from-icache */
#undef EXTS_LI_0b00
#undef AA
#undef LK
#line 11716 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_AA0_LK1(cpu *processor,
                        idecode_cache *cache_entry,
                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch
#undef MY_PREFIX
#define MY_PREFIX Branch_AA0_LK1

  /* extraction: 0.18,6.LI,30.AA,31.LK #define get-values-from-icache */
#define EXTS_LI_0b00 cache_entry->crack.I.EXTS_LI_0b00 /* in icache - extraction */
#define AA 0 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 11736 "semantics.c"

#define insn cache_entry->crack.I.insn
  unsigned_word nia;
#line 1505 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch\n"));
#line 11742 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1505 "../../sim/ppc/powerpc.igen"
  {
    /* option_mpc860c0:
    No problem here because this branch is predicted taken (unconditional). */
    if (AA) NIA = IEA(EXTS(LI_0b00));
    else    NIA = IEA(CIA + EXTS(LI_0b00));
    if (LK) LR = (spreg)CIA+4;
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), 1, -1);
  }
#line 11761 "semantics.c"
  return nia;
  /* extraction: 0.18,6.LI,30.AA,31.LK #undef get-values-from-icache */
#undef EXTS_LI_0b00
#undef AA
#undef LK
#line 11767 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_AA1_LK0(cpu *processor,
                        idecode_cache *cache_entry,
                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch
#undef MY_PREFIX
#define MY_PREFIX Branch_AA1_LK0

  /* extraction: 0.18,6.LI,30.AA,31.LK #define get-values-from-icache */
#define EXTS_LI_0b00 cache_entry->crack.I.EXTS_LI_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 0 /* default in icache - constant field */
#line 11787 "semantics.c"

#define insn cache_entry->crack.I.insn
  unsigned_word nia;
#line 1505 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch\n"));
#line 11793 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1505 "../../sim/ppc/powerpc.igen"
  {
    /* option_mpc860c0:
    No problem here because this branch is predicted taken (unconditional). */
    if (AA) NIA = IEA(EXTS(LI_0b00));
    else    NIA = IEA(CIA + EXTS(LI_0b00));
    if (LK) LR = (spreg)CIA+4;
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), 1, -1);
  }
#line 11812 "semantics.c"
  return nia;
  /* extraction: 0.18,6.LI,30.AA,31.LK #undef get-values-from-icache */
#undef EXTS_LI_0b00
#undef AA
#undef LK
#line 11818 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_AA1_LK1(cpu *processor,
                        idecode_cache *cache_entry,
                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch
#undef MY_PREFIX
#define MY_PREFIX Branch_AA1_LK1

  /* extraction: 0.18,6.LI,30.AA,31.LK #define get-values-from-icache */
#define EXTS_LI_0b00 cache_entry->crack.I.EXTS_LI_0b00 /* in icache - extraction */
#define AA 1 /* default in icache - constant field */
#define LK 1 /* default in icache - constant field */
#line 11838 "semantics.c"

#define insn cache_entry->crack.I.insn
  unsigned_word nia;
#line 1505 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch\n"));
#line 11844 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1505 "../../sim/ppc/powerpc.igen"
  {
    /* option_mpc860c0:
    No problem here because this branch is predicted taken (unconditional). */
    if (AA) NIA = IEA(EXTS(LI_0b00));
    else    NIA = IEA(CIA + EXTS(LI_0b00));
    if (LK) LR = (spreg)CIA+4;
    if (CURRENT_MODEL_ISSUE > 0)
      model_branches(cpu_model(processor), 1, -1);
  }
#line 11863 "semantics.c"
  return nia;
  /* extraction: 0.18,6.LI,30.AA,31.LK #undef get-values-from-icache */
#undef EXTS_LI_0b00
#undef AA
#undef LK
#line 11869 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_Condition_Register_Field(cpu *processor,
                                       idecode_cache *cache_entry,
                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_Condition_Register_Field
#undef MY_PREFIX
#define MY_PREFIX Move_Condition_Register_Field

  /* extraction: 0.19,6.BF,9./,11.BFA,14./,16./,21.0,31./ #define get-values-from-icache */
#define BF cache_entry->crack.XL.BF /* in icache - extraction */
#define BF_BITMASK cache_entry->crack.XL.BF_BITMASK /* in icache - extraction */
#define BFA cache_entry->crack.XL.BFA /* default in icache - extraction */
#line 11889 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1709 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move Condition Register Field\n"));
#line 11895 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_Condition_Register_Field, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1709 "../../sim/ppc/powerpc.igen"
  {
    MBLIT32(CR, 4*BF, 4*BF+3, EXTRACTED32(CR, 4*BFA, 4*BFA+3));
    PPC_INSN_CR(BF_BITMASK, 1 << BFA);
  }
#line 11909 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BF,9./,11.BFA,14./,16./,21.0,31./ #undef get-values-from-icache */
#undef BF
#undef BF_BITMASK
#undef BFA
#line 11915 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_to_Link_Register_LK0(cpu *processor,
                                                 idecode_cache *cache_entry,
                                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional_to_Link_Register
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_to_Link_Register_LK0

  /* extraction: 0.19,6.BO,11.BI,16./,21.16,31.LK #define get-values-from-icache */
#define BO cache_entry->crack.XL.BO /* default in icache - extraction */
#define BIT32_BI cache_entry->crack.XL.BIT32_BI /* in icache - extraction */
#define LK 0 /* default in icache - constant field */
#line 11935 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1561 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional to Link Register\n"));
#line 11941 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional_to_Link_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1561 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != BO_3_);
    cond_ok = BO_0_ || (CR_BI_ == BO_1_);
    if (ctr_ok && cond_ok) {
      NIA = IEA(LR_0b00);
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as not-taken.
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0) {
      model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_)
        model_branch_predict(cpu_model(processor), BO_4_ ? !succeed : succeed);
    }
  }
#line 11982 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BO,11.BI,16./,21.16,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef LK
#line 11988 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_to_Link_Register_LK1(cpu *processor,
                                                 idecode_cache *cache_entry,
                                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional_to_Link_Register
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_to_Link_Register_LK1

  /* extraction: 0.19,6.BO,11.BI,16./,21.16,31.LK #define get-values-from-icache */
#define BO cache_entry->crack.XL.BO /* default in icache - extraction */
#define BIT32_BI cache_entry->crack.XL.BIT32_BI /* in icache - extraction */
#define LK 1 /* default in icache - constant field */
#line 12008 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1561 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional to Link Register\n"));
#line 12014 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional_to_Link_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1561 "../../sim/ppc/powerpc.igen"
  {
    int M, ctr_ok, cond_ok, succeed;
    if (is_64bit_implementation && is_64bit_mode) M = 0;
    else                                          M = 32;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    if (!BO_2_) CTR = CTR - 1;
    ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != BO_3_);
    cond_ok = BO_0_ || (CR_BI_ == BO_1_);
    if (ctr_ok && cond_ok) {
      NIA = IEA(LR_0b00);
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as not-taken.
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0) {
      model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_)
        model_branch_predict(cpu_model(processor), BO_4_ ? !succeed : succeed);
    }
  }
#line 12055 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BO,11.BI,16./,21.16,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef LK
#line 12061 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Condition_Register_NOR(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_NOR
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_NOR

  /* extraction: 0.19,6.BT,11.BA,16.BB,21.33,31./ #define get-values-from-icache */
#define BT cache_entry->crack.XL.BT /* in icache - extraction */
#define BT_BITMASK cache_entry->crack.XL.BT_BITMASK /* in icache - extraction */
#define BIT32_BA cache_entry->crack.XL.BIT32_BA /* in icache - extraction */
#define BA_BITMASK cache_entry->crack.XL.BA_BITMASK /* in icache - extraction */
#define BIT32_BB cache_entry->crack.XL.BIT32_BB /* in icache - extraction */
#define BB_BITMASK cache_entry->crack.XL.BB_BITMASK /* in icache - extraction */
#line 12084 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1674 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Condition Register NOR\n"));
#line 12090 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Condition_Register_NOR, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1674 "../../sim/ppc/powerpc.igen"
  {
    BLIT32(CR, BT, !(CR_BA_ || CR_BB_));
    PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
  }
#line 12104 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BT,11.BA,16.BB,21.33,31./ #undef get-values-from-icache */
#undef BT
#undef BT_BITMASK
#undef BIT32_BA
#undef BA_BITMASK
#undef BIT32_BB
#undef BB_BITMASK
#line 12113 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Return_From_Interrupt(cpu *processor,
                               idecode_cache *cache_entry,
                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Return_From_Interrupt
#undef MY_PREFIX
#define MY_PREFIX Return_From_Interrupt

  /* extraction: 0.19,6./,11./,16./,21.50,31./ #define get-values-from-icache */
#line 12130 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 4861 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Return From Interrupt\n"));
#line 12136 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Return_From_Interrupt, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4861 "../../sim/ppc/powerpc.igen"
  {
    if (IS_PROBLEM_STATE(processor)) {
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    }
    else {
      MSR = (MASKED(SRR1, 0, 32)
             | MASKED(SRR1, 37, 41)
             | MASKED(SRR1, 48, 63));
      NIA = MASKED(SRR0, 0, 61);
      cpu_synchronize_context(processor, cia);
      check_masked_interrupts(processor);
    }
  }
#line 12160 "semantics.c"
  return nia;
  /* extraction: 0.19,6./,11./,16./,21.50,31./ #undef get-values-from-icache */
#line 12163 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Condition_Register_AND_with_Complement(cpu *processor,
                                                idecode_cache *cache_entry,
                                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_AND_with_Complement
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_AND_with_Complement

  /* extraction: 0.19,6.BT,11.BA,16.BB,21.129,31./ #define get-values-from-icache */
#define BT cache_entry->crack.XL.BT /* in icache - extraction */
#define BT_BITMASK cache_entry->crack.XL.BT_BITMASK /* in icache - extraction */
#define BIT32_BA cache_entry->crack.XL.BIT32_BA /* in icache - extraction */
#define BA_BITMASK cache_entry->crack.XL.BA_BITMASK /* in icache - extraction */
#define BIT32_BB cache_entry->crack.XL.BIT32_BB /* in icache - extraction */
#define BB_BITMASK cache_entry->crack.XL.BB_BITMASK /* in icache - extraction */
#line 12186 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1690 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Condition Register AND with Complement\n"));
#line 12192 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Condition_Register_AND_with_Complement, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1690 "../../sim/ppc/powerpc.igen"
  {
    BLIT32(CR, BT, CR_BA_ && !CR_BB_);
    PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
  }
#line 12206 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BT,11.BA,16.BB,21.129,31./ #undef get-values-from-icache */
#undef BT
#undef BT_BITMASK
#undef BIT32_BA
#undef BA_BITMASK
#undef BIT32_BB
#undef BB_BITMASK
#line 12215 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Instruction_Synchronize(cpu *processor,
                                 idecode_cache *cache_entry,
                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Instruction_Synchronize
#undef MY_PREFIX
#define MY_PREFIX Instruction_Synchronize

  /* extraction: 0.19,6./,11./,16./,21.150,31./ #define get-values-from-icache */
#line 12232 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 4774 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Instruction Synchronize\n"));
#line 12238 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Instruction_Synchronize, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4774 "../../sim/ppc/powerpc.igen"
  {
    cpu_synchronize_context(processor, cia);
    PPC_INSN_INT(0, 0, 0);
  }
#line 12252 "semantics.c"
  return nia;
  /* extraction: 0.19,6./,11./,16./,21.150,31./ #undef get-values-from-icache */
#line 12255 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Condition_Register_XOR(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_XOR
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_XOR

  /* extraction: 0.19,6.BT,11.BA,16.BB,21.193,31./ #define get-values-from-icache */
#define BT cache_entry->crack.XL.BT /* in icache - extraction */
#define BT_BITMASK cache_entry->crack.XL.BT_BITMASK /* in icache - extraction */
#define BIT32_BA cache_entry->crack.XL.BIT32_BA /* in icache - extraction */
#define BA_BITMASK cache_entry->crack.XL.BA_BITMASK /* in icache - extraction */
#define BIT32_BB cache_entry->crack.XL.BIT32_BB /* in icache - extraction */
#define BB_BITMASK cache_entry->crack.XL.BB_BITMASK /* in icache - extraction */
#line 12278 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1658 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Condition Register XOR\n"));
#line 12284 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Condition_Register_XOR, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1658 "../../sim/ppc/powerpc.igen"
  {
    BLIT32(CR, BT, CR_BA_ != CR_BB_);
    PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
  }
#line 12298 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BT,11.BA,16.BB,21.193,31./ #undef get-values-from-icache */
#undef BT
#undef BT_BITMASK
#undef BIT32_BA
#undef BA_BITMASK
#undef BIT32_BB
#undef BB_BITMASK
#line 12307 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Condition_Register_NAND(cpu *processor,
                                 idecode_cache *cache_entry,
                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_NAND
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_NAND

  /* extraction: 0.19,6.BT,11.BA,16.BB,21.225,31./ #define get-values-from-icache */
#define BT cache_entry->crack.XL.BT /* in icache - extraction */
#define BT_BITMASK cache_entry->crack.XL.BT_BITMASK /* in icache - extraction */
#define BIT32_BA cache_entry->crack.XL.BIT32_BA /* in icache - extraction */
#define BA_BITMASK cache_entry->crack.XL.BA_BITMASK /* in icache - extraction */
#define BIT32_BB cache_entry->crack.XL.BIT32_BB /* in icache - extraction */
#define BB_BITMASK cache_entry->crack.XL.BB_BITMASK /* in icache - extraction */
#line 12330 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1666 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Condition Register NAND\n"));
#line 12336 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Condition_Register_NAND, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1666 "../../sim/ppc/powerpc.igen"
  {
    BLIT32(CR, BT, !(CR_BA_ && CR_BB_));
    PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
  }
#line 12350 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BT,11.BA,16.BB,21.225,31./ #undef get-values-from-icache */
#undef BT
#undef BT_BITMASK
#undef BIT32_BA
#undef BA_BITMASK
#undef BIT32_BB
#undef BB_BITMASK
#line 12359 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Condition_Register_AND(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_AND
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_AND

  /* extraction: 0.19,6.BT,11.BA,16.BB,21.257,31./ #define get-values-from-icache */
#define BT cache_entry->crack.XL.BT /* in icache - extraction */
#define BT_BITMASK cache_entry->crack.XL.BT_BITMASK /* in icache - extraction */
#define BIT32_BA cache_entry->crack.XL.BIT32_BA /* in icache - extraction */
#define BA_BITMASK cache_entry->crack.XL.BA_BITMASK /* in icache - extraction */
#define BIT32_BB cache_entry->crack.XL.BIT32_BB /* in icache - extraction */
#define BB_BITMASK cache_entry->crack.XL.BB_BITMASK /* in icache - extraction */
#line 12382 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1642 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Condition Register AND\n"));
#line 12388 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Condition_Register_AND, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1642 "../../sim/ppc/powerpc.igen"
  {
    BLIT32(CR, BT, CR_BA_ && CR_BB_);
    PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
  }
#line 12402 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BT,11.BA,16.BB,21.257,31./ #undef get-values-from-icache */
#undef BT
#undef BT_BITMASK
#undef BIT32_BA
#undef BA_BITMASK
#undef BIT32_BB
#undef BB_BITMASK
#line 12411 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Condition_Register_Equivalent(cpu *processor,
                                       idecode_cache *cache_entry,
                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_Equivalent
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_Equivalent

  /* extraction: 0.19,6.BT,11.BA,16.BB,21.289,31./ #define get-values-from-icache */
#define BT cache_entry->crack.XL.BT /* in icache - extraction */
#define BT_BITMASK cache_entry->crack.XL.BT_BITMASK /* in icache - extraction */
#define BIT32_BA cache_entry->crack.XL.BIT32_BA /* in icache - extraction */
#define BA_BITMASK cache_entry->crack.XL.BA_BITMASK /* in icache - extraction */
#define BIT32_BB cache_entry->crack.XL.BIT32_BB /* in icache - extraction */
#define BB_BITMASK cache_entry->crack.XL.BB_BITMASK /* in icache - extraction */
#line 12434 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1682 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Condition Register Equivalent\n"));
#line 12440 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Condition_Register_Equivalent, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1682 "../../sim/ppc/powerpc.igen"
  {
    BLIT32(CR, BT, CR_BA_ == CR_BB_);
    PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
  }
#line 12454 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BT,11.BA,16.BB,21.289,31./ #undef get-values-from-icache */
#undef BT
#undef BT_BITMASK
#undef BIT32_BA
#undef BA_BITMASK
#undef BIT32_BB
#undef BB_BITMASK
#line 12463 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Condition_Register_OR_with_Complement(cpu *processor,
                                               idecode_cache *cache_entry,
                                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_OR_with_Complement
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_OR_with_Complement

  /* extraction: 0.19,6.BT,11.BA,16.BB,21.417,31./ #define get-values-from-icache */
#define BT cache_entry->crack.XL.BT /* in icache - extraction */
#define BT_BITMASK cache_entry->crack.XL.BT_BITMASK /* in icache - extraction */
#define BIT32_BA cache_entry->crack.XL.BIT32_BA /* in icache - extraction */
#define BA_BITMASK cache_entry->crack.XL.BA_BITMASK /* in icache - extraction */
#define BIT32_BB cache_entry->crack.XL.BIT32_BB /* in icache - extraction */
#define BB_BITMASK cache_entry->crack.XL.BB_BITMASK /* in icache - extraction */
#line 12486 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1698 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Condition Register OR with Complement\n"));
#line 12492 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Condition_Register_OR_with_Complement, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1698 "../../sim/ppc/powerpc.igen"
  {
    BLIT32(CR, BT, CR_BA_ || !CR_BB_);
    PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
  }
#line 12506 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BT,11.BA,16.BB,21.417,31./ #undef get-values-from-icache */
#undef BT
#undef BT_BITMASK
#undef BIT32_BA
#undef BA_BITMASK
#undef BIT32_BB
#undef BB_BITMASK
#line 12515 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Condition_Register_OR(cpu *processor,
                               idecode_cache *cache_entry,
                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_OR
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_OR

  /* extraction: 0.19,6.BT,11.BA,16.BB,21.449,31./ #define get-values-from-icache */
#define BT cache_entry->crack.XL.BT /* in icache - extraction */
#define BT_BITMASK cache_entry->crack.XL.BT_BITMASK /* in icache - extraction */
#define BIT32_BA cache_entry->crack.XL.BIT32_BA /* in icache - extraction */
#define BA_BITMASK cache_entry->crack.XL.BA_BITMASK /* in icache - extraction */
#define BIT32_BB cache_entry->crack.XL.BIT32_BB /* in icache - extraction */
#define BB_BITMASK cache_entry->crack.XL.BB_BITMASK /* in icache - extraction */
#line 12538 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1650 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Condition Register OR\n"));
#line 12544 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Condition_Register_OR, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1650 "../../sim/ppc/powerpc.igen"
  {
    BLIT32(CR, BT, CR_BA_ || CR_BB_);
    PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
  }
#line 12558 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BT,11.BA,16.BB,21.449,31./ #undef get-values-from-icache */
#undef BT
#undef BT_BITMASK
#undef BIT32_BA
#undef BA_BITMASK
#undef BIT32_BB
#undef BB_BITMASK
#line 12567 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_to_Count_Register_LK0(cpu *processor,
                                                  idecode_cache *cache_entry,
                                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional_to_Count_Register
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_to_Count_Register_LK0

  /* extraction: 0.19,6.BO,11.BI,16./,21.528,31.LK #define get-values-from-icache */
#define BO cache_entry->crack.XL.BO /* default in icache - extraction */
#define BIT32_BI cache_entry->crack.XL.BIT32_BI /* in icache - extraction */
#define LK 0 /* default in icache - constant field */
#line 12587 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1596 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional to Count Register\n"));
#line 12593 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional_to_Count_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1596 "../../sim/ppc/powerpc.igen"
  {
    int cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    cond_ok = BO_0_ || (CR_BI_ == BO_1_);
    if (cond_ok) {
      NIA = IEA(CTR_0b00);
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as not-taken.
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0) {
      model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_)
        model_branch_predict(cpu_model(processor), BO_4_ ? !succeed : succeed);
    }
  }
#line 12630 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BO,11.BI,16./,21.528,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef LK
#line 12636 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Branch_Conditional_to_Count_Register_LK1(cpu *processor,
                                                  idecode_cache *cache_entry,
                                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional_to_Count_Register
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_to_Count_Register_LK1

  /* extraction: 0.19,6.BO,11.BI,16./,21.528,31.LK #define get-values-from-icache */
#define BO cache_entry->crack.XL.BO /* default in icache - extraction */
#define BIT32_BI cache_entry->crack.XL.BIT32_BI /* in icache - extraction */
#define LK 1 /* default in icache - constant field */
#line 12656 "semantics.c"

#define insn cache_entry->crack.XL.insn
  unsigned_word nia;
#line 1596 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Branch Conditional to Count Register\n"));
#line 12662 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Branch_Conditional_to_Count_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1596 "../../sim/ppc/powerpc.igen"
  {
    int cond_ok, succeed;
    if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
      model_wait_for_cr(cpu_model(processor), BIT32_BI);
    cond_ok = BO_0_ || (CR_BI_ == BO_1_);
    if (cond_ok) {
      NIA = IEA(CTR_0b00);
      succeed = 1;
    }
    else
      succeed = 0;
    if (LK) LR = (spreg)IEA(CIA + 4);
    if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
      /* This branch is predicted as not-taken.
      If this is a forward branch and it is near the end of a page,
      we've detected a problematic branch. */
      if (succeed && NIA > CIA) {
        if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
          program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
      }
    }
    if (CURRENT_MODEL_ISSUE > 0) {
      model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_)
        model_branch_predict(cpu_model(processor), BO_4_ ? !succeed : succeed);
    }
  }
#line 12699 "semantics.c"
  return nia;
  /* extraction: 0.19,6.BO,11.BI,16./,21.528,31.LK #undef get-values-from-icache */
#undef BO
#undef BIT32_BI
#undef LK
#line 12705 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Rotate_Left_Word_Immediate_then_Mask_Insert_Rc0(cpu *processor,
                                                         idecode_cache *cache_entry,
                                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_Immediate_then_Mask_Insert
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_Immediate_then_Mask_Insert_Rc0

  /* extraction: 0.20,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.M.RS /* in icache - extraction */
#define rS cache_entry->crack.M.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.M.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.M.RA /* in icache - extraction */
#define rA cache_entry->crack.M.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.M.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define SH cache_entry->crack.M.SH /* default in icache - extraction */
#define MB cache_entry->crack.M.MB /* default in icache - extraction */
#define ME cache_entry->crack.M.ME /* default in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 12733 "semantics.c"

#define insn cache_entry->crack.M.insn
  unsigned_word nia;
#line 3231 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Rotate Left Word Immediate then Mask Insert\n"));
#line 12739 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Rotate_Left_Word_Immediate_then_Mask_Insert, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3231 "../../sim/ppc/powerpc.igen"
  {
    long n = SH;
    uint32_t r = ROTL32(*rS, n);
    uint32_t m = MASK(MB+32, ME+32);
    signed_word result = (r & m) | (*rA & ~m);
    *rA = result;
    ITRACE(trace_alu, (": n=%ld *rS=0x%lx r=0x%lx m=0x%lx result=0x%lx\n",
                       n, (unsigned long)*rS, (unsigned long)r, (unsigned long)m,
    		   (unsigned long)result));
    CR0_COMPARE(result, 0, Rc);
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 12761 "semantics.c"
  return nia;
  /* extraction: 0.20,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef SH
#undef MB
#undef ME
#undef Rc
#line 12775 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Rotate_Left_Word_Immediate_then_Mask_Insert_Rc1(cpu *processor,
                                                         idecode_cache *cache_entry,
                                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_Immediate_then_Mask_Insert
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_Immediate_then_Mask_Insert_Rc1

  /* extraction: 0.20,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.M.RS /* in icache - extraction */
#define rS cache_entry->crack.M.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.M.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.M.RA /* in icache - extraction */
#define rA cache_entry->crack.M.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.M.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define SH cache_entry->crack.M.SH /* default in icache - extraction */
#define MB cache_entry->crack.M.MB /* default in icache - extraction */
#define ME cache_entry->crack.M.ME /* default in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 12803 "semantics.c"

#define insn cache_entry->crack.M.insn
  unsigned_word nia;
#line 3231 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Rotate Left Word Immediate then Mask Insert\n"));
#line 12809 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Rotate_Left_Word_Immediate_then_Mask_Insert, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3231 "../../sim/ppc/powerpc.igen"
  {
    long n = SH;
    uint32_t r = ROTL32(*rS, n);
    uint32_t m = MASK(MB+32, ME+32);
    signed_word result = (r & m) | (*rA & ~m);
    *rA = result;
    ITRACE(trace_alu, (": n=%ld *rS=0x%lx r=0x%lx m=0x%lx result=0x%lx\n",
                       n, (unsigned long)*rS, (unsigned long)r, (unsigned long)m,
    		   (unsigned long)result));
    CR0_COMPARE(result, 0, Rc);
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 12831 "semantics.c"
  return nia;
  /* extraction: 0.20,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef SH
#undef MB
#undef ME
#undef Rc
#line 12845 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc0(cpu *processor,
                                                           idecode_cache *cache_entry,
                                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_Immediate_then_AND_with_Mask
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc0

  /* extraction: 0.21,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.M.RS /* in icache - extraction */
#define rS cache_entry->crack.M.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.M.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.M.RA /* in icache - extraction */
#define rA cache_entry->crack.M.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.M.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define SH cache_entry->crack.M.SH /* default in icache - extraction */
#define MB cache_entry->crack.M.MB /* default in icache - extraction */
#define ME cache_entry->crack.M.ME /* default in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 12873 "semantics.c"

#define insn cache_entry->crack.M.insn
  unsigned_word nia;
#line 3178 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Rotate Left Word Immediate then AND with Mask\n"));
#line 12879 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Rotate_Left_Word_Immediate_then_AND_with_Mask, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3178 "../../sim/ppc/powerpc.igen"
  {
    long n = SH;
    uint32_t s = *rS;
    uint32_t r = ROTL32(s, n);
    uint32_t m = MASK(MB+32, ME+32);
    signed_word result = r & m;
    *rA = result;
    CR0_COMPARE(result, 0, Rc);
    ITRACE(trace_alu,
           ("n=%ld, s=0x%lx, r=0x%lx, m=0x%lx, result=0x%lx, cr=0x%lx\n",
            n, (unsigned long)s, (unsigned long)r, (unsigned long)m,
    	(unsigned long)result, (unsigned long)CR));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 12903 "semantics.c"
  return nia;
  /* extraction: 0.21,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef SH
#undef MB
#undef ME
#undef Rc
#line 12917 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc1(cpu *processor,
                                                           idecode_cache *cache_entry,
                                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_Immediate_then_AND_with_Mask
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc1

  /* extraction: 0.21,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.M.RS /* in icache - extraction */
#define rS cache_entry->crack.M.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.M.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.M.RA /* in icache - extraction */
#define rA cache_entry->crack.M.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.M.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define SH cache_entry->crack.M.SH /* default in icache - extraction */
#define MB cache_entry->crack.M.MB /* default in icache - extraction */
#define ME cache_entry->crack.M.ME /* default in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 12945 "semantics.c"

#define insn cache_entry->crack.M.insn
  unsigned_word nia;
#line 3178 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Rotate Left Word Immediate then AND with Mask\n"));
#line 12951 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Rotate_Left_Word_Immediate_then_AND_with_Mask, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3178 "../../sim/ppc/powerpc.igen"
  {
    long n = SH;
    uint32_t s = *rS;
    uint32_t r = ROTL32(s, n);
    uint32_t m = MASK(MB+32, ME+32);
    signed_word result = r & m;
    *rA = result;
    CR0_COMPARE(result, 0, Rc);
    ITRACE(trace_alu,
           ("n=%ld, s=0x%lx, r=0x%lx, m=0x%lx, result=0x%lx, cr=0x%lx\n",
            n, (unsigned long)s, (unsigned long)r, (unsigned long)m,
    	(unsigned long)result, (unsigned long)CR));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 12975 "semantics.c"
  return nia;
  /* extraction: 0.21,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef SH
#undef MB
#undef ME
#undef Rc
#line 12989 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Rotate_Left_Word_then_AND_with_Mask_Rc0(cpu *processor,
                                                 idecode_cache *cache_entry,
                                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_then_AND_with_Mask
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_then_AND_with_Mask_Rc0

  /* extraction: 0.23,6.RS,11.RA,16.RB,21.MB,26.ME,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.M.RS /* in icache - extraction */
#define rS cache_entry->crack.M.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.M.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.M.RA /* in icache - extraction */
#define rA cache_entry->crack.M.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.M.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.M.RB /* in icache - extraction */
#define rB cache_entry->crack.M.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.M.RB_BITMASK /* in icache - extraction */
#define MB cache_entry->crack.M.MB /* default in icache - extraction */
#define ME cache_entry->crack.M.ME /* default in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 13019 "semantics.c"

#define insn cache_entry->crack.M.insn
  unsigned_word nia;
#line 3210 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Rotate Left Word then AND with Mask\n"));
#line 13025 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Rotate_Left_Word_then_AND_with_Mask, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3210 "../../sim/ppc/powerpc.igen"
  {
    long n = MASKED(*rB, 59, 63);
    uint32_t r = ROTL32(*rS, n);
    uint32_t m = MASK(MB+32, ME+32);
    signed_word result = r & m;
    *rA = result;
    CR0_COMPARE(result, 0, Rc);
  }
#line 13043 "semantics.c"
  return nia;
  /* extraction: 0.23,6.RS,11.RA,16.RB,21.MB,26.ME,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef MB
#undef ME
#undef Rc
#line 13059 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Rotate_Left_Word_then_AND_with_Mask_Rc1(cpu *processor,
                                                 idecode_cache *cache_entry,
                                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_then_AND_with_Mask
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_then_AND_with_Mask_Rc1

  /* extraction: 0.23,6.RS,11.RA,16.RB,21.MB,26.ME,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.M.RS /* in icache - extraction */
#define rS cache_entry->crack.M.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.M.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.M.RA /* in icache - extraction */
#define rA cache_entry->crack.M.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.M.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.M.RB /* in icache - extraction */
#define rB cache_entry->crack.M.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.M.RB_BITMASK /* in icache - extraction */
#define MB cache_entry->crack.M.MB /* default in icache - extraction */
#define ME cache_entry->crack.M.ME /* default in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 13089 "semantics.c"

#define insn cache_entry->crack.M.insn
  unsigned_word nia;
#line 3210 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Rotate Left Word then AND with Mask\n"));
#line 13095 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Rotate_Left_Word_then_AND_with_Mask, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3210 "../../sim/ppc/powerpc.igen"
  {
    long n = MASKED(*rB, 59, 63);
    uint32_t r = ROTL32(*rS, n);
    uint32_t m = MASK(MB+32, ME+32);
    signed_word result = r & m;
    *rA = result;
    CR0_COMPARE(result, 0, Rc);
  }
#line 13113 "semantics.c"
  return nia;
  /* extraction: 0.23,6.RS,11.RA,16.RB,21.MB,26.ME,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef MB
#undef ME
#undef Rc
#line 13129 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_OR_Immediate(cpu *processor,
                      idecode_cache *cache_entry,
                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_OR_Immediate
#undef MY_PREFIX
#define MY_PREFIX OR_Immediate

  /* extraction: 0.24,6.RS,11.RA,16.UI #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define UI cache_entry->crack.D.UI /* default in icache - extraction */
#line 13154 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2974 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics OR Immediate\n"));
#line 13160 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_OR_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2974 "../../sim/ppc/powerpc.igen"
  {
    *rA = *rS | UI;
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 0/*Rc*/);
  }
#line 13175 "semantics.c"
  return nia;
  /* extraction: 0.24,6.RS,11.RA,16.UI #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef UI
#line 13186 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_OR_Immediate_Shifted(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_OR_Immediate_Shifted
#undef MY_PREFIX
#define MY_PREFIX OR_Immediate_Shifted

  /* extraction: 0.25,6.RS,11.RA,16.UI #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define UI cache_entry->crack.D.UI /* default in icache - extraction */
#line 13211 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2983 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics OR Immediate Shifted\n"));
#line 13217 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_OR_Immediate_Shifted, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2983 "../../sim/ppc/powerpc.igen"
  {
    *rA = *rS | (UI << 16);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 0/*Rc*/);
  }
#line 13232 "semantics.c"
  return nia;
  /* extraction: 0.25,6.RS,11.RA,16.UI #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef UI
#line 13243 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_XOR_Immediate(cpu *processor,
                       idecode_cache *cache_entry,
                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_XOR_Immediate
#undef MY_PREFIX
#define MY_PREFIX XOR_Immediate

  /* extraction: 0.26,6.RS,11.RA,16.UI #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define UI cache_entry->crack.D.UI /* default in icache - extraction */
#line 13268 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2992 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics XOR Immediate\n"));
#line 13274 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_XOR_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2992 "../../sim/ppc/powerpc.igen"
  {
    *rA = *rS ^ UI;
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 0/*Rc*/);
  }
#line 13289 "semantics.c"
  return nia;
  /* extraction: 0.26,6.RS,11.RA,16.UI #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef UI
#line 13300 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_XOR_Immediate_Shifted(cpu *processor,
                               idecode_cache *cache_entry,
                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_XOR_Immediate_Shifted
#undef MY_PREFIX
#define MY_PREFIX XOR_Immediate_Shifted

  /* extraction: 0.27,6.RS,11.RA,16.UI #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define UI cache_entry->crack.D.UI /* default in icache - extraction */
#line 13325 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 3001 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics XOR Immediate Shifted\n"));
#line 13331 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_XOR_Immediate_Shifted, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3001 "../../sim/ppc/powerpc.igen"
  {
    *rA = *rS ^ (UI << 16);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 0/*Rc*/);
  }
#line 13346 "semantics.c"
  return nia;
  /* extraction: 0.27,6.RS,11.RA,16.UI #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef UI
#line 13357 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_AND_Immediate(cpu *processor,
                       idecode_cache *cache_entry,
                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_AND_Immediate
#undef MY_PREFIX
#define MY_PREFIX AND_Immediate

  /* extraction: 0.28,6.RS,11.RA,16.UI #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define UI cache_entry->crack.D.UI /* default in icache - extraction */
#line 13382 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2954 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics AND Immediate\n"));
#line 13388 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_AND_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2954 "../../sim/ppc/powerpc.igen"
  {
    *rA = *rS & UI;
    CR0_COMPARE(*rA, 0, 1/*Rc*/);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 1/*Rc*/);
  }
#line 13404 "semantics.c"
  return nia;
  /* extraction: 0.28,6.RS,11.RA,16.UI #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef UI
#line 13415 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_AND_Immediate_Shifted(cpu *processor,
                               idecode_cache *cache_entry,
                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_AND_Immediate_Shifted
#undef MY_PREFIX
#define MY_PREFIX AND_Immediate_Shifted

  /* extraction: 0.29,6.RS,11.RA,16.UI #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define UI cache_entry->crack.D.UI /* default in icache - extraction */
#line 13440 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2964 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics AND Immediate Shifted\n"));
#line 13446 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_AND_Immediate_Shifted, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2964 "../../sim/ppc/powerpc.igen"
  {
    *rA = *rS & (UI << 16);
    CR0_COMPARE(*rA, 0, 1/*Rc*/);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 1/*Rc*/);
  }
#line 13462 "semantics.c"
  return nia;
  /* extraction: 0.29,6.RS,11.RA,16.UI #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef UI
#line 13473 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Compare(cpu *processor,
                 idecode_cache *cache_entry,
                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Compare
#undef MY_PREFIX
#define MY_PREFIX Compare

  /* extraction: 0.31,6.BF,9./,10.L,11.RA,16.RB,21.0,31./ #define get-values-from-icache */
#define BF cache_entry->crack.X.BF /* in icache - extraction */
#define BF_BITMASK cache_entry->crack.X.BF_BITMASK /* in icache - extraction */
#define L cache_entry->crack.X.L /* default in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 13500 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2810 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Compare\n"));
#line 13506 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Compare, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2810 "../../sim/ppc/powerpc.igen"
  {
    if (!is_64bit_mode && L)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    else {
      signed_word a;
      signed_word b;
      if (L == 0) {
        a = EXTENDED(*rA);
        b = EXTENDED(*rB);
      }
      else {
        a = *rA;
        b = *rB;
      }
      CR_COMPARE(BF, a, b);
    }
    PPC_INSN_INT_CR(0, RA_BITMASK | RB_BITMASK, BF_BITMASK);
  }
#line 13535 "semantics.c"
  return nia;
  /* extraction: 0.31,6.BF,9./,10.L,11.RA,16.RB,21.0,31./ #undef get-values-from-icache */
#undef BF
#undef BF_BITMASK
#undef L
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 13548 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Trap_Word(cpu *processor,
                   idecode_cache *cache_entry,
                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Trap_Word
#undef MY_PREFIX
#define MY_PREFIX Trap_Word

  /* extraction: 0.31,6.TO,11.RA,16.RB,21.4,31./ #define get-values-from-icache */
#define TO cache_entry->crack.X.TO /* default in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 13573 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2930 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Trap Word\n"));
#line 13579 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Trap_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2930 "../../sim/ppc/powerpc.igen"
  {
    signed_word a = EXTENDED(*rA);
    signed_word b = EXTENDED(*rB);
    if (TO == 12 && rA == rB) {
      ITRACE(trace_breakpoint, ("breakpoint\n"));
      cpu_halt(processor, cia, was_trap, 0);
    }
    else if ((a < b && TO_0_)
        || (a > b && TO_1_)
        || (a == b && TO_2_)
        || ((unsigned_word)a < (unsigned_word)b && TO_3_)
        || ((unsigned_word)a > (unsigned_word)b && TO_4_)
        )
      program_interrupt(processor, cia,
                        trap_program_interrupt);
  }
#line 13605 "semantics.c"
  return nia;
  /* extraction: 0.31,6.TO,11.RA,16.RB,21.4,31./ #undef get-values-from-icache */
#undef TO
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 13616 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Carrying_OE0_Rc0(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Carrying
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Carrying_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 13645 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2596 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Carrying\n"));
#line 13651 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Carrying, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2596 "../../sim/ppc/powerpc.igen"
  {
    /* RT <- ~RA + RB + 1 === RT <- RB - RA */
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD(1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 13670 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 13685 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Carrying_OE0_Rc1(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Carrying
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Carrying_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 13714 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2596 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Carrying\n"));
#line 13720 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Carrying, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2596 "../../sim/ppc/powerpc.igen"
  {
    /* RT <- ~RA + RB + 1 === RT <- RB - RA */
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD(1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 13739 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 13754 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Carrying_OE0_Rc0(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Carrying
#undef MY_PREFIX
#define MY_PREFIX Add_Carrying_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 13783 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2586 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Carrying\n"));
#line 13789 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Carrying, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2586 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 13805 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 13820 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Carrying_OE0_Rc1(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Carrying
#undef MY_PREFIX
#define MY_PREFIX Add_Carrying_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 13849 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2586 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Carrying\n"));
#line 13855 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Carrying, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2586 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 13871 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 13886 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Multiply_High_Word_Unsigned_Rc0(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_High_Word_Unsigned
#undef MY_PREFIX
#define MY_PREFIX Multiply_High_Word_Unsigned_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.11,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 13914 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2730 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Multiply High Word Unsigned\n"));
#line 13920 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Multiply_High_Word_Unsigned, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2730 "../../sim/ppc/powerpc.igen"
  {
    uint64_t a = (uint32_t)(*rA);
    uint64_t b = (uint32_t)(*rB);
    uint64_t prod = a * b;
    signed_word t = EXTRACTED64(prod, 0, 31);
    *rT = t;
    CR0_COMPARE(t, 0, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 13939 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.11,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 13953 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Multiply_High_Word_Unsigned_Rc1(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_High_Word_Unsigned
#undef MY_PREFIX
#define MY_PREFIX Multiply_High_Word_Unsigned_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.11,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 13981 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2730 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Multiply High Word Unsigned\n"));
#line 13987 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Multiply_High_Word_Unsigned, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2730 "../../sim/ppc/powerpc.igen"
  {
    uint64_t a = (uint32_t)(*rA);
    uint64_t b = (uint32_t)(*rB);
    uint64_t prod = a * b;
    signed_word t = EXTRACTED64(prod, 0, 31);
    *rT = t;
    CR0_COMPARE(t, 0, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 14006 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.11,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 14020 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_From_Condition_Register(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_From_Condition_Register
#undef MY_PREFIX
#define MY_PREFIX Move_From_Condition_Register

  /* extraction: 0.31,6.RT,11./,16./,21.19,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#line 14040 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3452 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move From Condition Register\n"));
#line 14046 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_From_Condition_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3452 "../../sim/ppc/powerpc.igen"
  {
    *rT = (uint32_t)CR;
    PPC_INSN_MFCR(RT_BITMASK);
  }
#line 14060 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11./,16./,21.19,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#line 14066 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Word_And_Reserve_Indexed(cpu *processor,
                                       idecode_cache *cache_entry,
                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Word_And_Reserve_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Word_And_Reserve_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.20,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 14093 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2422 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Word And Reserve Indexed\n"));
#line 14099 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Word_And_Reserve_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2422 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    RESERVE = 1;
    RESERVE_ADDR = real_addr(EA, 1/*is-read?*/);
    RESERVE_DATA = MEM(unsigned, EA, 4);
    *rT = RESERVE_DATA;
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 14121 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.20,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 14134 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Word_and_Zero_Indexed(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Word_and_Zero_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Word_and_Zero_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.23,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 14161 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 1898 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Word and Zero Indexed\n"));
#line 14167 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Word_and_Zero_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1898 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    *rT = MEM(unsigned, EA, 4);
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 14186 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.23,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 14199 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Shift_Left_Word_Rc0(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Left_Word
#undef MY_PREFIX
#define MY_PREFIX Shift_Left_Word_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.24,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 14227 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3250 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Shift Left Word\n"));
#line 14233 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Shift_Left_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3250 "../../sim/ppc/powerpc.igen"
  {
    int n = MASKED(*rB, 58, 63);
    uint32_t source = *rS;
    signed_word shifted;
    if (n < 32)
      shifted = (source << n);
    else
      shifted = 0;
    *rA = shifted;
    CR0_COMPARE(shifted, 0, Rc);
    ITRACE(trace_alu,
           ("n=%d, source=0x%lx, shifted=0x%lx\n",
            n, (unsigned long)source, (unsigned long)shifted));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 14258 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.24,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 14272 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Shift_Left_Word_Rc1(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Left_Word
#undef MY_PREFIX
#define MY_PREFIX Shift_Left_Word_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.24,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 14300 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3250 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Shift Left Word\n"));
#line 14306 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Shift_Left_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3250 "../../sim/ppc/powerpc.igen"
  {
    int n = MASKED(*rB, 58, 63);
    uint32_t source = *rS;
    signed_word shifted;
    if (n < 32)
      shifted = (source << n);
    else
      shifted = 0;
    *rA = shifted;
    CR0_COMPARE(shifted, 0, Rc);
    ITRACE(trace_alu,
           ("n=%d, source=0x%lx, shifted=0x%lx\n",
            n, (unsigned long)source, (unsigned long)shifted));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 14331 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.24,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 14345 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Count_Leading_Zeros_Word_Rc0(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Count_Leading_Zeros_Word
#undef MY_PREFIX
#define MY_PREFIX Count_Leading_Zeros_Word_Rc0

  /* extraction: 0.31,6.RS,11.RA,16./,21.26,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define Rc 0 /* default in icache - constant field */
#line 14370 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3129 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Count Leading Zeros Word\n"));
#line 14376 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Count_Leading_Zeros_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3129 "../../sim/ppc/powerpc.igen"
  {
    int count = 0;
    uint32_t mask = BIT32(0);
    uint32_t source = *rS;
    while (!(source & mask) && mask != 0) {
      mask >>= 1;
      count++;
    }
    *rA = count;
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    CR0_COMPARE(count, 0, Rc); /* FIXME - is this correct */
  }
#line 14398 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16./,21.26,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef Rc
#line 14409 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Count_Leading_Zeros_Word_Rc1(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Count_Leading_Zeros_Word
#undef MY_PREFIX
#define MY_PREFIX Count_Leading_Zeros_Word_Rc1

  /* extraction: 0.31,6.RS,11.RA,16./,21.26,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define Rc 1 /* default in icache - constant field */
#line 14434 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3129 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Count Leading Zeros Word\n"));
#line 14440 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Count_Leading_Zeros_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3129 "../../sim/ppc/powerpc.igen"
  {
    int count = 0;
    uint32_t mask = BIT32(0);
    uint32_t source = *rS;
    while (!(source & mask) && mask != 0) {
      mask >>= 1;
      count++;
    }
    *rA = count;
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    CR0_COMPARE(count, 0, Rc); /* FIXME - is this correct */
  }
#line 14462 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16./,21.26,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef Rc
#line 14473 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_AND_Rc0(cpu *processor,
                 idecode_cache *cache_entry,
                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_AND
#undef MY_PREFIX
#define MY_PREFIX AND_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.28,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 14501 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3010 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics AND\n"));
#line 14507 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_AND, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3010 "../../sim/ppc/powerpc.igen"
  {
    *rA = *rS & *rB;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 14523 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.28,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 14537 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_AND_Rc1(cpu *processor,
                 idecode_cache *cache_entry,
                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_AND
#undef MY_PREFIX
#define MY_PREFIX AND_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.28,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 14565 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3010 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics AND\n"));
#line 14571 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_AND, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3010 "../../sim/ppc/powerpc.igen"
  {
    *rA = *rS & *rB;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 14587 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.28,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 14601 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Compare_Logical(cpu *processor,
                         idecode_cache *cache_entry,
                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Compare_Logical
#undef MY_PREFIX
#define MY_PREFIX Compare_Logical

  /* extraction: 0.31,6.BF,9./,10.L,11.RA,16.RB,21.32,31./ #define get-values-from-icache */
#define BF cache_entry->crack.X.BF /* in icache - extraction */
#define BF_BITMASK cache_entry->crack.X.BF_BITMASK /* in icache - extraction */
#define L cache_entry->crack.X.L /* default in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 14628 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2852 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Compare Logical\n"));
#line 14634 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Compare_Logical, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2852 "../../sim/ppc/powerpc.igen"
  {
    if (!is_64bit_mode && L)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    else {
      unsigned_word a;
      unsigned_word b;
      if (L == 0) {
        a = MASKED(*rA, 32, 63);
        b = MASKED(*rB, 32, 63);
      }
      else {
        a = *rA;
        b = *rB;
      }
      CR_COMPARE(BF, a, b);
    }
    PPC_INSN_INT_CR(0, RA_BITMASK | RB_BITMASK, BF_BITMASK);
  }
#line 14663 "semantics.c"
  return nia;
  /* extraction: 0.31,6.BF,9./,10.L,11.RA,16.RB,21.32,31./ #undef get-values-from-icache */
#undef BF
#undef BF_BITMASK
#undef L
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 14676 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_OE0_Rc0(cpu *processor,
                               idecode_cache *cache_entry,
                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 14705 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2542 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From\n"));
#line 14711 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2542 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD(1);
    ALU_END(*rT, 0/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 14729 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 14744 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_OE0_Rc1(cpu *processor,
                               idecode_cache *cache_entry,
                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 14773 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2542 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From\n"));
#line 14779 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2542 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD(1);
    ALU_END(*rT, 0/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 14797 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 14812 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Data_Cache_Block_Store(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Data_Cache_Block_Store
#undef MY_PREFIX
#define MY_PREFIX Data_Cache_Block_Store

  /* extraction: 0.31,6./,11.RA,16.RB,21.54,31./ #define get-values-from-icache */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 14836 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4811 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Data Cache Block Store\n"));
#line 14842 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Data_Cache_Block_Store, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4811 "../../sim/ppc/powerpc.igen"
  {
    TRACE(trace_tbd,("Data Cache Block Store\n"));
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK, 0/*Rc*/);
  }
#line 14856 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,11.RA,16.RB,21.54,31./ #undef get-values-from-icache */
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 14866 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Word_and_Zero_with_Update_Indexed(cpu *processor,
                                                idecode_cache *cache_entry,
                                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Word_and_Zero_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Word_and_Zero_with_Update_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.55,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 14893 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 1925 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Word and Zero with Update Indexed\n"));
#line 14899 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Word_and_Zero_with_Update_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1925 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0 || RA == RT)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + *rB;
    *rT = MEM(unsigned, EA, 4);
    *rA = EA;
    PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK | RB_BITMASK, 0);
  }
#line 14919 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.55,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 14932 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_AND_with_Complement_Rc0(cpu *processor,
                                 idecode_cache *cache_entry,
                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_AND_with_Complement
#undef MY_PREFIX
#define MY_PREFIX AND_with_Complement_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.60,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 14960 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3070 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics AND with Complement\n"));
#line 14966 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_AND_with_Complement, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3070 "../../sim/ppc/powerpc.igen"
  {
    *rA = *rS & ~*rB;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 14982 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.60,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 14996 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_AND_with_Complement_Rc1(cpu *processor,
                                 idecode_cache *cache_entry,
                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_AND_with_Complement
#undef MY_PREFIX
#define MY_PREFIX AND_with_Complement_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.60,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 15024 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3070 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics AND with Complement\n"));
#line 15030 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_AND_with_Complement, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3070 "../../sim/ppc/powerpc.igen"
  {
    *rA = *rS & ~*rB;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 15046 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.60,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 15060 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Multiply_High_Word_Rc0(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_High_Word
#undef MY_PREFIX
#define MY_PREFIX Multiply_High_Word_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.75,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 15088 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2715 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Multiply High Word\n"));
#line 15094 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Multiply_High_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2715 "../../sim/ppc/powerpc.igen"
  {
    int64_t a = (int32_t)(*rA);
    int64_t b = (int32_t)(*rB);
    int64_t prod = a * b;
    signed_word t = EXTRACTED64(prod, 0, 31);
    *rT = t;
    CR0_COMPARE(t, 0, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 15113 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.75,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 15127 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Multiply_High_Word_Rc1(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_High_Word
#undef MY_PREFIX
#define MY_PREFIX Multiply_High_Word_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.75,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 15155 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2715 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Multiply High Word\n"));
#line 15161 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Multiply_High_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2715 "../../sim/ppc/powerpc.igen"
  {
    int64_t a = (int32_t)(*rA);
    int64_t b = (int32_t)(*rB);
    int64_t prod = a * b;
    signed_word t = EXTRACTED64(prod, 0, 31);
    *rT = t;
    CR0_COMPARE(t, 0, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 15180 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.75,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 15194 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_From_Machine_State_Register(cpu *processor,
                                          idecode_cache *cache_entry,
                                          unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_From_Machine_State_Register
#undef MY_PREFIX
#define MY_PREFIX Move_From_Machine_State_Register

  /* extraction: 0.31,6.RT,11./,16./,21.83,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#line 15214 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4898 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move From Machine State Register\n"));
#line 15220 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_From_Machine_State_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4898 "../../sim/ppc/powerpc.igen"
  {
    if (IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else {
      *rT = MSR;
      check_masked_interrupts(processor);
    }
  }
#line 15239 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11./,16./,21.83,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#line 15245 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Data_Cache_Block_Flush(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Data_Cache_Block_Flush
#undef MY_PREFIX
#define MY_PREFIX Data_Cache_Block_Flush

  /* extraction: 0.31,6./,11.RA,16.RB,21.86,31./ #define get-values-from-icache */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 15269 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4819 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Data Cache Block Flush\n"));
#line 15275 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Data_Cache_Block_Flush, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4819 "../../sim/ppc/powerpc.igen"
  {
    TRACE(trace_tbd,("Data Cache Block Flush\n"));
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK, 0/*Rc*/);
  }
#line 15289 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,11.RA,16.RB,21.86,31./ #undef get-values-from-icache */
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 15299 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Byte_and_Zero_Indexed(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Byte_and_Zero_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Byte_and_Zero_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.87,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 15326 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 1736 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Byte and Zero Indexed\n"));
#line 15332 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Byte_and_Zero_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1736 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    *rT = MEM(unsigned, EA, 1);
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 15351 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.87,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 15364 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Negate_OE0_Rc0(cpu *processor,
                        idecode_cache *cache_entry,
                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Negate
#undef MY_PREFIX
#define MY_PREFIX Negate_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 15390 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2676 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Negate\n"));
#line 15396 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Negate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2676 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(1);
    ALU_END(*rT,0/*CA*/,OE,Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 15413 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 15425 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Negate_OE0_Rc1(cpu *processor,
                        idecode_cache *cache_entry,
                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Negate
#undef MY_PREFIX
#define MY_PREFIX Negate_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 15451 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2676 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Negate\n"));
#line 15457 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Negate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2676 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(1);
    ALU_END(*rT,0/*CA*/,OE,Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 15474 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 15486 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Byte_and_Zero_with_Update_Indexed(cpu *processor,
                                                idecode_cache *cache_entry,
                                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Byte_and_Zero_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Byte_and_Zero_with_Update_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.119,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 15513 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 1763 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Byte and Zero with Update Indexed\n"));
#line 15519 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Byte_and_Zero_with_Update_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1763 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0 || RA == RT)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + *rB;
    *rT = MEM(unsigned, EA, 1);
    *rA = EA;
    PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK | RB_BITMASK, 0);
  }
#line 15539 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.119,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 15552 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_NOR_Rc0(cpu *processor,
                 idecode_cache *cache_entry,
                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_NOR
#undef MY_PREFIX
#define MY_PREFIX NOR_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.124,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 15580 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3050 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics NOR\n"));
#line 15586 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_NOR, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3050 "../../sim/ppc/powerpc.igen"
  {
    *rA = ~(*rS | *rB);
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 15602 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.124,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 15616 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_NOR_Rc1(cpu *processor,
                 idecode_cache *cache_entry,
                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_NOR
#undef MY_PREFIX
#define MY_PREFIX NOR_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.124,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 15644 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3050 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics NOR\n"));
#line 15650 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_NOR, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3050 "../../sim/ppc/powerpc.igen"
  {
    *rA = ~(*rS | *rB);
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 15666 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.124,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 15680 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Extended_OE0_Rc0(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Extended_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 15709 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2620 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Extended\n"));
#line 15715 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2620 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 15733 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 15748 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Extended_OE0_Rc1(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Extended_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 15777 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2620 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Extended\n"));
#line 15783 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2620 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 15801 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 15816 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Extended_OE0_Rc0(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_Extended_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 15845 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2609 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Extended\n"));
#line 15851 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2609 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 15868 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 15883 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Extended_OE0_Rc1(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_Extended_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 15912 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2609 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Extended\n"));
#line 15918 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2609 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 15935 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 15950 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_to_Condition_Register_Fields(cpu *processor,
                                           idecode_cache *cache_entry,
                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_to_Condition_Register_Fields
#undef MY_PREFIX
#define MY_PREFIX Move_to_Condition_Register_Fields

  /* extraction: 0.31,6.RS,11./,12.FXM,20./,21.144,31./ #define get-values-from-icache */
#define RS cache_entry->crack.XFX.RS /* in icache - extraction */
#define rS cache_entry->crack.XFX.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.XFX.RS_BITMASK /* in icache - extraction */
#define FXM cache_entry->crack.XFX.FXM /* default in icache - extraction */
#line 15971 "semantics.c"

#define insn cache_entry->crack.XFX.insn
  unsigned_word nia;
#line 3429 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move to Condition Register Fields\n"));
#line 15977 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_to_Condition_Register_Fields, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3429 "../../sim/ppc/powerpc.igen"
  {
    if (FXM == 0xff) {
      CR = *rS;
    }
    else {
      unsigned_word mask = 0;
      unsigned_word f;
      for (f = 0; f < 8; f++) {
        if (FXM & (0x80 >> f))
          mask |= (0xf << 4*(7-f));
      }
      CR = (MASKED(*rS, 32, 63) & mask) | (CR & ~mask);
    }
    PPC_INSN_MTCR(RS_BITMASK, FXM);
  }
#line 16002 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11./,12.FXM,20./,21.144,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef FXM
#line 16009 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_To_Machine_State_Register(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_To_Machine_State_Register
#undef MY_PREFIX
#define MY_PREFIX Move_To_Machine_State_Register

  /* extraction: 0.31,6.RS,11./,16./,21.146,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#line 16029 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4885 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move To Machine State Register\n"));
#line 16035 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_To_Machine_State_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4885 "../../sim/ppc/powerpc.igen"
  {
    if (IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else {
      MSR = *rS;
      check_masked_interrupts(processor);
    }
  }
#line 16054 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11./,16./,21.146,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#line 16060 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Word_Conditional_Indexed(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Word_Conditional_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Word_Conditional_Indexed

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.150,31.1 #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 16087 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2450 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Word Conditional Indexed\n"));
#line 16093 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Word_Conditional_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2450 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    if (RESERVE) {
      if (RESERVE_ADDR == real_addr(EA, 0/*is-read?*/)
          && /*HACK*/ RESERVE_DATA == MEM(unsigned, EA, 4)) {
        STORE(EA, 4, *rS);
        CR_SET_XER_SO(0, cr_i_zero);
      }
      else {
        /* ment to randomly to store, we never do! */	
        CR_SET_XER_SO(0, 0);
      }
      RESERVE = 0;
    }
    else {
      CR_SET_XER_SO(0, 0);
    }
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK | RS_BITMASK, 1/*Rc*/);
  }
#line 16126 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.150,31.1 #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 16139 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Word_Indexed(cpu *processor,
                            idecode_cache *cache_entry,
                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Word_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Word_Indexed

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.151,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 16166 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2125 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Word Indexed\n"));
#line 16172 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Word_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2125 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    STORE(EA, 4, *rS);
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK | RS_BITMASK, 0);
  }
#line 16191 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.151,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 16204 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Word_with_Update_Indexed(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Word_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Word_with_Update_Indexed

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.183,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 16231 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2152 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Word with Update Indexed\n"));
#line 16237 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Word_with_Update_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2152 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + *rB;
    STORE(EA, 4, *rS);
    *rA = EA;
    PPC_INSN_INT(RA_BITMASK, RA_BITMASK | RB_BITMASK | RS_BITMASK, 0);
  }
#line 16257 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.183,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 16270 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_from_Zero_Extended_OE0_Rc0(cpu *processor,
                                             idecode_cache *cache_entry,
                                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_from_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_from_Zero_Extended_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 16296 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2665 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract from Zero Extended\n"));
#line 16302 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_from_Zero_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2665 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 16319 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 16331 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_from_Zero_Extended_OE0_Rc1(cpu *processor,
                                             idecode_cache *cache_entry,
                                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_from_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_from_Zero_Extended_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 16357 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2665 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract from Zero Extended\n"));
#line 16363 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_from_Zero_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2665 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 16380 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 16392 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_to_Zero_Extended_OE0_Rc0(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Zero_Extended_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 16418 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2655 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add to Zero Extended\n"));
#line 16424 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_to_Zero_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2655 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 16440 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 16452 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_to_Zero_Extended_OE0_Rc1(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Zero_Extended_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 16478 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2655 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add to Zero Extended\n"));
#line 16484 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_to_Zero_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2655 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 16500 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 16512 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_To_Segment_Register(cpu *processor,
                                  idecode_cache *cache_entry,
                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_To_Segment_Register
#undef MY_PREFIX
#define MY_PREFIX Move_To_Segment_Register

  /* extraction: 0.31,6.RS,11./,12.SR,16./,21.210,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define SR cache_entry->crack.X.SR /* default in icache - extraction */
#line 16533 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4931 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move To Segment Register\n"));
#line 16539 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_To_Segment_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4931 "../../sim/ppc/powerpc.igen"
  {
    if (IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else
      SEGREG(SR) = *rS;
  }
#line 16556 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11./,12.SR,16./,21.210,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef SR
#line 16563 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Byte_Indexed(cpu *processor,
                            idecode_cache *cache_entry,
                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Byte_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Byte_Indexed

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.215,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 16590 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2017 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Byte Indexed\n"));
#line 16596 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Byte_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2017 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    STORE(EA, 1, *rS);
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK | RS_BITMASK, 0);
  }
#line 16615 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.215,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 16628 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Minus_One_Extended_OE0_Rc0(cpu *processor,
                                                  idecode_cache *cache_entry,
                                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Minus_One_Extended_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 16654 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2643 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Minus One Extended\n"));
#line 16660 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Minus_One_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2643 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD_CA;
    ALU_ADD(-1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 16678 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 16690 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Minus_One_Extended_OE0_Rc1(cpu *processor,
                                                  idecode_cache *cache_entry,
                                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Minus_One_Extended_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 16716 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2643 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Minus One Extended\n"));
#line 16722 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Minus_One_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2643 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD_CA;
    ALU_ADD(-1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 16740 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 16752 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_to_Minus_One_Extended_OE0_Rc0(cpu *processor,
                                           idecode_cache *cache_entry,
                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Minus_One_Extended_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 16778 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2632 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add to Minus One Extended\n"));
#line 16784 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_to_Minus_One_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2632 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD_CA;
    ALU_ADD(-1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 16801 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 16813 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_to_Minus_One_Extended_OE0_Rc1(cpu *processor,
                                           idecode_cache *cache_entry,
                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Minus_One_Extended_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 16839 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2632 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add to Minus One Extended\n"));
#line 16845 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_to_Minus_One_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2632 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD_CA;
    ALU_ADD(-1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 16862 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 16874 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Multiply_Low_Word_OE0_Rc0(cpu *processor,
                                   idecode_cache *cache_entry,
                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_Low_Word
#undef MY_PREFIX
#define MY_PREFIX Multiply_Low_Word_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 16903 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2698 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Multiply Low Word\n"));
#line 16909 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Multiply_Low_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2698 "../../sim/ppc/powerpc.igen"
  {
    int64_t a = (int32_t)(*rA);
    int64_t b = (int32_t)(*rB);
    int64_t prod = a * b;
    signed_word t = prod;
    *rT = *rA * *rB;
    if (t != prod && OE)
      XER |= (xer_overflow | xer_summary_overflow);
    CR0_COMPARE(t, 0, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 16930 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 16945 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Multiply_Low_Word_OE0_Rc1(cpu *processor,
                                   idecode_cache *cache_entry,
                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_Low_Word
#undef MY_PREFIX
#define MY_PREFIX Multiply_Low_Word_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 16974 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2698 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Multiply Low Word\n"));
#line 16980 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Multiply_Low_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2698 "../../sim/ppc/powerpc.igen"
  {
    int64_t a = (int32_t)(*rA);
    int64_t b = (int32_t)(*rB);
    int64_t prod = a * b;
    signed_word t = prod;
    *rT = *rA * *rB;
    if (t != prod && OE)
      XER |= (xer_overflow | xer_summary_overflow);
    CR0_COMPARE(t, 0, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 17001 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 17016 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_To_Segment_Register_Indirect(cpu *processor,
                                           idecode_cache *cache_entry,
                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_To_Segment_Register_Indirect
#undef MY_PREFIX
#define MY_PREFIX Move_To_Segment_Register_Indirect

  /* extraction: 0.31,6.RS,11./,16.RB,21.242,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 17039 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4942 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move To Segment Register Indirect\n"));
#line 17045 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_To_Segment_Register_Indirect, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4942 "../../sim/ppc/powerpc.igen"
  {
    if (IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else
      SEGREG(EXTRACTED32(*rB, 0, 3)) = *rS;
  }
#line 17062 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11./,16.RB,21.242,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RB
#undef rB
#undef RB_BITMASK
#line 17071 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Data_Cache_Block_Touch_for_Store(cpu *processor,
                                          idecode_cache *cache_entry,
                                          unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Data_Cache_Block_Touch_for_Store
#undef MY_PREFIX
#define MY_PREFIX Data_Cache_Block_Touch_for_Store

  /* extraction: 0.31,6./,11.RA,16.RB,21.246,31./ #define get-values-from-icache */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 17095 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4795 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Data Cache Block Touch for Store\n"));
#line 17101 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Data_Cache_Block_Touch_for_Store, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4795 "../../sim/ppc/powerpc.igen"
  {
    TRACE(trace_tbd,("Data Cache Block Touch for Store\n"));
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK, 0/*Rc*/);
  }
#line 17115 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,11.RA,16.RB,21.246,31./ #undef get-values-from-icache */
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 17125 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Byte_with_Update_Indexed(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Byte_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Byte_with_Update_Indexed

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.247,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 17152 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2044 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Byte with Update Indexed\n"));
#line 17158 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Byte_with_Update_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2044 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + *rB;
    STORE(EA, 1, *rS);
    *rA = EA;
    PPC_INSN_INT(RA_BITMASK, RA_BITMASK | RB_BITMASK | RS_BITMASK, 0);
  }
#line 17178 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.247,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 17191 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_OE0_Rc0(cpu *processor,
                     idecode_cache *cache_entry,
                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add
#undef MY_PREFIX
#define MY_PREFIX Add_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 17220 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2532 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add\n"));
#line 17226 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2532 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_END(*rT, 0/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 17242 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 17257 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_OE0_Rc1(cpu *processor,
                     idecode_cache *cache_entry,
                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add
#undef MY_PREFIX
#define MY_PREFIX Add_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 17286 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2532 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add\n"));
#line 17292 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2532 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_END(*rT, 0/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 17308 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 17323 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Data_Cache_Block_Touch(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Data_Cache_Block_Touch
#undef MY_PREFIX
#define MY_PREFIX Data_Cache_Block_Touch

  /* extraction: 0.31,6./,11.RA,16.RB,21.278,31./ #define get-values-from-icache */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 17347 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4787 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Data Cache Block Touch\n"));
#line 17353 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Data_Cache_Block_Touch, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4787 "../../sim/ppc/powerpc.igen"
  {
    TRACE(trace_tbd,("Data Cache Block Touch\n"));
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK, 0/*Rc*/);
  }
#line 17367 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,11.RA,16.RB,21.278,31./ #undef get-values-from-icache */
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 17377 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Halfword_and_Zero_Indexed(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_and_Zero_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_and_Zero_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.279,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 17404 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 1790 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Halfword and Zero Indexed\n"));
#line 17410 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Halfword_and_Zero_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1790 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    *rT = MEM(unsigned, EA, 2);
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 17429 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.279,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 17442 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Equivalent_Rc0(cpu *processor,
                        idecode_cache *cache_entry,
                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Equivalent
#undef MY_PREFIX
#define MY_PREFIX Equivalent_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.284,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 17470 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3060 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Equivalent\n"));
#line 17476 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Equivalent, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3060 "../../sim/ppc/powerpc.igen"
  {
    *rA = ~(*rS ^ *rB); /* A === B */
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 17492 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.284,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 17506 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Equivalent_Rc1(cpu *processor,
                        idecode_cache *cache_entry,
                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Equivalent
#undef MY_PREFIX
#define MY_PREFIX Equivalent_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.284,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 17534 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3060 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Equivalent\n"));
#line 17540 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Equivalent, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3060 "../../sim/ppc/powerpc.igen"
  {
    *rA = ~(*rS ^ *rB); /* A === B */
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 17556 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.284,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 17570 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_TLB_Invalidate_Entry(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_TLB_Invalidate_Entry
#undef MY_PREFIX
#define MY_PREFIX TLB_Invalidate_Entry

  /* extraction: 0.31,6./,11./,16.RB,21.306,31./ #define get-values-from-icache */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 17590 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4980 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics TLB Invalidate Entry\n"));
#line 17596 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_TLB_Invalidate_Entry, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4980 "../../sim/ppc/powerpc.igen"
  {
    if (IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else {
      int nr = 0;
      cpu *proc;
      while (1) {
        proc = psim_cpu(cpu_system(processor), nr);
        if (proc == NULL) break;
        cpu_page_tlb_invalidate_entry(proc, *rB);
        nr++;
      }
    }
  }
#line 17621 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,11./,16.RB,21.306,31./ #undef get-values-from-icache */
#undef RB
#undef rB
#undef RB_BITMASK
#line 17627 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Halfword_and_Zero_with_Update_Indexed(cpu *processor,
                                                    idecode_cache *cache_entry,
                                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_and_Zero_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_and_Zero_with_Update_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.311,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 17654 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 1817 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Halfword and Zero with Update Indexed\n"));
#line 17660 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Halfword_and_Zero_with_Update_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1817 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0 || RA == RT)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + *rB;
    *rT = MEM(unsigned, EA, 2);
    *rA = EA;
    PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK | RB_BITMASK, 0);
  }
#line 17680 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.311,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 17693 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_XOR_Rc0(cpu *processor,
                 idecode_cache *cache_entry,
                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_XOR
#undef MY_PREFIX
#define MY_PREFIX XOR_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.316,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 17721 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3030 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics XOR\n"));
#line 17727 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_XOR, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3030 "../../sim/ppc/powerpc.igen"
  {
    *rA = *rS ^ *rB;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 17743 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.316,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 17757 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_XOR_Rc1(cpu *processor,
                 idecode_cache *cache_entry,
                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_XOR
#undef MY_PREFIX
#define MY_PREFIX XOR_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.316,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 17785 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3030 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics XOR\n"));
#line 17791 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_XOR, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3030 "../../sim/ppc/powerpc.igen"
  {
    *rA = *rS ^ *rB;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 17807 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.316,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 17821 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_from_Special_Purpose_Register_SPR256(cpu *processor,
                                                   idecode_cache *cache_entry,
                                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_from_Special_Purpose_Register
#undef MY_PREFIX
#define MY_PREFIX Move_from_Special_Purpose_Register_SPR256

  /* extraction: 0.31,6.RT,11.SPR,21.339,31./ #define get-values-from-icache */
#define RT cache_entry->crack.XFX.RT /* in icache - extraction */
#define rT cache_entry->crack.XFX.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XFX.RT_BITMASK /* in icache - extraction */
#define SPR 256 /* default in icache - constant field */
#line 17842 "semantics.c"

#define insn cache_entry->crack.XFX.insn
  unsigned_word nia;
#line 3388 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move from Special Purpose Register\n"));
#line 17848 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_from_Special_Purpose_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3388 "../../sim/ppc/powerpc.igen"
  {
    int n = (SPR_5_9_ << 5) | SPR_0_4_;
    if (SPR_0_ && IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else if (!spr_is_valid(n))
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    else {
      /* HACK - time base registers need to be calculated */
      if (WITH_TIME_BASE) {
        switch (n) {
        case spr_dec:
          *rT = cpu_get_decrementer(processor);
          break;
    	case spr_tbrl:
      	  if (is_64bit_implementation) *rT = TB;
      	  else                         *rT = EXTRACTED64(TB, 32, 63);
    	break;
    	case spr_tbru:
      	  if (is_64bit_implementation) *rT = EXTRACTED64(TB, 0, 31);
    	  else                         *rT = EXTRACTED64(TB, 0, 31);
    	break;
        case spr_tbu:
        case spr_tbl:
          /* NOTE - these SPR's are not readable. Use mftb[ul] */
        default:
          *rT = SPREG(n);
          break;
        }
      }
      else {
        *rT = SPREG(n);
      }
    }
    PPC_INSN_FROM_SPR(RT_BITMASK, n);
  }
#line 17895 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.SPR,21.339,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef SPR
#line 17902 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_from_Special_Purpose_Register_SPR(cpu *processor,
                                                idecode_cache *cache_entry,
                                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_from_Special_Purpose_Register
#undef MY_PREFIX
#define MY_PREFIX Move_from_Special_Purpose_Register_SPR

  /* extraction: 0.31,6.RT,11.SPR,21.339,31./ #define get-values-from-icache */
#define RT cache_entry->crack.XFX.RT /* in icache - extraction */
#define rT cache_entry->crack.XFX.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XFX.RT_BITMASK /* in icache - extraction */
#define SPR cache_entry->crack.XFX.SPR /* default in icache - extraction */
#line 17923 "semantics.c"

#define insn cache_entry->crack.XFX.insn
  unsigned_word nia;
#line 3388 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move from Special Purpose Register\n"));
#line 17929 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_from_Special_Purpose_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3388 "../../sim/ppc/powerpc.igen"
  {
    int n = (SPR_5_9_ << 5) | SPR_0_4_;
    if (SPR_0_ && IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else if (!spr_is_valid(n))
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    else {
      /* HACK - time base registers need to be calculated */
      if (WITH_TIME_BASE) {
        switch (n) {
        case spr_dec:
          *rT = cpu_get_decrementer(processor);
          break;
    	case spr_tbrl:
      	  if (is_64bit_implementation) *rT = TB;
      	  else                         *rT = EXTRACTED64(TB, 32, 63);
    	break;
    	case spr_tbru:
      	  if (is_64bit_implementation) *rT = EXTRACTED64(TB, 0, 31);
    	  else                         *rT = EXTRACTED64(TB, 0, 31);
    	break;
        case spr_tbu:
        case spr_tbl:
          /* NOTE - these SPR's are not readable. Use mftb[ul] */
        default:
          *rT = SPREG(n);
          break;
        }
      }
      else {
        *rT = SPREG(n);
      }
    }
    PPC_INSN_FROM_SPR(RT_BITMASK, n);
  }
#line 17976 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.SPR,21.339,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef SPR
#line 17983 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Halfword_Algebraic_Indexed(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_Algebraic_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_Algebraic_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.343,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 18010 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 1844 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Halfword Algebraic Indexed\n"));
#line 18016 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Halfword_Algebraic_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1844 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    *rT = MEM(signed, EA, 2);
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 18035 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.343,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 18048 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_TLB_Invalidate_All(cpu *processor,
                            idecode_cache *cache_entry,
                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_TLB_Invalidate_All
#undef MY_PREFIX
#define MY_PREFIX TLB_Invalidate_All

  /* extraction: 0.31,6./,11./,16./,21.370,31./ #define get-values-from-icache */
#line 18065 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4995 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics TLB Invalidate All\n"));
#line 18071 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_TLB_Invalidate_All, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4995 "../../sim/ppc/powerpc.igen"
  {
    if (IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else {
      int nr = 0;
      cpu *proc;
      while (1) {
        proc = psim_cpu(cpu_system(processor), nr);
        if (proc == NULL) break;
        cpu_page_tlb_invalidate_all(proc);
        nr++;
      }
    }
  }
#line 18096 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,11./,16./,21.370,31./ #undef get-values-from-icache */
#line 18099 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_From_Time_Base(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_From_Time_Base
#undef MY_PREFIX
#define MY_PREFIX Move_From_Time_Base

  /* extraction: 0.31,6.RT,11.tbr,21.371,31./ #define get-values-from-icache */
#define RT cache_entry->crack.XFX.RT /* in icache - extraction */
#define rT cache_entry->crack.XFX.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XFX.RT_BITMASK /* in icache - extraction */
#define tbr cache_entry->crack.XFX.tbr /* default in icache - extraction */
#line 18120 "semantics.c"

#define insn cache_entry->crack.XFX.insn
  unsigned_word nia;
#line 4838 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move From Time Base\n"));
#line 18126 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_From_Time_Base, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4838 "../../sim/ppc/powerpc.igen"
  {
    int n = (tbr_5_9_ << 5) | tbr_0_4_;
    if (n == 268) {
      if (is_64bit_implementation) *rT = TB;
      else                         *rT = EXTRACTED64(TB, 32, 63);
    }
    else if (n == 269) {
      if (is_64bit_implementation) *rT = EXTRACTED64(TB, 0, 31);
      else                         *rT = EXTRACTED64(TB, 0, 31);
    }
    else
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
  }
#line 18150 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.tbr,21.371,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef tbr
#line 18157 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Halfword_Algebraic_with_Update_Indexed(cpu *processor,
                                                     idecode_cache *cache_entry,
                                                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_Algebraic_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_Algebraic_with_Update_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.375,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 18184 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 1871 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Halfword Algebraic with Update Indexed\n"));
#line 18190 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Halfword_Algebraic_with_Update_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1871 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0 || RA == RT)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + *rB;
    *rT = MEM(signed, EA, 2);
    *rA = EA;
    PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK | RB_BITMASK, 0);
  }
#line 18210 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.375,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 18223 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Half_Word_Indexed(cpu *processor,
                                 idecode_cache *cache_entry,
                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Half_Word_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Half_Word_Indexed

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.407,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 18250 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2071 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Half Word Indexed\n"));
#line 18256 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Half_Word_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2071 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    STORE(EA, 2, *rS);
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK | RS_BITMASK, 0);
  }
#line 18275 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.407,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 18288 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_OR_with_Complement_Rc0(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_OR_with_Complement
#undef MY_PREFIX
#define MY_PREFIX OR_with_Complement_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.412,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 18316 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3080 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics OR with Complement\n"));
#line 18322 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_OR_with_Complement, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3080 "../../sim/ppc/powerpc.igen"
  {
    *rA = *rS | ~*rB;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 18338 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.412,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 18352 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_OR_with_Complement_Rc1(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_OR_with_Complement
#undef MY_PREFIX
#define MY_PREFIX OR_with_Complement_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.412,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 18380 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3080 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics OR with Complement\n"));
#line 18386 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_OR_with_Complement, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3080 "../../sim/ppc/powerpc.igen"
  {
    *rA = *rS | ~*rB;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 18402 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.412,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 18416 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Half_Word_with_Update_Indexed(cpu *processor,
                                             idecode_cache *cache_entry,
                                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Half_Word_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Half_Word_with_Update_Indexed

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.439,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 18443 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2098 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Half Word with Update Indexed\n"));
#line 18449 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Half_Word_with_Update_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2098 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + *rB;
    STORE(EA, 2, *rS);
    *rA = EA;
    PPC_INSN_INT(RA_BITMASK, RA_BITMASK | RB_BITMASK | RS_BITMASK, 0);
  }
#line 18469 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.439,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 18482 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_OR_Rc0(cpu *processor,
                idecode_cache *cache_entry,
                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_OR
#undef MY_PREFIX
#define MY_PREFIX OR_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.444,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 18510 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3020 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics OR\n"));
#line 18516 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_OR, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3020 "../../sim/ppc/powerpc.igen"
  {
    *rA = *rS | *rB;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 18532 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.444,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 18546 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_OR_Rc1(cpu *processor,
                idecode_cache *cache_entry,
                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_OR
#undef MY_PREFIX
#define MY_PREFIX OR_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.444,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 18574 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3020 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics OR\n"));
#line 18580 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_OR, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3020 "../../sim/ppc/powerpc.igen"
  {
    *rA = *rS | *rB;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 18596 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.444,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 18610 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Divide_Word_Unsigned_OE0_Rc0(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word_Unsigned
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_Unsigned_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 18639 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2767 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Divide Word Unsigned\n"));
#line 18645 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Divide_Word_Unsigned, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2767 "../../sim/ppc/powerpc.igen"
  {
    uint64_t dividend = (uint32_t)(*rA);
    uint64_t divisor = (uint32_t)(*rB);
    if (divisor == 0) {
      if (OE)
        XER |= (xer_overflow | xer_summary_overflow);
      CR0_COMPARE(0, 0, Rc);
    }
    else {
      uint64_t quotent = dividend / divisor;
      *rT = quotent;
      CR0_COMPARE((signed_word)quotent, 0, Rc);
    }
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 18670 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 18685 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Divide_Word_Unsigned_OE0_Rc1(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word_Unsigned
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_Unsigned_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 18714 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2767 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Divide Word Unsigned\n"));
#line 18720 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Divide_Word_Unsigned, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2767 "../../sim/ppc/powerpc.igen"
  {
    uint64_t dividend = (uint32_t)(*rA);
    uint64_t divisor = (uint32_t)(*rB);
    if (divisor == 0) {
      if (OE)
        XER |= (xer_overflow | xer_summary_overflow);
      CR0_COMPARE(0, 0, Rc);
    }
    else {
      uint64_t quotent = dividend / divisor;
      *rT = quotent;
      CR0_COMPARE((signed_word)quotent, 0, Rc);
    }
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 18745 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 18760 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_to_Special_Purpose_Register_SPR256(cpu *processor,
                                                 idecode_cache *cache_entry,
                                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_to_Special_Purpose_Register
#undef MY_PREFIX
#define MY_PREFIX Move_to_Special_Purpose_Register_SPR256

  /* extraction: 0.31,6.RS,11.SPR,21.467,31./ #define get-values-from-icache */
#define RS cache_entry->crack.XFX.RS /* in icache - extraction */
#define rS cache_entry->crack.XFX.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.XFX.RS_BITMASK /* in icache - extraction */
#define SPR 256 /* default in icache - constant field */
#line 18781 "semantics.c"

#define insn cache_entry->crack.XFX.insn
  unsigned_word nia;
#line 3344 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move to Special Purpose Register\n"));
#line 18787 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_to_Special_Purpose_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3344 "../../sim/ppc/powerpc.igen"
  {
    int n = (SPR_5_9_ << 5) | SPR_0_4_;
    if (SPR_0_ && IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else if (!spr_is_valid(n)
             || spr_is_readonly(n))
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    else {
      spreg new_val = (spr_length(n) == 64
    		   ? *rS
    		   : MASKED(*rS, 32, 63));
      /* HACK - time base registers need to be updated immediately */
      if (WITH_TIME_BASE) {
        switch (n) {
        case spr_tbu:
          cpu_set_time_base(processor,
                            (MASKED64(cpu_get_time_base(processor), 32, 63)
                             | INSERTED64(new_val, 0, 31)));
          break;
        case spr_tbl:
          cpu_set_time_base(processor,
                            (MASKED64(cpu_get_time_base(processor), 0, 31)
                             | INSERTED64(new_val, 32, 63)));
          break;
        case spr_dec:
          cpu_set_decrementer(processor, new_val);
          break;
        default:
          SPREG(n) = new_val;
          break;
        }
      }
      else {
        SPREG(n) = new_val;
      }
    }
    PPC_INSN_TO_SPR(RS_BITMASK, n);
  }
#line 18837 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.SPR,21.467,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef SPR
#line 18844 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_to_Special_Purpose_Register_SPR(cpu *processor,
                                              idecode_cache *cache_entry,
                                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_to_Special_Purpose_Register
#undef MY_PREFIX
#define MY_PREFIX Move_to_Special_Purpose_Register_SPR

  /* extraction: 0.31,6.RS,11.SPR,21.467,31./ #define get-values-from-icache */
#define RS cache_entry->crack.XFX.RS /* in icache - extraction */
#define rS cache_entry->crack.XFX.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.XFX.RS_BITMASK /* in icache - extraction */
#define SPR cache_entry->crack.XFX.SPR /* default in icache - extraction */
#line 18865 "semantics.c"

#define insn cache_entry->crack.XFX.insn
  unsigned_word nia;
#line 3344 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move to Special Purpose Register\n"));
#line 18871 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_to_Special_Purpose_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3344 "../../sim/ppc/powerpc.igen"
  {
    int n = (SPR_5_9_ << 5) | SPR_0_4_;
    if (SPR_0_ && IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else if (!spr_is_valid(n)
             || spr_is_readonly(n))
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    else {
      spreg new_val = (spr_length(n) == 64
    		   ? *rS
    		   : MASKED(*rS, 32, 63));
      /* HACK - time base registers need to be updated immediately */
      if (WITH_TIME_BASE) {
        switch (n) {
        case spr_tbu:
          cpu_set_time_base(processor,
                            (MASKED64(cpu_get_time_base(processor), 32, 63)
                             | INSERTED64(new_val, 0, 31)));
          break;
        case spr_tbl:
          cpu_set_time_base(processor,
                            (MASKED64(cpu_get_time_base(processor), 0, 31)
                             | INSERTED64(new_val, 32, 63)));
          break;
        case spr_dec:
          cpu_set_decrementer(processor, new_val);
          break;
        default:
          SPREG(n) = new_val;
          break;
        }
      }
      else {
        SPREG(n) = new_val;
      }
    }
    PPC_INSN_TO_SPR(RS_BITMASK, n);
  }
#line 18921 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.SPR,21.467,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef SPR
#line 18928 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Data_Cache_Block_Invalidate(cpu *processor,
                                     idecode_cache *cache_entry,
                                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Data_Cache_Block_Invalidate
#undef MY_PREFIX
#define MY_PREFIX Data_Cache_Block_Invalidate

  /* extraction: 0.31,6./,11.RA,16.RB,21.470,31./ #define get-values-from-icache */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 18952 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4916 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Data Cache Block Invalidate\n"));
#line 18958 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Data_Cache_Block_Invalidate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4916 "../../sim/ppc/powerpc.igen"
  {
    if (IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else
      TRACE(trace_tbd,("Data Cache Block Invalidate\n"));
  }
#line 18975 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,11.RA,16.RB,21.470,31./ #undef get-values-from-icache */
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 18985 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_NAND_Rc0(cpu *processor,
                  idecode_cache *cache_entry,
                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_NAND
#undef MY_PREFIX
#define MY_PREFIX NAND_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.476,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 19013 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3040 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics NAND\n"));
#line 19019 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_NAND, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3040 "../../sim/ppc/powerpc.igen"
  {
    *rA = ~(*rS & *rB);
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 19035 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.476,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 19049 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_NAND_Rc1(cpu *processor,
                  idecode_cache *cache_entry,
                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_NAND
#undef MY_PREFIX
#define MY_PREFIX NAND_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.476,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 19077 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3040 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics NAND\n"));
#line 19083 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_NAND, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3040 "../../sim/ppc/powerpc.igen"
  {
    *rA = ~(*rS & *rB);
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
  }
#line 19099 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.476,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 19113 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Divide_Word_OE0_Rc0(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_OE0_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 19142 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2745 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Divide Word\n"));
#line 19148 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Divide_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2745 "../../sim/ppc/powerpc.igen"
  {
    int64_t dividend = (int32_t)(*rA);
    int64_t divisor = (int32_t)(*rB);
    if (divisor == 0 /* nb 0x8000..0 is sign extended */
        || (dividend == 0x80000000 && divisor == -1)) {
      if (OE)
        XER |= (xer_overflow | xer_summary_overflow);
      CR0_COMPARE(0, 0, Rc);
    }
    else {
      int64_t quotent = dividend / divisor;
      *rT = quotent;
      CR0_COMPARE((signed_word)quotent, 0, Rc);
    }
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 19174 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 19189 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Divide_Word_OE0_Rc1(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_OE0_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 0 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 19218 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2745 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Divide Word\n"));
#line 19224 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Divide_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2745 "../../sim/ppc/powerpc.igen"
  {
    int64_t dividend = (int32_t)(*rA);
    int64_t divisor = (int32_t)(*rB);
    if (divisor == 0 /* nb 0x8000..0 is sign extended */
        || (dividend == 0x80000000 && divisor == -1)) {
      if (OE)
        XER |= (xer_overflow | xer_summary_overflow);
      CR0_COMPARE(0, 0, Rc);
    }
    else {
      int64_t quotent = dividend / divisor;
      *rT = quotent;
      CR0_COMPARE((signed_word)quotent, 0, Rc);
    }
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 19250 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 19265 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_to_Condition_Register_from_XER(cpu *processor,
                                             idecode_cache *cache_entry,
                                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_to_Condition_Register_from_XER
#undef MY_PREFIX
#define MY_PREFIX Move_to_Condition_Register_from_XER

  /* extraction: 0.31,6.BF,9./,11./,16./,21.512,31./ #define get-values-from-icache */
#define BF cache_entry->crack.X.BF /* in icache - extraction */
#define BF_BITMASK cache_entry->crack.X.BF_BITMASK /* in icache - extraction */
#line 19284 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3444 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move to Condition Register from XER\n"));
#line 19290 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_to_Condition_Register_from_XER, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3444 "../../sim/ppc/powerpc.igen"
  error("%s:%d:0x%08lx:%s unimplemented\n",
        itable[MY_INDEX].file, itable[MY_INDEX].line_nr, (long)cia, itable[MY_INDEX].name);
#line 19302 "semantics.c"
  return nia;
  /* extraction: 0.31,6.BF,9./,11./,16./,21.512,31./ #undef get-values-from-icache */
#undef BF
#undef BF_BITMASK
#line 19307 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Carrying_OE1_Rc0(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Carrying
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Carrying_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 19336 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2596 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Carrying\n"));
#line 19342 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Carrying, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2596 "../../sim/ppc/powerpc.igen"
  {
    /* RT <- ~RA + RB + 1 === RT <- RB - RA */
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD(1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 19361 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 19376 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Carrying_OE1_Rc1(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Carrying
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Carrying_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 19405 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2596 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Carrying\n"));
#line 19411 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Carrying, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2596 "../../sim/ppc/powerpc.igen"
  {
    /* RT <- ~RA + RB + 1 === RT <- RB - RA */
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD(1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 19430 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 19445 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Carrying_OE1_Rc0(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Carrying
#undef MY_PREFIX
#define MY_PREFIX Add_Carrying_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 19474 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2586 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Carrying\n"));
#line 19480 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Carrying, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2586 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 19496 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 19511 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Carrying_OE1_Rc1(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Carrying
#undef MY_PREFIX
#define MY_PREFIX Add_Carrying_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 19540 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2586 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Carrying\n"));
#line 19546 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Carrying, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2586 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 19562 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 19577 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_String_Word_Indexed(cpu *processor,
                                  idecode_cache *cache_entry,
                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_String_Word_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_String_Word_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.533,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 19604 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2328 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load String Word Indexed\n"));
#line 19610 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_String_Word_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2328 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    unsigned_word b;
    int n;
    int r;
    int i;
    int nr;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    n = EXTRACTED32(XER, 25, 31);
    r = RT - 1;
    i = 32;
    nr = (n + 3) / 4;
    if (((RT + nr >= 32)
         ? ((RA >= RT || RA < (RT + nr) % 32)
            || (RB >= RT || RB < (RT + nr) % 32))
         : ((RA >= RT && RA < RT + nr)
            || (RB >= RT && RB < RT + nr)))
        || (RT == RA || RT == RB))
      program_interrupt(processor, cia,
                      illegal_instruction_program_interrupt);
    if (CURRENT_ALIGNMENT == STRICT_ALIGNMENT)
      alignment_interrupt(processor, cia, EA);
    while (n > 0) {
      if (i == 32) {
        r = (r + 1) % 32;
        GPR(r) = 0;
      }
      GPR(r) |= INSERTED(MEM(unsigned, EA, 1), i, i+7);
      i = i + 8;
      if (i == 64) i = 32;
      EA = EA + 1;
      n = n - 1;
    }
  }
#line 19656 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.533,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 19669 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Word_ByteReverse_Indexed(cpu *processor,
                                       idecode_cache *cache_entry,
                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Word_ByteReverse_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Word_ByteReverse_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.534,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 19696 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2215 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Word Byte-Reverse Indexed\n"));
#line 19702 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Word_ByteReverse_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2215 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    *rT = SWAP_4(MEM(unsigned, EA, 4));
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 19721 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.534,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 19734 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_FloatingPoint_Single_Indexed(cpu *processor,
                                           idecode_cache *cache_entry,
                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_FloatingPoint_Single_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_FloatingPoint_Single_Indexed

  /* extraction: 0.31,6.FRT,11.RA,16.RB,21.535,31./ #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 19760 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3477 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Floating-Point Single Indexed\n"));
#line 19766 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_FloatingPoint_Single_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3477 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    *frT = DOUBLE(MEM(unsigned, EA, 4));
    PPC_INSN_INT_FLOAT(0, FRT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 19785 "semantics.c"
  return nia;
  /* extraction: 0.31,6.FRT,11.RA,16.RB,21.535,31./ #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 19797 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Shift_Right_Word_Rc0(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Right_Word
#undef MY_PREFIX
#define MY_PREFIX Shift_Right_Word_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.536,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 19825 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3271 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Shift Right Word\n"));
#line 19831 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Shift_Right_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3271 "../../sim/ppc/powerpc.igen"
  {
    int n = MASKED(*rB, 58, 63);
    uint32_t source = *rS;
    signed_word shifted;
    if (n < 32)
      shifted = (source >> n);
    else
      shifted = 0;
    *rA = shifted;
    CR0_COMPARE(shifted, 0, Rc);
    ITRACE(trace_alu, \
           ("n=%d, source=0x%lx, shifted=0x%lx\n",
            n, (unsigned long)source, (unsigned long)shifted));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 19856 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.536,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 19870 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Shift_Right_Word_Rc1(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Right_Word
#undef MY_PREFIX
#define MY_PREFIX Shift_Right_Word_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.536,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 19898 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3271 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Shift Right Word\n"));
#line 19904 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Shift_Right_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3271 "../../sim/ppc/powerpc.igen"
  {
    int n = MASKED(*rB, 58, 63);
    uint32_t source = *rS;
    signed_word shifted;
    if (n < 32)
      shifted = (source >> n);
    else
      shifted = 0;
    *rA = shifted;
    CR0_COMPARE(shifted, 0, Rc);
    ITRACE(trace_alu, \
           ("n=%d, source=0x%lx, shifted=0x%lx\n",
            n, (unsigned long)source, (unsigned long)shifted));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 19929 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.536,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 19943 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_OE1_Rc0(cpu *processor,
                               idecode_cache *cache_entry,
                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 19972 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2542 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From\n"));
#line 19978 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2542 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD(1);
    ALU_END(*rT, 0/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 19996 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 20011 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_OE1_Rc1(cpu *processor,
                               idecode_cache *cache_entry,
                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 20040 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2542 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From\n"));
#line 20046 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2542 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD(1);
    ALU_END(*rT, 0/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 20064 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 20079 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_TLB_Synchronize(cpu *processor,
                         idecode_cache *cache_entry,
                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_TLB_Synchronize
#undef MY_PREFIX
#define MY_PREFIX TLB_Synchronize

  /* extraction: 0.31,6./,11./,16./,21.566,31./ #define get-values-from-icache */
#line 20096 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 5010 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics TLB Synchronize\n"));
#line 20102 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_TLB_Synchronize, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 5010 "../../sim/ppc/powerpc.igen"
  {
    /* nothing happens here - always in sync */
  }
#line 20115 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,11./,16./,21.566,31./ #undef get-values-from-icache */
#line 20118 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_FloatingPoint_Single_with_Update_Indexed(cpu *processor,
                                                       idecode_cache *cache_entry,
                                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_FloatingPoint_Single_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_FloatingPoint_Single_with_Update_Indexed

  /* extraction: 0.31,6.FRT,11.RA,16.RB,21.567,31./ #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 20144 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3504 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Floating-Point Single with Update Indexed\n"));
#line 20150 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_FloatingPoint_Single_with_Update_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3504 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + *rB;
    *frT = DOUBLE(MEM(unsigned, EA, 4));
    *rA = EA;
    PPC_INSN_INT_FLOAT(RA_BITMASK, FRT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 20170 "semantics.c"
  return nia;
  /* extraction: 0.31,6.FRT,11.RA,16.RB,21.567,31./ #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 20182 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_From_Segment_Register(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_From_Segment_Register
#undef MY_PREFIX
#define MY_PREFIX Move_From_Segment_Register

  /* extraction: 0.31,6.RT,11./,12.SR,16./,21.595,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define SR cache_entry->crack.X.SR /* default in icache - extraction */
#line 20203 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4953 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move From Segment Register\n"));
#line 20209 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_From_Segment_Register, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4953 "../../sim/ppc/powerpc.igen"
  {
    if (IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else
      *rT = SEGREG(SR);
  }
#line 20226 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11./,12.SR,16./,21.595,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef SR
#line 20233 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_String_Word_Immediate(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_String_Word_Immediate
#undef MY_PREFIX
#define MY_PREFIX Load_String_Word_Immediate

  /* extraction: 0.31,6.RT,11.RA,16.NB,21.597,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define NB cache_entry->crack.X.NB /* default in icache - extraction */
#line 20258 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2296 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load String Word Immediate\n"));
#line 20264 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_String_Word_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2296 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    int n;
    int r;
    int i;
    int nr;
    if (RA_is_0) EA = 0;
    else         EA = *rA;
    if (NB == 0) n = 32;
    else         n = NB;
    r = RT - 1;
    i = 32;
    nr = (n + 3) / 4;
    if ((RT + nr >= 32)
        ? (RA >= RT || RA < (RT + nr) % 32)
        : (RA >= RT && RA < RT + nr))
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    if (CURRENT_ALIGNMENT == STRICT_ALIGNMENT)
      alignment_interrupt(processor, cia, EA);
    while (n > 0) {
      if (i == 32) {
        r = (r + 1) % 32;
        GPR(r) = 0;
      }
      GPR(r) |= INSERTED(MEM(unsigned, EA, 1), i, i+7);
      i = i + 8;
      if (i == 64) i = 32;
      EA = EA + 1;
      n = n - 1;
    }
  }
#line 20306 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.NB,21.597,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef NB
#line 20317 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Synchronize(cpu *processor,
                     idecode_cache *cache_entry,
                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Synchronize
#undef MY_PREFIX
#define MY_PREFIX Synchronize

  /* extraction: 0.31,6./,9.L,11./,16./,21.598,31./ #define get-values-from-icache */
#define L cache_entry->crack.X.L /* default in icache - extraction */
#line 20335 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2500 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Synchronize\n"));
#line 20341 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Synchronize, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2500 "../../sim/ppc/powerpc.igen"
  {
    /* do nothing */
  }
#line 20354 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,9.L,11./,16./,21.598,31./ #undef get-values-from-icache */
#undef L
#line 20358 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_FloatingPoint_Double_Indexed(cpu *processor,
                                           idecode_cache *cache_entry,
                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_FloatingPoint_Double_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_FloatingPoint_Double_Indexed

  /* extraction: 0.31,6.FRT,11.RA,16.RB,21.599,31./ #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 20384 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3531 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Floating-Point Double Indexed\n"));
#line 20390 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_FloatingPoint_Double_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3531 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    *frT = MEM(unsigned, EA, 8);
    PPC_INSN_INT_FLOAT(0, FRT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 20409 "semantics.c"
  return nia;
  /* extraction: 0.31,6.FRT,11.RA,16.RB,21.599,31./ #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 20421 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Negate_OE1_Rc0(cpu *processor,
                        idecode_cache *cache_entry,
                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Negate
#undef MY_PREFIX
#define MY_PREFIX Negate_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 20447 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2676 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Negate\n"));
#line 20453 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Negate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2676 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(1);
    ALU_END(*rT,0/*CA*/,OE,Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 20470 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 20482 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Negate_OE1_Rc1(cpu *processor,
                        idecode_cache *cache_entry,
                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Negate
#undef MY_PREFIX
#define MY_PREFIX Negate_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 20508 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2676 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Negate\n"));
#line 20514 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Negate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2676 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(1);
    ALU_END(*rT,0/*CA*/,OE,Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 20531 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 20543 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_FloatingPoint_Double_with_Update_Indexed(cpu *processor,
                                                       idecode_cache *cache_entry,
                                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_FloatingPoint_Double_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_FloatingPoint_Double_with_Update_Indexed

  /* extraction: 0.31,6.FRT,11.RA,16.RB,21.631,31./ #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 20569 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3558 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Floating-Point Double with Update Indexed\n"));
#line 20575 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_FloatingPoint_Double_with_Update_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3558 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + *rB;
    *frT = MEM(unsigned, EA, 8);
    *rA = EA;
    PPC_INSN_INT_FLOAT(RA_BITMASK, FRT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 20595 "semantics.c"
  return nia;
  /* extraction: 0.31,6.FRT,11.RA,16.RB,21.631,31./ #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 20607 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Extended_OE1_Rc0(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Extended_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 20636 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2620 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Extended\n"));
#line 20642 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2620 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 20660 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 20675 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Extended_OE1_Rc1(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Extended_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 20704 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2620 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Extended\n"));
#line 20710 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2620 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD(*rB);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 20728 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 20743 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Extended_OE1_Rc0(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_Extended_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 20772 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2609 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Extended\n"));
#line 20778 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2609 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 20795 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 20810 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_Extended_OE1_Rc1(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_Extended_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 20839 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2609 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add Extended\n"));
#line 20845 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2609 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 20862 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 20877 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_From_Segment_Register_Indirect(cpu *processor,
                                             idecode_cache *cache_entry,
                                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_From_Segment_Register_Indirect
#undef MY_PREFIX
#define MY_PREFIX Move_From_Segment_Register_Indirect

  /* extraction: 0.31,6.RT,11./,16.RB,21.659,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 20900 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4964 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move From Segment Register Indirect\n"));
#line 20906 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_From_Segment_Register_Indirect, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4964 "../../sim/ppc/powerpc.igen"
  {
    if (IS_PROBLEM_STATE(processor))
      program_interrupt(processor, cia,
                        privileged_instruction_program_interrupt);
    else
      *rT = SEGREG(EXTRACTED32(*rB, 0, 3));
  }
#line 20923 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11./,16.RB,21.659,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RB
#undef rB
#undef RB_BITMASK
#line 20932 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_String_Word_Indexed(cpu *processor,
                                   idecode_cache *cache_entry,
                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_String_Word_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_String_Word_Indexed

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.661,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 20959 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2386 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store String Word Indexed\n"));
#line 20965 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_String_Word_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2386 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    unsigned_word b;
    int n;
    int r;
    int i;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    if (CURRENT_ALIGNMENT == STRICT_ALIGNMENT)
      alignment_interrupt(processor, cia, EA);
    n = EXTRACTED32(XER, 25, 31);
    r = RS - 1;
    i = 32;
    while (n > 0) {
      if (i == 32) r = (r + 1) % 32;
      STORE(EA, 1, EXTRACTED(GPR(r), i, i+7));
      i = i + 8;
      if (i == 64) i = 32;
      EA = EA + 1;
      n = n - 1;
    }
  }
#line 20998 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.661,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 21011 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Word_ByteReversed_Indexed(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Word_ByteReversed_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Word_ByteReversed_Indexed

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.662,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 21038 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2241 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Word Byte-Reversed Indexed\n"));
#line 21044 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Word_ByteReversed_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2241 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    STORE(EA, 4, SWAP_4(*rS));
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK | RS_BITMASK, 0);
  }
#line 21063 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.662,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 21076 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_FloatingPoint_Single_Indexed(cpu *processor,
                                            idecode_cache *cache_entry,
                                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_FloatingPoint_Single_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_FloatingPoint_Single_Indexed

  /* extraction: 0.31,6.FRS,11.RA,16.RB,21.663,31./ #define get-values-from-icache */
#define frS cache_entry->crack.X.frS /* in icache - extraction */
#define FRS_BITMASK cache_entry->crack.X.FRS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 21102 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3590 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Floating-Point Single Indexed\n"));
#line 21108 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_FloatingPoint_Single_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3590 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    STORE(EA, 4, SINGLE(*frS));
    PPC_INSN_INT_FLOAT(0, 0, (RA_BITMASK & ~1) | RB_BITMASK, FRS_BITMASK);
  }
#line 21127 "semantics.c"
  return nia;
  /* extraction: 0.31,6.FRS,11.RA,16.RB,21.663,31./ #undef get-values-from-icache */
#undef frS
#undef FRS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 21139 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_FloatingPoint_Single_with_Update_Indexed(cpu *processor,
                                                        idecode_cache *cache_entry,
                                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_FloatingPoint_Single_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_FloatingPoint_Single_with_Update_Indexed

  /* extraction: 0.31,6.FRS,11.RA,16.RB,21.695,31./ #define get-values-from-icache */
#define frS cache_entry->crack.X.frS /* in icache - extraction */
#define FRS_BITMASK cache_entry->crack.X.FRS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 21165 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3617 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Floating-Point Single with Update Indexed\n"));
#line 21171 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_FloatingPoint_Single_with_Update_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3617 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + *rB;
    STORE(EA, 4, SINGLE(*frS));
    *rA = EA;
    PPC_INSN_INT_FLOAT(RA_BITMASK, 0, (RA_BITMASK & ~1) | RB_BITMASK, FRS_BITMASK);
  }
#line 21191 "semantics.c"
  return nia;
  /* extraction: 0.31,6.FRS,11.RA,16.RB,21.695,31./ #undef get-values-from-icache */
#undef frS
#undef FRS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 21203 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_from_Zero_Extended_OE1_Rc0(cpu *processor,
                                             idecode_cache *cache_entry,
                                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_from_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_from_Zero_Extended_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 21229 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2665 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract from Zero Extended\n"));
#line 21235 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_from_Zero_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2665 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 21252 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 21264 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_from_Zero_Extended_OE1_Rc1(cpu *processor,
                                             idecode_cache *cache_entry,
                                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_from_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_from_Zero_Extended_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 21290 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2665 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract from Zero Extended\n"));
#line 21296 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_from_Zero_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2665 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 21313 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 21325 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_to_Zero_Extended_OE1_Rc0(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Zero_Extended_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 21351 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2655 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add to Zero Extended\n"));
#line 21357 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_to_Zero_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2655 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 21373 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 21385 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_to_Zero_Extended_OE1_Rc1(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Zero_Extended_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 21411 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2655 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add to Zero Extended\n"));
#line 21417 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_to_Zero_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2655 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD_CA;
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 21433 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 21445 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_String_Word_Immedate(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_String_Word_Immedate
#undef MY_PREFIX
#define MY_PREFIX Store_String_Word_Immedate

  /* extraction: 0.31,6.RS,11.RA,16.NB,21.725,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define NB cache_entry->crack.X.NB /* default in icache - extraction */
#line 21470 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2364 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store String Word Immedate\n"));
#line 21476 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_String_Word_Immedate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2364 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    int n;
    int r;
    int i;
    if (RA_is_0) EA = 0;
    else         EA = *rA;
    if (NB == 0) n = 32;
    else         n = NB;
    r = RS - 1;
    i = 32;
    if (CURRENT_ALIGNMENT == STRICT_ALIGNMENT)
      alignment_interrupt(processor, cia, EA);
    while (n > 0) {
      if (i == 32) r = (r + 1) % 32;
      STORE(EA, 1, EXTRACTED(GPR(r), i, i+7));
      i = i + 8;
      if (i == 64) i = 32;
      EA = EA + 1;
      n = n - 1;
    }
  }
#line 21508 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.NB,21.725,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef NB
#line 21519 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_FloatingPoint_Double_Indexed(cpu *processor,
                                            idecode_cache *cache_entry,
                                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_FloatingPoint_Double_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_FloatingPoint_Double_Indexed

  /* extraction: 0.31,6.FRS,11.RA,16.RB,21.727,31./ #define get-values-from-icache */
#define frS cache_entry->crack.X.frS /* in icache - extraction */
#define FRS_BITMASK cache_entry->crack.X.FRS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 21545 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3644 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Floating-Point Double Indexed\n"));
#line 21551 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_FloatingPoint_Double_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3644 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    STORE(EA, 8, *frS);
    PPC_INSN_INT_FLOAT(0, 0, (RA_BITMASK & ~1) | RB_BITMASK, FRS_BITMASK);
  }
#line 21570 "semantics.c"
  return nia;
  /* extraction: 0.31,6.FRS,11.RA,16.RB,21.727,31./ #undef get-values-from-icache */
#undef frS
#undef FRS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 21582 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Minus_One_Extended_OE1_Rc0(cpu *processor,
                                                  idecode_cache *cache_entry,
                                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Minus_One_Extended_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 21608 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2643 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Minus One Extended\n"));
#line 21614 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Minus_One_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2643 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD_CA;
    ALU_ADD(-1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 21632 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 21644 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Subtract_From_Minus_One_Extended_OE1_Rc1(cpu *processor,
                                                  idecode_cache *cache_entry,
                                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Minus_One_Extended_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 21670 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2643 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Subtract From Minus One Extended\n"));
#line 21676 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Subtract_From_Minus_One_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2643 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_NOT;
    ALU_ADD_CA;
    ALU_ADD(-1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 21694 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 21706 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_to_Minus_One_Extended_OE1_Rc0(cpu *processor,
                                           idecode_cache *cache_entry,
                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Minus_One_Extended_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 21732 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2632 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add to Minus One Extended\n"));
#line 21738 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_to_Minus_One_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2632 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD_CA;
    ALU_ADD(-1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 21755 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 21767 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_to_Minus_One_Extended_OE1_Rc1(cpu *processor,
                                           idecode_cache *cache_entry,
                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Minus_One_Extended_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 21793 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2632 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add to Minus One Extended\n"));
#line 21799 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add_to_Minus_One_Extended, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2632 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD_CA;
    ALU_ADD(-1);
    ALU_END(*rT, 1/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
  }
#line 21816 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef OE
#undef Rc
#line 21828 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Multiply_Low_Word_OE1_Rc0(cpu *processor,
                                   idecode_cache *cache_entry,
                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_Low_Word
#undef MY_PREFIX
#define MY_PREFIX Multiply_Low_Word_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 21857 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2698 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Multiply Low Word\n"));
#line 21863 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Multiply_Low_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2698 "../../sim/ppc/powerpc.igen"
  {
    int64_t a = (int32_t)(*rA);
    int64_t b = (int32_t)(*rB);
    int64_t prod = a * b;
    signed_word t = prod;
    *rT = *rA * *rB;
    if (t != prod && OE)
      XER |= (xer_overflow | xer_summary_overflow);
    CR0_COMPARE(t, 0, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 21884 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 21899 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Multiply_Low_Word_OE1_Rc1(cpu *processor,
                                   idecode_cache *cache_entry,
                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_Low_Word
#undef MY_PREFIX
#define MY_PREFIX Multiply_Low_Word_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 21928 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2698 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Multiply Low Word\n"));
#line 21934 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Multiply_Low_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2698 "../../sim/ppc/powerpc.igen"
  {
    int64_t a = (int32_t)(*rA);
    int64_t b = (int32_t)(*rB);
    int64_t prod = a * b;
    signed_word t = prod;
    *rT = *rA * *rB;
    if (t != prod && OE)
      XER |= (xer_overflow | xer_summary_overflow);
    CR0_COMPARE(t, 0, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 21955 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 21970 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_FloatingPoint_Double_with_Update_Indexed(cpu *processor,
                                                        idecode_cache *cache_entry,
                                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_FloatingPoint_Double_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_FloatingPoint_Double_with_Update_Indexed

  /* extraction: 0.31,6.FRS,11.RA,16.RB,21.759,31./ #define get-values-from-icache */
#define frS cache_entry->crack.X.frS /* in icache - extraction */
#define FRS_BITMASK cache_entry->crack.X.FRS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 21996 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3683 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Floating-Point Double with Update Indexed\n"));
#line 22002 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_FloatingPoint_Double_with_Update_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3683 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + *rB;
    STORE(EA, 8, *frS);
    *rA = EA;
    PPC_INSN_INT_FLOAT(RA_BITMASK, 0, (RA_BITMASK & ~1) | RB_BITMASK, FRS_BITMASK);
  }
#line 22022 "semantics.c"
  return nia;
  /* extraction: 0.31,6.FRS,11.RA,16.RB,21.759,31./ #undef get-values-from-icache */
#undef frS
#undef FRS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 22034 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_OE1_Rc0(cpu *processor,
                     idecode_cache *cache_entry,
                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add
#undef MY_PREFIX
#define MY_PREFIX Add_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 22063 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2532 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add\n"));
#line 22069 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2532 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_END(*rT, 0/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 22085 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 22100 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Add_OE1_Rc1(cpu *processor,
                     idecode_cache *cache_entry,
                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Add
#undef MY_PREFIX
#define MY_PREFIX Add_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 22129 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2532 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Add\n"));
#line 22135 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Add, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2532 "../../sim/ppc/powerpc.igen"
  {
    ALU_BEGIN(*rA);
    ALU_ADD(*rB);
    ALU_END(*rT, 0/*CA*/, OE, Rc);
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 22151 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 22166 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Halfword_ByteReverse_Indexed(cpu *processor,
                                           idecode_cache *cache_entry,
                                           unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_ByteReverse_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_ByteReverse_Indexed

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.790,31./ #define get-values-from-icache */
#define RT cache_entry->crack.X.RT /* in icache - extraction */
#define rT cache_entry->crack.X.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.X.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 22193 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2202 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Halfword Byte-Reverse Indexed\n"));
#line 22199 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Halfword_ByteReverse_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2202 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    *rT = SWAP_2(MEM(unsigned, EA, 2));
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 22218 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.790,31./ #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 22231 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Shift_Right_Algebraic_Word_Rc0(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Right_Algebraic_Word
#undef MY_PREFIX
#define MY_PREFIX Shift_Right_Algebraic_Word_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.792,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 22259 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3314 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Shift Right Algebraic Word\n"));
#line 22265 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Shift_Right_Algebraic_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3314 "../../sim/ppc/powerpc.igen"
  {
    uint64_t mask;
    int n = MASKED(*rB, 59, 63);
    int32_t source = (int32_t)*rS; /* signed to keep sign bit */
    int S = (MASKED(*rS,32,32) != 0);
    int64_t r = ((uint64_t) source);
    r = ((uint64_t) source) << 32 | (uint32_t) source;
    r = ROTL64(r,64-n);
    if (MASKED(*rB,58,58) == 0)
    	mask = (uint64_t) MASK64(n+32,63);
    else
    	mask = (uint64_t) 0;
    *rA = (signed_word) ((r & mask) | (((int64_t) -1*S) & ~mask)); /* if 64bit will sign extend */
    if (S && (MASKED(r & ~mask,32,63)!=0))
      XER |= xer_carry;
    else
      XER &= ~xer_carry;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx), XER = %ld\n",
    		   (long)*rA, (long)*rA, (long)XER));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 22297 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.792,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 22311 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Shift_Right_Algebraic_Word_Rc1(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Right_Algebraic_Word
#undef MY_PREFIX
#define MY_PREFIX Shift_Right_Algebraic_Word_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.792,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 22339 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3314 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Shift Right Algebraic Word\n"));
#line 22345 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Shift_Right_Algebraic_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3314 "../../sim/ppc/powerpc.igen"
  {
    uint64_t mask;
    int n = MASKED(*rB, 59, 63);
    int32_t source = (int32_t)*rS; /* signed to keep sign bit */
    int S = (MASKED(*rS,32,32) != 0);
    int64_t r = ((uint64_t) source);
    r = ((uint64_t) source) << 32 | (uint32_t) source;
    r = ROTL64(r,64-n);
    if (MASKED(*rB,58,58) == 0)
    	mask = (uint64_t) MASK64(n+32,63);
    else
    	mask = (uint64_t) 0;
    *rA = (signed_word) ((r & mask) | (((int64_t) -1*S) & ~mask)); /* if 64bit will sign extend */
    if (S && (MASKED(r & ~mask,32,63)!=0))
      XER |= xer_carry;
    else
      XER &= ~xer_carry;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx), XER = %ld\n",
    		   (long)*rA, (long)*rA, (long)XER));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 22377 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.792,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef Rc
#line 22391 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Shift_Right_Algebraic_Word_Immediate_Rc0(cpu *processor,
                                                  idecode_cache *cache_entry,
                                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Right_Algebraic_Word_Immediate
#undef MY_PREFIX
#define MY_PREFIX Shift_Right_Algebraic_Word_Immediate_Rc0

  /* extraction: 0.31,6.RS,11.RA,16.SH,21.824,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define SH cache_entry->crack.X.SH /* default in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 22417 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3292 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Shift Right Algebraic Word Immediate\n"));
#line 22423 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Shift_Right_Algebraic_Word_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3292 "../../sim/ppc/powerpc.igen"
  {
    int n = SH;
    signed_word r = ROTL32(*rS, /*64*/32-n);
    signed_word m = MASK(n+32, 63);
    int S = MASKED(*rS, 32, 32);
    signed_word shifted = (r & m) | (S ? ~m : 0);
    *rA = shifted;
    if (S && ((r & ~m) & MASK(32, 63)) != 0)
      XER |= xer_carry;
    else
      XER &= ~xer_carry;
    CR0_COMPARE(shifted, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx), XER = %ld\n",
    		   (long)*rA, (long)*rA, (long)XER));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 22449 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.SH,21.824,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef SH
#undef Rc
#line 22461 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Shift_Right_Algebraic_Word_Immediate_Rc1(cpu *processor,
                                                  idecode_cache *cache_entry,
                                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Right_Algebraic_Word_Immediate
#undef MY_PREFIX
#define MY_PREFIX Shift_Right_Algebraic_Word_Immediate_Rc1

  /* extraction: 0.31,6.RS,11.RA,16.SH,21.824,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define SH cache_entry->crack.X.SH /* default in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 22487 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3292 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Shift Right Algebraic Word Immediate\n"));
#line 22493 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Shift_Right_Algebraic_Word_Immediate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3292 "../../sim/ppc/powerpc.igen"
  {
    int n = SH;
    signed_word r = ROTL32(*rS, /*64*/32-n);
    signed_word m = MASK(n+32, 63);
    int S = MASKED(*rS, 32, 32);
    signed_word shifted = (r & m) | (S ? ~m : 0);
    *rA = shifted;
    if (S && ((r & ~m) & MASK(32, 63)) != 0)
      XER |= xer_carry;
    else
      XER &= ~xer_carry;
    CR0_COMPARE(shifted, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx), XER = %ld\n",
    		   (long)*rA, (long)*rA, (long)XER));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 22519 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.SH,21.824,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef SH
#undef Rc
#line 22531 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Enforce_Inorder_Execution_of_IO(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Enforce_Inorder_Execution_of_IO
#undef MY_PREFIX
#define MY_PREFIX Enforce_Inorder_Execution_of_IO

  /* extraction: 0.31,6./,11./,16./,21.854,31./ #define get-values-from-icache */
#line 22548 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4827 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Enforce In-order Execution of I/O\n"));
#line 22554 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Enforce_Inorder_Execution_of_IO, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4827 "../../sim/ppc/powerpc.igen"
  {
    /* Since this model has no instruction overlap
       this instruction need do nothing */
  }
#line 22568 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,11./,16./,21.854,31./ #undef get-values-from-icache */
#line 22571 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Half_Word_ByteReversed_Indexed(cpu *processor,
                                              idecode_cache *cache_entry,
                                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Half_Word_ByteReversed_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Half_Word_ByteReversed_Indexed

  /* extraction: 0.31,6.RS,11.RA,16.RB,21.918,31./ #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 22598 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 2228 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Half Word Byte-Reversed Indexed\n"));
#line 22604 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Half_Word_ByteReversed_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2228 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    STORE(EA, 2, SWAP_2(*rS));
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK | RS_BITMASK, 0);
  }
#line 22623 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16.RB,21.918,31./ #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 22636 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Extend_Sign_Half_Word_Rc0(cpu *processor,
                                   idecode_cache *cache_entry,
                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Extend_Sign_Half_Word
#undef MY_PREFIX
#define MY_PREFIX Extend_Sign_Half_Word_Rc0

  /* extraction: 0.31,6.RS,11.RA,16./,21.922,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define Rc 0 /* default in icache - constant field */
#line 22661 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3100 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Extend Sign Half Word\n"));
#line 22667 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Extend_Sign_Half_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3100 "../../sim/ppc/powerpc.igen"
  {
    *rA = (signed_word)(int16_t)*rS;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 22683 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16./,21.922,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef Rc
#line 22694 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Extend_Sign_Half_Word_Rc1(cpu *processor,
                                   idecode_cache *cache_entry,
                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Extend_Sign_Half_Word
#undef MY_PREFIX
#define MY_PREFIX Extend_Sign_Half_Word_Rc1

  /* extraction: 0.31,6.RS,11.RA,16./,21.922,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define Rc 1 /* default in icache - constant field */
#line 22719 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3100 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Extend Sign Half Word\n"));
#line 22725 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Extend_Sign_Half_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3100 "../../sim/ppc/powerpc.igen"
  {
    *rA = (signed_word)(int16_t)*rS;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 22741 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16./,21.922,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef Rc
#line 22752 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Extend_Sign_Byte_Rc0(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Extend_Sign_Byte
#undef MY_PREFIX
#define MY_PREFIX Extend_Sign_Byte_Rc0

  /* extraction: 0.31,6.RS,11.RA,16./,21.954,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define Rc 0 /* default in icache - constant field */
#line 22777 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3090 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Extend Sign Byte\n"));
#line 22783 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Extend_Sign_Byte, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3090 "../../sim/ppc/powerpc.igen"
  {
    *rA = (signed_word)(int8_t)*rS;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 22799 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16./,21.954,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef Rc
#line 22810 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Extend_Sign_Byte_Rc1(cpu *processor,
                              idecode_cache *cache_entry,
                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Extend_Sign_Byte
#undef MY_PREFIX
#define MY_PREFIX Extend_Sign_Byte_Rc1

  /* extraction: 0.31,6.RS,11.RA,16./,21.954,31.Rc #define get-values-from-icache */
#define RS cache_entry->crack.X.RS /* in icache - extraction */
#define rS cache_entry->crack.X.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.X.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define Rc 1 /* default in icache - constant field */
#line 22835 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3090 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Extend Sign Byte\n"));
#line 22841 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Extend_Sign_Byte, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3090 "../../sim/ppc/powerpc.igen"
  {
    *rA = (signed_word)(int8_t)*rS;
    CR0_COMPARE(*rA, 0, Rc);
    ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
    PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
  }
#line 22857 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RS,11.RA,16./,21.954,31.Rc #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef Rc
#line 22868 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Divide_Word_Unsigned_OE1_Rc0(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word_Unsigned
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_Unsigned_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 22897 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2767 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Divide Word Unsigned\n"));
#line 22903 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Divide_Word_Unsigned, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2767 "../../sim/ppc/powerpc.igen"
  {
    uint64_t dividend = (uint32_t)(*rA);
    uint64_t divisor = (uint32_t)(*rB);
    if (divisor == 0) {
      if (OE)
        XER |= (xer_overflow | xer_summary_overflow);
      CR0_COMPARE(0, 0, Rc);
    }
    else {
      uint64_t quotent = dividend / divisor;
      *rT = quotent;
      CR0_COMPARE((signed_word)quotent, 0, Rc);
    }
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 22928 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 22943 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Divide_Word_Unsigned_OE1_Rc1(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word_Unsigned
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_Unsigned_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 22972 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2767 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Divide Word Unsigned\n"));
#line 22978 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Divide_Word_Unsigned, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2767 "../../sim/ppc/powerpc.igen"
  {
    uint64_t dividend = (uint32_t)(*rA);
    uint64_t divisor = (uint32_t)(*rB);
    if (divisor == 0) {
      if (OE)
        XER |= (xer_overflow | xer_summary_overflow);
      CR0_COMPARE(0, 0, Rc);
    }
    else {
      uint64_t quotent = dividend / divisor;
      *rT = quotent;
      CR0_COMPARE((signed_word)quotent, 0, Rc);
    }
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 23003 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 23018 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Instruction_Cache_Block_Invalidate(cpu *processor,
                                            idecode_cache *cache_entry,
                                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Instruction_Cache_Block_Invalidate
#undef MY_PREFIX
#define MY_PREFIX Instruction_Cache_Block_Invalidate

  /* extraction: 0.31,6./,11.RA,16.RB,21.982,31./ #define get-values-from-icache */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 23042 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4763 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Instruction Cache Block Invalidate\n"));
#line 23048 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Instruction_Cache_Block_Invalidate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4763 "../../sim/ppc/powerpc.igen"
  {
    /* blindly flush all instruction cache entries */
#if WITH_IDECODE_CACHE_SIZE
    cpu_flush_icache(processor);
#endif
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK, 0);
  }
#line 23065 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,11.RA,16.RB,21.982,31./ #undef get-values-from-icache */
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 23075 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_FloatingPoint_Integer_Word_Indexed(cpu *processor,
                                                  idecode_cache *cache_entry,
                                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_FloatingPoint_Integer_Word_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_FloatingPoint_Integer_Word_Indexed

  /* extraction: 0.31,6.FRS,11.RA,16.RB,21.983,31./ #define get-values-from-icache */
#define frS cache_entry->crack.X.frS /* in icache - extraction */
#define FRS_BITMASK cache_entry->crack.X.FRS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 23101 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3656 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Floating-Point Integer Word Indexed\n"));
#line 23107 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_FloatingPoint_Integer_Word_Indexed, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3656 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + *rB;
    STORE(EA, 4, *frS);
    PPC_INSN_INT_FLOAT(0, 0, (RA_BITMASK & ~1) | RB_BITMASK, FRS_BITMASK);
  }
#line 23126 "semantics.c"
  return nia;
  /* extraction: 0.31,6.FRS,11.RA,16.RB,21.983,31./ #undef get-values-from-icache */
#undef frS
#undef FRS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 23138 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Divide_Word_OE1_Rc0(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_OE1_Rc0

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 0 /* default in icache - constant field */
#line 23167 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2745 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Divide Word\n"));
#line 23173 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Divide_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2745 "../../sim/ppc/powerpc.igen"
  {
    int64_t dividend = (int32_t)(*rA);
    int64_t divisor = (int32_t)(*rB);
    if (divisor == 0 /* nb 0x8000..0 is sign extended */
        || (dividend == 0x80000000 && divisor == -1)) {
      if (OE)
        XER |= (xer_overflow | xer_summary_overflow);
      CR0_COMPARE(0, 0, Rc);
    }
    else {
      int64_t quotent = dividend / divisor;
      *rT = quotent;
      CR0_COMPARE((signed_word)quotent, 0, Rc);
    }
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 23199 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 23214 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Divide_Word_OE1_Rc1(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_OE1_Rc1

  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #define get-values-from-icache */
#define RT cache_entry->crack.XO.RT /* in icache - extraction */
#define rT cache_entry->crack.XO.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.XO.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.XO.RA /* in icache - extraction */
#define rA cache_entry->crack.XO.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.XO.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.XO.RB /* in icache - extraction */
#define rB cache_entry->crack.XO.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.XO.RB_BITMASK /* in icache - extraction */
#define OE 1 /* default in icache - constant field */
#define Rc 1 /* default in icache - constant field */
#line 23243 "semantics.c"

#define insn cache_entry->crack.XO.insn
  unsigned_word nia;
#line 2745 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Divide Word\n"));
#line 23249 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Divide_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2745 "../../sim/ppc/powerpc.igen"
  {
    int64_t dividend = (int32_t)(*rA);
    int64_t divisor = (int32_t)(*rB);
    if (divisor == 0 /* nb 0x8000..0 is sign extended */
        || (dividend == 0x80000000 && divisor == -1)) {
      if (OE)
        XER |= (xer_overflow | xer_summary_overflow);
      CR0_COMPARE(0, 0, Rc);
    }
    else {
      int64_t quotent = dividend / divisor;
      *rT = quotent;
      CR0_COMPARE((signed_word)quotent, 0, Rc);
    }
    PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
  }
#line 23275 "semantics.c"
  return nia;
  /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#undef OE
#undef Rc
#line 23290 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Data_Cache_Block_set_to_Zero(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Data_Cache_Block_set_to_Zero
#undef MY_PREFIX
#define MY_PREFIX Data_Cache_Block_set_to_Zero

  /* extraction: 0.31,6./,11.RA,16.RB,21.1014,31./ #define get-values-from-icache */
#define RA cache_entry->crack.X.RA /* in icache - extraction */
#define rA cache_entry->crack.X.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.X.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define RB cache_entry->crack.X.RB /* in icache - extraction */
#define rB cache_entry->crack.X.rB /* in icache - extraction */
#define RB_BITMASK cache_entry->crack.X.RB_BITMASK /* in icache - extraction */
#line 23314 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4803 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Data Cache Block set to Zero\n"));
#line 23320 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Data_Cache_Block_set_to_Zero, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4803 "../../sim/ppc/powerpc.igen"
  {
    TRACE(trace_tbd,("Data Cache Block set to Zero\n"));
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK, 0/*Rc*/);
  }
#line 23334 "semantics.c"
  return nia;
  /* extraction: 0.31,6./,11.RA,16.RB,21.1014,31./ #undef get-values-from-icache */
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef RB
#undef rB
#undef RB_BITMASK
#line 23344 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Word_and_Zero(cpu *processor,
                            idecode_cache *cache_entry,
                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Word_and_Zero
#undef MY_PREFIX
#define MY_PREFIX Load_Word_and_Zero

  /* extraction: 0.32,6.RT,11.RA,16.D #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 23369 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 1885 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Word and Zero\n"));
#line 23375 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Word_and_Zero, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1885 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    *rT = MEM(unsigned, EA, 4);
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 23394 "semantics.c"
  return nia;
  /* extraction: 0.32,6.RT,11.RA,16.D #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 23405 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Word_and_Zero_with_Update(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Word_and_Zero_with_Update
#undef MY_PREFIX
#define MY_PREFIX Load_Word_and_Zero_with_Update

  /* extraction: 0.33,6.RT,11.RA,16.D #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 23430 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 1911 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Word and Zero with Update\n"));
#line 23436 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Word_and_Zero_with_Update, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1911 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0 || RA == RT)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + EXTS(D);
    *rT = MEM(unsigned, EA, 4);
    *rA = EA;
    PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK, 0);
  }
#line 23456 "semantics.c"
  return nia;
  /* extraction: 0.33,6.RT,11.RA,16.D #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 23467 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Byte_and_Zero(cpu *processor,
                            idecode_cache *cache_entry,
                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Byte_and_Zero
#undef MY_PREFIX
#define MY_PREFIX Load_Byte_and_Zero

  /* extraction: 0.34,6.RT,11.RA,16.D #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 23492 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 1722 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Byte and Zero\n"));
#line 23498 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Byte_and_Zero, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1722 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    *rT = MEM(unsigned, EA, 1);
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 23517 "semantics.c"
  return nia;
  /* extraction: 0.34,6.RT,11.RA,16.D #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 23528 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Byte_and_Zero_with_Update(cpu *processor,
                                        idecode_cache *cache_entry,
                                        unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Byte_and_Zero_with_Update
#undef MY_PREFIX
#define MY_PREFIX Load_Byte_and_Zero_with_Update

  /* extraction: 0.35,6.RT,11.RA,16.D #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 23553 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 1749 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Byte and Zero with Update\n"));
#line 23559 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Byte_and_Zero_with_Update, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1749 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0 || RA == RT)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + EXTS(D);
    *rT = MEM(unsigned, EA, 1);
    *rA = EA;
    PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK, 0);
  }
#line 23579 "semantics.c"
  return nia;
  /* extraction: 0.35,6.RT,11.RA,16.D #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 23590 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Word(cpu *processor,
                    idecode_cache *cache_entry,
                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Word
#undef MY_PREFIX
#define MY_PREFIX Store_Word

  /* extraction: 0.36,6.RS,11.RA,16.D #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 23615 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2112 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Word\n"));
#line 23621 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2112 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    STORE(EA, 4, *rS);
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RS_BITMASK, 0);
  }
#line 23640 "semantics.c"
  return nia;
  /* extraction: 0.36,6.RS,11.RA,16.D #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 23651 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Word_with_Update(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Word_with_Update
#undef MY_PREFIX
#define MY_PREFIX Store_Word_with_Update

  /* extraction: 0.37,6.RS,11.RA,16.D #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 23676 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2138 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Word with Update\n"));
#line 23682 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Word_with_Update, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2138 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + EXTS(D);
    STORE(EA, 4, *rS);
    *rA = EA;
    PPC_INSN_INT(RA_BITMASK, RA_BITMASK | RS_BITMASK, 0);
  }
#line 23702 "semantics.c"
  return nia;
  /* extraction: 0.37,6.RS,11.RA,16.D #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 23713 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Byte(cpu *processor,
                    idecode_cache *cache_entry,
                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Byte
#undef MY_PREFIX
#define MY_PREFIX Store_Byte

  /* extraction: 0.38,6.RS,11.RA,16.D #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 23738 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2004 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Byte\n"));
#line 23744 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Byte, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2004 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    STORE(EA, 1, *rS);
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RS_BITMASK, 0);
  }
#line 23763 "semantics.c"
  return nia;
  /* extraction: 0.38,6.RS,11.RA,16.D #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 23774 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Byte_with_Update(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Byte_with_Update
#undef MY_PREFIX
#define MY_PREFIX Store_Byte_with_Update

  /* extraction: 0.39,6.RS,11.RA,16.D #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 23799 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2030 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Byte with Update\n"));
#line 23805 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Byte_with_Update, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2030 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + EXTS(D);
    STORE(EA, 1, *rS);
    *rA = EA;
    PPC_INSN_INT(RA_BITMASK, RA_BITMASK | RS_BITMASK, 0);
  }
#line 23825 "semantics.c"
  return nia;
  /* extraction: 0.39,6.RS,11.RA,16.D #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 23836 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Halfword_and_Zero(cpu *processor,
                                idecode_cache *cache_entry,
                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_and_Zero
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_and_Zero

  /* extraction: 0.40,6.RT,11.RA,16.D #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 23861 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 1777 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Halfword and Zero\n"));
#line 23867 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Halfword_and_Zero, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1777 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    *rT = MEM(unsigned, EA, 2);
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 23886 "semantics.c"
  return nia;
  /* extraction: 0.40,6.RT,11.RA,16.D #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 23897 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Halfword_and_Zero_with_Update(cpu *processor,
                                            idecode_cache *cache_entry,
                                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_and_Zero_with_Update
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_and_Zero_with_Update

  /* extraction: 0.41,6.RT,11.RA,16.D #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 23922 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 1803 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Halfword and Zero with Update\n"));
#line 23928 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Halfword_and_Zero_with_Update, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1803 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0 || RA == RT)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + EXTS(D);
    *rT = MEM(unsigned, EA, 2);
    *rA = EA;
    PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK, 0);
  }
#line 23948 "semantics.c"
  return nia;
  /* extraction: 0.41,6.RT,11.RA,16.D #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 23959 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Halfword_Algebraic(cpu *processor,
                                 idecode_cache *cache_entry,
                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_Algebraic
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_Algebraic

  /* extraction: 0.42,6.RT,11.RA,16.D #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 23984 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 1831 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Halfword Algebraic\n"));
#line 23990 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Halfword_Algebraic, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1831 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    *rT = MEM(signed, EA, 2);
    PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 24009 "semantics.c"
  return nia;
  /* extraction: 0.42,6.RT,11.RA,16.D #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24020 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Halfword_Algebraic_with_Update(cpu *processor,
                                             idecode_cache *cache_entry,
                                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_Algebraic_with_Update
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_Algebraic_with_Update

  /* extraction: 0.43,6.RT,11.RA,16.D #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24045 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 1857 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Halfword Algebraic with Update\n"));
#line 24051 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Halfword_Algebraic_with_Update, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 1857 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0 || RA == RT)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + EXTS(D);
    *rT = MEM(signed, EA, 2);
    *rA = EA;
    PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK, 0);
  }
#line 24071 "semantics.c"
  return nia;
  /* extraction: 0.43,6.RT,11.RA,16.D #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24082 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Half_Word(cpu *processor,
                         idecode_cache *cache_entry,
                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Half_Word
#undef MY_PREFIX
#define MY_PREFIX Store_Half_Word

  /* extraction: 0.44,6.RS,11.RA,16.D #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24107 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2058 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Half Word\n"));
#line 24113 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Half_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2058 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    STORE(EA, 2, *rS);
    PPC_INSN_INT(0, (RA_BITMASK & ~1) | RS_BITMASK, 0);
  }
#line 24132 "semantics.c"
  return nia;
  /* extraction: 0.44,6.RS,11.RA,16.D #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24143 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Half_Word_with_Update(cpu *processor,
                                     idecode_cache *cache_entry,
                                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Half_Word_with_Update
#undef MY_PREFIX
#define MY_PREFIX Store_Half_Word_with_Update

  /* extraction: 0.45,6.RS,11.RA,16.D #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24168 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2084 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Half Word with Update\n"));
#line 24174 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Half_Word_with_Update, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2084 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + EXTS(D);
    STORE(EA, 2, *rS);
    *rA = EA;
    PPC_INSN_INT(RA_BITMASK, RA_BITMASK | RS_BITMASK, 0);
  }
#line 24194 "semantics.c"
  return nia;
  /* extraction: 0.45,6.RS,11.RA,16.D #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24205 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_Multiple_Word(cpu *processor,
                            idecode_cache *cache_entry,
                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Multiple_Word
#undef MY_PREFIX
#define MY_PREFIX Load_Multiple_Word

  /* extraction: 0.46,6.RT,11.RA,16.D #define get-values-from-icache */
#define RT cache_entry->crack.D.RT /* in icache - extraction */
#define rT cache_entry->crack.D.rT /* in icache - extraction */
#define RT_BITMASK cache_entry->crack.D.RT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24230 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2255 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Multiple Word\n"));
#line 24236 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_Multiple_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2255 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    unsigned_word b;
    int r;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    r = RT;
    if (RA >= r)
      program_interrupt(processor, cia,
                      illegal_instruction_program_interrupt);
    if (CURRENT_ALIGNMENT == STRICT_ALIGNMENT || (EA % 4 != 0))
      alignment_interrupt(processor, cia, EA);
    while (r <= 31) {
      GPR(r) = MEM(unsigned, EA, 4);
      r = r + 1;
      EA = EA + 4;
    }
  }
#line 24265 "semantics.c"
  return nia;
  /* extraction: 0.46,6.RT,11.RA,16.D #undef get-values-from-icache */
#undef RT
#undef rT
#undef RT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24276 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_Multiple_Word(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Multiple_Word
#undef MY_PREFIX
#define MY_PREFIX Store_Multiple_Word

  /* extraction: 0.47,6.RS,11.RA,16.D #define get-values-from-icache */
#define RS cache_entry->crack.D.RS /* in icache - extraction */
#define rS cache_entry->crack.D.rS /* in icache - extraction */
#define RS_BITMASK cache_entry->crack.D.RS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24301 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 2274 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Multiple Word\n"));
#line 24307 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_Multiple_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 2274 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    unsigned_word b;
    int r;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    if (CURRENT_ALIGNMENT == STRICT_ALIGNMENT
        || (EA % 4 != 0))
      alignment_interrupt(processor, cia, EA);
    r = RS;
    while (r <= 31) {
      STORE(EA, 4, GPR(r));
      r = r + 1;
      EA = EA + 4;
    }
  }
#line 24334 "semantics.c"
  return nia;
  /* extraction: 0.47,6.RS,11.RA,16.D #undef get-values-from-icache */
#undef RS
#undef rS
#undef RS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24345 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_FloatingPoint_Single(cpu *processor,
                                   idecode_cache *cache_entry,
                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_FloatingPoint_Single
#undef MY_PREFIX
#define MY_PREFIX Load_FloatingPoint_Single

  /* extraction: 0.48,6.FRT,11.RA,16.D #define get-values-from-icache */
#define frT cache_entry->crack.D.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.D.FRT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24369 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 3464 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Floating-Point Single\n"));
#line 24375 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_FloatingPoint_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3464 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    *frT = DOUBLE(MEM(unsigned, EA, 4));
    PPC_INSN_INT_FLOAT(0, FRT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 24394 "semantics.c"
  return nia;
  /* extraction: 0.48,6.FRT,11.RA,16.D #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24404 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_FloatingPoint_Single_with_Update(cpu *processor,
                                               idecode_cache *cache_entry,
                                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_FloatingPoint_Single_with_Update
#undef MY_PREFIX
#define MY_PREFIX Load_FloatingPoint_Single_with_Update

  /* extraction: 0.49,6.FRT,11.RA,16.D #define get-values-from-icache */
#define frT cache_entry->crack.D.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.D.FRT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24428 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 3490 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Floating-Point Single with Update\n"));
#line 24434 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_FloatingPoint_Single_with_Update, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3490 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + EXTS(D);
    *frT = DOUBLE(MEM(unsigned, EA, 4));
    *rA = EA;
    PPC_INSN_INT_FLOAT(RA_BITMASK, FRT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 24454 "semantics.c"
  return nia;
  /* extraction: 0.49,6.FRT,11.RA,16.D #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24464 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_FloatingPoint_Double(cpu *processor,
                                   idecode_cache *cache_entry,
                                   unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_FloatingPoint_Double
#undef MY_PREFIX
#define MY_PREFIX Load_FloatingPoint_Double

  /* extraction: 0.50,6.FRT,11.RA,16.D #define get-values-from-icache */
#define frT cache_entry->crack.D.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.D.FRT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24488 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 3518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Floating-Point Double\n"));
#line 24494 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_FloatingPoint_Double, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3518 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    *frT = MEM(unsigned, EA, 8);
    PPC_INSN_INT_FLOAT(0, FRT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 24513 "semantics.c"
  return nia;
  /* extraction: 0.50,6.FRT,11.RA,16.D #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24523 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Load_FloatingPoint_Double_with_Update(cpu *processor,
                                               idecode_cache *cache_entry,
                                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_FloatingPoint_Double_with_Update
#undef MY_PREFIX
#define MY_PREFIX Load_FloatingPoint_Double_with_Update

  /* extraction: 0.51,6.FRT,11.RA,16.D #define get-values-from-icache */
#define frT cache_entry->crack.D.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.D.FRT_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24547 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 3544 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Load Floating-Point Double with Update\n"));
#line 24553 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Load_FloatingPoint_Double_with_Update, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3544 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + EXTS(D);
    *frT = MEM(unsigned, EA, 8);
    *rA = EA;
    PPC_INSN_INT_FLOAT(RA_BITMASK, FRT_BITMASK, (RA_BITMASK & ~1), 0);
  }
#line 24573 "semantics.c"
  return nia;
  /* extraction: 0.51,6.FRT,11.RA,16.D #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24583 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_FloatingPoint_Single(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_FloatingPoint_Single
#undef MY_PREFIX
#define MY_PREFIX Store_FloatingPoint_Single

  /* extraction: 0.52,6.FRS,11.RA,16.D #define get-values-from-icache */
#define frS cache_entry->crack.D.frS /* in icache - extraction */
#define FRS_BITMASK cache_entry->crack.D.FRS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24607 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 3577 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Floating-Point Single\n"));
#line 24613 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_FloatingPoint_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3577 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    STORE(EA, 4, SINGLE(*frS));
    PPC_INSN_INT_FLOAT(0, 0, (RA_BITMASK & ~1), FRS_BITMASK);
  }
#line 24632 "semantics.c"
  return nia;
  /* extraction: 0.52,6.FRS,11.RA,16.D #undef get-values-from-icache */
#undef frS
#undef FRS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24642 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_FloatingPoint_Single_with_Update(cpu *processor,
                                                idecode_cache *cache_entry,
                                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_FloatingPoint_Single_with_Update
#undef MY_PREFIX
#define MY_PREFIX Store_FloatingPoint_Single_with_Update

  /* extraction: 0.53,6.FRS,11.RA,16.D #define get-values-from-icache */
#define frS cache_entry->crack.D.frS /* in icache - extraction */
#define FRS_BITMASK cache_entry->crack.D.FRS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24666 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 3603 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Floating-Point Single with Update\n"));
#line 24672 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_FloatingPoint_Single_with_Update, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3603 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + EXTS(D);
    STORE(EA, 4, SINGLE(*frS));
    *rA = EA;
    PPC_INSN_INT_FLOAT(RA_BITMASK, 0, (RA_BITMASK & ~1), FRS_BITMASK);
  }
#line 24692 "semantics.c"
  return nia;
  /* extraction: 0.53,6.FRS,11.RA,16.D #undef get-values-from-icache */
#undef frS
#undef FRS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24702 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_FloatingPoint_Double(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_FloatingPoint_Double
#undef MY_PREFIX
#define MY_PREFIX Store_FloatingPoint_Double

  /* extraction: 0.54,6.FRS,11.RA,16.D #define get-values-from-icache */
#define frS cache_entry->crack.D.frS /* in icache - extraction */
#define FRS_BITMASK cache_entry->crack.D.FRS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24726 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 3631 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Floating-Point Double\n"));
#line 24732 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_FloatingPoint_Double, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3631 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word b;
    unsigned_word EA;
    if (RA_is_0) b = 0;
    else         b = *rA;
    EA = b + EXTS(D);
    STORE(EA, 8, *frS);
    PPC_INSN_INT_FLOAT(0, 0, (RA_BITMASK & ~1), FRS_BITMASK);
  }
#line 24751 "semantics.c"
  return nia;
  /* extraction: 0.54,6.FRS,11.RA,16.D #undef get-values-from-icache */
#undef frS
#undef FRS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24761 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Store_FloatingPoint_Double_with_Update(cpu *processor,
                                                idecode_cache *cache_entry,
                                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_FloatingPoint_Double_with_Update
#undef MY_PREFIX
#define MY_PREFIX Store_FloatingPoint_Double_with_Update

  /* extraction: 0.55,6.FRS,11.RA,16.D #define get-values-from-icache */
#define frS cache_entry->crack.D.frS /* in icache - extraction */
#define FRS_BITMASK cache_entry->crack.D.FRS_BITMASK /* in icache - extraction */
#define RA cache_entry->crack.D.RA /* in icache - extraction */
#define rA cache_entry->crack.D.rA /* in icache - extraction */
#define RA_BITMASK cache_entry->crack.D.RA_BITMASK /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#define EXTS_D cache_entry->crack.D.EXTS_D /* in icache - extraction */
#line 24785 "semantics.c"

#define insn cache_entry->crack.D.insn
  unsigned_word nia;
#line 3669 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Store Floating-Point Double with Update\n"));
#line 24791 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Store_FloatingPoint_Double_with_Update, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3669 "../../sim/ppc/powerpc.igen"
  {
    unsigned_word EA;
    if (RA_is_0)
      program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
    EA = *rA + EXTS(D);
    STORE(EA, 8, *frS);
    *rA = EA;
    PPC_INSN_INT_FLOAT(RA_BITMASK, 0, (RA_BITMASK & ~1), FRS_BITMASK);
  }
#line 24811 "semantics.c"
  return nia;
  /* extraction: 0.55,6.FRS,11.RA,16.D #undef get-values-from-icache */
#undef frS
#undef FRS_BITMASK
#undef RA
#undef rA
#undef RA_BITMASK
#undef RA_is_0
#undef EXTS_D
#line 24821 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Divide_Single_Rc0(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Divide_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Divide_Single_Rc0

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.18,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 24845 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3932 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Divide Single\n"));
#line 24851 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Divide_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3932 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxzdz,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    1); /*single-precision*/
    }
    else if (is_invalid_zero_divide (processor, cia,
                                     *frA, *frB,
                                     1 /*single?*/)) {
      invalid_zero_divide_operation (processor, cia,
                                     frT, *frA, *frB,
                                     1 /*single?*/);
    }
    else {
      /*HACK!*/
      float s = *(double*)frA / *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 24890 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.18,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 24900 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Divide_Single_Rc1(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Divide_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Divide_Single_Rc1

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.18,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 24924 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3932 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Divide Single\n"));
#line 24930 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Divide_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3932 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxzdz,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    1); /*single-precision*/
    }
    else if (is_invalid_zero_divide (processor, cia,
                                     *frA, *frB,
                                     1 /*single?*/)) {
      invalid_zero_divide_operation (processor, cia,
                                     frT, *frA, *frB,
                                     1 /*single?*/);
    }
    else {
      /*HACK!*/
      float s = *(double*)frA / *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 24969 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.18,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 24979 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Subtract_Single_Rc0(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Subtract_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Subtract_Single_Rc0

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.20,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 25003 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3821 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Subtract Single\n"));
#line 25009 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Subtract_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3821 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             1) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    1); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = *(double*)frA - *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 25041 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.20,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 25051 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Subtract_Single_Rc1(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Subtract_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Subtract_Single_Rc1

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.20,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 25075 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3821 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Subtract Single\n"));
#line 25081 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Subtract_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3821 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             1) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    1); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = *(double*)frA - *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 25113 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.20,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 25123 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Add_Single_Rc0(cpu *processor,
                                 idecode_cache *cache_entry,
                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Add_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Add_Single_Rc0

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.21,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 25147 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3769 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Add Single\n"));
#line 25153 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Add_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3769 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    1); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = *(double*)frA + *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 25185 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.21,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 25195 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Add_Single_Rc1(cpu *processor,
                                 idecode_cache *cache_entry,
                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Add_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Add_Single_Rc1

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.21,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 25219 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3769 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Add Single\n"));
#line 25225 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Add_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3769 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    1); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = *(double*)frA + *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 25257 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21./,26.21,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 25267 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Square_Root_Single_Rc0(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Square_Root_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Square_Root_Single_Rc0

  /* extraction: 0.59,6.FRT,11./,16.FRB,21./,26.22,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 25289 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4726 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Square Root Single\n"));
#line 25295 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Square_Root_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4726 "../../sim/ppc/powerpc.igen"
  {
    program_interrupt(processor, cia, optional_instruction_program_interrupt);
  }
#line 25308 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11./,16.FRB,21./,26.22,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 25316 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Square_Root_Single_Rc1(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Square_Root_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Square_Root_Single_Rc1

  /* extraction: 0.59,6.FRT,11./,16.FRB,21./,26.22,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 25338 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4726 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Square Root Single\n"));
#line 25344 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Square_Root_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4726 "../../sim/ppc/powerpc.igen"
  {
    program_interrupt(processor, cia, optional_instruction_program_interrupt);
  }
#line 25357 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11./,16.FRB,21./,26.22,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 25365 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Reciprocal_Estimate_Single_Rc0(cpu *processor,
                                                 idecode_cache *cache_entry,
                                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Reciprocal_Estimate_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Reciprocal_Estimate_Single_Rc0

  /* extraction: 0.59,6.FRT,11./,16.FRB,21./,26.24,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 25387 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4729 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Reciprocal Estimate Single\n"));
#line 25393 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Reciprocal_Estimate_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4729 "../../sim/ppc/powerpc.igen"
  {
    program_interrupt(processor, cia, optional_instruction_program_interrupt);
  }
#line 25406 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11./,16.FRB,21./,26.24,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 25414 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Reciprocal_Estimate_Single_Rc1(cpu *processor,
                                                 idecode_cache *cache_entry,
                                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Reciprocal_Estimate_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Reciprocal_Estimate_Single_Rc1

  /* extraction: 0.59,6.FRT,11./,16.FRB,21./,26.24,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 25436 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4729 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Reciprocal Estimate Single\n"));
#line 25442 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Reciprocal_Estimate_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4729 "../../sim/ppc/powerpc.igen"
  {
    program_interrupt(processor, cia, optional_instruction_program_interrupt);
  }
#line 25455 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11./,16.FRB,21./,26.24,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 25463 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Multiply_Single_Rc0(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Multiply_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Multiply_Single_Rc0

  /* extraction: 0.59,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 25487 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3873 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply Single\n"));
#line 25493 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Multiply_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3873 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    1); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = *(double*)frA * *(double*)frC;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRC_BITMASK, Rc);
  }
#line 25525 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 25535 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Multiply_Single_Rc1(cpu *processor,
                                      idecode_cache *cache_entry,
                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Multiply_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Multiply_Single_Rc1

  /* extraction: 0.59,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 25559 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3873 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply Single\n"));
#line 25565 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Multiply_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3873 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    1); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = *(double*)frA * *(double*)frC;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRC_BITMASK, Rc);
  }
#line 25597 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 25607 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplySubtract_Single_Rc0(cpu *processor,
                                              idecode_cache *cache_entry,
                                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplySubtract_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplySubtract_Single_Rc0

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 25633 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4106 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Subtract Single\n"));
#line 25639 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplySubtract_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4106 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    float product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             1, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = product - *(double*)frB;
      *(double*)frT = (double)s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 25692 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 25704 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplySubtract_Single_Rc1(cpu *processor,
                                              idecode_cache *cache_entry,
                                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplySubtract_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplySubtract_Single_Rc1

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 25730 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4106 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Subtract Single\n"));
#line 25736 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplySubtract_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4106 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    float product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             1, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = product - *(double*)frB;
      *(double*)frT = (double)s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 25789 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 25801 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplyAdd_Single_Rc0(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplyAdd_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplyAdd_Single_Rc0

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 25827 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4012 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Add Single\n"));
#line 25833 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplyAdd_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4012 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    float product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             1, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the add */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = product + *(double*)frB;
      *(double*)frT = (double)s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 25886 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 25898 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplyAdd_Single_Rc1(cpu *processor,
                                         idecode_cache *cache_entry,
                                         unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplyAdd_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplyAdd_Single_Rc1

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 25924 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4012 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Add Single\n"));
#line 25930 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplyAdd_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4012 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    float product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             1, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the add */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = product + *(double*)frB;
      *(double*)frT = (double)s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 25983 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 25995 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplySubtract_Single_Rc0(cpu *processor,
                                                       idecode_cache *cache_entry,
                                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplySubtract_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplySubtract_Single_Rc0

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 26021 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4294 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negative Multiply-Subtract Single\n"));
#line 26027 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negative_MultiplySubtract_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4294 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    float product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             1, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = -(product - *(double*)frB);
      *(double*)frT = (double)s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 26080 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 26092 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplySubtract_Single_Rc1(cpu *processor,
                                                       idecode_cache *cache_entry,
                                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplySubtract_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplySubtract_Single_Rc1

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 26118 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4294 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negative Multiply-Subtract Single\n"));
#line 26124 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negative_MultiplySubtract_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4294 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    float product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             1, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = -(product - *(double*)frB);
      *(double*)frT = (double)s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 26177 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 26189 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplyAdd_Single_Rc0(cpu *processor,
                                                  idecode_cache *cache_entry,
                                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplyAdd_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplyAdd_Single_Rc0

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.31,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 26215 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4200 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negative Multiply-Add Single\n"));
#line 26221 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negative_MultiplyAdd_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4200 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    float product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             1, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the add */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = -(product + *(double*)frB);
      *(double*)frT = (double)s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 26274 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.31,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 26286 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplyAdd_Single_Rc1(cpu *processor,
                                                  idecode_cache *cache_entry,
                                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplyAdd_Single
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplyAdd_Single_Rc1

  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.31,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 26312 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4200 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negative Multiply-Add Single\n"));
#line 26318 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negative_MultiplyAdd_Single, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4200 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    float product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             1, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the add */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             1, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      float s = -(product + *(double*)frB);
      *(double*)frT = (double)s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 26371 "semantics.c"
  return nia;
  /* extraction: 0.59,6.FRT,11.FRA,16.FRB,21.FRC,26.31,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 26383 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Compare_Unordered(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Compare_Unordered
#undef MY_PREFIX
#define MY_PREFIX Floating_Compare_Unordered

  /* extraction: 0.63,6.BF,9./,11.FRA,16.FRB,21.0,31./ #define get-values-from-icache */
#define BF cache_entry->crack.X.BF /* in icache - extraction */
#define BF_BITMASK cache_entry->crack.X.BF_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.X.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.X.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.X.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.X.FRB_BITMASK /* in icache - extraction */
#line 26406 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4621 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Compare Unordered\n"));
#line 26412 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Compare_Unordered, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4621 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    unsigned c;
    if (is_NaN(*frA, 0) || is_NaN(*frB, 0))
      c = cr_i_summary_overflow; /* 0b0001 - (FRA) ? (FRB) */
    else if (is_less_than(frA, frB))
      c = cr_i_negative; /* 0b1000 - (FRA) < (FRB) */
    else if (is_greater_than(frA, frB))
      c = cr_i_positive; /* 0b0100 - (FRA) > (FRB) */
    else
      c = cr_i_zero; /* 0b0010 - (FRA) = (FRB) */
    FPSCR_SET_FPCC(c);
    CR_SET(BF, c); /* CR[4*BF..4*BF+3] = c */
    if (is_SNaN(*frA, 0) || is_SNaN(*frB, 0))
      FPSCR_OR_VX(fpscr_vxsnan);
    FPSCR_END(0);
    PPC_INSN_FLOAT_CR(0, FRA_BITMASK | FRB_BITMASK, BF_BITMASK);
  }
#line 26440 "semantics.c"
  return nia;
  /* extraction: 0.63,6.BF,9./,11.FRA,16.FRB,21.0,31./ #undef get-values-from-icache */
#undef BF
#undef BF_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#line 26449 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Round_to_SinglePrecision_Rc0(cpu *processor,
                                               idecode_cache *cache_entry,
                                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Round_to_SinglePrecision
#undef MY_PREFIX
#define MY_PREFIX Floating_Round_to_SinglePrecision_Rc0

  /* extraction: 0.63,6.FRT,11./,16.FRB,21.12,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.X.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.X.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 26471 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4346 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Round to Single-Precision\n"));
#line 26477 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Round_to_SinglePrecision, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4346 "../../sim/ppc/powerpc.igen"
  {
    int sign;
    int exp;
    uint64_t frac_grx;
    /***/
      /* split off cases for what to do */
      if (EXTRACTED64(*frB, 1, 11) < 897
          && EXTRACTED64(*frB, 1, 63) > 0) {
          if ((FPSCR & fpscr_ue) == 0) GOTO(Disabled_Exponent_Underflow);
          if ((FPSCR & fpscr_ue) != 0) GOTO(Enabled_Exponent_Underflow);
      }
      if (EXTRACTED64(*frB, 1, 11) > 1150
          && EXTRACTED64(*frB, 1, 11) < 2047) {
          if ((FPSCR & fpscr_oe) == 0) GOTO(Disabled_Exponent_Overflow);
          if ((FPSCR & fpscr_oe) != 0) GOTO(Enabled_Exponent_Overflow);
      }
      if (EXTRACTED64(*frB, 1, 11) > 896
          && EXTRACTED64(*frB, 1, 11) < 1151) GOTO(Normal_Operand);
      if (EXTRACTED64(*frB, 1, 63) == 0) GOTO(Zero_Operand);
      if (EXTRACTED64(*frB, 1, 11) == 2047) {
        if (EXTRACTED64(*frB, 12, 63) == 0) GOTO(Infinity_Operand);
        if (EXTRACTED64(*frB, 12, 12) == 1) GOTO(QNaN_Operand);
        if (EXTRACTED64(*frB, 12, 12) == 0
            && EXTRACTED64(*frB, 13, 63) > 0) GOTO(SNaN_Operand);
      }
    /**/
    LABEL(Disabled_Exponent_Underflow):
      sign = EXTRACTED64(*frB, 0, 0);
      if (EXTRACTED64(*frB, 1, 11) == 0) {
        exp = -1022;
        frac_grx = INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52);
      }
      if (EXTRACTED64(*frB, 1, 11) > 0) {
        exp = EXTRACTED64(*frB, 1, 11) - 1023;
        frac_grx = BIT64(0) | INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52);
      }
        /* G|R|X == zero from above */
        while (exp < -126) {
          exp = exp + 1;
          frac_grx = (INSERTED64(EXTRACTED64(frac_grx, 0, 54), 1, 55)
                      | MASKED64(frac_grx, 55, 55));
        }
      FPSCR_SET_UX(EXTRACTED64(frac_grx, 24, 55) > 0);
      Round_Single(processor, sign, &exp, &frac_grx);
      FPSCR_SET_XX(FPSCR & fpscr_fi);
      if (EXTRACTED64(frac_grx, 0, 52) == 0) {
        *frT = INSERTED64(sign, 0, 0);
        if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_zero);
        if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_zero);
      }
      if (EXTRACTED64(frac_grx, 0, 52) > 0) {
        if (EXTRACTED64(frac_grx, 0, 0) == 1) {
          if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
          if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
        }
        if (EXTRACTED64(frac_grx, 0, 0) == 0) {
          if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_denormalized_number);
          if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_denormalized_number);
        }
        /*Normalize_Operand:*/
          while (EXTRACTED64(frac_grx, 0, 0) == 0) {
            exp = exp - 1;
            frac_grx = INSERTED64(EXTRACTED64(frac_grx, 1,  52), 0, 51);
          }
        *frT = (INSERTED64(sign, 0, 0)
                | INSERTED64(exp + 1023, 1, 11)
                | INSERTED64(EXTRACTED64(frac_grx, 1, 52), 12, 63));
      }
      GOTO(Done);
    /**/
    LABEL(Enabled_Exponent_Underflow):
      FPSCR_SET_UX(1);
      sign = EXTRACTED64(*frB, 0, 0);
      if (EXTRACTED64(*frB, 1, 11) == 0) {
        exp = -1022;
        frac_grx = INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52);
      }
      if (EXTRACTED64(*frB, 1, 11) > 0) {
        exp = EXTRACTED64(*frB, 1, 11) - 1023;
        frac_grx = (BIT64(0) |
                    INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52));
      }
      /*Normalize_Operand:*/
        while (EXTRACTED64(frac_grx, 0, 0) == 0) {
          exp = exp - 1;
          frac_grx = INSERTED64(EXTRACTED64(frac_grx, 1, 52), 0, 51);
        }
      Round_Single(processor, sign, &exp, &frac_grx);
      FPSCR_SET_XX(FPSCR & fpscr_fi);
      exp = exp + 192;
      *frT = (INSERTED64(sign, 0, 0)
              | INSERTED64(exp + 1023, 1, 11)
              | INSERTED64(EXTRACTED64(frac_grx, 1, 52), 12, 63));
      if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
      if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
      GOTO(Done);
    /**/
    LABEL(Disabled_Exponent_Overflow):
      FPSCR_SET_OX(1);
      if ((FPSCR & fpscr_rn) == fpscr_rn_round_to_nearest) {
        if (EXTRACTED64(*frB, 0, 0) == 0) {
          *frT = INSERTED64(0x7FF00000, 0, 31) | 0x00000000;
          FPSCR_SET_FPRF(fpscr_rf_pos_infinity);
        }
        if (EXTRACTED64(*frB, 0, 0) == 1) {
          *frT = INSERTED64(0xFFF00000, 0, 31) | 0x00000000;
          FPSCR_SET_FPRF(fpscr_rf_neg_infinity);
        }
      }
      if ((FPSCR & fpscr_rn) == fpscr_rn_round_towards_zero) {
        if (EXTRACTED64(*frB, 0, 0) == 0) {
          *frT = INSERTED64(0x47EFFFFF, 0, 31) | 0xE0000000;
          FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
        }
        if (EXTRACTED64(*frB, 0, 0) == 1) {
          *frT = INSERTED64(0xC7EFFFFF, 0, 31) | 0xE0000000;
          FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
        }
      }
      if ((FPSCR & fpscr_rn) == fpscr_rn_round_towards_pos_infinity) {
        if (EXTRACTED64(*frB, 0, 0) == 0) {
          *frT = INSERTED64(0x7FF00000, 0, 31) | 0x00000000;
          FPSCR_SET_FPRF(fpscr_rf_pos_infinity);
        }
        if (EXTRACTED64(*frB, 0, 0) == 1) {
          *frT = INSERTED64(0xC7EFFFFF, 0, 31) | 0xE0000000;
          FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
        }
      }
      if ((FPSCR & fpscr_rn) == fpscr_rn_round_towards_neg_infinity) {
        if (EXTRACTED64(*frB, 0, 0) == 0) {
          *frT = INSERTED64(0x47EFFFFF, 0, 31) | 0xE0000000;
          FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
        }
        if (EXTRACTED64(*frB, 0, 0) == 1) {
          *frT = INSERTED64(0xFFF00000, 0, 31) | 0x00000000;
          FPSCR_SET_FPRF(fpscr_rf_neg_infinity);
        }
      }
      /* FPSCR[FR] <- undefined */
      FPSCR_SET_FI(1);
      FPSCR_SET_XX(1);
      GOTO(Done);
    /**/
    LABEL(Enabled_Exponent_Overflow):
      sign = EXTRACTED64(*frB, 0, 0);
      exp = EXTRACTED64(*frB, 1, 11) - 1023;
      frac_grx = BIT64(0) | INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52);
      Round_Single(processor, sign, &exp, &frac_grx);
      FPSCR_SET_XX(FPSCR & fpscr_fi);
    /**/
    LABEL(Enabled_Overflow):
      FPSCR_SET_OX(1);
      exp = exp - 192;
      *frT = (INSERTED64(sign, 0, 0)
              | INSERTED64(exp + 1023, 1, 11)
              | INSERTED64(EXTRACTED64(frac_grx, 1, 52), 12, 63));
      if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
      if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
      GOTO(Done);
    /**/
    LABEL(Zero_Operand):
      *frT = *frB;
      if (EXTRACTED64(*frB, 0, 0) == 0) FPSCR_SET_FPRF(fpscr_rf_pos_zero);
      if (EXTRACTED64(*frB, 0, 0) == 1) FPSCR_SET_FPRF(fpscr_rf_neg_zero);
      FPSCR_SET_FR(0);
      FPSCR_SET_FI(0);
      GOTO(Done);
    /**/
    LABEL(Infinity_Operand):
      *frT = *frB;
      if (EXTRACTED64(*frB, 0, 0) == 0) FPSCR_SET_FPRF(fpscr_rf_pos_infinity);
      if (EXTRACTED64(*frB, 0, 0) == 1) FPSCR_SET_FPRF(fpscr_rf_neg_infinity);
      FPSCR_SET_FR(0);
      FPSCR_SET_FI(0);
      GOTO(Done);
    /**/
    LABEL(QNaN_Operand):
      *frT = INSERTED64(EXTRACTED64(*frB, 0, 34), 0, 34);
      FPSCR_SET_FPRF(fpscr_rf_quiet_nan);
      FPSCR_SET_FR(0);
      FPSCR_SET_FI(0);
      GOTO(Done);
    /**/
    LABEL(SNaN_Operand):
      FPSCR_OR_VX(fpscr_vxsnan);
      if ((FPSCR & fpscr_ve) == 0) {
        *frT = (MASKED64(*frB, 0, 11)
                | BIT64(12)
                | MASKED64(*frB, 13, 34));
        FPSCR_SET_FPRF(fpscr_rf_quiet_nan);
      }
      FPSCR_SET_FR(0);
      FPSCR_SET_FI(0);
      GOTO(Done);
    /**/
    LABEL(Normal_Operand):
      sign = EXTRACTED64(*frB, 0, 0);
      exp = EXTRACTED64(*frB, 1, 11) - 1023;
      frac_grx = BIT64(0) | INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52);
      Round_Single(processor, sign, &exp, &frac_grx);
      FPSCR_SET_XX(FPSCR & fpscr_fi);
      if (exp > 127 && (FPSCR & fpscr_oe) == 0) GOTO(Disabled_Exponent_Overflow);
      if (exp > 127 && (FPSCR & fpscr_oe) != 0) GOTO(Enabled_Overflow);
      *frT = (INSERTED64(sign, 0, 0)
              | INSERTED64(exp + 1023, 1, 11)
              | INSERTED64(EXTRACTED64(frac_grx, 1, 52), 12, 63));
      if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
      if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
      GOTO(Done);
    /**/
    LABEL(Done):
      PPC_INSN_FLOAT(FRT_BITMASK, FRB_BITMASK, Rc);
  }
#line 26701 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21.12,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 26709 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Round_to_SinglePrecision_Rc1(cpu *processor,
                                               idecode_cache *cache_entry,
                                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Round_to_SinglePrecision
#undef MY_PREFIX
#define MY_PREFIX Floating_Round_to_SinglePrecision_Rc1

  /* extraction: 0.63,6.FRT,11./,16.FRB,21.12,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.X.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.X.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 26731 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4346 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Round to Single-Precision\n"));
#line 26737 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Round_to_SinglePrecision, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4346 "../../sim/ppc/powerpc.igen"
  {
    int sign;
    int exp;
    uint64_t frac_grx;
    /***/
      /* split off cases for what to do */
      if (EXTRACTED64(*frB, 1, 11) < 897
          && EXTRACTED64(*frB, 1, 63) > 0) {
          if ((FPSCR & fpscr_ue) == 0) GOTO(Disabled_Exponent_Underflow);
          if ((FPSCR & fpscr_ue) != 0) GOTO(Enabled_Exponent_Underflow);
      }
      if (EXTRACTED64(*frB, 1, 11) > 1150
          && EXTRACTED64(*frB, 1, 11) < 2047) {
          if ((FPSCR & fpscr_oe) == 0) GOTO(Disabled_Exponent_Overflow);
          if ((FPSCR & fpscr_oe) != 0) GOTO(Enabled_Exponent_Overflow);
      }
      if (EXTRACTED64(*frB, 1, 11) > 896
          && EXTRACTED64(*frB, 1, 11) < 1151) GOTO(Normal_Operand);
      if (EXTRACTED64(*frB, 1, 63) == 0) GOTO(Zero_Operand);
      if (EXTRACTED64(*frB, 1, 11) == 2047) {
        if (EXTRACTED64(*frB, 12, 63) == 0) GOTO(Infinity_Operand);
        if (EXTRACTED64(*frB, 12, 12) == 1) GOTO(QNaN_Operand);
        if (EXTRACTED64(*frB, 12, 12) == 0
            && EXTRACTED64(*frB, 13, 63) > 0) GOTO(SNaN_Operand);
      }
    /**/
    LABEL(Disabled_Exponent_Underflow):
      sign = EXTRACTED64(*frB, 0, 0);
      if (EXTRACTED64(*frB, 1, 11) == 0) {
        exp = -1022;
        frac_grx = INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52);
      }
      if (EXTRACTED64(*frB, 1, 11) > 0) {
        exp = EXTRACTED64(*frB, 1, 11) - 1023;
        frac_grx = BIT64(0) | INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52);
      }
        /* G|R|X == zero from above */
        while (exp < -126) {
          exp = exp + 1;
          frac_grx = (INSERTED64(EXTRACTED64(frac_grx, 0, 54), 1, 55)
                      | MASKED64(frac_grx, 55, 55));
        }
      FPSCR_SET_UX(EXTRACTED64(frac_grx, 24, 55) > 0);
      Round_Single(processor, sign, &exp, &frac_grx);
      FPSCR_SET_XX(FPSCR & fpscr_fi);
      if (EXTRACTED64(frac_grx, 0, 52) == 0) {
        *frT = INSERTED64(sign, 0, 0);
        if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_zero);
        if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_zero);
      }
      if (EXTRACTED64(frac_grx, 0, 52) > 0) {
        if (EXTRACTED64(frac_grx, 0, 0) == 1) {
          if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
          if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
        }
        if (EXTRACTED64(frac_grx, 0, 0) == 0) {
          if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_denormalized_number);
          if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_denormalized_number);
        }
        /*Normalize_Operand:*/
          while (EXTRACTED64(frac_grx, 0, 0) == 0) {
            exp = exp - 1;
            frac_grx = INSERTED64(EXTRACTED64(frac_grx, 1,  52), 0, 51);
          }
        *frT = (INSERTED64(sign, 0, 0)
                | INSERTED64(exp + 1023, 1, 11)
                | INSERTED64(EXTRACTED64(frac_grx, 1, 52), 12, 63));
      }
      GOTO(Done);
    /**/
    LABEL(Enabled_Exponent_Underflow):
      FPSCR_SET_UX(1);
      sign = EXTRACTED64(*frB, 0, 0);
      if (EXTRACTED64(*frB, 1, 11) == 0) {
        exp = -1022;
        frac_grx = INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52);
      }
      if (EXTRACTED64(*frB, 1, 11) > 0) {
        exp = EXTRACTED64(*frB, 1, 11) - 1023;
        frac_grx = (BIT64(0) |
                    INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52));
      }
      /*Normalize_Operand:*/
        while (EXTRACTED64(frac_grx, 0, 0) == 0) {
          exp = exp - 1;
          frac_grx = INSERTED64(EXTRACTED64(frac_grx, 1, 52), 0, 51);
        }
      Round_Single(processor, sign, &exp, &frac_grx);
      FPSCR_SET_XX(FPSCR & fpscr_fi);
      exp = exp + 192;
      *frT = (INSERTED64(sign, 0, 0)
              | INSERTED64(exp + 1023, 1, 11)
              | INSERTED64(EXTRACTED64(frac_grx, 1, 52), 12, 63));
      if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
      if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
      GOTO(Done);
    /**/
    LABEL(Disabled_Exponent_Overflow):
      FPSCR_SET_OX(1);
      if ((FPSCR & fpscr_rn) == fpscr_rn_round_to_nearest) {
        if (EXTRACTED64(*frB, 0, 0) == 0) {
          *frT = INSERTED64(0x7FF00000, 0, 31) | 0x00000000;
          FPSCR_SET_FPRF(fpscr_rf_pos_infinity);
        }
        if (EXTRACTED64(*frB, 0, 0) == 1) {
          *frT = INSERTED64(0xFFF00000, 0, 31) | 0x00000000;
          FPSCR_SET_FPRF(fpscr_rf_neg_infinity);
        }
      }
      if ((FPSCR & fpscr_rn) == fpscr_rn_round_towards_zero) {
        if (EXTRACTED64(*frB, 0, 0) == 0) {
          *frT = INSERTED64(0x47EFFFFF, 0, 31) | 0xE0000000;
          FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
        }
        if (EXTRACTED64(*frB, 0, 0) == 1) {
          *frT = INSERTED64(0xC7EFFFFF, 0, 31) | 0xE0000000;
          FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
        }
      }
      if ((FPSCR & fpscr_rn) == fpscr_rn_round_towards_pos_infinity) {
        if (EXTRACTED64(*frB, 0, 0) == 0) {
          *frT = INSERTED64(0x7FF00000, 0, 31) | 0x00000000;
          FPSCR_SET_FPRF(fpscr_rf_pos_infinity);
        }
        if (EXTRACTED64(*frB, 0, 0) == 1) {
          *frT = INSERTED64(0xC7EFFFFF, 0, 31) | 0xE0000000;
          FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
        }
      }
      if ((FPSCR & fpscr_rn) == fpscr_rn_round_towards_neg_infinity) {
        if (EXTRACTED64(*frB, 0, 0) == 0) {
          *frT = INSERTED64(0x47EFFFFF, 0, 31) | 0xE0000000;
          FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
        }
        if (EXTRACTED64(*frB, 0, 0) == 1) {
          *frT = INSERTED64(0xFFF00000, 0, 31) | 0x00000000;
          FPSCR_SET_FPRF(fpscr_rf_neg_infinity);
        }
      }
      /* FPSCR[FR] <- undefined */
      FPSCR_SET_FI(1);
      FPSCR_SET_XX(1);
      GOTO(Done);
    /**/
    LABEL(Enabled_Exponent_Overflow):
      sign = EXTRACTED64(*frB, 0, 0);
      exp = EXTRACTED64(*frB, 1, 11) - 1023;
      frac_grx = BIT64(0) | INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52);
      Round_Single(processor, sign, &exp, &frac_grx);
      FPSCR_SET_XX(FPSCR & fpscr_fi);
    /**/
    LABEL(Enabled_Overflow):
      FPSCR_SET_OX(1);
      exp = exp - 192;
      *frT = (INSERTED64(sign, 0, 0)
              | INSERTED64(exp + 1023, 1, 11)
              | INSERTED64(EXTRACTED64(frac_grx, 1, 52), 12, 63));
      if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
      if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
      GOTO(Done);
    /**/
    LABEL(Zero_Operand):
      *frT = *frB;
      if (EXTRACTED64(*frB, 0, 0) == 0) FPSCR_SET_FPRF(fpscr_rf_pos_zero);
      if (EXTRACTED64(*frB, 0, 0) == 1) FPSCR_SET_FPRF(fpscr_rf_neg_zero);
      FPSCR_SET_FR(0);
      FPSCR_SET_FI(0);
      GOTO(Done);
    /**/
    LABEL(Infinity_Operand):
      *frT = *frB;
      if (EXTRACTED64(*frB, 0, 0) == 0) FPSCR_SET_FPRF(fpscr_rf_pos_infinity);
      if (EXTRACTED64(*frB, 0, 0) == 1) FPSCR_SET_FPRF(fpscr_rf_neg_infinity);
      FPSCR_SET_FR(0);
      FPSCR_SET_FI(0);
      GOTO(Done);
    /**/
    LABEL(QNaN_Operand):
      *frT = INSERTED64(EXTRACTED64(*frB, 0, 34), 0, 34);
      FPSCR_SET_FPRF(fpscr_rf_quiet_nan);
      FPSCR_SET_FR(0);
      FPSCR_SET_FI(0);
      GOTO(Done);
    /**/
    LABEL(SNaN_Operand):
      FPSCR_OR_VX(fpscr_vxsnan);
      if ((FPSCR & fpscr_ve) == 0) {
        *frT = (MASKED64(*frB, 0, 11)
                | BIT64(12)
                | MASKED64(*frB, 13, 34));
        FPSCR_SET_FPRF(fpscr_rf_quiet_nan);
      }
      FPSCR_SET_FR(0);
      FPSCR_SET_FI(0);
      GOTO(Done);
    /**/
    LABEL(Normal_Operand):
      sign = EXTRACTED64(*frB, 0, 0);
      exp = EXTRACTED64(*frB, 1, 11) - 1023;
      frac_grx = BIT64(0) | INSERTED64(EXTRACTED64(*frB, 12, 63), 1, 52);
      Round_Single(processor, sign, &exp, &frac_grx);
      FPSCR_SET_XX(FPSCR & fpscr_fi);
      if (exp > 127 && (FPSCR & fpscr_oe) == 0) GOTO(Disabled_Exponent_Overflow);
      if (exp > 127 && (FPSCR & fpscr_oe) != 0) GOTO(Enabled_Overflow);
      *frT = (INSERTED64(sign, 0, 0)
              | INSERTED64(exp + 1023, 1, 11)
              | INSERTED64(EXTRACTED64(frac_grx, 1, 52), 12, 63));
      if (sign == 0) FPSCR_SET_FPRF(fpscr_rf_pos_normal_number);
      if (sign == 1) FPSCR_SET_FPRF(fpscr_rf_neg_normal_number);
      GOTO(Done);
    /**/
    LABEL(Done):
      PPC_INSN_FLOAT(FRT_BITMASK, FRB_BITMASK, Rc);
  }
#line 26961 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21.12,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 26969 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Convert_To_Integer_Word_Rc0(cpu *processor,
                                              idecode_cache *cache_entry,
                                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Convert_To_Integer_Word
#undef MY_PREFIX
#define MY_PREFIX Floating_Convert_To_Integer_Word_Rc0

  /* extraction: 0.63,6.FRT,11./,16.FRB,21.14,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.X.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.X.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 26991 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4567 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Convert To Integer Word\n"));
#line 26997 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Convert_To_Integer_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4567 "../../sim/ppc/powerpc.igen"
  {
    floating_point_assist_interrupt(processor, cia);
  }
#line 27010 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21.14,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27018 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Convert_To_Integer_Word_Rc1(cpu *processor,
                                              idecode_cache *cache_entry,
                                              unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Convert_To_Integer_Word
#undef MY_PREFIX
#define MY_PREFIX Floating_Convert_To_Integer_Word_Rc1

  /* extraction: 0.63,6.FRT,11./,16.FRB,21.14,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.X.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.X.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 27040 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4567 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Convert To Integer Word\n"));
#line 27046 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Convert_To_Integer_Word, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4567 "../../sim/ppc/powerpc.igen"
  {
    floating_point_assist_interrupt(processor, cia);
  }
#line 27059 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21.14,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27067 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Convert_To_Integer_Word_with_round_towards_Zero_Rc0(cpu *processor,
                                                                      idecode_cache *cache_entry,
                                                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Convert_To_Integer_Word_with_round_towards_Zero
#undef MY_PREFIX
#define MY_PREFIX Floating_Convert_To_Integer_Word_with_round_towards_Zero_Rc0

  /* extraction: 0.63,6.FRT,11./,16.FRB,21.15,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.X.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.X.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 27089 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4574 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Convert To Integer Word with round towards Zero\n"));
#line 27095 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Convert_To_Integer_Word_with_round_towards_Zero, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4574 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    convert_to_integer(processor, cia,
                       frT, *frB,
                       fpscr_rn_round_towards_zero, 32);
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRB_BITMASK, Rc);
  }
#line 27113 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21.15,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27121 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Convert_To_Integer_Word_with_round_towards_Zero_Rc1(cpu *processor,
                                                                      idecode_cache *cache_entry,
                                                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Convert_To_Integer_Word_with_round_towards_Zero
#undef MY_PREFIX
#define MY_PREFIX Floating_Convert_To_Integer_Word_with_round_towards_Zero_Rc1

  /* extraction: 0.63,6.FRT,11./,16.FRB,21.15,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.X.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.X.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 27143 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4574 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Convert To Integer Word with round towards Zero\n"));
#line 27149 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Convert_To_Integer_Word_with_round_towards_Zero, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4574 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    convert_to_integer(processor, cia,
                       frT, *frB,
                       fpscr_rn_round_towards_zero, 32);
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRB_BITMASK, Rc);
  }
#line 27167 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21.15,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27175 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Divide_Rc0(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Divide
#undef MY_PREFIX
#define MY_PREFIX Floating_Divide_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.18,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 27199 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3899 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Divide\n"));
#line 27205 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Divide, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3899 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxzdz,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else if (is_invalid_zero_divide (processor, cia,
                                     *frA, *frB,
                                     0 /*single?*/)) {
      invalid_zero_divide_operation (processor, cia,
                                     frT, *frA, *frB,
                                     0 /*single?*/);
    }
    else {
      /*HACK!*/
      double s = *(double*)frA / *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 27244 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.18,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27254 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Divide_Rc1(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Divide
#undef MY_PREFIX
#define MY_PREFIX Floating_Divide_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.18,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 27278 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3899 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Divide\n"));
#line 27284 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Divide, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3899 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxzdz,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else if (is_invalid_zero_divide (processor, cia,
                                     *frA, *frB,
                                     0 /*single?*/)) {
      invalid_zero_divide_operation (processor, cia,
                                     frT, *frA, *frB,
                                     0 /*single?*/);
    }
    else {
      /*HACK!*/
      double s = *(double*)frA / *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 27323 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.18,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27333 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Subtract_Rc0(cpu *processor,
                               idecode_cache *cache_entry,
                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Subtract
#undef MY_PREFIX
#define MY_PREFIX Floating_Subtract_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.20,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 27357 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3795 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Subtract\n"));
#line 27363 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Subtract, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3795 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             1) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = *(double*)frA - *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 27395 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.20,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27405 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Subtract_Rc1(cpu *processor,
                               idecode_cache *cache_entry,
                               unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Subtract
#undef MY_PREFIX
#define MY_PREFIX Floating_Subtract_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.20,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 27429 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3795 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Subtract\n"));
#line 27435 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Subtract, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3795 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             1) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = *(double*)frA - *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 27467 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.20,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27477 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Add_Rc0(cpu *processor,
                          idecode_cache *cache_entry,
                          unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Add
#undef MY_PREFIX
#define MY_PREFIX Floating_Add_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.21,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 27501 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3743 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Add\n"));
#line 27507 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Add, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3743 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = *(double*)frA + *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 27539 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.21,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27549 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Add_Rc1(cpu *processor,
                          idecode_cache *cache_entry,
                          unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Add
#undef MY_PREFIX
#define MY_PREFIX Floating_Add_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.21,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 27573 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3743 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Add\n"));
#line 27579 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Add, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3743 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = *(double*)frA + *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK, Rc);
  }
#line 27611 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21./,26.21,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27621 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Square_Root_Rc0(cpu *processor,
                                  idecode_cache *cache_entry,
                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Square_Root
#undef MY_PREFIX
#define MY_PREFIX Floating_Square_Root_Rc0

  /* extraction: 0.63,6.FRT,11./,16.FRB,21./,26.22,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 27643 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4723 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Square Root\n"));
#line 27649 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Square_Root, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4723 "../../sim/ppc/powerpc.igen"
  {
    program_interrupt(processor, cia, optional_instruction_program_interrupt);
  }
#line 27662 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21./,26.22,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27670 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Square_Root_Rc1(cpu *processor,
                                  idecode_cache *cache_entry,
                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Square_Root
#undef MY_PREFIX
#define MY_PREFIX Floating_Square_Root_Rc1

  /* extraction: 0.63,6.FRT,11./,16.FRB,21./,26.22,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 27692 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4723 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Square Root\n"));
#line 27698 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Square_Root, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4723 "../../sim/ppc/powerpc.igen"
  {
    program_interrupt(processor, cia, optional_instruction_program_interrupt);
  }
#line 27711 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21./,26.22,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 27719 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Select_FRC0_Rc0(cpu *processor,
                                  idecode_cache *cache_entry,
                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Select
#undef MY_PREFIX
#define MY_PREFIX Floating_Select_FRC0_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.23,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 27745 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4743 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Select\n"));
#line 27751 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Select, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4743 "../../sim/ppc/powerpc.igen"
  {
    if (CURRENT_MODEL == MODEL_ppc601) {
      program_interrupt(processor, cia, optional_instruction_program_interrupt);
    } else {
      uint64_t zero = 0;
      FPSCR_BEGIN;
      if (is_NaN(*frA, 0) || is_less_than (frA, &zero)) *frT = *frB;
      else						    *frT = *frC;
      FPSCR_END(Rc);
      PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
    }
  }
#line 27773 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.23,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 27785 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Select_FRC0_Rc1(cpu *processor,
                                  idecode_cache *cache_entry,
                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Select
#undef MY_PREFIX
#define MY_PREFIX Floating_Select_FRC0_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.23,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 27811 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4743 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Select\n"));
#line 27817 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Select, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4743 "../../sim/ppc/powerpc.igen"
  {
    if (CURRENT_MODEL == MODEL_ppc601) {
      program_interrupt(processor, cia, optional_instruction_program_interrupt);
    } else {
      uint64_t zero = 0;
      FPSCR_BEGIN;
      if (is_NaN(*frA, 0) || is_less_than (frA, &zero)) *frT = *frB;
      else						    *frT = *frC;
      FPSCR_END(Rc);
      PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
    }
  }
#line 27839 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.23,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 27851 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Multiply_FRC0_Rc0(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Multiply
#undef MY_PREFIX
#define MY_PREFIX Floating_Multiply_FRC0_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 27875 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3847 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply\n"));
#line 27881 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Multiply, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3847 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = *(double*)frA * *(double*)frC;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRC_BITMASK, Rc);
  }
#line 27913 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 27923 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Multiply_FRC0_Rc1(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Multiply
#undef MY_PREFIX
#define MY_PREFIX Floating_Multiply_FRC0_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 27947 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3847 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply\n"));
#line 27953 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Multiply, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3847 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = *(double*)frA * *(double*)frC;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRC_BITMASK, Rc);
  }
#line 27985 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 27995 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Reciprocal_Square_Root_Estimate_Rc0(cpu *processor,
                                                      idecode_cache *cache_entry,
                                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Reciprocal_Square_Root_Estimate
#undef MY_PREFIX
#define MY_PREFIX Floating_Reciprocal_Square_Root_Estimate_Rc0

  /* extraction: 0.63,6.FRT,11./,16.FRB,21./,26.26,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 28017 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4732 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Reciprocal Square Root Estimate\n"));
#line 28023 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Reciprocal_Square_Root_Estimate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4732 "../../sim/ppc/powerpc.igen"
  {
    program_interrupt(processor, cia, optional_instruction_program_interrupt);
  }
#line 28036 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21./,26.26,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 28044 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Reciprocal_Square_Root_Estimate_Rc1(cpu *processor,
                                                      idecode_cache *cache_entry,
                                                      unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Reciprocal_Square_Root_Estimate
#undef MY_PREFIX
#define MY_PREFIX Floating_Reciprocal_Square_Root_Estimate_Rc1

  /* extraction: 0.63,6.FRT,11./,16.FRB,21./,26.26,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 28066 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4732 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Reciprocal Square Root Estimate\n"));
#line 28072 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Reciprocal_Square_Root_Estimate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4732 "../../sim/ppc/powerpc.igen"
  {
    program_interrupt(processor, cia, optional_instruction_program_interrupt);
  }
#line 28085 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21./,26.26,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 28093 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplySubtract_FRC0_Rc0(cpu *processor,
                                            idecode_cache *cache_entry,
                                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplySubtract
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplySubtract_FRC0_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 28119 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4059 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Subtract\n"));
#line 28125 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplySubtract, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4059 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = product - *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 28178 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 28190 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplySubtract_FRC0_Rc1(cpu *processor,
                                            idecode_cache *cache_entry,
                                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplySubtract
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplySubtract_FRC0_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 28216 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4059 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Subtract\n"));
#line 28222 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplySubtract, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4059 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = product - *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 28275 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 28287 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplyAdd_FRC0_Rc0(cpu *processor,
                                       idecode_cache *cache_entry,
                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplyAdd
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplyAdd_FRC0_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 28313 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3965 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Add\n"));
#line 28319 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplyAdd, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3965 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the add */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = product + *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 28372 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 28384 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplyAdd_FRC0_Rc1(cpu *processor,
                                       idecode_cache *cache_entry,
                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplyAdd
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplyAdd_FRC0_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 28410 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3965 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Add\n"));
#line 28416 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplyAdd, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3965 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the add */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = product + *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 28469 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 28481 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplySubtract_FRC0_Rc0(cpu *processor,
                                                     idecode_cache *cache_entry,
                                                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplySubtract
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplySubtract_FRC0_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 28507 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4247 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negative Multiply-Subtract\n"));
#line 28513 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negative_MultiplySubtract, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4247 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = -(product - *(double*)frB);
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 28566 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 28578 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplySubtract_FRC0_Rc1(cpu *processor,
                                                     idecode_cache *cache_entry,
                                                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplySubtract
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplySubtract_FRC0_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 28604 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4247 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negative Multiply-Subtract\n"));
#line 28610 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negative_MultiplySubtract, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4247 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = -(product - *(double*)frB);
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 28663 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 28675 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplyAdd_FRC0_Rc0(cpu *processor,
                                                idecode_cache *cache_entry,
                                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplyAdd
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplyAdd_FRC0_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.31,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 28701 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4153 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negative Multiply-Add\n"));
#line 28707 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negative_MultiplyAdd, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4153 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the add */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = -(product + *(double*)frB);
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 28760 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.31,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 28772 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplyAdd_FRC0_Rc1(cpu *processor,
                                                idecode_cache *cache_entry,
                                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplyAdd
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplyAdd_FRC0_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.31,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 28798 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4153 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negative Multiply-Add\n"));
#line 28804 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negative_MultiplyAdd, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4153 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the add */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = -(product + *(double*)frB);
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 28857 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.31,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 28869 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Compare_Ordered(cpu *processor,
                                  idecode_cache *cache_entry,
                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Compare_Ordered
#undef MY_PREFIX
#define MY_PREFIX Floating_Compare_Ordered

  /* extraction: 0.63,6.BF,9./,11.FRA,16.FRB,21.32,31./ #define get-values-from-icache */
#define BF cache_entry->crack.X.BF /* in icache - extraction */
#define BF_BITMASK cache_entry->crack.X.BF_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.X.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.X.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.X.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.X.FRB_BITMASK /* in icache - extraction */
#line 28892 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4643 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Compare Ordered\n"));
#line 28898 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Compare_Ordered, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4643 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    unsigned c;
    if (is_NaN(*frA, 0) || is_NaN(*frB, 0))
      c = cr_i_summary_overflow; /* 0b0001 - (FRA) ? (FRB) */
    else if (is_less_than(frA, frB))
      c = cr_i_negative; /* 0b1000 - (FRA) < (FRB) */
    else if (is_greater_than(frA, frB))
      c = cr_i_positive; /* 0b0100 - (FRA) > (FRB) */
    else
      c = cr_i_zero; /* 0b0010 - (FRA) = (FRB) */
    FPSCR_SET_FPCC(c);
    CR_SET(BF, c); /* CR[4*BF..4*BF+3] = c */
    if (is_SNaN(*frA, 0) || is_SNaN(*frB, 0)) {
      FPSCR_OR_VX(fpscr_vxsnan);
      if ((FPSCR & fpscr_ve) == 0)
        FPSCR_OR_VX(fpscr_vxvc);
    }
    else if (is_QNaN(*frA, 0) || is_QNaN(*frB, 0)) {
      FPSCR_OR_VX(fpscr_vxvc);
    }
    FPSCR_END(0);
    PPC_INSN_FLOAT_CR(0, FRA_BITMASK | FRB_BITMASK, BF_BITMASK);
  }
#line 28932 "semantics.c"
  return nia;
  /* extraction: 0.63,6.BF,9./,11.FRA,16.FRB,21.32,31./ #undef get-values-from-icache */
#undef BF
#undef BF_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#line 28941 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_To_FPSCR_Bit_1_Rc0(cpu *processor,
                                 idecode_cache *cache_entry,
                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_To_FPSCR_Bit_1
#undef MY_PREFIX
#define MY_PREFIX Move_To_FPSCR_Bit_1_Rc0

  /* extraction: 0.63,6.BT,11./,16./,21.38,31.Rc #define get-values-from-icache */
#define BT cache_entry->crack.X.BT /* in icache - extraction */
#define BT_BITMASK cache_entry->crack.X.BT_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 28961 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4706 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move To FPSCR Bit 1\n"));
#line 28967 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_To_FPSCR_Bit_1, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4706 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    uint32_t bit = BIT32(BT);
    if (bit & fpscr_fi)
      bit |= fpscr_xx;
    if ((bit & fpscr_vx_bits))
      bit |= fpscr_fx;
    /* note - omit vx bit */
    if ((bit & (fpscr_ox | fpscr_ux | fpscr_zx | fpscr_xx)))
      bit |= fpscr_fx;
    FPSCR |= bit;
    FPSCR_END(Rc);
  }
#line 28990 "semantics.c"
  return nia;
  /* extraction: 0.63,6.BT,11./,16./,21.38,31.Rc #undef get-values-from-icache */
#undef BT
#undef BT_BITMASK
#undef Rc
#line 28996 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Move_To_FPSCR_Bit_1_Rc1(cpu *processor,
                                 idecode_cache *cache_entry,
                                 unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_To_FPSCR_Bit_1
#undef MY_PREFIX
#define MY_PREFIX Move_To_FPSCR_Bit_1_Rc1

  /* extraction: 0.63,6.BT,11./,16./,21.38,31.Rc #define get-values-from-icache */
#define BT cache_entry->crack.X.BT /* in icache - extraction */
#define BT_BITMASK cache_entry->crack.X.BT_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 29016 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 4706 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Move To FPSCR Bit 1\n"));
#line 29022 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Move_To_FPSCR_Bit_1, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4706 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    uint32_t bit = BIT32(BT);
    if (bit & fpscr_fi)
      bit |= fpscr_xx;
    if ((bit & fpscr_vx_bits))
      bit |= fpscr_fx;
    /* note - omit vx bit */
    if ((bit & (fpscr_ox | fpscr_ux | fpscr_zx | fpscr_xx)))
      bit |= fpscr_fx;
    FPSCR |= bit;
    FPSCR_END(Rc);
  }
#line 29045 "semantics.c"
  return nia;
  /* extraction: 0.63,6.BT,11./,16./,21.38,31.Rc #undef get-values-from-icache */
#undef BT
#undef BT_BITMASK
#undef Rc
#line 29051 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negate_Rc0(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negate
#undef MY_PREFIX
#define MY_PREFIX Floating_Negate_Rc0

  /* extraction: 0.63,6.FRT,11./,16.FRB,21.40,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.X.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.X.FRB_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 29073 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3711 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negate\n"));
#line 29079 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3711 "../../sim/ppc/powerpc.igen"
  {
    *frT = *frB ^ BIT64(0);
    CR1_UPDATE(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRB_BITMASK, Rc);
  }
#line 29094 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21.40,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 29102 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negate_Rc1(cpu *processor,
                             idecode_cache *cache_entry,
                             unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negate
#undef MY_PREFIX
#define MY_PREFIX Floating_Negate_Rc1

  /* extraction: 0.63,6.FRT,11./,16.FRB,21.40,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.X.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.X.FRT_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.X.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.X.FRB_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 29124 "semantics.c"

#define insn cache_entry->crack.X.insn
  unsigned_word nia;
#line 3711 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negate\n"));
#line 29130 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negate, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3711 "../../sim/ppc/powerpc.igen"
  {
    *frT = *frB ^ BIT64(0);
    CR1_UPDATE(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRB_BITMASK, Rc);
  }
#line 29145 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11./,16.FRB,21.40,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frB
#undef FRB_BITMASK
#undef Rc
#line 29153 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Select_FRC1_Rc0(cpu *processor,
                                  idecode_cache *cache_entry,
                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Select
#undef MY_PREFIX
#define MY_PREFIX Floating_Select_FRC1_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.23,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 29179 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4743 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Select\n"));
#line 29185 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Select, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4743 "../../sim/ppc/powerpc.igen"
  {
    if (CURRENT_MODEL == MODEL_ppc601) {
      program_interrupt(processor, cia, optional_instruction_program_interrupt);
    } else {
      uint64_t zero = 0;
      FPSCR_BEGIN;
      if (is_NaN(*frA, 0) || is_less_than (frA, &zero)) *frT = *frB;
      else						    *frT = *frC;
      FPSCR_END(Rc);
      PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
    }
  }
#line 29207 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.23,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 29219 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Select_FRC1_Rc1(cpu *processor,
                                  idecode_cache *cache_entry,
                                  unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Select
#undef MY_PREFIX
#define MY_PREFIX Floating_Select_FRC1_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.23,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 29245 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4743 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Select\n"));
#line 29251 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Select, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4743 "../../sim/ppc/powerpc.igen"
  {
    if (CURRENT_MODEL == MODEL_ppc601) {
      program_interrupt(processor, cia, optional_instruction_program_interrupt);
    } else {
      uint64_t zero = 0;
      FPSCR_BEGIN;
      if (is_NaN(*frA, 0) || is_less_than (frA, &zero)) *frT = *frB;
      else						    *frT = *frC;
      FPSCR_END(Rc);
      PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
    }
  }
#line 29273 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.23,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 29285 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Multiply_FRC1_Rc0(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Multiply
#undef MY_PREFIX
#define MY_PREFIX Floating_Multiply_FRC1_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 29309 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3847 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply\n"));
#line 29315 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Multiply, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3847 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = *(double*)frA * *(double*)frC;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRC_BITMASK, Rc);
  }
#line 29347 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 29357 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Multiply_FRC1_Rc1(cpu *processor,
                                    idecode_cache *cache_entry,
                                    unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Multiply
#undef MY_PREFIX
#define MY_PREFIX Floating_Multiply_FRC1_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 29381 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3847 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply\n"));
#line 29387 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Multiply, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3847 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = *(double*)frA * *(double*)frC;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRC_BITMASK, Rc);
  }
#line 29419 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16./,21.FRC,26.25,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 29429 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplySubtract_FRC1_Rc0(cpu *processor,
                                            idecode_cache *cache_entry,
                                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplySubtract
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplySubtract_FRC1_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 29455 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4059 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Subtract\n"));
#line 29461 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplySubtract, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4059 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = product - *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 29514 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 29526 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplySubtract_FRC1_Rc1(cpu *processor,
                                            idecode_cache *cache_entry,
                                            unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplySubtract
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplySubtract_FRC1_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 29552 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4059 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Subtract\n"));
#line 29558 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplySubtract, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4059 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = product - *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 29611 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.28,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 29623 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplyAdd_FRC1_Rc0(cpu *processor,
                                       idecode_cache *cache_entry,
                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplyAdd
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplyAdd_FRC1_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 29649 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3965 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Add\n"));
#line 29655 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplyAdd, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3965 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the add */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = product + *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 29708 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 29720 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_MultiplyAdd_FRC1_Rc1(cpu *processor,
                                       idecode_cache *cache_entry,
                                       unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_MultiplyAdd
#undef MY_PREFIX
#define MY_PREFIX Floating_MultiplyAdd_FRC1_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 29746 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 3965 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Multiply-Add\n"));
#line 29752 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_MultiplyAdd, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 3965 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the add */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = product + *(double*)frB;
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 29805 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.29,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 29817 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplySubtract_FRC1_Rc0(cpu *processor,
                                                     idecode_cache *cache_entry,
                                                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplySubtract
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplySubtract_FRC1_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 29843 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4247 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negative Multiply-Subtract\n"));
#line 29849 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negative_MultiplySubtract, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4247 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = -(product - *(double*)frB);
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 29902 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 29914 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplySubtract_FRC1_Rc1(cpu *processor,
                                                     idecode_cache *cache_entry,
                                                     unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplySubtract
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplySubtract_FRC1_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 29940 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4247 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negative Multiply-Subtract\n"));
#line 29946 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negative_MultiplySubtract, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4247 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the subtract */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = -(product - *(double*)frB);
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 29999 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.30,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 30011 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplyAdd_FRC1_Rc0(cpu *processor,
                                                idecode_cache *cache_entry,
                                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplyAdd
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplyAdd_FRC1_Rc0

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.31,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 0 /* default in icache - constant field */
#line 30037 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4153 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_semantics, ("semantics Floating Negative Multiply-Add\n"));
#line 30043 "semantics.c"

  /* monitoring: */
  if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
    mon_issue(itable_Floating_Negative_MultiplyAdd, processor, cia);
  }

  /* semantics: */
  nia = cia + 4;
#line 4153 "../../sim/ppc/powerpc.igen"
  {
    FPSCR_BEGIN;
    double product; /*HACK! - incorrectly loosing precision ... */
    /* compute the multiply */
    if (is_invalid_operation(processor, cia,
                             *frA, *frC,
                             fpscr_vxsnan | fpscr_vximz,
                             0, /*single?*/
                             0) /*negate?*/) {
      union { double d; uint64_t u; } tmp;
      invalid_arithemetic_operation(processor, cia,
                                    &tmp.u, *frA, 0, *frC,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
      product = tmp.d;
    }
    else {
      /*HACK!*/
      product = *(double*)frA * *(double*)frC;
    }
    /* compute the add */
    if (is_invalid_operation(processor, cia,
                             product, *frB,
                             fpscr_vxsnan | fpscr_vxisi,
                             0, /*single?*/
                             0) /*negate?*/) {
      invalid_arithemetic_operation(processor, cia,
                                    frT, product, *frB, 0,
                                    0, /*instruction_is_frsp*/
                                    0, /*instruction_is_convert_to_64bit*/
                                    0, /*instruction_is_convert_to_32bit*/
                                    0); /*single-precision*/
    }
    else {
      /*HACK!*/
      double s = -(product + *(double*)frB);
      *(double*)frT = s;
    }
    FPSCR_END(Rc);
    PPC_INSN_FLOAT(FRT_BITMASK, FRA_BITMASK | FRB_BITMASK | FRC_BITMASK, Rc);
  }
#line 30096 "semantics.c"
  return nia;
  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.31,31.Rc #undef get-values-from-icache */
#undef frT
#undef FRT_BITMASK
#undef frA
#undef FRA_BITMASK
#undef frB
#undef FRB_BITMASK
#undef frC
#undef FRC_BITMASK
#undef Rc
#line 30108 "semantics.c"

#undef insn
}

PSIM_EXTERN_SEMANTICS\
(unsigned_word)
semantic_Floating_Negative_MultiplyAdd_FRC1_Rc1(cpu *processor,
                                                idecode_cache *cache_entry,
                                                unsigned_word cia)
{
#undef MY_INDEX
#define MY_INDEX itable_Floating_Negative_MultiplyAdd
#undef MY_PREFIX
#define MY_PREFIX Floating_Negative_MultiplyAdd_FRC1_Rc1

  /* extraction: 0.63,6.FRT,11.FRA,16.FRB,21.FRC,26.31,31.Rc #define get-values-from-icache */
#define frT cache_entry->crack.A.frT /* in icache - extraction */
#define FRT_BITMASK cache_entry->crack.A.FRT_BITMASK /* in icache - extraction */
#define frA cache_entry->crack.A.frA /* in icache - extraction */
#define FRA_BITMASK cache_entry->crack.A.FRA_BITMASK /* in icache - extraction */
#define frB cache_entry->crack.A.frB /* in icache - extraction */
#define FRB_BITMASK cache_entry->crack.A.FRB_BITMASK /* in icache - extraction */
#define frC cache_entry->crack.A.frC /* in icache - extraction */
#define FRC_BITMASK cache_entry->crack.A.FRC_BITMASK /* in icache - extraction */
#define Rc 1 /* default in icache - constant field */
#line 30134 "semantics.c"

#define insn cache_entry->crack.A.insn
  unsigned_word nia;
#line 4153