/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.13.1
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtDBus.h"

#line 41 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtDBus/qdbusconnection.sip"
#include <qdbusconnection.h>
#line 29 "/build/pyqt6/src/pyqt6-6.10.0/build/QtDBus/sipQtDBusQDBusConnection.cpp"

#line 24 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 33 "/build/pyqt6/src/pyqt6-6.10.0/build/QtDBus/sipQtDBusQDBusConnection.cpp"
#line 30 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 36 "/build/pyqt6/src/pyqt6-6.10.0/build/QtDBus/sipQtDBusQDBusConnection.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtDBus/qdbusconnectioninterface.sip"
#include <qdbusconnectioninterface.h>
#line 39 "/build/pyqt6/src/pyqt6-6.10.0/build/QtDBus/sipQtDBusQDBusConnection.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qobject.sip"
#include <qobject.h>
#line 42 "/build/pyqt6/src/pyqt6-6.10.0/build/QtDBus/sipQtDBusQDBusConnection.cpp"
#line 25 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qflags.sip"
#include <qglobal.h>
#line 45 "/build/pyqt6/src/pyqt6-6.10.0/build/QtDBus/sipQtDBusQDBusConnection.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 48 "/build/pyqt6/src/pyqt6-6.10.0/build/QtDBus/sipQtDBusQDBusConnection.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtDBus/qdbuspendingcall.sip"
#include <qdbuspendingcall.h>
#line 51 "/build/pyqt6/src/pyqt6-6.10.0/build/QtDBus/sipQtDBusQDBusConnection.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtDBus/qdbusmessage.sip"
#include <qdbusmessage.h>
#line 54 "/build/pyqt6/src/pyqt6-6.10.0/build/QtDBus/sipQtDBusQDBusConnection.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtDBus/qdbusconnection.sip"
#include <qdbusconnection.h>
#line 57 "/build/pyqt6/src/pyqt6-6.10.0/build/QtDBus/sipQtDBusQDBusConnection.cpp"
#line 25 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qflags.sip"
#include <qglobal.h>
#line 60 "/build/pyqt6/src/pyqt6-6.10.0/build/QtDBus/sipQtDBusQDBusConnection.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtDBus/qdbuserror.sip"
#include <qdbuserror.h>
#line 63 "/build/pyqt6/src/pyqt6-6.10.0/build/QtDBus/sipQtDBusQDBusConnection.cpp"


PyDoc_STRVAR(doc_QDBusConnection_isConnected, "isConnected(self) -> bool");

extern "C" {static PyObject *meth_QDBusConnection_isConnected(PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_isConnected(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDBusConnection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDBusConnection, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isConnected();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_isConnected, doc_QDBusConnection_isConnected);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_baseService, "baseService(self) -> str");

extern "C" {static PyObject *meth_QDBusConnection_baseService(PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_baseService(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDBusConnection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDBusConnection, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->baseService());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_baseService, doc_QDBusConnection_baseService);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_lastError, "lastError(self) -> QDBusError");

extern "C" {static PyObject *meth_QDBusConnection_lastError(PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_lastError(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDBusConnection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDBusConnection, &sipCpp))
        {
            ::QDBusError*sipRes;

            sipRes = new ::QDBusError(sipCpp->lastError());

            return sipConvertFromNewType(sipRes, sipType_QDBusError, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_lastError, doc_QDBusConnection_lastError);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_name, "name(self) -> str");

extern "C" {static PyObject *meth_QDBusConnection_name(PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_name(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDBusConnection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDBusConnection, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->name());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_name, doc_QDBusConnection_name);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_connectionCapabilities, "connectionCapabilities(self) -> QDBusConnection.ConnectionCapability");

extern "C" {static PyObject *meth_QDBusConnection_connectionCapabilities(PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_connectionCapabilities(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDBusConnection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDBusConnection, &sipCpp))
        {
            ::QDBusConnection::ConnectionCapabilities*sipRes;

            sipRes = new ::QDBusConnection::ConnectionCapabilities(sipCpp->connectionCapabilities());

            return sipConvertFromNewType(sipRes, sipType_QFlags_0100QDBusConnection_ConnectionCapability, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_connectionCapabilities, doc_QDBusConnection_connectionCapabilities);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_send, "send(self, message: QDBusMessage) -> bool");

extern "C" {static PyObject *meth_QDBusConnection_send(PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_send(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDBusMessage* a0;
        const ::QDBusConnection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QDBusConnection, &sipCpp, sipType_QDBusMessage, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->send(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_send, doc_QDBusConnection_send);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_callWithCallback, "callWithCallback(self, message: QDBusMessage, returnMethod: PYQT_SLOT, errorMethod: PYQT_SLOT, timeout: int = -1) -> bool");

extern "C" {static PyObject *meth_QDBusConnection_callWithCallback(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_callWithCallback(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDBusMessage* a0;
        PyObject * a1;
        PyObject * a2;
        int a3 = -1;
        const ::QDBusConnection *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_timeout,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9P0P0|i", &sipSelf, sipType_QDBusConnection, &sipCpp, sipType_QDBusMessage, &a0, &a1, &a2, &a3))
        {
            bool sipRes = 0;
            sipErrorState sipError = sipErrorNone;

#line 99 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtDBus/qdbusconnection.sip"
        QObject *receiver;
        QByteArray return_slot;
        
        if ((sipError = pyqt6_qtdbus_get_pyqtslot_parts(a1, &receiver, return_slot)) == sipErrorNone)
        {
            QObject *error_receiver;
            QByteArray error_slot;
        
            if ((sipError = pyqt6_qtdbus_get_pyqtslot_parts(a2, &error_receiver, error_slot)) == sipErrorNone)
            {
                if (receiver == error_receiver)
                {
                    sipRes = sipCpp->callWithCallback(*a0, receiver, return_slot.constData(), error_slot.constData(), a3);
                }
                else
                {
                    PyErr_SetString(PyExc_ValueError,
                            "the return and error methods must be bound to the same QObject instance");
                    sipError = sipErrorFail;
                }
            }
            else if (sipError == sipErrorContinue)
            {
                sipError = sipBadCallableArg(2, a2);
            }
        }
        else if (sipError == sipErrorContinue)
        {
            sipError = sipBadCallableArg(1, a1);
        }
#line 280 "/build/pyqt6/src/pyqt6-6.10.0/build/QtDBus/sipQtDBusQDBusConnection.cpp"

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return PyBool_FromLong(sipRes);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_callWithCallback, doc_QDBusConnection_callWithCallback);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_call, "call(self, message: QDBusMessage, mode: QDBus.CallMode = QDBus.Block, timeout: int = -1) -> QDBusMessage");

extern "C" {static PyObject *meth_QDBusConnection_call(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_call(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDBusMessage* a0;
        ::QDBus::CallMode a1 = QDBus::Block;
        int a2 = -1;
        const ::QDBusConnection *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_mode,
            sipName_timeout,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|Ei", &sipSelf, sipType_QDBusConnection, &sipCpp, sipType_QDBusMessage, &a0, sipType_QDBus_CallMode, &a1, &a2))
        {
            ::QDBusMessage*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::QDBusMessage(sipCpp->call(*a0, a1, a2));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QDBusMessage, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_call, doc_QDBusConnection_call);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_asyncCall, "asyncCall(self, message: QDBusMessage, timeout: int = -1) -> QDBusPendingCall");

extern "C" {static PyObject *meth_QDBusConnection_asyncCall(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_asyncCall(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDBusMessage* a0;
        int a1 = -1;
        const ::QDBusConnection *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_timeout,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|i", &sipSelf, sipType_QDBusConnection, &sipCpp, sipType_QDBusMessage, &a0, &a1))
        {
            ::QDBusPendingCall*sipRes;

            sipRes = new ::QDBusPendingCall(sipCpp->asyncCall(*a0, a1));

            return sipConvertFromNewType(sipRes, sipType_QDBusPendingCall, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_asyncCall, doc_QDBusConnection_asyncCall);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_connect, "connect(self, service: Optional[str], path: Optional[str], interface: Optional[str], name: Optional[str], slot: PYQT_SLOT) -> bool\n"
"connect(self, service: Optional[str], path: Optional[str], interface: Optional[str], name: Optional[str], signature: Optional[str], slot: PYQT_SLOT) -> bool\n"
"connect(self, service: Optional[str], path: Optional[str], interface: Optional[str], name: Optional[str], argumentMatch: Iterable[Optional[str]], signature: Optional[str], slot: PYQT_SLOT) -> bool");

extern "C" {static PyObject *meth_QDBusConnection_connect(PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_connect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString* a1;
        int a1State = 0;
        const ::QString* a2;
        int a2State = 0;
        const ::QString* a3;
        int a3State = 0;
        PyObject * a4;
        ::QDBusConnection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1J1J1P0", &sipSelf, sipType_QDBusConnection, &sipCpp, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State, sipType_QString, &a2, &a2State, sipType_QString, &a3, &a3State, &a4))
        {
            bool sipRes = 0;
            sipErrorState sipError = sipErrorNone;

#line 135 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtDBus/qdbusconnection.sip"
        QObject *receiver;
        QByteArray slot;
        
        if ((sipError = pyqt6_qtdbus_get_pyqtslot_parts(a4, &receiver, slot)) == sipErrorNone)
        {
            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->connect(*a0, *a1, *a2, *a3, receiver, slot.constData());
            Py_END_ALLOW_THREADS
        }
        else if (sipError == sipErrorContinue)
        {
            sipError = sipBadCallableArg(4, a4);
        }
#line 410 "/build/pyqt6/src/pyqt6-6.10.0/build/QtDBus/sipQtDBusQDBusConnection.cpp"
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);
            sipReleaseType(const_cast< ::QString *>(a2), sipType_QString, a2State);
            sipReleaseType(const_cast< ::QString *>(a3), sipType_QString, a3State);

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return PyBool_FromLong(sipRes);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString* a1;
        int a1State = 0;
        const ::QString* a2;
        int a2State = 0;
        const ::QString* a3;
        int a3State = 0;
        const ::QString* a4;
        int a4State = 0;
        PyObject * a5;
        ::QDBusConnection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1J1J1J1P0", &sipSelf, sipType_QDBusConnection, &sipCpp, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State, sipType_QString, &a2, &a2State, sipType_QString, &a3, &a3State, sipType_QString, &a4, &a4State, &a5))
        {
            bool sipRes = 0;
            sipErrorState sipError = sipErrorNone;

#line 152 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtDBus/qdbusconnection.sip"
        QObject *receiver;
        QByteArray slot;
        
        if ((sipError = pyqt6_qtdbus_get_pyqtslot_parts(a5, &receiver, slot)) == sipErrorNone)
        {
            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->connect(*a0, *a1, *a2, *a3, *a4, receiver, slot.constData());
            Py_END_ALLOW_THREADS
        }
        else if (sipError == sipErrorContinue)
        {
            sipError = sipBadCallableArg(5, a5);
        }
#line 461 "/build/pyqt6/src/pyqt6-6.10.0/build/QtDBus/sipQtDBusQDBusConnection.cpp"
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);
            sipReleaseType(const_cast< ::QString *>(a2), sipType_QString, a2State);
            sipReleaseType(const_cast< ::QString *>(a3), sipType_QString, a3State);
            sipReleaseType(const_cast< ::QString *>(a4), sipType_QString, a4State);

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return PyBool_FromLong(sipRes);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString* a1;
        int a1State = 0;
        const ::QString* a2;
        int a2State = 0;
        const ::QString* a3;
        int a3State = 0;
        const ::QStringList* a4;
        int a4State = 0;
        const ::QString* a5;
        int a5State = 0;
        PyObject * a6;
        ::QDBusConnection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1J1J1J1J1P0", &sipSelf, sipType_QDBusConnection, &sipCpp, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State, sipType_QString, &a2, &a2State, sipType_QString, &a3, &a3State, sipType_QStringList, &a4, &a4State, sipType_QString, &a5, &a5State, &a6))
        {
            bool sipRes = 0;
            sipErrorState sipError = sipErrorNone;

#line 169 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtDBus/qdbusconnection.sip"
        QObject *receiver;
        QByteArray slot;
        
        if ((sipError = pyqt6_qtdbus_get_pyqtslot_parts(a6, &receiver, slot)) == sipErrorNone)
        {
            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->connect(*a0, *a1, *a2, *a3, *a4, *a5, receiver, slot.constData());
            Py_END_ALLOW_THREADS
        }
        else if (sipError == sipErrorContinue)
        {
            sipError = sipBadCallableArg(6, a6);
        }
#line 515 "/build/pyqt6/src/pyqt6-6.10.0/build/QtDBus/sipQtDBusQDBusConnection.cpp"
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);
            sipReleaseType(const_cast< ::QString *>(a2), sipType_QString, a2State);
            sipReleaseType(const_cast< ::QString *>(a3), sipType_QString, a3State);
            sipReleaseType(const_cast< ::QStringList *>(a4), sipType_QStringList, a4State);
            sipReleaseType(const_cast< ::QString *>(a5), sipType_QString, a5State);

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return PyBool_FromLong(sipRes);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_connect, doc_QDBusConnection_connect);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_disconnect, "disconnect(self, service: Optional[str], path: Optional[str], interface: Optional[str], name: Optional[str], slot: PYQT_SLOT) -> bool\n"
"disconnect(self, service: Optional[str], path: Optional[str], interface: Optional[str], name: Optional[str], signature: Optional[str], slot: PYQT_SLOT) -> bool\n"
"disconnect(self, service: Optional[str], path: Optional[str], interface: Optional[str], name: Optional[str], argumentMatch: Iterable[Optional[str]], signature: Optional[str], slot: PYQT_SLOT) -> bool");

extern "C" {static PyObject *meth_QDBusConnection_disconnect(PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_disconnect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString* a1;
        int a1State = 0;
        const ::QString* a2;
        int a2State = 0;
        const ::QString* a3;
        int a3State = 0;
        PyObject * a4;
        ::QDBusConnection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1J1J1P0", &sipSelf, sipType_QDBusConnection, &sipCpp, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State, sipType_QString, &a2, &a2State, sipType_QString, &a3, &a3State, &a4))
        {
            bool sipRes = 0;
            sipErrorState sipError = sipErrorNone;

#line 186 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtDBus/qdbusconnection.sip"
        QObject *receiver;
        QByteArray slot;
        
        if ((sipError = pyqt6_qtdbus_get_pyqtslot_parts(a4, &receiver, slot)) == sipErrorNone)
        {
            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->disconnect(*a0, *a1, *a2, *a3, receiver, slot.constData());
            Py_END_ALLOW_THREADS
        }
        else if (sipError == sipErrorContinue)
        {
            sipError = sipBadCallableArg(4, a4);
        }
#line 581 "/build/pyqt6/src/pyqt6-6.10.0/build/QtDBus/sipQtDBusQDBusConnection.cpp"
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);
            sipReleaseType(const_cast< ::QString *>(a2), sipType_QString, a2State);
            sipReleaseType(const_cast< ::QString *>(a3), sipType_QString, a3State);

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return PyBool_FromLong(sipRes);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString* a1;
        int a1State = 0;
        const ::QString* a2;
        int a2State = 0;
        const ::QString* a3;
        int a3State = 0;
        const ::QString* a4;
        int a4State = 0;
        PyObject * a5;
        ::QDBusConnection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1J1J1J1P0", &sipSelf, sipType_QDBusConnection, &sipCpp, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State, sipType_QString, &a2, &a2State, sipType_QString, &a3, &a3State, sipType_QString, &a4, &a4State, &a5))
        {
            bool sipRes = 0;
            sipErrorState sipError = sipErrorNone;

#line 203 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtDBus/qdbusconnection.sip"
        QObject *receiver;
        QByteArray slot;
        
        if ((sipError = pyqt6_qtdbus_get_pyqtslot_parts(a5, &receiver, slot)) == sipErrorNone)
        {
            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->disconnect(*a0, *a1, *a2, *a3, *a4, receiver, slot.constData());
            Py_END_ALLOW_THREADS
        }
        else if (sipError == sipErrorContinue)
        {
            sipError = sipBadCallableArg(5, a5);
        }
#line 632 "/build/pyqt6/src/pyqt6-6.10.0/build/QtDBus/sipQtDBusQDBusConnection.cpp"
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);
            sipReleaseType(const_cast< ::QString *>(a2), sipType_QString, a2State);
            sipReleaseType(const_cast< ::QString *>(a3), sipType_QString, a3State);
            sipReleaseType(const_cast< ::QString *>(a4), sipType_QString, a4State);

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return PyBool_FromLong(sipRes);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString* a1;
        int a1State = 0;
        const ::QString* a2;
        int a2State = 0;
        const ::QString* a3;
        int a3State = 0;
        const ::QStringList* a4;
        int a4State = 0;
        const ::QString* a5;
        int a5State = 0;
        PyObject * a6;
        ::QDBusConnection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1J1J1J1J1P0", &sipSelf, sipType_QDBusConnection, &sipCpp, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State, sipType_QString, &a2, &a2State, sipType_QString, &a3, &a3State, sipType_QStringList, &a4, &a4State, sipType_QString, &a5, &a5State, &a6))
        {
            bool sipRes = 0;
            sipErrorState sipError = sipErrorNone;

#line 220 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtDBus/qdbusconnection.sip"
        QObject *receiver;
        QByteArray slot;
        
        if ((sipError = pyqt6_qtdbus_get_pyqtslot_parts(a6, &receiver, slot)) == sipErrorNone)
        {
            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->disconnect(*a0, *a1, *a2, *a3, *a4, *a5, receiver, slot.constData());
            Py_END_ALLOW_THREADS
        }
        else if (sipError == sipErrorContinue)
        {
            sipError = sipBadCallableArg(6, a6);
        }
#line 686 "/build/pyqt6/src/pyqt6-6.10.0/build/QtDBus/sipQtDBusQDBusConnection.cpp"
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);
            sipReleaseType(const_cast< ::QString *>(a2), sipType_QString, a2State);
            sipReleaseType(const_cast< ::QString *>(a3), sipType_QString, a3State);
            sipReleaseType(const_cast< ::QStringList *>(a4), sipType_QStringList, a4State);
            sipReleaseType(const_cast< ::QString *>(a5), sipType_QString, a5State);

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return PyBool_FromLong(sipRes);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_disconnect, doc_QDBusConnection_disconnect);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_registerObject, "registerObject(self, path: Optional[str], object: Optional[QObject], options: QDBusConnection.RegisterOption = QDBusConnection.ExportAdaptors) -> bool\n"
"registerObject(self, path: Optional[str], interface: Optional[str], object: Optional[QObject], options: QDBusConnection.RegisterOption = QDBusConnection.ExportAdaptors) -> bool");

extern "C" {static PyObject *meth_QDBusConnection_registerObject(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_registerObject(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QObject* a1;
        ::QDBusConnection::RegisterOptions a2def = QDBusConnection::ExportAdaptors;
        ::QDBusConnection::RegisterOptions* a2 = &a2def;
        int a2State = 0;
        ::QDBusConnection *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_options,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J8|J1", &sipSelf, sipType_QDBusConnection, &sipCpp, sipType_QString, &a0, &a0State, sipType_QObject, &a1, sipType_QFlags_0100QDBusConnection_RegisterOption, &a2, &a2State))
        {
            bool sipRes;

            sipRes = sipCpp->registerObject(*a0, a1, *a2);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(a2, sipType_QFlags_0100QDBusConnection_RegisterOption, a2State);

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString* a1;
        int a1State = 0;
        ::QObject* a2;
        ::QDBusConnection::RegisterOptions a3def = QDBusConnection::ExportAdaptors;
        ::QDBusConnection::RegisterOptions* a3 = &a3def;
        int a3State = 0;
        ::QDBusConnection *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_options,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1J8|J1", &sipSelf, sipType_QDBusConnection, &sipCpp, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State, sipType_QObject, &a2, sipType_QFlags_0100QDBusConnection_RegisterOption, &a3, &a3State))
        {
            bool sipRes;

            sipRes = sipCpp->registerObject(*a0, *a1, a2, *a3);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);
            sipReleaseType(a3, sipType_QFlags_0100QDBusConnection_RegisterOption, a3State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_registerObject, doc_QDBusConnection_registerObject);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_unregisterObject, "unregisterObject(self, path: Optional[str], mode: QDBusConnection.UnregisterMode = QDBusConnection.UnregisterNode)");

extern "C" {static PyObject *meth_QDBusConnection_unregisterObject(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_unregisterObject(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QDBusConnection::UnregisterMode a1 = QDBusConnection::UnregisterNode;
        ::QDBusConnection *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_mode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|E", &sipSelf, sipType_QDBusConnection, &sipCpp, sipType_QString, &a0, &a0State, sipType_QDBusConnection_UnregisterMode, &a1))
        {
            sipCpp->unregisterObject(*a0, a1);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_unregisterObject, doc_QDBusConnection_unregisterObject);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_objectRegisteredAt, "objectRegisteredAt(self, path: Optional[str]) -> Optional[QObject]");

extern "C" {static PyObject *meth_QDBusConnection_objectRegisteredAt(PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_objectRegisteredAt(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QDBusConnection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QDBusConnection, &sipCpp, sipType_QString, &a0, &a0State))
        {
            ::QObject*sipRes;

            sipRes = sipCpp->objectRegisteredAt(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromType(sipRes, sipType_QObject, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_objectRegisteredAt, doc_QDBusConnection_objectRegisteredAt);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_registerService, "registerService(self, serviceName: Optional[str]) -> bool");

extern "C" {static PyObject *meth_QDBusConnection_registerService(PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_registerService(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QDBusConnection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QDBusConnection, &sipCpp, sipType_QString, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp->registerService(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_registerService, doc_QDBusConnection_registerService);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_unregisterService, "unregisterService(self, serviceName: Optional[str]) -> bool");

extern "C" {static PyObject *meth_QDBusConnection_unregisterService(PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_unregisterService(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QDBusConnection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QDBusConnection, &sipCpp, sipType_QString, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp->unregisterService(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_unregisterService, doc_QDBusConnection_unregisterService);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_interface, "interface(self) -> Optional[QDBusConnectionInterface]");

extern "C" {static PyObject *meth_QDBusConnection_interface(PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_interface(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDBusConnection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QDBusConnection, &sipCpp))
        {
            ::QDBusConnectionInterface*sipRes;

            sipRes = sipCpp->interface();

            return sipConvertFromType(sipRes, sipType_QDBusConnectionInterface, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_interface, doc_QDBusConnection_interface);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_connectToBus, "connectToBus(type: QDBusConnection.BusType, name: Optional[str]) -> QDBusConnection\n"
"connectToBus(address: Optional[str], name: Optional[str]) -> QDBusConnection");

extern "C" {static PyObject *meth_QDBusConnection_connectToBus(PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_connectToBus(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QDBusConnection::BusType a0;
        const ::QString* a1;
        int a1State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CEJ1", &sipSelf, sipType_QDBusConnection_BusType, &a0, sipType_QString, &a1, &a1State))
        {
            ::QDBusConnection*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::QDBusConnection(::QDBusConnection::connectToBus(a0, *a1));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return sipConvertFromNewType(sipRes, sipType_QDBusConnection, SIP_NULLPTR);
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString* a1;
        int a1State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CJ1J1", &sipSelf, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State))
        {
            ::QDBusConnection*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::QDBusConnection(::QDBusConnection::connectToBus(*a0, *a1));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return sipConvertFromNewType(sipRes, sipType_QDBusConnection, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_connectToBus, doc_QDBusConnection_connectToBus);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_connectToPeer, "connectToPeer(address: Optional[str], name: Optional[str]) -> QDBusConnection");

extern "C" {static PyObject *meth_QDBusConnection_connectToPeer(PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_connectToPeer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString* a1;
        int a1State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CJ1J1", &sipSelf, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State))
        {
            ::QDBusConnection*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::QDBusConnection(::QDBusConnection::connectToPeer(*a0, *a1));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return sipConvertFromNewType(sipRes, sipType_QDBusConnection, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_connectToPeer, doc_QDBusConnection_connectToPeer);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_disconnectFromBus, "disconnectFromBus(name: Optional[str])");

extern "C" {static PyObject *meth_QDBusConnection_disconnectFromBus(PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_disconnectFromBus(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CJ1", &sipSelf, sipType_QString, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            ::QDBusConnection::disconnectFromBus(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_disconnectFromBus, doc_QDBusConnection_disconnectFromBus);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_disconnectFromPeer, "disconnectFromPeer(name: Optional[str])");

extern "C" {static PyObject *meth_QDBusConnection_disconnectFromPeer(PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_disconnectFromPeer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CJ1", &sipSelf, sipType_QString, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            ::QDBusConnection::disconnectFromPeer(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_disconnectFromPeer, doc_QDBusConnection_disconnectFromPeer);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_localMachineId, "localMachineId() -> QByteArray");

extern "C" {static PyObject *meth_QDBusConnection_localMachineId(PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_localMachineId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, "C", &sipSelf))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(::QDBusConnection::localMachineId());

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_localMachineId, doc_QDBusConnection_localMachineId);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_sessionBus, "sessionBus() -> QDBusConnection");

extern "C" {static PyObject *meth_QDBusConnection_sessionBus(PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_sessionBus(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, "C", &sipSelf))
        {
            ::QDBusConnection*sipRes;

            sipRes = new ::QDBusConnection(::QDBusConnection::sessionBus());

            return sipConvertFromNewType(sipRes, sipType_QDBusConnection, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_sessionBus, doc_QDBusConnection_sessionBus);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_systemBus, "systemBus() -> QDBusConnection");

extern "C" {static PyObject *meth_QDBusConnection_systemBus(PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_systemBus(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, "C", &sipSelf))
        {
            ::QDBusConnection*sipRes;

            sipRes = new ::QDBusConnection(::QDBusConnection::systemBus());

            return sipConvertFromNewType(sipRes, sipType_QDBusConnection, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_systemBus, doc_QDBusConnection_systemBus);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QDBusConnection_swap, "swap(self, other: QDBusConnection)");

extern "C" {static PyObject *meth_QDBusConnection_swap(PyObject *, PyObject *);}
static PyObject *meth_QDBusConnection_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QDBusConnection* a0;
        ::QDBusConnection *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QDBusConnection, &sipCpp, sipType_QDBusConnection, &a0))
        {
            sipCpp->swap(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QDBusConnection, sipName_swap, doc_QDBusConnection_swap);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QDBusConnection(void *, int);}
static void release_QDBusConnection(void *sipCppV, int)
{
    delete reinterpret_cast< ::QDBusConnection *>(sipCppV);
}


extern "C" {static void assign_QDBusConnection(void *, Py_ssize_t, void *);}
static void assign_QDBusConnection(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QDBusConnection *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QDBusConnection *>(sipSrc);
}


extern "C" {static void *copy_QDBusConnection(const void *, Py_ssize_t);}
static void *copy_QDBusConnection(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QDBusConnection(reinterpret_cast<const ::QDBusConnection *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QDBusConnection(sipSimpleWrapper *);}
static void dealloc_QDBusConnection(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QDBusConnection(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QDBusConnection(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QDBusConnection(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QDBusConnection *sipCpp = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_QString, &a0, &a0State))
        {
            sipCpp = new ::QDBusConnection(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipCpp;
        }
    }

    {
        const ::QDBusConnection* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QDBusConnection, &a0))
        {
            sipCpp = new ::QDBusConnection(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QDBusConnection[] = {
    {sipName_asyncCall, SIP_MLMETH_CAST(meth_QDBusConnection_asyncCall), METH_VARARGS|METH_KEYWORDS, doc_QDBusConnection_asyncCall},
    {sipName_baseService, meth_QDBusConnection_baseService, METH_VARARGS, doc_QDBusConnection_baseService},
    {sipName_call, SIP_MLMETH_CAST(meth_QDBusConnection_call), METH_VARARGS|METH_KEYWORDS, doc_QDBusConnection_call},
    {sipName_callWithCallback, SIP_MLMETH_CAST(meth_QDBusConnection_callWithCallback), METH_VARARGS|METH_KEYWORDS, doc_QDBusConnection_callWithCallback},
    {sipName_connect, meth_QDBusConnection_connect, METH_VARARGS, doc_QDBusConnection_connect},
    {sipName_connectToBus, meth_QDBusConnection_connectToBus, METH_VARARGS, doc_QDBusConnection_connectToBus},
    {sipName_connectToPeer, meth_QDBusConnection_connectToPeer, METH_VARARGS, doc_QDBusConnection_connectToPeer},
    {sipName_connectionCapabilities, meth_QDBusConnection_connectionCapabilities, METH_VARARGS, doc_QDBusConnection_connectionCapabilities},
    {sipName_disconnect, meth_QDBusConnection_disconnect, METH_VARARGS, doc_QDBusConnection_disconnect},
    {sipName_disconnectFromBus, meth_QDBusConnection_disconnectFromBus, METH_VARARGS, doc_QDBusConnection_disconnectFromBus},
    {sipName_disconnectFromPeer, meth_QDBusConnection_disconnectFromPeer, METH_VARARGS, doc_QDBusConnection_disconnectFromPeer},
    {sipName_interface, meth_QDBusConnection_interface, METH_VARARGS, doc_QDBusConnection_interface},
    {sipName_isConnected, meth_QDBusConnection_isConnected, METH_VARARGS, doc_QDBusConnection_isConnected},
    {sipName_lastError, meth_QDBusConnection_lastError, METH_VARARGS, doc_QDBusConnection_lastError},
    {sipName_localMachineId, meth_QDBusConnection_localMachineId, METH_VARARGS, doc_QDBusConnection_localMachineId},
    {sipName_name, meth_QDBusConnection_name, METH_VARARGS, doc_QDBusConnection_name},
    {sipName_objectRegisteredAt, meth_QDBusConnection_objectRegisteredAt, METH_VARARGS, doc_QDBusConnection_objectRegisteredAt},
    {sipName_registerObject, SIP_MLMETH_CAST(meth_QDBusConnection_registerObject), METH_VARARGS|METH_KEYWORDS, doc_QDBusConnection_registerObject},
    {sipName_registerService, meth_QDBusConnection_registerService, METH_VARARGS, doc_QDBusConnection_registerService},
    {sipName_send, meth_QDBusConnection_send, METH_VARARGS, doc_QDBusConnection_send},
    {sipName_sessionBus, meth_QDBusConnection_sessionBus, METH_VARARGS, doc_QDBusConnection_sessionBus},
    {sipName_swap, meth_QDBusConnection_swap, METH_VARARGS, doc_QDBusConnection_swap},
    {sipName_systemBus, meth_QDBusConnection_systemBus, METH_VARARGS, doc_QDBusConnection_systemBus},
    {sipName_unregisterObject, SIP_MLMETH_CAST(meth_QDBusConnection_unregisterObject), METH_VARARGS|METH_KEYWORDS, doc_QDBusConnection_unregisterObject},
    {sipName_unregisterService, meth_QDBusConnection_unregisterService, METH_VARARGS, doc_QDBusConnection_unregisterService}
};


/* Define the enum members and ints to be added to this type. */
static sipIntInstanceDef intInstances_QDBusConnection[] = {
    {sipName_SessionBus, static_cast<int>(::QDBusConnection::SessionBus)},
    {sipName_SystemBus, static_cast<int>(::QDBusConnection::SystemBus)},
    {sipName_ActivationBus, static_cast<int>(::QDBusConnection::ActivationBus)},
    {sipName_UnixFileDescriptorPassing, static_cast<int>(::QDBusConnection::UnixFileDescriptorPassing)},
    {sipName_ExportAdaptors, static_cast<int>(::QDBusConnection::ExportAdaptors)},
    {sipName_ExportScriptableSlots, static_cast<int>(::QDBusConnection::ExportScriptableSlots)},
    {sipName_ExportScriptableSignals, static_cast<int>(::QDBusConnection::ExportScriptableSignals)},
    {sipName_ExportScriptableProperties, static_cast<int>(::QDBusConnection::ExportScriptableProperties)},
    {sipName_ExportScriptableInvokables, static_cast<int>(::QDBusConnection::ExportScriptableInvokables)},
    {sipName_ExportScriptableContents, static_cast<int>(::QDBusConnection::ExportScriptableContents)},
    {sipName_ExportNonScriptableSlots, static_cast<int>(::QDBusConnection::ExportNonScriptableSlots)},
    {sipName_ExportNonScriptableSignals, static_cast<int>(::QDBusConnection::ExportNonScriptableSignals)},
    {sipName_ExportNonScriptableProperties, static_cast<int>(::QDBusConnection::ExportNonScriptableProperties)},
    {sipName_ExportNonScriptableInvokables, static_cast<int>(::QDBusConnection::ExportNonScriptableInvokables)},
    {sipName_ExportNonScriptableContents, static_cast<int>(::QDBusConnection::ExportNonScriptableContents)},
    {sipName_ExportAllSlots, static_cast<int>(::QDBusConnection::ExportAllSlots)},
    {sipName_ExportAllSignals, static_cast<int>(::QDBusConnection::ExportAllSignals)},
    {sipName_ExportAllProperties, static_cast<int>(::QDBusConnection::ExportAllProperties)},
    {sipName_ExportAllInvokables, static_cast<int>(::QDBusConnection::ExportAllInvokables)},
    {sipName_ExportAllContents, static_cast<int>(::QDBusConnection::ExportAllContents)},
    {sipName_ExportAllSignal, static_cast<int>(::QDBusConnection::ExportAllSignal)},
    {sipName_ExportChildObjects, static_cast<int>(::QDBusConnection::ExportChildObjects)},
    {sipName_UnregisterNode, static_cast<int>(::QDBusConnection::UnregisterNode)},
    {sipName_UnregisterTree, static_cast<int>(::QDBusConnection::UnregisterTree)},
    {0, 0}
};

PyDoc_STRVAR(doc_QDBusConnection, "\1QDBusConnection(name: Optional[str])\n"
"QDBusConnection(other: QDBusConnection)");


sipClassTypeDef sipTypeDef_QtDBus_QDBusConnection = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QDBusConnection,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QDBusConnection,
        {0, 0, 1},
        25, methods_QDBusConnection,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, intInstances_QDBusConnection, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QDBusConnection,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QDBusConnection,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QDBusConnection,
    assign_QDBusConnection,
    SIP_NULLPTR,
    copy_QDBusConnection,
    release_QDBusConnection,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::QDBusConnection),
};
