/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.13.1
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6-Graphs.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGraphs.h"

#line 27 "/build/pyqt6-graphs/src/pyqt6_graphs-6.10.0/sip/QtGraphs/qlist.sip"
#include <qlist.h>
#line 29 "/build/pyqt6-graphs/src/pyqt6_graphs-6.10.0/build/QtGraphs/sipQtGraphsQList0600QList0100QSurfaceDataItem.cpp"

#line 26 "/build/pyqt6-graphs/src/pyqt6_graphs-6.10.0/sip/QtGraphs/qsurfacedataitem.sip"
#include <qsurfacedataitem.h>
#line 33 "/build/pyqt6-graphs/src/pyqt6_graphs-6.10.0/build/QtGraphs/sipQtGraphsQList0600QList0100QSurfaceDataItem.cpp"


extern "C" {static void assign_QList_0600QList_0100QSurfaceDataItem(void *, Py_ssize_t, void *);}
static void assign_QList_0600QList_0100QSurfaceDataItem(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<QList<QList<QSurfaceDataItem>> *>(sipDst)[sipDstIdx] = *reinterpret_cast<QList<QList<QSurfaceDataItem>> *>(sipSrc);
}


extern "C" {static void *array_QList_0600QList_0100QSurfaceDataItem(Py_ssize_t);}
static void *array_QList_0600QList_0100QSurfaceDataItem(Py_ssize_t sipNrElem)
{
    return new QList<QList<QSurfaceDataItem>>[sipNrElem];
}


extern "C" {static void *copy_QList_0600QList_0100QSurfaceDataItem(const void *, Py_ssize_t);}
static void *copy_QList_0600QList_0100QSurfaceDataItem(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new QList<QList<QSurfaceDataItem>>(reinterpret_cast<const QList<QList<QSurfaceDataItem>> *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_QList_0600QList_0100QSurfaceDataItem(void *, int, void *);}
static void release_QList_0600QList_0100QSurfaceDataItem(void *sipCppV, int, void *)
{
    QList<QList<QSurfaceDataItem>> *sipCpp = reinterpret_cast<QList<QList<QSurfaceDataItem>> *>(sipCppV);
    delete sipCpp;
}



extern "C" {static int convertTo_QList_0600QList_0100QSurfaceDataItem(PyObject *, void **, int *, PyObject *, void **);}
static int convertTo_QList_0600QList_0100QSurfaceDataItem(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj, void **)
{
    QList<QList<QSurfaceDataItem>> **sipCppPtr = reinterpret_cast<QList<QList<QSurfaceDataItem>> **>(sipCppPtrV);

#line 73 "/build/pyqt6-graphs/src/pyqt6_graphs-6.10.0/sip/QtGraphs/qlist.sip"
    PyObject *iter = PyObject_GetIter(sipPy);

    if (!sipIsErr)
    {
        PyErr_Clear();
        Py_XDECREF(iter);

        return (iter && !PyBytes_Check(sipPy) && !PyUnicode_Check(sipPy));
    }

    if (!iter)
    {
        *sipIsErr = 1;

        return 0;
    }

    QList<QList<QSurfaceDataItem>> *ql = new QList<QList<QSurfaceDataItem>>;
 
    for (Py_ssize_t i = 0; ; ++i)
    {
        PyErr_Clear();
        PyObject *itm = PyIter_Next(iter);

        if (!itm)
        {
            if (PyErr_Occurred())
            {
                delete ql;
                Py_DECREF(iter);
                *sipIsErr = 1;

                return 0;
            }

            break;
        }

        PyObject *vec_iter = PyObject_GetIter(itm);

        if (!vec_iter)
        {
            PyErr_Format(PyExc_TypeError, "index %zd is not iterable", i);

            Py_DECREF(itm);
            delete ql;
            Py_DECREF(iter);

            return 0;
        }

        QList<QSurfaceDataItem> qv;

        for (Py_ssize_t j = 0; ; ++j)
        {
            PyErr_Clear();
            PyObject *vec_itm = PyIter_Next(vec_iter);

            if (!vec_itm)
            {
                if (PyErr_Occurred())
                {
                    Py_DECREF(vec_iter);
                    delete ql;
                    Py_DECREF(iter);
                    *sipIsErr = 1;

                    return 0;
                }

                break;
            }

            int state;
            QSurfaceDataItem *t = reinterpret_cast<QSurfaceDataItem *>(
                    sipForceConvertToType(vec_itm, sipType_QSurfaceDataItem,
                            sipTransferObj, SIP_NOT_NONE, &state, sipIsErr));
 
            if (*sipIsErr)
            {
                PyErr_Format(PyExc_TypeError,
                        "index %zd, %zd has type '%s' but 'QSurfaceDataItem' is expected",
                        i, j, sipPyTypeName(Py_TYPE(itm)));

                Py_DECREF(vec_itm);
                Py_DECREF(vec_iter);

                Py_DECREF(itm);
                delete ql;
                Py_DECREF(iter);

                return 0;
            }

            qv.append(*t);

            sipReleaseType(t, sipType_QSurfaceDataItem, state);
            Py_DECREF(vec_itm);
        }

        ql->append(qv);

        Py_DECREF(vec_iter);

        Py_DECREF(itm);
    }

    Py_DECREF(iter);
 
    *sipCppPtr = ql;
 
    return sipGetState(sipTransferObj);
#line 185 "/build/pyqt6-graphs/src/pyqt6_graphs-6.10.0/build/QtGraphs/sipQtGraphsQList0600QList0100QSurfaceDataItem.cpp"
}


extern "C" {static PyObject *convertFrom_QList_0600QList_0100QSurfaceDataItem(void *, PyObject *);}
static PyObject *convertFrom_QList_0600QList_0100QSurfaceDataItem(void *sipCppV, PyObject *sipTransferObj)
{
    QList<QList<QSurfaceDataItem>> *sipCpp = reinterpret_cast<QList<QList<QSurfaceDataItem>> *>(sipCppV);

#line 31 "/build/pyqt6-graphs/src/pyqt6_graphs-6.10.0/sip/QtGraphs/qlist.sip"
    PyObject *l = PyList_New(sipCpp->size());

    if (!l)
        return 0;

    for (int i = 0; i < sipCpp->size(); ++i)
    {
        QList<QSurfaceDataItem> t_vec = sipCpp->at(i);

        PyObject *v = PyList_New(t_vec.size());

        if (!v)
        {
            Py_DECREF(l);

            return 0;
        }

        PyList_SetItem(l, i, v);

        for (int j = 0; j < t_vec.size(); ++j)
        {
            QSurfaceDataItem *t = new QSurfaceDataItem(t_vec.at(i));
            PyObject *tobj = sipConvertFromType(t, sipType_QSurfaceDataItem,
                    sipTransferObj);

            if (!tobj)
            {
                delete t;
                Py_DECREF(l);

                return 0;
            }

            PyList_SetItem(v, j, tobj);
        }
    }

    return l;
#line 234 "/build/pyqt6-graphs/src/pyqt6_graphs-6.10.0/build/QtGraphs/sipQtGraphsQList0600QList0100QSurfaceDataItem.cpp"
}


sipMappedTypeDef sipTypeDef_QtGraphs_QList_0600QList_0100QSurfaceDataItem = {
    {
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_358,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        -1,
        {0, 0, 1},
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
    },
    assign_QList_0600QList_0100QSurfaceDataItem,
    array_QList_0600QList_0100QSurfaceDataItem,
    copy_QList_0600QList_0100QSurfaceDataItem,
    release_QList_0600QList_0100QSurfaceDataItem,
    convertTo_QList_0600QList_0100QSurfaceDataItem,
    convertFrom_QList_0600QList_0100QSurfaceDataItem
};
