// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A4__F208

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr std::string_view PACKAGE_PATH { R"xyzw(amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x)xyzw" };
constexpr std::string_view FUNC_NAME { R"xyzw(＊bf16@16_32_F_F_0_0)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx1200)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0x1b91dd55u, 0xd6b8c935u, 474, 48 }, // 1b91dd55d6b8c935 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x__P__0_2_16_16_True__CO__wave1_warp2_stg1--Arch_gfx1200
    { 0x755b5192u, 0x83cce1b1u, 474, 16 }, // 755b519283cce1b1 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x__P__0_2_16_16_True__CO__wave4_warp2_stg1--Arch_gfx1200
    { 0xb4f9bf9au, 0x66cd47ecu, 0, 48 }, // b4f9bf9a66cd47ec = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x__P__0_2_32_16_False__CO__wave1_warp2_stg1--Arch_gfx1200
    { 0x7cf8309eu, 0x0534e575u, 33, 16 }, // 7cf8309e0534e575 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x__P__0_2_32_16_True__CO__wave4_warp2_stg1--Arch_gfx1200
    { 0x73fd8857u, 0x2308d915u, 489, 263 }, // 73fd88572308d915 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x__P__0_2_32_32_False__CO__wave1_warp4_stg1--Arch_gfx1200
    { 0xf5724e1eu, 0x86bf8953u, 489, 195 }, // f5724e1e86bf8953 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x__P__0_2_32_32_False__CO__wave4_warp4_stg1--Arch_gfx1200
    { 0x9dec0445u, 0x65740554u, 505, 263 }, // 9dec044565740554 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x__P__0_2_32_32_True__CO__wave1_warp4_stg1--Arch_gfx1200
    { 0xbeebb445u, 0xd1b89b1bu, 505, 178 }, // beebb445d1b89b1b = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x__P__0_2_32_32_True__CO__wave2_warp4_stg1--Arch_gfx1200
    { 0x2b7a2e99u, 0x150fee59u, 505, 146 }, // 2b7a2e99150fee59 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x__P__0_2_32_32_True__CO__wave3_warp4_stg1--Arch_gfx1200
    { 0xd0166886u, 0x1de3346cu, 505, 16 }, // d01668861de3346c = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x__P__0_2_32_32_True__CO__wave4_warp2_stg1--Arch_gfx1200
    { 0xed6e5025u, 0x712b5e06u, 505, 195 }, // ed6e5025712b5e06 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x__P__0_2_32_32_True__CO__wave4_warp4_stg1--Arch_gfx1200
    { 0xbe91b174u, 0x41af2f75u, 99, 48 }, // be91b17441af2f75 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x__P__0_2_64_32_False__CO__wave1_warp2_stg1--Arch_gfx1200
    { 0xc9ad99c5u, 0x7c9b3bb6u, 99, 65 }, // c9ad99c57c9b3bb6 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x__P__0_2_64_32_False__CO__wave2_warp2_stg1--Arch_gfx1200
    { 0xca8f7ae8u, 0x37792aabu, 99, 82 }, // ca8f7ae837792aab = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x__P__0_2_64_32_False__CO__wave3_warp2_stg1--Arch_gfx1200
    { 0xad3af994u, 0x0122275fu, 99, 146 }, // ad3af9940122275f = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x__P__0_2_64_32_False__CO__wave3_warp4_stg1--Arch_gfx1200
    { 0x45620293u, 0x952bcce0u, 99, 16 }, // 45620293952bcce0 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x__P__0_2_64_32_False__CO__wave4_warp2_stg1--Arch_gfx1200
    { 0xb4f32022u, 0x8377b67fu, 99, 195 }, // b4f320228377b67f = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x__P__0_2_64_32_False__CO__wave4_warp4_stg1--Arch_gfx1200
    { 0x3ec037b6u, 0x82c4e07fu, 115, 48 }, // 3ec037b682c4e07f = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x__P__0_2_64_32_True__CO__wave1_warp2_stg1--Arch_gfx1200
    { 0xfed32bfbu, 0x49c76e68u, 115, 65 }, // fed32bfb49c76e68 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x__P__0_2_64_32_True__CO__wave2_warp2_stg1--Arch_gfx1200
    { 0x4f40b6dau, 0x25fb3496u, 115, 178 }, // 4f40b6da25fb3496 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x__P__0_2_64_32_True__CO__wave2_warp4_stg1--Arch_gfx1200
    { 0x7f26211cu, 0x76fb53b7u, 115, 82 }, // 7f26211c76fb53b7 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x__P__0_2_64_32_True__CO__wave3_warp2_stg1--Arch_gfx1200
    { 0x3b412b2au, 0xf138266bu, 115, 16 }, // 3b412b2af138266b = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_32_F_F_0_0___gfx120x__P__0_2_64_32_True__CO__wave4_warp2_stg1--Arch_gfx1200
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx1200_mod0
{{ 1, 4, 5, 8, 6, 8, 7,21,21,10},
 { 0, 4, 7, 8, 7, 7, 6,21,17,10},
 { 2, 5, 5, 5, 7, 9, 7, 7,20,21},
 { 2,15,12,15,20,20,20,17,17,17},
 { 3,18,13,18,19,15,21,17,17,17},
 { 2,12,17,13,15,15,15,11,11,21},
 { 2,13,17,15,15,11,11,11,17,17},
 { 2,12,20,15,13,11,11,17,17,17},
 {14,16,17,11,11,11,12,11,11,11},
 {15,15,17,11,11,11,11,11,11,11}}
// End of GPU gfx1200_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A4__F208 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 0;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 0;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*bf16:16"
// B = 0
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_bz = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 32
// Head_dim = 32
// PADDED_HEAD = False
// ENABLE_DROPOUT = False
// dropout_p = 0
// philox_seed_ptr = 0
// philox_offset1 = 0
// philox_offset2 = 0
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 0
// Window_left = 0
// BIAS_TYPE = 0
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = 0
// Num_CU = "i32"

// vim: set fileencoding=utf-8

