// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A1__F184

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr std::string_view PACKAGE_PATH { R"xyzw(amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_512_T_F_0_0___gfx11xx)xyzw" };
constexpr std::string_view FUNC_NAME { R"xyzw(＊fp16@16_512_T_F_0_0)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx1151)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0xc9007669u, 0x9ca7a880u, 458, 48 }, // c90076699ca7a880 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_512_T_F_0_0___gfx11xx__P__0_2_16_16_False__CO__wave1_warp2_stg1--Arch_gfx1151
    { 0x3cd2c9beu, 0x1895a25cu, 458, 65 }, // 3cd2c9be1895a25c = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_512_T_F_0_0___gfx11xx__P__0_2_16_16_False__CO__wave2_warp2_stg1--Arch_gfx1151
    { 0xe164bc59u, 0x7b962ecbu, 458, 82 }, // e164bc597b962ecb = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_512_T_F_0_0___gfx11xx__P__0_2_16_16_False__CO__wave3_warp2_stg1--Arch_gfx1151
    { 0x91d79642u, 0xb701ce28u, 458, 16 }, // 91d79642b701ce28 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_512_T_F_0_0___gfx11xx__P__0_2_16_16_False__CO__wave4_warp2_stg1--Arch_gfx1151
    { 0x5487e782u, 0xb5b1b4f2u, 0, 263 }, // 5487e782b5b1b4f2 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_512_T_F_0_0___gfx11xx__P__0_2_32_16_False__CO__wave1_warp4_stg1--Arch_gfx1151
    { 0x0ad766d8u, 0xfd28ea07u, 0, 178 }, // 0ad766d8fd28ea07 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_512_T_F_0_0___gfx11xx__P__0_2_32_16_False__CO__wave2_warp4_stg1--Arch_gfx1151
    { 0x432d83f3u, 0xe76a5042u, 0, 146 }, // 432d83f3e76a5042 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_512_T_F_0_0___gfx11xx__P__0_2_32_16_False__CO__wave3_warp4_stg1--Arch_gfx1151
    { 0x399544f1u, 0x76a469eeu, 0, 195 }, // 399544f176a469ee = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_512_T_F_0_0___gfx11xx__P__0_2_32_16_False__CO__wave4_warp4_stg1--Arch_gfx1151
    { 0x64f5672du, 0x540f3587u, 33, 263 }, // 64f5672d540f3587 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_512_T_F_0_0___gfx11xx__P__0_2_32_16_True__CO__wave1_warp4_stg1--Arch_gfx1151
    { 0xdc05cf01u, 0xeee068b4u, 33, 178 }, // dc05cf01eee068b4 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_512_T_F_0_0___gfx11xx__P__0_2_32_16_True__CO__wave2_warp4_stg1--Arch_gfx1151
    { 0xaf2b2d03u, 0x42de3524u, 33, 146 }, // af2b2d0342de3524 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_512_T_F_0_0___gfx11xx__P__0_2_32_16_True__CO__wave3_warp4_stg1--Arch_gfx1151
    { 0xef9050a4u, 0x324207d3u, 33, 195 }, // ef9050a4324207d3 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_512_T_F_0_0___gfx11xx__P__0_2_32_16_True__CO__wave4_warp4_stg1--Arch_gfx1151
    { 0x706f3f76u, 0x485a54a3u, 489, 263 }, // 706f3f76485a54a3 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_512_T_F_0_0___gfx11xx__P__0_2_32_32_False__CO__wave1_warp4_stg1--Arch_gfx1151
    { 0xe59138e5u, 0xe93aa107u, 489, 178 }, // e59138e5e93aa107 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_512_T_F_0_0___gfx11xx__P__0_2_32_32_False__CO__wave2_warp4_stg1--Arch_gfx1151
    { 0xb214030cu, 0xaae13bdau, 489, 146 }, // b214030caae13bda = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_512_T_F_0_0___gfx11xx__P__0_2_32_32_False__CO__wave3_warp4_stg1--Arch_gfx1151
    { 0x5700d19cu, 0xdd186255u, 489, 195 }, // 5700d19cdd186255 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_512_T_F_0_0___gfx11xx__P__0_2_32_32_False__CO__wave4_warp4_stg1--Arch_gfx1151
    { 0xc443c09cu, 0xbf74b51fu, 505, 263 }, // c443c09cbf74b51f = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_512_T_F_0_0___gfx11xx__P__0_2_32_32_True__CO__wave1_warp4_stg1--Arch_gfx1151
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx1151_mod0
{{ 9, 6,10,10, 1, 2, 1, 1, 3, 2},
 {12, 4, 5, 4, 4, 4, 4,16, 3, 1},
 {16, 6, 6, 4, 5, 4,15, 4, 4, 2},
 {13, 4, 4, 7, 4, 4, 8,10, 0, 1},
 {13, 4, 6, 4, 4, 5, 4, 1, 2, 1},
 {15, 6, 6, 6, 4, 4, 1, 1, 0, 0},
 {14, 4, 5, 7, 4, 4, 8, 0, 1, 8},
 {13, 4, 7, 5, 4, 7, 3, 3, 1, 8},
 {15, 8, 5, 6, 7, 4, 4, 1, 9, 8},
 {15, 7, 7, 4,11, 5, 0, 2, 8, 8}}
// End of GPU gfx1151_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A1__F184 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 6;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 6;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*fp16:16"
// B = 0
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_bz = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 512
// Head_dim = "i32"
// PADDED_HEAD = True
// ENABLE_DROPOUT = False
// dropout_p = 0
// philox_seed_ptr = 0
// philox_offset1 = 0
// philox_offset2 = 0
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 0
// Window_left = 0
// BIAS_TYPE = 0
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = 0
// Num_CU = "i32"

// vim: set fileencoding=utf-8

