// components/printing/common/print.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_H_
#define COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "components/printing/common/print.mojom-shared.h"
#include "components/printing/common/print.mojom-forward.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "printing/mojom/print.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace printing {
namespace mojom {

class PrintRendererProxy;

template <typename ImplRefTraits>
class PrintRendererStub;

class PrintRendererRequestValidator;
class PrintRendererResponseValidator;


class  PrintRenderer
    : public PrintRendererInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = PrintRendererInterfaceBase;
  using Proxy_ = PrintRendererProxy;

  template <typename ImplRefTraits>
  using Stub_ = PrintRendererStub<ImplRefTraits>;

  using RequestValidator_ = PrintRendererRequestValidator;
  using ResponseValidator_ = PrintRendererResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreatePreviewDocumentMinVersion = 0,
  };
  virtual ~PrintRenderer() {}


  using CreatePreviewDocumentCallback = base::OnceCallback<void(::base::ReadOnlySharedMemoryRegion)>;
  
  virtual void CreatePreviewDocument(::base::Value job_settings, CreatePreviewDocumentCallback callback) = 0;
};

class PrintPreviewUIProxy;

template <typename ImplRefTraits>
class PrintPreviewUIStub;

class PrintPreviewUIRequestValidator;


class  PrintPreviewUI
    : public PrintPreviewUIInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = PrintPreviewUIInterfaceBase;
  using Proxy_ = PrintPreviewUIProxy;

  template <typename ImplRefTraits>
  using Stub_ = PrintPreviewUIStub<ImplRefTraits>;

  using RequestValidator_ = PrintPreviewUIRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetOptionsFromDocumentMinVersion = 0,
    kPrintPreviewFailedMinVersion = 0,
    kPrintPreviewCancelledMinVersion = 0,
    kPrinterSettingsInvalidMinVersion = 0,
  };
  virtual ~PrintPreviewUI() {}

  
  virtual void SetOptionsFromDocument(OptionsFromDocumentParamsPtr params, int32_t request_id) = 0;

  
  virtual void PrintPreviewFailed(int32_t document_cookie, int32_t request_id) = 0;

  
  virtual void PrintPreviewCancelled(int32_t document_cookie, int32_t request_id) = 0;

  
  virtual void PrinterSettingsInvalid(int32_t document_cookie, int32_t request_id) = 0;
};

class PrintRenderFrameProxy;

template <typename ImplRefTraits>
class PrintRenderFrameStub;

class PrintRenderFrameRequestValidator;
class PrintRenderFrameResponseValidator;


class  PrintRenderFrame
    : public PrintRenderFrameInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = PrintRenderFrameInterfaceBase;
  using Proxy_ = PrintRenderFrameProxy;

  template <typename ImplRefTraits>
  using Stub_ = PrintRenderFrameStub<ImplRefTraits>;

  using RequestValidator_ = PrintRenderFrameRequestValidator;
  using ResponseValidator_ = PrintRenderFrameResponseValidator;
  enum MethodMinVersions : uint32_t {
    kPrintRequestedPagesMinVersion = 0,
    kPrintForSystemDialogMinVersion = 0,
    kInitiatePrintPreviewMinVersion = 0,
    kSetPrintPreviewUIMinVersion = 0,
    kPrintPreviewMinVersion = 0,
    kOnPrintPreviewDialogClosedMinVersion = 0,
    kPrintFrameContentMinVersion = 0,
    kSetPrintingEnabledMinVersion = 0,
    kPrintingDoneMinVersion = 0,
    kPrintNodeUnderContextMenuMinVersion = 0,
  };
  virtual ~PrintRenderFrame() {}

  
  virtual void PrintRequestedPages() = 0;

  
  virtual void PrintForSystemDialog() = 0;

  
  virtual void InitiatePrintPreview(::mojo::PendingAssociatedRemote<PrintRenderer> print_renderer, bool has_selection) = 0;

  
  virtual void SetPrintPreviewUI(::mojo::PendingAssociatedRemote<PrintPreviewUI> preview) = 0;

  
  virtual void PrintPreview(::base::Value settings) = 0;

  
  virtual void OnPrintPreviewDialogClosed() = 0;


  using PrintFrameContentCallback = base::OnceCallback<void(int32_t, DidPrintContentParamsPtr)>;
  
  virtual void PrintFrameContent(PrintFrameContentParamsPtr params, PrintFrameContentCallback callback) = 0;

  
  virtual void SetPrintingEnabled(bool enabled) = 0;

  
  virtual void PrintingDone(bool success) = 0;

  
  virtual void PrintNodeUnderContextMenu() = 0;
};

class PrintManagerHostProxy;

template <typename ImplRefTraits>
class PrintManagerHostStub;

class PrintManagerHostRequestValidator;
class PrintManagerHostResponseValidator;


class  PrintManagerHost
    : public PrintManagerHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = true;

  using Base_ = PrintManagerHostInterfaceBase;
  using Proxy_ = PrintManagerHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = PrintManagerHostStub<ImplRefTraits>;

  using RequestValidator_ = PrintManagerHostRequestValidator;
  using ResponseValidator_ = PrintManagerHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDidGetPrintedPagesCountMinVersion = 0,
    kDidGetDocumentCookieMinVersion = 0,
    kSetAccessibilityTreeMinVersion = 0,
    kGetDefaultPrintSettingsMinVersion = 0,
    kDidShowPrintDialogMinVersion = 0,
    kShowInvalidPrinterSettingsErrorMinVersion = 0,
    kPrintingFailedMinVersion = 0,
  };
  virtual ~PrintManagerHost() {}

  
  virtual void DidGetPrintedPagesCount(int32_t cookie, uint32_t number_pages) = 0;

  
  virtual void DidGetDocumentCookie(int32_t cookie) = 0;

  
  virtual void SetAccessibilityTree(int32_t cookie, const ::ui::AXTreeUpdate& accessibility_tree) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetDefaultPrintSettings(PrintParamsPtr* out_default_settings);

  using GetDefaultPrintSettingsCallback = base::OnceCallback<void(PrintParamsPtr)>;
  
  virtual void GetDefaultPrintSettings(GetDefaultPrintSettingsCallback callback) = 0;

  
  virtual void DidShowPrintDialog() = 0;

  
  virtual void ShowInvalidPrinterSettingsError() = 0;

  
  virtual void PrintingFailed(int32_t cookie) = 0;
};



class  PrintRendererProxy
    : public PrintRenderer {
 public:
  using InterfaceType = PrintRenderer;

  explicit PrintRendererProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePreviewDocument(::base::Value job_settings, CreatePreviewDocumentCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PrintPreviewUIProxy
    : public PrintPreviewUI {
 public:
  using InterfaceType = PrintPreviewUI;

  explicit PrintPreviewUIProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetOptionsFromDocument(OptionsFromDocumentParamsPtr params, int32_t request_id) final;
  
  void PrintPreviewFailed(int32_t document_cookie, int32_t request_id) final;
  
  void PrintPreviewCancelled(int32_t document_cookie, int32_t request_id) final;
  
  void PrinterSettingsInvalid(int32_t document_cookie, int32_t request_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PrintRenderFrameProxy
    : public PrintRenderFrame {
 public:
  using InterfaceType = PrintRenderFrame;

  explicit PrintRenderFrameProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void PrintRequestedPages() final;
  
  void PrintForSystemDialog() final;
  
  void InitiatePrintPreview(::mojo::PendingAssociatedRemote<PrintRenderer> print_renderer, bool has_selection) final;
  
  void SetPrintPreviewUI(::mojo::PendingAssociatedRemote<PrintPreviewUI> preview) final;
  
  void PrintPreview(::base::Value settings) final;
  
  void OnPrintPreviewDialogClosed() final;
  
  void PrintFrameContent(PrintFrameContentParamsPtr params, PrintFrameContentCallback callback) final;
  
  void SetPrintingEnabled(bool enabled) final;
  
  void PrintingDone(bool success) final;
  
  void PrintNodeUnderContextMenu() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PrintManagerHostProxy
    : public PrintManagerHost {
 public:
  using InterfaceType = PrintManagerHost;

  explicit PrintManagerHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DidGetPrintedPagesCount(int32_t cookie, uint32_t number_pages) final;
  
  void DidGetDocumentCookie(int32_t cookie) final;
  
  void SetAccessibilityTree(int32_t cookie, const ::ui::AXTreeUpdate& accessibility_tree) final;
  
  bool GetDefaultPrintSettings(PrintParamsPtr* out_default_settings) final;
  
  void GetDefaultPrintSettings(GetDefaultPrintSettingsCallback callback) final;
  
  void DidShowPrintDialog() final;
  
  void ShowInvalidPrinterSettingsError() final;
  
  void PrintingFailed(int32_t cookie) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PrintRendererStubDispatch {
 public:
  static bool Accept(PrintRenderer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PrintRenderer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PrintRenderer>>
class PrintRendererStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PrintRendererStub() {}
  ~PrintRendererStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrintRendererStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrintRendererStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PrintPreviewUIStubDispatch {
 public:
  static bool Accept(PrintPreviewUI* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PrintPreviewUI* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PrintPreviewUI>>
class PrintPreviewUIStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PrintPreviewUIStub() {}
  ~PrintPreviewUIStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrintPreviewUIStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrintPreviewUIStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PrintRenderFrameStubDispatch {
 public:
  static bool Accept(PrintRenderFrame* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PrintRenderFrame* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PrintRenderFrame>>
class PrintRenderFrameStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PrintRenderFrameStub() {}
  ~PrintRenderFrameStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrintRenderFrameStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrintRenderFrameStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PrintManagerHostStubDispatch {
 public:
  static bool Accept(PrintManagerHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PrintManagerHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PrintManagerHost>>
class PrintManagerHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PrintManagerHostStub() {}
  ~PrintManagerHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrintManagerHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PrintManagerHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PrintRendererRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PrintPreviewUIRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PrintRenderFrameRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PrintManagerHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PrintRendererResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PrintRenderFrameResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PrintManagerHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  PreviewIds {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PreviewIds, T>::value>;
  using DataView = PreviewIdsDataView;
  using Data_ = internal::PreviewIds_Data;

  template <typename... Args>
  static PreviewIdsPtr New(Args&&... args) {
    return PreviewIdsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PreviewIdsPtr From(const U& u) {
    return mojo::TypeConverter<PreviewIdsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PreviewIds>::Convert(*this);
  }


  PreviewIds();

  PreviewIds(
      int32_t request_id,
      int32_t ui_id);

  ~PreviewIds();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PreviewIdsPtr>
  PreviewIdsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PreviewIds::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PreviewIds::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PreviewIds::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PreviewIds_UnserializedMessageContext<
            UserType, PreviewIds::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PreviewIds::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return PreviewIds::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PreviewIds_UnserializedMessageContext<
            UserType, PreviewIds::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PreviewIds::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t request_id;
  
  int32_t ui_id;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PreviewIds::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PreviewIds::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PreviewIds::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PreviewIds::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  OptionsFromDocumentParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OptionsFromDocumentParams, T>::value>;
  using DataView = OptionsFromDocumentParamsDataView;
  using Data_ = internal::OptionsFromDocumentParams_Data;

  template <typename... Args>
  static OptionsFromDocumentParamsPtr New(Args&&... args) {
    return OptionsFromDocumentParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OptionsFromDocumentParamsPtr From(const U& u) {
    return mojo::TypeConverter<OptionsFromDocumentParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OptionsFromDocumentParams>::Convert(*this);
  }


  OptionsFromDocumentParams();

  OptionsFromDocumentParams(
      bool is_scaling_disabled,
      int32_t copies,
      ::printing::mojom::DuplexMode duplex);

  ~OptionsFromDocumentParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OptionsFromDocumentParamsPtr>
  OptionsFromDocumentParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OptionsFromDocumentParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OptionsFromDocumentParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OptionsFromDocumentParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OptionsFromDocumentParams_UnserializedMessageContext<
            UserType, OptionsFromDocumentParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<OptionsFromDocumentParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return OptionsFromDocumentParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OptionsFromDocumentParams_UnserializedMessageContext<
            UserType, OptionsFromDocumentParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OptionsFromDocumentParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool is_scaling_disabled;
  
  int32_t copies;
  
  ::printing::mojom::DuplexMode duplex;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OptionsFromDocumentParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OptionsFromDocumentParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OptionsFromDocumentParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OptionsFromDocumentParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}
















class  PrintFrameContentParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrintFrameContentParams, T>::value>;
  using DataView = PrintFrameContentParamsDataView;
  using Data_ = internal::PrintFrameContentParams_Data;

  template <typename... Args>
  static PrintFrameContentParamsPtr New(Args&&... args) {
    return PrintFrameContentParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrintFrameContentParamsPtr From(const U& u) {
    return mojo::TypeConverter<PrintFrameContentParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrintFrameContentParams>::Convert(*this);
  }


  PrintFrameContentParams();

  PrintFrameContentParams(
      const ::gfx::Rect& printable_area,
      int32_t document_cookie);

  ~PrintFrameContentParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrintFrameContentParamsPtr>
  PrintFrameContentParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrintFrameContentParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrintFrameContentParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrintFrameContentParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrintFrameContentParams_UnserializedMessageContext<
            UserType, PrintFrameContentParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PrintFrameContentParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return PrintFrameContentParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrintFrameContentParams_UnserializedMessageContext<
            UserType, PrintFrameContentParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrintFrameContentParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::gfx::Rect printable_area;
  
  int32_t document_cookie;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrintFrameContentParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrintFrameContentParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrintFrameContentParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrintFrameContentParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  DidPrintContentParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DidPrintContentParams, T>::value>;
  using DataView = DidPrintContentParamsDataView;
  using Data_ = internal::DidPrintContentParams_Data;

  template <typename... Args>
  static DidPrintContentParamsPtr New(Args&&... args) {
    return DidPrintContentParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DidPrintContentParamsPtr From(const U& u) {
    return mojo::TypeConverter<DidPrintContentParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DidPrintContentParams>::Convert(*this);
  }


  DidPrintContentParams();

  DidPrintContentParams(
      ::base::ReadOnlySharedMemoryRegion metafile_data_region,
      const base::flat_map<uint32_t, ::base::UnguessableToken>& subframe_content_info);

  ~DidPrintContentParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DidPrintContentParamsPtr>
  DidPrintContentParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DidPrintContentParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DidPrintContentParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DidPrintContentParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DidPrintContentParams_UnserializedMessageContext<
            UserType, DidPrintContentParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DidPrintContentParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return DidPrintContentParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DidPrintContentParams_UnserializedMessageContext<
            UserType, DidPrintContentParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DidPrintContentParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::base::ReadOnlySharedMemoryRegion metafile_data_region;
  
  base::flat_map<uint32_t, ::base::UnguessableToken> subframe_content_info;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(DidPrintContentParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DidPrintContentParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DidPrintContentParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DidPrintContentParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DidPrintContentParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DidStartPreviewParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DidStartPreviewParams, T>::value>;
  using DataView = DidStartPreviewParamsDataView;
  using Data_ = internal::DidStartPreviewParams_Data;

  template <typename... Args>
  static DidStartPreviewParamsPtr New(Args&&... args) {
    return DidStartPreviewParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DidStartPreviewParamsPtr From(const U& u) {
    return mojo::TypeConverter<DidStartPreviewParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DidStartPreviewParams>::Convert(*this);
  }


  DidStartPreviewParams();

  DidStartPreviewParams(
      uint32_t page_count,
      std::vector<uint32_t> pages_to_render,
      int32_t pages_per_sheet,
      const ::gfx::Size& page_size,
      int32_t fit_to_page_scaling);

  ~DidStartPreviewParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DidStartPreviewParamsPtr>
  DidStartPreviewParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DidStartPreviewParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DidStartPreviewParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DidStartPreviewParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DidStartPreviewParams_UnserializedMessageContext<
            UserType, DidStartPreviewParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DidStartPreviewParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return DidStartPreviewParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DidStartPreviewParams_UnserializedMessageContext<
            UserType, DidStartPreviewParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DidStartPreviewParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t page_count;
  
  std::vector<uint32_t> pages_to_render;
  
  int32_t pages_per_sheet;
  
  ::gfx::Size page_size;
  
  int32_t fit_to_page_scaling;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DidStartPreviewParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DidStartPreviewParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DidStartPreviewParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DidStartPreviewParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DidPreviewPageParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DidPreviewPageParams, T>::value>;
  using DataView = DidPreviewPageParamsDataView;
  using Data_ = internal::DidPreviewPageParams_Data;

  template <typename... Args>
  static DidPreviewPageParamsPtr New(Args&&... args) {
    return DidPreviewPageParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DidPreviewPageParamsPtr From(const U& u) {
    return mojo::TypeConverter<DidPreviewPageParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DidPreviewPageParams>::Convert(*this);
  }


  DidPreviewPageParams();

  DidPreviewPageParams(
      DidPrintContentParamsPtr content,
      uint32_t page_number,
      int32_t document_cookie);

  ~DidPreviewPageParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DidPreviewPageParamsPtr>
  DidPreviewPageParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DidPreviewPageParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DidPreviewPageParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DidPreviewPageParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DidPreviewPageParams_UnserializedMessageContext<
            UserType, DidPreviewPageParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DidPreviewPageParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return DidPreviewPageParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DidPreviewPageParams_UnserializedMessageContext<
            UserType, DidPreviewPageParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DidPreviewPageParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  DidPrintContentParamsPtr content;
  
  uint32_t page_number;
  
  int32_t document_cookie;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(DidPreviewPageParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DidPreviewPageParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DidPreviewPageParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DidPreviewPageParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DidPreviewPageParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DidPreviewDocumentParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DidPreviewDocumentParams, T>::value>;
  using DataView = DidPreviewDocumentParamsDataView;
  using Data_ = internal::DidPreviewDocumentParams_Data;

  template <typename... Args>
  static DidPreviewDocumentParamsPtr New(Args&&... args) {
    return DidPreviewDocumentParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DidPreviewDocumentParamsPtr From(const U& u) {
    return mojo::TypeConverter<DidPreviewDocumentParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DidPreviewDocumentParams>::Convert(*this);
  }


  DidPreviewDocumentParams();

  DidPreviewDocumentParams(
      DidPrintContentParamsPtr content,
      int32_t document_cookie,
      uint32_t expected_pages_count);

  ~DidPreviewDocumentParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DidPreviewDocumentParamsPtr>
  DidPreviewDocumentParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DidPreviewDocumentParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DidPreviewDocumentParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DidPreviewDocumentParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DidPreviewDocumentParams_UnserializedMessageContext<
            UserType, DidPreviewDocumentParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DidPreviewDocumentParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return DidPreviewDocumentParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DidPreviewDocumentParams_UnserializedMessageContext<
            UserType, DidPreviewDocumentParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DidPreviewDocumentParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  DidPrintContentParamsPtr content;
  
  int32_t document_cookie;
  
  uint32_t expected_pages_count;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(DidPreviewDocumentParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DidPreviewDocumentParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DidPreviewDocumentParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DidPreviewDocumentParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DidPreviewDocumentParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PrintParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrintParams, T>::value>;
  using DataView = PrintParamsDataView;
  using Data_ = internal::PrintParams_Data;

  template <typename... Args>
  static PrintParamsPtr New(Args&&... args) {
    return PrintParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrintParamsPtr From(const U& u) {
    return mojo::TypeConverter<PrintParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrintParams>::Convert(*this);
  }


  PrintParams();

  PrintParams(
      const ::gfx::Size& page_size,
      const ::gfx::Size& content_size,
      const ::gfx::Rect& printable_area,
      int32_t margin_top,
      int32_t margin_left,
      ::printing::mojom::PageOrientation page_orientation,
      const ::gfx::Size& dpi,
      double scale_factor,
      int32_t document_cookie,
      bool selection_only,
      bool supports_alpha_blend,
      int32_t preview_ui_id,
      int32_t preview_request_id,
      bool is_first_request,
      ::printing::mojom::PrintScalingOption print_scaling_option,
      bool print_to_pdf,
      bool display_header_footer,
      const ::base::string16& title,
      const ::base::string16& url,
      const ::base::string16& header_template,
      const ::base::string16& footer_template,
      bool rasterize_pdf,
      bool should_print_backgrounds,
      ::printing::mojom::SkiaDocumentType printed_doc_type,
      bool prefer_css_page_size,
      uint32_t pages_per_sheet);

  ~PrintParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrintParamsPtr>
  PrintParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrintParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrintParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrintParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrintParams_UnserializedMessageContext<
            UserType, PrintParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PrintParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return PrintParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrintParams_UnserializedMessageContext<
            UserType, PrintParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrintParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::gfx::Size page_size;
  
  ::gfx::Size content_size;
  
  ::gfx::Rect printable_area;
  
  int32_t margin_top;
  
  int32_t margin_left;
  
  ::printing::mojom::PageOrientation page_orientation;
  
  ::gfx::Size dpi;
  
  double scale_factor;
  
  int32_t document_cookie;
  
  bool selection_only;
  
  bool supports_alpha_blend;
  
  int32_t preview_ui_id;
  
  int32_t preview_request_id;
  
  bool is_first_request;
  
  ::printing::mojom::PrintScalingOption print_scaling_option;
  
  bool print_to_pdf;
  
  bool display_header_footer;
  
  ::base::string16 title;
  
  ::base::string16 url;
  
  ::base::string16 header_template;
  
  ::base::string16 footer_template;
  
  bool rasterize_pdf;
  
  bool should_print_backgrounds;
  
  ::printing::mojom::SkiaDocumentType printed_doc_type;
  
  bool prefer_css_page_size;
  
  uint32_t pages_per_sheet;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrintParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrintParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrintParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrintParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PrintPagesParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrintPagesParams, T>::value>;
  using DataView = PrintPagesParamsDataView;
  using Data_ = internal::PrintPagesParams_Data;

  template <typename... Args>
  static PrintPagesParamsPtr New(Args&&... args) {
    return PrintPagesParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrintPagesParamsPtr From(const U& u) {
    return mojo::TypeConverter<PrintPagesParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrintPagesParams>::Convert(*this);
  }


  PrintPagesParams();

  PrintPagesParams(
      PrintParamsPtr params,
      std::vector<uint32_t> pages);

  ~PrintPagesParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrintPagesParamsPtr>
  PrintPagesParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrintPagesParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrintPagesParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrintPagesParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrintPagesParams_UnserializedMessageContext<
            UserType, PrintPagesParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PrintPagesParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return PrintPagesParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrintPagesParams_UnserializedMessageContext<
            UserType, PrintPagesParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrintPagesParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  PrintParamsPtr params;
  
  std::vector<uint32_t> pages;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(PrintPagesParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrintPagesParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrintPagesParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrintPagesParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrintPagesParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DidPrintDocumentParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DidPrintDocumentParams, T>::value>;
  using DataView = DidPrintDocumentParamsDataView;
  using Data_ = internal::DidPrintDocumentParams_Data;

  template <typename... Args>
  static DidPrintDocumentParamsPtr New(Args&&... args) {
    return DidPrintDocumentParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DidPrintDocumentParamsPtr From(const U& u) {
    return mojo::TypeConverter<DidPrintDocumentParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DidPrintDocumentParams>::Convert(*this);
  }


  DidPrintDocumentParams();

  DidPrintDocumentParams(
      DidPrintContentParamsPtr content,
      int32_t document_cookie,
      const ::gfx::Size& page_size,
      const ::gfx::Rect& content_area,
      const ::gfx::Point& physical_offsets);

  ~DidPrintDocumentParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DidPrintDocumentParamsPtr>
  DidPrintDocumentParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DidPrintDocumentParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DidPrintDocumentParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DidPrintDocumentParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DidPrintDocumentParams_UnserializedMessageContext<
            UserType, DidPrintDocumentParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DidPrintDocumentParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return DidPrintDocumentParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DidPrintDocumentParams_UnserializedMessageContext<
            UserType, DidPrintDocumentParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DidPrintDocumentParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  DidPrintContentParamsPtr content;
  
  int32_t document_cookie;
  
  ::gfx::Size page_size;
  
  ::gfx::Rect content_area;
  
  ::gfx::Point physical_offsets;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(DidPrintDocumentParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DidPrintDocumentParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DidPrintDocumentParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DidPrintDocumentParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DidPrintDocumentParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ScriptedPrintParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScriptedPrintParams, T>::value>;
  using DataView = ScriptedPrintParamsDataView;
  using Data_ = internal::ScriptedPrintParams_Data;

  template <typename... Args>
  static ScriptedPrintParamsPtr New(Args&&... args) {
    return ScriptedPrintParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScriptedPrintParamsPtr From(const U& u) {
    return mojo::TypeConverter<ScriptedPrintParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScriptedPrintParams>::Convert(*this);
  }


  ScriptedPrintParams();

  ScriptedPrintParams(
      int32_t cookie,
      uint32_t expected_pages_count,
      bool has_selection,
      bool is_scripted,
      bool is_modifiable,
      ::printing::mojom::MarginType margin_type);

  ~ScriptedPrintParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScriptedPrintParamsPtr>
  ScriptedPrintParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScriptedPrintParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScriptedPrintParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScriptedPrintParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScriptedPrintParams_UnserializedMessageContext<
            UserType, ScriptedPrintParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ScriptedPrintParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ScriptedPrintParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScriptedPrintParams_UnserializedMessageContext<
            UserType, ScriptedPrintParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScriptedPrintParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t cookie;
  
  uint32_t expected_pages_count;
  
  bool has_selection;
  
  bool is_scripted;
  
  bool is_modifiable;
  
  ::printing::mojom::MarginType margin_type;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScriptedPrintParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScriptedPrintParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScriptedPrintParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScriptedPrintParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PreviewIdsPtr PreviewIds::Clone() const {
  return New(
      mojo::Clone(request_id),
      mojo::Clone(ui_id)
  );
}

template <typename T, PreviewIds::EnableIfSame<T>*>
bool PreviewIds::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request_id, other_struct.request_id))
    return false;
  if (!mojo::Equals(this->ui_id, other_struct.ui_id))
    return false;
  return true;
}

template <typename T, PreviewIds::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.request_id, rhs.request_id))
    return true;
  if (std::less<>{}(rhs.request_id, lhs.request_id))
    return false;
  if (std::less<>{}(lhs.ui_id, rhs.ui_id))
    return true;
  if (std::less<>{}(rhs.ui_id, lhs.ui_id))
    return false;
  return false;
}
template <typename StructPtrType>
PrintFrameContentParamsPtr PrintFrameContentParams::Clone() const {
  return New(
      mojo::Clone(printable_area),
      mojo::Clone(document_cookie)
  );
}

template <typename T, PrintFrameContentParams::EnableIfSame<T>*>
bool PrintFrameContentParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->printable_area, other_struct.printable_area))
    return false;
  if (!mojo::Equals(this->document_cookie, other_struct.document_cookie))
    return false;
  return true;
}

template <typename T, PrintFrameContentParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.printable_area, rhs.printable_area))
    return true;
  if (std::less<>{}(rhs.printable_area, lhs.printable_area))
    return false;
  if (std::less<>{}(lhs.document_cookie, rhs.document_cookie))
    return true;
  if (std::less<>{}(rhs.document_cookie, lhs.document_cookie))
    return false;
  return false;
}
template <typename StructPtrType>
OptionsFromDocumentParamsPtr OptionsFromDocumentParams::Clone() const {
  return New(
      mojo::Clone(is_scaling_disabled),
      mojo::Clone(copies),
      mojo::Clone(duplex)
  );
}

template <typename T, OptionsFromDocumentParams::EnableIfSame<T>*>
bool OptionsFromDocumentParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_scaling_disabled, other_struct.is_scaling_disabled))
    return false;
  if (!mojo::Equals(this->copies, other_struct.copies))
    return false;
  if (!mojo::Equals(this->duplex, other_struct.duplex))
    return false;
  return true;
}

template <typename T, OptionsFromDocumentParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.is_scaling_disabled, rhs.is_scaling_disabled))
    return true;
  if (std::less<>{}(rhs.is_scaling_disabled, lhs.is_scaling_disabled))
    return false;
  if (std::less<>{}(lhs.copies, rhs.copies))
    return true;
  if (std::less<>{}(rhs.copies, lhs.copies))
    return false;
  if (std::less<>{}(lhs.duplex, rhs.duplex))
    return true;
  if (std::less<>{}(rhs.duplex, lhs.duplex))
    return false;
  return false;
}
template <typename StructPtrType>
DidPrintContentParamsPtr DidPrintContentParams::Clone() const {
  return New(
      mojo::Clone(metafile_data_region),
      mojo::Clone(subframe_content_info)
  );
}

template <typename T, DidPrintContentParams::EnableIfSame<T>*>
bool DidPrintContentParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->metafile_data_region, other_struct.metafile_data_region))
    return false;
  if (!mojo::Equals(this->subframe_content_info, other_struct.subframe_content_info))
    return false;
  return true;
}

template <typename T, DidPrintContentParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.metafile_data_region, rhs.metafile_data_region))
    return true;
  if (std::less<>{}(rhs.metafile_data_region, lhs.metafile_data_region))
    return false;
  if (std::less<>{}(lhs.subframe_content_info, rhs.subframe_content_info))
    return true;
  if (std::less<>{}(rhs.subframe_content_info, lhs.subframe_content_info))
    return false;
  return false;
}
template <typename StructPtrType>
DidStartPreviewParamsPtr DidStartPreviewParams::Clone() const {
  return New(
      mojo::Clone(page_count),
      mojo::Clone(pages_to_render),
      mojo::Clone(pages_per_sheet),
      mojo::Clone(page_size),
      mojo::Clone(fit_to_page_scaling)
  );
}

template <typename T, DidStartPreviewParams::EnableIfSame<T>*>
bool DidStartPreviewParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->page_count, other_struct.page_count))
    return false;
  if (!mojo::Equals(this->pages_to_render, other_struct.pages_to_render))
    return false;
  if (!mojo::Equals(this->pages_per_sheet, other_struct.pages_per_sheet))
    return false;
  if (!mojo::Equals(this->page_size, other_struct.page_size))
    return false;
  if (!mojo::Equals(this->fit_to_page_scaling, other_struct.fit_to_page_scaling))
    return false;
  return true;
}

template <typename T, DidStartPreviewParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.page_count, rhs.page_count))
    return true;
  if (std::less<>{}(rhs.page_count, lhs.page_count))
    return false;
  if (std::less<>{}(lhs.pages_to_render, rhs.pages_to_render))
    return true;
  if (std::less<>{}(rhs.pages_to_render, lhs.pages_to_render))
    return false;
  if (std::less<>{}(lhs.pages_per_sheet, rhs.pages_per_sheet))
    return true;
  if (std::less<>{}(rhs.pages_per_sheet, lhs.pages_per_sheet))
    return false;
  if (std::less<>{}(lhs.page_size, rhs.page_size))
    return true;
  if (std::less<>{}(rhs.page_size, lhs.page_size))
    return false;
  if (std::less<>{}(lhs.fit_to_page_scaling, rhs.fit_to_page_scaling))
    return true;
  if (std::less<>{}(rhs.fit_to_page_scaling, lhs.fit_to_page_scaling))
    return false;
  return false;
}
template <typename StructPtrType>
DidPreviewPageParamsPtr DidPreviewPageParams::Clone() const {
  return New(
      mojo::Clone(content),
      mojo::Clone(page_number),
      mojo::Clone(document_cookie)
  );
}

template <typename T, DidPreviewPageParams::EnableIfSame<T>*>
bool DidPreviewPageParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->content, other_struct.content))
    return false;
  if (!mojo::Equals(this->page_number, other_struct.page_number))
    return false;
  if (!mojo::Equals(this->document_cookie, other_struct.document_cookie))
    return false;
  return true;
}

template <typename T, DidPreviewPageParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.content, rhs.content))
    return true;
  if (std::less<>{}(rhs.content, lhs.content))
    return false;
  if (std::less<>{}(lhs.page_number, rhs.page_number))
    return true;
  if (std::less<>{}(rhs.page_number, lhs.page_number))
    return false;
  if (std::less<>{}(lhs.document_cookie, rhs.document_cookie))
    return true;
  if (std::less<>{}(rhs.document_cookie, lhs.document_cookie))
    return false;
  return false;
}
template <typename StructPtrType>
DidPreviewDocumentParamsPtr DidPreviewDocumentParams::Clone() const {
  return New(
      mojo::Clone(content),
      mojo::Clone(document_cookie),
      mojo::Clone(expected_pages_count)
  );
}

template <typename T, DidPreviewDocumentParams::EnableIfSame<T>*>
bool DidPreviewDocumentParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->content, other_struct.content))
    return false;
  if (!mojo::Equals(this->document_cookie, other_struct.document_cookie))
    return false;
  if (!mojo::Equals(this->expected_pages_count, other_struct.expected_pages_count))
    return false;
  return true;
}

template <typename T, DidPreviewDocumentParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.content, rhs.content))
    return true;
  if (std::less<>{}(rhs.content, lhs.content))
    return false;
  if (std::less<>{}(lhs.document_cookie, rhs.document_cookie))
    return true;
  if (std::less<>{}(rhs.document_cookie, lhs.document_cookie))
    return false;
  if (std::less<>{}(lhs.expected_pages_count, rhs.expected_pages_count))
    return true;
  if (std::less<>{}(rhs.expected_pages_count, lhs.expected_pages_count))
    return false;
  return false;
}
template <typename StructPtrType>
PrintParamsPtr PrintParams::Clone() const {
  return New(
      mojo::Clone(page_size),
      mojo::Clone(content_size),
      mojo::Clone(printable_area),
      mojo::Clone(margin_top),
      mojo::Clone(margin_left),
      mojo::Clone(page_orientation),
      mojo::Clone(dpi),
      mojo::Clone(scale_factor),
      mojo::Clone(document_cookie),
      mojo::Clone(selection_only),
      mojo::Clone(supports_alpha_blend),
      mojo::Clone(preview_ui_id),
      mojo::Clone(preview_request_id),
      mojo::Clone(is_first_request),
      mojo::Clone(print_scaling_option),
      mojo::Clone(print_to_pdf),
      mojo::Clone(display_header_footer),
      mojo::Clone(title),
      mojo::Clone(url),
      mojo::Clone(header_template),
      mojo::Clone(footer_template),
      mojo::Clone(rasterize_pdf),
      mojo::Clone(should_print_backgrounds),
      mojo::Clone(printed_doc_type),
      mojo::Clone(prefer_css_page_size),
      mojo::Clone(pages_per_sheet)
  );
}

template <typename T, PrintParams::EnableIfSame<T>*>
bool PrintParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->page_size, other_struct.page_size))
    return false;
  if (!mojo::Equals(this->content_size, other_struct.content_size))
    return false;
  if (!mojo::Equals(this->printable_area, other_struct.printable_area))
    return false;
  if (!mojo::Equals(this->margin_top, other_struct.margin_top))
    return false;
  if (!mojo::Equals(this->margin_left, other_struct.margin_left))
    return false;
  if (!mojo::Equals(this->page_orientation, other_struct.page_orientation))
    return false;
  if (!mojo::Equals(this->dpi, other_struct.dpi))
    return false;
  if (!mojo::Equals(this->scale_factor, other_struct.scale_factor))
    return false;
  if (!mojo::Equals(this->document_cookie, other_struct.document_cookie))
    return false;
  if (!mojo::Equals(this->selection_only, other_struct.selection_only))
    return false;
  if (!mojo::Equals(this->supports_alpha_blend, other_struct.supports_alpha_blend))
    return false;
  if (!mojo::Equals(this->preview_ui_id, other_struct.preview_ui_id))
    return false;
  if (!mojo::Equals(this->preview_request_id, other_struct.preview_request_id))
    return false;
  if (!mojo::Equals(this->is_first_request, other_struct.is_first_request))
    return false;
  if (!mojo::Equals(this->print_scaling_option, other_struct.print_scaling_option))
    return false;
  if (!mojo::Equals(this->print_to_pdf, other_struct.print_to_pdf))
    return false;
  if (!mojo::Equals(this->display_header_footer, other_struct.display_header_footer))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->header_template, other_struct.header_template))
    return false;
  if (!mojo::Equals(this->footer_template, other_struct.footer_template))
    return false;
  if (!mojo::Equals(this->rasterize_pdf, other_struct.rasterize_pdf))
    return false;
  if (!mojo::Equals(this->should_print_backgrounds, other_struct.should_print_backgrounds))
    return false;
  if (!mojo::Equals(this->printed_doc_type, other_struct.printed_doc_type))
    return false;
  if (!mojo::Equals(this->prefer_css_page_size, other_struct.prefer_css_page_size))
    return false;
  if (!mojo::Equals(this->pages_per_sheet, other_struct.pages_per_sheet))
    return false;
  return true;
}

template <typename T, PrintParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.page_size, rhs.page_size))
    return true;
  if (std::less<>{}(rhs.page_size, lhs.page_size))
    return false;
  if (std::less<>{}(lhs.content_size, rhs.content_size))
    return true;
  if (std::less<>{}(rhs.content_size, lhs.content_size))
    return false;
  if (std::less<>{}(lhs.printable_area, rhs.printable_area))
    return true;
  if (std::less<>{}(rhs.printable_area, lhs.printable_area))
    return false;
  if (std::less<>{}(lhs.margin_top, rhs.margin_top))
    return true;
  if (std::less<>{}(rhs.margin_top, lhs.margin_top))
    return false;
  if (std::less<>{}(lhs.margin_left, rhs.margin_left))
    return true;
  if (std::less<>{}(rhs.margin_left, lhs.margin_left))
    return false;
  if (std::less<>{}(lhs.page_orientation, rhs.page_orientation))
    return true;
  if (std::less<>{}(rhs.page_orientation, lhs.page_orientation))
    return false;
  if (std::less<>{}(lhs.dpi, rhs.dpi))
    return true;
  if (std::less<>{}(rhs.dpi, lhs.dpi))
    return false;
  if (std::less<>{}(lhs.scale_factor, rhs.scale_factor))
    return true;
  if (std::less<>{}(rhs.scale_factor, lhs.scale_factor))
    return false;
  if (std::less<>{}(lhs.document_cookie, rhs.document_cookie))
    return true;
  if (std::less<>{}(rhs.document_cookie, lhs.document_cookie))
    return false;
  if (std::less<>{}(lhs.selection_only, rhs.selection_only))
    return true;
  if (std::less<>{}(rhs.selection_only, lhs.selection_only))
    return false;
  if (std::less<>{}(lhs.supports_alpha_blend, rhs.supports_alpha_blend))
    return true;
  if (std::less<>{}(rhs.supports_alpha_blend, lhs.supports_alpha_blend))
    return false;
  if (std::less<>{}(lhs.preview_ui_id, rhs.preview_ui_id))
    return true;
  if (std::less<>{}(rhs.preview_ui_id, lhs.preview_ui_id))
    return false;
  if (std::less<>{}(lhs.preview_request_id, rhs.preview_request_id))
    return true;
  if (std::less<>{}(rhs.preview_request_id, lhs.preview_request_id))
    return false;
  if (std::less<>{}(lhs.is_first_request, rhs.is_first_request))
    return true;
  if (std::less<>{}(rhs.is_first_request, lhs.is_first_request))
    return false;
  if (std::less<>{}(lhs.print_scaling_option, rhs.print_scaling_option))
    return true;
  if (std::less<>{}(rhs.print_scaling_option, lhs.print_scaling_option))
    return false;
  if (std::less<>{}(lhs.print_to_pdf, rhs.print_to_pdf))
    return true;
  if (std::less<>{}(rhs.print_to_pdf, lhs.print_to_pdf))
    return false;
  if (std::less<>{}(lhs.display_header_footer, rhs.display_header_footer))
    return true;
  if (std::less<>{}(rhs.display_header_footer, lhs.display_header_footer))
    return false;
  if (std::less<>{}(lhs.title, rhs.title))
    return true;
  if (std::less<>{}(rhs.title, lhs.title))
    return false;
  if (std::less<>{}(lhs.url, rhs.url))
    return true;
  if (std::less<>{}(rhs.url, lhs.url))
    return false;
  if (std::less<>{}(lhs.header_template, rhs.header_template))
    return true;
  if (std::less<>{}(rhs.header_template, lhs.header_template))
    return false;
  if (std::less<>{}(lhs.footer_template, rhs.footer_template))
    return true;
  if (std::less<>{}(rhs.footer_template, lhs.footer_template))
    return false;
  if (std::less<>{}(lhs.rasterize_pdf, rhs.rasterize_pdf))
    return true;
  if (std::less<>{}(rhs.rasterize_pdf, lhs.rasterize_pdf))
    return false;
  if (std::less<>{}(lhs.should_print_backgrounds, rhs.should_print_backgrounds))
    return true;
  if (std::less<>{}(rhs.should_print_backgrounds, lhs.should_print_backgrounds))
    return false;
  if (std::less<>{}(lhs.printed_doc_type, rhs.printed_doc_type))
    return true;
  if (std::less<>{}(rhs.printed_doc_type, lhs.printed_doc_type))
    return false;
  if (std::less<>{}(lhs.prefer_css_page_size, rhs.prefer_css_page_size))
    return true;
  if (std::less<>{}(rhs.prefer_css_page_size, lhs.prefer_css_page_size))
    return false;
  if (std::less<>{}(lhs.pages_per_sheet, rhs.pages_per_sheet))
    return true;
  if (std::less<>{}(rhs.pages_per_sheet, lhs.pages_per_sheet))
    return false;
  return false;
}
template <typename StructPtrType>
PrintPagesParamsPtr PrintPagesParams::Clone() const {
  return New(
      mojo::Clone(params),
      mojo::Clone(pages)
  );
}

template <typename T, PrintPagesParams::EnableIfSame<T>*>
bool PrintPagesParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->params, other_struct.params))
    return false;
  if (!mojo::Equals(this->pages, other_struct.pages))
    return false;
  return true;
}

template <typename T, PrintPagesParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.params, rhs.params))
    return true;
  if (std::less<>{}(rhs.params, lhs.params))
    return false;
  if (std::less<>{}(lhs.pages, rhs.pages))
    return true;
  if (std::less<>{}(rhs.pages, lhs.pages))
    return false;
  return false;
}
template <typename StructPtrType>
DidPrintDocumentParamsPtr DidPrintDocumentParams::Clone() const {
  return New(
      mojo::Clone(content),
      mojo::Clone(document_cookie),
      mojo::Clone(page_size),
      mojo::Clone(content_area),
      mojo::Clone(physical_offsets)
  );
}

template <typename T, DidPrintDocumentParams::EnableIfSame<T>*>
bool DidPrintDocumentParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->content, other_struct.content))
    return false;
  if (!mojo::Equals(this->document_cookie, other_struct.document_cookie))
    return false;
  if (!mojo::Equals(this->page_size, other_struct.page_size))
    return false;
  if (!mojo::Equals(this->content_area, other_struct.content_area))
    return false;
  if (!mojo::Equals(this->physical_offsets, other_struct.physical_offsets))
    return false;
  return true;
}

template <typename T, DidPrintDocumentParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.content, rhs.content))
    return true;
  if (std::less<>{}(rhs.content, lhs.content))
    return false;
  if (std::less<>{}(lhs.document_cookie, rhs.document_cookie))
    return true;
  if (std::less<>{}(rhs.document_cookie, lhs.document_cookie))
    return false;
  if (std::less<>{}(lhs.page_size, rhs.page_size))
    return true;
  if (std::less<>{}(rhs.page_size, lhs.page_size))
    return false;
  if (std::less<>{}(lhs.content_area, rhs.content_area))
    return true;
  if (std::less<>{}(rhs.content_area, lhs.content_area))
    return false;
  if (std::less<>{}(lhs.physical_offsets, rhs.physical_offsets))
    return true;
  if (std::less<>{}(rhs.physical_offsets, lhs.physical_offsets))
    return false;
  return false;
}
template <typename StructPtrType>
ScriptedPrintParamsPtr ScriptedPrintParams::Clone() const {
  return New(
      mojo::Clone(cookie),
      mojo::Clone(expected_pages_count),
      mojo::Clone(has_selection),
      mojo::Clone(is_scripted),
      mojo::Clone(is_modifiable),
      mojo::Clone(margin_type)
  );
}

template <typename T, ScriptedPrintParams::EnableIfSame<T>*>
bool ScriptedPrintParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cookie, other_struct.cookie))
    return false;
  if (!mojo::Equals(this->expected_pages_count, other_struct.expected_pages_count))
    return false;
  if (!mojo::Equals(this->has_selection, other_struct.has_selection))
    return false;
  if (!mojo::Equals(this->is_scripted, other_struct.is_scripted))
    return false;
  if (!mojo::Equals(this->is_modifiable, other_struct.is_modifiable))
    return false;
  if (!mojo::Equals(this->margin_type, other_struct.margin_type))
    return false;
  return true;
}

template <typename T, ScriptedPrintParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.cookie, rhs.cookie))
    return true;
  if (std::less<>{}(rhs.cookie, lhs.cookie))
    return false;
  if (std::less<>{}(lhs.expected_pages_count, rhs.expected_pages_count))
    return true;
  if (std::less<>{}(rhs.expected_pages_count, lhs.expected_pages_count))
    return false;
  if (std::less<>{}(lhs.has_selection, rhs.has_selection))
    return true;
  if (std::less<>{}(rhs.has_selection, lhs.has_selection))
    return false;
  if (std::less<>{}(lhs.is_scripted, rhs.is_scripted))
    return true;
  if (std::less<>{}(rhs.is_scripted, lhs.is_scripted))
    return false;
  if (std::less<>{}(lhs.is_modifiable, rhs.is_modifiable))
    return true;
  if (std::less<>{}(rhs.is_modifiable, lhs.is_modifiable))
    return false;
  if (std::less<>{}(lhs.margin_type, rhs.margin_type))
    return true;
  if (std::less<>{}(rhs.margin_type, lhs.margin_type))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace printing

namespace mojo {


template <>
struct  StructTraits<::printing::mojom::PreviewIds::DataView,
                                         ::printing::mojom::PreviewIdsPtr> {
  static bool IsNull(const ::printing::mojom::PreviewIdsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PreviewIdsPtr* output) { output->reset(); }

  static decltype(::printing::mojom::PreviewIds::request_id) request_id(
      const ::printing::mojom::PreviewIdsPtr& input) {
    return input->request_id;
  }

  static decltype(::printing::mojom::PreviewIds::ui_id) ui_id(
      const ::printing::mojom::PreviewIdsPtr& input) {
    return input->ui_id;
  }

  static bool Read(::printing::mojom::PreviewIds::DataView input, ::printing::mojom::PreviewIdsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::PrintFrameContentParams::DataView,
                                         ::printing::mojom::PrintFrameContentParamsPtr> {
  static bool IsNull(const ::printing::mojom::PrintFrameContentParamsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PrintFrameContentParamsPtr* output) { output->reset(); }

  static const decltype(::printing::mojom::PrintFrameContentParams::printable_area)& printable_area(
      const ::printing::mojom::PrintFrameContentParamsPtr& input) {
    return input->printable_area;
  }

  static decltype(::printing::mojom::PrintFrameContentParams::document_cookie) document_cookie(
      const ::printing::mojom::PrintFrameContentParamsPtr& input) {
    return input->document_cookie;
  }

  static bool Read(::printing::mojom::PrintFrameContentParams::DataView input, ::printing::mojom::PrintFrameContentParamsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::OptionsFromDocumentParams::DataView,
                                         ::printing::mojom::OptionsFromDocumentParamsPtr> {
  static bool IsNull(const ::printing::mojom::OptionsFromDocumentParamsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::OptionsFromDocumentParamsPtr* output) { output->reset(); }

  static decltype(::printing::mojom::OptionsFromDocumentParams::is_scaling_disabled) is_scaling_disabled(
      const ::printing::mojom::OptionsFromDocumentParamsPtr& input) {
    return input->is_scaling_disabled;
  }

  static decltype(::printing::mojom::OptionsFromDocumentParams::copies) copies(
      const ::printing::mojom::OptionsFromDocumentParamsPtr& input) {
    return input->copies;
  }

  static decltype(::printing::mojom::OptionsFromDocumentParams::duplex) duplex(
      const ::printing::mojom::OptionsFromDocumentParamsPtr& input) {
    return input->duplex;
  }

  static bool Read(::printing::mojom::OptionsFromDocumentParams::DataView input, ::printing::mojom::OptionsFromDocumentParamsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::DidPrintContentParams::DataView,
                                         ::printing::mojom::DidPrintContentParamsPtr> {
  static bool IsNull(const ::printing::mojom::DidPrintContentParamsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::DidPrintContentParamsPtr* output) { output->reset(); }

  static  decltype(::printing::mojom::DidPrintContentParams::metafile_data_region)& metafile_data_region(
       ::printing::mojom::DidPrintContentParamsPtr& input) {
    return input->metafile_data_region;
  }

  static const decltype(::printing::mojom::DidPrintContentParams::subframe_content_info)& subframe_content_info(
      const ::printing::mojom::DidPrintContentParamsPtr& input) {
    return input->subframe_content_info;
  }

  static bool Read(::printing::mojom::DidPrintContentParams::DataView input, ::printing::mojom::DidPrintContentParamsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::DidStartPreviewParams::DataView,
                                         ::printing::mojom::DidStartPreviewParamsPtr> {
  static bool IsNull(const ::printing::mojom::DidStartPreviewParamsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::DidStartPreviewParamsPtr* output) { output->reset(); }

  static decltype(::printing::mojom::DidStartPreviewParams::page_count) page_count(
      const ::printing::mojom::DidStartPreviewParamsPtr& input) {
    return input->page_count;
  }

  static const decltype(::printing::mojom::DidStartPreviewParams::pages_to_render)& pages_to_render(
      const ::printing::mojom::DidStartPreviewParamsPtr& input) {
    return input->pages_to_render;
  }

  static decltype(::printing::mojom::DidStartPreviewParams::pages_per_sheet) pages_per_sheet(
      const ::printing::mojom::DidStartPreviewParamsPtr& input) {
    return input->pages_per_sheet;
  }

  static const decltype(::printing::mojom::DidStartPreviewParams::page_size)& page_size(
      const ::printing::mojom::DidStartPreviewParamsPtr& input) {
    return input->page_size;
  }

  static decltype(::printing::mojom::DidStartPreviewParams::fit_to_page_scaling) fit_to_page_scaling(
      const ::printing::mojom::DidStartPreviewParamsPtr& input) {
    return input->fit_to_page_scaling;
  }

  static bool Read(::printing::mojom::DidStartPreviewParams::DataView input, ::printing::mojom::DidStartPreviewParamsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::DidPreviewPageParams::DataView,
                                         ::printing::mojom::DidPreviewPageParamsPtr> {
  static bool IsNull(const ::printing::mojom::DidPreviewPageParamsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::DidPreviewPageParamsPtr* output) { output->reset(); }

  static  decltype(::printing::mojom::DidPreviewPageParams::content)& content(
       ::printing::mojom::DidPreviewPageParamsPtr& input) {
    return input->content;
  }

  static decltype(::printing::mojom::DidPreviewPageParams::page_number) page_number(
      const ::printing::mojom::DidPreviewPageParamsPtr& input) {
    return input->page_number;
  }

  static decltype(::printing::mojom::DidPreviewPageParams::document_cookie) document_cookie(
      const ::printing::mojom::DidPreviewPageParamsPtr& input) {
    return input->document_cookie;
  }

  static bool Read(::printing::mojom::DidPreviewPageParams::DataView input, ::printing::mojom::DidPreviewPageParamsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::DidPreviewDocumentParams::DataView,
                                         ::printing::mojom::DidPreviewDocumentParamsPtr> {
  static bool IsNull(const ::printing::mojom::DidPreviewDocumentParamsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::DidPreviewDocumentParamsPtr* output) { output->reset(); }

  static  decltype(::printing::mojom::DidPreviewDocumentParams::content)& content(
       ::printing::mojom::DidPreviewDocumentParamsPtr& input) {
    return input->content;
  }

  static decltype(::printing::mojom::DidPreviewDocumentParams::document_cookie) document_cookie(
      const ::printing::mojom::DidPreviewDocumentParamsPtr& input) {
    return input->document_cookie;
  }

  static decltype(::printing::mojom::DidPreviewDocumentParams::expected_pages_count) expected_pages_count(
      const ::printing::mojom::DidPreviewDocumentParamsPtr& input) {
    return input->expected_pages_count;
  }

  static bool Read(::printing::mojom::DidPreviewDocumentParams::DataView input, ::printing::mojom::DidPreviewDocumentParamsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::PrintParams::DataView,
                                         ::printing::mojom::PrintParamsPtr> {
  static bool IsNull(const ::printing::mojom::PrintParamsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PrintParamsPtr* output) { output->reset(); }

  static const decltype(::printing::mojom::PrintParams::page_size)& page_size(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->page_size;
  }

  static const decltype(::printing::mojom::PrintParams::content_size)& content_size(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->content_size;
  }

  static const decltype(::printing::mojom::PrintParams::printable_area)& printable_area(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->printable_area;
  }

  static decltype(::printing::mojom::PrintParams::margin_top) margin_top(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->margin_top;
  }

  static decltype(::printing::mojom::PrintParams::margin_left) margin_left(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->margin_left;
  }

  static decltype(::printing::mojom::PrintParams::page_orientation) page_orientation(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->page_orientation;
  }

  static const decltype(::printing::mojom::PrintParams::dpi)& dpi(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->dpi;
  }

  static decltype(::printing::mojom::PrintParams::scale_factor) scale_factor(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->scale_factor;
  }

  static decltype(::printing::mojom::PrintParams::document_cookie) document_cookie(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->document_cookie;
  }

  static decltype(::printing::mojom::PrintParams::selection_only) selection_only(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->selection_only;
  }

  static decltype(::printing::mojom::PrintParams::supports_alpha_blend) supports_alpha_blend(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->supports_alpha_blend;
  }

  static decltype(::printing::mojom::PrintParams::preview_ui_id) preview_ui_id(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->preview_ui_id;
  }

  static decltype(::printing::mojom::PrintParams::preview_request_id) preview_request_id(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->preview_request_id;
  }

  static decltype(::printing::mojom::PrintParams::is_first_request) is_first_request(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->is_first_request;
  }

  static decltype(::printing::mojom::PrintParams::print_scaling_option) print_scaling_option(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->print_scaling_option;
  }

  static decltype(::printing::mojom::PrintParams::print_to_pdf) print_to_pdf(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->print_to_pdf;
  }

  static decltype(::printing::mojom::PrintParams::display_header_footer) display_header_footer(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->display_header_footer;
  }

  static const decltype(::printing::mojom::PrintParams::title)& title(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->title;
  }

  static const decltype(::printing::mojom::PrintParams::url)& url(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->url;
  }

  static const decltype(::printing::mojom::PrintParams::header_template)& header_template(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->header_template;
  }

  static const decltype(::printing::mojom::PrintParams::footer_template)& footer_template(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->footer_template;
  }

  static decltype(::printing::mojom::PrintParams::rasterize_pdf) rasterize_pdf(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->rasterize_pdf;
  }

  static decltype(::printing::mojom::PrintParams::should_print_backgrounds) should_print_backgrounds(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->should_print_backgrounds;
  }

  static decltype(::printing::mojom::PrintParams::printed_doc_type) printed_doc_type(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->printed_doc_type;
  }

  static decltype(::printing::mojom::PrintParams::prefer_css_page_size) prefer_css_page_size(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->prefer_css_page_size;
  }

  static decltype(::printing::mojom::PrintParams::pages_per_sheet) pages_per_sheet(
      const ::printing::mojom::PrintParamsPtr& input) {
    return input->pages_per_sheet;
  }

  static bool Read(::printing::mojom::PrintParams::DataView input, ::printing::mojom::PrintParamsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::PrintPagesParams::DataView,
                                         ::printing::mojom::PrintPagesParamsPtr> {
  static bool IsNull(const ::printing::mojom::PrintPagesParamsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PrintPagesParamsPtr* output) { output->reset(); }

  static const decltype(::printing::mojom::PrintPagesParams::params)& params(
      const ::printing::mojom::PrintPagesParamsPtr& input) {
    return input->params;
  }

  static const decltype(::printing::mojom::PrintPagesParams::pages)& pages(
      const ::printing::mojom::PrintPagesParamsPtr& input) {
    return input->pages;
  }

  static bool Read(::printing::mojom::PrintPagesParams::DataView input, ::printing::mojom::PrintPagesParamsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::DidPrintDocumentParams::DataView,
                                         ::printing::mojom::DidPrintDocumentParamsPtr> {
  static bool IsNull(const ::printing::mojom::DidPrintDocumentParamsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::DidPrintDocumentParamsPtr* output) { output->reset(); }

  static  decltype(::printing::mojom::DidPrintDocumentParams::content)& content(
       ::printing::mojom::DidPrintDocumentParamsPtr& input) {
    return input->content;
  }

  static decltype(::printing::mojom::DidPrintDocumentParams::document_cookie) document_cookie(
      const ::printing::mojom::DidPrintDocumentParamsPtr& input) {
    return input->document_cookie;
  }

  static const decltype(::printing::mojom::DidPrintDocumentParams::page_size)& page_size(
      const ::printing::mojom::DidPrintDocumentParamsPtr& input) {
    return input->page_size;
  }

  static const decltype(::printing::mojom::DidPrintDocumentParams::content_area)& content_area(
      const ::printing::mojom::DidPrintDocumentParamsPtr& input) {
    return input->content_area;
  }

  static const decltype(::printing::mojom::DidPrintDocumentParams::physical_offsets)& physical_offsets(
      const ::printing::mojom::DidPrintDocumentParamsPtr& input) {
    return input->physical_offsets;
  }

  static bool Read(::printing::mojom::DidPrintDocumentParams::DataView input, ::printing::mojom::DidPrintDocumentParamsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::ScriptedPrintParams::DataView,
                                         ::printing::mojom::ScriptedPrintParamsPtr> {
  static bool IsNull(const ::printing::mojom::ScriptedPrintParamsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::ScriptedPrintParamsPtr* output) { output->reset(); }

  static decltype(::printing::mojom::ScriptedPrintParams::cookie) cookie(
      const ::printing::mojom::ScriptedPrintParamsPtr& input) {
    return input->cookie;
  }

  static decltype(::printing::mojom::ScriptedPrintParams::expected_pages_count) expected_pages_count(
      const ::printing::mojom::ScriptedPrintParamsPtr& input) {
    return input->expected_pages_count;
  }

  static decltype(::printing::mojom::ScriptedPrintParams::has_selection) has_selection(
      const ::printing::mojom::ScriptedPrintParamsPtr& input) {
    return input->has_selection;
  }

  static decltype(::printing::mojom::ScriptedPrintParams::is_scripted) is_scripted(
      const ::printing::mojom::ScriptedPrintParamsPtr& input) {
    return input->is_scripted;
  }

  static decltype(::printing::mojom::ScriptedPrintParams::is_modifiable) is_modifiable(
      const ::printing::mojom::ScriptedPrintParamsPtr& input) {
    return input->is_modifiable;
  }

  static decltype(::printing::mojom::ScriptedPrintParams::margin_type) margin_type(
      const ::printing::mojom::ScriptedPrintParamsPtr& input) {
    return input->margin_type;
  }

  static bool Read(::printing::mojom::ScriptedPrintParams::DataView input, ::printing::mojom::ScriptedPrintParamsPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_H_