// services/device/public/mojom/wake_lock_context.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/wake_lock_context.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/device/public/mojom/wake_lock_context.mojom-params-data.h"
#include "services/device/public/mojom/wake_lock_context.mojom-shared-message-ids.h"

#include "services/device/public/mojom/wake_lock_context.mojom-import-headers.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_WAKE_LOCK_CONTEXT_MOJOM_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_WAKE_LOCK_CONTEXT_MOJOM_JUMBO_H_
#endif
namespace device {
namespace mojom {
const char WakeLockContext::Name_[] = "device.mojom.WakeLockContext";

WakeLockContextProxy::WakeLockContextProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WakeLockContextProxy::GetWakeLock(
    ::device::mojom::WakeLockType in_type, ::device::mojom::WakeLockReason in_reason, const std::string& in_description, ::mojo::PendingReceiver<::device::mojom::WakeLock> in_wake_lock) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::WakeLockContext::GetWakeLock", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("type", base::trace_event::ValueToString(in_type));
      raw_value->SetString("reason", base::trace_event::ValueToString(in_reason));
      raw_value->SetString("description", in_description);
      raw_value->SetBoolean("wake_lock", in_wake_lock.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWakeLockContext_GetWakeLock_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::WakeLockContext_GetWakeLock_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::device::mojom::WakeLockType>(
      in_type, &params->type);
  mojo::internal::Serialize<::device::mojom::WakeLockReason>(
      in_reason, &params->reason);
  typename decltype(params->description)::BaseType::BufferWriter
      description_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_description, buffer, &description_writer, &serialization_context);
  params->description.Set(
      description_writer.is_null() ? nullptr : description_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->description.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null description in WakeLockContext.GetWakeLock request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::WakeLockInterfaceBase>>(
      in_wake_lock, &params->wake_lock, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->wake_lock),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid wake_lock in WakeLockContext.GetWakeLock request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WakeLockContext::Name_);
  message.set_method_name("GetWakeLock");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WakeLockContextStubDispatch::Accept(
    WakeLockContext* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kWakeLockContext_GetWakeLock_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::WakeLockContext::GetWakeLock",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::WakeLockContext::GetWakeLock");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WakeLockContext_GetWakeLock_Params_Data* params =
          reinterpret_cast<internal::WakeLockContext_GetWakeLock_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::device::mojom::WakeLockType p_type{};
      ::device::mojom::WakeLockReason p_reason{};
      std::string p_description{};
      ::mojo::PendingReceiver<::device::mojom::WakeLock> p_wake_lock{};
      WakeLockContext_GetWakeLock_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (success && !input_data_view.ReadDescription(&p_description))
        success = false;
      if (success) {
        p_wake_lock =
            input_data_view.TakeWakeLock<decltype(p_wake_lock)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WakeLockContext::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetWakeLock(
std::move(p_type), 
std::move(p_reason), 
std::move(p_description), 
std::move(p_wake_lock));
      return true;
    }
  }
  return false;
}

// static
bool WakeLockContextStubDispatch::AcceptWithResponder(
    WakeLockContext* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWakeLockContext_GetWakeLock_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWakeLockContextValidationInfo[] = {
    {internal::kWakeLockContext_GetWakeLock_Name,
     {&internal::WakeLockContext_GetWakeLock_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WakeLockContextRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::WakeLockContext::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWakeLockContextValidationInfo);
}

}  // namespace mojom
}  // namespace device

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif