// services/network/public/mojom/url_response_head.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/url_response_head.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/url_response_head.mojom-params-data.h"
#include "services/network/public/mojom/url_response_head.mojom-shared-message-ids.h"

#include "services/network/public/mojom/url_response_head.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
URLResponseHead::URLResponseHead()
    : request_time(),
      response_time(),
      headers(),
      mime_type(),
      charset(),
      ct_policy_compliance(),
      content_length(-1),
      encoded_data_length(-1),
      encoded_body_length(-1),
      network_accessed(false),
      appcache_id(0),
      appcache_manifest_url(),
      load_timing(),
      raw_request_response_info(),
      was_fetched_via_spdy(false),
      was_alpn_negotiated(false),
      was_alternate_protocol_available(false),
      connection_info(),
      alpn_negotiated_protocol(),
      remote_endpoint(),
      was_fetched_via_cache(false),
      proxy_server(),
      was_fetched_via_service_worker(false),
      service_worker_response_source(::network::mojom::FetchResponseSource::kUnspecified),
      was_fallback_required_by_service_worker(false),
      url_list_via_service_worker(),
      response_type(::network::mojom::FetchResponseType::kDefault),
      padding(0),
      cache_storage_cache_name(),
      cert_status(0U),
      ssl_info(),
      cors_exposed_header_names(),
      did_service_worker_navigation_preload(false),
      should_report_corb_blocking(false),
      async_revalidation_requested(false),
      did_mime_sniff(false),
      is_signed_exchange_inner_response(false),
      was_in_prefetch_cache(false),
      was_cookie_in_request(false),
      intercepted_by_plugin(false),
      is_legacy_tls_version(false),
      has_range_requested(false),
      timing_allow_passed(false),
      auth_challenge_info(),
      request_start(),
      response_start(),
      parsed_headers(),
      origin_policy(),
      recursive_prefetch_token() {}

URLResponseHead::URLResponseHead(
    ::base::Time request_time_in,
    ::base::Time response_time_in,
    const ::scoped_refptr<::net::HttpResponseHeaders>& headers_in,
    const std::string& mime_type_in,
    const std::string& charset_in,
    ::net::ct::CTPolicyCompliance ct_policy_compliance_in,
    int64_t content_length_in,
    int64_t encoded_data_length_in,
    int64_t encoded_body_length_in,
    bool network_accessed_in,
    int64_t appcache_id_in,
    const ::GURL& appcache_manifest_url_in,
    const ::net::LoadTimingInfo& load_timing_in,
    ::network::mojom::HttpRawRequestResponseInfoPtr raw_request_response_info_in,
    bool was_fetched_via_spdy_in,
    bool was_alpn_negotiated_in,
    bool was_alternate_protocol_available_in,
    ::net::HttpResponseInfo::ConnectionInfo connection_info_in,
    const std::string& alpn_negotiated_protocol_in,
    const ::net::IPEndPoint& remote_endpoint_in,
    bool was_fetched_via_cache_in,
    const ::net::ProxyServer& proxy_server_in,
    bool was_fetched_via_service_worker_in,
    ::network::mojom::FetchResponseSource service_worker_response_source_in,
    bool was_fallback_required_by_service_worker_in,
    std::vector<::GURL> url_list_via_service_worker_in,
    ::network::mojom::FetchResponseType response_type_in,
    int64_t padding_in,
    const std::string& cache_storage_cache_name_in,
    uint32_t cert_status_in,
    const base::Optional<::net::SSLInfo>& ssl_info_in,
    std::vector<std::string> cors_exposed_header_names_in,
    bool did_service_worker_navigation_preload_in,
    bool should_report_corb_blocking_in,
    bool async_revalidation_requested_in,
    bool did_mime_sniff_in,
    bool is_signed_exchange_inner_response_in,
    bool was_in_prefetch_cache_in,
    bool was_cookie_in_request_in,
    bool intercepted_by_plugin_in,
    bool is_legacy_tls_version_in,
    bool has_range_requested_in,
    bool timing_allow_passed_in,
    const base::Optional<::net::AuthChallengeInfo>& auth_challenge_info_in,
    ::base::TimeTicks request_start_in,
    ::base::TimeTicks response_start_in,
    ::network::mojom::ParsedHeadersPtr parsed_headers_in,
    const base::Optional<::network::OriginPolicy>& origin_policy_in,
    const base::Optional<::base::UnguessableToken>& recursive_prefetch_token_in)
    : request_time(std::move(request_time_in)),
      response_time(std::move(response_time_in)),
      headers(std::move(headers_in)),
      mime_type(std::move(mime_type_in)),
      charset(std::move(charset_in)),
      ct_policy_compliance(std::move(ct_policy_compliance_in)),
      content_length(std::move(content_length_in)),
      encoded_data_length(std::move(encoded_data_length_in)),
      encoded_body_length(std::move(encoded_body_length_in)),
      network_accessed(std::move(network_accessed_in)),
      appcache_id(std::move(appcache_id_in)),
      appcache_manifest_url(std::move(appcache_manifest_url_in)),
      load_timing(std::move(load_timing_in)),
      raw_request_response_info(std::move(raw_request_response_info_in)),
      was_fetched_via_spdy(std::move(was_fetched_via_spdy_in)),
      was_alpn_negotiated(std::move(was_alpn_negotiated_in)),
      was_alternate_protocol_available(std::move(was_alternate_protocol_available_in)),
      connection_info(std::move(connection_info_in)),
      alpn_negotiated_protocol(std::move(alpn_negotiated_protocol_in)),
      remote_endpoint(std::move(remote_endpoint_in)),
      was_fetched_via_cache(std::move(was_fetched_via_cache_in)),
      proxy_server(std::move(proxy_server_in)),
      was_fetched_via_service_worker(std::move(was_fetched_via_service_worker_in)),
      service_worker_response_source(std::move(service_worker_response_source_in)),
      was_fallback_required_by_service_worker(std::move(was_fallback_required_by_service_worker_in)),
      url_list_via_service_worker(std::move(url_list_via_service_worker_in)),
      response_type(std::move(response_type_in)),
      padding(std::move(padding_in)),
      cache_storage_cache_name(std::move(cache_storage_cache_name_in)),
      cert_status(std::move(cert_status_in)),
      ssl_info(std::move(ssl_info_in)),
      cors_exposed_header_names(std::move(cors_exposed_header_names_in)),
      did_service_worker_navigation_preload(std::move(did_service_worker_navigation_preload_in)),
      should_report_corb_blocking(std::move(should_report_corb_blocking_in)),
      async_revalidation_requested(std::move(async_revalidation_requested_in)),
      did_mime_sniff(std::move(did_mime_sniff_in)),
      is_signed_exchange_inner_response(std::move(is_signed_exchange_inner_response_in)),
      was_in_prefetch_cache(std::move(was_in_prefetch_cache_in)),
      was_cookie_in_request(std::move(was_cookie_in_request_in)),
      intercepted_by_plugin(std::move(intercepted_by_plugin_in)),
      is_legacy_tls_version(std::move(is_legacy_tls_version_in)),
      has_range_requested(std::move(has_range_requested_in)),
      timing_allow_passed(std::move(timing_allow_passed_in)),
      auth_challenge_info(std::move(auth_challenge_info_in)),
      request_start(std::move(request_start_in)),
      response_start(std::move(response_start_in)),
      parsed_headers(std::move(parsed_headers_in)),
      origin_policy(std::move(origin_policy_in)),
      recursive_prefetch_token(std::move(recursive_prefetch_token_in)) {}

URLResponseHead::~URLResponseHead() = default;

void URLResponseHead::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("request_time", base::trace_event::ValueToString(this->request_time, "<value of type ::base::Time>"));
  value->SetString("response_time", base::trace_event::ValueToString(this->response_time, "<value of type ::base::Time>"));
  value->SetString("headers", base::trace_event::ValueToString(this->headers, "<value of type const ::scoped_refptr<::net::HttpResponseHeaders>&>"));
  value->SetString("mime_type", this->mime_type);
  value->SetString("charset", this->charset);
  value->SetInteger("ct_policy_compliance", static_cast<int>(this->ct_policy_compliance));
  value->SetString("content_length", base::NumberToString(this->content_length));
  value->SetString("encoded_data_length", base::NumberToString(this->encoded_data_length));
  value->SetString("encoded_body_length", base::NumberToString(this->encoded_body_length));
  value->SetBoolean("network_accessed", this->network_accessed);
  value->SetString("appcache_id", base::NumberToString(this->appcache_id));
  value->SetString("appcache_manifest_url", base::trace_event::ValueToString(this->appcache_manifest_url, "<value of type const ::GURL&>"));
  value->SetString("load_timing", base::trace_event::ValueToString(this->load_timing, "<value of type const ::net::LoadTimingInfo&>"));
  if (this->raw_request_response_info.is_null()) {
    value->SetString("raw_request_response_info", "nullptr");
  } else {
    value->BeginDictionary("raw_request_response_info");
    this->raw_request_response_info->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetBoolean("was_fetched_via_spdy", this->was_fetched_via_spdy);
  value->SetBoolean("was_alpn_negotiated", this->was_alpn_negotiated);
  value->SetBoolean("was_alternate_protocol_available", this->was_alternate_protocol_available);
  value->SetInteger("connection_info", static_cast<int>(this->connection_info));
  value->SetString("alpn_negotiated_protocol", this->alpn_negotiated_protocol);
  value->SetString("remote_endpoint", base::trace_event::ValueToString(this->remote_endpoint, "<value of type const ::net::IPEndPoint&>"));
  value->SetBoolean("was_fetched_via_cache", this->was_fetched_via_cache);
  value->SetString("proxy_server", base::trace_event::ValueToString(this->proxy_server, "<value of type const ::net::ProxyServer&>"));
  value->SetBoolean("was_fetched_via_service_worker", this->was_fetched_via_service_worker);
  value->SetString("service_worker_response_source", base::trace_event::ValueToString(this->service_worker_response_source));
  value->SetBoolean("was_fallback_required_by_service_worker", this->was_fallback_required_by_service_worker);
  value->BeginArray("url_list_via_service_worker");
  for (const auto& item0 : this->url_list_via_service_worker) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::GURL&>"));
  }
  value->EndArray();
  value->SetString("response_type", base::trace_event::ValueToString(this->response_type));
  value->SetString("padding", base::NumberToString(this->padding));
  value->SetString("cache_storage_cache_name", this->cache_storage_cache_name);
  value->SetString("cert_status", base::NumberToString(this->cert_status));
  value->SetString("ssl_info", base::trace_event::ValueToString(this->ssl_info, "<value of type const base::Optional<::net::SSLInfo>&>"));
  value->BeginArray("cors_exposed_header_names");
  for (const auto& item0 : this->cors_exposed_header_names) {
    value->AppendString(item0);
  }
  value->EndArray();
  value->SetBoolean("did_service_worker_navigation_preload", this->did_service_worker_navigation_preload);
  value->SetBoolean("should_report_corb_blocking", this->should_report_corb_blocking);
  value->SetBoolean("async_revalidation_requested", this->async_revalidation_requested);
  value->SetBoolean("did_mime_sniff", this->did_mime_sniff);
  value->SetBoolean("is_signed_exchange_inner_response", this->is_signed_exchange_inner_response);
  value->SetBoolean("was_in_prefetch_cache", this->was_in_prefetch_cache);
  value->SetBoolean("was_cookie_in_request", this->was_cookie_in_request);
  value->SetBoolean("intercepted_by_plugin", this->intercepted_by_plugin);
  value->SetBoolean("is_legacy_tls_version", this->is_legacy_tls_version);
  value->SetBoolean("has_range_requested", this->has_range_requested);
  value->SetBoolean("timing_allow_passed", this->timing_allow_passed);
  value->SetString("auth_challenge_info", base::trace_event::ValueToString(this->auth_challenge_info, "<value of type const base::Optional<::net::AuthChallengeInfo>&>"));
  value->SetString("request_start", base::trace_event::ValueToString(this->request_start, "<value of type ::base::TimeTicks>"));
  value->SetString("response_start", base::trace_event::ValueToString(this->response_start, "<value of type ::base::TimeTicks>"));
  if (this->parsed_headers.is_null()) {
    value->SetString("parsed_headers", "nullptr");
  } else {
    value->BeginDictionary("parsed_headers");
    this->parsed_headers->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetString("origin_policy", base::trace_event::ValueToString(this->origin_policy, "<value of type const base::Optional<::network::OriginPolicy>&>"));
  value->SetString("recursive_prefetch_token", base::trace_event::ValueToString(this->recursive_prefetch_token, "<value of type const base::Optional<::base::UnguessableToken>&>"));
}

bool URLResponseHead::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::URLResponseHead::DataView, ::network::mojom::URLResponseHeadPtr>::Read(
    ::network::mojom::URLResponseHead::DataView input,
    ::network::mojom::URLResponseHeadPtr* output) {
  bool success = true;
  ::network::mojom::URLResponseHeadPtr result(::network::mojom::URLResponseHead::New());
  
      if (success && !input.ReadRequestTime(&result->request_time))
        success = false;
      if (success && !input.ReadResponseTime(&result->response_time))
        success = false;
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
      if (success && !input.ReadCharset(&result->charset))
        success = false;
      if (success && !input.ReadCtPolicyCompliance(&result->ct_policy_compliance))
        success = false;
      if (success)
        result->content_length = input.content_length();
      if (success)
        result->encoded_data_length = input.encoded_data_length();
      if (success)
        result->encoded_body_length = input.encoded_body_length();
      if (success)
        result->network_accessed = input.network_accessed();
      if (success)
        result->appcache_id = input.appcache_id();
      if (success && !input.ReadAppcacheManifestUrl(&result->appcache_manifest_url))
        success = false;
      if (success && !input.ReadLoadTiming(&result->load_timing))
        success = false;
      if (success && !input.ReadRawRequestResponseInfo(&result->raw_request_response_info))
        success = false;
      if (success)
        result->was_fetched_via_spdy = input.was_fetched_via_spdy();
      if (success)
        result->was_alpn_negotiated = input.was_alpn_negotiated();
      if (success)
        result->was_alternate_protocol_available = input.was_alternate_protocol_available();
      if (success && !input.ReadConnectionInfo(&result->connection_info))
        success = false;
      if (success && !input.ReadAlpnNegotiatedProtocol(&result->alpn_negotiated_protocol))
        success = false;
      if (success && !input.ReadRemoteEndpoint(&result->remote_endpoint))
        success = false;
      if (success)
        result->was_fetched_via_cache = input.was_fetched_via_cache();
      if (success && !input.ReadProxyServer(&result->proxy_server))
        success = false;
      if (success)
        result->was_fetched_via_service_worker = input.was_fetched_via_service_worker();
      if (success && !input.ReadServiceWorkerResponseSource(&result->service_worker_response_source))
        success = false;
      if (success)
        result->was_fallback_required_by_service_worker = input.was_fallback_required_by_service_worker();
      if (success && !input.ReadUrlListViaServiceWorker(&result->url_list_via_service_worker))
        success = false;
      if (success && !input.ReadResponseType(&result->response_type))
        success = false;
      if (success)
        result->padding = input.padding();
      if (success && !input.ReadCacheStorageCacheName(&result->cache_storage_cache_name))
        success = false;
      if (success)
        result->cert_status = input.cert_status();
      if (success && !input.ReadSslInfo(&result->ssl_info))
        success = false;
      if (success && !input.ReadCorsExposedHeaderNames(&result->cors_exposed_header_names))
        success = false;
      if (success)
        result->did_service_worker_navigation_preload = input.did_service_worker_navigation_preload();
      if (success)
        result->should_report_corb_blocking = input.should_report_corb_blocking();
      if (success)
        result->async_revalidation_requested = input.async_revalidation_requested();
      if (success)
        result->did_mime_sniff = input.did_mime_sniff();
      if (success)
        result->is_signed_exchange_inner_response = input.is_signed_exchange_inner_response();
      if (success)
        result->was_in_prefetch_cache = input.was_in_prefetch_cache();
      if (success)
        result->was_cookie_in_request = input.was_cookie_in_request();
      if (success)
        result->intercepted_by_plugin = input.intercepted_by_plugin();
      if (success)
        result->is_legacy_tls_version = input.is_legacy_tls_version();
      if (success)
        result->has_range_requested = input.has_range_requested();
      if (success)
        result->timing_allow_passed = input.timing_allow_passed();
      if (success && !input.ReadAuthChallengeInfo(&result->auth_challenge_info))
        success = false;
      if (success && !input.ReadRequestStart(&result->request_start))
        success = false;
      if (success && !input.ReadResponseStart(&result->response_start))
        success = false;
      if (success && !input.ReadParsedHeaders(&result->parsed_headers))
        success = false;
      if (success && !input.ReadOriginPolicy(&result->origin_policy))
        success = false;
      if (success && !input.ReadRecursivePrefetchToken(&result->recursive_prefetch_token))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif