// services/shape_detection/public/mojom/facedetection_provider.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/shape_detection/public/mojom/facedetection_provider.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/shape_detection/public/mojom/facedetection_provider.mojom-params-data.h"
#include "services/shape_detection/public/mojom/facedetection_provider.mojom-shared-message-ids.h"

#include "services/shape_detection/public/mojom/facedetection_provider.mojom-import-headers.h"


#ifndef SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_FACEDETECTION_PROVIDER_MOJOM_JUMBO_H_
#define SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_FACEDETECTION_PROVIDER_MOJOM_JUMBO_H_
#endif
namespace shape_detection {
namespace mojom {
const char FaceDetectionProvider::Name_[] = "shape_detection.mojom.FaceDetectionProvider";

FaceDetectionProviderProxy::FaceDetectionProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FaceDetectionProviderProxy::CreateFaceDetection(
    ::mojo::PendingReceiver<::shape_detection::mojom::FaceDetection> in_receiver, ::shape_detection::mojom::FaceDetectorOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "shape_detection::mojom::FaceDetectionProvider::CreateFaceDetection", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      if (in_options.is_null()) {
        raw_value->SetString("options", "nullptr");
      } else {
        raw_value->BeginDictionary("options");
        in_options->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFaceDetectionProvider_CreateFaceDetection_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::shape_detection::mojom::internal::FaceDetectionProvider_CreateFaceDetection_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::shape_detection::mojom::FaceDetectionInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in FaceDetectionProvider.CreateFaceDetection request");
  typename decltype(params->options)::BaseType::BufferWriter
      options_writer;
  mojo::internal::Serialize<::shape_detection::mojom::FaceDetectorOptionsDataView>(
      in_options, buffer, &options_writer, &serialization_context);
  params->options.Set(
      options_writer.is_null() ? nullptr : options_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in FaceDetectionProvider.CreateFaceDetection request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FaceDetectionProvider::Name_);
  message.set_method_name("CreateFaceDetection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool FaceDetectionProviderStubDispatch::Accept(
    FaceDetectionProvider* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kFaceDetectionProvider_CreateFaceDetection_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)shape_detection::mojom::FaceDetectionProvider::CreateFaceDetection",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)shape_detection::mojom::FaceDetectionProvider::CreateFaceDetection");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FaceDetectionProvider_CreateFaceDetection_Params_Data* params =
          reinterpret_cast<internal::FaceDetectionProvider_CreateFaceDetection_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::shape_detection::mojom::FaceDetection> p_receiver{};
      ::shape_detection::mojom::FaceDetectorOptionsPtr p_options{};
      FaceDetectionProvider_CreateFaceDetection_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FaceDetectionProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateFaceDetection(
std::move(p_receiver), 
std::move(p_options));
      return true;
    }
  }
  return false;
}

// static
bool FaceDetectionProviderStubDispatch::AcceptWithResponder(
    FaceDetectionProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFaceDetectionProvider_CreateFaceDetection_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFaceDetectionProviderValidationInfo[] = {
    {internal::kFaceDetectionProvider_CreateFaceDetection_Name,
     {&internal::FaceDetectionProvider_CreateFaceDetection_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FaceDetectionProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::shape_detection::mojom::FaceDetectionProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFaceDetectionProviderValidationInfo);
}

}  // namespace mojom
}  // namespace shape_detection

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif