// services/viz/privileged/mojom/gl/gpu_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/gl/gpu_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/privileged/mojom/gl/gpu_service.mojom-params-data.h"
#include "services/viz/privileged/mojom/gl/gpu_service.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/gl/gpu_service.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_SERVICE_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_SERVICE_MOJOM_JUMBO_H_
#endif
namespace viz {
namespace mojom {
const char GpuService::Name_[] = "viz.mojom.GpuService";

class GpuService_EstablishGpuChannel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuService_EstablishGpuChannel_ForwardToCallback(
      GpuService::EstablishGpuChannelCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuService::EstablishGpuChannelCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuService_EstablishGpuChannel_ForwardToCallback);
};

class GpuService_CreateGpuMemoryBuffer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuService_CreateGpuMemoryBuffer_ForwardToCallback(
      GpuService::CreateGpuMemoryBufferCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuService::CreateGpuMemoryBufferCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuService_CreateGpuMemoryBuffer_ForwardToCallback);
};

class GpuService_GetVideoMemoryUsageStats_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuService_GetVideoMemoryUsageStats_ForwardToCallback(
      GpuService::GetVideoMemoryUsageStatsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuService::GetVideoMemoryUsageStatsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuService_GetVideoMemoryUsageStats_ForwardToCallback);
};

class GpuService_GetPeakMemoryUsage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuService_GetPeakMemoryUsage_ForwardToCallback(
      GpuService::GetPeakMemoryUsageCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuService::GetPeakMemoryUsageCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuService_GetPeakMemoryUsage_ForwardToCallback);
};

class GpuService_RequestHDRStatus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuService_RequestHDRStatus_ForwardToCallback(
      GpuService::RequestHDRStatusCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuService::RequestHDRStatusCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuService_RequestHDRStatus_ForwardToCallback);
};

class GpuService_Stop_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GpuService_Stop_ForwardToCallback(
      GpuService::StopCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  GpuService::StopCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(GpuService_Stop_ForwardToCallback);
};

GpuServiceProxy::GpuServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GpuServiceProxy::EstablishGpuChannel(
    int32_t in_client_id, uint64_t in_client_tracing_id, bool in_is_gpu_host, bool in_cache_shaders_on_disk, EstablishGpuChannelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuService::EstablishGpuChannel", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("client_id", in_client_id);
      raw_value->SetString("client_tracing_id", base::NumberToString(in_client_tracing_id));
      raw_value->SetBoolean("is_gpu_host", in_is_gpu_host);
      raw_value->SetBoolean("cache_shaders_on_disk", in_cache_shaders_on_disk);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_EstablishGpuChannel_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_EstablishGpuChannel_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->client_id = in_client_id;
  params->client_tracing_id = in_client_tracing_id;
  params->is_gpu_host = in_is_gpu_host;
  params->cache_shaders_on_disk = in_cache_shaders_on_disk;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("EstablishGpuChannel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuService_EstablishGpuChannel_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GpuServiceProxy::CloseChannel(
    int32_t in_client_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuService::CloseChannel", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("client_id", in_client_id);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_CloseChannel_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_CloseChannel_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->client_id = in_client_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("CloseChannel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::CreateVideoEncodeAcceleratorProvider(
    ::mojo::PendingReceiver<::media::mojom::VideoEncodeAcceleratorProvider> in_vea_provider) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuService::CreateVideoEncodeAcceleratorProvider", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("vea_provider", in_vea_provider.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_CreateVideoEncodeAcceleratorProvider_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::VideoEncodeAcceleratorProviderInterfaceBase>>(
      in_vea_provider, &params->vea_provider, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->vea_provider),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid vea_provider in GpuService.CreateVideoEncodeAcceleratorProvider request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("CreateVideoEncodeAcceleratorProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::CreateGpuMemoryBuffer(
    ::gfx::GpuMemoryBufferId in_id, const ::gfx::Size& in_size, ::gfx::BufferFormat in_format, ::gfx::BufferUsage in_usage, int32_t in_client_id, ::gpu::SurfaceHandle in_surface_handle, CreateGpuMemoryBufferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuService::CreateGpuMemoryBuffer", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("id", base::trace_event::ValueToString(in_id, "<value of type ::gfx::GpuMemoryBufferId>"));
      raw_value->SetString("size", base::trace_event::ValueToString(in_size, "<value of type const ::gfx::Size&>"));
      raw_value->SetInteger("format", static_cast<int>(in_format));
      raw_value->SetInteger("usage", static_cast<int>(in_usage));
      raw_value->SetInteger("client_id", in_client_id);
      raw_value->SetString("surface_handle", base::trace_event::ValueToString(in_surface_handle, "<value of type ::gpu::SurfaceHandle>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_CreateGpuMemoryBuffer_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_CreateGpuMemoryBuffer_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->id)::BaseType::BufferWriter
      id_writer;
  mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferIdDataView>(
      in_id, buffer, &id_writer, &serialization_context);
  params->id.Set(
      id_writer.is_null() ? nullptr : id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in GpuService.CreateGpuMemoryBuffer request");
  typename decltype(params->size)::BaseType::BufferWriter
      size_writer;
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_size, buffer, &size_writer, &serialization_context);
  params->size.Set(
      size_writer.is_null() ? nullptr : size_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size in GpuService.CreateGpuMemoryBuffer request");
  mojo::internal::Serialize<::gfx::mojom::BufferFormat>(
      in_format, &params->format);
  mojo::internal::Serialize<::gfx::mojom::BufferUsage>(
      in_usage, &params->usage);
  params->client_id = in_client_id;
  typename decltype(params->surface_handle)::BaseType::BufferWriter
      surface_handle_writer;
  mojo::internal::Serialize<::gpu::mojom::SurfaceHandleDataView>(
      in_surface_handle, buffer, &surface_handle_writer, &serialization_context);
  params->surface_handle.Set(
      surface_handle_writer.is_null() ? nullptr : surface_handle_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->surface_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null surface_handle in GpuService.CreateGpuMemoryBuffer request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("CreateGpuMemoryBuffer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuService_CreateGpuMemoryBuffer_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GpuServiceProxy::DestroyGpuMemoryBuffer(
    ::gfx::GpuMemoryBufferId in_id, int32_t in_client_id, const ::gpu::SyncToken& in_sync_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuService::DestroyGpuMemoryBuffer", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("id", base::trace_event::ValueToString(in_id, "<value of type ::gfx::GpuMemoryBufferId>"));
      raw_value->SetInteger("client_id", in_client_id);
      raw_value->SetString("sync_token", base::trace_event::ValueToString(in_sync_token, "<value of type const ::gpu::SyncToken&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_DestroyGpuMemoryBuffer_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_DestroyGpuMemoryBuffer_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->id)::BaseType::BufferWriter
      id_writer;
  mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferIdDataView>(
      in_id, buffer, &id_writer, &serialization_context);
  params->id.Set(
      id_writer.is_null() ? nullptr : id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in GpuService.DestroyGpuMemoryBuffer request");
  params->client_id = in_client_id;
  typename decltype(params->sync_token)::BaseType::BufferWriter
      sync_token_writer;
  mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
      in_sync_token, buffer, &sync_token_writer, &serialization_context);
  params->sync_token.Set(
      sync_token_writer.is_null() ? nullptr : sync_token_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->sync_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sync_token in GpuService.DestroyGpuMemoryBuffer request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("DestroyGpuMemoryBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::GetVideoMemoryUsageStats(
    GetVideoMemoryUsageStatsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::GetVideoMemoryUsageStats");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_GetVideoMemoryUsageStats_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_GetVideoMemoryUsageStats_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("GetVideoMemoryUsageStats");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuService_GetVideoMemoryUsageStats_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GpuServiceProxy::StartPeakMemoryMonitor(
    uint32_t in_sequence_num) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuService::StartPeakMemoryMonitor", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("sequence_num", base::NumberToString(in_sequence_num));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_StartPeakMemoryMonitor_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_StartPeakMemoryMonitor_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->sequence_num = in_sequence_num;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("StartPeakMemoryMonitor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::GetPeakMemoryUsage(
    uint32_t in_sequence_num, GetPeakMemoryUsageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuService::GetPeakMemoryUsage", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("sequence_num", base::NumberToString(in_sequence_num));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_GetPeakMemoryUsage_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_GetPeakMemoryUsage_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->sequence_num = in_sequence_num;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("GetPeakMemoryUsage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuService_GetPeakMemoryUsage_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GpuServiceProxy::RequestHDRStatus(
    RequestHDRStatusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::RequestHDRStatus");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_RequestHDRStatus_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_RequestHDRStatus_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("RequestHDRStatus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuService_RequestHDRStatus_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void GpuServiceProxy::LoadedShader(
    int32_t in_client_id, const std::string& in_key, const std::string& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuService::LoadedShader", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("client_id", in_client_id);
      raw_value->SetString("key", in_key);
      raw_value->SetString("data", in_data);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_LoadedShader_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_LoadedShader_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->client_id = in_client_id;
  typename decltype(params->key)::BaseType::BufferWriter
      key_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_key, buffer, &key_writer, &serialization_context);
  params->key.Set(
      key_writer.is_null() ? nullptr : key_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in GpuService.LoadedShader request");
  typename decltype(params->data)::BaseType::BufferWriter
      data_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_data, buffer, &data_writer, &serialization_context);
  params->data.Set(
      data_writer.is_null() ? nullptr : data_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in GpuService.LoadedShader request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("LoadedShader");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::WakeUpGpu(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::WakeUpGpu");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_WakeUpGpu_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_WakeUpGpu_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("WakeUpGpu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::GpuSwitched(
    ::gl::GpuPreference in_active_gpu_heuristic) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuService::GpuSwitched", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("active_gpu_heuristic", static_cast<int>(in_active_gpu_heuristic));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_GpuSwitched_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_GpuSwitched_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::gl::mojom::GpuPreference>(
      in_active_gpu_heuristic, &params->active_gpu_heuristic);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("GpuSwitched");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::DisplayAdded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::DisplayAdded");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_DisplayAdded_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_DisplayAdded_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("DisplayAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::DisplayRemoved(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::DisplayRemoved");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_DisplayRemoved_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_DisplayRemoved_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("DisplayRemoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::DestroyAllChannels(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::DestroyAllChannels");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_DestroyAllChannels_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_DestroyAllChannels_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("DestroyAllChannels");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::OnBackgroundCleanup(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::OnBackgroundCleanup");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_OnBackgroundCleanup_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_OnBackgroundCleanup_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("OnBackgroundCleanup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::OnBackgrounded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::OnBackgrounded");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_OnBackgrounded_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_OnBackgrounded_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("OnBackgrounded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::OnForegrounded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::OnForegrounded");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_OnForegrounded_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_OnForegrounded_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("OnForegrounded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::OnMemoryPressure(
    ::base::MemoryPressureListener::MemoryPressureLevel in_level) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::GpuService::OnMemoryPressure", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("level", static_cast<int>(in_level));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_OnMemoryPressure_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_OnMemoryPressure_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::mojo_base::mojom::MemoryPressureLevel>(
      in_level, &params->level);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("OnMemoryPressure");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::Crash(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::Crash");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_Crash_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_Crash_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("Crash");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::Hang(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::Hang");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_Hang_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_Hang_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("Hang");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::ThrowJavaException(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::ThrowJavaException");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_ThrowJavaException_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_ThrowJavaException_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("ThrowJavaException");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GpuServiceProxy::Stop(
    StopCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::GpuService::Stop");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_Stop_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_Stop_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("Stop");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GpuService_Stop_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class GpuService_EstablishGpuChannel_ProxyToResponder {
 public:
  static GpuService::EstablishGpuChannelCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuService_EstablishGpuChannel_ProxyToResponder> proxy(
        new GpuService_EstablishGpuChannel_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuService_EstablishGpuChannel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuService_EstablishGpuChannel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuService_EstablishGpuChannel_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuService::EstablishGpuChannelCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::ScopedMessagePipeHandle in_channel_handle);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuService_EstablishGpuChannel_ProxyToResponder);
};

bool GpuService_EstablishGpuChannel_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "viz::mojom::GpuService::EstablishGpuChannelCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::GpuService_EstablishGpuChannel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuService_EstablishGpuChannel_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::mojo::ScopedMessagePipeHandle p_channel_handle{};
  GpuService_EstablishGpuChannel_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_channel_handle = input_data_view.TakeChannelHandle();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_channel_handle));
  return true;
}

void GpuService_EstablishGpuChannel_ProxyToResponder::Run(
    ::mojo::ScopedMessagePipeHandle in_channel_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)viz::mojom::GpuService::EstablishGpuChannelCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("channel_handle", in_channel_handle.is_valid());
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_EstablishGpuChannel_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_EstablishGpuChannel_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
      in_channel_handle, &params->channel_handle, &serialization_context);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)viz::mojom::GpuService::EstablishGpuChannelCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("EstablishGpuChannel");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GpuService_CreateGpuMemoryBuffer_ProxyToResponder {
 public:
  static GpuService::CreateGpuMemoryBufferCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuService_CreateGpuMemoryBuffer_ProxyToResponder> proxy(
        new GpuService_CreateGpuMemoryBuffer_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuService_CreateGpuMemoryBuffer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuService_CreateGpuMemoryBuffer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuService_CreateGpuMemoryBuffer_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuService::CreateGpuMemoryBufferCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::gfx::GpuMemoryBufferHandle in_buffer_handle);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuService_CreateGpuMemoryBuffer_ProxyToResponder);
};

bool GpuService_CreateGpuMemoryBuffer_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "viz::mojom::GpuService::CreateGpuMemoryBufferCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::GpuService_CreateGpuMemoryBuffer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuService_CreateGpuMemoryBuffer_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::gfx::GpuMemoryBufferHandle p_buffer_handle{};
  GpuService_CreateGpuMemoryBuffer_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadBufferHandle(&p_buffer_handle))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_buffer_handle));
  return true;
}

void GpuService_CreateGpuMemoryBuffer_ProxyToResponder::Run(
    ::gfx::GpuMemoryBufferHandle in_buffer_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)viz::mojom::GpuService::CreateGpuMemoryBufferCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("buffer_handle", base::trace_event::ValueToString(in_buffer_handle, "<value of type ::gfx::GpuMemoryBufferHandle>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_CreateGpuMemoryBuffer_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_CreateGpuMemoryBuffer_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->buffer_handle)::BaseType::BufferWriter
      buffer_handle_writer;
  mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
      in_buffer_handle, buffer, &buffer_handle_writer, &serialization_context);
  params->buffer_handle.Set(
      buffer_handle_writer.is_null() ? nullptr : buffer_handle_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buffer_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer_handle in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)viz::mojom::GpuService::CreateGpuMemoryBufferCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("CreateGpuMemoryBuffer");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GpuService_GetVideoMemoryUsageStats_ProxyToResponder {
 public:
  static GpuService::GetVideoMemoryUsageStatsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuService_GetVideoMemoryUsageStats_ProxyToResponder> proxy(
        new GpuService_GetVideoMemoryUsageStats_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuService_GetVideoMemoryUsageStats_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuService_GetVideoMemoryUsageStats_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuService_GetVideoMemoryUsageStats_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuService::GetVideoMemoryUsageStatsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::gpu::VideoMemoryUsageStats& in_stats);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuService_GetVideoMemoryUsageStats_ProxyToResponder);
};

bool GpuService_GetVideoMemoryUsageStats_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "viz::mojom::GpuService::GetVideoMemoryUsageStatsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::GpuService_GetVideoMemoryUsageStats_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuService_GetVideoMemoryUsageStats_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::gpu::VideoMemoryUsageStats p_stats{};
  GpuService_GetVideoMemoryUsageStats_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadStats(&p_stats))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuService::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_stats));
  return true;
}

void GpuService_GetVideoMemoryUsageStats_ProxyToResponder::Run(
    const ::gpu::VideoMemoryUsageStats& in_stats) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)viz::mojom::GpuService::GetVideoMemoryUsageStatsCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("stats", base::trace_event::ValueToString(in_stats, "<value of type const ::gpu::VideoMemoryUsageStats&>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_GetVideoMemoryUsageStats_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_GetVideoMemoryUsageStats_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->stats)::BaseType::BufferWriter
      stats_writer;
  mojo::internal::Serialize<::gpu::mojom::VideoMemoryUsageStatsDataView>(
      in_stats, buffer, &stats_writer, &serialization_context);
  params->stats.Set(
      stats_writer.is_null() ? nullptr : stats_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->stats.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null stats in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)viz::mojom::GpuService::GetVideoMemoryUsageStatsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("GetVideoMemoryUsageStats");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GpuService_GetPeakMemoryUsage_ProxyToResponder {
 public:
  static GpuService::GetPeakMemoryUsageCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuService_GetPeakMemoryUsage_ProxyToResponder> proxy(
        new GpuService_GetPeakMemoryUsage_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuService_GetPeakMemoryUsage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuService_GetPeakMemoryUsage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuService_GetPeakMemoryUsage_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuService::GetPeakMemoryUsageCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint64_t in_memory_usage, const base::flat_map<::gpu::GpuPeakMemoryAllocationSource, uint64_t>& in_memory_per_allocation_source);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuService_GetPeakMemoryUsage_ProxyToResponder);
};

bool GpuService_GetPeakMemoryUsage_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "viz::mojom::GpuService::GetPeakMemoryUsageCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::GpuService_GetPeakMemoryUsage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuService_GetPeakMemoryUsage_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  uint64_t p_memory_usage{};
  base::flat_map<::gpu::GpuPeakMemoryAllocationSource, uint64_t> p_memory_per_allocation_source{};
  GpuService_GetPeakMemoryUsage_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_memory_usage = input_data_view.memory_usage();
  if (success && !input_data_view.ReadMemoryPerAllocationSource(&p_memory_per_allocation_source))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuService::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_memory_usage), 
std::move(p_memory_per_allocation_source));
  return true;
}

void GpuService_GetPeakMemoryUsage_ProxyToResponder::Run(
    uint64_t in_memory_usage, const base::flat_map<::gpu::GpuPeakMemoryAllocationSource, uint64_t>& in_memory_per_allocation_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)viz::mojom::GpuService::GetPeakMemoryUsageCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("memory_usage", base::NumberToString(in_memory_usage));
      raw_value->BeginDictionary("memory_per_allocation_source");
      for (const auto& item0 : in_memory_per_allocation_source) {
        raw_value->SetStringWithCopiedName(base::trace_event::ValueToString(item0.first, "<value of type ::gpu::GpuPeakMemoryAllocationSource>"), base::NumberToString(item0.second));
      }
      raw_value->EndDictionary();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_GetPeakMemoryUsage_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_GetPeakMemoryUsage_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->memory_usage = in_memory_usage;
  typename decltype(params->memory_per_allocation_source)::BaseType::BufferWriter
      memory_per_allocation_source_writer;
  const mojo::internal::ContainerValidateParams memory_per_allocation_source_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::gpu::mojom::internal::GpuPeakMemoryAllocationSource_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::MapDataView<::gpu::mojom::GpuPeakMemoryAllocationSource, uint64_t>>(
      in_memory_per_allocation_source, buffer, &memory_per_allocation_source_writer, &memory_per_allocation_source_validate_params,
      &serialization_context);
  params->memory_per_allocation_source.Set(
      memory_per_allocation_source_writer.is_null() ? nullptr : memory_per_allocation_source_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->memory_per_allocation_source.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null memory_per_allocation_source in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)viz::mojom::GpuService::GetPeakMemoryUsageCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("GetPeakMemoryUsage");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GpuService_RequestHDRStatus_ProxyToResponder {
 public:
  static GpuService::RequestHDRStatusCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuService_RequestHDRStatus_ProxyToResponder> proxy(
        new GpuService_RequestHDRStatus_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuService_RequestHDRStatus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuService_RequestHDRStatus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuService_RequestHDRStatus_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuService::RequestHDRStatusCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_hdr_enabled);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuService_RequestHDRStatus_ProxyToResponder);
};

bool GpuService_RequestHDRStatus_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "viz::mojom::GpuService::RequestHDRStatusCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::GpuService_RequestHDRStatus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuService_RequestHDRStatus_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_hdr_enabled{};
  GpuService_RequestHDRStatus_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_hdr_enabled = input_data_view.hdr_enabled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuService::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_hdr_enabled));
  return true;
}

void GpuService_RequestHDRStatus_ProxyToResponder::Run(
    bool in_hdr_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)viz::mojom::GpuService::RequestHDRStatusCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("hdr_enabled", in_hdr_enabled);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_RequestHDRStatus_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_RequestHDRStatus_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->hdr_enabled = in_hdr_enabled;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)viz::mojom::GpuService::RequestHDRStatusCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("RequestHDRStatus");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GpuService_Stop_ProxyToResponder {
 public:
  static GpuService::StopCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<GpuService_Stop_ProxyToResponder> proxy(
        new GpuService_Stop_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&GpuService_Stop_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GpuService_Stop_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  GpuService_Stop_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GpuService::StopCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(GpuService_Stop_ProxyToResponder);
};

bool GpuService_Stop_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "viz::mojom::GpuService::StopCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::GpuService_Stop_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GpuService_Stop_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  GpuService_Stop_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GpuService::Name_, 22, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void GpuService_Stop_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)viz::mojom::GpuService::StopCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGpuService_Stop_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::GpuService_Stop_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)viz::mojom::GpuService::StopCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GpuService::Name_);
  message.set_method_name("Stop");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GpuServiceStubDispatch::Accept(
    GpuService* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kGpuService_EstablishGpuChannel_Name: {
      break;
    }
    case internal::kGpuService_CloseChannel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::CloseChannel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::CloseChannel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_CloseChannel_Params_Data* params =
          reinterpret_cast<internal::GpuService_CloseChannel_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_client_id{};
      GpuService_CloseChannel_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_client_id = input_data_view.client_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseChannel(
std::move(p_client_id));
      return true;
    }
    case internal::kGpuService_CreateVideoEncodeAcceleratorProvider_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::CreateVideoEncodeAcceleratorProvider",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::CreateVideoEncodeAcceleratorProvider");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data* params =
          reinterpret_cast<internal::GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::VideoEncodeAcceleratorProvider> p_vea_provider{};
      GpuService_CreateVideoEncodeAcceleratorProvider_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_vea_provider =
            input_data_view.TakeVeaProvider<decltype(p_vea_provider)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateVideoEncodeAcceleratorProvider(
std::move(p_vea_provider));
      return true;
    }
    case internal::kGpuService_CreateGpuMemoryBuffer_Name: {
      break;
    }
    case internal::kGpuService_DestroyGpuMemoryBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::DestroyGpuMemoryBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::DestroyGpuMemoryBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_DestroyGpuMemoryBuffer_Params_Data* params =
          reinterpret_cast<internal::GpuService_DestroyGpuMemoryBuffer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::GpuMemoryBufferId p_id{};
      int32_t p_client_id{};
      ::gpu::SyncToken p_sync_token{};
      GpuService_DestroyGpuMemoryBuffer_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success)
        p_client_id = input_data_view.client_id();
      if (success && !input_data_view.ReadSyncToken(&p_sync_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DestroyGpuMemoryBuffer(
std::move(p_id), 
std::move(p_client_id), 
std::move(p_sync_token));
      return true;
    }
    case internal::kGpuService_GetVideoMemoryUsageStats_Name: {
      break;
    }
    case internal::kGpuService_StartPeakMemoryMonitor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::StartPeakMemoryMonitor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::StartPeakMemoryMonitor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_StartPeakMemoryMonitor_Params_Data* params =
          reinterpret_cast<internal::GpuService_StartPeakMemoryMonitor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_sequence_num{};
      GpuService_StartPeakMemoryMonitor_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_sequence_num = input_data_view.sequence_num();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartPeakMemoryMonitor(
std::move(p_sequence_num));
      return true;
    }
    case internal::kGpuService_GetPeakMemoryUsage_Name: {
      break;
    }
    case internal::kGpuService_RequestHDRStatus_Name: {
      break;
    }
    case internal::kGpuService_LoadedShader_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::LoadedShader",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::LoadedShader");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_LoadedShader_Params_Data* params =
          reinterpret_cast<internal::GpuService_LoadedShader_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_client_id{};
      std::string p_key{};
      std::string p_data{};
      GpuService_LoadedShader_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_client_id = input_data_view.client_id();
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadedShader(
std::move(p_client_id), 
std::move(p_key), 
std::move(p_data));
      return true;
    }
    case internal::kGpuService_WakeUpGpu_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::WakeUpGpu",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::WakeUpGpu");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_WakeUpGpu_Params_Data* params =
          reinterpret_cast<internal::GpuService_WakeUpGpu_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuService_WakeUpGpu_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WakeUpGpu();
      return true;
    }
    case internal::kGpuService_GpuSwitched_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::GpuSwitched",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::GpuSwitched");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_GpuSwitched_Params_Data* params =
          reinterpret_cast<internal::GpuService_GpuSwitched_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gl::GpuPreference p_active_gpu_heuristic{};
      GpuService_GpuSwitched_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadActiveGpuHeuristic(&p_active_gpu_heuristic))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GpuSwitched(
std::move(p_active_gpu_heuristic));
      return true;
    }
    case internal::kGpuService_DisplayAdded_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::DisplayAdded",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::DisplayAdded");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_DisplayAdded_Params_Data* params =
          reinterpret_cast<internal::GpuService_DisplayAdded_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuService_DisplayAdded_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisplayAdded();
      return true;
    }
    case internal::kGpuService_DisplayRemoved_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::DisplayRemoved",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::DisplayRemoved");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_DisplayRemoved_Params_Data* params =
          reinterpret_cast<internal::GpuService_DisplayRemoved_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuService_DisplayRemoved_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisplayRemoved();
      return true;
    }
    case internal::kGpuService_DestroyAllChannels_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::DestroyAllChannels",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::DestroyAllChannels");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_DestroyAllChannels_Params_Data* params =
          reinterpret_cast<internal::GpuService_DestroyAllChannels_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuService_DestroyAllChannels_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DestroyAllChannels();
      return true;
    }
    case internal::kGpuService_OnBackgroundCleanup_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::OnBackgroundCleanup",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::OnBackgroundCleanup");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_OnBackgroundCleanup_Params_Data* params =
          reinterpret_cast<internal::GpuService_OnBackgroundCleanup_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuService_OnBackgroundCleanup_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBackgroundCleanup();
      return true;
    }
    case internal::kGpuService_OnBackgrounded_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::OnBackgrounded",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::OnBackgrounded");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_OnBackgrounded_Params_Data* params =
          reinterpret_cast<internal::GpuService_OnBackgrounded_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuService_OnBackgrounded_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBackgrounded();
      return true;
    }
    case internal::kGpuService_OnForegrounded_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::OnForegrounded",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::OnForegrounded");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_OnForegrounded_Params_Data* params =
          reinterpret_cast<internal::GpuService_OnForegrounded_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuService_OnForegrounded_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnForegrounded();
      return true;
    }
    case internal::kGpuService_OnMemoryPressure_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::OnMemoryPressure",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::OnMemoryPressure");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_OnMemoryPressure_Params_Data* params =
          reinterpret_cast<internal::GpuService_OnMemoryPressure_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::MemoryPressureListener::MemoryPressureLevel p_level{};
      GpuService_OnMemoryPressure_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadLevel(&p_level))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMemoryPressure(
std::move(p_level));
      return true;
    }
    case internal::kGpuService_Crash_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::Crash",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::Crash");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_Crash_Params_Data* params =
          reinterpret_cast<internal::GpuService_Crash_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuService_Crash_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Crash();
      return true;
    }
    case internal::kGpuService_Hang_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::Hang",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::Hang");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_Hang_Params_Data* params =
          reinterpret_cast<internal::GpuService_Hang_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuService_Hang_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Hang();
      return true;
    }
    case internal::kGpuService_ThrowJavaException_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::ThrowJavaException",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::ThrowJavaException");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::GpuService_ThrowJavaException_Params_Data* params =
          reinterpret_cast<internal::GpuService_ThrowJavaException_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      GpuService_ThrowJavaException_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ThrowJavaException();
      return true;
    }
    case internal::kGpuService_Stop_Name: {
      break;
    }
  }
  return false;
}

// static
bool GpuServiceStubDispatch::AcceptWithResponder(
    GpuService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kGpuService_EstablishGpuChannel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::EstablishGpuChannel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::EstablishGpuChannel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuService_EstablishGpuChannel_Params_Data* params =
          reinterpret_cast<
              internal::GpuService_EstablishGpuChannel_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int32_t p_client_id{};
      uint64_t p_client_tracing_id{};
      bool p_is_gpu_host{};
      bool p_cache_shaders_on_disk{};
      GpuService_EstablishGpuChannel_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_client_id = input_data_view.client_id();
      if (success)
        p_client_tracing_id = input_data_view.client_tracing_id();
      if (success)
        p_is_gpu_host = input_data_view.is_gpu_host();
      if (success)
        p_cache_shaders_on_disk = input_data_view.cache_shaders_on_disk();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 0, false);
        return false;
      }
      GpuService::EstablishGpuChannelCallback callback =
          GpuService_EstablishGpuChannel_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EstablishGpuChannel(
std::move(p_client_id), 
std::move(p_client_tracing_id), 
std::move(p_is_gpu_host), 
std::move(p_cache_shaders_on_disk), std::move(callback));
      return true;
    }
    case internal::kGpuService_CloseChannel_Name: {
      break;
    }
    case internal::kGpuService_CreateVideoEncodeAcceleratorProvider_Name: {
      break;
    }
    case internal::kGpuService_CreateGpuMemoryBuffer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::CreateGpuMemoryBuffer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::CreateGpuMemoryBuffer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuService_CreateGpuMemoryBuffer_Params_Data* params =
          reinterpret_cast<
              internal::GpuService_CreateGpuMemoryBuffer_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::gfx::GpuMemoryBufferId p_id{};
      ::gfx::Size p_size{};
      ::gfx::BufferFormat p_format{};
      ::gfx::BufferUsage p_usage{};
      int32_t p_client_id{};
      ::gpu::SurfaceHandle p_surface_handle{};
      GpuService_CreateGpuMemoryBuffer_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (success && !input_data_view.ReadFormat(&p_format))
        success = false;
      if (success && !input_data_view.ReadUsage(&p_usage))
        success = false;
      if (success)
        p_client_id = input_data_view.client_id();
      if (success && !input_data_view.ReadSurfaceHandle(&p_surface_handle))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 3, false);
        return false;
      }
      GpuService::CreateGpuMemoryBufferCallback callback =
          GpuService_CreateGpuMemoryBuffer_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateGpuMemoryBuffer(
std::move(p_id), 
std::move(p_size), 
std::move(p_format), 
std::move(p_usage), 
std::move(p_client_id), 
std::move(p_surface_handle), std::move(callback));
      return true;
    }
    case internal::kGpuService_DestroyGpuMemoryBuffer_Name: {
      break;
    }
    case internal::kGpuService_GetVideoMemoryUsageStats_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::GetVideoMemoryUsageStats",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::GetVideoMemoryUsageStats");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuService_GetVideoMemoryUsageStats_Params_Data* params =
          reinterpret_cast<
              internal::GpuService_GetVideoMemoryUsageStats_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      GpuService_GetVideoMemoryUsageStats_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 5, false);
        return false;
      }
      GpuService::GetVideoMemoryUsageStatsCallback callback =
          GpuService_GetVideoMemoryUsageStats_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetVideoMemoryUsageStats(std::move(callback));
      return true;
    }
    case internal::kGpuService_StartPeakMemoryMonitor_Name: {
      break;
    }
    case internal::kGpuService_GetPeakMemoryUsage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::GetPeakMemoryUsage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::GetPeakMemoryUsage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuService_GetPeakMemoryUsage_Params_Data* params =
          reinterpret_cast<
              internal::GpuService_GetPeakMemoryUsage_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint32_t p_sequence_num{};
      GpuService_GetPeakMemoryUsage_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_sequence_num = input_data_view.sequence_num();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 7, false);
        return false;
      }
      GpuService::GetPeakMemoryUsageCallback callback =
          GpuService_GetPeakMemoryUsage_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPeakMemoryUsage(
std::move(p_sequence_num), std::move(callback));
      return true;
    }
    case internal::kGpuService_RequestHDRStatus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::RequestHDRStatus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::RequestHDRStatus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuService_RequestHDRStatus_Params_Data* params =
          reinterpret_cast<
              internal::GpuService_RequestHDRStatus_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      GpuService_RequestHDRStatus_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 8, false);
        return false;
      }
      GpuService::RequestHDRStatusCallback callback =
          GpuService_RequestHDRStatus_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestHDRStatus(std::move(callback));
      return true;
    }
    case internal::kGpuService_LoadedShader_Name: {
      break;
    }
    case internal::kGpuService_WakeUpGpu_Name: {
      break;
    }
    case internal::kGpuService_GpuSwitched_Name: {
      break;
    }
    case internal::kGpuService_DisplayAdded_Name: {
      break;
    }
    case internal::kGpuService_DisplayRemoved_Name: {
      break;
    }
    case internal::kGpuService_DestroyAllChannels_Name: {
      break;
    }
    case internal::kGpuService_OnBackgroundCleanup_Name: {
      break;
    }
    case internal::kGpuService_OnBackgrounded_Name: {
      break;
    }
    case internal::kGpuService_OnForegrounded_Name: {
      break;
    }
    case internal::kGpuService_OnMemoryPressure_Name: {
      break;
    }
    case internal::kGpuService_Crash_Name: {
      break;
    }
    case internal::kGpuService_Hang_Name: {
      break;
    }
    case internal::kGpuService_ThrowJavaException_Name: {
      break;
    }
    case internal::kGpuService_Stop_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::GpuService::Stop",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::GpuService::Stop");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::GpuService_Stop_Params_Data* params =
          reinterpret_cast<
              internal::GpuService_Stop_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      GpuService_Stop_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GpuService::Name_, 22, false);
        return false;
      }
      GpuService::StopCallback callback =
          GpuService_Stop_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGpuServiceValidationInfo[] = {
    {internal::kGpuService_EstablishGpuChannel_Name,
     {&internal::GpuService_EstablishGpuChannel_Params_Data::Validate,
      &internal::GpuService_EstablishGpuChannel_ResponseParams_Data::Validate}},
    {internal::kGpuService_CloseChannel_Name,
     {&internal::GpuService_CloseChannel_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_CreateVideoEncodeAcceleratorProvider_Name,
     {&internal::GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_CreateGpuMemoryBuffer_Name,
     {&internal::GpuService_CreateGpuMemoryBuffer_Params_Data::Validate,
      &internal::GpuService_CreateGpuMemoryBuffer_ResponseParams_Data::Validate}},
    {internal::kGpuService_DestroyGpuMemoryBuffer_Name,
     {&internal::GpuService_DestroyGpuMemoryBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_GetVideoMemoryUsageStats_Name,
     {&internal::GpuService_GetVideoMemoryUsageStats_Params_Data::Validate,
      &internal::GpuService_GetVideoMemoryUsageStats_ResponseParams_Data::Validate}},
    {internal::kGpuService_StartPeakMemoryMonitor_Name,
     {&internal::GpuService_StartPeakMemoryMonitor_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_GetPeakMemoryUsage_Name,
     {&internal::GpuService_GetPeakMemoryUsage_Params_Data::Validate,
      &internal::GpuService_GetPeakMemoryUsage_ResponseParams_Data::Validate}},
    {internal::kGpuService_RequestHDRStatus_Name,
     {&internal::GpuService_RequestHDRStatus_Params_Data::Validate,
      &internal::GpuService_RequestHDRStatus_ResponseParams_Data::Validate}},
    {internal::kGpuService_LoadedShader_Name,
     {&internal::GpuService_LoadedShader_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_WakeUpGpu_Name,
     {&internal::GpuService_WakeUpGpu_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_GpuSwitched_Name,
     {&internal::GpuService_GpuSwitched_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_DisplayAdded_Name,
     {&internal::GpuService_DisplayAdded_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_DisplayRemoved_Name,
     {&internal::GpuService_DisplayRemoved_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_DestroyAllChannels_Name,
     {&internal::GpuService_DestroyAllChannels_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_OnBackgroundCleanup_Name,
     {&internal::GpuService_OnBackgroundCleanup_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_OnBackgrounded_Name,
     {&internal::GpuService_OnBackgrounded_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_OnForegrounded_Name,
     {&internal::GpuService_OnForegrounded_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_OnMemoryPressure_Name,
     {&internal::GpuService_OnMemoryPressure_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_Crash_Name,
     {&internal::GpuService_Crash_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_Hang_Name,
     {&internal::GpuService_Hang_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_ThrowJavaException_Name,
     {&internal::GpuService_ThrowJavaException_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGpuService_Stop_Name,
     {&internal::GpuService_Stop_Params_Data::Validate,
      &internal::GpuService_Stop_ResponseParams_Data::Validate}},
};

bool GpuServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::GpuService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGpuServiceValidationInfo);
}

bool GpuServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::GpuService::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kGpuServiceValidationInfo);

}
}  // namespace mojom
}  // namespace viz

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif