// This file is generated by TypeBuilder_cpp.template.

// Copyright (c) 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "src/inspector/protocol/Runtime.h"

#include "src/inspector/protocol/Protocol.h"

#include "v8//third_party/inspector_protocol/crdtp/cbor.h"
#include "v8//third_party/inspector_protocol/crdtp/find_by_first.h"
#include "v8//third_party/inspector_protocol/crdtp/span.h"

namespace v8_inspector {
namespace protocol {
namespace Runtime {

using v8_crdtp::DeserializerState;
using v8_crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Runtime";
const char Metainfo::commandPrefix[] = "Runtime.";
const char Metainfo::version[] = "1.3";





const char* RemoteObject::TypeEnum::Object = "object";
const char* RemoteObject::TypeEnum::Function = "function";
const char* RemoteObject::TypeEnum::Undefined = "undefined";
const char* RemoteObject::TypeEnum::String = "string";
const char* RemoteObject::TypeEnum::Number = "number";
const char* RemoteObject::TypeEnum::Boolean = "boolean";
const char* RemoteObject::TypeEnum::Symbol = "symbol";
const char* RemoteObject::TypeEnum::Bigint = "bigint";
const char* RemoteObject::TypeEnum::Wasm = "wasm";

const char* RemoteObject::SubtypeEnum::Array = "array";
const char* RemoteObject::SubtypeEnum::Null = "null";
const char* RemoteObject::SubtypeEnum::Node = "node";
const char* RemoteObject::SubtypeEnum::Regexp = "regexp";
const char* RemoteObject::SubtypeEnum::Date = "date";
const char* RemoteObject::SubtypeEnum::Map = "map";
const char* RemoteObject::SubtypeEnum::Set = "set";
const char* RemoteObject::SubtypeEnum::Weakmap = "weakmap";
const char* RemoteObject::SubtypeEnum::Weakset = "weakset";
const char* RemoteObject::SubtypeEnum::Iterator = "iterator";
const char* RemoteObject::SubtypeEnum::Generator = "generator";
const char* RemoteObject::SubtypeEnum::Error = "error";
const char* RemoteObject::SubtypeEnum::Proxy = "proxy";
const char* RemoteObject::SubtypeEnum::Promise = "promise";
const char* RemoteObject::SubtypeEnum::Typedarray = "typedarray";
const char* RemoteObject::SubtypeEnum::Arraybuffer = "arraybuffer";
const char* RemoteObject::SubtypeEnum::Dataview = "dataview";
const char* RemoteObject::SubtypeEnum::I32 = "i32";
const char* RemoteObject::SubtypeEnum::I64 = "i64";
const char* RemoteObject::SubtypeEnum::F32 = "f32";
const char* RemoteObject::SubtypeEnum::F64 = "f64";
const char* RemoteObject::SubtypeEnum::V128 = "v128";
const char* RemoteObject::SubtypeEnum::Externref = "externref";
V8_CRDTP_BEGIN_DESERIALIZER(RemoteObject)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("className", m_className),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("customPreview", m_customPreview),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("description", m_description),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("objectId", m_objectId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("preview", m_preview),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("subtype", m_subtype),
    V8_CRDTP_DESERIALIZE_FIELD("type", m_type),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("unserializableValue", m_unserializableValue),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("value", m_value),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(RemoteObject)
    V8_CRDTP_SERIALIZE_FIELD("type", m_type);
    V8_CRDTP_SERIALIZE_FIELD("subtype", m_subtype);
    V8_CRDTP_SERIALIZE_FIELD("className", m_className);
    V8_CRDTP_SERIALIZE_FIELD("value", m_value);
    V8_CRDTP_SERIALIZE_FIELD("unserializableValue", m_unserializableValue);
    V8_CRDTP_SERIALIZE_FIELD("description", m_description);
    V8_CRDTP_SERIALIZE_FIELD("objectId", m_objectId);
    V8_CRDTP_SERIALIZE_FIELD("preview", m_preview);
    V8_CRDTP_SERIALIZE_FIELD("customPreview", m_customPreview);
V8_CRDTP_END_SERIALIZER();

// static
std::unique_ptr<API::RemoteObject> API::RemoteObject::fromBinary(const uint8_t* data, size_t length)
{
    return protocol::Runtime::RemoteObject::FromBinary(data, length);
}

V8_CRDTP_BEGIN_DESERIALIZER(CustomPreview)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("bodyGetterId", m_bodyGetterId),
    V8_CRDTP_DESERIALIZE_FIELD("header", m_header),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(CustomPreview)
    V8_CRDTP_SERIALIZE_FIELD("header", m_header);
    V8_CRDTP_SERIALIZE_FIELD("bodyGetterId", m_bodyGetterId);
V8_CRDTP_END_SERIALIZER();



const char* ObjectPreview::TypeEnum::Object = "object";
const char* ObjectPreview::TypeEnum::Function = "function";
const char* ObjectPreview::TypeEnum::Undefined = "undefined";
const char* ObjectPreview::TypeEnum::String = "string";
const char* ObjectPreview::TypeEnum::Number = "number";
const char* ObjectPreview::TypeEnum::Boolean = "boolean";
const char* ObjectPreview::TypeEnum::Symbol = "symbol";
const char* ObjectPreview::TypeEnum::Bigint = "bigint";

const char* ObjectPreview::SubtypeEnum::Array = "array";
const char* ObjectPreview::SubtypeEnum::Null = "null";
const char* ObjectPreview::SubtypeEnum::Node = "node";
const char* ObjectPreview::SubtypeEnum::Regexp = "regexp";
const char* ObjectPreview::SubtypeEnum::Date = "date";
const char* ObjectPreview::SubtypeEnum::Map = "map";
const char* ObjectPreview::SubtypeEnum::Set = "set";
const char* ObjectPreview::SubtypeEnum::Weakmap = "weakmap";
const char* ObjectPreview::SubtypeEnum::Weakset = "weakset";
const char* ObjectPreview::SubtypeEnum::Iterator = "iterator";
const char* ObjectPreview::SubtypeEnum::Generator = "generator";
const char* ObjectPreview::SubtypeEnum::Error = "error";
V8_CRDTP_BEGIN_DESERIALIZER(ObjectPreview)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("description", m_description),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("entries", m_entries),
    V8_CRDTP_DESERIALIZE_FIELD("overflow", m_overflow),
    V8_CRDTP_DESERIALIZE_FIELD("properties", m_properties),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("subtype", m_subtype),
    V8_CRDTP_DESERIALIZE_FIELD("type", m_type),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(ObjectPreview)
    V8_CRDTP_SERIALIZE_FIELD("type", m_type);
    V8_CRDTP_SERIALIZE_FIELD("subtype", m_subtype);
    V8_CRDTP_SERIALIZE_FIELD("description", m_description);
    V8_CRDTP_SERIALIZE_FIELD("overflow", m_overflow);
    V8_CRDTP_SERIALIZE_FIELD("properties", m_properties);
    V8_CRDTP_SERIALIZE_FIELD("entries", m_entries);
V8_CRDTP_END_SERIALIZER();



const char* PropertyPreview::TypeEnum::Object = "object";
const char* PropertyPreview::TypeEnum::Function = "function";
const char* PropertyPreview::TypeEnum::Undefined = "undefined";
const char* PropertyPreview::TypeEnum::String = "string";
const char* PropertyPreview::TypeEnum::Number = "number";
const char* PropertyPreview::TypeEnum::Boolean = "boolean";
const char* PropertyPreview::TypeEnum::Symbol = "symbol";
const char* PropertyPreview::TypeEnum::Accessor = "accessor";
const char* PropertyPreview::TypeEnum::Bigint = "bigint";

const char* PropertyPreview::SubtypeEnum::Array = "array";
const char* PropertyPreview::SubtypeEnum::Null = "null";
const char* PropertyPreview::SubtypeEnum::Node = "node";
const char* PropertyPreview::SubtypeEnum::Regexp = "regexp";
const char* PropertyPreview::SubtypeEnum::Date = "date";
const char* PropertyPreview::SubtypeEnum::Map = "map";
const char* PropertyPreview::SubtypeEnum::Set = "set";
const char* PropertyPreview::SubtypeEnum::Weakmap = "weakmap";
const char* PropertyPreview::SubtypeEnum::Weakset = "weakset";
const char* PropertyPreview::SubtypeEnum::Iterator = "iterator";
const char* PropertyPreview::SubtypeEnum::Generator = "generator";
const char* PropertyPreview::SubtypeEnum::Error = "error";
V8_CRDTP_BEGIN_DESERIALIZER(PropertyPreview)
    V8_CRDTP_DESERIALIZE_FIELD("name", m_name),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("subtype", m_subtype),
    V8_CRDTP_DESERIALIZE_FIELD("type", m_type),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("value", m_value),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("valuePreview", m_valuePreview),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(PropertyPreview)
    V8_CRDTP_SERIALIZE_FIELD("name", m_name);
    V8_CRDTP_SERIALIZE_FIELD("type", m_type);
    V8_CRDTP_SERIALIZE_FIELD("value", m_value);
    V8_CRDTP_SERIALIZE_FIELD("valuePreview", m_valuePreview);
    V8_CRDTP_SERIALIZE_FIELD("subtype", m_subtype);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(EntryPreview)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("key", m_key),
    V8_CRDTP_DESERIALIZE_FIELD("value", m_value),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(EntryPreview)
    V8_CRDTP_SERIALIZE_FIELD("key", m_key);
    V8_CRDTP_SERIALIZE_FIELD("value", m_value);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(PropertyDescriptor)
    V8_CRDTP_DESERIALIZE_FIELD("configurable", m_configurable),
    V8_CRDTP_DESERIALIZE_FIELD("enumerable", m_enumerable),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("get", m_get),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("isOwn", m_isOwn),
    V8_CRDTP_DESERIALIZE_FIELD("name", m_name),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("set", m_set),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("symbol", m_symbol),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("value", m_value),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("wasThrown", m_wasThrown),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("writable", m_writable),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(PropertyDescriptor)
    V8_CRDTP_SERIALIZE_FIELD("name", m_name);
    V8_CRDTP_SERIALIZE_FIELD("value", m_value);
    V8_CRDTP_SERIALIZE_FIELD("writable", m_writable);
    V8_CRDTP_SERIALIZE_FIELD("get", m_get);
    V8_CRDTP_SERIALIZE_FIELD("set", m_set);
    V8_CRDTP_SERIALIZE_FIELD("configurable", m_configurable);
    V8_CRDTP_SERIALIZE_FIELD("enumerable", m_enumerable);
    V8_CRDTP_SERIALIZE_FIELD("wasThrown", m_wasThrown);
    V8_CRDTP_SERIALIZE_FIELD("isOwn", m_isOwn);
    V8_CRDTP_SERIALIZE_FIELD("symbol", m_symbol);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(InternalPropertyDescriptor)
    V8_CRDTP_DESERIALIZE_FIELD("name", m_name),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("value", m_value),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(InternalPropertyDescriptor)
    V8_CRDTP_SERIALIZE_FIELD("name", m_name);
    V8_CRDTP_SERIALIZE_FIELD("value", m_value);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(PrivatePropertyDescriptor)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("get", m_get),
    V8_CRDTP_DESERIALIZE_FIELD("name", m_name),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("set", m_set),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("value", m_value),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(PrivatePropertyDescriptor)
    V8_CRDTP_SERIALIZE_FIELD("name", m_name);
    V8_CRDTP_SERIALIZE_FIELD("value", m_value);
    V8_CRDTP_SERIALIZE_FIELD("get", m_get);
    V8_CRDTP_SERIALIZE_FIELD("set", m_set);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(CallArgument)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("objectId", m_objectId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("unserializableValue", m_unserializableValue),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("value", m_value),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(CallArgument)
    V8_CRDTP_SERIALIZE_FIELD("value", m_value);
    V8_CRDTP_SERIALIZE_FIELD("unserializableValue", m_unserializableValue);
    V8_CRDTP_SERIALIZE_FIELD("objectId", m_objectId);
V8_CRDTP_END_SERIALIZER();



V8_CRDTP_BEGIN_DESERIALIZER(ExecutionContextDescription)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("auxData", m_auxData),
    V8_CRDTP_DESERIALIZE_FIELD("id", m_id),
    V8_CRDTP_DESERIALIZE_FIELD("name", m_name),
    V8_CRDTP_DESERIALIZE_FIELD("origin", m_origin),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(ExecutionContextDescription)
    V8_CRDTP_SERIALIZE_FIELD("id", m_id);
    V8_CRDTP_SERIALIZE_FIELD("origin", m_origin);
    V8_CRDTP_SERIALIZE_FIELD("name", m_name);
    V8_CRDTP_SERIALIZE_FIELD("auxData", m_auxData);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(ExceptionDetails)
    V8_CRDTP_DESERIALIZE_FIELD("columnNumber", m_columnNumber),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("exception", m_exception),
    V8_CRDTP_DESERIALIZE_FIELD("exceptionId", m_exceptionId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("executionContextId", m_executionContextId),
    V8_CRDTP_DESERIALIZE_FIELD("lineNumber", m_lineNumber),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("scriptId", m_scriptId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("stackTrace", m_stackTrace),
    V8_CRDTP_DESERIALIZE_FIELD("text", m_text),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("url", m_url),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(ExceptionDetails)
    V8_CRDTP_SERIALIZE_FIELD("exceptionId", m_exceptionId);
    V8_CRDTP_SERIALIZE_FIELD("text", m_text);
    V8_CRDTP_SERIALIZE_FIELD("lineNumber", m_lineNumber);
    V8_CRDTP_SERIALIZE_FIELD("columnNumber", m_columnNumber);
    V8_CRDTP_SERIALIZE_FIELD("scriptId", m_scriptId);
    V8_CRDTP_SERIALIZE_FIELD("url", m_url);
    V8_CRDTP_SERIALIZE_FIELD("stackTrace", m_stackTrace);
    V8_CRDTP_SERIALIZE_FIELD("exception", m_exception);
    V8_CRDTP_SERIALIZE_FIELD("executionContextId", m_executionContextId);
V8_CRDTP_END_SERIALIZER();




V8_CRDTP_BEGIN_DESERIALIZER(CallFrame)
    V8_CRDTP_DESERIALIZE_FIELD("columnNumber", m_columnNumber),
    V8_CRDTP_DESERIALIZE_FIELD("functionName", m_functionName),
    V8_CRDTP_DESERIALIZE_FIELD("lineNumber", m_lineNumber),
    V8_CRDTP_DESERIALIZE_FIELD("scriptId", m_scriptId),
    V8_CRDTP_DESERIALIZE_FIELD("url", m_url),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(CallFrame)
    V8_CRDTP_SERIALIZE_FIELD("functionName", m_functionName);
    V8_CRDTP_SERIALIZE_FIELD("scriptId", m_scriptId);
    V8_CRDTP_SERIALIZE_FIELD("url", m_url);
    V8_CRDTP_SERIALIZE_FIELD("lineNumber", m_lineNumber);
    V8_CRDTP_SERIALIZE_FIELD("columnNumber", m_columnNumber);
V8_CRDTP_END_SERIALIZER();


V8_CRDTP_BEGIN_DESERIALIZER(StackTrace)
    V8_CRDTP_DESERIALIZE_FIELD("callFrames", m_callFrames),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("description", m_description),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("parent", m_parent),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("parentId", m_parentId),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(StackTrace)
    V8_CRDTP_SERIALIZE_FIELD("description", m_description);
    V8_CRDTP_SERIALIZE_FIELD("callFrames", m_callFrames);
    V8_CRDTP_SERIALIZE_FIELD("parent", m_parent);
    V8_CRDTP_SERIALIZE_FIELD("parentId", m_parentId);
V8_CRDTP_END_SERIALIZER();

// static
std::unique_ptr<API::StackTrace> API::StackTrace::fromBinary(const uint8_t* data, size_t length)
{
    return protocol::Runtime::StackTrace::FromBinary(data, length);
}


V8_CRDTP_BEGIN_DESERIALIZER(StackTraceId)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("debuggerId", m_debuggerId),
    V8_CRDTP_DESERIALIZE_FIELD("id", m_id),
V8_CRDTP_END_DESERIALIZER()

V8_CRDTP_BEGIN_SERIALIZER(StackTraceId)
    V8_CRDTP_SERIALIZE_FIELD("id", m_id);
    V8_CRDTP_SERIALIZE_FIELD("debuggerId", m_debuggerId);
V8_CRDTP_END_SERIALIZER();

// static
std::unique_ptr<API::StackTraceId> API::StackTraceId::fromBinary(const uint8_t* data, size_t length)
{
    return protocol::Runtime::StackTraceId::FromBinary(data, length);
}

// ------------- Enum values from params.


namespace ConsoleAPICalled {
namespace TypeEnum {
const char* Log = "log";
const char* Debug = "debug";
const char* Info = "info";
const char* Error = "error";
const char* Warning = "warning";
const char* Dir = "dir";
const char* Dirxml = "dirxml";
const char* Table = "table";
const char* Trace = "trace";
const char* Clear = "clear";
const char* StartGroup = "startGroup";
const char* StartGroupCollapsed = "startGroupCollapsed";
const char* EndGroup = "endGroup";
const char* Assert = "assert";
const char* Profile = "profile";
const char* ProfileEnd = "profileEnd";
const char* Count = "count";
const char* TimeEnd = "timeEnd";
} // namespace TypeEnum
} // namespace ConsoleAPICalled

// ------------- Frontend notifications.

void Frontend::bindingCalled(const String& name, const String& payload, int executionContextId)
{
    if (!frontend_channel_)
        return;
    v8_crdtp::ObjectSerializer serializer;
    serializer.AddField(v8_crdtp::MakeSpan("name"), name);
    serializer.AddField(v8_crdtp::MakeSpan("payload"), payload);
    serializer.AddField(v8_crdtp::MakeSpan("executionContextId"), executionContextId);
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Runtime.bindingCalled", serializer.Finish()));
}

void Frontend::consoleAPICalled(const String& type, std::unique_ptr<protocol::Array<protocol::Runtime::RemoteObject>> args, int executionContextId, double timestamp, Maybe<protocol::Runtime::StackTrace> stackTrace, Maybe<String> context)
{
    if (!frontend_channel_)
        return;
    v8_crdtp::ObjectSerializer serializer;
    serializer.AddField(v8_crdtp::MakeSpan("type"), type);
    serializer.AddField(v8_crdtp::MakeSpan("args"), args);
    serializer.AddField(v8_crdtp::MakeSpan("executionContextId"), executionContextId);
    serializer.AddField(v8_crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(v8_crdtp::MakeSpan("stackTrace"), stackTrace);
    serializer.AddField(v8_crdtp::MakeSpan("context"), context);
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Runtime.consoleAPICalled", serializer.Finish()));
}

void Frontend::exceptionRevoked(const String& reason, int exceptionId)
{
    if (!frontend_channel_)
        return;
    v8_crdtp::ObjectSerializer serializer;
    serializer.AddField(v8_crdtp::MakeSpan("reason"), reason);
    serializer.AddField(v8_crdtp::MakeSpan("exceptionId"), exceptionId);
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Runtime.exceptionRevoked", serializer.Finish()));
}

void Frontend::exceptionThrown(double timestamp, std::unique_ptr<protocol::Runtime::ExceptionDetails> exceptionDetails)
{
    if (!frontend_channel_)
        return;
    v8_crdtp::ObjectSerializer serializer;
    serializer.AddField(v8_crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(v8_crdtp::MakeSpan("exceptionDetails"), exceptionDetails);
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Runtime.exceptionThrown", serializer.Finish()));
}

void Frontend::executionContextCreated(std::unique_ptr<protocol::Runtime::ExecutionContextDescription> context)
{
    if (!frontend_channel_)
        return;
    v8_crdtp::ObjectSerializer serializer;
    serializer.AddField(v8_crdtp::MakeSpan("context"), context);
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Runtime.executionContextCreated", serializer.Finish()));
}

void Frontend::executionContextDestroyed(int executionContextId)
{
    if (!frontend_channel_)
        return;
    v8_crdtp::ObjectSerializer serializer;
    serializer.AddField(v8_crdtp::MakeSpan("executionContextId"), executionContextId);
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Runtime.executionContextDestroyed", serializer.Finish()));
}

void Frontend::executionContextsCleared()
{
    if (!frontend_channel_)
        return;
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Runtime.executionContextsCleared"));
}

void Frontend::inspectRequested(std::unique_ptr<protocol::Runtime::RemoteObject> object, std::unique_ptr<protocol::DictionaryValue> hints)
{
    if (!frontend_channel_)
        return;
    v8_crdtp::ObjectSerializer serializer;
    serializer.AddField(v8_crdtp::MakeSpan("object"), object);
    serializer.AddField(v8_crdtp::MakeSpan("hints"), hints);
    frontend_channel_->SendProtocolNotification(v8_crdtp::CreateNotification("Runtime.inspectRequested", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const v8_crdtp::Dispatchable& dispatchable);

    std::function<void(const v8_crdtp::Dispatchable&)> Dispatch(v8_crdtp::span<uint8_t> command_name) override;

    void awaitPromise(const v8_crdtp::Dispatchable& dispatchable);
    void callFunctionOn(const v8_crdtp::Dispatchable& dispatchable);
    void compileScript(const v8_crdtp::Dispatchable& dispatchable);
    void disable(const v8_crdtp::Dispatchable& dispatchable);
    void discardConsoleEntries(const v8_crdtp::Dispatchable& dispatchable);
    void enable(const v8_crdtp::Dispatchable& dispatchable);
    void evaluate(const v8_crdtp::Dispatchable& dispatchable);
    void getIsolateId(const v8_crdtp::Dispatchable& dispatchable);
    void getHeapUsage(const v8_crdtp::Dispatchable& dispatchable);
    void getProperties(const v8_crdtp::Dispatchable& dispatchable);
    void globalLexicalScopeNames(const v8_crdtp::Dispatchable& dispatchable);
    void queryObjects(const v8_crdtp::Dispatchable& dispatchable);
    void releaseObject(const v8_crdtp::Dispatchable& dispatchable);
    void releaseObjectGroup(const v8_crdtp::Dispatchable& dispatchable);
    void runIfWaitingForDebugger(const v8_crdtp::Dispatchable& dispatchable);
    void runScript(const v8_crdtp::Dispatchable& dispatchable);
    void setCustomObjectFormatterEnabled(const v8_crdtp::Dispatchable& dispatchable);
    void setMaxCallStackSizeToCapture(const v8_crdtp::Dispatchable& dispatchable);
    void terminateExecution(const v8_crdtp::Dispatchable& dispatchable);
    void addBinding(const v8_crdtp::Dispatchable& dispatchable);
    void removeBinding(const v8_crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(v8_crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<v8_crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          v8_crdtp::SpanFrom("addBinding"),
          &DomainDispatcherImpl::addBinding
    },
    {
          v8_crdtp::SpanFrom("awaitPromise"),
          &DomainDispatcherImpl::awaitPromise
    },
    {
          v8_crdtp::SpanFrom("callFunctionOn"),
          &DomainDispatcherImpl::callFunctionOn
    },
    {
          v8_crdtp::SpanFrom("compileScript"),
          &DomainDispatcherImpl::compileScript
    },
    {
          v8_crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          v8_crdtp::SpanFrom("discardConsoleEntries"),
          &DomainDispatcherImpl::discardConsoleEntries
    },
    {
          v8_crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          v8_crdtp::SpanFrom("evaluate"),
          &DomainDispatcherImpl::evaluate
    },
    {
          v8_crdtp::SpanFrom("getHeapUsage"),
          &DomainDispatcherImpl::getHeapUsage
    },
    {
          v8_crdtp::SpanFrom("getIsolateId"),
          &DomainDispatcherImpl::getIsolateId
    },
    {
          v8_crdtp::SpanFrom("getProperties"),
          &DomainDispatcherImpl::getProperties
    },
    {
          v8_crdtp::SpanFrom("globalLexicalScopeNames"),
          &DomainDispatcherImpl::globalLexicalScopeNames
    },
    {
          v8_crdtp::SpanFrom("queryObjects"),
          &DomainDispatcherImpl::queryObjects
    },
    {
          v8_crdtp::SpanFrom("releaseObject"),
          &DomainDispatcherImpl::releaseObject
    },
    {
          v8_crdtp::SpanFrom("releaseObjectGroup"),
          &DomainDispatcherImpl::releaseObjectGroup
    },
    {
          v8_crdtp::SpanFrom("removeBinding"),
          &DomainDispatcherImpl::removeBinding
    },
    {
          v8_crdtp::SpanFrom("runIfWaitingForDebugger"),
          &DomainDispatcherImpl::runIfWaitingForDebugger
    },
    {
          v8_crdtp::SpanFrom("runScript"),
          &DomainDispatcherImpl::runScript
    },
    {
          v8_crdtp::SpanFrom("setCustomObjectFormatterEnabled"),
          &DomainDispatcherImpl::setCustomObjectFormatterEnabled
    },
    {
          v8_crdtp::SpanFrom("setMaxCallStackSizeToCapture"),
          &DomainDispatcherImpl::setMaxCallStackSizeToCapture
    },
    {
          v8_crdtp::SpanFrom("terminateExecution"),
          &DomainDispatcherImpl::terminateExecution
    },
    };
    return commands;
  }();
  return v8_crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const v8_crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(v8_crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const v8_crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


class AwaitPromiseCallbackImpl : public Backend::AwaitPromiseCallback, public DomainDispatcher::Callback {
public:
    AwaitPromiseCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, v8_crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
v8_crdtp::SpanFrom("Runtime.awaitPromise"), message) { }

    void sendSuccess(std::unique_ptr<protocol::Runtime::RemoteObject> result, Maybe<protocol::Runtime::ExceptionDetails> exceptionDetails) override
    {
        v8_crdtp::ObjectSerializer serializer;
        serializer.AddField(v8_crdtp::MakeSpan("result"), result);
        serializer.AddField(v8_crdtp::MakeSpan("exceptionDetails"), exceptionDetails);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct awaitPromiseParams : public v8_crdtp::DeserializableProtocolObject<awaitPromiseParams> {
    String promiseObjectId;
    Maybe<bool> returnByValue;
    Maybe<bool> generatePreview;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(awaitPromiseParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("generatePreview", generatePreview),
    V8_CRDTP_DESERIALIZE_FIELD("promiseObjectId", promiseObjectId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("returnByValue", returnByValue),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::awaitPromise(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    awaitPromiseParams params;
    awaitPromiseParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    m_backend->awaitPromise(params.promiseObjectId, std::move(params.returnByValue), std::move(params.generatePreview), std::make_unique<AwaitPromiseCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class CallFunctionOnCallbackImpl : public Backend::CallFunctionOnCallback, public DomainDispatcher::Callback {
public:
    CallFunctionOnCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, v8_crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
v8_crdtp::SpanFrom("Runtime.callFunctionOn"), message) { }

    void sendSuccess(std::unique_ptr<protocol::Runtime::RemoteObject> result, Maybe<protocol::Runtime::ExceptionDetails> exceptionDetails) override
    {
        v8_crdtp::ObjectSerializer serializer;
        serializer.AddField(v8_crdtp::MakeSpan("result"), result);
        serializer.AddField(v8_crdtp::MakeSpan("exceptionDetails"), exceptionDetails);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct callFunctionOnParams : public v8_crdtp::DeserializableProtocolObject<callFunctionOnParams> {
    String functionDeclaration;
    Maybe<String> objectId;
    Maybe<protocol::Array<protocol::Runtime::CallArgument>> arguments;
    Maybe<bool> silent;
    Maybe<bool> returnByValue;
    Maybe<bool> generatePreview;
    Maybe<bool> userGesture;
    Maybe<bool> awaitPromise;
    Maybe<int> executionContextId;
    Maybe<String> objectGroup;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(callFunctionOnParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("arguments", arguments),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("awaitPromise", awaitPromise),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("executionContextId", executionContextId),
    V8_CRDTP_DESERIALIZE_FIELD("functionDeclaration", functionDeclaration),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("generatePreview", generatePreview),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("objectGroup", objectGroup),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("objectId", objectId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("returnByValue", returnByValue),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("silent", silent),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("userGesture", userGesture),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::callFunctionOn(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    callFunctionOnParams params;
    callFunctionOnParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    m_backend->callFunctionOn(params.functionDeclaration, std::move(params.objectId), std::move(params.arguments), std::move(params.silent), std::move(params.returnByValue), std::move(params.generatePreview), std::move(params.userGesture), std::move(params.awaitPromise), std::move(params.executionContextId), std::move(params.objectGroup), std::make_unique<CallFunctionOnCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {

struct compileScriptParams : public v8_crdtp::DeserializableProtocolObject<compileScriptParams> {
    String expression;
    String sourceURL;
    bool persistScript;
    Maybe<int> executionContextId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(compileScriptParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("executionContextId", executionContextId),
    V8_CRDTP_DESERIALIZE_FIELD("expression", expression),
    V8_CRDTP_DESERIALIZE_FIELD("persistScript", persistScript),
    V8_CRDTP_DESERIALIZE_FIELD("sourceURL", sourceURL),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::compileScript(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    compileScriptParams params;
    compileScriptParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;

    // Declare output parameters.
    Maybe<String> out_scriptId;
    Maybe<protocol::Runtime::ExceptionDetails> out_exceptionDetails;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->compileScript(params.expression, params.sourceURL, params.persistScript, std::move(params.executionContextId), &out_scriptId, &out_exceptionDetails);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.compileScript"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("scriptId"), out_scriptId);
          serializer.AddField(v8_crdtp::MakeSpan("exceptionDetails"), out_exceptionDetails);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::disable(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::discardConsoleEntries(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->discardConsoleEntries();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.discardConsoleEntries"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::enable(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

class EvaluateCallbackImpl : public Backend::EvaluateCallback, public DomainDispatcher::Callback {
public:
    EvaluateCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, v8_crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
v8_crdtp::SpanFrom("Runtime.evaluate"), message) { }

    void sendSuccess(std::unique_ptr<protocol::Runtime::RemoteObject> result, Maybe<protocol::Runtime::ExceptionDetails> exceptionDetails) override
    {
        v8_crdtp::ObjectSerializer serializer;
        serializer.AddField(v8_crdtp::MakeSpan("result"), result);
        serializer.AddField(v8_crdtp::MakeSpan("exceptionDetails"), exceptionDetails);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct evaluateParams : public v8_crdtp::DeserializableProtocolObject<evaluateParams> {
    String expression;
    Maybe<String> objectGroup;
    Maybe<bool> includeCommandLineAPI;
    Maybe<bool> silent;
    Maybe<int> contextId;
    Maybe<bool> returnByValue;
    Maybe<bool> generatePreview;
    Maybe<bool> userGesture;
    Maybe<bool> awaitPromise;
    Maybe<bool> throwOnSideEffect;
    Maybe<double> timeout;
    Maybe<bool> disableBreaks;
    Maybe<bool> replMode;
    Maybe<bool> allowUnsafeEvalBlockedByCSP;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(evaluateParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("allowUnsafeEvalBlockedByCSP", allowUnsafeEvalBlockedByCSP),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("awaitPromise", awaitPromise),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("contextId", contextId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("disableBreaks", disableBreaks),
    V8_CRDTP_DESERIALIZE_FIELD("expression", expression),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("generatePreview", generatePreview),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("includeCommandLineAPI", includeCommandLineAPI),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("objectGroup", objectGroup),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("replMode", replMode),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("returnByValue", returnByValue),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("silent", silent),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("throwOnSideEffect", throwOnSideEffect),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("timeout", timeout),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("userGesture", userGesture),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::evaluate(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    evaluateParams params;
    evaluateParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    m_backend->evaluate(params.expression, std::move(params.objectGroup), std::move(params.includeCommandLineAPI), std::move(params.silent), std::move(params.contextId), std::move(params.returnByValue), std::move(params.generatePreview), std::move(params.userGesture), std::move(params.awaitPromise), std::move(params.throwOnSideEffect), std::move(params.timeout), std::move(params.disableBreaks), std::move(params.replMode), std::move(params.allowUnsafeEvalBlockedByCSP), std::make_unique<EvaluateCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {


}  // namespace

void DomainDispatcherImpl::getIsolateId(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    // Declare output parameters.
    String out_id;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getIsolateId(&out_id);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.getIsolateId"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("id"), out_id);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::getHeapUsage(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    // Declare output parameters.
    double out_usedSize;
    double out_totalSize;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getHeapUsage(&out_usedSize, &out_totalSize);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.getHeapUsage"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("usedSize"), out_usedSize);
          serializer.AddField(v8_crdtp::MakeSpan("totalSize"), out_totalSize);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getPropertiesParams : public v8_crdtp::DeserializableProtocolObject<getPropertiesParams> {
    String objectId;
    Maybe<bool> ownProperties;
    Maybe<bool> accessorPropertiesOnly;
    Maybe<bool> generatePreview;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(getPropertiesParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("accessorPropertiesOnly", accessorPropertiesOnly),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("generatePreview", generatePreview),
    V8_CRDTP_DESERIALIZE_FIELD("objectId", objectId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("ownProperties", ownProperties),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getProperties(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getPropertiesParams params;
    getPropertiesParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;

    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::Runtime::PropertyDescriptor>> out_result;
    Maybe<protocol::Array<protocol::Runtime::InternalPropertyDescriptor>> out_internalProperties;
    Maybe<protocol::Array<protocol::Runtime::PrivatePropertyDescriptor>> out_privateProperties;
    Maybe<protocol::Runtime::ExceptionDetails> out_exceptionDetails;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getProperties(params.objectId, std::move(params.ownProperties), std::move(params.accessorPropertiesOnly), std::move(params.generatePreview), &out_result, &out_internalProperties, &out_privateProperties, &out_exceptionDetails);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.getProperties"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("result"), out_result);
          serializer.AddField(v8_crdtp::MakeSpan("internalProperties"), out_internalProperties);
          serializer.AddField(v8_crdtp::MakeSpan("privateProperties"), out_privateProperties);
          serializer.AddField(v8_crdtp::MakeSpan("exceptionDetails"), out_exceptionDetails);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct globalLexicalScopeNamesParams : public v8_crdtp::DeserializableProtocolObject<globalLexicalScopeNamesParams> {
    Maybe<int> executionContextId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(globalLexicalScopeNamesParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("executionContextId", executionContextId),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::globalLexicalScopeNames(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    globalLexicalScopeNamesParams params;
    globalLexicalScopeNamesParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;

    // Declare output parameters.
    std::unique_ptr<protocol::Array<String>> out_names;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->globalLexicalScopeNames(std::move(params.executionContextId), &out_names);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.globalLexicalScopeNames"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("names"), out_names);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct queryObjectsParams : public v8_crdtp::DeserializableProtocolObject<queryObjectsParams> {
    String prototypeObjectId;
    Maybe<String> objectGroup;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(queryObjectsParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("objectGroup", objectGroup),
    V8_CRDTP_DESERIALIZE_FIELD("prototypeObjectId", prototypeObjectId),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::queryObjects(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    queryObjectsParams params;
    queryObjectsParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;

    // Declare output parameters.
    std::unique_ptr<protocol::Runtime::RemoteObject> out_objects;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->queryObjects(params.prototypeObjectId, std::move(params.objectGroup), &out_objects);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.queryObjects"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<v8_crdtp::Serializable> result;
        if (response.IsSuccess()) {
          v8_crdtp::ObjectSerializer serializer;
          serializer.AddField(v8_crdtp::MakeSpan("objects"), out_objects);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct releaseObjectParams : public v8_crdtp::DeserializableProtocolObject<releaseObjectParams> {
    String objectId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(releaseObjectParams)
    V8_CRDTP_DESERIALIZE_FIELD("objectId", objectId),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::releaseObject(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    releaseObjectParams params;
    releaseObjectParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->releaseObject(params.objectId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.releaseObject"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct releaseObjectGroupParams : public v8_crdtp::DeserializableProtocolObject<releaseObjectGroupParams> {
    String objectGroup;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(releaseObjectGroupParams)
    V8_CRDTP_DESERIALIZE_FIELD("objectGroup", objectGroup),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::releaseObjectGroup(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    releaseObjectGroupParams params;
    releaseObjectGroupParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->releaseObjectGroup(params.objectGroup);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.releaseObjectGroup"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::runIfWaitingForDebugger(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->runIfWaitingForDebugger();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.runIfWaitingForDebugger"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

class RunScriptCallbackImpl : public Backend::RunScriptCallback, public DomainDispatcher::Callback {
public:
    RunScriptCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, v8_crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
v8_crdtp::SpanFrom("Runtime.runScript"), message) { }

    void sendSuccess(std::unique_ptr<protocol::Runtime::RemoteObject> result, Maybe<protocol::Runtime::ExceptionDetails> exceptionDetails) override
    {
        v8_crdtp::ObjectSerializer serializer;
        serializer.AddField(v8_crdtp::MakeSpan("result"), result);
        serializer.AddField(v8_crdtp::MakeSpan("exceptionDetails"), exceptionDetails);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct runScriptParams : public v8_crdtp::DeserializableProtocolObject<runScriptParams> {
    String scriptId;
    Maybe<int> executionContextId;
    Maybe<String> objectGroup;
    Maybe<bool> silent;
    Maybe<bool> includeCommandLineAPI;
    Maybe<bool> returnByValue;
    Maybe<bool> generatePreview;
    Maybe<bool> awaitPromise;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(runScriptParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("awaitPromise", awaitPromise),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("executionContextId", executionContextId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("generatePreview", generatePreview),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("includeCommandLineAPI", includeCommandLineAPI),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("objectGroup", objectGroup),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("returnByValue", returnByValue),
    V8_CRDTP_DESERIALIZE_FIELD("scriptId", scriptId),
    V8_CRDTP_DESERIALIZE_FIELD_OPT("silent", silent),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::runScript(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    runScriptParams params;
    runScriptParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    m_backend->runScript(params.scriptId, std::move(params.executionContextId), std::move(params.objectGroup), std::move(params.silent), std::move(params.includeCommandLineAPI), std::move(params.returnByValue), std::move(params.generatePreview), std::move(params.awaitPromise), std::make_unique<RunScriptCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {

struct setCustomObjectFormatterEnabledParams : public v8_crdtp::DeserializableProtocolObject<setCustomObjectFormatterEnabledParams> {
    bool enabled;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(setCustomObjectFormatterEnabledParams)
    V8_CRDTP_DESERIALIZE_FIELD("enabled", enabled),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setCustomObjectFormatterEnabled(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setCustomObjectFormatterEnabledParams params;
    setCustomObjectFormatterEnabledParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setCustomObjectFormatterEnabled(params.enabled);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.setCustomObjectFormatterEnabled"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setMaxCallStackSizeToCaptureParams : public v8_crdtp::DeserializableProtocolObject<setMaxCallStackSizeToCaptureParams> {
    int size;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(setMaxCallStackSizeToCaptureParams)
    V8_CRDTP_DESERIALIZE_FIELD("size", size),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setMaxCallStackSizeToCapture(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setMaxCallStackSizeToCaptureParams params;
    setMaxCallStackSizeToCaptureParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setMaxCallStackSizeToCapture(params.size);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.setMaxCallStackSizeToCapture"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

class TerminateExecutionCallbackImpl : public Backend::TerminateExecutionCallback, public DomainDispatcher::Callback {
public:
    TerminateExecutionCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, v8_crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
v8_crdtp::SpanFrom("Runtime.terminateExecution"), message) { }

    void sendSuccess() override
    {
        v8_crdtp::ObjectSerializer serializer;
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {


}  // namespace

void DomainDispatcherImpl::terminateExecution(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    m_backend->terminateExecution(std::make_unique<TerminateExecutionCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {

struct addBindingParams : public v8_crdtp::DeserializableProtocolObject<addBindingParams> {
    String name;
    Maybe<int> executionContextId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(addBindingParams)
    V8_CRDTP_DESERIALIZE_FIELD_OPT("executionContextId", executionContextId),
    V8_CRDTP_DESERIALIZE_FIELD("name", name),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::addBinding(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    addBindingParams params;
    addBindingParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->addBinding(params.name, std::move(params.executionContextId));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.addBinding"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct removeBindingParams : public v8_crdtp::DeserializableProtocolObject<removeBindingParams> {
    String name;
    DECLARE_DESERIALIZATION_SUPPORT();
};

V8_CRDTP_BEGIN_DESERIALIZER(removeBindingParams)
    V8_CRDTP_DESERIALIZE_FIELD("name", name),
V8_CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::removeBinding(const v8_crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = v8_crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    removeBindingParams params;
    removeBindingParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->removeBinding(params.name);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), v8_crdtp::SpanFrom("Runtime.removeBinding"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<v8_crdtp::span<uint8_t>, v8_crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<v8_crdtp::span<uint8_t>, v8_crdtp::span<uint8_t>>>{
          { v8_crdtp::SpanFrom("Runtime.setAsyncCallStackDepth"), v8_crdtp::SpanFrom("Debugger.setAsyncCallStackDepth") },
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(v8_crdtp::SpanFrom("Runtime"), SortedRedirects(), std::move(dispatcher));
}

} // Runtime
} // namespace v8_inspector
} // namespace protocol
