// cc/mojom/ui_resource_id.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CC_MOJOM_UI_RESOURCE_ID_MOJOM_H_
#define CC_MOJOM_UI_RESOURCE_ID_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "cc/mojom/ui_resource_id.mojom-features.h"  // IWYU pragma: export
#include "cc/mojom/ui_resource_id.mojom-shared.h"  // IWYU pragma: export
#include "cc/mojom/ui_resource_id.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "cc/mojom/ui_resource_id_mojom_traits.h"




namespace cc::mojom {





class  UIResourceId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UIResourceId, T>::value>;
  using DataView = UIResourceIdDataView;
  using Data_ = internal::UIResourceId_Data;

  template <typename... Args>
  static UIResourceIdPtr New(Args&&... args) {
    return UIResourceIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UIResourceIdPtr From(const U& u) {
    return mojo::TypeConverter<UIResourceIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UIResourceId>::Convert(*this);
  }


  UIResourceId();

  explicit UIResourceId(
      int32_t value);


  ~UIResourceId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UIResourceIdPtr>
  UIResourceIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UIResourceId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UIResourceId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UIResourceId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UIResourceId::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UIResourceId::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UIResourceId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UIResourceId_UnserializedMessageContext<
            UserType, UIResourceId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UIResourceId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UIResourceId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UIResourceId_UnserializedMessageContext<
            UserType, UIResourceId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UIResourceId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UIResourceId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UIResourceId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UIResourceId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UIResourceId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
UIResourceIdPtr UIResourceId::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, UIResourceId::EnableIfSame<T>*>
bool UIResourceId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, UIResourceId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}


}  // cc::mojom

namespace mojo {


template <>
struct  StructTraits<::cc::mojom::UIResourceId::DataView,
                                         ::cc::mojom::UIResourceIdPtr> {
  static bool IsNull(const ::cc::mojom::UIResourceIdPtr& input) { return !input; }
  static void SetToNull(::cc::mojom::UIResourceIdPtr* output) { output->reset(); }

  static decltype(::cc::mojom::UIResourceId::value) value(
      const ::cc::mojom::UIResourceIdPtr& input) {
    return input->value;
  }

  static bool Read(::cc::mojom::UIResourceId::DataView input, ::cc::mojom::UIResourceIdPtr* output);
};

}  // namespace mojo

#endif  // CC_MOJOM_UI_RESOURCE_ID_MOJOM_H_