// components/attribution_reporting/data_host.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/attribution_reporting/data_host.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/attribution_reporting/data_host.mojom-params-data.h"
#include "components/attribution_reporting/data_host.mojom-shared-message-ids.h"

#include "components/attribution_reporting/data_host.mojom-blink-import-headers.h"
#include "components/attribution_reporting/data_host.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace attribution_reporting::mojom::blink {
// The declaration includes the definition on other builds.

DataHost::IPCStableHashFunction DataHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DataHost>(message.name())) {
    case messages::DataHost::kSourceDataAvailable: {
      return &DataHost::SourceDataAvailable_Sym::IPCStableHash;
    }
    case messages::DataHost::kTriggerDataAvailable: {
      return &DataHost::TriggerDataAvailable_Sym::IPCStableHash;
    }
    case messages::DataHost::kOsSourceDataAvailable: {
      return &DataHost::OsSourceDataAvailable_Sym::IPCStableHash;
    }
    case messages::DataHost::kOsTriggerDataAvailable: {
      return &DataHost::OsTriggerDataAvailable_Sym::IPCStableHash;
    }
    case messages::DataHost::kReportRegistrationHeaderError: {
      return &DataHost::ReportRegistrationHeaderError_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DataHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DataHost>(message.name())) {
      case messages::DataHost::kSourceDataAvailable:
            return "Receive attribution_reporting::mojom::DataHost::SourceDataAvailable";
      case messages::DataHost::kTriggerDataAvailable:
            return "Receive attribution_reporting::mojom::DataHost::TriggerDataAvailable";
      case messages::DataHost::kOsSourceDataAvailable:
            return "Receive attribution_reporting::mojom::DataHost::OsSourceDataAvailable";
      case messages::DataHost::kOsTriggerDataAvailable:
            return "Receive attribution_reporting::mojom::DataHost::OsTriggerDataAvailable";
      case messages::DataHost::kReportRegistrationHeaderError:
            return "Receive attribution_reporting::mojom::DataHost::ReportRegistrationHeaderError";
    }
  } else {
    switch (static_cast<messages::DataHost>(message.name())) {
      case messages::DataHost::kSourceDataAvailable:
            return "Receive reply attribution_reporting::mojom::DataHost::SourceDataAvailable";
      case messages::DataHost::kTriggerDataAvailable:
            return "Receive reply attribution_reporting::mojom::DataHost::TriggerDataAvailable";
      case messages::DataHost::kOsSourceDataAvailable:
            return "Receive reply attribution_reporting::mojom::DataHost::OsSourceDataAvailable";
      case messages::DataHost::kOsTriggerDataAvailable:
            return "Receive reply attribution_reporting::mojom::DataHost::OsTriggerDataAvailable";
      case messages::DataHost::kReportRegistrationHeaderError:
            return "Receive reply attribution_reporting::mojom::DataHost::ReportRegistrationHeaderError";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DataHost::SourceDataAvailable_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc22d05c7;  // IPCStableHash for attribution_reporting::mojom::DataHost::SourceDataAvailable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DataHost::TriggerDataAvailable_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc7d251be;  // IPCStableHash for attribution_reporting::mojom::DataHost::TriggerDataAvailable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DataHost::OsSourceDataAvailable_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa9f26221;  // IPCStableHash for attribution_reporting::mojom::DataHost::OsSourceDataAvailable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DataHost::OsTriggerDataAvailable_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd76c94da;  // IPCStableHash for attribution_reporting::mojom::DataHost::OsTriggerDataAvailable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DataHost::ReportRegistrationHeaderError_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xed47942b;  // IPCStableHash for attribution_reporting::mojom::DataHost::ReportRegistrationHeaderError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DataHostProxy::DataHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DataHostProxy::SourceDataAvailable(
    ::attribution_reporting::SuitableOrigin in_reporting_origin, ::attribution_reporting::SourceRegistration in_data, bool in_was_fetched_via_service_worker) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send attribution_reporting::mojom::DataHost::SourceDataAvailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reporting_origin"), in_reporting_origin,
                        "<value of type ::attribution_reporting::SuitableOrigin>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::attribution_reporting::SourceRegistration>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("was_fetched_via_service_worker"), in_was_fetched_via_service_worker,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DataHost::kSourceDataAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::attribution_reporting::mojom::internal::DataHost_SourceDataAvailable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->reporting_origin)::BaseType> reporting_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::attribution_reporting::mojom::SuitableOriginDataView>(
    in_reporting_origin,
    reporting_origin_fragment);

  params->reporting_origin.Set(
      reporting_origin_fragment.is_null() ? nullptr : reporting_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->reporting_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null reporting_origin in DataHost.SourceDataAvailable request");
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::attribution_reporting::mojom::SourceRegistrationDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in DataHost.SourceDataAvailable request");

  params->was_fetched_via_service_worker = in_was_fetched_via_service_worker;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DataHost::Name_);
  message.set_method_name("SourceDataAvailable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DataHostProxy::TriggerDataAvailable(
    ::attribution_reporting::SuitableOrigin in_reporting_origin, ::attribution_reporting::TriggerRegistration in_data, bool in_was_fetched_via_service_worker) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send attribution_reporting::mojom::DataHost::TriggerDataAvailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reporting_origin"), in_reporting_origin,
                        "<value of type ::attribution_reporting::SuitableOrigin>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::attribution_reporting::TriggerRegistration>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("was_fetched_via_service_worker"), in_was_fetched_via_service_worker,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DataHost::kTriggerDataAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::attribution_reporting::mojom::internal::DataHost_TriggerDataAvailable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->reporting_origin)::BaseType> reporting_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::attribution_reporting::mojom::SuitableOriginDataView>(
    in_reporting_origin,
    reporting_origin_fragment);

  params->reporting_origin.Set(
      reporting_origin_fragment.is_null() ? nullptr : reporting_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->reporting_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null reporting_origin in DataHost.TriggerDataAvailable request");
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::attribution_reporting::mojom::TriggerRegistrationDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in DataHost.TriggerDataAvailable request");

  params->was_fetched_via_service_worker = in_was_fetched_via_service_worker;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DataHost::Name_);
  message.set_method_name("TriggerDataAvailable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DataHostProxy::OsSourceDataAvailable(
    ::std::vector<::attribution_reporting::OsRegistrationItem> in_registration, bool in_was_fetched_via_service_worker) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send attribution_reporting::mojom::DataHost::OsSourceDataAvailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration"), in_registration,
                        "<value of type ::std::vector<::attribution_reporting::OsRegistrationItem>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("was_fetched_via_service_worker"), in_was_fetched_via_service_worker,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DataHost::kOsSourceDataAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::attribution_reporting::mojom::internal::DataHost_OsSourceDataAvailable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->registration)::BaseType> registration_fragment(
          params.message());
  
  mojo::internal::Serialize<::attribution_reporting::mojom::OsRegistrationDataView>(
    in_registration,
    registration_fragment);

  params->registration.Set(
      registration_fragment.is_null() ? nullptr : registration_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->registration.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null registration in DataHost.OsSourceDataAvailable request");

  params->was_fetched_via_service_worker = in_was_fetched_via_service_worker;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DataHost::Name_);
  message.set_method_name("OsSourceDataAvailable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DataHostProxy::OsTriggerDataAvailable(
    ::std::vector<::attribution_reporting::OsRegistrationItem> in_registration, bool in_was_fetched_via_service_worker) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send attribution_reporting::mojom::DataHost::OsTriggerDataAvailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration"), in_registration,
                        "<value of type ::std::vector<::attribution_reporting::OsRegistrationItem>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("was_fetched_via_service_worker"), in_was_fetched_via_service_worker,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DataHost::kOsTriggerDataAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::attribution_reporting::mojom::internal::DataHost_OsTriggerDataAvailable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->registration)::BaseType> registration_fragment(
          params.message());
  
  mojo::internal::Serialize<::attribution_reporting::mojom::OsRegistrationDataView>(
    in_registration,
    registration_fragment);

  params->registration.Set(
      registration_fragment.is_null() ? nullptr : registration_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->registration.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null registration in DataHost.OsTriggerDataAvailable request");

  params->was_fetched_via_service_worker = in_was_fetched_via_service_worker;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DataHost::Name_);
  message.set_method_name("OsTriggerDataAvailable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DataHostProxy::ReportRegistrationHeaderError(
    ::attribution_reporting::SuitableOrigin in_reporting_origin, ::attribution_reporting::RegistrationHeaderError in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send attribution_reporting::mojom::DataHost::ReportRegistrationHeaderError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reporting_origin"), in_reporting_origin,
                        "<value of type ::attribution_reporting::SuitableOrigin>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::attribution_reporting::RegistrationHeaderError>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DataHost::kReportRegistrationHeaderError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::attribution_reporting::mojom::internal::DataHost_ReportRegistrationHeaderError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->reporting_origin)::BaseType> reporting_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::attribution_reporting::mojom::SuitableOriginDataView>(
    in_reporting_origin,
    reporting_origin_fragment);

  params->reporting_origin.Set(
      reporting_origin_fragment.is_null() ? nullptr : reporting_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->reporting_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null reporting_origin in DataHost.ReportRegistrationHeaderError request");
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<::attribution_reporting::mojom::RegistrationHeaderErrorDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error in DataHost.ReportRegistrationHeaderError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DataHost::Name_);
  message.set_method_name("ReportRegistrationHeaderError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DataHostStubDispatch::Accept(
    DataHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DataHost>(message->header()->name)) {
    case messages::DataHost::kSourceDataAvailable: {
      DCHECK(message->is_serialized());
      internal::DataHost_SourceDataAvailable_Params_Data* params =
          reinterpret_cast<internal::DataHost_SourceDataAvailable_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DataHost.0
      bool success = true;
      ::attribution_reporting::SuitableOrigin p_reporting_origin{mojo::internal::DefaultConstructTag()};
      ::attribution_reporting::SourceRegistration p_data{mojo::internal::DefaultConstructTag()};
      bool p_was_fetched_via_service_worker{};
      DataHost_SourceDataAvailable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReportingOrigin(&p_reporting_origin))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success)
        p_was_fetched_via_service_worker = input_data_view.was_fetched_via_service_worker();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DataHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SourceDataAvailable(        
        std::move(p_reporting_origin), 
        std::move(p_data), 
        std::move(p_was_fetched_via_service_worker));
      return true;
    }
    case messages::DataHost::kTriggerDataAvailable: {
      DCHECK(message->is_serialized());
      internal::DataHost_TriggerDataAvailable_Params_Data* params =
          reinterpret_cast<internal::DataHost_TriggerDataAvailable_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DataHost.1
      bool success = true;
      ::attribution_reporting::SuitableOrigin p_reporting_origin{mojo::internal::DefaultConstructTag()};
      ::attribution_reporting::TriggerRegistration p_data{};
      bool p_was_fetched_via_service_worker{};
      DataHost_TriggerDataAvailable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReportingOrigin(&p_reporting_origin))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success)
        p_was_fetched_via_service_worker = input_data_view.was_fetched_via_service_worker();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DataHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TriggerDataAvailable(        
        std::move(p_reporting_origin), 
        std::move(p_data), 
        std::move(p_was_fetched_via_service_worker));
      return true;
    }
    case messages::DataHost::kOsSourceDataAvailable: {
      DCHECK(message->is_serialized());
      internal::DataHost_OsSourceDataAvailable_Params_Data* params =
          reinterpret_cast<internal::DataHost_OsSourceDataAvailable_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DataHost.2
      bool success = true;
      ::std::vector<::attribution_reporting::OsRegistrationItem> p_registration{};
      bool p_was_fetched_via_service_worker{};
      DataHost_OsSourceDataAvailable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegistration(&p_registration))
        success = false;
      if (success)
        p_was_fetched_via_service_worker = input_data_view.was_fetched_via_service_worker();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DataHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OsSourceDataAvailable(        
        std::move(p_registration), 
        std::move(p_was_fetched_via_service_worker));
      return true;
    }
    case messages::DataHost::kOsTriggerDataAvailable: {
      DCHECK(message->is_serialized());
      internal::DataHost_OsTriggerDataAvailable_Params_Data* params =
          reinterpret_cast<internal::DataHost_OsTriggerDataAvailable_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DataHost.3
      bool success = true;
      ::std::vector<::attribution_reporting::OsRegistrationItem> p_registration{};
      bool p_was_fetched_via_service_worker{};
      DataHost_OsTriggerDataAvailable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegistration(&p_registration))
        success = false;
      if (success)
        p_was_fetched_via_service_worker = input_data_view.was_fetched_via_service_worker();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DataHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OsTriggerDataAvailable(        
        std::move(p_registration), 
        std::move(p_was_fetched_via_service_worker));
      return true;
    }
    case messages::DataHost::kReportRegistrationHeaderError: {
      DCHECK(message->is_serialized());
      internal::DataHost_ReportRegistrationHeaderError_Params_Data* params =
          reinterpret_cast<internal::DataHost_ReportRegistrationHeaderError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DataHost.4
      bool success = true;
      ::attribution_reporting::SuitableOrigin p_reporting_origin{mojo::internal::DefaultConstructTag()};
      ::attribution_reporting::RegistrationHeaderError p_error{};
      DataHost_ReportRegistrationHeaderError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReportingOrigin(&p_reporting_origin))
        success = false;
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DataHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportRegistrationHeaderError(        
        std::move(p_reporting_origin), 
        std::move(p_error));
      return true;
    }
  }
  return false;
}

// static
bool DataHostStubDispatch::AcceptWithResponder(
    DataHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DataHost>(message->header()->name)) {
    case messages::DataHost::kSourceDataAvailable: {
      break;
    }
    case messages::DataHost::kTriggerDataAvailable: {
      break;
    }
    case messages::DataHost::kOsSourceDataAvailable: {
      break;
    }
    case messages::DataHost::kOsTriggerDataAvailable: {
      break;
    }
    case messages::DataHost::kReportRegistrationHeaderError: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDataHostValidationInfo[] = {
    {base::to_underlying(messages::DataHost::kSourceDataAvailable),
     { &internal::DataHost_SourceDataAvailable_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DataHost::kTriggerDataAvailable),
     { &internal::DataHost_TriggerDataAvailable_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DataHost::kOsSourceDataAvailable),
     { &internal::DataHost_OsSourceDataAvailable_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DataHost::kOsTriggerDataAvailable),
     { &internal::DataHost_OsTriggerDataAvailable_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DataHost::kReportRegistrationHeaderError),
     { &internal::DataHost_ReportRegistrationHeaderError_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DataHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::attribution_reporting::mojom::blink::DataHost::Name_,
    kDataHostValidationInfo);
}



}  // attribution_reporting::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace attribution_reporting::mojom::blink {


void DataHostInterceptorForTesting::SourceDataAvailable(::attribution_reporting::SuitableOrigin reporting_origin, ::attribution_reporting::SourceRegistration data, bool was_fetched_via_service_worker) {
  GetForwardingInterface()->SourceDataAvailable(
    std::move(reporting_origin)
    , 
    std::move(data)
    , 
    std::move(was_fetched_via_service_worker)
    );
}
void DataHostInterceptorForTesting::TriggerDataAvailable(::attribution_reporting::SuitableOrigin reporting_origin, ::attribution_reporting::TriggerRegistration data, bool was_fetched_via_service_worker) {
  GetForwardingInterface()->TriggerDataAvailable(
    std::move(reporting_origin)
    , 
    std::move(data)
    , 
    std::move(was_fetched_via_service_worker)
    );
}
void DataHostInterceptorForTesting::OsSourceDataAvailable(::std::vector<::attribution_reporting::OsRegistrationItem> registration, bool was_fetched_via_service_worker) {
  GetForwardingInterface()->OsSourceDataAvailable(
    std::move(registration)
    , 
    std::move(was_fetched_via_service_worker)
    );
}
void DataHostInterceptorForTesting::OsTriggerDataAvailable(::std::vector<::attribution_reporting::OsRegistrationItem> registration, bool was_fetched_via_service_worker) {
  GetForwardingInterface()->OsTriggerDataAvailable(
    std::move(registration)
    , 
    std::move(was_fetched_via_service_worker)
    );
}
void DataHostInterceptorForTesting::ReportRegistrationHeaderError(::attribution_reporting::SuitableOrigin reporting_origin, ::attribution_reporting::RegistrationHeaderError error) {
  GetForwardingInterface()->ReportRegistrationHeaderError(
    std::move(reporting_origin)
    , 
    std::move(error)
    );
}
DataHostAsyncWaiter::DataHostAsyncWaiter(
    DataHost* proxy) : proxy_(proxy) {}

DataHostAsyncWaiter::~DataHostAsyncWaiter() = default;







}  // attribution_reporting::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif